// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListMeshesOutput {
    /// <p>The list of existing service meshes.</p>
    pub meshes: std::option::Option<std::vec::Vec<crate::model::MeshRef>>,
    /// <p>The <code>nextToken</code> value to include in a future <code>ListMeshes</code> request.
    /// When the results of a <code>ListMeshes</code> request exceed <code>limit</code>, you can
    /// use this value to retrieve the next page of results. This value is <code>null</code> when
    /// there are no more results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListMeshesOutput {
    /// <p>The list of existing service meshes.</p>
    pub fn meshes(&self) -> std::option::Option<&[crate::model::MeshRef]> {
        self.meshes.as_deref()
    }
    /// <p>The <code>nextToken</code> value to include in a future <code>ListMeshes</code> request.
    /// When the results of a <code>ListMeshes</code> request exceed <code>limit</code>, you can
    /// use this value to retrieve the next page of results. This value is <code>null</code> when
    /// there are no more results to return.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListMeshesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListMeshesOutput");
        formatter.field("meshes", &self.meshes);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListMeshesOutput`](crate::output::ListMeshesOutput)
pub mod list_meshes_output {
    /// A builder for [`ListMeshesOutput`](crate::output::ListMeshesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) meshes: std::option::Option<std::vec::Vec<crate::model::MeshRef>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `meshes`.
        ///
        /// To override the contents of this collection use [`set_meshes`](Self::set_meshes).
        ///
        /// <p>The list of existing service meshes.</p>
        pub fn meshes(mut self, input: impl Into<crate::model::MeshRef>) -> Self {
            let mut v = self.meshes.unwrap_or_default();
            v.push(input.into());
            self.meshes = Some(v);
            self
        }
        /// <p>The list of existing service meshes.</p>
        pub fn set_meshes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MeshRef>>,
        ) -> Self {
            self.meshes = input;
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future <code>ListMeshes</code> request.
        /// When the results of a <code>ListMeshes</code> request exceed <code>limit</code>, you can
        /// use this value to retrieve the next page of results. This value is <code>null</code> when
        /// there are no more results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future <code>ListMeshes</code> request.
        /// When the results of a <code>ListMeshes</code> request exceed <code>limit</code>, you can
        /// use this value to retrieve the next page of results. This value is <code>null</code> when
        /// there are no more results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListMeshesOutput`](crate::output::ListMeshesOutput)
        pub fn build(self) -> crate::output::ListMeshesOutput {
            crate::output::ListMeshesOutput {
                meshes: self.meshes,
                next_token: self.next_token,
            }
        }
    }
}
impl ListMeshesOutput {
    /// Creates a new builder-style object to manufacture [`ListMeshesOutput`](crate::output::ListMeshesOutput)
    pub fn builder() -> crate::output::list_meshes_output::Builder {
        crate::output::list_meshes_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateMeshOutput {
    /// <p>The full description of your service mesh following the create call.</p>
    pub mesh: std::option::Option<crate::model::MeshData>,
}
impl CreateMeshOutput {
    /// <p>The full description of your service mesh following the create call.</p>
    pub fn mesh(&self) -> std::option::Option<&crate::model::MeshData> {
        self.mesh.as_ref()
    }
}
impl std::fmt::Debug for CreateMeshOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateMeshOutput");
        formatter.field("mesh", &self.mesh);
        formatter.finish()
    }
}
/// See [`CreateMeshOutput`](crate::output::CreateMeshOutput)
pub mod create_mesh_output {
    /// A builder for [`CreateMeshOutput`](crate::output::CreateMeshOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mesh: std::option::Option<crate::model::MeshData>,
    }
    impl Builder {
        /// <p>The full description of your service mesh following the create call.</p>
        pub fn mesh(mut self, input: crate::model::MeshData) -> Self {
            self.mesh = Some(input);
            self
        }
        /// <p>The full description of your service mesh following the create call.</p>
        pub fn set_mesh(mut self, input: std::option::Option<crate::model::MeshData>) -> Self {
            self.mesh = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateMeshOutput`](crate::output::CreateMeshOutput)
        pub fn build(self) -> crate::output::CreateMeshOutput {
            crate::output::CreateMeshOutput { mesh: self.mesh }
        }
    }
}
impl CreateMeshOutput {
    /// Creates a new builder-style object to manufacture [`CreateMeshOutput`](crate::output::CreateMeshOutput)
    pub fn builder() -> crate::output::create_mesh_output::Builder {
        crate::output::create_mesh_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteMeshOutput {
    /// <p>The service mesh that was deleted.</p>
    pub mesh: std::option::Option<crate::model::MeshData>,
}
impl DeleteMeshOutput {
    /// <p>The service mesh that was deleted.</p>
    pub fn mesh(&self) -> std::option::Option<&crate::model::MeshData> {
        self.mesh.as_ref()
    }
}
impl std::fmt::Debug for DeleteMeshOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteMeshOutput");
        formatter.field("mesh", &self.mesh);
        formatter.finish()
    }
}
/// See [`DeleteMeshOutput`](crate::output::DeleteMeshOutput)
pub mod delete_mesh_output {
    /// A builder for [`DeleteMeshOutput`](crate::output::DeleteMeshOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mesh: std::option::Option<crate::model::MeshData>,
    }
    impl Builder {
        /// <p>The service mesh that was deleted.</p>
        pub fn mesh(mut self, input: crate::model::MeshData) -> Self {
            self.mesh = Some(input);
            self
        }
        /// <p>The service mesh that was deleted.</p>
        pub fn set_mesh(mut self, input: std::option::Option<crate::model::MeshData>) -> Self {
            self.mesh = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteMeshOutput`](crate::output::DeleteMeshOutput)
        pub fn build(self) -> crate::output::DeleteMeshOutput {
            crate::output::DeleteMeshOutput { mesh: self.mesh }
        }
    }
}
impl DeleteMeshOutput {
    /// Creates a new builder-style object to manufacture [`DeleteMeshOutput`](crate::output::DeleteMeshOutput)
    pub fn builder() -> crate::output::delete_mesh_output::Builder {
        crate::output::delete_mesh_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateMeshOutput {
    /// <p>An object that represents a service mesh returned by a describe operation.</p>
    pub mesh: std::option::Option<crate::model::MeshData>,
}
impl UpdateMeshOutput {
    /// <p>An object that represents a service mesh returned by a describe operation.</p>
    pub fn mesh(&self) -> std::option::Option<&crate::model::MeshData> {
        self.mesh.as_ref()
    }
}
impl std::fmt::Debug for UpdateMeshOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateMeshOutput");
        formatter.field("mesh", &self.mesh);
        formatter.finish()
    }
}
/// See [`UpdateMeshOutput`](crate::output::UpdateMeshOutput)
pub mod update_mesh_output {
    /// A builder for [`UpdateMeshOutput`](crate::output::UpdateMeshOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mesh: std::option::Option<crate::model::MeshData>,
    }
    impl Builder {
        /// <p>An object that represents a service mesh returned by a describe operation.</p>
        pub fn mesh(mut self, input: crate::model::MeshData) -> Self {
            self.mesh = Some(input);
            self
        }
        /// <p>An object that represents a service mesh returned by a describe operation.</p>
        pub fn set_mesh(mut self, input: std::option::Option<crate::model::MeshData>) -> Self {
            self.mesh = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateMeshOutput`](crate::output::UpdateMeshOutput)
        pub fn build(self) -> crate::output::UpdateMeshOutput {
            crate::output::UpdateMeshOutput { mesh: self.mesh }
        }
    }
}
impl UpdateMeshOutput {
    /// Creates a new builder-style object to manufacture [`UpdateMeshOutput`](crate::output::UpdateMeshOutput)
    pub fn builder() -> crate::output::update_mesh_output::Builder {
        crate::output::update_mesh_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeMeshOutput {
    /// <p>The full description of your service mesh.</p>
    pub mesh: std::option::Option<crate::model::MeshData>,
}
impl DescribeMeshOutput {
    /// <p>The full description of your service mesh.</p>
    pub fn mesh(&self) -> std::option::Option<&crate::model::MeshData> {
        self.mesh.as_ref()
    }
}
impl std::fmt::Debug for DescribeMeshOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeMeshOutput");
        formatter.field("mesh", &self.mesh);
        formatter.finish()
    }
}
/// See [`DescribeMeshOutput`](crate::output::DescribeMeshOutput)
pub mod describe_mesh_output {
    /// A builder for [`DescribeMeshOutput`](crate::output::DescribeMeshOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mesh: std::option::Option<crate::model::MeshData>,
    }
    impl Builder {
        /// <p>The full description of your service mesh.</p>
        pub fn mesh(mut self, input: crate::model::MeshData) -> Self {
            self.mesh = Some(input);
            self
        }
        /// <p>The full description of your service mesh.</p>
        pub fn set_mesh(mut self, input: std::option::Option<crate::model::MeshData>) -> Self {
            self.mesh = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeMeshOutput`](crate::output::DescribeMeshOutput)
        pub fn build(self) -> crate::output::DescribeMeshOutput {
            crate::output::DescribeMeshOutput { mesh: self.mesh }
        }
    }
}
impl DescribeMeshOutput {
    /// Creates a new builder-style object to manufacture [`DescribeMeshOutput`](crate::output::DescribeMeshOutput)
    pub fn builder() -> crate::output::describe_mesh_output::Builder {
        crate::output::describe_mesh_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListVirtualServicesOutput {
    /// <p>The list of existing virtual services for the specified service mesh.</p>
    pub virtual_services: std::option::Option<std::vec::Vec<crate::model::VirtualServiceRef>>,
    /// <p>The <code>nextToken</code> value to include in a future <code>ListVirtualServices</code>
    /// request. When the results of a <code>ListVirtualServices</code> request exceed
    /// <code>limit</code>, you can use this value to retrieve the next page of results. This
    /// value is <code>null</code> when there are no more results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListVirtualServicesOutput {
    /// <p>The list of existing virtual services for the specified service mesh.</p>
    pub fn virtual_services(&self) -> std::option::Option<&[crate::model::VirtualServiceRef]> {
        self.virtual_services.as_deref()
    }
    /// <p>The <code>nextToken</code> value to include in a future <code>ListVirtualServices</code>
    /// request. When the results of a <code>ListVirtualServices</code> request exceed
    /// <code>limit</code>, you can use this value to retrieve the next page of results. This
    /// value is <code>null</code> when there are no more results to return.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListVirtualServicesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListVirtualServicesOutput");
        formatter.field("virtual_services", &self.virtual_services);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListVirtualServicesOutput`](crate::output::ListVirtualServicesOutput)
pub mod list_virtual_services_output {
    /// A builder for [`ListVirtualServicesOutput`](crate::output::ListVirtualServicesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_services:
            std::option::Option<std::vec::Vec<crate::model::VirtualServiceRef>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `virtual_services`.
        ///
        /// To override the contents of this collection use [`set_virtual_services`](Self::set_virtual_services).
        ///
        /// <p>The list of existing virtual services for the specified service mesh.</p>
        pub fn virtual_services(
            mut self,
            input: impl Into<crate::model::VirtualServiceRef>,
        ) -> Self {
            let mut v = self.virtual_services.unwrap_or_default();
            v.push(input.into());
            self.virtual_services = Some(v);
            self
        }
        /// <p>The list of existing virtual services for the specified service mesh.</p>
        pub fn set_virtual_services(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VirtualServiceRef>>,
        ) -> Self {
            self.virtual_services = input;
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future <code>ListVirtualServices</code>
        /// request. When the results of a <code>ListVirtualServices</code> request exceed
        /// <code>limit</code>, you can use this value to retrieve the next page of results. This
        /// value is <code>null</code> when there are no more results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future <code>ListVirtualServices</code>
        /// request. When the results of a <code>ListVirtualServices</code> request exceed
        /// <code>limit</code>, you can use this value to retrieve the next page of results. This
        /// value is <code>null</code> when there are no more results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListVirtualServicesOutput`](crate::output::ListVirtualServicesOutput)
        pub fn build(self) -> crate::output::ListVirtualServicesOutput {
            crate::output::ListVirtualServicesOutput {
                virtual_services: self.virtual_services,
                next_token: self.next_token,
            }
        }
    }
}
impl ListVirtualServicesOutput {
    /// Creates a new builder-style object to manufacture [`ListVirtualServicesOutput`](crate::output::ListVirtualServicesOutput)
    pub fn builder() -> crate::output::list_virtual_services_output::Builder {
        crate::output::list_virtual_services_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateVirtualServiceOutput {
    /// <p>The full description of your virtual service following the create call.</p>
    pub virtual_service: std::option::Option<crate::model::VirtualServiceData>,
}
impl CreateVirtualServiceOutput {
    /// <p>The full description of your virtual service following the create call.</p>
    pub fn virtual_service(&self) -> std::option::Option<&crate::model::VirtualServiceData> {
        self.virtual_service.as_ref()
    }
}
impl std::fmt::Debug for CreateVirtualServiceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateVirtualServiceOutput");
        formatter.field("virtual_service", &self.virtual_service);
        formatter.finish()
    }
}
/// See [`CreateVirtualServiceOutput`](crate::output::CreateVirtualServiceOutput)
pub mod create_virtual_service_output {
    /// A builder for [`CreateVirtualServiceOutput`](crate::output::CreateVirtualServiceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_service: std::option::Option<crate::model::VirtualServiceData>,
    }
    impl Builder {
        /// <p>The full description of your virtual service following the create call.</p>
        pub fn virtual_service(mut self, input: crate::model::VirtualServiceData) -> Self {
            self.virtual_service = Some(input);
            self
        }
        /// <p>The full description of your virtual service following the create call.</p>
        pub fn set_virtual_service(
            mut self,
            input: std::option::Option<crate::model::VirtualServiceData>,
        ) -> Self {
            self.virtual_service = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateVirtualServiceOutput`](crate::output::CreateVirtualServiceOutput)
        pub fn build(self) -> crate::output::CreateVirtualServiceOutput {
            crate::output::CreateVirtualServiceOutput {
                virtual_service: self.virtual_service,
            }
        }
    }
}
impl CreateVirtualServiceOutput {
    /// Creates a new builder-style object to manufacture [`CreateVirtualServiceOutput`](crate::output::CreateVirtualServiceOutput)
    pub fn builder() -> crate::output::create_virtual_service_output::Builder {
        crate::output::create_virtual_service_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteVirtualServiceOutput {
    /// <p>The virtual service that was deleted.</p>
    pub virtual_service: std::option::Option<crate::model::VirtualServiceData>,
}
impl DeleteVirtualServiceOutput {
    /// <p>The virtual service that was deleted.</p>
    pub fn virtual_service(&self) -> std::option::Option<&crate::model::VirtualServiceData> {
        self.virtual_service.as_ref()
    }
}
impl std::fmt::Debug for DeleteVirtualServiceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteVirtualServiceOutput");
        formatter.field("virtual_service", &self.virtual_service);
        formatter.finish()
    }
}
/// See [`DeleteVirtualServiceOutput`](crate::output::DeleteVirtualServiceOutput)
pub mod delete_virtual_service_output {
    /// A builder for [`DeleteVirtualServiceOutput`](crate::output::DeleteVirtualServiceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_service: std::option::Option<crate::model::VirtualServiceData>,
    }
    impl Builder {
        /// <p>The virtual service that was deleted.</p>
        pub fn virtual_service(mut self, input: crate::model::VirtualServiceData) -> Self {
            self.virtual_service = Some(input);
            self
        }
        /// <p>The virtual service that was deleted.</p>
        pub fn set_virtual_service(
            mut self,
            input: std::option::Option<crate::model::VirtualServiceData>,
        ) -> Self {
            self.virtual_service = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteVirtualServiceOutput`](crate::output::DeleteVirtualServiceOutput)
        pub fn build(self) -> crate::output::DeleteVirtualServiceOutput {
            crate::output::DeleteVirtualServiceOutput {
                virtual_service: self.virtual_service,
            }
        }
    }
}
impl DeleteVirtualServiceOutput {
    /// Creates a new builder-style object to manufacture [`DeleteVirtualServiceOutput`](crate::output::DeleteVirtualServiceOutput)
    pub fn builder() -> crate::output::delete_virtual_service_output::Builder {
        crate::output::delete_virtual_service_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateVirtualServiceOutput {
    /// <p>A full description of the virtual service that was updated.</p>
    pub virtual_service: std::option::Option<crate::model::VirtualServiceData>,
}
impl UpdateVirtualServiceOutput {
    /// <p>A full description of the virtual service that was updated.</p>
    pub fn virtual_service(&self) -> std::option::Option<&crate::model::VirtualServiceData> {
        self.virtual_service.as_ref()
    }
}
impl std::fmt::Debug for UpdateVirtualServiceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateVirtualServiceOutput");
        formatter.field("virtual_service", &self.virtual_service);
        formatter.finish()
    }
}
/// See [`UpdateVirtualServiceOutput`](crate::output::UpdateVirtualServiceOutput)
pub mod update_virtual_service_output {
    /// A builder for [`UpdateVirtualServiceOutput`](crate::output::UpdateVirtualServiceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_service: std::option::Option<crate::model::VirtualServiceData>,
    }
    impl Builder {
        /// <p>A full description of the virtual service that was updated.</p>
        pub fn virtual_service(mut self, input: crate::model::VirtualServiceData) -> Self {
            self.virtual_service = Some(input);
            self
        }
        /// <p>A full description of the virtual service that was updated.</p>
        pub fn set_virtual_service(
            mut self,
            input: std::option::Option<crate::model::VirtualServiceData>,
        ) -> Self {
            self.virtual_service = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateVirtualServiceOutput`](crate::output::UpdateVirtualServiceOutput)
        pub fn build(self) -> crate::output::UpdateVirtualServiceOutput {
            crate::output::UpdateVirtualServiceOutput {
                virtual_service: self.virtual_service,
            }
        }
    }
}
impl UpdateVirtualServiceOutput {
    /// Creates a new builder-style object to manufacture [`UpdateVirtualServiceOutput`](crate::output::UpdateVirtualServiceOutput)
    pub fn builder() -> crate::output::update_virtual_service_output::Builder {
        crate::output::update_virtual_service_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeVirtualServiceOutput {
    /// <p>The full description of your virtual service.</p>
    pub virtual_service: std::option::Option<crate::model::VirtualServiceData>,
}
impl DescribeVirtualServiceOutput {
    /// <p>The full description of your virtual service.</p>
    pub fn virtual_service(&self) -> std::option::Option<&crate::model::VirtualServiceData> {
        self.virtual_service.as_ref()
    }
}
impl std::fmt::Debug for DescribeVirtualServiceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeVirtualServiceOutput");
        formatter.field("virtual_service", &self.virtual_service);
        formatter.finish()
    }
}
/// See [`DescribeVirtualServiceOutput`](crate::output::DescribeVirtualServiceOutput)
pub mod describe_virtual_service_output {
    /// A builder for [`DescribeVirtualServiceOutput`](crate::output::DescribeVirtualServiceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_service: std::option::Option<crate::model::VirtualServiceData>,
    }
    impl Builder {
        /// <p>The full description of your virtual service.</p>
        pub fn virtual_service(mut self, input: crate::model::VirtualServiceData) -> Self {
            self.virtual_service = Some(input);
            self
        }
        /// <p>The full description of your virtual service.</p>
        pub fn set_virtual_service(
            mut self,
            input: std::option::Option<crate::model::VirtualServiceData>,
        ) -> Self {
            self.virtual_service = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeVirtualServiceOutput`](crate::output::DescribeVirtualServiceOutput)
        pub fn build(self) -> crate::output::DescribeVirtualServiceOutput {
            crate::output::DescribeVirtualServiceOutput {
                virtual_service: self.virtual_service,
            }
        }
    }
}
impl DescribeVirtualServiceOutput {
    /// Creates a new builder-style object to manufacture [`DescribeVirtualServiceOutput`](crate::output::DescribeVirtualServiceOutput)
    pub fn builder() -> crate::output::describe_virtual_service_output::Builder {
        crate::output::describe_virtual_service_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListVirtualRoutersOutput {
    /// <p>The list of existing virtual routers for the specified service mesh.</p>
    pub virtual_routers: std::option::Option<std::vec::Vec<crate::model::VirtualRouterRef>>,
    /// <p>The <code>nextToken</code> value to include in a future <code>ListVirtualRouters</code>
    /// request. When the results of a <code>ListVirtualRouters</code> request exceed
    /// <code>limit</code>, you can use this value to retrieve the next page of results. This
    /// value is <code>null</code> when there are no more results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListVirtualRoutersOutput {
    /// <p>The list of existing virtual routers for the specified service mesh.</p>
    pub fn virtual_routers(&self) -> std::option::Option<&[crate::model::VirtualRouterRef]> {
        self.virtual_routers.as_deref()
    }
    /// <p>The <code>nextToken</code> value to include in a future <code>ListVirtualRouters</code>
    /// request. When the results of a <code>ListVirtualRouters</code> request exceed
    /// <code>limit</code>, you can use this value to retrieve the next page of results. This
    /// value is <code>null</code> when there are no more results to return.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListVirtualRoutersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListVirtualRoutersOutput");
        formatter.field("virtual_routers", &self.virtual_routers);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListVirtualRoutersOutput`](crate::output::ListVirtualRoutersOutput)
pub mod list_virtual_routers_output {
    /// A builder for [`ListVirtualRoutersOutput`](crate::output::ListVirtualRoutersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_routers:
            std::option::Option<std::vec::Vec<crate::model::VirtualRouterRef>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `virtual_routers`.
        ///
        /// To override the contents of this collection use [`set_virtual_routers`](Self::set_virtual_routers).
        ///
        /// <p>The list of existing virtual routers for the specified service mesh.</p>
        pub fn virtual_routers(mut self, input: impl Into<crate::model::VirtualRouterRef>) -> Self {
            let mut v = self.virtual_routers.unwrap_or_default();
            v.push(input.into());
            self.virtual_routers = Some(v);
            self
        }
        /// <p>The list of existing virtual routers for the specified service mesh.</p>
        pub fn set_virtual_routers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VirtualRouterRef>>,
        ) -> Self {
            self.virtual_routers = input;
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future <code>ListVirtualRouters</code>
        /// request. When the results of a <code>ListVirtualRouters</code> request exceed
        /// <code>limit</code>, you can use this value to retrieve the next page of results. This
        /// value is <code>null</code> when there are no more results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future <code>ListVirtualRouters</code>
        /// request. When the results of a <code>ListVirtualRouters</code> request exceed
        /// <code>limit</code>, you can use this value to retrieve the next page of results. This
        /// value is <code>null</code> when there are no more results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListVirtualRoutersOutput`](crate::output::ListVirtualRoutersOutput)
        pub fn build(self) -> crate::output::ListVirtualRoutersOutput {
            crate::output::ListVirtualRoutersOutput {
                virtual_routers: self.virtual_routers,
                next_token: self.next_token,
            }
        }
    }
}
impl ListVirtualRoutersOutput {
    /// Creates a new builder-style object to manufacture [`ListVirtualRoutersOutput`](crate::output::ListVirtualRoutersOutput)
    pub fn builder() -> crate::output::list_virtual_routers_output::Builder {
        crate::output::list_virtual_routers_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateVirtualRouterOutput {
    /// <p>The full description of your virtual router following the create call.</p>
    pub virtual_router: std::option::Option<crate::model::VirtualRouterData>,
}
impl CreateVirtualRouterOutput {
    /// <p>The full description of your virtual router following the create call.</p>
    pub fn virtual_router(&self) -> std::option::Option<&crate::model::VirtualRouterData> {
        self.virtual_router.as_ref()
    }
}
impl std::fmt::Debug for CreateVirtualRouterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateVirtualRouterOutput");
        formatter.field("virtual_router", &self.virtual_router);
        formatter.finish()
    }
}
/// See [`CreateVirtualRouterOutput`](crate::output::CreateVirtualRouterOutput)
pub mod create_virtual_router_output {
    /// A builder for [`CreateVirtualRouterOutput`](crate::output::CreateVirtualRouterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_router: std::option::Option<crate::model::VirtualRouterData>,
    }
    impl Builder {
        /// <p>The full description of your virtual router following the create call.</p>
        pub fn virtual_router(mut self, input: crate::model::VirtualRouterData) -> Self {
            self.virtual_router = Some(input);
            self
        }
        /// <p>The full description of your virtual router following the create call.</p>
        pub fn set_virtual_router(
            mut self,
            input: std::option::Option<crate::model::VirtualRouterData>,
        ) -> Self {
            self.virtual_router = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateVirtualRouterOutput`](crate::output::CreateVirtualRouterOutput)
        pub fn build(self) -> crate::output::CreateVirtualRouterOutput {
            crate::output::CreateVirtualRouterOutput {
                virtual_router: self.virtual_router,
            }
        }
    }
}
impl CreateVirtualRouterOutput {
    /// Creates a new builder-style object to manufacture [`CreateVirtualRouterOutput`](crate::output::CreateVirtualRouterOutput)
    pub fn builder() -> crate::output::create_virtual_router_output::Builder {
        crate::output::create_virtual_router_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteVirtualRouterOutput {
    /// <p>The virtual router that was deleted.</p>
    pub virtual_router: std::option::Option<crate::model::VirtualRouterData>,
}
impl DeleteVirtualRouterOutput {
    /// <p>The virtual router that was deleted.</p>
    pub fn virtual_router(&self) -> std::option::Option<&crate::model::VirtualRouterData> {
        self.virtual_router.as_ref()
    }
}
impl std::fmt::Debug for DeleteVirtualRouterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteVirtualRouterOutput");
        formatter.field("virtual_router", &self.virtual_router);
        formatter.finish()
    }
}
/// See [`DeleteVirtualRouterOutput`](crate::output::DeleteVirtualRouterOutput)
pub mod delete_virtual_router_output {
    /// A builder for [`DeleteVirtualRouterOutput`](crate::output::DeleteVirtualRouterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_router: std::option::Option<crate::model::VirtualRouterData>,
    }
    impl Builder {
        /// <p>The virtual router that was deleted.</p>
        pub fn virtual_router(mut self, input: crate::model::VirtualRouterData) -> Self {
            self.virtual_router = Some(input);
            self
        }
        /// <p>The virtual router that was deleted.</p>
        pub fn set_virtual_router(
            mut self,
            input: std::option::Option<crate::model::VirtualRouterData>,
        ) -> Self {
            self.virtual_router = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteVirtualRouterOutput`](crate::output::DeleteVirtualRouterOutput)
        pub fn build(self) -> crate::output::DeleteVirtualRouterOutput {
            crate::output::DeleteVirtualRouterOutput {
                virtual_router: self.virtual_router,
            }
        }
    }
}
impl DeleteVirtualRouterOutput {
    /// Creates a new builder-style object to manufacture [`DeleteVirtualRouterOutput`](crate::output::DeleteVirtualRouterOutput)
    pub fn builder() -> crate::output::delete_virtual_router_output::Builder {
        crate::output::delete_virtual_router_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateVirtualRouterOutput {
    /// <p>A full description of the virtual router that was updated.</p>
    pub virtual_router: std::option::Option<crate::model::VirtualRouterData>,
}
impl UpdateVirtualRouterOutput {
    /// <p>A full description of the virtual router that was updated.</p>
    pub fn virtual_router(&self) -> std::option::Option<&crate::model::VirtualRouterData> {
        self.virtual_router.as_ref()
    }
}
impl std::fmt::Debug for UpdateVirtualRouterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateVirtualRouterOutput");
        formatter.field("virtual_router", &self.virtual_router);
        formatter.finish()
    }
}
/// See [`UpdateVirtualRouterOutput`](crate::output::UpdateVirtualRouterOutput)
pub mod update_virtual_router_output {
    /// A builder for [`UpdateVirtualRouterOutput`](crate::output::UpdateVirtualRouterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_router: std::option::Option<crate::model::VirtualRouterData>,
    }
    impl Builder {
        /// <p>A full description of the virtual router that was updated.</p>
        pub fn virtual_router(mut self, input: crate::model::VirtualRouterData) -> Self {
            self.virtual_router = Some(input);
            self
        }
        /// <p>A full description of the virtual router that was updated.</p>
        pub fn set_virtual_router(
            mut self,
            input: std::option::Option<crate::model::VirtualRouterData>,
        ) -> Self {
            self.virtual_router = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateVirtualRouterOutput`](crate::output::UpdateVirtualRouterOutput)
        pub fn build(self) -> crate::output::UpdateVirtualRouterOutput {
            crate::output::UpdateVirtualRouterOutput {
                virtual_router: self.virtual_router,
            }
        }
    }
}
impl UpdateVirtualRouterOutput {
    /// Creates a new builder-style object to manufacture [`UpdateVirtualRouterOutput`](crate::output::UpdateVirtualRouterOutput)
    pub fn builder() -> crate::output::update_virtual_router_output::Builder {
        crate::output::update_virtual_router_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeVirtualRouterOutput {
    /// <p>The full description of your virtual router.</p>
    pub virtual_router: std::option::Option<crate::model::VirtualRouterData>,
}
impl DescribeVirtualRouterOutput {
    /// <p>The full description of your virtual router.</p>
    pub fn virtual_router(&self) -> std::option::Option<&crate::model::VirtualRouterData> {
        self.virtual_router.as_ref()
    }
}
impl std::fmt::Debug for DescribeVirtualRouterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeVirtualRouterOutput");
        formatter.field("virtual_router", &self.virtual_router);
        formatter.finish()
    }
}
/// See [`DescribeVirtualRouterOutput`](crate::output::DescribeVirtualRouterOutput)
pub mod describe_virtual_router_output {
    /// A builder for [`DescribeVirtualRouterOutput`](crate::output::DescribeVirtualRouterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_router: std::option::Option<crate::model::VirtualRouterData>,
    }
    impl Builder {
        /// <p>The full description of your virtual router.</p>
        pub fn virtual_router(mut self, input: crate::model::VirtualRouterData) -> Self {
            self.virtual_router = Some(input);
            self
        }
        /// <p>The full description of your virtual router.</p>
        pub fn set_virtual_router(
            mut self,
            input: std::option::Option<crate::model::VirtualRouterData>,
        ) -> Self {
            self.virtual_router = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeVirtualRouterOutput`](crate::output::DescribeVirtualRouterOutput)
        pub fn build(self) -> crate::output::DescribeVirtualRouterOutput {
            crate::output::DescribeVirtualRouterOutput {
                virtual_router: self.virtual_router,
            }
        }
    }
}
impl DescribeVirtualRouterOutput {
    /// Creates a new builder-style object to manufacture [`DescribeVirtualRouterOutput`](crate::output::DescribeVirtualRouterOutput)
    pub fn builder() -> crate::output::describe_virtual_router_output::Builder {
        crate::output::describe_virtual_router_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRoutesOutput {
    /// <p>The list of existing routes for the specified service mesh and virtual router.</p>
    pub routes: std::option::Option<std::vec::Vec<crate::model::RouteRef>>,
    /// <p>The <code>nextToken</code> value to include in a future <code>ListRoutes</code> request.
    /// When the results of a <code>ListRoutes</code> request exceed <code>limit</code>, you can
    /// use this value to retrieve the next page of results. This value is <code>null</code> when
    /// there are no more results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListRoutesOutput {
    /// <p>The list of existing routes for the specified service mesh and virtual router.</p>
    pub fn routes(&self) -> std::option::Option<&[crate::model::RouteRef]> {
        self.routes.as_deref()
    }
    /// <p>The <code>nextToken</code> value to include in a future <code>ListRoutes</code> request.
    /// When the results of a <code>ListRoutes</code> request exceed <code>limit</code>, you can
    /// use this value to retrieve the next page of results. This value is <code>null</code> when
    /// there are no more results to return.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListRoutesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRoutesOutput");
        formatter.field("routes", &self.routes);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListRoutesOutput`](crate::output::ListRoutesOutput)
pub mod list_routes_output {
    /// A builder for [`ListRoutesOutput`](crate::output::ListRoutesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) routes: std::option::Option<std::vec::Vec<crate::model::RouteRef>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `routes`.
        ///
        /// To override the contents of this collection use [`set_routes`](Self::set_routes).
        ///
        /// <p>The list of existing routes for the specified service mesh and virtual router.</p>
        pub fn routes(mut self, input: impl Into<crate::model::RouteRef>) -> Self {
            let mut v = self.routes.unwrap_or_default();
            v.push(input.into());
            self.routes = Some(v);
            self
        }
        /// <p>The list of existing routes for the specified service mesh and virtual router.</p>
        pub fn set_routes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RouteRef>>,
        ) -> Self {
            self.routes = input;
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future <code>ListRoutes</code> request.
        /// When the results of a <code>ListRoutes</code> request exceed <code>limit</code>, you can
        /// use this value to retrieve the next page of results. This value is <code>null</code> when
        /// there are no more results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future <code>ListRoutes</code> request.
        /// When the results of a <code>ListRoutes</code> request exceed <code>limit</code>, you can
        /// use this value to retrieve the next page of results. This value is <code>null</code> when
        /// there are no more results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRoutesOutput`](crate::output::ListRoutesOutput)
        pub fn build(self) -> crate::output::ListRoutesOutput {
            crate::output::ListRoutesOutput {
                routes: self.routes,
                next_token: self.next_token,
            }
        }
    }
}
impl ListRoutesOutput {
    /// Creates a new builder-style object to manufacture [`ListRoutesOutput`](crate::output::ListRoutesOutput)
    pub fn builder() -> crate::output::list_routes_output::Builder {
        crate::output::list_routes_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRouteOutput {
    /// <p>The full description of your mesh following the create call.</p>
    pub route: std::option::Option<crate::model::RouteData>,
}
impl CreateRouteOutput {
    /// <p>The full description of your mesh following the create call.</p>
    pub fn route(&self) -> std::option::Option<&crate::model::RouteData> {
        self.route.as_ref()
    }
}
impl std::fmt::Debug for CreateRouteOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRouteOutput");
        formatter.field("route", &self.route);
        formatter.finish()
    }
}
/// See [`CreateRouteOutput`](crate::output::CreateRouteOutput)
pub mod create_route_output {
    /// A builder for [`CreateRouteOutput`](crate::output::CreateRouteOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) route: std::option::Option<crate::model::RouteData>,
    }
    impl Builder {
        /// <p>The full description of your mesh following the create call.</p>
        pub fn route(mut self, input: crate::model::RouteData) -> Self {
            self.route = Some(input);
            self
        }
        /// <p>The full description of your mesh following the create call.</p>
        pub fn set_route(mut self, input: std::option::Option<crate::model::RouteData>) -> Self {
            self.route = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRouteOutput`](crate::output::CreateRouteOutput)
        pub fn build(self) -> crate::output::CreateRouteOutput {
            crate::output::CreateRouteOutput { route: self.route }
        }
    }
}
impl CreateRouteOutput {
    /// Creates a new builder-style object to manufacture [`CreateRouteOutput`](crate::output::CreateRouteOutput)
    pub fn builder() -> crate::output::create_route_output::Builder {
        crate::output::create_route_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRouteOutput {
    /// <p>The route that was deleted.</p>
    pub route: std::option::Option<crate::model::RouteData>,
}
impl DeleteRouteOutput {
    /// <p>The route that was deleted.</p>
    pub fn route(&self) -> std::option::Option<&crate::model::RouteData> {
        self.route.as_ref()
    }
}
impl std::fmt::Debug for DeleteRouteOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRouteOutput");
        formatter.field("route", &self.route);
        formatter.finish()
    }
}
/// See [`DeleteRouteOutput`](crate::output::DeleteRouteOutput)
pub mod delete_route_output {
    /// A builder for [`DeleteRouteOutput`](crate::output::DeleteRouteOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) route: std::option::Option<crate::model::RouteData>,
    }
    impl Builder {
        /// <p>The route that was deleted.</p>
        pub fn route(mut self, input: crate::model::RouteData) -> Self {
            self.route = Some(input);
            self
        }
        /// <p>The route that was deleted.</p>
        pub fn set_route(mut self, input: std::option::Option<crate::model::RouteData>) -> Self {
            self.route = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRouteOutput`](crate::output::DeleteRouteOutput)
        pub fn build(self) -> crate::output::DeleteRouteOutput {
            crate::output::DeleteRouteOutput { route: self.route }
        }
    }
}
impl DeleteRouteOutput {
    /// Creates a new builder-style object to manufacture [`DeleteRouteOutput`](crate::output::DeleteRouteOutput)
    pub fn builder() -> crate::output::delete_route_output::Builder {
        crate::output::delete_route_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRouteOutput {
    /// <p>A full description of the route that was updated.</p>
    pub route: std::option::Option<crate::model::RouteData>,
}
impl UpdateRouteOutput {
    /// <p>A full description of the route that was updated.</p>
    pub fn route(&self) -> std::option::Option<&crate::model::RouteData> {
        self.route.as_ref()
    }
}
impl std::fmt::Debug for UpdateRouteOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRouteOutput");
        formatter.field("route", &self.route);
        formatter.finish()
    }
}
/// See [`UpdateRouteOutput`](crate::output::UpdateRouteOutput)
pub mod update_route_output {
    /// A builder for [`UpdateRouteOutput`](crate::output::UpdateRouteOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) route: std::option::Option<crate::model::RouteData>,
    }
    impl Builder {
        /// <p>A full description of the route that was updated.</p>
        pub fn route(mut self, input: crate::model::RouteData) -> Self {
            self.route = Some(input);
            self
        }
        /// <p>A full description of the route that was updated.</p>
        pub fn set_route(mut self, input: std::option::Option<crate::model::RouteData>) -> Self {
            self.route = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRouteOutput`](crate::output::UpdateRouteOutput)
        pub fn build(self) -> crate::output::UpdateRouteOutput {
            crate::output::UpdateRouteOutput { route: self.route }
        }
    }
}
impl UpdateRouteOutput {
    /// Creates a new builder-style object to manufacture [`UpdateRouteOutput`](crate::output::UpdateRouteOutput)
    pub fn builder() -> crate::output::update_route_output::Builder {
        crate::output::update_route_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRouteOutput {
    /// <p>The full description of your route.</p>
    pub route: std::option::Option<crate::model::RouteData>,
}
impl DescribeRouteOutput {
    /// <p>The full description of your route.</p>
    pub fn route(&self) -> std::option::Option<&crate::model::RouteData> {
        self.route.as_ref()
    }
}
impl std::fmt::Debug for DescribeRouteOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRouteOutput");
        formatter.field("route", &self.route);
        formatter.finish()
    }
}
/// See [`DescribeRouteOutput`](crate::output::DescribeRouteOutput)
pub mod describe_route_output {
    /// A builder for [`DescribeRouteOutput`](crate::output::DescribeRouteOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) route: std::option::Option<crate::model::RouteData>,
    }
    impl Builder {
        /// <p>The full description of your route.</p>
        pub fn route(mut self, input: crate::model::RouteData) -> Self {
            self.route = Some(input);
            self
        }
        /// <p>The full description of your route.</p>
        pub fn set_route(mut self, input: std::option::Option<crate::model::RouteData>) -> Self {
            self.route = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRouteOutput`](crate::output::DescribeRouteOutput)
        pub fn build(self) -> crate::output::DescribeRouteOutput {
            crate::output::DescribeRouteOutput { route: self.route }
        }
    }
}
impl DescribeRouteOutput {
    /// Creates a new builder-style object to manufacture [`DescribeRouteOutput`](crate::output::DescribeRouteOutput)
    pub fn builder() -> crate::output::describe_route_output::Builder {
        crate::output::describe_route_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListVirtualNodesOutput {
    /// <p>The list of existing virtual nodes for the specified service mesh.</p>
    pub virtual_nodes: std::option::Option<std::vec::Vec<crate::model::VirtualNodeRef>>,
    /// <p>The <code>nextToken</code> value to include in a future <code>ListVirtualNodes</code>
    /// request. When the results of a <code>ListVirtualNodes</code> request exceed
    /// <code>limit</code>, you can use this value to retrieve the next page of results. This
    /// value is <code>null</code> when there are no more results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListVirtualNodesOutput {
    /// <p>The list of existing virtual nodes for the specified service mesh.</p>
    pub fn virtual_nodes(&self) -> std::option::Option<&[crate::model::VirtualNodeRef]> {
        self.virtual_nodes.as_deref()
    }
    /// <p>The <code>nextToken</code> value to include in a future <code>ListVirtualNodes</code>
    /// request. When the results of a <code>ListVirtualNodes</code> request exceed
    /// <code>limit</code>, you can use this value to retrieve the next page of results. This
    /// value is <code>null</code> when there are no more results to return.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListVirtualNodesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListVirtualNodesOutput");
        formatter.field("virtual_nodes", &self.virtual_nodes);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListVirtualNodesOutput`](crate::output::ListVirtualNodesOutput)
pub mod list_virtual_nodes_output {
    /// A builder for [`ListVirtualNodesOutput`](crate::output::ListVirtualNodesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_nodes: std::option::Option<std::vec::Vec<crate::model::VirtualNodeRef>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `virtual_nodes`.
        ///
        /// To override the contents of this collection use [`set_virtual_nodes`](Self::set_virtual_nodes).
        ///
        /// <p>The list of existing virtual nodes for the specified service mesh.</p>
        pub fn virtual_nodes(mut self, input: impl Into<crate::model::VirtualNodeRef>) -> Self {
            let mut v = self.virtual_nodes.unwrap_or_default();
            v.push(input.into());
            self.virtual_nodes = Some(v);
            self
        }
        /// <p>The list of existing virtual nodes for the specified service mesh.</p>
        pub fn set_virtual_nodes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VirtualNodeRef>>,
        ) -> Self {
            self.virtual_nodes = input;
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future <code>ListVirtualNodes</code>
        /// request. When the results of a <code>ListVirtualNodes</code> request exceed
        /// <code>limit</code>, you can use this value to retrieve the next page of results. This
        /// value is <code>null</code> when there are no more results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future <code>ListVirtualNodes</code>
        /// request. When the results of a <code>ListVirtualNodes</code> request exceed
        /// <code>limit</code>, you can use this value to retrieve the next page of results. This
        /// value is <code>null</code> when there are no more results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListVirtualNodesOutput`](crate::output::ListVirtualNodesOutput)
        pub fn build(self) -> crate::output::ListVirtualNodesOutput {
            crate::output::ListVirtualNodesOutput {
                virtual_nodes: self.virtual_nodes,
                next_token: self.next_token,
            }
        }
    }
}
impl ListVirtualNodesOutput {
    /// Creates a new builder-style object to manufacture [`ListVirtualNodesOutput`](crate::output::ListVirtualNodesOutput)
    pub fn builder() -> crate::output::list_virtual_nodes_output::Builder {
        crate::output::list_virtual_nodes_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateVirtualNodeOutput {
    /// <p>The full description of your virtual node following the create call.</p>
    pub virtual_node: std::option::Option<crate::model::VirtualNodeData>,
}
impl CreateVirtualNodeOutput {
    /// <p>The full description of your virtual node following the create call.</p>
    pub fn virtual_node(&self) -> std::option::Option<&crate::model::VirtualNodeData> {
        self.virtual_node.as_ref()
    }
}
impl std::fmt::Debug for CreateVirtualNodeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateVirtualNodeOutput");
        formatter.field("virtual_node", &self.virtual_node);
        formatter.finish()
    }
}
/// See [`CreateVirtualNodeOutput`](crate::output::CreateVirtualNodeOutput)
pub mod create_virtual_node_output {
    /// A builder for [`CreateVirtualNodeOutput`](crate::output::CreateVirtualNodeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_node: std::option::Option<crate::model::VirtualNodeData>,
    }
    impl Builder {
        /// <p>The full description of your virtual node following the create call.</p>
        pub fn virtual_node(mut self, input: crate::model::VirtualNodeData) -> Self {
            self.virtual_node = Some(input);
            self
        }
        /// <p>The full description of your virtual node following the create call.</p>
        pub fn set_virtual_node(
            mut self,
            input: std::option::Option<crate::model::VirtualNodeData>,
        ) -> Self {
            self.virtual_node = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateVirtualNodeOutput`](crate::output::CreateVirtualNodeOutput)
        pub fn build(self) -> crate::output::CreateVirtualNodeOutput {
            crate::output::CreateVirtualNodeOutput {
                virtual_node: self.virtual_node,
            }
        }
    }
}
impl CreateVirtualNodeOutput {
    /// Creates a new builder-style object to manufacture [`CreateVirtualNodeOutput`](crate::output::CreateVirtualNodeOutput)
    pub fn builder() -> crate::output::create_virtual_node_output::Builder {
        crate::output::create_virtual_node_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteVirtualNodeOutput {
    /// <p>The virtual node that was deleted.</p>
    pub virtual_node: std::option::Option<crate::model::VirtualNodeData>,
}
impl DeleteVirtualNodeOutput {
    /// <p>The virtual node that was deleted.</p>
    pub fn virtual_node(&self) -> std::option::Option<&crate::model::VirtualNodeData> {
        self.virtual_node.as_ref()
    }
}
impl std::fmt::Debug for DeleteVirtualNodeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteVirtualNodeOutput");
        formatter.field("virtual_node", &self.virtual_node);
        formatter.finish()
    }
}
/// See [`DeleteVirtualNodeOutput`](crate::output::DeleteVirtualNodeOutput)
pub mod delete_virtual_node_output {
    /// A builder for [`DeleteVirtualNodeOutput`](crate::output::DeleteVirtualNodeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_node: std::option::Option<crate::model::VirtualNodeData>,
    }
    impl Builder {
        /// <p>The virtual node that was deleted.</p>
        pub fn virtual_node(mut self, input: crate::model::VirtualNodeData) -> Self {
            self.virtual_node = Some(input);
            self
        }
        /// <p>The virtual node that was deleted.</p>
        pub fn set_virtual_node(
            mut self,
            input: std::option::Option<crate::model::VirtualNodeData>,
        ) -> Self {
            self.virtual_node = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteVirtualNodeOutput`](crate::output::DeleteVirtualNodeOutput)
        pub fn build(self) -> crate::output::DeleteVirtualNodeOutput {
            crate::output::DeleteVirtualNodeOutput {
                virtual_node: self.virtual_node,
            }
        }
    }
}
impl DeleteVirtualNodeOutput {
    /// Creates a new builder-style object to manufacture [`DeleteVirtualNodeOutput`](crate::output::DeleteVirtualNodeOutput)
    pub fn builder() -> crate::output::delete_virtual_node_output::Builder {
        crate::output::delete_virtual_node_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateVirtualNodeOutput {
    /// <p>A full description of the virtual node that was updated.</p>
    pub virtual_node: std::option::Option<crate::model::VirtualNodeData>,
}
impl UpdateVirtualNodeOutput {
    /// <p>A full description of the virtual node that was updated.</p>
    pub fn virtual_node(&self) -> std::option::Option<&crate::model::VirtualNodeData> {
        self.virtual_node.as_ref()
    }
}
impl std::fmt::Debug for UpdateVirtualNodeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateVirtualNodeOutput");
        formatter.field("virtual_node", &self.virtual_node);
        formatter.finish()
    }
}
/// See [`UpdateVirtualNodeOutput`](crate::output::UpdateVirtualNodeOutput)
pub mod update_virtual_node_output {
    /// A builder for [`UpdateVirtualNodeOutput`](crate::output::UpdateVirtualNodeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_node: std::option::Option<crate::model::VirtualNodeData>,
    }
    impl Builder {
        /// <p>A full description of the virtual node that was updated.</p>
        pub fn virtual_node(mut self, input: crate::model::VirtualNodeData) -> Self {
            self.virtual_node = Some(input);
            self
        }
        /// <p>A full description of the virtual node that was updated.</p>
        pub fn set_virtual_node(
            mut self,
            input: std::option::Option<crate::model::VirtualNodeData>,
        ) -> Self {
            self.virtual_node = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateVirtualNodeOutput`](crate::output::UpdateVirtualNodeOutput)
        pub fn build(self) -> crate::output::UpdateVirtualNodeOutput {
            crate::output::UpdateVirtualNodeOutput {
                virtual_node: self.virtual_node,
            }
        }
    }
}
impl UpdateVirtualNodeOutput {
    /// Creates a new builder-style object to manufacture [`UpdateVirtualNodeOutput`](crate::output::UpdateVirtualNodeOutput)
    pub fn builder() -> crate::output::update_virtual_node_output::Builder {
        crate::output::update_virtual_node_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeVirtualNodeOutput {
    /// <p>The full description of your virtual node.</p>
    pub virtual_node: std::option::Option<crate::model::VirtualNodeData>,
}
impl DescribeVirtualNodeOutput {
    /// <p>The full description of your virtual node.</p>
    pub fn virtual_node(&self) -> std::option::Option<&crate::model::VirtualNodeData> {
        self.virtual_node.as_ref()
    }
}
impl std::fmt::Debug for DescribeVirtualNodeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeVirtualNodeOutput");
        formatter.field("virtual_node", &self.virtual_node);
        formatter.finish()
    }
}
/// See [`DescribeVirtualNodeOutput`](crate::output::DescribeVirtualNodeOutput)
pub mod describe_virtual_node_output {
    /// A builder for [`DescribeVirtualNodeOutput`](crate::output::DescribeVirtualNodeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_node: std::option::Option<crate::model::VirtualNodeData>,
    }
    impl Builder {
        /// <p>The full description of your virtual node.</p>
        pub fn virtual_node(mut self, input: crate::model::VirtualNodeData) -> Self {
            self.virtual_node = Some(input);
            self
        }
        /// <p>The full description of your virtual node.</p>
        pub fn set_virtual_node(
            mut self,
            input: std::option::Option<crate::model::VirtualNodeData>,
        ) -> Self {
            self.virtual_node = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeVirtualNodeOutput`](crate::output::DescribeVirtualNodeOutput)
        pub fn build(self) -> crate::output::DescribeVirtualNodeOutput {
            crate::output::DescribeVirtualNodeOutput {
                virtual_node: self.virtual_node,
            }
        }
    }
}
impl DescribeVirtualNodeOutput {
    /// Creates a new builder-style object to manufacture [`DescribeVirtualNodeOutput`](crate::output::DescribeVirtualNodeOutput)
    pub fn builder() -> crate::output::describe_virtual_node_output::Builder {
        crate::output::describe_virtual_node_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListVirtualGatewaysOutput {
    /// <p>The list of existing virtual gateways for the specified service mesh.</p>
    pub virtual_gateways: std::option::Option<std::vec::Vec<crate::model::VirtualGatewayRef>>,
    /// <p>The <code>nextToken</code> value to include in a future <code>ListVirtualGateways</code>
    /// request. When the results of a <code>ListVirtualGateways</code> request exceed
    /// <code>limit</code>, you can use this value to retrieve the next page of results. This
    /// value is <code>null</code> when there are no more results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListVirtualGatewaysOutput {
    /// <p>The list of existing virtual gateways for the specified service mesh.</p>
    pub fn virtual_gateways(&self) -> std::option::Option<&[crate::model::VirtualGatewayRef]> {
        self.virtual_gateways.as_deref()
    }
    /// <p>The <code>nextToken</code> value to include in a future <code>ListVirtualGateways</code>
    /// request. When the results of a <code>ListVirtualGateways</code> request exceed
    /// <code>limit</code>, you can use this value to retrieve the next page of results. This
    /// value is <code>null</code> when there are no more results to return.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListVirtualGatewaysOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListVirtualGatewaysOutput");
        formatter.field("virtual_gateways", &self.virtual_gateways);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListVirtualGatewaysOutput`](crate::output::ListVirtualGatewaysOutput)
pub mod list_virtual_gateways_output {
    /// A builder for [`ListVirtualGatewaysOutput`](crate::output::ListVirtualGatewaysOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_gateways:
            std::option::Option<std::vec::Vec<crate::model::VirtualGatewayRef>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `virtual_gateways`.
        ///
        /// To override the contents of this collection use [`set_virtual_gateways`](Self::set_virtual_gateways).
        ///
        /// <p>The list of existing virtual gateways for the specified service mesh.</p>
        pub fn virtual_gateways(
            mut self,
            input: impl Into<crate::model::VirtualGatewayRef>,
        ) -> Self {
            let mut v = self.virtual_gateways.unwrap_or_default();
            v.push(input.into());
            self.virtual_gateways = Some(v);
            self
        }
        /// <p>The list of existing virtual gateways for the specified service mesh.</p>
        pub fn set_virtual_gateways(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VirtualGatewayRef>>,
        ) -> Self {
            self.virtual_gateways = input;
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future <code>ListVirtualGateways</code>
        /// request. When the results of a <code>ListVirtualGateways</code> request exceed
        /// <code>limit</code>, you can use this value to retrieve the next page of results. This
        /// value is <code>null</code> when there are no more results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future <code>ListVirtualGateways</code>
        /// request. When the results of a <code>ListVirtualGateways</code> request exceed
        /// <code>limit</code>, you can use this value to retrieve the next page of results. This
        /// value is <code>null</code> when there are no more results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListVirtualGatewaysOutput`](crate::output::ListVirtualGatewaysOutput)
        pub fn build(self) -> crate::output::ListVirtualGatewaysOutput {
            crate::output::ListVirtualGatewaysOutput {
                virtual_gateways: self.virtual_gateways,
                next_token: self.next_token,
            }
        }
    }
}
impl ListVirtualGatewaysOutput {
    /// Creates a new builder-style object to manufacture [`ListVirtualGatewaysOutput`](crate::output::ListVirtualGatewaysOutput)
    pub fn builder() -> crate::output::list_virtual_gateways_output::Builder {
        crate::output::list_virtual_gateways_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateVirtualGatewayOutput {
    /// <p>The full description of your virtual gateway following the create call.</p>
    pub virtual_gateway: std::option::Option<crate::model::VirtualGatewayData>,
}
impl CreateVirtualGatewayOutput {
    /// <p>The full description of your virtual gateway following the create call.</p>
    pub fn virtual_gateway(&self) -> std::option::Option<&crate::model::VirtualGatewayData> {
        self.virtual_gateway.as_ref()
    }
}
impl std::fmt::Debug for CreateVirtualGatewayOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateVirtualGatewayOutput");
        formatter.field("virtual_gateway", &self.virtual_gateway);
        formatter.finish()
    }
}
/// See [`CreateVirtualGatewayOutput`](crate::output::CreateVirtualGatewayOutput)
pub mod create_virtual_gateway_output {
    /// A builder for [`CreateVirtualGatewayOutput`](crate::output::CreateVirtualGatewayOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_gateway: std::option::Option<crate::model::VirtualGatewayData>,
    }
    impl Builder {
        /// <p>The full description of your virtual gateway following the create call.</p>
        pub fn virtual_gateway(mut self, input: crate::model::VirtualGatewayData) -> Self {
            self.virtual_gateway = Some(input);
            self
        }
        /// <p>The full description of your virtual gateway following the create call.</p>
        pub fn set_virtual_gateway(
            mut self,
            input: std::option::Option<crate::model::VirtualGatewayData>,
        ) -> Self {
            self.virtual_gateway = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateVirtualGatewayOutput`](crate::output::CreateVirtualGatewayOutput)
        pub fn build(self) -> crate::output::CreateVirtualGatewayOutput {
            crate::output::CreateVirtualGatewayOutput {
                virtual_gateway: self.virtual_gateway,
            }
        }
    }
}
impl CreateVirtualGatewayOutput {
    /// Creates a new builder-style object to manufacture [`CreateVirtualGatewayOutput`](crate::output::CreateVirtualGatewayOutput)
    pub fn builder() -> crate::output::create_virtual_gateway_output::Builder {
        crate::output::create_virtual_gateway_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteVirtualGatewayOutput {
    /// <p>The virtual gateway that was deleted.</p>
    pub virtual_gateway: std::option::Option<crate::model::VirtualGatewayData>,
}
impl DeleteVirtualGatewayOutput {
    /// <p>The virtual gateway that was deleted.</p>
    pub fn virtual_gateway(&self) -> std::option::Option<&crate::model::VirtualGatewayData> {
        self.virtual_gateway.as_ref()
    }
}
impl std::fmt::Debug for DeleteVirtualGatewayOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteVirtualGatewayOutput");
        formatter.field("virtual_gateway", &self.virtual_gateway);
        formatter.finish()
    }
}
/// See [`DeleteVirtualGatewayOutput`](crate::output::DeleteVirtualGatewayOutput)
pub mod delete_virtual_gateway_output {
    /// A builder for [`DeleteVirtualGatewayOutput`](crate::output::DeleteVirtualGatewayOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_gateway: std::option::Option<crate::model::VirtualGatewayData>,
    }
    impl Builder {
        /// <p>The virtual gateway that was deleted.</p>
        pub fn virtual_gateway(mut self, input: crate::model::VirtualGatewayData) -> Self {
            self.virtual_gateway = Some(input);
            self
        }
        /// <p>The virtual gateway that was deleted.</p>
        pub fn set_virtual_gateway(
            mut self,
            input: std::option::Option<crate::model::VirtualGatewayData>,
        ) -> Self {
            self.virtual_gateway = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteVirtualGatewayOutput`](crate::output::DeleteVirtualGatewayOutput)
        pub fn build(self) -> crate::output::DeleteVirtualGatewayOutput {
            crate::output::DeleteVirtualGatewayOutput {
                virtual_gateway: self.virtual_gateway,
            }
        }
    }
}
impl DeleteVirtualGatewayOutput {
    /// Creates a new builder-style object to manufacture [`DeleteVirtualGatewayOutput`](crate::output::DeleteVirtualGatewayOutput)
    pub fn builder() -> crate::output::delete_virtual_gateway_output::Builder {
        crate::output::delete_virtual_gateway_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateVirtualGatewayOutput {
    /// <p>A full description of the virtual gateway that was updated.</p>
    pub virtual_gateway: std::option::Option<crate::model::VirtualGatewayData>,
}
impl UpdateVirtualGatewayOutput {
    /// <p>A full description of the virtual gateway that was updated.</p>
    pub fn virtual_gateway(&self) -> std::option::Option<&crate::model::VirtualGatewayData> {
        self.virtual_gateway.as_ref()
    }
}
impl std::fmt::Debug for UpdateVirtualGatewayOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateVirtualGatewayOutput");
        formatter.field("virtual_gateway", &self.virtual_gateway);
        formatter.finish()
    }
}
/// See [`UpdateVirtualGatewayOutput`](crate::output::UpdateVirtualGatewayOutput)
pub mod update_virtual_gateway_output {
    /// A builder for [`UpdateVirtualGatewayOutput`](crate::output::UpdateVirtualGatewayOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_gateway: std::option::Option<crate::model::VirtualGatewayData>,
    }
    impl Builder {
        /// <p>A full description of the virtual gateway that was updated.</p>
        pub fn virtual_gateway(mut self, input: crate::model::VirtualGatewayData) -> Self {
            self.virtual_gateway = Some(input);
            self
        }
        /// <p>A full description of the virtual gateway that was updated.</p>
        pub fn set_virtual_gateway(
            mut self,
            input: std::option::Option<crate::model::VirtualGatewayData>,
        ) -> Self {
            self.virtual_gateway = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateVirtualGatewayOutput`](crate::output::UpdateVirtualGatewayOutput)
        pub fn build(self) -> crate::output::UpdateVirtualGatewayOutput {
            crate::output::UpdateVirtualGatewayOutput {
                virtual_gateway: self.virtual_gateway,
            }
        }
    }
}
impl UpdateVirtualGatewayOutput {
    /// Creates a new builder-style object to manufacture [`UpdateVirtualGatewayOutput`](crate::output::UpdateVirtualGatewayOutput)
    pub fn builder() -> crate::output::update_virtual_gateway_output::Builder {
        crate::output::update_virtual_gateway_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeVirtualGatewayOutput {
    /// <p>The full description of your virtual gateway.</p>
    pub virtual_gateway: std::option::Option<crate::model::VirtualGatewayData>,
}
impl DescribeVirtualGatewayOutput {
    /// <p>The full description of your virtual gateway.</p>
    pub fn virtual_gateway(&self) -> std::option::Option<&crate::model::VirtualGatewayData> {
        self.virtual_gateway.as_ref()
    }
}
impl std::fmt::Debug for DescribeVirtualGatewayOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeVirtualGatewayOutput");
        formatter.field("virtual_gateway", &self.virtual_gateway);
        formatter.finish()
    }
}
/// See [`DescribeVirtualGatewayOutput`](crate::output::DescribeVirtualGatewayOutput)
pub mod describe_virtual_gateway_output {
    /// A builder for [`DescribeVirtualGatewayOutput`](crate::output::DescribeVirtualGatewayOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_gateway: std::option::Option<crate::model::VirtualGatewayData>,
    }
    impl Builder {
        /// <p>The full description of your virtual gateway.</p>
        pub fn virtual_gateway(mut self, input: crate::model::VirtualGatewayData) -> Self {
            self.virtual_gateway = Some(input);
            self
        }
        /// <p>The full description of your virtual gateway.</p>
        pub fn set_virtual_gateway(
            mut self,
            input: std::option::Option<crate::model::VirtualGatewayData>,
        ) -> Self {
            self.virtual_gateway = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeVirtualGatewayOutput`](crate::output::DescribeVirtualGatewayOutput)
        pub fn build(self) -> crate::output::DescribeVirtualGatewayOutput {
            crate::output::DescribeVirtualGatewayOutput {
                virtual_gateway: self.virtual_gateway,
            }
        }
    }
}
impl DescribeVirtualGatewayOutput {
    /// Creates a new builder-style object to manufacture [`DescribeVirtualGatewayOutput`](crate::output::DescribeVirtualGatewayOutput)
    pub fn builder() -> crate::output::describe_virtual_gateway_output::Builder {
        crate::output::describe_virtual_gateway_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListGatewayRoutesOutput {
    /// <p>The list of existing gateway routes for the specified service mesh and virtual
    /// gateway.</p>
    pub gateway_routes: std::option::Option<std::vec::Vec<crate::model::GatewayRouteRef>>,
    /// <p>The <code>nextToken</code> value to include in a future <code>ListGatewayRoutes</code>
    /// request. When the results of a <code>ListGatewayRoutes</code> request exceed
    /// <code>limit</code>, you can use this value to retrieve the next page of results. This
    /// value is <code>null</code> when there are no more results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListGatewayRoutesOutput {
    /// <p>The list of existing gateway routes for the specified service mesh and virtual
    /// gateway.</p>
    pub fn gateway_routes(&self) -> std::option::Option<&[crate::model::GatewayRouteRef]> {
        self.gateway_routes.as_deref()
    }
    /// <p>The <code>nextToken</code> value to include in a future <code>ListGatewayRoutes</code>
    /// request. When the results of a <code>ListGatewayRoutes</code> request exceed
    /// <code>limit</code>, you can use this value to retrieve the next page of results. This
    /// value is <code>null</code> when there are no more results to return.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListGatewayRoutesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListGatewayRoutesOutput");
        formatter.field("gateway_routes", &self.gateway_routes);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListGatewayRoutesOutput`](crate::output::ListGatewayRoutesOutput)
pub mod list_gateway_routes_output {
    /// A builder for [`ListGatewayRoutesOutput`](crate::output::ListGatewayRoutesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_routes:
            std::option::Option<std::vec::Vec<crate::model::GatewayRouteRef>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `gateway_routes`.
        ///
        /// To override the contents of this collection use [`set_gateway_routes`](Self::set_gateway_routes).
        ///
        /// <p>The list of existing gateway routes for the specified service mesh and virtual
        /// gateway.</p>
        pub fn gateway_routes(mut self, input: impl Into<crate::model::GatewayRouteRef>) -> Self {
            let mut v = self.gateway_routes.unwrap_or_default();
            v.push(input.into());
            self.gateway_routes = Some(v);
            self
        }
        /// <p>The list of existing gateway routes for the specified service mesh and virtual
        /// gateway.</p>
        pub fn set_gateway_routes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GatewayRouteRef>>,
        ) -> Self {
            self.gateway_routes = input;
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future <code>ListGatewayRoutes</code>
        /// request. When the results of a <code>ListGatewayRoutes</code> request exceed
        /// <code>limit</code>, you can use this value to retrieve the next page of results. This
        /// value is <code>null</code> when there are no more results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future <code>ListGatewayRoutes</code>
        /// request. When the results of a <code>ListGatewayRoutes</code> request exceed
        /// <code>limit</code>, you can use this value to retrieve the next page of results. This
        /// value is <code>null</code> when there are no more results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListGatewayRoutesOutput`](crate::output::ListGatewayRoutesOutput)
        pub fn build(self) -> crate::output::ListGatewayRoutesOutput {
            crate::output::ListGatewayRoutesOutput {
                gateway_routes: self.gateway_routes,
                next_token: self.next_token,
            }
        }
    }
}
impl ListGatewayRoutesOutput {
    /// Creates a new builder-style object to manufacture [`ListGatewayRoutesOutput`](crate::output::ListGatewayRoutesOutput)
    pub fn builder() -> crate::output::list_gateway_routes_output::Builder {
        crate::output::list_gateway_routes_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateGatewayRouteOutput {
    /// <p>The full description of your gateway route following the create call.</p>
    pub gateway_route: std::option::Option<crate::model::GatewayRouteData>,
}
impl CreateGatewayRouteOutput {
    /// <p>The full description of your gateway route following the create call.</p>
    pub fn gateway_route(&self) -> std::option::Option<&crate::model::GatewayRouteData> {
        self.gateway_route.as_ref()
    }
}
impl std::fmt::Debug for CreateGatewayRouteOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateGatewayRouteOutput");
        formatter.field("gateway_route", &self.gateway_route);
        formatter.finish()
    }
}
/// See [`CreateGatewayRouteOutput`](crate::output::CreateGatewayRouteOutput)
pub mod create_gateway_route_output {
    /// A builder for [`CreateGatewayRouteOutput`](crate::output::CreateGatewayRouteOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_route: std::option::Option<crate::model::GatewayRouteData>,
    }
    impl Builder {
        /// <p>The full description of your gateway route following the create call.</p>
        pub fn gateway_route(mut self, input: crate::model::GatewayRouteData) -> Self {
            self.gateway_route = Some(input);
            self
        }
        /// <p>The full description of your gateway route following the create call.</p>
        pub fn set_gateway_route(
            mut self,
            input: std::option::Option<crate::model::GatewayRouteData>,
        ) -> Self {
            self.gateway_route = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateGatewayRouteOutput`](crate::output::CreateGatewayRouteOutput)
        pub fn build(self) -> crate::output::CreateGatewayRouteOutput {
            crate::output::CreateGatewayRouteOutput {
                gateway_route: self.gateway_route,
            }
        }
    }
}
impl CreateGatewayRouteOutput {
    /// Creates a new builder-style object to manufacture [`CreateGatewayRouteOutput`](crate::output::CreateGatewayRouteOutput)
    pub fn builder() -> crate::output::create_gateway_route_output::Builder {
        crate::output::create_gateway_route_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteGatewayRouteOutput {
    /// <p>The gateway route that was deleted.</p>
    pub gateway_route: std::option::Option<crate::model::GatewayRouteData>,
}
impl DeleteGatewayRouteOutput {
    /// <p>The gateway route that was deleted.</p>
    pub fn gateway_route(&self) -> std::option::Option<&crate::model::GatewayRouteData> {
        self.gateway_route.as_ref()
    }
}
impl std::fmt::Debug for DeleteGatewayRouteOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteGatewayRouteOutput");
        formatter.field("gateway_route", &self.gateway_route);
        formatter.finish()
    }
}
/// See [`DeleteGatewayRouteOutput`](crate::output::DeleteGatewayRouteOutput)
pub mod delete_gateway_route_output {
    /// A builder for [`DeleteGatewayRouteOutput`](crate::output::DeleteGatewayRouteOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_route: std::option::Option<crate::model::GatewayRouteData>,
    }
    impl Builder {
        /// <p>The gateway route that was deleted.</p>
        pub fn gateway_route(mut self, input: crate::model::GatewayRouteData) -> Self {
            self.gateway_route = Some(input);
            self
        }
        /// <p>The gateway route that was deleted.</p>
        pub fn set_gateway_route(
            mut self,
            input: std::option::Option<crate::model::GatewayRouteData>,
        ) -> Self {
            self.gateway_route = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteGatewayRouteOutput`](crate::output::DeleteGatewayRouteOutput)
        pub fn build(self) -> crate::output::DeleteGatewayRouteOutput {
            crate::output::DeleteGatewayRouteOutput {
                gateway_route: self.gateway_route,
            }
        }
    }
}
impl DeleteGatewayRouteOutput {
    /// Creates a new builder-style object to manufacture [`DeleteGatewayRouteOutput`](crate::output::DeleteGatewayRouteOutput)
    pub fn builder() -> crate::output::delete_gateway_route_output::Builder {
        crate::output::delete_gateway_route_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateGatewayRouteOutput {
    /// <p>A full description of the gateway route that was updated.</p>
    pub gateway_route: std::option::Option<crate::model::GatewayRouteData>,
}
impl UpdateGatewayRouteOutput {
    /// <p>A full description of the gateway route that was updated.</p>
    pub fn gateway_route(&self) -> std::option::Option<&crate::model::GatewayRouteData> {
        self.gateway_route.as_ref()
    }
}
impl std::fmt::Debug for UpdateGatewayRouteOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateGatewayRouteOutput");
        formatter.field("gateway_route", &self.gateway_route);
        formatter.finish()
    }
}
/// See [`UpdateGatewayRouteOutput`](crate::output::UpdateGatewayRouteOutput)
pub mod update_gateway_route_output {
    /// A builder for [`UpdateGatewayRouteOutput`](crate::output::UpdateGatewayRouteOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_route: std::option::Option<crate::model::GatewayRouteData>,
    }
    impl Builder {
        /// <p>A full description of the gateway route that was updated.</p>
        pub fn gateway_route(mut self, input: crate::model::GatewayRouteData) -> Self {
            self.gateway_route = Some(input);
            self
        }
        /// <p>A full description of the gateway route that was updated.</p>
        pub fn set_gateway_route(
            mut self,
            input: std::option::Option<crate::model::GatewayRouteData>,
        ) -> Self {
            self.gateway_route = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateGatewayRouteOutput`](crate::output::UpdateGatewayRouteOutput)
        pub fn build(self) -> crate::output::UpdateGatewayRouteOutput {
            crate::output::UpdateGatewayRouteOutput {
                gateway_route: self.gateway_route,
            }
        }
    }
}
impl UpdateGatewayRouteOutput {
    /// Creates a new builder-style object to manufacture [`UpdateGatewayRouteOutput`](crate::output::UpdateGatewayRouteOutput)
    pub fn builder() -> crate::output::update_gateway_route_output::Builder {
        crate::output::update_gateway_route_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeGatewayRouteOutput {
    /// <p>The full description of your gateway route.</p>
    pub gateway_route: std::option::Option<crate::model::GatewayRouteData>,
}
impl DescribeGatewayRouteOutput {
    /// <p>The full description of your gateway route.</p>
    pub fn gateway_route(&self) -> std::option::Option<&crate::model::GatewayRouteData> {
        self.gateway_route.as_ref()
    }
}
impl std::fmt::Debug for DescribeGatewayRouteOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeGatewayRouteOutput");
        formatter.field("gateway_route", &self.gateway_route);
        formatter.finish()
    }
}
/// See [`DescribeGatewayRouteOutput`](crate::output::DescribeGatewayRouteOutput)
pub mod describe_gateway_route_output {
    /// A builder for [`DescribeGatewayRouteOutput`](crate::output::DescribeGatewayRouteOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_route: std::option::Option<crate::model::GatewayRouteData>,
    }
    impl Builder {
        /// <p>The full description of your gateway route.</p>
        pub fn gateway_route(mut self, input: crate::model::GatewayRouteData) -> Self {
            self.gateway_route = Some(input);
            self
        }
        /// <p>The full description of your gateway route.</p>
        pub fn set_gateway_route(
            mut self,
            input: std::option::Option<crate::model::GatewayRouteData>,
        ) -> Self {
            self.gateway_route = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeGatewayRouteOutput`](crate::output::DescribeGatewayRouteOutput)
        pub fn build(self) -> crate::output::DescribeGatewayRouteOutput {
            crate::output::DescribeGatewayRouteOutput {
                gateway_route: self.gateway_route,
            }
        }
    }
}
impl DescribeGatewayRouteOutput {
    /// Creates a new builder-style object to manufacture [`DescribeGatewayRouteOutput`](crate::output::DescribeGatewayRouteOutput)
    pub fn builder() -> crate::output::describe_gateway_route_output::Builder {
        crate::output::describe_gateway_route_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>The tags for the resource.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::TagRef>>,
    /// <p>The <code>nextToken</code> value to include in a future <code>ListTagsForResource</code>
    /// request. When the results of a <code>ListTagsForResource</code> request exceed
    /// <code>limit</code>, you can use this value to retrieve the next page of results. This
    /// value is <code>null</code> when there are no more results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTagsForResourceOutput {
    /// <p>The tags for the resource.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::TagRef]> {
        self.tags.as_deref()
    }
    /// <p>The <code>nextToken</code> value to include in a future <code>ListTagsForResource</code>
    /// request. When the results of a <code>ListTagsForResource</code> request exceed
    /// <code>limit</code>, you can use this value to retrieve the next page of results. This
    /// value is <code>null</code> when there are no more results to return.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::TagRef>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the resource.</p>
        pub fn tags(mut self, input: impl Into<crate::model::TagRef>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags for the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagRef>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future <code>ListTagsForResource</code>
        /// request. When the results of a <code>ListTagsForResource</code> request exceed
        /// <code>limit</code>, you can use this value to retrieve the next page of results. This
        /// value is <code>null</code> when there are no more results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future <code>ListTagsForResource</code>
        /// request. When the results of a <code>ListTagsForResource</code> request exceed
        /// <code>limit</code>, you can use this value to retrieve the next page of results. This
        /// value is <code>null</code> when there are no more results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput {
                tags: self.tags,
                next_token: self.next_token,
            }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}
