// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>An object that represents a service mesh returned by a list operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MeshRef {
    /// <p>The name of the service mesh.</p>
    pub mesh_name: std::option::Option<std::string::String>,
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
    /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub mesh_owner: std::option::Option<std::string::String>,
    /// <p>The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's
    /// the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub resource_owner: std::option::Option<std::string::String>,
    /// <p>The full Amazon Resource Name (ARN) of the service mesh.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The version of the resource. Resources are created at version 1, and this version is incremented each time that they're updated.</p>
    pub version: std::option::Option<i64>,
    /// <p>The Unix epoch timestamp in seconds for when the resource was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The Unix epoch timestamp in seconds for when the resource was last updated.</p>
    pub last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
}
impl MeshRef {
    /// <p>The name of the service mesh.</p>
    pub fn mesh_name(&self) -> std::option::Option<&str> {
        self.mesh_name.as_deref()
    }
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
    /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub fn mesh_owner(&self) -> std::option::Option<&str> {
        self.mesh_owner.as_deref()
    }
    /// <p>The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's
    /// the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub fn resource_owner(&self) -> std::option::Option<&str> {
        self.resource_owner.as_deref()
    }
    /// <p>The full Amazon Resource Name (ARN) of the service mesh.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The version of the resource. Resources are created at version 1, and this version is incremented each time that they're updated.</p>
    pub fn version(&self) -> std::option::Option<i64> {
        self.version
    }
    /// <p>The Unix epoch timestamp in seconds for when the resource was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The Unix epoch timestamp in seconds for when the resource was last updated.</p>
    pub fn last_updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_at.as_ref()
    }
}
impl std::fmt::Debug for MeshRef {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MeshRef");
        formatter.field("mesh_name", &self.mesh_name);
        formatter.field("mesh_owner", &self.mesh_owner);
        formatter.field("resource_owner", &self.resource_owner);
        formatter.field("arn", &self.arn);
        formatter.field("version", &self.version);
        formatter.field("created_at", &self.created_at);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.finish()
    }
}
/// See [`MeshRef`](crate::model::MeshRef)
pub mod mesh_ref {
    /// A builder for [`MeshRef`](crate::model::MeshRef)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mesh_name: std::option::Option<std::string::String>,
        pub(crate) mesh_owner: std::option::Option<std::string::String>,
        pub(crate) resource_owner: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<i64>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the service mesh.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_name = Some(input.into());
            self
        }
        /// <p>The name of the service mesh.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_name = input;
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_owner = Some(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_owner = input;
            self
        }
        /// <p>The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's
        /// the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn resource_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_owner = Some(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's
        /// the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_resource_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_owner = input;
            self
        }
        /// <p>The full Amazon Resource Name (ARN) of the service mesh.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The full Amazon Resource Name (ARN) of the service mesh.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The version of the resource. Resources are created at version 1, and this version is incremented each time that they're updated.</p>
        pub fn version(mut self, input: i64) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>The version of the resource. Resources are created at version 1, and this version is incremented each time that they're updated.</p>
        pub fn set_version(mut self, input: std::option::Option<i64>) -> Self {
            self.version = input;
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the resource was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the resource was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the resource was last updated.</p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the resource was last updated.</p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// Consumes the builder and constructs a [`MeshRef`](crate::model::MeshRef)
        pub fn build(self) -> crate::model::MeshRef {
            crate::model::MeshRef {
                mesh_name: self.mesh_name,
                mesh_owner: self.mesh_owner,
                resource_owner: self.resource_owner,
                arn: self.arn,
                version: self.version,
                created_at: self.created_at,
                last_updated_at: self.last_updated_at,
            }
        }
    }
}
impl MeshRef {
    /// Creates a new builder-style object to manufacture [`MeshRef`](crate::model::MeshRef)
    pub fn builder() -> crate::model::mesh_ref::Builder {
        crate::model::mesh_ref::Builder::default()
    }
}

/// <p>An object that represents a service mesh returned by a describe operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MeshData {
    /// <p>The name of the service mesh.</p>
    pub mesh_name: std::option::Option<std::string::String>,
    /// <p>The associated specification for the service mesh.</p>
    pub spec: std::option::Option<crate::model::MeshSpec>,
    /// <p>The associated metadata for the service mesh.</p>
    pub metadata: std::option::Option<crate::model::ResourceMetadata>,
    /// <p>The status of the service mesh.</p>
    pub status: std::option::Option<crate::model::MeshStatus>,
}
impl MeshData {
    /// <p>The name of the service mesh.</p>
    pub fn mesh_name(&self) -> std::option::Option<&str> {
        self.mesh_name.as_deref()
    }
    /// <p>The associated specification for the service mesh.</p>
    pub fn spec(&self) -> std::option::Option<&crate::model::MeshSpec> {
        self.spec.as_ref()
    }
    /// <p>The associated metadata for the service mesh.</p>
    pub fn metadata(&self) -> std::option::Option<&crate::model::ResourceMetadata> {
        self.metadata.as_ref()
    }
    /// <p>The status of the service mesh.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::MeshStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for MeshData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MeshData");
        formatter.field("mesh_name", &self.mesh_name);
        formatter.field("spec", &self.spec);
        formatter.field("metadata", &self.metadata);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`MeshData`](crate::model::MeshData)
pub mod mesh_data {
    /// A builder for [`MeshData`](crate::model::MeshData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mesh_name: std::option::Option<std::string::String>,
        pub(crate) spec: std::option::Option<crate::model::MeshSpec>,
        pub(crate) metadata: std::option::Option<crate::model::ResourceMetadata>,
        pub(crate) status: std::option::Option<crate::model::MeshStatus>,
    }
    impl Builder {
        /// <p>The name of the service mesh.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_name = Some(input.into());
            self
        }
        /// <p>The name of the service mesh.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_name = input;
            self
        }
        /// <p>The associated specification for the service mesh.</p>
        pub fn spec(mut self, input: crate::model::MeshSpec) -> Self {
            self.spec = Some(input);
            self
        }
        /// <p>The associated specification for the service mesh.</p>
        pub fn set_spec(mut self, input: std::option::Option<crate::model::MeshSpec>) -> Self {
            self.spec = input;
            self
        }
        /// <p>The associated metadata for the service mesh.</p>
        pub fn metadata(mut self, input: crate::model::ResourceMetadata) -> Self {
            self.metadata = Some(input);
            self
        }
        /// <p>The associated metadata for the service mesh.</p>
        pub fn set_metadata(
            mut self,
            input: std::option::Option<crate::model::ResourceMetadata>,
        ) -> Self {
            self.metadata = input;
            self
        }
        /// <p>The status of the service mesh.</p>
        pub fn status(mut self, input: crate::model::MeshStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the service mesh.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::MeshStatus>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`MeshData`](crate::model::MeshData)
        pub fn build(self) -> crate::model::MeshData {
            crate::model::MeshData {
                mesh_name: self.mesh_name,
                spec: self.spec,
                metadata: self.metadata,
                status: self.status,
            }
        }
    }
}
impl MeshData {
    /// Creates a new builder-style object to manufacture [`MeshData`](crate::model::MeshData)
    pub fn builder() -> crate::model::mesh_data::Builder {
        crate::model::mesh_data::Builder::default()
    }
}

/// <p>An object that represents the status of a service mesh.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MeshStatus {
    /// <p>The current mesh status.</p>
    pub status: std::option::Option<crate::model::MeshStatusCode>,
}
impl MeshStatus {
    /// <p>The current mesh status.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::MeshStatusCode> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for MeshStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MeshStatus");
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`MeshStatus`](crate::model::MeshStatus)
pub mod mesh_status {
    /// A builder for [`MeshStatus`](crate::model::MeshStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::MeshStatusCode>,
    }
    impl Builder {
        /// <p>The current mesh status.</p>
        pub fn status(mut self, input: crate::model::MeshStatusCode) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current mesh status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::MeshStatusCode>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`MeshStatus`](crate::model::MeshStatus)
        pub fn build(self) -> crate::model::MeshStatus {
            crate::model::MeshStatus {
                status: self.status,
            }
        }
    }
}
impl MeshStatus {
    /// Creates a new builder-style object to manufacture [`MeshStatus`](crate::model::MeshStatus)
    pub fn builder() -> crate::model::mesh_status::Builder {
        crate::model::mesh_status::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MeshStatusCode {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Inactive,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MeshStatusCode {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => MeshStatusCode::Active,
            "DELETED" => MeshStatusCode::Deleted,
            "INACTIVE" => MeshStatusCode::Inactive,
            other => MeshStatusCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MeshStatusCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MeshStatusCode::from(s))
    }
}
impl MeshStatusCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MeshStatusCode::Active => "ACTIVE",
            MeshStatusCode::Deleted => "DELETED",
            MeshStatusCode::Inactive => "INACTIVE",
            MeshStatusCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "DELETED", "INACTIVE"]
    }
}
impl AsRef<str> for MeshStatusCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that represents metadata for a resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceMetadata {
    /// <p>The full Amazon Resource Name (ARN) for the resource.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The version of the resource. Resources are created at version 1, and this version is incremented each time that they're updated.</p>
    pub version: std::option::Option<i64>,
    /// <p>The unique identifier for the resource.</p>
    pub uid: std::option::Option<std::string::String>,
    /// <p>The Unix epoch timestamp in seconds for when the resource was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The Unix epoch timestamp in seconds for when the resource was last updated.</p>
    pub last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
    /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub mesh_owner: std::option::Option<std::string::String>,
    /// <p>The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's
    /// the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub resource_owner: std::option::Option<std::string::String>,
}
impl ResourceMetadata {
    /// <p>The full Amazon Resource Name (ARN) for the resource.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The version of the resource. Resources are created at version 1, and this version is incremented each time that they're updated.</p>
    pub fn version(&self) -> std::option::Option<i64> {
        self.version
    }
    /// <p>The unique identifier for the resource.</p>
    pub fn uid(&self) -> std::option::Option<&str> {
        self.uid.as_deref()
    }
    /// <p>The Unix epoch timestamp in seconds for when the resource was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The Unix epoch timestamp in seconds for when the resource was last updated.</p>
    pub fn last_updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_at.as_ref()
    }
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
    /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub fn mesh_owner(&self) -> std::option::Option<&str> {
        self.mesh_owner.as_deref()
    }
    /// <p>The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's
    /// the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub fn resource_owner(&self) -> std::option::Option<&str> {
        self.resource_owner.as_deref()
    }
}
impl std::fmt::Debug for ResourceMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceMetadata");
        formatter.field("arn", &self.arn);
        formatter.field("version", &self.version);
        formatter.field("uid", &self.uid);
        formatter.field("created_at", &self.created_at);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.field("mesh_owner", &self.mesh_owner);
        formatter.field("resource_owner", &self.resource_owner);
        formatter.finish()
    }
}
/// See [`ResourceMetadata`](crate::model::ResourceMetadata)
pub mod resource_metadata {
    /// A builder for [`ResourceMetadata`](crate::model::ResourceMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<i64>,
        pub(crate) uid: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) mesh_owner: std::option::Option<std::string::String>,
        pub(crate) resource_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The full Amazon Resource Name (ARN) for the resource.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The full Amazon Resource Name (ARN) for the resource.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The version of the resource. Resources are created at version 1, and this version is incremented each time that they're updated.</p>
        pub fn version(mut self, input: i64) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>The version of the resource. Resources are created at version 1, and this version is incremented each time that they're updated.</p>
        pub fn set_version(mut self, input: std::option::Option<i64>) -> Self {
            self.version = input;
            self
        }
        /// <p>The unique identifier for the resource.</p>
        pub fn uid(mut self, input: impl Into<std::string::String>) -> Self {
            self.uid = Some(input.into());
            self
        }
        /// <p>The unique identifier for the resource.</p>
        pub fn set_uid(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.uid = input;
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the resource was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the resource was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the resource was last updated.</p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the resource was last updated.</p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_owner = Some(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_owner = input;
            self
        }
        /// <p>The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's
        /// the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn resource_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_owner = Some(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's
        /// the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_resource_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceMetadata`](crate::model::ResourceMetadata)
        pub fn build(self) -> crate::model::ResourceMetadata {
            crate::model::ResourceMetadata {
                arn: self.arn,
                version: self.version,
                uid: self.uid,
                created_at: self.created_at,
                last_updated_at: self.last_updated_at,
                mesh_owner: self.mesh_owner,
                resource_owner: self.resource_owner,
            }
        }
    }
}
impl ResourceMetadata {
    /// Creates a new builder-style object to manufacture [`ResourceMetadata`](crate::model::ResourceMetadata)
    pub fn builder() -> crate::model::resource_metadata::Builder {
        crate::model::resource_metadata::Builder::default()
    }
}

/// <p>An object that represents the specification of a service mesh.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MeshSpec {
    /// <p>The egress filter rules for the service mesh.</p>
    pub egress_filter: std::option::Option<crate::model::EgressFilter>,
}
impl MeshSpec {
    /// <p>The egress filter rules for the service mesh.</p>
    pub fn egress_filter(&self) -> std::option::Option<&crate::model::EgressFilter> {
        self.egress_filter.as_ref()
    }
}
impl std::fmt::Debug for MeshSpec {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MeshSpec");
        formatter.field("egress_filter", &self.egress_filter);
        formatter.finish()
    }
}
/// See [`MeshSpec`](crate::model::MeshSpec)
pub mod mesh_spec {
    /// A builder for [`MeshSpec`](crate::model::MeshSpec)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) egress_filter: std::option::Option<crate::model::EgressFilter>,
    }
    impl Builder {
        /// <p>The egress filter rules for the service mesh.</p>
        pub fn egress_filter(mut self, input: crate::model::EgressFilter) -> Self {
            self.egress_filter = Some(input);
            self
        }
        /// <p>The egress filter rules for the service mesh.</p>
        pub fn set_egress_filter(
            mut self,
            input: std::option::Option<crate::model::EgressFilter>,
        ) -> Self {
            self.egress_filter = input;
            self
        }
        /// Consumes the builder and constructs a [`MeshSpec`](crate::model::MeshSpec)
        pub fn build(self) -> crate::model::MeshSpec {
            crate::model::MeshSpec {
                egress_filter: self.egress_filter,
            }
        }
    }
}
impl MeshSpec {
    /// Creates a new builder-style object to manufacture [`MeshSpec`](crate::model::MeshSpec)
    pub fn builder() -> crate::model::mesh_spec::Builder {
        crate::model::mesh_spec::Builder::default()
    }
}

/// <p>An object that represents the egress filter rules for a service mesh.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EgressFilter {
    /// <p>The egress filter type. By default, the type is <code>DROP_ALL</code>, which allows
    /// egress only from virtual nodes to other defined resources in the service mesh (and any
    /// traffic to <code>*.amazonaws.com</code> for Amazon Web Services API calls). You can set the egress filter
    /// type to <code>ALLOW_ALL</code> to allow egress to any endpoint inside or outside of the
    /// service mesh.</p>
    pub r#type: std::option::Option<crate::model::EgressFilterType>,
}
impl EgressFilter {
    /// <p>The egress filter type. By default, the type is <code>DROP_ALL</code>, which allows
    /// egress only from virtual nodes to other defined resources in the service mesh (and any
    /// traffic to <code>*.amazonaws.com</code> for Amazon Web Services API calls). You can set the egress filter
    /// type to <code>ALLOW_ALL</code> to allow egress to any endpoint inside or outside of the
    /// service mesh.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::EgressFilterType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for EgressFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EgressFilter");
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`EgressFilter`](crate::model::EgressFilter)
pub mod egress_filter {
    /// A builder for [`EgressFilter`](crate::model::EgressFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::EgressFilterType>,
    }
    impl Builder {
        /// <p>The egress filter type. By default, the type is <code>DROP_ALL</code>, which allows
        /// egress only from virtual nodes to other defined resources in the service mesh (and any
        /// traffic to <code>*.amazonaws.com</code> for Amazon Web Services API calls). You can set the egress filter
        /// type to <code>ALLOW_ALL</code> to allow egress to any endpoint inside or outside of the
        /// service mesh.</p>
        pub fn r#type(mut self, input: crate::model::EgressFilterType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The egress filter type. By default, the type is <code>DROP_ALL</code>, which allows
        /// egress only from virtual nodes to other defined resources in the service mesh (and any
        /// traffic to <code>*.amazonaws.com</code> for Amazon Web Services API calls). You can set the egress filter
        /// type to <code>ALLOW_ALL</code> to allow egress to any endpoint inside or outside of the
        /// service mesh.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::EgressFilterType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`EgressFilter`](crate::model::EgressFilter)
        pub fn build(self) -> crate::model::EgressFilter {
            crate::model::EgressFilter {
                r#type: self.r#type,
            }
        }
    }
}
impl EgressFilter {
    /// Creates a new builder-style object to manufacture [`EgressFilter`](crate::model::EgressFilter)
    pub fn builder() -> crate::model::egress_filter::Builder {
        crate::model::egress_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EgressFilterType {
    #[allow(missing_docs)] // documentation missing in model
    AllowAll,
    #[allow(missing_docs)] // documentation missing in model
    DropAll,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EgressFilterType {
    fn from(s: &str) -> Self {
        match s {
            "ALLOW_ALL" => EgressFilterType::AllowAll,
            "DROP_ALL" => EgressFilterType::DropAll,
            other => EgressFilterType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EgressFilterType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EgressFilterType::from(s))
    }
}
impl EgressFilterType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EgressFilterType::AllowAll => "ALLOW_ALL",
            EgressFilterType::DropAll => "DROP_ALL",
            EgressFilterType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALLOW_ALL", "DROP_ALL"]
    }
}
impl AsRef<str> for EgressFilterType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Optional metadata that you apply to a resource to assist with categorization and
/// organization. Each tag consists of a key and an optional value, both of which you define.
/// Tag keys can have a maximum character length of 128 characters, and tag values can have
/// a maximum length of 256 characters.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagRef {
    /// <p>One part of a key-value pair that make up a tag. A <code>key</code> is a general label
    /// that acts like a category for more specific tag values.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The optional part of a key-value pair that make up a tag. A <code>value</code> acts as a
    /// descriptor within a tag category (key).</p>
    pub value: std::option::Option<std::string::String>,
}
impl TagRef {
    /// <p>One part of a key-value pair that make up a tag. A <code>key</code> is a general label
    /// that acts like a category for more specific tag values.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The optional part of a key-value pair that make up a tag. A <code>value</code> acts as a
    /// descriptor within a tag category (key).</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for TagRef {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagRef");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`TagRef`](crate::model::TagRef)
pub mod tag_ref {
    /// A builder for [`TagRef`](crate::model::TagRef)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>One part of a key-value pair that make up a tag. A <code>key</code> is a general label
        /// that acts like a category for more specific tag values.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>One part of a key-value pair that make up a tag. A <code>key</code> is a general label
        /// that acts like a category for more specific tag values.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The optional part of a key-value pair that make up a tag. A <code>value</code> acts as a
        /// descriptor within a tag category (key).</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The optional part of a key-value pair that make up a tag. A <code>value</code> acts as a
        /// descriptor within a tag category (key).</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`TagRef`](crate::model::TagRef)
        pub fn build(self) -> crate::model::TagRef {
            crate::model::TagRef {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl TagRef {
    /// Creates a new builder-style object to manufacture [`TagRef`](crate::model::TagRef)
    pub fn builder() -> crate::model::tag_ref::Builder {
        crate::model::tag_ref::Builder::default()
    }
}

/// <p>An object that represents a virtual service returned by a list operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VirtualServiceRef {
    /// <p>The name of the service mesh that the virtual service resides in.</p>
    pub mesh_name: std::option::Option<std::string::String>,
    /// <p>The name of the virtual service.</p>
    pub virtual_service_name: std::option::Option<std::string::String>,
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
    /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub mesh_owner: std::option::Option<std::string::String>,
    /// <p>The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's
    /// the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub resource_owner: std::option::Option<std::string::String>,
    /// <p>The full Amazon Resource Name (ARN) for the virtual service.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The version of the resource. Resources are created at version 1, and this version is incremented each time that they're updated.</p>
    pub version: std::option::Option<i64>,
    /// <p>The Unix epoch timestamp in seconds for when the resource was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The Unix epoch timestamp in seconds for when the resource was last updated.</p>
    pub last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
}
impl VirtualServiceRef {
    /// <p>The name of the service mesh that the virtual service resides in.</p>
    pub fn mesh_name(&self) -> std::option::Option<&str> {
        self.mesh_name.as_deref()
    }
    /// <p>The name of the virtual service.</p>
    pub fn virtual_service_name(&self) -> std::option::Option<&str> {
        self.virtual_service_name.as_deref()
    }
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
    /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub fn mesh_owner(&self) -> std::option::Option<&str> {
        self.mesh_owner.as_deref()
    }
    /// <p>The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's
    /// the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub fn resource_owner(&self) -> std::option::Option<&str> {
        self.resource_owner.as_deref()
    }
    /// <p>The full Amazon Resource Name (ARN) for the virtual service.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The version of the resource. Resources are created at version 1, and this version is incremented each time that they're updated.</p>
    pub fn version(&self) -> std::option::Option<i64> {
        self.version
    }
    /// <p>The Unix epoch timestamp in seconds for when the resource was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The Unix epoch timestamp in seconds for when the resource was last updated.</p>
    pub fn last_updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_at.as_ref()
    }
}
impl std::fmt::Debug for VirtualServiceRef {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VirtualServiceRef");
        formatter.field("mesh_name", &self.mesh_name);
        formatter.field("virtual_service_name", &self.virtual_service_name);
        formatter.field("mesh_owner", &self.mesh_owner);
        formatter.field("resource_owner", &self.resource_owner);
        formatter.field("arn", &self.arn);
        formatter.field("version", &self.version);
        formatter.field("created_at", &self.created_at);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.finish()
    }
}
/// See [`VirtualServiceRef`](crate::model::VirtualServiceRef)
pub mod virtual_service_ref {
    /// A builder for [`VirtualServiceRef`](crate::model::VirtualServiceRef)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mesh_name: std::option::Option<std::string::String>,
        pub(crate) virtual_service_name: std::option::Option<std::string::String>,
        pub(crate) mesh_owner: std::option::Option<std::string::String>,
        pub(crate) resource_owner: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<i64>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the service mesh that the virtual service resides in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_name = Some(input.into());
            self
        }
        /// <p>The name of the service mesh that the virtual service resides in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_name = input;
            self
        }
        /// <p>The name of the virtual service.</p>
        pub fn virtual_service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_service_name = Some(input.into());
            self
        }
        /// <p>The name of the virtual service.</p>
        pub fn set_virtual_service_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_service_name = input;
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_owner = Some(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_owner = input;
            self
        }
        /// <p>The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's
        /// the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn resource_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_owner = Some(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's
        /// the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_resource_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_owner = input;
            self
        }
        /// <p>The full Amazon Resource Name (ARN) for the virtual service.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The full Amazon Resource Name (ARN) for the virtual service.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The version of the resource. Resources are created at version 1, and this version is incremented each time that they're updated.</p>
        pub fn version(mut self, input: i64) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>The version of the resource. Resources are created at version 1, and this version is incremented each time that they're updated.</p>
        pub fn set_version(mut self, input: std::option::Option<i64>) -> Self {
            self.version = input;
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the resource was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the resource was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the resource was last updated.</p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the resource was last updated.</p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// Consumes the builder and constructs a [`VirtualServiceRef`](crate::model::VirtualServiceRef)
        pub fn build(self) -> crate::model::VirtualServiceRef {
            crate::model::VirtualServiceRef {
                mesh_name: self.mesh_name,
                virtual_service_name: self.virtual_service_name,
                mesh_owner: self.mesh_owner,
                resource_owner: self.resource_owner,
                arn: self.arn,
                version: self.version,
                created_at: self.created_at,
                last_updated_at: self.last_updated_at,
            }
        }
    }
}
impl VirtualServiceRef {
    /// Creates a new builder-style object to manufacture [`VirtualServiceRef`](crate::model::VirtualServiceRef)
    pub fn builder() -> crate::model::virtual_service_ref::Builder {
        crate::model::virtual_service_ref::Builder::default()
    }
}

/// <p>An object that represents a virtual service returned by a describe operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VirtualServiceData {
    /// <p>The name of the service mesh that the virtual service resides in.</p>
    pub mesh_name: std::option::Option<std::string::String>,
    /// <p>The name of the virtual service.</p>
    pub virtual_service_name: std::option::Option<std::string::String>,
    /// <p>The specifications of the virtual service.</p>
    pub spec: std::option::Option<crate::model::VirtualServiceSpec>,
    /// <p>An object that represents metadata for a resource.</p>
    pub metadata: std::option::Option<crate::model::ResourceMetadata>,
    /// <p>The current status of the virtual service.</p>
    pub status: std::option::Option<crate::model::VirtualServiceStatus>,
}
impl VirtualServiceData {
    /// <p>The name of the service mesh that the virtual service resides in.</p>
    pub fn mesh_name(&self) -> std::option::Option<&str> {
        self.mesh_name.as_deref()
    }
    /// <p>The name of the virtual service.</p>
    pub fn virtual_service_name(&self) -> std::option::Option<&str> {
        self.virtual_service_name.as_deref()
    }
    /// <p>The specifications of the virtual service.</p>
    pub fn spec(&self) -> std::option::Option<&crate::model::VirtualServiceSpec> {
        self.spec.as_ref()
    }
    /// <p>An object that represents metadata for a resource.</p>
    pub fn metadata(&self) -> std::option::Option<&crate::model::ResourceMetadata> {
        self.metadata.as_ref()
    }
    /// <p>The current status of the virtual service.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::VirtualServiceStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for VirtualServiceData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VirtualServiceData");
        formatter.field("mesh_name", &self.mesh_name);
        formatter.field("virtual_service_name", &self.virtual_service_name);
        formatter.field("spec", &self.spec);
        formatter.field("metadata", &self.metadata);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`VirtualServiceData`](crate::model::VirtualServiceData)
pub mod virtual_service_data {
    /// A builder for [`VirtualServiceData`](crate::model::VirtualServiceData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mesh_name: std::option::Option<std::string::String>,
        pub(crate) virtual_service_name: std::option::Option<std::string::String>,
        pub(crate) spec: std::option::Option<crate::model::VirtualServiceSpec>,
        pub(crate) metadata: std::option::Option<crate::model::ResourceMetadata>,
        pub(crate) status: std::option::Option<crate::model::VirtualServiceStatus>,
    }
    impl Builder {
        /// <p>The name of the service mesh that the virtual service resides in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_name = Some(input.into());
            self
        }
        /// <p>The name of the service mesh that the virtual service resides in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_name = input;
            self
        }
        /// <p>The name of the virtual service.</p>
        pub fn virtual_service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_service_name = Some(input.into());
            self
        }
        /// <p>The name of the virtual service.</p>
        pub fn set_virtual_service_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_service_name = input;
            self
        }
        /// <p>The specifications of the virtual service.</p>
        pub fn spec(mut self, input: crate::model::VirtualServiceSpec) -> Self {
            self.spec = Some(input);
            self
        }
        /// <p>The specifications of the virtual service.</p>
        pub fn set_spec(
            mut self,
            input: std::option::Option<crate::model::VirtualServiceSpec>,
        ) -> Self {
            self.spec = input;
            self
        }
        /// <p>An object that represents metadata for a resource.</p>
        pub fn metadata(mut self, input: crate::model::ResourceMetadata) -> Self {
            self.metadata = Some(input);
            self
        }
        /// <p>An object that represents metadata for a resource.</p>
        pub fn set_metadata(
            mut self,
            input: std::option::Option<crate::model::ResourceMetadata>,
        ) -> Self {
            self.metadata = input;
            self
        }
        /// <p>The current status of the virtual service.</p>
        pub fn status(mut self, input: crate::model::VirtualServiceStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the virtual service.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::VirtualServiceStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`VirtualServiceData`](crate::model::VirtualServiceData)
        pub fn build(self) -> crate::model::VirtualServiceData {
            crate::model::VirtualServiceData {
                mesh_name: self.mesh_name,
                virtual_service_name: self.virtual_service_name,
                spec: self.spec,
                metadata: self.metadata,
                status: self.status,
            }
        }
    }
}
impl VirtualServiceData {
    /// Creates a new builder-style object to manufacture [`VirtualServiceData`](crate::model::VirtualServiceData)
    pub fn builder() -> crate::model::virtual_service_data::Builder {
        crate::model::virtual_service_data::Builder::default()
    }
}

/// <p>An object that represents the status of a virtual service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VirtualServiceStatus {
    /// <p>The current status of the virtual service.</p>
    pub status: std::option::Option<crate::model::VirtualServiceStatusCode>,
}
impl VirtualServiceStatus {
    /// <p>The current status of the virtual service.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::VirtualServiceStatusCode> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for VirtualServiceStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VirtualServiceStatus");
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`VirtualServiceStatus`](crate::model::VirtualServiceStatus)
pub mod virtual_service_status {
    /// A builder for [`VirtualServiceStatus`](crate::model::VirtualServiceStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::VirtualServiceStatusCode>,
    }
    impl Builder {
        /// <p>The current status of the virtual service.</p>
        pub fn status(mut self, input: crate::model::VirtualServiceStatusCode) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the virtual service.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::VirtualServiceStatusCode>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`VirtualServiceStatus`](crate::model::VirtualServiceStatus)
        pub fn build(self) -> crate::model::VirtualServiceStatus {
            crate::model::VirtualServiceStatus {
                status: self.status,
            }
        }
    }
}
impl VirtualServiceStatus {
    /// Creates a new builder-style object to manufacture [`VirtualServiceStatus`](crate::model::VirtualServiceStatus)
    pub fn builder() -> crate::model::virtual_service_status::Builder {
        crate::model::virtual_service_status::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum VirtualServiceStatusCode {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Inactive,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for VirtualServiceStatusCode {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => VirtualServiceStatusCode::Active,
            "DELETED" => VirtualServiceStatusCode::Deleted,
            "INACTIVE" => VirtualServiceStatusCode::Inactive,
            other => VirtualServiceStatusCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for VirtualServiceStatusCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(VirtualServiceStatusCode::from(s))
    }
}
impl VirtualServiceStatusCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            VirtualServiceStatusCode::Active => "ACTIVE",
            VirtualServiceStatusCode::Deleted => "DELETED",
            VirtualServiceStatusCode::Inactive => "INACTIVE",
            VirtualServiceStatusCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "DELETED", "INACTIVE"]
    }
}
impl AsRef<str> for VirtualServiceStatusCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that represents the specification of a virtual service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VirtualServiceSpec {
    /// <p>The App Mesh object that is acting as the provider for a virtual service. You can specify
    /// a single virtual node or virtual router.</p>
    pub provider: std::option::Option<crate::model::VirtualServiceProvider>,
}
impl VirtualServiceSpec {
    /// <p>The App Mesh object that is acting as the provider for a virtual service. You can specify
    /// a single virtual node or virtual router.</p>
    pub fn provider(&self) -> std::option::Option<&crate::model::VirtualServiceProvider> {
        self.provider.as_ref()
    }
}
impl std::fmt::Debug for VirtualServiceSpec {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VirtualServiceSpec");
        formatter.field("provider", &self.provider);
        formatter.finish()
    }
}
/// See [`VirtualServiceSpec`](crate::model::VirtualServiceSpec)
pub mod virtual_service_spec {
    /// A builder for [`VirtualServiceSpec`](crate::model::VirtualServiceSpec)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) provider: std::option::Option<crate::model::VirtualServiceProvider>,
    }
    impl Builder {
        /// <p>The App Mesh object that is acting as the provider for a virtual service. You can specify
        /// a single virtual node or virtual router.</p>
        pub fn provider(mut self, input: crate::model::VirtualServiceProvider) -> Self {
            self.provider = Some(input);
            self
        }
        /// <p>The App Mesh object that is acting as the provider for a virtual service. You can specify
        /// a single virtual node or virtual router.</p>
        pub fn set_provider(
            mut self,
            input: std::option::Option<crate::model::VirtualServiceProvider>,
        ) -> Self {
            self.provider = input;
            self
        }
        /// Consumes the builder and constructs a [`VirtualServiceSpec`](crate::model::VirtualServiceSpec)
        pub fn build(self) -> crate::model::VirtualServiceSpec {
            crate::model::VirtualServiceSpec {
                provider: self.provider,
            }
        }
    }
}
impl VirtualServiceSpec {
    /// Creates a new builder-style object to manufacture [`VirtualServiceSpec`](crate::model::VirtualServiceSpec)
    pub fn builder() -> crate::model::virtual_service_spec::Builder {
        crate::model::virtual_service_spec::Builder::default()
    }
}

/// <p>An object that represents the provider for a virtual service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum VirtualServiceProvider {
    /// <p>The virtual node associated with a virtual service.</p>
    VirtualNode(crate::model::VirtualNodeServiceProvider),
    /// <p>The virtual router associated with a virtual service.</p>
    VirtualRouter(crate::model::VirtualRouterServiceProvider),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl VirtualServiceProvider {
    /// Tries to convert the enum instance into [`VirtualNode`](crate::model::VirtualServiceProvider::VirtualNode), extracting the inner [`VirtualNodeServiceProvider`](crate::model::VirtualNodeServiceProvider).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_virtual_node(
        &self,
    ) -> std::result::Result<&crate::model::VirtualNodeServiceProvider, &Self> {
        if let VirtualServiceProvider::VirtualNode(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`VirtualNode`](crate::model::VirtualServiceProvider::VirtualNode).
    pub fn is_virtual_node(&self) -> bool {
        self.as_virtual_node().is_ok()
    }
    /// Tries to convert the enum instance into [`VirtualRouter`](crate::model::VirtualServiceProvider::VirtualRouter), extracting the inner [`VirtualRouterServiceProvider`](crate::model::VirtualRouterServiceProvider).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_virtual_router(
        &self,
    ) -> std::result::Result<&crate::model::VirtualRouterServiceProvider, &Self> {
        if let VirtualServiceProvider::VirtualRouter(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`VirtualRouter`](crate::model::VirtualServiceProvider::VirtualRouter).
    pub fn is_virtual_router(&self) -> bool {
        self.as_virtual_router().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

/// <p>An object that represents a virtual node service provider.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VirtualRouterServiceProvider {
    /// <p>The name of the virtual router that is acting as a service provider.</p>
    pub virtual_router_name: std::option::Option<std::string::String>,
}
impl VirtualRouterServiceProvider {
    /// <p>The name of the virtual router that is acting as a service provider.</p>
    pub fn virtual_router_name(&self) -> std::option::Option<&str> {
        self.virtual_router_name.as_deref()
    }
}
impl std::fmt::Debug for VirtualRouterServiceProvider {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VirtualRouterServiceProvider");
        formatter.field("virtual_router_name", &self.virtual_router_name);
        formatter.finish()
    }
}
/// See [`VirtualRouterServiceProvider`](crate::model::VirtualRouterServiceProvider)
pub mod virtual_router_service_provider {
    /// A builder for [`VirtualRouterServiceProvider`](crate::model::VirtualRouterServiceProvider)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_router_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the virtual router that is acting as a service provider.</p>
        pub fn virtual_router_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_router_name = Some(input.into());
            self
        }
        /// <p>The name of the virtual router that is acting as a service provider.</p>
        pub fn set_virtual_router_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_router_name = input;
            self
        }
        /// Consumes the builder and constructs a [`VirtualRouterServiceProvider`](crate::model::VirtualRouterServiceProvider)
        pub fn build(self) -> crate::model::VirtualRouterServiceProvider {
            crate::model::VirtualRouterServiceProvider {
                virtual_router_name: self.virtual_router_name,
            }
        }
    }
}
impl VirtualRouterServiceProvider {
    /// Creates a new builder-style object to manufacture [`VirtualRouterServiceProvider`](crate::model::VirtualRouterServiceProvider)
    pub fn builder() -> crate::model::virtual_router_service_provider::Builder {
        crate::model::virtual_router_service_provider::Builder::default()
    }
}

/// <p>An object that represents a virtual node service provider.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VirtualNodeServiceProvider {
    /// <p>The name of the virtual node that is acting as a service provider.</p>
    pub virtual_node_name: std::option::Option<std::string::String>,
}
impl VirtualNodeServiceProvider {
    /// <p>The name of the virtual node that is acting as a service provider.</p>
    pub fn virtual_node_name(&self) -> std::option::Option<&str> {
        self.virtual_node_name.as_deref()
    }
}
impl std::fmt::Debug for VirtualNodeServiceProvider {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VirtualNodeServiceProvider");
        formatter.field("virtual_node_name", &self.virtual_node_name);
        formatter.finish()
    }
}
/// See [`VirtualNodeServiceProvider`](crate::model::VirtualNodeServiceProvider)
pub mod virtual_node_service_provider {
    /// A builder for [`VirtualNodeServiceProvider`](crate::model::VirtualNodeServiceProvider)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_node_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the virtual node that is acting as a service provider.</p>
        pub fn virtual_node_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_node_name = Some(input.into());
            self
        }
        /// <p>The name of the virtual node that is acting as a service provider.</p>
        pub fn set_virtual_node_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_node_name = input;
            self
        }
        /// Consumes the builder and constructs a [`VirtualNodeServiceProvider`](crate::model::VirtualNodeServiceProvider)
        pub fn build(self) -> crate::model::VirtualNodeServiceProvider {
            crate::model::VirtualNodeServiceProvider {
                virtual_node_name: self.virtual_node_name,
            }
        }
    }
}
impl VirtualNodeServiceProvider {
    /// Creates a new builder-style object to manufacture [`VirtualNodeServiceProvider`](crate::model::VirtualNodeServiceProvider)
    pub fn builder() -> crate::model::virtual_node_service_provider::Builder {
        crate::model::virtual_node_service_provider::Builder::default()
    }
}

/// <p>An object that represents a virtual router returned by a list operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VirtualRouterRef {
    /// <p>The name of the service mesh that the virtual router resides in.</p>
    pub mesh_name: std::option::Option<std::string::String>,
    /// <p>The name of the virtual router.</p>
    pub virtual_router_name: std::option::Option<std::string::String>,
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
    /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub mesh_owner: std::option::Option<std::string::String>,
    /// <p>The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's
    /// the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub resource_owner: std::option::Option<std::string::String>,
    /// <p>The full Amazon Resource Name (ARN) for the virtual router.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The version of the resource. Resources are created at version 1, and this version is incremented each time that they're updated.</p>
    pub version: std::option::Option<i64>,
    /// <p>The Unix epoch timestamp in seconds for when the resource was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The Unix epoch timestamp in seconds for when the resource was last updated.</p>
    pub last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
}
impl VirtualRouterRef {
    /// <p>The name of the service mesh that the virtual router resides in.</p>
    pub fn mesh_name(&self) -> std::option::Option<&str> {
        self.mesh_name.as_deref()
    }
    /// <p>The name of the virtual router.</p>
    pub fn virtual_router_name(&self) -> std::option::Option<&str> {
        self.virtual_router_name.as_deref()
    }
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
    /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub fn mesh_owner(&self) -> std::option::Option<&str> {
        self.mesh_owner.as_deref()
    }
    /// <p>The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's
    /// the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub fn resource_owner(&self) -> std::option::Option<&str> {
        self.resource_owner.as_deref()
    }
    /// <p>The full Amazon Resource Name (ARN) for the virtual router.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The version of the resource. Resources are created at version 1, and this version is incremented each time that they're updated.</p>
    pub fn version(&self) -> std::option::Option<i64> {
        self.version
    }
    /// <p>The Unix epoch timestamp in seconds for when the resource was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The Unix epoch timestamp in seconds for when the resource was last updated.</p>
    pub fn last_updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_at.as_ref()
    }
}
impl std::fmt::Debug for VirtualRouterRef {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VirtualRouterRef");
        formatter.field("mesh_name", &self.mesh_name);
        formatter.field("virtual_router_name", &self.virtual_router_name);
        formatter.field("mesh_owner", &self.mesh_owner);
        formatter.field("resource_owner", &self.resource_owner);
        formatter.field("arn", &self.arn);
        formatter.field("version", &self.version);
        formatter.field("created_at", &self.created_at);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.finish()
    }
}
/// See [`VirtualRouterRef`](crate::model::VirtualRouterRef)
pub mod virtual_router_ref {
    /// A builder for [`VirtualRouterRef`](crate::model::VirtualRouterRef)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mesh_name: std::option::Option<std::string::String>,
        pub(crate) virtual_router_name: std::option::Option<std::string::String>,
        pub(crate) mesh_owner: std::option::Option<std::string::String>,
        pub(crate) resource_owner: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<i64>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the service mesh that the virtual router resides in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_name = Some(input.into());
            self
        }
        /// <p>The name of the service mesh that the virtual router resides in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_name = input;
            self
        }
        /// <p>The name of the virtual router.</p>
        pub fn virtual_router_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_router_name = Some(input.into());
            self
        }
        /// <p>The name of the virtual router.</p>
        pub fn set_virtual_router_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_router_name = input;
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_owner = Some(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_owner = input;
            self
        }
        /// <p>The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's
        /// the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn resource_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_owner = Some(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's
        /// the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_resource_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_owner = input;
            self
        }
        /// <p>The full Amazon Resource Name (ARN) for the virtual router.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The full Amazon Resource Name (ARN) for the virtual router.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The version of the resource. Resources are created at version 1, and this version is incremented each time that they're updated.</p>
        pub fn version(mut self, input: i64) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>The version of the resource. Resources are created at version 1, and this version is incremented each time that they're updated.</p>
        pub fn set_version(mut self, input: std::option::Option<i64>) -> Self {
            self.version = input;
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the resource was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the resource was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the resource was last updated.</p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the resource was last updated.</p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// Consumes the builder and constructs a [`VirtualRouterRef`](crate::model::VirtualRouterRef)
        pub fn build(self) -> crate::model::VirtualRouterRef {
            crate::model::VirtualRouterRef {
                mesh_name: self.mesh_name,
                virtual_router_name: self.virtual_router_name,
                mesh_owner: self.mesh_owner,
                resource_owner: self.resource_owner,
                arn: self.arn,
                version: self.version,
                created_at: self.created_at,
                last_updated_at: self.last_updated_at,
            }
        }
    }
}
impl VirtualRouterRef {
    /// Creates a new builder-style object to manufacture [`VirtualRouterRef`](crate::model::VirtualRouterRef)
    pub fn builder() -> crate::model::virtual_router_ref::Builder {
        crate::model::virtual_router_ref::Builder::default()
    }
}

/// <p>An object that represents a virtual router returned by a describe operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VirtualRouterData {
    /// <p>The name of the service mesh that the virtual router resides in.</p>
    pub mesh_name: std::option::Option<std::string::String>,
    /// <p>The name of the virtual router.</p>
    pub virtual_router_name: std::option::Option<std::string::String>,
    /// <p>The specifications of the virtual router.</p>
    pub spec: std::option::Option<crate::model::VirtualRouterSpec>,
    /// <p>The associated metadata for the virtual router.</p>
    pub metadata: std::option::Option<crate::model::ResourceMetadata>,
    /// <p>The current status of the virtual router.</p>
    pub status: std::option::Option<crate::model::VirtualRouterStatus>,
}
impl VirtualRouterData {
    /// <p>The name of the service mesh that the virtual router resides in.</p>
    pub fn mesh_name(&self) -> std::option::Option<&str> {
        self.mesh_name.as_deref()
    }
    /// <p>The name of the virtual router.</p>
    pub fn virtual_router_name(&self) -> std::option::Option<&str> {
        self.virtual_router_name.as_deref()
    }
    /// <p>The specifications of the virtual router.</p>
    pub fn spec(&self) -> std::option::Option<&crate::model::VirtualRouterSpec> {
        self.spec.as_ref()
    }
    /// <p>The associated metadata for the virtual router.</p>
    pub fn metadata(&self) -> std::option::Option<&crate::model::ResourceMetadata> {
        self.metadata.as_ref()
    }
    /// <p>The current status of the virtual router.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::VirtualRouterStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for VirtualRouterData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VirtualRouterData");
        formatter.field("mesh_name", &self.mesh_name);
        formatter.field("virtual_router_name", &self.virtual_router_name);
        formatter.field("spec", &self.spec);
        formatter.field("metadata", &self.metadata);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`VirtualRouterData`](crate::model::VirtualRouterData)
pub mod virtual_router_data {
    /// A builder for [`VirtualRouterData`](crate::model::VirtualRouterData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mesh_name: std::option::Option<std::string::String>,
        pub(crate) virtual_router_name: std::option::Option<std::string::String>,
        pub(crate) spec: std::option::Option<crate::model::VirtualRouterSpec>,
        pub(crate) metadata: std::option::Option<crate::model::ResourceMetadata>,
        pub(crate) status: std::option::Option<crate::model::VirtualRouterStatus>,
    }
    impl Builder {
        /// <p>The name of the service mesh that the virtual router resides in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_name = Some(input.into());
            self
        }
        /// <p>The name of the service mesh that the virtual router resides in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_name = input;
            self
        }
        /// <p>The name of the virtual router.</p>
        pub fn virtual_router_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_router_name = Some(input.into());
            self
        }
        /// <p>The name of the virtual router.</p>
        pub fn set_virtual_router_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_router_name = input;
            self
        }
        /// <p>The specifications of the virtual router.</p>
        pub fn spec(mut self, input: crate::model::VirtualRouterSpec) -> Self {
            self.spec = Some(input);
            self
        }
        /// <p>The specifications of the virtual router.</p>
        pub fn set_spec(
            mut self,
            input: std::option::Option<crate::model::VirtualRouterSpec>,
        ) -> Self {
            self.spec = input;
            self
        }
        /// <p>The associated metadata for the virtual router.</p>
        pub fn metadata(mut self, input: crate::model::ResourceMetadata) -> Self {
            self.metadata = Some(input);
            self
        }
        /// <p>The associated metadata for the virtual router.</p>
        pub fn set_metadata(
            mut self,
            input: std::option::Option<crate::model::ResourceMetadata>,
        ) -> Self {
            self.metadata = input;
            self
        }
        /// <p>The current status of the virtual router.</p>
        pub fn status(mut self, input: crate::model::VirtualRouterStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the virtual router.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::VirtualRouterStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`VirtualRouterData`](crate::model::VirtualRouterData)
        pub fn build(self) -> crate::model::VirtualRouterData {
            crate::model::VirtualRouterData {
                mesh_name: self.mesh_name,
                virtual_router_name: self.virtual_router_name,
                spec: self.spec,
                metadata: self.metadata,
                status: self.status,
            }
        }
    }
}
impl VirtualRouterData {
    /// Creates a new builder-style object to manufacture [`VirtualRouterData`](crate::model::VirtualRouterData)
    pub fn builder() -> crate::model::virtual_router_data::Builder {
        crate::model::virtual_router_data::Builder::default()
    }
}

/// <p>An object that represents the status of a virtual router. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VirtualRouterStatus {
    /// <p>The current status of the virtual router.</p>
    pub status: std::option::Option<crate::model::VirtualRouterStatusCode>,
}
impl VirtualRouterStatus {
    /// <p>The current status of the virtual router.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::VirtualRouterStatusCode> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for VirtualRouterStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VirtualRouterStatus");
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`VirtualRouterStatus`](crate::model::VirtualRouterStatus)
pub mod virtual_router_status {
    /// A builder for [`VirtualRouterStatus`](crate::model::VirtualRouterStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::VirtualRouterStatusCode>,
    }
    impl Builder {
        /// <p>The current status of the virtual router.</p>
        pub fn status(mut self, input: crate::model::VirtualRouterStatusCode) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the virtual router.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::VirtualRouterStatusCode>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`VirtualRouterStatus`](crate::model::VirtualRouterStatus)
        pub fn build(self) -> crate::model::VirtualRouterStatus {
            crate::model::VirtualRouterStatus {
                status: self.status,
            }
        }
    }
}
impl VirtualRouterStatus {
    /// Creates a new builder-style object to manufacture [`VirtualRouterStatus`](crate::model::VirtualRouterStatus)
    pub fn builder() -> crate::model::virtual_router_status::Builder {
        crate::model::virtual_router_status::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum VirtualRouterStatusCode {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Inactive,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for VirtualRouterStatusCode {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => VirtualRouterStatusCode::Active,
            "DELETED" => VirtualRouterStatusCode::Deleted,
            "INACTIVE" => VirtualRouterStatusCode::Inactive,
            other => VirtualRouterStatusCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for VirtualRouterStatusCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(VirtualRouterStatusCode::from(s))
    }
}
impl VirtualRouterStatusCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            VirtualRouterStatusCode::Active => "ACTIVE",
            VirtualRouterStatusCode::Deleted => "DELETED",
            VirtualRouterStatusCode::Inactive => "INACTIVE",
            VirtualRouterStatusCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "DELETED", "INACTIVE"]
    }
}
impl AsRef<str> for VirtualRouterStatusCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that represents the specification of a virtual router.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VirtualRouterSpec {
    /// <p>The listeners that the virtual router is expected to receive inbound traffic from. You
    /// can specify one listener.</p>
    pub listeners: std::option::Option<std::vec::Vec<crate::model::VirtualRouterListener>>,
}
impl VirtualRouterSpec {
    /// <p>The listeners that the virtual router is expected to receive inbound traffic from. You
    /// can specify one listener.</p>
    pub fn listeners(&self) -> std::option::Option<&[crate::model::VirtualRouterListener]> {
        self.listeners.as_deref()
    }
}
impl std::fmt::Debug for VirtualRouterSpec {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VirtualRouterSpec");
        formatter.field("listeners", &self.listeners);
        formatter.finish()
    }
}
/// See [`VirtualRouterSpec`](crate::model::VirtualRouterSpec)
pub mod virtual_router_spec {
    /// A builder for [`VirtualRouterSpec`](crate::model::VirtualRouterSpec)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) listeners:
            std::option::Option<std::vec::Vec<crate::model::VirtualRouterListener>>,
    }
    impl Builder {
        /// Appends an item to `listeners`.
        ///
        /// To override the contents of this collection use [`set_listeners`](Self::set_listeners).
        ///
        /// <p>The listeners that the virtual router is expected to receive inbound traffic from. You
        /// can specify one listener.</p>
        pub fn listeners(mut self, input: impl Into<crate::model::VirtualRouterListener>) -> Self {
            let mut v = self.listeners.unwrap_or_default();
            v.push(input.into());
            self.listeners = Some(v);
            self
        }
        /// <p>The listeners that the virtual router is expected to receive inbound traffic from. You
        /// can specify one listener.</p>
        pub fn set_listeners(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VirtualRouterListener>>,
        ) -> Self {
            self.listeners = input;
            self
        }
        /// Consumes the builder and constructs a [`VirtualRouterSpec`](crate::model::VirtualRouterSpec)
        pub fn build(self) -> crate::model::VirtualRouterSpec {
            crate::model::VirtualRouterSpec {
                listeners: self.listeners,
            }
        }
    }
}
impl VirtualRouterSpec {
    /// Creates a new builder-style object to manufacture [`VirtualRouterSpec`](crate::model::VirtualRouterSpec)
    pub fn builder() -> crate::model::virtual_router_spec::Builder {
        crate::model::virtual_router_spec::Builder::default()
    }
}

/// <p>An object that represents a virtual router listener.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VirtualRouterListener {
    /// <p>An object that represents a port mapping.</p>
    pub port_mapping: std::option::Option<crate::model::PortMapping>,
}
impl VirtualRouterListener {
    /// <p>An object that represents a port mapping.</p>
    pub fn port_mapping(&self) -> std::option::Option<&crate::model::PortMapping> {
        self.port_mapping.as_ref()
    }
}
impl std::fmt::Debug for VirtualRouterListener {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VirtualRouterListener");
        formatter.field("port_mapping", &self.port_mapping);
        formatter.finish()
    }
}
/// See [`VirtualRouterListener`](crate::model::VirtualRouterListener)
pub mod virtual_router_listener {
    /// A builder for [`VirtualRouterListener`](crate::model::VirtualRouterListener)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) port_mapping: std::option::Option<crate::model::PortMapping>,
    }
    impl Builder {
        /// <p>An object that represents a port mapping.</p>
        pub fn port_mapping(mut self, input: crate::model::PortMapping) -> Self {
            self.port_mapping = Some(input);
            self
        }
        /// <p>An object that represents a port mapping.</p>
        pub fn set_port_mapping(
            mut self,
            input: std::option::Option<crate::model::PortMapping>,
        ) -> Self {
            self.port_mapping = input;
            self
        }
        /// Consumes the builder and constructs a [`VirtualRouterListener`](crate::model::VirtualRouterListener)
        pub fn build(self) -> crate::model::VirtualRouterListener {
            crate::model::VirtualRouterListener {
                port_mapping: self.port_mapping,
            }
        }
    }
}
impl VirtualRouterListener {
    /// Creates a new builder-style object to manufacture [`VirtualRouterListener`](crate::model::VirtualRouterListener)
    pub fn builder() -> crate::model::virtual_router_listener::Builder {
        crate::model::virtual_router_listener::Builder::default()
    }
}

/// <p>An object that represents a port mapping.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PortMapping {
    /// <p>The port used for the port mapping.</p>
    pub port: i32,
    /// <p>The protocol used for the port mapping. Specify one protocol.</p>
    pub protocol: std::option::Option<crate::model::PortProtocol>,
}
impl PortMapping {
    /// <p>The port used for the port mapping.</p>
    pub fn port(&self) -> i32 {
        self.port
    }
    /// <p>The protocol used for the port mapping. Specify one protocol.</p>
    pub fn protocol(&self) -> std::option::Option<&crate::model::PortProtocol> {
        self.protocol.as_ref()
    }
}
impl std::fmt::Debug for PortMapping {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PortMapping");
        formatter.field("port", &self.port);
        formatter.field("protocol", &self.protocol);
        formatter.finish()
    }
}
/// See [`PortMapping`](crate::model::PortMapping)
pub mod port_mapping {
    /// A builder for [`PortMapping`](crate::model::PortMapping)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) port: std::option::Option<i32>,
        pub(crate) protocol: std::option::Option<crate::model::PortProtocol>,
    }
    impl Builder {
        /// <p>The port used for the port mapping.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The port used for the port mapping.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>The protocol used for the port mapping. Specify one protocol.</p>
        pub fn protocol(mut self, input: crate::model::PortProtocol) -> Self {
            self.protocol = Some(input);
            self
        }
        /// <p>The protocol used for the port mapping. Specify one protocol.</p>
        pub fn set_protocol(
            mut self,
            input: std::option::Option<crate::model::PortProtocol>,
        ) -> Self {
            self.protocol = input;
            self
        }
        /// Consumes the builder and constructs a [`PortMapping`](crate::model::PortMapping)
        pub fn build(self) -> crate::model::PortMapping {
            crate::model::PortMapping {
                port: self.port.unwrap_or_default(),
                protocol: self.protocol,
            }
        }
    }
}
impl PortMapping {
    /// Creates a new builder-style object to manufacture [`PortMapping`](crate::model::PortMapping)
    pub fn builder() -> crate::model::port_mapping::Builder {
        crate::model::port_mapping::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PortProtocol {
    #[allow(missing_docs)] // documentation missing in model
    Grpc,
    #[allow(missing_docs)] // documentation missing in model
    Http,
    #[allow(missing_docs)] // documentation missing in model
    Http2,
    #[allow(missing_docs)] // documentation missing in model
    Tcp,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PortProtocol {
    fn from(s: &str) -> Self {
        match s {
            "grpc" => PortProtocol::Grpc,
            "http" => PortProtocol::Http,
            "http2" => PortProtocol::Http2,
            "tcp" => PortProtocol::Tcp,
            other => PortProtocol::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PortProtocol {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PortProtocol::from(s))
    }
}
impl PortProtocol {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PortProtocol::Grpc => "grpc",
            PortProtocol::Http => "http",
            PortProtocol::Http2 => "http2",
            PortProtocol::Tcp => "tcp",
            PortProtocol::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["grpc", "http", "http2", "tcp"]
    }
}
impl AsRef<str> for PortProtocol {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that represents a route returned by a list operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RouteRef {
    /// <p>The name of the service mesh that the route resides in.</p>
    pub mesh_name: std::option::Option<std::string::String>,
    /// <p>The virtual router that the route is associated with.</p>
    pub virtual_router_name: std::option::Option<std::string::String>,
    /// <p>The name of the route.</p>
    pub route_name: std::option::Option<std::string::String>,
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
    /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub mesh_owner: std::option::Option<std::string::String>,
    /// <p>The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's
    /// the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub resource_owner: std::option::Option<std::string::String>,
    /// <p>The full Amazon Resource Name (ARN) for the route.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The version of the resource. Resources are created at version 1, and this version is incremented each time that they're updated.</p>
    pub version: std::option::Option<i64>,
    /// <p>The Unix epoch timestamp in seconds for when the resource was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The Unix epoch timestamp in seconds for when the resource was last updated.</p>
    pub last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
}
impl RouteRef {
    /// <p>The name of the service mesh that the route resides in.</p>
    pub fn mesh_name(&self) -> std::option::Option<&str> {
        self.mesh_name.as_deref()
    }
    /// <p>The virtual router that the route is associated with.</p>
    pub fn virtual_router_name(&self) -> std::option::Option<&str> {
        self.virtual_router_name.as_deref()
    }
    /// <p>The name of the route.</p>
    pub fn route_name(&self) -> std::option::Option<&str> {
        self.route_name.as_deref()
    }
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
    /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub fn mesh_owner(&self) -> std::option::Option<&str> {
        self.mesh_owner.as_deref()
    }
    /// <p>The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's
    /// the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub fn resource_owner(&self) -> std::option::Option<&str> {
        self.resource_owner.as_deref()
    }
    /// <p>The full Amazon Resource Name (ARN) for the route.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The version of the resource. Resources are created at version 1, and this version is incremented each time that they're updated.</p>
    pub fn version(&self) -> std::option::Option<i64> {
        self.version
    }
    /// <p>The Unix epoch timestamp in seconds for when the resource was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The Unix epoch timestamp in seconds for when the resource was last updated.</p>
    pub fn last_updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_at.as_ref()
    }
}
impl std::fmt::Debug for RouteRef {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RouteRef");
        formatter.field("mesh_name", &self.mesh_name);
        formatter.field("virtual_router_name", &self.virtual_router_name);
        formatter.field("route_name", &self.route_name);
        formatter.field("mesh_owner", &self.mesh_owner);
        formatter.field("resource_owner", &self.resource_owner);
        formatter.field("arn", &self.arn);
        formatter.field("version", &self.version);
        formatter.field("created_at", &self.created_at);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.finish()
    }
}
/// See [`RouteRef`](crate::model::RouteRef)
pub mod route_ref {
    /// A builder for [`RouteRef`](crate::model::RouteRef)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mesh_name: std::option::Option<std::string::String>,
        pub(crate) virtual_router_name: std::option::Option<std::string::String>,
        pub(crate) route_name: std::option::Option<std::string::String>,
        pub(crate) mesh_owner: std::option::Option<std::string::String>,
        pub(crate) resource_owner: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<i64>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the service mesh that the route resides in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_name = Some(input.into());
            self
        }
        /// <p>The name of the service mesh that the route resides in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_name = input;
            self
        }
        /// <p>The virtual router that the route is associated with.</p>
        pub fn virtual_router_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_router_name = Some(input.into());
            self
        }
        /// <p>The virtual router that the route is associated with.</p>
        pub fn set_virtual_router_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_router_name = input;
            self
        }
        /// <p>The name of the route.</p>
        pub fn route_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_name = Some(input.into());
            self
        }
        /// <p>The name of the route.</p>
        pub fn set_route_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.route_name = input;
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_owner = Some(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_owner = input;
            self
        }
        /// <p>The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's
        /// the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn resource_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_owner = Some(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's
        /// the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_resource_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_owner = input;
            self
        }
        /// <p>The full Amazon Resource Name (ARN) for the route.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The full Amazon Resource Name (ARN) for the route.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The version of the resource. Resources are created at version 1, and this version is incremented each time that they're updated.</p>
        pub fn version(mut self, input: i64) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>The version of the resource. Resources are created at version 1, and this version is incremented each time that they're updated.</p>
        pub fn set_version(mut self, input: std::option::Option<i64>) -> Self {
            self.version = input;
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the resource was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the resource was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the resource was last updated.</p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the resource was last updated.</p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// Consumes the builder and constructs a [`RouteRef`](crate::model::RouteRef)
        pub fn build(self) -> crate::model::RouteRef {
            crate::model::RouteRef {
                mesh_name: self.mesh_name,
                virtual_router_name: self.virtual_router_name,
                route_name: self.route_name,
                mesh_owner: self.mesh_owner,
                resource_owner: self.resource_owner,
                arn: self.arn,
                version: self.version,
                created_at: self.created_at,
                last_updated_at: self.last_updated_at,
            }
        }
    }
}
impl RouteRef {
    /// Creates a new builder-style object to manufacture [`RouteRef`](crate::model::RouteRef)
    pub fn builder() -> crate::model::route_ref::Builder {
        crate::model::route_ref::Builder::default()
    }
}

/// <p>An object that represents a route returned by a describe operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RouteData {
    /// <p>The name of the service mesh that the route resides in.</p>
    pub mesh_name: std::option::Option<std::string::String>,
    /// <p>The virtual router that the route is associated with.</p>
    pub virtual_router_name: std::option::Option<std::string::String>,
    /// <p>The name of the route.</p>
    pub route_name: std::option::Option<std::string::String>,
    /// <p>The specifications of the route.</p>
    pub spec: std::option::Option<crate::model::RouteSpec>,
    /// <p>The associated metadata for the route.</p>
    pub metadata: std::option::Option<crate::model::ResourceMetadata>,
    /// <p>The status of the route.</p>
    pub status: std::option::Option<crate::model::RouteStatus>,
}
impl RouteData {
    /// <p>The name of the service mesh that the route resides in.</p>
    pub fn mesh_name(&self) -> std::option::Option<&str> {
        self.mesh_name.as_deref()
    }
    /// <p>The virtual router that the route is associated with.</p>
    pub fn virtual_router_name(&self) -> std::option::Option<&str> {
        self.virtual_router_name.as_deref()
    }
    /// <p>The name of the route.</p>
    pub fn route_name(&self) -> std::option::Option<&str> {
        self.route_name.as_deref()
    }
    /// <p>The specifications of the route.</p>
    pub fn spec(&self) -> std::option::Option<&crate::model::RouteSpec> {
        self.spec.as_ref()
    }
    /// <p>The associated metadata for the route.</p>
    pub fn metadata(&self) -> std::option::Option<&crate::model::ResourceMetadata> {
        self.metadata.as_ref()
    }
    /// <p>The status of the route.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::RouteStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for RouteData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RouteData");
        formatter.field("mesh_name", &self.mesh_name);
        formatter.field("virtual_router_name", &self.virtual_router_name);
        formatter.field("route_name", &self.route_name);
        formatter.field("spec", &self.spec);
        formatter.field("metadata", &self.metadata);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`RouteData`](crate::model::RouteData)
pub mod route_data {
    /// A builder for [`RouteData`](crate::model::RouteData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mesh_name: std::option::Option<std::string::String>,
        pub(crate) virtual_router_name: std::option::Option<std::string::String>,
        pub(crate) route_name: std::option::Option<std::string::String>,
        pub(crate) spec: std::option::Option<crate::model::RouteSpec>,
        pub(crate) metadata: std::option::Option<crate::model::ResourceMetadata>,
        pub(crate) status: std::option::Option<crate::model::RouteStatus>,
    }
    impl Builder {
        /// <p>The name of the service mesh that the route resides in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_name = Some(input.into());
            self
        }
        /// <p>The name of the service mesh that the route resides in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_name = input;
            self
        }
        /// <p>The virtual router that the route is associated with.</p>
        pub fn virtual_router_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_router_name = Some(input.into());
            self
        }
        /// <p>The virtual router that the route is associated with.</p>
        pub fn set_virtual_router_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_router_name = input;
            self
        }
        /// <p>The name of the route.</p>
        pub fn route_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_name = Some(input.into());
            self
        }
        /// <p>The name of the route.</p>
        pub fn set_route_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.route_name = input;
            self
        }
        /// <p>The specifications of the route.</p>
        pub fn spec(mut self, input: crate::model::RouteSpec) -> Self {
            self.spec = Some(input);
            self
        }
        /// <p>The specifications of the route.</p>
        pub fn set_spec(mut self, input: std::option::Option<crate::model::RouteSpec>) -> Self {
            self.spec = input;
            self
        }
        /// <p>The associated metadata for the route.</p>
        pub fn metadata(mut self, input: crate::model::ResourceMetadata) -> Self {
            self.metadata = Some(input);
            self
        }
        /// <p>The associated metadata for the route.</p>
        pub fn set_metadata(
            mut self,
            input: std::option::Option<crate::model::ResourceMetadata>,
        ) -> Self {
            self.metadata = input;
            self
        }
        /// <p>The status of the route.</p>
        pub fn status(mut self, input: crate::model::RouteStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the route.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::RouteStatus>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`RouteData`](crate::model::RouteData)
        pub fn build(self) -> crate::model::RouteData {
            crate::model::RouteData {
                mesh_name: self.mesh_name,
                virtual_router_name: self.virtual_router_name,
                route_name: self.route_name,
                spec: self.spec,
                metadata: self.metadata,
                status: self.status,
            }
        }
    }
}
impl RouteData {
    /// Creates a new builder-style object to manufacture [`RouteData`](crate::model::RouteData)
    pub fn builder() -> crate::model::route_data::Builder {
        crate::model::route_data::Builder::default()
    }
}

/// <p>An object that represents the current status of a route.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RouteStatus {
    /// <p>The current status for the route.</p>
    pub status: std::option::Option<crate::model::RouteStatusCode>,
}
impl RouteStatus {
    /// <p>The current status for the route.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::RouteStatusCode> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for RouteStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RouteStatus");
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`RouteStatus`](crate::model::RouteStatus)
pub mod route_status {
    /// A builder for [`RouteStatus`](crate::model::RouteStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::RouteStatusCode>,
    }
    impl Builder {
        /// <p>The current status for the route.</p>
        pub fn status(mut self, input: crate::model::RouteStatusCode) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status for the route.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::RouteStatusCode>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`RouteStatus`](crate::model::RouteStatus)
        pub fn build(self) -> crate::model::RouteStatus {
            crate::model::RouteStatus {
                status: self.status,
            }
        }
    }
}
impl RouteStatus {
    /// Creates a new builder-style object to manufacture [`RouteStatus`](crate::model::RouteStatus)
    pub fn builder() -> crate::model::route_status::Builder {
        crate::model::route_status::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RouteStatusCode {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Inactive,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RouteStatusCode {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => RouteStatusCode::Active,
            "DELETED" => RouteStatusCode::Deleted,
            "INACTIVE" => RouteStatusCode::Inactive,
            other => RouteStatusCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RouteStatusCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RouteStatusCode::from(s))
    }
}
impl RouteStatusCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RouteStatusCode::Active => "ACTIVE",
            RouteStatusCode::Deleted => "DELETED",
            RouteStatusCode::Inactive => "INACTIVE",
            RouteStatusCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "DELETED", "INACTIVE"]
    }
}
impl AsRef<str> for RouteStatusCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that represents a route specification. Specify one route type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RouteSpec {
    /// <p>The priority for the route. Routes are matched based on the specified value, where 0 is
    /// the highest priority.</p>
    pub priority: std::option::Option<i32>,
    /// <p>An object that represents the specification of an HTTP route.</p>
    pub http_route: std::option::Option<crate::model::HttpRoute>,
    /// <p>An object that represents the specification of a TCP route.</p>
    pub tcp_route: std::option::Option<crate::model::TcpRoute>,
    /// <p>An object that represents the specification of an HTTP/2 route.</p>
    pub http2_route: std::option::Option<crate::model::HttpRoute>,
    /// <p>An object that represents the specification of a gRPC route.</p>
    pub grpc_route: std::option::Option<crate::model::GrpcRoute>,
}
impl RouteSpec {
    /// <p>The priority for the route. Routes are matched based on the specified value, where 0 is
    /// the highest priority.</p>
    pub fn priority(&self) -> std::option::Option<i32> {
        self.priority
    }
    /// <p>An object that represents the specification of an HTTP route.</p>
    pub fn http_route(&self) -> std::option::Option<&crate::model::HttpRoute> {
        self.http_route.as_ref()
    }
    /// <p>An object that represents the specification of a TCP route.</p>
    pub fn tcp_route(&self) -> std::option::Option<&crate::model::TcpRoute> {
        self.tcp_route.as_ref()
    }
    /// <p>An object that represents the specification of an HTTP/2 route.</p>
    pub fn http2_route(&self) -> std::option::Option<&crate::model::HttpRoute> {
        self.http2_route.as_ref()
    }
    /// <p>An object that represents the specification of a gRPC route.</p>
    pub fn grpc_route(&self) -> std::option::Option<&crate::model::GrpcRoute> {
        self.grpc_route.as_ref()
    }
}
impl std::fmt::Debug for RouteSpec {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RouteSpec");
        formatter.field("priority", &self.priority);
        formatter.field("http_route", &self.http_route);
        formatter.field("tcp_route", &self.tcp_route);
        formatter.field("http2_route", &self.http2_route);
        formatter.field("grpc_route", &self.grpc_route);
        formatter.finish()
    }
}
/// See [`RouteSpec`](crate::model::RouteSpec)
pub mod route_spec {
    /// A builder for [`RouteSpec`](crate::model::RouteSpec)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) priority: std::option::Option<i32>,
        pub(crate) http_route: std::option::Option<crate::model::HttpRoute>,
        pub(crate) tcp_route: std::option::Option<crate::model::TcpRoute>,
        pub(crate) http2_route: std::option::Option<crate::model::HttpRoute>,
        pub(crate) grpc_route: std::option::Option<crate::model::GrpcRoute>,
    }
    impl Builder {
        /// <p>The priority for the route. Routes are matched based on the specified value, where 0 is
        /// the highest priority.</p>
        pub fn priority(mut self, input: i32) -> Self {
            self.priority = Some(input);
            self
        }
        /// <p>The priority for the route. Routes are matched based on the specified value, where 0 is
        /// the highest priority.</p>
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.priority = input;
            self
        }
        /// <p>An object that represents the specification of an HTTP route.</p>
        pub fn http_route(mut self, input: crate::model::HttpRoute) -> Self {
            self.http_route = Some(input);
            self
        }
        /// <p>An object that represents the specification of an HTTP route.</p>
        pub fn set_http_route(
            mut self,
            input: std::option::Option<crate::model::HttpRoute>,
        ) -> Self {
            self.http_route = input;
            self
        }
        /// <p>An object that represents the specification of a TCP route.</p>
        pub fn tcp_route(mut self, input: crate::model::TcpRoute) -> Self {
            self.tcp_route = Some(input);
            self
        }
        /// <p>An object that represents the specification of a TCP route.</p>
        pub fn set_tcp_route(mut self, input: std::option::Option<crate::model::TcpRoute>) -> Self {
            self.tcp_route = input;
            self
        }
        /// <p>An object that represents the specification of an HTTP/2 route.</p>
        pub fn http2_route(mut self, input: crate::model::HttpRoute) -> Self {
            self.http2_route = Some(input);
            self
        }
        /// <p>An object that represents the specification of an HTTP/2 route.</p>
        pub fn set_http2_route(
            mut self,
            input: std::option::Option<crate::model::HttpRoute>,
        ) -> Self {
            self.http2_route = input;
            self
        }
        /// <p>An object that represents the specification of a gRPC route.</p>
        pub fn grpc_route(mut self, input: crate::model::GrpcRoute) -> Self {
            self.grpc_route = Some(input);
            self
        }
        /// <p>An object that represents the specification of a gRPC route.</p>
        pub fn set_grpc_route(
            mut self,
            input: std::option::Option<crate::model::GrpcRoute>,
        ) -> Self {
            self.grpc_route = input;
            self
        }
        /// Consumes the builder and constructs a [`RouteSpec`](crate::model::RouteSpec)
        pub fn build(self) -> crate::model::RouteSpec {
            crate::model::RouteSpec {
                priority: self.priority,
                http_route: self.http_route,
                tcp_route: self.tcp_route,
                http2_route: self.http2_route,
                grpc_route: self.grpc_route,
            }
        }
    }
}
impl RouteSpec {
    /// Creates a new builder-style object to manufacture [`RouteSpec`](crate::model::RouteSpec)
    pub fn builder() -> crate::model::route_spec::Builder {
        crate::model::route_spec::Builder::default()
    }
}

/// <p>An object that represents a gRPC route type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GrpcRoute {
    /// <p>An object that represents the action to take if a match is determined.</p>
    pub action: std::option::Option<crate::model::GrpcRouteAction>,
    /// <p>An object that represents the criteria for determining a request match.</p>
    pub r#match: std::option::Option<crate::model::GrpcRouteMatch>,
    /// <p>An object that represents a retry policy.</p>
    pub retry_policy: std::option::Option<crate::model::GrpcRetryPolicy>,
    /// <p>An object that represents types of timeouts. </p>
    pub timeout: std::option::Option<crate::model::GrpcTimeout>,
}
impl GrpcRoute {
    /// <p>An object that represents the action to take if a match is determined.</p>
    pub fn action(&self) -> std::option::Option<&crate::model::GrpcRouteAction> {
        self.action.as_ref()
    }
    /// <p>An object that represents the criteria for determining a request match.</p>
    pub fn r#match(&self) -> std::option::Option<&crate::model::GrpcRouteMatch> {
        self.r#match.as_ref()
    }
    /// <p>An object that represents a retry policy.</p>
    pub fn retry_policy(&self) -> std::option::Option<&crate::model::GrpcRetryPolicy> {
        self.retry_policy.as_ref()
    }
    /// <p>An object that represents types of timeouts. </p>
    pub fn timeout(&self) -> std::option::Option<&crate::model::GrpcTimeout> {
        self.timeout.as_ref()
    }
}
impl std::fmt::Debug for GrpcRoute {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GrpcRoute");
        formatter.field("action", &self.action);
        formatter.field("r#match", &self.r#match);
        formatter.field("retry_policy", &self.retry_policy);
        formatter.field("timeout", &self.timeout);
        formatter.finish()
    }
}
/// See [`GrpcRoute`](crate::model::GrpcRoute)
pub mod grpc_route {
    /// A builder for [`GrpcRoute`](crate::model::GrpcRoute)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action: std::option::Option<crate::model::GrpcRouteAction>,
        pub(crate) r#match: std::option::Option<crate::model::GrpcRouteMatch>,
        pub(crate) retry_policy: std::option::Option<crate::model::GrpcRetryPolicy>,
        pub(crate) timeout: std::option::Option<crate::model::GrpcTimeout>,
    }
    impl Builder {
        /// <p>An object that represents the action to take if a match is determined.</p>
        pub fn action(mut self, input: crate::model::GrpcRouteAction) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>An object that represents the action to take if a match is determined.</p>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::GrpcRouteAction>,
        ) -> Self {
            self.action = input;
            self
        }
        /// <p>An object that represents the criteria for determining a request match.</p>
        pub fn r#match(mut self, input: crate::model::GrpcRouteMatch) -> Self {
            self.r#match = Some(input);
            self
        }
        /// <p>An object that represents the criteria for determining a request match.</p>
        pub fn set_match(
            mut self,
            input: std::option::Option<crate::model::GrpcRouteMatch>,
        ) -> Self {
            self.r#match = input;
            self
        }
        /// <p>An object that represents a retry policy.</p>
        pub fn retry_policy(mut self, input: crate::model::GrpcRetryPolicy) -> Self {
            self.retry_policy = Some(input);
            self
        }
        /// <p>An object that represents a retry policy.</p>
        pub fn set_retry_policy(
            mut self,
            input: std::option::Option<crate::model::GrpcRetryPolicy>,
        ) -> Self {
            self.retry_policy = input;
            self
        }
        /// <p>An object that represents types of timeouts. </p>
        pub fn timeout(mut self, input: crate::model::GrpcTimeout) -> Self {
            self.timeout = Some(input);
            self
        }
        /// <p>An object that represents types of timeouts. </p>
        pub fn set_timeout(
            mut self,
            input: std::option::Option<crate::model::GrpcTimeout>,
        ) -> Self {
            self.timeout = input;
            self
        }
        /// Consumes the builder and constructs a [`GrpcRoute`](crate::model::GrpcRoute)
        pub fn build(self) -> crate::model::GrpcRoute {
            crate::model::GrpcRoute {
                action: self.action,
                r#match: self.r#match,
                retry_policy: self.retry_policy,
                timeout: self.timeout,
            }
        }
    }
}
impl GrpcRoute {
    /// Creates a new builder-style object to manufacture [`GrpcRoute`](crate::model::GrpcRoute)
    pub fn builder() -> crate::model::grpc_route::Builder {
        crate::model::grpc_route::Builder::default()
    }
}

/// <p>An object that represents types of timeouts. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GrpcTimeout {
    /// <p>An object that represents a per request timeout. The default value is 15 seconds. If you set a higher timeout, then make sure that the higher value is set for each App Mesh
    /// resource in a conversation. For example, if a virtual node backend uses a virtual router provider to route to another virtual node, then the timeout should be greater than 15
    /// seconds for the source and destination virtual node and the route.</p>
    pub per_request: std::option::Option<crate::model::Duration>,
    /// <p>An object that represents an idle timeout. An idle timeout bounds the amount of time that a connection may be idle. The default value is none.</p>
    pub idle: std::option::Option<crate::model::Duration>,
}
impl GrpcTimeout {
    /// <p>An object that represents a per request timeout. The default value is 15 seconds. If you set a higher timeout, then make sure that the higher value is set for each App Mesh
    /// resource in a conversation. For example, if a virtual node backend uses a virtual router provider to route to another virtual node, then the timeout should be greater than 15
    /// seconds for the source and destination virtual node and the route.</p>
    pub fn per_request(&self) -> std::option::Option<&crate::model::Duration> {
        self.per_request.as_ref()
    }
    /// <p>An object that represents an idle timeout. An idle timeout bounds the amount of time that a connection may be idle. The default value is none.</p>
    pub fn idle(&self) -> std::option::Option<&crate::model::Duration> {
        self.idle.as_ref()
    }
}
impl std::fmt::Debug for GrpcTimeout {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GrpcTimeout");
        formatter.field("per_request", &self.per_request);
        formatter.field("idle", &self.idle);
        formatter.finish()
    }
}
/// See [`GrpcTimeout`](crate::model::GrpcTimeout)
pub mod grpc_timeout {
    /// A builder for [`GrpcTimeout`](crate::model::GrpcTimeout)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) per_request: std::option::Option<crate::model::Duration>,
        pub(crate) idle: std::option::Option<crate::model::Duration>,
    }
    impl Builder {
        /// <p>An object that represents a per request timeout. The default value is 15 seconds. If you set a higher timeout, then make sure that the higher value is set for each App Mesh
        /// resource in a conversation. For example, if a virtual node backend uses a virtual router provider to route to another virtual node, then the timeout should be greater than 15
        /// seconds for the source and destination virtual node and the route.</p>
        pub fn per_request(mut self, input: crate::model::Duration) -> Self {
            self.per_request = Some(input);
            self
        }
        /// <p>An object that represents a per request timeout. The default value is 15 seconds. If you set a higher timeout, then make sure that the higher value is set for each App Mesh
        /// resource in a conversation. For example, if a virtual node backend uses a virtual router provider to route to another virtual node, then the timeout should be greater than 15
        /// seconds for the source and destination virtual node and the route.</p>
        pub fn set_per_request(
            mut self,
            input: std::option::Option<crate::model::Duration>,
        ) -> Self {
            self.per_request = input;
            self
        }
        /// <p>An object that represents an idle timeout. An idle timeout bounds the amount of time that a connection may be idle. The default value is none.</p>
        pub fn idle(mut self, input: crate::model::Duration) -> Self {
            self.idle = Some(input);
            self
        }
        /// <p>An object that represents an idle timeout. An idle timeout bounds the amount of time that a connection may be idle. The default value is none.</p>
        pub fn set_idle(mut self, input: std::option::Option<crate::model::Duration>) -> Self {
            self.idle = input;
            self
        }
        /// Consumes the builder and constructs a [`GrpcTimeout`](crate::model::GrpcTimeout)
        pub fn build(self) -> crate::model::GrpcTimeout {
            crate::model::GrpcTimeout {
                per_request: self.per_request,
                idle: self.idle,
            }
        }
    }
}
impl GrpcTimeout {
    /// Creates a new builder-style object to manufacture [`GrpcTimeout`](crate::model::GrpcTimeout)
    pub fn builder() -> crate::model::grpc_timeout::Builder {
        crate::model::grpc_timeout::Builder::default()
    }
}

/// <p>An object that represents a duration of time.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Duration {
    /// <p>A number of time units.</p>
    pub value: std::option::Option<i64>,
    /// <p>A unit of time.</p>
    pub unit: std::option::Option<crate::model::DurationUnit>,
}
impl Duration {
    /// <p>A number of time units.</p>
    pub fn value(&self) -> std::option::Option<i64> {
        self.value
    }
    /// <p>A unit of time.</p>
    pub fn unit(&self) -> std::option::Option<&crate::model::DurationUnit> {
        self.unit.as_ref()
    }
}
impl std::fmt::Debug for Duration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Duration");
        formatter.field("value", &self.value);
        formatter.field("unit", &self.unit);
        formatter.finish()
    }
}
/// See [`Duration`](crate::model::Duration)
pub mod duration {
    /// A builder for [`Duration`](crate::model::Duration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) value: std::option::Option<i64>,
        pub(crate) unit: std::option::Option<crate::model::DurationUnit>,
    }
    impl Builder {
        /// <p>A number of time units.</p>
        pub fn value(mut self, input: i64) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>A number of time units.</p>
        pub fn set_value(mut self, input: std::option::Option<i64>) -> Self {
            self.value = input;
            self
        }
        /// <p>A unit of time.</p>
        pub fn unit(mut self, input: crate::model::DurationUnit) -> Self {
            self.unit = Some(input);
            self
        }
        /// <p>A unit of time.</p>
        pub fn set_unit(mut self, input: std::option::Option<crate::model::DurationUnit>) -> Self {
            self.unit = input;
            self
        }
        /// Consumes the builder and constructs a [`Duration`](crate::model::Duration)
        pub fn build(self) -> crate::model::Duration {
            crate::model::Duration {
                value: self.value,
                unit: self.unit,
            }
        }
    }
}
impl Duration {
    /// Creates a new builder-style object to manufacture [`Duration`](crate::model::Duration)
    pub fn builder() -> crate::model::duration::Builder {
        crate::model::duration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DurationUnit {
    #[allow(missing_docs)] // documentation missing in model
    Ms,
    #[allow(missing_docs)] // documentation missing in model
    S,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DurationUnit {
    fn from(s: &str) -> Self {
        match s {
            "ms" => DurationUnit::Ms,
            "s" => DurationUnit::S,
            other => DurationUnit::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DurationUnit {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DurationUnit::from(s))
    }
}
impl DurationUnit {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DurationUnit::Ms => "ms",
            DurationUnit::S => "s",
            DurationUnit::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ms", "s"]
    }
}
impl AsRef<str> for DurationUnit {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that represents a retry policy. Specify at least one value for at least one of the types of <code>RetryEvents</code>, a value for <code>maxRetries</code>, and a value for <code>perRetryTimeout</code>.
/// Both <code>server-error</code> and <code>gateway-error</code> under <code>httpRetryEvents</code> include the Envoy <code>reset</code> policy. For more information on the
/// <code>reset</code> policy, see the <a href="https://www.envoyproxy.io/docs/envoy/latest/configuration/http/http_filters/router_filter#x-envoy-retry-on">Envoy documentation</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GrpcRetryPolicy {
    /// <p>The timeout for each retry attempt.</p>
    pub per_retry_timeout: std::option::Option<crate::model::Duration>,
    /// <p>The maximum number of retry attempts.</p>
    pub max_retries: std::option::Option<i64>,
    /// <p>Specify at least one of the following values.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>server-error</b> – HTTP status codes 500, 501,
    /// 502, 503, 504, 505, 506, 507, 508, 510, and 511</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>gateway-error</b> – HTTP status codes 502,
    /// 503, and 504</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>client-error</b> – HTTP status code 409</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>stream-error</b> – Retry on refused
    /// stream</p>
    /// </li>
    /// </ul>
    pub http_retry_events: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specify a valid value. The event occurs before any processing of a request has started and is encountered when the upstream is temporarily or permanently unavailable.</p>
    pub tcp_retry_events: std::option::Option<std::vec::Vec<crate::model::TcpRetryPolicyEvent>>,
    /// <p>Specify at least one of the valid values.</p>
    pub grpc_retry_events: std::option::Option<std::vec::Vec<crate::model::GrpcRetryPolicyEvent>>,
}
impl GrpcRetryPolicy {
    /// <p>The timeout for each retry attempt.</p>
    pub fn per_retry_timeout(&self) -> std::option::Option<&crate::model::Duration> {
        self.per_retry_timeout.as_ref()
    }
    /// <p>The maximum number of retry attempts.</p>
    pub fn max_retries(&self) -> std::option::Option<i64> {
        self.max_retries
    }
    /// <p>Specify at least one of the following values.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>server-error</b> – HTTP status codes 500, 501,
    /// 502, 503, 504, 505, 506, 507, 508, 510, and 511</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>gateway-error</b> – HTTP status codes 502,
    /// 503, and 504</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>client-error</b> – HTTP status code 409</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>stream-error</b> – Retry on refused
    /// stream</p>
    /// </li>
    /// </ul>
    pub fn http_retry_events(&self) -> std::option::Option<&[std::string::String]> {
        self.http_retry_events.as_deref()
    }
    /// <p>Specify a valid value. The event occurs before any processing of a request has started and is encountered when the upstream is temporarily or permanently unavailable.</p>
    pub fn tcp_retry_events(&self) -> std::option::Option<&[crate::model::TcpRetryPolicyEvent]> {
        self.tcp_retry_events.as_deref()
    }
    /// <p>Specify at least one of the valid values.</p>
    pub fn grpc_retry_events(&self) -> std::option::Option<&[crate::model::GrpcRetryPolicyEvent]> {
        self.grpc_retry_events.as_deref()
    }
}
impl std::fmt::Debug for GrpcRetryPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GrpcRetryPolicy");
        formatter.field("per_retry_timeout", &self.per_retry_timeout);
        formatter.field("max_retries", &self.max_retries);
        formatter.field("http_retry_events", &self.http_retry_events);
        formatter.field("tcp_retry_events", &self.tcp_retry_events);
        formatter.field("grpc_retry_events", &self.grpc_retry_events);
        formatter.finish()
    }
}
/// See [`GrpcRetryPolicy`](crate::model::GrpcRetryPolicy)
pub mod grpc_retry_policy {
    /// A builder for [`GrpcRetryPolicy`](crate::model::GrpcRetryPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) per_retry_timeout: std::option::Option<crate::model::Duration>,
        pub(crate) max_retries: std::option::Option<i64>,
        pub(crate) http_retry_events: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tcp_retry_events:
            std::option::Option<std::vec::Vec<crate::model::TcpRetryPolicyEvent>>,
        pub(crate) grpc_retry_events:
            std::option::Option<std::vec::Vec<crate::model::GrpcRetryPolicyEvent>>,
    }
    impl Builder {
        /// <p>The timeout for each retry attempt.</p>
        pub fn per_retry_timeout(mut self, input: crate::model::Duration) -> Self {
            self.per_retry_timeout = Some(input);
            self
        }
        /// <p>The timeout for each retry attempt.</p>
        pub fn set_per_retry_timeout(
            mut self,
            input: std::option::Option<crate::model::Duration>,
        ) -> Self {
            self.per_retry_timeout = input;
            self
        }
        /// <p>The maximum number of retry attempts.</p>
        pub fn max_retries(mut self, input: i64) -> Self {
            self.max_retries = Some(input);
            self
        }
        /// <p>The maximum number of retry attempts.</p>
        pub fn set_max_retries(mut self, input: std::option::Option<i64>) -> Self {
            self.max_retries = input;
            self
        }
        /// Appends an item to `http_retry_events`.
        ///
        /// To override the contents of this collection use [`set_http_retry_events`](Self::set_http_retry_events).
        ///
        /// <p>Specify at least one of the following values.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>server-error</b> – HTTP status codes 500, 501,
        /// 502, 503, 504, 505, 506, 507, 508, 510, and 511</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>gateway-error</b> – HTTP status codes 502,
        /// 503, and 504</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>client-error</b> – HTTP status code 409</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>stream-error</b> – Retry on refused
        /// stream</p>
        /// </li>
        /// </ul>
        pub fn http_retry_events(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.http_retry_events.unwrap_or_default();
            v.push(input.into());
            self.http_retry_events = Some(v);
            self
        }
        /// <p>Specify at least one of the following values.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>server-error</b> – HTTP status codes 500, 501,
        /// 502, 503, 504, 505, 506, 507, 508, 510, and 511</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>gateway-error</b> – HTTP status codes 502,
        /// 503, and 504</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>client-error</b> – HTTP status code 409</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>stream-error</b> – Retry on refused
        /// stream</p>
        /// </li>
        /// </ul>
        pub fn set_http_retry_events(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.http_retry_events = input;
            self
        }
        /// Appends an item to `tcp_retry_events`.
        ///
        /// To override the contents of this collection use [`set_tcp_retry_events`](Self::set_tcp_retry_events).
        ///
        /// <p>Specify a valid value. The event occurs before any processing of a request has started and is encountered when the upstream is temporarily or permanently unavailable.</p>
        pub fn tcp_retry_events(
            mut self,
            input: impl Into<crate::model::TcpRetryPolicyEvent>,
        ) -> Self {
            let mut v = self.tcp_retry_events.unwrap_or_default();
            v.push(input.into());
            self.tcp_retry_events = Some(v);
            self
        }
        /// <p>Specify a valid value. The event occurs before any processing of a request has started and is encountered when the upstream is temporarily or permanently unavailable.</p>
        pub fn set_tcp_retry_events(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TcpRetryPolicyEvent>>,
        ) -> Self {
            self.tcp_retry_events = input;
            self
        }
        /// Appends an item to `grpc_retry_events`.
        ///
        /// To override the contents of this collection use [`set_grpc_retry_events`](Self::set_grpc_retry_events).
        ///
        /// <p>Specify at least one of the valid values.</p>
        pub fn grpc_retry_events(
            mut self,
            input: impl Into<crate::model::GrpcRetryPolicyEvent>,
        ) -> Self {
            let mut v = self.grpc_retry_events.unwrap_or_default();
            v.push(input.into());
            self.grpc_retry_events = Some(v);
            self
        }
        /// <p>Specify at least one of the valid values.</p>
        pub fn set_grpc_retry_events(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GrpcRetryPolicyEvent>>,
        ) -> Self {
            self.grpc_retry_events = input;
            self
        }
        /// Consumes the builder and constructs a [`GrpcRetryPolicy`](crate::model::GrpcRetryPolicy)
        pub fn build(self) -> crate::model::GrpcRetryPolicy {
            crate::model::GrpcRetryPolicy {
                per_retry_timeout: self.per_retry_timeout,
                max_retries: self.max_retries,
                http_retry_events: self.http_retry_events,
                tcp_retry_events: self.tcp_retry_events,
                grpc_retry_events: self.grpc_retry_events,
            }
        }
    }
}
impl GrpcRetryPolicy {
    /// Creates a new builder-style object to manufacture [`GrpcRetryPolicy`](crate::model::GrpcRetryPolicy)
    pub fn builder() -> crate::model::grpc_retry_policy::Builder {
        crate::model::grpc_retry_policy::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum GrpcRetryPolicyEvent {
    #[allow(missing_docs)] // documentation missing in model
    Cancelled,
    #[allow(missing_docs)] // documentation missing in model
    DeadlineExceeded,
    #[allow(missing_docs)] // documentation missing in model
    Internal,
    #[allow(missing_docs)] // documentation missing in model
    ResourceExhausted,
    #[allow(missing_docs)] // documentation missing in model
    Unavailable,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for GrpcRetryPolicyEvent {
    fn from(s: &str) -> Self {
        match s {
            "cancelled" => GrpcRetryPolicyEvent::Cancelled,
            "deadline-exceeded" => GrpcRetryPolicyEvent::DeadlineExceeded,
            "internal" => GrpcRetryPolicyEvent::Internal,
            "resource-exhausted" => GrpcRetryPolicyEvent::ResourceExhausted,
            "unavailable" => GrpcRetryPolicyEvent::Unavailable,
            other => GrpcRetryPolicyEvent::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for GrpcRetryPolicyEvent {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(GrpcRetryPolicyEvent::from(s))
    }
}
impl GrpcRetryPolicyEvent {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            GrpcRetryPolicyEvent::Cancelled => "cancelled",
            GrpcRetryPolicyEvent::DeadlineExceeded => "deadline-exceeded",
            GrpcRetryPolicyEvent::Internal => "internal",
            GrpcRetryPolicyEvent::ResourceExhausted => "resource-exhausted",
            GrpcRetryPolicyEvent::Unavailable => "unavailable",
            GrpcRetryPolicyEvent::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "cancelled",
            "deadline-exceeded",
            "internal",
            "resource-exhausted",
            "unavailable",
        ]
    }
}
impl AsRef<str> for GrpcRetryPolicyEvent {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TcpRetryPolicyEvent {
    #[allow(missing_docs)] // documentation missing in model
    ConnectionError,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TcpRetryPolicyEvent {
    fn from(s: &str) -> Self {
        match s {
            "connection-error" => TcpRetryPolicyEvent::ConnectionError,
            other => TcpRetryPolicyEvent::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TcpRetryPolicyEvent {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TcpRetryPolicyEvent::from(s))
    }
}
impl TcpRetryPolicyEvent {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TcpRetryPolicyEvent::ConnectionError => "connection-error",
            TcpRetryPolicyEvent::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["connection-error"]
    }
}
impl AsRef<str> for TcpRetryPolicyEvent {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that represents the criteria for determining a request match.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GrpcRouteMatch {
    /// <p>The fully qualified domain name for the service to match from the request.</p>
    pub service_name: std::option::Option<std::string::String>,
    /// <p>The method name to match from the request. If you specify a name, you must also specify
    /// a <code>serviceName</code>.</p>
    pub method_name: std::option::Option<std::string::String>,
    /// <p>An object that represents the data to match from the request.</p>
    pub metadata: std::option::Option<std::vec::Vec<crate::model::GrpcRouteMetadata>>,
}
impl GrpcRouteMatch {
    /// <p>The fully qualified domain name for the service to match from the request.</p>
    pub fn service_name(&self) -> std::option::Option<&str> {
        self.service_name.as_deref()
    }
    /// <p>The method name to match from the request. If you specify a name, you must also specify
    /// a <code>serviceName</code>.</p>
    pub fn method_name(&self) -> std::option::Option<&str> {
        self.method_name.as_deref()
    }
    /// <p>An object that represents the data to match from the request.</p>
    pub fn metadata(&self) -> std::option::Option<&[crate::model::GrpcRouteMetadata]> {
        self.metadata.as_deref()
    }
}
impl std::fmt::Debug for GrpcRouteMatch {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GrpcRouteMatch");
        formatter.field("service_name", &self.service_name);
        formatter.field("method_name", &self.method_name);
        formatter.field("metadata", &self.metadata);
        formatter.finish()
    }
}
/// See [`GrpcRouteMatch`](crate::model::GrpcRouteMatch)
pub mod grpc_route_match {
    /// A builder for [`GrpcRouteMatch`](crate::model::GrpcRouteMatch)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_name: std::option::Option<std::string::String>,
        pub(crate) method_name: std::option::Option<std::string::String>,
        pub(crate) metadata: std::option::Option<std::vec::Vec<crate::model::GrpcRouteMetadata>>,
    }
    impl Builder {
        /// <p>The fully qualified domain name for the service to match from the request.</p>
        pub fn service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_name = Some(input.into());
            self
        }
        /// <p>The fully qualified domain name for the service to match from the request.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_name = input;
            self
        }
        /// <p>The method name to match from the request. If you specify a name, you must also specify
        /// a <code>serviceName</code>.</p>
        pub fn method_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.method_name = Some(input.into());
            self
        }
        /// <p>The method name to match from the request. If you specify a name, you must also specify
        /// a <code>serviceName</code>.</p>
        pub fn set_method_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.method_name = input;
            self
        }
        /// Appends an item to `metadata`.
        ///
        /// To override the contents of this collection use [`set_metadata`](Self::set_metadata).
        ///
        /// <p>An object that represents the data to match from the request.</p>
        pub fn metadata(mut self, input: impl Into<crate::model::GrpcRouteMetadata>) -> Self {
            let mut v = self.metadata.unwrap_or_default();
            v.push(input.into());
            self.metadata = Some(v);
            self
        }
        /// <p>An object that represents the data to match from the request.</p>
        pub fn set_metadata(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GrpcRouteMetadata>>,
        ) -> Self {
            self.metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`GrpcRouteMatch`](crate::model::GrpcRouteMatch)
        pub fn build(self) -> crate::model::GrpcRouteMatch {
            crate::model::GrpcRouteMatch {
                service_name: self.service_name,
                method_name: self.method_name,
                metadata: self.metadata,
            }
        }
    }
}
impl GrpcRouteMatch {
    /// Creates a new builder-style object to manufacture [`GrpcRouteMatch`](crate::model::GrpcRouteMatch)
    pub fn builder() -> crate::model::grpc_route_match::Builder {
        crate::model::grpc_route_match::Builder::default()
    }
}

/// <p>An object that represents the match metadata for the route.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GrpcRouteMetadata {
    /// <p>The name of the route.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Specify <code>True</code> to match anything except the match criteria. The default value is <code>False</code>.</p>
    pub invert: std::option::Option<bool>,
    /// <p>An object that represents the data to match from the request.</p>
    pub r#match: std::option::Option<crate::model::GrpcRouteMetadataMatchMethod>,
}
impl GrpcRouteMetadata {
    /// <p>The name of the route.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Specify <code>True</code> to match anything except the match criteria. The default value is <code>False</code>.</p>
    pub fn invert(&self) -> std::option::Option<bool> {
        self.invert
    }
    /// <p>An object that represents the data to match from the request.</p>
    pub fn r#match(&self) -> std::option::Option<&crate::model::GrpcRouteMetadataMatchMethod> {
        self.r#match.as_ref()
    }
}
impl std::fmt::Debug for GrpcRouteMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GrpcRouteMetadata");
        formatter.field("name", &self.name);
        formatter.field("invert", &self.invert);
        formatter.field("r#match", &self.r#match);
        formatter.finish()
    }
}
/// See [`GrpcRouteMetadata`](crate::model::GrpcRouteMetadata)
pub mod grpc_route_metadata {
    /// A builder for [`GrpcRouteMetadata`](crate::model::GrpcRouteMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) invert: std::option::Option<bool>,
        pub(crate) r#match: std::option::Option<crate::model::GrpcRouteMetadataMatchMethod>,
    }
    impl Builder {
        /// <p>The name of the route.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the route.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Specify <code>True</code> to match anything except the match criteria. The default value is <code>False</code>.</p>
        pub fn invert(mut self, input: bool) -> Self {
            self.invert = Some(input);
            self
        }
        /// <p>Specify <code>True</code> to match anything except the match criteria. The default value is <code>False</code>.</p>
        pub fn set_invert(mut self, input: std::option::Option<bool>) -> Self {
            self.invert = input;
            self
        }
        /// <p>An object that represents the data to match from the request.</p>
        pub fn r#match(mut self, input: crate::model::GrpcRouteMetadataMatchMethod) -> Self {
            self.r#match = Some(input);
            self
        }
        /// <p>An object that represents the data to match from the request.</p>
        pub fn set_match(
            mut self,
            input: std::option::Option<crate::model::GrpcRouteMetadataMatchMethod>,
        ) -> Self {
            self.r#match = input;
            self
        }
        /// Consumes the builder and constructs a [`GrpcRouteMetadata`](crate::model::GrpcRouteMetadata)
        pub fn build(self) -> crate::model::GrpcRouteMetadata {
            crate::model::GrpcRouteMetadata {
                name: self.name,
                invert: self.invert,
                r#match: self.r#match,
            }
        }
    }
}
impl GrpcRouteMetadata {
    /// Creates a new builder-style object to manufacture [`GrpcRouteMetadata`](crate::model::GrpcRouteMetadata)
    pub fn builder() -> crate::model::grpc_route_metadata::Builder {
        crate::model::grpc_route_metadata::Builder::default()
    }
}

/// <p>An object that represents the match method. Specify one of the match values.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum GrpcRouteMetadataMatchMethod {
    /// <p>The value sent by the client must match the specified value exactly.</p>
    Exact(std::string::String),
    /// <p>The value sent by the client must begin with the specified characters.</p>
    Prefix(std::string::String),
    /// <p>An object that represents the range of values to match on.</p>
    Range(crate::model::MatchRange),
    /// <p>The value sent by the client must include the specified characters.</p>
    Regex(std::string::String),
    /// <p>The value sent by the client must end with the specified characters.</p>
    Suffix(std::string::String),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl GrpcRouteMetadataMatchMethod {
    /// Tries to convert the enum instance into [`Exact`](crate::model::GrpcRouteMetadataMatchMethod::Exact), extracting the inner [`String`](std::string::String).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_exact(&self) -> std::result::Result<&std::string::String, &Self> {
        if let GrpcRouteMetadataMatchMethod::Exact(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Exact`](crate::model::GrpcRouteMetadataMatchMethod::Exact).
    pub fn is_exact(&self) -> bool {
        self.as_exact().is_ok()
    }
    /// Tries to convert the enum instance into [`Prefix`](crate::model::GrpcRouteMetadataMatchMethod::Prefix), extracting the inner [`String`](std::string::String).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_prefix(&self) -> std::result::Result<&std::string::String, &Self> {
        if let GrpcRouteMetadataMatchMethod::Prefix(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Prefix`](crate::model::GrpcRouteMetadataMatchMethod::Prefix).
    pub fn is_prefix(&self) -> bool {
        self.as_prefix().is_ok()
    }
    /// Tries to convert the enum instance into [`Range`](crate::model::GrpcRouteMetadataMatchMethod::Range), extracting the inner [`MatchRange`](crate::model::MatchRange).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_range(&self) -> std::result::Result<&crate::model::MatchRange, &Self> {
        if let GrpcRouteMetadataMatchMethod::Range(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Range`](crate::model::GrpcRouteMetadataMatchMethod::Range).
    pub fn is_range(&self) -> bool {
        self.as_range().is_ok()
    }
    /// Tries to convert the enum instance into [`Regex`](crate::model::GrpcRouteMetadataMatchMethod::Regex), extracting the inner [`String`](std::string::String).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_regex(&self) -> std::result::Result<&std::string::String, &Self> {
        if let GrpcRouteMetadataMatchMethod::Regex(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Regex`](crate::model::GrpcRouteMetadataMatchMethod::Regex).
    pub fn is_regex(&self) -> bool {
        self.as_regex().is_ok()
    }
    /// Tries to convert the enum instance into [`Suffix`](crate::model::GrpcRouteMetadataMatchMethod::Suffix), extracting the inner [`String`](std::string::String).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_suffix(&self) -> std::result::Result<&std::string::String, &Self> {
        if let GrpcRouteMetadataMatchMethod::Suffix(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Suffix`](crate::model::GrpcRouteMetadataMatchMethod::Suffix).
    pub fn is_suffix(&self) -> bool {
        self.as_suffix().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

/// <p>An object that represents the range of values to match on. The first character of the range is included in the range, though the last character is not. For example, if the range specified were 1-100, only values 1-99 would be matched.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MatchRange {
    /// <p>The start of the range.</p>
    pub start: std::option::Option<i64>,
    /// <p>The end of the range.</p>
    pub end: std::option::Option<i64>,
}
impl MatchRange {
    /// <p>The start of the range.</p>
    pub fn start(&self) -> std::option::Option<i64> {
        self.start
    }
    /// <p>The end of the range.</p>
    pub fn end(&self) -> std::option::Option<i64> {
        self.end
    }
}
impl std::fmt::Debug for MatchRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MatchRange");
        formatter.field("start", &self.start);
        formatter.field("end", &self.end);
        formatter.finish()
    }
}
/// See [`MatchRange`](crate::model::MatchRange)
pub mod match_range {
    /// A builder for [`MatchRange`](crate::model::MatchRange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start: std::option::Option<i64>,
        pub(crate) end: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The start of the range.</p>
        pub fn start(mut self, input: i64) -> Self {
            self.start = Some(input);
            self
        }
        /// <p>The start of the range.</p>
        pub fn set_start(mut self, input: std::option::Option<i64>) -> Self {
            self.start = input;
            self
        }
        /// <p>The end of the range.</p>
        pub fn end(mut self, input: i64) -> Self {
            self.end = Some(input);
            self
        }
        /// <p>The end of the range.</p>
        pub fn set_end(mut self, input: std::option::Option<i64>) -> Self {
            self.end = input;
            self
        }
        /// Consumes the builder and constructs a [`MatchRange`](crate::model::MatchRange)
        pub fn build(self) -> crate::model::MatchRange {
            crate::model::MatchRange {
                start: self.start,
                end: self.end,
            }
        }
    }
}
impl MatchRange {
    /// Creates a new builder-style object to manufacture [`MatchRange`](crate::model::MatchRange)
    pub fn builder() -> crate::model::match_range::Builder {
        crate::model::match_range::Builder::default()
    }
}

/// <p>An object that represents the action to take if a match is determined.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GrpcRouteAction {
    /// <p>An object that represents the targets that traffic is routed to when a request matches the route.</p>
    pub weighted_targets: std::option::Option<std::vec::Vec<crate::model::WeightedTarget>>,
}
impl GrpcRouteAction {
    /// <p>An object that represents the targets that traffic is routed to when a request matches the route.</p>
    pub fn weighted_targets(&self) -> std::option::Option<&[crate::model::WeightedTarget]> {
        self.weighted_targets.as_deref()
    }
}
impl std::fmt::Debug for GrpcRouteAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GrpcRouteAction");
        formatter.field("weighted_targets", &self.weighted_targets);
        formatter.finish()
    }
}
/// See [`GrpcRouteAction`](crate::model::GrpcRouteAction)
pub mod grpc_route_action {
    /// A builder for [`GrpcRouteAction`](crate::model::GrpcRouteAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) weighted_targets:
            std::option::Option<std::vec::Vec<crate::model::WeightedTarget>>,
    }
    impl Builder {
        /// Appends an item to `weighted_targets`.
        ///
        /// To override the contents of this collection use [`set_weighted_targets`](Self::set_weighted_targets).
        ///
        /// <p>An object that represents the targets that traffic is routed to when a request matches the route.</p>
        pub fn weighted_targets(mut self, input: impl Into<crate::model::WeightedTarget>) -> Self {
            let mut v = self.weighted_targets.unwrap_or_default();
            v.push(input.into());
            self.weighted_targets = Some(v);
            self
        }
        /// <p>An object that represents the targets that traffic is routed to when a request matches the route.</p>
        pub fn set_weighted_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::WeightedTarget>>,
        ) -> Self {
            self.weighted_targets = input;
            self
        }
        /// Consumes the builder and constructs a [`GrpcRouteAction`](crate::model::GrpcRouteAction)
        pub fn build(self) -> crate::model::GrpcRouteAction {
            crate::model::GrpcRouteAction {
                weighted_targets: self.weighted_targets,
            }
        }
    }
}
impl GrpcRouteAction {
    /// Creates a new builder-style object to manufacture [`GrpcRouteAction`](crate::model::GrpcRouteAction)
    pub fn builder() -> crate::model::grpc_route_action::Builder {
        crate::model::grpc_route_action::Builder::default()
    }
}

/// <p>An object that represents a target and its relative weight. Traffic is distributed
/// across targets according to their relative weight. For example, a weighted target with a
/// relative weight of 50 receives five times as much traffic as one with a relative weight of
/// 10. The total weight for all targets combined must be less than or equal to 100.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WeightedTarget {
    /// <p>The virtual node to associate with the weighted target.</p>
    pub virtual_node: std::option::Option<std::string::String>,
    /// <p>The relative weight of the weighted target.</p>
    pub weight: i32,
}
impl WeightedTarget {
    /// <p>The virtual node to associate with the weighted target.</p>
    pub fn virtual_node(&self) -> std::option::Option<&str> {
        self.virtual_node.as_deref()
    }
    /// <p>The relative weight of the weighted target.</p>
    pub fn weight(&self) -> i32 {
        self.weight
    }
}
impl std::fmt::Debug for WeightedTarget {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WeightedTarget");
        formatter.field("virtual_node", &self.virtual_node);
        formatter.field("weight", &self.weight);
        formatter.finish()
    }
}
/// See [`WeightedTarget`](crate::model::WeightedTarget)
pub mod weighted_target {
    /// A builder for [`WeightedTarget`](crate::model::WeightedTarget)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_node: std::option::Option<std::string::String>,
        pub(crate) weight: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The virtual node to associate with the weighted target.</p>
        pub fn virtual_node(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_node = Some(input.into());
            self
        }
        /// <p>The virtual node to associate with the weighted target.</p>
        pub fn set_virtual_node(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.virtual_node = input;
            self
        }
        /// <p>The relative weight of the weighted target.</p>
        pub fn weight(mut self, input: i32) -> Self {
            self.weight = Some(input);
            self
        }
        /// <p>The relative weight of the weighted target.</p>
        pub fn set_weight(mut self, input: std::option::Option<i32>) -> Self {
            self.weight = input;
            self
        }
        /// Consumes the builder and constructs a [`WeightedTarget`](crate::model::WeightedTarget)
        pub fn build(self) -> crate::model::WeightedTarget {
            crate::model::WeightedTarget {
                virtual_node: self.virtual_node,
                weight: self.weight.unwrap_or_default(),
            }
        }
    }
}
impl WeightedTarget {
    /// Creates a new builder-style object to manufacture [`WeightedTarget`](crate::model::WeightedTarget)
    pub fn builder() -> crate::model::weighted_target::Builder {
        crate::model::weighted_target::Builder::default()
    }
}

/// <p>An object that represents an HTTP or HTTP/2 route type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HttpRoute {
    /// <p>An object that represents the criteria for determining a request match.</p>
    pub r#match: std::option::Option<crate::model::HttpRouteMatch>,
    /// <p>An object that represents the action to take if a match is determined.</p>
    pub action: std::option::Option<crate::model::HttpRouteAction>,
    /// <p>An object that represents a retry policy.</p>
    pub retry_policy: std::option::Option<crate::model::HttpRetryPolicy>,
    /// <p>An object that represents types of timeouts. </p>
    pub timeout: std::option::Option<crate::model::HttpTimeout>,
}
impl HttpRoute {
    /// <p>An object that represents the criteria for determining a request match.</p>
    pub fn r#match(&self) -> std::option::Option<&crate::model::HttpRouteMatch> {
        self.r#match.as_ref()
    }
    /// <p>An object that represents the action to take if a match is determined.</p>
    pub fn action(&self) -> std::option::Option<&crate::model::HttpRouteAction> {
        self.action.as_ref()
    }
    /// <p>An object that represents a retry policy.</p>
    pub fn retry_policy(&self) -> std::option::Option<&crate::model::HttpRetryPolicy> {
        self.retry_policy.as_ref()
    }
    /// <p>An object that represents types of timeouts. </p>
    pub fn timeout(&self) -> std::option::Option<&crate::model::HttpTimeout> {
        self.timeout.as_ref()
    }
}
impl std::fmt::Debug for HttpRoute {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HttpRoute");
        formatter.field("r#match", &self.r#match);
        formatter.field("action", &self.action);
        formatter.field("retry_policy", &self.retry_policy);
        formatter.field("timeout", &self.timeout);
        formatter.finish()
    }
}
/// See [`HttpRoute`](crate::model::HttpRoute)
pub mod http_route {
    /// A builder for [`HttpRoute`](crate::model::HttpRoute)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#match: std::option::Option<crate::model::HttpRouteMatch>,
        pub(crate) action: std::option::Option<crate::model::HttpRouteAction>,
        pub(crate) retry_policy: std::option::Option<crate::model::HttpRetryPolicy>,
        pub(crate) timeout: std::option::Option<crate::model::HttpTimeout>,
    }
    impl Builder {
        /// <p>An object that represents the criteria for determining a request match.</p>
        pub fn r#match(mut self, input: crate::model::HttpRouteMatch) -> Self {
            self.r#match = Some(input);
            self
        }
        /// <p>An object that represents the criteria for determining a request match.</p>
        pub fn set_match(
            mut self,
            input: std::option::Option<crate::model::HttpRouteMatch>,
        ) -> Self {
            self.r#match = input;
            self
        }
        /// <p>An object that represents the action to take if a match is determined.</p>
        pub fn action(mut self, input: crate::model::HttpRouteAction) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>An object that represents the action to take if a match is determined.</p>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::HttpRouteAction>,
        ) -> Self {
            self.action = input;
            self
        }
        /// <p>An object that represents a retry policy.</p>
        pub fn retry_policy(mut self, input: crate::model::HttpRetryPolicy) -> Self {
            self.retry_policy = Some(input);
            self
        }
        /// <p>An object that represents a retry policy.</p>
        pub fn set_retry_policy(
            mut self,
            input: std::option::Option<crate::model::HttpRetryPolicy>,
        ) -> Self {
            self.retry_policy = input;
            self
        }
        /// <p>An object that represents types of timeouts. </p>
        pub fn timeout(mut self, input: crate::model::HttpTimeout) -> Self {
            self.timeout = Some(input);
            self
        }
        /// <p>An object that represents types of timeouts. </p>
        pub fn set_timeout(
            mut self,
            input: std::option::Option<crate::model::HttpTimeout>,
        ) -> Self {
            self.timeout = input;
            self
        }
        /// Consumes the builder and constructs a [`HttpRoute`](crate::model::HttpRoute)
        pub fn build(self) -> crate::model::HttpRoute {
            crate::model::HttpRoute {
                r#match: self.r#match,
                action: self.action,
                retry_policy: self.retry_policy,
                timeout: self.timeout,
            }
        }
    }
}
impl HttpRoute {
    /// Creates a new builder-style object to manufacture [`HttpRoute`](crate::model::HttpRoute)
    pub fn builder() -> crate::model::http_route::Builder {
        crate::model::http_route::Builder::default()
    }
}

/// <p>An object that represents types of timeouts. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HttpTimeout {
    /// <p>An object that represents a per request timeout. The default value is 15 seconds. If you set a higher timeout, then make sure that the higher value is set for each App Mesh
    /// resource in a conversation. For example, if a virtual node backend uses a virtual router provider to route to another virtual node, then the timeout should be greater than 15
    /// seconds for the source and destination virtual node and the route.</p>
    pub per_request: std::option::Option<crate::model::Duration>,
    /// <p>An object that represents an idle timeout. An idle timeout bounds the amount of time that a connection may be idle. The default value is none.</p>
    pub idle: std::option::Option<crate::model::Duration>,
}
impl HttpTimeout {
    /// <p>An object that represents a per request timeout. The default value is 15 seconds. If you set a higher timeout, then make sure that the higher value is set for each App Mesh
    /// resource in a conversation. For example, if a virtual node backend uses a virtual router provider to route to another virtual node, then the timeout should be greater than 15
    /// seconds for the source and destination virtual node and the route.</p>
    pub fn per_request(&self) -> std::option::Option<&crate::model::Duration> {
        self.per_request.as_ref()
    }
    /// <p>An object that represents an idle timeout. An idle timeout bounds the amount of time that a connection may be idle. The default value is none.</p>
    pub fn idle(&self) -> std::option::Option<&crate::model::Duration> {
        self.idle.as_ref()
    }
}
impl std::fmt::Debug for HttpTimeout {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HttpTimeout");
        formatter.field("per_request", &self.per_request);
        formatter.field("idle", &self.idle);
        formatter.finish()
    }
}
/// See [`HttpTimeout`](crate::model::HttpTimeout)
pub mod http_timeout {
    /// A builder for [`HttpTimeout`](crate::model::HttpTimeout)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) per_request: std::option::Option<crate::model::Duration>,
        pub(crate) idle: std::option::Option<crate::model::Duration>,
    }
    impl Builder {
        /// <p>An object that represents a per request timeout. The default value is 15 seconds. If you set a higher timeout, then make sure that the higher value is set for each App Mesh
        /// resource in a conversation. For example, if a virtual node backend uses a virtual router provider to route to another virtual node, then the timeout should be greater than 15
        /// seconds for the source and destination virtual node and the route.</p>
        pub fn per_request(mut self, input: crate::model::Duration) -> Self {
            self.per_request = Some(input);
            self
        }
        /// <p>An object that represents a per request timeout. The default value is 15 seconds. If you set a higher timeout, then make sure that the higher value is set for each App Mesh
        /// resource in a conversation. For example, if a virtual node backend uses a virtual router provider to route to another virtual node, then the timeout should be greater than 15
        /// seconds for the source and destination virtual node and the route.</p>
        pub fn set_per_request(
            mut self,
            input: std::option::Option<crate::model::Duration>,
        ) -> Self {
            self.per_request = input;
            self
        }
        /// <p>An object that represents an idle timeout. An idle timeout bounds the amount of time that a connection may be idle. The default value is none.</p>
        pub fn idle(mut self, input: crate::model::Duration) -> Self {
            self.idle = Some(input);
            self
        }
        /// <p>An object that represents an idle timeout. An idle timeout bounds the amount of time that a connection may be idle. The default value is none.</p>
        pub fn set_idle(mut self, input: std::option::Option<crate::model::Duration>) -> Self {
            self.idle = input;
            self
        }
        /// Consumes the builder and constructs a [`HttpTimeout`](crate::model::HttpTimeout)
        pub fn build(self) -> crate::model::HttpTimeout {
            crate::model::HttpTimeout {
                per_request: self.per_request,
                idle: self.idle,
            }
        }
    }
}
impl HttpTimeout {
    /// Creates a new builder-style object to manufacture [`HttpTimeout`](crate::model::HttpTimeout)
    pub fn builder() -> crate::model::http_timeout::Builder {
        crate::model::http_timeout::Builder::default()
    }
}

/// <p>An object that represents a retry policy. Specify at least one value for at least one of the types of <code>RetryEvents</code>, a value for <code>maxRetries</code>, and a value for <code>perRetryTimeout</code>.
/// Both <code>server-error</code> and <code>gateway-error</code> under <code>httpRetryEvents</code> include the Envoy <code>reset</code> policy. For more information on the
/// <code>reset</code> policy, see the <a href="https://www.envoyproxy.io/docs/envoy/latest/configuration/http/http_filters/router_filter#x-envoy-retry-on">Envoy documentation</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HttpRetryPolicy {
    /// <p>The timeout for each retry attempt.</p>
    pub per_retry_timeout: std::option::Option<crate::model::Duration>,
    /// <p>The maximum number of retry attempts.</p>
    pub max_retries: std::option::Option<i64>,
    /// <p>Specify at least one of the following values.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>server-error</b> – HTTP status codes 500, 501,
    /// 502, 503, 504, 505, 506, 507, 508, 510, and 511</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>gateway-error</b> – HTTP status codes 502,
    /// 503, and 504</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>client-error</b> – HTTP status code 409</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>stream-error</b> – Retry on refused
    /// stream</p>
    /// </li>
    /// </ul>
    pub http_retry_events: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specify a valid value. The event occurs before any processing of a request has started and is encountered when the upstream is temporarily or permanently unavailable.</p>
    pub tcp_retry_events: std::option::Option<std::vec::Vec<crate::model::TcpRetryPolicyEvent>>,
}
impl HttpRetryPolicy {
    /// <p>The timeout for each retry attempt.</p>
    pub fn per_retry_timeout(&self) -> std::option::Option<&crate::model::Duration> {
        self.per_retry_timeout.as_ref()
    }
    /// <p>The maximum number of retry attempts.</p>
    pub fn max_retries(&self) -> std::option::Option<i64> {
        self.max_retries
    }
    /// <p>Specify at least one of the following values.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>server-error</b> – HTTP status codes 500, 501,
    /// 502, 503, 504, 505, 506, 507, 508, 510, and 511</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>gateway-error</b> – HTTP status codes 502,
    /// 503, and 504</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>client-error</b> – HTTP status code 409</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>stream-error</b> – Retry on refused
    /// stream</p>
    /// </li>
    /// </ul>
    pub fn http_retry_events(&self) -> std::option::Option<&[std::string::String]> {
        self.http_retry_events.as_deref()
    }
    /// <p>Specify a valid value. The event occurs before any processing of a request has started and is encountered when the upstream is temporarily or permanently unavailable.</p>
    pub fn tcp_retry_events(&self) -> std::option::Option<&[crate::model::TcpRetryPolicyEvent]> {
        self.tcp_retry_events.as_deref()
    }
}
impl std::fmt::Debug for HttpRetryPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HttpRetryPolicy");
        formatter.field("per_retry_timeout", &self.per_retry_timeout);
        formatter.field("max_retries", &self.max_retries);
        formatter.field("http_retry_events", &self.http_retry_events);
        formatter.field("tcp_retry_events", &self.tcp_retry_events);
        formatter.finish()
    }
}
/// See [`HttpRetryPolicy`](crate::model::HttpRetryPolicy)
pub mod http_retry_policy {
    /// A builder for [`HttpRetryPolicy`](crate::model::HttpRetryPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) per_retry_timeout: std::option::Option<crate::model::Duration>,
        pub(crate) max_retries: std::option::Option<i64>,
        pub(crate) http_retry_events: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tcp_retry_events:
            std::option::Option<std::vec::Vec<crate::model::TcpRetryPolicyEvent>>,
    }
    impl Builder {
        /// <p>The timeout for each retry attempt.</p>
        pub fn per_retry_timeout(mut self, input: crate::model::Duration) -> Self {
            self.per_retry_timeout = Some(input);
            self
        }
        /// <p>The timeout for each retry attempt.</p>
        pub fn set_per_retry_timeout(
            mut self,
            input: std::option::Option<crate::model::Duration>,
        ) -> Self {
            self.per_retry_timeout = input;
            self
        }
        /// <p>The maximum number of retry attempts.</p>
        pub fn max_retries(mut self, input: i64) -> Self {
            self.max_retries = Some(input);
            self
        }
        /// <p>The maximum number of retry attempts.</p>
        pub fn set_max_retries(mut self, input: std::option::Option<i64>) -> Self {
            self.max_retries = input;
            self
        }
        /// Appends an item to `http_retry_events`.
        ///
        /// To override the contents of this collection use [`set_http_retry_events`](Self::set_http_retry_events).
        ///
        /// <p>Specify at least one of the following values.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>server-error</b> – HTTP status codes 500, 501,
        /// 502, 503, 504, 505, 506, 507, 508, 510, and 511</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>gateway-error</b> – HTTP status codes 502,
        /// 503, and 504</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>client-error</b> – HTTP status code 409</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>stream-error</b> – Retry on refused
        /// stream</p>
        /// </li>
        /// </ul>
        pub fn http_retry_events(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.http_retry_events.unwrap_or_default();
            v.push(input.into());
            self.http_retry_events = Some(v);
            self
        }
        /// <p>Specify at least one of the following values.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>server-error</b> – HTTP status codes 500, 501,
        /// 502, 503, 504, 505, 506, 507, 508, 510, and 511</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>gateway-error</b> – HTTP status codes 502,
        /// 503, and 504</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>client-error</b> – HTTP status code 409</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>stream-error</b> – Retry on refused
        /// stream</p>
        /// </li>
        /// </ul>
        pub fn set_http_retry_events(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.http_retry_events = input;
            self
        }
        /// Appends an item to `tcp_retry_events`.
        ///
        /// To override the contents of this collection use [`set_tcp_retry_events`](Self::set_tcp_retry_events).
        ///
        /// <p>Specify a valid value. The event occurs before any processing of a request has started and is encountered when the upstream is temporarily or permanently unavailable.</p>
        pub fn tcp_retry_events(
            mut self,
            input: impl Into<crate::model::TcpRetryPolicyEvent>,
        ) -> Self {
            let mut v = self.tcp_retry_events.unwrap_or_default();
            v.push(input.into());
            self.tcp_retry_events = Some(v);
            self
        }
        /// <p>Specify a valid value. The event occurs before any processing of a request has started and is encountered when the upstream is temporarily or permanently unavailable.</p>
        pub fn set_tcp_retry_events(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TcpRetryPolicyEvent>>,
        ) -> Self {
            self.tcp_retry_events = input;
            self
        }
        /// Consumes the builder and constructs a [`HttpRetryPolicy`](crate::model::HttpRetryPolicy)
        pub fn build(self) -> crate::model::HttpRetryPolicy {
            crate::model::HttpRetryPolicy {
                per_retry_timeout: self.per_retry_timeout,
                max_retries: self.max_retries,
                http_retry_events: self.http_retry_events,
                tcp_retry_events: self.tcp_retry_events,
            }
        }
    }
}
impl HttpRetryPolicy {
    /// Creates a new builder-style object to manufacture [`HttpRetryPolicy`](crate::model::HttpRetryPolicy)
    pub fn builder() -> crate::model::http_retry_policy::Builder {
        crate::model::http_retry_policy::Builder::default()
    }
}

/// <p>An object that represents the action to take if a match is determined.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HttpRouteAction {
    /// <p>An object that represents the targets that traffic is routed to when a request matches the route.</p>
    pub weighted_targets: std::option::Option<std::vec::Vec<crate::model::WeightedTarget>>,
}
impl HttpRouteAction {
    /// <p>An object that represents the targets that traffic is routed to when a request matches the route.</p>
    pub fn weighted_targets(&self) -> std::option::Option<&[crate::model::WeightedTarget]> {
        self.weighted_targets.as_deref()
    }
}
impl std::fmt::Debug for HttpRouteAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HttpRouteAction");
        formatter.field("weighted_targets", &self.weighted_targets);
        formatter.finish()
    }
}
/// See [`HttpRouteAction`](crate::model::HttpRouteAction)
pub mod http_route_action {
    /// A builder for [`HttpRouteAction`](crate::model::HttpRouteAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) weighted_targets:
            std::option::Option<std::vec::Vec<crate::model::WeightedTarget>>,
    }
    impl Builder {
        /// Appends an item to `weighted_targets`.
        ///
        /// To override the contents of this collection use [`set_weighted_targets`](Self::set_weighted_targets).
        ///
        /// <p>An object that represents the targets that traffic is routed to when a request matches the route.</p>
        pub fn weighted_targets(mut self, input: impl Into<crate::model::WeightedTarget>) -> Self {
            let mut v = self.weighted_targets.unwrap_or_default();
            v.push(input.into());
            self.weighted_targets = Some(v);
            self
        }
        /// <p>An object that represents the targets that traffic is routed to when a request matches the route.</p>
        pub fn set_weighted_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::WeightedTarget>>,
        ) -> Self {
            self.weighted_targets = input;
            self
        }
        /// Consumes the builder and constructs a [`HttpRouteAction`](crate::model::HttpRouteAction)
        pub fn build(self) -> crate::model::HttpRouteAction {
            crate::model::HttpRouteAction {
                weighted_targets: self.weighted_targets,
            }
        }
    }
}
impl HttpRouteAction {
    /// Creates a new builder-style object to manufacture [`HttpRouteAction`](crate::model::HttpRouteAction)
    pub fn builder() -> crate::model::http_route_action::Builder {
        crate::model::http_route_action::Builder::default()
    }
}

/// <p>An object that represents the requirements for a route to match HTTP requests for a
/// virtual router.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HttpRouteMatch {
    /// <p>Specifies the path to match requests with. This parameter must always start with
    /// <code>/</code>, which by itself matches all requests to the virtual service name. You
    /// can also match for path-based routing of requests. For example, if your virtual service
    /// name is <code>my-service.local</code> and you want the route to match requests to
    /// <code>my-service.local/metrics</code>, your prefix should be
    /// <code>/metrics</code>.</p>
    pub prefix: std::option::Option<std::string::String>,
    /// <p>The client request path to match on.</p>
    pub path: std::option::Option<crate::model::HttpPathMatch>,
    /// <p>The client request query parameters to match on.</p>
    pub query_parameters: std::option::Option<std::vec::Vec<crate::model::HttpQueryParameter>>,
    /// <p>The client request method to match on. Specify only one.</p>
    pub method: std::option::Option<crate::model::HttpMethod>,
    /// <p>The client request scheme to match on. Specify only one. Applicable only for HTTP2
    /// routes.</p>
    pub scheme: std::option::Option<crate::model::HttpScheme>,
    /// <p>The client request headers to match on.</p>
    pub headers: std::option::Option<std::vec::Vec<crate::model::HttpRouteHeader>>,
}
impl HttpRouteMatch {
    /// <p>Specifies the path to match requests with. This parameter must always start with
    /// <code>/</code>, which by itself matches all requests to the virtual service name. You
    /// can also match for path-based routing of requests. For example, if your virtual service
    /// name is <code>my-service.local</code> and you want the route to match requests to
    /// <code>my-service.local/metrics</code>, your prefix should be
    /// <code>/metrics</code>.</p>
    pub fn prefix(&self) -> std::option::Option<&str> {
        self.prefix.as_deref()
    }
    /// <p>The client request path to match on.</p>
    pub fn path(&self) -> std::option::Option<&crate::model::HttpPathMatch> {
        self.path.as_ref()
    }
    /// <p>The client request query parameters to match on.</p>
    pub fn query_parameters(&self) -> std::option::Option<&[crate::model::HttpQueryParameter]> {
        self.query_parameters.as_deref()
    }
    /// <p>The client request method to match on. Specify only one.</p>
    pub fn method(&self) -> std::option::Option<&crate::model::HttpMethod> {
        self.method.as_ref()
    }
    /// <p>The client request scheme to match on. Specify only one. Applicable only for HTTP2
    /// routes.</p>
    pub fn scheme(&self) -> std::option::Option<&crate::model::HttpScheme> {
        self.scheme.as_ref()
    }
    /// <p>The client request headers to match on.</p>
    pub fn headers(&self) -> std::option::Option<&[crate::model::HttpRouteHeader]> {
        self.headers.as_deref()
    }
}
impl std::fmt::Debug for HttpRouteMatch {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HttpRouteMatch");
        formatter.field("prefix", &self.prefix);
        formatter.field("path", &self.path);
        formatter.field("query_parameters", &self.query_parameters);
        formatter.field("method", &self.method);
        formatter.field("scheme", &self.scheme);
        formatter.field("headers", &self.headers);
        formatter.finish()
    }
}
/// See [`HttpRouteMatch`](crate::model::HttpRouteMatch)
pub mod http_route_match {
    /// A builder for [`HttpRouteMatch`](crate::model::HttpRouteMatch)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) prefix: std::option::Option<std::string::String>,
        pub(crate) path: std::option::Option<crate::model::HttpPathMatch>,
        pub(crate) query_parameters:
            std::option::Option<std::vec::Vec<crate::model::HttpQueryParameter>>,
        pub(crate) method: std::option::Option<crate::model::HttpMethod>,
        pub(crate) scheme: std::option::Option<crate::model::HttpScheme>,
        pub(crate) headers: std::option::Option<std::vec::Vec<crate::model::HttpRouteHeader>>,
    }
    impl Builder {
        /// <p>Specifies the path to match requests with. This parameter must always start with
        /// <code>/</code>, which by itself matches all requests to the virtual service name. You
        /// can also match for path-based routing of requests. For example, if your virtual service
        /// name is <code>my-service.local</code> and you want the route to match requests to
        /// <code>my-service.local/metrics</code>, your prefix should be
        /// <code>/metrics</code>.</p>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p>Specifies the path to match requests with. This parameter must always start with
        /// <code>/</code>, which by itself matches all requests to the virtual service name. You
        /// can also match for path-based routing of requests. For example, if your virtual service
        /// name is <code>my-service.local</code> and you want the route to match requests to
        /// <code>my-service.local/metrics</code>, your prefix should be
        /// <code>/metrics</code>.</p>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// <p>The client request path to match on.</p>
        pub fn path(mut self, input: crate::model::HttpPathMatch) -> Self {
            self.path = Some(input);
            self
        }
        /// <p>The client request path to match on.</p>
        pub fn set_path(mut self, input: std::option::Option<crate::model::HttpPathMatch>) -> Self {
            self.path = input;
            self
        }
        /// Appends an item to `query_parameters`.
        ///
        /// To override the contents of this collection use [`set_query_parameters`](Self::set_query_parameters).
        ///
        /// <p>The client request query parameters to match on.</p>
        pub fn query_parameters(
            mut self,
            input: impl Into<crate::model::HttpQueryParameter>,
        ) -> Self {
            let mut v = self.query_parameters.unwrap_or_default();
            v.push(input.into());
            self.query_parameters = Some(v);
            self
        }
        /// <p>The client request query parameters to match on.</p>
        pub fn set_query_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HttpQueryParameter>>,
        ) -> Self {
            self.query_parameters = input;
            self
        }
        /// <p>The client request method to match on. Specify only one.</p>
        pub fn method(mut self, input: crate::model::HttpMethod) -> Self {
            self.method = Some(input);
            self
        }
        /// <p>The client request method to match on. Specify only one.</p>
        pub fn set_method(mut self, input: std::option::Option<crate::model::HttpMethod>) -> Self {
            self.method = input;
            self
        }
        /// <p>The client request scheme to match on. Specify only one. Applicable only for HTTP2
        /// routes.</p>
        pub fn scheme(mut self, input: crate::model::HttpScheme) -> Self {
            self.scheme = Some(input);
            self
        }
        /// <p>The client request scheme to match on. Specify only one. Applicable only for HTTP2
        /// routes.</p>
        pub fn set_scheme(mut self, input: std::option::Option<crate::model::HttpScheme>) -> Self {
            self.scheme = input;
            self
        }
        /// Appends an item to `headers`.
        ///
        /// To override the contents of this collection use [`set_headers`](Self::set_headers).
        ///
        /// <p>The client request headers to match on.</p>
        pub fn headers(mut self, input: impl Into<crate::model::HttpRouteHeader>) -> Self {
            let mut v = self.headers.unwrap_or_default();
            v.push(input.into());
            self.headers = Some(v);
            self
        }
        /// <p>The client request headers to match on.</p>
        pub fn set_headers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HttpRouteHeader>>,
        ) -> Self {
            self.headers = input;
            self
        }
        /// Consumes the builder and constructs a [`HttpRouteMatch`](crate::model::HttpRouteMatch)
        pub fn build(self) -> crate::model::HttpRouteMatch {
            crate::model::HttpRouteMatch {
                prefix: self.prefix,
                path: self.path,
                query_parameters: self.query_parameters,
                method: self.method,
                scheme: self.scheme,
                headers: self.headers,
            }
        }
    }
}
impl HttpRouteMatch {
    /// Creates a new builder-style object to manufacture [`HttpRouteMatch`](crate::model::HttpRouteMatch)
    pub fn builder() -> crate::model::http_route_match::Builder {
        crate::model::http_route_match::Builder::default()
    }
}

/// <p>An object that represents the HTTP header in the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HttpRouteHeader {
    /// <p>A name for the HTTP header in the client request that will be matched on.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Specify <code>True</code> to match anything except the match criteria. The default value is <code>False</code>.</p>
    pub invert: std::option::Option<bool>,
    /// <p>The <code>HeaderMatchMethod</code> object.</p>
    pub r#match: std::option::Option<crate::model::HeaderMatchMethod>,
}
impl HttpRouteHeader {
    /// <p>A name for the HTTP header in the client request that will be matched on.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Specify <code>True</code> to match anything except the match criteria. The default value is <code>False</code>.</p>
    pub fn invert(&self) -> std::option::Option<bool> {
        self.invert
    }
    /// <p>The <code>HeaderMatchMethod</code> object.</p>
    pub fn r#match(&self) -> std::option::Option<&crate::model::HeaderMatchMethod> {
        self.r#match.as_ref()
    }
}
impl std::fmt::Debug for HttpRouteHeader {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HttpRouteHeader");
        formatter.field("name", &self.name);
        formatter.field("invert", &self.invert);
        formatter.field("r#match", &self.r#match);
        formatter.finish()
    }
}
/// See [`HttpRouteHeader`](crate::model::HttpRouteHeader)
pub mod http_route_header {
    /// A builder for [`HttpRouteHeader`](crate::model::HttpRouteHeader)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) invert: std::option::Option<bool>,
        pub(crate) r#match: std::option::Option<crate::model::HeaderMatchMethod>,
    }
    impl Builder {
        /// <p>A name for the HTTP header in the client request that will be matched on.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A name for the HTTP header in the client request that will be matched on.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Specify <code>True</code> to match anything except the match criteria. The default value is <code>False</code>.</p>
        pub fn invert(mut self, input: bool) -> Self {
            self.invert = Some(input);
            self
        }
        /// <p>Specify <code>True</code> to match anything except the match criteria. The default value is <code>False</code>.</p>
        pub fn set_invert(mut self, input: std::option::Option<bool>) -> Self {
            self.invert = input;
            self
        }
        /// <p>The <code>HeaderMatchMethod</code> object.</p>
        pub fn r#match(mut self, input: crate::model::HeaderMatchMethod) -> Self {
            self.r#match = Some(input);
            self
        }
        /// <p>The <code>HeaderMatchMethod</code> object.</p>
        pub fn set_match(
            mut self,
            input: std::option::Option<crate::model::HeaderMatchMethod>,
        ) -> Self {
            self.r#match = input;
            self
        }
        /// Consumes the builder and constructs a [`HttpRouteHeader`](crate::model::HttpRouteHeader)
        pub fn build(self) -> crate::model::HttpRouteHeader {
            crate::model::HttpRouteHeader {
                name: self.name,
                invert: self.invert,
                r#match: self.r#match,
            }
        }
    }
}
impl HttpRouteHeader {
    /// Creates a new builder-style object to manufacture [`HttpRouteHeader`](crate::model::HttpRouteHeader)
    pub fn builder() -> crate::model::http_route_header::Builder {
        crate::model::http_route_header::Builder::default()
    }
}

/// <p>An object that represents the method and value to match with the header value sent in a
/// request. Specify one match method.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum HeaderMatchMethod {
    /// <p>The value sent by the client must match the specified value exactly.</p>
    Exact(std::string::String),
    /// <p>The value sent by the client must begin with the specified characters.</p>
    Prefix(std::string::String),
    /// <p>An object that represents the range of values to match on.</p>
    Range(crate::model::MatchRange),
    /// <p>The value sent by the client must include the specified characters.</p>
    Regex(std::string::String),
    /// <p>The value sent by the client must end with the specified characters.</p>
    Suffix(std::string::String),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl HeaderMatchMethod {
    /// Tries to convert the enum instance into [`Exact`](crate::model::HeaderMatchMethod::Exact), extracting the inner [`String`](std::string::String).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_exact(&self) -> std::result::Result<&std::string::String, &Self> {
        if let HeaderMatchMethod::Exact(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Exact`](crate::model::HeaderMatchMethod::Exact).
    pub fn is_exact(&self) -> bool {
        self.as_exact().is_ok()
    }
    /// Tries to convert the enum instance into [`Prefix`](crate::model::HeaderMatchMethod::Prefix), extracting the inner [`String`](std::string::String).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_prefix(&self) -> std::result::Result<&std::string::String, &Self> {
        if let HeaderMatchMethod::Prefix(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Prefix`](crate::model::HeaderMatchMethod::Prefix).
    pub fn is_prefix(&self) -> bool {
        self.as_prefix().is_ok()
    }
    /// Tries to convert the enum instance into [`Range`](crate::model::HeaderMatchMethod::Range), extracting the inner [`MatchRange`](crate::model::MatchRange).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_range(&self) -> std::result::Result<&crate::model::MatchRange, &Self> {
        if let HeaderMatchMethod::Range(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Range`](crate::model::HeaderMatchMethod::Range).
    pub fn is_range(&self) -> bool {
        self.as_range().is_ok()
    }
    /// Tries to convert the enum instance into [`Regex`](crate::model::HeaderMatchMethod::Regex), extracting the inner [`String`](std::string::String).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_regex(&self) -> std::result::Result<&std::string::String, &Self> {
        if let HeaderMatchMethod::Regex(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Regex`](crate::model::HeaderMatchMethod::Regex).
    pub fn is_regex(&self) -> bool {
        self.as_regex().is_ok()
    }
    /// Tries to convert the enum instance into [`Suffix`](crate::model::HeaderMatchMethod::Suffix), extracting the inner [`String`](std::string::String).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_suffix(&self) -> std::result::Result<&std::string::String, &Self> {
        if let HeaderMatchMethod::Suffix(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Suffix`](crate::model::HeaderMatchMethod::Suffix).
    pub fn is_suffix(&self) -> bool {
        self.as_suffix().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum HttpScheme {
    #[allow(missing_docs)] // documentation missing in model
    Http,
    #[allow(missing_docs)] // documentation missing in model
    Https,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for HttpScheme {
    fn from(s: &str) -> Self {
        match s {
            "http" => HttpScheme::Http,
            "https" => HttpScheme::Https,
            other => HttpScheme::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for HttpScheme {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(HttpScheme::from(s))
    }
}
impl HttpScheme {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            HttpScheme::Http => "http",
            HttpScheme::Https => "https",
            HttpScheme::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["http", "https"]
    }
}
impl AsRef<str> for HttpScheme {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum HttpMethod {
    #[allow(missing_docs)] // documentation missing in model
    Connect,
    #[allow(missing_docs)] // documentation missing in model
    Delete,
    #[allow(missing_docs)] // documentation missing in model
    Get,
    #[allow(missing_docs)] // documentation missing in model
    Head,
    #[allow(missing_docs)] // documentation missing in model
    Options,
    #[allow(missing_docs)] // documentation missing in model
    Patch,
    #[allow(missing_docs)] // documentation missing in model
    Post,
    #[allow(missing_docs)] // documentation missing in model
    Put,
    #[allow(missing_docs)] // documentation missing in model
    Trace,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for HttpMethod {
    fn from(s: &str) -> Self {
        match s {
            "CONNECT" => HttpMethod::Connect,
            "DELETE" => HttpMethod::Delete,
            "GET" => HttpMethod::Get,
            "HEAD" => HttpMethod::Head,
            "OPTIONS" => HttpMethod::Options,
            "PATCH" => HttpMethod::Patch,
            "POST" => HttpMethod::Post,
            "PUT" => HttpMethod::Put,
            "TRACE" => HttpMethod::Trace,
            other => HttpMethod::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for HttpMethod {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(HttpMethod::from(s))
    }
}
impl HttpMethod {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            HttpMethod::Connect => "CONNECT",
            HttpMethod::Delete => "DELETE",
            HttpMethod::Get => "GET",
            HttpMethod::Head => "HEAD",
            HttpMethod::Options => "OPTIONS",
            HttpMethod::Patch => "PATCH",
            HttpMethod::Post => "POST",
            HttpMethod::Put => "PUT",
            HttpMethod::Trace => "TRACE",
            HttpMethod::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CONNECT", "DELETE", "GET", "HEAD", "OPTIONS", "PATCH", "POST", "PUT", "TRACE",
        ]
    }
}
impl AsRef<str> for HttpMethod {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that represents the query parameter in the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HttpQueryParameter {
    /// <p>A name for the query parameter that will be matched on.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The query parameter to match on.</p>
    pub r#match: std::option::Option<crate::model::QueryParameterMatch>,
}
impl HttpQueryParameter {
    /// <p>A name for the query parameter that will be matched on.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The query parameter to match on.</p>
    pub fn r#match(&self) -> std::option::Option<&crate::model::QueryParameterMatch> {
        self.r#match.as_ref()
    }
}
impl std::fmt::Debug for HttpQueryParameter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HttpQueryParameter");
        formatter.field("name", &self.name);
        formatter.field("r#match", &self.r#match);
        formatter.finish()
    }
}
/// See [`HttpQueryParameter`](crate::model::HttpQueryParameter)
pub mod http_query_parameter {
    /// A builder for [`HttpQueryParameter`](crate::model::HttpQueryParameter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#match: std::option::Option<crate::model::QueryParameterMatch>,
    }
    impl Builder {
        /// <p>A name for the query parameter that will be matched on.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A name for the query parameter that will be matched on.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The query parameter to match on.</p>
        pub fn r#match(mut self, input: crate::model::QueryParameterMatch) -> Self {
            self.r#match = Some(input);
            self
        }
        /// <p>The query parameter to match on.</p>
        pub fn set_match(
            mut self,
            input: std::option::Option<crate::model::QueryParameterMatch>,
        ) -> Self {
            self.r#match = input;
            self
        }
        /// Consumes the builder and constructs a [`HttpQueryParameter`](crate::model::HttpQueryParameter)
        pub fn build(self) -> crate::model::HttpQueryParameter {
            crate::model::HttpQueryParameter {
                name: self.name,
                r#match: self.r#match,
            }
        }
    }
}
impl HttpQueryParameter {
    /// Creates a new builder-style object to manufacture [`HttpQueryParameter`](crate::model::HttpQueryParameter)
    pub fn builder() -> crate::model::http_query_parameter::Builder {
        crate::model::http_query_parameter::Builder::default()
    }
}

/// <p>An object representing the query parameter to match.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct QueryParameterMatch {
    /// <p>The exact query parameter to match on.</p>
    pub exact: std::option::Option<std::string::String>,
}
impl QueryParameterMatch {
    /// <p>The exact query parameter to match on.</p>
    pub fn exact(&self) -> std::option::Option<&str> {
        self.exact.as_deref()
    }
}
impl std::fmt::Debug for QueryParameterMatch {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("QueryParameterMatch");
        formatter.field("exact", &self.exact);
        formatter.finish()
    }
}
/// See [`QueryParameterMatch`](crate::model::QueryParameterMatch)
pub mod query_parameter_match {
    /// A builder for [`QueryParameterMatch`](crate::model::QueryParameterMatch)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) exact: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The exact query parameter to match on.</p>
        pub fn exact(mut self, input: impl Into<std::string::String>) -> Self {
            self.exact = Some(input.into());
            self
        }
        /// <p>The exact query parameter to match on.</p>
        pub fn set_exact(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.exact = input;
            self
        }
        /// Consumes the builder and constructs a [`QueryParameterMatch`](crate::model::QueryParameterMatch)
        pub fn build(self) -> crate::model::QueryParameterMatch {
            crate::model::QueryParameterMatch { exact: self.exact }
        }
    }
}
impl QueryParameterMatch {
    /// Creates a new builder-style object to manufacture [`QueryParameterMatch`](crate::model::QueryParameterMatch)
    pub fn builder() -> crate::model::query_parameter_match::Builder {
        crate::model::query_parameter_match::Builder::default()
    }
}

/// <p>An object representing the path to match in the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HttpPathMatch {
    /// <p>The exact path to match on.</p>
    pub exact: std::option::Option<std::string::String>,
    /// <p>The regex used to match the path.</p>
    pub regex: std::option::Option<std::string::String>,
}
impl HttpPathMatch {
    /// <p>The exact path to match on.</p>
    pub fn exact(&self) -> std::option::Option<&str> {
        self.exact.as_deref()
    }
    /// <p>The regex used to match the path.</p>
    pub fn regex(&self) -> std::option::Option<&str> {
        self.regex.as_deref()
    }
}
impl std::fmt::Debug for HttpPathMatch {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HttpPathMatch");
        formatter.field("exact", &self.exact);
        formatter.field("regex", &self.regex);
        formatter.finish()
    }
}
/// See [`HttpPathMatch`](crate::model::HttpPathMatch)
pub mod http_path_match {
    /// A builder for [`HttpPathMatch`](crate::model::HttpPathMatch)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) exact: std::option::Option<std::string::String>,
        pub(crate) regex: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The exact path to match on.</p>
        pub fn exact(mut self, input: impl Into<std::string::String>) -> Self {
            self.exact = Some(input.into());
            self
        }
        /// <p>The exact path to match on.</p>
        pub fn set_exact(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.exact = input;
            self
        }
        /// <p>The regex used to match the path.</p>
        pub fn regex(mut self, input: impl Into<std::string::String>) -> Self {
            self.regex = Some(input.into());
            self
        }
        /// <p>The regex used to match the path.</p>
        pub fn set_regex(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.regex = input;
            self
        }
        /// Consumes the builder and constructs a [`HttpPathMatch`](crate::model::HttpPathMatch)
        pub fn build(self) -> crate::model::HttpPathMatch {
            crate::model::HttpPathMatch {
                exact: self.exact,
                regex: self.regex,
            }
        }
    }
}
impl HttpPathMatch {
    /// Creates a new builder-style object to manufacture [`HttpPathMatch`](crate::model::HttpPathMatch)
    pub fn builder() -> crate::model::http_path_match::Builder {
        crate::model::http_path_match::Builder::default()
    }
}

/// <p>An object that represents a TCP route type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TcpRoute {
    /// <p>The action to take if a match is determined.</p>
    pub action: std::option::Option<crate::model::TcpRouteAction>,
    /// <p>An object that represents types of timeouts. </p>
    pub timeout: std::option::Option<crate::model::TcpTimeout>,
}
impl TcpRoute {
    /// <p>The action to take if a match is determined.</p>
    pub fn action(&self) -> std::option::Option<&crate::model::TcpRouteAction> {
        self.action.as_ref()
    }
    /// <p>An object that represents types of timeouts. </p>
    pub fn timeout(&self) -> std::option::Option<&crate::model::TcpTimeout> {
        self.timeout.as_ref()
    }
}
impl std::fmt::Debug for TcpRoute {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TcpRoute");
        formatter.field("action", &self.action);
        formatter.field("timeout", &self.timeout);
        formatter.finish()
    }
}
/// See [`TcpRoute`](crate::model::TcpRoute)
pub mod tcp_route {
    /// A builder for [`TcpRoute`](crate::model::TcpRoute)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action: std::option::Option<crate::model::TcpRouteAction>,
        pub(crate) timeout: std::option::Option<crate::model::TcpTimeout>,
    }
    impl Builder {
        /// <p>The action to take if a match is determined.</p>
        pub fn action(mut self, input: crate::model::TcpRouteAction) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>The action to take if a match is determined.</p>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::TcpRouteAction>,
        ) -> Self {
            self.action = input;
            self
        }
        /// <p>An object that represents types of timeouts. </p>
        pub fn timeout(mut self, input: crate::model::TcpTimeout) -> Self {
            self.timeout = Some(input);
            self
        }
        /// <p>An object that represents types of timeouts. </p>
        pub fn set_timeout(mut self, input: std::option::Option<crate::model::TcpTimeout>) -> Self {
            self.timeout = input;
            self
        }
        /// Consumes the builder and constructs a [`TcpRoute`](crate::model::TcpRoute)
        pub fn build(self) -> crate::model::TcpRoute {
            crate::model::TcpRoute {
                action: self.action,
                timeout: self.timeout,
            }
        }
    }
}
impl TcpRoute {
    /// Creates a new builder-style object to manufacture [`TcpRoute`](crate::model::TcpRoute)
    pub fn builder() -> crate::model::tcp_route::Builder {
        crate::model::tcp_route::Builder::default()
    }
}

/// <p>An object that represents types of timeouts. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TcpTimeout {
    /// <p>An object that represents an idle timeout. An idle timeout bounds the amount of time that a connection may be idle. The default value is none.</p>
    pub idle: std::option::Option<crate::model::Duration>,
}
impl TcpTimeout {
    /// <p>An object that represents an idle timeout. An idle timeout bounds the amount of time that a connection may be idle. The default value is none.</p>
    pub fn idle(&self) -> std::option::Option<&crate::model::Duration> {
        self.idle.as_ref()
    }
}
impl std::fmt::Debug for TcpTimeout {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TcpTimeout");
        formatter.field("idle", &self.idle);
        formatter.finish()
    }
}
/// See [`TcpTimeout`](crate::model::TcpTimeout)
pub mod tcp_timeout {
    /// A builder for [`TcpTimeout`](crate::model::TcpTimeout)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) idle: std::option::Option<crate::model::Duration>,
    }
    impl Builder {
        /// <p>An object that represents an idle timeout. An idle timeout bounds the amount of time that a connection may be idle. The default value is none.</p>
        pub fn idle(mut self, input: crate::model::Duration) -> Self {
            self.idle = Some(input);
            self
        }
        /// <p>An object that represents an idle timeout. An idle timeout bounds the amount of time that a connection may be idle. The default value is none.</p>
        pub fn set_idle(mut self, input: std::option::Option<crate::model::Duration>) -> Self {
            self.idle = input;
            self
        }
        /// Consumes the builder and constructs a [`TcpTimeout`](crate::model::TcpTimeout)
        pub fn build(self) -> crate::model::TcpTimeout {
            crate::model::TcpTimeout { idle: self.idle }
        }
    }
}
impl TcpTimeout {
    /// Creates a new builder-style object to manufacture [`TcpTimeout`](crate::model::TcpTimeout)
    pub fn builder() -> crate::model::tcp_timeout::Builder {
        crate::model::tcp_timeout::Builder::default()
    }
}

/// <p>An object that represents the action to take if a match is determined.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TcpRouteAction {
    /// <p>An object that represents the targets that traffic is routed to when a request matches the route.</p>
    pub weighted_targets: std::option::Option<std::vec::Vec<crate::model::WeightedTarget>>,
}
impl TcpRouteAction {
    /// <p>An object that represents the targets that traffic is routed to when a request matches the route.</p>
    pub fn weighted_targets(&self) -> std::option::Option<&[crate::model::WeightedTarget]> {
        self.weighted_targets.as_deref()
    }
}
impl std::fmt::Debug for TcpRouteAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TcpRouteAction");
        formatter.field("weighted_targets", &self.weighted_targets);
        formatter.finish()
    }
}
/// See [`TcpRouteAction`](crate::model::TcpRouteAction)
pub mod tcp_route_action {
    /// A builder for [`TcpRouteAction`](crate::model::TcpRouteAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) weighted_targets:
            std::option::Option<std::vec::Vec<crate::model::WeightedTarget>>,
    }
    impl Builder {
        /// Appends an item to `weighted_targets`.
        ///
        /// To override the contents of this collection use [`set_weighted_targets`](Self::set_weighted_targets).
        ///
        /// <p>An object that represents the targets that traffic is routed to when a request matches the route.</p>
        pub fn weighted_targets(mut self, input: impl Into<crate::model::WeightedTarget>) -> Self {
            let mut v = self.weighted_targets.unwrap_or_default();
            v.push(input.into());
            self.weighted_targets = Some(v);
            self
        }
        /// <p>An object that represents the targets that traffic is routed to when a request matches the route.</p>
        pub fn set_weighted_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::WeightedTarget>>,
        ) -> Self {
            self.weighted_targets = input;
            self
        }
        /// Consumes the builder and constructs a [`TcpRouteAction`](crate::model::TcpRouteAction)
        pub fn build(self) -> crate::model::TcpRouteAction {
            crate::model::TcpRouteAction {
                weighted_targets: self.weighted_targets,
            }
        }
    }
}
impl TcpRouteAction {
    /// Creates a new builder-style object to manufacture [`TcpRouteAction`](crate::model::TcpRouteAction)
    pub fn builder() -> crate::model::tcp_route_action::Builder {
        crate::model::tcp_route_action::Builder::default()
    }
}

/// <p>An object that represents a virtual node returned by a list operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VirtualNodeRef {
    /// <p>The name of the service mesh that the virtual node resides in.</p>
    pub mesh_name: std::option::Option<std::string::String>,
    /// <p>The name of the virtual node.</p>
    pub virtual_node_name: std::option::Option<std::string::String>,
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
    /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub mesh_owner: std::option::Option<std::string::String>,
    /// <p>The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's
    /// the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub resource_owner: std::option::Option<std::string::String>,
    /// <p>The full Amazon Resource Name (ARN) for the virtual node.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The version of the resource. Resources are created at version 1, and this version is incremented each time that they're updated.</p>
    pub version: std::option::Option<i64>,
    /// <p>The Unix epoch timestamp in seconds for when the resource was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The Unix epoch timestamp in seconds for when the resource was last updated.</p>
    pub last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
}
impl VirtualNodeRef {
    /// <p>The name of the service mesh that the virtual node resides in.</p>
    pub fn mesh_name(&self) -> std::option::Option<&str> {
        self.mesh_name.as_deref()
    }
    /// <p>The name of the virtual node.</p>
    pub fn virtual_node_name(&self) -> std::option::Option<&str> {
        self.virtual_node_name.as_deref()
    }
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
    /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub fn mesh_owner(&self) -> std::option::Option<&str> {
        self.mesh_owner.as_deref()
    }
    /// <p>The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's
    /// the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub fn resource_owner(&self) -> std::option::Option<&str> {
        self.resource_owner.as_deref()
    }
    /// <p>The full Amazon Resource Name (ARN) for the virtual node.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The version of the resource. Resources are created at version 1, and this version is incremented each time that they're updated.</p>
    pub fn version(&self) -> std::option::Option<i64> {
        self.version
    }
    /// <p>The Unix epoch timestamp in seconds for when the resource was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The Unix epoch timestamp in seconds for when the resource was last updated.</p>
    pub fn last_updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_at.as_ref()
    }
}
impl std::fmt::Debug for VirtualNodeRef {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VirtualNodeRef");
        formatter.field("mesh_name", &self.mesh_name);
        formatter.field("virtual_node_name", &self.virtual_node_name);
        formatter.field("mesh_owner", &self.mesh_owner);
        formatter.field("resource_owner", &self.resource_owner);
        formatter.field("arn", &self.arn);
        formatter.field("version", &self.version);
        formatter.field("created_at", &self.created_at);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.finish()
    }
}
/// See [`VirtualNodeRef`](crate::model::VirtualNodeRef)
pub mod virtual_node_ref {
    /// A builder for [`VirtualNodeRef`](crate::model::VirtualNodeRef)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mesh_name: std::option::Option<std::string::String>,
        pub(crate) virtual_node_name: std::option::Option<std::string::String>,
        pub(crate) mesh_owner: std::option::Option<std::string::String>,
        pub(crate) resource_owner: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<i64>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the service mesh that the virtual node resides in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_name = Some(input.into());
            self
        }
        /// <p>The name of the service mesh that the virtual node resides in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_name = input;
            self
        }
        /// <p>The name of the virtual node.</p>
        pub fn virtual_node_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_node_name = Some(input.into());
            self
        }
        /// <p>The name of the virtual node.</p>
        pub fn set_virtual_node_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_node_name = input;
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_owner = Some(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_owner = input;
            self
        }
        /// <p>The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's
        /// the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn resource_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_owner = Some(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's
        /// the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_resource_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_owner = input;
            self
        }
        /// <p>The full Amazon Resource Name (ARN) for the virtual node.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The full Amazon Resource Name (ARN) for the virtual node.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The version of the resource. Resources are created at version 1, and this version is incremented each time that they're updated.</p>
        pub fn version(mut self, input: i64) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>The version of the resource. Resources are created at version 1, and this version is incremented each time that they're updated.</p>
        pub fn set_version(mut self, input: std::option::Option<i64>) -> Self {
            self.version = input;
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the resource was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the resource was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the resource was last updated.</p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the resource was last updated.</p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// Consumes the builder and constructs a [`VirtualNodeRef`](crate::model::VirtualNodeRef)
        pub fn build(self) -> crate::model::VirtualNodeRef {
            crate::model::VirtualNodeRef {
                mesh_name: self.mesh_name,
                virtual_node_name: self.virtual_node_name,
                mesh_owner: self.mesh_owner,
                resource_owner: self.resource_owner,
                arn: self.arn,
                version: self.version,
                created_at: self.created_at,
                last_updated_at: self.last_updated_at,
            }
        }
    }
}
impl VirtualNodeRef {
    /// Creates a new builder-style object to manufacture [`VirtualNodeRef`](crate::model::VirtualNodeRef)
    pub fn builder() -> crate::model::virtual_node_ref::Builder {
        crate::model::virtual_node_ref::Builder::default()
    }
}

/// <p>An object that represents a virtual node returned by a describe operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VirtualNodeData {
    /// <p>The name of the service mesh that the virtual node resides in.</p>
    pub mesh_name: std::option::Option<std::string::String>,
    /// <p>The name of the virtual node.</p>
    pub virtual_node_name: std::option::Option<std::string::String>,
    /// <p>The specifications of the virtual node.</p>
    pub spec: std::option::Option<crate::model::VirtualNodeSpec>,
    /// <p>The associated metadata for the virtual node.</p>
    pub metadata: std::option::Option<crate::model::ResourceMetadata>,
    /// <p>The current status for the virtual node.</p>
    pub status: std::option::Option<crate::model::VirtualNodeStatus>,
}
impl VirtualNodeData {
    /// <p>The name of the service mesh that the virtual node resides in.</p>
    pub fn mesh_name(&self) -> std::option::Option<&str> {
        self.mesh_name.as_deref()
    }
    /// <p>The name of the virtual node.</p>
    pub fn virtual_node_name(&self) -> std::option::Option<&str> {
        self.virtual_node_name.as_deref()
    }
    /// <p>The specifications of the virtual node.</p>
    pub fn spec(&self) -> std::option::Option<&crate::model::VirtualNodeSpec> {
        self.spec.as_ref()
    }
    /// <p>The associated metadata for the virtual node.</p>
    pub fn metadata(&self) -> std::option::Option<&crate::model::ResourceMetadata> {
        self.metadata.as_ref()
    }
    /// <p>The current status for the virtual node.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::VirtualNodeStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for VirtualNodeData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VirtualNodeData");
        formatter.field("mesh_name", &self.mesh_name);
        formatter.field("virtual_node_name", &self.virtual_node_name);
        formatter.field("spec", &self.spec);
        formatter.field("metadata", &self.metadata);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`VirtualNodeData`](crate::model::VirtualNodeData)
pub mod virtual_node_data {
    /// A builder for [`VirtualNodeData`](crate::model::VirtualNodeData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mesh_name: std::option::Option<std::string::String>,
        pub(crate) virtual_node_name: std::option::Option<std::string::String>,
        pub(crate) spec: std::option::Option<crate::model::VirtualNodeSpec>,
        pub(crate) metadata: std::option::Option<crate::model::ResourceMetadata>,
        pub(crate) status: std::option::Option<crate::model::VirtualNodeStatus>,
    }
    impl Builder {
        /// <p>The name of the service mesh that the virtual node resides in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_name = Some(input.into());
            self
        }
        /// <p>The name of the service mesh that the virtual node resides in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_name = input;
            self
        }
        /// <p>The name of the virtual node.</p>
        pub fn virtual_node_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_node_name = Some(input.into());
            self
        }
        /// <p>The name of the virtual node.</p>
        pub fn set_virtual_node_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_node_name = input;
            self
        }
        /// <p>The specifications of the virtual node.</p>
        pub fn spec(mut self, input: crate::model::VirtualNodeSpec) -> Self {
            self.spec = Some(input);
            self
        }
        /// <p>The specifications of the virtual node.</p>
        pub fn set_spec(
            mut self,
            input: std::option::Option<crate::model::VirtualNodeSpec>,
        ) -> Self {
            self.spec = input;
            self
        }
        /// <p>The associated metadata for the virtual node.</p>
        pub fn metadata(mut self, input: crate::model::ResourceMetadata) -> Self {
            self.metadata = Some(input);
            self
        }
        /// <p>The associated metadata for the virtual node.</p>
        pub fn set_metadata(
            mut self,
            input: std::option::Option<crate::model::ResourceMetadata>,
        ) -> Self {
            self.metadata = input;
            self
        }
        /// <p>The current status for the virtual node.</p>
        pub fn status(mut self, input: crate::model::VirtualNodeStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status for the virtual node.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::VirtualNodeStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`VirtualNodeData`](crate::model::VirtualNodeData)
        pub fn build(self) -> crate::model::VirtualNodeData {
            crate::model::VirtualNodeData {
                mesh_name: self.mesh_name,
                virtual_node_name: self.virtual_node_name,
                spec: self.spec,
                metadata: self.metadata,
                status: self.status,
            }
        }
    }
}
impl VirtualNodeData {
    /// Creates a new builder-style object to manufacture [`VirtualNodeData`](crate::model::VirtualNodeData)
    pub fn builder() -> crate::model::virtual_node_data::Builder {
        crate::model::virtual_node_data::Builder::default()
    }
}

/// <p>An object that represents the current status of the virtual node.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VirtualNodeStatus {
    /// <p>The current status of the virtual node.</p>
    pub status: std::option::Option<crate::model::VirtualNodeStatusCode>,
}
impl VirtualNodeStatus {
    /// <p>The current status of the virtual node.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::VirtualNodeStatusCode> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for VirtualNodeStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VirtualNodeStatus");
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`VirtualNodeStatus`](crate::model::VirtualNodeStatus)
pub mod virtual_node_status {
    /// A builder for [`VirtualNodeStatus`](crate::model::VirtualNodeStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::VirtualNodeStatusCode>,
    }
    impl Builder {
        /// <p>The current status of the virtual node.</p>
        pub fn status(mut self, input: crate::model::VirtualNodeStatusCode) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the virtual node.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::VirtualNodeStatusCode>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`VirtualNodeStatus`](crate::model::VirtualNodeStatus)
        pub fn build(self) -> crate::model::VirtualNodeStatus {
            crate::model::VirtualNodeStatus {
                status: self.status,
            }
        }
    }
}
impl VirtualNodeStatus {
    /// Creates a new builder-style object to manufacture [`VirtualNodeStatus`](crate::model::VirtualNodeStatus)
    pub fn builder() -> crate::model::virtual_node_status::Builder {
        crate::model::virtual_node_status::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum VirtualNodeStatusCode {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Inactive,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for VirtualNodeStatusCode {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => VirtualNodeStatusCode::Active,
            "DELETED" => VirtualNodeStatusCode::Deleted,
            "INACTIVE" => VirtualNodeStatusCode::Inactive,
            other => VirtualNodeStatusCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for VirtualNodeStatusCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(VirtualNodeStatusCode::from(s))
    }
}
impl VirtualNodeStatusCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            VirtualNodeStatusCode::Active => "ACTIVE",
            VirtualNodeStatusCode::Deleted => "DELETED",
            VirtualNodeStatusCode::Inactive => "INACTIVE",
            VirtualNodeStatusCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "DELETED", "INACTIVE"]
    }
}
impl AsRef<str> for VirtualNodeStatusCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that represents the specification of a virtual node.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VirtualNodeSpec {
    /// <p>The service discovery information for the virtual node. If your virtual node does not
    /// expect ingress traffic, you can omit this parameter. If you specify a
    /// <code>listener</code>, then you must specify service discovery information.</p>
    pub service_discovery: std::option::Option<crate::model::ServiceDiscovery>,
    /// <p>The listener that the virtual node is expected to receive inbound traffic from. You can
    /// specify one listener.</p>
    pub listeners: std::option::Option<std::vec::Vec<crate::model::Listener>>,
    /// <p>The backends that the virtual node is expected to send outbound traffic to.</p>
    pub backends: std::option::Option<std::vec::Vec<crate::model::Backend>>,
    /// <p>A reference to an object that represents the defaults for backends.</p>
    pub backend_defaults: std::option::Option<crate::model::BackendDefaults>,
    /// <p>The inbound and outbound access logging information for the virtual node.</p>
    pub logging: std::option::Option<crate::model::Logging>,
}
impl VirtualNodeSpec {
    /// <p>The service discovery information for the virtual node. If your virtual node does not
    /// expect ingress traffic, you can omit this parameter. If you specify a
    /// <code>listener</code>, then you must specify service discovery information.</p>
    pub fn service_discovery(&self) -> std::option::Option<&crate::model::ServiceDiscovery> {
        self.service_discovery.as_ref()
    }
    /// <p>The listener that the virtual node is expected to receive inbound traffic from. You can
    /// specify one listener.</p>
    pub fn listeners(&self) -> std::option::Option<&[crate::model::Listener]> {
        self.listeners.as_deref()
    }
    /// <p>The backends that the virtual node is expected to send outbound traffic to.</p>
    pub fn backends(&self) -> std::option::Option<&[crate::model::Backend]> {
        self.backends.as_deref()
    }
    /// <p>A reference to an object that represents the defaults for backends.</p>
    pub fn backend_defaults(&self) -> std::option::Option<&crate::model::BackendDefaults> {
        self.backend_defaults.as_ref()
    }
    /// <p>The inbound and outbound access logging information for the virtual node.</p>
    pub fn logging(&self) -> std::option::Option<&crate::model::Logging> {
        self.logging.as_ref()
    }
}
impl std::fmt::Debug for VirtualNodeSpec {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VirtualNodeSpec");
        formatter.field("service_discovery", &self.service_discovery);
        formatter.field("listeners", &self.listeners);
        formatter.field("backends", &self.backends);
        formatter.field("backend_defaults", &self.backend_defaults);
        formatter.field("logging", &self.logging);
        formatter.finish()
    }
}
/// See [`VirtualNodeSpec`](crate::model::VirtualNodeSpec)
pub mod virtual_node_spec {
    /// A builder for [`VirtualNodeSpec`](crate::model::VirtualNodeSpec)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_discovery: std::option::Option<crate::model::ServiceDiscovery>,
        pub(crate) listeners: std::option::Option<std::vec::Vec<crate::model::Listener>>,
        pub(crate) backends: std::option::Option<std::vec::Vec<crate::model::Backend>>,
        pub(crate) backend_defaults: std::option::Option<crate::model::BackendDefaults>,
        pub(crate) logging: std::option::Option<crate::model::Logging>,
    }
    impl Builder {
        /// <p>The service discovery information for the virtual node. If your virtual node does not
        /// expect ingress traffic, you can omit this parameter. If you specify a
        /// <code>listener</code>, then you must specify service discovery information.</p>
        pub fn service_discovery(mut self, input: crate::model::ServiceDiscovery) -> Self {
            self.service_discovery = Some(input);
            self
        }
        /// <p>The service discovery information for the virtual node. If your virtual node does not
        /// expect ingress traffic, you can omit this parameter. If you specify a
        /// <code>listener</code>, then you must specify service discovery information.</p>
        pub fn set_service_discovery(
            mut self,
            input: std::option::Option<crate::model::ServiceDiscovery>,
        ) -> Self {
            self.service_discovery = input;
            self
        }
        /// Appends an item to `listeners`.
        ///
        /// To override the contents of this collection use [`set_listeners`](Self::set_listeners).
        ///
        /// <p>The listener that the virtual node is expected to receive inbound traffic from. You can
        /// specify one listener.</p>
        pub fn listeners(mut self, input: impl Into<crate::model::Listener>) -> Self {
            let mut v = self.listeners.unwrap_or_default();
            v.push(input.into());
            self.listeners = Some(v);
            self
        }
        /// <p>The listener that the virtual node is expected to receive inbound traffic from. You can
        /// specify one listener.</p>
        pub fn set_listeners(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Listener>>,
        ) -> Self {
            self.listeners = input;
            self
        }
        /// Appends an item to `backends`.
        ///
        /// To override the contents of this collection use [`set_backends`](Self::set_backends).
        ///
        /// <p>The backends that the virtual node is expected to send outbound traffic to.</p>
        pub fn backends(mut self, input: impl Into<crate::model::Backend>) -> Self {
            let mut v = self.backends.unwrap_or_default();
            v.push(input.into());
            self.backends = Some(v);
            self
        }
        /// <p>The backends that the virtual node is expected to send outbound traffic to.</p>
        pub fn set_backends(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Backend>>,
        ) -> Self {
            self.backends = input;
            self
        }
        /// <p>A reference to an object that represents the defaults for backends.</p>
        pub fn backend_defaults(mut self, input: crate::model::BackendDefaults) -> Self {
            self.backend_defaults = Some(input);
            self
        }
        /// <p>A reference to an object that represents the defaults for backends.</p>
        pub fn set_backend_defaults(
            mut self,
            input: std::option::Option<crate::model::BackendDefaults>,
        ) -> Self {
            self.backend_defaults = input;
            self
        }
        /// <p>The inbound and outbound access logging information for the virtual node.</p>
        pub fn logging(mut self, input: crate::model::Logging) -> Self {
            self.logging = Some(input);
            self
        }
        /// <p>The inbound and outbound access logging information for the virtual node.</p>
        pub fn set_logging(mut self, input: std::option::Option<crate::model::Logging>) -> Self {
            self.logging = input;
            self
        }
        /// Consumes the builder and constructs a [`VirtualNodeSpec`](crate::model::VirtualNodeSpec)
        pub fn build(self) -> crate::model::VirtualNodeSpec {
            crate::model::VirtualNodeSpec {
                service_discovery: self.service_discovery,
                listeners: self.listeners,
                backends: self.backends,
                backend_defaults: self.backend_defaults,
                logging: self.logging,
            }
        }
    }
}
impl VirtualNodeSpec {
    /// Creates a new builder-style object to manufacture [`VirtualNodeSpec`](crate::model::VirtualNodeSpec)
    pub fn builder() -> crate::model::virtual_node_spec::Builder {
        crate::model::virtual_node_spec::Builder::default()
    }
}

/// <p>An object that represents the logging information for a virtual node.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Logging {
    /// <p>The access log configuration for a virtual node.</p>
    pub access_log: std::option::Option<crate::model::AccessLog>,
}
impl Logging {
    /// <p>The access log configuration for a virtual node.</p>
    pub fn access_log(&self) -> std::option::Option<&crate::model::AccessLog> {
        self.access_log.as_ref()
    }
}
impl std::fmt::Debug for Logging {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Logging");
        formatter.field("access_log", &self.access_log);
        formatter.finish()
    }
}
/// See [`Logging`](crate::model::Logging)
pub mod logging {
    /// A builder for [`Logging`](crate::model::Logging)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_log: std::option::Option<crate::model::AccessLog>,
    }
    impl Builder {
        /// <p>The access log configuration for a virtual node.</p>
        pub fn access_log(mut self, input: crate::model::AccessLog) -> Self {
            self.access_log = Some(input);
            self
        }
        /// <p>The access log configuration for a virtual node.</p>
        pub fn set_access_log(
            mut self,
            input: std::option::Option<crate::model::AccessLog>,
        ) -> Self {
            self.access_log = input;
            self
        }
        /// Consumes the builder and constructs a [`Logging`](crate::model::Logging)
        pub fn build(self) -> crate::model::Logging {
            crate::model::Logging {
                access_log: self.access_log,
            }
        }
    }
}
impl Logging {
    /// Creates a new builder-style object to manufacture [`Logging`](crate::model::Logging)
    pub fn builder() -> crate::model::logging::Builder {
        crate::model::logging::Builder::default()
    }
}

/// <p>An object that represents the access logging information for a virtual node.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum AccessLog {
    /// <p>The file object to send virtual node access logs to.</p>
    File(crate::model::FileAccessLog),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl AccessLog {
    #[allow(irrefutable_let_patterns)]
    /// Tries to convert the enum instance into [`File`](crate::model::AccessLog::File), extracting the inner [`FileAccessLog`](crate::model::FileAccessLog).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_file(&self) -> std::result::Result<&crate::model::FileAccessLog, &Self> {
        if let AccessLog::File(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`File`](crate::model::AccessLog::File).
    pub fn is_file(&self) -> bool {
        self.as_file().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

/// <p>An object that represents an access log file.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FileAccessLog {
    /// <p>The file path to write access logs to. You can use <code>/dev/stdout</code> to send
    /// access logs to standard out and configure your Envoy container to use a log driver, such as
    /// <code>awslogs</code>, to export the access logs to a log storage service such as Amazon
    /// CloudWatch Logs. You can also specify a path in the Envoy container's file system to write
    /// the files to disk.</p>
    /// <note>
    /// <p>The Envoy process must have write permissions to the path that you specify here.
    /// Otherwise, Envoy fails to bootstrap properly.</p>
    /// </note>
    pub path: std::option::Option<std::string::String>,
}
impl FileAccessLog {
    /// <p>The file path to write access logs to. You can use <code>/dev/stdout</code> to send
    /// access logs to standard out and configure your Envoy container to use a log driver, such as
    /// <code>awslogs</code>, to export the access logs to a log storage service such as Amazon
    /// CloudWatch Logs. You can also specify a path in the Envoy container's file system to write
    /// the files to disk.</p>
    /// <note>
    /// <p>The Envoy process must have write permissions to the path that you specify here.
    /// Otherwise, Envoy fails to bootstrap properly.</p>
    /// </note>
    pub fn path(&self) -> std::option::Option<&str> {
        self.path.as_deref()
    }
}
impl std::fmt::Debug for FileAccessLog {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FileAccessLog");
        formatter.field("path", &self.path);
        formatter.finish()
    }
}
/// See [`FileAccessLog`](crate::model::FileAccessLog)
pub mod file_access_log {
    /// A builder for [`FileAccessLog`](crate::model::FileAccessLog)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) path: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The file path to write access logs to. You can use <code>/dev/stdout</code> to send
        /// access logs to standard out and configure your Envoy container to use a log driver, such as
        /// <code>awslogs</code>, to export the access logs to a log storage service such as Amazon
        /// CloudWatch Logs. You can also specify a path in the Envoy container's file system to write
        /// the files to disk.</p>
        /// <note>
        /// <p>The Envoy process must have write permissions to the path that you specify here.
        /// Otherwise, Envoy fails to bootstrap properly.</p>
        /// </note>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p>The file path to write access logs to. You can use <code>/dev/stdout</code> to send
        /// access logs to standard out and configure your Envoy container to use a log driver, such as
        /// <code>awslogs</code>, to export the access logs to a log storage service such as Amazon
        /// CloudWatch Logs. You can also specify a path in the Envoy container's file system to write
        /// the files to disk.</p>
        /// <note>
        /// <p>The Envoy process must have write permissions to the path that you specify here.
        /// Otherwise, Envoy fails to bootstrap properly.</p>
        /// </note>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// Consumes the builder and constructs a [`FileAccessLog`](crate::model::FileAccessLog)
        pub fn build(self) -> crate::model::FileAccessLog {
            crate::model::FileAccessLog { path: self.path }
        }
    }
}
impl FileAccessLog {
    /// Creates a new builder-style object to manufacture [`FileAccessLog`](crate::model::FileAccessLog)
    pub fn builder() -> crate::model::file_access_log::Builder {
        crate::model::file_access_log::Builder::default()
    }
}

/// <p>An object that represents the default properties for a backend.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BackendDefaults {
    /// <p>A reference to an object that represents a client policy.</p>
    pub client_policy: std::option::Option<crate::model::ClientPolicy>,
}
impl BackendDefaults {
    /// <p>A reference to an object that represents a client policy.</p>
    pub fn client_policy(&self) -> std::option::Option<&crate::model::ClientPolicy> {
        self.client_policy.as_ref()
    }
}
impl std::fmt::Debug for BackendDefaults {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BackendDefaults");
        formatter.field("client_policy", &self.client_policy);
        formatter.finish()
    }
}
/// See [`BackendDefaults`](crate::model::BackendDefaults)
pub mod backend_defaults {
    /// A builder for [`BackendDefaults`](crate::model::BackendDefaults)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_policy: std::option::Option<crate::model::ClientPolicy>,
    }
    impl Builder {
        /// <p>A reference to an object that represents a client policy.</p>
        pub fn client_policy(mut self, input: crate::model::ClientPolicy) -> Self {
            self.client_policy = Some(input);
            self
        }
        /// <p>A reference to an object that represents a client policy.</p>
        pub fn set_client_policy(
            mut self,
            input: std::option::Option<crate::model::ClientPolicy>,
        ) -> Self {
            self.client_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`BackendDefaults`](crate::model::BackendDefaults)
        pub fn build(self) -> crate::model::BackendDefaults {
            crate::model::BackendDefaults {
                client_policy: self.client_policy,
            }
        }
    }
}
impl BackendDefaults {
    /// Creates a new builder-style object to manufacture [`BackendDefaults`](crate::model::BackendDefaults)
    pub fn builder() -> crate::model::backend_defaults::Builder {
        crate::model::backend_defaults::Builder::default()
    }
}

/// <p>An object that represents a client policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClientPolicy {
    /// <p>A reference to an object that represents a Transport Layer Security (TLS) client policy.</p>
    pub tls: std::option::Option<crate::model::ClientPolicyTls>,
}
impl ClientPolicy {
    /// <p>A reference to an object that represents a Transport Layer Security (TLS) client policy.</p>
    pub fn tls(&self) -> std::option::Option<&crate::model::ClientPolicyTls> {
        self.tls.as_ref()
    }
}
impl std::fmt::Debug for ClientPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClientPolicy");
        formatter.field("tls", &self.tls);
        formatter.finish()
    }
}
/// See [`ClientPolicy`](crate::model::ClientPolicy)
pub mod client_policy {
    /// A builder for [`ClientPolicy`](crate::model::ClientPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tls: std::option::Option<crate::model::ClientPolicyTls>,
    }
    impl Builder {
        /// <p>A reference to an object that represents a Transport Layer Security (TLS) client policy.</p>
        pub fn tls(mut self, input: crate::model::ClientPolicyTls) -> Self {
            self.tls = Some(input);
            self
        }
        /// <p>A reference to an object that represents a Transport Layer Security (TLS) client policy.</p>
        pub fn set_tls(
            mut self,
            input: std::option::Option<crate::model::ClientPolicyTls>,
        ) -> Self {
            self.tls = input;
            self
        }
        /// Consumes the builder and constructs a [`ClientPolicy`](crate::model::ClientPolicy)
        pub fn build(self) -> crate::model::ClientPolicy {
            crate::model::ClientPolicy { tls: self.tls }
        }
    }
}
impl ClientPolicy {
    /// Creates a new builder-style object to manufacture [`ClientPolicy`](crate::model::ClientPolicy)
    pub fn builder() -> crate::model::client_policy::Builder {
        crate::model::client_policy::Builder::default()
    }
}

/// <p>A reference to an object that represents a Transport Layer Security (TLS) client policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClientPolicyTls {
    /// <p>Whether the policy is enforced. The default is <code>True</code>, if a value isn't specified.</p>
    pub enforce: std::option::Option<bool>,
    /// <p>One or more ports that the policy is enforced for.</p>
    pub ports: std::option::Option<std::vec::Vec<i32>>,
    /// <p>A reference to an object that represents a client's TLS certificate.</p>
    pub certificate: std::option::Option<crate::model::ClientTlsCertificate>,
    /// <p>A reference to an object that represents a TLS validation context.</p>
    pub validation: std::option::Option<crate::model::TlsValidationContext>,
}
impl ClientPolicyTls {
    /// <p>Whether the policy is enforced. The default is <code>True</code>, if a value isn't specified.</p>
    pub fn enforce(&self) -> std::option::Option<bool> {
        self.enforce
    }
    /// <p>One or more ports that the policy is enforced for.</p>
    pub fn ports(&self) -> std::option::Option<&[i32]> {
        self.ports.as_deref()
    }
    /// <p>A reference to an object that represents a client's TLS certificate.</p>
    pub fn certificate(&self) -> std::option::Option<&crate::model::ClientTlsCertificate> {
        self.certificate.as_ref()
    }
    /// <p>A reference to an object that represents a TLS validation context.</p>
    pub fn validation(&self) -> std::option::Option<&crate::model::TlsValidationContext> {
        self.validation.as_ref()
    }
}
impl std::fmt::Debug for ClientPolicyTls {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClientPolicyTls");
        formatter.field("enforce", &self.enforce);
        formatter.field("ports", &self.ports);
        formatter.field("certificate", &self.certificate);
        formatter.field("validation", &self.validation);
        formatter.finish()
    }
}
/// See [`ClientPolicyTls`](crate::model::ClientPolicyTls)
pub mod client_policy_tls {
    /// A builder for [`ClientPolicyTls`](crate::model::ClientPolicyTls)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enforce: std::option::Option<bool>,
        pub(crate) ports: std::option::Option<std::vec::Vec<i32>>,
        pub(crate) certificate: std::option::Option<crate::model::ClientTlsCertificate>,
        pub(crate) validation: std::option::Option<crate::model::TlsValidationContext>,
    }
    impl Builder {
        /// <p>Whether the policy is enforced. The default is <code>True</code>, if a value isn't specified.</p>
        pub fn enforce(mut self, input: bool) -> Self {
            self.enforce = Some(input);
            self
        }
        /// <p>Whether the policy is enforced. The default is <code>True</code>, if a value isn't specified.</p>
        pub fn set_enforce(mut self, input: std::option::Option<bool>) -> Self {
            self.enforce = input;
            self
        }
        /// Appends an item to `ports`.
        ///
        /// To override the contents of this collection use [`set_ports`](Self::set_ports).
        ///
        /// <p>One or more ports that the policy is enforced for.</p>
        pub fn ports(mut self, input: impl Into<i32>) -> Self {
            let mut v = self.ports.unwrap_or_default();
            v.push(input.into());
            self.ports = Some(v);
            self
        }
        /// <p>One or more ports that the policy is enforced for.</p>
        pub fn set_ports(mut self, input: std::option::Option<std::vec::Vec<i32>>) -> Self {
            self.ports = input;
            self
        }
        /// <p>A reference to an object that represents a client's TLS certificate.</p>
        pub fn certificate(mut self, input: crate::model::ClientTlsCertificate) -> Self {
            self.certificate = Some(input);
            self
        }
        /// <p>A reference to an object that represents a client's TLS certificate.</p>
        pub fn set_certificate(
            mut self,
            input: std::option::Option<crate::model::ClientTlsCertificate>,
        ) -> Self {
            self.certificate = input;
            self
        }
        /// <p>A reference to an object that represents a TLS validation context.</p>
        pub fn validation(mut self, input: crate::model::TlsValidationContext) -> Self {
            self.validation = Some(input);
            self
        }
        /// <p>A reference to an object that represents a TLS validation context.</p>
        pub fn set_validation(
            mut self,
            input: std::option::Option<crate::model::TlsValidationContext>,
        ) -> Self {
            self.validation = input;
            self
        }
        /// Consumes the builder and constructs a [`ClientPolicyTls`](crate::model::ClientPolicyTls)
        pub fn build(self) -> crate::model::ClientPolicyTls {
            crate::model::ClientPolicyTls {
                enforce: self.enforce,
                ports: self.ports,
                certificate: self.certificate,
                validation: self.validation,
            }
        }
    }
}
impl ClientPolicyTls {
    /// Creates a new builder-style object to manufacture [`ClientPolicyTls`](crate::model::ClientPolicyTls)
    pub fn builder() -> crate::model::client_policy_tls::Builder {
        crate::model::client_policy_tls::Builder::default()
    }
}

/// <p>An object that represents how the proxy will validate its peer during Transport Layer Security (TLS)
/// negotiation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TlsValidationContext {
    /// <p>A reference to where to retrieve the trust chain when validating a peer’s Transport Layer Security (TLS)
    /// certificate.</p>
    pub trust: std::option::Option<crate::model::TlsValidationContextTrust>,
    /// <p>A reference to an object that represents the SANs for a Transport Layer Security (TLS) validation context.</p>
    pub subject_alternative_names: std::option::Option<crate::model::SubjectAlternativeNames>,
}
impl TlsValidationContext {
    /// <p>A reference to where to retrieve the trust chain when validating a peer’s Transport Layer Security (TLS)
    /// certificate.</p>
    pub fn trust(&self) -> std::option::Option<&crate::model::TlsValidationContextTrust> {
        self.trust.as_ref()
    }
    /// <p>A reference to an object that represents the SANs for a Transport Layer Security (TLS) validation context.</p>
    pub fn subject_alternative_names(
        &self,
    ) -> std::option::Option<&crate::model::SubjectAlternativeNames> {
        self.subject_alternative_names.as_ref()
    }
}
impl std::fmt::Debug for TlsValidationContext {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TlsValidationContext");
        formatter.field("trust", &self.trust);
        formatter.field("subject_alternative_names", &self.subject_alternative_names);
        formatter.finish()
    }
}
/// See [`TlsValidationContext`](crate::model::TlsValidationContext)
pub mod tls_validation_context {
    /// A builder for [`TlsValidationContext`](crate::model::TlsValidationContext)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trust: std::option::Option<crate::model::TlsValidationContextTrust>,
        pub(crate) subject_alternative_names:
            std::option::Option<crate::model::SubjectAlternativeNames>,
    }
    impl Builder {
        /// <p>A reference to where to retrieve the trust chain when validating a peer’s Transport Layer Security (TLS)
        /// certificate.</p>
        pub fn trust(mut self, input: crate::model::TlsValidationContextTrust) -> Self {
            self.trust = Some(input);
            self
        }
        /// <p>A reference to where to retrieve the trust chain when validating a peer’s Transport Layer Security (TLS)
        /// certificate.</p>
        pub fn set_trust(
            mut self,
            input: std::option::Option<crate::model::TlsValidationContextTrust>,
        ) -> Self {
            self.trust = input;
            self
        }
        /// <p>A reference to an object that represents the SANs for a Transport Layer Security (TLS) validation context.</p>
        pub fn subject_alternative_names(
            mut self,
            input: crate::model::SubjectAlternativeNames,
        ) -> Self {
            self.subject_alternative_names = Some(input);
            self
        }
        /// <p>A reference to an object that represents the SANs for a Transport Layer Security (TLS) validation context.</p>
        pub fn set_subject_alternative_names(
            mut self,
            input: std::option::Option<crate::model::SubjectAlternativeNames>,
        ) -> Self {
            self.subject_alternative_names = input;
            self
        }
        /// Consumes the builder and constructs a [`TlsValidationContext`](crate::model::TlsValidationContext)
        pub fn build(self) -> crate::model::TlsValidationContext {
            crate::model::TlsValidationContext {
                trust: self.trust,
                subject_alternative_names: self.subject_alternative_names,
            }
        }
    }
}
impl TlsValidationContext {
    /// Creates a new builder-style object to manufacture [`TlsValidationContext`](crate::model::TlsValidationContext)
    pub fn builder() -> crate::model::tls_validation_context::Builder {
        crate::model::tls_validation_context::Builder::default()
    }
}

/// <p>An object that represents the subject alternative names secured by the
/// certificate.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SubjectAlternativeNames {
    /// <p>An object that represents the criteria for determining a SANs match.</p>
    pub r#match: std::option::Option<crate::model::SubjectAlternativeNameMatchers>,
}
impl SubjectAlternativeNames {
    /// <p>An object that represents the criteria for determining a SANs match.</p>
    pub fn r#match(&self) -> std::option::Option<&crate::model::SubjectAlternativeNameMatchers> {
        self.r#match.as_ref()
    }
}
impl std::fmt::Debug for SubjectAlternativeNames {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SubjectAlternativeNames");
        formatter.field("r#match", &self.r#match);
        formatter.finish()
    }
}
/// See [`SubjectAlternativeNames`](crate::model::SubjectAlternativeNames)
pub mod subject_alternative_names {
    /// A builder for [`SubjectAlternativeNames`](crate::model::SubjectAlternativeNames)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#match: std::option::Option<crate::model::SubjectAlternativeNameMatchers>,
    }
    impl Builder {
        /// <p>An object that represents the criteria for determining a SANs match.</p>
        pub fn r#match(mut self, input: crate::model::SubjectAlternativeNameMatchers) -> Self {
            self.r#match = Some(input);
            self
        }
        /// <p>An object that represents the criteria for determining a SANs match.</p>
        pub fn set_match(
            mut self,
            input: std::option::Option<crate::model::SubjectAlternativeNameMatchers>,
        ) -> Self {
            self.r#match = input;
            self
        }
        /// Consumes the builder and constructs a [`SubjectAlternativeNames`](crate::model::SubjectAlternativeNames)
        pub fn build(self) -> crate::model::SubjectAlternativeNames {
            crate::model::SubjectAlternativeNames {
                r#match: self.r#match,
            }
        }
    }
}
impl SubjectAlternativeNames {
    /// Creates a new builder-style object to manufacture [`SubjectAlternativeNames`](crate::model::SubjectAlternativeNames)
    pub fn builder() -> crate::model::subject_alternative_names::Builder {
        crate::model::subject_alternative_names::Builder::default()
    }
}

/// <p>An object that represents the methods by which a subject alternative name on a peer
/// Transport Layer Security (TLS) certificate can be matched.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SubjectAlternativeNameMatchers {
    /// <p>The values sent must match the specified values exactly.</p>
    pub exact: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl SubjectAlternativeNameMatchers {
    /// <p>The values sent must match the specified values exactly.</p>
    pub fn exact(&self) -> std::option::Option<&[std::string::String]> {
        self.exact.as_deref()
    }
}
impl std::fmt::Debug for SubjectAlternativeNameMatchers {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SubjectAlternativeNameMatchers");
        formatter.field("exact", &self.exact);
        formatter.finish()
    }
}
/// See [`SubjectAlternativeNameMatchers`](crate::model::SubjectAlternativeNameMatchers)
pub mod subject_alternative_name_matchers {
    /// A builder for [`SubjectAlternativeNameMatchers`](crate::model::SubjectAlternativeNameMatchers)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) exact: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `exact`.
        ///
        /// To override the contents of this collection use [`set_exact`](Self::set_exact).
        ///
        /// <p>The values sent must match the specified values exactly.</p>
        pub fn exact(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.exact.unwrap_or_default();
            v.push(input.into());
            self.exact = Some(v);
            self
        }
        /// <p>The values sent must match the specified values exactly.</p>
        pub fn set_exact(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.exact = input;
            self
        }
        /// Consumes the builder and constructs a [`SubjectAlternativeNameMatchers`](crate::model::SubjectAlternativeNameMatchers)
        pub fn build(self) -> crate::model::SubjectAlternativeNameMatchers {
            crate::model::SubjectAlternativeNameMatchers { exact: self.exact }
        }
    }
}
impl SubjectAlternativeNameMatchers {
    /// Creates a new builder-style object to manufacture [`SubjectAlternativeNameMatchers`](crate::model::SubjectAlternativeNameMatchers)
    pub fn builder() -> crate::model::subject_alternative_name_matchers::Builder {
        crate::model::subject_alternative_name_matchers::Builder::default()
    }
}

/// <p>An object that represents a Transport Layer Security (TLS) validation context trust.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum TlsValidationContextTrust {
    /// <p>A reference to an object that represents a Transport Layer Security (TLS) validation context trust for an
    /// Certificate Manager certificate.</p>
    Acm(crate::model::TlsValidationContextAcmTrust),
    /// <p>An object that represents a Transport Layer Security (TLS) validation context trust for a local file.</p>
    File(crate::model::TlsValidationContextFileTrust),
    /// <p>A reference to an object that represents a Transport Layer Security (TLS) Secret Discovery Service validation
    /// context trust.</p>
    Sds(crate::model::TlsValidationContextSdsTrust),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl TlsValidationContextTrust {
    /// Tries to convert the enum instance into [`Acm`](crate::model::TlsValidationContextTrust::Acm), extracting the inner [`TlsValidationContextAcmTrust`](crate::model::TlsValidationContextAcmTrust).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_acm(
        &self,
    ) -> std::result::Result<&crate::model::TlsValidationContextAcmTrust, &Self> {
        if let TlsValidationContextTrust::Acm(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Acm`](crate::model::TlsValidationContextTrust::Acm).
    pub fn is_acm(&self) -> bool {
        self.as_acm().is_ok()
    }
    /// Tries to convert the enum instance into [`File`](crate::model::TlsValidationContextTrust::File), extracting the inner [`TlsValidationContextFileTrust`](crate::model::TlsValidationContextFileTrust).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_file(
        &self,
    ) -> std::result::Result<&crate::model::TlsValidationContextFileTrust, &Self> {
        if let TlsValidationContextTrust::File(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`File`](crate::model::TlsValidationContextTrust::File).
    pub fn is_file(&self) -> bool {
        self.as_file().is_ok()
    }
    /// Tries to convert the enum instance into [`Sds`](crate::model::TlsValidationContextTrust::Sds), extracting the inner [`TlsValidationContextSdsTrust`](crate::model::TlsValidationContextSdsTrust).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_sds(
        &self,
    ) -> std::result::Result<&crate::model::TlsValidationContextSdsTrust, &Self> {
        if let TlsValidationContextTrust::Sds(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Sds`](crate::model::TlsValidationContextTrust::Sds).
    pub fn is_sds(&self) -> bool {
        self.as_sds().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

/// <p>An object that represents a Transport Layer Security (TLS) Secret Discovery Service validation context trust. The
/// proxy must be configured with a local SDS provider via a Unix Domain Socket. See App Mesh
/// <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html">TLS
/// documentation</a> for more info.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TlsValidationContextSdsTrust {
    /// <p>A reference to an object that represents the name of the secret for a Transport Layer Security (TLS) Secret
    /// Discovery Service validation context trust.</p>
    pub secret_name: std::option::Option<std::string::String>,
}
impl TlsValidationContextSdsTrust {
    /// <p>A reference to an object that represents the name of the secret for a Transport Layer Security (TLS) Secret
    /// Discovery Service validation context trust.</p>
    pub fn secret_name(&self) -> std::option::Option<&str> {
        self.secret_name.as_deref()
    }
}
impl std::fmt::Debug for TlsValidationContextSdsTrust {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TlsValidationContextSdsTrust");
        formatter.field("secret_name", &self.secret_name);
        formatter.finish()
    }
}
/// See [`TlsValidationContextSdsTrust`](crate::model::TlsValidationContextSdsTrust)
pub mod tls_validation_context_sds_trust {
    /// A builder for [`TlsValidationContextSdsTrust`](crate::model::TlsValidationContextSdsTrust)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) secret_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A reference to an object that represents the name of the secret for a Transport Layer Security (TLS) Secret
        /// Discovery Service validation context trust.</p>
        pub fn secret_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.secret_name = Some(input.into());
            self
        }
        /// <p>A reference to an object that represents the name of the secret for a Transport Layer Security (TLS) Secret
        /// Discovery Service validation context trust.</p>
        pub fn set_secret_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.secret_name = input;
            self
        }
        /// Consumes the builder and constructs a [`TlsValidationContextSdsTrust`](crate::model::TlsValidationContextSdsTrust)
        pub fn build(self) -> crate::model::TlsValidationContextSdsTrust {
            crate::model::TlsValidationContextSdsTrust {
                secret_name: self.secret_name,
            }
        }
    }
}
impl TlsValidationContextSdsTrust {
    /// Creates a new builder-style object to manufacture [`TlsValidationContextSdsTrust`](crate::model::TlsValidationContextSdsTrust)
    pub fn builder() -> crate::model::tls_validation_context_sds_trust::Builder {
        crate::model::tls_validation_context_sds_trust::Builder::default()
    }
}

/// <p>An object that represents a Transport Layer Security (TLS) validation context trust for a local file.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TlsValidationContextFileTrust {
    /// <p>The certificate trust chain for a certificate stored on the file system of the virtual
    /// node that the proxy is running on.</p>
    pub certificate_chain: std::option::Option<std::string::String>,
}
impl TlsValidationContextFileTrust {
    /// <p>The certificate trust chain for a certificate stored on the file system of the virtual
    /// node that the proxy is running on.</p>
    pub fn certificate_chain(&self) -> std::option::Option<&str> {
        self.certificate_chain.as_deref()
    }
}
impl std::fmt::Debug for TlsValidationContextFileTrust {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TlsValidationContextFileTrust");
        formatter.field("certificate_chain", &self.certificate_chain);
        formatter.finish()
    }
}
/// See [`TlsValidationContextFileTrust`](crate::model::TlsValidationContextFileTrust)
pub mod tls_validation_context_file_trust {
    /// A builder for [`TlsValidationContextFileTrust`](crate::model::TlsValidationContextFileTrust)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_chain: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The certificate trust chain for a certificate stored on the file system of the virtual
        /// node that the proxy is running on.</p>
        pub fn certificate_chain(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_chain = Some(input.into());
            self
        }
        /// <p>The certificate trust chain for a certificate stored on the file system of the virtual
        /// node that the proxy is running on.</p>
        pub fn set_certificate_chain(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_chain = input;
            self
        }
        /// Consumes the builder and constructs a [`TlsValidationContextFileTrust`](crate::model::TlsValidationContextFileTrust)
        pub fn build(self) -> crate::model::TlsValidationContextFileTrust {
            crate::model::TlsValidationContextFileTrust {
                certificate_chain: self.certificate_chain,
            }
        }
    }
}
impl TlsValidationContextFileTrust {
    /// Creates a new builder-style object to manufacture [`TlsValidationContextFileTrust`](crate::model::TlsValidationContextFileTrust)
    pub fn builder() -> crate::model::tls_validation_context_file_trust::Builder {
        crate::model::tls_validation_context_file_trust::Builder::default()
    }
}

/// <p>An object that represents a Transport Layer Security (TLS) validation context trust for an Certificate Manager
/// certificate.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TlsValidationContextAcmTrust {
    /// <p>One or more ACM Amazon Resource Name (ARN)s.</p>
    pub certificate_authority_arns: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl TlsValidationContextAcmTrust {
    /// <p>One or more ACM Amazon Resource Name (ARN)s.</p>
    pub fn certificate_authority_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.certificate_authority_arns.as_deref()
    }
}
impl std::fmt::Debug for TlsValidationContextAcmTrust {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TlsValidationContextAcmTrust");
        formatter.field(
            "certificate_authority_arns",
            &self.certificate_authority_arns,
        );
        formatter.finish()
    }
}
/// See [`TlsValidationContextAcmTrust`](crate::model::TlsValidationContextAcmTrust)
pub mod tls_validation_context_acm_trust {
    /// A builder for [`TlsValidationContextAcmTrust`](crate::model::TlsValidationContextAcmTrust)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_authority_arns:
            std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `certificate_authority_arns`.
        ///
        /// To override the contents of this collection use [`set_certificate_authority_arns`](Self::set_certificate_authority_arns).
        ///
        /// <p>One or more ACM Amazon Resource Name (ARN)s.</p>
        pub fn certificate_authority_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.certificate_authority_arns.unwrap_or_default();
            v.push(input.into());
            self.certificate_authority_arns = Some(v);
            self
        }
        /// <p>One or more ACM Amazon Resource Name (ARN)s.</p>
        pub fn set_certificate_authority_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.certificate_authority_arns = input;
            self
        }
        /// Consumes the builder and constructs a [`TlsValidationContextAcmTrust`](crate::model::TlsValidationContextAcmTrust)
        pub fn build(self) -> crate::model::TlsValidationContextAcmTrust {
            crate::model::TlsValidationContextAcmTrust {
                certificate_authority_arns: self.certificate_authority_arns,
            }
        }
    }
}
impl TlsValidationContextAcmTrust {
    /// Creates a new builder-style object to manufacture [`TlsValidationContextAcmTrust`](crate::model::TlsValidationContextAcmTrust)
    pub fn builder() -> crate::model::tls_validation_context_acm_trust::Builder {
        crate::model::tls_validation_context_acm_trust::Builder::default()
    }
}

/// <p>An object that represents the client's certificate.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum ClientTlsCertificate {
    /// <p>An object that represents a local file certificate. The certificate must meet specific
    /// requirements and you must have proxy authorization enabled. For more information, see
    /// <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html">Transport Layer Security (TLS)</a>.</p>
    File(crate::model::ListenerTlsFileCertificate),
    /// <p>A reference to an object that represents a client's TLS Secret Discovery Service
    /// certificate.</p>
    Sds(crate::model::ListenerTlsSdsCertificate),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl ClientTlsCertificate {
    /// Tries to convert the enum instance into [`File`](crate::model::ClientTlsCertificate::File), extracting the inner [`ListenerTlsFileCertificate`](crate::model::ListenerTlsFileCertificate).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_file(&self) -> std::result::Result<&crate::model::ListenerTlsFileCertificate, &Self> {
        if let ClientTlsCertificate::File(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`File`](crate::model::ClientTlsCertificate::File).
    pub fn is_file(&self) -> bool {
        self.as_file().is_ok()
    }
    /// Tries to convert the enum instance into [`Sds`](crate::model::ClientTlsCertificate::Sds), extracting the inner [`ListenerTlsSdsCertificate`](crate::model::ListenerTlsSdsCertificate).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_sds(&self) -> std::result::Result<&crate::model::ListenerTlsSdsCertificate, &Self> {
        if let ClientTlsCertificate::Sds(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Sds`](crate::model::ClientTlsCertificate::Sds).
    pub fn is_sds(&self) -> bool {
        self.as_sds().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

/// <p>An object that represents the listener's Secret Discovery Service certificate. The proxy
/// must be configured with a local SDS provider via a Unix Domain Socket. See App Mesh <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html">TLS documentation</a>
/// for more info.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListenerTlsSdsCertificate {
    /// <p>A reference to an object that represents the name of the secret requested from the
    /// Secret Discovery Service provider representing Transport Layer Security (TLS) materials like a certificate or
    /// certificate chain.</p>
    pub secret_name: std::option::Option<std::string::String>,
}
impl ListenerTlsSdsCertificate {
    /// <p>A reference to an object that represents the name of the secret requested from the
    /// Secret Discovery Service provider representing Transport Layer Security (TLS) materials like a certificate or
    /// certificate chain.</p>
    pub fn secret_name(&self) -> std::option::Option<&str> {
        self.secret_name.as_deref()
    }
}
impl std::fmt::Debug for ListenerTlsSdsCertificate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListenerTlsSdsCertificate");
        formatter.field("secret_name", &self.secret_name);
        formatter.finish()
    }
}
/// See [`ListenerTlsSdsCertificate`](crate::model::ListenerTlsSdsCertificate)
pub mod listener_tls_sds_certificate {
    /// A builder for [`ListenerTlsSdsCertificate`](crate::model::ListenerTlsSdsCertificate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) secret_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A reference to an object that represents the name of the secret requested from the
        /// Secret Discovery Service provider representing Transport Layer Security (TLS) materials like a certificate or
        /// certificate chain.</p>
        pub fn secret_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.secret_name = Some(input.into());
            self
        }
        /// <p>A reference to an object that represents the name of the secret requested from the
        /// Secret Discovery Service provider representing Transport Layer Security (TLS) materials like a certificate or
        /// certificate chain.</p>
        pub fn set_secret_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.secret_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ListenerTlsSdsCertificate`](crate::model::ListenerTlsSdsCertificate)
        pub fn build(self) -> crate::model::ListenerTlsSdsCertificate {
            crate::model::ListenerTlsSdsCertificate {
                secret_name: self.secret_name,
            }
        }
    }
}
impl ListenerTlsSdsCertificate {
    /// Creates a new builder-style object to manufacture [`ListenerTlsSdsCertificate`](crate::model::ListenerTlsSdsCertificate)
    pub fn builder() -> crate::model::listener_tls_sds_certificate::Builder {
        crate::model::listener_tls_sds_certificate::Builder::default()
    }
}

/// <p>An object that represents a local file certificate.
/// The certificate must meet specific requirements and you must have proxy authorization enabled. For more information, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html#virtual-node-tls-prerequisites">Transport Layer Security (TLS)</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListenerTlsFileCertificate {
    /// <p>The certificate chain for the certificate.</p>
    pub certificate_chain: std::option::Option<std::string::String>,
    /// <p>The private key for a certificate stored on the file system of the virtual node that the
    /// proxy is running on.</p>
    pub private_key: std::option::Option<std::string::String>,
}
impl ListenerTlsFileCertificate {
    /// <p>The certificate chain for the certificate.</p>
    pub fn certificate_chain(&self) -> std::option::Option<&str> {
        self.certificate_chain.as_deref()
    }
    /// <p>The private key for a certificate stored on the file system of the virtual node that the
    /// proxy is running on.</p>
    pub fn private_key(&self) -> std::option::Option<&str> {
        self.private_key.as_deref()
    }
}
impl std::fmt::Debug for ListenerTlsFileCertificate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListenerTlsFileCertificate");
        formatter.field("certificate_chain", &self.certificate_chain);
        formatter.field("private_key", &self.private_key);
        formatter.finish()
    }
}
/// See [`ListenerTlsFileCertificate`](crate::model::ListenerTlsFileCertificate)
pub mod listener_tls_file_certificate {
    /// A builder for [`ListenerTlsFileCertificate`](crate::model::ListenerTlsFileCertificate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_chain: std::option::Option<std::string::String>,
        pub(crate) private_key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The certificate chain for the certificate.</p>
        pub fn certificate_chain(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_chain = Some(input.into());
            self
        }
        /// <p>The certificate chain for the certificate.</p>
        pub fn set_certificate_chain(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_chain = input;
            self
        }
        /// <p>The private key for a certificate stored on the file system of the virtual node that the
        /// proxy is running on.</p>
        pub fn private_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.private_key = Some(input.into());
            self
        }
        /// <p>The private key for a certificate stored on the file system of the virtual node that the
        /// proxy is running on.</p>
        pub fn set_private_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.private_key = input;
            self
        }
        /// Consumes the builder and constructs a [`ListenerTlsFileCertificate`](crate::model::ListenerTlsFileCertificate)
        pub fn build(self) -> crate::model::ListenerTlsFileCertificate {
            crate::model::ListenerTlsFileCertificate {
                certificate_chain: self.certificate_chain,
                private_key: self.private_key,
            }
        }
    }
}
impl ListenerTlsFileCertificate {
    /// Creates a new builder-style object to manufacture [`ListenerTlsFileCertificate`](crate::model::ListenerTlsFileCertificate)
    pub fn builder() -> crate::model::listener_tls_file_certificate::Builder {
        crate::model::listener_tls_file_certificate::Builder::default()
    }
}

/// <p>An object that represents the backends that a virtual node is expected to send outbound
/// traffic to.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum Backend {
    /// <p>Specifies a virtual service to use as a backend.  </p>
    VirtualService(crate::model::VirtualServiceBackend),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl Backend {
    #[allow(irrefutable_let_patterns)]
    /// Tries to convert the enum instance into [`VirtualService`](crate::model::Backend::VirtualService), extracting the inner [`VirtualServiceBackend`](crate::model::VirtualServiceBackend).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_virtual_service(
        &self,
    ) -> std::result::Result<&crate::model::VirtualServiceBackend, &Self> {
        if let Backend::VirtualService(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`VirtualService`](crate::model::Backend::VirtualService).
    pub fn is_virtual_service(&self) -> bool {
        self.as_virtual_service().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

/// <p>An object that represents a virtual service backend for a virtual node.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VirtualServiceBackend {
    /// <p>The name of the virtual service that is acting as a virtual node backend.</p>
    pub virtual_service_name: std::option::Option<std::string::String>,
    /// <p>A reference to an object that represents the client policy for a backend.</p>
    pub client_policy: std::option::Option<crate::model::ClientPolicy>,
}
impl VirtualServiceBackend {
    /// <p>The name of the virtual service that is acting as a virtual node backend.</p>
    pub fn virtual_service_name(&self) -> std::option::Option<&str> {
        self.virtual_service_name.as_deref()
    }
    /// <p>A reference to an object that represents the client policy for a backend.</p>
    pub fn client_policy(&self) -> std::option::Option<&crate::model::ClientPolicy> {
        self.client_policy.as_ref()
    }
}
impl std::fmt::Debug for VirtualServiceBackend {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VirtualServiceBackend");
        formatter.field("virtual_service_name", &self.virtual_service_name);
        formatter.field("client_policy", &self.client_policy);
        formatter.finish()
    }
}
/// See [`VirtualServiceBackend`](crate::model::VirtualServiceBackend)
pub mod virtual_service_backend {
    /// A builder for [`VirtualServiceBackend`](crate::model::VirtualServiceBackend)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_service_name: std::option::Option<std::string::String>,
        pub(crate) client_policy: std::option::Option<crate::model::ClientPolicy>,
    }
    impl Builder {
        /// <p>The name of the virtual service that is acting as a virtual node backend.</p>
        pub fn virtual_service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_service_name = Some(input.into());
            self
        }
        /// <p>The name of the virtual service that is acting as a virtual node backend.</p>
        pub fn set_virtual_service_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_service_name = input;
            self
        }
        /// <p>A reference to an object that represents the client policy for a backend.</p>
        pub fn client_policy(mut self, input: crate::model::ClientPolicy) -> Self {
            self.client_policy = Some(input);
            self
        }
        /// <p>A reference to an object that represents the client policy for a backend.</p>
        pub fn set_client_policy(
            mut self,
            input: std::option::Option<crate::model::ClientPolicy>,
        ) -> Self {
            self.client_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`VirtualServiceBackend`](crate::model::VirtualServiceBackend)
        pub fn build(self) -> crate::model::VirtualServiceBackend {
            crate::model::VirtualServiceBackend {
                virtual_service_name: self.virtual_service_name,
                client_policy: self.client_policy,
            }
        }
    }
}
impl VirtualServiceBackend {
    /// Creates a new builder-style object to manufacture [`VirtualServiceBackend`](crate::model::VirtualServiceBackend)
    pub fn builder() -> crate::model::virtual_service_backend::Builder {
        crate::model::virtual_service_backend::Builder::default()
    }
}

/// <p>An object that represents a listener for a virtual node.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Listener {
    /// <p>The port mapping information for the listener.</p>
    pub port_mapping: std::option::Option<crate::model::PortMapping>,
    /// <p>A reference to an object that represents the Transport Layer Security (TLS) properties for a listener.</p>
    pub tls: std::option::Option<crate::model::ListenerTls>,
    /// <p>The health check information for the listener.</p>
    pub health_check: std::option::Option<crate::model::HealthCheckPolicy>,
    /// <p>An object that represents timeouts for different protocols.</p>
    pub timeout: std::option::Option<crate::model::ListenerTimeout>,
    /// <p>The outlier detection information for the listener.</p>
    pub outlier_detection: std::option::Option<crate::model::OutlierDetection>,
    /// <p>The connection pool information for the listener.</p>
    pub connection_pool: std::option::Option<crate::model::VirtualNodeConnectionPool>,
}
impl Listener {
    /// <p>The port mapping information for the listener.</p>
    pub fn port_mapping(&self) -> std::option::Option<&crate::model::PortMapping> {
        self.port_mapping.as_ref()
    }
    /// <p>A reference to an object that represents the Transport Layer Security (TLS) properties for a listener.</p>
    pub fn tls(&self) -> std::option::Option<&crate::model::ListenerTls> {
        self.tls.as_ref()
    }
    /// <p>The health check information for the listener.</p>
    pub fn health_check(&self) -> std::option::Option<&crate::model::HealthCheckPolicy> {
        self.health_check.as_ref()
    }
    /// <p>An object that represents timeouts for different protocols.</p>
    pub fn timeout(&self) -> std::option::Option<&crate::model::ListenerTimeout> {
        self.timeout.as_ref()
    }
    /// <p>The outlier detection information for the listener.</p>
    pub fn outlier_detection(&self) -> std::option::Option<&crate::model::OutlierDetection> {
        self.outlier_detection.as_ref()
    }
    /// <p>The connection pool information for the listener.</p>
    pub fn connection_pool(&self) -> std::option::Option<&crate::model::VirtualNodeConnectionPool> {
        self.connection_pool.as_ref()
    }
}
impl std::fmt::Debug for Listener {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Listener");
        formatter.field("port_mapping", &self.port_mapping);
        formatter.field("tls", &self.tls);
        formatter.field("health_check", &self.health_check);
        formatter.field("timeout", &self.timeout);
        formatter.field("outlier_detection", &self.outlier_detection);
        formatter.field("connection_pool", &self.connection_pool);
        formatter.finish()
    }
}
/// See [`Listener`](crate::model::Listener)
pub mod listener {
    /// A builder for [`Listener`](crate::model::Listener)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) port_mapping: std::option::Option<crate::model::PortMapping>,
        pub(crate) tls: std::option::Option<crate::model::ListenerTls>,
        pub(crate) health_check: std::option::Option<crate::model::HealthCheckPolicy>,
        pub(crate) timeout: std::option::Option<crate::model::ListenerTimeout>,
        pub(crate) outlier_detection: std::option::Option<crate::model::OutlierDetection>,
        pub(crate) connection_pool: std::option::Option<crate::model::VirtualNodeConnectionPool>,
    }
    impl Builder {
        /// <p>The port mapping information for the listener.</p>
        pub fn port_mapping(mut self, input: crate::model::PortMapping) -> Self {
            self.port_mapping = Some(input);
            self
        }
        /// <p>The port mapping information for the listener.</p>
        pub fn set_port_mapping(
            mut self,
            input: std::option::Option<crate::model::PortMapping>,
        ) -> Self {
            self.port_mapping = input;
            self
        }
        /// <p>A reference to an object that represents the Transport Layer Security (TLS) properties for a listener.</p>
        pub fn tls(mut self, input: crate::model::ListenerTls) -> Self {
            self.tls = Some(input);
            self
        }
        /// <p>A reference to an object that represents the Transport Layer Security (TLS) properties for a listener.</p>
        pub fn set_tls(mut self, input: std::option::Option<crate::model::ListenerTls>) -> Self {
            self.tls = input;
            self
        }
        /// <p>The health check information for the listener.</p>
        pub fn health_check(mut self, input: crate::model::HealthCheckPolicy) -> Self {
            self.health_check = Some(input);
            self
        }
        /// <p>The health check information for the listener.</p>
        pub fn set_health_check(
            mut self,
            input: std::option::Option<crate::model::HealthCheckPolicy>,
        ) -> Self {
            self.health_check = input;
            self
        }
        /// <p>An object that represents timeouts for different protocols.</p>
        pub fn timeout(mut self, input: crate::model::ListenerTimeout) -> Self {
            self.timeout = Some(input);
            self
        }
        /// <p>An object that represents timeouts for different protocols.</p>
        pub fn set_timeout(
            mut self,
            input: std::option::Option<crate::model::ListenerTimeout>,
        ) -> Self {
            self.timeout = input;
            self
        }
        /// <p>The outlier detection information for the listener.</p>
        pub fn outlier_detection(mut self, input: crate::model::OutlierDetection) -> Self {
            self.outlier_detection = Some(input);
            self
        }
        /// <p>The outlier detection information for the listener.</p>
        pub fn set_outlier_detection(
            mut self,
            input: std::option::Option<crate::model::OutlierDetection>,
        ) -> Self {
            self.outlier_detection = input;
            self
        }
        /// <p>The connection pool information for the listener.</p>
        pub fn connection_pool(mut self, input: crate::model::VirtualNodeConnectionPool) -> Self {
            self.connection_pool = Some(input);
            self
        }
        /// <p>The connection pool information for the listener.</p>
        pub fn set_connection_pool(
            mut self,
            input: std::option::Option<crate::model::VirtualNodeConnectionPool>,
        ) -> Self {
            self.connection_pool = input;
            self
        }
        /// Consumes the builder and constructs a [`Listener`](crate::model::Listener)
        pub fn build(self) -> crate::model::Listener {
            crate::model::Listener {
                port_mapping: self.port_mapping,
                tls: self.tls,
                health_check: self.health_check,
                timeout: self.timeout,
                outlier_detection: self.outlier_detection,
                connection_pool: self.connection_pool,
            }
        }
    }
}
impl Listener {
    /// Creates a new builder-style object to manufacture [`Listener`](crate::model::Listener)
    pub fn builder() -> crate::model::listener::Builder {
        crate::model::listener::Builder::default()
    }
}

/// <p>An object that represents the type of virtual node connection pool.</p>
/// <p>Only one protocol is used at a time and should be the same protocol as the one chosen
/// under port mapping.</p>
/// <p>If not present the default value for <code>maxPendingRequests</code> is
/// <code>2147483647</code>.</p>
/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum VirtualNodeConnectionPool {
    /// <p>An object that represents a type of connection pool.</p>
    Grpc(crate::model::VirtualNodeGrpcConnectionPool),
    /// <p>An object that represents a type of connection pool.</p>
    Http(crate::model::VirtualNodeHttpConnectionPool),
    /// <p>An object that represents a type of connection pool.</p>
    Http2(crate::model::VirtualNodeHttp2ConnectionPool),
    /// <p>An object that represents a type of connection pool.</p>
    Tcp(crate::model::VirtualNodeTcpConnectionPool),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl VirtualNodeConnectionPool {
    /// Tries to convert the enum instance into [`Grpc`](crate::model::VirtualNodeConnectionPool::Grpc), extracting the inner [`VirtualNodeGrpcConnectionPool`](crate::model::VirtualNodeGrpcConnectionPool).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_grpc(
        &self,
    ) -> std::result::Result<&crate::model::VirtualNodeGrpcConnectionPool, &Self> {
        if let VirtualNodeConnectionPool::Grpc(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Grpc`](crate::model::VirtualNodeConnectionPool::Grpc).
    pub fn is_grpc(&self) -> bool {
        self.as_grpc().is_ok()
    }
    /// Tries to convert the enum instance into [`Http`](crate::model::VirtualNodeConnectionPool::Http), extracting the inner [`VirtualNodeHttpConnectionPool`](crate::model::VirtualNodeHttpConnectionPool).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_http(
        &self,
    ) -> std::result::Result<&crate::model::VirtualNodeHttpConnectionPool, &Self> {
        if let VirtualNodeConnectionPool::Http(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Http`](crate::model::VirtualNodeConnectionPool::Http).
    pub fn is_http(&self) -> bool {
        self.as_http().is_ok()
    }
    /// Tries to convert the enum instance into [`Http2`](crate::model::VirtualNodeConnectionPool::Http2), extracting the inner [`VirtualNodeHttp2ConnectionPool`](crate::model::VirtualNodeHttp2ConnectionPool).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_http2(
        &self,
    ) -> std::result::Result<&crate::model::VirtualNodeHttp2ConnectionPool, &Self> {
        if let VirtualNodeConnectionPool::Http2(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Http2`](crate::model::VirtualNodeConnectionPool::Http2).
    pub fn is_http2(&self) -> bool {
        self.as_http2().is_ok()
    }
    /// Tries to convert the enum instance into [`Tcp`](crate::model::VirtualNodeConnectionPool::Tcp), extracting the inner [`VirtualNodeTcpConnectionPool`](crate::model::VirtualNodeTcpConnectionPool).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_tcp(
        &self,
    ) -> std::result::Result<&crate::model::VirtualNodeTcpConnectionPool, &Self> {
        if let VirtualNodeConnectionPool::Tcp(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Tcp`](crate::model::VirtualNodeConnectionPool::Tcp).
    pub fn is_tcp(&self) -> bool {
        self.as_tcp().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

/// <p>An object that represents a type of connection pool.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VirtualNodeGrpcConnectionPool {
    /// <p>Maximum number of inflight requests Envoy can concurrently support across hosts in
    /// upstream cluster.</p>
    pub max_requests: i32,
}
impl VirtualNodeGrpcConnectionPool {
    /// <p>Maximum number of inflight requests Envoy can concurrently support across hosts in
    /// upstream cluster.</p>
    pub fn max_requests(&self) -> i32 {
        self.max_requests
    }
}
impl std::fmt::Debug for VirtualNodeGrpcConnectionPool {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VirtualNodeGrpcConnectionPool");
        formatter.field("max_requests", &self.max_requests);
        formatter.finish()
    }
}
/// See [`VirtualNodeGrpcConnectionPool`](crate::model::VirtualNodeGrpcConnectionPool)
pub mod virtual_node_grpc_connection_pool {
    /// A builder for [`VirtualNodeGrpcConnectionPool`](crate::model::VirtualNodeGrpcConnectionPool)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_requests: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Maximum number of inflight requests Envoy can concurrently support across hosts in
        /// upstream cluster.</p>
        pub fn max_requests(mut self, input: i32) -> Self {
            self.max_requests = Some(input);
            self
        }
        /// <p>Maximum number of inflight requests Envoy can concurrently support across hosts in
        /// upstream cluster.</p>
        pub fn set_max_requests(mut self, input: std::option::Option<i32>) -> Self {
            self.max_requests = input;
            self
        }
        /// Consumes the builder and constructs a [`VirtualNodeGrpcConnectionPool`](crate::model::VirtualNodeGrpcConnectionPool)
        pub fn build(self) -> crate::model::VirtualNodeGrpcConnectionPool {
            crate::model::VirtualNodeGrpcConnectionPool {
                max_requests: self.max_requests.unwrap_or_default(),
            }
        }
    }
}
impl VirtualNodeGrpcConnectionPool {
    /// Creates a new builder-style object to manufacture [`VirtualNodeGrpcConnectionPool`](crate::model::VirtualNodeGrpcConnectionPool)
    pub fn builder() -> crate::model::virtual_node_grpc_connection_pool::Builder {
        crate::model::virtual_node_grpc_connection_pool::Builder::default()
    }
}

/// <p>An object that represents a type of connection pool.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VirtualNodeHttp2ConnectionPool {
    /// <p>Maximum number of inflight requests Envoy can concurrently support across hosts in
    /// upstream cluster.</p>
    pub max_requests: i32,
}
impl VirtualNodeHttp2ConnectionPool {
    /// <p>Maximum number of inflight requests Envoy can concurrently support across hosts in
    /// upstream cluster.</p>
    pub fn max_requests(&self) -> i32 {
        self.max_requests
    }
}
impl std::fmt::Debug for VirtualNodeHttp2ConnectionPool {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VirtualNodeHttp2ConnectionPool");
        formatter.field("max_requests", &self.max_requests);
        formatter.finish()
    }
}
/// See [`VirtualNodeHttp2ConnectionPool`](crate::model::VirtualNodeHttp2ConnectionPool)
pub mod virtual_node_http2_connection_pool {
    /// A builder for [`VirtualNodeHttp2ConnectionPool`](crate::model::VirtualNodeHttp2ConnectionPool)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_requests: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Maximum number of inflight requests Envoy can concurrently support across hosts in
        /// upstream cluster.</p>
        pub fn max_requests(mut self, input: i32) -> Self {
            self.max_requests = Some(input);
            self
        }
        /// <p>Maximum number of inflight requests Envoy can concurrently support across hosts in
        /// upstream cluster.</p>
        pub fn set_max_requests(mut self, input: std::option::Option<i32>) -> Self {
            self.max_requests = input;
            self
        }
        /// Consumes the builder and constructs a [`VirtualNodeHttp2ConnectionPool`](crate::model::VirtualNodeHttp2ConnectionPool)
        pub fn build(self) -> crate::model::VirtualNodeHttp2ConnectionPool {
            crate::model::VirtualNodeHttp2ConnectionPool {
                max_requests: self.max_requests.unwrap_or_default(),
            }
        }
    }
}
impl VirtualNodeHttp2ConnectionPool {
    /// Creates a new builder-style object to manufacture [`VirtualNodeHttp2ConnectionPool`](crate::model::VirtualNodeHttp2ConnectionPool)
    pub fn builder() -> crate::model::virtual_node_http2_connection_pool::Builder {
        crate::model::virtual_node_http2_connection_pool::Builder::default()
    }
}

/// <p>An object that represents a type of connection pool.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VirtualNodeHttpConnectionPool {
    /// <p>Maximum number of outbound TCP connections Envoy can establish concurrently with all
    /// hosts in upstream cluster.</p>
    pub max_connections: i32,
    /// <p>Number of overflowing requests after <code>max_connections</code> Envoy will queue to
    /// upstream cluster.</p>
    pub max_pending_requests: std::option::Option<i32>,
}
impl VirtualNodeHttpConnectionPool {
    /// <p>Maximum number of outbound TCP connections Envoy can establish concurrently with all
    /// hosts in upstream cluster.</p>
    pub fn max_connections(&self) -> i32 {
        self.max_connections
    }
    /// <p>Number of overflowing requests after <code>max_connections</code> Envoy will queue to
    /// upstream cluster.</p>
    pub fn max_pending_requests(&self) -> std::option::Option<i32> {
        self.max_pending_requests
    }
}
impl std::fmt::Debug for VirtualNodeHttpConnectionPool {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VirtualNodeHttpConnectionPool");
        formatter.field("max_connections", &self.max_connections);
        formatter.field("max_pending_requests", &self.max_pending_requests);
        formatter.finish()
    }
}
/// See [`VirtualNodeHttpConnectionPool`](crate::model::VirtualNodeHttpConnectionPool)
pub mod virtual_node_http_connection_pool {
    /// A builder for [`VirtualNodeHttpConnectionPool`](crate::model::VirtualNodeHttpConnectionPool)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_connections: std::option::Option<i32>,
        pub(crate) max_pending_requests: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Maximum number of outbound TCP connections Envoy can establish concurrently with all
        /// hosts in upstream cluster.</p>
        pub fn max_connections(mut self, input: i32) -> Self {
            self.max_connections = Some(input);
            self
        }
        /// <p>Maximum number of outbound TCP connections Envoy can establish concurrently with all
        /// hosts in upstream cluster.</p>
        pub fn set_max_connections(mut self, input: std::option::Option<i32>) -> Self {
            self.max_connections = input;
            self
        }
        /// <p>Number of overflowing requests after <code>max_connections</code> Envoy will queue to
        /// upstream cluster.</p>
        pub fn max_pending_requests(mut self, input: i32) -> Self {
            self.max_pending_requests = Some(input);
            self
        }
        /// <p>Number of overflowing requests after <code>max_connections</code> Envoy will queue to
        /// upstream cluster.</p>
        pub fn set_max_pending_requests(mut self, input: std::option::Option<i32>) -> Self {
            self.max_pending_requests = input;
            self
        }
        /// Consumes the builder and constructs a [`VirtualNodeHttpConnectionPool`](crate::model::VirtualNodeHttpConnectionPool)
        pub fn build(self) -> crate::model::VirtualNodeHttpConnectionPool {
            crate::model::VirtualNodeHttpConnectionPool {
                max_connections: self.max_connections.unwrap_or_default(),
                max_pending_requests: self.max_pending_requests,
            }
        }
    }
}
impl VirtualNodeHttpConnectionPool {
    /// Creates a new builder-style object to manufacture [`VirtualNodeHttpConnectionPool`](crate::model::VirtualNodeHttpConnectionPool)
    pub fn builder() -> crate::model::virtual_node_http_connection_pool::Builder {
        crate::model::virtual_node_http_connection_pool::Builder::default()
    }
}

/// <p>An object that represents a type of connection pool.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VirtualNodeTcpConnectionPool {
    /// <p>Maximum number of outbound TCP connections Envoy can establish concurrently with all
    /// hosts in upstream cluster.</p>
    pub max_connections: i32,
}
impl VirtualNodeTcpConnectionPool {
    /// <p>Maximum number of outbound TCP connections Envoy can establish concurrently with all
    /// hosts in upstream cluster.</p>
    pub fn max_connections(&self) -> i32 {
        self.max_connections
    }
}
impl std::fmt::Debug for VirtualNodeTcpConnectionPool {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VirtualNodeTcpConnectionPool");
        formatter.field("max_connections", &self.max_connections);
        formatter.finish()
    }
}
/// See [`VirtualNodeTcpConnectionPool`](crate::model::VirtualNodeTcpConnectionPool)
pub mod virtual_node_tcp_connection_pool {
    /// A builder for [`VirtualNodeTcpConnectionPool`](crate::model::VirtualNodeTcpConnectionPool)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_connections: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Maximum number of outbound TCP connections Envoy can establish concurrently with all
        /// hosts in upstream cluster.</p>
        pub fn max_connections(mut self, input: i32) -> Self {
            self.max_connections = Some(input);
            self
        }
        /// <p>Maximum number of outbound TCP connections Envoy can establish concurrently with all
        /// hosts in upstream cluster.</p>
        pub fn set_max_connections(mut self, input: std::option::Option<i32>) -> Self {
            self.max_connections = input;
            self
        }
        /// Consumes the builder and constructs a [`VirtualNodeTcpConnectionPool`](crate::model::VirtualNodeTcpConnectionPool)
        pub fn build(self) -> crate::model::VirtualNodeTcpConnectionPool {
            crate::model::VirtualNodeTcpConnectionPool {
                max_connections: self.max_connections.unwrap_or_default(),
            }
        }
    }
}
impl VirtualNodeTcpConnectionPool {
    /// Creates a new builder-style object to manufacture [`VirtualNodeTcpConnectionPool`](crate::model::VirtualNodeTcpConnectionPool)
    pub fn builder() -> crate::model::virtual_node_tcp_connection_pool::Builder {
        crate::model::virtual_node_tcp_connection_pool::Builder::default()
    }
}

/// <p>An object that represents the outlier detection for a virtual node's listener.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OutlierDetection {
    /// <p>Number of consecutive <code>5xx</code> errors required for ejection. </p>
    pub max_server_errors: std::option::Option<i64>,
    /// <p>The time interval between ejection sweep analysis.</p>
    pub interval: std::option::Option<crate::model::Duration>,
    /// <p>The base amount of time for which a host is ejected.</p>
    pub base_ejection_duration: std::option::Option<crate::model::Duration>,
    /// <p>Maximum percentage of hosts in load balancing pool for upstream service that can be
    /// ejected. Will eject at least one host regardless of the value.</p>
    pub max_ejection_percent: std::option::Option<i32>,
}
impl OutlierDetection {
    /// <p>Number of consecutive <code>5xx</code> errors required for ejection. </p>
    pub fn max_server_errors(&self) -> std::option::Option<i64> {
        self.max_server_errors
    }
    /// <p>The time interval between ejection sweep analysis.</p>
    pub fn interval(&self) -> std::option::Option<&crate::model::Duration> {
        self.interval.as_ref()
    }
    /// <p>The base amount of time for which a host is ejected.</p>
    pub fn base_ejection_duration(&self) -> std::option::Option<&crate::model::Duration> {
        self.base_ejection_duration.as_ref()
    }
    /// <p>Maximum percentage of hosts in load balancing pool for upstream service that can be
    /// ejected. Will eject at least one host regardless of the value.</p>
    pub fn max_ejection_percent(&self) -> std::option::Option<i32> {
        self.max_ejection_percent
    }
}
impl std::fmt::Debug for OutlierDetection {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OutlierDetection");
        formatter.field("max_server_errors", &self.max_server_errors);
        formatter.field("interval", &self.interval);
        formatter.field("base_ejection_duration", &self.base_ejection_duration);
        formatter.field("max_ejection_percent", &self.max_ejection_percent);
        formatter.finish()
    }
}
/// See [`OutlierDetection`](crate::model::OutlierDetection)
pub mod outlier_detection {
    /// A builder for [`OutlierDetection`](crate::model::OutlierDetection)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_server_errors: std::option::Option<i64>,
        pub(crate) interval: std::option::Option<crate::model::Duration>,
        pub(crate) base_ejection_duration: std::option::Option<crate::model::Duration>,
        pub(crate) max_ejection_percent: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Number of consecutive <code>5xx</code> errors required for ejection. </p>
        pub fn max_server_errors(mut self, input: i64) -> Self {
            self.max_server_errors = Some(input);
            self
        }
        /// <p>Number of consecutive <code>5xx</code> errors required for ejection. </p>
        pub fn set_max_server_errors(mut self, input: std::option::Option<i64>) -> Self {
            self.max_server_errors = input;
            self
        }
        /// <p>The time interval between ejection sweep analysis.</p>
        pub fn interval(mut self, input: crate::model::Duration) -> Self {
            self.interval = Some(input);
            self
        }
        /// <p>The time interval between ejection sweep analysis.</p>
        pub fn set_interval(mut self, input: std::option::Option<crate::model::Duration>) -> Self {
            self.interval = input;
            self
        }
        /// <p>The base amount of time for which a host is ejected.</p>
        pub fn base_ejection_duration(mut self, input: crate::model::Duration) -> Self {
            self.base_ejection_duration = Some(input);
            self
        }
        /// <p>The base amount of time for which a host is ejected.</p>
        pub fn set_base_ejection_duration(
            mut self,
            input: std::option::Option<crate::model::Duration>,
        ) -> Self {
            self.base_ejection_duration = input;
            self
        }
        /// <p>Maximum percentage of hosts in load balancing pool for upstream service that can be
        /// ejected. Will eject at least one host regardless of the value.</p>
        pub fn max_ejection_percent(mut self, input: i32) -> Self {
            self.max_ejection_percent = Some(input);
            self
        }
        /// <p>Maximum percentage of hosts in load balancing pool for upstream service that can be
        /// ejected. Will eject at least one host regardless of the value.</p>
        pub fn set_max_ejection_percent(mut self, input: std::option::Option<i32>) -> Self {
            self.max_ejection_percent = input;
            self
        }
        /// Consumes the builder and constructs a [`OutlierDetection`](crate::model::OutlierDetection)
        pub fn build(self) -> crate::model::OutlierDetection {
            crate::model::OutlierDetection {
                max_server_errors: self.max_server_errors,
                interval: self.interval,
                base_ejection_duration: self.base_ejection_duration,
                max_ejection_percent: self.max_ejection_percent,
            }
        }
    }
}
impl OutlierDetection {
    /// Creates a new builder-style object to manufacture [`OutlierDetection`](crate::model::OutlierDetection)
    pub fn builder() -> crate::model::outlier_detection::Builder {
        crate::model::outlier_detection::Builder::default()
    }
}

/// <p>An object that represents timeouts for different protocols.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum ListenerTimeout {
    /// <p>An object that represents types of timeouts. </p>
    Grpc(crate::model::GrpcTimeout),
    /// <p>An object that represents types of timeouts. </p>
    Http(crate::model::HttpTimeout),
    /// <p>An object that represents types of timeouts. </p>
    Http2(crate::model::HttpTimeout),
    /// <p>An object that represents types of timeouts. </p>
    Tcp(crate::model::TcpTimeout),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl ListenerTimeout {
    /// Tries to convert the enum instance into [`Grpc`](crate::model::ListenerTimeout::Grpc), extracting the inner [`GrpcTimeout`](crate::model::GrpcTimeout).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_grpc(&self) -> std::result::Result<&crate::model::GrpcTimeout, &Self> {
        if let ListenerTimeout::Grpc(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Grpc`](crate::model::ListenerTimeout::Grpc).
    pub fn is_grpc(&self) -> bool {
        self.as_grpc().is_ok()
    }
    /// Tries to convert the enum instance into [`Http`](crate::model::ListenerTimeout::Http), extracting the inner [`HttpTimeout`](crate::model::HttpTimeout).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_http(&self) -> std::result::Result<&crate::model::HttpTimeout, &Self> {
        if let ListenerTimeout::Http(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Http`](crate::model::ListenerTimeout::Http).
    pub fn is_http(&self) -> bool {
        self.as_http().is_ok()
    }
    /// Tries to convert the enum instance into [`Http2`](crate::model::ListenerTimeout::Http2), extracting the inner [`HttpTimeout`](crate::model::HttpTimeout).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_http2(&self) -> std::result::Result<&crate::model::HttpTimeout, &Self> {
        if let ListenerTimeout::Http2(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Http2`](crate::model::ListenerTimeout::Http2).
    pub fn is_http2(&self) -> bool {
        self.as_http2().is_ok()
    }
    /// Tries to convert the enum instance into [`Tcp`](crate::model::ListenerTimeout::Tcp), extracting the inner [`TcpTimeout`](crate::model::TcpTimeout).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_tcp(&self) -> std::result::Result<&crate::model::TcpTimeout, &Self> {
        if let ListenerTimeout::Tcp(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Tcp`](crate::model::ListenerTimeout::Tcp).
    pub fn is_tcp(&self) -> bool {
        self.as_tcp().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

/// <p>An object that represents the health check policy for a virtual node's listener.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HealthCheckPolicy {
    /// <p>The amount of time to wait when receiving a response from the health check, in
    /// milliseconds.</p>
    pub timeout_millis: std::option::Option<i64>,
    /// <p>The time period in milliseconds between each health check execution.</p>
    pub interval_millis: std::option::Option<i64>,
    /// <p>The protocol for the health check request. If you specify <code>grpc</code>, then your
    /// service must conform to the <a href="https://github.com/grpc/grpc/blob/master/doc/health-checking.md">GRPC Health
    /// Checking Protocol</a>.</p>
    pub protocol: std::option::Option<crate::model::PortProtocol>,
    /// <p>The destination port for the health check request. This port must match the port defined
    /// in the <a>PortMapping</a> for the listener.</p>
    pub port: i32,
    /// <p>The destination path for the health check request. This value is only used if the
    /// specified protocol is HTTP or HTTP/2. For any other protocol, this value is ignored.</p>
    pub path: std::option::Option<std::string::String>,
    /// <p>The number of consecutive successful health checks that must occur before declaring
    /// listener healthy.</p>
    pub healthy_threshold: i32,
    /// <p>The number of consecutive failed health checks that must occur before declaring a
    /// virtual node unhealthy. </p>
    pub unhealthy_threshold: i32,
}
impl HealthCheckPolicy {
    /// <p>The amount of time to wait when receiving a response from the health check, in
    /// milliseconds.</p>
    pub fn timeout_millis(&self) -> std::option::Option<i64> {
        self.timeout_millis
    }
    /// <p>The time period in milliseconds between each health check execution.</p>
    pub fn interval_millis(&self) -> std::option::Option<i64> {
        self.interval_millis
    }
    /// <p>The protocol for the health check request. If you specify <code>grpc</code>, then your
    /// service must conform to the <a href="https://github.com/grpc/grpc/blob/master/doc/health-checking.md">GRPC Health
    /// Checking Protocol</a>.</p>
    pub fn protocol(&self) -> std::option::Option<&crate::model::PortProtocol> {
        self.protocol.as_ref()
    }
    /// <p>The destination port for the health check request. This port must match the port defined
    /// in the <a>PortMapping</a> for the listener.</p>
    pub fn port(&self) -> i32 {
        self.port
    }
    /// <p>The destination path for the health check request. This value is only used if the
    /// specified protocol is HTTP or HTTP/2. For any other protocol, this value is ignored.</p>
    pub fn path(&self) -> std::option::Option<&str> {
        self.path.as_deref()
    }
    /// <p>The number of consecutive successful health checks that must occur before declaring
    /// listener healthy.</p>
    pub fn healthy_threshold(&self) -> i32 {
        self.healthy_threshold
    }
    /// <p>The number of consecutive failed health checks that must occur before declaring a
    /// virtual node unhealthy. </p>
    pub fn unhealthy_threshold(&self) -> i32 {
        self.unhealthy_threshold
    }
}
impl std::fmt::Debug for HealthCheckPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HealthCheckPolicy");
        formatter.field("timeout_millis", &self.timeout_millis);
        formatter.field("interval_millis", &self.interval_millis);
        formatter.field("protocol", &self.protocol);
        formatter.field("port", &self.port);
        formatter.field("path", &self.path);
        formatter.field("healthy_threshold", &self.healthy_threshold);
        formatter.field("unhealthy_threshold", &self.unhealthy_threshold);
        formatter.finish()
    }
}
/// See [`HealthCheckPolicy`](crate::model::HealthCheckPolicy)
pub mod health_check_policy {
    /// A builder for [`HealthCheckPolicy`](crate::model::HealthCheckPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) timeout_millis: std::option::Option<i64>,
        pub(crate) interval_millis: std::option::Option<i64>,
        pub(crate) protocol: std::option::Option<crate::model::PortProtocol>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) path: std::option::Option<std::string::String>,
        pub(crate) healthy_threshold: std::option::Option<i32>,
        pub(crate) unhealthy_threshold: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The amount of time to wait when receiving a response from the health check, in
        /// milliseconds.</p>
        pub fn timeout_millis(mut self, input: i64) -> Self {
            self.timeout_millis = Some(input);
            self
        }
        /// <p>The amount of time to wait when receiving a response from the health check, in
        /// milliseconds.</p>
        pub fn set_timeout_millis(mut self, input: std::option::Option<i64>) -> Self {
            self.timeout_millis = input;
            self
        }
        /// <p>The time period in milliseconds between each health check execution.</p>
        pub fn interval_millis(mut self, input: i64) -> Self {
            self.interval_millis = Some(input);
            self
        }
        /// <p>The time period in milliseconds between each health check execution.</p>
        pub fn set_interval_millis(mut self, input: std::option::Option<i64>) -> Self {
            self.interval_millis = input;
            self
        }
        /// <p>The protocol for the health check request. If you specify <code>grpc</code>, then your
        /// service must conform to the <a href="https://github.com/grpc/grpc/blob/master/doc/health-checking.md">GRPC Health
        /// Checking Protocol</a>.</p>
        pub fn protocol(mut self, input: crate::model::PortProtocol) -> Self {
            self.protocol = Some(input);
            self
        }
        /// <p>The protocol for the health check request. If you specify <code>grpc</code>, then your
        /// service must conform to the <a href="https://github.com/grpc/grpc/blob/master/doc/health-checking.md">GRPC Health
        /// Checking Protocol</a>.</p>
        pub fn set_protocol(
            mut self,
            input: std::option::Option<crate::model::PortProtocol>,
        ) -> Self {
            self.protocol = input;
            self
        }
        /// <p>The destination port for the health check request. This port must match the port defined
        /// in the <a>PortMapping</a> for the listener.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The destination port for the health check request. This port must match the port defined
        /// in the <a>PortMapping</a> for the listener.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>The destination path for the health check request. This value is only used if the
        /// specified protocol is HTTP or HTTP/2. For any other protocol, this value is ignored.</p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p>The destination path for the health check request. This value is only used if the
        /// specified protocol is HTTP or HTTP/2. For any other protocol, this value is ignored.</p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// <p>The number of consecutive successful health checks that must occur before declaring
        /// listener healthy.</p>
        pub fn healthy_threshold(mut self, input: i32) -> Self {
            self.healthy_threshold = Some(input);
            self
        }
        /// <p>The number of consecutive successful health checks that must occur before declaring
        /// listener healthy.</p>
        pub fn set_healthy_threshold(mut self, input: std::option::Option<i32>) -> Self {
            self.healthy_threshold = input;
            self
        }
        /// <p>The number of consecutive failed health checks that must occur before declaring a
        /// virtual node unhealthy. </p>
        pub fn unhealthy_threshold(mut self, input: i32) -> Self {
            self.unhealthy_threshold = Some(input);
            self
        }
        /// <p>The number of consecutive failed health checks that must occur before declaring a
        /// virtual node unhealthy. </p>
        pub fn set_unhealthy_threshold(mut self, input: std::option::Option<i32>) -> Self {
            self.unhealthy_threshold = input;
            self
        }
        /// Consumes the builder and constructs a [`HealthCheckPolicy`](crate::model::HealthCheckPolicy)
        pub fn build(self) -> crate::model::HealthCheckPolicy {
            crate::model::HealthCheckPolicy {
                timeout_millis: self.timeout_millis,
                interval_millis: self.interval_millis,
                protocol: self.protocol,
                port: self.port.unwrap_or_default(),
                path: self.path,
                healthy_threshold: self.healthy_threshold.unwrap_or_default(),
                unhealthy_threshold: self.unhealthy_threshold.unwrap_or_default(),
            }
        }
    }
}
impl HealthCheckPolicy {
    /// Creates a new builder-style object to manufacture [`HealthCheckPolicy`](crate::model::HealthCheckPolicy)
    pub fn builder() -> crate::model::health_check_policy::Builder {
        crate::model::health_check_policy::Builder::default()
    }
}

/// <p>An object that represents the Transport Layer Security (TLS) properties for a listener.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListenerTls {
    /// <p>Specify one of the following modes.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b/>STRICT – Listener only accepts connections with TLS
    /// enabled. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <b/>PERMISSIVE – Listener accepts connections with or
    /// without TLS enabled.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b/>DISABLED – Listener only accepts connections without
    /// TLS. </p>
    /// </li>
    /// </ul>
    pub mode: std::option::Option<crate::model::ListenerTlsMode>,
    /// <p>A reference to an object that represents a listener's Transport Layer Security (TLS) certificate.</p>
    pub certificate: std::option::Option<crate::model::ListenerTlsCertificate>,
    /// <p>A reference to an object that represents a listener's Transport Layer Security (TLS) validation context.</p>
    pub validation: std::option::Option<crate::model::ListenerTlsValidationContext>,
}
impl ListenerTls {
    /// <p>Specify one of the following modes.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b/>STRICT – Listener only accepts connections with TLS
    /// enabled. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <b/>PERMISSIVE – Listener accepts connections with or
    /// without TLS enabled.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b/>DISABLED – Listener only accepts connections without
    /// TLS. </p>
    /// </li>
    /// </ul>
    pub fn mode(&self) -> std::option::Option<&crate::model::ListenerTlsMode> {
        self.mode.as_ref()
    }
    /// <p>A reference to an object that represents a listener's Transport Layer Security (TLS) certificate.</p>
    pub fn certificate(&self) -> std::option::Option<&crate::model::ListenerTlsCertificate> {
        self.certificate.as_ref()
    }
    /// <p>A reference to an object that represents a listener's Transport Layer Security (TLS) validation context.</p>
    pub fn validation(&self) -> std::option::Option<&crate::model::ListenerTlsValidationContext> {
        self.validation.as_ref()
    }
}
impl std::fmt::Debug for ListenerTls {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListenerTls");
        formatter.field("mode", &self.mode);
        formatter.field("certificate", &self.certificate);
        formatter.field("validation", &self.validation);
        formatter.finish()
    }
}
/// See [`ListenerTls`](crate::model::ListenerTls)
pub mod listener_tls {
    /// A builder for [`ListenerTls`](crate::model::ListenerTls)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mode: std::option::Option<crate::model::ListenerTlsMode>,
        pub(crate) certificate: std::option::Option<crate::model::ListenerTlsCertificate>,
        pub(crate) validation: std::option::Option<crate::model::ListenerTlsValidationContext>,
    }
    impl Builder {
        /// <p>Specify one of the following modes.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b/>STRICT – Listener only accepts connections with TLS
        /// enabled. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b/>PERMISSIVE – Listener accepts connections with or
        /// without TLS enabled.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b/>DISABLED – Listener only accepts connections without
        /// TLS. </p>
        /// </li>
        /// </ul>
        pub fn mode(mut self, input: crate::model::ListenerTlsMode) -> Self {
            self.mode = Some(input);
            self
        }
        /// <p>Specify one of the following modes.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b/>STRICT – Listener only accepts connections with TLS
        /// enabled. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b/>PERMISSIVE – Listener accepts connections with or
        /// without TLS enabled.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b/>DISABLED – Listener only accepts connections without
        /// TLS. </p>
        /// </li>
        /// </ul>
        pub fn set_mode(
            mut self,
            input: std::option::Option<crate::model::ListenerTlsMode>,
        ) -> Self {
            self.mode = input;
            self
        }
        /// <p>A reference to an object that represents a listener's Transport Layer Security (TLS) certificate.</p>
        pub fn certificate(mut self, input: crate::model::ListenerTlsCertificate) -> Self {
            self.certificate = Some(input);
            self
        }
        /// <p>A reference to an object that represents a listener's Transport Layer Security (TLS) certificate.</p>
        pub fn set_certificate(
            mut self,
            input: std::option::Option<crate::model::ListenerTlsCertificate>,
        ) -> Self {
            self.certificate = input;
            self
        }
        /// <p>A reference to an object that represents a listener's Transport Layer Security (TLS) validation context.</p>
        pub fn validation(mut self, input: crate::model::ListenerTlsValidationContext) -> Self {
            self.validation = Some(input);
            self
        }
        /// <p>A reference to an object that represents a listener's Transport Layer Security (TLS) validation context.</p>
        pub fn set_validation(
            mut self,
            input: std::option::Option<crate::model::ListenerTlsValidationContext>,
        ) -> Self {
            self.validation = input;
            self
        }
        /// Consumes the builder and constructs a [`ListenerTls`](crate::model::ListenerTls)
        pub fn build(self) -> crate::model::ListenerTls {
            crate::model::ListenerTls {
                mode: self.mode,
                certificate: self.certificate,
                validation: self.validation,
            }
        }
    }
}
impl ListenerTls {
    /// Creates a new builder-style object to manufacture [`ListenerTls`](crate::model::ListenerTls)
    pub fn builder() -> crate::model::listener_tls::Builder {
        crate::model::listener_tls::Builder::default()
    }
}

/// <p>An object that represents a listener's Transport Layer Security (TLS) validation context.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListenerTlsValidationContext {
    /// <p>A reference to where to retrieve the trust chain when validating a peer’s Transport Layer Security (TLS)
    /// certificate.</p>
    pub trust: std::option::Option<crate::model::ListenerTlsValidationContextTrust>,
    /// <p>A reference to an object that represents the SANs for a listener's Transport Layer Security (TLS) validation
    /// context.</p>
    pub subject_alternative_names: std::option::Option<crate::model::SubjectAlternativeNames>,
}
impl ListenerTlsValidationContext {
    /// <p>A reference to where to retrieve the trust chain when validating a peer’s Transport Layer Security (TLS)
    /// certificate.</p>
    pub fn trust(&self) -> std::option::Option<&crate::model::ListenerTlsValidationContextTrust> {
        self.trust.as_ref()
    }
    /// <p>A reference to an object that represents the SANs for a listener's Transport Layer Security (TLS) validation
    /// context.</p>
    pub fn subject_alternative_names(
        &self,
    ) -> std::option::Option<&crate::model::SubjectAlternativeNames> {
        self.subject_alternative_names.as_ref()
    }
}
impl std::fmt::Debug for ListenerTlsValidationContext {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListenerTlsValidationContext");
        formatter.field("trust", &self.trust);
        formatter.field("subject_alternative_names", &self.subject_alternative_names);
        formatter.finish()
    }
}
/// See [`ListenerTlsValidationContext`](crate::model::ListenerTlsValidationContext)
pub mod listener_tls_validation_context {
    /// A builder for [`ListenerTlsValidationContext`](crate::model::ListenerTlsValidationContext)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trust: std::option::Option<crate::model::ListenerTlsValidationContextTrust>,
        pub(crate) subject_alternative_names:
            std::option::Option<crate::model::SubjectAlternativeNames>,
    }
    impl Builder {
        /// <p>A reference to where to retrieve the trust chain when validating a peer’s Transport Layer Security (TLS)
        /// certificate.</p>
        pub fn trust(mut self, input: crate::model::ListenerTlsValidationContextTrust) -> Self {
            self.trust = Some(input);
            self
        }
        /// <p>A reference to where to retrieve the trust chain when validating a peer’s Transport Layer Security (TLS)
        /// certificate.</p>
        pub fn set_trust(
            mut self,
            input: std::option::Option<crate::model::ListenerTlsValidationContextTrust>,
        ) -> Self {
            self.trust = input;
            self
        }
        /// <p>A reference to an object that represents the SANs for a listener's Transport Layer Security (TLS) validation
        /// context.</p>
        pub fn subject_alternative_names(
            mut self,
            input: crate::model::SubjectAlternativeNames,
        ) -> Self {
            self.subject_alternative_names = Some(input);
            self
        }
        /// <p>A reference to an object that represents the SANs for a listener's Transport Layer Security (TLS) validation
        /// context.</p>
        pub fn set_subject_alternative_names(
            mut self,
            input: std::option::Option<crate::model::SubjectAlternativeNames>,
        ) -> Self {
            self.subject_alternative_names = input;
            self
        }
        /// Consumes the builder and constructs a [`ListenerTlsValidationContext`](crate::model::ListenerTlsValidationContext)
        pub fn build(self) -> crate::model::ListenerTlsValidationContext {
            crate::model::ListenerTlsValidationContext {
                trust: self.trust,
                subject_alternative_names: self.subject_alternative_names,
            }
        }
    }
}
impl ListenerTlsValidationContext {
    /// Creates a new builder-style object to manufacture [`ListenerTlsValidationContext`](crate::model::ListenerTlsValidationContext)
    pub fn builder() -> crate::model::listener_tls_validation_context::Builder {
        crate::model::listener_tls_validation_context::Builder::default()
    }
}

/// <p>An object that represents a listener's Transport Layer Security (TLS) validation context trust.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum ListenerTlsValidationContextTrust {
    /// <p>An object that represents a Transport Layer Security (TLS) validation context trust for a local file.</p>
    File(crate::model::TlsValidationContextFileTrust),
    /// <p>A reference to an object that represents a listener's Transport Layer Security (TLS) Secret Discovery Service
    /// validation context trust.</p>
    Sds(crate::model::TlsValidationContextSdsTrust),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl ListenerTlsValidationContextTrust {
    /// Tries to convert the enum instance into [`File`](crate::model::ListenerTlsValidationContextTrust::File), extracting the inner [`TlsValidationContextFileTrust`](crate::model::TlsValidationContextFileTrust).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_file(
        &self,
    ) -> std::result::Result<&crate::model::TlsValidationContextFileTrust, &Self> {
        if let ListenerTlsValidationContextTrust::File(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`File`](crate::model::ListenerTlsValidationContextTrust::File).
    pub fn is_file(&self) -> bool {
        self.as_file().is_ok()
    }
    /// Tries to convert the enum instance into [`Sds`](crate::model::ListenerTlsValidationContextTrust::Sds), extracting the inner [`TlsValidationContextSdsTrust`](crate::model::TlsValidationContextSdsTrust).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_sds(
        &self,
    ) -> std::result::Result<&crate::model::TlsValidationContextSdsTrust, &Self> {
        if let ListenerTlsValidationContextTrust::Sds(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Sds`](crate::model::ListenerTlsValidationContextTrust::Sds).
    pub fn is_sds(&self) -> bool {
        self.as_sds().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

/// <p>An object that represents a listener's Transport Layer Security (TLS) certificate.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum ListenerTlsCertificate {
    /// <p>A reference to an object that represents an AWS Certicate Manager (ACM) certificate.</p>
    Acm(crate::model::ListenerTlsAcmCertificate),
    /// <p>A reference to an object that represents a local file certificate.</p>
    File(crate::model::ListenerTlsFileCertificate),
    /// <p>A reference to an object that represents a listener's Secret Discovery Service
    /// certificate.</p>
    Sds(crate::model::ListenerTlsSdsCertificate),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl ListenerTlsCertificate {
    /// Tries to convert the enum instance into [`Acm`](crate::model::ListenerTlsCertificate::Acm), extracting the inner [`ListenerTlsAcmCertificate`](crate::model::ListenerTlsAcmCertificate).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_acm(&self) -> std::result::Result<&crate::model::ListenerTlsAcmCertificate, &Self> {
        if let ListenerTlsCertificate::Acm(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Acm`](crate::model::ListenerTlsCertificate::Acm).
    pub fn is_acm(&self) -> bool {
        self.as_acm().is_ok()
    }
    /// Tries to convert the enum instance into [`File`](crate::model::ListenerTlsCertificate::File), extracting the inner [`ListenerTlsFileCertificate`](crate::model::ListenerTlsFileCertificate).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_file(&self) -> std::result::Result<&crate::model::ListenerTlsFileCertificate, &Self> {
        if let ListenerTlsCertificate::File(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`File`](crate::model::ListenerTlsCertificate::File).
    pub fn is_file(&self) -> bool {
        self.as_file().is_ok()
    }
    /// Tries to convert the enum instance into [`Sds`](crate::model::ListenerTlsCertificate::Sds), extracting the inner [`ListenerTlsSdsCertificate`](crate::model::ListenerTlsSdsCertificate).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_sds(&self) -> std::result::Result<&crate::model::ListenerTlsSdsCertificate, &Self> {
        if let ListenerTlsCertificate::Sds(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Sds`](crate::model::ListenerTlsCertificate::Sds).
    pub fn is_sds(&self) -> bool {
        self.as_sds().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

/// <p>An object that represents an AWS Certicate Manager (ACM) certificate.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListenerTlsAcmCertificate {
    /// <p>The Amazon Resource Name (ARN) for the certificate. The certificate must meet specific requirements and you must have proxy authorization enabled. For more information, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html#virtual-node-tls-prerequisites">Transport Layer Security (TLS)</a>.</p>
    pub certificate_arn: std::option::Option<std::string::String>,
}
impl ListenerTlsAcmCertificate {
    /// <p>The Amazon Resource Name (ARN) for the certificate. The certificate must meet specific requirements and you must have proxy authorization enabled. For more information, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html#virtual-node-tls-prerequisites">Transport Layer Security (TLS)</a>.</p>
    pub fn certificate_arn(&self) -> std::option::Option<&str> {
        self.certificate_arn.as_deref()
    }
}
impl std::fmt::Debug for ListenerTlsAcmCertificate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListenerTlsAcmCertificate");
        formatter.field("certificate_arn", &self.certificate_arn);
        formatter.finish()
    }
}
/// See [`ListenerTlsAcmCertificate`](crate::model::ListenerTlsAcmCertificate)
pub mod listener_tls_acm_certificate {
    /// A builder for [`ListenerTlsAcmCertificate`](crate::model::ListenerTlsAcmCertificate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for the certificate. The certificate must meet specific requirements and you must have proxy authorization enabled. For more information, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html#virtual-node-tls-prerequisites">Transport Layer Security (TLS)</a>.</p>
        pub fn certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the certificate. The certificate must meet specific requirements and you must have proxy authorization enabled. For more information, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html#virtual-node-tls-prerequisites">Transport Layer Security (TLS)</a>.</p>
        pub fn set_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListenerTlsAcmCertificate`](crate::model::ListenerTlsAcmCertificate)
        pub fn build(self) -> crate::model::ListenerTlsAcmCertificate {
            crate::model::ListenerTlsAcmCertificate {
                certificate_arn: self.certificate_arn,
            }
        }
    }
}
impl ListenerTlsAcmCertificate {
    /// Creates a new builder-style object to manufacture [`ListenerTlsAcmCertificate`](crate::model::ListenerTlsAcmCertificate)
    pub fn builder() -> crate::model::listener_tls_acm_certificate::Builder {
        crate::model::listener_tls_acm_certificate::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ListenerTlsMode {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Permissive,
    #[allow(missing_docs)] // documentation missing in model
    Strict,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ListenerTlsMode {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => ListenerTlsMode::Disabled,
            "PERMISSIVE" => ListenerTlsMode::Permissive,
            "STRICT" => ListenerTlsMode::Strict,
            other => ListenerTlsMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ListenerTlsMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ListenerTlsMode::from(s))
    }
}
impl ListenerTlsMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ListenerTlsMode::Disabled => "DISABLED",
            ListenerTlsMode::Permissive => "PERMISSIVE",
            ListenerTlsMode::Strict => "STRICT",
            ListenerTlsMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "PERMISSIVE", "STRICT"]
    }
}
impl AsRef<str> for ListenerTlsMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that represents the service discovery information for a virtual node.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum ServiceDiscovery {
    /// <p>Specifies any Cloud Map information for the virtual node.</p>
    AwsCloudMap(crate::model::AwsCloudMapServiceDiscovery),
    /// <p>Specifies the DNS information for the virtual node.</p>
    Dns(crate::model::DnsServiceDiscovery),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl ServiceDiscovery {
    /// Tries to convert the enum instance into [`AwsCloudMap`](crate::model::ServiceDiscovery::AwsCloudMap), extracting the inner [`AwsCloudMapServiceDiscovery`](crate::model::AwsCloudMapServiceDiscovery).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_aws_cloud_map(
        &self,
    ) -> std::result::Result<&crate::model::AwsCloudMapServiceDiscovery, &Self> {
        if let ServiceDiscovery::AwsCloudMap(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`AwsCloudMap`](crate::model::ServiceDiscovery::AwsCloudMap).
    pub fn is_aws_cloud_map(&self) -> bool {
        self.as_aws_cloud_map().is_ok()
    }
    /// Tries to convert the enum instance into [`Dns`](crate::model::ServiceDiscovery::Dns), extracting the inner [`DnsServiceDiscovery`](crate::model::DnsServiceDiscovery).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_dns(&self) -> std::result::Result<&crate::model::DnsServiceDiscovery, &Self> {
        if let ServiceDiscovery::Dns(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Dns`](crate::model::ServiceDiscovery::Dns).
    pub fn is_dns(&self) -> bool {
        self.as_dns().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

/// <p>An object that represents the Cloud Map service discovery information for your virtual
/// node.</p>
/// <note>
/// <p>Cloud Map is not available in the eu-south-1 Region.</p>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsCloudMapServiceDiscovery {
    /// <p>The name of the Cloud Map namespace to use.</p>
    pub namespace_name: std::option::Option<std::string::String>,
    /// <p>The name of the Cloud Map service to use.</p>
    pub service_name: std::option::Option<std::string::String>,
    /// <p>A string map that contains attributes with values that you can use to filter instances
    /// by any custom attribute that you specified when you registered the instance. Only instances
    /// that match all of the specified key/value pairs will be returned.</p>
    pub attributes: std::option::Option<std::vec::Vec<crate::model::AwsCloudMapInstanceAttribute>>,
}
impl AwsCloudMapServiceDiscovery {
    /// <p>The name of the Cloud Map namespace to use.</p>
    pub fn namespace_name(&self) -> std::option::Option<&str> {
        self.namespace_name.as_deref()
    }
    /// <p>The name of the Cloud Map service to use.</p>
    pub fn service_name(&self) -> std::option::Option<&str> {
        self.service_name.as_deref()
    }
    /// <p>A string map that contains attributes with values that you can use to filter instances
    /// by any custom attribute that you specified when you registered the instance. Only instances
    /// that match all of the specified key/value pairs will be returned.</p>
    pub fn attributes(&self) -> std::option::Option<&[crate::model::AwsCloudMapInstanceAttribute]> {
        self.attributes.as_deref()
    }
}
impl std::fmt::Debug for AwsCloudMapServiceDiscovery {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsCloudMapServiceDiscovery");
        formatter.field("namespace_name", &self.namespace_name);
        formatter.field("service_name", &self.service_name);
        formatter.field("attributes", &self.attributes);
        formatter.finish()
    }
}
/// See [`AwsCloudMapServiceDiscovery`](crate::model::AwsCloudMapServiceDiscovery)
pub mod aws_cloud_map_service_discovery {
    /// A builder for [`AwsCloudMapServiceDiscovery`](crate::model::AwsCloudMapServiceDiscovery)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) namespace_name: std::option::Option<std::string::String>,
        pub(crate) service_name: std::option::Option<std::string::String>,
        pub(crate) attributes:
            std::option::Option<std::vec::Vec<crate::model::AwsCloudMapInstanceAttribute>>,
    }
    impl Builder {
        /// <p>The name of the Cloud Map namespace to use.</p>
        pub fn namespace_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace_name = Some(input.into());
            self
        }
        /// <p>The name of the Cloud Map namespace to use.</p>
        pub fn set_namespace_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.namespace_name = input;
            self
        }
        /// <p>The name of the Cloud Map service to use.</p>
        pub fn service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_name = Some(input.into());
            self
        }
        /// <p>The name of the Cloud Map service to use.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_name = input;
            self
        }
        /// Appends an item to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>A string map that contains attributes with values that you can use to filter instances
        /// by any custom attribute that you specified when you registered the instance. Only instances
        /// that match all of the specified key/value pairs will be returned.</p>
        pub fn attributes(
            mut self,
            input: impl Into<crate::model::AwsCloudMapInstanceAttribute>,
        ) -> Self {
            let mut v = self.attributes.unwrap_or_default();
            v.push(input.into());
            self.attributes = Some(v);
            self
        }
        /// <p>A string map that contains attributes with values that you can use to filter instances
        /// by any custom attribute that you specified when you registered the instance. Only instances
        /// that match all of the specified key/value pairs will be returned.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AwsCloudMapInstanceAttribute>>,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsCloudMapServiceDiscovery`](crate::model::AwsCloudMapServiceDiscovery)
        pub fn build(self) -> crate::model::AwsCloudMapServiceDiscovery {
            crate::model::AwsCloudMapServiceDiscovery {
                namespace_name: self.namespace_name,
                service_name: self.service_name,
                attributes: self.attributes,
            }
        }
    }
}
impl AwsCloudMapServiceDiscovery {
    /// Creates a new builder-style object to manufacture [`AwsCloudMapServiceDiscovery`](crate::model::AwsCloudMapServiceDiscovery)
    pub fn builder() -> crate::model::aws_cloud_map_service_discovery::Builder {
        crate::model::aws_cloud_map_service_discovery::Builder::default()
    }
}

/// <p>An object that represents the Cloud Map attribute information for your virtual
/// node.</p>
/// <note>
/// <p>AWS Cloud Map is not available in the eu-south-1 Region.</p>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsCloudMapInstanceAttribute {
    /// <p>The name of an Cloud Map service instance attribute key. Any Cloud Map service
    /// instance that contains the specified key and value is returned.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The value of an Cloud Map service instance attribute key. Any Cloud Map service
    /// instance that contains the specified key and value is returned.</p>
    pub value: std::option::Option<std::string::String>,
}
impl AwsCloudMapInstanceAttribute {
    /// <p>The name of an Cloud Map service instance attribute key. Any Cloud Map service
    /// instance that contains the specified key and value is returned.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The value of an Cloud Map service instance attribute key. Any Cloud Map service
    /// instance that contains the specified key and value is returned.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for AwsCloudMapInstanceAttribute {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsCloudMapInstanceAttribute");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`AwsCloudMapInstanceAttribute`](crate::model::AwsCloudMapInstanceAttribute)
pub mod aws_cloud_map_instance_attribute {
    /// A builder for [`AwsCloudMapInstanceAttribute`](crate::model::AwsCloudMapInstanceAttribute)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of an Cloud Map service instance attribute key. Any Cloud Map service
        /// instance that contains the specified key and value is returned.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The name of an Cloud Map service instance attribute key. Any Cloud Map service
        /// instance that contains the specified key and value is returned.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The value of an Cloud Map service instance attribute key. Any Cloud Map service
        /// instance that contains the specified key and value is returned.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of an Cloud Map service instance attribute key. Any Cloud Map service
        /// instance that contains the specified key and value is returned.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsCloudMapInstanceAttribute`](crate::model::AwsCloudMapInstanceAttribute)
        pub fn build(self) -> crate::model::AwsCloudMapInstanceAttribute {
            crate::model::AwsCloudMapInstanceAttribute {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl AwsCloudMapInstanceAttribute {
    /// Creates a new builder-style object to manufacture [`AwsCloudMapInstanceAttribute`](crate::model::AwsCloudMapInstanceAttribute)
    pub fn builder() -> crate::model::aws_cloud_map_instance_attribute::Builder {
        crate::model::aws_cloud_map_instance_attribute::Builder::default()
    }
}

/// <p>An object that represents the DNS service discovery information for your virtual
/// node.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DnsServiceDiscovery {
    /// <p>Specifies the DNS service discovery hostname for the virtual node. </p>
    pub hostname: std::option::Option<std::string::String>,
    /// <p>Specifies the DNS response type for the virtual node.</p>
    pub response_type: std::option::Option<crate::model::DnsResponseType>,
}
impl DnsServiceDiscovery {
    /// <p>Specifies the DNS service discovery hostname for the virtual node. </p>
    pub fn hostname(&self) -> std::option::Option<&str> {
        self.hostname.as_deref()
    }
    /// <p>Specifies the DNS response type for the virtual node.</p>
    pub fn response_type(&self) -> std::option::Option<&crate::model::DnsResponseType> {
        self.response_type.as_ref()
    }
}
impl std::fmt::Debug for DnsServiceDiscovery {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DnsServiceDiscovery");
        formatter.field("hostname", &self.hostname);
        formatter.field("response_type", &self.response_type);
        formatter.finish()
    }
}
/// See [`DnsServiceDiscovery`](crate::model::DnsServiceDiscovery)
pub mod dns_service_discovery {
    /// A builder for [`DnsServiceDiscovery`](crate::model::DnsServiceDiscovery)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hostname: std::option::Option<std::string::String>,
        pub(crate) response_type: std::option::Option<crate::model::DnsResponseType>,
    }
    impl Builder {
        /// <p>Specifies the DNS service discovery hostname for the virtual node. </p>
        pub fn hostname(mut self, input: impl Into<std::string::String>) -> Self {
            self.hostname = Some(input.into());
            self
        }
        /// <p>Specifies the DNS service discovery hostname for the virtual node. </p>
        pub fn set_hostname(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hostname = input;
            self
        }
        /// <p>Specifies the DNS response type for the virtual node.</p>
        pub fn response_type(mut self, input: crate::model::DnsResponseType) -> Self {
            self.response_type = Some(input);
            self
        }
        /// <p>Specifies the DNS response type for the virtual node.</p>
        pub fn set_response_type(
            mut self,
            input: std::option::Option<crate::model::DnsResponseType>,
        ) -> Self {
            self.response_type = input;
            self
        }
        /// Consumes the builder and constructs a [`DnsServiceDiscovery`](crate::model::DnsServiceDiscovery)
        pub fn build(self) -> crate::model::DnsServiceDiscovery {
            crate::model::DnsServiceDiscovery {
                hostname: self.hostname,
                response_type: self.response_type,
            }
        }
    }
}
impl DnsServiceDiscovery {
    /// Creates a new builder-style object to manufacture [`DnsServiceDiscovery`](crate::model::DnsServiceDiscovery)
    pub fn builder() -> crate::model::dns_service_discovery::Builder {
        crate::model::dns_service_discovery::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DnsResponseType {
    #[allow(missing_docs)] // documentation missing in model
    Endpoints,
    #[allow(missing_docs)] // documentation missing in model
    Loadbalancer,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DnsResponseType {
    fn from(s: &str) -> Self {
        match s {
            "ENDPOINTS" => DnsResponseType::Endpoints,
            "LOADBALANCER" => DnsResponseType::Loadbalancer,
            other => DnsResponseType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DnsResponseType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DnsResponseType::from(s))
    }
}
impl DnsResponseType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DnsResponseType::Endpoints => "ENDPOINTS",
            DnsResponseType::Loadbalancer => "LOADBALANCER",
            DnsResponseType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ENDPOINTS", "LOADBALANCER"]
    }
}
impl AsRef<str> for DnsResponseType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that represents a virtual gateway returned by a list operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VirtualGatewayRef {
    /// <p>The name of the service mesh that the resource resides in.</p>
    pub mesh_name: std::option::Option<std::string::String>,
    /// <p>The name of the resource.</p>
    pub virtual_gateway_name: std::option::Option<std::string::String>,
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
    /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub mesh_owner: std::option::Option<std::string::String>,
    /// <p>The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's
    /// the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub resource_owner: std::option::Option<std::string::String>,
    /// <p>The full Amazon Resource Name (ARN) for the resource.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The version of the resource. Resources are created at version 1, and this version is incremented each time that they're updated.</p>
    pub version: std::option::Option<i64>,
    /// <p>The Unix epoch timestamp in seconds for when the resource was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The Unix epoch timestamp in seconds for when the resource was last updated.</p>
    pub last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
}
impl VirtualGatewayRef {
    /// <p>The name of the service mesh that the resource resides in.</p>
    pub fn mesh_name(&self) -> std::option::Option<&str> {
        self.mesh_name.as_deref()
    }
    /// <p>The name of the resource.</p>
    pub fn virtual_gateway_name(&self) -> std::option::Option<&str> {
        self.virtual_gateway_name.as_deref()
    }
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
    /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub fn mesh_owner(&self) -> std::option::Option<&str> {
        self.mesh_owner.as_deref()
    }
    /// <p>The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's
    /// the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub fn resource_owner(&self) -> std::option::Option<&str> {
        self.resource_owner.as_deref()
    }
    /// <p>The full Amazon Resource Name (ARN) for the resource.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The version of the resource. Resources are created at version 1, and this version is incremented each time that they're updated.</p>
    pub fn version(&self) -> std::option::Option<i64> {
        self.version
    }
    /// <p>The Unix epoch timestamp in seconds for when the resource was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The Unix epoch timestamp in seconds for when the resource was last updated.</p>
    pub fn last_updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_at.as_ref()
    }
}
impl std::fmt::Debug for VirtualGatewayRef {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VirtualGatewayRef");
        formatter.field("mesh_name", &self.mesh_name);
        formatter.field("virtual_gateway_name", &self.virtual_gateway_name);
        formatter.field("mesh_owner", &self.mesh_owner);
        formatter.field("resource_owner", &self.resource_owner);
        formatter.field("arn", &self.arn);
        formatter.field("version", &self.version);
        formatter.field("created_at", &self.created_at);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.finish()
    }
}
/// See [`VirtualGatewayRef`](crate::model::VirtualGatewayRef)
pub mod virtual_gateway_ref {
    /// A builder for [`VirtualGatewayRef`](crate::model::VirtualGatewayRef)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mesh_name: std::option::Option<std::string::String>,
        pub(crate) virtual_gateway_name: std::option::Option<std::string::String>,
        pub(crate) mesh_owner: std::option::Option<std::string::String>,
        pub(crate) resource_owner: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<i64>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the service mesh that the resource resides in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_name = Some(input.into());
            self
        }
        /// <p>The name of the service mesh that the resource resides in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_name = input;
            self
        }
        /// <p>The name of the resource.</p>
        pub fn virtual_gateway_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_gateway_name = Some(input.into());
            self
        }
        /// <p>The name of the resource.</p>
        pub fn set_virtual_gateway_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_gateway_name = input;
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_owner = Some(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_owner = input;
            self
        }
        /// <p>The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's
        /// the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn resource_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_owner = Some(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's
        /// the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_resource_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_owner = input;
            self
        }
        /// <p>The full Amazon Resource Name (ARN) for the resource.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The full Amazon Resource Name (ARN) for the resource.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The version of the resource. Resources are created at version 1, and this version is incremented each time that they're updated.</p>
        pub fn version(mut self, input: i64) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>The version of the resource. Resources are created at version 1, and this version is incremented each time that they're updated.</p>
        pub fn set_version(mut self, input: std::option::Option<i64>) -> Self {
            self.version = input;
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the resource was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the resource was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the resource was last updated.</p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the resource was last updated.</p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// Consumes the builder and constructs a [`VirtualGatewayRef`](crate::model::VirtualGatewayRef)
        pub fn build(self) -> crate::model::VirtualGatewayRef {
            crate::model::VirtualGatewayRef {
                mesh_name: self.mesh_name,
                virtual_gateway_name: self.virtual_gateway_name,
                mesh_owner: self.mesh_owner,
                resource_owner: self.resource_owner,
                arn: self.arn,
                version: self.version,
                created_at: self.created_at,
                last_updated_at: self.last_updated_at,
            }
        }
    }
}
impl VirtualGatewayRef {
    /// Creates a new builder-style object to manufacture [`VirtualGatewayRef`](crate::model::VirtualGatewayRef)
    pub fn builder() -> crate::model::virtual_gateway_ref::Builder {
        crate::model::virtual_gateway_ref::Builder::default()
    }
}

/// <p>An object that represents a virtual gateway returned by a describe operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VirtualGatewayData {
    /// <p>The name of the service mesh that the virtual gateway resides in.</p>
    pub mesh_name: std::option::Option<std::string::String>,
    /// <p>The name of the virtual gateway.</p>
    pub virtual_gateway_name: std::option::Option<std::string::String>,
    /// <p>The specifications of the virtual gateway.</p>
    pub spec: std::option::Option<crate::model::VirtualGatewaySpec>,
    /// <p>An object that represents metadata for a resource.</p>
    pub metadata: std::option::Option<crate::model::ResourceMetadata>,
    /// <p>The current status of the virtual gateway.</p>
    pub status: std::option::Option<crate::model::VirtualGatewayStatus>,
}
impl VirtualGatewayData {
    /// <p>The name of the service mesh that the virtual gateway resides in.</p>
    pub fn mesh_name(&self) -> std::option::Option<&str> {
        self.mesh_name.as_deref()
    }
    /// <p>The name of the virtual gateway.</p>
    pub fn virtual_gateway_name(&self) -> std::option::Option<&str> {
        self.virtual_gateway_name.as_deref()
    }
    /// <p>The specifications of the virtual gateway.</p>
    pub fn spec(&self) -> std::option::Option<&crate::model::VirtualGatewaySpec> {
        self.spec.as_ref()
    }
    /// <p>An object that represents metadata for a resource.</p>
    pub fn metadata(&self) -> std::option::Option<&crate::model::ResourceMetadata> {
        self.metadata.as_ref()
    }
    /// <p>The current status of the virtual gateway.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::VirtualGatewayStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for VirtualGatewayData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VirtualGatewayData");
        formatter.field("mesh_name", &self.mesh_name);
        formatter.field("virtual_gateway_name", &self.virtual_gateway_name);
        formatter.field("spec", &self.spec);
        formatter.field("metadata", &self.metadata);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`VirtualGatewayData`](crate::model::VirtualGatewayData)
pub mod virtual_gateway_data {
    /// A builder for [`VirtualGatewayData`](crate::model::VirtualGatewayData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mesh_name: std::option::Option<std::string::String>,
        pub(crate) virtual_gateway_name: std::option::Option<std::string::String>,
        pub(crate) spec: std::option::Option<crate::model::VirtualGatewaySpec>,
        pub(crate) metadata: std::option::Option<crate::model::ResourceMetadata>,
        pub(crate) status: std::option::Option<crate::model::VirtualGatewayStatus>,
    }
    impl Builder {
        /// <p>The name of the service mesh that the virtual gateway resides in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_name = Some(input.into());
            self
        }
        /// <p>The name of the service mesh that the virtual gateway resides in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_name = input;
            self
        }
        /// <p>The name of the virtual gateway.</p>
        pub fn virtual_gateway_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_gateway_name = Some(input.into());
            self
        }
        /// <p>The name of the virtual gateway.</p>
        pub fn set_virtual_gateway_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_gateway_name = input;
            self
        }
        /// <p>The specifications of the virtual gateway.</p>
        pub fn spec(mut self, input: crate::model::VirtualGatewaySpec) -> Self {
            self.spec = Some(input);
            self
        }
        /// <p>The specifications of the virtual gateway.</p>
        pub fn set_spec(
            mut self,
            input: std::option::Option<crate::model::VirtualGatewaySpec>,
        ) -> Self {
            self.spec = input;
            self
        }
        /// <p>An object that represents metadata for a resource.</p>
        pub fn metadata(mut self, input: crate::model::ResourceMetadata) -> Self {
            self.metadata = Some(input);
            self
        }
        /// <p>An object that represents metadata for a resource.</p>
        pub fn set_metadata(
            mut self,
            input: std::option::Option<crate::model::ResourceMetadata>,
        ) -> Self {
            self.metadata = input;
            self
        }
        /// <p>The current status of the virtual gateway.</p>
        pub fn status(mut self, input: crate::model::VirtualGatewayStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the virtual gateway.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::VirtualGatewayStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`VirtualGatewayData`](crate::model::VirtualGatewayData)
        pub fn build(self) -> crate::model::VirtualGatewayData {
            crate::model::VirtualGatewayData {
                mesh_name: self.mesh_name,
                virtual_gateway_name: self.virtual_gateway_name,
                spec: self.spec,
                metadata: self.metadata,
                status: self.status,
            }
        }
    }
}
impl VirtualGatewayData {
    /// Creates a new builder-style object to manufacture [`VirtualGatewayData`](crate::model::VirtualGatewayData)
    pub fn builder() -> crate::model::virtual_gateway_data::Builder {
        crate::model::virtual_gateway_data::Builder::default()
    }
}

/// <p>An object that represents the status of the mesh resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VirtualGatewayStatus {
    /// <p>The current status.</p>
    pub status: std::option::Option<crate::model::VirtualGatewayStatusCode>,
}
impl VirtualGatewayStatus {
    /// <p>The current status.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::VirtualGatewayStatusCode> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for VirtualGatewayStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VirtualGatewayStatus");
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`VirtualGatewayStatus`](crate::model::VirtualGatewayStatus)
pub mod virtual_gateway_status {
    /// A builder for [`VirtualGatewayStatus`](crate::model::VirtualGatewayStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::VirtualGatewayStatusCode>,
    }
    impl Builder {
        /// <p>The current status.</p>
        pub fn status(mut self, input: crate::model::VirtualGatewayStatusCode) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::VirtualGatewayStatusCode>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`VirtualGatewayStatus`](crate::model::VirtualGatewayStatus)
        pub fn build(self) -> crate::model::VirtualGatewayStatus {
            crate::model::VirtualGatewayStatus {
                status: self.status,
            }
        }
    }
}
impl VirtualGatewayStatus {
    /// Creates a new builder-style object to manufacture [`VirtualGatewayStatus`](crate::model::VirtualGatewayStatus)
    pub fn builder() -> crate::model::virtual_gateway_status::Builder {
        crate::model::virtual_gateway_status::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum VirtualGatewayStatusCode {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Inactive,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for VirtualGatewayStatusCode {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => VirtualGatewayStatusCode::Active,
            "DELETED" => VirtualGatewayStatusCode::Deleted,
            "INACTIVE" => VirtualGatewayStatusCode::Inactive,
            other => VirtualGatewayStatusCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for VirtualGatewayStatusCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(VirtualGatewayStatusCode::from(s))
    }
}
impl VirtualGatewayStatusCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            VirtualGatewayStatusCode::Active => "ACTIVE",
            VirtualGatewayStatusCode::Deleted => "DELETED",
            VirtualGatewayStatusCode::Inactive => "INACTIVE",
            VirtualGatewayStatusCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "DELETED", "INACTIVE"]
    }
}
impl AsRef<str> for VirtualGatewayStatusCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that represents the specification of a service mesh resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VirtualGatewaySpec {
    /// <p>A reference to an object that represents the defaults for backends.</p>
    pub backend_defaults: std::option::Option<crate::model::VirtualGatewayBackendDefaults>,
    /// <p>The listeners that the mesh endpoint is expected to receive inbound traffic from. You
    /// can specify one listener.</p>
    pub listeners: std::option::Option<std::vec::Vec<crate::model::VirtualGatewayListener>>,
    /// <p>An object that represents logging information.</p>
    pub logging: std::option::Option<crate::model::VirtualGatewayLogging>,
}
impl VirtualGatewaySpec {
    /// <p>A reference to an object that represents the defaults for backends.</p>
    pub fn backend_defaults(
        &self,
    ) -> std::option::Option<&crate::model::VirtualGatewayBackendDefaults> {
        self.backend_defaults.as_ref()
    }
    /// <p>The listeners that the mesh endpoint is expected to receive inbound traffic from. You
    /// can specify one listener.</p>
    pub fn listeners(&self) -> std::option::Option<&[crate::model::VirtualGatewayListener]> {
        self.listeners.as_deref()
    }
    /// <p>An object that represents logging information.</p>
    pub fn logging(&self) -> std::option::Option<&crate::model::VirtualGatewayLogging> {
        self.logging.as_ref()
    }
}
impl std::fmt::Debug for VirtualGatewaySpec {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VirtualGatewaySpec");
        formatter.field("backend_defaults", &self.backend_defaults);
        formatter.field("listeners", &self.listeners);
        formatter.field("logging", &self.logging);
        formatter.finish()
    }
}
/// See [`VirtualGatewaySpec`](crate::model::VirtualGatewaySpec)
pub mod virtual_gateway_spec {
    /// A builder for [`VirtualGatewaySpec`](crate::model::VirtualGatewaySpec)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backend_defaults:
            std::option::Option<crate::model::VirtualGatewayBackendDefaults>,
        pub(crate) listeners:
            std::option::Option<std::vec::Vec<crate::model::VirtualGatewayListener>>,
        pub(crate) logging: std::option::Option<crate::model::VirtualGatewayLogging>,
    }
    impl Builder {
        /// <p>A reference to an object that represents the defaults for backends.</p>
        pub fn backend_defaults(
            mut self,
            input: crate::model::VirtualGatewayBackendDefaults,
        ) -> Self {
            self.backend_defaults = Some(input);
            self
        }
        /// <p>A reference to an object that represents the defaults for backends.</p>
        pub fn set_backend_defaults(
            mut self,
            input: std::option::Option<crate::model::VirtualGatewayBackendDefaults>,
        ) -> Self {
            self.backend_defaults = input;
            self
        }
        /// Appends an item to `listeners`.
        ///
        /// To override the contents of this collection use [`set_listeners`](Self::set_listeners).
        ///
        /// <p>The listeners that the mesh endpoint is expected to receive inbound traffic from. You
        /// can specify one listener.</p>
        pub fn listeners(mut self, input: impl Into<crate::model::VirtualGatewayListener>) -> Self {
            let mut v = self.listeners.unwrap_or_default();
            v.push(input.into());
            self.listeners = Some(v);
            self
        }
        /// <p>The listeners that the mesh endpoint is expected to receive inbound traffic from. You
        /// can specify one listener.</p>
        pub fn set_listeners(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VirtualGatewayListener>>,
        ) -> Self {
            self.listeners = input;
            self
        }
        /// <p>An object that represents logging information.</p>
        pub fn logging(mut self, input: crate::model::VirtualGatewayLogging) -> Self {
            self.logging = Some(input);
            self
        }
        /// <p>An object that represents logging information.</p>
        pub fn set_logging(
            mut self,
            input: std::option::Option<crate::model::VirtualGatewayLogging>,
        ) -> Self {
            self.logging = input;
            self
        }
        /// Consumes the builder and constructs a [`VirtualGatewaySpec`](crate::model::VirtualGatewaySpec)
        pub fn build(self) -> crate::model::VirtualGatewaySpec {
            crate::model::VirtualGatewaySpec {
                backend_defaults: self.backend_defaults,
                listeners: self.listeners,
                logging: self.logging,
            }
        }
    }
}
impl VirtualGatewaySpec {
    /// Creates a new builder-style object to manufacture [`VirtualGatewaySpec`](crate::model::VirtualGatewaySpec)
    pub fn builder() -> crate::model::virtual_gateway_spec::Builder {
        crate::model::virtual_gateway_spec::Builder::default()
    }
}

/// <p>An object that represents logging information.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VirtualGatewayLogging {
    /// <p>The access log configuration.</p>
    pub access_log: std::option::Option<crate::model::VirtualGatewayAccessLog>,
}
impl VirtualGatewayLogging {
    /// <p>The access log configuration.</p>
    pub fn access_log(&self) -> std::option::Option<&crate::model::VirtualGatewayAccessLog> {
        self.access_log.as_ref()
    }
}
impl std::fmt::Debug for VirtualGatewayLogging {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VirtualGatewayLogging");
        formatter.field("access_log", &self.access_log);
        formatter.finish()
    }
}
/// See [`VirtualGatewayLogging`](crate::model::VirtualGatewayLogging)
pub mod virtual_gateway_logging {
    /// A builder for [`VirtualGatewayLogging`](crate::model::VirtualGatewayLogging)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_log: std::option::Option<crate::model::VirtualGatewayAccessLog>,
    }
    impl Builder {
        /// <p>The access log configuration.</p>
        pub fn access_log(mut self, input: crate::model::VirtualGatewayAccessLog) -> Self {
            self.access_log = Some(input);
            self
        }
        /// <p>The access log configuration.</p>
        pub fn set_access_log(
            mut self,
            input: std::option::Option<crate::model::VirtualGatewayAccessLog>,
        ) -> Self {
            self.access_log = input;
            self
        }
        /// Consumes the builder and constructs a [`VirtualGatewayLogging`](crate::model::VirtualGatewayLogging)
        pub fn build(self) -> crate::model::VirtualGatewayLogging {
            crate::model::VirtualGatewayLogging {
                access_log: self.access_log,
            }
        }
    }
}
impl VirtualGatewayLogging {
    /// Creates a new builder-style object to manufacture [`VirtualGatewayLogging`](crate::model::VirtualGatewayLogging)
    pub fn builder() -> crate::model::virtual_gateway_logging::Builder {
        crate::model::virtual_gateway_logging::Builder::default()
    }
}

/// <p>The access log configuration for a virtual gateway.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum VirtualGatewayAccessLog {
    /// <p>The file object to send virtual gateway access logs to.</p>
    File(crate::model::VirtualGatewayFileAccessLog),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl VirtualGatewayAccessLog {
    #[allow(irrefutable_let_patterns)]
    /// Tries to convert the enum instance into [`File`](crate::model::VirtualGatewayAccessLog::File), extracting the inner [`VirtualGatewayFileAccessLog`](crate::model::VirtualGatewayFileAccessLog).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_file(
        &self,
    ) -> std::result::Result<&crate::model::VirtualGatewayFileAccessLog, &Self> {
        if let VirtualGatewayAccessLog::File(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`File`](crate::model::VirtualGatewayAccessLog::File).
    pub fn is_file(&self) -> bool {
        self.as_file().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

/// <p>An object that represents an access log file.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VirtualGatewayFileAccessLog {
    /// <p>The file path to write access logs to. You can use <code>/dev/stdout</code> to send
    /// access logs to standard out and configure your Envoy container to use a log driver, such as
    /// <code>awslogs</code>, to export the access logs to a log storage service such as Amazon
    /// CloudWatch Logs. You can also specify a path in the Envoy container's file system to write
    /// the files to disk.</p>
    pub path: std::option::Option<std::string::String>,
}
impl VirtualGatewayFileAccessLog {
    /// <p>The file path to write access logs to. You can use <code>/dev/stdout</code> to send
    /// access logs to standard out and configure your Envoy container to use a log driver, such as
    /// <code>awslogs</code>, to export the access logs to a log storage service such as Amazon
    /// CloudWatch Logs. You can also specify a path in the Envoy container's file system to write
    /// the files to disk.</p>
    pub fn path(&self) -> std::option::Option<&str> {
        self.path.as_deref()
    }
}
impl std::fmt::Debug for VirtualGatewayFileAccessLog {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VirtualGatewayFileAccessLog");
        formatter.field("path", &self.path);
        formatter.finish()
    }
}
/// See [`VirtualGatewayFileAccessLog`](crate::model::VirtualGatewayFileAccessLog)
pub mod virtual_gateway_file_access_log {
    /// A builder for [`VirtualGatewayFileAccessLog`](crate::model::VirtualGatewayFileAccessLog)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) path: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The file path to write access logs to. You can use <code>/dev/stdout</code> to send
        /// access logs to standard out and configure your Envoy container to use a log driver, such as
        /// <code>awslogs</code>, to export the access logs to a log storage service such as Amazon
        /// CloudWatch Logs. You can also specify a path in the Envoy container's file system to write
        /// the files to disk.</p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p>The file path to write access logs to. You can use <code>/dev/stdout</code> to send
        /// access logs to standard out and configure your Envoy container to use a log driver, such as
        /// <code>awslogs</code>, to export the access logs to a log storage service such as Amazon
        /// CloudWatch Logs. You can also specify a path in the Envoy container's file system to write
        /// the files to disk.</p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// Consumes the builder and constructs a [`VirtualGatewayFileAccessLog`](crate::model::VirtualGatewayFileAccessLog)
        pub fn build(self) -> crate::model::VirtualGatewayFileAccessLog {
            crate::model::VirtualGatewayFileAccessLog { path: self.path }
        }
    }
}
impl VirtualGatewayFileAccessLog {
    /// Creates a new builder-style object to manufacture [`VirtualGatewayFileAccessLog`](crate::model::VirtualGatewayFileAccessLog)
    pub fn builder() -> crate::model::virtual_gateway_file_access_log::Builder {
        crate::model::virtual_gateway_file_access_log::Builder::default()
    }
}

/// <p>An object that represents a listener for a virtual gateway.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VirtualGatewayListener {
    /// <p>The health check information for the listener.</p>
    pub health_check: std::option::Option<crate::model::VirtualGatewayHealthCheckPolicy>,
    /// <p>The port mapping information for the listener.</p>
    pub port_mapping: std::option::Option<crate::model::VirtualGatewayPortMapping>,
    /// <p>A reference to an object that represents the Transport Layer Security (TLS) properties for the listener.</p>
    pub tls: std::option::Option<crate::model::VirtualGatewayListenerTls>,
    /// <p>The connection pool information for the virtual gateway listener.</p>
    pub connection_pool: std::option::Option<crate::model::VirtualGatewayConnectionPool>,
}
impl VirtualGatewayListener {
    /// <p>The health check information for the listener.</p>
    pub fn health_check(
        &self,
    ) -> std::option::Option<&crate::model::VirtualGatewayHealthCheckPolicy> {
        self.health_check.as_ref()
    }
    /// <p>The port mapping information for the listener.</p>
    pub fn port_mapping(&self) -> std::option::Option<&crate::model::VirtualGatewayPortMapping> {
        self.port_mapping.as_ref()
    }
    /// <p>A reference to an object that represents the Transport Layer Security (TLS) properties for the listener.</p>
    pub fn tls(&self) -> std::option::Option<&crate::model::VirtualGatewayListenerTls> {
        self.tls.as_ref()
    }
    /// <p>The connection pool information for the virtual gateway listener.</p>
    pub fn connection_pool(
        &self,
    ) -> std::option::Option<&crate::model::VirtualGatewayConnectionPool> {
        self.connection_pool.as_ref()
    }
}
impl std::fmt::Debug for VirtualGatewayListener {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VirtualGatewayListener");
        formatter.field("health_check", &self.health_check);
        formatter.field("port_mapping", &self.port_mapping);
        formatter.field("tls", &self.tls);
        formatter.field("connection_pool", &self.connection_pool);
        formatter.finish()
    }
}
/// See [`VirtualGatewayListener`](crate::model::VirtualGatewayListener)
pub mod virtual_gateway_listener {
    /// A builder for [`VirtualGatewayListener`](crate::model::VirtualGatewayListener)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) health_check: std::option::Option<crate::model::VirtualGatewayHealthCheckPolicy>,
        pub(crate) port_mapping: std::option::Option<crate::model::VirtualGatewayPortMapping>,
        pub(crate) tls: std::option::Option<crate::model::VirtualGatewayListenerTls>,
        pub(crate) connection_pool: std::option::Option<crate::model::VirtualGatewayConnectionPool>,
    }
    impl Builder {
        /// <p>The health check information for the listener.</p>
        pub fn health_check(
            mut self,
            input: crate::model::VirtualGatewayHealthCheckPolicy,
        ) -> Self {
            self.health_check = Some(input);
            self
        }
        /// <p>The health check information for the listener.</p>
        pub fn set_health_check(
            mut self,
            input: std::option::Option<crate::model::VirtualGatewayHealthCheckPolicy>,
        ) -> Self {
            self.health_check = input;
            self
        }
        /// <p>The port mapping information for the listener.</p>
        pub fn port_mapping(mut self, input: crate::model::VirtualGatewayPortMapping) -> Self {
            self.port_mapping = Some(input);
            self
        }
        /// <p>The port mapping information for the listener.</p>
        pub fn set_port_mapping(
            mut self,
            input: std::option::Option<crate::model::VirtualGatewayPortMapping>,
        ) -> Self {
            self.port_mapping = input;
            self
        }
        /// <p>A reference to an object that represents the Transport Layer Security (TLS) properties for the listener.</p>
        pub fn tls(mut self, input: crate::model::VirtualGatewayListenerTls) -> Self {
            self.tls = Some(input);
            self
        }
        /// <p>A reference to an object that represents the Transport Layer Security (TLS) properties for the listener.</p>
        pub fn set_tls(
            mut self,
            input: std::option::Option<crate::model::VirtualGatewayListenerTls>,
        ) -> Self {
            self.tls = input;
            self
        }
        /// <p>The connection pool information for the virtual gateway listener.</p>
        pub fn connection_pool(
            mut self,
            input: crate::model::VirtualGatewayConnectionPool,
        ) -> Self {
            self.connection_pool = Some(input);
            self
        }
        /// <p>The connection pool information for the virtual gateway listener.</p>
        pub fn set_connection_pool(
            mut self,
            input: std::option::Option<crate::model::VirtualGatewayConnectionPool>,
        ) -> Self {
            self.connection_pool = input;
            self
        }
        /// Consumes the builder and constructs a [`VirtualGatewayListener`](crate::model::VirtualGatewayListener)
        pub fn build(self) -> crate::model::VirtualGatewayListener {
            crate::model::VirtualGatewayListener {
                health_check: self.health_check,
                port_mapping: self.port_mapping,
                tls: self.tls,
                connection_pool: self.connection_pool,
            }
        }
    }
}
impl VirtualGatewayListener {
    /// Creates a new builder-style object to manufacture [`VirtualGatewayListener`](crate::model::VirtualGatewayListener)
    pub fn builder() -> crate::model::virtual_gateway_listener::Builder {
        crate::model::virtual_gateway_listener::Builder::default()
    }
}

/// <p>An object that represents the type of virtual gateway connection pool.</p>
/// <p>Only one protocol is used at a time and should be the same protocol as the one chosen
/// under port mapping.</p>
/// <p>If not present the default value for <code>maxPendingRequests</code> is
/// <code>2147483647</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum VirtualGatewayConnectionPool {
    /// <p>An object that represents a type of connection pool. </p>
    Grpc(crate::model::VirtualGatewayGrpcConnectionPool),
    /// <p>An object that represents a type of connection pool.</p>
    Http(crate::model::VirtualGatewayHttpConnectionPool),
    /// <p>An object that represents a type of connection pool.</p>
    Http2(crate::model::VirtualGatewayHttp2ConnectionPool),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl VirtualGatewayConnectionPool {
    /// Tries to convert the enum instance into [`Grpc`](crate::model::VirtualGatewayConnectionPool::Grpc), extracting the inner [`VirtualGatewayGrpcConnectionPool`](crate::model::VirtualGatewayGrpcConnectionPool).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_grpc(
        &self,
    ) -> std::result::Result<&crate::model::VirtualGatewayGrpcConnectionPool, &Self> {
        if let VirtualGatewayConnectionPool::Grpc(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Grpc`](crate::model::VirtualGatewayConnectionPool::Grpc).
    pub fn is_grpc(&self) -> bool {
        self.as_grpc().is_ok()
    }
    /// Tries to convert the enum instance into [`Http`](crate::model::VirtualGatewayConnectionPool::Http), extracting the inner [`VirtualGatewayHttpConnectionPool`](crate::model::VirtualGatewayHttpConnectionPool).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_http(
        &self,
    ) -> std::result::Result<&crate::model::VirtualGatewayHttpConnectionPool, &Self> {
        if let VirtualGatewayConnectionPool::Http(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Http`](crate::model::VirtualGatewayConnectionPool::Http).
    pub fn is_http(&self) -> bool {
        self.as_http().is_ok()
    }
    /// Tries to convert the enum instance into [`Http2`](crate::model::VirtualGatewayConnectionPool::Http2), extracting the inner [`VirtualGatewayHttp2ConnectionPool`](crate::model::VirtualGatewayHttp2ConnectionPool).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_http2(
        &self,
    ) -> std::result::Result<&crate::model::VirtualGatewayHttp2ConnectionPool, &Self> {
        if let VirtualGatewayConnectionPool::Http2(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Http2`](crate::model::VirtualGatewayConnectionPool::Http2).
    pub fn is_http2(&self) -> bool {
        self.as_http2().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

/// <p>An object that represents a type of connection pool.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VirtualGatewayGrpcConnectionPool {
    /// <p>Maximum number of inflight requests Envoy can concurrently support across hosts in
    /// upstream cluster.</p>
    pub max_requests: i32,
}
impl VirtualGatewayGrpcConnectionPool {
    /// <p>Maximum number of inflight requests Envoy can concurrently support across hosts in
    /// upstream cluster.</p>
    pub fn max_requests(&self) -> i32 {
        self.max_requests
    }
}
impl std::fmt::Debug for VirtualGatewayGrpcConnectionPool {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VirtualGatewayGrpcConnectionPool");
        formatter.field("max_requests", &self.max_requests);
        formatter.finish()
    }
}
/// See [`VirtualGatewayGrpcConnectionPool`](crate::model::VirtualGatewayGrpcConnectionPool)
pub mod virtual_gateway_grpc_connection_pool {
    /// A builder for [`VirtualGatewayGrpcConnectionPool`](crate::model::VirtualGatewayGrpcConnectionPool)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_requests: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Maximum number of inflight requests Envoy can concurrently support across hosts in
        /// upstream cluster.</p>
        pub fn max_requests(mut self, input: i32) -> Self {
            self.max_requests = Some(input);
            self
        }
        /// <p>Maximum number of inflight requests Envoy can concurrently support across hosts in
        /// upstream cluster.</p>
        pub fn set_max_requests(mut self, input: std::option::Option<i32>) -> Self {
            self.max_requests = input;
            self
        }
        /// Consumes the builder and constructs a [`VirtualGatewayGrpcConnectionPool`](crate::model::VirtualGatewayGrpcConnectionPool)
        pub fn build(self) -> crate::model::VirtualGatewayGrpcConnectionPool {
            crate::model::VirtualGatewayGrpcConnectionPool {
                max_requests: self.max_requests.unwrap_or_default(),
            }
        }
    }
}
impl VirtualGatewayGrpcConnectionPool {
    /// Creates a new builder-style object to manufacture [`VirtualGatewayGrpcConnectionPool`](crate::model::VirtualGatewayGrpcConnectionPool)
    pub fn builder() -> crate::model::virtual_gateway_grpc_connection_pool::Builder {
        crate::model::virtual_gateway_grpc_connection_pool::Builder::default()
    }
}

/// <p>An object that represents a type of connection pool.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VirtualGatewayHttp2ConnectionPool {
    /// <p>Maximum number of inflight requests Envoy can concurrently support across hosts in
    /// upstream cluster.</p>
    pub max_requests: i32,
}
impl VirtualGatewayHttp2ConnectionPool {
    /// <p>Maximum number of inflight requests Envoy can concurrently support across hosts in
    /// upstream cluster.</p>
    pub fn max_requests(&self) -> i32 {
        self.max_requests
    }
}
impl std::fmt::Debug for VirtualGatewayHttp2ConnectionPool {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VirtualGatewayHttp2ConnectionPool");
        formatter.field("max_requests", &self.max_requests);
        formatter.finish()
    }
}
/// See [`VirtualGatewayHttp2ConnectionPool`](crate::model::VirtualGatewayHttp2ConnectionPool)
pub mod virtual_gateway_http2_connection_pool {
    /// A builder for [`VirtualGatewayHttp2ConnectionPool`](crate::model::VirtualGatewayHttp2ConnectionPool)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_requests: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Maximum number of inflight requests Envoy can concurrently support across hosts in
        /// upstream cluster.</p>
        pub fn max_requests(mut self, input: i32) -> Self {
            self.max_requests = Some(input);
            self
        }
        /// <p>Maximum number of inflight requests Envoy can concurrently support across hosts in
        /// upstream cluster.</p>
        pub fn set_max_requests(mut self, input: std::option::Option<i32>) -> Self {
            self.max_requests = input;
            self
        }
        /// Consumes the builder and constructs a [`VirtualGatewayHttp2ConnectionPool`](crate::model::VirtualGatewayHttp2ConnectionPool)
        pub fn build(self) -> crate::model::VirtualGatewayHttp2ConnectionPool {
            crate::model::VirtualGatewayHttp2ConnectionPool {
                max_requests: self.max_requests.unwrap_or_default(),
            }
        }
    }
}
impl VirtualGatewayHttp2ConnectionPool {
    /// Creates a new builder-style object to manufacture [`VirtualGatewayHttp2ConnectionPool`](crate::model::VirtualGatewayHttp2ConnectionPool)
    pub fn builder() -> crate::model::virtual_gateway_http2_connection_pool::Builder {
        crate::model::virtual_gateway_http2_connection_pool::Builder::default()
    }
}

/// <p>An object that represents a type of connection pool.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VirtualGatewayHttpConnectionPool {
    /// <p>Maximum number of outbound TCP connections Envoy can establish concurrently with all
    /// hosts in upstream cluster.</p>
    pub max_connections: i32,
    /// <p>Number of overflowing requests after <code>max_connections</code> Envoy will queue to
    /// upstream cluster.</p>
    pub max_pending_requests: std::option::Option<i32>,
}
impl VirtualGatewayHttpConnectionPool {
    /// <p>Maximum number of outbound TCP connections Envoy can establish concurrently with all
    /// hosts in upstream cluster.</p>
    pub fn max_connections(&self) -> i32 {
        self.max_connections
    }
    /// <p>Number of overflowing requests after <code>max_connections</code> Envoy will queue to
    /// upstream cluster.</p>
    pub fn max_pending_requests(&self) -> std::option::Option<i32> {
        self.max_pending_requests
    }
}
impl std::fmt::Debug for VirtualGatewayHttpConnectionPool {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VirtualGatewayHttpConnectionPool");
        formatter.field("max_connections", &self.max_connections);
        formatter.field("max_pending_requests", &self.max_pending_requests);
        formatter.finish()
    }
}
/// See [`VirtualGatewayHttpConnectionPool`](crate::model::VirtualGatewayHttpConnectionPool)
pub mod virtual_gateway_http_connection_pool {
    /// A builder for [`VirtualGatewayHttpConnectionPool`](crate::model::VirtualGatewayHttpConnectionPool)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_connections: std::option::Option<i32>,
        pub(crate) max_pending_requests: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Maximum number of outbound TCP connections Envoy can establish concurrently with all
        /// hosts in upstream cluster.</p>
        pub fn max_connections(mut self, input: i32) -> Self {
            self.max_connections = Some(input);
            self
        }
        /// <p>Maximum number of outbound TCP connections Envoy can establish concurrently with all
        /// hosts in upstream cluster.</p>
        pub fn set_max_connections(mut self, input: std::option::Option<i32>) -> Self {
            self.max_connections = input;
            self
        }
        /// <p>Number of overflowing requests after <code>max_connections</code> Envoy will queue to
        /// upstream cluster.</p>
        pub fn max_pending_requests(mut self, input: i32) -> Self {
            self.max_pending_requests = Some(input);
            self
        }
        /// <p>Number of overflowing requests after <code>max_connections</code> Envoy will queue to
        /// upstream cluster.</p>
        pub fn set_max_pending_requests(mut self, input: std::option::Option<i32>) -> Self {
            self.max_pending_requests = input;
            self
        }
        /// Consumes the builder and constructs a [`VirtualGatewayHttpConnectionPool`](crate::model::VirtualGatewayHttpConnectionPool)
        pub fn build(self) -> crate::model::VirtualGatewayHttpConnectionPool {
            crate::model::VirtualGatewayHttpConnectionPool {
                max_connections: self.max_connections.unwrap_or_default(),
                max_pending_requests: self.max_pending_requests,
            }
        }
    }
}
impl VirtualGatewayHttpConnectionPool {
    /// Creates a new builder-style object to manufacture [`VirtualGatewayHttpConnectionPool`](crate::model::VirtualGatewayHttpConnectionPool)
    pub fn builder() -> crate::model::virtual_gateway_http_connection_pool::Builder {
        crate::model::virtual_gateway_http_connection_pool::Builder::default()
    }
}

/// <p>An object that represents the Transport Layer Security (TLS) properties for a listener.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VirtualGatewayListenerTls {
    /// <p>Specify one of the following modes.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b/>STRICT – Listener only accepts connections with TLS
    /// enabled. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <b/>PERMISSIVE – Listener accepts connections with or
    /// without TLS enabled.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b/>DISABLED – Listener only accepts connections without
    /// TLS. </p>
    /// </li>
    /// </ul>
    pub mode: std::option::Option<crate::model::VirtualGatewayListenerTlsMode>,
    /// <p>A reference to an object that represents a virtual gateway's listener's Transport Layer Security (TLS) validation
    /// context.</p>
    pub validation: std::option::Option<crate::model::VirtualGatewayListenerTlsValidationContext>,
    /// <p>An object that represents a Transport Layer Security (TLS) certificate.</p>
    pub certificate: std::option::Option<crate::model::VirtualGatewayListenerTlsCertificate>,
}
impl VirtualGatewayListenerTls {
    /// <p>Specify one of the following modes.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b/>STRICT – Listener only accepts connections with TLS
    /// enabled. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <b/>PERMISSIVE – Listener accepts connections with or
    /// without TLS enabled.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b/>DISABLED – Listener only accepts connections without
    /// TLS. </p>
    /// </li>
    /// </ul>
    pub fn mode(&self) -> std::option::Option<&crate::model::VirtualGatewayListenerTlsMode> {
        self.mode.as_ref()
    }
    /// <p>A reference to an object that represents a virtual gateway's listener's Transport Layer Security (TLS) validation
    /// context.</p>
    pub fn validation(
        &self,
    ) -> std::option::Option<&crate::model::VirtualGatewayListenerTlsValidationContext> {
        self.validation.as_ref()
    }
    /// <p>An object that represents a Transport Layer Security (TLS) certificate.</p>
    pub fn certificate(
        &self,
    ) -> std::option::Option<&crate::model::VirtualGatewayListenerTlsCertificate> {
        self.certificate.as_ref()
    }
}
impl std::fmt::Debug for VirtualGatewayListenerTls {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VirtualGatewayListenerTls");
        formatter.field("mode", &self.mode);
        formatter.field("validation", &self.validation);
        formatter.field("certificate", &self.certificate);
        formatter.finish()
    }
}
/// See [`VirtualGatewayListenerTls`](crate::model::VirtualGatewayListenerTls)
pub mod virtual_gateway_listener_tls {
    /// A builder for [`VirtualGatewayListenerTls`](crate::model::VirtualGatewayListenerTls)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mode: std::option::Option<crate::model::VirtualGatewayListenerTlsMode>,
        pub(crate) validation:
            std::option::Option<crate::model::VirtualGatewayListenerTlsValidationContext>,
        pub(crate) certificate:
            std::option::Option<crate::model::VirtualGatewayListenerTlsCertificate>,
    }
    impl Builder {
        /// <p>Specify one of the following modes.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b/>STRICT – Listener only accepts connections with TLS
        /// enabled. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b/>PERMISSIVE – Listener accepts connections with or
        /// without TLS enabled.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b/>DISABLED – Listener only accepts connections without
        /// TLS. </p>
        /// </li>
        /// </ul>
        pub fn mode(mut self, input: crate::model::VirtualGatewayListenerTlsMode) -> Self {
            self.mode = Some(input);
            self
        }
        /// <p>Specify one of the following modes.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b/>STRICT – Listener only accepts connections with TLS
        /// enabled. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b/>PERMISSIVE – Listener accepts connections with or
        /// without TLS enabled.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b/>DISABLED – Listener only accepts connections without
        /// TLS. </p>
        /// </li>
        /// </ul>
        pub fn set_mode(
            mut self,
            input: std::option::Option<crate::model::VirtualGatewayListenerTlsMode>,
        ) -> Self {
            self.mode = input;
            self
        }
        /// <p>A reference to an object that represents a virtual gateway's listener's Transport Layer Security (TLS) validation
        /// context.</p>
        pub fn validation(
            mut self,
            input: crate::model::VirtualGatewayListenerTlsValidationContext,
        ) -> Self {
            self.validation = Some(input);
            self
        }
        /// <p>A reference to an object that represents a virtual gateway's listener's Transport Layer Security (TLS) validation
        /// context.</p>
        pub fn set_validation(
            mut self,
            input: std::option::Option<crate::model::VirtualGatewayListenerTlsValidationContext>,
        ) -> Self {
            self.validation = input;
            self
        }
        /// <p>An object that represents a Transport Layer Security (TLS) certificate.</p>
        pub fn certificate(
            mut self,
            input: crate::model::VirtualGatewayListenerTlsCertificate,
        ) -> Self {
            self.certificate = Some(input);
            self
        }
        /// <p>An object that represents a Transport Layer Security (TLS) certificate.</p>
        pub fn set_certificate(
            mut self,
            input: std::option::Option<crate::model::VirtualGatewayListenerTlsCertificate>,
        ) -> Self {
            self.certificate = input;
            self
        }
        /// Consumes the builder and constructs a [`VirtualGatewayListenerTls`](crate::model::VirtualGatewayListenerTls)
        pub fn build(self) -> crate::model::VirtualGatewayListenerTls {
            crate::model::VirtualGatewayListenerTls {
                mode: self.mode,
                validation: self.validation,
                certificate: self.certificate,
            }
        }
    }
}
impl VirtualGatewayListenerTls {
    /// Creates a new builder-style object to manufacture [`VirtualGatewayListenerTls`](crate::model::VirtualGatewayListenerTls)
    pub fn builder() -> crate::model::virtual_gateway_listener_tls::Builder {
        crate::model::virtual_gateway_listener_tls::Builder::default()
    }
}

/// <p>An object that represents a listener's Transport Layer Security (TLS) certificate.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum VirtualGatewayListenerTlsCertificate {
    /// <p>A reference to an object that represents an Certificate Manager certificate.</p>
    Acm(crate::model::VirtualGatewayListenerTlsAcmCertificate),
    /// <p>A reference to an object that represents a local file certificate.</p>
    File(crate::model::VirtualGatewayListenerTlsFileCertificate),
    /// <p>A reference to an object that represents a virtual gateway's listener's Secret Discovery
    /// Service certificate.</p>
    Sds(crate::model::VirtualGatewayListenerTlsSdsCertificate),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl VirtualGatewayListenerTlsCertificate {
    /// Tries to convert the enum instance into [`Acm`](crate::model::VirtualGatewayListenerTlsCertificate::Acm), extracting the inner [`VirtualGatewayListenerTlsAcmCertificate`](crate::model::VirtualGatewayListenerTlsAcmCertificate).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_acm(
        &self,
    ) -> std::result::Result<&crate::model::VirtualGatewayListenerTlsAcmCertificate, &Self> {
        if let VirtualGatewayListenerTlsCertificate::Acm(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Acm`](crate::model::VirtualGatewayListenerTlsCertificate::Acm).
    pub fn is_acm(&self) -> bool {
        self.as_acm().is_ok()
    }
    /// Tries to convert the enum instance into [`File`](crate::model::VirtualGatewayListenerTlsCertificate::File), extracting the inner [`VirtualGatewayListenerTlsFileCertificate`](crate::model::VirtualGatewayListenerTlsFileCertificate).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_file(
        &self,
    ) -> std::result::Result<&crate::model::VirtualGatewayListenerTlsFileCertificate, &Self> {
        if let VirtualGatewayListenerTlsCertificate::File(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`File`](crate::model::VirtualGatewayListenerTlsCertificate::File).
    pub fn is_file(&self) -> bool {
        self.as_file().is_ok()
    }
    /// Tries to convert the enum instance into [`Sds`](crate::model::VirtualGatewayListenerTlsCertificate::Sds), extracting the inner [`VirtualGatewayListenerTlsSdsCertificate`](crate::model::VirtualGatewayListenerTlsSdsCertificate).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_sds(
        &self,
    ) -> std::result::Result<&crate::model::VirtualGatewayListenerTlsSdsCertificate, &Self> {
        if let VirtualGatewayListenerTlsCertificate::Sds(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Sds`](crate::model::VirtualGatewayListenerTlsCertificate::Sds).
    pub fn is_sds(&self) -> bool {
        self.as_sds().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

/// <p>An object that represents the virtual gateway's listener's Secret Discovery Service
/// certificate.The proxy must be configured with a local SDS provider via a Unix Domain
/// Socket. See App Mesh<a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html">TLS
/// documentation</a> for more info. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VirtualGatewayListenerTlsSdsCertificate {
    /// <p>A reference to an object that represents the name of the secret secret requested from
    /// the Secret Discovery Service provider representing Transport Layer Security (TLS) materials like a certificate or
    /// certificate chain.</p>
    pub secret_name: std::option::Option<std::string::String>,
}
impl VirtualGatewayListenerTlsSdsCertificate {
    /// <p>A reference to an object that represents the name of the secret secret requested from
    /// the Secret Discovery Service provider representing Transport Layer Security (TLS) materials like a certificate or
    /// certificate chain.</p>
    pub fn secret_name(&self) -> std::option::Option<&str> {
        self.secret_name.as_deref()
    }
}
impl std::fmt::Debug for VirtualGatewayListenerTlsSdsCertificate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VirtualGatewayListenerTlsSdsCertificate");
        formatter.field("secret_name", &self.secret_name);
        formatter.finish()
    }
}
/// See [`VirtualGatewayListenerTlsSdsCertificate`](crate::model::VirtualGatewayListenerTlsSdsCertificate)
pub mod virtual_gateway_listener_tls_sds_certificate {
    /// A builder for [`VirtualGatewayListenerTlsSdsCertificate`](crate::model::VirtualGatewayListenerTlsSdsCertificate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) secret_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A reference to an object that represents the name of the secret secret requested from
        /// the Secret Discovery Service provider representing Transport Layer Security (TLS) materials like a certificate or
        /// certificate chain.</p>
        pub fn secret_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.secret_name = Some(input.into());
            self
        }
        /// <p>A reference to an object that represents the name of the secret secret requested from
        /// the Secret Discovery Service provider representing Transport Layer Security (TLS) materials like a certificate or
        /// certificate chain.</p>
        pub fn set_secret_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.secret_name = input;
            self
        }
        /// Consumes the builder and constructs a [`VirtualGatewayListenerTlsSdsCertificate`](crate::model::VirtualGatewayListenerTlsSdsCertificate)
        pub fn build(self) -> crate::model::VirtualGatewayListenerTlsSdsCertificate {
            crate::model::VirtualGatewayListenerTlsSdsCertificate {
                secret_name: self.secret_name,
            }
        }
    }
}
impl VirtualGatewayListenerTlsSdsCertificate {
    /// Creates a new builder-style object to manufacture [`VirtualGatewayListenerTlsSdsCertificate`](crate::model::VirtualGatewayListenerTlsSdsCertificate)
    pub fn builder() -> crate::model::virtual_gateway_listener_tls_sds_certificate::Builder {
        crate::model::virtual_gateway_listener_tls_sds_certificate::Builder::default()
    }
}

/// <p>An object that represents a local file certificate.
/// The certificate must meet specific requirements and you must have proxy authorization enabled. For more information, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html#virtual-node-tls-prerequisites">Transport Layer Security (TLS)</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VirtualGatewayListenerTlsFileCertificate {
    /// <p>The certificate chain for the certificate.</p>
    pub certificate_chain: std::option::Option<std::string::String>,
    /// <p>The private key for a certificate stored on the file system of the mesh endpoint that
    /// the proxy is running on.</p>
    pub private_key: std::option::Option<std::string::String>,
}
impl VirtualGatewayListenerTlsFileCertificate {
    /// <p>The certificate chain for the certificate.</p>
    pub fn certificate_chain(&self) -> std::option::Option<&str> {
        self.certificate_chain.as_deref()
    }
    /// <p>The private key for a certificate stored on the file system of the mesh endpoint that
    /// the proxy is running on.</p>
    pub fn private_key(&self) -> std::option::Option<&str> {
        self.private_key.as_deref()
    }
}
impl std::fmt::Debug for VirtualGatewayListenerTlsFileCertificate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VirtualGatewayListenerTlsFileCertificate");
        formatter.field("certificate_chain", &self.certificate_chain);
        formatter.field("private_key", &self.private_key);
        formatter.finish()
    }
}
/// See [`VirtualGatewayListenerTlsFileCertificate`](crate::model::VirtualGatewayListenerTlsFileCertificate)
pub mod virtual_gateway_listener_tls_file_certificate {
    /// A builder for [`VirtualGatewayListenerTlsFileCertificate`](crate::model::VirtualGatewayListenerTlsFileCertificate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_chain: std::option::Option<std::string::String>,
        pub(crate) private_key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The certificate chain for the certificate.</p>
        pub fn certificate_chain(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_chain = Some(input.into());
            self
        }
        /// <p>The certificate chain for the certificate.</p>
        pub fn set_certificate_chain(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_chain = input;
            self
        }
        /// <p>The private key for a certificate stored on the file system of the mesh endpoint that
        /// the proxy is running on.</p>
        pub fn private_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.private_key = Some(input.into());
            self
        }
        /// <p>The private key for a certificate stored on the file system of the mesh endpoint that
        /// the proxy is running on.</p>
        pub fn set_private_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.private_key = input;
            self
        }
        /// Consumes the builder and constructs a [`VirtualGatewayListenerTlsFileCertificate`](crate::model::VirtualGatewayListenerTlsFileCertificate)
        pub fn build(self) -> crate::model::VirtualGatewayListenerTlsFileCertificate {
            crate::model::VirtualGatewayListenerTlsFileCertificate {
                certificate_chain: self.certificate_chain,
                private_key: self.private_key,
            }
        }
    }
}
impl VirtualGatewayListenerTlsFileCertificate {
    /// Creates a new builder-style object to manufacture [`VirtualGatewayListenerTlsFileCertificate`](crate::model::VirtualGatewayListenerTlsFileCertificate)
    pub fn builder() -> crate::model::virtual_gateway_listener_tls_file_certificate::Builder {
        crate::model::virtual_gateway_listener_tls_file_certificate::Builder::default()
    }
}

/// <p>An object that represents an Certificate Manager certificate.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VirtualGatewayListenerTlsAcmCertificate {
    /// <p>The Amazon Resource Name (ARN) for the certificate. The certificate must meet specific requirements and you must have proxy authorization enabled. For more information, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html#virtual-node-tls-prerequisites">Transport Layer Security (TLS)</a>.</p>
    pub certificate_arn: std::option::Option<std::string::String>,
}
impl VirtualGatewayListenerTlsAcmCertificate {
    /// <p>The Amazon Resource Name (ARN) for the certificate. The certificate must meet specific requirements and you must have proxy authorization enabled. For more information, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html#virtual-node-tls-prerequisites">Transport Layer Security (TLS)</a>.</p>
    pub fn certificate_arn(&self) -> std::option::Option<&str> {
        self.certificate_arn.as_deref()
    }
}
impl std::fmt::Debug for VirtualGatewayListenerTlsAcmCertificate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VirtualGatewayListenerTlsAcmCertificate");
        formatter.field("certificate_arn", &self.certificate_arn);
        formatter.finish()
    }
}
/// See [`VirtualGatewayListenerTlsAcmCertificate`](crate::model::VirtualGatewayListenerTlsAcmCertificate)
pub mod virtual_gateway_listener_tls_acm_certificate {
    /// A builder for [`VirtualGatewayListenerTlsAcmCertificate`](crate::model::VirtualGatewayListenerTlsAcmCertificate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for the certificate. The certificate must meet specific requirements and you must have proxy authorization enabled. For more information, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html#virtual-node-tls-prerequisites">Transport Layer Security (TLS)</a>.</p>
        pub fn certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the certificate. The certificate must meet specific requirements and you must have proxy authorization enabled. For more information, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html#virtual-node-tls-prerequisites">Transport Layer Security (TLS)</a>.</p>
        pub fn set_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`VirtualGatewayListenerTlsAcmCertificate`](crate::model::VirtualGatewayListenerTlsAcmCertificate)
        pub fn build(self) -> crate::model::VirtualGatewayListenerTlsAcmCertificate {
            crate::model::VirtualGatewayListenerTlsAcmCertificate {
                certificate_arn: self.certificate_arn,
            }
        }
    }
}
impl VirtualGatewayListenerTlsAcmCertificate {
    /// Creates a new builder-style object to manufacture [`VirtualGatewayListenerTlsAcmCertificate`](crate::model::VirtualGatewayListenerTlsAcmCertificate)
    pub fn builder() -> crate::model::virtual_gateway_listener_tls_acm_certificate::Builder {
        crate::model::virtual_gateway_listener_tls_acm_certificate::Builder::default()
    }
}

/// <p>An object that represents a virtual gateway's listener's Transport Layer Security (TLS) validation
/// context.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VirtualGatewayListenerTlsValidationContext {
    /// <p>A reference to where to retrieve the trust chain when validating a peer’s Transport Layer Security (TLS)
    /// certificate.</p>
    pub trust: std::option::Option<crate::model::VirtualGatewayListenerTlsValidationContextTrust>,
    /// <p>A reference to an object that represents the SANs for a virtual gateway listener's Transport Layer Security (TLS)
    /// validation context.</p>
    pub subject_alternative_names: std::option::Option<crate::model::SubjectAlternativeNames>,
}
impl VirtualGatewayListenerTlsValidationContext {
    /// <p>A reference to where to retrieve the trust chain when validating a peer’s Transport Layer Security (TLS)
    /// certificate.</p>
    pub fn trust(
        &self,
    ) -> std::option::Option<&crate::model::VirtualGatewayListenerTlsValidationContextTrust> {
        self.trust.as_ref()
    }
    /// <p>A reference to an object that represents the SANs for a virtual gateway listener's Transport Layer Security (TLS)
    /// validation context.</p>
    pub fn subject_alternative_names(
        &self,
    ) -> std::option::Option<&crate::model::SubjectAlternativeNames> {
        self.subject_alternative_names.as_ref()
    }
}
impl std::fmt::Debug for VirtualGatewayListenerTlsValidationContext {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VirtualGatewayListenerTlsValidationContext");
        formatter.field("trust", &self.trust);
        formatter.field("subject_alternative_names", &self.subject_alternative_names);
        formatter.finish()
    }
}
/// See [`VirtualGatewayListenerTlsValidationContext`](crate::model::VirtualGatewayListenerTlsValidationContext)
pub mod virtual_gateway_listener_tls_validation_context {
    /// A builder for [`VirtualGatewayListenerTlsValidationContext`](crate::model::VirtualGatewayListenerTlsValidationContext)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trust:
            std::option::Option<crate::model::VirtualGatewayListenerTlsValidationContextTrust>,
        pub(crate) subject_alternative_names:
            std::option::Option<crate::model::SubjectAlternativeNames>,
    }
    impl Builder {
        /// <p>A reference to where to retrieve the trust chain when validating a peer’s Transport Layer Security (TLS)
        /// certificate.</p>
        pub fn trust(
            mut self,
            input: crate::model::VirtualGatewayListenerTlsValidationContextTrust,
        ) -> Self {
            self.trust = Some(input);
            self
        }
        /// <p>A reference to where to retrieve the trust chain when validating a peer’s Transport Layer Security (TLS)
        /// certificate.</p>
        pub fn set_trust(
            mut self,
            input: std::option::Option<
                crate::model::VirtualGatewayListenerTlsValidationContextTrust,
            >,
        ) -> Self {
            self.trust = input;
            self
        }
        /// <p>A reference to an object that represents the SANs for a virtual gateway listener's Transport Layer Security (TLS)
        /// validation context.</p>
        pub fn subject_alternative_names(
            mut self,
            input: crate::model::SubjectAlternativeNames,
        ) -> Self {
            self.subject_alternative_names = Some(input);
            self
        }
        /// <p>A reference to an object that represents the SANs for a virtual gateway listener's Transport Layer Security (TLS)
        /// validation context.</p>
        pub fn set_subject_alternative_names(
            mut self,
            input: std::option::Option<crate::model::SubjectAlternativeNames>,
        ) -> Self {
            self.subject_alternative_names = input;
            self
        }
        /// Consumes the builder and constructs a [`VirtualGatewayListenerTlsValidationContext`](crate::model::VirtualGatewayListenerTlsValidationContext)
        pub fn build(self) -> crate::model::VirtualGatewayListenerTlsValidationContext {
            crate::model::VirtualGatewayListenerTlsValidationContext {
                trust: self.trust,
                subject_alternative_names: self.subject_alternative_names,
            }
        }
    }
}
impl VirtualGatewayListenerTlsValidationContext {
    /// Creates a new builder-style object to manufacture [`VirtualGatewayListenerTlsValidationContext`](crate::model::VirtualGatewayListenerTlsValidationContext)
    pub fn builder() -> crate::model::virtual_gateway_listener_tls_validation_context::Builder {
        crate::model::virtual_gateway_listener_tls_validation_context::Builder::default()
    }
}

/// <p>An object that represents a virtual gateway's listener's Transport Layer Security (TLS) validation context
/// trust.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum VirtualGatewayListenerTlsValidationContextTrust {
    /// <p>An object that represents a Transport Layer Security (TLS) validation context trust for a local file.</p>
    File(crate::model::VirtualGatewayTlsValidationContextFileTrust),
    /// <p>A reference to an object that represents a virtual gateway's listener's Transport Layer Security (TLS) Secret
    /// Discovery Service validation context trust.</p>
    Sds(crate::model::VirtualGatewayTlsValidationContextSdsTrust),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl VirtualGatewayListenerTlsValidationContextTrust {
    /// Tries to convert the enum instance into [`File`](crate::model::VirtualGatewayListenerTlsValidationContextTrust::File), extracting the inner [`VirtualGatewayTlsValidationContextFileTrust`](crate::model::VirtualGatewayTlsValidationContextFileTrust).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_file(
        &self,
    ) -> std::result::Result<&crate::model::VirtualGatewayTlsValidationContextFileTrust, &Self>
    {
        if let VirtualGatewayListenerTlsValidationContextTrust::File(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`File`](crate::model::VirtualGatewayListenerTlsValidationContextTrust::File).
    pub fn is_file(&self) -> bool {
        self.as_file().is_ok()
    }
    /// Tries to convert the enum instance into [`Sds`](crate::model::VirtualGatewayListenerTlsValidationContextTrust::Sds), extracting the inner [`VirtualGatewayTlsValidationContextSdsTrust`](crate::model::VirtualGatewayTlsValidationContextSdsTrust).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_sds(
        &self,
    ) -> std::result::Result<&crate::model::VirtualGatewayTlsValidationContextSdsTrust, &Self> {
        if let VirtualGatewayListenerTlsValidationContextTrust::Sds(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Sds`](crate::model::VirtualGatewayListenerTlsValidationContextTrust::Sds).
    pub fn is_sds(&self) -> bool {
        self.as_sds().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

/// <p>An object that represents a virtual gateway's listener's Transport Layer Security (TLS) Secret Discovery Service
/// validation context trust. The proxy must be configured with a local SDS provider via a Unix
/// Domain Socket. See App Mesh <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html">TLS documentation</a> for more info.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VirtualGatewayTlsValidationContextSdsTrust {
    /// <p>A reference to an object that represents the name of the secret for a virtual gateway's
    /// Transport Layer Security (TLS) Secret Discovery Service validation context trust.</p>
    pub secret_name: std::option::Option<std::string::String>,
}
impl VirtualGatewayTlsValidationContextSdsTrust {
    /// <p>A reference to an object that represents the name of the secret for a virtual gateway's
    /// Transport Layer Security (TLS) Secret Discovery Service validation context trust.</p>
    pub fn secret_name(&self) -> std::option::Option<&str> {
        self.secret_name.as_deref()
    }
}
impl std::fmt::Debug for VirtualGatewayTlsValidationContextSdsTrust {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VirtualGatewayTlsValidationContextSdsTrust");
        formatter.field("secret_name", &self.secret_name);
        formatter.finish()
    }
}
/// See [`VirtualGatewayTlsValidationContextSdsTrust`](crate::model::VirtualGatewayTlsValidationContextSdsTrust)
pub mod virtual_gateway_tls_validation_context_sds_trust {
    /// A builder for [`VirtualGatewayTlsValidationContextSdsTrust`](crate::model::VirtualGatewayTlsValidationContextSdsTrust)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) secret_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A reference to an object that represents the name of the secret for a virtual gateway's
        /// Transport Layer Security (TLS) Secret Discovery Service validation context trust.</p>
        pub fn secret_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.secret_name = Some(input.into());
            self
        }
        /// <p>A reference to an object that represents the name of the secret for a virtual gateway's
        /// Transport Layer Security (TLS) Secret Discovery Service validation context trust.</p>
        pub fn set_secret_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.secret_name = input;
            self
        }
        /// Consumes the builder and constructs a [`VirtualGatewayTlsValidationContextSdsTrust`](crate::model::VirtualGatewayTlsValidationContextSdsTrust)
        pub fn build(self) -> crate::model::VirtualGatewayTlsValidationContextSdsTrust {
            crate::model::VirtualGatewayTlsValidationContextSdsTrust {
                secret_name: self.secret_name,
            }
        }
    }
}
impl VirtualGatewayTlsValidationContextSdsTrust {
    /// Creates a new builder-style object to manufacture [`VirtualGatewayTlsValidationContextSdsTrust`](crate::model::VirtualGatewayTlsValidationContextSdsTrust)
    pub fn builder() -> crate::model::virtual_gateway_tls_validation_context_sds_trust::Builder {
        crate::model::virtual_gateway_tls_validation_context_sds_trust::Builder::default()
    }
}

/// <p>An object that represents a Transport Layer Security (TLS) validation context trust for a local file.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VirtualGatewayTlsValidationContextFileTrust {
    /// <p>The certificate trust chain for a certificate stored on the file system of the virtual
    /// node that the proxy is running on.</p>
    pub certificate_chain: std::option::Option<std::string::String>,
}
impl VirtualGatewayTlsValidationContextFileTrust {
    /// <p>The certificate trust chain for a certificate stored on the file system of the virtual
    /// node that the proxy is running on.</p>
    pub fn certificate_chain(&self) -> std::option::Option<&str> {
        self.certificate_chain.as_deref()
    }
}
impl std::fmt::Debug for VirtualGatewayTlsValidationContextFileTrust {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VirtualGatewayTlsValidationContextFileTrust");
        formatter.field("certificate_chain", &self.certificate_chain);
        formatter.finish()
    }
}
/// See [`VirtualGatewayTlsValidationContextFileTrust`](crate::model::VirtualGatewayTlsValidationContextFileTrust)
pub mod virtual_gateway_tls_validation_context_file_trust {
    /// A builder for [`VirtualGatewayTlsValidationContextFileTrust`](crate::model::VirtualGatewayTlsValidationContextFileTrust)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_chain: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The certificate trust chain for a certificate stored on the file system of the virtual
        /// node that the proxy is running on.</p>
        pub fn certificate_chain(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_chain = Some(input.into());
            self
        }
        /// <p>The certificate trust chain for a certificate stored on the file system of the virtual
        /// node that the proxy is running on.</p>
        pub fn set_certificate_chain(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_chain = input;
            self
        }
        /// Consumes the builder and constructs a [`VirtualGatewayTlsValidationContextFileTrust`](crate::model::VirtualGatewayTlsValidationContextFileTrust)
        pub fn build(self) -> crate::model::VirtualGatewayTlsValidationContextFileTrust {
            crate::model::VirtualGatewayTlsValidationContextFileTrust {
                certificate_chain: self.certificate_chain,
            }
        }
    }
}
impl VirtualGatewayTlsValidationContextFileTrust {
    /// Creates a new builder-style object to manufacture [`VirtualGatewayTlsValidationContextFileTrust`](crate::model::VirtualGatewayTlsValidationContextFileTrust)
    pub fn builder() -> crate::model::virtual_gateway_tls_validation_context_file_trust::Builder {
        crate::model::virtual_gateway_tls_validation_context_file_trust::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum VirtualGatewayListenerTlsMode {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Permissive,
    #[allow(missing_docs)] // documentation missing in model
    Strict,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for VirtualGatewayListenerTlsMode {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => VirtualGatewayListenerTlsMode::Disabled,
            "PERMISSIVE" => VirtualGatewayListenerTlsMode::Permissive,
            "STRICT" => VirtualGatewayListenerTlsMode::Strict,
            other => VirtualGatewayListenerTlsMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for VirtualGatewayListenerTlsMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(VirtualGatewayListenerTlsMode::from(s))
    }
}
impl VirtualGatewayListenerTlsMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            VirtualGatewayListenerTlsMode::Disabled => "DISABLED",
            VirtualGatewayListenerTlsMode::Permissive => "PERMISSIVE",
            VirtualGatewayListenerTlsMode::Strict => "STRICT",
            VirtualGatewayListenerTlsMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "PERMISSIVE", "STRICT"]
    }
}
impl AsRef<str> for VirtualGatewayListenerTlsMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that represents a port mapping.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VirtualGatewayPortMapping {
    /// <p>The port used for the port mapping. Specify one protocol.</p>
    pub port: i32,
    /// <p>The protocol used for the port mapping.</p>
    pub protocol: std::option::Option<crate::model::VirtualGatewayPortProtocol>,
}
impl VirtualGatewayPortMapping {
    /// <p>The port used for the port mapping. Specify one protocol.</p>
    pub fn port(&self) -> i32 {
        self.port
    }
    /// <p>The protocol used for the port mapping.</p>
    pub fn protocol(&self) -> std::option::Option<&crate::model::VirtualGatewayPortProtocol> {
        self.protocol.as_ref()
    }
}
impl std::fmt::Debug for VirtualGatewayPortMapping {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VirtualGatewayPortMapping");
        formatter.field("port", &self.port);
        formatter.field("protocol", &self.protocol);
        formatter.finish()
    }
}
/// See [`VirtualGatewayPortMapping`](crate::model::VirtualGatewayPortMapping)
pub mod virtual_gateway_port_mapping {
    /// A builder for [`VirtualGatewayPortMapping`](crate::model::VirtualGatewayPortMapping)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) port: std::option::Option<i32>,
        pub(crate) protocol: std::option::Option<crate::model::VirtualGatewayPortProtocol>,
    }
    impl Builder {
        /// <p>The port used for the port mapping. Specify one protocol.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The port used for the port mapping. Specify one protocol.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>The protocol used for the port mapping.</p>
        pub fn protocol(mut self, input: crate::model::VirtualGatewayPortProtocol) -> Self {
            self.protocol = Some(input);
            self
        }
        /// <p>The protocol used for the port mapping.</p>
        pub fn set_protocol(
            mut self,
            input: std::option::Option<crate::model::VirtualGatewayPortProtocol>,
        ) -> Self {
            self.protocol = input;
            self
        }
        /// Consumes the builder and constructs a [`VirtualGatewayPortMapping`](crate::model::VirtualGatewayPortMapping)
        pub fn build(self) -> crate::model::VirtualGatewayPortMapping {
            crate::model::VirtualGatewayPortMapping {
                port: self.port.unwrap_or_default(),
                protocol: self.protocol,
            }
        }
    }
}
impl VirtualGatewayPortMapping {
    /// Creates a new builder-style object to manufacture [`VirtualGatewayPortMapping`](crate::model::VirtualGatewayPortMapping)
    pub fn builder() -> crate::model::virtual_gateway_port_mapping::Builder {
        crate::model::virtual_gateway_port_mapping::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum VirtualGatewayPortProtocol {
    #[allow(missing_docs)] // documentation missing in model
    Grpc,
    #[allow(missing_docs)] // documentation missing in model
    Http,
    #[allow(missing_docs)] // documentation missing in model
    Http2,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for VirtualGatewayPortProtocol {
    fn from(s: &str) -> Self {
        match s {
            "grpc" => VirtualGatewayPortProtocol::Grpc,
            "http" => VirtualGatewayPortProtocol::Http,
            "http2" => VirtualGatewayPortProtocol::Http2,
            other => VirtualGatewayPortProtocol::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for VirtualGatewayPortProtocol {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(VirtualGatewayPortProtocol::from(s))
    }
}
impl VirtualGatewayPortProtocol {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            VirtualGatewayPortProtocol::Grpc => "grpc",
            VirtualGatewayPortProtocol::Http => "http",
            VirtualGatewayPortProtocol::Http2 => "http2",
            VirtualGatewayPortProtocol::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["grpc", "http", "http2"]
    }
}
impl AsRef<str> for VirtualGatewayPortProtocol {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that represents the health check policy for a virtual gateway's
/// listener.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VirtualGatewayHealthCheckPolicy {
    /// <p>The amount of time to wait when receiving a response from the health check, in
    /// milliseconds.</p>
    pub timeout_millis: std::option::Option<i64>,
    /// <p>The time period in milliseconds between each health check execution.</p>
    pub interval_millis: std::option::Option<i64>,
    /// <p>The protocol for the health check request. If you specify <code>grpc</code>, then your
    /// service must conform to the <a href="https://github.com/grpc/grpc/blob/master/doc/health-checking.md">GRPC Health
    /// Checking Protocol</a>.</p>
    pub protocol: std::option::Option<crate::model::VirtualGatewayPortProtocol>,
    /// <p>The destination port for the health check request. This port must match the port defined
    /// in the <a>PortMapping</a> for the listener.</p>
    pub port: i32,
    /// <p>The destination path for the health check request. This value is only used if the
    /// specified protocol is HTTP or HTTP/2. For any other protocol, this value is ignored.</p>
    pub path: std::option::Option<std::string::String>,
    /// <p>The number of consecutive successful health checks that must occur before declaring the
    /// listener healthy.</p>
    pub healthy_threshold: i32,
    /// <p>The number of consecutive failed health checks that must occur before declaring a
    /// virtual gateway unhealthy.</p>
    pub unhealthy_threshold: i32,
}
impl VirtualGatewayHealthCheckPolicy {
    /// <p>The amount of time to wait when receiving a response from the health check, in
    /// milliseconds.</p>
    pub fn timeout_millis(&self) -> std::option::Option<i64> {
        self.timeout_millis
    }
    /// <p>The time period in milliseconds between each health check execution.</p>
    pub fn interval_millis(&self) -> std::option::Option<i64> {
        self.interval_millis
    }
    /// <p>The protocol for the health check request. If you specify <code>grpc</code>, then your
    /// service must conform to the <a href="https://github.com/grpc/grpc/blob/master/doc/health-checking.md">GRPC Health
    /// Checking Protocol</a>.</p>
    pub fn protocol(&self) -> std::option::Option<&crate::model::VirtualGatewayPortProtocol> {
        self.protocol.as_ref()
    }
    /// <p>The destination port for the health check request. This port must match the port defined
    /// in the <a>PortMapping</a> for the listener.</p>
    pub fn port(&self) -> i32 {
        self.port
    }
    /// <p>The destination path for the health check request. This value is only used if the
    /// specified protocol is HTTP or HTTP/2. For any other protocol, this value is ignored.</p>
    pub fn path(&self) -> std::option::Option<&str> {
        self.path.as_deref()
    }
    /// <p>The number of consecutive successful health checks that must occur before declaring the
    /// listener healthy.</p>
    pub fn healthy_threshold(&self) -> i32 {
        self.healthy_threshold
    }
    /// <p>The number of consecutive failed health checks that must occur before declaring a
    /// virtual gateway unhealthy.</p>
    pub fn unhealthy_threshold(&self) -> i32 {
        self.unhealthy_threshold
    }
}
impl std::fmt::Debug for VirtualGatewayHealthCheckPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VirtualGatewayHealthCheckPolicy");
        formatter.field("timeout_millis", &self.timeout_millis);
        formatter.field("interval_millis", &self.interval_millis);
        formatter.field("protocol", &self.protocol);
        formatter.field("port", &self.port);
        formatter.field("path", &self.path);
        formatter.field("healthy_threshold", &self.healthy_threshold);
        formatter.field("unhealthy_threshold", &self.unhealthy_threshold);
        formatter.finish()
    }
}
/// See [`VirtualGatewayHealthCheckPolicy`](crate::model::VirtualGatewayHealthCheckPolicy)
pub mod virtual_gateway_health_check_policy {
    /// A builder for [`VirtualGatewayHealthCheckPolicy`](crate::model::VirtualGatewayHealthCheckPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) timeout_millis: std::option::Option<i64>,
        pub(crate) interval_millis: std::option::Option<i64>,
        pub(crate) protocol: std::option::Option<crate::model::VirtualGatewayPortProtocol>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) path: std::option::Option<std::string::String>,
        pub(crate) healthy_threshold: std::option::Option<i32>,
        pub(crate) unhealthy_threshold: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The amount of time to wait when receiving a response from the health check, in
        /// milliseconds.</p>
        pub fn timeout_millis(mut self, input: i64) -> Self {
            self.timeout_millis = Some(input);
            self
        }
        /// <p>The amount of time to wait when receiving a response from the health check, in
        /// milliseconds.</p>
        pub fn set_timeout_millis(mut self, input: std::option::Option<i64>) -> Self {
            self.timeout_millis = input;
            self
        }
        /// <p>The time period in milliseconds between each health check execution.</p>
        pub fn interval_millis(mut self, input: i64) -> Self {
            self.interval_millis = Some(input);
            self
        }
        /// <p>The time period in milliseconds between each health check execution.</p>
        pub fn set_interval_millis(mut self, input: std::option::Option<i64>) -> Self {
            self.interval_millis = input;
            self
        }
        /// <p>The protocol for the health check request. If you specify <code>grpc</code>, then your
        /// service must conform to the <a href="https://github.com/grpc/grpc/blob/master/doc/health-checking.md">GRPC Health
        /// Checking Protocol</a>.</p>
        pub fn protocol(mut self, input: crate::model::VirtualGatewayPortProtocol) -> Self {
            self.protocol = Some(input);
            self
        }
        /// <p>The protocol for the health check request. If you specify <code>grpc</code>, then your
        /// service must conform to the <a href="https://github.com/grpc/grpc/blob/master/doc/health-checking.md">GRPC Health
        /// Checking Protocol</a>.</p>
        pub fn set_protocol(
            mut self,
            input: std::option::Option<crate::model::VirtualGatewayPortProtocol>,
        ) -> Self {
            self.protocol = input;
            self
        }
        /// <p>The destination port for the health check request. This port must match the port defined
        /// in the <a>PortMapping</a> for the listener.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The destination port for the health check request. This port must match the port defined
        /// in the <a>PortMapping</a> for the listener.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>The destination path for the health check request. This value is only used if the
        /// specified protocol is HTTP or HTTP/2. For any other protocol, this value is ignored.</p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p>The destination path for the health check request. This value is only used if the
        /// specified protocol is HTTP or HTTP/2. For any other protocol, this value is ignored.</p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// <p>The number of consecutive successful health checks that must occur before declaring the
        /// listener healthy.</p>
        pub fn healthy_threshold(mut self, input: i32) -> Self {
            self.healthy_threshold = Some(input);
            self
        }
        /// <p>The number of consecutive successful health checks that must occur before declaring the
        /// listener healthy.</p>
        pub fn set_healthy_threshold(mut self, input: std::option::Option<i32>) -> Self {
            self.healthy_threshold = input;
            self
        }
        /// <p>The number of consecutive failed health checks that must occur before declaring a
        /// virtual gateway unhealthy.</p>
        pub fn unhealthy_threshold(mut self, input: i32) -> Self {
            self.unhealthy_threshold = Some(input);
            self
        }
        /// <p>The number of consecutive failed health checks that must occur before declaring a
        /// virtual gateway unhealthy.</p>
        pub fn set_unhealthy_threshold(mut self, input: std::option::Option<i32>) -> Self {
            self.unhealthy_threshold = input;
            self
        }
        /// Consumes the builder and constructs a [`VirtualGatewayHealthCheckPolicy`](crate::model::VirtualGatewayHealthCheckPolicy)
        pub fn build(self) -> crate::model::VirtualGatewayHealthCheckPolicy {
            crate::model::VirtualGatewayHealthCheckPolicy {
                timeout_millis: self.timeout_millis,
                interval_millis: self.interval_millis,
                protocol: self.protocol,
                port: self.port.unwrap_or_default(),
                path: self.path,
                healthy_threshold: self.healthy_threshold.unwrap_or_default(),
                unhealthy_threshold: self.unhealthy_threshold.unwrap_or_default(),
            }
        }
    }
}
impl VirtualGatewayHealthCheckPolicy {
    /// Creates a new builder-style object to manufacture [`VirtualGatewayHealthCheckPolicy`](crate::model::VirtualGatewayHealthCheckPolicy)
    pub fn builder() -> crate::model::virtual_gateway_health_check_policy::Builder {
        crate::model::virtual_gateway_health_check_policy::Builder::default()
    }
}

/// <p>An object that represents the default properties for a backend.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VirtualGatewayBackendDefaults {
    /// <p>A reference to an object that represents a client policy.</p>
    pub client_policy: std::option::Option<crate::model::VirtualGatewayClientPolicy>,
}
impl VirtualGatewayBackendDefaults {
    /// <p>A reference to an object that represents a client policy.</p>
    pub fn client_policy(&self) -> std::option::Option<&crate::model::VirtualGatewayClientPolicy> {
        self.client_policy.as_ref()
    }
}
impl std::fmt::Debug for VirtualGatewayBackendDefaults {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VirtualGatewayBackendDefaults");
        formatter.field("client_policy", &self.client_policy);
        formatter.finish()
    }
}
/// See [`VirtualGatewayBackendDefaults`](crate::model::VirtualGatewayBackendDefaults)
pub mod virtual_gateway_backend_defaults {
    /// A builder for [`VirtualGatewayBackendDefaults`](crate::model::VirtualGatewayBackendDefaults)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_policy: std::option::Option<crate::model::VirtualGatewayClientPolicy>,
    }
    impl Builder {
        /// <p>A reference to an object that represents a client policy.</p>
        pub fn client_policy(mut self, input: crate::model::VirtualGatewayClientPolicy) -> Self {
            self.client_policy = Some(input);
            self
        }
        /// <p>A reference to an object that represents a client policy.</p>
        pub fn set_client_policy(
            mut self,
            input: std::option::Option<crate::model::VirtualGatewayClientPolicy>,
        ) -> Self {
            self.client_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`VirtualGatewayBackendDefaults`](crate::model::VirtualGatewayBackendDefaults)
        pub fn build(self) -> crate::model::VirtualGatewayBackendDefaults {
            crate::model::VirtualGatewayBackendDefaults {
                client_policy: self.client_policy,
            }
        }
    }
}
impl VirtualGatewayBackendDefaults {
    /// Creates a new builder-style object to manufacture [`VirtualGatewayBackendDefaults`](crate::model::VirtualGatewayBackendDefaults)
    pub fn builder() -> crate::model::virtual_gateway_backend_defaults::Builder {
        crate::model::virtual_gateway_backend_defaults::Builder::default()
    }
}

/// <p>An object that represents a client policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VirtualGatewayClientPolicy {
    /// <p>A reference to an object that represents a Transport Layer Security (TLS) client policy.</p>
    pub tls: std::option::Option<crate::model::VirtualGatewayClientPolicyTls>,
}
impl VirtualGatewayClientPolicy {
    /// <p>A reference to an object that represents a Transport Layer Security (TLS) client policy.</p>
    pub fn tls(&self) -> std::option::Option<&crate::model::VirtualGatewayClientPolicyTls> {
        self.tls.as_ref()
    }
}
impl std::fmt::Debug for VirtualGatewayClientPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VirtualGatewayClientPolicy");
        formatter.field("tls", &self.tls);
        formatter.finish()
    }
}
/// See [`VirtualGatewayClientPolicy`](crate::model::VirtualGatewayClientPolicy)
pub mod virtual_gateway_client_policy {
    /// A builder for [`VirtualGatewayClientPolicy`](crate::model::VirtualGatewayClientPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tls: std::option::Option<crate::model::VirtualGatewayClientPolicyTls>,
    }
    impl Builder {
        /// <p>A reference to an object that represents a Transport Layer Security (TLS) client policy.</p>
        pub fn tls(mut self, input: crate::model::VirtualGatewayClientPolicyTls) -> Self {
            self.tls = Some(input);
            self
        }
        /// <p>A reference to an object that represents a Transport Layer Security (TLS) client policy.</p>
        pub fn set_tls(
            mut self,
            input: std::option::Option<crate::model::VirtualGatewayClientPolicyTls>,
        ) -> Self {
            self.tls = input;
            self
        }
        /// Consumes the builder and constructs a [`VirtualGatewayClientPolicy`](crate::model::VirtualGatewayClientPolicy)
        pub fn build(self) -> crate::model::VirtualGatewayClientPolicy {
            crate::model::VirtualGatewayClientPolicy { tls: self.tls }
        }
    }
}
impl VirtualGatewayClientPolicy {
    /// Creates a new builder-style object to manufacture [`VirtualGatewayClientPolicy`](crate::model::VirtualGatewayClientPolicy)
    pub fn builder() -> crate::model::virtual_gateway_client_policy::Builder {
        crate::model::virtual_gateway_client_policy::Builder::default()
    }
}

/// <p>An object that represents a Transport Layer Security (TLS) client policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VirtualGatewayClientPolicyTls {
    /// <p>Whether the policy is enforced. The default is <code>True</code>, if a value isn't
    /// specified.</p>
    pub enforce: std::option::Option<bool>,
    /// <p>One or more ports that the policy is enforced for.</p>
    pub ports: std::option::Option<std::vec::Vec<i32>>,
    /// <p>A reference to an object that represents a virtual gateway's client's Transport Layer Security (TLS)
    /// certificate.</p>
    pub certificate: std::option::Option<crate::model::VirtualGatewayClientTlsCertificate>,
    /// <p>A reference to an object that represents a Transport Layer Security (TLS) validation context.</p>
    pub validation: std::option::Option<crate::model::VirtualGatewayTlsValidationContext>,
}
impl VirtualGatewayClientPolicyTls {
    /// <p>Whether the policy is enforced. The default is <code>True</code>, if a value isn't
    /// specified.</p>
    pub fn enforce(&self) -> std::option::Option<bool> {
        self.enforce
    }
    /// <p>One or more ports that the policy is enforced for.</p>
    pub fn ports(&self) -> std::option::Option<&[i32]> {
        self.ports.as_deref()
    }
    /// <p>A reference to an object that represents a virtual gateway's client's Transport Layer Security (TLS)
    /// certificate.</p>
    pub fn certificate(
        &self,
    ) -> std::option::Option<&crate::model::VirtualGatewayClientTlsCertificate> {
        self.certificate.as_ref()
    }
    /// <p>A reference to an object that represents a Transport Layer Security (TLS) validation context.</p>
    pub fn validation(
        &self,
    ) -> std::option::Option<&crate::model::VirtualGatewayTlsValidationContext> {
        self.validation.as_ref()
    }
}
impl std::fmt::Debug for VirtualGatewayClientPolicyTls {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VirtualGatewayClientPolicyTls");
        formatter.field("enforce", &self.enforce);
        formatter.field("ports", &self.ports);
        formatter.field("certificate", &self.certificate);
        formatter.field("validation", &self.validation);
        formatter.finish()
    }
}
/// See [`VirtualGatewayClientPolicyTls`](crate::model::VirtualGatewayClientPolicyTls)
pub mod virtual_gateway_client_policy_tls {
    /// A builder for [`VirtualGatewayClientPolicyTls`](crate::model::VirtualGatewayClientPolicyTls)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enforce: std::option::Option<bool>,
        pub(crate) ports: std::option::Option<std::vec::Vec<i32>>,
        pub(crate) certificate:
            std::option::Option<crate::model::VirtualGatewayClientTlsCertificate>,
        pub(crate) validation:
            std::option::Option<crate::model::VirtualGatewayTlsValidationContext>,
    }
    impl Builder {
        /// <p>Whether the policy is enforced. The default is <code>True</code>, if a value isn't
        /// specified.</p>
        pub fn enforce(mut self, input: bool) -> Self {
            self.enforce = Some(input);
            self
        }
        /// <p>Whether the policy is enforced. The default is <code>True</code>, if a value isn't
        /// specified.</p>
        pub fn set_enforce(mut self, input: std::option::Option<bool>) -> Self {
            self.enforce = input;
            self
        }
        /// Appends an item to `ports`.
        ///
        /// To override the contents of this collection use [`set_ports`](Self::set_ports).
        ///
        /// <p>One or more ports that the policy is enforced for.</p>
        pub fn ports(mut self, input: impl Into<i32>) -> Self {
            let mut v = self.ports.unwrap_or_default();
            v.push(input.into());
            self.ports = Some(v);
            self
        }
        /// <p>One or more ports that the policy is enforced for.</p>
        pub fn set_ports(mut self, input: std::option::Option<std::vec::Vec<i32>>) -> Self {
            self.ports = input;
            self
        }
        /// <p>A reference to an object that represents a virtual gateway's client's Transport Layer Security (TLS)
        /// certificate.</p>
        pub fn certificate(
            mut self,
            input: crate::model::VirtualGatewayClientTlsCertificate,
        ) -> Self {
            self.certificate = Some(input);
            self
        }
        /// <p>A reference to an object that represents a virtual gateway's client's Transport Layer Security (TLS)
        /// certificate.</p>
        pub fn set_certificate(
            mut self,
            input: std::option::Option<crate::model::VirtualGatewayClientTlsCertificate>,
        ) -> Self {
            self.certificate = input;
            self
        }
        /// <p>A reference to an object that represents a Transport Layer Security (TLS) validation context.</p>
        pub fn validation(
            mut self,
            input: crate::model::VirtualGatewayTlsValidationContext,
        ) -> Self {
            self.validation = Some(input);
            self
        }
        /// <p>A reference to an object that represents a Transport Layer Security (TLS) validation context.</p>
        pub fn set_validation(
            mut self,
            input: std::option::Option<crate::model::VirtualGatewayTlsValidationContext>,
        ) -> Self {
            self.validation = input;
            self
        }
        /// Consumes the builder and constructs a [`VirtualGatewayClientPolicyTls`](crate::model::VirtualGatewayClientPolicyTls)
        pub fn build(self) -> crate::model::VirtualGatewayClientPolicyTls {
            crate::model::VirtualGatewayClientPolicyTls {
                enforce: self.enforce,
                ports: self.ports,
                certificate: self.certificate,
                validation: self.validation,
            }
        }
    }
}
impl VirtualGatewayClientPolicyTls {
    /// Creates a new builder-style object to manufacture [`VirtualGatewayClientPolicyTls`](crate::model::VirtualGatewayClientPolicyTls)
    pub fn builder() -> crate::model::virtual_gateway_client_policy_tls::Builder {
        crate::model::virtual_gateway_client_policy_tls::Builder::default()
    }
}

/// <p>An object that represents a Transport Layer Security (TLS) validation context.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VirtualGatewayTlsValidationContext {
    /// <p>A reference to where to retrieve the trust chain when validating a peer’s Transport Layer Security (TLS)
    /// certificate.</p>
    pub trust: std::option::Option<crate::model::VirtualGatewayTlsValidationContextTrust>,
    /// <p>A reference to an object that represents the SANs for a virtual gateway's listener's
    /// Transport Layer Security (TLS) validation context.</p>
    pub subject_alternative_names: std::option::Option<crate::model::SubjectAlternativeNames>,
}
impl VirtualGatewayTlsValidationContext {
    /// <p>A reference to where to retrieve the trust chain when validating a peer’s Transport Layer Security (TLS)
    /// certificate.</p>
    pub fn trust(
        &self,
    ) -> std::option::Option<&crate::model::VirtualGatewayTlsValidationContextTrust> {
        self.trust.as_ref()
    }
    /// <p>A reference to an object that represents the SANs for a virtual gateway's listener's
    /// Transport Layer Security (TLS) validation context.</p>
    pub fn subject_alternative_names(
        &self,
    ) -> std::option::Option<&crate::model::SubjectAlternativeNames> {
        self.subject_alternative_names.as_ref()
    }
}
impl std::fmt::Debug for VirtualGatewayTlsValidationContext {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VirtualGatewayTlsValidationContext");
        formatter.field("trust", &self.trust);
        formatter.field("subject_alternative_names", &self.subject_alternative_names);
        formatter.finish()
    }
}
/// See [`VirtualGatewayTlsValidationContext`](crate::model::VirtualGatewayTlsValidationContext)
pub mod virtual_gateway_tls_validation_context {
    /// A builder for [`VirtualGatewayTlsValidationContext`](crate::model::VirtualGatewayTlsValidationContext)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trust:
            std::option::Option<crate::model::VirtualGatewayTlsValidationContextTrust>,
        pub(crate) subject_alternative_names:
            std::option::Option<crate::model::SubjectAlternativeNames>,
    }
    impl Builder {
        /// <p>A reference to where to retrieve the trust chain when validating a peer’s Transport Layer Security (TLS)
        /// certificate.</p>
        pub fn trust(
            mut self,
            input: crate::model::VirtualGatewayTlsValidationContextTrust,
        ) -> Self {
            self.trust = Some(input);
            self
        }
        /// <p>A reference to where to retrieve the trust chain when validating a peer’s Transport Layer Security (TLS)
        /// certificate.</p>
        pub fn set_trust(
            mut self,
            input: std::option::Option<crate::model::VirtualGatewayTlsValidationContextTrust>,
        ) -> Self {
            self.trust = input;
            self
        }
        /// <p>A reference to an object that represents the SANs for a virtual gateway's listener's
        /// Transport Layer Security (TLS) validation context.</p>
        pub fn subject_alternative_names(
            mut self,
            input: crate::model::SubjectAlternativeNames,
        ) -> Self {
            self.subject_alternative_names = Some(input);
            self
        }
        /// <p>A reference to an object that represents the SANs for a virtual gateway's listener's
        /// Transport Layer Security (TLS) validation context.</p>
        pub fn set_subject_alternative_names(
            mut self,
            input: std::option::Option<crate::model::SubjectAlternativeNames>,
        ) -> Self {
            self.subject_alternative_names = input;
            self
        }
        /// Consumes the builder and constructs a [`VirtualGatewayTlsValidationContext`](crate::model::VirtualGatewayTlsValidationContext)
        pub fn build(self) -> crate::model::VirtualGatewayTlsValidationContext {
            crate::model::VirtualGatewayTlsValidationContext {
                trust: self.trust,
                subject_alternative_names: self.subject_alternative_names,
            }
        }
    }
}
impl VirtualGatewayTlsValidationContext {
    /// Creates a new builder-style object to manufacture [`VirtualGatewayTlsValidationContext`](crate::model::VirtualGatewayTlsValidationContext)
    pub fn builder() -> crate::model::virtual_gateway_tls_validation_context::Builder {
        crate::model::virtual_gateway_tls_validation_context::Builder::default()
    }
}

/// <p>An object that represents a Transport Layer Security (TLS) validation context trust.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum VirtualGatewayTlsValidationContextTrust {
    /// <p>A reference to an object that represents a Transport Layer Security (TLS) validation context trust for an
    /// Certificate Manager certificate.</p>
    Acm(crate::model::VirtualGatewayTlsValidationContextAcmTrust),
    /// <p>An object that represents a Transport Layer Security (TLS) validation context trust for a local file.</p>
    File(crate::model::VirtualGatewayTlsValidationContextFileTrust),
    /// <p>A reference to an object that represents a virtual gateway's Transport Layer Security (TLS) Secret Discovery
    /// Service validation context trust.</p>
    Sds(crate::model::VirtualGatewayTlsValidationContextSdsTrust),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl VirtualGatewayTlsValidationContextTrust {
    /// Tries to convert the enum instance into [`Acm`](crate::model::VirtualGatewayTlsValidationContextTrust::Acm), extracting the inner [`VirtualGatewayTlsValidationContextAcmTrust`](crate::model::VirtualGatewayTlsValidationContextAcmTrust).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_acm(
        &self,
    ) -> std::result::Result<&crate::model::VirtualGatewayTlsValidationContextAcmTrust, &Self> {
        if let VirtualGatewayTlsValidationContextTrust::Acm(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Acm`](crate::model::VirtualGatewayTlsValidationContextTrust::Acm).
    pub fn is_acm(&self) -> bool {
        self.as_acm().is_ok()
    }
    /// Tries to convert the enum instance into [`File`](crate::model::VirtualGatewayTlsValidationContextTrust::File), extracting the inner [`VirtualGatewayTlsValidationContextFileTrust`](crate::model::VirtualGatewayTlsValidationContextFileTrust).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_file(
        &self,
    ) -> std::result::Result<&crate::model::VirtualGatewayTlsValidationContextFileTrust, &Self>
    {
        if let VirtualGatewayTlsValidationContextTrust::File(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`File`](crate::model::VirtualGatewayTlsValidationContextTrust::File).
    pub fn is_file(&self) -> bool {
        self.as_file().is_ok()
    }
    /// Tries to convert the enum instance into [`Sds`](crate::model::VirtualGatewayTlsValidationContextTrust::Sds), extracting the inner [`VirtualGatewayTlsValidationContextSdsTrust`](crate::model::VirtualGatewayTlsValidationContextSdsTrust).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_sds(
        &self,
    ) -> std::result::Result<&crate::model::VirtualGatewayTlsValidationContextSdsTrust, &Self> {
        if let VirtualGatewayTlsValidationContextTrust::Sds(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Sds`](crate::model::VirtualGatewayTlsValidationContextTrust::Sds).
    pub fn is_sds(&self) -> bool {
        self.as_sds().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

/// <p>An object that represents a Transport Layer Security (TLS) validation context trust for an Certificate Manager
/// certificate.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VirtualGatewayTlsValidationContextAcmTrust {
    /// <p>One or more ACM Amazon Resource Name (ARN)s.</p>
    pub certificate_authority_arns: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl VirtualGatewayTlsValidationContextAcmTrust {
    /// <p>One or more ACM Amazon Resource Name (ARN)s.</p>
    pub fn certificate_authority_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.certificate_authority_arns.as_deref()
    }
}
impl std::fmt::Debug for VirtualGatewayTlsValidationContextAcmTrust {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VirtualGatewayTlsValidationContextAcmTrust");
        formatter.field(
            "certificate_authority_arns",
            &self.certificate_authority_arns,
        );
        formatter.finish()
    }
}
/// See [`VirtualGatewayTlsValidationContextAcmTrust`](crate::model::VirtualGatewayTlsValidationContextAcmTrust)
pub mod virtual_gateway_tls_validation_context_acm_trust {
    /// A builder for [`VirtualGatewayTlsValidationContextAcmTrust`](crate::model::VirtualGatewayTlsValidationContextAcmTrust)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_authority_arns:
            std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `certificate_authority_arns`.
        ///
        /// To override the contents of this collection use [`set_certificate_authority_arns`](Self::set_certificate_authority_arns).
        ///
        /// <p>One or more ACM Amazon Resource Name (ARN)s.</p>
        pub fn certificate_authority_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.certificate_authority_arns.unwrap_or_default();
            v.push(input.into());
            self.certificate_authority_arns = Some(v);
            self
        }
        /// <p>One or more ACM Amazon Resource Name (ARN)s.</p>
        pub fn set_certificate_authority_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.certificate_authority_arns = input;
            self
        }
        /// Consumes the builder and constructs a [`VirtualGatewayTlsValidationContextAcmTrust`](crate::model::VirtualGatewayTlsValidationContextAcmTrust)
        pub fn build(self) -> crate::model::VirtualGatewayTlsValidationContextAcmTrust {
            crate::model::VirtualGatewayTlsValidationContextAcmTrust {
                certificate_authority_arns: self.certificate_authority_arns,
            }
        }
    }
}
impl VirtualGatewayTlsValidationContextAcmTrust {
    /// Creates a new builder-style object to manufacture [`VirtualGatewayTlsValidationContextAcmTrust`](crate::model::VirtualGatewayTlsValidationContextAcmTrust)
    pub fn builder() -> crate::model::virtual_gateway_tls_validation_context_acm_trust::Builder {
        crate::model::virtual_gateway_tls_validation_context_acm_trust::Builder::default()
    }
}

/// <p>An object that represents the virtual gateway's client's Transport Layer Security (TLS) certificate.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum VirtualGatewayClientTlsCertificate {
    /// <p>An object that represents a local file certificate. The certificate must meet specific
    /// requirements and you must have proxy authorization enabled. For more information, see
    /// <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html"> Transport Layer Security (TLS)
    /// </a>.</p>
    File(crate::model::VirtualGatewayListenerTlsFileCertificate),
    /// <p>A reference to an object that represents a virtual gateway's client's Secret Discovery
    /// Service certificate.</p>
    Sds(crate::model::VirtualGatewayListenerTlsSdsCertificate),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl VirtualGatewayClientTlsCertificate {
    /// Tries to convert the enum instance into [`File`](crate::model::VirtualGatewayClientTlsCertificate::File), extracting the inner [`VirtualGatewayListenerTlsFileCertificate`](crate::model::VirtualGatewayListenerTlsFileCertificate).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_file(
        &self,
    ) -> std::result::Result<&crate::model::VirtualGatewayListenerTlsFileCertificate, &Self> {
        if let VirtualGatewayClientTlsCertificate::File(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`File`](crate::model::VirtualGatewayClientTlsCertificate::File).
    pub fn is_file(&self) -> bool {
        self.as_file().is_ok()
    }
    /// Tries to convert the enum instance into [`Sds`](crate::model::VirtualGatewayClientTlsCertificate::Sds), extracting the inner [`VirtualGatewayListenerTlsSdsCertificate`](crate::model::VirtualGatewayListenerTlsSdsCertificate).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_sds(
        &self,
    ) -> std::result::Result<&crate::model::VirtualGatewayListenerTlsSdsCertificate, &Self> {
        if let VirtualGatewayClientTlsCertificate::Sds(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Sds`](crate::model::VirtualGatewayClientTlsCertificate::Sds).
    pub fn is_sds(&self) -> bool {
        self.as_sds().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

/// <p>An object that represents a gateway route returned by a list operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GatewayRouteRef {
    /// <p>The name of the service mesh that the resource resides in. </p>
    pub mesh_name: std::option::Option<std::string::String>,
    /// <p>The name of the gateway route.</p>
    pub gateway_route_name: std::option::Option<std::string::String>,
    /// <p>The virtual gateway that the gateway route is associated with.</p>
    pub virtual_gateway_name: std::option::Option<std::string::String>,
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
    /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub mesh_owner: std::option::Option<std::string::String>,
    /// <p>The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's
    /// the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub resource_owner: std::option::Option<std::string::String>,
    /// <p>The full Amazon Resource Name (ARN) for the gateway route.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The version of the resource. Resources are created at version 1, and this version is incremented each time that they're updated.</p>
    pub version: std::option::Option<i64>,
    /// <p>The Unix epoch timestamp in seconds for when the resource was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The Unix epoch timestamp in seconds for when the resource was last updated.</p>
    pub last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
}
impl GatewayRouteRef {
    /// <p>The name of the service mesh that the resource resides in. </p>
    pub fn mesh_name(&self) -> std::option::Option<&str> {
        self.mesh_name.as_deref()
    }
    /// <p>The name of the gateway route.</p>
    pub fn gateway_route_name(&self) -> std::option::Option<&str> {
        self.gateway_route_name.as_deref()
    }
    /// <p>The virtual gateway that the gateway route is associated with.</p>
    pub fn virtual_gateway_name(&self) -> std::option::Option<&str> {
        self.virtual_gateway_name.as_deref()
    }
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
    /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub fn mesh_owner(&self) -> std::option::Option<&str> {
        self.mesh_owner.as_deref()
    }
    /// <p>The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's
    /// the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub fn resource_owner(&self) -> std::option::Option<&str> {
        self.resource_owner.as_deref()
    }
    /// <p>The full Amazon Resource Name (ARN) for the gateway route.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The version of the resource. Resources are created at version 1, and this version is incremented each time that they're updated.</p>
    pub fn version(&self) -> std::option::Option<i64> {
        self.version
    }
    /// <p>The Unix epoch timestamp in seconds for when the resource was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The Unix epoch timestamp in seconds for when the resource was last updated.</p>
    pub fn last_updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_at.as_ref()
    }
}
impl std::fmt::Debug for GatewayRouteRef {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GatewayRouteRef");
        formatter.field("mesh_name", &self.mesh_name);
        formatter.field("gateway_route_name", &self.gateway_route_name);
        formatter.field("virtual_gateway_name", &self.virtual_gateway_name);
        formatter.field("mesh_owner", &self.mesh_owner);
        formatter.field("resource_owner", &self.resource_owner);
        formatter.field("arn", &self.arn);
        formatter.field("version", &self.version);
        formatter.field("created_at", &self.created_at);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.finish()
    }
}
/// See [`GatewayRouteRef`](crate::model::GatewayRouteRef)
pub mod gateway_route_ref {
    /// A builder for [`GatewayRouteRef`](crate::model::GatewayRouteRef)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mesh_name: std::option::Option<std::string::String>,
        pub(crate) gateway_route_name: std::option::Option<std::string::String>,
        pub(crate) virtual_gateway_name: std::option::Option<std::string::String>,
        pub(crate) mesh_owner: std::option::Option<std::string::String>,
        pub(crate) resource_owner: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<i64>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the service mesh that the resource resides in. </p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_name = Some(input.into());
            self
        }
        /// <p>The name of the service mesh that the resource resides in. </p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_name = input;
            self
        }
        /// <p>The name of the gateway route.</p>
        pub fn gateway_route_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_route_name = Some(input.into());
            self
        }
        /// <p>The name of the gateway route.</p>
        pub fn set_gateway_route_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.gateway_route_name = input;
            self
        }
        /// <p>The virtual gateway that the gateway route is associated with.</p>
        pub fn virtual_gateway_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_gateway_name = Some(input.into());
            self
        }
        /// <p>The virtual gateway that the gateway route is associated with.</p>
        pub fn set_virtual_gateway_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_gateway_name = input;
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_owner = Some(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_owner = input;
            self
        }
        /// <p>The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's
        /// the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn resource_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_owner = Some(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's
        /// the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_resource_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_owner = input;
            self
        }
        /// <p>The full Amazon Resource Name (ARN) for the gateway route.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The full Amazon Resource Name (ARN) for the gateway route.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The version of the resource. Resources are created at version 1, and this version is incremented each time that they're updated.</p>
        pub fn version(mut self, input: i64) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>The version of the resource. Resources are created at version 1, and this version is incremented each time that they're updated.</p>
        pub fn set_version(mut self, input: std::option::Option<i64>) -> Self {
            self.version = input;
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the resource was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the resource was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the resource was last updated.</p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the resource was last updated.</p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// Consumes the builder and constructs a [`GatewayRouteRef`](crate::model::GatewayRouteRef)
        pub fn build(self) -> crate::model::GatewayRouteRef {
            crate::model::GatewayRouteRef {
                mesh_name: self.mesh_name,
                gateway_route_name: self.gateway_route_name,
                virtual_gateway_name: self.virtual_gateway_name,
                mesh_owner: self.mesh_owner,
                resource_owner: self.resource_owner,
                arn: self.arn,
                version: self.version,
                created_at: self.created_at,
                last_updated_at: self.last_updated_at,
            }
        }
    }
}
impl GatewayRouteRef {
    /// Creates a new builder-style object to manufacture [`GatewayRouteRef`](crate::model::GatewayRouteRef)
    pub fn builder() -> crate::model::gateway_route_ref::Builder {
        crate::model::gateway_route_ref::Builder::default()
    }
}

/// <p>An object that represents a gateway route returned by a describe operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GatewayRouteData {
    /// <p>The name of the service mesh that the resource resides in. </p>
    pub mesh_name: std::option::Option<std::string::String>,
    /// <p>The name of the gateway route.</p>
    pub gateway_route_name: std::option::Option<std::string::String>,
    /// <p>The virtual gateway that the gateway route is associated with.</p>
    pub virtual_gateway_name: std::option::Option<std::string::String>,
    /// <p>The specifications of the gateway route.</p>
    pub spec: std::option::Option<crate::model::GatewayRouteSpec>,
    /// <p>An object that represents metadata for a resource.</p>
    pub metadata: std::option::Option<crate::model::ResourceMetadata>,
    /// <p>The status of the gateway route.</p>
    pub status: std::option::Option<crate::model::GatewayRouteStatus>,
}
impl GatewayRouteData {
    /// <p>The name of the service mesh that the resource resides in. </p>
    pub fn mesh_name(&self) -> std::option::Option<&str> {
        self.mesh_name.as_deref()
    }
    /// <p>The name of the gateway route.</p>
    pub fn gateway_route_name(&self) -> std::option::Option<&str> {
        self.gateway_route_name.as_deref()
    }
    /// <p>The virtual gateway that the gateway route is associated with.</p>
    pub fn virtual_gateway_name(&self) -> std::option::Option<&str> {
        self.virtual_gateway_name.as_deref()
    }
    /// <p>The specifications of the gateway route.</p>
    pub fn spec(&self) -> std::option::Option<&crate::model::GatewayRouteSpec> {
        self.spec.as_ref()
    }
    /// <p>An object that represents metadata for a resource.</p>
    pub fn metadata(&self) -> std::option::Option<&crate::model::ResourceMetadata> {
        self.metadata.as_ref()
    }
    /// <p>The status of the gateway route.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::GatewayRouteStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for GatewayRouteData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GatewayRouteData");
        formatter.field("mesh_name", &self.mesh_name);
        formatter.field("gateway_route_name", &self.gateway_route_name);
        formatter.field("virtual_gateway_name", &self.virtual_gateway_name);
        formatter.field("spec", &self.spec);
        formatter.field("metadata", &self.metadata);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`GatewayRouteData`](crate::model::GatewayRouteData)
pub mod gateway_route_data {
    /// A builder for [`GatewayRouteData`](crate::model::GatewayRouteData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mesh_name: std::option::Option<std::string::String>,
        pub(crate) gateway_route_name: std::option::Option<std::string::String>,
        pub(crate) virtual_gateway_name: std::option::Option<std::string::String>,
        pub(crate) spec: std::option::Option<crate::model::GatewayRouteSpec>,
        pub(crate) metadata: std::option::Option<crate::model::ResourceMetadata>,
        pub(crate) status: std::option::Option<crate::model::GatewayRouteStatus>,
    }
    impl Builder {
        /// <p>The name of the service mesh that the resource resides in. </p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_name = Some(input.into());
            self
        }
        /// <p>The name of the service mesh that the resource resides in. </p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_name = input;
            self
        }
        /// <p>The name of the gateway route.</p>
        pub fn gateway_route_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_route_name = Some(input.into());
            self
        }
        /// <p>The name of the gateway route.</p>
        pub fn set_gateway_route_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.gateway_route_name = input;
            self
        }
        /// <p>The virtual gateway that the gateway route is associated with.</p>
        pub fn virtual_gateway_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_gateway_name = Some(input.into());
            self
        }
        /// <p>The virtual gateway that the gateway route is associated with.</p>
        pub fn set_virtual_gateway_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_gateway_name = input;
            self
        }
        /// <p>The specifications of the gateway route.</p>
        pub fn spec(mut self, input: crate::model::GatewayRouteSpec) -> Self {
            self.spec = Some(input);
            self
        }
        /// <p>The specifications of the gateway route.</p>
        pub fn set_spec(
            mut self,
            input: std::option::Option<crate::model::GatewayRouteSpec>,
        ) -> Self {
            self.spec = input;
            self
        }
        /// <p>An object that represents metadata for a resource.</p>
        pub fn metadata(mut self, input: crate::model::ResourceMetadata) -> Self {
            self.metadata = Some(input);
            self
        }
        /// <p>An object that represents metadata for a resource.</p>
        pub fn set_metadata(
            mut self,
            input: std::option::Option<crate::model::ResourceMetadata>,
        ) -> Self {
            self.metadata = input;
            self
        }
        /// <p>The status of the gateway route.</p>
        pub fn status(mut self, input: crate::model::GatewayRouteStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the gateway route.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::GatewayRouteStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`GatewayRouteData`](crate::model::GatewayRouteData)
        pub fn build(self) -> crate::model::GatewayRouteData {
            crate::model::GatewayRouteData {
                mesh_name: self.mesh_name,
                gateway_route_name: self.gateway_route_name,
                virtual_gateway_name: self.virtual_gateway_name,
                spec: self.spec,
                metadata: self.metadata,
                status: self.status,
            }
        }
    }
}
impl GatewayRouteData {
    /// Creates a new builder-style object to manufacture [`GatewayRouteData`](crate::model::GatewayRouteData)
    pub fn builder() -> crate::model::gateway_route_data::Builder {
        crate::model::gateway_route_data::Builder::default()
    }
}

/// <p>An object that represents the current status of a gateway route.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GatewayRouteStatus {
    /// <p>The current status for the gateway route.</p>
    pub status: std::option::Option<crate::model::GatewayRouteStatusCode>,
}
impl GatewayRouteStatus {
    /// <p>The current status for the gateway route.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::GatewayRouteStatusCode> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for GatewayRouteStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GatewayRouteStatus");
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`GatewayRouteStatus`](crate::model::GatewayRouteStatus)
pub mod gateway_route_status {
    /// A builder for [`GatewayRouteStatus`](crate::model::GatewayRouteStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::GatewayRouteStatusCode>,
    }
    impl Builder {
        /// <p>The current status for the gateway route.</p>
        pub fn status(mut self, input: crate::model::GatewayRouteStatusCode) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status for the gateway route.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::GatewayRouteStatusCode>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`GatewayRouteStatus`](crate::model::GatewayRouteStatus)
        pub fn build(self) -> crate::model::GatewayRouteStatus {
            crate::model::GatewayRouteStatus {
                status: self.status,
            }
        }
    }
}
impl GatewayRouteStatus {
    /// Creates a new builder-style object to manufacture [`GatewayRouteStatus`](crate::model::GatewayRouteStatus)
    pub fn builder() -> crate::model::gateway_route_status::Builder {
        crate::model::gateway_route_status::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum GatewayRouteStatusCode {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Inactive,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for GatewayRouteStatusCode {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => GatewayRouteStatusCode::Active,
            "DELETED" => GatewayRouteStatusCode::Deleted,
            "INACTIVE" => GatewayRouteStatusCode::Inactive,
            other => GatewayRouteStatusCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for GatewayRouteStatusCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(GatewayRouteStatusCode::from(s))
    }
}
impl GatewayRouteStatusCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            GatewayRouteStatusCode::Active => "ACTIVE",
            GatewayRouteStatusCode::Deleted => "DELETED",
            GatewayRouteStatusCode::Inactive => "INACTIVE",
            GatewayRouteStatusCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "DELETED", "INACTIVE"]
    }
}
impl AsRef<str> for GatewayRouteStatusCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that represents a gateway route specification. Specify one gateway route
/// type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GatewayRouteSpec {
    /// <p>The ordering of the gateway routes spec.</p>
    pub priority: std::option::Option<i32>,
    /// <p>An object that represents the specification of an HTTP gateway route.</p>
    pub http_route: std::option::Option<crate::model::HttpGatewayRoute>,
    /// <p>An object that represents the specification of an HTTP/2 gateway route.</p>
    pub http2_route: std::option::Option<crate::model::HttpGatewayRoute>,
    /// <p>An object that represents the specification of a gRPC gateway route.</p>
    pub grpc_route: std::option::Option<crate::model::GrpcGatewayRoute>,
}
impl GatewayRouteSpec {
    /// <p>The ordering of the gateway routes spec.</p>
    pub fn priority(&self) -> std::option::Option<i32> {
        self.priority
    }
    /// <p>An object that represents the specification of an HTTP gateway route.</p>
    pub fn http_route(&self) -> std::option::Option<&crate::model::HttpGatewayRoute> {
        self.http_route.as_ref()
    }
    /// <p>An object that represents the specification of an HTTP/2 gateway route.</p>
    pub fn http2_route(&self) -> std::option::Option<&crate::model::HttpGatewayRoute> {
        self.http2_route.as_ref()
    }
    /// <p>An object that represents the specification of a gRPC gateway route.</p>
    pub fn grpc_route(&self) -> std::option::Option<&crate::model::GrpcGatewayRoute> {
        self.grpc_route.as_ref()
    }
}
impl std::fmt::Debug for GatewayRouteSpec {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GatewayRouteSpec");
        formatter.field("priority", &self.priority);
        formatter.field("http_route", &self.http_route);
        formatter.field("http2_route", &self.http2_route);
        formatter.field("grpc_route", &self.grpc_route);
        formatter.finish()
    }
}
/// See [`GatewayRouteSpec`](crate::model::GatewayRouteSpec)
pub mod gateway_route_spec {
    /// A builder for [`GatewayRouteSpec`](crate::model::GatewayRouteSpec)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) priority: std::option::Option<i32>,
        pub(crate) http_route: std::option::Option<crate::model::HttpGatewayRoute>,
        pub(crate) http2_route: std::option::Option<crate::model::HttpGatewayRoute>,
        pub(crate) grpc_route: std::option::Option<crate::model::GrpcGatewayRoute>,
    }
    impl Builder {
        /// <p>The ordering of the gateway routes spec.</p>
        pub fn priority(mut self, input: i32) -> Self {
            self.priority = Some(input);
            self
        }
        /// <p>The ordering of the gateway routes spec.</p>
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.priority = input;
            self
        }
        /// <p>An object that represents the specification of an HTTP gateway route.</p>
        pub fn http_route(mut self, input: crate::model::HttpGatewayRoute) -> Self {
            self.http_route = Some(input);
            self
        }
        /// <p>An object that represents the specification of an HTTP gateway route.</p>
        pub fn set_http_route(
            mut self,
            input: std::option::Option<crate::model::HttpGatewayRoute>,
        ) -> Self {
            self.http_route = input;
            self
        }
        /// <p>An object that represents the specification of an HTTP/2 gateway route.</p>
        pub fn http2_route(mut self, input: crate::model::HttpGatewayRoute) -> Self {
            self.http2_route = Some(input);
            self
        }
        /// <p>An object that represents the specification of an HTTP/2 gateway route.</p>
        pub fn set_http2_route(
            mut self,
            input: std::option::Option<crate::model::HttpGatewayRoute>,
        ) -> Self {
            self.http2_route = input;
            self
        }
        /// <p>An object that represents the specification of a gRPC gateway route.</p>
        pub fn grpc_route(mut self, input: crate::model::GrpcGatewayRoute) -> Self {
            self.grpc_route = Some(input);
            self
        }
        /// <p>An object that represents the specification of a gRPC gateway route.</p>
        pub fn set_grpc_route(
            mut self,
            input: std::option::Option<crate::model::GrpcGatewayRoute>,
        ) -> Self {
            self.grpc_route = input;
            self
        }
        /// Consumes the builder and constructs a [`GatewayRouteSpec`](crate::model::GatewayRouteSpec)
        pub fn build(self) -> crate::model::GatewayRouteSpec {
            crate::model::GatewayRouteSpec {
                priority: self.priority,
                http_route: self.http_route,
                http2_route: self.http2_route,
                grpc_route: self.grpc_route,
            }
        }
    }
}
impl GatewayRouteSpec {
    /// Creates a new builder-style object to manufacture [`GatewayRouteSpec`](crate::model::GatewayRouteSpec)
    pub fn builder() -> crate::model::gateway_route_spec::Builder {
        crate::model::gateway_route_spec::Builder::default()
    }
}

/// <p>An object that represents a gRPC gateway route.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GrpcGatewayRoute {
    /// <p>An object that represents the criteria for determining a request match.</p>
    pub r#match: std::option::Option<crate::model::GrpcGatewayRouteMatch>,
    /// <p>An object that represents the action to take if a match is determined.</p>
    pub action: std::option::Option<crate::model::GrpcGatewayRouteAction>,
}
impl GrpcGatewayRoute {
    /// <p>An object that represents the criteria for determining a request match.</p>
    pub fn r#match(&self) -> std::option::Option<&crate::model::GrpcGatewayRouteMatch> {
        self.r#match.as_ref()
    }
    /// <p>An object that represents the action to take if a match is determined.</p>
    pub fn action(&self) -> std::option::Option<&crate::model::GrpcGatewayRouteAction> {
        self.action.as_ref()
    }
}
impl std::fmt::Debug for GrpcGatewayRoute {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GrpcGatewayRoute");
        formatter.field("r#match", &self.r#match);
        formatter.field("action", &self.action);
        formatter.finish()
    }
}
/// See [`GrpcGatewayRoute`](crate::model::GrpcGatewayRoute)
pub mod grpc_gateway_route {
    /// A builder for [`GrpcGatewayRoute`](crate::model::GrpcGatewayRoute)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#match: std::option::Option<crate::model::GrpcGatewayRouteMatch>,
        pub(crate) action: std::option::Option<crate::model::GrpcGatewayRouteAction>,
    }
    impl Builder {
        /// <p>An object that represents the criteria for determining a request match.</p>
        pub fn r#match(mut self, input: crate::model::GrpcGatewayRouteMatch) -> Self {
            self.r#match = Some(input);
            self
        }
        /// <p>An object that represents the criteria for determining a request match.</p>
        pub fn set_match(
            mut self,
            input: std::option::Option<crate::model::GrpcGatewayRouteMatch>,
        ) -> Self {
            self.r#match = input;
            self
        }
        /// <p>An object that represents the action to take if a match is determined.</p>
        pub fn action(mut self, input: crate::model::GrpcGatewayRouteAction) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>An object that represents the action to take if a match is determined.</p>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::GrpcGatewayRouteAction>,
        ) -> Self {
            self.action = input;
            self
        }
        /// Consumes the builder and constructs a [`GrpcGatewayRoute`](crate::model::GrpcGatewayRoute)
        pub fn build(self) -> crate::model::GrpcGatewayRoute {
            crate::model::GrpcGatewayRoute {
                r#match: self.r#match,
                action: self.action,
            }
        }
    }
}
impl GrpcGatewayRoute {
    /// Creates a new builder-style object to manufacture [`GrpcGatewayRoute`](crate::model::GrpcGatewayRoute)
    pub fn builder() -> crate::model::grpc_gateway_route::Builder {
        crate::model::grpc_gateway_route::Builder::default()
    }
}

/// <p>An object that represents the action to take if a match is determined.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GrpcGatewayRouteAction {
    /// <p>An object that represents the target that traffic is routed to when a request matches the gateway route.</p>
    pub target: std::option::Option<crate::model::GatewayRouteTarget>,
    /// <p>The gateway route action to rewrite.</p>
    pub rewrite: std::option::Option<crate::model::GrpcGatewayRouteRewrite>,
}
impl GrpcGatewayRouteAction {
    /// <p>An object that represents the target that traffic is routed to when a request matches the gateway route.</p>
    pub fn target(&self) -> std::option::Option<&crate::model::GatewayRouteTarget> {
        self.target.as_ref()
    }
    /// <p>The gateway route action to rewrite.</p>
    pub fn rewrite(&self) -> std::option::Option<&crate::model::GrpcGatewayRouteRewrite> {
        self.rewrite.as_ref()
    }
}
impl std::fmt::Debug for GrpcGatewayRouteAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GrpcGatewayRouteAction");
        formatter.field("target", &self.target);
        formatter.field("rewrite", &self.rewrite);
        formatter.finish()
    }
}
/// See [`GrpcGatewayRouteAction`](crate::model::GrpcGatewayRouteAction)
pub mod grpc_gateway_route_action {
    /// A builder for [`GrpcGatewayRouteAction`](crate::model::GrpcGatewayRouteAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target: std::option::Option<crate::model::GatewayRouteTarget>,
        pub(crate) rewrite: std::option::Option<crate::model::GrpcGatewayRouteRewrite>,
    }
    impl Builder {
        /// <p>An object that represents the target that traffic is routed to when a request matches the gateway route.</p>
        pub fn target(mut self, input: crate::model::GatewayRouteTarget) -> Self {
            self.target = Some(input);
            self
        }
        /// <p>An object that represents the target that traffic is routed to when a request matches the gateway route.</p>
        pub fn set_target(
            mut self,
            input: std::option::Option<crate::model::GatewayRouteTarget>,
        ) -> Self {
            self.target = input;
            self
        }
        /// <p>The gateway route action to rewrite.</p>
        pub fn rewrite(mut self, input: crate::model::GrpcGatewayRouteRewrite) -> Self {
            self.rewrite = Some(input);
            self
        }
        /// <p>The gateway route action to rewrite.</p>
        pub fn set_rewrite(
            mut self,
            input: std::option::Option<crate::model::GrpcGatewayRouteRewrite>,
        ) -> Self {
            self.rewrite = input;
            self
        }
        /// Consumes the builder and constructs a [`GrpcGatewayRouteAction`](crate::model::GrpcGatewayRouteAction)
        pub fn build(self) -> crate::model::GrpcGatewayRouteAction {
            crate::model::GrpcGatewayRouteAction {
                target: self.target,
                rewrite: self.rewrite,
            }
        }
    }
}
impl GrpcGatewayRouteAction {
    /// Creates a new builder-style object to manufacture [`GrpcGatewayRouteAction`](crate::model::GrpcGatewayRouteAction)
    pub fn builder() -> crate::model::grpc_gateway_route_action::Builder {
        crate::model::grpc_gateway_route_action::Builder::default()
    }
}

/// <p>An object that represents the gateway route to rewrite.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GrpcGatewayRouteRewrite {
    /// <p>The host name of the gateway route to rewrite.</p>
    pub hostname: std::option::Option<crate::model::GatewayRouteHostnameRewrite>,
}
impl GrpcGatewayRouteRewrite {
    /// <p>The host name of the gateway route to rewrite.</p>
    pub fn hostname(&self) -> std::option::Option<&crate::model::GatewayRouteHostnameRewrite> {
        self.hostname.as_ref()
    }
}
impl std::fmt::Debug for GrpcGatewayRouteRewrite {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GrpcGatewayRouteRewrite");
        formatter.field("hostname", &self.hostname);
        formatter.finish()
    }
}
/// See [`GrpcGatewayRouteRewrite`](crate::model::GrpcGatewayRouteRewrite)
pub mod grpc_gateway_route_rewrite {
    /// A builder for [`GrpcGatewayRouteRewrite`](crate::model::GrpcGatewayRouteRewrite)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hostname: std::option::Option<crate::model::GatewayRouteHostnameRewrite>,
    }
    impl Builder {
        /// <p>The host name of the gateway route to rewrite.</p>
        pub fn hostname(mut self, input: crate::model::GatewayRouteHostnameRewrite) -> Self {
            self.hostname = Some(input);
            self
        }
        /// <p>The host name of the gateway route to rewrite.</p>
        pub fn set_hostname(
            mut self,
            input: std::option::Option<crate::model::GatewayRouteHostnameRewrite>,
        ) -> Self {
            self.hostname = input;
            self
        }
        /// Consumes the builder and constructs a [`GrpcGatewayRouteRewrite`](crate::model::GrpcGatewayRouteRewrite)
        pub fn build(self) -> crate::model::GrpcGatewayRouteRewrite {
            crate::model::GrpcGatewayRouteRewrite {
                hostname: self.hostname,
            }
        }
    }
}
impl GrpcGatewayRouteRewrite {
    /// Creates a new builder-style object to manufacture [`GrpcGatewayRouteRewrite`](crate::model::GrpcGatewayRouteRewrite)
    pub fn builder() -> crate::model::grpc_gateway_route_rewrite::Builder {
        crate::model::grpc_gateway_route_rewrite::Builder::default()
    }
}

/// <p>An object representing the gateway route host name to rewrite.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GatewayRouteHostnameRewrite {
    /// <p>The default target host name to write to.</p>
    pub default_target_hostname: std::option::Option<crate::model::DefaultGatewayRouteRewrite>,
}
impl GatewayRouteHostnameRewrite {
    /// <p>The default target host name to write to.</p>
    pub fn default_target_hostname(
        &self,
    ) -> std::option::Option<&crate::model::DefaultGatewayRouteRewrite> {
        self.default_target_hostname.as_ref()
    }
}
impl std::fmt::Debug for GatewayRouteHostnameRewrite {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GatewayRouteHostnameRewrite");
        formatter.field("default_target_hostname", &self.default_target_hostname);
        formatter.finish()
    }
}
/// See [`GatewayRouteHostnameRewrite`](crate::model::GatewayRouteHostnameRewrite)
pub mod gateway_route_hostname_rewrite {
    /// A builder for [`GatewayRouteHostnameRewrite`](crate::model::GatewayRouteHostnameRewrite)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) default_target_hostname:
            std::option::Option<crate::model::DefaultGatewayRouteRewrite>,
    }
    impl Builder {
        /// <p>The default target host name to write to.</p>
        pub fn default_target_hostname(
            mut self,
            input: crate::model::DefaultGatewayRouteRewrite,
        ) -> Self {
            self.default_target_hostname = Some(input);
            self
        }
        /// <p>The default target host name to write to.</p>
        pub fn set_default_target_hostname(
            mut self,
            input: std::option::Option<crate::model::DefaultGatewayRouteRewrite>,
        ) -> Self {
            self.default_target_hostname = input;
            self
        }
        /// Consumes the builder and constructs a [`GatewayRouteHostnameRewrite`](crate::model::GatewayRouteHostnameRewrite)
        pub fn build(self) -> crate::model::GatewayRouteHostnameRewrite {
            crate::model::GatewayRouteHostnameRewrite {
                default_target_hostname: self.default_target_hostname,
            }
        }
    }
}
impl GatewayRouteHostnameRewrite {
    /// Creates a new builder-style object to manufacture [`GatewayRouteHostnameRewrite`](crate::model::GatewayRouteHostnameRewrite)
    pub fn builder() -> crate::model::gateway_route_hostname_rewrite::Builder {
        crate::model::gateway_route_hostname_rewrite::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DefaultGatewayRouteRewrite {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DefaultGatewayRouteRewrite {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => DefaultGatewayRouteRewrite::Disabled,
            "ENABLED" => DefaultGatewayRouteRewrite::Enabled,
            other => DefaultGatewayRouteRewrite::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DefaultGatewayRouteRewrite {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DefaultGatewayRouteRewrite::from(s))
    }
}
impl DefaultGatewayRouteRewrite {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DefaultGatewayRouteRewrite::Disabled => "DISABLED",
            DefaultGatewayRouteRewrite::Enabled => "ENABLED",
            DefaultGatewayRouteRewrite::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for DefaultGatewayRouteRewrite {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that represents a gateway route target.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GatewayRouteTarget {
    /// <p>An object that represents a virtual service gateway route target.</p>
    pub virtual_service: std::option::Option<crate::model::GatewayRouteVirtualService>,
}
impl GatewayRouteTarget {
    /// <p>An object that represents a virtual service gateway route target.</p>
    pub fn virtual_service(
        &self,
    ) -> std::option::Option<&crate::model::GatewayRouteVirtualService> {
        self.virtual_service.as_ref()
    }
}
impl std::fmt::Debug for GatewayRouteTarget {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GatewayRouteTarget");
        formatter.field("virtual_service", &self.virtual_service);
        formatter.finish()
    }
}
/// See [`GatewayRouteTarget`](crate::model::GatewayRouteTarget)
pub mod gateway_route_target {
    /// A builder for [`GatewayRouteTarget`](crate::model::GatewayRouteTarget)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_service: std::option::Option<crate::model::GatewayRouteVirtualService>,
    }
    impl Builder {
        /// <p>An object that represents a virtual service gateway route target.</p>
        pub fn virtual_service(mut self, input: crate::model::GatewayRouteVirtualService) -> Self {
            self.virtual_service = Some(input);
            self
        }
        /// <p>An object that represents a virtual service gateway route target.</p>
        pub fn set_virtual_service(
            mut self,
            input: std::option::Option<crate::model::GatewayRouteVirtualService>,
        ) -> Self {
            self.virtual_service = input;
            self
        }
        /// Consumes the builder and constructs a [`GatewayRouteTarget`](crate::model::GatewayRouteTarget)
        pub fn build(self) -> crate::model::GatewayRouteTarget {
            crate::model::GatewayRouteTarget {
                virtual_service: self.virtual_service,
            }
        }
    }
}
impl GatewayRouteTarget {
    /// Creates a new builder-style object to manufacture [`GatewayRouteTarget`](crate::model::GatewayRouteTarget)
    pub fn builder() -> crate::model::gateway_route_target::Builder {
        crate::model::gateway_route_target::Builder::default()
    }
}

/// <p>An object that represents the virtual service that traffic is routed to.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GatewayRouteVirtualService {
    /// <p>The name of the virtual service that traffic is routed to.</p>
    pub virtual_service_name: std::option::Option<std::string::String>,
}
impl GatewayRouteVirtualService {
    /// <p>The name of the virtual service that traffic is routed to.</p>
    pub fn virtual_service_name(&self) -> std::option::Option<&str> {
        self.virtual_service_name.as_deref()
    }
}
impl std::fmt::Debug for GatewayRouteVirtualService {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GatewayRouteVirtualService");
        formatter.field("virtual_service_name", &self.virtual_service_name);
        formatter.finish()
    }
}
/// See [`GatewayRouteVirtualService`](crate::model::GatewayRouteVirtualService)
pub mod gateway_route_virtual_service {
    /// A builder for [`GatewayRouteVirtualService`](crate::model::GatewayRouteVirtualService)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_service_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the virtual service that traffic is routed to.</p>
        pub fn virtual_service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_service_name = Some(input.into());
            self
        }
        /// <p>The name of the virtual service that traffic is routed to.</p>
        pub fn set_virtual_service_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_service_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GatewayRouteVirtualService`](crate::model::GatewayRouteVirtualService)
        pub fn build(self) -> crate::model::GatewayRouteVirtualService {
            crate::model::GatewayRouteVirtualService {
                virtual_service_name: self.virtual_service_name,
            }
        }
    }
}
impl GatewayRouteVirtualService {
    /// Creates a new builder-style object to manufacture [`GatewayRouteVirtualService`](crate::model::GatewayRouteVirtualService)
    pub fn builder() -> crate::model::gateway_route_virtual_service::Builder {
        crate::model::gateway_route_virtual_service::Builder::default()
    }
}

/// <p>An object that represents the criteria for determining a request match.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GrpcGatewayRouteMatch {
    /// <p>The fully qualified domain name for the service to match from the request.</p>
    pub service_name: std::option::Option<std::string::String>,
    /// <p>The gateway route host name to be matched on.</p>
    pub hostname: std::option::Option<crate::model::GatewayRouteHostnameMatch>,
    /// <p>The gateway route metadata to be matched on.</p>
    pub metadata: std::option::Option<std::vec::Vec<crate::model::GrpcGatewayRouteMetadata>>,
}
impl GrpcGatewayRouteMatch {
    /// <p>The fully qualified domain name for the service to match from the request.</p>
    pub fn service_name(&self) -> std::option::Option<&str> {
        self.service_name.as_deref()
    }
    /// <p>The gateway route host name to be matched on.</p>
    pub fn hostname(&self) -> std::option::Option<&crate::model::GatewayRouteHostnameMatch> {
        self.hostname.as_ref()
    }
    /// <p>The gateway route metadata to be matched on.</p>
    pub fn metadata(&self) -> std::option::Option<&[crate::model::GrpcGatewayRouteMetadata]> {
        self.metadata.as_deref()
    }
}
impl std::fmt::Debug for GrpcGatewayRouteMatch {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GrpcGatewayRouteMatch");
        formatter.field("service_name", &self.service_name);
        formatter.field("hostname", &self.hostname);
        formatter.field("metadata", &self.metadata);
        formatter.finish()
    }
}
/// See [`GrpcGatewayRouteMatch`](crate::model::GrpcGatewayRouteMatch)
pub mod grpc_gateway_route_match {
    /// A builder for [`GrpcGatewayRouteMatch`](crate::model::GrpcGatewayRouteMatch)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_name: std::option::Option<std::string::String>,
        pub(crate) hostname: std::option::Option<crate::model::GatewayRouteHostnameMatch>,
        pub(crate) metadata:
            std::option::Option<std::vec::Vec<crate::model::GrpcGatewayRouteMetadata>>,
    }
    impl Builder {
        /// <p>The fully qualified domain name for the service to match from the request.</p>
        pub fn service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_name = Some(input.into());
            self
        }
        /// <p>The fully qualified domain name for the service to match from the request.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_name = input;
            self
        }
        /// <p>The gateway route host name to be matched on.</p>
        pub fn hostname(mut self, input: crate::model::GatewayRouteHostnameMatch) -> Self {
            self.hostname = Some(input);
            self
        }
        /// <p>The gateway route host name to be matched on.</p>
        pub fn set_hostname(
            mut self,
            input: std::option::Option<crate::model::GatewayRouteHostnameMatch>,
        ) -> Self {
            self.hostname = input;
            self
        }
        /// Appends an item to `metadata`.
        ///
        /// To override the contents of this collection use [`set_metadata`](Self::set_metadata).
        ///
        /// <p>The gateway route metadata to be matched on.</p>
        pub fn metadata(
            mut self,
            input: impl Into<crate::model::GrpcGatewayRouteMetadata>,
        ) -> Self {
            let mut v = self.metadata.unwrap_or_default();
            v.push(input.into());
            self.metadata = Some(v);
            self
        }
        /// <p>The gateway route metadata to be matched on.</p>
        pub fn set_metadata(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GrpcGatewayRouteMetadata>>,
        ) -> Self {
            self.metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`GrpcGatewayRouteMatch`](crate::model::GrpcGatewayRouteMatch)
        pub fn build(self) -> crate::model::GrpcGatewayRouteMatch {
            crate::model::GrpcGatewayRouteMatch {
                service_name: self.service_name,
                hostname: self.hostname,
                metadata: self.metadata,
            }
        }
    }
}
impl GrpcGatewayRouteMatch {
    /// Creates a new builder-style object to manufacture [`GrpcGatewayRouteMatch`](crate::model::GrpcGatewayRouteMatch)
    pub fn builder() -> crate::model::grpc_gateway_route_match::Builder {
        crate::model::grpc_gateway_route_match::Builder::default()
    }
}

/// <p>An object representing the metadata of the gateway route.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GrpcGatewayRouteMetadata {
    /// <p>A name for the gateway route metadata.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Specify <code>True</code> to match anything except the match criteria. The default value is <code>False</code>.</p>
    pub invert: std::option::Option<bool>,
    /// <p>The criteria for determining a metadata match.</p>
    pub r#match: std::option::Option<crate::model::GrpcMetadataMatchMethod>,
}
impl GrpcGatewayRouteMetadata {
    /// <p>A name for the gateway route metadata.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Specify <code>True</code> to match anything except the match criteria. The default value is <code>False</code>.</p>
    pub fn invert(&self) -> std::option::Option<bool> {
        self.invert
    }
    /// <p>The criteria for determining a metadata match.</p>
    pub fn r#match(&self) -> std::option::Option<&crate::model::GrpcMetadataMatchMethod> {
        self.r#match.as_ref()
    }
}
impl std::fmt::Debug for GrpcGatewayRouteMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GrpcGatewayRouteMetadata");
        formatter.field("name", &self.name);
        formatter.field("invert", &self.invert);
        formatter.field("r#match", &self.r#match);
        formatter.finish()
    }
}
/// See [`GrpcGatewayRouteMetadata`](crate::model::GrpcGatewayRouteMetadata)
pub mod grpc_gateway_route_metadata {
    /// A builder for [`GrpcGatewayRouteMetadata`](crate::model::GrpcGatewayRouteMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) invert: std::option::Option<bool>,
        pub(crate) r#match: std::option::Option<crate::model::GrpcMetadataMatchMethod>,
    }
    impl Builder {
        /// <p>A name for the gateway route metadata.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A name for the gateway route metadata.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Specify <code>True</code> to match anything except the match criteria. The default value is <code>False</code>.</p>
        pub fn invert(mut self, input: bool) -> Self {
            self.invert = Some(input);
            self
        }
        /// <p>Specify <code>True</code> to match anything except the match criteria. The default value is <code>False</code>.</p>
        pub fn set_invert(mut self, input: std::option::Option<bool>) -> Self {
            self.invert = input;
            self
        }
        /// <p>The criteria for determining a metadata match.</p>
        pub fn r#match(mut self, input: crate::model::GrpcMetadataMatchMethod) -> Self {
            self.r#match = Some(input);
            self
        }
        /// <p>The criteria for determining a metadata match.</p>
        pub fn set_match(
            mut self,
            input: std::option::Option<crate::model::GrpcMetadataMatchMethod>,
        ) -> Self {
            self.r#match = input;
            self
        }
        /// Consumes the builder and constructs a [`GrpcGatewayRouteMetadata`](crate::model::GrpcGatewayRouteMetadata)
        pub fn build(self) -> crate::model::GrpcGatewayRouteMetadata {
            crate::model::GrpcGatewayRouteMetadata {
                name: self.name,
                invert: self.invert,
                r#match: self.r#match,
            }
        }
    }
}
impl GrpcGatewayRouteMetadata {
    /// Creates a new builder-style object to manufacture [`GrpcGatewayRouteMetadata`](crate::model::GrpcGatewayRouteMetadata)
    pub fn builder() -> crate::model::grpc_gateway_route_metadata::Builder {
        crate::model::grpc_gateway_route_metadata::Builder::default()
    }
}

/// <p>An object representing the method header to be matched.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum GrpcMetadataMatchMethod {
    /// <p>The exact method header to be matched on.</p>
    Exact(std::string::String),
    /// <p>The specified beginning characters of the method header to be matched on.</p>
    Prefix(std::string::String),
    /// <p>An object that represents the range of values to match on. The first character of the range is included in the range, though the last character is not. For example, if the range specified were 1-100, only values 1-99 would be matched.</p>
    Range(crate::model::MatchRange),
    /// <p>The regex used to match the method header.</p>
    Regex(std::string::String),
    /// <p>The specified ending characters of the method header to match on.</p>
    Suffix(std::string::String),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl GrpcMetadataMatchMethod {
    /// Tries to convert the enum instance into [`Exact`](crate::model::GrpcMetadataMatchMethod::Exact), extracting the inner [`String`](std::string::String).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_exact(&self) -> std::result::Result<&std::string::String, &Self> {
        if let GrpcMetadataMatchMethod::Exact(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Exact`](crate::model::GrpcMetadataMatchMethod::Exact).
    pub fn is_exact(&self) -> bool {
        self.as_exact().is_ok()
    }
    /// Tries to convert the enum instance into [`Prefix`](crate::model::GrpcMetadataMatchMethod::Prefix), extracting the inner [`String`](std::string::String).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_prefix(&self) -> std::result::Result<&std::string::String, &Self> {
        if let GrpcMetadataMatchMethod::Prefix(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Prefix`](crate::model::GrpcMetadataMatchMethod::Prefix).
    pub fn is_prefix(&self) -> bool {
        self.as_prefix().is_ok()
    }
    /// Tries to convert the enum instance into [`Range`](crate::model::GrpcMetadataMatchMethod::Range), extracting the inner [`MatchRange`](crate::model::MatchRange).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_range(&self) -> std::result::Result<&crate::model::MatchRange, &Self> {
        if let GrpcMetadataMatchMethod::Range(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Range`](crate::model::GrpcMetadataMatchMethod::Range).
    pub fn is_range(&self) -> bool {
        self.as_range().is_ok()
    }
    /// Tries to convert the enum instance into [`Regex`](crate::model::GrpcMetadataMatchMethod::Regex), extracting the inner [`String`](std::string::String).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_regex(&self) -> std::result::Result<&std::string::String, &Self> {
        if let GrpcMetadataMatchMethod::Regex(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Regex`](crate::model::GrpcMetadataMatchMethod::Regex).
    pub fn is_regex(&self) -> bool {
        self.as_regex().is_ok()
    }
    /// Tries to convert the enum instance into [`Suffix`](crate::model::GrpcMetadataMatchMethod::Suffix), extracting the inner [`String`](std::string::String).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_suffix(&self) -> std::result::Result<&std::string::String, &Self> {
        if let GrpcMetadataMatchMethod::Suffix(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Suffix`](crate::model::GrpcMetadataMatchMethod::Suffix).
    pub fn is_suffix(&self) -> bool {
        self.as_suffix().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

/// <p>An object representing the gateway route host name to match.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GatewayRouteHostnameMatch {
    /// <p>The exact host name to match on.</p>
    pub exact: std::option::Option<std::string::String>,
    /// <p>The specified ending characters of the host name to match on.</p>
    pub suffix: std::option::Option<std::string::String>,
}
impl GatewayRouteHostnameMatch {
    /// <p>The exact host name to match on.</p>
    pub fn exact(&self) -> std::option::Option<&str> {
        self.exact.as_deref()
    }
    /// <p>The specified ending characters of the host name to match on.</p>
    pub fn suffix(&self) -> std::option::Option<&str> {
        self.suffix.as_deref()
    }
}
impl std::fmt::Debug for GatewayRouteHostnameMatch {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GatewayRouteHostnameMatch");
        formatter.field("exact", &self.exact);
        formatter.field("suffix", &self.suffix);
        formatter.finish()
    }
}
/// See [`GatewayRouteHostnameMatch`](crate::model::GatewayRouteHostnameMatch)
pub mod gateway_route_hostname_match {
    /// A builder for [`GatewayRouteHostnameMatch`](crate::model::GatewayRouteHostnameMatch)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) exact: std::option::Option<std::string::String>,
        pub(crate) suffix: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The exact host name to match on.</p>
        pub fn exact(mut self, input: impl Into<std::string::String>) -> Self {
            self.exact = Some(input.into());
            self
        }
        /// <p>The exact host name to match on.</p>
        pub fn set_exact(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.exact = input;
            self
        }
        /// <p>The specified ending characters of the host name to match on.</p>
        pub fn suffix(mut self, input: impl Into<std::string::String>) -> Self {
            self.suffix = Some(input.into());
            self
        }
        /// <p>The specified ending characters of the host name to match on.</p>
        pub fn set_suffix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.suffix = input;
            self
        }
        /// Consumes the builder and constructs a [`GatewayRouteHostnameMatch`](crate::model::GatewayRouteHostnameMatch)
        pub fn build(self) -> crate::model::GatewayRouteHostnameMatch {
            crate::model::GatewayRouteHostnameMatch {
                exact: self.exact,
                suffix: self.suffix,
            }
        }
    }
}
impl GatewayRouteHostnameMatch {
    /// Creates a new builder-style object to manufacture [`GatewayRouteHostnameMatch`](crate::model::GatewayRouteHostnameMatch)
    pub fn builder() -> crate::model::gateway_route_hostname_match::Builder {
        crate::model::gateway_route_hostname_match::Builder::default()
    }
}

/// <p>An object that represents an HTTP gateway route.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HttpGatewayRoute {
    /// <p>An object that represents the criteria for determining a request match.</p>
    pub r#match: std::option::Option<crate::model::HttpGatewayRouteMatch>,
    /// <p>An object that represents the action to take if a match is determined.</p>
    pub action: std::option::Option<crate::model::HttpGatewayRouteAction>,
}
impl HttpGatewayRoute {
    /// <p>An object that represents the criteria for determining a request match.</p>
    pub fn r#match(&self) -> std::option::Option<&crate::model::HttpGatewayRouteMatch> {
        self.r#match.as_ref()
    }
    /// <p>An object that represents the action to take if a match is determined.</p>
    pub fn action(&self) -> std::option::Option<&crate::model::HttpGatewayRouteAction> {
        self.action.as_ref()
    }
}
impl std::fmt::Debug for HttpGatewayRoute {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HttpGatewayRoute");
        formatter.field("r#match", &self.r#match);
        formatter.field("action", &self.action);
        formatter.finish()
    }
}
/// See [`HttpGatewayRoute`](crate::model::HttpGatewayRoute)
pub mod http_gateway_route {
    /// A builder for [`HttpGatewayRoute`](crate::model::HttpGatewayRoute)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#match: std::option::Option<crate::model::HttpGatewayRouteMatch>,
        pub(crate) action: std::option::Option<crate::model::HttpGatewayRouteAction>,
    }
    impl Builder {
        /// <p>An object that represents the criteria for determining a request match.</p>
        pub fn r#match(mut self, input: crate::model::HttpGatewayRouteMatch) -> Self {
            self.r#match = Some(input);
            self
        }
        /// <p>An object that represents the criteria for determining a request match.</p>
        pub fn set_match(
            mut self,
            input: std::option::Option<crate::model::HttpGatewayRouteMatch>,
        ) -> Self {
            self.r#match = input;
            self
        }
        /// <p>An object that represents the action to take if a match is determined.</p>
        pub fn action(mut self, input: crate::model::HttpGatewayRouteAction) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>An object that represents the action to take if a match is determined.</p>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::HttpGatewayRouteAction>,
        ) -> Self {
            self.action = input;
            self
        }
        /// Consumes the builder and constructs a [`HttpGatewayRoute`](crate::model::HttpGatewayRoute)
        pub fn build(self) -> crate::model::HttpGatewayRoute {
            crate::model::HttpGatewayRoute {
                r#match: self.r#match,
                action: self.action,
            }
        }
    }
}
impl HttpGatewayRoute {
    /// Creates a new builder-style object to manufacture [`HttpGatewayRoute`](crate::model::HttpGatewayRoute)
    pub fn builder() -> crate::model::http_gateway_route::Builder {
        crate::model::http_gateway_route::Builder::default()
    }
}

/// <p>An object that represents the action to take if a match is determined.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HttpGatewayRouteAction {
    /// <p>An object that represents the target that traffic is routed to when a request matches the gateway route.</p>
    pub target: std::option::Option<crate::model::GatewayRouteTarget>,
    /// <p>The gateway route action to rewrite.</p>
    pub rewrite: std::option::Option<crate::model::HttpGatewayRouteRewrite>,
}
impl HttpGatewayRouteAction {
    /// <p>An object that represents the target that traffic is routed to when a request matches the gateway route.</p>
    pub fn target(&self) -> std::option::Option<&crate::model::GatewayRouteTarget> {
        self.target.as_ref()
    }
    /// <p>The gateway route action to rewrite.</p>
    pub fn rewrite(&self) -> std::option::Option<&crate::model::HttpGatewayRouteRewrite> {
        self.rewrite.as_ref()
    }
}
impl std::fmt::Debug for HttpGatewayRouteAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HttpGatewayRouteAction");
        formatter.field("target", &self.target);
        formatter.field("rewrite", &self.rewrite);
        formatter.finish()
    }
}
/// See [`HttpGatewayRouteAction`](crate::model::HttpGatewayRouteAction)
pub mod http_gateway_route_action {
    /// A builder for [`HttpGatewayRouteAction`](crate::model::HttpGatewayRouteAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target: std::option::Option<crate::model::GatewayRouteTarget>,
        pub(crate) rewrite: std::option::Option<crate::model::HttpGatewayRouteRewrite>,
    }
    impl Builder {
        /// <p>An object that represents the target that traffic is routed to when a request matches the gateway route.</p>
        pub fn target(mut self, input: crate::model::GatewayRouteTarget) -> Self {
            self.target = Some(input);
            self
        }
        /// <p>An object that represents the target that traffic is routed to when a request matches the gateway route.</p>
        pub fn set_target(
            mut self,
            input: std::option::Option<crate::model::GatewayRouteTarget>,
        ) -> Self {
            self.target = input;
            self
        }
        /// <p>The gateway route action to rewrite.</p>
        pub fn rewrite(mut self, input: crate::model::HttpGatewayRouteRewrite) -> Self {
            self.rewrite = Some(input);
            self
        }
        /// <p>The gateway route action to rewrite.</p>
        pub fn set_rewrite(
            mut self,
            input: std::option::Option<crate::model::HttpGatewayRouteRewrite>,
        ) -> Self {
            self.rewrite = input;
            self
        }
        /// Consumes the builder and constructs a [`HttpGatewayRouteAction`](crate::model::HttpGatewayRouteAction)
        pub fn build(self) -> crate::model::HttpGatewayRouteAction {
            crate::model::HttpGatewayRouteAction {
                target: self.target,
                rewrite: self.rewrite,
            }
        }
    }
}
impl HttpGatewayRouteAction {
    /// Creates a new builder-style object to manufacture [`HttpGatewayRouteAction`](crate::model::HttpGatewayRouteAction)
    pub fn builder() -> crate::model::http_gateway_route_action::Builder {
        crate::model::http_gateway_route_action::Builder::default()
    }
}

/// <p>An object representing the gateway route to rewrite.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HttpGatewayRouteRewrite {
    /// <p>The specified beginning characters to rewrite.</p>
    pub prefix: std::option::Option<crate::model::HttpGatewayRoutePrefixRewrite>,
    /// <p>The path to rewrite.</p>
    pub path: std::option::Option<crate::model::HttpGatewayRoutePathRewrite>,
    /// <p>The host name to rewrite.</p>
    pub hostname: std::option::Option<crate::model::GatewayRouteHostnameRewrite>,
}
impl HttpGatewayRouteRewrite {
    /// <p>The specified beginning characters to rewrite.</p>
    pub fn prefix(&self) -> std::option::Option<&crate::model::HttpGatewayRoutePrefixRewrite> {
        self.prefix.as_ref()
    }
    /// <p>The path to rewrite.</p>
    pub fn path(&self) -> std::option::Option<&crate::model::HttpGatewayRoutePathRewrite> {
        self.path.as_ref()
    }
    /// <p>The host name to rewrite.</p>
    pub fn hostname(&self) -> std::option::Option<&crate::model::GatewayRouteHostnameRewrite> {
        self.hostname.as_ref()
    }
}
impl std::fmt::Debug for HttpGatewayRouteRewrite {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HttpGatewayRouteRewrite");
        formatter.field("prefix", &self.prefix);
        formatter.field("path", &self.path);
        formatter.field("hostname", &self.hostname);
        formatter.finish()
    }
}
/// See [`HttpGatewayRouteRewrite`](crate::model::HttpGatewayRouteRewrite)
pub mod http_gateway_route_rewrite {
    /// A builder for [`HttpGatewayRouteRewrite`](crate::model::HttpGatewayRouteRewrite)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) prefix: std::option::Option<crate::model::HttpGatewayRoutePrefixRewrite>,
        pub(crate) path: std::option::Option<crate::model::HttpGatewayRoutePathRewrite>,
        pub(crate) hostname: std::option::Option<crate::model::GatewayRouteHostnameRewrite>,
    }
    impl Builder {
        /// <p>The specified beginning characters to rewrite.</p>
        pub fn prefix(mut self, input: crate::model::HttpGatewayRoutePrefixRewrite) -> Self {
            self.prefix = Some(input);
            self
        }
        /// <p>The specified beginning characters to rewrite.</p>
        pub fn set_prefix(
            mut self,
            input: std::option::Option<crate::model::HttpGatewayRoutePrefixRewrite>,
        ) -> Self {
            self.prefix = input;
            self
        }
        /// <p>The path to rewrite.</p>
        pub fn path(mut self, input: crate::model::HttpGatewayRoutePathRewrite) -> Self {
            self.path = Some(input);
            self
        }
        /// <p>The path to rewrite.</p>
        pub fn set_path(
            mut self,
            input: std::option::Option<crate::model::HttpGatewayRoutePathRewrite>,
        ) -> Self {
            self.path = input;
            self
        }
        /// <p>The host name to rewrite.</p>
        pub fn hostname(mut self, input: crate::model::GatewayRouteHostnameRewrite) -> Self {
            self.hostname = Some(input);
            self
        }
        /// <p>The host name to rewrite.</p>
        pub fn set_hostname(
            mut self,
            input: std::option::Option<crate::model::GatewayRouteHostnameRewrite>,
        ) -> Self {
            self.hostname = input;
            self
        }
        /// Consumes the builder and constructs a [`HttpGatewayRouteRewrite`](crate::model::HttpGatewayRouteRewrite)
        pub fn build(self) -> crate::model::HttpGatewayRouteRewrite {
            crate::model::HttpGatewayRouteRewrite {
                prefix: self.prefix,
                path: self.path,
                hostname: self.hostname,
            }
        }
    }
}
impl HttpGatewayRouteRewrite {
    /// Creates a new builder-style object to manufacture [`HttpGatewayRouteRewrite`](crate::model::HttpGatewayRouteRewrite)
    pub fn builder() -> crate::model::http_gateway_route_rewrite::Builder {
        crate::model::http_gateway_route_rewrite::Builder::default()
    }
}

/// <p>An object that represents the path to rewrite.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HttpGatewayRoutePathRewrite {
    /// <p>The exact path to rewrite.</p>
    pub exact: std::option::Option<std::string::String>,
}
impl HttpGatewayRoutePathRewrite {
    /// <p>The exact path to rewrite.</p>
    pub fn exact(&self) -> std::option::Option<&str> {
        self.exact.as_deref()
    }
}
impl std::fmt::Debug for HttpGatewayRoutePathRewrite {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HttpGatewayRoutePathRewrite");
        formatter.field("exact", &self.exact);
        formatter.finish()
    }
}
/// See [`HttpGatewayRoutePathRewrite`](crate::model::HttpGatewayRoutePathRewrite)
pub mod http_gateway_route_path_rewrite {
    /// A builder for [`HttpGatewayRoutePathRewrite`](crate::model::HttpGatewayRoutePathRewrite)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) exact: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The exact path to rewrite.</p>
        pub fn exact(mut self, input: impl Into<std::string::String>) -> Self {
            self.exact = Some(input.into());
            self
        }
        /// <p>The exact path to rewrite.</p>
        pub fn set_exact(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.exact = input;
            self
        }
        /// Consumes the builder and constructs a [`HttpGatewayRoutePathRewrite`](crate::model::HttpGatewayRoutePathRewrite)
        pub fn build(self) -> crate::model::HttpGatewayRoutePathRewrite {
            crate::model::HttpGatewayRoutePathRewrite { exact: self.exact }
        }
    }
}
impl HttpGatewayRoutePathRewrite {
    /// Creates a new builder-style object to manufacture [`HttpGatewayRoutePathRewrite`](crate::model::HttpGatewayRoutePathRewrite)
    pub fn builder() -> crate::model::http_gateway_route_path_rewrite::Builder {
        crate::model::http_gateway_route_path_rewrite::Builder::default()
    }
}

/// <p>An object representing the beginning characters of the route to rewrite.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HttpGatewayRoutePrefixRewrite {
    /// <p>The default prefix used to replace the incoming route prefix when rewritten.</p>
    pub default_prefix: std::option::Option<crate::model::DefaultGatewayRouteRewrite>,
    /// <p>The value used to replace the incoming route prefix when rewritten.</p>
    pub value: std::option::Option<std::string::String>,
}
impl HttpGatewayRoutePrefixRewrite {
    /// <p>The default prefix used to replace the incoming route prefix when rewritten.</p>
    pub fn default_prefix(&self) -> std::option::Option<&crate::model::DefaultGatewayRouteRewrite> {
        self.default_prefix.as_ref()
    }
    /// <p>The value used to replace the incoming route prefix when rewritten.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for HttpGatewayRoutePrefixRewrite {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HttpGatewayRoutePrefixRewrite");
        formatter.field("default_prefix", &self.default_prefix);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`HttpGatewayRoutePrefixRewrite`](crate::model::HttpGatewayRoutePrefixRewrite)
pub mod http_gateway_route_prefix_rewrite {
    /// A builder for [`HttpGatewayRoutePrefixRewrite`](crate::model::HttpGatewayRoutePrefixRewrite)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) default_prefix: std::option::Option<crate::model::DefaultGatewayRouteRewrite>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The default prefix used to replace the incoming route prefix when rewritten.</p>
        pub fn default_prefix(mut self, input: crate::model::DefaultGatewayRouteRewrite) -> Self {
            self.default_prefix = Some(input);
            self
        }
        /// <p>The default prefix used to replace the incoming route prefix when rewritten.</p>
        pub fn set_default_prefix(
            mut self,
            input: std::option::Option<crate::model::DefaultGatewayRouteRewrite>,
        ) -> Self {
            self.default_prefix = input;
            self
        }
        /// <p>The value used to replace the incoming route prefix when rewritten.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value used to replace the incoming route prefix when rewritten.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`HttpGatewayRoutePrefixRewrite`](crate::model::HttpGatewayRoutePrefixRewrite)
        pub fn build(self) -> crate::model::HttpGatewayRoutePrefixRewrite {
            crate::model::HttpGatewayRoutePrefixRewrite {
                default_prefix: self.default_prefix,
                value: self.value,
            }
        }
    }
}
impl HttpGatewayRoutePrefixRewrite {
    /// Creates a new builder-style object to manufacture [`HttpGatewayRoutePrefixRewrite`](crate::model::HttpGatewayRoutePrefixRewrite)
    pub fn builder() -> crate::model::http_gateway_route_prefix_rewrite::Builder {
        crate::model::http_gateway_route_prefix_rewrite::Builder::default()
    }
}

/// <p>An object that represents the criteria for determining a request match.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HttpGatewayRouteMatch {
    /// <p>Specifies the path to match requests with. This parameter must always start with
    /// <code>/</code>, which by itself matches all requests to the virtual service name. You
    /// can also match for path-based routing of requests. For example, if your virtual service
    /// name is <code>my-service.local</code> and you want the route to match requests to
    /// <code>my-service.local/metrics</code>, your prefix should be
    /// <code>/metrics</code>.</p>
    pub prefix: std::option::Option<std::string::String>,
    /// <p>The path to match on.</p>
    pub path: std::option::Option<crate::model::HttpPathMatch>,
    /// <p>The query parameter to match on.</p>
    pub query_parameters: std::option::Option<std::vec::Vec<crate::model::HttpQueryParameter>>,
    /// <p>The method to match on.</p>
    pub method: std::option::Option<crate::model::HttpMethod>,
    /// <p>The host name to match on.</p>
    pub hostname: std::option::Option<crate::model::GatewayRouteHostnameMatch>,
    /// <p>The client request headers to match on.</p>
    pub headers: std::option::Option<std::vec::Vec<crate::model::HttpGatewayRouteHeader>>,
}
impl HttpGatewayRouteMatch {
    /// <p>Specifies the path to match requests with. This parameter must always start with
    /// <code>/</code>, which by itself matches all requests to the virtual service name. You
    /// can also match for path-based routing of requests. For example, if your virtual service
    /// name is <code>my-service.local</code> and you want the route to match requests to
    /// <code>my-service.local/metrics</code>, your prefix should be
    /// <code>/metrics</code>.</p>
    pub fn prefix(&self) -> std::option::Option<&str> {
        self.prefix.as_deref()
    }
    /// <p>The path to match on.</p>
    pub fn path(&self) -> std::option::Option<&crate::model::HttpPathMatch> {
        self.path.as_ref()
    }
    /// <p>The query parameter to match on.</p>
    pub fn query_parameters(&self) -> std::option::Option<&[crate::model::HttpQueryParameter]> {
        self.query_parameters.as_deref()
    }
    /// <p>The method to match on.</p>
    pub fn method(&self) -> std::option::Option<&crate::model::HttpMethod> {
        self.method.as_ref()
    }
    /// <p>The host name to match on.</p>
    pub fn hostname(&self) -> std::option::Option<&crate::model::GatewayRouteHostnameMatch> {
        self.hostname.as_ref()
    }
    /// <p>The client request headers to match on.</p>
    pub fn headers(&self) -> std::option::Option<&[crate::model::HttpGatewayRouteHeader]> {
        self.headers.as_deref()
    }
}
impl std::fmt::Debug for HttpGatewayRouteMatch {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HttpGatewayRouteMatch");
        formatter.field("prefix", &self.prefix);
        formatter.field("path", &self.path);
        formatter.field("query_parameters", &self.query_parameters);
        formatter.field("method", &self.method);
        formatter.field("hostname", &self.hostname);
        formatter.field("headers", &self.headers);
        formatter.finish()
    }
}
/// See [`HttpGatewayRouteMatch`](crate::model::HttpGatewayRouteMatch)
pub mod http_gateway_route_match {
    /// A builder for [`HttpGatewayRouteMatch`](crate::model::HttpGatewayRouteMatch)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) prefix: std::option::Option<std::string::String>,
        pub(crate) path: std::option::Option<crate::model::HttpPathMatch>,
        pub(crate) query_parameters:
            std::option::Option<std::vec::Vec<crate::model::HttpQueryParameter>>,
        pub(crate) method: std::option::Option<crate::model::HttpMethod>,
        pub(crate) hostname: std::option::Option<crate::model::GatewayRouteHostnameMatch>,
        pub(crate) headers:
            std::option::Option<std::vec::Vec<crate::model::HttpGatewayRouteHeader>>,
    }
    impl Builder {
        /// <p>Specifies the path to match requests with. This parameter must always start with
        /// <code>/</code>, which by itself matches all requests to the virtual service name. You
        /// can also match for path-based routing of requests. For example, if your virtual service
        /// name is <code>my-service.local</code> and you want the route to match requests to
        /// <code>my-service.local/metrics</code>, your prefix should be
        /// <code>/metrics</code>.</p>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p>Specifies the path to match requests with. This parameter must always start with
        /// <code>/</code>, which by itself matches all requests to the virtual service name. You
        /// can also match for path-based routing of requests. For example, if your virtual service
        /// name is <code>my-service.local</code> and you want the route to match requests to
        /// <code>my-service.local/metrics</code>, your prefix should be
        /// <code>/metrics</code>.</p>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// <p>The path to match on.</p>
        pub fn path(mut self, input: crate::model::HttpPathMatch) -> Self {
            self.path = Some(input);
            self
        }
        /// <p>The path to match on.</p>
        pub fn set_path(mut self, input: std::option::Option<crate::model::HttpPathMatch>) -> Self {
            self.path = input;
            self
        }
        /// Appends an item to `query_parameters`.
        ///
        /// To override the contents of this collection use [`set_query_parameters`](Self::set_query_parameters).
        ///
        /// <p>The query parameter to match on.</p>
        pub fn query_parameters(
            mut self,
            input: impl Into<crate::model::HttpQueryParameter>,
        ) -> Self {
            let mut v = self.query_parameters.unwrap_or_default();
            v.push(input.into());
            self.query_parameters = Some(v);
            self
        }
        /// <p>The query parameter to match on.</p>
        pub fn set_query_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HttpQueryParameter>>,
        ) -> Self {
            self.query_parameters = input;
            self
        }
        /// <p>The method to match on.</p>
        pub fn method(mut self, input: crate::model::HttpMethod) -> Self {
            self.method = Some(input);
            self
        }
        /// <p>The method to match on.</p>
        pub fn set_method(mut self, input: std::option::Option<crate::model::HttpMethod>) -> Self {
            self.method = input;
            self
        }
        /// <p>The host name to match on.</p>
        pub fn hostname(mut self, input: crate::model::GatewayRouteHostnameMatch) -> Self {
            self.hostname = Some(input);
            self
        }
        /// <p>The host name to match on.</p>
        pub fn set_hostname(
            mut self,
            input: std::option::Option<crate::model::GatewayRouteHostnameMatch>,
        ) -> Self {
            self.hostname = input;
            self
        }
        /// Appends an item to `headers`.
        ///
        /// To override the contents of this collection use [`set_headers`](Self::set_headers).
        ///
        /// <p>The client request headers to match on.</p>
        pub fn headers(mut self, input: impl Into<crate::model::HttpGatewayRouteHeader>) -> Self {
            let mut v = self.headers.unwrap_or_default();
            v.push(input.into());
            self.headers = Some(v);
            self
        }
        /// <p>The client request headers to match on.</p>
        pub fn set_headers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HttpGatewayRouteHeader>>,
        ) -> Self {
            self.headers = input;
            self
        }
        /// Consumes the builder and constructs a [`HttpGatewayRouteMatch`](crate::model::HttpGatewayRouteMatch)
        pub fn build(self) -> crate::model::HttpGatewayRouteMatch {
            crate::model::HttpGatewayRouteMatch {
                prefix: self.prefix,
                path: self.path,
                query_parameters: self.query_parameters,
                method: self.method,
                hostname: self.hostname,
                headers: self.headers,
            }
        }
    }
}
impl HttpGatewayRouteMatch {
    /// Creates a new builder-style object to manufacture [`HttpGatewayRouteMatch`](crate::model::HttpGatewayRouteMatch)
    pub fn builder() -> crate::model::http_gateway_route_match::Builder {
        crate::model::http_gateway_route_match::Builder::default()
    }
}

/// <p>An object that represents the HTTP header in the gateway route.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HttpGatewayRouteHeader {
    /// <p>A name for the HTTP header in the gateway route that will be matched on.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Specify <code>True</code> to match anything except the match criteria. The default value is <code>False</code>.</p>
    pub invert: std::option::Option<bool>,
    /// <p>An object that represents the method and value to match with the header value sent in a
    /// request. Specify one match method.</p>
    pub r#match: std::option::Option<crate::model::HeaderMatchMethod>,
}
impl HttpGatewayRouteHeader {
    /// <p>A name for the HTTP header in the gateway route that will be matched on.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Specify <code>True</code> to match anything except the match criteria. The default value is <code>False</code>.</p>
    pub fn invert(&self) -> std::option::Option<bool> {
        self.invert
    }
    /// <p>An object that represents the method and value to match with the header value sent in a
    /// request. Specify one match method.</p>
    pub fn r#match(&self) -> std::option::Option<&crate::model::HeaderMatchMethod> {
        self.r#match.as_ref()
    }
}
impl std::fmt::Debug for HttpGatewayRouteHeader {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HttpGatewayRouteHeader");
        formatter.field("name", &self.name);
        formatter.field("invert", &self.invert);
        formatter.field("r#match", &self.r#match);
        formatter.finish()
    }
}
/// See [`HttpGatewayRouteHeader`](crate::model::HttpGatewayRouteHeader)
pub mod http_gateway_route_header {
    /// A builder for [`HttpGatewayRouteHeader`](crate::model::HttpGatewayRouteHeader)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) invert: std::option::Option<bool>,
        pub(crate) r#match: std::option::Option<crate::model::HeaderMatchMethod>,
    }
    impl Builder {
        /// <p>A name for the HTTP header in the gateway route that will be matched on.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A name for the HTTP header in the gateway route that will be matched on.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Specify <code>True</code> to match anything except the match criteria. The default value is <code>False</code>.</p>
        pub fn invert(mut self, input: bool) -> Self {
            self.invert = Some(input);
            self
        }
        /// <p>Specify <code>True</code> to match anything except the match criteria. The default value is <code>False</code>.</p>
        pub fn set_invert(mut self, input: std::option::Option<bool>) -> Self {
            self.invert = input;
            self
        }
        /// <p>An object that represents the method and value to match with the header value sent in a
        /// request. Specify one match method.</p>
        pub fn r#match(mut self, input: crate::model::HeaderMatchMethod) -> Self {
            self.r#match = Some(input);
            self
        }
        /// <p>An object that represents the method and value to match with the header value sent in a
        /// request. Specify one match method.</p>
        pub fn set_match(
            mut self,
            input: std::option::Option<crate::model::HeaderMatchMethod>,
        ) -> Self {
            self.r#match = input;
            self
        }
        /// Consumes the builder and constructs a [`HttpGatewayRouteHeader`](crate::model::HttpGatewayRouteHeader)
        pub fn build(self) -> crate::model::HttpGatewayRouteHeader {
            crate::model::HttpGatewayRouteHeader {
                name: self.name,
                invert: self.invert,
                r#match: self.r#match,
            }
        }
    }
}
impl HttpGatewayRouteHeader {
    /// Creates a new builder-style object to manufacture [`HttpGatewayRouteHeader`](crate::model::HttpGatewayRouteHeader)
    pub fn builder() -> crate::model::http_gateway_route_header::Builder {
        crate::model::http_gateway_route_header::Builder::default()
    }
}
