// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `CreateGatewayRoute`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_gateway_route`](crate::client::Client::create_gateway_route).
///
/// See [`crate::client::fluent_builders::CreateGatewayRoute`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateGatewayRoute {
    _private: (),
}
impl CreateGatewayRoute {
    /// Creates a new builder-style object to manufacture [`CreateGatewayRouteInput`](crate::input::CreateGatewayRouteInput)
    pub fn builder() -> crate::input::create_gateway_route_input::Builder {
        crate::input::create_gateway_route_input::Builder::default()
    }
    /// Creates a new `CreateGatewayRoute` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateGatewayRoute {
    type Output = std::result::Result<
        crate::output::CreateGatewayRouteOutput,
        crate::error::CreateGatewayRouteError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_gateway_route_error(response)
        } else {
            crate::operation_deser::parse_create_gateway_route_response(response)
        }
    }
}

/// Operation shape for `CreateMesh`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_mesh`](crate::client::Client::create_mesh).
///
/// See [`crate::client::fluent_builders::CreateMesh`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateMesh {
    _private: (),
}
impl CreateMesh {
    /// Creates a new builder-style object to manufacture [`CreateMeshInput`](crate::input::CreateMeshInput)
    pub fn builder() -> crate::input::create_mesh_input::Builder {
        crate::input::create_mesh_input::Builder::default()
    }
    /// Creates a new `CreateMesh` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateMesh {
    type Output =
        std::result::Result<crate::output::CreateMeshOutput, crate::error::CreateMeshError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_mesh_error(response)
        } else {
            crate::operation_deser::parse_create_mesh_response(response)
        }
    }
}

/// Operation shape for `CreateRoute`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_route`](crate::client::Client::create_route).
///
/// See [`crate::client::fluent_builders::CreateRoute`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateRoute {
    _private: (),
}
impl CreateRoute {
    /// Creates a new builder-style object to manufacture [`CreateRouteInput`](crate::input::CreateRouteInput)
    pub fn builder() -> crate::input::create_route_input::Builder {
        crate::input::create_route_input::Builder::default()
    }
    /// Creates a new `CreateRoute` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateRoute {
    type Output =
        std::result::Result<crate::output::CreateRouteOutput, crate::error::CreateRouteError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_route_error(response)
        } else {
            crate::operation_deser::parse_create_route_response(response)
        }
    }
}

/// Operation shape for `CreateVirtualGateway`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_virtual_gateway`](crate::client::Client::create_virtual_gateway).
///
/// See [`crate::client::fluent_builders::CreateVirtualGateway`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateVirtualGateway {
    _private: (),
}
impl CreateVirtualGateway {
    /// Creates a new builder-style object to manufacture [`CreateVirtualGatewayInput`](crate::input::CreateVirtualGatewayInput)
    pub fn builder() -> crate::input::create_virtual_gateway_input::Builder {
        crate::input::create_virtual_gateway_input::Builder::default()
    }
    /// Creates a new `CreateVirtualGateway` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateVirtualGateway {
    type Output = std::result::Result<
        crate::output::CreateVirtualGatewayOutput,
        crate::error::CreateVirtualGatewayError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_virtual_gateway_error(response)
        } else {
            crate::operation_deser::parse_create_virtual_gateway_response(response)
        }
    }
}

/// Operation shape for `CreateVirtualNode`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_virtual_node`](crate::client::Client::create_virtual_node).
///
/// See [`crate::client::fluent_builders::CreateVirtualNode`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateVirtualNode {
    _private: (),
}
impl CreateVirtualNode {
    /// Creates a new builder-style object to manufacture [`CreateVirtualNodeInput`](crate::input::CreateVirtualNodeInput)
    pub fn builder() -> crate::input::create_virtual_node_input::Builder {
        crate::input::create_virtual_node_input::Builder::default()
    }
    /// Creates a new `CreateVirtualNode` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateVirtualNode {
    type Output = std::result::Result<
        crate::output::CreateVirtualNodeOutput,
        crate::error::CreateVirtualNodeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_virtual_node_error(response)
        } else {
            crate::operation_deser::parse_create_virtual_node_response(response)
        }
    }
}

/// Operation shape for `CreateVirtualRouter`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_virtual_router`](crate::client::Client::create_virtual_router).
///
/// See [`crate::client::fluent_builders::CreateVirtualRouter`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateVirtualRouter {
    _private: (),
}
impl CreateVirtualRouter {
    /// Creates a new builder-style object to manufacture [`CreateVirtualRouterInput`](crate::input::CreateVirtualRouterInput)
    pub fn builder() -> crate::input::create_virtual_router_input::Builder {
        crate::input::create_virtual_router_input::Builder::default()
    }
    /// Creates a new `CreateVirtualRouter` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateVirtualRouter {
    type Output = std::result::Result<
        crate::output::CreateVirtualRouterOutput,
        crate::error::CreateVirtualRouterError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_virtual_router_error(response)
        } else {
            crate::operation_deser::parse_create_virtual_router_response(response)
        }
    }
}

/// Operation shape for `CreateVirtualService`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_virtual_service`](crate::client::Client::create_virtual_service).
///
/// See [`crate::client::fluent_builders::CreateVirtualService`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateVirtualService {
    _private: (),
}
impl CreateVirtualService {
    /// Creates a new builder-style object to manufacture [`CreateVirtualServiceInput`](crate::input::CreateVirtualServiceInput)
    pub fn builder() -> crate::input::create_virtual_service_input::Builder {
        crate::input::create_virtual_service_input::Builder::default()
    }
    /// Creates a new `CreateVirtualService` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateVirtualService {
    type Output = std::result::Result<
        crate::output::CreateVirtualServiceOutput,
        crate::error::CreateVirtualServiceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_virtual_service_error(response)
        } else {
            crate::operation_deser::parse_create_virtual_service_response(response)
        }
    }
}

/// Operation shape for `DeleteGatewayRoute`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_gateway_route`](crate::client::Client::delete_gateway_route).
///
/// See [`crate::client::fluent_builders::DeleteGatewayRoute`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteGatewayRoute {
    _private: (),
}
impl DeleteGatewayRoute {
    /// Creates a new builder-style object to manufacture [`DeleteGatewayRouteInput`](crate::input::DeleteGatewayRouteInput)
    pub fn builder() -> crate::input::delete_gateway_route_input::Builder {
        crate::input::delete_gateway_route_input::Builder::default()
    }
    /// Creates a new `DeleteGatewayRoute` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteGatewayRoute {
    type Output = std::result::Result<
        crate::output::DeleteGatewayRouteOutput,
        crate::error::DeleteGatewayRouteError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_gateway_route_error(response)
        } else {
            crate::operation_deser::parse_delete_gateway_route_response(response)
        }
    }
}

/// Operation shape for `DeleteMesh`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_mesh`](crate::client::Client::delete_mesh).
///
/// See [`crate::client::fluent_builders::DeleteMesh`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteMesh {
    _private: (),
}
impl DeleteMesh {
    /// Creates a new builder-style object to manufacture [`DeleteMeshInput`](crate::input::DeleteMeshInput)
    pub fn builder() -> crate::input::delete_mesh_input::Builder {
        crate::input::delete_mesh_input::Builder::default()
    }
    /// Creates a new `DeleteMesh` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteMesh {
    type Output =
        std::result::Result<crate::output::DeleteMeshOutput, crate::error::DeleteMeshError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_mesh_error(response)
        } else {
            crate::operation_deser::parse_delete_mesh_response(response)
        }
    }
}

/// Operation shape for `DeleteRoute`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_route`](crate::client::Client::delete_route).
///
/// See [`crate::client::fluent_builders::DeleteRoute`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteRoute {
    _private: (),
}
impl DeleteRoute {
    /// Creates a new builder-style object to manufacture [`DeleteRouteInput`](crate::input::DeleteRouteInput)
    pub fn builder() -> crate::input::delete_route_input::Builder {
        crate::input::delete_route_input::Builder::default()
    }
    /// Creates a new `DeleteRoute` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteRoute {
    type Output =
        std::result::Result<crate::output::DeleteRouteOutput, crate::error::DeleteRouteError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_route_error(response)
        } else {
            crate::operation_deser::parse_delete_route_response(response)
        }
    }
}

/// Operation shape for `DeleteVirtualGateway`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_virtual_gateway`](crate::client::Client::delete_virtual_gateway).
///
/// See [`crate::client::fluent_builders::DeleteVirtualGateway`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteVirtualGateway {
    _private: (),
}
impl DeleteVirtualGateway {
    /// Creates a new builder-style object to manufacture [`DeleteVirtualGatewayInput`](crate::input::DeleteVirtualGatewayInput)
    pub fn builder() -> crate::input::delete_virtual_gateway_input::Builder {
        crate::input::delete_virtual_gateway_input::Builder::default()
    }
    /// Creates a new `DeleteVirtualGateway` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteVirtualGateway {
    type Output = std::result::Result<
        crate::output::DeleteVirtualGatewayOutput,
        crate::error::DeleteVirtualGatewayError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_virtual_gateway_error(response)
        } else {
            crate::operation_deser::parse_delete_virtual_gateway_response(response)
        }
    }
}

/// Operation shape for `DeleteVirtualNode`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_virtual_node`](crate::client::Client::delete_virtual_node).
///
/// See [`crate::client::fluent_builders::DeleteVirtualNode`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteVirtualNode {
    _private: (),
}
impl DeleteVirtualNode {
    /// Creates a new builder-style object to manufacture [`DeleteVirtualNodeInput`](crate::input::DeleteVirtualNodeInput)
    pub fn builder() -> crate::input::delete_virtual_node_input::Builder {
        crate::input::delete_virtual_node_input::Builder::default()
    }
    /// Creates a new `DeleteVirtualNode` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteVirtualNode {
    type Output = std::result::Result<
        crate::output::DeleteVirtualNodeOutput,
        crate::error::DeleteVirtualNodeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_virtual_node_error(response)
        } else {
            crate::operation_deser::parse_delete_virtual_node_response(response)
        }
    }
}

/// Operation shape for `DeleteVirtualRouter`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_virtual_router`](crate::client::Client::delete_virtual_router).
///
/// See [`crate::client::fluent_builders::DeleteVirtualRouter`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteVirtualRouter {
    _private: (),
}
impl DeleteVirtualRouter {
    /// Creates a new builder-style object to manufacture [`DeleteVirtualRouterInput`](crate::input::DeleteVirtualRouterInput)
    pub fn builder() -> crate::input::delete_virtual_router_input::Builder {
        crate::input::delete_virtual_router_input::Builder::default()
    }
    /// Creates a new `DeleteVirtualRouter` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteVirtualRouter {
    type Output = std::result::Result<
        crate::output::DeleteVirtualRouterOutput,
        crate::error::DeleteVirtualRouterError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_virtual_router_error(response)
        } else {
            crate::operation_deser::parse_delete_virtual_router_response(response)
        }
    }
}

/// Operation shape for `DeleteVirtualService`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_virtual_service`](crate::client::Client::delete_virtual_service).
///
/// See [`crate::client::fluent_builders::DeleteVirtualService`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteVirtualService {
    _private: (),
}
impl DeleteVirtualService {
    /// Creates a new builder-style object to manufacture [`DeleteVirtualServiceInput`](crate::input::DeleteVirtualServiceInput)
    pub fn builder() -> crate::input::delete_virtual_service_input::Builder {
        crate::input::delete_virtual_service_input::Builder::default()
    }
    /// Creates a new `DeleteVirtualService` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteVirtualService {
    type Output = std::result::Result<
        crate::output::DeleteVirtualServiceOutput,
        crate::error::DeleteVirtualServiceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_virtual_service_error(response)
        } else {
            crate::operation_deser::parse_delete_virtual_service_response(response)
        }
    }
}

/// Operation shape for `DescribeGatewayRoute`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_gateway_route`](crate::client::Client::describe_gateway_route).
///
/// See [`crate::client::fluent_builders::DescribeGatewayRoute`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeGatewayRoute {
    _private: (),
}
impl DescribeGatewayRoute {
    /// Creates a new builder-style object to manufacture [`DescribeGatewayRouteInput`](crate::input::DescribeGatewayRouteInput)
    pub fn builder() -> crate::input::describe_gateway_route_input::Builder {
        crate::input::describe_gateway_route_input::Builder::default()
    }
    /// Creates a new `DescribeGatewayRoute` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeGatewayRoute {
    type Output = std::result::Result<
        crate::output::DescribeGatewayRouteOutput,
        crate::error::DescribeGatewayRouteError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_gateway_route_error(response)
        } else {
            crate::operation_deser::parse_describe_gateway_route_response(response)
        }
    }
}

/// Operation shape for `DescribeMesh`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_mesh`](crate::client::Client::describe_mesh).
///
/// See [`crate::client::fluent_builders::DescribeMesh`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeMesh {
    _private: (),
}
impl DescribeMesh {
    /// Creates a new builder-style object to manufacture [`DescribeMeshInput`](crate::input::DescribeMeshInput)
    pub fn builder() -> crate::input::describe_mesh_input::Builder {
        crate::input::describe_mesh_input::Builder::default()
    }
    /// Creates a new `DescribeMesh` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeMesh {
    type Output =
        std::result::Result<crate::output::DescribeMeshOutput, crate::error::DescribeMeshError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_mesh_error(response)
        } else {
            crate::operation_deser::parse_describe_mesh_response(response)
        }
    }
}

/// Operation shape for `DescribeRoute`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_route`](crate::client::Client::describe_route).
///
/// See [`crate::client::fluent_builders::DescribeRoute`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeRoute {
    _private: (),
}
impl DescribeRoute {
    /// Creates a new builder-style object to manufacture [`DescribeRouteInput`](crate::input::DescribeRouteInput)
    pub fn builder() -> crate::input::describe_route_input::Builder {
        crate::input::describe_route_input::Builder::default()
    }
    /// Creates a new `DescribeRoute` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeRoute {
    type Output =
        std::result::Result<crate::output::DescribeRouteOutput, crate::error::DescribeRouteError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_route_error(response)
        } else {
            crate::operation_deser::parse_describe_route_response(response)
        }
    }
}

/// Operation shape for `DescribeVirtualGateway`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_virtual_gateway`](crate::client::Client::describe_virtual_gateway).
///
/// See [`crate::client::fluent_builders::DescribeVirtualGateway`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeVirtualGateway {
    _private: (),
}
impl DescribeVirtualGateway {
    /// Creates a new builder-style object to manufacture [`DescribeVirtualGatewayInput`](crate::input::DescribeVirtualGatewayInput)
    pub fn builder() -> crate::input::describe_virtual_gateway_input::Builder {
        crate::input::describe_virtual_gateway_input::Builder::default()
    }
    /// Creates a new `DescribeVirtualGateway` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeVirtualGateway {
    type Output = std::result::Result<
        crate::output::DescribeVirtualGatewayOutput,
        crate::error::DescribeVirtualGatewayError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_virtual_gateway_error(response)
        } else {
            crate::operation_deser::parse_describe_virtual_gateway_response(response)
        }
    }
}

/// Operation shape for `DescribeVirtualNode`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_virtual_node`](crate::client::Client::describe_virtual_node).
///
/// See [`crate::client::fluent_builders::DescribeVirtualNode`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeVirtualNode {
    _private: (),
}
impl DescribeVirtualNode {
    /// Creates a new builder-style object to manufacture [`DescribeVirtualNodeInput`](crate::input::DescribeVirtualNodeInput)
    pub fn builder() -> crate::input::describe_virtual_node_input::Builder {
        crate::input::describe_virtual_node_input::Builder::default()
    }
    /// Creates a new `DescribeVirtualNode` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeVirtualNode {
    type Output = std::result::Result<
        crate::output::DescribeVirtualNodeOutput,
        crate::error::DescribeVirtualNodeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_virtual_node_error(response)
        } else {
            crate::operation_deser::parse_describe_virtual_node_response(response)
        }
    }
}

/// Operation shape for `DescribeVirtualRouter`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_virtual_router`](crate::client::Client::describe_virtual_router).
///
/// See [`crate::client::fluent_builders::DescribeVirtualRouter`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeVirtualRouter {
    _private: (),
}
impl DescribeVirtualRouter {
    /// Creates a new builder-style object to manufacture [`DescribeVirtualRouterInput`](crate::input::DescribeVirtualRouterInput)
    pub fn builder() -> crate::input::describe_virtual_router_input::Builder {
        crate::input::describe_virtual_router_input::Builder::default()
    }
    /// Creates a new `DescribeVirtualRouter` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeVirtualRouter {
    type Output = std::result::Result<
        crate::output::DescribeVirtualRouterOutput,
        crate::error::DescribeVirtualRouterError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_virtual_router_error(response)
        } else {
            crate::operation_deser::parse_describe_virtual_router_response(response)
        }
    }
}

/// Operation shape for `DescribeVirtualService`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_virtual_service`](crate::client::Client::describe_virtual_service).
///
/// See [`crate::client::fluent_builders::DescribeVirtualService`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeVirtualService {
    _private: (),
}
impl DescribeVirtualService {
    /// Creates a new builder-style object to manufacture [`DescribeVirtualServiceInput`](crate::input::DescribeVirtualServiceInput)
    pub fn builder() -> crate::input::describe_virtual_service_input::Builder {
        crate::input::describe_virtual_service_input::Builder::default()
    }
    /// Creates a new `DescribeVirtualService` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeVirtualService {
    type Output = std::result::Result<
        crate::output::DescribeVirtualServiceOutput,
        crate::error::DescribeVirtualServiceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_virtual_service_error(response)
        } else {
            crate::operation_deser::parse_describe_virtual_service_response(response)
        }
    }
}

/// Operation shape for `ListGatewayRoutes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_gateway_routes`](crate::client::Client::list_gateway_routes).
///
/// See [`crate::client::fluent_builders::ListGatewayRoutes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListGatewayRoutes {
    _private: (),
}
impl ListGatewayRoutes {
    /// Creates a new builder-style object to manufacture [`ListGatewayRoutesInput`](crate::input::ListGatewayRoutesInput)
    pub fn builder() -> crate::input::list_gateway_routes_input::Builder {
        crate::input::list_gateway_routes_input::Builder::default()
    }
    /// Creates a new `ListGatewayRoutes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListGatewayRoutes {
    type Output = std::result::Result<
        crate::output::ListGatewayRoutesOutput,
        crate::error::ListGatewayRoutesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_gateway_routes_error(response)
        } else {
            crate::operation_deser::parse_list_gateway_routes_response(response)
        }
    }
}

/// Operation shape for `ListMeshes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_meshes`](crate::client::Client::list_meshes).
///
/// See [`crate::client::fluent_builders::ListMeshes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListMeshes {
    _private: (),
}
impl ListMeshes {
    /// Creates a new builder-style object to manufacture [`ListMeshesInput`](crate::input::ListMeshesInput)
    pub fn builder() -> crate::input::list_meshes_input::Builder {
        crate::input::list_meshes_input::Builder::default()
    }
    /// Creates a new `ListMeshes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListMeshes {
    type Output =
        std::result::Result<crate::output::ListMeshesOutput, crate::error::ListMeshesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_meshes_error(response)
        } else {
            crate::operation_deser::parse_list_meshes_response(response)
        }
    }
}

/// Operation shape for `ListRoutes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_routes`](crate::client::Client::list_routes).
///
/// See [`crate::client::fluent_builders::ListRoutes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListRoutes {
    _private: (),
}
impl ListRoutes {
    /// Creates a new builder-style object to manufacture [`ListRoutesInput`](crate::input::ListRoutesInput)
    pub fn builder() -> crate::input::list_routes_input::Builder {
        crate::input::list_routes_input::Builder::default()
    }
    /// Creates a new `ListRoutes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListRoutes {
    type Output =
        std::result::Result<crate::output::ListRoutesOutput, crate::error::ListRoutesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_routes_error(response)
        } else {
            crate::operation_deser::parse_list_routes_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `ListVirtualGateways`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_virtual_gateways`](crate::client::Client::list_virtual_gateways).
///
/// See [`crate::client::fluent_builders::ListVirtualGateways`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListVirtualGateways {
    _private: (),
}
impl ListVirtualGateways {
    /// Creates a new builder-style object to manufacture [`ListVirtualGatewaysInput`](crate::input::ListVirtualGatewaysInput)
    pub fn builder() -> crate::input::list_virtual_gateways_input::Builder {
        crate::input::list_virtual_gateways_input::Builder::default()
    }
    /// Creates a new `ListVirtualGateways` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListVirtualGateways {
    type Output = std::result::Result<
        crate::output::ListVirtualGatewaysOutput,
        crate::error::ListVirtualGatewaysError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_virtual_gateways_error(response)
        } else {
            crate::operation_deser::parse_list_virtual_gateways_response(response)
        }
    }
}

/// Operation shape for `ListVirtualNodes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_virtual_nodes`](crate::client::Client::list_virtual_nodes).
///
/// See [`crate::client::fluent_builders::ListVirtualNodes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListVirtualNodes {
    _private: (),
}
impl ListVirtualNodes {
    /// Creates a new builder-style object to manufacture [`ListVirtualNodesInput`](crate::input::ListVirtualNodesInput)
    pub fn builder() -> crate::input::list_virtual_nodes_input::Builder {
        crate::input::list_virtual_nodes_input::Builder::default()
    }
    /// Creates a new `ListVirtualNodes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListVirtualNodes {
    type Output = std::result::Result<
        crate::output::ListVirtualNodesOutput,
        crate::error::ListVirtualNodesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_virtual_nodes_error(response)
        } else {
            crate::operation_deser::parse_list_virtual_nodes_response(response)
        }
    }
}

/// Operation shape for `ListVirtualRouters`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_virtual_routers`](crate::client::Client::list_virtual_routers).
///
/// See [`crate::client::fluent_builders::ListVirtualRouters`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListVirtualRouters {
    _private: (),
}
impl ListVirtualRouters {
    /// Creates a new builder-style object to manufacture [`ListVirtualRoutersInput`](crate::input::ListVirtualRoutersInput)
    pub fn builder() -> crate::input::list_virtual_routers_input::Builder {
        crate::input::list_virtual_routers_input::Builder::default()
    }
    /// Creates a new `ListVirtualRouters` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListVirtualRouters {
    type Output = std::result::Result<
        crate::output::ListVirtualRoutersOutput,
        crate::error::ListVirtualRoutersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_virtual_routers_error(response)
        } else {
            crate::operation_deser::parse_list_virtual_routers_response(response)
        }
    }
}

/// Operation shape for `ListVirtualServices`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_virtual_services`](crate::client::Client::list_virtual_services).
///
/// See [`crate::client::fluent_builders::ListVirtualServices`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListVirtualServices {
    _private: (),
}
impl ListVirtualServices {
    /// Creates a new builder-style object to manufacture [`ListVirtualServicesInput`](crate::input::ListVirtualServicesInput)
    pub fn builder() -> crate::input::list_virtual_services_input::Builder {
        crate::input::list_virtual_services_input::Builder::default()
    }
    /// Creates a new `ListVirtualServices` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListVirtualServices {
    type Output = std::result::Result<
        crate::output::ListVirtualServicesOutput,
        crate::error::ListVirtualServicesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_virtual_services_error(response)
        } else {
            crate::operation_deser::parse_list_virtual_services_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateGatewayRoute`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_gateway_route`](crate::client::Client::update_gateway_route).
///
/// See [`crate::client::fluent_builders::UpdateGatewayRoute`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateGatewayRoute {
    _private: (),
}
impl UpdateGatewayRoute {
    /// Creates a new builder-style object to manufacture [`UpdateGatewayRouteInput`](crate::input::UpdateGatewayRouteInput)
    pub fn builder() -> crate::input::update_gateway_route_input::Builder {
        crate::input::update_gateway_route_input::Builder::default()
    }
    /// Creates a new `UpdateGatewayRoute` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateGatewayRoute {
    type Output = std::result::Result<
        crate::output::UpdateGatewayRouteOutput,
        crate::error::UpdateGatewayRouteError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_gateway_route_error(response)
        } else {
            crate::operation_deser::parse_update_gateway_route_response(response)
        }
    }
}

/// Operation shape for `UpdateMesh`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_mesh`](crate::client::Client::update_mesh).
///
/// See [`crate::client::fluent_builders::UpdateMesh`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateMesh {
    _private: (),
}
impl UpdateMesh {
    /// Creates a new builder-style object to manufacture [`UpdateMeshInput`](crate::input::UpdateMeshInput)
    pub fn builder() -> crate::input::update_mesh_input::Builder {
        crate::input::update_mesh_input::Builder::default()
    }
    /// Creates a new `UpdateMesh` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateMesh {
    type Output =
        std::result::Result<crate::output::UpdateMeshOutput, crate::error::UpdateMeshError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_mesh_error(response)
        } else {
            crate::operation_deser::parse_update_mesh_response(response)
        }
    }
}

/// Operation shape for `UpdateRoute`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_route`](crate::client::Client::update_route).
///
/// See [`crate::client::fluent_builders::UpdateRoute`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateRoute {
    _private: (),
}
impl UpdateRoute {
    /// Creates a new builder-style object to manufacture [`UpdateRouteInput`](crate::input::UpdateRouteInput)
    pub fn builder() -> crate::input::update_route_input::Builder {
        crate::input::update_route_input::Builder::default()
    }
    /// Creates a new `UpdateRoute` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateRoute {
    type Output =
        std::result::Result<crate::output::UpdateRouteOutput, crate::error::UpdateRouteError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_route_error(response)
        } else {
            crate::operation_deser::parse_update_route_response(response)
        }
    }
}

/// Operation shape for `UpdateVirtualGateway`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_virtual_gateway`](crate::client::Client::update_virtual_gateway).
///
/// See [`crate::client::fluent_builders::UpdateVirtualGateway`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateVirtualGateway {
    _private: (),
}
impl UpdateVirtualGateway {
    /// Creates a new builder-style object to manufacture [`UpdateVirtualGatewayInput`](crate::input::UpdateVirtualGatewayInput)
    pub fn builder() -> crate::input::update_virtual_gateway_input::Builder {
        crate::input::update_virtual_gateway_input::Builder::default()
    }
    /// Creates a new `UpdateVirtualGateway` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateVirtualGateway {
    type Output = std::result::Result<
        crate::output::UpdateVirtualGatewayOutput,
        crate::error::UpdateVirtualGatewayError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_virtual_gateway_error(response)
        } else {
            crate::operation_deser::parse_update_virtual_gateway_response(response)
        }
    }
}

/// Operation shape for `UpdateVirtualNode`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_virtual_node`](crate::client::Client::update_virtual_node).
///
/// See [`crate::client::fluent_builders::UpdateVirtualNode`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateVirtualNode {
    _private: (),
}
impl UpdateVirtualNode {
    /// Creates a new builder-style object to manufacture [`UpdateVirtualNodeInput`](crate::input::UpdateVirtualNodeInput)
    pub fn builder() -> crate::input::update_virtual_node_input::Builder {
        crate::input::update_virtual_node_input::Builder::default()
    }
    /// Creates a new `UpdateVirtualNode` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateVirtualNode {
    type Output = std::result::Result<
        crate::output::UpdateVirtualNodeOutput,
        crate::error::UpdateVirtualNodeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_virtual_node_error(response)
        } else {
            crate::operation_deser::parse_update_virtual_node_response(response)
        }
    }
}

/// Operation shape for `UpdateVirtualRouter`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_virtual_router`](crate::client::Client::update_virtual_router).
///
/// See [`crate::client::fluent_builders::UpdateVirtualRouter`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateVirtualRouter {
    _private: (),
}
impl UpdateVirtualRouter {
    /// Creates a new builder-style object to manufacture [`UpdateVirtualRouterInput`](crate::input::UpdateVirtualRouterInput)
    pub fn builder() -> crate::input::update_virtual_router_input::Builder {
        crate::input::update_virtual_router_input::Builder::default()
    }
    /// Creates a new `UpdateVirtualRouter` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateVirtualRouter {
    type Output = std::result::Result<
        crate::output::UpdateVirtualRouterOutput,
        crate::error::UpdateVirtualRouterError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_virtual_router_error(response)
        } else {
            crate::operation_deser::parse_update_virtual_router_response(response)
        }
    }
}

/// Operation shape for `UpdateVirtualService`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_virtual_service`](crate::client::Client::update_virtual_service).
///
/// See [`crate::client::fluent_builders::UpdateVirtualService`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateVirtualService {
    _private: (),
}
impl UpdateVirtualService {
    /// Creates a new builder-style object to manufacture [`UpdateVirtualServiceInput`](crate::input::UpdateVirtualServiceInput)
    pub fn builder() -> crate::input::update_virtual_service_input::Builder {
        crate::input::update_virtual_service_input::Builder::default()
    }
    /// Creates a new `UpdateVirtualService` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateVirtualService {
    type Output = std::result::Result<
        crate::output::UpdateVirtualServiceOutput,
        crate::error::UpdateVirtualServiceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_virtual_service_error(response)
        } else {
            crate::operation_deser::parse_update_virtual_service_response(response)
        }
    }
}
