// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `AppMesh`.
///
/// This client allows ergonomic access to a `AppMesh`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `CreateGatewayRoute` operation.
    ///
    /// See [`CreateGatewayRoute`](crate::client::fluent_builders::CreateGatewayRoute) for more information about the
    /// operation and its arguments.
    pub fn create_gateway_route(&self) -> fluent_builders::CreateGatewayRoute<C, M, R> {
        fluent_builders::CreateGatewayRoute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateMesh` operation.
    ///
    /// See [`CreateMesh`](crate::client::fluent_builders::CreateMesh) for more information about the
    /// operation and its arguments.
    pub fn create_mesh(&self) -> fluent_builders::CreateMesh<C, M, R> {
        fluent_builders::CreateMesh::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateRoute` operation.
    ///
    /// See [`CreateRoute`](crate::client::fluent_builders::CreateRoute) for more information about the
    /// operation and its arguments.
    pub fn create_route(&self) -> fluent_builders::CreateRoute<C, M, R> {
        fluent_builders::CreateRoute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateVirtualGateway` operation.
    ///
    /// See [`CreateVirtualGateway`](crate::client::fluent_builders::CreateVirtualGateway) for more information about the
    /// operation and its arguments.
    pub fn create_virtual_gateway(&self) -> fluent_builders::CreateVirtualGateway<C, M, R> {
        fluent_builders::CreateVirtualGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateVirtualNode` operation.
    ///
    /// See [`CreateVirtualNode`](crate::client::fluent_builders::CreateVirtualNode) for more information about the
    /// operation and its arguments.
    pub fn create_virtual_node(&self) -> fluent_builders::CreateVirtualNode<C, M, R> {
        fluent_builders::CreateVirtualNode::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateVirtualRouter` operation.
    ///
    /// See [`CreateVirtualRouter`](crate::client::fluent_builders::CreateVirtualRouter) for more information about the
    /// operation and its arguments.
    pub fn create_virtual_router(&self) -> fluent_builders::CreateVirtualRouter<C, M, R> {
        fluent_builders::CreateVirtualRouter::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateVirtualService` operation.
    ///
    /// See [`CreateVirtualService`](crate::client::fluent_builders::CreateVirtualService) for more information about the
    /// operation and its arguments.
    pub fn create_virtual_service(&self) -> fluent_builders::CreateVirtualService<C, M, R> {
        fluent_builders::CreateVirtualService::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteGatewayRoute` operation.
    ///
    /// See [`DeleteGatewayRoute`](crate::client::fluent_builders::DeleteGatewayRoute) for more information about the
    /// operation and its arguments.
    pub fn delete_gateway_route(&self) -> fluent_builders::DeleteGatewayRoute<C, M, R> {
        fluent_builders::DeleteGatewayRoute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteMesh` operation.
    ///
    /// See [`DeleteMesh`](crate::client::fluent_builders::DeleteMesh) for more information about the
    /// operation and its arguments.
    pub fn delete_mesh(&self) -> fluent_builders::DeleteMesh<C, M, R> {
        fluent_builders::DeleteMesh::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRoute` operation.
    ///
    /// See [`DeleteRoute`](crate::client::fluent_builders::DeleteRoute) for more information about the
    /// operation and its arguments.
    pub fn delete_route(&self) -> fluent_builders::DeleteRoute<C, M, R> {
        fluent_builders::DeleteRoute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteVirtualGateway` operation.
    ///
    /// See [`DeleteVirtualGateway`](crate::client::fluent_builders::DeleteVirtualGateway) for more information about the
    /// operation and its arguments.
    pub fn delete_virtual_gateway(&self) -> fluent_builders::DeleteVirtualGateway<C, M, R> {
        fluent_builders::DeleteVirtualGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteVirtualNode` operation.
    ///
    /// See [`DeleteVirtualNode`](crate::client::fluent_builders::DeleteVirtualNode) for more information about the
    /// operation and its arguments.
    pub fn delete_virtual_node(&self) -> fluent_builders::DeleteVirtualNode<C, M, R> {
        fluent_builders::DeleteVirtualNode::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteVirtualRouter` operation.
    ///
    /// See [`DeleteVirtualRouter`](crate::client::fluent_builders::DeleteVirtualRouter) for more information about the
    /// operation and its arguments.
    pub fn delete_virtual_router(&self) -> fluent_builders::DeleteVirtualRouter<C, M, R> {
        fluent_builders::DeleteVirtualRouter::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteVirtualService` operation.
    ///
    /// See [`DeleteVirtualService`](crate::client::fluent_builders::DeleteVirtualService) for more information about the
    /// operation and its arguments.
    pub fn delete_virtual_service(&self) -> fluent_builders::DeleteVirtualService<C, M, R> {
        fluent_builders::DeleteVirtualService::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeGatewayRoute` operation.
    ///
    /// See [`DescribeGatewayRoute`](crate::client::fluent_builders::DescribeGatewayRoute) for more information about the
    /// operation and its arguments.
    pub fn describe_gateway_route(&self) -> fluent_builders::DescribeGatewayRoute<C, M, R> {
        fluent_builders::DescribeGatewayRoute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeMesh` operation.
    ///
    /// See [`DescribeMesh`](crate::client::fluent_builders::DescribeMesh) for more information about the
    /// operation and its arguments.
    pub fn describe_mesh(&self) -> fluent_builders::DescribeMesh<C, M, R> {
        fluent_builders::DescribeMesh::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeRoute` operation.
    ///
    /// See [`DescribeRoute`](crate::client::fluent_builders::DescribeRoute) for more information about the
    /// operation and its arguments.
    pub fn describe_route(&self) -> fluent_builders::DescribeRoute<C, M, R> {
        fluent_builders::DescribeRoute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeVirtualGateway` operation.
    ///
    /// See [`DescribeVirtualGateway`](crate::client::fluent_builders::DescribeVirtualGateway) for more information about the
    /// operation and its arguments.
    pub fn describe_virtual_gateway(&self) -> fluent_builders::DescribeVirtualGateway<C, M, R> {
        fluent_builders::DescribeVirtualGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeVirtualNode` operation.
    ///
    /// See [`DescribeVirtualNode`](crate::client::fluent_builders::DescribeVirtualNode) for more information about the
    /// operation and its arguments.
    pub fn describe_virtual_node(&self) -> fluent_builders::DescribeVirtualNode<C, M, R> {
        fluent_builders::DescribeVirtualNode::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeVirtualRouter` operation.
    ///
    /// See [`DescribeVirtualRouter`](crate::client::fluent_builders::DescribeVirtualRouter) for more information about the
    /// operation and its arguments.
    pub fn describe_virtual_router(&self) -> fluent_builders::DescribeVirtualRouter<C, M, R> {
        fluent_builders::DescribeVirtualRouter::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeVirtualService` operation.
    ///
    /// See [`DescribeVirtualService`](crate::client::fluent_builders::DescribeVirtualService) for more information about the
    /// operation and its arguments.
    pub fn describe_virtual_service(&self) -> fluent_builders::DescribeVirtualService<C, M, R> {
        fluent_builders::DescribeVirtualService::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListGatewayRoutes` operation.
    ///
    /// See [`ListGatewayRoutes`](crate::client::fluent_builders::ListGatewayRoutes) for more information about the
    /// operation and its arguments.
    pub fn list_gateway_routes(&self) -> fluent_builders::ListGatewayRoutes<C, M, R> {
        fluent_builders::ListGatewayRoutes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListMeshes` operation.
    ///
    /// See [`ListMeshes`](crate::client::fluent_builders::ListMeshes) for more information about the
    /// operation and its arguments.
    pub fn list_meshes(&self) -> fluent_builders::ListMeshes<C, M, R> {
        fluent_builders::ListMeshes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListRoutes` operation.
    ///
    /// See [`ListRoutes`](crate::client::fluent_builders::ListRoutes) for more information about the
    /// operation and its arguments.
    pub fn list_routes(&self) -> fluent_builders::ListRoutes<C, M, R> {
        fluent_builders::ListRoutes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListVirtualGateways` operation.
    ///
    /// See [`ListVirtualGateways`](crate::client::fluent_builders::ListVirtualGateways) for more information about the
    /// operation and its arguments.
    pub fn list_virtual_gateways(&self) -> fluent_builders::ListVirtualGateways<C, M, R> {
        fluent_builders::ListVirtualGateways::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListVirtualNodes` operation.
    ///
    /// See [`ListVirtualNodes`](crate::client::fluent_builders::ListVirtualNodes) for more information about the
    /// operation and its arguments.
    pub fn list_virtual_nodes(&self) -> fluent_builders::ListVirtualNodes<C, M, R> {
        fluent_builders::ListVirtualNodes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListVirtualRouters` operation.
    ///
    /// See [`ListVirtualRouters`](crate::client::fluent_builders::ListVirtualRouters) for more information about the
    /// operation and its arguments.
    pub fn list_virtual_routers(&self) -> fluent_builders::ListVirtualRouters<C, M, R> {
        fluent_builders::ListVirtualRouters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListVirtualServices` operation.
    ///
    /// See [`ListVirtualServices`](crate::client::fluent_builders::ListVirtualServices) for more information about the
    /// operation and its arguments.
    pub fn list_virtual_services(&self) -> fluent_builders::ListVirtualServices<C, M, R> {
        fluent_builders::ListVirtualServices::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateGatewayRoute` operation.
    ///
    /// See [`UpdateGatewayRoute`](crate::client::fluent_builders::UpdateGatewayRoute) for more information about the
    /// operation and its arguments.
    pub fn update_gateway_route(&self) -> fluent_builders::UpdateGatewayRoute<C, M, R> {
        fluent_builders::UpdateGatewayRoute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateMesh` operation.
    ///
    /// See [`UpdateMesh`](crate::client::fluent_builders::UpdateMesh) for more information about the
    /// operation and its arguments.
    pub fn update_mesh(&self) -> fluent_builders::UpdateMesh<C, M, R> {
        fluent_builders::UpdateMesh::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateRoute` operation.
    ///
    /// See [`UpdateRoute`](crate::client::fluent_builders::UpdateRoute) for more information about the
    /// operation and its arguments.
    pub fn update_route(&self) -> fluent_builders::UpdateRoute<C, M, R> {
        fluent_builders::UpdateRoute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateVirtualGateway` operation.
    ///
    /// See [`UpdateVirtualGateway`](crate::client::fluent_builders::UpdateVirtualGateway) for more information about the
    /// operation and its arguments.
    pub fn update_virtual_gateway(&self) -> fluent_builders::UpdateVirtualGateway<C, M, R> {
        fluent_builders::UpdateVirtualGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateVirtualNode` operation.
    ///
    /// See [`UpdateVirtualNode`](crate::client::fluent_builders::UpdateVirtualNode) for more information about the
    /// operation and its arguments.
    pub fn update_virtual_node(&self) -> fluent_builders::UpdateVirtualNode<C, M, R> {
        fluent_builders::UpdateVirtualNode::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateVirtualRouter` operation.
    ///
    /// See [`UpdateVirtualRouter`](crate::client::fluent_builders::UpdateVirtualRouter) for more information about the
    /// operation and its arguments.
    pub fn update_virtual_router(&self) -> fluent_builders::UpdateVirtualRouter<C, M, R> {
        fluent_builders::UpdateVirtualRouter::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateVirtualService` operation.
    ///
    /// See [`UpdateVirtualService`](crate::client::fluent_builders::UpdateVirtualService) for more information about the
    /// operation and its arguments.
    pub fn update_virtual_service(&self) -> fluent_builders::UpdateVirtualService<C, M, R> {
        fluent_builders::UpdateVirtualService::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateGatewayRoute`.
    ///
    /// <p>Creates a gateway route.</p>
    /// <p>A gateway route is attached to a virtual gateway and routes traffic to an existing
    /// virtual service. If a route matches a request, it can distribute traffic to a target
    /// virtual service.</p>
    /// <p>For more information about gateway routes, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/gateway-routes.html">Gateway routes</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateGatewayRoute<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_gateway_route_input::Builder,
    }
    impl<C, M, R> CreateGatewayRoute<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateGatewayRoute`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateGatewayRouteOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateGatewayRouteError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateGatewayRouteInputOperationOutputAlias,
                crate::output::CreateGatewayRouteOutput,
                crate::error::CreateGatewayRouteError,
                crate::input::CreateGatewayRouteInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name to use for the gateway route.</p>
        pub fn gateway_route_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_route_name(inp);
            self
        }
        /// <p>The name to use for the gateway route.</p>
        pub fn set_gateway_route_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_gateway_route_name(input);
            self
        }
        /// <p>The name of the service mesh to create the gateway route in.</p>
        pub fn mesh_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(inp);
            self
        }
        /// <p>The name of the service mesh to create the gateway route in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The name of the virtual gateway to associate the gateway route with. If the virtual
        /// gateway is in a shared mesh, then you must be the owner of the virtual gateway
        /// resource.</p>
        pub fn virtual_gateway_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_gateway_name(inp);
            self
        }
        /// <p>The name of the virtual gateway to associate the gateway route with. If the virtual
        /// gateway is in a shared mesh, then you must be the owner of the virtual gateway
        /// resource.</p>
        pub fn set_virtual_gateway_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_gateway_name(input);
            self
        }
        /// <p>The gateway route specification to apply.</p>
        pub fn spec(mut self, inp: crate::model::GatewayRouteSpec) -> Self {
            self.inner = self.inner.spec(inp);
            self
        }
        /// <p>The gateway route specification to apply.</p>
        pub fn set_spec(
            mut self,
            input: std::option::Option<crate::model::GatewayRouteSpec>,
        ) -> Self {
            self.inner = self.inner.set_spec(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Optional metadata that you can apply to the gateway route to assist with categorization
        /// and organization. Each tag consists of a key and an optional value, both of which you
        /// define. Tag keys can have a maximum character length of 128 characters, and tag values can have
        /// a maximum length of 256 characters.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::TagRef>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Optional metadata that you can apply to the gateway route to assist with categorization
        /// and organization. Each tag consists of a key and an optional value, both of which you
        /// define. Tag keys can have a maximum character length of 128 characters, and tag values can have
        /// a maximum length of 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagRef>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then
        /// the account that you specify must share the mesh with your account before you can create
        /// the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_owner(inp);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then
        /// the account that you specify must share the mesh with your account before you can create
        /// the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateMesh`.
    ///
    /// <p>Creates a service mesh.</p>
    /// <p> A service mesh is a logical boundary for network traffic between services that are
    /// represented by resources within the mesh. After you create your service mesh, you can
    /// create virtual services, virtual nodes, virtual routers, and routes to distribute traffic
    /// between the applications in your mesh.</p>
    /// <p>For more information about service meshes, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/meshes.html">Service meshes</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateMesh<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_mesh_input::Builder,
    }
    impl<C, M, R> CreateMesh<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateMesh`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateMeshOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateMeshError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateMeshInputOperationOutputAlias,
                crate::output::CreateMeshOutput,
                crate::error::CreateMeshError,
                crate::input::CreateMeshInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name to use for the service mesh.</p>
        pub fn mesh_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(inp);
            self
        }
        /// <p>The name to use for the service mesh.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The service mesh specification to apply.</p>
        pub fn spec(mut self, inp: crate::model::MeshSpec) -> Self {
            self.inner = self.inner.spec(inp);
            self
        }
        /// <p>The service mesh specification to apply.</p>
        pub fn set_spec(mut self, input: std::option::Option<crate::model::MeshSpec>) -> Self {
            self.inner = self.inner.set_spec(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Optional metadata that you can apply to the service mesh to assist with categorization
        /// and organization. Each tag consists of a key and an optional value, both of which you
        /// define. Tag keys can have a maximum character length of 128 characters, and tag values can have
        /// a maximum length of 256 characters.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::TagRef>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Optional metadata that you can apply to the service mesh to assist with categorization
        /// and organization. Each tag consists of a key and an optional value, both of which you
        /// define. Tag keys can have a maximum character length of 128 characters, and tag values can have
        /// a maximum length of 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagRef>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRoute`.
    ///
    /// <p>Creates a route that is associated with a virtual router.</p>
    /// <p> You can route several different protocols and define a retry policy for a route.
    /// Traffic can be routed to one or more virtual nodes.</p>
    /// <p>For more information about routes, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/routes.html">Routes</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateRoute<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_route_input::Builder,
    }
    impl<C, M, R> CreateRoute<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateRoute`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRouteOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRouteError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateRouteInputOperationOutputAlias,
                crate::output::CreateRouteOutput,
                crate::error::CreateRouteError,
                crate::input::CreateRouteInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name to use for the route.</p>
        pub fn route_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.route_name(inp);
            self
        }
        /// <p>The name to use for the route.</p>
        pub fn set_route_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_route_name(input);
            self
        }
        /// <p>The name of the service mesh to create the route in.</p>
        pub fn mesh_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(inp);
            self
        }
        /// <p>The name of the service mesh to create the route in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The name of the virtual router in which to create the route. If the virtual router is in
        /// a shared mesh, then you must be the owner of the virtual router resource.</p>
        pub fn virtual_router_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_router_name(inp);
            self
        }
        /// <p>The name of the virtual router in which to create the route. If the virtual router is in
        /// a shared mesh, then you must be the owner of the virtual router resource.</p>
        pub fn set_virtual_router_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_router_name(input);
            self
        }
        /// <p>The route specification to apply.</p>
        pub fn spec(mut self, inp: crate::model::RouteSpec) -> Self {
            self.inner = self.inner.spec(inp);
            self
        }
        /// <p>The route specification to apply.</p>
        pub fn set_spec(mut self, input: std::option::Option<crate::model::RouteSpec>) -> Self {
            self.inner = self.inner.set_spec(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Optional metadata that you can apply to the route to assist with categorization and
        /// organization. Each tag consists of a key and an optional value, both of which you define.
        /// Tag keys can have a maximum character length of 128 characters, and tag values can have
        /// a maximum length of 256 characters.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::TagRef>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Optional metadata that you can apply to the route to assist with categorization and
        /// organization. Each tag consists of a key and an optional value, both of which you define.
        /// Tag keys can have a maximum character length of 128 characters, and tag values can have
        /// a maximum length of 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagRef>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then
        /// the account that you specify must share the mesh with your account before you can create
        /// the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_owner(inp);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then
        /// the account that you specify must share the mesh with your account before you can create
        /// the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateVirtualGateway`.
    ///
    /// <p>Creates a virtual gateway.</p>
    /// <p>A virtual gateway allows resources outside your mesh to communicate to resources that
    /// are inside your mesh. The virtual gateway represents an Envoy proxy running in an Amazon ECS
    /// task, in a Kubernetes service, or on an Amazon EC2 instance. Unlike a virtual node, which
    /// represents an Envoy running with an application, a virtual gateway represents Envoy
    /// deployed by itself.</p>
    /// <p>For more information about virtual gateways, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_gateways.html">Virtual gateways</a>. </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateVirtualGateway<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_virtual_gateway_input::Builder,
    }
    impl<C, M, R> CreateVirtualGateway<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateVirtualGateway`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateVirtualGatewayOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateVirtualGatewayError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateVirtualGatewayInputOperationOutputAlias,
                crate::output::CreateVirtualGatewayOutput,
                crate::error::CreateVirtualGatewayError,
                crate::input::CreateVirtualGatewayInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name to use for the virtual gateway.</p>
        pub fn virtual_gateway_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_gateway_name(inp);
            self
        }
        /// <p>The name to use for the virtual gateway.</p>
        pub fn set_virtual_gateway_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_gateway_name(input);
            self
        }
        /// <p>The name of the service mesh to create the virtual gateway in.</p>
        pub fn mesh_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(inp);
            self
        }
        /// <p>The name of the service mesh to create the virtual gateway in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The virtual gateway specification to apply.</p>
        pub fn spec(mut self, inp: crate::model::VirtualGatewaySpec) -> Self {
            self.inner = self.inner.spec(inp);
            self
        }
        /// <p>The virtual gateway specification to apply.</p>
        pub fn set_spec(
            mut self,
            input: std::option::Option<crate::model::VirtualGatewaySpec>,
        ) -> Self {
            self.inner = self.inner.set_spec(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Optional metadata that you can apply to the virtual gateway to assist with
        /// categorization and organization. Each tag consists of a key and an optional value, both of
        /// which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have
        /// a maximum length of 256 characters.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::TagRef>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Optional metadata that you can apply to the virtual gateway to assist with
        /// categorization and organization. Each tag consists of a key and an optional value, both of
        /// which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have
        /// a maximum length of 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagRef>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then
        /// the account that you specify must share the mesh with your account before you can create
        /// the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_owner(inp);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then
        /// the account that you specify must share the mesh with your account before you can create
        /// the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateVirtualNode`.
    ///
    /// <p>Creates a virtual node within a service mesh.</p>
    /// <p> A virtual node acts as a logical pointer to a particular task group, such as an Amazon ECS
    /// service or a Kubernetes deployment. When you create a virtual node, you can specify the
    /// service discovery information for your task group, and whether the proxy running in a task
    /// group will communicate with other proxies using Transport Layer Security (TLS).</p>
    /// <p>You define a <code>listener</code> for any inbound traffic that your virtual node
    /// expects. Any virtual service that your virtual node expects to communicate to is specified
    /// as a <code>backend</code>.</p>
    /// <p>The response metadata for your new virtual node contains the <code>arn</code> that is
    /// associated with the virtual node. Set this value to the full ARN; for example,
    /// <code>arn:aws:appmesh:us-west-2:123456789012:myMesh/default/virtualNode/myApp</code>)
    /// as the <code>APPMESH_RESOURCE_ARN</code> environment variable for your task group's Envoy
    /// proxy container in your task definition or pod spec. This is then mapped to the
    /// <code>node.id</code> and <code>node.cluster</code> Envoy parameters.</p>
    /// <note>
    /// <p>By default, App Mesh uses the name of the resource you specified in
    /// <code>APPMESH_RESOURCE_ARN</code> when Envoy is referring to itself in metrics and
    /// traces. You can override this behavior by setting the
    /// <code>APPMESH_RESOURCE_CLUSTER</code> environment variable with your own name.</p>
    /// </note>
    /// <p>For more information about virtual nodes, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_nodes.html">Virtual nodes</a>. You must be using <code>1.15.0</code> or later of the Envoy image when
    /// setting these variables. For more information aboutApp Mesh Envoy variables, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/envoy.html">Envoy image</a> in
    /// the AWS App Mesh User Guide.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateVirtualNode<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_virtual_node_input::Builder,
    }
    impl<C, M, R> CreateVirtualNode<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateVirtualNode`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateVirtualNodeOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateVirtualNodeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateVirtualNodeInputOperationOutputAlias,
                crate::output::CreateVirtualNodeOutput,
                crate::error::CreateVirtualNodeError,
                crate::input::CreateVirtualNodeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name to use for the virtual node.</p>
        pub fn virtual_node_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_node_name(inp);
            self
        }
        /// <p>The name to use for the virtual node.</p>
        pub fn set_virtual_node_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_node_name(input);
            self
        }
        /// <p>The name of the service mesh to create the virtual node in.</p>
        pub fn mesh_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(inp);
            self
        }
        /// <p>The name of the service mesh to create the virtual node in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The virtual node specification to apply.</p>
        pub fn spec(mut self, inp: crate::model::VirtualNodeSpec) -> Self {
            self.inner = self.inner.spec(inp);
            self
        }
        /// <p>The virtual node specification to apply.</p>
        pub fn set_spec(
            mut self,
            input: std::option::Option<crate::model::VirtualNodeSpec>,
        ) -> Self {
            self.inner = self.inner.set_spec(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Optional metadata that you can apply to the virtual node to assist with categorization
        /// and organization. Each tag consists of a key and an optional value, both of which you
        /// define. Tag keys can have a maximum character length of 128 characters, and tag values can have
        /// a maximum length of 256 characters.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::TagRef>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Optional metadata that you can apply to the virtual node to assist with categorization
        /// and organization. Each tag consists of a key and an optional value, both of which you
        /// define. Tag keys can have a maximum character length of 128 characters, and tag values can have
        /// a maximum length of 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagRef>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then
        /// the account that you specify must share the mesh with your account before you can create
        /// the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_owner(inp);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then
        /// the account that you specify must share the mesh with your account before you can create
        /// the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateVirtualRouter`.
    ///
    /// <p>Creates a virtual router within a service mesh.</p>
    /// <p>Specify a <code>listener</code> for any inbound traffic that your virtual router
    /// receives. Create a virtual router for each protocol and port that you need to route.
    /// Virtual routers handle traffic for one or more virtual services within your mesh. After you
    /// create your virtual router, create and associate routes for your virtual router that direct
    /// incoming requests to different virtual nodes.</p>
    /// <p>For more information about virtual routers, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_routers.html">Virtual routers</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateVirtualRouter<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_virtual_router_input::Builder,
    }
    impl<C, M, R> CreateVirtualRouter<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateVirtualRouter`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateVirtualRouterOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateVirtualRouterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateVirtualRouterInputOperationOutputAlias,
                crate::output::CreateVirtualRouterOutput,
                crate::error::CreateVirtualRouterError,
                crate::input::CreateVirtualRouterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name to use for the virtual router.</p>
        pub fn virtual_router_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_router_name(inp);
            self
        }
        /// <p>The name to use for the virtual router.</p>
        pub fn set_virtual_router_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_router_name(input);
            self
        }
        /// <p>The name of the service mesh to create the virtual router in.</p>
        pub fn mesh_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(inp);
            self
        }
        /// <p>The name of the service mesh to create the virtual router in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The virtual router specification to apply.</p>
        pub fn spec(mut self, inp: crate::model::VirtualRouterSpec) -> Self {
            self.inner = self.inner.spec(inp);
            self
        }
        /// <p>The virtual router specification to apply.</p>
        pub fn set_spec(
            mut self,
            input: std::option::Option<crate::model::VirtualRouterSpec>,
        ) -> Self {
            self.inner = self.inner.set_spec(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Optional metadata that you can apply to the virtual router to assist with categorization
        /// and organization. Each tag consists of a key and an optional value, both of which you
        /// define. Tag keys can have a maximum character length of 128 characters, and tag values can have
        /// a maximum length of 256 characters.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::TagRef>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Optional metadata that you can apply to the virtual router to assist with categorization
        /// and organization. Each tag consists of a key and an optional value, both of which you
        /// define. Tag keys can have a maximum character length of 128 characters, and tag values can have
        /// a maximum length of 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagRef>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then
        /// the account that you specify must share the mesh with your account before you can create
        /// the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_owner(inp);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then
        /// the account that you specify must share the mesh with your account before you can create
        /// the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateVirtualService`.
    ///
    /// <p>Creates a virtual service within a service mesh.</p>
    /// <p>A virtual service is an abstraction of a real service that is provided by a virtual node
    /// directly or indirectly by means of a virtual router. Dependent services call your virtual
    /// service by its <code>virtualServiceName</code>, and those requests are routed to the
    /// virtual node or virtual router that is specified as the provider for the virtual
    /// service.</p>
    /// <p>For more information about virtual services, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_services.html">Virtual services</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateVirtualService<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_virtual_service_input::Builder,
    }
    impl<C, M, R> CreateVirtualService<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateVirtualService`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateVirtualServiceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateVirtualServiceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateVirtualServiceInputOperationOutputAlias,
                crate::output::CreateVirtualServiceOutput,
                crate::error::CreateVirtualServiceError,
                crate::input::CreateVirtualServiceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name to use for the virtual service.</p>
        pub fn virtual_service_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_service_name(inp);
            self
        }
        /// <p>The name to use for the virtual service.</p>
        pub fn set_virtual_service_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_service_name(input);
            self
        }
        /// <p>The name of the service mesh to create the virtual service in.</p>
        pub fn mesh_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(inp);
            self
        }
        /// <p>The name of the service mesh to create the virtual service in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The virtual service specification to apply.</p>
        pub fn spec(mut self, inp: crate::model::VirtualServiceSpec) -> Self {
            self.inner = self.inner.spec(inp);
            self
        }
        /// <p>The virtual service specification to apply.</p>
        pub fn set_spec(
            mut self,
            input: std::option::Option<crate::model::VirtualServiceSpec>,
        ) -> Self {
            self.inner = self.inner.set_spec(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Optional metadata that you can apply to the virtual service to assist with
        /// categorization and organization. Each tag consists of a key and an optional value, both of
        /// which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have
        /// a maximum length of 256 characters.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::TagRef>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Optional metadata that you can apply to the virtual service to assist with
        /// categorization and organization. Each tag consists of a key and an optional value, both of
        /// which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have
        /// a maximum length of 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagRef>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then
        /// the account that you specify must share the mesh with your account before you can create
        /// the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_owner(inp);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then
        /// the account that you specify must share the mesh with your account before you can create
        /// the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteGatewayRoute`.
    ///
    /// <p>Deletes an existing gateway route.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteGatewayRoute<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_gateway_route_input::Builder,
    }
    impl<C, M, R> DeleteGatewayRoute<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteGatewayRoute`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteGatewayRouteOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteGatewayRouteError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteGatewayRouteInputOperationOutputAlias,
                crate::output::DeleteGatewayRouteOutput,
                crate::error::DeleteGatewayRouteError,
                crate::input::DeleteGatewayRouteInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the gateway route to delete.</p>
        pub fn gateway_route_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_route_name(inp);
            self
        }
        /// <p>The name of the gateway route to delete.</p>
        pub fn set_gateway_route_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_gateway_route_name(input);
            self
        }
        /// <p>The name of the service mesh to delete the gateway route from.</p>
        pub fn mesh_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(inp);
            self
        }
        /// <p>The name of the service mesh to delete the gateway route from.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The name of the virtual gateway to delete the route from.</p>
        pub fn virtual_gateway_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_gateway_name(inp);
            self
        }
        /// <p>The name of the virtual gateway to delete the route from.</p>
        pub fn set_virtual_gateway_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_gateway_name(input);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_owner(inp);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteMesh`.
    ///
    /// <p>Deletes an existing service mesh.</p>
    /// <p>You must delete all resources (virtual services, routes, virtual routers, and virtual
    /// nodes) in the service mesh before you can delete the mesh itself.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteMesh<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_mesh_input::Builder,
    }
    impl<C, M, R> DeleteMesh<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteMesh`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteMeshOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteMeshError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteMeshInputOperationOutputAlias,
                crate::output::DeleteMeshOutput,
                crate::error::DeleteMeshError,
                crate::input::DeleteMeshInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the service mesh to delete.</p>
        pub fn mesh_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(inp);
            self
        }
        /// <p>The name of the service mesh to delete.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRoute`.
    ///
    /// <p>Deletes an existing route.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteRoute<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_route_input::Builder,
    }
    impl<C, M, R> DeleteRoute<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRoute`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRouteOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRouteError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRouteInputOperationOutputAlias,
                crate::output::DeleteRouteOutput,
                crate::error::DeleteRouteError,
                crate::input::DeleteRouteInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the route to delete.</p>
        pub fn route_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.route_name(inp);
            self
        }
        /// <p>The name of the route to delete.</p>
        pub fn set_route_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_route_name(input);
            self
        }
        /// <p>The name of the service mesh to delete the route in.</p>
        pub fn mesh_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(inp);
            self
        }
        /// <p>The name of the service mesh to delete the route in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The name of the virtual router to delete the route in.</p>
        pub fn virtual_router_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_router_name(inp);
            self
        }
        /// <p>The name of the virtual router to delete the route in.</p>
        pub fn set_virtual_router_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_router_name(input);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_owner(inp);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteVirtualGateway`.
    ///
    /// <p>Deletes an existing virtual gateway. You cannot delete a virtual gateway if any gateway
    /// routes are associated to it.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteVirtualGateway<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_virtual_gateway_input::Builder,
    }
    impl<C, M, R> DeleteVirtualGateway<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteVirtualGateway`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteVirtualGatewayOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteVirtualGatewayError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteVirtualGatewayInputOperationOutputAlias,
                crate::output::DeleteVirtualGatewayOutput,
                crate::error::DeleteVirtualGatewayError,
                crate::input::DeleteVirtualGatewayInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the virtual gateway to delete.</p>
        pub fn virtual_gateway_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_gateway_name(inp);
            self
        }
        /// <p>The name of the virtual gateway to delete.</p>
        pub fn set_virtual_gateway_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_gateway_name(input);
            self
        }
        /// <p>The name of the service mesh to delete the virtual gateway from.</p>
        pub fn mesh_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(inp);
            self
        }
        /// <p>The name of the service mesh to delete the virtual gateway from.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_owner(inp);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteVirtualNode`.
    ///
    /// <p>Deletes an existing virtual node.</p>
    /// <p>You must delete any virtual services that list a virtual node as a service provider
    /// before you can delete the virtual node itself.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteVirtualNode<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_virtual_node_input::Builder,
    }
    impl<C, M, R> DeleteVirtualNode<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteVirtualNode`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteVirtualNodeOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteVirtualNodeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteVirtualNodeInputOperationOutputAlias,
                crate::output::DeleteVirtualNodeOutput,
                crate::error::DeleteVirtualNodeError,
                crate::input::DeleteVirtualNodeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the virtual node to delete.</p>
        pub fn virtual_node_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_node_name(inp);
            self
        }
        /// <p>The name of the virtual node to delete.</p>
        pub fn set_virtual_node_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_node_name(input);
            self
        }
        /// <p>The name of the service mesh to delete the virtual node in.</p>
        pub fn mesh_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(inp);
            self
        }
        /// <p>The name of the service mesh to delete the virtual node in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_owner(inp);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteVirtualRouter`.
    ///
    /// <p>Deletes an existing virtual router.</p>
    /// <p>You must delete any routes associated with the virtual router before you can delete the
    /// router itself.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteVirtualRouter<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_virtual_router_input::Builder,
    }
    impl<C, M, R> DeleteVirtualRouter<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteVirtualRouter`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteVirtualRouterOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteVirtualRouterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteVirtualRouterInputOperationOutputAlias,
                crate::output::DeleteVirtualRouterOutput,
                crate::error::DeleteVirtualRouterError,
                crate::input::DeleteVirtualRouterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the virtual router to delete.</p>
        pub fn virtual_router_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_router_name(inp);
            self
        }
        /// <p>The name of the virtual router to delete.</p>
        pub fn set_virtual_router_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_router_name(input);
            self
        }
        /// <p>The name of the service mesh to delete the virtual router in.</p>
        pub fn mesh_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(inp);
            self
        }
        /// <p>The name of the service mesh to delete the virtual router in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_owner(inp);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteVirtualService`.
    ///
    /// <p>Deletes an existing virtual service.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteVirtualService<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_virtual_service_input::Builder,
    }
    impl<C, M, R> DeleteVirtualService<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteVirtualService`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteVirtualServiceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteVirtualServiceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteVirtualServiceInputOperationOutputAlias,
                crate::output::DeleteVirtualServiceOutput,
                crate::error::DeleteVirtualServiceError,
                crate::input::DeleteVirtualServiceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the virtual service to delete.</p>
        pub fn virtual_service_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_service_name(inp);
            self
        }
        /// <p>The name of the virtual service to delete.</p>
        pub fn set_virtual_service_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_service_name(input);
            self
        }
        /// <p>The name of the service mesh to delete the virtual service in.</p>
        pub fn mesh_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(inp);
            self
        }
        /// <p>The name of the service mesh to delete the virtual service in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_owner(inp);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeGatewayRoute`.
    ///
    /// <p>Describes an existing gateway route.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeGatewayRoute<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_gateway_route_input::Builder,
    }
    impl<C, M, R> DescribeGatewayRoute<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeGatewayRoute`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeGatewayRouteOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeGatewayRouteError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeGatewayRouteInputOperationOutputAlias,
                crate::output::DescribeGatewayRouteOutput,
                crate::error::DescribeGatewayRouteError,
                crate::input::DescribeGatewayRouteInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the gateway route to describe.</p>
        pub fn gateway_route_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_route_name(inp);
            self
        }
        /// <p>The name of the gateway route to describe.</p>
        pub fn set_gateway_route_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_gateway_route_name(input);
            self
        }
        /// <p>The name of the service mesh that the gateway route resides in.</p>
        pub fn mesh_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(inp);
            self
        }
        /// <p>The name of the service mesh that the gateway route resides in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The name of the virtual gateway that the gateway route is associated with.</p>
        pub fn virtual_gateway_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_gateway_name(inp);
            self
        }
        /// <p>The name of the virtual gateway that the gateway route is associated with.</p>
        pub fn set_virtual_gateway_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_gateway_name(input);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_owner(inp);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeMesh`.
    ///
    /// <p>Describes an existing service mesh.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeMesh<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_mesh_input::Builder,
    }
    impl<C, M, R> DescribeMesh<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeMesh`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeMeshOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeMeshError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeMeshInputOperationOutputAlias,
                crate::output::DescribeMeshOutput,
                crate::error::DescribeMeshError,
                crate::input::DescribeMeshInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the service mesh to describe.</p>
        pub fn mesh_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(inp);
            self
        }
        /// <p>The name of the service mesh to describe.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_owner(inp);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeRoute`.
    ///
    /// <p>Describes an existing route.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeRoute<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_route_input::Builder,
    }
    impl<C, M, R> DescribeRoute<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeRoute`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeRouteOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeRouteError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeRouteInputOperationOutputAlias,
                crate::output::DescribeRouteOutput,
                crate::error::DescribeRouteError,
                crate::input::DescribeRouteInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the route to describe.</p>
        pub fn route_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.route_name(inp);
            self
        }
        /// <p>The name of the route to describe.</p>
        pub fn set_route_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_route_name(input);
            self
        }
        /// <p>The name of the service mesh that the route resides in.</p>
        pub fn mesh_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(inp);
            self
        }
        /// <p>The name of the service mesh that the route resides in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_owner(inp);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_owner(input);
            self
        }
        /// <p>The name of the virtual router that the route is associated with.</p>
        pub fn virtual_router_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_router_name(inp);
            self
        }
        /// <p>The name of the virtual router that the route is associated with.</p>
        pub fn set_virtual_router_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_router_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeVirtualGateway`.
    ///
    /// <p>Describes an existing virtual gateway.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeVirtualGateway<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_virtual_gateway_input::Builder,
    }
    impl<C, M, R> DescribeVirtualGateway<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeVirtualGateway`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeVirtualGatewayOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeVirtualGatewayError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeVirtualGatewayInputOperationOutputAlias,
                crate::output::DescribeVirtualGatewayOutput,
                crate::error::DescribeVirtualGatewayError,
                crate::input::DescribeVirtualGatewayInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the virtual gateway to describe.</p>
        pub fn virtual_gateway_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_gateway_name(inp);
            self
        }
        /// <p>The name of the virtual gateway to describe.</p>
        pub fn set_virtual_gateway_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_gateway_name(input);
            self
        }
        /// <p>The name of the service mesh that the gateway route resides in.</p>
        pub fn mesh_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(inp);
            self
        }
        /// <p>The name of the service mesh that the gateway route resides in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_owner(inp);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeVirtualNode`.
    ///
    /// <p>Describes an existing virtual node.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeVirtualNode<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_virtual_node_input::Builder,
    }
    impl<C, M, R> DescribeVirtualNode<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeVirtualNode`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeVirtualNodeOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeVirtualNodeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeVirtualNodeInputOperationOutputAlias,
                crate::output::DescribeVirtualNodeOutput,
                crate::error::DescribeVirtualNodeError,
                crate::input::DescribeVirtualNodeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the virtual node to describe.</p>
        pub fn virtual_node_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_node_name(inp);
            self
        }
        /// <p>The name of the virtual node to describe.</p>
        pub fn set_virtual_node_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_node_name(input);
            self
        }
        /// <p>The name of the service mesh that the virtual node resides in.</p>
        pub fn mesh_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(inp);
            self
        }
        /// <p>The name of the service mesh that the virtual node resides in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_owner(inp);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeVirtualRouter`.
    ///
    /// <p>Describes an existing virtual router.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeVirtualRouter<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_virtual_router_input::Builder,
    }
    impl<C, M, R> DescribeVirtualRouter<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeVirtualRouter`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeVirtualRouterOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeVirtualRouterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeVirtualRouterInputOperationOutputAlias,
                crate::output::DescribeVirtualRouterOutput,
                crate::error::DescribeVirtualRouterError,
                crate::input::DescribeVirtualRouterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the virtual router to describe.</p>
        pub fn virtual_router_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_router_name(inp);
            self
        }
        /// <p>The name of the virtual router to describe.</p>
        pub fn set_virtual_router_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_router_name(input);
            self
        }
        /// <p>The name of the service mesh that the virtual router resides in.</p>
        pub fn mesh_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(inp);
            self
        }
        /// <p>The name of the service mesh that the virtual router resides in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_owner(inp);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeVirtualService`.
    ///
    /// <p>Describes an existing virtual service.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeVirtualService<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_virtual_service_input::Builder,
    }
    impl<C, M, R> DescribeVirtualService<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeVirtualService`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeVirtualServiceOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeVirtualServiceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeVirtualServiceInputOperationOutputAlias,
                crate::output::DescribeVirtualServiceOutput,
                crate::error::DescribeVirtualServiceError,
                crate::input::DescribeVirtualServiceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the virtual service to describe.</p>
        pub fn virtual_service_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_service_name(inp);
            self
        }
        /// <p>The name of the virtual service to describe.</p>
        pub fn set_virtual_service_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_service_name(input);
            self
        }
        /// <p>The name of the service mesh that the virtual service resides in.</p>
        pub fn mesh_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(inp);
            self
        }
        /// <p>The name of the service mesh that the virtual service resides in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_owner(inp);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListGatewayRoutes`.
    ///
    /// <p>Returns a list of existing gateway routes that are associated to a virtual
    /// gateway.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListGatewayRoutes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_gateway_routes_input::Builder,
    }
    impl<C, M, R> ListGatewayRoutes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListGatewayRoutes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListGatewayRoutesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListGatewayRoutesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListGatewayRoutesInputOperationOutputAlias,
                crate::output::ListGatewayRoutesOutput,
                crate::error::ListGatewayRoutesError,
                crate::input::ListGatewayRoutesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the service mesh to list gateway routes in.</p>
        pub fn mesh_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(inp);
            self
        }
        /// <p>The name of the service mesh to list gateway routes in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The name of the virtual gateway to list gateway routes in.</p>
        pub fn virtual_gateway_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_gateway_name(inp);
            self
        }
        /// <p>The name of the virtual gateway to list gateway routes in.</p>
        pub fn set_virtual_gateway_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_gateway_name(input);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>ListGatewayRoutes</code> request where <code>limit</code> was used and the results
        /// exceeded the value of that parameter. Pagination continues from the end of the previous
        /// results that returned the <code>nextToken</code> value.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>ListGatewayRoutes</code> request where <code>limit</code> was used and the results
        /// exceeded the value of that parameter. Pagination continues from the end of the previous
        /// results that returned the <code>nextToken</code> value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results returned by <code>ListGatewayRoutes</code> in paginated
        /// output. When you use this parameter, <code>ListGatewayRoutes</code> returns only
        /// <code>limit</code> results in a single page along with a <code>nextToken</code> response
        /// element. You can see the remaining results of the initial request by sending another
        /// <code>ListGatewayRoutes</code> request with the returned <code>nextToken</code> value.
        /// This value can be between 1 and 100. If you don't use this
        /// parameter, <code>ListGatewayRoutes</code> returns up to 100 results and a
        /// <code>nextToken</code> value if applicable.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>The maximum number of results returned by <code>ListGatewayRoutes</code> in paginated
        /// output. When you use this parameter, <code>ListGatewayRoutes</code> returns only
        /// <code>limit</code> results in a single page along with a <code>nextToken</code> response
        /// element. You can see the remaining results of the initial request by sending another
        /// <code>ListGatewayRoutes</code> request with the returned <code>nextToken</code> value.
        /// This value can be between 1 and 100. If you don't use this
        /// parameter, <code>ListGatewayRoutes</code> returns up to 100 results and a
        /// <code>nextToken</code> value if applicable.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_owner(inp);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListMeshes`.
    ///
    /// <p>Returns a list of existing service meshes.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListMeshes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_meshes_input::Builder,
    }
    impl<C, M, R> ListMeshes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListMeshes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListMeshesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListMeshesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListMeshesInputOperationOutputAlias,
                crate::output::ListMeshesOutput,
                crate::error::ListMeshesError,
                crate::input::ListMeshesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>ListMeshes</code> request where <code>limit</code> was used and the results
        /// exceeded the value of that parameter. Pagination continues from the end of the previous
        /// results that returned the <code>nextToken</code> value.</p>
        /// <note>
        /// <p>This token should be treated as an opaque identifier that is used only to
        /// retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>ListMeshes</code> request where <code>limit</code> was used and the results
        /// exceeded the value of that parameter. Pagination continues from the end of the previous
        /// results that returned the <code>nextToken</code> value.</p>
        /// <note>
        /// <p>This token should be treated as an opaque identifier that is used only to
        /// retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results returned by <code>ListMeshes</code> in paginated output.
        /// When you use this parameter, <code>ListMeshes</code> returns only <code>limit</code>
        /// results in a single page along with a <code>nextToken</code> response element. You can see
        /// the remaining results of the initial request by sending another <code>ListMeshes</code>
        /// request with the returned <code>nextToken</code> value. This value can be between
        /// 1 and 100. If you don't use this parameter,
        /// <code>ListMeshes</code> returns up to 100 results and a
        /// <code>nextToken</code> value if applicable.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>The maximum number of results returned by <code>ListMeshes</code> in paginated output.
        /// When you use this parameter, <code>ListMeshes</code> returns only <code>limit</code>
        /// results in a single page along with a <code>nextToken</code> response element. You can see
        /// the remaining results of the initial request by sending another <code>ListMeshes</code>
        /// request with the returned <code>nextToken</code> value. This value can be between
        /// 1 and 100. If you don't use this parameter,
        /// <code>ListMeshes</code> returns up to 100 results and a
        /// <code>nextToken</code> value if applicable.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRoutes`.
    ///
    /// <p>Returns a list of existing routes in a service mesh.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListRoutes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_routes_input::Builder,
    }
    impl<C, M, R> ListRoutes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRoutes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRoutesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRoutesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRoutesInputOperationOutputAlias,
                crate::output::ListRoutesOutput,
                crate::error::ListRoutesError,
                crate::input::ListRoutesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the service mesh to list routes in.</p>
        pub fn mesh_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(inp);
            self
        }
        /// <p>The name of the service mesh to list routes in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The name of the virtual router to list routes in.</p>
        pub fn virtual_router_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_router_name(inp);
            self
        }
        /// <p>The name of the virtual router to list routes in.</p>
        pub fn set_virtual_router_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_router_name(input);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>ListRoutes</code> request where <code>limit</code> was used and the results
        /// exceeded the value of that parameter. Pagination continues from the end of the previous
        /// results that returned the <code>nextToken</code> value.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>ListRoutes</code> request where <code>limit</code> was used and the results
        /// exceeded the value of that parameter. Pagination continues from the end of the previous
        /// results that returned the <code>nextToken</code> value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results returned by <code>ListRoutes</code> in paginated output.
        /// When you use this parameter, <code>ListRoutes</code> returns only <code>limit</code>
        /// results in a single page along with a <code>nextToken</code> response element. You can see
        /// the remaining results of the initial request by sending another <code>ListRoutes</code>
        /// request with the returned <code>nextToken</code> value. This value can be between
        /// 1 and 100. If you don't use this parameter,
        /// <code>ListRoutes</code> returns up to 100 results and a
        /// <code>nextToken</code> value if applicable.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>The maximum number of results returned by <code>ListRoutes</code> in paginated output.
        /// When you use this parameter, <code>ListRoutes</code> returns only <code>limit</code>
        /// results in a single page along with a <code>nextToken</code> response element. You can see
        /// the remaining results of the initial request by sending another <code>ListRoutes</code>
        /// request with the returned <code>nextToken</code> value. This value can be between
        /// 1 and 100. If you don't use this parameter,
        /// <code>ListRoutes</code> returns up to 100 results and a
        /// <code>nextToken</code> value if applicable.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_owner(inp);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>List the tags for an App Mesh resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the resource to list the tags for.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the resource to list the tags for.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>ListTagsForResource</code> request where <code>limit</code> was used and the
        /// results exceeded the value of that parameter. Pagination continues from the end of the
        /// previous results that returned the <code>nextToken</code> value.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>ListTagsForResource</code> request where <code>limit</code> was used and the
        /// results exceeded the value of that parameter. Pagination continues from the end of the
        /// previous results that returned the <code>nextToken</code> value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of tag results returned by <code>ListTagsForResource</code> in
        /// paginated output. When this parameter is used, <code>ListTagsForResource</code> returns
        /// only <code>limit</code> results in a single page along with a <code>nextToken</code>
        /// response element. You can see the remaining results of the initial request by sending
        /// another <code>ListTagsForResource</code> request with the returned <code>nextToken</code>
        /// value. This value can be between 1 and 100. If you don't use
        /// this parameter, <code>ListTagsForResource</code> returns up to 100
        /// results and a <code>nextToken</code> value if applicable.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>The maximum number of tag results returned by <code>ListTagsForResource</code> in
        /// paginated output. When this parameter is used, <code>ListTagsForResource</code> returns
        /// only <code>limit</code> results in a single page along with a <code>nextToken</code>
        /// response element. You can see the remaining results of the initial request by sending
        /// another <code>ListTagsForResource</code> request with the returned <code>nextToken</code>
        /// value. This value can be between 1 and 100. If you don't use
        /// this parameter, <code>ListTagsForResource</code> returns up to 100
        /// results and a <code>nextToken</code> value if applicable.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListVirtualGateways`.
    ///
    /// <p>Returns a list of existing virtual gateways in a service mesh.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListVirtualGateways<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_virtual_gateways_input::Builder,
    }
    impl<C, M, R> ListVirtualGateways<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListVirtualGateways`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListVirtualGatewaysOutput,
            aws_smithy_http::result::SdkError<crate::error::ListVirtualGatewaysError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListVirtualGatewaysInputOperationOutputAlias,
                crate::output::ListVirtualGatewaysOutput,
                crate::error::ListVirtualGatewaysError,
                crate::input::ListVirtualGatewaysInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the service mesh to list virtual gateways in.</p>
        pub fn mesh_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(inp);
            self
        }
        /// <p>The name of the service mesh to list virtual gateways in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>ListVirtualGateways</code> request where <code>limit</code> was used and the
        /// results exceeded the value of that parameter. Pagination continues from the end of the
        /// previous results that returned the <code>nextToken</code> value.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>ListVirtualGateways</code> request where <code>limit</code> was used and the
        /// results exceeded the value of that parameter. Pagination continues from the end of the
        /// previous results that returned the <code>nextToken</code> value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results returned by <code>ListVirtualGateways</code> in paginated
        /// output. When you use this parameter, <code>ListVirtualGateways</code> returns only
        /// <code>limit</code> results in a single page along with a <code>nextToken</code> response
        /// element. You can see the remaining results of the initial request by sending another
        /// <code>ListVirtualGateways</code> request with the returned <code>nextToken</code> value.
        /// This value can be between 1 and 100. If you don't use this
        /// parameter, <code>ListVirtualGateways</code> returns up to 100 results and
        /// a <code>nextToken</code> value if applicable.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>The maximum number of results returned by <code>ListVirtualGateways</code> in paginated
        /// output. When you use this parameter, <code>ListVirtualGateways</code> returns only
        /// <code>limit</code> results in a single page along with a <code>nextToken</code> response
        /// element. You can see the remaining results of the initial request by sending another
        /// <code>ListVirtualGateways</code> request with the returned <code>nextToken</code> value.
        /// This value can be between 1 and 100. If you don't use this
        /// parameter, <code>ListVirtualGateways</code> returns up to 100 results and
        /// a <code>nextToken</code> value if applicable.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_owner(inp);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListVirtualNodes`.
    ///
    /// <p>Returns a list of existing virtual nodes.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListVirtualNodes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_virtual_nodes_input::Builder,
    }
    impl<C, M, R> ListVirtualNodes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListVirtualNodes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListVirtualNodesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListVirtualNodesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListVirtualNodesInputOperationOutputAlias,
                crate::output::ListVirtualNodesOutput,
                crate::error::ListVirtualNodesError,
                crate::input::ListVirtualNodesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the service mesh to list virtual nodes in.</p>
        pub fn mesh_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(inp);
            self
        }
        /// <p>The name of the service mesh to list virtual nodes in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>ListVirtualNodes</code> request where <code>limit</code> was used and the results
        /// exceeded the value of that parameter. Pagination continues from the end of the previous
        /// results that returned the <code>nextToken</code> value.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>ListVirtualNodes</code> request where <code>limit</code> was used and the results
        /// exceeded the value of that parameter. Pagination continues from the end of the previous
        /// results that returned the <code>nextToken</code> value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results returned by <code>ListVirtualNodes</code> in paginated
        /// output. When you use this parameter, <code>ListVirtualNodes</code> returns only
        /// <code>limit</code> results in a single page along with a <code>nextToken</code> response
        /// element. You can see the remaining results of the initial request by sending another
        /// <code>ListVirtualNodes</code> request with the returned <code>nextToken</code> value.
        /// This value can be between 1 and 100. If you don't use this
        /// parameter, <code>ListVirtualNodes</code> returns up to 100 results and a
        /// <code>nextToken</code> value if applicable.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>The maximum number of results returned by <code>ListVirtualNodes</code> in paginated
        /// output. When you use this parameter, <code>ListVirtualNodes</code> returns only
        /// <code>limit</code> results in a single page along with a <code>nextToken</code> response
        /// element. You can see the remaining results of the initial request by sending another
        /// <code>ListVirtualNodes</code> request with the returned <code>nextToken</code> value.
        /// This value can be between 1 and 100. If you don't use this
        /// parameter, <code>ListVirtualNodes</code> returns up to 100 results and a
        /// <code>nextToken</code> value if applicable.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_owner(inp);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListVirtualRouters`.
    ///
    /// <p>Returns a list of existing virtual routers in a service mesh.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListVirtualRouters<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_virtual_routers_input::Builder,
    }
    impl<C, M, R> ListVirtualRouters<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListVirtualRouters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListVirtualRoutersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListVirtualRoutersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListVirtualRoutersInputOperationOutputAlias,
                crate::output::ListVirtualRoutersOutput,
                crate::error::ListVirtualRoutersError,
                crate::input::ListVirtualRoutersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the service mesh to list virtual routers in.</p>
        pub fn mesh_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(inp);
            self
        }
        /// <p>The name of the service mesh to list virtual routers in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>ListVirtualRouters</code> request where <code>limit</code> was used and the
        /// results exceeded the value of that parameter. Pagination continues from the end of the
        /// previous results that returned the <code>nextToken</code> value.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>ListVirtualRouters</code> request where <code>limit</code> was used and the
        /// results exceeded the value of that parameter. Pagination continues from the end of the
        /// previous results that returned the <code>nextToken</code> value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results returned by <code>ListVirtualRouters</code> in paginated
        /// output. When you use this parameter, <code>ListVirtualRouters</code> returns only
        /// <code>limit</code> results in a single page along with a <code>nextToken</code> response
        /// element. You can see the remaining results of the initial request by sending another
        /// <code>ListVirtualRouters</code> request with the returned <code>nextToken</code> value.
        /// This value can be between 1 and 100. If you don't use this
        /// parameter, <code>ListVirtualRouters</code> returns up to 100 results and
        /// a <code>nextToken</code> value if applicable.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>The maximum number of results returned by <code>ListVirtualRouters</code> in paginated
        /// output. When you use this parameter, <code>ListVirtualRouters</code> returns only
        /// <code>limit</code> results in a single page along with a <code>nextToken</code> response
        /// element. You can see the remaining results of the initial request by sending another
        /// <code>ListVirtualRouters</code> request with the returned <code>nextToken</code> value.
        /// This value can be between 1 and 100. If you don't use this
        /// parameter, <code>ListVirtualRouters</code> returns up to 100 results and
        /// a <code>nextToken</code> value if applicable.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_owner(inp);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListVirtualServices`.
    ///
    /// <p>Returns a list of existing virtual services in a service mesh.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListVirtualServices<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_virtual_services_input::Builder,
    }
    impl<C, M, R> ListVirtualServices<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListVirtualServices`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListVirtualServicesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListVirtualServicesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListVirtualServicesInputOperationOutputAlias,
                crate::output::ListVirtualServicesOutput,
                crate::error::ListVirtualServicesError,
                crate::input::ListVirtualServicesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the service mesh to list virtual services in.</p>
        pub fn mesh_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(inp);
            self
        }
        /// <p>The name of the service mesh to list virtual services in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>ListVirtualServices</code> request where <code>limit</code> was used and the
        /// results exceeded the value of that parameter. Pagination continues from the end of the
        /// previous results that returned the <code>nextToken</code> value.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>ListVirtualServices</code> request where <code>limit</code> was used and the
        /// results exceeded the value of that parameter. Pagination continues from the end of the
        /// previous results that returned the <code>nextToken</code> value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results returned by <code>ListVirtualServices</code> in paginated
        /// output. When you use this parameter, <code>ListVirtualServices</code> returns only
        /// <code>limit</code> results in a single page along with a <code>nextToken</code> response
        /// element. You can see the remaining results of the initial request by sending another
        /// <code>ListVirtualServices</code> request with the returned <code>nextToken</code> value.
        /// This value can be between 1 and 100. If you don't use this
        /// parameter, <code>ListVirtualServices</code> returns up to 100 results and
        /// a <code>nextToken</code> value if applicable.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>The maximum number of results returned by <code>ListVirtualServices</code> in paginated
        /// output. When you use this parameter, <code>ListVirtualServices</code> returns only
        /// <code>limit</code> results in a single page along with a <code>nextToken</code> response
        /// element. You can see the remaining results of the initial request by sending another
        /// <code>ListVirtualServices</code> request with the returned <code>nextToken</code> value.
        /// This value can be between 1 and 100. If you don't use this
        /// parameter, <code>ListVirtualServices</code> returns up to 100 results and
        /// a <code>nextToken</code> value if applicable.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_owner(inp);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Associates the specified tags to a resource with the specified <code>resourceArn</code>.
    /// If existing tags on a resource aren't specified in the request parameters, they aren't
    /// changed. When a resource is deleted, the tags associated with that resource are also
    /// deleted.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to add tags to.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to add tags to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to add to the resource. A tag is an array of key-value pairs.
        /// Tag keys can have a maximum character length of 128 characters, and tag values can have
        /// a maximum length of 256 characters.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::TagRef>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to add to the resource. A tag is an array of key-value pairs.
        /// Tag keys can have a maximum character length of 128 characters, and tag values can have
        /// a maximum length of 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagRef>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Deletes specified tags from a resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to delete tags from.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to delete tags from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The keys of the tags to be removed.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The keys of the tags to be removed.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateGatewayRoute`.
    ///
    /// <p>Updates an existing gateway route that is associated to a specified virtual gateway in a
    /// service mesh.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateGatewayRoute<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_gateway_route_input::Builder,
    }
    impl<C, M, R> UpdateGatewayRoute<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateGatewayRoute`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateGatewayRouteOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateGatewayRouteError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateGatewayRouteInputOperationOutputAlias,
                crate::output::UpdateGatewayRouteOutput,
                crate::error::UpdateGatewayRouteError,
                crate::input::UpdateGatewayRouteInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the gateway route to update.</p>
        pub fn gateway_route_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_route_name(inp);
            self
        }
        /// <p>The name of the gateway route to update.</p>
        pub fn set_gateway_route_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_gateway_route_name(input);
            self
        }
        /// <p>The name of the service mesh that the gateway route resides in.</p>
        pub fn mesh_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(inp);
            self
        }
        /// <p>The name of the service mesh that the gateway route resides in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The name of the virtual gateway that the gateway route is associated with.</p>
        pub fn virtual_gateway_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_gateway_name(inp);
            self
        }
        /// <p>The name of the virtual gateway that the gateway route is associated with.</p>
        pub fn set_virtual_gateway_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_gateway_name(input);
            self
        }
        /// <p>The new gateway route specification to apply. This overwrites the existing data.</p>
        pub fn spec(mut self, inp: crate::model::GatewayRouteSpec) -> Self {
            self.inner = self.inner.spec(inp);
            self
        }
        /// <p>The new gateway route specification to apply. This overwrites the existing data.</p>
        pub fn set_spec(
            mut self,
            input: std::option::Option<crate::model::GatewayRouteSpec>,
        ) -> Self {
            self.inner = self.inner.set_spec(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_owner(inp);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateMesh`.
    ///
    /// <p>Updates an existing service mesh.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateMesh<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_mesh_input::Builder,
    }
    impl<C, M, R> UpdateMesh<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateMesh`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateMeshOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateMeshError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateMeshInputOperationOutputAlias,
                crate::output::UpdateMeshOutput,
                crate::error::UpdateMeshError,
                crate::input::UpdateMeshInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the service mesh to update.</p>
        pub fn mesh_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(inp);
            self
        }
        /// <p>The name of the service mesh to update.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The service mesh specification to apply.</p>
        pub fn spec(mut self, inp: crate::model::MeshSpec) -> Self {
            self.inner = self.inner.spec(inp);
            self
        }
        /// <p>The service mesh specification to apply.</p>
        pub fn set_spec(mut self, input: std::option::Option<crate::model::MeshSpec>) -> Self {
            self.inner = self.inner.set_spec(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRoute`.
    ///
    /// <p>Updates an existing route for a specified service mesh and virtual router.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateRoute<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_route_input::Builder,
    }
    impl<C, M, R> UpdateRoute<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateRoute`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRouteOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRouteError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateRouteInputOperationOutputAlias,
                crate::output::UpdateRouteOutput,
                crate::error::UpdateRouteError,
                crate::input::UpdateRouteInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the route to update.</p>
        pub fn route_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.route_name(inp);
            self
        }
        /// <p>The name of the route to update.</p>
        pub fn set_route_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_route_name(input);
            self
        }
        /// <p>The name of the service mesh that the route resides in.</p>
        pub fn mesh_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(inp);
            self
        }
        /// <p>The name of the service mesh that the route resides in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The name of the virtual router that the route is associated with.</p>
        pub fn virtual_router_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_router_name(inp);
            self
        }
        /// <p>The name of the virtual router that the route is associated with.</p>
        pub fn set_virtual_router_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_router_name(input);
            self
        }
        /// <p>The new route specification to apply. This overwrites the existing data.</p>
        pub fn spec(mut self, inp: crate::model::RouteSpec) -> Self {
            self.inner = self.inner.spec(inp);
            self
        }
        /// <p>The new route specification to apply. This overwrites the existing data.</p>
        pub fn set_spec(mut self, input: std::option::Option<crate::model::RouteSpec>) -> Self {
            self.inner = self.inner.set_spec(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_owner(inp);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateVirtualGateway`.
    ///
    /// <p>Updates an existing virtual gateway in a specified service mesh.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateVirtualGateway<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_virtual_gateway_input::Builder,
    }
    impl<C, M, R> UpdateVirtualGateway<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateVirtualGateway`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateVirtualGatewayOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateVirtualGatewayError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateVirtualGatewayInputOperationOutputAlias,
                crate::output::UpdateVirtualGatewayOutput,
                crate::error::UpdateVirtualGatewayError,
                crate::input::UpdateVirtualGatewayInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the virtual gateway to update.</p>
        pub fn virtual_gateway_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_gateway_name(inp);
            self
        }
        /// <p>The name of the virtual gateway to update.</p>
        pub fn set_virtual_gateway_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_gateway_name(input);
            self
        }
        /// <p>The name of the service mesh that the virtual gateway resides in.</p>
        pub fn mesh_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(inp);
            self
        }
        /// <p>The name of the service mesh that the virtual gateway resides in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The new virtual gateway specification to apply. This overwrites the existing
        /// data.</p>
        pub fn spec(mut self, inp: crate::model::VirtualGatewaySpec) -> Self {
            self.inner = self.inner.spec(inp);
            self
        }
        /// <p>The new virtual gateway specification to apply. This overwrites the existing
        /// data.</p>
        pub fn set_spec(
            mut self,
            input: std::option::Option<crate::model::VirtualGatewaySpec>,
        ) -> Self {
            self.inner = self.inner.set_spec(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_owner(inp);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateVirtualNode`.
    ///
    /// <p>Updates an existing virtual node in a specified service mesh.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateVirtualNode<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_virtual_node_input::Builder,
    }
    impl<C, M, R> UpdateVirtualNode<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateVirtualNode`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateVirtualNodeOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateVirtualNodeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateVirtualNodeInputOperationOutputAlias,
                crate::output::UpdateVirtualNodeOutput,
                crate::error::UpdateVirtualNodeError,
                crate::input::UpdateVirtualNodeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the virtual node to update.</p>
        pub fn virtual_node_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_node_name(inp);
            self
        }
        /// <p>The name of the virtual node to update.</p>
        pub fn set_virtual_node_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_node_name(input);
            self
        }
        /// <p>The name of the service mesh that the virtual node resides in.</p>
        pub fn mesh_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(inp);
            self
        }
        /// <p>The name of the service mesh that the virtual node resides in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The new virtual node specification to apply. This overwrites the existing data.</p>
        pub fn spec(mut self, inp: crate::model::VirtualNodeSpec) -> Self {
            self.inner = self.inner.spec(inp);
            self
        }
        /// <p>The new virtual node specification to apply. This overwrites the existing data.</p>
        pub fn set_spec(
            mut self,
            input: std::option::Option<crate::model::VirtualNodeSpec>,
        ) -> Self {
            self.inner = self.inner.set_spec(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_owner(inp);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateVirtualRouter`.
    ///
    /// <p>Updates an existing virtual router in a specified service mesh.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateVirtualRouter<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_virtual_router_input::Builder,
    }
    impl<C, M, R> UpdateVirtualRouter<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateVirtualRouter`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateVirtualRouterOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateVirtualRouterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateVirtualRouterInputOperationOutputAlias,
                crate::output::UpdateVirtualRouterOutput,
                crate::error::UpdateVirtualRouterError,
                crate::input::UpdateVirtualRouterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the virtual router to update.</p>
        pub fn virtual_router_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_router_name(inp);
            self
        }
        /// <p>The name of the virtual router to update.</p>
        pub fn set_virtual_router_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_router_name(input);
            self
        }
        /// <p>The name of the service mesh that the virtual router resides in.</p>
        pub fn mesh_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(inp);
            self
        }
        /// <p>The name of the service mesh that the virtual router resides in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The new virtual router specification to apply. This overwrites the existing data.</p>
        pub fn spec(mut self, inp: crate::model::VirtualRouterSpec) -> Self {
            self.inner = self.inner.spec(inp);
            self
        }
        /// <p>The new virtual router specification to apply. This overwrites the existing data.</p>
        pub fn set_spec(
            mut self,
            input: std::option::Option<crate::model::VirtualRouterSpec>,
        ) -> Self {
            self.inner = self.inner.set_spec(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_owner(inp);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateVirtualService`.
    ///
    /// <p>Updates an existing virtual service in a specified service mesh.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateVirtualService<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_virtual_service_input::Builder,
    }
    impl<C, M, R> UpdateVirtualService<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateVirtualService`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateVirtualServiceOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateVirtualServiceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateVirtualServiceInputOperationOutputAlias,
                crate::output::UpdateVirtualServiceOutput,
                crate::error::UpdateVirtualServiceError,
                crate::input::UpdateVirtualServiceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the virtual service to update.</p>
        pub fn virtual_service_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_service_name(inp);
            self
        }
        /// <p>The name of the virtual service to update.</p>
        pub fn set_virtual_service_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_service_name(input);
            self
        }
        /// <p>The name of the service mesh that the virtual service resides in.</p>
        pub fn mesh_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(inp);
            self
        }
        /// <p>The name of the service mesh that the virtual service resides in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The new virtual service specification to apply. This overwrites the existing
        /// data.</p>
        pub fn spec(mut self, inp: crate::model::VirtualServiceSpec) -> Self {
            self.inner = self.inner.spec(inp);
            self
        }
        /// <p>The new virtual service specification to apply. This overwrites the existing
        /// data.</p>
        pub fn set_spec(
            mut self,
            input: std::option::Option<crate::model::VirtualServiceSpec>,
        ) -> Self {
            self.inner = self.inner.set_spec(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_owner(inp);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
        /// the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_owner(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
