// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CreateApplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateApplicationError {
    /// Kind of error that occurred.
    pub kind: CreateApplicationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateApplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateApplicationErrorKind {
    /// <p> User does not have permissions to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The server encountered an internal error and is unable to complete the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource is already created or in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The resource does not exist in the customer account.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Tags are already registered for the specified application ARN.</p>
    TagsAlreadyExistException(crate::error::TagsAlreadyExistException),
    /// <p>The parameter is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateApplicationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateApplicationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateApplicationErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateApplicationErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            CreateApplicationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateApplicationErrorKind::TagsAlreadyExistException(_inner) => _inner.fmt(f),
            CreateApplicationErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateApplicationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateApplicationError {
    fn code(&self) -> Option<&str> {
        CreateApplicationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateApplicationError {
    /// Creates a new `CreateApplicationError`.
    pub fn new(kind: CreateApplicationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateApplicationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateApplicationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateApplicationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateApplicationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateApplicationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateApplicationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateApplicationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateApplicationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateApplicationErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateApplicationErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateApplicationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateApplicationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateApplicationErrorKind::TagsAlreadyExistException`.
    pub fn is_tags_already_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateApplicationErrorKind::TagsAlreadyExistException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateApplicationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateApplicationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateApplicationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateApplicationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateApplicationErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateApplicationErrorKind::ResourceInUseException(_inner) => Some(_inner),
            CreateApplicationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateApplicationErrorKind::TagsAlreadyExistException(_inner) => Some(_inner),
            CreateApplicationErrorKind::ValidationException(_inner) => Some(_inner),
            CreateApplicationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateComponent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateComponentError {
    /// Kind of error that occurred.
    pub kind: CreateComponentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateComponent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateComponentErrorKind {
    /// <p>The server encountered an internal error and is unable to complete the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource is already created or in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The resource does not exist in the customer account.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The parameter is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateComponentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateComponentErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateComponentErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            CreateComponentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateComponentErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateComponentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateComponentError {
    fn code(&self) -> Option<&str> {
        CreateComponentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateComponentError {
    /// Creates a new `CreateComponentError`.
    pub fn new(kind: CreateComponentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateComponentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateComponentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateComponentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateComponentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateComponentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateComponentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateComponentErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateComponentErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateComponentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateComponentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateComponentErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateComponentErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateComponentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateComponentErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateComponentErrorKind::ResourceInUseException(_inner) => Some(_inner),
            CreateComponentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateComponentErrorKind::ValidationException(_inner) => Some(_inner),
            CreateComponentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateLogPattern` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateLogPatternError {
    /// Kind of error that occurred.
    pub kind: CreateLogPatternErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateLogPattern` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateLogPatternErrorKind {
    /// <p>The server encountered an internal error and is unable to complete the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource is already created or in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The resource does not exist in the customer account.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The parameter is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateLogPatternError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateLogPatternErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateLogPatternErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            CreateLogPatternErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateLogPatternErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateLogPatternErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateLogPatternError {
    fn code(&self) -> Option<&str> {
        CreateLogPatternError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateLogPatternError {
    /// Creates a new `CreateLogPatternError`.
    pub fn new(kind: CreateLogPatternErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateLogPatternError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateLogPatternErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateLogPatternError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateLogPatternErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateLogPatternErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLogPatternErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLogPatternErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLogPatternErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLogPatternErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLogPatternErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLogPatternErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLogPatternErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateLogPatternError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateLogPatternErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateLogPatternErrorKind::ResourceInUseException(_inner) => Some(_inner),
            CreateLogPatternErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateLogPatternErrorKind::ValidationException(_inner) => Some(_inner),
            CreateLogPatternErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteApplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteApplicationError {
    /// Kind of error that occurred.
    pub kind: DeleteApplicationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteApplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteApplicationErrorKind {
    /// <p>The request is not understood by the server.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The server encountered an internal error and is unable to complete the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource does not exist in the customer account.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The parameter is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteApplicationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteApplicationErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteApplicationErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteApplicationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteApplicationErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteApplicationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteApplicationError {
    fn code(&self) -> Option<&str> {
        DeleteApplicationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteApplicationError {
    /// Creates a new `DeleteApplicationError`.
    pub fn new(kind: DeleteApplicationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteApplicationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteApplicationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteApplicationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteApplicationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteApplicationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApplicationErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteApplicationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApplicationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteApplicationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApplicationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteApplicationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApplicationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteApplicationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteApplicationErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteApplicationErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteApplicationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteApplicationErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteApplicationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteComponent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteComponentError {
    /// Kind of error that occurred.
    pub kind: DeleteComponentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteComponent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteComponentErrorKind {
    /// <p>The server encountered an internal error and is unable to complete the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource does not exist in the customer account.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The parameter is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteComponentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteComponentErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteComponentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteComponentErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteComponentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteComponentError {
    fn code(&self) -> Option<&str> {
        DeleteComponentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteComponentError {
    /// Creates a new `DeleteComponentError`.
    pub fn new(kind: DeleteComponentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteComponentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteComponentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteComponentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteComponentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteComponentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteComponentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteComponentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteComponentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteComponentErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteComponentErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteComponentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteComponentErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteComponentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteComponentErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteComponentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteLogPattern` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteLogPatternError {
    /// Kind of error that occurred.
    pub kind: DeleteLogPatternErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteLogPattern` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteLogPatternErrorKind {
    /// <p>The request is not understood by the server.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The server encountered an internal error and is unable to complete the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource does not exist in the customer account.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The parameter is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteLogPatternError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteLogPatternErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteLogPatternErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteLogPatternErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteLogPatternErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteLogPatternErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteLogPatternError {
    fn code(&self) -> Option<&str> {
        DeleteLogPatternError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteLogPatternError {
    /// Creates a new `DeleteLogPatternError`.
    pub fn new(kind: DeleteLogPatternErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteLogPatternError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteLogPatternErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteLogPatternError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteLogPatternErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteLogPatternErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLogPatternErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteLogPatternErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLogPatternErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteLogPatternErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLogPatternErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteLogPatternErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLogPatternErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteLogPatternError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteLogPatternErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteLogPatternErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteLogPatternErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteLogPatternErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteLogPatternErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeApplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeApplicationError {
    /// Kind of error that occurred.
    pub kind: DescribeApplicationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeApplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeApplicationErrorKind {
    /// <p>The server encountered an internal error and is unable to complete the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource does not exist in the customer account.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The parameter is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeApplicationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeApplicationErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeApplicationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeApplicationErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeApplicationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeApplicationError {
    fn code(&self) -> Option<&str> {
        DescribeApplicationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeApplicationError {
    /// Creates a new `DescribeApplicationError`.
    pub fn new(kind: DescribeApplicationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeApplicationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeApplicationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeApplicationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeApplicationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeApplicationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeApplicationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeApplicationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeApplicationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeApplicationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeApplicationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeApplicationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeApplicationErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeApplicationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeApplicationErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeApplicationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeComponent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeComponentError {
    /// Kind of error that occurred.
    pub kind: DescribeComponentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeComponent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeComponentErrorKind {
    /// <p>The server encountered an internal error and is unable to complete the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource does not exist in the customer account.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The parameter is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeComponentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeComponentErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeComponentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeComponentErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeComponentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeComponentError {
    fn code(&self) -> Option<&str> {
        DescribeComponentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeComponentError {
    /// Creates a new `DescribeComponentError`.
    pub fn new(kind: DescribeComponentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeComponentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeComponentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeComponentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeComponentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeComponentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeComponentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeComponentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeComponentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeComponentErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeComponentErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeComponentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeComponentErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeComponentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeComponentErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeComponentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeComponentConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeComponentConfigurationError {
    /// Kind of error that occurred.
    pub kind: DescribeComponentConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeComponentConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeComponentConfigurationErrorKind {
    /// <p>The server encountered an internal error and is unable to complete the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource does not exist in the customer account.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The parameter is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeComponentConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeComponentConfigurationErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            DescribeComponentConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeComponentConfigurationErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeComponentConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeComponentConfigurationError {
    fn code(&self) -> Option<&str> {
        DescribeComponentConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeComponentConfigurationError {
    /// Creates a new `DescribeComponentConfigurationError`.
    pub fn new(
        kind: DescribeComponentConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeComponentConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeComponentConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeComponentConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeComponentConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeComponentConfigurationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeComponentConfigurationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeComponentConfigurationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeComponentConfigurationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeComponentConfigurationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeComponentConfigurationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeComponentConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeComponentConfigurationErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            DescribeComponentConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeComponentConfigurationErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeComponentConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeComponentConfigurationRecommendation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeComponentConfigurationRecommendationError {
    /// Kind of error that occurred.
    pub kind: DescribeComponentConfigurationRecommendationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeComponentConfigurationRecommendation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeComponentConfigurationRecommendationErrorKind {
    /// <p>The server encountered an internal error and is unable to complete the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource does not exist in the customer account.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The parameter is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeComponentConfigurationRecommendationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeComponentConfigurationRecommendationErrorKind::InternalServerException(
                _inner,
            ) => _inner.fmt(f),
            DescribeComponentConfigurationRecommendationErrorKind::ResourceNotFoundException(
                _inner,
            ) => _inner.fmt(f),
            DescribeComponentConfigurationRecommendationErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            DescribeComponentConfigurationRecommendationErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind
    for DescribeComponentConfigurationRecommendationError
{
    fn code(&self) -> Option<&str> {
        DescribeComponentConfigurationRecommendationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeComponentConfigurationRecommendationError {
    /// Creates a new `DescribeComponentConfigurationRecommendationError`.
    pub fn new(
        kind: DescribeComponentConfigurationRecommendationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeComponentConfigurationRecommendationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeComponentConfigurationRecommendationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeComponentConfigurationRecommendationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeComponentConfigurationRecommendationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeComponentConfigurationRecommendationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeComponentConfigurationRecommendationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeComponentConfigurationRecommendationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeComponentConfigurationRecommendationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeComponentConfigurationRecommendationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeComponentConfigurationRecommendationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeComponentConfigurationRecommendationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeComponentConfigurationRecommendationErrorKind::InternalServerException(
                _inner,
            ) => Some(_inner),
            DescribeComponentConfigurationRecommendationErrorKind::ResourceNotFoundException(
                _inner,
            ) => Some(_inner),
            DescribeComponentConfigurationRecommendationErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            DescribeComponentConfigurationRecommendationErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeLogPattern` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeLogPatternError {
    /// Kind of error that occurred.
    pub kind: DescribeLogPatternErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeLogPattern` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeLogPatternErrorKind {
    /// <p>The server encountered an internal error and is unable to complete the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource does not exist in the customer account.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The parameter is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeLogPatternError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeLogPatternErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeLogPatternErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeLogPatternErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeLogPatternErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeLogPatternError {
    fn code(&self) -> Option<&str> {
        DescribeLogPatternError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeLogPatternError {
    /// Creates a new `DescribeLogPatternError`.
    pub fn new(kind: DescribeLogPatternErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeLogPatternError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeLogPatternErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeLogPatternError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeLogPatternErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeLogPatternErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLogPatternErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeLogPatternErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLogPatternErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeLogPatternErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLogPatternErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeLogPatternError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeLogPatternErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeLogPatternErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeLogPatternErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeLogPatternErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeObservation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeObservationError {
    /// Kind of error that occurred.
    pub kind: DescribeObservationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeObservation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeObservationErrorKind {
    /// <p>The server encountered an internal error and is unable to complete the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource does not exist in the customer account.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The parameter is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeObservationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeObservationErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeObservationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeObservationErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeObservationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeObservationError {
    fn code(&self) -> Option<&str> {
        DescribeObservationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeObservationError {
    /// Creates a new `DescribeObservationError`.
    pub fn new(kind: DescribeObservationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeObservationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeObservationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeObservationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeObservationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeObservationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeObservationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeObservationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeObservationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeObservationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeObservationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeObservationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeObservationErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeObservationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeObservationErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeObservationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeProblem` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeProblemError {
    /// Kind of error that occurred.
    pub kind: DescribeProblemErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeProblem` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeProblemErrorKind {
    /// <p>The server encountered an internal error and is unable to complete the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource does not exist in the customer account.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The parameter is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeProblemError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeProblemErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeProblemErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeProblemErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeProblemErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeProblemError {
    fn code(&self) -> Option<&str> {
        DescribeProblemError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeProblemError {
    /// Creates a new `DescribeProblemError`.
    pub fn new(kind: DescribeProblemErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeProblemError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeProblemErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeProblemError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeProblemErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeProblemErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeProblemErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeProblemErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeProblemErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeProblemErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DescribeProblemErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DescribeProblemError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeProblemErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeProblemErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeProblemErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeProblemErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeProblemObservations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeProblemObservationsError {
    /// Kind of error that occurred.
    pub kind: DescribeProblemObservationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeProblemObservations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeProblemObservationsErrorKind {
    /// <p>The server encountered an internal error and is unable to complete the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource does not exist in the customer account.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The parameter is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeProblemObservationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeProblemObservationsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeProblemObservationsErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeProblemObservationsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeProblemObservationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeProblemObservationsError {
    fn code(&self) -> Option<&str> {
        DescribeProblemObservationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeProblemObservationsError {
    /// Creates a new `DescribeProblemObservationsError`.
    pub fn new(kind: DescribeProblemObservationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeProblemObservationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeProblemObservationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeProblemObservationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeProblemObservationsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeProblemObservationsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeProblemObservationsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeProblemObservationsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeProblemObservationsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeProblemObservationsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeProblemObservationsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeProblemObservationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeProblemObservationsErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeProblemObservationsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeProblemObservationsErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeProblemObservationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListApplications` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListApplicationsError {
    /// Kind of error that occurred.
    pub kind: ListApplicationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListApplications` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListApplicationsErrorKind {
    /// <p>The server encountered an internal error and is unable to complete the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The parameter is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListApplicationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListApplicationsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListApplicationsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListApplicationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListApplicationsError {
    fn code(&self) -> Option<&str> {
        ListApplicationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListApplicationsError {
    /// Creates a new `ListApplicationsError`.
    pub fn new(kind: ListApplicationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListApplicationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListApplicationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListApplicationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListApplicationsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListApplicationsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListApplicationsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListApplicationsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListApplicationsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListApplicationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListApplicationsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListApplicationsErrorKind::ValidationException(_inner) => Some(_inner),
            ListApplicationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListComponents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListComponentsError {
    /// Kind of error that occurred.
    pub kind: ListComponentsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListComponents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListComponentsErrorKind {
    /// <p>The server encountered an internal error and is unable to complete the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource does not exist in the customer account.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The parameter is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListComponentsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListComponentsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListComponentsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListComponentsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListComponentsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListComponentsError {
    fn code(&self) -> Option<&str> {
        ListComponentsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListComponentsError {
    /// Creates a new `ListComponentsError`.
    pub fn new(kind: ListComponentsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListComponentsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListComponentsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListComponentsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListComponentsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListComponentsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListComponentsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListComponentsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListComponentsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListComponentsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListComponentsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListComponentsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListComponentsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListComponentsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListComponentsErrorKind::ValidationException(_inner) => Some(_inner),
            ListComponentsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListConfigurationHistory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListConfigurationHistoryError {
    /// Kind of error that occurred.
    pub kind: ListConfigurationHistoryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListConfigurationHistory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListConfigurationHistoryErrorKind {
    /// <p>The server encountered an internal error and is unable to complete the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource does not exist in the customer account.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The parameter is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListConfigurationHistoryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListConfigurationHistoryErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListConfigurationHistoryErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListConfigurationHistoryErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListConfigurationHistoryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListConfigurationHistoryError {
    fn code(&self) -> Option<&str> {
        ListConfigurationHistoryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListConfigurationHistoryError {
    /// Creates a new `ListConfigurationHistoryError`.
    pub fn new(kind: ListConfigurationHistoryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListConfigurationHistoryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListConfigurationHistoryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListConfigurationHistoryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListConfigurationHistoryErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListConfigurationHistoryErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListConfigurationHistoryErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListConfigurationHistoryErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListConfigurationHistoryErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListConfigurationHistoryErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListConfigurationHistoryErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListConfigurationHistoryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListConfigurationHistoryErrorKind::InternalServerException(_inner) => Some(_inner),
            ListConfigurationHistoryErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListConfigurationHistoryErrorKind::ValidationException(_inner) => Some(_inner),
            ListConfigurationHistoryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListLogPatterns` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListLogPatternsError {
    /// Kind of error that occurred.
    pub kind: ListLogPatternsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListLogPatterns` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListLogPatternsErrorKind {
    /// <p>The server encountered an internal error and is unable to complete the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource does not exist in the customer account.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The parameter is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListLogPatternsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListLogPatternsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListLogPatternsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListLogPatternsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListLogPatternsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListLogPatternsError {
    fn code(&self) -> Option<&str> {
        ListLogPatternsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListLogPatternsError {
    /// Creates a new `ListLogPatternsError`.
    pub fn new(kind: ListLogPatternsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListLogPatternsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListLogPatternsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListLogPatternsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListLogPatternsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListLogPatternsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLogPatternsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListLogPatternsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLogPatternsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListLogPatternsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListLogPatternsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListLogPatternsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListLogPatternsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListLogPatternsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListLogPatternsErrorKind::ValidationException(_inner) => Some(_inner),
            ListLogPatternsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListLogPatternSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListLogPatternSetsError {
    /// Kind of error that occurred.
    pub kind: ListLogPatternSetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListLogPatternSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListLogPatternSetsErrorKind {
    /// <p>The server encountered an internal error and is unable to complete the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource does not exist in the customer account.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The parameter is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListLogPatternSetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListLogPatternSetsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListLogPatternSetsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListLogPatternSetsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListLogPatternSetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListLogPatternSetsError {
    fn code(&self) -> Option<&str> {
        ListLogPatternSetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListLogPatternSetsError {
    /// Creates a new `ListLogPatternSetsError`.
    pub fn new(kind: ListLogPatternSetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListLogPatternSetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListLogPatternSetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListLogPatternSetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListLogPatternSetsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListLogPatternSetsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLogPatternSetsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListLogPatternSetsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLogPatternSetsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListLogPatternSetsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLogPatternSetsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListLogPatternSetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListLogPatternSetsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListLogPatternSetsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListLogPatternSetsErrorKind::ValidationException(_inner) => Some(_inner),
            ListLogPatternSetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListProblems` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListProblemsError {
    /// Kind of error that occurred.
    pub kind: ListProblemsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListProblems` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListProblemsErrorKind {
    /// <p>The server encountered an internal error and is unable to complete the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource does not exist in the customer account.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The parameter is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListProblemsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListProblemsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListProblemsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListProblemsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListProblemsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListProblemsError {
    fn code(&self) -> Option<&str> {
        ListProblemsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListProblemsError {
    /// Creates a new `ListProblemsError`.
    pub fn new(kind: ListProblemsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListProblemsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListProblemsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListProblemsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListProblemsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListProblemsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProblemsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListProblemsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProblemsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListProblemsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListProblemsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListProblemsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListProblemsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListProblemsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListProblemsErrorKind::ValidationException(_inner) => Some(_inner),
            ListProblemsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>The resource does not exist in the customer account.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The parameter is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ValidationException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>The resource does not exist in the customer account.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The number of the provided tags is beyond the limit, or the number of total tags you are trying to attach to the specified resource exceeds the limit.</p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// <p>The parameter is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::TooManyTagsException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::TooManyTagsException(_inner) => Some(_inner),
            TagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>The resource does not exist in the customer account.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The parameter is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateApplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateApplicationError {
    /// Kind of error that occurred.
    pub kind: UpdateApplicationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateApplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateApplicationErrorKind {
    /// <p>The server encountered an internal error and is unable to complete the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource does not exist in the customer account.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The parameter is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateApplicationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateApplicationErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateApplicationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateApplicationErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateApplicationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateApplicationError {
    fn code(&self) -> Option<&str> {
        UpdateApplicationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateApplicationError {
    /// Creates a new `UpdateApplicationError`.
    pub fn new(kind: UpdateApplicationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateApplicationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateApplicationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateApplicationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateApplicationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateApplicationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApplicationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateApplicationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApplicationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateApplicationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApplicationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateApplicationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateApplicationErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateApplicationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateApplicationErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateApplicationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateComponent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateComponentError {
    /// Kind of error that occurred.
    pub kind: UpdateComponentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateComponent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateComponentErrorKind {
    /// <p>The server encountered an internal error and is unable to complete the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource is already created or in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The resource does not exist in the customer account.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The parameter is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateComponentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateComponentErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateComponentErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            UpdateComponentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateComponentErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateComponentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateComponentError {
    fn code(&self) -> Option<&str> {
        UpdateComponentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateComponentError {
    /// Creates a new `UpdateComponentError`.
    pub fn new(kind: UpdateComponentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateComponentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateComponentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateComponentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateComponentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateComponentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateComponentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateComponentErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateComponentErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateComponentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateComponentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateComponentErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UpdateComponentErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UpdateComponentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateComponentErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateComponentErrorKind::ResourceInUseException(_inner) => Some(_inner),
            UpdateComponentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateComponentErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateComponentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateComponentConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateComponentConfigurationError {
    /// Kind of error that occurred.
    pub kind: UpdateComponentConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateComponentConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateComponentConfigurationErrorKind {
    /// <p>The server encountered an internal error and is unable to complete the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource does not exist in the customer account.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The parameter is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateComponentConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateComponentConfigurationErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateComponentConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateComponentConfigurationErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateComponentConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateComponentConfigurationError {
    fn code(&self) -> Option<&str> {
        UpdateComponentConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateComponentConfigurationError {
    /// Creates a new `UpdateComponentConfigurationError`.
    pub fn new(kind: UpdateComponentConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateComponentConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateComponentConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateComponentConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateComponentConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateComponentConfigurationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateComponentConfigurationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateComponentConfigurationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateComponentConfigurationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateComponentConfigurationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateComponentConfigurationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateComponentConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateComponentConfigurationErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateComponentConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            UpdateComponentConfigurationErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateComponentConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateLogPattern` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateLogPatternError {
    /// Kind of error that occurred.
    pub kind: UpdateLogPatternErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateLogPattern` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateLogPatternErrorKind {
    /// <p>The server encountered an internal error and is unable to complete the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource is already created or in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The resource does not exist in the customer account.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The parameter is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateLogPatternError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateLogPatternErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateLogPatternErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            UpdateLogPatternErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateLogPatternErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateLogPatternErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateLogPatternError {
    fn code(&self) -> Option<&str> {
        UpdateLogPatternError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateLogPatternError {
    /// Creates a new `UpdateLogPatternError`.
    pub fn new(kind: UpdateLogPatternErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateLogPatternError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateLogPatternErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateLogPatternError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateLogPatternErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateLogPatternErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLogPatternErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateLogPatternErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLogPatternErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateLogPatternErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLogPatternErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateLogPatternErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLogPatternErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateLogPatternError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateLogPatternErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateLogPatternErrorKind::ResourceInUseException(_inner) => Some(_inner),
            UpdateLogPatternErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateLogPatternErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateLogPatternErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The parameter is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ValidationException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ValidationException {}
/// See [`ValidationException`](crate::error::ValidationException)
pub mod validation_exception {
    /// A builder for [`ValidationException`](crate::error::ValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationException`](crate::error::ValidationException)
        pub fn build(self) -> crate::error::ValidationException {
            crate::error::ValidationException {
                message: self.message,
            }
        }
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::error::ValidationException)
    pub fn builder() -> crate::error::validation_exception::Builder {
        crate::error::validation_exception::Builder::default()
    }
}

/// <p>The resource does not exist in the customer account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>The resource is already created or in use.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceInUseException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceInUseException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceInUseException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceInUseException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceInUseException {}
/// See [`ResourceInUseException`](crate::error::ResourceInUseException)
pub mod resource_in_use_exception {
    /// A builder for [`ResourceInUseException`](crate::error::ResourceInUseException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceInUseException`](crate::error::ResourceInUseException)
        pub fn build(self) -> crate::error::ResourceInUseException {
            crate::error::ResourceInUseException {
                message: self.message,
            }
        }
    }
}
impl ResourceInUseException {
    /// Creates a new builder-style object to manufacture [`ResourceInUseException`](crate::error::ResourceInUseException)
    pub fn builder() -> crate::error::resource_in_use_exception::Builder {
        crate::error::resource_in_use_exception::Builder::default()
    }
}

/// <p>The server encountered an internal error and is unable to complete the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServerException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerException {}
/// See [`InternalServerException`](crate::error::InternalServerException)
pub mod internal_server_exception {
    /// A builder for [`InternalServerException`](crate::error::InternalServerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerException`](crate::error::InternalServerException)
        pub fn build(self) -> crate::error::InternalServerException {
            crate::error::InternalServerException {
                message: self.message,
            }
        }
    }
}
impl InternalServerException {
    /// Creates a new builder-style object to manufacture [`InternalServerException`](crate::error::InternalServerException)
    pub fn builder() -> crate::error::internal_server_exception::Builder {
        crate::error::internal_server_exception::Builder::default()
    }
}

/// <p>The number of the provided tags is beyond the limit, or the number of total tags you are trying to attach to the specified resource exceeds the limit.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyTagsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The name of the resource with too many tags.</p>
    pub resource_name: std::option::Option<std::string::String>,
}
impl TooManyTagsException {
    /// <p>The name of the resource with too many tags.</p>
    pub fn resource_name(&self) -> std::option::Option<&str> {
        self.resource_name.as_deref()
    }
}
impl std::fmt::Debug for TooManyTagsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyTagsException");
        formatter.field("message", &self.message);
        formatter.field("resource_name", &self.resource_name);
        formatter.finish()
    }
}
impl TooManyTagsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyTagsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyTagsException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyTagsException {}
/// See [`TooManyTagsException`](crate::error::TooManyTagsException)
pub mod too_many_tags_exception {
    /// A builder for [`TooManyTagsException`](crate::error::TooManyTagsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The name of the resource with too many tags.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        /// <p>The name of the resource with too many tags.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyTagsException`](crate::error::TooManyTagsException)
        pub fn build(self) -> crate::error::TooManyTagsException {
            crate::error::TooManyTagsException {
                message: self.message,
                resource_name: self.resource_name,
            }
        }
    }
}
impl TooManyTagsException {
    /// Creates a new builder-style object to manufacture [`TooManyTagsException`](crate::error::TooManyTagsException)
    pub fn builder() -> crate::error::too_many_tags_exception::Builder {
        crate::error::too_many_tags_exception::Builder::default()
    }
}

/// <p>The request is not understood by the server.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BadRequestException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BadRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BadRequestException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl BadRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for BadRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "BadRequestException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for BadRequestException {}
/// See [`BadRequestException`](crate::error::BadRequestException)
pub mod bad_request_exception {
    /// A builder for [`BadRequestException`](crate::error::BadRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`BadRequestException`](crate::error::BadRequestException)
        pub fn build(self) -> crate::error::BadRequestException {
            crate::error::BadRequestException {
                message: self.message,
            }
        }
    }
}
impl BadRequestException {
    /// Creates a new builder-style object to manufacture [`BadRequestException`](crate::error::BadRequestException)
    pub fn builder() -> crate::error::bad_request_exception::Builder {
        crate::error::bad_request_exception::Builder::default()
    }
}

/// <p>Tags are already registered for the specified application ARN.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagsAlreadyExistException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TagsAlreadyExistException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagsAlreadyExistException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TagsAlreadyExistException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TagsAlreadyExistException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TagsAlreadyExistException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for TagsAlreadyExistException {}
/// See [`TagsAlreadyExistException`](crate::error::TagsAlreadyExistException)
pub mod tags_already_exist_exception {
    /// A builder for [`TagsAlreadyExistException`](crate::error::TagsAlreadyExistException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TagsAlreadyExistException`](crate::error::TagsAlreadyExistException)
        pub fn build(self) -> crate::error::TagsAlreadyExistException {
            crate::error::TagsAlreadyExistException {
                message: self.message,
            }
        }
    }
}
impl TagsAlreadyExistException {
    /// Creates a new builder-style object to manufacture [`TagsAlreadyExistException`](crate::error::TagsAlreadyExistException)
    pub fn builder() -> crate::error::tags_already_exist_exception::Builder {
        crate::error::tags_already_exist_exception::Builder::default()
    }
}

/// <p> User does not have permissions to perform this action. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}
