// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon CloudWatch Application Insights
///
/// Client for invoking operations on Amazon CloudWatch Application Insights. Each operation on Amazon CloudWatch Application Insights is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_applicationinsights::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_applicationinsights::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_applicationinsights::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`CreateApplication`](crate::client::fluent_builders::CreateApplication) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_group_name(impl Into<String>)`](crate::client::fluent_builders::CreateApplication::resource_group_name) / [`set_resource_group_name(Option<String>)`](crate::client::fluent_builders::CreateApplication::set_resource_group_name): <p>The name of the resource group.</p>
    ///   - [`ops_center_enabled(bool)`](crate::client::fluent_builders::CreateApplication::ops_center_enabled) / [`set_ops_center_enabled(Option<bool>)`](crate::client::fluent_builders::CreateApplication::set_ops_center_enabled): <p> When set to <code>true</code>, creates opsItems for any problems detected on an application. </p>
    ///   - [`cwe_monitor_enabled(bool)`](crate::client::fluent_builders::CreateApplication::cwe_monitor_enabled) / [`set_cwe_monitor_enabled(Option<bool>)`](crate::client::fluent_builders::CreateApplication::set_cwe_monitor_enabled): <p> Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as <code>instance terminated</code>, <code>failed deployment</code>, and others. </p>
    ///   - [`ops_item_sns_topic_arn(impl Into<String>)`](crate::client::fluent_builders::CreateApplication::ops_item_sns_topic_arn) / [`set_ops_item_sns_topic_arn(Option<String>)`](crate::client::fluent_builders::CreateApplication::set_ops_item_sns_topic_arn): <p> The SNS topic provided to Application Insights that is associated to the created opsItem. Allows you to receive notifications for updates to the opsItem. </p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateApplication::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateApplication::set_tags): <p>List of tags to add to the application. tag key (<code>Key</code>) and an associated tag value (<code>Value</code>). The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>
    ///   - [`auto_config_enabled(bool)`](crate::client::fluent_builders::CreateApplication::auto_config_enabled) / [`set_auto_config_enabled(Option<bool>)`](crate::client::fluent_builders::CreateApplication::set_auto_config_enabled): (undocumented)
    ///   - [`auto_create(bool)`](crate::client::fluent_builders::CreateApplication::auto_create) / [`set_auto_create(Option<bool>)`](crate::client::fluent_builders::CreateApplication::set_auto_create): (undocumented)
    /// - On success, responds with [`CreateApplicationOutput`](crate::output::CreateApplicationOutput) with field(s):
    ///   - [`application_info(Option<ApplicationInfo>)`](crate::output::CreateApplicationOutput::application_info): <p>Information about the application.</p>
    /// - On failure, responds with [`SdkError<CreateApplicationError>`](crate::error::CreateApplicationError)
    pub fn create_application(&self) -> fluent_builders::CreateApplication {
        fluent_builders::CreateApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateComponent`](crate::client::fluent_builders::CreateComponent) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_group_name(impl Into<String>)`](crate::client::fluent_builders::CreateComponent::resource_group_name) / [`set_resource_group_name(Option<String>)`](crate::client::fluent_builders::CreateComponent::set_resource_group_name): <p>The name of the resource group.</p>
    ///   - [`component_name(impl Into<String>)`](crate::client::fluent_builders::CreateComponent::component_name) / [`set_component_name(Option<String>)`](crate::client::fluent_builders::CreateComponent::set_component_name): <p>The name of the component.</p>
    ///   - [`resource_list(Vec<String>)`](crate::client::fluent_builders::CreateComponent::resource_list) / [`set_resource_list(Option<Vec<String>>)`](crate::client::fluent_builders::CreateComponent::set_resource_list): <p>The list of resource ARNs that belong to the component.</p>
    /// - On success, responds with [`CreateComponentOutput`](crate::output::CreateComponentOutput)

    /// - On failure, responds with [`SdkError<CreateComponentError>`](crate::error::CreateComponentError)
    pub fn create_component(&self) -> fluent_builders::CreateComponent {
        fluent_builders::CreateComponent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateLogPattern`](crate::client::fluent_builders::CreateLogPattern) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_group_name(impl Into<String>)`](crate::client::fluent_builders::CreateLogPattern::resource_group_name) / [`set_resource_group_name(Option<String>)`](crate::client::fluent_builders::CreateLogPattern::set_resource_group_name): <p>The name of the resource group.</p>
    ///   - [`pattern_set_name(impl Into<String>)`](crate::client::fluent_builders::CreateLogPattern::pattern_set_name) / [`set_pattern_set_name(Option<String>)`](crate::client::fluent_builders::CreateLogPattern::set_pattern_set_name): <p>The name of the log pattern set.</p>
    ///   - [`pattern_name(impl Into<String>)`](crate::client::fluent_builders::CreateLogPattern::pattern_name) / [`set_pattern_name(Option<String>)`](crate::client::fluent_builders::CreateLogPattern::set_pattern_name): <p>The name of the log pattern.</p>
    ///   - [`pattern(impl Into<String>)`](crate::client::fluent_builders::CreateLogPattern::pattern) / [`set_pattern(Option<String>)`](crate::client::fluent_builders::CreateLogPattern::set_pattern): <p>The log pattern. The pattern must be DFA compatible. Patterns that utilize forward lookahead or backreference constructions are not supported.</p>
    ///   - [`rank(i32)`](crate::client::fluent_builders::CreateLogPattern::rank) / [`set_rank(i32)`](crate::client::fluent_builders::CreateLogPattern::set_rank): <p>Rank of the log pattern. Must be a value between <code>1</code> and <code>1,000,000</code>. The patterns are sorted by rank, so we recommend that you set your highest priority patterns with the lowest rank. A pattern of rank <code>1</code> will be the first to get matched to a log line. A pattern of rank <code>1,000,000</code> will be last to get matched. When you configure custom log patterns from the console, a <code>Low</code> severity pattern translates to a <code>750,000</code> rank. A <code>Medium</code> severity pattern translates to a <code>500,000</code> rank. And a <code>High</code> severity pattern translates to a <code>250,000</code> rank. Rank values less than <code>1</code> or greater than <code>1,000,000</code> are reserved for AWS-provided patterns. </p>
    /// - On success, responds with [`CreateLogPatternOutput`](crate::output::CreateLogPatternOutput) with field(s):
    ///   - [`log_pattern(Option<LogPattern>)`](crate::output::CreateLogPatternOutput::log_pattern): <p>The successfully created log pattern.</p>
    ///   - [`resource_group_name(Option<String>)`](crate::output::CreateLogPatternOutput::resource_group_name): <p>The name of the resource group.</p>
    /// - On failure, responds with [`SdkError<CreateLogPatternError>`](crate::error::CreateLogPatternError)
    pub fn create_log_pattern(&self) -> fluent_builders::CreateLogPattern {
        fluent_builders::CreateLogPattern::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteApplication`](crate::client::fluent_builders::DeleteApplication) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_group_name(impl Into<String>)`](crate::client::fluent_builders::DeleteApplication::resource_group_name) / [`set_resource_group_name(Option<String>)`](crate::client::fluent_builders::DeleteApplication::set_resource_group_name): <p>The name of the resource group.</p>
    /// - On success, responds with [`DeleteApplicationOutput`](crate::output::DeleteApplicationOutput)

    /// - On failure, responds with [`SdkError<DeleteApplicationError>`](crate::error::DeleteApplicationError)
    pub fn delete_application(&self) -> fluent_builders::DeleteApplication {
        fluent_builders::DeleteApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteComponent`](crate::client::fluent_builders::DeleteComponent) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_group_name(impl Into<String>)`](crate::client::fluent_builders::DeleteComponent::resource_group_name) / [`set_resource_group_name(Option<String>)`](crate::client::fluent_builders::DeleteComponent::set_resource_group_name): <p>The name of the resource group.</p>
    ///   - [`component_name(impl Into<String>)`](crate::client::fluent_builders::DeleteComponent::component_name) / [`set_component_name(Option<String>)`](crate::client::fluent_builders::DeleteComponent::set_component_name): <p>The name of the component.</p>
    /// - On success, responds with [`DeleteComponentOutput`](crate::output::DeleteComponentOutput)

    /// - On failure, responds with [`SdkError<DeleteComponentError>`](crate::error::DeleteComponentError)
    pub fn delete_component(&self) -> fluent_builders::DeleteComponent {
        fluent_builders::DeleteComponent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteLogPattern`](crate::client::fluent_builders::DeleteLogPattern) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_group_name(impl Into<String>)`](crate::client::fluent_builders::DeleteLogPattern::resource_group_name) / [`set_resource_group_name(Option<String>)`](crate::client::fluent_builders::DeleteLogPattern::set_resource_group_name): <p>The name of the resource group.</p>
    ///   - [`pattern_set_name(impl Into<String>)`](crate::client::fluent_builders::DeleteLogPattern::pattern_set_name) / [`set_pattern_set_name(Option<String>)`](crate::client::fluent_builders::DeleteLogPattern::set_pattern_set_name): <p>The name of the log pattern set.</p>
    ///   - [`pattern_name(impl Into<String>)`](crate::client::fluent_builders::DeleteLogPattern::pattern_name) / [`set_pattern_name(Option<String>)`](crate::client::fluent_builders::DeleteLogPattern::set_pattern_name): <p>The name of the log pattern.</p>
    /// - On success, responds with [`DeleteLogPatternOutput`](crate::output::DeleteLogPatternOutput)

    /// - On failure, responds with [`SdkError<DeleteLogPatternError>`](crate::error::DeleteLogPatternError)
    pub fn delete_log_pattern(&self) -> fluent_builders::DeleteLogPattern {
        fluent_builders::DeleteLogPattern::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeApplication`](crate::client::fluent_builders::DescribeApplication) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_group_name(impl Into<String>)`](crate::client::fluent_builders::DescribeApplication::resource_group_name) / [`set_resource_group_name(Option<String>)`](crate::client::fluent_builders::DescribeApplication::set_resource_group_name): <p>The name of the resource group.</p>
    /// - On success, responds with [`DescribeApplicationOutput`](crate::output::DescribeApplicationOutput) with field(s):
    ///   - [`application_info(Option<ApplicationInfo>)`](crate::output::DescribeApplicationOutput::application_info): <p>Information about the application.</p>
    /// - On failure, responds with [`SdkError<DescribeApplicationError>`](crate::error::DescribeApplicationError)
    pub fn describe_application(&self) -> fluent_builders::DescribeApplication {
        fluent_builders::DescribeApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeComponent`](crate::client::fluent_builders::DescribeComponent) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_group_name(impl Into<String>)`](crate::client::fluent_builders::DescribeComponent::resource_group_name) / [`set_resource_group_name(Option<String>)`](crate::client::fluent_builders::DescribeComponent::set_resource_group_name): <p>The name of the resource group.</p>
    ///   - [`component_name(impl Into<String>)`](crate::client::fluent_builders::DescribeComponent::component_name) / [`set_component_name(Option<String>)`](crate::client::fluent_builders::DescribeComponent::set_component_name): <p>The name of the component.</p>
    /// - On success, responds with [`DescribeComponentOutput`](crate::output::DescribeComponentOutput) with field(s):
    ///   - [`application_component(Option<ApplicationComponent>)`](crate::output::DescribeComponentOutput::application_component): <p>Describes a standalone resource or similarly grouped resources that the application is made up of.</p>
    ///   - [`resource_list(Option<Vec<String>>)`](crate::output::DescribeComponentOutput::resource_list): <p>The list of resource ARNs that belong to the component.</p>
    /// - On failure, responds with [`SdkError<DescribeComponentError>`](crate::error::DescribeComponentError)
    pub fn describe_component(&self) -> fluent_builders::DescribeComponent {
        fluent_builders::DescribeComponent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeComponentConfiguration`](crate::client::fluent_builders::DescribeComponentConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_group_name(impl Into<String>)`](crate::client::fluent_builders::DescribeComponentConfiguration::resource_group_name) / [`set_resource_group_name(Option<String>)`](crate::client::fluent_builders::DescribeComponentConfiguration::set_resource_group_name): <p>The name of the resource group.</p>
    ///   - [`component_name(impl Into<String>)`](crate::client::fluent_builders::DescribeComponentConfiguration::component_name) / [`set_component_name(Option<String>)`](crate::client::fluent_builders::DescribeComponentConfiguration::set_component_name): <p>The name of the component.</p>
    /// - On success, responds with [`DescribeComponentConfigurationOutput`](crate::output::DescribeComponentConfigurationOutput) with field(s):
    ///   - [`monitor(Option<bool>)`](crate::output::DescribeComponentConfigurationOutput::monitor): <p>Indicates whether the application component is monitored.</p>
    ///   - [`tier(Option<Tier>)`](crate::output::DescribeComponentConfigurationOutput::tier): <p>The tier of the application component. Supported tiers include <code>DOT_NET_CORE</code>, <code>DOT_NET_WORKER</code>, <code>DOT_NET_WEB</code>, <code>SQL_SERVER</code>, and <code>DEFAULT</code> </p>
    ///   - [`component_configuration(Option<String>)`](crate::output::DescribeComponentConfigurationOutput::component_configuration): <p>The configuration settings of the component. The value is the escaped JSON of the configuration.</p>
    /// - On failure, responds with [`SdkError<DescribeComponentConfigurationError>`](crate::error::DescribeComponentConfigurationError)
    pub fn describe_component_configuration(
        &self,
    ) -> fluent_builders::DescribeComponentConfiguration {
        fluent_builders::DescribeComponentConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeComponentConfigurationRecommendation`](crate::client::fluent_builders::DescribeComponentConfigurationRecommendation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_group_name(impl Into<String>)`](crate::client::fluent_builders::DescribeComponentConfigurationRecommendation::resource_group_name) / [`set_resource_group_name(Option<String>)`](crate::client::fluent_builders::DescribeComponentConfigurationRecommendation::set_resource_group_name): <p>The name of the resource group.</p>
    ///   - [`component_name(impl Into<String>)`](crate::client::fluent_builders::DescribeComponentConfigurationRecommendation::component_name) / [`set_component_name(Option<String>)`](crate::client::fluent_builders::DescribeComponentConfigurationRecommendation::set_component_name): <p>The name of the component.</p>
    ///   - [`tier(Tier)`](crate::client::fluent_builders::DescribeComponentConfigurationRecommendation::tier) / [`set_tier(Option<Tier>)`](crate::client::fluent_builders::DescribeComponentConfigurationRecommendation::set_tier): <p>The tier of the application component. Supported tiers include <code>DOT_NET_CORE</code>, <code>DOT_NET_WORKER</code>, <code>DOT_NET_WEB</code>, <code>SQL_SERVER</code>, and <code>DEFAULT</code>.</p>
    /// - On success, responds with [`DescribeComponentConfigurationRecommendationOutput`](crate::output::DescribeComponentConfigurationRecommendationOutput) with field(s):
    ///   - [`component_configuration(Option<String>)`](crate::output::DescribeComponentConfigurationRecommendationOutput::component_configuration): <p>The recommended configuration settings of the component. The value is the escaped JSON of the configuration.</p>
    /// - On failure, responds with [`SdkError<DescribeComponentConfigurationRecommendationError>`](crate::error::DescribeComponentConfigurationRecommendationError)
    pub fn describe_component_configuration_recommendation(
        &self,
    ) -> fluent_builders::DescribeComponentConfigurationRecommendation {
        fluent_builders::DescribeComponentConfigurationRecommendation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeLogPattern`](crate::client::fluent_builders::DescribeLogPattern) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_group_name(impl Into<String>)`](crate::client::fluent_builders::DescribeLogPattern::resource_group_name) / [`set_resource_group_name(Option<String>)`](crate::client::fluent_builders::DescribeLogPattern::set_resource_group_name): <p>The name of the resource group.</p>
    ///   - [`pattern_set_name(impl Into<String>)`](crate::client::fluent_builders::DescribeLogPattern::pattern_set_name) / [`set_pattern_set_name(Option<String>)`](crate::client::fluent_builders::DescribeLogPattern::set_pattern_set_name): <p>The name of the log pattern set.</p>
    ///   - [`pattern_name(impl Into<String>)`](crate::client::fluent_builders::DescribeLogPattern::pattern_name) / [`set_pattern_name(Option<String>)`](crate::client::fluent_builders::DescribeLogPattern::set_pattern_name): <p>The name of the log pattern.</p>
    /// - On success, responds with [`DescribeLogPatternOutput`](crate::output::DescribeLogPatternOutput) with field(s):
    ///   - [`resource_group_name(Option<String>)`](crate::output::DescribeLogPatternOutput::resource_group_name): <p>The name of the resource group.</p>
    ///   - [`log_pattern(Option<LogPattern>)`](crate::output::DescribeLogPatternOutput::log_pattern): <p>The successfully created log pattern.</p>
    /// - On failure, responds with [`SdkError<DescribeLogPatternError>`](crate::error::DescribeLogPatternError)
    pub fn describe_log_pattern(&self) -> fluent_builders::DescribeLogPattern {
        fluent_builders::DescribeLogPattern::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeObservation`](crate::client::fluent_builders::DescribeObservation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`observation_id(impl Into<String>)`](crate::client::fluent_builders::DescribeObservation::observation_id) / [`set_observation_id(Option<String>)`](crate::client::fluent_builders::DescribeObservation::set_observation_id): <p>The ID of the observation.</p>
    /// - On success, responds with [`DescribeObservationOutput`](crate::output::DescribeObservationOutput) with field(s):
    ///   - [`observation(Option<Observation>)`](crate::output::DescribeObservationOutput::observation): <p>Information about the observation.</p>
    /// - On failure, responds with [`SdkError<DescribeObservationError>`](crate::error::DescribeObservationError)
    pub fn describe_observation(&self) -> fluent_builders::DescribeObservation {
        fluent_builders::DescribeObservation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeProblem`](crate::client::fluent_builders::DescribeProblem) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`problem_id(impl Into<String>)`](crate::client::fluent_builders::DescribeProblem::problem_id) / [`set_problem_id(Option<String>)`](crate::client::fluent_builders::DescribeProblem::set_problem_id): <p>The ID of the problem.</p>
    /// - On success, responds with [`DescribeProblemOutput`](crate::output::DescribeProblemOutput) with field(s):
    ///   - [`problem(Option<Problem>)`](crate::output::DescribeProblemOutput::problem): <p>Information about the problem. </p>
    /// - On failure, responds with [`SdkError<DescribeProblemError>`](crate::error::DescribeProblemError)
    pub fn describe_problem(&self) -> fluent_builders::DescribeProblem {
        fluent_builders::DescribeProblem::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeProblemObservations`](crate::client::fluent_builders::DescribeProblemObservations) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`problem_id(impl Into<String>)`](crate::client::fluent_builders::DescribeProblemObservations::problem_id) / [`set_problem_id(Option<String>)`](crate::client::fluent_builders::DescribeProblemObservations::set_problem_id): <p>The ID of the problem.</p>
    /// - On success, responds with [`DescribeProblemObservationsOutput`](crate::output::DescribeProblemObservationsOutput) with field(s):
    ///   - [`related_observations(Option<RelatedObservations>)`](crate::output::DescribeProblemObservationsOutput::related_observations): <p>Observations related to the problem.</p>
    /// - On failure, responds with [`SdkError<DescribeProblemObservationsError>`](crate::error::DescribeProblemObservationsError)
    pub fn describe_problem_observations(&self) -> fluent_builders::DescribeProblemObservations {
        fluent_builders::DescribeProblemObservations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListApplications`](crate::client::fluent_builders::ListApplications) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListApplications::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListApplications::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListApplications::set_max_results): <p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListApplications::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListApplications::set_next_token): <p>The token to request the next page of results.</p>
    /// - On success, responds with [`ListApplicationsOutput`](crate::output::ListApplicationsOutput) with field(s):
    ///   - [`application_info_list(Option<Vec<ApplicationInfo>>)`](crate::output::ListApplicationsOutput::application_info_list): <p>The list of applications.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListApplicationsOutput::next_token): <p>The token used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return. </p>
    /// - On failure, responds with [`SdkError<ListApplicationsError>`](crate::error::ListApplicationsError)
    pub fn list_applications(&self) -> fluent_builders::ListApplications {
        fluent_builders::ListApplications::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListComponents`](crate::client::fluent_builders::ListComponents) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListComponents::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_group_name(impl Into<String>)`](crate::client::fluent_builders::ListComponents::resource_group_name) / [`set_resource_group_name(Option<String>)`](crate::client::fluent_builders::ListComponents::set_resource_group_name): <p>The name of the resource group.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListComponents::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListComponents::set_max_results): <p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListComponents::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListComponents::set_next_token): <p>The token to request the next page of results.</p>
    /// - On success, responds with [`ListComponentsOutput`](crate::output::ListComponentsOutput) with field(s):
    ///   - [`application_component_list(Option<Vec<ApplicationComponent>>)`](crate::output::ListComponentsOutput::application_component_list): <p>The list of application components.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListComponentsOutput::next_token): <p>The token to request the next page of results.</p>
    /// - On failure, responds with [`SdkError<ListComponentsError>`](crate::error::ListComponentsError)
    pub fn list_components(&self) -> fluent_builders::ListComponents {
        fluent_builders::ListComponents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListConfigurationHistory`](crate::client::fluent_builders::ListConfigurationHistory) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListConfigurationHistory::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_group_name(impl Into<String>)`](crate::client::fluent_builders::ListConfigurationHistory::resource_group_name) / [`set_resource_group_name(Option<String>)`](crate::client::fluent_builders::ListConfigurationHistory::set_resource_group_name): <p>Resource group to which the application belongs. </p>
    ///   - [`start_time(DateTime)`](crate::client::fluent_builders::ListConfigurationHistory::start_time) / [`set_start_time(Option<DateTime>)`](crate::client::fluent_builders::ListConfigurationHistory::set_start_time): <p>The start time of the event. </p>
    ///   - [`end_time(DateTime)`](crate::client::fluent_builders::ListConfigurationHistory::end_time) / [`set_end_time(Option<DateTime>)`](crate::client::fluent_builders::ListConfigurationHistory::set_end_time): <p>The end time of the event.</p>
    ///   - [`event_status(ConfigurationEventStatus)`](crate::client::fluent_builders::ListConfigurationHistory::event_status) / [`set_event_status(Option<ConfigurationEventStatus>)`](crate::client::fluent_builders::ListConfigurationHistory::set_event_status): <p>The status of the configuration update event. Possible values include INFO, WARN, and ERROR.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListConfigurationHistory::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListConfigurationHistory::set_max_results): <p> The maximum number of results returned by <code>ListConfigurationHistory</code> in paginated output. When this parameter is used, <code>ListConfigurationHistory</code> returns only <code>MaxResults</code> in a single page along with a <code>NextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListConfigurationHistory</code> request with the returned <code>NextToken</code> value. If this parameter is not used, then <code>ListConfigurationHistory</code> returns all results. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListConfigurationHistory::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListConfigurationHistory::set_next_token): <p>The <code>NextToken</code> value returned from a previous paginated <code>ListConfigurationHistory</code> request where <code>MaxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>NextToken</code> value. This value is <code>null</code> when there are no more results to return.</p>
    /// - On success, responds with [`ListConfigurationHistoryOutput`](crate::output::ListConfigurationHistoryOutput) with field(s):
    ///   - [`event_list(Option<Vec<ConfigurationEvent>>)`](crate::output::ListConfigurationHistoryOutput::event_list): <p> The list of configuration events and their corresponding details. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListConfigurationHistoryOutput::next_token): <p>The <code>NextToken</code> value to include in a future <code>ListConfigurationHistory</code> request. When the results of a <code>ListConfigurationHistory</code> request exceed <code>MaxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<ListConfigurationHistoryError>`](crate::error::ListConfigurationHistoryError)
    pub fn list_configuration_history(&self) -> fluent_builders::ListConfigurationHistory {
        fluent_builders::ListConfigurationHistory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListLogPatterns`](crate::client::fluent_builders::ListLogPatterns) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListLogPatterns::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_group_name(impl Into<String>)`](crate::client::fluent_builders::ListLogPatterns::resource_group_name) / [`set_resource_group_name(Option<String>)`](crate::client::fluent_builders::ListLogPatterns::set_resource_group_name): <p>The name of the resource group.</p>
    ///   - [`pattern_set_name(impl Into<String>)`](crate::client::fluent_builders::ListLogPatterns::pattern_set_name) / [`set_pattern_set_name(Option<String>)`](crate::client::fluent_builders::ListLogPatterns::set_pattern_set_name): <p>The name of the log pattern set.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListLogPatterns::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListLogPatterns::set_max_results): <p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListLogPatterns::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListLogPatterns::set_next_token): <p>The token to request the next page of results.</p>
    /// - On success, responds with [`ListLogPatternsOutput`](crate::output::ListLogPatternsOutput) with field(s):
    ///   - [`resource_group_name(Option<String>)`](crate::output::ListLogPatternsOutput::resource_group_name): <p>The name of the resource group.</p>
    ///   - [`log_patterns(Option<Vec<LogPattern>>)`](crate::output::ListLogPatternsOutput::log_patterns): <p>The list of log patterns.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListLogPatternsOutput::next_token): <p>The token used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return. </p>
    /// - On failure, responds with [`SdkError<ListLogPatternsError>`](crate::error::ListLogPatternsError)
    pub fn list_log_patterns(&self) -> fluent_builders::ListLogPatterns {
        fluent_builders::ListLogPatterns::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListLogPatternSets`](crate::client::fluent_builders::ListLogPatternSets) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListLogPatternSets::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_group_name(impl Into<String>)`](crate::client::fluent_builders::ListLogPatternSets::resource_group_name) / [`set_resource_group_name(Option<String>)`](crate::client::fluent_builders::ListLogPatternSets::set_resource_group_name): <p>The name of the resource group.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListLogPatternSets::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListLogPatternSets::set_max_results): <p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListLogPatternSets::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListLogPatternSets::set_next_token): <p>The token to request the next page of results.</p>
    /// - On success, responds with [`ListLogPatternSetsOutput`](crate::output::ListLogPatternSetsOutput) with field(s):
    ///   - [`resource_group_name(Option<String>)`](crate::output::ListLogPatternSetsOutput::resource_group_name): <p>The name of the resource group.</p>
    ///   - [`log_pattern_sets(Option<Vec<String>>)`](crate::output::ListLogPatternSetsOutput::log_pattern_sets): <p>The list of log pattern sets.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListLogPatternSetsOutput::next_token): <p>The token used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return. </p>
    /// - On failure, responds with [`SdkError<ListLogPatternSetsError>`](crate::error::ListLogPatternSetsError)
    pub fn list_log_pattern_sets(&self) -> fluent_builders::ListLogPatternSets {
        fluent_builders::ListLogPatternSets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListProblems`](crate::client::fluent_builders::ListProblems) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListProblems::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_group_name(impl Into<String>)`](crate::client::fluent_builders::ListProblems::resource_group_name) / [`set_resource_group_name(Option<String>)`](crate::client::fluent_builders::ListProblems::set_resource_group_name): <p>The name of the resource group.</p>
    ///   - [`start_time(DateTime)`](crate::client::fluent_builders::ListProblems::start_time) / [`set_start_time(Option<DateTime>)`](crate::client::fluent_builders::ListProblems::set_start_time): <p>The time when the problem was detected, in epoch seconds. If you don't specify a time frame for the request, problems within the past seven days are returned.</p>
    ///   - [`end_time(DateTime)`](crate::client::fluent_builders::ListProblems::end_time) / [`set_end_time(Option<DateTime>)`](crate::client::fluent_builders::ListProblems::set_end_time): <p>The time when the problem ended, in epoch seconds. If not specified, problems within the past seven days are returned.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListProblems::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListProblems::set_max_results): <p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListProblems::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListProblems::set_next_token): <p>The token to request the next page of results.</p>
    ///   - [`component_name(impl Into<String>)`](crate::client::fluent_builders::ListProblems::component_name) / [`set_component_name(Option<String>)`](crate::client::fluent_builders::ListProblems::set_component_name): (undocumented)
    /// - On success, responds with [`ListProblemsOutput`](crate::output::ListProblemsOutput) with field(s):
    ///   - [`problem_list(Option<Vec<Problem>>)`](crate::output::ListProblemsOutput::problem_list): <p>The list of problems. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListProblemsOutput::next_token): <p>The token used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return. </p>
    ///   - [`resource_group_name(Option<String>)`](crate::output::ListProblemsOutput::resource_group_name): (undocumented)
    /// - On failure, responds with [`SdkError<ListProblemsError>`](crate::error::ListProblemsError)
    pub fn list_problems(&self) -> fluent_builders::ListProblems {
        fluent_builders::ListProblems::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the application that you want to retrieve tag information for.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::ListTagsForResourceOutput::tags): <p>An array that lists all the tags that are associated with the application. Each tag consists of a required tag key (<code>Key</code>) and an associated tag value (<code>Value</code>).</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the application that you want to add one or more tags to.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>A list of tags that to add to the application. A tag consists of a required tag key (<code>Key</code>) and an associated tag value (<code>Value</code>). The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the application that you want to remove one or more tags from.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The tags (tag keys) that you want to remove from the resource. When you specify a tag key, the action removes both that key and its associated tag value.</p>  <p>To remove more than one tag from the application, append the <code>TagKeys</code> parameter and argument for each additional tag to remove, separated by an ampersand. </p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateApplication`](crate::client::fluent_builders::UpdateApplication) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_group_name(impl Into<String>)`](crate::client::fluent_builders::UpdateApplication::resource_group_name) / [`set_resource_group_name(Option<String>)`](crate::client::fluent_builders::UpdateApplication::set_resource_group_name): <p>The name of the resource group.</p>
    ///   - [`ops_center_enabled(bool)`](crate::client::fluent_builders::UpdateApplication::ops_center_enabled) / [`set_ops_center_enabled(Option<bool>)`](crate::client::fluent_builders::UpdateApplication::set_ops_center_enabled): <p> When set to <code>true</code>, creates opsItems for any problems detected on an application. </p>
    ///   - [`cwe_monitor_enabled(bool)`](crate::client::fluent_builders::UpdateApplication::cwe_monitor_enabled) / [`set_cwe_monitor_enabled(Option<bool>)`](crate::client::fluent_builders::UpdateApplication::set_cwe_monitor_enabled): <p> Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as <code>instance terminated</code>, <code>failed deployment</code>, and others. </p>
    ///   - [`ops_item_sns_topic_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateApplication::ops_item_sns_topic_arn) / [`set_ops_item_sns_topic_arn(Option<String>)`](crate::client::fluent_builders::UpdateApplication::set_ops_item_sns_topic_arn): <p> The SNS topic provided to Application Insights that is associated to the created opsItem. Allows you to receive notifications for updates to the opsItem.</p>
    ///   - [`remove_sns_topic(bool)`](crate::client::fluent_builders::UpdateApplication::remove_sns_topic) / [`set_remove_sns_topic(Option<bool>)`](crate::client::fluent_builders::UpdateApplication::set_remove_sns_topic): <p> Disassociates the SNS topic from the opsItem created for detected problems.</p>
    ///   - [`auto_config_enabled(bool)`](crate::client::fluent_builders::UpdateApplication::auto_config_enabled) / [`set_auto_config_enabled(Option<bool>)`](crate::client::fluent_builders::UpdateApplication::set_auto_config_enabled): (undocumented)
    /// - On success, responds with [`UpdateApplicationOutput`](crate::output::UpdateApplicationOutput) with field(s):
    ///   - [`application_info(Option<ApplicationInfo>)`](crate::output::UpdateApplicationOutput::application_info): <p>Information about the application. </p>
    /// - On failure, responds with [`SdkError<UpdateApplicationError>`](crate::error::UpdateApplicationError)
    pub fn update_application(&self) -> fluent_builders::UpdateApplication {
        fluent_builders::UpdateApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateComponent`](crate::client::fluent_builders::UpdateComponent) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_group_name(impl Into<String>)`](crate::client::fluent_builders::UpdateComponent::resource_group_name) / [`set_resource_group_name(Option<String>)`](crate::client::fluent_builders::UpdateComponent::set_resource_group_name): <p>The name of the resource group.</p>
    ///   - [`component_name(impl Into<String>)`](crate::client::fluent_builders::UpdateComponent::component_name) / [`set_component_name(Option<String>)`](crate::client::fluent_builders::UpdateComponent::set_component_name): <p>The name of the component.</p>
    ///   - [`new_component_name(impl Into<String>)`](crate::client::fluent_builders::UpdateComponent::new_component_name) / [`set_new_component_name(Option<String>)`](crate::client::fluent_builders::UpdateComponent::set_new_component_name): <p>The new name of the component.</p>
    ///   - [`resource_list(Vec<String>)`](crate::client::fluent_builders::UpdateComponent::resource_list) / [`set_resource_list(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateComponent::set_resource_list): <p>The list of resource ARNs that belong to the component.</p>
    /// - On success, responds with [`UpdateComponentOutput`](crate::output::UpdateComponentOutput)

    /// - On failure, responds with [`SdkError<UpdateComponentError>`](crate::error::UpdateComponentError)
    pub fn update_component(&self) -> fluent_builders::UpdateComponent {
        fluent_builders::UpdateComponent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateComponentConfiguration`](crate::client::fluent_builders::UpdateComponentConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_group_name(impl Into<String>)`](crate::client::fluent_builders::UpdateComponentConfiguration::resource_group_name) / [`set_resource_group_name(Option<String>)`](crate::client::fluent_builders::UpdateComponentConfiguration::set_resource_group_name): <p>The name of the resource group.</p>
    ///   - [`component_name(impl Into<String>)`](crate::client::fluent_builders::UpdateComponentConfiguration::component_name) / [`set_component_name(Option<String>)`](crate::client::fluent_builders::UpdateComponentConfiguration::set_component_name): <p>The name of the component.</p>
    ///   - [`monitor(bool)`](crate::client::fluent_builders::UpdateComponentConfiguration::monitor) / [`set_monitor(Option<bool>)`](crate::client::fluent_builders::UpdateComponentConfiguration::set_monitor): <p>Indicates whether the application component is monitored.</p>
    ///   - [`tier(Tier)`](crate::client::fluent_builders::UpdateComponentConfiguration::tier) / [`set_tier(Option<Tier>)`](crate::client::fluent_builders::UpdateComponentConfiguration::set_tier): <p>The tier of the application component. Supported tiers include <code>DOT_NET_WORKER</code>, <code>DOT_NET_WEB</code>, <code>DOT_NET_CORE</code>, <code>SQL_SERVER</code>, and <code>DEFAULT</code>.</p>
    ///   - [`component_configuration(impl Into<String>)`](crate::client::fluent_builders::UpdateComponentConfiguration::component_configuration) / [`set_component_configuration(Option<String>)`](crate::client::fluent_builders::UpdateComponentConfiguration::set_component_configuration): <p>The configuration settings of the component. The value is the escaped JSON of the configuration. For more information about the JSON format, see <a href="https://docs.aws.amazon.com/sdk-for-javascript/v2/developer-guide/working-with-json.html">Working with JSON</a>. You can send a request to <code>DescribeComponentConfigurationRecommendation</code> to see the recommended configuration for a component. For the complete format of the component configuration file, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/component-config.html">Component Configuration</a>.</p>
    ///   - [`auto_config_enabled(bool)`](crate::client::fluent_builders::UpdateComponentConfiguration::auto_config_enabled) / [`set_auto_config_enabled(Option<bool>)`](crate::client::fluent_builders::UpdateComponentConfiguration::set_auto_config_enabled): (undocumented)
    /// - On success, responds with [`UpdateComponentConfigurationOutput`](crate::output::UpdateComponentConfigurationOutput)

    /// - On failure, responds with [`SdkError<UpdateComponentConfigurationError>`](crate::error::UpdateComponentConfigurationError)
    pub fn update_component_configuration(&self) -> fluent_builders::UpdateComponentConfiguration {
        fluent_builders::UpdateComponentConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateLogPattern`](crate::client::fluent_builders::UpdateLogPattern) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_group_name(impl Into<String>)`](crate::client::fluent_builders::UpdateLogPattern::resource_group_name) / [`set_resource_group_name(Option<String>)`](crate::client::fluent_builders::UpdateLogPattern::set_resource_group_name): <p>The name of the resource group.</p>
    ///   - [`pattern_set_name(impl Into<String>)`](crate::client::fluent_builders::UpdateLogPattern::pattern_set_name) / [`set_pattern_set_name(Option<String>)`](crate::client::fluent_builders::UpdateLogPattern::set_pattern_set_name): <p>The name of the log pattern set.</p>
    ///   - [`pattern_name(impl Into<String>)`](crate::client::fluent_builders::UpdateLogPattern::pattern_name) / [`set_pattern_name(Option<String>)`](crate::client::fluent_builders::UpdateLogPattern::set_pattern_name): <p>The name of the log pattern.</p>
    ///   - [`pattern(impl Into<String>)`](crate::client::fluent_builders::UpdateLogPattern::pattern) / [`set_pattern(Option<String>)`](crate::client::fluent_builders::UpdateLogPattern::set_pattern): <p>The log pattern. The pattern must be DFA compatible. Patterns that utilize forward lookahead or backreference constructions are not supported.</p>
    ///   - [`rank(i32)`](crate::client::fluent_builders::UpdateLogPattern::rank) / [`set_rank(i32)`](crate::client::fluent_builders::UpdateLogPattern::set_rank): <p>Rank of the log pattern. Must be a value between <code>1</code> and <code>1,000,000</code>. The patterns are sorted by rank, so we recommend that you set your highest priority patterns with the lowest rank. A pattern of rank <code>1</code> will be the first to get matched to a log line. A pattern of rank <code>1,000,000</code> will be last to get matched. When you configure custom log patterns from the console, a <code>Low</code> severity pattern translates to a <code>750,000</code> rank. A <code>Medium</code> severity pattern translates to a <code>500,000</code> rank. And a <code>High</code> severity pattern translates to a <code>250,000</code> rank. Rank values less than <code>1</code> or greater than <code>1,000,000</code> are reserved for AWS-provided patterns. </p>
    /// - On success, responds with [`UpdateLogPatternOutput`](crate::output::UpdateLogPatternOutput) with field(s):
    ///   - [`resource_group_name(Option<String>)`](crate::output::UpdateLogPatternOutput::resource_group_name): <p>The name of the resource group.</p>
    ///   - [`log_pattern(Option<LogPattern>)`](crate::output::UpdateLogPatternOutput::log_pattern): <p>The successfully created log pattern.</p>
    /// - On failure, responds with [`SdkError<UpdateLogPatternError>`](crate::error::UpdateLogPatternError)
    pub fn update_log_pattern(&self) -> fluent_builders::UpdateLogPattern {
        fluent_builders::UpdateLogPattern::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateApplication`.
    ///
    /// <p>Adds an application that is created from a resource group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateApplication {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_application_input::Builder,
    }
    impl CreateApplication {
        /// Creates a new `CreateApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateApplicationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the resource group.</p>
        pub fn resource_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_group_name(input.into());
            self
        }
        /// <p>The name of the resource group.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_group_name(input);
            self
        }
        /// <p> When set to <code>true</code>, creates opsItems for any problems detected on an application. </p>
        pub fn ops_center_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.ops_center_enabled(input);
            self
        }
        /// <p> When set to <code>true</code>, creates opsItems for any problems detected on an application. </p>
        pub fn set_ops_center_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_ops_center_enabled(input);
            self
        }
        /// <p> Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as <code>instance terminated</code>, <code>failed deployment</code>, and others. </p>
        pub fn cwe_monitor_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.cwe_monitor_enabled(input);
            self
        }
        /// <p> Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as <code>instance terminated</code>, <code>failed deployment</code>, and others. </p>
        pub fn set_cwe_monitor_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_cwe_monitor_enabled(input);
            self
        }
        /// <p> The SNS topic provided to Application Insights that is associated to the created opsItem. Allows you to receive notifications for updates to the opsItem. </p>
        pub fn ops_item_sns_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ops_item_sns_topic_arn(input.into());
            self
        }
        /// <p> The SNS topic provided to Application Insights that is associated to the created opsItem. Allows you to receive notifications for updates to the opsItem. </p>
        pub fn set_ops_item_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ops_item_sns_topic_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>List of tags to add to the application. tag key (<code>Key</code>) and an associated tag value (<code>Value</code>). The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>List of tags to add to the application. tag key (<code>Key</code>) and an associated tag value (<code>Value</code>). The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn auto_config_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.auto_config_enabled(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_auto_config_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_config_enabled(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn auto_create(mut self, input: bool) -> Self {
            self.inner = self.inner.auto_create(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_auto_create(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_create(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateComponent`.
    ///
    /// <p>Creates a custom component by grouping similar standalone instances to monitor.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateComponent {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_component_input::Builder,
    }
    impl CreateComponent {
        /// Creates a new `CreateComponent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateComponentOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateComponentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the resource group.</p>
        pub fn resource_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_group_name(input.into());
            self
        }
        /// <p>The name of the resource group.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_group_name(input);
            self
        }
        /// <p>The name of the component.</p>
        pub fn component_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.component_name(input.into());
            self
        }
        /// <p>The name of the component.</p>
        pub fn set_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_component_name(input);
            self
        }
        /// Appends an item to `ResourceList`.
        ///
        /// To override the contents of this collection use [`set_resource_list`](Self::set_resource_list).
        ///
        /// <p>The list of resource ARNs that belong to the component.</p>
        pub fn resource_list(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_list(input.into());
            self
        }
        /// <p>The list of resource ARNs that belong to the component.</p>
        pub fn set_resource_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLogPattern`.
    ///
    /// <p>Adds an log pattern to a <code>LogPatternSet</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateLogPattern {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_log_pattern_input::Builder,
    }
    impl CreateLogPattern {
        /// Creates a new `CreateLogPattern`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLogPatternOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateLogPatternError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the resource group.</p>
        pub fn resource_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_group_name(input.into());
            self
        }
        /// <p>The name of the resource group.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_group_name(input);
            self
        }
        /// <p>The name of the log pattern set.</p>
        pub fn pattern_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pattern_set_name(input.into());
            self
        }
        /// <p>The name of the log pattern set.</p>
        pub fn set_pattern_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pattern_set_name(input);
            self
        }
        /// <p>The name of the log pattern.</p>
        pub fn pattern_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pattern_name(input.into());
            self
        }
        /// <p>The name of the log pattern.</p>
        pub fn set_pattern_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_pattern_name(input);
            self
        }
        /// <p>The log pattern. The pattern must be DFA compatible. Patterns that utilize forward lookahead or backreference constructions are not supported.</p>
        pub fn pattern(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pattern(input.into());
            self
        }
        /// <p>The log pattern. The pattern must be DFA compatible. Patterns that utilize forward lookahead or backreference constructions are not supported.</p>
        pub fn set_pattern(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_pattern(input);
            self
        }
        /// <p>Rank of the log pattern. Must be a value between <code>1</code> and <code>1,000,000</code>. The patterns are sorted by rank, so we recommend that you set your highest priority patterns with the lowest rank. A pattern of rank <code>1</code> will be the first to get matched to a log line. A pattern of rank <code>1,000,000</code> will be last to get matched. When you configure custom log patterns from the console, a <code>Low</code> severity pattern translates to a <code>750,000</code> rank. A <code>Medium</code> severity pattern translates to a <code>500,000</code> rank. And a <code>High</code> severity pattern translates to a <code>250,000</code> rank. Rank values less than <code>1</code> or greater than <code>1,000,000</code> are reserved for AWS-provided patterns. </p>
        pub fn rank(mut self, input: i32) -> Self {
            self.inner = self.inner.rank(input);
            self
        }
        /// <p>Rank of the log pattern. Must be a value between <code>1</code> and <code>1,000,000</code>. The patterns are sorted by rank, so we recommend that you set your highest priority patterns with the lowest rank. A pattern of rank <code>1</code> will be the first to get matched to a log line. A pattern of rank <code>1,000,000</code> will be last to get matched. When you configure custom log patterns from the console, a <code>Low</code> severity pattern translates to a <code>750,000</code> rank. A <code>Medium</code> severity pattern translates to a <code>500,000</code> rank. And a <code>High</code> severity pattern translates to a <code>250,000</code> rank. Rank values less than <code>1</code> or greater than <code>1,000,000</code> are reserved for AWS-provided patterns. </p>
        pub fn set_rank(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_rank(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteApplication`.
    ///
    /// <p>Removes the specified application from monitoring. Does not delete the application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteApplication {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_application_input::Builder,
    }
    impl DeleteApplication {
        /// Creates a new `DeleteApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteApplicationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the resource group.</p>
        pub fn resource_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_group_name(input.into());
            self
        }
        /// <p>The name of the resource group.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteComponent`.
    ///
    /// <p>Ungroups a custom component. When you ungroup custom components, all applicable monitors that are set up for the component are removed and the instances revert to their standalone status.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteComponent {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_component_input::Builder,
    }
    impl DeleteComponent {
        /// Creates a new `DeleteComponent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteComponentOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteComponentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the resource group.</p>
        pub fn resource_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_group_name(input.into());
            self
        }
        /// <p>The name of the resource group.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_group_name(input);
            self
        }
        /// <p>The name of the component.</p>
        pub fn component_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.component_name(input.into());
            self
        }
        /// <p>The name of the component.</p>
        pub fn set_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_component_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteLogPattern`.
    ///
    /// <p>Removes the specified log pattern from a <code>LogPatternSet</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteLogPattern {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_log_pattern_input::Builder,
    }
    impl DeleteLogPattern {
        /// Creates a new `DeleteLogPattern`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteLogPatternOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteLogPatternError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the resource group.</p>
        pub fn resource_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_group_name(input.into());
            self
        }
        /// <p>The name of the resource group.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_group_name(input);
            self
        }
        /// <p>The name of the log pattern set.</p>
        pub fn pattern_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pattern_set_name(input.into());
            self
        }
        /// <p>The name of the log pattern set.</p>
        pub fn set_pattern_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pattern_set_name(input);
            self
        }
        /// <p>The name of the log pattern.</p>
        pub fn pattern_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pattern_name(input.into());
            self
        }
        /// <p>The name of the log pattern.</p>
        pub fn set_pattern_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_pattern_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeApplication`.
    ///
    /// <p>Describes the application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeApplication {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_application_input::Builder,
    }
    impl DescribeApplication {
        /// Creates a new `DescribeApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeApplicationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the resource group.</p>
        pub fn resource_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_group_name(input.into());
            self
        }
        /// <p>The name of the resource group.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeComponent`.
    ///
    /// <p>Describes a component and lists the resources that are grouped together in a component.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeComponent {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_component_input::Builder,
    }
    impl DescribeComponent {
        /// Creates a new `DescribeComponent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeComponentOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeComponentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the resource group.</p>
        pub fn resource_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_group_name(input.into());
            self
        }
        /// <p>The name of the resource group.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_group_name(input);
            self
        }
        /// <p>The name of the component.</p>
        pub fn component_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.component_name(input.into());
            self
        }
        /// <p>The name of the component.</p>
        pub fn set_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_component_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeComponentConfiguration`.
    ///
    /// <p>Describes the monitoring configuration of the component.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeComponentConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_component_configuration_input::Builder,
    }
    impl DescribeComponentConfiguration {
        /// Creates a new `DescribeComponentConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeComponentConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeComponentConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the resource group.</p>
        pub fn resource_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_group_name(input.into());
            self
        }
        /// <p>The name of the resource group.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_group_name(input);
            self
        }
        /// <p>The name of the component.</p>
        pub fn component_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.component_name(input.into());
            self
        }
        /// <p>The name of the component.</p>
        pub fn set_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_component_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeComponentConfigurationRecommendation`.
    ///
    /// <p>Describes the recommended monitoring configuration of the component.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeComponentConfigurationRecommendation {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_component_configuration_recommendation_input::Builder,
    }
    impl DescribeComponentConfigurationRecommendation {
        /// Creates a new `DescribeComponentConfigurationRecommendation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeComponentConfigurationRecommendationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeComponentConfigurationRecommendationError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the resource group.</p>
        pub fn resource_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_group_name(input.into());
            self
        }
        /// <p>The name of the resource group.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_group_name(input);
            self
        }
        /// <p>The name of the component.</p>
        pub fn component_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.component_name(input.into());
            self
        }
        /// <p>The name of the component.</p>
        pub fn set_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_component_name(input);
            self
        }
        /// <p>The tier of the application component. Supported tiers include <code>DOT_NET_CORE</code>, <code>DOT_NET_WORKER</code>, <code>DOT_NET_WEB</code>, <code>SQL_SERVER</code>, and <code>DEFAULT</code>.</p>
        pub fn tier(mut self, input: crate::model::Tier) -> Self {
            self.inner = self.inner.tier(input);
            self
        }
        /// <p>The tier of the application component. Supported tiers include <code>DOT_NET_CORE</code>, <code>DOT_NET_WORKER</code>, <code>DOT_NET_WEB</code>, <code>SQL_SERVER</code>, and <code>DEFAULT</code>.</p>
        pub fn set_tier(mut self, input: std::option::Option<crate::model::Tier>) -> Self {
            self.inner = self.inner.set_tier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeLogPattern`.
    ///
    /// <p>Describe a specific log pattern from a <code>LogPatternSet</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeLogPattern {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_log_pattern_input::Builder,
    }
    impl DescribeLogPattern {
        /// Creates a new `DescribeLogPattern`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeLogPatternOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeLogPatternError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the resource group.</p>
        pub fn resource_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_group_name(input.into());
            self
        }
        /// <p>The name of the resource group.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_group_name(input);
            self
        }
        /// <p>The name of the log pattern set.</p>
        pub fn pattern_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pattern_set_name(input.into());
            self
        }
        /// <p>The name of the log pattern set.</p>
        pub fn set_pattern_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pattern_set_name(input);
            self
        }
        /// <p>The name of the log pattern.</p>
        pub fn pattern_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pattern_name(input.into());
            self
        }
        /// <p>The name of the log pattern.</p>
        pub fn set_pattern_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_pattern_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeObservation`.
    ///
    /// <p>Describes an anomaly or error with the application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeObservation {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_observation_input::Builder,
    }
    impl DescribeObservation {
        /// Creates a new `DescribeObservation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeObservationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeObservationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the observation.</p>
        pub fn observation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.observation_id(input.into());
            self
        }
        /// <p>The ID of the observation.</p>
        pub fn set_observation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_observation_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeProblem`.
    ///
    /// <p>Describes an application problem.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeProblem {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_problem_input::Builder,
    }
    impl DescribeProblem {
        /// Creates a new `DescribeProblem`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeProblemOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeProblemError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the problem.</p>
        pub fn problem_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.problem_id(input.into());
            self
        }
        /// <p>The ID of the problem.</p>
        pub fn set_problem_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_problem_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeProblemObservations`.
    ///
    /// <p>Describes the anomalies or errors associated with the problem.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeProblemObservations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_problem_observations_input::Builder,
    }
    impl DescribeProblemObservations {
        /// Creates a new `DescribeProblemObservations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeProblemObservationsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeProblemObservationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the problem.</p>
        pub fn problem_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.problem_id(input.into());
            self
        }
        /// <p>The ID of the problem.</p>
        pub fn set_problem_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_problem_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListApplications`.
    ///
    /// <p>Lists the IDs of the applications that you are monitoring. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListApplications {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_applications_input::Builder,
    }
    impl ListApplications {
        /// Creates a new `ListApplications`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListApplicationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListApplicationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListApplicationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListApplicationsPaginator {
            crate::paginator::ListApplicationsPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListComponents`.
    ///
    /// <p>Lists the auto-grouped, standalone, and custom components of the application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListComponents {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_components_input::Builder,
    }
    impl ListComponents {
        /// Creates a new `ListComponents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListComponentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListComponentsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListComponentsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListComponentsPaginator {
            crate::paginator::ListComponentsPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the resource group.</p>
        pub fn resource_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_group_name(input.into());
            self
        }
        /// <p>The name of the resource group.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_group_name(input);
            self
        }
        /// <p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListConfigurationHistory`.
    ///
    /// <p> Lists the INFO, WARN, and ERROR events for periodic configuration updates performed by Application Insights. Examples of events represented are: </p>
    /// <ul>
    /// <li> <p>INFO: creating a new alarm or updating an alarm threshold.</p> </li>
    /// <li> <p>WARN: alarm not created due to insufficient data points used to predict thresholds.</p> </li>
    /// <li> <p>ERROR: alarm not created due to permission errors or exceeding quotas. </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListConfigurationHistory {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_configuration_history_input::Builder,
    }
    impl ListConfigurationHistory {
        /// Creates a new `ListConfigurationHistory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListConfigurationHistoryOutput,
            aws_smithy_http::result::SdkError<crate::error::ListConfigurationHistoryError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListConfigurationHistoryPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListConfigurationHistoryPaginator {
            crate::paginator::ListConfigurationHistoryPaginator::new(self.handle, self.inner)
        }
        /// <p>Resource group to which the application belongs. </p>
        pub fn resource_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_group_name(input.into());
            self
        }
        /// <p>Resource group to which the application belongs. </p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_group_name(input);
            self
        }
        /// <p>The start time of the event. </p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(input);
            self
        }
        /// <p>The start time of the event. </p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>The end time of the event.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(input);
            self
        }
        /// <p>The end time of the event.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>The status of the configuration update event. Possible values include INFO, WARN, and ERROR.</p>
        pub fn event_status(mut self, input: crate::model::ConfigurationEventStatus) -> Self {
            self.inner = self.inner.event_status(input);
            self
        }
        /// <p>The status of the configuration update event. Possible values include INFO, WARN, and ERROR.</p>
        pub fn set_event_status(
            mut self,
            input: std::option::Option<crate::model::ConfigurationEventStatus>,
        ) -> Self {
            self.inner = self.inner.set_event_status(input);
            self
        }
        /// <p> The maximum number of results returned by <code>ListConfigurationHistory</code> in paginated output. When this parameter is used, <code>ListConfigurationHistory</code> returns only <code>MaxResults</code> in a single page along with a <code>NextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListConfigurationHistory</code> request with the returned <code>NextToken</code> value. If this parameter is not used, then <code>ListConfigurationHistory</code> returns all results. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> The maximum number of results returned by <code>ListConfigurationHistory</code> in paginated output. When this parameter is used, <code>ListConfigurationHistory</code> returns only <code>MaxResults</code> in a single page along with a <code>NextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListConfigurationHistory</code> request with the returned <code>NextToken</code> value. If this parameter is not used, then <code>ListConfigurationHistory</code> returns all results. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The <code>NextToken</code> value returned from a previous paginated <code>ListConfigurationHistory</code> request where <code>MaxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>NextToken</code> value. This value is <code>null</code> when there are no more results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>NextToken</code> value returned from a previous paginated <code>ListConfigurationHistory</code> request where <code>MaxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>NextToken</code> value. This value is <code>null</code> when there are no more results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLogPatterns`.
    ///
    /// <p>Lists the log patterns in the specific log <code>LogPatternSet</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListLogPatterns {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_log_patterns_input::Builder,
    }
    impl ListLogPatterns {
        /// Creates a new `ListLogPatterns`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLogPatternsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListLogPatternsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListLogPatternsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListLogPatternsPaginator {
            crate::paginator::ListLogPatternsPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the resource group.</p>
        pub fn resource_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_group_name(input.into());
            self
        }
        /// <p>The name of the resource group.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_group_name(input);
            self
        }
        /// <p>The name of the log pattern set.</p>
        pub fn pattern_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pattern_set_name(input.into());
            self
        }
        /// <p>The name of the log pattern set.</p>
        pub fn set_pattern_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pattern_set_name(input);
            self
        }
        /// <p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLogPatternSets`.
    ///
    /// <p>Lists the log pattern sets in the specific application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListLogPatternSets {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_log_pattern_sets_input::Builder,
    }
    impl ListLogPatternSets {
        /// Creates a new `ListLogPatternSets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLogPatternSetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListLogPatternSetsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListLogPatternSetsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListLogPatternSetsPaginator {
            crate::paginator::ListLogPatternSetsPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the resource group.</p>
        pub fn resource_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_group_name(input.into());
            self
        }
        /// <p>The name of the resource group.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_group_name(input);
            self
        }
        /// <p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListProblems`.
    ///
    /// <p>Lists the problems with your application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListProblems {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_problems_input::Builder,
    }
    impl ListProblems {
        /// Creates a new `ListProblems`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListProblemsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListProblemsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListProblemsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListProblemsPaginator {
            crate::paginator::ListProblemsPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the resource group.</p>
        pub fn resource_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_group_name(input.into());
            self
        }
        /// <p>The name of the resource group.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_group_name(input);
            self
        }
        /// <p>The time when the problem was detected, in epoch seconds. If you don't specify a time frame for the request, problems within the past seven days are returned.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(input);
            self
        }
        /// <p>The time when the problem was detected, in epoch seconds. If you don't specify a time frame for the request, problems within the past seven days are returned.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>The time when the problem ended, in epoch seconds. If not specified, problems within the past seven days are returned.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(input);
            self
        }
        /// <p>The time when the problem ended, in epoch seconds. If not specified, problems within the past seven days are returned.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn component_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.component_name(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_component_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Retrieve a list of the tags (keys and values) that are associated with a specified application. A <i>tag</i> is a label that you optionally define and associate with an application. Each tag consists of a required <i>tag key</i> and an optional associated <i>tag value</i>. A tag key is a general label that acts as a category for more specific tag values. A tag value acts as a descriptor within a tag key.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the application that you want to retrieve tag information for.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application that you want to retrieve tag information for.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Add one or more tags (keys and values) to a specified application. A <i>tag</i> is a label that you optionally define and associate with an application. Tags can help you categorize and manage application in different ways, such as by purpose, owner, environment, or other criteria. </p>
    /// <p>Each tag consists of a required <i>tag key</i> and an associated <i>tag value</i>, both of which you define. A tag key is a general label that acts as a category for more specific tag values. A tag value acts as a descriptor within a tag key.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the application that you want to add one or more tags to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application that you want to add one or more tags to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags that to add to the application. A tag consists of a required tag key (<code>Key</code>) and an associated tag value (<code>Value</code>). The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tags that to add to the application. A tag consists of a required tag key (<code>Key</code>) and an associated tag value (<code>Value</code>). The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Remove one or more tags (keys and values) from a specified application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the application that you want to remove one or more tags from.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application that you want to remove one or more tags from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tags (tag keys) that you want to remove from the resource. When you specify a tag key, the action removes both that key and its associated tag value.</p>
        /// <p>To remove more than one tag from the application, append the <code>TagKeys</code> parameter and argument for each additional tag to remove, separated by an ampersand. </p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The tags (tag keys) that you want to remove from the resource. When you specify a tag key, the action removes both that key and its associated tag value.</p>
        /// <p>To remove more than one tag from the application, append the <code>TagKeys</code> parameter and argument for each additional tag to remove, separated by an ampersand. </p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateApplication`.
    ///
    /// <p>Updates the application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateApplication {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_application_input::Builder,
    }
    impl UpdateApplication {
        /// Creates a new `UpdateApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateApplicationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the resource group.</p>
        pub fn resource_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_group_name(input.into());
            self
        }
        /// <p>The name of the resource group.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_group_name(input);
            self
        }
        /// <p> When set to <code>true</code>, creates opsItems for any problems detected on an application. </p>
        pub fn ops_center_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.ops_center_enabled(input);
            self
        }
        /// <p> When set to <code>true</code>, creates opsItems for any problems detected on an application. </p>
        pub fn set_ops_center_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_ops_center_enabled(input);
            self
        }
        /// <p> Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as <code>instance terminated</code>, <code>failed deployment</code>, and others. </p>
        pub fn cwe_monitor_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.cwe_monitor_enabled(input);
            self
        }
        /// <p> Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as <code>instance terminated</code>, <code>failed deployment</code>, and others. </p>
        pub fn set_cwe_monitor_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_cwe_monitor_enabled(input);
            self
        }
        /// <p> The SNS topic provided to Application Insights that is associated to the created opsItem. Allows you to receive notifications for updates to the opsItem.</p>
        pub fn ops_item_sns_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ops_item_sns_topic_arn(input.into());
            self
        }
        /// <p> The SNS topic provided to Application Insights that is associated to the created opsItem. Allows you to receive notifications for updates to the opsItem.</p>
        pub fn set_ops_item_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ops_item_sns_topic_arn(input);
            self
        }
        /// <p> Disassociates the SNS topic from the opsItem created for detected problems.</p>
        pub fn remove_sns_topic(mut self, input: bool) -> Self {
            self.inner = self.inner.remove_sns_topic(input);
            self
        }
        /// <p> Disassociates the SNS topic from the opsItem created for detected problems.</p>
        pub fn set_remove_sns_topic(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_remove_sns_topic(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn auto_config_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.auto_config_enabled(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_auto_config_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_config_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateComponent`.
    ///
    /// <p>Updates the custom component name and/or the list of resources that make up the component.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateComponent {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_component_input::Builder,
    }
    impl UpdateComponent {
        /// Creates a new `UpdateComponent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateComponentOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateComponentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the resource group.</p>
        pub fn resource_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_group_name(input.into());
            self
        }
        /// <p>The name of the resource group.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_group_name(input);
            self
        }
        /// <p>The name of the component.</p>
        pub fn component_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.component_name(input.into());
            self
        }
        /// <p>The name of the component.</p>
        pub fn set_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_component_name(input);
            self
        }
        /// <p>The new name of the component.</p>
        pub fn new_component_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.new_component_name(input.into());
            self
        }
        /// <p>The new name of the component.</p>
        pub fn set_new_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_new_component_name(input);
            self
        }
        /// Appends an item to `ResourceList`.
        ///
        /// To override the contents of this collection use [`set_resource_list`](Self::set_resource_list).
        ///
        /// <p>The list of resource ARNs that belong to the component.</p>
        pub fn resource_list(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_list(input.into());
            self
        }
        /// <p>The list of resource ARNs that belong to the component.</p>
        pub fn set_resource_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateComponentConfiguration`.
    ///
    /// <p>Updates the monitoring configurations for the component. The configuration input parameter is an escaped JSON of the configuration and should match the schema of what is returned by <code>DescribeComponentConfigurationRecommendation</code>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateComponentConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_component_configuration_input::Builder,
    }
    impl UpdateComponentConfiguration {
        /// Creates a new `UpdateComponentConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateComponentConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateComponentConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the resource group.</p>
        pub fn resource_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_group_name(input.into());
            self
        }
        /// <p>The name of the resource group.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_group_name(input);
            self
        }
        /// <p>The name of the component.</p>
        pub fn component_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.component_name(input.into());
            self
        }
        /// <p>The name of the component.</p>
        pub fn set_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_component_name(input);
            self
        }
        /// <p>Indicates whether the application component is monitored.</p>
        pub fn monitor(mut self, input: bool) -> Self {
            self.inner = self.inner.monitor(input);
            self
        }
        /// <p>Indicates whether the application component is monitored.</p>
        pub fn set_monitor(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_monitor(input);
            self
        }
        /// <p>The tier of the application component. Supported tiers include <code>DOT_NET_WORKER</code>, <code>DOT_NET_WEB</code>, <code>DOT_NET_CORE</code>, <code>SQL_SERVER</code>, and <code>DEFAULT</code>.</p>
        pub fn tier(mut self, input: crate::model::Tier) -> Self {
            self.inner = self.inner.tier(input);
            self
        }
        /// <p>The tier of the application component. Supported tiers include <code>DOT_NET_WORKER</code>, <code>DOT_NET_WEB</code>, <code>DOT_NET_CORE</code>, <code>SQL_SERVER</code>, and <code>DEFAULT</code>.</p>
        pub fn set_tier(mut self, input: std::option::Option<crate::model::Tier>) -> Self {
            self.inner = self.inner.set_tier(input);
            self
        }
        /// <p>The configuration settings of the component. The value is the escaped JSON of the configuration. For more information about the JSON format, see <a href="https://docs.aws.amazon.com/sdk-for-javascript/v2/developer-guide/working-with-json.html">Working with JSON</a>. You can send a request to <code>DescribeComponentConfigurationRecommendation</code> to see the recommended configuration for a component. For the complete format of the component configuration file, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/component-config.html">Component Configuration</a>.</p>
        pub fn component_configuration(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.component_configuration(input.into());
            self
        }
        /// <p>The configuration settings of the component. The value is the escaped JSON of the configuration. For more information about the JSON format, see <a href="https://docs.aws.amazon.com/sdk-for-javascript/v2/developer-guide/working-with-json.html">Working with JSON</a>. You can send a request to <code>DescribeComponentConfigurationRecommendation</code> to see the recommended configuration for a component. For the complete format of the component configuration file, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/component-config.html">Component Configuration</a>.</p>
        pub fn set_component_configuration(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_component_configuration(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn auto_config_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.auto_config_enabled(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_auto_config_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_config_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateLogPattern`.
    ///
    /// <p>Adds a log pattern to a <code>LogPatternSet</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateLogPattern {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_log_pattern_input::Builder,
    }
    impl UpdateLogPattern {
        /// Creates a new `UpdateLogPattern`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateLogPatternOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateLogPatternError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the resource group.</p>
        pub fn resource_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_group_name(input.into());
            self
        }
        /// <p>The name of the resource group.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_group_name(input);
            self
        }
        /// <p>The name of the log pattern set.</p>
        pub fn pattern_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pattern_set_name(input.into());
            self
        }
        /// <p>The name of the log pattern set.</p>
        pub fn set_pattern_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pattern_set_name(input);
            self
        }
        /// <p>The name of the log pattern.</p>
        pub fn pattern_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pattern_name(input.into());
            self
        }
        /// <p>The name of the log pattern.</p>
        pub fn set_pattern_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_pattern_name(input);
            self
        }
        /// <p>The log pattern. The pattern must be DFA compatible. Patterns that utilize forward lookahead or backreference constructions are not supported.</p>
        pub fn pattern(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pattern(input.into());
            self
        }
        /// <p>The log pattern. The pattern must be DFA compatible. Patterns that utilize forward lookahead or backreference constructions are not supported.</p>
        pub fn set_pattern(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_pattern(input);
            self
        }
        /// <p>Rank of the log pattern. Must be a value between <code>1</code> and <code>1,000,000</code>. The patterns are sorted by rank, so we recommend that you set your highest priority patterns with the lowest rank. A pattern of rank <code>1</code> will be the first to get matched to a log line. A pattern of rank <code>1,000,000</code> will be last to get matched. When you configure custom log patterns from the console, a <code>Low</code> severity pattern translates to a <code>750,000</code> rank. A <code>Medium</code> severity pattern translates to a <code>500,000</code> rank. And a <code>High</code> severity pattern translates to a <code>250,000</code> rank. Rank values less than <code>1</code> or greater than <code>1,000,000</code> are reserved for AWS-provided patterns. </p>
        pub fn rank(mut self, input: i32) -> Self {
            self.inner = self.inner.rank(input);
            self
        }
        /// <p>Rank of the log pattern. Must be a value between <code>1</code> and <code>1,000,000</code>. The patterns are sorted by rank, so we recommend that you set your highest priority patterns with the lowest rank. A pattern of rank <code>1</code> will be the first to get matched to a log line. A pattern of rank <code>1,000,000</code> will be last to get matched. When you configure custom log patterns from the console, a <code>Low</code> severity pattern translates to a <code>750,000</code> rank. A <code>Medium</code> severity pattern translates to a <code>500,000</code> rank. And a <code>High</code> severity pattern translates to a <code>250,000</code> rank. Rank values less than <code>1</code> or greater than <code>1,000,000</code> are reserved for AWS-provided patterns. </p>
        pub fn set_rank(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_rank(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
