// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CreateApplicationInput`](crate::input::CreateApplicationInput)
pub mod create_application_input {
    /// A builder for [`CreateApplicationInput`](crate::input::CreateApplicationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_group_name: std::option::Option<std::string::String>,
        pub(crate) ops_center_enabled: std::option::Option<bool>,
        pub(crate) cwe_monitor_enabled: std::option::Option<bool>,
        pub(crate) ops_item_sns_topic_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) auto_config_enabled: std::option::Option<bool>,
        pub(crate) auto_create: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the resource group.</p>
        pub fn resource_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_group_name = Some(input.into());
            self
        }
        /// <p>The name of the resource group.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_group_name = input;
            self
        }
        /// <p>
        /// When set to <code>true</code>, creates opsItems for any problems detected on an application.
        /// </p>
        pub fn ops_center_enabled(mut self, input: bool) -> Self {
            self.ops_center_enabled = Some(input);
            self
        }
        /// <p>
        /// When set to <code>true</code>, creates opsItems for any problems detected on an application.
        /// </p>
        pub fn set_ops_center_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.ops_center_enabled = input;
            self
        }
        /// <p>
        /// Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as <code>instance terminated</code>, <code>failed deployment</code>, and others.
        /// </p>
        pub fn cwe_monitor_enabled(mut self, input: bool) -> Self {
            self.cwe_monitor_enabled = Some(input);
            self
        }
        /// <p>
        /// Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as <code>instance terminated</code>, <code>failed deployment</code>, and others.
        /// </p>
        pub fn set_cwe_monitor_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.cwe_monitor_enabled = input;
            self
        }
        /// <p>
        /// The SNS topic provided to Application Insights that is associated to the created opsItem. Allows you to
        /// receive notifications for updates to the opsItem.
        /// </p>
        pub fn ops_item_sns_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.ops_item_sns_topic_arn = Some(input.into());
            self
        }
        /// <p>
        /// The SNS topic provided to Application Insights that is associated to the created opsItem. Allows you to
        /// receive notifications for updates to the opsItem.
        /// </p>
        pub fn set_ops_item_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ops_item_sns_topic_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>List of tags to add to the application.
        /// tag key (<code>Key</code>) and an associated tag value (<code>Value</code>). The maximum
        /// length of a tag key is 128 characters. The maximum length of a tag value is 256
        /// characters.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>List of tags to add to the application.
        /// tag key (<code>Key</code>) and an associated tag value (<code>Value</code>). The maximum
        /// length of a tag key is 128 characters. The maximum length of a tag value is 256
        /// characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn auto_config_enabled(mut self, input: bool) -> Self {
            self.auto_config_enabled = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_auto_config_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_config_enabled = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn auto_create(mut self, input: bool) -> Self {
            self.auto_create = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_auto_create(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_create = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateApplicationInput`](crate::input::CreateApplicationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateApplicationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateApplicationInput {
                resource_group_name: self.resource_group_name,
                ops_center_enabled: self.ops_center_enabled,
                cwe_monitor_enabled: self.cwe_monitor_enabled,
                ops_item_sns_topic_arn: self.ops_item_sns_topic_arn,
                tags: self.tags,
                auto_config_enabled: self.auto_config_enabled,
                auto_create: self.auto_create,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateApplicationInputOperationOutputAlias = crate::operation::CreateApplication;
#[doc(hidden)]
pub type CreateApplicationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateApplicationInput {
    /// Consumes the builder and constructs an Operation<[`CreateApplication`](crate::operation::CreateApplication)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateApplication,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateApplicationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateApplicationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateApplicationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "EC2WindowsBarleyService.CreateApplication",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_application(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateApplication::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateApplication",
            "applicationinsights",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateApplicationInput`](crate::input::CreateApplicationInput)
    pub fn builder() -> crate::input::create_application_input::Builder {
        crate::input::create_application_input::Builder::default()
    }
}

/// See [`CreateComponentInput`](crate::input::CreateComponentInput)
pub mod create_component_input {
    /// A builder for [`CreateComponentInput`](crate::input::CreateComponentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_group_name: std::option::Option<std::string::String>,
        pub(crate) component_name: std::option::Option<std::string::String>,
        pub(crate) resource_list: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the resource group.</p>
        pub fn resource_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_group_name = Some(input.into());
            self
        }
        /// <p>The name of the resource group.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_group_name = input;
            self
        }
        /// <p>The name of the component.</p>
        pub fn component_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_name = Some(input.into());
            self
        }
        /// <p>The name of the component.</p>
        pub fn set_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_name = input;
            self
        }
        /// Appends an item to `resource_list`.
        ///
        /// To override the contents of this collection use [`set_resource_list`](Self::set_resource_list).
        ///
        /// <p>The list of resource ARNs that belong to the component.</p>
        pub fn resource_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resource_list.unwrap_or_default();
            v.push(input.into());
            self.resource_list = Some(v);
            self
        }
        /// <p>The list of resource ARNs that belong to the component.</p>
        pub fn set_resource_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resource_list = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateComponentInput`](crate::input::CreateComponentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateComponentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateComponentInput {
                resource_group_name: self.resource_group_name,
                component_name: self.component_name,
                resource_list: self.resource_list,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateComponentInputOperationOutputAlias = crate::operation::CreateComponent;
#[doc(hidden)]
pub type CreateComponentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateComponentInput {
    /// Consumes the builder and constructs an Operation<[`CreateComponent`](crate::operation::CreateComponent)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateComponent,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateComponentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateComponentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateComponentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "EC2WindowsBarleyService.CreateComponent",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_component(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateComponent::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateComponent",
            "applicationinsights",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateComponentInput`](crate::input::CreateComponentInput)
    pub fn builder() -> crate::input::create_component_input::Builder {
        crate::input::create_component_input::Builder::default()
    }
}

/// See [`CreateLogPatternInput`](crate::input::CreateLogPatternInput)
pub mod create_log_pattern_input {
    /// A builder for [`CreateLogPatternInput`](crate::input::CreateLogPatternInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_group_name: std::option::Option<std::string::String>,
        pub(crate) pattern_set_name: std::option::Option<std::string::String>,
        pub(crate) pattern_name: std::option::Option<std::string::String>,
        pub(crate) pattern: std::option::Option<std::string::String>,
        pub(crate) rank: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the resource group.</p>
        pub fn resource_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_group_name = Some(input.into());
            self
        }
        /// <p>The name of the resource group.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_group_name = input;
            self
        }
        /// <p>The name of the log pattern set.</p>
        pub fn pattern_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.pattern_set_name = Some(input.into());
            self
        }
        /// <p>The name of the log pattern set.</p>
        pub fn set_pattern_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pattern_set_name = input;
            self
        }
        /// <p>The name of the log pattern.</p>
        pub fn pattern_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.pattern_name = Some(input.into());
            self
        }
        /// <p>The name of the log pattern.</p>
        pub fn set_pattern_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pattern_name = input;
            self
        }
        /// <p>The log pattern. The pattern must be DFA compatible. Patterns that utilize forward lookahead or backreference constructions are not supported.</p>
        pub fn pattern(mut self, input: impl Into<std::string::String>) -> Self {
            self.pattern = Some(input.into());
            self
        }
        /// <p>The log pattern. The pattern must be DFA compatible. Patterns that utilize forward lookahead or backreference constructions are not supported.</p>
        pub fn set_pattern(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pattern = input;
            self
        }
        /// <p>Rank of the log pattern. Must be a value between <code>1</code> and <code>1,000,000</code>. The patterns are sorted by rank, so we recommend that you set your highest priority patterns with the lowest rank. A pattern of rank <code>1</code> will be the first to get matched to a log line. A pattern of rank <code>1,000,000</code> will be last to get matched. When you configure custom log patterns from the console, a <code>Low</code> severity pattern translates to a <code>750,000</code> rank. A <code>Medium</code> severity pattern translates to a <code>500,000</code> rank. And a <code>High</code> severity pattern translates to a <code>250,000</code> rank.
        /// Rank values less than <code>1</code> or greater than <code>1,000,000</code> are reserved for AWS-provided patterns.
        /// </p>
        pub fn rank(mut self, input: i32) -> Self {
            self.rank = Some(input);
            self
        }
        /// <p>Rank of the log pattern. Must be a value between <code>1</code> and <code>1,000,000</code>. The patterns are sorted by rank, so we recommend that you set your highest priority patterns with the lowest rank. A pattern of rank <code>1</code> will be the first to get matched to a log line. A pattern of rank <code>1,000,000</code> will be last to get matched. When you configure custom log patterns from the console, a <code>Low</code> severity pattern translates to a <code>750,000</code> rank. A <code>Medium</code> severity pattern translates to a <code>500,000</code> rank. And a <code>High</code> severity pattern translates to a <code>250,000</code> rank.
        /// Rank values less than <code>1</code> or greater than <code>1,000,000</code> are reserved for AWS-provided patterns.
        /// </p>
        pub fn set_rank(mut self, input: std::option::Option<i32>) -> Self {
            self.rank = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateLogPatternInput`](crate::input::CreateLogPatternInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateLogPatternInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateLogPatternInput {
                resource_group_name: self.resource_group_name,
                pattern_set_name: self.pattern_set_name,
                pattern_name: self.pattern_name,
                pattern: self.pattern,
                rank: self.rank.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type CreateLogPatternInputOperationOutputAlias = crate::operation::CreateLogPattern;
#[doc(hidden)]
pub type CreateLogPatternInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateLogPatternInput {
    /// Consumes the builder and constructs an Operation<[`CreateLogPattern`](crate::operation::CreateLogPattern)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateLogPattern,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateLogPatternInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateLogPatternInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateLogPatternInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "EC2WindowsBarleyService.CreateLogPattern",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_log_pattern(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateLogPattern::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateLogPattern",
            "applicationinsights",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateLogPatternInput`](crate::input::CreateLogPatternInput)
    pub fn builder() -> crate::input::create_log_pattern_input::Builder {
        crate::input::create_log_pattern_input::Builder::default()
    }
}

/// See [`DeleteApplicationInput`](crate::input::DeleteApplicationInput)
pub mod delete_application_input {
    /// A builder for [`DeleteApplicationInput`](crate::input::DeleteApplicationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the resource group.</p>
        pub fn resource_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_group_name = Some(input.into());
            self
        }
        /// <p>The name of the resource group.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteApplicationInput`](crate::input::DeleteApplicationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteApplicationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteApplicationInput {
                resource_group_name: self.resource_group_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteApplicationInputOperationOutputAlias = crate::operation::DeleteApplication;
#[doc(hidden)]
pub type DeleteApplicationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteApplicationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteApplication`](crate::operation::DeleteApplication)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteApplication,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteApplicationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteApplicationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteApplicationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "EC2WindowsBarleyService.DeleteApplication",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_application(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteApplication::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteApplication",
            "applicationinsights",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteApplicationInput`](crate::input::DeleteApplicationInput)
    pub fn builder() -> crate::input::delete_application_input::Builder {
        crate::input::delete_application_input::Builder::default()
    }
}

/// See [`DeleteComponentInput`](crate::input::DeleteComponentInput)
pub mod delete_component_input {
    /// A builder for [`DeleteComponentInput`](crate::input::DeleteComponentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_group_name: std::option::Option<std::string::String>,
        pub(crate) component_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the resource group.</p>
        pub fn resource_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_group_name = Some(input.into());
            self
        }
        /// <p>The name of the resource group.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_group_name = input;
            self
        }
        /// <p>The name of the component.</p>
        pub fn component_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_name = Some(input.into());
            self
        }
        /// <p>The name of the component.</p>
        pub fn set_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteComponentInput`](crate::input::DeleteComponentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteComponentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteComponentInput {
                resource_group_name: self.resource_group_name,
                component_name: self.component_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteComponentInputOperationOutputAlias = crate::operation::DeleteComponent;
#[doc(hidden)]
pub type DeleteComponentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteComponentInput {
    /// Consumes the builder and constructs an Operation<[`DeleteComponent`](crate::operation::DeleteComponent)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteComponent,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteComponentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteComponentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteComponentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "EC2WindowsBarleyService.DeleteComponent",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_component(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteComponent::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteComponent",
            "applicationinsights",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteComponentInput`](crate::input::DeleteComponentInput)
    pub fn builder() -> crate::input::delete_component_input::Builder {
        crate::input::delete_component_input::Builder::default()
    }
}

/// See [`DeleteLogPatternInput`](crate::input::DeleteLogPatternInput)
pub mod delete_log_pattern_input {
    /// A builder for [`DeleteLogPatternInput`](crate::input::DeleteLogPatternInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_group_name: std::option::Option<std::string::String>,
        pub(crate) pattern_set_name: std::option::Option<std::string::String>,
        pub(crate) pattern_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the resource group.</p>
        pub fn resource_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_group_name = Some(input.into());
            self
        }
        /// <p>The name of the resource group.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_group_name = input;
            self
        }
        /// <p>The name of the log pattern set.</p>
        pub fn pattern_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.pattern_set_name = Some(input.into());
            self
        }
        /// <p>The name of the log pattern set.</p>
        pub fn set_pattern_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pattern_set_name = input;
            self
        }
        /// <p>The name of the log pattern.</p>
        pub fn pattern_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.pattern_name = Some(input.into());
            self
        }
        /// <p>The name of the log pattern.</p>
        pub fn set_pattern_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pattern_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteLogPatternInput`](crate::input::DeleteLogPatternInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteLogPatternInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteLogPatternInput {
                resource_group_name: self.resource_group_name,
                pattern_set_name: self.pattern_set_name,
                pattern_name: self.pattern_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteLogPatternInputOperationOutputAlias = crate::operation::DeleteLogPattern;
#[doc(hidden)]
pub type DeleteLogPatternInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteLogPatternInput {
    /// Consumes the builder and constructs an Operation<[`DeleteLogPattern`](crate::operation::DeleteLogPattern)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteLogPattern,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteLogPatternInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteLogPatternInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteLogPatternInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "EC2WindowsBarleyService.DeleteLogPattern",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_log_pattern(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteLogPattern::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteLogPattern",
            "applicationinsights",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteLogPatternInput`](crate::input::DeleteLogPatternInput)
    pub fn builder() -> crate::input::delete_log_pattern_input::Builder {
        crate::input::delete_log_pattern_input::Builder::default()
    }
}

/// See [`DescribeApplicationInput`](crate::input::DescribeApplicationInput)
pub mod describe_application_input {
    /// A builder for [`DescribeApplicationInput`](crate::input::DescribeApplicationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the resource group.</p>
        pub fn resource_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_group_name = Some(input.into());
            self
        }
        /// <p>The name of the resource group.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeApplicationInput`](crate::input::DescribeApplicationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeApplicationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeApplicationInput {
                resource_group_name: self.resource_group_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeApplicationInputOperationOutputAlias = crate::operation::DescribeApplication;
#[doc(hidden)]
pub type DescribeApplicationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeApplicationInput {
    /// Consumes the builder and constructs an Operation<[`DescribeApplication`](crate::operation::DescribeApplication)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeApplication,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeApplicationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeApplicationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeApplicationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "EC2WindowsBarleyService.DescribeApplication",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_application(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeApplication::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeApplication",
            "applicationinsights",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeApplicationInput`](crate::input::DescribeApplicationInput)
    pub fn builder() -> crate::input::describe_application_input::Builder {
        crate::input::describe_application_input::Builder::default()
    }
}

/// See [`DescribeComponentInput`](crate::input::DescribeComponentInput)
pub mod describe_component_input {
    /// A builder for [`DescribeComponentInput`](crate::input::DescribeComponentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_group_name: std::option::Option<std::string::String>,
        pub(crate) component_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the resource group.</p>
        pub fn resource_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_group_name = Some(input.into());
            self
        }
        /// <p>The name of the resource group.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_group_name = input;
            self
        }
        /// <p>The name of the component.</p>
        pub fn component_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_name = Some(input.into());
            self
        }
        /// <p>The name of the component.</p>
        pub fn set_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeComponentInput`](crate::input::DescribeComponentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeComponentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeComponentInput {
                resource_group_name: self.resource_group_name,
                component_name: self.component_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeComponentInputOperationOutputAlias = crate::operation::DescribeComponent;
#[doc(hidden)]
pub type DescribeComponentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeComponentInput {
    /// Consumes the builder and constructs an Operation<[`DescribeComponent`](crate::operation::DescribeComponent)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeComponent,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeComponentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeComponentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeComponentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "EC2WindowsBarleyService.DescribeComponent",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_component(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeComponent::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeComponent",
            "applicationinsights",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeComponentInput`](crate::input::DescribeComponentInput)
    pub fn builder() -> crate::input::describe_component_input::Builder {
        crate::input::describe_component_input::Builder::default()
    }
}

/// See [`DescribeComponentConfigurationInput`](crate::input::DescribeComponentConfigurationInput)
pub mod describe_component_configuration_input {
    /// A builder for [`DescribeComponentConfigurationInput`](crate::input::DescribeComponentConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_group_name: std::option::Option<std::string::String>,
        pub(crate) component_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the resource group.</p>
        pub fn resource_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_group_name = Some(input.into());
            self
        }
        /// <p>The name of the resource group.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_group_name = input;
            self
        }
        /// <p>The name of the component.</p>
        pub fn component_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_name = Some(input.into());
            self
        }
        /// <p>The name of the component.</p>
        pub fn set_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeComponentConfigurationInput`](crate::input::DescribeComponentConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeComponentConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeComponentConfigurationInput {
                resource_group_name: self.resource_group_name,
                component_name: self.component_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeComponentConfigurationInputOperationOutputAlias =
    crate::operation::DescribeComponentConfiguration;
#[doc(hidden)]
pub type DescribeComponentConfigurationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeComponentConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`DescribeComponentConfiguration`](crate::operation::DescribeComponentConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeComponentConfiguration,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeComponentConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeComponentConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeComponentConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "EC2WindowsBarleyService.DescribeComponentConfiguration",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_component_configuration(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeComponentConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeComponentConfiguration",
            "applicationinsights",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeComponentConfigurationInput`](crate::input::DescribeComponentConfigurationInput)
    pub fn builder() -> crate::input::describe_component_configuration_input::Builder {
        crate::input::describe_component_configuration_input::Builder::default()
    }
}

/// See [`DescribeComponentConfigurationRecommendationInput`](crate::input::DescribeComponentConfigurationRecommendationInput)
pub mod describe_component_configuration_recommendation_input {
    /// A builder for [`DescribeComponentConfigurationRecommendationInput`](crate::input::DescribeComponentConfigurationRecommendationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_group_name: std::option::Option<std::string::String>,
        pub(crate) component_name: std::option::Option<std::string::String>,
        pub(crate) tier: std::option::Option<crate::model::Tier>,
    }
    impl Builder {
        /// <p>The name of the resource group.</p>
        pub fn resource_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_group_name = Some(input.into());
            self
        }
        /// <p>The name of the resource group.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_group_name = input;
            self
        }
        /// <p>The name of the component.</p>
        pub fn component_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_name = Some(input.into());
            self
        }
        /// <p>The name of the component.</p>
        pub fn set_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_name = input;
            self
        }
        /// <p>The tier of the application component. Supported tiers include
        /// <code>DOT_NET_CORE</code>, <code>DOT_NET_WORKER</code>, <code>DOT_NET_WEB</code>, <code>SQL_SERVER</code>,
        /// and <code>DEFAULT</code>.</p>
        pub fn tier(mut self, input: crate::model::Tier) -> Self {
            self.tier = Some(input);
            self
        }
        /// <p>The tier of the application component. Supported tiers include
        /// <code>DOT_NET_CORE</code>, <code>DOT_NET_WORKER</code>, <code>DOT_NET_WEB</code>, <code>SQL_SERVER</code>,
        /// and <code>DEFAULT</code>.</p>
        pub fn set_tier(mut self, input: std::option::Option<crate::model::Tier>) -> Self {
            self.tier = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeComponentConfigurationRecommendationInput`](crate::input::DescribeComponentConfigurationRecommendationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeComponentConfigurationRecommendationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::DescribeComponentConfigurationRecommendationInput {
                    resource_group_name: self.resource_group_name,
                    component_name: self.component_name,
                    tier: self.tier,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type DescribeComponentConfigurationRecommendationInputOperationOutputAlias =
    crate::operation::DescribeComponentConfigurationRecommendation;
#[doc(hidden)]
pub type DescribeComponentConfigurationRecommendationInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl DescribeComponentConfigurationRecommendationInput {
    /// Consumes the builder and constructs an Operation<[`DescribeComponentConfigurationRecommendation`](crate::operation::DescribeComponentConfigurationRecommendation)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeComponentConfigurationRecommendation,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeComponentConfigurationRecommendationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeComponentConfigurationRecommendationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeComponentConfigurationRecommendationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "EC2WindowsBarleyService.DescribeComponentConfigurationRecommendation",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_component_configuration_recommendation(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeComponentConfigurationRecommendation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeComponentConfigurationRecommendation",
            "applicationinsights",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeComponentConfigurationRecommendationInput`](crate::input::DescribeComponentConfigurationRecommendationInput)
    pub fn builder() -> crate::input::describe_component_configuration_recommendation_input::Builder
    {
        crate::input::describe_component_configuration_recommendation_input::Builder::default()
    }
}

/// See [`DescribeLogPatternInput`](crate::input::DescribeLogPatternInput)
pub mod describe_log_pattern_input {
    /// A builder for [`DescribeLogPatternInput`](crate::input::DescribeLogPatternInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_group_name: std::option::Option<std::string::String>,
        pub(crate) pattern_set_name: std::option::Option<std::string::String>,
        pub(crate) pattern_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the resource group.</p>
        pub fn resource_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_group_name = Some(input.into());
            self
        }
        /// <p>The name of the resource group.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_group_name = input;
            self
        }
        /// <p>The name of the log pattern set.</p>
        pub fn pattern_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.pattern_set_name = Some(input.into());
            self
        }
        /// <p>The name of the log pattern set.</p>
        pub fn set_pattern_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pattern_set_name = input;
            self
        }
        /// <p>The name of the log pattern.</p>
        pub fn pattern_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.pattern_name = Some(input.into());
            self
        }
        /// <p>The name of the log pattern.</p>
        pub fn set_pattern_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pattern_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeLogPatternInput`](crate::input::DescribeLogPatternInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeLogPatternInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeLogPatternInput {
                resource_group_name: self.resource_group_name,
                pattern_set_name: self.pattern_set_name,
                pattern_name: self.pattern_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeLogPatternInputOperationOutputAlias = crate::operation::DescribeLogPattern;
#[doc(hidden)]
pub type DescribeLogPatternInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeLogPatternInput {
    /// Consumes the builder and constructs an Operation<[`DescribeLogPattern`](crate::operation::DescribeLogPattern)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeLogPattern,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeLogPatternInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeLogPatternInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeLogPatternInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "EC2WindowsBarleyService.DescribeLogPattern",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_log_pattern(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeLogPattern::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeLogPattern",
            "applicationinsights",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeLogPatternInput`](crate::input::DescribeLogPatternInput)
    pub fn builder() -> crate::input::describe_log_pattern_input::Builder {
        crate::input::describe_log_pattern_input::Builder::default()
    }
}

/// See [`DescribeObservationInput`](crate::input::DescribeObservationInput)
pub mod describe_observation_input {
    /// A builder for [`DescribeObservationInput`](crate::input::DescribeObservationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) observation_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the observation.</p>
        pub fn observation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.observation_id = Some(input.into());
            self
        }
        /// <p>The ID of the observation.</p>
        pub fn set_observation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.observation_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeObservationInput`](crate::input::DescribeObservationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeObservationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeObservationInput {
                observation_id: self.observation_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeObservationInputOperationOutputAlias = crate::operation::DescribeObservation;
#[doc(hidden)]
pub type DescribeObservationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeObservationInput {
    /// Consumes the builder and constructs an Operation<[`DescribeObservation`](crate::operation::DescribeObservation)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeObservation,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeObservationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeObservationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeObservationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "EC2WindowsBarleyService.DescribeObservation",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_observation(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeObservation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeObservation",
            "applicationinsights",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeObservationInput`](crate::input::DescribeObservationInput)
    pub fn builder() -> crate::input::describe_observation_input::Builder {
        crate::input::describe_observation_input::Builder::default()
    }
}

/// See [`DescribeProblemInput`](crate::input::DescribeProblemInput)
pub mod describe_problem_input {
    /// A builder for [`DescribeProblemInput`](crate::input::DescribeProblemInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) problem_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the problem.</p>
        pub fn problem_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.problem_id = Some(input.into());
            self
        }
        /// <p>The ID of the problem.</p>
        pub fn set_problem_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.problem_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeProblemInput`](crate::input::DescribeProblemInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeProblemInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeProblemInput {
                problem_id: self.problem_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeProblemInputOperationOutputAlias = crate::operation::DescribeProblem;
#[doc(hidden)]
pub type DescribeProblemInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeProblemInput {
    /// Consumes the builder and constructs an Operation<[`DescribeProblem`](crate::operation::DescribeProblem)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeProblem,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeProblemInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeProblemInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeProblemInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "EC2WindowsBarleyService.DescribeProblem",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_problem(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeProblem::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeProblem",
            "applicationinsights",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeProblemInput`](crate::input::DescribeProblemInput)
    pub fn builder() -> crate::input::describe_problem_input::Builder {
        crate::input::describe_problem_input::Builder::default()
    }
}

/// See [`DescribeProblemObservationsInput`](crate::input::DescribeProblemObservationsInput)
pub mod describe_problem_observations_input {
    /// A builder for [`DescribeProblemObservationsInput`](crate::input::DescribeProblemObservationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) problem_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the problem.</p>
        pub fn problem_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.problem_id = Some(input.into());
            self
        }
        /// <p>The ID of the problem.</p>
        pub fn set_problem_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.problem_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeProblemObservationsInput`](crate::input::DescribeProblemObservationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeProblemObservationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeProblemObservationsInput {
                problem_id: self.problem_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeProblemObservationsInputOperationOutputAlias =
    crate::operation::DescribeProblemObservations;
#[doc(hidden)]
pub type DescribeProblemObservationsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeProblemObservationsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeProblemObservations`](crate::operation::DescribeProblemObservations)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeProblemObservations,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeProblemObservationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeProblemObservationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeProblemObservationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "EC2WindowsBarleyService.DescribeProblemObservations",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_problem_observations(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeProblemObservations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeProblemObservations",
            "applicationinsights",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeProblemObservationsInput`](crate::input::DescribeProblemObservationsInput)
    pub fn builder() -> crate::input::describe_problem_observations_input::Builder {
        crate::input::describe_problem_observations_input::Builder::default()
    }
}

/// See [`ListApplicationsInput`](crate::input::ListApplicationsInput)
pub mod list_applications_input {
    /// A builder for [`ListApplicationsInput`](crate::input::ListApplicationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of results to return in a single call. To retrieve the remaining
        /// results, make another call with the returned <code>NextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in a single call. To retrieve the remaining
        /// results, make another call with the returned <code>NextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListApplicationsInput`](crate::input::ListApplicationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListApplicationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListApplicationsInput {
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListApplicationsInputOperationOutputAlias = crate::operation::ListApplications;
#[doc(hidden)]
pub type ListApplicationsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListApplicationsInput {
    /// Consumes the builder and constructs an Operation<[`ListApplications`](crate::operation::ListApplications)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListApplications,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListApplicationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListApplicationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListApplicationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "EC2WindowsBarleyService.ListApplications",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_applications(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListApplications::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListApplications",
            "applicationinsights",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListApplicationsInput`](crate::input::ListApplicationsInput)
    pub fn builder() -> crate::input::list_applications_input::Builder {
        crate::input::list_applications_input::Builder::default()
    }
}

/// See [`ListComponentsInput`](crate::input::ListComponentsInput)
pub mod list_components_input {
    /// A builder for [`ListComponentsInput`](crate::input::ListComponentsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_group_name: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the resource group.</p>
        pub fn resource_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_group_name = Some(input.into());
            self
        }
        /// <p>The name of the resource group.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_group_name = input;
            self
        }
        /// <p>The maximum number of results to return in a single call. To retrieve the remaining
        /// results, make another call with the returned <code>NextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in a single call. To retrieve the remaining
        /// results, make another call with the returned <code>NextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListComponentsInput`](crate::input::ListComponentsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListComponentsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListComponentsInput {
                resource_group_name: self.resource_group_name,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListComponentsInputOperationOutputAlias = crate::operation::ListComponents;
#[doc(hidden)]
pub type ListComponentsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListComponentsInput {
    /// Consumes the builder and constructs an Operation<[`ListComponents`](crate::operation::ListComponents)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListComponents,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListComponentsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListComponentsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListComponentsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "EC2WindowsBarleyService.ListComponents",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_components(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListComponents::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListComponents",
            "applicationinsights",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListComponentsInput`](crate::input::ListComponentsInput)
    pub fn builder() -> crate::input::list_components_input::Builder {
        crate::input::list_components_input::Builder::default()
    }
}

/// See [`ListConfigurationHistoryInput`](crate::input::ListConfigurationHistoryInput)
pub mod list_configuration_history_input {
    /// A builder for [`ListConfigurationHistoryInput`](crate::input::ListConfigurationHistoryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_group_name: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) event_status: std::option::Option<crate::model::ConfigurationEventStatus>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Resource group to which the application belongs. </p>
        pub fn resource_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_group_name = Some(input.into());
            self
        }
        /// <p>Resource group to which the application belongs. </p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_group_name = input;
            self
        }
        /// <p>The start time of the event. </p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The start time of the event. </p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The end time of the event.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The end time of the event.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The status of the configuration update event. Possible values include INFO, WARN, and ERROR.</p>
        pub fn event_status(mut self, input: crate::model::ConfigurationEventStatus) -> Self {
            self.event_status = Some(input);
            self
        }
        /// <p>The status of the configuration update event. Possible values include INFO, WARN, and ERROR.</p>
        pub fn set_event_status(
            mut self,
            input: std::option::Option<crate::model::ConfigurationEventStatus>,
        ) -> Self {
            self.event_status = input;
            self
        }
        /// <p> The maximum number of results returned by <code>ListConfigurationHistory</code> in
        /// paginated output. When this parameter is used, <code>ListConfigurationHistory</code>
        /// returns only <code>MaxResults</code> in a single page along with a <code>NextToken</code>
        /// response element. The remaining results of the initial request can be seen by sending
        /// another <code>ListConfigurationHistory</code> request with the returned
        /// <code>NextToken</code> value. If this parameter is not used, then
        /// <code>ListConfigurationHistory</code> returns all results. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p> The maximum number of results returned by <code>ListConfigurationHistory</code> in
        /// paginated output. When this parameter is used, <code>ListConfigurationHistory</code>
        /// returns only <code>MaxResults</code> in a single page along with a <code>NextToken</code>
        /// response element. The remaining results of the initial request can be seen by sending
        /// another <code>ListConfigurationHistory</code> request with the returned
        /// <code>NextToken</code> value. If this parameter is not used, then
        /// <code>ListConfigurationHistory</code> returns all results. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The <code>NextToken</code> value returned from a previous paginated <code>ListConfigurationHistory</code> request where
        /// <code>MaxResults</code> was used and the results exceeded the value of that parameter. Pagination
        /// continues from the end of the previous results that returned the <code>NextToken</code> value. This
        /// value is <code>null</code> when there are no more results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>NextToken</code> value returned from a previous paginated <code>ListConfigurationHistory</code> request where
        /// <code>MaxResults</code> was used and the results exceeded the value of that parameter. Pagination
        /// continues from the end of the previous results that returned the <code>NextToken</code> value. This
        /// value is <code>null</code> when there are no more results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListConfigurationHistoryInput`](crate::input::ListConfigurationHistoryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListConfigurationHistoryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListConfigurationHistoryInput {
                resource_group_name: self.resource_group_name,
                start_time: self.start_time,
                end_time: self.end_time,
                event_status: self.event_status,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListConfigurationHistoryInputOperationOutputAlias =
    crate::operation::ListConfigurationHistory;
#[doc(hidden)]
pub type ListConfigurationHistoryInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListConfigurationHistoryInput {
    /// Consumes the builder and constructs an Operation<[`ListConfigurationHistory`](crate::operation::ListConfigurationHistory)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListConfigurationHistory,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListConfigurationHistoryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListConfigurationHistoryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListConfigurationHistoryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "EC2WindowsBarleyService.ListConfigurationHistory",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_configuration_history(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListConfigurationHistory::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListConfigurationHistory",
            "applicationinsights",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListConfigurationHistoryInput`](crate::input::ListConfigurationHistoryInput)
    pub fn builder() -> crate::input::list_configuration_history_input::Builder {
        crate::input::list_configuration_history_input::Builder::default()
    }
}

/// See [`ListLogPatternsInput`](crate::input::ListLogPatternsInput)
pub mod list_log_patterns_input {
    /// A builder for [`ListLogPatternsInput`](crate::input::ListLogPatternsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_group_name: std::option::Option<std::string::String>,
        pub(crate) pattern_set_name: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the resource group.</p>
        pub fn resource_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_group_name = Some(input.into());
            self
        }
        /// <p>The name of the resource group.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_group_name = input;
            self
        }
        /// <p>The name of the log pattern set.</p>
        pub fn pattern_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.pattern_set_name = Some(input.into());
            self
        }
        /// <p>The name of the log pattern set.</p>
        pub fn set_pattern_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pattern_set_name = input;
            self
        }
        /// <p>The maximum number of results to return in a single call. To retrieve the remaining
        /// results, make another call with the returned <code>NextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in a single call. To retrieve the remaining
        /// results, make another call with the returned <code>NextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListLogPatternsInput`](crate::input::ListLogPatternsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListLogPatternsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListLogPatternsInput {
                resource_group_name: self.resource_group_name,
                pattern_set_name: self.pattern_set_name,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListLogPatternsInputOperationOutputAlias = crate::operation::ListLogPatterns;
#[doc(hidden)]
pub type ListLogPatternsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListLogPatternsInput {
    /// Consumes the builder and constructs an Operation<[`ListLogPatterns`](crate::operation::ListLogPatterns)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListLogPatterns,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListLogPatternsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListLogPatternsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListLogPatternsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "EC2WindowsBarleyService.ListLogPatterns",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_log_patterns(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListLogPatterns::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListLogPatterns",
            "applicationinsights",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListLogPatternsInput`](crate::input::ListLogPatternsInput)
    pub fn builder() -> crate::input::list_log_patterns_input::Builder {
        crate::input::list_log_patterns_input::Builder::default()
    }
}

/// See [`ListLogPatternSetsInput`](crate::input::ListLogPatternSetsInput)
pub mod list_log_pattern_sets_input {
    /// A builder for [`ListLogPatternSetsInput`](crate::input::ListLogPatternSetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_group_name: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the resource group.</p>
        pub fn resource_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_group_name = Some(input.into());
            self
        }
        /// <p>The name of the resource group.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_group_name = input;
            self
        }
        /// <p>The maximum number of results to return in a single call. To retrieve the remaining
        /// results, make another call with the returned <code>NextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in a single call. To retrieve the remaining
        /// results, make another call with the returned <code>NextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListLogPatternSetsInput`](crate::input::ListLogPatternSetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListLogPatternSetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListLogPatternSetsInput {
                resource_group_name: self.resource_group_name,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListLogPatternSetsInputOperationOutputAlias = crate::operation::ListLogPatternSets;
#[doc(hidden)]
pub type ListLogPatternSetsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListLogPatternSetsInput {
    /// Consumes the builder and constructs an Operation<[`ListLogPatternSets`](crate::operation::ListLogPatternSets)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListLogPatternSets,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListLogPatternSetsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListLogPatternSetsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListLogPatternSetsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "EC2WindowsBarleyService.ListLogPatternSets",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_log_pattern_sets(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListLogPatternSets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListLogPatternSets",
            "applicationinsights",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListLogPatternSetsInput`](crate::input::ListLogPatternSetsInput)
    pub fn builder() -> crate::input::list_log_pattern_sets_input::Builder {
        crate::input::list_log_pattern_sets_input::Builder::default()
    }
}

/// See [`ListProblemsInput`](crate::input::ListProblemsInput)
pub mod list_problems_input {
    /// A builder for [`ListProblemsInput`](crate::input::ListProblemsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_group_name: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) component_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the resource group.</p>
        pub fn resource_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_group_name = Some(input.into());
            self
        }
        /// <p>The name of the resource group.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_group_name = input;
            self
        }
        /// <p>The time when the problem was detected, in epoch
        /// seconds. If you don't specify a time frame for the request, problems within the past seven days are returned.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The time when the problem was detected, in epoch
        /// seconds. If you don't specify a time frame for the request, problems within the past seven days are returned.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The time when the problem ended, in epoch seconds. If not specified, problems within the
        /// past seven days are returned.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The time when the problem ended, in epoch seconds. If not specified, problems within the
        /// past seven days are returned.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The maximum number of results to return in a single call. To retrieve the remaining
        /// results, make another call with the returned <code>NextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in a single call. To retrieve the remaining
        /// results, make another call with the returned <code>NextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn component_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_name = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ListProblemsInput`](crate::input::ListProblemsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListProblemsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListProblemsInput {
                resource_group_name: self.resource_group_name,
                start_time: self.start_time,
                end_time: self.end_time,
                max_results: self.max_results,
                next_token: self.next_token,
                component_name: self.component_name,
            })
        }
    }
}
#[doc(hidden)]
pub type ListProblemsInputOperationOutputAlias = crate::operation::ListProblems;
#[doc(hidden)]
pub type ListProblemsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListProblemsInput {
    /// Consumes the builder and constructs an Operation<[`ListProblems`](crate::operation::ListProblems)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListProblems,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListProblemsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListProblemsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListProblemsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "EC2WindowsBarleyService.ListProblems",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_problems(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListProblems::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListProblems",
            "applicationinsights",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListProblemsInput`](crate::input::ListProblemsInput)
    pub fn builder() -> crate::input::list_problems_input::Builder {
        crate::input::list_problems_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the application that you want to retrieve tag
        /// information for.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application that you want to retrieve tag
        /// information for.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "EC2WindowsBarleyService.ListTagsForResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_tags_for_resource(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "applicationinsights",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the application that you want to add one or more tags to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application that you want to add one or more tags to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags that to add to the application. A tag consists of a required
        /// tag key (<code>Key</code>) and an associated tag value (<code>Value</code>). The maximum
        /// length of a tag key is 128 characters. The maximum length of a tag value is 256
        /// characters.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags that to add to the application. A tag consists of a required
        /// tag key (<code>Key</code>) and an associated tag value (<code>Value</code>). The maximum
        /// length of a tag key is 128 characters. The maximum length of a tag value is 256
        /// characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "EC2WindowsBarleyService.TagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "applicationinsights",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the application that you want to remove one or more tags from.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application that you want to remove one or more tags from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tags (tag keys) that you want to remove from the resource. When you specify a tag
        /// key, the action removes both that key and its associated tag value.</p>
        /// <p>To remove more than one tag from the application, append the <code>TagKeys</code>
        /// parameter and argument for each additional tag to remove, separated by an ampersand.
        /// </p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The tags (tag keys) that you want to remove from the resource. When you specify a tag
        /// key, the action removes both that key and its associated tag value.</p>
        /// <p>To remove more than one tag from the application, append the <code>TagKeys</code>
        /// parameter and argument for each additional tag to remove, separated by an ampersand.
        /// </p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "EC2WindowsBarleyService.UntagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_untag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "applicationinsights",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateApplicationInput`](crate::input::UpdateApplicationInput)
pub mod update_application_input {
    /// A builder for [`UpdateApplicationInput`](crate::input::UpdateApplicationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_group_name: std::option::Option<std::string::String>,
        pub(crate) ops_center_enabled: std::option::Option<bool>,
        pub(crate) cwe_monitor_enabled: std::option::Option<bool>,
        pub(crate) ops_item_sns_topic_arn: std::option::Option<std::string::String>,
        pub(crate) remove_sns_topic: std::option::Option<bool>,
        pub(crate) auto_config_enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the resource group.</p>
        pub fn resource_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_group_name = Some(input.into());
            self
        }
        /// <p>The name of the resource group.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_group_name = input;
            self
        }
        /// <p>
        /// When set to <code>true</code>, creates opsItems for any problems detected on an application.
        /// </p>
        pub fn ops_center_enabled(mut self, input: bool) -> Self {
            self.ops_center_enabled = Some(input);
            self
        }
        /// <p>
        /// When set to <code>true</code>, creates opsItems for any problems detected on an application.
        /// </p>
        pub fn set_ops_center_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.ops_center_enabled = input;
            self
        }
        /// <p>
        /// Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as <code>instance terminated</code>, <code>failed deployment</code>, and others.
        /// </p>
        pub fn cwe_monitor_enabled(mut self, input: bool) -> Self {
            self.cwe_monitor_enabled = Some(input);
            self
        }
        /// <p>
        /// Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as <code>instance terminated</code>, <code>failed deployment</code>, and others.
        /// </p>
        pub fn set_cwe_monitor_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.cwe_monitor_enabled = input;
            self
        }
        /// <p>
        /// The SNS topic provided to Application Insights that is associated to the created opsItem. Allows you to
        /// receive notifications for updates to the opsItem.</p>
        pub fn ops_item_sns_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.ops_item_sns_topic_arn = Some(input.into());
            self
        }
        /// <p>
        /// The SNS topic provided to Application Insights that is associated to the created opsItem. Allows you to
        /// receive notifications for updates to the opsItem.</p>
        pub fn set_ops_item_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ops_item_sns_topic_arn = input;
            self
        }
        /// <p>
        /// Disassociates the SNS topic from the opsItem created for detected problems.</p>
        pub fn remove_sns_topic(mut self, input: bool) -> Self {
            self.remove_sns_topic = Some(input);
            self
        }
        /// <p>
        /// Disassociates the SNS topic from the opsItem created for detected problems.</p>
        pub fn set_remove_sns_topic(mut self, input: std::option::Option<bool>) -> Self {
            self.remove_sns_topic = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn auto_config_enabled(mut self, input: bool) -> Self {
            self.auto_config_enabled = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_auto_config_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_config_enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateApplicationInput`](crate::input::UpdateApplicationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateApplicationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateApplicationInput {
                resource_group_name: self.resource_group_name,
                ops_center_enabled: self.ops_center_enabled,
                cwe_monitor_enabled: self.cwe_monitor_enabled,
                ops_item_sns_topic_arn: self.ops_item_sns_topic_arn,
                remove_sns_topic: self.remove_sns_topic,
                auto_config_enabled: self.auto_config_enabled,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateApplicationInputOperationOutputAlias = crate::operation::UpdateApplication;
#[doc(hidden)]
pub type UpdateApplicationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateApplicationInput {
    /// Consumes the builder and constructs an Operation<[`UpdateApplication`](crate::operation::UpdateApplication)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateApplication,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateApplicationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateApplicationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateApplicationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "EC2WindowsBarleyService.UpdateApplication",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_application(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateApplication::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateApplication",
            "applicationinsights",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateApplicationInput`](crate::input::UpdateApplicationInput)
    pub fn builder() -> crate::input::update_application_input::Builder {
        crate::input::update_application_input::Builder::default()
    }
}

/// See [`UpdateComponentInput`](crate::input::UpdateComponentInput)
pub mod update_component_input {
    /// A builder for [`UpdateComponentInput`](crate::input::UpdateComponentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_group_name: std::option::Option<std::string::String>,
        pub(crate) component_name: std::option::Option<std::string::String>,
        pub(crate) new_component_name: std::option::Option<std::string::String>,
        pub(crate) resource_list: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the resource group.</p>
        pub fn resource_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_group_name = Some(input.into());
            self
        }
        /// <p>The name of the resource group.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_group_name = input;
            self
        }
        /// <p>The name of the component.</p>
        pub fn component_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_name = Some(input.into());
            self
        }
        /// <p>The name of the component.</p>
        pub fn set_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_name = input;
            self
        }
        /// <p>The new name of the component.</p>
        pub fn new_component_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.new_component_name = Some(input.into());
            self
        }
        /// <p>The new name of the component.</p>
        pub fn set_new_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.new_component_name = input;
            self
        }
        /// Appends an item to `resource_list`.
        ///
        /// To override the contents of this collection use [`set_resource_list`](Self::set_resource_list).
        ///
        /// <p>The list of resource ARNs that belong to the component.</p>
        pub fn resource_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resource_list.unwrap_or_default();
            v.push(input.into());
            self.resource_list = Some(v);
            self
        }
        /// <p>The list of resource ARNs that belong to the component.</p>
        pub fn set_resource_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resource_list = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateComponentInput`](crate::input::UpdateComponentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateComponentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateComponentInput {
                resource_group_name: self.resource_group_name,
                component_name: self.component_name,
                new_component_name: self.new_component_name,
                resource_list: self.resource_list,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateComponentInputOperationOutputAlias = crate::operation::UpdateComponent;
#[doc(hidden)]
pub type UpdateComponentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateComponentInput {
    /// Consumes the builder and constructs an Operation<[`UpdateComponent`](crate::operation::UpdateComponent)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateComponent,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateComponentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateComponentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateComponentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "EC2WindowsBarleyService.UpdateComponent",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_component(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateComponent::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateComponent",
            "applicationinsights",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateComponentInput`](crate::input::UpdateComponentInput)
    pub fn builder() -> crate::input::update_component_input::Builder {
        crate::input::update_component_input::Builder::default()
    }
}

/// See [`UpdateComponentConfigurationInput`](crate::input::UpdateComponentConfigurationInput)
pub mod update_component_configuration_input {
    /// A builder for [`UpdateComponentConfigurationInput`](crate::input::UpdateComponentConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_group_name: std::option::Option<std::string::String>,
        pub(crate) component_name: std::option::Option<std::string::String>,
        pub(crate) monitor: std::option::Option<bool>,
        pub(crate) tier: std::option::Option<crate::model::Tier>,
        pub(crate) component_configuration: std::option::Option<std::string::String>,
        pub(crate) auto_config_enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the resource group.</p>
        pub fn resource_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_group_name = Some(input.into());
            self
        }
        /// <p>The name of the resource group.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_group_name = input;
            self
        }
        /// <p>The name of the component.</p>
        pub fn component_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_name = Some(input.into());
            self
        }
        /// <p>The name of the component.</p>
        pub fn set_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_name = input;
            self
        }
        /// <p>Indicates whether the application component is monitored.</p>
        pub fn monitor(mut self, input: bool) -> Self {
            self.monitor = Some(input);
            self
        }
        /// <p>Indicates whether the application component is monitored.</p>
        pub fn set_monitor(mut self, input: std::option::Option<bool>) -> Self {
            self.monitor = input;
            self
        }
        /// <p>The tier of the application component. Supported tiers include <code>DOT_NET_WORKER</code>,
        /// <code>DOT_NET_WEB</code>, <code>DOT_NET_CORE</code>, <code>SQL_SERVER</code>, and <code>DEFAULT</code>.</p>
        pub fn tier(mut self, input: crate::model::Tier) -> Self {
            self.tier = Some(input);
            self
        }
        /// <p>The tier of the application component. Supported tiers include <code>DOT_NET_WORKER</code>,
        /// <code>DOT_NET_WEB</code>, <code>DOT_NET_CORE</code>, <code>SQL_SERVER</code>, and <code>DEFAULT</code>.</p>
        pub fn set_tier(mut self, input: std::option::Option<crate::model::Tier>) -> Self {
            self.tier = input;
            self
        }
        /// <p>The configuration settings of the component. The value is the escaped JSON of the configuration. For
        /// more information about the JSON format, see <a href="https://docs.aws.amazon.com/sdk-for-javascript/v2/developer-guide/working-with-json.html">Working with JSON</a>.
        /// You can send a request to <code>DescribeComponentConfigurationRecommendation</code> to see the recommended configuration for a component. For the complete
        /// format of the component configuration file, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/component-config.html">Component Configuration</a>.</p>
        pub fn component_configuration(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_configuration = Some(input.into());
            self
        }
        /// <p>The configuration settings of the component. The value is the escaped JSON of the configuration. For
        /// more information about the JSON format, see <a href="https://docs.aws.amazon.com/sdk-for-javascript/v2/developer-guide/working-with-json.html">Working with JSON</a>.
        /// You can send a request to <code>DescribeComponentConfigurationRecommendation</code> to see the recommended configuration for a component. For the complete
        /// format of the component configuration file, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/component-config.html">Component Configuration</a>.</p>
        pub fn set_component_configuration(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_configuration = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn auto_config_enabled(mut self, input: bool) -> Self {
            self.auto_config_enabled = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_auto_config_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_config_enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateComponentConfigurationInput`](crate::input::UpdateComponentConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateComponentConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateComponentConfigurationInput {
                resource_group_name: self.resource_group_name,
                component_name: self.component_name,
                monitor: self.monitor,
                tier: self.tier,
                component_configuration: self.component_configuration,
                auto_config_enabled: self.auto_config_enabled,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateComponentConfigurationInputOperationOutputAlias =
    crate::operation::UpdateComponentConfiguration;
#[doc(hidden)]
pub type UpdateComponentConfigurationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateComponentConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`UpdateComponentConfiguration`](crate::operation::UpdateComponentConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateComponentConfiguration,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateComponentConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateComponentConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateComponentConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "EC2WindowsBarleyService.UpdateComponentConfiguration",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_component_configuration(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateComponentConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateComponentConfiguration",
            "applicationinsights",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateComponentConfigurationInput`](crate::input::UpdateComponentConfigurationInput)
    pub fn builder() -> crate::input::update_component_configuration_input::Builder {
        crate::input::update_component_configuration_input::Builder::default()
    }
}

/// See [`UpdateLogPatternInput`](crate::input::UpdateLogPatternInput)
pub mod update_log_pattern_input {
    /// A builder for [`UpdateLogPatternInput`](crate::input::UpdateLogPatternInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_group_name: std::option::Option<std::string::String>,
        pub(crate) pattern_set_name: std::option::Option<std::string::String>,
        pub(crate) pattern_name: std::option::Option<std::string::String>,
        pub(crate) pattern: std::option::Option<std::string::String>,
        pub(crate) rank: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the resource group.</p>
        pub fn resource_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_group_name = Some(input.into());
            self
        }
        /// <p>The name of the resource group.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_group_name = input;
            self
        }
        /// <p>The name of the log pattern set.</p>
        pub fn pattern_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.pattern_set_name = Some(input.into());
            self
        }
        /// <p>The name of the log pattern set.</p>
        pub fn set_pattern_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pattern_set_name = input;
            self
        }
        /// <p>The name of the log pattern.</p>
        pub fn pattern_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.pattern_name = Some(input.into());
            self
        }
        /// <p>The name of the log pattern.</p>
        pub fn set_pattern_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pattern_name = input;
            self
        }
        /// <p>The log pattern. The pattern must be DFA compatible. Patterns that utilize forward lookahead or backreference constructions are not supported.</p>
        pub fn pattern(mut self, input: impl Into<std::string::String>) -> Self {
            self.pattern = Some(input.into());
            self
        }
        /// <p>The log pattern. The pattern must be DFA compatible. Patterns that utilize forward lookahead or backreference constructions are not supported.</p>
        pub fn set_pattern(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pattern = input;
            self
        }
        /// <p>Rank of the log pattern. Must be a value between <code>1</code> and <code>1,000,000</code>. The patterns are sorted by rank, so we recommend that you set your highest priority patterns with the lowest rank. A pattern of rank <code>1</code> will be the first to get matched to a log line. A pattern of rank <code>1,000,000</code> will be last to get matched. When you configure custom log patterns from the console, a <code>Low</code> severity pattern translates to a <code>750,000</code> rank. A <code>Medium</code> severity pattern translates to a <code>500,000</code> rank. And a <code>High</code> severity pattern translates to a <code>250,000</code> rank.
        /// Rank values less than <code>1</code> or greater than <code>1,000,000</code> are reserved for AWS-provided patterns.
        /// </p>
        pub fn rank(mut self, input: i32) -> Self {
            self.rank = Some(input);
            self
        }
        /// <p>Rank of the log pattern. Must be a value between <code>1</code> and <code>1,000,000</code>. The patterns are sorted by rank, so we recommend that you set your highest priority patterns with the lowest rank. A pattern of rank <code>1</code> will be the first to get matched to a log line. A pattern of rank <code>1,000,000</code> will be last to get matched. When you configure custom log patterns from the console, a <code>Low</code> severity pattern translates to a <code>750,000</code> rank. A <code>Medium</code> severity pattern translates to a <code>500,000</code> rank. And a <code>High</code> severity pattern translates to a <code>250,000</code> rank.
        /// Rank values less than <code>1</code> or greater than <code>1,000,000</code> are reserved for AWS-provided patterns.
        /// </p>
        pub fn set_rank(mut self, input: std::option::Option<i32>) -> Self {
            self.rank = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateLogPatternInput`](crate::input::UpdateLogPatternInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateLogPatternInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateLogPatternInput {
                resource_group_name: self.resource_group_name,
                pattern_set_name: self.pattern_set_name,
                pattern_name: self.pattern_name,
                pattern: self.pattern,
                rank: self.rank.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateLogPatternInputOperationOutputAlias = crate::operation::UpdateLogPattern;
#[doc(hidden)]
pub type UpdateLogPatternInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateLogPatternInput {
    /// Consumes the builder and constructs an Operation<[`UpdateLogPattern`](crate::operation::UpdateLogPattern)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateLogPattern,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateLogPatternInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateLogPatternInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateLogPatternInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "EC2WindowsBarleyService.UpdateLogPattern",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_log_pattern(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateLogPattern::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateLogPattern",
            "applicationinsights",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateLogPatternInput`](crate::input::UpdateLogPatternInput)
    pub fn builder() -> crate::input::update_log_pattern_input::Builder {
        crate::input::update_log_pattern_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateLogPatternInput {
    /// <p>The name of the resource group.</p>
    pub resource_group_name: std::option::Option<std::string::String>,
    /// <p>The name of the log pattern set.</p>
    pub pattern_set_name: std::option::Option<std::string::String>,
    /// <p>The name of the log pattern.</p>
    pub pattern_name: std::option::Option<std::string::String>,
    /// <p>The log pattern. The pattern must be DFA compatible. Patterns that utilize forward lookahead or backreference constructions are not supported.</p>
    pub pattern: std::option::Option<std::string::String>,
    /// <p>Rank of the log pattern. Must be a value between <code>1</code> and <code>1,000,000</code>. The patterns are sorted by rank, so we recommend that you set your highest priority patterns with the lowest rank. A pattern of rank <code>1</code> will be the first to get matched to a log line. A pattern of rank <code>1,000,000</code> will be last to get matched. When you configure custom log patterns from the console, a <code>Low</code> severity pattern translates to a <code>750,000</code> rank. A <code>Medium</code> severity pattern translates to a <code>500,000</code> rank. And a <code>High</code> severity pattern translates to a <code>250,000</code> rank.
    /// Rank values less than <code>1</code> or greater than <code>1,000,000</code> are reserved for AWS-provided patterns.
    /// </p>
    pub rank: i32,
}
impl UpdateLogPatternInput {
    /// <p>The name of the resource group.</p>
    pub fn resource_group_name(&self) -> std::option::Option<&str> {
        self.resource_group_name.as_deref()
    }
    /// <p>The name of the log pattern set.</p>
    pub fn pattern_set_name(&self) -> std::option::Option<&str> {
        self.pattern_set_name.as_deref()
    }
    /// <p>The name of the log pattern.</p>
    pub fn pattern_name(&self) -> std::option::Option<&str> {
        self.pattern_name.as_deref()
    }
    /// <p>The log pattern. The pattern must be DFA compatible. Patterns that utilize forward lookahead or backreference constructions are not supported.</p>
    pub fn pattern(&self) -> std::option::Option<&str> {
        self.pattern.as_deref()
    }
    /// <p>Rank of the log pattern. Must be a value between <code>1</code> and <code>1,000,000</code>. The patterns are sorted by rank, so we recommend that you set your highest priority patterns with the lowest rank. A pattern of rank <code>1</code> will be the first to get matched to a log line. A pattern of rank <code>1,000,000</code> will be last to get matched. When you configure custom log patterns from the console, a <code>Low</code> severity pattern translates to a <code>750,000</code> rank. A <code>Medium</code> severity pattern translates to a <code>500,000</code> rank. And a <code>High</code> severity pattern translates to a <code>250,000</code> rank.
    /// Rank values less than <code>1</code> or greater than <code>1,000,000</code> are reserved for AWS-provided patterns.
    /// </p>
    pub fn rank(&self) -> i32 {
        self.rank
    }
}
impl std::fmt::Debug for UpdateLogPatternInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateLogPatternInput");
        formatter.field("resource_group_name", &self.resource_group_name);
        formatter.field("pattern_set_name", &self.pattern_set_name);
        formatter.field("pattern_name", &self.pattern_name);
        formatter.field("pattern", &self.pattern);
        formatter.field("rank", &self.rank);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateComponentConfigurationInput {
    /// <p>The name of the resource group.</p>
    pub resource_group_name: std::option::Option<std::string::String>,
    /// <p>The name of the component.</p>
    pub component_name: std::option::Option<std::string::String>,
    /// <p>Indicates whether the application component is monitored.</p>
    pub monitor: std::option::Option<bool>,
    /// <p>The tier of the application component. Supported tiers include <code>DOT_NET_WORKER</code>,
    /// <code>DOT_NET_WEB</code>, <code>DOT_NET_CORE</code>, <code>SQL_SERVER</code>, and <code>DEFAULT</code>.</p>
    pub tier: std::option::Option<crate::model::Tier>,
    /// <p>The configuration settings of the component. The value is the escaped JSON of the configuration. For
    /// more information about the JSON format, see <a href="https://docs.aws.amazon.com/sdk-for-javascript/v2/developer-guide/working-with-json.html">Working with JSON</a>.
    /// You can send a request to <code>DescribeComponentConfigurationRecommendation</code> to see the recommended configuration for a component. For the complete
    /// format of the component configuration file, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/component-config.html">Component Configuration</a>.</p>
    pub component_configuration: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub auto_config_enabled: std::option::Option<bool>,
}
impl UpdateComponentConfigurationInput {
    /// <p>The name of the resource group.</p>
    pub fn resource_group_name(&self) -> std::option::Option<&str> {
        self.resource_group_name.as_deref()
    }
    /// <p>The name of the component.</p>
    pub fn component_name(&self) -> std::option::Option<&str> {
        self.component_name.as_deref()
    }
    /// <p>Indicates whether the application component is monitored.</p>
    pub fn monitor(&self) -> std::option::Option<bool> {
        self.monitor
    }
    /// <p>The tier of the application component. Supported tiers include <code>DOT_NET_WORKER</code>,
    /// <code>DOT_NET_WEB</code>, <code>DOT_NET_CORE</code>, <code>SQL_SERVER</code>, and <code>DEFAULT</code>.</p>
    pub fn tier(&self) -> std::option::Option<&crate::model::Tier> {
        self.tier.as_ref()
    }
    /// <p>The configuration settings of the component. The value is the escaped JSON of the configuration. For
    /// more information about the JSON format, see <a href="https://docs.aws.amazon.com/sdk-for-javascript/v2/developer-guide/working-with-json.html">Working with JSON</a>.
    /// You can send a request to <code>DescribeComponentConfigurationRecommendation</code> to see the recommended configuration for a component. For the complete
    /// format of the component configuration file, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/component-config.html">Component Configuration</a>.</p>
    pub fn component_configuration(&self) -> std::option::Option<&str> {
        self.component_configuration.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn auto_config_enabled(&self) -> std::option::Option<bool> {
        self.auto_config_enabled
    }
}
impl std::fmt::Debug for UpdateComponentConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateComponentConfigurationInput");
        formatter.field("resource_group_name", &self.resource_group_name);
        formatter.field("component_name", &self.component_name);
        formatter.field("monitor", &self.monitor);
        formatter.field("tier", &self.tier);
        formatter.field("component_configuration", &self.component_configuration);
        formatter.field("auto_config_enabled", &self.auto_config_enabled);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateComponentInput {
    /// <p>The name of the resource group.</p>
    pub resource_group_name: std::option::Option<std::string::String>,
    /// <p>The name of the component.</p>
    pub component_name: std::option::Option<std::string::String>,
    /// <p>The new name of the component.</p>
    pub new_component_name: std::option::Option<std::string::String>,
    /// <p>The list of resource ARNs that belong to the component.</p>
    pub resource_list: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UpdateComponentInput {
    /// <p>The name of the resource group.</p>
    pub fn resource_group_name(&self) -> std::option::Option<&str> {
        self.resource_group_name.as_deref()
    }
    /// <p>The name of the component.</p>
    pub fn component_name(&self) -> std::option::Option<&str> {
        self.component_name.as_deref()
    }
    /// <p>The new name of the component.</p>
    pub fn new_component_name(&self) -> std::option::Option<&str> {
        self.new_component_name.as_deref()
    }
    /// <p>The list of resource ARNs that belong to the component.</p>
    pub fn resource_list(&self) -> std::option::Option<&[std::string::String]> {
        self.resource_list.as_deref()
    }
}
impl std::fmt::Debug for UpdateComponentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateComponentInput");
        formatter.field("resource_group_name", &self.resource_group_name);
        formatter.field("component_name", &self.component_name);
        formatter.field("new_component_name", &self.new_component_name);
        formatter.field("resource_list", &self.resource_list);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateApplicationInput {
    /// <p>The name of the resource group.</p>
    pub resource_group_name: std::option::Option<std::string::String>,
    /// <p>
    /// When set to <code>true</code>, creates opsItems for any problems detected on an application.
    /// </p>
    pub ops_center_enabled: std::option::Option<bool>,
    /// <p>
    /// Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as <code>instance terminated</code>, <code>failed deployment</code>, and others.
    /// </p>
    pub cwe_monitor_enabled: std::option::Option<bool>,
    /// <p>
    /// The SNS topic provided to Application Insights that is associated to the created opsItem. Allows you to
    /// receive notifications for updates to the opsItem.</p>
    pub ops_item_sns_topic_arn: std::option::Option<std::string::String>,
    /// <p>
    /// Disassociates the SNS topic from the opsItem created for detected problems.</p>
    pub remove_sns_topic: std::option::Option<bool>,
    #[allow(missing_docs)] // documentation missing in model
    pub auto_config_enabled: std::option::Option<bool>,
}
impl UpdateApplicationInput {
    /// <p>The name of the resource group.</p>
    pub fn resource_group_name(&self) -> std::option::Option<&str> {
        self.resource_group_name.as_deref()
    }
    /// <p>
    /// When set to <code>true</code>, creates opsItems for any problems detected on an application.
    /// </p>
    pub fn ops_center_enabled(&self) -> std::option::Option<bool> {
        self.ops_center_enabled
    }
    /// <p>
    /// Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as <code>instance terminated</code>, <code>failed deployment</code>, and others.
    /// </p>
    pub fn cwe_monitor_enabled(&self) -> std::option::Option<bool> {
        self.cwe_monitor_enabled
    }
    /// <p>
    /// The SNS topic provided to Application Insights that is associated to the created opsItem. Allows you to
    /// receive notifications for updates to the opsItem.</p>
    pub fn ops_item_sns_topic_arn(&self) -> std::option::Option<&str> {
        self.ops_item_sns_topic_arn.as_deref()
    }
    /// <p>
    /// Disassociates the SNS topic from the opsItem created for detected problems.</p>
    pub fn remove_sns_topic(&self) -> std::option::Option<bool> {
        self.remove_sns_topic
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn auto_config_enabled(&self) -> std::option::Option<bool> {
        self.auto_config_enabled
    }
}
impl std::fmt::Debug for UpdateApplicationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateApplicationInput");
        formatter.field("resource_group_name", &self.resource_group_name);
        formatter.field("ops_center_enabled", &self.ops_center_enabled);
        formatter.field("cwe_monitor_enabled", &self.cwe_monitor_enabled);
        formatter.field("ops_item_sns_topic_arn", &self.ops_item_sns_topic_arn);
        formatter.field("remove_sns_topic", &self.remove_sns_topic);
        formatter.field("auto_config_enabled", &self.auto_config_enabled);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the application that you want to remove one or more tags from.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The tags (tag keys) that you want to remove from the resource. When you specify a tag
    /// key, the action removes both that key and its associated tag value.</p>
    /// <p>To remove more than one tag from the application, append the <code>TagKeys</code>
    /// parameter and argument for each additional tag to remove, separated by an ampersand.
    /// </p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the application that you want to remove one or more tags from.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The tags (tag keys) that you want to remove from the resource. When you specify a tag
    /// key, the action removes both that key and its associated tag value.</p>
    /// <p>To remove more than one tag from the application, append the <code>TagKeys</code>
    /// parameter and argument for each additional tag to remove, separated by an ampersand.
    /// </p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the application that you want to add one or more tags to.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A list of tags that to add to the application. A tag consists of a required
    /// tag key (<code>Key</code>) and an associated tag value (<code>Value</code>). The maximum
    /// length of a tag key is 128 characters. The maximum length of a tag value is 256
    /// characters.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the application that you want to add one or more tags to.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>A list of tags that to add to the application. A tag consists of a required
    /// tag key (<code>Key</code>) and an associated tag value (<code>Value</code>). The maximum
    /// length of a tag key is 128 characters. The maximum length of a tag value is 256
    /// characters.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the application that you want to retrieve tag
    /// information for.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the application that you want to retrieve tag
    /// information for.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListProblemsInput {
    /// <p>The name of the resource group.</p>
    pub resource_group_name: std::option::Option<std::string::String>,
    /// <p>The time when the problem was detected, in epoch
    /// seconds. If you don't specify a time frame for the request, problems within the past seven days are returned.</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time when the problem ended, in epoch seconds. If not specified, problems within the
    /// past seven days are returned.</p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The maximum number of results to return in a single call. To retrieve the remaining
    /// results, make another call with the returned <code>NextToken</code> value.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token to request the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub component_name: std::option::Option<std::string::String>,
}
impl ListProblemsInput {
    /// <p>The name of the resource group.</p>
    pub fn resource_group_name(&self) -> std::option::Option<&str> {
        self.resource_group_name.as_deref()
    }
    /// <p>The time when the problem was detected, in epoch
    /// seconds. If you don't specify a time frame for the request, problems within the past seven days are returned.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>The time when the problem ended, in epoch seconds. If not specified, problems within the
    /// past seven days are returned.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
    /// <p>The maximum number of results to return in a single call. To retrieve the remaining
    /// results, make another call with the returned <code>NextToken</code> value.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The token to request the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn component_name(&self) -> std::option::Option<&str> {
        self.component_name.as_deref()
    }
}
impl std::fmt::Debug for ListProblemsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListProblemsInput");
        formatter.field("resource_group_name", &self.resource_group_name);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("component_name", &self.component_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListLogPatternSetsInput {
    /// <p>The name of the resource group.</p>
    pub resource_group_name: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in a single call. To retrieve the remaining
    /// results, make another call with the returned <code>NextToken</code> value.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token to request the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListLogPatternSetsInput {
    /// <p>The name of the resource group.</p>
    pub fn resource_group_name(&self) -> std::option::Option<&str> {
        self.resource_group_name.as_deref()
    }
    /// <p>The maximum number of results to return in a single call. To retrieve the remaining
    /// results, make another call with the returned <code>NextToken</code> value.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The token to request the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListLogPatternSetsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListLogPatternSetsInput");
        formatter.field("resource_group_name", &self.resource_group_name);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListLogPatternsInput {
    /// <p>The name of the resource group.</p>
    pub resource_group_name: std::option::Option<std::string::String>,
    /// <p>The name of the log pattern set.</p>
    pub pattern_set_name: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in a single call. To retrieve the remaining
    /// results, make another call with the returned <code>NextToken</code> value.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token to request the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListLogPatternsInput {
    /// <p>The name of the resource group.</p>
    pub fn resource_group_name(&self) -> std::option::Option<&str> {
        self.resource_group_name.as_deref()
    }
    /// <p>The name of the log pattern set.</p>
    pub fn pattern_set_name(&self) -> std::option::Option<&str> {
        self.pattern_set_name.as_deref()
    }
    /// <p>The maximum number of results to return in a single call. To retrieve the remaining
    /// results, make another call with the returned <code>NextToken</code> value.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The token to request the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListLogPatternsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListLogPatternsInput");
        formatter.field("resource_group_name", &self.resource_group_name);
        formatter.field("pattern_set_name", &self.pattern_set_name);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListConfigurationHistoryInput {
    /// <p>Resource group to which the application belongs. </p>
    pub resource_group_name: std::option::Option<std::string::String>,
    /// <p>The start time of the event. </p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The end time of the event.</p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The status of the configuration update event. Possible values include INFO, WARN, and ERROR.</p>
    pub event_status: std::option::Option<crate::model::ConfigurationEventStatus>,
    /// <p> The maximum number of results returned by <code>ListConfigurationHistory</code> in
    /// paginated output. When this parameter is used, <code>ListConfigurationHistory</code>
    /// returns only <code>MaxResults</code> in a single page along with a <code>NextToken</code>
    /// response element. The remaining results of the initial request can be seen by sending
    /// another <code>ListConfigurationHistory</code> request with the returned
    /// <code>NextToken</code> value. If this parameter is not used, then
    /// <code>ListConfigurationHistory</code> returns all results. </p>
    pub max_results: std::option::Option<i32>,
    /// <p>The <code>NextToken</code> value returned from a previous paginated <code>ListConfigurationHistory</code> request where
    /// <code>MaxResults</code> was used and the results exceeded the value of that parameter. Pagination
    /// continues from the end of the previous results that returned the <code>NextToken</code> value. This
    /// value is <code>null</code> when there are no more results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListConfigurationHistoryInput {
    /// <p>Resource group to which the application belongs. </p>
    pub fn resource_group_name(&self) -> std::option::Option<&str> {
        self.resource_group_name.as_deref()
    }
    /// <p>The start time of the event. </p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>The end time of the event.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
    /// <p>The status of the configuration update event. Possible values include INFO, WARN, and ERROR.</p>
    pub fn event_status(&self) -> std::option::Option<&crate::model::ConfigurationEventStatus> {
        self.event_status.as_ref()
    }
    /// <p> The maximum number of results returned by <code>ListConfigurationHistory</code> in
    /// paginated output. When this parameter is used, <code>ListConfigurationHistory</code>
    /// returns only <code>MaxResults</code> in a single page along with a <code>NextToken</code>
    /// response element. The remaining results of the initial request can be seen by sending
    /// another <code>ListConfigurationHistory</code> request with the returned
    /// <code>NextToken</code> value. If this parameter is not used, then
    /// <code>ListConfigurationHistory</code> returns all results. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The <code>NextToken</code> value returned from a previous paginated <code>ListConfigurationHistory</code> request where
    /// <code>MaxResults</code> was used and the results exceeded the value of that parameter. Pagination
    /// continues from the end of the previous results that returned the <code>NextToken</code> value. This
    /// value is <code>null</code> when there are no more results to return.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListConfigurationHistoryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListConfigurationHistoryInput");
        formatter.field("resource_group_name", &self.resource_group_name);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("event_status", &self.event_status);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListComponentsInput {
    /// <p>The name of the resource group.</p>
    pub resource_group_name: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in a single call. To retrieve the remaining
    /// results, make another call with the returned <code>NextToken</code> value.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token to request the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListComponentsInput {
    /// <p>The name of the resource group.</p>
    pub fn resource_group_name(&self) -> std::option::Option<&str> {
        self.resource_group_name.as_deref()
    }
    /// <p>The maximum number of results to return in a single call. To retrieve the remaining
    /// results, make another call with the returned <code>NextToken</code> value.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The token to request the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListComponentsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListComponentsInput");
        formatter.field("resource_group_name", &self.resource_group_name);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListApplicationsInput {
    /// <p>The maximum number of results to return in a single call. To retrieve the remaining
    /// results, make another call with the returned <code>NextToken</code> value.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token to request the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListApplicationsInput {
    /// <p>The maximum number of results to return in a single call. To retrieve the remaining
    /// results, make another call with the returned <code>NextToken</code> value.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The token to request the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListApplicationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListApplicationsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeProblemObservationsInput {
    /// <p>The ID of the problem.</p>
    pub problem_id: std::option::Option<std::string::String>,
}
impl DescribeProblemObservationsInput {
    /// <p>The ID of the problem.</p>
    pub fn problem_id(&self) -> std::option::Option<&str> {
        self.problem_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeProblemObservationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeProblemObservationsInput");
        formatter.field("problem_id", &self.problem_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeProblemInput {
    /// <p>The ID of the problem.</p>
    pub problem_id: std::option::Option<std::string::String>,
}
impl DescribeProblemInput {
    /// <p>The ID of the problem.</p>
    pub fn problem_id(&self) -> std::option::Option<&str> {
        self.problem_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeProblemInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeProblemInput");
        formatter.field("problem_id", &self.problem_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeObservationInput {
    /// <p>The ID of the observation.</p>
    pub observation_id: std::option::Option<std::string::String>,
}
impl DescribeObservationInput {
    /// <p>The ID of the observation.</p>
    pub fn observation_id(&self) -> std::option::Option<&str> {
        self.observation_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeObservationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeObservationInput");
        formatter.field("observation_id", &self.observation_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeLogPatternInput {
    /// <p>The name of the resource group.</p>
    pub resource_group_name: std::option::Option<std::string::String>,
    /// <p>The name of the log pattern set.</p>
    pub pattern_set_name: std::option::Option<std::string::String>,
    /// <p>The name of the log pattern.</p>
    pub pattern_name: std::option::Option<std::string::String>,
}
impl DescribeLogPatternInput {
    /// <p>The name of the resource group.</p>
    pub fn resource_group_name(&self) -> std::option::Option<&str> {
        self.resource_group_name.as_deref()
    }
    /// <p>The name of the log pattern set.</p>
    pub fn pattern_set_name(&self) -> std::option::Option<&str> {
        self.pattern_set_name.as_deref()
    }
    /// <p>The name of the log pattern.</p>
    pub fn pattern_name(&self) -> std::option::Option<&str> {
        self.pattern_name.as_deref()
    }
}
impl std::fmt::Debug for DescribeLogPatternInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeLogPatternInput");
        formatter.field("resource_group_name", &self.resource_group_name);
        formatter.field("pattern_set_name", &self.pattern_set_name);
        formatter.field("pattern_name", &self.pattern_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeComponentConfigurationRecommendationInput {
    /// <p>The name of the resource group.</p>
    pub resource_group_name: std::option::Option<std::string::String>,
    /// <p>The name of the component.</p>
    pub component_name: std::option::Option<std::string::String>,
    /// <p>The tier of the application component. Supported tiers include
    /// <code>DOT_NET_CORE</code>, <code>DOT_NET_WORKER</code>, <code>DOT_NET_WEB</code>, <code>SQL_SERVER</code>,
    /// and <code>DEFAULT</code>.</p>
    pub tier: std::option::Option<crate::model::Tier>,
}
impl DescribeComponentConfigurationRecommendationInput {
    /// <p>The name of the resource group.</p>
    pub fn resource_group_name(&self) -> std::option::Option<&str> {
        self.resource_group_name.as_deref()
    }
    /// <p>The name of the component.</p>
    pub fn component_name(&self) -> std::option::Option<&str> {
        self.component_name.as_deref()
    }
    /// <p>The tier of the application component. Supported tiers include
    /// <code>DOT_NET_CORE</code>, <code>DOT_NET_WORKER</code>, <code>DOT_NET_WEB</code>, <code>SQL_SERVER</code>,
    /// and <code>DEFAULT</code>.</p>
    pub fn tier(&self) -> std::option::Option<&crate::model::Tier> {
        self.tier.as_ref()
    }
}
impl std::fmt::Debug for DescribeComponentConfigurationRecommendationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeComponentConfigurationRecommendationInput");
        formatter.field("resource_group_name", &self.resource_group_name);
        formatter.field("component_name", &self.component_name);
        formatter.field("tier", &self.tier);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeComponentConfigurationInput {
    /// <p>The name of the resource group.</p>
    pub resource_group_name: std::option::Option<std::string::String>,
    /// <p>The name of the component.</p>
    pub component_name: std::option::Option<std::string::String>,
}
impl DescribeComponentConfigurationInput {
    /// <p>The name of the resource group.</p>
    pub fn resource_group_name(&self) -> std::option::Option<&str> {
        self.resource_group_name.as_deref()
    }
    /// <p>The name of the component.</p>
    pub fn component_name(&self) -> std::option::Option<&str> {
        self.component_name.as_deref()
    }
}
impl std::fmt::Debug for DescribeComponentConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeComponentConfigurationInput");
        formatter.field("resource_group_name", &self.resource_group_name);
        formatter.field("component_name", &self.component_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeComponentInput {
    /// <p>The name of the resource group.</p>
    pub resource_group_name: std::option::Option<std::string::String>,
    /// <p>The name of the component.</p>
    pub component_name: std::option::Option<std::string::String>,
}
impl DescribeComponentInput {
    /// <p>The name of the resource group.</p>
    pub fn resource_group_name(&self) -> std::option::Option<&str> {
        self.resource_group_name.as_deref()
    }
    /// <p>The name of the component.</p>
    pub fn component_name(&self) -> std::option::Option<&str> {
        self.component_name.as_deref()
    }
}
impl std::fmt::Debug for DescribeComponentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeComponentInput");
        formatter.field("resource_group_name", &self.resource_group_name);
        formatter.field("component_name", &self.component_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeApplicationInput {
    /// <p>The name of the resource group.</p>
    pub resource_group_name: std::option::Option<std::string::String>,
}
impl DescribeApplicationInput {
    /// <p>The name of the resource group.</p>
    pub fn resource_group_name(&self) -> std::option::Option<&str> {
        self.resource_group_name.as_deref()
    }
}
impl std::fmt::Debug for DescribeApplicationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeApplicationInput");
        formatter.field("resource_group_name", &self.resource_group_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteLogPatternInput {
    /// <p>The name of the resource group.</p>
    pub resource_group_name: std::option::Option<std::string::String>,
    /// <p>The name of the log pattern set.</p>
    pub pattern_set_name: std::option::Option<std::string::String>,
    /// <p>The name of the log pattern.</p>
    pub pattern_name: std::option::Option<std::string::String>,
}
impl DeleteLogPatternInput {
    /// <p>The name of the resource group.</p>
    pub fn resource_group_name(&self) -> std::option::Option<&str> {
        self.resource_group_name.as_deref()
    }
    /// <p>The name of the log pattern set.</p>
    pub fn pattern_set_name(&self) -> std::option::Option<&str> {
        self.pattern_set_name.as_deref()
    }
    /// <p>The name of the log pattern.</p>
    pub fn pattern_name(&self) -> std::option::Option<&str> {
        self.pattern_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteLogPatternInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteLogPatternInput");
        formatter.field("resource_group_name", &self.resource_group_name);
        formatter.field("pattern_set_name", &self.pattern_set_name);
        formatter.field("pattern_name", &self.pattern_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteComponentInput {
    /// <p>The name of the resource group.</p>
    pub resource_group_name: std::option::Option<std::string::String>,
    /// <p>The name of the component.</p>
    pub component_name: std::option::Option<std::string::String>,
}
impl DeleteComponentInput {
    /// <p>The name of the resource group.</p>
    pub fn resource_group_name(&self) -> std::option::Option<&str> {
        self.resource_group_name.as_deref()
    }
    /// <p>The name of the component.</p>
    pub fn component_name(&self) -> std::option::Option<&str> {
        self.component_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteComponentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteComponentInput");
        formatter.field("resource_group_name", &self.resource_group_name);
        formatter.field("component_name", &self.component_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteApplicationInput {
    /// <p>The name of the resource group.</p>
    pub resource_group_name: std::option::Option<std::string::String>,
}
impl DeleteApplicationInput {
    /// <p>The name of the resource group.</p>
    pub fn resource_group_name(&self) -> std::option::Option<&str> {
        self.resource_group_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteApplicationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteApplicationInput");
        formatter.field("resource_group_name", &self.resource_group_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateLogPatternInput {
    /// <p>The name of the resource group.</p>
    pub resource_group_name: std::option::Option<std::string::String>,
    /// <p>The name of the log pattern set.</p>
    pub pattern_set_name: std::option::Option<std::string::String>,
    /// <p>The name of the log pattern.</p>
    pub pattern_name: std::option::Option<std::string::String>,
    /// <p>The log pattern. The pattern must be DFA compatible. Patterns that utilize forward lookahead or backreference constructions are not supported.</p>
    pub pattern: std::option::Option<std::string::String>,
    /// <p>Rank of the log pattern. Must be a value between <code>1</code> and <code>1,000,000</code>. The patterns are sorted by rank, so we recommend that you set your highest priority patterns with the lowest rank. A pattern of rank <code>1</code> will be the first to get matched to a log line. A pattern of rank <code>1,000,000</code> will be last to get matched. When you configure custom log patterns from the console, a <code>Low</code> severity pattern translates to a <code>750,000</code> rank. A <code>Medium</code> severity pattern translates to a <code>500,000</code> rank. And a <code>High</code> severity pattern translates to a <code>250,000</code> rank.
    /// Rank values less than <code>1</code> or greater than <code>1,000,000</code> are reserved for AWS-provided patterns.
    /// </p>
    pub rank: i32,
}
impl CreateLogPatternInput {
    /// <p>The name of the resource group.</p>
    pub fn resource_group_name(&self) -> std::option::Option<&str> {
        self.resource_group_name.as_deref()
    }
    /// <p>The name of the log pattern set.</p>
    pub fn pattern_set_name(&self) -> std::option::Option<&str> {
        self.pattern_set_name.as_deref()
    }
    /// <p>The name of the log pattern.</p>
    pub fn pattern_name(&self) -> std::option::Option<&str> {
        self.pattern_name.as_deref()
    }
    /// <p>The log pattern. The pattern must be DFA compatible. Patterns that utilize forward lookahead or backreference constructions are not supported.</p>
    pub fn pattern(&self) -> std::option::Option<&str> {
        self.pattern.as_deref()
    }
    /// <p>Rank of the log pattern. Must be a value between <code>1</code> and <code>1,000,000</code>. The patterns are sorted by rank, so we recommend that you set your highest priority patterns with the lowest rank. A pattern of rank <code>1</code> will be the first to get matched to a log line. A pattern of rank <code>1,000,000</code> will be last to get matched. When you configure custom log patterns from the console, a <code>Low</code> severity pattern translates to a <code>750,000</code> rank. A <code>Medium</code> severity pattern translates to a <code>500,000</code> rank. And a <code>High</code> severity pattern translates to a <code>250,000</code> rank.
    /// Rank values less than <code>1</code> or greater than <code>1,000,000</code> are reserved for AWS-provided patterns.
    /// </p>
    pub fn rank(&self) -> i32 {
        self.rank
    }
}
impl std::fmt::Debug for CreateLogPatternInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateLogPatternInput");
        formatter.field("resource_group_name", &self.resource_group_name);
        formatter.field("pattern_set_name", &self.pattern_set_name);
        formatter.field("pattern_name", &self.pattern_name);
        formatter.field("pattern", &self.pattern);
        formatter.field("rank", &self.rank);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateComponentInput {
    /// <p>The name of the resource group.</p>
    pub resource_group_name: std::option::Option<std::string::String>,
    /// <p>The name of the component.</p>
    pub component_name: std::option::Option<std::string::String>,
    /// <p>The list of resource ARNs that belong to the component.</p>
    pub resource_list: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl CreateComponentInput {
    /// <p>The name of the resource group.</p>
    pub fn resource_group_name(&self) -> std::option::Option<&str> {
        self.resource_group_name.as_deref()
    }
    /// <p>The name of the component.</p>
    pub fn component_name(&self) -> std::option::Option<&str> {
        self.component_name.as_deref()
    }
    /// <p>The list of resource ARNs that belong to the component.</p>
    pub fn resource_list(&self) -> std::option::Option<&[std::string::String]> {
        self.resource_list.as_deref()
    }
}
impl std::fmt::Debug for CreateComponentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateComponentInput");
        formatter.field("resource_group_name", &self.resource_group_name);
        formatter.field("component_name", &self.component_name);
        formatter.field("resource_list", &self.resource_list);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateApplicationInput {
    /// <p>The name of the resource group.</p>
    pub resource_group_name: std::option::Option<std::string::String>,
    /// <p>
    /// When set to <code>true</code>, creates opsItems for any problems detected on an application.
    /// </p>
    pub ops_center_enabled: std::option::Option<bool>,
    /// <p>
    /// Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as <code>instance terminated</code>, <code>failed deployment</code>, and others.
    /// </p>
    pub cwe_monitor_enabled: std::option::Option<bool>,
    /// <p>
    /// The SNS topic provided to Application Insights that is associated to the created opsItem. Allows you to
    /// receive notifications for updates to the opsItem.
    /// </p>
    pub ops_item_sns_topic_arn: std::option::Option<std::string::String>,
    /// <p>List of tags to add to the application.
    /// tag key (<code>Key</code>) and an associated tag value (<code>Value</code>). The maximum
    /// length of a tag key is 128 characters. The maximum length of a tag value is 256
    /// characters.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    #[allow(missing_docs)] // documentation missing in model
    pub auto_config_enabled: std::option::Option<bool>,
    #[allow(missing_docs)] // documentation missing in model
    pub auto_create: std::option::Option<bool>,
}
impl CreateApplicationInput {
    /// <p>The name of the resource group.</p>
    pub fn resource_group_name(&self) -> std::option::Option<&str> {
        self.resource_group_name.as_deref()
    }
    /// <p>
    /// When set to <code>true</code>, creates opsItems for any problems detected on an application.
    /// </p>
    pub fn ops_center_enabled(&self) -> std::option::Option<bool> {
        self.ops_center_enabled
    }
    /// <p>
    /// Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as <code>instance terminated</code>, <code>failed deployment</code>, and others.
    /// </p>
    pub fn cwe_monitor_enabled(&self) -> std::option::Option<bool> {
        self.cwe_monitor_enabled
    }
    /// <p>
    /// The SNS topic provided to Application Insights that is associated to the created opsItem. Allows you to
    /// receive notifications for updates to the opsItem.
    /// </p>
    pub fn ops_item_sns_topic_arn(&self) -> std::option::Option<&str> {
        self.ops_item_sns_topic_arn.as_deref()
    }
    /// <p>List of tags to add to the application.
    /// tag key (<code>Key</code>) and an associated tag value (<code>Value</code>). The maximum
    /// length of a tag key is 128 characters. The maximum length of a tag value is 256
    /// characters.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn auto_config_enabled(&self) -> std::option::Option<bool> {
        self.auto_config_enabled
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn auto_create(&self) -> std::option::Option<bool> {
        self.auto_create
    }
}
impl std::fmt::Debug for CreateApplicationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateApplicationInput");
        formatter.field("resource_group_name", &self.resource_group_name);
        formatter.field("ops_center_enabled", &self.ops_center_enabled);
        formatter.field("cwe_monitor_enabled", &self.cwe_monitor_enabled);
        formatter.field("ops_item_sns_topic_arn", &self.ops_item_sns_topic_arn);
        formatter.field("tags", &self.tags);
        formatter.field("auto_config_enabled", &self.auto_config_enabled);
        formatter.field("auto_create", &self.auto_create);
        formatter.finish()
    }
}
