// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>An object that defines the log patterns that belongs to a <code>LogPatternSet</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LogPattern {
    /// <p>The name of the log pattern. A log pattern name can contain as many as 30 characters, and it cannot be empty. The characters can be Unicode letters, digits, or one of the following symbols: period, dash, underscore.</p>
    pub pattern_set_name: std::option::Option<std::string::String>,
    /// <p>The name of the log pattern. A log pattern name can contain as many as 50 characters, and it cannot be empty. The characters can be Unicode letters, digits, or one of the following symbols: period, dash, underscore.</p>
    pub pattern_name: std::option::Option<std::string::String>,
    /// <p>A regular expression that defines the log pattern. A log pattern can contain as many as 50 characters, and it cannot be empty. The pattern must be DFA compatible. Patterns that utilize forward lookahead or backreference constructions are not supported.</p>
    pub pattern: std::option::Option<std::string::String>,
    /// <p>Rank of the log pattern. Must be a value between <code>1</code> and <code>1,000,000</code>. The patterns are sorted by rank, so we recommend that you set your highest priority patterns with the lowest rank. A pattern of rank <code>1</code> will be the first to get matched to a log line. A pattern of rank <code>1,000,000</code> will be last to get matched. When you configure custom log patterns from the console, a <code>Low</code> severity pattern translates to a <code>750,000</code> rank. A <code>Medium</code> severity pattern translates to a <code>500,000</code> rank. And a <code>High</code> severity pattern translates to a <code>250,000</code> rank. Rank values less than <code>1</code> or greater than <code>1,000,000</code> are reserved for AWS-provided patterns. </p>
    pub rank: i32,
}
impl LogPattern {
    /// <p>The name of the log pattern. A log pattern name can contain as many as 30 characters, and it cannot be empty. The characters can be Unicode letters, digits, or one of the following symbols: period, dash, underscore.</p>
    pub fn pattern_set_name(&self) -> std::option::Option<&str> {
        self.pattern_set_name.as_deref()
    }
    /// <p>The name of the log pattern. A log pattern name can contain as many as 50 characters, and it cannot be empty. The characters can be Unicode letters, digits, or one of the following symbols: period, dash, underscore.</p>
    pub fn pattern_name(&self) -> std::option::Option<&str> {
        self.pattern_name.as_deref()
    }
    /// <p>A regular expression that defines the log pattern. A log pattern can contain as many as 50 characters, and it cannot be empty. The pattern must be DFA compatible. Patterns that utilize forward lookahead or backreference constructions are not supported.</p>
    pub fn pattern(&self) -> std::option::Option<&str> {
        self.pattern.as_deref()
    }
    /// <p>Rank of the log pattern. Must be a value between <code>1</code> and <code>1,000,000</code>. The patterns are sorted by rank, so we recommend that you set your highest priority patterns with the lowest rank. A pattern of rank <code>1</code> will be the first to get matched to a log line. A pattern of rank <code>1,000,000</code> will be last to get matched. When you configure custom log patterns from the console, a <code>Low</code> severity pattern translates to a <code>750,000</code> rank. A <code>Medium</code> severity pattern translates to a <code>500,000</code> rank. And a <code>High</code> severity pattern translates to a <code>250,000</code> rank. Rank values less than <code>1</code> or greater than <code>1,000,000</code> are reserved for AWS-provided patterns. </p>
    pub fn rank(&self) -> i32 {
        self.rank
    }
}
impl std::fmt::Debug for LogPattern {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LogPattern");
        formatter.field("pattern_set_name", &self.pattern_set_name);
        formatter.field("pattern_name", &self.pattern_name);
        formatter.field("pattern", &self.pattern);
        formatter.field("rank", &self.rank);
        formatter.finish()
    }
}
/// See [`LogPattern`](crate::model::LogPattern)
pub mod log_pattern {
    /// A builder for [`LogPattern`](crate::model::LogPattern)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pattern_set_name: std::option::Option<std::string::String>,
        pub(crate) pattern_name: std::option::Option<std::string::String>,
        pub(crate) pattern: std::option::Option<std::string::String>,
        pub(crate) rank: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the log pattern. A log pattern name can contain as many as 30 characters, and it cannot be empty. The characters can be Unicode letters, digits, or one of the following symbols: period, dash, underscore.</p>
        pub fn pattern_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.pattern_set_name = Some(input.into());
            self
        }
        /// <p>The name of the log pattern. A log pattern name can contain as many as 30 characters, and it cannot be empty. The characters can be Unicode letters, digits, or one of the following symbols: period, dash, underscore.</p>
        pub fn set_pattern_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pattern_set_name = input;
            self
        }
        /// <p>The name of the log pattern. A log pattern name can contain as many as 50 characters, and it cannot be empty. The characters can be Unicode letters, digits, or one of the following symbols: period, dash, underscore.</p>
        pub fn pattern_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.pattern_name = Some(input.into());
            self
        }
        /// <p>The name of the log pattern. A log pattern name can contain as many as 50 characters, and it cannot be empty. The characters can be Unicode letters, digits, or one of the following symbols: period, dash, underscore.</p>
        pub fn set_pattern_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pattern_name = input;
            self
        }
        /// <p>A regular expression that defines the log pattern. A log pattern can contain as many as 50 characters, and it cannot be empty. The pattern must be DFA compatible. Patterns that utilize forward lookahead or backreference constructions are not supported.</p>
        pub fn pattern(mut self, input: impl Into<std::string::String>) -> Self {
            self.pattern = Some(input.into());
            self
        }
        /// <p>A regular expression that defines the log pattern. A log pattern can contain as many as 50 characters, and it cannot be empty. The pattern must be DFA compatible. Patterns that utilize forward lookahead or backreference constructions are not supported.</p>
        pub fn set_pattern(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pattern = input;
            self
        }
        /// <p>Rank of the log pattern. Must be a value between <code>1</code> and <code>1,000,000</code>. The patterns are sorted by rank, so we recommend that you set your highest priority patterns with the lowest rank. A pattern of rank <code>1</code> will be the first to get matched to a log line. A pattern of rank <code>1,000,000</code> will be last to get matched. When you configure custom log patterns from the console, a <code>Low</code> severity pattern translates to a <code>750,000</code> rank. A <code>Medium</code> severity pattern translates to a <code>500,000</code> rank. And a <code>High</code> severity pattern translates to a <code>250,000</code> rank. Rank values less than <code>1</code> or greater than <code>1,000,000</code> are reserved for AWS-provided patterns. </p>
        pub fn rank(mut self, input: i32) -> Self {
            self.rank = Some(input);
            self
        }
        /// <p>Rank of the log pattern. Must be a value between <code>1</code> and <code>1,000,000</code>. The patterns are sorted by rank, so we recommend that you set your highest priority patterns with the lowest rank. A pattern of rank <code>1</code> will be the first to get matched to a log line. A pattern of rank <code>1,000,000</code> will be last to get matched. When you configure custom log patterns from the console, a <code>Low</code> severity pattern translates to a <code>750,000</code> rank. A <code>Medium</code> severity pattern translates to a <code>500,000</code> rank. And a <code>High</code> severity pattern translates to a <code>250,000</code> rank. Rank values less than <code>1</code> or greater than <code>1,000,000</code> are reserved for AWS-provided patterns. </p>
        pub fn set_rank(mut self, input: std::option::Option<i32>) -> Self {
            self.rank = input;
            self
        }
        /// Consumes the builder and constructs a [`LogPattern`](crate::model::LogPattern)
        pub fn build(self) -> crate::model::LogPattern {
            crate::model::LogPattern {
                pattern_set_name: self.pattern_set_name,
                pattern_name: self.pattern_name,
                pattern: self.pattern,
                rank: self.rank.unwrap_or_default(),
            }
        }
    }
}
impl LogPattern {
    /// Creates a new builder-style object to manufacture [`LogPattern`](crate::model::LogPattern)
    pub fn builder() -> crate::model::log_pattern::Builder {
        crate::model::log_pattern::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Tier {
    #[allow(missing_docs)] // documentation missing in model
    ActiveDirectory,
    #[allow(missing_docs)] // documentation missing in model
    Custom,
    #[allow(missing_docs)] // documentation missing in model
    Default,
    #[allow(missing_docs)] // documentation missing in model
    DotNetCore,
    #[allow(missing_docs)] // documentation missing in model
    DotNetWeb,
    #[allow(missing_docs)] // documentation missing in model
    DotNetWebTier,
    #[allow(missing_docs)] // documentation missing in model
    DotNetWorker,
    #[allow(missing_docs)] // documentation missing in model
    JavaJmx,
    #[allow(missing_docs)] // documentation missing in model
    Mysql,
    #[allow(missing_docs)] // documentation missing in model
    Oracle,
    #[allow(missing_docs)] // documentation missing in model
    Postgresql,
    #[allow(missing_docs)] // documentation missing in model
    SapHanaHighAvailability,
    #[allow(missing_docs)] // documentation missing in model
    SapHanaMultiNode,
    #[allow(missing_docs)] // documentation missing in model
    SapHanaSingleNode,
    #[allow(missing_docs)] // documentation missing in model
    Sharepoint,
    #[allow(missing_docs)] // documentation missing in model
    SqlServer,
    #[allow(missing_docs)] // documentation missing in model
    SqlServerAlwaysonAvailabilityGroup,
    #[allow(missing_docs)] // documentation missing in model
    SqlServerFailoverClusterInstance,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Tier {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE_DIRECTORY" => Tier::ActiveDirectory,
            "CUSTOM" => Tier::Custom,
            "DEFAULT" => Tier::Default,
            "DOT_NET_CORE" => Tier::DotNetCore,
            "DOT_NET_WEB" => Tier::DotNetWeb,
            "DOT_NET_WEB_TIER" => Tier::DotNetWebTier,
            "DOT_NET_WORKER" => Tier::DotNetWorker,
            "JAVA_JMX" => Tier::JavaJmx,
            "MYSQL" => Tier::Mysql,
            "ORACLE" => Tier::Oracle,
            "POSTGRESQL" => Tier::Postgresql,
            "SAP_HANA_HIGH_AVAILABILITY" => Tier::SapHanaHighAvailability,
            "SAP_HANA_MULTI_NODE" => Tier::SapHanaMultiNode,
            "SAP_HANA_SINGLE_NODE" => Tier::SapHanaSingleNode,
            "SHAREPOINT" => Tier::Sharepoint,
            "SQL_SERVER" => Tier::SqlServer,
            "SQL_SERVER_ALWAYSON_AVAILABILITY_GROUP" => Tier::SqlServerAlwaysonAvailabilityGroup,
            "SQL_SERVER_FAILOVER_CLUSTER_INSTANCE" => Tier::SqlServerFailoverClusterInstance,
            other => Tier::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Tier {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Tier::from(s))
    }
}
impl Tier {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Tier::ActiveDirectory => "ACTIVE_DIRECTORY",
            Tier::Custom => "CUSTOM",
            Tier::Default => "DEFAULT",
            Tier::DotNetCore => "DOT_NET_CORE",
            Tier::DotNetWeb => "DOT_NET_WEB",
            Tier::DotNetWebTier => "DOT_NET_WEB_TIER",
            Tier::DotNetWorker => "DOT_NET_WORKER",
            Tier::JavaJmx => "JAVA_JMX",
            Tier::Mysql => "MYSQL",
            Tier::Oracle => "ORACLE",
            Tier::Postgresql => "POSTGRESQL",
            Tier::SapHanaHighAvailability => "SAP_HANA_HIGH_AVAILABILITY",
            Tier::SapHanaMultiNode => "SAP_HANA_MULTI_NODE",
            Tier::SapHanaSingleNode => "SAP_HANA_SINGLE_NODE",
            Tier::Sharepoint => "SHAREPOINT",
            Tier::SqlServer => "SQL_SERVER",
            Tier::SqlServerAlwaysonAvailabilityGroup => "SQL_SERVER_ALWAYSON_AVAILABILITY_GROUP",
            Tier::SqlServerFailoverClusterInstance => "SQL_SERVER_FAILOVER_CLUSTER_INSTANCE",
            Tier::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTIVE_DIRECTORY",
            "CUSTOM",
            "DEFAULT",
            "DOT_NET_CORE",
            "DOT_NET_WEB",
            "DOT_NET_WEB_TIER",
            "DOT_NET_WORKER",
            "JAVA_JMX",
            "MYSQL",
            "ORACLE",
            "POSTGRESQL",
            "SAP_HANA_HIGH_AVAILABILITY",
            "SAP_HANA_MULTI_NODE",
            "SAP_HANA_SINGLE_NODE",
            "SHAREPOINT",
            "SQL_SERVER",
            "SQL_SERVER_ALWAYSON_AVAILABILITY_GROUP",
            "SQL_SERVER_FAILOVER_CLUSTER_INSTANCE",
        ]
    }
}
impl AsRef<str> for Tier {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the status of the application.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApplicationInfo {
    /// <p>The name of the resource group used for the application.</p>
    pub resource_group_name: std::option::Option<std::string::String>,
    /// <p>The lifecycle of the application. </p>
    pub life_cycle: std::option::Option<std::string::String>,
    /// <p> The SNS topic provided to Application Insights that is associated to the created opsItems to receive SNS notifications for opsItem updates. </p>
    pub ops_item_sns_topic_arn: std::option::Option<std::string::String>,
    /// <p> Indicates whether Application Insights will create opsItems for any problem detected by Application Insights for an application. </p>
    pub ops_center_enabled: std::option::Option<bool>,
    /// <p> Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as <code>instance terminated</code>, <code>failed deployment</code>, and others. </p>
    pub cwe_monitor_enabled: std::option::Option<bool>,
    /// <p>The issues on the user side that block Application Insights from successfully monitoring an application. Example remarks include:</p>
    /// <ul>
    /// <li> <p>“Configuring application, detected 1 Errors, 3 Warnings”</p> </li>
    /// <li> <p>“Configuring application, detected 1 Unconfigured Components”</p> </li>
    /// </ul>
    pub remarks: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub auto_config_enabled: std::option::Option<bool>,
    #[allow(missing_docs)] // documentation missing in model
    pub discovery_type: std::option::Option<crate::model::DiscoveryType>,
}
impl ApplicationInfo {
    /// <p>The name of the resource group used for the application.</p>
    pub fn resource_group_name(&self) -> std::option::Option<&str> {
        self.resource_group_name.as_deref()
    }
    /// <p>The lifecycle of the application. </p>
    pub fn life_cycle(&self) -> std::option::Option<&str> {
        self.life_cycle.as_deref()
    }
    /// <p> The SNS topic provided to Application Insights that is associated to the created opsItems to receive SNS notifications for opsItem updates. </p>
    pub fn ops_item_sns_topic_arn(&self) -> std::option::Option<&str> {
        self.ops_item_sns_topic_arn.as_deref()
    }
    /// <p> Indicates whether Application Insights will create opsItems for any problem detected by Application Insights for an application. </p>
    pub fn ops_center_enabled(&self) -> std::option::Option<bool> {
        self.ops_center_enabled
    }
    /// <p> Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as <code>instance terminated</code>, <code>failed deployment</code>, and others. </p>
    pub fn cwe_monitor_enabled(&self) -> std::option::Option<bool> {
        self.cwe_monitor_enabled
    }
    /// <p>The issues on the user side that block Application Insights from successfully monitoring an application. Example remarks include:</p>
    /// <ul>
    /// <li> <p>“Configuring application, detected 1 Errors, 3 Warnings”</p> </li>
    /// <li> <p>“Configuring application, detected 1 Unconfigured Components”</p> </li>
    /// </ul>
    pub fn remarks(&self) -> std::option::Option<&str> {
        self.remarks.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn auto_config_enabled(&self) -> std::option::Option<bool> {
        self.auto_config_enabled
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn discovery_type(&self) -> std::option::Option<&crate::model::DiscoveryType> {
        self.discovery_type.as_ref()
    }
}
impl std::fmt::Debug for ApplicationInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApplicationInfo");
        formatter.field("resource_group_name", &self.resource_group_name);
        formatter.field("life_cycle", &self.life_cycle);
        formatter.field("ops_item_sns_topic_arn", &self.ops_item_sns_topic_arn);
        formatter.field("ops_center_enabled", &self.ops_center_enabled);
        formatter.field("cwe_monitor_enabled", &self.cwe_monitor_enabled);
        formatter.field("remarks", &self.remarks);
        formatter.field("auto_config_enabled", &self.auto_config_enabled);
        formatter.field("discovery_type", &self.discovery_type);
        formatter.finish()
    }
}
/// See [`ApplicationInfo`](crate::model::ApplicationInfo)
pub mod application_info {
    /// A builder for [`ApplicationInfo`](crate::model::ApplicationInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_group_name: std::option::Option<std::string::String>,
        pub(crate) life_cycle: std::option::Option<std::string::String>,
        pub(crate) ops_item_sns_topic_arn: std::option::Option<std::string::String>,
        pub(crate) ops_center_enabled: std::option::Option<bool>,
        pub(crate) cwe_monitor_enabled: std::option::Option<bool>,
        pub(crate) remarks: std::option::Option<std::string::String>,
        pub(crate) auto_config_enabled: std::option::Option<bool>,
        pub(crate) discovery_type: std::option::Option<crate::model::DiscoveryType>,
    }
    impl Builder {
        /// <p>The name of the resource group used for the application.</p>
        pub fn resource_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_group_name = Some(input.into());
            self
        }
        /// <p>The name of the resource group used for the application.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_group_name = input;
            self
        }
        /// <p>The lifecycle of the application. </p>
        pub fn life_cycle(mut self, input: impl Into<std::string::String>) -> Self {
            self.life_cycle = Some(input.into());
            self
        }
        /// <p>The lifecycle of the application. </p>
        pub fn set_life_cycle(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.life_cycle = input;
            self
        }
        /// <p> The SNS topic provided to Application Insights that is associated to the created opsItems to receive SNS notifications for opsItem updates. </p>
        pub fn ops_item_sns_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.ops_item_sns_topic_arn = Some(input.into());
            self
        }
        /// <p> The SNS topic provided to Application Insights that is associated to the created opsItems to receive SNS notifications for opsItem updates. </p>
        pub fn set_ops_item_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ops_item_sns_topic_arn = input;
            self
        }
        /// <p> Indicates whether Application Insights will create opsItems for any problem detected by Application Insights for an application. </p>
        pub fn ops_center_enabled(mut self, input: bool) -> Self {
            self.ops_center_enabled = Some(input);
            self
        }
        /// <p> Indicates whether Application Insights will create opsItems for any problem detected by Application Insights for an application. </p>
        pub fn set_ops_center_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.ops_center_enabled = input;
            self
        }
        /// <p> Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as <code>instance terminated</code>, <code>failed deployment</code>, and others. </p>
        pub fn cwe_monitor_enabled(mut self, input: bool) -> Self {
            self.cwe_monitor_enabled = Some(input);
            self
        }
        /// <p> Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as <code>instance terminated</code>, <code>failed deployment</code>, and others. </p>
        pub fn set_cwe_monitor_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.cwe_monitor_enabled = input;
            self
        }
        /// <p>The issues on the user side that block Application Insights from successfully monitoring an application. Example remarks include:</p>
        /// <ul>
        /// <li> <p>“Configuring application, detected 1 Errors, 3 Warnings”</p> </li>
        /// <li> <p>“Configuring application, detected 1 Unconfigured Components”</p> </li>
        /// </ul>
        pub fn remarks(mut self, input: impl Into<std::string::String>) -> Self {
            self.remarks = Some(input.into());
            self
        }
        /// <p>The issues on the user side that block Application Insights from successfully monitoring an application. Example remarks include:</p>
        /// <ul>
        /// <li> <p>“Configuring application, detected 1 Errors, 3 Warnings”</p> </li>
        /// <li> <p>“Configuring application, detected 1 Unconfigured Components”</p> </li>
        /// </ul>
        pub fn set_remarks(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.remarks = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn auto_config_enabled(mut self, input: bool) -> Self {
            self.auto_config_enabled = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_auto_config_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_config_enabled = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn discovery_type(mut self, input: crate::model::DiscoveryType) -> Self {
            self.discovery_type = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_discovery_type(
            mut self,
            input: std::option::Option<crate::model::DiscoveryType>,
        ) -> Self {
            self.discovery_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ApplicationInfo`](crate::model::ApplicationInfo)
        pub fn build(self) -> crate::model::ApplicationInfo {
            crate::model::ApplicationInfo {
                resource_group_name: self.resource_group_name,
                life_cycle: self.life_cycle,
                ops_item_sns_topic_arn: self.ops_item_sns_topic_arn,
                ops_center_enabled: self.ops_center_enabled,
                cwe_monitor_enabled: self.cwe_monitor_enabled,
                remarks: self.remarks,
                auto_config_enabled: self.auto_config_enabled,
                discovery_type: self.discovery_type,
            }
        }
    }
}
impl ApplicationInfo {
    /// Creates a new builder-style object to manufacture [`ApplicationInfo`](crate::model::ApplicationInfo)
    pub fn builder() -> crate::model::application_info::Builder {
        crate::model::application_info::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DiscoveryType {
    #[allow(missing_docs)] // documentation missing in model
    AccountBased,
    #[allow(missing_docs)] // documentation missing in model
    ResourceGroupBased,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DiscoveryType {
    fn from(s: &str) -> Self {
        match s {
            "ACCOUNT_BASED" => DiscoveryType::AccountBased,
            "RESOURCE_GROUP_BASED" => DiscoveryType::ResourceGroupBased,
            other => DiscoveryType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DiscoveryType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DiscoveryType::from(s))
    }
}
impl DiscoveryType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DiscoveryType::AccountBased => "ACCOUNT_BASED",
            DiscoveryType::ResourceGroupBased => "RESOURCE_GROUP_BASED",
            DiscoveryType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACCOUNT_BASED", "RESOURCE_GROUP_BASED"]
    }
}
impl AsRef<str> for DiscoveryType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that defines the tags associated with an application. A <i>tag</i> is a label that you optionally define and associate with an application. Tags can help you categorize and manage resources in different ways, such as by purpose, owner, environment, or other criteria.</p>
/// <p>Each tag consists of a required <i>tag key</i> and an associated <i>tag value</i>, both of which you define. A tag key is a general label that acts as a category for a more specific tag value. A tag value acts as a descriptor within a tag key. A tag key can contain as many as 128 characters. A tag value can contain as many as 256 characters. The characters can be Unicode letters, digits, white space, or one of the following symbols: _ . : / = + -. The following additional restrictions apply to tags:</p>
/// <ul>
/// <li> <p>Tag keys and values are case sensitive.</p> </li>
/// <li> <p>For each associated resource, each tag key must be unique and it can have only one value.</p> </li>
/// <li> <p>The <code>aws:</code> prefix is reserved for use by AWS; you can’t use it in any tag keys or values that you define. In addition, you can't edit or remove tag keys or values that use this prefix. </p> </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>One part of a key-value pair that defines a tag. The maximum length of a tag key is 128 characters. The minimum length is 1 character.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The optional part of a key-value pair that defines a tag. The maximum length of a tag value is 256 characters. The minimum length is 0 characters. If you don't want an application to have a specific tag value, don't specify a value for this parameter.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>One part of a key-value pair that defines a tag. The maximum length of a tag key is 128 characters. The minimum length is 1 character.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The optional part of a key-value pair that defines a tag. The maximum length of a tag value is 256 characters. The minimum length is 0 characters. If you don't want an application to have a specific tag value, don't specify a value for this parameter.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>One part of a key-value pair that defines a tag. The maximum length of a tag key is 128 characters. The minimum length is 1 character.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>One part of a key-value pair that defines a tag. The maximum length of a tag key is 128 characters. The minimum length is 1 character.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The optional part of a key-value pair that defines a tag. The maximum length of a tag value is 256 characters. The minimum length is 0 characters. If you don't want an application to have a specific tag value, don't specify a value for this parameter.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The optional part of a key-value pair that defines a tag. The maximum length of a tag value is 256 characters. The minimum length is 0 characters. If you don't want an application to have a specific tag value, don't specify a value for this parameter.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>Describes a problem that is detected by correlating observations.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Problem {
    /// <p>The ID of the problem.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the problem.</p>
    pub title: std::option::Option<std::string::String>,
    /// <p>A detailed analysis of the problem using machine learning.</p>
    pub insights: std::option::Option<std::string::String>,
    /// <p>The status of the problem.</p>
    pub status: std::option::Option<crate::model::Status>,
    /// <p>The resource affected by the problem.</p>
    pub affected_resource: std::option::Option<std::string::String>,
    /// <p>The time when the problem started, in epoch seconds.</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time when the problem ended, in epoch seconds.</p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A measure of the level of impact of the problem.</p>
    pub severity_level: std::option::Option<crate::model::SeverityLevel>,
    /// <p>The name of the resource group affected by the problem.</p>
    pub resource_group_name: std::option::Option<std::string::String>,
    /// <p>Feedback provided by the user about the problem.</p>
    pub feedback: std::option::Option<
        std::collections::HashMap<crate::model::FeedbackKey, crate::model::FeedbackValue>,
    >,
    #[allow(missing_docs)] // documentation missing in model
    pub recurring_count: std::option::Option<i64>,
    #[allow(missing_docs)] // documentation missing in model
    pub last_recurrence_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl Problem {
    /// <p>The ID of the problem.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name of the problem.</p>
    pub fn title(&self) -> std::option::Option<&str> {
        self.title.as_deref()
    }
    /// <p>A detailed analysis of the problem using machine learning.</p>
    pub fn insights(&self) -> std::option::Option<&str> {
        self.insights.as_deref()
    }
    /// <p>The status of the problem.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::Status> {
        self.status.as_ref()
    }
    /// <p>The resource affected by the problem.</p>
    pub fn affected_resource(&self) -> std::option::Option<&str> {
        self.affected_resource.as_deref()
    }
    /// <p>The time when the problem started, in epoch seconds.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>The time when the problem ended, in epoch seconds.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
    /// <p>A measure of the level of impact of the problem.</p>
    pub fn severity_level(&self) -> std::option::Option<&crate::model::SeverityLevel> {
        self.severity_level.as_ref()
    }
    /// <p>The name of the resource group affected by the problem.</p>
    pub fn resource_group_name(&self) -> std::option::Option<&str> {
        self.resource_group_name.as_deref()
    }
    /// <p>Feedback provided by the user about the problem.</p>
    pub fn feedback(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<crate::model::FeedbackKey, crate::model::FeedbackValue>,
    > {
        self.feedback.as_ref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn recurring_count(&self) -> std::option::Option<i64> {
        self.recurring_count
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn last_recurrence_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_recurrence_time.as_ref()
    }
}
impl std::fmt::Debug for Problem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Problem");
        formatter.field("id", &self.id);
        formatter.field("title", &self.title);
        formatter.field("insights", &self.insights);
        formatter.field("status", &self.status);
        formatter.field("affected_resource", &self.affected_resource);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("severity_level", &self.severity_level);
        formatter.field("resource_group_name", &self.resource_group_name);
        formatter.field("feedback", &self.feedback);
        formatter.field("recurring_count", &self.recurring_count);
        formatter.field("last_recurrence_time", &self.last_recurrence_time);
        formatter.finish()
    }
}
/// See [`Problem`](crate::model::Problem)
pub mod problem {
    /// A builder for [`Problem`](crate::model::Problem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) title: std::option::Option<std::string::String>,
        pub(crate) insights: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::Status>,
        pub(crate) affected_resource: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) severity_level: std::option::Option<crate::model::SeverityLevel>,
        pub(crate) resource_group_name: std::option::Option<std::string::String>,
        pub(crate) feedback: std::option::Option<
            std::collections::HashMap<crate::model::FeedbackKey, crate::model::FeedbackValue>,
        >,
        pub(crate) recurring_count: std::option::Option<i64>,
        pub(crate) last_recurrence_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The ID of the problem.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the problem.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the problem.</p>
        pub fn title(mut self, input: impl Into<std::string::String>) -> Self {
            self.title = Some(input.into());
            self
        }
        /// <p>The name of the problem.</p>
        pub fn set_title(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.title = input;
            self
        }
        /// <p>A detailed analysis of the problem using machine learning.</p>
        pub fn insights(mut self, input: impl Into<std::string::String>) -> Self {
            self.insights = Some(input.into());
            self
        }
        /// <p>A detailed analysis of the problem using machine learning.</p>
        pub fn set_insights(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.insights = input;
            self
        }
        /// <p>The status of the problem.</p>
        pub fn status(mut self, input: crate::model::Status) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the problem.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::Status>) -> Self {
            self.status = input;
            self
        }
        /// <p>The resource affected by the problem.</p>
        pub fn affected_resource(mut self, input: impl Into<std::string::String>) -> Self {
            self.affected_resource = Some(input.into());
            self
        }
        /// <p>The resource affected by the problem.</p>
        pub fn set_affected_resource(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.affected_resource = input;
            self
        }
        /// <p>The time when the problem started, in epoch seconds.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The time when the problem started, in epoch seconds.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The time when the problem ended, in epoch seconds.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The time when the problem ended, in epoch seconds.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>A measure of the level of impact of the problem.</p>
        pub fn severity_level(mut self, input: crate::model::SeverityLevel) -> Self {
            self.severity_level = Some(input);
            self
        }
        /// <p>A measure of the level of impact of the problem.</p>
        pub fn set_severity_level(
            mut self,
            input: std::option::Option<crate::model::SeverityLevel>,
        ) -> Self {
            self.severity_level = input;
            self
        }
        /// <p>The name of the resource group affected by the problem.</p>
        pub fn resource_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_group_name = Some(input.into());
            self
        }
        /// <p>The name of the resource group affected by the problem.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_group_name = input;
            self
        }
        /// Adds a key-value pair to `feedback`.
        ///
        /// To override the contents of this collection use [`set_feedback`](Self::set_feedback).
        ///
        /// <p>Feedback provided by the user about the problem.</p>
        pub fn feedback(
            mut self,
            k: crate::model::FeedbackKey,
            v: crate::model::FeedbackValue,
        ) -> Self {
            let mut hash_map = self.feedback.unwrap_or_default();
            hash_map.insert(k, v);
            self.feedback = Some(hash_map);
            self
        }
        /// <p>Feedback provided by the user about the problem.</p>
        pub fn set_feedback(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<crate::model::FeedbackKey, crate::model::FeedbackValue>,
            >,
        ) -> Self {
            self.feedback = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn recurring_count(mut self, input: i64) -> Self {
            self.recurring_count = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_recurring_count(mut self, input: std::option::Option<i64>) -> Self {
            self.recurring_count = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn last_recurrence_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_recurrence_time = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_last_recurrence_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_recurrence_time = input;
            self
        }
        /// Consumes the builder and constructs a [`Problem`](crate::model::Problem)
        pub fn build(self) -> crate::model::Problem {
            crate::model::Problem {
                id: self.id,
                title: self.title,
                insights: self.insights,
                status: self.status,
                affected_resource: self.affected_resource,
                start_time: self.start_time,
                end_time: self.end_time,
                severity_level: self.severity_level,
                resource_group_name: self.resource_group_name,
                feedback: self.feedback,
                recurring_count: self.recurring_count,
                last_recurrence_time: self.last_recurrence_time,
            }
        }
    }
}
impl Problem {
    /// Creates a new builder-style object to manufacture [`Problem`](crate::model::Problem)
    pub fn builder() -> crate::model::problem::Builder {
        crate::model::problem::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FeedbackValue {
    #[allow(missing_docs)] // documentation missing in model
    NotSpecified,
    #[allow(missing_docs)] // documentation missing in model
    NotUseful,
    #[allow(missing_docs)] // documentation missing in model
    Useful,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FeedbackValue {
    fn from(s: &str) -> Self {
        match s {
            "NOT_SPECIFIED" => FeedbackValue::NotSpecified,
            "NOT_USEFUL" => FeedbackValue::NotUseful,
            "USEFUL" => FeedbackValue::Useful,
            other => FeedbackValue::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FeedbackValue {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FeedbackValue::from(s))
    }
}
impl FeedbackValue {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FeedbackValue::NotSpecified => "NOT_SPECIFIED",
            FeedbackValue::NotUseful => "NOT_USEFUL",
            FeedbackValue::Useful => "USEFUL",
            FeedbackValue::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NOT_SPECIFIED", "NOT_USEFUL", "USEFUL"]
    }
}
impl AsRef<str> for FeedbackValue {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FeedbackKey {
    #[allow(missing_docs)] // documentation missing in model
    InsightsFeedback,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FeedbackKey {
    fn from(s: &str) -> Self {
        match s {
            "INSIGHTS_FEEDBACK" => FeedbackKey::InsightsFeedback,
            other => FeedbackKey::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FeedbackKey {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FeedbackKey::from(s))
    }
}
impl FeedbackKey {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FeedbackKey::InsightsFeedback => "INSIGHTS_FEEDBACK",
            FeedbackKey::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["INSIGHTS_FEEDBACK"]
    }
}
impl AsRef<str> for FeedbackKey {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SeverityLevel {
    #[allow(missing_docs)] // documentation missing in model
    High,
    #[allow(missing_docs)] // documentation missing in model
    Low,
    #[allow(missing_docs)] // documentation missing in model
    Medium,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SeverityLevel {
    fn from(s: &str) -> Self {
        match s {
            "High" => SeverityLevel::High,
            "Low" => SeverityLevel::Low,
            "Medium" => SeverityLevel::Medium,
            other => SeverityLevel::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SeverityLevel {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SeverityLevel::from(s))
    }
}
impl SeverityLevel {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SeverityLevel::High => "High",
            SeverityLevel::Low => "Low",
            SeverityLevel::Medium => "Medium",
            SeverityLevel::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["High", "Low", "Medium"]
    }
}
impl AsRef<str> for SeverityLevel {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Status {
    #[allow(missing_docs)] // documentation missing in model
    Ignore,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Recurring,
    #[allow(missing_docs)] // documentation missing in model
    Resolved,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Status {
    fn from(s: &str) -> Self {
        match s {
            "IGNORE" => Status::Ignore,
            "PENDING" => Status::Pending,
            "RECURRING" => Status::Recurring,
            "RESOLVED" => Status::Resolved,
            other => Status::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Status {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Status::from(s))
    }
}
impl Status {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Status::Ignore => "IGNORE",
            Status::Pending => "PENDING",
            Status::Recurring => "RECURRING",
            Status::Resolved => "RESOLVED",
            Status::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["IGNORE", "PENDING", "RECURRING", "RESOLVED"]
    }
}
impl AsRef<str> for Status {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> The event information. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConfigurationEvent {
    /// <p> The resource monitored by Application Insights. </p>
    pub monitored_resource_arn: std::option::Option<std::string::String>,
    /// <p> The status of the configuration update event. Possible values include INFO, WARN, and ERROR. </p>
    pub event_status: std::option::Option<crate::model::ConfigurationEventStatus>,
    /// <p> The resource type that Application Insights attempted to configure, for example, CLOUDWATCH_ALARM. </p>
    pub event_resource_type: std::option::Option<crate::model::ConfigurationEventResourceType>,
    /// <p> The timestamp of the event. </p>
    pub event_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> The details of the event in plain text. </p>
    pub event_detail: std::option::Option<std::string::String>,
    /// <p> The name of the resource Application Insights attempted to configure. </p>
    pub event_resource_name: std::option::Option<std::string::String>,
}
impl ConfigurationEvent {
    /// <p> The resource monitored by Application Insights. </p>
    pub fn monitored_resource_arn(&self) -> std::option::Option<&str> {
        self.monitored_resource_arn.as_deref()
    }
    /// <p> The status of the configuration update event. Possible values include INFO, WARN, and ERROR. </p>
    pub fn event_status(&self) -> std::option::Option<&crate::model::ConfigurationEventStatus> {
        self.event_status.as_ref()
    }
    /// <p> The resource type that Application Insights attempted to configure, for example, CLOUDWATCH_ALARM. </p>
    pub fn event_resource_type(
        &self,
    ) -> std::option::Option<&crate::model::ConfigurationEventResourceType> {
        self.event_resource_type.as_ref()
    }
    /// <p> The timestamp of the event. </p>
    pub fn event_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.event_time.as_ref()
    }
    /// <p> The details of the event in plain text. </p>
    pub fn event_detail(&self) -> std::option::Option<&str> {
        self.event_detail.as_deref()
    }
    /// <p> The name of the resource Application Insights attempted to configure. </p>
    pub fn event_resource_name(&self) -> std::option::Option<&str> {
        self.event_resource_name.as_deref()
    }
}
impl std::fmt::Debug for ConfigurationEvent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConfigurationEvent");
        formatter.field("monitored_resource_arn", &self.monitored_resource_arn);
        formatter.field("event_status", &self.event_status);
        formatter.field("event_resource_type", &self.event_resource_type);
        formatter.field("event_time", &self.event_time);
        formatter.field("event_detail", &self.event_detail);
        formatter.field("event_resource_name", &self.event_resource_name);
        formatter.finish()
    }
}
/// See [`ConfigurationEvent`](crate::model::ConfigurationEvent)
pub mod configuration_event {
    /// A builder for [`ConfigurationEvent`](crate::model::ConfigurationEvent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) monitored_resource_arn: std::option::Option<std::string::String>,
        pub(crate) event_status: std::option::Option<crate::model::ConfigurationEventStatus>,
        pub(crate) event_resource_type:
            std::option::Option<crate::model::ConfigurationEventResourceType>,
        pub(crate) event_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) event_detail: std::option::Option<std::string::String>,
        pub(crate) event_resource_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The resource monitored by Application Insights. </p>
        pub fn monitored_resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.monitored_resource_arn = Some(input.into());
            self
        }
        /// <p> The resource monitored by Application Insights. </p>
        pub fn set_monitored_resource_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.monitored_resource_arn = input;
            self
        }
        /// <p> The status of the configuration update event. Possible values include INFO, WARN, and ERROR. </p>
        pub fn event_status(mut self, input: crate::model::ConfigurationEventStatus) -> Self {
            self.event_status = Some(input);
            self
        }
        /// <p> The status of the configuration update event. Possible values include INFO, WARN, and ERROR. </p>
        pub fn set_event_status(
            mut self,
            input: std::option::Option<crate::model::ConfigurationEventStatus>,
        ) -> Self {
            self.event_status = input;
            self
        }
        /// <p> The resource type that Application Insights attempted to configure, for example, CLOUDWATCH_ALARM. </p>
        pub fn event_resource_type(
            mut self,
            input: crate::model::ConfigurationEventResourceType,
        ) -> Self {
            self.event_resource_type = Some(input);
            self
        }
        /// <p> The resource type that Application Insights attempted to configure, for example, CLOUDWATCH_ALARM. </p>
        pub fn set_event_resource_type(
            mut self,
            input: std::option::Option<crate::model::ConfigurationEventResourceType>,
        ) -> Self {
            self.event_resource_type = input;
            self
        }
        /// <p> The timestamp of the event. </p>
        pub fn event_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.event_time = Some(input);
            self
        }
        /// <p> The timestamp of the event. </p>
        pub fn set_event_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.event_time = input;
            self
        }
        /// <p> The details of the event in plain text. </p>
        pub fn event_detail(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_detail = Some(input.into());
            self
        }
        /// <p> The details of the event in plain text. </p>
        pub fn set_event_detail(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.event_detail = input;
            self
        }
        /// <p> The name of the resource Application Insights attempted to configure. </p>
        pub fn event_resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_resource_name = Some(input.into());
            self
        }
        /// <p> The name of the resource Application Insights attempted to configure. </p>
        pub fn set_event_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_resource_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ConfigurationEvent`](crate::model::ConfigurationEvent)
        pub fn build(self) -> crate::model::ConfigurationEvent {
            crate::model::ConfigurationEvent {
                monitored_resource_arn: self.monitored_resource_arn,
                event_status: self.event_status,
                event_resource_type: self.event_resource_type,
                event_time: self.event_time,
                event_detail: self.event_detail,
                event_resource_name: self.event_resource_name,
            }
        }
    }
}
impl ConfigurationEvent {
    /// Creates a new builder-style object to manufacture [`ConfigurationEvent`](crate::model::ConfigurationEvent)
    pub fn builder() -> crate::model::configuration_event::Builder {
        crate::model::configuration_event::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConfigurationEventResourceType {
    #[allow(missing_docs)] // documentation missing in model
    Cloudformation,
    #[allow(missing_docs)] // documentation missing in model
    CloudwatchAlarm,
    #[allow(missing_docs)] // documentation missing in model
    CloudwatchLog,
    #[allow(missing_docs)] // documentation missing in model
    SsmAssociation,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConfigurationEventResourceType {
    fn from(s: &str) -> Self {
        match s {
            "CLOUDFORMATION" => ConfigurationEventResourceType::Cloudformation,
            "CLOUDWATCH_ALARM" => ConfigurationEventResourceType::CloudwatchAlarm,
            "CLOUDWATCH_LOG" => ConfigurationEventResourceType::CloudwatchLog,
            "SSM_ASSOCIATION" => ConfigurationEventResourceType::SsmAssociation,
            other => ConfigurationEventResourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConfigurationEventResourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConfigurationEventResourceType::from(s))
    }
}
impl ConfigurationEventResourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConfigurationEventResourceType::Cloudformation => "CLOUDFORMATION",
            ConfigurationEventResourceType::CloudwatchAlarm => "CLOUDWATCH_ALARM",
            ConfigurationEventResourceType::CloudwatchLog => "CLOUDWATCH_LOG",
            ConfigurationEventResourceType::SsmAssociation => "SSM_ASSOCIATION",
            ConfigurationEventResourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CLOUDFORMATION",
            "CLOUDWATCH_ALARM",
            "CLOUDWATCH_LOG",
            "SSM_ASSOCIATION",
        ]
    }
}
impl AsRef<str> for ConfigurationEventResourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConfigurationEventStatus {
    #[allow(missing_docs)] // documentation missing in model
    Error,
    #[allow(missing_docs)] // documentation missing in model
    Info,
    #[allow(missing_docs)] // documentation missing in model
    Warn,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConfigurationEventStatus {
    fn from(s: &str) -> Self {
        match s {
            "ERROR" => ConfigurationEventStatus::Error,
            "INFO" => ConfigurationEventStatus::Info,
            "WARN" => ConfigurationEventStatus::Warn,
            other => ConfigurationEventStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConfigurationEventStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConfigurationEventStatus::from(s))
    }
}
impl ConfigurationEventStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConfigurationEventStatus::Error => "ERROR",
            ConfigurationEventStatus::Info => "INFO",
            ConfigurationEventStatus::Warn => "WARN",
            ConfigurationEventStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ERROR", "INFO", "WARN"]
    }
}
impl AsRef<str> for ConfigurationEventStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a standalone resource or similarly grouped resources that the application is made up of.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApplicationComponent {
    /// <p>The name of the component.</p>
    pub component_name: std::option::Option<std::string::String>,
    /// <p> If logging is supported for the resource type, indicates whether the component has configured logs to be monitored. </p>
    pub component_remarks: std::option::Option<std::string::String>,
    /// <p>The resource type. Supported resource types include EC2 instances, Auto Scaling group, Classic ELB, Application ELB, and SQS Queue.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p> The operating system of the component. </p>
    pub os_type: std::option::Option<crate::model::OsType>,
    /// <p>The stack tier of the application component.</p>
    pub tier: std::option::Option<crate::model::Tier>,
    /// <p>Indicates whether the application component is monitored. </p>
    pub monitor: std::option::Option<bool>,
    /// <p> Workloads detected in the application component. </p>
    pub detected_workload: std::option::Option<
        std::collections::HashMap<
            crate::model::Tier,
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    >,
}
impl ApplicationComponent {
    /// <p>The name of the component.</p>
    pub fn component_name(&self) -> std::option::Option<&str> {
        self.component_name.as_deref()
    }
    /// <p> If logging is supported for the resource type, indicates whether the component has configured logs to be monitored. </p>
    pub fn component_remarks(&self) -> std::option::Option<&str> {
        self.component_remarks.as_deref()
    }
    /// <p>The resource type. Supported resource types include EC2 instances, Auto Scaling group, Classic ELB, Application ELB, and SQS Queue.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p> The operating system of the component. </p>
    pub fn os_type(&self) -> std::option::Option<&crate::model::OsType> {
        self.os_type.as_ref()
    }
    /// <p>The stack tier of the application component.</p>
    pub fn tier(&self) -> std::option::Option<&crate::model::Tier> {
        self.tier.as_ref()
    }
    /// <p>Indicates whether the application component is monitored. </p>
    pub fn monitor(&self) -> std::option::Option<bool> {
        self.monitor
    }
    /// <p> Workloads detected in the application component. </p>
    pub fn detected_workload(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<
            crate::model::Tier,
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    > {
        self.detected_workload.as_ref()
    }
}
impl std::fmt::Debug for ApplicationComponent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApplicationComponent");
        formatter.field("component_name", &self.component_name);
        formatter.field("component_remarks", &self.component_remarks);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("os_type", &self.os_type);
        formatter.field("tier", &self.tier);
        formatter.field("monitor", &self.monitor);
        formatter.field("detected_workload", &self.detected_workload);
        formatter.finish()
    }
}
/// See [`ApplicationComponent`](crate::model::ApplicationComponent)
pub mod application_component {
    /// A builder for [`ApplicationComponent`](crate::model::ApplicationComponent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) component_name: std::option::Option<std::string::String>,
        pub(crate) component_remarks: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) os_type: std::option::Option<crate::model::OsType>,
        pub(crate) tier: std::option::Option<crate::model::Tier>,
        pub(crate) monitor: std::option::Option<bool>,
        pub(crate) detected_workload: std::option::Option<
            std::collections::HashMap<
                crate::model::Tier,
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        >,
    }
    impl Builder {
        /// <p>The name of the component.</p>
        pub fn component_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_name = Some(input.into());
            self
        }
        /// <p>The name of the component.</p>
        pub fn set_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_name = input;
            self
        }
        /// <p> If logging is supported for the resource type, indicates whether the component has configured logs to be monitored. </p>
        pub fn component_remarks(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_remarks = Some(input.into());
            self
        }
        /// <p> If logging is supported for the resource type, indicates whether the component has configured logs to be monitored. </p>
        pub fn set_component_remarks(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_remarks = input;
            self
        }
        /// <p>The resource type. Supported resource types include EC2 instances, Auto Scaling group, Classic ELB, Application ELB, and SQS Queue.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The resource type. Supported resource types include EC2 instances, Auto Scaling group, Classic ELB, Application ELB, and SQS Queue.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p> The operating system of the component. </p>
        pub fn os_type(mut self, input: crate::model::OsType) -> Self {
            self.os_type = Some(input);
            self
        }
        /// <p> The operating system of the component. </p>
        pub fn set_os_type(mut self, input: std::option::Option<crate::model::OsType>) -> Self {
            self.os_type = input;
            self
        }
        /// <p>The stack tier of the application component.</p>
        pub fn tier(mut self, input: crate::model::Tier) -> Self {
            self.tier = Some(input);
            self
        }
        /// <p>The stack tier of the application component.</p>
        pub fn set_tier(mut self, input: std::option::Option<crate::model::Tier>) -> Self {
            self.tier = input;
            self
        }
        /// <p>Indicates whether the application component is monitored. </p>
        pub fn monitor(mut self, input: bool) -> Self {
            self.monitor = Some(input);
            self
        }
        /// <p>Indicates whether the application component is monitored. </p>
        pub fn set_monitor(mut self, input: std::option::Option<bool>) -> Self {
            self.monitor = input;
            self
        }
        /// Adds a key-value pair to `detected_workload`.
        ///
        /// To override the contents of this collection use [`set_detected_workload`](Self::set_detected_workload).
        ///
        /// <p> Workloads detected in the application component. </p>
        pub fn detected_workload(
            mut self,
            k: crate::model::Tier,
            v: std::collections::HashMap<std::string::String, std::string::String>,
        ) -> Self {
            let mut hash_map = self.detected_workload.unwrap_or_default();
            hash_map.insert(k, v);
            self.detected_workload = Some(hash_map);
            self
        }
        /// <p> Workloads detected in the application component. </p>
        pub fn set_detected_workload(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    crate::model::Tier,
                    std::collections::HashMap<std::string::String, std::string::String>,
                >,
            >,
        ) -> Self {
            self.detected_workload = input;
            self
        }
        /// Consumes the builder and constructs a [`ApplicationComponent`](crate::model::ApplicationComponent)
        pub fn build(self) -> crate::model::ApplicationComponent {
            crate::model::ApplicationComponent {
                component_name: self.component_name,
                component_remarks: self.component_remarks,
                resource_type: self.resource_type,
                os_type: self.os_type,
                tier: self.tier,
                monitor: self.monitor,
                detected_workload: self.detected_workload,
            }
        }
    }
}
impl ApplicationComponent {
    /// Creates a new builder-style object to manufacture [`ApplicationComponent`](crate::model::ApplicationComponent)
    pub fn builder() -> crate::model::application_component::Builder {
        crate::model::application_component::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OsType {
    #[allow(missing_docs)] // documentation missing in model
    Linux,
    #[allow(missing_docs)] // documentation missing in model
    Windows,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OsType {
    fn from(s: &str) -> Self {
        match s {
            "LINUX" => OsType::Linux,
            "WINDOWS" => OsType::Windows,
            other => OsType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OsType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OsType::from(s))
    }
}
impl OsType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OsType::Linux => "LINUX",
            OsType::Windows => "WINDOWS",
            OsType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["LINUX", "WINDOWS"]
    }
}
impl AsRef<str> for OsType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes observations related to the problem.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RelatedObservations {
    /// <p>The list of observations related to the problem.</p>
    pub observation_list: std::option::Option<std::vec::Vec<crate::model::Observation>>,
}
impl RelatedObservations {
    /// <p>The list of observations related to the problem.</p>
    pub fn observation_list(&self) -> std::option::Option<&[crate::model::Observation]> {
        self.observation_list.as_deref()
    }
}
impl std::fmt::Debug for RelatedObservations {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RelatedObservations");
        formatter.field("observation_list", &self.observation_list);
        formatter.finish()
    }
}
/// See [`RelatedObservations`](crate::model::RelatedObservations)
pub mod related_observations {
    /// A builder for [`RelatedObservations`](crate::model::RelatedObservations)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) observation_list: std::option::Option<std::vec::Vec<crate::model::Observation>>,
    }
    impl Builder {
        /// Appends an item to `observation_list`.
        ///
        /// To override the contents of this collection use [`set_observation_list`](Self::set_observation_list).
        ///
        /// <p>The list of observations related to the problem.</p>
        pub fn observation_list(mut self, input: crate::model::Observation) -> Self {
            let mut v = self.observation_list.unwrap_or_default();
            v.push(input);
            self.observation_list = Some(v);
            self
        }
        /// <p>The list of observations related to the problem.</p>
        pub fn set_observation_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Observation>>,
        ) -> Self {
            self.observation_list = input;
            self
        }
        /// Consumes the builder and constructs a [`RelatedObservations`](crate::model::RelatedObservations)
        pub fn build(self) -> crate::model::RelatedObservations {
            crate::model::RelatedObservations {
                observation_list: self.observation_list,
            }
        }
    }
}
impl RelatedObservations {
    /// Creates a new builder-style object to manufacture [`RelatedObservations`](crate::model::RelatedObservations)
    pub fn builder() -> crate::model::related_observations::Builder {
        crate::model::related_observations::Builder::default()
    }
}

/// <p>Describes an anomaly or error with the application.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Observation {
    /// <p>The ID of the observation type.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The time when the observation was first detected, in epoch seconds.</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time when the observation ended, in epoch seconds.</p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The source type of the observation.</p>
    pub source_type: std::option::Option<std::string::String>,
    /// <p>The source resource ARN of the observation.</p>
    pub source_arn: std::option::Option<std::string::String>,
    /// <p>The log group name.</p>
    pub log_group: std::option::Option<std::string::String>,
    /// <p>The timestamp in the CloudWatch Logs that specifies when the matched line occurred.</p>
    pub line_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The log text of the observation.</p>
    pub log_text: std::option::Option<std::string::String>,
    /// <p>The log filter of the observation.</p>
    pub log_filter: std::option::Option<crate::model::LogFilter>,
    /// <p>The namespace of the observation metric.</p>
    pub metric_namespace: std::option::Option<std::string::String>,
    /// <p>The name of the observation metric.</p>
    pub metric_name: std::option::Option<std::string::String>,
    /// <p>The unit of the source observation metric.</p>
    pub unit: std::option::Option<std::string::String>,
    /// <p>The value of the source observation metric.</p>
    pub value: std::option::Option<f64>,
    /// <p> The ID of the CloudWatch Event-based observation related to the detected problem. </p>
    pub cloud_watch_event_id: std::option::Option<std::string::String>,
    /// <p> The source of the CloudWatch Event. </p>
    pub cloud_watch_event_source: std::option::Option<crate::model::CloudWatchEventSource>,
    /// <p> The detail type of the CloudWatch Event-based observation, for example, <code>EC2 Instance State-change Notification</code>. </p>
    pub cloud_watch_event_detail_type: std::option::Option<std::string::String>,
    /// <p> The Amazon Resource Name (ARN) of the AWS Health Event-based observation.</p>
    pub health_event_arn: std::option::Option<std::string::String>,
    /// <p> The service to which the AWS Health Event belongs, such as EC2. </p>
    pub health_service: std::option::Option<std::string::String>,
    /// <p> The type of the AWS Health event, for example, <code>AWS_EC2_POWER_CONNECTIVITY_ISSUE</code>. </p>
    pub health_event_type_code: std::option::Option<std::string::String>,
    /// <p> The category of the AWS Health event, such as <code>issue</code>. </p>
    pub health_event_type_category: std::option::Option<std::string::String>,
    /// <p> The description of the AWS Health event provided by the service, such as Amazon EC2. </p>
    pub health_event_description: std::option::Option<std::string::String>,
    /// <p> The deployment ID of the CodeDeploy-based observation related to the detected problem. </p>
    pub code_deploy_deployment_id: std::option::Option<std::string::String>,
    /// <p> The deployment group to which the CodeDeploy deployment belongs. </p>
    pub code_deploy_deployment_group: std::option::Option<std::string::String>,
    /// <p> The status of the CodeDeploy deployment, for example <code>SUCCESS</code> or <code> FAILURE</code>. </p>
    pub code_deploy_state: std::option::Option<std::string::String>,
    /// <p> The CodeDeploy application to which the deployment belongs. </p>
    pub code_deploy_application: std::option::Option<std::string::String>,
    /// <p> The instance group to which the CodeDeploy instance belongs. </p>
    pub code_deploy_instance_group_id: std::option::Option<std::string::String>,
    /// <p> The state of the instance, such as <code>STOPPING</code> or <code>TERMINATING</code>. </p>
    pub ec2_state: std::option::Option<std::string::String>,
    /// <p> The category of an RDS event. </p>
    pub rds_event_categories: std::option::Option<std::string::String>,
    /// <p> The message of an RDS event. </p>
    pub rds_event_message: std::option::Option<std::string::String>,
    /// <p> The name of the S3 CloudWatch Event-based observation. </p>
    pub s3_event_name: std::option::Option<std::string::String>,
    /// <p> The Amazon Resource Name (ARN) of the step function execution-based observation. </p>
    pub states_execution_arn: std::option::Option<std::string::String>,
    /// <p> The Amazon Resource Name (ARN) of the step function-based observation. </p>
    pub states_arn: std::option::Option<std::string::String>,
    /// <p> The status of the step function-related observation. </p>
    pub states_status: std::option::Option<std::string::String>,
    /// <p> The input to the step function-based observation. </p>
    pub states_input: std::option::Option<std::string::String>,
    /// <p> The type of EBS CloudWatch event, such as <code>createVolume</code>, <code>deleteVolume</code> or <code>attachVolume</code>. </p>
    pub ebs_event: std::option::Option<std::string::String>,
    /// <p> The result of an EBS CloudWatch event, such as <code>failed</code> or <code>succeeded</code>. </p>
    pub ebs_result: std::option::Option<std::string::String>,
    /// <p> The cause of an EBS CloudWatch event. </p>
    pub ebs_cause: std::option::Option<std::string::String>,
    /// <p> The request ID of an EBS CloudWatch event. </p>
    pub ebs_request_id: std::option::Option<std::string::String>,
    /// <p> The X-Ray request fault percentage for this node. </p>
    pub x_ray_fault_percent: std::option::Option<i32>,
    /// <p> The X-Ray request throttle percentage for this node. </p>
    pub x_ray_throttle_percent: std::option::Option<i32>,
    /// <p> The X-Ray request error percentage for this node. </p>
    pub x_ray_error_percent: std::option::Option<i32>,
    /// <p> The X-Ray request count for this node. </p>
    pub x_ray_request_count: std::option::Option<i32>,
    /// <p> The X-Ray node request average latency for this node. </p>
    pub x_ray_request_average_latency: std::option::Option<i64>,
    /// <p> The name of the X-Ray node. </p>
    pub x_ray_node_name: std::option::Option<std::string::String>,
    /// <p> The type of the X-Ray node. </p>
    pub x_ray_node_type: std::option::Option<std::string::String>,
}
impl Observation {
    /// <p>The ID of the observation type.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The time when the observation was first detected, in epoch seconds.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>The time when the observation ended, in epoch seconds.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
    /// <p>The source type of the observation.</p>
    pub fn source_type(&self) -> std::option::Option<&str> {
        self.source_type.as_deref()
    }
    /// <p>The source resource ARN of the observation.</p>
    pub fn source_arn(&self) -> std::option::Option<&str> {
        self.source_arn.as_deref()
    }
    /// <p>The log group name.</p>
    pub fn log_group(&self) -> std::option::Option<&str> {
        self.log_group.as_deref()
    }
    /// <p>The timestamp in the CloudWatch Logs that specifies when the matched line occurred.</p>
    pub fn line_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.line_time.as_ref()
    }
    /// <p>The log text of the observation.</p>
    pub fn log_text(&self) -> std::option::Option<&str> {
        self.log_text.as_deref()
    }
    /// <p>The log filter of the observation.</p>
    pub fn log_filter(&self) -> std::option::Option<&crate::model::LogFilter> {
        self.log_filter.as_ref()
    }
    /// <p>The namespace of the observation metric.</p>
    pub fn metric_namespace(&self) -> std::option::Option<&str> {
        self.metric_namespace.as_deref()
    }
    /// <p>The name of the observation metric.</p>
    pub fn metric_name(&self) -> std::option::Option<&str> {
        self.metric_name.as_deref()
    }
    /// <p>The unit of the source observation metric.</p>
    pub fn unit(&self) -> std::option::Option<&str> {
        self.unit.as_deref()
    }
    /// <p>The value of the source observation metric.</p>
    pub fn value(&self) -> std::option::Option<f64> {
        self.value
    }
    /// <p> The ID of the CloudWatch Event-based observation related to the detected problem. </p>
    pub fn cloud_watch_event_id(&self) -> std::option::Option<&str> {
        self.cloud_watch_event_id.as_deref()
    }
    /// <p> The source of the CloudWatch Event. </p>
    pub fn cloud_watch_event_source(
        &self,
    ) -> std::option::Option<&crate::model::CloudWatchEventSource> {
        self.cloud_watch_event_source.as_ref()
    }
    /// <p> The detail type of the CloudWatch Event-based observation, for example, <code>EC2 Instance State-change Notification</code>. </p>
    pub fn cloud_watch_event_detail_type(&self) -> std::option::Option<&str> {
        self.cloud_watch_event_detail_type.as_deref()
    }
    /// <p> The Amazon Resource Name (ARN) of the AWS Health Event-based observation.</p>
    pub fn health_event_arn(&self) -> std::option::Option<&str> {
        self.health_event_arn.as_deref()
    }
    /// <p> The service to which the AWS Health Event belongs, such as EC2. </p>
    pub fn health_service(&self) -> std::option::Option<&str> {
        self.health_service.as_deref()
    }
    /// <p> The type of the AWS Health event, for example, <code>AWS_EC2_POWER_CONNECTIVITY_ISSUE</code>. </p>
    pub fn health_event_type_code(&self) -> std::option::Option<&str> {
        self.health_event_type_code.as_deref()
    }
    /// <p> The category of the AWS Health event, such as <code>issue</code>. </p>
    pub fn health_event_type_category(&self) -> std::option::Option<&str> {
        self.health_event_type_category.as_deref()
    }
    /// <p> The description of the AWS Health event provided by the service, such as Amazon EC2. </p>
    pub fn health_event_description(&self) -> std::option::Option<&str> {
        self.health_event_description.as_deref()
    }
    /// <p> The deployment ID of the CodeDeploy-based observation related to the detected problem. </p>
    pub fn code_deploy_deployment_id(&self) -> std::option::Option<&str> {
        self.code_deploy_deployment_id.as_deref()
    }
    /// <p> The deployment group to which the CodeDeploy deployment belongs. </p>
    pub fn code_deploy_deployment_group(&self) -> std::option::Option<&str> {
        self.code_deploy_deployment_group.as_deref()
    }
    /// <p> The status of the CodeDeploy deployment, for example <code>SUCCESS</code> or <code> FAILURE</code>. </p>
    pub fn code_deploy_state(&self) -> std::option::Option<&str> {
        self.code_deploy_state.as_deref()
    }
    /// <p> The CodeDeploy application to which the deployment belongs. </p>
    pub fn code_deploy_application(&self) -> std::option::Option<&str> {
        self.code_deploy_application.as_deref()
    }
    /// <p> The instance group to which the CodeDeploy instance belongs. </p>
    pub fn code_deploy_instance_group_id(&self) -> std::option::Option<&str> {
        self.code_deploy_instance_group_id.as_deref()
    }
    /// <p> The state of the instance, such as <code>STOPPING</code> or <code>TERMINATING</code>. </p>
    pub fn ec2_state(&self) -> std::option::Option<&str> {
        self.ec2_state.as_deref()
    }
    /// <p> The category of an RDS event. </p>
    pub fn rds_event_categories(&self) -> std::option::Option<&str> {
        self.rds_event_categories.as_deref()
    }
    /// <p> The message of an RDS event. </p>
    pub fn rds_event_message(&self) -> std::option::Option<&str> {
        self.rds_event_message.as_deref()
    }
    /// <p> The name of the S3 CloudWatch Event-based observation. </p>
    pub fn s3_event_name(&self) -> std::option::Option<&str> {
        self.s3_event_name.as_deref()
    }
    /// <p> The Amazon Resource Name (ARN) of the step function execution-based observation. </p>
    pub fn states_execution_arn(&self) -> std::option::Option<&str> {
        self.states_execution_arn.as_deref()
    }
    /// <p> The Amazon Resource Name (ARN) of the step function-based observation. </p>
    pub fn states_arn(&self) -> std::option::Option<&str> {
        self.states_arn.as_deref()
    }
    /// <p> The status of the step function-related observation. </p>
    pub fn states_status(&self) -> std::option::Option<&str> {
        self.states_status.as_deref()
    }
    /// <p> The input to the step function-based observation. </p>
    pub fn states_input(&self) -> std::option::Option<&str> {
        self.states_input.as_deref()
    }
    /// <p> The type of EBS CloudWatch event, such as <code>createVolume</code>, <code>deleteVolume</code> or <code>attachVolume</code>. </p>
    pub fn ebs_event(&self) -> std::option::Option<&str> {
        self.ebs_event.as_deref()
    }
    /// <p> The result of an EBS CloudWatch event, such as <code>failed</code> or <code>succeeded</code>. </p>
    pub fn ebs_result(&self) -> std::option::Option<&str> {
        self.ebs_result.as_deref()
    }
    /// <p> The cause of an EBS CloudWatch event. </p>
    pub fn ebs_cause(&self) -> std::option::Option<&str> {
        self.ebs_cause.as_deref()
    }
    /// <p> The request ID of an EBS CloudWatch event. </p>
    pub fn ebs_request_id(&self) -> std::option::Option<&str> {
        self.ebs_request_id.as_deref()
    }
    /// <p> The X-Ray request fault percentage for this node. </p>
    pub fn x_ray_fault_percent(&self) -> std::option::Option<i32> {
        self.x_ray_fault_percent
    }
    /// <p> The X-Ray request throttle percentage for this node. </p>
    pub fn x_ray_throttle_percent(&self) -> std::option::Option<i32> {
        self.x_ray_throttle_percent
    }
    /// <p> The X-Ray request error percentage for this node. </p>
    pub fn x_ray_error_percent(&self) -> std::option::Option<i32> {
        self.x_ray_error_percent
    }
    /// <p> The X-Ray request count for this node. </p>
    pub fn x_ray_request_count(&self) -> std::option::Option<i32> {
        self.x_ray_request_count
    }
    /// <p> The X-Ray node request average latency for this node. </p>
    pub fn x_ray_request_average_latency(&self) -> std::option::Option<i64> {
        self.x_ray_request_average_latency
    }
    /// <p> The name of the X-Ray node. </p>
    pub fn x_ray_node_name(&self) -> std::option::Option<&str> {
        self.x_ray_node_name.as_deref()
    }
    /// <p> The type of the X-Ray node. </p>
    pub fn x_ray_node_type(&self) -> std::option::Option<&str> {
        self.x_ray_node_type.as_deref()
    }
}
impl std::fmt::Debug for Observation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Observation");
        formatter.field("id", &self.id);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("source_type", &self.source_type);
        formatter.field("source_arn", &self.source_arn);
        formatter.field("log_group", &self.log_group);
        formatter.field("line_time", &self.line_time);
        formatter.field("log_text", &self.log_text);
        formatter.field("log_filter", &self.log_filter);
        formatter.field("metric_namespace", &self.metric_namespace);
        formatter.field("metric_name", &self.metric_name);
        formatter.field("unit", &self.unit);
        formatter.field("value", &self.value);
        formatter.field("cloud_watch_event_id", &self.cloud_watch_event_id);
        formatter.field("cloud_watch_event_source", &self.cloud_watch_event_source);
        formatter.field(
            "cloud_watch_event_detail_type",
            &self.cloud_watch_event_detail_type,
        );
        formatter.field("health_event_arn", &self.health_event_arn);
        formatter.field("health_service", &self.health_service);
        formatter.field("health_event_type_code", &self.health_event_type_code);
        formatter.field(
            "health_event_type_category",
            &self.health_event_type_category,
        );
        formatter.field("health_event_description", &self.health_event_description);
        formatter.field("code_deploy_deployment_id", &self.code_deploy_deployment_id);
        formatter.field(
            "code_deploy_deployment_group",
            &self.code_deploy_deployment_group,
        );
        formatter.field("code_deploy_state", &self.code_deploy_state);
        formatter.field("code_deploy_application", &self.code_deploy_application);
        formatter.field(
            "code_deploy_instance_group_id",
            &self.code_deploy_instance_group_id,
        );
        formatter.field("ec2_state", &self.ec2_state);
        formatter.field("rds_event_categories", &self.rds_event_categories);
        formatter.field("rds_event_message", &self.rds_event_message);
        formatter.field("s3_event_name", &self.s3_event_name);
        formatter.field("states_execution_arn", &self.states_execution_arn);
        formatter.field("states_arn", &self.states_arn);
        formatter.field("states_status", &self.states_status);
        formatter.field("states_input", &self.states_input);
        formatter.field("ebs_event", &self.ebs_event);
        formatter.field("ebs_result", &self.ebs_result);
        formatter.field("ebs_cause", &self.ebs_cause);
        formatter.field("ebs_request_id", &self.ebs_request_id);
        formatter.field("x_ray_fault_percent", &self.x_ray_fault_percent);
        formatter.field("x_ray_throttle_percent", &self.x_ray_throttle_percent);
        formatter.field("x_ray_error_percent", &self.x_ray_error_percent);
        formatter.field("x_ray_request_count", &self.x_ray_request_count);
        formatter.field(
            "x_ray_request_average_latency",
            &self.x_ray_request_average_latency,
        );
        formatter.field("x_ray_node_name", &self.x_ray_node_name);
        formatter.field("x_ray_node_type", &self.x_ray_node_type);
        formatter.finish()
    }
}
/// See [`Observation`](crate::model::Observation)
pub mod observation {
    /// A builder for [`Observation`](crate::model::Observation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) source_type: std::option::Option<std::string::String>,
        pub(crate) source_arn: std::option::Option<std::string::String>,
        pub(crate) log_group: std::option::Option<std::string::String>,
        pub(crate) line_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) log_text: std::option::Option<std::string::String>,
        pub(crate) log_filter: std::option::Option<crate::model::LogFilter>,
        pub(crate) metric_namespace: std::option::Option<std::string::String>,
        pub(crate) metric_name: std::option::Option<std::string::String>,
        pub(crate) unit: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<f64>,
        pub(crate) cloud_watch_event_id: std::option::Option<std::string::String>,
        pub(crate) cloud_watch_event_source:
            std::option::Option<crate::model::CloudWatchEventSource>,
        pub(crate) cloud_watch_event_detail_type: std::option::Option<std::string::String>,
        pub(crate) health_event_arn: std::option::Option<std::string::String>,
        pub(crate) health_service: std::option::Option<std::string::String>,
        pub(crate) health_event_type_code: std::option::Option<std::string::String>,
        pub(crate) health_event_type_category: std::option::Option<std::string::String>,
        pub(crate) health_event_description: std::option::Option<std::string::String>,
        pub(crate) code_deploy_deployment_id: std::option::Option<std::string::String>,
        pub(crate) code_deploy_deployment_group: std::option::Option<std::string::String>,
        pub(crate) code_deploy_state: std::option::Option<std::string::String>,
        pub(crate) code_deploy_application: std::option::Option<std::string::String>,
        pub(crate) code_deploy_instance_group_id: std::option::Option<std::string::String>,
        pub(crate) ec2_state: std::option::Option<std::string::String>,
        pub(crate) rds_event_categories: std::option::Option<std::string::String>,
        pub(crate) rds_event_message: std::option::Option<std::string::String>,
        pub(crate) s3_event_name: std::option::Option<std::string::String>,
        pub(crate) states_execution_arn: std::option::Option<std::string::String>,
        pub(crate) states_arn: std::option::Option<std::string::String>,
        pub(crate) states_status: std::option::Option<std::string::String>,
        pub(crate) states_input: std::option::Option<std::string::String>,
        pub(crate) ebs_event: std::option::Option<std::string::String>,
        pub(crate) ebs_result: std::option::Option<std::string::String>,
        pub(crate) ebs_cause: std::option::Option<std::string::String>,
        pub(crate) ebs_request_id: std::option::Option<std::string::String>,
        pub(crate) x_ray_fault_percent: std::option::Option<i32>,
        pub(crate) x_ray_throttle_percent: std::option::Option<i32>,
        pub(crate) x_ray_error_percent: std::option::Option<i32>,
        pub(crate) x_ray_request_count: std::option::Option<i32>,
        pub(crate) x_ray_request_average_latency: std::option::Option<i64>,
        pub(crate) x_ray_node_name: std::option::Option<std::string::String>,
        pub(crate) x_ray_node_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the observation type.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the observation type.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The time when the observation was first detected, in epoch seconds.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The time when the observation was first detected, in epoch seconds.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The time when the observation ended, in epoch seconds.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The time when the observation ended, in epoch seconds.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The source type of the observation.</p>
        pub fn source_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_type = Some(input.into());
            self
        }
        /// <p>The source type of the observation.</p>
        pub fn set_source_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_type = input;
            self
        }
        /// <p>The source resource ARN of the observation.</p>
        pub fn source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_arn = Some(input.into());
            self
        }
        /// <p>The source resource ARN of the observation.</p>
        pub fn set_source_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_arn = input;
            self
        }
        /// <p>The log group name.</p>
        pub fn log_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_group = Some(input.into());
            self
        }
        /// <p>The log group name.</p>
        pub fn set_log_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.log_group = input;
            self
        }
        /// <p>The timestamp in the CloudWatch Logs that specifies when the matched line occurred.</p>
        pub fn line_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.line_time = Some(input);
            self
        }
        /// <p>The timestamp in the CloudWatch Logs that specifies when the matched line occurred.</p>
        pub fn set_line_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.line_time = input;
            self
        }
        /// <p>The log text of the observation.</p>
        pub fn log_text(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_text = Some(input.into());
            self
        }
        /// <p>The log text of the observation.</p>
        pub fn set_log_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.log_text = input;
            self
        }
        /// <p>The log filter of the observation.</p>
        pub fn log_filter(mut self, input: crate::model::LogFilter) -> Self {
            self.log_filter = Some(input);
            self
        }
        /// <p>The log filter of the observation.</p>
        pub fn set_log_filter(
            mut self,
            input: std::option::Option<crate::model::LogFilter>,
        ) -> Self {
            self.log_filter = input;
            self
        }
        /// <p>The namespace of the observation metric.</p>
        pub fn metric_namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_namespace = Some(input.into());
            self
        }
        /// <p>The namespace of the observation metric.</p>
        pub fn set_metric_namespace(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.metric_namespace = input;
            self
        }
        /// <p>The name of the observation metric.</p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_name = Some(input.into());
            self
        }
        /// <p>The name of the observation metric.</p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric_name = input;
            self
        }
        /// <p>The unit of the source observation metric.</p>
        pub fn unit(mut self, input: impl Into<std::string::String>) -> Self {
            self.unit = Some(input.into());
            self
        }
        /// <p>The unit of the source observation metric.</p>
        pub fn set_unit(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.unit = input;
            self
        }
        /// <p>The value of the source observation metric.</p>
        pub fn value(mut self, input: f64) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>The value of the source observation metric.</p>
        pub fn set_value(mut self, input: std::option::Option<f64>) -> Self {
            self.value = input;
            self
        }
        /// <p> The ID of the CloudWatch Event-based observation related to the detected problem. </p>
        pub fn cloud_watch_event_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cloud_watch_event_id = Some(input.into());
            self
        }
        /// <p> The ID of the CloudWatch Event-based observation related to the detected problem. </p>
        pub fn set_cloud_watch_event_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cloud_watch_event_id = input;
            self
        }
        /// <p> The source of the CloudWatch Event. </p>
        pub fn cloud_watch_event_source(
            mut self,
            input: crate::model::CloudWatchEventSource,
        ) -> Self {
            self.cloud_watch_event_source = Some(input);
            self
        }
        /// <p> The source of the CloudWatch Event. </p>
        pub fn set_cloud_watch_event_source(
            mut self,
            input: std::option::Option<crate::model::CloudWatchEventSource>,
        ) -> Self {
            self.cloud_watch_event_source = input;
            self
        }
        /// <p> The detail type of the CloudWatch Event-based observation, for example, <code>EC2 Instance State-change Notification</code>. </p>
        pub fn cloud_watch_event_detail_type(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.cloud_watch_event_detail_type = Some(input.into());
            self
        }
        /// <p> The detail type of the CloudWatch Event-based observation, for example, <code>EC2 Instance State-change Notification</code>. </p>
        pub fn set_cloud_watch_event_detail_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cloud_watch_event_detail_type = input;
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the AWS Health Event-based observation.</p>
        pub fn health_event_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.health_event_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the AWS Health Event-based observation.</p>
        pub fn set_health_event_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.health_event_arn = input;
            self
        }
        /// <p> The service to which the AWS Health Event belongs, such as EC2. </p>
        pub fn health_service(mut self, input: impl Into<std::string::String>) -> Self {
            self.health_service = Some(input.into());
            self
        }
        /// <p> The service to which the AWS Health Event belongs, such as EC2. </p>
        pub fn set_health_service(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.health_service = input;
            self
        }
        /// <p> The type of the AWS Health event, for example, <code>AWS_EC2_POWER_CONNECTIVITY_ISSUE</code>. </p>
        pub fn health_event_type_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.health_event_type_code = Some(input.into());
            self
        }
        /// <p> The type of the AWS Health event, for example, <code>AWS_EC2_POWER_CONNECTIVITY_ISSUE</code>. </p>
        pub fn set_health_event_type_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.health_event_type_code = input;
            self
        }
        /// <p> The category of the AWS Health event, such as <code>issue</code>. </p>
        pub fn health_event_type_category(mut self, input: impl Into<std::string::String>) -> Self {
            self.health_event_type_category = Some(input.into());
            self
        }
        /// <p> The category of the AWS Health event, such as <code>issue</code>. </p>
        pub fn set_health_event_type_category(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.health_event_type_category = input;
            self
        }
        /// <p> The description of the AWS Health event provided by the service, such as Amazon EC2. </p>
        pub fn health_event_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.health_event_description = Some(input.into());
            self
        }
        /// <p> The description of the AWS Health event provided by the service, such as Amazon EC2. </p>
        pub fn set_health_event_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.health_event_description = input;
            self
        }
        /// <p> The deployment ID of the CodeDeploy-based observation related to the detected problem. </p>
        pub fn code_deploy_deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.code_deploy_deployment_id = Some(input.into());
            self
        }
        /// <p> The deployment ID of the CodeDeploy-based observation related to the detected problem. </p>
        pub fn set_code_deploy_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.code_deploy_deployment_id = input;
            self
        }
        /// <p> The deployment group to which the CodeDeploy deployment belongs. </p>
        pub fn code_deploy_deployment_group(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.code_deploy_deployment_group = Some(input.into());
            self
        }
        /// <p> The deployment group to which the CodeDeploy deployment belongs. </p>
        pub fn set_code_deploy_deployment_group(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.code_deploy_deployment_group = input;
            self
        }
        /// <p> The status of the CodeDeploy deployment, for example <code>SUCCESS</code> or <code> FAILURE</code>. </p>
        pub fn code_deploy_state(mut self, input: impl Into<std::string::String>) -> Self {
            self.code_deploy_state = Some(input.into());
            self
        }
        /// <p> The status of the CodeDeploy deployment, for example <code>SUCCESS</code> or <code> FAILURE</code>. </p>
        pub fn set_code_deploy_state(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.code_deploy_state = input;
            self
        }
        /// <p> The CodeDeploy application to which the deployment belongs. </p>
        pub fn code_deploy_application(mut self, input: impl Into<std::string::String>) -> Self {
            self.code_deploy_application = Some(input.into());
            self
        }
        /// <p> The CodeDeploy application to which the deployment belongs. </p>
        pub fn set_code_deploy_application(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.code_deploy_application = input;
            self
        }
        /// <p> The instance group to which the CodeDeploy instance belongs. </p>
        pub fn code_deploy_instance_group_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.code_deploy_instance_group_id = Some(input.into());
            self
        }
        /// <p> The instance group to which the CodeDeploy instance belongs. </p>
        pub fn set_code_deploy_instance_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.code_deploy_instance_group_id = input;
            self
        }
        /// <p> The state of the instance, such as <code>STOPPING</code> or <code>TERMINATING</code>. </p>
        pub fn ec2_state(mut self, input: impl Into<std::string::String>) -> Self {
            self.ec2_state = Some(input.into());
            self
        }
        /// <p> The state of the instance, such as <code>STOPPING</code> or <code>TERMINATING</code>. </p>
        pub fn set_ec2_state(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ec2_state = input;
            self
        }
        /// <p> The category of an RDS event. </p>
        pub fn rds_event_categories(mut self, input: impl Into<std::string::String>) -> Self {
            self.rds_event_categories = Some(input.into());
            self
        }
        /// <p> The category of an RDS event. </p>
        pub fn set_rds_event_categories(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.rds_event_categories = input;
            self
        }
        /// <p> The message of an RDS event. </p>
        pub fn rds_event_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.rds_event_message = Some(input.into());
            self
        }
        /// <p> The message of an RDS event. </p>
        pub fn set_rds_event_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.rds_event_message = input;
            self
        }
        /// <p> The name of the S3 CloudWatch Event-based observation. </p>
        pub fn s3_event_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_event_name = Some(input.into());
            self
        }
        /// <p> The name of the S3 CloudWatch Event-based observation. </p>
        pub fn set_s3_event_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_event_name = input;
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the step function execution-based observation. </p>
        pub fn states_execution_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.states_execution_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the step function execution-based observation. </p>
        pub fn set_states_execution_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.states_execution_arn = input;
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the step function-based observation. </p>
        pub fn states_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.states_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the step function-based observation. </p>
        pub fn set_states_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.states_arn = input;
            self
        }
        /// <p> The status of the step function-related observation. </p>
        pub fn states_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.states_status = Some(input.into());
            self
        }
        /// <p> The status of the step function-related observation. </p>
        pub fn set_states_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.states_status = input;
            self
        }
        /// <p> The input to the step function-based observation. </p>
        pub fn states_input(mut self, input: impl Into<std::string::String>) -> Self {
            self.states_input = Some(input.into());
            self
        }
        /// <p> The input to the step function-based observation. </p>
        pub fn set_states_input(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.states_input = input;
            self
        }
        /// <p> The type of EBS CloudWatch event, such as <code>createVolume</code>, <code>deleteVolume</code> or <code>attachVolume</code>. </p>
        pub fn ebs_event(mut self, input: impl Into<std::string::String>) -> Self {
            self.ebs_event = Some(input.into());
            self
        }
        /// <p> The type of EBS CloudWatch event, such as <code>createVolume</code>, <code>deleteVolume</code> or <code>attachVolume</code>. </p>
        pub fn set_ebs_event(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ebs_event = input;
            self
        }
        /// <p> The result of an EBS CloudWatch event, such as <code>failed</code> or <code>succeeded</code>. </p>
        pub fn ebs_result(mut self, input: impl Into<std::string::String>) -> Self {
            self.ebs_result = Some(input.into());
            self
        }
        /// <p> The result of an EBS CloudWatch event, such as <code>failed</code> or <code>succeeded</code>. </p>
        pub fn set_ebs_result(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ebs_result = input;
            self
        }
        /// <p> The cause of an EBS CloudWatch event. </p>
        pub fn ebs_cause(mut self, input: impl Into<std::string::String>) -> Self {
            self.ebs_cause = Some(input.into());
            self
        }
        /// <p> The cause of an EBS CloudWatch event. </p>
        pub fn set_ebs_cause(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ebs_cause = input;
            self
        }
        /// <p> The request ID of an EBS CloudWatch event. </p>
        pub fn ebs_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ebs_request_id = Some(input.into());
            self
        }
        /// <p> The request ID of an EBS CloudWatch event. </p>
        pub fn set_ebs_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ebs_request_id = input;
            self
        }
        /// <p> The X-Ray request fault percentage for this node. </p>
        pub fn x_ray_fault_percent(mut self, input: i32) -> Self {
            self.x_ray_fault_percent = Some(input);
            self
        }
        /// <p> The X-Ray request fault percentage for this node. </p>
        pub fn set_x_ray_fault_percent(mut self, input: std::option::Option<i32>) -> Self {
            self.x_ray_fault_percent = input;
            self
        }
        /// <p> The X-Ray request throttle percentage for this node. </p>
        pub fn x_ray_throttle_percent(mut self, input: i32) -> Self {
            self.x_ray_throttle_percent = Some(input);
            self
        }
        /// <p> The X-Ray request throttle percentage for this node. </p>
        pub fn set_x_ray_throttle_percent(mut self, input: std::option::Option<i32>) -> Self {
            self.x_ray_throttle_percent = input;
            self
        }
        /// <p> The X-Ray request error percentage for this node. </p>
        pub fn x_ray_error_percent(mut self, input: i32) -> Self {
            self.x_ray_error_percent = Some(input);
            self
        }
        /// <p> The X-Ray request error percentage for this node. </p>
        pub fn set_x_ray_error_percent(mut self, input: std::option::Option<i32>) -> Self {
            self.x_ray_error_percent = input;
            self
        }
        /// <p> The X-Ray request count for this node. </p>
        pub fn x_ray_request_count(mut self, input: i32) -> Self {
            self.x_ray_request_count = Some(input);
            self
        }
        /// <p> The X-Ray request count for this node. </p>
        pub fn set_x_ray_request_count(mut self, input: std::option::Option<i32>) -> Self {
            self.x_ray_request_count = input;
            self
        }
        /// <p> The X-Ray node request average latency for this node. </p>
        pub fn x_ray_request_average_latency(mut self, input: i64) -> Self {
            self.x_ray_request_average_latency = Some(input);
            self
        }
        /// <p> The X-Ray node request average latency for this node. </p>
        pub fn set_x_ray_request_average_latency(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.x_ray_request_average_latency = input;
            self
        }
        /// <p> The name of the X-Ray node. </p>
        pub fn x_ray_node_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.x_ray_node_name = Some(input.into());
            self
        }
        /// <p> The name of the X-Ray node. </p>
        pub fn set_x_ray_node_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.x_ray_node_name = input;
            self
        }
        /// <p> The type of the X-Ray node. </p>
        pub fn x_ray_node_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.x_ray_node_type = Some(input.into());
            self
        }
        /// <p> The type of the X-Ray node. </p>
        pub fn set_x_ray_node_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.x_ray_node_type = input;
            self
        }
        /// Consumes the builder and constructs a [`Observation`](crate::model::Observation)
        pub fn build(self) -> crate::model::Observation {
            crate::model::Observation {
                id: self.id,
                start_time: self.start_time,
                end_time: self.end_time,
                source_type: self.source_type,
                source_arn: self.source_arn,
                log_group: self.log_group,
                line_time: self.line_time,
                log_text: self.log_text,
                log_filter: self.log_filter,
                metric_namespace: self.metric_namespace,
                metric_name: self.metric_name,
                unit: self.unit,
                value: self.value,
                cloud_watch_event_id: self.cloud_watch_event_id,
                cloud_watch_event_source: self.cloud_watch_event_source,
                cloud_watch_event_detail_type: self.cloud_watch_event_detail_type,
                health_event_arn: self.health_event_arn,
                health_service: self.health_service,
                health_event_type_code: self.health_event_type_code,
                health_event_type_category: self.health_event_type_category,
                health_event_description: self.health_event_description,
                code_deploy_deployment_id: self.code_deploy_deployment_id,
                code_deploy_deployment_group: self.code_deploy_deployment_group,
                code_deploy_state: self.code_deploy_state,
                code_deploy_application: self.code_deploy_application,
                code_deploy_instance_group_id: self.code_deploy_instance_group_id,
                ec2_state: self.ec2_state,
                rds_event_categories: self.rds_event_categories,
                rds_event_message: self.rds_event_message,
                s3_event_name: self.s3_event_name,
                states_execution_arn: self.states_execution_arn,
                states_arn: self.states_arn,
                states_status: self.states_status,
                states_input: self.states_input,
                ebs_event: self.ebs_event,
                ebs_result: self.ebs_result,
                ebs_cause: self.ebs_cause,
                ebs_request_id: self.ebs_request_id,
                x_ray_fault_percent: self.x_ray_fault_percent,
                x_ray_throttle_percent: self.x_ray_throttle_percent,
                x_ray_error_percent: self.x_ray_error_percent,
                x_ray_request_count: self.x_ray_request_count,
                x_ray_request_average_latency: self.x_ray_request_average_latency,
                x_ray_node_name: self.x_ray_node_name,
                x_ray_node_type: self.x_ray_node_type,
            }
        }
    }
}
impl Observation {
    /// Creates a new builder-style object to manufacture [`Observation`](crate::model::Observation)
    pub fn builder() -> crate::model::observation::Builder {
        crate::model::observation::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CloudWatchEventSource {
    #[allow(missing_docs)] // documentation missing in model
    CodeDeploy,
    #[allow(missing_docs)] // documentation missing in model
    Ec2,
    #[allow(missing_docs)] // documentation missing in model
    Health,
    #[allow(missing_docs)] // documentation missing in model
    Rds,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CloudWatchEventSource {
    fn from(s: &str) -> Self {
        match s {
            "CODE_DEPLOY" => CloudWatchEventSource::CodeDeploy,
            "EC2" => CloudWatchEventSource::Ec2,
            "HEALTH" => CloudWatchEventSource::Health,
            "RDS" => CloudWatchEventSource::Rds,
            other => CloudWatchEventSource::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CloudWatchEventSource {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CloudWatchEventSource::from(s))
    }
}
impl CloudWatchEventSource {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CloudWatchEventSource::CodeDeploy => "CODE_DEPLOY",
            CloudWatchEventSource::Ec2 => "EC2",
            CloudWatchEventSource::Health => "HEALTH",
            CloudWatchEventSource::Rds => "RDS",
            CloudWatchEventSource::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CODE_DEPLOY", "EC2", "HEALTH", "RDS"]
    }
}
impl AsRef<str> for CloudWatchEventSource {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LogFilter {
    #[allow(missing_docs)] // documentation missing in model
    Error,
    #[allow(missing_docs)] // documentation missing in model
    Info,
    #[allow(missing_docs)] // documentation missing in model
    Warn,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LogFilter {
    fn from(s: &str) -> Self {
        match s {
            "ERROR" => LogFilter::Error,
            "INFO" => LogFilter::Info,
            "WARN" => LogFilter::Warn,
            other => LogFilter::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LogFilter {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LogFilter::from(s))
    }
}
impl LogFilter {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LogFilter::Error => "ERROR",
            LogFilter::Info => "INFO",
            LogFilter::Warn => "WARN",
            LogFilter::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ERROR", "INFO", "WARN"]
    }
}
impl AsRef<str> for LogFilter {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
