// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `EC2WindowsBarleyService`.
///
/// This client allows ergonomic access to a `EC2WindowsBarleyService`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `CreateApplication` operation.
    ///
    /// See [`CreateApplication`](crate::client::fluent_builders::CreateApplication) for more information about the
    /// operation and its arguments.
    pub fn create_application(&self) -> fluent_builders::CreateApplication<C, M, R> {
        fluent_builders::CreateApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateComponent` operation.
    ///
    /// See [`CreateComponent`](crate::client::fluent_builders::CreateComponent) for more information about the
    /// operation and its arguments.
    pub fn create_component(&self) -> fluent_builders::CreateComponent<C, M, R> {
        fluent_builders::CreateComponent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateLogPattern` operation.
    ///
    /// See [`CreateLogPattern`](crate::client::fluent_builders::CreateLogPattern) for more information about the
    /// operation and its arguments.
    pub fn create_log_pattern(&self) -> fluent_builders::CreateLogPattern<C, M, R> {
        fluent_builders::CreateLogPattern::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteApplication` operation.
    ///
    /// See [`DeleteApplication`](crate::client::fluent_builders::DeleteApplication) for more information about the
    /// operation and its arguments.
    pub fn delete_application(&self) -> fluent_builders::DeleteApplication<C, M, R> {
        fluent_builders::DeleteApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteComponent` operation.
    ///
    /// See [`DeleteComponent`](crate::client::fluent_builders::DeleteComponent) for more information about the
    /// operation and its arguments.
    pub fn delete_component(&self) -> fluent_builders::DeleteComponent<C, M, R> {
        fluent_builders::DeleteComponent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteLogPattern` operation.
    ///
    /// See [`DeleteLogPattern`](crate::client::fluent_builders::DeleteLogPattern) for more information about the
    /// operation and its arguments.
    pub fn delete_log_pattern(&self) -> fluent_builders::DeleteLogPattern<C, M, R> {
        fluent_builders::DeleteLogPattern::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeApplication` operation.
    ///
    /// See [`DescribeApplication`](crate::client::fluent_builders::DescribeApplication) for more information about the
    /// operation and its arguments.
    pub fn describe_application(&self) -> fluent_builders::DescribeApplication<C, M, R> {
        fluent_builders::DescribeApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeComponent` operation.
    ///
    /// See [`DescribeComponent`](crate::client::fluent_builders::DescribeComponent) for more information about the
    /// operation and its arguments.
    pub fn describe_component(&self) -> fluent_builders::DescribeComponent<C, M, R> {
        fluent_builders::DescribeComponent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeComponentConfiguration` operation.
    ///
    /// See [`DescribeComponentConfiguration`](crate::client::fluent_builders::DescribeComponentConfiguration) for more information about the
    /// operation and its arguments.
    pub fn describe_component_configuration(
        &self,
    ) -> fluent_builders::DescribeComponentConfiguration<C, M, R> {
        fluent_builders::DescribeComponentConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeComponentConfigurationRecommendation` operation.
    ///
    /// See [`DescribeComponentConfigurationRecommendation`](crate::client::fluent_builders::DescribeComponentConfigurationRecommendation) for more information about the
    /// operation and its arguments.
    pub fn describe_component_configuration_recommendation(
        &self,
    ) -> fluent_builders::DescribeComponentConfigurationRecommendation<C, M, R> {
        fluent_builders::DescribeComponentConfigurationRecommendation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeLogPattern` operation.
    ///
    /// See [`DescribeLogPattern`](crate::client::fluent_builders::DescribeLogPattern) for more information about the
    /// operation and its arguments.
    pub fn describe_log_pattern(&self) -> fluent_builders::DescribeLogPattern<C, M, R> {
        fluent_builders::DescribeLogPattern::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeObservation` operation.
    ///
    /// See [`DescribeObservation`](crate::client::fluent_builders::DescribeObservation) for more information about the
    /// operation and its arguments.
    pub fn describe_observation(&self) -> fluent_builders::DescribeObservation<C, M, R> {
        fluent_builders::DescribeObservation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeProblem` operation.
    ///
    /// See [`DescribeProblem`](crate::client::fluent_builders::DescribeProblem) for more information about the
    /// operation and its arguments.
    pub fn describe_problem(&self) -> fluent_builders::DescribeProblem<C, M, R> {
        fluent_builders::DescribeProblem::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeProblemObservations` operation.
    ///
    /// See [`DescribeProblemObservations`](crate::client::fluent_builders::DescribeProblemObservations) for more information about the
    /// operation and its arguments.
    pub fn describe_problem_observations(
        &self,
    ) -> fluent_builders::DescribeProblemObservations<C, M, R> {
        fluent_builders::DescribeProblemObservations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListApplications` operation.
    ///
    /// See [`ListApplications`](crate::client::fluent_builders::ListApplications) for more information about the
    /// operation and its arguments.
    pub fn list_applications(&self) -> fluent_builders::ListApplications<C, M, R> {
        fluent_builders::ListApplications::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListComponents` operation.
    ///
    /// See [`ListComponents`](crate::client::fluent_builders::ListComponents) for more information about the
    /// operation and its arguments.
    pub fn list_components(&self) -> fluent_builders::ListComponents<C, M, R> {
        fluent_builders::ListComponents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListConfigurationHistory` operation.
    ///
    /// See [`ListConfigurationHistory`](crate::client::fluent_builders::ListConfigurationHistory) for more information about the
    /// operation and its arguments.
    pub fn list_configuration_history(&self) -> fluent_builders::ListConfigurationHistory<C, M, R> {
        fluent_builders::ListConfigurationHistory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListLogPatterns` operation.
    ///
    /// See [`ListLogPatterns`](crate::client::fluent_builders::ListLogPatterns) for more information about the
    /// operation and its arguments.
    pub fn list_log_patterns(&self) -> fluent_builders::ListLogPatterns<C, M, R> {
        fluent_builders::ListLogPatterns::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListLogPatternSets` operation.
    ///
    /// See [`ListLogPatternSets`](crate::client::fluent_builders::ListLogPatternSets) for more information about the
    /// operation and its arguments.
    pub fn list_log_pattern_sets(&self) -> fluent_builders::ListLogPatternSets<C, M, R> {
        fluent_builders::ListLogPatternSets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListProblems` operation.
    ///
    /// See [`ListProblems`](crate::client::fluent_builders::ListProblems) for more information about the
    /// operation and its arguments.
    pub fn list_problems(&self) -> fluent_builders::ListProblems<C, M, R> {
        fluent_builders::ListProblems::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateApplication` operation.
    ///
    /// See [`UpdateApplication`](crate::client::fluent_builders::UpdateApplication) for more information about the
    /// operation and its arguments.
    pub fn update_application(&self) -> fluent_builders::UpdateApplication<C, M, R> {
        fluent_builders::UpdateApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateComponent` operation.
    ///
    /// See [`UpdateComponent`](crate::client::fluent_builders::UpdateComponent) for more information about the
    /// operation and its arguments.
    pub fn update_component(&self) -> fluent_builders::UpdateComponent<C, M, R> {
        fluent_builders::UpdateComponent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateComponentConfiguration` operation.
    ///
    /// See [`UpdateComponentConfiguration`](crate::client::fluent_builders::UpdateComponentConfiguration) for more information about the
    /// operation and its arguments.
    pub fn update_component_configuration(
        &self,
    ) -> fluent_builders::UpdateComponentConfiguration<C, M, R> {
        fluent_builders::UpdateComponentConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateLogPattern` operation.
    ///
    /// See [`UpdateLogPattern`](crate::client::fluent_builders::UpdateLogPattern) for more information about the
    /// operation and its arguments.
    pub fn update_log_pattern(&self) -> fluent_builders::UpdateLogPattern<C, M, R> {
        fluent_builders::UpdateLogPattern::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateApplication`.
    ///
    /// <p>Adds an application that is created from a resource group.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateApplication<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_application_input::Builder,
    }
    impl<C, M, R> CreateApplication<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateApplicationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateApplicationInputOperationOutputAlias,
                crate::output::CreateApplicationOutput,
                crate::error::CreateApplicationError,
                crate::input::CreateApplicationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the resource group.</p>
        pub fn resource_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_group_name(inp);
            self
        }
        /// <p>The name of the resource group.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_group_name(input);
            self
        }
        /// <p>
        /// When set to <code>true</code>, creates opsItems for any problems detected on an application.
        /// </p>
        pub fn ops_center_enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.ops_center_enabled(inp);
            self
        }
        /// <p>
        /// When set to <code>true</code>, creates opsItems for any problems detected on an application.
        /// </p>
        pub fn set_ops_center_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_ops_center_enabled(input);
            self
        }
        /// <p>
        /// Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as <code>instance terminated</code>, <code>failed deployment</code>, and others.
        /// </p>
        pub fn cwe_monitor_enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.cwe_monitor_enabled(inp);
            self
        }
        /// <p>
        /// Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as <code>instance terminated</code>, <code>failed deployment</code>, and others.
        /// </p>
        pub fn set_cwe_monitor_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_cwe_monitor_enabled(input);
            self
        }
        /// <p>
        /// The SNS topic provided to Application Insights that is associated to the created opsItem. Allows you to
        /// receive notifications for updates to the opsItem.
        /// </p>
        pub fn ops_item_sns_topic_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ops_item_sns_topic_arn(inp);
            self
        }
        /// <p>
        /// The SNS topic provided to Application Insights that is associated to the created opsItem. Allows you to
        /// receive notifications for updates to the opsItem.
        /// </p>
        pub fn set_ops_item_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ops_item_sns_topic_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>List of tags to add to the application.
        /// tag key (<code>Key</code>) and an associated tag value (<code>Value</code>). The maximum
        /// length of a tag key is 128 characters. The maximum length of a tag value is 256
        /// characters.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>List of tags to add to the application.
        /// tag key (<code>Key</code>) and an associated tag value (<code>Value</code>). The maximum
        /// length of a tag key is 128 characters. The maximum length of a tag value is 256
        /// characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn auto_config_enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.auto_config_enabled(inp);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_auto_config_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_config_enabled(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn auto_create(mut self, inp: bool) -> Self {
            self.inner = self.inner.auto_create(inp);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_auto_create(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_create(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateComponent`.
    ///
    /// <p>Creates a custom component by grouping similar standalone instances to monitor.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateComponent<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_component_input::Builder,
    }
    impl<C, M, R> CreateComponent<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateComponent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateComponentOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateComponentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateComponentInputOperationOutputAlias,
                crate::output::CreateComponentOutput,
                crate::error::CreateComponentError,
                crate::input::CreateComponentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the resource group.</p>
        pub fn resource_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_group_name(inp);
            self
        }
        /// <p>The name of the resource group.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_group_name(input);
            self
        }
        /// <p>The name of the component.</p>
        pub fn component_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.component_name(inp);
            self
        }
        /// <p>The name of the component.</p>
        pub fn set_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_component_name(input);
            self
        }
        /// Appends an item to `ResourceList`.
        ///
        /// To override the contents of this collection use [`set_resource_list`](Self::set_resource_list).
        ///
        /// <p>The list of resource ARNs that belong to the component.</p>
        pub fn resource_list(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_list(inp);
            self
        }
        /// <p>The list of resource ARNs that belong to the component.</p>
        pub fn set_resource_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLogPattern`.
    ///
    /// <p>Adds an log pattern to a <code>LogPatternSet</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateLogPattern<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_log_pattern_input::Builder,
    }
    impl<C, M, R> CreateLogPattern<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateLogPattern`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLogPatternOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateLogPatternError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateLogPatternInputOperationOutputAlias,
                crate::output::CreateLogPatternOutput,
                crate::error::CreateLogPatternError,
                crate::input::CreateLogPatternInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the resource group.</p>
        pub fn resource_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_group_name(inp);
            self
        }
        /// <p>The name of the resource group.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_group_name(input);
            self
        }
        /// <p>The name of the log pattern set.</p>
        pub fn pattern_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pattern_set_name(inp);
            self
        }
        /// <p>The name of the log pattern set.</p>
        pub fn set_pattern_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pattern_set_name(input);
            self
        }
        /// <p>The name of the log pattern.</p>
        pub fn pattern_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pattern_name(inp);
            self
        }
        /// <p>The name of the log pattern.</p>
        pub fn set_pattern_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_pattern_name(input);
            self
        }
        /// <p>The log pattern. The pattern must be DFA compatible. Patterns that utilize forward lookahead or backreference constructions are not supported.</p>
        pub fn pattern(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pattern(inp);
            self
        }
        /// <p>The log pattern. The pattern must be DFA compatible. Patterns that utilize forward lookahead or backreference constructions are not supported.</p>
        pub fn set_pattern(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_pattern(input);
            self
        }
        /// <p>Rank of the log pattern. Must be a value between <code>1</code> and <code>1,000,000</code>. The patterns are sorted by rank, so we recommend that you set your highest priority patterns with the lowest rank. A pattern of rank <code>1</code> will be the first to get matched to a log line. A pattern of rank <code>1,000,000</code> will be last to get matched. When you configure custom log patterns from the console, a <code>Low</code> severity pattern translates to a <code>750,000</code> rank. A <code>Medium</code> severity pattern translates to a <code>500,000</code> rank. And a <code>High</code> severity pattern translates to a <code>250,000</code> rank.
        /// Rank values less than <code>1</code> or greater than <code>1,000,000</code> are reserved for AWS-provided patterns.
        /// </p>
        pub fn rank(mut self, inp: i32) -> Self {
            self.inner = self.inner.rank(inp);
            self
        }
        /// <p>Rank of the log pattern. Must be a value between <code>1</code> and <code>1,000,000</code>. The patterns are sorted by rank, so we recommend that you set your highest priority patterns with the lowest rank. A pattern of rank <code>1</code> will be the first to get matched to a log line. A pattern of rank <code>1,000,000</code> will be last to get matched. When you configure custom log patterns from the console, a <code>Low</code> severity pattern translates to a <code>750,000</code> rank. A <code>Medium</code> severity pattern translates to a <code>500,000</code> rank. And a <code>High</code> severity pattern translates to a <code>250,000</code> rank.
        /// Rank values less than <code>1</code> or greater than <code>1,000,000</code> are reserved for AWS-provided patterns.
        /// </p>
        pub fn set_rank(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_rank(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteApplication`.
    ///
    /// <p>Removes the specified application from monitoring. Does not delete the application.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteApplication<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_application_input::Builder,
    }
    impl<C, M, R> DeleteApplication<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteApplicationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteApplicationInputOperationOutputAlias,
                crate::output::DeleteApplicationOutput,
                crate::error::DeleteApplicationError,
                crate::input::DeleteApplicationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the resource group.</p>
        pub fn resource_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_group_name(inp);
            self
        }
        /// <p>The name of the resource group.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteComponent`.
    ///
    /// <p>Ungroups a custom component. When you ungroup custom components, all applicable
    /// monitors that are set up for the component are removed and the instances revert to their standalone status.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteComponent<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_component_input::Builder,
    }
    impl<C, M, R> DeleteComponent<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteComponent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteComponentOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteComponentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteComponentInputOperationOutputAlias,
                crate::output::DeleteComponentOutput,
                crate::error::DeleteComponentError,
                crate::input::DeleteComponentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the resource group.</p>
        pub fn resource_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_group_name(inp);
            self
        }
        /// <p>The name of the resource group.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_group_name(input);
            self
        }
        /// <p>The name of the component.</p>
        pub fn component_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.component_name(inp);
            self
        }
        /// <p>The name of the component.</p>
        pub fn set_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_component_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteLogPattern`.
    ///
    /// <p>Removes the specified log pattern from a <code>LogPatternSet</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteLogPattern<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_log_pattern_input::Builder,
    }
    impl<C, M, R> DeleteLogPattern<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteLogPattern`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteLogPatternOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteLogPatternError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteLogPatternInputOperationOutputAlias,
                crate::output::DeleteLogPatternOutput,
                crate::error::DeleteLogPatternError,
                crate::input::DeleteLogPatternInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the resource group.</p>
        pub fn resource_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_group_name(inp);
            self
        }
        /// <p>The name of the resource group.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_group_name(input);
            self
        }
        /// <p>The name of the log pattern set.</p>
        pub fn pattern_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pattern_set_name(inp);
            self
        }
        /// <p>The name of the log pattern set.</p>
        pub fn set_pattern_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pattern_set_name(input);
            self
        }
        /// <p>The name of the log pattern.</p>
        pub fn pattern_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pattern_name(inp);
            self
        }
        /// <p>The name of the log pattern.</p>
        pub fn set_pattern_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_pattern_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeApplication`.
    ///
    /// <p>Describes the application.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeApplication<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_application_input::Builder,
    }
    impl<C, M, R> DescribeApplication<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeApplicationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeApplicationInputOperationOutputAlias,
                crate::output::DescribeApplicationOutput,
                crate::error::DescribeApplicationError,
                crate::input::DescribeApplicationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the resource group.</p>
        pub fn resource_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_group_name(inp);
            self
        }
        /// <p>The name of the resource group.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeComponent`.
    ///
    /// <p>Describes a component and lists the resources that are grouped together in a component.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeComponent<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_component_input::Builder,
    }
    impl<C, M, R> DescribeComponent<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeComponent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeComponentOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeComponentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeComponentInputOperationOutputAlias,
                crate::output::DescribeComponentOutput,
                crate::error::DescribeComponentError,
                crate::input::DescribeComponentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the resource group.</p>
        pub fn resource_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_group_name(inp);
            self
        }
        /// <p>The name of the resource group.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_group_name(input);
            self
        }
        /// <p>The name of the component.</p>
        pub fn component_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.component_name(inp);
            self
        }
        /// <p>The name of the component.</p>
        pub fn set_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_component_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeComponentConfiguration`.
    ///
    /// <p>Describes the monitoring configuration of the component.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeComponentConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_component_configuration_input::Builder,
    }
    impl<C, M, R> DescribeComponentConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeComponentConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeComponentConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeComponentConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeComponentConfigurationInputOperationOutputAlias,
                crate::output::DescribeComponentConfigurationOutput,
                crate::error::DescribeComponentConfigurationError,
                crate::input::DescribeComponentConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the resource group.</p>
        pub fn resource_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_group_name(inp);
            self
        }
        /// <p>The name of the resource group.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_group_name(input);
            self
        }
        /// <p>The name of the component.</p>
        pub fn component_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.component_name(inp);
            self
        }
        /// <p>The name of the component.</p>
        pub fn set_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_component_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeComponentConfigurationRecommendation`.
    ///
    /// <p>Describes the recommended monitoring configuration of the component.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeComponentConfigurationRecommendation<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_component_configuration_recommendation_input::Builder,
    }
    impl<C, M, R> DescribeComponentConfigurationRecommendation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeComponentConfigurationRecommendation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeComponentConfigurationRecommendationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeComponentConfigurationRecommendationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeComponentConfigurationRecommendationInputOperationOutputAlias,
                crate::output::DescribeComponentConfigurationRecommendationOutput,
                crate::error::DescribeComponentConfigurationRecommendationError,
                crate::input::DescribeComponentConfigurationRecommendationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the resource group.</p>
        pub fn resource_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_group_name(inp);
            self
        }
        /// <p>The name of the resource group.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_group_name(input);
            self
        }
        /// <p>The name of the component.</p>
        pub fn component_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.component_name(inp);
            self
        }
        /// <p>The name of the component.</p>
        pub fn set_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_component_name(input);
            self
        }
        /// <p>The tier of the application component. Supported tiers include
        /// <code>DOT_NET_CORE</code>, <code>DOT_NET_WORKER</code>, <code>DOT_NET_WEB</code>, <code>SQL_SERVER</code>,
        /// and <code>DEFAULT</code>.</p>
        pub fn tier(mut self, inp: crate::model::Tier) -> Self {
            self.inner = self.inner.tier(inp);
            self
        }
        /// <p>The tier of the application component. Supported tiers include
        /// <code>DOT_NET_CORE</code>, <code>DOT_NET_WORKER</code>, <code>DOT_NET_WEB</code>, <code>SQL_SERVER</code>,
        /// and <code>DEFAULT</code>.</p>
        pub fn set_tier(mut self, input: std::option::Option<crate::model::Tier>) -> Self {
            self.inner = self.inner.set_tier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeLogPattern`.
    ///
    /// <p>Describe a specific log pattern from a <code>LogPatternSet</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeLogPattern<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_log_pattern_input::Builder,
    }
    impl<C, M, R> DescribeLogPattern<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeLogPattern`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeLogPatternOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeLogPatternError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeLogPatternInputOperationOutputAlias,
                crate::output::DescribeLogPatternOutput,
                crate::error::DescribeLogPatternError,
                crate::input::DescribeLogPatternInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the resource group.</p>
        pub fn resource_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_group_name(inp);
            self
        }
        /// <p>The name of the resource group.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_group_name(input);
            self
        }
        /// <p>The name of the log pattern set.</p>
        pub fn pattern_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pattern_set_name(inp);
            self
        }
        /// <p>The name of the log pattern set.</p>
        pub fn set_pattern_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pattern_set_name(input);
            self
        }
        /// <p>The name of the log pattern.</p>
        pub fn pattern_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pattern_name(inp);
            self
        }
        /// <p>The name of the log pattern.</p>
        pub fn set_pattern_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_pattern_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeObservation`.
    ///
    /// <p>Describes an anomaly or error with the application.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeObservation<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_observation_input::Builder,
    }
    impl<C, M, R> DescribeObservation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeObservation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeObservationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeObservationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeObservationInputOperationOutputAlias,
                crate::output::DescribeObservationOutput,
                crate::error::DescribeObservationError,
                crate::input::DescribeObservationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the observation.</p>
        pub fn observation_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.observation_id(inp);
            self
        }
        /// <p>The ID of the observation.</p>
        pub fn set_observation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_observation_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeProblem`.
    ///
    /// <p>Describes an application problem.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeProblem<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_problem_input::Builder,
    }
    impl<C, M, R> DescribeProblem<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeProblem`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeProblemOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeProblemError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeProblemInputOperationOutputAlias,
                crate::output::DescribeProblemOutput,
                crate::error::DescribeProblemError,
                crate::input::DescribeProblemInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the problem.</p>
        pub fn problem_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.problem_id(inp);
            self
        }
        /// <p>The ID of the problem.</p>
        pub fn set_problem_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_problem_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeProblemObservations`.
    ///
    /// <p>Describes the anomalies or errors associated with the problem.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeProblemObservations<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_problem_observations_input::Builder,
    }
    impl<C, M, R> DescribeProblemObservations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeProblemObservations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeProblemObservationsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeProblemObservationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeProblemObservationsInputOperationOutputAlias,
                crate::output::DescribeProblemObservationsOutput,
                crate::error::DescribeProblemObservationsError,
                crate::input::DescribeProblemObservationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the problem.</p>
        pub fn problem_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.problem_id(inp);
            self
        }
        /// <p>The ID of the problem.</p>
        pub fn set_problem_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_problem_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListApplications`.
    ///
    /// <p>Lists the IDs of the applications that you are monitoring. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListApplications<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_applications_input::Builder,
    }
    impl<C, M, R> ListApplications<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListApplications`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListApplicationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListApplicationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListApplicationsInputOperationOutputAlias,
                crate::output::ListApplicationsOutput,
                crate::error::ListApplicationsError,
                crate::input::ListApplicationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of results to return in a single call. To retrieve the remaining
        /// results, make another call with the returned <code>NextToken</code> value.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in a single call. To retrieve the remaining
        /// results, make another call with the returned <code>NextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListComponents`.
    ///
    /// <p>Lists the auto-grouped, standalone, and custom components of the application.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListComponents<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_components_input::Builder,
    }
    impl<C, M, R> ListComponents<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListComponents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListComponentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListComponentsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListComponentsInputOperationOutputAlias,
                crate::output::ListComponentsOutput,
                crate::error::ListComponentsError,
                crate::input::ListComponentsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the resource group.</p>
        pub fn resource_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_group_name(inp);
            self
        }
        /// <p>The name of the resource group.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_group_name(input);
            self
        }
        /// <p>The maximum number of results to return in a single call. To retrieve the remaining
        /// results, make another call with the returned <code>NextToken</code> value.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in a single call. To retrieve the remaining
        /// results, make another call with the returned <code>NextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListConfigurationHistory`.
    ///
    /// <p>
    /// Lists the INFO, WARN, and ERROR events for periodic configuration updates performed by Application Insights. Examples of events represented are:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>INFO: creating a new alarm or updating an alarm threshold.</p>
    /// </li>
    /// <li>
    /// <p>WARN: alarm not created due to insufficient data points used to predict thresholds.</p>
    /// </li>
    /// <li>
    /// <p>ERROR: alarm not created due to permission errors or exceeding quotas. </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct ListConfigurationHistory<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_configuration_history_input::Builder,
    }
    impl<C, M, R> ListConfigurationHistory<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListConfigurationHistory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListConfigurationHistoryOutput,
            aws_smithy_http::result::SdkError<crate::error::ListConfigurationHistoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListConfigurationHistoryInputOperationOutputAlias,
                crate::output::ListConfigurationHistoryOutput,
                crate::error::ListConfigurationHistoryError,
                crate::input::ListConfigurationHistoryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Resource group to which the application belongs. </p>
        pub fn resource_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_group_name(inp);
            self
        }
        /// <p>Resource group to which the application belongs. </p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_group_name(input);
            self
        }
        /// <p>The start time of the event. </p>
        pub fn start_time(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.start_time(inp);
            self
        }
        /// <p>The start time of the event. </p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>The end time of the event.</p>
        pub fn end_time(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.end_time(inp);
            self
        }
        /// <p>The end time of the event.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>The status of the configuration update event. Possible values include INFO, WARN, and ERROR.</p>
        pub fn event_status(mut self, inp: crate::model::ConfigurationEventStatus) -> Self {
            self.inner = self.inner.event_status(inp);
            self
        }
        /// <p>The status of the configuration update event. Possible values include INFO, WARN, and ERROR.</p>
        pub fn set_event_status(
            mut self,
            input: std::option::Option<crate::model::ConfigurationEventStatus>,
        ) -> Self {
            self.inner = self.inner.set_event_status(input);
            self
        }
        /// <p> The maximum number of results returned by <code>ListConfigurationHistory</code> in
        /// paginated output. When this parameter is used, <code>ListConfigurationHistory</code>
        /// returns only <code>MaxResults</code> in a single page along with a <code>NextToken</code>
        /// response element. The remaining results of the initial request can be seen by sending
        /// another <code>ListConfigurationHistory</code> request with the returned
        /// <code>NextToken</code> value. If this parameter is not used, then
        /// <code>ListConfigurationHistory</code> returns all results. </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p> The maximum number of results returned by <code>ListConfigurationHistory</code> in
        /// paginated output. When this parameter is used, <code>ListConfigurationHistory</code>
        /// returns only <code>MaxResults</code> in a single page along with a <code>NextToken</code>
        /// response element. The remaining results of the initial request can be seen by sending
        /// another <code>ListConfigurationHistory</code> request with the returned
        /// <code>NextToken</code> value. If this parameter is not used, then
        /// <code>ListConfigurationHistory</code> returns all results. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The <code>NextToken</code> value returned from a previous paginated <code>ListConfigurationHistory</code> request where
        /// <code>MaxResults</code> was used and the results exceeded the value of that parameter. Pagination
        /// continues from the end of the previous results that returned the <code>NextToken</code> value. This
        /// value is <code>null</code> when there are no more results to return.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The <code>NextToken</code> value returned from a previous paginated <code>ListConfigurationHistory</code> request where
        /// <code>MaxResults</code> was used and the results exceeded the value of that parameter. Pagination
        /// continues from the end of the previous results that returned the <code>NextToken</code> value. This
        /// value is <code>null</code> when there are no more results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLogPatterns`.
    ///
    /// <p>Lists the log patterns in the specific log <code>LogPatternSet</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListLogPatterns<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_log_patterns_input::Builder,
    }
    impl<C, M, R> ListLogPatterns<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListLogPatterns`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLogPatternsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListLogPatternsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListLogPatternsInputOperationOutputAlias,
                crate::output::ListLogPatternsOutput,
                crate::error::ListLogPatternsError,
                crate::input::ListLogPatternsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the resource group.</p>
        pub fn resource_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_group_name(inp);
            self
        }
        /// <p>The name of the resource group.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_group_name(input);
            self
        }
        /// <p>The name of the log pattern set.</p>
        pub fn pattern_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pattern_set_name(inp);
            self
        }
        /// <p>The name of the log pattern set.</p>
        pub fn set_pattern_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pattern_set_name(input);
            self
        }
        /// <p>The maximum number of results to return in a single call. To retrieve the remaining
        /// results, make another call with the returned <code>NextToken</code> value.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in a single call. To retrieve the remaining
        /// results, make another call with the returned <code>NextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLogPatternSets`.
    ///
    /// <p>Lists the log pattern sets in the specific application.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListLogPatternSets<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_log_pattern_sets_input::Builder,
    }
    impl<C, M, R> ListLogPatternSets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListLogPatternSets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLogPatternSetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListLogPatternSetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListLogPatternSetsInputOperationOutputAlias,
                crate::output::ListLogPatternSetsOutput,
                crate::error::ListLogPatternSetsError,
                crate::input::ListLogPatternSetsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the resource group.</p>
        pub fn resource_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_group_name(inp);
            self
        }
        /// <p>The name of the resource group.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_group_name(input);
            self
        }
        /// <p>The maximum number of results to return in a single call. To retrieve the remaining
        /// results, make another call with the returned <code>NextToken</code> value.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in a single call. To retrieve the remaining
        /// results, make another call with the returned <code>NextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListProblems`.
    ///
    /// <p>Lists the problems with your application.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListProblems<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_problems_input::Builder,
    }
    impl<C, M, R> ListProblems<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListProblems`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListProblemsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListProblemsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListProblemsInputOperationOutputAlias,
                crate::output::ListProblemsOutput,
                crate::error::ListProblemsError,
                crate::input::ListProblemsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the resource group.</p>
        pub fn resource_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_group_name(inp);
            self
        }
        /// <p>The name of the resource group.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_group_name(input);
            self
        }
        /// <p>The time when the problem was detected, in epoch
        /// seconds. If you don't specify a time frame for the request, problems within the past seven days are returned.</p>
        pub fn start_time(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.start_time(inp);
            self
        }
        /// <p>The time when the problem was detected, in epoch
        /// seconds. If you don't specify a time frame for the request, problems within the past seven days are returned.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>The time when the problem ended, in epoch seconds. If not specified, problems within the
        /// past seven days are returned.</p>
        pub fn end_time(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.end_time(inp);
            self
        }
        /// <p>The time when the problem ended, in epoch seconds. If not specified, problems within the
        /// past seven days are returned.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>The maximum number of results to return in a single call. To retrieve the remaining
        /// results, make another call with the returned <code>NextToken</code> value.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in a single call. To retrieve the remaining
        /// results, make another call with the returned <code>NextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn component_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.component_name(inp);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_component_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Retrieve a list of the tags (keys and values) that are associated with a specified
    /// application. A <i>tag</i> is a label that you optionally define and associate
    /// with an application. Each tag consists of a required <i>tag key</i> and an
    /// optional associated <i>tag value</i>. A tag key is a general label that
    /// acts as a category for more specific tag values. A tag value acts as a descriptor within
    /// a tag key.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the application that you want to retrieve tag
        /// information for.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application that you want to retrieve tag
        /// information for.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Add one or more tags (keys and values) to a specified application. A
    /// <i>tag</i> is a label that you optionally define and associate with an
    /// application. Tags can help you categorize and manage application in different ways, such as
    /// by purpose, owner, environment, or other criteria. </p>
    /// <p>Each tag consists of a required <i>tag key</i> and an
    /// associated <i>tag value</i>, both of which you define. A tag key is a
    /// general label that acts as a category for more specific tag values. A tag value acts as
    /// a descriptor within a tag key.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the application that you want to add one or more tags to.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application that you want to add one or more tags to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags that to add to the application. A tag consists of a required
        /// tag key (<code>Key</code>) and an associated tag value (<code>Value</code>). The maximum
        /// length of a tag key is 128 characters. The maximum length of a tag value is 256
        /// characters.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of tags that to add to the application. A tag consists of a required
        /// tag key (<code>Key</code>) and an associated tag value (<code>Value</code>). The maximum
        /// length of a tag key is 128 characters. The maximum length of a tag value is 256
        /// characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Remove one or more tags (keys and values) from a specified application.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the application that you want to remove one or more tags from.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application that you want to remove one or more tags from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tags (tag keys) that you want to remove from the resource. When you specify a tag
        /// key, the action removes both that key and its associated tag value.</p>
        /// <p>To remove more than one tag from the application, append the <code>TagKeys</code>
        /// parameter and argument for each additional tag to remove, separated by an ampersand.
        /// </p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The tags (tag keys) that you want to remove from the resource. When you specify a tag
        /// key, the action removes both that key and its associated tag value.</p>
        /// <p>To remove more than one tag from the application, append the <code>TagKeys</code>
        /// parameter and argument for each additional tag to remove, separated by an ampersand.
        /// </p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateApplication`.
    ///
    /// <p>Updates the application.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateApplication<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_application_input::Builder,
    }
    impl<C, M, R> UpdateApplication<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateApplicationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateApplicationInputOperationOutputAlias,
                crate::output::UpdateApplicationOutput,
                crate::error::UpdateApplicationError,
                crate::input::UpdateApplicationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the resource group.</p>
        pub fn resource_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_group_name(inp);
            self
        }
        /// <p>The name of the resource group.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_group_name(input);
            self
        }
        /// <p>
        /// When set to <code>true</code>, creates opsItems for any problems detected on an application.
        /// </p>
        pub fn ops_center_enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.ops_center_enabled(inp);
            self
        }
        /// <p>
        /// When set to <code>true</code>, creates opsItems for any problems detected on an application.
        /// </p>
        pub fn set_ops_center_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_ops_center_enabled(input);
            self
        }
        /// <p>
        /// Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as <code>instance terminated</code>, <code>failed deployment</code>, and others.
        /// </p>
        pub fn cwe_monitor_enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.cwe_monitor_enabled(inp);
            self
        }
        /// <p>
        /// Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as <code>instance terminated</code>, <code>failed deployment</code>, and others.
        /// </p>
        pub fn set_cwe_monitor_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_cwe_monitor_enabled(input);
            self
        }
        /// <p>
        /// The SNS topic provided to Application Insights that is associated to the created opsItem. Allows you to
        /// receive notifications for updates to the opsItem.</p>
        pub fn ops_item_sns_topic_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ops_item_sns_topic_arn(inp);
            self
        }
        /// <p>
        /// The SNS topic provided to Application Insights that is associated to the created opsItem. Allows you to
        /// receive notifications for updates to the opsItem.</p>
        pub fn set_ops_item_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ops_item_sns_topic_arn(input);
            self
        }
        /// <p>
        /// Disassociates the SNS topic from the opsItem created for detected problems.</p>
        pub fn remove_sns_topic(mut self, inp: bool) -> Self {
            self.inner = self.inner.remove_sns_topic(inp);
            self
        }
        /// <p>
        /// Disassociates the SNS topic from the opsItem created for detected problems.</p>
        pub fn set_remove_sns_topic(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_remove_sns_topic(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn auto_config_enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.auto_config_enabled(inp);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_auto_config_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_config_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateComponent`.
    ///
    /// <p>Updates the custom component name and/or the list of resources that make up the
    /// component.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateComponent<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_component_input::Builder,
    }
    impl<C, M, R> UpdateComponent<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateComponent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateComponentOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateComponentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateComponentInputOperationOutputAlias,
                crate::output::UpdateComponentOutput,
                crate::error::UpdateComponentError,
                crate::input::UpdateComponentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the resource group.</p>
        pub fn resource_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_group_name(inp);
            self
        }
        /// <p>The name of the resource group.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_group_name(input);
            self
        }
        /// <p>The name of the component.</p>
        pub fn component_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.component_name(inp);
            self
        }
        /// <p>The name of the component.</p>
        pub fn set_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_component_name(input);
            self
        }
        /// <p>The new name of the component.</p>
        pub fn new_component_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.new_component_name(inp);
            self
        }
        /// <p>The new name of the component.</p>
        pub fn set_new_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_new_component_name(input);
            self
        }
        /// Appends an item to `ResourceList`.
        ///
        /// To override the contents of this collection use [`set_resource_list`](Self::set_resource_list).
        ///
        /// <p>The list of resource ARNs that belong to the component.</p>
        pub fn resource_list(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_list(inp);
            self
        }
        /// <p>The list of resource ARNs that belong to the component.</p>
        pub fn set_resource_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateComponentConfiguration`.
    ///
    /// <p>Updates the monitoring configurations for the component. The configuration input parameter
    /// is an escaped JSON of the configuration and should match the schema of what is returned
    /// by <code>DescribeComponentConfigurationRecommendation</code>. </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateComponentConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_component_configuration_input::Builder,
    }
    impl<C, M, R> UpdateComponentConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateComponentConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateComponentConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateComponentConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateComponentConfigurationInputOperationOutputAlias,
                crate::output::UpdateComponentConfigurationOutput,
                crate::error::UpdateComponentConfigurationError,
                crate::input::UpdateComponentConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the resource group.</p>
        pub fn resource_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_group_name(inp);
            self
        }
        /// <p>The name of the resource group.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_group_name(input);
            self
        }
        /// <p>The name of the component.</p>
        pub fn component_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.component_name(inp);
            self
        }
        /// <p>The name of the component.</p>
        pub fn set_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_component_name(input);
            self
        }
        /// <p>Indicates whether the application component is monitored.</p>
        pub fn monitor(mut self, inp: bool) -> Self {
            self.inner = self.inner.monitor(inp);
            self
        }
        /// <p>Indicates whether the application component is monitored.</p>
        pub fn set_monitor(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_monitor(input);
            self
        }
        /// <p>The tier of the application component. Supported tiers include <code>DOT_NET_WORKER</code>,
        /// <code>DOT_NET_WEB</code>, <code>DOT_NET_CORE</code>, <code>SQL_SERVER</code>, and <code>DEFAULT</code>.</p>
        pub fn tier(mut self, inp: crate::model::Tier) -> Self {
            self.inner = self.inner.tier(inp);
            self
        }
        /// <p>The tier of the application component. Supported tiers include <code>DOT_NET_WORKER</code>,
        /// <code>DOT_NET_WEB</code>, <code>DOT_NET_CORE</code>, <code>SQL_SERVER</code>, and <code>DEFAULT</code>.</p>
        pub fn set_tier(mut self, input: std::option::Option<crate::model::Tier>) -> Self {
            self.inner = self.inner.set_tier(input);
            self
        }
        /// <p>The configuration settings of the component. The value is the escaped JSON of the configuration. For
        /// more information about the JSON format, see <a href="https://docs.aws.amazon.com/sdk-for-javascript/v2/developer-guide/working-with-json.html">Working with JSON</a>.
        /// You can send a request to <code>DescribeComponentConfigurationRecommendation</code> to see the recommended configuration for a component. For the complete
        /// format of the component configuration file, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/component-config.html">Component Configuration</a>.</p>
        pub fn component_configuration(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.component_configuration(inp);
            self
        }
        /// <p>The configuration settings of the component. The value is the escaped JSON of the configuration. For
        /// more information about the JSON format, see <a href="https://docs.aws.amazon.com/sdk-for-javascript/v2/developer-guide/working-with-json.html">Working with JSON</a>.
        /// You can send a request to <code>DescribeComponentConfigurationRecommendation</code> to see the recommended configuration for a component. For the complete
        /// format of the component configuration file, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/component-config.html">Component Configuration</a>.</p>
        pub fn set_component_configuration(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_component_configuration(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn auto_config_enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.auto_config_enabled(inp);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_auto_config_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_config_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateLogPattern`.
    ///
    /// <p>Adds a log pattern to a <code>LogPatternSet</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateLogPattern<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_log_pattern_input::Builder,
    }
    impl<C, M, R> UpdateLogPattern<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateLogPattern`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateLogPatternOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateLogPatternError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateLogPatternInputOperationOutputAlias,
                crate::output::UpdateLogPatternOutput,
                crate::error::UpdateLogPatternError,
                crate::input::UpdateLogPatternInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the resource group.</p>
        pub fn resource_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_group_name(inp);
            self
        }
        /// <p>The name of the resource group.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_group_name(input);
            self
        }
        /// <p>The name of the log pattern set.</p>
        pub fn pattern_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pattern_set_name(inp);
            self
        }
        /// <p>The name of the log pattern set.</p>
        pub fn set_pattern_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pattern_set_name(input);
            self
        }
        /// <p>The name of the log pattern.</p>
        pub fn pattern_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pattern_name(inp);
            self
        }
        /// <p>The name of the log pattern.</p>
        pub fn set_pattern_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_pattern_name(input);
            self
        }
        /// <p>The log pattern. The pattern must be DFA compatible. Patterns that utilize forward lookahead or backreference constructions are not supported.</p>
        pub fn pattern(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pattern(inp);
            self
        }
        /// <p>The log pattern. The pattern must be DFA compatible. Patterns that utilize forward lookahead or backreference constructions are not supported.</p>
        pub fn set_pattern(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_pattern(input);
            self
        }
        /// <p>Rank of the log pattern. Must be a value between <code>1</code> and <code>1,000,000</code>. The patterns are sorted by rank, so we recommend that you set your highest priority patterns with the lowest rank. A pattern of rank <code>1</code> will be the first to get matched to a log line. A pattern of rank <code>1,000,000</code> will be last to get matched. When you configure custom log patterns from the console, a <code>Low</code> severity pattern translates to a <code>750,000</code> rank. A <code>Medium</code> severity pattern translates to a <code>500,000</code> rank. And a <code>High</code> severity pattern translates to a <code>250,000</code> rank.
        /// Rank values less than <code>1</code> or greater than <code>1,000,000</code> are reserved for AWS-provided patterns.
        /// </p>
        pub fn rank(mut self, inp: i32) -> Self {
            self.inner = self.inner.rank(inp);
            self
        }
        /// <p>Rank of the log pattern. Must be a value between <code>1</code> and <code>1,000,000</code>. The patterns are sorted by rank, so we recommend that you set your highest priority patterns with the lowest rank. A pattern of rank <code>1</code> will be the first to get matched to a log line. A pattern of rank <code>1,000,000</code> will be last to get matched. When you configure custom log patterns from the console, a <code>Low</code> severity pattern translates to a <code>750,000</code> rank. A <code>Medium</code> severity pattern translates to a <code>500,000</code> rank. And a <code>High</code> severity pattern translates to a <code>250,000</code> rank.
        /// Rank values less than <code>1</code> or greater than <code>1,000,000</code> are reserved for AWS-provided patterns.
        /// </p>
        pub fn set_rank(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_rank(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
