// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateLogPatternOutput {
    /// <p>The name of the resource group.</p>
    pub resource_group_name: std::option::Option<std::string::String>,
    /// <p>The successfully created log pattern.</p>
    pub log_pattern: std::option::Option<crate::model::LogPattern>,
}
impl std::fmt::Debug for UpdateLogPatternOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateLogPatternOutput");
        formatter.field("resource_group_name", &self.resource_group_name);
        formatter.field("log_pattern", &self.log_pattern);
        formatter.finish()
    }
}
/// See [`UpdateLogPatternOutput`](crate::output::UpdateLogPatternOutput)
pub mod update_log_pattern_output {
    /// A builder for [`UpdateLogPatternOutput`](crate::output::UpdateLogPatternOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_group_name: std::option::Option<std::string::String>,
        pub(crate) log_pattern: std::option::Option<crate::model::LogPattern>,
    }
    impl Builder {
        /// <p>The name of the resource group.</p>
        pub fn resource_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_group_name = Some(input.into());
            self
        }
        /// <p>The name of the resource group.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_group_name = input;
            self
        }
        /// <p>The successfully created log pattern.</p>
        pub fn log_pattern(mut self, input: crate::model::LogPattern) -> Self {
            self.log_pattern = Some(input);
            self
        }
        /// <p>The successfully created log pattern.</p>
        pub fn set_log_pattern(
            mut self,
            input: std::option::Option<crate::model::LogPattern>,
        ) -> Self {
            self.log_pattern = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateLogPatternOutput`](crate::output::UpdateLogPatternOutput)
        pub fn build(self) -> crate::output::UpdateLogPatternOutput {
            crate::output::UpdateLogPatternOutput {
                resource_group_name: self.resource_group_name,
                log_pattern: self.log_pattern,
            }
        }
    }
}
impl UpdateLogPatternOutput {
    /// Creates a new builder-style object to manufacture [`UpdateLogPatternOutput`](crate::output::UpdateLogPatternOutput)
    pub fn builder() -> crate::output::update_log_pattern_output::Builder {
        crate::output::update_log_pattern_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateComponentConfigurationOutput {}
impl std::fmt::Debug for UpdateComponentConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateComponentConfigurationOutput");
        formatter.finish()
    }
}
/// See [`UpdateComponentConfigurationOutput`](crate::output::UpdateComponentConfigurationOutput)
pub mod update_component_configuration_output {
    /// A builder for [`UpdateComponentConfigurationOutput`](crate::output::UpdateComponentConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateComponentConfigurationOutput`](crate::output::UpdateComponentConfigurationOutput)
        pub fn build(self) -> crate::output::UpdateComponentConfigurationOutput {
            crate::output::UpdateComponentConfigurationOutput {}
        }
    }
}
impl UpdateComponentConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`UpdateComponentConfigurationOutput`](crate::output::UpdateComponentConfigurationOutput)
    pub fn builder() -> crate::output::update_component_configuration_output::Builder {
        crate::output::update_component_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateComponentOutput {}
impl std::fmt::Debug for UpdateComponentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateComponentOutput");
        formatter.finish()
    }
}
/// See [`UpdateComponentOutput`](crate::output::UpdateComponentOutput)
pub mod update_component_output {
    /// A builder for [`UpdateComponentOutput`](crate::output::UpdateComponentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateComponentOutput`](crate::output::UpdateComponentOutput)
        pub fn build(self) -> crate::output::UpdateComponentOutput {
            crate::output::UpdateComponentOutput {}
        }
    }
}
impl UpdateComponentOutput {
    /// Creates a new builder-style object to manufacture [`UpdateComponentOutput`](crate::output::UpdateComponentOutput)
    pub fn builder() -> crate::output::update_component_output::Builder {
        crate::output::update_component_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateApplicationOutput {
    /// <p>Information about the application. </p>
    pub application_info: std::option::Option<crate::model::ApplicationInfo>,
}
impl std::fmt::Debug for UpdateApplicationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateApplicationOutput");
        formatter.field("application_info", &self.application_info);
        formatter.finish()
    }
}
/// See [`UpdateApplicationOutput`](crate::output::UpdateApplicationOutput)
pub mod update_application_output {
    /// A builder for [`UpdateApplicationOutput`](crate::output::UpdateApplicationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_info: std::option::Option<crate::model::ApplicationInfo>,
    }
    impl Builder {
        /// <p>Information about the application. </p>
        pub fn application_info(mut self, input: crate::model::ApplicationInfo) -> Self {
            self.application_info = Some(input);
            self
        }
        /// <p>Information about the application. </p>
        pub fn set_application_info(
            mut self,
            input: std::option::Option<crate::model::ApplicationInfo>,
        ) -> Self {
            self.application_info = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateApplicationOutput`](crate::output::UpdateApplicationOutput)
        pub fn build(self) -> crate::output::UpdateApplicationOutput {
            crate::output::UpdateApplicationOutput {
                application_info: self.application_info,
            }
        }
    }
}
impl UpdateApplicationOutput {
    /// Creates a new builder-style object to manufacture [`UpdateApplicationOutput`](crate::output::UpdateApplicationOutput)
    pub fn builder() -> crate::output::update_application_output::Builder {
        crate::output::update_application_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>An array that lists all the tags that are associated with the application. Each tag
    /// consists of a required tag key (<code>Key</code>) and an associated tag value
    /// (<code>Value</code>).</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array that lists all the tags that are associated with the application. Each tag
        /// consists of a required tag key (<code>Key</code>) and an associated tag value
        /// (<code>Value</code>).</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>An array that lists all the tags that are associated with the application. Each tag
        /// consists of a required tag key (<code>Key</code>) and an associated tag value
        /// (<code>Value</code>).</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListProblemsOutput {
    /// <p>The list of problems. </p>
    pub problem_list: std::option::Option<std::vec::Vec<crate::model::Problem>>,
    /// <p>The token used to retrieve the next page of results. This value is <code>null</code>
    /// when there are no more results to return. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListProblemsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListProblemsOutput");
        formatter.field("problem_list", &self.problem_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListProblemsOutput`](crate::output::ListProblemsOutput)
pub mod list_problems_output {
    /// A builder for [`ListProblemsOutput`](crate::output::ListProblemsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) problem_list: std::option::Option<std::vec::Vec<crate::model::Problem>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `problem_list`.
        ///
        /// To override the contents of this collection use [`set_problem_list`](Self::set_problem_list).
        ///
        /// <p>The list of problems. </p>
        pub fn problem_list(mut self, input: impl Into<crate::model::Problem>) -> Self {
            let mut v = self.problem_list.unwrap_or_default();
            v.push(input.into());
            self.problem_list = Some(v);
            self
        }
        /// <p>The list of problems. </p>
        pub fn set_problem_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Problem>>,
        ) -> Self {
            self.problem_list = input;
            self
        }
        /// <p>The token used to retrieve the next page of results. This value is <code>null</code>
        /// when there are no more results to return. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token used to retrieve the next page of results. This value is <code>null</code>
        /// when there are no more results to return. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListProblemsOutput`](crate::output::ListProblemsOutput)
        pub fn build(self) -> crate::output::ListProblemsOutput {
            crate::output::ListProblemsOutput {
                problem_list: self.problem_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListProblemsOutput {
    /// Creates a new builder-style object to manufacture [`ListProblemsOutput`](crate::output::ListProblemsOutput)
    pub fn builder() -> crate::output::list_problems_output::Builder {
        crate::output::list_problems_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListLogPatternSetsOutput {
    /// <p>The name of the resource group.</p>
    pub resource_group_name: std::option::Option<std::string::String>,
    /// <p>The list of log pattern sets.</p>
    pub log_pattern_sets: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The token used to retrieve the next page of results. This value is <code>null</code>
    /// when there are no more results to return. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListLogPatternSetsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListLogPatternSetsOutput");
        formatter.field("resource_group_name", &self.resource_group_name);
        formatter.field("log_pattern_sets", &self.log_pattern_sets);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListLogPatternSetsOutput`](crate::output::ListLogPatternSetsOutput)
pub mod list_log_pattern_sets_output {
    /// A builder for [`ListLogPatternSetsOutput`](crate::output::ListLogPatternSetsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_group_name: std::option::Option<std::string::String>,
        pub(crate) log_pattern_sets: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the resource group.</p>
        pub fn resource_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_group_name = Some(input.into());
            self
        }
        /// <p>The name of the resource group.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_group_name = input;
            self
        }
        /// Appends an item to `log_pattern_sets`.
        ///
        /// To override the contents of this collection use [`set_log_pattern_sets`](Self::set_log_pattern_sets).
        ///
        /// <p>The list of log pattern sets.</p>
        pub fn log_pattern_sets(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.log_pattern_sets.unwrap_or_default();
            v.push(input.into());
            self.log_pattern_sets = Some(v);
            self
        }
        /// <p>The list of log pattern sets.</p>
        pub fn set_log_pattern_sets(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.log_pattern_sets = input;
            self
        }
        /// <p>The token used to retrieve the next page of results. This value is <code>null</code>
        /// when there are no more results to return. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token used to retrieve the next page of results. This value is <code>null</code>
        /// when there are no more results to return. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListLogPatternSetsOutput`](crate::output::ListLogPatternSetsOutput)
        pub fn build(self) -> crate::output::ListLogPatternSetsOutput {
            crate::output::ListLogPatternSetsOutput {
                resource_group_name: self.resource_group_name,
                log_pattern_sets: self.log_pattern_sets,
                next_token: self.next_token,
            }
        }
    }
}
impl ListLogPatternSetsOutput {
    /// Creates a new builder-style object to manufacture [`ListLogPatternSetsOutput`](crate::output::ListLogPatternSetsOutput)
    pub fn builder() -> crate::output::list_log_pattern_sets_output::Builder {
        crate::output::list_log_pattern_sets_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListLogPatternsOutput {
    /// <p>The name of the resource group.</p>
    pub resource_group_name: std::option::Option<std::string::String>,
    /// <p>The list of log patterns.</p>
    pub log_patterns: std::option::Option<std::vec::Vec<crate::model::LogPattern>>,
    /// <p>The token used to retrieve the next page of results. This value is <code>null</code>
    /// when there are no more results to return. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListLogPatternsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListLogPatternsOutput");
        formatter.field("resource_group_name", &self.resource_group_name);
        formatter.field("log_patterns", &self.log_patterns);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListLogPatternsOutput`](crate::output::ListLogPatternsOutput)
pub mod list_log_patterns_output {
    /// A builder for [`ListLogPatternsOutput`](crate::output::ListLogPatternsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_group_name: std::option::Option<std::string::String>,
        pub(crate) log_patterns: std::option::Option<std::vec::Vec<crate::model::LogPattern>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the resource group.</p>
        pub fn resource_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_group_name = Some(input.into());
            self
        }
        /// <p>The name of the resource group.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_group_name = input;
            self
        }
        /// Appends an item to `log_patterns`.
        ///
        /// To override the contents of this collection use [`set_log_patterns`](Self::set_log_patterns).
        ///
        /// <p>The list of log patterns.</p>
        pub fn log_patterns(mut self, input: impl Into<crate::model::LogPattern>) -> Self {
            let mut v = self.log_patterns.unwrap_or_default();
            v.push(input.into());
            self.log_patterns = Some(v);
            self
        }
        /// <p>The list of log patterns.</p>
        pub fn set_log_patterns(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LogPattern>>,
        ) -> Self {
            self.log_patterns = input;
            self
        }
        /// <p>The token used to retrieve the next page of results. This value is <code>null</code>
        /// when there are no more results to return. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token used to retrieve the next page of results. This value is <code>null</code>
        /// when there are no more results to return. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListLogPatternsOutput`](crate::output::ListLogPatternsOutput)
        pub fn build(self) -> crate::output::ListLogPatternsOutput {
            crate::output::ListLogPatternsOutput {
                resource_group_name: self.resource_group_name,
                log_patterns: self.log_patterns,
                next_token: self.next_token,
            }
        }
    }
}
impl ListLogPatternsOutput {
    /// Creates a new builder-style object to manufacture [`ListLogPatternsOutput`](crate::output::ListLogPatternsOutput)
    pub fn builder() -> crate::output::list_log_patterns_output::Builder {
        crate::output::list_log_patterns_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListConfigurationHistoryOutput {
    /// <p> The list of configuration events and their corresponding details. </p>
    pub event_list: std::option::Option<std::vec::Vec<crate::model::ConfigurationEvent>>,
    /// <p>The <code>NextToken</code> value to include in a future
    /// <code>ListConfigurationHistory</code> request. When the results of a
    /// <code>ListConfigurationHistory</code> request exceed <code>MaxResults</code>, this value
    /// can be used to retrieve the next page of results. This value is <code>null</code> when
    /// there are no more results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListConfigurationHistoryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListConfigurationHistoryOutput");
        formatter.field("event_list", &self.event_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListConfigurationHistoryOutput`](crate::output::ListConfigurationHistoryOutput)
pub mod list_configuration_history_output {
    /// A builder for [`ListConfigurationHistoryOutput`](crate::output::ListConfigurationHistoryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_list: std::option::Option<std::vec::Vec<crate::model::ConfigurationEvent>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `event_list`.
        ///
        /// To override the contents of this collection use [`set_event_list`](Self::set_event_list).
        ///
        /// <p> The list of configuration events and their corresponding details. </p>
        pub fn event_list(mut self, input: impl Into<crate::model::ConfigurationEvent>) -> Self {
            let mut v = self.event_list.unwrap_or_default();
            v.push(input.into());
            self.event_list = Some(v);
            self
        }
        /// <p> The list of configuration events and their corresponding details. </p>
        pub fn set_event_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConfigurationEvent>>,
        ) -> Self {
            self.event_list = input;
            self
        }
        /// <p>The <code>NextToken</code> value to include in a future
        /// <code>ListConfigurationHistory</code> request. When the results of a
        /// <code>ListConfigurationHistory</code> request exceed <code>MaxResults</code>, this value
        /// can be used to retrieve the next page of results. This value is <code>null</code> when
        /// there are no more results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>NextToken</code> value to include in a future
        /// <code>ListConfigurationHistory</code> request. When the results of a
        /// <code>ListConfigurationHistory</code> request exceed <code>MaxResults</code>, this value
        /// can be used to retrieve the next page of results. This value is <code>null</code> when
        /// there are no more results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListConfigurationHistoryOutput`](crate::output::ListConfigurationHistoryOutput)
        pub fn build(self) -> crate::output::ListConfigurationHistoryOutput {
            crate::output::ListConfigurationHistoryOutput {
                event_list: self.event_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListConfigurationHistoryOutput {
    /// Creates a new builder-style object to manufacture [`ListConfigurationHistoryOutput`](crate::output::ListConfigurationHistoryOutput)
    pub fn builder() -> crate::output::list_configuration_history_output::Builder {
        crate::output::list_configuration_history_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListComponentsOutput {
    /// <p>The list of application components.</p>
    pub application_component_list:
        std::option::Option<std::vec::Vec<crate::model::ApplicationComponent>>,
    /// <p>The token to request the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListComponentsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListComponentsOutput");
        formatter.field(
            "application_component_list",
            &self.application_component_list,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListComponentsOutput`](crate::output::ListComponentsOutput)
pub mod list_components_output {
    /// A builder for [`ListComponentsOutput`](crate::output::ListComponentsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_component_list:
            std::option::Option<std::vec::Vec<crate::model::ApplicationComponent>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `application_component_list`.
        ///
        /// To override the contents of this collection use [`set_application_component_list`](Self::set_application_component_list).
        ///
        /// <p>The list of application components.</p>
        pub fn application_component_list(
            mut self,
            input: impl Into<crate::model::ApplicationComponent>,
        ) -> Self {
            let mut v = self.application_component_list.unwrap_or_default();
            v.push(input.into());
            self.application_component_list = Some(v);
            self
        }
        /// <p>The list of application components.</p>
        pub fn set_application_component_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ApplicationComponent>>,
        ) -> Self {
            self.application_component_list = input;
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListComponentsOutput`](crate::output::ListComponentsOutput)
        pub fn build(self) -> crate::output::ListComponentsOutput {
            crate::output::ListComponentsOutput {
                application_component_list: self.application_component_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListComponentsOutput {
    /// Creates a new builder-style object to manufacture [`ListComponentsOutput`](crate::output::ListComponentsOutput)
    pub fn builder() -> crate::output::list_components_output::Builder {
        crate::output::list_components_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListApplicationsOutput {
    /// <p>The list of applications.</p>
    pub application_info_list: std::option::Option<std::vec::Vec<crate::model::ApplicationInfo>>,
    /// <p>The token used to retrieve the next page of results. This value is <code>null</code>
    /// when there are no more results to return. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListApplicationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListApplicationsOutput");
        formatter.field("application_info_list", &self.application_info_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListApplicationsOutput`](crate::output::ListApplicationsOutput)
pub mod list_applications_output {
    /// A builder for [`ListApplicationsOutput`](crate::output::ListApplicationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_info_list:
            std::option::Option<std::vec::Vec<crate::model::ApplicationInfo>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `application_info_list`.
        ///
        /// To override the contents of this collection use [`set_application_info_list`](Self::set_application_info_list).
        ///
        /// <p>The list of applications.</p>
        pub fn application_info_list(
            mut self,
            input: impl Into<crate::model::ApplicationInfo>,
        ) -> Self {
            let mut v = self.application_info_list.unwrap_or_default();
            v.push(input.into());
            self.application_info_list = Some(v);
            self
        }
        /// <p>The list of applications.</p>
        pub fn set_application_info_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ApplicationInfo>>,
        ) -> Self {
            self.application_info_list = input;
            self
        }
        /// <p>The token used to retrieve the next page of results. This value is <code>null</code>
        /// when there are no more results to return. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token used to retrieve the next page of results. This value is <code>null</code>
        /// when there are no more results to return. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListApplicationsOutput`](crate::output::ListApplicationsOutput)
        pub fn build(self) -> crate::output::ListApplicationsOutput {
            crate::output::ListApplicationsOutput {
                application_info_list: self.application_info_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListApplicationsOutput {
    /// Creates a new builder-style object to manufacture [`ListApplicationsOutput`](crate::output::ListApplicationsOutput)
    pub fn builder() -> crate::output::list_applications_output::Builder {
        crate::output::list_applications_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeProblemObservationsOutput {
    /// <p>Observations related to the problem.</p>
    pub related_observations: std::option::Option<crate::model::RelatedObservations>,
}
impl std::fmt::Debug for DescribeProblemObservationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeProblemObservationsOutput");
        formatter.field("related_observations", &self.related_observations);
        formatter.finish()
    }
}
/// See [`DescribeProblemObservationsOutput`](crate::output::DescribeProblemObservationsOutput)
pub mod describe_problem_observations_output {
    /// A builder for [`DescribeProblemObservationsOutput`](crate::output::DescribeProblemObservationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) related_observations: std::option::Option<crate::model::RelatedObservations>,
    }
    impl Builder {
        /// <p>Observations related to the problem.</p>
        pub fn related_observations(mut self, input: crate::model::RelatedObservations) -> Self {
            self.related_observations = Some(input);
            self
        }
        /// <p>Observations related to the problem.</p>
        pub fn set_related_observations(
            mut self,
            input: std::option::Option<crate::model::RelatedObservations>,
        ) -> Self {
            self.related_observations = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeProblemObservationsOutput`](crate::output::DescribeProblemObservationsOutput)
        pub fn build(self) -> crate::output::DescribeProblemObservationsOutput {
            crate::output::DescribeProblemObservationsOutput {
                related_observations: self.related_observations,
            }
        }
    }
}
impl DescribeProblemObservationsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeProblemObservationsOutput`](crate::output::DescribeProblemObservationsOutput)
    pub fn builder() -> crate::output::describe_problem_observations_output::Builder {
        crate::output::describe_problem_observations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeProblemOutput {
    /// <p>Information about the problem. </p>
    pub problem: std::option::Option<crate::model::Problem>,
}
impl std::fmt::Debug for DescribeProblemOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeProblemOutput");
        formatter.field("problem", &self.problem);
        formatter.finish()
    }
}
/// See [`DescribeProblemOutput`](crate::output::DescribeProblemOutput)
pub mod describe_problem_output {
    /// A builder for [`DescribeProblemOutput`](crate::output::DescribeProblemOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) problem: std::option::Option<crate::model::Problem>,
    }
    impl Builder {
        /// <p>Information about the problem. </p>
        pub fn problem(mut self, input: crate::model::Problem) -> Self {
            self.problem = Some(input);
            self
        }
        /// <p>Information about the problem. </p>
        pub fn set_problem(mut self, input: std::option::Option<crate::model::Problem>) -> Self {
            self.problem = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeProblemOutput`](crate::output::DescribeProblemOutput)
        pub fn build(self) -> crate::output::DescribeProblemOutput {
            crate::output::DescribeProblemOutput {
                problem: self.problem,
            }
        }
    }
}
impl DescribeProblemOutput {
    /// Creates a new builder-style object to manufacture [`DescribeProblemOutput`](crate::output::DescribeProblemOutput)
    pub fn builder() -> crate::output::describe_problem_output::Builder {
        crate::output::describe_problem_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeObservationOutput {
    /// <p>Information about the observation.</p>
    pub observation: std::option::Option<crate::model::Observation>,
}
impl std::fmt::Debug for DescribeObservationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeObservationOutput");
        formatter.field("observation", &self.observation);
        formatter.finish()
    }
}
/// See [`DescribeObservationOutput`](crate::output::DescribeObservationOutput)
pub mod describe_observation_output {
    /// A builder for [`DescribeObservationOutput`](crate::output::DescribeObservationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) observation: std::option::Option<crate::model::Observation>,
    }
    impl Builder {
        /// <p>Information about the observation.</p>
        pub fn observation(mut self, input: crate::model::Observation) -> Self {
            self.observation = Some(input);
            self
        }
        /// <p>Information about the observation.</p>
        pub fn set_observation(
            mut self,
            input: std::option::Option<crate::model::Observation>,
        ) -> Self {
            self.observation = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeObservationOutput`](crate::output::DescribeObservationOutput)
        pub fn build(self) -> crate::output::DescribeObservationOutput {
            crate::output::DescribeObservationOutput {
                observation: self.observation,
            }
        }
    }
}
impl DescribeObservationOutput {
    /// Creates a new builder-style object to manufacture [`DescribeObservationOutput`](crate::output::DescribeObservationOutput)
    pub fn builder() -> crate::output::describe_observation_output::Builder {
        crate::output::describe_observation_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeLogPatternOutput {
    /// <p>The name of the resource group.</p>
    pub resource_group_name: std::option::Option<std::string::String>,
    /// <p>The successfully created log pattern.</p>
    pub log_pattern: std::option::Option<crate::model::LogPattern>,
}
impl std::fmt::Debug for DescribeLogPatternOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeLogPatternOutput");
        formatter.field("resource_group_name", &self.resource_group_name);
        formatter.field("log_pattern", &self.log_pattern);
        formatter.finish()
    }
}
/// See [`DescribeLogPatternOutput`](crate::output::DescribeLogPatternOutput)
pub mod describe_log_pattern_output {
    /// A builder for [`DescribeLogPatternOutput`](crate::output::DescribeLogPatternOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_group_name: std::option::Option<std::string::String>,
        pub(crate) log_pattern: std::option::Option<crate::model::LogPattern>,
    }
    impl Builder {
        /// <p>The name of the resource group.</p>
        pub fn resource_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_group_name = Some(input.into());
            self
        }
        /// <p>The name of the resource group.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_group_name = input;
            self
        }
        /// <p>The successfully created log pattern.</p>
        pub fn log_pattern(mut self, input: crate::model::LogPattern) -> Self {
            self.log_pattern = Some(input);
            self
        }
        /// <p>The successfully created log pattern.</p>
        pub fn set_log_pattern(
            mut self,
            input: std::option::Option<crate::model::LogPattern>,
        ) -> Self {
            self.log_pattern = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeLogPatternOutput`](crate::output::DescribeLogPatternOutput)
        pub fn build(self) -> crate::output::DescribeLogPatternOutput {
            crate::output::DescribeLogPatternOutput {
                resource_group_name: self.resource_group_name,
                log_pattern: self.log_pattern,
            }
        }
    }
}
impl DescribeLogPatternOutput {
    /// Creates a new builder-style object to manufacture [`DescribeLogPatternOutput`](crate::output::DescribeLogPatternOutput)
    pub fn builder() -> crate::output::describe_log_pattern_output::Builder {
        crate::output::describe_log_pattern_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeComponentConfigurationRecommendationOutput {
    /// <p>The recommended configuration settings of the component. The value is the escaped JSON of the configuration.</p>
    pub component_configuration: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeComponentConfigurationRecommendationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeComponentConfigurationRecommendationOutput");
        formatter.field("component_configuration", &self.component_configuration);
        formatter.finish()
    }
}
/// See [`DescribeComponentConfigurationRecommendationOutput`](crate::output::DescribeComponentConfigurationRecommendationOutput)
pub mod describe_component_configuration_recommendation_output {
    /// A builder for [`DescribeComponentConfigurationRecommendationOutput`](crate::output::DescribeComponentConfigurationRecommendationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) component_configuration: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The recommended configuration settings of the component. The value is the escaped JSON of the configuration.</p>
        pub fn component_configuration(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_configuration = Some(input.into());
            self
        }
        /// <p>The recommended configuration settings of the component. The value is the escaped JSON of the configuration.</p>
        pub fn set_component_configuration(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeComponentConfigurationRecommendationOutput`](crate::output::DescribeComponentConfigurationRecommendationOutput)
        pub fn build(self) -> crate::output::DescribeComponentConfigurationRecommendationOutput {
            crate::output::DescribeComponentConfigurationRecommendationOutput {
                component_configuration: self.component_configuration,
            }
        }
    }
}
impl DescribeComponentConfigurationRecommendationOutput {
    /// Creates a new builder-style object to manufacture [`DescribeComponentConfigurationRecommendationOutput`](crate::output::DescribeComponentConfigurationRecommendationOutput)
    pub fn builder(
    ) -> crate::output::describe_component_configuration_recommendation_output::Builder {
        crate::output::describe_component_configuration_recommendation_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeComponentConfigurationOutput {
    /// <p>Indicates whether the application component is monitored.</p>
    pub monitor: std::option::Option<bool>,
    /// <p>The tier of the application component. Supported tiers include
    /// <code>DOT_NET_CORE</code>, <code>DOT_NET_WORKER</code>, <code>DOT_NET_WEB</code>,
    /// <code>SQL_SERVER</code>, and <code>DEFAULT</code>
    /// </p>
    pub tier: std::option::Option<crate::model::Tier>,
    /// <p>The configuration settings of the component. The value is the escaped JSON of the configuration.</p>
    pub component_configuration: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeComponentConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeComponentConfigurationOutput");
        formatter.field("monitor", &self.monitor);
        formatter.field("tier", &self.tier);
        formatter.field("component_configuration", &self.component_configuration);
        formatter.finish()
    }
}
/// See [`DescribeComponentConfigurationOutput`](crate::output::DescribeComponentConfigurationOutput)
pub mod describe_component_configuration_output {
    /// A builder for [`DescribeComponentConfigurationOutput`](crate::output::DescribeComponentConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) monitor: std::option::Option<bool>,
        pub(crate) tier: std::option::Option<crate::model::Tier>,
        pub(crate) component_configuration: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Indicates whether the application component is monitored.</p>
        pub fn monitor(mut self, input: bool) -> Self {
            self.monitor = Some(input);
            self
        }
        /// <p>Indicates whether the application component is monitored.</p>
        pub fn set_monitor(mut self, input: std::option::Option<bool>) -> Self {
            self.monitor = input;
            self
        }
        /// <p>The tier of the application component. Supported tiers include
        /// <code>DOT_NET_CORE</code>, <code>DOT_NET_WORKER</code>, <code>DOT_NET_WEB</code>,
        /// <code>SQL_SERVER</code>, and <code>DEFAULT</code>
        /// </p>
        pub fn tier(mut self, input: crate::model::Tier) -> Self {
            self.tier = Some(input);
            self
        }
        /// <p>The tier of the application component. Supported tiers include
        /// <code>DOT_NET_CORE</code>, <code>DOT_NET_WORKER</code>, <code>DOT_NET_WEB</code>,
        /// <code>SQL_SERVER</code>, and <code>DEFAULT</code>
        /// </p>
        pub fn set_tier(mut self, input: std::option::Option<crate::model::Tier>) -> Self {
            self.tier = input;
            self
        }
        /// <p>The configuration settings of the component. The value is the escaped JSON of the configuration.</p>
        pub fn component_configuration(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_configuration = Some(input.into());
            self
        }
        /// <p>The configuration settings of the component. The value is the escaped JSON of the configuration.</p>
        pub fn set_component_configuration(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeComponentConfigurationOutput`](crate::output::DescribeComponentConfigurationOutput)
        pub fn build(self) -> crate::output::DescribeComponentConfigurationOutput {
            crate::output::DescribeComponentConfigurationOutput {
                monitor: self.monitor,
                tier: self.tier,
                component_configuration: self.component_configuration,
            }
        }
    }
}
impl DescribeComponentConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`DescribeComponentConfigurationOutput`](crate::output::DescribeComponentConfigurationOutput)
    pub fn builder() -> crate::output::describe_component_configuration_output::Builder {
        crate::output::describe_component_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeComponentOutput {
    /// <p>Describes a standalone resource or similarly grouped resources that the application is made
    /// up of.</p>
    pub application_component: std::option::Option<crate::model::ApplicationComponent>,
    /// <p>The list of resource ARNs that belong to the component.</p>
    pub resource_list: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for DescribeComponentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeComponentOutput");
        formatter.field("application_component", &self.application_component);
        formatter.field("resource_list", &self.resource_list);
        formatter.finish()
    }
}
/// See [`DescribeComponentOutput`](crate::output::DescribeComponentOutput)
pub mod describe_component_output {
    /// A builder for [`DescribeComponentOutput`](crate::output::DescribeComponentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_component: std::option::Option<crate::model::ApplicationComponent>,
        pub(crate) resource_list: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>Describes a standalone resource or similarly grouped resources that the application is made
        /// up of.</p>
        pub fn application_component(mut self, input: crate::model::ApplicationComponent) -> Self {
            self.application_component = Some(input);
            self
        }
        /// <p>Describes a standalone resource or similarly grouped resources that the application is made
        /// up of.</p>
        pub fn set_application_component(
            mut self,
            input: std::option::Option<crate::model::ApplicationComponent>,
        ) -> Self {
            self.application_component = input;
            self
        }
        /// Appends an item to `resource_list`.
        ///
        /// To override the contents of this collection use [`set_resource_list`](Self::set_resource_list).
        ///
        /// <p>The list of resource ARNs that belong to the component.</p>
        pub fn resource_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resource_list.unwrap_or_default();
            v.push(input.into());
            self.resource_list = Some(v);
            self
        }
        /// <p>The list of resource ARNs that belong to the component.</p>
        pub fn set_resource_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resource_list = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeComponentOutput`](crate::output::DescribeComponentOutput)
        pub fn build(self) -> crate::output::DescribeComponentOutput {
            crate::output::DescribeComponentOutput {
                application_component: self.application_component,
                resource_list: self.resource_list,
            }
        }
    }
}
impl DescribeComponentOutput {
    /// Creates a new builder-style object to manufacture [`DescribeComponentOutput`](crate::output::DescribeComponentOutput)
    pub fn builder() -> crate::output::describe_component_output::Builder {
        crate::output::describe_component_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeApplicationOutput {
    /// <p>Information about the application.</p>
    pub application_info: std::option::Option<crate::model::ApplicationInfo>,
}
impl std::fmt::Debug for DescribeApplicationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeApplicationOutput");
        formatter.field("application_info", &self.application_info);
        formatter.finish()
    }
}
/// See [`DescribeApplicationOutput`](crate::output::DescribeApplicationOutput)
pub mod describe_application_output {
    /// A builder for [`DescribeApplicationOutput`](crate::output::DescribeApplicationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_info: std::option::Option<crate::model::ApplicationInfo>,
    }
    impl Builder {
        /// <p>Information about the application.</p>
        pub fn application_info(mut self, input: crate::model::ApplicationInfo) -> Self {
            self.application_info = Some(input);
            self
        }
        /// <p>Information about the application.</p>
        pub fn set_application_info(
            mut self,
            input: std::option::Option<crate::model::ApplicationInfo>,
        ) -> Self {
            self.application_info = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeApplicationOutput`](crate::output::DescribeApplicationOutput)
        pub fn build(self) -> crate::output::DescribeApplicationOutput {
            crate::output::DescribeApplicationOutput {
                application_info: self.application_info,
            }
        }
    }
}
impl DescribeApplicationOutput {
    /// Creates a new builder-style object to manufacture [`DescribeApplicationOutput`](crate::output::DescribeApplicationOutput)
    pub fn builder() -> crate::output::describe_application_output::Builder {
        crate::output::describe_application_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteLogPatternOutput {}
impl std::fmt::Debug for DeleteLogPatternOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteLogPatternOutput");
        formatter.finish()
    }
}
/// See [`DeleteLogPatternOutput`](crate::output::DeleteLogPatternOutput)
pub mod delete_log_pattern_output {
    /// A builder for [`DeleteLogPatternOutput`](crate::output::DeleteLogPatternOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteLogPatternOutput`](crate::output::DeleteLogPatternOutput)
        pub fn build(self) -> crate::output::DeleteLogPatternOutput {
            crate::output::DeleteLogPatternOutput {}
        }
    }
}
impl DeleteLogPatternOutput {
    /// Creates a new builder-style object to manufacture [`DeleteLogPatternOutput`](crate::output::DeleteLogPatternOutput)
    pub fn builder() -> crate::output::delete_log_pattern_output::Builder {
        crate::output::delete_log_pattern_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteComponentOutput {}
impl std::fmt::Debug for DeleteComponentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteComponentOutput");
        formatter.finish()
    }
}
/// See [`DeleteComponentOutput`](crate::output::DeleteComponentOutput)
pub mod delete_component_output {
    /// A builder for [`DeleteComponentOutput`](crate::output::DeleteComponentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteComponentOutput`](crate::output::DeleteComponentOutput)
        pub fn build(self) -> crate::output::DeleteComponentOutput {
            crate::output::DeleteComponentOutput {}
        }
    }
}
impl DeleteComponentOutput {
    /// Creates a new builder-style object to manufacture [`DeleteComponentOutput`](crate::output::DeleteComponentOutput)
    pub fn builder() -> crate::output::delete_component_output::Builder {
        crate::output::delete_component_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteApplicationOutput {}
impl std::fmt::Debug for DeleteApplicationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteApplicationOutput");
        formatter.finish()
    }
}
/// See [`DeleteApplicationOutput`](crate::output::DeleteApplicationOutput)
pub mod delete_application_output {
    /// A builder for [`DeleteApplicationOutput`](crate::output::DeleteApplicationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteApplicationOutput`](crate::output::DeleteApplicationOutput)
        pub fn build(self) -> crate::output::DeleteApplicationOutput {
            crate::output::DeleteApplicationOutput {}
        }
    }
}
impl DeleteApplicationOutput {
    /// Creates a new builder-style object to manufacture [`DeleteApplicationOutput`](crate::output::DeleteApplicationOutput)
    pub fn builder() -> crate::output::delete_application_output::Builder {
        crate::output::delete_application_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateLogPatternOutput {
    /// <p>The successfully created log pattern.</p>
    pub log_pattern: std::option::Option<crate::model::LogPattern>,
    /// <p>The name of the resource group.</p>
    pub resource_group_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateLogPatternOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateLogPatternOutput");
        formatter.field("log_pattern", &self.log_pattern);
        formatter.field("resource_group_name", &self.resource_group_name);
        formatter.finish()
    }
}
/// See [`CreateLogPatternOutput`](crate::output::CreateLogPatternOutput)
pub mod create_log_pattern_output {
    /// A builder for [`CreateLogPatternOutput`](crate::output::CreateLogPatternOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) log_pattern: std::option::Option<crate::model::LogPattern>,
        pub(crate) resource_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The successfully created log pattern.</p>
        pub fn log_pattern(mut self, input: crate::model::LogPattern) -> Self {
            self.log_pattern = Some(input);
            self
        }
        /// <p>The successfully created log pattern.</p>
        pub fn set_log_pattern(
            mut self,
            input: std::option::Option<crate::model::LogPattern>,
        ) -> Self {
            self.log_pattern = input;
            self
        }
        /// <p>The name of the resource group.</p>
        pub fn resource_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_group_name = Some(input.into());
            self
        }
        /// <p>The name of the resource group.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateLogPatternOutput`](crate::output::CreateLogPatternOutput)
        pub fn build(self) -> crate::output::CreateLogPatternOutput {
            crate::output::CreateLogPatternOutput {
                log_pattern: self.log_pattern,
                resource_group_name: self.resource_group_name,
            }
        }
    }
}
impl CreateLogPatternOutput {
    /// Creates a new builder-style object to manufacture [`CreateLogPatternOutput`](crate::output::CreateLogPatternOutput)
    pub fn builder() -> crate::output::create_log_pattern_output::Builder {
        crate::output::create_log_pattern_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateComponentOutput {}
impl std::fmt::Debug for CreateComponentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateComponentOutput");
        formatter.finish()
    }
}
/// See [`CreateComponentOutput`](crate::output::CreateComponentOutput)
pub mod create_component_output {
    /// A builder for [`CreateComponentOutput`](crate::output::CreateComponentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CreateComponentOutput`](crate::output::CreateComponentOutput)
        pub fn build(self) -> crate::output::CreateComponentOutput {
            crate::output::CreateComponentOutput {}
        }
    }
}
impl CreateComponentOutput {
    /// Creates a new builder-style object to manufacture [`CreateComponentOutput`](crate::output::CreateComponentOutput)
    pub fn builder() -> crate::output::create_component_output::Builder {
        crate::output::create_component_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateApplicationOutput {
    /// <p>Information about the application.</p>
    pub application_info: std::option::Option<crate::model::ApplicationInfo>,
}
impl std::fmt::Debug for CreateApplicationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateApplicationOutput");
        formatter.field("application_info", &self.application_info);
        formatter.finish()
    }
}
/// See [`CreateApplicationOutput`](crate::output::CreateApplicationOutput)
pub mod create_application_output {
    /// A builder for [`CreateApplicationOutput`](crate::output::CreateApplicationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_info: std::option::Option<crate::model::ApplicationInfo>,
    }
    impl Builder {
        /// <p>Information about the application.</p>
        pub fn application_info(mut self, input: crate::model::ApplicationInfo) -> Self {
            self.application_info = Some(input);
            self
        }
        /// <p>Information about the application.</p>
        pub fn set_application_info(
            mut self,
            input: std::option::Option<crate::model::ApplicationInfo>,
        ) -> Self {
            self.application_info = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateApplicationOutput`](crate::output::CreateApplicationOutput)
        pub fn build(self) -> crate::output::CreateApplicationOutput {
            crate::output::CreateApplicationOutput {
                application_info: self.application_info,
            }
        }
    }
}
impl CreateApplicationOutput {
    /// Creates a new builder-style object to manufacture [`CreateApplicationOutput`](crate::output::CreateApplicationOutput)
    pub fn builder() -> crate::output::create_application_output::Builder {
        crate::output::create_application_output::Builder::default()
    }
}
