// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_configuration_items_to_application_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AssociateConfigurationItemsToApplicationOutput,
    crate::error::AssociateConfigurationItemsToApplicationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AssociateConfigurationItemsToApplicationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::AssociateConfigurationItemsToApplicationError::unhandled(generic),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationErrorException" => crate::error::AssociateConfigurationItemsToApplicationError { meta: generic, kind: crate::error::AssociateConfigurationItemsToApplicationErrorKind::AuthorizationErrorException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::authorization_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_authorization_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateConfigurationItemsToApplicationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "HomeRegionNotSetException" => crate::error::AssociateConfigurationItemsToApplicationError { meta: generic, kind: crate::error::AssociateConfigurationItemsToApplicationErrorKind::HomeRegionNotSetException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::home_region_not_set_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_home_region_not_set_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateConfigurationItemsToApplicationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterException" => crate::error::AssociateConfigurationItemsToApplicationError { meta: generic, kind: crate::error::AssociateConfigurationItemsToApplicationErrorKind::InvalidParameterException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateConfigurationItemsToApplicationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterValueException" => crate::error::AssociateConfigurationItemsToApplicationError { meta: generic, kind: crate::error::AssociateConfigurationItemsToApplicationErrorKind::InvalidParameterValueException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateConfigurationItemsToApplicationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServerInternalErrorException" => crate::error::AssociateConfigurationItemsToApplicationError { meta: generic, kind: crate::error::AssociateConfigurationItemsToApplicationErrorKind::ServerInternalErrorException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::server_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_server_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateConfigurationItemsToApplicationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::AssociateConfigurationItemsToApplicationError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_configuration_items_to_application_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AssociateConfigurationItemsToApplicationOutput,
    crate::error::AssociateConfigurationItemsToApplicationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::associate_configuration_items_to_application_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_batch_delete_import_data_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::BatchDeleteImportDataOutput,
    crate::error::BatchDeleteImportDataError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::BatchDeleteImportDataError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::BatchDeleteImportDataError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationErrorException" => crate::error::BatchDeleteImportDataError {
            meta: generic,
            kind: crate::error::BatchDeleteImportDataErrorKind::AuthorizationErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::authorization_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_authorization_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchDeleteImportDataError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "HomeRegionNotSetException" => crate::error::BatchDeleteImportDataError {
            meta: generic,
            kind: crate::error::BatchDeleteImportDataErrorKind::HomeRegionNotSetException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::home_region_not_set_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_home_region_not_set_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchDeleteImportDataError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::BatchDeleteImportDataError {
            meta: generic,
            kind: crate::error::BatchDeleteImportDataErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchDeleteImportDataError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValueException" => crate::error::BatchDeleteImportDataError {
            meta: generic,
            kind: crate::error::BatchDeleteImportDataErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchDeleteImportDataError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerInternalErrorException" => crate::error::BatchDeleteImportDataError {
            meta: generic,
            kind: crate::error::BatchDeleteImportDataErrorKind::ServerInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::server_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_server_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchDeleteImportDataError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::BatchDeleteImportDataError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_batch_delete_import_data_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::BatchDeleteImportDataOutput,
    crate::error::BatchDeleteImportDataError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::batch_delete_import_data_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_batch_delete_import_data(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::BatchDeleteImportDataError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_application_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateApplicationOutput, crate::error::CreateApplicationError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateApplicationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateApplicationError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationErrorException" => crate::error::CreateApplicationError {
            meta: generic,
            kind: crate::error::CreateApplicationErrorKind::AuthorizationErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::authorization_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_authorization_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateApplicationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "HomeRegionNotSetException" => crate::error::CreateApplicationError {
            meta: generic,
            kind: crate::error::CreateApplicationErrorKind::HomeRegionNotSetException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::home_region_not_set_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_home_region_not_set_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateApplicationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::CreateApplicationError {
            meta: generic,
            kind: crate::error::CreateApplicationErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateApplicationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValueException" => crate::error::CreateApplicationError {
            meta: generic,
            kind: crate::error::CreateApplicationErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateApplicationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerInternalErrorException" => crate::error::CreateApplicationError {
            meta: generic,
            kind: crate::error::CreateApplicationErrorKind::ServerInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::server_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_server_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateApplicationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateApplicationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_application_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateApplicationOutput, crate::error::CreateApplicationError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_application_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_application(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateApplicationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_tags_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateTagsOutput, crate::error::CreateTagsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateTagsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateTagsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationErrorException" => crate::error::CreateTagsError {
            meta: generic,
            kind: crate::error::CreateTagsErrorKind::AuthorizationErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::authorization_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_authorization_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "HomeRegionNotSetException" => crate::error::CreateTagsError {
            meta: generic,
            kind: crate::error::CreateTagsErrorKind::HomeRegionNotSetException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::home_region_not_set_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_home_region_not_set_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::CreateTagsError {
            meta: generic,
            kind: crate::error::CreateTagsErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValueException" => crate::error::CreateTagsError {
            meta: generic,
            kind: crate::error::CreateTagsErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::CreateTagsError {
            meta: generic,
            kind: crate::error::CreateTagsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerInternalErrorException" => crate::error::CreateTagsError {
            meta: generic,
            kind: crate::error::CreateTagsErrorKind::ServerInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::server_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_server_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateTagsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_tags_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateTagsOutput, crate::error::CreateTagsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_tags_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_applications_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteApplicationsOutput,
    crate::error::DeleteApplicationsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteApplicationsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteApplicationsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationErrorException" => crate::error::DeleteApplicationsError {
            meta: generic,
            kind: crate::error::DeleteApplicationsErrorKind::AuthorizationErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::authorization_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_authorization_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteApplicationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "HomeRegionNotSetException" => crate::error::DeleteApplicationsError {
            meta: generic,
            kind: crate::error::DeleteApplicationsErrorKind::HomeRegionNotSetException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::home_region_not_set_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_home_region_not_set_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteApplicationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::DeleteApplicationsError {
            meta: generic,
            kind: crate::error::DeleteApplicationsErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteApplicationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValueException" => crate::error::DeleteApplicationsError {
            meta: generic,
            kind: crate::error::DeleteApplicationsErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteApplicationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerInternalErrorException" => crate::error::DeleteApplicationsError {
            meta: generic,
            kind: crate::error::DeleteApplicationsErrorKind::ServerInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::server_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_server_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteApplicationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteApplicationsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_applications_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteApplicationsOutput,
    crate::error::DeleteApplicationsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_applications_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_tags_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteTagsOutput, crate::error::DeleteTagsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteTagsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteTagsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationErrorException" => crate::error::DeleteTagsError {
            meta: generic,
            kind: crate::error::DeleteTagsErrorKind::AuthorizationErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::authorization_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_authorization_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "HomeRegionNotSetException" => crate::error::DeleteTagsError {
            meta: generic,
            kind: crate::error::DeleteTagsErrorKind::HomeRegionNotSetException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::home_region_not_set_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_home_region_not_set_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::DeleteTagsError {
            meta: generic,
            kind: crate::error::DeleteTagsErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValueException" => crate::error::DeleteTagsError {
            meta: generic,
            kind: crate::error::DeleteTagsErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DeleteTagsError {
            meta: generic,
            kind: crate::error::DeleteTagsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerInternalErrorException" => crate::error::DeleteTagsError {
            meta: generic,
            kind: crate::error::DeleteTagsErrorKind::ServerInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::server_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_server_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteTagsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_tags_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteTagsOutput, crate::error::DeleteTagsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_tags_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_agents_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeAgentsOutput, crate::error::DescribeAgentsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeAgentsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeAgentsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationErrorException" => crate::error::DescribeAgentsError {
            meta: generic,
            kind: crate::error::DescribeAgentsErrorKind::AuthorizationErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::authorization_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_authorization_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeAgentsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "HomeRegionNotSetException" => crate::error::DescribeAgentsError {
            meta: generic,
            kind: crate::error::DescribeAgentsErrorKind::HomeRegionNotSetException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::home_region_not_set_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_home_region_not_set_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeAgentsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::DescribeAgentsError {
            meta: generic,
            kind: crate::error::DescribeAgentsErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeAgentsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValueException" => crate::error::DescribeAgentsError {
            meta: generic,
            kind: crate::error::DescribeAgentsErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeAgentsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerInternalErrorException" => crate::error::DescribeAgentsError {
            meta: generic,
            kind: crate::error::DescribeAgentsErrorKind::ServerInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::server_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_server_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeAgentsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeAgentsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_agents_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeAgentsOutput, crate::error::DescribeAgentsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_agents_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_agents(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeAgentsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_configurations_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeConfigurationsOutput,
    crate::error::DescribeConfigurationsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeConfigurationsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeConfigurationsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationErrorException" => crate::error::DescribeConfigurationsError {
            meta: generic,
            kind: crate::error::DescribeConfigurationsErrorKind::AuthorizationErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::authorization_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_authorization_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeConfigurationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "HomeRegionNotSetException" => crate::error::DescribeConfigurationsError {
            meta: generic,
            kind: crate::error::DescribeConfigurationsErrorKind::HomeRegionNotSetException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::home_region_not_set_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_home_region_not_set_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeConfigurationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::DescribeConfigurationsError {
            meta: generic,
            kind: crate::error::DescribeConfigurationsErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeConfigurationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValueException" => crate::error::DescribeConfigurationsError {
            meta: generic,
            kind: crate::error::DescribeConfigurationsErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeConfigurationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerInternalErrorException" => crate::error::DescribeConfigurationsError {
            meta: generic,
            kind: crate::error::DescribeConfigurationsErrorKind::ServerInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::server_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_server_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeConfigurationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeConfigurationsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_configurations_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeConfigurationsOutput,
    crate::error::DescribeConfigurationsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_configurations_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_configurations(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeConfigurationsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_continuous_exports_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeContinuousExportsOutput,
    crate::error::DescribeContinuousExportsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeContinuousExportsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeContinuousExportsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationErrorException" => crate::error::DescribeContinuousExportsError {
            meta: generic,
            kind: crate::error::DescribeContinuousExportsErrorKind::AuthorizationErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::authorization_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_authorization_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeContinuousExportsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "HomeRegionNotSetException" => crate::error::DescribeContinuousExportsError {
            meta: generic,
            kind: crate::error::DescribeContinuousExportsErrorKind::HomeRegionNotSetException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::home_region_not_set_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_home_region_not_set_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeContinuousExportsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::DescribeContinuousExportsError {
            meta: generic,
            kind: crate::error::DescribeContinuousExportsErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeContinuousExportsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValueException" => crate::error::DescribeContinuousExportsError {
            meta: generic,
            kind: crate::error::DescribeContinuousExportsErrorKind::InvalidParameterValueException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_parameter_value_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeContinuousExportsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "OperationNotPermittedException" => crate::error::DescribeContinuousExportsError {
            meta: generic,
            kind: crate::error::DescribeContinuousExportsErrorKind::OperationNotPermittedException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::operation_not_permitted_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeContinuousExportsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ResourceNotFoundException" => crate::error::DescribeContinuousExportsError {
            meta: generic,
            kind: crate::error::DescribeContinuousExportsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeContinuousExportsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerInternalErrorException" => crate::error::DescribeContinuousExportsError {
            meta: generic,
            kind: crate::error::DescribeContinuousExportsErrorKind::ServerInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::server_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_server_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeContinuousExportsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeContinuousExportsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_continuous_exports_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeContinuousExportsOutput,
    crate::error::DescribeContinuousExportsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_continuous_exports_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_continuous_exports(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeContinuousExportsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_export_configurations_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeExportConfigurationsOutput,
    crate::error::DescribeExportConfigurationsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeExportConfigurationsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeExportConfigurationsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationErrorException" => crate::error::DescribeExportConfigurationsError {
            meta: generic,
            kind: crate::error::DescribeExportConfigurationsErrorKind::AuthorizationErrorException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::authorization_error_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_authorization_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeExportConfigurationsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "HomeRegionNotSetException" => crate::error::DescribeExportConfigurationsError {
            meta: generic,
            kind: crate::error::DescribeExportConfigurationsErrorKind::HomeRegionNotSetException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::home_region_not_set_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_home_region_not_set_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeExportConfigurationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::DescribeExportConfigurationsError {
            meta: generic,
            kind: crate::error::DescribeExportConfigurationsErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeExportConfigurationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValueException" => crate::error::DescribeExportConfigurationsError {
            meta: generic,
            kind:
                crate::error::DescribeExportConfigurationsErrorKind::InvalidParameterValueException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::invalid_parameter_value_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeExportConfigurationsError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "ResourceNotFoundException" => crate::error::DescribeExportConfigurationsError {
            meta: generic,
            kind: crate::error::DescribeExportConfigurationsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeExportConfigurationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerInternalErrorException" => crate::error::DescribeExportConfigurationsError {
            meta: generic,
            kind: crate::error::DescribeExportConfigurationsErrorKind::ServerInternalErrorException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::server_internal_error_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeExportConfigurationsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::DescribeExportConfigurationsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_export_configurations_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeExportConfigurationsOutput,
    crate::error::DescribeExportConfigurationsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_export_configurations_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_export_configurations(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeExportConfigurationsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_export_tasks_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeExportTasksOutput,
    crate::error::DescribeExportTasksError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeExportTasksError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeExportTasksError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationErrorException" => crate::error::DescribeExportTasksError {
            meta: generic,
            kind: crate::error::DescribeExportTasksErrorKind::AuthorizationErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::authorization_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_authorization_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeExportTasksError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "HomeRegionNotSetException" => crate::error::DescribeExportTasksError {
            meta: generic,
            kind: crate::error::DescribeExportTasksErrorKind::HomeRegionNotSetException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::home_region_not_set_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_home_region_not_set_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeExportTasksError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::DescribeExportTasksError {
            meta: generic,
            kind: crate::error::DescribeExportTasksErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeExportTasksError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValueException" => crate::error::DescribeExportTasksError {
            meta: generic,
            kind: crate::error::DescribeExportTasksErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeExportTasksError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerInternalErrorException" => crate::error::DescribeExportTasksError {
            meta: generic,
            kind: crate::error::DescribeExportTasksErrorKind::ServerInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::server_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_server_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeExportTasksError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeExportTasksError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_export_tasks_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeExportTasksOutput,
    crate::error::DescribeExportTasksError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_export_tasks_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_export_tasks(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeExportTasksError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_import_tasks_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeImportTasksOutput,
    crate::error::DescribeImportTasksError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeImportTasksError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeImportTasksError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationErrorException" => crate::error::DescribeImportTasksError {
            meta: generic,
            kind: crate::error::DescribeImportTasksErrorKind::AuthorizationErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::authorization_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_authorization_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeImportTasksError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "HomeRegionNotSetException" => crate::error::DescribeImportTasksError {
            meta: generic,
            kind: crate::error::DescribeImportTasksErrorKind::HomeRegionNotSetException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::home_region_not_set_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_home_region_not_set_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeImportTasksError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::DescribeImportTasksError {
            meta: generic,
            kind: crate::error::DescribeImportTasksErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeImportTasksError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValueException" => crate::error::DescribeImportTasksError {
            meta: generic,
            kind: crate::error::DescribeImportTasksErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeImportTasksError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerInternalErrorException" => crate::error::DescribeImportTasksError {
            meta: generic,
            kind: crate::error::DescribeImportTasksErrorKind::ServerInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::server_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_server_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeImportTasksError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeImportTasksError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_import_tasks_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeImportTasksOutput,
    crate::error::DescribeImportTasksError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_import_tasks_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_import_tasks(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeImportTasksError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_tags_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeTagsOutput, crate::error::DescribeTagsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeTagsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeTagsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationErrorException" => crate::error::DescribeTagsError {
            meta: generic,
            kind: crate::error::DescribeTagsErrorKind::AuthorizationErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::authorization_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_authorization_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "HomeRegionNotSetException" => crate::error::DescribeTagsError {
            meta: generic,
            kind: crate::error::DescribeTagsErrorKind::HomeRegionNotSetException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::home_region_not_set_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_home_region_not_set_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::DescribeTagsError {
            meta: generic,
            kind: crate::error::DescribeTagsErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValueException" => crate::error::DescribeTagsError {
            meta: generic,
            kind: crate::error::DescribeTagsErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DescribeTagsError {
            meta: generic,
            kind: crate::error::DescribeTagsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerInternalErrorException" => crate::error::DescribeTagsError {
            meta: generic,
            kind: crate::error::DescribeTagsErrorKind::ServerInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::server_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_server_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeTagsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_tags_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeTagsOutput, crate::error::DescribeTagsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_tags_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_tags(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeTagsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disassociate_configuration_items_from_application_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisassociateConfigurationItemsFromApplicationOutput,
    crate::error::DisassociateConfigurationItemsFromApplicationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DisassociateConfigurationItemsFromApplicationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::DisassociateConfigurationItemsFromApplicationError::unhandled(
                    generic,
                ),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationErrorException" => crate::error::DisassociateConfigurationItemsFromApplicationError { meta: generic, kind: crate::error::DisassociateConfigurationItemsFromApplicationErrorKind::AuthorizationErrorException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::authorization_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_authorization_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateConfigurationItemsFromApplicationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "HomeRegionNotSetException" => crate::error::DisassociateConfigurationItemsFromApplicationError { meta: generic, kind: crate::error::DisassociateConfigurationItemsFromApplicationErrorKind::HomeRegionNotSetException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::home_region_not_set_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_home_region_not_set_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateConfigurationItemsFromApplicationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterException" => crate::error::DisassociateConfigurationItemsFromApplicationError { meta: generic, kind: crate::error::DisassociateConfigurationItemsFromApplicationErrorKind::InvalidParameterException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateConfigurationItemsFromApplicationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterValueException" => crate::error::DisassociateConfigurationItemsFromApplicationError { meta: generic, kind: crate::error::DisassociateConfigurationItemsFromApplicationErrorKind::InvalidParameterValueException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateConfigurationItemsFromApplicationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServerInternalErrorException" => crate::error::DisassociateConfigurationItemsFromApplicationError { meta: generic, kind: crate::error::DisassociateConfigurationItemsFromApplicationErrorKind::ServerInternalErrorException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::server_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_server_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateConfigurationItemsFromApplicationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DisassociateConfigurationItemsFromApplicationError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disassociate_configuration_items_from_application_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisassociateConfigurationItemsFromApplicationOutput,
    crate::error::DisassociateConfigurationItemsFromApplicationError,
> {
    Ok({
        #[allow(unused_mut)]let mut output = crate::output::disassociate_configuration_items_from_application_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_export_configurations_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ExportConfigurationsOutput,
    crate::error::ExportConfigurationsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ExportConfigurationsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ExportConfigurationsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationErrorException" => crate::error::ExportConfigurationsError {
            meta: generic,
            kind: crate::error::ExportConfigurationsErrorKind::AuthorizationErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::authorization_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_authorization_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ExportConfigurationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "HomeRegionNotSetException" => crate::error::ExportConfigurationsError {
            meta: generic,
            kind: crate::error::ExportConfigurationsErrorKind::HomeRegionNotSetException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::home_region_not_set_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_home_region_not_set_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ExportConfigurationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::ExportConfigurationsError {
            meta: generic,
            kind: crate::error::ExportConfigurationsErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ExportConfigurationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValueException" => crate::error::ExportConfigurationsError {
            meta: generic,
            kind: crate::error::ExportConfigurationsErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ExportConfigurationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationNotPermittedException" => crate::error::ExportConfigurationsError {
            meta: generic,
            kind: crate::error::ExportConfigurationsErrorKind::OperationNotPermittedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ExportConfigurationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerInternalErrorException" => crate::error::ExportConfigurationsError {
            meta: generic,
            kind: crate::error::ExportConfigurationsErrorKind::ServerInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::server_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_server_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ExportConfigurationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ExportConfigurationsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_export_configurations_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ExportConfigurationsOutput,
    crate::error::ExportConfigurationsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::export_configurations_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_export_configurations(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ExportConfigurationsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_discovery_summary_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetDiscoverySummaryOutput,
    crate::error::GetDiscoverySummaryError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetDiscoverySummaryError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetDiscoverySummaryError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationErrorException" => crate::error::GetDiscoverySummaryError {
            meta: generic,
            kind: crate::error::GetDiscoverySummaryErrorKind::AuthorizationErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::authorization_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_authorization_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDiscoverySummaryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "HomeRegionNotSetException" => crate::error::GetDiscoverySummaryError {
            meta: generic,
            kind: crate::error::GetDiscoverySummaryErrorKind::HomeRegionNotSetException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::home_region_not_set_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_home_region_not_set_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDiscoverySummaryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::GetDiscoverySummaryError {
            meta: generic,
            kind: crate::error::GetDiscoverySummaryErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDiscoverySummaryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValueException" => crate::error::GetDiscoverySummaryError {
            meta: generic,
            kind: crate::error::GetDiscoverySummaryErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDiscoverySummaryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerInternalErrorException" => crate::error::GetDiscoverySummaryError {
            meta: generic,
            kind: crate::error::GetDiscoverySummaryErrorKind::ServerInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::server_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_server_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDiscoverySummaryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetDiscoverySummaryError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_discovery_summary_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetDiscoverySummaryOutput,
    crate::error::GetDiscoverySummaryError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_discovery_summary_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_discovery_summary(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetDiscoverySummaryError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_configurations_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListConfigurationsOutput,
    crate::error::ListConfigurationsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListConfigurationsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListConfigurationsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationErrorException" => crate::error::ListConfigurationsError {
            meta: generic,
            kind: crate::error::ListConfigurationsErrorKind::AuthorizationErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::authorization_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_authorization_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListConfigurationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "HomeRegionNotSetException" => crate::error::ListConfigurationsError {
            meta: generic,
            kind: crate::error::ListConfigurationsErrorKind::HomeRegionNotSetException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::home_region_not_set_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_home_region_not_set_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListConfigurationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::ListConfigurationsError {
            meta: generic,
            kind: crate::error::ListConfigurationsErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListConfigurationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValueException" => crate::error::ListConfigurationsError {
            meta: generic,
            kind: crate::error::ListConfigurationsErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListConfigurationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ListConfigurationsError {
            meta: generic,
            kind: crate::error::ListConfigurationsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListConfigurationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerInternalErrorException" => crate::error::ListConfigurationsError {
            meta: generic,
            kind: crate::error::ListConfigurationsErrorKind::ServerInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::server_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_server_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListConfigurationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListConfigurationsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_configurations_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListConfigurationsOutput,
    crate::error::ListConfigurationsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_configurations_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_configurations(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListConfigurationsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_server_neighbors_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListServerNeighborsOutput,
    crate::error::ListServerNeighborsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListServerNeighborsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListServerNeighborsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationErrorException" => crate::error::ListServerNeighborsError {
            meta: generic,
            kind: crate::error::ListServerNeighborsErrorKind::AuthorizationErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::authorization_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_authorization_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListServerNeighborsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "HomeRegionNotSetException" => crate::error::ListServerNeighborsError {
            meta: generic,
            kind: crate::error::ListServerNeighborsErrorKind::HomeRegionNotSetException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::home_region_not_set_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_home_region_not_set_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListServerNeighborsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::ListServerNeighborsError {
            meta: generic,
            kind: crate::error::ListServerNeighborsErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListServerNeighborsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValueException" => crate::error::ListServerNeighborsError {
            meta: generic,
            kind: crate::error::ListServerNeighborsErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListServerNeighborsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerInternalErrorException" => crate::error::ListServerNeighborsError {
            meta: generic,
            kind: crate::error::ListServerNeighborsErrorKind::ServerInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::server_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_server_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListServerNeighborsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListServerNeighborsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_server_neighbors_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListServerNeighborsOutput,
    crate::error::ListServerNeighborsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_server_neighbors_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_server_neighbors(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListServerNeighborsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_continuous_export_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartContinuousExportOutput,
    crate::error::StartContinuousExportError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StartContinuousExportError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::StartContinuousExportError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationErrorException" => crate::error::StartContinuousExportError {
            meta: generic,
            kind: crate::error::StartContinuousExportErrorKind::AuthorizationErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::authorization_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_authorization_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartContinuousExportError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictErrorException" => crate::error::StartContinuousExportError {
            meta: generic,
            kind: crate::error::StartContinuousExportErrorKind::ConflictErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::conflict_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_conflict_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartContinuousExportError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "HomeRegionNotSetException" => crate::error::StartContinuousExportError {
            meta: generic,
            kind: crate::error::StartContinuousExportErrorKind::HomeRegionNotSetException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::home_region_not_set_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_home_region_not_set_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartContinuousExportError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::StartContinuousExportError {
            meta: generic,
            kind: crate::error::StartContinuousExportErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartContinuousExportError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValueException" => crate::error::StartContinuousExportError {
            meta: generic,
            kind: crate::error::StartContinuousExportErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartContinuousExportError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationNotPermittedException" => crate::error::StartContinuousExportError {
            meta: generic,
            kind: crate::error::StartContinuousExportErrorKind::OperationNotPermittedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartContinuousExportError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceInUseException" => crate::error::StartContinuousExportError {
            meta: generic,
            kind: crate::error::StartContinuousExportErrorKind::ResourceInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartContinuousExportError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerInternalErrorException" => crate::error::StartContinuousExportError {
            meta: generic,
            kind: crate::error::StartContinuousExportErrorKind::ServerInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::server_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_server_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartContinuousExportError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::StartContinuousExportError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_continuous_export_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartContinuousExportOutput,
    crate::error::StartContinuousExportError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::start_continuous_export_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_start_continuous_export(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::StartContinuousExportError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_data_collection_by_agent_ids_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartDataCollectionByAgentIdsOutput,
    crate::error::StartDataCollectionByAgentIdsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StartDataCollectionByAgentIdsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::StartDataCollectionByAgentIdsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationErrorException" => crate::error::StartDataCollectionByAgentIdsError {
            meta: generic,
            kind: crate::error::StartDataCollectionByAgentIdsErrorKind::AuthorizationErrorException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::authorization_error_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_authorization_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartDataCollectionByAgentIdsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "HomeRegionNotSetException" => crate::error::StartDataCollectionByAgentIdsError {
            meta: generic,
            kind: crate::error::StartDataCollectionByAgentIdsErrorKind::HomeRegionNotSetException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::home_region_not_set_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_home_region_not_set_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartDataCollectionByAgentIdsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidParameterException" => crate::error::StartDataCollectionByAgentIdsError {
            meta: generic,
            kind: crate::error::StartDataCollectionByAgentIdsErrorKind::InvalidParameterException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_parameter_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartDataCollectionByAgentIdsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidParameterValueException" => crate::error::StartDataCollectionByAgentIdsError {
            meta: generic,
            kind:
                crate::error::StartDataCollectionByAgentIdsErrorKind::InvalidParameterValueException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::invalid_parameter_value_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartDataCollectionByAgentIdsError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "ServerInternalErrorException" => crate::error::StartDataCollectionByAgentIdsError {
            meta: generic,
            kind:
                crate::error::StartDataCollectionByAgentIdsErrorKind::ServerInternalErrorException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::server_internal_error_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_server_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartDataCollectionByAgentIdsError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        _ => crate::error::StartDataCollectionByAgentIdsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_data_collection_by_agent_ids_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartDataCollectionByAgentIdsOutput,
    crate::error::StartDataCollectionByAgentIdsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::start_data_collection_by_agent_ids_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_start_data_collection_by_agent_ids(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::StartDataCollectionByAgentIdsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_export_task_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StartExportTaskOutput, crate::error::StartExportTaskError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StartExportTaskError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::StartExportTaskError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationErrorException" => crate::error::StartExportTaskError {
            meta: generic,
            kind: crate::error::StartExportTaskErrorKind::AuthorizationErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::authorization_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_authorization_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartExportTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "HomeRegionNotSetException" => crate::error::StartExportTaskError {
            meta: generic,
            kind: crate::error::StartExportTaskErrorKind::HomeRegionNotSetException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::home_region_not_set_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_home_region_not_set_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartExportTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::StartExportTaskError {
            meta: generic,
            kind: crate::error::StartExportTaskErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartExportTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValueException" => crate::error::StartExportTaskError {
            meta: generic,
            kind: crate::error::StartExportTaskErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartExportTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationNotPermittedException" => crate::error::StartExportTaskError {
            meta: generic,
            kind: crate::error::StartExportTaskErrorKind::OperationNotPermittedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartExportTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerInternalErrorException" => crate::error::StartExportTaskError {
            meta: generic,
            kind: crate::error::StartExportTaskErrorKind::ServerInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::server_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_server_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartExportTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::StartExportTaskError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_export_task_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StartExportTaskOutput, crate::error::StartExportTaskError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::start_export_task_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_start_export_task(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::StartExportTaskError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_import_task_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StartImportTaskOutput, crate::error::StartImportTaskError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StartImportTaskError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::StartImportTaskError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationErrorException" => crate::error::StartImportTaskError {
            meta: generic,
            kind: crate::error::StartImportTaskErrorKind::AuthorizationErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::authorization_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_authorization_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartImportTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "HomeRegionNotSetException" => crate::error::StartImportTaskError {
            meta: generic,
            kind: crate::error::StartImportTaskErrorKind::HomeRegionNotSetException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::home_region_not_set_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_home_region_not_set_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartImportTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::StartImportTaskError {
            meta: generic,
            kind: crate::error::StartImportTaskErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartImportTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValueException" => crate::error::StartImportTaskError {
            meta: generic,
            kind: crate::error::StartImportTaskErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartImportTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceInUseException" => crate::error::StartImportTaskError {
            meta: generic,
            kind: crate::error::StartImportTaskErrorKind::ResourceInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartImportTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerInternalErrorException" => crate::error::StartImportTaskError {
            meta: generic,
            kind: crate::error::StartImportTaskErrorKind::ServerInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::server_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_server_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartImportTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::StartImportTaskError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_import_task_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StartImportTaskOutput, crate::error::StartImportTaskError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::start_import_task_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_start_import_task(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::StartImportTaskError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_continuous_export_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StopContinuousExportOutput,
    crate::error::StopContinuousExportError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StopContinuousExportError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::StopContinuousExportError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationErrorException" => crate::error::StopContinuousExportError {
            meta: generic,
            kind: crate::error::StopContinuousExportErrorKind::AuthorizationErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::authorization_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_authorization_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopContinuousExportError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "HomeRegionNotSetException" => crate::error::StopContinuousExportError {
            meta: generic,
            kind: crate::error::StopContinuousExportErrorKind::HomeRegionNotSetException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::home_region_not_set_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_home_region_not_set_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopContinuousExportError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::StopContinuousExportError {
            meta: generic,
            kind: crate::error::StopContinuousExportErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopContinuousExportError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValueException" => crate::error::StopContinuousExportError {
            meta: generic,
            kind: crate::error::StopContinuousExportErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopContinuousExportError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationNotPermittedException" => crate::error::StopContinuousExportError {
            meta: generic,
            kind: crate::error::StopContinuousExportErrorKind::OperationNotPermittedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopContinuousExportError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceInUseException" => crate::error::StopContinuousExportError {
            meta: generic,
            kind: crate::error::StopContinuousExportErrorKind::ResourceInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopContinuousExportError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::StopContinuousExportError {
            meta: generic,
            kind: crate::error::StopContinuousExportErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopContinuousExportError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerInternalErrorException" => crate::error::StopContinuousExportError {
            meta: generic,
            kind: crate::error::StopContinuousExportErrorKind::ServerInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::server_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_server_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopContinuousExportError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::StopContinuousExportError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_continuous_export_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StopContinuousExportOutput,
    crate::error::StopContinuousExportError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::stop_continuous_export_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_stop_continuous_export(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::StopContinuousExportError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_data_collection_by_agent_ids_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StopDataCollectionByAgentIdsOutput,
    crate::error::StopDataCollectionByAgentIdsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StopDataCollectionByAgentIdsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::StopDataCollectionByAgentIdsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationErrorException" => crate::error::StopDataCollectionByAgentIdsError {
            meta: generic,
            kind: crate::error::StopDataCollectionByAgentIdsErrorKind::AuthorizationErrorException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::authorization_error_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_authorization_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopDataCollectionByAgentIdsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "HomeRegionNotSetException" => crate::error::StopDataCollectionByAgentIdsError {
            meta: generic,
            kind: crate::error::StopDataCollectionByAgentIdsErrorKind::HomeRegionNotSetException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::home_region_not_set_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_home_region_not_set_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopDataCollectionByAgentIdsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::StopDataCollectionByAgentIdsError {
            meta: generic,
            kind: crate::error::StopDataCollectionByAgentIdsErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopDataCollectionByAgentIdsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValueException" => crate::error::StopDataCollectionByAgentIdsError {
            meta: generic,
            kind:
                crate::error::StopDataCollectionByAgentIdsErrorKind::InvalidParameterValueException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::invalid_parameter_value_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopDataCollectionByAgentIdsError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "ServerInternalErrorException" => crate::error::StopDataCollectionByAgentIdsError {
            meta: generic,
            kind: crate::error::StopDataCollectionByAgentIdsErrorKind::ServerInternalErrorException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::server_internal_error_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopDataCollectionByAgentIdsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::StopDataCollectionByAgentIdsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_data_collection_by_agent_ids_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StopDataCollectionByAgentIdsOutput,
    crate::error::StopDataCollectionByAgentIdsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::stop_data_collection_by_agent_ids_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_stop_data_collection_by_agent_ids(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::StopDataCollectionByAgentIdsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_application_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateApplicationOutput, crate::error::UpdateApplicationError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateApplicationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateApplicationError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationErrorException" => crate::error::UpdateApplicationError {
            meta: generic,
            kind: crate::error::UpdateApplicationErrorKind::AuthorizationErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::authorization_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_authorization_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateApplicationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "HomeRegionNotSetException" => crate::error::UpdateApplicationError {
            meta: generic,
            kind: crate::error::UpdateApplicationErrorKind::HomeRegionNotSetException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::home_region_not_set_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_home_region_not_set_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateApplicationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::UpdateApplicationError {
            meta: generic,
            kind: crate::error::UpdateApplicationErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateApplicationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValueException" => crate::error::UpdateApplicationError {
            meta: generic,
            kind: crate::error::UpdateApplicationErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateApplicationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerInternalErrorException" => crate::error::UpdateApplicationError {
            meta: generic,
            kind: crate::error::UpdateApplicationErrorKind::ServerInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::server_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_server_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateApplicationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateApplicationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_application_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateApplicationOutput, crate::error::UpdateApplicationError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_application_output::Builder::default();
        let _ = response;
        output.build()
    })
}
