// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// All possible error types for this service.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum Error {
    /// <p>The AWS user account does not have permission to perform the action. Check the IAM policy associated with this account.</p>
    AuthorizationErrorException(crate::error::AuthorizationErrorException),
    /// <p></p>
    ConflictErrorException(crate::error::ConflictErrorException),
    /// <p>The home region is not set. Set the home region to continue.</p>
    HomeRegionNotSetException(crate::error::HomeRegionNotSetException),
    /// <p>One or more parameters are not valid. Verify the parameters and try again.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The value of one or more parameters are either invalid or out of range. Verify the parameter values and try again.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>This operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>This issue occurs when the same <code>clientRequestToken</code> is used with the <code>StartImportTask</code> action, but with different parameters. For example, you use the same request token but have two different import URLs, you can encounter this issue. If the import tasks are meant to be different, use a different <code>clientRequestToken</code>, and try again.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The specified configuration ID was not located. Verify the configuration ID and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The server experienced an internal error. Try again.</p>
    ServerInternalErrorException(crate::error::ServerInternalErrorException),
    /// An unhandled error occurred.
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Error::AuthorizationErrorException(inner) => inner.fmt(f),
            Error::ConflictErrorException(inner) => inner.fmt(f),
            Error::HomeRegionNotSetException(inner) => inner.fmt(f),
            Error::InvalidParameterException(inner) => inner.fmt(f),
            Error::InvalidParameterValueException(inner) => inner.fmt(f),
            Error::OperationNotPermittedException(inner) => inner.fmt(f),
            Error::ResourceInUseException(inner) => inner.fmt(f),
            Error::ResourceNotFoundException(inner) => inner.fmt(f),
            Error::ServerInternalErrorException(inner) => inner.fmt(f),
            Error::Unhandled(inner) => inner.fmt(f),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::AssociateConfigurationItemsToApplicationError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::AssociateConfigurationItemsToApplicationError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::AssociateConfigurationItemsToApplicationErrorKind::AuthorizationErrorException(inner) => Error::AuthorizationErrorException(inner),
                crate::error::AssociateConfigurationItemsToApplicationErrorKind::HomeRegionNotSetException(inner) => Error::HomeRegionNotSetException(inner),
                crate::error::AssociateConfigurationItemsToApplicationErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::AssociateConfigurationItemsToApplicationErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::AssociateConfigurationItemsToApplicationErrorKind::ServerInternalErrorException(inner) => Error::ServerInternalErrorException(inner),
                crate::error::AssociateConfigurationItemsToApplicationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::BatchDeleteImportDataError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::BatchDeleteImportDataError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::BatchDeleteImportDataErrorKind::AuthorizationErrorException(
                    inner,
                ) => Error::AuthorizationErrorException(inner),
                crate::error::BatchDeleteImportDataErrorKind::HomeRegionNotSetException(inner) => {
                    Error::HomeRegionNotSetException(inner)
                }
                crate::error::BatchDeleteImportDataErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::BatchDeleteImportDataErrorKind::InvalidParameterValueException(
                    inner,
                ) => Error::InvalidParameterValueException(inner),
                crate::error::BatchDeleteImportDataErrorKind::ServerInternalErrorException(
                    inner,
                ) => Error::ServerInternalErrorException(inner),
                crate::error::BatchDeleteImportDataErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateApplicationError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateApplicationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateApplicationErrorKind::AuthorizationErrorException(inner) => {
                    Error::AuthorizationErrorException(inner)
                }
                crate::error::CreateApplicationErrorKind::HomeRegionNotSetException(inner) => {
                    Error::HomeRegionNotSetException(inner)
                }
                crate::error::CreateApplicationErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::CreateApplicationErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::CreateApplicationErrorKind::ServerInternalErrorException(inner) => {
                    Error::ServerInternalErrorException(inner)
                }
                crate::error::CreateApplicationErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateTagsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateTagsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateTagsErrorKind::AuthorizationErrorException(inner) => {
                    Error::AuthorizationErrorException(inner)
                }
                crate::error::CreateTagsErrorKind::HomeRegionNotSetException(inner) => {
                    Error::HomeRegionNotSetException(inner)
                }
                crate::error::CreateTagsErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::CreateTagsErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::CreateTagsErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::CreateTagsErrorKind::ServerInternalErrorException(inner) => {
                    Error::ServerInternalErrorException(inner)
                }
                crate::error::CreateTagsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteApplicationsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteApplicationsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteApplicationsErrorKind::AuthorizationErrorException(inner) => {
                    Error::AuthorizationErrorException(inner)
                }
                crate::error::DeleteApplicationsErrorKind::HomeRegionNotSetException(inner) => {
                    Error::HomeRegionNotSetException(inner)
                }
                crate::error::DeleteApplicationsErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::DeleteApplicationsErrorKind::InvalidParameterValueException(
                    inner,
                ) => Error::InvalidParameterValueException(inner),
                crate::error::DeleteApplicationsErrorKind::ServerInternalErrorException(inner) => {
                    Error::ServerInternalErrorException(inner)
                }
                crate::error::DeleteApplicationsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteTagsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteTagsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteTagsErrorKind::AuthorizationErrorException(inner) => {
                    Error::AuthorizationErrorException(inner)
                }
                crate::error::DeleteTagsErrorKind::HomeRegionNotSetException(inner) => {
                    Error::HomeRegionNotSetException(inner)
                }
                crate::error::DeleteTagsErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::DeleteTagsErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::DeleteTagsErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::DeleteTagsErrorKind::ServerInternalErrorException(inner) => {
                    Error::ServerInternalErrorException(inner)
                }
                crate::error::DeleteTagsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeAgentsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DescribeAgentsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeAgentsErrorKind::AuthorizationErrorException(inner) => {
                    Error::AuthorizationErrorException(inner)
                }
                crate::error::DescribeAgentsErrorKind::HomeRegionNotSetException(inner) => {
                    Error::HomeRegionNotSetException(inner)
                }
                crate::error::DescribeAgentsErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::DescribeAgentsErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::DescribeAgentsErrorKind::ServerInternalErrorException(inner) => {
                    Error::ServerInternalErrorException(inner)
                }
                crate::error::DescribeAgentsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeConfigurationsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeConfigurationsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeConfigurationsErrorKind::AuthorizationErrorException(
                    inner,
                ) => Error::AuthorizationErrorException(inner),
                crate::error::DescribeConfigurationsErrorKind::HomeRegionNotSetException(inner) => {
                    Error::HomeRegionNotSetException(inner)
                }
                crate::error::DescribeConfigurationsErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::DescribeConfigurationsErrorKind::InvalidParameterValueException(
                    inner,
                ) => Error::InvalidParameterValueException(inner),
                crate::error::DescribeConfigurationsErrorKind::ServerInternalErrorException(
                    inner,
                ) => Error::ServerInternalErrorException(inner),
                crate::error::DescribeConfigurationsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeContinuousExportsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeContinuousExportsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeContinuousExportsErrorKind::AuthorizationErrorException(inner) => Error::AuthorizationErrorException(inner),
                crate::error::DescribeContinuousExportsErrorKind::HomeRegionNotSetException(inner) => Error::HomeRegionNotSetException(inner),
                crate::error::DescribeContinuousExportsErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::DescribeContinuousExportsErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::DescribeContinuousExportsErrorKind::OperationNotPermittedException(inner) => Error::OperationNotPermittedException(inner),
                crate::error::DescribeContinuousExportsErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::DescribeContinuousExportsErrorKind::ServerInternalErrorException(inner) => Error::ServerInternalErrorException(inner),
                crate::error::DescribeContinuousExportsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeExportConfigurationsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeExportConfigurationsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeExportConfigurationsErrorKind::AuthorizationErrorException(inner) => Error::AuthorizationErrorException(inner),
                crate::error::DescribeExportConfigurationsErrorKind::HomeRegionNotSetException(inner) => Error::HomeRegionNotSetException(inner),
                crate::error::DescribeExportConfigurationsErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::DescribeExportConfigurationsErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::DescribeExportConfigurationsErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::DescribeExportConfigurationsErrorKind::ServerInternalErrorException(inner) => Error::ServerInternalErrorException(inner),
                crate::error::DescribeExportConfigurationsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeExportTasksError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeExportTasksError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeExportTasksErrorKind::AuthorizationErrorException(inner) => {
                    Error::AuthorizationErrorException(inner)
                }
                crate::error::DescribeExportTasksErrorKind::HomeRegionNotSetException(inner) => {
                    Error::HomeRegionNotSetException(inner)
                }
                crate::error::DescribeExportTasksErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::DescribeExportTasksErrorKind::InvalidParameterValueException(
                    inner,
                ) => Error::InvalidParameterValueException(inner),
                crate::error::DescribeExportTasksErrorKind::ServerInternalErrorException(inner) => {
                    Error::ServerInternalErrorException(inner)
                }
                crate::error::DescribeExportTasksErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeImportTasksError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeImportTasksError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeImportTasksErrorKind::AuthorizationErrorException(inner) => {
                    Error::AuthorizationErrorException(inner)
                }
                crate::error::DescribeImportTasksErrorKind::HomeRegionNotSetException(inner) => {
                    Error::HomeRegionNotSetException(inner)
                }
                crate::error::DescribeImportTasksErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::DescribeImportTasksErrorKind::InvalidParameterValueException(
                    inner,
                ) => Error::InvalidParameterValueException(inner),
                crate::error::DescribeImportTasksErrorKind::ServerInternalErrorException(inner) => {
                    Error::ServerInternalErrorException(inner)
                }
                crate::error::DescribeImportTasksErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeTagsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DescribeTagsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeTagsErrorKind::AuthorizationErrorException(inner) => {
                    Error::AuthorizationErrorException(inner)
                }
                crate::error::DescribeTagsErrorKind::HomeRegionNotSetException(inner) => {
                    Error::HomeRegionNotSetException(inner)
                }
                crate::error::DescribeTagsErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::DescribeTagsErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::DescribeTagsErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::DescribeTagsErrorKind::ServerInternalErrorException(inner) => {
                    Error::ServerInternalErrorException(inner)
                }
                crate::error::DescribeTagsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::DisassociateConfigurationItemsFromApplicationError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DisassociateConfigurationItemsFromApplicationError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DisassociateConfigurationItemsFromApplicationErrorKind::AuthorizationErrorException(inner) => Error::AuthorizationErrorException(inner),
                crate::error::DisassociateConfigurationItemsFromApplicationErrorKind::HomeRegionNotSetException(inner) => Error::HomeRegionNotSetException(inner),
                crate::error::DisassociateConfigurationItemsFromApplicationErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::DisassociateConfigurationItemsFromApplicationErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::DisassociateConfigurationItemsFromApplicationErrorKind::ServerInternalErrorException(inner) => Error::ServerInternalErrorException(inner),
                crate::error::DisassociateConfigurationItemsFromApplicationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ExportConfigurationsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ExportConfigurationsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ExportConfigurationsErrorKind::AuthorizationErrorException(inner) => {
                    Error::AuthorizationErrorException(inner)
                }
                crate::error::ExportConfigurationsErrorKind::HomeRegionNotSetException(inner) => {
                    Error::HomeRegionNotSetException(inner)
                }
                crate::error::ExportConfigurationsErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::ExportConfigurationsErrorKind::InvalidParameterValueException(
                    inner,
                ) => Error::InvalidParameterValueException(inner),
                crate::error::ExportConfigurationsErrorKind::OperationNotPermittedException(
                    inner,
                ) => Error::OperationNotPermittedException(inner),
                crate::error::ExportConfigurationsErrorKind::ServerInternalErrorException(
                    inner,
                ) => Error::ServerInternalErrorException(inner),
                crate::error::ExportConfigurationsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetDiscoverySummaryError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetDiscoverySummaryError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetDiscoverySummaryErrorKind::AuthorizationErrorException(inner) => {
                    Error::AuthorizationErrorException(inner)
                }
                crate::error::GetDiscoverySummaryErrorKind::HomeRegionNotSetException(inner) => {
                    Error::HomeRegionNotSetException(inner)
                }
                crate::error::GetDiscoverySummaryErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::GetDiscoverySummaryErrorKind::InvalidParameterValueException(
                    inner,
                ) => Error::InvalidParameterValueException(inner),
                crate::error::GetDiscoverySummaryErrorKind::ServerInternalErrorException(inner) => {
                    Error::ServerInternalErrorException(inner)
                }
                crate::error::GetDiscoverySummaryErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListConfigurationsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListConfigurationsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListConfigurationsErrorKind::AuthorizationErrorException(inner) => {
                    Error::AuthorizationErrorException(inner)
                }
                crate::error::ListConfigurationsErrorKind::HomeRegionNotSetException(inner) => {
                    Error::HomeRegionNotSetException(inner)
                }
                crate::error::ListConfigurationsErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::ListConfigurationsErrorKind::InvalidParameterValueException(
                    inner,
                ) => Error::InvalidParameterValueException(inner),
                crate::error::ListConfigurationsErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::ListConfigurationsErrorKind::ServerInternalErrorException(inner) => {
                    Error::ServerInternalErrorException(inner)
                }
                crate::error::ListConfigurationsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListServerNeighborsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListServerNeighborsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListServerNeighborsErrorKind::AuthorizationErrorException(inner) => {
                    Error::AuthorizationErrorException(inner)
                }
                crate::error::ListServerNeighborsErrorKind::HomeRegionNotSetException(inner) => {
                    Error::HomeRegionNotSetException(inner)
                }
                crate::error::ListServerNeighborsErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::ListServerNeighborsErrorKind::InvalidParameterValueException(
                    inner,
                ) => Error::InvalidParameterValueException(inner),
                crate::error::ListServerNeighborsErrorKind::ServerInternalErrorException(inner) => {
                    Error::ServerInternalErrorException(inner)
                }
                crate::error::ListServerNeighborsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartContinuousExportError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StartContinuousExportError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StartContinuousExportErrorKind::AuthorizationErrorException(
                    inner,
                ) => Error::AuthorizationErrorException(inner),
                crate::error::StartContinuousExportErrorKind::ConflictErrorException(inner) => {
                    Error::ConflictErrorException(inner)
                }
                crate::error::StartContinuousExportErrorKind::HomeRegionNotSetException(inner) => {
                    Error::HomeRegionNotSetException(inner)
                }
                crate::error::StartContinuousExportErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::StartContinuousExportErrorKind::InvalidParameterValueException(
                    inner,
                ) => Error::InvalidParameterValueException(inner),
                crate::error::StartContinuousExportErrorKind::OperationNotPermittedException(
                    inner,
                ) => Error::OperationNotPermittedException(inner),
                crate::error::StartContinuousExportErrorKind::ResourceInUseException(inner) => {
                    Error::ResourceInUseException(inner)
                }
                crate::error::StartContinuousExportErrorKind::ServerInternalErrorException(
                    inner,
                ) => Error::ServerInternalErrorException(inner),
                crate::error::StartContinuousExportErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartDataCollectionByAgentIdsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StartDataCollectionByAgentIdsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::StartDataCollectionByAgentIdsErrorKind::AuthorizationErrorException(inner) => Error::AuthorizationErrorException(inner),
                crate::error::StartDataCollectionByAgentIdsErrorKind::HomeRegionNotSetException(inner) => Error::HomeRegionNotSetException(inner),
                crate::error::StartDataCollectionByAgentIdsErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::StartDataCollectionByAgentIdsErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::StartDataCollectionByAgentIdsErrorKind::ServerInternalErrorException(inner) => Error::ServerInternalErrorException(inner),
                crate::error::StartDataCollectionByAgentIdsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartExportTaskError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::StartExportTaskError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StartExportTaskErrorKind::AuthorizationErrorException(inner) => {
                    Error::AuthorizationErrorException(inner)
                }
                crate::error::StartExportTaskErrorKind::HomeRegionNotSetException(inner) => {
                    Error::HomeRegionNotSetException(inner)
                }
                crate::error::StartExportTaskErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::StartExportTaskErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::StartExportTaskErrorKind::OperationNotPermittedException(inner) => {
                    Error::OperationNotPermittedException(inner)
                }
                crate::error::StartExportTaskErrorKind::ServerInternalErrorException(inner) => {
                    Error::ServerInternalErrorException(inner)
                }
                crate::error::StartExportTaskErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartImportTaskError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::StartImportTaskError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StartImportTaskErrorKind::AuthorizationErrorException(inner) => {
                    Error::AuthorizationErrorException(inner)
                }
                crate::error::StartImportTaskErrorKind::HomeRegionNotSetException(inner) => {
                    Error::HomeRegionNotSetException(inner)
                }
                crate::error::StartImportTaskErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::StartImportTaskErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::StartImportTaskErrorKind::ResourceInUseException(inner) => {
                    Error::ResourceInUseException(inner)
                }
                crate::error::StartImportTaskErrorKind::ServerInternalErrorException(inner) => {
                    Error::ServerInternalErrorException(inner)
                }
                crate::error::StartImportTaskErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StopContinuousExportError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StopContinuousExportError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StopContinuousExportErrorKind::AuthorizationErrorException(inner) => {
                    Error::AuthorizationErrorException(inner)
                }
                crate::error::StopContinuousExportErrorKind::HomeRegionNotSetException(inner) => {
                    Error::HomeRegionNotSetException(inner)
                }
                crate::error::StopContinuousExportErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::StopContinuousExportErrorKind::InvalidParameterValueException(
                    inner,
                ) => Error::InvalidParameterValueException(inner),
                crate::error::StopContinuousExportErrorKind::OperationNotPermittedException(
                    inner,
                ) => Error::OperationNotPermittedException(inner),
                crate::error::StopContinuousExportErrorKind::ResourceInUseException(inner) => {
                    Error::ResourceInUseException(inner)
                }
                crate::error::StopContinuousExportErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::StopContinuousExportErrorKind::ServerInternalErrorException(
                    inner,
                ) => Error::ServerInternalErrorException(inner),
                crate::error::StopContinuousExportErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StopDataCollectionByAgentIdsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StopDataCollectionByAgentIdsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::StopDataCollectionByAgentIdsErrorKind::AuthorizationErrorException(inner) => Error::AuthorizationErrorException(inner),
                crate::error::StopDataCollectionByAgentIdsErrorKind::HomeRegionNotSetException(inner) => Error::HomeRegionNotSetException(inner),
                crate::error::StopDataCollectionByAgentIdsErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::StopDataCollectionByAgentIdsErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::StopDataCollectionByAgentIdsErrorKind::ServerInternalErrorException(inner) => Error::ServerInternalErrorException(inner),
                crate::error::StopDataCollectionByAgentIdsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateApplicationError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateApplicationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateApplicationErrorKind::AuthorizationErrorException(inner) => {
                    Error::AuthorizationErrorException(inner)
                }
                crate::error::UpdateApplicationErrorKind::HomeRegionNotSetException(inner) => {
                    Error::HomeRegionNotSetException(inner)
                }
                crate::error::UpdateApplicationErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::UpdateApplicationErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::UpdateApplicationErrorKind::ServerInternalErrorException(inner) => {
                    Error::ServerInternalErrorException(inner)
                }
                crate::error::UpdateApplicationErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl std::error::Error for Error {}
