// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for AWS Application Discovery Service
///
/// Client for invoking operations on AWS Application Discovery Service. Each operation on AWS Application Discovery Service is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_applicationdiscovery::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
/// let shared_config = aws_config::load_from_env().await;
/// let config = aws_sdk_applicationdiscovery::config::Builder::from(&shared_config)
///   .retry_config(RetryConfig::disabled())
///   .build();
/// let client = aws_sdk_applicationdiscovery::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AssociateConfigurationItemsToApplication`](crate::client::fluent_builders::AssociateConfigurationItemsToApplication) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_configuration_id(impl Into<String>)`](crate::client::fluent_builders::AssociateConfigurationItemsToApplication::application_configuration_id) / [`set_application_configuration_id(Option<String>)`](crate::client::fluent_builders::AssociateConfigurationItemsToApplication::set_application_configuration_id): <p>The configuration ID of an application with which items are to be associated.</p>
    ///   - [`configuration_ids(Vec<String>)`](crate::client::fluent_builders::AssociateConfigurationItemsToApplication::configuration_ids) / [`set_configuration_ids(Option<Vec<String>>)`](crate::client::fluent_builders::AssociateConfigurationItemsToApplication::set_configuration_ids): <p>The ID of each configuration item to be associated with an application.</p>
    /// - On success, responds with [`AssociateConfigurationItemsToApplicationOutput`](crate::output::AssociateConfigurationItemsToApplicationOutput)

    /// - On failure, responds with [`SdkError<AssociateConfigurationItemsToApplicationError>`](crate::error::AssociateConfigurationItemsToApplicationError)
    pub fn associate_configuration_items_to_application(
        &self,
    ) -> fluent_builders::AssociateConfigurationItemsToApplication {
        fluent_builders::AssociateConfigurationItemsToApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchDeleteImportData`](crate::client::fluent_builders::BatchDeleteImportData) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`import_task_ids(Vec<String>)`](crate::client::fluent_builders::BatchDeleteImportData::import_task_ids) / [`set_import_task_ids(Option<Vec<String>>)`](crate::client::fluent_builders::BatchDeleteImportData::set_import_task_ids): <p>The IDs for the import tasks that you want to delete.</p>
    /// - On success, responds with [`BatchDeleteImportDataOutput`](crate::output::BatchDeleteImportDataOutput) with field(s):
    ///   - [`errors(Option<Vec<BatchDeleteImportDataError>>)`](crate::output::BatchDeleteImportDataOutput::errors): <p>Error messages returned for each import task that you deleted as a response for this command.</p>
    /// - On failure, responds with [`SdkError<BatchDeleteImportDataError>`](crate::error::BatchDeleteImportDataError)
    pub fn batch_delete_import_data(&self) -> fluent_builders::BatchDeleteImportData {
        fluent_builders::BatchDeleteImportData::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateApplication`](crate::client::fluent_builders::CreateApplication) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateApplication::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateApplication::set_name): <p>Name of the application to be created.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateApplication::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateApplication::set_description): <p>Description of the application to be created.</p>
    /// - On success, responds with [`CreateApplicationOutput`](crate::output::CreateApplicationOutput) with field(s):
    ///   - [`configuration_id(Option<String>)`](crate::output::CreateApplicationOutput::configuration_id): <p>Configuration ID of an application to be created.</p>
    /// - On failure, responds with [`SdkError<CreateApplicationError>`](crate::error::CreateApplicationError)
    pub fn create_application(&self) -> fluent_builders::CreateApplication {
        fluent_builders::CreateApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateTags`](crate::client::fluent_builders::CreateTags) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_ids(Vec<String>)`](crate::client::fluent_builders::CreateTags::configuration_ids) / [`set_configuration_ids(Option<Vec<String>>)`](crate::client::fluent_builders::CreateTags::set_configuration_ids): <p>A list of configuration items that you want to tag.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateTags::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateTags::set_tags): <p>Tags that you want to associate with one or more configuration items. Specify the tags that you want to create in a <i>key</i>-<i>value</i> format. For example:</p>  <p> <code>{"key": "serverType", "value": "webServer"}</code> </p>
    /// - On success, responds with [`CreateTagsOutput`](crate::output::CreateTagsOutput)

    /// - On failure, responds with [`SdkError<CreateTagsError>`](crate::error::CreateTagsError)
    pub fn create_tags(&self) -> fluent_builders::CreateTags {
        fluent_builders::CreateTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteApplications`](crate::client::fluent_builders::DeleteApplications) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_ids(Vec<String>)`](crate::client::fluent_builders::DeleteApplications::configuration_ids) / [`set_configuration_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DeleteApplications::set_configuration_ids): <p>Configuration ID of an application to be deleted.</p>
    /// - On success, responds with [`DeleteApplicationsOutput`](crate::output::DeleteApplicationsOutput)

    /// - On failure, responds with [`SdkError<DeleteApplicationsError>`](crate::error::DeleteApplicationsError)
    pub fn delete_applications(&self) -> fluent_builders::DeleteApplications {
        fluent_builders::DeleteApplications::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteTags`](crate::client::fluent_builders::DeleteTags) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_ids(Vec<String>)`](crate::client::fluent_builders::DeleteTags::configuration_ids) / [`set_configuration_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DeleteTags::set_configuration_ids): <p>A list of configuration items with tags that you want to delete.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::DeleteTags::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::DeleteTags::set_tags): <p>Tags that you want to delete from one or more configuration items. Specify the tags that you want to delete in a <i>key</i>-<i>value</i> format. For example:</p>  <p> <code>{"key": "serverType", "value": "webServer"}</code> </p>
    /// - On success, responds with [`DeleteTagsOutput`](crate::output::DeleteTagsOutput)

    /// - On failure, responds with [`SdkError<DeleteTagsError>`](crate::error::DeleteTagsError)
    pub fn delete_tags(&self) -> fluent_builders::DeleteTags {
        fluent_builders::DeleteTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAgents`](crate::client::fluent_builders::DescribeAgents) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`agent_ids(Vec<String>)`](crate::client::fluent_builders::DescribeAgents::agent_ids) / [`set_agent_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeAgents::set_agent_ids): <p>The agent or the Connector IDs for which you want information. If you specify no IDs, the system returns information about all agents/Connectors associated with your AWS user account.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeAgents::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeAgents::set_filters): <p>You can filter the request using various logical operators and a <i>key</i>-<i>value</i> format. For example: </p>  <p> <code>{"key": "collectionStatus", "value": "STARTED"}</code> </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeAgents::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::DescribeAgents::set_max_results): <p>The total number of agents/Connectors to return in a single page of output. The maximum value is 100.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeAgents::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeAgents::set_next_token): <p>Token to retrieve the next set of results. For example, if you previously specified 100 IDs for <code>DescribeAgentsRequest$agentIds</code> but set <code>DescribeAgentsRequest$maxResults</code> to 10, you received a set of 10 results along with a token. Use that token in this query to get the next set of 10.</p>
    /// - On success, responds with [`DescribeAgentsOutput`](crate::output::DescribeAgentsOutput) with field(s):
    ///   - [`agents_info(Option<Vec<AgentInfo>>)`](crate::output::DescribeAgentsOutput::agents_info): <p>Lists agents or the Connector by ID or lists all agents/Connectors associated with your user account if you did not specify an agent/Connector ID. The output includes agent/Connector IDs, IP addresses, media access control (MAC) addresses, agent/Connector health, host name where the agent/Connector resides, and the version number of each agent/Connector.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeAgentsOutput::next_token): <p>Token to retrieve the next set of results. For example, if you specified 100 IDs for <code>DescribeAgentsRequest$agentIds</code> but set <code>DescribeAgentsRequest$maxResults</code> to 10, you received a set of 10 results along with this token. Use this token in the next query to retrieve the next set of 10.</p>
    /// - On failure, responds with [`SdkError<DescribeAgentsError>`](crate::error::DescribeAgentsError)
    pub fn describe_agents(&self) -> fluent_builders::DescribeAgents {
        fluent_builders::DescribeAgents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeConfigurations`](crate::client::fluent_builders::DescribeConfigurations) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_ids(Vec<String>)`](crate::client::fluent_builders::DescribeConfigurations::configuration_ids) / [`set_configuration_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeConfigurations::set_configuration_ids): <p>One or more configuration IDs.</p>
    /// - On success, responds with [`DescribeConfigurationsOutput`](crate::output::DescribeConfigurationsOutput) with field(s):
    ///   - [`configurations(Option<Vec<HashMap<String, String>>>)`](crate::output::DescribeConfigurationsOutput::configurations): <p>A key in the response map. The value is an array of data.</p>
    /// - On failure, responds with [`SdkError<DescribeConfigurationsError>`](crate::error::DescribeConfigurationsError)
    pub fn describe_configurations(&self) -> fluent_builders::DescribeConfigurations {
        fluent_builders::DescribeConfigurations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeContinuousExports`](crate::client::fluent_builders::DescribeContinuousExports) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeContinuousExports::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`export_ids(Vec<String>)`](crate::client::fluent_builders::DescribeContinuousExports::export_ids) / [`set_export_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeContinuousExports::set_export_ids): <p>The unique IDs assigned to the exports.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeContinuousExports::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeContinuousExports::set_max_results): <p>A number between 1 and 100 specifying the maximum number of continuous export descriptions returned.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeContinuousExports::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeContinuousExports::set_next_token): <p>The token from the previous call to <code>DescribeExportTasks</code>.</p>
    /// - On success, responds with [`DescribeContinuousExportsOutput`](crate::output::DescribeContinuousExportsOutput) with field(s):
    ///   - [`descriptions(Option<Vec<ContinuousExportDescription>>)`](crate::output::DescribeContinuousExportsOutput::descriptions): <p>A list of continuous export descriptions.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeContinuousExportsOutput::next_token): <p>The token from the previous call to <code>DescribeExportTasks</code>.</p>
    /// - On failure, responds with [`SdkError<DescribeContinuousExportsError>`](crate::error::DescribeContinuousExportsError)
    pub fn describe_continuous_exports(&self) -> fluent_builders::DescribeContinuousExports {
        fluent_builders::DescribeContinuousExports::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeExportConfigurations`](crate::client::fluent_builders::DescribeExportConfigurations) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`export_ids(Vec<String>)`](crate::client::fluent_builders::DescribeExportConfigurations::export_ids) / [`set_export_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeExportConfigurations::set_export_ids): <p>A list of continuous export IDs to search for.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeExportConfigurations::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::DescribeExportConfigurations::set_max_results): <p>A number between 1 and 100 specifying the maximum number of continuous export descriptions returned.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeExportConfigurations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeExportConfigurations::set_next_token): <p>The token from the previous call to describe-export-tasks.</p>
    /// - On success, responds with [`DescribeExportConfigurationsOutput`](crate::output::DescribeExportConfigurationsOutput) with field(s):
    ///   - [`exports_info(Option<Vec<ExportInfo>>)`](crate::output::DescribeExportConfigurationsOutput::exports_info): <p></p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeExportConfigurationsOutput::next_token): <p>The token from the previous call to describe-export-tasks.</p>
    /// - On failure, responds with [`SdkError<DescribeExportConfigurationsError>`](crate::error::DescribeExportConfigurationsError)
    pub fn describe_export_configurations(&self) -> fluent_builders::DescribeExportConfigurations {
        fluent_builders::DescribeExportConfigurations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeExportTasks`](crate::client::fluent_builders::DescribeExportTasks) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`export_ids(Vec<String>)`](crate::client::fluent_builders::DescribeExportTasks::export_ids) / [`set_export_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeExportTasks::set_export_ids): <p>One or more unique identifiers used to query the status of an export request.</p>
    ///   - [`filters(Vec<ExportFilter>)`](crate::client::fluent_builders::DescribeExportTasks::filters) / [`set_filters(Option<Vec<ExportFilter>>)`](crate::client::fluent_builders::DescribeExportTasks::set_filters): <p>One or more filters.</p>  <ul>   <li> <p> <code>AgentId</code> - ID of the agent whose collected data will be exported</p> </li>  </ul>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeExportTasks::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::DescribeExportTasks::set_max_results): <p>The maximum number of volume results returned by <code>DescribeExportTasks</code> in paginated output. When this parameter is used, <code>DescribeExportTasks</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeExportTasks::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeExportTasks::set_next_token): <p>The <code>nextToken</code> value returned from a previous paginated <code>DescribeExportTasks</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. This value is null when there are no more results to return.</p>
    /// - On success, responds with [`DescribeExportTasksOutput`](crate::output::DescribeExportTasksOutput) with field(s):
    ///   - [`exports_info(Option<Vec<ExportInfo>>)`](crate::output::DescribeExportTasksOutput::exports_info): <p>Contains one or more sets of export request details. When the status of a request is <code>SUCCEEDED</code>, the response includes a URL for an Amazon S3 bucket where you can view the data in a CSV file.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeExportTasksOutput::next_token): <p>The <code>nextToken</code> value to include in a future <code>DescribeExportTasks</code> request. When the results of a <code>DescribeExportTasks</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is null when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeExportTasksError>`](crate::error::DescribeExportTasksError)
    pub fn describe_export_tasks(&self) -> fluent_builders::DescribeExportTasks {
        fluent_builders::DescribeExportTasks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeImportTasks`](crate::client::fluent_builders::DescribeImportTasks) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeImportTasks::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<ImportTaskFilter>)`](crate::client::fluent_builders::DescribeImportTasks::filters) / [`set_filters(Option<Vec<ImportTaskFilter>>)`](crate::client::fluent_builders::DescribeImportTasks::set_filters): <p>An array of name-value pairs that you provide to filter the results for the <code>DescribeImportTask</code> request to a specific subset of results. Currently, wildcard values aren't supported for filters.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeImportTasks::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeImportTasks::set_max_results): <p>The maximum number of results that you want this request to return, up to 100.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeImportTasks::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeImportTasks::set_next_token): <p>The token to request a specific page of results.</p>
    /// - On success, responds with [`DescribeImportTasksOutput`](crate::output::DescribeImportTasksOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::DescribeImportTasksOutput::next_token): <p>The token to request the next page of results.</p>
    ///   - [`tasks(Option<Vec<ImportTask>>)`](crate::output::DescribeImportTasksOutput::tasks): <p>A returned array of import tasks that match any applied filters, up to the specified number of maximum results.</p>
    /// - On failure, responds with [`SdkError<DescribeImportTasksError>`](crate::error::DescribeImportTasksError)
    pub fn describe_import_tasks(&self) -> fluent_builders::DescribeImportTasks {
        fluent_builders::DescribeImportTasks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeTags`](crate::client::fluent_builders::DescribeTags) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<TagFilter>)`](crate::client::fluent_builders::DescribeTags::filters) / [`set_filters(Option<Vec<TagFilter>>)`](crate::client::fluent_builders::DescribeTags::set_filters): <p>You can filter the list using a <i>key</i>-<i>value</i> format. You can separate these items by using logical operators. Allowed filters include <code>tagKey</code>, <code>tagValue</code>, and <code>configurationId</code>. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeTags::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::DescribeTags::set_max_results): <p>The total number of items to return in a single page of output. The maximum value is 100.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeTags::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeTags::set_next_token): <p>A token to start the list. Use this token to get the next set of results.</p>
    /// - On success, responds with [`DescribeTagsOutput`](crate::output::DescribeTagsOutput) with field(s):
    ///   - [`tags(Option<Vec<ConfigurationTag>>)`](crate::output::DescribeTagsOutput::tags): <p>Depending on the input, this is a list of configuration items tagged with a specific tag, or a list of tags for a specific configuration item.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeTagsOutput::next_token): <p>The call returns a token. Use this token to get the next set of results.</p>
    /// - On failure, responds with [`SdkError<DescribeTagsError>`](crate::error::DescribeTagsError)
    pub fn describe_tags(&self) -> fluent_builders::DescribeTags {
        fluent_builders::DescribeTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateConfigurationItemsFromApplication`](crate::client::fluent_builders::DisassociateConfigurationItemsFromApplication) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_configuration_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateConfigurationItemsFromApplication::application_configuration_id) / [`set_application_configuration_id(Option<String>)`](crate::client::fluent_builders::DisassociateConfigurationItemsFromApplication::set_application_configuration_id): <p>Configuration ID of an application from which each item is disassociated.</p>
    ///   - [`configuration_ids(Vec<String>)`](crate::client::fluent_builders::DisassociateConfigurationItemsFromApplication::configuration_ids) / [`set_configuration_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DisassociateConfigurationItemsFromApplication::set_configuration_ids): <p>Configuration ID of each item to be disassociated from an application.</p>
    /// - On success, responds with [`DisassociateConfigurationItemsFromApplicationOutput`](crate::output::DisassociateConfigurationItemsFromApplicationOutput)

    /// - On failure, responds with [`SdkError<DisassociateConfigurationItemsFromApplicationError>`](crate::error::DisassociateConfigurationItemsFromApplicationError)
    pub fn disassociate_configuration_items_from_application(
        &self,
    ) -> fluent_builders::DisassociateConfigurationItemsFromApplication {
        fluent_builders::DisassociateConfigurationItemsFromApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ExportConfigurations`](crate::client::fluent_builders::ExportConfigurations) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::ExportConfigurations::send) it.

    /// - On success, responds with [`ExportConfigurationsOutput`](crate::output::ExportConfigurationsOutput) with field(s):
    ///   - [`export_id(Option<String>)`](crate::output::ExportConfigurationsOutput::export_id): <p>A unique identifier that you can use to query the export status.</p>
    /// - On failure, responds with [`SdkError<ExportConfigurationsError>`](crate::error::ExportConfigurationsError)
    pub fn export_configurations(&self) -> fluent_builders::ExportConfigurations {
        fluent_builders::ExportConfigurations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDiscoverySummary`](crate::client::fluent_builders::GetDiscoverySummary) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::GetDiscoverySummary::send) it.

    /// - On success, responds with [`GetDiscoverySummaryOutput`](crate::output::GetDiscoverySummaryOutput) with field(s):
    ///   - [`servers(i64)`](crate::output::GetDiscoverySummaryOutput::servers): <p>The number of servers discovered.</p>
    ///   - [`applications(i64)`](crate::output::GetDiscoverySummaryOutput::applications): <p>The number of applications discovered.</p>
    ///   - [`servers_mapped_to_applications(i64)`](crate::output::GetDiscoverySummaryOutput::servers_mapped_to_applications): <p>The number of servers mapped to applications.</p>
    ///   - [`servers_mappedto_tags(i64)`](crate::output::GetDiscoverySummaryOutput::servers_mappedto_tags): <p>The number of servers mapped to tags.</p>
    ///   - [`agent_summary(Option<CustomerAgentInfo>)`](crate::output::GetDiscoverySummaryOutput::agent_summary): <p>Details about discovered agents, including agent status and health.</p>
    ///   - [`connector_summary(Option<CustomerConnectorInfo>)`](crate::output::GetDiscoverySummaryOutput::connector_summary): <p>Details about discovered connectors, including connector status and health.</p>
    /// - On failure, responds with [`SdkError<GetDiscoverySummaryError>`](crate::error::GetDiscoverySummaryError)
    pub fn get_discovery_summary(&self) -> fluent_builders::GetDiscoverySummary {
        fluent_builders::GetDiscoverySummary::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListConfigurations`](crate::client::fluent_builders::ListConfigurations) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_type(ConfigurationItemType)`](crate::client::fluent_builders::ListConfigurations::configuration_type) / [`set_configuration_type(Option<ConfigurationItemType>)`](crate::client::fluent_builders::ListConfigurations::set_configuration_type): <p>A valid configuration identified by Application Discovery Service. </p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::ListConfigurations::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::ListConfigurations::set_filters): <p>You can filter the request using various logical operators and a <i>key</i>-<i>value</i> format. For example: </p>  <p> <code>{"key": "serverType", "value": "webServer"}</code> </p>  <p>For a complete list of filter options and guidance about using them with this action, see <a href="https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-api-queries.html#ListConfigurations">Using the ListConfigurations Action</a> in the <i>AWS Application Discovery Service User Guide</i>.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListConfigurations::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListConfigurations::set_max_results): <p>The total number of items to return. The maximum value is 100.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListConfigurations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListConfigurations::set_next_token): <p>Token to retrieve the next set of results. For example, if a previous call to ListConfigurations returned 100 items, but you set <code>ListConfigurationsRequest$maxResults</code> to 10, you received a set of 10 results along with a token. Use that token in this query to get the next set of 10.</p>
    ///   - [`order_by(Vec<OrderByElement>)`](crate::client::fluent_builders::ListConfigurations::order_by) / [`set_order_by(Option<Vec<OrderByElement>>)`](crate::client::fluent_builders::ListConfigurations::set_order_by): <p>Certain filter criteria return output that can be sorted in ascending or descending order. For a list of output characteristics for each filter, see <a href="https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-api-queries.html#ListConfigurations">Using the ListConfigurations Action</a> in the <i>AWS Application Discovery Service User Guide</i>.</p>
    /// - On success, responds with [`ListConfigurationsOutput`](crate::output::ListConfigurationsOutput) with field(s):
    ///   - [`configurations(Option<Vec<HashMap<String, String>>>)`](crate::output::ListConfigurationsOutput::configurations): <p>Returns configuration details, including the configuration ID, attribute names, and attribute values.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListConfigurationsOutput::next_token): <p>Token to retrieve the next set of results. For example, if your call to ListConfigurations returned 100 items, but you set <code>ListConfigurationsRequest$maxResults</code> to 10, you received a set of 10 results along with this token. Use this token in the next query to retrieve the next set of 10.</p>
    /// - On failure, responds with [`SdkError<ListConfigurationsError>`](crate::error::ListConfigurationsError)
    pub fn list_configurations(&self) -> fluent_builders::ListConfigurations {
        fluent_builders::ListConfigurations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListServerNeighbors`](crate::client::fluent_builders::ListServerNeighbors) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_id(impl Into<String>)`](crate::client::fluent_builders::ListServerNeighbors::configuration_id) / [`set_configuration_id(Option<String>)`](crate::client::fluent_builders::ListServerNeighbors::set_configuration_id): <p>Configuration ID of the server for which neighbors are being listed.</p>
    ///   - [`port_information_needed(bool)`](crate::client::fluent_builders::ListServerNeighbors::port_information_needed) / [`set_port_information_needed(bool)`](crate::client::fluent_builders::ListServerNeighbors::set_port_information_needed): <p>Flag to indicate if port and protocol information is needed as part of the response.</p>
    ///   - [`neighbor_configuration_ids(Vec<String>)`](crate::client::fluent_builders::ListServerNeighbors::neighbor_configuration_ids) / [`set_neighbor_configuration_ids(Option<Vec<String>>)`](crate::client::fluent_builders::ListServerNeighbors::set_neighbor_configuration_ids): <p>List of configuration IDs to test for one-hop-away.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListServerNeighbors::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListServerNeighbors::set_max_results): <p>Maximum number of results to return in a single page of output.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListServerNeighbors::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListServerNeighbors::set_next_token): <p>Token to retrieve the next set of results. For example, if you previously specified 100 IDs for <code>ListServerNeighborsRequest$neighborConfigurationIds</code> but set <code>ListServerNeighborsRequest$maxResults</code> to 10, you received a set of 10 results along with a token. Use that token in this query to get the next set of 10.</p>
    /// - On success, responds with [`ListServerNeighborsOutput`](crate::output::ListServerNeighborsOutput) with field(s):
    ///   - [`neighbors(Option<Vec<NeighborConnectionDetail>>)`](crate::output::ListServerNeighborsOutput::neighbors): <p>List of distinct servers that are one hop away from the given server.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListServerNeighborsOutput::next_token): <p>Token to retrieve the next set of results. For example, if you specified 100 IDs for <code>ListServerNeighborsRequest$neighborConfigurationIds</code> but set <code>ListServerNeighborsRequest$maxResults</code> to 10, you received a set of 10 results along with this token. Use this token in the next query to retrieve the next set of 10.</p>
    ///   - [`known_dependency_count(i64)`](crate::output::ListServerNeighborsOutput::known_dependency_count): <p>Count of distinct servers that are one hop away from the given server.</p>
    /// - On failure, responds with [`SdkError<ListServerNeighborsError>`](crate::error::ListServerNeighborsError)
    pub fn list_server_neighbors(&self) -> fluent_builders::ListServerNeighbors {
        fluent_builders::ListServerNeighbors::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartContinuousExport`](crate::client::fluent_builders::StartContinuousExport) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::StartContinuousExport::send) it.

    /// - On success, responds with [`StartContinuousExportOutput`](crate::output::StartContinuousExportOutput) with field(s):
    ///   - [`export_id(Option<String>)`](crate::output::StartContinuousExportOutput::export_id): <p>The unique ID assigned to this export.</p>
    ///   - [`s3_bucket(Option<String>)`](crate::output::StartContinuousExportOutput::s3_bucket): <p>The name of the s3 bucket where the export data parquet files are stored.</p>
    ///   - [`start_time(Option<DateTime>)`](crate::output::StartContinuousExportOutput::start_time): <p>The timestamp representing when the continuous export was started.</p>
    ///   - [`data_source(Option<DataSource>)`](crate::output::StartContinuousExportOutput::data_source): <p>The type of data collector used to gather this data (currently only offered for AGENT).</p>
    ///   - [`schema_storage_config(Option<HashMap<String, String>>)`](crate::output::StartContinuousExportOutput::schema_storage_config): <p>A dictionary which describes how the data is stored.</p>  <ul>   <li> <p> <code>databaseName</code> - the name of the Glue database used to store the schema.</p> </li>  </ul>
    /// - On failure, responds with [`SdkError<StartContinuousExportError>`](crate::error::StartContinuousExportError)
    pub fn start_continuous_export(&self) -> fluent_builders::StartContinuousExport {
        fluent_builders::StartContinuousExport::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartDataCollectionByAgentIds`](crate::client::fluent_builders::StartDataCollectionByAgentIds) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`agent_ids(Vec<String>)`](crate::client::fluent_builders::StartDataCollectionByAgentIds::agent_ids) / [`set_agent_ids(Option<Vec<String>>)`](crate::client::fluent_builders::StartDataCollectionByAgentIds::set_agent_ids): <p>The IDs of the agents or connectors from which to start collecting data. If you send a request to an agent/connector ID that you do not have permission to contact, according to your AWS account, the service does not throw an exception. Instead, it returns the error in the <i>Description</i> field. If you send a request to multiple agents/connectors and you do not have permission to contact some of those agents/connectors, the system does not throw an exception. Instead, the system shows <code>Failed</code> in the <i>Description</i> field.</p>
    /// - On success, responds with [`StartDataCollectionByAgentIdsOutput`](crate::output::StartDataCollectionByAgentIdsOutput) with field(s):
    ///   - [`agents_configuration_status(Option<Vec<AgentConfigurationStatus>>)`](crate::output::StartDataCollectionByAgentIdsOutput::agents_configuration_status): <p>Information about agents or the connector that were instructed to start collecting data. Information includes the agent/connector ID, a description of the operation performed, and whether the agent/connector configuration was updated.</p>
    /// - On failure, responds with [`SdkError<StartDataCollectionByAgentIdsError>`](crate::error::StartDataCollectionByAgentIdsError)
    pub fn start_data_collection_by_agent_ids(
        &self,
    ) -> fluent_builders::StartDataCollectionByAgentIds {
        fluent_builders::StartDataCollectionByAgentIds::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartExportTask`](crate::client::fluent_builders::StartExportTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`export_data_format(Vec<ExportDataFormat>)`](crate::client::fluent_builders::StartExportTask::export_data_format) / [`set_export_data_format(Option<Vec<ExportDataFormat>>)`](crate::client::fluent_builders::StartExportTask::set_export_data_format): <p>The file format for the returned export data. Default value is <code>CSV</code>. <b>Note:</b> <i>The</i> <code>GRAPHML</code> <i>option has been deprecated.</i> </p>
    ///   - [`filters(Vec<ExportFilter>)`](crate::client::fluent_builders::StartExportTask::filters) / [`set_filters(Option<Vec<ExportFilter>>)`](crate::client::fluent_builders::StartExportTask::set_filters): <p>If a filter is present, it selects the single <code>agentId</code> of the Application Discovery Agent for which data is exported. The <code>agentId</code> can be found in the results of the <code>DescribeAgents</code> API or CLI. If no filter is present, <code>startTime</code> and <code>endTime</code> are ignored and exported data includes both Agentless Discovery Connector data and summary data from Application Discovery agents. </p>
    ///   - [`start_time(DateTime)`](crate::client::fluent_builders::StartExportTask::start_time) / [`set_start_time(Option<DateTime>)`](crate::client::fluent_builders::StartExportTask::set_start_time): <p>The start timestamp for exported data from the single Application Discovery Agent selected in the filters. If no value is specified, data is exported starting from the first data collected by the agent.</p>
    ///   - [`end_time(DateTime)`](crate::client::fluent_builders::StartExportTask::end_time) / [`set_end_time(Option<DateTime>)`](crate::client::fluent_builders::StartExportTask::set_end_time): <p>The end timestamp for exported data from the single Application Discovery Agent selected in the filters. If no value is specified, exported data includes the most recent data collected by the agent.</p>
    /// - On success, responds with [`StartExportTaskOutput`](crate::output::StartExportTaskOutput) with field(s):
    ///   - [`export_id(Option<String>)`](crate::output::StartExportTaskOutput::export_id): <p>A unique identifier used to query the status of an export request.</p>
    /// - On failure, responds with [`SdkError<StartExportTaskError>`](crate::error::StartExportTaskError)
    pub fn start_export_task(&self) -> fluent_builders::StartExportTask {
        fluent_builders::StartExportTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartImportTask`](crate::client::fluent_builders::StartImportTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::StartImportTask::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::StartImportTask::set_client_request_token): <p>Optional. A unique token that you can provide to prevent the same import request from occurring more than once. If you don't provide a token, a token is automatically generated.</p>  <p>Sending more than one <code>StartImportTask</code> request with the same client request token will return information about the original import task with that client request token.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::StartImportTask::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::StartImportTask::set_name): <p>A descriptive name for this request. You can use this name to filter future requests related to this import task, such as identifying applications and servers that were included in this import task. We recommend that you use a meaningful name for each import task.</p>
    ///   - [`import_url(impl Into<String>)`](crate::client::fluent_builders::StartImportTask::import_url) / [`set_import_url(Option<String>)`](crate::client::fluent_builders::StartImportTask::set_import_url): <p>The URL for your import file that you've uploaded to Amazon S3.</p> <note>   <p>If you're using the AWS CLI, this URL is structured as follows: <code>s3://BucketName/ImportFileName.CSV</code> </p>  </note>
    /// - On success, responds with [`StartImportTaskOutput`](crate::output::StartImportTaskOutput) with field(s):
    ///   - [`task(Option<ImportTask>)`](crate::output::StartImportTaskOutput::task): <p>An array of information related to the import task request including status information, times, IDs, the Amazon S3 Object URL for the import file, and more. </p>
    /// - On failure, responds with [`SdkError<StartImportTaskError>`](crate::error::StartImportTaskError)
    pub fn start_import_task(&self) -> fluent_builders::StartImportTask {
        fluent_builders::StartImportTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StopContinuousExport`](crate::client::fluent_builders::StopContinuousExport) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`export_id(impl Into<String>)`](crate::client::fluent_builders::StopContinuousExport::export_id) / [`set_export_id(Option<String>)`](crate::client::fluent_builders::StopContinuousExport::set_export_id): <p>The unique ID assigned to this export.</p>
    /// - On success, responds with [`StopContinuousExportOutput`](crate::output::StopContinuousExportOutput) with field(s):
    ///   - [`start_time(Option<DateTime>)`](crate::output::StopContinuousExportOutput::start_time): <p>Timestamp that represents when this continuous export started collecting data.</p>
    ///   - [`stop_time(Option<DateTime>)`](crate::output::StopContinuousExportOutput::stop_time): <p>Timestamp that represents when this continuous export was stopped.</p>
    /// - On failure, responds with [`SdkError<StopContinuousExportError>`](crate::error::StopContinuousExportError)
    pub fn stop_continuous_export(&self) -> fluent_builders::StopContinuousExport {
        fluent_builders::StopContinuousExport::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StopDataCollectionByAgentIds`](crate::client::fluent_builders::StopDataCollectionByAgentIds) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`agent_ids(Vec<String>)`](crate::client::fluent_builders::StopDataCollectionByAgentIds::agent_ids) / [`set_agent_ids(Option<Vec<String>>)`](crate::client::fluent_builders::StopDataCollectionByAgentIds::set_agent_ids): <p>The IDs of the agents or connectors from which to stop collecting data.</p>
    /// - On success, responds with [`StopDataCollectionByAgentIdsOutput`](crate::output::StopDataCollectionByAgentIdsOutput) with field(s):
    ///   - [`agents_configuration_status(Option<Vec<AgentConfigurationStatus>>)`](crate::output::StopDataCollectionByAgentIdsOutput::agents_configuration_status): <p>Information about the agents or connector that were instructed to stop collecting data. Information includes the agent/connector ID, a description of the operation performed, and whether the agent/connector configuration was updated.</p>
    /// - On failure, responds with [`SdkError<StopDataCollectionByAgentIdsError>`](crate::error::StopDataCollectionByAgentIdsError)
    pub fn stop_data_collection_by_agent_ids(
        &self,
    ) -> fluent_builders::StopDataCollectionByAgentIds {
        fluent_builders::StopDataCollectionByAgentIds::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateApplication`](crate::client::fluent_builders::UpdateApplication) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_id(impl Into<String>)`](crate::client::fluent_builders::UpdateApplication::configuration_id) / [`set_configuration_id(Option<String>)`](crate::client::fluent_builders::UpdateApplication::set_configuration_id): <p>Configuration ID of the application to be updated.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateApplication::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateApplication::set_name): <p>New name of the application to be updated.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateApplication::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateApplication::set_description): <p>New description of the application to be updated.</p>
    /// - On success, responds with [`UpdateApplicationOutput`](crate::output::UpdateApplicationOutput)

    /// - On failure, responds with [`SdkError<UpdateApplicationError>`](crate::error::UpdateApplicationError)
    pub fn update_application(&self) -> fluent_builders::UpdateApplication {
        fluent_builders::UpdateApplication::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateConfigurationItemsToApplication`.
    ///
    /// <p>Associates one or more configuration items with an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateConfigurationItemsToApplication {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_configuration_items_to_application_input::Builder,
    }
    impl AssociateConfigurationItemsToApplication {
        /// Creates a new `AssociateConfigurationItemsToApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateConfigurationItemsToApplicationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::AssociateConfigurationItemsToApplicationError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The configuration ID of an application with which items are to be associated.</p>
        pub fn application_configuration_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.application_configuration_id(input.into());
            self
        }
        /// <p>The configuration ID of an application with which items are to be associated.</p>
        pub fn set_application_configuration_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_configuration_id(input);
            self
        }
        /// Appends an item to `configurationIds`.
        ///
        /// To override the contents of this collection use [`set_configuration_ids`](Self::set_configuration_ids).
        ///
        /// <p>The ID of each configuration item to be associated with an application.</p>
        pub fn configuration_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_ids(input.into());
            self
        }
        /// <p>The ID of each configuration item to be associated with an application.</p>
        pub fn set_configuration_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_configuration_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchDeleteImportData`.
    ///
    /// <p>Deletes one or more import tasks, each identified by their import ID. Each import task has a number of records that can identify servers or applications. </p>
    /// <p>AWS Application Discovery Service has built-in matching logic that will identify when discovered servers match existing entries that you've previously discovered, the information for the already-existing discovered server is updated. When you delete an import task that contains records that were used to match, the information in those matched records that comes from the deleted records will also be deleted.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchDeleteImportData {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_delete_import_data_input::Builder,
    }
    impl BatchDeleteImportData {
        /// Creates a new `BatchDeleteImportData`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchDeleteImportDataOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchDeleteImportDataError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `importTaskIds`.
        ///
        /// To override the contents of this collection use [`set_import_task_ids`](Self::set_import_task_ids).
        ///
        /// <p>The IDs for the import tasks that you want to delete.</p>
        pub fn import_task_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.import_task_ids(input.into());
            self
        }
        /// <p>The IDs for the import tasks that you want to delete.</p>
        pub fn set_import_task_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_import_task_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateApplication`.
    ///
    /// <p>Creates an application with the given name and description.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateApplication {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_application_input::Builder,
    }
    impl CreateApplication {
        /// Creates a new `CreateApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateApplicationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of the application to be created.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>Name of the application to be created.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Description of the application to be created.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>Description of the application to be created.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTags`.
    ///
    /// <p>Creates one or more tags for configuration items. Tags are metadata that help you categorize IT assets. This API accepts a list of multiple configuration items.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateTags {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_tags_input::Builder,
    }
    impl CreateTags {
        /// Creates a new `CreateTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTagsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `configurationIds`.
        ///
        /// To override the contents of this collection use [`set_configuration_ids`](Self::set_configuration_ids).
        ///
        /// <p>A list of configuration items that you want to tag.</p>
        pub fn configuration_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_ids(input.into());
            self
        }
        /// <p>A list of configuration items that you want to tag.</p>
        pub fn set_configuration_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_configuration_ids(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags that you want to associate with one or more configuration items. Specify the tags that you want to create in a <i>key</i>-<i>value</i> format. For example:</p>
        /// <p> <code>{"key": "serverType", "value": "webServer"}</code> </p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Tags that you want to associate with one or more configuration items. Specify the tags that you want to create in a <i>key</i>-<i>value</i> format. For example:</p>
        /// <p> <code>{"key": "serverType", "value": "webServer"}</code> </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteApplications`.
    ///
    /// <p>Deletes a list of applications and their associations with configuration items.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteApplications {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_applications_input::Builder,
    }
    impl DeleteApplications {
        /// Creates a new `DeleteApplications`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteApplicationsOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteApplicationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `configurationIds`.
        ///
        /// To override the contents of this collection use [`set_configuration_ids`](Self::set_configuration_ids).
        ///
        /// <p>Configuration ID of an application to be deleted.</p>
        pub fn configuration_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_ids(input.into());
            self
        }
        /// <p>Configuration ID of an application to be deleted.</p>
        pub fn set_configuration_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_configuration_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTags`.
    ///
    /// <p>Deletes the association between configuration items and one or more tags. This API accepts a list of multiple configuration items.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteTags {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_tags_input::Builder,
    }
    impl DeleteTags {
        /// Creates a new `DeleteTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTagsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `configurationIds`.
        ///
        /// To override the contents of this collection use [`set_configuration_ids`](Self::set_configuration_ids).
        ///
        /// <p>A list of configuration items with tags that you want to delete.</p>
        pub fn configuration_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_ids(input.into());
            self
        }
        /// <p>A list of configuration items with tags that you want to delete.</p>
        pub fn set_configuration_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_configuration_ids(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags that you want to delete from one or more configuration items. Specify the tags that you want to delete in a <i>key</i>-<i>value</i> format. For example:</p>
        /// <p> <code>{"key": "serverType", "value": "webServer"}</code> </p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Tags that you want to delete from one or more configuration items. Specify the tags that you want to delete in a <i>key</i>-<i>value</i> format. For example:</p>
        /// <p> <code>{"key": "serverType", "value": "webServer"}</code> </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAgents`.
    ///
    /// <p>Lists agents or connectors as specified by ID or other filters. All agents/connectors associated with your user account can be listed if you call <code>DescribeAgents</code> as is without passing any parameters.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAgents {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_agents_input::Builder,
    }
    impl DescribeAgents {
        /// Creates a new `DescribeAgents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAgentsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAgentsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `agentIds`.
        ///
        /// To override the contents of this collection use [`set_agent_ids`](Self::set_agent_ids).
        ///
        /// <p>The agent or the Connector IDs for which you want information. If you specify no IDs, the system returns information about all agents/Connectors associated with your AWS user account.</p>
        pub fn agent_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.agent_ids(input.into());
            self
        }
        /// <p>The agent or the Connector IDs for which you want information. If you specify no IDs, the system returns information about all agents/Connectors associated with your AWS user account.</p>
        pub fn set_agent_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_agent_ids(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>You can filter the request using various logical operators and a <i>key</i>-<i>value</i> format. For example: </p>
        /// <p> <code>{"key": "collectionStatus", "value": "STARTED"}</code> </p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>You can filter the request using various logical operators and a <i>key</i>-<i>value</i> format. For example: </p>
        /// <p> <code>{"key": "collectionStatus", "value": "STARTED"}</code> </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The total number of agents/Connectors to return in a single page of output. The maximum value is 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The total number of agents/Connectors to return in a single page of output. The maximum value is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Token to retrieve the next set of results. For example, if you previously specified 100 IDs for <code>DescribeAgentsRequest$agentIds</code> but set <code>DescribeAgentsRequest$maxResults</code> to 10, you received a set of 10 results along with a token. Use that token in this query to get the next set of 10.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Token to retrieve the next set of results. For example, if you previously specified 100 IDs for <code>DescribeAgentsRequest$agentIds</code> but set <code>DescribeAgentsRequest$maxResults</code> to 10, you received a set of 10 results along with a token. Use that token in this query to get the next set of 10.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeConfigurations`.
    ///
    /// <p>Retrieves attributes for a list of configuration item IDs.</p> <note>
    /// <p>All of the supplied IDs must be for the same asset type from one of the following:</p>
    /// <ul>
    /// <li> <p>server</p> </li>
    /// <li> <p>application</p> </li>
    /// <li> <p>process</p> </li>
    /// <li> <p>connection</p> </li>
    /// </ul>
    /// <p>Output fields are specific to the asset type specified. For example, the output for a <i>server</i> configuration item includes a list of attributes about the server, such as host name, operating system, number of network cards, etc.</p>
    /// <p>For a complete list of outputs for each asset type, see <a href="https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-api-queries.html#DescribeConfigurations">Using the DescribeConfigurations Action</a> in the <i>AWS Application Discovery Service User Guide</i>.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeConfigurations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_configurations_input::Builder,
    }
    impl DescribeConfigurations {
        /// Creates a new `DescribeConfigurations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeConfigurationsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeConfigurationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `configurationIds`.
        ///
        /// To override the contents of this collection use [`set_configuration_ids`](Self::set_configuration_ids).
        ///
        /// <p>One or more configuration IDs.</p>
        pub fn configuration_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_ids(input.into());
            self
        }
        /// <p>One or more configuration IDs.</p>
        pub fn set_configuration_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_configuration_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeContinuousExports`.
    ///
    /// <p>Lists exports as specified by ID. All continuous exports associated with your user account can be listed if you call <code>DescribeContinuousExports</code> as is without passing any parameters.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeContinuousExports {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_continuous_exports_input::Builder,
    }
    impl DescribeContinuousExports {
        /// Creates a new `DescribeContinuousExports`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeContinuousExportsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeContinuousExportsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeContinuousExportsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeContinuousExportsPaginator {
            crate::paginator::DescribeContinuousExportsPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `exportIds`.
        ///
        /// To override the contents of this collection use [`set_export_ids`](Self::set_export_ids).
        ///
        /// <p>The unique IDs assigned to the exports.</p>
        pub fn export_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.export_ids(input.into());
            self
        }
        /// <p>The unique IDs assigned to the exports.</p>
        pub fn set_export_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_export_ids(input);
            self
        }
        /// <p>A number between 1 and 100 specifying the maximum number of continuous export descriptions returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>A number between 1 and 100 specifying the maximum number of continuous export descriptions returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token from the previous call to <code>DescribeExportTasks</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token from the previous call to <code>DescribeExportTasks</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeExportConfigurations`.
    ///
    /// <p> <code>DescribeExportConfigurations</code> is deprecated. Use <a href="https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeExportTasks.html">DescribeImportTasks</a>, instead.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeExportConfigurations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_export_configurations_input::Builder,
    }
    impl DescribeExportConfigurations {
        /// Creates a new `DescribeExportConfigurations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeExportConfigurationsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeExportConfigurationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `exportIds`.
        ///
        /// To override the contents of this collection use [`set_export_ids`](Self::set_export_ids).
        ///
        /// <p>A list of continuous export IDs to search for.</p>
        pub fn export_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.export_ids(input.into());
            self
        }
        /// <p>A list of continuous export IDs to search for.</p>
        pub fn set_export_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_export_ids(input);
            self
        }
        /// <p>A number between 1 and 100 specifying the maximum number of continuous export descriptions returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>A number between 1 and 100 specifying the maximum number of continuous export descriptions returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token from the previous call to describe-export-tasks.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token from the previous call to describe-export-tasks.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeExportTasks`.
    ///
    /// <p>Retrieve status of one or more export tasks. You can retrieve the status of up to 100 export tasks.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeExportTasks {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_export_tasks_input::Builder,
    }
    impl DescribeExportTasks {
        /// Creates a new `DescribeExportTasks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeExportTasksOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeExportTasksError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `exportIds`.
        ///
        /// To override the contents of this collection use [`set_export_ids`](Self::set_export_ids).
        ///
        /// <p>One or more unique identifiers used to query the status of an export request.</p>
        pub fn export_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.export_ids(input.into());
            self
        }
        /// <p>One or more unique identifiers used to query the status of an export request.</p>
        pub fn set_export_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_export_ids(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>One or more filters.</p>
        /// <ul>
        /// <li> <p> <code>AgentId</code> - ID of the agent whose collected data will be exported</p> </li>
        /// </ul>
        pub fn filters(mut self, input: crate::model::ExportFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>One or more filters.</p>
        /// <ul>
        /// <li> <p> <code>AgentId</code> - ID of the agent whose collected data will be exported</p> </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExportFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of volume results returned by <code>DescribeExportTasks</code> in paginated output. When this parameter is used, <code>DescribeExportTasks</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of volume results returned by <code>DescribeExportTasks</code> in paginated output. When this parameter is used, <code>DescribeExportTasks</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>DescribeExportTasks</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. This value is null when there are no more results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>DescribeExportTasks</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. This value is null when there are no more results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeImportTasks`.
    ///
    /// <p>Returns an array of import tasks for your account, including status information, times, IDs, the Amazon S3 Object URL for the import file, and more.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeImportTasks {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_import_tasks_input::Builder,
    }
    impl DescribeImportTasks {
        /// Creates a new `DescribeImportTasks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeImportTasksOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeImportTasksError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeImportTasksPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeImportTasksPaginator {
            crate::paginator::DescribeImportTasksPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>An array of name-value pairs that you provide to filter the results for the <code>DescribeImportTask</code> request to a specific subset of results. Currently, wildcard values aren't supported for filters.</p>
        pub fn filters(mut self, input: crate::model::ImportTaskFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>An array of name-value pairs that you provide to filter the results for the <code>DescribeImportTask</code> request to a specific subset of results. Currently, wildcard values aren't supported for filters.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ImportTaskFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of results that you want this request to return, up to 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results that you want this request to return, up to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token to request a specific page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to request a specific page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTags`.
    ///
    /// <p>Retrieves a list of configuration items that have tags as specified by the key-value pairs, name and value, passed to the optional parameter <code>filters</code>.</p>
    /// <p>There are three valid tag filter names:</p>
    /// <ul>
    /// <li> <p>tagKey</p> </li>
    /// <li> <p>tagValue</p> </li>
    /// <li> <p>configurationId</p> </li>
    /// </ul>
    /// <p>Also, all configuration items associated with your user account that have tags can be listed if you call <code>DescribeTags</code> as is without passing any parameters.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeTags {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_tags_input::Builder,
    }
    impl DescribeTags {
        /// Creates a new `DescribeTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTagsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>You can filter the list using a <i>key</i>-<i>value</i> format. You can separate these items by using logical operators. Allowed filters include <code>tagKey</code>, <code>tagValue</code>, and <code>configurationId</code>. </p>
        pub fn filters(mut self, input: crate::model::TagFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>You can filter the list using a <i>key</i>-<i>value</i> format. You can separate these items by using logical operators. Allowed filters include <code>tagKey</code>, <code>tagValue</code>, and <code>configurationId</code>. </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The total number of items to return in a single page of output. The maximum value is 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The total number of items to return in a single page of output. The maximum value is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateConfigurationItemsFromApplication`.
    ///
    /// <p>Disassociates one or more configuration items from an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateConfigurationItemsFromApplication {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disassociate_configuration_items_from_application_input::Builder,
    }
    impl DisassociateConfigurationItemsFromApplication {
        /// Creates a new `DisassociateConfigurationItemsFromApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateConfigurationItemsFromApplicationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DisassociateConfigurationItemsFromApplicationError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Configuration ID of an application from which each item is disassociated.</p>
        pub fn application_configuration_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.application_configuration_id(input.into());
            self
        }
        /// <p>Configuration ID of an application from which each item is disassociated.</p>
        pub fn set_application_configuration_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_configuration_id(input);
            self
        }
        /// Appends an item to `configurationIds`.
        ///
        /// To override the contents of this collection use [`set_configuration_ids`](Self::set_configuration_ids).
        ///
        /// <p>Configuration ID of each item to be disassociated from an application.</p>
        pub fn configuration_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_ids(input.into());
            self
        }
        /// <p>Configuration ID of each item to be disassociated from an application.</p>
        pub fn set_configuration_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_configuration_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ExportConfigurations`.
    ///
    /// <p>Deprecated. Use <code>StartExportTask</code> instead.</p>
    /// <p>Exports all discovered configuration data to an Amazon S3 bucket or an application that enables you to view and evaluate the data. Data includes tags and tag associations, processes, connections, servers, and system performance. This API returns an export ID that you can query using the <i>DescribeExportConfigurations</i> API. The system imposes a limit of two configuration exports in six hours.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ExportConfigurations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::export_configurations_input::Builder,
    }
    impl ExportConfigurations {
        /// Creates a new `ExportConfigurations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ExportConfigurationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ExportConfigurationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetDiscoverySummary`.
    ///
    /// <p>Retrieves a short summary of discovered assets.</p>
    /// <p>This API operation takes no request parameters and is called as is at the command prompt as shown in the example.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDiscoverySummary {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_discovery_summary_input::Builder,
    }
    impl GetDiscoverySummary {
        /// Creates a new `GetDiscoverySummary`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDiscoverySummaryOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDiscoverySummaryError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `ListConfigurations`.
    ///
    /// <p>Retrieves a list of configuration items as specified by the value passed to the required parameter <code>configurationType</code>. Optional filtering may be applied to refine search results.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListConfigurations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_configurations_input::Builder,
    }
    impl ListConfigurations {
        /// Creates a new `ListConfigurations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListConfigurationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListConfigurationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A valid configuration identified by Application Discovery Service. </p>
        pub fn configuration_type(mut self, input: crate::model::ConfigurationItemType) -> Self {
            self.inner = self.inner.configuration_type(input);
            self
        }
        /// <p>A valid configuration identified by Application Discovery Service. </p>
        pub fn set_configuration_type(
            mut self,
            input: std::option::Option<crate::model::ConfigurationItemType>,
        ) -> Self {
            self.inner = self.inner.set_configuration_type(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>You can filter the request using various logical operators and a <i>key</i>-<i>value</i> format. For example: </p>
        /// <p> <code>{"key": "serverType", "value": "webServer"}</code> </p>
        /// <p>For a complete list of filter options and guidance about using them with this action, see <a href="https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-api-queries.html#ListConfigurations">Using the ListConfigurations Action</a> in the <i>AWS Application Discovery Service User Guide</i>.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>You can filter the request using various logical operators and a <i>key</i>-<i>value</i> format. For example: </p>
        /// <p> <code>{"key": "serverType", "value": "webServer"}</code> </p>
        /// <p>For a complete list of filter options and guidance about using them with this action, see <a href="https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-api-queries.html#ListConfigurations">Using the ListConfigurations Action</a> in the <i>AWS Application Discovery Service User Guide</i>.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The total number of items to return. The maximum value is 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The total number of items to return. The maximum value is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Token to retrieve the next set of results. For example, if a previous call to ListConfigurations returned 100 items, but you set <code>ListConfigurationsRequest$maxResults</code> to 10, you received a set of 10 results along with a token. Use that token in this query to get the next set of 10.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Token to retrieve the next set of results. For example, if a previous call to ListConfigurations returned 100 items, but you set <code>ListConfigurationsRequest$maxResults</code> to 10, you received a set of 10 results along with a token. Use that token in this query to get the next set of 10.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Appends an item to `orderBy`.
        ///
        /// To override the contents of this collection use [`set_order_by`](Self::set_order_by).
        ///
        /// <p>Certain filter criteria return output that can be sorted in ascending or descending order. For a list of output characteristics for each filter, see <a href="https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-api-queries.html#ListConfigurations">Using the ListConfigurations Action</a> in the <i>AWS Application Discovery Service User Guide</i>.</p>
        pub fn order_by(mut self, input: crate::model::OrderByElement) -> Self {
            self.inner = self.inner.order_by(input);
            self
        }
        /// <p>Certain filter criteria return output that can be sorted in ascending or descending order. For a list of output characteristics for each filter, see <a href="https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-api-queries.html#ListConfigurations">Using the ListConfigurations Action</a> in the <i>AWS Application Discovery Service User Guide</i>.</p>
        pub fn set_order_by(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OrderByElement>>,
        ) -> Self {
            self.inner = self.inner.set_order_by(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListServerNeighbors`.
    ///
    /// <p>Retrieves a list of servers that are one network hop away from a specified server.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListServerNeighbors {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_server_neighbors_input::Builder,
    }
    impl ListServerNeighbors {
        /// Creates a new `ListServerNeighbors`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListServerNeighborsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListServerNeighborsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Configuration ID of the server for which neighbors are being listed.</p>
        pub fn configuration_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_id(input.into());
            self
        }
        /// <p>Configuration ID of the server for which neighbors are being listed.</p>
        pub fn set_configuration_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_id(input);
            self
        }
        /// <p>Flag to indicate if port and protocol information is needed as part of the response.</p>
        pub fn port_information_needed(mut self, input: bool) -> Self {
            self.inner = self.inner.port_information_needed(input);
            self
        }
        /// <p>Flag to indicate if port and protocol information is needed as part of the response.</p>
        pub fn set_port_information_needed(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_port_information_needed(input);
            self
        }
        /// Appends an item to `neighborConfigurationIds`.
        ///
        /// To override the contents of this collection use [`set_neighbor_configuration_ids`](Self::set_neighbor_configuration_ids).
        ///
        /// <p>List of configuration IDs to test for one-hop-away.</p>
        pub fn neighbor_configuration_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.neighbor_configuration_ids(input.into());
            self
        }
        /// <p>List of configuration IDs to test for one-hop-away.</p>
        pub fn set_neighbor_configuration_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_neighbor_configuration_ids(input);
            self
        }
        /// <p>Maximum number of results to return in a single page of output.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Maximum number of results to return in a single page of output.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Token to retrieve the next set of results. For example, if you previously specified 100 IDs for <code>ListServerNeighborsRequest$neighborConfigurationIds</code> but set <code>ListServerNeighborsRequest$maxResults</code> to 10, you received a set of 10 results along with a token. Use that token in this query to get the next set of 10.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Token to retrieve the next set of results. For example, if you previously specified 100 IDs for <code>ListServerNeighborsRequest$neighborConfigurationIds</code> but set <code>ListServerNeighborsRequest$maxResults</code> to 10, you received a set of 10 results along with a token. Use that token in this query to get the next set of 10.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartContinuousExport`.
    ///
    /// <p>Start the continuous flow of agent's discovered data into Amazon Athena.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartContinuousExport {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_continuous_export_input::Builder,
    }
    impl StartContinuousExport {
        /// Creates a new `StartContinuousExport`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartContinuousExportOutput,
            aws_smithy_http::result::SdkError<crate::error::StartContinuousExportError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `StartDataCollectionByAgentIds`.
    ///
    /// <p>Instructs the specified agents or connectors to start collecting data.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartDataCollectionByAgentIds {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_data_collection_by_agent_ids_input::Builder,
    }
    impl StartDataCollectionByAgentIds {
        /// Creates a new `StartDataCollectionByAgentIds`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartDataCollectionByAgentIdsOutput,
            aws_smithy_http::result::SdkError<crate::error::StartDataCollectionByAgentIdsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `agentIds`.
        ///
        /// To override the contents of this collection use [`set_agent_ids`](Self::set_agent_ids).
        ///
        /// <p>The IDs of the agents or connectors from which to start collecting data. If you send a request to an agent/connector ID that you do not have permission to contact, according to your AWS account, the service does not throw an exception. Instead, it returns the error in the <i>Description</i> field. If you send a request to multiple agents/connectors and you do not have permission to contact some of those agents/connectors, the system does not throw an exception. Instead, the system shows <code>Failed</code> in the <i>Description</i> field.</p>
        pub fn agent_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.agent_ids(input.into());
            self
        }
        /// <p>The IDs of the agents or connectors from which to start collecting data. If you send a request to an agent/connector ID that you do not have permission to contact, according to your AWS account, the service does not throw an exception. Instead, it returns the error in the <i>Description</i> field. If you send a request to multiple agents/connectors and you do not have permission to contact some of those agents/connectors, the system does not throw an exception. Instead, the system shows <code>Failed</code> in the <i>Description</i> field.</p>
        pub fn set_agent_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_agent_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartExportTask`.
    ///
    /// <p> Begins the export of discovered data to an S3 bucket.</p>
    /// <p> If you specify <code>agentIds</code> in a filter, the task exports up to 72 hours of detailed data collected by the identified Application Discovery Agent, including network, process, and performance details. A time range for exported agent data may be set by using <code>startTime</code> and <code>endTime</code>. Export of detailed agent data is limited to five concurrently running exports. </p>
    /// <p> If you do not include an <code>agentIds</code> filter, summary data is exported that includes both AWS Agentless Discovery Connector data and summary data from AWS Discovery Agents. Export of summary data is limited to two exports per day. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartExportTask {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_export_task_input::Builder,
    }
    impl StartExportTask {
        /// Creates a new `StartExportTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartExportTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::StartExportTaskError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `exportDataFormat`.
        ///
        /// To override the contents of this collection use [`set_export_data_format`](Self::set_export_data_format).
        ///
        /// <p>The file format for the returned export data. Default value is <code>CSV</code>. <b>Note:</b> <i>The</i> <code>GRAPHML</code> <i>option has been deprecated.</i> </p>
        pub fn export_data_format(mut self, input: crate::model::ExportDataFormat) -> Self {
            self.inner = self.inner.export_data_format(input);
            self
        }
        /// <p>The file format for the returned export data. Default value is <code>CSV</code>. <b>Note:</b> <i>The</i> <code>GRAPHML</code> <i>option has been deprecated.</i> </p>
        pub fn set_export_data_format(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExportDataFormat>>,
        ) -> Self {
            self.inner = self.inner.set_export_data_format(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>If a filter is present, it selects the single <code>agentId</code> of the Application Discovery Agent for which data is exported. The <code>agentId</code> can be found in the results of the <code>DescribeAgents</code> API or CLI. If no filter is present, <code>startTime</code> and <code>endTime</code> are ignored and exported data includes both Agentless Discovery Connector data and summary data from Application Discovery agents. </p>
        pub fn filters(mut self, input: crate::model::ExportFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>If a filter is present, it selects the single <code>agentId</code> of the Application Discovery Agent for which data is exported. The <code>agentId</code> can be found in the results of the <code>DescribeAgents</code> API or CLI. If no filter is present, <code>startTime</code> and <code>endTime</code> are ignored and exported data includes both Agentless Discovery Connector data and summary data from Application Discovery agents. </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExportFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The start timestamp for exported data from the single Application Discovery Agent selected in the filters. If no value is specified, data is exported starting from the first data collected by the agent.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(input);
            self
        }
        /// <p>The start timestamp for exported data from the single Application Discovery Agent selected in the filters. If no value is specified, data is exported starting from the first data collected by the agent.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>The end timestamp for exported data from the single Application Discovery Agent selected in the filters. If no value is specified, exported data includes the most recent data collected by the agent.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(input);
            self
        }
        /// <p>The end timestamp for exported data from the single Application Discovery Agent selected in the filters. If no value is specified, exported data includes the most recent data collected by the agent.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartImportTask`.
    ///
    /// <p>Starts an import task, which allows you to import details of your on-premises environment directly into AWS Migration Hub without having to use the Application Discovery Service (ADS) tools such as the Discovery Connector or Discovery Agent. This gives you the option to perform migration assessment and planning directly from your imported data, including the ability to group your devices as applications and track their migration status.</p>
    /// <p>To start an import request, do this:</p>
    /// <ol>
    /// <li> <p>Download the specially formatted comma separated value (CSV) import template, which you can find here: <a href="https://s3-us-west-2.amazonaws.com/templates-7cffcf56-bd96-4b1c-b45b-a5b42f282e46/import_template.csv">https://s3-us-west-2.amazonaws.com/templates-7cffcf56-bd96-4b1c-b45b-a5b42f282e46/import_template.csv</a>.</p> </li>
    /// <li> <p>Fill out the template with your server and application data.</p> </li>
    /// <li> <p>Upload your import file to an Amazon S3 bucket, and make a note of it's Object URL. Your import file must be in the CSV format.</p> </li>
    /// <li> <p>Use the console or the <code>StartImportTask</code> command with the AWS CLI or one of the AWS SDKs to import the records from your file.</p> </li>
    /// </ol>
    /// <p>For more information, including step-by-step procedures, see <a href="https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-import.html">Migration Hub Import</a> in the <i>AWS Application Discovery Service User Guide</i>.</p> <note>
    /// <p>There are limits to the number of import tasks you can create (and delete) in an AWS account. For more information, see <a href="https://docs.aws.amazon.com/application-discovery/latest/userguide/ads_service_limits.html">AWS Application Discovery Service Limits</a> in the <i>AWS Application Discovery Service User Guide</i>.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartImportTask {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_import_task_input::Builder,
    }
    impl StartImportTask {
        /// Creates a new `StartImportTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartImportTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::StartImportTaskError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Optional. A unique token that you can provide to prevent the same import request from occurring more than once. If you don't provide a token, a token is automatically generated.</p>
        /// <p>Sending more than one <code>StartImportTask</code> request with the same client request token will return information about the original import task with that client request token.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>Optional. A unique token that you can provide to prevent the same import request from occurring more than once. If you don't provide a token, a token is automatically generated.</p>
        /// <p>Sending more than one <code>StartImportTask</code> request with the same client request token will return information about the original import task with that client request token.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>A descriptive name for this request. You can use this name to filter future requests related to this import task, such as identifying applications and servers that were included in this import task. We recommend that you use a meaningful name for each import task.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A descriptive name for this request. You can use this name to filter future requests related to this import task, such as identifying applications and servers that were included in this import task. We recommend that you use a meaningful name for each import task.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The URL for your import file that you've uploaded to Amazon S3.</p> <note>
        /// <p>If you're using the AWS CLI, this URL is structured as follows: <code>s3://BucketName/ImportFileName.CSV</code> </p>
        /// </note>
        pub fn import_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.import_url(input.into());
            self
        }
        /// <p>The URL for your import file that you've uploaded to Amazon S3.</p> <note>
        /// <p>If you're using the AWS CLI, this URL is structured as follows: <code>s3://BucketName/ImportFileName.CSV</code> </p>
        /// </note>
        pub fn set_import_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_import_url(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopContinuousExport`.
    ///
    /// <p>Stop the continuous flow of agent's discovered data into Amazon Athena.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StopContinuousExport {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::stop_continuous_export_input::Builder,
    }
    impl StopContinuousExport {
        /// Creates a new `StopContinuousExport`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopContinuousExportOutput,
            aws_smithy_http::result::SdkError<crate::error::StopContinuousExportError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID assigned to this export.</p>
        pub fn export_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.export_id(input.into());
            self
        }
        /// <p>The unique ID assigned to this export.</p>
        pub fn set_export_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_export_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopDataCollectionByAgentIds`.
    ///
    /// <p>Instructs the specified agents or connectors to stop collecting data.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StopDataCollectionByAgentIds {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::stop_data_collection_by_agent_ids_input::Builder,
    }
    impl StopDataCollectionByAgentIds {
        /// Creates a new `StopDataCollectionByAgentIds`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopDataCollectionByAgentIdsOutput,
            aws_smithy_http::result::SdkError<crate::error::StopDataCollectionByAgentIdsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `agentIds`.
        ///
        /// To override the contents of this collection use [`set_agent_ids`](Self::set_agent_ids).
        ///
        /// <p>The IDs of the agents or connectors from which to stop collecting data.</p>
        pub fn agent_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.agent_ids(input.into());
            self
        }
        /// <p>The IDs of the agents or connectors from which to stop collecting data.</p>
        pub fn set_agent_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_agent_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateApplication`.
    ///
    /// <p>Updates metadata about an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateApplication {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_application_input::Builder,
    }
    impl UpdateApplication {
        /// Creates a new `UpdateApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateApplicationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Configuration ID of the application to be updated.</p>
        pub fn configuration_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_id(input.into());
            self
        }
        /// <p>Configuration ID of the application to be updated.</p>
        pub fn set_configuration_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_id(input);
            self
        }
        /// <p>New name of the application to be updated.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>New name of the application to be updated.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>New description of the application to be updated.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>New description of the application to be updated.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
