// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Information about agents or connectors that were instructed to start collecting data.
/// Information includes the agent/connector ID, a description of the operation, and whether the
/// agent/connector configuration was updated.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AgentConfigurationStatus {
    /// <p>The agent/connector ID.</p>
    pub agent_id: std::option::Option<std::string::String>,
    /// <p>Information about the status of the <code>StartDataCollection</code> and
    /// <code>StopDataCollection</code> operations. The system has recorded the data collection
    /// operation. The agent/connector receives this command the next time it polls for a new command.
    /// </p>
    pub operation_succeeded: bool,
    /// <p>A description of the operation performed.</p>
    pub description: std::option::Option<std::string::String>,
}
impl AgentConfigurationStatus {
    /// <p>The agent/connector ID.</p>
    pub fn agent_id(&self) -> std::option::Option<&str> {
        self.agent_id.as_deref()
    }
    /// <p>Information about the status of the <code>StartDataCollection</code> and
    /// <code>StopDataCollection</code> operations. The system has recorded the data collection
    /// operation. The agent/connector receives this command the next time it polls for a new command.
    /// </p>
    pub fn operation_succeeded(&self) -> bool {
        self.operation_succeeded
    }
    /// <p>A description of the operation performed.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for AgentConfigurationStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AgentConfigurationStatus");
        formatter.field("agent_id", &self.agent_id);
        formatter.field("operation_succeeded", &self.operation_succeeded);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`AgentConfigurationStatus`](crate::model::AgentConfigurationStatus)
pub mod agent_configuration_status {
    /// A builder for [`AgentConfigurationStatus`](crate::model::AgentConfigurationStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) agent_id: std::option::Option<std::string::String>,
        pub(crate) operation_succeeded: std::option::Option<bool>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The agent/connector ID.</p>
        pub fn agent_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.agent_id = Some(input.into());
            self
        }
        /// <p>The agent/connector ID.</p>
        pub fn set_agent_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.agent_id = input;
            self
        }
        /// <p>Information about the status of the <code>StartDataCollection</code> and
        /// <code>StopDataCollection</code> operations. The system has recorded the data collection
        /// operation. The agent/connector receives this command the next time it polls for a new command.
        /// </p>
        pub fn operation_succeeded(mut self, input: bool) -> Self {
            self.operation_succeeded = Some(input);
            self
        }
        /// <p>Information about the status of the <code>StartDataCollection</code> and
        /// <code>StopDataCollection</code> operations. The system has recorded the data collection
        /// operation. The agent/connector receives this command the next time it polls for a new command.
        /// </p>
        pub fn set_operation_succeeded(mut self, input: std::option::Option<bool>) -> Self {
            self.operation_succeeded = input;
            self
        }
        /// <p>A description of the operation performed.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the operation performed.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`AgentConfigurationStatus`](crate::model::AgentConfigurationStatus)
        pub fn build(self) -> crate::model::AgentConfigurationStatus {
            crate::model::AgentConfigurationStatus {
                agent_id: self.agent_id,
                operation_succeeded: self.operation_succeeded.unwrap_or_default(),
                description: self.description,
            }
        }
    }
}
impl AgentConfigurationStatus {
    /// Creates a new builder-style object to manufacture [`AgentConfigurationStatus`](crate::model::AgentConfigurationStatus)
    pub fn builder() -> crate::model::agent_configuration_status::Builder {
        crate::model::agent_configuration_status::Builder::default()
    }
}

/// <p>An array of information related to the import task request that includes status
/// information, times, IDs, the Amazon S3 Object URL for the import file, and more.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImportTask {
    /// <p>The unique ID for a specific import task. These IDs aren't globally unique, but they are
    /// unique within an AWS account.</p>
    pub import_task_id: std::option::Option<std::string::String>,
    /// <p>A unique token used to prevent the same import request from occurring more than once. If
    /// you didn't provide a token, a token was automatically generated when the import task request
    /// was sent.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>A descriptive name for an import task. You can use this name to filter future requests
    /// related to this import task, such as identifying applications and servers that were included
    /// in this import task. We recommend that you use a meaningful name for each import task.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The URL for your import file that you've uploaded to Amazon S3.</p>
    pub import_url: std::option::Option<std::string::String>,
    /// <p>The status of the import task. An import can have the status of
    /// <code>IMPORT_COMPLETE</code> and still have some records fail to import from the overall
    /// request. More information can be found in the downloadable archive defined in the
    /// <code>errorsAndFailedEntriesZip</code> field, or in the Migration Hub management
    /// console.</p>
    pub status: std::option::Option<crate::model::ImportStatus>,
    /// <p>The time that the import task request was made, presented in the Unix time stamp
    /// format.</p>
    pub import_request_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time that the import task request finished, presented in the Unix time stamp
    /// format.</p>
    pub import_completion_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time that the import task request was deleted, presented in the Unix time stamp
    /// format.</p>
    pub import_deleted_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The total number of server records in the import file that were successfully
    /// imported.</p>
    pub server_import_success: i32,
    /// <p>The total number of server records in the import file that failed to be imported.</p>
    pub server_import_failure: i32,
    /// <p>The total number of application records in the import file that were successfully
    /// imported.</p>
    pub application_import_success: i32,
    /// <p>The total number of application records in the import file that failed to be
    /// imported.</p>
    pub application_import_failure: i32,
    /// <p>A link to a compressed archive folder (in the ZIP format) that contains an error log and a
    /// file of failed records. You can use these two files to quickly identify records that failed,
    /// why they failed, and correct those records. Afterward, you can upload the corrected file to
    /// your Amazon S3 bucket and create another import task request.</p>
    ///
    /// <p>This field also includes authorization information so you can confirm the authenticity of
    /// the compressed archive before you download it.</p>
    ///
    /// <p>If some records failed to be imported we recommend that you correct the records in the
    /// failed entries file and then imports that failed entries file. This prevents you from having
    /// to correct and update the larger original file and attempt importing it again.</p>
    pub errors_and_failed_entries_zip: std::option::Option<std::string::String>,
}
impl ImportTask {
    /// <p>The unique ID for a specific import task. These IDs aren't globally unique, but they are
    /// unique within an AWS account.</p>
    pub fn import_task_id(&self) -> std::option::Option<&str> {
        self.import_task_id.as_deref()
    }
    /// <p>A unique token used to prevent the same import request from occurring more than once. If
    /// you didn't provide a token, a token was automatically generated when the import task request
    /// was sent.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p>A descriptive name for an import task. You can use this name to filter future requests
    /// related to this import task, such as identifying applications and servers that were included
    /// in this import task. We recommend that you use a meaningful name for each import task.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The URL for your import file that you've uploaded to Amazon S3.</p>
    pub fn import_url(&self) -> std::option::Option<&str> {
        self.import_url.as_deref()
    }
    /// <p>The status of the import task. An import can have the status of
    /// <code>IMPORT_COMPLETE</code> and still have some records fail to import from the overall
    /// request. More information can be found in the downloadable archive defined in the
    /// <code>errorsAndFailedEntriesZip</code> field, or in the Migration Hub management
    /// console.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ImportStatus> {
        self.status.as_ref()
    }
    /// <p>The time that the import task request was made, presented in the Unix time stamp
    /// format.</p>
    pub fn import_request_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.import_request_time.as_ref()
    }
    /// <p>The time that the import task request finished, presented in the Unix time stamp
    /// format.</p>
    pub fn import_completion_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.import_completion_time.as_ref()
    }
    /// <p>The time that the import task request was deleted, presented in the Unix time stamp
    /// format.</p>
    pub fn import_deleted_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.import_deleted_time.as_ref()
    }
    /// <p>The total number of server records in the import file that were successfully
    /// imported.</p>
    pub fn server_import_success(&self) -> i32 {
        self.server_import_success
    }
    /// <p>The total number of server records in the import file that failed to be imported.</p>
    pub fn server_import_failure(&self) -> i32 {
        self.server_import_failure
    }
    /// <p>The total number of application records in the import file that were successfully
    /// imported.</p>
    pub fn application_import_success(&self) -> i32 {
        self.application_import_success
    }
    /// <p>The total number of application records in the import file that failed to be
    /// imported.</p>
    pub fn application_import_failure(&self) -> i32 {
        self.application_import_failure
    }
    /// <p>A link to a compressed archive folder (in the ZIP format) that contains an error log and a
    /// file of failed records. You can use these two files to quickly identify records that failed,
    /// why they failed, and correct those records. Afterward, you can upload the corrected file to
    /// your Amazon S3 bucket and create another import task request.</p>
    ///
    /// <p>This field also includes authorization information so you can confirm the authenticity of
    /// the compressed archive before you download it.</p>
    ///
    /// <p>If some records failed to be imported we recommend that you correct the records in the
    /// failed entries file and then imports that failed entries file. This prevents you from having
    /// to correct and update the larger original file and attempt importing it again.</p>
    pub fn errors_and_failed_entries_zip(&self) -> std::option::Option<&str> {
        self.errors_and_failed_entries_zip.as_deref()
    }
}
impl std::fmt::Debug for ImportTask {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImportTask");
        formatter.field("import_task_id", &self.import_task_id);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("name", &self.name);
        formatter.field("import_url", &self.import_url);
        formatter.field("status", &self.status);
        formatter.field("import_request_time", &self.import_request_time);
        formatter.field("import_completion_time", &self.import_completion_time);
        formatter.field("import_deleted_time", &self.import_deleted_time);
        formatter.field("server_import_success", &self.server_import_success);
        formatter.field("server_import_failure", &self.server_import_failure);
        formatter.field(
            "application_import_success",
            &self.application_import_success,
        );
        formatter.field(
            "application_import_failure",
            &self.application_import_failure,
        );
        formatter.field(
            "errors_and_failed_entries_zip",
            &self.errors_and_failed_entries_zip,
        );
        formatter.finish()
    }
}
/// See [`ImportTask`](crate::model::ImportTask)
pub mod import_task {
    /// A builder for [`ImportTask`](crate::model::ImportTask)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) import_task_id: std::option::Option<std::string::String>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) import_url: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ImportStatus>,
        pub(crate) import_request_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) import_completion_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) import_deleted_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) server_import_success: std::option::Option<i32>,
        pub(crate) server_import_failure: std::option::Option<i32>,
        pub(crate) application_import_success: std::option::Option<i32>,
        pub(crate) application_import_failure: std::option::Option<i32>,
        pub(crate) errors_and_failed_entries_zip: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID for a specific import task. These IDs aren't globally unique, but they are
        /// unique within an AWS account.</p>
        pub fn import_task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.import_task_id = Some(input.into());
            self
        }
        /// <p>The unique ID for a specific import task. These IDs aren't globally unique, but they are
        /// unique within an AWS account.</p>
        pub fn set_import_task_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.import_task_id = input;
            self
        }
        /// <p>A unique token used to prevent the same import request from occurring more than once. If
        /// you didn't provide a token, a token was automatically generated when the import task request
        /// was sent.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>A unique token used to prevent the same import request from occurring more than once. If
        /// you didn't provide a token, a token was automatically generated when the import task request
        /// was sent.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>A descriptive name for an import task. You can use this name to filter future requests
        /// related to this import task, such as identifying applications and servers that were included
        /// in this import task. We recommend that you use a meaningful name for each import task.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A descriptive name for an import task. You can use this name to filter future requests
        /// related to this import task, such as identifying applications and servers that were included
        /// in this import task. We recommend that you use a meaningful name for each import task.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The URL for your import file that you've uploaded to Amazon S3.</p>
        pub fn import_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.import_url = Some(input.into());
            self
        }
        /// <p>The URL for your import file that you've uploaded to Amazon S3.</p>
        pub fn set_import_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.import_url = input;
            self
        }
        /// <p>The status of the import task. An import can have the status of
        /// <code>IMPORT_COMPLETE</code> and still have some records fail to import from the overall
        /// request. More information can be found in the downloadable archive defined in the
        /// <code>errorsAndFailedEntriesZip</code> field, or in the Migration Hub management
        /// console.</p>
        pub fn status(mut self, input: crate::model::ImportStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the import task. An import can have the status of
        /// <code>IMPORT_COMPLETE</code> and still have some records fail to import from the overall
        /// request. More information can be found in the downloadable archive defined in the
        /// <code>errorsAndFailedEntriesZip</code> field, or in the Migration Hub management
        /// console.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ImportStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The time that the import task request was made, presented in the Unix time stamp
        /// format.</p>
        pub fn import_request_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.import_request_time = Some(input);
            self
        }
        /// <p>The time that the import task request was made, presented in the Unix time stamp
        /// format.</p>
        pub fn set_import_request_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.import_request_time = input;
            self
        }
        /// <p>The time that the import task request finished, presented in the Unix time stamp
        /// format.</p>
        pub fn import_completion_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.import_completion_time = Some(input);
            self
        }
        /// <p>The time that the import task request finished, presented in the Unix time stamp
        /// format.</p>
        pub fn set_import_completion_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.import_completion_time = input;
            self
        }
        /// <p>The time that the import task request was deleted, presented in the Unix time stamp
        /// format.</p>
        pub fn import_deleted_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.import_deleted_time = Some(input);
            self
        }
        /// <p>The time that the import task request was deleted, presented in the Unix time stamp
        /// format.</p>
        pub fn set_import_deleted_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.import_deleted_time = input;
            self
        }
        /// <p>The total number of server records in the import file that were successfully
        /// imported.</p>
        pub fn server_import_success(mut self, input: i32) -> Self {
            self.server_import_success = Some(input);
            self
        }
        /// <p>The total number of server records in the import file that were successfully
        /// imported.</p>
        pub fn set_server_import_success(mut self, input: std::option::Option<i32>) -> Self {
            self.server_import_success = input;
            self
        }
        /// <p>The total number of server records in the import file that failed to be imported.</p>
        pub fn server_import_failure(mut self, input: i32) -> Self {
            self.server_import_failure = Some(input);
            self
        }
        /// <p>The total number of server records in the import file that failed to be imported.</p>
        pub fn set_server_import_failure(mut self, input: std::option::Option<i32>) -> Self {
            self.server_import_failure = input;
            self
        }
        /// <p>The total number of application records in the import file that were successfully
        /// imported.</p>
        pub fn application_import_success(mut self, input: i32) -> Self {
            self.application_import_success = Some(input);
            self
        }
        /// <p>The total number of application records in the import file that were successfully
        /// imported.</p>
        pub fn set_application_import_success(mut self, input: std::option::Option<i32>) -> Self {
            self.application_import_success = input;
            self
        }
        /// <p>The total number of application records in the import file that failed to be
        /// imported.</p>
        pub fn application_import_failure(mut self, input: i32) -> Self {
            self.application_import_failure = Some(input);
            self
        }
        /// <p>The total number of application records in the import file that failed to be
        /// imported.</p>
        pub fn set_application_import_failure(mut self, input: std::option::Option<i32>) -> Self {
            self.application_import_failure = input;
            self
        }
        /// <p>A link to a compressed archive folder (in the ZIP format) that contains an error log and a
        /// file of failed records. You can use these two files to quickly identify records that failed,
        /// why they failed, and correct those records. Afterward, you can upload the corrected file to
        /// your Amazon S3 bucket and create another import task request.</p>
        ///
        /// <p>This field also includes authorization information so you can confirm the authenticity of
        /// the compressed archive before you download it.</p>
        ///
        /// <p>If some records failed to be imported we recommend that you correct the records in the
        /// failed entries file and then imports that failed entries file. This prevents you from having
        /// to correct and update the larger original file and attempt importing it again.</p>
        pub fn errors_and_failed_entries_zip(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.errors_and_failed_entries_zip = Some(input.into());
            self
        }
        /// <p>A link to a compressed archive folder (in the ZIP format) that contains an error log and a
        /// file of failed records. You can use these two files to quickly identify records that failed,
        /// why they failed, and correct those records. Afterward, you can upload the corrected file to
        /// your Amazon S3 bucket and create another import task request.</p>
        ///
        /// <p>This field also includes authorization information so you can confirm the authenticity of
        /// the compressed archive before you download it.</p>
        ///
        /// <p>If some records failed to be imported we recommend that you correct the records in the
        /// failed entries file and then imports that failed entries file. This prevents you from having
        /// to correct and update the larger original file and attempt importing it again.</p>
        pub fn set_errors_and_failed_entries_zip(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.errors_and_failed_entries_zip = input;
            self
        }
        /// Consumes the builder and constructs a [`ImportTask`](crate::model::ImportTask)
        pub fn build(self) -> crate::model::ImportTask {
            crate::model::ImportTask {
                import_task_id: self.import_task_id,
                client_request_token: self.client_request_token,
                name: self.name,
                import_url: self.import_url,
                status: self.status,
                import_request_time: self.import_request_time,
                import_completion_time: self.import_completion_time,
                import_deleted_time: self.import_deleted_time,
                server_import_success: self.server_import_success.unwrap_or_default(),
                server_import_failure: self.server_import_failure.unwrap_or_default(),
                application_import_success: self.application_import_success.unwrap_or_default(),
                application_import_failure: self.application_import_failure.unwrap_or_default(),
                errors_and_failed_entries_zip: self.errors_and_failed_entries_zip,
            }
        }
    }
}
impl ImportTask {
    /// Creates a new builder-style object to manufacture [`ImportTask`](crate::model::ImportTask)
    pub fn builder() -> crate::model::import_task::Builder {
        crate::model::import_task::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ImportStatus {
    #[allow(missing_docs)] // documentation missing in model
    DeleteComplete,
    #[allow(missing_docs)] // documentation missing in model
    DeleteFailed,
    #[allow(missing_docs)] // documentation missing in model
    DeleteFailedLimitExceeded,
    #[allow(missing_docs)] // documentation missing in model
    DeleteInProgress,
    #[allow(missing_docs)] // documentation missing in model
    ImportComplete,
    #[allow(missing_docs)] // documentation missing in model
    ImportCompleteWithErrors,
    #[allow(missing_docs)] // documentation missing in model
    ImportFailed,
    #[allow(missing_docs)] // documentation missing in model
    ImportFailedRecordLimitExceeded,
    #[allow(missing_docs)] // documentation missing in model
    ImportFailedServerLimitExceeded,
    #[allow(missing_docs)] // documentation missing in model
    ImportInProgress,
    #[allow(missing_docs)] // documentation missing in model
    InternalError,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ImportStatus {
    fn from(s: &str) -> Self {
        match s {
            "DELETE_COMPLETE" => ImportStatus::DeleteComplete,
            "DELETE_FAILED" => ImportStatus::DeleteFailed,
            "DELETE_FAILED_LIMIT_EXCEEDED" => ImportStatus::DeleteFailedLimitExceeded,
            "DELETE_IN_PROGRESS" => ImportStatus::DeleteInProgress,
            "IMPORT_COMPLETE" => ImportStatus::ImportComplete,
            "IMPORT_COMPLETE_WITH_ERRORS" => ImportStatus::ImportCompleteWithErrors,
            "IMPORT_FAILED" => ImportStatus::ImportFailed,
            "IMPORT_FAILED_RECORD_LIMIT_EXCEEDED" => ImportStatus::ImportFailedRecordLimitExceeded,
            "IMPORT_FAILED_SERVER_LIMIT_EXCEEDED" => ImportStatus::ImportFailedServerLimitExceeded,
            "IMPORT_IN_PROGRESS" => ImportStatus::ImportInProgress,
            "INTERNAL_ERROR" => ImportStatus::InternalError,
            other => ImportStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ImportStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ImportStatus::from(s))
    }
}
impl ImportStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ImportStatus::DeleteComplete => "DELETE_COMPLETE",
            ImportStatus::DeleteFailed => "DELETE_FAILED",
            ImportStatus::DeleteFailedLimitExceeded => "DELETE_FAILED_LIMIT_EXCEEDED",
            ImportStatus::DeleteInProgress => "DELETE_IN_PROGRESS",
            ImportStatus::ImportComplete => "IMPORT_COMPLETE",
            ImportStatus::ImportCompleteWithErrors => "IMPORT_COMPLETE_WITH_ERRORS",
            ImportStatus::ImportFailed => "IMPORT_FAILED",
            ImportStatus::ImportFailedRecordLimitExceeded => "IMPORT_FAILED_RECORD_LIMIT_EXCEEDED",
            ImportStatus::ImportFailedServerLimitExceeded => "IMPORT_FAILED_SERVER_LIMIT_EXCEEDED",
            ImportStatus::ImportInProgress => "IMPORT_IN_PROGRESS",
            ImportStatus::InternalError => "INTERNAL_ERROR",
            ImportStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DELETE_COMPLETE",
            "DELETE_FAILED",
            "DELETE_FAILED_LIMIT_EXCEEDED",
            "DELETE_IN_PROGRESS",
            "IMPORT_COMPLETE",
            "IMPORT_COMPLETE_WITH_ERRORS",
            "IMPORT_FAILED",
            "IMPORT_FAILED_RECORD_LIMIT_EXCEEDED",
            "IMPORT_FAILED_SERVER_LIMIT_EXCEEDED",
            "IMPORT_IN_PROGRESS",
            "INTERNAL_ERROR",
        ]
    }
}
impl AsRef<str> for ImportStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Used to select which agent's data is to be exported. A single agent ID may be selected
/// for export using the <a href="http://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StartExportTask.html">StartExportTask</a> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExportFilter {
    /// <p>A single <code>ExportFilter</code> name. Supported filters:
    /// <code>agentId</code>.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A single <code>agentId</code> for a Discovery Agent. An <code>agentId</code> can be
    /// found using the <a href="http://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeExportTasks.html">DescribeAgents</a> action. Typically an ADS <code>agentId</code> is in the form
    /// <code>o-0123456789abcdef0</code>.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Supported condition: <code>EQUALS</code>
    /// </p>
    pub condition: std::option::Option<std::string::String>,
}
impl ExportFilter {
    /// <p>A single <code>ExportFilter</code> name. Supported filters:
    /// <code>agentId</code>.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A single <code>agentId</code> for a Discovery Agent. An <code>agentId</code> can be
    /// found using the <a href="http://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeExportTasks.html">DescribeAgents</a> action. Typically an ADS <code>agentId</code> is in the form
    /// <code>o-0123456789abcdef0</code>.</p>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
    /// <p>Supported condition: <code>EQUALS</code>
    /// </p>
    pub fn condition(&self) -> std::option::Option<&str> {
        self.condition.as_deref()
    }
}
impl std::fmt::Debug for ExportFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExportFilter");
        formatter.field("name", &self.name);
        formatter.field("values", &self.values);
        formatter.field("condition", &self.condition);
        formatter.finish()
    }
}
/// See [`ExportFilter`](crate::model::ExportFilter)
pub mod export_filter {
    /// A builder for [`ExportFilter`](crate::model::ExportFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) condition: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A single <code>ExportFilter</code> name. Supported filters:
        /// <code>agentId</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A single <code>ExportFilter</code> name. Supported filters:
        /// <code>agentId</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>A single <code>agentId</code> for a Discovery Agent. An <code>agentId</code> can be
        /// found using the <a href="http://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeExportTasks.html">DescribeAgents</a> action. Typically an ADS <code>agentId</code> is in the form
        /// <code>o-0123456789abcdef0</code>.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>A single <code>agentId</code> for a Discovery Agent. An <code>agentId</code> can be
        /// found using the <a href="http://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeExportTasks.html">DescribeAgents</a> action. Typically an ADS <code>agentId</code> is in the form
        /// <code>o-0123456789abcdef0</code>.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// <p>Supported condition: <code>EQUALS</code>
        /// </p>
        pub fn condition(mut self, input: impl Into<std::string::String>) -> Self {
            self.condition = Some(input.into());
            self
        }
        /// <p>Supported condition: <code>EQUALS</code>
        /// </p>
        pub fn set_condition(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.condition = input;
            self
        }
        /// Consumes the builder and constructs a [`ExportFilter`](crate::model::ExportFilter)
        pub fn build(self) -> crate::model::ExportFilter {
            crate::model::ExportFilter {
                name: self.name,
                values: self.values,
                condition: self.condition,
            }
        }
    }
}
impl ExportFilter {
    /// Creates a new builder-style object to manufacture [`ExportFilter`](crate::model::ExportFilter)
    pub fn builder() -> crate::model::export_filter::Builder {
        crate::model::export_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ExportDataFormat {
    #[allow(missing_docs)] // documentation missing in model
    Csv,
    #[allow(missing_docs)] // documentation missing in model
    Graphml,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ExportDataFormat {
    fn from(s: &str) -> Self {
        match s {
            "CSV" => ExportDataFormat::Csv,
            "GRAPHML" => ExportDataFormat::Graphml,
            other => ExportDataFormat::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ExportDataFormat {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ExportDataFormat::from(s))
    }
}
impl ExportDataFormat {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ExportDataFormat::Csv => "CSV",
            ExportDataFormat::Graphml => "GRAPHML",
            ExportDataFormat::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CSV", "GRAPHML"]
    }
}
impl AsRef<str> for ExportDataFormat {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DataSource {
    #[allow(missing_docs)] // documentation missing in model
    Agent,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DataSource {
    fn from(s: &str) -> Self {
        match s {
            "AGENT" => DataSource::Agent,
            other => DataSource::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DataSource {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DataSource::from(s))
    }
}
impl DataSource {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DataSource::Agent => "AGENT",
            DataSource::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AGENT"]
    }
}
impl AsRef<str> for DataSource {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Details about neighboring servers.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NeighborConnectionDetail {
    /// <p>The ID of the server that opened the network connection.</p>
    pub source_server_id: std::option::Option<std::string::String>,
    /// <p>The ID of the server that accepted the network connection.</p>
    pub destination_server_id: std::option::Option<std::string::String>,
    /// <p>The destination network port for the connection.</p>
    pub destination_port: std::option::Option<i32>,
    /// <p>The network protocol used for the connection.</p>
    pub transport_protocol: std::option::Option<std::string::String>,
    /// <p>The number of open network connections with the neighboring server.</p>
    pub connections_count: i64,
}
impl NeighborConnectionDetail {
    /// <p>The ID of the server that opened the network connection.</p>
    pub fn source_server_id(&self) -> std::option::Option<&str> {
        self.source_server_id.as_deref()
    }
    /// <p>The ID of the server that accepted the network connection.</p>
    pub fn destination_server_id(&self) -> std::option::Option<&str> {
        self.destination_server_id.as_deref()
    }
    /// <p>The destination network port for the connection.</p>
    pub fn destination_port(&self) -> std::option::Option<i32> {
        self.destination_port
    }
    /// <p>The network protocol used for the connection.</p>
    pub fn transport_protocol(&self) -> std::option::Option<&str> {
        self.transport_protocol.as_deref()
    }
    /// <p>The number of open network connections with the neighboring server.</p>
    pub fn connections_count(&self) -> i64 {
        self.connections_count
    }
}
impl std::fmt::Debug for NeighborConnectionDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NeighborConnectionDetail");
        formatter.field("source_server_id", &self.source_server_id);
        formatter.field("destination_server_id", &self.destination_server_id);
        formatter.field("destination_port", &self.destination_port);
        formatter.field("transport_protocol", &self.transport_protocol);
        formatter.field("connections_count", &self.connections_count);
        formatter.finish()
    }
}
/// See [`NeighborConnectionDetail`](crate::model::NeighborConnectionDetail)
pub mod neighbor_connection_detail {
    /// A builder for [`NeighborConnectionDetail`](crate::model::NeighborConnectionDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_server_id: std::option::Option<std::string::String>,
        pub(crate) destination_server_id: std::option::Option<std::string::String>,
        pub(crate) destination_port: std::option::Option<i32>,
        pub(crate) transport_protocol: std::option::Option<std::string::String>,
        pub(crate) connections_count: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The ID of the server that opened the network connection.</p>
        pub fn source_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_server_id = Some(input.into());
            self
        }
        /// <p>The ID of the server that opened the network connection.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_server_id = input;
            self
        }
        /// <p>The ID of the server that accepted the network connection.</p>
        pub fn destination_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_server_id = Some(input.into());
            self
        }
        /// <p>The ID of the server that accepted the network connection.</p>
        pub fn set_destination_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_server_id = input;
            self
        }
        /// <p>The destination network port for the connection.</p>
        pub fn destination_port(mut self, input: i32) -> Self {
            self.destination_port = Some(input);
            self
        }
        /// <p>The destination network port for the connection.</p>
        pub fn set_destination_port(mut self, input: std::option::Option<i32>) -> Self {
            self.destination_port = input;
            self
        }
        /// <p>The network protocol used for the connection.</p>
        pub fn transport_protocol(mut self, input: impl Into<std::string::String>) -> Self {
            self.transport_protocol = Some(input.into());
            self
        }
        /// <p>The network protocol used for the connection.</p>
        pub fn set_transport_protocol(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.transport_protocol = input;
            self
        }
        /// <p>The number of open network connections with the neighboring server.</p>
        pub fn connections_count(mut self, input: i64) -> Self {
            self.connections_count = Some(input);
            self
        }
        /// <p>The number of open network connections with the neighboring server.</p>
        pub fn set_connections_count(mut self, input: std::option::Option<i64>) -> Self {
            self.connections_count = input;
            self
        }
        /// Consumes the builder and constructs a [`NeighborConnectionDetail`](crate::model::NeighborConnectionDetail)
        pub fn build(self) -> crate::model::NeighborConnectionDetail {
            crate::model::NeighborConnectionDetail {
                source_server_id: self.source_server_id,
                destination_server_id: self.destination_server_id,
                destination_port: self.destination_port,
                transport_protocol: self.transport_protocol,
                connections_count: self.connections_count.unwrap_or_default(),
            }
        }
    }
}
impl NeighborConnectionDetail {
    /// Creates a new builder-style object to manufacture [`NeighborConnectionDetail`](crate::model::NeighborConnectionDetail)
    pub fn builder() -> crate::model::neighbor_connection_detail::Builder {
        crate::model::neighbor_connection_detail::Builder::default()
    }
}

/// <p>A field and direction for ordered output.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OrderByElement {
    /// <p>The field on which to order.</p>
    pub field_name: std::option::Option<std::string::String>,
    /// <p>Ordering direction.</p>
    pub sort_order: std::option::Option<crate::model::OrderString>,
}
impl OrderByElement {
    /// <p>The field on which to order.</p>
    pub fn field_name(&self) -> std::option::Option<&str> {
        self.field_name.as_deref()
    }
    /// <p>Ordering direction.</p>
    pub fn sort_order(&self) -> std::option::Option<&crate::model::OrderString> {
        self.sort_order.as_ref()
    }
}
impl std::fmt::Debug for OrderByElement {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OrderByElement");
        formatter.field("field_name", &self.field_name);
        formatter.field("sort_order", &self.sort_order);
        formatter.finish()
    }
}
/// See [`OrderByElement`](crate::model::OrderByElement)
pub mod order_by_element {
    /// A builder for [`OrderByElement`](crate::model::OrderByElement)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) field_name: std::option::Option<std::string::String>,
        pub(crate) sort_order: std::option::Option<crate::model::OrderString>,
    }
    impl Builder {
        /// <p>The field on which to order.</p>
        pub fn field_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.field_name = Some(input.into());
            self
        }
        /// <p>The field on which to order.</p>
        pub fn set_field_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.field_name = input;
            self
        }
        /// <p>Ordering direction.</p>
        pub fn sort_order(mut self, input: crate::model::OrderString) -> Self {
            self.sort_order = Some(input);
            self
        }
        /// <p>Ordering direction.</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::OrderString>,
        ) -> Self {
            self.sort_order = input;
            self
        }
        /// Consumes the builder and constructs a [`OrderByElement`](crate::model::OrderByElement)
        pub fn build(self) -> crate::model::OrderByElement {
            crate::model::OrderByElement {
                field_name: self.field_name,
                sort_order: self.sort_order,
            }
        }
    }
}
impl OrderByElement {
    /// Creates a new builder-style object to manufacture [`OrderByElement`](crate::model::OrderByElement)
    pub fn builder() -> crate::model::order_by_element::Builder {
        crate::model::order_by_element::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OrderString {
    #[allow(missing_docs)] // documentation missing in model
    Asc,
    #[allow(missing_docs)] // documentation missing in model
    Desc,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OrderString {
    fn from(s: &str) -> Self {
        match s {
            "ASC" => OrderString::Asc,
            "DESC" => OrderString::Desc,
            other => OrderString::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OrderString {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OrderString::from(s))
    }
}
impl OrderString {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OrderString::Asc => "ASC",
            OrderString::Desc => "DESC",
            OrderString::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ASC", "DESC"]
    }
}
impl AsRef<str> for OrderString {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A filter that can use conditional operators.</p>
/// <p>For more information about filters, see <a href="https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-api-queries.html">Querying Discovered
/// Configuration Items</a> in the <i>AWS Application Discovery Service User
/// Guide</i>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Filter {
    /// <p>The name of the filter.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A string value on which to filter. For example, if you choose the
    /// <code>destinationServer.osVersion</code> filter name, you could specify <code>Ubuntu</code>
    /// for the value.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A conditional operator. The following operators are valid: EQUALS, NOT_EQUALS,
    /// CONTAINS, NOT_CONTAINS. If you specify multiple filters, the system utilizes all filters as
    /// though concatenated by <i>AND</i>. If you specify multiple values for a
    /// particular filter, the system differentiates the values using <i>OR</i>. Calling
    /// either <i>DescribeConfigurations</i> or <i>ListConfigurations</i>
    /// returns attributes of matching configuration items.</p>
    pub condition: std::option::Option<std::string::String>,
}
impl Filter {
    /// <p>The name of the filter.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A string value on which to filter. For example, if you choose the
    /// <code>destinationServer.osVersion</code> filter name, you could specify <code>Ubuntu</code>
    /// for the value.</p>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
    /// <p>A conditional operator. The following operators are valid: EQUALS, NOT_EQUALS,
    /// CONTAINS, NOT_CONTAINS. If you specify multiple filters, the system utilizes all filters as
    /// though concatenated by <i>AND</i>. If you specify multiple values for a
    /// particular filter, the system differentiates the values using <i>OR</i>. Calling
    /// either <i>DescribeConfigurations</i> or <i>ListConfigurations</i>
    /// returns attributes of matching configuration items.</p>
    pub fn condition(&self) -> std::option::Option<&str> {
        self.condition.as_deref()
    }
}
impl std::fmt::Debug for Filter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Filter");
        formatter.field("name", &self.name);
        formatter.field("values", &self.values);
        formatter.field("condition", &self.condition);
        formatter.finish()
    }
}
/// See [`Filter`](crate::model::Filter)
pub mod filter {
    /// A builder for [`Filter`](crate::model::Filter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) condition: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the filter.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the filter.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>A string value on which to filter. For example, if you choose the
        /// <code>destinationServer.osVersion</code> filter name, you could specify <code>Ubuntu</code>
        /// for the value.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>A string value on which to filter. For example, if you choose the
        /// <code>destinationServer.osVersion</code> filter name, you could specify <code>Ubuntu</code>
        /// for the value.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// <p>A conditional operator. The following operators are valid: EQUALS, NOT_EQUALS,
        /// CONTAINS, NOT_CONTAINS. If you specify multiple filters, the system utilizes all filters as
        /// though concatenated by <i>AND</i>. If you specify multiple values for a
        /// particular filter, the system differentiates the values using <i>OR</i>. Calling
        /// either <i>DescribeConfigurations</i> or <i>ListConfigurations</i>
        /// returns attributes of matching configuration items.</p>
        pub fn condition(mut self, input: impl Into<std::string::String>) -> Self {
            self.condition = Some(input.into());
            self
        }
        /// <p>A conditional operator. The following operators are valid: EQUALS, NOT_EQUALS,
        /// CONTAINS, NOT_CONTAINS. If you specify multiple filters, the system utilizes all filters as
        /// though concatenated by <i>AND</i>. If you specify multiple values for a
        /// particular filter, the system differentiates the values using <i>OR</i>. Calling
        /// either <i>DescribeConfigurations</i> or <i>ListConfigurations</i>
        /// returns attributes of matching configuration items.</p>
        pub fn set_condition(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.condition = input;
            self
        }
        /// Consumes the builder and constructs a [`Filter`](crate::model::Filter)
        pub fn build(self) -> crate::model::Filter {
            crate::model::Filter {
                name: self.name,
                values: self.values,
                condition: self.condition,
            }
        }
    }
}
impl Filter {
    /// Creates a new builder-style object to manufacture [`Filter`](crate::model::Filter)
    pub fn builder() -> crate::model::filter::Builder {
        crate::model::filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConfigurationItemType {
    #[allow(missing_docs)] // documentation missing in model
    Application,
    #[allow(missing_docs)] // documentation missing in model
    Connections,
    #[allow(missing_docs)] // documentation missing in model
    Process,
    #[allow(missing_docs)] // documentation missing in model
    Server,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConfigurationItemType {
    fn from(s: &str) -> Self {
        match s {
            "APPLICATION" => ConfigurationItemType::Application,
            "CONNECTION" => ConfigurationItemType::Connections,
            "PROCESS" => ConfigurationItemType::Process,
            "SERVER" => ConfigurationItemType::Server,
            other => ConfigurationItemType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConfigurationItemType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConfigurationItemType::from(s))
    }
}
impl ConfigurationItemType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConfigurationItemType::Application => "APPLICATION",
            ConfigurationItemType::Connections => "CONNECTION",
            ConfigurationItemType::Process => "PROCESS",
            ConfigurationItemType::Server => "SERVER",
            ConfigurationItemType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["APPLICATION", "CONNECTION", "PROCESS", "SERVER"]
    }
}
impl AsRef<str> for ConfigurationItemType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Inventory data for installed discovery connectors.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomerConnectorInfo {
    /// <p>Number of active discovery connectors.</p>
    pub active_connectors: i32,
    /// <p>Number of healthy discovery connectors.</p>
    pub healthy_connectors: i32,
    /// <p>Number of blacklisted discovery connectors.</p>
    pub black_listed_connectors: i32,
    /// <p>Number of discovery connectors with status SHUTDOWN,</p>
    pub shutdown_connectors: i32,
    /// <p>Number of unhealthy discovery connectors.</p>
    pub unhealthy_connectors: i32,
    /// <p>Total number of discovery connectors.</p>
    pub total_connectors: i32,
    /// <p>Number of unknown discovery connectors.</p>
    pub unknown_connectors: i32,
}
impl CustomerConnectorInfo {
    /// <p>Number of active discovery connectors.</p>
    pub fn active_connectors(&self) -> i32 {
        self.active_connectors
    }
    /// <p>Number of healthy discovery connectors.</p>
    pub fn healthy_connectors(&self) -> i32 {
        self.healthy_connectors
    }
    /// <p>Number of blacklisted discovery connectors.</p>
    pub fn black_listed_connectors(&self) -> i32 {
        self.black_listed_connectors
    }
    /// <p>Number of discovery connectors with status SHUTDOWN,</p>
    pub fn shutdown_connectors(&self) -> i32 {
        self.shutdown_connectors
    }
    /// <p>Number of unhealthy discovery connectors.</p>
    pub fn unhealthy_connectors(&self) -> i32 {
        self.unhealthy_connectors
    }
    /// <p>Total number of discovery connectors.</p>
    pub fn total_connectors(&self) -> i32 {
        self.total_connectors
    }
    /// <p>Number of unknown discovery connectors.</p>
    pub fn unknown_connectors(&self) -> i32 {
        self.unknown_connectors
    }
}
impl std::fmt::Debug for CustomerConnectorInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomerConnectorInfo");
        formatter.field("active_connectors", &self.active_connectors);
        formatter.field("healthy_connectors", &self.healthy_connectors);
        formatter.field("black_listed_connectors", &self.black_listed_connectors);
        formatter.field("shutdown_connectors", &self.shutdown_connectors);
        formatter.field("unhealthy_connectors", &self.unhealthy_connectors);
        formatter.field("total_connectors", &self.total_connectors);
        formatter.field("unknown_connectors", &self.unknown_connectors);
        formatter.finish()
    }
}
/// See [`CustomerConnectorInfo`](crate::model::CustomerConnectorInfo)
pub mod customer_connector_info {
    /// A builder for [`CustomerConnectorInfo`](crate::model::CustomerConnectorInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) active_connectors: std::option::Option<i32>,
        pub(crate) healthy_connectors: std::option::Option<i32>,
        pub(crate) black_listed_connectors: std::option::Option<i32>,
        pub(crate) shutdown_connectors: std::option::Option<i32>,
        pub(crate) unhealthy_connectors: std::option::Option<i32>,
        pub(crate) total_connectors: std::option::Option<i32>,
        pub(crate) unknown_connectors: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Number of active discovery connectors.</p>
        pub fn active_connectors(mut self, input: i32) -> Self {
            self.active_connectors = Some(input);
            self
        }
        /// <p>Number of active discovery connectors.</p>
        pub fn set_active_connectors(mut self, input: std::option::Option<i32>) -> Self {
            self.active_connectors = input;
            self
        }
        /// <p>Number of healthy discovery connectors.</p>
        pub fn healthy_connectors(mut self, input: i32) -> Self {
            self.healthy_connectors = Some(input);
            self
        }
        /// <p>Number of healthy discovery connectors.</p>
        pub fn set_healthy_connectors(mut self, input: std::option::Option<i32>) -> Self {
            self.healthy_connectors = input;
            self
        }
        /// <p>Number of blacklisted discovery connectors.</p>
        pub fn black_listed_connectors(mut self, input: i32) -> Self {
            self.black_listed_connectors = Some(input);
            self
        }
        /// <p>Number of blacklisted discovery connectors.</p>
        pub fn set_black_listed_connectors(mut self, input: std::option::Option<i32>) -> Self {
            self.black_listed_connectors = input;
            self
        }
        /// <p>Number of discovery connectors with status SHUTDOWN,</p>
        pub fn shutdown_connectors(mut self, input: i32) -> Self {
            self.shutdown_connectors = Some(input);
            self
        }
        /// <p>Number of discovery connectors with status SHUTDOWN,</p>
        pub fn set_shutdown_connectors(mut self, input: std::option::Option<i32>) -> Self {
            self.shutdown_connectors = input;
            self
        }
        /// <p>Number of unhealthy discovery connectors.</p>
        pub fn unhealthy_connectors(mut self, input: i32) -> Self {
            self.unhealthy_connectors = Some(input);
            self
        }
        /// <p>Number of unhealthy discovery connectors.</p>
        pub fn set_unhealthy_connectors(mut self, input: std::option::Option<i32>) -> Self {
            self.unhealthy_connectors = input;
            self
        }
        /// <p>Total number of discovery connectors.</p>
        pub fn total_connectors(mut self, input: i32) -> Self {
            self.total_connectors = Some(input);
            self
        }
        /// <p>Total number of discovery connectors.</p>
        pub fn set_total_connectors(mut self, input: std::option::Option<i32>) -> Self {
            self.total_connectors = input;
            self
        }
        /// <p>Number of unknown discovery connectors.</p>
        pub fn unknown_connectors(mut self, input: i32) -> Self {
            self.unknown_connectors = Some(input);
            self
        }
        /// <p>Number of unknown discovery connectors.</p>
        pub fn set_unknown_connectors(mut self, input: std::option::Option<i32>) -> Self {
            self.unknown_connectors = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomerConnectorInfo`](crate::model::CustomerConnectorInfo)
        pub fn build(self) -> crate::model::CustomerConnectorInfo {
            crate::model::CustomerConnectorInfo {
                active_connectors: self.active_connectors.unwrap_or_default(),
                healthy_connectors: self.healthy_connectors.unwrap_or_default(),
                black_listed_connectors: self.black_listed_connectors.unwrap_or_default(),
                shutdown_connectors: self.shutdown_connectors.unwrap_or_default(),
                unhealthy_connectors: self.unhealthy_connectors.unwrap_or_default(),
                total_connectors: self.total_connectors.unwrap_or_default(),
                unknown_connectors: self.unknown_connectors.unwrap_or_default(),
            }
        }
    }
}
impl CustomerConnectorInfo {
    /// Creates a new builder-style object to manufacture [`CustomerConnectorInfo`](crate::model::CustomerConnectorInfo)
    pub fn builder() -> crate::model::customer_connector_info::Builder {
        crate::model::customer_connector_info::Builder::default()
    }
}

/// <p>Inventory data for installed discovery agents.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomerAgentInfo {
    /// <p>Number of active discovery agents.</p>
    pub active_agents: i32,
    /// <p>Number of healthy discovery agents</p>
    pub healthy_agents: i32,
    /// <p>Number of blacklisted discovery agents.</p>
    pub black_listed_agents: i32,
    /// <p>Number of discovery agents with status SHUTDOWN.</p>
    pub shutdown_agents: i32,
    /// <p>Number of unhealthy discovery agents.</p>
    pub unhealthy_agents: i32,
    /// <p>Total number of discovery agents.</p>
    pub total_agents: i32,
    /// <p>Number of unknown discovery agents.</p>
    pub unknown_agents: i32,
}
impl CustomerAgentInfo {
    /// <p>Number of active discovery agents.</p>
    pub fn active_agents(&self) -> i32 {
        self.active_agents
    }
    /// <p>Number of healthy discovery agents</p>
    pub fn healthy_agents(&self) -> i32 {
        self.healthy_agents
    }
    /// <p>Number of blacklisted discovery agents.</p>
    pub fn black_listed_agents(&self) -> i32 {
        self.black_listed_agents
    }
    /// <p>Number of discovery agents with status SHUTDOWN.</p>
    pub fn shutdown_agents(&self) -> i32 {
        self.shutdown_agents
    }
    /// <p>Number of unhealthy discovery agents.</p>
    pub fn unhealthy_agents(&self) -> i32 {
        self.unhealthy_agents
    }
    /// <p>Total number of discovery agents.</p>
    pub fn total_agents(&self) -> i32 {
        self.total_agents
    }
    /// <p>Number of unknown discovery agents.</p>
    pub fn unknown_agents(&self) -> i32 {
        self.unknown_agents
    }
}
impl std::fmt::Debug for CustomerAgentInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomerAgentInfo");
        formatter.field("active_agents", &self.active_agents);
        formatter.field("healthy_agents", &self.healthy_agents);
        formatter.field("black_listed_agents", &self.black_listed_agents);
        formatter.field("shutdown_agents", &self.shutdown_agents);
        formatter.field("unhealthy_agents", &self.unhealthy_agents);
        formatter.field("total_agents", &self.total_agents);
        formatter.field("unknown_agents", &self.unknown_agents);
        formatter.finish()
    }
}
/// See [`CustomerAgentInfo`](crate::model::CustomerAgentInfo)
pub mod customer_agent_info {
    /// A builder for [`CustomerAgentInfo`](crate::model::CustomerAgentInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) active_agents: std::option::Option<i32>,
        pub(crate) healthy_agents: std::option::Option<i32>,
        pub(crate) black_listed_agents: std::option::Option<i32>,
        pub(crate) shutdown_agents: std::option::Option<i32>,
        pub(crate) unhealthy_agents: std::option::Option<i32>,
        pub(crate) total_agents: std::option::Option<i32>,
        pub(crate) unknown_agents: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Number of active discovery agents.</p>
        pub fn active_agents(mut self, input: i32) -> Self {
            self.active_agents = Some(input);
            self
        }
        /// <p>Number of active discovery agents.</p>
        pub fn set_active_agents(mut self, input: std::option::Option<i32>) -> Self {
            self.active_agents = input;
            self
        }
        /// <p>Number of healthy discovery agents</p>
        pub fn healthy_agents(mut self, input: i32) -> Self {
            self.healthy_agents = Some(input);
            self
        }
        /// <p>Number of healthy discovery agents</p>
        pub fn set_healthy_agents(mut self, input: std::option::Option<i32>) -> Self {
            self.healthy_agents = input;
            self
        }
        /// <p>Number of blacklisted discovery agents.</p>
        pub fn black_listed_agents(mut self, input: i32) -> Self {
            self.black_listed_agents = Some(input);
            self
        }
        /// <p>Number of blacklisted discovery agents.</p>
        pub fn set_black_listed_agents(mut self, input: std::option::Option<i32>) -> Self {
            self.black_listed_agents = input;
            self
        }
        /// <p>Number of discovery agents with status SHUTDOWN.</p>
        pub fn shutdown_agents(mut self, input: i32) -> Self {
            self.shutdown_agents = Some(input);
            self
        }
        /// <p>Number of discovery agents with status SHUTDOWN.</p>
        pub fn set_shutdown_agents(mut self, input: std::option::Option<i32>) -> Self {
            self.shutdown_agents = input;
            self
        }
        /// <p>Number of unhealthy discovery agents.</p>
        pub fn unhealthy_agents(mut self, input: i32) -> Self {
            self.unhealthy_agents = Some(input);
            self
        }
        /// <p>Number of unhealthy discovery agents.</p>
        pub fn set_unhealthy_agents(mut self, input: std::option::Option<i32>) -> Self {
            self.unhealthy_agents = input;
            self
        }
        /// <p>Total number of discovery agents.</p>
        pub fn total_agents(mut self, input: i32) -> Self {
            self.total_agents = Some(input);
            self
        }
        /// <p>Total number of discovery agents.</p>
        pub fn set_total_agents(mut self, input: std::option::Option<i32>) -> Self {
            self.total_agents = input;
            self
        }
        /// <p>Number of unknown discovery agents.</p>
        pub fn unknown_agents(mut self, input: i32) -> Self {
            self.unknown_agents = Some(input);
            self
        }
        /// <p>Number of unknown discovery agents.</p>
        pub fn set_unknown_agents(mut self, input: std::option::Option<i32>) -> Self {
            self.unknown_agents = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomerAgentInfo`](crate::model::CustomerAgentInfo)
        pub fn build(self) -> crate::model::CustomerAgentInfo {
            crate::model::CustomerAgentInfo {
                active_agents: self.active_agents.unwrap_or_default(),
                healthy_agents: self.healthy_agents.unwrap_or_default(),
                black_listed_agents: self.black_listed_agents.unwrap_or_default(),
                shutdown_agents: self.shutdown_agents.unwrap_or_default(),
                unhealthy_agents: self.unhealthy_agents.unwrap_or_default(),
                total_agents: self.total_agents.unwrap_or_default(),
                unknown_agents: self.unknown_agents.unwrap_or_default(),
            }
        }
    }
}
impl CustomerAgentInfo {
    /// Creates a new builder-style object to manufacture [`CustomerAgentInfo`](crate::model::CustomerAgentInfo)
    pub fn builder() -> crate::model::customer_agent_info::Builder {
        crate::model::customer_agent_info::Builder::default()
    }
}

/// <p>Tags for a configuration item. Tags are metadata that help you categorize IT
/// assets.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConfigurationTag {
    /// <p>A type of IT asset to tag.</p>
    pub configuration_type: std::option::Option<crate::model::ConfigurationItemType>,
    /// <p>The configuration ID for the item to tag. You can specify a list of keys and
    /// values.</p>
    pub configuration_id: std::option::Option<std::string::String>,
    /// <p>A type of tag on which to filter. For example,
    /// <i>serverType</i>.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>A value on which to filter. For example <i>key = serverType</i> and
    /// <i>value = web server</i>.</p>
    pub value: std::option::Option<std::string::String>,
    /// <p>The time the configuration tag was created in Coordinated Universal Time
    /// (UTC).</p>
    pub time_of_creation: std::option::Option<aws_smithy_types::Instant>,
}
impl ConfigurationTag {
    /// <p>A type of IT asset to tag.</p>
    pub fn configuration_type(&self) -> std::option::Option<&crate::model::ConfigurationItemType> {
        self.configuration_type.as_ref()
    }
    /// <p>The configuration ID for the item to tag. You can specify a list of keys and
    /// values.</p>
    pub fn configuration_id(&self) -> std::option::Option<&str> {
        self.configuration_id.as_deref()
    }
    /// <p>A type of tag on which to filter. For example,
    /// <i>serverType</i>.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>A value on which to filter. For example <i>key = serverType</i> and
    /// <i>value = web server</i>.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
    /// <p>The time the configuration tag was created in Coordinated Universal Time
    /// (UTC).</p>
    pub fn time_of_creation(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.time_of_creation.as_ref()
    }
}
impl std::fmt::Debug for ConfigurationTag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConfigurationTag");
        formatter.field("configuration_type", &self.configuration_type);
        formatter.field("configuration_id", &self.configuration_id);
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.field("time_of_creation", &self.time_of_creation);
        formatter.finish()
    }
}
/// See [`ConfigurationTag`](crate::model::ConfigurationTag)
pub mod configuration_tag {
    /// A builder for [`ConfigurationTag`](crate::model::ConfigurationTag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_type: std::option::Option<crate::model::ConfigurationItemType>,
        pub(crate) configuration_id: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) time_of_creation: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>A type of IT asset to tag.</p>
        pub fn configuration_type(mut self, input: crate::model::ConfigurationItemType) -> Self {
            self.configuration_type = Some(input);
            self
        }
        /// <p>A type of IT asset to tag.</p>
        pub fn set_configuration_type(
            mut self,
            input: std::option::Option<crate::model::ConfigurationItemType>,
        ) -> Self {
            self.configuration_type = input;
            self
        }
        /// <p>The configuration ID for the item to tag. You can specify a list of keys and
        /// values.</p>
        pub fn configuration_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_id = Some(input.into());
            self
        }
        /// <p>The configuration ID for the item to tag. You can specify a list of keys and
        /// values.</p>
        pub fn set_configuration_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_id = input;
            self
        }
        /// <p>A type of tag on which to filter. For example,
        /// <i>serverType</i>.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>A type of tag on which to filter. For example,
        /// <i>serverType</i>.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>A value on which to filter. For example <i>key = serverType</i> and
        /// <i>value = web server</i>.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>A value on which to filter. For example <i>key = serverType</i> and
        /// <i>value = web server</i>.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// <p>The time the configuration tag was created in Coordinated Universal Time
        /// (UTC).</p>
        pub fn time_of_creation(mut self, input: aws_smithy_types::Instant) -> Self {
            self.time_of_creation = Some(input);
            self
        }
        /// <p>The time the configuration tag was created in Coordinated Universal Time
        /// (UTC).</p>
        pub fn set_time_of_creation(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.time_of_creation = input;
            self
        }
        /// Consumes the builder and constructs a [`ConfigurationTag`](crate::model::ConfigurationTag)
        pub fn build(self) -> crate::model::ConfigurationTag {
            crate::model::ConfigurationTag {
                configuration_type: self.configuration_type,
                configuration_id: self.configuration_id,
                key: self.key,
                value: self.value,
                time_of_creation: self.time_of_creation,
            }
        }
    }
}
impl ConfigurationTag {
    /// Creates a new builder-style object to manufacture [`ConfigurationTag`](crate::model::ConfigurationTag)
    pub fn builder() -> crate::model::configuration_tag::Builder {
        crate::model::configuration_tag::Builder::default()
    }
}

/// <p>The tag filter. Valid names are: <code>tagKey</code>, <code>tagValue</code>,
/// <code>configurationId</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagFilter {
    /// <p>A name of the tag filter.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Values for the tag filter.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl TagFilter {
    /// <p>A name of the tag filter.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Values for the tag filter.</p>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for TagFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagFilter");
        formatter.field("name", &self.name);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`TagFilter`](crate::model::TagFilter)
pub mod tag_filter {
    /// A builder for [`TagFilter`](crate::model::TagFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>A name of the tag filter.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A name of the tag filter.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>Values for the tag filter.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>Values for the tag filter.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`TagFilter`](crate::model::TagFilter)
        pub fn build(self) -> crate::model::TagFilter {
            crate::model::TagFilter {
                name: self.name,
                values: self.values,
            }
        }
    }
}
impl TagFilter {
    /// Creates a new builder-style object to manufacture [`TagFilter`](crate::model::TagFilter)
    pub fn builder() -> crate::model::tag_filter::Builder {
        crate::model::tag_filter::Builder::default()
    }
}

/// <p>A name-values pair of elements you can use to filter the results when querying your import
/// tasks. Currently, wildcards are not supported for filters.</p>
///
/// <note>
/// <p>When filtering by import status, all other filter values are ignored.</p>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImportTaskFilter {
    /// <p>The name, status, or import task ID for a specific import task.</p>
    pub name: std::option::Option<crate::model::ImportTaskFilterName>,
    /// <p>An array of strings that you can provide to match against a specific name, status, or
    /// import task ID to filter the results for your import task queries.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ImportTaskFilter {
    /// <p>The name, status, or import task ID for a specific import task.</p>
    pub fn name(&self) -> std::option::Option<&crate::model::ImportTaskFilterName> {
        self.name.as_ref()
    }
    /// <p>An array of strings that you can provide to match against a specific name, status, or
    /// import task ID to filter the results for your import task queries.</p>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for ImportTaskFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImportTaskFilter");
        formatter.field("name", &self.name);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`ImportTaskFilter`](crate::model::ImportTaskFilter)
pub mod import_task_filter {
    /// A builder for [`ImportTaskFilter`](crate::model::ImportTaskFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::ImportTaskFilterName>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name, status, or import task ID for a specific import task.</p>
        pub fn name(mut self, input: crate::model::ImportTaskFilterName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The name, status, or import task ID for a specific import task.</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::ImportTaskFilterName>,
        ) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>An array of strings that you can provide to match against a specific name, status, or
        /// import task ID to filter the results for your import task queries.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>An array of strings that you can provide to match against a specific name, status, or
        /// import task ID to filter the results for your import task queries.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`ImportTaskFilter`](crate::model::ImportTaskFilter)
        pub fn build(self) -> crate::model::ImportTaskFilter {
            crate::model::ImportTaskFilter {
                name: self.name,
                values: self.values,
            }
        }
    }
}
impl ImportTaskFilter {
    /// Creates a new builder-style object to manufacture [`ImportTaskFilter`](crate::model::ImportTaskFilter)
    pub fn builder() -> crate::model::import_task_filter::Builder {
        crate::model::import_task_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ImportTaskFilterName {
    #[allow(missing_docs)] // documentation missing in model
    ImportTaskId,
    #[allow(missing_docs)] // documentation missing in model
    Name,
    #[allow(missing_docs)] // documentation missing in model
    Status,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ImportTaskFilterName {
    fn from(s: &str) -> Self {
        match s {
            "IMPORT_TASK_ID" => ImportTaskFilterName::ImportTaskId,
            "NAME" => ImportTaskFilterName::Name,
            "STATUS" => ImportTaskFilterName::Status,
            other => ImportTaskFilterName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ImportTaskFilterName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ImportTaskFilterName::from(s))
    }
}
impl ImportTaskFilterName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ImportTaskFilterName::ImportTaskId => "IMPORT_TASK_ID",
            ImportTaskFilterName::Name => "NAME",
            ImportTaskFilterName::Status => "STATUS",
            ImportTaskFilterName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["IMPORT_TASK_ID", "NAME", "STATUS"]
    }
}
impl AsRef<str> for ImportTaskFilterName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information regarding the export status of discovered data. The value is an array of
/// objects.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExportInfo {
    /// <p>A unique identifier used to query an export.</p>
    pub export_id: std::option::Option<std::string::String>,
    /// <p>The status of the data export job.</p>
    pub export_status: std::option::Option<crate::model::ExportStatus>,
    /// <p>A status message provided for API callers.</p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p>A URL for an Amazon S3 bucket where you can review the exported data. The URL is
    /// displayed only if the export succeeded.</p>
    pub configurations_download_url: std::option::Option<std::string::String>,
    /// <p>The time that the data export was initiated.</p>
    pub export_request_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>If true, the export of agent information exceeded the size limit for a single export
    /// and the exported data is incomplete for the requested time range. To address this, select a
    /// smaller time range for the export by using <code>startDate</code> and
    /// <code>endDate</code>.</p>
    pub is_truncated: bool,
    /// <p>The value of <code>startTime</code> parameter in the <code>StartExportTask</code>
    /// request. If no <code>startTime</code> was requested, this result does not appear in
    /// <code>ExportInfo</code>.</p>
    pub requested_start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The <code>endTime</code> used in the <code>StartExportTask</code> request. If no
    /// <code>endTime</code> was requested, this result does not appear in
    /// <code>ExportInfo</code>.</p>
    pub requested_end_time: std::option::Option<aws_smithy_types::Instant>,
}
impl ExportInfo {
    /// <p>A unique identifier used to query an export.</p>
    pub fn export_id(&self) -> std::option::Option<&str> {
        self.export_id.as_deref()
    }
    /// <p>The status of the data export job.</p>
    pub fn export_status(&self) -> std::option::Option<&crate::model::ExportStatus> {
        self.export_status.as_ref()
    }
    /// <p>A status message provided for API callers.</p>
    pub fn status_message(&self) -> std::option::Option<&str> {
        self.status_message.as_deref()
    }
    /// <p>A URL for an Amazon S3 bucket where you can review the exported data. The URL is
    /// displayed only if the export succeeded.</p>
    pub fn configurations_download_url(&self) -> std::option::Option<&str> {
        self.configurations_download_url.as_deref()
    }
    /// <p>The time that the data export was initiated.</p>
    pub fn export_request_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.export_request_time.as_ref()
    }
    /// <p>If true, the export of agent information exceeded the size limit for a single export
    /// and the exported data is incomplete for the requested time range. To address this, select a
    /// smaller time range for the export by using <code>startDate</code> and
    /// <code>endDate</code>.</p>
    pub fn is_truncated(&self) -> bool {
        self.is_truncated
    }
    /// <p>The value of <code>startTime</code> parameter in the <code>StartExportTask</code>
    /// request. If no <code>startTime</code> was requested, this result does not appear in
    /// <code>ExportInfo</code>.</p>
    pub fn requested_start_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.requested_start_time.as_ref()
    }
    /// <p>The <code>endTime</code> used in the <code>StartExportTask</code> request. If no
    /// <code>endTime</code> was requested, this result does not appear in
    /// <code>ExportInfo</code>.</p>
    pub fn requested_end_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.requested_end_time.as_ref()
    }
}
impl std::fmt::Debug for ExportInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExportInfo");
        formatter.field("export_id", &self.export_id);
        formatter.field("export_status", &self.export_status);
        formatter.field("status_message", &self.status_message);
        formatter.field(
            "configurations_download_url",
            &self.configurations_download_url,
        );
        formatter.field("export_request_time", &self.export_request_time);
        formatter.field("is_truncated", &self.is_truncated);
        formatter.field("requested_start_time", &self.requested_start_time);
        formatter.field("requested_end_time", &self.requested_end_time);
        formatter.finish()
    }
}
/// See [`ExportInfo`](crate::model::ExportInfo)
pub mod export_info {
    /// A builder for [`ExportInfo`](crate::model::ExportInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) export_id: std::option::Option<std::string::String>,
        pub(crate) export_status: std::option::Option<crate::model::ExportStatus>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) configurations_download_url: std::option::Option<std::string::String>,
        pub(crate) export_request_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) is_truncated: std::option::Option<bool>,
        pub(crate) requested_start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) requested_end_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>A unique identifier used to query an export.</p>
        pub fn export_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.export_id = Some(input.into());
            self
        }
        /// <p>A unique identifier used to query an export.</p>
        pub fn set_export_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.export_id = input;
            self
        }
        /// <p>The status of the data export job.</p>
        pub fn export_status(mut self, input: crate::model::ExportStatus) -> Self {
            self.export_status = Some(input);
            self
        }
        /// <p>The status of the data export job.</p>
        pub fn set_export_status(
            mut self,
            input: std::option::Option<crate::model::ExportStatus>,
        ) -> Self {
            self.export_status = input;
            self
        }
        /// <p>A status message provided for API callers.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>A status message provided for API callers.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// <p>A URL for an Amazon S3 bucket where you can review the exported data. The URL is
        /// displayed only if the export succeeded.</p>
        pub fn configurations_download_url(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.configurations_download_url = Some(input.into());
            self
        }
        /// <p>A URL for an Amazon S3 bucket where you can review the exported data. The URL is
        /// displayed only if the export succeeded.</p>
        pub fn set_configurations_download_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configurations_download_url = input;
            self
        }
        /// <p>The time that the data export was initiated.</p>
        pub fn export_request_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.export_request_time = Some(input);
            self
        }
        /// <p>The time that the data export was initiated.</p>
        pub fn set_export_request_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.export_request_time = input;
            self
        }
        /// <p>If true, the export of agent information exceeded the size limit for a single export
        /// and the exported data is incomplete for the requested time range. To address this, select a
        /// smaller time range for the export by using <code>startDate</code> and
        /// <code>endDate</code>.</p>
        pub fn is_truncated(mut self, input: bool) -> Self {
            self.is_truncated = Some(input);
            self
        }
        /// <p>If true, the export of agent information exceeded the size limit for a single export
        /// and the exported data is incomplete for the requested time range. To address this, select a
        /// smaller time range for the export by using <code>startDate</code> and
        /// <code>endDate</code>.</p>
        pub fn set_is_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.is_truncated = input;
            self
        }
        /// <p>The value of <code>startTime</code> parameter in the <code>StartExportTask</code>
        /// request. If no <code>startTime</code> was requested, this result does not appear in
        /// <code>ExportInfo</code>.</p>
        pub fn requested_start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.requested_start_time = Some(input);
            self
        }
        /// <p>The value of <code>startTime</code> parameter in the <code>StartExportTask</code>
        /// request. If no <code>startTime</code> was requested, this result does not appear in
        /// <code>ExportInfo</code>.</p>
        pub fn set_requested_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.requested_start_time = input;
            self
        }
        /// <p>The <code>endTime</code> used in the <code>StartExportTask</code> request. If no
        /// <code>endTime</code> was requested, this result does not appear in
        /// <code>ExportInfo</code>.</p>
        pub fn requested_end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.requested_end_time = Some(input);
            self
        }
        /// <p>The <code>endTime</code> used in the <code>StartExportTask</code> request. If no
        /// <code>endTime</code> was requested, this result does not appear in
        /// <code>ExportInfo</code>.</p>
        pub fn set_requested_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.requested_end_time = input;
            self
        }
        /// Consumes the builder and constructs a [`ExportInfo`](crate::model::ExportInfo)
        pub fn build(self) -> crate::model::ExportInfo {
            crate::model::ExportInfo {
                export_id: self.export_id,
                export_status: self.export_status,
                status_message: self.status_message,
                configurations_download_url: self.configurations_download_url,
                export_request_time: self.export_request_time,
                is_truncated: self.is_truncated.unwrap_or_default(),
                requested_start_time: self.requested_start_time,
                requested_end_time: self.requested_end_time,
            }
        }
    }
}
impl ExportInfo {
    /// Creates a new builder-style object to manufacture [`ExportInfo`](crate::model::ExportInfo)
    pub fn builder() -> crate::model::export_info::Builder {
        crate::model::export_info::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ExportStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ExportStatus {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => ExportStatus::Failed,
            "IN_PROGRESS" => ExportStatus::InProgress,
            "SUCCEEDED" => ExportStatus::Succeeded,
            other => ExportStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ExportStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ExportStatus::from(s))
    }
}
impl ExportStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ExportStatus::Failed => "FAILED",
            ExportStatus::InProgress => "IN_PROGRESS",
            ExportStatus::Succeeded => "SUCCEEDED",
            ExportStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAILED", "IN_PROGRESS", "SUCCEEDED"]
    }
}
impl AsRef<str> for ExportStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A list of continuous export descriptions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ContinuousExportDescription {
    /// <p>The unique ID assigned to this export.</p>
    pub export_id: std::option::Option<std::string::String>,
    /// <p>Describes the status of the export. Can be one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>START_IN_PROGRESS - setting up resources to start continuous export.</p>
    /// </li>
    /// <li>
    /// <p>START_FAILED - an error occurred setting up continuous export. To recover, call
    /// start-continuous-export again.</p>
    /// </li>
    /// <li>
    /// <p>ACTIVE - data is being exported to the customer bucket.</p>
    /// </li>
    /// <li>
    /// <p>ERROR - an error occurred during export. To fix the issue, call
    /// stop-continuous-export and start-continuous-export.</p>
    /// </li>
    /// <li>
    /// <p>STOP_IN_PROGRESS - stopping the export.</p>
    /// </li>
    /// <li>
    /// <p>STOP_FAILED - an error occurred stopping the export. To recover, call
    /// stop-continuous-export again.</p>
    /// </li>
    /// <li>
    /// <p>INACTIVE - the continuous export has been stopped. Data is no longer being exported
    /// to the customer bucket.</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::ContinuousExportStatus>,
    /// <p>Contains information about any errors that have occurred. This data type can have the
    /// following values:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>ACCESS_DENIED - You don’t have permission to start Data Exploration in Amazon
    /// Athena. Contact your AWS administrator for help. For more information, see <a href="http://docs.aws.amazon.com/application-discovery/latest/userguide/setting-up.html">Setting Up AWS Application Discovery Service</a> in the Application Discovery
    /// Service User Guide.</p>
    /// </li>
    /// <li>
    /// <p>DELIVERY_STREAM_LIMIT_FAILURE - You reached the limit for Amazon Kinesis Data
    /// Firehose delivery streams. Reduce the number of streams or request a limit increase and
    /// try again. For more information, see <a href="http://docs.aws.amazon.com/streams/latest/dev/service-sizes-and-limits.html">Kinesis Data Streams Limits</a> in the Amazon Kinesis Data Streams Developer
    /// Guide.</p>
    /// </li>
    /// <li>
    /// <p>FIREHOSE_ROLE_MISSING - The Data Exploration feature is in an error state because
    /// your IAM User is missing the AWSApplicationDiscoveryServiceFirehose role. Turn on Data
    /// Exploration in Amazon Athena and try again. For more information, see <a href="http://docs.aws.amazon.com/application-discovery/latest/userguide/setting-up.html#setting-up-user-policy">Step 3: Provide Application Discovery Service Access to Non-Administrator Users by
    /// Attaching Policies</a> in the Application Discovery Service User Guide.</p>
    /// </li>
    /// <li>
    /// <p>FIREHOSE_STREAM_DOES_NOT_EXIST - The Data Exploration feature is in an error state
    /// because your IAM User is missing one or more of the Kinesis data delivery
    /// streams.</p>
    /// </li>
    /// <li>
    /// <p>INTERNAL_FAILURE - The Data Exploration feature is in an error state because of an
    /// internal failure. Try again later. If this problem persists, contact AWS
    /// Support.</p>
    /// </li>
    /// <li>
    /// <p>S3_BUCKET_LIMIT_FAILURE - You reached the limit for Amazon S3 buckets. Reduce the
    /// number of Amazon S3 buckets or request a limit increase and try again. For more
    /// information, see <a href="http://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html">Bucket
    /// Restrictions and Limitations</a> in the Amazon Simple Storage Service Developer
    /// Guide.</p>
    /// </li>
    /// <li>
    /// <p>S3_NOT_SIGNED_UP - Your account is not signed up for the Amazon S3 service. You
    /// must sign up before you can use Amazon S3. You can sign up at the following URL: <a href="https://aws.amazon.com/s3">https://aws.amazon.com/s3</a>.</p>
    /// </li>
    /// </ul>
    pub status_detail: std::option::Option<std::string::String>,
    /// <p>The name of the s3 bucket where the export data parquet files are stored.</p>
    pub s3_bucket: std::option::Option<std::string::String>,
    /// <p>The timestamp representing when the continuous export was started.</p>
    pub start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The timestamp that represents when this continuous export was stopped.</p>
    pub stop_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The type of data collector used to gather this data (currently only offered for
    /// AGENT).</p>
    pub data_source: std::option::Option<crate::model::DataSource>,
    /// <p>An object which describes how the data is stored.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>databaseName</code> - the name of the Glue database used to store the
    /// schema.</p>
    /// </li>
    /// </ul>
    pub schema_storage_config:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ContinuousExportDescription {
    /// <p>The unique ID assigned to this export.</p>
    pub fn export_id(&self) -> std::option::Option<&str> {
        self.export_id.as_deref()
    }
    /// <p>Describes the status of the export. Can be one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>START_IN_PROGRESS - setting up resources to start continuous export.</p>
    /// </li>
    /// <li>
    /// <p>START_FAILED - an error occurred setting up continuous export. To recover, call
    /// start-continuous-export again.</p>
    /// </li>
    /// <li>
    /// <p>ACTIVE - data is being exported to the customer bucket.</p>
    /// </li>
    /// <li>
    /// <p>ERROR - an error occurred during export. To fix the issue, call
    /// stop-continuous-export and start-continuous-export.</p>
    /// </li>
    /// <li>
    /// <p>STOP_IN_PROGRESS - stopping the export.</p>
    /// </li>
    /// <li>
    /// <p>STOP_FAILED - an error occurred stopping the export. To recover, call
    /// stop-continuous-export again.</p>
    /// </li>
    /// <li>
    /// <p>INACTIVE - the continuous export has been stopped. Data is no longer being exported
    /// to the customer bucket.</p>
    /// </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::ContinuousExportStatus> {
        self.status.as_ref()
    }
    /// <p>Contains information about any errors that have occurred. This data type can have the
    /// following values:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>ACCESS_DENIED - You don’t have permission to start Data Exploration in Amazon
    /// Athena. Contact your AWS administrator for help. For more information, see <a href="http://docs.aws.amazon.com/application-discovery/latest/userguide/setting-up.html">Setting Up AWS Application Discovery Service</a> in the Application Discovery
    /// Service User Guide.</p>
    /// </li>
    /// <li>
    /// <p>DELIVERY_STREAM_LIMIT_FAILURE - You reached the limit for Amazon Kinesis Data
    /// Firehose delivery streams. Reduce the number of streams or request a limit increase and
    /// try again. For more information, see <a href="http://docs.aws.amazon.com/streams/latest/dev/service-sizes-and-limits.html">Kinesis Data Streams Limits</a> in the Amazon Kinesis Data Streams Developer
    /// Guide.</p>
    /// </li>
    /// <li>
    /// <p>FIREHOSE_ROLE_MISSING - The Data Exploration feature is in an error state because
    /// your IAM User is missing the AWSApplicationDiscoveryServiceFirehose role. Turn on Data
    /// Exploration in Amazon Athena and try again. For more information, see <a href="http://docs.aws.amazon.com/application-discovery/latest/userguide/setting-up.html#setting-up-user-policy">Step 3: Provide Application Discovery Service Access to Non-Administrator Users by
    /// Attaching Policies</a> in the Application Discovery Service User Guide.</p>
    /// </li>
    /// <li>
    /// <p>FIREHOSE_STREAM_DOES_NOT_EXIST - The Data Exploration feature is in an error state
    /// because your IAM User is missing one or more of the Kinesis data delivery
    /// streams.</p>
    /// </li>
    /// <li>
    /// <p>INTERNAL_FAILURE - The Data Exploration feature is in an error state because of an
    /// internal failure. Try again later. If this problem persists, contact AWS
    /// Support.</p>
    /// </li>
    /// <li>
    /// <p>S3_BUCKET_LIMIT_FAILURE - You reached the limit for Amazon S3 buckets. Reduce the
    /// number of Amazon S3 buckets or request a limit increase and try again. For more
    /// information, see <a href="http://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html">Bucket
    /// Restrictions and Limitations</a> in the Amazon Simple Storage Service Developer
    /// Guide.</p>
    /// </li>
    /// <li>
    /// <p>S3_NOT_SIGNED_UP - Your account is not signed up for the Amazon S3 service. You
    /// must sign up before you can use Amazon S3. You can sign up at the following URL: <a href="https://aws.amazon.com/s3">https://aws.amazon.com/s3</a>.</p>
    /// </li>
    /// </ul>
    pub fn status_detail(&self) -> std::option::Option<&str> {
        self.status_detail.as_deref()
    }
    /// <p>The name of the s3 bucket where the export data parquet files are stored.</p>
    pub fn s3_bucket(&self) -> std::option::Option<&str> {
        self.s3_bucket.as_deref()
    }
    /// <p>The timestamp representing when the continuous export was started.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.start_time.as_ref()
    }
    /// <p>The timestamp that represents when this continuous export was stopped.</p>
    pub fn stop_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.stop_time.as_ref()
    }
    /// <p>The type of data collector used to gather this data (currently only offered for
    /// AGENT).</p>
    pub fn data_source(&self) -> std::option::Option<&crate::model::DataSource> {
        self.data_source.as_ref()
    }
    /// <p>An object which describes how the data is stored.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>databaseName</code> - the name of the Glue database used to store the
    /// schema.</p>
    /// </li>
    /// </ul>
    pub fn schema_storage_config(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.schema_storage_config.as_ref()
    }
}
impl std::fmt::Debug for ContinuousExportDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ContinuousExportDescription");
        formatter.field("export_id", &self.export_id);
        formatter.field("status", &self.status);
        formatter.field("status_detail", &self.status_detail);
        formatter.field("s3_bucket", &self.s3_bucket);
        formatter.field("start_time", &self.start_time);
        formatter.field("stop_time", &self.stop_time);
        formatter.field("data_source", &self.data_source);
        formatter.field("schema_storage_config", &self.schema_storage_config);
        formatter.finish()
    }
}
/// See [`ContinuousExportDescription`](crate::model::ContinuousExportDescription)
pub mod continuous_export_description {
    /// A builder for [`ContinuousExportDescription`](crate::model::ContinuousExportDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) export_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ContinuousExportStatus>,
        pub(crate) status_detail: std::option::Option<std::string::String>,
        pub(crate) s3_bucket: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) stop_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) data_source: std::option::Option<crate::model::DataSource>,
        pub(crate) schema_storage_config: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The unique ID assigned to this export.</p>
        pub fn export_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.export_id = Some(input.into());
            self
        }
        /// <p>The unique ID assigned to this export.</p>
        pub fn set_export_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.export_id = input;
            self
        }
        /// <p>Describes the status of the export. Can be one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>START_IN_PROGRESS - setting up resources to start continuous export.</p>
        /// </li>
        /// <li>
        /// <p>START_FAILED - an error occurred setting up continuous export. To recover, call
        /// start-continuous-export again.</p>
        /// </li>
        /// <li>
        /// <p>ACTIVE - data is being exported to the customer bucket.</p>
        /// </li>
        /// <li>
        /// <p>ERROR - an error occurred during export. To fix the issue, call
        /// stop-continuous-export and start-continuous-export.</p>
        /// </li>
        /// <li>
        /// <p>STOP_IN_PROGRESS - stopping the export.</p>
        /// </li>
        /// <li>
        /// <p>STOP_FAILED - an error occurred stopping the export. To recover, call
        /// stop-continuous-export again.</p>
        /// </li>
        /// <li>
        /// <p>INACTIVE - the continuous export has been stopped. Data is no longer being exported
        /// to the customer bucket.</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::ContinuousExportStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Describes the status of the export. Can be one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>START_IN_PROGRESS - setting up resources to start continuous export.</p>
        /// </li>
        /// <li>
        /// <p>START_FAILED - an error occurred setting up continuous export. To recover, call
        /// start-continuous-export again.</p>
        /// </li>
        /// <li>
        /// <p>ACTIVE - data is being exported to the customer bucket.</p>
        /// </li>
        /// <li>
        /// <p>ERROR - an error occurred during export. To fix the issue, call
        /// stop-continuous-export and start-continuous-export.</p>
        /// </li>
        /// <li>
        /// <p>STOP_IN_PROGRESS - stopping the export.</p>
        /// </li>
        /// <li>
        /// <p>STOP_FAILED - an error occurred stopping the export. To recover, call
        /// stop-continuous-export again.</p>
        /// </li>
        /// <li>
        /// <p>INACTIVE - the continuous export has been stopped. Data is no longer being exported
        /// to the customer bucket.</p>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ContinuousExportStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Contains information about any errors that have occurred. This data type can have the
        /// following values:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>ACCESS_DENIED - You don’t have permission to start Data Exploration in Amazon
        /// Athena. Contact your AWS administrator for help. For more information, see <a href="http://docs.aws.amazon.com/application-discovery/latest/userguide/setting-up.html">Setting Up AWS Application Discovery Service</a> in the Application Discovery
        /// Service User Guide.</p>
        /// </li>
        /// <li>
        /// <p>DELIVERY_STREAM_LIMIT_FAILURE - You reached the limit for Amazon Kinesis Data
        /// Firehose delivery streams. Reduce the number of streams or request a limit increase and
        /// try again. For more information, see <a href="http://docs.aws.amazon.com/streams/latest/dev/service-sizes-and-limits.html">Kinesis Data Streams Limits</a> in the Amazon Kinesis Data Streams Developer
        /// Guide.</p>
        /// </li>
        /// <li>
        /// <p>FIREHOSE_ROLE_MISSING - The Data Exploration feature is in an error state because
        /// your IAM User is missing the AWSApplicationDiscoveryServiceFirehose role. Turn on Data
        /// Exploration in Amazon Athena and try again. For more information, see <a href="http://docs.aws.amazon.com/application-discovery/latest/userguide/setting-up.html#setting-up-user-policy">Step 3: Provide Application Discovery Service Access to Non-Administrator Users by
        /// Attaching Policies</a> in the Application Discovery Service User Guide.</p>
        /// </li>
        /// <li>
        /// <p>FIREHOSE_STREAM_DOES_NOT_EXIST - The Data Exploration feature is in an error state
        /// because your IAM User is missing one or more of the Kinesis data delivery
        /// streams.</p>
        /// </li>
        /// <li>
        /// <p>INTERNAL_FAILURE - The Data Exploration feature is in an error state because of an
        /// internal failure. Try again later. If this problem persists, contact AWS
        /// Support.</p>
        /// </li>
        /// <li>
        /// <p>S3_BUCKET_LIMIT_FAILURE - You reached the limit for Amazon S3 buckets. Reduce the
        /// number of Amazon S3 buckets or request a limit increase and try again. For more
        /// information, see <a href="http://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html">Bucket
        /// Restrictions and Limitations</a> in the Amazon Simple Storage Service Developer
        /// Guide.</p>
        /// </li>
        /// <li>
        /// <p>S3_NOT_SIGNED_UP - Your account is not signed up for the Amazon S3 service. You
        /// must sign up before you can use Amazon S3. You can sign up at the following URL: <a href="https://aws.amazon.com/s3">https://aws.amazon.com/s3</a>.</p>
        /// </li>
        /// </ul>
        pub fn status_detail(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_detail = Some(input.into());
            self
        }
        /// <p>Contains information about any errors that have occurred. This data type can have the
        /// following values:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>ACCESS_DENIED - You don’t have permission to start Data Exploration in Amazon
        /// Athena. Contact your AWS administrator for help. For more information, see <a href="http://docs.aws.amazon.com/application-discovery/latest/userguide/setting-up.html">Setting Up AWS Application Discovery Service</a> in the Application Discovery
        /// Service User Guide.</p>
        /// </li>
        /// <li>
        /// <p>DELIVERY_STREAM_LIMIT_FAILURE - You reached the limit for Amazon Kinesis Data
        /// Firehose delivery streams. Reduce the number of streams or request a limit increase and
        /// try again. For more information, see <a href="http://docs.aws.amazon.com/streams/latest/dev/service-sizes-and-limits.html">Kinesis Data Streams Limits</a> in the Amazon Kinesis Data Streams Developer
        /// Guide.</p>
        /// </li>
        /// <li>
        /// <p>FIREHOSE_ROLE_MISSING - The Data Exploration feature is in an error state because
        /// your IAM User is missing the AWSApplicationDiscoveryServiceFirehose role. Turn on Data
        /// Exploration in Amazon Athena and try again. For more information, see <a href="http://docs.aws.amazon.com/application-discovery/latest/userguide/setting-up.html#setting-up-user-policy">Step 3: Provide Application Discovery Service Access to Non-Administrator Users by
        /// Attaching Policies</a> in the Application Discovery Service User Guide.</p>
        /// </li>
        /// <li>
        /// <p>FIREHOSE_STREAM_DOES_NOT_EXIST - The Data Exploration feature is in an error state
        /// because your IAM User is missing one or more of the Kinesis data delivery
        /// streams.</p>
        /// </li>
        /// <li>
        /// <p>INTERNAL_FAILURE - The Data Exploration feature is in an error state because of an
        /// internal failure. Try again later. If this problem persists, contact AWS
        /// Support.</p>
        /// </li>
        /// <li>
        /// <p>S3_BUCKET_LIMIT_FAILURE - You reached the limit for Amazon S3 buckets. Reduce the
        /// number of Amazon S3 buckets or request a limit increase and try again. For more
        /// information, see <a href="http://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html">Bucket
        /// Restrictions and Limitations</a> in the Amazon Simple Storage Service Developer
        /// Guide.</p>
        /// </li>
        /// <li>
        /// <p>S3_NOT_SIGNED_UP - Your account is not signed up for the Amazon S3 service. You
        /// must sign up before you can use Amazon S3. You can sign up at the following URL: <a href="https://aws.amazon.com/s3">https://aws.amazon.com/s3</a>.</p>
        /// </li>
        /// </ul>
        pub fn set_status_detail(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_detail = input;
            self
        }
        /// <p>The name of the s3 bucket where the export data parquet files are stored.</p>
        pub fn s3_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket = Some(input.into());
            self
        }
        /// <p>The name of the s3 bucket where the export data parquet files are stored.</p>
        pub fn set_s3_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_bucket = input;
            self
        }
        /// <p>The timestamp representing when the continuous export was started.</p>
        pub fn start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The timestamp representing when the continuous export was started.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The timestamp that represents when this continuous export was stopped.</p>
        pub fn stop_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.stop_time = Some(input);
            self
        }
        /// <p>The timestamp that represents when this continuous export was stopped.</p>
        pub fn set_stop_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.stop_time = input;
            self
        }
        /// <p>The type of data collector used to gather this data (currently only offered for
        /// AGENT).</p>
        pub fn data_source(mut self, input: crate::model::DataSource) -> Self {
            self.data_source = Some(input);
            self
        }
        /// <p>The type of data collector used to gather this data (currently only offered for
        /// AGENT).</p>
        pub fn set_data_source(
            mut self,
            input: std::option::Option<crate::model::DataSource>,
        ) -> Self {
            self.data_source = input;
            self
        }
        /// Adds a key-value pair to `schema_storage_config`.
        ///
        /// To override the contents of this collection use [`set_schema_storage_config`](Self::set_schema_storage_config).
        ///
        /// <p>An object which describes how the data is stored.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>databaseName</code> - the name of the Glue database used to store the
        /// schema.</p>
        /// </li>
        /// </ul>
        pub fn schema_storage_config(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.schema_storage_config.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.schema_storage_config = Some(hash_map);
            self
        }
        /// <p>An object which describes how the data is stored.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>databaseName</code> - the name of the Glue database used to store the
        /// schema.</p>
        /// </li>
        /// </ul>
        pub fn set_schema_storage_config(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.schema_storage_config = input;
            self
        }
        /// Consumes the builder and constructs a [`ContinuousExportDescription`](crate::model::ContinuousExportDescription)
        pub fn build(self) -> crate::model::ContinuousExportDescription {
            crate::model::ContinuousExportDescription {
                export_id: self.export_id,
                status: self.status,
                status_detail: self.status_detail,
                s3_bucket: self.s3_bucket,
                start_time: self.start_time,
                stop_time: self.stop_time,
                data_source: self.data_source,
                schema_storage_config: self.schema_storage_config,
            }
        }
    }
}
impl ContinuousExportDescription {
    /// Creates a new builder-style object to manufacture [`ContinuousExportDescription`](crate::model::ContinuousExportDescription)
    pub fn builder() -> crate::model::continuous_export_description::Builder {
        crate::model::continuous_export_description::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ContinuousExportStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Error,
    #[allow(missing_docs)] // documentation missing in model
    Inactive,
    #[allow(missing_docs)] // documentation missing in model
    StartFailed,
    #[allow(missing_docs)] // documentation missing in model
    StartInProgress,
    #[allow(missing_docs)] // documentation missing in model
    StopFailed,
    #[allow(missing_docs)] // documentation missing in model
    StopInProgress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ContinuousExportStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => ContinuousExportStatus::Active,
            "ERROR" => ContinuousExportStatus::Error,
            "INACTIVE" => ContinuousExportStatus::Inactive,
            "START_FAILED" => ContinuousExportStatus::StartFailed,
            "START_IN_PROGRESS" => ContinuousExportStatus::StartInProgress,
            "STOP_FAILED" => ContinuousExportStatus::StopFailed,
            "STOP_IN_PROGRESS" => ContinuousExportStatus::StopInProgress,
            other => ContinuousExportStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ContinuousExportStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ContinuousExportStatus::from(s))
    }
}
impl ContinuousExportStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ContinuousExportStatus::Active => "ACTIVE",
            ContinuousExportStatus::Error => "ERROR",
            ContinuousExportStatus::Inactive => "INACTIVE",
            ContinuousExportStatus::StartFailed => "START_FAILED",
            ContinuousExportStatus::StartInProgress => "START_IN_PROGRESS",
            ContinuousExportStatus::StopFailed => "STOP_FAILED",
            ContinuousExportStatus::StopInProgress => "STOP_IN_PROGRESS",
            ContinuousExportStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTIVE",
            "ERROR",
            "INACTIVE",
            "START_FAILED",
            "START_IN_PROGRESS",
            "STOP_FAILED",
            "STOP_IN_PROGRESS",
        ]
    }
}
impl AsRef<str> for ContinuousExportStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about agents or connectors associated with the user’s AWS account.
/// Information includes agent or connector IDs, IP addresses, media access control (MAC)
/// addresses, agent or connector health, hostname where the agent or connector resides, and agent
/// version for each agent.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AgentInfo {
    /// <p>The agent or connector ID.</p>
    pub agent_id: std::option::Option<std::string::String>,
    /// <p>The name of the host where the agent or connector resides. The host can be a server or
    /// virtual machine.</p>
    pub host_name: std::option::Option<std::string::String>,
    /// <p>Network details about the host where the agent or connector resides.</p>
    pub agent_network_info_list: std::option::Option<std::vec::Vec<crate::model::AgentNetworkInfo>>,
    /// <p>The ID of the connector.</p>
    pub connector_id: std::option::Option<std::string::String>,
    /// <p>The agent or connector version.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>The health of the agent or connector.</p>
    pub health: std::option::Option<crate::model::AgentStatus>,
    /// <p>Time since agent or connector health was reported.</p>
    pub last_health_ping_time: std::option::Option<std::string::String>,
    /// <p>Status of the collection process for an agent or connector.</p>
    pub collection_status: std::option::Option<std::string::String>,
    /// <p>Type of agent.</p>
    pub agent_type: std::option::Option<std::string::String>,
    /// <p>Agent's first registration timestamp in UTC.</p>
    pub registered_time: std::option::Option<std::string::String>,
}
impl AgentInfo {
    /// <p>The agent or connector ID.</p>
    pub fn agent_id(&self) -> std::option::Option<&str> {
        self.agent_id.as_deref()
    }
    /// <p>The name of the host where the agent or connector resides. The host can be a server or
    /// virtual machine.</p>
    pub fn host_name(&self) -> std::option::Option<&str> {
        self.host_name.as_deref()
    }
    /// <p>Network details about the host where the agent or connector resides.</p>
    pub fn agent_network_info_list(
        &self,
    ) -> std::option::Option<&[crate::model::AgentNetworkInfo]> {
        self.agent_network_info_list.as_deref()
    }
    /// <p>The ID of the connector.</p>
    pub fn connector_id(&self) -> std::option::Option<&str> {
        self.connector_id.as_deref()
    }
    /// <p>The agent or connector version.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>The health of the agent or connector.</p>
    pub fn health(&self) -> std::option::Option<&crate::model::AgentStatus> {
        self.health.as_ref()
    }
    /// <p>Time since agent or connector health was reported.</p>
    pub fn last_health_ping_time(&self) -> std::option::Option<&str> {
        self.last_health_ping_time.as_deref()
    }
    /// <p>Status of the collection process for an agent or connector.</p>
    pub fn collection_status(&self) -> std::option::Option<&str> {
        self.collection_status.as_deref()
    }
    /// <p>Type of agent.</p>
    pub fn agent_type(&self) -> std::option::Option<&str> {
        self.agent_type.as_deref()
    }
    /// <p>Agent's first registration timestamp in UTC.</p>
    pub fn registered_time(&self) -> std::option::Option<&str> {
        self.registered_time.as_deref()
    }
}
impl std::fmt::Debug for AgentInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AgentInfo");
        formatter.field("agent_id", &self.agent_id);
        formatter.field("host_name", &self.host_name);
        formatter.field("agent_network_info_list", &self.agent_network_info_list);
        formatter.field("connector_id", &self.connector_id);
        formatter.field("version", &self.version);
        formatter.field("health", &self.health);
        formatter.field("last_health_ping_time", &self.last_health_ping_time);
        formatter.field("collection_status", &self.collection_status);
        formatter.field("agent_type", &self.agent_type);
        formatter.field("registered_time", &self.registered_time);
        formatter.finish()
    }
}
/// See [`AgentInfo`](crate::model::AgentInfo)
pub mod agent_info {
    /// A builder for [`AgentInfo`](crate::model::AgentInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) agent_id: std::option::Option<std::string::String>,
        pub(crate) host_name: std::option::Option<std::string::String>,
        pub(crate) agent_network_info_list:
            std::option::Option<std::vec::Vec<crate::model::AgentNetworkInfo>>,
        pub(crate) connector_id: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) health: std::option::Option<crate::model::AgentStatus>,
        pub(crate) last_health_ping_time: std::option::Option<std::string::String>,
        pub(crate) collection_status: std::option::Option<std::string::String>,
        pub(crate) agent_type: std::option::Option<std::string::String>,
        pub(crate) registered_time: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The agent or connector ID.</p>
        pub fn agent_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.agent_id = Some(input.into());
            self
        }
        /// <p>The agent or connector ID.</p>
        pub fn set_agent_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.agent_id = input;
            self
        }
        /// <p>The name of the host where the agent or connector resides. The host can be a server or
        /// virtual machine.</p>
        pub fn host_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.host_name = Some(input.into());
            self
        }
        /// <p>The name of the host where the agent or connector resides. The host can be a server or
        /// virtual machine.</p>
        pub fn set_host_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.host_name = input;
            self
        }
        /// Appends an item to `agent_network_info_list`.
        ///
        /// To override the contents of this collection use [`set_agent_network_info_list`](Self::set_agent_network_info_list).
        ///
        /// <p>Network details about the host where the agent or connector resides.</p>
        pub fn agent_network_info_list(
            mut self,
            input: impl Into<crate::model::AgentNetworkInfo>,
        ) -> Self {
            let mut v = self.agent_network_info_list.unwrap_or_default();
            v.push(input.into());
            self.agent_network_info_list = Some(v);
            self
        }
        /// <p>Network details about the host where the agent or connector resides.</p>
        pub fn set_agent_network_info_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AgentNetworkInfo>>,
        ) -> Self {
            self.agent_network_info_list = input;
            self
        }
        /// <p>The ID of the connector.</p>
        pub fn connector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connector_id = Some(input.into());
            self
        }
        /// <p>The ID of the connector.</p>
        pub fn set_connector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.connector_id = input;
            self
        }
        /// <p>The agent or connector version.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The agent or connector version.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>The health of the agent or connector.</p>
        pub fn health(mut self, input: crate::model::AgentStatus) -> Self {
            self.health = Some(input);
            self
        }
        /// <p>The health of the agent or connector.</p>
        pub fn set_health(mut self, input: std::option::Option<crate::model::AgentStatus>) -> Self {
            self.health = input;
            self
        }
        /// <p>Time since agent or connector health was reported.</p>
        pub fn last_health_ping_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_health_ping_time = Some(input.into());
            self
        }
        /// <p>Time since agent or connector health was reported.</p>
        pub fn set_last_health_ping_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_health_ping_time = input;
            self
        }
        /// <p>Status of the collection process for an agent or connector.</p>
        pub fn collection_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.collection_status = Some(input.into());
            self
        }
        /// <p>Status of the collection process for an agent or connector.</p>
        pub fn set_collection_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.collection_status = input;
            self
        }
        /// <p>Type of agent.</p>
        pub fn agent_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.agent_type = Some(input.into());
            self
        }
        /// <p>Type of agent.</p>
        pub fn set_agent_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.agent_type = input;
            self
        }
        /// <p>Agent's first registration timestamp in UTC.</p>
        pub fn registered_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.registered_time = Some(input.into());
            self
        }
        /// <p>Agent's first registration timestamp in UTC.</p>
        pub fn set_registered_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.registered_time = input;
            self
        }
        /// Consumes the builder and constructs a [`AgentInfo`](crate::model::AgentInfo)
        pub fn build(self) -> crate::model::AgentInfo {
            crate::model::AgentInfo {
                agent_id: self.agent_id,
                host_name: self.host_name,
                agent_network_info_list: self.agent_network_info_list,
                connector_id: self.connector_id,
                version: self.version,
                health: self.health,
                last_health_ping_time: self.last_health_ping_time,
                collection_status: self.collection_status,
                agent_type: self.agent_type,
                registered_time: self.registered_time,
            }
        }
    }
}
impl AgentInfo {
    /// Creates a new builder-style object to manufacture [`AgentInfo`](crate::model::AgentInfo)
    pub fn builder() -> crate::model::agent_info::Builder {
        crate::model::agent_info::Builder::default()
    }
}

/// _Note: `AgentStatus::Unknown` has been renamed to `::UnknownValue`._
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AgentStatus {
    #[allow(missing_docs)] // documentation missing in model
    Blacklisted,
    #[allow(missing_docs)] // documentation missing in model
    Healthy,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    #[allow(missing_docs)] // documentation missing in model
    Shutdown,
    #[allow(missing_docs)] // documentation missing in model
    Unhealthy,
    /// _Note: `::Unknown` has been renamed to `::UnknownValue`._
    UnknownValue,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AgentStatus {
    fn from(s: &str) -> Self {
        match s {
            "BLACKLISTED" => AgentStatus::Blacklisted,
            "HEALTHY" => AgentStatus::Healthy,
            "RUNNING" => AgentStatus::Running,
            "SHUTDOWN" => AgentStatus::Shutdown,
            "UNHEALTHY" => AgentStatus::Unhealthy,
            "UNKNOWN" => AgentStatus::UnknownValue,
            other => AgentStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AgentStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AgentStatus::from(s))
    }
}
impl AgentStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AgentStatus::Blacklisted => "BLACKLISTED",
            AgentStatus::Healthy => "HEALTHY",
            AgentStatus::Running => "RUNNING",
            AgentStatus::Shutdown => "SHUTDOWN",
            AgentStatus::Unhealthy => "UNHEALTHY",
            AgentStatus::UnknownValue => "UNKNOWN",
            AgentStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BLACKLISTED",
            "HEALTHY",
            "RUNNING",
            "SHUTDOWN",
            "UNHEALTHY",
            "UNKNOWN",
        ]
    }
}
impl AsRef<str> for AgentStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Network details about the host where the agent/connector resides.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AgentNetworkInfo {
    /// <p>The IP address for the host where the agent/connector resides.</p>
    pub ip_address: std::option::Option<std::string::String>,
    /// <p>The MAC address for the host where the agent/connector resides.</p>
    pub mac_address: std::option::Option<std::string::String>,
}
impl AgentNetworkInfo {
    /// <p>The IP address for the host where the agent/connector resides.</p>
    pub fn ip_address(&self) -> std::option::Option<&str> {
        self.ip_address.as_deref()
    }
    /// <p>The MAC address for the host where the agent/connector resides.</p>
    pub fn mac_address(&self) -> std::option::Option<&str> {
        self.mac_address.as_deref()
    }
}
impl std::fmt::Debug for AgentNetworkInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AgentNetworkInfo");
        formatter.field("ip_address", &self.ip_address);
        formatter.field("mac_address", &self.mac_address);
        formatter.finish()
    }
}
/// See [`AgentNetworkInfo`](crate::model::AgentNetworkInfo)
pub mod agent_network_info {
    /// A builder for [`AgentNetworkInfo`](crate::model::AgentNetworkInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ip_address: std::option::Option<std::string::String>,
        pub(crate) mac_address: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The IP address for the host where the agent/connector resides.</p>
        pub fn ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip_address = Some(input.into());
            self
        }
        /// <p>The IP address for the host where the agent/connector resides.</p>
        pub fn set_ip_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ip_address = input;
            self
        }
        /// <p>The MAC address for the host where the agent/connector resides.</p>
        pub fn mac_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.mac_address = Some(input.into());
            self
        }
        /// <p>The MAC address for the host where the agent/connector resides.</p>
        pub fn set_mac_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mac_address = input;
            self
        }
        /// Consumes the builder and constructs a [`AgentNetworkInfo`](crate::model::AgentNetworkInfo)
        pub fn build(self) -> crate::model::AgentNetworkInfo {
            crate::model::AgentNetworkInfo {
                ip_address: self.ip_address,
                mac_address: self.mac_address,
            }
        }
    }
}
impl AgentNetworkInfo {
    /// Creates a new builder-style object to manufacture [`AgentNetworkInfo`](crate::model::AgentNetworkInfo)
    pub fn builder() -> crate::model::agent_network_info::Builder {
        crate::model::agent_network_info::Builder::default()
    }
}

/// <p>Metadata that help you categorize IT assets.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The type of tag on which to filter.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>A value for a tag key on which to filter.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>The type of tag on which to filter.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>A value for a tag key on which to filter.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of tag on which to filter.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The type of tag on which to filter.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>A value for a tag key on which to filter.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>A value for a tag key on which to filter.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>Error messages returned for each import task that you deleted as a response for this
/// command.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDeleteImportDataError {
    /// <p>The unique import ID associated with the error that occurred.</p>
    pub import_task_id: std::option::Option<std::string::String>,
    /// <p>The type of error that occurred for a specific import task.</p>
    pub error_code: std::option::Option<crate::model::BatchDeleteImportDataErrorCode>,
    /// <p>The description of the error that occurred for a specific import task.</p>
    pub error_description: std::option::Option<std::string::String>,
}
impl BatchDeleteImportDataError {
    /// <p>The unique import ID associated with the error that occurred.</p>
    pub fn import_task_id(&self) -> std::option::Option<&str> {
        self.import_task_id.as_deref()
    }
    /// <p>The type of error that occurred for a specific import task.</p>
    pub fn error_code(&self) -> std::option::Option<&crate::model::BatchDeleteImportDataErrorCode> {
        self.error_code.as_ref()
    }
    /// <p>The description of the error that occurred for a specific import task.</p>
    pub fn error_description(&self) -> std::option::Option<&str> {
        self.error_description.as_deref()
    }
}
impl std::fmt::Debug for BatchDeleteImportDataError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDeleteImportDataError");
        formatter.field("import_task_id", &self.import_task_id);
        formatter.field("error_code", &self.error_code);
        formatter.field("error_description", &self.error_description);
        formatter.finish()
    }
}
/// See [`BatchDeleteImportDataError`](crate::model::BatchDeleteImportDataError)
pub mod batch_delete_import_data_error {
    /// A builder for [`BatchDeleteImportDataError`](crate::model::BatchDeleteImportDataError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) import_task_id: std::option::Option<std::string::String>,
        pub(crate) error_code: std::option::Option<crate::model::BatchDeleteImportDataErrorCode>,
        pub(crate) error_description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique import ID associated with the error that occurred.</p>
        pub fn import_task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.import_task_id = Some(input.into());
            self
        }
        /// <p>The unique import ID associated with the error that occurred.</p>
        pub fn set_import_task_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.import_task_id = input;
            self
        }
        /// <p>The type of error that occurred for a specific import task.</p>
        pub fn error_code(mut self, input: crate::model::BatchDeleteImportDataErrorCode) -> Self {
            self.error_code = Some(input);
            self
        }
        /// <p>The type of error that occurred for a specific import task.</p>
        pub fn set_error_code(
            mut self,
            input: std::option::Option<crate::model::BatchDeleteImportDataErrorCode>,
        ) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The description of the error that occurred for a specific import task.</p>
        pub fn error_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_description = Some(input.into());
            self
        }
        /// <p>The description of the error that occurred for a specific import task.</p>
        pub fn set_error_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_description = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDeleteImportDataError`](crate::model::BatchDeleteImportDataError)
        pub fn build(self) -> crate::model::BatchDeleteImportDataError {
            crate::model::BatchDeleteImportDataError {
                import_task_id: self.import_task_id,
                error_code: self.error_code,
                error_description: self.error_description,
            }
        }
    }
}
impl BatchDeleteImportDataError {
    /// Creates a new builder-style object to manufacture [`BatchDeleteImportDataError`](crate::model::BatchDeleteImportDataError)
    pub fn builder() -> crate::model::batch_delete_import_data_error::Builder {
        crate::model::batch_delete_import_data_error::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BatchDeleteImportDataErrorCode {
    #[allow(missing_docs)] // documentation missing in model
    InternalServerError,
    #[allow(missing_docs)] // documentation missing in model
    NotFound,
    #[allow(missing_docs)] // documentation missing in model
    OverLimit,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BatchDeleteImportDataErrorCode {
    fn from(s: &str) -> Self {
        match s {
            "INTERNAL_SERVER_ERROR" => BatchDeleteImportDataErrorCode::InternalServerError,
            "NOT_FOUND" => BatchDeleteImportDataErrorCode::NotFound,
            "OVER_LIMIT" => BatchDeleteImportDataErrorCode::OverLimit,
            other => BatchDeleteImportDataErrorCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BatchDeleteImportDataErrorCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BatchDeleteImportDataErrorCode::from(s))
    }
}
impl BatchDeleteImportDataErrorCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BatchDeleteImportDataErrorCode::InternalServerError => "INTERNAL_SERVER_ERROR",
            BatchDeleteImportDataErrorCode::NotFound => "NOT_FOUND",
            BatchDeleteImportDataErrorCode::OverLimit => "OVER_LIMIT",
            BatchDeleteImportDataErrorCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["INTERNAL_SERVER_ERROR", "NOT_FOUND", "OVER_LIMIT"]
    }
}
impl AsRef<str> for BatchDeleteImportDataErrorCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
