// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateApplicationOutput {}
impl std::fmt::Debug for UpdateApplicationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateApplicationOutput");
        formatter.finish()
    }
}
/// See [`UpdateApplicationOutput`](crate::output::UpdateApplicationOutput)
pub mod update_application_output {
    /// A builder for [`UpdateApplicationOutput`](crate::output::UpdateApplicationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateApplicationOutput`](crate::output::UpdateApplicationOutput)
        pub fn build(self) -> crate::output::UpdateApplicationOutput {
            crate::output::UpdateApplicationOutput {}
        }
    }
}
impl UpdateApplicationOutput {
    /// Creates a new builder-style object to manufacture [`UpdateApplicationOutput`](crate::output::UpdateApplicationOutput)
    pub fn builder() -> crate::output::update_application_output::Builder {
        crate::output::update_application_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopDataCollectionByAgentIdsOutput {
    /// <p>Information about the agents or connector that were instructed to stop collecting data.
    /// Information includes the agent/connector ID, a description of the operation performed, and
    /// whether the agent/connector configuration was updated.</p>
    pub agents_configuration_status:
        std::option::Option<std::vec::Vec<crate::model::AgentConfigurationStatus>>,
}
impl std::fmt::Debug for StopDataCollectionByAgentIdsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopDataCollectionByAgentIdsOutput");
        formatter.field(
            "agents_configuration_status",
            &self.agents_configuration_status,
        );
        formatter.finish()
    }
}
/// See [`StopDataCollectionByAgentIdsOutput`](crate::output::StopDataCollectionByAgentIdsOutput)
pub mod stop_data_collection_by_agent_ids_output {
    /// A builder for [`StopDataCollectionByAgentIdsOutput`](crate::output::StopDataCollectionByAgentIdsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) agents_configuration_status:
            std::option::Option<std::vec::Vec<crate::model::AgentConfigurationStatus>>,
    }
    impl Builder {
        /// Appends an item to `agents_configuration_status`.
        ///
        /// To override the contents of this collection use [`set_agents_configuration_status`](Self::set_agents_configuration_status).
        ///
        /// <p>Information about the agents or connector that were instructed to stop collecting data.
        /// Information includes the agent/connector ID, a description of the operation performed, and
        /// whether the agent/connector configuration was updated.</p>
        pub fn agents_configuration_status(
            mut self,
            input: impl Into<crate::model::AgentConfigurationStatus>,
        ) -> Self {
            let mut v = self.agents_configuration_status.unwrap_or_default();
            v.push(input.into());
            self.agents_configuration_status = Some(v);
            self
        }
        /// <p>Information about the agents or connector that were instructed to stop collecting data.
        /// Information includes the agent/connector ID, a description of the operation performed, and
        /// whether the agent/connector configuration was updated.</p>
        pub fn set_agents_configuration_status(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AgentConfigurationStatus>>,
        ) -> Self {
            self.agents_configuration_status = input;
            self
        }
        /// Consumes the builder and constructs a [`StopDataCollectionByAgentIdsOutput`](crate::output::StopDataCollectionByAgentIdsOutput)
        pub fn build(self) -> crate::output::StopDataCollectionByAgentIdsOutput {
            crate::output::StopDataCollectionByAgentIdsOutput {
                agents_configuration_status: self.agents_configuration_status,
            }
        }
    }
}
impl StopDataCollectionByAgentIdsOutput {
    /// Creates a new builder-style object to manufacture [`StopDataCollectionByAgentIdsOutput`](crate::output::StopDataCollectionByAgentIdsOutput)
    pub fn builder() -> crate::output::stop_data_collection_by_agent_ids_output::Builder {
        crate::output::stop_data_collection_by_agent_ids_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopContinuousExportOutput {
    /// <p>Timestamp that represents when this continuous export started collecting
    /// data.</p>
    pub start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Timestamp that represents when this continuous export was stopped.</p>
    pub stop_time: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for StopContinuousExportOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopContinuousExportOutput");
        formatter.field("start_time", &self.start_time);
        formatter.field("stop_time", &self.stop_time);
        formatter.finish()
    }
}
/// See [`StopContinuousExportOutput`](crate::output::StopContinuousExportOutput)
pub mod stop_continuous_export_output {
    /// A builder for [`StopContinuousExportOutput`](crate::output::StopContinuousExportOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) stop_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>Timestamp that represents when this continuous export started collecting
        /// data.</p>
        pub fn start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>Timestamp that represents when this continuous export started collecting
        /// data.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>Timestamp that represents when this continuous export was stopped.</p>
        pub fn stop_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.stop_time = Some(input);
            self
        }
        /// <p>Timestamp that represents when this continuous export was stopped.</p>
        pub fn set_stop_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.stop_time = input;
            self
        }
        /// Consumes the builder and constructs a [`StopContinuousExportOutput`](crate::output::StopContinuousExportOutput)
        pub fn build(self) -> crate::output::StopContinuousExportOutput {
            crate::output::StopContinuousExportOutput {
                start_time: self.start_time,
                stop_time: self.stop_time,
            }
        }
    }
}
impl StopContinuousExportOutput {
    /// Creates a new builder-style object to manufacture [`StopContinuousExportOutput`](crate::output::StopContinuousExportOutput)
    pub fn builder() -> crate::output::stop_continuous_export_output::Builder {
        crate::output::stop_continuous_export_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartImportTaskOutput {
    /// <p>An array of information related to the import task request including status information,
    /// times, IDs, the Amazon S3 Object URL for the import file, and more. </p>
    pub task: std::option::Option<crate::model::ImportTask>,
}
impl std::fmt::Debug for StartImportTaskOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartImportTaskOutput");
        formatter.field("task", &self.task);
        formatter.finish()
    }
}
/// See [`StartImportTaskOutput`](crate::output::StartImportTaskOutput)
pub mod start_import_task_output {
    /// A builder for [`StartImportTaskOutput`](crate::output::StartImportTaskOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task: std::option::Option<crate::model::ImportTask>,
    }
    impl Builder {
        /// <p>An array of information related to the import task request including status information,
        /// times, IDs, the Amazon S3 Object URL for the import file, and more. </p>
        pub fn task(mut self, input: crate::model::ImportTask) -> Self {
            self.task = Some(input);
            self
        }
        /// <p>An array of information related to the import task request including status information,
        /// times, IDs, the Amazon S3 Object URL for the import file, and more. </p>
        pub fn set_task(mut self, input: std::option::Option<crate::model::ImportTask>) -> Self {
            self.task = input;
            self
        }
        /// Consumes the builder and constructs a [`StartImportTaskOutput`](crate::output::StartImportTaskOutput)
        pub fn build(self) -> crate::output::StartImportTaskOutput {
            crate::output::StartImportTaskOutput { task: self.task }
        }
    }
}
impl StartImportTaskOutput {
    /// Creates a new builder-style object to manufacture [`StartImportTaskOutput`](crate::output::StartImportTaskOutput)
    pub fn builder() -> crate::output::start_import_task_output::Builder {
        crate::output::start_import_task_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartExportTaskOutput {
    /// <p>A unique identifier used to query the status of an export request.</p>
    pub export_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StartExportTaskOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartExportTaskOutput");
        formatter.field("export_id", &self.export_id);
        formatter.finish()
    }
}
/// See [`StartExportTaskOutput`](crate::output::StartExportTaskOutput)
pub mod start_export_task_output {
    /// A builder for [`StartExportTaskOutput`](crate::output::StartExportTaskOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) export_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier used to query the status of an export request.</p>
        pub fn export_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.export_id = Some(input.into());
            self
        }
        /// <p>A unique identifier used to query the status of an export request.</p>
        pub fn set_export_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.export_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StartExportTaskOutput`](crate::output::StartExportTaskOutput)
        pub fn build(self) -> crate::output::StartExportTaskOutput {
            crate::output::StartExportTaskOutput {
                export_id: self.export_id,
            }
        }
    }
}
impl StartExportTaskOutput {
    /// Creates a new builder-style object to manufacture [`StartExportTaskOutput`](crate::output::StartExportTaskOutput)
    pub fn builder() -> crate::output::start_export_task_output::Builder {
        crate::output::start_export_task_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartDataCollectionByAgentIdsOutput {
    /// <p>Information about agents or the connector that were instructed to start collecting
    /// data. Information includes the agent/connector ID, a description of the operation performed,
    /// and whether the agent/connector configuration was updated.</p>
    pub agents_configuration_status:
        std::option::Option<std::vec::Vec<crate::model::AgentConfigurationStatus>>,
}
impl std::fmt::Debug for StartDataCollectionByAgentIdsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartDataCollectionByAgentIdsOutput");
        formatter.field(
            "agents_configuration_status",
            &self.agents_configuration_status,
        );
        formatter.finish()
    }
}
/// See [`StartDataCollectionByAgentIdsOutput`](crate::output::StartDataCollectionByAgentIdsOutput)
pub mod start_data_collection_by_agent_ids_output {
    /// A builder for [`StartDataCollectionByAgentIdsOutput`](crate::output::StartDataCollectionByAgentIdsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) agents_configuration_status:
            std::option::Option<std::vec::Vec<crate::model::AgentConfigurationStatus>>,
    }
    impl Builder {
        /// Appends an item to `agents_configuration_status`.
        ///
        /// To override the contents of this collection use [`set_agents_configuration_status`](Self::set_agents_configuration_status).
        ///
        /// <p>Information about agents or the connector that were instructed to start collecting
        /// data. Information includes the agent/connector ID, a description of the operation performed,
        /// and whether the agent/connector configuration was updated.</p>
        pub fn agents_configuration_status(
            mut self,
            input: impl Into<crate::model::AgentConfigurationStatus>,
        ) -> Self {
            let mut v = self.agents_configuration_status.unwrap_or_default();
            v.push(input.into());
            self.agents_configuration_status = Some(v);
            self
        }
        /// <p>Information about agents or the connector that were instructed to start collecting
        /// data. Information includes the agent/connector ID, a description of the operation performed,
        /// and whether the agent/connector configuration was updated.</p>
        pub fn set_agents_configuration_status(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AgentConfigurationStatus>>,
        ) -> Self {
            self.agents_configuration_status = input;
            self
        }
        /// Consumes the builder and constructs a [`StartDataCollectionByAgentIdsOutput`](crate::output::StartDataCollectionByAgentIdsOutput)
        pub fn build(self) -> crate::output::StartDataCollectionByAgentIdsOutput {
            crate::output::StartDataCollectionByAgentIdsOutput {
                agents_configuration_status: self.agents_configuration_status,
            }
        }
    }
}
impl StartDataCollectionByAgentIdsOutput {
    /// Creates a new builder-style object to manufacture [`StartDataCollectionByAgentIdsOutput`](crate::output::StartDataCollectionByAgentIdsOutput)
    pub fn builder() -> crate::output::start_data_collection_by_agent_ids_output::Builder {
        crate::output::start_data_collection_by_agent_ids_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartContinuousExportOutput {
    /// <p>The unique ID assigned to this export.</p>
    pub export_id: std::option::Option<std::string::String>,
    /// <p>The name of the s3 bucket where the export data parquet files are stored.</p>
    pub s3_bucket: std::option::Option<std::string::String>,
    /// <p>The timestamp representing when the continuous export was started.</p>
    pub start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The type of data collector used to gather this data (currently only offered for
    /// AGENT).</p>
    pub data_source: std::option::Option<crate::model::DataSource>,
    /// <p>A dictionary which describes how the data is stored.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>databaseName</code> - the name of the Glue database used to store the
    /// schema.</p>
    /// </li>
    /// </ul>
    pub schema_storage_config:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for StartContinuousExportOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartContinuousExportOutput");
        formatter.field("export_id", &self.export_id);
        formatter.field("s3_bucket", &self.s3_bucket);
        formatter.field("start_time", &self.start_time);
        formatter.field("data_source", &self.data_source);
        formatter.field("schema_storage_config", &self.schema_storage_config);
        formatter.finish()
    }
}
/// See [`StartContinuousExportOutput`](crate::output::StartContinuousExportOutput)
pub mod start_continuous_export_output {
    /// A builder for [`StartContinuousExportOutput`](crate::output::StartContinuousExportOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) export_id: std::option::Option<std::string::String>,
        pub(crate) s3_bucket: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) data_source: std::option::Option<crate::model::DataSource>,
        pub(crate) schema_storage_config: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The unique ID assigned to this export.</p>
        pub fn export_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.export_id = Some(input.into());
            self
        }
        /// <p>The unique ID assigned to this export.</p>
        pub fn set_export_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.export_id = input;
            self
        }
        /// <p>The name of the s3 bucket where the export data parquet files are stored.</p>
        pub fn s3_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket = Some(input.into());
            self
        }
        /// <p>The name of the s3 bucket where the export data parquet files are stored.</p>
        pub fn set_s3_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_bucket = input;
            self
        }
        /// <p>The timestamp representing when the continuous export was started.</p>
        pub fn start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The timestamp representing when the continuous export was started.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The type of data collector used to gather this data (currently only offered for
        /// AGENT).</p>
        pub fn data_source(mut self, input: crate::model::DataSource) -> Self {
            self.data_source = Some(input);
            self
        }
        /// <p>The type of data collector used to gather this data (currently only offered for
        /// AGENT).</p>
        pub fn set_data_source(
            mut self,
            input: std::option::Option<crate::model::DataSource>,
        ) -> Self {
            self.data_source = input;
            self
        }
        /// Adds a key-value pair to `schema_storage_config`.
        ///
        /// To override the contents of this collection use [`set_schema_storage_config`](Self::set_schema_storage_config).
        ///
        /// <p>A dictionary which describes how the data is stored.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>databaseName</code> - the name of the Glue database used to store the
        /// schema.</p>
        /// </li>
        /// </ul>
        pub fn schema_storage_config(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.schema_storage_config.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.schema_storage_config = Some(hash_map);
            self
        }
        /// <p>A dictionary which describes how the data is stored.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>databaseName</code> - the name of the Glue database used to store the
        /// schema.</p>
        /// </li>
        /// </ul>
        pub fn set_schema_storage_config(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.schema_storage_config = input;
            self
        }
        /// Consumes the builder and constructs a [`StartContinuousExportOutput`](crate::output::StartContinuousExportOutput)
        pub fn build(self) -> crate::output::StartContinuousExportOutput {
            crate::output::StartContinuousExportOutput {
                export_id: self.export_id,
                s3_bucket: self.s3_bucket,
                start_time: self.start_time,
                data_source: self.data_source,
                schema_storage_config: self.schema_storage_config,
            }
        }
    }
}
impl StartContinuousExportOutput {
    /// Creates a new builder-style object to manufacture [`StartContinuousExportOutput`](crate::output::StartContinuousExportOutput)
    pub fn builder() -> crate::output::start_continuous_export_output::Builder {
        crate::output::start_continuous_export_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListServerNeighborsOutput {
    /// <p>List of distinct servers that are one hop away from the given server.</p>
    pub neighbors: std::option::Option<std::vec::Vec<crate::model::NeighborConnectionDetail>>,
    /// <p>Token to retrieve the next set of results. For example, if you specified 100 IDs for
    /// <code>ListServerNeighborsRequest$neighborConfigurationIds</code> but set
    /// <code>ListServerNeighborsRequest$maxResults</code> to 10, you received a set of 10 results
    /// along with this token. Use this token in the next query to retrieve the next set of
    /// 10.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Count of distinct servers that are one hop away from the given server.</p>
    pub known_dependency_count: i64,
}
impl std::fmt::Debug for ListServerNeighborsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListServerNeighborsOutput");
        formatter.field("neighbors", &self.neighbors);
        formatter.field("next_token", &self.next_token);
        formatter.field("known_dependency_count", &self.known_dependency_count);
        formatter.finish()
    }
}
/// See [`ListServerNeighborsOutput`](crate::output::ListServerNeighborsOutput)
pub mod list_server_neighbors_output {
    /// A builder for [`ListServerNeighborsOutput`](crate::output::ListServerNeighborsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) neighbors:
            std::option::Option<std::vec::Vec<crate::model::NeighborConnectionDetail>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) known_dependency_count: std::option::Option<i64>,
    }
    impl Builder {
        /// Appends an item to `neighbors`.
        ///
        /// To override the contents of this collection use [`set_neighbors`](Self::set_neighbors).
        ///
        /// <p>List of distinct servers that are one hop away from the given server.</p>
        pub fn neighbors(
            mut self,
            input: impl Into<crate::model::NeighborConnectionDetail>,
        ) -> Self {
            let mut v = self.neighbors.unwrap_or_default();
            v.push(input.into());
            self.neighbors = Some(v);
            self
        }
        /// <p>List of distinct servers that are one hop away from the given server.</p>
        pub fn set_neighbors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NeighborConnectionDetail>>,
        ) -> Self {
            self.neighbors = input;
            self
        }
        /// <p>Token to retrieve the next set of results. For example, if you specified 100 IDs for
        /// <code>ListServerNeighborsRequest$neighborConfigurationIds</code> but set
        /// <code>ListServerNeighborsRequest$maxResults</code> to 10, you received a set of 10 results
        /// along with this token. Use this token in the next query to retrieve the next set of
        /// 10.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Token to retrieve the next set of results. For example, if you specified 100 IDs for
        /// <code>ListServerNeighborsRequest$neighborConfigurationIds</code> but set
        /// <code>ListServerNeighborsRequest$maxResults</code> to 10, you received a set of 10 results
        /// along with this token. Use this token in the next query to retrieve the next set of
        /// 10.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>Count of distinct servers that are one hop away from the given server.</p>
        pub fn known_dependency_count(mut self, input: i64) -> Self {
            self.known_dependency_count = Some(input);
            self
        }
        /// <p>Count of distinct servers that are one hop away from the given server.</p>
        pub fn set_known_dependency_count(mut self, input: std::option::Option<i64>) -> Self {
            self.known_dependency_count = input;
            self
        }
        /// Consumes the builder and constructs a [`ListServerNeighborsOutput`](crate::output::ListServerNeighborsOutput)
        pub fn build(self) -> crate::output::ListServerNeighborsOutput {
            crate::output::ListServerNeighborsOutput {
                neighbors: self.neighbors,
                next_token: self.next_token,
                known_dependency_count: self.known_dependency_count.unwrap_or_default(),
            }
        }
    }
}
impl ListServerNeighborsOutput {
    /// Creates a new builder-style object to manufacture [`ListServerNeighborsOutput`](crate::output::ListServerNeighborsOutput)
    pub fn builder() -> crate::output::list_server_neighbors_output::Builder {
        crate::output::list_server_neighbors_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListConfigurationsOutput {
    /// <p>Returns configuration details, including the configuration ID, attribute names, and
    /// attribute values.</p>
    pub configurations: std::option::Option<
        std::vec::Vec<std::collections::HashMap<std::string::String, std::string::String>>,
    >,
    /// <p>Token to retrieve the next set of results. For example, if your call to
    /// ListConfigurations returned 100 items, but you set
    /// <code>ListConfigurationsRequest$maxResults</code> to 10, you received a set of 10 results
    /// along with this token. Use this token in the next query to retrieve the next set of
    /// 10.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListConfigurationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListConfigurationsOutput");
        formatter.field("configurations", &self.configurations);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListConfigurationsOutput`](crate::output::ListConfigurationsOutput)
pub mod list_configurations_output {
    /// A builder for [`ListConfigurationsOutput`](crate::output::ListConfigurationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configurations: std::option::Option<
            std::vec::Vec<std::collections::HashMap<std::string::String, std::string::String>>,
        >,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `configurations`.
        ///
        /// To override the contents of this collection use [`set_configurations`](Self::set_configurations).
        ///
        /// <p>Returns configuration details, including the configuration ID, attribute names, and
        /// attribute values.</p>
        pub fn configurations(
            mut self,
            input: impl Into<std::collections::HashMap<std::string::String, std::string::String>>,
        ) -> Self {
            let mut v = self.configurations.unwrap_or_default();
            v.push(input.into());
            self.configurations = Some(v);
            self
        }
        /// <p>Returns configuration details, including the configuration ID, attribute names, and
        /// attribute values.</p>
        pub fn set_configurations(
            mut self,
            input: std::option::Option<
                std::vec::Vec<std::collections::HashMap<std::string::String, std::string::String>>,
            >,
        ) -> Self {
            self.configurations = input;
            self
        }
        /// <p>Token to retrieve the next set of results. For example, if your call to
        /// ListConfigurations returned 100 items, but you set
        /// <code>ListConfigurationsRequest$maxResults</code> to 10, you received a set of 10 results
        /// along with this token. Use this token in the next query to retrieve the next set of
        /// 10.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Token to retrieve the next set of results. For example, if your call to
        /// ListConfigurations returned 100 items, but you set
        /// <code>ListConfigurationsRequest$maxResults</code> to 10, you received a set of 10 results
        /// along with this token. Use this token in the next query to retrieve the next set of
        /// 10.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListConfigurationsOutput`](crate::output::ListConfigurationsOutput)
        pub fn build(self) -> crate::output::ListConfigurationsOutput {
            crate::output::ListConfigurationsOutput {
                configurations: self.configurations,
                next_token: self.next_token,
            }
        }
    }
}
impl ListConfigurationsOutput {
    /// Creates a new builder-style object to manufacture [`ListConfigurationsOutput`](crate::output::ListConfigurationsOutput)
    pub fn builder() -> crate::output::list_configurations_output::Builder {
        crate::output::list_configurations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDiscoverySummaryOutput {
    /// <p>The number of servers discovered.</p>
    pub servers: i64,
    /// <p>The number of applications discovered.</p>
    pub applications: i64,
    /// <p>The number of servers mapped to applications.</p>
    pub servers_mapped_to_applications: i64,
    /// <p>The number of servers mapped to tags.</p>
    pub servers_mappedto_tags: i64,
    /// <p>Details about discovered agents, including agent status and health.</p>
    pub agent_summary: std::option::Option<crate::model::CustomerAgentInfo>,
    /// <p>Details about discovered connectors, including connector status and health.</p>
    pub connector_summary: std::option::Option<crate::model::CustomerConnectorInfo>,
}
impl std::fmt::Debug for GetDiscoverySummaryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDiscoverySummaryOutput");
        formatter.field("servers", &self.servers);
        formatter.field("applications", &self.applications);
        formatter.field(
            "servers_mapped_to_applications",
            &self.servers_mapped_to_applications,
        );
        formatter.field("servers_mappedto_tags", &self.servers_mappedto_tags);
        formatter.field("agent_summary", &self.agent_summary);
        formatter.field("connector_summary", &self.connector_summary);
        formatter.finish()
    }
}
/// See [`GetDiscoverySummaryOutput`](crate::output::GetDiscoverySummaryOutput)
pub mod get_discovery_summary_output {
    /// A builder for [`GetDiscoverySummaryOutput`](crate::output::GetDiscoverySummaryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) servers: std::option::Option<i64>,
        pub(crate) applications: std::option::Option<i64>,
        pub(crate) servers_mapped_to_applications: std::option::Option<i64>,
        pub(crate) servers_mappedto_tags: std::option::Option<i64>,
        pub(crate) agent_summary: std::option::Option<crate::model::CustomerAgentInfo>,
        pub(crate) connector_summary: std::option::Option<crate::model::CustomerConnectorInfo>,
    }
    impl Builder {
        /// <p>The number of servers discovered.</p>
        pub fn servers(mut self, input: i64) -> Self {
            self.servers = Some(input);
            self
        }
        /// <p>The number of servers discovered.</p>
        pub fn set_servers(mut self, input: std::option::Option<i64>) -> Self {
            self.servers = input;
            self
        }
        /// <p>The number of applications discovered.</p>
        pub fn applications(mut self, input: i64) -> Self {
            self.applications = Some(input);
            self
        }
        /// <p>The number of applications discovered.</p>
        pub fn set_applications(mut self, input: std::option::Option<i64>) -> Self {
            self.applications = input;
            self
        }
        /// <p>The number of servers mapped to applications.</p>
        pub fn servers_mapped_to_applications(mut self, input: i64) -> Self {
            self.servers_mapped_to_applications = Some(input);
            self
        }
        /// <p>The number of servers mapped to applications.</p>
        pub fn set_servers_mapped_to_applications(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.servers_mapped_to_applications = input;
            self
        }
        /// <p>The number of servers mapped to tags.</p>
        pub fn servers_mappedto_tags(mut self, input: i64) -> Self {
            self.servers_mappedto_tags = Some(input);
            self
        }
        /// <p>The number of servers mapped to tags.</p>
        pub fn set_servers_mappedto_tags(mut self, input: std::option::Option<i64>) -> Self {
            self.servers_mappedto_tags = input;
            self
        }
        /// <p>Details about discovered agents, including agent status and health.</p>
        pub fn agent_summary(mut self, input: crate::model::CustomerAgentInfo) -> Self {
            self.agent_summary = Some(input);
            self
        }
        /// <p>Details about discovered agents, including agent status and health.</p>
        pub fn set_agent_summary(
            mut self,
            input: std::option::Option<crate::model::CustomerAgentInfo>,
        ) -> Self {
            self.agent_summary = input;
            self
        }
        /// <p>Details about discovered connectors, including connector status and health.</p>
        pub fn connector_summary(mut self, input: crate::model::CustomerConnectorInfo) -> Self {
            self.connector_summary = Some(input);
            self
        }
        /// <p>Details about discovered connectors, including connector status and health.</p>
        pub fn set_connector_summary(
            mut self,
            input: std::option::Option<crate::model::CustomerConnectorInfo>,
        ) -> Self {
            self.connector_summary = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDiscoverySummaryOutput`](crate::output::GetDiscoverySummaryOutput)
        pub fn build(self) -> crate::output::GetDiscoverySummaryOutput {
            crate::output::GetDiscoverySummaryOutput {
                servers: self.servers.unwrap_or_default(),
                applications: self.applications.unwrap_or_default(),
                servers_mapped_to_applications: self
                    .servers_mapped_to_applications
                    .unwrap_or_default(),
                servers_mappedto_tags: self.servers_mappedto_tags.unwrap_or_default(),
                agent_summary: self.agent_summary,
                connector_summary: self.connector_summary,
            }
        }
    }
}
impl GetDiscoverySummaryOutput {
    /// Creates a new builder-style object to manufacture [`GetDiscoverySummaryOutput`](crate::output::GetDiscoverySummaryOutput)
    pub fn builder() -> crate::output::get_discovery_summary_output::Builder {
        crate::output::get_discovery_summary_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExportConfigurationsOutput {
    /// <p>A unique identifier that you can use to query the export status.</p>
    pub export_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ExportConfigurationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExportConfigurationsOutput");
        formatter.field("export_id", &self.export_id);
        formatter.finish()
    }
}
/// See [`ExportConfigurationsOutput`](crate::output::ExportConfigurationsOutput)
pub mod export_configurations_output {
    /// A builder for [`ExportConfigurationsOutput`](crate::output::ExportConfigurationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) export_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier that you can use to query the export status.</p>
        pub fn export_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.export_id = Some(input.into());
            self
        }
        /// <p>A unique identifier that you can use to query the export status.</p>
        pub fn set_export_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.export_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ExportConfigurationsOutput`](crate::output::ExportConfigurationsOutput)
        pub fn build(self) -> crate::output::ExportConfigurationsOutput {
            crate::output::ExportConfigurationsOutput {
                export_id: self.export_id,
            }
        }
    }
}
impl ExportConfigurationsOutput {
    /// Creates a new builder-style object to manufacture [`ExportConfigurationsOutput`](crate::output::ExportConfigurationsOutput)
    pub fn builder() -> crate::output::export_configurations_output::Builder {
        crate::output::export_configurations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateConfigurationItemsFromApplicationOutput {}
impl std::fmt::Debug for DisassociateConfigurationItemsFromApplicationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateConfigurationItemsFromApplicationOutput");
        formatter.finish()
    }
}
/// See [`DisassociateConfigurationItemsFromApplicationOutput`](crate::output::DisassociateConfigurationItemsFromApplicationOutput)
pub mod disassociate_configuration_items_from_application_output {
    /// A builder for [`DisassociateConfigurationItemsFromApplicationOutput`](crate::output::DisassociateConfigurationItemsFromApplicationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DisassociateConfigurationItemsFromApplicationOutput`](crate::output::DisassociateConfigurationItemsFromApplicationOutput)
        pub fn build(self) -> crate::output::DisassociateConfigurationItemsFromApplicationOutput {
            crate::output::DisassociateConfigurationItemsFromApplicationOutput {}
        }
    }
}
impl DisassociateConfigurationItemsFromApplicationOutput {
    /// Creates a new builder-style object to manufacture [`DisassociateConfigurationItemsFromApplicationOutput`](crate::output::DisassociateConfigurationItemsFromApplicationOutput)
    pub fn builder(
    ) -> crate::output::disassociate_configuration_items_from_application_output::Builder {
        crate::output::disassociate_configuration_items_from_application_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTagsOutput {
    /// <p>Depending on the input, this is a list of configuration items tagged with a specific
    /// tag, or a list of tags for a specific configuration item.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::ConfigurationTag>>,
    /// <p>The call returns a token. Use this token to get the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeTagsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTagsOutput");
        formatter.field("tags", &self.tags);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeTagsOutput`](crate::output::DescribeTagsOutput)
pub mod describe_tags_output {
    /// A builder for [`DescribeTagsOutput`](crate::output::DescribeTagsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::ConfigurationTag>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Depending on the input, this is a list of configuration items tagged with a specific
        /// tag, or a list of tags for a specific configuration item.</p>
        pub fn tags(mut self, input: impl Into<crate::model::ConfigurationTag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Depending on the input, this is a list of configuration items tagged with a specific
        /// tag, or a list of tags for a specific configuration item.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConfigurationTag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The call returns a token. Use this token to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The call returns a token. Use this token to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTagsOutput`](crate::output::DescribeTagsOutput)
        pub fn build(self) -> crate::output::DescribeTagsOutput {
            crate::output::DescribeTagsOutput {
                tags: self.tags,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeTagsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeTagsOutput`](crate::output::DescribeTagsOutput)
    pub fn builder() -> crate::output::describe_tags_output::Builder {
        crate::output::describe_tags_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeImportTasksOutput {
    /// <p>The token to request the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>A returned array of import tasks that match any applied filters, up to the specified
    /// number of maximum results.</p>
    pub tasks: std::option::Option<std::vec::Vec<crate::model::ImportTask>>,
}
impl std::fmt::Debug for DescribeImportTasksOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeImportTasksOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("tasks", &self.tasks);
        formatter.finish()
    }
}
/// See [`DescribeImportTasksOutput`](crate::output::DescribeImportTasksOutput)
pub mod describe_import_tasks_output {
    /// A builder for [`DescribeImportTasksOutput`](crate::output::DescribeImportTasksOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) tasks: std::option::Option<std::vec::Vec<crate::model::ImportTask>>,
    }
    impl Builder {
        /// <p>The token to request the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `tasks`.
        ///
        /// To override the contents of this collection use [`set_tasks`](Self::set_tasks).
        ///
        /// <p>A returned array of import tasks that match any applied filters, up to the specified
        /// number of maximum results.</p>
        pub fn tasks(mut self, input: impl Into<crate::model::ImportTask>) -> Self {
            let mut v = self.tasks.unwrap_or_default();
            v.push(input.into());
            self.tasks = Some(v);
            self
        }
        /// <p>A returned array of import tasks that match any applied filters, up to the specified
        /// number of maximum results.</p>
        pub fn set_tasks(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ImportTask>>,
        ) -> Self {
            self.tasks = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeImportTasksOutput`](crate::output::DescribeImportTasksOutput)
        pub fn build(self) -> crate::output::DescribeImportTasksOutput {
            crate::output::DescribeImportTasksOutput {
                next_token: self.next_token,
                tasks: self.tasks,
            }
        }
    }
}
impl DescribeImportTasksOutput {
    /// Creates a new builder-style object to manufacture [`DescribeImportTasksOutput`](crate::output::DescribeImportTasksOutput)
    pub fn builder() -> crate::output::describe_import_tasks_output::Builder {
        crate::output::describe_import_tasks_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeExportTasksOutput {
    /// <p>Contains one or more sets of export request details. When the status of a request is
    /// <code>SUCCEEDED</code>, the response includes a URL for an Amazon S3 bucket where you can
    /// view the data in a CSV file.</p>
    pub exports_info: std::option::Option<std::vec::Vec<crate::model::ExportInfo>>,
    /// <p>The <code>nextToken</code> value to include in a future
    /// <code>DescribeExportTasks</code> request. When the results of a
    /// <code>DescribeExportTasks</code> request exceed <code>maxResults</code>, this value can be
    /// used to retrieve the next page of results. This value is null when there are no more results
    /// to return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeExportTasksOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeExportTasksOutput");
        formatter.field("exports_info", &self.exports_info);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeExportTasksOutput`](crate::output::DescribeExportTasksOutput)
pub mod describe_export_tasks_output {
    /// A builder for [`DescribeExportTasksOutput`](crate::output::DescribeExportTasksOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) exports_info: std::option::Option<std::vec::Vec<crate::model::ExportInfo>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `exports_info`.
        ///
        /// To override the contents of this collection use [`set_exports_info`](Self::set_exports_info).
        ///
        /// <p>Contains one or more sets of export request details. When the status of a request is
        /// <code>SUCCEEDED</code>, the response includes a URL for an Amazon S3 bucket where you can
        /// view the data in a CSV file.</p>
        pub fn exports_info(mut self, input: impl Into<crate::model::ExportInfo>) -> Self {
            let mut v = self.exports_info.unwrap_or_default();
            v.push(input.into());
            self.exports_info = Some(v);
            self
        }
        /// <p>Contains one or more sets of export request details. When the status of a request is
        /// <code>SUCCEEDED</code>, the response includes a URL for an Amazon S3 bucket where you can
        /// view the data in a CSV file.</p>
        pub fn set_exports_info(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExportInfo>>,
        ) -> Self {
            self.exports_info = input;
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future
        /// <code>DescribeExportTasks</code> request. When the results of a
        /// <code>DescribeExportTasks</code> request exceed <code>maxResults</code>, this value can be
        /// used to retrieve the next page of results. This value is null when there are no more results
        /// to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future
        /// <code>DescribeExportTasks</code> request. When the results of a
        /// <code>DescribeExportTasks</code> request exceed <code>maxResults</code>, this value can be
        /// used to retrieve the next page of results. This value is null when there are no more results
        /// to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeExportTasksOutput`](crate::output::DescribeExportTasksOutput)
        pub fn build(self) -> crate::output::DescribeExportTasksOutput {
            crate::output::DescribeExportTasksOutput {
                exports_info: self.exports_info,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeExportTasksOutput {
    /// Creates a new builder-style object to manufacture [`DescribeExportTasksOutput`](crate::output::DescribeExportTasksOutput)
    pub fn builder() -> crate::output::describe_export_tasks_output::Builder {
        crate::output::describe_export_tasks_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeExportConfigurationsOutput {
    /// <p></p>
    pub exports_info: std::option::Option<std::vec::Vec<crate::model::ExportInfo>>,
    /// <p>The token from the previous call to describe-export-tasks.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeExportConfigurationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeExportConfigurationsOutput");
        formatter.field("exports_info", &self.exports_info);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeExportConfigurationsOutput`](crate::output::DescribeExportConfigurationsOutput)
pub mod describe_export_configurations_output {
    /// A builder for [`DescribeExportConfigurationsOutput`](crate::output::DescribeExportConfigurationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) exports_info: std::option::Option<std::vec::Vec<crate::model::ExportInfo>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `exports_info`.
        ///
        /// To override the contents of this collection use [`set_exports_info`](Self::set_exports_info).
        ///
        /// <p></p>
        pub fn exports_info(mut self, input: impl Into<crate::model::ExportInfo>) -> Self {
            let mut v = self.exports_info.unwrap_or_default();
            v.push(input.into());
            self.exports_info = Some(v);
            self
        }
        /// <p></p>
        pub fn set_exports_info(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExportInfo>>,
        ) -> Self {
            self.exports_info = input;
            self
        }
        /// <p>The token from the previous call to describe-export-tasks.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token from the previous call to describe-export-tasks.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeExportConfigurationsOutput`](crate::output::DescribeExportConfigurationsOutput)
        pub fn build(self) -> crate::output::DescribeExportConfigurationsOutput {
            crate::output::DescribeExportConfigurationsOutput {
                exports_info: self.exports_info,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeExportConfigurationsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeExportConfigurationsOutput`](crate::output::DescribeExportConfigurationsOutput)
    pub fn builder() -> crate::output::describe_export_configurations_output::Builder {
        crate::output::describe_export_configurations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeContinuousExportsOutput {
    /// <p>A list of continuous export descriptions.</p>
    pub descriptions: std::option::Option<std::vec::Vec<crate::model::ContinuousExportDescription>>,
    /// <p>The token from the previous call to <code>DescribeExportTasks</code>.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeContinuousExportsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeContinuousExportsOutput");
        formatter.field("descriptions", &self.descriptions);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeContinuousExportsOutput`](crate::output::DescribeContinuousExportsOutput)
pub mod describe_continuous_exports_output {
    /// A builder for [`DescribeContinuousExportsOutput`](crate::output::DescribeContinuousExportsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) descriptions:
            std::option::Option<std::vec::Vec<crate::model::ContinuousExportDescription>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `descriptions`.
        ///
        /// To override the contents of this collection use [`set_descriptions`](Self::set_descriptions).
        ///
        /// <p>A list of continuous export descriptions.</p>
        pub fn descriptions(
            mut self,
            input: impl Into<crate::model::ContinuousExportDescription>,
        ) -> Self {
            let mut v = self.descriptions.unwrap_or_default();
            v.push(input.into());
            self.descriptions = Some(v);
            self
        }
        /// <p>A list of continuous export descriptions.</p>
        pub fn set_descriptions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ContinuousExportDescription>>,
        ) -> Self {
            self.descriptions = input;
            self
        }
        /// <p>The token from the previous call to <code>DescribeExportTasks</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token from the previous call to <code>DescribeExportTasks</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeContinuousExportsOutput`](crate::output::DescribeContinuousExportsOutput)
        pub fn build(self) -> crate::output::DescribeContinuousExportsOutput {
            crate::output::DescribeContinuousExportsOutput {
                descriptions: self.descriptions,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeContinuousExportsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeContinuousExportsOutput`](crate::output::DescribeContinuousExportsOutput)
    pub fn builder() -> crate::output::describe_continuous_exports_output::Builder {
        crate::output::describe_continuous_exports_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeConfigurationsOutput {
    /// <p>A key in the response map. The value is an array of data.</p>
    pub configurations: std::option::Option<
        std::vec::Vec<std::collections::HashMap<std::string::String, std::string::String>>,
    >,
}
impl std::fmt::Debug for DescribeConfigurationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeConfigurationsOutput");
        formatter.field("configurations", &self.configurations);
        formatter.finish()
    }
}
/// See [`DescribeConfigurationsOutput`](crate::output::DescribeConfigurationsOutput)
pub mod describe_configurations_output {
    /// A builder for [`DescribeConfigurationsOutput`](crate::output::DescribeConfigurationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configurations: std::option::Option<
            std::vec::Vec<std::collections::HashMap<std::string::String, std::string::String>>,
        >,
    }
    impl Builder {
        /// Appends an item to `configurations`.
        ///
        /// To override the contents of this collection use [`set_configurations`](Self::set_configurations).
        ///
        /// <p>A key in the response map. The value is an array of data.</p>
        pub fn configurations(
            mut self,
            input: impl Into<std::collections::HashMap<std::string::String, std::string::String>>,
        ) -> Self {
            let mut v = self.configurations.unwrap_or_default();
            v.push(input.into());
            self.configurations = Some(v);
            self
        }
        /// <p>A key in the response map. The value is an array of data.</p>
        pub fn set_configurations(
            mut self,
            input: std::option::Option<
                std::vec::Vec<std::collections::HashMap<std::string::String, std::string::String>>,
            >,
        ) -> Self {
            self.configurations = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeConfigurationsOutput`](crate::output::DescribeConfigurationsOutput)
        pub fn build(self) -> crate::output::DescribeConfigurationsOutput {
            crate::output::DescribeConfigurationsOutput {
                configurations: self.configurations,
            }
        }
    }
}
impl DescribeConfigurationsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeConfigurationsOutput`](crate::output::DescribeConfigurationsOutput)
    pub fn builder() -> crate::output::describe_configurations_output::Builder {
        crate::output::describe_configurations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAgentsOutput {
    /// <p>Lists agents or the Connector by ID or lists all agents/Connectors associated with your
    /// user account if you did not specify an agent/Connector ID. The output includes agent/Connector
    /// IDs, IP addresses, media access control (MAC) addresses, agent/Connector health, host name
    /// where the agent/Connector resides, and the version number of each agent/Connector.</p>
    pub agents_info: std::option::Option<std::vec::Vec<crate::model::AgentInfo>>,
    /// <p>Token to retrieve the next set of results. For example, if you specified 100 IDs for
    /// <code>DescribeAgentsRequest$agentIds</code> but set
    /// <code>DescribeAgentsRequest$maxResults</code> to 10, you received a set of 10 results along
    /// with this token. Use this token in the next query to retrieve the next set of 10.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeAgentsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAgentsOutput");
        formatter.field("agents_info", &self.agents_info);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeAgentsOutput`](crate::output::DescribeAgentsOutput)
pub mod describe_agents_output {
    /// A builder for [`DescribeAgentsOutput`](crate::output::DescribeAgentsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) agents_info: std::option::Option<std::vec::Vec<crate::model::AgentInfo>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `agents_info`.
        ///
        /// To override the contents of this collection use [`set_agents_info`](Self::set_agents_info).
        ///
        /// <p>Lists agents or the Connector by ID or lists all agents/Connectors associated with your
        /// user account if you did not specify an agent/Connector ID. The output includes agent/Connector
        /// IDs, IP addresses, media access control (MAC) addresses, agent/Connector health, host name
        /// where the agent/Connector resides, and the version number of each agent/Connector.</p>
        pub fn agents_info(mut self, input: impl Into<crate::model::AgentInfo>) -> Self {
            let mut v = self.agents_info.unwrap_or_default();
            v.push(input.into());
            self.agents_info = Some(v);
            self
        }
        /// <p>Lists agents or the Connector by ID or lists all agents/Connectors associated with your
        /// user account if you did not specify an agent/Connector ID. The output includes agent/Connector
        /// IDs, IP addresses, media access control (MAC) addresses, agent/Connector health, host name
        /// where the agent/Connector resides, and the version number of each agent/Connector.</p>
        pub fn set_agents_info(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AgentInfo>>,
        ) -> Self {
            self.agents_info = input;
            self
        }
        /// <p>Token to retrieve the next set of results. For example, if you specified 100 IDs for
        /// <code>DescribeAgentsRequest$agentIds</code> but set
        /// <code>DescribeAgentsRequest$maxResults</code> to 10, you received a set of 10 results along
        /// with this token. Use this token in the next query to retrieve the next set of 10.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Token to retrieve the next set of results. For example, if you specified 100 IDs for
        /// <code>DescribeAgentsRequest$agentIds</code> but set
        /// <code>DescribeAgentsRequest$maxResults</code> to 10, you received a set of 10 results along
        /// with this token. Use this token in the next query to retrieve the next set of 10.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAgentsOutput`](crate::output::DescribeAgentsOutput)
        pub fn build(self) -> crate::output::DescribeAgentsOutput {
            crate::output::DescribeAgentsOutput {
                agents_info: self.agents_info,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeAgentsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeAgentsOutput`](crate::output::DescribeAgentsOutput)
    pub fn builder() -> crate::output::describe_agents_output::Builder {
        crate::output::describe_agents_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTagsOutput {}
impl std::fmt::Debug for DeleteTagsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTagsOutput");
        formatter.finish()
    }
}
/// See [`DeleteTagsOutput`](crate::output::DeleteTagsOutput)
pub mod delete_tags_output {
    /// A builder for [`DeleteTagsOutput`](crate::output::DeleteTagsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteTagsOutput`](crate::output::DeleteTagsOutput)
        pub fn build(self) -> crate::output::DeleteTagsOutput {
            crate::output::DeleteTagsOutput {}
        }
    }
}
impl DeleteTagsOutput {
    /// Creates a new builder-style object to manufacture [`DeleteTagsOutput`](crate::output::DeleteTagsOutput)
    pub fn builder() -> crate::output::delete_tags_output::Builder {
        crate::output::delete_tags_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteApplicationsOutput {}
impl std::fmt::Debug for DeleteApplicationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteApplicationsOutput");
        formatter.finish()
    }
}
/// See [`DeleteApplicationsOutput`](crate::output::DeleteApplicationsOutput)
pub mod delete_applications_output {
    /// A builder for [`DeleteApplicationsOutput`](crate::output::DeleteApplicationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteApplicationsOutput`](crate::output::DeleteApplicationsOutput)
        pub fn build(self) -> crate::output::DeleteApplicationsOutput {
            crate::output::DeleteApplicationsOutput {}
        }
    }
}
impl DeleteApplicationsOutput {
    /// Creates a new builder-style object to manufacture [`DeleteApplicationsOutput`](crate::output::DeleteApplicationsOutput)
    pub fn builder() -> crate::output::delete_applications_output::Builder {
        crate::output::delete_applications_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateTagsOutput {}
impl std::fmt::Debug for CreateTagsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateTagsOutput");
        formatter.finish()
    }
}
/// See [`CreateTagsOutput`](crate::output::CreateTagsOutput)
pub mod create_tags_output {
    /// A builder for [`CreateTagsOutput`](crate::output::CreateTagsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CreateTagsOutput`](crate::output::CreateTagsOutput)
        pub fn build(self) -> crate::output::CreateTagsOutput {
            crate::output::CreateTagsOutput {}
        }
    }
}
impl CreateTagsOutput {
    /// Creates a new builder-style object to manufacture [`CreateTagsOutput`](crate::output::CreateTagsOutput)
    pub fn builder() -> crate::output::create_tags_output::Builder {
        crate::output::create_tags_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateApplicationOutput {
    /// <p>Configuration ID of an application to be created.</p>
    pub configuration_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateApplicationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateApplicationOutput");
        formatter.field("configuration_id", &self.configuration_id);
        formatter.finish()
    }
}
/// See [`CreateApplicationOutput`](crate::output::CreateApplicationOutput)
pub mod create_application_output {
    /// A builder for [`CreateApplicationOutput`](crate::output::CreateApplicationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Configuration ID of an application to be created.</p>
        pub fn configuration_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_id = Some(input.into());
            self
        }
        /// <p>Configuration ID of an application to be created.</p>
        pub fn set_configuration_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateApplicationOutput`](crate::output::CreateApplicationOutput)
        pub fn build(self) -> crate::output::CreateApplicationOutput {
            crate::output::CreateApplicationOutput {
                configuration_id: self.configuration_id,
            }
        }
    }
}
impl CreateApplicationOutput {
    /// Creates a new builder-style object to manufacture [`CreateApplicationOutput`](crate::output::CreateApplicationOutput)
    pub fn builder() -> crate::output::create_application_output::Builder {
        crate::output::create_application_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDeleteImportDataOutput {
    /// <p>Error messages returned for each import task that you deleted as a response for this
    /// command.</p>
    pub errors: std::option::Option<std::vec::Vec<crate::model::BatchDeleteImportDataError>>,
}
impl std::fmt::Debug for BatchDeleteImportDataOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDeleteImportDataOutput");
        formatter.field("errors", &self.errors);
        formatter.finish()
    }
}
/// See [`BatchDeleteImportDataOutput`](crate::output::BatchDeleteImportDataOutput)
pub mod batch_delete_import_data_output {
    /// A builder for [`BatchDeleteImportDataOutput`](crate::output::BatchDeleteImportDataOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) errors:
            std::option::Option<std::vec::Vec<crate::model::BatchDeleteImportDataError>>,
    }
    impl Builder {
        /// Appends an item to `errors`.
        ///
        /// To override the contents of this collection use [`set_errors`](Self::set_errors).
        ///
        /// <p>Error messages returned for each import task that you deleted as a response for this
        /// command.</p>
        pub fn errors(
            mut self,
            input: impl Into<crate::model::BatchDeleteImportDataError>,
        ) -> Self {
            let mut v = self.errors.unwrap_or_default();
            v.push(input.into());
            self.errors = Some(v);
            self
        }
        /// <p>Error messages returned for each import task that you deleted as a response for this
        /// command.</p>
        pub fn set_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BatchDeleteImportDataError>>,
        ) -> Self {
            self.errors = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDeleteImportDataOutput`](crate::output::BatchDeleteImportDataOutput)
        pub fn build(self) -> crate::output::BatchDeleteImportDataOutput {
            crate::output::BatchDeleteImportDataOutput {
                errors: self.errors,
            }
        }
    }
}
impl BatchDeleteImportDataOutput {
    /// Creates a new builder-style object to manufacture [`BatchDeleteImportDataOutput`](crate::output::BatchDeleteImportDataOutput)
    pub fn builder() -> crate::output::batch_delete_import_data_output::Builder {
        crate::output::batch_delete_import_data_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateConfigurationItemsToApplicationOutput {}
impl std::fmt::Debug for AssociateConfigurationItemsToApplicationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateConfigurationItemsToApplicationOutput");
        formatter.finish()
    }
}
/// See [`AssociateConfigurationItemsToApplicationOutput`](crate::output::AssociateConfigurationItemsToApplicationOutput)
pub mod associate_configuration_items_to_application_output {
    /// A builder for [`AssociateConfigurationItemsToApplicationOutput`](crate::output::AssociateConfigurationItemsToApplicationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AssociateConfigurationItemsToApplicationOutput`](crate::output::AssociateConfigurationItemsToApplicationOutput)
        pub fn build(self) -> crate::output::AssociateConfigurationItemsToApplicationOutput {
            crate::output::AssociateConfigurationItemsToApplicationOutput {}
        }
    }
}
impl AssociateConfigurationItemsToApplicationOutput {
    /// Creates a new builder-style object to manufacture [`AssociateConfigurationItemsToApplicationOutput`](crate::output::AssociateConfigurationItemsToApplicationOutput)
    pub fn builder() -> crate::output::associate_configuration_items_to_application_output::Builder
    {
        crate::output::associate_configuration_items_to_application_output::Builder::default()
    }
}
