// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `AWSPoseidonService_V2015_11_01`.
///
/// This client allows ergonomic access to a `AWSPoseidonService_V2015_11_01`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AssociateConfigurationItemsToApplication` operation.
    ///
    /// See [`AssociateConfigurationItemsToApplication`](crate::client::fluent_builders::AssociateConfigurationItemsToApplication) for more information about the
    /// operation and its arguments.
    pub fn associate_configuration_items_to_application(
        &self,
    ) -> fluent_builders::AssociateConfigurationItemsToApplication<C, M, R> {
        fluent_builders::AssociateConfigurationItemsToApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchDeleteImportData` operation.
    ///
    /// See [`BatchDeleteImportData`](crate::client::fluent_builders::BatchDeleteImportData) for more information about the
    /// operation and its arguments.
    pub fn batch_delete_import_data(&self) -> fluent_builders::BatchDeleteImportData<C, M, R> {
        fluent_builders::BatchDeleteImportData::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateApplication` operation.
    ///
    /// See [`CreateApplication`](crate::client::fluent_builders::CreateApplication) for more information about the
    /// operation and its arguments.
    pub fn create_application(&self) -> fluent_builders::CreateApplication<C, M, R> {
        fluent_builders::CreateApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateTags` operation.
    ///
    /// See [`CreateTags`](crate::client::fluent_builders::CreateTags) for more information about the
    /// operation and its arguments.
    pub fn create_tags(&self) -> fluent_builders::CreateTags<C, M, R> {
        fluent_builders::CreateTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteApplications` operation.
    ///
    /// See [`DeleteApplications`](crate::client::fluent_builders::DeleteApplications) for more information about the
    /// operation and its arguments.
    pub fn delete_applications(&self) -> fluent_builders::DeleteApplications<C, M, R> {
        fluent_builders::DeleteApplications::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteTags` operation.
    ///
    /// See [`DeleteTags`](crate::client::fluent_builders::DeleteTags) for more information about the
    /// operation and its arguments.
    pub fn delete_tags(&self) -> fluent_builders::DeleteTags<C, M, R> {
        fluent_builders::DeleteTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAgents` operation.
    ///
    /// See [`DescribeAgents`](crate::client::fluent_builders::DescribeAgents) for more information about the
    /// operation and its arguments.
    pub fn describe_agents(&self) -> fluent_builders::DescribeAgents<C, M, R> {
        fluent_builders::DescribeAgents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeConfigurations` operation.
    ///
    /// See [`DescribeConfigurations`](crate::client::fluent_builders::DescribeConfigurations) for more information about the
    /// operation and its arguments.
    pub fn describe_configurations(&self) -> fluent_builders::DescribeConfigurations<C, M, R> {
        fluent_builders::DescribeConfigurations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeContinuousExports` operation.
    ///
    /// See [`DescribeContinuousExports`](crate::client::fluent_builders::DescribeContinuousExports) for more information about the
    /// operation and its arguments.
    pub fn describe_continuous_exports(
        &self,
    ) -> fluent_builders::DescribeContinuousExports<C, M, R> {
        fluent_builders::DescribeContinuousExports::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeExportConfigurations` operation.
    ///
    /// See [`DescribeExportConfigurations`](crate::client::fluent_builders::DescribeExportConfigurations) for more information about the
    /// operation and its arguments.
    pub fn describe_export_configurations(
        &self,
    ) -> fluent_builders::DescribeExportConfigurations<C, M, R> {
        fluent_builders::DescribeExportConfigurations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeExportTasks` operation.
    ///
    /// See [`DescribeExportTasks`](crate::client::fluent_builders::DescribeExportTasks) for more information about the
    /// operation and its arguments.
    pub fn describe_export_tasks(&self) -> fluent_builders::DescribeExportTasks<C, M, R> {
        fluent_builders::DescribeExportTasks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeImportTasks` operation.
    ///
    /// See [`DescribeImportTasks`](crate::client::fluent_builders::DescribeImportTasks) for more information about the
    /// operation and its arguments.
    pub fn describe_import_tasks(&self) -> fluent_builders::DescribeImportTasks<C, M, R> {
        fluent_builders::DescribeImportTasks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeTags` operation.
    ///
    /// See [`DescribeTags`](crate::client::fluent_builders::DescribeTags) for more information about the
    /// operation and its arguments.
    pub fn describe_tags(&self) -> fluent_builders::DescribeTags<C, M, R> {
        fluent_builders::DescribeTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateConfigurationItemsFromApplication` operation.
    ///
    /// See [`DisassociateConfigurationItemsFromApplication`](crate::client::fluent_builders::DisassociateConfigurationItemsFromApplication) for more information about the
    /// operation and its arguments.
    pub fn disassociate_configuration_items_from_application(
        &self,
    ) -> fluent_builders::DisassociateConfigurationItemsFromApplication<C, M, R> {
        fluent_builders::DisassociateConfigurationItemsFromApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ExportConfigurations` operation.
    ///
    /// See [`ExportConfigurations`](crate::client::fluent_builders::ExportConfigurations) for more information about the
    /// operation and its arguments.
    pub fn export_configurations(&self) -> fluent_builders::ExportConfigurations<C, M, R> {
        fluent_builders::ExportConfigurations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDiscoverySummary` operation.
    ///
    /// See [`GetDiscoverySummary`](crate::client::fluent_builders::GetDiscoverySummary) for more information about the
    /// operation and its arguments.
    pub fn get_discovery_summary(&self) -> fluent_builders::GetDiscoverySummary<C, M, R> {
        fluent_builders::GetDiscoverySummary::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListConfigurations` operation.
    ///
    /// See [`ListConfigurations`](crate::client::fluent_builders::ListConfigurations) for more information about the
    /// operation and its arguments.
    pub fn list_configurations(&self) -> fluent_builders::ListConfigurations<C, M, R> {
        fluent_builders::ListConfigurations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListServerNeighbors` operation.
    ///
    /// See [`ListServerNeighbors`](crate::client::fluent_builders::ListServerNeighbors) for more information about the
    /// operation and its arguments.
    pub fn list_server_neighbors(&self) -> fluent_builders::ListServerNeighbors<C, M, R> {
        fluent_builders::ListServerNeighbors::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartContinuousExport` operation.
    ///
    /// See [`StartContinuousExport`](crate::client::fluent_builders::StartContinuousExport) for more information about the
    /// operation and its arguments.
    pub fn start_continuous_export(&self) -> fluent_builders::StartContinuousExport<C, M, R> {
        fluent_builders::StartContinuousExport::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartDataCollectionByAgentIds` operation.
    ///
    /// See [`StartDataCollectionByAgentIds`](crate::client::fluent_builders::StartDataCollectionByAgentIds) for more information about the
    /// operation and its arguments.
    pub fn start_data_collection_by_agent_ids(
        &self,
    ) -> fluent_builders::StartDataCollectionByAgentIds<C, M, R> {
        fluent_builders::StartDataCollectionByAgentIds::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartExportTask` operation.
    ///
    /// See [`StartExportTask`](crate::client::fluent_builders::StartExportTask) for more information about the
    /// operation and its arguments.
    pub fn start_export_task(&self) -> fluent_builders::StartExportTask<C, M, R> {
        fluent_builders::StartExportTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartImportTask` operation.
    ///
    /// See [`StartImportTask`](crate::client::fluent_builders::StartImportTask) for more information about the
    /// operation and its arguments.
    pub fn start_import_task(&self) -> fluent_builders::StartImportTask<C, M, R> {
        fluent_builders::StartImportTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopContinuousExport` operation.
    ///
    /// See [`StopContinuousExport`](crate::client::fluent_builders::StopContinuousExport) for more information about the
    /// operation and its arguments.
    pub fn stop_continuous_export(&self) -> fluent_builders::StopContinuousExport<C, M, R> {
        fluent_builders::StopContinuousExport::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopDataCollectionByAgentIds` operation.
    ///
    /// See [`StopDataCollectionByAgentIds`](crate::client::fluent_builders::StopDataCollectionByAgentIds) for more information about the
    /// operation and its arguments.
    pub fn stop_data_collection_by_agent_ids(
        &self,
    ) -> fluent_builders::StopDataCollectionByAgentIds<C, M, R> {
        fluent_builders::StopDataCollectionByAgentIds::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateApplication` operation.
    ///
    /// See [`UpdateApplication`](crate::client::fluent_builders::UpdateApplication) for more information about the
    /// operation and its arguments.
    pub fn update_application(&self) -> fluent_builders::UpdateApplication<C, M, R> {
        fluent_builders::UpdateApplication::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateConfigurationItemsToApplication`.
    ///
    /// <p>Associates one or more configuration items with an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct AssociateConfigurationItemsToApplication<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_configuration_items_to_application_input::Builder,
    }
    impl<C, M, R> AssociateConfigurationItemsToApplication<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateConfigurationItemsToApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateConfigurationItemsToApplicationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::AssociateConfigurationItemsToApplicationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateConfigurationItemsToApplicationInputOperationOutputAlias,
                crate::output::AssociateConfigurationItemsToApplicationOutput,
                crate::error::AssociateConfigurationItemsToApplicationError,
                crate::input::AssociateConfigurationItemsToApplicationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The configuration ID of an application with which items are to be associated.</p>
        pub fn application_configuration_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_configuration_id(inp);
            self
        }
        /// <p>The configuration ID of an application with which items are to be associated.</p>
        pub fn set_application_configuration_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_configuration_id(input);
            self
        }
        /// Appends an item to `configurationIds`.
        ///
        /// To override the contents of this collection use [`set_configuration_ids`](Self::set_configuration_ids).
        ///
        /// <p>The ID of each configuration item to be associated with an application.</p>
        pub fn configuration_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_ids(inp);
            self
        }
        /// <p>The ID of each configuration item to be associated with an application.</p>
        pub fn set_configuration_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_configuration_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchDeleteImportData`.
    ///
    /// <p>Deletes one or more import tasks, each identified by their import ID. Each import task has
    /// a number of records that can identify servers or applications. </p>
    ///
    /// <p>AWS Application Discovery Service has built-in matching logic that will identify when
    /// discovered servers match existing entries that you've previously discovered, the information
    /// for the already-existing discovered server is updated. When you delete an import task that
    /// contains records that were used to match, the information in those matched records that comes
    /// from the deleted records will also be deleted.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchDeleteImportData<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_delete_import_data_input::Builder,
    }
    impl<C, M, R> BatchDeleteImportData<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchDeleteImportData`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchDeleteImportDataOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchDeleteImportDataError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchDeleteImportDataInputOperationOutputAlias,
                crate::output::BatchDeleteImportDataOutput,
                crate::error::BatchDeleteImportDataError,
                crate::input::BatchDeleteImportDataInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `importTaskIds`.
        ///
        /// To override the contents of this collection use [`set_import_task_ids`](Self::set_import_task_ids).
        ///
        /// <p>The IDs for the import tasks that you want to delete.</p>
        pub fn import_task_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.import_task_ids(inp);
            self
        }
        /// <p>The IDs for the import tasks that you want to delete.</p>
        pub fn set_import_task_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_import_task_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateApplication`.
    ///
    /// <p>Creates an application with the given name and description.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateApplication<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_application_input::Builder,
    }
    impl<C, M, R> CreateApplication<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateApplicationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateApplicationInputOperationOutputAlias,
                crate::output::CreateApplicationOutput,
                crate::error::CreateApplicationError,
                crate::input::CreateApplicationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of the application to be created.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>Name of the application to be created.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Description of the application to be created.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>Description of the application to be created.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTags`.
    ///
    /// <p>Creates one or more tags for configuration items. Tags are metadata that help you
    /// categorize IT assets. This API accepts a list of multiple configuration items.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateTags<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_tags_input::Builder,
    }
    impl<C, M, R> CreateTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateTagsInputOperationOutputAlias,
                crate::output::CreateTagsOutput,
                crate::error::CreateTagsError,
                crate::input::CreateTagsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `configurationIds`.
        ///
        /// To override the contents of this collection use [`set_configuration_ids`](Self::set_configuration_ids).
        ///
        /// <p>A list of configuration items that you want to tag.</p>
        pub fn configuration_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_ids(inp);
            self
        }
        /// <p>A list of configuration items that you want to tag.</p>
        pub fn set_configuration_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_configuration_ids(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags that you want to associate with one or more configuration items. Specify the tags
        /// that you want to create in a <i>key</i>-<i>value</i> format. For
        /// example:</p>
        /// <p>
        /// <code>{"key": "serverType", "value": "webServer"}</code>
        /// </p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Tags that you want to associate with one or more configuration items. Specify the tags
        /// that you want to create in a <i>key</i>-<i>value</i> format. For
        /// example:</p>
        /// <p>
        /// <code>{"key": "serverType", "value": "webServer"}</code>
        /// </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteApplications`.
    ///
    /// <p>Deletes a list of applications and their associations with configuration
    /// items.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteApplications<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_applications_input::Builder,
    }
    impl<C, M, R> DeleteApplications<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteApplications`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteApplicationsOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteApplicationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteApplicationsInputOperationOutputAlias,
                crate::output::DeleteApplicationsOutput,
                crate::error::DeleteApplicationsError,
                crate::input::DeleteApplicationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `configurationIds`.
        ///
        /// To override the contents of this collection use [`set_configuration_ids`](Self::set_configuration_ids).
        ///
        /// <p>Configuration ID of an application to be deleted.</p>
        pub fn configuration_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_ids(inp);
            self
        }
        /// <p>Configuration ID of an application to be deleted.</p>
        pub fn set_configuration_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_configuration_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTags`.
    ///
    /// <p>Deletes the association between configuration items and one or more tags. This API
    /// accepts a list of multiple configuration items.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteTags<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_tags_input::Builder,
    }
    impl<C, M, R> DeleteTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteTagsInputOperationOutputAlias,
                crate::output::DeleteTagsOutput,
                crate::error::DeleteTagsError,
                crate::input::DeleteTagsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `configurationIds`.
        ///
        /// To override the contents of this collection use [`set_configuration_ids`](Self::set_configuration_ids).
        ///
        /// <p>A list of configuration items with tags that you want to delete.</p>
        pub fn configuration_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_ids(inp);
            self
        }
        /// <p>A list of configuration items with tags that you want to delete.</p>
        pub fn set_configuration_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_configuration_ids(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags that you want to delete from one or more configuration items. Specify the tags
        /// that you want to delete in a <i>key</i>-<i>value</i> format. For
        /// example:</p>
        /// <p>
        /// <code>{"key": "serverType", "value": "webServer"}</code>
        /// </p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Tags that you want to delete from one or more configuration items. Specify the tags
        /// that you want to delete in a <i>key</i>-<i>value</i> format. For
        /// example:</p>
        /// <p>
        /// <code>{"key": "serverType", "value": "webServer"}</code>
        /// </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAgents`.
    ///
    /// <p>Lists agents or connectors as specified by ID or other filters. All agents/connectors
    /// associated with your user account can be listed if you call <code>DescribeAgents</code> as is
    /// without passing any parameters.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeAgents<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_agents_input::Builder,
    }
    impl<C, M, R> DescribeAgents<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAgents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAgentsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAgentsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAgentsInputOperationOutputAlias,
                crate::output::DescribeAgentsOutput,
                crate::error::DescribeAgentsError,
                crate::input::DescribeAgentsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `agentIds`.
        ///
        /// To override the contents of this collection use [`set_agent_ids`](Self::set_agent_ids).
        ///
        /// <p>The agent or the Connector IDs for which you want information. If you specify no IDs,
        /// the system returns information about all agents/Connectors associated with your AWS user
        /// account.</p>
        pub fn agent_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.agent_ids(inp);
            self
        }
        /// <p>The agent or the Connector IDs for which you want information. If you specify no IDs,
        /// the system returns information about all agents/Connectors associated with your AWS user
        /// account.</p>
        pub fn set_agent_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_agent_ids(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>You can filter the request using various logical operators and a
        /// <i>key</i>-<i>value</i> format. For example: </p>
        /// <p>
        /// <code>{"key": "collectionStatus", "value": "STARTED"}</code>
        /// </p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>You can filter the request using various logical operators and a
        /// <i>key</i>-<i>value</i> format. For example: </p>
        /// <p>
        /// <code>{"key": "collectionStatus", "value": "STARTED"}</code>
        /// </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The total number of agents/Connectors to return in a single page of output. The maximum
        /// value is 100.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The total number of agents/Connectors to return in a single page of output. The maximum
        /// value is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Token to retrieve the next set of results. For example, if you previously specified 100
        /// IDs for <code>DescribeAgentsRequest$agentIds</code> but set
        /// <code>DescribeAgentsRequest$maxResults</code> to 10, you received a set of 10 results along
        /// with a token. Use that token in this query to get the next set of 10.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Token to retrieve the next set of results. For example, if you previously specified 100
        /// IDs for <code>DescribeAgentsRequest$agentIds</code> but set
        /// <code>DescribeAgentsRequest$maxResults</code> to 10, you received a set of 10 results along
        /// with a token. Use that token in this query to get the next set of 10.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeConfigurations`.
    ///
    /// <p>Retrieves attributes for a list of configuration item IDs.</p>
    ///
    /// <note>
    /// <p>All of the supplied IDs must be for the same asset type from one of the
    /// following:</p>
    /// <ul>
    /// <li>
    /// <p>server</p>
    /// </li>
    /// <li>
    /// <p>application</p>
    /// </li>
    /// <li>
    /// <p>process</p>
    /// </li>
    /// <li>
    /// <p>connection</p>
    /// </li>
    /// </ul>
    ///
    /// <p>Output fields are specific to the asset type specified. For example, the output for a
    /// <i>server</i> configuration item includes a list of attributes about the
    /// server, such as host name, operating system, number of network cards, etc.</p>
    /// <p>For a complete list of outputs for each asset type, see <a href="https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-api-queries.html#DescribeConfigurations">Using the DescribeConfigurations Action</a> in the <i>AWS Application
    /// Discovery Service User Guide</i>.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DescribeConfigurations<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_configurations_input::Builder,
    }
    impl<C, M, R> DescribeConfigurations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeConfigurations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeConfigurationsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeConfigurationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeConfigurationsInputOperationOutputAlias,
                crate::output::DescribeConfigurationsOutput,
                crate::error::DescribeConfigurationsError,
                crate::input::DescribeConfigurationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `configurationIds`.
        ///
        /// To override the contents of this collection use [`set_configuration_ids`](Self::set_configuration_ids).
        ///
        /// <p>One or more configuration IDs.</p>
        pub fn configuration_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_ids(inp);
            self
        }
        /// <p>One or more configuration IDs.</p>
        pub fn set_configuration_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_configuration_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeContinuousExports`.
    ///
    /// <p>Lists exports as specified by ID. All continuous exports associated with your user
    /// account can be listed if you call <code>DescribeContinuousExports</code> as is without passing
    /// any parameters.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeContinuousExports<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_continuous_exports_input::Builder,
    }
    impl<C, M, R> DescribeContinuousExports<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeContinuousExports`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeContinuousExportsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeContinuousExportsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeContinuousExportsInputOperationOutputAlias,
                crate::output::DescribeContinuousExportsOutput,
                crate::error::DescribeContinuousExportsError,
                crate::input::DescribeContinuousExportsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `exportIds`.
        ///
        /// To override the contents of this collection use [`set_export_ids`](Self::set_export_ids).
        ///
        /// <p>The unique IDs assigned to the exports.</p>
        pub fn export_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.export_ids(inp);
            self
        }
        /// <p>The unique IDs assigned to the exports.</p>
        pub fn set_export_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_export_ids(input);
            self
        }
        /// <p>A number between 1 and 100 specifying the maximum number of continuous export
        /// descriptions returned.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>A number between 1 and 100 specifying the maximum number of continuous export
        /// descriptions returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token from the previous call to <code>DescribeExportTasks</code>.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token from the previous call to <code>DescribeExportTasks</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeExportConfigurations`.
    ///
    /// <p>
    /// <code>DescribeExportConfigurations</code> is deprecated. Use <a href="https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeExportTasks.html">DescribeImportTasks</a>, instead.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeExportConfigurations<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_export_configurations_input::Builder,
    }
    impl<C, M, R> DescribeExportConfigurations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeExportConfigurations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeExportConfigurationsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeExportConfigurationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeExportConfigurationsInputOperationOutputAlias,
                crate::output::DescribeExportConfigurationsOutput,
                crate::error::DescribeExportConfigurationsError,
                crate::input::DescribeExportConfigurationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `exportIds`.
        ///
        /// To override the contents of this collection use [`set_export_ids`](Self::set_export_ids).
        ///
        /// <p>A list of continuous export IDs to search for.</p>
        pub fn export_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.export_ids(inp);
            self
        }
        /// <p>A list of continuous export IDs to search for.</p>
        pub fn set_export_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_export_ids(input);
            self
        }
        /// <p>A number between 1 and 100 specifying the maximum number of continuous export
        /// descriptions returned.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>A number between 1 and 100 specifying the maximum number of continuous export
        /// descriptions returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token from the previous call to describe-export-tasks.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token from the previous call to describe-export-tasks.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeExportTasks`.
    ///
    /// <p>Retrieve status of one or more export tasks. You can retrieve the status of up to 100
    /// export tasks.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeExportTasks<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_export_tasks_input::Builder,
    }
    impl<C, M, R> DescribeExportTasks<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeExportTasks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeExportTasksOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeExportTasksError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeExportTasksInputOperationOutputAlias,
                crate::output::DescribeExportTasksOutput,
                crate::error::DescribeExportTasksError,
                crate::input::DescribeExportTasksInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `exportIds`.
        ///
        /// To override the contents of this collection use [`set_export_ids`](Self::set_export_ids).
        ///
        /// <p>One or more unique identifiers used to query the status of an export request.</p>
        pub fn export_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.export_ids(inp);
            self
        }
        /// <p>One or more unique identifiers used to query the status of an export request.</p>
        pub fn set_export_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_export_ids(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>One or more filters.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>AgentId</code> - ID of the agent whose collected data will be
        /// exported</p>
        /// </li>
        /// </ul>
        pub fn filters(mut self, inp: impl Into<crate::model::ExportFilter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>One or more filters.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>AgentId</code> - ID of the agent whose collected data will be
        /// exported</p>
        /// </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExportFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of volume results returned by <code>DescribeExportTasks</code> in
        /// paginated output. When this parameter is used, <code>DescribeExportTasks</code> only returns
        /// <code>maxResults</code> results in a single page along with a <code>nextToken</code>
        /// response element.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of volume results returned by <code>DescribeExportTasks</code> in
        /// paginated output. When this parameter is used, <code>DescribeExportTasks</code> only returns
        /// <code>maxResults</code> results in a single page along with a <code>nextToken</code>
        /// response element.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>DescribeExportTasks</code> request where <code>maxResults</code> was used and the
        /// results exceeded the value of that parameter. Pagination continues from the end of the
        /// previous results that returned the <code>nextToken</code> value. This value is null when there
        /// are no more results to return.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>DescribeExportTasks</code> request where <code>maxResults</code> was used and the
        /// results exceeded the value of that parameter. Pagination continues from the end of the
        /// previous results that returned the <code>nextToken</code> value. This value is null when there
        /// are no more results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeImportTasks`.
    ///
    /// <p>Returns an array of import tasks for your account, including status information, times,
    /// IDs, the Amazon S3 Object URL for the import file, and more.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeImportTasks<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_import_tasks_input::Builder,
    }
    impl<C, M, R> DescribeImportTasks<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeImportTasks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeImportTasksOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeImportTasksError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeImportTasksInputOperationOutputAlias,
                crate::output::DescribeImportTasksOutput,
                crate::error::DescribeImportTasksError,
                crate::input::DescribeImportTasksInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>An array of name-value pairs that you provide to filter the results for the
        /// <code>DescribeImportTask</code> request to a specific subset of results. Currently, wildcard
        /// values aren't supported for filters.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::ImportTaskFilter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>An array of name-value pairs that you provide to filter the results for the
        /// <code>DescribeImportTask</code> request to a specific subset of results. Currently, wildcard
        /// values aren't supported for filters.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ImportTaskFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of results that you want this request to return, up to 100.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results that you want this request to return, up to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token to request a specific page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to request a specific page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTags`.
    ///
    /// <p>Retrieves a list of configuration items that have tags as specified by the key-value
    /// pairs, name and value, passed to the optional parameter <code>filters</code>.</p>
    /// <p>There are three valid tag filter names:</p>
    /// <ul>
    /// <li>
    /// <p>tagKey</p>
    /// </li>
    /// <li>
    /// <p>tagValue</p>
    /// </li>
    /// <li>
    /// <p>configurationId</p>
    /// </li>
    /// </ul>
    /// <p>Also, all configuration items associated with your user account that have tags can be
    /// listed if you call <code>DescribeTags</code> as is without passing any parameters.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeTags<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_tags_input::Builder,
    }
    impl<C, M, R> DescribeTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeTagsInputOperationOutputAlias,
                crate::output::DescribeTagsOutput,
                crate::error::DescribeTagsError,
                crate::input::DescribeTagsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>You can filter the list using a <i>key</i>-<i>value</i>
        /// format. You can separate these items by using logical operators. Allowed filters include
        /// <code>tagKey</code>, <code>tagValue</code>, and <code>configurationId</code>. </p>
        pub fn filters(mut self, inp: impl Into<crate::model::TagFilter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>You can filter the list using a <i>key</i>-<i>value</i>
        /// format. You can separate these items by using logical operators. Allowed filters include
        /// <code>tagKey</code>, <code>tagValue</code>, and <code>configurationId</code>. </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The total number of items to return in a single page of output. The maximum value is
        /// 100.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The total number of items to return in a single page of output. The maximum value is
        /// 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateConfigurationItemsFromApplication`.
    ///
    /// <p>Disassociates one or more configuration items from an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateConfigurationItemsFromApplication<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_configuration_items_from_application_input::Builder,
    }
    impl<C, M, R> DisassociateConfigurationItemsFromApplication<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateConfigurationItemsFromApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
                                pub async fn send(self) -> std::result::Result<crate::output::DisassociateConfigurationItemsFromApplicationOutput, aws_smithy_http::result::SdkError<crate::error::DisassociateConfigurationItemsFromApplicationError>>
                                where
                                    R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<crate::input::DisassociateConfigurationItemsFromApplicationInputOperationOutputAlias,
                                    crate::output::DisassociateConfigurationItemsFromApplicationOutput,
                                    crate::error::DisassociateConfigurationItemsFromApplicationError,
                                    crate::input::DisassociateConfigurationItemsFromApplicationInputOperationRetryAlias>,
                                {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Configuration ID of an application from which each item is disassociated.</p>
        pub fn application_configuration_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_configuration_id(inp);
            self
        }
        /// <p>Configuration ID of an application from which each item is disassociated.</p>
        pub fn set_application_configuration_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_configuration_id(input);
            self
        }
        /// Appends an item to `configurationIds`.
        ///
        /// To override the contents of this collection use [`set_configuration_ids`](Self::set_configuration_ids).
        ///
        /// <p>Configuration ID of each item to be disassociated from an application.</p>
        pub fn configuration_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_ids(inp);
            self
        }
        /// <p>Configuration ID of each item to be disassociated from an application.</p>
        pub fn set_configuration_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_configuration_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ExportConfigurations`.
    ///
    /// <p>Deprecated. Use <code>StartExportTask</code> instead.</p>
    /// <p>Exports all discovered configuration data to an Amazon S3 bucket or an application that
    /// enables you to view and evaluate the data. Data includes tags and tag associations, processes,
    /// connections, servers, and system performance. This API returns an export ID that you can query
    /// using the <i>DescribeExportConfigurations</i> API. The system imposes a limit of
    /// two configuration exports in six hours.</p>
    #[derive(std::fmt::Debug)]
    pub struct ExportConfigurations<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::export_configurations_input::Builder,
    }
    impl<C, M, R> ExportConfigurations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ExportConfigurations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ExportConfigurationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ExportConfigurationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ExportConfigurationsInputOperationOutputAlias,
                crate::output::ExportConfigurationsOutput,
                crate::error::ExportConfigurationsError,
                crate::input::ExportConfigurationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetDiscoverySummary`.
    ///
    /// <p>Retrieves a short summary of discovered assets.</p>
    /// <p>This API operation takes no request parameters and is called as is at the command
    /// prompt as shown in the example.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetDiscoverySummary<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_discovery_summary_input::Builder,
    }
    impl<C, M, R> GetDiscoverySummary<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDiscoverySummary`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDiscoverySummaryOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDiscoverySummaryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDiscoverySummaryInputOperationOutputAlias,
                crate::output::GetDiscoverySummaryOutput,
                crate::error::GetDiscoverySummaryError,
                crate::input::GetDiscoverySummaryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `ListConfigurations`.
    ///
    /// <p>Retrieves a list of configuration items as specified by the value passed to the
    /// required parameter <code>configurationType</code>. Optional filtering may be applied to refine
    /// search results.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListConfigurations<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_configurations_input::Builder,
    }
    impl<C, M, R> ListConfigurations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListConfigurations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListConfigurationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListConfigurationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListConfigurationsInputOperationOutputAlias,
                crate::output::ListConfigurationsOutput,
                crate::error::ListConfigurationsError,
                crate::input::ListConfigurationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A valid configuration identified by Application Discovery Service. </p>
        pub fn configuration_type(mut self, inp: crate::model::ConfigurationItemType) -> Self {
            self.inner = self.inner.configuration_type(inp);
            self
        }
        /// <p>A valid configuration identified by Application Discovery Service. </p>
        pub fn set_configuration_type(
            mut self,
            input: std::option::Option<crate::model::ConfigurationItemType>,
        ) -> Self {
            self.inner = self.inner.set_configuration_type(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>You can filter the request using various logical operators and a
        /// <i>key</i>-<i>value</i> format. For example: </p>
        /// <p>
        /// <code>{"key": "serverType", "value": "webServer"}</code>
        /// </p>
        /// <p>For a complete list of filter options and guidance about using them with this action,
        /// see <a href="https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-api-queries.html#ListConfigurations">Using the ListConfigurations Action</a> in the <i>AWS Application Discovery
        /// Service User Guide</i>.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>You can filter the request using various logical operators and a
        /// <i>key</i>-<i>value</i> format. For example: </p>
        /// <p>
        /// <code>{"key": "serverType", "value": "webServer"}</code>
        /// </p>
        /// <p>For a complete list of filter options and guidance about using them with this action,
        /// see <a href="https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-api-queries.html#ListConfigurations">Using the ListConfigurations Action</a> in the <i>AWS Application Discovery
        /// Service User Guide</i>.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The total number of items to return. The maximum value is 100.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The total number of items to return. The maximum value is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Token to retrieve the next set of results. For example, if a previous call to
        /// ListConfigurations returned 100 items, but you set
        /// <code>ListConfigurationsRequest$maxResults</code> to 10, you received a set of 10 results
        /// along with a token. Use that token in this query to get the next set of 10.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Token to retrieve the next set of results. For example, if a previous call to
        /// ListConfigurations returned 100 items, but you set
        /// <code>ListConfigurationsRequest$maxResults</code> to 10, you received a set of 10 results
        /// along with a token. Use that token in this query to get the next set of 10.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Appends an item to `orderBy`.
        ///
        /// To override the contents of this collection use [`set_order_by`](Self::set_order_by).
        ///
        /// <p>Certain filter criteria return output that can be sorted in ascending or descending
        /// order. For a list of output characteristics for each filter, see <a href="https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-api-queries.html#ListConfigurations">Using the ListConfigurations Action</a> in the <i>AWS Application Discovery
        /// Service User Guide</i>.</p>
        pub fn order_by(mut self, inp: impl Into<crate::model::OrderByElement>) -> Self {
            self.inner = self.inner.order_by(inp);
            self
        }
        /// <p>Certain filter criteria return output that can be sorted in ascending or descending
        /// order. For a list of output characteristics for each filter, see <a href="https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-api-queries.html#ListConfigurations">Using the ListConfigurations Action</a> in the <i>AWS Application Discovery
        /// Service User Guide</i>.</p>
        pub fn set_order_by(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OrderByElement>>,
        ) -> Self {
            self.inner = self.inner.set_order_by(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListServerNeighbors`.
    ///
    /// <p>Retrieves a list of servers that are one network hop away from a specified
    /// server.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListServerNeighbors<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_server_neighbors_input::Builder,
    }
    impl<C, M, R> ListServerNeighbors<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListServerNeighbors`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListServerNeighborsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListServerNeighborsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListServerNeighborsInputOperationOutputAlias,
                crate::output::ListServerNeighborsOutput,
                crate::error::ListServerNeighborsError,
                crate::input::ListServerNeighborsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Configuration ID of the server for which neighbors are being listed.</p>
        pub fn configuration_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_id(inp);
            self
        }
        /// <p>Configuration ID of the server for which neighbors are being listed.</p>
        pub fn set_configuration_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_id(input);
            self
        }
        /// <p>Flag to indicate if port and protocol information is needed as part of the
        /// response.</p>
        pub fn port_information_needed(mut self, inp: bool) -> Self {
            self.inner = self.inner.port_information_needed(inp);
            self
        }
        /// <p>Flag to indicate if port and protocol information is needed as part of the
        /// response.</p>
        pub fn set_port_information_needed(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_port_information_needed(input);
            self
        }
        /// Appends an item to `neighborConfigurationIds`.
        ///
        /// To override the contents of this collection use [`set_neighbor_configuration_ids`](Self::set_neighbor_configuration_ids).
        ///
        /// <p>List of configuration IDs to test for one-hop-away.</p>
        pub fn neighbor_configuration_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.neighbor_configuration_ids(inp);
            self
        }
        /// <p>List of configuration IDs to test for one-hop-away.</p>
        pub fn set_neighbor_configuration_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_neighbor_configuration_ids(input);
            self
        }
        /// <p>Maximum number of results to return in a single page of output.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Maximum number of results to return in a single page of output.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Token to retrieve the next set of results. For example, if you previously specified 100
        /// IDs for <code>ListServerNeighborsRequest$neighborConfigurationIds</code> but set
        /// <code>ListServerNeighborsRequest$maxResults</code> to 10, you received a set of 10 results
        /// along with a token. Use that token in this query to get the next set of 10.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Token to retrieve the next set of results. For example, if you previously specified 100
        /// IDs for <code>ListServerNeighborsRequest$neighborConfigurationIds</code> but set
        /// <code>ListServerNeighborsRequest$maxResults</code> to 10, you received a set of 10 results
        /// along with a token. Use that token in this query to get the next set of 10.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartContinuousExport`.
    ///
    /// <p>Start the continuous flow of agent's discovered data into Amazon Athena.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartContinuousExport<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_continuous_export_input::Builder,
    }
    impl<C, M, R> StartContinuousExport<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartContinuousExport`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartContinuousExportOutput,
            aws_smithy_http::result::SdkError<crate::error::StartContinuousExportError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartContinuousExportInputOperationOutputAlias,
                crate::output::StartContinuousExportOutput,
                crate::error::StartContinuousExportError,
                crate::input::StartContinuousExportInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `StartDataCollectionByAgentIds`.
    ///
    /// <p>Instructs the specified agents or connectors to start collecting data.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartDataCollectionByAgentIds<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_data_collection_by_agent_ids_input::Builder,
    }
    impl<C, M, R> StartDataCollectionByAgentIds<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartDataCollectionByAgentIds`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartDataCollectionByAgentIdsOutput,
            aws_smithy_http::result::SdkError<crate::error::StartDataCollectionByAgentIdsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartDataCollectionByAgentIdsInputOperationOutputAlias,
                crate::output::StartDataCollectionByAgentIdsOutput,
                crate::error::StartDataCollectionByAgentIdsError,
                crate::input::StartDataCollectionByAgentIdsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `agentIds`.
        ///
        /// To override the contents of this collection use [`set_agent_ids`](Self::set_agent_ids).
        ///
        /// <p>The IDs of the agents or connectors from which to start collecting data. If you send a
        /// request to an agent/connector ID that you do not have permission to contact, according to your
        /// AWS account, the service does not throw an exception. Instead, it returns the error in the
        /// <i>Description</i> field. If you send a request to multiple agents/connectors
        /// and you do not have permission to contact some of those agents/connectors, the system does not
        /// throw an exception. Instead, the system shows <code>Failed</code> in the
        /// <i>Description</i> field.</p>
        pub fn agent_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.agent_ids(inp);
            self
        }
        /// <p>The IDs of the agents or connectors from which to start collecting data. If you send a
        /// request to an agent/connector ID that you do not have permission to contact, according to your
        /// AWS account, the service does not throw an exception. Instead, it returns the error in the
        /// <i>Description</i> field. If you send a request to multiple agents/connectors
        /// and you do not have permission to contact some of those agents/connectors, the system does not
        /// throw an exception. Instead, the system shows <code>Failed</code> in the
        /// <i>Description</i> field.</p>
        pub fn set_agent_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_agent_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartExportTask`.
    ///
    /// <p> Begins the export of discovered data to an S3 bucket.</p>
    /// <p> If you specify <code>agentIds</code> in a filter, the task exports up to 72 hours of
    /// detailed data collected by the identified Application Discovery Agent, including network,
    /// process, and performance details. A time range for exported agent data may be set by using
    /// <code>startTime</code> and <code>endTime</code>. Export of detailed agent data is limited to
    /// five concurrently running exports. </p>
    /// <p> If you do not include an <code>agentIds</code> filter, summary data is exported that
    /// includes both AWS Agentless Discovery Connector data and summary data from AWS Discovery
    /// Agents. Export of summary data is limited to two exports per day. </p>
    #[derive(std::fmt::Debug)]
    pub struct StartExportTask<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_export_task_input::Builder,
    }
    impl<C, M, R> StartExportTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartExportTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartExportTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::StartExportTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartExportTaskInputOperationOutputAlias,
                crate::output::StartExportTaskOutput,
                crate::error::StartExportTaskError,
                crate::input::StartExportTaskInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `exportDataFormat`.
        ///
        /// To override the contents of this collection use [`set_export_data_format`](Self::set_export_data_format).
        ///
        /// <p>The file format for the returned export data. Default value is <code>CSV</code>.
        /// <b>Note:</b>
        /// <i>The</i>
        /// <code>GRAPHML</code>
        /// <i>option has been deprecated.</i>
        /// </p>
        pub fn export_data_format(
            mut self,
            inp: impl Into<crate::model::ExportDataFormat>,
        ) -> Self {
            self.inner = self.inner.export_data_format(inp);
            self
        }
        /// <p>The file format for the returned export data. Default value is <code>CSV</code>.
        /// <b>Note:</b>
        /// <i>The</i>
        /// <code>GRAPHML</code>
        /// <i>option has been deprecated.</i>
        /// </p>
        pub fn set_export_data_format(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExportDataFormat>>,
        ) -> Self {
            self.inner = self.inner.set_export_data_format(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>If a filter is present, it selects the single <code>agentId</code> of the Application
        /// Discovery Agent for which data is exported. The <code>agentId</code> can be found in the
        /// results of the <code>DescribeAgents</code> API or CLI. If no filter is present,
        /// <code>startTime</code> and <code>endTime</code> are ignored and exported data includes both
        /// Agentless Discovery Connector data and summary data from Application Discovery agents.
        /// </p>
        pub fn filters(mut self, inp: impl Into<crate::model::ExportFilter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>If a filter is present, it selects the single <code>agentId</code> of the Application
        /// Discovery Agent for which data is exported. The <code>agentId</code> can be found in the
        /// results of the <code>DescribeAgents</code> API or CLI. If no filter is present,
        /// <code>startTime</code> and <code>endTime</code> are ignored and exported data includes both
        /// Agentless Discovery Connector data and summary data from Application Discovery agents.
        /// </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExportFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The start timestamp for exported data from the single Application Discovery Agent
        /// selected in the filters. If no value is specified, data is exported starting from the first
        /// data collected by the agent.</p>
        pub fn start_time(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.start_time(inp);
            self
        }
        /// <p>The start timestamp for exported data from the single Application Discovery Agent
        /// selected in the filters. If no value is specified, data is exported starting from the first
        /// data collected by the agent.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>The end timestamp for exported data from the single Application Discovery Agent
        /// selected in the filters. If no value is specified, exported data includes the most recent data
        /// collected by the agent.</p>
        pub fn end_time(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.end_time(inp);
            self
        }
        /// <p>The end timestamp for exported data from the single Application Discovery Agent
        /// selected in the filters. If no value is specified, exported data includes the most recent data
        /// collected by the agent.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartImportTask`.
    ///
    /// <p>Starts an import task, which allows you to import details of your on-premises environment
    /// directly into AWS Migration Hub without having to use the Application Discovery Service (ADS)
    /// tools such as the Discovery Connector or Discovery Agent. This gives you the option to perform
    /// migration assessment and planning directly from your imported data, including the ability to
    /// group your devices as applications and track their migration status.</p>
    ///
    /// <p>To start an import request, do this:</p>
    ///
    /// <ol>
    /// <li>
    /// <p>Download the specially formatted comma separated value (CSV) import template, which
    /// you can find here: <a href="https://s3-us-west-2.amazonaws.com/templates-7cffcf56-bd96-4b1c-b45b-a5b42f282e46/import_template.csv">https://s3-us-west-2.amazonaws.com/templates-7cffcf56-bd96-4b1c-b45b-a5b42f282e46/import_template.csv</a>.</p>
    /// </li>
    /// <li>
    /// <p>Fill out the template with your server and application data.</p>
    /// </li>
    /// <li>
    /// <p>Upload your import file to an Amazon S3 bucket, and make a note of it's Object URL.
    /// Your import file must be in the CSV format.</p>
    /// </li>
    /// <li>
    /// <p>Use the console or the <code>StartImportTask</code> command with the AWS CLI or one of
    /// the AWS SDKs to import the records from your file.</p>
    /// </li>
    /// </ol>
    ///
    /// <p>For more information, including step-by-step procedures, see <a href="https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-import.html">Migration Hub
    /// Import</a> in the <i>AWS Application Discovery Service User
    /// Guide</i>.</p>
    ///
    /// <note>
    /// <p>There are limits to the number of import tasks you can create (and delete) in an AWS
    /// account. For more information, see <a href="https://docs.aws.amazon.com/application-discovery/latest/userguide/ads_service_limits.html">AWS Application
    /// Discovery Service Limits</a> in the <i>AWS Application Discovery Service User
    /// Guide</i>.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct StartImportTask<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_import_task_input::Builder,
    }
    impl<C, M, R> StartImportTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartImportTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartImportTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::StartImportTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartImportTaskInputOperationOutputAlias,
                crate::output::StartImportTaskOutput,
                crate::error::StartImportTaskError,
                crate::input::StartImportTaskInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Optional. A unique token that you can provide to prevent the same import request from
        /// occurring more than once. If you don't provide a token, a token is automatically
        /// generated.</p>
        ///
        /// <p>Sending more than one <code>StartImportTask</code> request with the same client request
        /// token will return information about the original import task with that client request
        /// token.</p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>Optional. A unique token that you can provide to prevent the same import request from
        /// occurring more than once. If you don't provide a token, a token is automatically
        /// generated.</p>
        ///
        /// <p>Sending more than one <code>StartImportTask</code> request with the same client request
        /// token will return information about the original import task with that client request
        /// token.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>A descriptive name for this request. You can use this name to filter future requests
        /// related to this import task, such as identifying applications and servers that were included
        /// in this import task. We recommend that you use a meaningful name for each import task.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>A descriptive name for this request. You can use this name to filter future requests
        /// related to this import task, such as identifying applications and servers that were included
        /// in this import task. We recommend that you use a meaningful name for each import task.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The URL for your import file that you've uploaded to Amazon S3.</p>
        ///
        /// <note>
        /// <p>If you're using the AWS CLI, this URL is structured as follows:
        /// <code>s3://BucketName/ImportFileName.CSV</code>
        /// </p>
        /// </note>
        pub fn import_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.import_url(inp);
            self
        }
        /// <p>The URL for your import file that you've uploaded to Amazon S3.</p>
        ///
        /// <note>
        /// <p>If you're using the AWS CLI, this URL is structured as follows:
        /// <code>s3://BucketName/ImportFileName.CSV</code>
        /// </p>
        /// </note>
        pub fn set_import_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_import_url(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopContinuousExport`.
    ///
    /// <p>Stop the continuous flow of agent's discovered data into Amazon Athena.</p>
    #[derive(std::fmt::Debug)]
    pub struct StopContinuousExport<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_continuous_export_input::Builder,
    }
    impl<C, M, R> StopContinuousExport<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopContinuousExport`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopContinuousExportOutput,
            aws_smithy_http::result::SdkError<crate::error::StopContinuousExportError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopContinuousExportInputOperationOutputAlias,
                crate::output::StopContinuousExportOutput,
                crate::error::StopContinuousExportError,
                crate::input::StopContinuousExportInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID assigned to this export.</p>
        pub fn export_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.export_id(inp);
            self
        }
        /// <p>The unique ID assigned to this export.</p>
        pub fn set_export_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_export_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopDataCollectionByAgentIds`.
    ///
    /// <p>Instructs the specified agents or connectors to stop collecting data.</p>
    #[derive(std::fmt::Debug)]
    pub struct StopDataCollectionByAgentIds<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_data_collection_by_agent_ids_input::Builder,
    }
    impl<C, M, R> StopDataCollectionByAgentIds<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopDataCollectionByAgentIds`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopDataCollectionByAgentIdsOutput,
            aws_smithy_http::result::SdkError<crate::error::StopDataCollectionByAgentIdsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopDataCollectionByAgentIdsInputOperationOutputAlias,
                crate::output::StopDataCollectionByAgentIdsOutput,
                crate::error::StopDataCollectionByAgentIdsError,
                crate::input::StopDataCollectionByAgentIdsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `agentIds`.
        ///
        /// To override the contents of this collection use [`set_agent_ids`](Self::set_agent_ids).
        ///
        /// <p>The IDs of the agents or connectors from which to stop collecting data.</p>
        pub fn agent_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.agent_ids(inp);
            self
        }
        /// <p>The IDs of the agents or connectors from which to stop collecting data.</p>
        pub fn set_agent_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_agent_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateApplication`.
    ///
    /// <p>Updates metadata about an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateApplication<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_application_input::Builder,
    }
    impl<C, M, R> UpdateApplication<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateApplicationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateApplicationInputOperationOutputAlias,
                crate::output::UpdateApplicationOutput,
                crate::error::UpdateApplicationError,
                crate::input::UpdateApplicationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Configuration ID of the application to be updated.</p>
        pub fn configuration_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_id(inp);
            self
        }
        /// <p>Configuration ID of the application to be updated.</p>
        pub fn set_configuration_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_id(input);
            self
        }
        /// <p>New name of the application to be updated.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>New name of the application to be updated.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>New description of the application to be updated.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>New description of the application to be updated.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
