// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`DeleteReportDefinitionInput`](crate::input::DeleteReportDefinitionInput)
pub mod delete_report_definition_input {
    /// A builder for [`DeleteReportDefinitionInput`](crate::input::DeleteReportDefinitionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) report_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Required. ID of the report to delete.</p>
        pub fn report_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.report_id = Some(input.into());
            self
        }
        /// <p>Required. ID of the report to delete.</p>
        pub fn set_report_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.report_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteReportDefinitionInput`](crate::input::DeleteReportDefinitionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteReportDefinitionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteReportDefinitionInput {
                report_id: self.report_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteReportDefinitionInputOperationOutputAlias = crate::operation::DeleteReportDefinition;
#[doc(hidden)]
pub type DeleteReportDefinitionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteReportDefinitionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteReportDefinition`](crate::operation::DeleteReportDefinition)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteReportDefinition,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteReportDefinitionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.report_id;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "report_id",
                        details: "cannot be empty or unset",
                    })?;
            let report_id = aws_smithy_http::label::fmt_string(input_1, false);
            if report_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "report_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/reportDefinition/{reportId}", reportId = report_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteReportDefinitionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteReportDefinitionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteReportDefinition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteReportDefinition",
            "applicationcostprofiler",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteReportDefinitionInput`](crate::input::DeleteReportDefinitionInput)
    pub fn builder() -> crate::input::delete_report_definition_input::Builder {
        crate::input::delete_report_definition_input::Builder::default()
    }
}

/// See [`GetReportDefinitionInput`](crate::input::GetReportDefinitionInput)
pub mod get_report_definition_input {
    /// A builder for [`GetReportDefinitionInput`](crate::input::GetReportDefinitionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) report_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>ID of the report to retrieve.</p>
        pub fn report_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.report_id = Some(input.into());
            self
        }
        /// <p>ID of the report to retrieve.</p>
        pub fn set_report_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.report_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetReportDefinitionInput`](crate::input::GetReportDefinitionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetReportDefinitionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetReportDefinitionInput {
                report_id: self.report_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetReportDefinitionInputOperationOutputAlias = crate::operation::GetReportDefinition;
#[doc(hidden)]
pub type GetReportDefinitionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetReportDefinitionInput {
    /// Consumes the builder and constructs an Operation<[`GetReportDefinition`](crate::operation::GetReportDefinition)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetReportDefinition,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetReportDefinitionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_2 = &_input.report_id;
            let input_2 =
                input_2
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "report_id",
                        details: "cannot be empty or unset",
                    })?;
            let report_id = aws_smithy_http::label::fmt_string(input_2, false);
            if report_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "report_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/reportDefinition/{reportId}", reportId = report_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetReportDefinitionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetReportDefinitionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetReportDefinition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetReportDefinition",
            "applicationcostprofiler",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetReportDefinitionInput`](crate::input::GetReportDefinitionInput)
    pub fn builder() -> crate::input::get_report_definition_input::Builder {
        crate::input::get_report_definition_input::Builder::default()
    }
}

/// See [`ImportApplicationUsageInput`](crate::input::ImportApplicationUsageInput)
pub mod import_application_usage_input {
    /// A builder for [`ImportApplicationUsageInput`](crate::input::ImportApplicationUsageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_s3_location: std::option::Option<crate::model::SourceS3Location>,
    }
    impl Builder {
        /// <p>Amazon S3 location to import application usage data from.</p>
        pub fn source_s3_location(mut self, input: crate::model::SourceS3Location) -> Self {
            self.source_s3_location = Some(input);
            self
        }
        /// <p>Amazon S3 location to import application usage data from.</p>
        pub fn set_source_s3_location(
            mut self,
            input: std::option::Option<crate::model::SourceS3Location>,
        ) -> Self {
            self.source_s3_location = input;
            self
        }
        /// Consumes the builder and constructs a [`ImportApplicationUsageInput`](crate::input::ImportApplicationUsageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ImportApplicationUsageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ImportApplicationUsageInput {
                source_s3_location: self.source_s3_location,
            })
        }
    }
}
#[doc(hidden)]
pub type ImportApplicationUsageInputOperationOutputAlias = crate::operation::ImportApplicationUsage;
#[doc(hidden)]
pub type ImportApplicationUsageInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ImportApplicationUsageInput {
    /// Consumes the builder and constructs an Operation<[`ImportApplicationUsage`](crate::operation::ImportApplicationUsage)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ImportApplicationUsage,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ImportApplicationUsageInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/importApplicationUsage").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ImportApplicationUsageInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ImportApplicationUsageInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_import_application_usage(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ImportApplicationUsage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ImportApplicationUsage",
            "applicationcostprofiler",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ImportApplicationUsageInput`](crate::input::ImportApplicationUsageInput)
    pub fn builder() -> crate::input::import_application_usage_input::Builder {
        crate::input::import_application_usage_input::Builder::default()
    }
}

/// See [`ListReportDefinitionsInput`](crate::input::ListReportDefinitionsInput)
pub mod list_report_definitions_input {
    /// A builder for [`ListReportDefinitionsInput`](crate::input::ListReportDefinitionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The token value from a previous call to access the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token value from a previous call to access the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListReportDefinitionsInput`](crate::input::ListReportDefinitionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListReportDefinitionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListReportDefinitionsInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListReportDefinitionsInputOperationOutputAlias = crate::operation::ListReportDefinitions;
#[doc(hidden)]
pub type ListReportDefinitionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListReportDefinitionsInput {
    /// Consumes the builder and constructs an Operation<[`ListReportDefinitions`](crate::operation::ListReportDefinitions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListReportDefinitions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListReportDefinitionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/reportDefinition").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListReportDefinitionsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_3) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_3));
            }
            if let Some(inner_4) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_4).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListReportDefinitionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListReportDefinitionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListReportDefinitions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListReportDefinitions",
            "applicationcostprofiler",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListReportDefinitionsInput`](crate::input::ListReportDefinitionsInput)
    pub fn builder() -> crate::input::list_report_definitions_input::Builder {
        crate::input::list_report_definitions_input::Builder::default()
    }
}

/// See [`PutReportDefinitionInput`](crate::input::PutReportDefinitionInput)
pub mod put_report_definition_input {
    /// A builder for [`PutReportDefinitionInput`](crate::input::PutReportDefinitionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) report_id: std::option::Option<std::string::String>,
        pub(crate) report_description: std::option::Option<std::string::String>,
        pub(crate) report_frequency: std::option::Option<crate::model::ReportFrequency>,
        pub(crate) format: std::option::Option<crate::model::Format>,
        pub(crate) destination_s3_location: std::option::Option<crate::model::S3Location>,
    }
    impl Builder {
        /// <p>Required. ID of the report. You can choose any valid string matching the pattern for the ID.</p>
        pub fn report_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.report_id = Some(input.into());
            self
        }
        /// <p>Required. ID of the report. You can choose any valid string matching the pattern for the ID.</p>
        pub fn set_report_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.report_id = input;
            self
        }
        /// <p>Required. Description of the report.</p>
        pub fn report_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.report_description = Some(input.into());
            self
        }
        /// <p>Required. Description of the report.</p>
        pub fn set_report_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.report_description = input;
            self
        }
        /// <p>Required. The cadence to generate the report.</p>
        pub fn report_frequency(mut self, input: crate::model::ReportFrequency) -> Self {
            self.report_frequency = Some(input);
            self
        }
        /// <p>Required. The cadence to generate the report.</p>
        pub fn set_report_frequency(
            mut self,
            input: std::option::Option<crate::model::ReportFrequency>,
        ) -> Self {
            self.report_frequency = input;
            self
        }
        /// <p>Required. The format to use for the generated report.</p>
        pub fn format(mut self, input: crate::model::Format) -> Self {
            self.format = Some(input);
            self
        }
        /// <p>Required. The format to use for the generated report.</p>
        pub fn set_format(mut self, input: std::option::Option<crate::model::Format>) -> Self {
            self.format = input;
            self
        }
        /// <p>Required. Amazon Simple Storage Service (Amazon S3) location where Application Cost Profiler uploads the report.</p>
        pub fn destination_s3_location(mut self, input: crate::model::S3Location) -> Self {
            self.destination_s3_location = Some(input);
            self
        }
        /// <p>Required. Amazon Simple Storage Service (Amazon S3) location where Application Cost Profiler uploads the report.</p>
        pub fn set_destination_s3_location(
            mut self,
            input: std::option::Option<crate::model::S3Location>,
        ) -> Self {
            self.destination_s3_location = input;
            self
        }
        /// Consumes the builder and constructs a [`PutReportDefinitionInput`](crate::input::PutReportDefinitionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutReportDefinitionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutReportDefinitionInput {
                report_id: self.report_id,
                report_description: self.report_description,
                report_frequency: self.report_frequency,
                format: self.format,
                destination_s3_location: self.destination_s3_location,
            })
        }
    }
}
#[doc(hidden)]
pub type PutReportDefinitionInputOperationOutputAlias = crate::operation::PutReportDefinition;
#[doc(hidden)]
pub type PutReportDefinitionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutReportDefinitionInput {
    /// Consumes the builder and constructs an Operation<[`PutReportDefinition`](crate::operation::PutReportDefinition)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutReportDefinition,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutReportDefinitionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/reportDefinition").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutReportDefinitionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutReportDefinitionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_report_definition(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutReportDefinition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutReportDefinition",
            "applicationcostprofiler",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutReportDefinitionInput`](crate::input::PutReportDefinitionInput)
    pub fn builder() -> crate::input::put_report_definition_input::Builder {
        crate::input::put_report_definition_input::Builder::default()
    }
}

/// See [`UpdateReportDefinitionInput`](crate::input::UpdateReportDefinitionInput)
pub mod update_report_definition_input {
    /// A builder for [`UpdateReportDefinitionInput`](crate::input::UpdateReportDefinitionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) report_id: std::option::Option<std::string::String>,
        pub(crate) report_description: std::option::Option<std::string::String>,
        pub(crate) report_frequency: std::option::Option<crate::model::ReportFrequency>,
        pub(crate) format: std::option::Option<crate::model::Format>,
        pub(crate) destination_s3_location: std::option::Option<crate::model::S3Location>,
    }
    impl Builder {
        /// <p>Required. ID of the report to update.</p>
        pub fn report_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.report_id = Some(input.into());
            self
        }
        /// <p>Required. ID of the report to update.</p>
        pub fn set_report_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.report_id = input;
            self
        }
        /// <p>Required. Description of the report.</p>
        pub fn report_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.report_description = Some(input.into());
            self
        }
        /// <p>Required. Description of the report.</p>
        pub fn set_report_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.report_description = input;
            self
        }
        /// <p>Required. The cadence to generate the report.</p>
        pub fn report_frequency(mut self, input: crate::model::ReportFrequency) -> Self {
            self.report_frequency = Some(input);
            self
        }
        /// <p>Required. The cadence to generate the report.</p>
        pub fn set_report_frequency(
            mut self,
            input: std::option::Option<crate::model::ReportFrequency>,
        ) -> Self {
            self.report_frequency = input;
            self
        }
        /// <p>Required. The format to use for the generated report.</p>
        pub fn format(mut self, input: crate::model::Format) -> Self {
            self.format = Some(input);
            self
        }
        /// <p>Required. The format to use for the generated report.</p>
        pub fn set_format(mut self, input: std::option::Option<crate::model::Format>) -> Self {
            self.format = input;
            self
        }
        /// <p>Required. Amazon Simple Storage Service (Amazon S3) location where Application Cost Profiler uploads the report.</p>
        pub fn destination_s3_location(mut self, input: crate::model::S3Location) -> Self {
            self.destination_s3_location = Some(input);
            self
        }
        /// <p>Required. Amazon Simple Storage Service (Amazon S3) location where Application Cost Profiler uploads the report.</p>
        pub fn set_destination_s3_location(
            mut self,
            input: std::option::Option<crate::model::S3Location>,
        ) -> Self {
            self.destination_s3_location = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateReportDefinitionInput`](crate::input::UpdateReportDefinitionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateReportDefinitionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateReportDefinitionInput {
                report_id: self.report_id,
                report_description: self.report_description,
                report_frequency: self.report_frequency,
                format: self.format,
                destination_s3_location: self.destination_s3_location,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateReportDefinitionInputOperationOutputAlias = crate::operation::UpdateReportDefinition;
#[doc(hidden)]
pub type UpdateReportDefinitionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateReportDefinitionInput {
    /// Consumes the builder and constructs an Operation<[`UpdateReportDefinition`](crate::operation::UpdateReportDefinition)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateReportDefinition,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateReportDefinitionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_5 = &_input.report_id;
            let input_5 =
                input_5
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "report_id",
                        details: "cannot be empty or unset",
                    })?;
            let report_id = aws_smithy_http::label::fmt_string(input_5, false);
            if report_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "report_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/reportDefinition/{reportId}", reportId = report_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateReportDefinitionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateReportDefinitionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_report_definition(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateReportDefinition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateReportDefinition",
            "applicationcostprofiler",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateReportDefinitionInput`](crate::input::UpdateReportDefinitionInput)
    pub fn builder() -> crate::input::update_report_definition_input::Builder {
        crate::input::update_report_definition_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateReportDefinitionInput {
    /// <p>Required. ID of the report to update.</p>
    pub report_id: std::option::Option<std::string::String>,
    /// <p>Required. Description of the report.</p>
    pub report_description: std::option::Option<std::string::String>,
    /// <p>Required. The cadence to generate the report.</p>
    pub report_frequency: std::option::Option<crate::model::ReportFrequency>,
    /// <p>Required. The format to use for the generated report.</p>
    pub format: std::option::Option<crate::model::Format>,
    /// <p>Required. Amazon Simple Storage Service (Amazon S3) location where Application Cost Profiler uploads the report.</p>
    pub destination_s3_location: std::option::Option<crate::model::S3Location>,
}
impl UpdateReportDefinitionInput {
    /// <p>Required. ID of the report to update.</p>
    pub fn report_id(&self) -> std::option::Option<&str> {
        self.report_id.as_deref()
    }
    /// <p>Required. Description of the report.</p>
    pub fn report_description(&self) -> std::option::Option<&str> {
        self.report_description.as_deref()
    }
    /// <p>Required. The cadence to generate the report.</p>
    pub fn report_frequency(&self) -> std::option::Option<&crate::model::ReportFrequency> {
        self.report_frequency.as_ref()
    }
    /// <p>Required. The format to use for the generated report.</p>
    pub fn format(&self) -> std::option::Option<&crate::model::Format> {
        self.format.as_ref()
    }
    /// <p>Required. Amazon Simple Storage Service (Amazon S3) location where Application Cost Profiler uploads the report.</p>
    pub fn destination_s3_location(&self) -> std::option::Option<&crate::model::S3Location> {
        self.destination_s3_location.as_ref()
    }
}
impl std::fmt::Debug for UpdateReportDefinitionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateReportDefinitionInput");
        formatter.field("report_id", &self.report_id);
        formatter.field("report_description", &self.report_description);
        formatter.field("report_frequency", &self.report_frequency);
        formatter.field("format", &self.format);
        formatter.field("destination_s3_location", &self.destination_s3_location);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutReportDefinitionInput {
    /// <p>Required. ID of the report. You can choose any valid string matching the pattern for the ID.</p>
    pub report_id: std::option::Option<std::string::String>,
    /// <p>Required. Description of the report.</p>
    pub report_description: std::option::Option<std::string::String>,
    /// <p>Required. The cadence to generate the report.</p>
    pub report_frequency: std::option::Option<crate::model::ReportFrequency>,
    /// <p>Required. The format to use for the generated report.</p>
    pub format: std::option::Option<crate::model::Format>,
    /// <p>Required. Amazon Simple Storage Service (Amazon S3) location where Application Cost Profiler uploads the report.</p>
    pub destination_s3_location: std::option::Option<crate::model::S3Location>,
}
impl PutReportDefinitionInput {
    /// <p>Required. ID of the report. You can choose any valid string matching the pattern for the ID.</p>
    pub fn report_id(&self) -> std::option::Option<&str> {
        self.report_id.as_deref()
    }
    /// <p>Required. Description of the report.</p>
    pub fn report_description(&self) -> std::option::Option<&str> {
        self.report_description.as_deref()
    }
    /// <p>Required. The cadence to generate the report.</p>
    pub fn report_frequency(&self) -> std::option::Option<&crate::model::ReportFrequency> {
        self.report_frequency.as_ref()
    }
    /// <p>Required. The format to use for the generated report.</p>
    pub fn format(&self) -> std::option::Option<&crate::model::Format> {
        self.format.as_ref()
    }
    /// <p>Required. Amazon Simple Storage Service (Amazon S3) location where Application Cost Profiler uploads the report.</p>
    pub fn destination_s3_location(&self) -> std::option::Option<&crate::model::S3Location> {
        self.destination_s3_location.as_ref()
    }
}
impl std::fmt::Debug for PutReportDefinitionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutReportDefinitionInput");
        formatter.field("report_id", &self.report_id);
        formatter.field("report_description", &self.report_description);
        formatter.field("report_frequency", &self.report_frequency);
        formatter.field("format", &self.format);
        formatter.field("destination_s3_location", &self.destination_s3_location);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListReportDefinitionsInput {
    /// <p>The token value from a previous call to access the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListReportDefinitionsInput {
    /// <p>The token value from a previous call to access the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListReportDefinitionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListReportDefinitionsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImportApplicationUsageInput {
    /// <p>Amazon S3 location to import application usage data from.</p>
    pub source_s3_location: std::option::Option<crate::model::SourceS3Location>,
}
impl ImportApplicationUsageInput {
    /// <p>Amazon S3 location to import application usage data from.</p>
    pub fn source_s3_location(&self) -> std::option::Option<&crate::model::SourceS3Location> {
        self.source_s3_location.as_ref()
    }
}
impl std::fmt::Debug for ImportApplicationUsageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImportApplicationUsageInput");
        formatter.field("source_s3_location", &self.source_s3_location);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetReportDefinitionInput {
    /// <p>ID of the report to retrieve.</p>
    pub report_id: std::option::Option<std::string::String>,
}
impl GetReportDefinitionInput {
    /// <p>ID of the report to retrieve.</p>
    pub fn report_id(&self) -> std::option::Option<&str> {
        self.report_id.as_deref()
    }
}
impl std::fmt::Debug for GetReportDefinitionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetReportDefinitionInput");
        formatter.field("report_id", &self.report_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteReportDefinitionInput {
    /// <p>Required. ID of the report to delete.</p>
    pub report_id: std::option::Option<std::string::String>,
}
impl DeleteReportDefinitionInput {
    /// <p>Required. ID of the report to delete.</p>
    pub fn report_id(&self) -> std::option::Option<&str> {
        self.report_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteReportDefinitionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteReportDefinitionInput");
        formatter.field("report_id", &self.report_id);
        formatter.finish()
    }
}
