// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for AWS Application Cost Profiler
///
/// Client for invoking operations on AWS Application Cost Profiler. Each operation on AWS Application Cost Profiler is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_applicationcostprofiler::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_applicationcostprofiler::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_applicationcostprofiler::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the [`DeleteReportDefinition`](crate::client::fluent_builders::DeleteReportDefinition) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`report_id(impl Into<String>)`](crate::client::fluent_builders::DeleteReportDefinition::report_id) / [`set_report_id(Option<String>)`](crate::client::fluent_builders::DeleteReportDefinition::set_report_id): <p>Required. ID of the report to delete.</p>
    /// - On success, responds with [`DeleteReportDefinitionOutput`](crate::output::DeleteReportDefinitionOutput) with field(s):
    ///   - [`report_id(Option<String>)`](crate::output::DeleteReportDefinitionOutput::report_id): <p>ID of the report that was deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteReportDefinitionError>`](crate::error::DeleteReportDefinitionError)
    pub fn delete_report_definition(&self) -> fluent_builders::DeleteReportDefinition<C, M, R> {
        fluent_builders::DeleteReportDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetReportDefinition`](crate::client::fluent_builders::GetReportDefinition) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`report_id(impl Into<String>)`](crate::client::fluent_builders::GetReportDefinition::report_id) / [`set_report_id(Option<String>)`](crate::client::fluent_builders::GetReportDefinition::set_report_id): <p>ID of the report to retrieve.</p>
    /// - On success, responds with [`GetReportDefinitionOutput`](crate::output::GetReportDefinitionOutput) with field(s):
    ///   - [`report_id(Option<String>)`](crate::output::GetReportDefinitionOutput::report_id): <p>ID of the report retrieved.</p>
    ///   - [`report_description(Option<String>)`](crate::output::GetReportDefinitionOutput::report_description): <p>Description of the report.</p>
    ///   - [`report_frequency(Option<ReportFrequency>)`](crate::output::GetReportDefinitionOutput::report_frequency): <p>Cadence used to generate the report.</p>
    ///   - [`format(Option<Format>)`](crate::output::GetReportDefinitionOutput::format): <p>Format of the generated report.</p>
    ///   - [`destination_s3_location(Option<S3Location>)`](crate::output::GetReportDefinitionOutput::destination_s3_location): <p>Amazon Simple Storage Service (Amazon S3) location where the report is uploaded.</p>
    ///   - [`created_at(Option<DateTime>)`](crate::output::GetReportDefinitionOutput::created_at): <p>Timestamp (milliseconds) when this report definition was created.</p>
    ///   - [`last_updated(Option<DateTime>)`](crate::output::GetReportDefinitionOutput::last_updated): <p>Timestamp (milliseconds) when this report definition was last updated.</p>
    /// - On failure, responds with [`SdkError<GetReportDefinitionError>`](crate::error::GetReportDefinitionError)
    pub fn get_report_definition(&self) -> fluent_builders::GetReportDefinition<C, M, R> {
        fluent_builders::GetReportDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ImportApplicationUsage`](crate::client::fluent_builders::ImportApplicationUsage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`source_s3_location(SourceS3Location)`](crate::client::fluent_builders::ImportApplicationUsage::source_s3_location) / [`set_source_s3_location(Option<SourceS3Location>)`](crate::client::fluent_builders::ImportApplicationUsage::set_source_s3_location): <p>Amazon S3 location to import application usage data from.</p>
    /// - On success, responds with [`ImportApplicationUsageOutput`](crate::output::ImportApplicationUsageOutput) with field(s):
    ///   - [`import_id(Option<String>)`](crate::output::ImportApplicationUsageOutput::import_id): <p>ID of the import request.</p>
    /// - On failure, responds with [`SdkError<ImportApplicationUsageError>`](crate::error::ImportApplicationUsageError)
    pub fn import_application_usage(&self) -> fluent_builders::ImportApplicationUsage<C, M, R> {
        fluent_builders::ImportApplicationUsage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListReportDefinitions`](crate::client::fluent_builders::ListReportDefinitions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListReportDefinitions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListReportDefinitions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListReportDefinitions::set_next_token): <p>The token value from a previous call to access the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListReportDefinitions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListReportDefinitions::set_max_results): <p>The maximum number of results to return.</p>
    /// - On success, responds with [`ListReportDefinitionsOutput`](crate::output::ListReportDefinitionsOutput) with field(s):
    ///   - [`report_definitions(Option<Vec<ReportDefinition>>)`](crate::output::ListReportDefinitionsOutput::report_definitions): <p>The retrieved reports.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListReportDefinitionsOutput::next_token): <p>The value of the next token, if it exists. Null if there are no more results.</p>
    /// - On failure, responds with [`SdkError<ListReportDefinitionsError>`](crate::error::ListReportDefinitionsError)
    pub fn list_report_definitions(&self) -> fluent_builders::ListReportDefinitions<C, M, R> {
        fluent_builders::ListReportDefinitions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutReportDefinition`](crate::client::fluent_builders::PutReportDefinition) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`report_id(impl Into<String>)`](crate::client::fluent_builders::PutReportDefinition::report_id) / [`set_report_id(Option<String>)`](crate::client::fluent_builders::PutReportDefinition::set_report_id): <p>Required. ID of the report. You can choose any valid string matching the pattern for the ID.</p>
    ///   - [`report_description(impl Into<String>)`](crate::client::fluent_builders::PutReportDefinition::report_description) / [`set_report_description(Option<String>)`](crate::client::fluent_builders::PutReportDefinition::set_report_description): <p>Required. Description of the report.</p>
    ///   - [`report_frequency(ReportFrequency)`](crate::client::fluent_builders::PutReportDefinition::report_frequency) / [`set_report_frequency(Option<ReportFrequency>)`](crate::client::fluent_builders::PutReportDefinition::set_report_frequency): <p>Required. The cadence to generate the report.</p>
    ///   - [`format(Format)`](crate::client::fluent_builders::PutReportDefinition::format) / [`set_format(Option<Format>)`](crate::client::fluent_builders::PutReportDefinition::set_format): <p>Required. The format to use for the generated report.</p>
    ///   - [`destination_s3_location(S3Location)`](crate::client::fluent_builders::PutReportDefinition::destination_s3_location) / [`set_destination_s3_location(Option<S3Location>)`](crate::client::fluent_builders::PutReportDefinition::set_destination_s3_location): <p>Required. Amazon Simple Storage Service (Amazon S3) location where Application Cost Profiler uploads the report.</p>
    /// - On success, responds with [`PutReportDefinitionOutput`](crate::output::PutReportDefinitionOutput) with field(s):
    ///   - [`report_id(Option<String>)`](crate::output::PutReportDefinitionOutput::report_id): <p>ID of the report.</p>
    /// - On failure, responds with [`SdkError<PutReportDefinitionError>`](crate::error::PutReportDefinitionError)
    pub fn put_report_definition(&self) -> fluent_builders::PutReportDefinition<C, M, R> {
        fluent_builders::PutReportDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateReportDefinition`](crate::client::fluent_builders::UpdateReportDefinition) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`report_id(impl Into<String>)`](crate::client::fluent_builders::UpdateReportDefinition::report_id) / [`set_report_id(Option<String>)`](crate::client::fluent_builders::UpdateReportDefinition::set_report_id): <p>Required. ID of the report to update.</p>
    ///   - [`report_description(impl Into<String>)`](crate::client::fluent_builders::UpdateReportDefinition::report_description) / [`set_report_description(Option<String>)`](crate::client::fluent_builders::UpdateReportDefinition::set_report_description): <p>Required. Description of the report.</p>
    ///   - [`report_frequency(ReportFrequency)`](crate::client::fluent_builders::UpdateReportDefinition::report_frequency) / [`set_report_frequency(Option<ReportFrequency>)`](crate::client::fluent_builders::UpdateReportDefinition::set_report_frequency): <p>Required. The cadence to generate the report.</p>
    ///   - [`format(Format)`](crate::client::fluent_builders::UpdateReportDefinition::format) / [`set_format(Option<Format>)`](crate::client::fluent_builders::UpdateReportDefinition::set_format): <p>Required. The format to use for the generated report.</p>
    ///   - [`destination_s3_location(S3Location)`](crate::client::fluent_builders::UpdateReportDefinition::destination_s3_location) / [`set_destination_s3_location(Option<S3Location>)`](crate::client::fluent_builders::UpdateReportDefinition::set_destination_s3_location): <p>Required. Amazon Simple Storage Service (Amazon S3) location where Application Cost Profiler uploads the report.</p>
    /// - On success, responds with [`UpdateReportDefinitionOutput`](crate::output::UpdateReportDefinitionOutput) with field(s):
    ///   - [`report_id(Option<String>)`](crate::output::UpdateReportDefinitionOutput::report_id): <p>ID of the report.</p>
    /// - On failure, responds with [`SdkError<UpdateReportDefinitionError>`](crate::error::UpdateReportDefinitionError)
    pub fn update_report_definition(&self) -> fluent_builders::UpdateReportDefinition<C, M, R> {
        fluent_builders::UpdateReportDefinition::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `DeleteReportDefinition`.
    ///
    /// <p>Deletes the specified report definition in AWS Application Cost Profiler. This stops the report from being generated.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteReportDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_report_definition_input::Builder,
    }
    impl<C, M, R> DeleteReportDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteReportDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteReportDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteReportDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteReportDefinitionInputOperationOutputAlias,
                crate::output::DeleteReportDefinitionOutput,
                crate::error::DeleteReportDefinitionError,
                crate::input::DeleteReportDefinitionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Required. ID of the report to delete.</p>
        pub fn report_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.report_id(input.into());
            self
        }
        /// <p>Required. ID of the report to delete.</p>
        pub fn set_report_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_report_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetReportDefinition`.
    ///
    /// <p>Retrieves the definition of a report already configured in AWS Application Cost Profiler.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetReportDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_report_definition_input::Builder,
    }
    impl<C, M, R> GetReportDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetReportDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetReportDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetReportDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetReportDefinitionInputOperationOutputAlias,
                crate::output::GetReportDefinitionOutput,
                crate::error::GetReportDefinitionError,
                crate::input::GetReportDefinitionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>ID of the report to retrieve.</p>
        pub fn report_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.report_id(input.into());
            self
        }
        /// <p>ID of the report to retrieve.</p>
        pub fn set_report_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_report_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ImportApplicationUsage`.
    ///
    /// <p>Ingests application usage data from Amazon Simple Storage Service (Amazon S3).</p>
    /// <p>The data must already exist in the S3 location. As part of the action, AWS Application Cost Profiler copies the object from your S3 bucket to an S3 bucket owned by Amazon for processing asynchronously.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ImportApplicationUsage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::import_application_usage_input::Builder,
    }
    impl<C, M, R> ImportApplicationUsage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ImportApplicationUsage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ImportApplicationUsageOutput,
            aws_smithy_http::result::SdkError<crate::error::ImportApplicationUsageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ImportApplicationUsageInputOperationOutputAlias,
                crate::output::ImportApplicationUsageOutput,
                crate::error::ImportApplicationUsageError,
                crate::input::ImportApplicationUsageInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon S3 location to import application usage data from.</p>
        pub fn source_s3_location(mut self, input: crate::model::SourceS3Location) -> Self {
            self.inner = self.inner.source_s3_location(input);
            self
        }
        /// <p>Amazon S3 location to import application usage data from.</p>
        pub fn set_source_s3_location(
            mut self,
            input: std::option::Option<crate::model::SourceS3Location>,
        ) -> Self {
            self.inner = self.inner.set_source_s3_location(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListReportDefinitions`.
    ///
    /// <p>Retrieves a list of all reports and their configurations for your AWS account.</p>
    /// <p>The maximum number of reports is one.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListReportDefinitions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_report_definitions_input::Builder,
    }
    impl<C, M, R> ListReportDefinitions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListReportDefinitions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListReportDefinitionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListReportDefinitionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListReportDefinitionsInputOperationOutputAlias,
                crate::output::ListReportDefinitionsOutput,
                crate::error::ListReportDefinitionsError,
                crate::input::ListReportDefinitionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListReportDefinitionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListReportDefinitionsPaginator<C, M, R> {
            crate::paginator::ListReportDefinitionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The token value from a previous call to access the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token value from a previous call to access the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutReportDefinition`.
    ///
    /// <p>Creates the report definition for a report in Application Cost Profiler.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutReportDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_report_definition_input::Builder,
    }
    impl<C, M, R> PutReportDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutReportDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutReportDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::PutReportDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutReportDefinitionInputOperationOutputAlias,
                crate::output::PutReportDefinitionOutput,
                crate::error::PutReportDefinitionError,
                crate::input::PutReportDefinitionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Required. ID of the report. You can choose any valid string matching the pattern for the ID.</p>
        pub fn report_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.report_id(input.into());
            self
        }
        /// <p>Required. ID of the report. You can choose any valid string matching the pattern for the ID.</p>
        pub fn set_report_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_report_id(input);
            self
        }
        /// <p>Required. Description of the report.</p>
        pub fn report_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.report_description(input.into());
            self
        }
        /// <p>Required. Description of the report.</p>
        pub fn set_report_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_report_description(input);
            self
        }
        /// <p>Required. The cadence to generate the report.</p>
        pub fn report_frequency(mut self, input: crate::model::ReportFrequency) -> Self {
            self.inner = self.inner.report_frequency(input);
            self
        }
        /// <p>Required. The cadence to generate the report.</p>
        pub fn set_report_frequency(
            mut self,
            input: std::option::Option<crate::model::ReportFrequency>,
        ) -> Self {
            self.inner = self.inner.set_report_frequency(input);
            self
        }
        /// <p>Required. The format to use for the generated report.</p>
        pub fn format(mut self, input: crate::model::Format) -> Self {
            self.inner = self.inner.format(input);
            self
        }
        /// <p>Required. The format to use for the generated report.</p>
        pub fn set_format(mut self, input: std::option::Option<crate::model::Format>) -> Self {
            self.inner = self.inner.set_format(input);
            self
        }
        /// <p>Required. Amazon Simple Storage Service (Amazon S3) location where Application Cost Profiler uploads the report.</p>
        pub fn destination_s3_location(mut self, input: crate::model::S3Location) -> Self {
            self.inner = self.inner.destination_s3_location(input);
            self
        }
        /// <p>Required. Amazon Simple Storage Service (Amazon S3) location where Application Cost Profiler uploads the report.</p>
        pub fn set_destination_s3_location(
            mut self,
            input: std::option::Option<crate::model::S3Location>,
        ) -> Self {
            self.inner = self.inner.set_destination_s3_location(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateReportDefinition`.
    ///
    /// <p>Updates existing report in AWS Application Cost Profiler.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateReportDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_report_definition_input::Builder,
    }
    impl<C, M, R> UpdateReportDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateReportDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateReportDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateReportDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateReportDefinitionInputOperationOutputAlias,
                crate::output::UpdateReportDefinitionOutput,
                crate::error::UpdateReportDefinitionError,
                crate::input::UpdateReportDefinitionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Required. ID of the report to update.</p>
        pub fn report_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.report_id(input.into());
            self
        }
        /// <p>Required. ID of the report to update.</p>
        pub fn set_report_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_report_id(input);
            self
        }
        /// <p>Required. Description of the report.</p>
        pub fn report_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.report_description(input.into());
            self
        }
        /// <p>Required. Description of the report.</p>
        pub fn set_report_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_report_description(input);
            self
        }
        /// <p>Required. The cadence to generate the report.</p>
        pub fn report_frequency(mut self, input: crate::model::ReportFrequency) -> Self {
            self.inner = self.inner.report_frequency(input);
            self
        }
        /// <p>Required. The cadence to generate the report.</p>
        pub fn set_report_frequency(
            mut self,
            input: std::option::Option<crate::model::ReportFrequency>,
        ) -> Self {
            self.inner = self.inner.set_report_frequency(input);
            self
        }
        /// <p>Required. The format to use for the generated report.</p>
        pub fn format(mut self, input: crate::model::Format) -> Self {
            self.inner = self.inner.format(input);
            self
        }
        /// <p>Required. The format to use for the generated report.</p>
        pub fn set_format(mut self, input: std::option::Option<crate::model::Format>) -> Self {
            self.inner = self.inner.set_format(input);
            self
        }
        /// <p>Required. Amazon Simple Storage Service (Amazon S3) location where Application Cost Profiler uploads the report.</p>
        pub fn destination_s3_location(mut self, input: crate::model::S3Location) -> Self {
            self.inner = self.inner.destination_s3_location(input);
            self
        }
        /// <p>Required. Amazon Simple Storage Service (Amazon S3) location where Application Cost Profiler uploads the report.</p>
        pub fn set_destination_s3_location(
            mut self,
            input: std::option::Option<crate::model::S3Location>,
        ) -> Self {
            self.inner = self.inner.set_destination_s3_location(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
