// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Specifies whether the scaling activities for a scalable target are in a suspended state. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SuspendedState {
    /// <p>Whether scale in by a target tracking scaling policy or a step scaling policy is suspended. Set the value to <code>true</code> if you don't want Application Auto Scaling to remove capacity when a scaling policy is triggered. The default is <code>false</code>. </p>
    pub dynamic_scaling_in_suspended: std::option::Option<bool>,
    /// <p>Whether scale out by a target tracking scaling policy or a step scaling policy is suspended. Set the value to <code>true</code> if you don't want Application Auto Scaling to add capacity when a scaling policy is triggered. The default is <code>false</code>. </p>
    pub dynamic_scaling_out_suspended: std::option::Option<bool>,
    /// <p>Whether scheduled scaling is suspended. Set the value to <code>true</code> if you don't want Application Auto Scaling to add or remove capacity by initiating scheduled actions. The default is <code>false</code>. </p>
    pub scheduled_scaling_suspended: std::option::Option<bool>,
}
impl SuspendedState {
    /// <p>Whether scale in by a target tracking scaling policy or a step scaling policy is suspended. Set the value to <code>true</code> if you don't want Application Auto Scaling to remove capacity when a scaling policy is triggered. The default is <code>false</code>. </p>
    pub fn dynamic_scaling_in_suspended(&self) -> std::option::Option<bool> {
        self.dynamic_scaling_in_suspended
    }
    /// <p>Whether scale out by a target tracking scaling policy or a step scaling policy is suspended. Set the value to <code>true</code> if you don't want Application Auto Scaling to add capacity when a scaling policy is triggered. The default is <code>false</code>. </p>
    pub fn dynamic_scaling_out_suspended(&self) -> std::option::Option<bool> {
        self.dynamic_scaling_out_suspended
    }
    /// <p>Whether scheduled scaling is suspended. Set the value to <code>true</code> if you don't want Application Auto Scaling to add or remove capacity by initiating scheduled actions. The default is <code>false</code>. </p>
    pub fn scheduled_scaling_suspended(&self) -> std::option::Option<bool> {
        self.scheduled_scaling_suspended
    }
}
impl std::fmt::Debug for SuspendedState {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SuspendedState");
        formatter.field(
            "dynamic_scaling_in_suspended",
            &self.dynamic_scaling_in_suspended,
        );
        formatter.field(
            "dynamic_scaling_out_suspended",
            &self.dynamic_scaling_out_suspended,
        );
        formatter.field(
            "scheduled_scaling_suspended",
            &self.scheduled_scaling_suspended,
        );
        formatter.finish()
    }
}
/// See [`SuspendedState`](crate::model::SuspendedState)
pub mod suspended_state {
    /// A builder for [`SuspendedState`](crate::model::SuspendedState)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dynamic_scaling_in_suspended: std::option::Option<bool>,
        pub(crate) dynamic_scaling_out_suspended: std::option::Option<bool>,
        pub(crate) scheduled_scaling_suspended: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Whether scale in by a target tracking scaling policy or a step scaling policy is suspended. Set the value to <code>true</code> if you don't want Application Auto Scaling to remove capacity when a scaling policy is triggered. The default is <code>false</code>. </p>
        pub fn dynamic_scaling_in_suspended(mut self, input: bool) -> Self {
            self.dynamic_scaling_in_suspended = Some(input);
            self
        }
        /// <p>Whether scale in by a target tracking scaling policy or a step scaling policy is suspended. Set the value to <code>true</code> if you don't want Application Auto Scaling to remove capacity when a scaling policy is triggered. The default is <code>false</code>. </p>
        pub fn set_dynamic_scaling_in_suspended(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.dynamic_scaling_in_suspended = input;
            self
        }
        /// <p>Whether scale out by a target tracking scaling policy or a step scaling policy is suspended. Set the value to <code>true</code> if you don't want Application Auto Scaling to add capacity when a scaling policy is triggered. The default is <code>false</code>. </p>
        pub fn dynamic_scaling_out_suspended(mut self, input: bool) -> Self {
            self.dynamic_scaling_out_suspended = Some(input);
            self
        }
        /// <p>Whether scale out by a target tracking scaling policy or a step scaling policy is suspended. Set the value to <code>true</code> if you don't want Application Auto Scaling to add capacity when a scaling policy is triggered. The default is <code>false</code>. </p>
        pub fn set_dynamic_scaling_out_suspended(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.dynamic_scaling_out_suspended = input;
            self
        }
        /// <p>Whether scheduled scaling is suspended. Set the value to <code>true</code> if you don't want Application Auto Scaling to add or remove capacity by initiating scheduled actions. The default is <code>false</code>. </p>
        pub fn scheduled_scaling_suspended(mut self, input: bool) -> Self {
            self.scheduled_scaling_suspended = Some(input);
            self
        }
        /// <p>Whether scheduled scaling is suspended. Set the value to <code>true</code> if you don't want Application Auto Scaling to add or remove capacity by initiating scheduled actions. The default is <code>false</code>. </p>
        pub fn set_scheduled_scaling_suspended(mut self, input: std::option::Option<bool>) -> Self {
            self.scheduled_scaling_suspended = input;
            self
        }
        /// Consumes the builder and constructs a [`SuspendedState`](crate::model::SuspendedState)
        pub fn build(self) -> crate::model::SuspendedState {
            crate::model::SuspendedState {
                dynamic_scaling_in_suspended: self.dynamic_scaling_in_suspended,
                dynamic_scaling_out_suspended: self.dynamic_scaling_out_suspended,
                scheduled_scaling_suspended: self.scheduled_scaling_suspended,
            }
        }
    }
}
impl SuspendedState {
    /// Creates a new builder-style object to manufacture [`SuspendedState`](crate::model::SuspendedState)
    pub fn builder() -> crate::model::suspended_state::Builder {
        crate::model::suspended_state::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ScalableDimension {
    #[allow(missing_docs)] // documentation missing in model
    AppstreamFleetDesiredCapacity,
    #[allow(missing_docs)] // documentation missing in model
    CassandraTableReadCapacityUnits,
    #[allow(missing_docs)] // documentation missing in model
    CassandraTableWriteCapacityUnits,
    #[allow(missing_docs)] // documentation missing in model
    ComprehendDocClassifierEndpointInferenceUnits,
    #[allow(missing_docs)] // documentation missing in model
    ComprehendEntityRecognizerEndpointInferenceUnits,
    #[allow(missing_docs)] // documentation missing in model
    CustomResourceScalableDimension,
    #[allow(missing_docs)] // documentation missing in model
    DynamoDbIndexReadCapacityUnits,
    #[allow(missing_docs)] // documentation missing in model
    DynamoDbIndexWriteCapacityUnits,
    #[allow(missing_docs)] // documentation missing in model
    DynamoDbTableReadCapacityUnits,
    #[allow(missing_docs)] // documentation missing in model
    DynamoDbTableWriteCapacityUnits,
    #[allow(missing_docs)] // documentation missing in model
    Ec2SpotFleetRequestTargetCapacity,
    #[allow(missing_docs)] // documentation missing in model
    EcsServiceDesiredCount,
    #[allow(missing_docs)] // documentation missing in model
    ElastiCacheReplicationGroupNodeGroups,
    #[allow(missing_docs)] // documentation missing in model
    ElastiCacheReplicationGroupReplicas,
    #[allow(missing_docs)] // documentation missing in model
    EmrInstanceGroupInstanceCount,
    #[allow(missing_docs)] // documentation missing in model
    KafkaBrokerStorageVolumeSize,
    #[allow(missing_docs)] // documentation missing in model
    LambdaFunctionProvisionedConcurrency,
    #[allow(missing_docs)] // documentation missing in model
    NeptuneClusterReadReplicaCount,
    #[allow(missing_docs)] // documentation missing in model
    RdsClusterReadReplicaCount,
    #[allow(missing_docs)] // documentation missing in model
    SageMakerVariantDesiredInstanceCount,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ScalableDimension {
    fn from(s: &str) -> Self {
        match s {
            "appstream:fleet:DesiredCapacity" => ScalableDimension::AppstreamFleetDesiredCapacity,
            "cassandra:table:ReadCapacityUnits" => {
                ScalableDimension::CassandraTableReadCapacityUnits
            }
            "cassandra:table:WriteCapacityUnits" => {
                ScalableDimension::CassandraTableWriteCapacityUnits
            }
            "comprehend:document-classifier-endpoint:DesiredInferenceUnits" => {
                ScalableDimension::ComprehendDocClassifierEndpointInferenceUnits
            }
            "comprehend:entity-recognizer-endpoint:DesiredInferenceUnits" => {
                ScalableDimension::ComprehendEntityRecognizerEndpointInferenceUnits
            }
            "custom-resource:ResourceType:Property" => {
                ScalableDimension::CustomResourceScalableDimension
            }
            "dynamodb:index:ReadCapacityUnits" => ScalableDimension::DynamoDbIndexReadCapacityUnits,
            "dynamodb:index:WriteCapacityUnits" => {
                ScalableDimension::DynamoDbIndexWriteCapacityUnits
            }
            "dynamodb:table:ReadCapacityUnits" => ScalableDimension::DynamoDbTableReadCapacityUnits,
            "dynamodb:table:WriteCapacityUnits" => {
                ScalableDimension::DynamoDbTableWriteCapacityUnits
            }
            "ec2:spot-fleet-request:TargetCapacity" => {
                ScalableDimension::Ec2SpotFleetRequestTargetCapacity
            }
            "ecs:service:DesiredCount" => ScalableDimension::EcsServiceDesiredCount,
            "elasticache:replication-group:NodeGroups" => {
                ScalableDimension::ElastiCacheReplicationGroupNodeGroups
            }
            "elasticache:replication-group:Replicas" => {
                ScalableDimension::ElastiCacheReplicationGroupReplicas
            }
            "elasticmapreduce:instancegroup:InstanceCount" => {
                ScalableDimension::EmrInstanceGroupInstanceCount
            }
            "kafka:broker-storage:VolumeSize" => ScalableDimension::KafkaBrokerStorageVolumeSize,
            "lambda:function:ProvisionedConcurrency" => {
                ScalableDimension::LambdaFunctionProvisionedConcurrency
            }
            "neptune:cluster:ReadReplicaCount" => ScalableDimension::NeptuneClusterReadReplicaCount,
            "rds:cluster:ReadReplicaCount" => ScalableDimension::RdsClusterReadReplicaCount,
            "sagemaker:variant:DesiredInstanceCount" => {
                ScalableDimension::SageMakerVariantDesiredInstanceCount
            }
            other => ScalableDimension::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ScalableDimension {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ScalableDimension::from(s))
    }
}
impl ScalableDimension {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ScalableDimension::AppstreamFleetDesiredCapacity => "appstream:fleet:DesiredCapacity",
            ScalableDimension::CassandraTableReadCapacityUnits => {
                "cassandra:table:ReadCapacityUnits"
            }
            ScalableDimension::CassandraTableWriteCapacityUnits => {
                "cassandra:table:WriteCapacityUnits"
            }
            ScalableDimension::ComprehendDocClassifierEndpointInferenceUnits => {
                "comprehend:document-classifier-endpoint:DesiredInferenceUnits"
            }
            ScalableDimension::ComprehendEntityRecognizerEndpointInferenceUnits => {
                "comprehend:entity-recognizer-endpoint:DesiredInferenceUnits"
            }
            ScalableDimension::CustomResourceScalableDimension => {
                "custom-resource:ResourceType:Property"
            }
            ScalableDimension::DynamoDbIndexReadCapacityUnits => "dynamodb:index:ReadCapacityUnits",
            ScalableDimension::DynamoDbIndexWriteCapacityUnits => {
                "dynamodb:index:WriteCapacityUnits"
            }
            ScalableDimension::DynamoDbTableReadCapacityUnits => "dynamodb:table:ReadCapacityUnits",
            ScalableDimension::DynamoDbTableWriteCapacityUnits => {
                "dynamodb:table:WriteCapacityUnits"
            }
            ScalableDimension::Ec2SpotFleetRequestTargetCapacity => {
                "ec2:spot-fleet-request:TargetCapacity"
            }
            ScalableDimension::EcsServiceDesiredCount => "ecs:service:DesiredCount",
            ScalableDimension::ElastiCacheReplicationGroupNodeGroups => {
                "elasticache:replication-group:NodeGroups"
            }
            ScalableDimension::ElastiCacheReplicationGroupReplicas => {
                "elasticache:replication-group:Replicas"
            }
            ScalableDimension::EmrInstanceGroupInstanceCount => {
                "elasticmapreduce:instancegroup:InstanceCount"
            }
            ScalableDimension::KafkaBrokerStorageVolumeSize => "kafka:broker-storage:VolumeSize",
            ScalableDimension::LambdaFunctionProvisionedConcurrency => {
                "lambda:function:ProvisionedConcurrency"
            }
            ScalableDimension::NeptuneClusterReadReplicaCount => "neptune:cluster:ReadReplicaCount",
            ScalableDimension::RdsClusterReadReplicaCount => "rds:cluster:ReadReplicaCount",
            ScalableDimension::SageMakerVariantDesiredInstanceCount => {
                "sagemaker:variant:DesiredInstanceCount"
            }
            ScalableDimension::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "appstream:fleet:DesiredCapacity",
            "cassandra:table:ReadCapacityUnits",
            "cassandra:table:WriteCapacityUnits",
            "comprehend:document-classifier-endpoint:DesiredInferenceUnits",
            "comprehend:entity-recognizer-endpoint:DesiredInferenceUnits",
            "custom-resource:ResourceType:Property",
            "dynamodb:index:ReadCapacityUnits",
            "dynamodb:index:WriteCapacityUnits",
            "dynamodb:table:ReadCapacityUnits",
            "dynamodb:table:WriteCapacityUnits",
            "ec2:spot-fleet-request:TargetCapacity",
            "ecs:service:DesiredCount",
            "elasticache:replication-group:NodeGroups",
            "elasticache:replication-group:Replicas",
            "elasticmapreduce:instancegroup:InstanceCount",
            "kafka:broker-storage:VolumeSize",
            "lambda:function:ProvisionedConcurrency",
            "neptune:cluster:ReadReplicaCount",
            "rds:cluster:ReadReplicaCount",
            "sagemaker:variant:DesiredInstanceCount",
        ]
    }
}
impl AsRef<str> for ScalableDimension {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ServiceNamespace {
    #[allow(missing_docs)] // documentation missing in model
    Appstream,
    #[allow(missing_docs)] // documentation missing in model
    Cassandra,
    #[allow(missing_docs)] // documentation missing in model
    Comprehend,
    #[allow(missing_docs)] // documentation missing in model
    CustomResource,
    #[allow(missing_docs)] // documentation missing in model
    Dynamodb,
    #[allow(missing_docs)] // documentation missing in model
    Ec2,
    #[allow(missing_docs)] // documentation missing in model
    Ecs,
    #[allow(missing_docs)] // documentation missing in model
    Elasticache,
    #[allow(missing_docs)] // documentation missing in model
    Emr,
    #[allow(missing_docs)] // documentation missing in model
    Kafka,
    #[allow(missing_docs)] // documentation missing in model
    Lambda,
    #[allow(missing_docs)] // documentation missing in model
    Neptune,
    #[allow(missing_docs)] // documentation missing in model
    Rds,
    #[allow(missing_docs)] // documentation missing in model
    Sagemaker,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ServiceNamespace {
    fn from(s: &str) -> Self {
        match s {
            "appstream" => ServiceNamespace::Appstream,
            "cassandra" => ServiceNamespace::Cassandra,
            "comprehend" => ServiceNamespace::Comprehend,
            "custom-resource" => ServiceNamespace::CustomResource,
            "dynamodb" => ServiceNamespace::Dynamodb,
            "ec2" => ServiceNamespace::Ec2,
            "ecs" => ServiceNamespace::Ecs,
            "elasticache" => ServiceNamespace::Elasticache,
            "elasticmapreduce" => ServiceNamespace::Emr,
            "kafka" => ServiceNamespace::Kafka,
            "lambda" => ServiceNamespace::Lambda,
            "neptune" => ServiceNamespace::Neptune,
            "rds" => ServiceNamespace::Rds,
            "sagemaker" => ServiceNamespace::Sagemaker,
            other => ServiceNamespace::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ServiceNamespace {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ServiceNamespace::from(s))
    }
}
impl ServiceNamespace {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ServiceNamespace::Appstream => "appstream",
            ServiceNamespace::Cassandra => "cassandra",
            ServiceNamespace::Comprehend => "comprehend",
            ServiceNamespace::CustomResource => "custom-resource",
            ServiceNamespace::Dynamodb => "dynamodb",
            ServiceNamespace::Ec2 => "ec2",
            ServiceNamespace::Ecs => "ecs",
            ServiceNamespace::Elasticache => "elasticache",
            ServiceNamespace::Emr => "elasticmapreduce",
            ServiceNamespace::Kafka => "kafka",
            ServiceNamespace::Lambda => "lambda",
            ServiceNamespace::Neptune => "neptune",
            ServiceNamespace::Rds => "rds",
            ServiceNamespace::Sagemaker => "sagemaker",
            ServiceNamespace::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "appstream",
            "cassandra",
            "comprehend",
            "custom-resource",
            "dynamodb",
            "ec2",
            "ecs",
            "elasticache",
            "elasticmapreduce",
            "kafka",
            "lambda",
            "neptune",
            "rds",
            "sagemaker",
        ]
    }
}
impl AsRef<str> for ServiceNamespace {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents the minimum and maximum capacity for a scheduled action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScalableTargetAction {
    /// <p>The minimum capacity.</p>
    /// <p>For certain resources, the minimum value allowed is 0. This includes Lambda provisioned concurrency, Spot Fleet, ECS services, Aurora DB clusters, EMR clusters, and custom resources. For all other resources, the minimum value allowed is 1.</p>
    pub min_capacity: std::option::Option<i32>,
    /// <p>The maximum capacity.</p>
    /// <p>Although you can specify a large maximum capacity, note that service quotas may impose lower limits. Each service has its own default quotas for the maximum capacity of the resource. If you want to specify a higher limit, you can request an increase. For more information, consult the documentation for that service. For information about the default quotas for each service, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-service-information.html">Service Endpoints and Quotas</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub max_capacity: std::option::Option<i32>,
}
impl ScalableTargetAction {
    /// <p>The minimum capacity.</p>
    /// <p>For certain resources, the minimum value allowed is 0. This includes Lambda provisioned concurrency, Spot Fleet, ECS services, Aurora DB clusters, EMR clusters, and custom resources. For all other resources, the minimum value allowed is 1.</p>
    pub fn min_capacity(&self) -> std::option::Option<i32> {
        self.min_capacity
    }
    /// <p>The maximum capacity.</p>
    /// <p>Although you can specify a large maximum capacity, note that service quotas may impose lower limits. Each service has its own default quotas for the maximum capacity of the resource. If you want to specify a higher limit, you can request an increase. For more information, consult the documentation for that service. For information about the default quotas for each service, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-service-information.html">Service Endpoints and Quotas</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub fn max_capacity(&self) -> std::option::Option<i32> {
        self.max_capacity
    }
}
impl std::fmt::Debug for ScalableTargetAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScalableTargetAction");
        formatter.field("min_capacity", &self.min_capacity);
        formatter.field("max_capacity", &self.max_capacity);
        formatter.finish()
    }
}
/// See [`ScalableTargetAction`](crate::model::ScalableTargetAction)
pub mod scalable_target_action {
    /// A builder for [`ScalableTargetAction`](crate::model::ScalableTargetAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) min_capacity: std::option::Option<i32>,
        pub(crate) max_capacity: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The minimum capacity.</p>
        /// <p>For certain resources, the minimum value allowed is 0. This includes Lambda provisioned concurrency, Spot Fleet, ECS services, Aurora DB clusters, EMR clusters, and custom resources. For all other resources, the minimum value allowed is 1.</p>
        pub fn min_capacity(mut self, input: i32) -> Self {
            self.min_capacity = Some(input);
            self
        }
        /// <p>The minimum capacity.</p>
        /// <p>For certain resources, the minimum value allowed is 0. This includes Lambda provisioned concurrency, Spot Fleet, ECS services, Aurora DB clusters, EMR clusters, and custom resources. For all other resources, the minimum value allowed is 1.</p>
        pub fn set_min_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.min_capacity = input;
            self
        }
        /// <p>The maximum capacity.</p>
        /// <p>Although you can specify a large maximum capacity, note that service quotas may impose lower limits. Each service has its own default quotas for the maximum capacity of the resource. If you want to specify a higher limit, you can request an increase. For more information, consult the documentation for that service. For information about the default quotas for each service, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-service-information.html">Service Endpoints and Quotas</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn max_capacity(mut self, input: i32) -> Self {
            self.max_capacity = Some(input);
            self
        }
        /// <p>The maximum capacity.</p>
        /// <p>Although you can specify a large maximum capacity, note that service quotas may impose lower limits. Each service has its own default quotas for the maximum capacity of the resource. If you want to specify a higher limit, you can request an increase. For more information, consult the documentation for that service. For information about the default quotas for each service, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-service-information.html">Service Endpoints and Quotas</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_max_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.max_capacity = input;
            self
        }
        /// Consumes the builder and constructs a [`ScalableTargetAction`](crate::model::ScalableTargetAction)
        pub fn build(self) -> crate::model::ScalableTargetAction {
            crate::model::ScalableTargetAction {
                min_capacity: self.min_capacity,
                max_capacity: self.max_capacity,
            }
        }
    }
}
impl ScalableTargetAction {
    /// Creates a new builder-style object to manufacture [`ScalableTargetAction`](crate::model::ScalableTargetAction)
    pub fn builder() -> crate::model::scalable_target_action::Builder {
        crate::model::scalable_target_action::Builder::default()
    }
}

/// <p>Represents a CloudWatch alarm associated with a scaling policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Alarm {
    /// <p>The name of the alarm.</p>
    pub alarm_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the alarm.</p>
    pub alarm_arn: std::option::Option<std::string::String>,
}
impl Alarm {
    /// <p>The name of the alarm.</p>
    pub fn alarm_name(&self) -> std::option::Option<&str> {
        self.alarm_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the alarm.</p>
    pub fn alarm_arn(&self) -> std::option::Option<&str> {
        self.alarm_arn.as_deref()
    }
}
impl std::fmt::Debug for Alarm {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Alarm");
        formatter.field("alarm_name", &self.alarm_name);
        formatter.field("alarm_arn", &self.alarm_arn);
        formatter.finish()
    }
}
/// See [`Alarm`](crate::model::Alarm)
pub mod alarm {
    /// A builder for [`Alarm`](crate::model::Alarm)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alarm_name: std::option::Option<std::string::String>,
        pub(crate) alarm_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the alarm.</p>
        pub fn alarm_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.alarm_name = Some(input.into());
            self
        }
        /// <p>The name of the alarm.</p>
        pub fn set_alarm_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alarm_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the alarm.</p>
        pub fn alarm_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.alarm_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the alarm.</p>
        pub fn set_alarm_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alarm_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`Alarm`](crate::model::Alarm)
        pub fn build(self) -> crate::model::Alarm {
            crate::model::Alarm {
                alarm_name: self.alarm_name,
                alarm_arn: self.alarm_arn,
            }
        }
    }
}
impl Alarm {
    /// Creates a new builder-style object to manufacture [`Alarm`](crate::model::Alarm)
    pub fn builder() -> crate::model::alarm::Builder {
        crate::model::alarm::Builder::default()
    }
}

/// <p>Represents a target tracking scaling policy configuration to use with Application Auto Scaling.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TargetTrackingScalingPolicyConfiguration {
    /// <p>The target value for the metric. Although this property accepts numbers of type Double, it won't accept values that are either too small or too large. Values must be in the range of -2^360 to 2^360. The value must be a valid number based on the choice of metric. For example, if the metric is CPU utilization, then the target value is a percent value that represents how much of the CPU can be used before scaling out. </p>
    pub target_value: std::option::Option<f64>,
    /// <p>A predefined metric. You can specify either a predefined metric or a customized metric.</p>
    pub predefined_metric_specification:
        std::option::Option<crate::model::PredefinedMetricSpecification>,
    /// <p>A customized metric. You can specify either a predefined metric or a customized metric.</p>
    pub customized_metric_specification:
        std::option::Option<crate::model::CustomizedMetricSpecification>,
    /// <p>The amount of time, in seconds, to wait for a previous scale-out activity to take effect.</p>
    /// <p>With the <i>scale-out cooldown period</i>, the intention is to continuously (but not excessively) scale out. After Application Auto Scaling successfully scales out using a target tracking scaling policy, it starts to calculate the cooldown time. The scaling policy won't increase the desired capacity again unless either a larger scale out is triggered or the cooldown period ends. While the cooldown period is in effect, the capacity added by the initiating scale-out activity is calculated as part of the desired capacity for the next scale-out activity.</p>
    /// <p>Application Auto Scaling provides a default value of 600 for Amazon ElastiCache replication groups and a default value of 300 for the following scalable targets:</p>
    /// <ul>
    /// <li> <p>AppStream 2.0 fleets</p> </li>
    /// <li> <p>Aurora DB clusters</p> </li>
    /// <li> <p>ECS services</p> </li>
    /// <li> <p>EMR clusters</p> </li>
    /// <li> <p> Neptune clusters</p> </li>
    /// <li> <p>SageMaker endpoint variants</p> </li>
    /// <li> <p>Spot Fleets</p> </li>
    /// <li> <p>Custom resources</p> </li>
    /// </ul>
    /// <p>For all other scalable targets, the default value is 0:</p>
    /// <ul>
    /// <li> <p>Amazon Comprehend document classification and entity recognizer endpoints</p> </li>
    /// <li> <p>DynamoDB tables and global secondary indexes</p> </li>
    /// <li> <p>Amazon Keyspaces tables</p> </li>
    /// <li> <p>Lambda provisioned concurrency</p> </li>
    /// <li> <p>Amazon MSK broker storage</p> </li>
    /// </ul>
    pub scale_out_cooldown: std::option::Option<i32>,
    /// <p>The amount of time, in seconds, after a scale-in activity completes before another scale-in activity can start.</p>
    /// <p>With the <i>scale-in cooldown period</i>, the intention is to scale in conservatively to protect your application’s availability, so scale-in activities are blocked until the cooldown period has expired. However, if another alarm triggers a scale-out activity during the scale-in cooldown period, Application Auto Scaling scales out the target immediately. In this case, the scale-in cooldown period stops and doesn't complete.</p>
    /// <p>Application Auto Scaling provides a default value of 600 for Amazon ElastiCache replication groups and a default value of 300 for the following scalable targets:</p>
    /// <ul>
    /// <li> <p>AppStream 2.0 fleets</p> </li>
    /// <li> <p>Aurora DB clusters</p> </li>
    /// <li> <p>ECS services</p> </li>
    /// <li> <p>EMR clusters</p> </li>
    /// <li> <p> Neptune clusters</p> </li>
    /// <li> <p>SageMaker endpoint variants</p> </li>
    /// <li> <p>Spot Fleets</p> </li>
    /// <li> <p>Custom resources</p> </li>
    /// </ul>
    /// <p>For all other scalable targets, the default value is 0:</p>
    /// <ul>
    /// <li> <p>Amazon Comprehend document classification and entity recognizer endpoints</p> </li>
    /// <li> <p>DynamoDB tables and global secondary indexes</p> </li>
    /// <li> <p>Amazon Keyspaces tables</p> </li>
    /// <li> <p>Lambda provisioned concurrency</p> </li>
    /// <li> <p>Amazon MSK broker storage</p> </li>
    /// </ul>
    pub scale_in_cooldown: std::option::Option<i32>,
    /// <p>Indicates whether scale in by the target tracking scaling policy is disabled. If the value is <code>true</code>, scale in is disabled and the target tracking scaling policy won't remove capacity from the scalable target. Otherwise, scale in is enabled and the target tracking scaling policy can remove capacity from the scalable target. The default value is <code>false</code>.</p>
    pub disable_scale_in: std::option::Option<bool>,
}
impl TargetTrackingScalingPolicyConfiguration {
    /// <p>The target value for the metric. Although this property accepts numbers of type Double, it won't accept values that are either too small or too large. Values must be in the range of -2^360 to 2^360. The value must be a valid number based on the choice of metric. For example, if the metric is CPU utilization, then the target value is a percent value that represents how much of the CPU can be used before scaling out. </p>
    pub fn target_value(&self) -> std::option::Option<f64> {
        self.target_value
    }
    /// <p>A predefined metric. You can specify either a predefined metric or a customized metric.</p>
    pub fn predefined_metric_specification(
        &self,
    ) -> std::option::Option<&crate::model::PredefinedMetricSpecification> {
        self.predefined_metric_specification.as_ref()
    }
    /// <p>A customized metric. You can specify either a predefined metric or a customized metric.</p>
    pub fn customized_metric_specification(
        &self,
    ) -> std::option::Option<&crate::model::CustomizedMetricSpecification> {
        self.customized_metric_specification.as_ref()
    }
    /// <p>The amount of time, in seconds, to wait for a previous scale-out activity to take effect.</p>
    /// <p>With the <i>scale-out cooldown period</i>, the intention is to continuously (but not excessively) scale out. After Application Auto Scaling successfully scales out using a target tracking scaling policy, it starts to calculate the cooldown time. The scaling policy won't increase the desired capacity again unless either a larger scale out is triggered or the cooldown period ends. While the cooldown period is in effect, the capacity added by the initiating scale-out activity is calculated as part of the desired capacity for the next scale-out activity.</p>
    /// <p>Application Auto Scaling provides a default value of 600 for Amazon ElastiCache replication groups and a default value of 300 for the following scalable targets:</p>
    /// <ul>
    /// <li> <p>AppStream 2.0 fleets</p> </li>
    /// <li> <p>Aurora DB clusters</p> </li>
    /// <li> <p>ECS services</p> </li>
    /// <li> <p>EMR clusters</p> </li>
    /// <li> <p> Neptune clusters</p> </li>
    /// <li> <p>SageMaker endpoint variants</p> </li>
    /// <li> <p>Spot Fleets</p> </li>
    /// <li> <p>Custom resources</p> </li>
    /// </ul>
    /// <p>For all other scalable targets, the default value is 0:</p>
    /// <ul>
    /// <li> <p>Amazon Comprehend document classification and entity recognizer endpoints</p> </li>
    /// <li> <p>DynamoDB tables and global secondary indexes</p> </li>
    /// <li> <p>Amazon Keyspaces tables</p> </li>
    /// <li> <p>Lambda provisioned concurrency</p> </li>
    /// <li> <p>Amazon MSK broker storage</p> </li>
    /// </ul>
    pub fn scale_out_cooldown(&self) -> std::option::Option<i32> {
        self.scale_out_cooldown
    }
    /// <p>The amount of time, in seconds, after a scale-in activity completes before another scale-in activity can start.</p>
    /// <p>With the <i>scale-in cooldown period</i>, the intention is to scale in conservatively to protect your application’s availability, so scale-in activities are blocked until the cooldown period has expired. However, if another alarm triggers a scale-out activity during the scale-in cooldown period, Application Auto Scaling scales out the target immediately. In this case, the scale-in cooldown period stops and doesn't complete.</p>
    /// <p>Application Auto Scaling provides a default value of 600 for Amazon ElastiCache replication groups and a default value of 300 for the following scalable targets:</p>
    /// <ul>
    /// <li> <p>AppStream 2.0 fleets</p> </li>
    /// <li> <p>Aurora DB clusters</p> </li>
    /// <li> <p>ECS services</p> </li>
    /// <li> <p>EMR clusters</p> </li>
    /// <li> <p> Neptune clusters</p> </li>
    /// <li> <p>SageMaker endpoint variants</p> </li>
    /// <li> <p>Spot Fleets</p> </li>
    /// <li> <p>Custom resources</p> </li>
    /// </ul>
    /// <p>For all other scalable targets, the default value is 0:</p>
    /// <ul>
    /// <li> <p>Amazon Comprehend document classification and entity recognizer endpoints</p> </li>
    /// <li> <p>DynamoDB tables and global secondary indexes</p> </li>
    /// <li> <p>Amazon Keyspaces tables</p> </li>
    /// <li> <p>Lambda provisioned concurrency</p> </li>
    /// <li> <p>Amazon MSK broker storage</p> </li>
    /// </ul>
    pub fn scale_in_cooldown(&self) -> std::option::Option<i32> {
        self.scale_in_cooldown
    }
    /// <p>Indicates whether scale in by the target tracking scaling policy is disabled. If the value is <code>true</code>, scale in is disabled and the target tracking scaling policy won't remove capacity from the scalable target. Otherwise, scale in is enabled and the target tracking scaling policy can remove capacity from the scalable target. The default value is <code>false</code>.</p>
    pub fn disable_scale_in(&self) -> std::option::Option<bool> {
        self.disable_scale_in
    }
}
impl std::fmt::Debug for TargetTrackingScalingPolicyConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TargetTrackingScalingPolicyConfiguration");
        formatter.field("target_value", &self.target_value);
        formatter.field(
            "predefined_metric_specification",
            &self.predefined_metric_specification,
        );
        formatter.field(
            "customized_metric_specification",
            &self.customized_metric_specification,
        );
        formatter.field("scale_out_cooldown", &self.scale_out_cooldown);
        formatter.field("scale_in_cooldown", &self.scale_in_cooldown);
        formatter.field("disable_scale_in", &self.disable_scale_in);
        formatter.finish()
    }
}
/// See [`TargetTrackingScalingPolicyConfiguration`](crate::model::TargetTrackingScalingPolicyConfiguration)
pub mod target_tracking_scaling_policy_configuration {
    /// A builder for [`TargetTrackingScalingPolicyConfiguration`](crate::model::TargetTrackingScalingPolicyConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_value: std::option::Option<f64>,
        pub(crate) predefined_metric_specification:
            std::option::Option<crate::model::PredefinedMetricSpecification>,
        pub(crate) customized_metric_specification:
            std::option::Option<crate::model::CustomizedMetricSpecification>,
        pub(crate) scale_out_cooldown: std::option::Option<i32>,
        pub(crate) scale_in_cooldown: std::option::Option<i32>,
        pub(crate) disable_scale_in: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The target value for the metric. Although this property accepts numbers of type Double, it won't accept values that are either too small or too large. Values must be in the range of -2^360 to 2^360. The value must be a valid number based on the choice of metric. For example, if the metric is CPU utilization, then the target value is a percent value that represents how much of the CPU can be used before scaling out. </p>
        pub fn target_value(mut self, input: f64) -> Self {
            self.target_value = Some(input);
            self
        }
        /// <p>The target value for the metric. Although this property accepts numbers of type Double, it won't accept values that are either too small or too large. Values must be in the range of -2^360 to 2^360. The value must be a valid number based on the choice of metric. For example, if the metric is CPU utilization, then the target value is a percent value that represents how much of the CPU can be used before scaling out. </p>
        pub fn set_target_value(mut self, input: std::option::Option<f64>) -> Self {
            self.target_value = input;
            self
        }
        /// <p>A predefined metric. You can specify either a predefined metric or a customized metric.</p>
        pub fn predefined_metric_specification(
            mut self,
            input: crate::model::PredefinedMetricSpecification,
        ) -> Self {
            self.predefined_metric_specification = Some(input);
            self
        }
        /// <p>A predefined metric. You can specify either a predefined metric or a customized metric.</p>
        pub fn set_predefined_metric_specification(
            mut self,
            input: std::option::Option<crate::model::PredefinedMetricSpecification>,
        ) -> Self {
            self.predefined_metric_specification = input;
            self
        }
        /// <p>A customized metric. You can specify either a predefined metric or a customized metric.</p>
        pub fn customized_metric_specification(
            mut self,
            input: crate::model::CustomizedMetricSpecification,
        ) -> Self {
            self.customized_metric_specification = Some(input);
            self
        }
        /// <p>A customized metric. You can specify either a predefined metric or a customized metric.</p>
        pub fn set_customized_metric_specification(
            mut self,
            input: std::option::Option<crate::model::CustomizedMetricSpecification>,
        ) -> Self {
            self.customized_metric_specification = input;
            self
        }
        /// <p>The amount of time, in seconds, to wait for a previous scale-out activity to take effect.</p>
        /// <p>With the <i>scale-out cooldown period</i>, the intention is to continuously (but not excessively) scale out. After Application Auto Scaling successfully scales out using a target tracking scaling policy, it starts to calculate the cooldown time. The scaling policy won't increase the desired capacity again unless either a larger scale out is triggered or the cooldown period ends. While the cooldown period is in effect, the capacity added by the initiating scale-out activity is calculated as part of the desired capacity for the next scale-out activity.</p>
        /// <p>Application Auto Scaling provides a default value of 600 for Amazon ElastiCache replication groups and a default value of 300 for the following scalable targets:</p>
        /// <ul>
        /// <li> <p>AppStream 2.0 fleets</p> </li>
        /// <li> <p>Aurora DB clusters</p> </li>
        /// <li> <p>ECS services</p> </li>
        /// <li> <p>EMR clusters</p> </li>
        /// <li> <p> Neptune clusters</p> </li>
        /// <li> <p>SageMaker endpoint variants</p> </li>
        /// <li> <p>Spot Fleets</p> </li>
        /// <li> <p>Custom resources</p> </li>
        /// </ul>
        /// <p>For all other scalable targets, the default value is 0:</p>
        /// <ul>
        /// <li> <p>Amazon Comprehend document classification and entity recognizer endpoints</p> </li>
        /// <li> <p>DynamoDB tables and global secondary indexes</p> </li>
        /// <li> <p>Amazon Keyspaces tables</p> </li>
        /// <li> <p>Lambda provisioned concurrency</p> </li>
        /// <li> <p>Amazon MSK broker storage</p> </li>
        /// </ul>
        pub fn scale_out_cooldown(mut self, input: i32) -> Self {
            self.scale_out_cooldown = Some(input);
            self
        }
        /// <p>The amount of time, in seconds, to wait for a previous scale-out activity to take effect.</p>
        /// <p>With the <i>scale-out cooldown period</i>, the intention is to continuously (but not excessively) scale out. After Application Auto Scaling successfully scales out using a target tracking scaling policy, it starts to calculate the cooldown time. The scaling policy won't increase the desired capacity again unless either a larger scale out is triggered or the cooldown period ends. While the cooldown period is in effect, the capacity added by the initiating scale-out activity is calculated as part of the desired capacity for the next scale-out activity.</p>
        /// <p>Application Auto Scaling provides a default value of 600 for Amazon ElastiCache replication groups and a default value of 300 for the following scalable targets:</p>
        /// <ul>
        /// <li> <p>AppStream 2.0 fleets</p> </li>
        /// <li> <p>Aurora DB clusters</p> </li>
        /// <li> <p>ECS services</p> </li>
        /// <li> <p>EMR clusters</p> </li>
        /// <li> <p> Neptune clusters</p> </li>
        /// <li> <p>SageMaker endpoint variants</p> </li>
        /// <li> <p>Spot Fleets</p> </li>
        /// <li> <p>Custom resources</p> </li>
        /// </ul>
        /// <p>For all other scalable targets, the default value is 0:</p>
        /// <ul>
        /// <li> <p>Amazon Comprehend document classification and entity recognizer endpoints</p> </li>
        /// <li> <p>DynamoDB tables and global secondary indexes</p> </li>
        /// <li> <p>Amazon Keyspaces tables</p> </li>
        /// <li> <p>Lambda provisioned concurrency</p> </li>
        /// <li> <p>Amazon MSK broker storage</p> </li>
        /// </ul>
        pub fn set_scale_out_cooldown(mut self, input: std::option::Option<i32>) -> Self {
            self.scale_out_cooldown = input;
            self
        }
        /// <p>The amount of time, in seconds, after a scale-in activity completes before another scale-in activity can start.</p>
        /// <p>With the <i>scale-in cooldown period</i>, the intention is to scale in conservatively to protect your application’s availability, so scale-in activities are blocked until the cooldown period has expired. However, if another alarm triggers a scale-out activity during the scale-in cooldown period, Application Auto Scaling scales out the target immediately. In this case, the scale-in cooldown period stops and doesn't complete.</p>
        /// <p>Application Auto Scaling provides a default value of 600 for Amazon ElastiCache replication groups and a default value of 300 for the following scalable targets:</p>
        /// <ul>
        /// <li> <p>AppStream 2.0 fleets</p> </li>
        /// <li> <p>Aurora DB clusters</p> </li>
        /// <li> <p>ECS services</p> </li>
        /// <li> <p>EMR clusters</p> </li>
        /// <li> <p> Neptune clusters</p> </li>
        /// <li> <p>SageMaker endpoint variants</p> </li>
        /// <li> <p>Spot Fleets</p> </li>
        /// <li> <p>Custom resources</p> </li>
        /// </ul>
        /// <p>For all other scalable targets, the default value is 0:</p>
        /// <ul>
        /// <li> <p>Amazon Comprehend document classification and entity recognizer endpoints</p> </li>
        /// <li> <p>DynamoDB tables and global secondary indexes</p> </li>
        /// <li> <p>Amazon Keyspaces tables</p> </li>
        /// <li> <p>Lambda provisioned concurrency</p> </li>
        /// <li> <p>Amazon MSK broker storage</p> </li>
        /// </ul>
        pub fn scale_in_cooldown(mut self, input: i32) -> Self {
            self.scale_in_cooldown = Some(input);
            self
        }
        /// <p>The amount of time, in seconds, after a scale-in activity completes before another scale-in activity can start.</p>
        /// <p>With the <i>scale-in cooldown period</i>, the intention is to scale in conservatively to protect your application’s availability, so scale-in activities are blocked until the cooldown period has expired. However, if another alarm triggers a scale-out activity during the scale-in cooldown period, Application Auto Scaling scales out the target immediately. In this case, the scale-in cooldown period stops and doesn't complete.</p>
        /// <p>Application Auto Scaling provides a default value of 600 for Amazon ElastiCache replication groups and a default value of 300 for the following scalable targets:</p>
        /// <ul>
        /// <li> <p>AppStream 2.0 fleets</p> </li>
        /// <li> <p>Aurora DB clusters</p> </li>
        /// <li> <p>ECS services</p> </li>
        /// <li> <p>EMR clusters</p> </li>
        /// <li> <p> Neptune clusters</p> </li>
        /// <li> <p>SageMaker endpoint variants</p> </li>
        /// <li> <p>Spot Fleets</p> </li>
        /// <li> <p>Custom resources</p> </li>
        /// </ul>
        /// <p>For all other scalable targets, the default value is 0:</p>
        /// <ul>
        /// <li> <p>Amazon Comprehend document classification and entity recognizer endpoints</p> </li>
        /// <li> <p>DynamoDB tables and global secondary indexes</p> </li>
        /// <li> <p>Amazon Keyspaces tables</p> </li>
        /// <li> <p>Lambda provisioned concurrency</p> </li>
        /// <li> <p>Amazon MSK broker storage</p> </li>
        /// </ul>
        pub fn set_scale_in_cooldown(mut self, input: std::option::Option<i32>) -> Self {
            self.scale_in_cooldown = input;
            self
        }
        /// <p>Indicates whether scale in by the target tracking scaling policy is disabled. If the value is <code>true</code>, scale in is disabled and the target tracking scaling policy won't remove capacity from the scalable target. Otherwise, scale in is enabled and the target tracking scaling policy can remove capacity from the scalable target. The default value is <code>false</code>.</p>
        pub fn disable_scale_in(mut self, input: bool) -> Self {
            self.disable_scale_in = Some(input);
            self
        }
        /// <p>Indicates whether scale in by the target tracking scaling policy is disabled. If the value is <code>true</code>, scale in is disabled and the target tracking scaling policy won't remove capacity from the scalable target. Otherwise, scale in is enabled and the target tracking scaling policy can remove capacity from the scalable target. The default value is <code>false</code>.</p>
        pub fn set_disable_scale_in(mut self, input: std::option::Option<bool>) -> Self {
            self.disable_scale_in = input;
            self
        }
        /// Consumes the builder and constructs a [`TargetTrackingScalingPolicyConfiguration`](crate::model::TargetTrackingScalingPolicyConfiguration)
        pub fn build(self) -> crate::model::TargetTrackingScalingPolicyConfiguration {
            crate::model::TargetTrackingScalingPolicyConfiguration {
                target_value: self.target_value,
                predefined_metric_specification: self.predefined_metric_specification,
                customized_metric_specification: self.customized_metric_specification,
                scale_out_cooldown: self.scale_out_cooldown,
                scale_in_cooldown: self.scale_in_cooldown,
                disable_scale_in: self.disable_scale_in,
            }
        }
    }
}
impl TargetTrackingScalingPolicyConfiguration {
    /// Creates a new builder-style object to manufacture [`TargetTrackingScalingPolicyConfiguration`](crate::model::TargetTrackingScalingPolicyConfiguration)
    pub fn builder() -> crate::model::target_tracking_scaling_policy_configuration::Builder {
        crate::model::target_tracking_scaling_policy_configuration::Builder::default()
    }
}

/// <p>Represents a CloudWatch metric of your choosing for a target tracking scaling policy to use with Application Auto Scaling.</p>
/// <p>For information about the available metrics for a service, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/aws-services-cloudwatch-metrics.html">Amazon Web Services Services That Publish CloudWatch Metrics</a> in the <i>Amazon CloudWatch User Guide</i>.</p>
/// <p>To create your customized metric specification:</p>
/// <ul>
/// <li> <p>Add values for each required parameter from CloudWatch. You can use an existing metric, or a new metric that you create. To use your own metric, you must first publish the metric to CloudWatch. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/publishingMetrics.html">Publish Custom Metrics</a> in the <i>Amazon CloudWatch User Guide</i>.</p> </li>
/// <li> <p>Choose a metric that changes proportionally with capacity. The value of the metric should increase or decrease in inverse proportion to the number of capacity units. That is, the value of the metric should decrease when capacity increases, and increase when capacity decreases. </p> </li>
/// </ul>
/// <p>For more information about CloudWatch, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html">Amazon CloudWatch Concepts</a>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomizedMetricSpecification {
    /// <p>The name of the metric. </p>
    pub metric_name: std::option::Option<std::string::String>,
    /// <p>The namespace of the metric.</p>
    pub namespace: std::option::Option<std::string::String>,
    /// <p>The dimensions of the metric. </p>
    /// <p>Conditional: If you published your metric with dimensions, you must specify the same dimensions in your scaling policy.</p>
    pub dimensions: std::option::Option<std::vec::Vec<crate::model::MetricDimension>>,
    /// <p>The statistic of the metric.</p>
    pub statistic: std::option::Option<crate::model::MetricStatistic>,
    /// <p>The unit of the metric.</p>
    pub unit: std::option::Option<std::string::String>,
}
impl CustomizedMetricSpecification {
    /// <p>The name of the metric. </p>
    pub fn metric_name(&self) -> std::option::Option<&str> {
        self.metric_name.as_deref()
    }
    /// <p>The namespace of the metric.</p>
    pub fn namespace(&self) -> std::option::Option<&str> {
        self.namespace.as_deref()
    }
    /// <p>The dimensions of the metric. </p>
    /// <p>Conditional: If you published your metric with dimensions, you must specify the same dimensions in your scaling policy.</p>
    pub fn dimensions(&self) -> std::option::Option<&[crate::model::MetricDimension]> {
        self.dimensions.as_deref()
    }
    /// <p>The statistic of the metric.</p>
    pub fn statistic(&self) -> std::option::Option<&crate::model::MetricStatistic> {
        self.statistic.as_ref()
    }
    /// <p>The unit of the metric.</p>
    pub fn unit(&self) -> std::option::Option<&str> {
        self.unit.as_deref()
    }
}
impl std::fmt::Debug for CustomizedMetricSpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomizedMetricSpecification");
        formatter.field("metric_name", &self.metric_name);
        formatter.field("namespace", &self.namespace);
        formatter.field("dimensions", &self.dimensions);
        formatter.field("statistic", &self.statistic);
        formatter.field("unit", &self.unit);
        formatter.finish()
    }
}
/// See [`CustomizedMetricSpecification`](crate::model::CustomizedMetricSpecification)
pub mod customized_metric_specification {
    /// A builder for [`CustomizedMetricSpecification`](crate::model::CustomizedMetricSpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric_name: std::option::Option<std::string::String>,
        pub(crate) namespace: std::option::Option<std::string::String>,
        pub(crate) dimensions: std::option::Option<std::vec::Vec<crate::model::MetricDimension>>,
        pub(crate) statistic: std::option::Option<crate::model::MetricStatistic>,
        pub(crate) unit: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the metric. </p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_name = Some(input.into());
            self
        }
        /// <p>The name of the metric. </p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric_name = input;
            self
        }
        /// <p>The namespace of the metric.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>The namespace of the metric.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// Appends an item to `dimensions`.
        ///
        /// To override the contents of this collection use [`set_dimensions`](Self::set_dimensions).
        ///
        /// <p>The dimensions of the metric. </p>
        /// <p>Conditional: If you published your metric with dimensions, you must specify the same dimensions in your scaling policy.</p>
        pub fn dimensions(mut self, input: crate::model::MetricDimension) -> Self {
            let mut v = self.dimensions.unwrap_or_default();
            v.push(input);
            self.dimensions = Some(v);
            self
        }
        /// <p>The dimensions of the metric. </p>
        /// <p>Conditional: If you published your metric with dimensions, you must specify the same dimensions in your scaling policy.</p>
        pub fn set_dimensions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MetricDimension>>,
        ) -> Self {
            self.dimensions = input;
            self
        }
        /// <p>The statistic of the metric.</p>
        pub fn statistic(mut self, input: crate::model::MetricStatistic) -> Self {
            self.statistic = Some(input);
            self
        }
        /// <p>The statistic of the metric.</p>
        pub fn set_statistic(
            mut self,
            input: std::option::Option<crate::model::MetricStatistic>,
        ) -> Self {
            self.statistic = input;
            self
        }
        /// <p>The unit of the metric.</p>
        pub fn unit(mut self, input: impl Into<std::string::String>) -> Self {
            self.unit = Some(input.into());
            self
        }
        /// <p>The unit of the metric.</p>
        pub fn set_unit(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.unit = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomizedMetricSpecification`](crate::model::CustomizedMetricSpecification)
        pub fn build(self) -> crate::model::CustomizedMetricSpecification {
            crate::model::CustomizedMetricSpecification {
                metric_name: self.metric_name,
                namespace: self.namespace,
                dimensions: self.dimensions,
                statistic: self.statistic,
                unit: self.unit,
            }
        }
    }
}
impl CustomizedMetricSpecification {
    /// Creates a new builder-style object to manufacture [`CustomizedMetricSpecification`](crate::model::CustomizedMetricSpecification)
    pub fn builder() -> crate::model::customized_metric_specification::Builder {
        crate::model::customized_metric_specification::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MetricStatistic {
    #[allow(missing_docs)] // documentation missing in model
    Average,
    #[allow(missing_docs)] // documentation missing in model
    Maximum,
    #[allow(missing_docs)] // documentation missing in model
    Minimum,
    #[allow(missing_docs)] // documentation missing in model
    SampleCount,
    #[allow(missing_docs)] // documentation missing in model
    Sum,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MetricStatistic {
    fn from(s: &str) -> Self {
        match s {
            "Average" => MetricStatistic::Average,
            "Maximum" => MetricStatistic::Maximum,
            "Minimum" => MetricStatistic::Minimum,
            "SampleCount" => MetricStatistic::SampleCount,
            "Sum" => MetricStatistic::Sum,
            other => MetricStatistic::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MetricStatistic {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MetricStatistic::from(s))
    }
}
impl MetricStatistic {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MetricStatistic::Average => "Average",
            MetricStatistic::Maximum => "Maximum",
            MetricStatistic::Minimum => "Minimum",
            MetricStatistic::SampleCount => "SampleCount",
            MetricStatistic::Sum => "Sum",
            MetricStatistic::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Average", "Maximum", "Minimum", "SampleCount", "Sum"]
    }
}
impl AsRef<str> for MetricStatistic {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the dimension names and values associated with a metric.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MetricDimension {
    /// <p>The name of the dimension.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The value of the dimension.</p>
    pub value: std::option::Option<std::string::String>,
}
impl MetricDimension {
    /// <p>The name of the dimension.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The value of the dimension.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for MetricDimension {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MetricDimension");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`MetricDimension`](crate::model::MetricDimension)
pub mod metric_dimension {
    /// A builder for [`MetricDimension`](crate::model::MetricDimension)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the dimension.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the dimension.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The value of the dimension.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the dimension.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`MetricDimension`](crate::model::MetricDimension)
        pub fn build(self) -> crate::model::MetricDimension {
            crate::model::MetricDimension {
                name: self.name,
                value: self.value,
            }
        }
    }
}
impl MetricDimension {
    /// Creates a new builder-style object to manufacture [`MetricDimension`](crate::model::MetricDimension)
    pub fn builder() -> crate::model::metric_dimension::Builder {
        crate::model::metric_dimension::Builder::default()
    }
}

/// <p>Represents a predefined metric for a target tracking scaling policy to use with Application Auto Scaling.</p>
/// <p>Only the Amazon Web Services that you're using send metrics to Amazon CloudWatch. To determine whether a desired metric already exists by looking up its namespace and dimension using the CloudWatch metrics dashboard in the console, follow the procedure in <a href="https://docs.aws.amazon.com/autoscaling/application/userguide/monitoring-cloudwatch.html">Building dashboards with CloudWatch</a> in the <i>Application Auto Scaling User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PredefinedMetricSpecification {
    /// <p>The metric type. The <code>ALBRequestCountPerTarget</code> metric type applies only to Spot Fleet requests and ECS services.</p>
    pub predefined_metric_type: std::option::Option<crate::model::MetricType>,
    /// <p>Identifies the resource associated with the metric type. You can't specify a resource label unless the metric type is <code>ALBRequestCountPerTarget</code> and there is a target group attached to the Spot Fleet request or ECS service.</p>
    /// <p>You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). The format of the resource label is:</p>
    /// <p> <code>app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff</code>.</p>
    /// <p>Where:</p>
    /// <ul>
    /// <li> <p>app/<load-balancer-name>
    /// /
    /// <load-balancer-id>
    /// is the final portion of the load balancer ARN
    /// </load-balancer-id>
    /// </load-balancer-name></p> </li>
    /// <li> <p>targetgroup/<target-group-name>
    /// /
    /// <target-group-id>
    /// is the final portion of the target group ARN.
    /// </target-group-id>
    /// </target-group-name></p> </li>
    /// </ul>
    /// <p>To find the ARN for an Application Load Balancer, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers</a> API operation. To find the ARN for the target group, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html">DescribeTargetGroups</a> API operation.</p>
    pub resource_label: std::option::Option<std::string::String>,
}
impl PredefinedMetricSpecification {
    /// <p>The metric type. The <code>ALBRequestCountPerTarget</code> metric type applies only to Spot Fleet requests and ECS services.</p>
    pub fn predefined_metric_type(&self) -> std::option::Option<&crate::model::MetricType> {
        self.predefined_metric_type.as_ref()
    }
    /// <p>Identifies the resource associated with the metric type. You can't specify a resource label unless the metric type is <code>ALBRequestCountPerTarget</code> and there is a target group attached to the Spot Fleet request or ECS service.</p>
    /// <p>You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). The format of the resource label is:</p>
    /// <p> <code>app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff</code>.</p>
    /// <p>Where:</p>
    /// <ul>
    /// <li> <p>app/<load-balancer-name>
    /// /
    /// <load-balancer-id>
    /// is the final portion of the load balancer ARN
    /// </load-balancer-id>
    /// </load-balancer-name></p> </li>
    /// <li> <p>targetgroup/<target-group-name>
    /// /
    /// <target-group-id>
    /// is the final portion of the target group ARN.
    /// </target-group-id>
    /// </target-group-name></p> </li>
    /// </ul>
    /// <p>To find the ARN for an Application Load Balancer, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers</a> API operation. To find the ARN for the target group, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html">DescribeTargetGroups</a> API operation.</p>
    pub fn resource_label(&self) -> std::option::Option<&str> {
        self.resource_label.as_deref()
    }
}
impl std::fmt::Debug for PredefinedMetricSpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PredefinedMetricSpecification");
        formatter.field("predefined_metric_type", &self.predefined_metric_type);
        formatter.field("resource_label", &self.resource_label);
        formatter.finish()
    }
}
/// See [`PredefinedMetricSpecification`](crate::model::PredefinedMetricSpecification)
pub mod predefined_metric_specification {
    /// A builder for [`PredefinedMetricSpecification`](crate::model::PredefinedMetricSpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) predefined_metric_type: std::option::Option<crate::model::MetricType>,
        pub(crate) resource_label: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The metric type. The <code>ALBRequestCountPerTarget</code> metric type applies only to Spot Fleet requests and ECS services.</p>
        pub fn predefined_metric_type(mut self, input: crate::model::MetricType) -> Self {
            self.predefined_metric_type = Some(input);
            self
        }
        /// <p>The metric type. The <code>ALBRequestCountPerTarget</code> metric type applies only to Spot Fleet requests and ECS services.</p>
        pub fn set_predefined_metric_type(
            mut self,
            input: std::option::Option<crate::model::MetricType>,
        ) -> Self {
            self.predefined_metric_type = input;
            self
        }
        /// <p>Identifies the resource associated with the metric type. You can't specify a resource label unless the metric type is <code>ALBRequestCountPerTarget</code> and there is a target group attached to the Spot Fleet request or ECS service.</p>
        /// <p>You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). The format of the resource label is:</p>
        /// <p> <code>app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff</code>.</p>
        /// <p>Where:</p>
        /// <ul>
        /// <li> <p>app/<load-balancer-name>
        /// /
        /// <load-balancer-id>
        /// is the final portion of the load balancer ARN
        /// </load-balancer-id>
        /// </load-balancer-name></p> </li>
        /// <li> <p>targetgroup/<target-group-name>
        /// /
        /// <target-group-id>
        /// is the final portion of the target group ARN.
        /// </target-group-id>
        /// </target-group-name></p> </li>
        /// </ul>
        /// <p>To find the ARN for an Application Load Balancer, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers</a> API operation. To find the ARN for the target group, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html">DescribeTargetGroups</a> API operation.</p>
        pub fn resource_label(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_label = Some(input.into());
            self
        }
        /// <p>Identifies the resource associated with the metric type. You can't specify a resource label unless the metric type is <code>ALBRequestCountPerTarget</code> and there is a target group attached to the Spot Fleet request or ECS service.</p>
        /// <p>You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). The format of the resource label is:</p>
        /// <p> <code>app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff</code>.</p>
        /// <p>Where:</p>
        /// <ul>
        /// <li> <p>app/<load-balancer-name>
        /// /
        /// <load-balancer-id>
        /// is the final portion of the load balancer ARN
        /// </load-balancer-id>
        /// </load-balancer-name></p> </li>
        /// <li> <p>targetgroup/<target-group-name>
        /// /
        /// <target-group-id>
        /// is the final portion of the target group ARN.
        /// </target-group-id>
        /// </target-group-name></p> </li>
        /// </ul>
        /// <p>To find the ARN for an Application Load Balancer, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers</a> API operation. To find the ARN for the target group, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html">DescribeTargetGroups</a> API operation.</p>
        pub fn set_resource_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_label = input;
            self
        }
        /// Consumes the builder and constructs a [`PredefinedMetricSpecification`](crate::model::PredefinedMetricSpecification)
        pub fn build(self) -> crate::model::PredefinedMetricSpecification {
            crate::model::PredefinedMetricSpecification {
                predefined_metric_type: self.predefined_metric_type,
                resource_label: self.resource_label,
            }
        }
    }
}
impl PredefinedMetricSpecification {
    /// Creates a new builder-style object to manufacture [`PredefinedMetricSpecification`](crate::model::PredefinedMetricSpecification)
    pub fn builder() -> crate::model::predefined_metric_specification::Builder {
        crate::model::predefined_metric_specification::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MetricType {
    #[allow(missing_docs)] // documentation missing in model
    AlbRequestCountPerTarget,
    #[allow(missing_docs)] // documentation missing in model
    AppStreamAverageCapacityUtilization,
    #[allow(missing_docs)] // documentation missing in model
    CassandraReadCapacityUtilization,
    #[allow(missing_docs)] // documentation missing in model
    CassandraWriteCapacityUtilization,
    #[allow(missing_docs)] // documentation missing in model
    ComprehendInferenceUtilization,
    #[allow(missing_docs)] // documentation missing in model
    DynamoDbReadCapacityUtilization,
    #[allow(missing_docs)] // documentation missing in model
    DynamoDbWriteCapacityUtilization,
    #[allow(missing_docs)] // documentation missing in model
    Ec2SpotFleetRequestAverageCpuUtilization,
    #[allow(missing_docs)] // documentation missing in model
    Ec2SpotFleetRequestAverageNetworkIn,
    #[allow(missing_docs)] // documentation missing in model
    Ec2SpotFleetRequestAverageNetworkOut,
    #[allow(missing_docs)] // documentation missing in model
    EcsServiceAverageCpuUtilization,
    #[allow(missing_docs)] // documentation missing in model
    EcsServiceAverageMemoryUtilization,
    #[allow(missing_docs)] // documentation missing in model
    ElastiCacheDatabaseMemoryUsageCountedForEvictPercentage,
    #[allow(missing_docs)] // documentation missing in model
    ElastiCachePrimaryEngineCpuUtilization,
    #[allow(missing_docs)] // documentation missing in model
    ElastiCacheReplicaEngineCpuUtilization,
    #[allow(missing_docs)] // documentation missing in model
    KafkaBrokerStorageUtilization,
    #[allow(missing_docs)] // documentation missing in model
    LambdaProvisionedConcurrencyUtilization,
    #[allow(missing_docs)] // documentation missing in model
    NeptuneReaderAverageCpuUtilization,
    #[allow(missing_docs)] // documentation missing in model
    RdsReaderAverageCpuUtilization,
    #[allow(missing_docs)] // documentation missing in model
    RdsReaderAverageDatabaseConnections,
    #[allow(missing_docs)] // documentation missing in model
    SageMakerVariantInvocationsPerInstance,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MetricType {
    fn from(s: &str) -> Self {
        match s {
            "ALBRequestCountPerTarget" => MetricType::AlbRequestCountPerTarget,
            "AppStreamAverageCapacityUtilization" => {
                MetricType::AppStreamAverageCapacityUtilization
            }
            "CassandraReadCapacityUtilization" => MetricType::CassandraReadCapacityUtilization,
            "CassandraWriteCapacityUtilization" => MetricType::CassandraWriteCapacityUtilization,
            "ComprehendInferenceUtilization" => MetricType::ComprehendInferenceUtilization,
            "DynamoDBReadCapacityUtilization" => MetricType::DynamoDbReadCapacityUtilization,
            "DynamoDBWriteCapacityUtilization" => MetricType::DynamoDbWriteCapacityUtilization,
            "EC2SpotFleetRequestAverageCPUUtilization" => {
                MetricType::Ec2SpotFleetRequestAverageCpuUtilization
            }
            "EC2SpotFleetRequestAverageNetworkIn" => {
                MetricType::Ec2SpotFleetRequestAverageNetworkIn
            }
            "EC2SpotFleetRequestAverageNetworkOut" => {
                MetricType::Ec2SpotFleetRequestAverageNetworkOut
            }
            "ECSServiceAverageCPUUtilization" => MetricType::EcsServiceAverageCpuUtilization,
            "ECSServiceAverageMemoryUtilization" => MetricType::EcsServiceAverageMemoryUtilization,
            "ElastiCacheDatabaseMemoryUsageCountedForEvictPercentage" => {
                MetricType::ElastiCacheDatabaseMemoryUsageCountedForEvictPercentage
            }
            "ElastiCachePrimaryEngineCPUUtilization" => {
                MetricType::ElastiCachePrimaryEngineCpuUtilization
            }
            "ElastiCacheReplicaEngineCPUUtilization" => {
                MetricType::ElastiCacheReplicaEngineCpuUtilization
            }
            "KafkaBrokerStorageUtilization" => MetricType::KafkaBrokerStorageUtilization,
            "LambdaProvisionedConcurrencyUtilization" => {
                MetricType::LambdaProvisionedConcurrencyUtilization
            }
            "NeptuneReaderAverageCPUUtilization" => MetricType::NeptuneReaderAverageCpuUtilization,
            "RDSReaderAverageCPUUtilization" => MetricType::RdsReaderAverageCpuUtilization,
            "RDSReaderAverageDatabaseConnections" => {
                MetricType::RdsReaderAverageDatabaseConnections
            }
            "SageMakerVariantInvocationsPerInstance" => {
                MetricType::SageMakerVariantInvocationsPerInstance
            }
            other => MetricType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MetricType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MetricType::from(s))
    }
}
impl MetricType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MetricType::AlbRequestCountPerTarget => "ALBRequestCountPerTarget",
            MetricType::AppStreamAverageCapacityUtilization => {
                "AppStreamAverageCapacityUtilization"
            }
            MetricType::CassandraReadCapacityUtilization => "CassandraReadCapacityUtilization",
            MetricType::CassandraWriteCapacityUtilization => "CassandraWriteCapacityUtilization",
            MetricType::ComprehendInferenceUtilization => "ComprehendInferenceUtilization",
            MetricType::DynamoDbReadCapacityUtilization => "DynamoDBReadCapacityUtilization",
            MetricType::DynamoDbWriteCapacityUtilization => "DynamoDBWriteCapacityUtilization",
            MetricType::Ec2SpotFleetRequestAverageCpuUtilization => {
                "EC2SpotFleetRequestAverageCPUUtilization"
            }
            MetricType::Ec2SpotFleetRequestAverageNetworkIn => {
                "EC2SpotFleetRequestAverageNetworkIn"
            }
            MetricType::Ec2SpotFleetRequestAverageNetworkOut => {
                "EC2SpotFleetRequestAverageNetworkOut"
            }
            MetricType::EcsServiceAverageCpuUtilization => "ECSServiceAverageCPUUtilization",
            MetricType::EcsServiceAverageMemoryUtilization => "ECSServiceAverageMemoryUtilization",
            MetricType::ElastiCacheDatabaseMemoryUsageCountedForEvictPercentage => {
                "ElastiCacheDatabaseMemoryUsageCountedForEvictPercentage"
            }
            MetricType::ElastiCachePrimaryEngineCpuUtilization => {
                "ElastiCachePrimaryEngineCPUUtilization"
            }
            MetricType::ElastiCacheReplicaEngineCpuUtilization => {
                "ElastiCacheReplicaEngineCPUUtilization"
            }
            MetricType::KafkaBrokerStorageUtilization => "KafkaBrokerStorageUtilization",
            MetricType::LambdaProvisionedConcurrencyUtilization => {
                "LambdaProvisionedConcurrencyUtilization"
            }
            MetricType::NeptuneReaderAverageCpuUtilization => "NeptuneReaderAverageCPUUtilization",
            MetricType::RdsReaderAverageCpuUtilization => "RDSReaderAverageCPUUtilization",
            MetricType::RdsReaderAverageDatabaseConnections => {
                "RDSReaderAverageDatabaseConnections"
            }
            MetricType::SageMakerVariantInvocationsPerInstance => {
                "SageMakerVariantInvocationsPerInstance"
            }
            MetricType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ALBRequestCountPerTarget",
            "AppStreamAverageCapacityUtilization",
            "CassandraReadCapacityUtilization",
            "CassandraWriteCapacityUtilization",
            "ComprehendInferenceUtilization",
            "DynamoDBReadCapacityUtilization",
            "DynamoDBWriteCapacityUtilization",
            "EC2SpotFleetRequestAverageCPUUtilization",
            "EC2SpotFleetRequestAverageNetworkIn",
            "EC2SpotFleetRequestAverageNetworkOut",
            "ECSServiceAverageCPUUtilization",
            "ECSServiceAverageMemoryUtilization",
            "ElastiCacheDatabaseMemoryUsageCountedForEvictPercentage",
            "ElastiCachePrimaryEngineCPUUtilization",
            "ElastiCacheReplicaEngineCPUUtilization",
            "KafkaBrokerStorageUtilization",
            "LambdaProvisionedConcurrencyUtilization",
            "NeptuneReaderAverageCPUUtilization",
            "RDSReaderAverageCPUUtilization",
            "RDSReaderAverageDatabaseConnections",
            "SageMakerVariantInvocationsPerInstance",
        ]
    }
}
impl AsRef<str> for MetricType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents a step scaling policy configuration to use with Application Auto Scaling.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StepScalingPolicyConfiguration {
    /// <p>Specifies how the <code>ScalingAdjustment</code> value in a <a href="https://docs.aws.amazon.com/autoscaling/application/APIReference/API_StepAdjustment.html">StepAdjustment</a> is interpreted (for example, an absolute number or a percentage). The valid values are <code>ChangeInCapacity</code>, <code>ExactCapacity</code>, and <code>PercentChangeInCapacity</code>. </p>
    /// <p> <code>AdjustmentType</code> is required if you are adding a new step scaling policy configuration.</p>
    pub adjustment_type: std::option::Option<crate::model::AdjustmentType>,
    /// <p>A set of adjustments that enable you to scale based on the size of the alarm breach.</p>
    /// <p>At least one step adjustment is required if you are adding a new step scaling policy configuration.</p>
    pub step_adjustments: std::option::Option<std::vec::Vec<crate::model::StepAdjustment>>,
    /// <p>The minimum value to scale by when the adjustment type is <code>PercentChangeInCapacity</code>. For example, suppose that you create a step scaling policy to scale out an Amazon ECS service by 25 percent and you specify a <code>MinAdjustmentMagnitude</code> of 2. If the service has 4 tasks and the scaling policy is performed, 25 percent of 4 is 1. However, because you specified a <code>MinAdjustmentMagnitude</code> of 2, Application Auto Scaling scales out the service by 2 tasks.</p>
    pub min_adjustment_magnitude: std::option::Option<i32>,
    /// <p>The amount of time, in seconds, to wait for a previous scaling activity to take effect. </p>
    /// <p>With scale-out policies, the intention is to continuously (but not excessively) scale out. After Application Auto Scaling successfully scales out using a step scaling policy, it starts to calculate the cooldown time. The scaling policy won't increase the desired capacity again unless either a larger scale out is triggered or the cooldown period ends. While the cooldown period is in effect, capacity added by the initiating scale-out activity is calculated as part of the desired capacity for the next scale-out activity. For example, when an alarm triggers a step scaling policy to increase the capacity by 2, the scaling activity completes successfully, and a cooldown period starts. If the alarm triggers again during the cooldown period but at a more aggressive step adjustment of 3, the previous increase of 2 is considered part of the current capacity. Therefore, only 1 is added to the capacity.</p>
    /// <p>With scale-in policies, the intention is to scale in conservatively to protect your application’s availability, so scale-in activities are blocked until the cooldown period has expired. However, if another alarm triggers a scale-out activity during the cooldown period after a scale-in activity, Application Auto Scaling scales out the target immediately. In this case, the cooldown period for the scale-in activity stops and doesn't complete.</p>
    /// <p>Application Auto Scaling provides a default value of 600 for Amazon ElastiCache replication groups and a default value of 300 for the following scalable targets:</p>
    /// <ul>
    /// <li> <p>AppStream 2.0 fleets</p> </li>
    /// <li> <p>Aurora DB clusters</p> </li>
    /// <li> <p>ECS services</p> </li>
    /// <li> <p>EMR clusters</p> </li>
    /// <li> <p> Neptune clusters</p> </li>
    /// <li> <p>SageMaker endpoint variants</p> </li>
    /// <li> <p>Spot Fleets</p> </li>
    /// <li> <p>Custom resources</p> </li>
    /// </ul>
    /// <p>For all other scalable targets, the default value is 0:</p>
    /// <ul>
    /// <li> <p>Amazon Comprehend document classification and entity recognizer endpoints</p> </li>
    /// <li> <p>DynamoDB tables and global secondary indexes</p> </li>
    /// <li> <p>Amazon Keyspaces tables</p> </li>
    /// <li> <p>Lambda provisioned concurrency</p> </li>
    /// <li> <p>Amazon MSK broker storage</p> </li>
    /// </ul>
    pub cooldown: std::option::Option<i32>,
    /// <p>The aggregation type for the CloudWatch metrics. Valid values are <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code>. If the aggregation type is null, the value is treated as <code>Average</code>.</p>
    pub metric_aggregation_type: std::option::Option<crate::model::MetricAggregationType>,
}
impl StepScalingPolicyConfiguration {
    /// <p>Specifies how the <code>ScalingAdjustment</code> value in a <a href="https://docs.aws.amazon.com/autoscaling/application/APIReference/API_StepAdjustment.html">StepAdjustment</a> is interpreted (for example, an absolute number or a percentage). The valid values are <code>ChangeInCapacity</code>, <code>ExactCapacity</code>, and <code>PercentChangeInCapacity</code>. </p>
    /// <p> <code>AdjustmentType</code> is required if you are adding a new step scaling policy configuration.</p>
    pub fn adjustment_type(&self) -> std::option::Option<&crate::model::AdjustmentType> {
        self.adjustment_type.as_ref()
    }
    /// <p>A set of adjustments that enable you to scale based on the size of the alarm breach.</p>
    /// <p>At least one step adjustment is required if you are adding a new step scaling policy configuration.</p>
    pub fn step_adjustments(&self) -> std::option::Option<&[crate::model::StepAdjustment]> {
        self.step_adjustments.as_deref()
    }
    /// <p>The minimum value to scale by when the adjustment type is <code>PercentChangeInCapacity</code>. For example, suppose that you create a step scaling policy to scale out an Amazon ECS service by 25 percent and you specify a <code>MinAdjustmentMagnitude</code> of 2. If the service has 4 tasks and the scaling policy is performed, 25 percent of 4 is 1. However, because you specified a <code>MinAdjustmentMagnitude</code> of 2, Application Auto Scaling scales out the service by 2 tasks.</p>
    pub fn min_adjustment_magnitude(&self) -> std::option::Option<i32> {
        self.min_adjustment_magnitude
    }
    /// <p>The amount of time, in seconds, to wait for a previous scaling activity to take effect. </p>
    /// <p>With scale-out policies, the intention is to continuously (but not excessively) scale out. After Application Auto Scaling successfully scales out using a step scaling policy, it starts to calculate the cooldown time. The scaling policy won't increase the desired capacity again unless either a larger scale out is triggered or the cooldown period ends. While the cooldown period is in effect, capacity added by the initiating scale-out activity is calculated as part of the desired capacity for the next scale-out activity. For example, when an alarm triggers a step scaling policy to increase the capacity by 2, the scaling activity completes successfully, and a cooldown period starts. If the alarm triggers again during the cooldown period but at a more aggressive step adjustment of 3, the previous increase of 2 is considered part of the current capacity. Therefore, only 1 is added to the capacity.</p>
    /// <p>With scale-in policies, the intention is to scale in conservatively to protect your application’s availability, so scale-in activities are blocked until the cooldown period has expired. However, if another alarm triggers a scale-out activity during the cooldown period after a scale-in activity, Application Auto Scaling scales out the target immediately. In this case, the cooldown period for the scale-in activity stops and doesn't complete.</p>
    /// <p>Application Auto Scaling provides a default value of 600 for Amazon ElastiCache replication groups and a default value of 300 for the following scalable targets:</p>
    /// <ul>
    /// <li> <p>AppStream 2.0 fleets</p> </li>
    /// <li> <p>Aurora DB clusters</p> </li>
    /// <li> <p>ECS services</p> </li>
    /// <li> <p>EMR clusters</p> </li>
    /// <li> <p> Neptune clusters</p> </li>
    /// <li> <p>SageMaker endpoint variants</p> </li>
    /// <li> <p>Spot Fleets</p> </li>
    /// <li> <p>Custom resources</p> </li>
    /// </ul>
    /// <p>For all other scalable targets, the default value is 0:</p>
    /// <ul>
    /// <li> <p>Amazon Comprehend document classification and entity recognizer endpoints</p> </li>
    /// <li> <p>DynamoDB tables and global secondary indexes</p> </li>
    /// <li> <p>Amazon Keyspaces tables</p> </li>
    /// <li> <p>Lambda provisioned concurrency</p> </li>
    /// <li> <p>Amazon MSK broker storage</p> </li>
    /// </ul>
    pub fn cooldown(&self) -> std::option::Option<i32> {
        self.cooldown
    }
    /// <p>The aggregation type for the CloudWatch metrics. Valid values are <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code>. If the aggregation type is null, the value is treated as <code>Average</code>.</p>
    pub fn metric_aggregation_type(
        &self,
    ) -> std::option::Option<&crate::model::MetricAggregationType> {
        self.metric_aggregation_type.as_ref()
    }
}
impl std::fmt::Debug for StepScalingPolicyConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StepScalingPolicyConfiguration");
        formatter.field("adjustment_type", &self.adjustment_type);
        formatter.field("step_adjustments", &self.step_adjustments);
        formatter.field("min_adjustment_magnitude", &self.min_adjustment_magnitude);
        formatter.field("cooldown", &self.cooldown);
        formatter.field("metric_aggregation_type", &self.metric_aggregation_type);
        formatter.finish()
    }
}
/// See [`StepScalingPolicyConfiguration`](crate::model::StepScalingPolicyConfiguration)
pub mod step_scaling_policy_configuration {
    /// A builder for [`StepScalingPolicyConfiguration`](crate::model::StepScalingPolicyConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) adjustment_type: std::option::Option<crate::model::AdjustmentType>,
        pub(crate) step_adjustments:
            std::option::Option<std::vec::Vec<crate::model::StepAdjustment>>,
        pub(crate) min_adjustment_magnitude: std::option::Option<i32>,
        pub(crate) cooldown: std::option::Option<i32>,
        pub(crate) metric_aggregation_type:
            std::option::Option<crate::model::MetricAggregationType>,
    }
    impl Builder {
        /// <p>Specifies how the <code>ScalingAdjustment</code> value in a <a href="https://docs.aws.amazon.com/autoscaling/application/APIReference/API_StepAdjustment.html">StepAdjustment</a> is interpreted (for example, an absolute number or a percentage). The valid values are <code>ChangeInCapacity</code>, <code>ExactCapacity</code>, and <code>PercentChangeInCapacity</code>. </p>
        /// <p> <code>AdjustmentType</code> is required if you are adding a new step scaling policy configuration.</p>
        pub fn adjustment_type(mut self, input: crate::model::AdjustmentType) -> Self {
            self.adjustment_type = Some(input);
            self
        }
        /// <p>Specifies how the <code>ScalingAdjustment</code> value in a <a href="https://docs.aws.amazon.com/autoscaling/application/APIReference/API_StepAdjustment.html">StepAdjustment</a> is interpreted (for example, an absolute number or a percentage). The valid values are <code>ChangeInCapacity</code>, <code>ExactCapacity</code>, and <code>PercentChangeInCapacity</code>. </p>
        /// <p> <code>AdjustmentType</code> is required if you are adding a new step scaling policy configuration.</p>
        pub fn set_adjustment_type(
            mut self,
            input: std::option::Option<crate::model::AdjustmentType>,
        ) -> Self {
            self.adjustment_type = input;
            self
        }
        /// Appends an item to `step_adjustments`.
        ///
        /// To override the contents of this collection use [`set_step_adjustments`](Self::set_step_adjustments).
        ///
        /// <p>A set of adjustments that enable you to scale based on the size of the alarm breach.</p>
        /// <p>At least one step adjustment is required if you are adding a new step scaling policy configuration.</p>
        pub fn step_adjustments(mut self, input: crate::model::StepAdjustment) -> Self {
            let mut v = self.step_adjustments.unwrap_or_default();
            v.push(input);
            self.step_adjustments = Some(v);
            self
        }
        /// <p>A set of adjustments that enable you to scale based on the size of the alarm breach.</p>
        /// <p>At least one step adjustment is required if you are adding a new step scaling policy configuration.</p>
        pub fn set_step_adjustments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StepAdjustment>>,
        ) -> Self {
            self.step_adjustments = input;
            self
        }
        /// <p>The minimum value to scale by when the adjustment type is <code>PercentChangeInCapacity</code>. For example, suppose that you create a step scaling policy to scale out an Amazon ECS service by 25 percent and you specify a <code>MinAdjustmentMagnitude</code> of 2. If the service has 4 tasks and the scaling policy is performed, 25 percent of 4 is 1. However, because you specified a <code>MinAdjustmentMagnitude</code> of 2, Application Auto Scaling scales out the service by 2 tasks.</p>
        pub fn min_adjustment_magnitude(mut self, input: i32) -> Self {
            self.min_adjustment_magnitude = Some(input);
            self
        }
        /// <p>The minimum value to scale by when the adjustment type is <code>PercentChangeInCapacity</code>. For example, suppose that you create a step scaling policy to scale out an Amazon ECS service by 25 percent and you specify a <code>MinAdjustmentMagnitude</code> of 2. If the service has 4 tasks and the scaling policy is performed, 25 percent of 4 is 1. However, because you specified a <code>MinAdjustmentMagnitude</code> of 2, Application Auto Scaling scales out the service by 2 tasks.</p>
        pub fn set_min_adjustment_magnitude(mut self, input: std::option::Option<i32>) -> Self {
            self.min_adjustment_magnitude = input;
            self
        }
        /// <p>The amount of time, in seconds, to wait for a previous scaling activity to take effect. </p>
        /// <p>With scale-out policies, the intention is to continuously (but not excessively) scale out. After Application Auto Scaling successfully scales out using a step scaling policy, it starts to calculate the cooldown time. The scaling policy won't increase the desired capacity again unless either a larger scale out is triggered or the cooldown period ends. While the cooldown period is in effect, capacity added by the initiating scale-out activity is calculated as part of the desired capacity for the next scale-out activity. For example, when an alarm triggers a step scaling policy to increase the capacity by 2, the scaling activity completes successfully, and a cooldown period starts. If the alarm triggers again during the cooldown period but at a more aggressive step adjustment of 3, the previous increase of 2 is considered part of the current capacity. Therefore, only 1 is added to the capacity.</p>
        /// <p>With scale-in policies, the intention is to scale in conservatively to protect your application’s availability, so scale-in activities are blocked until the cooldown period has expired. However, if another alarm triggers a scale-out activity during the cooldown period after a scale-in activity, Application Auto Scaling scales out the target immediately. In this case, the cooldown period for the scale-in activity stops and doesn't complete.</p>
        /// <p>Application Auto Scaling provides a default value of 600 for Amazon ElastiCache replication groups and a default value of 300 for the following scalable targets:</p>
        /// <ul>
        /// <li> <p>AppStream 2.0 fleets</p> </li>
        /// <li> <p>Aurora DB clusters</p> </li>
        /// <li> <p>ECS services</p> </li>
        /// <li> <p>EMR clusters</p> </li>
        /// <li> <p> Neptune clusters</p> </li>
        /// <li> <p>SageMaker endpoint variants</p> </li>
        /// <li> <p>Spot Fleets</p> </li>
        /// <li> <p>Custom resources</p> </li>
        /// </ul>
        /// <p>For all other scalable targets, the default value is 0:</p>
        /// <ul>
        /// <li> <p>Amazon Comprehend document classification and entity recognizer endpoints</p> </li>
        /// <li> <p>DynamoDB tables and global secondary indexes</p> </li>
        /// <li> <p>Amazon Keyspaces tables</p> </li>
        /// <li> <p>Lambda provisioned concurrency</p> </li>
        /// <li> <p>Amazon MSK broker storage</p> </li>
        /// </ul>
        pub fn cooldown(mut self, input: i32) -> Self {
            self.cooldown = Some(input);
            self
        }
        /// <p>The amount of time, in seconds, to wait for a previous scaling activity to take effect. </p>
        /// <p>With scale-out policies, the intention is to continuously (but not excessively) scale out. After Application Auto Scaling successfully scales out using a step scaling policy, it starts to calculate the cooldown time. The scaling policy won't increase the desired capacity again unless either a larger scale out is triggered or the cooldown period ends. While the cooldown period is in effect, capacity added by the initiating scale-out activity is calculated as part of the desired capacity for the next scale-out activity. For example, when an alarm triggers a step scaling policy to increase the capacity by 2, the scaling activity completes successfully, and a cooldown period starts. If the alarm triggers again during the cooldown period but at a more aggressive step adjustment of 3, the previous increase of 2 is considered part of the current capacity. Therefore, only 1 is added to the capacity.</p>
        /// <p>With scale-in policies, the intention is to scale in conservatively to protect your application’s availability, so scale-in activities are blocked until the cooldown period has expired. However, if another alarm triggers a scale-out activity during the cooldown period after a scale-in activity, Application Auto Scaling scales out the target immediately. In this case, the cooldown period for the scale-in activity stops and doesn't complete.</p>
        /// <p>Application Auto Scaling provides a default value of 600 for Amazon ElastiCache replication groups and a default value of 300 for the following scalable targets:</p>
        /// <ul>
        /// <li> <p>AppStream 2.0 fleets</p> </li>
        /// <li> <p>Aurora DB clusters</p> </li>
        /// <li> <p>ECS services</p> </li>
        /// <li> <p>EMR clusters</p> </li>
        /// <li> <p> Neptune clusters</p> </li>
        /// <li> <p>SageMaker endpoint variants</p> </li>
        /// <li> <p>Spot Fleets</p> </li>
        /// <li> <p>Custom resources</p> </li>
        /// </ul>
        /// <p>For all other scalable targets, the default value is 0:</p>
        /// <ul>
        /// <li> <p>Amazon Comprehend document classification and entity recognizer endpoints</p> </li>
        /// <li> <p>DynamoDB tables and global secondary indexes</p> </li>
        /// <li> <p>Amazon Keyspaces tables</p> </li>
        /// <li> <p>Lambda provisioned concurrency</p> </li>
        /// <li> <p>Amazon MSK broker storage</p> </li>
        /// </ul>
        pub fn set_cooldown(mut self, input: std::option::Option<i32>) -> Self {
            self.cooldown = input;
            self
        }
        /// <p>The aggregation type for the CloudWatch metrics. Valid values are <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code>. If the aggregation type is null, the value is treated as <code>Average</code>.</p>
        pub fn metric_aggregation_type(
            mut self,
            input: crate::model::MetricAggregationType,
        ) -> Self {
            self.metric_aggregation_type = Some(input);
            self
        }
        /// <p>The aggregation type for the CloudWatch metrics. Valid values are <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code>. If the aggregation type is null, the value is treated as <code>Average</code>.</p>
        pub fn set_metric_aggregation_type(
            mut self,
            input: std::option::Option<crate::model::MetricAggregationType>,
        ) -> Self {
            self.metric_aggregation_type = input;
            self
        }
        /// Consumes the builder and constructs a [`StepScalingPolicyConfiguration`](crate::model::StepScalingPolicyConfiguration)
        pub fn build(self) -> crate::model::StepScalingPolicyConfiguration {
            crate::model::StepScalingPolicyConfiguration {
                adjustment_type: self.adjustment_type,
                step_adjustments: self.step_adjustments,
                min_adjustment_magnitude: self.min_adjustment_magnitude,
                cooldown: self.cooldown,
                metric_aggregation_type: self.metric_aggregation_type,
            }
        }
    }
}
impl StepScalingPolicyConfiguration {
    /// Creates a new builder-style object to manufacture [`StepScalingPolicyConfiguration`](crate::model::StepScalingPolicyConfiguration)
    pub fn builder() -> crate::model::step_scaling_policy_configuration::Builder {
        crate::model::step_scaling_policy_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MetricAggregationType {
    #[allow(missing_docs)] // documentation missing in model
    Average,
    #[allow(missing_docs)] // documentation missing in model
    Maximum,
    #[allow(missing_docs)] // documentation missing in model
    Minimum,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MetricAggregationType {
    fn from(s: &str) -> Self {
        match s {
            "Average" => MetricAggregationType::Average,
            "Maximum" => MetricAggregationType::Maximum,
            "Minimum" => MetricAggregationType::Minimum,
            other => MetricAggregationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MetricAggregationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MetricAggregationType::from(s))
    }
}
impl MetricAggregationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MetricAggregationType::Average => "Average",
            MetricAggregationType::Maximum => "Maximum",
            MetricAggregationType::Minimum => "Minimum",
            MetricAggregationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Average", "Maximum", "Minimum"]
    }
}
impl AsRef<str> for MetricAggregationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents a step adjustment for a <a href="https://docs.aws.amazon.com/autoscaling/application/APIReference/API_StepScalingPolicyConfiguration.html">StepScalingPolicyConfiguration</a>. Describes an adjustment based on the difference between the value of the aggregated CloudWatch metric and the breach threshold that you've defined for the alarm. </p>
/// <p>For the following examples, suppose that you have an alarm with a breach threshold of 50:</p>
/// <ul>
/// <li> <p>To trigger the adjustment when the metric is greater than or equal to 50 and less than 60, specify a lower bound of 0 and an upper bound of 10.</p> </li>
/// <li> <p>To trigger the adjustment when the metric is greater than 40 and less than or equal to 50, specify a lower bound of -10 and an upper bound of 0.</p> </li>
/// </ul>
/// <p>There are a few rules for the step adjustments for your step policy:</p>
/// <ul>
/// <li> <p>The ranges of your step adjustments can't overlap or have a gap.</p> </li>
/// <li> <p>At most one step adjustment can have a null lower bound. If one step adjustment has a negative lower bound, then there must be a step adjustment with a null lower bound.</p> </li>
/// <li> <p>At most one step adjustment can have a null upper bound. If one step adjustment has a positive upper bound, then there must be a step adjustment with a null upper bound.</p> </li>
/// <li> <p>The upper and lower bound can't be null in the same step adjustment.</p> </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StepAdjustment {
    /// <p>The lower bound for the difference between the alarm threshold and the CloudWatch metric. If the metric value is above the breach threshold, the lower bound is inclusive (the metric must be greater than or equal to the threshold plus the lower bound). Otherwise, it is exclusive (the metric must be greater than the threshold plus the lower bound). A null value indicates negative infinity.</p>
    pub metric_interval_lower_bound: std::option::Option<f64>,
    /// <p>The upper bound for the difference between the alarm threshold and the CloudWatch metric. If the metric value is above the breach threshold, the upper bound is exclusive (the metric must be less than the threshold plus the upper bound). Otherwise, it is inclusive (the metric must be less than or equal to the threshold plus the upper bound). A null value indicates positive infinity.</p>
    /// <p>The upper bound must be greater than the lower bound.</p>
    pub metric_interval_upper_bound: std::option::Option<f64>,
    /// <p>The amount by which to scale, based on the specified adjustment type. A positive value adds to the current capacity while a negative number removes from the current capacity. For exact capacity, you must specify a positive value.</p>
    pub scaling_adjustment: std::option::Option<i32>,
}
impl StepAdjustment {
    /// <p>The lower bound for the difference between the alarm threshold and the CloudWatch metric. If the metric value is above the breach threshold, the lower bound is inclusive (the metric must be greater than or equal to the threshold plus the lower bound). Otherwise, it is exclusive (the metric must be greater than the threshold plus the lower bound). A null value indicates negative infinity.</p>
    pub fn metric_interval_lower_bound(&self) -> std::option::Option<f64> {
        self.metric_interval_lower_bound
    }
    /// <p>The upper bound for the difference between the alarm threshold and the CloudWatch metric. If the metric value is above the breach threshold, the upper bound is exclusive (the metric must be less than the threshold plus the upper bound). Otherwise, it is inclusive (the metric must be less than or equal to the threshold plus the upper bound). A null value indicates positive infinity.</p>
    /// <p>The upper bound must be greater than the lower bound.</p>
    pub fn metric_interval_upper_bound(&self) -> std::option::Option<f64> {
        self.metric_interval_upper_bound
    }
    /// <p>The amount by which to scale, based on the specified adjustment type. A positive value adds to the current capacity while a negative number removes from the current capacity. For exact capacity, you must specify a positive value.</p>
    pub fn scaling_adjustment(&self) -> std::option::Option<i32> {
        self.scaling_adjustment
    }
}
impl std::fmt::Debug for StepAdjustment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StepAdjustment");
        formatter.field(
            "metric_interval_lower_bound",
            &self.metric_interval_lower_bound,
        );
        formatter.field(
            "metric_interval_upper_bound",
            &self.metric_interval_upper_bound,
        );
        formatter.field("scaling_adjustment", &self.scaling_adjustment);
        formatter.finish()
    }
}
/// See [`StepAdjustment`](crate::model::StepAdjustment)
pub mod step_adjustment {
    /// A builder for [`StepAdjustment`](crate::model::StepAdjustment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric_interval_lower_bound: std::option::Option<f64>,
        pub(crate) metric_interval_upper_bound: std::option::Option<f64>,
        pub(crate) scaling_adjustment: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The lower bound for the difference between the alarm threshold and the CloudWatch metric. If the metric value is above the breach threshold, the lower bound is inclusive (the metric must be greater than or equal to the threshold plus the lower bound). Otherwise, it is exclusive (the metric must be greater than the threshold plus the lower bound). A null value indicates negative infinity.</p>
        pub fn metric_interval_lower_bound(mut self, input: f64) -> Self {
            self.metric_interval_lower_bound = Some(input);
            self
        }
        /// <p>The lower bound for the difference between the alarm threshold and the CloudWatch metric. If the metric value is above the breach threshold, the lower bound is inclusive (the metric must be greater than or equal to the threshold plus the lower bound). Otherwise, it is exclusive (the metric must be greater than the threshold plus the lower bound). A null value indicates negative infinity.</p>
        pub fn set_metric_interval_lower_bound(mut self, input: std::option::Option<f64>) -> Self {
            self.metric_interval_lower_bound = input;
            self
        }
        /// <p>The upper bound for the difference between the alarm threshold and the CloudWatch metric. If the metric value is above the breach threshold, the upper bound is exclusive (the metric must be less than the threshold plus the upper bound). Otherwise, it is inclusive (the metric must be less than or equal to the threshold plus the upper bound). A null value indicates positive infinity.</p>
        /// <p>The upper bound must be greater than the lower bound.</p>
        pub fn metric_interval_upper_bound(mut self, input: f64) -> Self {
            self.metric_interval_upper_bound = Some(input);
            self
        }
        /// <p>The upper bound for the difference between the alarm threshold and the CloudWatch metric. If the metric value is above the breach threshold, the upper bound is exclusive (the metric must be less than the threshold plus the upper bound). Otherwise, it is inclusive (the metric must be less than or equal to the threshold plus the upper bound). A null value indicates positive infinity.</p>
        /// <p>The upper bound must be greater than the lower bound.</p>
        pub fn set_metric_interval_upper_bound(mut self, input: std::option::Option<f64>) -> Self {
            self.metric_interval_upper_bound = input;
            self
        }
        /// <p>The amount by which to scale, based on the specified adjustment type. A positive value adds to the current capacity while a negative number removes from the current capacity. For exact capacity, you must specify a positive value.</p>
        pub fn scaling_adjustment(mut self, input: i32) -> Self {
            self.scaling_adjustment = Some(input);
            self
        }
        /// <p>The amount by which to scale, based on the specified adjustment type. A positive value adds to the current capacity while a negative number removes from the current capacity. For exact capacity, you must specify a positive value.</p>
        pub fn set_scaling_adjustment(mut self, input: std::option::Option<i32>) -> Self {
            self.scaling_adjustment = input;
            self
        }
        /// Consumes the builder and constructs a [`StepAdjustment`](crate::model::StepAdjustment)
        pub fn build(self) -> crate::model::StepAdjustment {
            crate::model::StepAdjustment {
                metric_interval_lower_bound: self.metric_interval_lower_bound,
                metric_interval_upper_bound: self.metric_interval_upper_bound,
                scaling_adjustment: self.scaling_adjustment,
            }
        }
    }
}
impl StepAdjustment {
    /// Creates a new builder-style object to manufacture [`StepAdjustment`](crate::model::StepAdjustment)
    pub fn builder() -> crate::model::step_adjustment::Builder {
        crate::model::step_adjustment::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AdjustmentType {
    #[allow(missing_docs)] // documentation missing in model
    ChangeInCapacity,
    #[allow(missing_docs)] // documentation missing in model
    ExactCapacity,
    #[allow(missing_docs)] // documentation missing in model
    PercentChangeInCapacity,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AdjustmentType {
    fn from(s: &str) -> Self {
        match s {
            "ChangeInCapacity" => AdjustmentType::ChangeInCapacity,
            "ExactCapacity" => AdjustmentType::ExactCapacity,
            "PercentChangeInCapacity" => AdjustmentType::PercentChangeInCapacity,
            other => AdjustmentType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AdjustmentType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AdjustmentType::from(s))
    }
}
impl AdjustmentType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AdjustmentType::ChangeInCapacity => "ChangeInCapacity",
            AdjustmentType::ExactCapacity => "ExactCapacity",
            AdjustmentType::PercentChangeInCapacity => "PercentChangeInCapacity",
            AdjustmentType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ChangeInCapacity",
            "ExactCapacity",
            "PercentChangeInCapacity",
        ]
    }
}
impl AsRef<str> for AdjustmentType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PolicyType {
    #[allow(missing_docs)] // documentation missing in model
    StepScaling,
    #[allow(missing_docs)] // documentation missing in model
    TargetTrackingScaling,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PolicyType {
    fn from(s: &str) -> Self {
        match s {
            "StepScaling" => PolicyType::StepScaling,
            "TargetTrackingScaling" => PolicyType::TargetTrackingScaling,
            other => PolicyType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PolicyType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PolicyType::from(s))
    }
}
impl PolicyType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PolicyType::StepScaling => "StepScaling",
            PolicyType::TargetTrackingScaling => "TargetTrackingScaling",
            PolicyType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["StepScaling", "TargetTrackingScaling"]
    }
}
impl AsRef<str> for PolicyType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents a scheduled action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScheduledAction {
    /// <p>The name of the scheduled action.</p>
    pub scheduled_action_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the scheduled action.</p>
    pub scheduled_action_arn: std::option::Option<std::string::String>,
    /// <p>The namespace of the Amazon Web Services service that provides the resource, or a <code>custom-resource</code>.</p>
    pub service_namespace: std::option::Option<crate::model::ServiceNamespace>,
    /// <p>The schedule for this action. The following formats are supported:</p>
    /// <ul>
    /// <li> <p>At expressions - "<code>at(<i>yyyy</i>-<i>mm</i>-<i>dd</i>T<i>hh</i>:<i>mm</i>:<i>ss</i>)</code>"</p> </li>
    /// <li> <p>Rate expressions - "<code>rate(<i>value</i> <i>unit</i>)</code>"</p> </li>
    /// <li> <p>Cron expressions - "<code>cron(<i>fields</i>)</code>"</p> </li>
    /// </ul>
    /// <p>At expressions are useful for one-time schedules. Cron expressions are useful for scheduled actions that run periodically at a specified date and time, and rate expressions are useful for scheduled actions that run at a regular interval.</p>
    /// <p>At and cron expressions use Universal Coordinated Time (UTC) by default.</p>
    /// <p>The cron format consists of six fields separated by white spaces: [Minutes] [Hours] [Day_of_Month] [Month] [Day_of_Week] [Year].</p>
    /// <p>For rate expressions, <i>value</i> is a positive integer and <i>unit</i> is <code>minute</code> | <code>minutes</code> | <code>hour</code> | <code>hours</code> | <code>day</code> | <code>days</code>.</p>
    /// <p>For more information and examples, see <a href="https://docs.aws.amazon.com/autoscaling/application/userguide/examples-scheduled-actions.html">Example scheduled actions for Application Auto Scaling</a> in the <i>Application Auto Scaling User Guide</i>.</p>
    pub schedule: std::option::Option<std::string::String>,
    /// <p>The time zone used when referring to the date and time of a scheduled action, when the scheduled action uses an at or cron expression.</p>
    pub timezone: std::option::Option<std::string::String>,
    /// <p>The identifier of the resource associated with the scaling policy. This string consists of the resource type and unique identifier.</p>
    /// <ul>
    /// <li> <p>ECS service - The resource type is <code>service</code> and the unique identifier is the cluster name and service name. Example: <code>service/default/sample-webapp</code>.</p> </li>
    /// <li> <p>Spot Fleet - The resource type is <code>spot-fleet-request</code> and the unique identifier is the Spot Fleet request ID. Example: <code>spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE</code>.</p> </li>
    /// <li> <p>EMR cluster - The resource type is <code>instancegroup</code> and the unique identifier is the cluster ID and instance group ID. Example: <code>instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0</code>.</p> </li>
    /// <li> <p>AppStream 2.0 fleet - The resource type is <code>fleet</code> and the unique identifier is the fleet name. Example: <code>fleet/sample-fleet</code>.</p> </li>
    /// <li> <p>DynamoDB table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>table/my-table</code>.</p> </li>
    /// <li> <p>DynamoDB global secondary index - The resource type is <code>index</code> and the unique identifier is the index name. Example: <code>table/my-table/index/my-table-index</code>.</p> </li>
    /// <li> <p>Aurora DB cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:my-db-cluster</code>.</p> </li>
    /// <li> <p>SageMaker endpoint variant - The resource type is <code>variant</code> and the unique identifier is the resource ID. Example: <code>endpoint/my-end-point/variant/KMeansClustering</code>.</p> </li>
    /// <li> <p>Custom resources are not supported with a resource type. This parameter must specify the <code>OutputValue</code> from the CloudFormation template stack used to access the resources. The unique identifier is defined by the service provider. More information is available in our <a href="https://github.com/aws/aws-auto-scaling-custom-resource">GitHub repository</a>.</p> </li>
    /// <li> <p>Amazon Comprehend document classification endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: <code>arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE</code>.</p> </li>
    /// <li> <p>Amazon Comprehend entity recognizer endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: <code>arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE</code>.</p> </li>
    /// <li> <p>Lambda provisioned concurrency - The resource type is <code>function</code> and the unique identifier is the function name with a function version or alias name suffix that is not <code>$LATEST</code>. Example: <code>function:my-function:prod</code> or <code>function:my-function:1</code>.</p> </li>
    /// <li> <p>Amazon Keyspaces table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>keyspace/mykeyspace/table/mytable</code>.</p> </li>
    /// <li> <p>Amazon MSK cluster - The resource type and unique identifier are specified using the cluster ARN. Example: <code>arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5</code>.</p> </li>
    /// <li> <p>Amazon ElastiCache replication group - The resource type is <code>replication-group</code> and the unique identifier is the replication group name. Example: <code>replication-group/mycluster</code>.</p> </li>
    /// <li> <p>Neptune cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:mycluster</code>.</p> </li>
    /// </ul>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The scalable dimension. This string consists of the service namespace, resource type, and scaling property.</p>
    /// <ul>
    /// <li> <p> <code>ecs:service:DesiredCount</code> - The desired task count of an ECS service.</p> </li>
    /// <li> <p> <code>elasticmapreduce:instancegroup:InstanceCount</code> - The instance count of an EMR Instance Group.</p> </li>
    /// <li> <p> <code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet.</p> </li>
    /// <li> <p> <code>appstream:fleet:DesiredCapacity</code> - The desired capacity of an AppStream 2.0 fleet.</p> </li>
    /// <li> <p> <code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table.</p> </li>
    /// <li> <p> <code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table.</p> </li>
    /// <li> <p> <code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global secondary index.</p> </li>
    /// <li> <p> <code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global secondary index.</p> </li>
    /// <li> <p> <code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.</p> </li>
    /// <li> <p> <code>sagemaker:variant:DesiredInstanceCount</code> - The number of EC2 instances for an SageMaker model endpoint variant.</p> </li>
    /// <li> <p> <code>custom-resource:ResourceType:Property</code> - The scalable dimension for a custom resource provided by your own application or service.</p> </li>
    /// <li> <p> <code>comprehend:document-classifier-endpoint:DesiredInferenceUnits</code> - The number of inference units for an Amazon Comprehend document classification endpoint.</p> </li>
    /// <li> <p> <code>comprehend:entity-recognizer-endpoint:DesiredInferenceUnits</code> - The number of inference units for an Amazon Comprehend entity recognizer endpoint.</p> </li>
    /// <li> <p> <code>lambda:function:ProvisionedConcurrency</code> - The provisioned concurrency for a Lambda function.</p> </li>
    /// <li> <p> <code>cassandra:table:ReadCapacityUnits</code> - The provisioned read capacity for an Amazon Keyspaces table.</p> </li>
    /// <li> <p> <code>cassandra:table:WriteCapacityUnits</code> - The provisioned write capacity for an Amazon Keyspaces table.</p> </li>
    /// <li> <p> <code>kafka:broker-storage:VolumeSize</code> - The provisioned volume size (in GiB) for brokers in an Amazon MSK cluster.</p> </li>
    /// <li> <p> <code>elasticache:replication-group:NodeGroups</code> - The number of node groups for an Amazon ElastiCache replication group.</p> </li>
    /// <li> <p> <code>elasticache:replication-group:Replicas</code> - The number of replicas per node group for an Amazon ElastiCache replication group.</p> </li>
    /// <li> <p> <code>neptune:cluster:ReadReplicaCount</code> - The count of read replicas in an Amazon Neptune DB cluster.</p> </li>
    /// </ul>
    pub scalable_dimension: std::option::Option<crate::model::ScalableDimension>,
    /// <p>The date and time that the action is scheduled to begin, in UTC.</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time that the action is scheduled to end, in UTC.</p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The new minimum and maximum capacity. You can set both values or just one. At the scheduled time, if the current capacity is below the minimum capacity, Application Auto Scaling scales out to the minimum capacity. If the current capacity is above the maximum capacity, Application Auto Scaling scales in to the maximum capacity.</p>
    pub scalable_target_action: std::option::Option<crate::model::ScalableTargetAction>,
    /// <p>The date and time that the scheduled action was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl ScheduledAction {
    /// <p>The name of the scheduled action.</p>
    pub fn scheduled_action_name(&self) -> std::option::Option<&str> {
        self.scheduled_action_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the scheduled action.</p>
    pub fn scheduled_action_arn(&self) -> std::option::Option<&str> {
        self.scheduled_action_arn.as_deref()
    }
    /// <p>The namespace of the Amazon Web Services service that provides the resource, or a <code>custom-resource</code>.</p>
    pub fn service_namespace(&self) -> std::option::Option<&crate::model::ServiceNamespace> {
        self.service_namespace.as_ref()
    }
    /// <p>The schedule for this action. The following formats are supported:</p>
    /// <ul>
    /// <li> <p>At expressions - "<code>at(<i>yyyy</i>-<i>mm</i>-<i>dd</i>T<i>hh</i>:<i>mm</i>:<i>ss</i>)</code>"</p> </li>
    /// <li> <p>Rate expressions - "<code>rate(<i>value</i> <i>unit</i>)</code>"</p> </li>
    /// <li> <p>Cron expressions - "<code>cron(<i>fields</i>)</code>"</p> </li>
    /// </ul>
    /// <p>At expressions are useful for one-time schedules. Cron expressions are useful for scheduled actions that run periodically at a specified date and time, and rate expressions are useful for scheduled actions that run at a regular interval.</p>
    /// <p>At and cron expressions use Universal Coordinated Time (UTC) by default.</p>
    /// <p>The cron format consists of six fields separated by white spaces: [Minutes] [Hours] [Day_of_Month] [Month] [Day_of_Week] [Year].</p>
    /// <p>For rate expressions, <i>value</i> is a positive integer and <i>unit</i> is <code>minute</code> | <code>minutes</code> | <code>hour</code> | <code>hours</code> | <code>day</code> | <code>days</code>.</p>
    /// <p>For more information and examples, see <a href="https://docs.aws.amazon.com/autoscaling/application/userguide/examples-scheduled-actions.html">Example scheduled actions for Application Auto Scaling</a> in the <i>Application Auto Scaling User Guide</i>.</p>
    pub fn schedule(&self) -> std::option::Option<&str> {
        self.schedule.as_deref()
    }
    /// <p>The time zone used when referring to the date and time of a scheduled action, when the scheduled action uses an at or cron expression.</p>
    pub fn timezone(&self) -> std::option::Option<&str> {
        self.timezone.as_deref()
    }
    /// <p>The identifier of the resource associated with the scaling policy. This string consists of the resource type and unique identifier.</p>
    /// <ul>
    /// <li> <p>ECS service - The resource type is <code>service</code> and the unique identifier is the cluster name and service name. Example: <code>service/default/sample-webapp</code>.</p> </li>
    /// <li> <p>Spot Fleet - The resource type is <code>spot-fleet-request</code> and the unique identifier is the Spot Fleet request ID. Example: <code>spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE</code>.</p> </li>
    /// <li> <p>EMR cluster - The resource type is <code>instancegroup</code> and the unique identifier is the cluster ID and instance group ID. Example: <code>instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0</code>.</p> </li>
    /// <li> <p>AppStream 2.0 fleet - The resource type is <code>fleet</code> and the unique identifier is the fleet name. Example: <code>fleet/sample-fleet</code>.</p> </li>
    /// <li> <p>DynamoDB table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>table/my-table</code>.</p> </li>
    /// <li> <p>DynamoDB global secondary index - The resource type is <code>index</code> and the unique identifier is the index name. Example: <code>table/my-table/index/my-table-index</code>.</p> </li>
    /// <li> <p>Aurora DB cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:my-db-cluster</code>.</p> </li>
    /// <li> <p>SageMaker endpoint variant - The resource type is <code>variant</code> and the unique identifier is the resource ID. Example: <code>endpoint/my-end-point/variant/KMeansClustering</code>.</p> </li>
    /// <li> <p>Custom resources are not supported with a resource type. This parameter must specify the <code>OutputValue</code> from the CloudFormation template stack used to access the resources. The unique identifier is defined by the service provider. More information is available in our <a href="https://github.com/aws/aws-auto-scaling-custom-resource">GitHub repository</a>.</p> </li>
    /// <li> <p>Amazon Comprehend document classification endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: <code>arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE</code>.</p> </li>
    /// <li> <p>Amazon Comprehend entity recognizer endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: <code>arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE</code>.</p> </li>
    /// <li> <p>Lambda provisioned concurrency - The resource type is <code>function</code> and the unique identifier is the function name with a function version or alias name suffix that is not <code>$LATEST</code>. Example: <code>function:my-function:prod</code> or <code>function:my-function:1</code>.</p> </li>
    /// <li> <p>Amazon Keyspaces table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>keyspace/mykeyspace/table/mytable</code>.</p> </li>
    /// <li> <p>Amazon MSK cluster - The resource type and unique identifier are specified using the cluster ARN. Example: <code>arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5</code>.</p> </li>
    /// <li> <p>Amazon ElastiCache replication group - The resource type is <code>replication-group</code> and the unique identifier is the replication group name. Example: <code>replication-group/mycluster</code>.</p> </li>
    /// <li> <p>Neptune cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:mycluster</code>.</p> </li>
    /// </ul>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The scalable dimension. This string consists of the service namespace, resource type, and scaling property.</p>
    /// <ul>
    /// <li> <p> <code>ecs:service:DesiredCount</code> - The desired task count of an ECS service.</p> </li>
    /// <li> <p> <code>elasticmapreduce:instancegroup:InstanceCount</code> - The instance count of an EMR Instance Group.</p> </li>
    /// <li> <p> <code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet.</p> </li>
    /// <li> <p> <code>appstream:fleet:DesiredCapacity</code> - The desired capacity of an AppStream 2.0 fleet.</p> </li>
    /// <li> <p> <code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table.</p> </li>
    /// <li> <p> <code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table.</p> </li>
    /// <li> <p> <code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global secondary index.</p> </li>
    /// <li> <p> <code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global secondary index.</p> </li>
    /// <li> <p> <code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.</p> </li>
    /// <li> <p> <code>sagemaker:variant:DesiredInstanceCount</code> - The number of EC2 instances for an SageMaker model endpoint variant.</p> </li>
    /// <li> <p> <code>custom-resource:ResourceType:Property</code> - The scalable dimension for a custom resource provided by your own application or service.</p> </li>
    /// <li> <p> <code>comprehend:document-classifier-endpoint:DesiredInferenceUnits</code> - The number of inference units for an Amazon Comprehend document classification endpoint.</p> </li>
    /// <li> <p> <code>comprehend:entity-recognizer-endpoint:DesiredInferenceUnits</code> - The number of inference units for an Amazon Comprehend entity recognizer endpoint.</p> </li>
    /// <li> <p> <code>lambda:function:ProvisionedConcurrency</code> - The provisioned concurrency for a Lambda function.</p> </li>
    /// <li> <p> <code>cassandra:table:ReadCapacityUnits</code> - The provisioned read capacity for an Amazon Keyspaces table.</p> </li>
    /// <li> <p> <code>cassandra:table:WriteCapacityUnits</code> - The provisioned write capacity for an Amazon Keyspaces table.</p> </li>
    /// <li> <p> <code>kafka:broker-storage:VolumeSize</code> - The provisioned volume size (in GiB) for brokers in an Amazon MSK cluster.</p> </li>
    /// <li> <p> <code>elasticache:replication-group:NodeGroups</code> - The number of node groups for an Amazon ElastiCache replication group.</p> </li>
    /// <li> <p> <code>elasticache:replication-group:Replicas</code> - The number of replicas per node group for an Amazon ElastiCache replication group.</p> </li>
    /// <li> <p> <code>neptune:cluster:ReadReplicaCount</code> - The count of read replicas in an Amazon Neptune DB cluster.</p> </li>
    /// </ul>
    pub fn scalable_dimension(&self) -> std::option::Option<&crate::model::ScalableDimension> {
        self.scalable_dimension.as_ref()
    }
    /// <p>The date and time that the action is scheduled to begin, in UTC.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>The date and time that the action is scheduled to end, in UTC.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
    /// <p>The new minimum and maximum capacity. You can set both values or just one. At the scheduled time, if the current capacity is below the minimum capacity, Application Auto Scaling scales out to the minimum capacity. If the current capacity is above the maximum capacity, Application Auto Scaling scales in to the maximum capacity.</p>
    pub fn scalable_target_action(
        &self,
    ) -> std::option::Option<&crate::model::ScalableTargetAction> {
        self.scalable_target_action.as_ref()
    }
    /// <p>The date and time that the scheduled action was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
}
impl std::fmt::Debug for ScheduledAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScheduledAction");
        formatter.field("scheduled_action_name", &self.scheduled_action_name);
        formatter.field("scheduled_action_arn", &self.scheduled_action_arn);
        formatter.field("service_namespace", &self.service_namespace);
        formatter.field("schedule", &self.schedule);
        formatter.field("timezone", &self.timezone);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("scalable_dimension", &self.scalable_dimension);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("scalable_target_action", &self.scalable_target_action);
        formatter.field("creation_time", &self.creation_time);
        formatter.finish()
    }
}
/// See [`ScheduledAction`](crate::model::ScheduledAction)
pub mod scheduled_action {
    /// A builder for [`ScheduledAction`](crate::model::ScheduledAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) scheduled_action_name: std::option::Option<std::string::String>,
        pub(crate) scheduled_action_arn: std::option::Option<std::string::String>,
        pub(crate) service_namespace: std::option::Option<crate::model::ServiceNamespace>,
        pub(crate) schedule: std::option::Option<std::string::String>,
        pub(crate) timezone: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) scalable_dimension: std::option::Option<crate::model::ScalableDimension>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) scalable_target_action: std::option::Option<crate::model::ScalableTargetAction>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the scheduled action.</p>
        pub fn scheduled_action_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.scheduled_action_name = Some(input.into());
            self
        }
        /// <p>The name of the scheduled action.</p>
        pub fn set_scheduled_action_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.scheduled_action_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the scheduled action.</p>
        pub fn scheduled_action_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.scheduled_action_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the scheduled action.</p>
        pub fn set_scheduled_action_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.scheduled_action_arn = input;
            self
        }
        /// <p>The namespace of the Amazon Web Services service that provides the resource, or a <code>custom-resource</code>.</p>
        pub fn service_namespace(mut self, input: crate::model::ServiceNamespace) -> Self {
            self.service_namespace = Some(input);
            self
        }
        /// <p>The namespace of the Amazon Web Services service that provides the resource, or a <code>custom-resource</code>.</p>
        pub fn set_service_namespace(
            mut self,
            input: std::option::Option<crate::model::ServiceNamespace>,
        ) -> Self {
            self.service_namespace = input;
            self
        }
        /// <p>The schedule for this action. The following formats are supported:</p>
        /// <ul>
        /// <li> <p>At expressions - "<code>at(<i>yyyy</i>-<i>mm</i>-<i>dd</i>T<i>hh</i>:<i>mm</i>:<i>ss</i>)</code>"</p> </li>
        /// <li> <p>Rate expressions - "<code>rate(<i>value</i> <i>unit</i>)</code>"</p> </li>
        /// <li> <p>Cron expressions - "<code>cron(<i>fields</i>)</code>"</p> </li>
        /// </ul>
        /// <p>At expressions are useful for one-time schedules. Cron expressions are useful for scheduled actions that run periodically at a specified date and time, and rate expressions are useful for scheduled actions that run at a regular interval.</p>
        /// <p>At and cron expressions use Universal Coordinated Time (UTC) by default.</p>
        /// <p>The cron format consists of six fields separated by white spaces: [Minutes] [Hours] [Day_of_Month] [Month] [Day_of_Week] [Year].</p>
        /// <p>For rate expressions, <i>value</i> is a positive integer and <i>unit</i> is <code>minute</code> | <code>minutes</code> | <code>hour</code> | <code>hours</code> | <code>day</code> | <code>days</code>.</p>
        /// <p>For more information and examples, see <a href="https://docs.aws.amazon.com/autoscaling/application/userguide/examples-scheduled-actions.html">Example scheduled actions for Application Auto Scaling</a> in the <i>Application Auto Scaling User Guide</i>.</p>
        pub fn schedule(mut self, input: impl Into<std::string::String>) -> Self {
            self.schedule = Some(input.into());
            self
        }
        /// <p>The schedule for this action. The following formats are supported:</p>
        /// <ul>
        /// <li> <p>At expressions - "<code>at(<i>yyyy</i>-<i>mm</i>-<i>dd</i>T<i>hh</i>:<i>mm</i>:<i>ss</i>)</code>"</p> </li>
        /// <li> <p>Rate expressions - "<code>rate(<i>value</i> <i>unit</i>)</code>"</p> </li>
        /// <li> <p>Cron expressions - "<code>cron(<i>fields</i>)</code>"</p> </li>
        /// </ul>
        /// <p>At expressions are useful for one-time schedules. Cron expressions are useful for scheduled actions that run periodically at a specified date and time, and rate expressions are useful for scheduled actions that run at a regular interval.</p>
        /// <p>At and cron expressions use Universal Coordinated Time (UTC) by default.</p>
        /// <p>The cron format consists of six fields separated by white spaces: [Minutes] [Hours] [Day_of_Month] [Month] [Day_of_Week] [Year].</p>
        /// <p>For rate expressions, <i>value</i> is a positive integer and <i>unit</i> is <code>minute</code> | <code>minutes</code> | <code>hour</code> | <code>hours</code> | <code>day</code> | <code>days</code>.</p>
        /// <p>For more information and examples, see <a href="https://docs.aws.amazon.com/autoscaling/application/userguide/examples-scheduled-actions.html">Example scheduled actions for Application Auto Scaling</a> in the <i>Application Auto Scaling User Guide</i>.</p>
        pub fn set_schedule(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schedule = input;
            self
        }
        /// <p>The time zone used when referring to the date and time of a scheduled action, when the scheduled action uses an at or cron expression.</p>
        pub fn timezone(mut self, input: impl Into<std::string::String>) -> Self {
            self.timezone = Some(input.into());
            self
        }
        /// <p>The time zone used when referring to the date and time of a scheduled action, when the scheduled action uses an at or cron expression.</p>
        pub fn set_timezone(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.timezone = input;
            self
        }
        /// <p>The identifier of the resource associated with the scaling policy. This string consists of the resource type and unique identifier.</p>
        /// <ul>
        /// <li> <p>ECS service - The resource type is <code>service</code> and the unique identifier is the cluster name and service name. Example: <code>service/default/sample-webapp</code>.</p> </li>
        /// <li> <p>Spot Fleet - The resource type is <code>spot-fleet-request</code> and the unique identifier is the Spot Fleet request ID. Example: <code>spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE</code>.</p> </li>
        /// <li> <p>EMR cluster - The resource type is <code>instancegroup</code> and the unique identifier is the cluster ID and instance group ID. Example: <code>instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0</code>.</p> </li>
        /// <li> <p>AppStream 2.0 fleet - The resource type is <code>fleet</code> and the unique identifier is the fleet name. Example: <code>fleet/sample-fleet</code>.</p> </li>
        /// <li> <p>DynamoDB table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>table/my-table</code>.</p> </li>
        /// <li> <p>DynamoDB global secondary index - The resource type is <code>index</code> and the unique identifier is the index name. Example: <code>table/my-table/index/my-table-index</code>.</p> </li>
        /// <li> <p>Aurora DB cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:my-db-cluster</code>.</p> </li>
        /// <li> <p>SageMaker endpoint variant - The resource type is <code>variant</code> and the unique identifier is the resource ID. Example: <code>endpoint/my-end-point/variant/KMeansClustering</code>.</p> </li>
        /// <li> <p>Custom resources are not supported with a resource type. This parameter must specify the <code>OutputValue</code> from the CloudFormation template stack used to access the resources. The unique identifier is defined by the service provider. More information is available in our <a href="https://github.com/aws/aws-auto-scaling-custom-resource">GitHub repository</a>.</p> </li>
        /// <li> <p>Amazon Comprehend document classification endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: <code>arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE</code>.</p> </li>
        /// <li> <p>Amazon Comprehend entity recognizer endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: <code>arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE</code>.</p> </li>
        /// <li> <p>Lambda provisioned concurrency - The resource type is <code>function</code> and the unique identifier is the function name with a function version or alias name suffix that is not <code>$LATEST</code>. Example: <code>function:my-function:prod</code> or <code>function:my-function:1</code>.</p> </li>
        /// <li> <p>Amazon Keyspaces table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>keyspace/mykeyspace/table/mytable</code>.</p> </li>
        /// <li> <p>Amazon MSK cluster - The resource type and unique identifier are specified using the cluster ARN. Example: <code>arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5</code>.</p> </li>
        /// <li> <p>Amazon ElastiCache replication group - The resource type is <code>replication-group</code> and the unique identifier is the replication group name. Example: <code>replication-group/mycluster</code>.</p> </li>
        /// <li> <p>Neptune cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:mycluster</code>.</p> </li>
        /// </ul>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The identifier of the resource associated with the scaling policy. This string consists of the resource type and unique identifier.</p>
        /// <ul>
        /// <li> <p>ECS service - The resource type is <code>service</code> and the unique identifier is the cluster name and service name. Example: <code>service/default/sample-webapp</code>.</p> </li>
        /// <li> <p>Spot Fleet - The resource type is <code>spot-fleet-request</code> and the unique identifier is the Spot Fleet request ID. Example: <code>spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE</code>.</p> </li>
        /// <li> <p>EMR cluster - The resource type is <code>instancegroup</code> and the unique identifier is the cluster ID and instance group ID. Example: <code>instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0</code>.</p> </li>
        /// <li> <p>AppStream 2.0 fleet - The resource type is <code>fleet</code> and the unique identifier is the fleet name. Example: <code>fleet/sample-fleet</code>.</p> </li>
        /// <li> <p>DynamoDB table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>table/my-table</code>.</p> </li>
        /// <li> <p>DynamoDB global secondary index - The resource type is <code>index</code> and the unique identifier is the index name. Example: <code>table/my-table/index/my-table-index</code>.</p> </li>
        /// <li> <p>Aurora DB cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:my-db-cluster</code>.</p> </li>
        /// <li> <p>SageMaker endpoint variant - The resource type is <code>variant</code> and the unique identifier is the resource ID. Example: <code>endpoint/my-end-point/variant/KMeansClustering</code>.</p> </li>
        /// <li> <p>Custom resources are not supported with a resource type. This parameter must specify the <code>OutputValue</code> from the CloudFormation template stack used to access the resources. The unique identifier is defined by the service provider. More information is available in our <a href="https://github.com/aws/aws-auto-scaling-custom-resource">GitHub repository</a>.</p> </li>
        /// <li> <p>Amazon Comprehend document classification endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: <code>arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE</code>.</p> </li>
        /// <li> <p>Amazon Comprehend entity recognizer endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: <code>arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE</code>.</p> </li>
        /// <li> <p>Lambda provisioned concurrency - The resource type is <code>function</code> and the unique identifier is the function name with a function version or alias name suffix that is not <code>$LATEST</code>. Example: <code>function:my-function:prod</code> or <code>function:my-function:1</code>.</p> </li>
        /// <li> <p>Amazon Keyspaces table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>keyspace/mykeyspace/table/mytable</code>.</p> </li>
        /// <li> <p>Amazon MSK cluster - The resource type and unique identifier are specified using the cluster ARN. Example: <code>arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5</code>.</p> </li>
        /// <li> <p>Amazon ElastiCache replication group - The resource type is <code>replication-group</code> and the unique identifier is the replication group name. Example: <code>replication-group/mycluster</code>.</p> </li>
        /// <li> <p>Neptune cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:mycluster</code>.</p> </li>
        /// </ul>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The scalable dimension. This string consists of the service namespace, resource type, and scaling property.</p>
        /// <ul>
        /// <li> <p> <code>ecs:service:DesiredCount</code> - The desired task count of an ECS service.</p> </li>
        /// <li> <p> <code>elasticmapreduce:instancegroup:InstanceCount</code> - The instance count of an EMR Instance Group.</p> </li>
        /// <li> <p> <code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet.</p> </li>
        /// <li> <p> <code>appstream:fleet:DesiredCapacity</code> - The desired capacity of an AppStream 2.0 fleet.</p> </li>
        /// <li> <p> <code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table.</p> </li>
        /// <li> <p> <code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table.</p> </li>
        /// <li> <p> <code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global secondary index.</p> </li>
        /// <li> <p> <code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global secondary index.</p> </li>
        /// <li> <p> <code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.</p> </li>
        /// <li> <p> <code>sagemaker:variant:DesiredInstanceCount</code> - The number of EC2 instances for an SageMaker model endpoint variant.</p> </li>
        /// <li> <p> <code>custom-resource:ResourceType:Property</code> - The scalable dimension for a custom resource provided by your own application or service.</p> </li>
        /// <li> <p> <code>comprehend:document-classifier-endpoint:DesiredInferenceUnits</code> - The number of inference units for an Amazon Comprehend document classification endpoint.</p> </li>
        /// <li> <p> <code>comprehend:entity-recognizer-endpoint:DesiredInferenceUnits</code> - The number of inference units for an Amazon Comprehend entity recognizer endpoint.</p> </li>
        /// <li> <p> <code>lambda:function:ProvisionedConcurrency</code> - The provisioned concurrency for a Lambda function.</p> </li>
        /// <li> <p> <code>cassandra:table:ReadCapacityUnits</code> - The provisioned read capacity for an Amazon Keyspaces table.</p> </li>
        /// <li> <p> <code>cassandra:table:WriteCapacityUnits</code> - The provisioned write capacity for an Amazon Keyspaces table.</p> </li>
        /// <li> <p> <code>kafka:broker-storage:VolumeSize</code> - The provisioned volume size (in GiB) for brokers in an Amazon MSK cluster.</p> </li>
        /// <li> <p> <code>elasticache:replication-group:NodeGroups</code> - The number of node groups for an Amazon ElastiCache replication group.</p> </li>
        /// <li> <p> <code>elasticache:replication-group:Replicas</code> - The number of replicas per node group for an Amazon ElastiCache replication group.</p> </li>
        /// <li> <p> <code>neptune:cluster:ReadReplicaCount</code> - The count of read replicas in an Amazon Neptune DB cluster.</p> </li>
        /// </ul>
        pub fn scalable_dimension(mut self, input: crate::model::ScalableDimension) -> Self {
            self.scalable_dimension = Some(input);
            self
        }
        /// <p>The scalable dimension. This string consists of the service namespace, resource type, and scaling property.</p>
        /// <ul>
        /// <li> <p> <code>ecs:service:DesiredCount</code> - The desired task count of an ECS service.</p> </li>
        /// <li> <p> <code>elasticmapreduce:instancegroup:InstanceCount</code> - The instance count of an EMR Instance Group.</p> </li>
        /// <li> <p> <code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet.</p> </li>
        /// <li> <p> <code>appstream:fleet:DesiredCapacity</code> - The desired capacity of an AppStream 2.0 fleet.</p> </li>
        /// <li> <p> <code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table.</p> </li>
        /// <li> <p> <code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table.</p> </li>
        /// <li> <p> <code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global secondary index.</p> </li>
        /// <li> <p> <code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global secondary index.</p> </li>
        /// <li> <p> <code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.</p> </li>
        /// <li> <p> <code>sagemaker:variant:DesiredInstanceCount</code> - The number of EC2 instances for an SageMaker model endpoint variant.</p> </li>
        /// <li> <p> <code>custom-resource:ResourceType:Property</code> - The scalable dimension for a custom resource provided by your own application or service.</p> </li>
        /// <li> <p> <code>comprehend:document-classifier-endpoint:DesiredInferenceUnits</code> - The number of inference units for an Amazon Comprehend document classification endpoint.</p> </li>
        /// <li> <p> <code>comprehend:entity-recognizer-endpoint:DesiredInferenceUnits</code> - The number of inference units for an Amazon Comprehend entity recognizer endpoint.</p> </li>
        /// <li> <p> <code>lambda:function:ProvisionedConcurrency</code> - The provisioned concurrency for a Lambda function.</p> </li>
        /// <li> <p> <code>cassandra:table:ReadCapacityUnits</code> - The provisioned read capacity for an Amazon Keyspaces table.</p> </li>
        /// <li> <p> <code>cassandra:table:WriteCapacityUnits</code> - The provisioned write capacity for an Amazon Keyspaces table.</p> </li>
        /// <li> <p> <code>kafka:broker-storage:VolumeSize</code> - The provisioned volume size (in GiB) for brokers in an Amazon MSK cluster.</p> </li>
        /// <li> <p> <code>elasticache:replication-group:NodeGroups</code> - The number of node groups for an Amazon ElastiCache replication group.</p> </li>
        /// <li> <p> <code>elasticache:replication-group:Replicas</code> - The number of replicas per node group for an Amazon ElastiCache replication group.</p> </li>
        /// <li> <p> <code>neptune:cluster:ReadReplicaCount</code> - The count of read replicas in an Amazon Neptune DB cluster.</p> </li>
        /// </ul>
        pub fn set_scalable_dimension(
            mut self,
            input: std::option::Option<crate::model::ScalableDimension>,
        ) -> Self {
            self.scalable_dimension = input;
            self
        }
        /// <p>The date and time that the action is scheduled to begin, in UTC.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The date and time that the action is scheduled to begin, in UTC.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The date and time that the action is scheduled to end, in UTC.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The date and time that the action is scheduled to end, in UTC.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The new minimum and maximum capacity. You can set both values or just one. At the scheduled time, if the current capacity is below the minimum capacity, Application Auto Scaling scales out to the minimum capacity. If the current capacity is above the maximum capacity, Application Auto Scaling scales in to the maximum capacity.</p>
        pub fn scalable_target_action(mut self, input: crate::model::ScalableTargetAction) -> Self {
            self.scalable_target_action = Some(input);
            self
        }
        /// <p>The new minimum and maximum capacity. You can set both values or just one. At the scheduled time, if the current capacity is below the minimum capacity, Application Auto Scaling scales out to the minimum capacity. If the current capacity is above the maximum capacity, Application Auto Scaling scales in to the maximum capacity.</p>
        pub fn set_scalable_target_action(
            mut self,
            input: std::option::Option<crate::model::ScalableTargetAction>,
        ) -> Self {
            self.scalable_target_action = input;
            self
        }
        /// <p>The date and time that the scheduled action was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The date and time that the scheduled action was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// Consumes the builder and constructs a [`ScheduledAction`](crate::model::ScheduledAction)
        pub fn build(self) -> crate::model::ScheduledAction {
            crate::model::ScheduledAction {
                scheduled_action_name: self.scheduled_action_name,
                scheduled_action_arn: self.scheduled_action_arn,
                service_namespace: self.service_namespace,
                schedule: self.schedule,
                timezone: self.timezone,
                resource_id: self.resource_id,
                scalable_dimension: self.scalable_dimension,
                start_time: self.start_time,
                end_time: self.end_time,
                scalable_target_action: self.scalable_target_action,
                creation_time: self.creation_time,
            }
        }
    }
}
impl ScheduledAction {
    /// Creates a new builder-style object to manufacture [`ScheduledAction`](crate::model::ScheduledAction)
    pub fn builder() -> crate::model::scheduled_action::Builder {
        crate::model::scheduled_action::Builder::default()
    }
}

/// <p>Represents a scaling policy to use with Application Auto Scaling.</p>
/// <p>For more information about configuring scaling policies for a specific service, see <a href="https://docs.aws.amazon.com/autoscaling/application/userguide/getting-started.html">Getting started with Application Auto Scaling</a> in the <i>Application Auto Scaling User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScalingPolicy {
    /// <p>The Amazon Resource Name (ARN) of the scaling policy.</p>
    pub policy_arn: std::option::Option<std::string::String>,
    /// <p>The name of the scaling policy.</p>
    pub policy_name: std::option::Option<std::string::String>,
    /// <p>The namespace of the Amazon Web Services service that provides the resource, or a <code>custom-resource</code>.</p>
    pub service_namespace: std::option::Option<crate::model::ServiceNamespace>,
    /// <p>The identifier of the resource associated with the scaling policy. This string consists of the resource type and unique identifier.</p>
    /// <ul>
    /// <li> <p>ECS service - The resource type is <code>service</code> and the unique identifier is the cluster name and service name. Example: <code>service/default/sample-webapp</code>.</p> </li>
    /// <li> <p>Spot Fleet - The resource type is <code>spot-fleet-request</code> and the unique identifier is the Spot Fleet request ID. Example: <code>spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE</code>.</p> </li>
    /// <li> <p>EMR cluster - The resource type is <code>instancegroup</code> and the unique identifier is the cluster ID and instance group ID. Example: <code>instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0</code>.</p> </li>
    /// <li> <p>AppStream 2.0 fleet - The resource type is <code>fleet</code> and the unique identifier is the fleet name. Example: <code>fleet/sample-fleet</code>.</p> </li>
    /// <li> <p>DynamoDB table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>table/my-table</code>.</p> </li>
    /// <li> <p>DynamoDB global secondary index - The resource type is <code>index</code> and the unique identifier is the index name. Example: <code>table/my-table/index/my-table-index</code>.</p> </li>
    /// <li> <p>Aurora DB cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:my-db-cluster</code>.</p> </li>
    /// <li> <p>SageMaker endpoint variant - The resource type is <code>variant</code> and the unique identifier is the resource ID. Example: <code>endpoint/my-end-point/variant/KMeansClustering</code>.</p> </li>
    /// <li> <p>Custom resources are not supported with a resource type. This parameter must specify the <code>OutputValue</code> from the CloudFormation template stack used to access the resources. The unique identifier is defined by the service provider. More information is available in our <a href="https://github.com/aws/aws-auto-scaling-custom-resource">GitHub repository</a>.</p> </li>
    /// <li> <p>Amazon Comprehend document classification endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: <code>arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE</code>.</p> </li>
    /// <li> <p>Amazon Comprehend entity recognizer endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: <code>arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE</code>.</p> </li>
    /// <li> <p>Lambda provisioned concurrency - The resource type is <code>function</code> and the unique identifier is the function name with a function version or alias name suffix that is not <code>$LATEST</code>. Example: <code>function:my-function:prod</code> or <code>function:my-function:1</code>.</p> </li>
    /// <li> <p>Amazon Keyspaces table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>keyspace/mykeyspace/table/mytable</code>.</p> </li>
    /// <li> <p>Amazon MSK cluster - The resource type and unique identifier are specified using the cluster ARN. Example: <code>arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5</code>.</p> </li>
    /// <li> <p>Amazon ElastiCache replication group - The resource type is <code>replication-group</code> and the unique identifier is the replication group name. Example: <code>replication-group/mycluster</code>.</p> </li>
    /// <li> <p>Neptune cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:mycluster</code>.</p> </li>
    /// </ul>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The scalable dimension. This string consists of the service namespace, resource type, and scaling property.</p>
    /// <ul>
    /// <li> <p> <code>ecs:service:DesiredCount</code> - The desired task count of an ECS service.</p> </li>
    /// <li> <p> <code>elasticmapreduce:instancegroup:InstanceCount</code> - The instance count of an EMR Instance Group.</p> </li>
    /// <li> <p> <code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet.</p> </li>
    /// <li> <p> <code>appstream:fleet:DesiredCapacity</code> - The desired capacity of an AppStream 2.0 fleet.</p> </li>
    /// <li> <p> <code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table.</p> </li>
    /// <li> <p> <code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table.</p> </li>
    /// <li> <p> <code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global secondary index.</p> </li>
    /// <li> <p> <code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global secondary index.</p> </li>
    /// <li> <p> <code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.</p> </li>
    /// <li> <p> <code>sagemaker:variant:DesiredInstanceCount</code> - The number of EC2 instances for an SageMaker model endpoint variant.</p> </li>
    /// <li> <p> <code>custom-resource:ResourceType:Property</code> - The scalable dimension for a custom resource provided by your own application or service.</p> </li>
    /// <li> <p> <code>comprehend:document-classifier-endpoint:DesiredInferenceUnits</code> - The number of inference units for an Amazon Comprehend document classification endpoint.</p> </li>
    /// <li> <p> <code>comprehend:entity-recognizer-endpoint:DesiredInferenceUnits</code> - The number of inference units for an Amazon Comprehend entity recognizer endpoint.</p> </li>
    /// <li> <p> <code>lambda:function:ProvisionedConcurrency</code> - The provisioned concurrency for a Lambda function.</p> </li>
    /// <li> <p> <code>cassandra:table:ReadCapacityUnits</code> - The provisioned read capacity for an Amazon Keyspaces table.</p> </li>
    /// <li> <p> <code>cassandra:table:WriteCapacityUnits</code> - The provisioned write capacity for an Amazon Keyspaces table.</p> </li>
    /// <li> <p> <code>kafka:broker-storage:VolumeSize</code> - The provisioned volume size (in GiB) for brokers in an Amazon MSK cluster.</p> </li>
    /// <li> <p> <code>elasticache:replication-group:NodeGroups</code> - The number of node groups for an Amazon ElastiCache replication group.</p> </li>
    /// <li> <p> <code>elasticache:replication-group:Replicas</code> - The number of replicas per node group for an Amazon ElastiCache replication group.</p> </li>
    /// <li> <p> <code>neptune:cluster:ReadReplicaCount</code> - The count of read replicas in an Amazon Neptune DB cluster.</p> </li>
    /// </ul>
    pub scalable_dimension: std::option::Option<crate::model::ScalableDimension>,
    /// <p>The scaling policy type.</p>
    pub policy_type: std::option::Option<crate::model::PolicyType>,
    /// <p>A step scaling policy.</p>
    pub step_scaling_policy_configuration:
        std::option::Option<crate::model::StepScalingPolicyConfiguration>,
    /// <p>A target tracking scaling policy.</p>
    pub target_tracking_scaling_policy_configuration:
        std::option::Option<crate::model::TargetTrackingScalingPolicyConfiguration>,
    /// <p>The CloudWatch alarms associated with the scaling policy.</p>
    pub alarms: std::option::Option<std::vec::Vec<crate::model::Alarm>>,
    /// <p>The Unix timestamp for when the scaling policy was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl ScalingPolicy {
    /// <p>The Amazon Resource Name (ARN) of the scaling policy.</p>
    pub fn policy_arn(&self) -> std::option::Option<&str> {
        self.policy_arn.as_deref()
    }
    /// <p>The name of the scaling policy.</p>
    pub fn policy_name(&self) -> std::option::Option<&str> {
        self.policy_name.as_deref()
    }
    /// <p>The namespace of the Amazon Web Services service that provides the resource, or a <code>custom-resource</code>.</p>
    pub fn service_namespace(&self) -> std::option::Option<&crate::model::ServiceNamespace> {
        self.service_namespace.as_ref()
    }
    /// <p>The identifier of the resource associated with the scaling policy. This string consists of the resource type and unique identifier.</p>
    /// <ul>
    /// <li> <p>ECS service - The resource type is <code>service</code> and the unique identifier is the cluster name and service name. Example: <code>service/default/sample-webapp</code>.</p> </li>
    /// <li> <p>Spot Fleet - The resource type is <code>spot-fleet-request</code> and the unique identifier is the Spot Fleet request ID. Example: <code>spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE</code>.</p> </li>
    /// <li> <p>EMR cluster - The resource type is <code>instancegroup</code> and the unique identifier is the cluster ID and instance group ID. Example: <code>instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0</code>.</p> </li>
    /// <li> <p>AppStream 2.0 fleet - The resource type is <code>fleet</code> and the unique identifier is the fleet name. Example: <code>fleet/sample-fleet</code>.</p> </li>
    /// <li> <p>DynamoDB table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>table/my-table</code>.</p> </li>
    /// <li> <p>DynamoDB global secondary index - The resource type is <code>index</code> and the unique identifier is the index name. Example: <code>table/my-table/index/my-table-index</code>.</p> </li>
    /// <li> <p>Aurora DB cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:my-db-cluster</code>.</p> </li>
    /// <li> <p>SageMaker endpoint variant - The resource type is <code>variant</code> and the unique identifier is the resource ID. Example: <code>endpoint/my-end-point/variant/KMeansClustering</code>.</p> </li>
    /// <li> <p>Custom resources are not supported with a resource type. This parameter must specify the <code>OutputValue</code> from the CloudFormation template stack used to access the resources. The unique identifier is defined by the service provider. More information is available in our <a href="https://github.com/aws/aws-auto-scaling-custom-resource">GitHub repository</a>.</p> </li>
    /// <li> <p>Amazon Comprehend document classification endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: <code>arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE</code>.</p> </li>
    /// <li> <p>Amazon Comprehend entity recognizer endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: <code>arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE</code>.</p> </li>
    /// <li> <p>Lambda provisioned concurrency - The resource type is <code>function</code> and the unique identifier is the function name with a function version or alias name suffix that is not <code>$LATEST</code>. Example: <code>function:my-function:prod</code> or <code>function:my-function:1</code>.</p> </li>
    /// <li> <p>Amazon Keyspaces table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>keyspace/mykeyspace/table/mytable</code>.</p> </li>
    /// <li> <p>Amazon MSK cluster - The resource type and unique identifier are specified using the cluster ARN. Example: <code>arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5</code>.</p> </li>
    /// <li> <p>Amazon ElastiCache replication group - The resource type is <code>replication-group</code> and the unique identifier is the replication group name. Example: <code>replication-group/mycluster</code>.</p> </li>
    /// <li> <p>Neptune cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:mycluster</code>.</p> </li>
    /// </ul>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The scalable dimension. This string consists of the service namespace, resource type, and scaling property.</p>
    /// <ul>
    /// <li> <p> <code>ecs:service:DesiredCount</code> - The desired task count of an ECS service.</p> </li>
    /// <li> <p> <code>elasticmapreduce:instancegroup:InstanceCount</code> - The instance count of an EMR Instance Group.</p> </li>
    /// <li> <p> <code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet.</p> </li>
    /// <li> <p> <code>appstream:fleet:DesiredCapacity</code> - The desired capacity of an AppStream 2.0 fleet.</p> </li>
    /// <li> <p> <code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table.</p> </li>
    /// <li> <p> <code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table.</p> </li>
    /// <li> <p> <code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global secondary index.</p> </li>
    /// <li> <p> <code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global secondary index.</p> </li>
    /// <li> <p> <code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.</p> </li>
    /// <li> <p> <code>sagemaker:variant:DesiredInstanceCount</code> - The number of EC2 instances for an SageMaker model endpoint variant.</p> </li>
    /// <li> <p> <code>custom-resource:ResourceType:Property</code> - The scalable dimension for a custom resource provided by your own application or service.</p> </li>
    /// <li> <p> <code>comprehend:document-classifier-endpoint:DesiredInferenceUnits</code> - The number of inference units for an Amazon Comprehend document classification endpoint.</p> </li>
    /// <li> <p> <code>comprehend:entity-recognizer-endpoint:DesiredInferenceUnits</code> - The number of inference units for an Amazon Comprehend entity recognizer endpoint.</p> </li>
    /// <li> <p> <code>lambda:function:ProvisionedConcurrency</code> - The provisioned concurrency for a Lambda function.</p> </li>
    /// <li> <p> <code>cassandra:table:ReadCapacityUnits</code> - The provisioned read capacity for an Amazon Keyspaces table.</p> </li>
    /// <li> <p> <code>cassandra:table:WriteCapacityUnits</code> - The provisioned write capacity for an Amazon Keyspaces table.</p> </li>
    /// <li> <p> <code>kafka:broker-storage:VolumeSize</code> - The provisioned volume size (in GiB) for brokers in an Amazon MSK cluster.</p> </li>
    /// <li> <p> <code>elasticache:replication-group:NodeGroups</code> - The number of node groups for an Amazon ElastiCache replication group.</p> </li>
    /// <li> <p> <code>elasticache:replication-group:Replicas</code> - The number of replicas per node group for an Amazon ElastiCache replication group.</p> </li>
    /// <li> <p> <code>neptune:cluster:ReadReplicaCount</code> - The count of read replicas in an Amazon Neptune DB cluster.</p> </li>
    /// </ul>
    pub fn scalable_dimension(&self) -> std::option::Option<&crate::model::ScalableDimension> {
        self.scalable_dimension.as_ref()
    }
    /// <p>The scaling policy type.</p>
    pub fn policy_type(&self) -> std::option::Option<&crate::model::PolicyType> {
        self.policy_type.as_ref()
    }
    /// <p>A step scaling policy.</p>
    pub fn step_scaling_policy_configuration(
        &self,
    ) -> std::option::Option<&crate::model::StepScalingPolicyConfiguration> {
        self.step_scaling_policy_configuration.as_ref()
    }
    /// <p>A target tracking scaling policy.</p>
    pub fn target_tracking_scaling_policy_configuration(
        &self,
    ) -> std::option::Option<&crate::model::TargetTrackingScalingPolicyConfiguration> {
        self.target_tracking_scaling_policy_configuration.as_ref()
    }
    /// <p>The CloudWatch alarms associated with the scaling policy.</p>
    pub fn alarms(&self) -> std::option::Option<&[crate::model::Alarm]> {
        self.alarms.as_deref()
    }
    /// <p>The Unix timestamp for when the scaling policy was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
}
impl std::fmt::Debug for ScalingPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScalingPolicy");
        formatter.field("policy_arn", &self.policy_arn);
        formatter.field("policy_name", &self.policy_name);
        formatter.field("service_namespace", &self.service_namespace);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("scalable_dimension", &self.scalable_dimension);
        formatter.field("policy_type", &self.policy_type);
        formatter.field(
            "step_scaling_policy_configuration",
            &self.step_scaling_policy_configuration,
        );
        formatter.field(
            "target_tracking_scaling_policy_configuration",
            &self.target_tracking_scaling_policy_configuration,
        );
        formatter.field("alarms", &self.alarms);
        formatter.field("creation_time", &self.creation_time);
        formatter.finish()
    }
}
/// See [`ScalingPolicy`](crate::model::ScalingPolicy)
pub mod scaling_policy {
    /// A builder for [`ScalingPolicy`](crate::model::ScalingPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_arn: std::option::Option<std::string::String>,
        pub(crate) policy_name: std::option::Option<std::string::String>,
        pub(crate) service_namespace: std::option::Option<crate::model::ServiceNamespace>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) scalable_dimension: std::option::Option<crate::model::ScalableDimension>,
        pub(crate) policy_type: std::option::Option<crate::model::PolicyType>,
        pub(crate) step_scaling_policy_configuration:
            std::option::Option<crate::model::StepScalingPolicyConfiguration>,
        pub(crate) target_tracking_scaling_policy_configuration:
            std::option::Option<crate::model::TargetTrackingScalingPolicyConfiguration>,
        pub(crate) alarms: std::option::Option<std::vec::Vec<crate::model::Alarm>>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the scaling policy.</p>
        pub fn policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the scaling policy.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_arn = input;
            self
        }
        /// <p>The name of the scaling policy.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_name = Some(input.into());
            self
        }
        /// <p>The name of the scaling policy.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_name = input;
            self
        }
        /// <p>The namespace of the Amazon Web Services service that provides the resource, or a <code>custom-resource</code>.</p>
        pub fn service_namespace(mut self, input: crate::model::ServiceNamespace) -> Self {
            self.service_namespace = Some(input);
            self
        }
        /// <p>The namespace of the Amazon Web Services service that provides the resource, or a <code>custom-resource</code>.</p>
        pub fn set_service_namespace(
            mut self,
            input: std::option::Option<crate::model::ServiceNamespace>,
        ) -> Self {
            self.service_namespace = input;
            self
        }
        /// <p>The identifier of the resource associated with the scaling policy. This string consists of the resource type and unique identifier.</p>
        /// <ul>
        /// <li> <p>ECS service - The resource type is <code>service</code> and the unique identifier is the cluster name and service name. Example: <code>service/default/sample-webapp</code>.</p> </li>
        /// <li> <p>Spot Fleet - The resource type is <code>spot-fleet-request</code> and the unique identifier is the Spot Fleet request ID. Example: <code>spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE</code>.</p> </li>
        /// <li> <p>EMR cluster - The resource type is <code>instancegroup</code> and the unique identifier is the cluster ID and instance group ID. Example: <code>instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0</code>.</p> </li>
        /// <li> <p>AppStream 2.0 fleet - The resource type is <code>fleet</code> and the unique identifier is the fleet name. Example: <code>fleet/sample-fleet</code>.</p> </li>
        /// <li> <p>DynamoDB table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>table/my-table</code>.</p> </li>
        /// <li> <p>DynamoDB global secondary index - The resource type is <code>index</code> and the unique identifier is the index name. Example: <code>table/my-table/index/my-table-index</code>.</p> </li>
        /// <li> <p>Aurora DB cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:my-db-cluster</code>.</p> </li>
        /// <li> <p>SageMaker endpoint variant - The resource type is <code>variant</code> and the unique identifier is the resource ID. Example: <code>endpoint/my-end-point/variant/KMeansClustering</code>.</p> </li>
        /// <li> <p>Custom resources are not supported with a resource type. This parameter must specify the <code>OutputValue</code> from the CloudFormation template stack used to access the resources. The unique identifier is defined by the service provider. More information is available in our <a href="https://github.com/aws/aws-auto-scaling-custom-resource">GitHub repository</a>.</p> </li>
        /// <li> <p>Amazon Comprehend document classification endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: <code>arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE</code>.</p> </li>
        /// <li> <p>Amazon Comprehend entity recognizer endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: <code>arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE</code>.</p> </li>
        /// <li> <p>Lambda provisioned concurrency - The resource type is <code>function</code> and the unique identifier is the function name with a function version or alias name suffix that is not <code>$LATEST</code>. Example: <code>function:my-function:prod</code> or <code>function:my-function:1</code>.</p> </li>
        /// <li> <p>Amazon Keyspaces table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>keyspace/mykeyspace/table/mytable</code>.</p> </li>
        /// <li> <p>Amazon MSK cluster - The resource type and unique identifier are specified using the cluster ARN. Example: <code>arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5</code>.</p> </li>
        /// <li> <p>Amazon ElastiCache replication group - The resource type is <code>replication-group</code> and the unique identifier is the replication group name. Example: <code>replication-group/mycluster</code>.</p> </li>
        /// <li> <p>Neptune cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:mycluster</code>.</p> </li>
        /// </ul>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The identifier of the resource associated with the scaling policy. This string consists of the resource type and unique identifier.</p>
        /// <ul>
        /// <li> <p>ECS service - The resource type is <code>service</code> and the unique identifier is the cluster name and service name. Example: <code>service/default/sample-webapp</code>.</p> </li>
        /// <li> <p>Spot Fleet - The resource type is <code>spot-fleet-request</code> and the unique identifier is the Spot Fleet request ID. Example: <code>spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE</code>.</p> </li>
        /// <li> <p>EMR cluster - The resource type is <code>instancegroup</code> and the unique identifier is the cluster ID and instance group ID. Example: <code>instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0</code>.</p> </li>
        /// <li> <p>AppStream 2.0 fleet - The resource type is <code>fleet</code> and the unique identifier is the fleet name. Example: <code>fleet/sample-fleet</code>.</p> </li>
        /// <li> <p>DynamoDB table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>table/my-table</code>.</p> </li>
        /// <li> <p>DynamoDB global secondary index - The resource type is <code>index</code> and the unique identifier is the index name. Example: <code>table/my-table/index/my-table-index</code>.</p> </li>
        /// <li> <p>Aurora DB cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:my-db-cluster</code>.</p> </li>
        /// <li> <p>SageMaker endpoint variant - The resource type is <code>variant</code> and the unique identifier is the resource ID. Example: <code>endpoint/my-end-point/variant/KMeansClustering</code>.</p> </li>
        /// <li> <p>Custom resources are not supported with a resource type. This parameter must specify the <code>OutputValue</code> from the CloudFormation template stack used to access the resources. The unique identifier is defined by the service provider. More information is available in our <a href="https://github.com/aws/aws-auto-scaling-custom-resource">GitHub repository</a>.</p> </li>
        /// <li> <p>Amazon Comprehend document classification endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: <code>arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE</code>.</p> </li>
        /// <li> <p>Amazon Comprehend entity recognizer endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: <code>arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE</code>.</p> </li>
        /// <li> <p>Lambda provisioned concurrency - The resource type is <code>function</code> and the unique identifier is the function name with a function version or alias name suffix that is not <code>$LATEST</code>. Example: <code>function:my-function:prod</code> or <code>function:my-function:1</code>.</p> </li>
        /// <li> <p>Amazon Keyspaces table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>keyspace/mykeyspace/table/mytable</code>.</p> </li>
        /// <li> <p>Amazon MSK cluster - The resource type and unique identifier are specified using the cluster ARN. Example: <code>arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5</code>.</p> </li>
        /// <li> <p>Amazon ElastiCache replication group - The resource type is <code>replication-group</code> and the unique identifier is the replication group name. Example: <code>replication-group/mycluster</code>.</p> </li>
        /// <li> <p>Neptune cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:mycluster</code>.</p> </li>
        /// </ul>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The scalable dimension. This string consists of the service namespace, resource type, and scaling property.</p>
        /// <ul>
        /// <li> <p> <code>ecs:service:DesiredCount</code> - The desired task count of an ECS service.</p> </li>
        /// <li> <p> <code>elasticmapreduce:instancegroup:InstanceCount</code> - The instance count of an EMR Instance Group.</p> </li>
        /// <li> <p> <code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet.</p> </li>
        /// <li> <p> <code>appstream:fleet:DesiredCapacity</code> - The desired capacity of an AppStream 2.0 fleet.</p> </li>
        /// <li> <p> <code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table.</p> </li>
        /// <li> <p> <code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table.</p> </li>
        /// <li> <p> <code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global secondary index.</p> </li>
        /// <li> <p> <code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global secondary index.</p> </li>
        /// <li> <p> <code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.</p> </li>
        /// <li> <p> <code>sagemaker:variant:DesiredInstanceCount</code> - The number of EC2 instances for an SageMaker model endpoint variant.</p> </li>
        /// <li> <p> <code>custom-resource:ResourceType:Property</code> - The scalable dimension for a custom resource provided by your own application or service.</p> </li>
        /// <li> <p> <code>comprehend:document-classifier-endpoint:DesiredInferenceUnits</code> - The number of inference units for an Amazon Comprehend document classification endpoint.</p> </li>
        /// <li> <p> <code>comprehend:entity-recognizer-endpoint:DesiredInferenceUnits</code> - The number of inference units for an Amazon Comprehend entity recognizer endpoint.</p> </li>
        /// <li> <p> <code>lambda:function:ProvisionedConcurrency</code> - The provisioned concurrency for a Lambda function.</p> </li>
        /// <li> <p> <code>cassandra:table:ReadCapacityUnits</code> - The provisioned read capacity for an Amazon Keyspaces table.</p> </li>
        /// <li> <p> <code>cassandra:table:WriteCapacityUnits</code> - The provisioned write capacity for an Amazon Keyspaces table.</p> </li>
        /// <li> <p> <code>kafka:broker-storage:VolumeSize</code> - The provisioned volume size (in GiB) for brokers in an Amazon MSK cluster.</p> </li>
        /// <li> <p> <code>elasticache:replication-group:NodeGroups</code> - The number of node groups for an Amazon ElastiCache replication group.</p> </li>
        /// <li> <p> <code>elasticache:replication-group:Replicas</code> - The number of replicas per node group for an Amazon ElastiCache replication group.</p> </li>
        /// <li> <p> <code>neptune:cluster:ReadReplicaCount</code> - The count of read replicas in an Amazon Neptune DB cluster.</p> </li>
        /// </ul>
        pub fn scalable_dimension(mut self, input: crate::model::ScalableDimension) -> Self {
            self.scalable_dimension = Some(input);
            self
        }
        /// <p>The scalable dimension. This string consists of the service namespace, resource type, and scaling property.</p>
        /// <ul>
        /// <li> <p> <code>ecs:service:DesiredCount</code> - The desired task count of an ECS service.</p> </li>
        /// <li> <p> <code>elasticmapreduce:instancegroup:InstanceCount</code> - The instance count of an EMR Instance Group.</p> </li>
        /// <li> <p> <code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet.</p> </li>
        /// <li> <p> <code>appstream:fleet:DesiredCapacity</code> - The desired capacity of an AppStream 2.0 fleet.</p> </li>
        /// <li> <p> <code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table.</p> </li>
        /// <li> <p> <code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table.</p> </li>
        /// <li> <p> <code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global secondary index.</p> </li>
        /// <li> <p> <code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global secondary index.</p> </li>
        /// <li> <p> <code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.</p> </li>
        /// <li> <p> <code>sagemaker:variant:DesiredInstanceCount</code> - The number of EC2 instances for an SageMaker model endpoint variant.</p> </li>
        /// <li> <p> <code>custom-resource:ResourceType:Property</code> - The scalable dimension for a custom resource provided by your own application or service.</p> </li>
        /// <li> <p> <code>comprehend:document-classifier-endpoint:DesiredInferenceUnits</code> - The number of inference units for an Amazon Comprehend document classification endpoint.</p> </li>
        /// <li> <p> <code>comprehend:entity-recognizer-endpoint:DesiredInferenceUnits</code> - The number of inference units for an Amazon Comprehend entity recognizer endpoint.</p> </li>
        /// <li> <p> <code>lambda:function:ProvisionedConcurrency</code> - The provisioned concurrency for a Lambda function.</p> </li>
        /// <li> <p> <code>cassandra:table:ReadCapacityUnits</code> - The provisioned read capacity for an Amazon Keyspaces table.</p> </li>
        /// <li> <p> <code>cassandra:table:WriteCapacityUnits</code> - The provisioned write capacity for an Amazon Keyspaces table.</p> </li>
        /// <li> <p> <code>kafka:broker-storage:VolumeSize</code> - The provisioned volume size (in GiB) for brokers in an Amazon MSK cluster.</p> </li>
        /// <li> <p> <code>elasticache:replication-group:NodeGroups</code> - The number of node groups for an Amazon ElastiCache replication group.</p> </li>
        /// <li> <p> <code>elasticache:replication-group:Replicas</code> - The number of replicas per node group for an Amazon ElastiCache replication group.</p> </li>
        /// <li> <p> <code>neptune:cluster:ReadReplicaCount</code> - The count of read replicas in an Amazon Neptune DB cluster.</p> </li>
        /// </ul>
        pub fn set_scalable_dimension(
            mut self,
            input: std::option::Option<crate::model::ScalableDimension>,
        ) -> Self {
            self.scalable_dimension = input;
            self
        }
        /// <p>The scaling policy type.</p>
        pub fn policy_type(mut self, input: crate::model::PolicyType) -> Self {
            self.policy_type = Some(input);
            self
        }
        /// <p>The scaling policy type.</p>
        pub fn set_policy_type(
            mut self,
            input: std::option::Option<crate::model::PolicyType>,
        ) -> Self {
            self.policy_type = input;
            self
        }
        /// <p>A step scaling policy.</p>
        pub fn step_scaling_policy_configuration(
            mut self,
            input: crate::model::StepScalingPolicyConfiguration,
        ) -> Self {
            self.step_scaling_policy_configuration = Some(input);
            self
        }
        /// <p>A step scaling policy.</p>
        pub fn set_step_scaling_policy_configuration(
            mut self,
            input: std::option::Option<crate::model::StepScalingPolicyConfiguration>,
        ) -> Self {
            self.step_scaling_policy_configuration = input;
            self
        }
        /// <p>A target tracking scaling policy.</p>
        pub fn target_tracking_scaling_policy_configuration(
            mut self,
            input: crate::model::TargetTrackingScalingPolicyConfiguration,
        ) -> Self {
            self.target_tracking_scaling_policy_configuration = Some(input);
            self
        }
        /// <p>A target tracking scaling policy.</p>
        pub fn set_target_tracking_scaling_policy_configuration(
            mut self,
            input: std::option::Option<crate::model::TargetTrackingScalingPolicyConfiguration>,
        ) -> Self {
            self.target_tracking_scaling_policy_configuration = input;
            self
        }
        /// Appends an item to `alarms`.
        ///
        /// To override the contents of this collection use [`set_alarms`](Self::set_alarms).
        ///
        /// <p>The CloudWatch alarms associated with the scaling policy.</p>
        pub fn alarms(mut self, input: crate::model::Alarm) -> Self {
            let mut v = self.alarms.unwrap_or_default();
            v.push(input);
            self.alarms = Some(v);
            self
        }
        /// <p>The CloudWatch alarms associated with the scaling policy.</p>
        pub fn set_alarms(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Alarm>>,
        ) -> Self {
            self.alarms = input;
            self
        }
        /// <p>The Unix timestamp for when the scaling policy was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The Unix timestamp for when the scaling policy was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// Consumes the builder and constructs a [`ScalingPolicy`](crate::model::ScalingPolicy)
        pub fn build(self) -> crate::model::ScalingPolicy {
            crate::model::ScalingPolicy {
                policy_arn: self.policy_arn,
                policy_name: self.policy_name,
                service_namespace: self.service_namespace,
                resource_id: self.resource_id,
                scalable_dimension: self.scalable_dimension,
                policy_type: self.policy_type,
                step_scaling_policy_configuration: self.step_scaling_policy_configuration,
                target_tracking_scaling_policy_configuration: self
                    .target_tracking_scaling_policy_configuration,
                alarms: self.alarms,
                creation_time: self.creation_time,
            }
        }
    }
}
impl ScalingPolicy {
    /// Creates a new builder-style object to manufacture [`ScalingPolicy`](crate::model::ScalingPolicy)
    pub fn builder() -> crate::model::scaling_policy::Builder {
        crate::model::scaling_policy::Builder::default()
    }
}

/// <p>Represents a scaling activity.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScalingActivity {
    /// <p>The unique identifier of the scaling activity.</p>
    pub activity_id: std::option::Option<std::string::String>,
    /// <p>The namespace of the Amazon Web Services service that provides the resource, or a <code>custom-resource</code>.</p>
    pub service_namespace: std::option::Option<crate::model::ServiceNamespace>,
    /// <p>The identifier of the resource associated with the scaling activity. This string consists of the resource type and unique identifier.</p>
    /// <ul>
    /// <li> <p>ECS service - The resource type is <code>service</code> and the unique identifier is the cluster name and service name. Example: <code>service/default/sample-webapp</code>.</p> </li>
    /// <li> <p>Spot Fleet - The resource type is <code>spot-fleet-request</code> and the unique identifier is the Spot Fleet request ID. Example: <code>spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE</code>.</p> </li>
    /// <li> <p>EMR cluster - The resource type is <code>instancegroup</code> and the unique identifier is the cluster ID and instance group ID. Example: <code>instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0</code>.</p> </li>
    /// <li> <p>AppStream 2.0 fleet - The resource type is <code>fleet</code> and the unique identifier is the fleet name. Example: <code>fleet/sample-fleet</code>.</p> </li>
    /// <li> <p>DynamoDB table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>table/my-table</code>.</p> </li>
    /// <li> <p>DynamoDB global secondary index - The resource type is <code>index</code> and the unique identifier is the index name. Example: <code>table/my-table/index/my-table-index</code>.</p> </li>
    /// <li> <p>Aurora DB cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:my-db-cluster</code>.</p> </li>
    /// <li> <p>SageMaker endpoint variant - The resource type is <code>variant</code> and the unique identifier is the resource ID. Example: <code>endpoint/my-end-point/variant/KMeansClustering</code>.</p> </li>
    /// <li> <p>Custom resources are not supported with a resource type. This parameter must specify the <code>OutputValue</code> from the CloudFormation template stack used to access the resources. The unique identifier is defined by the service provider. More information is available in our <a href="https://github.com/aws/aws-auto-scaling-custom-resource">GitHub repository</a>.</p> </li>
    /// <li> <p>Amazon Comprehend document classification endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: <code>arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE</code>.</p> </li>
    /// <li> <p>Amazon Comprehend entity recognizer endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: <code>arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE</code>.</p> </li>
    /// <li> <p>Lambda provisioned concurrency - The resource type is <code>function</code> and the unique identifier is the function name with a function version or alias name suffix that is not <code>$LATEST</code>. Example: <code>function:my-function:prod</code> or <code>function:my-function:1</code>.</p> </li>
    /// <li> <p>Amazon Keyspaces table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>keyspace/mykeyspace/table/mytable</code>.</p> </li>
    /// <li> <p>Amazon MSK cluster - The resource type and unique identifier are specified using the cluster ARN. Example: <code>arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5</code>.</p> </li>
    /// <li> <p>Amazon ElastiCache replication group - The resource type is <code>replication-group</code> and the unique identifier is the replication group name. Example: <code>replication-group/mycluster</code>.</p> </li>
    /// <li> <p>Neptune cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:mycluster</code>.</p> </li>
    /// </ul>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The scalable dimension. This string consists of the service namespace, resource type, and scaling property.</p>
    /// <ul>
    /// <li> <p> <code>ecs:service:DesiredCount</code> - The desired task count of an ECS service.</p> </li>
    /// <li> <p> <code>elasticmapreduce:instancegroup:InstanceCount</code> - The instance count of an EMR Instance Group.</p> </li>
    /// <li> <p> <code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet.</p> </li>
    /// <li> <p> <code>appstream:fleet:DesiredCapacity</code> - The desired capacity of an AppStream 2.0 fleet.</p> </li>
    /// <li> <p> <code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table.</p> </li>
    /// <li> <p> <code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table.</p> </li>
    /// <li> <p> <code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global secondary index.</p> </li>
    /// <li> <p> <code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global secondary index.</p> </li>
    /// <li> <p> <code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.</p> </li>
    /// <li> <p> <code>sagemaker:variant:DesiredInstanceCount</code> - The number of EC2 instances for an SageMaker model endpoint variant.</p> </li>
    /// <li> <p> <code>custom-resource:ResourceType:Property</code> - The scalable dimension for a custom resource provided by your own application or service.</p> </li>
    /// <li> <p> <code>comprehend:document-classifier-endpoint:DesiredInferenceUnits</code> - The number of inference units for an Amazon Comprehend document classification endpoint.</p> </li>
    /// <li> <p> <code>comprehend:entity-recognizer-endpoint:DesiredInferenceUnits</code> - The number of inference units for an Amazon Comprehend entity recognizer endpoint.</p> </li>
    /// <li> <p> <code>lambda:function:ProvisionedConcurrency</code> - The provisioned concurrency for a Lambda function.</p> </li>
    /// <li> <p> <code>cassandra:table:ReadCapacityUnits</code> - The provisioned read capacity for an Amazon Keyspaces table.</p> </li>
    /// <li> <p> <code>cassandra:table:WriteCapacityUnits</code> - The provisioned write capacity for an Amazon Keyspaces table.</p> </li>
    /// <li> <p> <code>kafka:broker-storage:VolumeSize</code> - The provisioned volume size (in GiB) for brokers in an Amazon MSK cluster.</p> </li>
    /// <li> <p> <code>elasticache:replication-group:NodeGroups</code> - The number of node groups for an Amazon ElastiCache replication group.</p> </li>
    /// <li> <p> <code>elasticache:replication-group:Replicas</code> - The number of replicas per node group for an Amazon ElastiCache replication group.</p> </li>
    /// <li> <p> <code>neptune:cluster:ReadReplicaCount</code> - The count of read replicas in an Amazon Neptune DB cluster.</p> </li>
    /// </ul>
    pub scalable_dimension: std::option::Option<crate::model::ScalableDimension>,
    /// <p>A simple description of what action the scaling activity intends to accomplish.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A simple description of what caused the scaling activity to happen.</p>
    pub cause: std::option::Option<std::string::String>,
    /// <p>The Unix timestamp for when the scaling activity began.</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The Unix timestamp for when the scaling activity ended.</p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Indicates the status of the scaling activity.</p>
    pub status_code: std::option::Option<crate::model::ScalingActivityStatusCode>,
    /// <p>A simple message about the current status of the scaling activity.</p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p>The details about the scaling activity.</p>
    pub details: std::option::Option<std::string::String>,
}
impl ScalingActivity {
    /// <p>The unique identifier of the scaling activity.</p>
    pub fn activity_id(&self) -> std::option::Option<&str> {
        self.activity_id.as_deref()
    }
    /// <p>The namespace of the Amazon Web Services service that provides the resource, or a <code>custom-resource</code>.</p>
    pub fn service_namespace(&self) -> std::option::Option<&crate::model::ServiceNamespace> {
        self.service_namespace.as_ref()
    }
    /// <p>The identifier of the resource associated with the scaling activity. This string consists of the resource type and unique identifier.</p>
    /// <ul>
    /// <li> <p>ECS service - The resource type is <code>service</code> and the unique identifier is the cluster name and service name. Example: <code>service/default/sample-webapp</code>.</p> </li>
    /// <li> <p>Spot Fleet - The resource type is <code>spot-fleet-request</code> and the unique identifier is the Spot Fleet request ID. Example: <code>spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE</code>.</p> </li>
    /// <li> <p>EMR cluster - The resource type is <code>instancegroup</code> and the unique identifier is the cluster ID and instance group ID. Example: <code>instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0</code>.</p> </li>
    /// <li> <p>AppStream 2.0 fleet - The resource type is <code>fleet</code> and the unique identifier is the fleet name. Example: <code>fleet/sample-fleet</code>.</p> </li>
    /// <li> <p>DynamoDB table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>table/my-table</code>.</p> </li>
    /// <li> <p>DynamoDB global secondary index - The resource type is <code>index</code> and the unique identifier is the index name. Example: <code>table/my-table/index/my-table-index</code>.</p> </li>
    /// <li> <p>Aurora DB cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:my-db-cluster</code>.</p> </li>
    /// <li> <p>SageMaker endpoint variant - The resource type is <code>variant</code> and the unique identifier is the resource ID. Example: <code>endpoint/my-end-point/variant/KMeansClustering</code>.</p> </li>
    /// <li> <p>Custom resources are not supported with a resource type. This parameter must specify the <code>OutputValue</code> from the CloudFormation template stack used to access the resources. The unique identifier is defined by the service provider. More information is available in our <a href="https://github.com/aws/aws-auto-scaling-custom-resource">GitHub repository</a>.</p> </li>
    /// <li> <p>Amazon Comprehend document classification endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: <code>arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE</code>.</p> </li>
    /// <li> <p>Amazon Comprehend entity recognizer endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: <code>arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE</code>.</p> </li>
    /// <li> <p>Lambda provisioned concurrency - The resource type is <code>function</code> and the unique identifier is the function name with a function version or alias name suffix that is not <code>$LATEST</code>. Example: <code>function:my-function:prod</code> or <code>function:my-function:1</code>.</p> </li>
    /// <li> <p>Amazon Keyspaces table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>keyspace/mykeyspace/table/mytable</code>.</p> </li>
    /// <li> <p>Amazon MSK cluster - The resource type and unique identifier are specified using the cluster ARN. Example: <code>arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5</code>.</p> </li>
    /// <li> <p>Amazon ElastiCache replication group - The resource type is <code>replication-group</code> and the unique identifier is the replication group name. Example: <code>replication-group/mycluster</code>.</p> </li>
    /// <li> <p>Neptune cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:mycluster</code>.</p> </li>
    /// </ul>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The scalable dimension. This string consists of the service namespace, resource type, and scaling property.</p>
    /// <ul>
    /// <li> <p> <code>ecs:service:DesiredCount</code> - The desired task count of an ECS service.</p> </li>
    /// <li> <p> <code>elasticmapreduce:instancegroup:InstanceCount</code> - The instance count of an EMR Instance Group.</p> </li>
    /// <li> <p> <code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet.</p> </li>
    /// <li> <p> <code>appstream:fleet:DesiredCapacity</code> - The desired capacity of an AppStream 2.0 fleet.</p> </li>
    /// <li> <p> <code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table.</p> </li>
    /// <li> <p> <code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table.</p> </li>
    /// <li> <p> <code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global secondary index.</p> </li>
    /// <li> <p> <code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global secondary index.</p> </li>
    /// <li> <p> <code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.</p> </li>
    /// <li> <p> <code>sagemaker:variant:DesiredInstanceCount</code> - The number of EC2 instances for an SageMaker model endpoint variant.</p> </li>
    /// <li> <p> <code>custom-resource:ResourceType:Property</code> - The scalable dimension for a custom resource provided by your own application or service.</p> </li>
    /// <li> <p> <code>comprehend:document-classifier-endpoint:DesiredInferenceUnits</code> - The number of inference units for an Amazon Comprehend document classification endpoint.</p> </li>
    /// <li> <p> <code>comprehend:entity-recognizer-endpoint:DesiredInferenceUnits</code> - The number of inference units for an Amazon Comprehend entity recognizer endpoint.</p> </li>
    /// <li> <p> <code>lambda:function:ProvisionedConcurrency</code> - The provisioned concurrency for a Lambda function.</p> </li>
    /// <li> <p> <code>cassandra:table:ReadCapacityUnits</code> - The provisioned read capacity for an Amazon Keyspaces table.</p> </li>
    /// <li> <p> <code>cassandra:table:WriteCapacityUnits</code> - The provisioned write capacity for an Amazon Keyspaces table.</p> </li>
    /// <li> <p> <code>kafka:broker-storage:VolumeSize</code> - The provisioned volume size (in GiB) for brokers in an Amazon MSK cluster.</p> </li>
    /// <li> <p> <code>elasticache:replication-group:NodeGroups</code> - The number of node groups for an Amazon ElastiCache replication group.</p> </li>
    /// <li> <p> <code>elasticache:replication-group:Replicas</code> - The number of replicas per node group for an Amazon ElastiCache replication group.</p> </li>
    /// <li> <p> <code>neptune:cluster:ReadReplicaCount</code> - The count of read replicas in an Amazon Neptune DB cluster.</p> </li>
    /// </ul>
    pub fn scalable_dimension(&self) -> std::option::Option<&crate::model::ScalableDimension> {
        self.scalable_dimension.as_ref()
    }
    /// <p>A simple description of what action the scaling activity intends to accomplish.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>A simple description of what caused the scaling activity to happen.</p>
    pub fn cause(&self) -> std::option::Option<&str> {
        self.cause.as_deref()
    }
    /// <p>The Unix timestamp for when the scaling activity began.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>The Unix timestamp for when the scaling activity ended.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
    /// <p>Indicates the status of the scaling activity.</p>
    pub fn status_code(&self) -> std::option::Option<&crate::model::ScalingActivityStatusCode> {
        self.status_code.as_ref()
    }
    /// <p>A simple message about the current status of the scaling activity.</p>
    pub fn status_message(&self) -> std::option::Option<&str> {
        self.status_message.as_deref()
    }
    /// <p>The details about the scaling activity.</p>
    pub fn details(&self) -> std::option::Option<&str> {
        self.details.as_deref()
    }
}
impl std::fmt::Debug for ScalingActivity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScalingActivity");
        formatter.field("activity_id", &self.activity_id);
        formatter.field("service_namespace", &self.service_namespace);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("scalable_dimension", &self.scalable_dimension);
        formatter.field("description", &self.description);
        formatter.field("cause", &self.cause);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("status_code", &self.status_code);
        formatter.field("status_message", &self.status_message);
        formatter.field("details", &self.details);
        formatter.finish()
    }
}
/// See [`ScalingActivity`](crate::model::ScalingActivity)
pub mod scaling_activity {
    /// A builder for [`ScalingActivity`](crate::model::ScalingActivity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) activity_id: std::option::Option<std::string::String>,
        pub(crate) service_namespace: std::option::Option<crate::model::ServiceNamespace>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) scalable_dimension: std::option::Option<crate::model::ScalableDimension>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) cause: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) status_code: std::option::Option<crate::model::ScalingActivityStatusCode>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) details: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the scaling activity.</p>
        pub fn activity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.activity_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the scaling activity.</p>
        pub fn set_activity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.activity_id = input;
            self
        }
        /// <p>The namespace of the Amazon Web Services service that provides the resource, or a <code>custom-resource</code>.</p>
        pub fn service_namespace(mut self, input: crate::model::ServiceNamespace) -> Self {
            self.service_namespace = Some(input);
            self
        }
        /// <p>The namespace of the Amazon Web Services service that provides the resource, or a <code>custom-resource</code>.</p>
        pub fn set_service_namespace(
            mut self,
            input: std::option::Option<crate::model::ServiceNamespace>,
        ) -> Self {
            self.service_namespace = input;
            self
        }
        /// <p>The identifier of the resource associated with the scaling activity. This string consists of the resource type and unique identifier.</p>
        /// <ul>
        /// <li> <p>ECS service - The resource type is <code>service</code> and the unique identifier is the cluster name and service name. Example: <code>service/default/sample-webapp</code>.</p> </li>
        /// <li> <p>Spot Fleet - The resource type is <code>spot-fleet-request</code> and the unique identifier is the Spot Fleet request ID. Example: <code>spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE</code>.</p> </li>
        /// <li> <p>EMR cluster - The resource type is <code>instancegroup</code> and the unique identifier is the cluster ID and instance group ID. Example: <code>instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0</code>.</p> </li>
        /// <li> <p>AppStream 2.0 fleet - The resource type is <code>fleet</code> and the unique identifier is the fleet name. Example: <code>fleet/sample-fleet</code>.</p> </li>
        /// <li> <p>DynamoDB table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>table/my-table</code>.</p> </li>
        /// <li> <p>DynamoDB global secondary index - The resource type is <code>index</code> and the unique identifier is the index name. Example: <code>table/my-table/index/my-table-index</code>.</p> </li>
        /// <li> <p>Aurora DB cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:my-db-cluster</code>.</p> </li>
        /// <li> <p>SageMaker endpoint variant - The resource type is <code>variant</code> and the unique identifier is the resource ID. Example: <code>endpoint/my-end-point/variant/KMeansClustering</code>.</p> </li>
        /// <li> <p>Custom resources are not supported with a resource type. This parameter must specify the <code>OutputValue</code> from the CloudFormation template stack used to access the resources. The unique identifier is defined by the service provider. More information is available in our <a href="https://github.com/aws/aws-auto-scaling-custom-resource">GitHub repository</a>.</p> </li>
        /// <li> <p>Amazon Comprehend document classification endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: <code>arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE</code>.</p> </li>
        /// <li> <p>Amazon Comprehend entity recognizer endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: <code>arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE</code>.</p> </li>
        /// <li> <p>Lambda provisioned concurrency - The resource type is <code>function</code> and the unique identifier is the function name with a function version or alias name suffix that is not <code>$LATEST</code>. Example: <code>function:my-function:prod</code> or <code>function:my-function:1</code>.</p> </li>
        /// <li> <p>Amazon Keyspaces table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>keyspace/mykeyspace/table/mytable</code>.</p> </li>
        /// <li> <p>Amazon MSK cluster - The resource type and unique identifier are specified using the cluster ARN. Example: <code>arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5</code>.</p> </li>
        /// <li> <p>Amazon ElastiCache replication group - The resource type is <code>replication-group</code> and the unique identifier is the replication group name. Example: <code>replication-group/mycluster</code>.</p> </li>
        /// <li> <p>Neptune cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:mycluster</code>.</p> </li>
        /// </ul>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The identifier of the resource associated with the scaling activity. This string consists of the resource type and unique identifier.</p>
        /// <ul>
        /// <li> <p>ECS service - The resource type is <code>service</code> and the unique identifier is the cluster name and service name. Example: <code>service/default/sample-webapp</code>.</p> </li>
        /// <li> <p>Spot Fleet - The resource type is <code>spot-fleet-request</code> and the unique identifier is the Spot Fleet request ID. Example: <code>spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE</code>.</p> </li>
        /// <li> <p>EMR cluster - The resource type is <code>instancegroup</code> and the unique identifier is the cluster ID and instance group ID. Example: <code>instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0</code>.</p> </li>
        /// <li> <p>AppStream 2.0 fleet - The resource type is <code>fleet</code> and the unique identifier is the fleet name. Example: <code>fleet/sample-fleet</code>.</p> </li>
        /// <li> <p>DynamoDB table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>table/my-table</code>.</p> </li>
        /// <li> <p>DynamoDB global secondary index - The resource type is <code>index</code> and the unique identifier is the index name. Example: <code>table/my-table/index/my-table-index</code>.</p> </li>
        /// <li> <p>Aurora DB cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:my-db-cluster</code>.</p> </li>
        /// <li> <p>SageMaker endpoint variant - The resource type is <code>variant</code> and the unique identifier is the resource ID. Example: <code>endpoint/my-end-point/variant/KMeansClustering</code>.</p> </li>
        /// <li> <p>Custom resources are not supported with a resource type. This parameter must specify the <code>OutputValue</code> from the CloudFormation template stack used to access the resources. The unique identifier is defined by the service provider. More information is available in our <a href="https://github.com/aws/aws-auto-scaling-custom-resource">GitHub repository</a>.</p> </li>
        /// <li> <p>Amazon Comprehend document classification endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: <code>arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE</code>.</p> </li>
        /// <li> <p>Amazon Comprehend entity recognizer endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: <code>arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE</code>.</p> </li>
        /// <li> <p>Lambda provisioned concurrency - The resource type is <code>function</code> and the unique identifier is the function name with a function version or alias name suffix that is not <code>$LATEST</code>. Example: <code>function:my-function:prod</code> or <code>function:my-function:1</code>.</p> </li>
        /// <li> <p>Amazon Keyspaces table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>keyspace/mykeyspace/table/mytable</code>.</p> </li>
        /// <li> <p>Amazon MSK cluster - The resource type and unique identifier are specified using the cluster ARN. Example: <code>arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5</code>.</p> </li>
        /// <li> <p>Amazon ElastiCache replication group - The resource type is <code>replication-group</code> and the unique identifier is the replication group name. Example: <code>replication-group/mycluster</code>.</p> </li>
        /// <li> <p>Neptune cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:mycluster</code>.</p> </li>
        /// </ul>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The scalable dimension. This string consists of the service namespace, resource type, and scaling property.</p>
        /// <ul>
        /// <li> <p> <code>ecs:service:DesiredCount</code> - The desired task count of an ECS service.</p> </li>
        /// <li> <p> <code>elasticmapreduce:instancegroup:InstanceCount</code> - The instance count of an EMR Instance Group.</p> </li>
        /// <li> <p> <code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet.</p> </li>
        /// <li> <p> <code>appstream:fleet:DesiredCapacity</code> - The desired capacity of an AppStream 2.0 fleet.</p> </li>
        /// <li> <p> <code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table.</p> </li>
        /// <li> <p> <code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table.</p> </li>
        /// <li> <p> <code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global secondary index.</p> </li>
        /// <li> <p> <code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global secondary index.</p> </li>
        /// <li> <p> <code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.</p> </li>
        /// <li> <p> <code>sagemaker:variant:DesiredInstanceCount</code> - The number of EC2 instances for an SageMaker model endpoint variant.</p> </li>
        /// <li> <p> <code>custom-resource:ResourceType:Property</code> - The scalable dimension for a custom resource provided by your own application or service.</p> </li>
        /// <li> <p> <code>comprehend:document-classifier-endpoint:DesiredInferenceUnits</code> - The number of inference units for an Amazon Comprehend document classification endpoint.</p> </li>
        /// <li> <p> <code>comprehend:entity-recognizer-endpoint:DesiredInferenceUnits</code> - The number of inference units for an Amazon Comprehend entity recognizer endpoint.</p> </li>
        /// <li> <p> <code>lambda:function:ProvisionedConcurrency</code> - The provisioned concurrency for a Lambda function.</p> </li>
        /// <li> <p> <code>cassandra:table:ReadCapacityUnits</code> - The provisioned read capacity for an Amazon Keyspaces table.</p> </li>
        /// <li> <p> <code>cassandra:table:WriteCapacityUnits</code> - The provisioned write capacity for an Amazon Keyspaces table.</p> </li>
        /// <li> <p> <code>kafka:broker-storage:VolumeSize</code> - The provisioned volume size (in GiB) for brokers in an Amazon MSK cluster.</p> </li>
        /// <li> <p> <code>elasticache:replication-group:NodeGroups</code> - The number of node groups for an Amazon ElastiCache replication group.</p> </li>
        /// <li> <p> <code>elasticache:replication-group:Replicas</code> - The number of replicas per node group for an Amazon ElastiCache replication group.</p> </li>
        /// <li> <p> <code>neptune:cluster:ReadReplicaCount</code> - The count of read replicas in an Amazon Neptune DB cluster.</p> </li>
        /// </ul>
        pub fn scalable_dimension(mut self, input: crate::model::ScalableDimension) -> Self {
            self.scalable_dimension = Some(input);
            self
        }
        /// <p>The scalable dimension. This string consists of the service namespace, resource type, and scaling property.</p>
        /// <ul>
        /// <li> <p> <code>ecs:service:DesiredCount</code> - The desired task count of an ECS service.</p> </li>
        /// <li> <p> <code>elasticmapreduce:instancegroup:InstanceCount</code> - The instance count of an EMR Instance Group.</p> </li>
        /// <li> <p> <code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet.</p> </li>
        /// <li> <p> <code>appstream:fleet:DesiredCapacity</code> - The desired capacity of an AppStream 2.0 fleet.</p> </li>
        /// <li> <p> <code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table.</p> </li>
        /// <li> <p> <code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table.</p> </li>
        /// <li> <p> <code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global secondary index.</p> </li>
        /// <li> <p> <code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global secondary index.</p> </li>
        /// <li> <p> <code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.</p> </li>
        /// <li> <p> <code>sagemaker:variant:DesiredInstanceCount</code> - The number of EC2 instances for an SageMaker model endpoint variant.</p> </li>
        /// <li> <p> <code>custom-resource:ResourceType:Property</code> - The scalable dimension for a custom resource provided by your own application or service.</p> </li>
        /// <li> <p> <code>comprehend:document-classifier-endpoint:DesiredInferenceUnits</code> - The number of inference units for an Amazon Comprehend document classification endpoint.</p> </li>
        /// <li> <p> <code>comprehend:entity-recognizer-endpoint:DesiredInferenceUnits</code> - The number of inference units for an Amazon Comprehend entity recognizer endpoint.</p> </li>
        /// <li> <p> <code>lambda:function:ProvisionedConcurrency</code> - The provisioned concurrency for a Lambda function.</p> </li>
        /// <li> <p> <code>cassandra:table:ReadCapacityUnits</code> - The provisioned read capacity for an Amazon Keyspaces table.</p> </li>
        /// <li> <p> <code>cassandra:table:WriteCapacityUnits</code> - The provisioned write capacity for an Amazon Keyspaces table.</p> </li>
        /// <li> <p> <code>kafka:broker-storage:VolumeSize</code> - The provisioned volume size (in GiB) for brokers in an Amazon MSK cluster.</p> </li>
        /// <li> <p> <code>elasticache:replication-group:NodeGroups</code> - The number of node groups for an Amazon ElastiCache replication group.</p> </li>
        /// <li> <p> <code>elasticache:replication-group:Replicas</code> - The number of replicas per node group for an Amazon ElastiCache replication group.</p> </li>
        /// <li> <p> <code>neptune:cluster:ReadReplicaCount</code> - The count of read replicas in an Amazon Neptune DB cluster.</p> </li>
        /// </ul>
        pub fn set_scalable_dimension(
            mut self,
            input: std::option::Option<crate::model::ScalableDimension>,
        ) -> Self {
            self.scalable_dimension = input;
            self
        }
        /// <p>A simple description of what action the scaling activity intends to accomplish.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A simple description of what action the scaling activity intends to accomplish.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>A simple description of what caused the scaling activity to happen.</p>
        pub fn cause(mut self, input: impl Into<std::string::String>) -> Self {
            self.cause = Some(input.into());
            self
        }
        /// <p>A simple description of what caused the scaling activity to happen.</p>
        pub fn set_cause(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cause = input;
            self
        }
        /// <p>The Unix timestamp for when the scaling activity began.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The Unix timestamp for when the scaling activity began.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The Unix timestamp for when the scaling activity ended.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The Unix timestamp for when the scaling activity ended.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>Indicates the status of the scaling activity.</p>
        pub fn status_code(mut self, input: crate::model::ScalingActivityStatusCode) -> Self {
            self.status_code = Some(input);
            self
        }
        /// <p>Indicates the status of the scaling activity.</p>
        pub fn set_status_code(
            mut self,
            input: std::option::Option<crate::model::ScalingActivityStatusCode>,
        ) -> Self {
            self.status_code = input;
            self
        }
        /// <p>A simple message about the current status of the scaling activity.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>A simple message about the current status of the scaling activity.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// <p>The details about the scaling activity.</p>
        pub fn details(mut self, input: impl Into<std::string::String>) -> Self {
            self.details = Some(input.into());
            self
        }
        /// <p>The details about the scaling activity.</p>
        pub fn set_details(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.details = input;
            self
        }
        /// Consumes the builder and constructs a [`ScalingActivity`](crate::model::ScalingActivity)
        pub fn build(self) -> crate::model::ScalingActivity {
            crate::model::ScalingActivity {
                activity_id: self.activity_id,
                service_namespace: self.service_namespace,
                resource_id: self.resource_id,
                scalable_dimension: self.scalable_dimension,
                description: self.description,
                cause: self.cause,
                start_time: self.start_time,
                end_time: self.end_time,
                status_code: self.status_code,
                status_message: self.status_message,
                details: self.details,
            }
        }
    }
}
impl ScalingActivity {
    /// Creates a new builder-style object to manufacture [`ScalingActivity`](crate::model::ScalingActivity)
    pub fn builder() -> crate::model::scaling_activity::Builder {
        crate::model::scaling_activity::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ScalingActivityStatusCode {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Overridden,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Successful,
    #[allow(missing_docs)] // documentation missing in model
    Unfulfilled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ScalingActivityStatusCode {
    fn from(s: &str) -> Self {
        match s {
            "Failed" => ScalingActivityStatusCode::Failed,
            "InProgress" => ScalingActivityStatusCode::InProgress,
            "Overridden" => ScalingActivityStatusCode::Overridden,
            "Pending" => ScalingActivityStatusCode::Pending,
            "Successful" => ScalingActivityStatusCode::Successful,
            "Unfulfilled" => ScalingActivityStatusCode::Unfulfilled,
            other => ScalingActivityStatusCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ScalingActivityStatusCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ScalingActivityStatusCode::from(s))
    }
}
impl ScalingActivityStatusCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ScalingActivityStatusCode::Failed => "Failed",
            ScalingActivityStatusCode::InProgress => "InProgress",
            ScalingActivityStatusCode::Overridden => "Overridden",
            ScalingActivityStatusCode::Pending => "Pending",
            ScalingActivityStatusCode::Successful => "Successful",
            ScalingActivityStatusCode::Unfulfilled => "Unfulfilled",
            ScalingActivityStatusCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Failed",
            "InProgress",
            "Overridden",
            "Pending",
            "Successful",
            "Unfulfilled",
        ]
    }
}
impl AsRef<str> for ScalingActivityStatusCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents a scalable target.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScalableTarget {
    /// <p>The namespace of the Amazon Web Services service that provides the resource, or a <code>custom-resource</code>.</p>
    pub service_namespace: std::option::Option<crate::model::ServiceNamespace>,
    /// <p>The identifier of the resource associated with the scalable target. This string consists of the resource type and unique identifier.</p>
    /// <ul>
    /// <li> <p>ECS service - The resource type is <code>service</code> and the unique identifier is the cluster name and service name. Example: <code>service/default/sample-webapp</code>.</p> </li>
    /// <li> <p>Spot Fleet - The resource type is <code>spot-fleet-request</code> and the unique identifier is the Spot Fleet request ID. Example: <code>spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE</code>.</p> </li>
    /// <li> <p>EMR cluster - The resource type is <code>instancegroup</code> and the unique identifier is the cluster ID and instance group ID. Example: <code>instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0</code>.</p> </li>
    /// <li> <p>AppStream 2.0 fleet - The resource type is <code>fleet</code> and the unique identifier is the fleet name. Example: <code>fleet/sample-fleet</code>.</p> </li>
    /// <li> <p>DynamoDB table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>table/my-table</code>.</p> </li>
    /// <li> <p>DynamoDB global secondary index - The resource type is <code>index</code> and the unique identifier is the index name. Example: <code>table/my-table/index/my-table-index</code>.</p> </li>
    /// <li> <p>Aurora DB cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:my-db-cluster</code>.</p> </li>
    /// <li> <p>SageMaker endpoint variant - The resource type is <code>variant</code> and the unique identifier is the resource ID. Example: <code>endpoint/my-end-point/variant/KMeansClustering</code>.</p> </li>
    /// <li> <p>Custom resources are not supported with a resource type. This parameter must specify the <code>OutputValue</code> from the CloudFormation template stack used to access the resources. The unique identifier is defined by the service provider. More information is available in our <a href="https://github.com/aws/aws-auto-scaling-custom-resource">GitHub repository</a>.</p> </li>
    /// <li> <p>Amazon Comprehend document classification endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: <code>arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE</code>.</p> </li>
    /// <li> <p>Amazon Comprehend entity recognizer endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: <code>arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE</code>.</p> </li>
    /// <li> <p>Lambda provisioned concurrency - The resource type is <code>function</code> and the unique identifier is the function name with a function version or alias name suffix that is not <code>$LATEST</code>. Example: <code>function:my-function:prod</code> or <code>function:my-function:1</code>.</p> </li>
    /// <li> <p>Amazon Keyspaces table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>keyspace/mykeyspace/table/mytable</code>.</p> </li>
    /// <li> <p>Amazon MSK cluster - The resource type and unique identifier are specified using the cluster ARN. Example: <code>arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5</code>.</p> </li>
    /// <li> <p>Amazon ElastiCache replication group - The resource type is <code>replication-group</code> and the unique identifier is the replication group name. Example: <code>replication-group/mycluster</code>.</p> </li>
    /// <li> <p>Neptune cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:mycluster</code>.</p> </li>
    /// </ul>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The scalable dimension associated with the scalable target. This string consists of the service namespace, resource type, and scaling property.</p>
    /// <ul>
    /// <li> <p> <code>ecs:service:DesiredCount</code> - The desired task count of an ECS service.</p> </li>
    /// <li> <p> <code>elasticmapreduce:instancegroup:InstanceCount</code> - The instance count of an EMR Instance Group.</p> </li>
    /// <li> <p> <code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet.</p> </li>
    /// <li> <p> <code>appstream:fleet:DesiredCapacity</code> - The desired capacity of an AppStream 2.0 fleet.</p> </li>
    /// <li> <p> <code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table.</p> </li>
    /// <li> <p> <code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table.</p> </li>
    /// <li> <p> <code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global secondary index.</p> </li>
    /// <li> <p> <code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global secondary index.</p> </li>
    /// <li> <p> <code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.</p> </li>
    /// <li> <p> <code>sagemaker:variant:DesiredInstanceCount</code> - The number of EC2 instances for an SageMaker model endpoint variant.</p> </li>
    /// <li> <p> <code>custom-resource:ResourceType:Property</code> - The scalable dimension for a custom resource provided by your own application or service.</p> </li>
    /// <li> <p> <code>comprehend:document-classifier-endpoint:DesiredInferenceUnits</code> - The number of inference units for an Amazon Comprehend document classification endpoint.</p> </li>
    /// <li> <p> <code>comprehend:entity-recognizer-endpoint:DesiredInferenceUnits</code> - The number of inference units for an Amazon Comprehend entity recognizer endpoint.</p> </li>
    /// <li> <p> <code>lambda:function:ProvisionedConcurrency</code> - The provisioned concurrency for a Lambda function.</p> </li>
    /// <li> <p> <code>cassandra:table:ReadCapacityUnits</code> - The provisioned read capacity for an Amazon Keyspaces table.</p> </li>
    /// <li> <p> <code>cassandra:table:WriteCapacityUnits</code> - The provisioned write capacity for an Amazon Keyspaces table.</p> </li>
    /// <li> <p> <code>kafka:broker-storage:VolumeSize</code> - The provisioned volume size (in GiB) for brokers in an Amazon MSK cluster.</p> </li>
    /// <li> <p> <code>elasticache:replication-group:NodeGroups</code> - The number of node groups for an Amazon ElastiCache replication group.</p> </li>
    /// <li> <p> <code>elasticache:replication-group:Replicas</code> - The number of replicas per node group for an Amazon ElastiCache replication group.</p> </li>
    /// <li> <p> <code>neptune:cluster:ReadReplicaCount</code> - The count of read replicas in an Amazon Neptune DB cluster.</p> </li>
    /// </ul>
    pub scalable_dimension: std::option::Option<crate::model::ScalableDimension>,
    /// <p>The minimum value to scale to in response to a scale-in activity.</p>
    pub min_capacity: std::option::Option<i32>,
    /// <p>The maximum value to scale to in response to a scale-out activity.</p>
    pub max_capacity: std::option::Option<i32>,
    /// <p>The ARN of an IAM role that allows Application Auto Scaling to modify the scalable target on your behalf.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The Unix timestamp for when the scalable target was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Specifies whether the scaling activities for a scalable target are in a suspended state. </p>
    pub suspended_state: std::option::Option<crate::model::SuspendedState>,
}
impl ScalableTarget {
    /// <p>The namespace of the Amazon Web Services service that provides the resource, or a <code>custom-resource</code>.</p>
    pub fn service_namespace(&self) -> std::option::Option<&crate::model::ServiceNamespace> {
        self.service_namespace.as_ref()
    }
    /// <p>The identifier of the resource associated with the scalable target. This string consists of the resource type and unique identifier.</p>
    /// <ul>
    /// <li> <p>ECS service - The resource type is <code>service</code> and the unique identifier is the cluster name and service name. Example: <code>service/default/sample-webapp</code>.</p> </li>
    /// <li> <p>Spot Fleet - The resource type is <code>spot-fleet-request</code> and the unique identifier is the Spot Fleet request ID. Example: <code>spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE</code>.</p> </li>
    /// <li> <p>EMR cluster - The resource type is <code>instancegroup</code> and the unique identifier is the cluster ID and instance group ID. Example: <code>instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0</code>.</p> </li>
    /// <li> <p>AppStream 2.0 fleet - The resource type is <code>fleet</code> and the unique identifier is the fleet name. Example: <code>fleet/sample-fleet</code>.</p> </li>
    /// <li> <p>DynamoDB table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>table/my-table</code>.</p> </li>
    /// <li> <p>DynamoDB global secondary index - The resource type is <code>index</code> and the unique identifier is the index name. Example: <code>table/my-table/index/my-table-index</code>.</p> </li>
    /// <li> <p>Aurora DB cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:my-db-cluster</code>.</p> </li>
    /// <li> <p>SageMaker endpoint variant - The resource type is <code>variant</code> and the unique identifier is the resource ID. Example: <code>endpoint/my-end-point/variant/KMeansClustering</code>.</p> </li>
    /// <li> <p>Custom resources are not supported with a resource type. This parameter must specify the <code>OutputValue</code> from the CloudFormation template stack used to access the resources. The unique identifier is defined by the service provider. More information is available in our <a href="https://github.com/aws/aws-auto-scaling-custom-resource">GitHub repository</a>.</p> </li>
    /// <li> <p>Amazon Comprehend document classification endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: <code>arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE</code>.</p> </li>
    /// <li> <p>Amazon Comprehend entity recognizer endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: <code>arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE</code>.</p> </li>
    /// <li> <p>Lambda provisioned concurrency - The resource type is <code>function</code> and the unique identifier is the function name with a function version or alias name suffix that is not <code>$LATEST</code>. Example: <code>function:my-function:prod</code> or <code>function:my-function:1</code>.</p> </li>
    /// <li> <p>Amazon Keyspaces table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>keyspace/mykeyspace/table/mytable</code>.</p> </li>
    /// <li> <p>Amazon MSK cluster - The resource type and unique identifier are specified using the cluster ARN. Example: <code>arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5</code>.</p> </li>
    /// <li> <p>Amazon ElastiCache replication group - The resource type is <code>replication-group</code> and the unique identifier is the replication group name. Example: <code>replication-group/mycluster</code>.</p> </li>
    /// <li> <p>Neptune cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:mycluster</code>.</p> </li>
    /// </ul>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The scalable dimension associated with the scalable target. This string consists of the service namespace, resource type, and scaling property.</p>
    /// <ul>
    /// <li> <p> <code>ecs:service:DesiredCount</code> - The desired task count of an ECS service.</p> </li>
    /// <li> <p> <code>elasticmapreduce:instancegroup:InstanceCount</code> - The instance count of an EMR Instance Group.</p> </li>
    /// <li> <p> <code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet.</p> </li>
    /// <li> <p> <code>appstream:fleet:DesiredCapacity</code> - The desired capacity of an AppStream 2.0 fleet.</p> </li>
    /// <li> <p> <code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table.</p> </li>
    /// <li> <p> <code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table.</p> </li>
    /// <li> <p> <code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global secondary index.</p> </li>
    /// <li> <p> <code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global secondary index.</p> </li>
    /// <li> <p> <code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.</p> </li>
    /// <li> <p> <code>sagemaker:variant:DesiredInstanceCount</code> - The number of EC2 instances for an SageMaker model endpoint variant.</p> </li>
    /// <li> <p> <code>custom-resource:ResourceType:Property</code> - The scalable dimension for a custom resource provided by your own application or service.</p> </li>
    /// <li> <p> <code>comprehend:document-classifier-endpoint:DesiredInferenceUnits</code> - The number of inference units for an Amazon Comprehend document classification endpoint.</p> </li>
    /// <li> <p> <code>comprehend:entity-recognizer-endpoint:DesiredInferenceUnits</code> - The number of inference units for an Amazon Comprehend entity recognizer endpoint.</p> </li>
    /// <li> <p> <code>lambda:function:ProvisionedConcurrency</code> - The provisioned concurrency for a Lambda function.</p> </li>
    /// <li> <p> <code>cassandra:table:ReadCapacityUnits</code> - The provisioned read capacity for an Amazon Keyspaces table.</p> </li>
    /// <li> <p> <code>cassandra:table:WriteCapacityUnits</code> - The provisioned write capacity for an Amazon Keyspaces table.</p> </li>
    /// <li> <p> <code>kafka:broker-storage:VolumeSize</code> - The provisioned volume size (in GiB) for brokers in an Amazon MSK cluster.</p> </li>
    /// <li> <p> <code>elasticache:replication-group:NodeGroups</code> - The number of node groups for an Amazon ElastiCache replication group.</p> </li>
    /// <li> <p> <code>elasticache:replication-group:Replicas</code> - The number of replicas per node group for an Amazon ElastiCache replication group.</p> </li>
    /// <li> <p> <code>neptune:cluster:ReadReplicaCount</code> - The count of read replicas in an Amazon Neptune DB cluster.</p> </li>
    /// </ul>
    pub fn scalable_dimension(&self) -> std::option::Option<&crate::model::ScalableDimension> {
        self.scalable_dimension.as_ref()
    }
    /// <p>The minimum value to scale to in response to a scale-in activity.</p>
    pub fn min_capacity(&self) -> std::option::Option<i32> {
        self.min_capacity
    }
    /// <p>The maximum value to scale to in response to a scale-out activity.</p>
    pub fn max_capacity(&self) -> std::option::Option<i32> {
        self.max_capacity
    }
    /// <p>The ARN of an IAM role that allows Application Auto Scaling to modify the scalable target on your behalf.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The Unix timestamp for when the scalable target was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>Specifies whether the scaling activities for a scalable target are in a suspended state. </p>
    pub fn suspended_state(&self) -> std::option::Option<&crate::model::SuspendedState> {
        self.suspended_state.as_ref()
    }
}
impl std::fmt::Debug for ScalableTarget {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScalableTarget");
        formatter.field("service_namespace", &self.service_namespace);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("scalable_dimension", &self.scalable_dimension);
        formatter.field("min_capacity", &self.min_capacity);
        formatter.field("max_capacity", &self.max_capacity);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("suspended_state", &self.suspended_state);
        formatter.finish()
    }
}
/// See [`ScalableTarget`](crate::model::ScalableTarget)
pub mod scalable_target {
    /// A builder for [`ScalableTarget`](crate::model::ScalableTarget)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_namespace: std::option::Option<crate::model::ServiceNamespace>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) scalable_dimension: std::option::Option<crate::model::ScalableDimension>,
        pub(crate) min_capacity: std::option::Option<i32>,
        pub(crate) max_capacity: std::option::Option<i32>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) suspended_state: std::option::Option<crate::model::SuspendedState>,
    }
    impl Builder {
        /// <p>The namespace of the Amazon Web Services service that provides the resource, or a <code>custom-resource</code>.</p>
        pub fn service_namespace(mut self, input: crate::model::ServiceNamespace) -> Self {
            self.service_namespace = Some(input);
            self
        }
        /// <p>The namespace of the Amazon Web Services service that provides the resource, or a <code>custom-resource</code>.</p>
        pub fn set_service_namespace(
            mut self,
            input: std::option::Option<crate::model::ServiceNamespace>,
        ) -> Self {
            self.service_namespace = input;
            self
        }
        /// <p>The identifier of the resource associated with the scalable target. This string consists of the resource type and unique identifier.</p>
        /// <ul>
        /// <li> <p>ECS service - The resource type is <code>service</code> and the unique identifier is the cluster name and service name. Example: <code>service/default/sample-webapp</code>.</p> </li>
        /// <li> <p>Spot Fleet - The resource type is <code>spot-fleet-request</code> and the unique identifier is the Spot Fleet request ID. Example: <code>spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE</code>.</p> </li>
        /// <li> <p>EMR cluster - The resource type is <code>instancegroup</code> and the unique identifier is the cluster ID and instance group ID. Example: <code>instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0</code>.</p> </li>
        /// <li> <p>AppStream 2.0 fleet - The resource type is <code>fleet</code> and the unique identifier is the fleet name. Example: <code>fleet/sample-fleet</code>.</p> </li>
        /// <li> <p>DynamoDB table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>table/my-table</code>.</p> </li>
        /// <li> <p>DynamoDB global secondary index - The resource type is <code>index</code> and the unique identifier is the index name. Example: <code>table/my-table/index/my-table-index</code>.</p> </li>
        /// <li> <p>Aurora DB cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:my-db-cluster</code>.</p> </li>
        /// <li> <p>SageMaker endpoint variant - The resource type is <code>variant</code> and the unique identifier is the resource ID. Example: <code>endpoint/my-end-point/variant/KMeansClustering</code>.</p> </li>
        /// <li> <p>Custom resources are not supported with a resource type. This parameter must specify the <code>OutputValue</code> from the CloudFormation template stack used to access the resources. The unique identifier is defined by the service provider. More information is available in our <a href="https://github.com/aws/aws-auto-scaling-custom-resource">GitHub repository</a>.</p> </li>
        /// <li> <p>Amazon Comprehend document classification endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: <code>arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE</code>.</p> </li>
        /// <li> <p>Amazon Comprehend entity recognizer endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: <code>arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE</code>.</p> </li>
        /// <li> <p>Lambda provisioned concurrency - The resource type is <code>function</code> and the unique identifier is the function name with a function version or alias name suffix that is not <code>$LATEST</code>. Example: <code>function:my-function:prod</code> or <code>function:my-function:1</code>.</p> </li>
        /// <li> <p>Amazon Keyspaces table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>keyspace/mykeyspace/table/mytable</code>.</p> </li>
        /// <li> <p>Amazon MSK cluster - The resource type and unique identifier are specified using the cluster ARN. Example: <code>arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5</code>.</p> </li>
        /// <li> <p>Amazon ElastiCache replication group - The resource type is <code>replication-group</code> and the unique identifier is the replication group name. Example: <code>replication-group/mycluster</code>.</p> </li>
        /// <li> <p>Neptune cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:mycluster</code>.</p> </li>
        /// </ul>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The identifier of the resource associated with the scalable target. This string consists of the resource type and unique identifier.</p>
        /// <ul>
        /// <li> <p>ECS service - The resource type is <code>service</code> and the unique identifier is the cluster name and service name. Example: <code>service/default/sample-webapp</code>.</p> </li>
        /// <li> <p>Spot Fleet - The resource type is <code>spot-fleet-request</code> and the unique identifier is the Spot Fleet request ID. Example: <code>spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE</code>.</p> </li>
        /// <li> <p>EMR cluster - The resource type is <code>instancegroup</code> and the unique identifier is the cluster ID and instance group ID. Example: <code>instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0</code>.</p> </li>
        /// <li> <p>AppStream 2.0 fleet - The resource type is <code>fleet</code> and the unique identifier is the fleet name. Example: <code>fleet/sample-fleet</code>.</p> </li>
        /// <li> <p>DynamoDB table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>table/my-table</code>.</p> </li>
        /// <li> <p>DynamoDB global secondary index - The resource type is <code>index</code> and the unique identifier is the index name. Example: <code>table/my-table/index/my-table-index</code>.</p> </li>
        /// <li> <p>Aurora DB cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:my-db-cluster</code>.</p> </li>
        /// <li> <p>SageMaker endpoint variant - The resource type is <code>variant</code> and the unique identifier is the resource ID. Example: <code>endpoint/my-end-point/variant/KMeansClustering</code>.</p> </li>
        /// <li> <p>Custom resources are not supported with a resource type. This parameter must specify the <code>OutputValue</code> from the CloudFormation template stack used to access the resources. The unique identifier is defined by the service provider. More information is available in our <a href="https://github.com/aws/aws-auto-scaling-custom-resource">GitHub repository</a>.</p> </li>
        /// <li> <p>Amazon Comprehend document classification endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: <code>arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE</code>.</p> </li>
        /// <li> <p>Amazon Comprehend entity recognizer endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: <code>arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE</code>.</p> </li>
        /// <li> <p>Lambda provisioned concurrency - The resource type is <code>function</code> and the unique identifier is the function name with a function version or alias name suffix that is not <code>$LATEST</code>. Example: <code>function:my-function:prod</code> or <code>function:my-function:1</code>.</p> </li>
        /// <li> <p>Amazon Keyspaces table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>keyspace/mykeyspace/table/mytable</code>.</p> </li>
        /// <li> <p>Amazon MSK cluster - The resource type and unique identifier are specified using the cluster ARN. Example: <code>arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5</code>.</p> </li>
        /// <li> <p>Amazon ElastiCache replication group - The resource type is <code>replication-group</code> and the unique identifier is the replication group name. Example: <code>replication-group/mycluster</code>.</p> </li>
        /// <li> <p>Neptune cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:mycluster</code>.</p> </li>
        /// </ul>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The scalable dimension associated with the scalable target. This string consists of the service namespace, resource type, and scaling property.</p>
        /// <ul>
        /// <li> <p> <code>ecs:service:DesiredCount</code> - The desired task count of an ECS service.</p> </li>
        /// <li> <p> <code>elasticmapreduce:instancegroup:InstanceCount</code> - The instance count of an EMR Instance Group.</p> </li>
        /// <li> <p> <code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet.</p> </li>
        /// <li> <p> <code>appstream:fleet:DesiredCapacity</code> - The desired capacity of an AppStream 2.0 fleet.</p> </li>
        /// <li> <p> <code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table.</p> </li>
        /// <li> <p> <code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table.</p> </li>
        /// <li> <p> <code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global secondary index.</p> </li>
        /// <li> <p> <code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global secondary index.</p> </li>
        /// <li> <p> <code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.</p> </li>
        /// <li> <p> <code>sagemaker:variant:DesiredInstanceCount</code> - The number of EC2 instances for an SageMaker model endpoint variant.</p> </li>
        /// <li> <p> <code>custom-resource:ResourceType:Property</code> - The scalable dimension for a custom resource provided by your own application or service.</p> </li>
        /// <li> <p> <code>comprehend:document-classifier-endpoint:DesiredInferenceUnits</code> - The number of inference units for an Amazon Comprehend document classification endpoint.</p> </li>
        /// <li> <p> <code>comprehend:entity-recognizer-endpoint:DesiredInferenceUnits</code> - The number of inference units for an Amazon Comprehend entity recognizer endpoint.</p> </li>
        /// <li> <p> <code>lambda:function:ProvisionedConcurrency</code> - The provisioned concurrency for a Lambda function.</p> </li>
        /// <li> <p> <code>cassandra:table:ReadCapacityUnits</code> - The provisioned read capacity for an Amazon Keyspaces table.</p> </li>
        /// <li> <p> <code>cassandra:table:WriteCapacityUnits</code> - The provisioned write capacity for an Amazon Keyspaces table.</p> </li>
        /// <li> <p> <code>kafka:broker-storage:VolumeSize</code> - The provisioned volume size (in GiB) for brokers in an Amazon MSK cluster.</p> </li>
        /// <li> <p> <code>elasticache:replication-group:NodeGroups</code> - The number of node groups for an Amazon ElastiCache replication group.</p> </li>
        /// <li> <p> <code>elasticache:replication-group:Replicas</code> - The number of replicas per node group for an Amazon ElastiCache replication group.</p> </li>
        /// <li> <p> <code>neptune:cluster:ReadReplicaCount</code> - The count of read replicas in an Amazon Neptune DB cluster.</p> </li>
        /// </ul>
        pub fn scalable_dimension(mut self, input: crate::model::ScalableDimension) -> Self {
            self.scalable_dimension = Some(input);
            self
        }
        /// <p>The scalable dimension associated with the scalable target. This string consists of the service namespace, resource type, and scaling property.</p>
        /// <ul>
        /// <li> <p> <code>ecs:service:DesiredCount</code> - The desired task count of an ECS service.</p> </li>
        /// <li> <p> <code>elasticmapreduce:instancegroup:InstanceCount</code> - The instance count of an EMR Instance Group.</p> </li>
        /// <li> <p> <code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet.</p> </li>
        /// <li> <p> <code>appstream:fleet:DesiredCapacity</code> - The desired capacity of an AppStream 2.0 fleet.</p> </li>
        /// <li> <p> <code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table.</p> </li>
        /// <li> <p> <code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table.</p> </li>
        /// <li> <p> <code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global secondary index.</p> </li>
        /// <li> <p> <code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global secondary index.</p> </li>
        /// <li> <p> <code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.</p> </li>
        /// <li> <p> <code>sagemaker:variant:DesiredInstanceCount</code> - The number of EC2 instances for an SageMaker model endpoint variant.</p> </li>
        /// <li> <p> <code>custom-resource:ResourceType:Property</code> - The scalable dimension for a custom resource provided by your own application or service.</p> </li>
        /// <li> <p> <code>comprehend:document-classifier-endpoint:DesiredInferenceUnits</code> - The number of inference units for an Amazon Comprehend document classification endpoint.</p> </li>
        /// <li> <p> <code>comprehend:entity-recognizer-endpoint:DesiredInferenceUnits</code> - The number of inference units for an Amazon Comprehend entity recognizer endpoint.</p> </li>
        /// <li> <p> <code>lambda:function:ProvisionedConcurrency</code> - The provisioned concurrency for a Lambda function.</p> </li>
        /// <li> <p> <code>cassandra:table:ReadCapacityUnits</code> - The provisioned read capacity for an Amazon Keyspaces table.</p> </li>
        /// <li> <p> <code>cassandra:table:WriteCapacityUnits</code> - The provisioned write capacity for an Amazon Keyspaces table.</p> </li>
        /// <li> <p> <code>kafka:broker-storage:VolumeSize</code> - The provisioned volume size (in GiB) for brokers in an Amazon MSK cluster.</p> </li>
        /// <li> <p> <code>elasticache:replication-group:NodeGroups</code> - The number of node groups for an Amazon ElastiCache replication group.</p> </li>
        /// <li> <p> <code>elasticache:replication-group:Replicas</code> - The number of replicas per node group for an Amazon ElastiCache replication group.</p> </li>
        /// <li> <p> <code>neptune:cluster:ReadReplicaCount</code> - The count of read replicas in an Amazon Neptune DB cluster.</p> </li>
        /// </ul>
        pub fn set_scalable_dimension(
            mut self,
            input: std::option::Option<crate::model::ScalableDimension>,
        ) -> Self {
            self.scalable_dimension = input;
            self
        }
        /// <p>The minimum value to scale to in response to a scale-in activity.</p>
        pub fn min_capacity(mut self, input: i32) -> Self {
            self.min_capacity = Some(input);
            self
        }
        /// <p>The minimum value to scale to in response to a scale-in activity.</p>
        pub fn set_min_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.min_capacity = input;
            self
        }
        /// <p>The maximum value to scale to in response to a scale-out activity.</p>
        pub fn max_capacity(mut self, input: i32) -> Self {
            self.max_capacity = Some(input);
            self
        }
        /// <p>The maximum value to scale to in response to a scale-out activity.</p>
        pub fn set_max_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.max_capacity = input;
            self
        }
        /// <p>The ARN of an IAM role that allows Application Auto Scaling to modify the scalable target on your behalf.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of an IAM role that allows Application Auto Scaling to modify the scalable target on your behalf.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The Unix timestamp for when the scalable target was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The Unix timestamp for when the scalable target was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>Specifies whether the scaling activities for a scalable target are in a suspended state. </p>
        pub fn suspended_state(mut self, input: crate::model::SuspendedState) -> Self {
            self.suspended_state = Some(input);
            self
        }
        /// <p>Specifies whether the scaling activities for a scalable target are in a suspended state. </p>
        pub fn set_suspended_state(
            mut self,
            input: std::option::Option<crate::model::SuspendedState>,
        ) -> Self {
            self.suspended_state = input;
            self
        }
        /// Consumes the builder and constructs a [`ScalableTarget`](crate::model::ScalableTarget)
        pub fn build(self) -> crate::model::ScalableTarget {
            crate::model::ScalableTarget {
                service_namespace: self.service_namespace,
                resource_id: self.resource_id,
                scalable_dimension: self.scalable_dimension,
                min_capacity: self.min_capacity,
                max_capacity: self.max_capacity,
                role_arn: self.role_arn,
                creation_time: self.creation_time,
                suspended_state: self.suspended_state,
            }
        }
    }
}
impl ScalableTarget {
    /// Creates a new builder-style object to manufacture [`ScalableTarget`](crate::model::ScalableTarget)
    pub fn builder() -> crate::model::scalable_target::Builder {
        crate::model::scalable_target::Builder::default()
    }
}
