// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `DeleteScalingPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteScalingPolicyError {
    /// Kind of error that occurred.
    pub kind: DeleteScalingPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteScalingPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteScalingPolicyErrorKind {
    /// <p>Concurrent updates caused an exception, for example, if you request an update to an
    /// Application Auto Scaling resource that already has a pending update.</p>
    ConcurrentUpdateException(crate::error::ConcurrentUpdateException),
    /// <p>The service encountered an internal error.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The specified object could not be found. For any operation that depends on the existence
    /// of a scalable target, this exception is thrown if the scalable target with the specified
    /// service namespace, resource ID, and scalable dimension does not exist. For any operation
    /// that deletes or deregisters a resource, this exception is thrown if the resource cannot be
    /// found.</p>
    ObjectNotFoundException(crate::error::ObjectNotFoundException),
    /// <p>An exception was thrown for a validation issue. Review the available parameters for the
    /// API request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteScalingPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteScalingPolicyErrorKind::ConcurrentUpdateException(_inner) => _inner.fmt(f),
            DeleteScalingPolicyErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DeleteScalingPolicyErrorKind::ObjectNotFoundException(_inner) => _inner.fmt(f),
            DeleteScalingPolicyErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteScalingPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteScalingPolicyError {
    fn code(&self) -> Option<&str> {
        DeleteScalingPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteScalingPolicyError {
    /// Creates a new `DeleteScalingPolicyError`.
    pub fn new(kind: DeleteScalingPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteScalingPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteScalingPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteScalingPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteScalingPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteScalingPolicyErrorKind::ConcurrentUpdateException`.
    pub fn is_concurrent_update_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteScalingPolicyErrorKind::ConcurrentUpdateException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteScalingPolicyErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteScalingPolicyErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteScalingPolicyErrorKind::ObjectNotFoundException`.
    pub fn is_object_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteScalingPolicyErrorKind::ObjectNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteScalingPolicyErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteScalingPolicyErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteScalingPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteScalingPolicyErrorKind::ConcurrentUpdateException(_inner) => Some(_inner),
            DeleteScalingPolicyErrorKind::InternalServiceException(_inner) => Some(_inner),
            DeleteScalingPolicyErrorKind::ObjectNotFoundException(_inner) => Some(_inner),
            DeleteScalingPolicyErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteScalingPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteScheduledAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteScheduledActionError {
    /// Kind of error that occurred.
    pub kind: DeleteScheduledActionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteScheduledAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteScheduledActionErrorKind {
    /// <p>Concurrent updates caused an exception, for example, if you request an update to an
    /// Application Auto Scaling resource that already has a pending update.</p>
    ConcurrentUpdateException(crate::error::ConcurrentUpdateException),
    /// <p>The service encountered an internal error.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The specified object could not be found. For any operation that depends on the existence
    /// of a scalable target, this exception is thrown if the scalable target with the specified
    /// service namespace, resource ID, and scalable dimension does not exist. For any operation
    /// that deletes or deregisters a resource, this exception is thrown if the resource cannot be
    /// found.</p>
    ObjectNotFoundException(crate::error::ObjectNotFoundException),
    /// <p>An exception was thrown for a validation issue. Review the available parameters for the
    /// API request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteScheduledActionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteScheduledActionErrorKind::ConcurrentUpdateException(_inner) => _inner.fmt(f),
            DeleteScheduledActionErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DeleteScheduledActionErrorKind::ObjectNotFoundException(_inner) => _inner.fmt(f),
            DeleteScheduledActionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteScheduledActionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteScheduledActionError {
    fn code(&self) -> Option<&str> {
        DeleteScheduledActionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteScheduledActionError {
    /// Creates a new `DeleteScheduledActionError`.
    pub fn new(kind: DeleteScheduledActionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteScheduledActionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteScheduledActionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteScheduledActionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteScheduledActionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteScheduledActionErrorKind::ConcurrentUpdateException`.
    pub fn is_concurrent_update_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteScheduledActionErrorKind::ConcurrentUpdateException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteScheduledActionErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteScheduledActionErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteScheduledActionErrorKind::ObjectNotFoundException`.
    pub fn is_object_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteScheduledActionErrorKind::ObjectNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteScheduledActionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteScheduledActionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteScheduledActionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteScheduledActionErrorKind::ConcurrentUpdateException(_inner) => Some(_inner),
            DeleteScheduledActionErrorKind::InternalServiceException(_inner) => Some(_inner),
            DeleteScheduledActionErrorKind::ObjectNotFoundException(_inner) => Some(_inner),
            DeleteScheduledActionErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteScheduledActionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeregisterScalableTarget` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeregisterScalableTargetError {
    /// Kind of error that occurred.
    pub kind: DeregisterScalableTargetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeregisterScalableTarget` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeregisterScalableTargetErrorKind {
    /// <p>Concurrent updates caused an exception, for example, if you request an update to an
    /// Application Auto Scaling resource that already has a pending update.</p>
    ConcurrentUpdateException(crate::error::ConcurrentUpdateException),
    /// <p>The service encountered an internal error.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The specified object could not be found. For any operation that depends on the existence
    /// of a scalable target, this exception is thrown if the scalable target with the specified
    /// service namespace, resource ID, and scalable dimension does not exist. For any operation
    /// that deletes or deregisters a resource, this exception is thrown if the resource cannot be
    /// found.</p>
    ObjectNotFoundException(crate::error::ObjectNotFoundException),
    /// <p>An exception was thrown for a validation issue. Review the available parameters for the
    /// API request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeregisterScalableTargetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeregisterScalableTargetErrorKind::ConcurrentUpdateException(_inner) => _inner.fmt(f),
            DeregisterScalableTargetErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DeregisterScalableTargetErrorKind::ObjectNotFoundException(_inner) => _inner.fmt(f),
            DeregisterScalableTargetErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeregisterScalableTargetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeregisterScalableTargetError {
    fn code(&self) -> Option<&str> {
        DeregisterScalableTargetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeregisterScalableTargetError {
    /// Creates a new `DeregisterScalableTargetError`.
    pub fn new(kind: DeregisterScalableTargetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeregisterScalableTargetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeregisterScalableTargetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeregisterScalableTargetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeregisterScalableTargetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeregisterScalableTargetErrorKind::ConcurrentUpdateException`.
    pub fn is_concurrent_update_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterScalableTargetErrorKind::ConcurrentUpdateException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterScalableTargetErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterScalableTargetErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterScalableTargetErrorKind::ObjectNotFoundException`.
    pub fn is_object_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterScalableTargetErrorKind::ObjectNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterScalableTargetErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterScalableTargetErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeregisterScalableTargetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeregisterScalableTargetErrorKind::ConcurrentUpdateException(_inner) => Some(_inner),
            DeregisterScalableTargetErrorKind::InternalServiceException(_inner) => Some(_inner),
            DeregisterScalableTargetErrorKind::ObjectNotFoundException(_inner) => Some(_inner),
            DeregisterScalableTargetErrorKind::ValidationException(_inner) => Some(_inner),
            DeregisterScalableTargetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeScalableTargets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeScalableTargetsError {
    /// Kind of error that occurred.
    pub kind: DescribeScalableTargetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeScalableTargets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeScalableTargetsErrorKind {
    /// <p>Concurrent updates caused an exception, for example, if you request an update to an
    /// Application Auto Scaling resource that already has a pending update.</p>
    ConcurrentUpdateException(crate::error::ConcurrentUpdateException),
    /// <p>The service encountered an internal error.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The next token supplied was invalid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>An exception was thrown for a validation issue. Review the available parameters for the
    /// API request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeScalableTargetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeScalableTargetsErrorKind::ConcurrentUpdateException(_inner) => _inner.fmt(f),
            DescribeScalableTargetsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DescribeScalableTargetsErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            DescribeScalableTargetsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeScalableTargetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeScalableTargetsError {
    fn code(&self) -> Option<&str> {
        DescribeScalableTargetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeScalableTargetsError {
    /// Creates a new `DescribeScalableTargetsError`.
    pub fn new(kind: DescribeScalableTargetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeScalableTargetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeScalableTargetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeScalableTargetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeScalableTargetsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeScalableTargetsErrorKind::ConcurrentUpdateException`.
    pub fn is_concurrent_update_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeScalableTargetsErrorKind::ConcurrentUpdateException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeScalableTargetsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeScalableTargetsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeScalableTargetsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeScalableTargetsErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeScalableTargetsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeScalableTargetsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeScalableTargetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeScalableTargetsErrorKind::ConcurrentUpdateException(_inner) => Some(_inner),
            DescribeScalableTargetsErrorKind::InternalServiceException(_inner) => Some(_inner),
            DescribeScalableTargetsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            DescribeScalableTargetsErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeScalableTargetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeScalingActivities` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeScalingActivitiesError {
    /// Kind of error that occurred.
    pub kind: DescribeScalingActivitiesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeScalingActivities` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeScalingActivitiesErrorKind {
    /// <p>Concurrent updates caused an exception, for example, if you request an update to an
    /// Application Auto Scaling resource that already has a pending update.</p>
    ConcurrentUpdateException(crate::error::ConcurrentUpdateException),
    /// <p>The service encountered an internal error.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The next token supplied was invalid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>An exception was thrown for a validation issue. Review the available parameters for the
    /// API request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeScalingActivitiesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeScalingActivitiesErrorKind::ConcurrentUpdateException(_inner) => _inner.fmt(f),
            DescribeScalingActivitiesErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DescribeScalingActivitiesErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            DescribeScalingActivitiesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeScalingActivitiesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeScalingActivitiesError {
    fn code(&self) -> Option<&str> {
        DescribeScalingActivitiesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeScalingActivitiesError {
    /// Creates a new `DescribeScalingActivitiesError`.
    pub fn new(kind: DescribeScalingActivitiesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeScalingActivitiesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeScalingActivitiesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeScalingActivitiesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeScalingActivitiesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeScalingActivitiesErrorKind::ConcurrentUpdateException`.
    pub fn is_concurrent_update_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeScalingActivitiesErrorKind::ConcurrentUpdateException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeScalingActivitiesErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeScalingActivitiesErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeScalingActivitiesErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeScalingActivitiesErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeScalingActivitiesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeScalingActivitiesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeScalingActivitiesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeScalingActivitiesErrorKind::ConcurrentUpdateException(_inner) => Some(_inner),
            DescribeScalingActivitiesErrorKind::InternalServiceException(_inner) => Some(_inner),
            DescribeScalingActivitiesErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            DescribeScalingActivitiesErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeScalingActivitiesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeScalingPolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeScalingPoliciesError {
    /// Kind of error that occurred.
    pub kind: DescribeScalingPoliciesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeScalingPolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeScalingPoliciesErrorKind {
    /// <p>Concurrent updates caused an exception, for example, if you request an update to an
    /// Application Auto Scaling resource that already has a pending update.</p>
    ConcurrentUpdateException(crate::error::ConcurrentUpdateException),
    /// <p>Failed access to resources caused an exception. This exception is thrown when Application Auto Scaling
    /// is unable to retrieve the alarms associated with a scaling policy due to a client error,
    /// for example, if the role ARN specified for a scalable target does not have permission to
    /// call the CloudWatch <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_DescribeAlarms.html">DescribeAlarms</a> on your behalf.</p>
    FailedResourceAccessException(crate::error::FailedResourceAccessException),
    /// <p>The service encountered an internal error.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The next token supplied was invalid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>An exception was thrown for a validation issue. Review the available parameters for the
    /// API request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeScalingPoliciesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeScalingPoliciesErrorKind::ConcurrentUpdateException(_inner) => _inner.fmt(f),
            DescribeScalingPoliciesErrorKind::FailedResourceAccessException(_inner) => {
                _inner.fmt(f)
            }
            DescribeScalingPoliciesErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DescribeScalingPoliciesErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            DescribeScalingPoliciesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeScalingPoliciesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeScalingPoliciesError {
    fn code(&self) -> Option<&str> {
        DescribeScalingPoliciesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeScalingPoliciesError {
    /// Creates a new `DescribeScalingPoliciesError`.
    pub fn new(kind: DescribeScalingPoliciesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeScalingPoliciesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeScalingPoliciesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeScalingPoliciesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeScalingPoliciesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeScalingPoliciesErrorKind::ConcurrentUpdateException`.
    pub fn is_concurrent_update_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeScalingPoliciesErrorKind::ConcurrentUpdateException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeScalingPoliciesErrorKind::FailedResourceAccessException`.
    pub fn is_failed_resource_access_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeScalingPoliciesErrorKind::FailedResourceAccessException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeScalingPoliciesErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeScalingPoliciesErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeScalingPoliciesErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeScalingPoliciesErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeScalingPoliciesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeScalingPoliciesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeScalingPoliciesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeScalingPoliciesErrorKind::ConcurrentUpdateException(_inner) => Some(_inner),
            DescribeScalingPoliciesErrorKind::FailedResourceAccessException(_inner) => Some(_inner),
            DescribeScalingPoliciesErrorKind::InternalServiceException(_inner) => Some(_inner),
            DescribeScalingPoliciesErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            DescribeScalingPoliciesErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeScalingPoliciesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeScheduledActions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeScheduledActionsError {
    /// Kind of error that occurred.
    pub kind: DescribeScheduledActionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeScheduledActions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeScheduledActionsErrorKind {
    /// <p>Concurrent updates caused an exception, for example, if you request an update to an
    /// Application Auto Scaling resource that already has a pending update.</p>
    ConcurrentUpdateException(crate::error::ConcurrentUpdateException),
    /// <p>The service encountered an internal error.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The next token supplied was invalid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>An exception was thrown for a validation issue. Review the available parameters for the
    /// API request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeScheduledActionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeScheduledActionsErrorKind::ConcurrentUpdateException(_inner) => _inner.fmt(f),
            DescribeScheduledActionsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DescribeScheduledActionsErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            DescribeScheduledActionsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeScheduledActionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeScheduledActionsError {
    fn code(&self) -> Option<&str> {
        DescribeScheduledActionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeScheduledActionsError {
    /// Creates a new `DescribeScheduledActionsError`.
    pub fn new(kind: DescribeScheduledActionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeScheduledActionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeScheduledActionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeScheduledActionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeScheduledActionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeScheduledActionsErrorKind::ConcurrentUpdateException`.
    pub fn is_concurrent_update_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeScheduledActionsErrorKind::ConcurrentUpdateException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeScheduledActionsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeScheduledActionsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeScheduledActionsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeScheduledActionsErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeScheduledActionsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeScheduledActionsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeScheduledActionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeScheduledActionsErrorKind::ConcurrentUpdateException(_inner) => Some(_inner),
            DescribeScheduledActionsErrorKind::InternalServiceException(_inner) => Some(_inner),
            DescribeScheduledActionsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            DescribeScheduledActionsErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeScheduledActionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutScalingPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutScalingPolicyError {
    /// Kind of error that occurred.
    pub kind: PutScalingPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutScalingPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutScalingPolicyErrorKind {
    /// <p>Concurrent updates caused an exception, for example, if you request an update to an
    /// Application Auto Scaling resource that already has a pending update.</p>
    ConcurrentUpdateException(crate::error::ConcurrentUpdateException),
    /// <p>Failed access to resources caused an exception. This exception is thrown when Application Auto Scaling
    /// is unable to retrieve the alarms associated with a scaling policy due to a client error,
    /// for example, if the role ARN specified for a scalable target does not have permission to
    /// call the CloudWatch <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_DescribeAlarms.html">DescribeAlarms</a> on your behalf.</p>
    FailedResourceAccessException(crate::error::FailedResourceAccessException),
    /// <p>The service encountered an internal error.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>A per-account resource limit is exceeded. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-limits.html">Application Auto Scaling service quotas</a>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified object could not be found. For any operation that depends on the existence
    /// of a scalable target, this exception is thrown if the scalable target with the specified
    /// service namespace, resource ID, and scalable dimension does not exist. For any operation
    /// that deletes or deregisters a resource, this exception is thrown if the resource cannot be
    /// found.</p>
    ObjectNotFoundException(crate::error::ObjectNotFoundException),
    /// <p>An exception was thrown for a validation issue. Review the available parameters for the
    /// API request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutScalingPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutScalingPolicyErrorKind::ConcurrentUpdateException(_inner) => _inner.fmt(f),
            PutScalingPolicyErrorKind::FailedResourceAccessException(_inner) => _inner.fmt(f),
            PutScalingPolicyErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            PutScalingPolicyErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            PutScalingPolicyErrorKind::ObjectNotFoundException(_inner) => _inner.fmt(f),
            PutScalingPolicyErrorKind::ValidationException(_inner) => _inner.fmt(f),
            PutScalingPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutScalingPolicyError {
    fn code(&self) -> Option<&str> {
        PutScalingPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutScalingPolicyError {
    /// Creates a new `PutScalingPolicyError`.
    pub fn new(kind: PutScalingPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutScalingPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutScalingPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutScalingPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutScalingPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutScalingPolicyErrorKind::ConcurrentUpdateException`.
    pub fn is_concurrent_update_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutScalingPolicyErrorKind::ConcurrentUpdateException(_)
        )
    }
    /// Returns `true` if the error kind is `PutScalingPolicyErrorKind::FailedResourceAccessException`.
    pub fn is_failed_resource_access_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutScalingPolicyErrorKind::FailedResourceAccessException(_)
        )
    }
    /// Returns `true` if the error kind is `PutScalingPolicyErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutScalingPolicyErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `PutScalingPolicyErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutScalingPolicyErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `PutScalingPolicyErrorKind::ObjectNotFoundException`.
    pub fn is_object_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutScalingPolicyErrorKind::ObjectNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutScalingPolicyErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutScalingPolicyErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for PutScalingPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutScalingPolicyErrorKind::ConcurrentUpdateException(_inner) => Some(_inner),
            PutScalingPolicyErrorKind::FailedResourceAccessException(_inner) => Some(_inner),
            PutScalingPolicyErrorKind::InternalServiceException(_inner) => Some(_inner),
            PutScalingPolicyErrorKind::LimitExceededException(_inner) => Some(_inner),
            PutScalingPolicyErrorKind::ObjectNotFoundException(_inner) => Some(_inner),
            PutScalingPolicyErrorKind::ValidationException(_inner) => Some(_inner),
            PutScalingPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutScheduledAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutScheduledActionError {
    /// Kind of error that occurred.
    pub kind: PutScheduledActionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutScheduledAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutScheduledActionErrorKind {
    /// <p>Concurrent updates caused an exception, for example, if you request an update to an
    /// Application Auto Scaling resource that already has a pending update.</p>
    ConcurrentUpdateException(crate::error::ConcurrentUpdateException),
    /// <p>The service encountered an internal error.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>A per-account resource limit is exceeded. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-limits.html">Application Auto Scaling service quotas</a>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified object could not be found. For any operation that depends on the existence
    /// of a scalable target, this exception is thrown if the scalable target with the specified
    /// service namespace, resource ID, and scalable dimension does not exist. For any operation
    /// that deletes or deregisters a resource, this exception is thrown if the resource cannot be
    /// found.</p>
    ObjectNotFoundException(crate::error::ObjectNotFoundException),
    /// <p>An exception was thrown for a validation issue. Review the available parameters for the
    /// API request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutScheduledActionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutScheduledActionErrorKind::ConcurrentUpdateException(_inner) => _inner.fmt(f),
            PutScheduledActionErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            PutScheduledActionErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            PutScheduledActionErrorKind::ObjectNotFoundException(_inner) => _inner.fmt(f),
            PutScheduledActionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            PutScheduledActionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutScheduledActionError {
    fn code(&self) -> Option<&str> {
        PutScheduledActionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutScheduledActionError {
    /// Creates a new `PutScheduledActionError`.
    pub fn new(kind: PutScheduledActionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutScheduledActionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutScheduledActionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutScheduledActionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutScheduledActionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutScheduledActionErrorKind::ConcurrentUpdateException`.
    pub fn is_concurrent_update_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutScheduledActionErrorKind::ConcurrentUpdateException(_)
        )
    }
    /// Returns `true` if the error kind is `PutScheduledActionErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutScheduledActionErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `PutScheduledActionErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutScheduledActionErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `PutScheduledActionErrorKind::ObjectNotFoundException`.
    pub fn is_object_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutScheduledActionErrorKind::ObjectNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutScheduledActionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutScheduledActionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for PutScheduledActionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutScheduledActionErrorKind::ConcurrentUpdateException(_inner) => Some(_inner),
            PutScheduledActionErrorKind::InternalServiceException(_inner) => Some(_inner),
            PutScheduledActionErrorKind::LimitExceededException(_inner) => Some(_inner),
            PutScheduledActionErrorKind::ObjectNotFoundException(_inner) => Some(_inner),
            PutScheduledActionErrorKind::ValidationException(_inner) => Some(_inner),
            PutScheduledActionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RegisterScalableTarget` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RegisterScalableTargetError {
    /// Kind of error that occurred.
    pub kind: RegisterScalableTargetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RegisterScalableTarget` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RegisterScalableTargetErrorKind {
    /// <p>Concurrent updates caused an exception, for example, if you request an update to an
    /// Application Auto Scaling resource that already has a pending update.</p>
    ConcurrentUpdateException(crate::error::ConcurrentUpdateException),
    /// <p>The service encountered an internal error.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>A per-account resource limit is exceeded. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-limits.html">Application Auto Scaling service quotas</a>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>An exception was thrown for a validation issue. Review the available parameters for the
    /// API request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RegisterScalableTargetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RegisterScalableTargetErrorKind::ConcurrentUpdateException(_inner) => _inner.fmt(f),
            RegisterScalableTargetErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            RegisterScalableTargetErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            RegisterScalableTargetErrorKind::ValidationException(_inner) => _inner.fmt(f),
            RegisterScalableTargetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RegisterScalableTargetError {
    fn code(&self) -> Option<&str> {
        RegisterScalableTargetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RegisterScalableTargetError {
    /// Creates a new `RegisterScalableTargetError`.
    pub fn new(kind: RegisterScalableTargetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RegisterScalableTargetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RegisterScalableTargetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RegisterScalableTargetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RegisterScalableTargetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RegisterScalableTargetErrorKind::ConcurrentUpdateException`.
    pub fn is_concurrent_update_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterScalableTargetErrorKind::ConcurrentUpdateException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterScalableTargetErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterScalableTargetErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterScalableTargetErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterScalableTargetErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterScalableTargetErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterScalableTargetErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for RegisterScalableTargetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RegisterScalableTargetErrorKind::ConcurrentUpdateException(_inner) => Some(_inner),
            RegisterScalableTargetErrorKind::InternalServiceException(_inner) => Some(_inner),
            RegisterScalableTargetErrorKind::LimitExceededException(_inner) => Some(_inner),
            RegisterScalableTargetErrorKind::ValidationException(_inner) => Some(_inner),
            RegisterScalableTargetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>An exception was thrown for a validation issue. Review the available parameters for the
/// API request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ValidationException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ValidationException {}
/// See [`ValidationException`](crate::error::ValidationException)
pub mod validation_exception {
    /// A builder for [`ValidationException`](crate::error::ValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationException`](crate::error::ValidationException)
        pub fn build(self) -> crate::error::ValidationException {
            crate::error::ValidationException {
                message: self.message,
            }
        }
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::error::ValidationException)
    pub fn builder() -> crate::error::validation_exception::Builder {
        crate::error::validation_exception::Builder::default()
    }
}

/// <p>A per-account resource limit is exceeded. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-limits.html">Application Auto Scaling service quotas</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededException {}
/// See [`LimitExceededException`](crate::error::LimitExceededException)
pub mod limit_exceeded_exception {
    /// A builder for [`LimitExceededException`](crate::error::LimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededException`](crate::error::LimitExceededException)
        pub fn build(self) -> crate::error::LimitExceededException {
            crate::error::LimitExceededException {
                message: self.message,
            }
        }
    }
}
impl LimitExceededException {
    /// Creates a new builder-style object to manufacture [`LimitExceededException`](crate::error::LimitExceededException)
    pub fn builder() -> crate::error::limit_exceeded_exception::Builder {
        crate::error::limit_exceeded_exception::Builder::default()
    }
}

/// <p>The service encountered an internal error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServiceException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServiceException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServiceException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServiceException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServiceException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServiceException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServiceException {}
/// See [`InternalServiceException`](crate::error::InternalServiceException)
pub mod internal_service_exception {
    /// A builder for [`InternalServiceException`](crate::error::InternalServiceException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServiceException`](crate::error::InternalServiceException)
        pub fn build(self) -> crate::error::InternalServiceException {
            crate::error::InternalServiceException {
                message: self.message,
            }
        }
    }
}
impl InternalServiceException {
    /// Creates a new builder-style object to manufacture [`InternalServiceException`](crate::error::InternalServiceException)
    pub fn builder() -> crate::error::internal_service_exception::Builder {
        crate::error::internal_service_exception::Builder::default()
    }
}

/// <p>Concurrent updates caused an exception, for example, if you request an update to an
/// Application Auto Scaling resource that already has a pending update.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConcurrentUpdateException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConcurrentUpdateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConcurrentUpdateException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConcurrentUpdateException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConcurrentUpdateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConcurrentUpdateException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConcurrentUpdateException {}
/// See [`ConcurrentUpdateException`](crate::error::ConcurrentUpdateException)
pub mod concurrent_update_exception {
    /// A builder for [`ConcurrentUpdateException`](crate::error::ConcurrentUpdateException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConcurrentUpdateException`](crate::error::ConcurrentUpdateException)
        pub fn build(self) -> crate::error::ConcurrentUpdateException {
            crate::error::ConcurrentUpdateException {
                message: self.message,
            }
        }
    }
}
impl ConcurrentUpdateException {
    /// Creates a new builder-style object to manufacture [`ConcurrentUpdateException`](crate::error::ConcurrentUpdateException)
    pub fn builder() -> crate::error::concurrent_update_exception::Builder {
        crate::error::concurrent_update_exception::Builder::default()
    }
}

/// <p>The specified object could not be found. For any operation that depends on the existence
/// of a scalable target, this exception is thrown if the scalable target with the specified
/// service namespace, resource ID, and scalable dimension does not exist. For any operation
/// that deletes or deregisters a resource, this exception is thrown if the resource cannot be
/// found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ObjectNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ObjectNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ObjectNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ObjectNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ObjectNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ObjectNotFoundException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for ObjectNotFoundException {}
/// See [`ObjectNotFoundException`](crate::error::ObjectNotFoundException)
pub mod object_not_found_exception {
    /// A builder for [`ObjectNotFoundException`](crate::error::ObjectNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ObjectNotFoundException`](crate::error::ObjectNotFoundException)
        pub fn build(self) -> crate::error::ObjectNotFoundException {
            crate::error::ObjectNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ObjectNotFoundException {
    /// Creates a new builder-style object to manufacture [`ObjectNotFoundException`](crate::error::ObjectNotFoundException)
    pub fn builder() -> crate::error::object_not_found_exception::Builder {
        crate::error::object_not_found_exception::Builder::default()
    }
}

/// <p>Failed access to resources caused an exception. This exception is thrown when Application Auto Scaling
/// is unable to retrieve the alarms associated with a scaling policy due to a client error,
/// for example, if the role ARN specified for a scalable target does not have permission to
/// call the CloudWatch <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_DescribeAlarms.html">DescribeAlarms</a> on your behalf.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FailedResourceAccessException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for FailedResourceAccessException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FailedResourceAccessException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl FailedResourceAccessException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for FailedResourceAccessException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "FailedResourceAccessException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for FailedResourceAccessException {}
/// See [`FailedResourceAccessException`](crate::error::FailedResourceAccessException)
pub mod failed_resource_access_exception {
    /// A builder for [`FailedResourceAccessException`](crate::error::FailedResourceAccessException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`FailedResourceAccessException`](crate::error::FailedResourceAccessException)
        pub fn build(self) -> crate::error::FailedResourceAccessException {
            crate::error::FailedResourceAccessException {
                message: self.message,
            }
        }
    }
}
impl FailedResourceAccessException {
    /// Creates a new builder-style object to manufacture [`FailedResourceAccessException`](crate::error::FailedResourceAccessException)
    pub fn builder() -> crate::error::failed_resource_access_exception::Builder {
        crate::error::failed_resource_access_exception::Builder::default()
    }
}

/// <p>The next token supplied was invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidNextTokenException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidNextTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidNextTokenException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidNextTokenException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidNextTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidNextTokenException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidNextTokenException {}
/// See [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
pub mod invalid_next_token_exception {
    /// A builder for [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
        pub fn build(self) -> crate::error::InvalidNextTokenException {
            crate::error::InvalidNextTokenException {
                message: self.message,
            }
        }
    }
}
impl InvalidNextTokenException {
    /// Creates a new builder-style object to manufacture [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
    pub fn builder() -> crate::error::invalid_next_token_exception::Builder {
        crate::error::invalid_next_token_exception::Builder::default()
    }
}
