// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon AppIntegrations Service
///
/// Client for invoking operations on Amazon AppIntegrations Service. Each operation on Amazon AppIntegrations Service is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_appintegrations::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_appintegrations::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_appintegrations::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`CreateDataIntegration`](crate::client::fluent_builders::CreateDataIntegration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateDataIntegration::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateDataIntegration::set_name): <p>The name of the DataIntegration.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateDataIntegration::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateDataIntegration::set_description): <p>A description of the DataIntegration.</p>
    ///   - [`kms_key(impl Into<String>)`](crate::client::fluent_builders::CreateDataIntegration::kms_key) / [`set_kms_key(Option<String>)`](crate::client::fluent_builders::CreateDataIntegration::set_kms_key): <p>The KMS key for the DataIntegration.</p>
    ///   - [`source_uri(impl Into<String>)`](crate::client::fluent_builders::CreateDataIntegration::source_uri) / [`set_source_uri(Option<String>)`](crate::client::fluent_builders::CreateDataIntegration::set_source_uri): <p>The URI of the data source.</p>
    ///   - [`schedule_config(ScheduleConfiguration)`](crate::client::fluent_builders::CreateDataIntegration::schedule_config) / [`set_schedule_config(Option<ScheduleConfiguration>)`](crate::client::fluent_builders::CreateDataIntegration::set_schedule_config): <p>The name of the data and how often it should be pulled from the source.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateDataIntegration::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateDataIntegration::set_tags): <p>One or more tags.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateDataIntegration::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateDataIntegration::set_client_token): <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    /// - On success, responds with [`CreateDataIntegrationOutput`](crate::output::CreateDataIntegrationOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::CreateDataIntegrationOutput::arn): <p>The Amazon Resource Name (ARN)</p>
    ///   - [`id(Option<String>)`](crate::output::CreateDataIntegrationOutput::id): <p>A unique identifier.</p>
    ///   - [`name(Option<String>)`](crate::output::CreateDataIntegrationOutput::name): <p>The name of the DataIntegration.</p>
    ///   - [`description(Option<String>)`](crate::output::CreateDataIntegrationOutput::description): <p>A description of the DataIntegration.</p>
    ///   - [`kms_key(Option<String>)`](crate::output::CreateDataIntegrationOutput::kms_key): <p>The KMS key for the DataIntegration.</p>
    ///   - [`source_uri(Option<String>)`](crate::output::CreateDataIntegrationOutput::source_uri): <p>The URI of the data source.</p>
    ///   - [`schedule_configuration(Option<ScheduleConfiguration>)`](crate::output::CreateDataIntegrationOutput::schedule_configuration): <p>The name of the data and how often it should be pulled from the source.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::CreateDataIntegrationOutput::tags): <p>One or more tags.</p>
    ///   - [`client_token(Option<String>)`](crate::output::CreateDataIntegrationOutput::client_token): <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    /// - On failure, responds with [`SdkError<CreateDataIntegrationError>`](crate::error::CreateDataIntegrationError)
    pub fn create_data_integration(&self) -> fluent_builders::CreateDataIntegration {
        fluent_builders::CreateDataIntegration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateEventIntegration`](crate::client::fluent_builders::CreateEventIntegration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateEventIntegration::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateEventIntegration::set_name): <p>The name of the event integration.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateEventIntegration::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateEventIntegration::set_description): <p>The description of the event integration.</p>
    ///   - [`event_filter(EventFilter)`](crate::client::fluent_builders::CreateEventIntegration::event_filter) / [`set_event_filter(Option<EventFilter>)`](crate::client::fluent_builders::CreateEventIntegration::set_event_filter): <p>The event filter.</p>
    ///   - [`event_bridge_bus(impl Into<String>)`](crate::client::fluent_builders::CreateEventIntegration::event_bridge_bus) / [`set_event_bridge_bus(Option<String>)`](crate::client::fluent_builders::CreateEventIntegration::set_event_bridge_bus): <p>The EventBridge bus.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateEventIntegration::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateEventIntegration::set_client_token): <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateEventIntegration::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateEventIntegration::set_tags): <p>One or more tags.</p>
    /// - On success, responds with [`CreateEventIntegrationOutput`](crate::output::CreateEventIntegrationOutput) with field(s):
    ///   - [`event_integration_arn(Option<String>)`](crate::output::CreateEventIntegrationOutput::event_integration_arn): <p>The Amazon Resource Name (ARN) of the event integration. </p>
    /// - On failure, responds with [`SdkError<CreateEventIntegrationError>`](crate::error::CreateEventIntegrationError)
    pub fn create_event_integration(&self) -> fluent_builders::CreateEventIntegration {
        fluent_builders::CreateEventIntegration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDataIntegration`](crate::client::fluent_builders::DeleteDataIntegration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`data_integration_identifier(impl Into<String>)`](crate::client::fluent_builders::DeleteDataIntegration::data_integration_identifier) / [`set_data_integration_identifier(Option<String>)`](crate::client::fluent_builders::DeleteDataIntegration::set_data_integration_identifier): <p>A unique identifier for the DataIntegration.</p>
    /// - On success, responds with [`DeleteDataIntegrationOutput`](crate::output::DeleteDataIntegrationOutput)

    /// - On failure, responds with [`SdkError<DeleteDataIntegrationError>`](crate::error::DeleteDataIntegrationError)
    pub fn delete_data_integration(&self) -> fluent_builders::DeleteDataIntegration {
        fluent_builders::DeleteDataIntegration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteEventIntegration`](crate::client::fluent_builders::DeleteEventIntegration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteEventIntegration::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteEventIntegration::set_name): <p>The name of the event integration.</p>
    /// - On success, responds with [`DeleteEventIntegrationOutput`](crate::output::DeleteEventIntegrationOutput)

    /// - On failure, responds with [`SdkError<DeleteEventIntegrationError>`](crate::error::DeleteEventIntegrationError)
    pub fn delete_event_integration(&self) -> fluent_builders::DeleteEventIntegration {
        fluent_builders::DeleteEventIntegration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDataIntegration`](crate::client::fluent_builders::GetDataIntegration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identifier(impl Into<String>)`](crate::client::fluent_builders::GetDataIntegration::identifier) / [`set_identifier(Option<String>)`](crate::client::fluent_builders::GetDataIntegration::set_identifier): <p>A unique identifier.</p>
    /// - On success, responds with [`GetDataIntegrationOutput`](crate::output::GetDataIntegrationOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::GetDataIntegrationOutput::arn): <p>The Amazon Resource Name (ARN) for the DataIntegration.</p>
    ///   - [`id(Option<String>)`](crate::output::GetDataIntegrationOutput::id): <p>A unique identifier.</p>
    ///   - [`name(Option<String>)`](crate::output::GetDataIntegrationOutput::name): <p>The name of the DataIntegration.</p>
    ///   - [`description(Option<String>)`](crate::output::GetDataIntegrationOutput::description): <p>The KMS key for the DataIntegration.</p>
    ///   - [`kms_key(Option<String>)`](crate::output::GetDataIntegrationOutput::kms_key): <p>The KMS key for the DataIntegration.</p>
    ///   - [`source_uri(Option<String>)`](crate::output::GetDataIntegrationOutput::source_uri): <p>The URI of the data source.</p>
    ///   - [`schedule_configuration(Option<ScheduleConfiguration>)`](crate::output::GetDataIntegrationOutput::schedule_configuration): <p>The name of the data and how often it should be pulled from the source.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::GetDataIntegrationOutput::tags): <p>One or more tags.</p>
    /// - On failure, responds with [`SdkError<GetDataIntegrationError>`](crate::error::GetDataIntegrationError)
    pub fn get_data_integration(&self) -> fluent_builders::GetDataIntegration {
        fluent_builders::GetDataIntegration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetEventIntegration`](crate::client::fluent_builders::GetEventIntegration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::GetEventIntegration::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::GetEventIntegration::set_name): <p>The name of the event integration. </p>
    /// - On success, responds with [`GetEventIntegrationOutput`](crate::output::GetEventIntegrationOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::GetEventIntegrationOutput::name): <p>The name of the event integration. </p>
    ///   - [`description(Option<String>)`](crate::output::GetEventIntegrationOutput::description): <p>The description of the event integration.</p>
    ///   - [`event_integration_arn(Option<String>)`](crate::output::GetEventIntegrationOutput::event_integration_arn): <p>The Amazon Resource Name (ARN) for the event integration.</p>
    ///   - [`event_bridge_bus(Option<String>)`](crate::output::GetEventIntegrationOutput::event_bridge_bus): <p>The EventBridge bus.</p>
    ///   - [`event_filter(Option<EventFilter>)`](crate::output::GetEventIntegrationOutput::event_filter): <p>The event filter.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::GetEventIntegrationOutput::tags): <p>One or more tags.</p>
    /// - On failure, responds with [`SdkError<GetEventIntegrationError>`](crate::error::GetEventIntegrationError)
    pub fn get_event_integration(&self) -> fluent_builders::GetEventIntegration {
        fluent_builders::GetEventIntegration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDataIntegrationAssociations`](crate::client::fluent_builders::ListDataIntegrationAssociations) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`data_integration_identifier(impl Into<String>)`](crate::client::fluent_builders::ListDataIntegrationAssociations::data_integration_identifier) / [`set_data_integration_identifier(Option<String>)`](crate::client::fluent_builders::ListDataIntegrationAssociations::set_data_integration_identifier): <p>A unique identifier for the DataIntegration.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDataIntegrationAssociations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDataIntegrationAssociations::set_next_token): <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListDataIntegrationAssociations::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListDataIntegrationAssociations::set_max_results): <p>The maximum number of results to return per page.</p>
    /// - On success, responds with [`ListDataIntegrationAssociationsOutput`](crate::output::ListDataIntegrationAssociationsOutput) with field(s):
    ///   - [`data_integration_associations(Option<Vec<DataIntegrationAssociationSummary>>)`](crate::output::ListDataIntegrationAssociationsOutput::data_integration_associations): <p>The Amazon Resource Name (ARN) and unique ID of the DataIntegration association.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDataIntegrationAssociationsOutput::next_token): <p>If there are additional results, this is the token for the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListDataIntegrationAssociationsError>`](crate::error::ListDataIntegrationAssociationsError)
    pub fn list_data_integration_associations(
        &self,
    ) -> fluent_builders::ListDataIntegrationAssociations {
        fluent_builders::ListDataIntegrationAssociations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDataIntegrations`](crate::client::fluent_builders::ListDataIntegrations) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDataIntegrations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDataIntegrations::set_next_token): <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListDataIntegrations::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListDataIntegrations::set_max_results): <p>The maximum number of results to return per page.</p>
    /// - On success, responds with [`ListDataIntegrationsOutput`](crate::output::ListDataIntegrationsOutput) with field(s):
    ///   - [`data_integrations(Option<Vec<DataIntegrationSummary>>)`](crate::output::ListDataIntegrationsOutput::data_integrations): <p>The DataIntegrations associated with this account.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDataIntegrationsOutput::next_token): <p>If there are additional results, this is the token for the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListDataIntegrationsError>`](crate::error::ListDataIntegrationsError)
    pub fn list_data_integrations(&self) -> fluent_builders::ListDataIntegrations {
        fluent_builders::ListDataIntegrations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListEventIntegrationAssociations`](crate::client::fluent_builders::ListEventIntegrationAssociations) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`event_integration_name(impl Into<String>)`](crate::client::fluent_builders::ListEventIntegrationAssociations::event_integration_name) / [`set_event_integration_name(Option<String>)`](crate::client::fluent_builders::ListEventIntegrationAssociations::set_event_integration_name): <p>The name of the event integration. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListEventIntegrationAssociations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListEventIntegrationAssociations::set_next_token): <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListEventIntegrationAssociations::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListEventIntegrationAssociations::set_max_results): <p>The maximum number of results to return per page.</p>
    /// - On success, responds with [`ListEventIntegrationAssociationsOutput`](crate::output::ListEventIntegrationAssociationsOutput) with field(s):
    ///   - [`event_integration_associations(Option<Vec<EventIntegrationAssociation>>)`](crate::output::ListEventIntegrationAssociationsOutput::event_integration_associations): <p>The event integration associations.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListEventIntegrationAssociationsOutput::next_token): <p>If there are additional results, this is the token for the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListEventIntegrationAssociationsError>`](crate::error::ListEventIntegrationAssociationsError)
    pub fn list_event_integration_associations(
        &self,
    ) -> fluent_builders::ListEventIntegrationAssociations {
        fluent_builders::ListEventIntegrationAssociations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListEventIntegrations`](crate::client::fluent_builders::ListEventIntegrations) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListEventIntegrations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListEventIntegrations::set_next_token): <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListEventIntegrations::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListEventIntegrations::set_max_results): <p>The maximum number of results to return per page.</p>
    /// - On success, responds with [`ListEventIntegrationsOutput`](crate::output::ListEventIntegrationsOutput) with field(s):
    ///   - [`event_integrations(Option<Vec<EventIntegration>>)`](crate::output::ListEventIntegrationsOutput::event_integrations): <p>The event integrations.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListEventIntegrationsOutput::next_token): <p>If there are additional results, this is the token for the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListEventIntegrationsError>`](crate::error::ListEventIntegrationsError)
    pub fn list_event_integrations(&self) -> fluent_builders::ListEventIntegrations {
        fluent_builders::ListEventIntegrations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource. </p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsForResourceOutput::tags): <p>Information about the tags.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>One or more tags. </p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The tag keys.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateDataIntegration`](crate::client::fluent_builders::UpdateDataIntegration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identifier(impl Into<String>)`](crate::client::fluent_builders::UpdateDataIntegration::identifier) / [`set_identifier(Option<String>)`](crate::client::fluent_builders::UpdateDataIntegration::set_identifier): <p>A unique identifier for the DataIntegration.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateDataIntegration::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateDataIntegration::set_name): <p>The name of the DataIntegration.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateDataIntegration::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateDataIntegration::set_description): <p>A description of the DataIntegration.</p>
    /// - On success, responds with [`UpdateDataIntegrationOutput`](crate::output::UpdateDataIntegrationOutput)

    /// - On failure, responds with [`SdkError<UpdateDataIntegrationError>`](crate::error::UpdateDataIntegrationError)
    pub fn update_data_integration(&self) -> fluent_builders::UpdateDataIntegration {
        fluent_builders::UpdateDataIntegration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateEventIntegration`](crate::client::fluent_builders::UpdateEventIntegration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateEventIntegration::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateEventIntegration::set_name): <p>The name of the event integration.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateEventIntegration::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateEventIntegration::set_description): <p>The description of the event inegration.</p>
    /// - On success, responds with [`UpdateEventIntegrationOutput`](crate::output::UpdateEventIntegrationOutput)

    /// - On failure, responds with [`SdkError<UpdateEventIntegrationError>`](crate::error::UpdateEventIntegrationError)
    pub fn update_event_integration(&self) -> fluent_builders::UpdateEventIntegration {
        fluent_builders::UpdateEventIntegration::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateDataIntegration`.
    ///
    /// <p>Creates and persists a DataIntegration resource.</p> <note>
    /// <p>You cannot create a DataIntegration association for a DataIntegration that has been previously associated. Use a different DataIntegration, or recreate the DataIntegration using the <code>CreateDataIntegration</code> API.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDataIntegration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_data_integration_input::Builder,
    }
    impl CreateDataIntegration {
        /// Creates a new `CreateDataIntegration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDataIntegrationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDataIntegrationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DataIntegration.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the DataIntegration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A description of the DataIntegration.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the DataIntegration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The KMS key for the DataIntegration.</p>
        pub fn kms_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key(input.into());
            self
        }
        /// <p>The KMS key for the DataIntegration.</p>
        pub fn set_kms_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key(input);
            self
        }
        /// <p>The URI of the data source.</p>
        pub fn source_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_uri(input.into());
            self
        }
        /// <p>The URI of the data source.</p>
        pub fn set_source_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source_uri(input);
            self
        }
        /// <p>The name of the data and how often it should be pulled from the source.</p>
        pub fn schedule_config(mut self, input: crate::model::ScheduleConfiguration) -> Self {
            self.inner = self.inner.schedule_config(input);
            self
        }
        /// <p>The name of the data and how often it should be pulled from the source.</p>
        pub fn set_schedule_config(
            mut self,
            input: std::option::Option<crate::model::ScheduleConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_schedule_config(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>One or more tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateEventIntegration`.
    ///
    /// <p>Creates an EventIntegration, given a specified name, description, and a reference to an Amazon EventBridge bus in your account and a partner event source that pushes events to that bus. No objects are created in the your account, only metadata that is persisted on the EventIntegration control plane.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateEventIntegration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_event_integration_input::Builder,
    }
    impl CreateEventIntegration {
        /// Creates a new `CreateEventIntegration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateEventIntegrationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateEventIntegrationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the event integration.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the event integration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the event integration.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the event integration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The event filter.</p>
        pub fn event_filter(mut self, input: crate::model::EventFilter) -> Self {
            self.inner = self.inner.event_filter(input);
            self
        }
        /// <p>The event filter.</p>
        pub fn set_event_filter(
            mut self,
            input: std::option::Option<crate::model::EventFilter>,
        ) -> Self {
            self.inner = self.inner.set_event_filter(input);
            self
        }
        /// <p>The EventBridge bus.</p>
        pub fn event_bridge_bus(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_bridge_bus(input.into());
            self
        }
        /// <p>The EventBridge bus.</p>
        pub fn set_event_bridge_bus(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_bridge_bus(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>One or more tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDataIntegration`.
    ///
    /// <p>Deletes the DataIntegration. Only DataIntegrations that don't have any DataIntegrationAssociations can be deleted. Deleting a DataIntegration also deletes the underlying Amazon AppFlow flow and service linked role. </p> <note>
    /// <p>You cannot create a DataIntegration association for a DataIntegration that has been previously associated. Use a different DataIntegration, or recreate the DataIntegration using the <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html">CreateDataIntegration</a> API.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDataIntegration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_data_integration_input::Builder,
    }
    impl DeleteDataIntegration {
        /// Creates a new `DeleteDataIntegration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDataIntegrationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDataIntegrationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique identifier for the DataIntegration.</p>
        pub fn data_integration_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.data_integration_identifier(input.into());
            self
        }
        /// <p>A unique identifier for the DataIntegration.</p>
        pub fn set_data_integration_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_integration_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEventIntegration`.
    ///
    /// <p>Deletes the specified existing event integration. If the event integration is associated with clients, the request is rejected.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteEventIntegration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_event_integration_input::Builder,
    }
    impl DeleteEventIntegration {
        /// Creates a new `DeleteEventIntegration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEventIntegrationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEventIntegrationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the event integration.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the event integration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDataIntegration`.
    ///
    /// <p>Returns information about the DataIntegration.</p> <note>
    /// <p>You cannot create a DataIntegration association for a DataIntegration that has been previously associated. Use a different DataIntegration, or recreate the DataIntegration using the <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html">CreateDataIntegration</a> API.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDataIntegration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_data_integration_input::Builder,
    }
    impl GetDataIntegration {
        /// Creates a new `GetDataIntegration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDataIntegrationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDataIntegrationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique identifier.</p>
        pub fn identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identifier(input.into());
            self
        }
        /// <p>A unique identifier.</p>
        pub fn set_identifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetEventIntegration`.
    ///
    /// <p>Returns information about the event integration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetEventIntegration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_event_integration_input::Builder,
    }
    impl GetEventIntegration {
        /// Creates a new `GetEventIntegration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEventIntegrationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetEventIntegrationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the event integration. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the event integration. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDataIntegrationAssociations`.
    ///
    /// <p>Returns a paginated list of DataIntegration associations in the account.</p> <note>
    /// <p>You cannot create a DataIntegration association for a DataIntegration that has been previously associated. Use a different DataIntegration, or recreate the DataIntegration using the <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html">CreateDataIntegration</a> API.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDataIntegrationAssociations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_data_integration_associations_input::Builder,
    }
    impl ListDataIntegrationAssociations {
        /// Creates a new `ListDataIntegrationAssociations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDataIntegrationAssociationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDataIntegrationAssociationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique identifier for the DataIntegration.</p>
        pub fn data_integration_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.data_integration_identifier(input.into());
            self
        }
        /// <p>A unique identifier for the DataIntegration.</p>
        pub fn set_data_integration_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_integration_identifier(input);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDataIntegrations`.
    ///
    /// <p>Returns a paginated list of DataIntegrations in the account.</p> <note>
    /// <p>You cannot create a DataIntegration association for a DataIntegration that has been previously associated. Use a different DataIntegration, or recreate the DataIntegration using the <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html">CreateDataIntegration</a> API.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDataIntegrations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_data_integrations_input::Builder,
    }
    impl ListDataIntegrations {
        /// Creates a new `ListDataIntegrations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDataIntegrationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDataIntegrationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListEventIntegrationAssociations`.
    ///
    /// <p>Returns a paginated list of event integration associations in the account. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListEventIntegrationAssociations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_event_integration_associations_input::Builder,
    }
    impl ListEventIntegrationAssociations {
        /// Creates a new `ListEventIntegrationAssociations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListEventIntegrationAssociationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListEventIntegrationAssociationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the event integration. </p>
        pub fn event_integration_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_integration_name(input.into());
            self
        }
        /// <p>The name of the event integration. </p>
        pub fn set_event_integration_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_integration_name(input);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListEventIntegrations`.
    ///
    /// <p>Returns a paginated list of event integrations in the account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListEventIntegrations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_event_integrations_input::Builder,
    }
    impl ListEventIntegrations {
        /// Creates a new `ListEventIntegrations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListEventIntegrationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListEventIntegrationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists the tags for the specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds the specified tags to the specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>One or more tags. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes the specified tags from the specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The tag keys.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDataIntegration`.
    ///
    /// <p>Updates the description of a DataIntegration.</p> <note>
    /// <p>You cannot create a DataIntegration association for a DataIntegration that has been previously associated. Use a different DataIntegration, or recreate the DataIntegration using the <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html">CreateDataIntegration</a> API.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateDataIntegration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_data_integration_input::Builder,
    }
    impl UpdateDataIntegration {
        /// Creates a new `UpdateDataIntegration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDataIntegrationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDataIntegrationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique identifier for the DataIntegration.</p>
        pub fn identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identifier(input.into());
            self
        }
        /// <p>A unique identifier for the DataIntegration.</p>
        pub fn set_identifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identifier(input);
            self
        }
        /// <p>The name of the DataIntegration.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the DataIntegration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A description of the DataIntegration.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the DataIntegration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateEventIntegration`.
    ///
    /// <p>Updates the description of an event integration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateEventIntegration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_event_integration_input::Builder,
    }
    impl UpdateEventIntegration {
        /// Creates a new `UpdateEventIntegration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateEventIntegrationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateEventIntegrationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the event integration.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the event integration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the event inegration.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the event inegration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
