// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CreateDataIntegration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDataIntegrationError {
    /// Kind of error that occurred.
    pub kind: CreateDataIntegrationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDataIntegration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDataIntegrationErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A resource with the specified name already exists.</p>
    DuplicateResourceException(crate::error::DuplicateResourceException),
    /// <p>Request processing failed due to an error or failure with the service.</p>
    InternalServiceError(crate::error::InternalServiceError),
    /// <p>The request is not valid. </p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The allowed quota for the resource has been exceeded.</p>
    ResourceQuotaExceededException(crate::error::ResourceQuotaExceededException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDataIntegrationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDataIntegrationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateDataIntegrationErrorKind::DuplicateResourceException(_inner) => _inner.fmt(f),
            CreateDataIntegrationErrorKind::InternalServiceError(_inner) => _inner.fmt(f),
            CreateDataIntegrationErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateDataIntegrationErrorKind::ResourceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateDataIntegrationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateDataIntegrationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDataIntegrationError {
    fn code(&self) -> Option<&str> {
        CreateDataIntegrationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDataIntegrationError {
    /// Creates a new `CreateDataIntegrationError`.
    pub fn new(kind: CreateDataIntegrationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDataIntegrationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDataIntegrationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDataIntegrationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDataIntegrationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDataIntegrationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDataIntegrationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDataIntegrationErrorKind::DuplicateResourceException`.
    pub fn is_duplicate_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDataIntegrationErrorKind::DuplicateResourceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDataIntegrationErrorKind::InternalServiceError`.
    pub fn is_internal_service_error(&self) -> bool {
        matches!(
            &self.kind,
            CreateDataIntegrationErrorKind::InternalServiceError(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDataIntegrationErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDataIntegrationErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDataIntegrationErrorKind::ResourceQuotaExceededException`.
    pub fn is_resource_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDataIntegrationErrorKind::ResourceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDataIntegrationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDataIntegrationErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for CreateDataIntegrationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDataIntegrationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateDataIntegrationErrorKind::DuplicateResourceException(_inner) => Some(_inner),
            CreateDataIntegrationErrorKind::InternalServiceError(_inner) => Some(_inner),
            CreateDataIntegrationErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateDataIntegrationErrorKind::ResourceQuotaExceededException(_inner) => Some(_inner),
            CreateDataIntegrationErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateDataIntegrationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateEventIntegration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateEventIntegrationError {
    /// Kind of error that occurred.
    pub kind: CreateEventIntegrationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateEventIntegration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateEventIntegrationErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A resource with the specified name already exists.</p>
    DuplicateResourceException(crate::error::DuplicateResourceException),
    /// <p>Request processing failed due to an error or failure with the service.</p>
    InternalServiceError(crate::error::InternalServiceError),
    /// <p>The request is not valid. </p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The allowed quota for the resource has been exceeded.</p>
    ResourceQuotaExceededException(crate::error::ResourceQuotaExceededException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateEventIntegrationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateEventIntegrationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateEventIntegrationErrorKind::DuplicateResourceException(_inner) => _inner.fmt(f),
            CreateEventIntegrationErrorKind::InternalServiceError(_inner) => _inner.fmt(f),
            CreateEventIntegrationErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateEventIntegrationErrorKind::ResourceQuotaExceededException(_inner) => {
                _inner.fmt(f)
            }
            CreateEventIntegrationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateEventIntegrationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateEventIntegrationError {
    fn code(&self) -> Option<&str> {
        CreateEventIntegrationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateEventIntegrationError {
    /// Creates a new `CreateEventIntegrationError`.
    pub fn new(kind: CreateEventIntegrationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateEventIntegrationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateEventIntegrationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateEventIntegrationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateEventIntegrationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateEventIntegrationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventIntegrationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventIntegrationErrorKind::DuplicateResourceException`.
    pub fn is_duplicate_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventIntegrationErrorKind::DuplicateResourceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventIntegrationErrorKind::InternalServiceError`.
    pub fn is_internal_service_error(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventIntegrationErrorKind::InternalServiceError(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventIntegrationErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventIntegrationErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventIntegrationErrorKind::ResourceQuotaExceededException`.
    pub fn is_resource_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventIntegrationErrorKind::ResourceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventIntegrationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventIntegrationErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for CreateEventIntegrationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateEventIntegrationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateEventIntegrationErrorKind::DuplicateResourceException(_inner) => Some(_inner),
            CreateEventIntegrationErrorKind::InternalServiceError(_inner) => Some(_inner),
            CreateEventIntegrationErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateEventIntegrationErrorKind::ResourceQuotaExceededException(_inner) => Some(_inner),
            CreateEventIntegrationErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateEventIntegrationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDataIntegration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDataIntegrationError {
    /// Kind of error that occurred.
    pub kind: DeleteDataIntegrationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDataIntegration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDataIntegrationErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Request processing failed due to an error or failure with the service.</p>
    InternalServiceError(crate::error::InternalServiceError),
    /// <p>The request is not valid. </p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDataIntegrationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDataIntegrationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteDataIntegrationErrorKind::InternalServiceError(_inner) => _inner.fmt(f),
            DeleteDataIntegrationErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteDataIntegrationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteDataIntegrationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteDataIntegrationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDataIntegrationError {
    fn code(&self) -> Option<&str> {
        DeleteDataIntegrationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDataIntegrationError {
    /// Creates a new `DeleteDataIntegrationError`.
    pub fn new(kind: DeleteDataIntegrationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDataIntegrationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDataIntegrationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDataIntegrationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDataIntegrationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDataIntegrationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDataIntegrationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDataIntegrationErrorKind::InternalServiceError`.
    pub fn is_internal_service_error(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDataIntegrationErrorKind::InternalServiceError(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDataIntegrationErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDataIntegrationErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDataIntegrationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDataIntegrationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDataIntegrationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDataIntegrationErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DeleteDataIntegrationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDataIntegrationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteDataIntegrationErrorKind::InternalServiceError(_inner) => Some(_inner),
            DeleteDataIntegrationErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteDataIntegrationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteDataIntegrationErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteDataIntegrationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteEventIntegration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteEventIntegrationError {
    /// Kind of error that occurred.
    pub kind: DeleteEventIntegrationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteEventIntegration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteEventIntegrationErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Request processing failed due to an error or failure with the service.</p>
    InternalServiceError(crate::error::InternalServiceError),
    /// <p>The request is not valid. </p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteEventIntegrationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteEventIntegrationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteEventIntegrationErrorKind::InternalServiceError(_inner) => _inner.fmt(f),
            DeleteEventIntegrationErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteEventIntegrationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteEventIntegrationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteEventIntegrationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteEventIntegrationError {
    fn code(&self) -> Option<&str> {
        DeleteEventIntegrationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteEventIntegrationError {
    /// Creates a new `DeleteEventIntegrationError`.
    pub fn new(kind: DeleteEventIntegrationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteEventIntegrationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteEventIntegrationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteEventIntegrationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteEventIntegrationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteEventIntegrationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEventIntegrationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEventIntegrationErrorKind::InternalServiceError`.
    pub fn is_internal_service_error(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEventIntegrationErrorKind::InternalServiceError(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEventIntegrationErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEventIntegrationErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEventIntegrationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEventIntegrationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEventIntegrationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEventIntegrationErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DeleteEventIntegrationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteEventIntegrationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteEventIntegrationErrorKind::InternalServiceError(_inner) => Some(_inner),
            DeleteEventIntegrationErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteEventIntegrationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteEventIntegrationErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteEventIntegrationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDataIntegration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDataIntegrationError {
    /// Kind of error that occurred.
    pub kind: GetDataIntegrationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDataIntegration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDataIntegrationErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Request processing failed due to an error or failure with the service.</p>
    InternalServiceError(crate::error::InternalServiceError),
    /// <p>The request is not valid. </p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDataIntegrationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDataIntegrationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetDataIntegrationErrorKind::InternalServiceError(_inner) => _inner.fmt(f),
            GetDataIntegrationErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            GetDataIntegrationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetDataIntegrationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetDataIntegrationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDataIntegrationError {
    fn code(&self) -> Option<&str> {
        GetDataIntegrationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDataIntegrationError {
    /// Creates a new `GetDataIntegrationError`.
    pub fn new(kind: GetDataIntegrationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDataIntegrationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDataIntegrationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDataIntegrationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDataIntegrationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetDataIntegrationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDataIntegrationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDataIntegrationErrorKind::InternalServiceError`.
    pub fn is_internal_service_error(&self) -> bool {
        matches!(
            &self.kind,
            GetDataIntegrationErrorKind::InternalServiceError(_)
        )
    }
    /// Returns `true` if the error kind is `GetDataIntegrationErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDataIntegrationErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDataIntegrationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDataIntegrationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDataIntegrationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDataIntegrationErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for GetDataIntegrationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDataIntegrationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetDataIntegrationErrorKind::InternalServiceError(_inner) => Some(_inner),
            GetDataIntegrationErrorKind::InvalidRequestException(_inner) => Some(_inner),
            GetDataIntegrationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetDataIntegrationErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetDataIntegrationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetEventIntegration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetEventIntegrationError {
    /// Kind of error that occurred.
    pub kind: GetEventIntegrationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetEventIntegration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetEventIntegrationErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Request processing failed due to an error or failure with the service.</p>
    InternalServiceError(crate::error::InternalServiceError),
    /// <p>The request is not valid. </p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetEventIntegrationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetEventIntegrationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetEventIntegrationErrorKind::InternalServiceError(_inner) => _inner.fmt(f),
            GetEventIntegrationErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            GetEventIntegrationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetEventIntegrationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetEventIntegrationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetEventIntegrationError {
    fn code(&self) -> Option<&str> {
        GetEventIntegrationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetEventIntegrationError {
    /// Creates a new `GetEventIntegrationError`.
    pub fn new(kind: GetEventIntegrationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetEventIntegrationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetEventIntegrationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetEventIntegrationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetEventIntegrationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetEventIntegrationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEventIntegrationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEventIntegrationErrorKind::InternalServiceError`.
    pub fn is_internal_service_error(&self) -> bool {
        matches!(
            &self.kind,
            GetEventIntegrationErrorKind::InternalServiceError(_)
        )
    }
    /// Returns `true` if the error kind is `GetEventIntegrationErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEventIntegrationErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEventIntegrationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEventIntegrationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEventIntegrationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEventIntegrationErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for GetEventIntegrationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetEventIntegrationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetEventIntegrationErrorKind::InternalServiceError(_inner) => Some(_inner),
            GetEventIntegrationErrorKind::InvalidRequestException(_inner) => Some(_inner),
            GetEventIntegrationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetEventIntegrationErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetEventIntegrationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDataIntegrationAssociations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDataIntegrationAssociationsError {
    /// Kind of error that occurred.
    pub kind: ListDataIntegrationAssociationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDataIntegrationAssociations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDataIntegrationAssociationsErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Request processing failed due to an error or failure with the service.</p>
    InternalServiceError(crate::error::InternalServiceError),
    /// <p>The request is not valid. </p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDataIntegrationAssociationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDataIntegrationAssociationsErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            ListDataIntegrationAssociationsErrorKind::InternalServiceError(_inner) => _inner.fmt(f),
            ListDataIntegrationAssociationsErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            ListDataIntegrationAssociationsErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ListDataIntegrationAssociationsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListDataIntegrationAssociationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDataIntegrationAssociationsError {
    fn code(&self) -> Option<&str> {
        ListDataIntegrationAssociationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDataIntegrationAssociationsError {
    /// Creates a new `ListDataIntegrationAssociationsError`.
    pub fn new(
        kind: ListDataIntegrationAssociationsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDataIntegrationAssociationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDataIntegrationAssociationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDataIntegrationAssociationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDataIntegrationAssociationsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDataIntegrationAssociationsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDataIntegrationAssociationsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDataIntegrationAssociationsErrorKind::InternalServiceError`.
    pub fn is_internal_service_error(&self) -> bool {
        matches!(
            &self.kind,
            ListDataIntegrationAssociationsErrorKind::InternalServiceError(_)
        )
    }
    /// Returns `true` if the error kind is `ListDataIntegrationAssociationsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDataIntegrationAssociationsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDataIntegrationAssociationsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDataIntegrationAssociationsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDataIntegrationAssociationsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDataIntegrationAssociationsErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListDataIntegrationAssociationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDataIntegrationAssociationsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListDataIntegrationAssociationsErrorKind::InternalServiceError(_inner) => Some(_inner),
            ListDataIntegrationAssociationsErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            ListDataIntegrationAssociationsErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            ListDataIntegrationAssociationsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListDataIntegrationAssociationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDataIntegrations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDataIntegrationsError {
    /// Kind of error that occurred.
    pub kind: ListDataIntegrationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDataIntegrations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDataIntegrationsErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Request processing failed due to an error or failure with the service.</p>
    InternalServiceError(crate::error::InternalServiceError),
    /// <p>The request is not valid. </p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDataIntegrationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDataIntegrationsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListDataIntegrationsErrorKind::InternalServiceError(_inner) => _inner.fmt(f),
            ListDataIntegrationsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListDataIntegrationsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListDataIntegrationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDataIntegrationsError {
    fn code(&self) -> Option<&str> {
        ListDataIntegrationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDataIntegrationsError {
    /// Creates a new `ListDataIntegrationsError`.
    pub fn new(kind: ListDataIntegrationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDataIntegrationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDataIntegrationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDataIntegrationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDataIntegrationsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDataIntegrationsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDataIntegrationsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDataIntegrationsErrorKind::InternalServiceError`.
    pub fn is_internal_service_error(&self) -> bool {
        matches!(
            &self.kind,
            ListDataIntegrationsErrorKind::InternalServiceError(_)
        )
    }
    /// Returns `true` if the error kind is `ListDataIntegrationsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDataIntegrationsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDataIntegrationsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDataIntegrationsErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListDataIntegrationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDataIntegrationsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListDataIntegrationsErrorKind::InternalServiceError(_inner) => Some(_inner),
            ListDataIntegrationsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListDataIntegrationsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListDataIntegrationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListEventIntegrationAssociations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListEventIntegrationAssociationsError {
    /// Kind of error that occurred.
    pub kind: ListEventIntegrationAssociationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListEventIntegrationAssociations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListEventIntegrationAssociationsErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Request processing failed due to an error or failure with the service.</p>
    InternalServiceError(crate::error::InternalServiceError),
    /// <p>The request is not valid. </p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListEventIntegrationAssociationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListEventIntegrationAssociationsErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            ListEventIntegrationAssociationsErrorKind::InternalServiceError(_inner) => {
                _inner.fmt(f)
            }
            ListEventIntegrationAssociationsErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            ListEventIntegrationAssociationsErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ListEventIntegrationAssociationsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListEventIntegrationAssociationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListEventIntegrationAssociationsError {
    fn code(&self) -> Option<&str> {
        ListEventIntegrationAssociationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListEventIntegrationAssociationsError {
    /// Creates a new `ListEventIntegrationAssociationsError`.
    pub fn new(
        kind: ListEventIntegrationAssociationsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListEventIntegrationAssociationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListEventIntegrationAssociationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListEventIntegrationAssociationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListEventIntegrationAssociationsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListEventIntegrationAssociationsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEventIntegrationAssociationsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEventIntegrationAssociationsErrorKind::InternalServiceError`.
    pub fn is_internal_service_error(&self) -> bool {
        matches!(
            &self.kind,
            ListEventIntegrationAssociationsErrorKind::InternalServiceError(_)
        )
    }
    /// Returns `true` if the error kind is `ListEventIntegrationAssociationsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEventIntegrationAssociationsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEventIntegrationAssociationsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEventIntegrationAssociationsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEventIntegrationAssociationsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEventIntegrationAssociationsErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListEventIntegrationAssociationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListEventIntegrationAssociationsErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            ListEventIntegrationAssociationsErrorKind::InternalServiceError(_inner) => Some(_inner),
            ListEventIntegrationAssociationsErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            ListEventIntegrationAssociationsErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            ListEventIntegrationAssociationsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListEventIntegrationAssociationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListEventIntegrations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListEventIntegrationsError {
    /// Kind of error that occurred.
    pub kind: ListEventIntegrationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListEventIntegrations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListEventIntegrationsErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Request processing failed due to an error or failure with the service.</p>
    InternalServiceError(crate::error::InternalServiceError),
    /// <p>The request is not valid. </p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListEventIntegrationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListEventIntegrationsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListEventIntegrationsErrorKind::InternalServiceError(_inner) => _inner.fmt(f),
            ListEventIntegrationsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListEventIntegrationsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListEventIntegrationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListEventIntegrationsError {
    fn code(&self) -> Option<&str> {
        ListEventIntegrationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListEventIntegrationsError {
    /// Creates a new `ListEventIntegrationsError`.
    pub fn new(kind: ListEventIntegrationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListEventIntegrationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListEventIntegrationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListEventIntegrationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListEventIntegrationsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListEventIntegrationsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEventIntegrationsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEventIntegrationsErrorKind::InternalServiceError`.
    pub fn is_internal_service_error(&self) -> bool {
        matches!(
            &self.kind,
            ListEventIntegrationsErrorKind::InternalServiceError(_)
        )
    }
    /// Returns `true` if the error kind is `ListEventIntegrationsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEventIntegrationsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEventIntegrationsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEventIntegrationsErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListEventIntegrationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListEventIntegrationsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListEventIntegrationsErrorKind::InternalServiceError(_inner) => Some(_inner),
            ListEventIntegrationsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListEventIntegrationsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListEventIntegrationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>Request processing failed due to an error or failure with the service.</p>
    InternalServiceError(crate::error::InternalServiceError),
    /// <p>The request is not valid. </p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalServiceError(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InternalServiceError`.
    pub fn is_internal_service_error(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalServiceError(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalServiceError(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>Request processing failed due to an error or failure with the service.</p>
    InternalServiceError(crate::error::InternalServiceError),
    /// <p>The request is not valid. </p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::InternalServiceError(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InternalServiceError`.
    pub fn is_internal_service_error(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InternalServiceError(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::InternalServiceError(_inner) => Some(_inner),
            TagResourceErrorKind::InvalidRequestException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>Request processing failed due to an error or failure with the service.</p>
    InternalServiceError(crate::error::InternalServiceError),
    /// <p>The request is not valid. </p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::InternalServiceError(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InternalServiceError`.
    pub fn is_internal_service_error(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::InternalServiceError(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::InternalServiceError(_inner) => Some(_inner),
            UntagResourceErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateDataIntegration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateDataIntegrationError {
    /// Kind of error that occurred.
    pub kind: UpdateDataIntegrationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateDataIntegration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateDataIntegrationErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Request processing failed due to an error or failure with the service.</p>
    InternalServiceError(crate::error::InternalServiceError),
    /// <p>The request is not valid. </p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateDataIntegrationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateDataIntegrationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateDataIntegrationErrorKind::InternalServiceError(_inner) => _inner.fmt(f),
            UpdateDataIntegrationErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateDataIntegrationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateDataIntegrationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateDataIntegrationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateDataIntegrationError {
    fn code(&self) -> Option<&str> {
        UpdateDataIntegrationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateDataIntegrationError {
    /// Creates a new `UpdateDataIntegrationError`.
    pub fn new(kind: UpdateDataIntegrationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateDataIntegrationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateDataIntegrationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateDataIntegrationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateDataIntegrationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateDataIntegrationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDataIntegrationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDataIntegrationErrorKind::InternalServiceError`.
    pub fn is_internal_service_error(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDataIntegrationErrorKind::InternalServiceError(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDataIntegrationErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDataIntegrationErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDataIntegrationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDataIntegrationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDataIntegrationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDataIntegrationErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for UpdateDataIntegrationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateDataIntegrationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateDataIntegrationErrorKind::InternalServiceError(_inner) => Some(_inner),
            UpdateDataIntegrationErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateDataIntegrationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateDataIntegrationErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateDataIntegrationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateEventIntegration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateEventIntegrationError {
    /// Kind of error that occurred.
    pub kind: UpdateEventIntegrationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateEventIntegration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateEventIntegrationErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Request processing failed due to an error or failure with the service.</p>
    InternalServiceError(crate::error::InternalServiceError),
    /// <p>The request is not valid. </p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateEventIntegrationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateEventIntegrationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateEventIntegrationErrorKind::InternalServiceError(_inner) => _inner.fmt(f),
            UpdateEventIntegrationErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateEventIntegrationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateEventIntegrationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateEventIntegrationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateEventIntegrationError {
    fn code(&self) -> Option<&str> {
        UpdateEventIntegrationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateEventIntegrationError {
    /// Creates a new `UpdateEventIntegrationError`.
    pub fn new(kind: UpdateEventIntegrationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateEventIntegrationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateEventIntegrationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateEventIntegrationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateEventIntegrationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateEventIntegrationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEventIntegrationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEventIntegrationErrorKind::InternalServiceError`.
    pub fn is_internal_service_error(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEventIntegrationErrorKind::InternalServiceError(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEventIntegrationErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEventIntegrationErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEventIntegrationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEventIntegrationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEventIntegrationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEventIntegrationErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for UpdateEventIntegrationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateEventIntegrationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateEventIntegrationErrorKind::InternalServiceError(_inner) => Some(_inner),
            UpdateEventIntegrationErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateEventIntegrationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateEventIntegrationErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateEventIntegrationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The throttling limit has been exceeded.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThrottlingException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThrottlingException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ThrottlingException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ThrottlingException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ThrottlingException {}
/// See [`ThrottlingException`](crate::error::ThrottlingException)
pub mod throttling_exception {
    /// A builder for [`ThrottlingException`](crate::error::ThrottlingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ThrottlingException`](crate::error::ThrottlingException)
        pub fn build(self) -> crate::error::ThrottlingException {
            crate::error::ThrottlingException {
                message: self.message,
            }
        }
    }
}
impl ThrottlingException {
    /// Creates a new builder-style object to manufacture [`ThrottlingException`](crate::error::ThrottlingException)
    pub fn builder() -> crate::error::throttling_exception::Builder {
        crate::error::throttling_exception::Builder::default()
    }
}

/// <p>The specified resource was not found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>The request is not valid. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidRequestException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidRequestException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidRequestException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidRequestException {}
/// See [`InvalidRequestException`](crate::error::InvalidRequestException)
pub mod invalid_request_exception {
    /// A builder for [`InvalidRequestException`](crate::error::InvalidRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidRequestException`](crate::error::InvalidRequestException)
        pub fn build(self) -> crate::error::InvalidRequestException {
            crate::error::InvalidRequestException {
                message: self.message,
            }
        }
    }
}
impl InvalidRequestException {
    /// Creates a new builder-style object to manufacture [`InvalidRequestException`](crate::error::InvalidRequestException)
    pub fn builder() -> crate::error::invalid_request_exception::Builder {
        crate::error::invalid_request_exception::Builder::default()
    }
}

/// <p>Request processing failed due to an error or failure with the service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServiceError {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServiceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServiceError");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServiceError {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServiceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServiceError")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServiceError {}
/// See [`InternalServiceError`](crate::error::InternalServiceError)
pub mod internal_service_error {
    /// A builder for [`InternalServiceError`](crate::error::InternalServiceError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServiceError`](crate::error::InternalServiceError)
        pub fn build(self) -> crate::error::InternalServiceError {
            crate::error::InternalServiceError {
                message: self.message,
            }
        }
    }
}
impl InternalServiceError {
    /// Creates a new builder-style object to manufacture [`InternalServiceError`](crate::error::InternalServiceError)
    pub fn builder() -> crate::error::internal_service_error::Builder {
        crate::error::internal_service_error::Builder::default()
    }
}

/// <p>You do not have sufficient access to perform this action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}

/// <p>The allowed quota for the resource has been exceeded.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceQuotaExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceQuotaExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceQuotaExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceQuotaExceededException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceQuotaExceededException {}
/// See [`ResourceQuotaExceededException`](crate::error::ResourceQuotaExceededException)
pub mod resource_quota_exceeded_exception {
    /// A builder for [`ResourceQuotaExceededException`](crate::error::ResourceQuotaExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceQuotaExceededException`](crate::error::ResourceQuotaExceededException)
        pub fn build(self) -> crate::error::ResourceQuotaExceededException {
            crate::error::ResourceQuotaExceededException {
                message: self.message,
            }
        }
    }
}
impl ResourceQuotaExceededException {
    /// Creates a new builder-style object to manufacture [`ResourceQuotaExceededException`](crate::error::ResourceQuotaExceededException)
    pub fn builder() -> crate::error::resource_quota_exceeded_exception::Builder {
        crate::error::resource_quota_exceeded_exception::Builder::default()
    }
}

/// <p>A resource with the specified name already exists.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DuplicateResourceException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DuplicateResourceException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DuplicateResourceException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DuplicateResourceException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DuplicateResourceException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DuplicateResourceException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for DuplicateResourceException {}
/// See [`DuplicateResourceException`](crate::error::DuplicateResourceException)
pub mod duplicate_resource_exception {
    /// A builder for [`DuplicateResourceException`](crate::error::DuplicateResourceException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DuplicateResourceException`](crate::error::DuplicateResourceException)
        pub fn build(self) -> crate::error::DuplicateResourceException {
            crate::error::DuplicateResourceException {
                message: self.message,
            }
        }
    }
}
impl DuplicateResourceException {
    /// Creates a new builder-style object to manufacture [`DuplicateResourceException`](crate::error::DuplicateResourceException)
    pub fn builder() -> crate::error::duplicate_resource_exception::Builder {
        crate::error::duplicate_resource_exception::Builder::default()
    }
}
