// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Appflow
///
/// Client for invoking operations on Amazon Appflow. Each operation on Amazon Appflow is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_appflow::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_appflow::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_appflow::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`CreateConnectorProfile`](crate::client::fluent_builders::CreateConnectorProfile) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`connector_profile_name(impl Into<String>)`](crate::client::fluent_builders::CreateConnectorProfile::connector_profile_name) / [`set_connector_profile_name(Option<String>)`](crate::client::fluent_builders::CreateConnectorProfile::set_connector_profile_name): <p> The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in your Amazon Web Services account. </p>
    ///   - [`kms_arn(impl Into<String>)`](crate::client::fluent_builders::CreateConnectorProfile::kms_arn) / [`set_kms_arn(Option<String>)`](crate::client::fluent_builders::CreateConnectorProfile::set_kms_arn): <p> The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption. This is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key. </p>
    ///   - [`connector_type(ConnectorType)`](crate::client::fluent_builders::CreateConnectorProfile::connector_type) / [`set_connector_type(Option<ConnectorType>)`](crate::client::fluent_builders::CreateConnectorProfile::set_connector_type): <p> The type of connector, such as Salesforce, Amplitude, and so on. </p>
    ///   - [`connector_label(impl Into<String>)`](crate::client::fluent_builders::CreateConnectorProfile::connector_label) / [`set_connector_label(Option<String>)`](crate::client::fluent_builders::CreateConnectorProfile::set_connector_label): <p>The label of the connector. The label is unique for each <code>ConnectorRegistration</code> in your Amazon Web Services account. Only needed if calling for CUSTOMCONNECTOR connector type/.</p>
    ///   - [`connection_mode(ConnectionMode)`](crate::client::fluent_builders::CreateConnectorProfile::connection_mode) / [`set_connection_mode(Option<ConnectionMode>)`](crate::client::fluent_builders::CreateConnectorProfile::set_connection_mode): <p> Indicates the connection mode and specifies whether it is public or private. Private flows use Amazon Web Services PrivateLink to route data over Amazon Web Services infrastructure without exposing it to the public internet. </p>
    ///   - [`connector_profile_config(ConnectorProfileConfig)`](crate::client::fluent_builders::CreateConnectorProfile::connector_profile_config) / [`set_connector_profile_config(Option<ConnectorProfileConfig>)`](crate::client::fluent_builders::CreateConnectorProfile::set_connector_profile_config): <p> Defines the connector-specific configuration and credentials. </p>
    /// - On success, responds with [`CreateConnectorProfileOutput`](crate::output::CreateConnectorProfileOutput) with field(s):
    ///   - [`connector_profile_arn(Option<String>)`](crate::output::CreateConnectorProfileOutput::connector_profile_arn): <p> The Amazon Resource Name (ARN) of the connector profile. </p>
    /// - On failure, responds with [`SdkError<CreateConnectorProfileError>`](crate::error::CreateConnectorProfileError)
    pub fn create_connector_profile(&self) -> fluent_builders::CreateConnectorProfile {
        fluent_builders::CreateConnectorProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateFlow`](crate::client::fluent_builders::CreateFlow) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`flow_name(impl Into<String>)`](crate::client::fluent_builders::CreateFlow::flow_name) / [`set_flow_name(Option<String>)`](crate::client::fluent_builders::CreateFlow::set_flow_name): <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only. </p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateFlow::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateFlow::set_description): <p> A description of the flow you want to create. </p>
    ///   - [`kms_arn(impl Into<String>)`](crate::client::fluent_builders::CreateFlow::kms_arn) / [`set_kms_arn(Option<String>)`](crate::client::fluent_builders::CreateFlow::set_kms_arn): <p> The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption. This is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key. </p>
    ///   - [`trigger_config(TriggerConfig)`](crate::client::fluent_builders::CreateFlow::trigger_config) / [`set_trigger_config(Option<TriggerConfig>)`](crate::client::fluent_builders::CreateFlow::set_trigger_config): <p> The trigger settings that determine how and when the flow runs. </p>
    ///   - [`source_flow_config(SourceFlowConfig)`](crate::client::fluent_builders::CreateFlow::source_flow_config) / [`set_source_flow_config(Option<SourceFlowConfig>)`](crate::client::fluent_builders::CreateFlow::set_source_flow_config): <p> The configuration that controls how Amazon AppFlow retrieves data from the source connector. </p>
    ///   - [`destination_flow_config_list(Vec<DestinationFlowConfig>)`](crate::client::fluent_builders::CreateFlow::destination_flow_config_list) / [`set_destination_flow_config_list(Option<Vec<DestinationFlowConfig>>)`](crate::client::fluent_builders::CreateFlow::set_destination_flow_config_list): <p> The configuration that controls how Amazon AppFlow places data in the destination connector. </p>
    ///   - [`tasks(Vec<Task>)`](crate::client::fluent_builders::CreateFlow::tasks) / [`set_tasks(Option<Vec<Task>>)`](crate::client::fluent_builders::CreateFlow::set_tasks): <p> A list of tasks that Amazon AppFlow performs while transferring the data in the flow run. </p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateFlow::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateFlow::set_tags): <p> The tags used to organize, track, or control access for your flow. </p>
    /// - On success, responds with [`CreateFlowOutput`](crate::output::CreateFlowOutput) with field(s):
    ///   - [`flow_arn(Option<String>)`](crate::output::CreateFlowOutput::flow_arn): <p> The flow's Amazon Resource Name (ARN). </p>
    ///   - [`flow_status(Option<FlowStatus>)`](crate::output::CreateFlowOutput::flow_status): <p> Indicates the current status of the flow. </p>
    /// - On failure, responds with [`SdkError<CreateFlowError>`](crate::error::CreateFlowError)
    pub fn create_flow(&self) -> fluent_builders::CreateFlow {
        fluent_builders::CreateFlow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteConnectorProfile`](crate::client::fluent_builders::DeleteConnectorProfile) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`connector_profile_name(impl Into<String>)`](crate::client::fluent_builders::DeleteConnectorProfile::connector_profile_name) / [`set_connector_profile_name(Option<String>)`](crate::client::fluent_builders::DeleteConnectorProfile::set_connector_profile_name): <p> The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in your account. </p>
    ///   - [`force_delete(bool)`](crate::client::fluent_builders::DeleteConnectorProfile::force_delete) / [`set_force_delete(bool)`](crate::client::fluent_builders::DeleteConnectorProfile::set_force_delete): <p> Indicates whether Amazon AppFlow should delete the profile, even if it is currently in use in one or more flows. </p>
    /// - On success, responds with [`DeleteConnectorProfileOutput`](crate::output::DeleteConnectorProfileOutput)

    /// - On failure, responds with [`SdkError<DeleteConnectorProfileError>`](crate::error::DeleteConnectorProfileError)
    pub fn delete_connector_profile(&self) -> fluent_builders::DeleteConnectorProfile {
        fluent_builders::DeleteConnectorProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteFlow`](crate::client::fluent_builders::DeleteFlow) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`flow_name(impl Into<String>)`](crate::client::fluent_builders::DeleteFlow::flow_name) / [`set_flow_name(Option<String>)`](crate::client::fluent_builders::DeleteFlow::set_flow_name): <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only. </p>
    ///   - [`force_delete(bool)`](crate::client::fluent_builders::DeleteFlow::force_delete) / [`set_force_delete(bool)`](crate::client::fluent_builders::DeleteFlow::set_force_delete): <p> Indicates whether Amazon AppFlow should delete the flow, even if it is currently in use. </p>
    /// - On success, responds with [`DeleteFlowOutput`](crate::output::DeleteFlowOutput)

    /// - On failure, responds with [`SdkError<DeleteFlowError>`](crate::error::DeleteFlowError)
    pub fn delete_flow(&self) -> fluent_builders::DeleteFlow {
        fluent_builders::DeleteFlow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeConnector`](crate::client::fluent_builders::DescribeConnector) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`connector_type(ConnectorType)`](crate::client::fluent_builders::DescribeConnector::connector_type) / [`set_connector_type(Option<ConnectorType>)`](crate::client::fluent_builders::DescribeConnector::set_connector_type): <p>The connector type, such as CUSTOMCONNECTOR, Saleforce, Marketo. Please choose CUSTOMCONNECTOR for Lambda based custom connectors.</p>
    ///   - [`connector_label(impl Into<String>)`](crate::client::fluent_builders::DescribeConnector::connector_label) / [`set_connector_label(Option<String>)`](crate::client::fluent_builders::DescribeConnector::set_connector_label): <p>The label of the connector. The label is unique for each <code>ConnectorRegistration</code> in your Amazon Web Services account. Only needed if calling for CUSTOMCONNECTOR connector type/.</p>
    /// - On success, responds with [`DescribeConnectorOutput`](crate::output::DescribeConnectorOutput) with field(s):
    ///   - [`connector_configuration(Option<ConnectorConfiguration>)`](crate::output::DescribeConnectorOutput::connector_configuration): <p>Configuration info of all the connectors that the user requested.</p>
    /// - On failure, responds with [`SdkError<DescribeConnectorError>`](crate::error::DescribeConnectorError)
    pub fn describe_connector(&self) -> fluent_builders::DescribeConnector {
        fluent_builders::DescribeConnector::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeConnectorEntity`](crate::client::fluent_builders::DescribeConnectorEntity) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`connector_entity_name(impl Into<String>)`](crate::client::fluent_builders::DescribeConnectorEntity::connector_entity_name) / [`set_connector_entity_name(Option<String>)`](crate::client::fluent_builders::DescribeConnectorEntity::set_connector_entity_name): <p> The entity name for that connector. </p>
    ///   - [`connector_type(ConnectorType)`](crate::client::fluent_builders::DescribeConnectorEntity::connector_type) / [`set_connector_type(Option<ConnectorType>)`](crate::client::fluent_builders::DescribeConnectorEntity::set_connector_type): <p> The type of connector application, such as Salesforce, Amplitude, and so on. </p>
    ///   - [`connector_profile_name(impl Into<String>)`](crate::client::fluent_builders::DescribeConnectorEntity::connector_profile_name) / [`set_connector_profile_name(Option<String>)`](crate::client::fluent_builders::DescribeConnectorEntity::set_connector_profile_name): <p> The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in the Amazon Web Services account. </p>
    ///   - [`api_version(impl Into<String>)`](crate::client::fluent_builders::DescribeConnectorEntity::api_version) / [`set_api_version(Option<String>)`](crate::client::fluent_builders::DescribeConnectorEntity::set_api_version): <p>The version of the API that's used by the connector.</p>
    /// - On success, responds with [`DescribeConnectorEntityOutput`](crate::output::DescribeConnectorEntityOutput) with field(s):
    ///   - [`connector_entity_fields(Option<Vec<ConnectorEntityField>>)`](crate::output::DescribeConnectorEntityOutput::connector_entity_fields): <p> Describes the fields for that connector entity. For example, for an <i>account</i> entity, the fields would be <i>account name</i>, <i>account ID</i>, and so on. </p>
    /// - On failure, responds with [`SdkError<DescribeConnectorEntityError>`](crate::error::DescribeConnectorEntityError)
    pub fn describe_connector_entity(&self) -> fluent_builders::DescribeConnectorEntity {
        fluent_builders::DescribeConnectorEntity::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeConnectorProfiles`](crate::client::fluent_builders::DescribeConnectorProfiles) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeConnectorProfiles::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`connector_profile_names(Vec<String>)`](crate::client::fluent_builders::DescribeConnectorProfiles::connector_profile_names) / [`set_connector_profile_names(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeConnectorProfiles::set_connector_profile_names): <p> The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in the Amazon Web Services account. </p>
    ///   - [`connector_type(ConnectorType)`](crate::client::fluent_builders::DescribeConnectorProfiles::connector_type) / [`set_connector_type(Option<ConnectorType>)`](crate::client::fluent_builders::DescribeConnectorProfiles::set_connector_type): <p> The type of connector, such as Salesforce, Amplitude, and so on. </p>
    ///   - [`connector_label(impl Into<String>)`](crate::client::fluent_builders::DescribeConnectorProfiles::connector_label) / [`set_connector_label(Option<String>)`](crate::client::fluent_builders::DescribeConnectorProfiles::set_connector_label): <p>The name of the connector. The name is unique for each <code>ConnectorRegistration</code> in your Amazon Web Services account. Only needed if calling for CUSTOMCONNECTOR connector type/.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeConnectorProfiles::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeConnectorProfiles::set_max_results): <p> Specifies the maximum number of items that should be returned in the result set. The default for <code>maxResults</code> is 20 (for all paginated API operations). </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeConnectorProfiles::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeConnectorProfiles::set_next_token): <p> The pagination token for the next page of data. </p>
    /// - On success, responds with [`DescribeConnectorProfilesOutput`](crate::output::DescribeConnectorProfilesOutput) with field(s):
    ///   - [`connector_profile_details(Option<Vec<ConnectorProfile>>)`](crate::output::DescribeConnectorProfilesOutput::connector_profile_details): <p> Returns information about the connector profiles associated with the flow. </p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeConnectorProfilesOutput::next_token): <p> The pagination token for the next page of data. If <code>nextToken=null</code>, this means that all records have been fetched. </p>
    /// - On failure, responds with [`SdkError<DescribeConnectorProfilesError>`](crate::error::DescribeConnectorProfilesError)
    pub fn describe_connector_profiles(&self) -> fluent_builders::DescribeConnectorProfiles {
        fluent_builders::DescribeConnectorProfiles::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeConnectors`](crate::client::fluent_builders::DescribeConnectors) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeConnectors::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`connector_types(Vec<ConnectorType>)`](crate::client::fluent_builders::DescribeConnectors::connector_types) / [`set_connector_types(Option<Vec<ConnectorType>>)`](crate::client::fluent_builders::DescribeConnectors::set_connector_types): <p> The type of connector, such as Salesforce, Amplitude, and so on. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeConnectors::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeConnectors::set_max_results): <p>The maximum number of items that should be returned in the result set. The default is 20.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeConnectors::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeConnectors::set_next_token): <p> The pagination token for the next page of data. </p>
    /// - On success, responds with [`DescribeConnectorsOutput`](crate::output::DescribeConnectorsOutput) with field(s):
    ///   - [`connector_configurations(Option<HashMap<ConnectorType, ConnectorConfiguration>>)`](crate::output::DescribeConnectorsOutput::connector_configurations): <p> The configuration that is applied to the connectors used in the flow. </p>
    ///   - [`connectors(Option<Vec<ConnectorDetail>>)`](crate::output::DescribeConnectorsOutput::connectors): <p>Information about the connectors supported in Amazon AppFlow.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeConnectorsOutput::next_token): <p> The pagination token for the next page of data. </p>
    /// - On failure, responds with [`SdkError<DescribeConnectorsError>`](crate::error::DescribeConnectorsError)
    pub fn describe_connectors(&self) -> fluent_builders::DescribeConnectors {
        fluent_builders::DescribeConnectors::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeFlow`](crate::client::fluent_builders::DescribeFlow) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`flow_name(impl Into<String>)`](crate::client::fluent_builders::DescribeFlow::flow_name) / [`set_flow_name(Option<String>)`](crate::client::fluent_builders::DescribeFlow::set_flow_name): <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only. </p>
    /// - On success, responds with [`DescribeFlowOutput`](crate::output::DescribeFlowOutput) with field(s):
    ///   - [`flow_arn(Option<String>)`](crate::output::DescribeFlowOutput::flow_arn): <p> The flow's Amazon Resource Name (ARN). </p>
    ///   - [`description(Option<String>)`](crate::output::DescribeFlowOutput::description): <p> A description of the flow. </p>
    ///   - [`flow_name(Option<String>)`](crate::output::DescribeFlowOutput::flow_name): <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only. </p>
    ///   - [`kms_arn(Option<String>)`](crate::output::DescribeFlowOutput::kms_arn): <p> The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption. This is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key. </p>
    ///   - [`flow_status(Option<FlowStatus>)`](crate::output::DescribeFlowOutput::flow_status): <p> Indicates the current status of the flow. </p>
    ///   - [`flow_status_message(Option<String>)`](crate::output::DescribeFlowOutput::flow_status_message): <p> Contains an error message if the flow status is in a suspended or error state. This applies only to scheduled or event-triggered flows. </p>
    ///   - [`source_flow_config(Option<SourceFlowConfig>)`](crate::output::DescribeFlowOutput::source_flow_config): <p> The configuration that controls how Amazon AppFlow retrieves data from the source connector. </p>
    ///   - [`destination_flow_config_list(Option<Vec<DestinationFlowConfig>>)`](crate::output::DescribeFlowOutput::destination_flow_config_list): <p> The configuration that controls how Amazon AppFlow transfers data to the destination connector. </p>
    ///   - [`last_run_execution_details(Option<ExecutionDetails>)`](crate::output::DescribeFlowOutput::last_run_execution_details): <p> Describes the details of the most recent flow run. </p>
    ///   - [`trigger_config(Option<TriggerConfig>)`](crate::output::DescribeFlowOutput::trigger_config): <p> The trigger settings that determine how and when the flow runs. </p>
    ///   - [`tasks(Option<Vec<Task>>)`](crate::output::DescribeFlowOutput::tasks): <p> A list of tasks that Amazon AppFlow performs while transferring the data in the flow run. </p>
    ///   - [`created_at(Option<DateTime>)`](crate::output::DescribeFlowOutput::created_at): <p> Specifies when the flow was created. </p>
    ///   - [`last_updated_at(Option<DateTime>)`](crate::output::DescribeFlowOutput::last_updated_at): <p> Specifies when the flow was last updated. </p>
    ///   - [`created_by(Option<String>)`](crate::output::DescribeFlowOutput::created_by): <p> The ARN of the user who created the flow. </p>
    ///   - [`last_updated_by(Option<String>)`](crate::output::DescribeFlowOutput::last_updated_by): <p> Specifies the user name of the account that performed the most recent update. </p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::DescribeFlowOutput::tags): <p> The tags used to organize, track, or control access for your flow. </p>
    /// - On failure, responds with [`SdkError<DescribeFlowError>`](crate::error::DescribeFlowError)
    pub fn describe_flow(&self) -> fluent_builders::DescribeFlow {
        fluent_builders::DescribeFlow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeFlowExecutionRecords`](crate::client::fluent_builders::DescribeFlowExecutionRecords) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeFlowExecutionRecords::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`flow_name(impl Into<String>)`](crate::client::fluent_builders::DescribeFlowExecutionRecords::flow_name) / [`set_flow_name(Option<String>)`](crate::client::fluent_builders::DescribeFlowExecutionRecords::set_flow_name): <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeFlowExecutionRecords::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeFlowExecutionRecords::set_max_results): <p> Specifies the maximum number of items that should be returned in the result set. The default for <code>maxResults</code> is 20 (for all paginated API operations). </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeFlowExecutionRecords::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeFlowExecutionRecords::set_next_token): <p> The pagination token for the next page of data. </p>
    /// - On success, responds with [`DescribeFlowExecutionRecordsOutput`](crate::output::DescribeFlowExecutionRecordsOutput) with field(s):
    ///   - [`flow_executions(Option<Vec<ExecutionRecord>>)`](crate::output::DescribeFlowExecutionRecordsOutput::flow_executions): <p> Returns a list of all instances when this flow was run. </p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeFlowExecutionRecordsOutput::next_token): <p> The pagination token for the next page of data. </p>
    /// - On failure, responds with [`SdkError<DescribeFlowExecutionRecordsError>`](crate::error::DescribeFlowExecutionRecordsError)
    pub fn describe_flow_execution_records(&self) -> fluent_builders::DescribeFlowExecutionRecords {
        fluent_builders::DescribeFlowExecutionRecords::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListConnectorEntities`](crate::client::fluent_builders::ListConnectorEntities) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`connector_profile_name(impl Into<String>)`](crate::client::fluent_builders::ListConnectorEntities::connector_profile_name) / [`set_connector_profile_name(Option<String>)`](crate::client::fluent_builders::ListConnectorEntities::set_connector_profile_name): <p> The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in the Amazon Web Services account, and is used to query the downstream connector. </p>
    ///   - [`connector_type(ConnectorType)`](crate::client::fluent_builders::ListConnectorEntities::connector_type) / [`set_connector_type(Option<ConnectorType>)`](crate::client::fluent_builders::ListConnectorEntities::set_connector_type): <p> The type of connector, such as Salesforce, Amplitude, and so on. </p>
    ///   - [`entities_path(impl Into<String>)`](crate::client::fluent_builders::ListConnectorEntities::entities_path) / [`set_entities_path(Option<String>)`](crate::client::fluent_builders::ListConnectorEntities::set_entities_path): <p> This optional parameter is specific to connector implementation. Some connectors support multiple levels or categories of entities. You can find out the list of roots for such providers by sending a request without the <code>entitiesPath</code> parameter. If the connector supports entities at different roots, this initial request returns the list of roots. Otherwise, this request returns all entities supported by the provider. </p>
    ///   - [`api_version(impl Into<String>)`](crate::client::fluent_builders::ListConnectorEntities::api_version) / [`set_api_version(Option<String>)`](crate::client::fluent_builders::ListConnectorEntities::set_api_version): <p>The version of the API that's used by the connector.</p>
    /// - On success, responds with [`ListConnectorEntitiesOutput`](crate::output::ListConnectorEntitiesOutput) with field(s):
    ///   - [`connector_entity_map(Option<HashMap<String, Vec<ConnectorEntity>>>)`](crate::output::ListConnectorEntitiesOutput::connector_entity_map): <p> The response of <code>ListConnectorEntities</code> lists entities grouped by category. This map's key represents the group name, and its value contains the list of entities belonging to that group. </p>
    /// - On failure, responds with [`SdkError<ListConnectorEntitiesError>`](crate::error::ListConnectorEntitiesError)
    pub fn list_connector_entities(&self) -> fluent_builders::ListConnectorEntities {
        fluent_builders::ListConnectorEntities::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListConnectors`](crate::client::fluent_builders::ListConnectors) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListConnectors::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListConnectors::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListConnectors::set_max_results): <p>Specifies the maximum number of items that should be returned in the result set. The default for <code>maxResults</code> is 20 (for all paginated API operations).</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListConnectors::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListConnectors::set_next_token): <p>The pagination token for the next page of data.</p>
    /// - On success, responds with [`ListConnectorsOutput`](crate::output::ListConnectorsOutput) with field(s):
    ///   - [`connectors(Option<Vec<ConnectorDetail>>)`](crate::output::ListConnectorsOutput::connectors): <p>Contains information about the connectors supported by Amazon AppFlow.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListConnectorsOutput::next_token): <p>The pagination token for the next page of data. If nextToken=null, this means that all records have been fetched.</p>
    /// - On failure, responds with [`SdkError<ListConnectorsError>`](crate::error::ListConnectorsError)
    pub fn list_connectors(&self) -> fluent_builders::ListConnectors {
        fluent_builders::ListConnectors::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListFlows`](crate::client::fluent_builders::ListFlows) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListFlows::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListFlows::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListFlows::set_max_results): <p> Specifies the maximum number of items that should be returned in the result set. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListFlows::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListFlows::set_next_token): <p> The pagination token for next page of data. </p>
    /// - On success, responds with [`ListFlowsOutput`](crate::output::ListFlowsOutput) with field(s):
    ///   - [`flows(Option<Vec<FlowDefinition>>)`](crate::output::ListFlowsOutput::flows): <p> The list of flows associated with your account. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListFlowsOutput::next_token): <p> The pagination token for next page of data. </p>
    /// - On failure, responds with [`SdkError<ListFlowsError>`](crate::error::ListFlowsError)
    pub fn list_flows(&self) -> fluent_builders::ListFlows {
        fluent_builders::ListFlows::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p> The Amazon Resource Name (ARN) of the specified flow. </p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsForResourceOutput::tags): <p> The tags used to organize, track, or control access for your flow. </p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RegisterConnector`](crate::client::fluent_builders::RegisterConnector) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`connector_label(impl Into<String>)`](crate::client::fluent_builders::RegisterConnector::connector_label) / [`set_connector_label(Option<String>)`](crate::client::fluent_builders::RegisterConnector::set_connector_label): <p> The name of the connector. The name is unique for each <code>ConnectorRegistration</code> in your Amazon Web Services account.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::RegisterConnector::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::RegisterConnector::set_description): <p>A description about the connector that's being registered.</p>
    ///   - [`connector_provisioning_type(ConnectorProvisioningType)`](crate::client::fluent_builders::RegisterConnector::connector_provisioning_type) / [`set_connector_provisioning_type(Option<ConnectorProvisioningType>)`](crate::client::fluent_builders::RegisterConnector::set_connector_provisioning_type): <p>The provisioning type of the connector. Currently the only supported value is LAMBDA. </p>
    ///   - [`connector_provisioning_config(ConnectorProvisioningConfig)`](crate::client::fluent_builders::RegisterConnector::connector_provisioning_config) / [`set_connector_provisioning_config(Option<ConnectorProvisioningConfig>)`](crate::client::fluent_builders::RegisterConnector::set_connector_provisioning_config): <p>The provisioning type of the connector. Currently the only supported value is LAMBDA.</p>
    /// - On success, responds with [`RegisterConnectorOutput`](crate::output::RegisterConnectorOutput) with field(s):
    ///   - [`connector_arn(Option<String>)`](crate::output::RegisterConnectorOutput::connector_arn): <p>The ARN of the connector being registered.</p>
    /// - On failure, responds with [`SdkError<RegisterConnectorError>`](crate::error::RegisterConnectorError)
    pub fn register_connector(&self) -> fluent_builders::RegisterConnector {
        fluent_builders::RegisterConnector::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartFlow`](crate::client::fluent_builders::StartFlow) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`flow_name(impl Into<String>)`](crate::client::fluent_builders::StartFlow::flow_name) / [`set_flow_name(Option<String>)`](crate::client::fluent_builders::StartFlow::set_flow_name): <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only. </p>
    /// - On success, responds with [`StartFlowOutput`](crate::output::StartFlowOutput) with field(s):
    ///   - [`flow_arn(Option<String>)`](crate::output::StartFlowOutput::flow_arn): <p> The flow's Amazon Resource Name (ARN). </p>
    ///   - [`flow_status(Option<FlowStatus>)`](crate::output::StartFlowOutput::flow_status): <p> Indicates the current status of the flow. </p>
    ///   - [`execution_id(Option<String>)`](crate::output::StartFlowOutput::execution_id): <p> Returns the internal execution ID of an on-demand flow when the flow is started. For scheduled or event-triggered flows, this value is null. </p>
    /// - On failure, responds with [`SdkError<StartFlowError>`](crate::error::StartFlowError)
    pub fn start_flow(&self) -> fluent_builders::StartFlow {
        fluent_builders::StartFlow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StopFlow`](crate::client::fluent_builders::StopFlow) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`flow_name(impl Into<String>)`](crate::client::fluent_builders::StopFlow::flow_name) / [`set_flow_name(Option<String>)`](crate::client::fluent_builders::StopFlow::set_flow_name): <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only. </p>
    /// - On success, responds with [`StopFlowOutput`](crate::output::StopFlowOutput) with field(s):
    ///   - [`flow_arn(Option<String>)`](crate::output::StopFlowOutput::flow_arn): <p> The flow's Amazon Resource Name (ARN). </p>
    ///   - [`flow_status(Option<FlowStatus>)`](crate::output::StopFlowOutput::flow_status): <p> Indicates the current status of the flow. </p>
    /// - On failure, responds with [`SdkError<StopFlowError>`](crate::error::StopFlowError)
    pub fn stop_flow(&self) -> fluent_builders::StopFlow {
        fluent_builders::StopFlow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p> The Amazon Resource Name (ARN) of the flow that you want to tag. </p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagResource::set_tags): <p> The tags used to organize, track, or control access for your flow. </p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UnregisterConnector`](crate::client::fluent_builders::UnregisterConnector) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`connector_label(impl Into<String>)`](crate::client::fluent_builders::UnregisterConnector::connector_label) / [`set_connector_label(Option<String>)`](crate::client::fluent_builders::UnregisterConnector::set_connector_label): <p>The label of the connector. The label is unique for each <code>ConnectorRegistration</code> in your Amazon Web Services account.</p>
    ///   - [`force_delete(bool)`](crate::client::fluent_builders::UnregisterConnector::force_delete) / [`set_force_delete(bool)`](crate::client::fluent_builders::UnregisterConnector::set_force_delete): <p>Indicates whether Amazon AppFlow should unregister the connector, even if it is currently in use in one or more connector profiles. The default value is false.</p>
    /// - On success, responds with [`UnregisterConnectorOutput`](crate::output::UnregisterConnectorOutput)

    /// - On failure, responds with [`SdkError<UnregisterConnectorError>`](crate::error::UnregisterConnectorError)
    pub fn unregister_connector(&self) -> fluent_builders::UnregisterConnector {
        fluent_builders::UnregisterConnector::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p> The Amazon Resource Name (ARN) of the flow that you want to untag. </p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p> The tag keys associated with the tag that you want to remove from your flow. </p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateConnectorProfile`](crate::client::fluent_builders::UpdateConnectorProfile) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`connector_profile_name(impl Into<String>)`](crate::client::fluent_builders::UpdateConnectorProfile::connector_profile_name) / [`set_connector_profile_name(Option<String>)`](crate::client::fluent_builders::UpdateConnectorProfile::set_connector_profile_name): <p> The name of the connector profile and is unique for each <code>ConnectorProfile</code> in the Amazon Web Services account. </p>
    ///   - [`connection_mode(ConnectionMode)`](crate::client::fluent_builders::UpdateConnectorProfile::connection_mode) / [`set_connection_mode(Option<ConnectionMode>)`](crate::client::fluent_builders::UpdateConnectorProfile::set_connection_mode): <p> Indicates the connection mode and if it is public or private. </p>
    ///   - [`connector_profile_config(ConnectorProfileConfig)`](crate::client::fluent_builders::UpdateConnectorProfile::connector_profile_config) / [`set_connector_profile_config(Option<ConnectorProfileConfig>)`](crate::client::fluent_builders::UpdateConnectorProfile::set_connector_profile_config): <p> Defines the connector-specific profile configuration and credentials. </p>
    /// - On success, responds with [`UpdateConnectorProfileOutput`](crate::output::UpdateConnectorProfileOutput) with field(s):
    ///   - [`connector_profile_arn(Option<String>)`](crate::output::UpdateConnectorProfileOutput::connector_profile_arn): <p> The Amazon Resource Name (ARN) of the connector profile. </p>
    /// - On failure, responds with [`SdkError<UpdateConnectorProfileError>`](crate::error::UpdateConnectorProfileError)
    pub fn update_connector_profile(&self) -> fluent_builders::UpdateConnectorProfile {
        fluent_builders::UpdateConnectorProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateFlow`](crate::client::fluent_builders::UpdateFlow) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`flow_name(impl Into<String>)`](crate::client::fluent_builders::UpdateFlow::flow_name) / [`set_flow_name(Option<String>)`](crate::client::fluent_builders::UpdateFlow::set_flow_name): <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only. </p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateFlow::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateFlow::set_description): <p> A description of the flow. </p>
    ///   - [`trigger_config(TriggerConfig)`](crate::client::fluent_builders::UpdateFlow::trigger_config) / [`set_trigger_config(Option<TriggerConfig>)`](crate::client::fluent_builders::UpdateFlow::set_trigger_config): <p> The trigger settings that determine how and when the flow runs. </p>
    ///   - [`source_flow_config(SourceFlowConfig)`](crate::client::fluent_builders::UpdateFlow::source_flow_config) / [`set_source_flow_config(Option<SourceFlowConfig>)`](crate::client::fluent_builders::UpdateFlow::set_source_flow_config): <p> Contains information about the configuration of the source connector used in the flow. </p>
    ///   - [`destination_flow_config_list(Vec<DestinationFlowConfig>)`](crate::client::fluent_builders::UpdateFlow::destination_flow_config_list) / [`set_destination_flow_config_list(Option<Vec<DestinationFlowConfig>>)`](crate::client::fluent_builders::UpdateFlow::set_destination_flow_config_list): <p> The configuration that controls how Amazon AppFlow transfers data to the destination connector. </p>
    ///   - [`tasks(Vec<Task>)`](crate::client::fluent_builders::UpdateFlow::tasks) / [`set_tasks(Option<Vec<Task>>)`](crate::client::fluent_builders::UpdateFlow::set_tasks): <p> A list of tasks that Amazon AppFlow performs while transferring the data in the flow run. </p>
    /// - On success, responds with [`UpdateFlowOutput`](crate::output::UpdateFlowOutput) with field(s):
    ///   - [`flow_status(Option<FlowStatus>)`](crate::output::UpdateFlowOutput::flow_status): <p>Indicates the current status of the flow. </p>
    /// - On failure, responds with [`SdkError<UpdateFlowError>`](crate::error::UpdateFlowError)
    pub fn update_flow(&self) -> fluent_builders::UpdateFlow {
        fluent_builders::UpdateFlow::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateConnectorProfile`.
    ///
    /// <p> Creates a new connector profile associated with your Amazon Web Services account. There is a soft quota of 100 connector profiles per Amazon Web Services account. If you need more connector profiles than this quota allows, you can submit a request to the Amazon AppFlow team through the Amazon AppFlow support channel. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateConnectorProfile {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_connector_profile_input::Builder,
    }
    impl CreateConnectorProfile {
        /// Creates a new `CreateConnectorProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateConnectorProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateConnectorProfileError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in your Amazon Web Services account. </p>
        pub fn connector_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connector_profile_name(input.into());
            self
        }
        /// <p> The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in your Amazon Web Services account. </p>
        pub fn set_connector_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connector_profile_name(input);
            self
        }
        /// <p> The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption. This is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key. </p>
        pub fn kms_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_arn(input.into());
            self
        }
        /// <p> The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption. This is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key. </p>
        pub fn set_kms_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_arn(input);
            self
        }
        /// <p> The type of connector, such as Salesforce, Amplitude, and so on. </p>
        pub fn connector_type(mut self, input: crate::model::ConnectorType) -> Self {
            self.inner = self.inner.connector_type(input);
            self
        }
        /// <p> The type of connector, such as Salesforce, Amplitude, and so on. </p>
        pub fn set_connector_type(
            mut self,
            input: std::option::Option<crate::model::ConnectorType>,
        ) -> Self {
            self.inner = self.inner.set_connector_type(input);
            self
        }
        /// <p>The label of the connector. The label is unique for each <code>ConnectorRegistration</code> in your Amazon Web Services account. Only needed if calling for CUSTOMCONNECTOR connector type/.</p>
        pub fn connector_label(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connector_label(input.into());
            self
        }
        /// <p>The label of the connector. The label is unique for each <code>ConnectorRegistration</code> in your Amazon Web Services account. Only needed if calling for CUSTOMCONNECTOR connector type/.</p>
        pub fn set_connector_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connector_label(input);
            self
        }
        /// <p> Indicates the connection mode and specifies whether it is public or private. Private flows use Amazon Web Services PrivateLink to route data over Amazon Web Services infrastructure without exposing it to the public internet. </p>
        pub fn connection_mode(mut self, input: crate::model::ConnectionMode) -> Self {
            self.inner = self.inner.connection_mode(input);
            self
        }
        /// <p> Indicates the connection mode and specifies whether it is public or private. Private flows use Amazon Web Services PrivateLink to route data over Amazon Web Services infrastructure without exposing it to the public internet. </p>
        pub fn set_connection_mode(
            mut self,
            input: std::option::Option<crate::model::ConnectionMode>,
        ) -> Self {
            self.inner = self.inner.set_connection_mode(input);
            self
        }
        /// <p> Defines the connector-specific configuration and credentials. </p>
        pub fn connector_profile_config(
            mut self,
            input: crate::model::ConnectorProfileConfig,
        ) -> Self {
            self.inner = self.inner.connector_profile_config(input);
            self
        }
        /// <p> Defines the connector-specific configuration and credentials. </p>
        pub fn set_connector_profile_config(
            mut self,
            input: std::option::Option<crate::model::ConnectorProfileConfig>,
        ) -> Self {
            self.inner = self.inner.set_connector_profile_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFlow`.
    ///
    /// <p> Enables your application to create a new flow using Amazon AppFlow. You must create a connector profile before calling this API. Please note that the Request Syntax below shows syntax for multiple destinations, however, you can only transfer data to one item in this list at a time. Amazon AppFlow does not currently support flows to multiple destinations at once. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateFlow {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_flow_input::Builder,
    }
    impl CreateFlow {
        /// Creates a new `CreateFlow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFlowOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFlowError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only. </p>
        pub fn flow_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_name(input.into());
            self
        }
        /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only. </p>
        pub fn set_flow_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_flow_name(input);
            self
        }
        /// <p> A description of the flow you want to create. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p> A description of the flow you want to create. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p> The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption. This is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key. </p>
        pub fn kms_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_arn(input.into());
            self
        }
        /// <p> The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption. This is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key. </p>
        pub fn set_kms_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_arn(input);
            self
        }
        /// <p> The trigger settings that determine how and when the flow runs. </p>
        pub fn trigger_config(mut self, input: crate::model::TriggerConfig) -> Self {
            self.inner = self.inner.trigger_config(input);
            self
        }
        /// <p> The trigger settings that determine how and when the flow runs. </p>
        pub fn set_trigger_config(
            mut self,
            input: std::option::Option<crate::model::TriggerConfig>,
        ) -> Self {
            self.inner = self.inner.set_trigger_config(input);
            self
        }
        /// <p> The configuration that controls how Amazon AppFlow retrieves data from the source connector. </p>
        pub fn source_flow_config(mut self, input: crate::model::SourceFlowConfig) -> Self {
            self.inner = self.inner.source_flow_config(input);
            self
        }
        /// <p> The configuration that controls how Amazon AppFlow retrieves data from the source connector. </p>
        pub fn set_source_flow_config(
            mut self,
            input: std::option::Option<crate::model::SourceFlowConfig>,
        ) -> Self {
            self.inner = self.inner.set_source_flow_config(input);
            self
        }
        /// Appends an item to `destinationFlowConfigList`.
        ///
        /// To override the contents of this collection use [`set_destination_flow_config_list`](Self::set_destination_flow_config_list).
        ///
        /// <p> The configuration that controls how Amazon AppFlow places data in the destination connector. </p>
        pub fn destination_flow_config_list(
            mut self,
            input: crate::model::DestinationFlowConfig,
        ) -> Self {
            self.inner = self.inner.destination_flow_config_list(input);
            self
        }
        /// <p> The configuration that controls how Amazon AppFlow places data in the destination connector. </p>
        pub fn set_destination_flow_config_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DestinationFlowConfig>>,
        ) -> Self {
            self.inner = self.inner.set_destination_flow_config_list(input);
            self
        }
        /// Appends an item to `tasks`.
        ///
        /// To override the contents of this collection use [`set_tasks`](Self::set_tasks).
        ///
        /// <p> A list of tasks that Amazon AppFlow performs while transferring the data in the flow run. </p>
        pub fn tasks(mut self, input: crate::model::Task) -> Self {
            self.inner = self.inner.tasks(input);
            self
        }
        /// <p> A list of tasks that Amazon AppFlow performs while transferring the data in the flow run. </p>
        pub fn set_tasks(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Task>>,
        ) -> Self {
            self.inner = self.inner.set_tasks(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> The tags used to organize, track, or control access for your flow. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p> The tags used to organize, track, or control access for your flow. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteConnectorProfile`.
    ///
    /// <p> Enables you to delete an existing connector profile. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteConnectorProfile {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_connector_profile_input::Builder,
    }
    impl DeleteConnectorProfile {
        /// Creates a new `DeleteConnectorProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteConnectorProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteConnectorProfileError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in your account. </p>
        pub fn connector_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connector_profile_name(input.into());
            self
        }
        /// <p> The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in your account. </p>
        pub fn set_connector_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connector_profile_name(input);
            self
        }
        /// <p> Indicates whether Amazon AppFlow should delete the profile, even if it is currently in use in one or more flows. </p>
        pub fn force_delete(mut self, input: bool) -> Self {
            self.inner = self.inner.force_delete(input);
            self
        }
        /// <p> Indicates whether Amazon AppFlow should delete the profile, even if it is currently in use in one or more flows. </p>
        pub fn set_force_delete(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force_delete(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFlow`.
    ///
    /// <p> Enables your application to delete an existing flow. Before deleting the flow, Amazon AppFlow validates the request by checking the flow configuration and status. You can delete flows one at a time. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteFlow {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_flow_input::Builder,
    }
    impl DeleteFlow {
        /// Creates a new `DeleteFlow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFlowOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFlowError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only. </p>
        pub fn flow_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_name(input.into());
            self
        }
        /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only. </p>
        pub fn set_flow_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_flow_name(input);
            self
        }
        /// <p> Indicates whether Amazon AppFlow should delete the flow, even if it is currently in use. </p>
        pub fn force_delete(mut self, input: bool) -> Self {
            self.inner = self.inner.force_delete(input);
            self
        }
        /// <p> Indicates whether Amazon AppFlow should delete the flow, even if it is currently in use. </p>
        pub fn set_force_delete(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force_delete(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeConnector`.
    ///
    /// <p>Describes the given custom connector registered in your Amazon Web Services account. This API can be used for custom connectors that are registered in your account and also for Amazon authored connectors.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeConnector {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_connector_input::Builder,
    }
    impl DescribeConnector {
        /// Creates a new `DescribeConnector`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeConnectorOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeConnectorError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The connector type, such as CUSTOMCONNECTOR, Saleforce, Marketo. Please choose CUSTOMCONNECTOR for Lambda based custom connectors.</p>
        pub fn connector_type(mut self, input: crate::model::ConnectorType) -> Self {
            self.inner = self.inner.connector_type(input);
            self
        }
        /// <p>The connector type, such as CUSTOMCONNECTOR, Saleforce, Marketo. Please choose CUSTOMCONNECTOR for Lambda based custom connectors.</p>
        pub fn set_connector_type(
            mut self,
            input: std::option::Option<crate::model::ConnectorType>,
        ) -> Self {
            self.inner = self.inner.set_connector_type(input);
            self
        }
        /// <p>The label of the connector. The label is unique for each <code>ConnectorRegistration</code> in your Amazon Web Services account. Only needed if calling for CUSTOMCONNECTOR connector type/.</p>
        pub fn connector_label(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connector_label(input.into());
            self
        }
        /// <p>The label of the connector. The label is unique for each <code>ConnectorRegistration</code> in your Amazon Web Services account. Only needed if calling for CUSTOMCONNECTOR connector type/.</p>
        pub fn set_connector_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connector_label(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeConnectorEntity`.
    ///
    /// <p> Provides details regarding the entity used with the connector, with a description of the data model for each entity. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeConnectorEntity {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_connector_entity_input::Builder,
    }
    impl DescribeConnectorEntity {
        /// Creates a new `DescribeConnectorEntity`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeConnectorEntityOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeConnectorEntityError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The entity name for that connector. </p>
        pub fn connector_entity_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connector_entity_name(input.into());
            self
        }
        /// <p> The entity name for that connector. </p>
        pub fn set_connector_entity_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connector_entity_name(input);
            self
        }
        /// <p> The type of connector application, such as Salesforce, Amplitude, and so on. </p>
        pub fn connector_type(mut self, input: crate::model::ConnectorType) -> Self {
            self.inner = self.inner.connector_type(input);
            self
        }
        /// <p> The type of connector application, such as Salesforce, Amplitude, and so on. </p>
        pub fn set_connector_type(
            mut self,
            input: std::option::Option<crate::model::ConnectorType>,
        ) -> Self {
            self.inner = self.inner.set_connector_type(input);
            self
        }
        /// <p> The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in the Amazon Web Services account. </p>
        pub fn connector_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connector_profile_name(input.into());
            self
        }
        /// <p> The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in the Amazon Web Services account. </p>
        pub fn set_connector_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connector_profile_name(input);
            self
        }
        /// <p>The version of the API that's used by the connector.</p>
        pub fn api_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_version(input.into());
            self
        }
        /// <p>The version of the API that's used by the connector.</p>
        pub fn set_api_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeConnectorProfiles`.
    ///
    /// <p> Returns a list of <code>connector-profile</code> details matching the provided <code>connector-profile</code> names and <code>connector-types</code>. Both input lists are optional, and you can use them to filter the result. </p>
    /// <p>If no names or <code>connector-types</code> are provided, returns all connector profiles in a paginated form. If there is no match, this operation returns an empty list.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeConnectorProfiles {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_connector_profiles_input::Builder,
    }
    impl DescribeConnectorProfiles {
        /// Creates a new `DescribeConnectorProfiles`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeConnectorProfilesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeConnectorProfilesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeConnectorProfilesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeConnectorProfilesPaginator {
            crate::paginator::DescribeConnectorProfilesPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `connectorProfileNames`.
        ///
        /// To override the contents of this collection use [`set_connector_profile_names`](Self::set_connector_profile_names).
        ///
        /// <p> The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in the Amazon Web Services account. </p>
        pub fn connector_profile_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connector_profile_names(input.into());
            self
        }
        /// <p> The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in the Amazon Web Services account. </p>
        pub fn set_connector_profile_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_connector_profile_names(input);
            self
        }
        /// <p> The type of connector, such as Salesforce, Amplitude, and so on. </p>
        pub fn connector_type(mut self, input: crate::model::ConnectorType) -> Self {
            self.inner = self.inner.connector_type(input);
            self
        }
        /// <p> The type of connector, such as Salesforce, Amplitude, and so on. </p>
        pub fn set_connector_type(
            mut self,
            input: std::option::Option<crate::model::ConnectorType>,
        ) -> Self {
            self.inner = self.inner.set_connector_type(input);
            self
        }
        /// <p>The name of the connector. The name is unique for each <code>ConnectorRegistration</code> in your Amazon Web Services account. Only needed if calling for CUSTOMCONNECTOR connector type/.</p>
        pub fn connector_label(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connector_label(input.into());
            self
        }
        /// <p>The name of the connector. The name is unique for each <code>ConnectorRegistration</code> in your Amazon Web Services account. Only needed if calling for CUSTOMCONNECTOR connector type/.</p>
        pub fn set_connector_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connector_label(input);
            self
        }
        /// <p> Specifies the maximum number of items that should be returned in the result set. The default for <code>maxResults</code> is 20 (for all paginated API operations). </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> Specifies the maximum number of items that should be returned in the result set. The default for <code>maxResults</code> is 20 (for all paginated API operations). </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p> The pagination token for the next page of data. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> The pagination token for the next page of data. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeConnectors`.
    ///
    /// <p> Describes the connectors vended by Amazon AppFlow for specified connector types. If you don't specify a connector type, this operation describes all connectors vended by Amazon AppFlow. If there are more connectors than can be returned in one page, the response contains a <code>nextToken</code> object, which can be be passed in to the next call to the <code>DescribeConnectors</code> API operation to retrieve the next page. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeConnectors {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_connectors_input::Builder,
    }
    impl DescribeConnectors {
        /// Creates a new `DescribeConnectors`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeConnectorsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeConnectorsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeConnectorsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeConnectorsPaginator {
            crate::paginator::DescribeConnectorsPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `connectorTypes`.
        ///
        /// To override the contents of this collection use [`set_connector_types`](Self::set_connector_types).
        ///
        /// <p> The type of connector, such as Salesforce, Amplitude, and so on. </p>
        pub fn connector_types(mut self, input: crate::model::ConnectorType) -> Self {
            self.inner = self.inner.connector_types(input);
            self
        }
        /// <p> The type of connector, such as Salesforce, Amplitude, and so on. </p>
        pub fn set_connector_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConnectorType>>,
        ) -> Self {
            self.inner = self.inner.set_connector_types(input);
            self
        }
        /// <p>The maximum number of items that should be returned in the result set. The default is 20.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items that should be returned in the result set. The default is 20.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p> The pagination token for the next page of data. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> The pagination token for the next page of data. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeFlow`.
    ///
    /// <p> Provides a description of the specified flow. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeFlow {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_flow_input::Builder,
    }
    impl DescribeFlow {
        /// Creates a new `DescribeFlow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeFlowOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeFlowError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only. </p>
        pub fn flow_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_name(input.into());
            self
        }
        /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only. </p>
        pub fn set_flow_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_flow_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeFlowExecutionRecords`.
    ///
    /// <p> Fetches the execution history of the flow. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeFlowExecutionRecords {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_flow_execution_records_input::Builder,
    }
    impl DescribeFlowExecutionRecords {
        /// Creates a new `DescribeFlowExecutionRecords`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeFlowExecutionRecordsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeFlowExecutionRecordsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeFlowExecutionRecordsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeFlowExecutionRecordsPaginator {
            crate::paginator::DescribeFlowExecutionRecordsPaginator::new(self.handle, self.inner)
        }
        /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only. </p>
        pub fn flow_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_name(input.into());
            self
        }
        /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only. </p>
        pub fn set_flow_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_flow_name(input);
            self
        }
        /// <p> Specifies the maximum number of items that should be returned in the result set. The default for <code>maxResults</code> is 20 (for all paginated API operations). </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> Specifies the maximum number of items that should be returned in the result set. The default for <code>maxResults</code> is 20 (for all paginated API operations). </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p> The pagination token for the next page of data. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> The pagination token for the next page of data. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListConnectorEntities`.
    ///
    /// <p> Returns the list of available connector entities supported by Amazon AppFlow. For example, you can query Salesforce for <i>Account</i> and <i>Opportunity</i> entities, or query ServiceNow for the <i>Incident</i> entity. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListConnectorEntities {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_connector_entities_input::Builder,
    }
    impl ListConnectorEntities {
        /// Creates a new `ListConnectorEntities`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListConnectorEntitiesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListConnectorEntitiesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in the Amazon Web Services account, and is used to query the downstream connector. </p>
        pub fn connector_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connector_profile_name(input.into());
            self
        }
        /// <p> The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in the Amazon Web Services account, and is used to query the downstream connector. </p>
        pub fn set_connector_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connector_profile_name(input);
            self
        }
        /// <p> The type of connector, such as Salesforce, Amplitude, and so on. </p>
        pub fn connector_type(mut self, input: crate::model::ConnectorType) -> Self {
            self.inner = self.inner.connector_type(input);
            self
        }
        /// <p> The type of connector, such as Salesforce, Amplitude, and so on. </p>
        pub fn set_connector_type(
            mut self,
            input: std::option::Option<crate::model::ConnectorType>,
        ) -> Self {
            self.inner = self.inner.set_connector_type(input);
            self
        }
        /// <p> This optional parameter is specific to connector implementation. Some connectors support multiple levels or categories of entities. You can find out the list of roots for such providers by sending a request without the <code>entitiesPath</code> parameter. If the connector supports entities at different roots, this initial request returns the list of roots. Otherwise, this request returns all entities supported by the provider. </p>
        pub fn entities_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entities_path(input.into());
            self
        }
        /// <p> This optional parameter is specific to connector implementation. Some connectors support multiple levels or categories of entities. You can find out the list of roots for such providers by sending a request without the <code>entitiesPath</code> parameter. If the connector supports entities at different roots, this initial request returns the list of roots. Otherwise, this request returns all entities supported by the provider. </p>
        pub fn set_entities_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_entities_path(input);
            self
        }
        /// <p>The version of the API that's used by the connector.</p>
        pub fn api_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_version(input.into());
            self
        }
        /// <p>The version of the API that's used by the connector.</p>
        pub fn set_api_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListConnectors`.
    ///
    /// <p>Returns the list of all registered custom connectors in your Amazon Web Services account. This API lists only custom connectors registered in this account, not the Amazon Web Services authored connectors. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListConnectors {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_connectors_input::Builder,
    }
    impl ListConnectors {
        /// Creates a new `ListConnectors`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListConnectorsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListConnectorsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListConnectorsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListConnectorsPaginator {
            crate::paginator::ListConnectorsPaginator::new(self.handle, self.inner)
        }
        /// <p>Specifies the maximum number of items that should be returned in the result set. The default for <code>maxResults</code> is 20 (for all paginated API operations).</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Specifies the maximum number of items that should be returned in the result set. The default for <code>maxResults</code> is 20 (for all paginated API operations).</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token for the next page of data.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token for the next page of data.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFlows`.
    ///
    /// <p> Lists all of the flows associated with your account. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListFlows {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_flows_input::Builder,
    }
    impl ListFlows {
        /// Creates a new `ListFlows`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFlowsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFlowsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListFlowsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListFlowsPaginator {
            crate::paginator::ListFlowsPaginator::new(self.handle, self.inner)
        }
        /// <p> Specifies the maximum number of items that should be returned in the result set. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> Specifies the maximum number of items that should be returned in the result set. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p> The pagination token for next page of data. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> The pagination token for next page of data. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p> Retrieves the tags that are associated with a specified flow. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The Amazon Resource Name (ARN) of the specified flow. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the specified flow. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterConnector`.
    ///
    /// <p>Registers a new connector with your Amazon Web Services account. Before you can register the connector, you must deploy lambda in your account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RegisterConnector {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::register_connector_input::Builder,
    }
    impl RegisterConnector {
        /// Creates a new `RegisterConnector`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterConnectorOutput,
            aws_smithy_http::result::SdkError<crate::error::RegisterConnectorError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the connector. The name is unique for each <code>ConnectorRegistration</code> in your Amazon Web Services account.</p>
        pub fn connector_label(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connector_label(input.into());
            self
        }
        /// <p> The name of the connector. The name is unique for each <code>ConnectorRegistration</code> in your Amazon Web Services account.</p>
        pub fn set_connector_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connector_label(input);
            self
        }
        /// <p>A description about the connector that's being registered.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description about the connector that's being registered.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The provisioning type of the connector. Currently the only supported value is LAMBDA. </p>
        pub fn connector_provisioning_type(
            mut self,
            input: crate::model::ConnectorProvisioningType,
        ) -> Self {
            self.inner = self.inner.connector_provisioning_type(input);
            self
        }
        /// <p>The provisioning type of the connector. Currently the only supported value is LAMBDA. </p>
        pub fn set_connector_provisioning_type(
            mut self,
            input: std::option::Option<crate::model::ConnectorProvisioningType>,
        ) -> Self {
            self.inner = self.inner.set_connector_provisioning_type(input);
            self
        }
        /// <p>The provisioning type of the connector. Currently the only supported value is LAMBDA.</p>
        pub fn connector_provisioning_config(
            mut self,
            input: crate::model::ConnectorProvisioningConfig,
        ) -> Self {
            self.inner = self.inner.connector_provisioning_config(input);
            self
        }
        /// <p>The provisioning type of the connector. Currently the only supported value is LAMBDA.</p>
        pub fn set_connector_provisioning_config(
            mut self,
            input: std::option::Option<crate::model::ConnectorProvisioningConfig>,
        ) -> Self {
            self.inner = self.inner.set_connector_provisioning_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartFlow`.
    ///
    /// <p> Activates an existing flow. For on-demand flows, this operation runs the flow immediately. For schedule and event-triggered flows, this operation activates the flow. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartFlow {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_flow_input::Builder,
    }
    impl StartFlow {
        /// Creates a new `StartFlow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartFlowOutput,
            aws_smithy_http::result::SdkError<crate::error::StartFlowError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only. </p>
        pub fn flow_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_name(input.into());
            self
        }
        /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only. </p>
        pub fn set_flow_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_flow_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopFlow`.
    ///
    /// <p> Deactivates the existing flow. For on-demand flows, this operation returns an <code>unsupportedOperationException</code> error message. For schedule and event-triggered flows, this operation deactivates the flow. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StopFlow {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::stop_flow_input::Builder,
    }
    impl StopFlow {
        /// Creates a new `StopFlow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopFlowOutput,
            aws_smithy_http::result::SdkError<crate::error::StopFlowError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only. </p>
        pub fn flow_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_name(input.into());
            self
        }
        /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only. </p>
        pub fn set_flow_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_flow_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p> Applies a tag to the specified flow. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The Amazon Resource Name (ARN) of the flow that you want to tag. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the flow that you want to tag. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> The tags used to organize, track, or control access for your flow. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p> The tags used to organize, track, or control access for your flow. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UnregisterConnector`.
    ///
    /// <p>Unregisters the custom connector registered in your account that matches the connectorLabel provided in the request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UnregisterConnector {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::unregister_connector_input::Builder,
    }
    impl UnregisterConnector {
        /// Creates a new `UnregisterConnector`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UnregisterConnectorOutput,
            aws_smithy_http::result::SdkError<crate::error::UnregisterConnectorError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The label of the connector. The label is unique for each <code>ConnectorRegistration</code> in your Amazon Web Services account.</p>
        pub fn connector_label(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connector_label(input.into());
            self
        }
        /// <p>The label of the connector. The label is unique for each <code>ConnectorRegistration</code> in your Amazon Web Services account.</p>
        pub fn set_connector_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connector_label(input);
            self
        }
        /// <p>Indicates whether Amazon AppFlow should unregister the connector, even if it is currently in use in one or more connector profiles. The default value is false.</p>
        pub fn force_delete(mut self, input: bool) -> Self {
            self.inner = self.inner.force_delete(input);
            self
        }
        /// <p>Indicates whether Amazon AppFlow should unregister the connector, even if it is currently in use in one or more connector profiles. The default value is false.</p>
        pub fn set_force_delete(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force_delete(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p> Removes a tag from the specified flow. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The Amazon Resource Name (ARN) of the flow that you want to untag. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the flow that you want to untag. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p> The tag keys associated with the tag that you want to remove from your flow. </p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p> The tag keys associated with the tag that you want to remove from your flow. </p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateConnectorProfile`.
    ///
    /// <p> Updates a given connector profile associated with your account. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateConnectorProfile {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_connector_profile_input::Builder,
    }
    impl UpdateConnectorProfile {
        /// Creates a new `UpdateConnectorProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateConnectorProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateConnectorProfileError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the connector profile and is unique for each <code>ConnectorProfile</code> in the Amazon Web Services account. </p>
        pub fn connector_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connector_profile_name(input.into());
            self
        }
        /// <p> The name of the connector profile and is unique for each <code>ConnectorProfile</code> in the Amazon Web Services account. </p>
        pub fn set_connector_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connector_profile_name(input);
            self
        }
        /// <p> Indicates the connection mode and if it is public or private. </p>
        pub fn connection_mode(mut self, input: crate::model::ConnectionMode) -> Self {
            self.inner = self.inner.connection_mode(input);
            self
        }
        /// <p> Indicates the connection mode and if it is public or private. </p>
        pub fn set_connection_mode(
            mut self,
            input: std::option::Option<crate::model::ConnectionMode>,
        ) -> Self {
            self.inner = self.inner.set_connection_mode(input);
            self
        }
        /// <p> Defines the connector-specific profile configuration and credentials. </p>
        pub fn connector_profile_config(
            mut self,
            input: crate::model::ConnectorProfileConfig,
        ) -> Self {
            self.inner = self.inner.connector_profile_config(input);
            self
        }
        /// <p> Defines the connector-specific profile configuration and credentials. </p>
        pub fn set_connector_profile_config(
            mut self,
            input: std::option::Option<crate::model::ConnectorProfileConfig>,
        ) -> Self {
            self.inner = self.inner.set_connector_profile_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFlow`.
    ///
    /// <p> Updates an existing flow. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateFlow {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_flow_input::Builder,
    }
    impl UpdateFlow {
        /// Creates a new `UpdateFlow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFlowOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFlowError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only. </p>
        pub fn flow_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_name(input.into());
            self
        }
        /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only. </p>
        pub fn set_flow_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_flow_name(input);
            self
        }
        /// <p> A description of the flow. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p> A description of the flow. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p> The trigger settings that determine how and when the flow runs. </p>
        pub fn trigger_config(mut self, input: crate::model::TriggerConfig) -> Self {
            self.inner = self.inner.trigger_config(input);
            self
        }
        /// <p> The trigger settings that determine how and when the flow runs. </p>
        pub fn set_trigger_config(
            mut self,
            input: std::option::Option<crate::model::TriggerConfig>,
        ) -> Self {
            self.inner = self.inner.set_trigger_config(input);
            self
        }
        /// <p> Contains information about the configuration of the source connector used in the flow. </p>
        pub fn source_flow_config(mut self, input: crate::model::SourceFlowConfig) -> Self {
            self.inner = self.inner.source_flow_config(input);
            self
        }
        /// <p> Contains information about the configuration of the source connector used in the flow. </p>
        pub fn set_source_flow_config(
            mut self,
            input: std::option::Option<crate::model::SourceFlowConfig>,
        ) -> Self {
            self.inner = self.inner.set_source_flow_config(input);
            self
        }
        /// Appends an item to `destinationFlowConfigList`.
        ///
        /// To override the contents of this collection use [`set_destination_flow_config_list`](Self::set_destination_flow_config_list).
        ///
        /// <p> The configuration that controls how Amazon AppFlow transfers data to the destination connector. </p>
        pub fn destination_flow_config_list(
            mut self,
            input: crate::model::DestinationFlowConfig,
        ) -> Self {
            self.inner = self.inner.destination_flow_config_list(input);
            self
        }
        /// <p> The configuration that controls how Amazon AppFlow transfers data to the destination connector. </p>
        pub fn set_destination_flow_config_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DestinationFlowConfig>>,
        ) -> Self {
            self.inner = self.inner.set_destination_flow_config_list(input);
            self
        }
        /// Appends an item to `tasks`.
        ///
        /// To override the contents of this collection use [`set_tasks`](Self::set_tasks).
        ///
        /// <p> A list of tasks that Amazon AppFlow performs while transferring the data in the flow run. </p>
        pub fn tasks(mut self, input: crate::model::Task) -> Self {
            self.inner = self.inner.tasks(input);
            self
        }
        /// <p> A list of tasks that Amazon AppFlow performs while transferring the data in the flow run. </p>
        pub fn set_tasks(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Task>>,
        ) -> Self {
            self.inner = self.inner.set_tasks(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
