// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CreateConnectorProfileInput`](crate::input::CreateConnectorProfileInput)
pub mod create_connector_profile_input {
    /// A builder for [`CreateConnectorProfileInput`](crate::input::CreateConnectorProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connector_profile_name: std::option::Option<std::string::String>,
        pub(crate) kms_arn: std::option::Option<std::string::String>,
        pub(crate) connector_type: std::option::Option<crate::model::ConnectorType>,
        pub(crate) connection_mode: std::option::Option<crate::model::ConnectionMode>,
        pub(crate) connector_profile_config:
            std::option::Option<crate::model::ConnectorProfileConfig>,
    }
    impl Builder {
        /// <p> The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in your Amazon Web Services account. </p>
        pub fn connector_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.connector_profile_name = Some(input.into());
            self
        }
        /// <p> The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in your Amazon Web Services account. </p>
        pub fn set_connector_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connector_profile_name = input;
            self
        }
        /// <p> The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption. This is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key. </p>
        pub fn kms_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_arn = Some(input.into());
            self
        }
        /// <p> The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption. This is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key. </p>
        pub fn set_kms_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_arn = input;
            self
        }
        /// <p> The type of connector, such as Salesforce, Amplitude, and so on. </p>
        pub fn connector_type(mut self, input: crate::model::ConnectorType) -> Self {
            self.connector_type = Some(input);
            self
        }
        /// <p> The type of connector, such as Salesforce, Amplitude, and so on. </p>
        pub fn set_connector_type(
            mut self,
            input: std::option::Option<crate::model::ConnectorType>,
        ) -> Self {
            self.connector_type = input;
            self
        }
        /// <p> Indicates the connection mode and specifies whether it is public or private. Private flows use Amazon Web Services PrivateLink to route data over Amazon Web Services infrastructure without exposing it to the public internet. </p>
        pub fn connection_mode(mut self, input: crate::model::ConnectionMode) -> Self {
            self.connection_mode = Some(input);
            self
        }
        /// <p> Indicates the connection mode and specifies whether it is public or private. Private flows use Amazon Web Services PrivateLink to route data over Amazon Web Services infrastructure without exposing it to the public internet. </p>
        pub fn set_connection_mode(
            mut self,
            input: std::option::Option<crate::model::ConnectionMode>,
        ) -> Self {
            self.connection_mode = input;
            self
        }
        /// <p> Defines the connector-specific configuration and credentials. </p>
        pub fn connector_profile_config(
            mut self,
            input: crate::model::ConnectorProfileConfig,
        ) -> Self {
            self.connector_profile_config = Some(input);
            self
        }
        /// <p> Defines the connector-specific configuration and credentials. </p>
        pub fn set_connector_profile_config(
            mut self,
            input: std::option::Option<crate::model::ConnectorProfileConfig>,
        ) -> Self {
            self.connector_profile_config = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateConnectorProfileInput`](crate::input::CreateConnectorProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateConnectorProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateConnectorProfileInput {
                connector_profile_name: self.connector_profile_name,
                kms_arn: self.kms_arn,
                connector_type: self.connector_type,
                connection_mode: self.connection_mode,
                connector_profile_config: self.connector_profile_config,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateConnectorProfileInputOperationOutputAlias = crate::operation::CreateConnectorProfile;
#[doc(hidden)]
pub type CreateConnectorProfileInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateConnectorProfileInput {
    /// Consumes the builder and constructs an Operation<[`CreateConnectorProfile`](crate::operation::CreateConnectorProfile)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateConnectorProfile,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateConnectorProfileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/create-connector-profile").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateConnectorProfileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateConnectorProfileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_connector_profile(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateConnectorProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateConnectorProfile",
            "appflow",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateConnectorProfileInput`](crate::input::CreateConnectorProfileInput)
    pub fn builder() -> crate::input::create_connector_profile_input::Builder {
        crate::input::create_connector_profile_input::Builder::default()
    }
}

/// See [`CreateFlowInput`](crate::input::CreateFlowInput)
pub mod create_flow_input {
    /// A builder for [`CreateFlowInput`](crate::input::CreateFlowInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) flow_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) kms_arn: std::option::Option<std::string::String>,
        pub(crate) trigger_config: std::option::Option<crate::model::TriggerConfig>,
        pub(crate) source_flow_config: std::option::Option<crate::model::SourceFlowConfig>,
        pub(crate) destination_flow_config_list:
            std::option::Option<std::vec::Vec<crate::model::DestinationFlowConfig>>,
        pub(crate) tasks: std::option::Option<std::vec::Vec<crate::model::Task>>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only. </p>
        pub fn flow_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_name = Some(input.into());
            self
        }
        /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only. </p>
        pub fn set_flow_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.flow_name = input;
            self
        }
        /// <p> A description of the flow you want to create. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p> A description of the flow you want to create. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p> The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption. This is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key. </p>
        pub fn kms_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_arn = Some(input.into());
            self
        }
        /// <p> The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption. This is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key. </p>
        pub fn set_kms_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_arn = input;
            self
        }
        /// <p> The trigger settings that determine how and when the flow runs. </p>
        pub fn trigger_config(mut self, input: crate::model::TriggerConfig) -> Self {
            self.trigger_config = Some(input);
            self
        }
        /// <p> The trigger settings that determine how and when the flow runs. </p>
        pub fn set_trigger_config(
            mut self,
            input: std::option::Option<crate::model::TriggerConfig>,
        ) -> Self {
            self.trigger_config = input;
            self
        }
        /// <p> The configuration that controls how Amazon AppFlow retrieves data from the source connector. </p>
        pub fn source_flow_config(mut self, input: crate::model::SourceFlowConfig) -> Self {
            self.source_flow_config = Some(input);
            self
        }
        /// <p> The configuration that controls how Amazon AppFlow retrieves data from the source connector. </p>
        pub fn set_source_flow_config(
            mut self,
            input: std::option::Option<crate::model::SourceFlowConfig>,
        ) -> Self {
            self.source_flow_config = input;
            self
        }
        /// Appends an item to `destination_flow_config_list`.
        ///
        /// To override the contents of this collection use [`set_destination_flow_config_list`](Self::set_destination_flow_config_list).
        ///
        /// <p> The configuration that controls how Amazon AppFlow places data in the destination connector. </p>
        pub fn destination_flow_config_list(
            mut self,
            input: crate::model::DestinationFlowConfig,
        ) -> Self {
            let mut v = self.destination_flow_config_list.unwrap_or_default();
            v.push(input);
            self.destination_flow_config_list = Some(v);
            self
        }
        /// <p> The configuration that controls how Amazon AppFlow places data in the destination connector. </p>
        pub fn set_destination_flow_config_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DestinationFlowConfig>>,
        ) -> Self {
            self.destination_flow_config_list = input;
            self
        }
        /// Appends an item to `tasks`.
        ///
        /// To override the contents of this collection use [`set_tasks`](Self::set_tasks).
        ///
        /// <p> A list of tasks that Amazon AppFlow performs while transferring the data in the flow run. </p>
        pub fn tasks(mut self, input: crate::model::Task) -> Self {
            let mut v = self.tasks.unwrap_or_default();
            v.push(input);
            self.tasks = Some(v);
            self
        }
        /// <p> A list of tasks that Amazon AppFlow performs while transferring the data in the flow run. </p>
        pub fn set_tasks(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Task>>,
        ) -> Self {
            self.tasks = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> The tags used to organize, track, or control access for your flow. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p> The tags used to organize, track, or control access for your flow. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFlowInput`](crate::input::CreateFlowInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateFlowInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateFlowInput {
                flow_name: self.flow_name,
                description: self.description,
                kms_arn: self.kms_arn,
                trigger_config: self.trigger_config,
                source_flow_config: self.source_flow_config,
                destination_flow_config_list: self.destination_flow_config_list,
                tasks: self.tasks,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateFlowInputOperationOutputAlias = crate::operation::CreateFlow;
#[doc(hidden)]
pub type CreateFlowInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateFlowInput {
    /// Consumes the builder and constructs an Operation<[`CreateFlow`](crate::operation::CreateFlow)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateFlow,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateFlowInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/create-flow").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateFlowInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateFlowInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_flow(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateFlow::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateFlow",
            "appflow",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateFlowInput`](crate::input::CreateFlowInput)
    pub fn builder() -> crate::input::create_flow_input::Builder {
        crate::input::create_flow_input::Builder::default()
    }
}

/// See [`DeleteConnectorProfileInput`](crate::input::DeleteConnectorProfileInput)
pub mod delete_connector_profile_input {
    /// A builder for [`DeleteConnectorProfileInput`](crate::input::DeleteConnectorProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connector_profile_name: std::option::Option<std::string::String>,
        pub(crate) force_delete: std::option::Option<bool>,
    }
    impl Builder {
        /// <p> The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in your account. </p>
        pub fn connector_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.connector_profile_name = Some(input.into());
            self
        }
        /// <p> The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in your account. </p>
        pub fn set_connector_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connector_profile_name = input;
            self
        }
        /// <p> Indicates whether Amazon AppFlow should delete the profile, even if it is currently in use in one or more flows. </p>
        pub fn force_delete(mut self, input: bool) -> Self {
            self.force_delete = Some(input);
            self
        }
        /// <p> Indicates whether Amazon AppFlow should delete the profile, even if it is currently in use in one or more flows. </p>
        pub fn set_force_delete(mut self, input: std::option::Option<bool>) -> Self {
            self.force_delete = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteConnectorProfileInput`](crate::input::DeleteConnectorProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteConnectorProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteConnectorProfileInput {
                connector_profile_name: self.connector_profile_name,
                force_delete: self.force_delete.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteConnectorProfileInputOperationOutputAlias = crate::operation::DeleteConnectorProfile;
#[doc(hidden)]
pub type DeleteConnectorProfileInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteConnectorProfileInput {
    /// Consumes the builder and constructs an Operation<[`DeleteConnectorProfile`](crate::operation::DeleteConnectorProfile)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteConnectorProfile,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteConnectorProfileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/delete-connector-profile").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteConnectorProfileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteConnectorProfileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_connector_profile(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteConnectorProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteConnectorProfile",
            "appflow",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteConnectorProfileInput`](crate::input::DeleteConnectorProfileInput)
    pub fn builder() -> crate::input::delete_connector_profile_input::Builder {
        crate::input::delete_connector_profile_input::Builder::default()
    }
}

/// See [`DeleteFlowInput`](crate::input::DeleteFlowInput)
pub mod delete_flow_input {
    /// A builder for [`DeleteFlowInput`](crate::input::DeleteFlowInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) flow_name: std::option::Option<std::string::String>,
        pub(crate) force_delete: std::option::Option<bool>,
    }
    impl Builder {
        /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only. </p>
        pub fn flow_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_name = Some(input.into());
            self
        }
        /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only. </p>
        pub fn set_flow_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.flow_name = input;
            self
        }
        /// <p> Indicates whether Amazon AppFlow should delete the flow, even if it is currently in use. </p>
        pub fn force_delete(mut self, input: bool) -> Self {
            self.force_delete = Some(input);
            self
        }
        /// <p> Indicates whether Amazon AppFlow should delete the flow, even if it is currently in use. </p>
        pub fn set_force_delete(mut self, input: std::option::Option<bool>) -> Self {
            self.force_delete = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteFlowInput`](crate::input::DeleteFlowInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteFlowInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteFlowInput {
                flow_name: self.flow_name,
                force_delete: self.force_delete.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteFlowInputOperationOutputAlias = crate::operation::DeleteFlow;
#[doc(hidden)]
pub type DeleteFlowInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteFlowInput {
    /// Consumes the builder and constructs an Operation<[`DeleteFlow`](crate::operation::DeleteFlow)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteFlow,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteFlowInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/delete-flow").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteFlowInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteFlowInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_flow(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteFlow::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteFlow",
            "appflow",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteFlowInput`](crate::input::DeleteFlowInput)
    pub fn builder() -> crate::input::delete_flow_input::Builder {
        crate::input::delete_flow_input::Builder::default()
    }
}

/// See [`DescribeConnectorEntityInput`](crate::input::DescribeConnectorEntityInput)
pub mod describe_connector_entity_input {
    /// A builder for [`DescribeConnectorEntityInput`](crate::input::DescribeConnectorEntityInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connector_entity_name: std::option::Option<std::string::String>,
        pub(crate) connector_type: std::option::Option<crate::model::ConnectorType>,
        pub(crate) connector_profile_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The entity name for that connector. </p>
        pub fn connector_entity_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.connector_entity_name = Some(input.into());
            self
        }
        /// <p> The entity name for that connector. </p>
        pub fn set_connector_entity_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connector_entity_name = input;
            self
        }
        /// <p> The type of connector application, such as Salesforce, Amplitude, and so on. </p>
        pub fn connector_type(mut self, input: crate::model::ConnectorType) -> Self {
            self.connector_type = Some(input);
            self
        }
        /// <p> The type of connector application, such as Salesforce, Amplitude, and so on. </p>
        pub fn set_connector_type(
            mut self,
            input: std::option::Option<crate::model::ConnectorType>,
        ) -> Self {
            self.connector_type = input;
            self
        }
        /// <p> The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in the Amazon Web Services account. </p>
        pub fn connector_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.connector_profile_name = Some(input.into());
            self
        }
        /// <p> The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in the Amazon Web Services account. </p>
        pub fn set_connector_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connector_profile_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeConnectorEntityInput`](crate::input::DescribeConnectorEntityInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeConnectorEntityInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeConnectorEntityInput {
                connector_entity_name: self.connector_entity_name,
                connector_type: self.connector_type,
                connector_profile_name: self.connector_profile_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeConnectorEntityInputOperationOutputAlias =
    crate::operation::DescribeConnectorEntity;
#[doc(hidden)]
pub type DescribeConnectorEntityInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeConnectorEntityInput {
    /// Consumes the builder and constructs an Operation<[`DescribeConnectorEntity`](crate::operation::DescribeConnectorEntity)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeConnectorEntity,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeConnectorEntityInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/describe-connector-entity").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeConnectorEntityInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeConnectorEntityInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_connector_entity(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeConnectorEntity::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeConnectorEntity",
            "appflow",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeConnectorEntityInput`](crate::input::DescribeConnectorEntityInput)
    pub fn builder() -> crate::input::describe_connector_entity_input::Builder {
        crate::input::describe_connector_entity_input::Builder::default()
    }
}

/// See [`DescribeConnectorProfilesInput`](crate::input::DescribeConnectorProfilesInput)
pub mod describe_connector_profiles_input {
    /// A builder for [`DescribeConnectorProfilesInput`](crate::input::DescribeConnectorProfilesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connector_profile_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) connector_type: std::option::Option<crate::model::ConnectorType>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `connector_profile_names`.
        ///
        /// To override the contents of this collection use [`set_connector_profile_names`](Self::set_connector_profile_names).
        ///
        /// <p> The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in the Amazon Web Services account. </p>
        pub fn connector_profile_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.connector_profile_names.unwrap_or_default();
            v.push(input.into());
            self.connector_profile_names = Some(v);
            self
        }
        /// <p> The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in the Amazon Web Services account. </p>
        pub fn set_connector_profile_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.connector_profile_names = input;
            self
        }
        /// <p> The type of connector, such as Salesforce, Amplitude, and so on. </p>
        pub fn connector_type(mut self, input: crate::model::ConnectorType) -> Self {
            self.connector_type = Some(input);
            self
        }
        /// <p> The type of connector, such as Salesforce, Amplitude, and so on. </p>
        pub fn set_connector_type(
            mut self,
            input: std::option::Option<crate::model::ConnectorType>,
        ) -> Self {
            self.connector_type = input;
            self
        }
        /// <p> Specifies the maximum number of items that should be returned in the result set. The default for <code>maxResults</code> is 20 (for all paginated API operations). </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p> Specifies the maximum number of items that should be returned in the result set. The default for <code>maxResults</code> is 20 (for all paginated API operations). </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p> The pagination token for the next page of data. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> The pagination token for the next page of data. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeConnectorProfilesInput`](crate::input::DescribeConnectorProfilesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeConnectorProfilesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeConnectorProfilesInput {
                connector_profile_names: self.connector_profile_names,
                connector_type: self.connector_type,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeConnectorProfilesInputOperationOutputAlias =
    crate::operation::DescribeConnectorProfiles;
#[doc(hidden)]
pub type DescribeConnectorProfilesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeConnectorProfilesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeConnectorProfiles`](crate::operation::DescribeConnectorProfiles)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeConnectorProfiles,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeConnectorProfilesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/describe-connector-profiles").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeConnectorProfilesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeConnectorProfilesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_connector_profiles(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeConnectorProfiles::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeConnectorProfiles",
            "appflow",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeConnectorProfilesInput`](crate::input::DescribeConnectorProfilesInput)
    pub fn builder() -> crate::input::describe_connector_profiles_input::Builder {
        crate::input::describe_connector_profiles_input::Builder::default()
    }
}

/// See [`DescribeConnectorsInput`](crate::input::DescribeConnectorsInput)
pub mod describe_connectors_input {
    /// A builder for [`DescribeConnectorsInput`](crate::input::DescribeConnectorsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connector_types: std::option::Option<std::vec::Vec<crate::model::ConnectorType>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `connector_types`.
        ///
        /// To override the contents of this collection use [`set_connector_types`](Self::set_connector_types).
        ///
        /// <p> The type of connector, such as Salesforce, Amplitude, and so on. </p>
        pub fn connector_types(mut self, input: crate::model::ConnectorType) -> Self {
            let mut v = self.connector_types.unwrap_or_default();
            v.push(input);
            self.connector_types = Some(v);
            self
        }
        /// <p> The type of connector, such as Salesforce, Amplitude, and so on. </p>
        pub fn set_connector_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConnectorType>>,
        ) -> Self {
            self.connector_types = input;
            self
        }
        /// <p> The pagination token for the next page of data. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> The pagination token for the next page of data. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeConnectorsInput`](crate::input::DescribeConnectorsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeConnectorsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeConnectorsInput {
                connector_types: self.connector_types,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeConnectorsInputOperationOutputAlias = crate::operation::DescribeConnectors;
#[doc(hidden)]
pub type DescribeConnectorsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeConnectorsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeConnectors`](crate::operation::DescribeConnectors)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeConnectors,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeConnectorsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/describe-connectors").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeConnectorsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeConnectorsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_connectors(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeConnectors::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeConnectors",
            "appflow",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeConnectorsInput`](crate::input::DescribeConnectorsInput)
    pub fn builder() -> crate::input::describe_connectors_input::Builder {
        crate::input::describe_connectors_input::Builder::default()
    }
}

/// See [`DescribeFlowInput`](crate::input::DescribeFlowInput)
pub mod describe_flow_input {
    /// A builder for [`DescribeFlowInput`](crate::input::DescribeFlowInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) flow_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only. </p>
        pub fn flow_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_name = Some(input.into());
            self
        }
        /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only. </p>
        pub fn set_flow_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.flow_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFlowInput`](crate::input::DescribeFlowInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeFlowInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeFlowInput {
                flow_name: self.flow_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeFlowInputOperationOutputAlias = crate::operation::DescribeFlow;
#[doc(hidden)]
pub type DescribeFlowInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeFlowInput {
    /// Consumes the builder and constructs an Operation<[`DescribeFlow`](crate::operation::DescribeFlow)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeFlow,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeFlowInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/describe-flow").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeFlowInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeFlowInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_describe_flow(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeFlow::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeFlow",
            "appflow",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeFlowInput`](crate::input::DescribeFlowInput)
    pub fn builder() -> crate::input::describe_flow_input::Builder {
        crate::input::describe_flow_input::Builder::default()
    }
}

/// See [`DescribeFlowExecutionRecordsInput`](crate::input::DescribeFlowExecutionRecordsInput)
pub mod describe_flow_execution_records_input {
    /// A builder for [`DescribeFlowExecutionRecordsInput`](crate::input::DescribeFlowExecutionRecordsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) flow_name: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only. </p>
        pub fn flow_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_name = Some(input.into());
            self
        }
        /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only. </p>
        pub fn set_flow_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.flow_name = input;
            self
        }
        /// <p> Specifies the maximum number of items that should be returned in the result set. The default for <code>maxResults</code> is 20 (for all paginated API operations). </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p> Specifies the maximum number of items that should be returned in the result set. The default for <code>maxResults</code> is 20 (for all paginated API operations). </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p> The pagination token for the next page of data. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> The pagination token for the next page of data. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFlowExecutionRecordsInput`](crate::input::DescribeFlowExecutionRecordsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeFlowExecutionRecordsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeFlowExecutionRecordsInput {
                flow_name: self.flow_name,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeFlowExecutionRecordsInputOperationOutputAlias =
    crate::operation::DescribeFlowExecutionRecords;
#[doc(hidden)]
pub type DescribeFlowExecutionRecordsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeFlowExecutionRecordsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeFlowExecutionRecords`](crate::operation::DescribeFlowExecutionRecords)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeFlowExecutionRecords,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeFlowExecutionRecordsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/describe-flow-execution-records").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeFlowExecutionRecordsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeFlowExecutionRecordsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_flow_execution_records(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeFlowExecutionRecords::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeFlowExecutionRecords",
            "appflow",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeFlowExecutionRecordsInput`](crate::input::DescribeFlowExecutionRecordsInput)
    pub fn builder() -> crate::input::describe_flow_execution_records_input::Builder {
        crate::input::describe_flow_execution_records_input::Builder::default()
    }
}

/// See [`ListConnectorEntitiesInput`](crate::input::ListConnectorEntitiesInput)
pub mod list_connector_entities_input {
    /// A builder for [`ListConnectorEntitiesInput`](crate::input::ListConnectorEntitiesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connector_profile_name: std::option::Option<std::string::String>,
        pub(crate) connector_type: std::option::Option<crate::model::ConnectorType>,
        pub(crate) entities_path: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in the Amazon Web Services account, and is used to query the downstream connector. </p>
        pub fn connector_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.connector_profile_name = Some(input.into());
            self
        }
        /// <p> The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in the Amazon Web Services account, and is used to query the downstream connector. </p>
        pub fn set_connector_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connector_profile_name = input;
            self
        }
        /// <p> The type of connector, such as Salesforce, Amplitude, and so on. </p>
        pub fn connector_type(mut self, input: crate::model::ConnectorType) -> Self {
            self.connector_type = Some(input);
            self
        }
        /// <p> The type of connector, such as Salesforce, Amplitude, and so on. </p>
        pub fn set_connector_type(
            mut self,
            input: std::option::Option<crate::model::ConnectorType>,
        ) -> Self {
            self.connector_type = input;
            self
        }
        /// <p> This optional parameter is specific to connector implementation. Some connectors support multiple levels or categories of entities. You can find out the list of roots for such providers by sending a request without the <code>entitiesPath</code> parameter. If the connector supports entities at different roots, this initial request returns the list of roots. Otherwise, this request returns all entities supported by the provider. </p>
        pub fn entities_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.entities_path = Some(input.into());
            self
        }
        /// <p> This optional parameter is specific to connector implementation. Some connectors support multiple levels or categories of entities. You can find out the list of roots for such providers by sending a request without the <code>entitiesPath</code> parameter. If the connector supports entities at different roots, this initial request returns the list of roots. Otherwise, this request returns all entities supported by the provider. </p>
        pub fn set_entities_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.entities_path = input;
            self
        }
        /// Consumes the builder and constructs a [`ListConnectorEntitiesInput`](crate::input::ListConnectorEntitiesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListConnectorEntitiesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListConnectorEntitiesInput {
                connector_profile_name: self.connector_profile_name,
                connector_type: self.connector_type,
                entities_path: self.entities_path,
            })
        }
    }
}
#[doc(hidden)]
pub type ListConnectorEntitiesInputOperationOutputAlias = crate::operation::ListConnectorEntities;
#[doc(hidden)]
pub type ListConnectorEntitiesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListConnectorEntitiesInput {
    /// Consumes the builder and constructs an Operation<[`ListConnectorEntities`](crate::operation::ListConnectorEntities)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListConnectorEntities,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListConnectorEntitiesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/list-connector-entities").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListConnectorEntitiesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListConnectorEntitiesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_connector_entities(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListConnectorEntities::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListConnectorEntities",
            "appflow",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListConnectorEntitiesInput`](crate::input::ListConnectorEntitiesInput)
    pub fn builder() -> crate::input::list_connector_entities_input::Builder {
        crate::input::list_connector_entities_input::Builder::default()
    }
}

/// See [`ListFlowsInput`](crate::input::ListFlowsInput)
pub mod list_flows_input {
    /// A builder for [`ListFlowsInput`](crate::input::ListFlowsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> Specifies the maximum number of items that should be returned in the result set. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p> Specifies the maximum number of items that should be returned in the result set. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p> The pagination token for next page of data. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> The pagination token for next page of data. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFlowsInput`](crate::input::ListFlowsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListFlowsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListFlowsInput {
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListFlowsInputOperationOutputAlias = crate::operation::ListFlows;
#[doc(hidden)]
pub type ListFlowsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListFlowsInput {
    /// Consumes the builder and constructs an Operation<[`ListFlows`](crate::operation::ListFlows)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListFlows,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListFlowsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/list-flows").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListFlowsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListFlowsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_flows(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListFlows::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "ListFlows",
                    "appflow",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListFlowsInput`](crate::input::ListFlowsInput)
    pub fn builder() -> crate::input::list_flows_input::Builder {
        crate::input::list_flows_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The Amazon Resource Name (ARN) of the specified flow. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the specified flow. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.resource_arn;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_1, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "appflow",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`StartFlowInput`](crate::input::StartFlowInput)
pub mod start_flow_input {
    /// A builder for [`StartFlowInput`](crate::input::StartFlowInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) flow_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only. </p>
        pub fn flow_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_name = Some(input.into());
            self
        }
        /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only. </p>
        pub fn set_flow_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.flow_name = input;
            self
        }
        /// Consumes the builder and constructs a [`StartFlowInput`](crate::input::StartFlowInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::StartFlowInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::StartFlowInput {
                flow_name: self.flow_name,
            })
        }
    }
}
#[doc(hidden)]
pub type StartFlowInputOperationOutputAlias = crate::operation::StartFlow;
#[doc(hidden)]
pub type StartFlowInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartFlowInput {
    /// Consumes the builder and constructs an Operation<[`StartFlow`](crate::operation::StartFlow)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartFlow,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartFlowInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/start-flow").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartFlowInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartFlowInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_start_flow(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::StartFlow::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "StartFlow",
                    "appflow",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartFlowInput`](crate::input::StartFlowInput)
    pub fn builder() -> crate::input::start_flow_input::Builder {
        crate::input::start_flow_input::Builder::default()
    }
}

/// See [`StopFlowInput`](crate::input::StopFlowInput)
pub mod stop_flow_input {
    /// A builder for [`StopFlowInput`](crate::input::StopFlowInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) flow_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only. </p>
        pub fn flow_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_name = Some(input.into());
            self
        }
        /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only. </p>
        pub fn set_flow_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.flow_name = input;
            self
        }
        /// Consumes the builder and constructs a [`StopFlowInput`](crate::input::StopFlowInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::StopFlowInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::StopFlowInput {
                flow_name: self.flow_name,
            })
        }
    }
}
#[doc(hidden)]
pub type StopFlowInputOperationOutputAlias = crate::operation::StopFlow;
#[doc(hidden)]
pub type StopFlowInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StopFlowInput {
    /// Consumes the builder and constructs an Operation<[`StopFlow`](crate::operation::StopFlow)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopFlow,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StopFlowInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/stop-flow").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StopFlowInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StopFlowInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_stop_flow(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::StopFlow::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "StopFlow", "appflow",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StopFlowInput`](crate::input::StopFlowInput)
    pub fn builder() -> crate::input::stop_flow_input::Builder {
        crate::input::stop_flow_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p> The Amazon Resource Name (ARN) of the flow that you want to tag. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the flow that you want to tag. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> The tags used to organize, track, or control access for your flow. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p> The tags used to organize, track, or control access for your flow. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_2 = &_input.resource_arn;
            let input_2 =
                input_2
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_2, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "appflow",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p> The Amazon Resource Name (ARN) of the flow that you want to untag. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the flow that you want to untag. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p> The tag keys associated with the tag that you want to remove from your flow. </p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p> The tag keys associated with the tag that you want to remove from your flow. </p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_3 = &_input.resource_arn;
            let input_3 =
                input_3
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_3, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::UntagResourceInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_4) = &_input.tag_keys {
                for inner_5 in inner_4 {
                    query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_5));
                }
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "appflow",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateConnectorProfileInput`](crate::input::UpdateConnectorProfileInput)
pub mod update_connector_profile_input {
    /// A builder for [`UpdateConnectorProfileInput`](crate::input::UpdateConnectorProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connector_profile_name: std::option::Option<std::string::String>,
        pub(crate) connection_mode: std::option::Option<crate::model::ConnectionMode>,
        pub(crate) connector_profile_config:
            std::option::Option<crate::model::ConnectorProfileConfig>,
    }
    impl Builder {
        /// <p> The name of the connector profile and is unique for each <code>ConnectorProfile</code> in the Amazon Web Services account. </p>
        pub fn connector_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.connector_profile_name = Some(input.into());
            self
        }
        /// <p> The name of the connector profile and is unique for each <code>ConnectorProfile</code> in the Amazon Web Services account. </p>
        pub fn set_connector_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connector_profile_name = input;
            self
        }
        /// <p> Indicates the connection mode and if it is public or private. </p>
        pub fn connection_mode(mut self, input: crate::model::ConnectionMode) -> Self {
            self.connection_mode = Some(input);
            self
        }
        /// <p> Indicates the connection mode and if it is public or private. </p>
        pub fn set_connection_mode(
            mut self,
            input: std::option::Option<crate::model::ConnectionMode>,
        ) -> Self {
            self.connection_mode = input;
            self
        }
        /// <p> Defines the connector-specific profile configuration and credentials. </p>
        pub fn connector_profile_config(
            mut self,
            input: crate::model::ConnectorProfileConfig,
        ) -> Self {
            self.connector_profile_config = Some(input);
            self
        }
        /// <p> Defines the connector-specific profile configuration and credentials. </p>
        pub fn set_connector_profile_config(
            mut self,
            input: std::option::Option<crate::model::ConnectorProfileConfig>,
        ) -> Self {
            self.connector_profile_config = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateConnectorProfileInput`](crate::input::UpdateConnectorProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateConnectorProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateConnectorProfileInput {
                connector_profile_name: self.connector_profile_name,
                connection_mode: self.connection_mode,
                connector_profile_config: self.connector_profile_config,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateConnectorProfileInputOperationOutputAlias = crate::operation::UpdateConnectorProfile;
#[doc(hidden)]
pub type UpdateConnectorProfileInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateConnectorProfileInput {
    /// Consumes the builder and constructs an Operation<[`UpdateConnectorProfile`](crate::operation::UpdateConnectorProfile)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateConnectorProfile,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateConnectorProfileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/update-connector-profile").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateConnectorProfileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateConnectorProfileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_connector_profile(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateConnectorProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateConnectorProfile",
            "appflow",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateConnectorProfileInput`](crate::input::UpdateConnectorProfileInput)
    pub fn builder() -> crate::input::update_connector_profile_input::Builder {
        crate::input::update_connector_profile_input::Builder::default()
    }
}

/// See [`UpdateFlowInput`](crate::input::UpdateFlowInput)
pub mod update_flow_input {
    /// A builder for [`UpdateFlowInput`](crate::input::UpdateFlowInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) flow_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) trigger_config: std::option::Option<crate::model::TriggerConfig>,
        pub(crate) source_flow_config: std::option::Option<crate::model::SourceFlowConfig>,
        pub(crate) destination_flow_config_list:
            std::option::Option<std::vec::Vec<crate::model::DestinationFlowConfig>>,
        pub(crate) tasks: std::option::Option<std::vec::Vec<crate::model::Task>>,
    }
    impl Builder {
        /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only. </p>
        pub fn flow_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_name = Some(input.into());
            self
        }
        /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only. </p>
        pub fn set_flow_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.flow_name = input;
            self
        }
        /// <p> A description of the flow. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p> A description of the flow. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p> The trigger settings that determine how and when the flow runs. </p>
        pub fn trigger_config(mut self, input: crate::model::TriggerConfig) -> Self {
            self.trigger_config = Some(input);
            self
        }
        /// <p> The trigger settings that determine how and when the flow runs. </p>
        pub fn set_trigger_config(
            mut self,
            input: std::option::Option<crate::model::TriggerConfig>,
        ) -> Self {
            self.trigger_config = input;
            self
        }
        /// <p> Contains information about the configuration of the source connector used in the flow. </p>
        pub fn source_flow_config(mut self, input: crate::model::SourceFlowConfig) -> Self {
            self.source_flow_config = Some(input);
            self
        }
        /// <p> Contains information about the configuration of the source connector used in the flow. </p>
        pub fn set_source_flow_config(
            mut self,
            input: std::option::Option<crate::model::SourceFlowConfig>,
        ) -> Self {
            self.source_flow_config = input;
            self
        }
        /// Appends an item to `destination_flow_config_list`.
        ///
        /// To override the contents of this collection use [`set_destination_flow_config_list`](Self::set_destination_flow_config_list).
        ///
        /// <p> The configuration that controls how Amazon AppFlow transfers data to the destination connector. </p>
        pub fn destination_flow_config_list(
            mut self,
            input: crate::model::DestinationFlowConfig,
        ) -> Self {
            let mut v = self.destination_flow_config_list.unwrap_or_default();
            v.push(input);
            self.destination_flow_config_list = Some(v);
            self
        }
        /// <p> The configuration that controls how Amazon AppFlow transfers data to the destination connector. </p>
        pub fn set_destination_flow_config_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DestinationFlowConfig>>,
        ) -> Self {
            self.destination_flow_config_list = input;
            self
        }
        /// Appends an item to `tasks`.
        ///
        /// To override the contents of this collection use [`set_tasks`](Self::set_tasks).
        ///
        /// <p> A list of tasks that Amazon AppFlow performs while transferring the data in the flow run. </p>
        pub fn tasks(mut self, input: crate::model::Task) -> Self {
            let mut v = self.tasks.unwrap_or_default();
            v.push(input);
            self.tasks = Some(v);
            self
        }
        /// <p> A list of tasks that Amazon AppFlow performs while transferring the data in the flow run. </p>
        pub fn set_tasks(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Task>>,
        ) -> Self {
            self.tasks = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFlowInput`](crate::input::UpdateFlowInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateFlowInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateFlowInput {
                flow_name: self.flow_name,
                description: self.description,
                trigger_config: self.trigger_config,
                source_flow_config: self.source_flow_config,
                destination_flow_config_list: self.destination_flow_config_list,
                tasks: self.tasks,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateFlowInputOperationOutputAlias = crate::operation::UpdateFlow;
#[doc(hidden)]
pub type UpdateFlowInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateFlowInput {
    /// Consumes the builder and constructs an Operation<[`UpdateFlow`](crate::operation::UpdateFlow)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateFlow,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateFlowInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/update-flow").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateFlowInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateFlowInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_flow(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateFlow::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateFlow",
            "appflow",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateFlowInput`](crate::input::UpdateFlowInput)
    pub fn builder() -> crate::input::update_flow_input::Builder {
        crate::input::update_flow_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFlowInput {
    /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only. </p>
    pub flow_name: std::option::Option<std::string::String>,
    /// <p> A description of the flow. </p>
    pub description: std::option::Option<std::string::String>,
    /// <p> The trigger settings that determine how and when the flow runs. </p>
    pub trigger_config: std::option::Option<crate::model::TriggerConfig>,
    /// <p> Contains information about the configuration of the source connector used in the flow. </p>
    pub source_flow_config: std::option::Option<crate::model::SourceFlowConfig>,
    /// <p> The configuration that controls how Amazon AppFlow transfers data to the destination connector. </p>
    pub destination_flow_config_list:
        std::option::Option<std::vec::Vec<crate::model::DestinationFlowConfig>>,
    /// <p> A list of tasks that Amazon AppFlow performs while transferring the data in the flow run. </p>
    pub tasks: std::option::Option<std::vec::Vec<crate::model::Task>>,
}
impl UpdateFlowInput {
    /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only. </p>
    pub fn flow_name(&self) -> std::option::Option<&str> {
        self.flow_name.as_deref()
    }
    /// <p> A description of the flow. </p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p> The trigger settings that determine how and when the flow runs. </p>
    pub fn trigger_config(&self) -> std::option::Option<&crate::model::TriggerConfig> {
        self.trigger_config.as_ref()
    }
    /// <p> Contains information about the configuration of the source connector used in the flow. </p>
    pub fn source_flow_config(&self) -> std::option::Option<&crate::model::SourceFlowConfig> {
        self.source_flow_config.as_ref()
    }
    /// <p> The configuration that controls how Amazon AppFlow transfers data to the destination connector. </p>
    pub fn destination_flow_config_list(
        &self,
    ) -> std::option::Option<&[crate::model::DestinationFlowConfig]> {
        self.destination_flow_config_list.as_deref()
    }
    /// <p> A list of tasks that Amazon AppFlow performs while transferring the data in the flow run. </p>
    pub fn tasks(&self) -> std::option::Option<&[crate::model::Task]> {
        self.tasks.as_deref()
    }
}
impl std::fmt::Debug for UpdateFlowInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFlowInput");
        formatter.field("flow_name", &self.flow_name);
        formatter.field("description", &self.description);
        formatter.field("trigger_config", &self.trigger_config);
        formatter.field("source_flow_config", &self.source_flow_config);
        formatter.field(
            "destination_flow_config_list",
            &self.destination_flow_config_list,
        );
        formatter.field("tasks", &self.tasks);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateConnectorProfileInput {
    /// <p> The name of the connector profile and is unique for each <code>ConnectorProfile</code> in the Amazon Web Services account. </p>
    pub connector_profile_name: std::option::Option<std::string::String>,
    /// <p> Indicates the connection mode and if it is public or private. </p>
    pub connection_mode: std::option::Option<crate::model::ConnectionMode>,
    /// <p> Defines the connector-specific profile configuration and credentials. </p>
    pub connector_profile_config: std::option::Option<crate::model::ConnectorProfileConfig>,
}
impl UpdateConnectorProfileInput {
    /// <p> The name of the connector profile and is unique for each <code>ConnectorProfile</code> in the Amazon Web Services account. </p>
    pub fn connector_profile_name(&self) -> std::option::Option<&str> {
        self.connector_profile_name.as_deref()
    }
    /// <p> Indicates the connection mode and if it is public or private. </p>
    pub fn connection_mode(&self) -> std::option::Option<&crate::model::ConnectionMode> {
        self.connection_mode.as_ref()
    }
    /// <p> Defines the connector-specific profile configuration and credentials. </p>
    pub fn connector_profile_config(
        &self,
    ) -> std::option::Option<&crate::model::ConnectorProfileConfig> {
        self.connector_profile_config.as_ref()
    }
}
impl std::fmt::Debug for UpdateConnectorProfileInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateConnectorProfileInput");
        formatter.field("connector_profile_name", &self.connector_profile_name);
        formatter.field("connection_mode", &self.connection_mode);
        formatter.field("connector_profile_config", &self.connector_profile_config);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p> The Amazon Resource Name (ARN) of the flow that you want to untag. </p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p> The tag keys associated with the tag that you want to remove from your flow. </p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p> The Amazon Resource Name (ARN) of the flow that you want to untag. </p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p> The tag keys associated with the tag that you want to remove from your flow. </p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p> The Amazon Resource Name (ARN) of the flow that you want to tag. </p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p> The tags used to organize, track, or control access for your flow. </p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl TagResourceInput {
    /// <p> The Amazon Resource Name (ARN) of the flow that you want to tag. </p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p> The tags used to organize, track, or control access for your flow. </p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopFlowInput {
    /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only. </p>
    pub flow_name: std::option::Option<std::string::String>,
}
impl StopFlowInput {
    /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only. </p>
    pub fn flow_name(&self) -> std::option::Option<&str> {
        self.flow_name.as_deref()
    }
}
impl std::fmt::Debug for StopFlowInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopFlowInput");
        formatter.field("flow_name", &self.flow_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartFlowInput {
    /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only. </p>
    pub flow_name: std::option::Option<std::string::String>,
}
impl StartFlowInput {
    /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only. </p>
    pub fn flow_name(&self) -> std::option::Option<&str> {
        self.flow_name.as_deref()
    }
}
impl std::fmt::Debug for StartFlowInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartFlowInput");
        formatter.field("flow_name", &self.flow_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p> The Amazon Resource Name (ARN) of the specified flow. </p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p> The Amazon Resource Name (ARN) of the specified flow. </p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFlowsInput {
    /// <p> Specifies the maximum number of items that should be returned in the result set. </p>
    pub max_results: std::option::Option<i32>,
    /// <p> The pagination token for next page of data. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListFlowsInput {
    /// <p> Specifies the maximum number of items that should be returned in the result set. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p> The pagination token for next page of data. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListFlowsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFlowsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListConnectorEntitiesInput {
    /// <p> The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in the Amazon Web Services account, and is used to query the downstream connector. </p>
    pub connector_profile_name: std::option::Option<std::string::String>,
    /// <p> The type of connector, such as Salesforce, Amplitude, and so on. </p>
    pub connector_type: std::option::Option<crate::model::ConnectorType>,
    /// <p> This optional parameter is specific to connector implementation. Some connectors support multiple levels or categories of entities. You can find out the list of roots for such providers by sending a request without the <code>entitiesPath</code> parameter. If the connector supports entities at different roots, this initial request returns the list of roots. Otherwise, this request returns all entities supported by the provider. </p>
    pub entities_path: std::option::Option<std::string::String>,
}
impl ListConnectorEntitiesInput {
    /// <p> The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in the Amazon Web Services account, and is used to query the downstream connector. </p>
    pub fn connector_profile_name(&self) -> std::option::Option<&str> {
        self.connector_profile_name.as_deref()
    }
    /// <p> The type of connector, such as Salesforce, Amplitude, and so on. </p>
    pub fn connector_type(&self) -> std::option::Option<&crate::model::ConnectorType> {
        self.connector_type.as_ref()
    }
    /// <p> This optional parameter is specific to connector implementation. Some connectors support multiple levels or categories of entities. You can find out the list of roots for such providers by sending a request without the <code>entitiesPath</code> parameter. If the connector supports entities at different roots, this initial request returns the list of roots. Otherwise, this request returns all entities supported by the provider. </p>
    pub fn entities_path(&self) -> std::option::Option<&str> {
        self.entities_path.as_deref()
    }
}
impl std::fmt::Debug for ListConnectorEntitiesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListConnectorEntitiesInput");
        formatter.field("connector_profile_name", &self.connector_profile_name);
        formatter.field("connector_type", &self.connector_type);
        formatter.field("entities_path", &self.entities_path);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeFlowExecutionRecordsInput {
    /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only. </p>
    pub flow_name: std::option::Option<std::string::String>,
    /// <p> Specifies the maximum number of items that should be returned in the result set. The default for <code>maxResults</code> is 20 (for all paginated API operations). </p>
    pub max_results: std::option::Option<i32>,
    /// <p> The pagination token for the next page of data. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeFlowExecutionRecordsInput {
    /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only. </p>
    pub fn flow_name(&self) -> std::option::Option<&str> {
        self.flow_name.as_deref()
    }
    /// <p> Specifies the maximum number of items that should be returned in the result set. The default for <code>maxResults</code> is 20 (for all paginated API operations). </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p> The pagination token for the next page of data. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeFlowExecutionRecordsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeFlowExecutionRecordsInput");
        formatter.field("flow_name", &self.flow_name);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeFlowInput {
    /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only. </p>
    pub flow_name: std::option::Option<std::string::String>,
}
impl DescribeFlowInput {
    /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only. </p>
    pub fn flow_name(&self) -> std::option::Option<&str> {
        self.flow_name.as_deref()
    }
}
impl std::fmt::Debug for DescribeFlowInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeFlowInput");
        formatter.field("flow_name", &self.flow_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeConnectorsInput {
    /// <p> The type of connector, such as Salesforce, Amplitude, and so on. </p>
    pub connector_types: std::option::Option<std::vec::Vec<crate::model::ConnectorType>>,
    /// <p> The pagination token for the next page of data. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeConnectorsInput {
    /// <p> The type of connector, such as Salesforce, Amplitude, and so on. </p>
    pub fn connector_types(&self) -> std::option::Option<&[crate::model::ConnectorType]> {
        self.connector_types.as_deref()
    }
    /// <p> The pagination token for the next page of data. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeConnectorsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeConnectorsInput");
        formatter.field("connector_types", &self.connector_types);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeConnectorProfilesInput {
    /// <p> The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in the Amazon Web Services account. </p>
    pub connector_profile_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> The type of connector, such as Salesforce, Amplitude, and so on. </p>
    pub connector_type: std::option::Option<crate::model::ConnectorType>,
    /// <p> Specifies the maximum number of items that should be returned in the result set. The default for <code>maxResults</code> is 20 (for all paginated API operations). </p>
    pub max_results: std::option::Option<i32>,
    /// <p> The pagination token for the next page of data. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeConnectorProfilesInput {
    /// <p> The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in the Amazon Web Services account. </p>
    pub fn connector_profile_names(&self) -> std::option::Option<&[std::string::String]> {
        self.connector_profile_names.as_deref()
    }
    /// <p> The type of connector, such as Salesforce, Amplitude, and so on. </p>
    pub fn connector_type(&self) -> std::option::Option<&crate::model::ConnectorType> {
        self.connector_type.as_ref()
    }
    /// <p> Specifies the maximum number of items that should be returned in the result set. The default for <code>maxResults</code> is 20 (for all paginated API operations). </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p> The pagination token for the next page of data. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeConnectorProfilesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeConnectorProfilesInput");
        formatter.field("connector_profile_names", &self.connector_profile_names);
        formatter.field("connector_type", &self.connector_type);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeConnectorEntityInput {
    /// <p> The entity name for that connector. </p>
    pub connector_entity_name: std::option::Option<std::string::String>,
    /// <p> The type of connector application, such as Salesforce, Amplitude, and so on. </p>
    pub connector_type: std::option::Option<crate::model::ConnectorType>,
    /// <p> The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in the Amazon Web Services account. </p>
    pub connector_profile_name: std::option::Option<std::string::String>,
}
impl DescribeConnectorEntityInput {
    /// <p> The entity name for that connector. </p>
    pub fn connector_entity_name(&self) -> std::option::Option<&str> {
        self.connector_entity_name.as_deref()
    }
    /// <p> The type of connector application, such as Salesforce, Amplitude, and so on. </p>
    pub fn connector_type(&self) -> std::option::Option<&crate::model::ConnectorType> {
        self.connector_type.as_ref()
    }
    /// <p> The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in the Amazon Web Services account. </p>
    pub fn connector_profile_name(&self) -> std::option::Option<&str> {
        self.connector_profile_name.as_deref()
    }
}
impl std::fmt::Debug for DescribeConnectorEntityInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeConnectorEntityInput");
        formatter.field("connector_entity_name", &self.connector_entity_name);
        formatter.field("connector_type", &self.connector_type);
        formatter.field("connector_profile_name", &self.connector_profile_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFlowInput {
    /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only. </p>
    pub flow_name: std::option::Option<std::string::String>,
    /// <p> Indicates whether Amazon AppFlow should delete the flow, even if it is currently in use. </p>
    pub force_delete: bool,
}
impl DeleteFlowInput {
    /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only. </p>
    pub fn flow_name(&self) -> std::option::Option<&str> {
        self.flow_name.as_deref()
    }
    /// <p> Indicates whether Amazon AppFlow should delete the flow, even if it is currently in use. </p>
    pub fn force_delete(&self) -> bool {
        self.force_delete
    }
}
impl std::fmt::Debug for DeleteFlowInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFlowInput");
        formatter.field("flow_name", &self.flow_name);
        formatter.field("force_delete", &self.force_delete);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteConnectorProfileInput {
    /// <p> The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in your account. </p>
    pub connector_profile_name: std::option::Option<std::string::String>,
    /// <p> Indicates whether Amazon AppFlow should delete the profile, even if it is currently in use in one or more flows. </p>
    pub force_delete: bool,
}
impl DeleteConnectorProfileInput {
    /// <p> The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in your account. </p>
    pub fn connector_profile_name(&self) -> std::option::Option<&str> {
        self.connector_profile_name.as_deref()
    }
    /// <p> Indicates whether Amazon AppFlow should delete the profile, even if it is currently in use in one or more flows. </p>
    pub fn force_delete(&self) -> bool {
        self.force_delete
    }
}
impl std::fmt::Debug for DeleteConnectorProfileInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteConnectorProfileInput");
        formatter.field("connector_profile_name", &self.connector_profile_name);
        formatter.field("force_delete", &self.force_delete);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFlowInput {
    /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only. </p>
    pub flow_name: std::option::Option<std::string::String>,
    /// <p> A description of the flow you want to create. </p>
    pub description: std::option::Option<std::string::String>,
    /// <p> The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption. This is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key. </p>
    pub kms_arn: std::option::Option<std::string::String>,
    /// <p> The trigger settings that determine how and when the flow runs. </p>
    pub trigger_config: std::option::Option<crate::model::TriggerConfig>,
    /// <p> The configuration that controls how Amazon AppFlow retrieves data from the source connector. </p>
    pub source_flow_config: std::option::Option<crate::model::SourceFlowConfig>,
    /// <p> The configuration that controls how Amazon AppFlow places data in the destination connector. </p>
    pub destination_flow_config_list:
        std::option::Option<std::vec::Vec<crate::model::DestinationFlowConfig>>,
    /// <p> A list of tasks that Amazon AppFlow performs while transferring the data in the flow run. </p>
    pub tasks: std::option::Option<std::vec::Vec<crate::model::Task>>,
    /// <p> The tags used to organize, track, or control access for your flow. </p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateFlowInput {
    /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only. </p>
    pub fn flow_name(&self) -> std::option::Option<&str> {
        self.flow_name.as_deref()
    }
    /// <p> A description of the flow you want to create. </p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p> The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption. This is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key. </p>
    pub fn kms_arn(&self) -> std::option::Option<&str> {
        self.kms_arn.as_deref()
    }
    /// <p> The trigger settings that determine how and when the flow runs. </p>
    pub fn trigger_config(&self) -> std::option::Option<&crate::model::TriggerConfig> {
        self.trigger_config.as_ref()
    }
    /// <p> The configuration that controls how Amazon AppFlow retrieves data from the source connector. </p>
    pub fn source_flow_config(&self) -> std::option::Option<&crate::model::SourceFlowConfig> {
        self.source_flow_config.as_ref()
    }
    /// <p> The configuration that controls how Amazon AppFlow places data in the destination connector. </p>
    pub fn destination_flow_config_list(
        &self,
    ) -> std::option::Option<&[crate::model::DestinationFlowConfig]> {
        self.destination_flow_config_list.as_deref()
    }
    /// <p> A list of tasks that Amazon AppFlow performs while transferring the data in the flow run. </p>
    pub fn tasks(&self) -> std::option::Option<&[crate::model::Task]> {
        self.tasks.as_deref()
    }
    /// <p> The tags used to organize, track, or control access for your flow. </p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateFlowInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFlowInput");
        formatter.field("flow_name", &self.flow_name);
        formatter.field("description", &self.description);
        formatter.field("kms_arn", &self.kms_arn);
        formatter.field("trigger_config", &self.trigger_config);
        formatter.field("source_flow_config", &self.source_flow_config);
        formatter.field(
            "destination_flow_config_list",
            &self.destination_flow_config_list,
        );
        formatter.field("tasks", &self.tasks);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateConnectorProfileInput {
    /// <p> The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in your Amazon Web Services account. </p>
    pub connector_profile_name: std::option::Option<std::string::String>,
    /// <p> The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption. This is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key. </p>
    pub kms_arn: std::option::Option<std::string::String>,
    /// <p> The type of connector, such as Salesforce, Amplitude, and so on. </p>
    pub connector_type: std::option::Option<crate::model::ConnectorType>,
    /// <p> Indicates the connection mode and specifies whether it is public or private. Private flows use Amazon Web Services PrivateLink to route data over Amazon Web Services infrastructure without exposing it to the public internet. </p>
    pub connection_mode: std::option::Option<crate::model::ConnectionMode>,
    /// <p> Defines the connector-specific configuration and credentials. </p>
    pub connector_profile_config: std::option::Option<crate::model::ConnectorProfileConfig>,
}
impl CreateConnectorProfileInput {
    /// <p> The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in your Amazon Web Services account. </p>
    pub fn connector_profile_name(&self) -> std::option::Option<&str> {
        self.connector_profile_name.as_deref()
    }
    /// <p> The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption. This is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key. </p>
    pub fn kms_arn(&self) -> std::option::Option<&str> {
        self.kms_arn.as_deref()
    }
    /// <p> The type of connector, such as Salesforce, Amplitude, and so on. </p>
    pub fn connector_type(&self) -> std::option::Option<&crate::model::ConnectorType> {
        self.connector_type.as_ref()
    }
    /// <p> Indicates the connection mode and specifies whether it is public or private. Private flows use Amazon Web Services PrivateLink to route data over Amazon Web Services infrastructure without exposing it to the public internet. </p>
    pub fn connection_mode(&self) -> std::option::Option<&crate::model::ConnectionMode> {
        self.connection_mode.as_ref()
    }
    /// <p> Defines the connector-specific configuration and credentials. </p>
    pub fn connector_profile_config(
        &self,
    ) -> std::option::Option<&crate::model::ConnectorProfileConfig> {
        self.connector_profile_config.as_ref()
    }
}
impl std::fmt::Debug for CreateConnectorProfileInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateConnectorProfileInput");
        formatter.field("connector_profile_name", &self.connector_profile_name);
        formatter.field("kms_arn", &self.kms_arn);
        formatter.field("connector_type", &self.connector_type);
        formatter.field("connection_mode", &self.connection_mode);
        formatter.field("connector_profile_config", &self.connector_profile_config);
        formatter.finish()
    }
}
