// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CreateConnectorProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateConnectorProfileError {
    /// Kind of error that occurred.
    pub kind: CreateConnectorProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateConnectorProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateConnectorProfileErrorKind {
    /// <p> There was a conflict when processing the request (for example, a flow with the given name already exists within the account. Check for conflicting resource names and try again. </p>
    ConflictException(crate::error::ConflictException),
    /// <p> An error occurred when authenticating with the connector endpoint. </p>
    ConnectorAuthenticationException(crate::error::ConnectorAuthenticationException),
    /// <p> An internal service error occurred during the processing of your request. Try again later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The request would cause a service quota (such as the number of flows) to be exceeded. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateConnectorProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateConnectorProfileErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateConnectorProfileErrorKind::ConnectorAuthenticationException(_inner) => {
                _inner.fmt(f)
            }
            CreateConnectorProfileErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateConnectorProfileErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateConnectorProfileErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateConnectorProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateConnectorProfileError {
    fn code(&self) -> Option<&str> {
        CreateConnectorProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateConnectorProfileError {
    /// Creates a new `CreateConnectorProfileError`.
    pub fn new(kind: CreateConnectorProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateConnectorProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateConnectorProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateConnectorProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateConnectorProfileErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateConnectorProfileErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConnectorProfileErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateConnectorProfileErrorKind::ConnectorAuthenticationException`.
    pub fn is_connector_authentication_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConnectorProfileErrorKind::ConnectorAuthenticationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateConnectorProfileErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConnectorProfileErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateConnectorProfileErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConnectorProfileErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateConnectorProfileErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConnectorProfileErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateConnectorProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateConnectorProfileErrorKind::ConflictException(_inner) => Some(_inner),
            CreateConnectorProfileErrorKind::ConnectorAuthenticationException(_inner) => {
                Some(_inner)
            }
            CreateConnectorProfileErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateConnectorProfileErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateConnectorProfileErrorKind::ValidationException(_inner) => Some(_inner),
            CreateConnectorProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateFlow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateFlowError {
    /// Kind of error that occurred.
    pub kind: CreateFlowErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateFlow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateFlowErrorKind {
    /// <p> There was a conflict when processing the request (for example, a flow with the given name already exists within the account. Check for conflicting resource names and try again. </p>
    ConflictException(crate::error::ConflictException),
    /// <p> An error occurred when authenticating with the connector endpoint. </p>
    ConnectorAuthenticationException(crate::error::ConnectorAuthenticationException),
    /// <p> An error occurred when retrieving data from the connector endpoint. </p>
    ConnectorServerException(crate::error::ConnectorServerException),
    /// <p> An internal service error occurred during the processing of your request. Try again later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The resource specified in the request (such as the source or destination connector profile) is not found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request would cause a service quota (such as the number of flows) to be exceeded. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateFlowError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateFlowErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateFlowErrorKind::ConnectorAuthenticationException(_inner) => _inner.fmt(f),
            CreateFlowErrorKind::ConnectorServerException(_inner) => _inner.fmt(f),
            CreateFlowErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateFlowErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateFlowErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateFlowErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateFlowErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateFlowError {
    fn code(&self) -> Option<&str> {
        CreateFlowError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateFlowError {
    /// Creates a new `CreateFlowError`.
    pub fn new(kind: CreateFlowErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateFlowError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateFlowErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateFlowError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateFlowErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateFlowErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateFlowErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateFlowErrorKind::ConnectorAuthenticationException`.
    pub fn is_connector_authentication_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFlowErrorKind::ConnectorAuthenticationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFlowErrorKind::ConnectorServerException`.
    pub fn is_connector_server_exception(&self) -> bool {
        matches!(&self.kind, CreateFlowErrorKind::ConnectorServerException(_))
    }
    /// Returns `true` if the error kind is `CreateFlowErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, CreateFlowErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `CreateFlowErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFlowErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFlowErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFlowErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFlowErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateFlowErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateFlowError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateFlowErrorKind::ConflictException(_inner) => Some(_inner),
            CreateFlowErrorKind::ConnectorAuthenticationException(_inner) => Some(_inner),
            CreateFlowErrorKind::ConnectorServerException(_inner) => Some(_inner),
            CreateFlowErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateFlowErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateFlowErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateFlowErrorKind::ValidationException(_inner) => Some(_inner),
            CreateFlowErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteConnectorProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteConnectorProfileError {
    /// Kind of error that occurred.
    pub kind: DeleteConnectorProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteConnectorProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteConnectorProfileErrorKind {
    /// <p> There was a conflict when processing the request (for example, a flow with the given name already exists within the account. Check for conflicting resource names and try again. </p>
    ConflictException(crate::error::ConflictException),
    /// <p> An internal service error occurred during the processing of your request. Try again later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The resource specified in the request (such as the source or destination connector profile) is not found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteConnectorProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteConnectorProfileErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteConnectorProfileErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteConnectorProfileErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteConnectorProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteConnectorProfileError {
    fn code(&self) -> Option<&str> {
        DeleteConnectorProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteConnectorProfileError {
    /// Creates a new `DeleteConnectorProfileError`.
    pub fn new(kind: DeleteConnectorProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteConnectorProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteConnectorProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteConnectorProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteConnectorProfileErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteConnectorProfileErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConnectorProfileErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteConnectorProfileErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConnectorProfileErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteConnectorProfileErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConnectorProfileErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteConnectorProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteConnectorProfileErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteConnectorProfileErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteConnectorProfileErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteConnectorProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteFlow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteFlowError {
    /// Kind of error that occurred.
    pub kind: DeleteFlowErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteFlow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteFlowErrorKind {
    /// <p> There was a conflict when processing the request (for example, a flow with the given name already exists within the account. Check for conflicting resource names and try again. </p>
    ConflictException(crate::error::ConflictException),
    /// <p> An internal service error occurred during the processing of your request. Try again later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The resource specified in the request (such as the source or destination connector profile) is not found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteFlowError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteFlowErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteFlowErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteFlowErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteFlowErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteFlowError {
    fn code(&self) -> Option<&str> {
        DeleteFlowError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteFlowError {
    /// Creates a new `DeleteFlowError`.
    pub fn new(kind: DeleteFlowErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteFlowError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteFlowErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteFlowError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteFlowErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteFlowErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteFlowErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteFlowErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, DeleteFlowErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `DeleteFlowErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFlowErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteFlowError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteFlowErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteFlowErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteFlowErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteFlowErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeConnectorEntity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeConnectorEntityError {
    /// Kind of error that occurred.
    pub kind: DescribeConnectorEntityErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeConnectorEntity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeConnectorEntityErrorKind {
    /// <p> An error occurred when authenticating with the connector endpoint. </p>
    ConnectorAuthenticationException(crate::error::ConnectorAuthenticationException),
    /// <p> An error occurred when retrieving data from the connector endpoint. </p>
    ConnectorServerException(crate::error::ConnectorServerException),
    /// <p> An internal service error occurred during the processing of your request. Try again later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The resource specified in the request (such as the source or destination connector profile) is not found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeConnectorEntityError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeConnectorEntityErrorKind::ConnectorAuthenticationException(_inner) => {
                _inner.fmt(f)
            }
            DescribeConnectorEntityErrorKind::ConnectorServerException(_inner) => _inner.fmt(f),
            DescribeConnectorEntityErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeConnectorEntityErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeConnectorEntityErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeConnectorEntityErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeConnectorEntityError {
    fn code(&self) -> Option<&str> {
        DescribeConnectorEntityError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeConnectorEntityError {
    /// Creates a new `DescribeConnectorEntityError`.
    pub fn new(kind: DescribeConnectorEntityErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeConnectorEntityError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeConnectorEntityErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeConnectorEntityError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeConnectorEntityErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeConnectorEntityErrorKind::ConnectorAuthenticationException`.
    pub fn is_connector_authentication_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConnectorEntityErrorKind::ConnectorAuthenticationException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeConnectorEntityErrorKind::ConnectorServerException`.
    pub fn is_connector_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConnectorEntityErrorKind::ConnectorServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeConnectorEntityErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConnectorEntityErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeConnectorEntityErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConnectorEntityErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeConnectorEntityErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConnectorEntityErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeConnectorEntityError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeConnectorEntityErrorKind::ConnectorAuthenticationException(_inner) => {
                Some(_inner)
            }
            DescribeConnectorEntityErrorKind::ConnectorServerException(_inner) => Some(_inner),
            DescribeConnectorEntityErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeConnectorEntityErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeConnectorEntityErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeConnectorEntityErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeConnectorProfiles` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeConnectorProfilesError {
    /// Kind of error that occurred.
    pub kind: DescribeConnectorProfilesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeConnectorProfiles` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeConnectorProfilesErrorKind {
    /// <p> An internal service error occurred during the processing of your request. Try again later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeConnectorProfilesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeConnectorProfilesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeConnectorProfilesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeConnectorProfilesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeConnectorProfilesError {
    fn code(&self) -> Option<&str> {
        DescribeConnectorProfilesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeConnectorProfilesError {
    /// Creates a new `DescribeConnectorProfilesError`.
    pub fn new(kind: DescribeConnectorProfilesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeConnectorProfilesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeConnectorProfilesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeConnectorProfilesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeConnectorProfilesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeConnectorProfilesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConnectorProfilesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeConnectorProfilesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConnectorProfilesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeConnectorProfilesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeConnectorProfilesErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeConnectorProfilesErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeConnectorProfilesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeConnectors` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeConnectorsError {
    /// Kind of error that occurred.
    pub kind: DescribeConnectorsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeConnectors` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeConnectorsErrorKind {
    /// <p> An internal service error occurred during the processing of your request. Try again later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeConnectorsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeConnectorsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeConnectorsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeConnectorsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeConnectorsError {
    fn code(&self) -> Option<&str> {
        DescribeConnectorsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeConnectorsError {
    /// Creates a new `DescribeConnectorsError`.
    pub fn new(kind: DescribeConnectorsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeConnectorsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeConnectorsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeConnectorsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeConnectorsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeConnectorsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConnectorsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeConnectorsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConnectorsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeConnectorsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeConnectorsErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeConnectorsErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeConnectorsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeFlow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeFlowError {
    /// Kind of error that occurred.
    pub kind: DescribeFlowErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeFlow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeFlowErrorKind {
    /// <p> An internal service error occurred during the processing of your request. Try again later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The resource specified in the request (such as the source or destination connector profile) is not found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeFlowError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeFlowErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeFlowErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeFlowErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeFlowError {
    fn code(&self) -> Option<&str> {
        DescribeFlowError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeFlowError {
    /// Creates a new `DescribeFlowError`.
    pub fn new(kind: DescribeFlowErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeFlowError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeFlowErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeFlowError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeFlowErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeFlowErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFlowErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFlowErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFlowErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeFlowError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeFlowErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeFlowErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeFlowErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeFlowExecutionRecords` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeFlowExecutionRecordsError {
    /// Kind of error that occurred.
    pub kind: DescribeFlowExecutionRecordsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeFlowExecutionRecords` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeFlowExecutionRecordsErrorKind {
    /// <p> An internal service error occurred during the processing of your request. Try again later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The resource specified in the request (such as the source or destination connector profile) is not found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeFlowExecutionRecordsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeFlowExecutionRecordsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeFlowExecutionRecordsErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeFlowExecutionRecordsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeFlowExecutionRecordsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeFlowExecutionRecordsError {
    fn code(&self) -> Option<&str> {
        DescribeFlowExecutionRecordsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeFlowExecutionRecordsError {
    /// Creates a new `DescribeFlowExecutionRecordsError`.
    pub fn new(kind: DescribeFlowExecutionRecordsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeFlowExecutionRecordsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeFlowExecutionRecordsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeFlowExecutionRecordsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeFlowExecutionRecordsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeFlowExecutionRecordsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFlowExecutionRecordsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFlowExecutionRecordsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFlowExecutionRecordsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFlowExecutionRecordsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFlowExecutionRecordsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeFlowExecutionRecordsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeFlowExecutionRecordsErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeFlowExecutionRecordsErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeFlowExecutionRecordsErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeFlowExecutionRecordsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListConnectorEntities` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListConnectorEntitiesError {
    /// Kind of error that occurred.
    pub kind: ListConnectorEntitiesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListConnectorEntities` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListConnectorEntitiesErrorKind {
    /// <p> An error occurred when authenticating with the connector endpoint. </p>
    ConnectorAuthenticationException(crate::error::ConnectorAuthenticationException),
    /// <p> An error occurred when retrieving data from the connector endpoint. </p>
    ConnectorServerException(crate::error::ConnectorServerException),
    /// <p> An internal service error occurred during the processing of your request. Try again later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The resource specified in the request (such as the source or destination connector profile) is not found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListConnectorEntitiesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListConnectorEntitiesErrorKind::ConnectorAuthenticationException(_inner) => {
                _inner.fmt(f)
            }
            ListConnectorEntitiesErrorKind::ConnectorServerException(_inner) => _inner.fmt(f),
            ListConnectorEntitiesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListConnectorEntitiesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListConnectorEntitiesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListConnectorEntitiesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListConnectorEntitiesError {
    fn code(&self) -> Option<&str> {
        ListConnectorEntitiesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListConnectorEntitiesError {
    /// Creates a new `ListConnectorEntitiesError`.
    pub fn new(kind: ListConnectorEntitiesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListConnectorEntitiesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListConnectorEntitiesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListConnectorEntitiesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListConnectorEntitiesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListConnectorEntitiesErrorKind::ConnectorAuthenticationException`.
    pub fn is_connector_authentication_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListConnectorEntitiesErrorKind::ConnectorAuthenticationException(_)
        )
    }
    /// Returns `true` if the error kind is `ListConnectorEntitiesErrorKind::ConnectorServerException`.
    pub fn is_connector_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListConnectorEntitiesErrorKind::ConnectorServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListConnectorEntitiesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListConnectorEntitiesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListConnectorEntitiesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListConnectorEntitiesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListConnectorEntitiesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListConnectorEntitiesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListConnectorEntitiesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListConnectorEntitiesErrorKind::ConnectorAuthenticationException(_inner) => {
                Some(_inner)
            }
            ListConnectorEntitiesErrorKind::ConnectorServerException(_inner) => Some(_inner),
            ListConnectorEntitiesErrorKind::InternalServerException(_inner) => Some(_inner),
            ListConnectorEntitiesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListConnectorEntitiesErrorKind::ValidationException(_inner) => Some(_inner),
            ListConnectorEntitiesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListFlows` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListFlowsError {
    /// Kind of error that occurred.
    pub kind: ListFlowsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListFlows` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListFlowsErrorKind {
    /// <p> An internal service error occurred during the processing of your request. Try again later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListFlowsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListFlowsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListFlowsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListFlowsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListFlowsError {
    fn code(&self) -> Option<&str> {
        ListFlowsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListFlowsError {
    /// Creates a new `ListFlowsError`.
    pub fn new(kind: ListFlowsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListFlowsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListFlowsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListFlowsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListFlowsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListFlowsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, ListFlowsErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `ListFlowsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListFlowsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListFlowsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListFlowsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListFlowsErrorKind::ValidationException(_inner) => Some(_inner),
            ListFlowsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p> An internal service error occurred during the processing of your request. Try again later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The resource specified in the request (such as the source or destination connector profile) is not found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ValidationException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartFlow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartFlowError {
    /// Kind of error that occurred.
    pub kind: StartFlowErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartFlow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartFlowErrorKind {
    /// <p> There was a conflict when processing the request (for example, a flow with the given name already exists within the account. Check for conflicting resource names and try again. </p>
    ConflictException(crate::error::ConflictException),
    /// <p> An internal service error occurred during the processing of your request. Try again later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The resource specified in the request (such as the source or destination connector profile) is not found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request would cause a service quota (such as the number of flows) to be exceeded. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartFlowError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartFlowErrorKind::ConflictException(_inner) => _inner.fmt(f),
            StartFlowErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            StartFlowErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StartFlowErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            StartFlowErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartFlowError {
    fn code(&self) -> Option<&str> {
        StartFlowError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartFlowError {
    /// Creates a new `StartFlowError`.
    pub fn new(kind: StartFlowErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartFlowError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartFlowErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartFlowError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartFlowErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartFlowErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, StartFlowErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `StartFlowErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, StartFlowErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `StartFlowErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, StartFlowErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `StartFlowErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartFlowErrorKind::ServiceQuotaExceededException(_)
        )
    }
}
impl std::error::Error for StartFlowError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartFlowErrorKind::ConflictException(_inner) => Some(_inner),
            StartFlowErrorKind::InternalServerException(_inner) => Some(_inner),
            StartFlowErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StartFlowErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            StartFlowErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopFlow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopFlowError {
    /// Kind of error that occurred.
    pub kind: StopFlowErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopFlow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopFlowErrorKind {
    /// <p> There was a conflict when processing the request (for example, a flow with the given name already exists within the account. Check for conflicting resource names and try again. </p>
    ConflictException(crate::error::ConflictException),
    /// <p> An internal service error occurred during the processing of your request. Try again later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The resource specified in the request (such as the source or destination connector profile) is not found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The requested operation is not supported for the current flow. </p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopFlowError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopFlowErrorKind::ConflictException(_inner) => _inner.fmt(f),
            StopFlowErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            StopFlowErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StopFlowErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            StopFlowErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopFlowError {
    fn code(&self) -> Option<&str> {
        StopFlowError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopFlowError {
    /// Creates a new `StopFlowError`.
    pub fn new(kind: StopFlowErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopFlowError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopFlowErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopFlowError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopFlowErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StopFlowErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, StopFlowErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `StopFlowErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, StopFlowErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `StopFlowErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, StopFlowErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `StopFlowErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopFlowErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for StopFlowError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopFlowErrorKind::ConflictException(_inner) => Some(_inner),
            StopFlowErrorKind::InternalServerException(_inner) => Some(_inner),
            StopFlowErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StopFlowErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            StopFlowErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p> An internal service error occurred during the processing of your request. Try again later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The resource specified in the request (such as the source or destination connector profile) is not found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p> An internal service error occurred during the processing of your request. Try again later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The resource specified in the request (such as the source or destination connector profile) is not found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateConnectorProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateConnectorProfileError {
    /// Kind of error that occurred.
    pub kind: UpdateConnectorProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateConnectorProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateConnectorProfileErrorKind {
    /// <p> There was a conflict when processing the request (for example, a flow with the given name already exists within the account. Check for conflicting resource names and try again. </p>
    ConflictException(crate::error::ConflictException),
    /// <p> An error occurred when authenticating with the connector endpoint. </p>
    ConnectorAuthenticationException(crate::error::ConnectorAuthenticationException),
    /// <p> An internal service error occurred during the processing of your request. Try again later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The resource specified in the request (such as the source or destination connector profile) is not found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateConnectorProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateConnectorProfileErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateConnectorProfileErrorKind::ConnectorAuthenticationException(_inner) => {
                _inner.fmt(f)
            }
            UpdateConnectorProfileErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateConnectorProfileErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateConnectorProfileErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateConnectorProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateConnectorProfileError {
    fn code(&self) -> Option<&str> {
        UpdateConnectorProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateConnectorProfileError {
    /// Creates a new `UpdateConnectorProfileError`.
    pub fn new(kind: UpdateConnectorProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateConnectorProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateConnectorProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateConnectorProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateConnectorProfileErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateConnectorProfileErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConnectorProfileErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateConnectorProfileErrorKind::ConnectorAuthenticationException`.
    pub fn is_connector_authentication_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConnectorProfileErrorKind::ConnectorAuthenticationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateConnectorProfileErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConnectorProfileErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateConnectorProfileErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConnectorProfileErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateConnectorProfileErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConnectorProfileErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateConnectorProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateConnectorProfileErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateConnectorProfileErrorKind::ConnectorAuthenticationException(_inner) => {
                Some(_inner)
            }
            UpdateConnectorProfileErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateConnectorProfileErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateConnectorProfileErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateConnectorProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateFlow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateFlowError {
    /// Kind of error that occurred.
    pub kind: UpdateFlowErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateFlow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateFlowErrorKind {
    /// <p> There was a conflict when processing the request (for example, a flow with the given name already exists within the account. Check for conflicting resource names and try again. </p>
    ConflictException(crate::error::ConflictException),
    /// <p> An error occurred when authenticating with the connector endpoint. </p>
    ConnectorAuthenticationException(crate::error::ConnectorAuthenticationException),
    /// <p> An error occurred when retrieving data from the connector endpoint. </p>
    ConnectorServerException(crate::error::ConnectorServerException),
    /// <p> An internal service error occurred during the processing of your request. Try again later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The resource specified in the request (such as the source or destination connector profile) is not found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request would cause a service quota (such as the number of flows) to be exceeded. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateFlowError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateFlowErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateFlowErrorKind::ConnectorAuthenticationException(_inner) => _inner.fmt(f),
            UpdateFlowErrorKind::ConnectorServerException(_inner) => _inner.fmt(f),
            UpdateFlowErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateFlowErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateFlowErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            UpdateFlowErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateFlowErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateFlowError {
    fn code(&self) -> Option<&str> {
        UpdateFlowError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateFlowError {
    /// Creates a new `UpdateFlowError`.
    pub fn new(kind: UpdateFlowErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateFlowError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateFlowErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateFlowError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateFlowErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateFlowErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateFlowErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UpdateFlowErrorKind::ConnectorAuthenticationException`.
    pub fn is_connector_authentication_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFlowErrorKind::ConnectorAuthenticationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFlowErrorKind::ConnectorServerException`.
    pub fn is_connector_server_exception(&self) -> bool {
        matches!(&self.kind, UpdateFlowErrorKind::ConnectorServerException(_))
    }
    /// Returns `true` if the error kind is `UpdateFlowErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, UpdateFlowErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `UpdateFlowErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFlowErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFlowErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFlowErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFlowErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UpdateFlowErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UpdateFlowError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateFlowErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateFlowErrorKind::ConnectorAuthenticationException(_inner) => Some(_inner),
            UpdateFlowErrorKind::ConnectorServerException(_inner) => Some(_inner),
            UpdateFlowErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateFlowErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateFlowErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            UpdateFlowErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateFlowErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p> The request has invalid or missing parameters. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ValidationException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ValidationException {}
/// See [`ValidationException`](crate::error::ValidationException)
pub mod validation_exception {
    /// A builder for [`ValidationException`](crate::error::ValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationException`](crate::error::ValidationException)
        pub fn build(self) -> crate::error::ValidationException {
            crate::error::ValidationException {
                message: self.message,
            }
        }
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::error::ValidationException)
    pub fn builder() -> crate::error::validation_exception::Builder {
        crate::error::validation_exception::Builder::default()
    }
}

/// <p> The request would cause a service quota (such as the number of flows) to be exceeded. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceQuotaExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceQuotaExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceQuotaExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceQuotaExceededException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceQuotaExceededException {}
/// See [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
pub mod service_quota_exceeded_exception {
    /// A builder for [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
        pub fn build(self) -> crate::error::ServiceQuotaExceededException {
            crate::error::ServiceQuotaExceededException {
                message: self.message,
            }
        }
    }
}
impl ServiceQuotaExceededException {
    /// Creates a new builder-style object to manufacture [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    pub fn builder() -> crate::error::service_quota_exceeded_exception::Builder {
        crate::error::service_quota_exceeded_exception::Builder::default()
    }
}

/// <p> The resource specified in the request (such as the source or destination connector profile) is not found. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p> An internal service error occurred during the processing of your request. Try again later. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServerException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerException {}
/// See [`InternalServerException`](crate::error::InternalServerException)
pub mod internal_server_exception {
    /// A builder for [`InternalServerException`](crate::error::InternalServerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerException`](crate::error::InternalServerException)
        pub fn build(self) -> crate::error::InternalServerException {
            crate::error::InternalServerException {
                message: self.message,
            }
        }
    }
}
impl InternalServerException {
    /// Creates a new builder-style object to manufacture [`InternalServerException`](crate::error::InternalServerException)
    pub fn builder() -> crate::error::internal_server_exception::Builder {
        crate::error::internal_server_exception::Builder::default()
    }
}

/// <p> An error occurred when retrieving data from the connector endpoint. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConnectorServerException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConnectorServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConnectorServerException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConnectorServerException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConnectorServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConnectorServerException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConnectorServerException {}
/// See [`ConnectorServerException`](crate::error::ConnectorServerException)
pub mod connector_server_exception {
    /// A builder for [`ConnectorServerException`](crate::error::ConnectorServerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConnectorServerException`](crate::error::ConnectorServerException)
        pub fn build(self) -> crate::error::ConnectorServerException {
            crate::error::ConnectorServerException {
                message: self.message,
            }
        }
    }
}
impl ConnectorServerException {
    /// Creates a new builder-style object to manufacture [`ConnectorServerException`](crate::error::ConnectorServerException)
    pub fn builder() -> crate::error::connector_server_exception::Builder {
        crate::error::connector_server_exception::Builder::default()
    }
}

/// <p> An error occurred when authenticating with the connector endpoint. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConnectorAuthenticationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConnectorAuthenticationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConnectorAuthenticationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConnectorAuthenticationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConnectorAuthenticationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConnectorAuthenticationException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConnectorAuthenticationException {}
/// See [`ConnectorAuthenticationException`](crate::error::ConnectorAuthenticationException)
pub mod connector_authentication_exception {
    /// A builder for [`ConnectorAuthenticationException`](crate::error::ConnectorAuthenticationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConnectorAuthenticationException`](crate::error::ConnectorAuthenticationException)
        pub fn build(self) -> crate::error::ConnectorAuthenticationException {
            crate::error::ConnectorAuthenticationException {
                message: self.message,
            }
        }
    }
}
impl ConnectorAuthenticationException {
    /// Creates a new builder-style object to manufacture [`ConnectorAuthenticationException`](crate::error::ConnectorAuthenticationException)
    pub fn builder() -> crate::error::connector_authentication_exception::Builder {
        crate::error::connector_authentication_exception::Builder::default()
    }
}

/// <p> There was a conflict when processing the request (for example, a flow with the given name already exists within the account. Check for conflicting resource names and try again. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

/// <p> The requested operation is not supported for the current flow. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnsupportedOperationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnsupportedOperationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnsupportedOperationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnsupportedOperationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnsupportedOperationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnsupportedOperationException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnsupportedOperationException {}
/// See [`UnsupportedOperationException`](crate::error::UnsupportedOperationException)
pub mod unsupported_operation_exception {
    /// A builder for [`UnsupportedOperationException`](crate::error::UnsupportedOperationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnsupportedOperationException`](crate::error::UnsupportedOperationException)
        pub fn build(self) -> crate::error::UnsupportedOperationException {
            crate::error::UnsupportedOperationException {
                message: self.message,
            }
        }
    }
}
impl UnsupportedOperationException {
    /// Creates a new builder-style object to manufacture [`UnsupportedOperationException`](crate::error::UnsupportedOperationException)
    pub fn builder() -> crate::error::unsupported_operation_exception::Builder {
        crate::error::unsupported_operation_exception::Builder::default()
    }
}
