// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FlowStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Deprecated,
    #[allow(missing_docs)] // documentation missing in model
    Draft,
    #[allow(missing_docs)] // documentation missing in model
    Errored,
    #[allow(missing_docs)] // documentation missing in model
    Suspended,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FlowStatus {
    fn from(s: &str) -> Self {
        match s {
            "Active" => FlowStatus::Active,
            "Deleted" => FlowStatus::Deleted,
            "Deprecated" => FlowStatus::Deprecated,
            "Draft" => FlowStatus::Draft,
            "Errored" => FlowStatus::Errored,
            "Suspended" => FlowStatus::Suspended,
            other => FlowStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FlowStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FlowStatus::from(s))
    }
}
impl FlowStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FlowStatus::Active => "Active",
            FlowStatus::Deleted => "Deleted",
            FlowStatus::Deprecated => "Deprecated",
            FlowStatus::Draft => "Draft",
            FlowStatus::Errored => "Errored",
            FlowStatus::Suspended => "Suspended",
            FlowStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Active",
            "Deleted",
            "Deprecated",
            "Draft",
            "Errored",
            "Suspended",
        ]
    }
}
impl AsRef<str> for FlowStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> A class for modeling different type of tasks. Task implementation varies based on the <code>TaskType</code>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Task {
    /// <p> The source fields to which a particular task is applied. </p>
    pub source_fields: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> The operation to be performed on the provided source fields. </p>
    pub connector_operator: std::option::Option<crate::model::ConnectorOperator>,
    /// <p> A field in a destination connector, or a field value against which Amazon AppFlow validates a source field. </p>
    pub destination_field: std::option::Option<std::string::String>,
    /// <p> Specifies the particular task implementation that Amazon AppFlow performs. </p>
    pub task_type: std::option::Option<crate::model::TaskType>,
    /// <p> A map used to store task-related information. The execution service looks for particular information based on the <code>TaskType</code>. </p>
    pub task_properties: std::option::Option<
        std::collections::HashMap<crate::model::OperatorPropertiesKeys, std::string::String>,
    >,
}
impl Task {
    /// <p> The source fields to which a particular task is applied. </p>
    pub fn source_fields(&self) -> std::option::Option<&[std::string::String]> {
        self.source_fields.as_deref()
    }
    /// <p> The operation to be performed on the provided source fields. </p>
    pub fn connector_operator(&self) -> std::option::Option<&crate::model::ConnectorOperator> {
        self.connector_operator.as_ref()
    }
    /// <p> A field in a destination connector, or a field value against which Amazon AppFlow validates a source field. </p>
    pub fn destination_field(&self) -> std::option::Option<&str> {
        self.destination_field.as_deref()
    }
    /// <p> Specifies the particular task implementation that Amazon AppFlow performs. </p>
    pub fn task_type(&self) -> std::option::Option<&crate::model::TaskType> {
        self.task_type.as_ref()
    }
    /// <p> A map used to store task-related information. The execution service looks for particular information based on the <code>TaskType</code>. </p>
    pub fn task_properties(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<crate::model::OperatorPropertiesKeys, std::string::String>,
    > {
        self.task_properties.as_ref()
    }
}
impl std::fmt::Debug for Task {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Task");
        formatter.field("source_fields", &self.source_fields);
        formatter.field("connector_operator", &self.connector_operator);
        formatter.field("destination_field", &self.destination_field);
        formatter.field("task_type", &self.task_type);
        formatter.field("task_properties", &self.task_properties);
        formatter.finish()
    }
}
/// See [`Task`](crate::model::Task)
pub mod task {
    /// A builder for [`Task`](crate::model::Task)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_fields: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) connector_operator: std::option::Option<crate::model::ConnectorOperator>,
        pub(crate) destination_field: std::option::Option<std::string::String>,
        pub(crate) task_type: std::option::Option<crate::model::TaskType>,
        pub(crate) task_properties: std::option::Option<
            std::collections::HashMap<crate::model::OperatorPropertiesKeys, std::string::String>,
        >,
    }
    impl Builder {
        /// Appends an item to `source_fields`.
        ///
        /// To override the contents of this collection use [`set_source_fields`](Self::set_source_fields).
        ///
        /// <p> The source fields to which a particular task is applied. </p>
        pub fn source_fields(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.source_fields.unwrap_or_default();
            v.push(input.into());
            self.source_fields = Some(v);
            self
        }
        /// <p> The source fields to which a particular task is applied. </p>
        pub fn set_source_fields(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.source_fields = input;
            self
        }
        /// <p> The operation to be performed on the provided source fields. </p>
        pub fn connector_operator(mut self, input: crate::model::ConnectorOperator) -> Self {
            self.connector_operator = Some(input);
            self
        }
        /// <p> The operation to be performed on the provided source fields. </p>
        pub fn set_connector_operator(
            mut self,
            input: std::option::Option<crate::model::ConnectorOperator>,
        ) -> Self {
            self.connector_operator = input;
            self
        }
        /// <p> A field in a destination connector, or a field value against which Amazon AppFlow validates a source field. </p>
        pub fn destination_field(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_field = Some(input.into());
            self
        }
        /// <p> A field in a destination connector, or a field value against which Amazon AppFlow validates a source field. </p>
        pub fn set_destination_field(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_field = input;
            self
        }
        /// <p> Specifies the particular task implementation that Amazon AppFlow performs. </p>
        pub fn task_type(mut self, input: crate::model::TaskType) -> Self {
            self.task_type = Some(input);
            self
        }
        /// <p> Specifies the particular task implementation that Amazon AppFlow performs. </p>
        pub fn set_task_type(mut self, input: std::option::Option<crate::model::TaskType>) -> Self {
            self.task_type = input;
            self
        }
        /// Adds a key-value pair to `task_properties`.
        ///
        /// To override the contents of this collection use [`set_task_properties`](Self::set_task_properties).
        ///
        /// <p> A map used to store task-related information. The execution service looks for particular information based on the <code>TaskType</code>. </p>
        pub fn task_properties(
            mut self,
            k: crate::model::OperatorPropertiesKeys,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.task_properties.unwrap_or_default();
            hash_map.insert(k, v.into());
            self.task_properties = Some(hash_map);
            self
        }
        /// <p> A map used to store task-related information. The execution service looks for particular information based on the <code>TaskType</code>. </p>
        pub fn set_task_properties(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    crate::model::OperatorPropertiesKeys,
                    std::string::String,
                >,
            >,
        ) -> Self {
            self.task_properties = input;
            self
        }
        /// Consumes the builder and constructs a [`Task`](crate::model::Task)
        pub fn build(self) -> crate::model::Task {
            crate::model::Task {
                source_fields: self.source_fields,
                connector_operator: self.connector_operator,
                destination_field: self.destination_field,
                task_type: self.task_type,
                task_properties: self.task_properties,
            }
        }
    }
}
impl Task {
    /// Creates a new builder-style object to manufacture [`Task`](crate::model::Task)
    pub fn builder() -> crate::model::task::Builder {
        crate::model::task::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OperatorPropertiesKeys {
    #[allow(missing_docs)] // documentation missing in model
    ConcatFormat,
    #[allow(missing_docs)] // documentation missing in model
    DataType,
    #[allow(missing_docs)] // documentation missing in model
    DestinationDataType,
    #[allow(missing_docs)] // documentation missing in model
    ExcludeSourceFieldsList,
    #[allow(missing_docs)] // documentation missing in model
    LowerBound,
    #[allow(missing_docs)] // documentation missing in model
    MaskLength,
    #[allow(missing_docs)] // documentation missing in model
    MaskValue,
    #[allow(missing_docs)] // documentation missing in model
    MathOperationFieldsOrder,
    #[allow(missing_docs)] // documentation missing in model
    SourceDataType,
    #[allow(missing_docs)] // documentation missing in model
    SubfieldCategoryMap,
    #[allow(missing_docs)] // documentation missing in model
    TruncateLength,
    #[allow(missing_docs)] // documentation missing in model
    UpperBound,
    #[allow(missing_docs)] // documentation missing in model
    ValidationAction,
    #[allow(missing_docs)] // documentation missing in model
    Value,
    #[allow(missing_docs)] // documentation missing in model
    Values,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OperatorPropertiesKeys {
    fn from(s: &str) -> Self {
        match s {
            "CONCAT_FORMAT" => OperatorPropertiesKeys::ConcatFormat,
            "DATA_TYPE" => OperatorPropertiesKeys::DataType,
            "DESTINATION_DATA_TYPE" => OperatorPropertiesKeys::DestinationDataType,
            "EXCLUDE_SOURCE_FIELDS_LIST" => OperatorPropertiesKeys::ExcludeSourceFieldsList,
            "LOWER_BOUND" => OperatorPropertiesKeys::LowerBound,
            "MASK_LENGTH" => OperatorPropertiesKeys::MaskLength,
            "MASK_VALUE" => OperatorPropertiesKeys::MaskValue,
            "MATH_OPERATION_FIELDS_ORDER" => OperatorPropertiesKeys::MathOperationFieldsOrder,
            "SOURCE_DATA_TYPE" => OperatorPropertiesKeys::SourceDataType,
            "SUBFIELD_CATEGORY_MAP" => OperatorPropertiesKeys::SubfieldCategoryMap,
            "TRUNCATE_LENGTH" => OperatorPropertiesKeys::TruncateLength,
            "UPPER_BOUND" => OperatorPropertiesKeys::UpperBound,
            "VALIDATION_ACTION" => OperatorPropertiesKeys::ValidationAction,
            "VALUE" => OperatorPropertiesKeys::Value,
            "VALUES" => OperatorPropertiesKeys::Values,
            other => OperatorPropertiesKeys::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OperatorPropertiesKeys {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OperatorPropertiesKeys::from(s))
    }
}
impl OperatorPropertiesKeys {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OperatorPropertiesKeys::ConcatFormat => "CONCAT_FORMAT",
            OperatorPropertiesKeys::DataType => "DATA_TYPE",
            OperatorPropertiesKeys::DestinationDataType => "DESTINATION_DATA_TYPE",
            OperatorPropertiesKeys::ExcludeSourceFieldsList => "EXCLUDE_SOURCE_FIELDS_LIST",
            OperatorPropertiesKeys::LowerBound => "LOWER_BOUND",
            OperatorPropertiesKeys::MaskLength => "MASK_LENGTH",
            OperatorPropertiesKeys::MaskValue => "MASK_VALUE",
            OperatorPropertiesKeys::MathOperationFieldsOrder => "MATH_OPERATION_FIELDS_ORDER",
            OperatorPropertiesKeys::SourceDataType => "SOURCE_DATA_TYPE",
            OperatorPropertiesKeys::SubfieldCategoryMap => "SUBFIELD_CATEGORY_MAP",
            OperatorPropertiesKeys::TruncateLength => "TRUNCATE_LENGTH",
            OperatorPropertiesKeys::UpperBound => "UPPER_BOUND",
            OperatorPropertiesKeys::ValidationAction => "VALIDATION_ACTION",
            OperatorPropertiesKeys::Value => "VALUE",
            OperatorPropertiesKeys::Values => "VALUES",
            OperatorPropertiesKeys::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CONCAT_FORMAT",
            "DATA_TYPE",
            "DESTINATION_DATA_TYPE",
            "EXCLUDE_SOURCE_FIELDS_LIST",
            "LOWER_BOUND",
            "MASK_LENGTH",
            "MASK_VALUE",
            "MATH_OPERATION_FIELDS_ORDER",
            "SOURCE_DATA_TYPE",
            "SUBFIELD_CATEGORY_MAP",
            "TRUNCATE_LENGTH",
            "UPPER_BOUND",
            "VALIDATION_ACTION",
            "VALUE",
            "VALUES",
        ]
    }
}
impl AsRef<str> for OperatorPropertiesKeys {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TaskType {
    #[allow(missing_docs)] // documentation missing in model
    Arithmetic,
    #[allow(missing_docs)] // documentation missing in model
    Filter,
    #[allow(missing_docs)] // documentation missing in model
    Map,
    #[allow(missing_docs)] // documentation missing in model
    MapAll,
    #[allow(missing_docs)] // documentation missing in model
    Mask,
    #[allow(missing_docs)] // documentation missing in model
    Merge,
    #[allow(missing_docs)] // documentation missing in model
    Passthrough,
    #[allow(missing_docs)] // documentation missing in model
    Truncate,
    #[allow(missing_docs)] // documentation missing in model
    Validate,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TaskType {
    fn from(s: &str) -> Self {
        match s {
            "Arithmetic" => TaskType::Arithmetic,
            "Filter" => TaskType::Filter,
            "Map" => TaskType::Map,
            "Map_all" => TaskType::MapAll,
            "Mask" => TaskType::Mask,
            "Merge" => TaskType::Merge,
            "Passthrough" => TaskType::Passthrough,
            "Truncate" => TaskType::Truncate,
            "Validate" => TaskType::Validate,
            other => TaskType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TaskType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TaskType::from(s))
    }
}
impl TaskType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TaskType::Arithmetic => "Arithmetic",
            TaskType::Filter => "Filter",
            TaskType::Map => "Map",
            TaskType::MapAll => "Map_all",
            TaskType::Mask => "Mask",
            TaskType::Merge => "Merge",
            TaskType::Passthrough => "Passthrough",
            TaskType::Truncate => "Truncate",
            TaskType::Validate => "Validate",
            TaskType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Arithmetic",
            "Filter",
            "Map",
            "Map_all",
            "Mask",
            "Merge",
            "Passthrough",
            "Truncate",
            "Validate",
        ]
    }
}
impl AsRef<str> for TaskType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> The operation to be performed on the provided source fields. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConnectorOperator {
    /// <p> The operation to be performed on the provided Amplitude source fields. </p>
    pub amplitude: std::option::Option<crate::model::AmplitudeConnectorOperator>,
    /// <p> The operation to be performed on the provided Datadog source fields. </p>
    pub datadog: std::option::Option<crate::model::DatadogConnectorOperator>,
    /// <p> The operation to be performed on the provided Dynatrace source fields. </p>
    pub dynatrace: std::option::Option<crate::model::DynatraceConnectorOperator>,
    /// <p> The operation to be performed on the provided Google Analytics source fields. </p>
    pub google_analytics: std::option::Option<crate::model::GoogleAnalyticsConnectorOperator>,
    /// <p> The operation to be performed on the provided Infor Nexus source fields. </p>
    pub infor_nexus: std::option::Option<crate::model::InforNexusConnectorOperator>,
    /// <p> The operation to be performed on the provided Marketo source fields. </p>
    pub marketo: std::option::Option<crate::model::MarketoConnectorOperator>,
    /// <p> The operation to be performed on the provided Amazon S3 source fields. </p>
    pub s3: std::option::Option<crate::model::S3ConnectorOperator>,
    /// <p> The operation to be performed on the provided Salesforce source fields. </p>
    pub salesforce: std::option::Option<crate::model::SalesforceConnectorOperator>,
    /// <p> The operation to be performed on the provided ServiceNow source fields. </p>
    pub service_now: std::option::Option<crate::model::ServiceNowConnectorOperator>,
    /// <p> The operation to be performed on the provided Singular source fields. </p>
    pub singular: std::option::Option<crate::model::SingularConnectorOperator>,
    /// <p> The operation to be performed on the provided Slack source fields. </p>
    pub slack: std::option::Option<crate::model::SlackConnectorOperator>,
    /// <p> The operation to be performed on the provided Trend Micro source fields. </p>
    pub trendmicro: std::option::Option<crate::model::TrendmicroConnectorOperator>,
    /// <p> The operation to be performed on the provided Veeva source fields. </p>
    pub veeva: std::option::Option<crate::model::VeevaConnectorOperator>,
    /// <p> The operation to be performed on the provided Zendesk source fields. </p>
    pub zendesk: std::option::Option<crate::model::ZendeskConnectorOperator>,
    /// <p> The operation to be performed on the provided SAPOData source fields. </p>
    pub sapo_data: std::option::Option<crate::model::SapoDataConnectorOperator>,
    /// <p>Operators supported by the custom connector.</p>
    pub custom_connector: std::option::Option<crate::model::Operator>,
}
impl ConnectorOperator {
    /// <p> The operation to be performed on the provided Amplitude source fields. </p>
    pub fn amplitude(&self) -> std::option::Option<&crate::model::AmplitudeConnectorOperator> {
        self.amplitude.as_ref()
    }
    /// <p> The operation to be performed on the provided Datadog source fields. </p>
    pub fn datadog(&self) -> std::option::Option<&crate::model::DatadogConnectorOperator> {
        self.datadog.as_ref()
    }
    /// <p> The operation to be performed on the provided Dynatrace source fields. </p>
    pub fn dynatrace(&self) -> std::option::Option<&crate::model::DynatraceConnectorOperator> {
        self.dynatrace.as_ref()
    }
    /// <p> The operation to be performed on the provided Google Analytics source fields. </p>
    pub fn google_analytics(
        &self,
    ) -> std::option::Option<&crate::model::GoogleAnalyticsConnectorOperator> {
        self.google_analytics.as_ref()
    }
    /// <p> The operation to be performed on the provided Infor Nexus source fields. </p>
    pub fn infor_nexus(&self) -> std::option::Option<&crate::model::InforNexusConnectorOperator> {
        self.infor_nexus.as_ref()
    }
    /// <p> The operation to be performed on the provided Marketo source fields. </p>
    pub fn marketo(&self) -> std::option::Option<&crate::model::MarketoConnectorOperator> {
        self.marketo.as_ref()
    }
    /// <p> The operation to be performed on the provided Amazon S3 source fields. </p>
    pub fn s3(&self) -> std::option::Option<&crate::model::S3ConnectorOperator> {
        self.s3.as_ref()
    }
    /// <p> The operation to be performed on the provided Salesforce source fields. </p>
    pub fn salesforce(&self) -> std::option::Option<&crate::model::SalesforceConnectorOperator> {
        self.salesforce.as_ref()
    }
    /// <p> The operation to be performed on the provided ServiceNow source fields. </p>
    pub fn service_now(&self) -> std::option::Option<&crate::model::ServiceNowConnectorOperator> {
        self.service_now.as_ref()
    }
    /// <p> The operation to be performed on the provided Singular source fields. </p>
    pub fn singular(&self) -> std::option::Option<&crate::model::SingularConnectorOperator> {
        self.singular.as_ref()
    }
    /// <p> The operation to be performed on the provided Slack source fields. </p>
    pub fn slack(&self) -> std::option::Option<&crate::model::SlackConnectorOperator> {
        self.slack.as_ref()
    }
    /// <p> The operation to be performed on the provided Trend Micro source fields. </p>
    pub fn trendmicro(&self) -> std::option::Option<&crate::model::TrendmicroConnectorOperator> {
        self.trendmicro.as_ref()
    }
    /// <p> The operation to be performed on the provided Veeva source fields. </p>
    pub fn veeva(&self) -> std::option::Option<&crate::model::VeevaConnectorOperator> {
        self.veeva.as_ref()
    }
    /// <p> The operation to be performed on the provided Zendesk source fields. </p>
    pub fn zendesk(&self) -> std::option::Option<&crate::model::ZendeskConnectorOperator> {
        self.zendesk.as_ref()
    }
    /// <p> The operation to be performed on the provided SAPOData source fields. </p>
    pub fn sapo_data(&self) -> std::option::Option<&crate::model::SapoDataConnectorOperator> {
        self.sapo_data.as_ref()
    }
    /// <p>Operators supported by the custom connector.</p>
    pub fn custom_connector(&self) -> std::option::Option<&crate::model::Operator> {
        self.custom_connector.as_ref()
    }
}
impl std::fmt::Debug for ConnectorOperator {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConnectorOperator");
        formatter.field("amplitude", &self.amplitude);
        formatter.field("datadog", &self.datadog);
        formatter.field("dynatrace", &self.dynatrace);
        formatter.field("google_analytics", &self.google_analytics);
        formatter.field("infor_nexus", &self.infor_nexus);
        formatter.field("marketo", &self.marketo);
        formatter.field("s3", &self.s3);
        formatter.field("salesforce", &self.salesforce);
        formatter.field("service_now", &self.service_now);
        formatter.field("singular", &self.singular);
        formatter.field("slack", &self.slack);
        formatter.field("trendmicro", &self.trendmicro);
        formatter.field("veeva", &self.veeva);
        formatter.field("zendesk", &self.zendesk);
        formatter.field("sapo_data", &self.sapo_data);
        formatter.field("custom_connector", &self.custom_connector);
        formatter.finish()
    }
}
/// See [`ConnectorOperator`](crate::model::ConnectorOperator)
pub mod connector_operator {
    /// A builder for [`ConnectorOperator`](crate::model::ConnectorOperator)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) amplitude: std::option::Option<crate::model::AmplitudeConnectorOperator>,
        pub(crate) datadog: std::option::Option<crate::model::DatadogConnectorOperator>,
        pub(crate) dynatrace: std::option::Option<crate::model::DynatraceConnectorOperator>,
        pub(crate) google_analytics:
            std::option::Option<crate::model::GoogleAnalyticsConnectorOperator>,
        pub(crate) infor_nexus: std::option::Option<crate::model::InforNexusConnectorOperator>,
        pub(crate) marketo: std::option::Option<crate::model::MarketoConnectorOperator>,
        pub(crate) s3: std::option::Option<crate::model::S3ConnectorOperator>,
        pub(crate) salesforce: std::option::Option<crate::model::SalesforceConnectorOperator>,
        pub(crate) service_now: std::option::Option<crate::model::ServiceNowConnectorOperator>,
        pub(crate) singular: std::option::Option<crate::model::SingularConnectorOperator>,
        pub(crate) slack: std::option::Option<crate::model::SlackConnectorOperator>,
        pub(crate) trendmicro: std::option::Option<crate::model::TrendmicroConnectorOperator>,
        pub(crate) veeva: std::option::Option<crate::model::VeevaConnectorOperator>,
        pub(crate) zendesk: std::option::Option<crate::model::ZendeskConnectorOperator>,
        pub(crate) sapo_data: std::option::Option<crate::model::SapoDataConnectorOperator>,
        pub(crate) custom_connector: std::option::Option<crate::model::Operator>,
    }
    impl Builder {
        /// <p> The operation to be performed on the provided Amplitude source fields. </p>
        pub fn amplitude(mut self, input: crate::model::AmplitudeConnectorOperator) -> Self {
            self.amplitude = Some(input);
            self
        }
        /// <p> The operation to be performed on the provided Amplitude source fields. </p>
        pub fn set_amplitude(
            mut self,
            input: std::option::Option<crate::model::AmplitudeConnectorOperator>,
        ) -> Self {
            self.amplitude = input;
            self
        }
        /// <p> The operation to be performed on the provided Datadog source fields. </p>
        pub fn datadog(mut self, input: crate::model::DatadogConnectorOperator) -> Self {
            self.datadog = Some(input);
            self
        }
        /// <p> The operation to be performed on the provided Datadog source fields. </p>
        pub fn set_datadog(
            mut self,
            input: std::option::Option<crate::model::DatadogConnectorOperator>,
        ) -> Self {
            self.datadog = input;
            self
        }
        /// <p> The operation to be performed on the provided Dynatrace source fields. </p>
        pub fn dynatrace(mut self, input: crate::model::DynatraceConnectorOperator) -> Self {
            self.dynatrace = Some(input);
            self
        }
        /// <p> The operation to be performed on the provided Dynatrace source fields. </p>
        pub fn set_dynatrace(
            mut self,
            input: std::option::Option<crate::model::DynatraceConnectorOperator>,
        ) -> Self {
            self.dynatrace = input;
            self
        }
        /// <p> The operation to be performed on the provided Google Analytics source fields. </p>
        pub fn google_analytics(
            mut self,
            input: crate::model::GoogleAnalyticsConnectorOperator,
        ) -> Self {
            self.google_analytics = Some(input);
            self
        }
        /// <p> The operation to be performed on the provided Google Analytics source fields. </p>
        pub fn set_google_analytics(
            mut self,
            input: std::option::Option<crate::model::GoogleAnalyticsConnectorOperator>,
        ) -> Self {
            self.google_analytics = input;
            self
        }
        /// <p> The operation to be performed on the provided Infor Nexus source fields. </p>
        pub fn infor_nexus(mut self, input: crate::model::InforNexusConnectorOperator) -> Self {
            self.infor_nexus = Some(input);
            self
        }
        /// <p> The operation to be performed on the provided Infor Nexus source fields. </p>
        pub fn set_infor_nexus(
            mut self,
            input: std::option::Option<crate::model::InforNexusConnectorOperator>,
        ) -> Self {
            self.infor_nexus = input;
            self
        }
        /// <p> The operation to be performed on the provided Marketo source fields. </p>
        pub fn marketo(mut self, input: crate::model::MarketoConnectorOperator) -> Self {
            self.marketo = Some(input);
            self
        }
        /// <p> The operation to be performed on the provided Marketo source fields. </p>
        pub fn set_marketo(
            mut self,
            input: std::option::Option<crate::model::MarketoConnectorOperator>,
        ) -> Self {
            self.marketo = input;
            self
        }
        /// <p> The operation to be performed on the provided Amazon S3 source fields. </p>
        pub fn s3(mut self, input: crate::model::S3ConnectorOperator) -> Self {
            self.s3 = Some(input);
            self
        }
        /// <p> The operation to be performed on the provided Amazon S3 source fields. </p>
        pub fn set_s3(
            mut self,
            input: std::option::Option<crate::model::S3ConnectorOperator>,
        ) -> Self {
            self.s3 = input;
            self
        }
        /// <p> The operation to be performed on the provided Salesforce source fields. </p>
        pub fn salesforce(mut self, input: crate::model::SalesforceConnectorOperator) -> Self {
            self.salesforce = Some(input);
            self
        }
        /// <p> The operation to be performed on the provided Salesforce source fields. </p>
        pub fn set_salesforce(
            mut self,
            input: std::option::Option<crate::model::SalesforceConnectorOperator>,
        ) -> Self {
            self.salesforce = input;
            self
        }
        /// <p> The operation to be performed on the provided ServiceNow source fields. </p>
        pub fn service_now(mut self, input: crate::model::ServiceNowConnectorOperator) -> Self {
            self.service_now = Some(input);
            self
        }
        /// <p> The operation to be performed on the provided ServiceNow source fields. </p>
        pub fn set_service_now(
            mut self,
            input: std::option::Option<crate::model::ServiceNowConnectorOperator>,
        ) -> Self {
            self.service_now = input;
            self
        }
        /// <p> The operation to be performed on the provided Singular source fields. </p>
        pub fn singular(mut self, input: crate::model::SingularConnectorOperator) -> Self {
            self.singular = Some(input);
            self
        }
        /// <p> The operation to be performed on the provided Singular source fields. </p>
        pub fn set_singular(
            mut self,
            input: std::option::Option<crate::model::SingularConnectorOperator>,
        ) -> Self {
            self.singular = input;
            self
        }
        /// <p> The operation to be performed on the provided Slack source fields. </p>
        pub fn slack(mut self, input: crate::model::SlackConnectorOperator) -> Self {
            self.slack = Some(input);
            self
        }
        /// <p> The operation to be performed on the provided Slack source fields. </p>
        pub fn set_slack(
            mut self,
            input: std::option::Option<crate::model::SlackConnectorOperator>,
        ) -> Self {
            self.slack = input;
            self
        }
        /// <p> The operation to be performed on the provided Trend Micro source fields. </p>
        pub fn trendmicro(mut self, input: crate::model::TrendmicroConnectorOperator) -> Self {
            self.trendmicro = Some(input);
            self
        }
        /// <p> The operation to be performed on the provided Trend Micro source fields. </p>
        pub fn set_trendmicro(
            mut self,
            input: std::option::Option<crate::model::TrendmicroConnectorOperator>,
        ) -> Self {
            self.trendmicro = input;
            self
        }
        /// <p> The operation to be performed on the provided Veeva source fields. </p>
        pub fn veeva(mut self, input: crate::model::VeevaConnectorOperator) -> Self {
            self.veeva = Some(input);
            self
        }
        /// <p> The operation to be performed on the provided Veeva source fields. </p>
        pub fn set_veeva(
            mut self,
            input: std::option::Option<crate::model::VeevaConnectorOperator>,
        ) -> Self {
            self.veeva = input;
            self
        }
        /// <p> The operation to be performed on the provided Zendesk source fields. </p>
        pub fn zendesk(mut self, input: crate::model::ZendeskConnectorOperator) -> Self {
            self.zendesk = Some(input);
            self
        }
        /// <p> The operation to be performed on the provided Zendesk source fields. </p>
        pub fn set_zendesk(
            mut self,
            input: std::option::Option<crate::model::ZendeskConnectorOperator>,
        ) -> Self {
            self.zendesk = input;
            self
        }
        /// <p> The operation to be performed on the provided SAPOData source fields. </p>
        pub fn sapo_data(mut self, input: crate::model::SapoDataConnectorOperator) -> Self {
            self.sapo_data = Some(input);
            self
        }
        /// <p> The operation to be performed on the provided SAPOData source fields. </p>
        pub fn set_sapo_data(
            mut self,
            input: std::option::Option<crate::model::SapoDataConnectorOperator>,
        ) -> Self {
            self.sapo_data = input;
            self
        }
        /// <p>Operators supported by the custom connector.</p>
        pub fn custom_connector(mut self, input: crate::model::Operator) -> Self {
            self.custom_connector = Some(input);
            self
        }
        /// <p>Operators supported by the custom connector.</p>
        pub fn set_custom_connector(
            mut self,
            input: std::option::Option<crate::model::Operator>,
        ) -> Self {
            self.custom_connector = input;
            self
        }
        /// Consumes the builder and constructs a [`ConnectorOperator`](crate::model::ConnectorOperator)
        pub fn build(self) -> crate::model::ConnectorOperator {
            crate::model::ConnectorOperator {
                amplitude: self.amplitude,
                datadog: self.datadog,
                dynatrace: self.dynatrace,
                google_analytics: self.google_analytics,
                infor_nexus: self.infor_nexus,
                marketo: self.marketo,
                s3: self.s3,
                salesforce: self.salesforce,
                service_now: self.service_now,
                singular: self.singular,
                slack: self.slack,
                trendmicro: self.trendmicro,
                veeva: self.veeva,
                zendesk: self.zendesk,
                sapo_data: self.sapo_data,
                custom_connector: self.custom_connector,
            }
        }
    }
}
impl ConnectorOperator {
    /// Creates a new builder-style object to manufacture [`ConnectorOperator`](crate::model::ConnectorOperator)
    pub fn builder() -> crate::model::connector_operator::Builder {
        crate::model::connector_operator::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Operator {
    #[allow(missing_docs)] // documentation missing in model
    Addition,
    #[allow(missing_docs)] // documentation missing in model
    Between,
    #[allow(missing_docs)] // documentation missing in model
    Contains,
    #[allow(missing_docs)] // documentation missing in model
    Division,
    #[allow(missing_docs)] // documentation missing in model
    EqualTo,
    #[allow(missing_docs)] // documentation missing in model
    GreaterThan,
    #[allow(missing_docs)] // documentation missing in model
    GreaterThanOrEqualTo,
    #[allow(missing_docs)] // documentation missing in model
    LessThan,
    #[allow(missing_docs)] // documentation missing in model
    LessThanOrEqualTo,
    #[allow(missing_docs)] // documentation missing in model
    MaskAll,
    #[allow(missing_docs)] // documentation missing in model
    MaskFirstN,
    #[allow(missing_docs)] // documentation missing in model
    MaskLastN,
    #[allow(missing_docs)] // documentation missing in model
    Multiplication,
    #[allow(missing_docs)] // documentation missing in model
    NotEqualTo,
    #[allow(missing_docs)] // documentation missing in model
    NoOp,
    #[allow(missing_docs)] // documentation missing in model
    Projection,
    #[allow(missing_docs)] // documentation missing in model
    Subtraction,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNonNegative,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNonNull,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNonZero,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNumeric,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Operator {
    fn from(s: &str) -> Self {
        match s {
            "ADDITION" => Operator::Addition,
            "BETWEEN" => Operator::Between,
            "CONTAINS" => Operator::Contains,
            "DIVISION" => Operator::Division,
            "EQUAL_TO" => Operator::EqualTo,
            "GREATER_THAN" => Operator::GreaterThan,
            "GREATER_THAN_OR_EQUAL_TO" => Operator::GreaterThanOrEqualTo,
            "LESS_THAN" => Operator::LessThan,
            "LESS_THAN_OR_EQUAL_TO" => Operator::LessThanOrEqualTo,
            "MASK_ALL" => Operator::MaskAll,
            "MASK_FIRST_N" => Operator::MaskFirstN,
            "MASK_LAST_N" => Operator::MaskLastN,
            "MULTIPLICATION" => Operator::Multiplication,
            "NOT_EQUAL_TO" => Operator::NotEqualTo,
            "NO_OP" => Operator::NoOp,
            "PROJECTION" => Operator::Projection,
            "SUBTRACTION" => Operator::Subtraction,
            "VALIDATE_NON_NEGATIVE" => Operator::ValidateNonNegative,
            "VALIDATE_NON_NULL" => Operator::ValidateNonNull,
            "VALIDATE_NON_ZERO" => Operator::ValidateNonZero,
            "VALIDATE_NUMERIC" => Operator::ValidateNumeric,
            other => Operator::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Operator {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Operator::from(s))
    }
}
impl Operator {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Operator::Addition => "ADDITION",
            Operator::Between => "BETWEEN",
            Operator::Contains => "CONTAINS",
            Operator::Division => "DIVISION",
            Operator::EqualTo => "EQUAL_TO",
            Operator::GreaterThan => "GREATER_THAN",
            Operator::GreaterThanOrEqualTo => "GREATER_THAN_OR_EQUAL_TO",
            Operator::LessThan => "LESS_THAN",
            Operator::LessThanOrEqualTo => "LESS_THAN_OR_EQUAL_TO",
            Operator::MaskAll => "MASK_ALL",
            Operator::MaskFirstN => "MASK_FIRST_N",
            Operator::MaskLastN => "MASK_LAST_N",
            Operator::Multiplication => "MULTIPLICATION",
            Operator::NotEqualTo => "NOT_EQUAL_TO",
            Operator::NoOp => "NO_OP",
            Operator::Projection => "PROJECTION",
            Operator::Subtraction => "SUBTRACTION",
            Operator::ValidateNonNegative => "VALIDATE_NON_NEGATIVE",
            Operator::ValidateNonNull => "VALIDATE_NON_NULL",
            Operator::ValidateNonZero => "VALIDATE_NON_ZERO",
            Operator::ValidateNumeric => "VALIDATE_NUMERIC",
            Operator::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ADDITION",
            "BETWEEN",
            "CONTAINS",
            "DIVISION",
            "EQUAL_TO",
            "GREATER_THAN",
            "GREATER_THAN_OR_EQUAL_TO",
            "LESS_THAN",
            "LESS_THAN_OR_EQUAL_TO",
            "MASK_ALL",
            "MASK_FIRST_N",
            "MASK_LAST_N",
            "MULTIPLICATION",
            "NOT_EQUAL_TO",
            "NO_OP",
            "PROJECTION",
            "SUBTRACTION",
            "VALIDATE_NON_NEGATIVE",
            "VALIDATE_NON_NULL",
            "VALIDATE_NON_ZERO",
            "VALIDATE_NUMERIC",
        ]
    }
}
impl AsRef<str> for Operator {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SapoDataConnectorOperator {
    #[allow(missing_docs)] // documentation missing in model
    Addition,
    #[allow(missing_docs)] // documentation missing in model
    Between,
    #[allow(missing_docs)] // documentation missing in model
    Contains,
    #[allow(missing_docs)] // documentation missing in model
    Division,
    #[allow(missing_docs)] // documentation missing in model
    EqualTo,
    #[allow(missing_docs)] // documentation missing in model
    GreaterThan,
    #[allow(missing_docs)] // documentation missing in model
    GreaterThanOrEqualTo,
    #[allow(missing_docs)] // documentation missing in model
    LessThan,
    #[allow(missing_docs)] // documentation missing in model
    LessThanOrEqualTo,
    #[allow(missing_docs)] // documentation missing in model
    MaskAll,
    #[allow(missing_docs)] // documentation missing in model
    MaskFirstN,
    #[allow(missing_docs)] // documentation missing in model
    MaskLastN,
    #[allow(missing_docs)] // documentation missing in model
    Multiplication,
    #[allow(missing_docs)] // documentation missing in model
    NotEqualTo,
    #[allow(missing_docs)] // documentation missing in model
    NoOp,
    #[allow(missing_docs)] // documentation missing in model
    Projection,
    #[allow(missing_docs)] // documentation missing in model
    Subtraction,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNonNegative,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNonNull,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNonZero,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNumeric,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SapoDataConnectorOperator {
    fn from(s: &str) -> Self {
        match s {
            "ADDITION" => SapoDataConnectorOperator::Addition,
            "BETWEEN" => SapoDataConnectorOperator::Between,
            "CONTAINS" => SapoDataConnectorOperator::Contains,
            "DIVISION" => SapoDataConnectorOperator::Division,
            "EQUAL_TO" => SapoDataConnectorOperator::EqualTo,
            "GREATER_THAN" => SapoDataConnectorOperator::GreaterThan,
            "GREATER_THAN_OR_EQUAL_TO" => SapoDataConnectorOperator::GreaterThanOrEqualTo,
            "LESS_THAN" => SapoDataConnectorOperator::LessThan,
            "LESS_THAN_OR_EQUAL_TO" => SapoDataConnectorOperator::LessThanOrEqualTo,
            "MASK_ALL" => SapoDataConnectorOperator::MaskAll,
            "MASK_FIRST_N" => SapoDataConnectorOperator::MaskFirstN,
            "MASK_LAST_N" => SapoDataConnectorOperator::MaskLastN,
            "MULTIPLICATION" => SapoDataConnectorOperator::Multiplication,
            "NOT_EQUAL_TO" => SapoDataConnectorOperator::NotEqualTo,
            "NO_OP" => SapoDataConnectorOperator::NoOp,
            "PROJECTION" => SapoDataConnectorOperator::Projection,
            "SUBTRACTION" => SapoDataConnectorOperator::Subtraction,
            "VALIDATE_NON_NEGATIVE" => SapoDataConnectorOperator::ValidateNonNegative,
            "VALIDATE_NON_NULL" => SapoDataConnectorOperator::ValidateNonNull,
            "VALIDATE_NON_ZERO" => SapoDataConnectorOperator::ValidateNonZero,
            "VALIDATE_NUMERIC" => SapoDataConnectorOperator::ValidateNumeric,
            other => SapoDataConnectorOperator::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SapoDataConnectorOperator {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SapoDataConnectorOperator::from(s))
    }
}
impl SapoDataConnectorOperator {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SapoDataConnectorOperator::Addition => "ADDITION",
            SapoDataConnectorOperator::Between => "BETWEEN",
            SapoDataConnectorOperator::Contains => "CONTAINS",
            SapoDataConnectorOperator::Division => "DIVISION",
            SapoDataConnectorOperator::EqualTo => "EQUAL_TO",
            SapoDataConnectorOperator::GreaterThan => "GREATER_THAN",
            SapoDataConnectorOperator::GreaterThanOrEqualTo => "GREATER_THAN_OR_EQUAL_TO",
            SapoDataConnectorOperator::LessThan => "LESS_THAN",
            SapoDataConnectorOperator::LessThanOrEqualTo => "LESS_THAN_OR_EQUAL_TO",
            SapoDataConnectorOperator::MaskAll => "MASK_ALL",
            SapoDataConnectorOperator::MaskFirstN => "MASK_FIRST_N",
            SapoDataConnectorOperator::MaskLastN => "MASK_LAST_N",
            SapoDataConnectorOperator::Multiplication => "MULTIPLICATION",
            SapoDataConnectorOperator::NotEqualTo => "NOT_EQUAL_TO",
            SapoDataConnectorOperator::NoOp => "NO_OP",
            SapoDataConnectorOperator::Projection => "PROJECTION",
            SapoDataConnectorOperator::Subtraction => "SUBTRACTION",
            SapoDataConnectorOperator::ValidateNonNegative => "VALIDATE_NON_NEGATIVE",
            SapoDataConnectorOperator::ValidateNonNull => "VALIDATE_NON_NULL",
            SapoDataConnectorOperator::ValidateNonZero => "VALIDATE_NON_ZERO",
            SapoDataConnectorOperator::ValidateNumeric => "VALIDATE_NUMERIC",
            SapoDataConnectorOperator::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ADDITION",
            "BETWEEN",
            "CONTAINS",
            "DIVISION",
            "EQUAL_TO",
            "GREATER_THAN",
            "GREATER_THAN_OR_EQUAL_TO",
            "LESS_THAN",
            "LESS_THAN_OR_EQUAL_TO",
            "MASK_ALL",
            "MASK_FIRST_N",
            "MASK_LAST_N",
            "MULTIPLICATION",
            "NOT_EQUAL_TO",
            "NO_OP",
            "PROJECTION",
            "SUBTRACTION",
            "VALIDATE_NON_NEGATIVE",
            "VALIDATE_NON_NULL",
            "VALIDATE_NON_ZERO",
            "VALIDATE_NUMERIC",
        ]
    }
}
impl AsRef<str> for SapoDataConnectorOperator {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ZendeskConnectorOperator {
    #[allow(missing_docs)] // documentation missing in model
    Addition,
    #[allow(missing_docs)] // documentation missing in model
    Division,
    #[allow(missing_docs)] // documentation missing in model
    GreaterThan,
    #[allow(missing_docs)] // documentation missing in model
    MaskAll,
    #[allow(missing_docs)] // documentation missing in model
    MaskFirstN,
    #[allow(missing_docs)] // documentation missing in model
    MaskLastN,
    #[allow(missing_docs)] // documentation missing in model
    Multiplication,
    #[allow(missing_docs)] // documentation missing in model
    NoOp,
    #[allow(missing_docs)] // documentation missing in model
    Projection,
    #[allow(missing_docs)] // documentation missing in model
    Subtraction,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNonNegative,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNonNull,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNonZero,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNumeric,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ZendeskConnectorOperator {
    fn from(s: &str) -> Self {
        match s {
            "ADDITION" => ZendeskConnectorOperator::Addition,
            "DIVISION" => ZendeskConnectorOperator::Division,
            "GREATER_THAN" => ZendeskConnectorOperator::GreaterThan,
            "MASK_ALL" => ZendeskConnectorOperator::MaskAll,
            "MASK_FIRST_N" => ZendeskConnectorOperator::MaskFirstN,
            "MASK_LAST_N" => ZendeskConnectorOperator::MaskLastN,
            "MULTIPLICATION" => ZendeskConnectorOperator::Multiplication,
            "NO_OP" => ZendeskConnectorOperator::NoOp,
            "PROJECTION" => ZendeskConnectorOperator::Projection,
            "SUBTRACTION" => ZendeskConnectorOperator::Subtraction,
            "VALIDATE_NON_NEGATIVE" => ZendeskConnectorOperator::ValidateNonNegative,
            "VALIDATE_NON_NULL" => ZendeskConnectorOperator::ValidateNonNull,
            "VALIDATE_NON_ZERO" => ZendeskConnectorOperator::ValidateNonZero,
            "VALIDATE_NUMERIC" => ZendeskConnectorOperator::ValidateNumeric,
            other => ZendeskConnectorOperator::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ZendeskConnectorOperator {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ZendeskConnectorOperator::from(s))
    }
}
impl ZendeskConnectorOperator {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ZendeskConnectorOperator::Addition => "ADDITION",
            ZendeskConnectorOperator::Division => "DIVISION",
            ZendeskConnectorOperator::GreaterThan => "GREATER_THAN",
            ZendeskConnectorOperator::MaskAll => "MASK_ALL",
            ZendeskConnectorOperator::MaskFirstN => "MASK_FIRST_N",
            ZendeskConnectorOperator::MaskLastN => "MASK_LAST_N",
            ZendeskConnectorOperator::Multiplication => "MULTIPLICATION",
            ZendeskConnectorOperator::NoOp => "NO_OP",
            ZendeskConnectorOperator::Projection => "PROJECTION",
            ZendeskConnectorOperator::Subtraction => "SUBTRACTION",
            ZendeskConnectorOperator::ValidateNonNegative => "VALIDATE_NON_NEGATIVE",
            ZendeskConnectorOperator::ValidateNonNull => "VALIDATE_NON_NULL",
            ZendeskConnectorOperator::ValidateNonZero => "VALIDATE_NON_ZERO",
            ZendeskConnectorOperator::ValidateNumeric => "VALIDATE_NUMERIC",
            ZendeskConnectorOperator::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ADDITION",
            "DIVISION",
            "GREATER_THAN",
            "MASK_ALL",
            "MASK_FIRST_N",
            "MASK_LAST_N",
            "MULTIPLICATION",
            "NO_OP",
            "PROJECTION",
            "SUBTRACTION",
            "VALIDATE_NON_NEGATIVE",
            "VALIDATE_NON_NULL",
            "VALIDATE_NON_ZERO",
            "VALIDATE_NUMERIC",
        ]
    }
}
impl AsRef<str> for ZendeskConnectorOperator {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum VeevaConnectorOperator {
    #[allow(missing_docs)] // documentation missing in model
    Addition,
    #[allow(missing_docs)] // documentation missing in model
    Between,
    #[allow(missing_docs)] // documentation missing in model
    Contains,
    #[allow(missing_docs)] // documentation missing in model
    Division,
    #[allow(missing_docs)] // documentation missing in model
    EqualTo,
    #[allow(missing_docs)] // documentation missing in model
    GreaterThan,
    #[allow(missing_docs)] // documentation missing in model
    GreaterThanOrEqualTo,
    #[allow(missing_docs)] // documentation missing in model
    LessThan,
    #[allow(missing_docs)] // documentation missing in model
    LessThanOrEqualTo,
    #[allow(missing_docs)] // documentation missing in model
    MaskAll,
    #[allow(missing_docs)] // documentation missing in model
    MaskFirstN,
    #[allow(missing_docs)] // documentation missing in model
    MaskLastN,
    #[allow(missing_docs)] // documentation missing in model
    Multiplication,
    #[allow(missing_docs)] // documentation missing in model
    NotEqualTo,
    #[allow(missing_docs)] // documentation missing in model
    NoOp,
    #[allow(missing_docs)] // documentation missing in model
    Projection,
    #[allow(missing_docs)] // documentation missing in model
    Subtraction,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNonNegative,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNonNull,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNonZero,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNumeric,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for VeevaConnectorOperator {
    fn from(s: &str) -> Self {
        match s {
            "ADDITION" => VeevaConnectorOperator::Addition,
            "BETWEEN" => VeevaConnectorOperator::Between,
            "CONTAINS" => VeevaConnectorOperator::Contains,
            "DIVISION" => VeevaConnectorOperator::Division,
            "EQUAL_TO" => VeevaConnectorOperator::EqualTo,
            "GREATER_THAN" => VeevaConnectorOperator::GreaterThan,
            "GREATER_THAN_OR_EQUAL_TO" => VeevaConnectorOperator::GreaterThanOrEqualTo,
            "LESS_THAN" => VeevaConnectorOperator::LessThan,
            "LESS_THAN_OR_EQUAL_TO" => VeevaConnectorOperator::LessThanOrEqualTo,
            "MASK_ALL" => VeevaConnectorOperator::MaskAll,
            "MASK_FIRST_N" => VeevaConnectorOperator::MaskFirstN,
            "MASK_LAST_N" => VeevaConnectorOperator::MaskLastN,
            "MULTIPLICATION" => VeevaConnectorOperator::Multiplication,
            "NOT_EQUAL_TO" => VeevaConnectorOperator::NotEqualTo,
            "NO_OP" => VeevaConnectorOperator::NoOp,
            "PROJECTION" => VeevaConnectorOperator::Projection,
            "SUBTRACTION" => VeevaConnectorOperator::Subtraction,
            "VALIDATE_NON_NEGATIVE" => VeevaConnectorOperator::ValidateNonNegative,
            "VALIDATE_NON_NULL" => VeevaConnectorOperator::ValidateNonNull,
            "VALIDATE_NON_ZERO" => VeevaConnectorOperator::ValidateNonZero,
            "VALIDATE_NUMERIC" => VeevaConnectorOperator::ValidateNumeric,
            other => VeevaConnectorOperator::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for VeevaConnectorOperator {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(VeevaConnectorOperator::from(s))
    }
}
impl VeevaConnectorOperator {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            VeevaConnectorOperator::Addition => "ADDITION",
            VeevaConnectorOperator::Between => "BETWEEN",
            VeevaConnectorOperator::Contains => "CONTAINS",
            VeevaConnectorOperator::Division => "DIVISION",
            VeevaConnectorOperator::EqualTo => "EQUAL_TO",
            VeevaConnectorOperator::GreaterThan => "GREATER_THAN",
            VeevaConnectorOperator::GreaterThanOrEqualTo => "GREATER_THAN_OR_EQUAL_TO",
            VeevaConnectorOperator::LessThan => "LESS_THAN",
            VeevaConnectorOperator::LessThanOrEqualTo => "LESS_THAN_OR_EQUAL_TO",
            VeevaConnectorOperator::MaskAll => "MASK_ALL",
            VeevaConnectorOperator::MaskFirstN => "MASK_FIRST_N",
            VeevaConnectorOperator::MaskLastN => "MASK_LAST_N",
            VeevaConnectorOperator::Multiplication => "MULTIPLICATION",
            VeevaConnectorOperator::NotEqualTo => "NOT_EQUAL_TO",
            VeevaConnectorOperator::NoOp => "NO_OP",
            VeevaConnectorOperator::Projection => "PROJECTION",
            VeevaConnectorOperator::Subtraction => "SUBTRACTION",
            VeevaConnectorOperator::ValidateNonNegative => "VALIDATE_NON_NEGATIVE",
            VeevaConnectorOperator::ValidateNonNull => "VALIDATE_NON_NULL",
            VeevaConnectorOperator::ValidateNonZero => "VALIDATE_NON_ZERO",
            VeevaConnectorOperator::ValidateNumeric => "VALIDATE_NUMERIC",
            VeevaConnectorOperator::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ADDITION",
            "BETWEEN",
            "CONTAINS",
            "DIVISION",
            "EQUAL_TO",
            "GREATER_THAN",
            "GREATER_THAN_OR_EQUAL_TO",
            "LESS_THAN",
            "LESS_THAN_OR_EQUAL_TO",
            "MASK_ALL",
            "MASK_FIRST_N",
            "MASK_LAST_N",
            "MULTIPLICATION",
            "NOT_EQUAL_TO",
            "NO_OP",
            "PROJECTION",
            "SUBTRACTION",
            "VALIDATE_NON_NEGATIVE",
            "VALIDATE_NON_NULL",
            "VALIDATE_NON_ZERO",
            "VALIDATE_NUMERIC",
        ]
    }
}
impl AsRef<str> for VeevaConnectorOperator {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TrendmicroConnectorOperator {
    #[allow(missing_docs)] // documentation missing in model
    Addition,
    #[allow(missing_docs)] // documentation missing in model
    Division,
    #[allow(missing_docs)] // documentation missing in model
    EqualTo,
    #[allow(missing_docs)] // documentation missing in model
    MaskAll,
    #[allow(missing_docs)] // documentation missing in model
    MaskFirstN,
    #[allow(missing_docs)] // documentation missing in model
    MaskLastN,
    #[allow(missing_docs)] // documentation missing in model
    Multiplication,
    #[allow(missing_docs)] // documentation missing in model
    NoOp,
    #[allow(missing_docs)] // documentation missing in model
    Projection,
    #[allow(missing_docs)] // documentation missing in model
    Subtraction,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNonNegative,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNonNull,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNonZero,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNumeric,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TrendmicroConnectorOperator {
    fn from(s: &str) -> Self {
        match s {
            "ADDITION" => TrendmicroConnectorOperator::Addition,
            "DIVISION" => TrendmicroConnectorOperator::Division,
            "EQUAL_TO" => TrendmicroConnectorOperator::EqualTo,
            "MASK_ALL" => TrendmicroConnectorOperator::MaskAll,
            "MASK_FIRST_N" => TrendmicroConnectorOperator::MaskFirstN,
            "MASK_LAST_N" => TrendmicroConnectorOperator::MaskLastN,
            "MULTIPLICATION" => TrendmicroConnectorOperator::Multiplication,
            "NO_OP" => TrendmicroConnectorOperator::NoOp,
            "PROJECTION" => TrendmicroConnectorOperator::Projection,
            "SUBTRACTION" => TrendmicroConnectorOperator::Subtraction,
            "VALIDATE_NON_NEGATIVE" => TrendmicroConnectorOperator::ValidateNonNegative,
            "VALIDATE_NON_NULL" => TrendmicroConnectorOperator::ValidateNonNull,
            "VALIDATE_NON_ZERO" => TrendmicroConnectorOperator::ValidateNonZero,
            "VALIDATE_NUMERIC" => TrendmicroConnectorOperator::ValidateNumeric,
            other => TrendmicroConnectorOperator::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TrendmicroConnectorOperator {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TrendmicroConnectorOperator::from(s))
    }
}
impl TrendmicroConnectorOperator {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TrendmicroConnectorOperator::Addition => "ADDITION",
            TrendmicroConnectorOperator::Division => "DIVISION",
            TrendmicroConnectorOperator::EqualTo => "EQUAL_TO",
            TrendmicroConnectorOperator::MaskAll => "MASK_ALL",
            TrendmicroConnectorOperator::MaskFirstN => "MASK_FIRST_N",
            TrendmicroConnectorOperator::MaskLastN => "MASK_LAST_N",
            TrendmicroConnectorOperator::Multiplication => "MULTIPLICATION",
            TrendmicroConnectorOperator::NoOp => "NO_OP",
            TrendmicroConnectorOperator::Projection => "PROJECTION",
            TrendmicroConnectorOperator::Subtraction => "SUBTRACTION",
            TrendmicroConnectorOperator::ValidateNonNegative => "VALIDATE_NON_NEGATIVE",
            TrendmicroConnectorOperator::ValidateNonNull => "VALIDATE_NON_NULL",
            TrendmicroConnectorOperator::ValidateNonZero => "VALIDATE_NON_ZERO",
            TrendmicroConnectorOperator::ValidateNumeric => "VALIDATE_NUMERIC",
            TrendmicroConnectorOperator::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ADDITION",
            "DIVISION",
            "EQUAL_TO",
            "MASK_ALL",
            "MASK_FIRST_N",
            "MASK_LAST_N",
            "MULTIPLICATION",
            "NO_OP",
            "PROJECTION",
            "SUBTRACTION",
            "VALIDATE_NON_NEGATIVE",
            "VALIDATE_NON_NULL",
            "VALIDATE_NON_ZERO",
            "VALIDATE_NUMERIC",
        ]
    }
}
impl AsRef<str> for TrendmicroConnectorOperator {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SlackConnectorOperator {
    #[allow(missing_docs)] // documentation missing in model
    Addition,
    #[allow(missing_docs)] // documentation missing in model
    Between,
    #[allow(missing_docs)] // documentation missing in model
    Division,
    #[allow(missing_docs)] // documentation missing in model
    EqualTo,
    #[allow(missing_docs)] // documentation missing in model
    GreaterThan,
    #[allow(missing_docs)] // documentation missing in model
    GreaterThanOrEqualTo,
    #[allow(missing_docs)] // documentation missing in model
    LessThan,
    #[allow(missing_docs)] // documentation missing in model
    LessThanOrEqualTo,
    #[allow(missing_docs)] // documentation missing in model
    MaskAll,
    #[allow(missing_docs)] // documentation missing in model
    MaskFirstN,
    #[allow(missing_docs)] // documentation missing in model
    MaskLastN,
    #[allow(missing_docs)] // documentation missing in model
    Multiplication,
    #[allow(missing_docs)] // documentation missing in model
    NoOp,
    #[allow(missing_docs)] // documentation missing in model
    Projection,
    #[allow(missing_docs)] // documentation missing in model
    Subtraction,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNonNegative,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNonNull,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNonZero,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNumeric,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SlackConnectorOperator {
    fn from(s: &str) -> Self {
        match s {
            "ADDITION" => SlackConnectorOperator::Addition,
            "BETWEEN" => SlackConnectorOperator::Between,
            "DIVISION" => SlackConnectorOperator::Division,
            "EQUAL_TO" => SlackConnectorOperator::EqualTo,
            "GREATER_THAN" => SlackConnectorOperator::GreaterThan,
            "GREATER_THAN_OR_EQUAL_TO" => SlackConnectorOperator::GreaterThanOrEqualTo,
            "LESS_THAN" => SlackConnectorOperator::LessThan,
            "LESS_THAN_OR_EQUAL_TO" => SlackConnectorOperator::LessThanOrEqualTo,
            "MASK_ALL" => SlackConnectorOperator::MaskAll,
            "MASK_FIRST_N" => SlackConnectorOperator::MaskFirstN,
            "MASK_LAST_N" => SlackConnectorOperator::MaskLastN,
            "MULTIPLICATION" => SlackConnectorOperator::Multiplication,
            "NO_OP" => SlackConnectorOperator::NoOp,
            "PROJECTION" => SlackConnectorOperator::Projection,
            "SUBTRACTION" => SlackConnectorOperator::Subtraction,
            "VALIDATE_NON_NEGATIVE" => SlackConnectorOperator::ValidateNonNegative,
            "VALIDATE_NON_NULL" => SlackConnectorOperator::ValidateNonNull,
            "VALIDATE_NON_ZERO" => SlackConnectorOperator::ValidateNonZero,
            "VALIDATE_NUMERIC" => SlackConnectorOperator::ValidateNumeric,
            other => SlackConnectorOperator::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SlackConnectorOperator {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SlackConnectorOperator::from(s))
    }
}
impl SlackConnectorOperator {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SlackConnectorOperator::Addition => "ADDITION",
            SlackConnectorOperator::Between => "BETWEEN",
            SlackConnectorOperator::Division => "DIVISION",
            SlackConnectorOperator::EqualTo => "EQUAL_TO",
            SlackConnectorOperator::GreaterThan => "GREATER_THAN",
            SlackConnectorOperator::GreaterThanOrEqualTo => "GREATER_THAN_OR_EQUAL_TO",
            SlackConnectorOperator::LessThan => "LESS_THAN",
            SlackConnectorOperator::LessThanOrEqualTo => "LESS_THAN_OR_EQUAL_TO",
            SlackConnectorOperator::MaskAll => "MASK_ALL",
            SlackConnectorOperator::MaskFirstN => "MASK_FIRST_N",
            SlackConnectorOperator::MaskLastN => "MASK_LAST_N",
            SlackConnectorOperator::Multiplication => "MULTIPLICATION",
            SlackConnectorOperator::NoOp => "NO_OP",
            SlackConnectorOperator::Projection => "PROJECTION",
            SlackConnectorOperator::Subtraction => "SUBTRACTION",
            SlackConnectorOperator::ValidateNonNegative => "VALIDATE_NON_NEGATIVE",
            SlackConnectorOperator::ValidateNonNull => "VALIDATE_NON_NULL",
            SlackConnectorOperator::ValidateNonZero => "VALIDATE_NON_ZERO",
            SlackConnectorOperator::ValidateNumeric => "VALIDATE_NUMERIC",
            SlackConnectorOperator::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ADDITION",
            "BETWEEN",
            "DIVISION",
            "EQUAL_TO",
            "GREATER_THAN",
            "GREATER_THAN_OR_EQUAL_TO",
            "LESS_THAN",
            "LESS_THAN_OR_EQUAL_TO",
            "MASK_ALL",
            "MASK_FIRST_N",
            "MASK_LAST_N",
            "MULTIPLICATION",
            "NO_OP",
            "PROJECTION",
            "SUBTRACTION",
            "VALIDATE_NON_NEGATIVE",
            "VALIDATE_NON_NULL",
            "VALIDATE_NON_ZERO",
            "VALIDATE_NUMERIC",
        ]
    }
}
impl AsRef<str> for SlackConnectorOperator {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SingularConnectorOperator {
    #[allow(missing_docs)] // documentation missing in model
    Addition,
    #[allow(missing_docs)] // documentation missing in model
    Division,
    #[allow(missing_docs)] // documentation missing in model
    EqualTo,
    #[allow(missing_docs)] // documentation missing in model
    MaskAll,
    #[allow(missing_docs)] // documentation missing in model
    MaskFirstN,
    #[allow(missing_docs)] // documentation missing in model
    MaskLastN,
    #[allow(missing_docs)] // documentation missing in model
    Multiplication,
    #[allow(missing_docs)] // documentation missing in model
    NoOp,
    #[allow(missing_docs)] // documentation missing in model
    Projection,
    #[allow(missing_docs)] // documentation missing in model
    Subtraction,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNonNegative,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNonNull,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNonZero,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNumeric,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SingularConnectorOperator {
    fn from(s: &str) -> Self {
        match s {
            "ADDITION" => SingularConnectorOperator::Addition,
            "DIVISION" => SingularConnectorOperator::Division,
            "EQUAL_TO" => SingularConnectorOperator::EqualTo,
            "MASK_ALL" => SingularConnectorOperator::MaskAll,
            "MASK_FIRST_N" => SingularConnectorOperator::MaskFirstN,
            "MASK_LAST_N" => SingularConnectorOperator::MaskLastN,
            "MULTIPLICATION" => SingularConnectorOperator::Multiplication,
            "NO_OP" => SingularConnectorOperator::NoOp,
            "PROJECTION" => SingularConnectorOperator::Projection,
            "SUBTRACTION" => SingularConnectorOperator::Subtraction,
            "VALIDATE_NON_NEGATIVE" => SingularConnectorOperator::ValidateNonNegative,
            "VALIDATE_NON_NULL" => SingularConnectorOperator::ValidateNonNull,
            "VALIDATE_NON_ZERO" => SingularConnectorOperator::ValidateNonZero,
            "VALIDATE_NUMERIC" => SingularConnectorOperator::ValidateNumeric,
            other => SingularConnectorOperator::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SingularConnectorOperator {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SingularConnectorOperator::from(s))
    }
}
impl SingularConnectorOperator {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SingularConnectorOperator::Addition => "ADDITION",
            SingularConnectorOperator::Division => "DIVISION",
            SingularConnectorOperator::EqualTo => "EQUAL_TO",
            SingularConnectorOperator::MaskAll => "MASK_ALL",
            SingularConnectorOperator::MaskFirstN => "MASK_FIRST_N",
            SingularConnectorOperator::MaskLastN => "MASK_LAST_N",
            SingularConnectorOperator::Multiplication => "MULTIPLICATION",
            SingularConnectorOperator::NoOp => "NO_OP",
            SingularConnectorOperator::Projection => "PROJECTION",
            SingularConnectorOperator::Subtraction => "SUBTRACTION",
            SingularConnectorOperator::ValidateNonNegative => "VALIDATE_NON_NEGATIVE",
            SingularConnectorOperator::ValidateNonNull => "VALIDATE_NON_NULL",
            SingularConnectorOperator::ValidateNonZero => "VALIDATE_NON_ZERO",
            SingularConnectorOperator::ValidateNumeric => "VALIDATE_NUMERIC",
            SingularConnectorOperator::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ADDITION",
            "DIVISION",
            "EQUAL_TO",
            "MASK_ALL",
            "MASK_FIRST_N",
            "MASK_LAST_N",
            "MULTIPLICATION",
            "NO_OP",
            "PROJECTION",
            "SUBTRACTION",
            "VALIDATE_NON_NEGATIVE",
            "VALIDATE_NON_NULL",
            "VALIDATE_NON_ZERO",
            "VALIDATE_NUMERIC",
        ]
    }
}
impl AsRef<str> for SingularConnectorOperator {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ServiceNowConnectorOperator {
    #[allow(missing_docs)] // documentation missing in model
    Addition,
    #[allow(missing_docs)] // documentation missing in model
    Between,
    #[allow(missing_docs)] // documentation missing in model
    Contains,
    #[allow(missing_docs)] // documentation missing in model
    Division,
    #[allow(missing_docs)] // documentation missing in model
    EqualTo,
    #[allow(missing_docs)] // documentation missing in model
    GreaterThan,
    #[allow(missing_docs)] // documentation missing in model
    GreaterThanOrEqualTo,
    #[allow(missing_docs)] // documentation missing in model
    LessThan,
    #[allow(missing_docs)] // documentation missing in model
    LessThanOrEqualTo,
    #[allow(missing_docs)] // documentation missing in model
    MaskAll,
    #[allow(missing_docs)] // documentation missing in model
    MaskFirstN,
    #[allow(missing_docs)] // documentation missing in model
    MaskLastN,
    #[allow(missing_docs)] // documentation missing in model
    Multiplication,
    #[allow(missing_docs)] // documentation missing in model
    NotEqualTo,
    #[allow(missing_docs)] // documentation missing in model
    NoOp,
    #[allow(missing_docs)] // documentation missing in model
    Projection,
    #[allow(missing_docs)] // documentation missing in model
    Subtraction,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNonNegative,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNonNull,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNonZero,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNumeric,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ServiceNowConnectorOperator {
    fn from(s: &str) -> Self {
        match s {
            "ADDITION" => ServiceNowConnectorOperator::Addition,
            "BETWEEN" => ServiceNowConnectorOperator::Between,
            "CONTAINS" => ServiceNowConnectorOperator::Contains,
            "DIVISION" => ServiceNowConnectorOperator::Division,
            "EQUAL_TO" => ServiceNowConnectorOperator::EqualTo,
            "GREATER_THAN" => ServiceNowConnectorOperator::GreaterThan,
            "GREATER_THAN_OR_EQUAL_TO" => ServiceNowConnectorOperator::GreaterThanOrEqualTo,
            "LESS_THAN" => ServiceNowConnectorOperator::LessThan,
            "LESS_THAN_OR_EQUAL_TO" => ServiceNowConnectorOperator::LessThanOrEqualTo,
            "MASK_ALL" => ServiceNowConnectorOperator::MaskAll,
            "MASK_FIRST_N" => ServiceNowConnectorOperator::MaskFirstN,
            "MASK_LAST_N" => ServiceNowConnectorOperator::MaskLastN,
            "MULTIPLICATION" => ServiceNowConnectorOperator::Multiplication,
            "NOT_EQUAL_TO" => ServiceNowConnectorOperator::NotEqualTo,
            "NO_OP" => ServiceNowConnectorOperator::NoOp,
            "PROJECTION" => ServiceNowConnectorOperator::Projection,
            "SUBTRACTION" => ServiceNowConnectorOperator::Subtraction,
            "VALIDATE_NON_NEGATIVE" => ServiceNowConnectorOperator::ValidateNonNegative,
            "VALIDATE_NON_NULL" => ServiceNowConnectorOperator::ValidateNonNull,
            "VALIDATE_NON_ZERO" => ServiceNowConnectorOperator::ValidateNonZero,
            "VALIDATE_NUMERIC" => ServiceNowConnectorOperator::ValidateNumeric,
            other => ServiceNowConnectorOperator::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ServiceNowConnectorOperator {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ServiceNowConnectorOperator::from(s))
    }
}
impl ServiceNowConnectorOperator {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ServiceNowConnectorOperator::Addition => "ADDITION",
            ServiceNowConnectorOperator::Between => "BETWEEN",
            ServiceNowConnectorOperator::Contains => "CONTAINS",
            ServiceNowConnectorOperator::Division => "DIVISION",
            ServiceNowConnectorOperator::EqualTo => "EQUAL_TO",
            ServiceNowConnectorOperator::GreaterThan => "GREATER_THAN",
            ServiceNowConnectorOperator::GreaterThanOrEqualTo => "GREATER_THAN_OR_EQUAL_TO",
            ServiceNowConnectorOperator::LessThan => "LESS_THAN",
            ServiceNowConnectorOperator::LessThanOrEqualTo => "LESS_THAN_OR_EQUAL_TO",
            ServiceNowConnectorOperator::MaskAll => "MASK_ALL",
            ServiceNowConnectorOperator::MaskFirstN => "MASK_FIRST_N",
            ServiceNowConnectorOperator::MaskLastN => "MASK_LAST_N",
            ServiceNowConnectorOperator::Multiplication => "MULTIPLICATION",
            ServiceNowConnectorOperator::NotEqualTo => "NOT_EQUAL_TO",
            ServiceNowConnectorOperator::NoOp => "NO_OP",
            ServiceNowConnectorOperator::Projection => "PROJECTION",
            ServiceNowConnectorOperator::Subtraction => "SUBTRACTION",
            ServiceNowConnectorOperator::ValidateNonNegative => "VALIDATE_NON_NEGATIVE",
            ServiceNowConnectorOperator::ValidateNonNull => "VALIDATE_NON_NULL",
            ServiceNowConnectorOperator::ValidateNonZero => "VALIDATE_NON_ZERO",
            ServiceNowConnectorOperator::ValidateNumeric => "VALIDATE_NUMERIC",
            ServiceNowConnectorOperator::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ADDITION",
            "BETWEEN",
            "CONTAINS",
            "DIVISION",
            "EQUAL_TO",
            "GREATER_THAN",
            "GREATER_THAN_OR_EQUAL_TO",
            "LESS_THAN",
            "LESS_THAN_OR_EQUAL_TO",
            "MASK_ALL",
            "MASK_FIRST_N",
            "MASK_LAST_N",
            "MULTIPLICATION",
            "NOT_EQUAL_TO",
            "NO_OP",
            "PROJECTION",
            "SUBTRACTION",
            "VALIDATE_NON_NEGATIVE",
            "VALIDATE_NON_NULL",
            "VALIDATE_NON_ZERO",
            "VALIDATE_NUMERIC",
        ]
    }
}
impl AsRef<str> for ServiceNowConnectorOperator {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SalesforceConnectorOperator {
    #[allow(missing_docs)] // documentation missing in model
    Addition,
    #[allow(missing_docs)] // documentation missing in model
    Between,
    #[allow(missing_docs)] // documentation missing in model
    Contains,
    #[allow(missing_docs)] // documentation missing in model
    Division,
    #[allow(missing_docs)] // documentation missing in model
    EqualTo,
    #[allow(missing_docs)] // documentation missing in model
    GreaterThan,
    #[allow(missing_docs)] // documentation missing in model
    GreaterThanOrEqualTo,
    #[allow(missing_docs)] // documentation missing in model
    LessThan,
    #[allow(missing_docs)] // documentation missing in model
    LessThanOrEqualTo,
    #[allow(missing_docs)] // documentation missing in model
    MaskAll,
    #[allow(missing_docs)] // documentation missing in model
    MaskFirstN,
    #[allow(missing_docs)] // documentation missing in model
    MaskLastN,
    #[allow(missing_docs)] // documentation missing in model
    Multiplication,
    #[allow(missing_docs)] // documentation missing in model
    NotEqualTo,
    #[allow(missing_docs)] // documentation missing in model
    NoOp,
    #[allow(missing_docs)] // documentation missing in model
    Projection,
    #[allow(missing_docs)] // documentation missing in model
    Subtraction,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNonNegative,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNonNull,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNonZero,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNumeric,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SalesforceConnectorOperator {
    fn from(s: &str) -> Self {
        match s {
            "ADDITION" => SalesforceConnectorOperator::Addition,
            "BETWEEN" => SalesforceConnectorOperator::Between,
            "CONTAINS" => SalesforceConnectorOperator::Contains,
            "DIVISION" => SalesforceConnectorOperator::Division,
            "EQUAL_TO" => SalesforceConnectorOperator::EqualTo,
            "GREATER_THAN" => SalesforceConnectorOperator::GreaterThan,
            "GREATER_THAN_OR_EQUAL_TO" => SalesforceConnectorOperator::GreaterThanOrEqualTo,
            "LESS_THAN" => SalesforceConnectorOperator::LessThan,
            "LESS_THAN_OR_EQUAL_TO" => SalesforceConnectorOperator::LessThanOrEqualTo,
            "MASK_ALL" => SalesforceConnectorOperator::MaskAll,
            "MASK_FIRST_N" => SalesforceConnectorOperator::MaskFirstN,
            "MASK_LAST_N" => SalesforceConnectorOperator::MaskLastN,
            "MULTIPLICATION" => SalesforceConnectorOperator::Multiplication,
            "NOT_EQUAL_TO" => SalesforceConnectorOperator::NotEqualTo,
            "NO_OP" => SalesforceConnectorOperator::NoOp,
            "PROJECTION" => SalesforceConnectorOperator::Projection,
            "SUBTRACTION" => SalesforceConnectorOperator::Subtraction,
            "VALIDATE_NON_NEGATIVE" => SalesforceConnectorOperator::ValidateNonNegative,
            "VALIDATE_NON_NULL" => SalesforceConnectorOperator::ValidateNonNull,
            "VALIDATE_NON_ZERO" => SalesforceConnectorOperator::ValidateNonZero,
            "VALIDATE_NUMERIC" => SalesforceConnectorOperator::ValidateNumeric,
            other => SalesforceConnectorOperator::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SalesforceConnectorOperator {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SalesforceConnectorOperator::from(s))
    }
}
impl SalesforceConnectorOperator {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SalesforceConnectorOperator::Addition => "ADDITION",
            SalesforceConnectorOperator::Between => "BETWEEN",
            SalesforceConnectorOperator::Contains => "CONTAINS",
            SalesforceConnectorOperator::Division => "DIVISION",
            SalesforceConnectorOperator::EqualTo => "EQUAL_TO",
            SalesforceConnectorOperator::GreaterThan => "GREATER_THAN",
            SalesforceConnectorOperator::GreaterThanOrEqualTo => "GREATER_THAN_OR_EQUAL_TO",
            SalesforceConnectorOperator::LessThan => "LESS_THAN",
            SalesforceConnectorOperator::LessThanOrEqualTo => "LESS_THAN_OR_EQUAL_TO",
            SalesforceConnectorOperator::MaskAll => "MASK_ALL",
            SalesforceConnectorOperator::MaskFirstN => "MASK_FIRST_N",
            SalesforceConnectorOperator::MaskLastN => "MASK_LAST_N",
            SalesforceConnectorOperator::Multiplication => "MULTIPLICATION",
            SalesforceConnectorOperator::NotEqualTo => "NOT_EQUAL_TO",
            SalesforceConnectorOperator::NoOp => "NO_OP",
            SalesforceConnectorOperator::Projection => "PROJECTION",
            SalesforceConnectorOperator::Subtraction => "SUBTRACTION",
            SalesforceConnectorOperator::ValidateNonNegative => "VALIDATE_NON_NEGATIVE",
            SalesforceConnectorOperator::ValidateNonNull => "VALIDATE_NON_NULL",
            SalesforceConnectorOperator::ValidateNonZero => "VALIDATE_NON_ZERO",
            SalesforceConnectorOperator::ValidateNumeric => "VALIDATE_NUMERIC",
            SalesforceConnectorOperator::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ADDITION",
            "BETWEEN",
            "CONTAINS",
            "DIVISION",
            "EQUAL_TO",
            "GREATER_THAN",
            "GREATER_THAN_OR_EQUAL_TO",
            "LESS_THAN",
            "LESS_THAN_OR_EQUAL_TO",
            "MASK_ALL",
            "MASK_FIRST_N",
            "MASK_LAST_N",
            "MULTIPLICATION",
            "NOT_EQUAL_TO",
            "NO_OP",
            "PROJECTION",
            "SUBTRACTION",
            "VALIDATE_NON_NEGATIVE",
            "VALIDATE_NON_NULL",
            "VALIDATE_NON_ZERO",
            "VALIDATE_NUMERIC",
        ]
    }
}
impl AsRef<str> for SalesforceConnectorOperator {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum S3ConnectorOperator {
    #[allow(missing_docs)] // documentation missing in model
    Addition,
    #[allow(missing_docs)] // documentation missing in model
    Between,
    #[allow(missing_docs)] // documentation missing in model
    Division,
    #[allow(missing_docs)] // documentation missing in model
    EqualTo,
    #[allow(missing_docs)] // documentation missing in model
    GreaterThan,
    #[allow(missing_docs)] // documentation missing in model
    GreaterThanOrEqualTo,
    #[allow(missing_docs)] // documentation missing in model
    LessThan,
    #[allow(missing_docs)] // documentation missing in model
    LessThanOrEqualTo,
    #[allow(missing_docs)] // documentation missing in model
    MaskAll,
    #[allow(missing_docs)] // documentation missing in model
    MaskFirstN,
    #[allow(missing_docs)] // documentation missing in model
    MaskLastN,
    #[allow(missing_docs)] // documentation missing in model
    Multiplication,
    #[allow(missing_docs)] // documentation missing in model
    NotEqualTo,
    #[allow(missing_docs)] // documentation missing in model
    NoOp,
    #[allow(missing_docs)] // documentation missing in model
    Projection,
    #[allow(missing_docs)] // documentation missing in model
    Subtraction,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNonNegative,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNonNull,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNonZero,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNumeric,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for S3ConnectorOperator {
    fn from(s: &str) -> Self {
        match s {
            "ADDITION" => S3ConnectorOperator::Addition,
            "BETWEEN" => S3ConnectorOperator::Between,
            "DIVISION" => S3ConnectorOperator::Division,
            "EQUAL_TO" => S3ConnectorOperator::EqualTo,
            "GREATER_THAN" => S3ConnectorOperator::GreaterThan,
            "GREATER_THAN_OR_EQUAL_TO" => S3ConnectorOperator::GreaterThanOrEqualTo,
            "LESS_THAN" => S3ConnectorOperator::LessThan,
            "LESS_THAN_OR_EQUAL_TO" => S3ConnectorOperator::LessThanOrEqualTo,
            "MASK_ALL" => S3ConnectorOperator::MaskAll,
            "MASK_FIRST_N" => S3ConnectorOperator::MaskFirstN,
            "MASK_LAST_N" => S3ConnectorOperator::MaskLastN,
            "MULTIPLICATION" => S3ConnectorOperator::Multiplication,
            "NOT_EQUAL_TO" => S3ConnectorOperator::NotEqualTo,
            "NO_OP" => S3ConnectorOperator::NoOp,
            "PROJECTION" => S3ConnectorOperator::Projection,
            "SUBTRACTION" => S3ConnectorOperator::Subtraction,
            "VALIDATE_NON_NEGATIVE" => S3ConnectorOperator::ValidateNonNegative,
            "VALIDATE_NON_NULL" => S3ConnectorOperator::ValidateNonNull,
            "VALIDATE_NON_ZERO" => S3ConnectorOperator::ValidateNonZero,
            "VALIDATE_NUMERIC" => S3ConnectorOperator::ValidateNumeric,
            other => S3ConnectorOperator::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for S3ConnectorOperator {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(S3ConnectorOperator::from(s))
    }
}
impl S3ConnectorOperator {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            S3ConnectorOperator::Addition => "ADDITION",
            S3ConnectorOperator::Between => "BETWEEN",
            S3ConnectorOperator::Division => "DIVISION",
            S3ConnectorOperator::EqualTo => "EQUAL_TO",
            S3ConnectorOperator::GreaterThan => "GREATER_THAN",
            S3ConnectorOperator::GreaterThanOrEqualTo => "GREATER_THAN_OR_EQUAL_TO",
            S3ConnectorOperator::LessThan => "LESS_THAN",
            S3ConnectorOperator::LessThanOrEqualTo => "LESS_THAN_OR_EQUAL_TO",
            S3ConnectorOperator::MaskAll => "MASK_ALL",
            S3ConnectorOperator::MaskFirstN => "MASK_FIRST_N",
            S3ConnectorOperator::MaskLastN => "MASK_LAST_N",
            S3ConnectorOperator::Multiplication => "MULTIPLICATION",
            S3ConnectorOperator::NotEqualTo => "NOT_EQUAL_TO",
            S3ConnectorOperator::NoOp => "NO_OP",
            S3ConnectorOperator::Projection => "PROJECTION",
            S3ConnectorOperator::Subtraction => "SUBTRACTION",
            S3ConnectorOperator::ValidateNonNegative => "VALIDATE_NON_NEGATIVE",
            S3ConnectorOperator::ValidateNonNull => "VALIDATE_NON_NULL",
            S3ConnectorOperator::ValidateNonZero => "VALIDATE_NON_ZERO",
            S3ConnectorOperator::ValidateNumeric => "VALIDATE_NUMERIC",
            S3ConnectorOperator::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ADDITION",
            "BETWEEN",
            "DIVISION",
            "EQUAL_TO",
            "GREATER_THAN",
            "GREATER_THAN_OR_EQUAL_TO",
            "LESS_THAN",
            "LESS_THAN_OR_EQUAL_TO",
            "MASK_ALL",
            "MASK_FIRST_N",
            "MASK_LAST_N",
            "MULTIPLICATION",
            "NOT_EQUAL_TO",
            "NO_OP",
            "PROJECTION",
            "SUBTRACTION",
            "VALIDATE_NON_NEGATIVE",
            "VALIDATE_NON_NULL",
            "VALIDATE_NON_ZERO",
            "VALIDATE_NUMERIC",
        ]
    }
}
impl AsRef<str> for S3ConnectorOperator {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MarketoConnectorOperator {
    #[allow(missing_docs)] // documentation missing in model
    Addition,
    #[allow(missing_docs)] // documentation missing in model
    Between,
    #[allow(missing_docs)] // documentation missing in model
    Division,
    #[allow(missing_docs)] // documentation missing in model
    GreaterThan,
    #[allow(missing_docs)] // documentation missing in model
    LessThan,
    #[allow(missing_docs)] // documentation missing in model
    MaskAll,
    #[allow(missing_docs)] // documentation missing in model
    MaskFirstN,
    #[allow(missing_docs)] // documentation missing in model
    MaskLastN,
    #[allow(missing_docs)] // documentation missing in model
    Multiplication,
    #[allow(missing_docs)] // documentation missing in model
    NoOp,
    #[allow(missing_docs)] // documentation missing in model
    Projection,
    #[allow(missing_docs)] // documentation missing in model
    Subtraction,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNonNegative,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNonNull,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNonZero,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNumeric,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MarketoConnectorOperator {
    fn from(s: &str) -> Self {
        match s {
            "ADDITION" => MarketoConnectorOperator::Addition,
            "BETWEEN" => MarketoConnectorOperator::Between,
            "DIVISION" => MarketoConnectorOperator::Division,
            "GREATER_THAN" => MarketoConnectorOperator::GreaterThan,
            "LESS_THAN" => MarketoConnectorOperator::LessThan,
            "MASK_ALL" => MarketoConnectorOperator::MaskAll,
            "MASK_FIRST_N" => MarketoConnectorOperator::MaskFirstN,
            "MASK_LAST_N" => MarketoConnectorOperator::MaskLastN,
            "MULTIPLICATION" => MarketoConnectorOperator::Multiplication,
            "NO_OP" => MarketoConnectorOperator::NoOp,
            "PROJECTION" => MarketoConnectorOperator::Projection,
            "SUBTRACTION" => MarketoConnectorOperator::Subtraction,
            "VALIDATE_NON_NEGATIVE" => MarketoConnectorOperator::ValidateNonNegative,
            "VALIDATE_NON_NULL" => MarketoConnectorOperator::ValidateNonNull,
            "VALIDATE_NON_ZERO" => MarketoConnectorOperator::ValidateNonZero,
            "VALIDATE_NUMERIC" => MarketoConnectorOperator::ValidateNumeric,
            other => MarketoConnectorOperator::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MarketoConnectorOperator {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MarketoConnectorOperator::from(s))
    }
}
impl MarketoConnectorOperator {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MarketoConnectorOperator::Addition => "ADDITION",
            MarketoConnectorOperator::Between => "BETWEEN",
            MarketoConnectorOperator::Division => "DIVISION",
            MarketoConnectorOperator::GreaterThan => "GREATER_THAN",
            MarketoConnectorOperator::LessThan => "LESS_THAN",
            MarketoConnectorOperator::MaskAll => "MASK_ALL",
            MarketoConnectorOperator::MaskFirstN => "MASK_FIRST_N",
            MarketoConnectorOperator::MaskLastN => "MASK_LAST_N",
            MarketoConnectorOperator::Multiplication => "MULTIPLICATION",
            MarketoConnectorOperator::NoOp => "NO_OP",
            MarketoConnectorOperator::Projection => "PROJECTION",
            MarketoConnectorOperator::Subtraction => "SUBTRACTION",
            MarketoConnectorOperator::ValidateNonNegative => "VALIDATE_NON_NEGATIVE",
            MarketoConnectorOperator::ValidateNonNull => "VALIDATE_NON_NULL",
            MarketoConnectorOperator::ValidateNonZero => "VALIDATE_NON_ZERO",
            MarketoConnectorOperator::ValidateNumeric => "VALIDATE_NUMERIC",
            MarketoConnectorOperator::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ADDITION",
            "BETWEEN",
            "DIVISION",
            "GREATER_THAN",
            "LESS_THAN",
            "MASK_ALL",
            "MASK_FIRST_N",
            "MASK_LAST_N",
            "MULTIPLICATION",
            "NO_OP",
            "PROJECTION",
            "SUBTRACTION",
            "VALIDATE_NON_NEGATIVE",
            "VALIDATE_NON_NULL",
            "VALIDATE_NON_ZERO",
            "VALIDATE_NUMERIC",
        ]
    }
}
impl AsRef<str> for MarketoConnectorOperator {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InforNexusConnectorOperator {
    #[allow(missing_docs)] // documentation missing in model
    Addition,
    #[allow(missing_docs)] // documentation missing in model
    Between,
    #[allow(missing_docs)] // documentation missing in model
    Division,
    #[allow(missing_docs)] // documentation missing in model
    EqualTo,
    #[allow(missing_docs)] // documentation missing in model
    MaskAll,
    #[allow(missing_docs)] // documentation missing in model
    MaskFirstN,
    #[allow(missing_docs)] // documentation missing in model
    MaskLastN,
    #[allow(missing_docs)] // documentation missing in model
    Multiplication,
    #[allow(missing_docs)] // documentation missing in model
    NoOp,
    #[allow(missing_docs)] // documentation missing in model
    Projection,
    #[allow(missing_docs)] // documentation missing in model
    Subtraction,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNonNegative,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNonNull,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNonZero,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNumeric,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InforNexusConnectorOperator {
    fn from(s: &str) -> Self {
        match s {
            "ADDITION" => InforNexusConnectorOperator::Addition,
            "BETWEEN" => InforNexusConnectorOperator::Between,
            "DIVISION" => InforNexusConnectorOperator::Division,
            "EQUAL_TO" => InforNexusConnectorOperator::EqualTo,
            "MASK_ALL" => InforNexusConnectorOperator::MaskAll,
            "MASK_FIRST_N" => InforNexusConnectorOperator::MaskFirstN,
            "MASK_LAST_N" => InforNexusConnectorOperator::MaskLastN,
            "MULTIPLICATION" => InforNexusConnectorOperator::Multiplication,
            "NO_OP" => InforNexusConnectorOperator::NoOp,
            "PROJECTION" => InforNexusConnectorOperator::Projection,
            "SUBTRACTION" => InforNexusConnectorOperator::Subtraction,
            "VALIDATE_NON_NEGATIVE" => InforNexusConnectorOperator::ValidateNonNegative,
            "VALIDATE_NON_NULL" => InforNexusConnectorOperator::ValidateNonNull,
            "VALIDATE_NON_ZERO" => InforNexusConnectorOperator::ValidateNonZero,
            "VALIDATE_NUMERIC" => InforNexusConnectorOperator::ValidateNumeric,
            other => InforNexusConnectorOperator::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InforNexusConnectorOperator {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InforNexusConnectorOperator::from(s))
    }
}
impl InforNexusConnectorOperator {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InforNexusConnectorOperator::Addition => "ADDITION",
            InforNexusConnectorOperator::Between => "BETWEEN",
            InforNexusConnectorOperator::Division => "DIVISION",
            InforNexusConnectorOperator::EqualTo => "EQUAL_TO",
            InforNexusConnectorOperator::MaskAll => "MASK_ALL",
            InforNexusConnectorOperator::MaskFirstN => "MASK_FIRST_N",
            InforNexusConnectorOperator::MaskLastN => "MASK_LAST_N",
            InforNexusConnectorOperator::Multiplication => "MULTIPLICATION",
            InforNexusConnectorOperator::NoOp => "NO_OP",
            InforNexusConnectorOperator::Projection => "PROJECTION",
            InforNexusConnectorOperator::Subtraction => "SUBTRACTION",
            InforNexusConnectorOperator::ValidateNonNegative => "VALIDATE_NON_NEGATIVE",
            InforNexusConnectorOperator::ValidateNonNull => "VALIDATE_NON_NULL",
            InforNexusConnectorOperator::ValidateNonZero => "VALIDATE_NON_ZERO",
            InforNexusConnectorOperator::ValidateNumeric => "VALIDATE_NUMERIC",
            InforNexusConnectorOperator::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ADDITION",
            "BETWEEN",
            "DIVISION",
            "EQUAL_TO",
            "MASK_ALL",
            "MASK_FIRST_N",
            "MASK_LAST_N",
            "MULTIPLICATION",
            "NO_OP",
            "PROJECTION",
            "SUBTRACTION",
            "VALIDATE_NON_NEGATIVE",
            "VALIDATE_NON_NULL",
            "VALIDATE_NON_ZERO",
            "VALIDATE_NUMERIC",
        ]
    }
}
impl AsRef<str> for InforNexusConnectorOperator {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum GoogleAnalyticsConnectorOperator {
    #[allow(missing_docs)] // documentation missing in model
    Between,
    #[allow(missing_docs)] // documentation missing in model
    Projection,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for GoogleAnalyticsConnectorOperator {
    fn from(s: &str) -> Self {
        match s {
            "BETWEEN" => GoogleAnalyticsConnectorOperator::Between,
            "PROJECTION" => GoogleAnalyticsConnectorOperator::Projection,
            other => GoogleAnalyticsConnectorOperator::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for GoogleAnalyticsConnectorOperator {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(GoogleAnalyticsConnectorOperator::from(s))
    }
}
impl GoogleAnalyticsConnectorOperator {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            GoogleAnalyticsConnectorOperator::Between => "BETWEEN",
            GoogleAnalyticsConnectorOperator::Projection => "PROJECTION",
            GoogleAnalyticsConnectorOperator::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["BETWEEN", "PROJECTION"]
    }
}
impl AsRef<str> for GoogleAnalyticsConnectorOperator {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DynatraceConnectorOperator {
    #[allow(missing_docs)] // documentation missing in model
    Addition,
    #[allow(missing_docs)] // documentation missing in model
    Between,
    #[allow(missing_docs)] // documentation missing in model
    Division,
    #[allow(missing_docs)] // documentation missing in model
    EqualTo,
    #[allow(missing_docs)] // documentation missing in model
    MaskAll,
    #[allow(missing_docs)] // documentation missing in model
    MaskFirstN,
    #[allow(missing_docs)] // documentation missing in model
    MaskLastN,
    #[allow(missing_docs)] // documentation missing in model
    Multiplication,
    #[allow(missing_docs)] // documentation missing in model
    NoOp,
    #[allow(missing_docs)] // documentation missing in model
    Projection,
    #[allow(missing_docs)] // documentation missing in model
    Subtraction,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNonNegative,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNonNull,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNonZero,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNumeric,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DynatraceConnectorOperator {
    fn from(s: &str) -> Self {
        match s {
            "ADDITION" => DynatraceConnectorOperator::Addition,
            "BETWEEN" => DynatraceConnectorOperator::Between,
            "DIVISION" => DynatraceConnectorOperator::Division,
            "EQUAL_TO" => DynatraceConnectorOperator::EqualTo,
            "MASK_ALL" => DynatraceConnectorOperator::MaskAll,
            "MASK_FIRST_N" => DynatraceConnectorOperator::MaskFirstN,
            "MASK_LAST_N" => DynatraceConnectorOperator::MaskLastN,
            "MULTIPLICATION" => DynatraceConnectorOperator::Multiplication,
            "NO_OP" => DynatraceConnectorOperator::NoOp,
            "PROJECTION" => DynatraceConnectorOperator::Projection,
            "SUBTRACTION" => DynatraceConnectorOperator::Subtraction,
            "VALIDATE_NON_NEGATIVE" => DynatraceConnectorOperator::ValidateNonNegative,
            "VALIDATE_NON_NULL" => DynatraceConnectorOperator::ValidateNonNull,
            "VALIDATE_NON_ZERO" => DynatraceConnectorOperator::ValidateNonZero,
            "VALIDATE_NUMERIC" => DynatraceConnectorOperator::ValidateNumeric,
            other => DynatraceConnectorOperator::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DynatraceConnectorOperator {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DynatraceConnectorOperator::from(s))
    }
}
impl DynatraceConnectorOperator {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DynatraceConnectorOperator::Addition => "ADDITION",
            DynatraceConnectorOperator::Between => "BETWEEN",
            DynatraceConnectorOperator::Division => "DIVISION",
            DynatraceConnectorOperator::EqualTo => "EQUAL_TO",
            DynatraceConnectorOperator::MaskAll => "MASK_ALL",
            DynatraceConnectorOperator::MaskFirstN => "MASK_FIRST_N",
            DynatraceConnectorOperator::MaskLastN => "MASK_LAST_N",
            DynatraceConnectorOperator::Multiplication => "MULTIPLICATION",
            DynatraceConnectorOperator::NoOp => "NO_OP",
            DynatraceConnectorOperator::Projection => "PROJECTION",
            DynatraceConnectorOperator::Subtraction => "SUBTRACTION",
            DynatraceConnectorOperator::ValidateNonNegative => "VALIDATE_NON_NEGATIVE",
            DynatraceConnectorOperator::ValidateNonNull => "VALIDATE_NON_NULL",
            DynatraceConnectorOperator::ValidateNonZero => "VALIDATE_NON_ZERO",
            DynatraceConnectorOperator::ValidateNumeric => "VALIDATE_NUMERIC",
            DynatraceConnectorOperator::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ADDITION",
            "BETWEEN",
            "DIVISION",
            "EQUAL_TO",
            "MASK_ALL",
            "MASK_FIRST_N",
            "MASK_LAST_N",
            "MULTIPLICATION",
            "NO_OP",
            "PROJECTION",
            "SUBTRACTION",
            "VALIDATE_NON_NEGATIVE",
            "VALIDATE_NON_NULL",
            "VALIDATE_NON_ZERO",
            "VALIDATE_NUMERIC",
        ]
    }
}
impl AsRef<str> for DynatraceConnectorOperator {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DatadogConnectorOperator {
    #[allow(missing_docs)] // documentation missing in model
    Addition,
    #[allow(missing_docs)] // documentation missing in model
    Between,
    #[allow(missing_docs)] // documentation missing in model
    Division,
    #[allow(missing_docs)] // documentation missing in model
    EqualTo,
    #[allow(missing_docs)] // documentation missing in model
    MaskAll,
    #[allow(missing_docs)] // documentation missing in model
    MaskFirstN,
    #[allow(missing_docs)] // documentation missing in model
    MaskLastN,
    #[allow(missing_docs)] // documentation missing in model
    Multiplication,
    #[allow(missing_docs)] // documentation missing in model
    NoOp,
    #[allow(missing_docs)] // documentation missing in model
    Projection,
    #[allow(missing_docs)] // documentation missing in model
    Subtraction,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNonNegative,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNonNull,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNonZero,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNumeric,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DatadogConnectorOperator {
    fn from(s: &str) -> Self {
        match s {
            "ADDITION" => DatadogConnectorOperator::Addition,
            "BETWEEN" => DatadogConnectorOperator::Between,
            "DIVISION" => DatadogConnectorOperator::Division,
            "EQUAL_TO" => DatadogConnectorOperator::EqualTo,
            "MASK_ALL" => DatadogConnectorOperator::MaskAll,
            "MASK_FIRST_N" => DatadogConnectorOperator::MaskFirstN,
            "MASK_LAST_N" => DatadogConnectorOperator::MaskLastN,
            "MULTIPLICATION" => DatadogConnectorOperator::Multiplication,
            "NO_OP" => DatadogConnectorOperator::NoOp,
            "PROJECTION" => DatadogConnectorOperator::Projection,
            "SUBTRACTION" => DatadogConnectorOperator::Subtraction,
            "VALIDATE_NON_NEGATIVE" => DatadogConnectorOperator::ValidateNonNegative,
            "VALIDATE_NON_NULL" => DatadogConnectorOperator::ValidateNonNull,
            "VALIDATE_NON_ZERO" => DatadogConnectorOperator::ValidateNonZero,
            "VALIDATE_NUMERIC" => DatadogConnectorOperator::ValidateNumeric,
            other => DatadogConnectorOperator::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DatadogConnectorOperator {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DatadogConnectorOperator::from(s))
    }
}
impl DatadogConnectorOperator {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DatadogConnectorOperator::Addition => "ADDITION",
            DatadogConnectorOperator::Between => "BETWEEN",
            DatadogConnectorOperator::Division => "DIVISION",
            DatadogConnectorOperator::EqualTo => "EQUAL_TO",
            DatadogConnectorOperator::MaskAll => "MASK_ALL",
            DatadogConnectorOperator::MaskFirstN => "MASK_FIRST_N",
            DatadogConnectorOperator::MaskLastN => "MASK_LAST_N",
            DatadogConnectorOperator::Multiplication => "MULTIPLICATION",
            DatadogConnectorOperator::NoOp => "NO_OP",
            DatadogConnectorOperator::Projection => "PROJECTION",
            DatadogConnectorOperator::Subtraction => "SUBTRACTION",
            DatadogConnectorOperator::ValidateNonNegative => "VALIDATE_NON_NEGATIVE",
            DatadogConnectorOperator::ValidateNonNull => "VALIDATE_NON_NULL",
            DatadogConnectorOperator::ValidateNonZero => "VALIDATE_NON_ZERO",
            DatadogConnectorOperator::ValidateNumeric => "VALIDATE_NUMERIC",
            DatadogConnectorOperator::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ADDITION",
            "BETWEEN",
            "DIVISION",
            "EQUAL_TO",
            "MASK_ALL",
            "MASK_FIRST_N",
            "MASK_LAST_N",
            "MULTIPLICATION",
            "NO_OP",
            "PROJECTION",
            "SUBTRACTION",
            "VALIDATE_NON_NEGATIVE",
            "VALIDATE_NON_NULL",
            "VALIDATE_NON_ZERO",
            "VALIDATE_NUMERIC",
        ]
    }
}
impl AsRef<str> for DatadogConnectorOperator {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AmplitudeConnectorOperator {
    #[allow(missing_docs)] // documentation missing in model
    Between,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AmplitudeConnectorOperator {
    fn from(s: &str) -> Self {
        match s {
            "BETWEEN" => AmplitudeConnectorOperator::Between,
            other => AmplitudeConnectorOperator::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AmplitudeConnectorOperator {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AmplitudeConnectorOperator::from(s))
    }
}
impl AmplitudeConnectorOperator {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AmplitudeConnectorOperator::Between => "BETWEEN",
            AmplitudeConnectorOperator::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["BETWEEN"]
    }
}
impl AsRef<str> for AmplitudeConnectorOperator {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> Contains information about the configuration of destination connectors present in the flow. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DestinationFlowConfig {
    /// <p> The type of connector, such as Salesforce, Amplitude, and so on. </p>
    pub connector_type: std::option::Option<crate::model::ConnectorType>,
    /// <p>The API version that the destination connector uses.</p>
    pub api_version: std::option::Option<std::string::String>,
    /// <p> The name of the connector profile. This name must be unique for each connector profile in the Amazon Web Services account. </p>
    pub connector_profile_name: std::option::Option<std::string::String>,
    /// <p> This stores the information that is required to query a particular connector. </p>
    pub destination_connector_properties:
        std::option::Option<crate::model::DestinationConnectorProperties>,
}
impl DestinationFlowConfig {
    /// <p> The type of connector, such as Salesforce, Amplitude, and so on. </p>
    pub fn connector_type(&self) -> std::option::Option<&crate::model::ConnectorType> {
        self.connector_type.as_ref()
    }
    /// <p>The API version that the destination connector uses.</p>
    pub fn api_version(&self) -> std::option::Option<&str> {
        self.api_version.as_deref()
    }
    /// <p> The name of the connector profile. This name must be unique for each connector profile in the Amazon Web Services account. </p>
    pub fn connector_profile_name(&self) -> std::option::Option<&str> {
        self.connector_profile_name.as_deref()
    }
    /// <p> This stores the information that is required to query a particular connector. </p>
    pub fn destination_connector_properties(
        &self,
    ) -> std::option::Option<&crate::model::DestinationConnectorProperties> {
        self.destination_connector_properties.as_ref()
    }
}
impl std::fmt::Debug for DestinationFlowConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DestinationFlowConfig");
        formatter.field("connector_type", &self.connector_type);
        formatter.field("api_version", &self.api_version);
        formatter.field("connector_profile_name", &self.connector_profile_name);
        formatter.field(
            "destination_connector_properties",
            &self.destination_connector_properties,
        );
        formatter.finish()
    }
}
/// See [`DestinationFlowConfig`](crate::model::DestinationFlowConfig)
pub mod destination_flow_config {
    /// A builder for [`DestinationFlowConfig`](crate::model::DestinationFlowConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connector_type: std::option::Option<crate::model::ConnectorType>,
        pub(crate) api_version: std::option::Option<std::string::String>,
        pub(crate) connector_profile_name: std::option::Option<std::string::String>,
        pub(crate) destination_connector_properties:
            std::option::Option<crate::model::DestinationConnectorProperties>,
    }
    impl Builder {
        /// <p> The type of connector, such as Salesforce, Amplitude, and so on. </p>
        pub fn connector_type(mut self, input: crate::model::ConnectorType) -> Self {
            self.connector_type = Some(input);
            self
        }
        /// <p> The type of connector, such as Salesforce, Amplitude, and so on. </p>
        pub fn set_connector_type(
            mut self,
            input: std::option::Option<crate::model::ConnectorType>,
        ) -> Self {
            self.connector_type = input;
            self
        }
        /// <p>The API version that the destination connector uses.</p>
        pub fn api_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_version = Some(input.into());
            self
        }
        /// <p>The API version that the destination connector uses.</p>
        pub fn set_api_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_version = input;
            self
        }
        /// <p> The name of the connector profile. This name must be unique for each connector profile in the Amazon Web Services account. </p>
        pub fn connector_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.connector_profile_name = Some(input.into());
            self
        }
        /// <p> The name of the connector profile. This name must be unique for each connector profile in the Amazon Web Services account. </p>
        pub fn set_connector_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connector_profile_name = input;
            self
        }
        /// <p> This stores the information that is required to query a particular connector. </p>
        pub fn destination_connector_properties(
            mut self,
            input: crate::model::DestinationConnectorProperties,
        ) -> Self {
            self.destination_connector_properties = Some(input);
            self
        }
        /// <p> This stores the information that is required to query a particular connector. </p>
        pub fn set_destination_connector_properties(
            mut self,
            input: std::option::Option<crate::model::DestinationConnectorProperties>,
        ) -> Self {
            self.destination_connector_properties = input;
            self
        }
        /// Consumes the builder and constructs a [`DestinationFlowConfig`](crate::model::DestinationFlowConfig)
        pub fn build(self) -> crate::model::DestinationFlowConfig {
            crate::model::DestinationFlowConfig {
                connector_type: self.connector_type,
                api_version: self.api_version,
                connector_profile_name: self.connector_profile_name,
                destination_connector_properties: self.destination_connector_properties,
            }
        }
    }
}
impl DestinationFlowConfig {
    /// Creates a new builder-style object to manufacture [`DestinationFlowConfig`](crate::model::DestinationFlowConfig)
    pub fn builder() -> crate::model::destination_flow_config::Builder {
        crate::model::destination_flow_config::Builder::default()
    }
}

/// <p> This stores the information that is required to query a particular connector. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DestinationConnectorProperties {
    /// <p> The properties required to query Amazon Redshift. </p>
    pub redshift: std::option::Option<crate::model::RedshiftDestinationProperties>,
    /// <p> The properties required to query Amazon S3. </p>
    pub s3: std::option::Option<crate::model::S3DestinationProperties>,
    /// <p> The properties required to query Salesforce. </p>
    pub salesforce: std::option::Option<crate::model::SalesforceDestinationProperties>,
    /// <p> The properties required to query Snowflake. </p>
    pub snowflake: std::option::Option<crate::model::SnowflakeDestinationProperties>,
    /// <p> The properties required to query Amazon EventBridge. </p>
    pub event_bridge: std::option::Option<crate::model::EventBridgeDestinationProperties>,
    /// <p> The properties required to query Amazon Lookout for Metrics. </p>
    pub lookout_metrics: std::option::Option<crate::model::LookoutMetricsDestinationProperties>,
    /// <p> The properties required to query Upsolver. </p>
    pub upsolver: std::option::Option<crate::model::UpsolverDestinationProperties>,
    /// <p> The properties required to query Amazon Honeycode. </p>
    pub honeycode: std::option::Option<crate::model::HoneycodeDestinationProperties>,
    /// <p> The properties required to query Amazon Connect Customer Profiles. </p>
    pub customer_profiles: std::option::Option<crate::model::CustomerProfilesDestinationProperties>,
    /// <p>The properties required to query Zendesk.</p>
    pub zendesk: std::option::Option<crate::model::ZendeskDestinationProperties>,
    /// <p>The properties required to query Marketo.</p>
    pub marketo: std::option::Option<crate::model::MarketoDestinationProperties>,
    /// <p>The properties that are required to query the custom Connector.</p>
    pub custom_connector: std::option::Option<crate::model::CustomConnectorDestinationProperties>,
    /// <p>The properties required to query SAPOData.</p>
    pub sapo_data: std::option::Option<crate::model::SapoDataDestinationProperties>,
}
impl DestinationConnectorProperties {
    /// <p> The properties required to query Amazon Redshift. </p>
    pub fn redshift(&self) -> std::option::Option<&crate::model::RedshiftDestinationProperties> {
        self.redshift.as_ref()
    }
    /// <p> The properties required to query Amazon S3. </p>
    pub fn s3(&self) -> std::option::Option<&crate::model::S3DestinationProperties> {
        self.s3.as_ref()
    }
    /// <p> The properties required to query Salesforce. </p>
    pub fn salesforce(
        &self,
    ) -> std::option::Option<&crate::model::SalesforceDestinationProperties> {
        self.salesforce.as_ref()
    }
    /// <p> The properties required to query Snowflake. </p>
    pub fn snowflake(&self) -> std::option::Option<&crate::model::SnowflakeDestinationProperties> {
        self.snowflake.as_ref()
    }
    /// <p> The properties required to query Amazon EventBridge. </p>
    pub fn event_bridge(
        &self,
    ) -> std::option::Option<&crate::model::EventBridgeDestinationProperties> {
        self.event_bridge.as_ref()
    }
    /// <p> The properties required to query Amazon Lookout for Metrics. </p>
    pub fn lookout_metrics(
        &self,
    ) -> std::option::Option<&crate::model::LookoutMetricsDestinationProperties> {
        self.lookout_metrics.as_ref()
    }
    /// <p> The properties required to query Upsolver. </p>
    pub fn upsolver(&self) -> std::option::Option<&crate::model::UpsolverDestinationProperties> {
        self.upsolver.as_ref()
    }
    /// <p> The properties required to query Amazon Honeycode. </p>
    pub fn honeycode(&self) -> std::option::Option<&crate::model::HoneycodeDestinationProperties> {
        self.honeycode.as_ref()
    }
    /// <p> The properties required to query Amazon Connect Customer Profiles. </p>
    pub fn customer_profiles(
        &self,
    ) -> std::option::Option<&crate::model::CustomerProfilesDestinationProperties> {
        self.customer_profiles.as_ref()
    }
    /// <p>The properties required to query Zendesk.</p>
    pub fn zendesk(&self) -> std::option::Option<&crate::model::ZendeskDestinationProperties> {
        self.zendesk.as_ref()
    }
    /// <p>The properties required to query Marketo.</p>
    pub fn marketo(&self) -> std::option::Option<&crate::model::MarketoDestinationProperties> {
        self.marketo.as_ref()
    }
    /// <p>The properties that are required to query the custom Connector.</p>
    pub fn custom_connector(
        &self,
    ) -> std::option::Option<&crate::model::CustomConnectorDestinationProperties> {
        self.custom_connector.as_ref()
    }
    /// <p>The properties required to query SAPOData.</p>
    pub fn sapo_data(&self) -> std::option::Option<&crate::model::SapoDataDestinationProperties> {
        self.sapo_data.as_ref()
    }
}
impl std::fmt::Debug for DestinationConnectorProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DestinationConnectorProperties");
        formatter.field("redshift", &self.redshift);
        formatter.field("s3", &self.s3);
        formatter.field("salesforce", &self.salesforce);
        formatter.field("snowflake", &self.snowflake);
        formatter.field("event_bridge", &self.event_bridge);
        formatter.field("lookout_metrics", &self.lookout_metrics);
        formatter.field("upsolver", &self.upsolver);
        formatter.field("honeycode", &self.honeycode);
        formatter.field("customer_profiles", &self.customer_profiles);
        formatter.field("zendesk", &self.zendesk);
        formatter.field("marketo", &self.marketo);
        formatter.field("custom_connector", &self.custom_connector);
        formatter.field("sapo_data", &self.sapo_data);
        formatter.finish()
    }
}
/// See [`DestinationConnectorProperties`](crate::model::DestinationConnectorProperties)
pub mod destination_connector_properties {
    /// A builder for [`DestinationConnectorProperties`](crate::model::DestinationConnectorProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) redshift: std::option::Option<crate::model::RedshiftDestinationProperties>,
        pub(crate) s3: std::option::Option<crate::model::S3DestinationProperties>,
        pub(crate) salesforce: std::option::Option<crate::model::SalesforceDestinationProperties>,
        pub(crate) snowflake: std::option::Option<crate::model::SnowflakeDestinationProperties>,
        pub(crate) event_bridge:
            std::option::Option<crate::model::EventBridgeDestinationProperties>,
        pub(crate) lookout_metrics:
            std::option::Option<crate::model::LookoutMetricsDestinationProperties>,
        pub(crate) upsolver: std::option::Option<crate::model::UpsolverDestinationProperties>,
        pub(crate) honeycode: std::option::Option<crate::model::HoneycodeDestinationProperties>,
        pub(crate) customer_profiles:
            std::option::Option<crate::model::CustomerProfilesDestinationProperties>,
        pub(crate) zendesk: std::option::Option<crate::model::ZendeskDestinationProperties>,
        pub(crate) marketo: std::option::Option<crate::model::MarketoDestinationProperties>,
        pub(crate) custom_connector:
            std::option::Option<crate::model::CustomConnectorDestinationProperties>,
        pub(crate) sapo_data: std::option::Option<crate::model::SapoDataDestinationProperties>,
    }
    impl Builder {
        /// <p> The properties required to query Amazon Redshift. </p>
        pub fn redshift(mut self, input: crate::model::RedshiftDestinationProperties) -> Self {
            self.redshift = Some(input);
            self
        }
        /// <p> The properties required to query Amazon Redshift. </p>
        pub fn set_redshift(
            mut self,
            input: std::option::Option<crate::model::RedshiftDestinationProperties>,
        ) -> Self {
            self.redshift = input;
            self
        }
        /// <p> The properties required to query Amazon S3. </p>
        pub fn s3(mut self, input: crate::model::S3DestinationProperties) -> Self {
            self.s3 = Some(input);
            self
        }
        /// <p> The properties required to query Amazon S3. </p>
        pub fn set_s3(
            mut self,
            input: std::option::Option<crate::model::S3DestinationProperties>,
        ) -> Self {
            self.s3 = input;
            self
        }
        /// <p> The properties required to query Salesforce. </p>
        pub fn salesforce(mut self, input: crate::model::SalesforceDestinationProperties) -> Self {
            self.salesforce = Some(input);
            self
        }
        /// <p> The properties required to query Salesforce. </p>
        pub fn set_salesforce(
            mut self,
            input: std::option::Option<crate::model::SalesforceDestinationProperties>,
        ) -> Self {
            self.salesforce = input;
            self
        }
        /// <p> The properties required to query Snowflake. </p>
        pub fn snowflake(mut self, input: crate::model::SnowflakeDestinationProperties) -> Self {
            self.snowflake = Some(input);
            self
        }
        /// <p> The properties required to query Snowflake. </p>
        pub fn set_snowflake(
            mut self,
            input: std::option::Option<crate::model::SnowflakeDestinationProperties>,
        ) -> Self {
            self.snowflake = input;
            self
        }
        /// <p> The properties required to query Amazon EventBridge. </p>
        pub fn event_bridge(
            mut self,
            input: crate::model::EventBridgeDestinationProperties,
        ) -> Self {
            self.event_bridge = Some(input);
            self
        }
        /// <p> The properties required to query Amazon EventBridge. </p>
        pub fn set_event_bridge(
            mut self,
            input: std::option::Option<crate::model::EventBridgeDestinationProperties>,
        ) -> Self {
            self.event_bridge = input;
            self
        }
        /// <p> The properties required to query Amazon Lookout for Metrics. </p>
        pub fn lookout_metrics(
            mut self,
            input: crate::model::LookoutMetricsDestinationProperties,
        ) -> Self {
            self.lookout_metrics = Some(input);
            self
        }
        /// <p> The properties required to query Amazon Lookout for Metrics. </p>
        pub fn set_lookout_metrics(
            mut self,
            input: std::option::Option<crate::model::LookoutMetricsDestinationProperties>,
        ) -> Self {
            self.lookout_metrics = input;
            self
        }
        /// <p> The properties required to query Upsolver. </p>
        pub fn upsolver(mut self, input: crate::model::UpsolverDestinationProperties) -> Self {
            self.upsolver = Some(input);
            self
        }
        /// <p> The properties required to query Upsolver. </p>
        pub fn set_upsolver(
            mut self,
            input: std::option::Option<crate::model::UpsolverDestinationProperties>,
        ) -> Self {
            self.upsolver = input;
            self
        }
        /// <p> The properties required to query Amazon Honeycode. </p>
        pub fn honeycode(mut self, input: crate::model::HoneycodeDestinationProperties) -> Self {
            self.honeycode = Some(input);
            self
        }
        /// <p> The properties required to query Amazon Honeycode. </p>
        pub fn set_honeycode(
            mut self,
            input: std::option::Option<crate::model::HoneycodeDestinationProperties>,
        ) -> Self {
            self.honeycode = input;
            self
        }
        /// <p> The properties required to query Amazon Connect Customer Profiles. </p>
        pub fn customer_profiles(
            mut self,
            input: crate::model::CustomerProfilesDestinationProperties,
        ) -> Self {
            self.customer_profiles = Some(input);
            self
        }
        /// <p> The properties required to query Amazon Connect Customer Profiles. </p>
        pub fn set_customer_profiles(
            mut self,
            input: std::option::Option<crate::model::CustomerProfilesDestinationProperties>,
        ) -> Self {
            self.customer_profiles = input;
            self
        }
        /// <p>The properties required to query Zendesk.</p>
        pub fn zendesk(mut self, input: crate::model::ZendeskDestinationProperties) -> Self {
            self.zendesk = Some(input);
            self
        }
        /// <p>The properties required to query Zendesk.</p>
        pub fn set_zendesk(
            mut self,
            input: std::option::Option<crate::model::ZendeskDestinationProperties>,
        ) -> Self {
            self.zendesk = input;
            self
        }
        /// <p>The properties required to query Marketo.</p>
        pub fn marketo(mut self, input: crate::model::MarketoDestinationProperties) -> Self {
            self.marketo = Some(input);
            self
        }
        /// <p>The properties required to query Marketo.</p>
        pub fn set_marketo(
            mut self,
            input: std::option::Option<crate::model::MarketoDestinationProperties>,
        ) -> Self {
            self.marketo = input;
            self
        }
        /// <p>The properties that are required to query the custom Connector.</p>
        pub fn custom_connector(
            mut self,
            input: crate::model::CustomConnectorDestinationProperties,
        ) -> Self {
            self.custom_connector = Some(input);
            self
        }
        /// <p>The properties that are required to query the custom Connector.</p>
        pub fn set_custom_connector(
            mut self,
            input: std::option::Option<crate::model::CustomConnectorDestinationProperties>,
        ) -> Self {
            self.custom_connector = input;
            self
        }
        /// <p>The properties required to query SAPOData.</p>
        pub fn sapo_data(mut self, input: crate::model::SapoDataDestinationProperties) -> Self {
            self.sapo_data = Some(input);
            self
        }
        /// <p>The properties required to query SAPOData.</p>
        pub fn set_sapo_data(
            mut self,
            input: std::option::Option<crate::model::SapoDataDestinationProperties>,
        ) -> Self {
            self.sapo_data = input;
            self
        }
        /// Consumes the builder and constructs a [`DestinationConnectorProperties`](crate::model::DestinationConnectorProperties)
        pub fn build(self) -> crate::model::DestinationConnectorProperties {
            crate::model::DestinationConnectorProperties {
                redshift: self.redshift,
                s3: self.s3,
                salesforce: self.salesforce,
                snowflake: self.snowflake,
                event_bridge: self.event_bridge,
                lookout_metrics: self.lookout_metrics,
                upsolver: self.upsolver,
                honeycode: self.honeycode,
                customer_profiles: self.customer_profiles,
                zendesk: self.zendesk,
                marketo: self.marketo,
                custom_connector: self.custom_connector,
                sapo_data: self.sapo_data,
            }
        }
    }
}
impl DestinationConnectorProperties {
    /// Creates a new builder-style object to manufacture [`DestinationConnectorProperties`](crate::model::DestinationConnectorProperties)
    pub fn builder() -> crate::model::destination_connector_properties::Builder {
        crate::model::destination_connector_properties::Builder::default()
    }
}

/// <p>The properties that are applied when using SAPOData as a flow destination</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SapoDataDestinationProperties {
    /// <p>The object path specified in the SAPOData flow destination.</p>
    pub object_path: std::option::Option<std::string::String>,
    /// <p>Determines how Amazon AppFlow handles the success response that it gets from the connector after placing data.</p>
    /// <p>For example, this setting would determine where to write the response from a destination connector upon a successful insert operation.</p>
    pub success_response_handling_config:
        std::option::Option<crate::model::SuccessResponseHandlingConfig>,
    /// <p> A list of field names that can be used as an ID field when performing a write operation. </p>
    pub id_field_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> The settings that determine how Amazon AppFlow handles an error when placing data in the destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details. </p>
    pub error_handling_config: std::option::Option<crate::model::ErrorHandlingConfig>,
    /// <p> The possible write operations in the destination connector. When this value is not provided, this defaults to the <code>INSERT</code> operation. </p>
    pub write_operation_type: std::option::Option<crate::model::WriteOperationType>,
}
impl SapoDataDestinationProperties {
    /// <p>The object path specified in the SAPOData flow destination.</p>
    pub fn object_path(&self) -> std::option::Option<&str> {
        self.object_path.as_deref()
    }
    /// <p>Determines how Amazon AppFlow handles the success response that it gets from the connector after placing data.</p>
    /// <p>For example, this setting would determine where to write the response from a destination connector upon a successful insert operation.</p>
    pub fn success_response_handling_config(
        &self,
    ) -> std::option::Option<&crate::model::SuccessResponseHandlingConfig> {
        self.success_response_handling_config.as_ref()
    }
    /// <p> A list of field names that can be used as an ID field when performing a write operation. </p>
    pub fn id_field_names(&self) -> std::option::Option<&[std::string::String]> {
        self.id_field_names.as_deref()
    }
    /// <p> The settings that determine how Amazon AppFlow handles an error when placing data in the destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details. </p>
    pub fn error_handling_config(&self) -> std::option::Option<&crate::model::ErrorHandlingConfig> {
        self.error_handling_config.as_ref()
    }
    /// <p> The possible write operations in the destination connector. When this value is not provided, this defaults to the <code>INSERT</code> operation. </p>
    pub fn write_operation_type(&self) -> std::option::Option<&crate::model::WriteOperationType> {
        self.write_operation_type.as_ref()
    }
}
impl std::fmt::Debug for SapoDataDestinationProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SapoDataDestinationProperties");
        formatter.field("object_path", &self.object_path);
        formatter.field(
            "success_response_handling_config",
            &self.success_response_handling_config,
        );
        formatter.field("id_field_names", &self.id_field_names);
        formatter.field("error_handling_config", &self.error_handling_config);
        formatter.field("write_operation_type", &self.write_operation_type);
        formatter.finish()
    }
}
/// See [`SapoDataDestinationProperties`](crate::model::SapoDataDestinationProperties)
pub mod sapo_data_destination_properties {
    /// A builder for [`SapoDataDestinationProperties`](crate::model::SapoDataDestinationProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) object_path: std::option::Option<std::string::String>,
        pub(crate) success_response_handling_config:
            std::option::Option<crate::model::SuccessResponseHandlingConfig>,
        pub(crate) id_field_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) error_handling_config: std::option::Option<crate::model::ErrorHandlingConfig>,
        pub(crate) write_operation_type: std::option::Option<crate::model::WriteOperationType>,
    }
    impl Builder {
        /// <p>The object path specified in the SAPOData flow destination.</p>
        pub fn object_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.object_path = Some(input.into());
            self
        }
        /// <p>The object path specified in the SAPOData flow destination.</p>
        pub fn set_object_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.object_path = input;
            self
        }
        /// <p>Determines how Amazon AppFlow handles the success response that it gets from the connector after placing data.</p>
        /// <p>For example, this setting would determine where to write the response from a destination connector upon a successful insert operation.</p>
        pub fn success_response_handling_config(
            mut self,
            input: crate::model::SuccessResponseHandlingConfig,
        ) -> Self {
            self.success_response_handling_config = Some(input);
            self
        }
        /// <p>Determines how Amazon AppFlow handles the success response that it gets from the connector after placing data.</p>
        /// <p>For example, this setting would determine where to write the response from a destination connector upon a successful insert operation.</p>
        pub fn set_success_response_handling_config(
            mut self,
            input: std::option::Option<crate::model::SuccessResponseHandlingConfig>,
        ) -> Self {
            self.success_response_handling_config = input;
            self
        }
        /// Appends an item to `id_field_names`.
        ///
        /// To override the contents of this collection use [`set_id_field_names`](Self::set_id_field_names).
        ///
        /// <p> A list of field names that can be used as an ID field when performing a write operation. </p>
        pub fn id_field_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.id_field_names.unwrap_or_default();
            v.push(input.into());
            self.id_field_names = Some(v);
            self
        }
        /// <p> A list of field names that can be used as an ID field when performing a write operation. </p>
        pub fn set_id_field_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.id_field_names = input;
            self
        }
        /// <p> The settings that determine how Amazon AppFlow handles an error when placing data in the destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details. </p>
        pub fn error_handling_config(mut self, input: crate::model::ErrorHandlingConfig) -> Self {
            self.error_handling_config = Some(input);
            self
        }
        /// <p> The settings that determine how Amazon AppFlow handles an error when placing data in the destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details. </p>
        pub fn set_error_handling_config(
            mut self,
            input: std::option::Option<crate::model::ErrorHandlingConfig>,
        ) -> Self {
            self.error_handling_config = input;
            self
        }
        /// <p> The possible write operations in the destination connector. When this value is not provided, this defaults to the <code>INSERT</code> operation. </p>
        pub fn write_operation_type(mut self, input: crate::model::WriteOperationType) -> Self {
            self.write_operation_type = Some(input);
            self
        }
        /// <p> The possible write operations in the destination connector. When this value is not provided, this defaults to the <code>INSERT</code> operation. </p>
        pub fn set_write_operation_type(
            mut self,
            input: std::option::Option<crate::model::WriteOperationType>,
        ) -> Self {
            self.write_operation_type = input;
            self
        }
        /// Consumes the builder and constructs a [`SapoDataDestinationProperties`](crate::model::SapoDataDestinationProperties)
        pub fn build(self) -> crate::model::SapoDataDestinationProperties {
            crate::model::SapoDataDestinationProperties {
                object_path: self.object_path,
                success_response_handling_config: self.success_response_handling_config,
                id_field_names: self.id_field_names,
                error_handling_config: self.error_handling_config,
                write_operation_type: self.write_operation_type,
            }
        }
    }
}
impl SapoDataDestinationProperties {
    /// Creates a new builder-style object to manufacture [`SapoDataDestinationProperties`](crate::model::SapoDataDestinationProperties)
    pub fn builder() -> crate::model::sapo_data_destination_properties::Builder {
        crate::model::sapo_data_destination_properties::Builder::default()
    }
}

/// <p> The possible write operations in the destination connector. When this value is not
/// provided, this defaults to the <code>INSERT</code> operation. </p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum WriteOperationType {
    #[allow(missing_docs)] // documentation missing in model
    Delete,
    #[allow(missing_docs)] // documentation missing in model
    Insert,
    #[allow(missing_docs)] // documentation missing in model
    Update,
    #[allow(missing_docs)] // documentation missing in model
    Upsert,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for WriteOperationType {
    fn from(s: &str) -> Self {
        match s {
            "DELETE" => WriteOperationType::Delete,
            "INSERT" => WriteOperationType::Insert,
            "UPDATE" => WriteOperationType::Update,
            "UPSERT" => WriteOperationType::Upsert,
            other => WriteOperationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for WriteOperationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(WriteOperationType::from(s))
    }
}
impl WriteOperationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            WriteOperationType::Delete => "DELETE",
            WriteOperationType::Insert => "INSERT",
            WriteOperationType::Update => "UPDATE",
            WriteOperationType::Upsert => "UPSERT",
            WriteOperationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DELETE", "INSERT", "UPDATE", "UPSERT"]
    }
}
impl AsRef<str> for WriteOperationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> The settings that determine how Amazon AppFlow handles an error when placing data in the destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ErrorHandlingConfig {
    /// <p> Specifies if the flow should fail after the first instance of a failure when attempting to place data in the destination. </p>
    pub fail_on_first_destination_error: bool,
    /// <p> Specifies the Amazon S3 bucket prefix. </p>
    pub bucket_prefix: std::option::Option<std::string::String>,
    /// <p> Specifies the name of the Amazon S3 bucket. </p>
    pub bucket_name: std::option::Option<std::string::String>,
}
impl ErrorHandlingConfig {
    /// <p> Specifies if the flow should fail after the first instance of a failure when attempting to place data in the destination. </p>
    pub fn fail_on_first_destination_error(&self) -> bool {
        self.fail_on_first_destination_error
    }
    /// <p> Specifies the Amazon S3 bucket prefix. </p>
    pub fn bucket_prefix(&self) -> std::option::Option<&str> {
        self.bucket_prefix.as_deref()
    }
    /// <p> Specifies the name of the Amazon S3 bucket. </p>
    pub fn bucket_name(&self) -> std::option::Option<&str> {
        self.bucket_name.as_deref()
    }
}
impl std::fmt::Debug for ErrorHandlingConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ErrorHandlingConfig");
        formatter.field(
            "fail_on_first_destination_error",
            &self.fail_on_first_destination_error,
        );
        formatter.field("bucket_prefix", &self.bucket_prefix);
        formatter.field("bucket_name", &self.bucket_name);
        formatter.finish()
    }
}
/// See [`ErrorHandlingConfig`](crate::model::ErrorHandlingConfig)
pub mod error_handling_config {
    /// A builder for [`ErrorHandlingConfig`](crate::model::ErrorHandlingConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fail_on_first_destination_error: std::option::Option<bool>,
        pub(crate) bucket_prefix: std::option::Option<std::string::String>,
        pub(crate) bucket_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> Specifies if the flow should fail after the first instance of a failure when attempting to place data in the destination. </p>
        pub fn fail_on_first_destination_error(mut self, input: bool) -> Self {
            self.fail_on_first_destination_error = Some(input);
            self
        }
        /// <p> Specifies if the flow should fail after the first instance of a failure when attempting to place data in the destination. </p>
        pub fn set_fail_on_first_destination_error(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.fail_on_first_destination_error = input;
            self
        }
        /// <p> Specifies the Amazon S3 bucket prefix. </p>
        pub fn bucket_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_prefix = Some(input.into());
            self
        }
        /// <p> Specifies the Amazon S3 bucket prefix. </p>
        pub fn set_bucket_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.bucket_prefix = input;
            self
        }
        /// <p> Specifies the name of the Amazon S3 bucket. </p>
        pub fn bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_name = Some(input.into());
            self
        }
        /// <p> Specifies the name of the Amazon S3 bucket. </p>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ErrorHandlingConfig`](crate::model::ErrorHandlingConfig)
        pub fn build(self) -> crate::model::ErrorHandlingConfig {
            crate::model::ErrorHandlingConfig {
                fail_on_first_destination_error: self
                    .fail_on_first_destination_error
                    .unwrap_or_default(),
                bucket_prefix: self.bucket_prefix,
                bucket_name: self.bucket_name,
            }
        }
    }
}
impl ErrorHandlingConfig {
    /// Creates a new builder-style object to manufacture [`ErrorHandlingConfig`](crate::model::ErrorHandlingConfig)
    pub fn builder() -> crate::model::error_handling_config::Builder {
        crate::model::error_handling_config::Builder::default()
    }
}

/// <p>Determines how Amazon AppFlow handles the success response that it gets from the connector after placing data.</p>
/// <p>For example, this setting would determine where to write the response from the destination connector upon a successful insert operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SuccessResponseHandlingConfig {
    /// <p>The Amazon S3 bucket prefix.</p>
    pub bucket_prefix: std::option::Option<std::string::String>,
    /// <p>The name of the Amazon S3 bucket.</p>
    pub bucket_name: std::option::Option<std::string::String>,
}
impl SuccessResponseHandlingConfig {
    /// <p>The Amazon S3 bucket prefix.</p>
    pub fn bucket_prefix(&self) -> std::option::Option<&str> {
        self.bucket_prefix.as_deref()
    }
    /// <p>The name of the Amazon S3 bucket.</p>
    pub fn bucket_name(&self) -> std::option::Option<&str> {
        self.bucket_name.as_deref()
    }
}
impl std::fmt::Debug for SuccessResponseHandlingConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SuccessResponseHandlingConfig");
        formatter.field("bucket_prefix", &self.bucket_prefix);
        formatter.field("bucket_name", &self.bucket_name);
        formatter.finish()
    }
}
/// See [`SuccessResponseHandlingConfig`](crate::model::SuccessResponseHandlingConfig)
pub mod success_response_handling_config {
    /// A builder for [`SuccessResponseHandlingConfig`](crate::model::SuccessResponseHandlingConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket_prefix: std::option::Option<std::string::String>,
        pub(crate) bucket_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon S3 bucket prefix.</p>
        pub fn bucket_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_prefix = Some(input.into());
            self
        }
        /// <p>The Amazon S3 bucket prefix.</p>
        pub fn set_bucket_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.bucket_prefix = input;
            self
        }
        /// <p>The name of the Amazon S3 bucket.</p>
        pub fn bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket.</p>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_name = input;
            self
        }
        /// Consumes the builder and constructs a [`SuccessResponseHandlingConfig`](crate::model::SuccessResponseHandlingConfig)
        pub fn build(self) -> crate::model::SuccessResponseHandlingConfig {
            crate::model::SuccessResponseHandlingConfig {
                bucket_prefix: self.bucket_prefix,
                bucket_name: self.bucket_name,
            }
        }
    }
}
impl SuccessResponseHandlingConfig {
    /// Creates a new builder-style object to manufacture [`SuccessResponseHandlingConfig`](crate::model::SuccessResponseHandlingConfig)
    pub fn builder() -> crate::model::success_response_handling_config::Builder {
        crate::model::success_response_handling_config::Builder::default()
    }
}

/// <p>The properties that are applied when the custom connector is being used as a destination.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomConnectorDestinationProperties {
    /// <p>The entity specified in the custom connector as a destination in the flow.</p>
    pub entity_name: std::option::Option<std::string::String>,
    /// <p>The settings that determine how Amazon AppFlow handles an error when placing data in the custom connector as destination.</p>
    pub error_handling_config: std::option::Option<crate::model::ErrorHandlingConfig>,
    /// <p>Specifies the type of write operation to be performed in the custom connector when it's used as destination.</p>
    pub write_operation_type: std::option::Option<crate::model::WriteOperationType>,
    /// <p>The name of the field that Amazon AppFlow uses as an ID when performing a write operation such as update, delete, or upsert.</p>
    pub id_field_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The custom properties that are specific to the connector when it's used as a destination in the flow.</p>
    pub custom_properties:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CustomConnectorDestinationProperties {
    /// <p>The entity specified in the custom connector as a destination in the flow.</p>
    pub fn entity_name(&self) -> std::option::Option<&str> {
        self.entity_name.as_deref()
    }
    /// <p>The settings that determine how Amazon AppFlow handles an error when placing data in the custom connector as destination.</p>
    pub fn error_handling_config(&self) -> std::option::Option<&crate::model::ErrorHandlingConfig> {
        self.error_handling_config.as_ref()
    }
    /// <p>Specifies the type of write operation to be performed in the custom connector when it's used as destination.</p>
    pub fn write_operation_type(&self) -> std::option::Option<&crate::model::WriteOperationType> {
        self.write_operation_type.as_ref()
    }
    /// <p>The name of the field that Amazon AppFlow uses as an ID when performing a write operation such as update, delete, or upsert.</p>
    pub fn id_field_names(&self) -> std::option::Option<&[std::string::String]> {
        self.id_field_names.as_deref()
    }
    /// <p>The custom properties that are specific to the connector when it's used as a destination in the flow.</p>
    pub fn custom_properties(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.custom_properties.as_ref()
    }
}
impl std::fmt::Debug for CustomConnectorDestinationProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomConnectorDestinationProperties");
        formatter.field("entity_name", &self.entity_name);
        formatter.field("error_handling_config", &self.error_handling_config);
        formatter.field("write_operation_type", &self.write_operation_type);
        formatter.field("id_field_names", &self.id_field_names);
        formatter.field("custom_properties", &self.custom_properties);
        formatter.finish()
    }
}
/// See [`CustomConnectorDestinationProperties`](crate::model::CustomConnectorDestinationProperties)
pub mod custom_connector_destination_properties {
    /// A builder for [`CustomConnectorDestinationProperties`](crate::model::CustomConnectorDestinationProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) entity_name: std::option::Option<std::string::String>,
        pub(crate) error_handling_config: std::option::Option<crate::model::ErrorHandlingConfig>,
        pub(crate) write_operation_type: std::option::Option<crate::model::WriteOperationType>,
        pub(crate) id_field_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) custom_properties: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The entity specified in the custom connector as a destination in the flow.</p>
        pub fn entity_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.entity_name = Some(input.into());
            self
        }
        /// <p>The entity specified in the custom connector as a destination in the flow.</p>
        pub fn set_entity_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.entity_name = input;
            self
        }
        /// <p>The settings that determine how Amazon AppFlow handles an error when placing data in the custom connector as destination.</p>
        pub fn error_handling_config(mut self, input: crate::model::ErrorHandlingConfig) -> Self {
            self.error_handling_config = Some(input);
            self
        }
        /// <p>The settings that determine how Amazon AppFlow handles an error when placing data in the custom connector as destination.</p>
        pub fn set_error_handling_config(
            mut self,
            input: std::option::Option<crate::model::ErrorHandlingConfig>,
        ) -> Self {
            self.error_handling_config = input;
            self
        }
        /// <p>Specifies the type of write operation to be performed in the custom connector when it's used as destination.</p>
        pub fn write_operation_type(mut self, input: crate::model::WriteOperationType) -> Self {
            self.write_operation_type = Some(input);
            self
        }
        /// <p>Specifies the type of write operation to be performed in the custom connector when it's used as destination.</p>
        pub fn set_write_operation_type(
            mut self,
            input: std::option::Option<crate::model::WriteOperationType>,
        ) -> Self {
            self.write_operation_type = input;
            self
        }
        /// Appends an item to `id_field_names`.
        ///
        /// To override the contents of this collection use [`set_id_field_names`](Self::set_id_field_names).
        ///
        /// <p>The name of the field that Amazon AppFlow uses as an ID when performing a write operation such as update, delete, or upsert.</p>
        pub fn id_field_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.id_field_names.unwrap_or_default();
            v.push(input.into());
            self.id_field_names = Some(v);
            self
        }
        /// <p>The name of the field that Amazon AppFlow uses as an ID when performing a write operation such as update, delete, or upsert.</p>
        pub fn set_id_field_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.id_field_names = input;
            self
        }
        /// Adds a key-value pair to `custom_properties`.
        ///
        /// To override the contents of this collection use [`set_custom_properties`](Self::set_custom_properties).
        ///
        /// <p>The custom properties that are specific to the connector when it's used as a destination in the flow.</p>
        pub fn custom_properties(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.custom_properties.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.custom_properties = Some(hash_map);
            self
        }
        /// <p>The custom properties that are specific to the connector when it's used as a destination in the flow.</p>
        pub fn set_custom_properties(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.custom_properties = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomConnectorDestinationProperties`](crate::model::CustomConnectorDestinationProperties)
        pub fn build(self) -> crate::model::CustomConnectorDestinationProperties {
            crate::model::CustomConnectorDestinationProperties {
                entity_name: self.entity_name,
                error_handling_config: self.error_handling_config,
                write_operation_type: self.write_operation_type,
                id_field_names: self.id_field_names,
                custom_properties: self.custom_properties,
            }
        }
    }
}
impl CustomConnectorDestinationProperties {
    /// Creates a new builder-style object to manufacture [`CustomConnectorDestinationProperties`](crate::model::CustomConnectorDestinationProperties)
    pub fn builder() -> crate::model::custom_connector_destination_properties::Builder {
        crate::model::custom_connector_destination_properties::Builder::default()
    }
}

/// <p>The properties that Amazon AppFlow applies when you use Marketo as a flow destination.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MarketoDestinationProperties {
    /// <p>The object specified in the Marketo flow destination.</p>
    pub object: std::option::Option<std::string::String>,
    /// <p> The settings that determine how Amazon AppFlow handles an error when placing data in the destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details. </p>
    pub error_handling_config: std::option::Option<crate::model::ErrorHandlingConfig>,
}
impl MarketoDestinationProperties {
    /// <p>The object specified in the Marketo flow destination.</p>
    pub fn object(&self) -> std::option::Option<&str> {
        self.object.as_deref()
    }
    /// <p> The settings that determine how Amazon AppFlow handles an error when placing data in the destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details. </p>
    pub fn error_handling_config(&self) -> std::option::Option<&crate::model::ErrorHandlingConfig> {
        self.error_handling_config.as_ref()
    }
}
impl std::fmt::Debug for MarketoDestinationProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MarketoDestinationProperties");
        formatter.field("object", &self.object);
        formatter.field("error_handling_config", &self.error_handling_config);
        formatter.finish()
    }
}
/// See [`MarketoDestinationProperties`](crate::model::MarketoDestinationProperties)
pub mod marketo_destination_properties {
    /// A builder for [`MarketoDestinationProperties`](crate::model::MarketoDestinationProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) object: std::option::Option<std::string::String>,
        pub(crate) error_handling_config: std::option::Option<crate::model::ErrorHandlingConfig>,
    }
    impl Builder {
        /// <p>The object specified in the Marketo flow destination.</p>
        pub fn object(mut self, input: impl Into<std::string::String>) -> Self {
            self.object = Some(input.into());
            self
        }
        /// <p>The object specified in the Marketo flow destination.</p>
        pub fn set_object(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.object = input;
            self
        }
        /// <p> The settings that determine how Amazon AppFlow handles an error when placing data in the destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details. </p>
        pub fn error_handling_config(mut self, input: crate::model::ErrorHandlingConfig) -> Self {
            self.error_handling_config = Some(input);
            self
        }
        /// <p> The settings that determine how Amazon AppFlow handles an error when placing data in the destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details. </p>
        pub fn set_error_handling_config(
            mut self,
            input: std::option::Option<crate::model::ErrorHandlingConfig>,
        ) -> Self {
            self.error_handling_config = input;
            self
        }
        /// Consumes the builder and constructs a [`MarketoDestinationProperties`](crate::model::MarketoDestinationProperties)
        pub fn build(self) -> crate::model::MarketoDestinationProperties {
            crate::model::MarketoDestinationProperties {
                object: self.object,
                error_handling_config: self.error_handling_config,
            }
        }
    }
}
impl MarketoDestinationProperties {
    /// Creates a new builder-style object to manufacture [`MarketoDestinationProperties`](crate::model::MarketoDestinationProperties)
    pub fn builder() -> crate::model::marketo_destination_properties::Builder {
        crate::model::marketo_destination_properties::Builder::default()
    }
}

/// <p>The properties that are applied when Zendesk is used as a destination.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ZendeskDestinationProperties {
    /// <p>The object specified in the Zendesk flow destination.</p>
    pub object: std::option::Option<std::string::String>,
    /// <p> A list of field names that can be used as an ID field when performing a write operation. </p>
    pub id_field_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> The settings that determine how Amazon AppFlow handles an error when placing data in the destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details. </p>
    pub error_handling_config: std::option::Option<crate::model::ErrorHandlingConfig>,
    /// <p> The possible write operations in the destination connector. When this value is not provided, this defaults to the <code>INSERT</code> operation. </p>
    pub write_operation_type: std::option::Option<crate::model::WriteOperationType>,
}
impl ZendeskDestinationProperties {
    /// <p>The object specified in the Zendesk flow destination.</p>
    pub fn object(&self) -> std::option::Option<&str> {
        self.object.as_deref()
    }
    /// <p> A list of field names that can be used as an ID field when performing a write operation. </p>
    pub fn id_field_names(&self) -> std::option::Option<&[std::string::String]> {
        self.id_field_names.as_deref()
    }
    /// <p> The settings that determine how Amazon AppFlow handles an error when placing data in the destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details. </p>
    pub fn error_handling_config(&self) -> std::option::Option<&crate::model::ErrorHandlingConfig> {
        self.error_handling_config.as_ref()
    }
    /// <p> The possible write operations in the destination connector. When this value is not provided, this defaults to the <code>INSERT</code> operation. </p>
    pub fn write_operation_type(&self) -> std::option::Option<&crate::model::WriteOperationType> {
        self.write_operation_type.as_ref()
    }
}
impl std::fmt::Debug for ZendeskDestinationProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ZendeskDestinationProperties");
        formatter.field("object", &self.object);
        formatter.field("id_field_names", &self.id_field_names);
        formatter.field("error_handling_config", &self.error_handling_config);
        formatter.field("write_operation_type", &self.write_operation_type);
        formatter.finish()
    }
}
/// See [`ZendeskDestinationProperties`](crate::model::ZendeskDestinationProperties)
pub mod zendesk_destination_properties {
    /// A builder for [`ZendeskDestinationProperties`](crate::model::ZendeskDestinationProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) object: std::option::Option<std::string::String>,
        pub(crate) id_field_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) error_handling_config: std::option::Option<crate::model::ErrorHandlingConfig>,
        pub(crate) write_operation_type: std::option::Option<crate::model::WriteOperationType>,
    }
    impl Builder {
        /// <p>The object specified in the Zendesk flow destination.</p>
        pub fn object(mut self, input: impl Into<std::string::String>) -> Self {
            self.object = Some(input.into());
            self
        }
        /// <p>The object specified in the Zendesk flow destination.</p>
        pub fn set_object(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.object = input;
            self
        }
        /// Appends an item to `id_field_names`.
        ///
        /// To override the contents of this collection use [`set_id_field_names`](Self::set_id_field_names).
        ///
        /// <p> A list of field names that can be used as an ID field when performing a write operation. </p>
        pub fn id_field_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.id_field_names.unwrap_or_default();
            v.push(input.into());
            self.id_field_names = Some(v);
            self
        }
        /// <p> A list of field names that can be used as an ID field when performing a write operation. </p>
        pub fn set_id_field_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.id_field_names = input;
            self
        }
        /// <p> The settings that determine how Amazon AppFlow handles an error when placing data in the destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details. </p>
        pub fn error_handling_config(mut self, input: crate::model::ErrorHandlingConfig) -> Self {
            self.error_handling_config = Some(input);
            self
        }
        /// <p> The settings that determine how Amazon AppFlow handles an error when placing data in the destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details. </p>
        pub fn set_error_handling_config(
            mut self,
            input: std::option::Option<crate::model::ErrorHandlingConfig>,
        ) -> Self {
            self.error_handling_config = input;
            self
        }
        /// <p> The possible write operations in the destination connector. When this value is not provided, this defaults to the <code>INSERT</code> operation. </p>
        pub fn write_operation_type(mut self, input: crate::model::WriteOperationType) -> Self {
            self.write_operation_type = Some(input);
            self
        }
        /// <p> The possible write operations in the destination connector. When this value is not provided, this defaults to the <code>INSERT</code> operation. </p>
        pub fn set_write_operation_type(
            mut self,
            input: std::option::Option<crate::model::WriteOperationType>,
        ) -> Self {
            self.write_operation_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ZendeskDestinationProperties`](crate::model::ZendeskDestinationProperties)
        pub fn build(self) -> crate::model::ZendeskDestinationProperties {
            crate::model::ZendeskDestinationProperties {
                object: self.object,
                id_field_names: self.id_field_names,
                error_handling_config: self.error_handling_config,
                write_operation_type: self.write_operation_type,
            }
        }
    }
}
impl ZendeskDestinationProperties {
    /// Creates a new builder-style object to manufacture [`ZendeskDestinationProperties`](crate::model::ZendeskDestinationProperties)
    pub fn builder() -> crate::model::zendesk_destination_properties::Builder {
        crate::model::zendesk_destination_properties::Builder::default()
    }
}

/// <p> The properties that are applied when Amazon Connect Customer Profiles is used as a destination. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomerProfilesDestinationProperties {
    /// <p> The unique name of the Amazon Connect Customer Profiles domain. </p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p> The object specified in the Amazon Connect Customer Profiles flow destination. </p>
    pub object_type_name: std::option::Option<std::string::String>,
}
impl CustomerProfilesDestinationProperties {
    /// <p> The unique name of the Amazon Connect Customer Profiles domain. </p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p> The object specified in the Amazon Connect Customer Profiles flow destination. </p>
    pub fn object_type_name(&self) -> std::option::Option<&str> {
        self.object_type_name.as_deref()
    }
}
impl std::fmt::Debug for CustomerProfilesDestinationProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomerProfilesDestinationProperties");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("object_type_name", &self.object_type_name);
        formatter.finish()
    }
}
/// See [`CustomerProfilesDestinationProperties`](crate::model::CustomerProfilesDestinationProperties)
pub mod customer_profiles_destination_properties {
    /// A builder for [`CustomerProfilesDestinationProperties`](crate::model::CustomerProfilesDestinationProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) object_type_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The unique name of the Amazon Connect Customer Profiles domain. </p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p> The unique name of the Amazon Connect Customer Profiles domain. </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p> The object specified in the Amazon Connect Customer Profiles flow destination. </p>
        pub fn object_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.object_type_name = Some(input.into());
            self
        }
        /// <p> The object specified in the Amazon Connect Customer Profiles flow destination. </p>
        pub fn set_object_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.object_type_name = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomerProfilesDestinationProperties`](crate::model::CustomerProfilesDestinationProperties)
        pub fn build(self) -> crate::model::CustomerProfilesDestinationProperties {
            crate::model::CustomerProfilesDestinationProperties {
                domain_name: self.domain_name,
                object_type_name: self.object_type_name,
            }
        }
    }
}
impl CustomerProfilesDestinationProperties {
    /// Creates a new builder-style object to manufacture [`CustomerProfilesDestinationProperties`](crate::model::CustomerProfilesDestinationProperties)
    pub fn builder() -> crate::model::customer_profiles_destination_properties::Builder {
        crate::model::customer_profiles_destination_properties::Builder::default()
    }
}

/// <p> The properties that are applied when Amazon Honeycode is used as a destination. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HoneycodeDestinationProperties {
    /// <p> The object specified in the Amazon Honeycode flow destination. </p>
    pub object: std::option::Option<std::string::String>,
    /// <p> The settings that determine how Amazon AppFlow handles an error when placing data in the destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details. </p>
    pub error_handling_config: std::option::Option<crate::model::ErrorHandlingConfig>,
}
impl HoneycodeDestinationProperties {
    /// <p> The object specified in the Amazon Honeycode flow destination. </p>
    pub fn object(&self) -> std::option::Option<&str> {
        self.object.as_deref()
    }
    /// <p> The settings that determine how Amazon AppFlow handles an error when placing data in the destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details. </p>
    pub fn error_handling_config(&self) -> std::option::Option<&crate::model::ErrorHandlingConfig> {
        self.error_handling_config.as_ref()
    }
}
impl std::fmt::Debug for HoneycodeDestinationProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HoneycodeDestinationProperties");
        formatter.field("object", &self.object);
        formatter.field("error_handling_config", &self.error_handling_config);
        formatter.finish()
    }
}
/// See [`HoneycodeDestinationProperties`](crate::model::HoneycodeDestinationProperties)
pub mod honeycode_destination_properties {
    /// A builder for [`HoneycodeDestinationProperties`](crate::model::HoneycodeDestinationProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) object: std::option::Option<std::string::String>,
        pub(crate) error_handling_config: std::option::Option<crate::model::ErrorHandlingConfig>,
    }
    impl Builder {
        /// <p> The object specified in the Amazon Honeycode flow destination. </p>
        pub fn object(mut self, input: impl Into<std::string::String>) -> Self {
            self.object = Some(input.into());
            self
        }
        /// <p> The object specified in the Amazon Honeycode flow destination. </p>
        pub fn set_object(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.object = input;
            self
        }
        /// <p> The settings that determine how Amazon AppFlow handles an error when placing data in the destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details. </p>
        pub fn error_handling_config(mut self, input: crate::model::ErrorHandlingConfig) -> Self {
            self.error_handling_config = Some(input);
            self
        }
        /// <p> The settings that determine how Amazon AppFlow handles an error when placing data in the destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details. </p>
        pub fn set_error_handling_config(
            mut self,
            input: std::option::Option<crate::model::ErrorHandlingConfig>,
        ) -> Self {
            self.error_handling_config = input;
            self
        }
        /// Consumes the builder and constructs a [`HoneycodeDestinationProperties`](crate::model::HoneycodeDestinationProperties)
        pub fn build(self) -> crate::model::HoneycodeDestinationProperties {
            crate::model::HoneycodeDestinationProperties {
                object: self.object,
                error_handling_config: self.error_handling_config,
            }
        }
    }
}
impl HoneycodeDestinationProperties {
    /// Creates a new builder-style object to manufacture [`HoneycodeDestinationProperties`](crate::model::HoneycodeDestinationProperties)
    pub fn builder() -> crate::model::honeycode_destination_properties::Builder {
        crate::model::honeycode_destination_properties::Builder::default()
    }
}

/// <p> The properties that are applied when Upsolver is used as a destination. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpsolverDestinationProperties {
    /// <p> The Upsolver Amazon S3 bucket name in which Amazon AppFlow places the transferred data. </p>
    pub bucket_name: std::option::Option<std::string::String>,
    /// <p> The object key for the destination Upsolver Amazon S3 bucket in which Amazon AppFlow places the files. </p>
    pub bucket_prefix: std::option::Option<std::string::String>,
    /// <p> The configuration that determines how data is formatted when Upsolver is used as the flow destination. </p>
    pub s3_output_format_config: std::option::Option<crate::model::UpsolverS3OutputFormatConfig>,
}
impl UpsolverDestinationProperties {
    /// <p> The Upsolver Amazon S3 bucket name in which Amazon AppFlow places the transferred data. </p>
    pub fn bucket_name(&self) -> std::option::Option<&str> {
        self.bucket_name.as_deref()
    }
    /// <p> The object key for the destination Upsolver Amazon S3 bucket in which Amazon AppFlow places the files. </p>
    pub fn bucket_prefix(&self) -> std::option::Option<&str> {
        self.bucket_prefix.as_deref()
    }
    /// <p> The configuration that determines how data is formatted when Upsolver is used as the flow destination. </p>
    pub fn s3_output_format_config(
        &self,
    ) -> std::option::Option<&crate::model::UpsolverS3OutputFormatConfig> {
        self.s3_output_format_config.as_ref()
    }
}
impl std::fmt::Debug for UpsolverDestinationProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpsolverDestinationProperties");
        formatter.field("bucket_name", &self.bucket_name);
        formatter.field("bucket_prefix", &self.bucket_prefix);
        formatter.field("s3_output_format_config", &self.s3_output_format_config);
        formatter.finish()
    }
}
/// See [`UpsolverDestinationProperties`](crate::model::UpsolverDestinationProperties)
pub mod upsolver_destination_properties {
    /// A builder for [`UpsolverDestinationProperties`](crate::model::UpsolverDestinationProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket_name: std::option::Option<std::string::String>,
        pub(crate) bucket_prefix: std::option::Option<std::string::String>,
        pub(crate) s3_output_format_config:
            std::option::Option<crate::model::UpsolverS3OutputFormatConfig>,
    }
    impl Builder {
        /// <p> The Upsolver Amazon S3 bucket name in which Amazon AppFlow places the transferred data. </p>
        pub fn bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_name = Some(input.into());
            self
        }
        /// <p> The Upsolver Amazon S3 bucket name in which Amazon AppFlow places the transferred data. </p>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_name = input;
            self
        }
        /// <p> The object key for the destination Upsolver Amazon S3 bucket in which Amazon AppFlow places the files. </p>
        pub fn bucket_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_prefix = Some(input.into());
            self
        }
        /// <p> The object key for the destination Upsolver Amazon S3 bucket in which Amazon AppFlow places the files. </p>
        pub fn set_bucket_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.bucket_prefix = input;
            self
        }
        /// <p> The configuration that determines how data is formatted when Upsolver is used as the flow destination. </p>
        pub fn s3_output_format_config(
            mut self,
            input: crate::model::UpsolverS3OutputFormatConfig,
        ) -> Self {
            self.s3_output_format_config = Some(input);
            self
        }
        /// <p> The configuration that determines how data is formatted when Upsolver is used as the flow destination. </p>
        pub fn set_s3_output_format_config(
            mut self,
            input: std::option::Option<crate::model::UpsolverS3OutputFormatConfig>,
        ) -> Self {
            self.s3_output_format_config = input;
            self
        }
        /// Consumes the builder and constructs a [`UpsolverDestinationProperties`](crate::model::UpsolverDestinationProperties)
        pub fn build(self) -> crate::model::UpsolverDestinationProperties {
            crate::model::UpsolverDestinationProperties {
                bucket_name: self.bucket_name,
                bucket_prefix: self.bucket_prefix,
                s3_output_format_config: self.s3_output_format_config,
            }
        }
    }
}
impl UpsolverDestinationProperties {
    /// Creates a new builder-style object to manufacture [`UpsolverDestinationProperties`](crate::model::UpsolverDestinationProperties)
    pub fn builder() -> crate::model::upsolver_destination_properties::Builder {
        crate::model::upsolver_destination_properties::Builder::default()
    }
}

/// <p> The configuration that determines how Amazon AppFlow formats the flow output data when Upsolver is used as the destination. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpsolverS3OutputFormatConfig {
    /// <p> Indicates the file type that Amazon AppFlow places in the Upsolver Amazon S3 bucket. </p>
    pub file_type: std::option::Option<crate::model::FileType>,
    /// <p> Determines the prefix that Amazon AppFlow applies to the destination folder name. You can name your destination folders according to the flow frequency and date. </p>
    pub prefix_config: std::option::Option<crate::model::PrefixConfig>,
    /// <p> The aggregation settings that you can use to customize the output format of your flow data. </p>
    pub aggregation_config: std::option::Option<crate::model::AggregationConfig>,
}
impl UpsolverS3OutputFormatConfig {
    /// <p> Indicates the file type that Amazon AppFlow places in the Upsolver Amazon S3 bucket. </p>
    pub fn file_type(&self) -> std::option::Option<&crate::model::FileType> {
        self.file_type.as_ref()
    }
    /// <p> Determines the prefix that Amazon AppFlow applies to the destination folder name. You can name your destination folders according to the flow frequency and date. </p>
    pub fn prefix_config(&self) -> std::option::Option<&crate::model::PrefixConfig> {
        self.prefix_config.as_ref()
    }
    /// <p> The aggregation settings that you can use to customize the output format of your flow data. </p>
    pub fn aggregation_config(&self) -> std::option::Option<&crate::model::AggregationConfig> {
        self.aggregation_config.as_ref()
    }
}
impl std::fmt::Debug for UpsolverS3OutputFormatConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpsolverS3OutputFormatConfig");
        formatter.field("file_type", &self.file_type);
        formatter.field("prefix_config", &self.prefix_config);
        formatter.field("aggregation_config", &self.aggregation_config);
        formatter.finish()
    }
}
/// See [`UpsolverS3OutputFormatConfig`](crate::model::UpsolverS3OutputFormatConfig)
pub mod upsolver_s3_output_format_config {
    /// A builder for [`UpsolverS3OutputFormatConfig`](crate::model::UpsolverS3OutputFormatConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_type: std::option::Option<crate::model::FileType>,
        pub(crate) prefix_config: std::option::Option<crate::model::PrefixConfig>,
        pub(crate) aggregation_config: std::option::Option<crate::model::AggregationConfig>,
    }
    impl Builder {
        /// <p> Indicates the file type that Amazon AppFlow places in the Upsolver Amazon S3 bucket. </p>
        pub fn file_type(mut self, input: crate::model::FileType) -> Self {
            self.file_type = Some(input);
            self
        }
        /// <p> Indicates the file type that Amazon AppFlow places in the Upsolver Amazon S3 bucket. </p>
        pub fn set_file_type(mut self, input: std::option::Option<crate::model::FileType>) -> Self {
            self.file_type = input;
            self
        }
        /// <p> Determines the prefix that Amazon AppFlow applies to the destination folder name. You can name your destination folders according to the flow frequency and date. </p>
        pub fn prefix_config(mut self, input: crate::model::PrefixConfig) -> Self {
            self.prefix_config = Some(input);
            self
        }
        /// <p> Determines the prefix that Amazon AppFlow applies to the destination folder name. You can name your destination folders according to the flow frequency and date. </p>
        pub fn set_prefix_config(
            mut self,
            input: std::option::Option<crate::model::PrefixConfig>,
        ) -> Self {
            self.prefix_config = input;
            self
        }
        /// <p> The aggregation settings that you can use to customize the output format of your flow data. </p>
        pub fn aggregation_config(mut self, input: crate::model::AggregationConfig) -> Self {
            self.aggregation_config = Some(input);
            self
        }
        /// <p> The aggregation settings that you can use to customize the output format of your flow data. </p>
        pub fn set_aggregation_config(
            mut self,
            input: std::option::Option<crate::model::AggregationConfig>,
        ) -> Self {
            self.aggregation_config = input;
            self
        }
        /// Consumes the builder and constructs a [`UpsolverS3OutputFormatConfig`](crate::model::UpsolverS3OutputFormatConfig)
        pub fn build(self) -> crate::model::UpsolverS3OutputFormatConfig {
            crate::model::UpsolverS3OutputFormatConfig {
                file_type: self.file_type,
                prefix_config: self.prefix_config,
                aggregation_config: self.aggregation_config,
            }
        }
    }
}
impl UpsolverS3OutputFormatConfig {
    /// Creates a new builder-style object to manufacture [`UpsolverS3OutputFormatConfig`](crate::model::UpsolverS3OutputFormatConfig)
    pub fn builder() -> crate::model::upsolver_s3_output_format_config::Builder {
        crate::model::upsolver_s3_output_format_config::Builder::default()
    }
}

/// <p> The aggregation settings that you can use to customize the output format of your flow data. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AggregationConfig {
    /// <p> Specifies whether Amazon AppFlow aggregates the flow records into a single file, or leave them unaggregated. </p>
    pub aggregation_type: std::option::Option<crate::model::AggregationType>,
}
impl AggregationConfig {
    /// <p> Specifies whether Amazon AppFlow aggregates the flow records into a single file, or leave them unaggregated. </p>
    pub fn aggregation_type(&self) -> std::option::Option<&crate::model::AggregationType> {
        self.aggregation_type.as_ref()
    }
}
impl std::fmt::Debug for AggregationConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AggregationConfig");
        formatter.field("aggregation_type", &self.aggregation_type);
        formatter.finish()
    }
}
/// See [`AggregationConfig`](crate::model::AggregationConfig)
pub mod aggregation_config {
    /// A builder for [`AggregationConfig`](crate::model::AggregationConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aggregation_type: std::option::Option<crate::model::AggregationType>,
    }
    impl Builder {
        /// <p> Specifies whether Amazon AppFlow aggregates the flow records into a single file, or leave them unaggregated. </p>
        pub fn aggregation_type(mut self, input: crate::model::AggregationType) -> Self {
            self.aggregation_type = Some(input);
            self
        }
        /// <p> Specifies whether Amazon AppFlow aggregates the flow records into a single file, or leave them unaggregated. </p>
        pub fn set_aggregation_type(
            mut self,
            input: std::option::Option<crate::model::AggregationType>,
        ) -> Self {
            self.aggregation_type = input;
            self
        }
        /// Consumes the builder and constructs a [`AggregationConfig`](crate::model::AggregationConfig)
        pub fn build(self) -> crate::model::AggregationConfig {
            crate::model::AggregationConfig {
                aggregation_type: self.aggregation_type,
            }
        }
    }
}
impl AggregationConfig {
    /// Creates a new builder-style object to manufacture [`AggregationConfig`](crate::model::AggregationConfig)
    pub fn builder() -> crate::model::aggregation_config::Builder {
        crate::model::aggregation_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AggregationType {
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    SingleFile,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AggregationType {
    fn from(s: &str) -> Self {
        match s {
            "None" => AggregationType::None,
            "SingleFile" => AggregationType::SingleFile,
            other => AggregationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AggregationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AggregationType::from(s))
    }
}
impl AggregationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AggregationType::None => "None",
            AggregationType::SingleFile => "SingleFile",
            AggregationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["None", "SingleFile"]
    }
}
impl AsRef<str> for AggregationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> Determines the prefix that Amazon AppFlow applies to the destination folder name. You can name your destination folders according to the flow frequency and date. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PrefixConfig {
    /// <p> Determines the format of the prefix, and whether it applies to the file name, file path, or both. </p>
    pub prefix_type: std::option::Option<crate::model::PrefixType>,
    /// <p> Determines the level of granularity that's included in the prefix. </p>
    pub prefix_format: std::option::Option<crate::model::PrefixFormat>,
}
impl PrefixConfig {
    /// <p> Determines the format of the prefix, and whether it applies to the file name, file path, or both. </p>
    pub fn prefix_type(&self) -> std::option::Option<&crate::model::PrefixType> {
        self.prefix_type.as_ref()
    }
    /// <p> Determines the level of granularity that's included in the prefix. </p>
    pub fn prefix_format(&self) -> std::option::Option<&crate::model::PrefixFormat> {
        self.prefix_format.as_ref()
    }
}
impl std::fmt::Debug for PrefixConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PrefixConfig");
        formatter.field("prefix_type", &self.prefix_type);
        formatter.field("prefix_format", &self.prefix_format);
        formatter.finish()
    }
}
/// See [`PrefixConfig`](crate::model::PrefixConfig)
pub mod prefix_config {
    /// A builder for [`PrefixConfig`](crate::model::PrefixConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) prefix_type: std::option::Option<crate::model::PrefixType>,
        pub(crate) prefix_format: std::option::Option<crate::model::PrefixFormat>,
    }
    impl Builder {
        /// <p> Determines the format of the prefix, and whether it applies to the file name, file path, or both. </p>
        pub fn prefix_type(mut self, input: crate::model::PrefixType) -> Self {
            self.prefix_type = Some(input);
            self
        }
        /// <p> Determines the format of the prefix, and whether it applies to the file name, file path, or both. </p>
        pub fn set_prefix_type(
            mut self,
            input: std::option::Option<crate::model::PrefixType>,
        ) -> Self {
            self.prefix_type = input;
            self
        }
        /// <p> Determines the level of granularity that's included in the prefix. </p>
        pub fn prefix_format(mut self, input: crate::model::PrefixFormat) -> Self {
            self.prefix_format = Some(input);
            self
        }
        /// <p> Determines the level of granularity that's included in the prefix. </p>
        pub fn set_prefix_format(
            mut self,
            input: std::option::Option<crate::model::PrefixFormat>,
        ) -> Self {
            self.prefix_format = input;
            self
        }
        /// Consumes the builder and constructs a [`PrefixConfig`](crate::model::PrefixConfig)
        pub fn build(self) -> crate::model::PrefixConfig {
            crate::model::PrefixConfig {
                prefix_type: self.prefix_type,
                prefix_format: self.prefix_format,
            }
        }
    }
}
impl PrefixConfig {
    /// Creates a new builder-style object to manufacture [`PrefixConfig`](crate::model::PrefixConfig)
    pub fn builder() -> crate::model::prefix_config::Builder {
        crate::model::prefix_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PrefixFormat {
    #[allow(missing_docs)] // documentation missing in model
    Day,
    #[allow(missing_docs)] // documentation missing in model
    Hour,
    #[allow(missing_docs)] // documentation missing in model
    Minute,
    #[allow(missing_docs)] // documentation missing in model
    Month,
    #[allow(missing_docs)] // documentation missing in model
    Year,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PrefixFormat {
    fn from(s: &str) -> Self {
        match s {
            "DAY" => PrefixFormat::Day,
            "HOUR" => PrefixFormat::Hour,
            "MINUTE" => PrefixFormat::Minute,
            "MONTH" => PrefixFormat::Month,
            "YEAR" => PrefixFormat::Year,
            other => PrefixFormat::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PrefixFormat {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PrefixFormat::from(s))
    }
}
impl PrefixFormat {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PrefixFormat::Day => "DAY",
            PrefixFormat::Hour => "HOUR",
            PrefixFormat::Minute => "MINUTE",
            PrefixFormat::Month => "MONTH",
            PrefixFormat::Year => "YEAR",
            PrefixFormat::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DAY", "HOUR", "MINUTE", "MONTH", "YEAR"]
    }
}
impl AsRef<str> for PrefixFormat {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PrefixType {
    #[allow(missing_docs)] // documentation missing in model
    Filename,
    #[allow(missing_docs)] // documentation missing in model
    Path,
    #[allow(missing_docs)] // documentation missing in model
    PathAndFilename,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PrefixType {
    fn from(s: &str) -> Self {
        match s {
            "FILENAME" => PrefixType::Filename,
            "PATH" => PrefixType::Path,
            "PATH_AND_FILENAME" => PrefixType::PathAndFilename,
            other => PrefixType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PrefixType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PrefixType::from(s))
    }
}
impl PrefixType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PrefixType::Filename => "FILENAME",
            PrefixType::Path => "PATH",
            PrefixType::PathAndFilename => "PATH_AND_FILENAME",
            PrefixType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FILENAME", "PATH", "PATH_AND_FILENAME"]
    }
}
impl AsRef<str> for PrefixType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FileType {
    #[allow(missing_docs)] // documentation missing in model
    Csv,
    #[allow(missing_docs)] // documentation missing in model
    Json,
    #[allow(missing_docs)] // documentation missing in model
    Parquet,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FileType {
    fn from(s: &str) -> Self {
        match s {
            "CSV" => FileType::Csv,
            "JSON" => FileType::Json,
            "PARQUET" => FileType::Parquet,
            other => FileType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FileType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FileType::from(s))
    }
}
impl FileType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FileType::Csv => "CSV",
            FileType::Json => "JSON",
            FileType::Parquet => "PARQUET",
            FileType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CSV", "JSON", "PARQUET"]
    }
}
impl AsRef<str> for FileType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> The properties that are applied when Amazon Lookout for Metrics is used as a destination. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LookoutMetricsDestinationProperties {}
impl std::fmt::Debug for LookoutMetricsDestinationProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LookoutMetricsDestinationProperties");
        formatter.finish()
    }
}
/// See [`LookoutMetricsDestinationProperties`](crate::model::LookoutMetricsDestinationProperties)
pub mod lookout_metrics_destination_properties {
    /// A builder for [`LookoutMetricsDestinationProperties`](crate::model::LookoutMetricsDestinationProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`LookoutMetricsDestinationProperties`](crate::model::LookoutMetricsDestinationProperties)
        pub fn build(self) -> crate::model::LookoutMetricsDestinationProperties {
            crate::model::LookoutMetricsDestinationProperties {}
        }
    }
}
impl LookoutMetricsDestinationProperties {
    /// Creates a new builder-style object to manufacture [`LookoutMetricsDestinationProperties`](crate::model::LookoutMetricsDestinationProperties)
    pub fn builder() -> crate::model::lookout_metrics_destination_properties::Builder {
        crate::model::lookout_metrics_destination_properties::Builder::default()
    }
}

/// <p> The properties that are applied when Amazon EventBridge is being used as a destination. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventBridgeDestinationProperties {
    /// <p> The object specified in the Amazon EventBridge flow destination. </p>
    pub object: std::option::Option<std::string::String>,
    /// <p> The settings that determine how Amazon AppFlow handles an error when placing data in the destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details. </p>
    pub error_handling_config: std::option::Option<crate::model::ErrorHandlingConfig>,
}
impl EventBridgeDestinationProperties {
    /// <p> The object specified in the Amazon EventBridge flow destination. </p>
    pub fn object(&self) -> std::option::Option<&str> {
        self.object.as_deref()
    }
    /// <p> The settings that determine how Amazon AppFlow handles an error when placing data in the destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details. </p>
    pub fn error_handling_config(&self) -> std::option::Option<&crate::model::ErrorHandlingConfig> {
        self.error_handling_config.as_ref()
    }
}
impl std::fmt::Debug for EventBridgeDestinationProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventBridgeDestinationProperties");
        formatter.field("object", &self.object);
        formatter.field("error_handling_config", &self.error_handling_config);
        formatter.finish()
    }
}
/// See [`EventBridgeDestinationProperties`](crate::model::EventBridgeDestinationProperties)
pub mod event_bridge_destination_properties {
    /// A builder for [`EventBridgeDestinationProperties`](crate::model::EventBridgeDestinationProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) object: std::option::Option<std::string::String>,
        pub(crate) error_handling_config: std::option::Option<crate::model::ErrorHandlingConfig>,
    }
    impl Builder {
        /// <p> The object specified in the Amazon EventBridge flow destination. </p>
        pub fn object(mut self, input: impl Into<std::string::String>) -> Self {
            self.object = Some(input.into());
            self
        }
        /// <p> The object specified in the Amazon EventBridge flow destination. </p>
        pub fn set_object(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.object = input;
            self
        }
        /// <p> The settings that determine how Amazon AppFlow handles an error when placing data in the destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details. </p>
        pub fn error_handling_config(mut self, input: crate::model::ErrorHandlingConfig) -> Self {
            self.error_handling_config = Some(input);
            self
        }
        /// <p> The settings that determine how Amazon AppFlow handles an error when placing data in the destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details. </p>
        pub fn set_error_handling_config(
            mut self,
            input: std::option::Option<crate::model::ErrorHandlingConfig>,
        ) -> Self {
            self.error_handling_config = input;
            self
        }
        /// Consumes the builder and constructs a [`EventBridgeDestinationProperties`](crate::model::EventBridgeDestinationProperties)
        pub fn build(self) -> crate::model::EventBridgeDestinationProperties {
            crate::model::EventBridgeDestinationProperties {
                object: self.object,
                error_handling_config: self.error_handling_config,
            }
        }
    }
}
impl EventBridgeDestinationProperties {
    /// Creates a new builder-style object to manufacture [`EventBridgeDestinationProperties`](crate::model::EventBridgeDestinationProperties)
    pub fn builder() -> crate::model::event_bridge_destination_properties::Builder {
        crate::model::event_bridge_destination_properties::Builder::default()
    }
}

/// <p> The properties that are applied when Snowflake is being used as a destination. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SnowflakeDestinationProperties {
    /// <p> The object specified in the Snowflake flow destination. </p>
    pub object: std::option::Option<std::string::String>,
    /// <p> The intermediate bucket that Amazon AppFlow uses when moving data into Snowflake. </p>
    pub intermediate_bucket_name: std::option::Option<std::string::String>,
    /// <p> The object key for the destination bucket in which Amazon AppFlow places the files. </p>
    pub bucket_prefix: std::option::Option<std::string::String>,
    /// <p> The settings that determine how Amazon AppFlow handles an error when placing data in the Snowflake destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details. </p>
    pub error_handling_config: std::option::Option<crate::model::ErrorHandlingConfig>,
}
impl SnowflakeDestinationProperties {
    /// <p> The object specified in the Snowflake flow destination. </p>
    pub fn object(&self) -> std::option::Option<&str> {
        self.object.as_deref()
    }
    /// <p> The intermediate bucket that Amazon AppFlow uses when moving data into Snowflake. </p>
    pub fn intermediate_bucket_name(&self) -> std::option::Option<&str> {
        self.intermediate_bucket_name.as_deref()
    }
    /// <p> The object key for the destination bucket in which Amazon AppFlow places the files. </p>
    pub fn bucket_prefix(&self) -> std::option::Option<&str> {
        self.bucket_prefix.as_deref()
    }
    /// <p> The settings that determine how Amazon AppFlow handles an error when placing data in the Snowflake destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details. </p>
    pub fn error_handling_config(&self) -> std::option::Option<&crate::model::ErrorHandlingConfig> {
        self.error_handling_config.as_ref()
    }
}
impl std::fmt::Debug for SnowflakeDestinationProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SnowflakeDestinationProperties");
        formatter.field("object", &self.object);
        formatter.field("intermediate_bucket_name", &self.intermediate_bucket_name);
        formatter.field("bucket_prefix", &self.bucket_prefix);
        formatter.field("error_handling_config", &self.error_handling_config);
        formatter.finish()
    }
}
/// See [`SnowflakeDestinationProperties`](crate::model::SnowflakeDestinationProperties)
pub mod snowflake_destination_properties {
    /// A builder for [`SnowflakeDestinationProperties`](crate::model::SnowflakeDestinationProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) object: std::option::Option<std::string::String>,
        pub(crate) intermediate_bucket_name: std::option::Option<std::string::String>,
        pub(crate) bucket_prefix: std::option::Option<std::string::String>,
        pub(crate) error_handling_config: std::option::Option<crate::model::ErrorHandlingConfig>,
    }
    impl Builder {
        /// <p> The object specified in the Snowflake flow destination. </p>
        pub fn object(mut self, input: impl Into<std::string::String>) -> Self {
            self.object = Some(input.into());
            self
        }
        /// <p> The object specified in the Snowflake flow destination. </p>
        pub fn set_object(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.object = input;
            self
        }
        /// <p> The intermediate bucket that Amazon AppFlow uses when moving data into Snowflake. </p>
        pub fn intermediate_bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.intermediate_bucket_name = Some(input.into());
            self
        }
        /// <p> The intermediate bucket that Amazon AppFlow uses when moving data into Snowflake. </p>
        pub fn set_intermediate_bucket_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.intermediate_bucket_name = input;
            self
        }
        /// <p> The object key for the destination bucket in which Amazon AppFlow places the files. </p>
        pub fn bucket_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_prefix = Some(input.into());
            self
        }
        /// <p> The object key for the destination bucket in which Amazon AppFlow places the files. </p>
        pub fn set_bucket_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.bucket_prefix = input;
            self
        }
        /// <p> The settings that determine how Amazon AppFlow handles an error when placing data in the Snowflake destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details. </p>
        pub fn error_handling_config(mut self, input: crate::model::ErrorHandlingConfig) -> Self {
            self.error_handling_config = Some(input);
            self
        }
        /// <p> The settings that determine how Amazon AppFlow handles an error when placing data in the Snowflake destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details. </p>
        pub fn set_error_handling_config(
            mut self,
            input: std::option::Option<crate::model::ErrorHandlingConfig>,
        ) -> Self {
            self.error_handling_config = input;
            self
        }
        /// Consumes the builder and constructs a [`SnowflakeDestinationProperties`](crate::model::SnowflakeDestinationProperties)
        pub fn build(self) -> crate::model::SnowflakeDestinationProperties {
            crate::model::SnowflakeDestinationProperties {
                object: self.object,
                intermediate_bucket_name: self.intermediate_bucket_name,
                bucket_prefix: self.bucket_prefix,
                error_handling_config: self.error_handling_config,
            }
        }
    }
}
impl SnowflakeDestinationProperties {
    /// Creates a new builder-style object to manufacture [`SnowflakeDestinationProperties`](crate::model::SnowflakeDestinationProperties)
    pub fn builder() -> crate::model::snowflake_destination_properties::Builder {
        crate::model::snowflake_destination_properties::Builder::default()
    }
}

/// <p> The properties that are applied when Salesforce is being used as a destination. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SalesforceDestinationProperties {
    /// <p> The object specified in the Salesforce flow destination. </p>
    pub object: std::option::Option<std::string::String>,
    /// <p> The name of the field that Amazon AppFlow uses as an ID when performing a write operation such as update or delete. </p>
    pub id_field_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> The settings that determine how Amazon AppFlow handles an error when placing data in the Salesforce destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details. </p>
    pub error_handling_config: std::option::Option<crate::model::ErrorHandlingConfig>,
    /// <p> This specifies the type of write operation to be performed in Salesforce. When the value is <code>UPSERT</code>, then <code>idFieldNames</code> is required. </p>
    pub write_operation_type: std::option::Option<crate::model::WriteOperationType>,
}
impl SalesforceDestinationProperties {
    /// <p> The object specified in the Salesforce flow destination. </p>
    pub fn object(&self) -> std::option::Option<&str> {
        self.object.as_deref()
    }
    /// <p> The name of the field that Amazon AppFlow uses as an ID when performing a write operation such as update or delete. </p>
    pub fn id_field_names(&self) -> std::option::Option<&[std::string::String]> {
        self.id_field_names.as_deref()
    }
    /// <p> The settings that determine how Amazon AppFlow handles an error when placing data in the Salesforce destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details. </p>
    pub fn error_handling_config(&self) -> std::option::Option<&crate::model::ErrorHandlingConfig> {
        self.error_handling_config.as_ref()
    }
    /// <p> This specifies the type of write operation to be performed in Salesforce. When the value is <code>UPSERT</code>, then <code>idFieldNames</code> is required. </p>
    pub fn write_operation_type(&self) -> std::option::Option<&crate::model::WriteOperationType> {
        self.write_operation_type.as_ref()
    }
}
impl std::fmt::Debug for SalesforceDestinationProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SalesforceDestinationProperties");
        formatter.field("object", &self.object);
        formatter.field("id_field_names", &self.id_field_names);
        formatter.field("error_handling_config", &self.error_handling_config);
        formatter.field("write_operation_type", &self.write_operation_type);
        formatter.finish()
    }
}
/// See [`SalesforceDestinationProperties`](crate::model::SalesforceDestinationProperties)
pub mod salesforce_destination_properties {
    /// A builder for [`SalesforceDestinationProperties`](crate::model::SalesforceDestinationProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) object: std::option::Option<std::string::String>,
        pub(crate) id_field_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) error_handling_config: std::option::Option<crate::model::ErrorHandlingConfig>,
        pub(crate) write_operation_type: std::option::Option<crate::model::WriteOperationType>,
    }
    impl Builder {
        /// <p> The object specified in the Salesforce flow destination. </p>
        pub fn object(mut self, input: impl Into<std::string::String>) -> Self {
            self.object = Some(input.into());
            self
        }
        /// <p> The object specified in the Salesforce flow destination. </p>
        pub fn set_object(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.object = input;
            self
        }
        /// Appends an item to `id_field_names`.
        ///
        /// To override the contents of this collection use [`set_id_field_names`](Self::set_id_field_names).
        ///
        /// <p> The name of the field that Amazon AppFlow uses as an ID when performing a write operation such as update or delete. </p>
        pub fn id_field_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.id_field_names.unwrap_or_default();
            v.push(input.into());
            self.id_field_names = Some(v);
            self
        }
        /// <p> The name of the field that Amazon AppFlow uses as an ID when performing a write operation such as update or delete. </p>
        pub fn set_id_field_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.id_field_names = input;
            self
        }
        /// <p> The settings that determine how Amazon AppFlow handles an error when placing data in the Salesforce destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details. </p>
        pub fn error_handling_config(mut self, input: crate::model::ErrorHandlingConfig) -> Self {
            self.error_handling_config = Some(input);
            self
        }
        /// <p> The settings that determine how Amazon AppFlow handles an error when placing data in the Salesforce destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details. </p>
        pub fn set_error_handling_config(
            mut self,
            input: std::option::Option<crate::model::ErrorHandlingConfig>,
        ) -> Self {
            self.error_handling_config = input;
            self
        }
        /// <p> This specifies the type of write operation to be performed in Salesforce. When the value is <code>UPSERT</code>, then <code>idFieldNames</code> is required. </p>
        pub fn write_operation_type(mut self, input: crate::model::WriteOperationType) -> Self {
            self.write_operation_type = Some(input);
            self
        }
        /// <p> This specifies the type of write operation to be performed in Salesforce. When the value is <code>UPSERT</code>, then <code>idFieldNames</code> is required. </p>
        pub fn set_write_operation_type(
            mut self,
            input: std::option::Option<crate::model::WriteOperationType>,
        ) -> Self {
            self.write_operation_type = input;
            self
        }
        /// Consumes the builder and constructs a [`SalesforceDestinationProperties`](crate::model::SalesforceDestinationProperties)
        pub fn build(self) -> crate::model::SalesforceDestinationProperties {
            crate::model::SalesforceDestinationProperties {
                object: self.object,
                id_field_names: self.id_field_names,
                error_handling_config: self.error_handling_config,
                write_operation_type: self.write_operation_type,
            }
        }
    }
}
impl SalesforceDestinationProperties {
    /// Creates a new builder-style object to manufacture [`SalesforceDestinationProperties`](crate::model::SalesforceDestinationProperties)
    pub fn builder() -> crate::model::salesforce_destination_properties::Builder {
        crate::model::salesforce_destination_properties::Builder::default()
    }
}

/// <p> The properties that are applied when Amazon S3 is used as a destination. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3DestinationProperties {
    /// <p> The Amazon S3 bucket name in which Amazon AppFlow places the transferred data. </p>
    pub bucket_name: std::option::Option<std::string::String>,
    /// <p> The object key for the destination bucket in which Amazon AppFlow places the files. </p>
    pub bucket_prefix: std::option::Option<std::string::String>,
    /// <p> The configuration that determines how Amazon AppFlow should format the flow output data when Amazon S3 is used as the destination. </p>
    pub s3_output_format_config: std::option::Option<crate::model::S3OutputFormatConfig>,
}
impl S3DestinationProperties {
    /// <p> The Amazon S3 bucket name in which Amazon AppFlow places the transferred data. </p>
    pub fn bucket_name(&self) -> std::option::Option<&str> {
        self.bucket_name.as_deref()
    }
    /// <p> The object key for the destination bucket in which Amazon AppFlow places the files. </p>
    pub fn bucket_prefix(&self) -> std::option::Option<&str> {
        self.bucket_prefix.as_deref()
    }
    /// <p> The configuration that determines how Amazon AppFlow should format the flow output data when Amazon S3 is used as the destination. </p>
    pub fn s3_output_format_config(
        &self,
    ) -> std::option::Option<&crate::model::S3OutputFormatConfig> {
        self.s3_output_format_config.as_ref()
    }
}
impl std::fmt::Debug for S3DestinationProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3DestinationProperties");
        formatter.field("bucket_name", &self.bucket_name);
        formatter.field("bucket_prefix", &self.bucket_prefix);
        formatter.field("s3_output_format_config", &self.s3_output_format_config);
        formatter.finish()
    }
}
/// See [`S3DestinationProperties`](crate::model::S3DestinationProperties)
pub mod s3_destination_properties {
    /// A builder for [`S3DestinationProperties`](crate::model::S3DestinationProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket_name: std::option::Option<std::string::String>,
        pub(crate) bucket_prefix: std::option::Option<std::string::String>,
        pub(crate) s3_output_format_config: std::option::Option<crate::model::S3OutputFormatConfig>,
    }
    impl Builder {
        /// <p> The Amazon S3 bucket name in which Amazon AppFlow places the transferred data. </p>
        pub fn bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_name = Some(input.into());
            self
        }
        /// <p> The Amazon S3 bucket name in which Amazon AppFlow places the transferred data. </p>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_name = input;
            self
        }
        /// <p> The object key for the destination bucket in which Amazon AppFlow places the files. </p>
        pub fn bucket_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_prefix = Some(input.into());
            self
        }
        /// <p> The object key for the destination bucket in which Amazon AppFlow places the files. </p>
        pub fn set_bucket_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.bucket_prefix = input;
            self
        }
        /// <p> The configuration that determines how Amazon AppFlow should format the flow output data when Amazon S3 is used as the destination. </p>
        pub fn s3_output_format_config(
            mut self,
            input: crate::model::S3OutputFormatConfig,
        ) -> Self {
            self.s3_output_format_config = Some(input);
            self
        }
        /// <p> The configuration that determines how Amazon AppFlow should format the flow output data when Amazon S3 is used as the destination. </p>
        pub fn set_s3_output_format_config(
            mut self,
            input: std::option::Option<crate::model::S3OutputFormatConfig>,
        ) -> Self {
            self.s3_output_format_config = input;
            self
        }
        /// Consumes the builder and constructs a [`S3DestinationProperties`](crate::model::S3DestinationProperties)
        pub fn build(self) -> crate::model::S3DestinationProperties {
            crate::model::S3DestinationProperties {
                bucket_name: self.bucket_name,
                bucket_prefix: self.bucket_prefix,
                s3_output_format_config: self.s3_output_format_config,
            }
        }
    }
}
impl S3DestinationProperties {
    /// Creates a new builder-style object to manufacture [`S3DestinationProperties`](crate::model::S3DestinationProperties)
    pub fn builder() -> crate::model::s3_destination_properties::Builder {
        crate::model::s3_destination_properties::Builder::default()
    }
}

/// <p> The configuration that determines how Amazon AppFlow should format the flow output data when Amazon S3 is used as the destination. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3OutputFormatConfig {
    /// <p> Indicates the file type that Amazon AppFlow places in the Amazon S3 bucket. </p>
    pub file_type: std::option::Option<crate::model::FileType>,
    /// <p> Determines the prefix that Amazon AppFlow applies to the folder name in the Amazon S3 bucket. You can name folders according to the flow frequency and date. </p>
    pub prefix_config: std::option::Option<crate::model::PrefixConfig>,
    /// <p> The aggregation settings that you can use to customize the output format of your flow data. </p>
    pub aggregation_config: std::option::Option<crate::model::AggregationConfig>,
}
impl S3OutputFormatConfig {
    /// <p> Indicates the file type that Amazon AppFlow places in the Amazon S3 bucket. </p>
    pub fn file_type(&self) -> std::option::Option<&crate::model::FileType> {
        self.file_type.as_ref()
    }
    /// <p> Determines the prefix that Amazon AppFlow applies to the folder name in the Amazon S3 bucket. You can name folders according to the flow frequency and date. </p>
    pub fn prefix_config(&self) -> std::option::Option<&crate::model::PrefixConfig> {
        self.prefix_config.as_ref()
    }
    /// <p> The aggregation settings that you can use to customize the output format of your flow data. </p>
    pub fn aggregation_config(&self) -> std::option::Option<&crate::model::AggregationConfig> {
        self.aggregation_config.as_ref()
    }
}
impl std::fmt::Debug for S3OutputFormatConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3OutputFormatConfig");
        formatter.field("file_type", &self.file_type);
        formatter.field("prefix_config", &self.prefix_config);
        formatter.field("aggregation_config", &self.aggregation_config);
        formatter.finish()
    }
}
/// See [`S3OutputFormatConfig`](crate::model::S3OutputFormatConfig)
pub mod s3_output_format_config {
    /// A builder for [`S3OutputFormatConfig`](crate::model::S3OutputFormatConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_type: std::option::Option<crate::model::FileType>,
        pub(crate) prefix_config: std::option::Option<crate::model::PrefixConfig>,
        pub(crate) aggregation_config: std::option::Option<crate::model::AggregationConfig>,
    }
    impl Builder {
        /// <p> Indicates the file type that Amazon AppFlow places in the Amazon S3 bucket. </p>
        pub fn file_type(mut self, input: crate::model::FileType) -> Self {
            self.file_type = Some(input);
            self
        }
        /// <p> Indicates the file type that Amazon AppFlow places in the Amazon S3 bucket. </p>
        pub fn set_file_type(mut self, input: std::option::Option<crate::model::FileType>) -> Self {
            self.file_type = input;
            self
        }
        /// <p> Determines the prefix that Amazon AppFlow applies to the folder name in the Amazon S3 bucket. You can name folders according to the flow frequency and date. </p>
        pub fn prefix_config(mut self, input: crate::model::PrefixConfig) -> Self {
            self.prefix_config = Some(input);
            self
        }
        /// <p> Determines the prefix that Amazon AppFlow applies to the folder name in the Amazon S3 bucket. You can name folders according to the flow frequency and date. </p>
        pub fn set_prefix_config(
            mut self,
            input: std::option::Option<crate::model::PrefixConfig>,
        ) -> Self {
            self.prefix_config = input;
            self
        }
        /// <p> The aggregation settings that you can use to customize the output format of your flow data. </p>
        pub fn aggregation_config(mut self, input: crate::model::AggregationConfig) -> Self {
            self.aggregation_config = Some(input);
            self
        }
        /// <p> The aggregation settings that you can use to customize the output format of your flow data. </p>
        pub fn set_aggregation_config(
            mut self,
            input: std::option::Option<crate::model::AggregationConfig>,
        ) -> Self {
            self.aggregation_config = input;
            self
        }
        /// Consumes the builder and constructs a [`S3OutputFormatConfig`](crate::model::S3OutputFormatConfig)
        pub fn build(self) -> crate::model::S3OutputFormatConfig {
            crate::model::S3OutputFormatConfig {
                file_type: self.file_type,
                prefix_config: self.prefix_config,
                aggregation_config: self.aggregation_config,
            }
        }
    }
}
impl S3OutputFormatConfig {
    /// Creates a new builder-style object to manufacture [`S3OutputFormatConfig`](crate::model::S3OutputFormatConfig)
    pub fn builder() -> crate::model::s3_output_format_config::Builder {
        crate::model::s3_output_format_config::Builder::default()
    }
}

/// <p> The properties that are applied when Amazon Redshift is being used as a destination. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RedshiftDestinationProperties {
    /// <p> The object specified in the Amazon Redshift flow destination. </p>
    pub object: std::option::Option<std::string::String>,
    /// <p> The intermediate bucket that Amazon AppFlow uses when moving data into Amazon Redshift. </p>
    pub intermediate_bucket_name: std::option::Option<std::string::String>,
    /// <p> The object key for the bucket in which Amazon AppFlow places the destination files. </p>
    pub bucket_prefix: std::option::Option<std::string::String>,
    /// <p> The settings that determine how Amazon AppFlow handles an error when placing data in the Amazon Redshift destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details. </p>
    pub error_handling_config: std::option::Option<crate::model::ErrorHandlingConfig>,
}
impl RedshiftDestinationProperties {
    /// <p> The object specified in the Amazon Redshift flow destination. </p>
    pub fn object(&self) -> std::option::Option<&str> {
        self.object.as_deref()
    }
    /// <p> The intermediate bucket that Amazon AppFlow uses when moving data into Amazon Redshift. </p>
    pub fn intermediate_bucket_name(&self) -> std::option::Option<&str> {
        self.intermediate_bucket_name.as_deref()
    }
    /// <p> The object key for the bucket in which Amazon AppFlow places the destination files. </p>
    pub fn bucket_prefix(&self) -> std::option::Option<&str> {
        self.bucket_prefix.as_deref()
    }
    /// <p> The settings that determine how Amazon AppFlow handles an error when placing data in the Amazon Redshift destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details. </p>
    pub fn error_handling_config(&self) -> std::option::Option<&crate::model::ErrorHandlingConfig> {
        self.error_handling_config.as_ref()
    }
}
impl std::fmt::Debug for RedshiftDestinationProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RedshiftDestinationProperties");
        formatter.field("object", &self.object);
        formatter.field("intermediate_bucket_name", &self.intermediate_bucket_name);
        formatter.field("bucket_prefix", &self.bucket_prefix);
        formatter.field("error_handling_config", &self.error_handling_config);
        formatter.finish()
    }
}
/// See [`RedshiftDestinationProperties`](crate::model::RedshiftDestinationProperties)
pub mod redshift_destination_properties {
    /// A builder for [`RedshiftDestinationProperties`](crate::model::RedshiftDestinationProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) object: std::option::Option<std::string::String>,
        pub(crate) intermediate_bucket_name: std::option::Option<std::string::String>,
        pub(crate) bucket_prefix: std::option::Option<std::string::String>,
        pub(crate) error_handling_config: std::option::Option<crate::model::ErrorHandlingConfig>,
    }
    impl Builder {
        /// <p> The object specified in the Amazon Redshift flow destination. </p>
        pub fn object(mut self, input: impl Into<std::string::String>) -> Self {
            self.object = Some(input.into());
            self
        }
        /// <p> The object specified in the Amazon Redshift flow destination. </p>
        pub fn set_object(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.object = input;
            self
        }
        /// <p> The intermediate bucket that Amazon AppFlow uses when moving data into Amazon Redshift. </p>
        pub fn intermediate_bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.intermediate_bucket_name = Some(input.into());
            self
        }
        /// <p> The intermediate bucket that Amazon AppFlow uses when moving data into Amazon Redshift. </p>
        pub fn set_intermediate_bucket_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.intermediate_bucket_name = input;
            self
        }
        /// <p> The object key for the bucket in which Amazon AppFlow places the destination files. </p>
        pub fn bucket_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_prefix = Some(input.into());
            self
        }
        /// <p> The object key for the bucket in which Amazon AppFlow places the destination files. </p>
        pub fn set_bucket_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.bucket_prefix = input;
            self
        }
        /// <p> The settings that determine how Amazon AppFlow handles an error when placing data in the Amazon Redshift destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details. </p>
        pub fn error_handling_config(mut self, input: crate::model::ErrorHandlingConfig) -> Self {
            self.error_handling_config = Some(input);
            self
        }
        /// <p> The settings that determine how Amazon AppFlow handles an error when placing data in the Amazon Redshift destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details. </p>
        pub fn set_error_handling_config(
            mut self,
            input: std::option::Option<crate::model::ErrorHandlingConfig>,
        ) -> Self {
            self.error_handling_config = input;
            self
        }
        /// Consumes the builder and constructs a [`RedshiftDestinationProperties`](crate::model::RedshiftDestinationProperties)
        pub fn build(self) -> crate::model::RedshiftDestinationProperties {
            crate::model::RedshiftDestinationProperties {
                object: self.object,
                intermediate_bucket_name: self.intermediate_bucket_name,
                bucket_prefix: self.bucket_prefix,
                error_handling_config: self.error_handling_config,
            }
        }
    }
}
impl RedshiftDestinationProperties {
    /// Creates a new builder-style object to manufacture [`RedshiftDestinationProperties`](crate::model::RedshiftDestinationProperties)
    pub fn builder() -> crate::model::redshift_destination_properties::Builder {
        crate::model::redshift_destination_properties::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConnectorType {
    #[allow(missing_docs)] // documentation missing in model
    Amplitude,
    #[allow(missing_docs)] // documentation missing in model
    Customconnector,
    #[allow(missing_docs)] // documentation missing in model
    Customerprofiles,
    #[allow(missing_docs)] // documentation missing in model
    Datadog,
    #[allow(missing_docs)] // documentation missing in model
    Dynatrace,
    #[allow(missing_docs)] // documentation missing in model
    Eventbridge,
    #[allow(missing_docs)] // documentation missing in model
    Googleanalytics,
    #[allow(missing_docs)] // documentation missing in model
    Honeycode,
    #[allow(missing_docs)] // documentation missing in model
    Infornexus,
    #[allow(missing_docs)] // documentation missing in model
    Lookoutmetrics,
    #[allow(missing_docs)] // documentation missing in model
    Marketo,
    #[allow(missing_docs)] // documentation missing in model
    Redshift,
    #[allow(missing_docs)] // documentation missing in model
    S3,
    #[allow(missing_docs)] // documentation missing in model
    Sapodata,
    #[allow(missing_docs)] // documentation missing in model
    Salesforce,
    #[allow(missing_docs)] // documentation missing in model
    Servicenow,
    #[allow(missing_docs)] // documentation missing in model
    Singular,
    #[allow(missing_docs)] // documentation missing in model
    Slack,
    #[allow(missing_docs)] // documentation missing in model
    Snowflake,
    #[allow(missing_docs)] // documentation missing in model
    Trendmicro,
    #[allow(missing_docs)] // documentation missing in model
    Upsolver,
    #[allow(missing_docs)] // documentation missing in model
    Veeva,
    #[allow(missing_docs)] // documentation missing in model
    Zendesk,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConnectorType {
    fn from(s: &str) -> Self {
        match s {
            "Amplitude" => ConnectorType::Amplitude,
            "CustomConnector" => ConnectorType::Customconnector,
            "CustomerProfiles" => ConnectorType::Customerprofiles,
            "Datadog" => ConnectorType::Datadog,
            "Dynatrace" => ConnectorType::Dynatrace,
            "EventBridge" => ConnectorType::Eventbridge,
            "Googleanalytics" => ConnectorType::Googleanalytics,
            "Honeycode" => ConnectorType::Honeycode,
            "Infornexus" => ConnectorType::Infornexus,
            "LookoutMetrics" => ConnectorType::Lookoutmetrics,
            "Marketo" => ConnectorType::Marketo,
            "Redshift" => ConnectorType::Redshift,
            "S3" => ConnectorType::S3,
            "SAPOData" => ConnectorType::Sapodata,
            "Salesforce" => ConnectorType::Salesforce,
            "Servicenow" => ConnectorType::Servicenow,
            "Singular" => ConnectorType::Singular,
            "Slack" => ConnectorType::Slack,
            "Snowflake" => ConnectorType::Snowflake,
            "Trendmicro" => ConnectorType::Trendmicro,
            "Upsolver" => ConnectorType::Upsolver,
            "Veeva" => ConnectorType::Veeva,
            "Zendesk" => ConnectorType::Zendesk,
            other => ConnectorType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConnectorType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConnectorType::from(s))
    }
}
impl ConnectorType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConnectorType::Amplitude => "Amplitude",
            ConnectorType::Customconnector => "CustomConnector",
            ConnectorType::Customerprofiles => "CustomerProfiles",
            ConnectorType::Datadog => "Datadog",
            ConnectorType::Dynatrace => "Dynatrace",
            ConnectorType::Eventbridge => "EventBridge",
            ConnectorType::Googleanalytics => "Googleanalytics",
            ConnectorType::Honeycode => "Honeycode",
            ConnectorType::Infornexus => "Infornexus",
            ConnectorType::Lookoutmetrics => "LookoutMetrics",
            ConnectorType::Marketo => "Marketo",
            ConnectorType::Redshift => "Redshift",
            ConnectorType::S3 => "S3",
            ConnectorType::Sapodata => "SAPOData",
            ConnectorType::Salesforce => "Salesforce",
            ConnectorType::Servicenow => "Servicenow",
            ConnectorType::Singular => "Singular",
            ConnectorType::Slack => "Slack",
            ConnectorType::Snowflake => "Snowflake",
            ConnectorType::Trendmicro => "Trendmicro",
            ConnectorType::Upsolver => "Upsolver",
            ConnectorType::Veeva => "Veeva",
            ConnectorType::Zendesk => "Zendesk",
            ConnectorType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Amplitude",
            "CustomConnector",
            "CustomerProfiles",
            "Datadog",
            "Dynatrace",
            "EventBridge",
            "Googleanalytics",
            "Honeycode",
            "Infornexus",
            "LookoutMetrics",
            "Marketo",
            "Redshift",
            "S3",
            "SAPOData",
            "Salesforce",
            "Servicenow",
            "Singular",
            "Slack",
            "Snowflake",
            "Trendmicro",
            "Upsolver",
            "Veeva",
            "Zendesk",
        ]
    }
}
impl AsRef<str> for ConnectorType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> Contains information about the configuration of the source connector used in the flow. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SourceFlowConfig {
    /// <p> The type of connector, such as Salesforce, Amplitude, and so on. </p>
    pub connector_type: std::option::Option<crate::model::ConnectorType>,
    /// <p>The API version of the connector when it's used as a source in the flow.</p>
    pub api_version: std::option::Option<std::string::String>,
    /// <p> The name of the connector profile. This name must be unique for each connector profile in the Amazon Web Services account. </p>
    pub connector_profile_name: std::option::Option<std::string::String>,
    /// <p> Specifies the information that is required to query a particular source connector. </p>
    pub source_connector_properties: std::option::Option<crate::model::SourceConnectorProperties>,
    /// <p> Defines the configuration for a scheduled incremental data pull. If a valid configuration is provided, the fields specified in the configuration are used when querying for the incremental data pull. </p>
    pub incremental_pull_config: std::option::Option<crate::model::IncrementalPullConfig>,
}
impl SourceFlowConfig {
    /// <p> The type of connector, such as Salesforce, Amplitude, and so on. </p>
    pub fn connector_type(&self) -> std::option::Option<&crate::model::ConnectorType> {
        self.connector_type.as_ref()
    }
    /// <p>The API version of the connector when it's used as a source in the flow.</p>
    pub fn api_version(&self) -> std::option::Option<&str> {
        self.api_version.as_deref()
    }
    /// <p> The name of the connector profile. This name must be unique for each connector profile in the Amazon Web Services account. </p>
    pub fn connector_profile_name(&self) -> std::option::Option<&str> {
        self.connector_profile_name.as_deref()
    }
    /// <p> Specifies the information that is required to query a particular source connector. </p>
    pub fn source_connector_properties(
        &self,
    ) -> std::option::Option<&crate::model::SourceConnectorProperties> {
        self.source_connector_properties.as_ref()
    }
    /// <p> Defines the configuration for a scheduled incremental data pull. If a valid configuration is provided, the fields specified in the configuration are used when querying for the incremental data pull. </p>
    pub fn incremental_pull_config(
        &self,
    ) -> std::option::Option<&crate::model::IncrementalPullConfig> {
        self.incremental_pull_config.as_ref()
    }
}
impl std::fmt::Debug for SourceFlowConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SourceFlowConfig");
        formatter.field("connector_type", &self.connector_type);
        formatter.field("api_version", &self.api_version);
        formatter.field("connector_profile_name", &self.connector_profile_name);
        formatter.field(
            "source_connector_properties",
            &self.source_connector_properties,
        );
        formatter.field("incremental_pull_config", &self.incremental_pull_config);
        formatter.finish()
    }
}
/// See [`SourceFlowConfig`](crate::model::SourceFlowConfig)
pub mod source_flow_config {
    /// A builder for [`SourceFlowConfig`](crate::model::SourceFlowConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connector_type: std::option::Option<crate::model::ConnectorType>,
        pub(crate) api_version: std::option::Option<std::string::String>,
        pub(crate) connector_profile_name: std::option::Option<std::string::String>,
        pub(crate) source_connector_properties:
            std::option::Option<crate::model::SourceConnectorProperties>,
        pub(crate) incremental_pull_config:
            std::option::Option<crate::model::IncrementalPullConfig>,
    }
    impl Builder {
        /// <p> The type of connector, such as Salesforce, Amplitude, and so on. </p>
        pub fn connector_type(mut self, input: crate::model::ConnectorType) -> Self {
            self.connector_type = Some(input);
            self
        }
        /// <p> The type of connector, such as Salesforce, Amplitude, and so on. </p>
        pub fn set_connector_type(
            mut self,
            input: std::option::Option<crate::model::ConnectorType>,
        ) -> Self {
            self.connector_type = input;
            self
        }
        /// <p>The API version of the connector when it's used as a source in the flow.</p>
        pub fn api_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_version = Some(input.into());
            self
        }
        /// <p>The API version of the connector when it's used as a source in the flow.</p>
        pub fn set_api_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_version = input;
            self
        }
        /// <p> The name of the connector profile. This name must be unique for each connector profile in the Amazon Web Services account. </p>
        pub fn connector_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.connector_profile_name = Some(input.into());
            self
        }
        /// <p> The name of the connector profile. This name must be unique for each connector profile in the Amazon Web Services account. </p>
        pub fn set_connector_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connector_profile_name = input;
            self
        }
        /// <p> Specifies the information that is required to query a particular source connector. </p>
        pub fn source_connector_properties(
            mut self,
            input: crate::model::SourceConnectorProperties,
        ) -> Self {
            self.source_connector_properties = Some(input);
            self
        }
        /// <p> Specifies the information that is required to query a particular source connector. </p>
        pub fn set_source_connector_properties(
            mut self,
            input: std::option::Option<crate::model::SourceConnectorProperties>,
        ) -> Self {
            self.source_connector_properties = input;
            self
        }
        /// <p> Defines the configuration for a scheduled incremental data pull. If a valid configuration is provided, the fields specified in the configuration are used when querying for the incremental data pull. </p>
        pub fn incremental_pull_config(
            mut self,
            input: crate::model::IncrementalPullConfig,
        ) -> Self {
            self.incremental_pull_config = Some(input);
            self
        }
        /// <p> Defines the configuration for a scheduled incremental data pull. If a valid configuration is provided, the fields specified in the configuration are used when querying for the incremental data pull. </p>
        pub fn set_incremental_pull_config(
            mut self,
            input: std::option::Option<crate::model::IncrementalPullConfig>,
        ) -> Self {
            self.incremental_pull_config = input;
            self
        }
        /// Consumes the builder and constructs a [`SourceFlowConfig`](crate::model::SourceFlowConfig)
        pub fn build(self) -> crate::model::SourceFlowConfig {
            crate::model::SourceFlowConfig {
                connector_type: self.connector_type,
                api_version: self.api_version,
                connector_profile_name: self.connector_profile_name,
                source_connector_properties: self.source_connector_properties,
                incremental_pull_config: self.incremental_pull_config,
            }
        }
    }
}
impl SourceFlowConfig {
    /// Creates a new builder-style object to manufacture [`SourceFlowConfig`](crate::model::SourceFlowConfig)
    pub fn builder() -> crate::model::source_flow_config::Builder {
        crate::model::source_flow_config::Builder::default()
    }
}

/// <p> Specifies the configuration used when importing incremental records from the source. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IncrementalPullConfig {
    /// <p> A field that specifies the date time or timestamp field as the criteria to use when importing incremental records from the source. </p>
    pub datetime_type_field_name: std::option::Option<std::string::String>,
}
impl IncrementalPullConfig {
    /// <p> A field that specifies the date time or timestamp field as the criteria to use when importing incremental records from the source. </p>
    pub fn datetime_type_field_name(&self) -> std::option::Option<&str> {
        self.datetime_type_field_name.as_deref()
    }
}
impl std::fmt::Debug for IncrementalPullConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IncrementalPullConfig");
        formatter.field("datetime_type_field_name", &self.datetime_type_field_name);
        formatter.finish()
    }
}
/// See [`IncrementalPullConfig`](crate::model::IncrementalPullConfig)
pub mod incremental_pull_config {
    /// A builder for [`IncrementalPullConfig`](crate::model::IncrementalPullConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) datetime_type_field_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> A field that specifies the date time or timestamp field as the criteria to use when importing incremental records from the source. </p>
        pub fn datetime_type_field_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.datetime_type_field_name = Some(input.into());
            self
        }
        /// <p> A field that specifies the date time or timestamp field as the criteria to use when importing incremental records from the source. </p>
        pub fn set_datetime_type_field_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.datetime_type_field_name = input;
            self
        }
        /// Consumes the builder and constructs a [`IncrementalPullConfig`](crate::model::IncrementalPullConfig)
        pub fn build(self) -> crate::model::IncrementalPullConfig {
            crate::model::IncrementalPullConfig {
                datetime_type_field_name: self.datetime_type_field_name,
            }
        }
    }
}
impl IncrementalPullConfig {
    /// Creates a new builder-style object to manufacture [`IncrementalPullConfig`](crate::model::IncrementalPullConfig)
    pub fn builder() -> crate::model::incremental_pull_config::Builder {
        crate::model::incremental_pull_config::Builder::default()
    }
}

/// <p> Specifies the information that is required to query a particular connector. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SourceConnectorProperties {
    /// <p> Specifies the information that is required for querying Amplitude. </p>
    pub amplitude: std::option::Option<crate::model::AmplitudeSourceProperties>,
    /// <p> Specifies the information that is required for querying Datadog. </p>
    pub datadog: std::option::Option<crate::model::DatadogSourceProperties>,
    /// <p> Specifies the information that is required for querying Dynatrace. </p>
    pub dynatrace: std::option::Option<crate::model::DynatraceSourceProperties>,
    /// <p> Specifies the information that is required for querying Google Analytics. </p>
    pub google_analytics: std::option::Option<crate::model::GoogleAnalyticsSourceProperties>,
    /// <p> Specifies the information that is required for querying Infor Nexus. </p>
    pub infor_nexus: std::option::Option<crate::model::InforNexusSourceProperties>,
    /// <p> Specifies the information that is required for querying Marketo. </p>
    pub marketo: std::option::Option<crate::model::MarketoSourceProperties>,
    /// <p> Specifies the information that is required for querying Amazon S3. </p>
    pub s3: std::option::Option<crate::model::S3SourceProperties>,
    /// <p> Specifies the information that is required for querying Salesforce. </p>
    pub salesforce: std::option::Option<crate::model::SalesforceSourceProperties>,
    /// <p> Specifies the information that is required for querying ServiceNow. </p>
    pub service_now: std::option::Option<crate::model::ServiceNowSourceProperties>,
    /// <p> Specifies the information that is required for querying Singular. </p>
    pub singular: std::option::Option<crate::model::SingularSourceProperties>,
    /// <p> Specifies the information that is required for querying Slack. </p>
    pub slack: std::option::Option<crate::model::SlackSourceProperties>,
    /// <p> Specifies the information that is required for querying Trend Micro. </p>
    pub trendmicro: std::option::Option<crate::model::TrendmicroSourceProperties>,
    /// <p> Specifies the information that is required for querying Veeva. </p>
    pub veeva: std::option::Option<crate::model::VeevaSourceProperties>,
    /// <p> Specifies the information that is required for querying Zendesk. </p>
    pub zendesk: std::option::Option<crate::model::ZendeskSourceProperties>,
    /// <p> The properties that are applied when using SAPOData as a flow source. </p>
    pub sapo_data: std::option::Option<crate::model::SapoDataSourceProperties>,
    /// <p>The properties that are applied when the custom connector is being used as a source.</p>
    pub custom_connector: std::option::Option<crate::model::CustomConnectorSourceProperties>,
}
impl SourceConnectorProperties {
    /// <p> Specifies the information that is required for querying Amplitude. </p>
    pub fn amplitude(&self) -> std::option::Option<&crate::model::AmplitudeSourceProperties> {
        self.amplitude.as_ref()
    }
    /// <p> Specifies the information that is required for querying Datadog. </p>
    pub fn datadog(&self) -> std::option::Option<&crate::model::DatadogSourceProperties> {
        self.datadog.as_ref()
    }
    /// <p> Specifies the information that is required for querying Dynatrace. </p>
    pub fn dynatrace(&self) -> std::option::Option<&crate::model::DynatraceSourceProperties> {
        self.dynatrace.as_ref()
    }
    /// <p> Specifies the information that is required for querying Google Analytics. </p>
    pub fn google_analytics(
        &self,
    ) -> std::option::Option<&crate::model::GoogleAnalyticsSourceProperties> {
        self.google_analytics.as_ref()
    }
    /// <p> Specifies the information that is required for querying Infor Nexus. </p>
    pub fn infor_nexus(&self) -> std::option::Option<&crate::model::InforNexusSourceProperties> {
        self.infor_nexus.as_ref()
    }
    /// <p> Specifies the information that is required for querying Marketo. </p>
    pub fn marketo(&self) -> std::option::Option<&crate::model::MarketoSourceProperties> {
        self.marketo.as_ref()
    }
    /// <p> Specifies the information that is required for querying Amazon S3. </p>
    pub fn s3(&self) -> std::option::Option<&crate::model::S3SourceProperties> {
        self.s3.as_ref()
    }
    /// <p> Specifies the information that is required for querying Salesforce. </p>
    pub fn salesforce(&self) -> std::option::Option<&crate::model::SalesforceSourceProperties> {
        self.salesforce.as_ref()
    }
    /// <p> Specifies the information that is required for querying ServiceNow. </p>
    pub fn service_now(&self) -> std::option::Option<&crate::model::ServiceNowSourceProperties> {
        self.service_now.as_ref()
    }
    /// <p> Specifies the information that is required for querying Singular. </p>
    pub fn singular(&self) -> std::option::Option<&crate::model::SingularSourceProperties> {
        self.singular.as_ref()
    }
    /// <p> Specifies the information that is required for querying Slack. </p>
    pub fn slack(&self) -> std::option::Option<&crate::model::SlackSourceProperties> {
        self.slack.as_ref()
    }
    /// <p> Specifies the information that is required for querying Trend Micro. </p>
    pub fn trendmicro(&self) -> std::option::Option<&crate::model::TrendmicroSourceProperties> {
        self.trendmicro.as_ref()
    }
    /// <p> Specifies the information that is required for querying Veeva. </p>
    pub fn veeva(&self) -> std::option::Option<&crate::model::VeevaSourceProperties> {
        self.veeva.as_ref()
    }
    /// <p> Specifies the information that is required for querying Zendesk. </p>
    pub fn zendesk(&self) -> std::option::Option<&crate::model::ZendeskSourceProperties> {
        self.zendesk.as_ref()
    }
    /// <p> The properties that are applied when using SAPOData as a flow source. </p>
    pub fn sapo_data(&self) -> std::option::Option<&crate::model::SapoDataSourceProperties> {
        self.sapo_data.as_ref()
    }
    /// <p>The properties that are applied when the custom connector is being used as a source.</p>
    pub fn custom_connector(
        &self,
    ) -> std::option::Option<&crate::model::CustomConnectorSourceProperties> {
        self.custom_connector.as_ref()
    }
}
impl std::fmt::Debug for SourceConnectorProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SourceConnectorProperties");
        formatter.field("amplitude", &self.amplitude);
        formatter.field("datadog", &self.datadog);
        formatter.field("dynatrace", &self.dynatrace);
        formatter.field("google_analytics", &self.google_analytics);
        formatter.field("infor_nexus", &self.infor_nexus);
        formatter.field("marketo", &self.marketo);
        formatter.field("s3", &self.s3);
        formatter.field("salesforce", &self.salesforce);
        formatter.field("service_now", &self.service_now);
        formatter.field("singular", &self.singular);
        formatter.field("slack", &self.slack);
        formatter.field("trendmicro", &self.trendmicro);
        formatter.field("veeva", &self.veeva);
        formatter.field("zendesk", &self.zendesk);
        formatter.field("sapo_data", &self.sapo_data);
        formatter.field("custom_connector", &self.custom_connector);
        formatter.finish()
    }
}
/// See [`SourceConnectorProperties`](crate::model::SourceConnectorProperties)
pub mod source_connector_properties {
    /// A builder for [`SourceConnectorProperties`](crate::model::SourceConnectorProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) amplitude: std::option::Option<crate::model::AmplitudeSourceProperties>,
        pub(crate) datadog: std::option::Option<crate::model::DatadogSourceProperties>,
        pub(crate) dynatrace: std::option::Option<crate::model::DynatraceSourceProperties>,
        pub(crate) google_analytics:
            std::option::Option<crate::model::GoogleAnalyticsSourceProperties>,
        pub(crate) infor_nexus: std::option::Option<crate::model::InforNexusSourceProperties>,
        pub(crate) marketo: std::option::Option<crate::model::MarketoSourceProperties>,
        pub(crate) s3: std::option::Option<crate::model::S3SourceProperties>,
        pub(crate) salesforce: std::option::Option<crate::model::SalesforceSourceProperties>,
        pub(crate) service_now: std::option::Option<crate::model::ServiceNowSourceProperties>,
        pub(crate) singular: std::option::Option<crate::model::SingularSourceProperties>,
        pub(crate) slack: std::option::Option<crate::model::SlackSourceProperties>,
        pub(crate) trendmicro: std::option::Option<crate::model::TrendmicroSourceProperties>,
        pub(crate) veeva: std::option::Option<crate::model::VeevaSourceProperties>,
        pub(crate) zendesk: std::option::Option<crate::model::ZendeskSourceProperties>,
        pub(crate) sapo_data: std::option::Option<crate::model::SapoDataSourceProperties>,
        pub(crate) custom_connector:
            std::option::Option<crate::model::CustomConnectorSourceProperties>,
    }
    impl Builder {
        /// <p> Specifies the information that is required for querying Amplitude. </p>
        pub fn amplitude(mut self, input: crate::model::AmplitudeSourceProperties) -> Self {
            self.amplitude = Some(input);
            self
        }
        /// <p> Specifies the information that is required for querying Amplitude. </p>
        pub fn set_amplitude(
            mut self,
            input: std::option::Option<crate::model::AmplitudeSourceProperties>,
        ) -> Self {
            self.amplitude = input;
            self
        }
        /// <p> Specifies the information that is required for querying Datadog. </p>
        pub fn datadog(mut self, input: crate::model::DatadogSourceProperties) -> Self {
            self.datadog = Some(input);
            self
        }
        /// <p> Specifies the information that is required for querying Datadog. </p>
        pub fn set_datadog(
            mut self,
            input: std::option::Option<crate::model::DatadogSourceProperties>,
        ) -> Self {
            self.datadog = input;
            self
        }
        /// <p> Specifies the information that is required for querying Dynatrace. </p>
        pub fn dynatrace(mut self, input: crate::model::DynatraceSourceProperties) -> Self {
            self.dynatrace = Some(input);
            self
        }
        /// <p> Specifies the information that is required for querying Dynatrace. </p>
        pub fn set_dynatrace(
            mut self,
            input: std::option::Option<crate::model::DynatraceSourceProperties>,
        ) -> Self {
            self.dynatrace = input;
            self
        }
        /// <p> Specifies the information that is required for querying Google Analytics. </p>
        pub fn google_analytics(
            mut self,
            input: crate::model::GoogleAnalyticsSourceProperties,
        ) -> Self {
            self.google_analytics = Some(input);
            self
        }
        /// <p> Specifies the information that is required for querying Google Analytics. </p>
        pub fn set_google_analytics(
            mut self,
            input: std::option::Option<crate::model::GoogleAnalyticsSourceProperties>,
        ) -> Self {
            self.google_analytics = input;
            self
        }
        /// <p> Specifies the information that is required for querying Infor Nexus. </p>
        pub fn infor_nexus(mut self, input: crate::model::InforNexusSourceProperties) -> Self {
            self.infor_nexus = Some(input);
            self
        }
        /// <p> Specifies the information that is required for querying Infor Nexus. </p>
        pub fn set_infor_nexus(
            mut self,
            input: std::option::Option<crate::model::InforNexusSourceProperties>,
        ) -> Self {
            self.infor_nexus = input;
            self
        }
        /// <p> Specifies the information that is required for querying Marketo. </p>
        pub fn marketo(mut self, input: crate::model::MarketoSourceProperties) -> Self {
            self.marketo = Some(input);
            self
        }
        /// <p> Specifies the information that is required for querying Marketo. </p>
        pub fn set_marketo(
            mut self,
            input: std::option::Option<crate::model::MarketoSourceProperties>,
        ) -> Self {
            self.marketo = input;
            self
        }
        /// <p> Specifies the information that is required for querying Amazon S3. </p>
        pub fn s3(mut self, input: crate::model::S3SourceProperties) -> Self {
            self.s3 = Some(input);
            self
        }
        /// <p> Specifies the information that is required for querying Amazon S3. </p>
        pub fn set_s3(
            mut self,
            input: std::option::Option<crate::model::S3SourceProperties>,
        ) -> Self {
            self.s3 = input;
            self
        }
        /// <p> Specifies the information that is required for querying Salesforce. </p>
        pub fn salesforce(mut self, input: crate::model::SalesforceSourceProperties) -> Self {
            self.salesforce = Some(input);
            self
        }
        /// <p> Specifies the information that is required for querying Salesforce. </p>
        pub fn set_salesforce(
            mut self,
            input: std::option::Option<crate::model::SalesforceSourceProperties>,
        ) -> Self {
            self.salesforce = input;
            self
        }
        /// <p> Specifies the information that is required for querying ServiceNow. </p>
        pub fn service_now(mut self, input: crate::model::ServiceNowSourceProperties) -> Self {
            self.service_now = Some(input);
            self
        }
        /// <p> Specifies the information that is required for querying ServiceNow. </p>
        pub fn set_service_now(
            mut self,
            input: std::option::Option<crate::model::ServiceNowSourceProperties>,
        ) -> Self {
            self.service_now = input;
            self
        }
        /// <p> Specifies the information that is required for querying Singular. </p>
        pub fn singular(mut self, input: crate::model::SingularSourceProperties) -> Self {
            self.singular = Some(input);
            self
        }
        /// <p> Specifies the information that is required for querying Singular. </p>
        pub fn set_singular(
            mut self,
            input: std::option::Option<crate::model::SingularSourceProperties>,
        ) -> Self {
            self.singular = input;
            self
        }
        /// <p> Specifies the information that is required for querying Slack. </p>
        pub fn slack(mut self, input: crate::model::SlackSourceProperties) -> Self {
            self.slack = Some(input);
            self
        }
        /// <p> Specifies the information that is required for querying Slack. </p>
        pub fn set_slack(
            mut self,
            input: std::option::Option<crate::model::SlackSourceProperties>,
        ) -> Self {
            self.slack = input;
            self
        }
        /// <p> Specifies the information that is required for querying Trend Micro. </p>
        pub fn trendmicro(mut self, input: crate::model::TrendmicroSourceProperties) -> Self {
            self.trendmicro = Some(input);
            self
        }
        /// <p> Specifies the information that is required for querying Trend Micro. </p>
        pub fn set_trendmicro(
            mut self,
            input: std::option::Option<crate::model::TrendmicroSourceProperties>,
        ) -> Self {
            self.trendmicro = input;
            self
        }
        /// <p> Specifies the information that is required for querying Veeva. </p>
        pub fn veeva(mut self, input: crate::model::VeevaSourceProperties) -> Self {
            self.veeva = Some(input);
            self
        }
        /// <p> Specifies the information that is required for querying Veeva. </p>
        pub fn set_veeva(
            mut self,
            input: std::option::Option<crate::model::VeevaSourceProperties>,
        ) -> Self {
            self.veeva = input;
            self
        }
        /// <p> Specifies the information that is required for querying Zendesk. </p>
        pub fn zendesk(mut self, input: crate::model::ZendeskSourceProperties) -> Self {
            self.zendesk = Some(input);
            self
        }
        /// <p> Specifies the information that is required for querying Zendesk. </p>
        pub fn set_zendesk(
            mut self,
            input: std::option::Option<crate::model::ZendeskSourceProperties>,
        ) -> Self {
            self.zendesk = input;
            self
        }
        /// <p> The properties that are applied when using SAPOData as a flow source. </p>
        pub fn sapo_data(mut self, input: crate::model::SapoDataSourceProperties) -> Self {
            self.sapo_data = Some(input);
            self
        }
        /// <p> The properties that are applied when using SAPOData as a flow source. </p>
        pub fn set_sapo_data(
            mut self,
            input: std::option::Option<crate::model::SapoDataSourceProperties>,
        ) -> Self {
            self.sapo_data = input;
            self
        }
        /// <p>The properties that are applied when the custom connector is being used as a source.</p>
        pub fn custom_connector(
            mut self,
            input: crate::model::CustomConnectorSourceProperties,
        ) -> Self {
            self.custom_connector = Some(input);
            self
        }
        /// <p>The properties that are applied when the custom connector is being used as a source.</p>
        pub fn set_custom_connector(
            mut self,
            input: std::option::Option<crate::model::CustomConnectorSourceProperties>,
        ) -> Self {
            self.custom_connector = input;
            self
        }
        /// Consumes the builder and constructs a [`SourceConnectorProperties`](crate::model::SourceConnectorProperties)
        pub fn build(self) -> crate::model::SourceConnectorProperties {
            crate::model::SourceConnectorProperties {
                amplitude: self.amplitude,
                datadog: self.datadog,
                dynatrace: self.dynatrace,
                google_analytics: self.google_analytics,
                infor_nexus: self.infor_nexus,
                marketo: self.marketo,
                s3: self.s3,
                salesforce: self.salesforce,
                service_now: self.service_now,
                singular: self.singular,
                slack: self.slack,
                trendmicro: self.trendmicro,
                veeva: self.veeva,
                zendesk: self.zendesk,
                sapo_data: self.sapo_data,
                custom_connector: self.custom_connector,
            }
        }
    }
}
impl SourceConnectorProperties {
    /// Creates a new builder-style object to manufacture [`SourceConnectorProperties`](crate::model::SourceConnectorProperties)
    pub fn builder() -> crate::model::source_connector_properties::Builder {
        crate::model::source_connector_properties::Builder::default()
    }
}

/// <p>The properties that are applied when the custom connector is being used as a source.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomConnectorSourceProperties {
    /// <p>The entity specified in the custom connector as a source in the flow.</p>
    pub entity_name: std::option::Option<std::string::String>,
    /// <p>Custom properties that are required to use the custom connector as a source.</p>
    pub custom_properties:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CustomConnectorSourceProperties {
    /// <p>The entity specified in the custom connector as a source in the flow.</p>
    pub fn entity_name(&self) -> std::option::Option<&str> {
        self.entity_name.as_deref()
    }
    /// <p>Custom properties that are required to use the custom connector as a source.</p>
    pub fn custom_properties(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.custom_properties.as_ref()
    }
}
impl std::fmt::Debug for CustomConnectorSourceProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomConnectorSourceProperties");
        formatter.field("entity_name", &self.entity_name);
        formatter.field("custom_properties", &self.custom_properties);
        formatter.finish()
    }
}
/// See [`CustomConnectorSourceProperties`](crate::model::CustomConnectorSourceProperties)
pub mod custom_connector_source_properties {
    /// A builder for [`CustomConnectorSourceProperties`](crate::model::CustomConnectorSourceProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) entity_name: std::option::Option<std::string::String>,
        pub(crate) custom_properties: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The entity specified in the custom connector as a source in the flow.</p>
        pub fn entity_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.entity_name = Some(input.into());
            self
        }
        /// <p>The entity specified in the custom connector as a source in the flow.</p>
        pub fn set_entity_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.entity_name = input;
            self
        }
        /// Adds a key-value pair to `custom_properties`.
        ///
        /// To override the contents of this collection use [`set_custom_properties`](Self::set_custom_properties).
        ///
        /// <p>Custom properties that are required to use the custom connector as a source.</p>
        pub fn custom_properties(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.custom_properties.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.custom_properties = Some(hash_map);
            self
        }
        /// <p>Custom properties that are required to use the custom connector as a source.</p>
        pub fn set_custom_properties(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.custom_properties = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomConnectorSourceProperties`](crate::model::CustomConnectorSourceProperties)
        pub fn build(self) -> crate::model::CustomConnectorSourceProperties {
            crate::model::CustomConnectorSourceProperties {
                entity_name: self.entity_name,
                custom_properties: self.custom_properties,
            }
        }
    }
}
impl CustomConnectorSourceProperties {
    /// Creates a new builder-style object to manufacture [`CustomConnectorSourceProperties`](crate::model::CustomConnectorSourceProperties)
    pub fn builder() -> crate::model::custom_connector_source_properties::Builder {
        crate::model::custom_connector_source_properties::Builder::default()
    }
}

/// <p> The properties that are applied when using SAPOData as a flow source. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SapoDataSourceProperties {
    /// <p> The object path specified in the SAPOData flow source. </p>
    pub object_path: std::option::Option<std::string::String>,
}
impl SapoDataSourceProperties {
    /// <p> The object path specified in the SAPOData flow source. </p>
    pub fn object_path(&self) -> std::option::Option<&str> {
        self.object_path.as_deref()
    }
}
impl std::fmt::Debug for SapoDataSourceProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SapoDataSourceProperties");
        formatter.field("object_path", &self.object_path);
        formatter.finish()
    }
}
/// See [`SapoDataSourceProperties`](crate::model::SapoDataSourceProperties)
pub mod sapo_data_source_properties {
    /// A builder for [`SapoDataSourceProperties`](crate::model::SapoDataSourceProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) object_path: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The object path specified in the SAPOData flow source. </p>
        pub fn object_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.object_path = Some(input.into());
            self
        }
        /// <p> The object path specified in the SAPOData flow source. </p>
        pub fn set_object_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.object_path = input;
            self
        }
        /// Consumes the builder and constructs a [`SapoDataSourceProperties`](crate::model::SapoDataSourceProperties)
        pub fn build(self) -> crate::model::SapoDataSourceProperties {
            crate::model::SapoDataSourceProperties {
                object_path: self.object_path,
            }
        }
    }
}
impl SapoDataSourceProperties {
    /// Creates a new builder-style object to manufacture [`SapoDataSourceProperties`](crate::model::SapoDataSourceProperties)
    pub fn builder() -> crate::model::sapo_data_source_properties::Builder {
        crate::model::sapo_data_source_properties::Builder::default()
    }
}

/// <p> The properties that are applied when using Zendesk as a flow source. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ZendeskSourceProperties {
    /// <p> The object specified in the Zendesk flow source. </p>
    pub object: std::option::Option<std::string::String>,
}
impl ZendeskSourceProperties {
    /// <p> The object specified in the Zendesk flow source. </p>
    pub fn object(&self) -> std::option::Option<&str> {
        self.object.as_deref()
    }
}
impl std::fmt::Debug for ZendeskSourceProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ZendeskSourceProperties");
        formatter.field("object", &self.object);
        formatter.finish()
    }
}
/// See [`ZendeskSourceProperties`](crate::model::ZendeskSourceProperties)
pub mod zendesk_source_properties {
    /// A builder for [`ZendeskSourceProperties`](crate::model::ZendeskSourceProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) object: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The object specified in the Zendesk flow source. </p>
        pub fn object(mut self, input: impl Into<std::string::String>) -> Self {
            self.object = Some(input.into());
            self
        }
        /// <p> The object specified in the Zendesk flow source. </p>
        pub fn set_object(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.object = input;
            self
        }
        /// Consumes the builder and constructs a [`ZendeskSourceProperties`](crate::model::ZendeskSourceProperties)
        pub fn build(self) -> crate::model::ZendeskSourceProperties {
            crate::model::ZendeskSourceProperties {
                object: self.object,
            }
        }
    }
}
impl ZendeskSourceProperties {
    /// Creates a new builder-style object to manufacture [`ZendeskSourceProperties`](crate::model::ZendeskSourceProperties)
    pub fn builder() -> crate::model::zendesk_source_properties::Builder {
        crate::model::zendesk_source_properties::Builder::default()
    }
}

/// <p> The properties that are applied when using Veeva as a flow source. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VeevaSourceProperties {
    /// <p> The object specified in the Veeva flow source. </p>
    pub object: std::option::Option<std::string::String>,
    /// <p>The document type specified in the Veeva document extract flow.</p>
    pub document_type: std::option::Option<std::string::String>,
    /// <p>Boolean value to include source files in Veeva document extract flow.</p>
    pub include_source_files: bool,
    /// <p>Boolean value to include file renditions in Veeva document extract flow.</p>
    pub include_renditions: bool,
    /// <p>Boolean value to include All Versions of files in Veeva document extract flow.</p>
    pub include_all_versions: bool,
}
impl VeevaSourceProperties {
    /// <p> The object specified in the Veeva flow source. </p>
    pub fn object(&self) -> std::option::Option<&str> {
        self.object.as_deref()
    }
    /// <p>The document type specified in the Veeva document extract flow.</p>
    pub fn document_type(&self) -> std::option::Option<&str> {
        self.document_type.as_deref()
    }
    /// <p>Boolean value to include source files in Veeva document extract flow.</p>
    pub fn include_source_files(&self) -> bool {
        self.include_source_files
    }
    /// <p>Boolean value to include file renditions in Veeva document extract flow.</p>
    pub fn include_renditions(&self) -> bool {
        self.include_renditions
    }
    /// <p>Boolean value to include All Versions of files in Veeva document extract flow.</p>
    pub fn include_all_versions(&self) -> bool {
        self.include_all_versions
    }
}
impl std::fmt::Debug for VeevaSourceProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VeevaSourceProperties");
        formatter.field("object", &self.object);
        formatter.field("document_type", &self.document_type);
        formatter.field("include_source_files", &self.include_source_files);
        formatter.field("include_renditions", &self.include_renditions);
        formatter.field("include_all_versions", &self.include_all_versions);
        formatter.finish()
    }
}
/// See [`VeevaSourceProperties`](crate::model::VeevaSourceProperties)
pub mod veeva_source_properties {
    /// A builder for [`VeevaSourceProperties`](crate::model::VeevaSourceProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) object: std::option::Option<std::string::String>,
        pub(crate) document_type: std::option::Option<std::string::String>,
        pub(crate) include_source_files: std::option::Option<bool>,
        pub(crate) include_renditions: std::option::Option<bool>,
        pub(crate) include_all_versions: std::option::Option<bool>,
    }
    impl Builder {
        /// <p> The object specified in the Veeva flow source. </p>
        pub fn object(mut self, input: impl Into<std::string::String>) -> Self {
            self.object = Some(input.into());
            self
        }
        /// <p> The object specified in the Veeva flow source. </p>
        pub fn set_object(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.object = input;
            self
        }
        /// <p>The document type specified in the Veeva document extract flow.</p>
        pub fn document_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_type = Some(input.into());
            self
        }
        /// <p>The document type specified in the Veeva document extract flow.</p>
        pub fn set_document_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.document_type = input;
            self
        }
        /// <p>Boolean value to include source files in Veeva document extract flow.</p>
        pub fn include_source_files(mut self, input: bool) -> Self {
            self.include_source_files = Some(input);
            self
        }
        /// <p>Boolean value to include source files in Veeva document extract flow.</p>
        pub fn set_include_source_files(mut self, input: std::option::Option<bool>) -> Self {
            self.include_source_files = input;
            self
        }
        /// <p>Boolean value to include file renditions in Veeva document extract flow.</p>
        pub fn include_renditions(mut self, input: bool) -> Self {
            self.include_renditions = Some(input);
            self
        }
        /// <p>Boolean value to include file renditions in Veeva document extract flow.</p>
        pub fn set_include_renditions(mut self, input: std::option::Option<bool>) -> Self {
            self.include_renditions = input;
            self
        }
        /// <p>Boolean value to include All Versions of files in Veeva document extract flow.</p>
        pub fn include_all_versions(mut self, input: bool) -> Self {
            self.include_all_versions = Some(input);
            self
        }
        /// <p>Boolean value to include All Versions of files in Veeva document extract flow.</p>
        pub fn set_include_all_versions(mut self, input: std::option::Option<bool>) -> Self {
            self.include_all_versions = input;
            self
        }
        /// Consumes the builder and constructs a [`VeevaSourceProperties`](crate::model::VeevaSourceProperties)
        pub fn build(self) -> crate::model::VeevaSourceProperties {
            crate::model::VeevaSourceProperties {
                object: self.object,
                document_type: self.document_type,
                include_source_files: self.include_source_files.unwrap_or_default(),
                include_renditions: self.include_renditions.unwrap_or_default(),
                include_all_versions: self.include_all_versions.unwrap_or_default(),
            }
        }
    }
}
impl VeevaSourceProperties {
    /// Creates a new builder-style object to manufacture [`VeevaSourceProperties`](crate::model::VeevaSourceProperties)
    pub fn builder() -> crate::model::veeva_source_properties::Builder {
        crate::model::veeva_source_properties::Builder::default()
    }
}

/// <p> The properties that are applied when using Trend Micro as a flow source. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TrendmicroSourceProperties {
    /// <p> The object specified in the Trend Micro flow source. </p>
    pub object: std::option::Option<std::string::String>,
}
impl TrendmicroSourceProperties {
    /// <p> The object specified in the Trend Micro flow source. </p>
    pub fn object(&self) -> std::option::Option<&str> {
        self.object.as_deref()
    }
}
impl std::fmt::Debug for TrendmicroSourceProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TrendmicroSourceProperties");
        formatter.field("object", &self.object);
        formatter.finish()
    }
}
/// See [`TrendmicroSourceProperties`](crate::model::TrendmicroSourceProperties)
pub mod trendmicro_source_properties {
    /// A builder for [`TrendmicroSourceProperties`](crate::model::TrendmicroSourceProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) object: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The object specified in the Trend Micro flow source. </p>
        pub fn object(mut self, input: impl Into<std::string::String>) -> Self {
            self.object = Some(input.into());
            self
        }
        /// <p> The object specified in the Trend Micro flow source. </p>
        pub fn set_object(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.object = input;
            self
        }
        /// Consumes the builder and constructs a [`TrendmicroSourceProperties`](crate::model::TrendmicroSourceProperties)
        pub fn build(self) -> crate::model::TrendmicroSourceProperties {
            crate::model::TrendmicroSourceProperties {
                object: self.object,
            }
        }
    }
}
impl TrendmicroSourceProperties {
    /// Creates a new builder-style object to manufacture [`TrendmicroSourceProperties`](crate::model::TrendmicroSourceProperties)
    pub fn builder() -> crate::model::trendmicro_source_properties::Builder {
        crate::model::trendmicro_source_properties::Builder::default()
    }
}

/// <p> The properties that are applied when Slack is being used as a source. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SlackSourceProperties {
    /// <p> The object specified in the Slack flow source. </p>
    pub object: std::option::Option<std::string::String>,
}
impl SlackSourceProperties {
    /// <p> The object specified in the Slack flow source. </p>
    pub fn object(&self) -> std::option::Option<&str> {
        self.object.as_deref()
    }
}
impl std::fmt::Debug for SlackSourceProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SlackSourceProperties");
        formatter.field("object", &self.object);
        formatter.finish()
    }
}
/// See [`SlackSourceProperties`](crate::model::SlackSourceProperties)
pub mod slack_source_properties {
    /// A builder for [`SlackSourceProperties`](crate::model::SlackSourceProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) object: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The object specified in the Slack flow source. </p>
        pub fn object(mut self, input: impl Into<std::string::String>) -> Self {
            self.object = Some(input.into());
            self
        }
        /// <p> The object specified in the Slack flow source. </p>
        pub fn set_object(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.object = input;
            self
        }
        /// Consumes the builder and constructs a [`SlackSourceProperties`](crate::model::SlackSourceProperties)
        pub fn build(self) -> crate::model::SlackSourceProperties {
            crate::model::SlackSourceProperties {
                object: self.object,
            }
        }
    }
}
impl SlackSourceProperties {
    /// Creates a new builder-style object to manufacture [`SlackSourceProperties`](crate::model::SlackSourceProperties)
    pub fn builder() -> crate::model::slack_source_properties::Builder {
        crate::model::slack_source_properties::Builder::default()
    }
}

/// <p> The properties that are applied when Singular is being used as a source. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SingularSourceProperties {
    /// <p> The object specified in the Singular flow source. </p>
    pub object: std::option::Option<std::string::String>,
}
impl SingularSourceProperties {
    /// <p> The object specified in the Singular flow source. </p>
    pub fn object(&self) -> std::option::Option<&str> {
        self.object.as_deref()
    }
}
impl std::fmt::Debug for SingularSourceProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SingularSourceProperties");
        formatter.field("object", &self.object);
        formatter.finish()
    }
}
/// See [`SingularSourceProperties`](crate::model::SingularSourceProperties)
pub mod singular_source_properties {
    /// A builder for [`SingularSourceProperties`](crate::model::SingularSourceProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) object: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The object specified in the Singular flow source. </p>
        pub fn object(mut self, input: impl Into<std::string::String>) -> Self {
            self.object = Some(input.into());
            self
        }
        /// <p> The object specified in the Singular flow source. </p>
        pub fn set_object(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.object = input;
            self
        }
        /// Consumes the builder and constructs a [`SingularSourceProperties`](crate::model::SingularSourceProperties)
        pub fn build(self) -> crate::model::SingularSourceProperties {
            crate::model::SingularSourceProperties {
                object: self.object,
            }
        }
    }
}
impl SingularSourceProperties {
    /// Creates a new builder-style object to manufacture [`SingularSourceProperties`](crate::model::SingularSourceProperties)
    pub fn builder() -> crate::model::singular_source_properties::Builder {
        crate::model::singular_source_properties::Builder::default()
    }
}

/// <p> The properties that are applied when ServiceNow is being used as a source. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceNowSourceProperties {
    /// <p> The object specified in the ServiceNow flow source. </p>
    pub object: std::option::Option<std::string::String>,
}
impl ServiceNowSourceProperties {
    /// <p> The object specified in the ServiceNow flow source. </p>
    pub fn object(&self) -> std::option::Option<&str> {
        self.object.as_deref()
    }
}
impl std::fmt::Debug for ServiceNowSourceProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceNowSourceProperties");
        formatter.field("object", &self.object);
        formatter.finish()
    }
}
/// See [`ServiceNowSourceProperties`](crate::model::ServiceNowSourceProperties)
pub mod service_now_source_properties {
    /// A builder for [`ServiceNowSourceProperties`](crate::model::ServiceNowSourceProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) object: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The object specified in the ServiceNow flow source. </p>
        pub fn object(mut self, input: impl Into<std::string::String>) -> Self {
            self.object = Some(input.into());
            self
        }
        /// <p> The object specified in the ServiceNow flow source. </p>
        pub fn set_object(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.object = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceNowSourceProperties`](crate::model::ServiceNowSourceProperties)
        pub fn build(self) -> crate::model::ServiceNowSourceProperties {
            crate::model::ServiceNowSourceProperties {
                object: self.object,
            }
        }
    }
}
impl ServiceNowSourceProperties {
    /// Creates a new builder-style object to manufacture [`ServiceNowSourceProperties`](crate::model::ServiceNowSourceProperties)
    pub fn builder() -> crate::model::service_now_source_properties::Builder {
        crate::model::service_now_source_properties::Builder::default()
    }
}

/// <p> The properties that are applied when Salesforce is being used as a source. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SalesforceSourceProperties {
    /// <p> The object specified in the Salesforce flow source. </p>
    pub object: std::option::Option<std::string::String>,
    /// <p> The flag that enables dynamic fetching of new (recently added) fields in the Salesforce objects while running a flow. </p>
    pub enable_dynamic_field_update: bool,
    /// <p> Indicates whether Amazon AppFlow includes deleted files in the flow run. </p>
    pub include_deleted_records: bool,
}
impl SalesforceSourceProperties {
    /// <p> The object specified in the Salesforce flow source. </p>
    pub fn object(&self) -> std::option::Option<&str> {
        self.object.as_deref()
    }
    /// <p> The flag that enables dynamic fetching of new (recently added) fields in the Salesforce objects while running a flow. </p>
    pub fn enable_dynamic_field_update(&self) -> bool {
        self.enable_dynamic_field_update
    }
    /// <p> Indicates whether Amazon AppFlow includes deleted files in the flow run. </p>
    pub fn include_deleted_records(&self) -> bool {
        self.include_deleted_records
    }
}
impl std::fmt::Debug for SalesforceSourceProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SalesforceSourceProperties");
        formatter.field("object", &self.object);
        formatter.field(
            "enable_dynamic_field_update",
            &self.enable_dynamic_field_update,
        );
        formatter.field("include_deleted_records", &self.include_deleted_records);
        formatter.finish()
    }
}
/// See [`SalesforceSourceProperties`](crate::model::SalesforceSourceProperties)
pub mod salesforce_source_properties {
    /// A builder for [`SalesforceSourceProperties`](crate::model::SalesforceSourceProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) object: std::option::Option<std::string::String>,
        pub(crate) enable_dynamic_field_update: std::option::Option<bool>,
        pub(crate) include_deleted_records: std::option::Option<bool>,
    }
    impl Builder {
        /// <p> The object specified in the Salesforce flow source. </p>
        pub fn object(mut self, input: impl Into<std::string::String>) -> Self {
            self.object = Some(input.into());
            self
        }
        /// <p> The object specified in the Salesforce flow source. </p>
        pub fn set_object(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.object = input;
            self
        }
        /// <p> The flag that enables dynamic fetching of new (recently added) fields in the Salesforce objects while running a flow. </p>
        pub fn enable_dynamic_field_update(mut self, input: bool) -> Self {
            self.enable_dynamic_field_update = Some(input);
            self
        }
        /// <p> The flag that enables dynamic fetching of new (recently added) fields in the Salesforce objects while running a flow. </p>
        pub fn set_enable_dynamic_field_update(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_dynamic_field_update = input;
            self
        }
        /// <p> Indicates whether Amazon AppFlow includes deleted files in the flow run. </p>
        pub fn include_deleted_records(mut self, input: bool) -> Self {
            self.include_deleted_records = Some(input);
            self
        }
        /// <p> Indicates whether Amazon AppFlow includes deleted files in the flow run. </p>
        pub fn set_include_deleted_records(mut self, input: std::option::Option<bool>) -> Self {
            self.include_deleted_records = input;
            self
        }
        /// Consumes the builder and constructs a [`SalesforceSourceProperties`](crate::model::SalesforceSourceProperties)
        pub fn build(self) -> crate::model::SalesforceSourceProperties {
            crate::model::SalesforceSourceProperties {
                object: self.object,
                enable_dynamic_field_update: self.enable_dynamic_field_update.unwrap_or_default(),
                include_deleted_records: self.include_deleted_records.unwrap_or_default(),
            }
        }
    }
}
impl SalesforceSourceProperties {
    /// Creates a new builder-style object to manufacture [`SalesforceSourceProperties`](crate::model::SalesforceSourceProperties)
    pub fn builder() -> crate::model::salesforce_source_properties::Builder {
        crate::model::salesforce_source_properties::Builder::default()
    }
}

/// <p> The properties that are applied when Amazon S3 is being used as the flow source. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3SourceProperties {
    /// <p> The Amazon S3 bucket name where the source files are stored. </p>
    pub bucket_name: std::option::Option<std::string::String>,
    /// <p> The object key for the Amazon S3 bucket in which the source files are stored. </p>
    pub bucket_prefix: std::option::Option<std::string::String>,
    /// <p> When you use Amazon S3 as the source, the configuration format that you provide the flow input data. </p>
    pub s3_input_format_config: std::option::Option<crate::model::S3InputFormatConfig>,
}
impl S3SourceProperties {
    /// <p> The Amazon S3 bucket name where the source files are stored. </p>
    pub fn bucket_name(&self) -> std::option::Option<&str> {
        self.bucket_name.as_deref()
    }
    /// <p> The object key for the Amazon S3 bucket in which the source files are stored. </p>
    pub fn bucket_prefix(&self) -> std::option::Option<&str> {
        self.bucket_prefix.as_deref()
    }
    /// <p> When you use Amazon S3 as the source, the configuration format that you provide the flow input data. </p>
    pub fn s3_input_format_config(
        &self,
    ) -> std::option::Option<&crate::model::S3InputFormatConfig> {
        self.s3_input_format_config.as_ref()
    }
}
impl std::fmt::Debug for S3SourceProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3SourceProperties");
        formatter.field("bucket_name", &self.bucket_name);
        formatter.field("bucket_prefix", &self.bucket_prefix);
        formatter.field("s3_input_format_config", &self.s3_input_format_config);
        formatter.finish()
    }
}
/// See [`S3SourceProperties`](crate::model::S3SourceProperties)
pub mod s3_source_properties {
    /// A builder for [`S3SourceProperties`](crate::model::S3SourceProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket_name: std::option::Option<std::string::String>,
        pub(crate) bucket_prefix: std::option::Option<std::string::String>,
        pub(crate) s3_input_format_config: std::option::Option<crate::model::S3InputFormatConfig>,
    }
    impl Builder {
        /// <p> The Amazon S3 bucket name where the source files are stored. </p>
        pub fn bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_name = Some(input.into());
            self
        }
        /// <p> The Amazon S3 bucket name where the source files are stored. </p>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_name = input;
            self
        }
        /// <p> The object key for the Amazon S3 bucket in which the source files are stored. </p>
        pub fn bucket_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_prefix = Some(input.into());
            self
        }
        /// <p> The object key for the Amazon S3 bucket in which the source files are stored. </p>
        pub fn set_bucket_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.bucket_prefix = input;
            self
        }
        /// <p> When you use Amazon S3 as the source, the configuration format that you provide the flow input data. </p>
        pub fn s3_input_format_config(mut self, input: crate::model::S3InputFormatConfig) -> Self {
            self.s3_input_format_config = Some(input);
            self
        }
        /// <p> When you use Amazon S3 as the source, the configuration format that you provide the flow input data. </p>
        pub fn set_s3_input_format_config(
            mut self,
            input: std::option::Option<crate::model::S3InputFormatConfig>,
        ) -> Self {
            self.s3_input_format_config = input;
            self
        }
        /// Consumes the builder and constructs a [`S3SourceProperties`](crate::model::S3SourceProperties)
        pub fn build(self) -> crate::model::S3SourceProperties {
            crate::model::S3SourceProperties {
                bucket_name: self.bucket_name,
                bucket_prefix: self.bucket_prefix,
                s3_input_format_config: self.s3_input_format_config,
            }
        }
    }
}
impl S3SourceProperties {
    /// Creates a new builder-style object to manufacture [`S3SourceProperties`](crate::model::S3SourceProperties)
    pub fn builder() -> crate::model::s3_source_properties::Builder {
        crate::model::s3_source_properties::Builder::default()
    }
}

/// <p> When you use Amazon S3 as the source, the configuration format that you provide the flow input data. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3InputFormatConfig {
    /// <p> The file type that Amazon AppFlow gets from your Amazon S3 bucket. </p>
    pub s3_input_file_type: std::option::Option<crate::model::S3InputFileType>,
}
impl S3InputFormatConfig {
    /// <p> The file type that Amazon AppFlow gets from your Amazon S3 bucket. </p>
    pub fn s3_input_file_type(&self) -> std::option::Option<&crate::model::S3InputFileType> {
        self.s3_input_file_type.as_ref()
    }
}
impl std::fmt::Debug for S3InputFormatConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3InputFormatConfig");
        formatter.field("s3_input_file_type", &self.s3_input_file_type);
        formatter.finish()
    }
}
/// See [`S3InputFormatConfig`](crate::model::S3InputFormatConfig)
pub mod s3_input_format_config {
    /// A builder for [`S3InputFormatConfig`](crate::model::S3InputFormatConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_input_file_type: std::option::Option<crate::model::S3InputFileType>,
    }
    impl Builder {
        /// <p> The file type that Amazon AppFlow gets from your Amazon S3 bucket. </p>
        pub fn s3_input_file_type(mut self, input: crate::model::S3InputFileType) -> Self {
            self.s3_input_file_type = Some(input);
            self
        }
        /// <p> The file type that Amazon AppFlow gets from your Amazon S3 bucket. </p>
        pub fn set_s3_input_file_type(
            mut self,
            input: std::option::Option<crate::model::S3InputFileType>,
        ) -> Self {
            self.s3_input_file_type = input;
            self
        }
        /// Consumes the builder and constructs a [`S3InputFormatConfig`](crate::model::S3InputFormatConfig)
        pub fn build(self) -> crate::model::S3InputFormatConfig {
            crate::model::S3InputFormatConfig {
                s3_input_file_type: self.s3_input_file_type,
            }
        }
    }
}
impl S3InputFormatConfig {
    /// Creates a new builder-style object to manufacture [`S3InputFormatConfig`](crate::model::S3InputFormatConfig)
    pub fn builder() -> crate::model::s3_input_format_config::Builder {
        crate::model::s3_input_format_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum S3InputFileType {
    #[allow(missing_docs)] // documentation missing in model
    Csv,
    #[allow(missing_docs)] // documentation missing in model
    Json,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for S3InputFileType {
    fn from(s: &str) -> Self {
        match s {
            "CSV" => S3InputFileType::Csv,
            "JSON" => S3InputFileType::Json,
            other => S3InputFileType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for S3InputFileType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(S3InputFileType::from(s))
    }
}
impl S3InputFileType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            S3InputFileType::Csv => "CSV",
            S3InputFileType::Json => "JSON",
            S3InputFileType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CSV", "JSON"]
    }
}
impl AsRef<str> for S3InputFileType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> The properties that are applied when Marketo is being used as a source. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MarketoSourceProperties {
    /// <p> The object specified in the Marketo flow source. </p>
    pub object: std::option::Option<std::string::String>,
}
impl MarketoSourceProperties {
    /// <p> The object specified in the Marketo flow source. </p>
    pub fn object(&self) -> std::option::Option<&str> {
        self.object.as_deref()
    }
}
impl std::fmt::Debug for MarketoSourceProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MarketoSourceProperties");
        formatter.field("object", &self.object);
        formatter.finish()
    }
}
/// See [`MarketoSourceProperties`](crate::model::MarketoSourceProperties)
pub mod marketo_source_properties {
    /// A builder for [`MarketoSourceProperties`](crate::model::MarketoSourceProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) object: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The object specified in the Marketo flow source. </p>
        pub fn object(mut self, input: impl Into<std::string::String>) -> Self {
            self.object = Some(input.into());
            self
        }
        /// <p> The object specified in the Marketo flow source. </p>
        pub fn set_object(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.object = input;
            self
        }
        /// Consumes the builder and constructs a [`MarketoSourceProperties`](crate::model::MarketoSourceProperties)
        pub fn build(self) -> crate::model::MarketoSourceProperties {
            crate::model::MarketoSourceProperties {
                object: self.object,
            }
        }
    }
}
impl MarketoSourceProperties {
    /// Creates a new builder-style object to manufacture [`MarketoSourceProperties`](crate::model::MarketoSourceProperties)
    pub fn builder() -> crate::model::marketo_source_properties::Builder {
        crate::model::marketo_source_properties::Builder::default()
    }
}

/// <p> The properties that are applied when Infor Nexus is being used as a source. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InforNexusSourceProperties {
    /// <p> The object specified in the Infor Nexus flow source. </p>
    pub object: std::option::Option<std::string::String>,
}
impl InforNexusSourceProperties {
    /// <p> The object specified in the Infor Nexus flow source. </p>
    pub fn object(&self) -> std::option::Option<&str> {
        self.object.as_deref()
    }
}
impl std::fmt::Debug for InforNexusSourceProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InforNexusSourceProperties");
        formatter.field("object", &self.object);
        formatter.finish()
    }
}
/// See [`InforNexusSourceProperties`](crate::model::InforNexusSourceProperties)
pub mod infor_nexus_source_properties {
    /// A builder for [`InforNexusSourceProperties`](crate::model::InforNexusSourceProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) object: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The object specified in the Infor Nexus flow source. </p>
        pub fn object(mut self, input: impl Into<std::string::String>) -> Self {
            self.object = Some(input.into());
            self
        }
        /// <p> The object specified in the Infor Nexus flow source. </p>
        pub fn set_object(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.object = input;
            self
        }
        /// Consumes the builder and constructs a [`InforNexusSourceProperties`](crate::model::InforNexusSourceProperties)
        pub fn build(self) -> crate::model::InforNexusSourceProperties {
            crate::model::InforNexusSourceProperties {
                object: self.object,
            }
        }
    }
}
impl InforNexusSourceProperties {
    /// Creates a new builder-style object to manufacture [`InforNexusSourceProperties`](crate::model::InforNexusSourceProperties)
    pub fn builder() -> crate::model::infor_nexus_source_properties::Builder {
        crate::model::infor_nexus_source_properties::Builder::default()
    }
}

/// <p> The properties that are applied when Google Analytics is being used as a source. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GoogleAnalyticsSourceProperties {
    /// <p> The object specified in the Google Analytics flow source. </p>
    pub object: std::option::Option<std::string::String>,
}
impl GoogleAnalyticsSourceProperties {
    /// <p> The object specified in the Google Analytics flow source. </p>
    pub fn object(&self) -> std::option::Option<&str> {
        self.object.as_deref()
    }
}
impl std::fmt::Debug for GoogleAnalyticsSourceProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GoogleAnalyticsSourceProperties");
        formatter.field("object", &self.object);
        formatter.finish()
    }
}
/// See [`GoogleAnalyticsSourceProperties`](crate::model::GoogleAnalyticsSourceProperties)
pub mod google_analytics_source_properties {
    /// A builder for [`GoogleAnalyticsSourceProperties`](crate::model::GoogleAnalyticsSourceProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) object: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The object specified in the Google Analytics flow source. </p>
        pub fn object(mut self, input: impl Into<std::string::String>) -> Self {
            self.object = Some(input.into());
            self
        }
        /// <p> The object specified in the Google Analytics flow source. </p>
        pub fn set_object(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.object = input;
            self
        }
        /// Consumes the builder and constructs a [`GoogleAnalyticsSourceProperties`](crate::model::GoogleAnalyticsSourceProperties)
        pub fn build(self) -> crate::model::GoogleAnalyticsSourceProperties {
            crate::model::GoogleAnalyticsSourceProperties {
                object: self.object,
            }
        }
    }
}
impl GoogleAnalyticsSourceProperties {
    /// Creates a new builder-style object to manufacture [`GoogleAnalyticsSourceProperties`](crate::model::GoogleAnalyticsSourceProperties)
    pub fn builder() -> crate::model::google_analytics_source_properties::Builder {
        crate::model::google_analytics_source_properties::Builder::default()
    }
}

/// <p> The properties that are applied when Dynatrace is being used as a source. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DynatraceSourceProperties {
    /// <p> The object specified in the Dynatrace flow source. </p>
    pub object: std::option::Option<std::string::String>,
}
impl DynatraceSourceProperties {
    /// <p> The object specified in the Dynatrace flow source. </p>
    pub fn object(&self) -> std::option::Option<&str> {
        self.object.as_deref()
    }
}
impl std::fmt::Debug for DynatraceSourceProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DynatraceSourceProperties");
        formatter.field("object", &self.object);
        formatter.finish()
    }
}
/// See [`DynatraceSourceProperties`](crate::model::DynatraceSourceProperties)
pub mod dynatrace_source_properties {
    /// A builder for [`DynatraceSourceProperties`](crate::model::DynatraceSourceProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) object: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The object specified in the Dynatrace flow source. </p>
        pub fn object(mut self, input: impl Into<std::string::String>) -> Self {
            self.object = Some(input.into());
            self
        }
        /// <p> The object specified in the Dynatrace flow source. </p>
        pub fn set_object(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.object = input;
            self
        }
        /// Consumes the builder and constructs a [`DynatraceSourceProperties`](crate::model::DynatraceSourceProperties)
        pub fn build(self) -> crate::model::DynatraceSourceProperties {
            crate::model::DynatraceSourceProperties {
                object: self.object,
            }
        }
    }
}
impl DynatraceSourceProperties {
    /// Creates a new builder-style object to manufacture [`DynatraceSourceProperties`](crate::model::DynatraceSourceProperties)
    pub fn builder() -> crate::model::dynatrace_source_properties::Builder {
        crate::model::dynatrace_source_properties::Builder::default()
    }
}

/// <p> The properties that are applied when Datadog is being used as a source. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DatadogSourceProperties {
    /// <p> The object specified in the Datadog flow source. </p>
    pub object: std::option::Option<std::string::String>,
}
impl DatadogSourceProperties {
    /// <p> The object specified in the Datadog flow source. </p>
    pub fn object(&self) -> std::option::Option<&str> {
        self.object.as_deref()
    }
}
impl std::fmt::Debug for DatadogSourceProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DatadogSourceProperties");
        formatter.field("object", &self.object);
        formatter.finish()
    }
}
/// See [`DatadogSourceProperties`](crate::model::DatadogSourceProperties)
pub mod datadog_source_properties {
    /// A builder for [`DatadogSourceProperties`](crate::model::DatadogSourceProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) object: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The object specified in the Datadog flow source. </p>
        pub fn object(mut self, input: impl Into<std::string::String>) -> Self {
            self.object = Some(input.into());
            self
        }
        /// <p> The object specified in the Datadog flow source. </p>
        pub fn set_object(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.object = input;
            self
        }
        /// Consumes the builder and constructs a [`DatadogSourceProperties`](crate::model::DatadogSourceProperties)
        pub fn build(self) -> crate::model::DatadogSourceProperties {
            crate::model::DatadogSourceProperties {
                object: self.object,
            }
        }
    }
}
impl DatadogSourceProperties {
    /// Creates a new builder-style object to manufacture [`DatadogSourceProperties`](crate::model::DatadogSourceProperties)
    pub fn builder() -> crate::model::datadog_source_properties::Builder {
        crate::model::datadog_source_properties::Builder::default()
    }
}

/// <p> The properties that are applied when Amplitude is being used as a source. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AmplitudeSourceProperties {
    /// <p> The object specified in the Amplitude flow source. </p>
    pub object: std::option::Option<std::string::String>,
}
impl AmplitudeSourceProperties {
    /// <p> The object specified in the Amplitude flow source. </p>
    pub fn object(&self) -> std::option::Option<&str> {
        self.object.as_deref()
    }
}
impl std::fmt::Debug for AmplitudeSourceProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AmplitudeSourceProperties");
        formatter.field("object", &self.object);
        formatter.finish()
    }
}
/// See [`AmplitudeSourceProperties`](crate::model::AmplitudeSourceProperties)
pub mod amplitude_source_properties {
    /// A builder for [`AmplitudeSourceProperties`](crate::model::AmplitudeSourceProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) object: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The object specified in the Amplitude flow source. </p>
        pub fn object(mut self, input: impl Into<std::string::String>) -> Self {
            self.object = Some(input.into());
            self
        }
        /// <p> The object specified in the Amplitude flow source. </p>
        pub fn set_object(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.object = input;
            self
        }
        /// Consumes the builder and constructs a [`AmplitudeSourceProperties`](crate::model::AmplitudeSourceProperties)
        pub fn build(self) -> crate::model::AmplitudeSourceProperties {
            crate::model::AmplitudeSourceProperties {
                object: self.object,
            }
        }
    }
}
impl AmplitudeSourceProperties {
    /// Creates a new builder-style object to manufacture [`AmplitudeSourceProperties`](crate::model::AmplitudeSourceProperties)
    pub fn builder() -> crate::model::amplitude_source_properties::Builder {
        crate::model::amplitude_source_properties::Builder::default()
    }
}

/// <p> The trigger settings that determine how and when Amazon AppFlow runs the specified flow. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TriggerConfig {
    /// <p> Specifies the type of flow trigger. This can be <code>OnDemand</code>, <code>Scheduled</code>, or <code>Event</code>. </p>
    pub trigger_type: std::option::Option<crate::model::TriggerType>,
    /// <p> Specifies the configuration details of a schedule-triggered flow as defined by the user. Currently, these settings only apply to the <code>Scheduled</code> trigger type. </p>
    pub trigger_properties: std::option::Option<crate::model::TriggerProperties>,
}
impl TriggerConfig {
    /// <p> Specifies the type of flow trigger. This can be <code>OnDemand</code>, <code>Scheduled</code>, or <code>Event</code>. </p>
    pub fn trigger_type(&self) -> std::option::Option<&crate::model::TriggerType> {
        self.trigger_type.as_ref()
    }
    /// <p> Specifies the configuration details of a schedule-triggered flow as defined by the user. Currently, these settings only apply to the <code>Scheduled</code> trigger type. </p>
    pub fn trigger_properties(&self) -> std::option::Option<&crate::model::TriggerProperties> {
        self.trigger_properties.as_ref()
    }
}
impl std::fmt::Debug for TriggerConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TriggerConfig");
        formatter.field("trigger_type", &self.trigger_type);
        formatter.field("trigger_properties", &self.trigger_properties);
        formatter.finish()
    }
}
/// See [`TriggerConfig`](crate::model::TriggerConfig)
pub mod trigger_config {
    /// A builder for [`TriggerConfig`](crate::model::TriggerConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trigger_type: std::option::Option<crate::model::TriggerType>,
        pub(crate) trigger_properties: std::option::Option<crate::model::TriggerProperties>,
    }
    impl Builder {
        /// <p> Specifies the type of flow trigger. This can be <code>OnDemand</code>, <code>Scheduled</code>, or <code>Event</code>. </p>
        pub fn trigger_type(mut self, input: crate::model::TriggerType) -> Self {
            self.trigger_type = Some(input);
            self
        }
        /// <p> Specifies the type of flow trigger. This can be <code>OnDemand</code>, <code>Scheduled</code>, or <code>Event</code>. </p>
        pub fn set_trigger_type(
            mut self,
            input: std::option::Option<crate::model::TriggerType>,
        ) -> Self {
            self.trigger_type = input;
            self
        }
        /// <p> Specifies the configuration details of a schedule-triggered flow as defined by the user. Currently, these settings only apply to the <code>Scheduled</code> trigger type. </p>
        pub fn trigger_properties(mut self, input: crate::model::TriggerProperties) -> Self {
            self.trigger_properties = Some(input);
            self
        }
        /// <p> Specifies the configuration details of a schedule-triggered flow as defined by the user. Currently, these settings only apply to the <code>Scheduled</code> trigger type. </p>
        pub fn set_trigger_properties(
            mut self,
            input: std::option::Option<crate::model::TriggerProperties>,
        ) -> Self {
            self.trigger_properties = input;
            self
        }
        /// Consumes the builder and constructs a [`TriggerConfig`](crate::model::TriggerConfig)
        pub fn build(self) -> crate::model::TriggerConfig {
            crate::model::TriggerConfig {
                trigger_type: self.trigger_type,
                trigger_properties: self.trigger_properties,
            }
        }
    }
}
impl TriggerConfig {
    /// Creates a new builder-style object to manufacture [`TriggerConfig`](crate::model::TriggerConfig)
    pub fn builder() -> crate::model::trigger_config::Builder {
        crate::model::trigger_config::Builder::default()
    }
}

/// <p> Specifies the configuration details that control the trigger for a flow. Currently, these settings only apply to the <code>Scheduled</code> trigger type. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TriggerProperties {
    /// <p> Specifies the configuration details of a schedule-triggered flow as defined by the user. </p>
    pub scheduled: std::option::Option<crate::model::ScheduledTriggerProperties>,
}
impl TriggerProperties {
    /// <p> Specifies the configuration details of a schedule-triggered flow as defined by the user. </p>
    pub fn scheduled(&self) -> std::option::Option<&crate::model::ScheduledTriggerProperties> {
        self.scheduled.as_ref()
    }
}
impl std::fmt::Debug for TriggerProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TriggerProperties");
        formatter.field("scheduled", &self.scheduled);
        formatter.finish()
    }
}
/// See [`TriggerProperties`](crate::model::TriggerProperties)
pub mod trigger_properties {
    /// A builder for [`TriggerProperties`](crate::model::TriggerProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) scheduled: std::option::Option<crate::model::ScheduledTriggerProperties>,
    }
    impl Builder {
        /// <p> Specifies the configuration details of a schedule-triggered flow as defined by the user. </p>
        pub fn scheduled(mut self, input: crate::model::ScheduledTriggerProperties) -> Self {
            self.scheduled = Some(input);
            self
        }
        /// <p> Specifies the configuration details of a schedule-triggered flow as defined by the user. </p>
        pub fn set_scheduled(
            mut self,
            input: std::option::Option<crate::model::ScheduledTriggerProperties>,
        ) -> Self {
            self.scheduled = input;
            self
        }
        /// Consumes the builder and constructs a [`TriggerProperties`](crate::model::TriggerProperties)
        pub fn build(self) -> crate::model::TriggerProperties {
            crate::model::TriggerProperties {
                scheduled: self.scheduled,
            }
        }
    }
}
impl TriggerProperties {
    /// Creates a new builder-style object to manufacture [`TriggerProperties`](crate::model::TriggerProperties)
    pub fn builder() -> crate::model::trigger_properties::Builder {
        crate::model::trigger_properties::Builder::default()
    }
}

/// <p> Specifies the configuration details of a schedule-triggered flow as defined by the user. Currently, these settings only apply to the <code>Scheduled</code> trigger type. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScheduledTriggerProperties {
    /// <p> The scheduling expression that determines the rate at which the schedule will run, for example <code>rate(5minutes)</code>. </p>
    pub schedule_expression: std::option::Option<std::string::String>,
    /// <p> Specifies whether a scheduled flow has an incremental data transfer or a complete data transfer for each flow run. </p>
    pub data_pull_mode: std::option::Option<crate::model::DataPullMode>,
    /// <p> Specifies the scheduled start time for a schedule-triggered flow. </p>
    pub schedule_start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> Specifies the scheduled end time for a schedule-triggered flow. </p>
    pub schedule_end_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> Specifies the time zone used when referring to the date and time of a scheduled-triggered flow, such as <code>America/New_York</code>. </p>
    pub timezone: std::option::Option<std::string::String>,
    /// <p> Specifies the optional offset that is added to the time interval for a schedule-triggered flow. </p>
    pub schedule_offset: std::option::Option<i64>,
    /// <p> Specifies the date range for the records to import from the connector in the first flow run. </p>
    pub first_execution_from: std::option::Option<aws_smithy_types::DateTime>,
}
impl ScheduledTriggerProperties {
    /// <p> The scheduling expression that determines the rate at which the schedule will run, for example <code>rate(5minutes)</code>. </p>
    pub fn schedule_expression(&self) -> std::option::Option<&str> {
        self.schedule_expression.as_deref()
    }
    /// <p> Specifies whether a scheduled flow has an incremental data transfer or a complete data transfer for each flow run. </p>
    pub fn data_pull_mode(&self) -> std::option::Option<&crate::model::DataPullMode> {
        self.data_pull_mode.as_ref()
    }
    /// <p> Specifies the scheduled start time for a schedule-triggered flow. </p>
    pub fn schedule_start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.schedule_start_time.as_ref()
    }
    /// <p> Specifies the scheduled end time for a schedule-triggered flow. </p>
    pub fn schedule_end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.schedule_end_time.as_ref()
    }
    /// <p> Specifies the time zone used when referring to the date and time of a scheduled-triggered flow, such as <code>America/New_York</code>. </p>
    pub fn timezone(&self) -> std::option::Option<&str> {
        self.timezone.as_deref()
    }
    /// <p> Specifies the optional offset that is added to the time interval for a schedule-triggered flow. </p>
    pub fn schedule_offset(&self) -> std::option::Option<i64> {
        self.schedule_offset
    }
    /// <p> Specifies the date range for the records to import from the connector in the first flow run. </p>
    pub fn first_execution_from(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.first_execution_from.as_ref()
    }
}
impl std::fmt::Debug for ScheduledTriggerProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScheduledTriggerProperties");
        formatter.field("schedule_expression", &self.schedule_expression);
        formatter.field("data_pull_mode", &self.data_pull_mode);
        formatter.field("schedule_start_time", &self.schedule_start_time);
        formatter.field("schedule_end_time", &self.schedule_end_time);
        formatter.field("timezone", &self.timezone);
        formatter.field("schedule_offset", &self.schedule_offset);
        formatter.field("first_execution_from", &self.first_execution_from);
        formatter.finish()
    }
}
/// See [`ScheduledTriggerProperties`](crate::model::ScheduledTriggerProperties)
pub mod scheduled_trigger_properties {
    /// A builder for [`ScheduledTriggerProperties`](crate::model::ScheduledTriggerProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schedule_expression: std::option::Option<std::string::String>,
        pub(crate) data_pull_mode: std::option::Option<crate::model::DataPullMode>,
        pub(crate) schedule_start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) schedule_end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) timezone: std::option::Option<std::string::String>,
        pub(crate) schedule_offset: std::option::Option<i64>,
        pub(crate) first_execution_from: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p> The scheduling expression that determines the rate at which the schedule will run, for example <code>rate(5minutes)</code>. </p>
        pub fn schedule_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.schedule_expression = Some(input.into());
            self
        }
        /// <p> The scheduling expression that determines the rate at which the schedule will run, for example <code>rate(5minutes)</code>. </p>
        pub fn set_schedule_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schedule_expression = input;
            self
        }
        /// <p> Specifies whether a scheduled flow has an incremental data transfer or a complete data transfer for each flow run. </p>
        pub fn data_pull_mode(mut self, input: crate::model::DataPullMode) -> Self {
            self.data_pull_mode = Some(input);
            self
        }
        /// <p> Specifies whether a scheduled flow has an incremental data transfer or a complete data transfer for each flow run. </p>
        pub fn set_data_pull_mode(
            mut self,
            input: std::option::Option<crate::model::DataPullMode>,
        ) -> Self {
            self.data_pull_mode = input;
            self
        }
        /// <p> Specifies the scheduled start time for a schedule-triggered flow. </p>
        pub fn schedule_start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.schedule_start_time = Some(input);
            self
        }
        /// <p> Specifies the scheduled start time for a schedule-triggered flow. </p>
        pub fn set_schedule_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.schedule_start_time = input;
            self
        }
        /// <p> Specifies the scheduled end time for a schedule-triggered flow. </p>
        pub fn schedule_end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.schedule_end_time = Some(input);
            self
        }
        /// <p> Specifies the scheduled end time for a schedule-triggered flow. </p>
        pub fn set_schedule_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.schedule_end_time = input;
            self
        }
        /// <p> Specifies the time zone used when referring to the date and time of a scheduled-triggered flow, such as <code>America/New_York</code>. </p>
        pub fn timezone(mut self, input: impl Into<std::string::String>) -> Self {
            self.timezone = Some(input.into());
            self
        }
        /// <p> Specifies the time zone used when referring to the date and time of a scheduled-triggered flow, such as <code>America/New_York</code>. </p>
        pub fn set_timezone(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.timezone = input;
            self
        }
        /// <p> Specifies the optional offset that is added to the time interval for a schedule-triggered flow. </p>
        pub fn schedule_offset(mut self, input: i64) -> Self {
            self.schedule_offset = Some(input);
            self
        }
        /// <p> Specifies the optional offset that is added to the time interval for a schedule-triggered flow. </p>
        pub fn set_schedule_offset(mut self, input: std::option::Option<i64>) -> Self {
            self.schedule_offset = input;
            self
        }
        /// <p> Specifies the date range for the records to import from the connector in the first flow run. </p>
        pub fn first_execution_from(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.first_execution_from = Some(input);
            self
        }
        /// <p> Specifies the date range for the records to import from the connector in the first flow run. </p>
        pub fn set_first_execution_from(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.first_execution_from = input;
            self
        }
        /// Consumes the builder and constructs a [`ScheduledTriggerProperties`](crate::model::ScheduledTriggerProperties)
        pub fn build(self) -> crate::model::ScheduledTriggerProperties {
            crate::model::ScheduledTriggerProperties {
                schedule_expression: self.schedule_expression,
                data_pull_mode: self.data_pull_mode,
                schedule_start_time: self.schedule_start_time,
                schedule_end_time: self.schedule_end_time,
                timezone: self.timezone,
                schedule_offset: self.schedule_offset,
                first_execution_from: self.first_execution_from,
            }
        }
    }
}
impl ScheduledTriggerProperties {
    /// Creates a new builder-style object to manufacture [`ScheduledTriggerProperties`](crate::model::ScheduledTriggerProperties)
    pub fn builder() -> crate::model::scheduled_trigger_properties::Builder {
        crate::model::scheduled_trigger_properties::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DataPullMode {
    #[allow(missing_docs)] // documentation missing in model
    Complete,
    #[allow(missing_docs)] // documentation missing in model
    Incremental,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DataPullMode {
    fn from(s: &str) -> Self {
        match s {
            "Complete" => DataPullMode::Complete,
            "Incremental" => DataPullMode::Incremental,
            other => DataPullMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DataPullMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DataPullMode::from(s))
    }
}
impl DataPullMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DataPullMode::Complete => "Complete",
            DataPullMode::Incremental => "Incremental",
            DataPullMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Complete", "Incremental"]
    }
}
impl AsRef<str> for DataPullMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TriggerType {
    #[allow(missing_docs)] // documentation missing in model
    Event,
    #[allow(missing_docs)] // documentation missing in model
    Ondemand,
    #[allow(missing_docs)] // documentation missing in model
    Scheduled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TriggerType {
    fn from(s: &str) -> Self {
        match s {
            "Event" => TriggerType::Event,
            "OnDemand" => TriggerType::Ondemand,
            "Scheduled" => TriggerType::Scheduled,
            other => TriggerType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TriggerType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TriggerType::from(s))
    }
}
impl TriggerType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TriggerType::Event => "Event",
            TriggerType::Ondemand => "OnDemand",
            TriggerType::Scheduled => "Scheduled",
            TriggerType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Event", "OnDemand", "Scheduled"]
    }
}
impl AsRef<str> for TriggerType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> Defines the connector-specific configuration and credentials for the connector profile. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConnectorProfileConfig {
    /// <p> The connector-specific properties of the profile configuration. </p>
    pub connector_profile_properties: std::option::Option<crate::model::ConnectorProfileProperties>,
    /// <p> The connector-specific credentials required by each connector. </p>
    pub connector_profile_credentials:
        std::option::Option<crate::model::ConnectorProfileCredentials>,
}
impl ConnectorProfileConfig {
    /// <p> The connector-specific properties of the profile configuration. </p>
    pub fn connector_profile_properties(
        &self,
    ) -> std::option::Option<&crate::model::ConnectorProfileProperties> {
        self.connector_profile_properties.as_ref()
    }
    /// <p> The connector-specific credentials required by each connector. </p>
    pub fn connector_profile_credentials(
        &self,
    ) -> std::option::Option<&crate::model::ConnectorProfileCredentials> {
        self.connector_profile_credentials.as_ref()
    }
}
impl std::fmt::Debug for ConnectorProfileConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConnectorProfileConfig");
        formatter.field(
            "connector_profile_properties",
            &self.connector_profile_properties,
        );
        formatter.field(
            "connector_profile_credentials",
            &self.connector_profile_credentials,
        );
        formatter.finish()
    }
}
/// See [`ConnectorProfileConfig`](crate::model::ConnectorProfileConfig)
pub mod connector_profile_config {
    /// A builder for [`ConnectorProfileConfig`](crate::model::ConnectorProfileConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connector_profile_properties:
            std::option::Option<crate::model::ConnectorProfileProperties>,
        pub(crate) connector_profile_credentials:
            std::option::Option<crate::model::ConnectorProfileCredentials>,
    }
    impl Builder {
        /// <p> The connector-specific properties of the profile configuration. </p>
        pub fn connector_profile_properties(
            mut self,
            input: crate::model::ConnectorProfileProperties,
        ) -> Self {
            self.connector_profile_properties = Some(input);
            self
        }
        /// <p> The connector-specific properties of the profile configuration. </p>
        pub fn set_connector_profile_properties(
            mut self,
            input: std::option::Option<crate::model::ConnectorProfileProperties>,
        ) -> Self {
            self.connector_profile_properties = input;
            self
        }
        /// <p> The connector-specific credentials required by each connector. </p>
        pub fn connector_profile_credentials(
            mut self,
            input: crate::model::ConnectorProfileCredentials,
        ) -> Self {
            self.connector_profile_credentials = Some(input);
            self
        }
        /// <p> The connector-specific credentials required by each connector. </p>
        pub fn set_connector_profile_credentials(
            mut self,
            input: std::option::Option<crate::model::ConnectorProfileCredentials>,
        ) -> Self {
            self.connector_profile_credentials = input;
            self
        }
        /// Consumes the builder and constructs a [`ConnectorProfileConfig`](crate::model::ConnectorProfileConfig)
        pub fn build(self) -> crate::model::ConnectorProfileConfig {
            crate::model::ConnectorProfileConfig {
                connector_profile_properties: self.connector_profile_properties,
                connector_profile_credentials: self.connector_profile_credentials,
            }
        }
    }
}
impl ConnectorProfileConfig {
    /// Creates a new builder-style object to manufacture [`ConnectorProfileConfig`](crate::model::ConnectorProfileConfig)
    pub fn builder() -> crate::model::connector_profile_config::Builder {
        crate::model::connector_profile_config::Builder::default()
    }
}

/// <p> The connector-specific credentials required by a connector. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConnectorProfileCredentials {
    /// <p> The connector-specific credentials required when using Amplitude. </p>
    pub amplitude: std::option::Option<crate::model::AmplitudeConnectorProfileCredentials>,
    /// <p> The connector-specific credentials required when using Datadog. </p>
    pub datadog: std::option::Option<crate::model::DatadogConnectorProfileCredentials>,
    /// <p> The connector-specific credentials required when using Dynatrace. </p>
    pub dynatrace: std::option::Option<crate::model::DynatraceConnectorProfileCredentials>,
    /// <p> The connector-specific credentials required when using Google Analytics. </p>
    pub google_analytics:
        std::option::Option<crate::model::GoogleAnalyticsConnectorProfileCredentials>,
    /// <p> The connector-specific credentials required when using Amazon Honeycode. </p>
    pub honeycode: std::option::Option<crate::model::HoneycodeConnectorProfileCredentials>,
    /// <p> The connector-specific credentials required when using Infor Nexus. </p>
    pub infor_nexus: std::option::Option<crate::model::InforNexusConnectorProfileCredentials>,
    /// <p> The connector-specific credentials required when using Marketo. </p>
    pub marketo: std::option::Option<crate::model::MarketoConnectorProfileCredentials>,
    /// <p> The connector-specific credentials required when using Amazon Redshift. </p>
    pub redshift: std::option::Option<crate::model::RedshiftConnectorProfileCredentials>,
    /// <p> The connector-specific credentials required when using Salesforce. </p>
    pub salesforce: std::option::Option<crate::model::SalesforceConnectorProfileCredentials>,
    /// <p> The connector-specific credentials required when using ServiceNow. </p>
    pub service_now: std::option::Option<crate::model::ServiceNowConnectorProfileCredentials>,
    /// <p> The connector-specific credentials required when using Singular. </p>
    pub singular: std::option::Option<crate::model::SingularConnectorProfileCredentials>,
    /// <p> The connector-specific credentials required when using Slack. </p>
    pub slack: std::option::Option<crate::model::SlackConnectorProfileCredentials>,
    /// <p> The connector-specific credentials required when using Snowflake. </p>
    pub snowflake: std::option::Option<crate::model::SnowflakeConnectorProfileCredentials>,
    /// <p> The connector-specific credentials required when using Trend Micro. </p>
    pub trendmicro: std::option::Option<crate::model::TrendmicroConnectorProfileCredentials>,
    /// <p> The connector-specific credentials required when using Veeva. </p>
    pub veeva: std::option::Option<crate::model::VeevaConnectorProfileCredentials>,
    /// <p> The connector-specific credentials required when using Zendesk. </p>
    pub zendesk: std::option::Option<crate::model::ZendeskConnectorProfileCredentials>,
    /// <p> The connector-specific profile credentials required when using SAPOData. </p>
    pub sapo_data: std::option::Option<crate::model::SapoDataConnectorProfileCredentials>,
    /// <p>The connector-specific profile credentials that are required when using the custom connector.</p>
    pub custom_connector: std::option::Option<crate::model::CustomConnectorProfileCredentials>,
}
impl ConnectorProfileCredentials {
    /// <p> The connector-specific credentials required when using Amplitude. </p>
    pub fn amplitude(
        &self,
    ) -> std::option::Option<&crate::model::AmplitudeConnectorProfileCredentials> {
        self.amplitude.as_ref()
    }
    /// <p> The connector-specific credentials required when using Datadog. </p>
    pub fn datadog(
        &self,
    ) -> std::option::Option<&crate::model::DatadogConnectorProfileCredentials> {
        self.datadog.as_ref()
    }
    /// <p> The connector-specific credentials required when using Dynatrace. </p>
    pub fn dynatrace(
        &self,
    ) -> std::option::Option<&crate::model::DynatraceConnectorProfileCredentials> {
        self.dynatrace.as_ref()
    }
    /// <p> The connector-specific credentials required when using Google Analytics. </p>
    pub fn google_analytics(
        &self,
    ) -> std::option::Option<&crate::model::GoogleAnalyticsConnectorProfileCredentials> {
        self.google_analytics.as_ref()
    }
    /// <p> The connector-specific credentials required when using Amazon Honeycode. </p>
    pub fn honeycode(
        &self,
    ) -> std::option::Option<&crate::model::HoneycodeConnectorProfileCredentials> {
        self.honeycode.as_ref()
    }
    /// <p> The connector-specific credentials required when using Infor Nexus. </p>
    pub fn infor_nexus(
        &self,
    ) -> std::option::Option<&crate::model::InforNexusConnectorProfileCredentials> {
        self.infor_nexus.as_ref()
    }
    /// <p> The connector-specific credentials required when using Marketo. </p>
    pub fn marketo(
        &self,
    ) -> std::option::Option<&crate::model::MarketoConnectorProfileCredentials> {
        self.marketo.as_ref()
    }
    /// <p> The connector-specific credentials required when using Amazon Redshift. </p>
    pub fn redshift(
        &self,
    ) -> std::option::Option<&crate::model::RedshiftConnectorProfileCredentials> {
        self.redshift.as_ref()
    }
    /// <p> The connector-specific credentials required when using Salesforce. </p>
    pub fn salesforce(
        &self,
    ) -> std::option::Option<&crate::model::SalesforceConnectorProfileCredentials> {
        self.salesforce.as_ref()
    }
    /// <p> The connector-specific credentials required when using ServiceNow. </p>
    pub fn service_now(
        &self,
    ) -> std::option::Option<&crate::model::ServiceNowConnectorProfileCredentials> {
        self.service_now.as_ref()
    }
    /// <p> The connector-specific credentials required when using Singular. </p>
    pub fn singular(
        &self,
    ) -> std::option::Option<&crate::model::SingularConnectorProfileCredentials> {
        self.singular.as_ref()
    }
    /// <p> The connector-specific credentials required when using Slack. </p>
    pub fn slack(&self) -> std::option::Option<&crate::model::SlackConnectorProfileCredentials> {
        self.slack.as_ref()
    }
    /// <p> The connector-specific credentials required when using Snowflake. </p>
    pub fn snowflake(
        &self,
    ) -> std::option::Option<&crate::model::SnowflakeConnectorProfileCredentials> {
        self.snowflake.as_ref()
    }
    /// <p> The connector-specific credentials required when using Trend Micro. </p>
    pub fn trendmicro(
        &self,
    ) -> std::option::Option<&crate::model::TrendmicroConnectorProfileCredentials> {
        self.trendmicro.as_ref()
    }
    /// <p> The connector-specific credentials required when using Veeva. </p>
    pub fn veeva(&self) -> std::option::Option<&crate::model::VeevaConnectorProfileCredentials> {
        self.veeva.as_ref()
    }
    /// <p> The connector-specific credentials required when using Zendesk. </p>
    pub fn zendesk(
        &self,
    ) -> std::option::Option<&crate::model::ZendeskConnectorProfileCredentials> {
        self.zendesk.as_ref()
    }
    /// <p> The connector-specific profile credentials required when using SAPOData. </p>
    pub fn sapo_data(
        &self,
    ) -> std::option::Option<&crate::model::SapoDataConnectorProfileCredentials> {
        self.sapo_data.as_ref()
    }
    /// <p>The connector-specific profile credentials that are required when using the custom connector.</p>
    pub fn custom_connector(
        &self,
    ) -> std::option::Option<&crate::model::CustomConnectorProfileCredentials> {
        self.custom_connector.as_ref()
    }
}
impl std::fmt::Debug for ConnectorProfileCredentials {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConnectorProfileCredentials");
        formatter.field("amplitude", &self.amplitude);
        formatter.field("datadog", &self.datadog);
        formatter.field("dynatrace", &self.dynatrace);
        formatter.field("google_analytics", &self.google_analytics);
        formatter.field("honeycode", &self.honeycode);
        formatter.field("infor_nexus", &self.infor_nexus);
        formatter.field("marketo", &self.marketo);
        formatter.field("redshift", &self.redshift);
        formatter.field("salesforce", &self.salesforce);
        formatter.field("service_now", &self.service_now);
        formatter.field("singular", &self.singular);
        formatter.field("slack", &self.slack);
        formatter.field("snowflake", &self.snowflake);
        formatter.field("trendmicro", &self.trendmicro);
        formatter.field("veeva", &self.veeva);
        formatter.field("zendesk", &self.zendesk);
        formatter.field("sapo_data", &self.sapo_data);
        formatter.field("custom_connector", &self.custom_connector);
        formatter.finish()
    }
}
/// See [`ConnectorProfileCredentials`](crate::model::ConnectorProfileCredentials)
pub mod connector_profile_credentials {
    /// A builder for [`ConnectorProfileCredentials`](crate::model::ConnectorProfileCredentials)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) amplitude:
            std::option::Option<crate::model::AmplitudeConnectorProfileCredentials>,
        pub(crate) datadog: std::option::Option<crate::model::DatadogConnectorProfileCredentials>,
        pub(crate) dynatrace:
            std::option::Option<crate::model::DynatraceConnectorProfileCredentials>,
        pub(crate) google_analytics:
            std::option::Option<crate::model::GoogleAnalyticsConnectorProfileCredentials>,
        pub(crate) honeycode:
            std::option::Option<crate::model::HoneycodeConnectorProfileCredentials>,
        pub(crate) infor_nexus:
            std::option::Option<crate::model::InforNexusConnectorProfileCredentials>,
        pub(crate) marketo: std::option::Option<crate::model::MarketoConnectorProfileCredentials>,
        pub(crate) redshift: std::option::Option<crate::model::RedshiftConnectorProfileCredentials>,
        pub(crate) salesforce:
            std::option::Option<crate::model::SalesforceConnectorProfileCredentials>,
        pub(crate) service_now:
            std::option::Option<crate::model::ServiceNowConnectorProfileCredentials>,
        pub(crate) singular: std::option::Option<crate::model::SingularConnectorProfileCredentials>,
        pub(crate) slack: std::option::Option<crate::model::SlackConnectorProfileCredentials>,
        pub(crate) snowflake:
            std::option::Option<crate::model::SnowflakeConnectorProfileCredentials>,
        pub(crate) trendmicro:
            std::option::Option<crate::model::TrendmicroConnectorProfileCredentials>,
        pub(crate) veeva: std::option::Option<crate::model::VeevaConnectorProfileCredentials>,
        pub(crate) zendesk: std::option::Option<crate::model::ZendeskConnectorProfileCredentials>,
        pub(crate) sapo_data:
            std::option::Option<crate::model::SapoDataConnectorProfileCredentials>,
        pub(crate) custom_connector:
            std::option::Option<crate::model::CustomConnectorProfileCredentials>,
    }
    impl Builder {
        /// <p> The connector-specific credentials required when using Amplitude. </p>
        pub fn amplitude(
            mut self,
            input: crate::model::AmplitudeConnectorProfileCredentials,
        ) -> Self {
            self.amplitude = Some(input);
            self
        }
        /// <p> The connector-specific credentials required when using Amplitude. </p>
        pub fn set_amplitude(
            mut self,
            input: std::option::Option<crate::model::AmplitudeConnectorProfileCredentials>,
        ) -> Self {
            self.amplitude = input;
            self
        }
        /// <p> The connector-specific credentials required when using Datadog. </p>
        pub fn datadog(mut self, input: crate::model::DatadogConnectorProfileCredentials) -> Self {
            self.datadog = Some(input);
            self
        }
        /// <p> The connector-specific credentials required when using Datadog. </p>
        pub fn set_datadog(
            mut self,
            input: std::option::Option<crate::model::DatadogConnectorProfileCredentials>,
        ) -> Self {
            self.datadog = input;
            self
        }
        /// <p> The connector-specific credentials required when using Dynatrace. </p>
        pub fn dynatrace(
            mut self,
            input: crate::model::DynatraceConnectorProfileCredentials,
        ) -> Self {
            self.dynatrace = Some(input);
            self
        }
        /// <p> The connector-specific credentials required when using Dynatrace. </p>
        pub fn set_dynatrace(
            mut self,
            input: std::option::Option<crate::model::DynatraceConnectorProfileCredentials>,
        ) -> Self {
            self.dynatrace = input;
            self
        }
        /// <p> The connector-specific credentials required when using Google Analytics. </p>
        pub fn google_analytics(
            mut self,
            input: crate::model::GoogleAnalyticsConnectorProfileCredentials,
        ) -> Self {
            self.google_analytics = Some(input);
            self
        }
        /// <p> The connector-specific credentials required when using Google Analytics. </p>
        pub fn set_google_analytics(
            mut self,
            input: std::option::Option<crate::model::GoogleAnalyticsConnectorProfileCredentials>,
        ) -> Self {
            self.google_analytics = input;
            self
        }
        /// <p> The connector-specific credentials required when using Amazon Honeycode. </p>
        pub fn honeycode(
            mut self,
            input: crate::model::HoneycodeConnectorProfileCredentials,
        ) -> Self {
            self.honeycode = Some(input);
            self
        }
        /// <p> The connector-specific credentials required when using Amazon Honeycode. </p>
        pub fn set_honeycode(
            mut self,
            input: std::option::Option<crate::model::HoneycodeConnectorProfileCredentials>,
        ) -> Self {
            self.honeycode = input;
            self
        }
        /// <p> The connector-specific credentials required when using Infor Nexus. </p>
        pub fn infor_nexus(
            mut self,
            input: crate::model::InforNexusConnectorProfileCredentials,
        ) -> Self {
            self.infor_nexus = Some(input);
            self
        }
        /// <p> The connector-specific credentials required when using Infor Nexus. </p>
        pub fn set_infor_nexus(
            mut self,
            input: std::option::Option<crate::model::InforNexusConnectorProfileCredentials>,
        ) -> Self {
            self.infor_nexus = input;
            self
        }
        /// <p> The connector-specific credentials required when using Marketo. </p>
        pub fn marketo(mut self, input: crate::model::MarketoConnectorProfileCredentials) -> Self {
            self.marketo = Some(input);
            self
        }
        /// <p> The connector-specific credentials required when using Marketo. </p>
        pub fn set_marketo(
            mut self,
            input: std::option::Option<crate::model::MarketoConnectorProfileCredentials>,
        ) -> Self {
            self.marketo = input;
            self
        }
        /// <p> The connector-specific credentials required when using Amazon Redshift. </p>
        pub fn redshift(
            mut self,
            input: crate::model::RedshiftConnectorProfileCredentials,
        ) -> Self {
            self.redshift = Some(input);
            self
        }
        /// <p> The connector-specific credentials required when using Amazon Redshift. </p>
        pub fn set_redshift(
            mut self,
            input: std::option::Option<crate::model::RedshiftConnectorProfileCredentials>,
        ) -> Self {
            self.redshift = input;
            self
        }
        /// <p> The connector-specific credentials required when using Salesforce. </p>
        pub fn salesforce(
            mut self,
            input: crate::model::SalesforceConnectorProfileCredentials,
        ) -> Self {
            self.salesforce = Some(input);
            self
        }
        /// <p> The connector-specific credentials required when using Salesforce. </p>
        pub fn set_salesforce(
            mut self,
            input: std::option::Option<crate::model::SalesforceConnectorProfileCredentials>,
        ) -> Self {
            self.salesforce = input;
            self
        }
        /// <p> The connector-specific credentials required when using ServiceNow. </p>
        pub fn service_now(
            mut self,
            input: crate::model::ServiceNowConnectorProfileCredentials,
        ) -> Self {
            self.service_now = Some(input);
            self
        }
        /// <p> The connector-specific credentials required when using ServiceNow. </p>
        pub fn set_service_now(
            mut self,
            input: std::option::Option<crate::model::ServiceNowConnectorProfileCredentials>,
        ) -> Self {
            self.service_now = input;
            self
        }
        /// <p> The connector-specific credentials required when using Singular. </p>
        pub fn singular(
            mut self,
            input: crate::model::SingularConnectorProfileCredentials,
        ) -> Self {
            self.singular = Some(input);
            self
        }
        /// <p> The connector-specific credentials required when using Singular. </p>
        pub fn set_singular(
            mut self,
            input: std::option::Option<crate::model::SingularConnectorProfileCredentials>,
        ) -> Self {
            self.singular = input;
            self
        }
        /// <p> The connector-specific credentials required when using Slack. </p>
        pub fn slack(mut self, input: crate::model::SlackConnectorProfileCredentials) -> Self {
            self.slack = Some(input);
            self
        }
        /// <p> The connector-specific credentials required when using Slack. </p>
        pub fn set_slack(
            mut self,
            input: std::option::Option<crate::model::SlackConnectorProfileCredentials>,
        ) -> Self {
            self.slack = input;
            self
        }
        /// <p> The connector-specific credentials required when using Snowflake. </p>
        pub fn snowflake(
            mut self,
            input: crate::model::SnowflakeConnectorProfileCredentials,
        ) -> Self {
            self.snowflake = Some(input);
            self
        }
        /// <p> The connector-specific credentials required when using Snowflake. </p>
        pub fn set_snowflake(
            mut self,
            input: std::option::Option<crate::model::SnowflakeConnectorProfileCredentials>,
        ) -> Self {
            self.snowflake = input;
            self
        }
        /// <p> The connector-specific credentials required when using Trend Micro. </p>
        pub fn trendmicro(
            mut self,
            input: crate::model::TrendmicroConnectorProfileCredentials,
        ) -> Self {
            self.trendmicro = Some(input);
            self
        }
        /// <p> The connector-specific credentials required when using Trend Micro. </p>
        pub fn set_trendmicro(
            mut self,
            input: std::option::Option<crate::model::TrendmicroConnectorProfileCredentials>,
        ) -> Self {
            self.trendmicro = input;
            self
        }
        /// <p> The connector-specific credentials required when using Veeva. </p>
        pub fn veeva(mut self, input: crate::model::VeevaConnectorProfileCredentials) -> Self {
            self.veeva = Some(input);
            self
        }
        /// <p> The connector-specific credentials required when using Veeva. </p>
        pub fn set_veeva(
            mut self,
            input: std::option::Option<crate::model::VeevaConnectorProfileCredentials>,
        ) -> Self {
            self.veeva = input;
            self
        }
        /// <p> The connector-specific credentials required when using Zendesk. </p>
        pub fn zendesk(mut self, input: crate::model::ZendeskConnectorProfileCredentials) -> Self {
            self.zendesk = Some(input);
            self
        }
        /// <p> The connector-specific credentials required when using Zendesk. </p>
        pub fn set_zendesk(
            mut self,
            input: std::option::Option<crate::model::ZendeskConnectorProfileCredentials>,
        ) -> Self {
            self.zendesk = input;
            self
        }
        /// <p> The connector-specific profile credentials required when using SAPOData. </p>
        pub fn sapo_data(
            mut self,
            input: crate::model::SapoDataConnectorProfileCredentials,
        ) -> Self {
            self.sapo_data = Some(input);
            self
        }
        /// <p> The connector-specific profile credentials required when using SAPOData. </p>
        pub fn set_sapo_data(
            mut self,
            input: std::option::Option<crate::model::SapoDataConnectorProfileCredentials>,
        ) -> Self {
            self.sapo_data = input;
            self
        }
        /// <p>The connector-specific profile credentials that are required when using the custom connector.</p>
        pub fn custom_connector(
            mut self,
            input: crate::model::CustomConnectorProfileCredentials,
        ) -> Self {
            self.custom_connector = Some(input);
            self
        }
        /// <p>The connector-specific profile credentials that are required when using the custom connector.</p>
        pub fn set_custom_connector(
            mut self,
            input: std::option::Option<crate::model::CustomConnectorProfileCredentials>,
        ) -> Self {
            self.custom_connector = input;
            self
        }
        /// Consumes the builder and constructs a [`ConnectorProfileCredentials`](crate::model::ConnectorProfileCredentials)
        pub fn build(self) -> crate::model::ConnectorProfileCredentials {
            crate::model::ConnectorProfileCredentials {
                amplitude: self.amplitude,
                datadog: self.datadog,
                dynatrace: self.dynatrace,
                google_analytics: self.google_analytics,
                honeycode: self.honeycode,
                infor_nexus: self.infor_nexus,
                marketo: self.marketo,
                redshift: self.redshift,
                salesforce: self.salesforce,
                service_now: self.service_now,
                singular: self.singular,
                slack: self.slack,
                snowflake: self.snowflake,
                trendmicro: self.trendmicro,
                veeva: self.veeva,
                zendesk: self.zendesk,
                sapo_data: self.sapo_data,
                custom_connector: self.custom_connector,
            }
        }
    }
}
impl ConnectorProfileCredentials {
    /// Creates a new builder-style object to manufacture [`ConnectorProfileCredentials`](crate::model::ConnectorProfileCredentials)
    pub fn builder() -> crate::model::connector_profile_credentials::Builder {
        crate::model::connector_profile_credentials::Builder::default()
    }
}

/// <p>The connector-specific profile credentials that are required when using the custom connector.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomConnectorProfileCredentials {
    /// <p>The authentication type that the custom connector uses for authenticating while creating a connector profile.</p>
    pub authentication_type: std::option::Option<crate::model::AuthenticationType>,
    /// <p>The basic credentials that are required for the authentication of the user.</p>
    pub basic: std::option::Option<crate::model::BasicAuthCredentials>,
    /// <p>The OAuth 2.0 credentials required for the authentication of the user.</p>
    pub oauth2: std::option::Option<crate::model::OAuth2Credentials>,
    /// <p>The API keys required for the authentication of the user.</p>
    pub api_key: std::option::Option<crate::model::ApiKeyCredentials>,
    /// <p>If the connector uses the custom authentication mechanism, this holds the required credentials.</p>
    pub custom: std::option::Option<crate::model::CustomAuthCredentials>,
}
impl CustomConnectorProfileCredentials {
    /// <p>The authentication type that the custom connector uses for authenticating while creating a connector profile.</p>
    pub fn authentication_type(&self) -> std::option::Option<&crate::model::AuthenticationType> {
        self.authentication_type.as_ref()
    }
    /// <p>The basic credentials that are required for the authentication of the user.</p>
    pub fn basic(&self) -> std::option::Option<&crate::model::BasicAuthCredentials> {
        self.basic.as_ref()
    }
    /// <p>The OAuth 2.0 credentials required for the authentication of the user.</p>
    pub fn oauth2(&self) -> std::option::Option<&crate::model::OAuth2Credentials> {
        self.oauth2.as_ref()
    }
    /// <p>The API keys required for the authentication of the user.</p>
    pub fn api_key(&self) -> std::option::Option<&crate::model::ApiKeyCredentials> {
        self.api_key.as_ref()
    }
    /// <p>If the connector uses the custom authentication mechanism, this holds the required credentials.</p>
    pub fn custom(&self) -> std::option::Option<&crate::model::CustomAuthCredentials> {
        self.custom.as_ref()
    }
}
impl std::fmt::Debug for CustomConnectorProfileCredentials {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomConnectorProfileCredentials");
        formatter.field("authentication_type", &self.authentication_type);
        formatter.field("basic", &self.basic);
        formatter.field("oauth2", &self.oauth2);
        formatter.field("api_key", &self.api_key);
        formatter.field("custom", &self.custom);
        formatter.finish()
    }
}
/// See [`CustomConnectorProfileCredentials`](crate::model::CustomConnectorProfileCredentials)
pub mod custom_connector_profile_credentials {
    /// A builder for [`CustomConnectorProfileCredentials`](crate::model::CustomConnectorProfileCredentials)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_type: std::option::Option<crate::model::AuthenticationType>,
        pub(crate) basic: std::option::Option<crate::model::BasicAuthCredentials>,
        pub(crate) oauth2: std::option::Option<crate::model::OAuth2Credentials>,
        pub(crate) api_key: std::option::Option<crate::model::ApiKeyCredentials>,
        pub(crate) custom: std::option::Option<crate::model::CustomAuthCredentials>,
    }
    impl Builder {
        /// <p>The authentication type that the custom connector uses for authenticating while creating a connector profile.</p>
        pub fn authentication_type(mut self, input: crate::model::AuthenticationType) -> Self {
            self.authentication_type = Some(input);
            self
        }
        /// <p>The authentication type that the custom connector uses for authenticating while creating a connector profile.</p>
        pub fn set_authentication_type(
            mut self,
            input: std::option::Option<crate::model::AuthenticationType>,
        ) -> Self {
            self.authentication_type = input;
            self
        }
        /// <p>The basic credentials that are required for the authentication of the user.</p>
        pub fn basic(mut self, input: crate::model::BasicAuthCredentials) -> Self {
            self.basic = Some(input);
            self
        }
        /// <p>The basic credentials that are required for the authentication of the user.</p>
        pub fn set_basic(
            mut self,
            input: std::option::Option<crate::model::BasicAuthCredentials>,
        ) -> Self {
            self.basic = input;
            self
        }
        /// <p>The OAuth 2.0 credentials required for the authentication of the user.</p>
        pub fn oauth2(mut self, input: crate::model::OAuth2Credentials) -> Self {
            self.oauth2 = Some(input);
            self
        }
        /// <p>The OAuth 2.0 credentials required for the authentication of the user.</p>
        pub fn set_oauth2(
            mut self,
            input: std::option::Option<crate::model::OAuth2Credentials>,
        ) -> Self {
            self.oauth2 = input;
            self
        }
        /// <p>The API keys required for the authentication of the user.</p>
        pub fn api_key(mut self, input: crate::model::ApiKeyCredentials) -> Self {
            self.api_key = Some(input);
            self
        }
        /// <p>The API keys required for the authentication of the user.</p>
        pub fn set_api_key(
            mut self,
            input: std::option::Option<crate::model::ApiKeyCredentials>,
        ) -> Self {
            self.api_key = input;
            self
        }
        /// <p>If the connector uses the custom authentication mechanism, this holds the required credentials.</p>
        pub fn custom(mut self, input: crate::model::CustomAuthCredentials) -> Self {
            self.custom = Some(input);
            self
        }
        /// <p>If the connector uses the custom authentication mechanism, this holds the required credentials.</p>
        pub fn set_custom(
            mut self,
            input: std::option::Option<crate::model::CustomAuthCredentials>,
        ) -> Self {
            self.custom = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomConnectorProfileCredentials`](crate::model::CustomConnectorProfileCredentials)
        pub fn build(self) -> crate::model::CustomConnectorProfileCredentials {
            crate::model::CustomConnectorProfileCredentials {
                authentication_type: self.authentication_type,
                basic: self.basic,
                oauth2: self.oauth2,
                api_key: self.api_key,
                custom: self.custom,
            }
        }
    }
}
impl CustomConnectorProfileCredentials {
    /// Creates a new builder-style object to manufacture [`CustomConnectorProfileCredentials`](crate::model::CustomConnectorProfileCredentials)
    pub fn builder() -> crate::model::custom_connector_profile_credentials::Builder {
        crate::model::custom_connector_profile_credentials::Builder::default()
    }
}

/// <p>The custom credentials required for custom authentication.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomAuthCredentials {
    /// <p>The custom authentication type that the connector uses.</p>
    pub custom_authentication_type: std::option::Option<std::string::String>,
    /// <p>A map that holds custom authentication credentials.</p>
    pub credentials_map:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CustomAuthCredentials {
    /// <p>The custom authentication type that the connector uses.</p>
    pub fn custom_authentication_type(&self) -> std::option::Option<&str> {
        self.custom_authentication_type.as_deref()
    }
    /// <p>A map that holds custom authentication credentials.</p>
    pub fn credentials_map(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.credentials_map.as_ref()
    }
}
impl std::fmt::Debug for CustomAuthCredentials {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomAuthCredentials");
        formatter.field(
            "custom_authentication_type",
            &self.custom_authentication_type,
        );
        formatter.field("credentials_map", &self.credentials_map);
        formatter.finish()
    }
}
/// See [`CustomAuthCredentials`](crate::model::CustomAuthCredentials)
pub mod custom_auth_credentials {
    /// A builder for [`CustomAuthCredentials`](crate::model::CustomAuthCredentials)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) custom_authentication_type: std::option::Option<std::string::String>,
        pub(crate) credentials_map: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The custom authentication type that the connector uses.</p>
        pub fn custom_authentication_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_authentication_type = Some(input.into());
            self
        }
        /// <p>The custom authentication type that the connector uses.</p>
        pub fn set_custom_authentication_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_authentication_type = input;
            self
        }
        /// Adds a key-value pair to `credentials_map`.
        ///
        /// To override the contents of this collection use [`set_credentials_map`](Self::set_credentials_map).
        ///
        /// <p>A map that holds custom authentication credentials.</p>
        pub fn credentials_map(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.credentials_map.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.credentials_map = Some(hash_map);
            self
        }
        /// <p>A map that holds custom authentication credentials.</p>
        pub fn set_credentials_map(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.credentials_map = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomAuthCredentials`](crate::model::CustomAuthCredentials)
        pub fn build(self) -> crate::model::CustomAuthCredentials {
            crate::model::CustomAuthCredentials {
                custom_authentication_type: self.custom_authentication_type,
                credentials_map: self.credentials_map,
            }
        }
    }
}
impl CustomAuthCredentials {
    /// Creates a new builder-style object to manufacture [`CustomAuthCredentials`](crate::model::CustomAuthCredentials)
    pub fn builder() -> crate::model::custom_auth_credentials::Builder {
        crate::model::custom_auth_credentials::Builder::default()
    }
}

/// <p>The API key credentials required for API key authentication.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApiKeyCredentials {
    /// <p>The API key required for API key authentication.</p>
    pub api_key: std::option::Option<std::string::String>,
    /// <p>The API secret key required for API key authentication.</p>
    pub api_secret_key: std::option::Option<std::string::String>,
}
impl ApiKeyCredentials {
    /// <p>The API key required for API key authentication.</p>
    pub fn api_key(&self) -> std::option::Option<&str> {
        self.api_key.as_deref()
    }
    /// <p>The API secret key required for API key authentication.</p>
    pub fn api_secret_key(&self) -> std::option::Option<&str> {
        self.api_secret_key.as_deref()
    }
}
impl std::fmt::Debug for ApiKeyCredentials {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApiKeyCredentials");
        formatter.field("api_key", &"*** Sensitive Data Redacted ***");
        formatter.field("api_secret_key", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`ApiKeyCredentials`](crate::model::ApiKeyCredentials)
pub mod api_key_credentials {
    /// A builder for [`ApiKeyCredentials`](crate::model::ApiKeyCredentials)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_key: std::option::Option<std::string::String>,
        pub(crate) api_secret_key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API key required for API key authentication.</p>
        pub fn api_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_key = Some(input.into());
            self
        }
        /// <p>The API key required for API key authentication.</p>
        pub fn set_api_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_key = input;
            self
        }
        /// <p>The API secret key required for API key authentication.</p>
        pub fn api_secret_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_secret_key = Some(input.into());
            self
        }
        /// <p>The API secret key required for API key authentication.</p>
        pub fn set_api_secret_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.api_secret_key = input;
            self
        }
        /// Consumes the builder and constructs a [`ApiKeyCredentials`](crate::model::ApiKeyCredentials)
        pub fn build(self) -> crate::model::ApiKeyCredentials {
            crate::model::ApiKeyCredentials {
                api_key: self.api_key,
                api_secret_key: self.api_secret_key,
            }
        }
    }
}
impl ApiKeyCredentials {
    /// Creates a new builder-style object to manufacture [`ApiKeyCredentials`](crate::model::ApiKeyCredentials)
    pub fn builder() -> crate::model::api_key_credentials::Builder {
        crate::model::api_key_credentials::Builder::default()
    }
}

/// <p>The OAuth 2.0 credentials required for OAuth 2.0 authentication.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OAuth2Credentials {
    /// <p>The identifier for the desired client.</p>
    pub client_id: std::option::Option<std::string::String>,
    /// <p>The client secret used by the OAuth client to authenticate to the authorization server.</p>
    pub client_secret: std::option::Option<std::string::String>,
    /// <p>The access token used to access the connector on your behalf.</p>
    pub access_token: std::option::Option<std::string::String>,
    /// <p>The refresh token used to refresh an expired access token.</p>
    pub refresh_token: std::option::Option<std::string::String>,
    /// <p> Used by select connectors for which the OAuth workflow is supported, such as Salesforce, Google Analytics, Marketo, Zendesk, and Slack. </p>
    pub o_auth_request: std::option::Option<crate::model::ConnectorOAuthRequest>,
}
impl OAuth2Credentials {
    /// <p>The identifier for the desired client.</p>
    pub fn client_id(&self) -> std::option::Option<&str> {
        self.client_id.as_deref()
    }
    /// <p>The client secret used by the OAuth client to authenticate to the authorization server.</p>
    pub fn client_secret(&self) -> std::option::Option<&str> {
        self.client_secret.as_deref()
    }
    /// <p>The access token used to access the connector on your behalf.</p>
    pub fn access_token(&self) -> std::option::Option<&str> {
        self.access_token.as_deref()
    }
    /// <p>The refresh token used to refresh an expired access token.</p>
    pub fn refresh_token(&self) -> std::option::Option<&str> {
        self.refresh_token.as_deref()
    }
    /// <p> Used by select connectors for which the OAuth workflow is supported, such as Salesforce, Google Analytics, Marketo, Zendesk, and Slack. </p>
    pub fn o_auth_request(&self) -> std::option::Option<&crate::model::ConnectorOAuthRequest> {
        self.o_auth_request.as_ref()
    }
}
impl std::fmt::Debug for OAuth2Credentials {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OAuth2Credentials");
        formatter.field("client_id", &self.client_id);
        formatter.field("client_secret", &"*** Sensitive Data Redacted ***");
        formatter.field("access_token", &"*** Sensitive Data Redacted ***");
        formatter.field("refresh_token", &self.refresh_token);
        formatter.field("o_auth_request", &self.o_auth_request);
        formatter.finish()
    }
}
/// See [`OAuth2Credentials`](crate::model::OAuth2Credentials)
pub mod o_auth2_credentials {
    /// A builder for [`OAuth2Credentials`](crate::model::OAuth2Credentials)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_id: std::option::Option<std::string::String>,
        pub(crate) client_secret: std::option::Option<std::string::String>,
        pub(crate) access_token: std::option::Option<std::string::String>,
        pub(crate) refresh_token: std::option::Option<std::string::String>,
        pub(crate) o_auth_request: std::option::Option<crate::model::ConnectorOAuthRequest>,
    }
    impl Builder {
        /// <p>The identifier for the desired client.</p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_id = Some(input.into());
            self
        }
        /// <p>The identifier for the desired client.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_id = input;
            self
        }
        /// <p>The client secret used by the OAuth client to authenticate to the authorization server.</p>
        pub fn client_secret(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_secret = Some(input.into());
            self
        }
        /// <p>The client secret used by the OAuth client to authenticate to the authorization server.</p>
        pub fn set_client_secret(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_secret = input;
            self
        }
        /// <p>The access token used to access the connector on your behalf.</p>
        pub fn access_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_token = Some(input.into());
            self
        }
        /// <p>The access token used to access the connector on your behalf.</p>
        pub fn set_access_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.access_token = input;
            self
        }
        /// <p>The refresh token used to refresh an expired access token.</p>
        pub fn refresh_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.refresh_token = Some(input.into());
            self
        }
        /// <p>The refresh token used to refresh an expired access token.</p>
        pub fn set_refresh_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.refresh_token = input;
            self
        }
        /// <p> Used by select connectors for which the OAuth workflow is supported, such as Salesforce, Google Analytics, Marketo, Zendesk, and Slack. </p>
        pub fn o_auth_request(mut self, input: crate::model::ConnectorOAuthRequest) -> Self {
            self.o_auth_request = Some(input);
            self
        }
        /// <p> Used by select connectors for which the OAuth workflow is supported, such as Salesforce, Google Analytics, Marketo, Zendesk, and Slack. </p>
        pub fn set_o_auth_request(
            mut self,
            input: std::option::Option<crate::model::ConnectorOAuthRequest>,
        ) -> Self {
            self.o_auth_request = input;
            self
        }
        /// Consumes the builder and constructs a [`OAuth2Credentials`](crate::model::OAuth2Credentials)
        pub fn build(self) -> crate::model::OAuth2Credentials {
            crate::model::OAuth2Credentials {
                client_id: self.client_id,
                client_secret: self.client_secret,
                access_token: self.access_token,
                refresh_token: self.refresh_token,
                o_auth_request: self.o_auth_request,
            }
        }
    }
}
impl OAuth2Credentials {
    /// Creates a new builder-style object to manufacture [`OAuth2Credentials`](crate::model::OAuth2Credentials)
    pub fn builder() -> crate::model::o_auth2_credentials::Builder {
        crate::model::o_auth2_credentials::Builder::default()
    }
}

/// <p> Used by select connectors for which the OAuth workflow is supported, such as Salesforce, Google Analytics, Marketo, Zendesk, and Slack. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConnectorOAuthRequest {
    /// <p> The code provided by the connector when it has been authenticated via the connected app. </p>
    pub auth_code: std::option::Option<std::string::String>,
    /// <p> The URL to which the authentication server redirects the browser after authorization has been granted. </p>
    pub redirect_uri: std::option::Option<std::string::String>,
}
impl ConnectorOAuthRequest {
    /// <p> The code provided by the connector when it has been authenticated via the connected app. </p>
    pub fn auth_code(&self) -> std::option::Option<&str> {
        self.auth_code.as_deref()
    }
    /// <p> The URL to which the authentication server redirects the browser after authorization has been granted. </p>
    pub fn redirect_uri(&self) -> std::option::Option<&str> {
        self.redirect_uri.as_deref()
    }
}
impl std::fmt::Debug for ConnectorOAuthRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConnectorOAuthRequest");
        formatter.field("auth_code", &self.auth_code);
        formatter.field("redirect_uri", &self.redirect_uri);
        formatter.finish()
    }
}
/// See [`ConnectorOAuthRequest`](crate::model::ConnectorOAuthRequest)
pub mod connector_o_auth_request {
    /// A builder for [`ConnectorOAuthRequest`](crate::model::ConnectorOAuthRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auth_code: std::option::Option<std::string::String>,
        pub(crate) redirect_uri: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The code provided by the connector when it has been authenticated via the connected app. </p>
        pub fn auth_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.auth_code = Some(input.into());
            self
        }
        /// <p> The code provided by the connector when it has been authenticated via the connected app. </p>
        pub fn set_auth_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.auth_code = input;
            self
        }
        /// <p> The URL to which the authentication server redirects the browser after authorization has been granted. </p>
        pub fn redirect_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.redirect_uri = Some(input.into());
            self
        }
        /// <p> The URL to which the authentication server redirects the browser after authorization has been granted. </p>
        pub fn set_redirect_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.redirect_uri = input;
            self
        }
        /// Consumes the builder and constructs a [`ConnectorOAuthRequest`](crate::model::ConnectorOAuthRequest)
        pub fn build(self) -> crate::model::ConnectorOAuthRequest {
            crate::model::ConnectorOAuthRequest {
                auth_code: self.auth_code,
                redirect_uri: self.redirect_uri,
            }
        }
    }
}
impl ConnectorOAuthRequest {
    /// Creates a new builder-style object to manufacture [`ConnectorOAuthRequest`](crate::model::ConnectorOAuthRequest)
    pub fn builder() -> crate::model::connector_o_auth_request::Builder {
        crate::model::connector_o_auth_request::Builder::default()
    }
}

/// <p> The basic auth credentials required for basic authentication. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BasicAuthCredentials {
    /// <p> The username to use to connect to a resource. </p>
    pub username: std::option::Option<std::string::String>,
    /// <p> The password to use to connect to a resource.</p>
    pub password: std::option::Option<std::string::String>,
}
impl BasicAuthCredentials {
    /// <p> The username to use to connect to a resource. </p>
    pub fn username(&self) -> std::option::Option<&str> {
        self.username.as_deref()
    }
    /// <p> The password to use to connect to a resource.</p>
    pub fn password(&self) -> std::option::Option<&str> {
        self.password.as_deref()
    }
}
impl std::fmt::Debug for BasicAuthCredentials {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BasicAuthCredentials");
        formatter.field("username", &self.username);
        formatter.field("password", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`BasicAuthCredentials`](crate::model::BasicAuthCredentials)
pub mod basic_auth_credentials {
    /// A builder for [`BasicAuthCredentials`](crate::model::BasicAuthCredentials)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) password: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The username to use to connect to a resource. </p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p> The username to use to connect to a resource. </p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// <p> The password to use to connect to a resource.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.password = Some(input.into());
            self
        }
        /// <p> The password to use to connect to a resource.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.password = input;
            self
        }
        /// Consumes the builder and constructs a [`BasicAuthCredentials`](crate::model::BasicAuthCredentials)
        pub fn build(self) -> crate::model::BasicAuthCredentials {
            crate::model::BasicAuthCredentials {
                username: self.username,
                password: self.password,
            }
        }
    }
}
impl BasicAuthCredentials {
    /// Creates a new builder-style object to manufacture [`BasicAuthCredentials`](crate::model::BasicAuthCredentials)
    pub fn builder() -> crate::model::basic_auth_credentials::Builder {
        crate::model::basic_auth_credentials::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AuthenticationType {
    #[allow(missing_docs)] // documentation missing in model
    Apikey,
    #[allow(missing_docs)] // documentation missing in model
    Basic,
    #[allow(missing_docs)] // documentation missing in model
    Custom,
    #[allow(missing_docs)] // documentation missing in model
    Oauth2,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AuthenticationType {
    fn from(s: &str) -> Self {
        match s {
            "APIKEY" => AuthenticationType::Apikey,
            "BASIC" => AuthenticationType::Basic,
            "CUSTOM" => AuthenticationType::Custom,
            "OAUTH2" => AuthenticationType::Oauth2,
            other => AuthenticationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AuthenticationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AuthenticationType::from(s))
    }
}
impl AuthenticationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AuthenticationType::Apikey => "APIKEY",
            AuthenticationType::Basic => "BASIC",
            AuthenticationType::Custom => "CUSTOM",
            AuthenticationType::Oauth2 => "OAUTH2",
            AuthenticationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["APIKEY", "BASIC", "CUSTOM", "OAUTH2"]
    }
}
impl AsRef<str> for AuthenticationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> The connector-specific profile credentials required when using SAPOData. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SapoDataConnectorProfileCredentials {
    /// <p> The SAPOData basic authentication credentials. </p>
    pub basic_auth_credentials: std::option::Option<crate::model::BasicAuthCredentials>,
    /// <p> The SAPOData OAuth type authentication credentials. </p>
    pub o_auth_credentials: std::option::Option<crate::model::OAuthCredentials>,
}
impl SapoDataConnectorProfileCredentials {
    /// <p> The SAPOData basic authentication credentials. </p>
    pub fn basic_auth_credentials(
        &self,
    ) -> std::option::Option<&crate::model::BasicAuthCredentials> {
        self.basic_auth_credentials.as_ref()
    }
    /// <p> The SAPOData OAuth type authentication credentials. </p>
    pub fn o_auth_credentials(&self) -> std::option::Option<&crate::model::OAuthCredentials> {
        self.o_auth_credentials.as_ref()
    }
}
impl std::fmt::Debug for SapoDataConnectorProfileCredentials {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SapoDataConnectorProfileCredentials");
        formatter.field("basic_auth_credentials", &self.basic_auth_credentials);
        formatter.field("o_auth_credentials", &self.o_auth_credentials);
        formatter.finish()
    }
}
/// See [`SapoDataConnectorProfileCredentials`](crate::model::SapoDataConnectorProfileCredentials)
pub mod sapo_data_connector_profile_credentials {
    /// A builder for [`SapoDataConnectorProfileCredentials`](crate::model::SapoDataConnectorProfileCredentials)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) basic_auth_credentials: std::option::Option<crate::model::BasicAuthCredentials>,
        pub(crate) o_auth_credentials: std::option::Option<crate::model::OAuthCredentials>,
    }
    impl Builder {
        /// <p> The SAPOData basic authentication credentials. </p>
        pub fn basic_auth_credentials(mut self, input: crate::model::BasicAuthCredentials) -> Self {
            self.basic_auth_credentials = Some(input);
            self
        }
        /// <p> The SAPOData basic authentication credentials. </p>
        pub fn set_basic_auth_credentials(
            mut self,
            input: std::option::Option<crate::model::BasicAuthCredentials>,
        ) -> Self {
            self.basic_auth_credentials = input;
            self
        }
        /// <p> The SAPOData OAuth type authentication credentials. </p>
        pub fn o_auth_credentials(mut self, input: crate::model::OAuthCredentials) -> Self {
            self.o_auth_credentials = Some(input);
            self
        }
        /// <p> The SAPOData OAuth type authentication credentials. </p>
        pub fn set_o_auth_credentials(
            mut self,
            input: std::option::Option<crate::model::OAuthCredentials>,
        ) -> Self {
            self.o_auth_credentials = input;
            self
        }
        /// Consumes the builder and constructs a [`SapoDataConnectorProfileCredentials`](crate::model::SapoDataConnectorProfileCredentials)
        pub fn build(self) -> crate::model::SapoDataConnectorProfileCredentials {
            crate::model::SapoDataConnectorProfileCredentials {
                basic_auth_credentials: self.basic_auth_credentials,
                o_auth_credentials: self.o_auth_credentials,
            }
        }
    }
}
impl SapoDataConnectorProfileCredentials {
    /// Creates a new builder-style object to manufacture [`SapoDataConnectorProfileCredentials`](crate::model::SapoDataConnectorProfileCredentials)
    pub fn builder() -> crate::model::sapo_data_connector_profile_credentials::Builder {
        crate::model::sapo_data_connector_profile_credentials::Builder::default()
    }
}

/// <p> The OAuth credentials required for OAuth type authentication. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OAuthCredentials {
    /// <p> The identifier for the desired client. </p>
    pub client_id: std::option::Option<std::string::String>,
    /// <p> The client secret used by the OAuth client to authenticate to the authorization server. </p>
    pub client_secret: std::option::Option<std::string::String>,
    /// <p> The access token used to access protected SAPOData resources. </p>
    pub access_token: std::option::Option<std::string::String>,
    /// <p> The refresh token used to refresh expired access token. </p>
    pub refresh_token: std::option::Option<std::string::String>,
    /// <p> The OAuth requirement needed to request security tokens from the connector endpoint. </p>
    pub o_auth_request: std::option::Option<crate::model::ConnectorOAuthRequest>,
}
impl OAuthCredentials {
    /// <p> The identifier for the desired client. </p>
    pub fn client_id(&self) -> std::option::Option<&str> {
        self.client_id.as_deref()
    }
    /// <p> The client secret used by the OAuth client to authenticate to the authorization server. </p>
    pub fn client_secret(&self) -> std::option::Option<&str> {
        self.client_secret.as_deref()
    }
    /// <p> The access token used to access protected SAPOData resources. </p>
    pub fn access_token(&self) -> std::option::Option<&str> {
        self.access_token.as_deref()
    }
    /// <p> The refresh token used to refresh expired access token. </p>
    pub fn refresh_token(&self) -> std::option::Option<&str> {
        self.refresh_token.as_deref()
    }
    /// <p> The OAuth requirement needed to request security tokens from the connector endpoint. </p>
    pub fn o_auth_request(&self) -> std::option::Option<&crate::model::ConnectorOAuthRequest> {
        self.o_auth_request.as_ref()
    }
}
impl std::fmt::Debug for OAuthCredentials {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OAuthCredentials");
        formatter.field("client_id", &self.client_id);
        formatter.field("client_secret", &"*** Sensitive Data Redacted ***");
        formatter.field("access_token", &"*** Sensitive Data Redacted ***");
        formatter.field("refresh_token", &self.refresh_token);
        formatter.field("o_auth_request", &self.o_auth_request);
        formatter.finish()
    }
}
/// See [`OAuthCredentials`](crate::model::OAuthCredentials)
pub mod o_auth_credentials {
    /// A builder for [`OAuthCredentials`](crate::model::OAuthCredentials)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_id: std::option::Option<std::string::String>,
        pub(crate) client_secret: std::option::Option<std::string::String>,
        pub(crate) access_token: std::option::Option<std::string::String>,
        pub(crate) refresh_token: std::option::Option<std::string::String>,
        pub(crate) o_auth_request: std::option::Option<crate::model::ConnectorOAuthRequest>,
    }
    impl Builder {
        /// <p> The identifier for the desired client. </p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_id = Some(input.into());
            self
        }
        /// <p> The identifier for the desired client. </p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_id = input;
            self
        }
        /// <p> The client secret used by the OAuth client to authenticate to the authorization server. </p>
        pub fn client_secret(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_secret = Some(input.into());
            self
        }
        /// <p> The client secret used by the OAuth client to authenticate to the authorization server. </p>
        pub fn set_client_secret(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_secret = input;
            self
        }
        /// <p> The access token used to access protected SAPOData resources. </p>
        pub fn access_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_token = Some(input.into());
            self
        }
        /// <p> The access token used to access protected SAPOData resources. </p>
        pub fn set_access_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.access_token = input;
            self
        }
        /// <p> The refresh token used to refresh expired access token. </p>
        pub fn refresh_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.refresh_token = Some(input.into());
            self
        }
        /// <p> The refresh token used to refresh expired access token. </p>
        pub fn set_refresh_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.refresh_token = input;
            self
        }
        /// <p> The OAuth requirement needed to request security tokens from the connector endpoint. </p>
        pub fn o_auth_request(mut self, input: crate::model::ConnectorOAuthRequest) -> Self {
            self.o_auth_request = Some(input);
            self
        }
        /// <p> The OAuth requirement needed to request security tokens from the connector endpoint. </p>
        pub fn set_o_auth_request(
            mut self,
            input: std::option::Option<crate::model::ConnectorOAuthRequest>,
        ) -> Self {
            self.o_auth_request = input;
            self
        }
        /// Consumes the builder and constructs a [`OAuthCredentials`](crate::model::OAuthCredentials)
        pub fn build(self) -> crate::model::OAuthCredentials {
            crate::model::OAuthCredentials {
                client_id: self.client_id,
                client_secret: self.client_secret,
                access_token: self.access_token,
                refresh_token: self.refresh_token,
                o_auth_request: self.o_auth_request,
            }
        }
    }
}
impl OAuthCredentials {
    /// Creates a new builder-style object to manufacture [`OAuthCredentials`](crate::model::OAuthCredentials)
    pub fn builder() -> crate::model::o_auth_credentials::Builder {
        crate::model::o_auth_credentials::Builder::default()
    }
}

/// <p> The connector-specific profile credentials required when using Zendesk. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ZendeskConnectorProfileCredentials {
    /// <p> The identifier for the desired client. </p>
    pub client_id: std::option::Option<std::string::String>,
    /// <p> The client secret used by the OAuth client to authenticate to the authorization server. </p>
    pub client_secret: std::option::Option<std::string::String>,
    /// <p> The credentials used to access protected Zendesk resources. </p>
    pub access_token: std::option::Option<std::string::String>,
    /// <p> The OAuth requirement needed to request security tokens from the connector endpoint. </p>
    pub o_auth_request: std::option::Option<crate::model::ConnectorOAuthRequest>,
}
impl ZendeskConnectorProfileCredentials {
    /// <p> The identifier for the desired client. </p>
    pub fn client_id(&self) -> std::option::Option<&str> {
        self.client_id.as_deref()
    }
    /// <p> The client secret used by the OAuth client to authenticate to the authorization server. </p>
    pub fn client_secret(&self) -> std::option::Option<&str> {
        self.client_secret.as_deref()
    }
    /// <p> The credentials used to access protected Zendesk resources. </p>
    pub fn access_token(&self) -> std::option::Option<&str> {
        self.access_token.as_deref()
    }
    /// <p> The OAuth requirement needed to request security tokens from the connector endpoint. </p>
    pub fn o_auth_request(&self) -> std::option::Option<&crate::model::ConnectorOAuthRequest> {
        self.o_auth_request.as_ref()
    }
}
impl std::fmt::Debug for ZendeskConnectorProfileCredentials {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ZendeskConnectorProfileCredentials");
        formatter.field("client_id", &self.client_id);
        formatter.field("client_secret", &"*** Sensitive Data Redacted ***");
        formatter.field("access_token", &"*** Sensitive Data Redacted ***");
        formatter.field("o_auth_request", &self.o_auth_request);
        formatter.finish()
    }
}
/// See [`ZendeskConnectorProfileCredentials`](crate::model::ZendeskConnectorProfileCredentials)
pub mod zendesk_connector_profile_credentials {
    /// A builder for [`ZendeskConnectorProfileCredentials`](crate::model::ZendeskConnectorProfileCredentials)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_id: std::option::Option<std::string::String>,
        pub(crate) client_secret: std::option::Option<std::string::String>,
        pub(crate) access_token: std::option::Option<std::string::String>,
        pub(crate) o_auth_request: std::option::Option<crate::model::ConnectorOAuthRequest>,
    }
    impl Builder {
        /// <p> The identifier for the desired client. </p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_id = Some(input.into());
            self
        }
        /// <p> The identifier for the desired client. </p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_id = input;
            self
        }
        /// <p> The client secret used by the OAuth client to authenticate to the authorization server. </p>
        pub fn client_secret(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_secret = Some(input.into());
            self
        }
        /// <p> The client secret used by the OAuth client to authenticate to the authorization server. </p>
        pub fn set_client_secret(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_secret = input;
            self
        }
        /// <p> The credentials used to access protected Zendesk resources. </p>
        pub fn access_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_token = Some(input.into());
            self
        }
        /// <p> The credentials used to access protected Zendesk resources. </p>
        pub fn set_access_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.access_token = input;
            self
        }
        /// <p> The OAuth requirement needed to request security tokens from the connector endpoint. </p>
        pub fn o_auth_request(mut self, input: crate::model::ConnectorOAuthRequest) -> Self {
            self.o_auth_request = Some(input);
            self
        }
        /// <p> The OAuth requirement needed to request security tokens from the connector endpoint. </p>
        pub fn set_o_auth_request(
            mut self,
            input: std::option::Option<crate::model::ConnectorOAuthRequest>,
        ) -> Self {
            self.o_auth_request = input;
            self
        }
        /// Consumes the builder and constructs a [`ZendeskConnectorProfileCredentials`](crate::model::ZendeskConnectorProfileCredentials)
        pub fn build(self) -> crate::model::ZendeskConnectorProfileCredentials {
            crate::model::ZendeskConnectorProfileCredentials {
                client_id: self.client_id,
                client_secret: self.client_secret,
                access_token: self.access_token,
                o_auth_request: self.o_auth_request,
            }
        }
    }
}
impl ZendeskConnectorProfileCredentials {
    /// Creates a new builder-style object to manufacture [`ZendeskConnectorProfileCredentials`](crate::model::ZendeskConnectorProfileCredentials)
    pub fn builder() -> crate::model::zendesk_connector_profile_credentials::Builder {
        crate::model::zendesk_connector_profile_credentials::Builder::default()
    }
}

/// <p> The connector-specific profile credentials required when using Veeva. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VeevaConnectorProfileCredentials {
    /// <p> The name of the user. </p>
    pub username: std::option::Option<std::string::String>,
    /// <p> The password that corresponds to the user name. </p>
    pub password: std::option::Option<std::string::String>,
}
impl VeevaConnectorProfileCredentials {
    /// <p> The name of the user. </p>
    pub fn username(&self) -> std::option::Option<&str> {
        self.username.as_deref()
    }
    /// <p> The password that corresponds to the user name. </p>
    pub fn password(&self) -> std::option::Option<&str> {
        self.password.as_deref()
    }
}
impl std::fmt::Debug for VeevaConnectorProfileCredentials {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VeevaConnectorProfileCredentials");
        formatter.field("username", &self.username);
        formatter.field("password", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`VeevaConnectorProfileCredentials`](crate::model::VeevaConnectorProfileCredentials)
pub mod veeva_connector_profile_credentials {
    /// A builder for [`VeevaConnectorProfileCredentials`](crate::model::VeevaConnectorProfileCredentials)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) password: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The name of the user. </p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p> The name of the user. </p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// <p> The password that corresponds to the user name. </p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.password = Some(input.into());
            self
        }
        /// <p> The password that corresponds to the user name. </p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.password = input;
            self
        }
        /// Consumes the builder and constructs a [`VeevaConnectorProfileCredentials`](crate::model::VeevaConnectorProfileCredentials)
        pub fn build(self) -> crate::model::VeevaConnectorProfileCredentials {
            crate::model::VeevaConnectorProfileCredentials {
                username: self.username,
                password: self.password,
            }
        }
    }
}
impl VeevaConnectorProfileCredentials {
    /// Creates a new builder-style object to manufacture [`VeevaConnectorProfileCredentials`](crate::model::VeevaConnectorProfileCredentials)
    pub fn builder() -> crate::model::veeva_connector_profile_credentials::Builder {
        crate::model::veeva_connector_profile_credentials::Builder::default()
    }
}

/// <p> The connector-specific profile credentials required when using Trend Micro. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TrendmicroConnectorProfileCredentials {
    /// <p> The Secret Access Key portion of the credentials. </p>
    pub api_secret_key: std::option::Option<std::string::String>,
}
impl TrendmicroConnectorProfileCredentials {
    /// <p> The Secret Access Key portion of the credentials. </p>
    pub fn api_secret_key(&self) -> std::option::Option<&str> {
        self.api_secret_key.as_deref()
    }
}
impl std::fmt::Debug for TrendmicroConnectorProfileCredentials {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TrendmicroConnectorProfileCredentials");
        formatter.field("api_secret_key", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`TrendmicroConnectorProfileCredentials`](crate::model::TrendmicroConnectorProfileCredentials)
pub mod trendmicro_connector_profile_credentials {
    /// A builder for [`TrendmicroConnectorProfileCredentials`](crate::model::TrendmicroConnectorProfileCredentials)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_secret_key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The Secret Access Key portion of the credentials. </p>
        pub fn api_secret_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_secret_key = Some(input.into());
            self
        }
        /// <p> The Secret Access Key portion of the credentials. </p>
        pub fn set_api_secret_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.api_secret_key = input;
            self
        }
        /// Consumes the builder and constructs a [`TrendmicroConnectorProfileCredentials`](crate::model::TrendmicroConnectorProfileCredentials)
        pub fn build(self) -> crate::model::TrendmicroConnectorProfileCredentials {
            crate::model::TrendmicroConnectorProfileCredentials {
                api_secret_key: self.api_secret_key,
            }
        }
    }
}
impl TrendmicroConnectorProfileCredentials {
    /// Creates a new builder-style object to manufacture [`TrendmicroConnectorProfileCredentials`](crate::model::TrendmicroConnectorProfileCredentials)
    pub fn builder() -> crate::model::trendmicro_connector_profile_credentials::Builder {
        crate::model::trendmicro_connector_profile_credentials::Builder::default()
    }
}

/// <p> The connector-specific profile credentials required when using Snowflake. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SnowflakeConnectorProfileCredentials {
    /// <p> The name of the user. </p>
    pub username: std::option::Option<std::string::String>,
    /// <p> The password that corresponds to the user name. </p>
    pub password: std::option::Option<std::string::String>,
}
impl SnowflakeConnectorProfileCredentials {
    /// <p> The name of the user. </p>
    pub fn username(&self) -> std::option::Option<&str> {
        self.username.as_deref()
    }
    /// <p> The password that corresponds to the user name. </p>
    pub fn password(&self) -> std::option::Option<&str> {
        self.password.as_deref()
    }
}
impl std::fmt::Debug for SnowflakeConnectorProfileCredentials {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SnowflakeConnectorProfileCredentials");
        formatter.field("username", &self.username);
        formatter.field("password", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`SnowflakeConnectorProfileCredentials`](crate::model::SnowflakeConnectorProfileCredentials)
pub mod snowflake_connector_profile_credentials {
    /// A builder for [`SnowflakeConnectorProfileCredentials`](crate::model::SnowflakeConnectorProfileCredentials)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) password: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The name of the user. </p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p> The name of the user. </p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// <p> The password that corresponds to the user name. </p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.password = Some(input.into());
            self
        }
        /// <p> The password that corresponds to the user name. </p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.password = input;
            self
        }
        /// Consumes the builder and constructs a [`SnowflakeConnectorProfileCredentials`](crate::model::SnowflakeConnectorProfileCredentials)
        pub fn build(self) -> crate::model::SnowflakeConnectorProfileCredentials {
            crate::model::SnowflakeConnectorProfileCredentials {
                username: self.username,
                password: self.password,
            }
        }
    }
}
impl SnowflakeConnectorProfileCredentials {
    /// Creates a new builder-style object to manufacture [`SnowflakeConnectorProfileCredentials`](crate::model::SnowflakeConnectorProfileCredentials)
    pub fn builder() -> crate::model::snowflake_connector_profile_credentials::Builder {
        crate::model::snowflake_connector_profile_credentials::Builder::default()
    }
}

/// <p> The connector-specific profile credentials required when using Slack. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SlackConnectorProfileCredentials {
    /// <p> The identifier for the client. </p>
    pub client_id: std::option::Option<std::string::String>,
    /// <p> The client secret used by the OAuth client to authenticate to the authorization server. </p>
    pub client_secret: std::option::Option<std::string::String>,
    /// <p> The credentials used to access protected Slack resources. </p>
    pub access_token: std::option::Option<std::string::String>,
    /// <p> The OAuth requirement needed to request security tokens from the connector endpoint. </p>
    pub o_auth_request: std::option::Option<crate::model::ConnectorOAuthRequest>,
}
impl SlackConnectorProfileCredentials {
    /// <p> The identifier for the client. </p>
    pub fn client_id(&self) -> std::option::Option<&str> {
        self.client_id.as_deref()
    }
    /// <p> The client secret used by the OAuth client to authenticate to the authorization server. </p>
    pub fn client_secret(&self) -> std::option::Option<&str> {
        self.client_secret.as_deref()
    }
    /// <p> The credentials used to access protected Slack resources. </p>
    pub fn access_token(&self) -> std::option::Option<&str> {
        self.access_token.as_deref()
    }
    /// <p> The OAuth requirement needed to request security tokens from the connector endpoint. </p>
    pub fn o_auth_request(&self) -> std::option::Option<&crate::model::ConnectorOAuthRequest> {
        self.o_auth_request.as_ref()
    }
}
impl std::fmt::Debug for SlackConnectorProfileCredentials {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SlackConnectorProfileCredentials");
        formatter.field("client_id", &self.client_id);
        formatter.field("client_secret", &"*** Sensitive Data Redacted ***");
        formatter.field("access_token", &"*** Sensitive Data Redacted ***");
        formatter.field("o_auth_request", &self.o_auth_request);
        formatter.finish()
    }
}
/// See [`SlackConnectorProfileCredentials`](crate::model::SlackConnectorProfileCredentials)
pub mod slack_connector_profile_credentials {
    /// A builder for [`SlackConnectorProfileCredentials`](crate::model::SlackConnectorProfileCredentials)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_id: std::option::Option<std::string::String>,
        pub(crate) client_secret: std::option::Option<std::string::String>,
        pub(crate) access_token: std::option::Option<std::string::String>,
        pub(crate) o_auth_request: std::option::Option<crate::model::ConnectorOAuthRequest>,
    }
    impl Builder {
        /// <p> The identifier for the client. </p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_id = Some(input.into());
            self
        }
        /// <p> The identifier for the client. </p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_id = input;
            self
        }
        /// <p> The client secret used by the OAuth client to authenticate to the authorization server. </p>
        pub fn client_secret(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_secret = Some(input.into());
            self
        }
        /// <p> The client secret used by the OAuth client to authenticate to the authorization server. </p>
        pub fn set_client_secret(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_secret = input;
            self
        }
        /// <p> The credentials used to access protected Slack resources. </p>
        pub fn access_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_token = Some(input.into());
            self
        }
        /// <p> The credentials used to access protected Slack resources. </p>
        pub fn set_access_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.access_token = input;
            self
        }
        /// <p> The OAuth requirement needed to request security tokens from the connector endpoint. </p>
        pub fn o_auth_request(mut self, input: crate::model::ConnectorOAuthRequest) -> Self {
            self.o_auth_request = Some(input);
            self
        }
        /// <p> The OAuth requirement needed to request security tokens from the connector endpoint. </p>
        pub fn set_o_auth_request(
            mut self,
            input: std::option::Option<crate::model::ConnectorOAuthRequest>,
        ) -> Self {
            self.o_auth_request = input;
            self
        }
        /// Consumes the builder and constructs a [`SlackConnectorProfileCredentials`](crate::model::SlackConnectorProfileCredentials)
        pub fn build(self) -> crate::model::SlackConnectorProfileCredentials {
            crate::model::SlackConnectorProfileCredentials {
                client_id: self.client_id,
                client_secret: self.client_secret,
                access_token: self.access_token,
                o_auth_request: self.o_auth_request,
            }
        }
    }
}
impl SlackConnectorProfileCredentials {
    /// Creates a new builder-style object to manufacture [`SlackConnectorProfileCredentials`](crate::model::SlackConnectorProfileCredentials)
    pub fn builder() -> crate::model::slack_connector_profile_credentials::Builder {
        crate::model::slack_connector_profile_credentials::Builder::default()
    }
}

/// <p> The connector-specific profile credentials required when using Singular. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SingularConnectorProfileCredentials {
    /// <p> A unique alphanumeric identifier used to authenticate a user, developer, or calling program to your API. </p>
    pub api_key: std::option::Option<std::string::String>,
}
impl SingularConnectorProfileCredentials {
    /// <p> A unique alphanumeric identifier used to authenticate a user, developer, or calling program to your API. </p>
    pub fn api_key(&self) -> std::option::Option<&str> {
        self.api_key.as_deref()
    }
}
impl std::fmt::Debug for SingularConnectorProfileCredentials {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SingularConnectorProfileCredentials");
        formatter.field("api_key", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`SingularConnectorProfileCredentials`](crate::model::SingularConnectorProfileCredentials)
pub mod singular_connector_profile_credentials {
    /// A builder for [`SingularConnectorProfileCredentials`](crate::model::SingularConnectorProfileCredentials)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> A unique alphanumeric identifier used to authenticate a user, developer, or calling program to your API. </p>
        pub fn api_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_key = Some(input.into());
            self
        }
        /// <p> A unique alphanumeric identifier used to authenticate a user, developer, or calling program to your API. </p>
        pub fn set_api_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_key = input;
            self
        }
        /// Consumes the builder and constructs a [`SingularConnectorProfileCredentials`](crate::model::SingularConnectorProfileCredentials)
        pub fn build(self) -> crate::model::SingularConnectorProfileCredentials {
            crate::model::SingularConnectorProfileCredentials {
                api_key: self.api_key,
            }
        }
    }
}
impl SingularConnectorProfileCredentials {
    /// Creates a new builder-style object to manufacture [`SingularConnectorProfileCredentials`](crate::model::SingularConnectorProfileCredentials)
    pub fn builder() -> crate::model::singular_connector_profile_credentials::Builder {
        crate::model::singular_connector_profile_credentials::Builder::default()
    }
}

/// <p> The connector-specific profile credentials required when using ServiceNow. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceNowConnectorProfileCredentials {
    /// <p> The name of the user. </p>
    pub username: std::option::Option<std::string::String>,
    /// <p> The password that corresponds to the user name. </p>
    pub password: std::option::Option<std::string::String>,
}
impl ServiceNowConnectorProfileCredentials {
    /// <p> The name of the user. </p>
    pub fn username(&self) -> std::option::Option<&str> {
        self.username.as_deref()
    }
    /// <p> The password that corresponds to the user name. </p>
    pub fn password(&self) -> std::option::Option<&str> {
        self.password.as_deref()
    }
}
impl std::fmt::Debug for ServiceNowConnectorProfileCredentials {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceNowConnectorProfileCredentials");
        formatter.field("username", &self.username);
        formatter.field("password", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`ServiceNowConnectorProfileCredentials`](crate::model::ServiceNowConnectorProfileCredentials)
pub mod service_now_connector_profile_credentials {
    /// A builder for [`ServiceNowConnectorProfileCredentials`](crate::model::ServiceNowConnectorProfileCredentials)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) password: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The name of the user. </p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p> The name of the user. </p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// <p> The password that corresponds to the user name. </p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.password = Some(input.into());
            self
        }
        /// <p> The password that corresponds to the user name. </p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.password = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceNowConnectorProfileCredentials`](crate::model::ServiceNowConnectorProfileCredentials)
        pub fn build(self) -> crate::model::ServiceNowConnectorProfileCredentials {
            crate::model::ServiceNowConnectorProfileCredentials {
                username: self.username,
                password: self.password,
            }
        }
    }
}
impl ServiceNowConnectorProfileCredentials {
    /// Creates a new builder-style object to manufacture [`ServiceNowConnectorProfileCredentials`](crate::model::ServiceNowConnectorProfileCredentials)
    pub fn builder() -> crate::model::service_now_connector_profile_credentials::Builder {
        crate::model::service_now_connector_profile_credentials::Builder::default()
    }
}

/// <p> The connector-specific profile credentials required when using Salesforce. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SalesforceConnectorProfileCredentials {
    /// <p> The credentials used to access protected Salesforce resources. </p>
    pub access_token: std::option::Option<std::string::String>,
    /// <p> The credentials used to acquire new access tokens. </p>
    pub refresh_token: std::option::Option<std::string::String>,
    /// <p> The OAuth requirement needed to request security tokens from the connector endpoint. </p>
    pub o_auth_request: std::option::Option<crate::model::ConnectorOAuthRequest>,
    /// <p> The secret manager ARN, which contains the client ID and client secret of the connected app. </p>
    pub client_credentials_arn: std::option::Option<std::string::String>,
}
impl SalesforceConnectorProfileCredentials {
    /// <p> The credentials used to access protected Salesforce resources. </p>
    pub fn access_token(&self) -> std::option::Option<&str> {
        self.access_token.as_deref()
    }
    /// <p> The credentials used to acquire new access tokens. </p>
    pub fn refresh_token(&self) -> std::option::Option<&str> {
        self.refresh_token.as_deref()
    }
    /// <p> The OAuth requirement needed to request security tokens from the connector endpoint. </p>
    pub fn o_auth_request(&self) -> std::option::Option<&crate::model::ConnectorOAuthRequest> {
        self.o_auth_request.as_ref()
    }
    /// <p> The secret manager ARN, which contains the client ID and client secret of the connected app. </p>
    pub fn client_credentials_arn(&self) -> std::option::Option<&str> {
        self.client_credentials_arn.as_deref()
    }
}
impl std::fmt::Debug for SalesforceConnectorProfileCredentials {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SalesforceConnectorProfileCredentials");
        formatter.field("access_token", &"*** Sensitive Data Redacted ***");
        formatter.field("refresh_token", &self.refresh_token);
        formatter.field("o_auth_request", &self.o_auth_request);
        formatter.field("client_credentials_arn", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`SalesforceConnectorProfileCredentials`](crate::model::SalesforceConnectorProfileCredentials)
pub mod salesforce_connector_profile_credentials {
    /// A builder for [`SalesforceConnectorProfileCredentials`](crate::model::SalesforceConnectorProfileCredentials)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_token: std::option::Option<std::string::String>,
        pub(crate) refresh_token: std::option::Option<std::string::String>,
        pub(crate) o_auth_request: std::option::Option<crate::model::ConnectorOAuthRequest>,
        pub(crate) client_credentials_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The credentials used to access protected Salesforce resources. </p>
        pub fn access_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_token = Some(input.into());
            self
        }
        /// <p> The credentials used to access protected Salesforce resources. </p>
        pub fn set_access_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.access_token = input;
            self
        }
        /// <p> The credentials used to acquire new access tokens. </p>
        pub fn refresh_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.refresh_token = Some(input.into());
            self
        }
        /// <p> The credentials used to acquire new access tokens. </p>
        pub fn set_refresh_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.refresh_token = input;
            self
        }
        /// <p> The OAuth requirement needed to request security tokens from the connector endpoint. </p>
        pub fn o_auth_request(mut self, input: crate::model::ConnectorOAuthRequest) -> Self {
            self.o_auth_request = Some(input);
            self
        }
        /// <p> The OAuth requirement needed to request security tokens from the connector endpoint. </p>
        pub fn set_o_auth_request(
            mut self,
            input: std::option::Option<crate::model::ConnectorOAuthRequest>,
        ) -> Self {
            self.o_auth_request = input;
            self
        }
        /// <p> The secret manager ARN, which contains the client ID and client secret of the connected app. </p>
        pub fn client_credentials_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_credentials_arn = Some(input.into());
            self
        }
        /// <p> The secret manager ARN, which contains the client ID and client secret of the connected app. </p>
        pub fn set_client_credentials_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_credentials_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`SalesforceConnectorProfileCredentials`](crate::model::SalesforceConnectorProfileCredentials)
        pub fn build(self) -> crate::model::SalesforceConnectorProfileCredentials {
            crate::model::SalesforceConnectorProfileCredentials {
                access_token: self.access_token,
                refresh_token: self.refresh_token,
                o_auth_request: self.o_auth_request,
                client_credentials_arn: self.client_credentials_arn,
            }
        }
    }
}
impl SalesforceConnectorProfileCredentials {
    /// Creates a new builder-style object to manufacture [`SalesforceConnectorProfileCredentials`](crate::model::SalesforceConnectorProfileCredentials)
    pub fn builder() -> crate::model::salesforce_connector_profile_credentials::Builder {
        crate::model::salesforce_connector_profile_credentials::Builder::default()
    }
}

/// <p> The connector-specific profile credentials required when using Amazon Redshift. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RedshiftConnectorProfileCredentials {
    /// <p> The name of the user. </p>
    pub username: std::option::Option<std::string::String>,
    /// <p> The password that corresponds to the user name. </p>
    pub password: std::option::Option<std::string::String>,
}
impl RedshiftConnectorProfileCredentials {
    /// <p> The name of the user. </p>
    pub fn username(&self) -> std::option::Option<&str> {
        self.username.as_deref()
    }
    /// <p> The password that corresponds to the user name. </p>
    pub fn password(&self) -> std::option::Option<&str> {
        self.password.as_deref()
    }
}
impl std::fmt::Debug for RedshiftConnectorProfileCredentials {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RedshiftConnectorProfileCredentials");
        formatter.field("username", &self.username);
        formatter.field("password", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`RedshiftConnectorProfileCredentials`](crate::model::RedshiftConnectorProfileCredentials)
pub mod redshift_connector_profile_credentials {
    /// A builder for [`RedshiftConnectorProfileCredentials`](crate::model::RedshiftConnectorProfileCredentials)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) password: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The name of the user. </p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p> The name of the user. </p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// <p> The password that corresponds to the user name. </p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.password = Some(input.into());
            self
        }
        /// <p> The password that corresponds to the user name. </p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.password = input;
            self
        }
        /// Consumes the builder and constructs a [`RedshiftConnectorProfileCredentials`](crate::model::RedshiftConnectorProfileCredentials)
        pub fn build(self) -> crate::model::RedshiftConnectorProfileCredentials {
            crate::model::RedshiftConnectorProfileCredentials {
                username: self.username,
                password: self.password,
            }
        }
    }
}
impl RedshiftConnectorProfileCredentials {
    /// Creates a new builder-style object to manufacture [`RedshiftConnectorProfileCredentials`](crate::model::RedshiftConnectorProfileCredentials)
    pub fn builder() -> crate::model::redshift_connector_profile_credentials::Builder {
        crate::model::redshift_connector_profile_credentials::Builder::default()
    }
}

/// <p> The connector-specific profile credentials required by Marketo. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MarketoConnectorProfileCredentials {
    /// <p> The identifier for the desired client. </p>
    pub client_id: std::option::Option<std::string::String>,
    /// <p> The client secret used by the OAuth client to authenticate to the authorization server. </p>
    pub client_secret: std::option::Option<std::string::String>,
    /// <p> The credentials used to access protected Marketo resources. </p>
    pub access_token: std::option::Option<std::string::String>,
    /// <p> The OAuth requirement needed to request security tokens from the connector endpoint. </p>
    pub o_auth_request: std::option::Option<crate::model::ConnectorOAuthRequest>,
}
impl MarketoConnectorProfileCredentials {
    /// <p> The identifier for the desired client. </p>
    pub fn client_id(&self) -> std::option::Option<&str> {
        self.client_id.as_deref()
    }
    /// <p> The client secret used by the OAuth client to authenticate to the authorization server. </p>
    pub fn client_secret(&self) -> std::option::Option<&str> {
        self.client_secret.as_deref()
    }
    /// <p> The credentials used to access protected Marketo resources. </p>
    pub fn access_token(&self) -> std::option::Option<&str> {
        self.access_token.as_deref()
    }
    /// <p> The OAuth requirement needed to request security tokens from the connector endpoint. </p>
    pub fn o_auth_request(&self) -> std::option::Option<&crate::model::ConnectorOAuthRequest> {
        self.o_auth_request.as_ref()
    }
}
impl std::fmt::Debug for MarketoConnectorProfileCredentials {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MarketoConnectorProfileCredentials");
        formatter.field("client_id", &self.client_id);
        formatter.field("client_secret", &"*** Sensitive Data Redacted ***");
        formatter.field("access_token", &"*** Sensitive Data Redacted ***");
        formatter.field("o_auth_request", &self.o_auth_request);
        formatter.finish()
    }
}
/// See [`MarketoConnectorProfileCredentials`](crate::model::MarketoConnectorProfileCredentials)
pub mod marketo_connector_profile_credentials {
    /// A builder for [`MarketoConnectorProfileCredentials`](crate::model::MarketoConnectorProfileCredentials)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_id: std::option::Option<std::string::String>,
        pub(crate) client_secret: std::option::Option<std::string::String>,
        pub(crate) access_token: std::option::Option<std::string::String>,
        pub(crate) o_auth_request: std::option::Option<crate::model::ConnectorOAuthRequest>,
    }
    impl Builder {
        /// <p> The identifier for the desired client. </p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_id = Some(input.into());
            self
        }
        /// <p> The identifier for the desired client. </p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_id = input;
            self
        }
        /// <p> The client secret used by the OAuth client to authenticate to the authorization server. </p>
        pub fn client_secret(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_secret = Some(input.into());
            self
        }
        /// <p> The client secret used by the OAuth client to authenticate to the authorization server. </p>
        pub fn set_client_secret(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_secret = input;
            self
        }
        /// <p> The credentials used to access protected Marketo resources. </p>
        pub fn access_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_token = Some(input.into());
            self
        }
        /// <p> The credentials used to access protected Marketo resources. </p>
        pub fn set_access_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.access_token = input;
            self
        }
        /// <p> The OAuth requirement needed to request security tokens from the connector endpoint. </p>
        pub fn o_auth_request(mut self, input: crate::model::ConnectorOAuthRequest) -> Self {
            self.o_auth_request = Some(input);
            self
        }
        /// <p> The OAuth requirement needed to request security tokens from the connector endpoint. </p>
        pub fn set_o_auth_request(
            mut self,
            input: std::option::Option<crate::model::ConnectorOAuthRequest>,
        ) -> Self {
            self.o_auth_request = input;
            self
        }
        /// Consumes the builder and constructs a [`MarketoConnectorProfileCredentials`](crate::model::MarketoConnectorProfileCredentials)
        pub fn build(self) -> crate::model::MarketoConnectorProfileCredentials {
            crate::model::MarketoConnectorProfileCredentials {
                client_id: self.client_id,
                client_secret: self.client_secret,
                access_token: self.access_token,
                o_auth_request: self.o_auth_request,
            }
        }
    }
}
impl MarketoConnectorProfileCredentials {
    /// Creates a new builder-style object to manufacture [`MarketoConnectorProfileCredentials`](crate::model::MarketoConnectorProfileCredentials)
    pub fn builder() -> crate::model::marketo_connector_profile_credentials::Builder {
        crate::model::marketo_connector_profile_credentials::Builder::default()
    }
}

/// <p> The connector-specific profile credentials required by Infor Nexus. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InforNexusConnectorProfileCredentials {
    /// <p> The Access Key portion of the credentials. </p>
    pub access_key_id: std::option::Option<std::string::String>,
    /// <p> The identifier for the user. </p>
    pub user_id: std::option::Option<std::string::String>,
    /// <p> The secret key used to sign requests. </p>
    pub secret_access_key: std::option::Option<std::string::String>,
    /// <p> The encryption keys used to encrypt data. </p>
    pub datakey: std::option::Option<std::string::String>,
}
impl InforNexusConnectorProfileCredentials {
    /// <p> The Access Key portion of the credentials. </p>
    pub fn access_key_id(&self) -> std::option::Option<&str> {
        self.access_key_id.as_deref()
    }
    /// <p> The identifier for the user. </p>
    pub fn user_id(&self) -> std::option::Option<&str> {
        self.user_id.as_deref()
    }
    /// <p> The secret key used to sign requests. </p>
    pub fn secret_access_key(&self) -> std::option::Option<&str> {
        self.secret_access_key.as_deref()
    }
    /// <p> The encryption keys used to encrypt data. </p>
    pub fn datakey(&self) -> std::option::Option<&str> {
        self.datakey.as_deref()
    }
}
impl std::fmt::Debug for InforNexusConnectorProfileCredentials {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InforNexusConnectorProfileCredentials");
        formatter.field("access_key_id", &"*** Sensitive Data Redacted ***");
        formatter.field("user_id", &self.user_id);
        formatter.field("secret_access_key", &self.secret_access_key);
        formatter.field("datakey", &self.datakey);
        formatter.finish()
    }
}
/// See [`InforNexusConnectorProfileCredentials`](crate::model::InforNexusConnectorProfileCredentials)
pub mod infor_nexus_connector_profile_credentials {
    /// A builder for [`InforNexusConnectorProfileCredentials`](crate::model::InforNexusConnectorProfileCredentials)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_key_id: std::option::Option<std::string::String>,
        pub(crate) user_id: std::option::Option<std::string::String>,
        pub(crate) secret_access_key: std::option::Option<std::string::String>,
        pub(crate) datakey: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The Access Key portion of the credentials. </p>
        pub fn access_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_key_id = Some(input.into());
            self
        }
        /// <p> The Access Key portion of the credentials. </p>
        pub fn set_access_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.access_key_id = input;
            self
        }
        /// <p> The identifier for the user. </p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p> The identifier for the user. </p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// <p> The secret key used to sign requests. </p>
        pub fn secret_access_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.secret_access_key = Some(input.into());
            self
        }
        /// <p> The secret key used to sign requests. </p>
        pub fn set_secret_access_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.secret_access_key = input;
            self
        }
        /// <p> The encryption keys used to encrypt data. </p>
        pub fn datakey(mut self, input: impl Into<std::string::String>) -> Self {
            self.datakey = Some(input.into());
            self
        }
        /// <p> The encryption keys used to encrypt data. </p>
        pub fn set_datakey(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.datakey = input;
            self
        }
        /// Consumes the builder and constructs a [`InforNexusConnectorProfileCredentials`](crate::model::InforNexusConnectorProfileCredentials)
        pub fn build(self) -> crate::model::InforNexusConnectorProfileCredentials {
            crate::model::InforNexusConnectorProfileCredentials {
                access_key_id: self.access_key_id,
                user_id: self.user_id,
                secret_access_key: self.secret_access_key,
                datakey: self.datakey,
            }
        }
    }
}
impl InforNexusConnectorProfileCredentials {
    /// Creates a new builder-style object to manufacture [`InforNexusConnectorProfileCredentials`](crate::model::InforNexusConnectorProfileCredentials)
    pub fn builder() -> crate::model::infor_nexus_connector_profile_credentials::Builder {
        crate::model::infor_nexus_connector_profile_credentials::Builder::default()
    }
}

/// <p> The connector-specific credentials required when using Amazon Honeycode. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HoneycodeConnectorProfileCredentials {
    /// <p> The credentials used to access protected Amazon Honeycode resources. </p>
    pub access_token: std::option::Option<std::string::String>,
    /// <p> The credentials used to acquire new access tokens. </p>
    pub refresh_token: std::option::Option<std::string::String>,
    /// <p> Used by select connectors for which the OAuth workflow is supported, such as Salesforce, Google Analytics, Marketo, Zendesk, and Slack. </p>
    pub o_auth_request: std::option::Option<crate::model::ConnectorOAuthRequest>,
}
impl HoneycodeConnectorProfileCredentials {
    /// <p> The credentials used to access protected Amazon Honeycode resources. </p>
    pub fn access_token(&self) -> std::option::Option<&str> {
        self.access_token.as_deref()
    }
    /// <p> The credentials used to acquire new access tokens. </p>
    pub fn refresh_token(&self) -> std::option::Option<&str> {
        self.refresh_token.as_deref()
    }
    /// <p> Used by select connectors for which the OAuth workflow is supported, such as Salesforce, Google Analytics, Marketo, Zendesk, and Slack. </p>
    pub fn o_auth_request(&self) -> std::option::Option<&crate::model::ConnectorOAuthRequest> {
        self.o_auth_request.as_ref()
    }
}
impl std::fmt::Debug for HoneycodeConnectorProfileCredentials {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HoneycodeConnectorProfileCredentials");
        formatter.field("access_token", &"*** Sensitive Data Redacted ***");
        formatter.field("refresh_token", &self.refresh_token);
        formatter.field("o_auth_request", &self.o_auth_request);
        formatter.finish()
    }
}
/// See [`HoneycodeConnectorProfileCredentials`](crate::model::HoneycodeConnectorProfileCredentials)
pub mod honeycode_connector_profile_credentials {
    /// A builder for [`HoneycodeConnectorProfileCredentials`](crate::model::HoneycodeConnectorProfileCredentials)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_token: std::option::Option<std::string::String>,
        pub(crate) refresh_token: std::option::Option<std::string::String>,
        pub(crate) o_auth_request: std::option::Option<crate::model::ConnectorOAuthRequest>,
    }
    impl Builder {
        /// <p> The credentials used to access protected Amazon Honeycode resources. </p>
        pub fn access_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_token = Some(input.into());
            self
        }
        /// <p> The credentials used to access protected Amazon Honeycode resources. </p>
        pub fn set_access_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.access_token = input;
            self
        }
        /// <p> The credentials used to acquire new access tokens. </p>
        pub fn refresh_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.refresh_token = Some(input.into());
            self
        }
        /// <p> The credentials used to acquire new access tokens. </p>
        pub fn set_refresh_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.refresh_token = input;
            self
        }
        /// <p> Used by select connectors for which the OAuth workflow is supported, such as Salesforce, Google Analytics, Marketo, Zendesk, and Slack. </p>
        pub fn o_auth_request(mut self, input: crate::model::ConnectorOAuthRequest) -> Self {
            self.o_auth_request = Some(input);
            self
        }
        /// <p> Used by select connectors for which the OAuth workflow is supported, such as Salesforce, Google Analytics, Marketo, Zendesk, and Slack. </p>
        pub fn set_o_auth_request(
            mut self,
            input: std::option::Option<crate::model::ConnectorOAuthRequest>,
        ) -> Self {
            self.o_auth_request = input;
            self
        }
        /// Consumes the builder and constructs a [`HoneycodeConnectorProfileCredentials`](crate::model::HoneycodeConnectorProfileCredentials)
        pub fn build(self) -> crate::model::HoneycodeConnectorProfileCredentials {
            crate::model::HoneycodeConnectorProfileCredentials {
                access_token: self.access_token,
                refresh_token: self.refresh_token,
                o_auth_request: self.o_auth_request,
            }
        }
    }
}
impl HoneycodeConnectorProfileCredentials {
    /// Creates a new builder-style object to manufacture [`HoneycodeConnectorProfileCredentials`](crate::model::HoneycodeConnectorProfileCredentials)
    pub fn builder() -> crate::model::honeycode_connector_profile_credentials::Builder {
        crate::model::honeycode_connector_profile_credentials::Builder::default()
    }
}

/// <p> The connector-specific profile credentials required by Google Analytics. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GoogleAnalyticsConnectorProfileCredentials {
    /// <p> The identifier for the desired client. </p>
    pub client_id: std::option::Option<std::string::String>,
    /// <p> The client secret used by the OAuth client to authenticate to the authorization server. </p>
    pub client_secret: std::option::Option<std::string::String>,
    /// <p> The credentials used to access protected Google Analytics resources. </p>
    pub access_token: std::option::Option<std::string::String>,
    /// <p> The credentials used to acquire new access tokens. This is required only for OAuth2 access tokens, and is not required for OAuth1 access tokens. </p>
    pub refresh_token: std::option::Option<std::string::String>,
    /// <p> The OAuth requirement needed to request security tokens from the connector endpoint. </p>
    pub o_auth_request: std::option::Option<crate::model::ConnectorOAuthRequest>,
}
impl GoogleAnalyticsConnectorProfileCredentials {
    /// <p> The identifier for the desired client. </p>
    pub fn client_id(&self) -> std::option::Option<&str> {
        self.client_id.as_deref()
    }
    /// <p> The client secret used by the OAuth client to authenticate to the authorization server. </p>
    pub fn client_secret(&self) -> std::option::Option<&str> {
        self.client_secret.as_deref()
    }
    /// <p> The credentials used to access protected Google Analytics resources. </p>
    pub fn access_token(&self) -> std::option::Option<&str> {
        self.access_token.as_deref()
    }
    /// <p> The credentials used to acquire new access tokens. This is required only for OAuth2 access tokens, and is not required for OAuth1 access tokens. </p>
    pub fn refresh_token(&self) -> std::option::Option<&str> {
        self.refresh_token.as_deref()
    }
    /// <p> The OAuth requirement needed to request security tokens from the connector endpoint. </p>
    pub fn o_auth_request(&self) -> std::option::Option<&crate::model::ConnectorOAuthRequest> {
        self.o_auth_request.as_ref()
    }
}
impl std::fmt::Debug for GoogleAnalyticsConnectorProfileCredentials {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GoogleAnalyticsConnectorProfileCredentials");
        formatter.field("client_id", &self.client_id);
        formatter.field("client_secret", &"*** Sensitive Data Redacted ***");
        formatter.field("access_token", &"*** Sensitive Data Redacted ***");
        formatter.field("refresh_token", &self.refresh_token);
        formatter.field("o_auth_request", &self.o_auth_request);
        formatter.finish()
    }
}
/// See [`GoogleAnalyticsConnectorProfileCredentials`](crate::model::GoogleAnalyticsConnectorProfileCredentials)
pub mod google_analytics_connector_profile_credentials {
    /// A builder for [`GoogleAnalyticsConnectorProfileCredentials`](crate::model::GoogleAnalyticsConnectorProfileCredentials)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_id: std::option::Option<std::string::String>,
        pub(crate) client_secret: std::option::Option<std::string::String>,
        pub(crate) access_token: std::option::Option<std::string::String>,
        pub(crate) refresh_token: std::option::Option<std::string::String>,
        pub(crate) o_auth_request: std::option::Option<crate::model::ConnectorOAuthRequest>,
    }
    impl Builder {
        /// <p> The identifier for the desired client. </p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_id = Some(input.into());
            self
        }
        /// <p> The identifier for the desired client. </p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_id = input;
            self
        }
        /// <p> The client secret used by the OAuth client to authenticate to the authorization server. </p>
        pub fn client_secret(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_secret = Some(input.into());
            self
        }
        /// <p> The client secret used by the OAuth client to authenticate to the authorization server. </p>
        pub fn set_client_secret(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_secret = input;
            self
        }
        /// <p> The credentials used to access protected Google Analytics resources. </p>
        pub fn access_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_token = Some(input.into());
            self
        }
        /// <p> The credentials used to access protected Google Analytics resources. </p>
        pub fn set_access_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.access_token = input;
            self
        }
        /// <p> The credentials used to acquire new access tokens. This is required only for OAuth2 access tokens, and is not required for OAuth1 access tokens. </p>
        pub fn refresh_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.refresh_token = Some(input.into());
            self
        }
        /// <p> The credentials used to acquire new access tokens. This is required only for OAuth2 access tokens, and is not required for OAuth1 access tokens. </p>
        pub fn set_refresh_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.refresh_token = input;
            self
        }
        /// <p> The OAuth requirement needed to request security tokens from the connector endpoint. </p>
        pub fn o_auth_request(mut self, input: crate::model::ConnectorOAuthRequest) -> Self {
            self.o_auth_request = Some(input);
            self
        }
        /// <p> The OAuth requirement needed to request security tokens from the connector endpoint. </p>
        pub fn set_o_auth_request(
            mut self,
            input: std::option::Option<crate::model::ConnectorOAuthRequest>,
        ) -> Self {
            self.o_auth_request = input;
            self
        }
        /// Consumes the builder and constructs a [`GoogleAnalyticsConnectorProfileCredentials`](crate::model::GoogleAnalyticsConnectorProfileCredentials)
        pub fn build(self) -> crate::model::GoogleAnalyticsConnectorProfileCredentials {
            crate::model::GoogleAnalyticsConnectorProfileCredentials {
                client_id: self.client_id,
                client_secret: self.client_secret,
                access_token: self.access_token,
                refresh_token: self.refresh_token,
                o_auth_request: self.o_auth_request,
            }
        }
    }
}
impl GoogleAnalyticsConnectorProfileCredentials {
    /// Creates a new builder-style object to manufacture [`GoogleAnalyticsConnectorProfileCredentials`](crate::model::GoogleAnalyticsConnectorProfileCredentials)
    pub fn builder() -> crate::model::google_analytics_connector_profile_credentials::Builder {
        crate::model::google_analytics_connector_profile_credentials::Builder::default()
    }
}

/// <p> The connector-specific profile credentials required by Dynatrace. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DynatraceConnectorProfileCredentials {
    /// <p> The API tokens used by Dynatrace API to authenticate various API calls. </p>
    pub api_token: std::option::Option<std::string::String>,
}
impl DynatraceConnectorProfileCredentials {
    /// <p> The API tokens used by Dynatrace API to authenticate various API calls. </p>
    pub fn api_token(&self) -> std::option::Option<&str> {
        self.api_token.as_deref()
    }
}
impl std::fmt::Debug for DynatraceConnectorProfileCredentials {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DynatraceConnectorProfileCredentials");
        formatter.field("api_token", &self.api_token);
        formatter.finish()
    }
}
/// See [`DynatraceConnectorProfileCredentials`](crate::model::DynatraceConnectorProfileCredentials)
pub mod dynatrace_connector_profile_credentials {
    /// A builder for [`DynatraceConnectorProfileCredentials`](crate::model::DynatraceConnectorProfileCredentials)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The API tokens used by Dynatrace API to authenticate various API calls. </p>
        pub fn api_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_token = Some(input.into());
            self
        }
        /// <p> The API tokens used by Dynatrace API to authenticate various API calls. </p>
        pub fn set_api_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DynatraceConnectorProfileCredentials`](crate::model::DynatraceConnectorProfileCredentials)
        pub fn build(self) -> crate::model::DynatraceConnectorProfileCredentials {
            crate::model::DynatraceConnectorProfileCredentials {
                api_token: self.api_token,
            }
        }
    }
}
impl DynatraceConnectorProfileCredentials {
    /// Creates a new builder-style object to manufacture [`DynatraceConnectorProfileCredentials`](crate::model::DynatraceConnectorProfileCredentials)
    pub fn builder() -> crate::model::dynatrace_connector_profile_credentials::Builder {
        crate::model::dynatrace_connector_profile_credentials::Builder::default()
    }
}

/// <p> The connector-specific credentials required by Datadog. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DatadogConnectorProfileCredentials {
    /// <p> A unique alphanumeric identifier used to authenticate a user, developer, or calling program to your API. </p>
    pub api_key: std::option::Option<std::string::String>,
    /// <p> Application keys, in conjunction with your API key, give you full access to Datadog’s programmatic API. Application keys are associated with the user account that created them. The application key is used to log all requests made to the API. </p>
    pub application_key: std::option::Option<std::string::String>,
}
impl DatadogConnectorProfileCredentials {
    /// <p> A unique alphanumeric identifier used to authenticate a user, developer, or calling program to your API. </p>
    pub fn api_key(&self) -> std::option::Option<&str> {
        self.api_key.as_deref()
    }
    /// <p> Application keys, in conjunction with your API key, give you full access to Datadog’s programmatic API. Application keys are associated with the user account that created them. The application key is used to log all requests made to the API. </p>
    pub fn application_key(&self) -> std::option::Option<&str> {
        self.application_key.as_deref()
    }
}
impl std::fmt::Debug for DatadogConnectorProfileCredentials {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DatadogConnectorProfileCredentials");
        formatter.field("api_key", &"*** Sensitive Data Redacted ***");
        formatter.field("application_key", &self.application_key);
        formatter.finish()
    }
}
/// See [`DatadogConnectorProfileCredentials`](crate::model::DatadogConnectorProfileCredentials)
pub mod datadog_connector_profile_credentials {
    /// A builder for [`DatadogConnectorProfileCredentials`](crate::model::DatadogConnectorProfileCredentials)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_key: std::option::Option<std::string::String>,
        pub(crate) application_key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> A unique alphanumeric identifier used to authenticate a user, developer, or calling program to your API. </p>
        pub fn api_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_key = Some(input.into());
            self
        }
        /// <p> A unique alphanumeric identifier used to authenticate a user, developer, or calling program to your API. </p>
        pub fn set_api_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_key = input;
            self
        }
        /// <p> Application keys, in conjunction with your API key, give you full access to Datadog’s programmatic API. Application keys are associated with the user account that created them. The application key is used to log all requests made to the API. </p>
        pub fn application_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_key = Some(input.into());
            self
        }
        /// <p> Application keys, in conjunction with your API key, give you full access to Datadog’s programmatic API. Application keys are associated with the user account that created them. The application key is used to log all requests made to the API. </p>
        pub fn set_application_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_key = input;
            self
        }
        /// Consumes the builder and constructs a [`DatadogConnectorProfileCredentials`](crate::model::DatadogConnectorProfileCredentials)
        pub fn build(self) -> crate::model::DatadogConnectorProfileCredentials {
            crate::model::DatadogConnectorProfileCredentials {
                api_key: self.api_key,
                application_key: self.application_key,
            }
        }
    }
}
impl DatadogConnectorProfileCredentials {
    /// Creates a new builder-style object to manufacture [`DatadogConnectorProfileCredentials`](crate::model::DatadogConnectorProfileCredentials)
    pub fn builder() -> crate::model::datadog_connector_profile_credentials::Builder {
        crate::model::datadog_connector_profile_credentials::Builder::default()
    }
}

/// <p> The connector-specific credentials required when using Amplitude. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AmplitudeConnectorProfileCredentials {
    /// <p> A unique alphanumeric identifier used to authenticate a user, developer, or calling program to your API. </p>
    pub api_key: std::option::Option<std::string::String>,
    /// <p> The Secret Access Key portion of the credentials. </p>
    pub secret_key: std::option::Option<std::string::String>,
}
impl AmplitudeConnectorProfileCredentials {
    /// <p> A unique alphanumeric identifier used to authenticate a user, developer, or calling program to your API. </p>
    pub fn api_key(&self) -> std::option::Option<&str> {
        self.api_key.as_deref()
    }
    /// <p> The Secret Access Key portion of the credentials. </p>
    pub fn secret_key(&self) -> std::option::Option<&str> {
        self.secret_key.as_deref()
    }
}
impl std::fmt::Debug for AmplitudeConnectorProfileCredentials {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AmplitudeConnectorProfileCredentials");
        formatter.field("api_key", &"*** Sensitive Data Redacted ***");
        formatter.field("secret_key", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`AmplitudeConnectorProfileCredentials`](crate::model::AmplitudeConnectorProfileCredentials)
pub mod amplitude_connector_profile_credentials {
    /// A builder for [`AmplitudeConnectorProfileCredentials`](crate::model::AmplitudeConnectorProfileCredentials)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_key: std::option::Option<std::string::String>,
        pub(crate) secret_key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> A unique alphanumeric identifier used to authenticate a user, developer, or calling program to your API. </p>
        pub fn api_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_key = Some(input.into());
            self
        }
        /// <p> A unique alphanumeric identifier used to authenticate a user, developer, or calling program to your API. </p>
        pub fn set_api_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_key = input;
            self
        }
        /// <p> The Secret Access Key portion of the credentials. </p>
        pub fn secret_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.secret_key = Some(input.into());
            self
        }
        /// <p> The Secret Access Key portion of the credentials. </p>
        pub fn set_secret_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.secret_key = input;
            self
        }
        /// Consumes the builder and constructs a [`AmplitudeConnectorProfileCredentials`](crate::model::AmplitudeConnectorProfileCredentials)
        pub fn build(self) -> crate::model::AmplitudeConnectorProfileCredentials {
            crate::model::AmplitudeConnectorProfileCredentials {
                api_key: self.api_key,
                secret_key: self.secret_key,
            }
        }
    }
}
impl AmplitudeConnectorProfileCredentials {
    /// Creates a new builder-style object to manufacture [`AmplitudeConnectorProfileCredentials`](crate::model::AmplitudeConnectorProfileCredentials)
    pub fn builder() -> crate::model::amplitude_connector_profile_credentials::Builder {
        crate::model::amplitude_connector_profile_credentials::Builder::default()
    }
}

/// <p> The connector-specific profile properties required by each connector. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConnectorProfileProperties {
    /// <p> The connector-specific properties required by Amplitude. </p>
    pub amplitude: std::option::Option<crate::model::AmplitudeConnectorProfileProperties>,
    /// <p> The connector-specific properties required by Datadog. </p>
    pub datadog: std::option::Option<crate::model::DatadogConnectorProfileProperties>,
    /// <p> The connector-specific properties required by Dynatrace. </p>
    pub dynatrace: std::option::Option<crate::model::DynatraceConnectorProfileProperties>,
    /// <p> The connector-specific properties required Google Analytics. </p>
    pub google_analytics:
        std::option::Option<crate::model::GoogleAnalyticsConnectorProfileProperties>,
    /// <p> The connector-specific properties required by Amazon Honeycode. </p>
    pub honeycode: std::option::Option<crate::model::HoneycodeConnectorProfileProperties>,
    /// <p> The connector-specific properties required by Infor Nexus. </p>
    pub infor_nexus: std::option::Option<crate::model::InforNexusConnectorProfileProperties>,
    /// <p> The connector-specific properties required by Marketo. </p>
    pub marketo: std::option::Option<crate::model::MarketoConnectorProfileProperties>,
    /// <p> The connector-specific properties required by Amazon Redshift. </p>
    pub redshift: std::option::Option<crate::model::RedshiftConnectorProfileProperties>,
    /// <p> The connector-specific properties required by Salesforce. </p>
    pub salesforce: std::option::Option<crate::model::SalesforceConnectorProfileProperties>,
    /// <p> The connector-specific properties required by serviceNow. </p>
    pub service_now: std::option::Option<crate::model::ServiceNowConnectorProfileProperties>,
    /// <p> The connector-specific properties required by Singular. </p>
    pub singular: std::option::Option<crate::model::SingularConnectorProfileProperties>,
    /// <p> The connector-specific properties required by Slack. </p>
    pub slack: std::option::Option<crate::model::SlackConnectorProfileProperties>,
    /// <p> The connector-specific properties required by Snowflake. </p>
    pub snowflake: std::option::Option<crate::model::SnowflakeConnectorProfileProperties>,
    /// <p> The connector-specific properties required by Trend Micro. </p>
    pub trendmicro: std::option::Option<crate::model::TrendmicroConnectorProfileProperties>,
    /// <p> The connector-specific properties required by Veeva. </p>
    pub veeva: std::option::Option<crate::model::VeevaConnectorProfileProperties>,
    /// <p> The connector-specific properties required by Zendesk. </p>
    pub zendesk: std::option::Option<crate::model::ZendeskConnectorProfileProperties>,
    /// <p> The connector-specific profile properties required when using SAPOData. </p>
    pub sapo_data: std::option::Option<crate::model::SapoDataConnectorProfileProperties>,
    /// <p>The properties required by the custom connector.</p>
    pub custom_connector: std::option::Option<crate::model::CustomConnectorProfileProperties>,
}
impl ConnectorProfileProperties {
    /// <p> The connector-specific properties required by Amplitude. </p>
    pub fn amplitude(
        &self,
    ) -> std::option::Option<&crate::model::AmplitudeConnectorProfileProperties> {
        self.amplitude.as_ref()
    }
    /// <p> The connector-specific properties required by Datadog. </p>
    pub fn datadog(&self) -> std::option::Option<&crate::model::DatadogConnectorProfileProperties> {
        self.datadog.as_ref()
    }
    /// <p> The connector-specific properties required by Dynatrace. </p>
    pub fn dynatrace(
        &self,
    ) -> std::option::Option<&crate::model::DynatraceConnectorProfileProperties> {
        self.dynatrace.as_ref()
    }
    /// <p> The connector-specific properties required Google Analytics. </p>
    pub fn google_analytics(
        &self,
    ) -> std::option::Option<&crate::model::GoogleAnalyticsConnectorProfileProperties> {
        self.google_analytics.as_ref()
    }
    /// <p> The connector-specific properties required by Amazon Honeycode. </p>
    pub fn honeycode(
        &self,
    ) -> std::option::Option<&crate::model::HoneycodeConnectorProfileProperties> {
        self.honeycode.as_ref()
    }
    /// <p> The connector-specific properties required by Infor Nexus. </p>
    pub fn infor_nexus(
        &self,
    ) -> std::option::Option<&crate::model::InforNexusConnectorProfileProperties> {
        self.infor_nexus.as_ref()
    }
    /// <p> The connector-specific properties required by Marketo. </p>
    pub fn marketo(&self) -> std::option::Option<&crate::model::MarketoConnectorProfileProperties> {
        self.marketo.as_ref()
    }
    /// <p> The connector-specific properties required by Amazon Redshift. </p>
    pub fn redshift(
        &self,
    ) -> std::option::Option<&crate::model::RedshiftConnectorProfileProperties> {
        self.redshift.as_ref()
    }
    /// <p> The connector-specific properties required by Salesforce. </p>
    pub fn salesforce(
        &self,
    ) -> std::option::Option<&crate::model::SalesforceConnectorProfileProperties> {
        self.salesforce.as_ref()
    }
    /// <p> The connector-specific properties required by serviceNow. </p>
    pub fn service_now(
        &self,
    ) -> std::option::Option<&crate::model::ServiceNowConnectorProfileProperties> {
        self.service_now.as_ref()
    }
    /// <p> The connector-specific properties required by Singular. </p>
    pub fn singular(
        &self,
    ) -> std::option::Option<&crate::model::SingularConnectorProfileProperties> {
        self.singular.as_ref()
    }
    /// <p> The connector-specific properties required by Slack. </p>
    pub fn slack(&self) -> std::option::Option<&crate::model::SlackConnectorProfileProperties> {
        self.slack.as_ref()
    }
    /// <p> The connector-specific properties required by Snowflake. </p>
    pub fn snowflake(
        &self,
    ) -> std::option::Option<&crate::model::SnowflakeConnectorProfileProperties> {
        self.snowflake.as_ref()
    }
    /// <p> The connector-specific properties required by Trend Micro. </p>
    pub fn trendmicro(
        &self,
    ) -> std::option::Option<&crate::model::TrendmicroConnectorProfileProperties> {
        self.trendmicro.as_ref()
    }
    /// <p> The connector-specific properties required by Veeva. </p>
    pub fn veeva(&self) -> std::option::Option<&crate::model::VeevaConnectorProfileProperties> {
        self.veeva.as_ref()
    }
    /// <p> The connector-specific properties required by Zendesk. </p>
    pub fn zendesk(&self) -> std::option::Option<&crate::model::ZendeskConnectorProfileProperties> {
        self.zendesk.as_ref()
    }
    /// <p> The connector-specific profile properties required when using SAPOData. </p>
    pub fn sapo_data(
        &self,
    ) -> std::option::Option<&crate::model::SapoDataConnectorProfileProperties> {
        self.sapo_data.as_ref()
    }
    /// <p>The properties required by the custom connector.</p>
    pub fn custom_connector(
        &self,
    ) -> std::option::Option<&crate::model::CustomConnectorProfileProperties> {
        self.custom_connector.as_ref()
    }
}
impl std::fmt::Debug for ConnectorProfileProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConnectorProfileProperties");
        formatter.field("amplitude", &self.amplitude);
        formatter.field("datadog", &self.datadog);
        formatter.field("dynatrace", &self.dynatrace);
        formatter.field("google_analytics", &self.google_analytics);
        formatter.field("honeycode", &self.honeycode);
        formatter.field("infor_nexus", &self.infor_nexus);
        formatter.field("marketo", &self.marketo);
        formatter.field("redshift", &self.redshift);
        formatter.field("salesforce", &self.salesforce);
        formatter.field("service_now", &self.service_now);
        formatter.field("singular", &self.singular);
        formatter.field("slack", &self.slack);
        formatter.field("snowflake", &self.snowflake);
        formatter.field("trendmicro", &self.trendmicro);
        formatter.field("veeva", &self.veeva);
        formatter.field("zendesk", &self.zendesk);
        formatter.field("sapo_data", &self.sapo_data);
        formatter.field("custom_connector", &self.custom_connector);
        formatter.finish()
    }
}
/// See [`ConnectorProfileProperties`](crate::model::ConnectorProfileProperties)
pub mod connector_profile_properties {
    /// A builder for [`ConnectorProfileProperties`](crate::model::ConnectorProfileProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) amplitude:
            std::option::Option<crate::model::AmplitudeConnectorProfileProperties>,
        pub(crate) datadog: std::option::Option<crate::model::DatadogConnectorProfileProperties>,
        pub(crate) dynatrace:
            std::option::Option<crate::model::DynatraceConnectorProfileProperties>,
        pub(crate) google_analytics:
            std::option::Option<crate::model::GoogleAnalyticsConnectorProfileProperties>,
        pub(crate) honeycode:
            std::option::Option<crate::model::HoneycodeConnectorProfileProperties>,
        pub(crate) infor_nexus:
            std::option::Option<crate::model::InforNexusConnectorProfileProperties>,
        pub(crate) marketo: std::option::Option<crate::model::MarketoConnectorProfileProperties>,
        pub(crate) redshift: std::option::Option<crate::model::RedshiftConnectorProfileProperties>,
        pub(crate) salesforce:
            std::option::Option<crate::model::SalesforceConnectorProfileProperties>,
        pub(crate) service_now:
            std::option::Option<crate::model::ServiceNowConnectorProfileProperties>,
        pub(crate) singular: std::option::Option<crate::model::SingularConnectorProfileProperties>,
        pub(crate) slack: std::option::Option<crate::model::SlackConnectorProfileProperties>,
        pub(crate) snowflake:
            std::option::Option<crate::model::SnowflakeConnectorProfileProperties>,
        pub(crate) trendmicro:
            std::option::Option<crate::model::TrendmicroConnectorProfileProperties>,
        pub(crate) veeva: std::option::Option<crate::model::VeevaConnectorProfileProperties>,
        pub(crate) zendesk: std::option::Option<crate::model::ZendeskConnectorProfileProperties>,
        pub(crate) sapo_data: std::option::Option<crate::model::SapoDataConnectorProfileProperties>,
        pub(crate) custom_connector:
            std::option::Option<crate::model::CustomConnectorProfileProperties>,
    }
    impl Builder {
        /// <p> The connector-specific properties required by Amplitude. </p>
        pub fn amplitude(
            mut self,
            input: crate::model::AmplitudeConnectorProfileProperties,
        ) -> Self {
            self.amplitude = Some(input);
            self
        }
        /// <p> The connector-specific properties required by Amplitude. </p>
        pub fn set_amplitude(
            mut self,
            input: std::option::Option<crate::model::AmplitudeConnectorProfileProperties>,
        ) -> Self {
            self.amplitude = input;
            self
        }
        /// <p> The connector-specific properties required by Datadog. </p>
        pub fn datadog(mut self, input: crate::model::DatadogConnectorProfileProperties) -> Self {
            self.datadog = Some(input);
            self
        }
        /// <p> The connector-specific properties required by Datadog. </p>
        pub fn set_datadog(
            mut self,
            input: std::option::Option<crate::model::DatadogConnectorProfileProperties>,
        ) -> Self {
            self.datadog = input;
            self
        }
        /// <p> The connector-specific properties required by Dynatrace. </p>
        pub fn dynatrace(
            mut self,
            input: crate::model::DynatraceConnectorProfileProperties,
        ) -> Self {
            self.dynatrace = Some(input);
            self
        }
        /// <p> The connector-specific properties required by Dynatrace. </p>
        pub fn set_dynatrace(
            mut self,
            input: std::option::Option<crate::model::DynatraceConnectorProfileProperties>,
        ) -> Self {
            self.dynatrace = input;
            self
        }
        /// <p> The connector-specific properties required Google Analytics. </p>
        pub fn google_analytics(
            mut self,
            input: crate::model::GoogleAnalyticsConnectorProfileProperties,
        ) -> Self {
            self.google_analytics = Some(input);
            self
        }
        /// <p> The connector-specific properties required Google Analytics. </p>
        pub fn set_google_analytics(
            mut self,
            input: std::option::Option<crate::model::GoogleAnalyticsConnectorProfileProperties>,
        ) -> Self {
            self.google_analytics = input;
            self
        }
        /// <p> The connector-specific properties required by Amazon Honeycode. </p>
        pub fn honeycode(
            mut self,
            input: crate::model::HoneycodeConnectorProfileProperties,
        ) -> Self {
            self.honeycode = Some(input);
            self
        }
        /// <p> The connector-specific properties required by Amazon Honeycode. </p>
        pub fn set_honeycode(
            mut self,
            input: std::option::Option<crate::model::HoneycodeConnectorProfileProperties>,
        ) -> Self {
            self.honeycode = input;
            self
        }
        /// <p> The connector-specific properties required by Infor Nexus. </p>
        pub fn infor_nexus(
            mut self,
            input: crate::model::InforNexusConnectorProfileProperties,
        ) -> Self {
            self.infor_nexus = Some(input);
            self
        }
        /// <p> The connector-specific properties required by Infor Nexus. </p>
        pub fn set_infor_nexus(
            mut self,
            input: std::option::Option<crate::model::InforNexusConnectorProfileProperties>,
        ) -> Self {
            self.infor_nexus = input;
            self
        }
        /// <p> The connector-specific properties required by Marketo. </p>
        pub fn marketo(mut self, input: crate::model::MarketoConnectorProfileProperties) -> Self {
            self.marketo = Some(input);
            self
        }
        /// <p> The connector-specific properties required by Marketo. </p>
        pub fn set_marketo(
            mut self,
            input: std::option::Option<crate::model::MarketoConnectorProfileProperties>,
        ) -> Self {
            self.marketo = input;
            self
        }
        /// <p> The connector-specific properties required by Amazon Redshift. </p>
        pub fn redshift(mut self, input: crate::model::RedshiftConnectorProfileProperties) -> Self {
            self.redshift = Some(input);
            self
        }
        /// <p> The connector-specific properties required by Amazon Redshift. </p>
        pub fn set_redshift(
            mut self,
            input: std::option::Option<crate::model::RedshiftConnectorProfileProperties>,
        ) -> Self {
            self.redshift = input;
            self
        }
        /// <p> The connector-specific properties required by Salesforce. </p>
        pub fn salesforce(
            mut self,
            input: crate::model::SalesforceConnectorProfileProperties,
        ) -> Self {
            self.salesforce = Some(input);
            self
        }
        /// <p> The connector-specific properties required by Salesforce. </p>
        pub fn set_salesforce(
            mut self,
            input: std::option::Option<crate::model::SalesforceConnectorProfileProperties>,
        ) -> Self {
            self.salesforce = input;
            self
        }
        /// <p> The connector-specific properties required by serviceNow. </p>
        pub fn service_now(
            mut self,
            input: crate::model::ServiceNowConnectorProfileProperties,
        ) -> Self {
            self.service_now = Some(input);
            self
        }
        /// <p> The connector-specific properties required by serviceNow. </p>
        pub fn set_service_now(
            mut self,
            input: std::option::Option<crate::model::ServiceNowConnectorProfileProperties>,
        ) -> Self {
            self.service_now = input;
            self
        }
        /// <p> The connector-specific properties required by Singular. </p>
        pub fn singular(mut self, input: crate::model::SingularConnectorProfileProperties) -> Self {
            self.singular = Some(input);
            self
        }
        /// <p> The connector-specific properties required by Singular. </p>
        pub fn set_singular(
            mut self,
            input: std::option::Option<crate::model::SingularConnectorProfileProperties>,
        ) -> Self {
            self.singular = input;
            self
        }
        /// <p> The connector-specific properties required by Slack. </p>
        pub fn slack(mut self, input: crate::model::SlackConnectorProfileProperties) -> Self {
            self.slack = Some(input);
            self
        }
        /// <p> The connector-specific properties required by Slack. </p>
        pub fn set_slack(
            mut self,
            input: std::option::Option<crate::model::SlackConnectorProfileProperties>,
        ) -> Self {
            self.slack = input;
            self
        }
        /// <p> The connector-specific properties required by Snowflake. </p>
        pub fn snowflake(
            mut self,
            input: crate::model::SnowflakeConnectorProfileProperties,
        ) -> Self {
            self.snowflake = Some(input);
            self
        }
        /// <p> The connector-specific properties required by Snowflake. </p>
        pub fn set_snowflake(
            mut self,
            input: std::option::Option<crate::model::SnowflakeConnectorProfileProperties>,
        ) -> Self {
            self.snowflake = input;
            self
        }
        /// <p> The connector-specific properties required by Trend Micro. </p>
        pub fn trendmicro(
            mut self,
            input: crate::model::TrendmicroConnectorProfileProperties,
        ) -> Self {
            self.trendmicro = Some(input);
            self
        }
        /// <p> The connector-specific properties required by Trend Micro. </p>
        pub fn set_trendmicro(
            mut self,
            input: std::option::Option<crate::model::TrendmicroConnectorProfileProperties>,
        ) -> Self {
            self.trendmicro = input;
            self
        }
        /// <p> The connector-specific properties required by Veeva. </p>
        pub fn veeva(mut self, input: crate::model::VeevaConnectorProfileProperties) -> Self {
            self.veeva = Some(input);
            self
        }
        /// <p> The connector-specific properties required by Veeva. </p>
        pub fn set_veeva(
            mut self,
            input: std::option::Option<crate::model::VeevaConnectorProfileProperties>,
        ) -> Self {
            self.veeva = input;
            self
        }
        /// <p> The connector-specific properties required by Zendesk. </p>
        pub fn zendesk(mut self, input: crate::model::ZendeskConnectorProfileProperties) -> Self {
            self.zendesk = Some(input);
            self
        }
        /// <p> The connector-specific properties required by Zendesk. </p>
        pub fn set_zendesk(
            mut self,
            input: std::option::Option<crate::model::ZendeskConnectorProfileProperties>,
        ) -> Self {
            self.zendesk = input;
            self
        }
        /// <p> The connector-specific profile properties required when using SAPOData. </p>
        pub fn sapo_data(
            mut self,
            input: crate::model::SapoDataConnectorProfileProperties,
        ) -> Self {
            self.sapo_data = Some(input);
            self
        }
        /// <p> The connector-specific profile properties required when using SAPOData. </p>
        pub fn set_sapo_data(
            mut self,
            input: std::option::Option<crate::model::SapoDataConnectorProfileProperties>,
        ) -> Self {
            self.sapo_data = input;
            self
        }
        /// <p>The properties required by the custom connector.</p>
        pub fn custom_connector(
            mut self,
            input: crate::model::CustomConnectorProfileProperties,
        ) -> Self {
            self.custom_connector = Some(input);
            self
        }
        /// <p>The properties required by the custom connector.</p>
        pub fn set_custom_connector(
            mut self,
            input: std::option::Option<crate::model::CustomConnectorProfileProperties>,
        ) -> Self {
            self.custom_connector = input;
            self
        }
        /// Consumes the builder and constructs a [`ConnectorProfileProperties`](crate::model::ConnectorProfileProperties)
        pub fn build(self) -> crate::model::ConnectorProfileProperties {
            crate::model::ConnectorProfileProperties {
                amplitude: self.amplitude,
                datadog: self.datadog,
                dynatrace: self.dynatrace,
                google_analytics: self.google_analytics,
                honeycode: self.honeycode,
                infor_nexus: self.infor_nexus,
                marketo: self.marketo,
                redshift: self.redshift,
                salesforce: self.salesforce,
                service_now: self.service_now,
                singular: self.singular,
                slack: self.slack,
                snowflake: self.snowflake,
                trendmicro: self.trendmicro,
                veeva: self.veeva,
                zendesk: self.zendesk,
                sapo_data: self.sapo_data,
                custom_connector: self.custom_connector,
            }
        }
    }
}
impl ConnectorProfileProperties {
    /// Creates a new builder-style object to manufacture [`ConnectorProfileProperties`](crate::model::ConnectorProfileProperties)
    pub fn builder() -> crate::model::connector_profile_properties::Builder {
        crate::model::connector_profile_properties::Builder::default()
    }
}

/// <p>The profile properties required by the custom connector.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomConnectorProfileProperties {
    /// <p>A map of properties that are required to create a profile for the custom connector.</p>
    pub profile_properties:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The OAuth 2.0 properties required for OAuth 2.0 authentication.</p>
    pub o_auth2_properties: std::option::Option<crate::model::OAuth2Properties>,
}
impl CustomConnectorProfileProperties {
    /// <p>A map of properties that are required to create a profile for the custom connector.</p>
    pub fn profile_properties(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.profile_properties.as_ref()
    }
    /// <p>The OAuth 2.0 properties required for OAuth 2.0 authentication.</p>
    pub fn o_auth2_properties(&self) -> std::option::Option<&crate::model::OAuth2Properties> {
        self.o_auth2_properties.as_ref()
    }
}
impl std::fmt::Debug for CustomConnectorProfileProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomConnectorProfileProperties");
        formatter.field("profile_properties", &self.profile_properties);
        formatter.field("o_auth2_properties", &self.o_auth2_properties);
        formatter.finish()
    }
}
/// See [`CustomConnectorProfileProperties`](crate::model::CustomConnectorProfileProperties)
pub mod custom_connector_profile_properties {
    /// A builder for [`CustomConnectorProfileProperties`](crate::model::CustomConnectorProfileProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) profile_properties: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) o_auth2_properties: std::option::Option<crate::model::OAuth2Properties>,
    }
    impl Builder {
        /// Adds a key-value pair to `profile_properties`.
        ///
        /// To override the contents of this collection use [`set_profile_properties`](Self::set_profile_properties).
        ///
        /// <p>A map of properties that are required to create a profile for the custom connector.</p>
        pub fn profile_properties(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.profile_properties.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.profile_properties = Some(hash_map);
            self
        }
        /// <p>A map of properties that are required to create a profile for the custom connector.</p>
        pub fn set_profile_properties(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.profile_properties = input;
            self
        }
        /// <p>The OAuth 2.0 properties required for OAuth 2.0 authentication.</p>
        pub fn o_auth2_properties(mut self, input: crate::model::OAuth2Properties) -> Self {
            self.o_auth2_properties = Some(input);
            self
        }
        /// <p>The OAuth 2.0 properties required for OAuth 2.0 authentication.</p>
        pub fn set_o_auth2_properties(
            mut self,
            input: std::option::Option<crate::model::OAuth2Properties>,
        ) -> Self {
            self.o_auth2_properties = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomConnectorProfileProperties`](crate::model::CustomConnectorProfileProperties)
        pub fn build(self) -> crate::model::CustomConnectorProfileProperties {
            crate::model::CustomConnectorProfileProperties {
                profile_properties: self.profile_properties,
                o_auth2_properties: self.o_auth2_properties,
            }
        }
    }
}
impl CustomConnectorProfileProperties {
    /// Creates a new builder-style object to manufacture [`CustomConnectorProfileProperties`](crate::model::CustomConnectorProfileProperties)
    pub fn builder() -> crate::model::custom_connector_profile_properties::Builder {
        crate::model::custom_connector_profile_properties::Builder::default()
    }
}

/// <p>The OAuth 2.0 properties required for OAuth 2.0 authentication.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OAuth2Properties {
    /// <p>The token URL required for OAuth 2.0 authentication.</p>
    pub token_url: std::option::Option<std::string::String>,
    /// <p>The OAuth 2.0 grant type used by connector for OAuth 2.0 authentication.</p>
    pub o_auth2_grant_type: std::option::Option<crate::model::OAuth2GrantType>,
    /// <p>Associates your token URL with a map of properties that you define. Use this parameter to provide any additional details that the connector requires to authenticate your request.</p>
    pub token_url_custom_properties:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl OAuth2Properties {
    /// <p>The token URL required for OAuth 2.0 authentication.</p>
    pub fn token_url(&self) -> std::option::Option<&str> {
        self.token_url.as_deref()
    }
    /// <p>The OAuth 2.0 grant type used by connector for OAuth 2.0 authentication.</p>
    pub fn o_auth2_grant_type(&self) -> std::option::Option<&crate::model::OAuth2GrantType> {
        self.o_auth2_grant_type.as_ref()
    }
    /// <p>Associates your token URL with a map of properties that you define. Use this parameter to provide any additional details that the connector requires to authenticate your request.</p>
    pub fn token_url_custom_properties(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.token_url_custom_properties.as_ref()
    }
}
impl std::fmt::Debug for OAuth2Properties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OAuth2Properties");
        formatter.field("token_url", &self.token_url);
        formatter.field("o_auth2_grant_type", &self.o_auth2_grant_type);
        formatter.field(
            "token_url_custom_properties",
            &self.token_url_custom_properties,
        );
        formatter.finish()
    }
}
/// See [`OAuth2Properties`](crate::model::OAuth2Properties)
pub mod o_auth2_properties {
    /// A builder for [`OAuth2Properties`](crate::model::OAuth2Properties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) token_url: std::option::Option<std::string::String>,
        pub(crate) o_auth2_grant_type: std::option::Option<crate::model::OAuth2GrantType>,
        pub(crate) token_url_custom_properties: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The token URL required for OAuth 2.0 authentication.</p>
        pub fn token_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.token_url = Some(input.into());
            self
        }
        /// <p>The token URL required for OAuth 2.0 authentication.</p>
        pub fn set_token_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.token_url = input;
            self
        }
        /// <p>The OAuth 2.0 grant type used by connector for OAuth 2.0 authentication.</p>
        pub fn o_auth2_grant_type(mut self, input: crate::model::OAuth2GrantType) -> Self {
            self.o_auth2_grant_type = Some(input);
            self
        }
        /// <p>The OAuth 2.0 grant type used by connector for OAuth 2.0 authentication.</p>
        pub fn set_o_auth2_grant_type(
            mut self,
            input: std::option::Option<crate::model::OAuth2GrantType>,
        ) -> Self {
            self.o_auth2_grant_type = input;
            self
        }
        /// Adds a key-value pair to `token_url_custom_properties`.
        ///
        /// To override the contents of this collection use [`set_token_url_custom_properties`](Self::set_token_url_custom_properties).
        ///
        /// <p>Associates your token URL with a map of properties that you define. Use this parameter to provide any additional details that the connector requires to authenticate your request.</p>
        pub fn token_url_custom_properties(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.token_url_custom_properties.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.token_url_custom_properties = Some(hash_map);
            self
        }
        /// <p>Associates your token URL with a map of properties that you define. Use this parameter to provide any additional details that the connector requires to authenticate your request.</p>
        pub fn set_token_url_custom_properties(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.token_url_custom_properties = input;
            self
        }
        /// Consumes the builder and constructs a [`OAuth2Properties`](crate::model::OAuth2Properties)
        pub fn build(self) -> crate::model::OAuth2Properties {
            crate::model::OAuth2Properties {
                token_url: self.token_url,
                o_auth2_grant_type: self.o_auth2_grant_type,
                token_url_custom_properties: self.token_url_custom_properties,
            }
        }
    }
}
impl OAuth2Properties {
    /// Creates a new builder-style object to manufacture [`OAuth2Properties`](crate::model::OAuth2Properties)
    pub fn builder() -> crate::model::o_auth2_properties::Builder {
        crate::model::o_auth2_properties::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OAuth2GrantType {
    #[allow(missing_docs)] // documentation missing in model
    AuthorizationCode,
    #[allow(missing_docs)] // documentation missing in model
    ClientCredentials,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OAuth2GrantType {
    fn from(s: &str) -> Self {
        match s {
            "AUTHORIZATION_CODE" => OAuth2GrantType::AuthorizationCode,
            "CLIENT_CREDENTIALS" => OAuth2GrantType::ClientCredentials,
            other => OAuth2GrantType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OAuth2GrantType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OAuth2GrantType::from(s))
    }
}
impl OAuth2GrantType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OAuth2GrantType::AuthorizationCode => "AUTHORIZATION_CODE",
            OAuth2GrantType::ClientCredentials => "CLIENT_CREDENTIALS",
            OAuth2GrantType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AUTHORIZATION_CODE", "CLIENT_CREDENTIALS"]
    }
}
impl AsRef<str> for OAuth2GrantType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> The connector-specific profile properties required when using SAPOData. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SapoDataConnectorProfileProperties {
    /// <p> The location of the SAPOData resource. </p>
    pub application_host_url: std::option::Option<std::string::String>,
    /// <p> The application path to catalog service. </p>
    pub application_service_path: std::option::Option<std::string::String>,
    /// <p> The port number of the SAPOData instance. </p>
    pub port_number: std::option::Option<i32>,
    /// <p> The client number for the client creating the connection. </p>
    pub client_number: std::option::Option<std::string::String>,
    /// <p> The logon language of SAPOData instance. </p>
    pub logon_language: std::option::Option<std::string::String>,
    /// <p> The SAPOData Private Link service name to be used for private data transfers. </p>
    pub private_link_service_name: std::option::Option<std::string::String>,
    /// <p> The SAPOData OAuth properties required for OAuth type authentication. </p>
    pub o_auth_properties: std::option::Option<crate::model::OAuthProperties>,
}
impl SapoDataConnectorProfileProperties {
    /// <p> The location of the SAPOData resource. </p>
    pub fn application_host_url(&self) -> std::option::Option<&str> {
        self.application_host_url.as_deref()
    }
    /// <p> The application path to catalog service. </p>
    pub fn application_service_path(&self) -> std::option::Option<&str> {
        self.application_service_path.as_deref()
    }
    /// <p> The port number of the SAPOData instance. </p>
    pub fn port_number(&self) -> std::option::Option<i32> {
        self.port_number
    }
    /// <p> The client number for the client creating the connection. </p>
    pub fn client_number(&self) -> std::option::Option<&str> {
        self.client_number.as_deref()
    }
    /// <p> The logon language of SAPOData instance. </p>
    pub fn logon_language(&self) -> std::option::Option<&str> {
        self.logon_language.as_deref()
    }
    /// <p> The SAPOData Private Link service name to be used for private data transfers. </p>
    pub fn private_link_service_name(&self) -> std::option::Option<&str> {
        self.private_link_service_name.as_deref()
    }
    /// <p> The SAPOData OAuth properties required for OAuth type authentication. </p>
    pub fn o_auth_properties(&self) -> std::option::Option<&crate::model::OAuthProperties> {
        self.o_auth_properties.as_ref()
    }
}
impl std::fmt::Debug for SapoDataConnectorProfileProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SapoDataConnectorProfileProperties");
        formatter.field("application_host_url", &self.application_host_url);
        formatter.field("application_service_path", &self.application_service_path);
        formatter.field("port_number", &self.port_number);
        formatter.field("client_number", &self.client_number);
        formatter.field("logon_language", &self.logon_language);
        formatter.field("private_link_service_name", &self.private_link_service_name);
        formatter.field("o_auth_properties", &self.o_auth_properties);
        formatter.finish()
    }
}
/// See [`SapoDataConnectorProfileProperties`](crate::model::SapoDataConnectorProfileProperties)
pub mod sapo_data_connector_profile_properties {
    /// A builder for [`SapoDataConnectorProfileProperties`](crate::model::SapoDataConnectorProfileProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_host_url: std::option::Option<std::string::String>,
        pub(crate) application_service_path: std::option::Option<std::string::String>,
        pub(crate) port_number: std::option::Option<i32>,
        pub(crate) client_number: std::option::Option<std::string::String>,
        pub(crate) logon_language: std::option::Option<std::string::String>,
        pub(crate) private_link_service_name: std::option::Option<std::string::String>,
        pub(crate) o_auth_properties: std::option::Option<crate::model::OAuthProperties>,
    }
    impl Builder {
        /// <p> The location of the SAPOData resource. </p>
        pub fn application_host_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_host_url = Some(input.into());
            self
        }
        /// <p> The location of the SAPOData resource. </p>
        pub fn set_application_host_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_host_url = input;
            self
        }
        /// <p> The application path to catalog service. </p>
        pub fn application_service_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_service_path = Some(input.into());
            self
        }
        /// <p> The application path to catalog service. </p>
        pub fn set_application_service_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_service_path = input;
            self
        }
        /// <p> The port number of the SAPOData instance. </p>
        pub fn port_number(mut self, input: i32) -> Self {
            self.port_number = Some(input);
            self
        }
        /// <p> The port number of the SAPOData instance. </p>
        pub fn set_port_number(mut self, input: std::option::Option<i32>) -> Self {
            self.port_number = input;
            self
        }
        /// <p> The client number for the client creating the connection. </p>
        pub fn client_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_number = Some(input.into());
            self
        }
        /// <p> The client number for the client creating the connection. </p>
        pub fn set_client_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_number = input;
            self
        }
        /// <p> The logon language of SAPOData instance. </p>
        pub fn logon_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.logon_language = Some(input.into());
            self
        }
        /// <p> The logon language of SAPOData instance. </p>
        pub fn set_logon_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.logon_language = input;
            self
        }
        /// <p> The SAPOData Private Link service name to be used for private data transfers. </p>
        pub fn private_link_service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.private_link_service_name = Some(input.into());
            self
        }
        /// <p> The SAPOData Private Link service name to be used for private data transfers. </p>
        pub fn set_private_link_service_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.private_link_service_name = input;
            self
        }
        /// <p> The SAPOData OAuth properties required for OAuth type authentication. </p>
        pub fn o_auth_properties(mut self, input: crate::model::OAuthProperties) -> Self {
            self.o_auth_properties = Some(input);
            self
        }
        /// <p> The SAPOData OAuth properties required for OAuth type authentication. </p>
        pub fn set_o_auth_properties(
            mut self,
            input: std::option::Option<crate::model::OAuthProperties>,
        ) -> Self {
            self.o_auth_properties = input;
            self
        }
        /// Consumes the builder and constructs a [`SapoDataConnectorProfileProperties`](crate::model::SapoDataConnectorProfileProperties)
        pub fn build(self) -> crate::model::SapoDataConnectorProfileProperties {
            crate::model::SapoDataConnectorProfileProperties {
                application_host_url: self.application_host_url,
                application_service_path: self.application_service_path,
                port_number: self.port_number,
                client_number: self.client_number,
                logon_language: self.logon_language,
                private_link_service_name: self.private_link_service_name,
                o_auth_properties: self.o_auth_properties,
            }
        }
    }
}
impl SapoDataConnectorProfileProperties {
    /// Creates a new builder-style object to manufacture [`SapoDataConnectorProfileProperties`](crate::model::SapoDataConnectorProfileProperties)
    pub fn builder() -> crate::model::sapo_data_connector_profile_properties::Builder {
        crate::model::sapo_data_connector_profile_properties::Builder::default()
    }
}

/// <p> The OAuth properties required for OAuth type authentication. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OAuthProperties {
    /// <p> The token url required to fetch access/refresh tokens using authorization code and also to refresh expired access token using refresh token.</p>
    pub token_url: std::option::Option<std::string::String>,
    /// <p> The authorization code url required to redirect to SAP Login Page to fetch authorization code for OAuth type authentication. </p>
    pub auth_code_url: std::option::Option<std::string::String>,
    /// <p> The OAuth scopes required for OAuth type authentication. </p>
    pub o_auth_scopes: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl OAuthProperties {
    /// <p> The token url required to fetch access/refresh tokens using authorization code and also to refresh expired access token using refresh token.</p>
    pub fn token_url(&self) -> std::option::Option<&str> {
        self.token_url.as_deref()
    }
    /// <p> The authorization code url required to redirect to SAP Login Page to fetch authorization code for OAuth type authentication. </p>
    pub fn auth_code_url(&self) -> std::option::Option<&str> {
        self.auth_code_url.as_deref()
    }
    /// <p> The OAuth scopes required for OAuth type authentication. </p>
    pub fn o_auth_scopes(&self) -> std::option::Option<&[std::string::String]> {
        self.o_auth_scopes.as_deref()
    }
}
impl std::fmt::Debug for OAuthProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OAuthProperties");
        formatter.field("token_url", &self.token_url);
        formatter.field("auth_code_url", &self.auth_code_url);
        formatter.field("o_auth_scopes", &self.o_auth_scopes);
        formatter.finish()
    }
}
/// See [`OAuthProperties`](crate::model::OAuthProperties)
pub mod o_auth_properties {
    /// A builder for [`OAuthProperties`](crate::model::OAuthProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) token_url: std::option::Option<std::string::String>,
        pub(crate) auth_code_url: std::option::Option<std::string::String>,
        pub(crate) o_auth_scopes: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p> The token url required to fetch access/refresh tokens using authorization code and also to refresh expired access token using refresh token.</p>
        pub fn token_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.token_url = Some(input.into());
            self
        }
        /// <p> The token url required to fetch access/refresh tokens using authorization code and also to refresh expired access token using refresh token.</p>
        pub fn set_token_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.token_url = input;
            self
        }
        /// <p> The authorization code url required to redirect to SAP Login Page to fetch authorization code for OAuth type authentication. </p>
        pub fn auth_code_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.auth_code_url = Some(input.into());
            self
        }
        /// <p> The authorization code url required to redirect to SAP Login Page to fetch authorization code for OAuth type authentication. </p>
        pub fn set_auth_code_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auth_code_url = input;
            self
        }
        /// Appends an item to `o_auth_scopes`.
        ///
        /// To override the contents of this collection use [`set_o_auth_scopes`](Self::set_o_auth_scopes).
        ///
        /// <p> The OAuth scopes required for OAuth type authentication. </p>
        pub fn o_auth_scopes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.o_auth_scopes.unwrap_or_default();
            v.push(input.into());
            self.o_auth_scopes = Some(v);
            self
        }
        /// <p> The OAuth scopes required for OAuth type authentication. </p>
        pub fn set_o_auth_scopes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.o_auth_scopes = input;
            self
        }
        /// Consumes the builder and constructs a [`OAuthProperties`](crate::model::OAuthProperties)
        pub fn build(self) -> crate::model::OAuthProperties {
            crate::model::OAuthProperties {
                token_url: self.token_url,
                auth_code_url: self.auth_code_url,
                o_auth_scopes: self.o_auth_scopes,
            }
        }
    }
}
impl OAuthProperties {
    /// Creates a new builder-style object to manufacture [`OAuthProperties`](crate::model::OAuthProperties)
    pub fn builder() -> crate::model::o_auth_properties::Builder {
        crate::model::o_auth_properties::Builder::default()
    }
}

/// <p> The connector-specific profile properties required when using Zendesk. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ZendeskConnectorProfileProperties {
    /// <p> The location of the Zendesk resource. </p>
    pub instance_url: std::option::Option<std::string::String>,
}
impl ZendeskConnectorProfileProperties {
    /// <p> The location of the Zendesk resource. </p>
    pub fn instance_url(&self) -> std::option::Option<&str> {
        self.instance_url.as_deref()
    }
}
impl std::fmt::Debug for ZendeskConnectorProfileProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ZendeskConnectorProfileProperties");
        formatter.field("instance_url", &self.instance_url);
        formatter.finish()
    }
}
/// See [`ZendeskConnectorProfileProperties`](crate::model::ZendeskConnectorProfileProperties)
pub mod zendesk_connector_profile_properties {
    /// A builder for [`ZendeskConnectorProfileProperties`](crate::model::ZendeskConnectorProfileProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The location of the Zendesk resource. </p>
        pub fn instance_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_url = Some(input.into());
            self
        }
        /// <p> The location of the Zendesk resource. </p>
        pub fn set_instance_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_url = input;
            self
        }
        /// Consumes the builder and constructs a [`ZendeskConnectorProfileProperties`](crate::model::ZendeskConnectorProfileProperties)
        pub fn build(self) -> crate::model::ZendeskConnectorProfileProperties {
            crate::model::ZendeskConnectorProfileProperties {
                instance_url: self.instance_url,
            }
        }
    }
}
impl ZendeskConnectorProfileProperties {
    /// Creates a new builder-style object to manufacture [`ZendeskConnectorProfileProperties`](crate::model::ZendeskConnectorProfileProperties)
    pub fn builder() -> crate::model::zendesk_connector_profile_properties::Builder {
        crate::model::zendesk_connector_profile_properties::Builder::default()
    }
}

/// <p> The connector-specific profile properties required when using Veeva. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VeevaConnectorProfileProperties {
    /// <p> The location of the Veeva resource. </p>
    pub instance_url: std::option::Option<std::string::String>,
}
impl VeevaConnectorProfileProperties {
    /// <p> The location of the Veeva resource. </p>
    pub fn instance_url(&self) -> std::option::Option<&str> {
        self.instance_url.as_deref()
    }
}
impl std::fmt::Debug for VeevaConnectorProfileProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VeevaConnectorProfileProperties");
        formatter.field("instance_url", &self.instance_url);
        formatter.finish()
    }
}
/// See [`VeevaConnectorProfileProperties`](crate::model::VeevaConnectorProfileProperties)
pub mod veeva_connector_profile_properties {
    /// A builder for [`VeevaConnectorProfileProperties`](crate::model::VeevaConnectorProfileProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The location of the Veeva resource. </p>
        pub fn instance_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_url = Some(input.into());
            self
        }
        /// <p> The location of the Veeva resource. </p>
        pub fn set_instance_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_url = input;
            self
        }
        /// Consumes the builder and constructs a [`VeevaConnectorProfileProperties`](crate::model::VeevaConnectorProfileProperties)
        pub fn build(self) -> crate::model::VeevaConnectorProfileProperties {
            crate::model::VeevaConnectorProfileProperties {
                instance_url: self.instance_url,
            }
        }
    }
}
impl VeevaConnectorProfileProperties {
    /// Creates a new builder-style object to manufacture [`VeevaConnectorProfileProperties`](crate::model::VeevaConnectorProfileProperties)
    pub fn builder() -> crate::model::veeva_connector_profile_properties::Builder {
        crate::model::veeva_connector_profile_properties::Builder::default()
    }
}

/// <p> The connector-specific profile properties required when using Trend Micro. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TrendmicroConnectorProfileProperties {}
impl std::fmt::Debug for TrendmicroConnectorProfileProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TrendmicroConnectorProfileProperties");
        formatter.finish()
    }
}
/// See [`TrendmicroConnectorProfileProperties`](crate::model::TrendmicroConnectorProfileProperties)
pub mod trendmicro_connector_profile_properties {
    /// A builder for [`TrendmicroConnectorProfileProperties`](crate::model::TrendmicroConnectorProfileProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TrendmicroConnectorProfileProperties`](crate::model::TrendmicroConnectorProfileProperties)
        pub fn build(self) -> crate::model::TrendmicroConnectorProfileProperties {
            crate::model::TrendmicroConnectorProfileProperties {}
        }
    }
}
impl TrendmicroConnectorProfileProperties {
    /// Creates a new builder-style object to manufacture [`TrendmicroConnectorProfileProperties`](crate::model::TrendmicroConnectorProfileProperties)
    pub fn builder() -> crate::model::trendmicro_connector_profile_properties::Builder {
        crate::model::trendmicro_connector_profile_properties::Builder::default()
    }
}

/// <p> The connector-specific profile properties required when using Snowflake. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SnowflakeConnectorProfileProperties {
    /// <p> The name of the Snowflake warehouse. </p>
    pub warehouse: std::option::Option<std::string::String>,
    /// <p> The name of the Amazon S3 stage that was created while setting up an Amazon S3 stage in the Snowflake account. This is written in the following format: &lt; Database&gt;&lt; Schema&gt;<stage name>
    /// .
    /// </stage></p>
    pub stage: std::option::Option<std::string::String>,
    /// <p> The name of the Amazon S3 bucket associated with Snowflake. </p>
    pub bucket_name: std::option::Option<std::string::String>,
    /// <p> The bucket path that refers to the Amazon S3 bucket associated with Snowflake. </p>
    pub bucket_prefix: std::option::Option<std::string::String>,
    /// <p> The Snowflake Private Link service name to be used for private data transfers. </p>
    pub private_link_service_name: std::option::Option<std::string::String>,
    /// <p> The name of the account. </p>
    pub account_name: std::option::Option<std::string::String>,
    /// <p> The Amazon Web Services Region of the Snowflake account. </p>
    pub region: std::option::Option<std::string::String>,
}
impl SnowflakeConnectorProfileProperties {
    /// <p> The name of the Snowflake warehouse. </p>
    pub fn warehouse(&self) -> std::option::Option<&str> {
        self.warehouse.as_deref()
    }
    /// <p> The name of the Amazon S3 stage that was created while setting up an Amazon S3 stage in the Snowflake account. This is written in the following format: &lt; Database&gt;&lt; Schema&gt;<stage name>
    /// .
    /// </stage></p>
    pub fn stage(&self) -> std::option::Option<&str> {
        self.stage.as_deref()
    }
    /// <p> The name of the Amazon S3 bucket associated with Snowflake. </p>
    pub fn bucket_name(&self) -> std::option::Option<&str> {
        self.bucket_name.as_deref()
    }
    /// <p> The bucket path that refers to the Amazon S3 bucket associated with Snowflake. </p>
    pub fn bucket_prefix(&self) -> std::option::Option<&str> {
        self.bucket_prefix.as_deref()
    }
    /// <p> The Snowflake Private Link service name to be used for private data transfers. </p>
    pub fn private_link_service_name(&self) -> std::option::Option<&str> {
        self.private_link_service_name.as_deref()
    }
    /// <p> The name of the account. </p>
    pub fn account_name(&self) -> std::option::Option<&str> {
        self.account_name.as_deref()
    }
    /// <p> The Amazon Web Services Region of the Snowflake account. </p>
    pub fn region(&self) -> std::option::Option<&str> {
        self.region.as_deref()
    }
}
impl std::fmt::Debug for SnowflakeConnectorProfileProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SnowflakeConnectorProfileProperties");
        formatter.field("warehouse", &self.warehouse);
        formatter.field("stage", &self.stage);
        formatter.field("bucket_name", &self.bucket_name);
        formatter.field("bucket_prefix", &self.bucket_prefix);
        formatter.field("private_link_service_name", &self.private_link_service_name);
        formatter.field("account_name", &self.account_name);
        formatter.field("region", &self.region);
        formatter.finish()
    }
}
/// See [`SnowflakeConnectorProfileProperties`](crate::model::SnowflakeConnectorProfileProperties)
pub mod snowflake_connector_profile_properties {
    /// A builder for [`SnowflakeConnectorProfileProperties`](crate::model::SnowflakeConnectorProfileProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) warehouse: std::option::Option<std::string::String>,
        pub(crate) stage: std::option::Option<std::string::String>,
        pub(crate) bucket_name: std::option::Option<std::string::String>,
        pub(crate) bucket_prefix: std::option::Option<std::string::String>,
        pub(crate) private_link_service_name: std::option::Option<std::string::String>,
        pub(crate) account_name: std::option::Option<std::string::String>,
        pub(crate) region: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The name of the Snowflake warehouse. </p>
        pub fn warehouse(mut self, input: impl Into<std::string::String>) -> Self {
            self.warehouse = Some(input.into());
            self
        }
        /// <p> The name of the Snowflake warehouse. </p>
        pub fn set_warehouse(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.warehouse = input;
            self
        }
        /// <p> The name of the Amazon S3 stage that was created while setting up an Amazon S3 stage in the Snowflake account. This is written in the following format: &lt; Database&gt;&lt; Schema&gt;<stage name>
        /// .
        /// </stage></p>
        pub fn stage(mut self, input: impl Into<std::string::String>) -> Self {
            self.stage = Some(input.into());
            self
        }
        /// <p> The name of the Amazon S3 stage that was created while setting up an Amazon S3 stage in the Snowflake account. This is written in the following format: &lt; Database&gt;&lt; Schema&gt;<stage name>
        /// .
        /// </stage></p>
        pub fn set_stage(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stage = input;
            self
        }
        /// <p> The name of the Amazon S3 bucket associated with Snowflake. </p>
        pub fn bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_name = Some(input.into());
            self
        }
        /// <p> The name of the Amazon S3 bucket associated with Snowflake. </p>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_name = input;
            self
        }
        /// <p> The bucket path that refers to the Amazon S3 bucket associated with Snowflake. </p>
        pub fn bucket_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_prefix = Some(input.into());
            self
        }
        /// <p> The bucket path that refers to the Amazon S3 bucket associated with Snowflake. </p>
        pub fn set_bucket_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.bucket_prefix = input;
            self
        }
        /// <p> The Snowflake Private Link service name to be used for private data transfers. </p>
        pub fn private_link_service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.private_link_service_name = Some(input.into());
            self
        }
        /// <p> The Snowflake Private Link service name to be used for private data transfers. </p>
        pub fn set_private_link_service_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.private_link_service_name = input;
            self
        }
        /// <p> The name of the account. </p>
        pub fn account_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_name = Some(input.into());
            self
        }
        /// <p> The name of the account. </p>
        pub fn set_account_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_name = input;
            self
        }
        /// <p> The Amazon Web Services Region of the Snowflake account. </p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p> The Amazon Web Services Region of the Snowflake account. </p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// Consumes the builder and constructs a [`SnowflakeConnectorProfileProperties`](crate::model::SnowflakeConnectorProfileProperties)
        pub fn build(self) -> crate::model::SnowflakeConnectorProfileProperties {
            crate::model::SnowflakeConnectorProfileProperties {
                warehouse: self.warehouse,
                stage: self.stage,
                bucket_name: self.bucket_name,
                bucket_prefix: self.bucket_prefix,
                private_link_service_name: self.private_link_service_name,
                account_name: self.account_name,
                region: self.region,
            }
        }
    }
}
impl SnowflakeConnectorProfileProperties {
    /// Creates a new builder-style object to manufacture [`SnowflakeConnectorProfileProperties`](crate::model::SnowflakeConnectorProfileProperties)
    pub fn builder() -> crate::model::snowflake_connector_profile_properties::Builder {
        crate::model::snowflake_connector_profile_properties::Builder::default()
    }
}

/// <p> The connector-specific profile properties required when using Slack. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SlackConnectorProfileProperties {
    /// <p> The location of the Slack resource. </p>
    pub instance_url: std::option::Option<std::string::String>,
}
impl SlackConnectorProfileProperties {
    /// <p> The location of the Slack resource. </p>
    pub fn instance_url(&self) -> std::option::Option<&str> {
        self.instance_url.as_deref()
    }
}
impl std::fmt::Debug for SlackConnectorProfileProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SlackConnectorProfileProperties");
        formatter.field("instance_url", &self.instance_url);
        formatter.finish()
    }
}
/// See [`SlackConnectorProfileProperties`](crate::model::SlackConnectorProfileProperties)
pub mod slack_connector_profile_properties {
    /// A builder for [`SlackConnectorProfileProperties`](crate::model::SlackConnectorProfileProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The location of the Slack resource. </p>
        pub fn instance_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_url = Some(input.into());
            self
        }
        /// <p> The location of the Slack resource. </p>
        pub fn set_instance_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_url = input;
            self
        }
        /// Consumes the builder and constructs a [`SlackConnectorProfileProperties`](crate::model::SlackConnectorProfileProperties)
        pub fn build(self) -> crate::model::SlackConnectorProfileProperties {
            crate::model::SlackConnectorProfileProperties {
                instance_url: self.instance_url,
            }
        }
    }
}
impl SlackConnectorProfileProperties {
    /// Creates a new builder-style object to manufacture [`SlackConnectorProfileProperties`](crate::model::SlackConnectorProfileProperties)
    pub fn builder() -> crate::model::slack_connector_profile_properties::Builder {
        crate::model::slack_connector_profile_properties::Builder::default()
    }
}

/// <p> The connector-specific profile properties required when using Singular. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SingularConnectorProfileProperties {}
impl std::fmt::Debug for SingularConnectorProfileProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SingularConnectorProfileProperties");
        formatter.finish()
    }
}
/// See [`SingularConnectorProfileProperties`](crate::model::SingularConnectorProfileProperties)
pub mod singular_connector_profile_properties {
    /// A builder for [`SingularConnectorProfileProperties`](crate::model::SingularConnectorProfileProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`SingularConnectorProfileProperties`](crate::model::SingularConnectorProfileProperties)
        pub fn build(self) -> crate::model::SingularConnectorProfileProperties {
            crate::model::SingularConnectorProfileProperties {}
        }
    }
}
impl SingularConnectorProfileProperties {
    /// Creates a new builder-style object to manufacture [`SingularConnectorProfileProperties`](crate::model::SingularConnectorProfileProperties)
    pub fn builder() -> crate::model::singular_connector_profile_properties::Builder {
        crate::model::singular_connector_profile_properties::Builder::default()
    }
}

/// <p> The connector-specific profile properties required when using ServiceNow. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceNowConnectorProfileProperties {
    /// <p> The location of the ServiceNow resource. </p>
    pub instance_url: std::option::Option<std::string::String>,
}
impl ServiceNowConnectorProfileProperties {
    /// <p> The location of the ServiceNow resource. </p>
    pub fn instance_url(&self) -> std::option::Option<&str> {
        self.instance_url.as_deref()
    }
}
impl std::fmt::Debug for ServiceNowConnectorProfileProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceNowConnectorProfileProperties");
        formatter.field("instance_url", &self.instance_url);
        formatter.finish()
    }
}
/// See [`ServiceNowConnectorProfileProperties`](crate::model::ServiceNowConnectorProfileProperties)
pub mod service_now_connector_profile_properties {
    /// A builder for [`ServiceNowConnectorProfileProperties`](crate::model::ServiceNowConnectorProfileProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The location of the ServiceNow resource. </p>
        pub fn instance_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_url = Some(input.into());
            self
        }
        /// <p> The location of the ServiceNow resource. </p>
        pub fn set_instance_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_url = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceNowConnectorProfileProperties`](crate::model::ServiceNowConnectorProfileProperties)
        pub fn build(self) -> crate::model::ServiceNowConnectorProfileProperties {
            crate::model::ServiceNowConnectorProfileProperties {
                instance_url: self.instance_url,
            }
        }
    }
}
impl ServiceNowConnectorProfileProperties {
    /// Creates a new builder-style object to manufacture [`ServiceNowConnectorProfileProperties`](crate::model::ServiceNowConnectorProfileProperties)
    pub fn builder() -> crate::model::service_now_connector_profile_properties::Builder {
        crate::model::service_now_connector_profile_properties::Builder::default()
    }
}

/// <p> The connector-specific profile properties required when using Salesforce. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SalesforceConnectorProfileProperties {
    /// <p> The location of the Salesforce resource. </p>
    pub instance_url: std::option::Option<std::string::String>,
    /// <p> Indicates whether the connector profile applies to a sandbox or production environment. </p>
    pub is_sandbox_environment: bool,
}
impl SalesforceConnectorProfileProperties {
    /// <p> The location of the Salesforce resource. </p>
    pub fn instance_url(&self) -> std::option::Option<&str> {
        self.instance_url.as_deref()
    }
    /// <p> Indicates whether the connector profile applies to a sandbox or production environment. </p>
    pub fn is_sandbox_environment(&self) -> bool {
        self.is_sandbox_environment
    }
}
impl std::fmt::Debug for SalesforceConnectorProfileProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SalesforceConnectorProfileProperties");
        formatter.field("instance_url", &self.instance_url);
        formatter.field("is_sandbox_environment", &self.is_sandbox_environment);
        formatter.finish()
    }
}
/// See [`SalesforceConnectorProfileProperties`](crate::model::SalesforceConnectorProfileProperties)
pub mod salesforce_connector_profile_properties {
    /// A builder for [`SalesforceConnectorProfileProperties`](crate::model::SalesforceConnectorProfileProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_url: std::option::Option<std::string::String>,
        pub(crate) is_sandbox_environment: std::option::Option<bool>,
    }
    impl Builder {
        /// <p> The location of the Salesforce resource. </p>
        pub fn instance_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_url = Some(input.into());
            self
        }
        /// <p> The location of the Salesforce resource. </p>
        pub fn set_instance_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_url = input;
            self
        }
        /// <p> Indicates whether the connector profile applies to a sandbox or production environment. </p>
        pub fn is_sandbox_environment(mut self, input: bool) -> Self {
            self.is_sandbox_environment = Some(input);
            self
        }
        /// <p> Indicates whether the connector profile applies to a sandbox or production environment. </p>
        pub fn set_is_sandbox_environment(mut self, input: std::option::Option<bool>) -> Self {
            self.is_sandbox_environment = input;
            self
        }
        /// Consumes the builder and constructs a [`SalesforceConnectorProfileProperties`](crate::model::SalesforceConnectorProfileProperties)
        pub fn build(self) -> crate::model::SalesforceConnectorProfileProperties {
            crate::model::SalesforceConnectorProfileProperties {
                instance_url: self.instance_url,
                is_sandbox_environment: self.is_sandbox_environment.unwrap_or_default(),
            }
        }
    }
}
impl SalesforceConnectorProfileProperties {
    /// Creates a new builder-style object to manufacture [`SalesforceConnectorProfileProperties`](crate::model::SalesforceConnectorProfileProperties)
    pub fn builder() -> crate::model::salesforce_connector_profile_properties::Builder {
        crate::model::salesforce_connector_profile_properties::Builder::default()
    }
}

/// <p> The connector-specific profile properties when using Amazon Redshift. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RedshiftConnectorProfileProperties {
    /// <p> The JDBC URL of the Amazon Redshift cluster. </p>
    pub database_url: std::option::Option<std::string::String>,
    /// <p> A name for the associated Amazon S3 bucket. </p>
    pub bucket_name: std::option::Option<std::string::String>,
    /// <p> The object key for the destination bucket in which Amazon AppFlow places the files. </p>
    pub bucket_prefix: std::option::Option<std::string::String>,
    /// <p> The Amazon Resource Name (ARN) of the IAM role. </p>
    pub role_arn: std::option::Option<std::string::String>,
}
impl RedshiftConnectorProfileProperties {
    /// <p> The JDBC URL of the Amazon Redshift cluster. </p>
    pub fn database_url(&self) -> std::option::Option<&str> {
        self.database_url.as_deref()
    }
    /// <p> A name for the associated Amazon S3 bucket. </p>
    pub fn bucket_name(&self) -> std::option::Option<&str> {
        self.bucket_name.as_deref()
    }
    /// <p> The object key for the destination bucket in which Amazon AppFlow places the files. </p>
    pub fn bucket_prefix(&self) -> std::option::Option<&str> {
        self.bucket_prefix.as_deref()
    }
    /// <p> The Amazon Resource Name (ARN) of the IAM role. </p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
}
impl std::fmt::Debug for RedshiftConnectorProfileProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RedshiftConnectorProfileProperties");
        formatter.field("database_url", &self.database_url);
        formatter.field("bucket_name", &self.bucket_name);
        formatter.field("bucket_prefix", &self.bucket_prefix);
        formatter.field("role_arn", &self.role_arn);
        formatter.finish()
    }
}
/// See [`RedshiftConnectorProfileProperties`](crate::model::RedshiftConnectorProfileProperties)
pub mod redshift_connector_profile_properties {
    /// A builder for [`RedshiftConnectorProfileProperties`](crate::model::RedshiftConnectorProfileProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) database_url: std::option::Option<std::string::String>,
        pub(crate) bucket_name: std::option::Option<std::string::String>,
        pub(crate) bucket_prefix: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The JDBC URL of the Amazon Redshift cluster. </p>
        pub fn database_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_url = Some(input.into());
            self
        }
        /// <p> The JDBC URL of the Amazon Redshift cluster. </p>
        pub fn set_database_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.database_url = input;
            self
        }
        /// <p> A name for the associated Amazon S3 bucket. </p>
        pub fn bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_name = Some(input.into());
            self
        }
        /// <p> A name for the associated Amazon S3 bucket. </p>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_name = input;
            self
        }
        /// <p> The object key for the destination bucket in which Amazon AppFlow places the files. </p>
        pub fn bucket_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_prefix = Some(input.into());
            self
        }
        /// <p> The object key for the destination bucket in which Amazon AppFlow places the files. </p>
        pub fn set_bucket_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.bucket_prefix = input;
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the IAM role. </p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the IAM role. </p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`RedshiftConnectorProfileProperties`](crate::model::RedshiftConnectorProfileProperties)
        pub fn build(self) -> crate::model::RedshiftConnectorProfileProperties {
            crate::model::RedshiftConnectorProfileProperties {
                database_url: self.database_url,
                bucket_name: self.bucket_name,
                bucket_prefix: self.bucket_prefix,
                role_arn: self.role_arn,
            }
        }
    }
}
impl RedshiftConnectorProfileProperties {
    /// Creates a new builder-style object to manufacture [`RedshiftConnectorProfileProperties`](crate::model::RedshiftConnectorProfileProperties)
    pub fn builder() -> crate::model::redshift_connector_profile_properties::Builder {
        crate::model::redshift_connector_profile_properties::Builder::default()
    }
}

/// <p> The connector-specific profile properties required when using Marketo. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MarketoConnectorProfileProperties {
    /// <p> The location of the Marketo resource. </p>
    pub instance_url: std::option::Option<std::string::String>,
}
impl MarketoConnectorProfileProperties {
    /// <p> The location of the Marketo resource. </p>
    pub fn instance_url(&self) -> std::option::Option<&str> {
        self.instance_url.as_deref()
    }
}
impl std::fmt::Debug for MarketoConnectorProfileProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MarketoConnectorProfileProperties");
        formatter.field("instance_url", &self.instance_url);
        formatter.finish()
    }
}
/// See [`MarketoConnectorProfileProperties`](crate::model::MarketoConnectorProfileProperties)
pub mod marketo_connector_profile_properties {
    /// A builder for [`MarketoConnectorProfileProperties`](crate::model::MarketoConnectorProfileProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The location of the Marketo resource. </p>
        pub fn instance_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_url = Some(input.into());
            self
        }
        /// <p> The location of the Marketo resource. </p>
        pub fn set_instance_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_url = input;
            self
        }
        /// Consumes the builder and constructs a [`MarketoConnectorProfileProperties`](crate::model::MarketoConnectorProfileProperties)
        pub fn build(self) -> crate::model::MarketoConnectorProfileProperties {
            crate::model::MarketoConnectorProfileProperties {
                instance_url: self.instance_url,
            }
        }
    }
}
impl MarketoConnectorProfileProperties {
    /// Creates a new builder-style object to manufacture [`MarketoConnectorProfileProperties`](crate::model::MarketoConnectorProfileProperties)
    pub fn builder() -> crate::model::marketo_connector_profile_properties::Builder {
        crate::model::marketo_connector_profile_properties::Builder::default()
    }
}

/// <p> The connector-specific profile properties required by Infor Nexus. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InforNexusConnectorProfileProperties {
    /// <p> The location of the Infor Nexus resource. </p>
    pub instance_url: std::option::Option<std::string::String>,
}
impl InforNexusConnectorProfileProperties {
    /// <p> The location of the Infor Nexus resource. </p>
    pub fn instance_url(&self) -> std::option::Option<&str> {
        self.instance_url.as_deref()
    }
}
impl std::fmt::Debug for InforNexusConnectorProfileProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InforNexusConnectorProfileProperties");
        formatter.field("instance_url", &self.instance_url);
        formatter.finish()
    }
}
/// See [`InforNexusConnectorProfileProperties`](crate::model::InforNexusConnectorProfileProperties)
pub mod infor_nexus_connector_profile_properties {
    /// A builder for [`InforNexusConnectorProfileProperties`](crate::model::InforNexusConnectorProfileProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The location of the Infor Nexus resource. </p>
        pub fn instance_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_url = Some(input.into());
            self
        }
        /// <p> The location of the Infor Nexus resource. </p>
        pub fn set_instance_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_url = input;
            self
        }
        /// Consumes the builder and constructs a [`InforNexusConnectorProfileProperties`](crate::model::InforNexusConnectorProfileProperties)
        pub fn build(self) -> crate::model::InforNexusConnectorProfileProperties {
            crate::model::InforNexusConnectorProfileProperties {
                instance_url: self.instance_url,
            }
        }
    }
}
impl InforNexusConnectorProfileProperties {
    /// Creates a new builder-style object to manufacture [`InforNexusConnectorProfileProperties`](crate::model::InforNexusConnectorProfileProperties)
    pub fn builder() -> crate::model::infor_nexus_connector_profile_properties::Builder {
        crate::model::infor_nexus_connector_profile_properties::Builder::default()
    }
}

/// <p> The connector-specific properties required when using Amazon Honeycode. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HoneycodeConnectorProfileProperties {}
impl std::fmt::Debug for HoneycodeConnectorProfileProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HoneycodeConnectorProfileProperties");
        formatter.finish()
    }
}
/// See [`HoneycodeConnectorProfileProperties`](crate::model::HoneycodeConnectorProfileProperties)
pub mod honeycode_connector_profile_properties {
    /// A builder for [`HoneycodeConnectorProfileProperties`](crate::model::HoneycodeConnectorProfileProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`HoneycodeConnectorProfileProperties`](crate::model::HoneycodeConnectorProfileProperties)
        pub fn build(self) -> crate::model::HoneycodeConnectorProfileProperties {
            crate::model::HoneycodeConnectorProfileProperties {}
        }
    }
}
impl HoneycodeConnectorProfileProperties {
    /// Creates a new builder-style object to manufacture [`HoneycodeConnectorProfileProperties`](crate::model::HoneycodeConnectorProfileProperties)
    pub fn builder() -> crate::model::honeycode_connector_profile_properties::Builder {
        crate::model::honeycode_connector_profile_properties::Builder::default()
    }
}

/// <p> The connector-specific profile properties required by Google Analytics. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GoogleAnalyticsConnectorProfileProperties {}
impl std::fmt::Debug for GoogleAnalyticsConnectorProfileProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GoogleAnalyticsConnectorProfileProperties");
        formatter.finish()
    }
}
/// See [`GoogleAnalyticsConnectorProfileProperties`](crate::model::GoogleAnalyticsConnectorProfileProperties)
pub mod google_analytics_connector_profile_properties {
    /// A builder for [`GoogleAnalyticsConnectorProfileProperties`](crate::model::GoogleAnalyticsConnectorProfileProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`GoogleAnalyticsConnectorProfileProperties`](crate::model::GoogleAnalyticsConnectorProfileProperties)
        pub fn build(self) -> crate::model::GoogleAnalyticsConnectorProfileProperties {
            crate::model::GoogleAnalyticsConnectorProfileProperties {}
        }
    }
}
impl GoogleAnalyticsConnectorProfileProperties {
    /// Creates a new builder-style object to manufacture [`GoogleAnalyticsConnectorProfileProperties`](crate::model::GoogleAnalyticsConnectorProfileProperties)
    pub fn builder() -> crate::model::google_analytics_connector_profile_properties::Builder {
        crate::model::google_analytics_connector_profile_properties::Builder::default()
    }
}

/// <p> The connector-specific profile properties required by Dynatrace. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DynatraceConnectorProfileProperties {
    /// <p> The location of the Dynatrace resource. </p>
    pub instance_url: std::option::Option<std::string::String>,
}
impl DynatraceConnectorProfileProperties {
    /// <p> The location of the Dynatrace resource. </p>
    pub fn instance_url(&self) -> std::option::Option<&str> {
        self.instance_url.as_deref()
    }
}
impl std::fmt::Debug for DynatraceConnectorProfileProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DynatraceConnectorProfileProperties");
        formatter.field("instance_url", &self.instance_url);
        formatter.finish()
    }
}
/// See [`DynatraceConnectorProfileProperties`](crate::model::DynatraceConnectorProfileProperties)
pub mod dynatrace_connector_profile_properties {
    /// A builder for [`DynatraceConnectorProfileProperties`](crate::model::DynatraceConnectorProfileProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The location of the Dynatrace resource. </p>
        pub fn instance_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_url = Some(input.into());
            self
        }
        /// <p> The location of the Dynatrace resource. </p>
        pub fn set_instance_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_url = input;
            self
        }
        /// Consumes the builder and constructs a [`DynatraceConnectorProfileProperties`](crate::model::DynatraceConnectorProfileProperties)
        pub fn build(self) -> crate::model::DynatraceConnectorProfileProperties {
            crate::model::DynatraceConnectorProfileProperties {
                instance_url: self.instance_url,
            }
        }
    }
}
impl DynatraceConnectorProfileProperties {
    /// Creates a new builder-style object to manufacture [`DynatraceConnectorProfileProperties`](crate::model::DynatraceConnectorProfileProperties)
    pub fn builder() -> crate::model::dynatrace_connector_profile_properties::Builder {
        crate::model::dynatrace_connector_profile_properties::Builder::default()
    }
}

/// <p> The connector-specific profile properties required by Datadog. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DatadogConnectorProfileProperties {
    /// <p> The location of the Datadog resource. </p>
    pub instance_url: std::option::Option<std::string::String>,
}
impl DatadogConnectorProfileProperties {
    /// <p> The location of the Datadog resource. </p>
    pub fn instance_url(&self) -> std::option::Option<&str> {
        self.instance_url.as_deref()
    }
}
impl std::fmt::Debug for DatadogConnectorProfileProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DatadogConnectorProfileProperties");
        formatter.field("instance_url", &self.instance_url);
        formatter.finish()
    }
}
/// See [`DatadogConnectorProfileProperties`](crate::model::DatadogConnectorProfileProperties)
pub mod datadog_connector_profile_properties {
    /// A builder for [`DatadogConnectorProfileProperties`](crate::model::DatadogConnectorProfileProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The location of the Datadog resource. </p>
        pub fn instance_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_url = Some(input.into());
            self
        }
        /// <p> The location of the Datadog resource. </p>
        pub fn set_instance_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_url = input;
            self
        }
        /// Consumes the builder and constructs a [`DatadogConnectorProfileProperties`](crate::model::DatadogConnectorProfileProperties)
        pub fn build(self) -> crate::model::DatadogConnectorProfileProperties {
            crate::model::DatadogConnectorProfileProperties {
                instance_url: self.instance_url,
            }
        }
    }
}
impl DatadogConnectorProfileProperties {
    /// Creates a new builder-style object to manufacture [`DatadogConnectorProfileProperties`](crate::model::DatadogConnectorProfileProperties)
    pub fn builder() -> crate::model::datadog_connector_profile_properties::Builder {
        crate::model::datadog_connector_profile_properties::Builder::default()
    }
}

/// <p> The connector-specific profile properties required when using Amplitude. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AmplitudeConnectorProfileProperties {}
impl std::fmt::Debug for AmplitudeConnectorProfileProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AmplitudeConnectorProfileProperties");
        formatter.finish()
    }
}
/// See [`AmplitudeConnectorProfileProperties`](crate::model::AmplitudeConnectorProfileProperties)
pub mod amplitude_connector_profile_properties {
    /// A builder for [`AmplitudeConnectorProfileProperties`](crate::model::AmplitudeConnectorProfileProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AmplitudeConnectorProfileProperties`](crate::model::AmplitudeConnectorProfileProperties)
        pub fn build(self) -> crate::model::AmplitudeConnectorProfileProperties {
            crate::model::AmplitudeConnectorProfileProperties {}
        }
    }
}
impl AmplitudeConnectorProfileProperties {
    /// Creates a new builder-style object to manufacture [`AmplitudeConnectorProfileProperties`](crate::model::AmplitudeConnectorProfileProperties)
    pub fn builder() -> crate::model::amplitude_connector_profile_properties::Builder {
        crate::model::amplitude_connector_profile_properties::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConnectionMode {
    #[allow(missing_docs)] // documentation missing in model
    Private,
    #[allow(missing_docs)] // documentation missing in model
    Public,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConnectionMode {
    fn from(s: &str) -> Self {
        match s {
            "Private" => ConnectionMode::Private,
            "Public" => ConnectionMode::Public,
            other => ConnectionMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConnectionMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConnectionMode::from(s))
    }
}
impl ConnectionMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConnectionMode::Private => "Private",
            ConnectionMode::Public => "Public",
            ConnectionMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Private", "Public"]
    }
}
impl AsRef<str> for ConnectionMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about the configuration of the connector being registered.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConnectorProvisioningConfig {
    /// <p>Contains information about the configuration of the lambda which is being registered as the connector.</p>
    pub lambda: std::option::Option<crate::model::LambdaConnectorProvisioningConfig>,
}
impl ConnectorProvisioningConfig {
    /// <p>Contains information about the configuration of the lambda which is being registered as the connector.</p>
    pub fn lambda(&self) -> std::option::Option<&crate::model::LambdaConnectorProvisioningConfig> {
        self.lambda.as_ref()
    }
}
impl std::fmt::Debug for ConnectorProvisioningConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConnectorProvisioningConfig");
        formatter.field("lambda", &self.lambda);
        formatter.finish()
    }
}
/// See [`ConnectorProvisioningConfig`](crate::model::ConnectorProvisioningConfig)
pub mod connector_provisioning_config {
    /// A builder for [`ConnectorProvisioningConfig`](crate::model::ConnectorProvisioningConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) lambda: std::option::Option<crate::model::LambdaConnectorProvisioningConfig>,
    }
    impl Builder {
        /// <p>Contains information about the configuration of the lambda which is being registered as the connector.</p>
        pub fn lambda(mut self, input: crate::model::LambdaConnectorProvisioningConfig) -> Self {
            self.lambda = Some(input);
            self
        }
        /// <p>Contains information about the configuration of the lambda which is being registered as the connector.</p>
        pub fn set_lambda(
            mut self,
            input: std::option::Option<crate::model::LambdaConnectorProvisioningConfig>,
        ) -> Self {
            self.lambda = input;
            self
        }
        /// Consumes the builder and constructs a [`ConnectorProvisioningConfig`](crate::model::ConnectorProvisioningConfig)
        pub fn build(self) -> crate::model::ConnectorProvisioningConfig {
            crate::model::ConnectorProvisioningConfig {
                lambda: self.lambda,
            }
        }
    }
}
impl ConnectorProvisioningConfig {
    /// Creates a new builder-style object to manufacture [`ConnectorProvisioningConfig`](crate::model::ConnectorProvisioningConfig)
    pub fn builder() -> crate::model::connector_provisioning_config::Builder {
        crate::model::connector_provisioning_config::Builder::default()
    }
}

/// <p>Contains information about the configuration of the lambda which is being registered as the connector.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LambdaConnectorProvisioningConfig {
    /// <p>Lambda ARN of the connector being registered.</p>
    pub lambda_arn: std::option::Option<std::string::String>,
}
impl LambdaConnectorProvisioningConfig {
    /// <p>Lambda ARN of the connector being registered.</p>
    pub fn lambda_arn(&self) -> std::option::Option<&str> {
        self.lambda_arn.as_deref()
    }
}
impl std::fmt::Debug for LambdaConnectorProvisioningConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LambdaConnectorProvisioningConfig");
        formatter.field("lambda_arn", &self.lambda_arn);
        formatter.finish()
    }
}
/// See [`LambdaConnectorProvisioningConfig`](crate::model::LambdaConnectorProvisioningConfig)
pub mod lambda_connector_provisioning_config {
    /// A builder for [`LambdaConnectorProvisioningConfig`](crate::model::LambdaConnectorProvisioningConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) lambda_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Lambda ARN of the connector being registered.</p>
        pub fn lambda_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.lambda_arn = Some(input.into());
            self
        }
        /// <p>Lambda ARN of the connector being registered.</p>
        pub fn set_lambda_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lambda_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`LambdaConnectorProvisioningConfig`](crate::model::LambdaConnectorProvisioningConfig)
        pub fn build(self) -> crate::model::LambdaConnectorProvisioningConfig {
            crate::model::LambdaConnectorProvisioningConfig {
                lambda_arn: self.lambda_arn,
            }
        }
    }
}
impl LambdaConnectorProvisioningConfig {
    /// Creates a new builder-style object to manufacture [`LambdaConnectorProvisioningConfig`](crate::model::LambdaConnectorProvisioningConfig)
    pub fn builder() -> crate::model::lambda_connector_provisioning_config::Builder {
        crate::model::lambda_connector_provisioning_config::Builder::default()
    }
}

/// <p>The type of provisioning that the connector supports, such as Lambda.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConnectorProvisioningType {
    #[allow(missing_docs)] // documentation missing in model
    Lambda,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConnectorProvisioningType {
    fn from(s: &str) -> Self {
        match s {
            "LAMBDA" => ConnectorProvisioningType::Lambda,
            other => ConnectorProvisioningType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConnectorProvisioningType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConnectorProvisioningType::from(s))
    }
}
impl ConnectorProvisioningType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConnectorProvisioningType::Lambda => "LAMBDA",
            ConnectorProvisioningType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["LAMBDA"]
    }
}
impl AsRef<str> for ConnectorProvisioningType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> The properties of the flow, such as its source, destination, trigger type, and so on. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FlowDefinition {
    /// <p> The flow's Amazon Resource Name (ARN). </p>
    pub flow_arn: std::option::Option<std::string::String>,
    /// <p> A user-entered description of the flow. </p>
    pub description: std::option::Option<std::string::String>,
    /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only. </p>
    pub flow_name: std::option::Option<std::string::String>,
    /// <p> Indicates the current status of the flow. </p>
    pub flow_status: std::option::Option<crate::model::FlowStatus>,
    /// <p> Specifies the source connector type, such as Salesforce, Amazon S3, Amplitude, and so on. </p>
    pub source_connector_type: std::option::Option<crate::model::ConnectorType>,
    /// <p>The label of the source connector in the flow.</p>
    pub source_connector_label: std::option::Option<std::string::String>,
    /// <p> Specifies the destination connector type, such as Salesforce, Amazon S3, Amplitude, and so on. </p>
    pub destination_connector_type: std::option::Option<crate::model::ConnectorType>,
    /// <p>The label of the destination connector in the flow.</p>
    pub destination_connector_label: std::option::Option<std::string::String>,
    /// <p> Specifies the type of flow trigger. This can be <code>OnDemand</code>, <code>Scheduled</code>, or <code>Event</code>. </p>
    pub trigger_type: std::option::Option<crate::model::TriggerType>,
    /// <p> Specifies when the flow was created. </p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> Specifies when the flow was last updated. </p>
    pub last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> The ARN of the user who created the flow. </p>
    pub created_by: std::option::Option<std::string::String>,
    /// <p> Specifies the account user name that most recently updated the flow. </p>
    pub last_updated_by: std::option::Option<std::string::String>,
    /// <p> The tags used to organize, track, or control access for your flow. </p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p> Describes the details of the most recent flow run. </p>
    pub last_run_execution_details: std::option::Option<crate::model::ExecutionDetails>,
}
impl FlowDefinition {
    /// <p> The flow's Amazon Resource Name (ARN). </p>
    pub fn flow_arn(&self) -> std::option::Option<&str> {
        self.flow_arn.as_deref()
    }
    /// <p> A user-entered description of the flow. </p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only. </p>
    pub fn flow_name(&self) -> std::option::Option<&str> {
        self.flow_name.as_deref()
    }
    /// <p> Indicates the current status of the flow. </p>
    pub fn flow_status(&self) -> std::option::Option<&crate::model::FlowStatus> {
        self.flow_status.as_ref()
    }
    /// <p> Specifies the source connector type, such as Salesforce, Amazon S3, Amplitude, and so on. </p>
    pub fn source_connector_type(&self) -> std::option::Option<&crate::model::ConnectorType> {
        self.source_connector_type.as_ref()
    }
    /// <p>The label of the source connector in the flow.</p>
    pub fn source_connector_label(&self) -> std::option::Option<&str> {
        self.source_connector_label.as_deref()
    }
    /// <p> Specifies the destination connector type, such as Salesforce, Amazon S3, Amplitude, and so on. </p>
    pub fn destination_connector_type(&self) -> std::option::Option<&crate::model::ConnectorType> {
        self.destination_connector_type.as_ref()
    }
    /// <p>The label of the destination connector in the flow.</p>
    pub fn destination_connector_label(&self) -> std::option::Option<&str> {
        self.destination_connector_label.as_deref()
    }
    /// <p> Specifies the type of flow trigger. This can be <code>OnDemand</code>, <code>Scheduled</code>, or <code>Event</code>. </p>
    pub fn trigger_type(&self) -> std::option::Option<&crate::model::TriggerType> {
        self.trigger_type.as_ref()
    }
    /// <p> Specifies when the flow was created. </p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p> Specifies when the flow was last updated. </p>
    pub fn last_updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_at.as_ref()
    }
    /// <p> The ARN of the user who created the flow. </p>
    pub fn created_by(&self) -> std::option::Option<&str> {
        self.created_by.as_deref()
    }
    /// <p> Specifies the account user name that most recently updated the flow. </p>
    pub fn last_updated_by(&self) -> std::option::Option<&str> {
        self.last_updated_by.as_deref()
    }
    /// <p> The tags used to organize, track, or control access for your flow. </p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p> Describes the details of the most recent flow run. </p>
    pub fn last_run_execution_details(
        &self,
    ) -> std::option::Option<&crate::model::ExecutionDetails> {
        self.last_run_execution_details.as_ref()
    }
}
impl std::fmt::Debug for FlowDefinition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FlowDefinition");
        formatter.field("flow_arn", &self.flow_arn);
        formatter.field("description", &self.description);
        formatter.field("flow_name", &self.flow_name);
        formatter.field("flow_status", &self.flow_status);
        formatter.field("source_connector_type", &self.source_connector_type);
        formatter.field("source_connector_label", &self.source_connector_label);
        formatter.field(
            "destination_connector_type",
            &self.destination_connector_type,
        );
        formatter.field(
            "destination_connector_label",
            &self.destination_connector_label,
        );
        formatter.field("trigger_type", &self.trigger_type);
        formatter.field("created_at", &self.created_at);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.field("created_by", &self.created_by);
        formatter.field("last_updated_by", &self.last_updated_by);
        formatter.field("tags", &self.tags);
        formatter.field(
            "last_run_execution_details",
            &self.last_run_execution_details,
        );
        formatter.finish()
    }
}
/// See [`FlowDefinition`](crate::model::FlowDefinition)
pub mod flow_definition {
    /// A builder for [`FlowDefinition`](crate::model::FlowDefinition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) flow_arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) flow_name: std::option::Option<std::string::String>,
        pub(crate) flow_status: std::option::Option<crate::model::FlowStatus>,
        pub(crate) source_connector_type: std::option::Option<crate::model::ConnectorType>,
        pub(crate) source_connector_label: std::option::Option<std::string::String>,
        pub(crate) destination_connector_type: std::option::Option<crate::model::ConnectorType>,
        pub(crate) destination_connector_label: std::option::Option<std::string::String>,
        pub(crate) trigger_type: std::option::Option<crate::model::TriggerType>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) created_by: std::option::Option<std::string::String>,
        pub(crate) last_updated_by: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) last_run_execution_details: std::option::Option<crate::model::ExecutionDetails>,
    }
    impl Builder {
        /// <p> The flow's Amazon Resource Name (ARN). </p>
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_arn = Some(input.into());
            self
        }
        /// <p> The flow's Amazon Resource Name (ARN). </p>
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.flow_arn = input;
            self
        }
        /// <p> A user-entered description of the flow. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p> A user-entered description of the flow. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only. </p>
        pub fn flow_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_name = Some(input.into());
            self
        }
        /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only. </p>
        pub fn set_flow_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.flow_name = input;
            self
        }
        /// <p> Indicates the current status of the flow. </p>
        pub fn flow_status(mut self, input: crate::model::FlowStatus) -> Self {
            self.flow_status = Some(input);
            self
        }
        /// <p> Indicates the current status of the flow. </p>
        pub fn set_flow_status(
            mut self,
            input: std::option::Option<crate::model::FlowStatus>,
        ) -> Self {
            self.flow_status = input;
            self
        }
        /// <p> Specifies the source connector type, such as Salesforce, Amazon S3, Amplitude, and so on. </p>
        pub fn source_connector_type(mut self, input: crate::model::ConnectorType) -> Self {
            self.source_connector_type = Some(input);
            self
        }
        /// <p> Specifies the source connector type, such as Salesforce, Amazon S3, Amplitude, and so on. </p>
        pub fn set_source_connector_type(
            mut self,
            input: std::option::Option<crate::model::ConnectorType>,
        ) -> Self {
            self.source_connector_type = input;
            self
        }
        /// <p>The label of the source connector in the flow.</p>
        pub fn source_connector_label(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_connector_label = Some(input.into());
            self
        }
        /// <p>The label of the source connector in the flow.</p>
        pub fn set_source_connector_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_connector_label = input;
            self
        }
        /// <p> Specifies the destination connector type, such as Salesforce, Amazon S3, Amplitude, and so on. </p>
        pub fn destination_connector_type(mut self, input: crate::model::ConnectorType) -> Self {
            self.destination_connector_type = Some(input);
            self
        }
        /// <p> Specifies the destination connector type, such as Salesforce, Amazon S3, Amplitude, and so on. </p>
        pub fn set_destination_connector_type(
            mut self,
            input: std::option::Option<crate::model::ConnectorType>,
        ) -> Self {
            self.destination_connector_type = input;
            self
        }
        /// <p>The label of the destination connector in the flow.</p>
        pub fn destination_connector_label(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.destination_connector_label = Some(input.into());
            self
        }
        /// <p>The label of the destination connector in the flow.</p>
        pub fn set_destination_connector_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_connector_label = input;
            self
        }
        /// <p> Specifies the type of flow trigger. This can be <code>OnDemand</code>, <code>Scheduled</code>, or <code>Event</code>. </p>
        pub fn trigger_type(mut self, input: crate::model::TriggerType) -> Self {
            self.trigger_type = Some(input);
            self
        }
        /// <p> Specifies the type of flow trigger. This can be <code>OnDemand</code>, <code>Scheduled</code>, or <code>Event</code>. </p>
        pub fn set_trigger_type(
            mut self,
            input: std::option::Option<crate::model::TriggerType>,
        ) -> Self {
            self.trigger_type = input;
            self
        }
        /// <p> Specifies when the flow was created. </p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p> Specifies when the flow was created. </p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p> Specifies when the flow was last updated. </p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p> Specifies when the flow was last updated. </p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// <p> The ARN of the user who created the flow. </p>
        pub fn created_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_by = Some(input.into());
            self
        }
        /// <p> The ARN of the user who created the flow. </p>
        pub fn set_created_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_by = input;
            self
        }
        /// <p> Specifies the account user name that most recently updated the flow. </p>
        pub fn last_updated_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_updated_by = Some(input.into());
            self
        }
        /// <p> Specifies the account user name that most recently updated the flow. </p>
        pub fn set_last_updated_by(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_updated_by = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> The tags used to organize, track, or control access for your flow. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p> The tags used to organize, track, or control access for your flow. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p> Describes the details of the most recent flow run. </p>
        pub fn last_run_execution_details(mut self, input: crate::model::ExecutionDetails) -> Self {
            self.last_run_execution_details = Some(input);
            self
        }
        /// <p> Describes the details of the most recent flow run. </p>
        pub fn set_last_run_execution_details(
            mut self,
            input: std::option::Option<crate::model::ExecutionDetails>,
        ) -> Self {
            self.last_run_execution_details = input;
            self
        }
        /// Consumes the builder and constructs a [`FlowDefinition`](crate::model::FlowDefinition)
        pub fn build(self) -> crate::model::FlowDefinition {
            crate::model::FlowDefinition {
                flow_arn: self.flow_arn,
                description: self.description,
                flow_name: self.flow_name,
                flow_status: self.flow_status,
                source_connector_type: self.source_connector_type,
                source_connector_label: self.source_connector_label,
                destination_connector_type: self.destination_connector_type,
                destination_connector_label: self.destination_connector_label,
                trigger_type: self.trigger_type,
                created_at: self.created_at,
                last_updated_at: self.last_updated_at,
                created_by: self.created_by,
                last_updated_by: self.last_updated_by,
                tags: self.tags,
                last_run_execution_details: self.last_run_execution_details,
            }
        }
    }
}
impl FlowDefinition {
    /// Creates a new builder-style object to manufacture [`FlowDefinition`](crate::model::FlowDefinition)
    pub fn builder() -> crate::model::flow_definition::Builder {
        crate::model::flow_definition::Builder::default()
    }
}

/// <p> Describes the details of the flow run, including the timestamp, status, and message. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExecutionDetails {
    /// <p> Describes the details of the most recent flow run. </p>
    pub most_recent_execution_message: std::option::Option<std::string::String>,
    /// <p> Specifies the time of the most recent flow run. </p>
    pub most_recent_execution_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> Specifies the status of the most recent flow run. </p>
    pub most_recent_execution_status: std::option::Option<crate::model::ExecutionStatus>,
}
impl ExecutionDetails {
    /// <p> Describes the details of the most recent flow run. </p>
    pub fn most_recent_execution_message(&self) -> std::option::Option<&str> {
        self.most_recent_execution_message.as_deref()
    }
    /// <p> Specifies the time of the most recent flow run. </p>
    pub fn most_recent_execution_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.most_recent_execution_time.as_ref()
    }
    /// <p> Specifies the status of the most recent flow run. </p>
    pub fn most_recent_execution_status(
        &self,
    ) -> std::option::Option<&crate::model::ExecutionStatus> {
        self.most_recent_execution_status.as_ref()
    }
}
impl std::fmt::Debug for ExecutionDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExecutionDetails");
        formatter.field(
            "most_recent_execution_message",
            &self.most_recent_execution_message,
        );
        formatter.field(
            "most_recent_execution_time",
            &self.most_recent_execution_time,
        );
        formatter.field(
            "most_recent_execution_status",
            &self.most_recent_execution_status,
        );
        formatter.finish()
    }
}
/// See [`ExecutionDetails`](crate::model::ExecutionDetails)
pub mod execution_details {
    /// A builder for [`ExecutionDetails`](crate::model::ExecutionDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) most_recent_execution_message: std::option::Option<std::string::String>,
        pub(crate) most_recent_execution_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) most_recent_execution_status: std::option::Option<crate::model::ExecutionStatus>,
    }
    impl Builder {
        /// <p> Describes the details of the most recent flow run. </p>
        pub fn most_recent_execution_message(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.most_recent_execution_message = Some(input.into());
            self
        }
        /// <p> Describes the details of the most recent flow run. </p>
        pub fn set_most_recent_execution_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.most_recent_execution_message = input;
            self
        }
        /// <p> Specifies the time of the most recent flow run. </p>
        pub fn most_recent_execution_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.most_recent_execution_time = Some(input);
            self
        }
        /// <p> Specifies the time of the most recent flow run. </p>
        pub fn set_most_recent_execution_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.most_recent_execution_time = input;
            self
        }
        /// <p> Specifies the status of the most recent flow run. </p>
        pub fn most_recent_execution_status(
            mut self,
            input: crate::model::ExecutionStatus,
        ) -> Self {
            self.most_recent_execution_status = Some(input);
            self
        }
        /// <p> Specifies the status of the most recent flow run. </p>
        pub fn set_most_recent_execution_status(
            mut self,
            input: std::option::Option<crate::model::ExecutionStatus>,
        ) -> Self {
            self.most_recent_execution_status = input;
            self
        }
        /// Consumes the builder and constructs a [`ExecutionDetails`](crate::model::ExecutionDetails)
        pub fn build(self) -> crate::model::ExecutionDetails {
            crate::model::ExecutionDetails {
                most_recent_execution_message: self.most_recent_execution_message,
                most_recent_execution_time: self.most_recent_execution_time,
                most_recent_execution_status: self.most_recent_execution_status,
            }
        }
    }
}
impl ExecutionDetails {
    /// Creates a new builder-style object to manufacture [`ExecutionDetails`](crate::model::ExecutionDetails)
    pub fn builder() -> crate::model::execution_details::Builder {
        crate::model::execution_details::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ExecutionStatus {
    #[allow(missing_docs)] // documentation missing in model
    Error,
    #[allow(missing_docs)] // documentation missing in model
    Inprogress,
    #[allow(missing_docs)] // documentation missing in model
    Successful,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ExecutionStatus {
    fn from(s: &str) -> Self {
        match s {
            "Error" => ExecutionStatus::Error,
            "InProgress" => ExecutionStatus::Inprogress,
            "Successful" => ExecutionStatus::Successful,
            other => ExecutionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ExecutionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ExecutionStatus::from(s))
    }
}
impl ExecutionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ExecutionStatus::Error => "Error",
            ExecutionStatus::Inprogress => "InProgress",
            ExecutionStatus::Successful => "Successful",
            ExecutionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Error", "InProgress", "Successful"]
    }
}
impl AsRef<str> for ExecutionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about the registered connector.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConnectorDetail {
    /// <p>A description about the registered connector.</p>
    pub connector_description: std::option::Option<std::string::String>,
    /// <p>The name of the connector.</p>
    pub connector_name: std::option::Option<std::string::String>,
    /// <p>The owner of the connector.</p>
    pub connector_owner: std::option::Option<std::string::String>,
    /// <p>The connector version.</p>
    pub connector_version: std::option::Option<std::string::String>,
    /// <p>The application type of the connector.</p>
    pub application_type: std::option::Option<std::string::String>,
    /// <p>The connector type.</p>
    pub connector_type: std::option::Option<crate::model::ConnectorType>,
    /// <p>A label used for the connector.</p>
    pub connector_label: std::option::Option<std::string::String>,
    /// <p>The time at which the connector was registered.</p>
    pub registered_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The user who registered the connector.</p>
    pub registered_by: std::option::Option<std::string::String>,
    /// <p>The provisioning type that the connector uses.</p>
    pub connector_provisioning_type: std::option::Option<crate::model::ConnectorProvisioningType>,
    /// <p>The connection mode that the connector supports.</p>
    pub connector_modes: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ConnectorDetail {
    /// <p>A description about the registered connector.</p>
    pub fn connector_description(&self) -> std::option::Option<&str> {
        self.connector_description.as_deref()
    }
    /// <p>The name of the connector.</p>
    pub fn connector_name(&self) -> std::option::Option<&str> {
        self.connector_name.as_deref()
    }
    /// <p>The owner of the connector.</p>
    pub fn connector_owner(&self) -> std::option::Option<&str> {
        self.connector_owner.as_deref()
    }
    /// <p>The connector version.</p>
    pub fn connector_version(&self) -> std::option::Option<&str> {
        self.connector_version.as_deref()
    }
    /// <p>The application type of the connector.</p>
    pub fn application_type(&self) -> std::option::Option<&str> {
        self.application_type.as_deref()
    }
    /// <p>The connector type.</p>
    pub fn connector_type(&self) -> std::option::Option<&crate::model::ConnectorType> {
        self.connector_type.as_ref()
    }
    /// <p>A label used for the connector.</p>
    pub fn connector_label(&self) -> std::option::Option<&str> {
        self.connector_label.as_deref()
    }
    /// <p>The time at which the connector was registered.</p>
    pub fn registered_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.registered_at.as_ref()
    }
    /// <p>The user who registered the connector.</p>
    pub fn registered_by(&self) -> std::option::Option<&str> {
        self.registered_by.as_deref()
    }
    /// <p>The provisioning type that the connector uses.</p>
    pub fn connector_provisioning_type(
        &self,
    ) -> std::option::Option<&crate::model::ConnectorProvisioningType> {
        self.connector_provisioning_type.as_ref()
    }
    /// <p>The connection mode that the connector supports.</p>
    pub fn connector_modes(&self) -> std::option::Option<&[std::string::String]> {
        self.connector_modes.as_deref()
    }
}
impl std::fmt::Debug for ConnectorDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConnectorDetail");
        formatter.field("connector_description", &self.connector_description);
        formatter.field("connector_name", &self.connector_name);
        formatter.field("connector_owner", &self.connector_owner);
        formatter.field("connector_version", &self.connector_version);
        formatter.field("application_type", &self.application_type);
        formatter.field("connector_type", &self.connector_type);
        formatter.field("connector_label", &self.connector_label);
        formatter.field("registered_at", &self.registered_at);
        formatter.field("registered_by", &self.registered_by);
        formatter.field(
            "connector_provisioning_type",
            &self.connector_provisioning_type,
        );
        formatter.field("connector_modes", &self.connector_modes);
        formatter.finish()
    }
}
/// See [`ConnectorDetail`](crate::model::ConnectorDetail)
pub mod connector_detail {
    /// A builder for [`ConnectorDetail`](crate::model::ConnectorDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connector_description: std::option::Option<std::string::String>,
        pub(crate) connector_name: std::option::Option<std::string::String>,
        pub(crate) connector_owner: std::option::Option<std::string::String>,
        pub(crate) connector_version: std::option::Option<std::string::String>,
        pub(crate) application_type: std::option::Option<std::string::String>,
        pub(crate) connector_type: std::option::Option<crate::model::ConnectorType>,
        pub(crate) connector_label: std::option::Option<std::string::String>,
        pub(crate) registered_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) registered_by: std::option::Option<std::string::String>,
        pub(crate) connector_provisioning_type:
            std::option::Option<crate::model::ConnectorProvisioningType>,
        pub(crate) connector_modes: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>A description about the registered connector.</p>
        pub fn connector_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.connector_description = Some(input.into());
            self
        }
        /// <p>A description about the registered connector.</p>
        pub fn set_connector_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connector_description = input;
            self
        }
        /// <p>The name of the connector.</p>
        pub fn connector_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.connector_name = Some(input.into());
            self
        }
        /// <p>The name of the connector.</p>
        pub fn set_connector_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connector_name = input;
            self
        }
        /// <p>The owner of the connector.</p>
        pub fn connector_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.connector_owner = Some(input.into());
            self
        }
        /// <p>The owner of the connector.</p>
        pub fn set_connector_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connector_owner = input;
            self
        }
        /// <p>The connector version.</p>
        pub fn connector_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.connector_version = Some(input.into());
            self
        }
        /// <p>The connector version.</p>
        pub fn set_connector_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connector_version = input;
            self
        }
        /// <p>The application type of the connector.</p>
        pub fn application_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_type = Some(input.into());
            self
        }
        /// <p>The application type of the connector.</p>
        pub fn set_application_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_type = input;
            self
        }
        /// <p>The connector type.</p>
        pub fn connector_type(mut self, input: crate::model::ConnectorType) -> Self {
            self.connector_type = Some(input);
            self
        }
        /// <p>The connector type.</p>
        pub fn set_connector_type(
            mut self,
            input: std::option::Option<crate::model::ConnectorType>,
        ) -> Self {
            self.connector_type = input;
            self
        }
        /// <p>A label used for the connector.</p>
        pub fn connector_label(mut self, input: impl Into<std::string::String>) -> Self {
            self.connector_label = Some(input.into());
            self
        }
        /// <p>A label used for the connector.</p>
        pub fn set_connector_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connector_label = input;
            self
        }
        /// <p>The time at which the connector was registered.</p>
        pub fn registered_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.registered_at = Some(input);
            self
        }
        /// <p>The time at which the connector was registered.</p>
        pub fn set_registered_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.registered_at = input;
            self
        }
        /// <p>The user who registered the connector.</p>
        pub fn registered_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.registered_by = Some(input.into());
            self
        }
        /// <p>The user who registered the connector.</p>
        pub fn set_registered_by(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.registered_by = input;
            self
        }
        /// <p>The provisioning type that the connector uses.</p>
        pub fn connector_provisioning_type(
            mut self,
            input: crate::model::ConnectorProvisioningType,
        ) -> Self {
            self.connector_provisioning_type = Some(input);
            self
        }
        /// <p>The provisioning type that the connector uses.</p>
        pub fn set_connector_provisioning_type(
            mut self,
            input: std::option::Option<crate::model::ConnectorProvisioningType>,
        ) -> Self {
            self.connector_provisioning_type = input;
            self
        }
        /// Appends an item to `connector_modes`.
        ///
        /// To override the contents of this collection use [`set_connector_modes`](Self::set_connector_modes).
        ///
        /// <p>The connection mode that the connector supports.</p>
        pub fn connector_modes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.connector_modes.unwrap_or_default();
            v.push(input.into());
            self.connector_modes = Some(v);
            self
        }
        /// <p>The connection mode that the connector supports.</p>
        pub fn set_connector_modes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.connector_modes = input;
            self
        }
        /// Consumes the builder and constructs a [`ConnectorDetail`](crate::model::ConnectorDetail)
        pub fn build(self) -> crate::model::ConnectorDetail {
            crate::model::ConnectorDetail {
                connector_description: self.connector_description,
                connector_name: self.connector_name,
                connector_owner: self.connector_owner,
                connector_version: self.connector_version,
                application_type: self.application_type,
                connector_type: self.connector_type,
                connector_label: self.connector_label,
                registered_at: self.registered_at,
                registered_by: self.registered_by,
                connector_provisioning_type: self.connector_provisioning_type,
                connector_modes: self.connector_modes,
            }
        }
    }
}
impl ConnectorDetail {
    /// Creates a new builder-style object to manufacture [`ConnectorDetail`](crate::model::ConnectorDetail)
    pub fn builder() -> crate::model::connector_detail::Builder {
        crate::model::connector_detail::Builder::default()
    }
}

/// <p> The high-level entity that can be queried in Amazon AppFlow. For example, a Salesforce entity might be an <i>Account</i> or <i>Opportunity</i>, whereas a ServiceNow entity might be an <i>Incident</i>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConnectorEntity {
    /// <p> The name of the connector entity. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p> The label applied to the connector entity. </p>
    pub label: std::option::Option<std::string::String>,
    /// <p> Specifies whether the connector entity is a parent or a category and has more entities nested underneath it. If another call is made with <code>entitiesPath = "the_current_entity_name_with_hasNestedEntities_true"</code>, then it returns the nested entities underneath it. This provides a way to retrieve all supported entities in a recursive fashion. </p>
    pub has_nested_entities: bool,
}
impl ConnectorEntity {
    /// <p> The name of the connector entity. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p> The label applied to the connector entity. </p>
    pub fn label(&self) -> std::option::Option<&str> {
        self.label.as_deref()
    }
    /// <p> Specifies whether the connector entity is a parent or a category and has more entities nested underneath it. If another call is made with <code>entitiesPath = "the_current_entity_name_with_hasNestedEntities_true"</code>, then it returns the nested entities underneath it. This provides a way to retrieve all supported entities in a recursive fashion. </p>
    pub fn has_nested_entities(&self) -> bool {
        self.has_nested_entities
    }
}
impl std::fmt::Debug for ConnectorEntity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConnectorEntity");
        formatter.field("name", &self.name);
        formatter.field("label", &self.label);
        formatter.field("has_nested_entities", &self.has_nested_entities);
        formatter.finish()
    }
}
/// See [`ConnectorEntity`](crate::model::ConnectorEntity)
pub mod connector_entity {
    /// A builder for [`ConnectorEntity`](crate::model::ConnectorEntity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) label: std::option::Option<std::string::String>,
        pub(crate) has_nested_entities: std::option::Option<bool>,
    }
    impl Builder {
        /// <p> The name of the connector entity. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> The name of the connector entity. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p> The label applied to the connector entity. </p>
        pub fn label(mut self, input: impl Into<std::string::String>) -> Self {
            self.label = Some(input.into());
            self
        }
        /// <p> The label applied to the connector entity. </p>
        pub fn set_label(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.label = input;
            self
        }
        /// <p> Specifies whether the connector entity is a parent or a category and has more entities nested underneath it. If another call is made with <code>entitiesPath = "the_current_entity_name_with_hasNestedEntities_true"</code>, then it returns the nested entities underneath it. This provides a way to retrieve all supported entities in a recursive fashion. </p>
        pub fn has_nested_entities(mut self, input: bool) -> Self {
            self.has_nested_entities = Some(input);
            self
        }
        /// <p> Specifies whether the connector entity is a parent or a category and has more entities nested underneath it. If another call is made with <code>entitiesPath = "the_current_entity_name_with_hasNestedEntities_true"</code>, then it returns the nested entities underneath it. This provides a way to retrieve all supported entities in a recursive fashion. </p>
        pub fn set_has_nested_entities(mut self, input: std::option::Option<bool>) -> Self {
            self.has_nested_entities = input;
            self
        }
        /// Consumes the builder and constructs a [`ConnectorEntity`](crate::model::ConnectorEntity)
        pub fn build(self) -> crate::model::ConnectorEntity {
            crate::model::ConnectorEntity {
                name: self.name,
                label: self.label,
                has_nested_entities: self.has_nested_entities.unwrap_or_default(),
            }
        }
    }
}
impl ConnectorEntity {
    /// Creates a new builder-style object to manufacture [`ConnectorEntity`](crate::model::ConnectorEntity)
    pub fn builder() -> crate::model::connector_entity::Builder {
        crate::model::connector_entity::Builder::default()
    }
}

/// <p> Specifies information about the past flow run instances for a given flow. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExecutionRecord {
    /// <p> Specifies the identifier of the given flow run. </p>
    pub execution_id: std::option::Option<std::string::String>,
    /// <p> Specifies the flow run status and whether it is in progress, has completed successfully, or has failed. </p>
    pub execution_status: std::option::Option<crate::model::ExecutionStatus>,
    /// <p> Describes the result of the given flow run. </p>
    pub execution_result: std::option::Option<crate::model::ExecutionResult>,
    /// <p> Specifies the start time of the flow run. </p>
    pub started_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> Specifies the time of the most recent update. </p>
    pub last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> The timestamp that determines the first new or updated record to be transferred in the flow run. </p>
    pub data_pull_start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> The timestamp that indicates the last new or updated record to be transferred in the flow run. </p>
    pub data_pull_end_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl ExecutionRecord {
    /// <p> Specifies the identifier of the given flow run. </p>
    pub fn execution_id(&self) -> std::option::Option<&str> {
        self.execution_id.as_deref()
    }
    /// <p> Specifies the flow run status and whether it is in progress, has completed successfully, or has failed. </p>
    pub fn execution_status(&self) -> std::option::Option<&crate::model::ExecutionStatus> {
        self.execution_status.as_ref()
    }
    /// <p> Describes the result of the given flow run. </p>
    pub fn execution_result(&self) -> std::option::Option<&crate::model::ExecutionResult> {
        self.execution_result.as_ref()
    }
    /// <p> Specifies the start time of the flow run. </p>
    pub fn started_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.started_at.as_ref()
    }
    /// <p> Specifies the time of the most recent update. </p>
    pub fn last_updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_at.as_ref()
    }
    /// <p> The timestamp that determines the first new or updated record to be transferred in the flow run. </p>
    pub fn data_pull_start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.data_pull_start_time.as_ref()
    }
    /// <p> The timestamp that indicates the last new or updated record to be transferred in the flow run. </p>
    pub fn data_pull_end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.data_pull_end_time.as_ref()
    }
}
impl std::fmt::Debug for ExecutionRecord {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExecutionRecord");
        formatter.field("execution_id", &self.execution_id);
        formatter.field("execution_status", &self.execution_status);
        formatter.field("execution_result", &self.execution_result);
        formatter.field("started_at", &self.started_at);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.field("data_pull_start_time", &self.data_pull_start_time);
        formatter.field("data_pull_end_time", &self.data_pull_end_time);
        formatter.finish()
    }
}
/// See [`ExecutionRecord`](crate::model::ExecutionRecord)
pub mod execution_record {
    /// A builder for [`ExecutionRecord`](crate::model::ExecutionRecord)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) execution_id: std::option::Option<std::string::String>,
        pub(crate) execution_status: std::option::Option<crate::model::ExecutionStatus>,
        pub(crate) execution_result: std::option::Option<crate::model::ExecutionResult>,
        pub(crate) started_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) data_pull_start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) data_pull_end_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p> Specifies the identifier of the given flow run. </p>
        pub fn execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.execution_id = Some(input.into());
            self
        }
        /// <p> Specifies the identifier of the given flow run. </p>
        pub fn set_execution_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.execution_id = input;
            self
        }
        /// <p> Specifies the flow run status and whether it is in progress, has completed successfully, or has failed. </p>
        pub fn execution_status(mut self, input: crate::model::ExecutionStatus) -> Self {
            self.execution_status = Some(input);
            self
        }
        /// <p> Specifies the flow run status and whether it is in progress, has completed successfully, or has failed. </p>
        pub fn set_execution_status(
            mut self,
            input: std::option::Option<crate::model::ExecutionStatus>,
        ) -> Self {
            self.execution_status = input;
            self
        }
        /// <p> Describes the result of the given flow run. </p>
        pub fn execution_result(mut self, input: crate::model::ExecutionResult) -> Self {
            self.execution_result = Some(input);
            self
        }
        /// <p> Describes the result of the given flow run. </p>
        pub fn set_execution_result(
            mut self,
            input: std::option::Option<crate::model::ExecutionResult>,
        ) -> Self {
            self.execution_result = input;
            self
        }
        /// <p> Specifies the start time of the flow run. </p>
        pub fn started_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.started_at = Some(input);
            self
        }
        /// <p> Specifies the start time of the flow run. </p>
        pub fn set_started_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.started_at = input;
            self
        }
        /// <p> Specifies the time of the most recent update. </p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p> Specifies the time of the most recent update. </p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// <p> The timestamp that determines the first new or updated record to be transferred in the flow run. </p>
        pub fn data_pull_start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.data_pull_start_time = Some(input);
            self
        }
        /// <p> The timestamp that determines the first new or updated record to be transferred in the flow run. </p>
        pub fn set_data_pull_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.data_pull_start_time = input;
            self
        }
        /// <p> The timestamp that indicates the last new or updated record to be transferred in the flow run. </p>
        pub fn data_pull_end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.data_pull_end_time = Some(input);
            self
        }
        /// <p> The timestamp that indicates the last new or updated record to be transferred in the flow run. </p>
        pub fn set_data_pull_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.data_pull_end_time = input;
            self
        }
        /// Consumes the builder and constructs a [`ExecutionRecord`](crate::model::ExecutionRecord)
        pub fn build(self) -> crate::model::ExecutionRecord {
            crate::model::ExecutionRecord {
                execution_id: self.execution_id,
                execution_status: self.execution_status,
                execution_result: self.execution_result,
                started_at: self.started_at,
                last_updated_at: self.last_updated_at,
                data_pull_start_time: self.data_pull_start_time,
                data_pull_end_time: self.data_pull_end_time,
            }
        }
    }
}
impl ExecutionRecord {
    /// Creates a new builder-style object to manufacture [`ExecutionRecord`](crate::model::ExecutionRecord)
    pub fn builder() -> crate::model::execution_record::Builder {
        crate::model::execution_record::Builder::default()
    }
}

/// <p> Specifies the end result of the flow run. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExecutionResult {
    /// <p> Provides any error message information related to the flow run. </p>
    pub error_info: std::option::Option<crate::model::ErrorInfo>,
    /// <p> The total number of bytes processed by the flow run. </p>
    pub bytes_processed: std::option::Option<i64>,
    /// <p> The total number of bytes written as a result of the flow run. </p>
    pub bytes_written: std::option::Option<i64>,
    /// <p> The number of records processed in the flow run. </p>
    pub records_processed: std::option::Option<i64>,
}
impl ExecutionResult {
    /// <p> Provides any error message information related to the flow run. </p>
    pub fn error_info(&self) -> std::option::Option<&crate::model::ErrorInfo> {
        self.error_info.as_ref()
    }
    /// <p> The total number of bytes processed by the flow run. </p>
    pub fn bytes_processed(&self) -> std::option::Option<i64> {
        self.bytes_processed
    }
    /// <p> The total number of bytes written as a result of the flow run. </p>
    pub fn bytes_written(&self) -> std::option::Option<i64> {
        self.bytes_written
    }
    /// <p> The number of records processed in the flow run. </p>
    pub fn records_processed(&self) -> std::option::Option<i64> {
        self.records_processed
    }
}
impl std::fmt::Debug for ExecutionResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExecutionResult");
        formatter.field("error_info", &self.error_info);
        formatter.field("bytes_processed", &self.bytes_processed);
        formatter.field("bytes_written", &self.bytes_written);
        formatter.field("records_processed", &self.records_processed);
        formatter.finish()
    }
}
/// See [`ExecutionResult`](crate::model::ExecutionResult)
pub mod execution_result {
    /// A builder for [`ExecutionResult`](crate::model::ExecutionResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_info: std::option::Option<crate::model::ErrorInfo>,
        pub(crate) bytes_processed: std::option::Option<i64>,
        pub(crate) bytes_written: std::option::Option<i64>,
        pub(crate) records_processed: std::option::Option<i64>,
    }
    impl Builder {
        /// <p> Provides any error message information related to the flow run. </p>
        pub fn error_info(mut self, input: crate::model::ErrorInfo) -> Self {
            self.error_info = Some(input);
            self
        }
        /// <p> Provides any error message information related to the flow run. </p>
        pub fn set_error_info(
            mut self,
            input: std::option::Option<crate::model::ErrorInfo>,
        ) -> Self {
            self.error_info = input;
            self
        }
        /// <p> The total number of bytes processed by the flow run. </p>
        pub fn bytes_processed(mut self, input: i64) -> Self {
            self.bytes_processed = Some(input);
            self
        }
        /// <p> The total number of bytes processed by the flow run. </p>
        pub fn set_bytes_processed(mut self, input: std::option::Option<i64>) -> Self {
            self.bytes_processed = input;
            self
        }
        /// <p> The total number of bytes written as a result of the flow run. </p>
        pub fn bytes_written(mut self, input: i64) -> Self {
            self.bytes_written = Some(input);
            self
        }
        /// <p> The total number of bytes written as a result of the flow run. </p>
        pub fn set_bytes_written(mut self, input: std::option::Option<i64>) -> Self {
            self.bytes_written = input;
            self
        }
        /// <p> The number of records processed in the flow run. </p>
        pub fn records_processed(mut self, input: i64) -> Self {
            self.records_processed = Some(input);
            self
        }
        /// <p> The number of records processed in the flow run. </p>
        pub fn set_records_processed(mut self, input: std::option::Option<i64>) -> Self {
            self.records_processed = input;
            self
        }
        /// Consumes the builder and constructs a [`ExecutionResult`](crate::model::ExecutionResult)
        pub fn build(self) -> crate::model::ExecutionResult {
            crate::model::ExecutionResult {
                error_info: self.error_info,
                bytes_processed: self.bytes_processed,
                bytes_written: self.bytes_written,
                records_processed: self.records_processed,
            }
        }
    }
}
impl ExecutionResult {
    /// Creates a new builder-style object to manufacture [`ExecutionResult`](crate::model::ExecutionResult)
    pub fn builder() -> crate::model::execution_result::Builder {
        crate::model::execution_result::Builder::default()
    }
}

/// <p> Provides details in the event of a failed flow, including the failure count and the related error messages. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ErrorInfo {
    /// <p> Specifies the failure count for the attempted flow. </p>
    pub put_failures_count: std::option::Option<i64>,
    /// <p> Specifies the error message that appears if a flow fails. </p>
    pub execution_message: std::option::Option<std::string::String>,
}
impl ErrorInfo {
    /// <p> Specifies the failure count for the attempted flow. </p>
    pub fn put_failures_count(&self) -> std::option::Option<i64> {
        self.put_failures_count
    }
    /// <p> Specifies the error message that appears if a flow fails. </p>
    pub fn execution_message(&self) -> std::option::Option<&str> {
        self.execution_message.as_deref()
    }
}
impl std::fmt::Debug for ErrorInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ErrorInfo");
        formatter.field("put_failures_count", &self.put_failures_count);
        formatter.field("execution_message", &self.execution_message);
        formatter.finish()
    }
}
/// See [`ErrorInfo`](crate::model::ErrorInfo)
pub mod error_info {
    /// A builder for [`ErrorInfo`](crate::model::ErrorInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) put_failures_count: std::option::Option<i64>,
        pub(crate) execution_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> Specifies the failure count for the attempted flow. </p>
        pub fn put_failures_count(mut self, input: i64) -> Self {
            self.put_failures_count = Some(input);
            self
        }
        /// <p> Specifies the failure count for the attempted flow. </p>
        pub fn set_put_failures_count(mut self, input: std::option::Option<i64>) -> Self {
            self.put_failures_count = input;
            self
        }
        /// <p> Specifies the error message that appears if a flow fails. </p>
        pub fn execution_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.execution_message = Some(input.into());
            self
        }
        /// <p> Specifies the error message that appears if a flow fails. </p>
        pub fn set_execution_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.execution_message = input;
            self
        }
        /// Consumes the builder and constructs a [`ErrorInfo`](crate::model::ErrorInfo)
        pub fn build(self) -> crate::model::ErrorInfo {
            crate::model::ErrorInfo {
                put_failures_count: self.put_failures_count,
                execution_message: self.execution_message,
            }
        }
    }
}
impl ErrorInfo {
    /// Creates a new builder-style object to manufacture [`ErrorInfo`](crate::model::ErrorInfo)
    pub fn builder() -> crate::model::error_info::Builder {
        crate::model::error_info::Builder::default()
    }
}

/// <p> The configuration settings related to a given connector. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConnectorConfiguration {
    /// <p> Specifies whether the connector can be used as a source. </p>
    pub can_use_as_source: bool,
    /// <p> Specifies whether the connector can be used as a destination. </p>
    pub can_use_as_destination: bool,
    /// <p> Lists the connectors that are available for use as destinations. </p>
    pub supported_destination_connectors:
        std::option::Option<std::vec::Vec<crate::model::ConnectorType>>,
    /// <p> Specifies the supported flow frequency for that connector. </p>
    pub supported_scheduling_frequencies:
        std::option::Option<std::vec::Vec<crate::model::ScheduleFrequencyType>>,
    /// <p> Specifies if PrivateLink is enabled for that connector. </p>
    pub is_private_link_enabled: bool,
    /// <p> Specifies if a PrivateLink endpoint URL is required. </p>
    pub is_private_link_endpoint_url_required: bool,
    /// <p> Specifies the supported trigger types for the flow. </p>
    pub supported_trigger_types: std::option::Option<std::vec::Vec<crate::model::TriggerType>>,
    /// <p> Specifies connector-specific metadata such as <code>oAuthScopes</code>, <code>supportedRegions</code>, <code>privateLinkServiceUrl</code>, and so on. </p>
    pub connector_metadata: std::option::Option<crate::model::ConnectorMetadata>,
    /// <p>The connector type.</p>
    pub connector_type: std::option::Option<crate::model::ConnectorType>,
    /// <p>The label used for registering the connector.</p>
    pub connector_label: std::option::Option<std::string::String>,
    /// <p>A description about the connector.</p>
    pub connector_description: std::option::Option<std::string::String>,
    /// <p>The owner who developed the connector.</p>
    pub connector_owner: std::option::Option<std::string::String>,
    /// <p>The connector name.</p>
    pub connector_name: std::option::Option<std::string::String>,
    /// <p>The connector version.</p>
    pub connector_version: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the registered connector.</p>
    pub connector_arn: std::option::Option<std::string::String>,
    /// <p>The connection modes that the connector supports.</p>
    pub connector_modes: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The authentication config required for the connector.</p>
    pub authentication_config: std::option::Option<crate::model::AuthenticationConfig>,
    /// <p>The required connector runtime settings.</p>
    pub connector_runtime_settings:
        std::option::Option<std::vec::Vec<crate::model::ConnectorRuntimeSetting>>,
    /// <p>A list of API versions that are supported by the connector.</p>
    pub supported_api_versions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of operators supported by the connector.</p>
    pub supported_operators: std::option::Option<std::vec::Vec<crate::model::Operators>>,
    /// <p>A list of write operations supported by the connector.</p>
    pub supported_write_operations:
        std::option::Option<std::vec::Vec<crate::model::WriteOperationType>>,
    /// <p>The provisioning type used to register the connector.</p>
    pub connector_provisioning_type: std::option::Option<crate::model::ConnectorProvisioningType>,
    /// <p>The configuration required for registering the connector.</p>
    pub connector_provisioning_config:
        std::option::Option<crate::model::ConnectorProvisioningConfig>,
    /// <p>Logo URL of the connector.</p>
    pub logo_url: std::option::Option<std::string::String>,
    /// <p>The date on which the connector was registered.</p>
    pub registered_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Information about who registered the connector.</p>
    pub registered_by: std::option::Option<std::string::String>,
}
impl ConnectorConfiguration {
    /// <p> Specifies whether the connector can be used as a source. </p>
    pub fn can_use_as_source(&self) -> bool {
        self.can_use_as_source
    }
    /// <p> Specifies whether the connector can be used as a destination. </p>
    pub fn can_use_as_destination(&self) -> bool {
        self.can_use_as_destination
    }
    /// <p> Lists the connectors that are available for use as destinations. </p>
    pub fn supported_destination_connectors(
        &self,
    ) -> std::option::Option<&[crate::model::ConnectorType]> {
        self.supported_destination_connectors.as_deref()
    }
    /// <p> Specifies the supported flow frequency for that connector. </p>
    pub fn supported_scheduling_frequencies(
        &self,
    ) -> std::option::Option<&[crate::model::ScheduleFrequencyType]> {
        self.supported_scheduling_frequencies.as_deref()
    }
    /// <p> Specifies if PrivateLink is enabled for that connector. </p>
    pub fn is_private_link_enabled(&self) -> bool {
        self.is_private_link_enabled
    }
    /// <p> Specifies if a PrivateLink endpoint URL is required. </p>
    pub fn is_private_link_endpoint_url_required(&self) -> bool {
        self.is_private_link_endpoint_url_required
    }
    /// <p> Specifies the supported trigger types for the flow. </p>
    pub fn supported_trigger_types(&self) -> std::option::Option<&[crate::model::TriggerType]> {
        self.supported_trigger_types.as_deref()
    }
    /// <p> Specifies connector-specific metadata such as <code>oAuthScopes</code>, <code>supportedRegions</code>, <code>privateLinkServiceUrl</code>, and so on. </p>
    pub fn connector_metadata(&self) -> std::option::Option<&crate::model::ConnectorMetadata> {
        self.connector_metadata.as_ref()
    }
    /// <p>The connector type.</p>
    pub fn connector_type(&self) -> std::option::Option<&crate::model::ConnectorType> {
        self.connector_type.as_ref()
    }
    /// <p>The label used for registering the connector.</p>
    pub fn connector_label(&self) -> std::option::Option<&str> {
        self.connector_label.as_deref()
    }
    /// <p>A description about the connector.</p>
    pub fn connector_description(&self) -> std::option::Option<&str> {
        self.connector_description.as_deref()
    }
    /// <p>The owner who developed the connector.</p>
    pub fn connector_owner(&self) -> std::option::Option<&str> {
        self.connector_owner.as_deref()
    }
    /// <p>The connector name.</p>
    pub fn connector_name(&self) -> std::option::Option<&str> {
        self.connector_name.as_deref()
    }
    /// <p>The connector version.</p>
    pub fn connector_version(&self) -> std::option::Option<&str> {
        self.connector_version.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the registered connector.</p>
    pub fn connector_arn(&self) -> std::option::Option<&str> {
        self.connector_arn.as_deref()
    }
    /// <p>The connection modes that the connector supports.</p>
    pub fn connector_modes(&self) -> std::option::Option<&[std::string::String]> {
        self.connector_modes.as_deref()
    }
    /// <p>The authentication config required for the connector.</p>
    pub fn authentication_config(
        &self,
    ) -> std::option::Option<&crate::model::AuthenticationConfig> {
        self.authentication_config.as_ref()
    }
    /// <p>The required connector runtime settings.</p>
    pub fn connector_runtime_settings(
        &self,
    ) -> std::option::Option<&[crate::model::ConnectorRuntimeSetting]> {
        self.connector_runtime_settings.as_deref()
    }
    /// <p>A list of API versions that are supported by the connector.</p>
    pub fn supported_api_versions(&self) -> std::option::Option<&[std::string::String]> {
        self.supported_api_versions.as_deref()
    }
    /// <p>A list of operators supported by the connector.</p>
    pub fn supported_operators(&self) -> std::option::Option<&[crate::model::Operators]> {
        self.supported_operators.as_deref()
    }
    /// <p>A list of write operations supported by the connector.</p>
    pub fn supported_write_operations(
        &self,
    ) -> std::option::Option<&[crate::model::WriteOperationType]> {
        self.supported_write_operations.as_deref()
    }
    /// <p>The provisioning type used to register the connector.</p>
    pub fn connector_provisioning_type(
        &self,
    ) -> std::option::Option<&crate::model::ConnectorProvisioningType> {
        self.connector_provisioning_type.as_ref()
    }
    /// <p>The configuration required for registering the connector.</p>
    pub fn connector_provisioning_config(
        &self,
    ) -> std::option::Option<&crate::model::ConnectorProvisioningConfig> {
        self.connector_provisioning_config.as_ref()
    }
    /// <p>Logo URL of the connector.</p>
    pub fn logo_url(&self) -> std::option::Option<&str> {
        self.logo_url.as_deref()
    }
    /// <p>The date on which the connector was registered.</p>
    pub fn registered_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.registered_at.as_ref()
    }
    /// <p>Information about who registered the connector.</p>
    pub fn registered_by(&self) -> std::option::Option<&str> {
        self.registered_by.as_deref()
    }
}
impl std::fmt::Debug for ConnectorConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConnectorConfiguration");
        formatter.field("can_use_as_source", &self.can_use_as_source);
        formatter.field("can_use_as_destination", &self.can_use_as_destination);
        formatter.field(
            "supported_destination_connectors",
            &self.supported_destination_connectors,
        );
        formatter.field(
            "supported_scheduling_frequencies",
            &self.supported_scheduling_frequencies,
        );
        formatter.field("is_private_link_enabled", &self.is_private_link_enabled);
        formatter.field(
            "is_private_link_endpoint_url_required",
            &self.is_private_link_endpoint_url_required,
        );
        formatter.field("supported_trigger_types", &self.supported_trigger_types);
        formatter.field("connector_metadata", &self.connector_metadata);
        formatter.field("connector_type", &self.connector_type);
        formatter.field("connector_label", &self.connector_label);
        formatter.field("connector_description", &self.connector_description);
        formatter.field("connector_owner", &self.connector_owner);
        formatter.field("connector_name", &self.connector_name);
        formatter.field("connector_version", &self.connector_version);
        formatter.field("connector_arn", &self.connector_arn);
        formatter.field("connector_modes", &self.connector_modes);
        formatter.field("authentication_config", &self.authentication_config);
        formatter.field(
            "connector_runtime_settings",
            &self.connector_runtime_settings,
        );
        formatter.field("supported_api_versions", &self.supported_api_versions);
        formatter.field("supported_operators", &self.supported_operators);
        formatter.field(
            "supported_write_operations",
            &self.supported_write_operations,
        );
        formatter.field(
            "connector_provisioning_type",
            &self.connector_provisioning_type,
        );
        formatter.field(
            "connector_provisioning_config",
            &self.connector_provisioning_config,
        );
        formatter.field("logo_url", &self.logo_url);
        formatter.field("registered_at", &self.registered_at);
        formatter.field("registered_by", &self.registered_by);
        formatter.finish()
    }
}
/// See [`ConnectorConfiguration`](crate::model::ConnectorConfiguration)
pub mod connector_configuration {
    /// A builder for [`ConnectorConfiguration`](crate::model::ConnectorConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) can_use_as_source: std::option::Option<bool>,
        pub(crate) can_use_as_destination: std::option::Option<bool>,
        pub(crate) supported_destination_connectors:
            std::option::Option<std::vec::Vec<crate::model::ConnectorType>>,
        pub(crate) supported_scheduling_frequencies:
            std::option::Option<std::vec::Vec<crate::model::ScheduleFrequencyType>>,
        pub(crate) is_private_link_enabled: std::option::Option<bool>,
        pub(crate) is_private_link_endpoint_url_required: std::option::Option<bool>,
        pub(crate) supported_trigger_types:
            std::option::Option<std::vec::Vec<crate::model::TriggerType>>,
        pub(crate) connector_metadata: std::option::Option<crate::model::ConnectorMetadata>,
        pub(crate) connector_type: std::option::Option<crate::model::ConnectorType>,
        pub(crate) connector_label: std::option::Option<std::string::String>,
        pub(crate) connector_description: std::option::Option<std::string::String>,
        pub(crate) connector_owner: std::option::Option<std::string::String>,
        pub(crate) connector_name: std::option::Option<std::string::String>,
        pub(crate) connector_version: std::option::Option<std::string::String>,
        pub(crate) connector_arn: std::option::Option<std::string::String>,
        pub(crate) connector_modes: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) authentication_config: std::option::Option<crate::model::AuthenticationConfig>,
        pub(crate) connector_runtime_settings:
            std::option::Option<std::vec::Vec<crate::model::ConnectorRuntimeSetting>>,
        pub(crate) supported_api_versions: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) supported_operators: std::option::Option<std::vec::Vec<crate::model::Operators>>,
        pub(crate) supported_write_operations:
            std::option::Option<std::vec::Vec<crate::model::WriteOperationType>>,
        pub(crate) connector_provisioning_type:
            std::option::Option<crate::model::ConnectorProvisioningType>,
        pub(crate) connector_provisioning_config:
            std::option::Option<crate::model::ConnectorProvisioningConfig>,
        pub(crate) logo_url: std::option::Option<std::string::String>,
        pub(crate) registered_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) registered_by: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> Specifies whether the connector can be used as a source. </p>
        pub fn can_use_as_source(mut self, input: bool) -> Self {
            self.can_use_as_source = Some(input);
            self
        }
        /// <p> Specifies whether the connector can be used as a source. </p>
        pub fn set_can_use_as_source(mut self, input: std::option::Option<bool>) -> Self {
            self.can_use_as_source = input;
            self
        }
        /// <p> Specifies whether the connector can be used as a destination. </p>
        pub fn can_use_as_destination(mut self, input: bool) -> Self {
            self.can_use_as_destination = Some(input);
            self
        }
        /// <p> Specifies whether the connector can be used as a destination. </p>
        pub fn set_can_use_as_destination(mut self, input: std::option::Option<bool>) -> Self {
            self.can_use_as_destination = input;
            self
        }
        /// Appends an item to `supported_destination_connectors`.
        ///
        /// To override the contents of this collection use [`set_supported_destination_connectors`](Self::set_supported_destination_connectors).
        ///
        /// <p> Lists the connectors that are available for use as destinations. </p>
        pub fn supported_destination_connectors(
            mut self,
            input: crate::model::ConnectorType,
        ) -> Self {
            let mut v = self.supported_destination_connectors.unwrap_or_default();
            v.push(input);
            self.supported_destination_connectors = Some(v);
            self
        }
        /// <p> Lists the connectors that are available for use as destinations. </p>
        pub fn set_supported_destination_connectors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConnectorType>>,
        ) -> Self {
            self.supported_destination_connectors = input;
            self
        }
        /// Appends an item to `supported_scheduling_frequencies`.
        ///
        /// To override the contents of this collection use [`set_supported_scheduling_frequencies`](Self::set_supported_scheduling_frequencies).
        ///
        /// <p> Specifies the supported flow frequency for that connector. </p>
        pub fn supported_scheduling_frequencies(
            mut self,
            input: crate::model::ScheduleFrequencyType,
        ) -> Self {
            let mut v = self.supported_scheduling_frequencies.unwrap_or_default();
            v.push(input);
            self.supported_scheduling_frequencies = Some(v);
            self
        }
        /// <p> Specifies the supported flow frequency for that connector. </p>
        pub fn set_supported_scheduling_frequencies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ScheduleFrequencyType>>,
        ) -> Self {
            self.supported_scheduling_frequencies = input;
            self
        }
        /// <p> Specifies if PrivateLink is enabled for that connector. </p>
        pub fn is_private_link_enabled(mut self, input: bool) -> Self {
            self.is_private_link_enabled = Some(input);
            self
        }
        /// <p> Specifies if PrivateLink is enabled for that connector. </p>
        pub fn set_is_private_link_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.is_private_link_enabled = input;
            self
        }
        /// <p> Specifies if a PrivateLink endpoint URL is required. </p>
        pub fn is_private_link_endpoint_url_required(mut self, input: bool) -> Self {
            self.is_private_link_endpoint_url_required = Some(input);
            self
        }
        /// <p> Specifies if a PrivateLink endpoint URL is required. </p>
        pub fn set_is_private_link_endpoint_url_required(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.is_private_link_endpoint_url_required = input;
            self
        }
        /// Appends an item to `supported_trigger_types`.
        ///
        /// To override the contents of this collection use [`set_supported_trigger_types`](Self::set_supported_trigger_types).
        ///
        /// <p> Specifies the supported trigger types for the flow. </p>
        pub fn supported_trigger_types(mut self, input: crate::model::TriggerType) -> Self {
            let mut v = self.supported_trigger_types.unwrap_or_default();
            v.push(input);
            self.supported_trigger_types = Some(v);
            self
        }
        /// <p> Specifies the supported trigger types for the flow. </p>
        pub fn set_supported_trigger_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TriggerType>>,
        ) -> Self {
            self.supported_trigger_types = input;
            self
        }
        /// <p> Specifies connector-specific metadata such as <code>oAuthScopes</code>, <code>supportedRegions</code>, <code>privateLinkServiceUrl</code>, and so on. </p>
        pub fn connector_metadata(mut self, input: crate::model::ConnectorMetadata) -> Self {
            self.connector_metadata = Some(input);
            self
        }
        /// <p> Specifies connector-specific metadata such as <code>oAuthScopes</code>, <code>supportedRegions</code>, <code>privateLinkServiceUrl</code>, and so on. </p>
        pub fn set_connector_metadata(
            mut self,
            input: std::option::Option<crate::model::ConnectorMetadata>,
        ) -> Self {
            self.connector_metadata = input;
            self
        }
        /// <p>The connector type.</p>
        pub fn connector_type(mut self, input: crate::model::ConnectorType) -> Self {
            self.connector_type = Some(input);
            self
        }
        /// <p>The connector type.</p>
        pub fn set_connector_type(
            mut self,
            input: std::option::Option<crate::model::ConnectorType>,
        ) -> Self {
            self.connector_type = input;
            self
        }
        /// <p>The label used for registering the connector.</p>
        pub fn connector_label(mut self, input: impl Into<std::string::String>) -> Self {
            self.connector_label = Some(input.into());
            self
        }
        /// <p>The label used for registering the connector.</p>
        pub fn set_connector_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connector_label = input;
            self
        }
        /// <p>A description about the connector.</p>
        pub fn connector_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.connector_description = Some(input.into());
            self
        }
        /// <p>A description about the connector.</p>
        pub fn set_connector_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connector_description = input;
            self
        }
        /// <p>The owner who developed the connector.</p>
        pub fn connector_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.connector_owner = Some(input.into());
            self
        }
        /// <p>The owner who developed the connector.</p>
        pub fn set_connector_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connector_owner = input;
            self
        }
        /// <p>The connector name.</p>
        pub fn connector_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.connector_name = Some(input.into());
            self
        }
        /// <p>The connector name.</p>
        pub fn set_connector_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connector_name = input;
            self
        }
        /// <p>The connector version.</p>
        pub fn connector_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.connector_version = Some(input.into());
            self
        }
        /// <p>The connector version.</p>
        pub fn set_connector_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connector_version = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the registered connector.</p>
        pub fn connector_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.connector_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the registered connector.</p>
        pub fn set_connector_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connector_arn = input;
            self
        }
        /// Appends an item to `connector_modes`.
        ///
        /// To override the contents of this collection use [`set_connector_modes`](Self::set_connector_modes).
        ///
        /// <p>The connection modes that the connector supports.</p>
        pub fn connector_modes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.connector_modes.unwrap_or_default();
            v.push(input.into());
            self.connector_modes = Some(v);
            self
        }
        /// <p>The connection modes that the connector supports.</p>
        pub fn set_connector_modes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.connector_modes = input;
            self
        }
        /// <p>The authentication config required for the connector.</p>
        pub fn authentication_config(mut self, input: crate::model::AuthenticationConfig) -> Self {
            self.authentication_config = Some(input);
            self
        }
        /// <p>The authentication config required for the connector.</p>
        pub fn set_authentication_config(
            mut self,
            input: std::option::Option<crate::model::AuthenticationConfig>,
        ) -> Self {
            self.authentication_config = input;
            self
        }
        /// Appends an item to `connector_runtime_settings`.
        ///
        /// To override the contents of this collection use [`set_connector_runtime_settings`](Self::set_connector_runtime_settings).
        ///
        /// <p>The required connector runtime settings.</p>
        pub fn connector_runtime_settings(
            mut self,
            input: crate::model::ConnectorRuntimeSetting,
        ) -> Self {
            let mut v = self.connector_runtime_settings.unwrap_or_default();
            v.push(input);
            self.connector_runtime_settings = Some(v);
            self
        }
        /// <p>The required connector runtime settings.</p>
        pub fn set_connector_runtime_settings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConnectorRuntimeSetting>>,
        ) -> Self {
            self.connector_runtime_settings = input;
            self
        }
        /// Appends an item to `supported_api_versions`.
        ///
        /// To override the contents of this collection use [`set_supported_api_versions`](Self::set_supported_api_versions).
        ///
        /// <p>A list of API versions that are supported by the connector.</p>
        pub fn supported_api_versions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.supported_api_versions.unwrap_or_default();
            v.push(input.into());
            self.supported_api_versions = Some(v);
            self
        }
        /// <p>A list of API versions that are supported by the connector.</p>
        pub fn set_supported_api_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.supported_api_versions = input;
            self
        }
        /// Appends an item to `supported_operators`.
        ///
        /// To override the contents of this collection use [`set_supported_operators`](Self::set_supported_operators).
        ///
        /// <p>A list of operators supported by the connector.</p>
        pub fn supported_operators(mut self, input: crate::model::Operators) -> Self {
            let mut v = self.supported_operators.unwrap_or_default();
            v.push(input);
            self.supported_operators = Some(v);
            self
        }
        /// <p>A list of operators supported by the connector.</p>
        pub fn set_supported_operators(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Operators>>,
        ) -> Self {
            self.supported_operators = input;
            self
        }
        /// Appends an item to `supported_write_operations`.
        ///
        /// To override the contents of this collection use [`set_supported_write_operations`](Self::set_supported_write_operations).
        ///
        /// <p>A list of write operations supported by the connector.</p>
        pub fn supported_write_operations(
            mut self,
            input: crate::model::WriteOperationType,
        ) -> Self {
            let mut v = self.supported_write_operations.unwrap_or_default();
            v.push(input);
            self.supported_write_operations = Some(v);
            self
        }
        /// <p>A list of write operations supported by the connector.</p>
        pub fn set_supported_write_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::WriteOperationType>>,
        ) -> Self {
            self.supported_write_operations = input;
            self
        }
        /// <p>The provisioning type used to register the connector.</p>
        pub fn connector_provisioning_type(
            mut self,
            input: crate::model::ConnectorProvisioningType,
        ) -> Self {
            self.connector_provisioning_type = Some(input);
            self
        }
        /// <p>The provisioning type used to register the connector.</p>
        pub fn set_connector_provisioning_type(
            mut self,
            input: std::option::Option<crate::model::ConnectorProvisioningType>,
        ) -> Self {
            self.connector_provisioning_type = input;
            self
        }
        /// <p>The configuration required for registering the connector.</p>
        pub fn connector_provisioning_config(
            mut self,
            input: crate::model::ConnectorProvisioningConfig,
        ) -> Self {
            self.connector_provisioning_config = Some(input);
            self
        }
        /// <p>The configuration required for registering the connector.</p>
        pub fn set_connector_provisioning_config(
            mut self,
            input: std::option::Option<crate::model::ConnectorProvisioningConfig>,
        ) -> Self {
            self.connector_provisioning_config = input;
            self
        }
        /// <p>Logo URL of the connector.</p>
        pub fn logo_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.logo_url = Some(input.into());
            self
        }
        /// <p>Logo URL of the connector.</p>
        pub fn set_logo_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.logo_url = input;
            self
        }
        /// <p>The date on which the connector was registered.</p>
        pub fn registered_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.registered_at = Some(input);
            self
        }
        /// <p>The date on which the connector was registered.</p>
        pub fn set_registered_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.registered_at = input;
            self
        }
        /// <p>Information about who registered the connector.</p>
        pub fn registered_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.registered_by = Some(input.into());
            self
        }
        /// <p>Information about who registered the connector.</p>
        pub fn set_registered_by(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.registered_by = input;
            self
        }
        /// Consumes the builder and constructs a [`ConnectorConfiguration`](crate::model::ConnectorConfiguration)
        pub fn build(self) -> crate::model::ConnectorConfiguration {
            crate::model::ConnectorConfiguration {
                can_use_as_source: self.can_use_as_source.unwrap_or_default(),
                can_use_as_destination: self.can_use_as_destination.unwrap_or_default(),
                supported_destination_connectors: self.supported_destination_connectors,
                supported_scheduling_frequencies: self.supported_scheduling_frequencies,
                is_private_link_enabled: self.is_private_link_enabled.unwrap_or_default(),
                is_private_link_endpoint_url_required: self
                    .is_private_link_endpoint_url_required
                    .unwrap_or_default(),
                supported_trigger_types: self.supported_trigger_types,
                connector_metadata: self.connector_metadata,
                connector_type: self.connector_type,
                connector_label: self.connector_label,
                connector_description: self.connector_description,
                connector_owner: self.connector_owner,
                connector_name: self.connector_name,
                connector_version: self.connector_version,
                connector_arn: self.connector_arn,
                connector_modes: self.connector_modes,
                authentication_config: self.authentication_config,
                connector_runtime_settings: self.connector_runtime_settings,
                supported_api_versions: self.supported_api_versions,
                supported_operators: self.supported_operators,
                supported_write_operations: self.supported_write_operations,
                connector_provisioning_type: self.connector_provisioning_type,
                connector_provisioning_config: self.connector_provisioning_config,
                logo_url: self.logo_url,
                registered_at: self.registered_at,
                registered_by: self.registered_by,
            }
        }
    }
}
impl ConnectorConfiguration {
    /// Creates a new builder-style object to manufacture [`ConnectorConfiguration`](crate::model::ConnectorConfiguration)
    pub fn builder() -> crate::model::connector_configuration::Builder {
        crate::model::connector_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Operators {
    #[allow(missing_docs)] // documentation missing in model
    Addition,
    #[allow(missing_docs)] // documentation missing in model
    Between,
    #[allow(missing_docs)] // documentation missing in model
    Contains,
    #[allow(missing_docs)] // documentation missing in model
    Division,
    #[allow(missing_docs)] // documentation missing in model
    EqualTo,
    #[allow(missing_docs)] // documentation missing in model
    GreaterThan,
    #[allow(missing_docs)] // documentation missing in model
    GreaterThanOrEqualTo,
    #[allow(missing_docs)] // documentation missing in model
    LessThan,
    #[allow(missing_docs)] // documentation missing in model
    LessThanOrEqualTo,
    #[allow(missing_docs)] // documentation missing in model
    MaskAll,
    #[allow(missing_docs)] // documentation missing in model
    MaskFirstN,
    #[allow(missing_docs)] // documentation missing in model
    MaskLastN,
    #[allow(missing_docs)] // documentation missing in model
    Multiplication,
    #[allow(missing_docs)] // documentation missing in model
    NotEqualTo,
    #[allow(missing_docs)] // documentation missing in model
    NoOp,
    #[allow(missing_docs)] // documentation missing in model
    Projection,
    #[allow(missing_docs)] // documentation missing in model
    Subtraction,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNonNegative,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNonNull,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNonZero,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNumeric,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Operators {
    fn from(s: &str) -> Self {
        match s {
            "ADDITION" => Operators::Addition,
            "BETWEEN" => Operators::Between,
            "CONTAINS" => Operators::Contains,
            "DIVISION" => Operators::Division,
            "EQUAL_TO" => Operators::EqualTo,
            "GREATER_THAN" => Operators::GreaterThan,
            "GREATER_THAN_OR_EQUAL_TO" => Operators::GreaterThanOrEqualTo,
            "LESS_THAN" => Operators::LessThan,
            "LESS_THAN_OR_EQUAL_TO" => Operators::LessThanOrEqualTo,
            "MASK_ALL" => Operators::MaskAll,
            "MASK_FIRST_N" => Operators::MaskFirstN,
            "MASK_LAST_N" => Operators::MaskLastN,
            "MULTIPLICATION" => Operators::Multiplication,
            "NOT_EQUAL_TO" => Operators::NotEqualTo,
            "NO_OP" => Operators::NoOp,
            "PROJECTION" => Operators::Projection,
            "SUBTRACTION" => Operators::Subtraction,
            "VALIDATE_NON_NEGATIVE" => Operators::ValidateNonNegative,
            "VALIDATE_NON_NULL" => Operators::ValidateNonNull,
            "VALIDATE_NON_ZERO" => Operators::ValidateNonZero,
            "VALIDATE_NUMERIC" => Operators::ValidateNumeric,
            other => Operators::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Operators {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Operators::from(s))
    }
}
impl Operators {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Operators::Addition => "ADDITION",
            Operators::Between => "BETWEEN",
            Operators::Contains => "CONTAINS",
            Operators::Division => "DIVISION",
            Operators::EqualTo => "EQUAL_TO",
            Operators::GreaterThan => "GREATER_THAN",
            Operators::GreaterThanOrEqualTo => "GREATER_THAN_OR_EQUAL_TO",
            Operators::LessThan => "LESS_THAN",
            Operators::LessThanOrEqualTo => "LESS_THAN_OR_EQUAL_TO",
            Operators::MaskAll => "MASK_ALL",
            Operators::MaskFirstN => "MASK_FIRST_N",
            Operators::MaskLastN => "MASK_LAST_N",
            Operators::Multiplication => "MULTIPLICATION",
            Operators::NotEqualTo => "NOT_EQUAL_TO",
            Operators::NoOp => "NO_OP",
            Operators::Projection => "PROJECTION",
            Operators::Subtraction => "SUBTRACTION",
            Operators::ValidateNonNegative => "VALIDATE_NON_NEGATIVE",
            Operators::ValidateNonNull => "VALIDATE_NON_NULL",
            Operators::ValidateNonZero => "VALIDATE_NON_ZERO",
            Operators::ValidateNumeric => "VALIDATE_NUMERIC",
            Operators::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ADDITION",
            "BETWEEN",
            "CONTAINS",
            "DIVISION",
            "EQUAL_TO",
            "GREATER_THAN",
            "GREATER_THAN_OR_EQUAL_TO",
            "LESS_THAN",
            "LESS_THAN_OR_EQUAL_TO",
            "MASK_ALL",
            "MASK_FIRST_N",
            "MASK_LAST_N",
            "MULTIPLICATION",
            "NOT_EQUAL_TO",
            "NO_OP",
            "PROJECTION",
            "SUBTRACTION",
            "VALIDATE_NON_NEGATIVE",
            "VALIDATE_NON_NULL",
            "VALIDATE_NON_ZERO",
            "VALIDATE_NUMERIC",
        ]
    }
}
impl AsRef<str> for Operators {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about the connector runtime settings that are required for flow execution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConnectorRuntimeSetting {
    /// <p>Contains value information about the connector runtime setting.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>Data type of the connector runtime setting.</p>
    pub data_type: std::option::Option<std::string::String>,
    /// <p>Indicates whether this connector runtime setting is required.</p>
    pub is_required: bool,
    /// <p>A label used for connector runtime setting.</p>
    pub label: std::option::Option<std::string::String>,
    /// <p>A description about the connector runtime setting.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Indicates the scope of the connector runtime setting.</p>
    pub scope: std::option::Option<std::string::String>,
    /// <p>Contains default values for the connector runtime setting that are supplied by the connector.</p>
    pub connector_supplied_value_options: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ConnectorRuntimeSetting {
    /// <p>Contains value information about the connector runtime setting.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>Data type of the connector runtime setting.</p>
    pub fn data_type(&self) -> std::option::Option<&str> {
        self.data_type.as_deref()
    }
    /// <p>Indicates whether this connector runtime setting is required.</p>
    pub fn is_required(&self) -> bool {
        self.is_required
    }
    /// <p>A label used for connector runtime setting.</p>
    pub fn label(&self) -> std::option::Option<&str> {
        self.label.as_deref()
    }
    /// <p>A description about the connector runtime setting.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Indicates the scope of the connector runtime setting.</p>
    pub fn scope(&self) -> std::option::Option<&str> {
        self.scope.as_deref()
    }
    /// <p>Contains default values for the connector runtime setting that are supplied by the connector.</p>
    pub fn connector_supplied_value_options(&self) -> std::option::Option<&[std::string::String]> {
        self.connector_supplied_value_options.as_deref()
    }
}
impl std::fmt::Debug for ConnectorRuntimeSetting {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConnectorRuntimeSetting");
        formatter.field("key", &self.key);
        formatter.field("data_type", &self.data_type);
        formatter.field("is_required", &self.is_required);
        formatter.field("label", &self.label);
        formatter.field("description", &self.description);
        formatter.field("scope", &self.scope);
        formatter.field(
            "connector_supplied_value_options",
            &self.connector_supplied_value_options,
        );
        formatter.finish()
    }
}
/// See [`ConnectorRuntimeSetting`](crate::model::ConnectorRuntimeSetting)
pub mod connector_runtime_setting {
    /// A builder for [`ConnectorRuntimeSetting`](crate::model::ConnectorRuntimeSetting)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) data_type: std::option::Option<std::string::String>,
        pub(crate) is_required: std::option::Option<bool>,
        pub(crate) label: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) scope: std::option::Option<std::string::String>,
        pub(crate) connector_supplied_value_options:
            std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>Contains value information about the connector runtime setting.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>Contains value information about the connector runtime setting.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>Data type of the connector runtime setting.</p>
        pub fn data_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_type = Some(input.into());
            self
        }
        /// <p>Data type of the connector runtime setting.</p>
        pub fn set_data_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_type = input;
            self
        }
        /// <p>Indicates whether this connector runtime setting is required.</p>
        pub fn is_required(mut self, input: bool) -> Self {
            self.is_required = Some(input);
            self
        }
        /// <p>Indicates whether this connector runtime setting is required.</p>
        pub fn set_is_required(mut self, input: std::option::Option<bool>) -> Self {
            self.is_required = input;
            self
        }
        /// <p>A label used for connector runtime setting.</p>
        pub fn label(mut self, input: impl Into<std::string::String>) -> Self {
            self.label = Some(input.into());
            self
        }
        /// <p>A label used for connector runtime setting.</p>
        pub fn set_label(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.label = input;
            self
        }
        /// <p>A description about the connector runtime setting.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description about the connector runtime setting.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Indicates the scope of the connector runtime setting.</p>
        pub fn scope(mut self, input: impl Into<std::string::String>) -> Self {
            self.scope = Some(input.into());
            self
        }
        /// <p>Indicates the scope of the connector runtime setting.</p>
        pub fn set_scope(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.scope = input;
            self
        }
        /// Appends an item to `connector_supplied_value_options`.
        ///
        /// To override the contents of this collection use [`set_connector_supplied_value_options`](Self::set_connector_supplied_value_options).
        ///
        /// <p>Contains default values for the connector runtime setting that are supplied by the connector.</p>
        pub fn connector_supplied_value_options(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.connector_supplied_value_options.unwrap_or_default();
            v.push(input.into());
            self.connector_supplied_value_options = Some(v);
            self
        }
        /// <p>Contains default values for the connector runtime setting that are supplied by the connector.</p>
        pub fn set_connector_supplied_value_options(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.connector_supplied_value_options = input;
            self
        }
        /// Consumes the builder and constructs a [`ConnectorRuntimeSetting`](crate::model::ConnectorRuntimeSetting)
        pub fn build(self) -> crate::model::ConnectorRuntimeSetting {
            crate::model::ConnectorRuntimeSetting {
                key: self.key,
                data_type: self.data_type,
                is_required: self.is_required.unwrap_or_default(),
                label: self.label,
                description: self.description,
                scope: self.scope,
                connector_supplied_value_options: self.connector_supplied_value_options,
            }
        }
    }
}
impl ConnectorRuntimeSetting {
    /// Creates a new builder-style object to manufacture [`ConnectorRuntimeSetting`](crate::model::ConnectorRuntimeSetting)
    pub fn builder() -> crate::model::connector_runtime_setting::Builder {
        crate::model::connector_runtime_setting::Builder::default()
    }
}

/// <p>Contains information about the authentication config that the connector supports.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AuthenticationConfig {
    /// <p>Indicates whether basic authentication is supported by the connector.</p>
    pub is_basic_auth_supported: bool,
    /// <p>Indicates whether API key authentication is supported by the connector</p>
    pub is_api_key_auth_supported: bool,
    /// <p>Indicates whether OAuth 2.0 authentication is supported by the connector.</p>
    pub is_o_auth2_supported: bool,
    /// <p>Indicates whether custom authentication is supported by the connector</p>
    pub is_custom_auth_supported: bool,
    /// <p>Contains the default values required for OAuth 2.0 authentication.</p>
    pub o_auth2_defaults: std::option::Option<crate::model::OAuth2Defaults>,
    /// <p>Contains information required for custom authentication.</p>
    pub custom_auth_configs: std::option::Option<std::vec::Vec<crate::model::CustomAuthConfig>>,
}
impl AuthenticationConfig {
    /// <p>Indicates whether basic authentication is supported by the connector.</p>
    pub fn is_basic_auth_supported(&self) -> bool {
        self.is_basic_auth_supported
    }
    /// <p>Indicates whether API key authentication is supported by the connector</p>
    pub fn is_api_key_auth_supported(&self) -> bool {
        self.is_api_key_auth_supported
    }
    /// <p>Indicates whether OAuth 2.0 authentication is supported by the connector.</p>
    pub fn is_o_auth2_supported(&self) -> bool {
        self.is_o_auth2_supported
    }
    /// <p>Indicates whether custom authentication is supported by the connector</p>
    pub fn is_custom_auth_supported(&self) -> bool {
        self.is_custom_auth_supported
    }
    /// <p>Contains the default values required for OAuth 2.0 authentication.</p>
    pub fn o_auth2_defaults(&self) -> std::option::Option<&crate::model::OAuth2Defaults> {
        self.o_auth2_defaults.as_ref()
    }
    /// <p>Contains information required for custom authentication.</p>
    pub fn custom_auth_configs(&self) -> std::option::Option<&[crate::model::CustomAuthConfig]> {
        self.custom_auth_configs.as_deref()
    }
}
impl std::fmt::Debug for AuthenticationConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AuthenticationConfig");
        formatter.field("is_basic_auth_supported", &self.is_basic_auth_supported);
        formatter.field("is_api_key_auth_supported", &self.is_api_key_auth_supported);
        formatter.field("is_o_auth2_supported", &self.is_o_auth2_supported);
        formatter.field("is_custom_auth_supported", &self.is_custom_auth_supported);
        formatter.field("o_auth2_defaults", &self.o_auth2_defaults);
        formatter.field("custom_auth_configs", &self.custom_auth_configs);
        formatter.finish()
    }
}
/// See [`AuthenticationConfig`](crate::model::AuthenticationConfig)
pub mod authentication_config {
    /// A builder for [`AuthenticationConfig`](crate::model::AuthenticationConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) is_basic_auth_supported: std::option::Option<bool>,
        pub(crate) is_api_key_auth_supported: std::option::Option<bool>,
        pub(crate) is_o_auth2_supported: std::option::Option<bool>,
        pub(crate) is_custom_auth_supported: std::option::Option<bool>,
        pub(crate) o_auth2_defaults: std::option::Option<crate::model::OAuth2Defaults>,
        pub(crate) custom_auth_configs:
            std::option::Option<std::vec::Vec<crate::model::CustomAuthConfig>>,
    }
    impl Builder {
        /// <p>Indicates whether basic authentication is supported by the connector.</p>
        pub fn is_basic_auth_supported(mut self, input: bool) -> Self {
            self.is_basic_auth_supported = Some(input);
            self
        }
        /// <p>Indicates whether basic authentication is supported by the connector.</p>
        pub fn set_is_basic_auth_supported(mut self, input: std::option::Option<bool>) -> Self {
            self.is_basic_auth_supported = input;
            self
        }
        /// <p>Indicates whether API key authentication is supported by the connector</p>
        pub fn is_api_key_auth_supported(mut self, input: bool) -> Self {
            self.is_api_key_auth_supported = Some(input);
            self
        }
        /// <p>Indicates whether API key authentication is supported by the connector</p>
        pub fn set_is_api_key_auth_supported(mut self, input: std::option::Option<bool>) -> Self {
            self.is_api_key_auth_supported = input;
            self
        }
        /// <p>Indicates whether OAuth 2.0 authentication is supported by the connector.</p>
        pub fn is_o_auth2_supported(mut self, input: bool) -> Self {
            self.is_o_auth2_supported = Some(input);
            self
        }
        /// <p>Indicates whether OAuth 2.0 authentication is supported by the connector.</p>
        pub fn set_is_o_auth2_supported(mut self, input: std::option::Option<bool>) -> Self {
            self.is_o_auth2_supported = input;
            self
        }
        /// <p>Indicates whether custom authentication is supported by the connector</p>
        pub fn is_custom_auth_supported(mut self, input: bool) -> Self {
            self.is_custom_auth_supported = Some(input);
            self
        }
        /// <p>Indicates whether custom authentication is supported by the connector</p>
        pub fn set_is_custom_auth_supported(mut self, input: std::option::Option<bool>) -> Self {
            self.is_custom_auth_supported = input;
            self
        }
        /// <p>Contains the default values required for OAuth 2.0 authentication.</p>
        pub fn o_auth2_defaults(mut self, input: crate::model::OAuth2Defaults) -> Self {
            self.o_auth2_defaults = Some(input);
            self
        }
        /// <p>Contains the default values required for OAuth 2.0 authentication.</p>
        pub fn set_o_auth2_defaults(
            mut self,
            input: std::option::Option<crate::model::OAuth2Defaults>,
        ) -> Self {
            self.o_auth2_defaults = input;
            self
        }
        /// Appends an item to `custom_auth_configs`.
        ///
        /// To override the contents of this collection use [`set_custom_auth_configs`](Self::set_custom_auth_configs).
        ///
        /// <p>Contains information required for custom authentication.</p>
        pub fn custom_auth_configs(mut self, input: crate::model::CustomAuthConfig) -> Self {
            let mut v = self.custom_auth_configs.unwrap_or_default();
            v.push(input);
            self.custom_auth_configs = Some(v);
            self
        }
        /// <p>Contains information required for custom authentication.</p>
        pub fn set_custom_auth_configs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CustomAuthConfig>>,
        ) -> Self {
            self.custom_auth_configs = input;
            self
        }
        /// Consumes the builder and constructs a [`AuthenticationConfig`](crate::model::AuthenticationConfig)
        pub fn build(self) -> crate::model::AuthenticationConfig {
            crate::model::AuthenticationConfig {
                is_basic_auth_supported: self.is_basic_auth_supported.unwrap_or_default(),
                is_api_key_auth_supported: self.is_api_key_auth_supported.unwrap_or_default(),
                is_o_auth2_supported: self.is_o_auth2_supported.unwrap_or_default(),
                is_custom_auth_supported: self.is_custom_auth_supported.unwrap_or_default(),
                o_auth2_defaults: self.o_auth2_defaults,
                custom_auth_configs: self.custom_auth_configs,
            }
        }
    }
}
impl AuthenticationConfig {
    /// Creates a new builder-style object to manufacture [`AuthenticationConfig`](crate::model::AuthenticationConfig)
    pub fn builder() -> crate::model::authentication_config::Builder {
        crate::model::authentication_config::Builder::default()
    }
}

/// <p>Configuration information required for custom authentication.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomAuthConfig {
    /// <p>The authentication type that the custom connector uses.</p>
    pub custom_authentication_type: std::option::Option<std::string::String>,
    /// <p>Information about authentication parameters required for authentication.</p>
    pub auth_parameters: std::option::Option<std::vec::Vec<crate::model::AuthParameter>>,
}
impl CustomAuthConfig {
    /// <p>The authentication type that the custom connector uses.</p>
    pub fn custom_authentication_type(&self) -> std::option::Option<&str> {
        self.custom_authentication_type.as_deref()
    }
    /// <p>Information about authentication parameters required for authentication.</p>
    pub fn auth_parameters(&self) -> std::option::Option<&[crate::model::AuthParameter]> {
        self.auth_parameters.as_deref()
    }
}
impl std::fmt::Debug for CustomAuthConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomAuthConfig");
        formatter.field(
            "custom_authentication_type",
            &self.custom_authentication_type,
        );
        formatter.field("auth_parameters", &self.auth_parameters);
        formatter.finish()
    }
}
/// See [`CustomAuthConfig`](crate::model::CustomAuthConfig)
pub mod custom_auth_config {
    /// A builder for [`CustomAuthConfig`](crate::model::CustomAuthConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) custom_authentication_type: std::option::Option<std::string::String>,
        pub(crate) auth_parameters: std::option::Option<std::vec::Vec<crate::model::AuthParameter>>,
    }
    impl Builder {
        /// <p>The authentication type that the custom connector uses.</p>
        pub fn custom_authentication_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_authentication_type = Some(input.into());
            self
        }
        /// <p>The authentication type that the custom connector uses.</p>
        pub fn set_custom_authentication_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_authentication_type = input;
            self
        }
        /// Appends an item to `auth_parameters`.
        ///
        /// To override the contents of this collection use [`set_auth_parameters`](Self::set_auth_parameters).
        ///
        /// <p>Information about authentication parameters required for authentication.</p>
        pub fn auth_parameters(mut self, input: crate::model::AuthParameter) -> Self {
            let mut v = self.auth_parameters.unwrap_or_default();
            v.push(input);
            self.auth_parameters = Some(v);
            self
        }
        /// <p>Information about authentication parameters required for authentication.</p>
        pub fn set_auth_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AuthParameter>>,
        ) -> Self {
            self.auth_parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomAuthConfig`](crate::model::CustomAuthConfig)
        pub fn build(self) -> crate::model::CustomAuthConfig {
            crate::model::CustomAuthConfig {
                custom_authentication_type: self.custom_authentication_type,
                auth_parameters: self.auth_parameters,
            }
        }
    }
}
impl CustomAuthConfig {
    /// Creates a new builder-style object to manufacture [`CustomAuthConfig`](crate::model::CustomAuthConfig)
    pub fn builder() -> crate::model::custom_auth_config::Builder {
        crate::model::custom_auth_config::Builder::default()
    }
}

/// <p>Information about required authentication parameters.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AuthParameter {
    /// <p>The authentication key required to authenticate with the connector.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>Indicates whether this authentication parameter is required.</p>
    pub is_required: bool,
    /// <p>Label used for authentication parameter.</p>
    pub label: std::option::Option<std::string::String>,
    /// <p>A description about the authentication parameter.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Indicates whether this authentication parameter is a sensitive field.</p>
    pub is_sensitive_field: bool,
    /// <p>Contains default values for this authentication parameter that are supplied by the connector.</p>
    pub connector_supplied_values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl AuthParameter {
    /// <p>The authentication key required to authenticate with the connector.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>Indicates whether this authentication parameter is required.</p>
    pub fn is_required(&self) -> bool {
        self.is_required
    }
    /// <p>Label used for authentication parameter.</p>
    pub fn label(&self) -> std::option::Option<&str> {
        self.label.as_deref()
    }
    /// <p>A description about the authentication parameter.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Indicates whether this authentication parameter is a sensitive field.</p>
    pub fn is_sensitive_field(&self) -> bool {
        self.is_sensitive_field
    }
    /// <p>Contains default values for this authentication parameter that are supplied by the connector.</p>
    pub fn connector_supplied_values(&self) -> std::option::Option<&[std::string::String]> {
        self.connector_supplied_values.as_deref()
    }
}
impl std::fmt::Debug for AuthParameter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AuthParameter");
        formatter.field("key", &self.key);
        formatter.field("is_required", &self.is_required);
        formatter.field("label", &self.label);
        formatter.field("description", &self.description);
        formatter.field("is_sensitive_field", &self.is_sensitive_field);
        formatter.field("connector_supplied_values", &self.connector_supplied_values);
        formatter.finish()
    }
}
/// See [`AuthParameter`](crate::model::AuthParameter)
pub mod auth_parameter {
    /// A builder for [`AuthParameter`](crate::model::AuthParameter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) is_required: std::option::Option<bool>,
        pub(crate) label: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) is_sensitive_field: std::option::Option<bool>,
        pub(crate) connector_supplied_values:
            std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The authentication key required to authenticate with the connector.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The authentication key required to authenticate with the connector.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>Indicates whether this authentication parameter is required.</p>
        pub fn is_required(mut self, input: bool) -> Self {
            self.is_required = Some(input);
            self
        }
        /// <p>Indicates whether this authentication parameter is required.</p>
        pub fn set_is_required(mut self, input: std::option::Option<bool>) -> Self {
            self.is_required = input;
            self
        }
        /// <p>Label used for authentication parameter.</p>
        pub fn label(mut self, input: impl Into<std::string::String>) -> Self {
            self.label = Some(input.into());
            self
        }
        /// <p>Label used for authentication parameter.</p>
        pub fn set_label(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.label = input;
            self
        }
        /// <p>A description about the authentication parameter.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description about the authentication parameter.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Indicates whether this authentication parameter is a sensitive field.</p>
        pub fn is_sensitive_field(mut self, input: bool) -> Self {
            self.is_sensitive_field = Some(input);
            self
        }
        /// <p>Indicates whether this authentication parameter is a sensitive field.</p>
        pub fn set_is_sensitive_field(mut self, input: std::option::Option<bool>) -> Self {
            self.is_sensitive_field = input;
            self
        }
        /// Appends an item to `connector_supplied_values`.
        ///
        /// To override the contents of this collection use [`set_connector_supplied_values`](Self::set_connector_supplied_values).
        ///
        /// <p>Contains default values for this authentication parameter that are supplied by the connector.</p>
        pub fn connector_supplied_values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.connector_supplied_values.unwrap_or_default();
            v.push(input.into());
            self.connector_supplied_values = Some(v);
            self
        }
        /// <p>Contains default values for this authentication parameter that are supplied by the connector.</p>
        pub fn set_connector_supplied_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.connector_supplied_values = input;
            self
        }
        /// Consumes the builder and constructs a [`AuthParameter`](crate::model::AuthParameter)
        pub fn build(self) -> crate::model::AuthParameter {
            crate::model::AuthParameter {
                key: self.key,
                is_required: self.is_required.unwrap_or_default(),
                label: self.label,
                description: self.description,
                is_sensitive_field: self.is_sensitive_field.unwrap_or_default(),
                connector_supplied_values: self.connector_supplied_values,
            }
        }
    }
}
impl AuthParameter {
    /// Creates a new builder-style object to manufacture [`AuthParameter`](crate::model::AuthParameter)
    pub fn builder() -> crate::model::auth_parameter::Builder {
        crate::model::auth_parameter::Builder::default()
    }
}

/// <p>Contains the default values required for OAuth 2.0 authentication.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OAuth2Defaults {
    /// <p>OAuth 2.0 scopes that the connector supports.</p>
    pub oauth_scopes: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Token URLs that can be used for OAuth 2.0 authentication.</p>
    pub token_urls: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Auth code URLs that can be used for OAuth 2.0 authentication.</p>
    pub auth_code_urls: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>OAuth 2.0 grant types supported by the connector.</p>
    pub oauth2_grant_types_supported:
        std::option::Option<std::vec::Vec<crate::model::OAuth2GrantType>>,
    /// <p>List of custom parameters required for OAuth 2.0 authentication.</p>
    pub oauth2_custom_properties:
        std::option::Option<std::vec::Vec<crate::model::OAuth2CustomParameter>>,
}
impl OAuth2Defaults {
    /// <p>OAuth 2.0 scopes that the connector supports.</p>
    pub fn oauth_scopes(&self) -> std::option::Option<&[std::string::String]> {
        self.oauth_scopes.as_deref()
    }
    /// <p>Token URLs that can be used for OAuth 2.0 authentication.</p>
    pub fn token_urls(&self) -> std::option::Option<&[std::string::String]> {
        self.token_urls.as_deref()
    }
    /// <p>Auth code URLs that can be used for OAuth 2.0 authentication.</p>
    pub fn auth_code_urls(&self) -> std::option::Option<&[std::string::String]> {
        self.auth_code_urls.as_deref()
    }
    /// <p>OAuth 2.0 grant types supported by the connector.</p>
    pub fn oauth2_grant_types_supported(
        &self,
    ) -> std::option::Option<&[crate::model::OAuth2GrantType]> {
        self.oauth2_grant_types_supported.as_deref()
    }
    /// <p>List of custom parameters required for OAuth 2.0 authentication.</p>
    pub fn oauth2_custom_properties(
        &self,
    ) -> std::option::Option<&[crate::model::OAuth2CustomParameter]> {
        self.oauth2_custom_properties.as_deref()
    }
}
impl std::fmt::Debug for OAuth2Defaults {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OAuth2Defaults");
        formatter.field("oauth_scopes", &self.oauth_scopes);
        formatter.field("token_urls", &self.token_urls);
        formatter.field("auth_code_urls", &self.auth_code_urls);
        formatter.field(
            "oauth2_grant_types_supported",
            &self.oauth2_grant_types_supported,
        );
        formatter.field("oauth2_custom_properties", &self.oauth2_custom_properties);
        formatter.finish()
    }
}
/// See [`OAuth2Defaults`](crate::model::OAuth2Defaults)
pub mod o_auth2_defaults {
    /// A builder for [`OAuth2Defaults`](crate::model::OAuth2Defaults)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) oauth_scopes: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) token_urls: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) auth_code_urls: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) oauth2_grant_types_supported:
            std::option::Option<std::vec::Vec<crate::model::OAuth2GrantType>>,
        pub(crate) oauth2_custom_properties:
            std::option::Option<std::vec::Vec<crate::model::OAuth2CustomParameter>>,
    }
    impl Builder {
        /// Appends an item to `oauth_scopes`.
        ///
        /// To override the contents of this collection use [`set_oauth_scopes`](Self::set_oauth_scopes).
        ///
        /// <p>OAuth 2.0 scopes that the connector supports.</p>
        pub fn oauth_scopes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.oauth_scopes.unwrap_or_default();
            v.push(input.into());
            self.oauth_scopes = Some(v);
            self
        }
        /// <p>OAuth 2.0 scopes that the connector supports.</p>
        pub fn set_oauth_scopes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.oauth_scopes = input;
            self
        }
        /// Appends an item to `token_urls`.
        ///
        /// To override the contents of this collection use [`set_token_urls`](Self::set_token_urls).
        ///
        /// <p>Token URLs that can be used for OAuth 2.0 authentication.</p>
        pub fn token_urls(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.token_urls.unwrap_or_default();
            v.push(input.into());
            self.token_urls = Some(v);
            self
        }
        /// <p>Token URLs that can be used for OAuth 2.0 authentication.</p>
        pub fn set_token_urls(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.token_urls = input;
            self
        }
        /// Appends an item to `auth_code_urls`.
        ///
        /// To override the contents of this collection use [`set_auth_code_urls`](Self::set_auth_code_urls).
        ///
        /// <p>Auth code URLs that can be used for OAuth 2.0 authentication.</p>
        pub fn auth_code_urls(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.auth_code_urls.unwrap_or_default();
            v.push(input.into());
            self.auth_code_urls = Some(v);
            self
        }
        /// <p>Auth code URLs that can be used for OAuth 2.0 authentication.</p>
        pub fn set_auth_code_urls(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.auth_code_urls = input;
            self
        }
        /// Appends an item to `oauth2_grant_types_supported`.
        ///
        /// To override the contents of this collection use [`set_oauth2_grant_types_supported`](Self::set_oauth2_grant_types_supported).
        ///
        /// <p>OAuth 2.0 grant types supported by the connector.</p>
        pub fn oauth2_grant_types_supported(
            mut self,
            input: crate::model::OAuth2GrantType,
        ) -> Self {
            let mut v = self.oauth2_grant_types_supported.unwrap_or_default();
            v.push(input);
            self.oauth2_grant_types_supported = Some(v);
            self
        }
        /// <p>OAuth 2.0 grant types supported by the connector.</p>
        pub fn set_oauth2_grant_types_supported(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OAuth2GrantType>>,
        ) -> Self {
            self.oauth2_grant_types_supported = input;
            self
        }
        /// Appends an item to `oauth2_custom_properties`.
        ///
        /// To override the contents of this collection use [`set_oauth2_custom_properties`](Self::set_oauth2_custom_properties).
        ///
        /// <p>List of custom parameters required for OAuth 2.0 authentication.</p>
        pub fn oauth2_custom_properties(
            mut self,
            input: crate::model::OAuth2CustomParameter,
        ) -> Self {
            let mut v = self.oauth2_custom_properties.unwrap_or_default();
            v.push(input);
            self.oauth2_custom_properties = Some(v);
            self
        }
        /// <p>List of custom parameters required for OAuth 2.0 authentication.</p>
        pub fn set_oauth2_custom_properties(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OAuth2CustomParameter>>,
        ) -> Self {
            self.oauth2_custom_properties = input;
            self
        }
        /// Consumes the builder and constructs a [`OAuth2Defaults`](crate::model::OAuth2Defaults)
        pub fn build(self) -> crate::model::OAuth2Defaults {
            crate::model::OAuth2Defaults {
                oauth_scopes: self.oauth_scopes,
                token_urls: self.token_urls,
                auth_code_urls: self.auth_code_urls,
                oauth2_grant_types_supported: self.oauth2_grant_types_supported,
                oauth2_custom_properties: self.oauth2_custom_properties,
            }
        }
    }
}
impl OAuth2Defaults {
    /// Creates a new builder-style object to manufacture [`OAuth2Defaults`](crate::model::OAuth2Defaults)
    pub fn builder() -> crate::model::o_auth2_defaults::Builder {
        crate::model::o_auth2_defaults::Builder::default()
    }
}

/// <p>Custom parameter required for OAuth 2.0 authentication.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OAuth2CustomParameter {
    /// <p>The key of the custom parameter required for OAuth 2.0 authentication.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>Indicates whether the custom parameter for OAuth 2.0 authentication is required.</p>
    pub is_required: bool,
    /// <p>The label of the custom parameter used for OAuth 2.0 authentication.</p>
    pub label: std::option::Option<std::string::String>,
    /// <p>A description about the custom parameter used for OAuth 2.0 authentication.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Indicates whether this authentication custom parameter is a sensitive field.</p>
    pub is_sensitive_field: bool,
    /// <p>Contains default values for this authentication parameter that are supplied by the connector.</p>
    pub connector_supplied_values: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Indicates whether custom parameter is used with TokenUrl or AuthUrl.</p>
    pub r#type: std::option::Option<crate::model::OAuth2CustomPropType>,
}
impl OAuth2CustomParameter {
    /// <p>The key of the custom parameter required for OAuth 2.0 authentication.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>Indicates whether the custom parameter for OAuth 2.0 authentication is required.</p>
    pub fn is_required(&self) -> bool {
        self.is_required
    }
    /// <p>The label of the custom parameter used for OAuth 2.0 authentication.</p>
    pub fn label(&self) -> std::option::Option<&str> {
        self.label.as_deref()
    }
    /// <p>A description about the custom parameter used for OAuth 2.0 authentication.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Indicates whether this authentication custom parameter is a sensitive field.</p>
    pub fn is_sensitive_field(&self) -> bool {
        self.is_sensitive_field
    }
    /// <p>Contains default values for this authentication parameter that are supplied by the connector.</p>
    pub fn connector_supplied_values(&self) -> std::option::Option<&[std::string::String]> {
        self.connector_supplied_values.as_deref()
    }
    /// <p>Indicates whether custom parameter is used with TokenUrl or AuthUrl.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::OAuth2CustomPropType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for OAuth2CustomParameter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OAuth2CustomParameter");
        formatter.field("key", &self.key);
        formatter.field("is_required", &self.is_required);
        formatter.field("label", &self.label);
        formatter.field("description", &self.description);
        formatter.field("is_sensitive_field", &self.is_sensitive_field);
        formatter.field("connector_supplied_values", &self.connector_supplied_values);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`OAuth2CustomParameter`](crate::model::OAuth2CustomParameter)
pub mod o_auth2_custom_parameter {
    /// A builder for [`OAuth2CustomParameter`](crate::model::OAuth2CustomParameter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) is_required: std::option::Option<bool>,
        pub(crate) label: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) is_sensitive_field: std::option::Option<bool>,
        pub(crate) connector_supplied_values:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) r#type: std::option::Option<crate::model::OAuth2CustomPropType>,
    }
    impl Builder {
        /// <p>The key of the custom parameter required for OAuth 2.0 authentication.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key of the custom parameter required for OAuth 2.0 authentication.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>Indicates whether the custom parameter for OAuth 2.0 authentication is required.</p>
        pub fn is_required(mut self, input: bool) -> Self {
            self.is_required = Some(input);
            self
        }
        /// <p>Indicates whether the custom parameter for OAuth 2.0 authentication is required.</p>
        pub fn set_is_required(mut self, input: std::option::Option<bool>) -> Self {
            self.is_required = input;
            self
        }
        /// <p>The label of the custom parameter used for OAuth 2.0 authentication.</p>
        pub fn label(mut self, input: impl Into<std::string::String>) -> Self {
            self.label = Some(input.into());
            self
        }
        /// <p>The label of the custom parameter used for OAuth 2.0 authentication.</p>
        pub fn set_label(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.label = input;
            self
        }
        /// <p>A description about the custom parameter used for OAuth 2.0 authentication.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description about the custom parameter used for OAuth 2.0 authentication.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Indicates whether this authentication custom parameter is a sensitive field.</p>
        pub fn is_sensitive_field(mut self, input: bool) -> Self {
            self.is_sensitive_field = Some(input);
            self
        }
        /// <p>Indicates whether this authentication custom parameter is a sensitive field.</p>
        pub fn set_is_sensitive_field(mut self, input: std::option::Option<bool>) -> Self {
            self.is_sensitive_field = input;
            self
        }
        /// Appends an item to `connector_supplied_values`.
        ///
        /// To override the contents of this collection use [`set_connector_supplied_values`](Self::set_connector_supplied_values).
        ///
        /// <p>Contains default values for this authentication parameter that are supplied by the connector.</p>
        pub fn connector_supplied_values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.connector_supplied_values.unwrap_or_default();
            v.push(input.into());
            self.connector_supplied_values = Some(v);
            self
        }
        /// <p>Contains default values for this authentication parameter that are supplied by the connector.</p>
        pub fn set_connector_supplied_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.connector_supplied_values = input;
            self
        }
        /// <p>Indicates whether custom parameter is used with TokenUrl or AuthUrl.</p>
        pub fn r#type(mut self, input: crate::model::OAuth2CustomPropType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>Indicates whether custom parameter is used with TokenUrl or AuthUrl.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::OAuth2CustomPropType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`OAuth2CustomParameter`](crate::model::OAuth2CustomParameter)
        pub fn build(self) -> crate::model::OAuth2CustomParameter {
            crate::model::OAuth2CustomParameter {
                key: self.key,
                is_required: self.is_required.unwrap_or_default(),
                label: self.label,
                description: self.description,
                is_sensitive_field: self.is_sensitive_field.unwrap_or_default(),
                connector_supplied_values: self.connector_supplied_values,
                r#type: self.r#type,
            }
        }
    }
}
impl OAuth2CustomParameter {
    /// Creates a new builder-style object to manufacture [`OAuth2CustomParameter`](crate::model::OAuth2CustomParameter)
    pub fn builder() -> crate::model::o_auth2_custom_parameter::Builder {
        crate::model::o_auth2_custom_parameter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OAuth2CustomPropType {
    #[allow(missing_docs)] // documentation missing in model
    AuthUrl,
    #[allow(missing_docs)] // documentation missing in model
    TokenUrl,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OAuth2CustomPropType {
    fn from(s: &str) -> Self {
        match s {
            "AUTH_URL" => OAuth2CustomPropType::AuthUrl,
            "TOKEN_URL" => OAuth2CustomPropType::TokenUrl,
            other => OAuth2CustomPropType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OAuth2CustomPropType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OAuth2CustomPropType::from(s))
    }
}
impl OAuth2CustomPropType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OAuth2CustomPropType::AuthUrl => "AUTH_URL",
            OAuth2CustomPropType::TokenUrl => "TOKEN_URL",
            OAuth2CustomPropType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AUTH_URL", "TOKEN_URL"]
    }
}
impl AsRef<str> for OAuth2CustomPropType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> A structure to specify connector-specific metadata such as <code>oAuthScopes</code>, <code>supportedRegions</code>, <code>privateLinkServiceUrl</code>, and so on. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConnectorMetadata {
    /// <p> The connector metadata specific to Amplitude. </p>
    pub amplitude: std::option::Option<crate::model::AmplitudeMetadata>,
    /// <p> The connector metadata specific to Datadog. </p>
    pub datadog: std::option::Option<crate::model::DatadogMetadata>,
    /// <p> The connector metadata specific to Dynatrace. </p>
    pub dynatrace: std::option::Option<crate::model::DynatraceMetadata>,
    /// <p> The connector metadata specific to Google Analytics. </p>
    pub google_analytics: std::option::Option<crate::model::GoogleAnalyticsMetadata>,
    /// <p> The connector metadata specific to Infor Nexus. </p>
    pub infor_nexus: std::option::Option<crate::model::InforNexusMetadata>,
    /// <p> The connector metadata specific to Marketo. </p>
    pub marketo: std::option::Option<crate::model::MarketoMetadata>,
    /// <p> The connector metadata specific to Amazon Redshift. </p>
    pub redshift: std::option::Option<crate::model::RedshiftMetadata>,
    /// <p> The connector metadata specific to Amazon S3. </p>
    pub s3: std::option::Option<crate::model::S3Metadata>,
    /// <p> The connector metadata specific to Salesforce. </p>
    pub salesforce: std::option::Option<crate::model::SalesforceMetadata>,
    /// <p> The connector metadata specific to ServiceNow. </p>
    pub service_now: std::option::Option<crate::model::ServiceNowMetadata>,
    /// <p> The connector metadata specific to Singular. </p>
    pub singular: std::option::Option<crate::model::SingularMetadata>,
    /// <p> The connector metadata specific to Slack. </p>
    pub slack: std::option::Option<crate::model::SlackMetadata>,
    /// <p> The connector metadata specific to Snowflake. </p>
    pub snowflake: std::option::Option<crate::model::SnowflakeMetadata>,
    /// <p> The connector metadata specific to Trend Micro. </p>
    pub trendmicro: std::option::Option<crate::model::TrendmicroMetadata>,
    /// <p> The connector metadata specific to Veeva. </p>
    pub veeva: std::option::Option<crate::model::VeevaMetadata>,
    /// <p> The connector metadata specific to Zendesk. </p>
    pub zendesk: std::option::Option<crate::model::ZendeskMetadata>,
    /// <p> The connector metadata specific to Amazon EventBridge. </p>
    pub event_bridge: std::option::Option<crate::model::EventBridgeMetadata>,
    /// <p> The connector metadata specific to Upsolver. </p>
    pub upsolver: std::option::Option<crate::model::UpsolverMetadata>,
    /// <p> The connector metadata specific to Amazon Connect Customer Profiles. </p>
    pub customer_profiles: std::option::Option<crate::model::CustomerProfilesMetadata>,
    /// <p> The connector metadata specific to Amazon Honeycode. </p>
    pub honeycode: std::option::Option<crate::model::HoneycodeMetadata>,
    /// <p> The connector metadata specific to SAPOData. </p>
    pub sapo_data: std::option::Option<crate::model::SapoDataMetadata>,
}
impl ConnectorMetadata {
    /// <p> The connector metadata specific to Amplitude. </p>
    pub fn amplitude(&self) -> std::option::Option<&crate::model::AmplitudeMetadata> {
        self.amplitude.as_ref()
    }
    /// <p> The connector metadata specific to Datadog. </p>
    pub fn datadog(&self) -> std::option::Option<&crate::model::DatadogMetadata> {
        self.datadog.as_ref()
    }
    /// <p> The connector metadata specific to Dynatrace. </p>
    pub fn dynatrace(&self) -> std::option::Option<&crate::model::DynatraceMetadata> {
        self.dynatrace.as_ref()
    }
    /// <p> The connector metadata specific to Google Analytics. </p>
    pub fn google_analytics(&self) -> std::option::Option<&crate::model::GoogleAnalyticsMetadata> {
        self.google_analytics.as_ref()
    }
    /// <p> The connector metadata specific to Infor Nexus. </p>
    pub fn infor_nexus(&self) -> std::option::Option<&crate::model::InforNexusMetadata> {
        self.infor_nexus.as_ref()
    }
    /// <p> The connector metadata specific to Marketo. </p>
    pub fn marketo(&self) -> std::option::Option<&crate::model::MarketoMetadata> {
        self.marketo.as_ref()
    }
    /// <p> The connector metadata specific to Amazon Redshift. </p>
    pub fn redshift(&self) -> std::option::Option<&crate::model::RedshiftMetadata> {
        self.redshift.as_ref()
    }
    /// <p> The connector metadata specific to Amazon S3. </p>
    pub fn s3(&self) -> std::option::Option<&crate::model::S3Metadata> {
        self.s3.as_ref()
    }
    /// <p> The connector metadata specific to Salesforce. </p>
    pub fn salesforce(&self) -> std::option::Option<&crate::model::SalesforceMetadata> {
        self.salesforce.as_ref()
    }
    /// <p> The connector metadata specific to ServiceNow. </p>
    pub fn service_now(&self) -> std::option::Option<&crate::model::ServiceNowMetadata> {
        self.service_now.as_ref()
    }
    /// <p> The connector metadata specific to Singular. </p>
    pub fn singular(&self) -> std::option::Option<&crate::model::SingularMetadata> {
        self.singular.as_ref()
    }
    /// <p> The connector metadata specific to Slack. </p>
    pub fn slack(&self) -> std::option::Option<&crate::model::SlackMetadata> {
        self.slack.as_ref()
    }
    /// <p> The connector metadata specific to Snowflake. </p>
    pub fn snowflake(&self) -> std::option::Option<&crate::model::SnowflakeMetadata> {
        self.snowflake.as_ref()
    }
    /// <p> The connector metadata specific to Trend Micro. </p>
    pub fn trendmicro(&self) -> std::option::Option<&crate::model::TrendmicroMetadata> {
        self.trendmicro.as_ref()
    }
    /// <p> The connector metadata specific to Veeva. </p>
    pub fn veeva(&self) -> std::option::Option<&crate::model::VeevaMetadata> {
        self.veeva.as_ref()
    }
    /// <p> The connector metadata specific to Zendesk. </p>
    pub fn zendesk(&self) -> std::option::Option<&crate::model::ZendeskMetadata> {
        self.zendesk.as_ref()
    }
    /// <p> The connector metadata specific to Amazon EventBridge. </p>
    pub fn event_bridge(&self) -> std::option::Option<&crate::model::EventBridgeMetadata> {
        self.event_bridge.as_ref()
    }
    /// <p> The connector metadata specific to Upsolver. </p>
    pub fn upsolver(&self) -> std::option::Option<&crate::model::UpsolverMetadata> {
        self.upsolver.as_ref()
    }
    /// <p> The connector metadata specific to Amazon Connect Customer Profiles. </p>
    pub fn customer_profiles(
        &self,
    ) -> std::option::Option<&crate::model::CustomerProfilesMetadata> {
        self.customer_profiles.as_ref()
    }
    /// <p> The connector metadata specific to Amazon Honeycode. </p>
    pub fn honeycode(&self) -> std::option::Option<&crate::model::HoneycodeMetadata> {
        self.honeycode.as_ref()
    }
    /// <p> The connector metadata specific to SAPOData. </p>
    pub fn sapo_data(&self) -> std::option::Option<&crate::model::SapoDataMetadata> {
        self.sapo_data.as_ref()
    }
}
impl std::fmt::Debug for ConnectorMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConnectorMetadata");
        formatter.field("amplitude", &self.amplitude);
        formatter.field("datadog", &self.datadog);
        formatter.field("dynatrace", &self.dynatrace);
        formatter.field("google_analytics", &self.google_analytics);
        formatter.field("infor_nexus", &self.infor_nexus);
        formatter.field("marketo", &self.marketo);
        formatter.field("redshift", &self.redshift);
        formatter.field("s3", &self.s3);
        formatter.field("salesforce", &self.salesforce);
        formatter.field("service_now", &self.service_now);
        formatter.field("singular", &self.singular);
        formatter.field("slack", &self.slack);
        formatter.field("snowflake", &self.snowflake);
        formatter.field("trendmicro", &self.trendmicro);
        formatter.field("veeva", &self.veeva);
        formatter.field("zendesk", &self.zendesk);
        formatter.field("event_bridge", &self.event_bridge);
        formatter.field("upsolver", &self.upsolver);
        formatter.field("customer_profiles", &self.customer_profiles);
        formatter.field("honeycode", &self.honeycode);
        formatter.field("sapo_data", &self.sapo_data);
        formatter.finish()
    }
}
/// See [`ConnectorMetadata`](crate::model::ConnectorMetadata)
pub mod connector_metadata {
    /// A builder for [`ConnectorMetadata`](crate::model::ConnectorMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) amplitude: std::option::Option<crate::model::AmplitudeMetadata>,
        pub(crate) datadog: std::option::Option<crate::model::DatadogMetadata>,
        pub(crate) dynatrace: std::option::Option<crate::model::DynatraceMetadata>,
        pub(crate) google_analytics: std::option::Option<crate::model::GoogleAnalyticsMetadata>,
        pub(crate) infor_nexus: std::option::Option<crate::model::InforNexusMetadata>,
        pub(crate) marketo: std::option::Option<crate::model::MarketoMetadata>,
        pub(crate) redshift: std::option::Option<crate::model::RedshiftMetadata>,
        pub(crate) s3: std::option::Option<crate::model::S3Metadata>,
        pub(crate) salesforce: std::option::Option<crate::model::SalesforceMetadata>,
        pub(crate) service_now: std::option::Option<crate::model::ServiceNowMetadata>,
        pub(crate) singular: std::option::Option<crate::model::SingularMetadata>,
        pub(crate) slack: std::option::Option<crate::model::SlackMetadata>,
        pub(crate) snowflake: std::option::Option<crate::model::SnowflakeMetadata>,
        pub(crate) trendmicro: std::option::Option<crate::model::TrendmicroMetadata>,
        pub(crate) veeva: std::option::Option<crate::model::VeevaMetadata>,
        pub(crate) zendesk: std::option::Option<crate::model::ZendeskMetadata>,
        pub(crate) event_bridge: std::option::Option<crate::model::EventBridgeMetadata>,
        pub(crate) upsolver: std::option::Option<crate::model::UpsolverMetadata>,
        pub(crate) customer_profiles: std::option::Option<crate::model::CustomerProfilesMetadata>,
        pub(crate) honeycode: std::option::Option<crate::model::HoneycodeMetadata>,
        pub(crate) sapo_data: std::option::Option<crate::model::SapoDataMetadata>,
    }
    impl Builder {
        /// <p> The connector metadata specific to Amplitude. </p>
        pub fn amplitude(mut self, input: crate::model::AmplitudeMetadata) -> Self {
            self.amplitude = Some(input);
            self
        }
        /// <p> The connector metadata specific to Amplitude. </p>
        pub fn set_amplitude(
            mut self,
            input: std::option::Option<crate::model::AmplitudeMetadata>,
        ) -> Self {
            self.amplitude = input;
            self
        }
        /// <p> The connector metadata specific to Datadog. </p>
        pub fn datadog(mut self, input: crate::model::DatadogMetadata) -> Self {
            self.datadog = Some(input);
            self
        }
        /// <p> The connector metadata specific to Datadog. </p>
        pub fn set_datadog(
            mut self,
            input: std::option::Option<crate::model::DatadogMetadata>,
        ) -> Self {
            self.datadog = input;
            self
        }
        /// <p> The connector metadata specific to Dynatrace. </p>
        pub fn dynatrace(mut self, input: crate::model::DynatraceMetadata) -> Self {
            self.dynatrace = Some(input);
            self
        }
        /// <p> The connector metadata specific to Dynatrace. </p>
        pub fn set_dynatrace(
            mut self,
            input: std::option::Option<crate::model::DynatraceMetadata>,
        ) -> Self {
            self.dynatrace = input;
            self
        }
        /// <p> The connector metadata specific to Google Analytics. </p>
        pub fn google_analytics(mut self, input: crate::model::GoogleAnalyticsMetadata) -> Self {
            self.google_analytics = Some(input);
            self
        }
        /// <p> The connector metadata specific to Google Analytics. </p>
        pub fn set_google_analytics(
            mut self,
            input: std::option::Option<crate::model::GoogleAnalyticsMetadata>,
        ) -> Self {
            self.google_analytics = input;
            self
        }
        /// <p> The connector metadata specific to Infor Nexus. </p>
        pub fn infor_nexus(mut self, input: crate::model::InforNexusMetadata) -> Self {
            self.infor_nexus = Some(input);
            self
        }
        /// <p> The connector metadata specific to Infor Nexus. </p>
        pub fn set_infor_nexus(
            mut self,
            input: std::option::Option<crate::model::InforNexusMetadata>,
        ) -> Self {
            self.infor_nexus = input;
            self
        }
        /// <p> The connector metadata specific to Marketo. </p>
        pub fn marketo(mut self, input: crate::model::MarketoMetadata) -> Self {
            self.marketo = Some(input);
            self
        }
        /// <p> The connector metadata specific to Marketo. </p>
        pub fn set_marketo(
            mut self,
            input: std::option::Option<crate::model::MarketoMetadata>,
        ) -> Self {
            self.marketo = input;
            self
        }
        /// <p> The connector metadata specific to Amazon Redshift. </p>
        pub fn redshift(mut self, input: crate::model::RedshiftMetadata) -> Self {
            self.redshift = Some(input);
            self
        }
        /// <p> The connector metadata specific to Amazon Redshift. </p>
        pub fn set_redshift(
            mut self,
            input: std::option::Option<crate::model::RedshiftMetadata>,
        ) -> Self {
            self.redshift = input;
            self
        }
        /// <p> The connector metadata specific to Amazon S3. </p>
        pub fn s3(mut self, input: crate::model::S3Metadata) -> Self {
            self.s3 = Some(input);
            self
        }
        /// <p> The connector metadata specific to Amazon S3. </p>
        pub fn set_s3(mut self, input: std::option::Option<crate::model::S3Metadata>) -> Self {
            self.s3 = input;
            self
        }
        /// <p> The connector metadata specific to Salesforce. </p>
        pub fn salesforce(mut self, input: crate::model::SalesforceMetadata) -> Self {
            self.salesforce = Some(input);
            self
        }
        /// <p> The connector metadata specific to Salesforce. </p>
        pub fn set_salesforce(
            mut self,
            input: std::option::Option<crate::model::SalesforceMetadata>,
        ) -> Self {
            self.salesforce = input;
            self
        }
        /// <p> The connector metadata specific to ServiceNow. </p>
        pub fn service_now(mut self, input: crate::model::ServiceNowMetadata) -> Self {
            self.service_now = Some(input);
            self
        }
        /// <p> The connector metadata specific to ServiceNow. </p>
        pub fn set_service_now(
            mut self,
            input: std::option::Option<crate::model::ServiceNowMetadata>,
        ) -> Self {
            self.service_now = input;
            self
        }
        /// <p> The connector metadata specific to Singular. </p>
        pub fn singular(mut self, input: crate::model::SingularMetadata) -> Self {
            self.singular = Some(input);
            self
        }
        /// <p> The connector metadata specific to Singular. </p>
        pub fn set_singular(
            mut self,
            input: std::option::Option<crate::model::SingularMetadata>,
        ) -> Self {
            self.singular = input;
            self
        }
        /// <p> The connector metadata specific to Slack. </p>
        pub fn slack(mut self, input: crate::model::SlackMetadata) -> Self {
            self.slack = Some(input);
            self
        }
        /// <p> The connector metadata specific to Slack. </p>
        pub fn set_slack(
            mut self,
            input: std::option::Option<crate::model::SlackMetadata>,
        ) -> Self {
            self.slack = input;
            self
        }
        /// <p> The connector metadata specific to Snowflake. </p>
        pub fn snowflake(mut self, input: crate::model::SnowflakeMetadata) -> Self {
            self.snowflake = Some(input);
            self
        }
        /// <p> The connector metadata specific to Snowflake. </p>
        pub fn set_snowflake(
            mut self,
            input: std::option::Option<crate::model::SnowflakeMetadata>,
        ) -> Self {
            self.snowflake = input;
            self
        }
        /// <p> The connector metadata specific to Trend Micro. </p>
        pub fn trendmicro(mut self, input: crate::model::TrendmicroMetadata) -> Self {
            self.trendmicro = Some(input);
            self
        }
        /// <p> The connector metadata specific to Trend Micro. </p>
        pub fn set_trendmicro(
            mut self,
            input: std::option::Option<crate::model::TrendmicroMetadata>,
        ) -> Self {
            self.trendmicro = input;
            self
        }
        /// <p> The connector metadata specific to Veeva. </p>
        pub fn veeva(mut self, input: crate::model::VeevaMetadata) -> Self {
            self.veeva = Some(input);
            self
        }
        /// <p> The connector metadata specific to Veeva. </p>
        pub fn set_veeva(
            mut self,
            input: std::option::Option<crate::model::VeevaMetadata>,
        ) -> Self {
            self.veeva = input;
            self
        }
        /// <p> The connector metadata specific to Zendesk. </p>
        pub fn zendesk(mut self, input: crate::model::ZendeskMetadata) -> Self {
            self.zendesk = Some(input);
            self
        }
        /// <p> The connector metadata specific to Zendesk. </p>
        pub fn set_zendesk(
            mut self,
            input: std::option::Option<crate::model::ZendeskMetadata>,
        ) -> Self {
            self.zendesk = input;
            self
        }
        /// <p> The connector metadata specific to Amazon EventBridge. </p>
        pub fn event_bridge(mut self, input: crate::model::EventBridgeMetadata) -> Self {
            self.event_bridge = Some(input);
            self
        }
        /// <p> The connector metadata specific to Amazon EventBridge. </p>
        pub fn set_event_bridge(
            mut self,
            input: std::option::Option<crate::model::EventBridgeMetadata>,
        ) -> Self {
            self.event_bridge = input;
            self
        }
        /// <p> The connector metadata specific to Upsolver. </p>
        pub fn upsolver(mut self, input: crate::model::UpsolverMetadata) -> Self {
            self.upsolver = Some(input);
            self
        }
        /// <p> The connector metadata specific to Upsolver. </p>
        pub fn set_upsolver(
            mut self,
            input: std::option::Option<crate::model::UpsolverMetadata>,
        ) -> Self {
            self.upsolver = input;
            self
        }
        /// <p> The connector metadata specific to Amazon Connect Customer Profiles. </p>
        pub fn customer_profiles(mut self, input: crate::model::CustomerProfilesMetadata) -> Self {
            self.customer_profiles = Some(input);
            self
        }
        /// <p> The connector metadata specific to Amazon Connect Customer Profiles. </p>
        pub fn set_customer_profiles(
            mut self,
            input: std::option::Option<crate::model::CustomerProfilesMetadata>,
        ) -> Self {
            self.customer_profiles = input;
            self
        }
        /// <p> The connector metadata specific to Amazon Honeycode. </p>
        pub fn honeycode(mut self, input: crate::model::HoneycodeMetadata) -> Self {
            self.honeycode = Some(input);
            self
        }
        /// <p> The connector metadata specific to Amazon Honeycode. </p>
        pub fn set_honeycode(
            mut self,
            input: std::option::Option<crate::model::HoneycodeMetadata>,
        ) -> Self {
            self.honeycode = input;
            self
        }
        /// <p> The connector metadata specific to SAPOData. </p>
        pub fn sapo_data(mut self, input: crate::model::SapoDataMetadata) -> Self {
            self.sapo_data = Some(input);
            self
        }
        /// <p> The connector metadata specific to SAPOData. </p>
        pub fn set_sapo_data(
            mut self,
            input: std::option::Option<crate::model::SapoDataMetadata>,
        ) -> Self {
            self.sapo_data = input;
            self
        }
        /// Consumes the builder and constructs a [`ConnectorMetadata`](crate::model::ConnectorMetadata)
        pub fn build(self) -> crate::model::ConnectorMetadata {
            crate::model::ConnectorMetadata {
                amplitude: self.amplitude,
                datadog: self.datadog,
                dynatrace: self.dynatrace,
                google_analytics: self.google_analytics,
                infor_nexus: self.infor_nexus,
                marketo: self.marketo,
                redshift: self.redshift,
                s3: self.s3,
                salesforce: self.salesforce,
                service_now: self.service_now,
                singular: self.singular,
                slack: self.slack,
                snowflake: self.snowflake,
                trendmicro: self.trendmicro,
                veeva: self.veeva,
                zendesk: self.zendesk,
                event_bridge: self.event_bridge,
                upsolver: self.upsolver,
                customer_profiles: self.customer_profiles,
                honeycode: self.honeycode,
                sapo_data: self.sapo_data,
            }
        }
    }
}
impl ConnectorMetadata {
    /// Creates a new builder-style object to manufacture [`ConnectorMetadata`](crate::model::ConnectorMetadata)
    pub fn builder() -> crate::model::connector_metadata::Builder {
        crate::model::connector_metadata::Builder::default()
    }
}

/// <p> The connector metadata specific to SAPOData. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SapoDataMetadata {}
impl std::fmt::Debug for SapoDataMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SapoDataMetadata");
        formatter.finish()
    }
}
/// See [`SapoDataMetadata`](crate::model::SapoDataMetadata)
pub mod sapo_data_metadata {
    /// A builder for [`SapoDataMetadata`](crate::model::SapoDataMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`SapoDataMetadata`](crate::model::SapoDataMetadata)
        pub fn build(self) -> crate::model::SapoDataMetadata {
            crate::model::SapoDataMetadata {}
        }
    }
}
impl SapoDataMetadata {
    /// Creates a new builder-style object to manufacture [`SapoDataMetadata`](crate::model::SapoDataMetadata)
    pub fn builder() -> crate::model::sapo_data_metadata::Builder {
        crate::model::sapo_data_metadata::Builder::default()
    }
}

/// <p> The connector metadata specific to Amazon Honeycode. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HoneycodeMetadata {
    /// <p> The desired authorization scope for the Amazon Honeycode account. </p>
    pub o_auth_scopes: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl HoneycodeMetadata {
    /// <p> The desired authorization scope for the Amazon Honeycode account. </p>
    pub fn o_auth_scopes(&self) -> std::option::Option<&[std::string::String]> {
        self.o_auth_scopes.as_deref()
    }
}
impl std::fmt::Debug for HoneycodeMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HoneycodeMetadata");
        formatter.field("o_auth_scopes", &self.o_auth_scopes);
        formatter.finish()
    }
}
/// See [`HoneycodeMetadata`](crate::model::HoneycodeMetadata)
pub mod honeycode_metadata {
    /// A builder for [`HoneycodeMetadata`](crate::model::HoneycodeMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) o_auth_scopes: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `o_auth_scopes`.
        ///
        /// To override the contents of this collection use [`set_o_auth_scopes`](Self::set_o_auth_scopes).
        ///
        /// <p> The desired authorization scope for the Amazon Honeycode account. </p>
        pub fn o_auth_scopes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.o_auth_scopes.unwrap_or_default();
            v.push(input.into());
            self.o_auth_scopes = Some(v);
            self
        }
        /// <p> The desired authorization scope for the Amazon Honeycode account. </p>
        pub fn set_o_auth_scopes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.o_auth_scopes = input;
            self
        }
        /// Consumes the builder and constructs a [`HoneycodeMetadata`](crate::model::HoneycodeMetadata)
        pub fn build(self) -> crate::model::HoneycodeMetadata {
            crate::model::HoneycodeMetadata {
                o_auth_scopes: self.o_auth_scopes,
            }
        }
    }
}
impl HoneycodeMetadata {
    /// Creates a new builder-style object to manufacture [`HoneycodeMetadata`](crate::model::HoneycodeMetadata)
    pub fn builder() -> crate::model::honeycode_metadata::Builder {
        crate::model::honeycode_metadata::Builder::default()
    }
}

/// <p> The connector metadata specific to Amazon Connect Customer Profiles. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomerProfilesMetadata {}
impl std::fmt::Debug for CustomerProfilesMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomerProfilesMetadata");
        formatter.finish()
    }
}
/// See [`CustomerProfilesMetadata`](crate::model::CustomerProfilesMetadata)
pub mod customer_profiles_metadata {
    /// A builder for [`CustomerProfilesMetadata`](crate::model::CustomerProfilesMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CustomerProfilesMetadata`](crate::model::CustomerProfilesMetadata)
        pub fn build(self) -> crate::model::CustomerProfilesMetadata {
            crate::model::CustomerProfilesMetadata {}
        }
    }
}
impl CustomerProfilesMetadata {
    /// Creates a new builder-style object to manufacture [`CustomerProfilesMetadata`](crate::model::CustomerProfilesMetadata)
    pub fn builder() -> crate::model::customer_profiles_metadata::Builder {
        crate::model::customer_profiles_metadata::Builder::default()
    }
}

/// <p> The connector metadata specific to Upsolver. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpsolverMetadata {}
impl std::fmt::Debug for UpsolverMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpsolverMetadata");
        formatter.finish()
    }
}
/// See [`UpsolverMetadata`](crate::model::UpsolverMetadata)
pub mod upsolver_metadata {
    /// A builder for [`UpsolverMetadata`](crate::model::UpsolverMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpsolverMetadata`](crate::model::UpsolverMetadata)
        pub fn build(self) -> crate::model::UpsolverMetadata {
            crate::model::UpsolverMetadata {}
        }
    }
}
impl UpsolverMetadata {
    /// Creates a new builder-style object to manufacture [`UpsolverMetadata`](crate::model::UpsolverMetadata)
    pub fn builder() -> crate::model::upsolver_metadata::Builder {
        crate::model::upsolver_metadata::Builder::default()
    }
}

/// <p> The connector metadata specific to Amazon EventBridge. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventBridgeMetadata {}
impl std::fmt::Debug for EventBridgeMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventBridgeMetadata");
        formatter.finish()
    }
}
/// See [`EventBridgeMetadata`](crate::model::EventBridgeMetadata)
pub mod event_bridge_metadata {
    /// A builder for [`EventBridgeMetadata`](crate::model::EventBridgeMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`EventBridgeMetadata`](crate::model::EventBridgeMetadata)
        pub fn build(self) -> crate::model::EventBridgeMetadata {
            crate::model::EventBridgeMetadata {}
        }
    }
}
impl EventBridgeMetadata {
    /// Creates a new builder-style object to manufacture [`EventBridgeMetadata`](crate::model::EventBridgeMetadata)
    pub fn builder() -> crate::model::event_bridge_metadata::Builder {
        crate::model::event_bridge_metadata::Builder::default()
    }
}

/// <p> The connector metadata specific to Zendesk. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ZendeskMetadata {
    /// <p> The desired authorization scope for the Zendesk account. </p>
    pub o_auth_scopes: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ZendeskMetadata {
    /// <p> The desired authorization scope for the Zendesk account. </p>
    pub fn o_auth_scopes(&self) -> std::option::Option<&[std::string::String]> {
        self.o_auth_scopes.as_deref()
    }
}
impl std::fmt::Debug for ZendeskMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ZendeskMetadata");
        formatter.field("o_auth_scopes", &self.o_auth_scopes);
        formatter.finish()
    }
}
/// See [`ZendeskMetadata`](crate::model::ZendeskMetadata)
pub mod zendesk_metadata {
    /// A builder for [`ZendeskMetadata`](crate::model::ZendeskMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) o_auth_scopes: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `o_auth_scopes`.
        ///
        /// To override the contents of this collection use [`set_o_auth_scopes`](Self::set_o_auth_scopes).
        ///
        /// <p> The desired authorization scope for the Zendesk account. </p>
        pub fn o_auth_scopes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.o_auth_scopes.unwrap_or_default();
            v.push(input.into());
            self.o_auth_scopes = Some(v);
            self
        }
        /// <p> The desired authorization scope for the Zendesk account. </p>
        pub fn set_o_auth_scopes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.o_auth_scopes = input;
            self
        }
        /// Consumes the builder and constructs a [`ZendeskMetadata`](crate::model::ZendeskMetadata)
        pub fn build(self) -> crate::model::ZendeskMetadata {
            crate::model::ZendeskMetadata {
                o_auth_scopes: self.o_auth_scopes,
            }
        }
    }
}
impl ZendeskMetadata {
    /// Creates a new builder-style object to manufacture [`ZendeskMetadata`](crate::model::ZendeskMetadata)
    pub fn builder() -> crate::model::zendesk_metadata::Builder {
        crate::model::zendesk_metadata::Builder::default()
    }
}

/// <p> The connector metadata specific to Veeva. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VeevaMetadata {}
impl std::fmt::Debug for VeevaMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VeevaMetadata");
        formatter.finish()
    }
}
/// See [`VeevaMetadata`](crate::model::VeevaMetadata)
pub mod veeva_metadata {
    /// A builder for [`VeevaMetadata`](crate::model::VeevaMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`VeevaMetadata`](crate::model::VeevaMetadata)
        pub fn build(self) -> crate::model::VeevaMetadata {
            crate::model::VeevaMetadata {}
        }
    }
}
impl VeevaMetadata {
    /// Creates a new builder-style object to manufacture [`VeevaMetadata`](crate::model::VeevaMetadata)
    pub fn builder() -> crate::model::veeva_metadata::Builder {
        crate::model::veeva_metadata::Builder::default()
    }
}

/// <p> The connector metadata specific to Trend Micro. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TrendmicroMetadata {}
impl std::fmt::Debug for TrendmicroMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TrendmicroMetadata");
        formatter.finish()
    }
}
/// See [`TrendmicroMetadata`](crate::model::TrendmicroMetadata)
pub mod trendmicro_metadata {
    /// A builder for [`TrendmicroMetadata`](crate::model::TrendmicroMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TrendmicroMetadata`](crate::model::TrendmicroMetadata)
        pub fn build(self) -> crate::model::TrendmicroMetadata {
            crate::model::TrendmicroMetadata {}
        }
    }
}
impl TrendmicroMetadata {
    /// Creates a new builder-style object to manufacture [`TrendmicroMetadata`](crate::model::TrendmicroMetadata)
    pub fn builder() -> crate::model::trendmicro_metadata::Builder {
        crate::model::trendmicro_metadata::Builder::default()
    }
}

/// <p> The connector metadata specific to Snowflake. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SnowflakeMetadata {
    /// <p> Specifies the supported Amazon Web Services Regions when using Snowflake. </p>
    pub supported_regions: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl SnowflakeMetadata {
    /// <p> Specifies the supported Amazon Web Services Regions when using Snowflake. </p>
    pub fn supported_regions(&self) -> std::option::Option<&[std::string::String]> {
        self.supported_regions.as_deref()
    }
}
impl std::fmt::Debug for SnowflakeMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SnowflakeMetadata");
        formatter.field("supported_regions", &self.supported_regions);
        formatter.finish()
    }
}
/// See [`SnowflakeMetadata`](crate::model::SnowflakeMetadata)
pub mod snowflake_metadata {
    /// A builder for [`SnowflakeMetadata`](crate::model::SnowflakeMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) supported_regions: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `supported_regions`.
        ///
        /// To override the contents of this collection use [`set_supported_regions`](Self::set_supported_regions).
        ///
        /// <p> Specifies the supported Amazon Web Services Regions when using Snowflake. </p>
        pub fn supported_regions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.supported_regions.unwrap_or_default();
            v.push(input.into());
            self.supported_regions = Some(v);
            self
        }
        /// <p> Specifies the supported Amazon Web Services Regions when using Snowflake. </p>
        pub fn set_supported_regions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.supported_regions = input;
            self
        }
        /// Consumes the builder and constructs a [`SnowflakeMetadata`](crate::model::SnowflakeMetadata)
        pub fn build(self) -> crate::model::SnowflakeMetadata {
            crate::model::SnowflakeMetadata {
                supported_regions: self.supported_regions,
            }
        }
    }
}
impl SnowflakeMetadata {
    /// Creates a new builder-style object to manufacture [`SnowflakeMetadata`](crate::model::SnowflakeMetadata)
    pub fn builder() -> crate::model::snowflake_metadata::Builder {
        crate::model::snowflake_metadata::Builder::default()
    }
}

/// <p> The connector metadata specific to Slack. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SlackMetadata {
    /// <p> The desired authorization scope for the Slack account. </p>
    pub o_auth_scopes: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl SlackMetadata {
    /// <p> The desired authorization scope for the Slack account. </p>
    pub fn o_auth_scopes(&self) -> std::option::Option<&[std::string::String]> {
        self.o_auth_scopes.as_deref()
    }
}
impl std::fmt::Debug for SlackMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SlackMetadata");
        formatter.field("o_auth_scopes", &self.o_auth_scopes);
        formatter.finish()
    }
}
/// See [`SlackMetadata`](crate::model::SlackMetadata)
pub mod slack_metadata {
    /// A builder for [`SlackMetadata`](crate::model::SlackMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) o_auth_scopes: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `o_auth_scopes`.
        ///
        /// To override the contents of this collection use [`set_o_auth_scopes`](Self::set_o_auth_scopes).
        ///
        /// <p> The desired authorization scope for the Slack account. </p>
        pub fn o_auth_scopes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.o_auth_scopes.unwrap_or_default();
            v.push(input.into());
            self.o_auth_scopes = Some(v);
            self
        }
        /// <p> The desired authorization scope for the Slack account. </p>
        pub fn set_o_auth_scopes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.o_auth_scopes = input;
            self
        }
        /// Consumes the builder and constructs a [`SlackMetadata`](crate::model::SlackMetadata)
        pub fn build(self) -> crate::model::SlackMetadata {
            crate::model::SlackMetadata {
                o_auth_scopes: self.o_auth_scopes,
            }
        }
    }
}
impl SlackMetadata {
    /// Creates a new builder-style object to manufacture [`SlackMetadata`](crate::model::SlackMetadata)
    pub fn builder() -> crate::model::slack_metadata::Builder {
        crate::model::slack_metadata::Builder::default()
    }
}

/// <p> The connector metadata specific to Singular. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SingularMetadata {}
impl std::fmt::Debug for SingularMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SingularMetadata");
        formatter.finish()
    }
}
/// See [`SingularMetadata`](crate::model::SingularMetadata)
pub mod singular_metadata {
    /// A builder for [`SingularMetadata`](crate::model::SingularMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`SingularMetadata`](crate::model::SingularMetadata)
        pub fn build(self) -> crate::model::SingularMetadata {
            crate::model::SingularMetadata {}
        }
    }
}
impl SingularMetadata {
    /// Creates a new builder-style object to manufacture [`SingularMetadata`](crate::model::SingularMetadata)
    pub fn builder() -> crate::model::singular_metadata::Builder {
        crate::model::singular_metadata::Builder::default()
    }
}

/// <p> The connector metadata specific to ServiceNow. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceNowMetadata {}
impl std::fmt::Debug for ServiceNowMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceNowMetadata");
        formatter.finish()
    }
}
/// See [`ServiceNowMetadata`](crate::model::ServiceNowMetadata)
pub mod service_now_metadata {
    /// A builder for [`ServiceNowMetadata`](crate::model::ServiceNowMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`ServiceNowMetadata`](crate::model::ServiceNowMetadata)
        pub fn build(self) -> crate::model::ServiceNowMetadata {
            crate::model::ServiceNowMetadata {}
        }
    }
}
impl ServiceNowMetadata {
    /// Creates a new builder-style object to manufacture [`ServiceNowMetadata`](crate::model::ServiceNowMetadata)
    pub fn builder() -> crate::model::service_now_metadata::Builder {
        crate::model::service_now_metadata::Builder::default()
    }
}

/// <p> The connector metadata specific to Salesforce. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SalesforceMetadata {
    /// <p> The desired authorization scope for the Salesforce account. </p>
    pub o_auth_scopes: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl SalesforceMetadata {
    /// <p> The desired authorization scope for the Salesforce account. </p>
    pub fn o_auth_scopes(&self) -> std::option::Option<&[std::string::String]> {
        self.o_auth_scopes.as_deref()
    }
}
impl std::fmt::Debug for SalesforceMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SalesforceMetadata");
        formatter.field("o_auth_scopes", &self.o_auth_scopes);
        formatter.finish()
    }
}
/// See [`SalesforceMetadata`](crate::model::SalesforceMetadata)
pub mod salesforce_metadata {
    /// A builder for [`SalesforceMetadata`](crate::model::SalesforceMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) o_auth_scopes: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `o_auth_scopes`.
        ///
        /// To override the contents of this collection use [`set_o_auth_scopes`](Self::set_o_auth_scopes).
        ///
        /// <p> The desired authorization scope for the Salesforce account. </p>
        pub fn o_auth_scopes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.o_auth_scopes.unwrap_or_default();
            v.push(input.into());
            self.o_auth_scopes = Some(v);
            self
        }
        /// <p> The desired authorization scope for the Salesforce account. </p>
        pub fn set_o_auth_scopes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.o_auth_scopes = input;
            self
        }
        /// Consumes the builder and constructs a [`SalesforceMetadata`](crate::model::SalesforceMetadata)
        pub fn build(self) -> crate::model::SalesforceMetadata {
            crate::model::SalesforceMetadata {
                o_auth_scopes: self.o_auth_scopes,
            }
        }
    }
}
impl SalesforceMetadata {
    /// Creates a new builder-style object to manufacture [`SalesforceMetadata`](crate::model::SalesforceMetadata)
    pub fn builder() -> crate::model::salesforce_metadata::Builder {
        crate::model::salesforce_metadata::Builder::default()
    }
}

/// <p> The connector metadata specific to Amazon S3. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3Metadata {}
impl std::fmt::Debug for S3Metadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3Metadata");
        formatter.finish()
    }
}
/// See [`S3Metadata`](crate::model::S3Metadata)
pub mod s3_metadata {
    /// A builder for [`S3Metadata`](crate::model::S3Metadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`S3Metadata`](crate::model::S3Metadata)
        pub fn build(self) -> crate::model::S3Metadata {
            crate::model::S3Metadata {}
        }
    }
}
impl S3Metadata {
    /// Creates a new builder-style object to manufacture [`S3Metadata`](crate::model::S3Metadata)
    pub fn builder() -> crate::model::s3_metadata::Builder {
        crate::model::s3_metadata::Builder::default()
    }
}

/// <p> The connector metadata specific to Amazon Redshift. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RedshiftMetadata {}
impl std::fmt::Debug for RedshiftMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RedshiftMetadata");
        formatter.finish()
    }
}
/// See [`RedshiftMetadata`](crate::model::RedshiftMetadata)
pub mod redshift_metadata {
    /// A builder for [`RedshiftMetadata`](crate::model::RedshiftMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`RedshiftMetadata`](crate::model::RedshiftMetadata)
        pub fn build(self) -> crate::model::RedshiftMetadata {
            crate::model::RedshiftMetadata {}
        }
    }
}
impl RedshiftMetadata {
    /// Creates a new builder-style object to manufacture [`RedshiftMetadata`](crate::model::RedshiftMetadata)
    pub fn builder() -> crate::model::redshift_metadata::Builder {
        crate::model::redshift_metadata::Builder::default()
    }
}

/// <p> The connector metadata specific to Marketo. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MarketoMetadata {}
impl std::fmt::Debug for MarketoMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MarketoMetadata");
        formatter.finish()
    }
}
/// See [`MarketoMetadata`](crate::model::MarketoMetadata)
pub mod marketo_metadata {
    /// A builder for [`MarketoMetadata`](crate::model::MarketoMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`MarketoMetadata`](crate::model::MarketoMetadata)
        pub fn build(self) -> crate::model::MarketoMetadata {
            crate::model::MarketoMetadata {}
        }
    }
}
impl MarketoMetadata {
    /// Creates a new builder-style object to manufacture [`MarketoMetadata`](crate::model::MarketoMetadata)
    pub fn builder() -> crate::model::marketo_metadata::Builder {
        crate::model::marketo_metadata::Builder::default()
    }
}

/// <p> The connector metadata specific to Infor Nexus. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InforNexusMetadata {}
impl std::fmt::Debug for InforNexusMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InforNexusMetadata");
        formatter.finish()
    }
}
/// See [`InforNexusMetadata`](crate::model::InforNexusMetadata)
pub mod infor_nexus_metadata {
    /// A builder for [`InforNexusMetadata`](crate::model::InforNexusMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`InforNexusMetadata`](crate::model::InforNexusMetadata)
        pub fn build(self) -> crate::model::InforNexusMetadata {
            crate::model::InforNexusMetadata {}
        }
    }
}
impl InforNexusMetadata {
    /// Creates a new builder-style object to manufacture [`InforNexusMetadata`](crate::model::InforNexusMetadata)
    pub fn builder() -> crate::model::infor_nexus_metadata::Builder {
        crate::model::infor_nexus_metadata::Builder::default()
    }
}

/// <p> The connector metadata specific to Google Analytics. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GoogleAnalyticsMetadata {
    /// <p> The desired authorization scope for the Google Analytics account. </p>
    pub o_auth_scopes: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl GoogleAnalyticsMetadata {
    /// <p> The desired authorization scope for the Google Analytics account. </p>
    pub fn o_auth_scopes(&self) -> std::option::Option<&[std::string::String]> {
        self.o_auth_scopes.as_deref()
    }
}
impl std::fmt::Debug for GoogleAnalyticsMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GoogleAnalyticsMetadata");
        formatter.field("o_auth_scopes", &self.o_auth_scopes);
        formatter.finish()
    }
}
/// See [`GoogleAnalyticsMetadata`](crate::model::GoogleAnalyticsMetadata)
pub mod google_analytics_metadata {
    /// A builder for [`GoogleAnalyticsMetadata`](crate::model::GoogleAnalyticsMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) o_auth_scopes: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `o_auth_scopes`.
        ///
        /// To override the contents of this collection use [`set_o_auth_scopes`](Self::set_o_auth_scopes).
        ///
        /// <p> The desired authorization scope for the Google Analytics account. </p>
        pub fn o_auth_scopes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.o_auth_scopes.unwrap_or_default();
            v.push(input.into());
            self.o_auth_scopes = Some(v);
            self
        }
        /// <p> The desired authorization scope for the Google Analytics account. </p>
        pub fn set_o_auth_scopes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.o_auth_scopes = input;
            self
        }
        /// Consumes the builder and constructs a [`GoogleAnalyticsMetadata`](crate::model::GoogleAnalyticsMetadata)
        pub fn build(self) -> crate::model::GoogleAnalyticsMetadata {
            crate::model::GoogleAnalyticsMetadata {
                o_auth_scopes: self.o_auth_scopes,
            }
        }
    }
}
impl GoogleAnalyticsMetadata {
    /// Creates a new builder-style object to manufacture [`GoogleAnalyticsMetadata`](crate::model::GoogleAnalyticsMetadata)
    pub fn builder() -> crate::model::google_analytics_metadata::Builder {
        crate::model::google_analytics_metadata::Builder::default()
    }
}

/// <p> The connector metadata specific to Dynatrace. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DynatraceMetadata {}
impl std::fmt::Debug for DynatraceMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DynatraceMetadata");
        formatter.finish()
    }
}
/// See [`DynatraceMetadata`](crate::model::DynatraceMetadata)
pub mod dynatrace_metadata {
    /// A builder for [`DynatraceMetadata`](crate::model::DynatraceMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DynatraceMetadata`](crate::model::DynatraceMetadata)
        pub fn build(self) -> crate::model::DynatraceMetadata {
            crate::model::DynatraceMetadata {}
        }
    }
}
impl DynatraceMetadata {
    /// Creates a new builder-style object to manufacture [`DynatraceMetadata`](crate::model::DynatraceMetadata)
    pub fn builder() -> crate::model::dynatrace_metadata::Builder {
        crate::model::dynatrace_metadata::Builder::default()
    }
}

/// <p> The connector metadata specific to Datadog. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DatadogMetadata {}
impl std::fmt::Debug for DatadogMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DatadogMetadata");
        formatter.finish()
    }
}
/// See [`DatadogMetadata`](crate::model::DatadogMetadata)
pub mod datadog_metadata {
    /// A builder for [`DatadogMetadata`](crate::model::DatadogMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DatadogMetadata`](crate::model::DatadogMetadata)
        pub fn build(self) -> crate::model::DatadogMetadata {
            crate::model::DatadogMetadata {}
        }
    }
}
impl DatadogMetadata {
    /// Creates a new builder-style object to manufacture [`DatadogMetadata`](crate::model::DatadogMetadata)
    pub fn builder() -> crate::model::datadog_metadata::Builder {
        crate::model::datadog_metadata::Builder::default()
    }
}

/// <p> The connector metadata specific to Amplitude. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AmplitudeMetadata {}
impl std::fmt::Debug for AmplitudeMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AmplitudeMetadata");
        formatter.finish()
    }
}
/// See [`AmplitudeMetadata`](crate::model::AmplitudeMetadata)
pub mod amplitude_metadata {
    /// A builder for [`AmplitudeMetadata`](crate::model::AmplitudeMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AmplitudeMetadata`](crate::model::AmplitudeMetadata)
        pub fn build(self) -> crate::model::AmplitudeMetadata {
            crate::model::AmplitudeMetadata {}
        }
    }
}
impl AmplitudeMetadata {
    /// Creates a new builder-style object to manufacture [`AmplitudeMetadata`](crate::model::AmplitudeMetadata)
    pub fn builder() -> crate::model::amplitude_metadata::Builder {
        crate::model::amplitude_metadata::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ScheduleFrequencyType {
    #[allow(missing_docs)] // documentation missing in model
    Byminute,
    #[allow(missing_docs)] // documentation missing in model
    Daily,
    #[allow(missing_docs)] // documentation missing in model
    Hourly,
    #[allow(missing_docs)] // documentation missing in model
    Monthly,
    #[allow(missing_docs)] // documentation missing in model
    Once,
    #[allow(missing_docs)] // documentation missing in model
    Weekly,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ScheduleFrequencyType {
    fn from(s: &str) -> Self {
        match s {
            "BYMINUTE" => ScheduleFrequencyType::Byminute,
            "DAILY" => ScheduleFrequencyType::Daily,
            "HOURLY" => ScheduleFrequencyType::Hourly,
            "MONTHLY" => ScheduleFrequencyType::Monthly,
            "ONCE" => ScheduleFrequencyType::Once,
            "WEEKLY" => ScheduleFrequencyType::Weekly,
            other => ScheduleFrequencyType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ScheduleFrequencyType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ScheduleFrequencyType::from(s))
    }
}
impl ScheduleFrequencyType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ScheduleFrequencyType::Byminute => "BYMINUTE",
            ScheduleFrequencyType::Daily => "DAILY",
            ScheduleFrequencyType::Hourly => "HOURLY",
            ScheduleFrequencyType::Monthly => "MONTHLY",
            ScheduleFrequencyType::Once => "ONCE",
            ScheduleFrequencyType::Weekly => "WEEKLY",
            ScheduleFrequencyType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["BYMINUTE", "DAILY", "HOURLY", "MONTHLY", "ONCE", "WEEKLY"]
    }
}
impl AsRef<str> for ScheduleFrequencyType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> Describes an instance of a connector. This includes the provided name, credentials ARN, connection-mode, and so on. To keep the API intuitive and extensible, the fields that are common to all types of connector profiles are explicitly specified at the top level. The rest of the connector-specific properties are available via the <code>connectorProfileProperties</code> field. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConnectorProfile {
    /// <p> The Amazon Resource Name (ARN) of the connector profile. </p>
    pub connector_profile_arn: std::option::Option<std::string::String>,
    /// <p> The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in the Amazon Web Services account. </p>
    pub connector_profile_name: std::option::Option<std::string::String>,
    /// <p> The type of connector, such as Salesforce, Amplitude, and so on. </p>
    pub connector_type: std::option::Option<crate::model::ConnectorType>,
    /// <p>The label for the connector profile being created.</p>
    pub connector_label: std::option::Option<std::string::String>,
    /// <p> Indicates the connection mode and if it is public or private. </p>
    pub connection_mode: std::option::Option<crate::model::ConnectionMode>,
    /// <p> The Amazon Resource Name (ARN) of the connector profile credentials. </p>
    pub credentials_arn: std::option::Option<std::string::String>,
    /// <p> The connector-specific properties of the profile configuration. </p>
    pub connector_profile_properties: std::option::Option<crate::model::ConnectorProfileProperties>,
    /// <p> Specifies when the connector profile was created. </p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> Specifies when the connector profile was last updated. </p>
    pub last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> Specifies the private connection provisioning state. </p>
    pub private_connection_provisioning_state:
        std::option::Option<crate::model::PrivateConnectionProvisioningState>,
}
impl ConnectorProfile {
    /// <p> The Amazon Resource Name (ARN) of the connector profile. </p>
    pub fn connector_profile_arn(&self) -> std::option::Option<&str> {
        self.connector_profile_arn.as_deref()
    }
    /// <p> The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in the Amazon Web Services account. </p>
    pub fn connector_profile_name(&self) -> std::option::Option<&str> {
        self.connector_profile_name.as_deref()
    }
    /// <p> The type of connector, such as Salesforce, Amplitude, and so on. </p>
    pub fn connector_type(&self) -> std::option::Option<&crate::model::ConnectorType> {
        self.connector_type.as_ref()
    }
    /// <p>The label for the connector profile being created.</p>
    pub fn connector_label(&self) -> std::option::Option<&str> {
        self.connector_label.as_deref()
    }
    /// <p> Indicates the connection mode and if it is public or private. </p>
    pub fn connection_mode(&self) -> std::option::Option<&crate::model::ConnectionMode> {
        self.connection_mode.as_ref()
    }
    /// <p> The Amazon Resource Name (ARN) of the connector profile credentials. </p>
    pub fn credentials_arn(&self) -> std::option::Option<&str> {
        self.credentials_arn.as_deref()
    }
    /// <p> The connector-specific properties of the profile configuration. </p>
    pub fn connector_profile_properties(
        &self,
    ) -> std::option::Option<&crate::model::ConnectorProfileProperties> {
        self.connector_profile_properties.as_ref()
    }
    /// <p> Specifies when the connector profile was created. </p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p> Specifies when the connector profile was last updated. </p>
    pub fn last_updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_at.as_ref()
    }
    /// <p> Specifies the private connection provisioning state. </p>
    pub fn private_connection_provisioning_state(
        &self,
    ) -> std::option::Option<&crate::model::PrivateConnectionProvisioningState> {
        self.private_connection_provisioning_state.as_ref()
    }
}
impl std::fmt::Debug for ConnectorProfile {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConnectorProfile");
        formatter.field("connector_profile_arn", &self.connector_profile_arn);
        formatter.field("connector_profile_name", &self.connector_profile_name);
        formatter.field("connector_type", &self.connector_type);
        formatter.field("connector_label", &self.connector_label);
        formatter.field("connection_mode", &self.connection_mode);
        formatter.field("credentials_arn", &self.credentials_arn);
        formatter.field(
            "connector_profile_properties",
            &self.connector_profile_properties,
        );
        formatter.field("created_at", &self.created_at);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.field(
            "private_connection_provisioning_state",
            &self.private_connection_provisioning_state,
        );
        formatter.finish()
    }
}
/// See [`ConnectorProfile`](crate::model::ConnectorProfile)
pub mod connector_profile {
    /// A builder for [`ConnectorProfile`](crate::model::ConnectorProfile)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connector_profile_arn: std::option::Option<std::string::String>,
        pub(crate) connector_profile_name: std::option::Option<std::string::String>,
        pub(crate) connector_type: std::option::Option<crate::model::ConnectorType>,
        pub(crate) connector_label: std::option::Option<std::string::String>,
        pub(crate) connection_mode: std::option::Option<crate::model::ConnectionMode>,
        pub(crate) credentials_arn: std::option::Option<std::string::String>,
        pub(crate) connector_profile_properties:
            std::option::Option<crate::model::ConnectorProfileProperties>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) private_connection_provisioning_state:
            std::option::Option<crate::model::PrivateConnectionProvisioningState>,
    }
    impl Builder {
        /// <p> The Amazon Resource Name (ARN) of the connector profile. </p>
        pub fn connector_profile_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.connector_profile_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the connector profile. </p>
        pub fn set_connector_profile_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connector_profile_arn = input;
            self
        }
        /// <p> The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in the Amazon Web Services account. </p>
        pub fn connector_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.connector_profile_name = Some(input.into());
            self
        }
        /// <p> The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in the Amazon Web Services account. </p>
        pub fn set_connector_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connector_profile_name = input;
            self
        }
        /// <p> The type of connector, such as Salesforce, Amplitude, and so on. </p>
        pub fn connector_type(mut self, input: crate::model::ConnectorType) -> Self {
            self.connector_type = Some(input);
            self
        }
        /// <p> The type of connector, such as Salesforce, Amplitude, and so on. </p>
        pub fn set_connector_type(
            mut self,
            input: std::option::Option<crate::model::ConnectorType>,
        ) -> Self {
            self.connector_type = input;
            self
        }
        /// <p>The label for the connector profile being created.</p>
        pub fn connector_label(mut self, input: impl Into<std::string::String>) -> Self {
            self.connector_label = Some(input.into());
            self
        }
        /// <p>The label for the connector profile being created.</p>
        pub fn set_connector_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connector_label = input;
            self
        }
        /// <p> Indicates the connection mode and if it is public or private. </p>
        pub fn connection_mode(mut self, input: crate::model::ConnectionMode) -> Self {
            self.connection_mode = Some(input);
            self
        }
        /// <p> Indicates the connection mode and if it is public or private. </p>
        pub fn set_connection_mode(
            mut self,
            input: std::option::Option<crate::model::ConnectionMode>,
        ) -> Self {
            self.connection_mode = input;
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the connector profile credentials. </p>
        pub fn credentials_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.credentials_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the connector profile credentials. </p>
        pub fn set_credentials_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.credentials_arn = input;
            self
        }
        /// <p> The connector-specific properties of the profile configuration. </p>
        pub fn connector_profile_properties(
            mut self,
            input: crate::model::ConnectorProfileProperties,
        ) -> Self {
            self.connector_profile_properties = Some(input);
            self
        }
        /// <p> The connector-specific properties of the profile configuration. </p>
        pub fn set_connector_profile_properties(
            mut self,
            input: std::option::Option<crate::model::ConnectorProfileProperties>,
        ) -> Self {
            self.connector_profile_properties = input;
            self
        }
        /// <p> Specifies when the connector profile was created. </p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p> Specifies when the connector profile was created. </p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p> Specifies when the connector profile was last updated. </p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p> Specifies when the connector profile was last updated. </p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// <p> Specifies the private connection provisioning state. </p>
        pub fn private_connection_provisioning_state(
            mut self,
            input: crate::model::PrivateConnectionProvisioningState,
        ) -> Self {
            self.private_connection_provisioning_state = Some(input);
            self
        }
        /// <p> Specifies the private connection provisioning state. </p>
        pub fn set_private_connection_provisioning_state(
            mut self,
            input: std::option::Option<crate::model::PrivateConnectionProvisioningState>,
        ) -> Self {
            self.private_connection_provisioning_state = input;
            self
        }
        /// Consumes the builder and constructs a [`ConnectorProfile`](crate::model::ConnectorProfile)
        pub fn build(self) -> crate::model::ConnectorProfile {
            crate::model::ConnectorProfile {
                connector_profile_arn: self.connector_profile_arn,
                connector_profile_name: self.connector_profile_name,
                connector_type: self.connector_type,
                connector_label: self.connector_label,
                connection_mode: self.connection_mode,
                credentials_arn: self.credentials_arn,
                connector_profile_properties: self.connector_profile_properties,
                created_at: self.created_at,
                last_updated_at: self.last_updated_at,
                private_connection_provisioning_state: self.private_connection_provisioning_state,
            }
        }
    }
}
impl ConnectorProfile {
    /// Creates a new builder-style object to manufacture [`ConnectorProfile`](crate::model::ConnectorProfile)
    pub fn builder() -> crate::model::connector_profile::Builder {
        crate::model::connector_profile::Builder::default()
    }
}

/// <p> Specifies the private connection provisioning state. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PrivateConnectionProvisioningState {
    /// <p> Specifies the private connection provisioning status. </p>
    pub status: std::option::Option<crate::model::PrivateConnectionProvisioningStatus>,
    /// <p> Specifies the private connection provisioning failure reason. </p>
    pub failure_message: std::option::Option<std::string::String>,
    /// <p> Specifies the private connection provisioning failure cause. </p>
    pub failure_cause: std::option::Option<crate::model::PrivateConnectionProvisioningFailureCause>,
}
impl PrivateConnectionProvisioningState {
    /// <p> Specifies the private connection provisioning status. </p>
    pub fn status(
        &self,
    ) -> std::option::Option<&crate::model::PrivateConnectionProvisioningStatus> {
        self.status.as_ref()
    }
    /// <p> Specifies the private connection provisioning failure reason. </p>
    pub fn failure_message(&self) -> std::option::Option<&str> {
        self.failure_message.as_deref()
    }
    /// <p> Specifies the private connection provisioning failure cause. </p>
    pub fn failure_cause(
        &self,
    ) -> std::option::Option<&crate::model::PrivateConnectionProvisioningFailureCause> {
        self.failure_cause.as_ref()
    }
}
impl std::fmt::Debug for PrivateConnectionProvisioningState {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PrivateConnectionProvisioningState");
        formatter.field("status", &self.status);
        formatter.field("failure_message", &self.failure_message);
        formatter.field("failure_cause", &self.failure_cause);
        formatter.finish()
    }
}
/// See [`PrivateConnectionProvisioningState`](crate::model::PrivateConnectionProvisioningState)
pub mod private_connection_provisioning_state {
    /// A builder for [`PrivateConnectionProvisioningState`](crate::model::PrivateConnectionProvisioningState)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::PrivateConnectionProvisioningStatus>,
        pub(crate) failure_message: std::option::Option<std::string::String>,
        pub(crate) failure_cause:
            std::option::Option<crate::model::PrivateConnectionProvisioningFailureCause>,
    }
    impl Builder {
        /// <p> Specifies the private connection provisioning status. </p>
        pub fn status(mut self, input: crate::model::PrivateConnectionProvisioningStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p> Specifies the private connection provisioning status. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::PrivateConnectionProvisioningStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p> Specifies the private connection provisioning failure reason. </p>
        pub fn failure_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_message = Some(input.into());
            self
        }
        /// <p> Specifies the private connection provisioning failure reason. </p>
        pub fn set_failure_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_message = input;
            self
        }
        /// <p> Specifies the private connection provisioning failure cause. </p>
        pub fn failure_cause(
            mut self,
            input: crate::model::PrivateConnectionProvisioningFailureCause,
        ) -> Self {
            self.failure_cause = Some(input);
            self
        }
        /// <p> Specifies the private connection provisioning failure cause. </p>
        pub fn set_failure_cause(
            mut self,
            input: std::option::Option<crate::model::PrivateConnectionProvisioningFailureCause>,
        ) -> Self {
            self.failure_cause = input;
            self
        }
        /// Consumes the builder and constructs a [`PrivateConnectionProvisioningState`](crate::model::PrivateConnectionProvisioningState)
        pub fn build(self) -> crate::model::PrivateConnectionProvisioningState {
            crate::model::PrivateConnectionProvisioningState {
                status: self.status,
                failure_message: self.failure_message,
                failure_cause: self.failure_cause,
            }
        }
    }
}
impl PrivateConnectionProvisioningState {
    /// Creates a new builder-style object to manufacture [`PrivateConnectionProvisioningState`](crate::model::PrivateConnectionProvisioningState)
    pub fn builder() -> crate::model::private_connection_provisioning_state::Builder {
        crate::model::private_connection_provisioning_state::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PrivateConnectionProvisioningFailureCause {
    #[allow(missing_docs)] // documentation missing in model
    AccessDenied,
    #[allow(missing_docs)] // documentation missing in model
    ConnectorAuthentication,
    #[allow(missing_docs)] // documentation missing in model
    ConnectorServer,
    #[allow(missing_docs)] // documentation missing in model
    InternalServer,
    #[allow(missing_docs)] // documentation missing in model
    Validation,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PrivateConnectionProvisioningFailureCause {
    fn from(s: &str) -> Self {
        match s {
            "ACCESS_DENIED" => PrivateConnectionProvisioningFailureCause::AccessDenied,
            "CONNECTOR_AUTHENTICATION" => {
                PrivateConnectionProvisioningFailureCause::ConnectorAuthentication
            }
            "CONNECTOR_SERVER" => PrivateConnectionProvisioningFailureCause::ConnectorServer,
            "INTERNAL_SERVER" => PrivateConnectionProvisioningFailureCause::InternalServer,
            "VALIDATION" => PrivateConnectionProvisioningFailureCause::Validation,
            other => PrivateConnectionProvisioningFailureCause::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PrivateConnectionProvisioningFailureCause {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PrivateConnectionProvisioningFailureCause::from(s))
    }
}
impl PrivateConnectionProvisioningFailureCause {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PrivateConnectionProvisioningFailureCause::AccessDenied => "ACCESS_DENIED",
            PrivateConnectionProvisioningFailureCause::ConnectorAuthentication => {
                "CONNECTOR_AUTHENTICATION"
            }
            PrivateConnectionProvisioningFailureCause::ConnectorServer => "CONNECTOR_SERVER",
            PrivateConnectionProvisioningFailureCause::InternalServer => "INTERNAL_SERVER",
            PrivateConnectionProvisioningFailureCause::Validation => "VALIDATION",
            PrivateConnectionProvisioningFailureCause::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACCESS_DENIED",
            "CONNECTOR_AUTHENTICATION",
            "CONNECTOR_SERVER",
            "INTERNAL_SERVER",
            "VALIDATION",
        ]
    }
}
impl AsRef<str> for PrivateConnectionProvisioningFailureCause {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PrivateConnectionProvisioningStatus {
    #[allow(missing_docs)] // documentation missing in model
    Created,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PrivateConnectionProvisioningStatus {
    fn from(s: &str) -> Self {
        match s {
            "CREATED" => PrivateConnectionProvisioningStatus::Created,
            "FAILED" => PrivateConnectionProvisioningStatus::Failed,
            "PENDING" => PrivateConnectionProvisioningStatus::Pending,
            other => PrivateConnectionProvisioningStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PrivateConnectionProvisioningStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PrivateConnectionProvisioningStatus::from(s))
    }
}
impl PrivateConnectionProvisioningStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PrivateConnectionProvisioningStatus::Created => "CREATED",
            PrivateConnectionProvisioningStatus::Failed => "FAILED",
            PrivateConnectionProvisioningStatus::Pending => "PENDING",
            PrivateConnectionProvisioningStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CREATED", "FAILED", "PENDING"]
    }
}
impl AsRef<str> for PrivateConnectionProvisioningStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> Describes the data model of a connector field. For example, for an <i>account</i> entity, the fields would be <i>account name</i>, <i>account ID</i>, and so on. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConnectorEntityField {
    /// <p> The unique identifier of the connector field. </p>
    pub identifier: std::option::Option<std::string::String>,
    /// <p>The parent identifier of the connector field.</p>
    pub parent_identifier: std::option::Option<std::string::String>,
    /// <p> The label applied to a connector entity field. </p>
    pub label: std::option::Option<std::string::String>,
    /// <p>Booelan value that indicates whether this field can be used as a primary key.</p>
    pub is_primary_key: bool,
    /// <p>Default value that can be assigned to this field.</p>
    pub default_value: std::option::Option<std::string::String>,
    /// <p>Booelan value that indicates whether this field is deprecated or not.</p>
    pub is_deprecated: bool,
    /// <p> Contains details regarding the supported <code>FieldType</code>, including the corresponding <code>filterOperators</code> and <code>supportedValues</code>. </p>
    pub supported_field_type_details: std::option::Option<crate::model::SupportedFieldTypeDetails>,
    /// <p> A description of the connector entity field. </p>
    pub description: std::option::Option<std::string::String>,
    /// <p> The properties that can be applied to a field when the connector is being used as a source. </p>
    pub source_properties: std::option::Option<crate::model::SourceFieldProperties>,
    /// <p> The properties applied to a field when the connector is being used as a destination. </p>
    pub destination_properties: std::option::Option<crate::model::DestinationFieldProperties>,
    /// <p>A map that has specific properties related to the ConnectorEntityField.</p>
    pub custom_properties:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ConnectorEntityField {
    /// <p> The unique identifier of the connector field. </p>
    pub fn identifier(&self) -> std::option::Option<&str> {
        self.identifier.as_deref()
    }
    /// <p>The parent identifier of the connector field.</p>
    pub fn parent_identifier(&self) -> std::option::Option<&str> {
        self.parent_identifier.as_deref()
    }
    /// <p> The label applied to a connector entity field. </p>
    pub fn label(&self) -> std::option::Option<&str> {
        self.label.as_deref()
    }
    /// <p>Booelan value that indicates whether this field can be used as a primary key.</p>
    pub fn is_primary_key(&self) -> bool {
        self.is_primary_key
    }
    /// <p>Default value that can be assigned to this field.</p>
    pub fn default_value(&self) -> std::option::Option<&str> {
        self.default_value.as_deref()
    }
    /// <p>Booelan value that indicates whether this field is deprecated or not.</p>
    pub fn is_deprecated(&self) -> bool {
        self.is_deprecated
    }
    /// <p> Contains details regarding the supported <code>FieldType</code>, including the corresponding <code>filterOperators</code> and <code>supportedValues</code>. </p>
    pub fn supported_field_type_details(
        &self,
    ) -> std::option::Option<&crate::model::SupportedFieldTypeDetails> {
        self.supported_field_type_details.as_ref()
    }
    /// <p> A description of the connector entity field. </p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p> The properties that can be applied to a field when the connector is being used as a source. </p>
    pub fn source_properties(&self) -> std::option::Option<&crate::model::SourceFieldProperties> {
        self.source_properties.as_ref()
    }
    /// <p> The properties applied to a field when the connector is being used as a destination. </p>
    pub fn destination_properties(
        &self,
    ) -> std::option::Option<&crate::model::DestinationFieldProperties> {
        self.destination_properties.as_ref()
    }
    /// <p>A map that has specific properties related to the ConnectorEntityField.</p>
    pub fn custom_properties(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.custom_properties.as_ref()
    }
}
impl std::fmt::Debug for ConnectorEntityField {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConnectorEntityField");
        formatter.field("identifier", &self.identifier);
        formatter.field("parent_identifier", &self.parent_identifier);
        formatter.field("label", &self.label);
        formatter.field("is_primary_key", &self.is_primary_key);
        formatter.field("default_value", &self.default_value);
        formatter.field("is_deprecated", &self.is_deprecated);
        formatter.field(
            "supported_field_type_details",
            &self.supported_field_type_details,
        );
        formatter.field("description", &self.description);
        formatter.field("source_properties", &self.source_properties);
        formatter.field("destination_properties", &self.destination_properties);
        formatter.field("custom_properties", &self.custom_properties);
        formatter.finish()
    }
}
/// See [`ConnectorEntityField`](crate::model::ConnectorEntityField)
pub mod connector_entity_field {
    /// A builder for [`ConnectorEntityField`](crate::model::ConnectorEntityField)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identifier: std::option::Option<std::string::String>,
        pub(crate) parent_identifier: std::option::Option<std::string::String>,
        pub(crate) label: std::option::Option<std::string::String>,
        pub(crate) is_primary_key: std::option::Option<bool>,
        pub(crate) default_value: std::option::Option<std::string::String>,
        pub(crate) is_deprecated: std::option::Option<bool>,
        pub(crate) supported_field_type_details:
            std::option::Option<crate::model::SupportedFieldTypeDetails>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) source_properties: std::option::Option<crate::model::SourceFieldProperties>,
        pub(crate) destination_properties:
            std::option::Option<crate::model::DestinationFieldProperties>,
        pub(crate) custom_properties: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p> The unique identifier of the connector field. </p>
        pub fn identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.identifier = Some(input.into());
            self
        }
        /// <p> The unique identifier of the connector field. </p>
        pub fn set_identifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identifier = input;
            self
        }
        /// <p>The parent identifier of the connector field.</p>
        pub fn parent_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_identifier = Some(input.into());
            self
        }
        /// <p>The parent identifier of the connector field.</p>
        pub fn set_parent_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parent_identifier = input;
            self
        }
        /// <p> The label applied to a connector entity field. </p>
        pub fn label(mut self, input: impl Into<std::string::String>) -> Self {
            self.label = Some(input.into());
            self
        }
        /// <p> The label applied to a connector entity field. </p>
        pub fn set_label(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.label = input;
            self
        }
        /// <p>Booelan value that indicates whether this field can be used as a primary key.</p>
        pub fn is_primary_key(mut self, input: bool) -> Self {
            self.is_primary_key = Some(input);
            self
        }
        /// <p>Booelan value that indicates whether this field can be used as a primary key.</p>
        pub fn set_is_primary_key(mut self, input: std::option::Option<bool>) -> Self {
            self.is_primary_key = input;
            self
        }
        /// <p>Default value that can be assigned to this field.</p>
        pub fn default_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_value = Some(input.into());
            self
        }
        /// <p>Default value that can be assigned to this field.</p>
        pub fn set_default_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_value = input;
            self
        }
        /// <p>Booelan value that indicates whether this field is deprecated or not.</p>
        pub fn is_deprecated(mut self, input: bool) -> Self {
            self.is_deprecated = Some(input);
            self
        }
        /// <p>Booelan value that indicates whether this field is deprecated or not.</p>
        pub fn set_is_deprecated(mut self, input: std::option::Option<bool>) -> Self {
            self.is_deprecated = input;
            self
        }
        /// <p> Contains details regarding the supported <code>FieldType</code>, including the corresponding <code>filterOperators</code> and <code>supportedValues</code>. </p>
        pub fn supported_field_type_details(
            mut self,
            input: crate::model::SupportedFieldTypeDetails,
        ) -> Self {
            self.supported_field_type_details = Some(input);
            self
        }
        /// <p> Contains details regarding the supported <code>FieldType</code>, including the corresponding <code>filterOperators</code> and <code>supportedValues</code>. </p>
        pub fn set_supported_field_type_details(
            mut self,
            input: std::option::Option<crate::model::SupportedFieldTypeDetails>,
        ) -> Self {
            self.supported_field_type_details = input;
            self
        }
        /// <p> A description of the connector entity field. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p> A description of the connector entity field. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p> The properties that can be applied to a field when the connector is being used as a source. </p>
        pub fn source_properties(mut self, input: crate::model::SourceFieldProperties) -> Self {
            self.source_properties = Some(input);
            self
        }
        /// <p> The properties that can be applied to a field when the connector is being used as a source. </p>
        pub fn set_source_properties(
            mut self,
            input: std::option::Option<crate::model::SourceFieldProperties>,
        ) -> Self {
            self.source_properties = input;
            self
        }
        /// <p> The properties applied to a field when the connector is being used as a destination. </p>
        pub fn destination_properties(
            mut self,
            input: crate::model::DestinationFieldProperties,
        ) -> Self {
            self.destination_properties = Some(input);
            self
        }
        /// <p> The properties applied to a field when the connector is being used as a destination. </p>
        pub fn set_destination_properties(
            mut self,
            input: std::option::Option<crate::model::DestinationFieldProperties>,
        ) -> Self {
            self.destination_properties = input;
            self
        }
        /// Adds a key-value pair to `custom_properties`.
        ///
        /// To override the contents of this collection use [`set_custom_properties`](Self::set_custom_properties).
        ///
        /// <p>A map that has specific properties related to the ConnectorEntityField.</p>
        pub fn custom_properties(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.custom_properties.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.custom_properties = Some(hash_map);
            self
        }
        /// <p>A map that has specific properties related to the ConnectorEntityField.</p>
        pub fn set_custom_properties(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.custom_properties = input;
            self
        }
        /// Consumes the builder and constructs a [`ConnectorEntityField`](crate::model::ConnectorEntityField)
        pub fn build(self) -> crate::model::ConnectorEntityField {
            crate::model::ConnectorEntityField {
                identifier: self.identifier,
                parent_identifier: self.parent_identifier,
                label: self.label,
                is_primary_key: self.is_primary_key.unwrap_or_default(),
                default_value: self.default_value,
                is_deprecated: self.is_deprecated.unwrap_or_default(),
                supported_field_type_details: self.supported_field_type_details,
                description: self.description,
                source_properties: self.source_properties,
                destination_properties: self.destination_properties,
                custom_properties: self.custom_properties,
            }
        }
    }
}
impl ConnectorEntityField {
    /// Creates a new builder-style object to manufacture [`ConnectorEntityField`](crate::model::ConnectorEntityField)
    pub fn builder() -> crate::model::connector_entity_field::Builder {
        crate::model::connector_entity_field::Builder::default()
    }
}

/// <p> The properties that can be applied to a field when connector is being used as a destination. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DestinationFieldProperties {
    /// <p> Specifies if the destination field can be created by the current user. </p>
    pub is_creatable: bool,
    /// <p> Specifies if the destination field can have a null value. </p>
    pub is_nullable: bool,
    /// <p> Specifies if the flow run can either insert new rows in the destination field if they do not already exist, or update them if they do. </p>
    pub is_upsertable: bool,
    /// <p> Specifies whether the field can be updated during an <code>UPDATE</code> or <code>UPSERT</code> write operation. </p>
    pub is_updatable: bool,
    /// <p>Specifies whether the field can use the default value during a Create operation.</p>
    pub is_defaulted_on_create: bool,
    /// <p> A list of supported write operations. For each write operation listed, this field can be used in <code>idFieldNames</code> when that write operation is present as a destination option. </p>
    pub supported_write_operations:
        std::option::Option<std::vec::Vec<crate::model::WriteOperationType>>,
}
impl DestinationFieldProperties {
    /// <p> Specifies if the destination field can be created by the current user. </p>
    pub fn is_creatable(&self) -> bool {
        self.is_creatable
    }
    /// <p> Specifies if the destination field can have a null value. </p>
    pub fn is_nullable(&self) -> bool {
        self.is_nullable
    }
    /// <p> Specifies if the flow run can either insert new rows in the destination field if they do not already exist, or update them if they do. </p>
    pub fn is_upsertable(&self) -> bool {
        self.is_upsertable
    }
    /// <p> Specifies whether the field can be updated during an <code>UPDATE</code> or <code>UPSERT</code> write operation. </p>
    pub fn is_updatable(&self) -> bool {
        self.is_updatable
    }
    /// <p>Specifies whether the field can use the default value during a Create operation.</p>
    pub fn is_defaulted_on_create(&self) -> bool {
        self.is_defaulted_on_create
    }
    /// <p> A list of supported write operations. For each write operation listed, this field can be used in <code>idFieldNames</code> when that write operation is present as a destination option. </p>
    pub fn supported_write_operations(
        &self,
    ) -> std::option::Option<&[crate::model::WriteOperationType]> {
        self.supported_write_operations.as_deref()
    }
}
impl std::fmt::Debug for DestinationFieldProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DestinationFieldProperties");
        formatter.field("is_creatable", &self.is_creatable);
        formatter.field("is_nullable", &self.is_nullable);
        formatter.field("is_upsertable", &self.is_upsertable);
        formatter.field("is_updatable", &self.is_updatable);
        formatter.field("is_defaulted_on_create", &self.is_defaulted_on_create);
        formatter.field(
            "supported_write_operations",
            &self.supported_write_operations,
        );
        formatter.finish()
    }
}
/// See [`DestinationFieldProperties`](crate::model::DestinationFieldProperties)
pub mod destination_field_properties {
    /// A builder for [`DestinationFieldProperties`](crate::model::DestinationFieldProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) is_creatable: std::option::Option<bool>,
        pub(crate) is_nullable: std::option::Option<bool>,
        pub(crate) is_upsertable: std::option::Option<bool>,
        pub(crate) is_updatable: std::option::Option<bool>,
        pub(crate) is_defaulted_on_create: std::option::Option<bool>,
        pub(crate) supported_write_operations:
            std::option::Option<std::vec::Vec<crate::model::WriteOperationType>>,
    }
    impl Builder {
        /// <p> Specifies if the destination field can be created by the current user. </p>
        pub fn is_creatable(mut self, input: bool) -> Self {
            self.is_creatable = Some(input);
            self
        }
        /// <p> Specifies if the destination field can be created by the current user. </p>
        pub fn set_is_creatable(mut self, input: std::option::Option<bool>) -> Self {
            self.is_creatable = input;
            self
        }
        /// <p> Specifies if the destination field can have a null value. </p>
        pub fn is_nullable(mut self, input: bool) -> Self {
            self.is_nullable = Some(input);
            self
        }
        /// <p> Specifies if the destination field can have a null value. </p>
        pub fn set_is_nullable(mut self, input: std::option::Option<bool>) -> Self {
            self.is_nullable = input;
            self
        }
        /// <p> Specifies if the flow run can either insert new rows in the destination field if they do not already exist, or update them if they do. </p>
        pub fn is_upsertable(mut self, input: bool) -> Self {
            self.is_upsertable = Some(input);
            self
        }
        /// <p> Specifies if the flow run can either insert new rows in the destination field if they do not already exist, or update them if they do. </p>
        pub fn set_is_upsertable(mut self, input: std::option::Option<bool>) -> Self {
            self.is_upsertable = input;
            self
        }
        /// <p> Specifies whether the field can be updated during an <code>UPDATE</code> or <code>UPSERT</code> write operation. </p>
        pub fn is_updatable(mut self, input: bool) -> Self {
            self.is_updatable = Some(input);
            self
        }
        /// <p> Specifies whether the field can be updated during an <code>UPDATE</code> or <code>UPSERT</code> write operation. </p>
        pub fn set_is_updatable(mut self, input: std::option::Option<bool>) -> Self {
            self.is_updatable = input;
            self
        }
        /// <p>Specifies whether the field can use the default value during a Create operation.</p>
        pub fn is_defaulted_on_create(mut self, input: bool) -> Self {
            self.is_defaulted_on_create = Some(input);
            self
        }
        /// <p>Specifies whether the field can use the default value during a Create operation.</p>
        pub fn set_is_defaulted_on_create(mut self, input: std::option::Option<bool>) -> Self {
            self.is_defaulted_on_create = input;
            self
        }
        /// Appends an item to `supported_write_operations`.
        ///
        /// To override the contents of this collection use [`set_supported_write_operations`](Self::set_supported_write_operations).
        ///
        /// <p> A list of supported write operations. For each write operation listed, this field can be used in <code>idFieldNames</code> when that write operation is present as a destination option. </p>
        pub fn supported_write_operations(
            mut self,
            input: crate::model::WriteOperationType,
        ) -> Self {
            let mut v = self.supported_write_operations.unwrap_or_default();
            v.push(input);
            self.supported_write_operations = Some(v);
            self
        }
        /// <p> A list of supported write operations. For each write operation listed, this field can be used in <code>idFieldNames</code> when that write operation is present as a destination option. </p>
        pub fn set_supported_write_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::WriteOperationType>>,
        ) -> Self {
            self.supported_write_operations = input;
            self
        }
        /// Consumes the builder and constructs a [`DestinationFieldProperties`](crate::model::DestinationFieldProperties)
        pub fn build(self) -> crate::model::DestinationFieldProperties {
            crate::model::DestinationFieldProperties {
                is_creatable: self.is_creatable.unwrap_or_default(),
                is_nullable: self.is_nullable.unwrap_or_default(),
                is_upsertable: self.is_upsertable.unwrap_or_default(),
                is_updatable: self.is_updatable.unwrap_or_default(),
                is_defaulted_on_create: self.is_defaulted_on_create.unwrap_or_default(),
                supported_write_operations: self.supported_write_operations,
            }
        }
    }
}
impl DestinationFieldProperties {
    /// Creates a new builder-style object to manufacture [`DestinationFieldProperties`](crate::model::DestinationFieldProperties)
    pub fn builder() -> crate::model::destination_field_properties::Builder {
        crate::model::destination_field_properties::Builder::default()
    }
}

/// <p> The properties that can be applied to a field when the connector is being used as a source. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SourceFieldProperties {
    /// <p> Indicates whether the field can be returned in a search result. </p>
    pub is_retrievable: bool,
    /// <p> Indicates if the field can be queried. </p>
    pub is_queryable: bool,
    /// <p>Indicates if this timestamp field can be used for incremental queries.</p>
    pub is_timestamp_field_for_incremental_queries: bool,
}
impl SourceFieldProperties {
    /// <p> Indicates whether the field can be returned in a search result. </p>
    pub fn is_retrievable(&self) -> bool {
        self.is_retrievable
    }
    /// <p> Indicates if the field can be queried. </p>
    pub fn is_queryable(&self) -> bool {
        self.is_queryable
    }
    /// <p>Indicates if this timestamp field can be used for incremental queries.</p>
    pub fn is_timestamp_field_for_incremental_queries(&self) -> bool {
        self.is_timestamp_field_for_incremental_queries
    }
}
impl std::fmt::Debug for SourceFieldProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SourceFieldProperties");
        formatter.field("is_retrievable", &self.is_retrievable);
        formatter.field("is_queryable", &self.is_queryable);
        formatter.field(
            "is_timestamp_field_for_incremental_queries",
            &self.is_timestamp_field_for_incremental_queries,
        );
        formatter.finish()
    }
}
/// See [`SourceFieldProperties`](crate::model::SourceFieldProperties)
pub mod source_field_properties {
    /// A builder for [`SourceFieldProperties`](crate::model::SourceFieldProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) is_retrievable: std::option::Option<bool>,
        pub(crate) is_queryable: std::option::Option<bool>,
        pub(crate) is_timestamp_field_for_incremental_queries: std::option::Option<bool>,
    }
    impl Builder {
        /// <p> Indicates whether the field can be returned in a search result. </p>
        pub fn is_retrievable(mut self, input: bool) -> Self {
            self.is_retrievable = Some(input);
            self
        }
        /// <p> Indicates whether the field can be returned in a search result. </p>
        pub fn set_is_retrievable(mut self, input: std::option::Option<bool>) -> Self {
            self.is_retrievable = input;
            self
        }
        /// <p> Indicates if the field can be queried. </p>
        pub fn is_queryable(mut self, input: bool) -> Self {
            self.is_queryable = Some(input);
            self
        }
        /// <p> Indicates if the field can be queried. </p>
        pub fn set_is_queryable(mut self, input: std::option::Option<bool>) -> Self {
            self.is_queryable = input;
            self
        }
        /// <p>Indicates if this timestamp field can be used for incremental queries.</p>
        pub fn is_timestamp_field_for_incremental_queries(mut self, input: bool) -> Self {
            self.is_timestamp_field_for_incremental_queries = Some(input);
            self
        }
        /// <p>Indicates if this timestamp field can be used for incremental queries.</p>
        pub fn set_is_timestamp_field_for_incremental_queries(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.is_timestamp_field_for_incremental_queries = input;
            self
        }
        /// Consumes the builder and constructs a [`SourceFieldProperties`](crate::model::SourceFieldProperties)
        pub fn build(self) -> crate::model::SourceFieldProperties {
            crate::model::SourceFieldProperties {
                is_retrievable: self.is_retrievable.unwrap_or_default(),
                is_queryable: self.is_queryable.unwrap_or_default(),
                is_timestamp_field_for_incremental_queries: self
                    .is_timestamp_field_for_incremental_queries
                    .unwrap_or_default(),
            }
        }
    }
}
impl SourceFieldProperties {
    /// Creates a new builder-style object to manufacture [`SourceFieldProperties`](crate::model::SourceFieldProperties)
    pub fn builder() -> crate::model::source_field_properties::Builder {
        crate::model::source_field_properties::Builder::default()
    }
}

/// <p> Contains details regarding all the supported <code>FieldTypes</code> and their corresponding <code>filterOperators</code> and <code>supportedValues</code>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SupportedFieldTypeDetails {
    /// <p> The initial supported version for <code>fieldType</code>. If this is later changed to a different version, v2 will be introduced. </p>
    pub v1: std::option::Option<crate::model::FieldTypeDetails>,
}
impl SupportedFieldTypeDetails {
    /// <p> The initial supported version for <code>fieldType</code>. If this is later changed to a different version, v2 will be introduced. </p>
    pub fn v1(&self) -> std::option::Option<&crate::model::FieldTypeDetails> {
        self.v1.as_ref()
    }
}
impl std::fmt::Debug for SupportedFieldTypeDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SupportedFieldTypeDetails");
        formatter.field("v1", &self.v1);
        formatter.finish()
    }
}
/// See [`SupportedFieldTypeDetails`](crate::model::SupportedFieldTypeDetails)
pub mod supported_field_type_details {
    /// A builder for [`SupportedFieldTypeDetails`](crate::model::SupportedFieldTypeDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) v1: std::option::Option<crate::model::FieldTypeDetails>,
    }
    impl Builder {
        /// <p> The initial supported version for <code>fieldType</code>. If this is later changed to a different version, v2 will be introduced. </p>
        pub fn v1(mut self, input: crate::model::FieldTypeDetails) -> Self {
            self.v1 = Some(input);
            self
        }
        /// <p> The initial supported version for <code>fieldType</code>. If this is later changed to a different version, v2 will be introduced. </p>
        pub fn set_v1(
            mut self,
            input: std::option::Option<crate::model::FieldTypeDetails>,
        ) -> Self {
            self.v1 = input;
            self
        }
        /// Consumes the builder and constructs a [`SupportedFieldTypeDetails`](crate::model::SupportedFieldTypeDetails)
        pub fn build(self) -> crate::model::SupportedFieldTypeDetails {
            crate::model::SupportedFieldTypeDetails { v1: self.v1 }
        }
    }
}
impl SupportedFieldTypeDetails {
    /// Creates a new builder-style object to manufacture [`SupportedFieldTypeDetails`](crate::model::SupportedFieldTypeDetails)
    pub fn builder() -> crate::model::supported_field_type_details::Builder {
        crate::model::supported_field_type_details::Builder::default()
    }
}

/// <p> Contains details regarding the supported field type and the operators that can be applied for filtering. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FieldTypeDetails {
    /// <p> The type of field, such as string, integer, date, and so on. </p>
    pub field_type: std::option::Option<std::string::String>,
    /// <p> The list of operators supported by a field. </p>
    pub filter_operators: std::option::Option<std::vec::Vec<crate::model::Operator>>,
    /// <p> The list of values that a field can contain. For example, a Boolean <code>fieldType</code> can have two values: "true" and "false". </p>
    pub supported_values: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The regular expression pattern for the field name.</p>
    pub value_regex_pattern: std::option::Option<std::string::String>,
    /// <p>The date format that the field supports.</p>
    pub supported_date_format: std::option::Option<std::string::String>,
    /// <p>The range of values this field can hold.</p>
    pub field_value_range: std::option::Option<crate::model::Range>,
    /// <p>This is the allowable length range for this field's value.</p>
    pub field_length_range: std::option::Option<crate::model::Range>,
}
impl FieldTypeDetails {
    /// <p> The type of field, such as string, integer, date, and so on. </p>
    pub fn field_type(&self) -> std::option::Option<&str> {
        self.field_type.as_deref()
    }
    /// <p> The list of operators supported by a field. </p>
    pub fn filter_operators(&self) -> std::option::Option<&[crate::model::Operator]> {
        self.filter_operators.as_deref()
    }
    /// <p> The list of values that a field can contain. For example, a Boolean <code>fieldType</code> can have two values: "true" and "false". </p>
    pub fn supported_values(&self) -> std::option::Option<&[std::string::String]> {
        self.supported_values.as_deref()
    }
    /// <p>The regular expression pattern for the field name.</p>
    pub fn value_regex_pattern(&self) -> std::option::Option<&str> {
        self.value_regex_pattern.as_deref()
    }
    /// <p>The date format that the field supports.</p>
    pub fn supported_date_format(&self) -> std::option::Option<&str> {
        self.supported_date_format.as_deref()
    }
    /// <p>The range of values this field can hold.</p>
    pub fn field_value_range(&self) -> std::option::Option<&crate::model::Range> {
        self.field_value_range.as_ref()
    }
    /// <p>This is the allowable length range for this field's value.</p>
    pub fn field_length_range(&self) -> std::option::Option<&crate::model::Range> {
        self.field_length_range.as_ref()
    }
}
impl std::fmt::Debug for FieldTypeDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FieldTypeDetails");
        formatter.field("field_type", &self.field_type);
        formatter.field("filter_operators", &self.filter_operators);
        formatter.field("supported_values", &self.supported_values);
        formatter.field("value_regex_pattern", &self.value_regex_pattern);
        formatter.field("supported_date_format", &self.supported_date_format);
        formatter.field("field_value_range", &self.field_value_range);
        formatter.field("field_length_range", &self.field_length_range);
        formatter.finish()
    }
}
/// See [`FieldTypeDetails`](crate::model::FieldTypeDetails)
pub mod field_type_details {
    /// A builder for [`FieldTypeDetails`](crate::model::FieldTypeDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) field_type: std::option::Option<std::string::String>,
        pub(crate) filter_operators: std::option::Option<std::vec::Vec<crate::model::Operator>>,
        pub(crate) supported_values: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) value_regex_pattern: std::option::Option<std::string::String>,
        pub(crate) supported_date_format: std::option::Option<std::string::String>,
        pub(crate) field_value_range: std::option::Option<crate::model::Range>,
        pub(crate) field_length_range: std::option::Option<crate::model::Range>,
    }
    impl Builder {
        /// <p> The type of field, such as string, integer, date, and so on. </p>
        pub fn field_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.field_type = Some(input.into());
            self
        }
        /// <p> The type of field, such as string, integer, date, and so on. </p>
        pub fn set_field_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.field_type = input;
            self
        }
        /// Appends an item to `filter_operators`.
        ///
        /// To override the contents of this collection use [`set_filter_operators`](Self::set_filter_operators).
        ///
        /// <p> The list of operators supported by a field. </p>
        pub fn filter_operators(mut self, input: crate::model::Operator) -> Self {
            let mut v = self.filter_operators.unwrap_or_default();
            v.push(input);
            self.filter_operators = Some(v);
            self
        }
        /// <p> The list of operators supported by a field. </p>
        pub fn set_filter_operators(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Operator>>,
        ) -> Self {
            self.filter_operators = input;
            self
        }
        /// Appends an item to `supported_values`.
        ///
        /// To override the contents of this collection use [`set_supported_values`](Self::set_supported_values).
        ///
        /// <p> The list of values that a field can contain. For example, a Boolean <code>fieldType</code> can have two values: "true" and "false". </p>
        pub fn supported_values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.supported_values.unwrap_or_default();
            v.push(input.into());
            self.supported_values = Some(v);
            self
        }
        /// <p> The list of values that a field can contain. For example, a Boolean <code>fieldType</code> can have two values: "true" and "false". </p>
        pub fn set_supported_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.supported_values = input;
            self
        }
        /// <p>The regular expression pattern for the field name.</p>
        pub fn value_regex_pattern(mut self, input: impl Into<std::string::String>) -> Self {
            self.value_regex_pattern = Some(input.into());
            self
        }
        /// <p>The regular expression pattern for the field name.</p>
        pub fn set_value_regex_pattern(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.value_regex_pattern = input;
            self
        }
        /// <p>The date format that the field supports.</p>
        pub fn supported_date_format(mut self, input: impl Into<std::string::String>) -> Self {
            self.supported_date_format = Some(input.into());
            self
        }
        /// <p>The date format that the field supports.</p>
        pub fn set_supported_date_format(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.supported_date_format = input;
            self
        }
        /// <p>The range of values this field can hold.</p>
        pub fn field_value_range(mut self, input: crate::model::Range) -> Self {
            self.field_value_range = Some(input);
            self
        }
        /// <p>The range of values this field can hold.</p>
        pub fn set_field_value_range(
            mut self,
            input: std::option::Option<crate::model::Range>,
        ) -> Self {
            self.field_value_range = input;
            self
        }
        /// <p>This is the allowable length range for this field's value.</p>
        pub fn field_length_range(mut self, input: crate::model::Range) -> Self {
            self.field_length_range = Some(input);
            self
        }
        /// <p>This is the allowable length range for this field's value.</p>
        pub fn set_field_length_range(
            mut self,
            input: std::option::Option<crate::model::Range>,
        ) -> Self {
            self.field_length_range = input;
            self
        }
        /// Consumes the builder and constructs a [`FieldTypeDetails`](crate::model::FieldTypeDetails)
        pub fn build(self) -> crate::model::FieldTypeDetails {
            crate::model::FieldTypeDetails {
                field_type: self.field_type,
                filter_operators: self.filter_operators,
                supported_values: self.supported_values,
                value_regex_pattern: self.value_regex_pattern,
                supported_date_format: self.supported_date_format,
                field_value_range: self.field_value_range,
                field_length_range: self.field_length_range,
            }
        }
    }
}
impl FieldTypeDetails {
    /// Creates a new builder-style object to manufacture [`FieldTypeDetails`](crate::model::FieldTypeDetails)
    pub fn builder() -> crate::model::field_type_details::Builder {
        crate::model::field_type_details::Builder::default()
    }
}

/// <p>The range of values that the property supports.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Range {
    /// <p>Maximum value supported by the field.</p>
    pub maximum: f64,
    /// <p>Minimum value supported by the field.</p>
    pub minimum: f64,
}
impl Range {
    /// <p>Maximum value supported by the field.</p>
    pub fn maximum(&self) -> f64 {
        self.maximum
    }
    /// <p>Minimum value supported by the field.</p>
    pub fn minimum(&self) -> f64 {
        self.minimum
    }
}
impl std::fmt::Debug for Range {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Range");
        formatter.field("maximum", &self.maximum);
        formatter.field("minimum", &self.minimum);
        formatter.finish()
    }
}
/// See [`Range`](crate::model::Range)
pub mod range {
    /// A builder for [`Range`](crate::model::Range)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) maximum: std::option::Option<f64>,
        pub(crate) minimum: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>Maximum value supported by the field.</p>
        pub fn maximum(mut self, input: f64) -> Self {
            self.maximum = Some(input);
            self
        }
        /// <p>Maximum value supported by the field.</p>
        pub fn set_maximum(mut self, input: std::option::Option<f64>) -> Self {
            self.maximum = input;
            self
        }
        /// <p>Minimum value supported by the field.</p>
        pub fn minimum(mut self, input: f64) -> Self {
            self.minimum = Some(input);
            self
        }
        /// <p>Minimum value supported by the field.</p>
        pub fn set_minimum(mut self, input: std::option::Option<f64>) -> Self {
            self.minimum = input;
            self
        }
        /// Consumes the builder and constructs a [`Range`](crate::model::Range)
        pub fn build(self) -> crate::model::Range {
            crate::model::Range {
                maximum: self.maximum.unwrap_or_default(),
                minimum: self.minimum.unwrap_or_default(),
            }
        }
    }
}
impl Range {
    /// Creates a new builder-style object to manufacture [`Range`](crate::model::Range)
    pub fn builder() -> crate::model::range::Builder {
        crate::model::range::Builder::default()
    }
}
