// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `SandstoneConfigurationServiceLambda`.
///
/// This client allows ergonomic access to a `SandstoneConfigurationServiceLambda`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `CreateConnectorProfile` operation.
    ///
    /// See [`CreateConnectorProfile`](crate::client::fluent_builders::CreateConnectorProfile) for more information about the
    /// operation and its arguments.
    pub fn create_connector_profile(&self) -> fluent_builders::CreateConnectorProfile<C, M, R> {
        fluent_builders::CreateConnectorProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateFlow` operation.
    ///
    /// See [`CreateFlow`](crate::client::fluent_builders::CreateFlow) for more information about the
    /// operation and its arguments.
    pub fn create_flow(&self) -> fluent_builders::CreateFlow<C, M, R> {
        fluent_builders::CreateFlow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteConnectorProfile` operation.
    ///
    /// See [`DeleteConnectorProfile`](crate::client::fluent_builders::DeleteConnectorProfile) for more information about the
    /// operation and its arguments.
    pub fn delete_connector_profile(&self) -> fluent_builders::DeleteConnectorProfile<C, M, R> {
        fluent_builders::DeleteConnectorProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteFlow` operation.
    ///
    /// See [`DeleteFlow`](crate::client::fluent_builders::DeleteFlow) for more information about the
    /// operation and its arguments.
    pub fn delete_flow(&self) -> fluent_builders::DeleteFlow<C, M, R> {
        fluent_builders::DeleteFlow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeConnectorEntity` operation.
    ///
    /// See [`DescribeConnectorEntity`](crate::client::fluent_builders::DescribeConnectorEntity) for more information about the
    /// operation and its arguments.
    pub fn describe_connector_entity(&self) -> fluent_builders::DescribeConnectorEntity<C, M, R> {
        fluent_builders::DescribeConnectorEntity::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeConnectorProfiles` operation.
    ///
    /// See [`DescribeConnectorProfiles`](crate::client::fluent_builders::DescribeConnectorProfiles) for more information about the
    /// operation and its arguments.
    pub fn describe_connector_profiles(
        &self,
    ) -> fluent_builders::DescribeConnectorProfiles<C, M, R> {
        fluent_builders::DescribeConnectorProfiles::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeConnectors` operation.
    ///
    /// See [`DescribeConnectors`](crate::client::fluent_builders::DescribeConnectors) for more information about the
    /// operation and its arguments.
    pub fn describe_connectors(&self) -> fluent_builders::DescribeConnectors<C, M, R> {
        fluent_builders::DescribeConnectors::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeFlow` operation.
    ///
    /// See [`DescribeFlow`](crate::client::fluent_builders::DescribeFlow) for more information about the
    /// operation and its arguments.
    pub fn describe_flow(&self) -> fluent_builders::DescribeFlow<C, M, R> {
        fluent_builders::DescribeFlow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeFlowExecutionRecords` operation.
    ///
    /// See [`DescribeFlowExecutionRecords`](crate::client::fluent_builders::DescribeFlowExecutionRecords) for more information about the
    /// operation and its arguments.
    pub fn describe_flow_execution_records(
        &self,
    ) -> fluent_builders::DescribeFlowExecutionRecords<C, M, R> {
        fluent_builders::DescribeFlowExecutionRecords::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListConnectorEntities` operation.
    ///
    /// See [`ListConnectorEntities`](crate::client::fluent_builders::ListConnectorEntities) for more information about the
    /// operation and its arguments.
    pub fn list_connector_entities(&self) -> fluent_builders::ListConnectorEntities<C, M, R> {
        fluent_builders::ListConnectorEntities::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListFlows` operation.
    ///
    /// See [`ListFlows`](crate::client::fluent_builders::ListFlows) for more information about the
    /// operation and its arguments.
    pub fn list_flows(&self) -> fluent_builders::ListFlows<C, M, R> {
        fluent_builders::ListFlows::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartFlow` operation.
    ///
    /// See [`StartFlow`](crate::client::fluent_builders::StartFlow) for more information about the
    /// operation and its arguments.
    pub fn start_flow(&self) -> fluent_builders::StartFlow<C, M, R> {
        fluent_builders::StartFlow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopFlow` operation.
    ///
    /// See [`StopFlow`](crate::client::fluent_builders::StopFlow) for more information about the
    /// operation and its arguments.
    pub fn stop_flow(&self) -> fluent_builders::StopFlow<C, M, R> {
        fluent_builders::StopFlow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateConnectorProfile` operation.
    ///
    /// See [`UpdateConnectorProfile`](crate::client::fluent_builders::UpdateConnectorProfile) for more information about the
    /// operation and its arguments.
    pub fn update_connector_profile(&self) -> fluent_builders::UpdateConnectorProfile<C, M, R> {
        fluent_builders::UpdateConnectorProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateFlow` operation.
    ///
    /// See [`UpdateFlow`](crate::client::fluent_builders::UpdateFlow) for more information about the
    /// operation and its arguments.
    pub fn update_flow(&self) -> fluent_builders::UpdateFlow<C, M, R> {
        fluent_builders::UpdateFlow::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateConnectorProfile`.
    ///
    /// <p> Creates a new connector profile associated with your Amazon Web Services account. There is a soft quota
    /// of 100 connector profiles per Amazon Web Services account. If you need more connector profiles than this quota
    /// allows, you can submit a request to the Amazon AppFlow team through the Amazon AppFlow support
    /// channel. </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateConnectorProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_connector_profile_input::Builder,
    }
    impl<C, M, R> CreateConnectorProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateConnectorProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateConnectorProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateConnectorProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateConnectorProfileInputOperationOutputAlias,
                crate::output::CreateConnectorProfileOutput,
                crate::error::CreateConnectorProfileError,
                crate::input::CreateConnectorProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the connector profile. The name is unique for each
        /// <code>ConnectorProfile</code> in your Amazon Web Services account. </p>
        pub fn connector_profile_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connector_profile_name(inp);
            self
        }
        /// <p> The name of the connector profile. The name is unique for each
        /// <code>ConnectorProfile</code> in your Amazon Web Services account. </p>
        pub fn set_connector_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connector_profile_name(input);
            self
        }
        /// <p> The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for
        /// encryption. This is required if you do not want to use the Amazon AppFlow-managed KMS key. If
        /// you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key.
        /// </p>
        pub fn kms_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_arn(inp);
            self
        }
        /// <p> The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for
        /// encryption. This is required if you do not want to use the Amazon AppFlow-managed KMS key. If
        /// you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key.
        /// </p>
        pub fn set_kms_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_arn(input);
            self
        }
        /// <p> The type of connector, such as Salesforce, Amplitude, and so on. </p>
        pub fn connector_type(mut self, inp: crate::model::ConnectorType) -> Self {
            self.inner = self.inner.connector_type(inp);
            self
        }
        /// <p> The type of connector, such as Salesforce, Amplitude, and so on. </p>
        pub fn set_connector_type(
            mut self,
            input: std::option::Option<crate::model::ConnectorType>,
        ) -> Self {
            self.inner = self.inner.set_connector_type(input);
            self
        }
        /// <p> Indicates the connection mode and specifies whether it is public or private. Private
        /// flows use Amazon Web Services PrivateLink to route data over Amazon Web Services infrastructure without exposing it to the
        /// public internet. </p>
        pub fn connection_mode(mut self, inp: crate::model::ConnectionMode) -> Self {
            self.inner = self.inner.connection_mode(inp);
            self
        }
        /// <p> Indicates the connection mode and specifies whether it is public or private. Private
        /// flows use Amazon Web Services PrivateLink to route data over Amazon Web Services infrastructure without exposing it to the
        /// public internet. </p>
        pub fn set_connection_mode(
            mut self,
            input: std::option::Option<crate::model::ConnectionMode>,
        ) -> Self {
            self.inner = self.inner.set_connection_mode(input);
            self
        }
        /// <p> Defines the connector-specific configuration and credentials. </p>
        pub fn connector_profile_config(
            mut self,
            inp: crate::model::ConnectorProfileConfig,
        ) -> Self {
            self.inner = self.inner.connector_profile_config(inp);
            self
        }
        /// <p> Defines the connector-specific configuration and credentials. </p>
        pub fn set_connector_profile_config(
            mut self,
            input: std::option::Option<crate::model::ConnectorProfileConfig>,
        ) -> Self {
            self.inner = self.inner.set_connector_profile_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFlow`.
    ///
    /// <p> Enables your application to create a new flow using Amazon AppFlow. You must create a
    /// connector profile before calling this API. Please note that the Request Syntax below shows
    /// syntax for multiple destinations, however, you can only transfer data to one item in this list
    /// at a time. Amazon AppFlow does not currently support flows to multiple destinations at once. </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateFlow<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_flow_input::Builder,
    }
    impl<C, M, R> CreateFlow<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateFlow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFlowOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFlowError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateFlowInputOperationOutputAlias,
                crate::output::CreateFlowOutput,
                crate::error::CreateFlowError,
                crate::input::CreateFlowInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens
        /// (-) only. </p>
        pub fn flow_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_name(inp);
            self
        }
        /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens
        /// (-) only. </p>
        pub fn set_flow_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_flow_name(input);
            self
        }
        /// <p> A description of the flow you want to create. </p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p> A description of the flow you want to create. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p> The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for
        /// encryption. This is required if you do not want to use the Amazon AppFlow-managed KMS key. If
        /// you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key.
        /// </p>
        pub fn kms_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_arn(inp);
            self
        }
        /// <p> The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for
        /// encryption. This is required if you do not want to use the Amazon AppFlow-managed KMS key. If
        /// you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key.
        /// </p>
        pub fn set_kms_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_arn(input);
            self
        }
        /// <p> The trigger settings that determine how and when the flow runs. </p>
        pub fn trigger_config(mut self, inp: crate::model::TriggerConfig) -> Self {
            self.inner = self.inner.trigger_config(inp);
            self
        }
        /// <p> The trigger settings that determine how and when the flow runs. </p>
        pub fn set_trigger_config(
            mut self,
            input: std::option::Option<crate::model::TriggerConfig>,
        ) -> Self {
            self.inner = self.inner.set_trigger_config(input);
            self
        }
        /// <p> The configuration that controls how Amazon AppFlow retrieves data from the source
        /// connector. </p>
        pub fn source_flow_config(mut self, inp: crate::model::SourceFlowConfig) -> Self {
            self.inner = self.inner.source_flow_config(inp);
            self
        }
        /// <p> The configuration that controls how Amazon AppFlow retrieves data from the source
        /// connector. </p>
        pub fn set_source_flow_config(
            mut self,
            input: std::option::Option<crate::model::SourceFlowConfig>,
        ) -> Self {
            self.inner = self.inner.set_source_flow_config(input);
            self
        }
        /// Appends an item to `destinationFlowConfigList`.
        ///
        /// To override the contents of this collection use [`set_destination_flow_config_list`](Self::set_destination_flow_config_list).
        ///
        /// <p> The configuration that controls how Amazon AppFlow places data in the destination
        /// connector. </p>
        pub fn destination_flow_config_list(
            mut self,
            inp: impl Into<crate::model::DestinationFlowConfig>,
        ) -> Self {
            self.inner = self.inner.destination_flow_config_list(inp);
            self
        }
        /// <p> The configuration that controls how Amazon AppFlow places data in the destination
        /// connector. </p>
        pub fn set_destination_flow_config_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DestinationFlowConfig>>,
        ) -> Self {
            self.inner = self.inner.set_destination_flow_config_list(input);
            self
        }
        /// Appends an item to `tasks`.
        ///
        /// To override the contents of this collection use [`set_tasks`](Self::set_tasks).
        ///
        /// <p> A list of tasks that Amazon AppFlow performs while transferring the data in the flow run.
        /// </p>
        pub fn tasks(mut self, inp: impl Into<crate::model::Task>) -> Self {
            self.inner = self.inner.tasks(inp);
            self
        }
        /// <p> A list of tasks that Amazon AppFlow performs while transferring the data in the flow run.
        /// </p>
        pub fn set_tasks(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Task>>,
        ) -> Self {
            self.inner = self.inner.set_tasks(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> The tags used to organize, track, or control access for your flow. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p> The tags used to organize, track, or control access for your flow. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteConnectorProfile`.
    ///
    /// <p> Enables you to delete an existing connector profile. </p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteConnectorProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_connector_profile_input::Builder,
    }
    impl<C, M, R> DeleteConnectorProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteConnectorProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteConnectorProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteConnectorProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteConnectorProfileInputOperationOutputAlias,
                crate::output::DeleteConnectorProfileOutput,
                crate::error::DeleteConnectorProfileError,
                crate::input::DeleteConnectorProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the connector profile. The name is unique for each
        /// <code>ConnectorProfile</code> in your account. </p>
        pub fn connector_profile_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connector_profile_name(inp);
            self
        }
        /// <p> The name of the connector profile. The name is unique for each
        /// <code>ConnectorProfile</code> in your account. </p>
        pub fn set_connector_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connector_profile_name(input);
            self
        }
        /// <p> Indicates whether Amazon AppFlow should delete the profile, even if it is currently in
        /// use in one or more flows. </p>
        pub fn force_delete(mut self, inp: bool) -> Self {
            self.inner = self.inner.force_delete(inp);
            self
        }
        /// <p> Indicates whether Amazon AppFlow should delete the profile, even if it is currently in
        /// use in one or more flows. </p>
        pub fn set_force_delete(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force_delete(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFlow`.
    ///
    /// <p> Enables your application to delete an existing flow. Before deleting the flow, Amazon
    /// AppFlow validates the request by checking the flow configuration and status. You can delete
    /// flows one at a time. </p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteFlow<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_flow_input::Builder,
    }
    impl<C, M, R> DeleteFlow<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteFlow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFlowOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFlowError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteFlowInputOperationOutputAlias,
                crate::output::DeleteFlowOutput,
                crate::error::DeleteFlowError,
                crate::input::DeleteFlowInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens
        /// (-) only. </p>
        pub fn flow_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_name(inp);
            self
        }
        /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens
        /// (-) only. </p>
        pub fn set_flow_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_flow_name(input);
            self
        }
        /// <p> Indicates whether Amazon AppFlow should delete the flow, even if it is currently in use.
        /// </p>
        pub fn force_delete(mut self, inp: bool) -> Self {
            self.inner = self.inner.force_delete(inp);
            self
        }
        /// <p> Indicates whether Amazon AppFlow should delete the flow, even if it is currently in use.
        /// </p>
        pub fn set_force_delete(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force_delete(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeConnectorEntity`.
    ///
    /// <p> Provides details regarding the entity used with the connector, with a description of the
    /// data model for each entity. </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeConnectorEntity<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_connector_entity_input::Builder,
    }
    impl<C, M, R> DescribeConnectorEntity<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeConnectorEntity`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeConnectorEntityOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeConnectorEntityError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeConnectorEntityInputOperationOutputAlias,
                crate::output::DescribeConnectorEntityOutput,
                crate::error::DescribeConnectorEntityError,
                crate::input::DescribeConnectorEntityInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The entity name for that connector. </p>
        pub fn connector_entity_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connector_entity_name(inp);
            self
        }
        /// <p> The entity name for that connector. </p>
        pub fn set_connector_entity_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connector_entity_name(input);
            self
        }
        /// <p> The type of connector application, such as Salesforce, Amplitude, and so on. </p>
        pub fn connector_type(mut self, inp: crate::model::ConnectorType) -> Self {
            self.inner = self.inner.connector_type(inp);
            self
        }
        /// <p> The type of connector application, such as Salesforce, Amplitude, and so on. </p>
        pub fn set_connector_type(
            mut self,
            input: std::option::Option<crate::model::ConnectorType>,
        ) -> Self {
            self.inner = self.inner.set_connector_type(input);
            self
        }
        /// <p> The name of the connector profile. The name is unique for each
        /// <code>ConnectorProfile</code> in the Amazon Web Services account. </p>
        pub fn connector_profile_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connector_profile_name(inp);
            self
        }
        /// <p> The name of the connector profile. The name is unique for each
        /// <code>ConnectorProfile</code> in the Amazon Web Services account. </p>
        pub fn set_connector_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connector_profile_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeConnectorProfiles`.
    ///
    /// <p> Returns a list of <code>connector-profile</code> details matching the provided
    /// <code>connector-profile</code> names and <code>connector-types</code>. Both input lists are
    /// optional, and you can use them to filter the result. </p>
    /// <p>If no names or <code>connector-types</code> are provided, returns all connector profiles
    /// in a paginated form. If there is no match, this operation returns an empty list.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeConnectorProfiles<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_connector_profiles_input::Builder,
    }
    impl<C, M, R> DescribeConnectorProfiles<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeConnectorProfiles`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeConnectorProfilesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeConnectorProfilesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeConnectorProfilesInputOperationOutputAlias,
                crate::output::DescribeConnectorProfilesOutput,
                crate::error::DescribeConnectorProfilesError,
                crate::input::DescribeConnectorProfilesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `connectorProfileNames`.
        ///
        /// To override the contents of this collection use [`set_connector_profile_names`](Self::set_connector_profile_names).
        ///
        /// <p> The name of the connector profile. The name is unique for each
        /// <code>ConnectorProfile</code> in the Amazon Web Services account. </p>
        pub fn connector_profile_names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connector_profile_names(inp);
            self
        }
        /// <p> The name of the connector profile. The name is unique for each
        /// <code>ConnectorProfile</code> in the Amazon Web Services account. </p>
        pub fn set_connector_profile_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_connector_profile_names(input);
            self
        }
        /// <p> The type of connector, such as Salesforce, Amplitude, and so on. </p>
        pub fn connector_type(mut self, inp: crate::model::ConnectorType) -> Self {
            self.inner = self.inner.connector_type(inp);
            self
        }
        /// <p> The type of connector, such as Salesforce, Amplitude, and so on. </p>
        pub fn set_connector_type(
            mut self,
            input: std::option::Option<crate::model::ConnectorType>,
        ) -> Self {
            self.inner = self.inner.set_connector_type(input);
            self
        }
        /// <p> Specifies the maximum number of items that should be returned in the result set. The
        /// default for <code>maxResults</code> is 20 (for all paginated API operations). </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p> Specifies the maximum number of items that should be returned in the result set. The
        /// default for <code>maxResults</code> is 20 (for all paginated API operations). </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p> The pagination token for the next page of data. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p> The pagination token for the next page of data. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeConnectors`.
    ///
    /// <p> Describes the connectors vended by Amazon AppFlow for specified connector types. If you
    /// don't specify a connector type, this operation describes all connectors vended by Amazon
    /// AppFlow. If there are more connectors than can be returned in one page, the response contains
    /// a <code>nextToken</code> object, which can be be passed in to the next call to the
    /// <code>DescribeConnectors</code> API operation to retrieve the next page. </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeConnectors<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_connectors_input::Builder,
    }
    impl<C, M, R> DescribeConnectors<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeConnectors`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeConnectorsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeConnectorsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeConnectorsInputOperationOutputAlias,
                crate::output::DescribeConnectorsOutput,
                crate::error::DescribeConnectorsError,
                crate::input::DescribeConnectorsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `connectorTypes`.
        ///
        /// To override the contents of this collection use [`set_connector_types`](Self::set_connector_types).
        ///
        /// <p> The type of connector, such as Salesforce, Amplitude, and so on. </p>
        pub fn connector_types(mut self, inp: impl Into<crate::model::ConnectorType>) -> Self {
            self.inner = self.inner.connector_types(inp);
            self
        }
        /// <p> The type of connector, such as Salesforce, Amplitude, and so on. </p>
        pub fn set_connector_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConnectorType>>,
        ) -> Self {
            self.inner = self.inner.set_connector_types(input);
            self
        }
        /// <p> The pagination token for the next page of data. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p> The pagination token for the next page of data. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeFlow`.
    ///
    /// <p> Provides a description of the specified flow. </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeFlow<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_flow_input::Builder,
    }
    impl<C, M, R> DescribeFlow<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeFlow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeFlowOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeFlowError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeFlowInputOperationOutputAlias,
                crate::output::DescribeFlowOutput,
                crate::error::DescribeFlowError,
                crate::input::DescribeFlowInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens
        /// (-) only. </p>
        pub fn flow_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_name(inp);
            self
        }
        /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens
        /// (-) only. </p>
        pub fn set_flow_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_flow_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeFlowExecutionRecords`.
    ///
    /// <p> Fetches the execution history of the flow. </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeFlowExecutionRecords<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_flow_execution_records_input::Builder,
    }
    impl<C, M, R> DescribeFlowExecutionRecords<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeFlowExecutionRecords`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeFlowExecutionRecordsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeFlowExecutionRecordsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeFlowExecutionRecordsInputOperationOutputAlias,
                crate::output::DescribeFlowExecutionRecordsOutput,
                crate::error::DescribeFlowExecutionRecordsError,
                crate::input::DescribeFlowExecutionRecordsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens
        /// (-) only. </p>
        pub fn flow_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_name(inp);
            self
        }
        /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens
        /// (-) only. </p>
        pub fn set_flow_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_flow_name(input);
            self
        }
        /// <p> Specifies the maximum number of items that should be returned in the result set. The
        /// default for <code>maxResults</code> is 20 (for all paginated API operations). </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p> Specifies the maximum number of items that should be returned in the result set. The
        /// default for <code>maxResults</code> is 20 (for all paginated API operations). </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p> The pagination token for the next page of data. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p> The pagination token for the next page of data. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListConnectorEntities`.
    ///
    /// <p> Returns the list of available connector entities supported by Amazon AppFlow. For
    /// example, you can query Salesforce for <i>Account</i> and
    /// <i>Opportunity</i> entities, or query ServiceNow for the
    /// <i>Incident</i> entity. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListConnectorEntities<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_connector_entities_input::Builder,
    }
    impl<C, M, R> ListConnectorEntities<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListConnectorEntities`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListConnectorEntitiesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListConnectorEntitiesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListConnectorEntitiesInputOperationOutputAlias,
                crate::output::ListConnectorEntitiesOutput,
                crate::error::ListConnectorEntitiesError,
                crate::input::ListConnectorEntitiesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the connector profile. The name is unique for each
        /// <code>ConnectorProfile</code> in the Amazon Web Services account, and is used to query the downstream
        /// connector. </p>
        pub fn connector_profile_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connector_profile_name(inp);
            self
        }
        /// <p> The name of the connector profile. The name is unique for each
        /// <code>ConnectorProfile</code> in the Amazon Web Services account, and is used to query the downstream
        /// connector. </p>
        pub fn set_connector_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connector_profile_name(input);
            self
        }
        /// <p> The type of connector, such as Salesforce, Amplitude, and so on. </p>
        pub fn connector_type(mut self, inp: crate::model::ConnectorType) -> Self {
            self.inner = self.inner.connector_type(inp);
            self
        }
        /// <p> The type of connector, such as Salesforce, Amplitude, and so on. </p>
        pub fn set_connector_type(
            mut self,
            input: std::option::Option<crate::model::ConnectorType>,
        ) -> Self {
            self.inner = self.inner.set_connector_type(input);
            self
        }
        /// <p> This optional parameter is specific to connector implementation. Some connectors support
        /// multiple levels or categories of entities. You can find out the list of roots for such
        /// providers by sending a request without the <code>entitiesPath</code> parameter. If the
        /// connector supports entities at different roots, this initial request returns the list of
        /// roots. Otherwise, this request returns all entities supported by the provider. </p>
        pub fn entities_path(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entities_path(inp);
            self
        }
        /// <p> This optional parameter is specific to connector implementation. Some connectors support
        /// multiple levels or categories of entities. You can find out the list of roots for such
        /// providers by sending a request without the <code>entitiesPath</code> parameter. If the
        /// connector supports entities at different roots, this initial request returns the list of
        /// roots. Otherwise, this request returns all entities supported by the provider. </p>
        pub fn set_entities_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_entities_path(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFlows`.
    ///
    /// <p> Lists all of the flows associated with your account. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListFlows<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_flows_input::Builder,
    }
    impl<C, M, R> ListFlows<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListFlows`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFlowsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFlowsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListFlowsInputOperationOutputAlias,
                crate::output::ListFlowsOutput,
                crate::error::ListFlowsError,
                crate::input::ListFlowsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> Specifies the maximum number of items that should be returned in the result set. </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p> Specifies the maximum number of items that should be returned in the result set. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p> The pagination token for next page of data. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p> The pagination token for next page of data. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p> Retrieves the tags that are associated with a specified flow. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The Amazon Resource Name (ARN) of the specified flow. </p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the specified flow. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartFlow`.
    ///
    /// <p> Activates an existing flow. For on-demand flows, this operation runs the flow
    /// immediately. For schedule and event-triggered flows, this operation activates the flow. </p>
    #[derive(std::fmt::Debug)]
    pub struct StartFlow<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_flow_input::Builder,
    }
    impl<C, M, R> StartFlow<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartFlow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartFlowOutput,
            aws_smithy_http::result::SdkError<crate::error::StartFlowError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartFlowInputOperationOutputAlias,
                crate::output::StartFlowOutput,
                crate::error::StartFlowError,
                crate::input::StartFlowInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens
        /// (-) only. </p>
        pub fn flow_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_name(inp);
            self
        }
        /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens
        /// (-) only. </p>
        pub fn set_flow_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_flow_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopFlow`.
    ///
    /// <p> Deactivates the existing flow. For on-demand flows, this operation returns an
    /// <code>unsupportedOperationException</code> error message. For schedule and event-triggered
    /// flows, this operation deactivates the flow. </p>
    #[derive(std::fmt::Debug)]
    pub struct StopFlow<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_flow_input::Builder,
    }
    impl<C, M, R> StopFlow<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopFlow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopFlowOutput,
            aws_smithy_http::result::SdkError<crate::error::StopFlowError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopFlowInputOperationOutputAlias,
                crate::output::StopFlowOutput,
                crate::error::StopFlowError,
                crate::input::StopFlowInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens
        /// (-) only. </p>
        pub fn flow_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_name(inp);
            self
        }
        /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens
        /// (-) only. </p>
        pub fn set_flow_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_flow_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p> Applies a tag to the specified flow. </p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The Amazon Resource Name (ARN) of the flow that you want to tag. </p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the flow that you want to tag. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> The tags used to organize, track, or control access for your flow. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p> The tags used to organize, track, or control access for your flow. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p> Removes a tag from the specified flow. </p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The Amazon Resource Name (ARN) of the flow that you want to untag. </p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the flow that you want to untag. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p> The tag keys associated with the tag that you want to remove from your flow. </p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p> The tag keys associated with the tag that you want to remove from your flow. </p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateConnectorProfile`.
    ///
    /// <p> Updates a given connector profile associated with your account. </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateConnectorProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_connector_profile_input::Builder,
    }
    impl<C, M, R> UpdateConnectorProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateConnectorProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateConnectorProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateConnectorProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateConnectorProfileInputOperationOutputAlias,
                crate::output::UpdateConnectorProfileOutput,
                crate::error::UpdateConnectorProfileError,
                crate::input::UpdateConnectorProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the connector profile and is unique for each <code>ConnectorProfile</code> in
        /// the Amazon Web Services account. </p>
        pub fn connector_profile_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connector_profile_name(inp);
            self
        }
        /// <p> The name of the connector profile and is unique for each <code>ConnectorProfile</code> in
        /// the Amazon Web Services account. </p>
        pub fn set_connector_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connector_profile_name(input);
            self
        }
        /// <p> Indicates the connection mode and if it is public or private. </p>
        pub fn connection_mode(mut self, inp: crate::model::ConnectionMode) -> Self {
            self.inner = self.inner.connection_mode(inp);
            self
        }
        /// <p> Indicates the connection mode and if it is public or private. </p>
        pub fn set_connection_mode(
            mut self,
            input: std::option::Option<crate::model::ConnectionMode>,
        ) -> Self {
            self.inner = self.inner.set_connection_mode(input);
            self
        }
        /// <p> Defines the connector-specific profile configuration and credentials. </p>
        pub fn connector_profile_config(
            mut self,
            inp: crate::model::ConnectorProfileConfig,
        ) -> Self {
            self.inner = self.inner.connector_profile_config(inp);
            self
        }
        /// <p> Defines the connector-specific profile configuration and credentials. </p>
        pub fn set_connector_profile_config(
            mut self,
            input: std::option::Option<crate::model::ConnectorProfileConfig>,
        ) -> Self {
            self.inner = self.inner.set_connector_profile_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFlow`.
    ///
    /// <p> Updates an existing flow. </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateFlow<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_flow_input::Builder,
    }
    impl<C, M, R> UpdateFlow<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateFlow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFlowOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFlowError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateFlowInputOperationOutputAlias,
                crate::output::UpdateFlowOutput,
                crate::error::UpdateFlowError,
                crate::input::UpdateFlowInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens
        /// (-) only. </p>
        pub fn flow_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_name(inp);
            self
        }
        /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens
        /// (-) only. </p>
        pub fn set_flow_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_flow_name(input);
            self
        }
        /// <p> A description of the flow. </p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p> A description of the flow. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p> The trigger settings that determine how and when the flow runs. </p>
        pub fn trigger_config(mut self, inp: crate::model::TriggerConfig) -> Self {
            self.inner = self.inner.trigger_config(inp);
            self
        }
        /// <p> The trigger settings that determine how and when the flow runs. </p>
        pub fn set_trigger_config(
            mut self,
            input: std::option::Option<crate::model::TriggerConfig>,
        ) -> Self {
            self.inner = self.inner.set_trigger_config(input);
            self
        }
        /// <p> Contains information about the configuration of the source connector used in the flow.
        /// </p>
        pub fn source_flow_config(mut self, inp: crate::model::SourceFlowConfig) -> Self {
            self.inner = self.inner.source_flow_config(inp);
            self
        }
        /// <p> Contains information about the configuration of the source connector used in the flow.
        /// </p>
        pub fn set_source_flow_config(
            mut self,
            input: std::option::Option<crate::model::SourceFlowConfig>,
        ) -> Self {
            self.inner = self.inner.set_source_flow_config(input);
            self
        }
        /// Appends an item to `destinationFlowConfigList`.
        ///
        /// To override the contents of this collection use [`set_destination_flow_config_list`](Self::set_destination_flow_config_list).
        ///
        /// <p> The configuration that controls how Amazon AppFlow transfers data to the destination
        /// connector. </p>
        pub fn destination_flow_config_list(
            mut self,
            inp: impl Into<crate::model::DestinationFlowConfig>,
        ) -> Self {
            self.inner = self.inner.destination_flow_config_list(inp);
            self
        }
        /// <p> The configuration that controls how Amazon AppFlow transfers data to the destination
        /// connector. </p>
        pub fn set_destination_flow_config_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DestinationFlowConfig>>,
        ) -> Self {
            self.inner = self.inner.set_destination_flow_config_list(input);
            self
        }
        /// Appends an item to `tasks`.
        ///
        /// To override the contents of this collection use [`set_tasks`](Self::set_tasks).
        ///
        /// <p> A list of tasks that Amazon AppFlow performs while transferring the data in the flow run.
        /// </p>
        pub fn tasks(mut self, inp: impl Into<crate::model::Task>) -> Self {
            self.inner = self.inner.tasks(inp);
            self
        }
        /// <p> A list of tasks that Amazon AppFlow performs while transferring the data in the flow run.
        /// </p>
        pub fn set_tasks(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Task>>,
        ) -> Self {
            self.inner = self.inner.set_tasks(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::new(conn)
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::https()
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
