// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFlowOutput {
    /// <p>Indicates the current status of the flow. </p>
    pub flow_status: std::option::Option<crate::model::FlowStatus>,
}
impl UpdateFlowOutput {
    /// <p>Indicates the current status of the flow. </p>
    pub fn flow_status(&self) -> std::option::Option<&crate::model::FlowStatus> {
        self.flow_status.as_ref()
    }
}
impl std::fmt::Debug for UpdateFlowOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFlowOutput");
        formatter.field("flow_status", &self.flow_status);
        formatter.finish()
    }
}
/// See [`UpdateFlowOutput`](crate::output::UpdateFlowOutput)
pub mod update_flow_output {
    /// A builder for [`UpdateFlowOutput`](crate::output::UpdateFlowOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) flow_status: std::option::Option<crate::model::FlowStatus>,
    }
    impl Builder {
        /// <p>Indicates the current status of the flow. </p>
        pub fn flow_status(mut self, input: crate::model::FlowStatus) -> Self {
            self.flow_status = Some(input);
            self
        }
        /// <p>Indicates the current status of the flow. </p>
        pub fn set_flow_status(
            mut self,
            input: std::option::Option<crate::model::FlowStatus>,
        ) -> Self {
            self.flow_status = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFlowOutput`](crate::output::UpdateFlowOutput)
        pub fn build(self) -> crate::output::UpdateFlowOutput {
            crate::output::UpdateFlowOutput {
                flow_status: self.flow_status,
            }
        }
    }
}
impl UpdateFlowOutput {
    /// Creates a new builder-style object to manufacture [`UpdateFlowOutput`](crate::output::UpdateFlowOutput)
    pub fn builder() -> crate::output::update_flow_output::Builder {
        crate::output::update_flow_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateConnectorProfileOutput {
    /// <p> The Amazon Resource Name (ARN) of the connector profile. </p>
    pub connector_profile_arn: std::option::Option<std::string::String>,
}
impl UpdateConnectorProfileOutput {
    /// <p> The Amazon Resource Name (ARN) of the connector profile. </p>
    pub fn connector_profile_arn(&self) -> std::option::Option<&str> {
        self.connector_profile_arn.as_deref()
    }
}
impl std::fmt::Debug for UpdateConnectorProfileOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateConnectorProfileOutput");
        formatter.field("connector_profile_arn", &self.connector_profile_arn);
        formatter.finish()
    }
}
/// See [`UpdateConnectorProfileOutput`](crate::output::UpdateConnectorProfileOutput)
pub mod update_connector_profile_output {
    /// A builder for [`UpdateConnectorProfileOutput`](crate::output::UpdateConnectorProfileOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connector_profile_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The Amazon Resource Name (ARN) of the connector profile. </p>
        pub fn connector_profile_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.connector_profile_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the connector profile. </p>
        pub fn set_connector_profile_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connector_profile_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateConnectorProfileOutput`](crate::output::UpdateConnectorProfileOutput)
        pub fn build(self) -> crate::output::UpdateConnectorProfileOutput {
            crate::output::UpdateConnectorProfileOutput {
                connector_profile_arn: self.connector_profile_arn,
            }
        }
    }
}
impl UpdateConnectorProfileOutput {
    /// Creates a new builder-style object to manufacture [`UpdateConnectorProfileOutput`](crate::output::UpdateConnectorProfileOutput)
    pub fn builder() -> crate::output::update_connector_profile_output::Builder {
        crate::output::update_connector_profile_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopFlowOutput {
    /// <p> The flow's Amazon Resource Name (ARN). </p>
    pub flow_arn: std::option::Option<std::string::String>,
    /// <p> Indicates the current status of the flow. </p>
    pub flow_status: std::option::Option<crate::model::FlowStatus>,
}
impl StopFlowOutput {
    /// <p> The flow's Amazon Resource Name (ARN). </p>
    pub fn flow_arn(&self) -> std::option::Option<&str> {
        self.flow_arn.as_deref()
    }
    /// <p> Indicates the current status of the flow. </p>
    pub fn flow_status(&self) -> std::option::Option<&crate::model::FlowStatus> {
        self.flow_status.as_ref()
    }
}
impl std::fmt::Debug for StopFlowOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopFlowOutput");
        formatter.field("flow_arn", &self.flow_arn);
        formatter.field("flow_status", &self.flow_status);
        formatter.finish()
    }
}
/// See [`StopFlowOutput`](crate::output::StopFlowOutput)
pub mod stop_flow_output {
    /// A builder for [`StopFlowOutput`](crate::output::StopFlowOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) flow_arn: std::option::Option<std::string::String>,
        pub(crate) flow_status: std::option::Option<crate::model::FlowStatus>,
    }
    impl Builder {
        /// <p> The flow's Amazon Resource Name (ARN). </p>
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_arn = Some(input.into());
            self
        }
        /// <p> The flow's Amazon Resource Name (ARN). </p>
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.flow_arn = input;
            self
        }
        /// <p> Indicates the current status of the flow. </p>
        pub fn flow_status(mut self, input: crate::model::FlowStatus) -> Self {
            self.flow_status = Some(input);
            self
        }
        /// <p> Indicates the current status of the flow. </p>
        pub fn set_flow_status(
            mut self,
            input: std::option::Option<crate::model::FlowStatus>,
        ) -> Self {
            self.flow_status = input;
            self
        }
        /// Consumes the builder and constructs a [`StopFlowOutput`](crate::output::StopFlowOutput)
        pub fn build(self) -> crate::output::StopFlowOutput {
            crate::output::StopFlowOutput {
                flow_arn: self.flow_arn,
                flow_status: self.flow_status,
            }
        }
    }
}
impl StopFlowOutput {
    /// Creates a new builder-style object to manufacture [`StopFlowOutput`](crate::output::StopFlowOutput)
    pub fn builder() -> crate::output::stop_flow_output::Builder {
        crate::output::stop_flow_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartFlowOutput {
    /// <p> The flow's Amazon Resource Name (ARN). </p>
    pub flow_arn: std::option::Option<std::string::String>,
    /// <p> Indicates the current status of the flow. </p>
    pub flow_status: std::option::Option<crate::model::FlowStatus>,
    /// <p> Returns the internal execution ID of an on-demand flow when the flow is started. For
    /// scheduled or event-triggered flows, this value is null. </p>
    pub execution_id: std::option::Option<std::string::String>,
}
impl StartFlowOutput {
    /// <p> The flow's Amazon Resource Name (ARN). </p>
    pub fn flow_arn(&self) -> std::option::Option<&str> {
        self.flow_arn.as_deref()
    }
    /// <p> Indicates the current status of the flow. </p>
    pub fn flow_status(&self) -> std::option::Option<&crate::model::FlowStatus> {
        self.flow_status.as_ref()
    }
    /// <p> Returns the internal execution ID of an on-demand flow when the flow is started. For
    /// scheduled or event-triggered flows, this value is null. </p>
    pub fn execution_id(&self) -> std::option::Option<&str> {
        self.execution_id.as_deref()
    }
}
impl std::fmt::Debug for StartFlowOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartFlowOutput");
        formatter.field("flow_arn", &self.flow_arn);
        formatter.field("flow_status", &self.flow_status);
        formatter.field("execution_id", &self.execution_id);
        formatter.finish()
    }
}
/// See [`StartFlowOutput`](crate::output::StartFlowOutput)
pub mod start_flow_output {
    /// A builder for [`StartFlowOutput`](crate::output::StartFlowOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) flow_arn: std::option::Option<std::string::String>,
        pub(crate) flow_status: std::option::Option<crate::model::FlowStatus>,
        pub(crate) execution_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The flow's Amazon Resource Name (ARN). </p>
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_arn = Some(input.into());
            self
        }
        /// <p> The flow's Amazon Resource Name (ARN). </p>
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.flow_arn = input;
            self
        }
        /// <p> Indicates the current status of the flow. </p>
        pub fn flow_status(mut self, input: crate::model::FlowStatus) -> Self {
            self.flow_status = Some(input);
            self
        }
        /// <p> Indicates the current status of the flow. </p>
        pub fn set_flow_status(
            mut self,
            input: std::option::Option<crate::model::FlowStatus>,
        ) -> Self {
            self.flow_status = input;
            self
        }
        /// <p> Returns the internal execution ID of an on-demand flow when the flow is started. For
        /// scheduled or event-triggered flows, this value is null. </p>
        pub fn execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.execution_id = Some(input.into());
            self
        }
        /// <p> Returns the internal execution ID of an on-demand flow when the flow is started. For
        /// scheduled or event-triggered flows, this value is null. </p>
        pub fn set_execution_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.execution_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StartFlowOutput`](crate::output::StartFlowOutput)
        pub fn build(self) -> crate::output::StartFlowOutput {
            crate::output::StartFlowOutput {
                flow_arn: self.flow_arn,
                flow_status: self.flow_status,
                execution_id: self.execution_id,
            }
        }
    }
}
impl StartFlowOutput {
    /// Creates a new builder-style object to manufacture [`StartFlowOutput`](crate::output::StartFlowOutput)
    pub fn builder() -> crate::output::start_flow_output::Builder {
        crate::output::start_flow_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p> The tags used to organize, track, or control access for your flow. </p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ListTagsForResourceOutput {
    /// <p> The tags used to organize, track, or control access for your flow. </p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> The tags used to organize, track, or control access for your flow. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p> The tags used to organize, track, or control access for your flow. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFlowsOutput {
    /// <p> The list of flows associated with your account. </p>
    pub flows: std::option::Option<std::vec::Vec<crate::model::FlowDefinition>>,
    /// <p> The pagination token for next page of data. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListFlowsOutput {
    /// <p> The list of flows associated with your account. </p>
    pub fn flows(&self) -> std::option::Option<&[crate::model::FlowDefinition]> {
        self.flows.as_deref()
    }
    /// <p> The pagination token for next page of data. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListFlowsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFlowsOutput");
        formatter.field("flows", &self.flows);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListFlowsOutput`](crate::output::ListFlowsOutput)
pub mod list_flows_output {
    /// A builder for [`ListFlowsOutput`](crate::output::ListFlowsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) flows: std::option::Option<std::vec::Vec<crate::model::FlowDefinition>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `flows`.
        ///
        /// To override the contents of this collection use [`set_flows`](Self::set_flows).
        ///
        /// <p> The list of flows associated with your account. </p>
        pub fn flows(mut self, input: impl Into<crate::model::FlowDefinition>) -> Self {
            let mut v = self.flows.unwrap_or_default();
            v.push(input.into());
            self.flows = Some(v);
            self
        }
        /// <p> The list of flows associated with your account. </p>
        pub fn set_flows(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FlowDefinition>>,
        ) -> Self {
            self.flows = input;
            self
        }
        /// <p> The pagination token for next page of data. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> The pagination token for next page of data. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFlowsOutput`](crate::output::ListFlowsOutput)
        pub fn build(self) -> crate::output::ListFlowsOutput {
            crate::output::ListFlowsOutput {
                flows: self.flows,
                next_token: self.next_token,
            }
        }
    }
}
impl ListFlowsOutput {
    /// Creates a new builder-style object to manufacture [`ListFlowsOutput`](crate::output::ListFlowsOutput)
    pub fn builder() -> crate::output::list_flows_output::Builder {
        crate::output::list_flows_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListConnectorEntitiesOutput {
    /// <p> The response of <code>ListConnectorEntities</code> lists entities grouped by category.
    /// This map's key represents the group name, and its value contains the list of entities
    /// belonging to that group. </p>
    pub connector_entity_map: std::option::Option<
        std::collections::HashMap<
            std::string::String,
            std::vec::Vec<crate::model::ConnectorEntity>,
        >,
    >,
}
impl ListConnectorEntitiesOutput {
    /// <p> The response of <code>ListConnectorEntities</code> lists entities grouped by category.
    /// This map's key represents the group name, and its value contains the list of entities
    /// belonging to that group. </p>
    pub fn connector_entity_map(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<
            std::string::String,
            std::vec::Vec<crate::model::ConnectorEntity>,
        >,
    > {
        self.connector_entity_map.as_ref()
    }
}
impl std::fmt::Debug for ListConnectorEntitiesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListConnectorEntitiesOutput");
        formatter.field("connector_entity_map", &self.connector_entity_map);
        formatter.finish()
    }
}
/// See [`ListConnectorEntitiesOutput`](crate::output::ListConnectorEntitiesOutput)
pub mod list_connector_entities_output {
    /// A builder for [`ListConnectorEntitiesOutput`](crate::output::ListConnectorEntitiesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connector_entity_map: std::option::Option<
            std::collections::HashMap<
                std::string::String,
                std::vec::Vec<crate::model::ConnectorEntity>,
            >,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `connector_entity_map`.
        ///
        /// To override the contents of this collection use [`set_connector_entity_map`](Self::set_connector_entity_map).
        ///
        /// <p> The response of <code>ListConnectorEntities</code> lists entities grouped by category.
        /// This map's key represents the group name, and its value contains the list of entities
        /// belonging to that group. </p>
        pub fn connector_entity_map(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::vec::Vec<crate::model::ConnectorEntity>>,
        ) -> Self {
            let mut hash_map = self.connector_entity_map.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.connector_entity_map = Some(hash_map);
            self
        }
        /// <p> The response of <code>ListConnectorEntities</code> lists entities grouped by category.
        /// This map's key represents the group name, and its value contains the list of entities
        /// belonging to that group. </p>
        pub fn set_connector_entity_map(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    std::vec::Vec<crate::model::ConnectorEntity>,
                >,
            >,
        ) -> Self {
            self.connector_entity_map = input;
            self
        }
        /// Consumes the builder and constructs a [`ListConnectorEntitiesOutput`](crate::output::ListConnectorEntitiesOutput)
        pub fn build(self) -> crate::output::ListConnectorEntitiesOutput {
            crate::output::ListConnectorEntitiesOutput {
                connector_entity_map: self.connector_entity_map,
            }
        }
    }
}
impl ListConnectorEntitiesOutput {
    /// Creates a new builder-style object to manufacture [`ListConnectorEntitiesOutput`](crate::output::ListConnectorEntitiesOutput)
    pub fn builder() -> crate::output::list_connector_entities_output::Builder {
        crate::output::list_connector_entities_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeFlowExecutionRecordsOutput {
    /// <p> Returns a list of all instances when this flow was run. </p>
    pub flow_executions: std::option::Option<std::vec::Vec<crate::model::ExecutionRecord>>,
    /// <p> The pagination token for the next page of data. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeFlowExecutionRecordsOutput {
    /// <p> Returns a list of all instances when this flow was run. </p>
    pub fn flow_executions(&self) -> std::option::Option<&[crate::model::ExecutionRecord]> {
        self.flow_executions.as_deref()
    }
    /// <p> The pagination token for the next page of data. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeFlowExecutionRecordsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeFlowExecutionRecordsOutput");
        formatter.field("flow_executions", &self.flow_executions);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeFlowExecutionRecordsOutput`](crate::output::DescribeFlowExecutionRecordsOutput)
pub mod describe_flow_execution_records_output {
    /// A builder for [`DescribeFlowExecutionRecordsOutput`](crate::output::DescribeFlowExecutionRecordsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) flow_executions:
            std::option::Option<std::vec::Vec<crate::model::ExecutionRecord>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `flow_executions`.
        ///
        /// To override the contents of this collection use [`set_flow_executions`](Self::set_flow_executions).
        ///
        /// <p> Returns a list of all instances when this flow was run. </p>
        pub fn flow_executions(mut self, input: impl Into<crate::model::ExecutionRecord>) -> Self {
            let mut v = self.flow_executions.unwrap_or_default();
            v.push(input.into());
            self.flow_executions = Some(v);
            self
        }
        /// <p> Returns a list of all instances when this flow was run. </p>
        pub fn set_flow_executions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExecutionRecord>>,
        ) -> Self {
            self.flow_executions = input;
            self
        }
        /// <p> The pagination token for the next page of data. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> The pagination token for the next page of data. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFlowExecutionRecordsOutput`](crate::output::DescribeFlowExecutionRecordsOutput)
        pub fn build(self) -> crate::output::DescribeFlowExecutionRecordsOutput {
            crate::output::DescribeFlowExecutionRecordsOutput {
                flow_executions: self.flow_executions,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeFlowExecutionRecordsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeFlowExecutionRecordsOutput`](crate::output::DescribeFlowExecutionRecordsOutput)
    pub fn builder() -> crate::output::describe_flow_execution_records_output::Builder {
        crate::output::describe_flow_execution_records_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeFlowOutput {
    /// <p> The flow's Amazon Resource Name (ARN). </p>
    pub flow_arn: std::option::Option<std::string::String>,
    /// <p> A description of the flow. </p>
    pub description: std::option::Option<std::string::String>,
    /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens
    /// (-) only. </p>
    pub flow_name: std::option::Option<std::string::String>,
    /// <p> The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for
    /// encryption. This is required if you do not want to use the Amazon AppFlow-managed KMS key. If
    /// you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key.
    /// </p>
    pub kms_arn: std::option::Option<std::string::String>,
    /// <p> Indicates the current status of the flow. </p>
    pub flow_status: std::option::Option<crate::model::FlowStatus>,
    /// <p> Contains an error message if the flow status is in a suspended or error state. This
    /// applies only to scheduled or event-triggered flows. </p>
    pub flow_status_message: std::option::Option<std::string::String>,
    /// <p> The configuration that controls how Amazon AppFlow retrieves data from the source
    /// connector. </p>
    pub source_flow_config: std::option::Option<crate::model::SourceFlowConfig>,
    /// <p> The configuration that controls how Amazon AppFlow transfers data to the destination
    /// connector. </p>
    pub destination_flow_config_list:
        std::option::Option<std::vec::Vec<crate::model::DestinationFlowConfig>>,
    /// <p> Describes the details of the most recent flow run. </p>
    pub last_run_execution_details: std::option::Option<crate::model::ExecutionDetails>,
    /// <p> The trigger settings that determine how and when the flow runs. </p>
    pub trigger_config: std::option::Option<crate::model::TriggerConfig>,
    /// <p> A list of tasks that Amazon AppFlow performs while transferring the data in the flow run.
    /// </p>
    pub tasks: std::option::Option<std::vec::Vec<crate::model::Task>>,
    /// <p> Specifies when the flow was created. </p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p> Specifies when the flow was last updated. </p>
    pub last_updated_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p> The ARN of the user who created the flow. </p>
    pub created_by: std::option::Option<std::string::String>,
    /// <p> Specifies the user name of the account that performed the most recent update. </p>
    pub last_updated_by: std::option::Option<std::string::String>,
    /// <p> The tags used to organize, track, or control access for your flow. </p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl DescribeFlowOutput {
    /// <p> The flow's Amazon Resource Name (ARN). </p>
    pub fn flow_arn(&self) -> std::option::Option<&str> {
        self.flow_arn.as_deref()
    }
    /// <p> A description of the flow. </p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens
    /// (-) only. </p>
    pub fn flow_name(&self) -> std::option::Option<&str> {
        self.flow_name.as_deref()
    }
    /// <p> The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for
    /// encryption. This is required if you do not want to use the Amazon AppFlow-managed KMS key. If
    /// you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key.
    /// </p>
    pub fn kms_arn(&self) -> std::option::Option<&str> {
        self.kms_arn.as_deref()
    }
    /// <p> Indicates the current status of the flow. </p>
    pub fn flow_status(&self) -> std::option::Option<&crate::model::FlowStatus> {
        self.flow_status.as_ref()
    }
    /// <p> Contains an error message if the flow status is in a suspended or error state. This
    /// applies only to scheduled or event-triggered flows. </p>
    pub fn flow_status_message(&self) -> std::option::Option<&str> {
        self.flow_status_message.as_deref()
    }
    /// <p> The configuration that controls how Amazon AppFlow retrieves data from the source
    /// connector. </p>
    pub fn source_flow_config(&self) -> std::option::Option<&crate::model::SourceFlowConfig> {
        self.source_flow_config.as_ref()
    }
    /// <p> The configuration that controls how Amazon AppFlow transfers data to the destination
    /// connector. </p>
    pub fn destination_flow_config_list(
        &self,
    ) -> std::option::Option<&[crate::model::DestinationFlowConfig]> {
        self.destination_flow_config_list.as_deref()
    }
    /// <p> Describes the details of the most recent flow run. </p>
    pub fn last_run_execution_details(
        &self,
    ) -> std::option::Option<&crate::model::ExecutionDetails> {
        self.last_run_execution_details.as_ref()
    }
    /// <p> The trigger settings that determine how and when the flow runs. </p>
    pub fn trigger_config(&self) -> std::option::Option<&crate::model::TriggerConfig> {
        self.trigger_config.as_ref()
    }
    /// <p> A list of tasks that Amazon AppFlow performs while transferring the data in the flow run.
    /// </p>
    pub fn tasks(&self) -> std::option::Option<&[crate::model::Task]> {
        self.tasks.as_deref()
    }
    /// <p> Specifies when the flow was created. </p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_at.as_ref()
    }
    /// <p> Specifies when the flow was last updated. </p>
    pub fn last_updated_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_updated_at.as_ref()
    }
    /// <p> The ARN of the user who created the flow. </p>
    pub fn created_by(&self) -> std::option::Option<&str> {
        self.created_by.as_deref()
    }
    /// <p> Specifies the user name of the account that performed the most recent update. </p>
    pub fn last_updated_by(&self) -> std::option::Option<&str> {
        self.last_updated_by.as_deref()
    }
    /// <p> The tags used to organize, track, or control access for your flow. </p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for DescribeFlowOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeFlowOutput");
        formatter.field("flow_arn", &self.flow_arn);
        formatter.field("description", &self.description);
        formatter.field("flow_name", &self.flow_name);
        formatter.field("kms_arn", &self.kms_arn);
        formatter.field("flow_status", &self.flow_status);
        formatter.field("flow_status_message", &self.flow_status_message);
        formatter.field("source_flow_config", &self.source_flow_config);
        formatter.field(
            "destination_flow_config_list",
            &self.destination_flow_config_list,
        );
        formatter.field(
            "last_run_execution_details",
            &self.last_run_execution_details,
        );
        formatter.field("trigger_config", &self.trigger_config);
        formatter.field("tasks", &self.tasks);
        formatter.field("created_at", &self.created_at);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.field("created_by", &self.created_by);
        formatter.field("last_updated_by", &self.last_updated_by);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`DescribeFlowOutput`](crate::output::DescribeFlowOutput)
pub mod describe_flow_output {
    /// A builder for [`DescribeFlowOutput`](crate::output::DescribeFlowOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) flow_arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) flow_name: std::option::Option<std::string::String>,
        pub(crate) kms_arn: std::option::Option<std::string::String>,
        pub(crate) flow_status: std::option::Option<crate::model::FlowStatus>,
        pub(crate) flow_status_message: std::option::Option<std::string::String>,
        pub(crate) source_flow_config: std::option::Option<crate::model::SourceFlowConfig>,
        pub(crate) destination_flow_config_list:
            std::option::Option<std::vec::Vec<crate::model::DestinationFlowConfig>>,
        pub(crate) last_run_execution_details: std::option::Option<crate::model::ExecutionDetails>,
        pub(crate) trigger_config: std::option::Option<crate::model::TriggerConfig>,
        pub(crate) tasks: std::option::Option<std::vec::Vec<crate::model::Task>>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) created_by: std::option::Option<std::string::String>,
        pub(crate) last_updated_by: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p> The flow's Amazon Resource Name (ARN). </p>
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_arn = Some(input.into());
            self
        }
        /// <p> The flow's Amazon Resource Name (ARN). </p>
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.flow_arn = input;
            self
        }
        /// <p> A description of the flow. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p> A description of the flow. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens
        /// (-) only. </p>
        pub fn flow_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_name = Some(input.into());
            self
        }
        /// <p> The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens
        /// (-) only. </p>
        pub fn set_flow_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.flow_name = input;
            self
        }
        /// <p> The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for
        /// encryption. This is required if you do not want to use the Amazon AppFlow-managed KMS key. If
        /// you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key.
        /// </p>
        pub fn kms_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_arn = Some(input.into());
            self
        }
        /// <p> The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for
        /// encryption. This is required if you do not want to use the Amazon AppFlow-managed KMS key. If
        /// you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key.
        /// </p>
        pub fn set_kms_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_arn = input;
            self
        }
        /// <p> Indicates the current status of the flow. </p>
        pub fn flow_status(mut self, input: crate::model::FlowStatus) -> Self {
            self.flow_status = Some(input);
            self
        }
        /// <p> Indicates the current status of the flow. </p>
        pub fn set_flow_status(
            mut self,
            input: std::option::Option<crate::model::FlowStatus>,
        ) -> Self {
            self.flow_status = input;
            self
        }
        /// <p> Contains an error message if the flow status is in a suspended or error state. This
        /// applies only to scheduled or event-triggered flows. </p>
        pub fn flow_status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_status_message = Some(input.into());
            self
        }
        /// <p> Contains an error message if the flow status is in a suspended or error state. This
        /// applies only to scheduled or event-triggered flows. </p>
        pub fn set_flow_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.flow_status_message = input;
            self
        }
        /// <p> The configuration that controls how Amazon AppFlow retrieves data from the source
        /// connector. </p>
        pub fn source_flow_config(mut self, input: crate::model::SourceFlowConfig) -> Self {
            self.source_flow_config = Some(input);
            self
        }
        /// <p> The configuration that controls how Amazon AppFlow retrieves data from the source
        /// connector. </p>
        pub fn set_source_flow_config(
            mut self,
            input: std::option::Option<crate::model::SourceFlowConfig>,
        ) -> Self {
            self.source_flow_config = input;
            self
        }
        /// Appends an item to `destination_flow_config_list`.
        ///
        /// To override the contents of this collection use [`set_destination_flow_config_list`](Self::set_destination_flow_config_list).
        ///
        /// <p> The configuration that controls how Amazon AppFlow transfers data to the destination
        /// connector. </p>
        pub fn destination_flow_config_list(
            mut self,
            input: impl Into<crate::model::DestinationFlowConfig>,
        ) -> Self {
            let mut v = self.destination_flow_config_list.unwrap_or_default();
            v.push(input.into());
            self.destination_flow_config_list = Some(v);
            self
        }
        /// <p> The configuration that controls how Amazon AppFlow transfers data to the destination
        /// connector. </p>
        pub fn set_destination_flow_config_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DestinationFlowConfig>>,
        ) -> Self {
            self.destination_flow_config_list = input;
            self
        }
        /// <p> Describes the details of the most recent flow run. </p>
        pub fn last_run_execution_details(mut self, input: crate::model::ExecutionDetails) -> Self {
            self.last_run_execution_details = Some(input);
            self
        }
        /// <p> Describes the details of the most recent flow run. </p>
        pub fn set_last_run_execution_details(
            mut self,
            input: std::option::Option<crate::model::ExecutionDetails>,
        ) -> Self {
            self.last_run_execution_details = input;
            self
        }
        /// <p> The trigger settings that determine how and when the flow runs. </p>
        pub fn trigger_config(mut self, input: crate::model::TriggerConfig) -> Self {
            self.trigger_config = Some(input);
            self
        }
        /// <p> The trigger settings that determine how and when the flow runs. </p>
        pub fn set_trigger_config(
            mut self,
            input: std::option::Option<crate::model::TriggerConfig>,
        ) -> Self {
            self.trigger_config = input;
            self
        }
        /// Appends an item to `tasks`.
        ///
        /// To override the contents of this collection use [`set_tasks`](Self::set_tasks).
        ///
        /// <p> A list of tasks that Amazon AppFlow performs while transferring the data in the flow run.
        /// </p>
        pub fn tasks(mut self, input: impl Into<crate::model::Task>) -> Self {
            let mut v = self.tasks.unwrap_or_default();
            v.push(input.into());
            self.tasks = Some(v);
            self
        }
        /// <p> A list of tasks that Amazon AppFlow performs while transferring the data in the flow run.
        /// </p>
        pub fn set_tasks(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Task>>,
        ) -> Self {
            self.tasks = input;
            self
        }
        /// <p> Specifies when the flow was created. </p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p> Specifies when the flow was created. </p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p> Specifies when the flow was last updated. </p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p> Specifies when the flow was last updated. </p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// <p> The ARN of the user who created the flow. </p>
        pub fn created_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_by = Some(input.into());
            self
        }
        /// <p> The ARN of the user who created the flow. </p>
        pub fn set_created_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_by = input;
            self
        }
        /// <p> Specifies the user name of the account that performed the most recent update. </p>
        pub fn last_updated_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_updated_by = Some(input.into());
            self
        }
        /// <p> Specifies the user name of the account that performed the most recent update. </p>
        pub fn set_last_updated_by(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_updated_by = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> The tags used to organize, track, or control access for your flow. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p> The tags used to organize, track, or control access for your flow. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFlowOutput`](crate::output::DescribeFlowOutput)
        pub fn build(self) -> crate::output::DescribeFlowOutput {
            crate::output::DescribeFlowOutput {
                flow_arn: self.flow_arn,
                description: self.description,
                flow_name: self.flow_name,
                kms_arn: self.kms_arn,
                flow_status: self.flow_status,
                flow_status_message: self.flow_status_message,
                source_flow_config: self.source_flow_config,
                destination_flow_config_list: self.destination_flow_config_list,
                last_run_execution_details: self.last_run_execution_details,
                trigger_config: self.trigger_config,
                tasks: self.tasks,
                created_at: self.created_at,
                last_updated_at: self.last_updated_at,
                created_by: self.created_by,
                last_updated_by: self.last_updated_by,
                tags: self.tags,
            }
        }
    }
}
impl DescribeFlowOutput {
    /// Creates a new builder-style object to manufacture [`DescribeFlowOutput`](crate::output::DescribeFlowOutput)
    pub fn builder() -> crate::output::describe_flow_output::Builder {
        crate::output::describe_flow_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeConnectorsOutput {
    /// <p> The configuration that is applied to the connectors used in the flow. </p>
    pub connector_configurations: std::option::Option<
        std::collections::HashMap<
            crate::model::ConnectorType,
            crate::model::ConnectorConfiguration,
        >,
    >,
    /// <p> The pagination token for the next page of data. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeConnectorsOutput {
    /// <p> The configuration that is applied to the connectors used in the flow. </p>
    pub fn connector_configurations(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<
            crate::model::ConnectorType,
            crate::model::ConnectorConfiguration,
        >,
    > {
        self.connector_configurations.as_ref()
    }
    /// <p> The pagination token for the next page of data. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeConnectorsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeConnectorsOutput");
        formatter.field("connector_configurations", &self.connector_configurations);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeConnectorsOutput`](crate::output::DescribeConnectorsOutput)
pub mod describe_connectors_output {
    /// A builder for [`DescribeConnectorsOutput`](crate::output::DescribeConnectorsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connector_configurations: std::option::Option<
            std::collections::HashMap<
                crate::model::ConnectorType,
                crate::model::ConnectorConfiguration,
            >,
        >,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Adds a key-value pair to `connector_configurations`.
        ///
        /// To override the contents of this collection use [`set_connector_configurations`](Self::set_connector_configurations).
        ///
        /// <p> The configuration that is applied to the connectors used in the flow. </p>
        pub fn connector_configurations(
            mut self,
            k: impl Into<crate::model::ConnectorType>,
            v: impl Into<crate::model::ConnectorConfiguration>,
        ) -> Self {
            let mut hash_map = self.connector_configurations.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.connector_configurations = Some(hash_map);
            self
        }
        /// <p> The configuration that is applied to the connectors used in the flow. </p>
        pub fn set_connector_configurations(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    crate::model::ConnectorType,
                    crate::model::ConnectorConfiguration,
                >,
            >,
        ) -> Self {
            self.connector_configurations = input;
            self
        }
        /// <p> The pagination token for the next page of data. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> The pagination token for the next page of data. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeConnectorsOutput`](crate::output::DescribeConnectorsOutput)
        pub fn build(self) -> crate::output::DescribeConnectorsOutput {
            crate::output::DescribeConnectorsOutput {
                connector_configurations: self.connector_configurations,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeConnectorsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeConnectorsOutput`](crate::output::DescribeConnectorsOutput)
    pub fn builder() -> crate::output::describe_connectors_output::Builder {
        crate::output::describe_connectors_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeConnectorProfilesOutput {
    /// <p> Returns information about the connector profiles associated with the flow. </p>
    pub connector_profile_details:
        std::option::Option<std::vec::Vec<crate::model::ConnectorProfile>>,
    /// <p> The pagination token for the next page of data. If <code>nextToken=null</code>, this
    /// means that all records have been fetched. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeConnectorProfilesOutput {
    /// <p> Returns information about the connector profiles associated with the flow. </p>
    pub fn connector_profile_details(
        &self,
    ) -> std::option::Option<&[crate::model::ConnectorProfile]> {
        self.connector_profile_details.as_deref()
    }
    /// <p> The pagination token for the next page of data. If <code>nextToken=null</code>, this
    /// means that all records have been fetched. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeConnectorProfilesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeConnectorProfilesOutput");
        formatter.field("connector_profile_details", &self.connector_profile_details);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeConnectorProfilesOutput`](crate::output::DescribeConnectorProfilesOutput)
pub mod describe_connector_profiles_output {
    /// A builder for [`DescribeConnectorProfilesOutput`](crate::output::DescribeConnectorProfilesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connector_profile_details:
            std::option::Option<std::vec::Vec<crate::model::ConnectorProfile>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `connector_profile_details`.
        ///
        /// To override the contents of this collection use [`set_connector_profile_details`](Self::set_connector_profile_details).
        ///
        /// <p> Returns information about the connector profiles associated with the flow. </p>
        pub fn connector_profile_details(
            mut self,
            input: impl Into<crate::model::ConnectorProfile>,
        ) -> Self {
            let mut v = self.connector_profile_details.unwrap_or_default();
            v.push(input.into());
            self.connector_profile_details = Some(v);
            self
        }
        /// <p> Returns information about the connector profiles associated with the flow. </p>
        pub fn set_connector_profile_details(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConnectorProfile>>,
        ) -> Self {
            self.connector_profile_details = input;
            self
        }
        /// <p> The pagination token for the next page of data. If <code>nextToken=null</code>, this
        /// means that all records have been fetched. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> The pagination token for the next page of data. If <code>nextToken=null</code>, this
        /// means that all records have been fetched. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeConnectorProfilesOutput`](crate::output::DescribeConnectorProfilesOutput)
        pub fn build(self) -> crate::output::DescribeConnectorProfilesOutput {
            crate::output::DescribeConnectorProfilesOutput {
                connector_profile_details: self.connector_profile_details,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeConnectorProfilesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeConnectorProfilesOutput`](crate::output::DescribeConnectorProfilesOutput)
    pub fn builder() -> crate::output::describe_connector_profiles_output::Builder {
        crate::output::describe_connector_profiles_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeConnectorEntityOutput {
    /// <p> Describes the fields for that connector entity. For example, for an
    /// <i>account</i> entity, the fields would be <i>account name</i>,
    /// <i>account ID</i>, and so on. </p>
    pub connector_entity_fields:
        std::option::Option<std::vec::Vec<crate::model::ConnectorEntityField>>,
}
impl DescribeConnectorEntityOutput {
    /// <p> Describes the fields for that connector entity. For example, for an
    /// <i>account</i> entity, the fields would be <i>account name</i>,
    /// <i>account ID</i>, and so on. </p>
    pub fn connector_entity_fields(
        &self,
    ) -> std::option::Option<&[crate::model::ConnectorEntityField]> {
        self.connector_entity_fields.as_deref()
    }
}
impl std::fmt::Debug for DescribeConnectorEntityOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeConnectorEntityOutput");
        formatter.field("connector_entity_fields", &self.connector_entity_fields);
        formatter.finish()
    }
}
/// See [`DescribeConnectorEntityOutput`](crate::output::DescribeConnectorEntityOutput)
pub mod describe_connector_entity_output {
    /// A builder for [`DescribeConnectorEntityOutput`](crate::output::DescribeConnectorEntityOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connector_entity_fields:
            std::option::Option<std::vec::Vec<crate::model::ConnectorEntityField>>,
    }
    impl Builder {
        /// Appends an item to `connector_entity_fields`.
        ///
        /// To override the contents of this collection use [`set_connector_entity_fields`](Self::set_connector_entity_fields).
        ///
        /// <p> Describes the fields for that connector entity. For example, for an
        /// <i>account</i> entity, the fields would be <i>account name</i>,
        /// <i>account ID</i>, and so on. </p>
        pub fn connector_entity_fields(
            mut self,
            input: impl Into<crate::model::ConnectorEntityField>,
        ) -> Self {
            let mut v = self.connector_entity_fields.unwrap_or_default();
            v.push(input.into());
            self.connector_entity_fields = Some(v);
            self
        }
        /// <p> Describes the fields for that connector entity. For example, for an
        /// <i>account</i> entity, the fields would be <i>account name</i>,
        /// <i>account ID</i>, and so on. </p>
        pub fn set_connector_entity_fields(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConnectorEntityField>>,
        ) -> Self {
            self.connector_entity_fields = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeConnectorEntityOutput`](crate::output::DescribeConnectorEntityOutput)
        pub fn build(self) -> crate::output::DescribeConnectorEntityOutput {
            crate::output::DescribeConnectorEntityOutput {
                connector_entity_fields: self.connector_entity_fields,
            }
        }
    }
}
impl DescribeConnectorEntityOutput {
    /// Creates a new builder-style object to manufacture [`DescribeConnectorEntityOutput`](crate::output::DescribeConnectorEntityOutput)
    pub fn builder() -> crate::output::describe_connector_entity_output::Builder {
        crate::output::describe_connector_entity_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFlowOutput {}
impl std::fmt::Debug for DeleteFlowOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFlowOutput");
        formatter.finish()
    }
}
/// See [`DeleteFlowOutput`](crate::output::DeleteFlowOutput)
pub mod delete_flow_output {
    /// A builder for [`DeleteFlowOutput`](crate::output::DeleteFlowOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteFlowOutput`](crate::output::DeleteFlowOutput)
        pub fn build(self) -> crate::output::DeleteFlowOutput {
            crate::output::DeleteFlowOutput {}
        }
    }
}
impl DeleteFlowOutput {
    /// Creates a new builder-style object to manufacture [`DeleteFlowOutput`](crate::output::DeleteFlowOutput)
    pub fn builder() -> crate::output::delete_flow_output::Builder {
        crate::output::delete_flow_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteConnectorProfileOutput {}
impl std::fmt::Debug for DeleteConnectorProfileOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteConnectorProfileOutput");
        formatter.finish()
    }
}
/// See [`DeleteConnectorProfileOutput`](crate::output::DeleteConnectorProfileOutput)
pub mod delete_connector_profile_output {
    /// A builder for [`DeleteConnectorProfileOutput`](crate::output::DeleteConnectorProfileOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteConnectorProfileOutput`](crate::output::DeleteConnectorProfileOutput)
        pub fn build(self) -> crate::output::DeleteConnectorProfileOutput {
            crate::output::DeleteConnectorProfileOutput {}
        }
    }
}
impl DeleteConnectorProfileOutput {
    /// Creates a new builder-style object to manufacture [`DeleteConnectorProfileOutput`](crate::output::DeleteConnectorProfileOutput)
    pub fn builder() -> crate::output::delete_connector_profile_output::Builder {
        crate::output::delete_connector_profile_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFlowOutput {
    /// <p> The flow's Amazon Resource Name (ARN). </p>
    pub flow_arn: std::option::Option<std::string::String>,
    /// <p> Indicates the current status of the flow. </p>
    pub flow_status: std::option::Option<crate::model::FlowStatus>,
}
impl CreateFlowOutput {
    /// <p> The flow's Amazon Resource Name (ARN). </p>
    pub fn flow_arn(&self) -> std::option::Option<&str> {
        self.flow_arn.as_deref()
    }
    /// <p> Indicates the current status of the flow. </p>
    pub fn flow_status(&self) -> std::option::Option<&crate::model::FlowStatus> {
        self.flow_status.as_ref()
    }
}
impl std::fmt::Debug for CreateFlowOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFlowOutput");
        formatter.field("flow_arn", &self.flow_arn);
        formatter.field("flow_status", &self.flow_status);
        formatter.finish()
    }
}
/// See [`CreateFlowOutput`](crate::output::CreateFlowOutput)
pub mod create_flow_output {
    /// A builder for [`CreateFlowOutput`](crate::output::CreateFlowOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) flow_arn: std::option::Option<std::string::String>,
        pub(crate) flow_status: std::option::Option<crate::model::FlowStatus>,
    }
    impl Builder {
        /// <p> The flow's Amazon Resource Name (ARN). </p>
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_arn = Some(input.into());
            self
        }
        /// <p> The flow's Amazon Resource Name (ARN). </p>
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.flow_arn = input;
            self
        }
        /// <p> Indicates the current status of the flow. </p>
        pub fn flow_status(mut self, input: crate::model::FlowStatus) -> Self {
            self.flow_status = Some(input);
            self
        }
        /// <p> Indicates the current status of the flow. </p>
        pub fn set_flow_status(
            mut self,
            input: std::option::Option<crate::model::FlowStatus>,
        ) -> Self {
            self.flow_status = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFlowOutput`](crate::output::CreateFlowOutput)
        pub fn build(self) -> crate::output::CreateFlowOutput {
            crate::output::CreateFlowOutput {
                flow_arn: self.flow_arn,
                flow_status: self.flow_status,
            }
        }
    }
}
impl CreateFlowOutput {
    /// Creates a new builder-style object to manufacture [`CreateFlowOutput`](crate::output::CreateFlowOutput)
    pub fn builder() -> crate::output::create_flow_output::Builder {
        crate::output::create_flow_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateConnectorProfileOutput {
    /// <p> The Amazon Resource Name (ARN) of the connector profile. </p>
    pub connector_profile_arn: std::option::Option<std::string::String>,
}
impl CreateConnectorProfileOutput {
    /// <p> The Amazon Resource Name (ARN) of the connector profile. </p>
    pub fn connector_profile_arn(&self) -> std::option::Option<&str> {
        self.connector_profile_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateConnectorProfileOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateConnectorProfileOutput");
        formatter.field("connector_profile_arn", &self.connector_profile_arn);
        formatter.finish()
    }
}
/// See [`CreateConnectorProfileOutput`](crate::output::CreateConnectorProfileOutput)
pub mod create_connector_profile_output {
    /// A builder for [`CreateConnectorProfileOutput`](crate::output::CreateConnectorProfileOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connector_profile_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The Amazon Resource Name (ARN) of the connector profile. </p>
        pub fn connector_profile_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.connector_profile_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the connector profile. </p>
        pub fn set_connector_profile_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connector_profile_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateConnectorProfileOutput`](crate::output::CreateConnectorProfileOutput)
        pub fn build(self) -> crate::output::CreateConnectorProfileOutput {
            crate::output::CreateConnectorProfileOutput {
                connector_profile_arn: self.connector_profile_arn,
            }
        }
    }
}
impl CreateConnectorProfileOutput {
    /// Creates a new builder-style object to manufacture [`CreateConnectorProfileOutput`](crate::output::CreateConnectorProfileOutput)
    pub fn builder() -> crate::output::create_connector_profile_output::Builder {
        crate::output::create_connector_profile_output::Builder::default()
    }
}
