// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `CreateApplication`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_application`](crate::client::Client::create_application).
///
/// See [`crate::client::fluent_builders::CreateApplication`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateApplication {
    _private: (),
}
impl CreateApplication {
    /// Creates a new builder-style object to manufacture [`CreateApplicationInput`](crate::input::CreateApplicationInput)
    pub fn builder() -> crate::input::create_application_input::Builder {
        crate::input::create_application_input::Builder::default()
    }
    /// Creates a new `CreateApplication` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateApplication {
    type Output = std::result::Result<
        crate::output::CreateApplicationOutput,
        crate::error::CreateApplicationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_application_error(response)
        } else {
            crate::operation_deser::parse_create_application_response(response)
        }
    }
}

/// Operation shape for `CreateConfigurationProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_configuration_profile`](crate::client::Client::create_configuration_profile).
///
/// See [`crate::client::fluent_builders::CreateConfigurationProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateConfigurationProfile {
    _private: (),
}
impl CreateConfigurationProfile {
    /// Creates a new builder-style object to manufacture [`CreateConfigurationProfileInput`](crate::input::CreateConfigurationProfileInput)
    pub fn builder() -> crate::input::create_configuration_profile_input::Builder {
        crate::input::create_configuration_profile_input::Builder::default()
    }
    /// Creates a new `CreateConfigurationProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateConfigurationProfile {
    type Output = std::result::Result<
        crate::output::CreateConfigurationProfileOutput,
        crate::error::CreateConfigurationProfileError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_configuration_profile_error(response)
        } else {
            crate::operation_deser::parse_create_configuration_profile_response(response)
        }
    }
}

/// Operation shape for `CreateDeploymentStrategy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_deployment_strategy`](crate::client::Client::create_deployment_strategy).
///
/// See [`crate::client::fluent_builders::CreateDeploymentStrategy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDeploymentStrategy {
    _private: (),
}
impl CreateDeploymentStrategy {
    /// Creates a new builder-style object to manufacture [`CreateDeploymentStrategyInput`](crate::input::CreateDeploymentStrategyInput)
    pub fn builder() -> crate::input::create_deployment_strategy_input::Builder {
        crate::input::create_deployment_strategy_input::Builder::default()
    }
    /// Creates a new `CreateDeploymentStrategy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDeploymentStrategy {
    type Output = std::result::Result<
        crate::output::CreateDeploymentStrategyOutput,
        crate::error::CreateDeploymentStrategyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_deployment_strategy_error(response)
        } else {
            crate::operation_deser::parse_create_deployment_strategy_response(response)
        }
    }
}

/// Operation shape for `CreateEnvironment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_environment`](crate::client::Client::create_environment).
///
/// See [`crate::client::fluent_builders::CreateEnvironment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateEnvironment {
    _private: (),
}
impl CreateEnvironment {
    /// Creates a new builder-style object to manufacture [`CreateEnvironmentInput`](crate::input::CreateEnvironmentInput)
    pub fn builder() -> crate::input::create_environment_input::Builder {
        crate::input::create_environment_input::Builder::default()
    }
    /// Creates a new `CreateEnvironment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateEnvironment {
    type Output = std::result::Result<
        crate::output::CreateEnvironmentOutput,
        crate::error::CreateEnvironmentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_environment_error(response)
        } else {
            crate::operation_deser::parse_create_environment_response(response)
        }
    }
}

/// Operation shape for `CreateHostedConfigurationVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_hosted_configuration_version`](crate::client::Client::create_hosted_configuration_version).
///
/// See [`crate::client::fluent_builders::CreateHostedConfigurationVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateHostedConfigurationVersion {
    _private: (),
}
impl CreateHostedConfigurationVersion {
    /// Creates a new builder-style object to manufacture [`CreateHostedConfigurationVersionInput`](crate::input::CreateHostedConfigurationVersionInput)
    pub fn builder() -> crate::input::create_hosted_configuration_version_input::Builder {
        crate::input::create_hosted_configuration_version_input::Builder::default()
    }
    /// Creates a new `CreateHostedConfigurationVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateHostedConfigurationVersion {
    type Output = std::result::Result<
        crate::output::CreateHostedConfigurationVersionOutput,
        crate::error::CreateHostedConfigurationVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_hosted_configuration_version_error(response)
        } else {
            crate::operation_deser::parse_create_hosted_configuration_version_response(response)
        }
    }
}

/// Operation shape for `DeleteApplication`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_application`](crate::client::Client::delete_application).
///
/// See [`crate::client::fluent_builders::DeleteApplication`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteApplication {
    _private: (),
}
impl DeleteApplication {
    /// Creates a new builder-style object to manufacture [`DeleteApplicationInput`](crate::input::DeleteApplicationInput)
    pub fn builder() -> crate::input::delete_application_input::Builder {
        crate::input::delete_application_input::Builder::default()
    }
    /// Creates a new `DeleteApplication` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteApplication {
    type Output = std::result::Result<
        crate::output::DeleteApplicationOutput,
        crate::error::DeleteApplicationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_application_error(response)
        } else {
            crate::operation_deser::parse_delete_application_response(response)
        }
    }
}

/// Operation shape for `DeleteConfigurationProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_configuration_profile`](crate::client::Client::delete_configuration_profile).
///
/// See [`crate::client::fluent_builders::DeleteConfigurationProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteConfigurationProfile {
    _private: (),
}
impl DeleteConfigurationProfile {
    /// Creates a new builder-style object to manufacture [`DeleteConfigurationProfileInput`](crate::input::DeleteConfigurationProfileInput)
    pub fn builder() -> crate::input::delete_configuration_profile_input::Builder {
        crate::input::delete_configuration_profile_input::Builder::default()
    }
    /// Creates a new `DeleteConfigurationProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteConfigurationProfile {
    type Output = std::result::Result<
        crate::output::DeleteConfigurationProfileOutput,
        crate::error::DeleteConfigurationProfileError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_configuration_profile_error(response)
        } else {
            crate::operation_deser::parse_delete_configuration_profile_response(response)
        }
    }
}

/// Operation shape for `DeleteDeploymentStrategy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_deployment_strategy`](crate::client::Client::delete_deployment_strategy).
///
/// See [`crate::client::fluent_builders::DeleteDeploymentStrategy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDeploymentStrategy {
    _private: (),
}
impl DeleteDeploymentStrategy {
    /// Creates a new builder-style object to manufacture [`DeleteDeploymentStrategyInput`](crate::input::DeleteDeploymentStrategyInput)
    pub fn builder() -> crate::input::delete_deployment_strategy_input::Builder {
        crate::input::delete_deployment_strategy_input::Builder::default()
    }
    /// Creates a new `DeleteDeploymentStrategy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDeploymentStrategy {
    type Output = std::result::Result<
        crate::output::DeleteDeploymentStrategyOutput,
        crate::error::DeleteDeploymentStrategyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_deployment_strategy_error(response)
        } else {
            crate::operation_deser::parse_delete_deployment_strategy_response(response)
        }
    }
}

/// Operation shape for `DeleteEnvironment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_environment`](crate::client::Client::delete_environment).
///
/// See [`crate::client::fluent_builders::DeleteEnvironment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteEnvironment {
    _private: (),
}
impl DeleteEnvironment {
    /// Creates a new builder-style object to manufacture [`DeleteEnvironmentInput`](crate::input::DeleteEnvironmentInput)
    pub fn builder() -> crate::input::delete_environment_input::Builder {
        crate::input::delete_environment_input::Builder::default()
    }
    /// Creates a new `DeleteEnvironment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteEnvironment {
    type Output = std::result::Result<
        crate::output::DeleteEnvironmentOutput,
        crate::error::DeleteEnvironmentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_environment_error(response)
        } else {
            crate::operation_deser::parse_delete_environment_response(response)
        }
    }
}

/// Operation shape for `DeleteHostedConfigurationVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_hosted_configuration_version`](crate::client::Client::delete_hosted_configuration_version).
///
/// See [`crate::client::fluent_builders::DeleteHostedConfigurationVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteHostedConfigurationVersion {
    _private: (),
}
impl DeleteHostedConfigurationVersion {
    /// Creates a new builder-style object to manufacture [`DeleteHostedConfigurationVersionInput`](crate::input::DeleteHostedConfigurationVersionInput)
    pub fn builder() -> crate::input::delete_hosted_configuration_version_input::Builder {
        crate::input::delete_hosted_configuration_version_input::Builder::default()
    }
    /// Creates a new `DeleteHostedConfigurationVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteHostedConfigurationVersion {
    type Output = std::result::Result<
        crate::output::DeleteHostedConfigurationVersionOutput,
        crate::error::DeleteHostedConfigurationVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_hosted_configuration_version_error(response)
        } else {
            crate::operation_deser::parse_delete_hosted_configuration_version_response(response)
        }
    }
}

/// Operation shape for `GetApplication`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_application`](crate::client::Client::get_application).
///
/// See [`crate::client::fluent_builders::GetApplication`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetApplication {
    _private: (),
}
impl GetApplication {
    /// Creates a new builder-style object to manufacture [`GetApplicationInput`](crate::input::GetApplicationInput)
    pub fn builder() -> crate::input::get_application_input::Builder {
        crate::input::get_application_input::Builder::default()
    }
    /// Creates a new `GetApplication` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetApplication {
    type Output =
        std::result::Result<crate::output::GetApplicationOutput, crate::error::GetApplicationError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_application_error(response)
        } else {
            crate::operation_deser::parse_get_application_response(response)
        }
    }
}

/// Operation shape for `GetConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_configuration`](crate::client::Client::get_configuration).
///
/// See [`crate::client::fluent_builders::GetConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetConfiguration {
    _private: (),
}
impl GetConfiguration {
    /// Creates a new builder-style object to manufacture [`GetConfigurationInput`](crate::input::GetConfigurationInput)
    pub fn builder() -> crate::input::get_configuration_input::Builder {
        crate::input::get_configuration_input::Builder::default()
    }
    /// Creates a new `GetConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetConfiguration {
    type Output = std::result::Result<
        crate::output::GetConfigurationOutput,
        crate::error::GetConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_configuration_error(response)
        } else {
            crate::operation_deser::parse_get_configuration_response(response)
        }
    }
}

/// Operation shape for `GetConfigurationProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_configuration_profile`](crate::client::Client::get_configuration_profile).
///
/// See [`crate::client::fluent_builders::GetConfigurationProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetConfigurationProfile {
    _private: (),
}
impl GetConfigurationProfile {
    /// Creates a new builder-style object to manufacture [`GetConfigurationProfileInput`](crate::input::GetConfigurationProfileInput)
    pub fn builder() -> crate::input::get_configuration_profile_input::Builder {
        crate::input::get_configuration_profile_input::Builder::default()
    }
    /// Creates a new `GetConfigurationProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetConfigurationProfile {
    type Output = std::result::Result<
        crate::output::GetConfigurationProfileOutput,
        crate::error::GetConfigurationProfileError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_configuration_profile_error(response)
        } else {
            crate::operation_deser::parse_get_configuration_profile_response(response)
        }
    }
}

/// Operation shape for `GetDeployment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_deployment`](crate::client::Client::get_deployment).
///
/// See [`crate::client::fluent_builders::GetDeployment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDeployment {
    _private: (),
}
impl GetDeployment {
    /// Creates a new builder-style object to manufacture [`GetDeploymentInput`](crate::input::GetDeploymentInput)
    pub fn builder() -> crate::input::get_deployment_input::Builder {
        crate::input::get_deployment_input::Builder::default()
    }
    /// Creates a new `GetDeployment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDeployment {
    type Output =
        std::result::Result<crate::output::GetDeploymentOutput, crate::error::GetDeploymentError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_deployment_error(response)
        } else {
            crate::operation_deser::parse_get_deployment_response(response)
        }
    }
}

/// Operation shape for `GetDeploymentStrategy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_deployment_strategy`](crate::client::Client::get_deployment_strategy).
///
/// See [`crate::client::fluent_builders::GetDeploymentStrategy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDeploymentStrategy {
    _private: (),
}
impl GetDeploymentStrategy {
    /// Creates a new builder-style object to manufacture [`GetDeploymentStrategyInput`](crate::input::GetDeploymentStrategyInput)
    pub fn builder() -> crate::input::get_deployment_strategy_input::Builder {
        crate::input::get_deployment_strategy_input::Builder::default()
    }
    /// Creates a new `GetDeploymentStrategy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDeploymentStrategy {
    type Output = std::result::Result<
        crate::output::GetDeploymentStrategyOutput,
        crate::error::GetDeploymentStrategyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_deployment_strategy_error(response)
        } else {
            crate::operation_deser::parse_get_deployment_strategy_response(response)
        }
    }
}

/// Operation shape for `GetEnvironment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_environment`](crate::client::Client::get_environment).
///
/// See [`crate::client::fluent_builders::GetEnvironment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetEnvironment {
    _private: (),
}
impl GetEnvironment {
    /// Creates a new builder-style object to manufacture [`GetEnvironmentInput`](crate::input::GetEnvironmentInput)
    pub fn builder() -> crate::input::get_environment_input::Builder {
        crate::input::get_environment_input::Builder::default()
    }
    /// Creates a new `GetEnvironment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetEnvironment {
    type Output =
        std::result::Result<crate::output::GetEnvironmentOutput, crate::error::GetEnvironmentError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_environment_error(response)
        } else {
            crate::operation_deser::parse_get_environment_response(response)
        }
    }
}

/// Operation shape for `GetHostedConfigurationVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_hosted_configuration_version`](crate::client::Client::get_hosted_configuration_version).
///
/// See [`crate::client::fluent_builders::GetHostedConfigurationVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetHostedConfigurationVersion {
    _private: (),
}
impl GetHostedConfigurationVersion {
    /// Creates a new builder-style object to manufacture [`GetHostedConfigurationVersionInput`](crate::input::GetHostedConfigurationVersionInput)
    pub fn builder() -> crate::input::get_hosted_configuration_version_input::Builder {
        crate::input::get_hosted_configuration_version_input::Builder::default()
    }
    /// Creates a new `GetHostedConfigurationVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetHostedConfigurationVersion {
    type Output = std::result::Result<
        crate::output::GetHostedConfigurationVersionOutput,
        crate::error::GetHostedConfigurationVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_hosted_configuration_version_error(response)
        } else {
            crate::operation_deser::parse_get_hosted_configuration_version_response(response)
        }
    }
}

/// Operation shape for `ListApplications`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_applications`](crate::client::Client::list_applications).
///
/// See [`crate::client::fluent_builders::ListApplications`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListApplications {
    _private: (),
}
impl ListApplications {
    /// Creates a new builder-style object to manufacture [`ListApplicationsInput`](crate::input::ListApplicationsInput)
    pub fn builder() -> crate::input::list_applications_input::Builder {
        crate::input::list_applications_input::Builder::default()
    }
    /// Creates a new `ListApplications` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListApplications {
    type Output = std::result::Result<
        crate::output::ListApplicationsOutput,
        crate::error::ListApplicationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_applications_error(response)
        } else {
            crate::operation_deser::parse_list_applications_response(response)
        }
    }
}

/// Operation shape for `ListConfigurationProfiles`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_configuration_profiles`](crate::client::Client::list_configuration_profiles).
///
/// See [`crate::client::fluent_builders::ListConfigurationProfiles`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListConfigurationProfiles {
    _private: (),
}
impl ListConfigurationProfiles {
    /// Creates a new builder-style object to manufacture [`ListConfigurationProfilesInput`](crate::input::ListConfigurationProfilesInput)
    pub fn builder() -> crate::input::list_configuration_profiles_input::Builder {
        crate::input::list_configuration_profiles_input::Builder::default()
    }
    /// Creates a new `ListConfigurationProfiles` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListConfigurationProfiles {
    type Output = std::result::Result<
        crate::output::ListConfigurationProfilesOutput,
        crate::error::ListConfigurationProfilesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_configuration_profiles_error(response)
        } else {
            crate::operation_deser::parse_list_configuration_profiles_response(response)
        }
    }
}

/// Operation shape for `ListDeployments`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_deployments`](crate::client::Client::list_deployments).
///
/// See [`crate::client::fluent_builders::ListDeployments`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDeployments {
    _private: (),
}
impl ListDeployments {
    /// Creates a new builder-style object to manufacture [`ListDeploymentsInput`](crate::input::ListDeploymentsInput)
    pub fn builder() -> crate::input::list_deployments_input::Builder {
        crate::input::list_deployments_input::Builder::default()
    }
    /// Creates a new `ListDeployments` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDeployments {
    type Output = std::result::Result<
        crate::output::ListDeploymentsOutput,
        crate::error::ListDeploymentsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_deployments_error(response)
        } else {
            crate::operation_deser::parse_list_deployments_response(response)
        }
    }
}

/// Operation shape for `ListDeploymentStrategies`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_deployment_strategies`](crate::client::Client::list_deployment_strategies).
///
/// See [`crate::client::fluent_builders::ListDeploymentStrategies`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDeploymentStrategies {
    _private: (),
}
impl ListDeploymentStrategies {
    /// Creates a new builder-style object to manufacture [`ListDeploymentStrategiesInput`](crate::input::ListDeploymentStrategiesInput)
    pub fn builder() -> crate::input::list_deployment_strategies_input::Builder {
        crate::input::list_deployment_strategies_input::Builder::default()
    }
    /// Creates a new `ListDeploymentStrategies` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDeploymentStrategies {
    type Output = std::result::Result<
        crate::output::ListDeploymentStrategiesOutput,
        crate::error::ListDeploymentStrategiesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_deployment_strategies_error(response)
        } else {
            crate::operation_deser::parse_list_deployment_strategies_response(response)
        }
    }
}

/// Operation shape for `ListEnvironments`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_environments`](crate::client::Client::list_environments).
///
/// See [`crate::client::fluent_builders::ListEnvironments`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListEnvironments {
    _private: (),
}
impl ListEnvironments {
    /// Creates a new builder-style object to manufacture [`ListEnvironmentsInput`](crate::input::ListEnvironmentsInput)
    pub fn builder() -> crate::input::list_environments_input::Builder {
        crate::input::list_environments_input::Builder::default()
    }
    /// Creates a new `ListEnvironments` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListEnvironments {
    type Output = std::result::Result<
        crate::output::ListEnvironmentsOutput,
        crate::error::ListEnvironmentsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_environments_error(response)
        } else {
            crate::operation_deser::parse_list_environments_response(response)
        }
    }
}

/// Operation shape for `ListHostedConfigurationVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_hosted_configuration_versions`](crate::client::Client::list_hosted_configuration_versions).
///
/// See [`crate::client::fluent_builders::ListHostedConfigurationVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListHostedConfigurationVersions {
    _private: (),
}
impl ListHostedConfigurationVersions {
    /// Creates a new builder-style object to manufacture [`ListHostedConfigurationVersionsInput`](crate::input::ListHostedConfigurationVersionsInput)
    pub fn builder() -> crate::input::list_hosted_configuration_versions_input::Builder {
        crate::input::list_hosted_configuration_versions_input::Builder::default()
    }
    /// Creates a new `ListHostedConfigurationVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListHostedConfigurationVersions {
    type Output = std::result::Result<
        crate::output::ListHostedConfigurationVersionsOutput,
        crate::error::ListHostedConfigurationVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_hosted_configuration_versions_error(response)
        } else {
            crate::operation_deser::parse_list_hosted_configuration_versions_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `StartDeployment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_deployment`](crate::client::Client::start_deployment).
///
/// See [`crate::client::fluent_builders::StartDeployment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartDeployment {
    _private: (),
}
impl StartDeployment {
    /// Creates a new builder-style object to manufacture [`StartDeploymentInput`](crate::input::StartDeploymentInput)
    pub fn builder() -> crate::input::start_deployment_input::Builder {
        crate::input::start_deployment_input::Builder::default()
    }
    /// Creates a new `StartDeployment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartDeployment {
    type Output = std::result::Result<
        crate::output::StartDeploymentOutput,
        crate::error::StartDeploymentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_start_deployment_error(response)
        } else {
            crate::operation_deser::parse_start_deployment_response(response)
        }
    }
}

/// Operation shape for `StopDeployment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_deployment`](crate::client::Client::stop_deployment).
///
/// See [`crate::client::fluent_builders::StopDeployment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopDeployment {
    _private: (),
}
impl StopDeployment {
    /// Creates a new builder-style object to manufacture [`StopDeploymentInput`](crate::input::StopDeploymentInput)
    pub fn builder() -> crate::input::stop_deployment_input::Builder {
        crate::input::stop_deployment_input::Builder::default()
    }
    /// Creates a new `StopDeployment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopDeployment {
    type Output =
        std::result::Result<crate::output::StopDeploymentOutput, crate::error::StopDeploymentError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_stop_deployment_error(response)
        } else {
            crate::operation_deser::parse_stop_deployment_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateApplication`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_application`](crate::client::Client::update_application).
///
/// See [`crate::client::fluent_builders::UpdateApplication`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateApplication {
    _private: (),
}
impl UpdateApplication {
    /// Creates a new builder-style object to manufacture [`UpdateApplicationInput`](crate::input::UpdateApplicationInput)
    pub fn builder() -> crate::input::update_application_input::Builder {
        crate::input::update_application_input::Builder::default()
    }
    /// Creates a new `UpdateApplication` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateApplication {
    type Output = std::result::Result<
        crate::output::UpdateApplicationOutput,
        crate::error::UpdateApplicationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_application_error(response)
        } else {
            crate::operation_deser::parse_update_application_response(response)
        }
    }
}

/// Operation shape for `UpdateConfigurationProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_configuration_profile`](crate::client::Client::update_configuration_profile).
///
/// See [`crate::client::fluent_builders::UpdateConfigurationProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateConfigurationProfile {
    _private: (),
}
impl UpdateConfigurationProfile {
    /// Creates a new builder-style object to manufacture [`UpdateConfigurationProfileInput`](crate::input::UpdateConfigurationProfileInput)
    pub fn builder() -> crate::input::update_configuration_profile_input::Builder {
        crate::input::update_configuration_profile_input::Builder::default()
    }
    /// Creates a new `UpdateConfigurationProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateConfigurationProfile {
    type Output = std::result::Result<
        crate::output::UpdateConfigurationProfileOutput,
        crate::error::UpdateConfigurationProfileError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_configuration_profile_error(response)
        } else {
            crate::operation_deser::parse_update_configuration_profile_response(response)
        }
    }
}

/// Operation shape for `UpdateDeploymentStrategy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_deployment_strategy`](crate::client::Client::update_deployment_strategy).
///
/// See [`crate::client::fluent_builders::UpdateDeploymentStrategy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDeploymentStrategy {
    _private: (),
}
impl UpdateDeploymentStrategy {
    /// Creates a new builder-style object to manufacture [`UpdateDeploymentStrategyInput`](crate::input::UpdateDeploymentStrategyInput)
    pub fn builder() -> crate::input::update_deployment_strategy_input::Builder {
        crate::input::update_deployment_strategy_input::Builder::default()
    }
    /// Creates a new `UpdateDeploymentStrategy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDeploymentStrategy {
    type Output = std::result::Result<
        crate::output::UpdateDeploymentStrategyOutput,
        crate::error::UpdateDeploymentStrategyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_deployment_strategy_error(response)
        } else {
            crate::operation_deser::parse_update_deployment_strategy_response(response)
        }
    }
}

/// Operation shape for `UpdateEnvironment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_environment`](crate::client::Client::update_environment).
///
/// See [`crate::client::fluent_builders::UpdateEnvironment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateEnvironment {
    _private: (),
}
impl UpdateEnvironment {
    /// Creates a new builder-style object to manufacture [`UpdateEnvironmentInput`](crate::input::UpdateEnvironmentInput)
    pub fn builder() -> crate::input::update_environment_input::Builder {
        crate::input::update_environment_input::Builder::default()
    }
    /// Creates a new `UpdateEnvironment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateEnvironment {
    type Output = std::result::Result<
        crate::output::UpdateEnvironmentOutput,
        crate::error::UpdateEnvironmentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_environment_error(response)
        } else {
            crate::operation_deser::parse_update_environment_response(response)
        }
    }
}

/// Operation shape for `ValidateConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`validate_configuration`](crate::client::Client::validate_configuration).
///
/// See [`crate::client::fluent_builders::ValidateConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ValidateConfiguration {
    _private: (),
}
impl ValidateConfiguration {
    /// Creates a new builder-style object to manufacture [`ValidateConfigurationInput`](crate::input::ValidateConfigurationInput)
    pub fn builder() -> crate::input::validate_configuration_input::Builder {
        crate::input::validate_configuration_input::Builder::default()
    }
    /// Creates a new `ValidateConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ValidateConfiguration {
    type Output = std::result::Result<
        crate::output::ValidateConfigurationOutput,
        crate::error::ValidateConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_validate_configuration_error(response)
        } else {
            crate::operation_deser::parse_validate_configuration_response(response)
        }
    }
}
