// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon AppConfig
///
/// Client for invoking operations on Amazon AppConfig. Each operation on Amazon AppConfig is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_appconfig::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_appconfig::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_appconfig::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`CreateApplication`](crate::client::fluent_builders::CreateApplication) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateApplication::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateApplication::set_name): <p>A name for the application.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateApplication::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateApplication::set_description): <p>A description of the application.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateApplication::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateApplication::set_tags): <p>Metadata to assign to the application. Tags help organize and categorize your AppConfig resources. Each tag consists of a key and an optional value, both of which you define.</p>
    /// - On success, responds with [`CreateApplicationOutput`](crate::output::CreateApplicationOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::CreateApplicationOutput::id): <p>The application ID.</p>
    ///   - [`name(Option<String>)`](crate::output::CreateApplicationOutput::name): <p>The application name.</p>
    ///   - [`description(Option<String>)`](crate::output::CreateApplicationOutput::description): <p>The description of the application.</p>
    /// - On failure, responds with [`SdkError<CreateApplicationError>`](crate::error::CreateApplicationError)
    pub fn create_application(&self) -> fluent_builders::CreateApplication {
        fluent_builders::CreateApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateConfigurationProfile`](crate::client::fluent_builders::CreateConfigurationProfile) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::CreateConfigurationProfile::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::CreateConfigurationProfile::set_application_id): <p>The application ID.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateConfigurationProfile::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateConfigurationProfile::set_name): <p>A name for the configuration profile.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateConfigurationProfile::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateConfigurationProfile::set_description): <p>A description of the configuration profile.</p>
    ///   - [`location_uri(impl Into<String>)`](crate::client::fluent_builders::CreateConfigurationProfile::location_uri) / [`set_location_uri(Option<String>)`](crate::client::fluent_builders::CreateConfigurationProfile::set_location_uri): <p>A URI to locate the configuration. You can specify the AppConfig hosted configuration store, Systems Manager (SSM) document, an SSM Parameter Store parameter, or an Amazon S3 object. For the hosted configuration store and for feature flags, specify <code>hosted</code>. For an SSM document, specify either the document name in the format <code>ssm-document://   <document_name></document_name></code> or the Amazon Resource Name (ARN). For a parameter, specify either the parameter name in the format <code>ssm-parameter://   <parameter_name></parameter_name></code> or the ARN. For an Amazon S3 object, specify the URI in the following format: <code>s3://   <bucket>    /    <objectkey>     </objectkey>   </bucket></code>. Here is an example: <code>s3://my-bucket/my-app/us-east-1/my-config.json</code> </p>
    ///   - [`retrieval_role_arn(impl Into<String>)`](crate::client::fluent_builders::CreateConfigurationProfile::retrieval_role_arn) / [`set_retrieval_role_arn(Option<String>)`](crate::client::fluent_builders::CreateConfigurationProfile::set_retrieval_role_arn): <p>The ARN of an IAM role with permission to access the configuration at the specified <code>LocationUri</code>.</p> <important>   <p>A retrieval role ARN is not required for configurations stored in the AppConfig hosted configuration store. It is required for all other sources that store your configuration. </p>  </important>
    ///   - [`validators(Vec<Validator>)`](crate::client::fluent_builders::CreateConfigurationProfile::validators) / [`set_validators(Option<Vec<Validator>>)`](crate::client::fluent_builders::CreateConfigurationProfile::set_validators): <p>A list of methods for validating the configuration.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateConfigurationProfile::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateConfigurationProfile::set_tags): <p>Metadata to assign to the configuration profile. Tags help organize and categorize your AppConfig resources. Each tag consists of a key and an optional value, both of which you define.</p>
    ///   - [`r#type(impl Into<String>)`](crate::client::fluent_builders::CreateConfigurationProfile::type) / [`set_type(Option<String>)`](crate::client::fluent_builders::CreateConfigurationProfile::set_type): <p>The type of configurations contained in the profile. AppConfig supports <code>feature flags</code> and <code>freeform</code> configurations. We recommend you create feature flag configurations to enable or disable new features and freeform configurations to distribute configurations to an application. When calling this API, enter one of the following values for <code>Type</code>:</p>  <p> <code>AWS.AppConfig.FeatureFlags</code> </p>  <p> <code>AWS.Freeform</code> </p>
    /// - On success, responds with [`CreateConfigurationProfileOutput`](crate::output::CreateConfigurationProfileOutput) with field(s):
    ///   - [`application_id(Option<String>)`](crate::output::CreateConfigurationProfileOutput::application_id): <p>The application ID.</p>
    ///   - [`id(Option<String>)`](crate::output::CreateConfigurationProfileOutput::id): <p>The configuration profile ID.</p>
    ///   - [`name(Option<String>)`](crate::output::CreateConfigurationProfileOutput::name): <p>The name of the configuration profile.</p>
    ///   - [`description(Option<String>)`](crate::output::CreateConfigurationProfileOutput::description): <p>The configuration profile description.</p>
    ///   - [`location_uri(Option<String>)`](crate::output::CreateConfigurationProfileOutput::location_uri): <p>The URI location of the configuration.</p>
    ///   - [`retrieval_role_arn(Option<String>)`](crate::output::CreateConfigurationProfileOutput::retrieval_role_arn): <p>The ARN of an IAM role with permission to access the configuration at the specified <code>LocationUri</code>.</p>
    ///   - [`validators(Option<Vec<Validator>>)`](crate::output::CreateConfigurationProfileOutput::validators): <p>A list of methods for validating the configuration.</p>
    ///   - [`r#type(Option<String>)`](crate::output::CreateConfigurationProfileOutput::type): <p>The type of configurations contained in the profile. AppConfig supports <code>feature flags</code> and <code>freeform</code> configurations. We recommend you create feature flag configurations to enable or disable new features and freeform configurations to distribute configurations to an application. When calling this API, enter one of the following values for <code>Type</code>:</p>  <p> <code>AWS.AppConfig.FeatureFlags</code> </p>  <p> <code>AWS.Freeform</code> </p>
    /// - On failure, responds with [`SdkError<CreateConfigurationProfileError>`](crate::error::CreateConfigurationProfileError)
    pub fn create_configuration_profile(&self) -> fluent_builders::CreateConfigurationProfile {
        fluent_builders::CreateConfigurationProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDeploymentStrategy`](crate::client::fluent_builders::CreateDeploymentStrategy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateDeploymentStrategy::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateDeploymentStrategy::set_name): <p>A name for the deployment strategy.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateDeploymentStrategy::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateDeploymentStrategy::set_description): <p>A description of the deployment strategy.</p>
    ///   - [`deployment_duration_in_minutes(i32)`](crate::client::fluent_builders::CreateDeploymentStrategy::deployment_duration_in_minutes) / [`set_deployment_duration_in_minutes(Option<i32>)`](crate::client::fluent_builders::CreateDeploymentStrategy::set_deployment_duration_in_minutes): <p>Total amount of time for a deployment to last.</p>
    ///   - [`final_bake_time_in_minutes(i32)`](crate::client::fluent_builders::CreateDeploymentStrategy::final_bake_time_in_minutes) / [`set_final_bake_time_in_minutes(i32)`](crate::client::fluent_builders::CreateDeploymentStrategy::set_final_bake_time_in_minutes): <p>The amount of time AppConfig monitors for alarms before considering the deployment to be complete and no longer eligible for automatic roll back.</p>
    ///   - [`growth_factor(f32)`](crate::client::fluent_builders::CreateDeploymentStrategy::growth_factor) / [`set_growth_factor(Option<f32>)`](crate::client::fluent_builders::CreateDeploymentStrategy::set_growth_factor): <p>The percentage of targets to receive a deployed configuration during each interval.</p>
    ///   - [`growth_type(GrowthType)`](crate::client::fluent_builders::CreateDeploymentStrategy::growth_type) / [`set_growth_type(Option<GrowthType>)`](crate::client::fluent_builders::CreateDeploymentStrategy::set_growth_type): <p>The algorithm used to define how percentage grows over time. AppConfig supports the following growth types:</p>  <p> <b>Linear</b>: For this type, AppConfig processes the deployment by dividing the total number of targets by the value specified for <code>Step percentage</code>. For example, a linear deployment that uses a <code>Step percentage</code> of 10 deploys the configuration to 10 percent of the hosts. After those deployments are complete, the system deploys the configuration to the next 10 percent. This continues until 100% of the targets have successfully received the configuration.</p>  <p> <b>Exponential</b>: For this type, AppConfig processes the deployment exponentially using the following formula: <code>G*(2^N)</code>. In this formula, <code>G</code> is the growth factor specified by the user and <code>N</code> is the number of steps until the configuration is deployed to all targets. For example, if you specify a growth factor of 2, then the system rolls out the configuration as follows:</p>  <p> <code>2*(2^0)</code> </p>  <p> <code>2*(2^1)</code> </p>  <p> <code>2*(2^2)</code> </p>  <p>Expressed numerically, the deployment rolls out as follows: 2% of the targets, 4% of the targets, 8% of the targets, and continues until the configuration has been deployed to all targets.</p>
    ///   - [`replicate_to(ReplicateTo)`](crate::client::fluent_builders::CreateDeploymentStrategy::replicate_to) / [`set_replicate_to(Option<ReplicateTo>)`](crate::client::fluent_builders::CreateDeploymentStrategy::set_replicate_to): <p>Save the deployment strategy to a Systems Manager (SSM) document.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateDeploymentStrategy::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateDeploymentStrategy::set_tags): <p>Metadata to assign to the deployment strategy. Tags help organize and categorize your AppConfig resources. Each tag consists of a key and an optional value, both of which you define.</p>
    /// - On success, responds with [`CreateDeploymentStrategyOutput`](crate::output::CreateDeploymentStrategyOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::CreateDeploymentStrategyOutput::id): <p>The deployment strategy ID.</p>
    ///   - [`name(Option<String>)`](crate::output::CreateDeploymentStrategyOutput::name): <p>The name of the deployment strategy.</p>
    ///   - [`description(Option<String>)`](crate::output::CreateDeploymentStrategyOutput::description): <p>The description of the deployment strategy.</p>
    ///   - [`deployment_duration_in_minutes(i32)`](crate::output::CreateDeploymentStrategyOutput::deployment_duration_in_minutes): <p>Total amount of time the deployment lasted.</p>
    ///   - [`growth_type(Option<GrowthType>)`](crate::output::CreateDeploymentStrategyOutput::growth_type): <p>The algorithm used to define how percentage grew over time.</p>
    ///   - [`growth_factor(f32)`](crate::output::CreateDeploymentStrategyOutput::growth_factor): <p>The percentage of targets that received a deployed configuration during each interval.</p>
    ///   - [`final_bake_time_in_minutes(i32)`](crate::output::CreateDeploymentStrategyOutput::final_bake_time_in_minutes): <p>The amount of time that AppConfig monitored for alarms before considering the deployment to be complete and no longer eligible for automatic rollback.</p>
    ///   - [`replicate_to(Option<ReplicateTo>)`](crate::output::CreateDeploymentStrategyOutput::replicate_to): <p>Save the deployment strategy to a Systems Manager (SSM) document.</p>
    /// - On failure, responds with [`SdkError<CreateDeploymentStrategyError>`](crate::error::CreateDeploymentStrategyError)
    pub fn create_deployment_strategy(&self) -> fluent_builders::CreateDeploymentStrategy {
        fluent_builders::CreateDeploymentStrategy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateEnvironment`](crate::client::fluent_builders::CreateEnvironment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::CreateEnvironment::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::CreateEnvironment::set_application_id): <p>The application ID.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateEnvironment::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateEnvironment::set_name): <p>A name for the environment.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateEnvironment::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateEnvironment::set_description): <p>A description of the environment.</p>
    ///   - [`monitors(Vec<Monitor>)`](crate::client::fluent_builders::CreateEnvironment::monitors) / [`set_monitors(Option<Vec<Monitor>>)`](crate::client::fluent_builders::CreateEnvironment::set_monitors): <p>Amazon CloudWatch alarms to monitor during the deployment process.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateEnvironment::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateEnvironment::set_tags): <p>Metadata to assign to the environment. Tags help organize and categorize your AppConfig resources. Each tag consists of a key and an optional value, both of which you define.</p>
    /// - On success, responds with [`CreateEnvironmentOutput`](crate::output::CreateEnvironmentOutput) with field(s):
    ///   - [`application_id(Option<String>)`](crate::output::CreateEnvironmentOutput::application_id): <p>The application ID.</p>
    ///   - [`id(Option<String>)`](crate::output::CreateEnvironmentOutput::id): <p>The environment ID.</p>
    ///   - [`name(Option<String>)`](crate::output::CreateEnvironmentOutput::name): <p>The name of the environment.</p>
    ///   - [`description(Option<String>)`](crate::output::CreateEnvironmentOutput::description): <p>The description of the environment.</p>
    ///   - [`state(Option<EnvironmentState>)`](crate::output::CreateEnvironmentOutput::state): <p>The state of the environment. An environment can be in one of the following states: <code>READY_FOR_DEPLOYMENT</code>, <code>DEPLOYING</code>, <code>ROLLING_BACK</code>, or <code>ROLLED_BACK</code> </p>
    ///   - [`monitors(Option<Vec<Monitor>>)`](crate::output::CreateEnvironmentOutput::monitors): <p>Amazon CloudWatch alarms monitored during the deployment.</p>
    /// - On failure, responds with [`SdkError<CreateEnvironmentError>`](crate::error::CreateEnvironmentError)
    pub fn create_environment(&self) -> fluent_builders::CreateEnvironment {
        fluent_builders::CreateEnvironment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateHostedConfigurationVersion`](crate::client::fluent_builders::CreateHostedConfigurationVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::CreateHostedConfigurationVersion::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::CreateHostedConfigurationVersion::set_application_id): <p>The application ID.</p>
    ///   - [`configuration_profile_id(impl Into<String>)`](crate::client::fluent_builders::CreateHostedConfigurationVersion::configuration_profile_id) / [`set_configuration_profile_id(Option<String>)`](crate::client::fluent_builders::CreateHostedConfigurationVersion::set_configuration_profile_id): <p>The configuration profile ID.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateHostedConfigurationVersion::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateHostedConfigurationVersion::set_description): <p>A description of the configuration.</p>
    ///   - [`content(Blob)`](crate::client::fluent_builders::CreateHostedConfigurationVersion::content) / [`set_content(Option<Blob>)`](crate::client::fluent_builders::CreateHostedConfigurationVersion::set_content): <p>The content of the configuration or the configuration data.</p>
    ///   - [`content_type(impl Into<String>)`](crate::client::fluent_builders::CreateHostedConfigurationVersion::content_type) / [`set_content_type(Option<String>)`](crate::client::fluent_builders::CreateHostedConfigurationVersion::set_content_type): <p>A standard MIME type describing the format of the configuration content. For more information, see <a href="https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17">Content-Type</a>.</p>
    ///   - [`latest_version_number(i32)`](crate::client::fluent_builders::CreateHostedConfigurationVersion::latest_version_number) / [`set_latest_version_number(Option<i32>)`](crate::client::fluent_builders::CreateHostedConfigurationVersion::set_latest_version_number): <p>An optional locking token used to prevent race conditions from overwriting configuration updates when creating a new version. To ensure your data is not overwritten when creating multiple hosted configuration versions in rapid succession, specify the version number of the latest hosted configuration version.</p>
    /// - On success, responds with [`CreateHostedConfigurationVersionOutput`](crate::output::CreateHostedConfigurationVersionOutput) with field(s):
    ///   - [`application_id(Option<String>)`](crate::output::CreateHostedConfigurationVersionOutput::application_id): <p>The application ID.</p>
    ///   - [`configuration_profile_id(Option<String>)`](crate::output::CreateHostedConfigurationVersionOutput::configuration_profile_id): <p>The configuration profile ID.</p>
    ///   - [`version_number(i32)`](crate::output::CreateHostedConfigurationVersionOutput::version_number): <p>The configuration version.</p>
    ///   - [`description(Option<String>)`](crate::output::CreateHostedConfigurationVersionOutput::description): <p>A description of the configuration.</p>
    ///   - [`content(Option<Blob>)`](crate::output::CreateHostedConfigurationVersionOutput::content): <p>The content of the configuration or the configuration data.</p>
    ///   - [`content_type(Option<String>)`](crate::output::CreateHostedConfigurationVersionOutput::content_type): <p>A standard MIME type describing the format of the configuration content. For more information, see <a href="https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17">Content-Type</a>.</p>
    /// - On failure, responds with [`SdkError<CreateHostedConfigurationVersionError>`](crate::error::CreateHostedConfigurationVersionError)
    pub fn create_hosted_configuration_version(
        &self,
    ) -> fluent_builders::CreateHostedConfigurationVersion {
        fluent_builders::CreateHostedConfigurationVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteApplication`](crate::client::fluent_builders::DeleteApplication) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::DeleteApplication::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::DeleteApplication::set_application_id): <p>The ID of the application to delete.</p>
    /// - On success, responds with [`DeleteApplicationOutput`](crate::output::DeleteApplicationOutput)

    /// - On failure, responds with [`SdkError<DeleteApplicationError>`](crate::error::DeleteApplicationError)
    pub fn delete_application(&self) -> fluent_builders::DeleteApplication {
        fluent_builders::DeleteApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteConfigurationProfile`](crate::client::fluent_builders::DeleteConfigurationProfile) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::DeleteConfigurationProfile::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::DeleteConfigurationProfile::set_application_id): <p>The application ID that includes the configuration profile you want to delete.</p>
    ///   - [`configuration_profile_id(impl Into<String>)`](crate::client::fluent_builders::DeleteConfigurationProfile::configuration_profile_id) / [`set_configuration_profile_id(Option<String>)`](crate::client::fluent_builders::DeleteConfigurationProfile::set_configuration_profile_id): <p>The ID of the configuration profile you want to delete.</p>
    /// - On success, responds with [`DeleteConfigurationProfileOutput`](crate::output::DeleteConfigurationProfileOutput)

    /// - On failure, responds with [`SdkError<DeleteConfigurationProfileError>`](crate::error::DeleteConfigurationProfileError)
    pub fn delete_configuration_profile(&self) -> fluent_builders::DeleteConfigurationProfile {
        fluent_builders::DeleteConfigurationProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDeploymentStrategy`](crate::client::fluent_builders::DeleteDeploymentStrategy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`deployment_strategy_id(impl Into<String>)`](crate::client::fluent_builders::DeleteDeploymentStrategy::deployment_strategy_id) / [`set_deployment_strategy_id(Option<String>)`](crate::client::fluent_builders::DeleteDeploymentStrategy::set_deployment_strategy_id): <p>The ID of the deployment strategy you want to delete.</p>
    /// - On success, responds with [`DeleteDeploymentStrategyOutput`](crate::output::DeleteDeploymentStrategyOutput)

    /// - On failure, responds with [`SdkError<DeleteDeploymentStrategyError>`](crate::error::DeleteDeploymentStrategyError)
    pub fn delete_deployment_strategy(&self) -> fluent_builders::DeleteDeploymentStrategy {
        fluent_builders::DeleteDeploymentStrategy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteEnvironment`](crate::client::fluent_builders::DeleteEnvironment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::DeleteEnvironment::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::DeleteEnvironment::set_application_id): <p>The application ID that includes the environment that you want to delete.</p>
    ///   - [`environment_id(impl Into<String>)`](crate::client::fluent_builders::DeleteEnvironment::environment_id) / [`set_environment_id(Option<String>)`](crate::client::fluent_builders::DeleteEnvironment::set_environment_id): <p>The ID of the environment that you want to delete.</p>
    /// - On success, responds with [`DeleteEnvironmentOutput`](crate::output::DeleteEnvironmentOutput)

    /// - On failure, responds with [`SdkError<DeleteEnvironmentError>`](crate::error::DeleteEnvironmentError)
    pub fn delete_environment(&self) -> fluent_builders::DeleteEnvironment {
        fluent_builders::DeleteEnvironment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteHostedConfigurationVersion`](crate::client::fluent_builders::DeleteHostedConfigurationVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::DeleteHostedConfigurationVersion::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::DeleteHostedConfigurationVersion::set_application_id): <p>The application ID.</p>
    ///   - [`configuration_profile_id(impl Into<String>)`](crate::client::fluent_builders::DeleteHostedConfigurationVersion::configuration_profile_id) / [`set_configuration_profile_id(Option<String>)`](crate::client::fluent_builders::DeleteHostedConfigurationVersion::set_configuration_profile_id): <p>The configuration profile ID.</p>
    ///   - [`version_number(i32)`](crate::client::fluent_builders::DeleteHostedConfigurationVersion::version_number) / [`set_version_number(i32)`](crate::client::fluent_builders::DeleteHostedConfigurationVersion::set_version_number): <p>The versions number to delete.</p>
    /// - On success, responds with [`DeleteHostedConfigurationVersionOutput`](crate::output::DeleteHostedConfigurationVersionOutput)

    /// - On failure, responds with [`SdkError<DeleteHostedConfigurationVersionError>`](crate::error::DeleteHostedConfigurationVersionError)
    pub fn delete_hosted_configuration_version(
        &self,
    ) -> fluent_builders::DeleteHostedConfigurationVersion {
        fluent_builders::DeleteHostedConfigurationVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetApplication`](crate::client::fluent_builders::GetApplication) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::GetApplication::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::GetApplication::set_application_id): <p>The ID of the application you want to get.</p>
    /// - On success, responds with [`GetApplicationOutput`](crate::output::GetApplicationOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::GetApplicationOutput::id): <p>The application ID.</p>
    ///   - [`name(Option<String>)`](crate::output::GetApplicationOutput::name): <p>The application name.</p>
    ///   - [`description(Option<String>)`](crate::output::GetApplicationOutput::description): <p>The description of the application.</p>
    /// - On failure, responds with [`SdkError<GetApplicationError>`](crate::error::GetApplicationError)
    pub fn get_application(&self) -> fluent_builders::GetApplication {
        fluent_builders::GetApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetConfiguration`](crate::client::fluent_builders::GetConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application(impl Into<String>)`](crate::client::fluent_builders::GetConfiguration::application) / [`set_application(Option<String>)`](crate::client::fluent_builders::GetConfiguration::set_application): <p>The application to get. Specify either the application name or the application ID.</p>
    ///   - [`environment(impl Into<String>)`](crate::client::fluent_builders::GetConfiguration::environment) / [`set_environment(Option<String>)`](crate::client::fluent_builders::GetConfiguration::set_environment): <p>The environment to get. Specify either the environment name or the environment ID.</p>
    ///   - [`configuration(impl Into<String>)`](crate::client::fluent_builders::GetConfiguration::configuration) / [`set_configuration(Option<String>)`](crate::client::fluent_builders::GetConfiguration::set_configuration): <p>The configuration to get. Specify either the configuration name or the configuration ID.</p>
    ///   - [`client_id(impl Into<String>)`](crate::client::fluent_builders::GetConfiguration::client_id) / [`set_client_id(Option<String>)`](crate::client::fluent_builders::GetConfiguration::set_client_id): <p>The clientId parameter in the following command is a unique, user-specified ID to identify the client for the configuration. This ID enables AppConfig to deploy the configuration in intervals, as defined in the deployment strategy. </p>
    ///   - [`client_configuration_version(impl Into<String>)`](crate::client::fluent_builders::GetConfiguration::client_configuration_version) / [`set_client_configuration_version(Option<String>)`](crate::client::fluent_builders::GetConfiguration::set_client_configuration_version): <p>The configuration version returned in the most recent <code>GetConfiguration</code> response.</p> <important>   <p>AppConfig uses the value of the <code>ClientConfigurationVersion</code> parameter to identify the configuration version on your clients. If you don’t send <code>ClientConfigurationVersion</code> with each call to <code>GetConfiguration</code>, your clients receive the current configuration. You are charged each time your clients receive a configuration.</p>   <p>To avoid excess charges, we recommend that you include the <code>ClientConfigurationVersion</code> value with every call to <code>GetConfiguration</code>. This value must be saved on your client. Subsequent calls to <code>GetConfiguration</code> must pass this value by using the <code>ClientConfigurationVersion</code> parameter. </p>  </important>  <p>For more information about working with configurations, see <a href="http://docs.aws.amazon.com/appconfig/latest/userguide/appconfig-retrieving-the-configuration.html">Retrieving the Configuration</a> in the <i>AppConfig User Guide</i>.</p>
    /// - On success, responds with [`GetConfigurationOutput`](crate::output::GetConfigurationOutput) with field(s):
    ///   - [`content(Option<Blob>)`](crate::output::GetConfigurationOutput::content): <p>The content of the configuration or the configuration data.</p> <important>   <p>The <code>Content</code> attribute only contains data if the system finds new or updated configuration data. If there is no new or updated data and <code>ClientConfigurationVersion</code> matches the version of the current configuration, AppConfig returns a <code>204 No Content</code> HTTP response code and the <code>Content</code> value will be empty.</p>  </important>
    ///   - [`configuration_version(Option<String>)`](crate::output::GetConfigurationOutput::configuration_version): <p>The configuration version.</p>
    ///   - [`content_type(Option<String>)`](crate::output::GetConfigurationOutput::content_type): <p>A standard MIME type describing the format of the configuration content. For more information, see <a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17">Content-Type</a>.</p>
    /// - On failure, responds with [`SdkError<GetConfigurationError>`](crate::error::GetConfigurationError)
    pub fn get_configuration(&self) -> fluent_builders::GetConfiguration {
        fluent_builders::GetConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetConfigurationProfile`](crate::client::fluent_builders::GetConfigurationProfile) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::GetConfigurationProfile::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::GetConfigurationProfile::set_application_id): <p>The ID of the application that includes the configuration profile you want to get.</p>
    ///   - [`configuration_profile_id(impl Into<String>)`](crate::client::fluent_builders::GetConfigurationProfile::configuration_profile_id) / [`set_configuration_profile_id(Option<String>)`](crate::client::fluent_builders::GetConfigurationProfile::set_configuration_profile_id): <p>The ID of the configuration profile that you want to get.</p>
    /// - On success, responds with [`GetConfigurationProfileOutput`](crate::output::GetConfigurationProfileOutput) with field(s):
    ///   - [`application_id(Option<String>)`](crate::output::GetConfigurationProfileOutput::application_id): <p>The application ID.</p>
    ///   - [`id(Option<String>)`](crate::output::GetConfigurationProfileOutput::id): <p>The configuration profile ID.</p>
    ///   - [`name(Option<String>)`](crate::output::GetConfigurationProfileOutput::name): <p>The name of the configuration profile.</p>
    ///   - [`description(Option<String>)`](crate::output::GetConfigurationProfileOutput::description): <p>The configuration profile description.</p>
    ///   - [`location_uri(Option<String>)`](crate::output::GetConfigurationProfileOutput::location_uri): <p>The URI location of the configuration.</p>
    ///   - [`retrieval_role_arn(Option<String>)`](crate::output::GetConfigurationProfileOutput::retrieval_role_arn): <p>The ARN of an IAM role with permission to access the configuration at the specified <code>LocationUri</code>.</p>
    ///   - [`validators(Option<Vec<Validator>>)`](crate::output::GetConfigurationProfileOutput::validators): <p>A list of methods for validating the configuration.</p>
    ///   - [`r#type(Option<String>)`](crate::output::GetConfigurationProfileOutput::type): <p>The type of configurations contained in the profile. AppConfig supports <code>feature flags</code> and <code>freeform</code> configurations. We recommend you create feature flag configurations to enable or disable new features and freeform configurations to distribute configurations to an application. When calling this API, enter one of the following values for <code>Type</code>:</p>  <p> <code>AWS.AppConfig.FeatureFlags</code> </p>  <p> <code>AWS.Freeform</code> </p>
    /// - On failure, responds with [`SdkError<GetConfigurationProfileError>`](crate::error::GetConfigurationProfileError)
    pub fn get_configuration_profile(&self) -> fluent_builders::GetConfigurationProfile {
        fluent_builders::GetConfigurationProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDeployment`](crate::client::fluent_builders::GetDeployment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::GetDeployment::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::GetDeployment::set_application_id): <p>The ID of the application that includes the deployment you want to get. </p>
    ///   - [`environment_id(impl Into<String>)`](crate::client::fluent_builders::GetDeployment::environment_id) / [`set_environment_id(Option<String>)`](crate::client::fluent_builders::GetDeployment::set_environment_id): <p>The ID of the environment that includes the deployment you want to get. </p>
    ///   - [`deployment_number(i32)`](crate::client::fluent_builders::GetDeployment::deployment_number) / [`set_deployment_number(Option<i32>)`](crate::client::fluent_builders::GetDeployment::set_deployment_number): <p>The sequence number of the deployment.</p>
    /// - On success, responds with [`GetDeploymentOutput`](crate::output::GetDeploymentOutput) with field(s):
    ///   - [`application_id(Option<String>)`](crate::output::GetDeploymentOutput::application_id): <p>The ID of the application that was deployed.</p>
    ///   - [`environment_id(Option<String>)`](crate::output::GetDeploymentOutput::environment_id): <p>The ID of the environment that was deployed.</p>
    ///   - [`deployment_strategy_id(Option<String>)`](crate::output::GetDeploymentOutput::deployment_strategy_id): <p>The ID of the deployment strategy that was deployed.</p>
    ///   - [`configuration_profile_id(Option<String>)`](crate::output::GetDeploymentOutput::configuration_profile_id): <p>The ID of the configuration profile that was deployed.</p>
    ///   - [`deployment_number(i32)`](crate::output::GetDeploymentOutput::deployment_number): <p>The sequence number of the deployment.</p>
    ///   - [`configuration_name(Option<String>)`](crate::output::GetDeploymentOutput::configuration_name): <p>The name of the configuration.</p>
    ///   - [`configuration_location_uri(Option<String>)`](crate::output::GetDeploymentOutput::configuration_location_uri): <p>Information about the source location of the configuration.</p>
    ///   - [`configuration_version(Option<String>)`](crate::output::GetDeploymentOutput::configuration_version): <p>The configuration version that was deployed.</p>
    ///   - [`description(Option<String>)`](crate::output::GetDeploymentOutput::description): <p>The description of the deployment.</p>
    ///   - [`deployment_duration_in_minutes(i32)`](crate::output::GetDeploymentOutput::deployment_duration_in_minutes): <p>Total amount of time the deployment lasted.</p>
    ///   - [`growth_type(Option<GrowthType>)`](crate::output::GetDeploymentOutput::growth_type): <p>The algorithm used to define how percentage grew over time.</p>
    ///   - [`growth_factor(f32)`](crate::output::GetDeploymentOutput::growth_factor): <p>The percentage of targets to receive a deployed configuration during each interval.</p>
    ///   - [`final_bake_time_in_minutes(i32)`](crate::output::GetDeploymentOutput::final_bake_time_in_minutes): <p>The amount of time that AppConfig monitored for alarms before considering the deployment to be complete and no longer eligible for automatic rollback.</p>
    ///   - [`state(Option<DeploymentState>)`](crate::output::GetDeploymentOutput::state): <p>The state of the deployment.</p>
    ///   - [`event_log(Option<Vec<DeploymentEvent>>)`](crate::output::GetDeploymentOutput::event_log): <p>A list containing all events related to a deployment. The most recent events are displayed first.</p>
    ///   - [`percentage_complete(f32)`](crate::output::GetDeploymentOutput::percentage_complete): <p>The percentage of targets for which the deployment is available.</p>
    ///   - [`started_at(Option<DateTime>)`](crate::output::GetDeploymentOutput::started_at): <p>The time the deployment started.</p>
    ///   - [`completed_at(Option<DateTime>)`](crate::output::GetDeploymentOutput::completed_at): <p>The time the deployment completed. </p>
    /// - On failure, responds with [`SdkError<GetDeploymentError>`](crate::error::GetDeploymentError)
    pub fn get_deployment(&self) -> fluent_builders::GetDeployment {
        fluent_builders::GetDeployment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDeploymentStrategy`](crate::client::fluent_builders::GetDeploymentStrategy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`deployment_strategy_id(impl Into<String>)`](crate::client::fluent_builders::GetDeploymentStrategy::deployment_strategy_id) / [`set_deployment_strategy_id(Option<String>)`](crate::client::fluent_builders::GetDeploymentStrategy::set_deployment_strategy_id): <p>The ID of the deployment strategy to get.</p>
    /// - On success, responds with [`GetDeploymentStrategyOutput`](crate::output::GetDeploymentStrategyOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::GetDeploymentStrategyOutput::id): <p>The deployment strategy ID.</p>
    ///   - [`name(Option<String>)`](crate::output::GetDeploymentStrategyOutput::name): <p>The name of the deployment strategy.</p>
    ///   - [`description(Option<String>)`](crate::output::GetDeploymentStrategyOutput::description): <p>The description of the deployment strategy.</p>
    ///   - [`deployment_duration_in_minutes(i32)`](crate::output::GetDeploymentStrategyOutput::deployment_duration_in_minutes): <p>Total amount of time the deployment lasted.</p>
    ///   - [`growth_type(Option<GrowthType>)`](crate::output::GetDeploymentStrategyOutput::growth_type): <p>The algorithm used to define how percentage grew over time.</p>
    ///   - [`growth_factor(f32)`](crate::output::GetDeploymentStrategyOutput::growth_factor): <p>The percentage of targets that received a deployed configuration during each interval.</p>
    ///   - [`final_bake_time_in_minutes(i32)`](crate::output::GetDeploymentStrategyOutput::final_bake_time_in_minutes): <p>The amount of time that AppConfig monitored for alarms before considering the deployment to be complete and no longer eligible for automatic rollback.</p>
    ///   - [`replicate_to(Option<ReplicateTo>)`](crate::output::GetDeploymentStrategyOutput::replicate_to): <p>Save the deployment strategy to a Systems Manager (SSM) document.</p>
    /// - On failure, responds with [`SdkError<GetDeploymentStrategyError>`](crate::error::GetDeploymentStrategyError)
    pub fn get_deployment_strategy(&self) -> fluent_builders::GetDeploymentStrategy {
        fluent_builders::GetDeploymentStrategy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetEnvironment`](crate::client::fluent_builders::GetEnvironment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::GetEnvironment::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::GetEnvironment::set_application_id): <p>The ID of the application that includes the environment you want to get.</p>
    ///   - [`environment_id(impl Into<String>)`](crate::client::fluent_builders::GetEnvironment::environment_id) / [`set_environment_id(Option<String>)`](crate::client::fluent_builders::GetEnvironment::set_environment_id): <p>The ID of the environment that you want to get.</p>
    /// - On success, responds with [`GetEnvironmentOutput`](crate::output::GetEnvironmentOutput) with field(s):
    ///   - [`application_id(Option<String>)`](crate::output::GetEnvironmentOutput::application_id): <p>The application ID.</p>
    ///   - [`id(Option<String>)`](crate::output::GetEnvironmentOutput::id): <p>The environment ID.</p>
    ///   - [`name(Option<String>)`](crate::output::GetEnvironmentOutput::name): <p>The name of the environment.</p>
    ///   - [`description(Option<String>)`](crate::output::GetEnvironmentOutput::description): <p>The description of the environment.</p>
    ///   - [`state(Option<EnvironmentState>)`](crate::output::GetEnvironmentOutput::state): <p>The state of the environment. An environment can be in one of the following states: <code>READY_FOR_DEPLOYMENT</code>, <code>DEPLOYING</code>, <code>ROLLING_BACK</code>, or <code>ROLLED_BACK</code> </p>
    ///   - [`monitors(Option<Vec<Monitor>>)`](crate::output::GetEnvironmentOutput::monitors): <p>Amazon CloudWatch alarms monitored during the deployment.</p>
    /// - On failure, responds with [`SdkError<GetEnvironmentError>`](crate::error::GetEnvironmentError)
    pub fn get_environment(&self) -> fluent_builders::GetEnvironment {
        fluent_builders::GetEnvironment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetHostedConfigurationVersion`](crate::client::fluent_builders::GetHostedConfigurationVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::GetHostedConfigurationVersion::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::GetHostedConfigurationVersion::set_application_id): <p>The application ID.</p>
    ///   - [`configuration_profile_id(impl Into<String>)`](crate::client::fluent_builders::GetHostedConfigurationVersion::configuration_profile_id) / [`set_configuration_profile_id(Option<String>)`](crate::client::fluent_builders::GetHostedConfigurationVersion::set_configuration_profile_id): <p>The configuration profile ID.</p>
    ///   - [`version_number(i32)`](crate::client::fluent_builders::GetHostedConfigurationVersion::version_number) / [`set_version_number(i32)`](crate::client::fluent_builders::GetHostedConfigurationVersion::set_version_number): <p>The version.</p>
    /// - On success, responds with [`GetHostedConfigurationVersionOutput`](crate::output::GetHostedConfigurationVersionOutput) with field(s):
    ///   - [`application_id(Option<String>)`](crate::output::GetHostedConfigurationVersionOutput::application_id): <p>The application ID.</p>
    ///   - [`configuration_profile_id(Option<String>)`](crate::output::GetHostedConfigurationVersionOutput::configuration_profile_id): <p>The configuration profile ID.</p>
    ///   - [`version_number(i32)`](crate::output::GetHostedConfigurationVersionOutput::version_number): <p>The configuration version.</p>
    ///   - [`description(Option<String>)`](crate::output::GetHostedConfigurationVersionOutput::description): <p>A description of the configuration.</p>
    ///   - [`content(Option<Blob>)`](crate::output::GetHostedConfigurationVersionOutput::content): <p>The content of the configuration or the configuration data.</p>
    ///   - [`content_type(Option<String>)`](crate::output::GetHostedConfigurationVersionOutput::content_type): <p>A standard MIME type describing the format of the configuration content. For more information, see <a href="https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17">Content-Type</a>.</p>
    /// - On failure, responds with [`SdkError<GetHostedConfigurationVersionError>`](crate::error::GetHostedConfigurationVersionError)
    pub fn get_hosted_configuration_version(
        &self,
    ) -> fluent_builders::GetHostedConfigurationVersion {
        fluent_builders::GetHostedConfigurationVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListApplications`](crate::client::fluent_builders::ListApplications) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListApplications::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListApplications::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListApplications::set_max_results): <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListApplications::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListApplications::set_next_token): <p>A token to start the list. Next token is a pagination token generated by AppConfig to describe what page the previous List call ended on. For the first List request, the nextToken should not be set. On subsequent calls, the nextToken parameter should be set to the previous responses nextToken value. Use this token to get the next set of results. </p>
    /// - On success, responds with [`ListApplicationsOutput`](crate::output::ListApplicationsOutput) with field(s):
    ///   - [`items(Option<Vec<Application>>)`](crate::output::ListApplicationsOutput::items): <p>The elements from this collection.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListApplicationsOutput::next_token): <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListApplicationsError>`](crate::error::ListApplicationsError)
    pub fn list_applications(&self) -> fluent_builders::ListApplications {
        fluent_builders::ListApplications::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListConfigurationProfiles`](crate::client::fluent_builders::ListConfigurationProfiles) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListConfigurationProfiles::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::ListConfigurationProfiles::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::ListConfigurationProfiles::set_application_id): <p>The application ID.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListConfigurationProfiles::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListConfigurationProfiles::set_max_results): <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListConfigurationProfiles::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListConfigurationProfiles::set_next_token): <p>A token to start the list. Use this token to get the next set of results.</p>
    ///   - [`r#type(impl Into<String>)`](crate::client::fluent_builders::ListConfigurationProfiles::type) / [`set_type(Option<String>)`](crate::client::fluent_builders::ListConfigurationProfiles::set_type): <p>A filter based on the type of configurations that the configuration profile contains. A configuration can be a feature flag or a freeform configuration.</p>
    /// - On success, responds with [`ListConfigurationProfilesOutput`](crate::output::ListConfigurationProfilesOutput) with field(s):
    ///   - [`items(Option<Vec<ConfigurationProfileSummary>>)`](crate::output::ListConfigurationProfilesOutput::items): <p>The elements from this collection.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListConfigurationProfilesOutput::next_token): <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListConfigurationProfilesError>`](crate::error::ListConfigurationProfilesError)
    pub fn list_configuration_profiles(&self) -> fluent_builders::ListConfigurationProfiles {
        fluent_builders::ListConfigurationProfiles::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDeployments`](crate::client::fluent_builders::ListDeployments) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListDeployments::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::ListDeployments::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::ListDeployments::set_application_id): <p>The application ID.</p>
    ///   - [`environment_id(impl Into<String>)`](crate::client::fluent_builders::ListDeployments::environment_id) / [`set_environment_id(Option<String>)`](crate::client::fluent_builders::ListDeployments::set_environment_id): <p>The environment ID.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListDeployments::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListDeployments::set_max_results): <p>The maximum number of items that may be returned for this call. If there are items that have not yet been returned, the response will include a non-null <code>NextToken</code> that you can provide in a subsequent call to get the next set of results.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDeployments::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDeployments::set_next_token): <p>The token returned by a prior call to this operation indicating the next set of results to be returned. If not specified, the operation will return the first set of results.</p>
    /// - On success, responds with [`ListDeploymentsOutput`](crate::output::ListDeploymentsOutput) with field(s):
    ///   - [`items(Option<Vec<DeploymentSummary>>)`](crate::output::ListDeploymentsOutput::items): <p>The elements from this collection.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDeploymentsOutput::next_token): <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListDeploymentsError>`](crate::error::ListDeploymentsError)
    pub fn list_deployments(&self) -> fluent_builders::ListDeployments {
        fluent_builders::ListDeployments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDeploymentStrategies`](crate::client::fluent_builders::ListDeploymentStrategies) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListDeploymentStrategies::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListDeploymentStrategies::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListDeploymentStrategies::set_max_results): <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDeploymentStrategies::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDeploymentStrategies::set_next_token): <p>A token to start the list. Use this token to get the next set of results.</p>
    /// - On success, responds with [`ListDeploymentStrategiesOutput`](crate::output::ListDeploymentStrategiesOutput) with field(s):
    ///   - [`items(Option<Vec<DeploymentStrategy>>)`](crate::output::ListDeploymentStrategiesOutput::items): <p>The elements from this collection.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDeploymentStrategiesOutput::next_token): <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListDeploymentStrategiesError>`](crate::error::ListDeploymentStrategiesError)
    pub fn list_deployment_strategies(&self) -> fluent_builders::ListDeploymentStrategies {
        fluent_builders::ListDeploymentStrategies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListEnvironments`](crate::client::fluent_builders::ListEnvironments) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListEnvironments::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::ListEnvironments::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::ListEnvironments::set_application_id): <p>The application ID.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListEnvironments::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListEnvironments::set_max_results): <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListEnvironments::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListEnvironments::set_next_token): <p>A token to start the list. Use this token to get the next set of results.</p>
    /// - On success, responds with [`ListEnvironmentsOutput`](crate::output::ListEnvironmentsOutput) with field(s):
    ///   - [`items(Option<Vec<Environment>>)`](crate::output::ListEnvironmentsOutput::items): <p>The elements from this collection.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListEnvironmentsOutput::next_token): <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListEnvironmentsError>`](crate::error::ListEnvironmentsError)
    pub fn list_environments(&self) -> fluent_builders::ListEnvironments {
        fluent_builders::ListEnvironments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListHostedConfigurationVersions`](crate::client::fluent_builders::ListHostedConfigurationVersions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListHostedConfigurationVersions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::ListHostedConfigurationVersions::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::ListHostedConfigurationVersions::set_application_id): <p>The application ID.</p>
    ///   - [`configuration_profile_id(impl Into<String>)`](crate::client::fluent_builders::ListHostedConfigurationVersions::configuration_profile_id) / [`set_configuration_profile_id(Option<String>)`](crate::client::fluent_builders::ListHostedConfigurationVersions::set_configuration_profile_id): <p>The configuration profile ID.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListHostedConfigurationVersions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListHostedConfigurationVersions::set_max_results): <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListHostedConfigurationVersions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListHostedConfigurationVersions::set_next_token): <p>A token to start the list. Use this token to get the next set of results. </p>
    /// - On success, responds with [`ListHostedConfigurationVersionsOutput`](crate::output::ListHostedConfigurationVersionsOutput) with field(s):
    ///   - [`items(Option<Vec<HostedConfigurationVersionSummary>>)`](crate::output::ListHostedConfigurationVersionsOutput::items): <p>The elements from this collection.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListHostedConfigurationVersionsOutput::next_token): <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListHostedConfigurationVersionsError>`](crate::error::ListHostedConfigurationVersionsError)
    pub fn list_hosted_configuration_versions(
        &self,
    ) -> fluent_builders::ListHostedConfigurationVersions {
        fluent_builders::ListHostedConfigurationVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The resource ARN.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsForResourceOutput::tags): <p>Metadata to assign to AppConfig resources. Tags help organize and categorize your AppConfig resources. Each tag consists of a key and an optional value, both of which you define.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartDeployment`](crate::client::fluent_builders::StartDeployment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::StartDeployment::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::StartDeployment::set_application_id): <p>The application ID.</p>
    ///   - [`environment_id(impl Into<String>)`](crate::client::fluent_builders::StartDeployment::environment_id) / [`set_environment_id(Option<String>)`](crate::client::fluent_builders::StartDeployment::set_environment_id): <p>The environment ID.</p>
    ///   - [`deployment_strategy_id(impl Into<String>)`](crate::client::fluent_builders::StartDeployment::deployment_strategy_id) / [`set_deployment_strategy_id(Option<String>)`](crate::client::fluent_builders::StartDeployment::set_deployment_strategy_id): <p>The deployment strategy ID.</p>
    ///   - [`configuration_profile_id(impl Into<String>)`](crate::client::fluent_builders::StartDeployment::configuration_profile_id) / [`set_configuration_profile_id(Option<String>)`](crate::client::fluent_builders::StartDeployment::set_configuration_profile_id): <p>The configuration profile ID.</p>
    ///   - [`configuration_version(impl Into<String>)`](crate::client::fluent_builders::StartDeployment::configuration_version) / [`set_configuration_version(Option<String>)`](crate::client::fluent_builders::StartDeployment::set_configuration_version): <p>The configuration version to deploy.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::StartDeployment::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::StartDeployment::set_description): <p>A description of the deployment.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::StartDeployment::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::StartDeployment::set_tags): <p>Metadata to assign to the deployment. Tags help organize and categorize your AppConfig resources. Each tag consists of a key and an optional value, both of which you define.</p>
    /// - On success, responds with [`StartDeploymentOutput`](crate::output::StartDeploymentOutput) with field(s):
    ///   - [`application_id(Option<String>)`](crate::output::StartDeploymentOutput::application_id): <p>The ID of the application that was deployed.</p>
    ///   - [`environment_id(Option<String>)`](crate::output::StartDeploymentOutput::environment_id): <p>The ID of the environment that was deployed.</p>
    ///   - [`deployment_strategy_id(Option<String>)`](crate::output::StartDeploymentOutput::deployment_strategy_id): <p>The ID of the deployment strategy that was deployed.</p>
    ///   - [`configuration_profile_id(Option<String>)`](crate::output::StartDeploymentOutput::configuration_profile_id): <p>The ID of the configuration profile that was deployed.</p>
    ///   - [`deployment_number(i32)`](crate::output::StartDeploymentOutput::deployment_number): <p>The sequence number of the deployment.</p>
    ///   - [`configuration_name(Option<String>)`](crate::output::StartDeploymentOutput::configuration_name): <p>The name of the configuration.</p>
    ///   - [`configuration_location_uri(Option<String>)`](crate::output::StartDeploymentOutput::configuration_location_uri): <p>Information about the source location of the configuration.</p>
    ///   - [`configuration_version(Option<String>)`](crate::output::StartDeploymentOutput::configuration_version): <p>The configuration version that was deployed.</p>
    ///   - [`description(Option<String>)`](crate::output::StartDeploymentOutput::description): <p>The description of the deployment.</p>
    ///   - [`deployment_duration_in_minutes(i32)`](crate::output::StartDeploymentOutput::deployment_duration_in_minutes): <p>Total amount of time the deployment lasted.</p>
    ///   - [`growth_type(Option<GrowthType>)`](crate::output::StartDeploymentOutput::growth_type): <p>The algorithm used to define how percentage grew over time.</p>
    ///   - [`growth_factor(f32)`](crate::output::StartDeploymentOutput::growth_factor): <p>The percentage of targets to receive a deployed configuration during each interval.</p>
    ///   - [`final_bake_time_in_minutes(i32)`](crate::output::StartDeploymentOutput::final_bake_time_in_minutes): <p>The amount of time that AppConfig monitored for alarms before considering the deployment to be complete and no longer eligible for automatic rollback.</p>
    ///   - [`state(Option<DeploymentState>)`](crate::output::StartDeploymentOutput::state): <p>The state of the deployment.</p>
    ///   - [`event_log(Option<Vec<DeploymentEvent>>)`](crate::output::StartDeploymentOutput::event_log): <p>A list containing all events related to a deployment. The most recent events are displayed first.</p>
    ///   - [`percentage_complete(f32)`](crate::output::StartDeploymentOutput::percentage_complete): <p>The percentage of targets for which the deployment is available.</p>
    ///   - [`started_at(Option<DateTime>)`](crate::output::StartDeploymentOutput::started_at): <p>The time the deployment started.</p>
    ///   - [`completed_at(Option<DateTime>)`](crate::output::StartDeploymentOutput::completed_at): <p>The time the deployment completed. </p>
    /// - On failure, responds with [`SdkError<StartDeploymentError>`](crate::error::StartDeploymentError)
    pub fn start_deployment(&self) -> fluent_builders::StartDeployment {
        fluent_builders::StartDeployment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StopDeployment`](crate::client::fluent_builders::StopDeployment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::StopDeployment::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::StopDeployment::set_application_id): <p>The application ID.</p>
    ///   - [`environment_id(impl Into<String>)`](crate::client::fluent_builders::StopDeployment::environment_id) / [`set_environment_id(Option<String>)`](crate::client::fluent_builders::StopDeployment::set_environment_id): <p>The environment ID.</p>
    ///   - [`deployment_number(i32)`](crate::client::fluent_builders::StopDeployment::deployment_number) / [`set_deployment_number(Option<i32>)`](crate::client::fluent_builders::StopDeployment::set_deployment_number): <p>The sequence number of the deployment.</p>
    /// - On success, responds with [`StopDeploymentOutput`](crate::output::StopDeploymentOutput) with field(s):
    ///   - [`application_id(Option<String>)`](crate::output::StopDeploymentOutput::application_id): <p>The ID of the application that was deployed.</p>
    ///   - [`environment_id(Option<String>)`](crate::output::StopDeploymentOutput::environment_id): <p>The ID of the environment that was deployed.</p>
    ///   - [`deployment_strategy_id(Option<String>)`](crate::output::StopDeploymentOutput::deployment_strategy_id): <p>The ID of the deployment strategy that was deployed.</p>
    ///   - [`configuration_profile_id(Option<String>)`](crate::output::StopDeploymentOutput::configuration_profile_id): <p>The ID of the configuration profile that was deployed.</p>
    ///   - [`deployment_number(i32)`](crate::output::StopDeploymentOutput::deployment_number): <p>The sequence number of the deployment.</p>
    ///   - [`configuration_name(Option<String>)`](crate::output::StopDeploymentOutput::configuration_name): <p>The name of the configuration.</p>
    ///   - [`configuration_location_uri(Option<String>)`](crate::output::StopDeploymentOutput::configuration_location_uri): <p>Information about the source location of the configuration.</p>
    ///   - [`configuration_version(Option<String>)`](crate::output::StopDeploymentOutput::configuration_version): <p>The configuration version that was deployed.</p>
    ///   - [`description(Option<String>)`](crate::output::StopDeploymentOutput::description): <p>The description of the deployment.</p>
    ///   - [`deployment_duration_in_minutes(i32)`](crate::output::StopDeploymentOutput::deployment_duration_in_minutes): <p>Total amount of time the deployment lasted.</p>
    ///   - [`growth_type(Option<GrowthType>)`](crate::output::StopDeploymentOutput::growth_type): <p>The algorithm used to define how percentage grew over time.</p>
    ///   - [`growth_factor(f32)`](crate::output::StopDeploymentOutput::growth_factor): <p>The percentage of targets to receive a deployed configuration during each interval.</p>
    ///   - [`final_bake_time_in_minutes(i32)`](crate::output::StopDeploymentOutput::final_bake_time_in_minutes): <p>The amount of time that AppConfig monitored for alarms before considering the deployment to be complete and no longer eligible for automatic rollback.</p>
    ///   - [`state(Option<DeploymentState>)`](crate::output::StopDeploymentOutput::state): <p>The state of the deployment.</p>
    ///   - [`event_log(Option<Vec<DeploymentEvent>>)`](crate::output::StopDeploymentOutput::event_log): <p>A list containing all events related to a deployment. The most recent events are displayed first.</p>
    ///   - [`percentage_complete(f32)`](crate::output::StopDeploymentOutput::percentage_complete): <p>The percentage of targets for which the deployment is available.</p>
    ///   - [`started_at(Option<DateTime>)`](crate::output::StopDeploymentOutput::started_at): <p>The time the deployment started.</p>
    ///   - [`completed_at(Option<DateTime>)`](crate::output::StopDeploymentOutput::completed_at): <p>The time the deployment completed. </p>
    /// - On failure, responds with [`SdkError<StopDeploymentError>`](crate::error::StopDeploymentError)
    pub fn stop_deployment(&self) -> fluent_builders::StopDeployment {
        fluent_builders::StopDeployment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The ARN of the resource for which to retrieve tags.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>The key-value string map. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The ARN of the resource for which to remove tags.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The tag keys to delete.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateApplication`](crate::client::fluent_builders::UpdateApplication) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::UpdateApplication::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::UpdateApplication::set_application_id): <p>The application ID.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateApplication::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateApplication::set_name): <p>The name of the application.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateApplication::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateApplication::set_description): <p>A description of the application.</p>
    /// - On success, responds with [`UpdateApplicationOutput`](crate::output::UpdateApplicationOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::UpdateApplicationOutput::id): <p>The application ID.</p>
    ///   - [`name(Option<String>)`](crate::output::UpdateApplicationOutput::name): <p>The application name.</p>
    ///   - [`description(Option<String>)`](crate::output::UpdateApplicationOutput::description): <p>The description of the application.</p>
    /// - On failure, responds with [`SdkError<UpdateApplicationError>`](crate::error::UpdateApplicationError)
    pub fn update_application(&self) -> fluent_builders::UpdateApplication {
        fluent_builders::UpdateApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateConfigurationProfile`](crate::client::fluent_builders::UpdateConfigurationProfile) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::UpdateConfigurationProfile::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::UpdateConfigurationProfile::set_application_id): <p>The application ID.</p>
    ///   - [`configuration_profile_id(impl Into<String>)`](crate::client::fluent_builders::UpdateConfigurationProfile::configuration_profile_id) / [`set_configuration_profile_id(Option<String>)`](crate::client::fluent_builders::UpdateConfigurationProfile::set_configuration_profile_id): <p>The ID of the configuration profile.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateConfigurationProfile::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateConfigurationProfile::set_name): <p>The name of the configuration profile.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateConfigurationProfile::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateConfigurationProfile::set_description): <p>A description of the configuration profile.</p>
    ///   - [`retrieval_role_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateConfigurationProfile::retrieval_role_arn) / [`set_retrieval_role_arn(Option<String>)`](crate::client::fluent_builders::UpdateConfigurationProfile::set_retrieval_role_arn): <p>The ARN of an IAM role with permission to access the configuration at the specified <code>LocationUri</code>.</p>
    ///   - [`validators(Vec<Validator>)`](crate::client::fluent_builders::UpdateConfigurationProfile::validators) / [`set_validators(Option<Vec<Validator>>)`](crate::client::fluent_builders::UpdateConfigurationProfile::set_validators): <p>A list of methods for validating the configuration.</p>
    /// - On success, responds with [`UpdateConfigurationProfileOutput`](crate::output::UpdateConfigurationProfileOutput) with field(s):
    ///   - [`application_id(Option<String>)`](crate::output::UpdateConfigurationProfileOutput::application_id): <p>The application ID.</p>
    ///   - [`id(Option<String>)`](crate::output::UpdateConfigurationProfileOutput::id): <p>The configuration profile ID.</p>
    ///   - [`name(Option<String>)`](crate::output::UpdateConfigurationProfileOutput::name): <p>The name of the configuration profile.</p>
    ///   - [`description(Option<String>)`](crate::output::UpdateConfigurationProfileOutput::description): <p>The configuration profile description.</p>
    ///   - [`location_uri(Option<String>)`](crate::output::UpdateConfigurationProfileOutput::location_uri): <p>The URI location of the configuration.</p>
    ///   - [`retrieval_role_arn(Option<String>)`](crate::output::UpdateConfigurationProfileOutput::retrieval_role_arn): <p>The ARN of an IAM role with permission to access the configuration at the specified <code>LocationUri</code>.</p>
    ///   - [`validators(Option<Vec<Validator>>)`](crate::output::UpdateConfigurationProfileOutput::validators): <p>A list of methods for validating the configuration.</p>
    ///   - [`r#type(Option<String>)`](crate::output::UpdateConfigurationProfileOutput::type): <p>The type of configurations contained in the profile. AppConfig supports <code>feature flags</code> and <code>freeform</code> configurations. We recommend you create feature flag configurations to enable or disable new features and freeform configurations to distribute configurations to an application. When calling this API, enter one of the following values for <code>Type</code>:</p>  <p> <code>AWS.AppConfig.FeatureFlags</code> </p>  <p> <code>AWS.Freeform</code> </p>
    /// - On failure, responds with [`SdkError<UpdateConfigurationProfileError>`](crate::error::UpdateConfigurationProfileError)
    pub fn update_configuration_profile(&self) -> fluent_builders::UpdateConfigurationProfile {
        fluent_builders::UpdateConfigurationProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateDeploymentStrategy`](crate::client::fluent_builders::UpdateDeploymentStrategy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`deployment_strategy_id(impl Into<String>)`](crate::client::fluent_builders::UpdateDeploymentStrategy::deployment_strategy_id) / [`set_deployment_strategy_id(Option<String>)`](crate::client::fluent_builders::UpdateDeploymentStrategy::set_deployment_strategy_id): <p>The deployment strategy ID.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateDeploymentStrategy::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateDeploymentStrategy::set_description): <p>A description of the deployment strategy.</p>
    ///   - [`deployment_duration_in_minutes(i32)`](crate::client::fluent_builders::UpdateDeploymentStrategy::deployment_duration_in_minutes) / [`set_deployment_duration_in_minutes(Option<i32>)`](crate::client::fluent_builders::UpdateDeploymentStrategy::set_deployment_duration_in_minutes): <p>Total amount of time for a deployment to last.</p>
    ///   - [`final_bake_time_in_minutes(i32)`](crate::client::fluent_builders::UpdateDeploymentStrategy::final_bake_time_in_minutes) / [`set_final_bake_time_in_minutes(Option<i32>)`](crate::client::fluent_builders::UpdateDeploymentStrategy::set_final_bake_time_in_minutes): <p>The amount of time that AppConfig monitors for alarms before considering the deployment to be complete and no longer eligible for automatic rollback.</p>
    ///   - [`growth_factor(f32)`](crate::client::fluent_builders::UpdateDeploymentStrategy::growth_factor) / [`set_growth_factor(Option<f32>)`](crate::client::fluent_builders::UpdateDeploymentStrategy::set_growth_factor): <p>The percentage of targets to receive a deployed configuration during each interval.</p>
    ///   - [`growth_type(GrowthType)`](crate::client::fluent_builders::UpdateDeploymentStrategy::growth_type) / [`set_growth_type(Option<GrowthType>)`](crate::client::fluent_builders::UpdateDeploymentStrategy::set_growth_type): <p>The algorithm used to define how percentage grows over time. AppConfig supports the following growth types:</p>  <p> <b>Linear</b>: For this type, AppConfig processes the deployment by increments of the growth factor evenly distributed over the deployment time. For example, a linear deployment that uses a growth factor of 20 initially makes the configuration available to 20 percent of the targets. After 1/5th of the deployment time has passed, the system updates the percentage to 40 percent. This continues until 100% of the targets are set to receive the deployed configuration.</p>  <p> <b>Exponential</b>: For this type, AppConfig processes the deployment exponentially using the following formula: <code>G*(2^N)</code>. In this formula, <code>G</code> is the growth factor specified by the user and <code>N</code> is the number of steps until the configuration is deployed to all targets. For example, if you specify a growth factor of 2, then the system rolls out the configuration as follows:</p>  <p> <code>2*(2^0)</code> </p>  <p> <code>2*(2^1)</code> </p>  <p> <code>2*(2^2)</code> </p>  <p>Expressed numerically, the deployment rolls out as follows: 2% of the targets, 4% of the targets, 8% of the targets, and continues until the configuration has been deployed to all targets.</p>
    /// - On success, responds with [`UpdateDeploymentStrategyOutput`](crate::output::UpdateDeploymentStrategyOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::UpdateDeploymentStrategyOutput::id): <p>The deployment strategy ID.</p>
    ///   - [`name(Option<String>)`](crate::output::UpdateDeploymentStrategyOutput::name): <p>The name of the deployment strategy.</p>
    ///   - [`description(Option<String>)`](crate::output::UpdateDeploymentStrategyOutput::description): <p>The description of the deployment strategy.</p>
    ///   - [`deployment_duration_in_minutes(i32)`](crate::output::UpdateDeploymentStrategyOutput::deployment_duration_in_minutes): <p>Total amount of time the deployment lasted.</p>
    ///   - [`growth_type(Option<GrowthType>)`](crate::output::UpdateDeploymentStrategyOutput::growth_type): <p>The algorithm used to define how percentage grew over time.</p>
    ///   - [`growth_factor(f32)`](crate::output::UpdateDeploymentStrategyOutput::growth_factor): <p>The percentage of targets that received a deployed configuration during each interval.</p>
    ///   - [`final_bake_time_in_minutes(i32)`](crate::output::UpdateDeploymentStrategyOutput::final_bake_time_in_minutes): <p>The amount of time that AppConfig monitored for alarms before considering the deployment to be complete and no longer eligible for automatic rollback.</p>
    ///   - [`replicate_to(Option<ReplicateTo>)`](crate::output::UpdateDeploymentStrategyOutput::replicate_to): <p>Save the deployment strategy to a Systems Manager (SSM) document.</p>
    /// - On failure, responds with [`SdkError<UpdateDeploymentStrategyError>`](crate::error::UpdateDeploymentStrategyError)
    pub fn update_deployment_strategy(&self) -> fluent_builders::UpdateDeploymentStrategy {
        fluent_builders::UpdateDeploymentStrategy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateEnvironment`](crate::client::fluent_builders::UpdateEnvironment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::UpdateEnvironment::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::UpdateEnvironment::set_application_id): <p>The application ID.</p>
    ///   - [`environment_id(impl Into<String>)`](crate::client::fluent_builders::UpdateEnvironment::environment_id) / [`set_environment_id(Option<String>)`](crate::client::fluent_builders::UpdateEnvironment::set_environment_id): <p>The environment ID.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateEnvironment::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateEnvironment::set_name): <p>The name of the environment.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateEnvironment::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateEnvironment::set_description): <p>A description of the environment.</p>
    ///   - [`monitors(Vec<Monitor>)`](crate::client::fluent_builders::UpdateEnvironment::monitors) / [`set_monitors(Option<Vec<Monitor>>)`](crate::client::fluent_builders::UpdateEnvironment::set_monitors): <p>Amazon CloudWatch alarms to monitor during the deployment process.</p>
    /// - On success, responds with [`UpdateEnvironmentOutput`](crate::output::UpdateEnvironmentOutput) with field(s):
    ///   - [`application_id(Option<String>)`](crate::output::UpdateEnvironmentOutput::application_id): <p>The application ID.</p>
    ///   - [`id(Option<String>)`](crate::output::UpdateEnvironmentOutput::id): <p>The environment ID.</p>
    ///   - [`name(Option<String>)`](crate::output::UpdateEnvironmentOutput::name): <p>The name of the environment.</p>
    ///   - [`description(Option<String>)`](crate::output::UpdateEnvironmentOutput::description): <p>The description of the environment.</p>
    ///   - [`state(Option<EnvironmentState>)`](crate::output::UpdateEnvironmentOutput::state): <p>The state of the environment. An environment can be in one of the following states: <code>READY_FOR_DEPLOYMENT</code>, <code>DEPLOYING</code>, <code>ROLLING_BACK</code>, or <code>ROLLED_BACK</code> </p>
    ///   - [`monitors(Option<Vec<Monitor>>)`](crate::output::UpdateEnvironmentOutput::monitors): <p>Amazon CloudWatch alarms monitored during the deployment.</p>
    /// - On failure, responds with [`SdkError<UpdateEnvironmentError>`](crate::error::UpdateEnvironmentError)
    pub fn update_environment(&self) -> fluent_builders::UpdateEnvironment {
        fluent_builders::UpdateEnvironment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ValidateConfiguration`](crate::client::fluent_builders::ValidateConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::ValidateConfiguration::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::ValidateConfiguration::set_application_id): <p>The application ID.</p>
    ///   - [`configuration_profile_id(impl Into<String>)`](crate::client::fluent_builders::ValidateConfiguration::configuration_profile_id) / [`set_configuration_profile_id(Option<String>)`](crate::client::fluent_builders::ValidateConfiguration::set_configuration_profile_id): <p>The configuration profile ID.</p>
    ///   - [`configuration_version(impl Into<String>)`](crate::client::fluent_builders::ValidateConfiguration::configuration_version) / [`set_configuration_version(Option<String>)`](crate::client::fluent_builders::ValidateConfiguration::set_configuration_version): <p>The version of the configuration to validate.</p>
    /// - On success, responds with [`ValidateConfigurationOutput`](crate::output::ValidateConfigurationOutput)

    /// - On failure, responds with [`SdkError<ValidateConfigurationError>`](crate::error::ValidateConfigurationError)
    pub fn validate_configuration(&self) -> fluent_builders::ValidateConfiguration {
        fluent_builders::ValidateConfiguration::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateApplication`.
    ///
    /// <p>Creates an application. An application in AppConfig is a logical unit of code that provides capabilities for your customers. For example, an application can be a microservice that runs on Amazon EC2 instances, a mobile application installed by your users, a serverless application using Amazon API Gateway and Lambda, or any system you run on behalf of others.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateApplication {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_application_input::Builder,
    }
    impl CreateApplication {
        /// Creates a new `CreateApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateApplicationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A name for the application.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A name for the application.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A description of the application.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the application.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata to assign to the application. Tags help organize and categorize your AppConfig resources. Each tag consists of a key and an optional value, both of which you define.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Metadata to assign to the application. Tags help organize and categorize your AppConfig resources. Each tag consists of a key and an optional value, both of which you define.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateConfigurationProfile`.
    ///
    /// <p>Creates a configuration profile, which is information that enables AppConfig to access the configuration source. Valid configuration sources include the AppConfig hosted configuration store, Amazon Web Services Systems Manager (SSM) documents, SSM Parameter Store parameters, Amazon S3 objects, or any <a href="http://docs.aws.amazon.com/codepipeline/latest/userguide/integrations-action-type.html#integrations-source">integration source action</a> supported by CodePipeline. A configuration profile includes the following information:</p>
    /// <ul>
    /// <li> <p>The URI location of the configuration data.</p> </li>
    /// <li> <p>The Identity and Access Management (IAM) role that provides access to the configuration data.</p> </li>
    /// <li> <p>A validator for the configuration data. Available validators include either a JSON Schema or an Amazon Web Services Lambda function.</p> </li>
    /// </ul>
    /// <p>For more information, see <a href="http://docs.aws.amazon.com/appconfig/latest/userguide/appconfig-creating-configuration-and-profile.html">Create a Configuration and a Configuration Profile</a> in the <i>AppConfig User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateConfigurationProfile {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_configuration_profile_input::Builder,
    }
    impl CreateConfigurationProfile {
        /// Creates a new `CreateConfigurationProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateConfigurationProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateConfigurationProfileError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The application ID.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The application ID.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>A name for the configuration profile.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A name for the configuration profile.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A description of the configuration profile.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the configuration profile.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>A URI to locate the configuration. You can specify the AppConfig hosted configuration store, Systems Manager (SSM) document, an SSM Parameter Store parameter, or an Amazon S3 object. For the hosted configuration store and for feature flags, specify <code>hosted</code>. For an SSM document, specify either the document name in the format <code>ssm-document://
        /// <document_name></document_name></code> or the Amazon Resource Name (ARN). For a parameter, specify either the parameter name in the format <code>ssm-parameter://
        /// <parameter_name></parameter_name></code> or the ARN. For an Amazon S3 object, specify the URI in the following format: <code>s3://
        /// <bucket>
        /// /
        /// <objectkey>
        /// </objectkey>
        /// </bucket></code>. Here is an example: <code>s3://my-bucket/my-app/us-east-1/my-config.json</code> </p>
        pub fn location_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.location_uri(input.into());
            self
        }
        /// <p>A URI to locate the configuration. You can specify the AppConfig hosted configuration store, Systems Manager (SSM) document, an SSM Parameter Store parameter, or an Amazon S3 object. For the hosted configuration store and for feature flags, specify <code>hosted</code>. For an SSM document, specify either the document name in the format <code>ssm-document://
        /// <document_name></document_name></code> or the Amazon Resource Name (ARN). For a parameter, specify either the parameter name in the format <code>ssm-parameter://
        /// <parameter_name></parameter_name></code> or the ARN. For an Amazon S3 object, specify the URI in the following format: <code>s3://
        /// <bucket>
        /// /
        /// <objectkey>
        /// </objectkey>
        /// </bucket></code>. Here is an example: <code>s3://my-bucket/my-app/us-east-1/my-config.json</code> </p>
        pub fn set_location_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_location_uri(input);
            self
        }
        /// <p>The ARN of an IAM role with permission to access the configuration at the specified <code>LocationUri</code>.</p> <important>
        /// <p>A retrieval role ARN is not required for configurations stored in the AppConfig hosted configuration store. It is required for all other sources that store your configuration. </p>
        /// </important>
        pub fn retrieval_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.retrieval_role_arn(input.into());
            self
        }
        /// <p>The ARN of an IAM role with permission to access the configuration at the specified <code>LocationUri</code>.</p> <important>
        /// <p>A retrieval role ARN is not required for configurations stored in the AppConfig hosted configuration store. It is required for all other sources that store your configuration. </p>
        /// </important>
        pub fn set_retrieval_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_retrieval_role_arn(input);
            self
        }
        /// Appends an item to `Validators`.
        ///
        /// To override the contents of this collection use [`set_validators`](Self::set_validators).
        ///
        /// <p>A list of methods for validating the configuration.</p>
        pub fn validators(mut self, input: crate::model::Validator) -> Self {
            self.inner = self.inner.validators(input);
            self
        }
        /// <p>A list of methods for validating the configuration.</p>
        pub fn set_validators(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Validator>>,
        ) -> Self {
            self.inner = self.inner.set_validators(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata to assign to the configuration profile. Tags help organize and categorize your AppConfig resources. Each tag consists of a key and an optional value, both of which you define.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Metadata to assign to the configuration profile. Tags help organize and categorize your AppConfig resources. Each tag consists of a key and an optional value, both of which you define.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The type of configurations contained in the profile. AppConfig supports <code>feature flags</code> and <code>freeform</code> configurations. We recommend you create feature flag configurations to enable or disable new features and freeform configurations to distribute configurations to an application. When calling this API, enter one of the following values for <code>Type</code>:</p>
        /// <p> <code>AWS.AppConfig.FeatureFlags</code> </p>
        /// <p> <code>AWS.Freeform</code> </p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.r#type(input.into());
            self
        }
        /// <p>The type of configurations contained in the profile. AppConfig supports <code>feature flags</code> and <code>freeform</code> configurations. We recommend you create feature flag configurations to enable or disable new features and freeform configurations to distribute configurations to an application. When calling this API, enter one of the following values for <code>Type</code>:</p>
        /// <p> <code>AWS.AppConfig.FeatureFlags</code> </p>
        /// <p> <code>AWS.Freeform</code> </p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDeploymentStrategy`.
    ///
    /// <p>Creates a deployment strategy that defines important criteria for rolling out your configuration to the designated targets. A deployment strategy includes the overall duration required, a percentage of targets to receive the deployment during each interval, an algorithm that defines how percentage grows, and bake time.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDeploymentStrategy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_deployment_strategy_input::Builder,
    }
    impl CreateDeploymentStrategy {
        /// Creates a new `CreateDeploymentStrategy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDeploymentStrategyOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDeploymentStrategyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A name for the deployment strategy.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A name for the deployment strategy.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A description of the deployment strategy.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the deployment strategy.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Total amount of time for a deployment to last.</p>
        pub fn deployment_duration_in_minutes(mut self, input: i32) -> Self {
            self.inner = self.inner.deployment_duration_in_minutes(input);
            self
        }
        /// <p>Total amount of time for a deployment to last.</p>
        pub fn set_deployment_duration_in_minutes(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_deployment_duration_in_minutes(input);
            self
        }
        /// <p>The amount of time AppConfig monitors for alarms before considering the deployment to be complete and no longer eligible for automatic roll back.</p>
        pub fn final_bake_time_in_minutes(mut self, input: i32) -> Self {
            self.inner = self.inner.final_bake_time_in_minutes(input);
            self
        }
        /// <p>The amount of time AppConfig monitors for alarms before considering the deployment to be complete and no longer eligible for automatic roll back.</p>
        pub fn set_final_bake_time_in_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_final_bake_time_in_minutes(input);
            self
        }
        /// <p>The percentage of targets to receive a deployed configuration during each interval.</p>
        pub fn growth_factor(mut self, input: f32) -> Self {
            self.inner = self.inner.growth_factor(input);
            self
        }
        /// <p>The percentage of targets to receive a deployed configuration during each interval.</p>
        pub fn set_growth_factor(mut self, input: std::option::Option<f32>) -> Self {
            self.inner = self.inner.set_growth_factor(input);
            self
        }
        /// <p>The algorithm used to define how percentage grows over time. AppConfig supports the following growth types:</p>
        /// <p> <b>Linear</b>: For this type, AppConfig processes the deployment by dividing the total number of targets by the value specified for <code>Step percentage</code>. For example, a linear deployment that uses a <code>Step percentage</code> of 10 deploys the configuration to 10 percent of the hosts. After those deployments are complete, the system deploys the configuration to the next 10 percent. This continues until 100% of the targets have successfully received the configuration.</p>
        /// <p> <b>Exponential</b>: For this type, AppConfig processes the deployment exponentially using the following formula: <code>G*(2^N)</code>. In this formula, <code>G</code> is the growth factor specified by the user and <code>N</code> is the number of steps until the configuration is deployed to all targets. For example, if you specify a growth factor of 2, then the system rolls out the configuration as follows:</p>
        /// <p> <code>2*(2^0)</code> </p>
        /// <p> <code>2*(2^1)</code> </p>
        /// <p> <code>2*(2^2)</code> </p>
        /// <p>Expressed numerically, the deployment rolls out as follows: 2% of the targets, 4% of the targets, 8% of the targets, and continues until the configuration has been deployed to all targets.</p>
        pub fn growth_type(mut self, input: crate::model::GrowthType) -> Self {
            self.inner = self.inner.growth_type(input);
            self
        }
        /// <p>The algorithm used to define how percentage grows over time. AppConfig supports the following growth types:</p>
        /// <p> <b>Linear</b>: For this type, AppConfig processes the deployment by dividing the total number of targets by the value specified for <code>Step percentage</code>. For example, a linear deployment that uses a <code>Step percentage</code> of 10 deploys the configuration to 10 percent of the hosts. After those deployments are complete, the system deploys the configuration to the next 10 percent. This continues until 100% of the targets have successfully received the configuration.</p>
        /// <p> <b>Exponential</b>: For this type, AppConfig processes the deployment exponentially using the following formula: <code>G*(2^N)</code>. In this formula, <code>G</code> is the growth factor specified by the user and <code>N</code> is the number of steps until the configuration is deployed to all targets. For example, if you specify a growth factor of 2, then the system rolls out the configuration as follows:</p>
        /// <p> <code>2*(2^0)</code> </p>
        /// <p> <code>2*(2^1)</code> </p>
        /// <p> <code>2*(2^2)</code> </p>
        /// <p>Expressed numerically, the deployment rolls out as follows: 2% of the targets, 4% of the targets, 8% of the targets, and continues until the configuration has been deployed to all targets.</p>
        pub fn set_growth_type(
            mut self,
            input: std::option::Option<crate::model::GrowthType>,
        ) -> Self {
            self.inner = self.inner.set_growth_type(input);
            self
        }
        /// <p>Save the deployment strategy to a Systems Manager (SSM) document.</p>
        pub fn replicate_to(mut self, input: crate::model::ReplicateTo) -> Self {
            self.inner = self.inner.replicate_to(input);
            self
        }
        /// <p>Save the deployment strategy to a Systems Manager (SSM) document.</p>
        pub fn set_replicate_to(
            mut self,
            input: std::option::Option<crate::model::ReplicateTo>,
        ) -> Self {
            self.inner = self.inner.set_replicate_to(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata to assign to the deployment strategy. Tags help organize and categorize your AppConfig resources. Each tag consists of a key and an optional value, both of which you define.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Metadata to assign to the deployment strategy. Tags help organize and categorize your AppConfig resources. Each tag consists of a key and an optional value, both of which you define.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateEnvironment`.
    ///
    /// <p>Creates an environment. For each application, you define one or more environments. An environment is a logical deployment group of AppConfig targets, such as applications in a <code>Beta</code> or <code>Production</code> environment. You can also define environments for application subcomponents such as the <code>Web</code>, <code>Mobile</code> and <code>Back-end</code> components for your application. You can configure Amazon CloudWatch alarms for each environment. The system monitors alarms during a configuration deployment. If an alarm is triggered, the system rolls back the configuration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateEnvironment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_environment_input::Builder,
    }
    impl CreateEnvironment {
        /// Creates a new `CreateEnvironment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateEnvironmentOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateEnvironmentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The application ID.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The application ID.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>A name for the environment.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A name for the environment.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A description of the environment.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the environment.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `Monitors`.
        ///
        /// To override the contents of this collection use [`set_monitors`](Self::set_monitors).
        ///
        /// <p>Amazon CloudWatch alarms to monitor during the deployment process.</p>
        pub fn monitors(mut self, input: crate::model::Monitor) -> Self {
            self.inner = self.inner.monitors(input);
            self
        }
        /// <p>Amazon CloudWatch alarms to monitor during the deployment process.</p>
        pub fn set_monitors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Monitor>>,
        ) -> Self {
            self.inner = self.inner.set_monitors(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata to assign to the environment. Tags help organize and categorize your AppConfig resources. Each tag consists of a key and an optional value, both of which you define.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Metadata to assign to the environment. Tags help organize and categorize your AppConfig resources. Each tag consists of a key and an optional value, both of which you define.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateHostedConfigurationVersion`.
    ///
    /// <p>Creates a new configuration in the AppConfig hosted configuration store.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateHostedConfigurationVersion {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_hosted_configuration_version_input::Builder,
    }
    impl CreateHostedConfigurationVersion {
        /// Creates a new `CreateHostedConfigurationVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateHostedConfigurationVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateHostedConfigurationVersionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The application ID.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The application ID.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The configuration profile ID.</p>
        pub fn configuration_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_profile_id(input.into());
            self
        }
        /// <p>The configuration profile ID.</p>
        pub fn set_configuration_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_profile_id(input);
            self
        }
        /// <p>A description of the configuration.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the configuration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The content of the configuration or the configuration data.</p>
        pub fn content(mut self, input: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.content(input);
            self
        }
        /// <p>The content of the configuration or the configuration data.</p>
        pub fn set_content(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.inner = self.inner.set_content(input);
            self
        }
        /// <p>A standard MIME type describing the format of the configuration content. For more information, see <a href="https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17">Content-Type</a>.</p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content_type(input.into());
            self
        }
        /// <p>A standard MIME type describing the format of the configuration content. For more information, see <a href="https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17">Content-Type</a>.</p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content_type(input);
            self
        }
        /// <p>An optional locking token used to prevent race conditions from overwriting configuration updates when creating a new version. To ensure your data is not overwritten when creating multiple hosted configuration versions in rapid succession, specify the version number of the latest hosted configuration version.</p>
        pub fn latest_version_number(mut self, input: i32) -> Self {
            self.inner = self.inner.latest_version_number(input);
            self
        }
        /// <p>An optional locking token used to prevent race conditions from overwriting configuration updates when creating a new version. To ensure your data is not overwritten when creating multiple hosted configuration versions in rapid succession, specify the version number of the latest hosted configuration version.</p>
        pub fn set_latest_version_number(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_latest_version_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteApplication`.
    ///
    /// <p>Deletes an application. Deleting an application does not delete a configuration from a host.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteApplication {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_application_input::Builder,
    }
    impl DeleteApplication {
        /// Creates a new `DeleteApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteApplicationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the application to delete.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The ID of the application to delete.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteConfigurationProfile`.
    ///
    /// <p>Deletes a configuration profile. Deleting a configuration profile does not delete a configuration from a host.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteConfigurationProfile {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_configuration_profile_input::Builder,
    }
    impl DeleteConfigurationProfile {
        /// Creates a new `DeleteConfigurationProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteConfigurationProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteConfigurationProfileError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The application ID that includes the configuration profile you want to delete.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The application ID that includes the configuration profile you want to delete.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The ID of the configuration profile you want to delete.</p>
        pub fn configuration_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_profile_id(input.into());
            self
        }
        /// <p>The ID of the configuration profile you want to delete.</p>
        pub fn set_configuration_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_profile_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDeploymentStrategy`.
    ///
    /// <p>Deletes a deployment strategy. Deleting a deployment strategy does not delete a configuration from a host.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDeploymentStrategy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_deployment_strategy_input::Builder,
    }
    impl DeleteDeploymentStrategy {
        /// Creates a new `DeleteDeploymentStrategy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDeploymentStrategyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDeploymentStrategyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the deployment strategy you want to delete.</p>
        pub fn deployment_strategy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_strategy_id(input.into());
            self
        }
        /// <p>The ID of the deployment strategy you want to delete.</p>
        pub fn set_deployment_strategy_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_strategy_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEnvironment`.
    ///
    /// <p>Deletes an environment. Deleting an environment does not delete a configuration from a host.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteEnvironment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_environment_input::Builder,
    }
    impl DeleteEnvironment {
        /// Creates a new `DeleteEnvironment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEnvironmentOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEnvironmentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The application ID that includes the environment that you want to delete.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The application ID that includes the environment that you want to delete.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The ID of the environment that you want to delete.</p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_id(input.into());
            self
        }
        /// <p>The ID of the environment that you want to delete.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteHostedConfigurationVersion`.
    ///
    /// <p>Deletes a version of a configuration from the AppConfig hosted configuration store.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteHostedConfigurationVersion {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_hosted_configuration_version_input::Builder,
    }
    impl DeleteHostedConfigurationVersion {
        /// Creates a new `DeleteHostedConfigurationVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteHostedConfigurationVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteHostedConfigurationVersionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The application ID.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The application ID.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The configuration profile ID.</p>
        pub fn configuration_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_profile_id(input.into());
            self
        }
        /// <p>The configuration profile ID.</p>
        pub fn set_configuration_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_profile_id(input);
            self
        }
        /// <p>The versions number to delete.</p>
        pub fn version_number(mut self, input: i32) -> Self {
            self.inner = self.inner.version_number(input);
            self
        }
        /// <p>The versions number to delete.</p>
        pub fn set_version_number(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_version_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetApplication`.
    ///
    /// <p>Retrieves information about an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetApplication {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_application_input::Builder,
    }
    impl GetApplication {
        /// Creates a new `GetApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetApplicationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the application you want to get.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The ID of the application you want to get.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetConfiguration`.
    ///
    /// <p>Retrieves the latest deployed configuration.</p> <important>
    /// <p>Note the following important information.</p>
    /// <ul>
    /// <li> <p>This API action has been deprecated. Calls to receive configuration data should use the <a href="https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_StartConfigurationSession.html">StartConfigurationSession</a> and <a href="https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_GetLatestConfiguration.html">GetLatestConfiguration</a> APIs instead. </p> </li>
    /// <li> <p> <code>GetConfiguration</code> is a priced call. For more information, see <a href="https://aws.amazon.com/systems-manager/pricing/">Pricing</a>.</p> </li>
    /// <li> <p>AppConfig uses the value of the <code>ClientConfigurationVersion</code> parameter to identify the configuration version on your clients. If you don’t send <code>ClientConfigurationVersion</code> with each call to <code>GetConfiguration</code>, your clients receive the current configuration. You are charged each time your clients receive a configuration.</p> <p>To avoid excess charges, we recommend you use the <a href="https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/StartConfigurationSession.html">StartConfigurationSession</a> and <a href="https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/GetLatestConfiguration.html">GetLatestConfiguration</a> APIs, which track the client configuration version on your behalf. If you choose to continue using <code>GetConfiguration</code>, we recommend that you include the <code>ClientConfigurationVersion</code> value with every call to <code>GetConfiguration</code>. The value to use for <code>ClientConfigurationVersion</code> comes from the <code>ConfigurationVersion</code> attribute returned by <code>GetConfiguration</code> when there is new or updated data, and should be saved for subsequent calls to <code>GetConfiguration</code>.</p> </li>
    /// </ul>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_configuration_input::Builder,
    }
    impl GetConfiguration {
        /// Creates a new `GetConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The application to get. Specify either the application name or the application ID.</p>
        pub fn application(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application(input.into());
            self
        }
        /// <p>The application to get. Specify either the application name or the application ID.</p>
        pub fn set_application(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_application(input);
            self
        }
        /// <p>The environment to get. Specify either the environment name or the environment ID.</p>
        pub fn environment(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment(input.into());
            self
        }
        /// <p>The environment to get. Specify either the environment name or the environment ID.</p>
        pub fn set_environment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_environment(input);
            self
        }
        /// <p>The configuration to get. Specify either the configuration name or the configuration ID.</p>
        pub fn configuration(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration(input.into());
            self
        }
        /// <p>The configuration to get. Specify either the configuration name or the configuration ID.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration(input);
            self
        }
        /// <p>The clientId parameter in the following command is a unique, user-specified ID to identify the client for the configuration. This ID enables AppConfig to deploy the configuration in intervals, as defined in the deployment strategy. </p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_id(input.into());
            self
        }
        /// <p>The clientId parameter in the following command is a unique, user-specified ID to identify the client for the configuration. This ID enables AppConfig to deploy the configuration in intervals, as defined in the deployment strategy. </p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_id(input);
            self
        }
        /// <p>The configuration version returned in the most recent <code>GetConfiguration</code> response.</p> <important>
        /// <p>AppConfig uses the value of the <code>ClientConfigurationVersion</code> parameter to identify the configuration version on your clients. If you don’t send <code>ClientConfigurationVersion</code> with each call to <code>GetConfiguration</code>, your clients receive the current configuration. You are charged each time your clients receive a configuration.</p>
        /// <p>To avoid excess charges, we recommend that you include the <code>ClientConfigurationVersion</code> value with every call to <code>GetConfiguration</code>. This value must be saved on your client. Subsequent calls to <code>GetConfiguration</code> must pass this value by using the <code>ClientConfigurationVersion</code> parameter. </p>
        /// </important>
        /// <p>For more information about working with configurations, see <a href="http://docs.aws.amazon.com/appconfig/latest/userguide/appconfig-retrieving-the-configuration.html">Retrieving the Configuration</a> in the <i>AppConfig User Guide</i>.</p>
        pub fn client_configuration_version(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.client_configuration_version(input.into());
            self
        }
        /// <p>The configuration version returned in the most recent <code>GetConfiguration</code> response.</p> <important>
        /// <p>AppConfig uses the value of the <code>ClientConfigurationVersion</code> parameter to identify the configuration version on your clients. If you don’t send <code>ClientConfigurationVersion</code> with each call to <code>GetConfiguration</code>, your clients receive the current configuration. You are charged each time your clients receive a configuration.</p>
        /// <p>To avoid excess charges, we recommend that you include the <code>ClientConfigurationVersion</code> value with every call to <code>GetConfiguration</code>. This value must be saved on your client. Subsequent calls to <code>GetConfiguration</code> must pass this value by using the <code>ClientConfigurationVersion</code> parameter. </p>
        /// </important>
        /// <p>For more information about working with configurations, see <a href="http://docs.aws.amazon.com/appconfig/latest/userguide/appconfig-retrieving-the-configuration.html">Retrieving the Configuration</a> in the <i>AppConfig User Guide</i>.</p>
        pub fn set_client_configuration_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_configuration_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetConfigurationProfile`.
    ///
    /// <p>Retrieves information about a configuration profile.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetConfigurationProfile {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_configuration_profile_input::Builder,
    }
    impl GetConfigurationProfile {
        /// Creates a new `GetConfigurationProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetConfigurationProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::GetConfigurationProfileError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the application that includes the configuration profile you want to get.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The ID of the application that includes the configuration profile you want to get.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The ID of the configuration profile that you want to get.</p>
        pub fn configuration_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_profile_id(input.into());
            self
        }
        /// <p>The ID of the configuration profile that you want to get.</p>
        pub fn set_configuration_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_profile_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDeployment`.
    ///
    /// <p>Retrieves information about a configuration deployment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDeployment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_deployment_input::Builder,
    }
    impl GetDeployment {
        /// Creates a new `GetDeployment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDeploymentOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDeploymentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the application that includes the deployment you want to get. </p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The ID of the application that includes the deployment you want to get. </p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The ID of the environment that includes the deployment you want to get. </p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_id(input.into());
            self
        }
        /// <p>The ID of the environment that includes the deployment you want to get. </p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_id(input);
            self
        }
        /// <p>The sequence number of the deployment.</p>
        pub fn deployment_number(mut self, input: i32) -> Self {
            self.inner = self.inner.deployment_number(input);
            self
        }
        /// <p>The sequence number of the deployment.</p>
        pub fn set_deployment_number(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_deployment_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDeploymentStrategy`.
    ///
    /// <p>Retrieves information about a deployment strategy. A deployment strategy defines important criteria for rolling out your configuration to the designated targets. A deployment strategy includes the overall duration required, a percentage of targets to receive the deployment during each interval, an algorithm that defines how percentage grows, and bake time.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDeploymentStrategy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_deployment_strategy_input::Builder,
    }
    impl GetDeploymentStrategy {
        /// Creates a new `GetDeploymentStrategy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDeploymentStrategyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDeploymentStrategyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the deployment strategy to get.</p>
        pub fn deployment_strategy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_strategy_id(input.into());
            self
        }
        /// <p>The ID of the deployment strategy to get.</p>
        pub fn set_deployment_strategy_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_strategy_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetEnvironment`.
    ///
    /// <p>Retrieves information about an environment. An environment is a logical deployment group of AppConfig applications, such as applications in a <code>Production</code> environment or in an <code>EU_Region</code> environment. Each configuration deployment targets an environment. You can enable one or more Amazon CloudWatch alarms for an environment. If an alarm is triggered during a deployment, AppConfig roles back the configuration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetEnvironment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_environment_input::Builder,
    }
    impl GetEnvironment {
        /// Creates a new `GetEnvironment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEnvironmentOutput,
            aws_smithy_http::result::SdkError<crate::error::GetEnvironmentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the application that includes the environment you want to get.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The ID of the application that includes the environment you want to get.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The ID of the environment that you want to get.</p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_id(input.into());
            self
        }
        /// <p>The ID of the environment that you want to get.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetHostedConfigurationVersion`.
    ///
    /// <p>Retrieves information about a specific configuration version.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetHostedConfigurationVersion {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_hosted_configuration_version_input::Builder,
    }
    impl GetHostedConfigurationVersion {
        /// Creates a new `GetHostedConfigurationVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetHostedConfigurationVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetHostedConfigurationVersionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The application ID.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The application ID.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The configuration profile ID.</p>
        pub fn configuration_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_profile_id(input.into());
            self
        }
        /// <p>The configuration profile ID.</p>
        pub fn set_configuration_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_profile_id(input);
            self
        }
        /// <p>The version.</p>
        pub fn version_number(mut self, input: i32) -> Self {
            self.inner = self.inner.version_number(input);
            self
        }
        /// <p>The version.</p>
        pub fn set_version_number(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_version_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListApplications`.
    ///
    /// <p>Lists all applications in your Amazon Web Services account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListApplications {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_applications_input::Builder,
    }
    impl ListApplications {
        /// Creates a new `ListApplications`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListApplicationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListApplicationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListApplicationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListApplicationsPaginator {
            crate::paginator::ListApplicationsPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to start the list. Next token is a pagination token generated by AppConfig to describe what page the previous List call ended on. For the first List request, the nextToken should not be set. On subsequent calls, the nextToken parameter should be set to the previous responses nextToken value. Use this token to get the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token to start the list. Next token is a pagination token generated by AppConfig to describe what page the previous List call ended on. For the first List request, the nextToken should not be set. On subsequent calls, the nextToken parameter should be set to the previous responses nextToken value. Use this token to get the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListConfigurationProfiles`.
    ///
    /// <p>Lists the configuration profiles for an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListConfigurationProfiles {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_configuration_profiles_input::Builder,
    }
    impl ListConfigurationProfiles {
        /// Creates a new `ListConfigurationProfiles`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListConfigurationProfilesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListConfigurationProfilesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListConfigurationProfilesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListConfigurationProfilesPaginator {
            crate::paginator::ListConfigurationProfilesPaginator::new(self.handle, self.inner)
        }
        /// <p>The application ID.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The application ID.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>A filter based on the type of configurations that the configuration profile contains. A configuration can be a feature flag or a freeform configuration.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.r#type(input.into());
            self
        }
        /// <p>A filter based on the type of configurations that the configuration profile contains. A configuration can be a feature flag or a freeform configuration.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDeployments`.
    ///
    /// <p>Lists the deployments for an environment in descending deployment number order.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDeployments {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_deployments_input::Builder,
    }
    impl ListDeployments {
        /// Creates a new `ListDeployments`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDeploymentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDeploymentsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDeploymentsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDeploymentsPaginator {
            crate::paginator::ListDeploymentsPaginator::new(self.handle, self.inner)
        }
        /// <p>The application ID.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The application ID.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The environment ID.</p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_id(input.into());
            self
        }
        /// <p>The environment ID.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_id(input);
            self
        }
        /// <p>The maximum number of items that may be returned for this call. If there are items that have not yet been returned, the response will include a non-null <code>NextToken</code> that you can provide in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items that may be returned for this call. If there are items that have not yet been returned, the response will include a non-null <code>NextToken</code> that you can provide in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token returned by a prior call to this operation indicating the next set of results to be returned. If not specified, the operation will return the first set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token returned by a prior call to this operation indicating the next set of results to be returned. If not specified, the operation will return the first set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDeploymentStrategies`.
    ///
    /// <p>Lists deployment strategies.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDeploymentStrategies {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_deployment_strategies_input::Builder,
    }
    impl ListDeploymentStrategies {
        /// Creates a new `ListDeploymentStrategies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDeploymentStrategiesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDeploymentStrategiesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDeploymentStrategiesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDeploymentStrategiesPaginator {
            crate::paginator::ListDeploymentStrategiesPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListEnvironments`.
    ///
    /// <p>Lists the environments for an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListEnvironments {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_environments_input::Builder,
    }
    impl ListEnvironments {
        /// Creates a new `ListEnvironments`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListEnvironmentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListEnvironmentsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListEnvironmentsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListEnvironmentsPaginator {
            crate::paginator::ListEnvironmentsPaginator::new(self.handle, self.inner)
        }
        /// <p>The application ID.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The application ID.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListHostedConfigurationVersions`.
    ///
    /// <p>Lists configurations stored in the AppConfig hosted configuration store by version.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListHostedConfigurationVersions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_hosted_configuration_versions_input::Builder,
    }
    impl ListHostedConfigurationVersions {
        /// Creates a new `ListHostedConfigurationVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListHostedConfigurationVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListHostedConfigurationVersionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListHostedConfigurationVersionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListHostedConfigurationVersionsPaginator {
            crate::paginator::ListHostedConfigurationVersionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The application ID.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The application ID.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The configuration profile ID.</p>
        pub fn configuration_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_profile_id(input.into());
            self
        }
        /// <p>The configuration profile ID.</p>
        pub fn set_configuration_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_profile_id(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Retrieves the list of key-value tags assigned to the resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The resource ARN.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The resource ARN.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartDeployment`.
    ///
    /// <p>Starts a deployment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartDeployment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_deployment_input::Builder,
    }
    impl StartDeployment {
        /// Creates a new `StartDeployment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartDeploymentOutput,
            aws_smithy_http::result::SdkError<crate::error::StartDeploymentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The application ID.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The application ID.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The environment ID.</p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_id(input.into());
            self
        }
        /// <p>The environment ID.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_id(input);
            self
        }
        /// <p>The deployment strategy ID.</p>
        pub fn deployment_strategy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_strategy_id(input.into());
            self
        }
        /// <p>The deployment strategy ID.</p>
        pub fn set_deployment_strategy_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_strategy_id(input);
            self
        }
        /// <p>The configuration profile ID.</p>
        pub fn configuration_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_profile_id(input.into());
            self
        }
        /// <p>The configuration profile ID.</p>
        pub fn set_configuration_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_profile_id(input);
            self
        }
        /// <p>The configuration version to deploy.</p>
        pub fn configuration_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_version(input.into());
            self
        }
        /// <p>The configuration version to deploy.</p>
        pub fn set_configuration_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_version(input);
            self
        }
        /// <p>A description of the deployment.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the deployment.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata to assign to the deployment. Tags help organize and categorize your AppConfig resources. Each tag consists of a key and an optional value, both of which you define.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Metadata to assign to the deployment. Tags help organize and categorize your AppConfig resources. Each tag consists of a key and an optional value, both of which you define.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopDeployment`.
    ///
    /// <p>Stops a deployment. This API action works only on deployments that have a status of <code>DEPLOYING</code>. This action moves the deployment to a status of <code>ROLLED_BACK</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StopDeployment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::stop_deployment_input::Builder,
    }
    impl StopDeployment {
        /// Creates a new `StopDeployment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopDeploymentOutput,
            aws_smithy_http::result::SdkError<crate::error::StopDeploymentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The application ID.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The application ID.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The environment ID.</p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_id(input.into());
            self
        }
        /// <p>The environment ID.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_id(input);
            self
        }
        /// <p>The sequence number of the deployment.</p>
        pub fn deployment_number(mut self, input: i32) -> Self {
            self.inner = self.inner.deployment_number(input);
            self
        }
        /// <p>The sequence number of the deployment.</p>
        pub fn set_deployment_number(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_deployment_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Assigns metadata to an AppConfig resource. Tags help organize and categorize your AppConfig resources. Each tag consists of a key and an optional value, both of which you define. You can specify a maximum of 50 tags for a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource for which to retrieve tags.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the resource for which to retrieve tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value string map. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The key-value string map. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Deletes a tag key and value from an AppConfig resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource for which to remove tags.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the resource for which to remove tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys to delete.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The tag keys to delete.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateApplication`.
    ///
    /// <p>Updates an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateApplication {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_application_input::Builder,
    }
    impl UpdateApplication {
        /// Creates a new `UpdateApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateApplicationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The application ID.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The application ID.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The name of the application.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the application.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A description of the application.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the application.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateConfigurationProfile`.
    ///
    /// <p>Updates a configuration profile.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateConfigurationProfile {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_configuration_profile_input::Builder,
    }
    impl UpdateConfigurationProfile {
        /// Creates a new `UpdateConfigurationProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateConfigurationProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateConfigurationProfileError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The application ID.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The application ID.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The ID of the configuration profile.</p>
        pub fn configuration_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_profile_id(input.into());
            self
        }
        /// <p>The ID of the configuration profile.</p>
        pub fn set_configuration_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_profile_id(input);
            self
        }
        /// <p>The name of the configuration profile.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the configuration profile.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A description of the configuration profile.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the configuration profile.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The ARN of an IAM role with permission to access the configuration at the specified <code>LocationUri</code>.</p>
        pub fn retrieval_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.retrieval_role_arn(input.into());
            self
        }
        /// <p>The ARN of an IAM role with permission to access the configuration at the specified <code>LocationUri</code>.</p>
        pub fn set_retrieval_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_retrieval_role_arn(input);
            self
        }
        /// Appends an item to `Validators`.
        ///
        /// To override the contents of this collection use [`set_validators`](Self::set_validators).
        ///
        /// <p>A list of methods for validating the configuration.</p>
        pub fn validators(mut self, input: crate::model::Validator) -> Self {
            self.inner = self.inner.validators(input);
            self
        }
        /// <p>A list of methods for validating the configuration.</p>
        pub fn set_validators(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Validator>>,
        ) -> Self {
            self.inner = self.inner.set_validators(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDeploymentStrategy`.
    ///
    /// <p>Updates a deployment strategy.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateDeploymentStrategy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_deployment_strategy_input::Builder,
    }
    impl UpdateDeploymentStrategy {
        /// Creates a new `UpdateDeploymentStrategy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDeploymentStrategyOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDeploymentStrategyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The deployment strategy ID.</p>
        pub fn deployment_strategy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_strategy_id(input.into());
            self
        }
        /// <p>The deployment strategy ID.</p>
        pub fn set_deployment_strategy_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_strategy_id(input);
            self
        }
        /// <p>A description of the deployment strategy.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the deployment strategy.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Total amount of time for a deployment to last.</p>
        pub fn deployment_duration_in_minutes(mut self, input: i32) -> Self {
            self.inner = self.inner.deployment_duration_in_minutes(input);
            self
        }
        /// <p>Total amount of time for a deployment to last.</p>
        pub fn set_deployment_duration_in_minutes(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_deployment_duration_in_minutes(input);
            self
        }
        /// <p>The amount of time that AppConfig monitors for alarms before considering the deployment to be complete and no longer eligible for automatic rollback.</p>
        pub fn final_bake_time_in_minutes(mut self, input: i32) -> Self {
            self.inner = self.inner.final_bake_time_in_minutes(input);
            self
        }
        /// <p>The amount of time that AppConfig monitors for alarms before considering the deployment to be complete and no longer eligible for automatic rollback.</p>
        pub fn set_final_bake_time_in_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_final_bake_time_in_minutes(input);
            self
        }
        /// <p>The percentage of targets to receive a deployed configuration during each interval.</p>
        pub fn growth_factor(mut self, input: f32) -> Self {
            self.inner = self.inner.growth_factor(input);
            self
        }
        /// <p>The percentage of targets to receive a deployed configuration during each interval.</p>
        pub fn set_growth_factor(mut self, input: std::option::Option<f32>) -> Self {
            self.inner = self.inner.set_growth_factor(input);
            self
        }
        /// <p>The algorithm used to define how percentage grows over time. AppConfig supports the following growth types:</p>
        /// <p> <b>Linear</b>: For this type, AppConfig processes the deployment by increments of the growth factor evenly distributed over the deployment time. For example, a linear deployment that uses a growth factor of 20 initially makes the configuration available to 20 percent of the targets. After 1/5th of the deployment time has passed, the system updates the percentage to 40 percent. This continues until 100% of the targets are set to receive the deployed configuration.</p>
        /// <p> <b>Exponential</b>: For this type, AppConfig processes the deployment exponentially using the following formula: <code>G*(2^N)</code>. In this formula, <code>G</code> is the growth factor specified by the user and <code>N</code> is the number of steps until the configuration is deployed to all targets. For example, if you specify a growth factor of 2, then the system rolls out the configuration as follows:</p>
        /// <p> <code>2*(2^0)</code> </p>
        /// <p> <code>2*(2^1)</code> </p>
        /// <p> <code>2*(2^2)</code> </p>
        /// <p>Expressed numerically, the deployment rolls out as follows: 2% of the targets, 4% of the targets, 8% of the targets, and continues until the configuration has been deployed to all targets.</p>
        pub fn growth_type(mut self, input: crate::model::GrowthType) -> Self {
            self.inner = self.inner.growth_type(input);
            self
        }
        /// <p>The algorithm used to define how percentage grows over time. AppConfig supports the following growth types:</p>
        /// <p> <b>Linear</b>: For this type, AppConfig processes the deployment by increments of the growth factor evenly distributed over the deployment time. For example, a linear deployment that uses a growth factor of 20 initially makes the configuration available to 20 percent of the targets. After 1/5th of the deployment time has passed, the system updates the percentage to 40 percent. This continues until 100% of the targets are set to receive the deployed configuration.</p>
        /// <p> <b>Exponential</b>: For this type, AppConfig processes the deployment exponentially using the following formula: <code>G*(2^N)</code>. In this formula, <code>G</code> is the growth factor specified by the user and <code>N</code> is the number of steps until the configuration is deployed to all targets. For example, if you specify a growth factor of 2, then the system rolls out the configuration as follows:</p>
        /// <p> <code>2*(2^0)</code> </p>
        /// <p> <code>2*(2^1)</code> </p>
        /// <p> <code>2*(2^2)</code> </p>
        /// <p>Expressed numerically, the deployment rolls out as follows: 2% of the targets, 4% of the targets, 8% of the targets, and continues until the configuration has been deployed to all targets.</p>
        pub fn set_growth_type(
            mut self,
            input: std::option::Option<crate::model::GrowthType>,
        ) -> Self {
            self.inner = self.inner.set_growth_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateEnvironment`.
    ///
    /// <p>Updates an environment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateEnvironment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_environment_input::Builder,
    }
    impl UpdateEnvironment {
        /// Creates a new `UpdateEnvironment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateEnvironmentOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateEnvironmentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The application ID.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The application ID.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The environment ID.</p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_id(input.into());
            self
        }
        /// <p>The environment ID.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_id(input);
            self
        }
        /// <p>The name of the environment.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the environment.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A description of the environment.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the environment.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `Monitors`.
        ///
        /// To override the contents of this collection use [`set_monitors`](Self::set_monitors).
        ///
        /// <p>Amazon CloudWatch alarms to monitor during the deployment process.</p>
        pub fn monitors(mut self, input: crate::model::Monitor) -> Self {
            self.inner = self.inner.monitors(input);
            self
        }
        /// <p>Amazon CloudWatch alarms to monitor during the deployment process.</p>
        pub fn set_monitors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Monitor>>,
        ) -> Self {
            self.inner = self.inner.set_monitors(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ValidateConfiguration`.
    ///
    /// <p>Uses the validators in a configuration profile to validate a configuration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ValidateConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::validate_configuration_input::Builder,
    }
    impl ValidateConfiguration {
        /// Creates a new `ValidateConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ValidateConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::ValidateConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The application ID.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The application ID.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The configuration profile ID.</p>
        pub fn configuration_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_profile_id(input.into());
            self
        }
        /// <p>The configuration profile ID.</p>
        pub fn set_configuration_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_profile_id(input);
            self
        }
        /// <p>The version of the configuration to validate.</p>
        pub fn configuration_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_version(input.into());
            self
        }
        /// <p>The version of the configuration to validate.</p>
        pub fn set_configuration_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_version(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
