// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CreateApplicationInput`](crate::input::CreateApplicationInput)
pub mod create_application_input {
    /// A builder for [`CreateApplicationInput`](crate::input::CreateApplicationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>A name for the application.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A name for the application.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A description of the application.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the application.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata to assign to the application. Tags help organize and categorize your AppConfig resources. Each tag consists of a key and an optional value, both of which you define.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Metadata to assign to the application. Tags help organize and categorize your AppConfig resources. Each tag consists of a key and an optional value, both of which you define.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateApplicationInput`](crate::input::CreateApplicationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateApplicationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateApplicationInput {
                name: self.name,
                description: self.description,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateApplicationInputOperationOutputAlias = crate::operation::CreateApplication;
#[doc(hidden)]
pub type CreateApplicationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateApplicationInput {
    /// Consumes the builder and constructs an Operation<[`CreateApplication`](crate::operation::CreateApplication)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateApplication,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateApplicationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/applications").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateApplicationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateApplicationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_application(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateApplication::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateApplication",
            "appconfig",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateApplicationInput`](crate::input::CreateApplicationInput)
    pub fn builder() -> crate::input::create_application_input::Builder {
        crate::input::create_application_input::Builder::default()
    }
}

/// See [`CreateConfigurationProfileInput`](crate::input::CreateConfigurationProfileInput)
pub mod create_configuration_profile_input {
    /// A builder for [`CreateConfigurationProfileInput`](crate::input::CreateConfigurationProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) location_uri: std::option::Option<std::string::String>,
        pub(crate) retrieval_role_arn: std::option::Option<std::string::String>,
        pub(crate) validators: std::option::Option<std::vec::Vec<crate::model::Validator>>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) r#type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The application ID.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The application ID.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>A name for the configuration profile.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A name for the configuration profile.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A description of the configuration profile.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the configuration profile.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>A URI to locate the configuration. You can specify the AppConfig hosted configuration store, Systems Manager (SSM) document, an SSM Parameter Store parameter, or an Amazon S3 object. For the hosted configuration store and for feature flags, specify <code>hosted</code>. For an SSM document, specify either the document name in the format <code>ssm-document://
        /// <document_name></document_name></code> or the Amazon Resource Name (ARN). For a parameter, specify either the parameter name in the format <code>ssm-parameter://
        /// <parameter_name></parameter_name></code> or the ARN. For an Amazon S3 object, specify the URI in the following format: <code>s3://
        /// <bucket>
        /// /
        /// <objectkey>
        /// </objectkey>
        /// </bucket></code>. Here is an example: <code>s3://my-bucket/my-app/us-east-1/my-config.json</code> </p>
        pub fn location_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.location_uri = Some(input.into());
            self
        }
        /// <p>A URI to locate the configuration. You can specify the AppConfig hosted configuration store, Systems Manager (SSM) document, an SSM Parameter Store parameter, or an Amazon S3 object. For the hosted configuration store and for feature flags, specify <code>hosted</code>. For an SSM document, specify either the document name in the format <code>ssm-document://
        /// <document_name></document_name></code> or the Amazon Resource Name (ARN). For a parameter, specify either the parameter name in the format <code>ssm-parameter://
        /// <parameter_name></parameter_name></code> or the ARN. For an Amazon S3 object, specify the URI in the following format: <code>s3://
        /// <bucket>
        /// /
        /// <objectkey>
        /// </objectkey>
        /// </bucket></code>. Here is an example: <code>s3://my-bucket/my-app/us-east-1/my-config.json</code> </p>
        pub fn set_location_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location_uri = input;
            self
        }
        /// <p>The ARN of an IAM role with permission to access the configuration at the specified <code>LocationUri</code>.</p> <important>
        /// <p>A retrieval role ARN is not required for configurations stored in the AppConfig hosted configuration store. It is required for all other sources that store your configuration. </p>
        /// </important>
        pub fn retrieval_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.retrieval_role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of an IAM role with permission to access the configuration at the specified <code>LocationUri</code>.</p> <important>
        /// <p>A retrieval role ARN is not required for configurations stored in the AppConfig hosted configuration store. It is required for all other sources that store your configuration. </p>
        /// </important>
        pub fn set_retrieval_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.retrieval_role_arn = input;
            self
        }
        /// Appends an item to `validators`.
        ///
        /// To override the contents of this collection use [`set_validators`](Self::set_validators).
        ///
        /// <p>A list of methods for validating the configuration.</p>
        pub fn validators(mut self, input: crate::model::Validator) -> Self {
            let mut v = self.validators.unwrap_or_default();
            v.push(input);
            self.validators = Some(v);
            self
        }
        /// <p>A list of methods for validating the configuration.</p>
        pub fn set_validators(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Validator>>,
        ) -> Self {
            self.validators = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata to assign to the configuration profile. Tags help organize and categorize your AppConfig resources. Each tag consists of a key and an optional value, both of which you define.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Metadata to assign to the configuration profile. Tags help organize and categorize your AppConfig resources. Each tag consists of a key and an optional value, both of which you define.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The type of configurations contained in the profile. AppConfig supports <code>feature flags</code> and <code>freeform</code> configurations. We recommend you create feature flag configurations to enable or disable new features and freeform configurations to distribute configurations to an application. When calling this API, enter one of the following values for <code>Type</code>:</p>
        /// <p> <code>AWS.AppConfig.FeatureFlags</code> </p>
        /// <p> <code>AWS.Freeform</code> </p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of configurations contained in the profile. AppConfig supports <code>feature flags</code> and <code>freeform</code> configurations. We recommend you create feature flag configurations to enable or disable new features and freeform configurations to distribute configurations to an application. When calling this API, enter one of the following values for <code>Type</code>:</p>
        /// <p> <code>AWS.AppConfig.FeatureFlags</code> </p>
        /// <p> <code>AWS.Freeform</code> </p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateConfigurationProfileInput`](crate::input::CreateConfigurationProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateConfigurationProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateConfigurationProfileInput {
                application_id: self.application_id,
                name: self.name,
                description: self.description,
                location_uri: self.location_uri,
                retrieval_role_arn: self.retrieval_role_arn,
                validators: self.validators,
                tags: self.tags,
                r#type: self.r#type,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateConfigurationProfileInputOperationOutputAlias =
    crate::operation::CreateConfigurationProfile;
#[doc(hidden)]
pub type CreateConfigurationProfileInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateConfigurationProfileInput {
    /// Consumes the builder and constructs an Operation<[`CreateConfigurationProfile`](crate::operation::CreateConfigurationProfile)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateConfigurationProfile,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateConfigurationProfileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.application_id;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    })?;
            let application_id = aws_smithy_http::label::fmt_string(input_1, false);
            if application_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "application_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/applications/{ApplicationId}/configurationprofiles",
                ApplicationId = application_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateConfigurationProfileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateConfigurationProfileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_configuration_profile(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateConfigurationProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateConfigurationProfile",
            "appconfig",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateConfigurationProfileInput`](crate::input::CreateConfigurationProfileInput)
    pub fn builder() -> crate::input::create_configuration_profile_input::Builder {
        crate::input::create_configuration_profile_input::Builder::default()
    }
}

/// See [`CreateDeploymentStrategyInput`](crate::input::CreateDeploymentStrategyInput)
pub mod create_deployment_strategy_input {
    /// A builder for [`CreateDeploymentStrategyInput`](crate::input::CreateDeploymentStrategyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) deployment_duration_in_minutes: std::option::Option<i32>,
        pub(crate) final_bake_time_in_minutes: std::option::Option<i32>,
        pub(crate) growth_factor: std::option::Option<f32>,
        pub(crate) growth_type: std::option::Option<crate::model::GrowthType>,
        pub(crate) replicate_to: std::option::Option<crate::model::ReplicateTo>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>A name for the deployment strategy.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A name for the deployment strategy.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A description of the deployment strategy.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the deployment strategy.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Total amount of time for a deployment to last.</p>
        pub fn deployment_duration_in_minutes(mut self, input: i32) -> Self {
            self.deployment_duration_in_minutes = Some(input);
            self
        }
        /// <p>Total amount of time for a deployment to last.</p>
        pub fn set_deployment_duration_in_minutes(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.deployment_duration_in_minutes = input;
            self
        }
        /// <p>The amount of time AppConfig monitors for alarms before considering the deployment to be complete and no longer eligible for automatic roll back.</p>
        pub fn final_bake_time_in_minutes(mut self, input: i32) -> Self {
            self.final_bake_time_in_minutes = Some(input);
            self
        }
        /// <p>The amount of time AppConfig monitors for alarms before considering the deployment to be complete and no longer eligible for automatic roll back.</p>
        pub fn set_final_bake_time_in_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.final_bake_time_in_minutes = input;
            self
        }
        /// <p>The percentage of targets to receive a deployed configuration during each interval.</p>
        pub fn growth_factor(mut self, input: f32) -> Self {
            self.growth_factor = Some(input);
            self
        }
        /// <p>The percentage of targets to receive a deployed configuration during each interval.</p>
        pub fn set_growth_factor(mut self, input: std::option::Option<f32>) -> Self {
            self.growth_factor = input;
            self
        }
        /// <p>The algorithm used to define how percentage grows over time. AppConfig supports the following growth types:</p>
        /// <p> <b>Linear</b>: For this type, AppConfig processes the deployment by dividing the total number of targets by the value specified for <code>Step percentage</code>. For example, a linear deployment that uses a <code>Step percentage</code> of 10 deploys the configuration to 10 percent of the hosts. After those deployments are complete, the system deploys the configuration to the next 10 percent. This continues until 100% of the targets have successfully received the configuration.</p>
        /// <p> <b>Exponential</b>: For this type, AppConfig processes the deployment exponentially using the following formula: <code>G*(2^N)</code>. In this formula, <code>G</code> is the growth factor specified by the user and <code>N</code> is the number of steps until the configuration is deployed to all targets. For example, if you specify a growth factor of 2, then the system rolls out the configuration as follows:</p>
        /// <p> <code>2*(2^0)</code> </p>
        /// <p> <code>2*(2^1)</code> </p>
        /// <p> <code>2*(2^2)</code> </p>
        /// <p>Expressed numerically, the deployment rolls out as follows: 2% of the targets, 4% of the targets, 8% of the targets, and continues until the configuration has been deployed to all targets.</p>
        pub fn growth_type(mut self, input: crate::model::GrowthType) -> Self {
            self.growth_type = Some(input);
            self
        }
        /// <p>The algorithm used to define how percentage grows over time. AppConfig supports the following growth types:</p>
        /// <p> <b>Linear</b>: For this type, AppConfig processes the deployment by dividing the total number of targets by the value specified for <code>Step percentage</code>. For example, a linear deployment that uses a <code>Step percentage</code> of 10 deploys the configuration to 10 percent of the hosts. After those deployments are complete, the system deploys the configuration to the next 10 percent. This continues until 100% of the targets have successfully received the configuration.</p>
        /// <p> <b>Exponential</b>: For this type, AppConfig processes the deployment exponentially using the following formula: <code>G*(2^N)</code>. In this formula, <code>G</code> is the growth factor specified by the user and <code>N</code> is the number of steps until the configuration is deployed to all targets. For example, if you specify a growth factor of 2, then the system rolls out the configuration as follows:</p>
        /// <p> <code>2*(2^0)</code> </p>
        /// <p> <code>2*(2^1)</code> </p>
        /// <p> <code>2*(2^2)</code> </p>
        /// <p>Expressed numerically, the deployment rolls out as follows: 2% of the targets, 4% of the targets, 8% of the targets, and continues until the configuration has been deployed to all targets.</p>
        pub fn set_growth_type(
            mut self,
            input: std::option::Option<crate::model::GrowthType>,
        ) -> Self {
            self.growth_type = input;
            self
        }
        /// <p>Save the deployment strategy to a Systems Manager (SSM) document.</p>
        pub fn replicate_to(mut self, input: crate::model::ReplicateTo) -> Self {
            self.replicate_to = Some(input);
            self
        }
        /// <p>Save the deployment strategy to a Systems Manager (SSM) document.</p>
        pub fn set_replicate_to(
            mut self,
            input: std::option::Option<crate::model::ReplicateTo>,
        ) -> Self {
            self.replicate_to = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata to assign to the deployment strategy. Tags help organize and categorize your AppConfig resources. Each tag consists of a key and an optional value, both of which you define.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Metadata to assign to the deployment strategy. Tags help organize and categorize your AppConfig resources. Each tag consists of a key and an optional value, both of which you define.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDeploymentStrategyInput`](crate::input::CreateDeploymentStrategyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDeploymentStrategyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDeploymentStrategyInput {
                name: self.name,
                description: self.description,
                deployment_duration_in_minutes: self.deployment_duration_in_minutes,
                final_bake_time_in_minutes: self.final_bake_time_in_minutes.unwrap_or_default(),
                growth_factor: self.growth_factor,
                growth_type: self.growth_type,
                replicate_to: self.replicate_to,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDeploymentStrategyInputOperationOutputAlias =
    crate::operation::CreateDeploymentStrategy;
#[doc(hidden)]
pub type CreateDeploymentStrategyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateDeploymentStrategyInput {
    /// Consumes the builder and constructs an Operation<[`CreateDeploymentStrategy`](crate::operation::CreateDeploymentStrategy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDeploymentStrategy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateDeploymentStrategyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/deploymentstrategies").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateDeploymentStrategyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateDeploymentStrategyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_deployment_strategy(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDeploymentStrategy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDeploymentStrategy",
            "appconfig",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateDeploymentStrategyInput`](crate::input::CreateDeploymentStrategyInput)
    pub fn builder() -> crate::input::create_deployment_strategy_input::Builder {
        crate::input::create_deployment_strategy_input::Builder::default()
    }
}

/// See [`CreateEnvironmentInput`](crate::input::CreateEnvironmentInput)
pub mod create_environment_input {
    /// A builder for [`CreateEnvironmentInput`](crate::input::CreateEnvironmentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) monitors: std::option::Option<std::vec::Vec<crate::model::Monitor>>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The application ID.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The application ID.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>A name for the environment.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A name for the environment.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A description of the environment.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the environment.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `monitors`.
        ///
        /// To override the contents of this collection use [`set_monitors`](Self::set_monitors).
        ///
        /// <p>Amazon CloudWatch alarms to monitor during the deployment process.</p>
        pub fn monitors(mut self, input: crate::model::Monitor) -> Self {
            let mut v = self.monitors.unwrap_or_default();
            v.push(input);
            self.monitors = Some(v);
            self
        }
        /// <p>Amazon CloudWatch alarms to monitor during the deployment process.</p>
        pub fn set_monitors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Monitor>>,
        ) -> Self {
            self.monitors = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata to assign to the environment. Tags help organize and categorize your AppConfig resources. Each tag consists of a key and an optional value, both of which you define.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Metadata to assign to the environment. Tags help organize and categorize your AppConfig resources. Each tag consists of a key and an optional value, both of which you define.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateEnvironmentInput`](crate::input::CreateEnvironmentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateEnvironmentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateEnvironmentInput {
                application_id: self.application_id,
                name: self.name,
                description: self.description,
                monitors: self.monitors,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateEnvironmentInputOperationOutputAlias = crate::operation::CreateEnvironment;
#[doc(hidden)]
pub type CreateEnvironmentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateEnvironmentInput {
    /// Consumes the builder and constructs an Operation<[`CreateEnvironment`](crate::operation::CreateEnvironment)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateEnvironment,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateEnvironmentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_2 = &_input.application_id;
            let input_2 =
                input_2
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    })?;
            let application_id = aws_smithy_http::label::fmt_string(input_2, false);
            if application_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "application_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/applications/{ApplicationId}/environments",
                ApplicationId = application_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateEnvironmentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateEnvironmentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_environment(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateEnvironment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateEnvironment",
            "appconfig",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateEnvironmentInput`](crate::input::CreateEnvironmentInput)
    pub fn builder() -> crate::input::create_environment_input::Builder {
        crate::input::create_environment_input::Builder::default()
    }
}

/// See [`CreateHostedConfigurationVersionInput`](crate::input::CreateHostedConfigurationVersionInput)
pub mod create_hosted_configuration_version_input {
    /// A builder for [`CreateHostedConfigurationVersionInput`](crate::input::CreateHostedConfigurationVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) configuration_profile_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) content: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) content_type: std::option::Option<std::string::String>,
        pub(crate) latest_version_number: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The application ID.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The application ID.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The configuration profile ID.</p>
        pub fn configuration_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_profile_id = Some(input.into());
            self
        }
        /// <p>The configuration profile ID.</p>
        pub fn set_configuration_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_profile_id = input;
            self
        }
        /// <p>A description of the configuration.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the configuration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The content of the configuration or the configuration data.</p>
        pub fn content(mut self, input: aws_smithy_types::Blob) -> Self {
            self.content = Some(input);
            self
        }
        /// <p>The content of the configuration or the configuration data.</p>
        pub fn set_content(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.content = input;
            self
        }
        /// <p>A standard MIME type describing the format of the configuration content. For more information, see <a href="https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17">Content-Type</a>.</p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_type = Some(input.into());
            self
        }
        /// <p>A standard MIME type describing the format of the configuration content. For more information, see <a href="https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17">Content-Type</a>.</p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_type = input;
            self
        }
        /// <p>An optional locking token used to prevent race conditions from overwriting configuration updates when creating a new version. To ensure your data is not overwritten when creating multiple hosted configuration versions in rapid succession, specify the version number of the latest hosted configuration version.</p>
        pub fn latest_version_number(mut self, input: i32) -> Self {
            self.latest_version_number = Some(input);
            self
        }
        /// <p>An optional locking token used to prevent race conditions from overwriting configuration updates when creating a new version. To ensure your data is not overwritten when creating multiple hosted configuration versions in rapid succession, specify the version number of the latest hosted configuration version.</p>
        pub fn set_latest_version_number(mut self, input: std::option::Option<i32>) -> Self {
            self.latest_version_number = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateHostedConfigurationVersionInput`](crate::input::CreateHostedConfigurationVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateHostedConfigurationVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateHostedConfigurationVersionInput {
                application_id: self.application_id,
                configuration_profile_id: self.configuration_profile_id,
                description: self.description,
                content: self.content,
                content_type: self.content_type,
                latest_version_number: self.latest_version_number,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateHostedConfigurationVersionInputOperationOutputAlias =
    crate::operation::CreateHostedConfigurationVersion;
#[doc(hidden)]
pub type CreateHostedConfigurationVersionInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl CreateHostedConfigurationVersionInput {
    /// Consumes the builder and constructs an Operation<[`CreateHostedConfigurationVersion`](crate::operation::CreateHostedConfigurationVersion)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateHostedConfigurationVersion,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateHostedConfigurationVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_3 = &_input.application_id;
            let input_3 =
                input_3
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    })?;
            let application_id = aws_smithy_http::label::fmt_string(input_3, false);
            if application_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "application_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_4 = &_input.configuration_profile_id;
            let input_4 =
                input_4
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "configuration_profile_id",
                        details: "cannot be empty or unset",
                    })?;
            let configuration_profile_id = aws_smithy_http::label::fmt_string(input_4, false);
            if configuration_profile_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "configuration_profile_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/applications/{ApplicationId}/configurationprofiles/{ConfigurationProfileId}/hostedconfigurationversions", ApplicationId = application_id, ConfigurationProfileId = configuration_profile_id).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateHostedConfigurationVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder =
                crate::http_serde::add_headers_create_hosted_configuration_version(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateHostedConfigurationVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/octet-stream",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_create_hosted_configuration_version_input(
                self.content,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateHostedConfigurationVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateHostedConfigurationVersion",
            "appconfig",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateHostedConfigurationVersionInput`](crate::input::CreateHostedConfigurationVersionInput)
    pub fn builder() -> crate::input::create_hosted_configuration_version_input::Builder {
        crate::input::create_hosted_configuration_version_input::Builder::default()
    }
}

/// See [`DeleteApplicationInput`](crate::input::DeleteApplicationInput)
pub mod delete_application_input {
    /// A builder for [`DeleteApplicationInput`](crate::input::DeleteApplicationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the application to delete.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The ID of the application to delete.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteApplicationInput`](crate::input::DeleteApplicationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteApplicationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteApplicationInput {
                application_id: self.application_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteApplicationInputOperationOutputAlias = crate::operation::DeleteApplication;
#[doc(hidden)]
pub type DeleteApplicationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteApplicationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteApplication`](crate::operation::DeleteApplication)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteApplication,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteApplicationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_5 = &_input.application_id;
            let input_5 =
                input_5
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    })?;
            let application_id = aws_smithy_http::label::fmt_string(input_5, false);
            if application_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "application_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/applications/{ApplicationId}",
                ApplicationId = application_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteApplicationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteApplicationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteApplication::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteApplication",
            "appconfig",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteApplicationInput`](crate::input::DeleteApplicationInput)
    pub fn builder() -> crate::input::delete_application_input::Builder {
        crate::input::delete_application_input::Builder::default()
    }
}

/// See [`DeleteConfigurationProfileInput`](crate::input::DeleteConfigurationProfileInput)
pub mod delete_configuration_profile_input {
    /// A builder for [`DeleteConfigurationProfileInput`](crate::input::DeleteConfigurationProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) configuration_profile_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The application ID that includes the configuration profile you want to delete.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The application ID that includes the configuration profile you want to delete.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The ID of the configuration profile you want to delete.</p>
        pub fn configuration_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_profile_id = Some(input.into());
            self
        }
        /// <p>The ID of the configuration profile you want to delete.</p>
        pub fn set_configuration_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_profile_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteConfigurationProfileInput`](crate::input::DeleteConfigurationProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteConfigurationProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteConfigurationProfileInput {
                application_id: self.application_id,
                configuration_profile_id: self.configuration_profile_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteConfigurationProfileInputOperationOutputAlias =
    crate::operation::DeleteConfigurationProfile;
#[doc(hidden)]
pub type DeleteConfigurationProfileInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteConfigurationProfileInput {
    /// Consumes the builder and constructs an Operation<[`DeleteConfigurationProfile`](crate::operation::DeleteConfigurationProfile)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteConfigurationProfile,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteConfigurationProfileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_6 = &_input.application_id;
            let input_6 =
                input_6
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    })?;
            let application_id = aws_smithy_http::label::fmt_string(input_6, false);
            if application_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "application_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_7 = &_input.configuration_profile_id;
            let input_7 =
                input_7
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "configuration_profile_id",
                        details: "cannot be empty or unset",
                    })?;
            let configuration_profile_id = aws_smithy_http::label::fmt_string(input_7, false);
            if configuration_profile_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "configuration_profile_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/applications/{ApplicationId}/configurationprofiles/{ConfigurationProfileId}",
                ApplicationId = application_id,
                ConfigurationProfileId = configuration_profile_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteConfigurationProfileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteConfigurationProfileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteConfigurationProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteConfigurationProfile",
            "appconfig",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteConfigurationProfileInput`](crate::input::DeleteConfigurationProfileInput)
    pub fn builder() -> crate::input::delete_configuration_profile_input::Builder {
        crate::input::delete_configuration_profile_input::Builder::default()
    }
}

/// See [`DeleteDeploymentStrategyInput`](crate::input::DeleteDeploymentStrategyInput)
pub mod delete_deployment_strategy_input {
    /// A builder for [`DeleteDeploymentStrategyInput`](crate::input::DeleteDeploymentStrategyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deployment_strategy_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the deployment strategy you want to delete.</p>
        pub fn deployment_strategy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_strategy_id = Some(input.into());
            self
        }
        /// <p>The ID of the deployment strategy you want to delete.</p>
        pub fn set_deployment_strategy_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_strategy_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDeploymentStrategyInput`](crate::input::DeleteDeploymentStrategyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDeploymentStrategyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDeploymentStrategyInput {
                deployment_strategy_id: self.deployment_strategy_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDeploymentStrategyInputOperationOutputAlias =
    crate::operation::DeleteDeploymentStrategy;
#[doc(hidden)]
pub type DeleteDeploymentStrategyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteDeploymentStrategyInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDeploymentStrategy`](crate::operation::DeleteDeploymentStrategy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDeploymentStrategy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteDeploymentStrategyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_8 = &_input.deployment_strategy_id;
            let input_8 =
                input_8
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "deployment_strategy_id",
                        details: "cannot be empty or unset",
                    })?;
            let deployment_strategy_id = aws_smithy_http::label::fmt_string(input_8, false);
            if deployment_strategy_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "deployment_strategy_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/deployementstrategies/{DeploymentStrategyId}",
                DeploymentStrategyId = deployment_strategy_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteDeploymentStrategyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteDeploymentStrategyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDeploymentStrategy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDeploymentStrategy",
            "appconfig",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteDeploymentStrategyInput`](crate::input::DeleteDeploymentStrategyInput)
    pub fn builder() -> crate::input::delete_deployment_strategy_input::Builder {
        crate::input::delete_deployment_strategy_input::Builder::default()
    }
}

/// See [`DeleteEnvironmentInput`](crate::input::DeleteEnvironmentInput)
pub mod delete_environment_input {
    /// A builder for [`DeleteEnvironmentInput`](crate::input::DeleteEnvironmentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) environment_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The application ID that includes the environment that you want to delete.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The application ID that includes the environment that you want to delete.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The ID of the environment that you want to delete.</p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_id = Some(input.into());
            self
        }
        /// <p>The ID of the environment that you want to delete.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteEnvironmentInput`](crate::input::DeleteEnvironmentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteEnvironmentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteEnvironmentInput {
                application_id: self.application_id,
                environment_id: self.environment_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteEnvironmentInputOperationOutputAlias = crate::operation::DeleteEnvironment;
#[doc(hidden)]
pub type DeleteEnvironmentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteEnvironmentInput {
    /// Consumes the builder and constructs an Operation<[`DeleteEnvironment`](crate::operation::DeleteEnvironment)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteEnvironment,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteEnvironmentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_9 = &_input.application_id;
            let input_9 =
                input_9
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    })?;
            let application_id = aws_smithy_http::label::fmt_string(input_9, false);
            if application_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "application_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_10 = &_input.environment_id;
            let input_10 =
                input_10
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "environment_id",
                        details: "cannot be empty or unset",
                    })?;
            let environment_id = aws_smithy_http::label::fmt_string(input_10, false);
            if environment_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "environment_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/applications/{ApplicationId}/environments/{EnvironmentId}",
                ApplicationId = application_id,
                EnvironmentId = environment_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteEnvironmentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteEnvironmentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteEnvironment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteEnvironment",
            "appconfig",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteEnvironmentInput`](crate::input::DeleteEnvironmentInput)
    pub fn builder() -> crate::input::delete_environment_input::Builder {
        crate::input::delete_environment_input::Builder::default()
    }
}

/// See [`DeleteHostedConfigurationVersionInput`](crate::input::DeleteHostedConfigurationVersionInput)
pub mod delete_hosted_configuration_version_input {
    /// A builder for [`DeleteHostedConfigurationVersionInput`](crate::input::DeleteHostedConfigurationVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) configuration_profile_id: std::option::Option<std::string::String>,
        pub(crate) version_number: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The application ID.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The application ID.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The configuration profile ID.</p>
        pub fn configuration_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_profile_id = Some(input.into());
            self
        }
        /// <p>The configuration profile ID.</p>
        pub fn set_configuration_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_profile_id = input;
            self
        }
        /// <p>The versions number to delete.</p>
        pub fn version_number(mut self, input: i32) -> Self {
            self.version_number = Some(input);
            self
        }
        /// <p>The versions number to delete.</p>
        pub fn set_version_number(mut self, input: std::option::Option<i32>) -> Self {
            self.version_number = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteHostedConfigurationVersionInput`](crate::input::DeleteHostedConfigurationVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteHostedConfigurationVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteHostedConfigurationVersionInput {
                application_id: self.application_id,
                configuration_profile_id: self.configuration_profile_id,
                version_number: self.version_number.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteHostedConfigurationVersionInputOperationOutputAlias =
    crate::operation::DeleteHostedConfigurationVersion;
#[doc(hidden)]
pub type DeleteHostedConfigurationVersionInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteHostedConfigurationVersionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteHostedConfigurationVersion`](crate::operation::DeleteHostedConfigurationVersion)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteHostedConfigurationVersion,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteHostedConfigurationVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_11 = &_input.application_id;
            let input_11 =
                input_11
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    })?;
            let application_id = aws_smithy_http::label::fmt_string(input_11, false);
            if application_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "application_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_12 = &_input.configuration_profile_id;
            let input_12 =
                input_12
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "configuration_profile_id",
                        details: "cannot be empty or unset",
                    })?;
            let configuration_profile_id = aws_smithy_http::label::fmt_string(input_12, false);
            if configuration_profile_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "configuration_profile_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_13 = &_input.version_number;
            let mut version_number_encoder = aws_smithy_types::primitive::Encoder::from(*input_13);
            let version_number = version_number_encoder.encode();
            if version_number.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "version_number",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/applications/{ApplicationId}/configurationprofiles/{ConfigurationProfileId}/hostedconfigurationversions/{VersionNumber}", ApplicationId = application_id, ConfigurationProfileId = configuration_profile_id, VersionNumber = version_number).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteHostedConfigurationVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteHostedConfigurationVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteHostedConfigurationVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteHostedConfigurationVersion",
            "appconfig",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteHostedConfigurationVersionInput`](crate::input::DeleteHostedConfigurationVersionInput)
    pub fn builder() -> crate::input::delete_hosted_configuration_version_input::Builder {
        crate::input::delete_hosted_configuration_version_input::Builder::default()
    }
}

/// See [`GetApplicationInput`](crate::input::GetApplicationInput)
pub mod get_application_input {
    /// A builder for [`GetApplicationInput`](crate::input::GetApplicationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the application you want to get.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The ID of the application you want to get.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetApplicationInput`](crate::input::GetApplicationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetApplicationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetApplicationInput {
                application_id: self.application_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetApplicationInputOperationOutputAlias = crate::operation::GetApplication;
#[doc(hidden)]
pub type GetApplicationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetApplicationInput {
    /// Consumes the builder and constructs an Operation<[`GetApplication`](crate::operation::GetApplication)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetApplication,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetApplicationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_14 = &_input.application_id;
            let input_14 =
                input_14
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    })?;
            let application_id = aws_smithy_http::label::fmt_string(input_14, false);
            if application_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "application_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/applications/{ApplicationId}",
                ApplicationId = application_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetApplicationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetApplicationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetApplication::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetApplication",
            "appconfig",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetApplicationInput`](crate::input::GetApplicationInput)
    pub fn builder() -> crate::input::get_application_input::Builder {
        crate::input::get_application_input::Builder::default()
    }
}

/// See [`GetConfigurationInput`](crate::input::GetConfigurationInput)
pub mod get_configuration_input {
    /// A builder for [`GetConfigurationInput`](crate::input::GetConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application: std::option::Option<std::string::String>,
        pub(crate) environment: std::option::Option<std::string::String>,
        pub(crate) configuration: std::option::Option<std::string::String>,
        pub(crate) client_id: std::option::Option<std::string::String>,
        pub(crate) client_configuration_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The application to get. Specify either the application name or the application ID.</p>
        pub fn application(mut self, input: impl Into<std::string::String>) -> Self {
            self.application = Some(input.into());
            self
        }
        /// <p>The application to get. Specify either the application name or the application ID.</p>
        pub fn set_application(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.application = input;
            self
        }
        /// <p>The environment to get. Specify either the environment name or the environment ID.</p>
        pub fn environment(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment = Some(input.into());
            self
        }
        /// <p>The environment to get. Specify either the environment name or the environment ID.</p>
        pub fn set_environment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.environment = input;
            self
        }
        /// <p>The configuration to get. Specify either the configuration name or the configuration ID.</p>
        pub fn configuration(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration = Some(input.into());
            self
        }
        /// <p>The configuration to get. Specify either the configuration name or the configuration ID.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration = input;
            self
        }
        /// <p>The clientId parameter in the following command is a unique, user-specified ID to identify the client for the configuration. This ID enables AppConfig to deploy the configuration in intervals, as defined in the deployment strategy. </p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_id = Some(input.into());
            self
        }
        /// <p>The clientId parameter in the following command is a unique, user-specified ID to identify the client for the configuration. This ID enables AppConfig to deploy the configuration in intervals, as defined in the deployment strategy. </p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_id = input;
            self
        }
        /// <p>The configuration version returned in the most recent <code>GetConfiguration</code> response.</p> <important>
        /// <p>AppConfig uses the value of the <code>ClientConfigurationVersion</code> parameter to identify the configuration version on your clients. If you don’t send <code>ClientConfigurationVersion</code> with each call to <code>GetConfiguration</code>, your clients receive the current configuration. You are charged each time your clients receive a configuration.</p>
        /// <p>To avoid excess charges, we recommend that you include the <code>ClientConfigurationVersion</code> value with every call to <code>GetConfiguration</code>. This value must be saved on your client. Subsequent calls to <code>GetConfiguration</code> must pass this value by using the <code>ClientConfigurationVersion</code> parameter. </p>
        /// </important>
        /// <p>For more information about working with configurations, see <a href="http://docs.aws.amazon.com/appconfig/latest/userguide/appconfig-retrieving-the-configuration.html">Retrieving the Configuration</a> in the <i>AppConfig User Guide</i>.</p>
        pub fn client_configuration_version(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.client_configuration_version = Some(input.into());
            self
        }
        /// <p>The configuration version returned in the most recent <code>GetConfiguration</code> response.</p> <important>
        /// <p>AppConfig uses the value of the <code>ClientConfigurationVersion</code> parameter to identify the configuration version on your clients. If you don’t send <code>ClientConfigurationVersion</code> with each call to <code>GetConfiguration</code>, your clients receive the current configuration. You are charged each time your clients receive a configuration.</p>
        /// <p>To avoid excess charges, we recommend that you include the <code>ClientConfigurationVersion</code> value with every call to <code>GetConfiguration</code>. This value must be saved on your client. Subsequent calls to <code>GetConfiguration</code> must pass this value by using the <code>ClientConfigurationVersion</code> parameter. </p>
        /// </important>
        /// <p>For more information about working with configurations, see <a href="http://docs.aws.amazon.com/appconfig/latest/userguide/appconfig-retrieving-the-configuration.html">Retrieving the Configuration</a> in the <i>AppConfig User Guide</i>.</p>
        pub fn set_client_configuration_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_configuration_version = input;
            self
        }
        /// Consumes the builder and constructs a [`GetConfigurationInput`](crate::input::GetConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetConfigurationInput {
                application: self.application,
                environment: self.environment,
                configuration: self.configuration,
                client_id: self.client_id,
                client_configuration_version: self.client_configuration_version,
            })
        }
    }
}
#[doc(hidden)]
pub type GetConfigurationInputOperationOutputAlias = crate::operation::GetConfiguration;
#[doc(hidden)]
pub type GetConfigurationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`GetConfiguration`](crate::operation::GetConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_15 = &_input.application;
            let input_15 =
                input_15
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application",
                        details: "cannot be empty or unset",
                    })?;
            let application = aws_smithy_http::label::fmt_string(input_15, false);
            if application.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "application",
                    details: "cannot be empty or unset",
                });
            }
            let input_16 = &_input.environment;
            let input_16 =
                input_16
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "environment",
                        details: "cannot be empty or unset",
                    })?;
            let environment = aws_smithy_http::label::fmt_string(input_16, false);
            if environment.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "environment",
                    details: "cannot be empty or unset",
                });
            }
            let input_17 = &_input.configuration;
            let input_17 =
                input_17
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "configuration",
                        details: "cannot be empty or unset",
                    })?;
            let configuration = aws_smithy_http::label::fmt_string(input_17, false);
            if configuration.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "configuration",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/applications/{Application}/environments/{Environment}/configurations/{Configuration}", Application = application, Environment = environment, Configuration = configuration).expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::GetConfigurationInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_18) = &_input.client_id {
                query.push_kv("client_id", &aws_smithy_http::query::fmt_string(&inner_18));
            }
            if let Some(inner_19) = &_input.client_configuration_version {
                query.push_kv(
                    "client_configuration_version",
                    &aws_smithy_http::query::fmt_string(&inner_19),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetConfiguration",
            "appconfig",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetConfigurationInput`](crate::input::GetConfigurationInput)
    pub fn builder() -> crate::input::get_configuration_input::Builder {
        crate::input::get_configuration_input::Builder::default()
    }
}

/// See [`GetConfigurationProfileInput`](crate::input::GetConfigurationProfileInput)
pub mod get_configuration_profile_input {
    /// A builder for [`GetConfigurationProfileInput`](crate::input::GetConfigurationProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) configuration_profile_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the application that includes the configuration profile you want to get.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The ID of the application that includes the configuration profile you want to get.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The ID of the configuration profile that you want to get.</p>
        pub fn configuration_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_profile_id = Some(input.into());
            self
        }
        /// <p>The ID of the configuration profile that you want to get.</p>
        pub fn set_configuration_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_profile_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetConfigurationProfileInput`](crate::input::GetConfigurationProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetConfigurationProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetConfigurationProfileInput {
                application_id: self.application_id,
                configuration_profile_id: self.configuration_profile_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetConfigurationProfileInputOperationOutputAlias =
    crate::operation::GetConfigurationProfile;
#[doc(hidden)]
pub type GetConfigurationProfileInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetConfigurationProfileInput {
    /// Consumes the builder and constructs an Operation<[`GetConfigurationProfile`](crate::operation::GetConfigurationProfile)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetConfigurationProfile,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetConfigurationProfileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_20 = &_input.application_id;
            let input_20 =
                input_20
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    })?;
            let application_id = aws_smithy_http::label::fmt_string(input_20, false);
            if application_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "application_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_21 = &_input.configuration_profile_id;
            let input_21 =
                input_21
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "configuration_profile_id",
                        details: "cannot be empty or unset",
                    })?;
            let configuration_profile_id = aws_smithy_http::label::fmt_string(input_21, false);
            if configuration_profile_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "configuration_profile_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/applications/{ApplicationId}/configurationprofiles/{ConfigurationProfileId}",
                ApplicationId = application_id,
                ConfigurationProfileId = configuration_profile_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetConfigurationProfileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetConfigurationProfileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetConfigurationProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetConfigurationProfile",
            "appconfig",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetConfigurationProfileInput`](crate::input::GetConfigurationProfileInput)
    pub fn builder() -> crate::input::get_configuration_profile_input::Builder {
        crate::input::get_configuration_profile_input::Builder::default()
    }
}

/// See [`GetDeploymentInput`](crate::input::GetDeploymentInput)
pub mod get_deployment_input {
    /// A builder for [`GetDeploymentInput`](crate::input::GetDeploymentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) environment_id: std::option::Option<std::string::String>,
        pub(crate) deployment_number: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of the application that includes the deployment you want to get. </p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The ID of the application that includes the deployment you want to get. </p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The ID of the environment that includes the deployment you want to get. </p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_id = Some(input.into());
            self
        }
        /// <p>The ID of the environment that includes the deployment you want to get. </p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_id = input;
            self
        }
        /// <p>The sequence number of the deployment.</p>
        pub fn deployment_number(mut self, input: i32) -> Self {
            self.deployment_number = Some(input);
            self
        }
        /// <p>The sequence number of the deployment.</p>
        pub fn set_deployment_number(mut self, input: std::option::Option<i32>) -> Self {
            self.deployment_number = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDeploymentInput`](crate::input::GetDeploymentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDeploymentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDeploymentInput {
                application_id: self.application_id,
                environment_id: self.environment_id,
                deployment_number: self.deployment_number,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDeploymentInputOperationOutputAlias = crate::operation::GetDeployment;
#[doc(hidden)]
pub type GetDeploymentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetDeploymentInput {
    /// Consumes the builder and constructs an Operation<[`GetDeployment`](crate::operation::GetDeployment)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDeployment,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDeploymentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_22 = &_input.application_id;
            let input_22 =
                input_22
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    })?;
            let application_id = aws_smithy_http::label::fmt_string(input_22, false);
            if application_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "application_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_23 = &_input.environment_id;
            let input_23 =
                input_23
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "environment_id",
                        details: "cannot be empty or unset",
                    })?;
            let environment_id = aws_smithy_http::label::fmt_string(input_23, false);
            if environment_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "environment_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_24 = &_input.deployment_number;
            let input_24 =
                input_24
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "deployment_number",
                        details: "cannot be empty or unset",
                    })?;
            let mut deployment_number_encoder =
                aws_smithy_types::primitive::Encoder::from(*input_24);
            let deployment_number = deployment_number_encoder.encode();
            if deployment_number.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "deployment_number",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/applications/{ApplicationId}/environments/{EnvironmentId}/deployments/{DeploymentNumber}", ApplicationId = application_id, EnvironmentId = environment_id, DeploymentNumber = deployment_number).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDeploymentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDeploymentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDeployment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDeployment",
            "appconfig",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDeploymentInput`](crate::input::GetDeploymentInput)
    pub fn builder() -> crate::input::get_deployment_input::Builder {
        crate::input::get_deployment_input::Builder::default()
    }
}

/// See [`GetDeploymentStrategyInput`](crate::input::GetDeploymentStrategyInput)
pub mod get_deployment_strategy_input {
    /// A builder for [`GetDeploymentStrategyInput`](crate::input::GetDeploymentStrategyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deployment_strategy_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the deployment strategy to get.</p>
        pub fn deployment_strategy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_strategy_id = Some(input.into());
            self
        }
        /// <p>The ID of the deployment strategy to get.</p>
        pub fn set_deployment_strategy_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_strategy_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDeploymentStrategyInput`](crate::input::GetDeploymentStrategyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDeploymentStrategyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDeploymentStrategyInput {
                deployment_strategy_id: self.deployment_strategy_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDeploymentStrategyInputOperationOutputAlias = crate::operation::GetDeploymentStrategy;
#[doc(hidden)]
pub type GetDeploymentStrategyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetDeploymentStrategyInput {
    /// Consumes the builder and constructs an Operation<[`GetDeploymentStrategy`](crate::operation::GetDeploymentStrategy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDeploymentStrategy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDeploymentStrategyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_25 = &_input.deployment_strategy_id;
            let input_25 =
                input_25
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "deployment_strategy_id",
                        details: "cannot be empty or unset",
                    })?;
            let deployment_strategy_id = aws_smithy_http::label::fmt_string(input_25, false);
            if deployment_strategy_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "deployment_strategy_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/deploymentstrategies/{DeploymentStrategyId}",
                DeploymentStrategyId = deployment_strategy_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDeploymentStrategyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDeploymentStrategyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDeploymentStrategy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDeploymentStrategy",
            "appconfig",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDeploymentStrategyInput`](crate::input::GetDeploymentStrategyInput)
    pub fn builder() -> crate::input::get_deployment_strategy_input::Builder {
        crate::input::get_deployment_strategy_input::Builder::default()
    }
}

/// See [`GetEnvironmentInput`](crate::input::GetEnvironmentInput)
pub mod get_environment_input {
    /// A builder for [`GetEnvironmentInput`](crate::input::GetEnvironmentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) environment_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the application that includes the environment you want to get.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The ID of the application that includes the environment you want to get.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The ID of the environment that you want to get.</p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_id = Some(input.into());
            self
        }
        /// <p>The ID of the environment that you want to get.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEnvironmentInput`](crate::input::GetEnvironmentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetEnvironmentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetEnvironmentInput {
                application_id: self.application_id,
                environment_id: self.environment_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetEnvironmentInputOperationOutputAlias = crate::operation::GetEnvironment;
#[doc(hidden)]
pub type GetEnvironmentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetEnvironmentInput {
    /// Consumes the builder and constructs an Operation<[`GetEnvironment`](crate::operation::GetEnvironment)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetEnvironment,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetEnvironmentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_26 = &_input.application_id;
            let input_26 =
                input_26
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    })?;
            let application_id = aws_smithy_http::label::fmt_string(input_26, false);
            if application_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "application_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_27 = &_input.environment_id;
            let input_27 =
                input_27
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "environment_id",
                        details: "cannot be empty or unset",
                    })?;
            let environment_id = aws_smithy_http::label::fmt_string(input_27, false);
            if environment_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "environment_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/applications/{ApplicationId}/environments/{EnvironmentId}",
                ApplicationId = application_id,
                EnvironmentId = environment_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetEnvironmentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetEnvironmentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetEnvironment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetEnvironment",
            "appconfig",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetEnvironmentInput`](crate::input::GetEnvironmentInput)
    pub fn builder() -> crate::input::get_environment_input::Builder {
        crate::input::get_environment_input::Builder::default()
    }
}

/// See [`GetHostedConfigurationVersionInput`](crate::input::GetHostedConfigurationVersionInput)
pub mod get_hosted_configuration_version_input {
    /// A builder for [`GetHostedConfigurationVersionInput`](crate::input::GetHostedConfigurationVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) configuration_profile_id: std::option::Option<std::string::String>,
        pub(crate) version_number: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The application ID.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The application ID.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The configuration profile ID.</p>
        pub fn configuration_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_profile_id = Some(input.into());
            self
        }
        /// <p>The configuration profile ID.</p>
        pub fn set_configuration_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_profile_id = input;
            self
        }
        /// <p>The version.</p>
        pub fn version_number(mut self, input: i32) -> Self {
            self.version_number = Some(input);
            self
        }
        /// <p>The version.</p>
        pub fn set_version_number(mut self, input: std::option::Option<i32>) -> Self {
            self.version_number = input;
            self
        }
        /// Consumes the builder and constructs a [`GetHostedConfigurationVersionInput`](crate::input::GetHostedConfigurationVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetHostedConfigurationVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetHostedConfigurationVersionInput {
                application_id: self.application_id,
                configuration_profile_id: self.configuration_profile_id,
                version_number: self.version_number.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type GetHostedConfigurationVersionInputOperationOutputAlias =
    crate::operation::GetHostedConfigurationVersion;
#[doc(hidden)]
pub type GetHostedConfigurationVersionInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetHostedConfigurationVersionInput {
    /// Consumes the builder and constructs an Operation<[`GetHostedConfigurationVersion`](crate::operation::GetHostedConfigurationVersion)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetHostedConfigurationVersion,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetHostedConfigurationVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_28 = &_input.application_id;
            let input_28 =
                input_28
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    })?;
            let application_id = aws_smithy_http::label::fmt_string(input_28, false);
            if application_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "application_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_29 = &_input.configuration_profile_id;
            let input_29 =
                input_29
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "configuration_profile_id",
                        details: "cannot be empty or unset",
                    })?;
            let configuration_profile_id = aws_smithy_http::label::fmt_string(input_29, false);
            if configuration_profile_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "configuration_profile_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_30 = &_input.version_number;
            let mut version_number_encoder = aws_smithy_types::primitive::Encoder::from(*input_30);
            let version_number = version_number_encoder.encode();
            if version_number.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "version_number",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/applications/{ApplicationId}/configurationprofiles/{ConfigurationProfileId}/hostedconfigurationversions/{VersionNumber}", ApplicationId = application_id, ConfigurationProfileId = configuration_profile_id, VersionNumber = version_number).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetHostedConfigurationVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetHostedConfigurationVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetHostedConfigurationVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetHostedConfigurationVersion",
            "appconfig",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetHostedConfigurationVersionInput`](crate::input::GetHostedConfigurationVersionInput)
    pub fn builder() -> crate::input::get_hosted_configuration_version_input::Builder {
        crate::input::get_hosted_configuration_version_input::Builder::default()
    }
}

/// See [`ListApplicationsInput`](crate::input::ListApplicationsInput)
pub mod list_applications_input {
    /// A builder for [`ListApplicationsInput`](crate::input::ListApplicationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>A token to start the list. Next token is a pagination token generated by AppConfig to describe what page the previous List call ended on. For the first List request, the nextToken should not be set. On subsequent calls, the nextToken parameter should be set to the previous responses nextToken value. Use this token to get the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to start the list. Next token is a pagination token generated by AppConfig to describe what page the previous List call ended on. For the first List request, the nextToken should not be set. On subsequent calls, the nextToken parameter should be set to the previous responses nextToken value. Use this token to get the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListApplicationsInput`](crate::input::ListApplicationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListApplicationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListApplicationsInput {
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListApplicationsInputOperationOutputAlias = crate::operation::ListApplications;
#[doc(hidden)]
pub type ListApplicationsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListApplicationsInput {
    /// Consumes the builder and constructs an Operation<[`ListApplications`](crate::operation::ListApplications)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListApplications,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListApplicationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/applications").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListApplicationsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_31) = &_input.max_results {
                query.push_kv(
                    "max_results",
                    aws_smithy_types::primitive::Encoder::from(*inner_31).encode(),
                );
            }
            if let Some(inner_32) = &_input.next_token {
                query.push_kv("next_token", &aws_smithy_http::query::fmt_string(&inner_32));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListApplicationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListApplicationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListApplications::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListApplications",
            "appconfig",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListApplicationsInput`](crate::input::ListApplicationsInput)
    pub fn builder() -> crate::input::list_applications_input::Builder {
        crate::input::list_applications_input::Builder::default()
    }
}

/// See [`ListConfigurationProfilesInput`](crate::input::ListConfigurationProfilesInput)
pub mod list_configuration_profiles_input {
    /// A builder for [`ListConfigurationProfilesInput`](crate::input::ListConfigurationProfilesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The application ID.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The application ID.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>A filter based on the type of configurations that the configuration profile contains. A configuration can be a feature flag or a freeform configuration.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>A filter based on the type of configurations that the configuration profile contains. A configuration can be a feature flag or a freeform configuration.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`ListConfigurationProfilesInput`](crate::input::ListConfigurationProfilesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListConfigurationProfilesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListConfigurationProfilesInput {
                application_id: self.application_id,
                max_results: self.max_results,
                next_token: self.next_token,
                r#type: self.r#type,
            })
        }
    }
}
#[doc(hidden)]
pub type ListConfigurationProfilesInputOperationOutputAlias =
    crate::operation::ListConfigurationProfiles;
#[doc(hidden)]
pub type ListConfigurationProfilesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListConfigurationProfilesInput {
    /// Consumes the builder and constructs an Operation<[`ListConfigurationProfiles`](crate::operation::ListConfigurationProfiles)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListConfigurationProfiles,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListConfigurationProfilesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_33 = &_input.application_id;
            let input_33 =
                input_33
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    })?;
            let application_id = aws_smithy_http::label::fmt_string(input_33, false);
            if application_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "application_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/applications/{ApplicationId}/configurationprofiles",
                ApplicationId = application_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListConfigurationProfilesInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_34) = &_input.max_results {
                query.push_kv(
                    "max_results",
                    aws_smithy_types::primitive::Encoder::from(*inner_34).encode(),
                );
            }
            if let Some(inner_35) = &_input.next_token {
                query.push_kv("next_token", &aws_smithy_http::query::fmt_string(&inner_35));
            }
            if let Some(inner_36) = &_input.r#type {
                query.push_kv("type", &aws_smithy_http::query::fmt_string(&inner_36));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListConfigurationProfilesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListConfigurationProfilesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListConfigurationProfiles::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListConfigurationProfiles",
            "appconfig",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListConfigurationProfilesInput`](crate::input::ListConfigurationProfilesInput)
    pub fn builder() -> crate::input::list_configuration_profiles_input::Builder {
        crate::input::list_configuration_profiles_input::Builder::default()
    }
}

/// See [`ListDeploymentsInput`](crate::input::ListDeploymentsInput)
pub mod list_deployments_input {
    /// A builder for [`ListDeploymentsInput`](crate::input::ListDeploymentsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) environment_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The application ID.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The application ID.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The environment ID.</p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_id = Some(input.into());
            self
        }
        /// <p>The environment ID.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_id = input;
            self
        }
        /// <p>The maximum number of items that may be returned for this call. If there are items that have not yet been returned, the response will include a non-null <code>NextToken</code> that you can provide in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items that may be returned for this call. If there are items that have not yet been returned, the response will include a non-null <code>NextToken</code> that you can provide in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token returned by a prior call to this operation indicating the next set of results to be returned. If not specified, the operation will return the first set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token returned by a prior call to this operation indicating the next set of results to be returned. If not specified, the operation will return the first set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDeploymentsInput`](crate::input::ListDeploymentsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDeploymentsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDeploymentsInput {
                application_id: self.application_id,
                environment_id: self.environment_id,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDeploymentsInputOperationOutputAlias = crate::operation::ListDeployments;
#[doc(hidden)]
pub type ListDeploymentsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListDeploymentsInput {
    /// Consumes the builder and constructs an Operation<[`ListDeployments`](crate::operation::ListDeployments)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDeployments,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDeploymentsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_37 = &_input.application_id;
            let input_37 =
                input_37
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    })?;
            let application_id = aws_smithy_http::label::fmt_string(input_37, false);
            if application_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "application_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_38 = &_input.environment_id;
            let input_38 =
                input_38
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "environment_id",
                        details: "cannot be empty or unset",
                    })?;
            let environment_id = aws_smithy_http::label::fmt_string(input_38, false);
            if environment_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "environment_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/applications/{ApplicationId}/environments/{EnvironmentId}/deployments",
                ApplicationId = application_id,
                EnvironmentId = environment_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListDeploymentsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_39) = &_input.max_results {
                query.push_kv(
                    "max_results",
                    aws_smithy_types::primitive::Encoder::from(*inner_39).encode(),
                );
            }
            if let Some(inner_40) = &_input.next_token {
                query.push_kv("next_token", &aws_smithy_http::query::fmt_string(&inner_40));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDeploymentsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDeploymentsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDeployments::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDeployments",
            "appconfig",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDeploymentsInput`](crate::input::ListDeploymentsInput)
    pub fn builder() -> crate::input::list_deployments_input::Builder {
        crate::input::list_deployments_input::Builder::default()
    }
}

/// See [`ListDeploymentStrategiesInput`](crate::input::ListDeploymentStrategiesInput)
pub mod list_deployment_strategies_input {
    /// A builder for [`ListDeploymentStrategiesInput`](crate::input::ListDeploymentStrategiesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDeploymentStrategiesInput`](crate::input::ListDeploymentStrategiesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDeploymentStrategiesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDeploymentStrategiesInput {
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDeploymentStrategiesInputOperationOutputAlias =
    crate::operation::ListDeploymentStrategies;
#[doc(hidden)]
pub type ListDeploymentStrategiesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListDeploymentStrategiesInput {
    /// Consumes the builder and constructs an Operation<[`ListDeploymentStrategies`](crate::operation::ListDeploymentStrategies)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDeploymentStrategies,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDeploymentStrategiesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/deploymentstrategies").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListDeploymentStrategiesInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_41) = &_input.max_results {
                query.push_kv(
                    "max_results",
                    aws_smithy_types::primitive::Encoder::from(*inner_41).encode(),
                );
            }
            if let Some(inner_42) = &_input.next_token {
                query.push_kv("next_token", &aws_smithy_http::query::fmt_string(&inner_42));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDeploymentStrategiesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDeploymentStrategiesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDeploymentStrategies::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDeploymentStrategies",
            "appconfig",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDeploymentStrategiesInput`](crate::input::ListDeploymentStrategiesInput)
    pub fn builder() -> crate::input::list_deployment_strategies_input::Builder {
        crate::input::list_deployment_strategies_input::Builder::default()
    }
}

/// See [`ListEnvironmentsInput`](crate::input::ListEnvironmentsInput)
pub mod list_environments_input {
    /// A builder for [`ListEnvironmentsInput`](crate::input::ListEnvironmentsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The application ID.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The application ID.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListEnvironmentsInput`](crate::input::ListEnvironmentsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListEnvironmentsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListEnvironmentsInput {
                application_id: self.application_id,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListEnvironmentsInputOperationOutputAlias = crate::operation::ListEnvironments;
#[doc(hidden)]
pub type ListEnvironmentsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListEnvironmentsInput {
    /// Consumes the builder and constructs an Operation<[`ListEnvironments`](crate::operation::ListEnvironments)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListEnvironments,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListEnvironmentsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_43 = &_input.application_id;
            let input_43 =
                input_43
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    })?;
            let application_id = aws_smithy_http::label::fmt_string(input_43, false);
            if application_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "application_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/applications/{ApplicationId}/environments",
                ApplicationId = application_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListEnvironmentsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_44) = &_input.max_results {
                query.push_kv(
                    "max_results",
                    aws_smithy_types::primitive::Encoder::from(*inner_44).encode(),
                );
            }
            if let Some(inner_45) = &_input.next_token {
                query.push_kv("next_token", &aws_smithy_http::query::fmt_string(&inner_45));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListEnvironmentsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListEnvironmentsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListEnvironments::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListEnvironments",
            "appconfig",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListEnvironmentsInput`](crate::input::ListEnvironmentsInput)
    pub fn builder() -> crate::input::list_environments_input::Builder {
        crate::input::list_environments_input::Builder::default()
    }
}

/// See [`ListHostedConfigurationVersionsInput`](crate::input::ListHostedConfigurationVersionsInput)
pub mod list_hosted_configuration_versions_input {
    /// A builder for [`ListHostedConfigurationVersionsInput`](crate::input::ListHostedConfigurationVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) configuration_profile_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The application ID.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The application ID.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The configuration profile ID.</p>
        pub fn configuration_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_profile_id = Some(input.into());
            self
        }
        /// <p>The configuration profile ID.</p>
        pub fn set_configuration_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_profile_id = input;
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListHostedConfigurationVersionsInput`](crate::input::ListHostedConfigurationVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListHostedConfigurationVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListHostedConfigurationVersionsInput {
                application_id: self.application_id,
                configuration_profile_id: self.configuration_profile_id,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListHostedConfigurationVersionsInputOperationOutputAlias =
    crate::operation::ListHostedConfigurationVersions;
#[doc(hidden)]
pub type ListHostedConfigurationVersionsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListHostedConfigurationVersionsInput {
    /// Consumes the builder and constructs an Operation<[`ListHostedConfigurationVersions`](crate::operation::ListHostedConfigurationVersions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListHostedConfigurationVersions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListHostedConfigurationVersionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_46 = &_input.application_id;
            let input_46 =
                input_46
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    })?;
            let application_id = aws_smithy_http::label::fmt_string(input_46, false);
            if application_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "application_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_47 = &_input.configuration_profile_id;
            let input_47 =
                input_47
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "configuration_profile_id",
                        details: "cannot be empty or unset",
                    })?;
            let configuration_profile_id = aws_smithy_http::label::fmt_string(input_47, false);
            if configuration_profile_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "configuration_profile_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/applications/{ApplicationId}/configurationprofiles/{ConfigurationProfileId}/hostedconfigurationversions", ApplicationId = application_id, ConfigurationProfileId = configuration_profile_id).expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListHostedConfigurationVersionsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_48) = &_input.max_results {
                query.push_kv(
                    "max_results",
                    aws_smithy_types::primitive::Encoder::from(*inner_48).encode(),
                );
            }
            if let Some(inner_49) = &_input.next_token {
                query.push_kv("next_token", &aws_smithy_http::query::fmt_string(&inner_49));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListHostedConfigurationVersionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListHostedConfigurationVersionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListHostedConfigurationVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListHostedConfigurationVersions",
            "appconfig",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListHostedConfigurationVersionsInput`](crate::input::ListHostedConfigurationVersionsInput)
    pub fn builder() -> crate::input::list_hosted_configuration_versions_input::Builder {
        crate::input::list_hosted_configuration_versions_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The resource ARN.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The resource ARN.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_50 = &_input.resource_arn;
            let input_50 =
                input_50
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_50, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "appconfig",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`StartDeploymentInput`](crate::input::StartDeploymentInput)
pub mod start_deployment_input {
    /// A builder for [`StartDeploymentInput`](crate::input::StartDeploymentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) environment_id: std::option::Option<std::string::String>,
        pub(crate) deployment_strategy_id: std::option::Option<std::string::String>,
        pub(crate) configuration_profile_id: std::option::Option<std::string::String>,
        pub(crate) configuration_version: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The application ID.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The application ID.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The environment ID.</p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_id = Some(input.into());
            self
        }
        /// <p>The environment ID.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_id = input;
            self
        }
        /// <p>The deployment strategy ID.</p>
        pub fn deployment_strategy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_strategy_id = Some(input.into());
            self
        }
        /// <p>The deployment strategy ID.</p>
        pub fn set_deployment_strategy_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_strategy_id = input;
            self
        }
        /// <p>The configuration profile ID.</p>
        pub fn configuration_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_profile_id = Some(input.into());
            self
        }
        /// <p>The configuration profile ID.</p>
        pub fn set_configuration_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_profile_id = input;
            self
        }
        /// <p>The configuration version to deploy.</p>
        pub fn configuration_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_version = Some(input.into());
            self
        }
        /// <p>The configuration version to deploy.</p>
        pub fn set_configuration_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_version = input;
            self
        }
        /// <p>A description of the deployment.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the deployment.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata to assign to the deployment. Tags help organize and categorize your AppConfig resources. Each tag consists of a key and an optional value, both of which you define.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Metadata to assign to the deployment. Tags help organize and categorize your AppConfig resources. Each tag consists of a key and an optional value, both of which you define.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`StartDeploymentInput`](crate::input::StartDeploymentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartDeploymentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartDeploymentInput {
                application_id: self.application_id,
                environment_id: self.environment_id,
                deployment_strategy_id: self.deployment_strategy_id,
                configuration_profile_id: self.configuration_profile_id,
                configuration_version: self.configuration_version,
                description: self.description,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type StartDeploymentInputOperationOutputAlias = crate::operation::StartDeployment;
#[doc(hidden)]
pub type StartDeploymentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartDeploymentInput {
    /// Consumes the builder and constructs an Operation<[`StartDeployment`](crate::operation::StartDeployment)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartDeployment,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartDeploymentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_51 = &_input.application_id;
            let input_51 =
                input_51
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    })?;
            let application_id = aws_smithy_http::label::fmt_string(input_51, false);
            if application_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "application_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_52 = &_input.environment_id;
            let input_52 =
                input_52
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "environment_id",
                        details: "cannot be empty or unset",
                    })?;
            let environment_id = aws_smithy_http::label::fmt_string(input_52, false);
            if environment_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "environment_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/applications/{ApplicationId}/environments/{EnvironmentId}/deployments",
                ApplicationId = application_id,
                EnvironmentId = environment_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartDeploymentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartDeploymentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_start_deployment(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartDeployment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartDeployment",
            "appconfig",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartDeploymentInput`](crate::input::StartDeploymentInput)
    pub fn builder() -> crate::input::start_deployment_input::Builder {
        crate::input::start_deployment_input::Builder::default()
    }
}

/// See [`StopDeploymentInput`](crate::input::StopDeploymentInput)
pub mod stop_deployment_input {
    /// A builder for [`StopDeploymentInput`](crate::input::StopDeploymentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) environment_id: std::option::Option<std::string::String>,
        pub(crate) deployment_number: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The application ID.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The application ID.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The environment ID.</p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_id = Some(input.into());
            self
        }
        /// <p>The environment ID.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_id = input;
            self
        }
        /// <p>The sequence number of the deployment.</p>
        pub fn deployment_number(mut self, input: i32) -> Self {
            self.deployment_number = Some(input);
            self
        }
        /// <p>The sequence number of the deployment.</p>
        pub fn set_deployment_number(mut self, input: std::option::Option<i32>) -> Self {
            self.deployment_number = input;
            self
        }
        /// Consumes the builder and constructs a [`StopDeploymentInput`](crate::input::StopDeploymentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StopDeploymentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StopDeploymentInput {
                application_id: self.application_id,
                environment_id: self.environment_id,
                deployment_number: self.deployment_number,
            })
        }
    }
}
#[doc(hidden)]
pub type StopDeploymentInputOperationOutputAlias = crate::operation::StopDeployment;
#[doc(hidden)]
pub type StopDeploymentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StopDeploymentInput {
    /// Consumes the builder and constructs an Operation<[`StopDeployment`](crate::operation::StopDeployment)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopDeployment,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StopDeploymentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_53 = &_input.application_id;
            let input_53 =
                input_53
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    })?;
            let application_id = aws_smithy_http::label::fmt_string(input_53, false);
            if application_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "application_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_54 = &_input.environment_id;
            let input_54 =
                input_54
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "environment_id",
                        details: "cannot be empty or unset",
                    })?;
            let environment_id = aws_smithy_http::label::fmt_string(input_54, false);
            if environment_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "environment_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_55 = &_input.deployment_number;
            let input_55 =
                input_55
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "deployment_number",
                        details: "cannot be empty or unset",
                    })?;
            let mut deployment_number_encoder =
                aws_smithy_types::primitive::Encoder::from(*input_55);
            let deployment_number = deployment_number_encoder.encode();
            if deployment_number.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "deployment_number",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/applications/{ApplicationId}/environments/{EnvironmentId}/deployments/{DeploymentNumber}", ApplicationId = application_id, EnvironmentId = environment_id, DeploymentNumber = deployment_number).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StopDeploymentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StopDeploymentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StopDeployment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StopDeployment",
            "appconfig",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StopDeploymentInput`](crate::input::StopDeploymentInput)
    pub fn builder() -> crate::input::stop_deployment_input::Builder {
        crate::input::stop_deployment_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ARN of the resource for which to retrieve tags.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource for which to retrieve tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value string map. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The key-value string map. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_56 = &_input.resource_arn;
            let input_56 =
                input_56
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_56, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "appconfig",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ARN of the resource for which to remove tags.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource for which to remove tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys to delete.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The tag keys to delete.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_57 = &_input.resource_arn;
            let input_57 =
                input_57
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_57, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::UntagResourceInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_58) = &_input.tag_keys {
                for inner_59 in inner_58 {
                    query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_59));
                }
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "appconfig",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateApplicationInput`](crate::input::UpdateApplicationInput)
pub mod update_application_input {
    /// A builder for [`UpdateApplicationInput`](crate::input::UpdateApplicationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The application ID.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The application ID.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The name of the application.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the application.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A description of the application.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the application.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateApplicationInput`](crate::input::UpdateApplicationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateApplicationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateApplicationInput {
                application_id: self.application_id,
                name: self.name,
                description: self.description,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateApplicationInputOperationOutputAlias = crate::operation::UpdateApplication;
#[doc(hidden)]
pub type UpdateApplicationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateApplicationInput {
    /// Consumes the builder and constructs an Operation<[`UpdateApplication`](crate::operation::UpdateApplication)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateApplication,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateApplicationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_60 = &_input.application_id;
            let input_60 =
                input_60
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    })?;
            let application_id = aws_smithy_http::label::fmt_string(input_60, false);
            if application_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "application_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/applications/{ApplicationId}",
                ApplicationId = application_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateApplicationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PATCH").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateApplicationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_application(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateApplication::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateApplication",
            "appconfig",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateApplicationInput`](crate::input::UpdateApplicationInput)
    pub fn builder() -> crate::input::update_application_input::Builder {
        crate::input::update_application_input::Builder::default()
    }
}

/// See [`UpdateConfigurationProfileInput`](crate::input::UpdateConfigurationProfileInput)
pub mod update_configuration_profile_input {
    /// A builder for [`UpdateConfigurationProfileInput`](crate::input::UpdateConfigurationProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) configuration_profile_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) retrieval_role_arn: std::option::Option<std::string::String>,
        pub(crate) validators: std::option::Option<std::vec::Vec<crate::model::Validator>>,
    }
    impl Builder {
        /// <p>The application ID.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The application ID.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The ID of the configuration profile.</p>
        pub fn configuration_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_profile_id = Some(input.into());
            self
        }
        /// <p>The ID of the configuration profile.</p>
        pub fn set_configuration_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_profile_id = input;
            self
        }
        /// <p>The name of the configuration profile.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the configuration profile.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A description of the configuration profile.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the configuration profile.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The ARN of an IAM role with permission to access the configuration at the specified <code>LocationUri</code>.</p>
        pub fn retrieval_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.retrieval_role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of an IAM role with permission to access the configuration at the specified <code>LocationUri</code>.</p>
        pub fn set_retrieval_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.retrieval_role_arn = input;
            self
        }
        /// Appends an item to `validators`.
        ///
        /// To override the contents of this collection use [`set_validators`](Self::set_validators).
        ///
        /// <p>A list of methods for validating the configuration.</p>
        pub fn validators(mut self, input: crate::model::Validator) -> Self {
            let mut v = self.validators.unwrap_or_default();
            v.push(input);
            self.validators = Some(v);
            self
        }
        /// <p>A list of methods for validating the configuration.</p>
        pub fn set_validators(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Validator>>,
        ) -> Self {
            self.validators = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateConfigurationProfileInput`](crate::input::UpdateConfigurationProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateConfigurationProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateConfigurationProfileInput {
                application_id: self.application_id,
                configuration_profile_id: self.configuration_profile_id,
                name: self.name,
                description: self.description,
                retrieval_role_arn: self.retrieval_role_arn,
                validators: self.validators,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateConfigurationProfileInputOperationOutputAlias =
    crate::operation::UpdateConfigurationProfile;
#[doc(hidden)]
pub type UpdateConfigurationProfileInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateConfigurationProfileInput {
    /// Consumes the builder and constructs an Operation<[`UpdateConfigurationProfile`](crate::operation::UpdateConfigurationProfile)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateConfigurationProfile,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateConfigurationProfileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_61 = &_input.application_id;
            let input_61 =
                input_61
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    })?;
            let application_id = aws_smithy_http::label::fmt_string(input_61, false);
            if application_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "application_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_62 = &_input.configuration_profile_id;
            let input_62 =
                input_62
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "configuration_profile_id",
                        details: "cannot be empty or unset",
                    })?;
            let configuration_profile_id = aws_smithy_http::label::fmt_string(input_62, false);
            if configuration_profile_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "configuration_profile_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/applications/{ApplicationId}/configurationprofiles/{ConfigurationProfileId}",
                ApplicationId = application_id,
                ConfigurationProfileId = configuration_profile_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateConfigurationProfileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PATCH").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateConfigurationProfileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_configuration_profile(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateConfigurationProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateConfigurationProfile",
            "appconfig",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateConfigurationProfileInput`](crate::input::UpdateConfigurationProfileInput)
    pub fn builder() -> crate::input::update_configuration_profile_input::Builder {
        crate::input::update_configuration_profile_input::Builder::default()
    }
}

/// See [`UpdateDeploymentStrategyInput`](crate::input::UpdateDeploymentStrategyInput)
pub mod update_deployment_strategy_input {
    /// A builder for [`UpdateDeploymentStrategyInput`](crate::input::UpdateDeploymentStrategyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deployment_strategy_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) deployment_duration_in_minutes: std::option::Option<i32>,
        pub(crate) final_bake_time_in_minutes: std::option::Option<i32>,
        pub(crate) growth_factor: std::option::Option<f32>,
        pub(crate) growth_type: std::option::Option<crate::model::GrowthType>,
    }
    impl Builder {
        /// <p>The deployment strategy ID.</p>
        pub fn deployment_strategy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_strategy_id = Some(input.into());
            self
        }
        /// <p>The deployment strategy ID.</p>
        pub fn set_deployment_strategy_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_strategy_id = input;
            self
        }
        /// <p>A description of the deployment strategy.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the deployment strategy.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Total amount of time for a deployment to last.</p>
        pub fn deployment_duration_in_minutes(mut self, input: i32) -> Self {
            self.deployment_duration_in_minutes = Some(input);
            self
        }
        /// <p>Total amount of time for a deployment to last.</p>
        pub fn set_deployment_duration_in_minutes(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.deployment_duration_in_minutes = input;
            self
        }
        /// <p>The amount of time that AppConfig monitors for alarms before considering the deployment to be complete and no longer eligible for automatic rollback.</p>
        pub fn final_bake_time_in_minutes(mut self, input: i32) -> Self {
            self.final_bake_time_in_minutes = Some(input);
            self
        }
        /// <p>The amount of time that AppConfig monitors for alarms before considering the deployment to be complete and no longer eligible for automatic rollback.</p>
        pub fn set_final_bake_time_in_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.final_bake_time_in_minutes = input;
            self
        }
        /// <p>The percentage of targets to receive a deployed configuration during each interval.</p>
        pub fn growth_factor(mut self, input: f32) -> Self {
            self.growth_factor = Some(input);
            self
        }
        /// <p>The percentage of targets to receive a deployed configuration during each interval.</p>
        pub fn set_growth_factor(mut self, input: std::option::Option<f32>) -> Self {
            self.growth_factor = input;
            self
        }
        /// <p>The algorithm used to define how percentage grows over time. AppConfig supports the following growth types:</p>
        /// <p> <b>Linear</b>: For this type, AppConfig processes the deployment by increments of the growth factor evenly distributed over the deployment time. For example, a linear deployment that uses a growth factor of 20 initially makes the configuration available to 20 percent of the targets. After 1/5th of the deployment time has passed, the system updates the percentage to 40 percent. This continues until 100% of the targets are set to receive the deployed configuration.</p>
        /// <p> <b>Exponential</b>: For this type, AppConfig processes the deployment exponentially using the following formula: <code>G*(2^N)</code>. In this formula, <code>G</code> is the growth factor specified by the user and <code>N</code> is the number of steps until the configuration is deployed to all targets. For example, if you specify a growth factor of 2, then the system rolls out the configuration as follows:</p>
        /// <p> <code>2*(2^0)</code> </p>
        /// <p> <code>2*(2^1)</code> </p>
        /// <p> <code>2*(2^2)</code> </p>
        /// <p>Expressed numerically, the deployment rolls out as follows: 2% of the targets, 4% of the targets, 8% of the targets, and continues until the configuration has been deployed to all targets.</p>
        pub fn growth_type(mut self, input: crate::model::GrowthType) -> Self {
            self.growth_type = Some(input);
            self
        }
        /// <p>The algorithm used to define how percentage grows over time. AppConfig supports the following growth types:</p>
        /// <p> <b>Linear</b>: For this type, AppConfig processes the deployment by increments of the growth factor evenly distributed over the deployment time. For example, a linear deployment that uses a growth factor of 20 initially makes the configuration available to 20 percent of the targets. After 1/5th of the deployment time has passed, the system updates the percentage to 40 percent. This continues until 100% of the targets are set to receive the deployed configuration.</p>
        /// <p> <b>Exponential</b>: For this type, AppConfig processes the deployment exponentially using the following formula: <code>G*(2^N)</code>. In this formula, <code>G</code> is the growth factor specified by the user and <code>N</code> is the number of steps until the configuration is deployed to all targets. For example, if you specify a growth factor of 2, then the system rolls out the configuration as follows:</p>
        /// <p> <code>2*(2^0)</code> </p>
        /// <p> <code>2*(2^1)</code> </p>
        /// <p> <code>2*(2^2)</code> </p>
        /// <p>Expressed numerically, the deployment rolls out as follows: 2% of the targets, 4% of the targets, 8% of the targets, and continues until the configuration has been deployed to all targets.</p>
        pub fn set_growth_type(
            mut self,
            input: std::option::Option<crate::model::GrowthType>,
        ) -> Self {
            self.growth_type = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDeploymentStrategyInput`](crate::input::UpdateDeploymentStrategyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateDeploymentStrategyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateDeploymentStrategyInput {
                deployment_strategy_id: self.deployment_strategy_id,
                description: self.description,
                deployment_duration_in_minutes: self.deployment_duration_in_minutes,
                final_bake_time_in_minutes: self.final_bake_time_in_minutes,
                growth_factor: self.growth_factor,
                growth_type: self.growth_type,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateDeploymentStrategyInputOperationOutputAlias =
    crate::operation::UpdateDeploymentStrategy;
#[doc(hidden)]
pub type UpdateDeploymentStrategyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateDeploymentStrategyInput {
    /// Consumes the builder and constructs an Operation<[`UpdateDeploymentStrategy`](crate::operation::UpdateDeploymentStrategy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateDeploymentStrategy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateDeploymentStrategyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_63 = &_input.deployment_strategy_id;
            let input_63 =
                input_63
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "deployment_strategy_id",
                        details: "cannot be empty or unset",
                    })?;
            let deployment_strategy_id = aws_smithy_http::label::fmt_string(input_63, false);
            if deployment_strategy_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "deployment_strategy_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/deploymentstrategies/{DeploymentStrategyId}",
                DeploymentStrategyId = deployment_strategy_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateDeploymentStrategyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PATCH").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateDeploymentStrategyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_deployment_strategy(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateDeploymentStrategy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateDeploymentStrategy",
            "appconfig",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateDeploymentStrategyInput`](crate::input::UpdateDeploymentStrategyInput)
    pub fn builder() -> crate::input::update_deployment_strategy_input::Builder {
        crate::input::update_deployment_strategy_input::Builder::default()
    }
}

/// See [`UpdateEnvironmentInput`](crate::input::UpdateEnvironmentInput)
pub mod update_environment_input {
    /// A builder for [`UpdateEnvironmentInput`](crate::input::UpdateEnvironmentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) environment_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) monitors: std::option::Option<std::vec::Vec<crate::model::Monitor>>,
    }
    impl Builder {
        /// <p>The application ID.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The application ID.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The environment ID.</p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_id = Some(input.into());
            self
        }
        /// <p>The environment ID.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_id = input;
            self
        }
        /// <p>The name of the environment.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the environment.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A description of the environment.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the environment.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `monitors`.
        ///
        /// To override the contents of this collection use [`set_monitors`](Self::set_monitors).
        ///
        /// <p>Amazon CloudWatch alarms to monitor during the deployment process.</p>
        pub fn monitors(mut self, input: crate::model::Monitor) -> Self {
            let mut v = self.monitors.unwrap_or_default();
            v.push(input);
            self.monitors = Some(v);
            self
        }
        /// <p>Amazon CloudWatch alarms to monitor during the deployment process.</p>
        pub fn set_monitors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Monitor>>,
        ) -> Self {
            self.monitors = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateEnvironmentInput`](crate::input::UpdateEnvironmentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateEnvironmentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateEnvironmentInput {
                application_id: self.application_id,
                environment_id: self.environment_id,
                name: self.name,
                description: self.description,
                monitors: self.monitors,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateEnvironmentInputOperationOutputAlias = crate::operation::UpdateEnvironment;
#[doc(hidden)]
pub type UpdateEnvironmentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateEnvironmentInput {
    /// Consumes the builder and constructs an Operation<[`UpdateEnvironment`](crate::operation::UpdateEnvironment)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateEnvironment,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateEnvironmentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_64 = &_input.application_id;
            let input_64 =
                input_64
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    })?;
            let application_id = aws_smithy_http::label::fmt_string(input_64, false);
            if application_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "application_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_65 = &_input.environment_id;
            let input_65 =
                input_65
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "environment_id",
                        details: "cannot be empty or unset",
                    })?;
            let environment_id = aws_smithy_http::label::fmt_string(input_65, false);
            if environment_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "environment_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/applications/{ApplicationId}/environments/{EnvironmentId}",
                ApplicationId = application_id,
                EnvironmentId = environment_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateEnvironmentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PATCH").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateEnvironmentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_environment(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateEnvironment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateEnvironment",
            "appconfig",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateEnvironmentInput`](crate::input::UpdateEnvironmentInput)
    pub fn builder() -> crate::input::update_environment_input::Builder {
        crate::input::update_environment_input::Builder::default()
    }
}

/// See [`ValidateConfigurationInput`](crate::input::ValidateConfigurationInput)
pub mod validate_configuration_input {
    /// A builder for [`ValidateConfigurationInput`](crate::input::ValidateConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) configuration_profile_id: std::option::Option<std::string::String>,
        pub(crate) configuration_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The application ID.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The application ID.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The configuration profile ID.</p>
        pub fn configuration_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_profile_id = Some(input.into());
            self
        }
        /// <p>The configuration profile ID.</p>
        pub fn set_configuration_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_profile_id = input;
            self
        }
        /// <p>The version of the configuration to validate.</p>
        pub fn configuration_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_version = Some(input.into());
            self
        }
        /// <p>The version of the configuration to validate.</p>
        pub fn set_configuration_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_version = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidateConfigurationInput`](crate::input::ValidateConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ValidateConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ValidateConfigurationInput {
                application_id: self.application_id,
                configuration_profile_id: self.configuration_profile_id,
                configuration_version: self.configuration_version,
            })
        }
    }
}
#[doc(hidden)]
pub type ValidateConfigurationInputOperationOutputAlias = crate::operation::ValidateConfiguration;
#[doc(hidden)]
pub type ValidateConfigurationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ValidateConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`ValidateConfiguration`](crate::operation::ValidateConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ValidateConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ValidateConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_66 = &_input.application_id;
            let input_66 =
                input_66
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    })?;
            let application_id = aws_smithy_http::label::fmt_string(input_66, false);
            if application_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "application_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_67 = &_input.configuration_profile_id;
            let input_67 =
                input_67
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "configuration_profile_id",
                        details: "cannot be empty or unset",
                    })?;
            let configuration_profile_id = aws_smithy_http::label::fmt_string(input_67, false);
            if configuration_profile_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "configuration_profile_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/applications/{ApplicationId}/configurationprofiles/{ConfigurationProfileId}/validators", ApplicationId = application_id, ConfigurationProfileId = configuration_profile_id).expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ValidateConfigurationInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_68) = &_input.configuration_version {
                query.push_kv(
                    "configuration_version",
                    &aws_smithy_http::query::fmt_string(&inner_68),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ValidateConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ValidateConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ValidateConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ValidateConfiguration",
            "appconfig",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ValidateConfigurationInput`](crate::input::ValidateConfigurationInput)
    pub fn builder() -> crate::input::validate_configuration_input::Builder {
        crate::input::validate_configuration_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidateConfigurationInput {
    /// <p>The application ID.</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The configuration profile ID.</p>
    pub configuration_profile_id: std::option::Option<std::string::String>,
    /// <p>The version of the configuration to validate.</p>
    pub configuration_version: std::option::Option<std::string::String>,
}
impl ValidateConfigurationInput {
    /// <p>The application ID.</p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
    /// <p>The configuration profile ID.</p>
    pub fn configuration_profile_id(&self) -> std::option::Option<&str> {
        self.configuration_profile_id.as_deref()
    }
    /// <p>The version of the configuration to validate.</p>
    pub fn configuration_version(&self) -> std::option::Option<&str> {
        self.configuration_version.as_deref()
    }
}
impl std::fmt::Debug for ValidateConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidateConfigurationInput");
        formatter.field("application_id", &self.application_id);
        formatter.field("configuration_profile_id", &self.configuration_profile_id);
        formatter.field("configuration_version", &self.configuration_version);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateEnvironmentInput {
    /// <p>The application ID.</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The environment ID.</p>
    pub environment_id: std::option::Option<std::string::String>,
    /// <p>The name of the environment.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A description of the environment.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Amazon CloudWatch alarms to monitor during the deployment process.</p>
    pub monitors: std::option::Option<std::vec::Vec<crate::model::Monitor>>,
}
impl UpdateEnvironmentInput {
    /// <p>The application ID.</p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
    /// <p>The environment ID.</p>
    pub fn environment_id(&self) -> std::option::Option<&str> {
        self.environment_id.as_deref()
    }
    /// <p>The name of the environment.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A description of the environment.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Amazon CloudWatch alarms to monitor during the deployment process.</p>
    pub fn monitors(&self) -> std::option::Option<&[crate::model::Monitor]> {
        self.monitors.as_deref()
    }
}
impl std::fmt::Debug for UpdateEnvironmentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateEnvironmentInput");
        formatter.field("application_id", &self.application_id);
        formatter.field("environment_id", &self.environment_id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("monitors", &self.monitors);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDeploymentStrategyInput {
    /// <p>The deployment strategy ID.</p>
    pub deployment_strategy_id: std::option::Option<std::string::String>,
    /// <p>A description of the deployment strategy.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Total amount of time for a deployment to last.</p>
    pub deployment_duration_in_minutes: std::option::Option<i32>,
    /// <p>The amount of time that AppConfig monitors for alarms before considering the deployment to be complete and no longer eligible for automatic rollback.</p>
    pub final_bake_time_in_minutes: std::option::Option<i32>,
    /// <p>The percentage of targets to receive a deployed configuration during each interval.</p>
    pub growth_factor: std::option::Option<f32>,
    /// <p>The algorithm used to define how percentage grows over time. AppConfig supports the following growth types:</p>
    /// <p> <b>Linear</b>: For this type, AppConfig processes the deployment by increments of the growth factor evenly distributed over the deployment time. For example, a linear deployment that uses a growth factor of 20 initially makes the configuration available to 20 percent of the targets. After 1/5th of the deployment time has passed, the system updates the percentage to 40 percent. This continues until 100% of the targets are set to receive the deployed configuration.</p>
    /// <p> <b>Exponential</b>: For this type, AppConfig processes the deployment exponentially using the following formula: <code>G*(2^N)</code>. In this formula, <code>G</code> is the growth factor specified by the user and <code>N</code> is the number of steps until the configuration is deployed to all targets. For example, if you specify a growth factor of 2, then the system rolls out the configuration as follows:</p>
    /// <p> <code>2*(2^0)</code> </p>
    /// <p> <code>2*(2^1)</code> </p>
    /// <p> <code>2*(2^2)</code> </p>
    /// <p>Expressed numerically, the deployment rolls out as follows: 2% of the targets, 4% of the targets, 8% of the targets, and continues until the configuration has been deployed to all targets.</p>
    pub growth_type: std::option::Option<crate::model::GrowthType>,
}
impl UpdateDeploymentStrategyInput {
    /// <p>The deployment strategy ID.</p>
    pub fn deployment_strategy_id(&self) -> std::option::Option<&str> {
        self.deployment_strategy_id.as_deref()
    }
    /// <p>A description of the deployment strategy.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Total amount of time for a deployment to last.</p>
    pub fn deployment_duration_in_minutes(&self) -> std::option::Option<i32> {
        self.deployment_duration_in_minutes
    }
    /// <p>The amount of time that AppConfig monitors for alarms before considering the deployment to be complete and no longer eligible for automatic rollback.</p>
    pub fn final_bake_time_in_minutes(&self) -> std::option::Option<i32> {
        self.final_bake_time_in_minutes
    }
    /// <p>The percentage of targets to receive a deployed configuration during each interval.</p>
    pub fn growth_factor(&self) -> std::option::Option<f32> {
        self.growth_factor
    }
    /// <p>The algorithm used to define how percentage grows over time. AppConfig supports the following growth types:</p>
    /// <p> <b>Linear</b>: For this type, AppConfig processes the deployment by increments of the growth factor evenly distributed over the deployment time. For example, a linear deployment that uses a growth factor of 20 initially makes the configuration available to 20 percent of the targets. After 1/5th of the deployment time has passed, the system updates the percentage to 40 percent. This continues until 100% of the targets are set to receive the deployed configuration.</p>
    /// <p> <b>Exponential</b>: For this type, AppConfig processes the deployment exponentially using the following formula: <code>G*(2^N)</code>. In this formula, <code>G</code> is the growth factor specified by the user and <code>N</code> is the number of steps until the configuration is deployed to all targets. For example, if you specify a growth factor of 2, then the system rolls out the configuration as follows:</p>
    /// <p> <code>2*(2^0)</code> </p>
    /// <p> <code>2*(2^1)</code> </p>
    /// <p> <code>2*(2^2)</code> </p>
    /// <p>Expressed numerically, the deployment rolls out as follows: 2% of the targets, 4% of the targets, 8% of the targets, and continues until the configuration has been deployed to all targets.</p>
    pub fn growth_type(&self) -> std::option::Option<&crate::model::GrowthType> {
        self.growth_type.as_ref()
    }
}
impl std::fmt::Debug for UpdateDeploymentStrategyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDeploymentStrategyInput");
        formatter.field("deployment_strategy_id", &self.deployment_strategy_id);
        formatter.field("description", &self.description);
        formatter.field(
            "deployment_duration_in_minutes",
            &self.deployment_duration_in_minutes,
        );
        formatter.field(
            "final_bake_time_in_minutes",
            &self.final_bake_time_in_minutes,
        );
        formatter.field("growth_factor", &self.growth_factor);
        formatter.field("growth_type", &self.growth_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateConfigurationProfileInput {
    /// <p>The application ID.</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The ID of the configuration profile.</p>
    pub configuration_profile_id: std::option::Option<std::string::String>,
    /// <p>The name of the configuration profile.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A description of the configuration profile.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The ARN of an IAM role with permission to access the configuration at the specified <code>LocationUri</code>.</p>
    pub retrieval_role_arn: std::option::Option<std::string::String>,
    /// <p>A list of methods for validating the configuration.</p>
    pub validators: std::option::Option<std::vec::Vec<crate::model::Validator>>,
}
impl UpdateConfigurationProfileInput {
    /// <p>The application ID.</p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
    /// <p>The ID of the configuration profile.</p>
    pub fn configuration_profile_id(&self) -> std::option::Option<&str> {
        self.configuration_profile_id.as_deref()
    }
    /// <p>The name of the configuration profile.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A description of the configuration profile.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The ARN of an IAM role with permission to access the configuration at the specified <code>LocationUri</code>.</p>
    pub fn retrieval_role_arn(&self) -> std::option::Option<&str> {
        self.retrieval_role_arn.as_deref()
    }
    /// <p>A list of methods for validating the configuration.</p>
    pub fn validators(&self) -> std::option::Option<&[crate::model::Validator]> {
        self.validators.as_deref()
    }
}
impl std::fmt::Debug for UpdateConfigurationProfileInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateConfigurationProfileInput");
        formatter.field("application_id", &self.application_id);
        formatter.field("configuration_profile_id", &self.configuration_profile_id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("retrieval_role_arn", &self.retrieval_role_arn);
        formatter.field("validators", &self.validators);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateApplicationInput {
    /// <p>The application ID.</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The name of the application.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A description of the application.</p>
    pub description: std::option::Option<std::string::String>,
}
impl UpdateApplicationInput {
    /// <p>The application ID.</p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
    /// <p>The name of the application.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A description of the application.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for UpdateApplicationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateApplicationInput");
        formatter.field("application_id", &self.application_id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The ARN of the resource for which to remove tags.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The tag keys to delete.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The ARN of the resource for which to remove tags.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The tag keys to delete.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The ARN of the resource for which to retrieve tags.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The key-value string map. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl TagResourceInput {
    /// <p>The ARN of the resource for which to retrieve tags.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The key-value string map. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopDeploymentInput {
    /// <p>The application ID.</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The environment ID.</p>
    pub environment_id: std::option::Option<std::string::String>,
    /// <p>The sequence number of the deployment.</p>
    pub deployment_number: std::option::Option<i32>,
}
impl StopDeploymentInput {
    /// <p>The application ID.</p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
    /// <p>The environment ID.</p>
    pub fn environment_id(&self) -> std::option::Option<&str> {
        self.environment_id.as_deref()
    }
    /// <p>The sequence number of the deployment.</p>
    pub fn deployment_number(&self) -> std::option::Option<i32> {
        self.deployment_number
    }
}
impl std::fmt::Debug for StopDeploymentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopDeploymentInput");
        formatter.field("application_id", &self.application_id);
        formatter.field("environment_id", &self.environment_id);
        formatter.field("deployment_number", &self.deployment_number);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartDeploymentInput {
    /// <p>The application ID.</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The environment ID.</p>
    pub environment_id: std::option::Option<std::string::String>,
    /// <p>The deployment strategy ID.</p>
    pub deployment_strategy_id: std::option::Option<std::string::String>,
    /// <p>The configuration profile ID.</p>
    pub configuration_profile_id: std::option::Option<std::string::String>,
    /// <p>The configuration version to deploy.</p>
    pub configuration_version: std::option::Option<std::string::String>,
    /// <p>A description of the deployment.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Metadata to assign to the deployment. Tags help organize and categorize your AppConfig resources. Each tag consists of a key and an optional value, both of which you define.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl StartDeploymentInput {
    /// <p>The application ID.</p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
    /// <p>The environment ID.</p>
    pub fn environment_id(&self) -> std::option::Option<&str> {
        self.environment_id.as_deref()
    }
    /// <p>The deployment strategy ID.</p>
    pub fn deployment_strategy_id(&self) -> std::option::Option<&str> {
        self.deployment_strategy_id.as_deref()
    }
    /// <p>The configuration profile ID.</p>
    pub fn configuration_profile_id(&self) -> std::option::Option<&str> {
        self.configuration_profile_id.as_deref()
    }
    /// <p>The configuration version to deploy.</p>
    pub fn configuration_version(&self) -> std::option::Option<&str> {
        self.configuration_version.as_deref()
    }
    /// <p>A description of the deployment.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Metadata to assign to the deployment. Tags help organize and categorize your AppConfig resources. Each tag consists of a key and an optional value, both of which you define.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for StartDeploymentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartDeploymentInput");
        formatter.field("application_id", &self.application_id);
        formatter.field("environment_id", &self.environment_id);
        formatter.field("deployment_strategy_id", &self.deployment_strategy_id);
        formatter.field("configuration_profile_id", &self.configuration_profile_id);
        formatter.field("configuration_version", &self.configuration_version);
        formatter.field("description", &self.description);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The resource ARN.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The resource ARN.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListHostedConfigurationVersionsInput {
    /// <p>The application ID.</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The configuration profile ID.</p>
    pub configuration_profile_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>A token to start the list. Use this token to get the next set of results. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListHostedConfigurationVersionsInput {
    /// <p>The application ID.</p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
    /// <p>The configuration profile ID.</p>
    pub fn configuration_profile_id(&self) -> std::option::Option<&str> {
        self.configuration_profile_id.as_deref()
    }
    /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>A token to start the list. Use this token to get the next set of results. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListHostedConfigurationVersionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListHostedConfigurationVersionsInput");
        formatter.field("application_id", &self.application_id);
        formatter.field("configuration_profile_id", &self.configuration_profile_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListEnvironmentsInput {
    /// <p>The application ID.</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>A token to start the list. Use this token to get the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListEnvironmentsInput {
    /// <p>The application ID.</p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
    /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>A token to start the list. Use this token to get the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListEnvironmentsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListEnvironmentsInput");
        formatter.field("application_id", &self.application_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDeploymentStrategiesInput {
    /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>A token to start the list. Use this token to get the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListDeploymentStrategiesInput {
    /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>A token to start the list. Use this token to get the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListDeploymentStrategiesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDeploymentStrategiesInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDeploymentsInput {
    /// <p>The application ID.</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The environment ID.</p>
    pub environment_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of items that may be returned for this call. If there are items that have not yet been returned, the response will include a non-null <code>NextToken</code> that you can provide in a subsequent call to get the next set of results.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token returned by a prior call to this operation indicating the next set of results to be returned. If not specified, the operation will return the first set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListDeploymentsInput {
    /// <p>The application ID.</p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
    /// <p>The environment ID.</p>
    pub fn environment_id(&self) -> std::option::Option<&str> {
        self.environment_id.as_deref()
    }
    /// <p>The maximum number of items that may be returned for this call. If there are items that have not yet been returned, the response will include a non-null <code>NextToken</code> that you can provide in a subsequent call to get the next set of results.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The token returned by a prior call to this operation indicating the next set of results to be returned. If not specified, the operation will return the first set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListDeploymentsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDeploymentsInput");
        formatter.field("application_id", &self.application_id);
        formatter.field("environment_id", &self.environment_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListConfigurationProfilesInput {
    /// <p>The application ID.</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>A token to start the list. Use this token to get the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>A filter based on the type of configurations that the configuration profile contains. A configuration can be a feature flag or a freeform configuration.</p>
    pub r#type: std::option::Option<std::string::String>,
}
impl ListConfigurationProfilesInput {
    /// <p>The application ID.</p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
    /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>A token to start the list. Use this token to get the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>A filter based on the type of configurations that the configuration profile contains. A configuration can be a feature flag or a freeform configuration.</p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
}
impl std::fmt::Debug for ListConfigurationProfilesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListConfigurationProfilesInput");
        formatter.field("application_id", &self.application_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListApplicationsInput {
    /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>A token to start the list. Next token is a pagination token generated by AppConfig to describe what page the previous List call ended on. For the first List request, the nextToken should not be set. On subsequent calls, the nextToken parameter should be set to the previous responses nextToken value. Use this token to get the next set of results. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListApplicationsInput {
    /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>A token to start the list. Next token is a pagination token generated by AppConfig to describe what page the previous List call ended on. For the first List request, the nextToken should not be set. On subsequent calls, the nextToken parameter should be set to the previous responses nextToken value. Use this token to get the next set of results. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListApplicationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListApplicationsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetHostedConfigurationVersionInput {
    /// <p>The application ID.</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The configuration profile ID.</p>
    pub configuration_profile_id: std::option::Option<std::string::String>,
    /// <p>The version.</p>
    pub version_number: i32,
}
impl GetHostedConfigurationVersionInput {
    /// <p>The application ID.</p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
    /// <p>The configuration profile ID.</p>
    pub fn configuration_profile_id(&self) -> std::option::Option<&str> {
        self.configuration_profile_id.as_deref()
    }
    /// <p>The version.</p>
    pub fn version_number(&self) -> i32 {
        self.version_number
    }
}
impl std::fmt::Debug for GetHostedConfigurationVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetHostedConfigurationVersionInput");
        formatter.field("application_id", &self.application_id);
        formatter.field("configuration_profile_id", &self.configuration_profile_id);
        formatter.field("version_number", &self.version_number);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEnvironmentInput {
    /// <p>The ID of the application that includes the environment you want to get.</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The ID of the environment that you want to get.</p>
    pub environment_id: std::option::Option<std::string::String>,
}
impl GetEnvironmentInput {
    /// <p>The ID of the application that includes the environment you want to get.</p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
    /// <p>The ID of the environment that you want to get.</p>
    pub fn environment_id(&self) -> std::option::Option<&str> {
        self.environment_id.as_deref()
    }
}
impl std::fmt::Debug for GetEnvironmentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEnvironmentInput");
        formatter.field("application_id", &self.application_id);
        formatter.field("environment_id", &self.environment_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDeploymentStrategyInput {
    /// <p>The ID of the deployment strategy to get.</p>
    pub deployment_strategy_id: std::option::Option<std::string::String>,
}
impl GetDeploymentStrategyInput {
    /// <p>The ID of the deployment strategy to get.</p>
    pub fn deployment_strategy_id(&self) -> std::option::Option<&str> {
        self.deployment_strategy_id.as_deref()
    }
}
impl std::fmt::Debug for GetDeploymentStrategyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDeploymentStrategyInput");
        formatter.field("deployment_strategy_id", &self.deployment_strategy_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDeploymentInput {
    /// <p>The ID of the application that includes the deployment you want to get. </p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The ID of the environment that includes the deployment you want to get. </p>
    pub environment_id: std::option::Option<std::string::String>,
    /// <p>The sequence number of the deployment.</p>
    pub deployment_number: std::option::Option<i32>,
}
impl GetDeploymentInput {
    /// <p>The ID of the application that includes the deployment you want to get. </p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
    /// <p>The ID of the environment that includes the deployment you want to get. </p>
    pub fn environment_id(&self) -> std::option::Option<&str> {
        self.environment_id.as_deref()
    }
    /// <p>The sequence number of the deployment.</p>
    pub fn deployment_number(&self) -> std::option::Option<i32> {
        self.deployment_number
    }
}
impl std::fmt::Debug for GetDeploymentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDeploymentInput");
        formatter.field("application_id", &self.application_id);
        formatter.field("environment_id", &self.environment_id);
        formatter.field("deployment_number", &self.deployment_number);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetConfigurationProfileInput {
    /// <p>The ID of the application that includes the configuration profile you want to get.</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The ID of the configuration profile that you want to get.</p>
    pub configuration_profile_id: std::option::Option<std::string::String>,
}
impl GetConfigurationProfileInput {
    /// <p>The ID of the application that includes the configuration profile you want to get.</p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
    /// <p>The ID of the configuration profile that you want to get.</p>
    pub fn configuration_profile_id(&self) -> std::option::Option<&str> {
        self.configuration_profile_id.as_deref()
    }
}
impl std::fmt::Debug for GetConfigurationProfileInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetConfigurationProfileInput");
        formatter.field("application_id", &self.application_id);
        formatter.field("configuration_profile_id", &self.configuration_profile_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetConfigurationInput {
    /// <p>The application to get. Specify either the application name or the application ID.</p>
    pub application: std::option::Option<std::string::String>,
    /// <p>The environment to get. Specify either the environment name or the environment ID.</p>
    pub environment: std::option::Option<std::string::String>,
    /// <p>The configuration to get. Specify either the configuration name or the configuration ID.</p>
    pub configuration: std::option::Option<std::string::String>,
    /// <p>The clientId parameter in the following command is a unique, user-specified ID to identify the client for the configuration. This ID enables AppConfig to deploy the configuration in intervals, as defined in the deployment strategy. </p>
    pub client_id: std::option::Option<std::string::String>,
    /// <p>The configuration version returned in the most recent <code>GetConfiguration</code> response.</p> <important>
    /// <p>AppConfig uses the value of the <code>ClientConfigurationVersion</code> parameter to identify the configuration version on your clients. If you don’t send <code>ClientConfigurationVersion</code> with each call to <code>GetConfiguration</code>, your clients receive the current configuration. You are charged each time your clients receive a configuration.</p>
    /// <p>To avoid excess charges, we recommend that you include the <code>ClientConfigurationVersion</code> value with every call to <code>GetConfiguration</code>. This value must be saved on your client. Subsequent calls to <code>GetConfiguration</code> must pass this value by using the <code>ClientConfigurationVersion</code> parameter. </p>
    /// </important>
    /// <p>For more information about working with configurations, see <a href="http://docs.aws.amazon.com/appconfig/latest/userguide/appconfig-retrieving-the-configuration.html">Retrieving the Configuration</a> in the <i>AppConfig User Guide</i>.</p>
    pub client_configuration_version: std::option::Option<std::string::String>,
}
impl GetConfigurationInput {
    /// <p>The application to get. Specify either the application name or the application ID.</p>
    pub fn application(&self) -> std::option::Option<&str> {
        self.application.as_deref()
    }
    /// <p>The environment to get. Specify either the environment name or the environment ID.</p>
    pub fn environment(&self) -> std::option::Option<&str> {
        self.environment.as_deref()
    }
    /// <p>The configuration to get. Specify either the configuration name or the configuration ID.</p>
    pub fn configuration(&self) -> std::option::Option<&str> {
        self.configuration.as_deref()
    }
    /// <p>The clientId parameter in the following command is a unique, user-specified ID to identify the client for the configuration. This ID enables AppConfig to deploy the configuration in intervals, as defined in the deployment strategy. </p>
    pub fn client_id(&self) -> std::option::Option<&str> {
        self.client_id.as_deref()
    }
    /// <p>The configuration version returned in the most recent <code>GetConfiguration</code> response.</p> <important>
    /// <p>AppConfig uses the value of the <code>ClientConfigurationVersion</code> parameter to identify the configuration version on your clients. If you don’t send <code>ClientConfigurationVersion</code> with each call to <code>GetConfiguration</code>, your clients receive the current configuration. You are charged each time your clients receive a configuration.</p>
    /// <p>To avoid excess charges, we recommend that you include the <code>ClientConfigurationVersion</code> value with every call to <code>GetConfiguration</code>. This value must be saved on your client. Subsequent calls to <code>GetConfiguration</code> must pass this value by using the <code>ClientConfigurationVersion</code> parameter. </p>
    /// </important>
    /// <p>For more information about working with configurations, see <a href="http://docs.aws.amazon.com/appconfig/latest/userguide/appconfig-retrieving-the-configuration.html">Retrieving the Configuration</a> in the <i>AppConfig User Guide</i>.</p>
    pub fn client_configuration_version(&self) -> std::option::Option<&str> {
        self.client_configuration_version.as_deref()
    }
}
impl std::fmt::Debug for GetConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetConfigurationInput");
        formatter.field("application", &self.application);
        formatter.field("environment", &self.environment);
        formatter.field("configuration", &self.configuration);
        formatter.field("client_id", &self.client_id);
        formatter.field(
            "client_configuration_version",
            &self.client_configuration_version,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetApplicationInput {
    /// <p>The ID of the application you want to get.</p>
    pub application_id: std::option::Option<std::string::String>,
}
impl GetApplicationInput {
    /// <p>The ID of the application you want to get.</p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
}
impl std::fmt::Debug for GetApplicationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetApplicationInput");
        formatter.field("application_id", &self.application_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteHostedConfigurationVersionInput {
    /// <p>The application ID.</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The configuration profile ID.</p>
    pub configuration_profile_id: std::option::Option<std::string::String>,
    /// <p>The versions number to delete.</p>
    pub version_number: i32,
}
impl DeleteHostedConfigurationVersionInput {
    /// <p>The application ID.</p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
    /// <p>The configuration profile ID.</p>
    pub fn configuration_profile_id(&self) -> std::option::Option<&str> {
        self.configuration_profile_id.as_deref()
    }
    /// <p>The versions number to delete.</p>
    pub fn version_number(&self) -> i32 {
        self.version_number
    }
}
impl std::fmt::Debug for DeleteHostedConfigurationVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteHostedConfigurationVersionInput");
        formatter.field("application_id", &self.application_id);
        formatter.field("configuration_profile_id", &self.configuration_profile_id);
        formatter.field("version_number", &self.version_number);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteEnvironmentInput {
    /// <p>The application ID that includes the environment that you want to delete.</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The ID of the environment that you want to delete.</p>
    pub environment_id: std::option::Option<std::string::String>,
}
impl DeleteEnvironmentInput {
    /// <p>The application ID that includes the environment that you want to delete.</p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
    /// <p>The ID of the environment that you want to delete.</p>
    pub fn environment_id(&self) -> std::option::Option<&str> {
        self.environment_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteEnvironmentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteEnvironmentInput");
        formatter.field("application_id", &self.application_id);
        formatter.field("environment_id", &self.environment_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDeploymentStrategyInput {
    /// <p>The ID of the deployment strategy you want to delete.</p>
    pub deployment_strategy_id: std::option::Option<std::string::String>,
}
impl DeleteDeploymentStrategyInput {
    /// <p>The ID of the deployment strategy you want to delete.</p>
    pub fn deployment_strategy_id(&self) -> std::option::Option<&str> {
        self.deployment_strategy_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteDeploymentStrategyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDeploymentStrategyInput");
        formatter.field("deployment_strategy_id", &self.deployment_strategy_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteConfigurationProfileInput {
    /// <p>The application ID that includes the configuration profile you want to delete.</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The ID of the configuration profile you want to delete.</p>
    pub configuration_profile_id: std::option::Option<std::string::String>,
}
impl DeleteConfigurationProfileInput {
    /// <p>The application ID that includes the configuration profile you want to delete.</p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
    /// <p>The ID of the configuration profile you want to delete.</p>
    pub fn configuration_profile_id(&self) -> std::option::Option<&str> {
        self.configuration_profile_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteConfigurationProfileInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteConfigurationProfileInput");
        formatter.field("application_id", &self.application_id);
        formatter.field("configuration_profile_id", &self.configuration_profile_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteApplicationInput {
    /// <p>The ID of the application to delete.</p>
    pub application_id: std::option::Option<std::string::String>,
}
impl DeleteApplicationInput {
    /// <p>The ID of the application to delete.</p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteApplicationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteApplicationInput");
        formatter.field("application_id", &self.application_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateHostedConfigurationVersionInput {
    /// <p>The application ID.</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The configuration profile ID.</p>
    pub configuration_profile_id: std::option::Option<std::string::String>,
    /// <p>A description of the configuration.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The content of the configuration or the configuration data.</p>
    pub content: std::option::Option<aws_smithy_types::Blob>,
    /// <p>A standard MIME type describing the format of the configuration content. For more information, see <a href="https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17">Content-Type</a>.</p>
    pub content_type: std::option::Option<std::string::String>,
    /// <p>An optional locking token used to prevent race conditions from overwriting configuration updates when creating a new version. To ensure your data is not overwritten when creating multiple hosted configuration versions in rapid succession, specify the version number of the latest hosted configuration version.</p>
    pub latest_version_number: std::option::Option<i32>,
}
impl CreateHostedConfigurationVersionInput {
    /// <p>The application ID.</p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
    /// <p>The configuration profile ID.</p>
    pub fn configuration_profile_id(&self) -> std::option::Option<&str> {
        self.configuration_profile_id.as_deref()
    }
    /// <p>A description of the configuration.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The content of the configuration or the configuration data.</p>
    pub fn content(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.content.as_ref()
    }
    /// <p>A standard MIME type describing the format of the configuration content. For more information, see <a href="https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17">Content-Type</a>.</p>
    pub fn content_type(&self) -> std::option::Option<&str> {
        self.content_type.as_deref()
    }
    /// <p>An optional locking token used to prevent race conditions from overwriting configuration updates when creating a new version. To ensure your data is not overwritten when creating multiple hosted configuration versions in rapid succession, specify the version number of the latest hosted configuration version.</p>
    pub fn latest_version_number(&self) -> std::option::Option<i32> {
        self.latest_version_number
    }
}
impl std::fmt::Debug for CreateHostedConfigurationVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateHostedConfigurationVersionInput");
        formatter.field("application_id", &self.application_id);
        formatter.field("configuration_profile_id", &self.configuration_profile_id);
        formatter.field("description", &self.description);
        formatter.field("content", &"*** Sensitive Data Redacted ***");
        formatter.field("content_type", &self.content_type);
        formatter.field("latest_version_number", &self.latest_version_number);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateEnvironmentInput {
    /// <p>The application ID.</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>A name for the environment.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A description of the environment.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Amazon CloudWatch alarms to monitor during the deployment process.</p>
    pub monitors: std::option::Option<std::vec::Vec<crate::model::Monitor>>,
    /// <p>Metadata to assign to the environment. Tags help organize and categorize your AppConfig resources. Each tag consists of a key and an optional value, both of which you define.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateEnvironmentInput {
    /// <p>The application ID.</p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
    /// <p>A name for the environment.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A description of the environment.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Amazon CloudWatch alarms to monitor during the deployment process.</p>
    pub fn monitors(&self) -> std::option::Option<&[crate::model::Monitor]> {
        self.monitors.as_deref()
    }
    /// <p>Metadata to assign to the environment. Tags help organize and categorize your AppConfig resources. Each tag consists of a key and an optional value, both of which you define.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateEnvironmentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateEnvironmentInput");
        formatter.field("application_id", &self.application_id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("monitors", &self.monitors);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDeploymentStrategyInput {
    /// <p>A name for the deployment strategy.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A description of the deployment strategy.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Total amount of time for a deployment to last.</p>
    pub deployment_duration_in_minutes: std::option::Option<i32>,
    /// <p>The amount of time AppConfig monitors for alarms before considering the deployment to be complete and no longer eligible for automatic roll back.</p>
    pub final_bake_time_in_minutes: i32,
    /// <p>The percentage of targets to receive a deployed configuration during each interval.</p>
    pub growth_factor: std::option::Option<f32>,
    /// <p>The algorithm used to define how percentage grows over time. AppConfig supports the following growth types:</p>
    /// <p> <b>Linear</b>: For this type, AppConfig processes the deployment by dividing the total number of targets by the value specified for <code>Step percentage</code>. For example, a linear deployment that uses a <code>Step percentage</code> of 10 deploys the configuration to 10 percent of the hosts. After those deployments are complete, the system deploys the configuration to the next 10 percent. This continues until 100% of the targets have successfully received the configuration.</p>
    /// <p> <b>Exponential</b>: For this type, AppConfig processes the deployment exponentially using the following formula: <code>G*(2^N)</code>. In this formula, <code>G</code> is the growth factor specified by the user and <code>N</code> is the number of steps until the configuration is deployed to all targets. For example, if you specify a growth factor of 2, then the system rolls out the configuration as follows:</p>
    /// <p> <code>2*(2^0)</code> </p>
    /// <p> <code>2*(2^1)</code> </p>
    /// <p> <code>2*(2^2)</code> </p>
    /// <p>Expressed numerically, the deployment rolls out as follows: 2% of the targets, 4% of the targets, 8% of the targets, and continues until the configuration has been deployed to all targets.</p>
    pub growth_type: std::option::Option<crate::model::GrowthType>,
    /// <p>Save the deployment strategy to a Systems Manager (SSM) document.</p>
    pub replicate_to: std::option::Option<crate::model::ReplicateTo>,
    /// <p>Metadata to assign to the deployment strategy. Tags help organize and categorize your AppConfig resources. Each tag consists of a key and an optional value, both of which you define.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateDeploymentStrategyInput {
    /// <p>A name for the deployment strategy.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A description of the deployment strategy.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Total amount of time for a deployment to last.</p>
    pub fn deployment_duration_in_minutes(&self) -> std::option::Option<i32> {
        self.deployment_duration_in_minutes
    }
    /// <p>The amount of time AppConfig monitors for alarms before considering the deployment to be complete and no longer eligible for automatic roll back.</p>
    pub fn final_bake_time_in_minutes(&self) -> i32 {
        self.final_bake_time_in_minutes
    }
    /// <p>The percentage of targets to receive a deployed configuration during each interval.</p>
    pub fn growth_factor(&self) -> std::option::Option<f32> {
        self.growth_factor
    }
    /// <p>The algorithm used to define how percentage grows over time. AppConfig supports the following growth types:</p>
    /// <p> <b>Linear</b>: For this type, AppConfig processes the deployment by dividing the total number of targets by the value specified for <code>Step percentage</code>. For example, a linear deployment that uses a <code>Step percentage</code> of 10 deploys the configuration to 10 percent of the hosts. After those deployments are complete, the system deploys the configuration to the next 10 percent. This continues until 100% of the targets have successfully received the configuration.</p>
    /// <p> <b>Exponential</b>: For this type, AppConfig processes the deployment exponentially using the following formula: <code>G*(2^N)</code>. In this formula, <code>G</code> is the growth factor specified by the user and <code>N</code> is the number of steps until the configuration is deployed to all targets. For example, if you specify a growth factor of 2, then the system rolls out the configuration as follows:</p>
    /// <p> <code>2*(2^0)</code> </p>
    /// <p> <code>2*(2^1)</code> </p>
    /// <p> <code>2*(2^2)</code> </p>
    /// <p>Expressed numerically, the deployment rolls out as follows: 2% of the targets, 4% of the targets, 8% of the targets, and continues until the configuration has been deployed to all targets.</p>
    pub fn growth_type(&self) -> std::option::Option<&crate::model::GrowthType> {
        self.growth_type.as_ref()
    }
    /// <p>Save the deployment strategy to a Systems Manager (SSM) document.</p>
    pub fn replicate_to(&self) -> std::option::Option<&crate::model::ReplicateTo> {
        self.replicate_to.as_ref()
    }
    /// <p>Metadata to assign to the deployment strategy. Tags help organize and categorize your AppConfig resources. Each tag consists of a key and an optional value, both of which you define.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateDeploymentStrategyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDeploymentStrategyInput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field(
            "deployment_duration_in_minutes",
            &self.deployment_duration_in_minutes,
        );
        formatter.field(
            "final_bake_time_in_minutes",
            &self.final_bake_time_in_minutes,
        );
        formatter.field("growth_factor", &self.growth_factor);
        formatter.field("growth_type", &self.growth_type);
        formatter.field("replicate_to", &self.replicate_to);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateConfigurationProfileInput {
    /// <p>The application ID.</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>A name for the configuration profile.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A description of the configuration profile.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A URI to locate the configuration. You can specify the AppConfig hosted configuration store, Systems Manager (SSM) document, an SSM Parameter Store parameter, or an Amazon S3 object. For the hosted configuration store and for feature flags, specify <code>hosted</code>. For an SSM document, specify either the document name in the format <code>ssm-document://
    /// <document_name></document_name></code> or the Amazon Resource Name (ARN). For a parameter, specify either the parameter name in the format <code>ssm-parameter://
    /// <parameter_name></parameter_name></code> or the ARN. For an Amazon S3 object, specify the URI in the following format: <code>s3://
    /// <bucket>
    /// /
    /// <objectkey>
    /// </objectkey>
    /// </bucket></code>. Here is an example: <code>s3://my-bucket/my-app/us-east-1/my-config.json</code> </p>
    pub location_uri: std::option::Option<std::string::String>,
    /// <p>The ARN of an IAM role with permission to access the configuration at the specified <code>LocationUri</code>.</p> <important>
    /// <p>A retrieval role ARN is not required for configurations stored in the AppConfig hosted configuration store. It is required for all other sources that store your configuration. </p>
    /// </important>
    pub retrieval_role_arn: std::option::Option<std::string::String>,
    /// <p>A list of methods for validating the configuration.</p>
    pub validators: std::option::Option<std::vec::Vec<crate::model::Validator>>,
    /// <p>Metadata to assign to the configuration profile. Tags help organize and categorize your AppConfig resources. Each tag consists of a key and an optional value, both of which you define.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The type of configurations contained in the profile. AppConfig supports <code>feature flags</code> and <code>freeform</code> configurations. We recommend you create feature flag configurations to enable or disable new features and freeform configurations to distribute configurations to an application. When calling this API, enter one of the following values for <code>Type</code>:</p>
    /// <p> <code>AWS.AppConfig.FeatureFlags</code> </p>
    /// <p> <code>AWS.Freeform</code> </p>
    pub r#type: std::option::Option<std::string::String>,
}
impl CreateConfigurationProfileInput {
    /// <p>The application ID.</p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
    /// <p>A name for the configuration profile.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A description of the configuration profile.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>A URI to locate the configuration. You can specify the AppConfig hosted configuration store, Systems Manager (SSM) document, an SSM Parameter Store parameter, or an Amazon S3 object. For the hosted configuration store and for feature flags, specify <code>hosted</code>. For an SSM document, specify either the document name in the format <code>ssm-document://
    /// <document_name></document_name></code> or the Amazon Resource Name (ARN). For a parameter, specify either the parameter name in the format <code>ssm-parameter://
    /// <parameter_name></parameter_name></code> or the ARN. For an Amazon S3 object, specify the URI in the following format: <code>s3://
    /// <bucket>
    /// /
    /// <objectkey>
    /// </objectkey>
    /// </bucket></code>. Here is an example: <code>s3://my-bucket/my-app/us-east-1/my-config.json</code> </p>
    pub fn location_uri(&self) -> std::option::Option<&str> {
        self.location_uri.as_deref()
    }
    /// <p>The ARN of an IAM role with permission to access the configuration at the specified <code>LocationUri</code>.</p> <important>
    /// <p>A retrieval role ARN is not required for configurations stored in the AppConfig hosted configuration store. It is required for all other sources that store your configuration. </p>
    /// </important>
    pub fn retrieval_role_arn(&self) -> std::option::Option<&str> {
        self.retrieval_role_arn.as_deref()
    }
    /// <p>A list of methods for validating the configuration.</p>
    pub fn validators(&self) -> std::option::Option<&[crate::model::Validator]> {
        self.validators.as_deref()
    }
    /// <p>Metadata to assign to the configuration profile. Tags help organize and categorize your AppConfig resources. Each tag consists of a key and an optional value, both of which you define.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The type of configurations contained in the profile. AppConfig supports <code>feature flags</code> and <code>freeform</code> configurations. We recommend you create feature flag configurations to enable or disable new features and freeform configurations to distribute configurations to an application. When calling this API, enter one of the following values for <code>Type</code>:</p>
    /// <p> <code>AWS.AppConfig.FeatureFlags</code> </p>
    /// <p> <code>AWS.Freeform</code> </p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
}
impl std::fmt::Debug for CreateConfigurationProfileInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateConfigurationProfileInput");
        formatter.field("application_id", &self.application_id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("location_uri", &self.location_uri);
        formatter.field("retrieval_role_arn", &self.retrieval_role_arn);
        formatter.field("validators", &self.validators);
        formatter.field("tags", &self.tags);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateApplicationInput {
    /// <p>A name for the application.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A description of the application.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Metadata to assign to the application. Tags help organize and categorize your AppConfig resources. Each tag consists of a key and an optional value, both of which you define.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateApplicationInput {
    /// <p>A name for the application.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A description of the application.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Metadata to assign to the application. Tags help organize and categorize your AppConfig resources. Each tag consists of a key and an optional value, both of which you define.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateApplicationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateApplicationInput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
