// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CreateApplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateApplicationError {
    /// Kind of error that occurred.
    pub kind: CreateApplicationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateApplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateApplicationErrorKind {
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>There was an internal failure in the AppConfig service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateApplicationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateApplicationErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateApplicationErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateApplicationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateApplicationError {
    fn code(&self) -> Option<&str> {
        CreateApplicationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateApplicationError {
    /// Creates a new `CreateApplicationError`.
    pub fn new(kind: CreateApplicationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateApplicationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateApplicationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateApplicationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateApplicationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateApplicationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateApplicationErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateApplicationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateApplicationErrorKind::InternalServerException(_)
        )
    }
}
impl std::error::Error for CreateApplicationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateApplicationErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateApplicationErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateApplicationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateConfigurationProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateConfigurationProfileError {
    /// Kind of error that occurred.
    pub kind: CreateConfigurationProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateConfigurationProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateConfigurationProfileErrorKind {
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>There was an internal failure in the AppConfig service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateConfigurationProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateConfigurationProfileErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateConfigurationProfileErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateConfigurationProfileErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateConfigurationProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateConfigurationProfileError {
    fn code(&self) -> Option<&str> {
        CreateConfigurationProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateConfigurationProfileError {
    /// Creates a new `CreateConfigurationProfileError`.
    pub fn new(kind: CreateConfigurationProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateConfigurationProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateConfigurationProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateConfigurationProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateConfigurationProfileErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateConfigurationProfileErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConfigurationProfileErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateConfigurationProfileErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConfigurationProfileErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateConfigurationProfileErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConfigurationProfileErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for CreateConfigurationProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateConfigurationProfileErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateConfigurationProfileErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateConfigurationProfileErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateConfigurationProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDeploymentStrategy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDeploymentStrategyError {
    /// Kind of error that occurred.
    pub kind: CreateDeploymentStrategyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDeploymentStrategy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDeploymentStrategyErrorKind {
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>There was an internal failure in the AppConfig service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDeploymentStrategyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDeploymentStrategyErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateDeploymentStrategyErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateDeploymentStrategyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDeploymentStrategyError {
    fn code(&self) -> Option<&str> {
        CreateDeploymentStrategyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDeploymentStrategyError {
    /// Creates a new `CreateDeploymentStrategyError`.
    pub fn new(kind: CreateDeploymentStrategyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDeploymentStrategyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDeploymentStrategyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDeploymentStrategyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDeploymentStrategyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDeploymentStrategyErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDeploymentStrategyErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDeploymentStrategyErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDeploymentStrategyErrorKind::InternalServerException(_)
        )
    }
}
impl std::error::Error for CreateDeploymentStrategyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDeploymentStrategyErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateDeploymentStrategyErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateDeploymentStrategyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateEnvironment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateEnvironmentError {
    /// Kind of error that occurred.
    pub kind: CreateEnvironmentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateEnvironment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateEnvironmentErrorKind {
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>There was an internal failure in the AppConfig service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateEnvironmentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateEnvironmentErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateEnvironmentErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateEnvironmentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateEnvironmentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateEnvironmentError {
    fn code(&self) -> Option<&str> {
        CreateEnvironmentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateEnvironmentError {
    /// Creates a new `CreateEnvironmentError`.
    pub fn new(kind: CreateEnvironmentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateEnvironmentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateEnvironmentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateEnvironmentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateEnvironmentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateEnvironmentErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEnvironmentErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEnvironmentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEnvironmentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEnvironmentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEnvironmentErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for CreateEnvironmentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateEnvironmentErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateEnvironmentErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateEnvironmentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateEnvironmentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateHostedConfigurationVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateHostedConfigurationVersionError {
    /// Kind of error that occurred.
    pub kind: CreateHostedConfigurationVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateHostedConfigurationVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateHostedConfigurationVersionErrorKind {
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request could not be processed because of conflict in the current state of the resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>There was an internal failure in the AppConfig service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The configuration size is too large.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>The requested resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The number of hosted configuration versions exceeds the limit for the AppConfig hosted configuration store. Delete one or more versions and try again.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateHostedConfigurationVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateHostedConfigurationVersionErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateHostedConfigurationVersionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateHostedConfigurationVersionErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            CreateHostedConfigurationVersionErrorKind::PayloadTooLargeException(_inner) => {
                _inner.fmt(f)
            }
            CreateHostedConfigurationVersionErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            CreateHostedConfigurationVersionErrorKind::ServiceQuotaExceededException(_inner) => {
                _inner.fmt(f)
            }
            CreateHostedConfigurationVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateHostedConfigurationVersionError {
    fn code(&self) -> Option<&str> {
        CreateHostedConfigurationVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateHostedConfigurationVersionError {
    /// Creates a new `CreateHostedConfigurationVersionError`.
    pub fn new(
        kind: CreateHostedConfigurationVersionErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateHostedConfigurationVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateHostedConfigurationVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateHostedConfigurationVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateHostedConfigurationVersionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateHostedConfigurationVersionErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateHostedConfigurationVersionErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateHostedConfigurationVersionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateHostedConfigurationVersionErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateHostedConfigurationVersionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateHostedConfigurationVersionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateHostedConfigurationVersionErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateHostedConfigurationVersionErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateHostedConfigurationVersionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateHostedConfigurationVersionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateHostedConfigurationVersionErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateHostedConfigurationVersionErrorKind::ServiceQuotaExceededException(_)
        )
    }
}
impl std::error::Error for CreateHostedConfigurationVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateHostedConfigurationVersionErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateHostedConfigurationVersionErrorKind::ConflictException(_inner) => Some(_inner),
            CreateHostedConfigurationVersionErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            CreateHostedConfigurationVersionErrorKind::PayloadTooLargeException(_inner) => {
                Some(_inner)
            }
            CreateHostedConfigurationVersionErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            CreateHostedConfigurationVersionErrorKind::ServiceQuotaExceededException(_inner) => {
                Some(_inner)
            }
            CreateHostedConfigurationVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteApplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteApplicationError {
    /// Kind of error that occurred.
    pub kind: DeleteApplicationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteApplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteApplicationErrorKind {
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>There was an internal failure in the AppConfig service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteApplicationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteApplicationErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteApplicationErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteApplicationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteApplicationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteApplicationError {
    fn code(&self) -> Option<&str> {
        DeleteApplicationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteApplicationError {
    /// Creates a new `DeleteApplicationError`.
    pub fn new(kind: DeleteApplicationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteApplicationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteApplicationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteApplicationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteApplicationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteApplicationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApplicationErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteApplicationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApplicationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteApplicationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApplicationErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteApplicationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteApplicationErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteApplicationErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteApplicationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteApplicationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteConfigurationProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteConfigurationProfileError {
    /// Kind of error that occurred.
    pub kind: DeleteConfigurationProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteConfigurationProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteConfigurationProfileErrorKind {
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request could not be processed because of conflict in the current state of the resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>There was an internal failure in the AppConfig service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteConfigurationProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteConfigurationProfileErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteConfigurationProfileErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteConfigurationProfileErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteConfigurationProfileErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteConfigurationProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteConfigurationProfileError {
    fn code(&self) -> Option<&str> {
        DeleteConfigurationProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteConfigurationProfileError {
    /// Creates a new `DeleteConfigurationProfileError`.
    pub fn new(kind: DeleteConfigurationProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteConfigurationProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteConfigurationProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteConfigurationProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteConfigurationProfileErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteConfigurationProfileErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConfigurationProfileErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteConfigurationProfileErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConfigurationProfileErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteConfigurationProfileErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConfigurationProfileErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteConfigurationProfileErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConfigurationProfileErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteConfigurationProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteConfigurationProfileErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteConfigurationProfileErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteConfigurationProfileErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteConfigurationProfileErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteConfigurationProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDeploymentStrategy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDeploymentStrategyError {
    /// Kind of error that occurred.
    pub kind: DeleteDeploymentStrategyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDeploymentStrategy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDeploymentStrategyErrorKind {
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>There was an internal failure in the AppConfig service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDeploymentStrategyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDeploymentStrategyErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteDeploymentStrategyErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteDeploymentStrategyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteDeploymentStrategyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDeploymentStrategyError {
    fn code(&self) -> Option<&str> {
        DeleteDeploymentStrategyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDeploymentStrategyError {
    /// Creates a new `DeleteDeploymentStrategyError`.
    pub fn new(kind: DeleteDeploymentStrategyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDeploymentStrategyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDeploymentStrategyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDeploymentStrategyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDeploymentStrategyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDeploymentStrategyErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDeploymentStrategyErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDeploymentStrategyErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDeploymentStrategyErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDeploymentStrategyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDeploymentStrategyErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteDeploymentStrategyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDeploymentStrategyErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteDeploymentStrategyErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteDeploymentStrategyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteDeploymentStrategyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteEnvironment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteEnvironmentError {
    /// Kind of error that occurred.
    pub kind: DeleteEnvironmentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteEnvironment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteEnvironmentErrorKind {
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request could not be processed because of conflict in the current state of the resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>There was an internal failure in the AppConfig service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteEnvironmentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteEnvironmentErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteEnvironmentErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteEnvironmentErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteEnvironmentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteEnvironmentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteEnvironmentError {
    fn code(&self) -> Option<&str> {
        DeleteEnvironmentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteEnvironmentError {
    /// Creates a new `DeleteEnvironmentError`.
    pub fn new(kind: DeleteEnvironmentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteEnvironmentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteEnvironmentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteEnvironmentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteEnvironmentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteEnvironmentErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEnvironmentErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEnvironmentErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteEnvironmentErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteEnvironmentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEnvironmentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEnvironmentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEnvironmentErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteEnvironmentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteEnvironmentErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteEnvironmentErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteEnvironmentErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteEnvironmentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteEnvironmentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteHostedConfigurationVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteHostedConfigurationVersionError {
    /// Kind of error that occurred.
    pub kind: DeleteHostedConfigurationVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteHostedConfigurationVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteHostedConfigurationVersionErrorKind {
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>There was an internal failure in the AppConfig service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteHostedConfigurationVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteHostedConfigurationVersionErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteHostedConfigurationVersionErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            DeleteHostedConfigurationVersionErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeleteHostedConfigurationVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteHostedConfigurationVersionError {
    fn code(&self) -> Option<&str> {
        DeleteHostedConfigurationVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteHostedConfigurationVersionError {
    /// Creates a new `DeleteHostedConfigurationVersionError`.
    pub fn new(
        kind: DeleteHostedConfigurationVersionErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteHostedConfigurationVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteHostedConfigurationVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteHostedConfigurationVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteHostedConfigurationVersionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteHostedConfigurationVersionErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteHostedConfigurationVersionErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteHostedConfigurationVersionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteHostedConfigurationVersionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteHostedConfigurationVersionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteHostedConfigurationVersionErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteHostedConfigurationVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteHostedConfigurationVersionErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteHostedConfigurationVersionErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            DeleteHostedConfigurationVersionErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DeleteHostedConfigurationVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetApplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetApplicationError {
    /// Kind of error that occurred.
    pub kind: GetApplicationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetApplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetApplicationErrorKind {
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>There was an internal failure in the AppConfig service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetApplicationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetApplicationErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetApplicationErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetApplicationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetApplicationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetApplicationError {
    fn code(&self) -> Option<&str> {
        GetApplicationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetApplicationError {
    /// Creates a new `GetApplicationError`.
    pub fn new(kind: GetApplicationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetApplicationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetApplicationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetApplicationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetApplicationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetApplicationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetApplicationErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetApplicationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApplicationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetApplicationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApplicationErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for GetApplicationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetApplicationErrorKind::BadRequestException(_inner) => Some(_inner),
            GetApplicationErrorKind::InternalServerException(_inner) => Some(_inner),
            GetApplicationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetApplicationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetConfigurationError {
    /// Kind of error that occurred.
    pub kind: GetConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetConfigurationErrorKind {
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>There was an internal failure in the AppConfig service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetConfigurationErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetConfigurationErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetConfigurationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetConfigurationError {
    fn code(&self) -> Option<&str> {
        GetConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetConfigurationError {
    /// Creates a new `GetConfigurationError`.
    pub fn new(kind: GetConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetConfigurationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetConfigurationErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetConfigurationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetConfigurationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetConfigurationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetConfigurationErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for GetConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetConfigurationErrorKind::BadRequestException(_inner) => Some(_inner),
            GetConfigurationErrorKind::InternalServerException(_inner) => Some(_inner),
            GetConfigurationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetConfigurationProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetConfigurationProfileError {
    /// Kind of error that occurred.
    pub kind: GetConfigurationProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetConfigurationProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetConfigurationProfileErrorKind {
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>There was an internal failure in the AppConfig service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetConfigurationProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetConfigurationProfileErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetConfigurationProfileErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetConfigurationProfileErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetConfigurationProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetConfigurationProfileError {
    fn code(&self) -> Option<&str> {
        GetConfigurationProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetConfigurationProfileError {
    /// Creates a new `GetConfigurationProfileError`.
    pub fn new(kind: GetConfigurationProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetConfigurationProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetConfigurationProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetConfigurationProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetConfigurationProfileErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetConfigurationProfileErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetConfigurationProfileErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetConfigurationProfileErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetConfigurationProfileErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetConfigurationProfileErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetConfigurationProfileErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for GetConfigurationProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetConfigurationProfileErrorKind::BadRequestException(_inner) => Some(_inner),
            GetConfigurationProfileErrorKind::InternalServerException(_inner) => Some(_inner),
            GetConfigurationProfileErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetConfigurationProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDeployment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDeploymentError {
    /// Kind of error that occurred.
    pub kind: GetDeploymentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDeployment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDeploymentErrorKind {
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>There was an internal failure in the AppConfig service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDeploymentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDeploymentErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetDeploymentErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetDeploymentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetDeploymentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDeploymentError {
    fn code(&self) -> Option<&str> {
        GetDeploymentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDeploymentError {
    /// Creates a new `GetDeploymentError`.
    pub fn new(kind: GetDeploymentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDeploymentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDeploymentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDeploymentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDeploymentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetDeploymentErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetDeploymentErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetDeploymentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDeploymentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDeploymentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDeploymentErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for GetDeploymentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDeploymentErrorKind::BadRequestException(_inner) => Some(_inner),
            GetDeploymentErrorKind::InternalServerException(_inner) => Some(_inner),
            GetDeploymentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetDeploymentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDeploymentStrategy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDeploymentStrategyError {
    /// Kind of error that occurred.
    pub kind: GetDeploymentStrategyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDeploymentStrategy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDeploymentStrategyErrorKind {
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>There was an internal failure in the AppConfig service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDeploymentStrategyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDeploymentStrategyErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetDeploymentStrategyErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetDeploymentStrategyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetDeploymentStrategyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDeploymentStrategyError {
    fn code(&self) -> Option<&str> {
        GetDeploymentStrategyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDeploymentStrategyError {
    /// Creates a new `GetDeploymentStrategyError`.
    pub fn new(kind: GetDeploymentStrategyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDeploymentStrategyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDeploymentStrategyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDeploymentStrategyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDeploymentStrategyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetDeploymentStrategyErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDeploymentStrategyErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDeploymentStrategyErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDeploymentStrategyErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDeploymentStrategyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDeploymentStrategyErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for GetDeploymentStrategyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDeploymentStrategyErrorKind::BadRequestException(_inner) => Some(_inner),
            GetDeploymentStrategyErrorKind::InternalServerException(_inner) => Some(_inner),
            GetDeploymentStrategyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetDeploymentStrategyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetEnvironment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetEnvironmentError {
    /// Kind of error that occurred.
    pub kind: GetEnvironmentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetEnvironment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetEnvironmentErrorKind {
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>There was an internal failure in the AppConfig service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetEnvironmentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetEnvironmentErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetEnvironmentErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetEnvironmentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetEnvironmentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetEnvironmentError {
    fn code(&self) -> Option<&str> {
        GetEnvironmentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetEnvironmentError {
    /// Creates a new `GetEnvironmentError`.
    pub fn new(kind: GetEnvironmentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetEnvironmentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetEnvironmentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetEnvironmentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetEnvironmentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetEnvironmentErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetEnvironmentErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetEnvironmentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEnvironmentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEnvironmentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEnvironmentErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for GetEnvironmentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetEnvironmentErrorKind::BadRequestException(_inner) => Some(_inner),
            GetEnvironmentErrorKind::InternalServerException(_inner) => Some(_inner),
            GetEnvironmentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetEnvironmentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetHostedConfigurationVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetHostedConfigurationVersionError {
    /// Kind of error that occurred.
    pub kind: GetHostedConfigurationVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetHostedConfigurationVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetHostedConfigurationVersionErrorKind {
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>There was an internal failure in the AppConfig service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetHostedConfigurationVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetHostedConfigurationVersionErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetHostedConfigurationVersionErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            GetHostedConfigurationVersionErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetHostedConfigurationVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetHostedConfigurationVersionError {
    fn code(&self) -> Option<&str> {
        GetHostedConfigurationVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetHostedConfigurationVersionError {
    /// Creates a new `GetHostedConfigurationVersionError`.
    pub fn new(
        kind: GetHostedConfigurationVersionErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetHostedConfigurationVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetHostedConfigurationVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetHostedConfigurationVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetHostedConfigurationVersionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetHostedConfigurationVersionErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetHostedConfigurationVersionErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetHostedConfigurationVersionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetHostedConfigurationVersionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetHostedConfigurationVersionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetHostedConfigurationVersionErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for GetHostedConfigurationVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetHostedConfigurationVersionErrorKind::BadRequestException(_inner) => Some(_inner),
            GetHostedConfigurationVersionErrorKind::InternalServerException(_inner) => Some(_inner),
            GetHostedConfigurationVersionErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            GetHostedConfigurationVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListApplications` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListApplicationsError {
    /// Kind of error that occurred.
    pub kind: ListApplicationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListApplications` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListApplicationsErrorKind {
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>There was an internal failure in the AppConfig service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListApplicationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListApplicationsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListApplicationsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListApplicationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListApplicationsError {
    fn code(&self) -> Option<&str> {
        ListApplicationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListApplicationsError {
    /// Creates a new `ListApplicationsError`.
    pub fn new(kind: ListApplicationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListApplicationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListApplicationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListApplicationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListApplicationsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListApplicationsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListApplicationsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListApplicationsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListApplicationsErrorKind::InternalServerException(_)
        )
    }
}
impl std::error::Error for ListApplicationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListApplicationsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListApplicationsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListApplicationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListConfigurationProfiles` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListConfigurationProfilesError {
    /// Kind of error that occurred.
    pub kind: ListConfigurationProfilesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListConfigurationProfiles` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListConfigurationProfilesErrorKind {
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>There was an internal failure in the AppConfig service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListConfigurationProfilesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListConfigurationProfilesErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListConfigurationProfilesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListConfigurationProfilesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListConfigurationProfilesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListConfigurationProfilesError {
    fn code(&self) -> Option<&str> {
        ListConfigurationProfilesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListConfigurationProfilesError {
    /// Creates a new `ListConfigurationProfilesError`.
    pub fn new(kind: ListConfigurationProfilesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListConfigurationProfilesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListConfigurationProfilesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListConfigurationProfilesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListConfigurationProfilesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListConfigurationProfilesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListConfigurationProfilesErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListConfigurationProfilesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListConfigurationProfilesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListConfigurationProfilesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListConfigurationProfilesErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListConfigurationProfilesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListConfigurationProfilesErrorKind::BadRequestException(_inner) => Some(_inner),
            ListConfigurationProfilesErrorKind::InternalServerException(_inner) => Some(_inner),
            ListConfigurationProfilesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListConfigurationProfilesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDeployments` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDeploymentsError {
    /// Kind of error that occurred.
    pub kind: ListDeploymentsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDeployments` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDeploymentsErrorKind {
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>There was an internal failure in the AppConfig service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDeploymentsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDeploymentsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListDeploymentsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListDeploymentsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListDeploymentsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDeploymentsError {
    fn code(&self) -> Option<&str> {
        ListDeploymentsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDeploymentsError {
    /// Creates a new `ListDeploymentsError`.
    pub fn new(kind: ListDeploymentsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDeploymentsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDeploymentsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDeploymentsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDeploymentsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDeploymentsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ListDeploymentsErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `ListDeploymentsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDeploymentsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDeploymentsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDeploymentsErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListDeploymentsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDeploymentsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListDeploymentsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListDeploymentsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListDeploymentsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDeploymentStrategies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDeploymentStrategiesError {
    /// Kind of error that occurred.
    pub kind: ListDeploymentStrategiesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDeploymentStrategies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDeploymentStrategiesErrorKind {
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>There was an internal failure in the AppConfig service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDeploymentStrategiesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDeploymentStrategiesErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListDeploymentStrategiesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListDeploymentStrategiesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDeploymentStrategiesError {
    fn code(&self) -> Option<&str> {
        ListDeploymentStrategiesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDeploymentStrategiesError {
    /// Creates a new `ListDeploymentStrategiesError`.
    pub fn new(kind: ListDeploymentStrategiesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDeploymentStrategiesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDeploymentStrategiesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDeploymentStrategiesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDeploymentStrategiesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDeploymentStrategiesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDeploymentStrategiesErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDeploymentStrategiesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDeploymentStrategiesErrorKind::InternalServerException(_)
        )
    }
}
impl std::error::Error for ListDeploymentStrategiesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDeploymentStrategiesErrorKind::BadRequestException(_inner) => Some(_inner),
            ListDeploymentStrategiesErrorKind::InternalServerException(_inner) => Some(_inner),
            ListDeploymentStrategiesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListEnvironments` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListEnvironmentsError {
    /// Kind of error that occurred.
    pub kind: ListEnvironmentsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListEnvironments` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListEnvironmentsErrorKind {
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>There was an internal failure in the AppConfig service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListEnvironmentsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListEnvironmentsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListEnvironmentsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListEnvironmentsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListEnvironmentsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListEnvironmentsError {
    fn code(&self) -> Option<&str> {
        ListEnvironmentsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListEnvironmentsError {
    /// Creates a new `ListEnvironmentsError`.
    pub fn new(kind: ListEnvironmentsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListEnvironmentsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListEnvironmentsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListEnvironmentsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListEnvironmentsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListEnvironmentsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEnvironmentsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEnvironmentsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEnvironmentsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEnvironmentsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEnvironmentsErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListEnvironmentsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListEnvironmentsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListEnvironmentsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListEnvironmentsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListEnvironmentsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListHostedConfigurationVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListHostedConfigurationVersionsError {
    /// Kind of error that occurred.
    pub kind: ListHostedConfigurationVersionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListHostedConfigurationVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListHostedConfigurationVersionsErrorKind {
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>There was an internal failure in the AppConfig service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListHostedConfigurationVersionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListHostedConfigurationVersionsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListHostedConfigurationVersionsErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            ListHostedConfigurationVersionsErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ListHostedConfigurationVersionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListHostedConfigurationVersionsError {
    fn code(&self) -> Option<&str> {
        ListHostedConfigurationVersionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListHostedConfigurationVersionsError {
    /// Creates a new `ListHostedConfigurationVersionsError`.
    pub fn new(
        kind: ListHostedConfigurationVersionsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListHostedConfigurationVersionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListHostedConfigurationVersionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListHostedConfigurationVersionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListHostedConfigurationVersionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListHostedConfigurationVersionsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListHostedConfigurationVersionsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListHostedConfigurationVersionsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListHostedConfigurationVersionsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListHostedConfigurationVersionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListHostedConfigurationVersionsErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListHostedConfigurationVersionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListHostedConfigurationVersionsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListHostedConfigurationVersionsErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            ListHostedConfigurationVersionsErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            ListHostedConfigurationVersionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>There was an internal failure in the AppConfig service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::BadRequestException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartDeployment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartDeploymentError {
    /// Kind of error that occurred.
    pub kind: StartDeploymentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartDeployment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartDeploymentErrorKind {
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request could not be processed because of conflict in the current state of the resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>There was an internal failure in the AppConfig service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartDeploymentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartDeploymentErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            StartDeploymentErrorKind::ConflictException(_inner) => _inner.fmt(f),
            StartDeploymentErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            StartDeploymentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StartDeploymentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartDeploymentError {
    fn code(&self) -> Option<&str> {
        StartDeploymentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartDeploymentError {
    /// Creates a new `StartDeploymentError`.
    pub fn new(kind: StartDeploymentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartDeploymentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartDeploymentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartDeploymentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartDeploymentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartDeploymentErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, StartDeploymentErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `StartDeploymentErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, StartDeploymentErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `StartDeploymentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartDeploymentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `StartDeploymentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartDeploymentErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for StartDeploymentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartDeploymentErrorKind::BadRequestException(_inner) => Some(_inner),
            StartDeploymentErrorKind::ConflictException(_inner) => Some(_inner),
            StartDeploymentErrorKind::InternalServerException(_inner) => Some(_inner),
            StartDeploymentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StartDeploymentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopDeployment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopDeploymentError {
    /// Kind of error that occurred.
    pub kind: StopDeploymentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopDeployment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopDeploymentErrorKind {
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>There was an internal failure in the AppConfig service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopDeploymentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopDeploymentErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            StopDeploymentErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            StopDeploymentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StopDeploymentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopDeploymentError {
    fn code(&self) -> Option<&str> {
        StopDeploymentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopDeploymentError {
    /// Creates a new `StopDeploymentError`.
    pub fn new(kind: StopDeploymentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopDeploymentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopDeploymentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopDeploymentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopDeploymentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StopDeploymentErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, StopDeploymentErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `StopDeploymentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopDeploymentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `StopDeploymentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopDeploymentErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for StopDeploymentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopDeploymentErrorKind::BadRequestException(_inner) => Some(_inner),
            StopDeploymentErrorKind::InternalServerException(_inner) => Some(_inner),
            StopDeploymentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StopDeploymentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>There was an internal failure in the AppConfig service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::BadRequestException(_inner) => Some(_inner),
            TagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>There was an internal failure in the AppConfig service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::BadRequestException(_inner) => Some(_inner),
            UntagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateApplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateApplicationError {
    /// Kind of error that occurred.
    pub kind: UpdateApplicationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateApplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateApplicationErrorKind {
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>There was an internal failure in the AppConfig service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateApplicationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateApplicationErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateApplicationErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateApplicationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateApplicationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateApplicationError {
    fn code(&self) -> Option<&str> {
        UpdateApplicationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateApplicationError {
    /// Creates a new `UpdateApplicationError`.
    pub fn new(kind: UpdateApplicationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateApplicationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateApplicationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateApplicationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateApplicationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateApplicationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApplicationErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateApplicationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApplicationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateApplicationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApplicationErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateApplicationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateApplicationErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateApplicationErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateApplicationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateApplicationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateConfigurationProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateConfigurationProfileError {
    /// Kind of error that occurred.
    pub kind: UpdateConfigurationProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateConfigurationProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateConfigurationProfileErrorKind {
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>There was an internal failure in the AppConfig service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateConfigurationProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateConfigurationProfileErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateConfigurationProfileErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateConfigurationProfileErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateConfigurationProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateConfigurationProfileError {
    fn code(&self) -> Option<&str> {
        UpdateConfigurationProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateConfigurationProfileError {
    /// Creates a new `UpdateConfigurationProfileError`.
    pub fn new(kind: UpdateConfigurationProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateConfigurationProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateConfigurationProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateConfigurationProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateConfigurationProfileErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateConfigurationProfileErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConfigurationProfileErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateConfigurationProfileErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConfigurationProfileErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateConfigurationProfileErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConfigurationProfileErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateConfigurationProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateConfigurationProfileErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateConfigurationProfileErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateConfigurationProfileErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateConfigurationProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateDeploymentStrategy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateDeploymentStrategyError {
    /// Kind of error that occurred.
    pub kind: UpdateDeploymentStrategyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateDeploymentStrategy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateDeploymentStrategyErrorKind {
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>There was an internal failure in the AppConfig service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateDeploymentStrategyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateDeploymentStrategyErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateDeploymentStrategyErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateDeploymentStrategyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateDeploymentStrategyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateDeploymentStrategyError {
    fn code(&self) -> Option<&str> {
        UpdateDeploymentStrategyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateDeploymentStrategyError {
    /// Creates a new `UpdateDeploymentStrategyError`.
    pub fn new(kind: UpdateDeploymentStrategyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateDeploymentStrategyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateDeploymentStrategyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateDeploymentStrategyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateDeploymentStrategyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateDeploymentStrategyErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDeploymentStrategyErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDeploymentStrategyErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDeploymentStrategyErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDeploymentStrategyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDeploymentStrategyErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateDeploymentStrategyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateDeploymentStrategyErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateDeploymentStrategyErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateDeploymentStrategyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateDeploymentStrategyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateEnvironment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateEnvironmentError {
    /// Kind of error that occurred.
    pub kind: UpdateEnvironmentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateEnvironment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateEnvironmentErrorKind {
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>There was an internal failure in the AppConfig service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateEnvironmentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateEnvironmentErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateEnvironmentErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateEnvironmentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateEnvironmentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateEnvironmentError {
    fn code(&self) -> Option<&str> {
        UpdateEnvironmentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateEnvironmentError {
    /// Creates a new `UpdateEnvironmentError`.
    pub fn new(kind: UpdateEnvironmentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateEnvironmentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateEnvironmentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateEnvironmentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateEnvironmentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateEnvironmentErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEnvironmentErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEnvironmentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEnvironmentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEnvironmentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEnvironmentErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateEnvironmentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateEnvironmentErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateEnvironmentErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateEnvironmentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateEnvironmentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ValidateConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ValidateConfigurationError {
    /// Kind of error that occurred.
    pub kind: ValidateConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ValidateConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ValidateConfigurationErrorKind {
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>There was an internal failure in the AppConfig service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ValidateConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ValidateConfigurationErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ValidateConfigurationErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ValidateConfigurationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ValidateConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ValidateConfigurationError {
    fn code(&self) -> Option<&str> {
        ValidateConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ValidateConfigurationError {
    /// Creates a new `ValidateConfigurationError`.
    pub fn new(kind: ValidateConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ValidateConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ValidateConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ValidateConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ValidateConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ValidateConfigurationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ValidateConfigurationErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ValidateConfigurationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ValidateConfigurationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ValidateConfigurationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ValidateConfigurationErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ValidateConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ValidateConfigurationErrorKind::BadRequestException(_inner) => Some(_inner),
            ValidateConfigurationErrorKind::InternalServerException(_inner) => Some(_inner),
            ValidateConfigurationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ValidateConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The requested resource could not be found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub resource_name: std::option::Option<std::string::String>,
}
impl ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn resource_name(&self) -> std::option::Option<&str> {
        self.resource_name.as_deref()
    }
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.field("resource_name", &self.resource_name);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
                resource_name: self.resource_name,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>There was an internal failure in the AppConfig service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServerException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerException {}
/// See [`InternalServerException`](crate::error::InternalServerException)
pub mod internal_server_exception {
    /// A builder for [`InternalServerException`](crate::error::InternalServerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerException`](crate::error::InternalServerException)
        pub fn build(self) -> crate::error::InternalServerException {
            crate::error::InternalServerException {
                message: self.message,
            }
        }
    }
}
impl InternalServerException {
    /// Creates a new builder-style object to manufacture [`InternalServerException`](crate::error::InternalServerException)
    pub fn builder() -> crate::error::internal_server_exception::Builder {
        crate::error::internal_server_exception::Builder::default()
    }
}

/// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BadRequestException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub reason: std::option::Option<crate::model::BadRequestReason>,
    /// <p>Detailed information about the input that failed to satisfy the constraints specified by an AWS service.</p>
    pub details: std::option::Option<crate::model::BadRequestDetails>,
}
impl BadRequestException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn reason(&self) -> std::option::Option<&crate::model::BadRequestReason> {
        self.reason.as_ref()
    }
    /// <p>Detailed information about the input that failed to satisfy the constraints specified by an AWS service.</p>
    pub fn details(&self) -> std::option::Option<&crate::model::BadRequestDetails> {
        self.details.as_ref()
    }
}
impl std::fmt::Debug for BadRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BadRequestException");
        formatter.field("message", &self.message);
        formatter.field("reason", &self.reason);
        formatter.field("details", &self.details);
        formatter.finish()
    }
}
impl BadRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for BadRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "BadRequestException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for BadRequestException {}
/// See [`BadRequestException`](crate::error::BadRequestException)
pub mod bad_request_exception {
    /// A builder for [`BadRequestException`](crate::error::BadRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<crate::model::BadRequestReason>,
        pub(crate) details: std::option::Option<crate::model::BadRequestDetails>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn reason(mut self, input: crate::model::BadRequestReason) -> Self {
            self.reason = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_reason(
            mut self,
            input: std::option::Option<crate::model::BadRequestReason>,
        ) -> Self {
            self.reason = input;
            self
        }
        /// <p>Detailed information about the input that failed to satisfy the constraints specified by an AWS service.</p>
        pub fn details(mut self, input: crate::model::BadRequestDetails) -> Self {
            self.details = Some(input);
            self
        }
        /// <p>Detailed information about the input that failed to satisfy the constraints specified by an AWS service.</p>
        pub fn set_details(
            mut self,
            input: std::option::Option<crate::model::BadRequestDetails>,
        ) -> Self {
            self.details = input;
            self
        }
        /// Consumes the builder and constructs a [`BadRequestException`](crate::error::BadRequestException)
        pub fn build(self) -> crate::error::BadRequestException {
            crate::error::BadRequestException {
                message: self.message,
                reason: self.reason,
                details: self.details,
            }
        }
    }
}
impl BadRequestException {
    /// Creates a new builder-style object to manufacture [`BadRequestException`](crate::error::BadRequestException)
    pub fn builder() -> crate::error::bad_request_exception::Builder {
        crate::error::bad_request_exception::Builder::default()
    }
}

/// <p>The request could not be processed because of conflict in the current state of the resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

/// <p>The number of hosted configuration versions exceeds the limit for the AppConfig hosted configuration store. Delete one or more versions and try again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceQuotaExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceQuotaExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceQuotaExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceQuotaExceededException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceQuotaExceededException {}
/// See [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
pub mod service_quota_exceeded_exception {
    /// A builder for [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
        pub fn build(self) -> crate::error::ServiceQuotaExceededException {
            crate::error::ServiceQuotaExceededException {
                message: self.message,
            }
        }
    }
}
impl ServiceQuotaExceededException {
    /// Creates a new builder-style object to manufacture [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    pub fn builder() -> crate::error::service_quota_exceeded_exception::Builder {
        crate::error::service_quota_exceeded_exception::Builder::default()
    }
}

/// <p>The configuration size is too large.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PayloadTooLargeException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub measure: std::option::Option<crate::model::BytesMeasure>,
    #[allow(missing_docs)] // documentation missing in model
    pub limit: f32,
    #[allow(missing_docs)] // documentation missing in model
    pub size: f32,
}
impl PayloadTooLargeException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn measure(&self) -> std::option::Option<&crate::model::BytesMeasure> {
        self.measure.as_ref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn limit(&self) -> f32 {
        self.limit
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn size(&self) -> f32 {
        self.size
    }
}
impl std::fmt::Debug for PayloadTooLargeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PayloadTooLargeException");
        formatter.field("message", &self.message);
        formatter.field("measure", &self.measure);
        formatter.field("limit", &self.limit);
        formatter.field("size", &self.size);
        formatter.finish()
    }
}
impl PayloadTooLargeException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for PayloadTooLargeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "PayloadTooLargeException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for PayloadTooLargeException {}
/// See [`PayloadTooLargeException`](crate::error::PayloadTooLargeException)
pub mod payload_too_large_exception {
    /// A builder for [`PayloadTooLargeException`](crate::error::PayloadTooLargeException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) measure: std::option::Option<crate::model::BytesMeasure>,
        pub(crate) limit: std::option::Option<f32>,
        pub(crate) size: std::option::Option<f32>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn measure(mut self, input: crate::model::BytesMeasure) -> Self {
            self.measure = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_measure(
            mut self,
            input: std::option::Option<crate::model::BytesMeasure>,
        ) -> Self {
            self.measure = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn limit(mut self, input: f32) -> Self {
            self.limit = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_limit(mut self, input: std::option::Option<f32>) -> Self {
            self.limit = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn size(mut self, input: f32) -> Self {
            self.size = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_size(mut self, input: std::option::Option<f32>) -> Self {
            self.size = input;
            self
        }
        /// Consumes the builder and constructs a [`PayloadTooLargeException`](crate::error::PayloadTooLargeException)
        pub fn build(self) -> crate::error::PayloadTooLargeException {
            crate::error::PayloadTooLargeException {
                message: self.message,
                measure: self.measure,
                limit: self.limit.unwrap_or_default(),
                size: self.size.unwrap_or_default(),
            }
        }
    }
}
impl PayloadTooLargeException {
    /// Creates a new builder-style object to manufacture [`PayloadTooLargeException`](crate::error::PayloadTooLargeException)
    pub fn builder() -> crate::error::payload_too_large_exception::Builder {
        crate::error::payload_too_large_exception::Builder::default()
    }
}
