// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidateConfigurationOutput {}
impl std::fmt::Debug for ValidateConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidateConfigurationOutput");
        formatter.finish()
    }
}
/// See [`ValidateConfigurationOutput`](crate::output::ValidateConfigurationOutput)
pub mod validate_configuration_output {
    /// A builder for [`ValidateConfigurationOutput`](crate::output::ValidateConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`ValidateConfigurationOutput`](crate::output::ValidateConfigurationOutput)
        pub fn build(self) -> crate::output::ValidateConfigurationOutput {
            crate::output::ValidateConfigurationOutput {}
        }
    }
}
impl ValidateConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`ValidateConfigurationOutput`](crate::output::ValidateConfigurationOutput)
    pub fn builder() -> crate::output::validate_configuration_output::Builder {
        crate::output::validate_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateEnvironmentOutput {
    /// <p>The application ID.</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The environment ID.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the environment.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the environment.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The state of the environment. An environment can be in one of the following states:
    /// <code>READY_FOR_DEPLOYMENT</code>, <code>DEPLOYING</code>, <code>ROLLING_BACK</code>, or
    /// <code>ROLLED_BACK</code>
    /// </p>
    pub state: std::option::Option<crate::model::EnvironmentState>,
    /// <p>Amazon CloudWatch alarms monitored during the deployment.</p>
    pub monitors: std::option::Option<std::vec::Vec<crate::model::Monitor>>,
}
impl std::fmt::Debug for UpdateEnvironmentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateEnvironmentOutput");
        formatter.field("application_id", &self.application_id);
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("state", &self.state);
        formatter.field("monitors", &self.monitors);
        formatter.finish()
    }
}
/// See [`UpdateEnvironmentOutput`](crate::output::UpdateEnvironmentOutput)
pub mod update_environment_output {
    /// A builder for [`UpdateEnvironmentOutput`](crate::output::UpdateEnvironmentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::EnvironmentState>,
        pub(crate) monitors: std::option::Option<std::vec::Vec<crate::model::Monitor>>,
    }
    impl Builder {
        /// <p>The application ID.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The application ID.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The environment ID.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The environment ID.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the environment.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the environment.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the environment.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the environment.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The state of the environment. An environment can be in one of the following states:
        /// <code>READY_FOR_DEPLOYMENT</code>, <code>DEPLOYING</code>, <code>ROLLING_BACK</code>, or
        /// <code>ROLLED_BACK</code>
        /// </p>
        pub fn state(mut self, input: crate::model::EnvironmentState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the environment. An environment can be in one of the following states:
        /// <code>READY_FOR_DEPLOYMENT</code>, <code>DEPLOYING</code>, <code>ROLLING_BACK</code>, or
        /// <code>ROLLED_BACK</code>
        /// </p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::EnvironmentState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Appends an item to `monitors`.
        ///
        /// To override the contents of this collection use [`set_monitors`](Self::set_monitors).
        ///
        /// <p>Amazon CloudWatch alarms monitored during the deployment.</p>
        pub fn monitors(mut self, input: impl Into<crate::model::Monitor>) -> Self {
            let mut v = self.monitors.unwrap_or_default();
            v.push(input.into());
            self.monitors = Some(v);
            self
        }
        /// <p>Amazon CloudWatch alarms monitored during the deployment.</p>
        pub fn set_monitors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Monitor>>,
        ) -> Self {
            self.monitors = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateEnvironmentOutput`](crate::output::UpdateEnvironmentOutput)
        pub fn build(self) -> crate::output::UpdateEnvironmentOutput {
            crate::output::UpdateEnvironmentOutput {
                application_id: self.application_id,
                id: self.id,
                name: self.name,
                description: self.description,
                state: self.state,
                monitors: self.monitors,
            }
        }
    }
}
impl UpdateEnvironmentOutput {
    /// Creates a new builder-style object to manufacture [`UpdateEnvironmentOutput`](crate::output::UpdateEnvironmentOutput)
    pub fn builder() -> crate::output::update_environment_output::Builder {
        crate::output::update_environment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDeploymentStrategyOutput {
    /// <p>The deployment strategy ID.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the deployment strategy.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the deployment strategy.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Total amount of time the deployment lasted.</p>
    pub deployment_duration_in_minutes: i32,
    /// <p>The algorithm used to define how percentage grew over time.</p>
    pub growth_type: std::option::Option<crate::model::GrowthType>,
    /// <p>The percentage of targets that received a deployed configuration during each
    /// interval.</p>
    pub growth_factor: f32,
    /// <p>The amount of time AppConfig monitored for alarms before considering the deployment to be
    /// complete and no longer eligible for automatic roll back.</p>
    pub final_bake_time_in_minutes: i32,
    /// <p>Save the deployment strategy to a Systems Manager (SSM) document.</p>
    pub replicate_to: std::option::Option<crate::model::ReplicateTo>,
}
impl std::fmt::Debug for UpdateDeploymentStrategyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDeploymentStrategyOutput");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field(
            "deployment_duration_in_minutes",
            &self.deployment_duration_in_minutes,
        );
        formatter.field("growth_type", &self.growth_type);
        formatter.field("growth_factor", &self.growth_factor);
        formatter.field(
            "final_bake_time_in_minutes",
            &self.final_bake_time_in_minutes,
        );
        formatter.field("replicate_to", &self.replicate_to);
        formatter.finish()
    }
}
/// See [`UpdateDeploymentStrategyOutput`](crate::output::UpdateDeploymentStrategyOutput)
pub mod update_deployment_strategy_output {
    /// A builder for [`UpdateDeploymentStrategyOutput`](crate::output::UpdateDeploymentStrategyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) deployment_duration_in_minutes: std::option::Option<i32>,
        pub(crate) growth_type: std::option::Option<crate::model::GrowthType>,
        pub(crate) growth_factor: std::option::Option<f32>,
        pub(crate) final_bake_time_in_minutes: std::option::Option<i32>,
        pub(crate) replicate_to: std::option::Option<crate::model::ReplicateTo>,
    }
    impl Builder {
        /// <p>The deployment strategy ID.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The deployment strategy ID.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the deployment strategy.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the deployment strategy.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the deployment strategy.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the deployment strategy.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Total amount of time the deployment lasted.</p>
        pub fn deployment_duration_in_minutes(mut self, input: i32) -> Self {
            self.deployment_duration_in_minutes = Some(input);
            self
        }
        /// <p>Total amount of time the deployment lasted.</p>
        pub fn set_deployment_duration_in_minutes(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.deployment_duration_in_minutes = input;
            self
        }
        /// <p>The algorithm used to define how percentage grew over time.</p>
        pub fn growth_type(mut self, input: crate::model::GrowthType) -> Self {
            self.growth_type = Some(input);
            self
        }
        /// <p>The algorithm used to define how percentage grew over time.</p>
        pub fn set_growth_type(
            mut self,
            input: std::option::Option<crate::model::GrowthType>,
        ) -> Self {
            self.growth_type = input;
            self
        }
        /// <p>The percentage of targets that received a deployed configuration during each
        /// interval.</p>
        pub fn growth_factor(mut self, input: f32) -> Self {
            self.growth_factor = Some(input);
            self
        }
        /// <p>The percentage of targets that received a deployed configuration during each
        /// interval.</p>
        pub fn set_growth_factor(mut self, input: std::option::Option<f32>) -> Self {
            self.growth_factor = input;
            self
        }
        /// <p>The amount of time AppConfig monitored for alarms before considering the deployment to be
        /// complete and no longer eligible for automatic roll back.</p>
        pub fn final_bake_time_in_minutes(mut self, input: i32) -> Self {
            self.final_bake_time_in_minutes = Some(input);
            self
        }
        /// <p>The amount of time AppConfig monitored for alarms before considering the deployment to be
        /// complete and no longer eligible for automatic roll back.</p>
        pub fn set_final_bake_time_in_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.final_bake_time_in_minutes = input;
            self
        }
        /// <p>Save the deployment strategy to a Systems Manager (SSM) document.</p>
        pub fn replicate_to(mut self, input: crate::model::ReplicateTo) -> Self {
            self.replicate_to = Some(input);
            self
        }
        /// <p>Save the deployment strategy to a Systems Manager (SSM) document.</p>
        pub fn set_replicate_to(
            mut self,
            input: std::option::Option<crate::model::ReplicateTo>,
        ) -> Self {
            self.replicate_to = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDeploymentStrategyOutput`](crate::output::UpdateDeploymentStrategyOutput)
        pub fn build(self) -> crate::output::UpdateDeploymentStrategyOutput {
            crate::output::UpdateDeploymentStrategyOutput {
                id: self.id,
                name: self.name,
                description: self.description,
                deployment_duration_in_minutes: self
                    .deployment_duration_in_minutes
                    .unwrap_or_default(),
                growth_type: self.growth_type,
                growth_factor: self.growth_factor.unwrap_or_default(),
                final_bake_time_in_minutes: self.final_bake_time_in_minutes.unwrap_or_default(),
                replicate_to: self.replicate_to,
            }
        }
    }
}
impl UpdateDeploymentStrategyOutput {
    /// Creates a new builder-style object to manufacture [`UpdateDeploymentStrategyOutput`](crate::output::UpdateDeploymentStrategyOutput)
    pub fn builder() -> crate::output::update_deployment_strategy_output::Builder {
        crate::output::update_deployment_strategy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateConfigurationProfileOutput {
    /// <p>The application ID.</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The configuration profile ID.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the configuration profile.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The configuration profile description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The URI location of the configuration.</p>
    pub location_uri: std::option::Option<std::string::String>,
    /// <p>The ARN of an IAM role with permission to access the configuration at the specified
    /// LocationUri.</p>
    pub retrieval_role_arn: std::option::Option<std::string::String>,
    /// <p>A list of methods for validating the configuration.</p>
    pub validators: std::option::Option<std::vec::Vec<crate::model::Validator>>,
}
impl std::fmt::Debug for UpdateConfigurationProfileOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateConfigurationProfileOutput");
        formatter.field("application_id", &self.application_id);
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("location_uri", &self.location_uri);
        formatter.field("retrieval_role_arn", &self.retrieval_role_arn);
        formatter.field("validators", &self.validators);
        formatter.finish()
    }
}
/// See [`UpdateConfigurationProfileOutput`](crate::output::UpdateConfigurationProfileOutput)
pub mod update_configuration_profile_output {
    /// A builder for [`UpdateConfigurationProfileOutput`](crate::output::UpdateConfigurationProfileOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) location_uri: std::option::Option<std::string::String>,
        pub(crate) retrieval_role_arn: std::option::Option<std::string::String>,
        pub(crate) validators: std::option::Option<std::vec::Vec<crate::model::Validator>>,
    }
    impl Builder {
        /// <p>The application ID.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The application ID.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The configuration profile ID.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The configuration profile ID.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the configuration profile.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the configuration profile.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The configuration profile description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The configuration profile description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The URI location of the configuration.</p>
        pub fn location_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.location_uri = Some(input.into());
            self
        }
        /// <p>The URI location of the configuration.</p>
        pub fn set_location_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location_uri = input;
            self
        }
        /// <p>The ARN of an IAM role with permission to access the configuration at the specified
        /// LocationUri.</p>
        pub fn retrieval_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.retrieval_role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of an IAM role with permission to access the configuration at the specified
        /// LocationUri.</p>
        pub fn set_retrieval_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.retrieval_role_arn = input;
            self
        }
        /// Appends an item to `validators`.
        ///
        /// To override the contents of this collection use [`set_validators`](Self::set_validators).
        ///
        /// <p>A list of methods for validating the configuration.</p>
        pub fn validators(mut self, input: impl Into<crate::model::Validator>) -> Self {
            let mut v = self.validators.unwrap_or_default();
            v.push(input.into());
            self.validators = Some(v);
            self
        }
        /// <p>A list of methods for validating the configuration.</p>
        pub fn set_validators(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Validator>>,
        ) -> Self {
            self.validators = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateConfigurationProfileOutput`](crate::output::UpdateConfigurationProfileOutput)
        pub fn build(self) -> crate::output::UpdateConfigurationProfileOutput {
            crate::output::UpdateConfigurationProfileOutput {
                application_id: self.application_id,
                id: self.id,
                name: self.name,
                description: self.description,
                location_uri: self.location_uri,
                retrieval_role_arn: self.retrieval_role_arn,
                validators: self.validators,
            }
        }
    }
}
impl UpdateConfigurationProfileOutput {
    /// Creates a new builder-style object to manufacture [`UpdateConfigurationProfileOutput`](crate::output::UpdateConfigurationProfileOutput)
    pub fn builder() -> crate::output::update_configuration_profile_output::Builder {
        crate::output::update_configuration_profile_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateApplicationOutput {
    /// <p>The application ID.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The application name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the application.</p>
    pub description: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateApplicationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateApplicationOutput");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`UpdateApplicationOutput`](crate::output::UpdateApplicationOutput)
pub mod update_application_output {
    /// A builder for [`UpdateApplicationOutput`](crate::output::UpdateApplicationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The application ID.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The application ID.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The application name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The application name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the application.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the application.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateApplicationOutput`](crate::output::UpdateApplicationOutput)
        pub fn build(self) -> crate::output::UpdateApplicationOutput {
            crate::output::UpdateApplicationOutput {
                id: self.id,
                name: self.name,
                description: self.description,
            }
        }
    }
}
impl UpdateApplicationOutput {
    /// Creates a new builder-style object to manufacture [`UpdateApplicationOutput`](crate::output::UpdateApplicationOutput)
    pub fn builder() -> crate::output::update_application_output::Builder {
        crate::output::update_application_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopDeploymentOutput {
    /// <p>The ID of the application that was deployed.</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The ID of the environment that was deployed.</p>
    pub environment_id: std::option::Option<std::string::String>,
    /// <p>The ID of the deployment strategy that was deployed.</p>
    pub deployment_strategy_id: std::option::Option<std::string::String>,
    /// <p>The ID of the configuration profile that was deployed.</p>
    pub configuration_profile_id: std::option::Option<std::string::String>,
    /// <p>The sequence number of the deployment.</p>
    pub deployment_number: i32,
    /// <p>The name of the configuration.</p>
    pub configuration_name: std::option::Option<std::string::String>,
    /// <p>Information about the source location of the configuration.</p>
    pub configuration_location_uri: std::option::Option<std::string::String>,
    /// <p>The configuration version that was deployed.</p>
    pub configuration_version: std::option::Option<std::string::String>,
    /// <p>The description of the deployment.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Total amount of time the deployment lasted.</p>
    pub deployment_duration_in_minutes: i32,
    /// <p>The algorithm used to define how percentage grew over time.</p>
    pub growth_type: std::option::Option<crate::model::GrowthType>,
    /// <p>The percentage of targets to receive a deployed configuration during each
    /// interval.</p>
    pub growth_factor: f32,
    /// <p>The amount of time AppConfig monitored for alarms before considering the deployment to be
    /// complete and no longer eligible for automatic roll back.</p>
    pub final_bake_time_in_minutes: i32,
    /// <p>The state of the deployment.</p>
    pub state: std::option::Option<crate::model::DeploymentState>,
    /// <p>A list containing all events related to a deployment. The most recent events are
    /// displayed first.</p>
    pub event_log: std::option::Option<std::vec::Vec<crate::model::DeploymentEvent>>,
    /// <p>The percentage of targets for which the deployment is available.</p>
    pub percentage_complete: f32,
    /// <p>The time the deployment started.</p>
    pub started_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time the deployment completed. </p>
    pub completed_at: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for StopDeploymentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopDeploymentOutput");
        formatter.field("application_id", &self.application_id);
        formatter.field("environment_id", &self.environment_id);
        formatter.field("deployment_strategy_id", &self.deployment_strategy_id);
        formatter.field("configuration_profile_id", &self.configuration_profile_id);
        formatter.field("deployment_number", &self.deployment_number);
        formatter.field("configuration_name", &self.configuration_name);
        formatter.field(
            "configuration_location_uri",
            &self.configuration_location_uri,
        );
        formatter.field("configuration_version", &self.configuration_version);
        formatter.field("description", &self.description);
        formatter.field(
            "deployment_duration_in_minutes",
            &self.deployment_duration_in_minutes,
        );
        formatter.field("growth_type", &self.growth_type);
        formatter.field("growth_factor", &self.growth_factor);
        formatter.field(
            "final_bake_time_in_minutes",
            &self.final_bake_time_in_minutes,
        );
        formatter.field("state", &self.state);
        formatter.field("event_log", &self.event_log);
        formatter.field("percentage_complete", &self.percentage_complete);
        formatter.field("started_at", &self.started_at);
        formatter.field("completed_at", &self.completed_at);
        formatter.finish()
    }
}
/// See [`StopDeploymentOutput`](crate::output::StopDeploymentOutput)
pub mod stop_deployment_output {
    /// A builder for [`StopDeploymentOutput`](crate::output::StopDeploymentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) environment_id: std::option::Option<std::string::String>,
        pub(crate) deployment_strategy_id: std::option::Option<std::string::String>,
        pub(crate) configuration_profile_id: std::option::Option<std::string::String>,
        pub(crate) deployment_number: std::option::Option<i32>,
        pub(crate) configuration_name: std::option::Option<std::string::String>,
        pub(crate) configuration_location_uri: std::option::Option<std::string::String>,
        pub(crate) configuration_version: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) deployment_duration_in_minutes: std::option::Option<i32>,
        pub(crate) growth_type: std::option::Option<crate::model::GrowthType>,
        pub(crate) growth_factor: std::option::Option<f32>,
        pub(crate) final_bake_time_in_minutes: std::option::Option<i32>,
        pub(crate) state: std::option::Option<crate::model::DeploymentState>,
        pub(crate) event_log: std::option::Option<std::vec::Vec<crate::model::DeploymentEvent>>,
        pub(crate) percentage_complete: std::option::Option<f32>,
        pub(crate) started_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) completed_at: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The ID of the application that was deployed.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The ID of the application that was deployed.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The ID of the environment that was deployed.</p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_id = Some(input.into());
            self
        }
        /// <p>The ID of the environment that was deployed.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_id = input;
            self
        }
        /// <p>The ID of the deployment strategy that was deployed.</p>
        pub fn deployment_strategy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_strategy_id = Some(input.into());
            self
        }
        /// <p>The ID of the deployment strategy that was deployed.</p>
        pub fn set_deployment_strategy_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_strategy_id = input;
            self
        }
        /// <p>The ID of the configuration profile that was deployed.</p>
        pub fn configuration_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_profile_id = Some(input.into());
            self
        }
        /// <p>The ID of the configuration profile that was deployed.</p>
        pub fn set_configuration_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_profile_id = input;
            self
        }
        /// <p>The sequence number of the deployment.</p>
        pub fn deployment_number(mut self, input: i32) -> Self {
            self.deployment_number = Some(input);
            self
        }
        /// <p>The sequence number of the deployment.</p>
        pub fn set_deployment_number(mut self, input: std::option::Option<i32>) -> Self {
            self.deployment_number = input;
            self
        }
        /// <p>The name of the configuration.</p>
        pub fn configuration_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration.</p>
        pub fn set_configuration_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_name = input;
            self
        }
        /// <p>Information about the source location of the configuration.</p>
        pub fn configuration_location_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_location_uri = Some(input.into());
            self
        }
        /// <p>Information about the source location of the configuration.</p>
        pub fn set_configuration_location_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_location_uri = input;
            self
        }
        /// <p>The configuration version that was deployed.</p>
        pub fn configuration_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_version = Some(input.into());
            self
        }
        /// <p>The configuration version that was deployed.</p>
        pub fn set_configuration_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_version = input;
            self
        }
        /// <p>The description of the deployment.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the deployment.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Total amount of time the deployment lasted.</p>
        pub fn deployment_duration_in_minutes(mut self, input: i32) -> Self {
            self.deployment_duration_in_minutes = Some(input);
            self
        }
        /// <p>Total amount of time the deployment lasted.</p>
        pub fn set_deployment_duration_in_minutes(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.deployment_duration_in_minutes = input;
            self
        }
        /// <p>The algorithm used to define how percentage grew over time.</p>
        pub fn growth_type(mut self, input: crate::model::GrowthType) -> Self {
            self.growth_type = Some(input);
            self
        }
        /// <p>The algorithm used to define how percentage grew over time.</p>
        pub fn set_growth_type(
            mut self,
            input: std::option::Option<crate::model::GrowthType>,
        ) -> Self {
            self.growth_type = input;
            self
        }
        /// <p>The percentage of targets to receive a deployed configuration during each
        /// interval.</p>
        pub fn growth_factor(mut self, input: f32) -> Self {
            self.growth_factor = Some(input);
            self
        }
        /// <p>The percentage of targets to receive a deployed configuration during each
        /// interval.</p>
        pub fn set_growth_factor(mut self, input: std::option::Option<f32>) -> Self {
            self.growth_factor = input;
            self
        }
        /// <p>The amount of time AppConfig monitored for alarms before considering the deployment to be
        /// complete and no longer eligible for automatic roll back.</p>
        pub fn final_bake_time_in_minutes(mut self, input: i32) -> Self {
            self.final_bake_time_in_minutes = Some(input);
            self
        }
        /// <p>The amount of time AppConfig monitored for alarms before considering the deployment to be
        /// complete and no longer eligible for automatic roll back.</p>
        pub fn set_final_bake_time_in_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.final_bake_time_in_minutes = input;
            self
        }
        /// <p>The state of the deployment.</p>
        pub fn state(mut self, input: crate::model::DeploymentState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the deployment.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::DeploymentState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Appends an item to `event_log`.
        ///
        /// To override the contents of this collection use [`set_event_log`](Self::set_event_log).
        ///
        /// <p>A list containing all events related to a deployment. The most recent events are
        /// displayed first.</p>
        pub fn event_log(mut self, input: impl Into<crate::model::DeploymentEvent>) -> Self {
            let mut v = self.event_log.unwrap_or_default();
            v.push(input.into());
            self.event_log = Some(v);
            self
        }
        /// <p>A list containing all events related to a deployment. The most recent events are
        /// displayed first.</p>
        pub fn set_event_log(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DeploymentEvent>>,
        ) -> Self {
            self.event_log = input;
            self
        }
        /// <p>The percentage of targets for which the deployment is available.</p>
        pub fn percentage_complete(mut self, input: f32) -> Self {
            self.percentage_complete = Some(input);
            self
        }
        /// <p>The percentage of targets for which the deployment is available.</p>
        pub fn set_percentage_complete(mut self, input: std::option::Option<f32>) -> Self {
            self.percentage_complete = input;
            self
        }
        /// <p>The time the deployment started.</p>
        pub fn started_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.started_at = Some(input);
            self
        }
        /// <p>The time the deployment started.</p>
        pub fn set_started_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.started_at = input;
            self
        }
        /// <p>The time the deployment completed. </p>
        pub fn completed_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.completed_at = Some(input);
            self
        }
        /// <p>The time the deployment completed. </p>
        pub fn set_completed_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.completed_at = input;
            self
        }
        /// Consumes the builder and constructs a [`StopDeploymentOutput`](crate::output::StopDeploymentOutput)
        pub fn build(self) -> crate::output::StopDeploymentOutput {
            crate::output::StopDeploymentOutput {
                application_id: self.application_id,
                environment_id: self.environment_id,
                deployment_strategy_id: self.deployment_strategy_id,
                configuration_profile_id: self.configuration_profile_id,
                deployment_number: self.deployment_number.unwrap_or_default(),
                configuration_name: self.configuration_name,
                configuration_location_uri: self.configuration_location_uri,
                configuration_version: self.configuration_version,
                description: self.description,
                deployment_duration_in_minutes: self
                    .deployment_duration_in_minutes
                    .unwrap_or_default(),
                growth_type: self.growth_type,
                growth_factor: self.growth_factor.unwrap_or_default(),
                final_bake_time_in_minutes: self.final_bake_time_in_minutes.unwrap_or_default(),
                state: self.state,
                event_log: self.event_log,
                percentage_complete: self.percentage_complete.unwrap_or_default(),
                started_at: self.started_at,
                completed_at: self.completed_at,
            }
        }
    }
}
impl StopDeploymentOutput {
    /// Creates a new builder-style object to manufacture [`StopDeploymentOutput`](crate::output::StopDeploymentOutput)
    pub fn builder() -> crate::output::stop_deployment_output::Builder {
        crate::output::stop_deployment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartDeploymentOutput {
    /// <p>The ID of the application that was deployed.</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The ID of the environment that was deployed.</p>
    pub environment_id: std::option::Option<std::string::String>,
    /// <p>The ID of the deployment strategy that was deployed.</p>
    pub deployment_strategy_id: std::option::Option<std::string::String>,
    /// <p>The ID of the configuration profile that was deployed.</p>
    pub configuration_profile_id: std::option::Option<std::string::String>,
    /// <p>The sequence number of the deployment.</p>
    pub deployment_number: i32,
    /// <p>The name of the configuration.</p>
    pub configuration_name: std::option::Option<std::string::String>,
    /// <p>Information about the source location of the configuration.</p>
    pub configuration_location_uri: std::option::Option<std::string::String>,
    /// <p>The configuration version that was deployed.</p>
    pub configuration_version: std::option::Option<std::string::String>,
    /// <p>The description of the deployment.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Total amount of time the deployment lasted.</p>
    pub deployment_duration_in_minutes: i32,
    /// <p>The algorithm used to define how percentage grew over time.</p>
    pub growth_type: std::option::Option<crate::model::GrowthType>,
    /// <p>The percentage of targets to receive a deployed configuration during each
    /// interval.</p>
    pub growth_factor: f32,
    /// <p>The amount of time AppConfig monitored for alarms before considering the deployment to be
    /// complete and no longer eligible for automatic roll back.</p>
    pub final_bake_time_in_minutes: i32,
    /// <p>The state of the deployment.</p>
    pub state: std::option::Option<crate::model::DeploymentState>,
    /// <p>A list containing all events related to a deployment. The most recent events are
    /// displayed first.</p>
    pub event_log: std::option::Option<std::vec::Vec<crate::model::DeploymentEvent>>,
    /// <p>The percentage of targets for which the deployment is available.</p>
    pub percentage_complete: f32,
    /// <p>The time the deployment started.</p>
    pub started_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time the deployment completed. </p>
    pub completed_at: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for StartDeploymentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartDeploymentOutput");
        formatter.field("application_id", &self.application_id);
        formatter.field("environment_id", &self.environment_id);
        formatter.field("deployment_strategy_id", &self.deployment_strategy_id);
        formatter.field("configuration_profile_id", &self.configuration_profile_id);
        formatter.field("deployment_number", &self.deployment_number);
        formatter.field("configuration_name", &self.configuration_name);
        formatter.field(
            "configuration_location_uri",
            &self.configuration_location_uri,
        );
        formatter.field("configuration_version", &self.configuration_version);
        formatter.field("description", &self.description);
        formatter.field(
            "deployment_duration_in_minutes",
            &self.deployment_duration_in_minutes,
        );
        formatter.field("growth_type", &self.growth_type);
        formatter.field("growth_factor", &self.growth_factor);
        formatter.field(
            "final_bake_time_in_minutes",
            &self.final_bake_time_in_minutes,
        );
        formatter.field("state", &self.state);
        formatter.field("event_log", &self.event_log);
        formatter.field("percentage_complete", &self.percentage_complete);
        formatter.field("started_at", &self.started_at);
        formatter.field("completed_at", &self.completed_at);
        formatter.finish()
    }
}
/// See [`StartDeploymentOutput`](crate::output::StartDeploymentOutput)
pub mod start_deployment_output {
    /// A builder for [`StartDeploymentOutput`](crate::output::StartDeploymentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) environment_id: std::option::Option<std::string::String>,
        pub(crate) deployment_strategy_id: std::option::Option<std::string::String>,
        pub(crate) configuration_profile_id: std::option::Option<std::string::String>,
        pub(crate) deployment_number: std::option::Option<i32>,
        pub(crate) configuration_name: std::option::Option<std::string::String>,
        pub(crate) configuration_location_uri: std::option::Option<std::string::String>,
        pub(crate) configuration_version: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) deployment_duration_in_minutes: std::option::Option<i32>,
        pub(crate) growth_type: std::option::Option<crate::model::GrowthType>,
        pub(crate) growth_factor: std::option::Option<f32>,
        pub(crate) final_bake_time_in_minutes: std::option::Option<i32>,
        pub(crate) state: std::option::Option<crate::model::DeploymentState>,
        pub(crate) event_log: std::option::Option<std::vec::Vec<crate::model::DeploymentEvent>>,
        pub(crate) percentage_complete: std::option::Option<f32>,
        pub(crate) started_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) completed_at: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The ID of the application that was deployed.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The ID of the application that was deployed.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The ID of the environment that was deployed.</p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_id = Some(input.into());
            self
        }
        /// <p>The ID of the environment that was deployed.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_id = input;
            self
        }
        /// <p>The ID of the deployment strategy that was deployed.</p>
        pub fn deployment_strategy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_strategy_id = Some(input.into());
            self
        }
        /// <p>The ID of the deployment strategy that was deployed.</p>
        pub fn set_deployment_strategy_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_strategy_id = input;
            self
        }
        /// <p>The ID of the configuration profile that was deployed.</p>
        pub fn configuration_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_profile_id = Some(input.into());
            self
        }
        /// <p>The ID of the configuration profile that was deployed.</p>
        pub fn set_configuration_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_profile_id = input;
            self
        }
        /// <p>The sequence number of the deployment.</p>
        pub fn deployment_number(mut self, input: i32) -> Self {
            self.deployment_number = Some(input);
            self
        }
        /// <p>The sequence number of the deployment.</p>
        pub fn set_deployment_number(mut self, input: std::option::Option<i32>) -> Self {
            self.deployment_number = input;
            self
        }
        /// <p>The name of the configuration.</p>
        pub fn configuration_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration.</p>
        pub fn set_configuration_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_name = input;
            self
        }
        /// <p>Information about the source location of the configuration.</p>
        pub fn configuration_location_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_location_uri = Some(input.into());
            self
        }
        /// <p>Information about the source location of the configuration.</p>
        pub fn set_configuration_location_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_location_uri = input;
            self
        }
        /// <p>The configuration version that was deployed.</p>
        pub fn configuration_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_version = Some(input.into());
            self
        }
        /// <p>The configuration version that was deployed.</p>
        pub fn set_configuration_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_version = input;
            self
        }
        /// <p>The description of the deployment.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the deployment.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Total amount of time the deployment lasted.</p>
        pub fn deployment_duration_in_minutes(mut self, input: i32) -> Self {
            self.deployment_duration_in_minutes = Some(input);
            self
        }
        /// <p>Total amount of time the deployment lasted.</p>
        pub fn set_deployment_duration_in_minutes(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.deployment_duration_in_minutes = input;
            self
        }
        /// <p>The algorithm used to define how percentage grew over time.</p>
        pub fn growth_type(mut self, input: crate::model::GrowthType) -> Self {
            self.growth_type = Some(input);
            self
        }
        /// <p>The algorithm used to define how percentage grew over time.</p>
        pub fn set_growth_type(
            mut self,
            input: std::option::Option<crate::model::GrowthType>,
        ) -> Self {
            self.growth_type = input;
            self
        }
        /// <p>The percentage of targets to receive a deployed configuration during each
        /// interval.</p>
        pub fn growth_factor(mut self, input: f32) -> Self {
            self.growth_factor = Some(input);
            self
        }
        /// <p>The percentage of targets to receive a deployed configuration during each
        /// interval.</p>
        pub fn set_growth_factor(mut self, input: std::option::Option<f32>) -> Self {
            self.growth_factor = input;
            self
        }
        /// <p>The amount of time AppConfig monitored for alarms before considering the deployment to be
        /// complete and no longer eligible for automatic roll back.</p>
        pub fn final_bake_time_in_minutes(mut self, input: i32) -> Self {
            self.final_bake_time_in_minutes = Some(input);
            self
        }
        /// <p>The amount of time AppConfig monitored for alarms before considering the deployment to be
        /// complete and no longer eligible for automatic roll back.</p>
        pub fn set_final_bake_time_in_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.final_bake_time_in_minutes = input;
            self
        }
        /// <p>The state of the deployment.</p>
        pub fn state(mut self, input: crate::model::DeploymentState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the deployment.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::DeploymentState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Appends an item to `event_log`.
        ///
        /// To override the contents of this collection use [`set_event_log`](Self::set_event_log).
        ///
        /// <p>A list containing all events related to a deployment. The most recent events are
        /// displayed first.</p>
        pub fn event_log(mut self, input: impl Into<crate::model::DeploymentEvent>) -> Self {
            let mut v = self.event_log.unwrap_or_default();
            v.push(input.into());
            self.event_log = Some(v);
            self
        }
        /// <p>A list containing all events related to a deployment. The most recent events are
        /// displayed first.</p>
        pub fn set_event_log(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DeploymentEvent>>,
        ) -> Self {
            self.event_log = input;
            self
        }
        /// <p>The percentage of targets for which the deployment is available.</p>
        pub fn percentage_complete(mut self, input: f32) -> Self {
            self.percentage_complete = Some(input);
            self
        }
        /// <p>The percentage of targets for which the deployment is available.</p>
        pub fn set_percentage_complete(mut self, input: std::option::Option<f32>) -> Self {
            self.percentage_complete = input;
            self
        }
        /// <p>The time the deployment started.</p>
        pub fn started_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.started_at = Some(input);
            self
        }
        /// <p>The time the deployment started.</p>
        pub fn set_started_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.started_at = input;
            self
        }
        /// <p>The time the deployment completed. </p>
        pub fn completed_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.completed_at = Some(input);
            self
        }
        /// <p>The time the deployment completed. </p>
        pub fn set_completed_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.completed_at = input;
            self
        }
        /// Consumes the builder and constructs a [`StartDeploymentOutput`](crate::output::StartDeploymentOutput)
        pub fn build(self) -> crate::output::StartDeploymentOutput {
            crate::output::StartDeploymentOutput {
                application_id: self.application_id,
                environment_id: self.environment_id,
                deployment_strategy_id: self.deployment_strategy_id,
                configuration_profile_id: self.configuration_profile_id,
                deployment_number: self.deployment_number.unwrap_or_default(),
                configuration_name: self.configuration_name,
                configuration_location_uri: self.configuration_location_uri,
                configuration_version: self.configuration_version,
                description: self.description,
                deployment_duration_in_minutes: self
                    .deployment_duration_in_minutes
                    .unwrap_or_default(),
                growth_type: self.growth_type,
                growth_factor: self.growth_factor.unwrap_or_default(),
                final_bake_time_in_minutes: self.final_bake_time_in_minutes.unwrap_or_default(),
                state: self.state,
                event_log: self.event_log,
                percentage_complete: self.percentage_complete.unwrap_or_default(),
                started_at: self.started_at,
                completed_at: self.completed_at,
            }
        }
    }
}
impl StartDeploymentOutput {
    /// Creates a new builder-style object to manufacture [`StartDeploymentOutput`](crate::output::StartDeploymentOutput)
    pub fn builder() -> crate::output::start_deployment_output::Builder {
        crate::output::start_deployment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>Metadata to assign to AppConfig resources. Tags help organize and categorize your
    /// AppConfig resources. Each tag consists of a key and an optional value, both of which you
    /// define.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata to assign to AppConfig resources. Tags help organize and categorize your
        /// AppConfig resources. Each tag consists of a key and an optional value, both of which you
        /// define.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Metadata to assign to AppConfig resources. Tags help organize and categorize your
        /// AppConfig resources. Each tag consists of a key and an optional value, both of which you
        /// define.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListHostedConfigurationVersionsOutput {
    /// <p>The elements from this collection.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::HostedConfigurationVersionSummary>>,
    /// <p>The token for the next set of items to return. Use this token to get the next set of
    /// results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListHostedConfigurationVersionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListHostedConfigurationVersionsOutput");
        formatter.field("items", &self.items);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListHostedConfigurationVersionsOutput`](crate::output::ListHostedConfigurationVersionsOutput)
pub mod list_hosted_configuration_versions_output {
    /// A builder for [`ListHostedConfigurationVersionsOutput`](crate::output::ListHostedConfigurationVersionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) items:
            std::option::Option<std::vec::Vec<crate::model::HostedConfigurationVersionSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>The elements from this collection.</p>
        pub fn items(
            mut self,
            input: impl Into<crate::model::HostedConfigurationVersionSummary>,
        ) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>The elements from this collection.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::HostedConfigurationVersionSummary>,
            >,
        ) -> Self {
            self.items = input;
            self
        }
        /// <p>The token for the next set of items to return. Use this token to get the next set of
        /// results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. Use this token to get the next set of
        /// results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListHostedConfigurationVersionsOutput`](crate::output::ListHostedConfigurationVersionsOutput)
        pub fn build(self) -> crate::output::ListHostedConfigurationVersionsOutput {
            crate::output::ListHostedConfigurationVersionsOutput {
                items: self.items,
                next_token: self.next_token,
            }
        }
    }
}
impl ListHostedConfigurationVersionsOutput {
    /// Creates a new builder-style object to manufacture [`ListHostedConfigurationVersionsOutput`](crate::output::ListHostedConfigurationVersionsOutput)
    pub fn builder() -> crate::output::list_hosted_configuration_versions_output::Builder {
        crate::output::list_hosted_configuration_versions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListEnvironmentsOutput {
    /// <p>The elements from this collection.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::Environment>>,
    /// <p>The token for the next set of items to return. Use this token to get the next set of
    /// results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListEnvironmentsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListEnvironmentsOutput");
        formatter.field("items", &self.items);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListEnvironmentsOutput`](crate::output::ListEnvironmentsOutput)
pub mod list_environments_output {
    /// A builder for [`ListEnvironmentsOutput`](crate::output::ListEnvironmentsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) items: std::option::Option<std::vec::Vec<crate::model::Environment>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>The elements from this collection.</p>
        pub fn items(mut self, input: impl Into<crate::model::Environment>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>The elements from this collection.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Environment>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// <p>The token for the next set of items to return. Use this token to get the next set of
        /// results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. Use this token to get the next set of
        /// results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListEnvironmentsOutput`](crate::output::ListEnvironmentsOutput)
        pub fn build(self) -> crate::output::ListEnvironmentsOutput {
            crate::output::ListEnvironmentsOutput {
                items: self.items,
                next_token: self.next_token,
            }
        }
    }
}
impl ListEnvironmentsOutput {
    /// Creates a new builder-style object to manufacture [`ListEnvironmentsOutput`](crate::output::ListEnvironmentsOutput)
    pub fn builder() -> crate::output::list_environments_output::Builder {
        crate::output::list_environments_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDeploymentStrategiesOutput {
    /// <p>The elements from this collection.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::DeploymentStrategy>>,
    /// <p>The token for the next set of items to return. Use this token to get the next set of
    /// results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListDeploymentStrategiesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDeploymentStrategiesOutput");
        formatter.field("items", &self.items);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListDeploymentStrategiesOutput`](crate::output::ListDeploymentStrategiesOutput)
pub mod list_deployment_strategies_output {
    /// A builder for [`ListDeploymentStrategiesOutput`](crate::output::ListDeploymentStrategiesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) items: std::option::Option<std::vec::Vec<crate::model::DeploymentStrategy>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>The elements from this collection.</p>
        pub fn items(mut self, input: impl Into<crate::model::DeploymentStrategy>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>The elements from this collection.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DeploymentStrategy>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// <p>The token for the next set of items to return. Use this token to get the next set of
        /// results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. Use this token to get the next set of
        /// results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDeploymentStrategiesOutput`](crate::output::ListDeploymentStrategiesOutput)
        pub fn build(self) -> crate::output::ListDeploymentStrategiesOutput {
            crate::output::ListDeploymentStrategiesOutput {
                items: self.items,
                next_token: self.next_token,
            }
        }
    }
}
impl ListDeploymentStrategiesOutput {
    /// Creates a new builder-style object to manufacture [`ListDeploymentStrategiesOutput`](crate::output::ListDeploymentStrategiesOutput)
    pub fn builder() -> crate::output::list_deployment_strategies_output::Builder {
        crate::output::list_deployment_strategies_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDeploymentsOutput {
    /// <p>The elements from this collection.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::DeploymentSummary>>,
    /// <p>The token for the next set of items to return. Use this token to get the next set of
    /// results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListDeploymentsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDeploymentsOutput");
        formatter.field("items", &self.items);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListDeploymentsOutput`](crate::output::ListDeploymentsOutput)
pub mod list_deployments_output {
    /// A builder for [`ListDeploymentsOutput`](crate::output::ListDeploymentsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) items: std::option::Option<std::vec::Vec<crate::model::DeploymentSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>The elements from this collection.</p>
        pub fn items(mut self, input: impl Into<crate::model::DeploymentSummary>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>The elements from this collection.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DeploymentSummary>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// <p>The token for the next set of items to return. Use this token to get the next set of
        /// results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. Use this token to get the next set of
        /// results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDeploymentsOutput`](crate::output::ListDeploymentsOutput)
        pub fn build(self) -> crate::output::ListDeploymentsOutput {
            crate::output::ListDeploymentsOutput {
                items: self.items,
                next_token: self.next_token,
            }
        }
    }
}
impl ListDeploymentsOutput {
    /// Creates a new builder-style object to manufacture [`ListDeploymentsOutput`](crate::output::ListDeploymentsOutput)
    pub fn builder() -> crate::output::list_deployments_output::Builder {
        crate::output::list_deployments_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListConfigurationProfilesOutput {
    /// <p>The elements from this collection.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::ConfigurationProfileSummary>>,
    /// <p>The token for the next set of items to return. Use this token to get the next set of
    /// results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListConfigurationProfilesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListConfigurationProfilesOutput");
        formatter.field("items", &self.items);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListConfigurationProfilesOutput`](crate::output::ListConfigurationProfilesOutput)
pub mod list_configuration_profiles_output {
    /// A builder for [`ListConfigurationProfilesOutput`](crate::output::ListConfigurationProfilesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) items:
            std::option::Option<std::vec::Vec<crate::model::ConfigurationProfileSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>The elements from this collection.</p>
        pub fn items(
            mut self,
            input: impl Into<crate::model::ConfigurationProfileSummary>,
        ) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>The elements from this collection.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConfigurationProfileSummary>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// <p>The token for the next set of items to return. Use this token to get the next set of
        /// results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. Use this token to get the next set of
        /// results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListConfigurationProfilesOutput`](crate::output::ListConfigurationProfilesOutput)
        pub fn build(self) -> crate::output::ListConfigurationProfilesOutput {
            crate::output::ListConfigurationProfilesOutput {
                items: self.items,
                next_token: self.next_token,
            }
        }
    }
}
impl ListConfigurationProfilesOutput {
    /// Creates a new builder-style object to manufacture [`ListConfigurationProfilesOutput`](crate::output::ListConfigurationProfilesOutput)
    pub fn builder() -> crate::output::list_configuration_profiles_output::Builder {
        crate::output::list_configuration_profiles_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListApplicationsOutput {
    /// <p>The elements from this collection.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::Application>>,
    /// <p>The token for the next set of items to return. Use this token to get the next set of
    /// results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListApplicationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListApplicationsOutput");
        formatter.field("items", &self.items);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListApplicationsOutput`](crate::output::ListApplicationsOutput)
pub mod list_applications_output {
    /// A builder for [`ListApplicationsOutput`](crate::output::ListApplicationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) items: std::option::Option<std::vec::Vec<crate::model::Application>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>The elements from this collection.</p>
        pub fn items(mut self, input: impl Into<crate::model::Application>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>The elements from this collection.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Application>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// <p>The token for the next set of items to return. Use this token to get the next set of
        /// results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. Use this token to get the next set of
        /// results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListApplicationsOutput`](crate::output::ListApplicationsOutput)
        pub fn build(self) -> crate::output::ListApplicationsOutput {
            crate::output::ListApplicationsOutput {
                items: self.items,
                next_token: self.next_token,
            }
        }
    }
}
impl ListApplicationsOutput {
    /// Creates a new builder-style object to manufacture [`ListApplicationsOutput`](crate::output::ListApplicationsOutput)
    pub fn builder() -> crate::output::list_applications_output::Builder {
        crate::output::list_applications_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetHostedConfigurationVersionOutput {
    /// <p>The application ID.</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The configuration profile ID.</p>
    pub configuration_profile_id: std::option::Option<std::string::String>,
    /// <p>The configuration version.</p>
    pub version_number: i32,
    /// <p>A description of the configuration.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The content of the configuration or the configuration data.</p>
    pub content: std::option::Option<aws_smithy_types::Blob>,
    /// <p>A standard MIME type describing the format of the configuration content. For more
    /// information, see <a href="https://docs.aws.amazon.com/https:/www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17">Content-Type</a>.</p>
    pub content_type: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetHostedConfigurationVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetHostedConfigurationVersionOutput");
        formatter.field("application_id", &self.application_id);
        formatter.field("configuration_profile_id", &self.configuration_profile_id);
        formatter.field("version_number", &self.version_number);
        formatter.field("description", &self.description);
        formatter.field("content", &"*** Sensitive Data Redacted ***");
        formatter.field("content_type", &self.content_type);
        formatter.finish()
    }
}
/// See [`GetHostedConfigurationVersionOutput`](crate::output::GetHostedConfigurationVersionOutput)
pub mod get_hosted_configuration_version_output {
    /// A builder for [`GetHostedConfigurationVersionOutput`](crate::output::GetHostedConfigurationVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) configuration_profile_id: std::option::Option<std::string::String>,
        pub(crate) version_number: std::option::Option<i32>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) content: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) content_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The application ID.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The application ID.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The configuration profile ID.</p>
        pub fn configuration_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_profile_id = Some(input.into());
            self
        }
        /// <p>The configuration profile ID.</p>
        pub fn set_configuration_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_profile_id = input;
            self
        }
        /// <p>The configuration version.</p>
        pub fn version_number(mut self, input: i32) -> Self {
            self.version_number = Some(input);
            self
        }
        /// <p>The configuration version.</p>
        pub fn set_version_number(mut self, input: std::option::Option<i32>) -> Self {
            self.version_number = input;
            self
        }
        /// <p>A description of the configuration.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the configuration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The content of the configuration or the configuration data.</p>
        pub fn content(mut self, input: aws_smithy_types::Blob) -> Self {
            self.content = Some(input);
            self
        }
        /// <p>The content of the configuration or the configuration data.</p>
        pub fn set_content(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.content = input;
            self
        }
        /// <p>A standard MIME type describing the format of the configuration content. For more
        /// information, see <a href="https://docs.aws.amazon.com/https:/www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17">Content-Type</a>.</p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_type = Some(input.into());
            self
        }
        /// <p>A standard MIME type describing the format of the configuration content. For more
        /// information, see <a href="https://docs.aws.amazon.com/https:/www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17">Content-Type</a>.</p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_type = input;
            self
        }
        /// Consumes the builder and constructs a [`GetHostedConfigurationVersionOutput`](crate::output::GetHostedConfigurationVersionOutput)
        pub fn build(self) -> crate::output::GetHostedConfigurationVersionOutput {
            crate::output::GetHostedConfigurationVersionOutput {
                application_id: self.application_id,
                configuration_profile_id: self.configuration_profile_id,
                version_number: self.version_number.unwrap_or_default(),
                description: self.description,
                content: self.content,
                content_type: self.content_type,
            }
        }
    }
}
impl GetHostedConfigurationVersionOutput {
    /// Creates a new builder-style object to manufacture [`GetHostedConfigurationVersionOutput`](crate::output::GetHostedConfigurationVersionOutput)
    pub fn builder() -> crate::output::get_hosted_configuration_version_output::Builder {
        crate::output::get_hosted_configuration_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEnvironmentOutput {
    /// <p>The application ID.</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The environment ID.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the environment.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the environment.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The state of the environment. An environment can be in one of the following states:
    /// <code>READY_FOR_DEPLOYMENT</code>, <code>DEPLOYING</code>, <code>ROLLING_BACK</code>, or
    /// <code>ROLLED_BACK</code>
    /// </p>
    pub state: std::option::Option<crate::model::EnvironmentState>,
    /// <p>Amazon CloudWatch alarms monitored during the deployment.</p>
    pub monitors: std::option::Option<std::vec::Vec<crate::model::Monitor>>,
}
impl std::fmt::Debug for GetEnvironmentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEnvironmentOutput");
        formatter.field("application_id", &self.application_id);
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("state", &self.state);
        formatter.field("monitors", &self.monitors);
        formatter.finish()
    }
}
/// See [`GetEnvironmentOutput`](crate::output::GetEnvironmentOutput)
pub mod get_environment_output {
    /// A builder for [`GetEnvironmentOutput`](crate::output::GetEnvironmentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::EnvironmentState>,
        pub(crate) monitors: std::option::Option<std::vec::Vec<crate::model::Monitor>>,
    }
    impl Builder {
        /// <p>The application ID.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The application ID.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The environment ID.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The environment ID.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the environment.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the environment.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the environment.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the environment.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The state of the environment. An environment can be in one of the following states:
        /// <code>READY_FOR_DEPLOYMENT</code>, <code>DEPLOYING</code>, <code>ROLLING_BACK</code>, or
        /// <code>ROLLED_BACK</code>
        /// </p>
        pub fn state(mut self, input: crate::model::EnvironmentState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the environment. An environment can be in one of the following states:
        /// <code>READY_FOR_DEPLOYMENT</code>, <code>DEPLOYING</code>, <code>ROLLING_BACK</code>, or
        /// <code>ROLLED_BACK</code>
        /// </p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::EnvironmentState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Appends an item to `monitors`.
        ///
        /// To override the contents of this collection use [`set_monitors`](Self::set_monitors).
        ///
        /// <p>Amazon CloudWatch alarms monitored during the deployment.</p>
        pub fn monitors(mut self, input: impl Into<crate::model::Monitor>) -> Self {
            let mut v = self.monitors.unwrap_or_default();
            v.push(input.into());
            self.monitors = Some(v);
            self
        }
        /// <p>Amazon CloudWatch alarms monitored during the deployment.</p>
        pub fn set_monitors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Monitor>>,
        ) -> Self {
            self.monitors = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEnvironmentOutput`](crate::output::GetEnvironmentOutput)
        pub fn build(self) -> crate::output::GetEnvironmentOutput {
            crate::output::GetEnvironmentOutput {
                application_id: self.application_id,
                id: self.id,
                name: self.name,
                description: self.description,
                state: self.state,
                monitors: self.monitors,
            }
        }
    }
}
impl GetEnvironmentOutput {
    /// Creates a new builder-style object to manufacture [`GetEnvironmentOutput`](crate::output::GetEnvironmentOutput)
    pub fn builder() -> crate::output::get_environment_output::Builder {
        crate::output::get_environment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDeploymentStrategyOutput {
    /// <p>The deployment strategy ID.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the deployment strategy.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the deployment strategy.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Total amount of time the deployment lasted.</p>
    pub deployment_duration_in_minutes: i32,
    /// <p>The algorithm used to define how percentage grew over time.</p>
    pub growth_type: std::option::Option<crate::model::GrowthType>,
    /// <p>The percentage of targets that received a deployed configuration during each
    /// interval.</p>
    pub growth_factor: f32,
    /// <p>The amount of time AppConfig monitored for alarms before considering the deployment to be
    /// complete and no longer eligible for automatic roll back.</p>
    pub final_bake_time_in_minutes: i32,
    /// <p>Save the deployment strategy to a Systems Manager (SSM) document.</p>
    pub replicate_to: std::option::Option<crate::model::ReplicateTo>,
}
impl std::fmt::Debug for GetDeploymentStrategyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDeploymentStrategyOutput");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field(
            "deployment_duration_in_minutes",
            &self.deployment_duration_in_minutes,
        );
        formatter.field("growth_type", &self.growth_type);
        formatter.field("growth_factor", &self.growth_factor);
        formatter.field(
            "final_bake_time_in_minutes",
            &self.final_bake_time_in_minutes,
        );
        formatter.field("replicate_to", &self.replicate_to);
        formatter.finish()
    }
}
/// See [`GetDeploymentStrategyOutput`](crate::output::GetDeploymentStrategyOutput)
pub mod get_deployment_strategy_output {
    /// A builder for [`GetDeploymentStrategyOutput`](crate::output::GetDeploymentStrategyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) deployment_duration_in_minutes: std::option::Option<i32>,
        pub(crate) growth_type: std::option::Option<crate::model::GrowthType>,
        pub(crate) growth_factor: std::option::Option<f32>,
        pub(crate) final_bake_time_in_minutes: std::option::Option<i32>,
        pub(crate) replicate_to: std::option::Option<crate::model::ReplicateTo>,
    }
    impl Builder {
        /// <p>The deployment strategy ID.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The deployment strategy ID.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the deployment strategy.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the deployment strategy.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the deployment strategy.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the deployment strategy.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Total amount of time the deployment lasted.</p>
        pub fn deployment_duration_in_minutes(mut self, input: i32) -> Self {
            self.deployment_duration_in_minutes = Some(input);
            self
        }
        /// <p>Total amount of time the deployment lasted.</p>
        pub fn set_deployment_duration_in_minutes(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.deployment_duration_in_minutes = input;
            self
        }
        /// <p>The algorithm used to define how percentage grew over time.</p>
        pub fn growth_type(mut self, input: crate::model::GrowthType) -> Self {
            self.growth_type = Some(input);
            self
        }
        /// <p>The algorithm used to define how percentage grew over time.</p>
        pub fn set_growth_type(
            mut self,
            input: std::option::Option<crate::model::GrowthType>,
        ) -> Self {
            self.growth_type = input;
            self
        }
        /// <p>The percentage of targets that received a deployed configuration during each
        /// interval.</p>
        pub fn growth_factor(mut self, input: f32) -> Self {
            self.growth_factor = Some(input);
            self
        }
        /// <p>The percentage of targets that received a deployed configuration during each
        /// interval.</p>
        pub fn set_growth_factor(mut self, input: std::option::Option<f32>) -> Self {
            self.growth_factor = input;
            self
        }
        /// <p>The amount of time AppConfig monitored for alarms before considering the deployment to be
        /// complete and no longer eligible for automatic roll back.</p>
        pub fn final_bake_time_in_minutes(mut self, input: i32) -> Self {
            self.final_bake_time_in_minutes = Some(input);
            self
        }
        /// <p>The amount of time AppConfig monitored for alarms before considering the deployment to be
        /// complete and no longer eligible for automatic roll back.</p>
        pub fn set_final_bake_time_in_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.final_bake_time_in_minutes = input;
            self
        }
        /// <p>Save the deployment strategy to a Systems Manager (SSM) document.</p>
        pub fn replicate_to(mut self, input: crate::model::ReplicateTo) -> Self {
            self.replicate_to = Some(input);
            self
        }
        /// <p>Save the deployment strategy to a Systems Manager (SSM) document.</p>
        pub fn set_replicate_to(
            mut self,
            input: std::option::Option<crate::model::ReplicateTo>,
        ) -> Self {
            self.replicate_to = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDeploymentStrategyOutput`](crate::output::GetDeploymentStrategyOutput)
        pub fn build(self) -> crate::output::GetDeploymentStrategyOutput {
            crate::output::GetDeploymentStrategyOutput {
                id: self.id,
                name: self.name,
                description: self.description,
                deployment_duration_in_minutes: self
                    .deployment_duration_in_minutes
                    .unwrap_or_default(),
                growth_type: self.growth_type,
                growth_factor: self.growth_factor.unwrap_or_default(),
                final_bake_time_in_minutes: self.final_bake_time_in_minutes.unwrap_or_default(),
                replicate_to: self.replicate_to,
            }
        }
    }
}
impl GetDeploymentStrategyOutput {
    /// Creates a new builder-style object to manufacture [`GetDeploymentStrategyOutput`](crate::output::GetDeploymentStrategyOutput)
    pub fn builder() -> crate::output::get_deployment_strategy_output::Builder {
        crate::output::get_deployment_strategy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDeploymentOutput {
    /// <p>The ID of the application that was deployed.</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The ID of the environment that was deployed.</p>
    pub environment_id: std::option::Option<std::string::String>,
    /// <p>The ID of the deployment strategy that was deployed.</p>
    pub deployment_strategy_id: std::option::Option<std::string::String>,
    /// <p>The ID of the configuration profile that was deployed.</p>
    pub configuration_profile_id: std::option::Option<std::string::String>,
    /// <p>The sequence number of the deployment.</p>
    pub deployment_number: i32,
    /// <p>The name of the configuration.</p>
    pub configuration_name: std::option::Option<std::string::String>,
    /// <p>Information about the source location of the configuration.</p>
    pub configuration_location_uri: std::option::Option<std::string::String>,
    /// <p>The configuration version that was deployed.</p>
    pub configuration_version: std::option::Option<std::string::String>,
    /// <p>The description of the deployment.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Total amount of time the deployment lasted.</p>
    pub deployment_duration_in_minutes: i32,
    /// <p>The algorithm used to define how percentage grew over time.</p>
    pub growth_type: std::option::Option<crate::model::GrowthType>,
    /// <p>The percentage of targets to receive a deployed configuration during each
    /// interval.</p>
    pub growth_factor: f32,
    /// <p>The amount of time AppConfig monitored for alarms before considering the deployment to be
    /// complete and no longer eligible for automatic roll back.</p>
    pub final_bake_time_in_minutes: i32,
    /// <p>The state of the deployment.</p>
    pub state: std::option::Option<crate::model::DeploymentState>,
    /// <p>A list containing all events related to a deployment. The most recent events are
    /// displayed first.</p>
    pub event_log: std::option::Option<std::vec::Vec<crate::model::DeploymentEvent>>,
    /// <p>The percentage of targets for which the deployment is available.</p>
    pub percentage_complete: f32,
    /// <p>The time the deployment started.</p>
    pub started_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time the deployment completed. </p>
    pub completed_at: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for GetDeploymentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDeploymentOutput");
        formatter.field("application_id", &self.application_id);
        formatter.field("environment_id", &self.environment_id);
        formatter.field("deployment_strategy_id", &self.deployment_strategy_id);
        formatter.field("configuration_profile_id", &self.configuration_profile_id);
        formatter.field("deployment_number", &self.deployment_number);
        formatter.field("configuration_name", &self.configuration_name);
        formatter.field(
            "configuration_location_uri",
            &self.configuration_location_uri,
        );
        formatter.field("configuration_version", &self.configuration_version);
        formatter.field("description", &self.description);
        formatter.field(
            "deployment_duration_in_minutes",
            &self.deployment_duration_in_minutes,
        );
        formatter.field("growth_type", &self.growth_type);
        formatter.field("growth_factor", &self.growth_factor);
        formatter.field(
            "final_bake_time_in_minutes",
            &self.final_bake_time_in_minutes,
        );
        formatter.field("state", &self.state);
        formatter.field("event_log", &self.event_log);
        formatter.field("percentage_complete", &self.percentage_complete);
        formatter.field("started_at", &self.started_at);
        formatter.field("completed_at", &self.completed_at);
        formatter.finish()
    }
}
/// See [`GetDeploymentOutput`](crate::output::GetDeploymentOutput)
pub mod get_deployment_output {
    /// A builder for [`GetDeploymentOutput`](crate::output::GetDeploymentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) environment_id: std::option::Option<std::string::String>,
        pub(crate) deployment_strategy_id: std::option::Option<std::string::String>,
        pub(crate) configuration_profile_id: std::option::Option<std::string::String>,
        pub(crate) deployment_number: std::option::Option<i32>,
        pub(crate) configuration_name: std::option::Option<std::string::String>,
        pub(crate) configuration_location_uri: std::option::Option<std::string::String>,
        pub(crate) configuration_version: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) deployment_duration_in_minutes: std::option::Option<i32>,
        pub(crate) growth_type: std::option::Option<crate::model::GrowthType>,
        pub(crate) growth_factor: std::option::Option<f32>,
        pub(crate) final_bake_time_in_minutes: std::option::Option<i32>,
        pub(crate) state: std::option::Option<crate::model::DeploymentState>,
        pub(crate) event_log: std::option::Option<std::vec::Vec<crate::model::DeploymentEvent>>,
        pub(crate) percentage_complete: std::option::Option<f32>,
        pub(crate) started_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) completed_at: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The ID of the application that was deployed.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The ID of the application that was deployed.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The ID of the environment that was deployed.</p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_id = Some(input.into());
            self
        }
        /// <p>The ID of the environment that was deployed.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_id = input;
            self
        }
        /// <p>The ID of the deployment strategy that was deployed.</p>
        pub fn deployment_strategy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_strategy_id = Some(input.into());
            self
        }
        /// <p>The ID of the deployment strategy that was deployed.</p>
        pub fn set_deployment_strategy_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_strategy_id = input;
            self
        }
        /// <p>The ID of the configuration profile that was deployed.</p>
        pub fn configuration_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_profile_id = Some(input.into());
            self
        }
        /// <p>The ID of the configuration profile that was deployed.</p>
        pub fn set_configuration_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_profile_id = input;
            self
        }
        /// <p>The sequence number of the deployment.</p>
        pub fn deployment_number(mut self, input: i32) -> Self {
            self.deployment_number = Some(input);
            self
        }
        /// <p>The sequence number of the deployment.</p>
        pub fn set_deployment_number(mut self, input: std::option::Option<i32>) -> Self {
            self.deployment_number = input;
            self
        }
        /// <p>The name of the configuration.</p>
        pub fn configuration_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration.</p>
        pub fn set_configuration_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_name = input;
            self
        }
        /// <p>Information about the source location of the configuration.</p>
        pub fn configuration_location_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_location_uri = Some(input.into());
            self
        }
        /// <p>Information about the source location of the configuration.</p>
        pub fn set_configuration_location_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_location_uri = input;
            self
        }
        /// <p>The configuration version that was deployed.</p>
        pub fn configuration_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_version = Some(input.into());
            self
        }
        /// <p>The configuration version that was deployed.</p>
        pub fn set_configuration_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_version = input;
            self
        }
        /// <p>The description of the deployment.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the deployment.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Total amount of time the deployment lasted.</p>
        pub fn deployment_duration_in_minutes(mut self, input: i32) -> Self {
            self.deployment_duration_in_minutes = Some(input);
            self
        }
        /// <p>Total amount of time the deployment lasted.</p>
        pub fn set_deployment_duration_in_minutes(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.deployment_duration_in_minutes = input;
            self
        }
        /// <p>The algorithm used to define how percentage grew over time.</p>
        pub fn growth_type(mut self, input: crate::model::GrowthType) -> Self {
            self.growth_type = Some(input);
            self
        }
        /// <p>The algorithm used to define how percentage grew over time.</p>
        pub fn set_growth_type(
            mut self,
            input: std::option::Option<crate::model::GrowthType>,
        ) -> Self {
            self.growth_type = input;
            self
        }
        /// <p>The percentage of targets to receive a deployed configuration during each
        /// interval.</p>
        pub fn growth_factor(mut self, input: f32) -> Self {
            self.growth_factor = Some(input);
            self
        }
        /// <p>The percentage of targets to receive a deployed configuration during each
        /// interval.</p>
        pub fn set_growth_factor(mut self, input: std::option::Option<f32>) -> Self {
            self.growth_factor = input;
            self
        }
        /// <p>The amount of time AppConfig monitored for alarms before considering the deployment to be
        /// complete and no longer eligible for automatic roll back.</p>
        pub fn final_bake_time_in_minutes(mut self, input: i32) -> Self {
            self.final_bake_time_in_minutes = Some(input);
            self
        }
        /// <p>The amount of time AppConfig monitored for alarms before considering the deployment to be
        /// complete and no longer eligible for automatic roll back.</p>
        pub fn set_final_bake_time_in_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.final_bake_time_in_minutes = input;
            self
        }
        /// <p>The state of the deployment.</p>
        pub fn state(mut self, input: crate::model::DeploymentState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the deployment.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::DeploymentState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Appends an item to `event_log`.
        ///
        /// To override the contents of this collection use [`set_event_log`](Self::set_event_log).
        ///
        /// <p>A list containing all events related to a deployment. The most recent events are
        /// displayed first.</p>
        pub fn event_log(mut self, input: impl Into<crate::model::DeploymentEvent>) -> Self {
            let mut v = self.event_log.unwrap_or_default();
            v.push(input.into());
            self.event_log = Some(v);
            self
        }
        /// <p>A list containing all events related to a deployment. The most recent events are
        /// displayed first.</p>
        pub fn set_event_log(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DeploymentEvent>>,
        ) -> Self {
            self.event_log = input;
            self
        }
        /// <p>The percentage of targets for which the deployment is available.</p>
        pub fn percentage_complete(mut self, input: f32) -> Self {
            self.percentage_complete = Some(input);
            self
        }
        /// <p>The percentage of targets for which the deployment is available.</p>
        pub fn set_percentage_complete(mut self, input: std::option::Option<f32>) -> Self {
            self.percentage_complete = input;
            self
        }
        /// <p>The time the deployment started.</p>
        pub fn started_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.started_at = Some(input);
            self
        }
        /// <p>The time the deployment started.</p>
        pub fn set_started_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.started_at = input;
            self
        }
        /// <p>The time the deployment completed. </p>
        pub fn completed_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.completed_at = Some(input);
            self
        }
        /// <p>The time the deployment completed. </p>
        pub fn set_completed_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.completed_at = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDeploymentOutput`](crate::output::GetDeploymentOutput)
        pub fn build(self) -> crate::output::GetDeploymentOutput {
            crate::output::GetDeploymentOutput {
                application_id: self.application_id,
                environment_id: self.environment_id,
                deployment_strategy_id: self.deployment_strategy_id,
                configuration_profile_id: self.configuration_profile_id,
                deployment_number: self.deployment_number.unwrap_or_default(),
                configuration_name: self.configuration_name,
                configuration_location_uri: self.configuration_location_uri,
                configuration_version: self.configuration_version,
                description: self.description,
                deployment_duration_in_minutes: self
                    .deployment_duration_in_minutes
                    .unwrap_or_default(),
                growth_type: self.growth_type,
                growth_factor: self.growth_factor.unwrap_or_default(),
                final_bake_time_in_minutes: self.final_bake_time_in_minutes.unwrap_or_default(),
                state: self.state,
                event_log: self.event_log,
                percentage_complete: self.percentage_complete.unwrap_or_default(),
                started_at: self.started_at,
                completed_at: self.completed_at,
            }
        }
    }
}
impl GetDeploymentOutput {
    /// Creates a new builder-style object to manufacture [`GetDeploymentOutput`](crate::output::GetDeploymentOutput)
    pub fn builder() -> crate::output::get_deployment_output::Builder {
        crate::output::get_deployment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetConfigurationProfileOutput {
    /// <p>The application ID.</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The configuration profile ID.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the configuration profile.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The configuration profile description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The URI location of the configuration.</p>
    pub location_uri: std::option::Option<std::string::String>,
    /// <p>The ARN of an IAM role with permission to access the configuration at the specified
    /// LocationUri.</p>
    pub retrieval_role_arn: std::option::Option<std::string::String>,
    /// <p>A list of methods for validating the configuration.</p>
    pub validators: std::option::Option<std::vec::Vec<crate::model::Validator>>,
}
impl std::fmt::Debug for GetConfigurationProfileOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetConfigurationProfileOutput");
        formatter.field("application_id", &self.application_id);
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("location_uri", &self.location_uri);
        formatter.field("retrieval_role_arn", &self.retrieval_role_arn);
        formatter.field("validators", &self.validators);
        formatter.finish()
    }
}
/// See [`GetConfigurationProfileOutput`](crate::output::GetConfigurationProfileOutput)
pub mod get_configuration_profile_output {
    /// A builder for [`GetConfigurationProfileOutput`](crate::output::GetConfigurationProfileOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) location_uri: std::option::Option<std::string::String>,
        pub(crate) retrieval_role_arn: std::option::Option<std::string::String>,
        pub(crate) validators: std::option::Option<std::vec::Vec<crate::model::Validator>>,
    }
    impl Builder {
        /// <p>The application ID.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The application ID.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The configuration profile ID.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The configuration profile ID.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the configuration profile.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the configuration profile.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The configuration profile description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The configuration profile description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The URI location of the configuration.</p>
        pub fn location_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.location_uri = Some(input.into());
            self
        }
        /// <p>The URI location of the configuration.</p>
        pub fn set_location_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location_uri = input;
            self
        }
        /// <p>The ARN of an IAM role with permission to access the configuration at the specified
        /// LocationUri.</p>
        pub fn retrieval_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.retrieval_role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of an IAM role with permission to access the configuration at the specified
        /// LocationUri.</p>
        pub fn set_retrieval_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.retrieval_role_arn = input;
            self
        }
        /// Appends an item to `validators`.
        ///
        /// To override the contents of this collection use [`set_validators`](Self::set_validators).
        ///
        /// <p>A list of methods for validating the configuration.</p>
        pub fn validators(mut self, input: impl Into<crate::model::Validator>) -> Self {
            let mut v = self.validators.unwrap_or_default();
            v.push(input.into());
            self.validators = Some(v);
            self
        }
        /// <p>A list of methods for validating the configuration.</p>
        pub fn set_validators(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Validator>>,
        ) -> Self {
            self.validators = input;
            self
        }
        /// Consumes the builder and constructs a [`GetConfigurationProfileOutput`](crate::output::GetConfigurationProfileOutput)
        pub fn build(self) -> crate::output::GetConfigurationProfileOutput {
            crate::output::GetConfigurationProfileOutput {
                application_id: self.application_id,
                id: self.id,
                name: self.name,
                description: self.description,
                location_uri: self.location_uri,
                retrieval_role_arn: self.retrieval_role_arn,
                validators: self.validators,
            }
        }
    }
}
impl GetConfigurationProfileOutput {
    /// Creates a new builder-style object to manufacture [`GetConfigurationProfileOutput`](crate::output::GetConfigurationProfileOutput)
    pub fn builder() -> crate::output::get_configuration_profile_output::Builder {
        crate::output::get_configuration_profile_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetConfigurationOutput {
    /// <p>The content of the configuration or the configuration data.</p>
    pub content: std::option::Option<aws_smithy_types::Blob>,
    /// <p>The configuration version.</p>
    pub configuration_version: std::option::Option<std::string::String>,
    /// <p>A standard MIME type describing the format of the configuration content. For more
    /// information, see <a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17">Content-Type</a>.</p>
    pub content_type: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetConfigurationOutput");
        formatter.field("content", &"*** Sensitive Data Redacted ***");
        formatter.field("configuration_version", &self.configuration_version);
        formatter.field("content_type", &self.content_type);
        formatter.finish()
    }
}
/// See [`GetConfigurationOutput`](crate::output::GetConfigurationOutput)
pub mod get_configuration_output {
    /// A builder for [`GetConfigurationOutput`](crate::output::GetConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) content: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) configuration_version: std::option::Option<std::string::String>,
        pub(crate) content_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The content of the configuration or the configuration data.</p>
        pub fn content(mut self, input: aws_smithy_types::Blob) -> Self {
            self.content = Some(input);
            self
        }
        /// <p>The content of the configuration or the configuration data.</p>
        pub fn set_content(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.content = input;
            self
        }
        /// <p>The configuration version.</p>
        pub fn configuration_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_version = Some(input.into());
            self
        }
        /// <p>The configuration version.</p>
        pub fn set_configuration_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_version = input;
            self
        }
        /// <p>A standard MIME type describing the format of the configuration content. For more
        /// information, see <a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17">Content-Type</a>.</p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_type = Some(input.into());
            self
        }
        /// <p>A standard MIME type describing the format of the configuration content. For more
        /// information, see <a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17">Content-Type</a>.</p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_type = input;
            self
        }
        /// Consumes the builder and constructs a [`GetConfigurationOutput`](crate::output::GetConfigurationOutput)
        pub fn build(self) -> crate::output::GetConfigurationOutput {
            crate::output::GetConfigurationOutput {
                content: self.content,
                configuration_version: self.configuration_version,
                content_type: self.content_type,
            }
        }
    }
}
impl GetConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`GetConfigurationOutput`](crate::output::GetConfigurationOutput)
    pub fn builder() -> crate::output::get_configuration_output::Builder {
        crate::output::get_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetApplicationOutput {
    /// <p>The application ID.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The application name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the application.</p>
    pub description: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetApplicationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetApplicationOutput");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`GetApplicationOutput`](crate::output::GetApplicationOutput)
pub mod get_application_output {
    /// A builder for [`GetApplicationOutput`](crate::output::GetApplicationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The application ID.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The application ID.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The application name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The application name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the application.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the application.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`GetApplicationOutput`](crate::output::GetApplicationOutput)
        pub fn build(self) -> crate::output::GetApplicationOutput {
            crate::output::GetApplicationOutput {
                id: self.id,
                name: self.name,
                description: self.description,
            }
        }
    }
}
impl GetApplicationOutput {
    /// Creates a new builder-style object to manufacture [`GetApplicationOutput`](crate::output::GetApplicationOutput)
    pub fn builder() -> crate::output::get_application_output::Builder {
        crate::output::get_application_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteHostedConfigurationVersionOutput {}
impl std::fmt::Debug for DeleteHostedConfigurationVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteHostedConfigurationVersionOutput");
        formatter.finish()
    }
}
/// See [`DeleteHostedConfigurationVersionOutput`](crate::output::DeleteHostedConfigurationVersionOutput)
pub mod delete_hosted_configuration_version_output {
    /// A builder for [`DeleteHostedConfigurationVersionOutput`](crate::output::DeleteHostedConfigurationVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteHostedConfigurationVersionOutput`](crate::output::DeleteHostedConfigurationVersionOutput)
        pub fn build(self) -> crate::output::DeleteHostedConfigurationVersionOutput {
            crate::output::DeleteHostedConfigurationVersionOutput {}
        }
    }
}
impl DeleteHostedConfigurationVersionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteHostedConfigurationVersionOutput`](crate::output::DeleteHostedConfigurationVersionOutput)
    pub fn builder() -> crate::output::delete_hosted_configuration_version_output::Builder {
        crate::output::delete_hosted_configuration_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteEnvironmentOutput {}
impl std::fmt::Debug for DeleteEnvironmentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteEnvironmentOutput");
        formatter.finish()
    }
}
/// See [`DeleteEnvironmentOutput`](crate::output::DeleteEnvironmentOutput)
pub mod delete_environment_output {
    /// A builder for [`DeleteEnvironmentOutput`](crate::output::DeleteEnvironmentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteEnvironmentOutput`](crate::output::DeleteEnvironmentOutput)
        pub fn build(self) -> crate::output::DeleteEnvironmentOutput {
            crate::output::DeleteEnvironmentOutput {}
        }
    }
}
impl DeleteEnvironmentOutput {
    /// Creates a new builder-style object to manufacture [`DeleteEnvironmentOutput`](crate::output::DeleteEnvironmentOutput)
    pub fn builder() -> crate::output::delete_environment_output::Builder {
        crate::output::delete_environment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDeploymentStrategyOutput {}
impl std::fmt::Debug for DeleteDeploymentStrategyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDeploymentStrategyOutput");
        formatter.finish()
    }
}
/// See [`DeleteDeploymentStrategyOutput`](crate::output::DeleteDeploymentStrategyOutput)
pub mod delete_deployment_strategy_output {
    /// A builder for [`DeleteDeploymentStrategyOutput`](crate::output::DeleteDeploymentStrategyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteDeploymentStrategyOutput`](crate::output::DeleteDeploymentStrategyOutput)
        pub fn build(self) -> crate::output::DeleteDeploymentStrategyOutput {
            crate::output::DeleteDeploymentStrategyOutput {}
        }
    }
}
impl DeleteDeploymentStrategyOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDeploymentStrategyOutput`](crate::output::DeleteDeploymentStrategyOutput)
    pub fn builder() -> crate::output::delete_deployment_strategy_output::Builder {
        crate::output::delete_deployment_strategy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteConfigurationProfileOutput {}
impl std::fmt::Debug for DeleteConfigurationProfileOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteConfigurationProfileOutput");
        formatter.finish()
    }
}
/// See [`DeleteConfigurationProfileOutput`](crate::output::DeleteConfigurationProfileOutput)
pub mod delete_configuration_profile_output {
    /// A builder for [`DeleteConfigurationProfileOutput`](crate::output::DeleteConfigurationProfileOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteConfigurationProfileOutput`](crate::output::DeleteConfigurationProfileOutput)
        pub fn build(self) -> crate::output::DeleteConfigurationProfileOutput {
            crate::output::DeleteConfigurationProfileOutput {}
        }
    }
}
impl DeleteConfigurationProfileOutput {
    /// Creates a new builder-style object to manufacture [`DeleteConfigurationProfileOutput`](crate::output::DeleteConfigurationProfileOutput)
    pub fn builder() -> crate::output::delete_configuration_profile_output::Builder {
        crate::output::delete_configuration_profile_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteApplicationOutput {}
impl std::fmt::Debug for DeleteApplicationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteApplicationOutput");
        formatter.finish()
    }
}
/// See [`DeleteApplicationOutput`](crate::output::DeleteApplicationOutput)
pub mod delete_application_output {
    /// A builder for [`DeleteApplicationOutput`](crate::output::DeleteApplicationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteApplicationOutput`](crate::output::DeleteApplicationOutput)
        pub fn build(self) -> crate::output::DeleteApplicationOutput {
            crate::output::DeleteApplicationOutput {}
        }
    }
}
impl DeleteApplicationOutput {
    /// Creates a new builder-style object to manufacture [`DeleteApplicationOutput`](crate::output::DeleteApplicationOutput)
    pub fn builder() -> crate::output::delete_application_output::Builder {
        crate::output::delete_application_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateHostedConfigurationVersionOutput {
    /// <p>The application ID.</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The configuration profile ID.</p>
    pub configuration_profile_id: std::option::Option<std::string::String>,
    /// <p>The configuration version.</p>
    pub version_number: i32,
    /// <p>A description of the configuration.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The content of the configuration or the configuration data.</p>
    pub content: std::option::Option<aws_smithy_types::Blob>,
    /// <p>A standard MIME type describing the format of the configuration content. For more
    /// information, see <a href="https://docs.aws.amazon.com/https:/www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17">Content-Type</a>.</p>
    pub content_type: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateHostedConfigurationVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateHostedConfigurationVersionOutput");
        formatter.field("application_id", &self.application_id);
        formatter.field("configuration_profile_id", &self.configuration_profile_id);
        formatter.field("version_number", &self.version_number);
        formatter.field("description", &self.description);
        formatter.field("content", &"*** Sensitive Data Redacted ***");
        formatter.field("content_type", &self.content_type);
        formatter.finish()
    }
}
/// See [`CreateHostedConfigurationVersionOutput`](crate::output::CreateHostedConfigurationVersionOutput)
pub mod create_hosted_configuration_version_output {
    /// A builder for [`CreateHostedConfigurationVersionOutput`](crate::output::CreateHostedConfigurationVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) configuration_profile_id: std::option::Option<std::string::String>,
        pub(crate) version_number: std::option::Option<i32>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) content: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) content_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The application ID.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The application ID.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The configuration profile ID.</p>
        pub fn configuration_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_profile_id = Some(input.into());
            self
        }
        /// <p>The configuration profile ID.</p>
        pub fn set_configuration_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_profile_id = input;
            self
        }
        /// <p>The configuration version.</p>
        pub fn version_number(mut self, input: i32) -> Self {
            self.version_number = Some(input);
            self
        }
        /// <p>The configuration version.</p>
        pub fn set_version_number(mut self, input: std::option::Option<i32>) -> Self {
            self.version_number = input;
            self
        }
        /// <p>A description of the configuration.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the configuration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The content of the configuration or the configuration data.</p>
        pub fn content(mut self, input: aws_smithy_types::Blob) -> Self {
            self.content = Some(input);
            self
        }
        /// <p>The content of the configuration or the configuration data.</p>
        pub fn set_content(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.content = input;
            self
        }
        /// <p>A standard MIME type describing the format of the configuration content. For more
        /// information, see <a href="https://docs.aws.amazon.com/https:/www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17">Content-Type</a>.</p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_type = Some(input.into());
            self
        }
        /// <p>A standard MIME type describing the format of the configuration content. For more
        /// information, see <a href="https://docs.aws.amazon.com/https:/www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17">Content-Type</a>.</p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_type = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateHostedConfigurationVersionOutput`](crate::output::CreateHostedConfigurationVersionOutput)
        pub fn build(self) -> crate::output::CreateHostedConfigurationVersionOutput {
            crate::output::CreateHostedConfigurationVersionOutput {
                application_id: self.application_id,
                configuration_profile_id: self.configuration_profile_id,
                version_number: self.version_number.unwrap_or_default(),
                description: self.description,
                content: self.content,
                content_type: self.content_type,
            }
        }
    }
}
impl CreateHostedConfigurationVersionOutput {
    /// Creates a new builder-style object to manufacture [`CreateHostedConfigurationVersionOutput`](crate::output::CreateHostedConfigurationVersionOutput)
    pub fn builder() -> crate::output::create_hosted_configuration_version_output::Builder {
        crate::output::create_hosted_configuration_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateEnvironmentOutput {
    /// <p>The application ID.</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The environment ID.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the environment.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the environment.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The state of the environment. An environment can be in one of the following states:
    /// <code>READY_FOR_DEPLOYMENT</code>, <code>DEPLOYING</code>, <code>ROLLING_BACK</code>, or
    /// <code>ROLLED_BACK</code>
    /// </p>
    pub state: std::option::Option<crate::model::EnvironmentState>,
    /// <p>Amazon CloudWatch alarms monitored during the deployment.</p>
    pub monitors: std::option::Option<std::vec::Vec<crate::model::Monitor>>,
}
impl std::fmt::Debug for CreateEnvironmentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateEnvironmentOutput");
        formatter.field("application_id", &self.application_id);
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("state", &self.state);
        formatter.field("monitors", &self.monitors);
        formatter.finish()
    }
}
/// See [`CreateEnvironmentOutput`](crate::output::CreateEnvironmentOutput)
pub mod create_environment_output {
    /// A builder for [`CreateEnvironmentOutput`](crate::output::CreateEnvironmentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::EnvironmentState>,
        pub(crate) monitors: std::option::Option<std::vec::Vec<crate::model::Monitor>>,
    }
    impl Builder {
        /// <p>The application ID.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The application ID.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The environment ID.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The environment ID.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the environment.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the environment.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the environment.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the environment.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The state of the environment. An environment can be in one of the following states:
        /// <code>READY_FOR_DEPLOYMENT</code>, <code>DEPLOYING</code>, <code>ROLLING_BACK</code>, or
        /// <code>ROLLED_BACK</code>
        /// </p>
        pub fn state(mut self, input: crate::model::EnvironmentState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the environment. An environment can be in one of the following states:
        /// <code>READY_FOR_DEPLOYMENT</code>, <code>DEPLOYING</code>, <code>ROLLING_BACK</code>, or
        /// <code>ROLLED_BACK</code>
        /// </p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::EnvironmentState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Appends an item to `monitors`.
        ///
        /// To override the contents of this collection use [`set_monitors`](Self::set_monitors).
        ///
        /// <p>Amazon CloudWatch alarms monitored during the deployment.</p>
        pub fn monitors(mut self, input: impl Into<crate::model::Monitor>) -> Self {
            let mut v = self.monitors.unwrap_or_default();
            v.push(input.into());
            self.monitors = Some(v);
            self
        }
        /// <p>Amazon CloudWatch alarms monitored during the deployment.</p>
        pub fn set_monitors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Monitor>>,
        ) -> Self {
            self.monitors = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateEnvironmentOutput`](crate::output::CreateEnvironmentOutput)
        pub fn build(self) -> crate::output::CreateEnvironmentOutput {
            crate::output::CreateEnvironmentOutput {
                application_id: self.application_id,
                id: self.id,
                name: self.name,
                description: self.description,
                state: self.state,
                monitors: self.monitors,
            }
        }
    }
}
impl CreateEnvironmentOutput {
    /// Creates a new builder-style object to manufacture [`CreateEnvironmentOutput`](crate::output::CreateEnvironmentOutput)
    pub fn builder() -> crate::output::create_environment_output::Builder {
        crate::output::create_environment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDeploymentStrategyOutput {
    /// <p>The deployment strategy ID.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the deployment strategy.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the deployment strategy.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Total amount of time the deployment lasted.</p>
    pub deployment_duration_in_minutes: i32,
    /// <p>The algorithm used to define how percentage grew over time.</p>
    pub growth_type: std::option::Option<crate::model::GrowthType>,
    /// <p>The percentage of targets that received a deployed configuration during each
    /// interval.</p>
    pub growth_factor: f32,
    /// <p>The amount of time AppConfig monitored for alarms before considering the deployment to be
    /// complete and no longer eligible for automatic roll back.</p>
    pub final_bake_time_in_minutes: i32,
    /// <p>Save the deployment strategy to a Systems Manager (SSM) document.</p>
    pub replicate_to: std::option::Option<crate::model::ReplicateTo>,
}
impl std::fmt::Debug for CreateDeploymentStrategyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDeploymentStrategyOutput");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field(
            "deployment_duration_in_minutes",
            &self.deployment_duration_in_minutes,
        );
        formatter.field("growth_type", &self.growth_type);
        formatter.field("growth_factor", &self.growth_factor);
        formatter.field(
            "final_bake_time_in_minutes",
            &self.final_bake_time_in_minutes,
        );
        formatter.field("replicate_to", &self.replicate_to);
        formatter.finish()
    }
}
/// See [`CreateDeploymentStrategyOutput`](crate::output::CreateDeploymentStrategyOutput)
pub mod create_deployment_strategy_output {
    /// A builder for [`CreateDeploymentStrategyOutput`](crate::output::CreateDeploymentStrategyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) deployment_duration_in_minutes: std::option::Option<i32>,
        pub(crate) growth_type: std::option::Option<crate::model::GrowthType>,
        pub(crate) growth_factor: std::option::Option<f32>,
        pub(crate) final_bake_time_in_minutes: std::option::Option<i32>,
        pub(crate) replicate_to: std::option::Option<crate::model::ReplicateTo>,
    }
    impl Builder {
        /// <p>The deployment strategy ID.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The deployment strategy ID.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the deployment strategy.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the deployment strategy.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the deployment strategy.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the deployment strategy.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Total amount of time the deployment lasted.</p>
        pub fn deployment_duration_in_minutes(mut self, input: i32) -> Self {
            self.deployment_duration_in_minutes = Some(input);
            self
        }
        /// <p>Total amount of time the deployment lasted.</p>
        pub fn set_deployment_duration_in_minutes(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.deployment_duration_in_minutes = input;
            self
        }
        /// <p>The algorithm used to define how percentage grew over time.</p>
        pub fn growth_type(mut self, input: crate::model::GrowthType) -> Self {
            self.growth_type = Some(input);
            self
        }
        /// <p>The algorithm used to define how percentage grew over time.</p>
        pub fn set_growth_type(
            mut self,
            input: std::option::Option<crate::model::GrowthType>,
        ) -> Self {
            self.growth_type = input;
            self
        }
        /// <p>The percentage of targets that received a deployed configuration during each
        /// interval.</p>
        pub fn growth_factor(mut self, input: f32) -> Self {
            self.growth_factor = Some(input);
            self
        }
        /// <p>The percentage of targets that received a deployed configuration during each
        /// interval.</p>
        pub fn set_growth_factor(mut self, input: std::option::Option<f32>) -> Self {
            self.growth_factor = input;
            self
        }
        /// <p>The amount of time AppConfig monitored for alarms before considering the deployment to be
        /// complete and no longer eligible for automatic roll back.</p>
        pub fn final_bake_time_in_minutes(mut self, input: i32) -> Self {
            self.final_bake_time_in_minutes = Some(input);
            self
        }
        /// <p>The amount of time AppConfig monitored for alarms before considering the deployment to be
        /// complete and no longer eligible for automatic roll back.</p>
        pub fn set_final_bake_time_in_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.final_bake_time_in_minutes = input;
            self
        }
        /// <p>Save the deployment strategy to a Systems Manager (SSM) document.</p>
        pub fn replicate_to(mut self, input: crate::model::ReplicateTo) -> Self {
            self.replicate_to = Some(input);
            self
        }
        /// <p>Save the deployment strategy to a Systems Manager (SSM) document.</p>
        pub fn set_replicate_to(
            mut self,
            input: std::option::Option<crate::model::ReplicateTo>,
        ) -> Self {
            self.replicate_to = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDeploymentStrategyOutput`](crate::output::CreateDeploymentStrategyOutput)
        pub fn build(self) -> crate::output::CreateDeploymentStrategyOutput {
            crate::output::CreateDeploymentStrategyOutput {
                id: self.id,
                name: self.name,
                description: self.description,
                deployment_duration_in_minutes: self
                    .deployment_duration_in_minutes
                    .unwrap_or_default(),
                growth_type: self.growth_type,
                growth_factor: self.growth_factor.unwrap_or_default(),
                final_bake_time_in_minutes: self.final_bake_time_in_minutes.unwrap_or_default(),
                replicate_to: self.replicate_to,
            }
        }
    }
}
impl CreateDeploymentStrategyOutput {
    /// Creates a new builder-style object to manufacture [`CreateDeploymentStrategyOutput`](crate::output::CreateDeploymentStrategyOutput)
    pub fn builder() -> crate::output::create_deployment_strategy_output::Builder {
        crate::output::create_deployment_strategy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateConfigurationProfileOutput {
    /// <p>The application ID.</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The configuration profile ID.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the configuration profile.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The configuration profile description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The URI location of the configuration.</p>
    pub location_uri: std::option::Option<std::string::String>,
    /// <p>The ARN of an IAM role with permission to access the configuration at the specified
    /// LocationUri.</p>
    pub retrieval_role_arn: std::option::Option<std::string::String>,
    /// <p>A list of methods for validating the configuration.</p>
    pub validators: std::option::Option<std::vec::Vec<crate::model::Validator>>,
}
impl std::fmt::Debug for CreateConfigurationProfileOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateConfigurationProfileOutput");
        formatter.field("application_id", &self.application_id);
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("location_uri", &self.location_uri);
        formatter.field("retrieval_role_arn", &self.retrieval_role_arn);
        formatter.field("validators", &self.validators);
        formatter.finish()
    }
}
/// See [`CreateConfigurationProfileOutput`](crate::output::CreateConfigurationProfileOutput)
pub mod create_configuration_profile_output {
    /// A builder for [`CreateConfigurationProfileOutput`](crate::output::CreateConfigurationProfileOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) location_uri: std::option::Option<std::string::String>,
        pub(crate) retrieval_role_arn: std::option::Option<std::string::String>,
        pub(crate) validators: std::option::Option<std::vec::Vec<crate::model::Validator>>,
    }
    impl Builder {
        /// <p>The application ID.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The application ID.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The configuration profile ID.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The configuration profile ID.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the configuration profile.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the configuration profile.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The configuration profile description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The configuration profile description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The URI location of the configuration.</p>
        pub fn location_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.location_uri = Some(input.into());
            self
        }
        /// <p>The URI location of the configuration.</p>
        pub fn set_location_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location_uri = input;
            self
        }
        /// <p>The ARN of an IAM role with permission to access the configuration at the specified
        /// LocationUri.</p>
        pub fn retrieval_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.retrieval_role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of an IAM role with permission to access the configuration at the specified
        /// LocationUri.</p>
        pub fn set_retrieval_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.retrieval_role_arn = input;
            self
        }
        /// Appends an item to `validators`.
        ///
        /// To override the contents of this collection use [`set_validators`](Self::set_validators).
        ///
        /// <p>A list of methods for validating the configuration.</p>
        pub fn validators(mut self, input: impl Into<crate::model::Validator>) -> Self {
            let mut v = self.validators.unwrap_or_default();
            v.push(input.into());
            self.validators = Some(v);
            self
        }
        /// <p>A list of methods for validating the configuration.</p>
        pub fn set_validators(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Validator>>,
        ) -> Self {
            self.validators = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateConfigurationProfileOutput`](crate::output::CreateConfigurationProfileOutput)
        pub fn build(self) -> crate::output::CreateConfigurationProfileOutput {
            crate::output::CreateConfigurationProfileOutput {
                application_id: self.application_id,
                id: self.id,
                name: self.name,
                description: self.description,
                location_uri: self.location_uri,
                retrieval_role_arn: self.retrieval_role_arn,
                validators: self.validators,
            }
        }
    }
}
impl CreateConfigurationProfileOutput {
    /// Creates a new builder-style object to manufacture [`CreateConfigurationProfileOutput`](crate::output::CreateConfigurationProfileOutput)
    pub fn builder() -> crate::output::create_configuration_profile_output::Builder {
        crate::output::create_configuration_profile_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateApplicationOutput {
    /// <p>The application ID.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The application name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the application.</p>
    pub description: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateApplicationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateApplicationOutput");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`CreateApplicationOutput`](crate::output::CreateApplicationOutput)
pub mod create_application_output {
    /// A builder for [`CreateApplicationOutput`](crate::output::CreateApplicationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The application ID.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The application ID.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The application name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The application name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the application.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the application.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateApplicationOutput`](crate::output::CreateApplicationOutput)
        pub fn build(self) -> crate::output::CreateApplicationOutput {
            crate::output::CreateApplicationOutput {
                id: self.id,
                name: self.name,
                description: self.description,
            }
        }
    }
}
impl CreateApplicationOutput {
    /// Creates a new builder-style object to manufacture [`CreateApplicationOutput`](crate::output::CreateApplicationOutput)
    pub fn builder() -> crate::output::create_application_output::Builder {
        crate::output::create_application_output::Builder::default()
    }
}
