// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Amazon CloudWatch alarms to monitor during the deployment process.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Monitor {
    /// <p>ARN of the Amazon CloudWatch alarm.</p>
    pub alarm_arn: std::option::Option<std::string::String>,
    /// <p>ARN of an IAM role for AppConfig to monitor <code>AlarmArn</code>.</p>
    pub alarm_role_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Monitor {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Monitor");
        formatter.field("alarm_arn", &self.alarm_arn);
        formatter.field("alarm_role_arn", &self.alarm_role_arn);
        formatter.finish()
    }
}
/// See [`Monitor`](crate::model::Monitor)
pub mod monitor {
    /// A builder for [`Monitor`](crate::model::Monitor)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alarm_arn: std::option::Option<std::string::String>,
        pub(crate) alarm_role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>ARN of the Amazon CloudWatch alarm.</p>
        pub fn alarm_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.alarm_arn = Some(input.into());
            self
        }
        /// <p>ARN of the Amazon CloudWatch alarm.</p>
        pub fn set_alarm_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alarm_arn = input;
            self
        }
        /// <p>ARN of an IAM role for AppConfig to monitor <code>AlarmArn</code>.</p>
        pub fn alarm_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.alarm_role_arn = Some(input.into());
            self
        }
        /// <p>ARN of an IAM role for AppConfig to monitor <code>AlarmArn</code>.</p>
        pub fn set_alarm_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.alarm_role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`Monitor`](crate::model::Monitor)
        pub fn build(self) -> crate::model::Monitor {
            crate::model::Monitor {
                alarm_arn: self.alarm_arn,
                alarm_role_arn: self.alarm_role_arn,
            }
        }
    }
}
impl Monitor {
    /// Creates a new builder-style object to manufacture [`Monitor`](crate::model::Monitor)
    pub fn builder() -> crate::model::monitor::Builder {
        crate::model::monitor::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EnvironmentState {
    #[allow(missing_docs)] // documentation missing in model
    Deploying,
    #[allow(missing_docs)] // documentation missing in model
    ReadyForDeployment,
    #[allow(missing_docs)] // documentation missing in model
    RolledBack,
    #[allow(missing_docs)] // documentation missing in model
    RollingBack,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EnvironmentState {
    fn from(s: &str) -> Self {
        match s {
            "DEPLOYING" => EnvironmentState::Deploying,
            "READY_FOR_DEPLOYMENT" => EnvironmentState::ReadyForDeployment,
            "ROLLED_BACK" => EnvironmentState::RolledBack,
            "ROLLING_BACK" => EnvironmentState::RollingBack,
            other => EnvironmentState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EnvironmentState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EnvironmentState::from(s))
    }
}
impl EnvironmentState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EnvironmentState::Deploying => "DEPLOYING",
            EnvironmentState::ReadyForDeployment => "READY_FOR_DEPLOYMENT",
            EnvironmentState::RolledBack => "ROLLED_BACK",
            EnvironmentState::RollingBack => "ROLLING_BACK",
            EnvironmentState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DEPLOYING",
            "READY_FOR_DEPLOYMENT",
            "ROLLED_BACK",
            "ROLLING_BACK",
        ]
    }
}
impl AsRef<str> for EnvironmentState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReplicateTo {
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    SsmDocument,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReplicateTo {
    fn from(s: &str) -> Self {
        match s {
            "NONE" => ReplicateTo::None,
            "SSM_DOCUMENT" => ReplicateTo::SsmDocument,
            other => ReplicateTo::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReplicateTo {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReplicateTo::from(s))
    }
}
impl ReplicateTo {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReplicateTo::None => "NONE",
            ReplicateTo::SsmDocument => "SSM_DOCUMENT",
            ReplicateTo::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NONE", "SSM_DOCUMENT"]
    }
}
impl AsRef<str> for ReplicateTo {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum GrowthType {
    #[allow(missing_docs)] // documentation missing in model
    Exponential,
    #[allow(missing_docs)] // documentation missing in model
    Linear,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for GrowthType {
    fn from(s: &str) -> Self {
        match s {
            "EXPONENTIAL" => GrowthType::Exponential,
            "LINEAR" => GrowthType::Linear,
            other => GrowthType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for GrowthType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(GrowthType::from(s))
    }
}
impl GrowthType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            GrowthType::Exponential => "EXPONENTIAL",
            GrowthType::Linear => "LINEAR",
            GrowthType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["EXPONENTIAL", "LINEAR"]
    }
}
impl AsRef<str> for GrowthType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A validator provides a syntactic or semantic check to ensure the configuration you want
/// to deploy functions as intended. To validate your application configuration data, you
/// provide a schema or a Lambda function that runs against the configuration. The
/// configuration deployment or update can only proceed when the configuration data is
/// valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Validator {
    /// <p>AppConfig supports validators of type <code>JSON_SCHEMA</code> and
    /// <code>LAMBDA</code>
    /// </p>
    pub r#type: std::option::Option<crate::model::ValidatorType>,
    /// <p>Either the JSON Schema content or the Amazon Resource Name (ARN) of an AWS Lambda
    /// function.</p>
    pub content: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Validator {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Validator");
        formatter.field("r#type", &self.r#type);
        formatter.field("content", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`Validator`](crate::model::Validator)
pub mod validator {
    /// A builder for [`Validator`](crate::model::Validator)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::ValidatorType>,
        pub(crate) content: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>AppConfig supports validators of type <code>JSON_SCHEMA</code> and
        /// <code>LAMBDA</code>
        /// </p>
        pub fn r#type(mut self, input: crate::model::ValidatorType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>AppConfig supports validators of type <code>JSON_SCHEMA</code> and
        /// <code>LAMBDA</code>
        /// </p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ValidatorType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>Either the JSON Schema content or the Amazon Resource Name (ARN) of an AWS Lambda
        /// function.</p>
        pub fn content(mut self, input: impl Into<std::string::String>) -> Self {
            self.content = Some(input.into());
            self
        }
        /// <p>Either the JSON Schema content or the Amazon Resource Name (ARN) of an AWS Lambda
        /// function.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content = input;
            self
        }
        /// Consumes the builder and constructs a [`Validator`](crate::model::Validator)
        pub fn build(self) -> crate::model::Validator {
            crate::model::Validator {
                r#type: self.r#type,
                content: self.content,
            }
        }
    }
}
impl Validator {
    /// Creates a new builder-style object to manufacture [`Validator`](crate::model::Validator)
    pub fn builder() -> crate::model::validator::Builder {
        crate::model::validator::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ValidatorType {
    #[allow(missing_docs)] // documentation missing in model
    JsonSchema,
    #[allow(missing_docs)] // documentation missing in model
    Lambda,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ValidatorType {
    fn from(s: &str) -> Self {
        match s {
            "JSON_SCHEMA" => ValidatorType::JsonSchema,
            "LAMBDA" => ValidatorType::Lambda,
            other => ValidatorType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ValidatorType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ValidatorType::from(s))
    }
}
impl ValidatorType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ValidatorType::JsonSchema => "JSON_SCHEMA",
            ValidatorType::Lambda => "LAMBDA",
            ValidatorType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["JSON_SCHEMA", "LAMBDA"]
    }
}
impl AsRef<str> for ValidatorType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that describes a deployment event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeploymentEvent {
    /// <p>The type of deployment event. Deployment event types include the start, stop, or
    /// completion of a deployment; a percentage update; the start or stop of a bake period; the
    /// start or completion of a rollback.</p>
    pub event_type: std::option::Option<crate::model::DeploymentEventType>,
    /// <p>The entity that triggered the deployment event. Events can be triggered by a user, AWS
    /// AppConfig, an Amazon CloudWatch alarm, or an internal error.</p>
    pub triggered_by: std::option::Option<crate::model::TriggeredBy>,
    /// <p>A description of the deployment event. Descriptions include, but are not limited to, the
    /// user account or the CloudWatch alarm ARN that initiated a rollback, the percentage of hosts
    /// that received the deployment, or in the case of an internal error, a recommendation to
    /// attempt a new deployment.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The date and time the event occurred.</p>
    pub occurred_at: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for DeploymentEvent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeploymentEvent");
        formatter.field("event_type", &self.event_type);
        formatter.field("triggered_by", &self.triggered_by);
        formatter.field("description", &self.description);
        formatter.field("occurred_at", &self.occurred_at);
        formatter.finish()
    }
}
/// See [`DeploymentEvent`](crate::model::DeploymentEvent)
pub mod deployment_event {
    /// A builder for [`DeploymentEvent`](crate::model::DeploymentEvent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_type: std::option::Option<crate::model::DeploymentEventType>,
        pub(crate) triggered_by: std::option::Option<crate::model::TriggeredBy>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) occurred_at: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The type of deployment event. Deployment event types include the start, stop, or
        /// completion of a deployment; a percentage update; the start or stop of a bake period; the
        /// start or completion of a rollback.</p>
        pub fn event_type(mut self, input: crate::model::DeploymentEventType) -> Self {
            self.event_type = Some(input);
            self
        }
        /// <p>The type of deployment event. Deployment event types include the start, stop, or
        /// completion of a deployment; a percentage update; the start or stop of a bake period; the
        /// start or completion of a rollback.</p>
        pub fn set_event_type(
            mut self,
            input: std::option::Option<crate::model::DeploymentEventType>,
        ) -> Self {
            self.event_type = input;
            self
        }
        /// <p>The entity that triggered the deployment event. Events can be triggered by a user, AWS
        /// AppConfig, an Amazon CloudWatch alarm, or an internal error.</p>
        pub fn triggered_by(mut self, input: crate::model::TriggeredBy) -> Self {
            self.triggered_by = Some(input);
            self
        }
        /// <p>The entity that triggered the deployment event. Events can be triggered by a user, AWS
        /// AppConfig, an Amazon CloudWatch alarm, or an internal error.</p>
        pub fn set_triggered_by(
            mut self,
            input: std::option::Option<crate::model::TriggeredBy>,
        ) -> Self {
            self.triggered_by = input;
            self
        }
        /// <p>A description of the deployment event. Descriptions include, but are not limited to, the
        /// user account or the CloudWatch alarm ARN that initiated a rollback, the percentage of hosts
        /// that received the deployment, or in the case of an internal error, a recommendation to
        /// attempt a new deployment.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the deployment event. Descriptions include, but are not limited to, the
        /// user account or the CloudWatch alarm ARN that initiated a rollback, the percentage of hosts
        /// that received the deployment, or in the case of an internal error, a recommendation to
        /// attempt a new deployment.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The date and time the event occurred.</p>
        pub fn occurred_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.occurred_at = Some(input);
            self
        }
        /// <p>The date and time the event occurred.</p>
        pub fn set_occurred_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.occurred_at = input;
            self
        }
        /// Consumes the builder and constructs a [`DeploymentEvent`](crate::model::DeploymentEvent)
        pub fn build(self) -> crate::model::DeploymentEvent {
            crate::model::DeploymentEvent {
                event_type: self.event_type,
                triggered_by: self.triggered_by,
                description: self.description,
                occurred_at: self.occurred_at,
            }
        }
    }
}
impl DeploymentEvent {
    /// Creates a new builder-style object to manufacture [`DeploymentEvent`](crate::model::DeploymentEvent)
    pub fn builder() -> crate::model::deployment_event::Builder {
        crate::model::deployment_event::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TriggeredBy {
    #[allow(missing_docs)] // documentation missing in model
    Appconfig,
    #[allow(missing_docs)] // documentation missing in model
    CloudwatchAlarm,
    #[allow(missing_docs)] // documentation missing in model
    InternalError,
    #[allow(missing_docs)] // documentation missing in model
    User,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TriggeredBy {
    fn from(s: &str) -> Self {
        match s {
            "APPCONFIG" => TriggeredBy::Appconfig,
            "CLOUDWATCH_ALARM" => TriggeredBy::CloudwatchAlarm,
            "INTERNAL_ERROR" => TriggeredBy::InternalError,
            "USER" => TriggeredBy::User,
            other => TriggeredBy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TriggeredBy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TriggeredBy::from(s))
    }
}
impl TriggeredBy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TriggeredBy::Appconfig => "APPCONFIG",
            TriggeredBy::CloudwatchAlarm => "CLOUDWATCH_ALARM",
            TriggeredBy::InternalError => "INTERNAL_ERROR",
            TriggeredBy::User => "USER",
            TriggeredBy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["APPCONFIG", "CLOUDWATCH_ALARM", "INTERNAL_ERROR", "USER"]
    }
}
impl AsRef<str> for TriggeredBy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeploymentEventType {
    #[allow(missing_docs)] // documentation missing in model
    BakeTimeStarted,
    #[allow(missing_docs)] // documentation missing in model
    DeploymentCompleted,
    #[allow(missing_docs)] // documentation missing in model
    DeploymentStarted,
    #[allow(missing_docs)] // documentation missing in model
    PercentageUpdated,
    #[allow(missing_docs)] // documentation missing in model
    RollbackCompleted,
    #[allow(missing_docs)] // documentation missing in model
    RollbackStarted,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeploymentEventType {
    fn from(s: &str) -> Self {
        match s {
            "BAKE_TIME_STARTED" => DeploymentEventType::BakeTimeStarted,
            "DEPLOYMENT_COMPLETED" => DeploymentEventType::DeploymentCompleted,
            "DEPLOYMENT_STARTED" => DeploymentEventType::DeploymentStarted,
            "PERCENTAGE_UPDATED" => DeploymentEventType::PercentageUpdated,
            "ROLLBACK_COMPLETED" => DeploymentEventType::RollbackCompleted,
            "ROLLBACK_STARTED" => DeploymentEventType::RollbackStarted,
            other => DeploymentEventType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeploymentEventType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeploymentEventType::from(s))
    }
}
impl DeploymentEventType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeploymentEventType::BakeTimeStarted => "BAKE_TIME_STARTED",
            DeploymentEventType::DeploymentCompleted => "DEPLOYMENT_COMPLETED",
            DeploymentEventType::DeploymentStarted => "DEPLOYMENT_STARTED",
            DeploymentEventType::PercentageUpdated => "PERCENTAGE_UPDATED",
            DeploymentEventType::RollbackCompleted => "ROLLBACK_COMPLETED",
            DeploymentEventType::RollbackStarted => "ROLLBACK_STARTED",
            DeploymentEventType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BAKE_TIME_STARTED",
            "DEPLOYMENT_COMPLETED",
            "DEPLOYMENT_STARTED",
            "PERCENTAGE_UPDATED",
            "ROLLBACK_COMPLETED",
            "ROLLBACK_STARTED",
        ]
    }
}
impl AsRef<str> for DeploymentEventType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeploymentState {
    #[allow(missing_docs)] // documentation missing in model
    Baking,
    #[allow(missing_docs)] // documentation missing in model
    Complete,
    #[allow(missing_docs)] // documentation missing in model
    Deploying,
    #[allow(missing_docs)] // documentation missing in model
    RolledBack,
    #[allow(missing_docs)] // documentation missing in model
    RollingBack,
    #[allow(missing_docs)] // documentation missing in model
    Validating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeploymentState {
    fn from(s: &str) -> Self {
        match s {
            "BAKING" => DeploymentState::Baking,
            "COMPLETE" => DeploymentState::Complete,
            "DEPLOYING" => DeploymentState::Deploying,
            "ROLLED_BACK" => DeploymentState::RolledBack,
            "ROLLING_BACK" => DeploymentState::RollingBack,
            "VALIDATING" => DeploymentState::Validating,
            other => DeploymentState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeploymentState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeploymentState::from(s))
    }
}
impl DeploymentState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeploymentState::Baking => "BAKING",
            DeploymentState::Complete => "COMPLETE",
            DeploymentState::Deploying => "DEPLOYING",
            DeploymentState::RolledBack => "ROLLED_BACK",
            DeploymentState::RollingBack => "ROLLING_BACK",
            DeploymentState::Validating => "VALIDATING",
            DeploymentState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BAKING",
            "COMPLETE",
            "DEPLOYING",
            "ROLLED_BACK",
            "ROLLING_BACK",
            "VALIDATING",
        ]
    }
}
impl AsRef<str> for DeploymentState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about the configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HostedConfigurationVersionSummary {
    /// <p>The application ID.</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The configuration profile ID.</p>
    pub configuration_profile_id: std::option::Option<std::string::String>,
    /// <p>The configuration version.</p>
    pub version_number: i32,
    /// <p>A description of the configuration.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A standard MIME type describing the format of the configuration content. For more
    /// information, see <a href="https://docs.aws.amazon.com/https:/www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17">Content-Type</a>.</p>
    pub content_type: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for HostedConfigurationVersionSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HostedConfigurationVersionSummary");
        formatter.field("application_id", &self.application_id);
        formatter.field("configuration_profile_id", &self.configuration_profile_id);
        formatter.field("version_number", &self.version_number);
        formatter.field("description", &self.description);
        formatter.field("content_type", &self.content_type);
        formatter.finish()
    }
}
/// See [`HostedConfigurationVersionSummary`](crate::model::HostedConfigurationVersionSummary)
pub mod hosted_configuration_version_summary {
    /// A builder for [`HostedConfigurationVersionSummary`](crate::model::HostedConfigurationVersionSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) configuration_profile_id: std::option::Option<std::string::String>,
        pub(crate) version_number: std::option::Option<i32>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) content_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The application ID.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The application ID.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The configuration profile ID.</p>
        pub fn configuration_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_profile_id = Some(input.into());
            self
        }
        /// <p>The configuration profile ID.</p>
        pub fn set_configuration_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_profile_id = input;
            self
        }
        /// <p>The configuration version.</p>
        pub fn version_number(mut self, input: i32) -> Self {
            self.version_number = Some(input);
            self
        }
        /// <p>The configuration version.</p>
        pub fn set_version_number(mut self, input: std::option::Option<i32>) -> Self {
            self.version_number = input;
            self
        }
        /// <p>A description of the configuration.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the configuration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>A standard MIME type describing the format of the configuration content. For more
        /// information, see <a href="https://docs.aws.amazon.com/https:/www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17">Content-Type</a>.</p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_type = Some(input.into());
            self
        }
        /// <p>A standard MIME type describing the format of the configuration content. For more
        /// information, see <a href="https://docs.aws.amazon.com/https:/www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17">Content-Type</a>.</p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_type = input;
            self
        }
        /// Consumes the builder and constructs a [`HostedConfigurationVersionSummary`](crate::model::HostedConfigurationVersionSummary)
        pub fn build(self) -> crate::model::HostedConfigurationVersionSummary {
            crate::model::HostedConfigurationVersionSummary {
                application_id: self.application_id,
                configuration_profile_id: self.configuration_profile_id,
                version_number: self.version_number.unwrap_or_default(),
                description: self.description,
                content_type: self.content_type,
            }
        }
    }
}
impl HostedConfigurationVersionSummary {
    /// Creates a new builder-style object to manufacture [`HostedConfigurationVersionSummary`](crate::model::HostedConfigurationVersionSummary)
    pub fn builder() -> crate::model::hosted_configuration_version_summary::Builder {
        crate::model::hosted_configuration_version_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Environment {
    /// <p>The application ID.</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The environment ID.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the environment.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the environment.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The state of the environment. An environment can be in one of the following states:
    /// <code>READY_FOR_DEPLOYMENT</code>, <code>DEPLOYING</code>, <code>ROLLING_BACK</code>, or
    /// <code>ROLLED_BACK</code>
    /// </p>
    pub state: std::option::Option<crate::model::EnvironmentState>,
    /// <p>Amazon CloudWatch alarms monitored during the deployment.</p>
    pub monitors: std::option::Option<std::vec::Vec<crate::model::Monitor>>,
}
impl std::fmt::Debug for Environment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Environment");
        formatter.field("application_id", &self.application_id);
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("state", &self.state);
        formatter.field("monitors", &self.monitors);
        formatter.finish()
    }
}
/// See [`Environment`](crate::model::Environment)
pub mod environment {
    /// A builder for [`Environment`](crate::model::Environment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::EnvironmentState>,
        pub(crate) monitors: std::option::Option<std::vec::Vec<crate::model::Monitor>>,
    }
    impl Builder {
        /// <p>The application ID.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The application ID.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The environment ID.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The environment ID.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the environment.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the environment.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the environment.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the environment.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The state of the environment. An environment can be in one of the following states:
        /// <code>READY_FOR_DEPLOYMENT</code>, <code>DEPLOYING</code>, <code>ROLLING_BACK</code>, or
        /// <code>ROLLED_BACK</code>
        /// </p>
        pub fn state(mut self, input: crate::model::EnvironmentState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the environment. An environment can be in one of the following states:
        /// <code>READY_FOR_DEPLOYMENT</code>, <code>DEPLOYING</code>, <code>ROLLING_BACK</code>, or
        /// <code>ROLLED_BACK</code>
        /// </p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::EnvironmentState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Appends an item to `monitors`.
        ///
        /// To override the contents of this collection use [`set_monitors`](Self::set_monitors).
        ///
        /// <p>Amazon CloudWatch alarms monitored during the deployment.</p>
        pub fn monitors(mut self, input: impl Into<crate::model::Monitor>) -> Self {
            let mut v = self.monitors.unwrap_or_default();
            v.push(input.into());
            self.monitors = Some(v);
            self
        }
        /// <p>Amazon CloudWatch alarms monitored during the deployment.</p>
        pub fn set_monitors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Monitor>>,
        ) -> Self {
            self.monitors = input;
            self
        }
        /// Consumes the builder and constructs a [`Environment`](crate::model::Environment)
        pub fn build(self) -> crate::model::Environment {
            crate::model::Environment {
                application_id: self.application_id,
                id: self.id,
                name: self.name,
                description: self.description,
                state: self.state,
                monitors: self.monitors,
            }
        }
    }
}
impl Environment {
    /// Creates a new builder-style object to manufacture [`Environment`](crate::model::Environment)
    pub fn builder() -> crate::model::environment::Builder {
        crate::model::environment::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeploymentStrategy {
    /// <p>The deployment strategy ID.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the deployment strategy.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the deployment strategy.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Total amount of time the deployment lasted.</p>
    pub deployment_duration_in_minutes: i32,
    /// <p>The algorithm used to define how percentage grew over time.</p>
    pub growth_type: std::option::Option<crate::model::GrowthType>,
    /// <p>The percentage of targets that received a deployed configuration during each
    /// interval.</p>
    pub growth_factor: f32,
    /// <p>The amount of time AppConfig monitored for alarms before considering the deployment to be
    /// complete and no longer eligible for automatic roll back.</p>
    pub final_bake_time_in_minutes: i32,
    /// <p>Save the deployment strategy to a Systems Manager (SSM) document.</p>
    pub replicate_to: std::option::Option<crate::model::ReplicateTo>,
}
impl std::fmt::Debug for DeploymentStrategy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeploymentStrategy");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field(
            "deployment_duration_in_minutes",
            &self.deployment_duration_in_minutes,
        );
        formatter.field("growth_type", &self.growth_type);
        formatter.field("growth_factor", &self.growth_factor);
        formatter.field(
            "final_bake_time_in_minutes",
            &self.final_bake_time_in_minutes,
        );
        formatter.field("replicate_to", &self.replicate_to);
        formatter.finish()
    }
}
/// See [`DeploymentStrategy`](crate::model::DeploymentStrategy)
pub mod deployment_strategy {
    /// A builder for [`DeploymentStrategy`](crate::model::DeploymentStrategy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) deployment_duration_in_minutes: std::option::Option<i32>,
        pub(crate) growth_type: std::option::Option<crate::model::GrowthType>,
        pub(crate) growth_factor: std::option::Option<f32>,
        pub(crate) final_bake_time_in_minutes: std::option::Option<i32>,
        pub(crate) replicate_to: std::option::Option<crate::model::ReplicateTo>,
    }
    impl Builder {
        /// <p>The deployment strategy ID.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The deployment strategy ID.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the deployment strategy.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the deployment strategy.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the deployment strategy.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the deployment strategy.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Total amount of time the deployment lasted.</p>
        pub fn deployment_duration_in_minutes(mut self, input: i32) -> Self {
            self.deployment_duration_in_minutes = Some(input);
            self
        }
        /// <p>Total amount of time the deployment lasted.</p>
        pub fn set_deployment_duration_in_minutes(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.deployment_duration_in_minutes = input;
            self
        }
        /// <p>The algorithm used to define how percentage grew over time.</p>
        pub fn growth_type(mut self, input: crate::model::GrowthType) -> Self {
            self.growth_type = Some(input);
            self
        }
        /// <p>The algorithm used to define how percentage grew over time.</p>
        pub fn set_growth_type(
            mut self,
            input: std::option::Option<crate::model::GrowthType>,
        ) -> Self {
            self.growth_type = input;
            self
        }
        /// <p>The percentage of targets that received a deployed configuration during each
        /// interval.</p>
        pub fn growth_factor(mut self, input: f32) -> Self {
            self.growth_factor = Some(input);
            self
        }
        /// <p>The percentage of targets that received a deployed configuration during each
        /// interval.</p>
        pub fn set_growth_factor(mut self, input: std::option::Option<f32>) -> Self {
            self.growth_factor = input;
            self
        }
        /// <p>The amount of time AppConfig monitored for alarms before considering the deployment to be
        /// complete and no longer eligible for automatic roll back.</p>
        pub fn final_bake_time_in_minutes(mut self, input: i32) -> Self {
            self.final_bake_time_in_minutes = Some(input);
            self
        }
        /// <p>The amount of time AppConfig monitored for alarms before considering the deployment to be
        /// complete and no longer eligible for automatic roll back.</p>
        pub fn set_final_bake_time_in_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.final_bake_time_in_minutes = input;
            self
        }
        /// <p>Save the deployment strategy to a Systems Manager (SSM) document.</p>
        pub fn replicate_to(mut self, input: crate::model::ReplicateTo) -> Self {
            self.replicate_to = Some(input);
            self
        }
        /// <p>Save the deployment strategy to a Systems Manager (SSM) document.</p>
        pub fn set_replicate_to(
            mut self,
            input: std::option::Option<crate::model::ReplicateTo>,
        ) -> Self {
            self.replicate_to = input;
            self
        }
        /// Consumes the builder and constructs a [`DeploymentStrategy`](crate::model::DeploymentStrategy)
        pub fn build(self) -> crate::model::DeploymentStrategy {
            crate::model::DeploymentStrategy {
                id: self.id,
                name: self.name,
                description: self.description,
                deployment_duration_in_minutes: self
                    .deployment_duration_in_minutes
                    .unwrap_or_default(),
                growth_type: self.growth_type,
                growth_factor: self.growth_factor.unwrap_or_default(),
                final_bake_time_in_minutes: self.final_bake_time_in_minutes.unwrap_or_default(),
                replicate_to: self.replicate_to,
            }
        }
    }
}
impl DeploymentStrategy {
    /// Creates a new builder-style object to manufacture [`DeploymentStrategy`](crate::model::DeploymentStrategy)
    pub fn builder() -> crate::model::deployment_strategy::Builder {
        crate::model::deployment_strategy::Builder::default()
    }
}

/// <p>Information about the deployment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeploymentSummary {
    /// <p>The sequence number of the deployment.</p>
    pub deployment_number: i32,
    /// <p>The name of the configuration.</p>
    pub configuration_name: std::option::Option<std::string::String>,
    /// <p>The version of the configuration.</p>
    pub configuration_version: std::option::Option<std::string::String>,
    /// <p>Total amount of time the deployment lasted.</p>
    pub deployment_duration_in_minutes: i32,
    /// <p>The algorithm used to define how percentage grows over time.</p>
    pub growth_type: std::option::Option<crate::model::GrowthType>,
    /// <p>The percentage of targets to receive a deployed configuration during each
    /// interval.</p>
    pub growth_factor: f32,
    /// <p>The amount of time AppConfig monitors for alarms before considering the deployment to be
    /// complete and no longer eligible for automatic roll back.</p>
    pub final_bake_time_in_minutes: i32,
    /// <p>The state of the deployment.</p>
    pub state: std::option::Option<crate::model::DeploymentState>,
    /// <p>The percentage of targets for which the deployment is available.</p>
    pub percentage_complete: f32,
    /// <p>Time the deployment started.</p>
    pub started_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Time the deployment completed.</p>
    pub completed_at: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for DeploymentSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeploymentSummary");
        formatter.field("deployment_number", &self.deployment_number);
        formatter.field("configuration_name", &self.configuration_name);
        formatter.field("configuration_version", &self.configuration_version);
        formatter.field(
            "deployment_duration_in_minutes",
            &self.deployment_duration_in_minutes,
        );
        formatter.field("growth_type", &self.growth_type);
        formatter.field("growth_factor", &self.growth_factor);
        formatter.field(
            "final_bake_time_in_minutes",
            &self.final_bake_time_in_minutes,
        );
        formatter.field("state", &self.state);
        formatter.field("percentage_complete", &self.percentage_complete);
        formatter.field("started_at", &self.started_at);
        formatter.field("completed_at", &self.completed_at);
        formatter.finish()
    }
}
/// See [`DeploymentSummary`](crate::model::DeploymentSummary)
pub mod deployment_summary {
    /// A builder for [`DeploymentSummary`](crate::model::DeploymentSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deployment_number: std::option::Option<i32>,
        pub(crate) configuration_name: std::option::Option<std::string::String>,
        pub(crate) configuration_version: std::option::Option<std::string::String>,
        pub(crate) deployment_duration_in_minutes: std::option::Option<i32>,
        pub(crate) growth_type: std::option::Option<crate::model::GrowthType>,
        pub(crate) growth_factor: std::option::Option<f32>,
        pub(crate) final_bake_time_in_minutes: std::option::Option<i32>,
        pub(crate) state: std::option::Option<crate::model::DeploymentState>,
        pub(crate) percentage_complete: std::option::Option<f32>,
        pub(crate) started_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) completed_at: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The sequence number of the deployment.</p>
        pub fn deployment_number(mut self, input: i32) -> Self {
            self.deployment_number = Some(input);
            self
        }
        /// <p>The sequence number of the deployment.</p>
        pub fn set_deployment_number(mut self, input: std::option::Option<i32>) -> Self {
            self.deployment_number = input;
            self
        }
        /// <p>The name of the configuration.</p>
        pub fn configuration_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration.</p>
        pub fn set_configuration_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_name = input;
            self
        }
        /// <p>The version of the configuration.</p>
        pub fn configuration_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_version = Some(input.into());
            self
        }
        /// <p>The version of the configuration.</p>
        pub fn set_configuration_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_version = input;
            self
        }
        /// <p>Total amount of time the deployment lasted.</p>
        pub fn deployment_duration_in_minutes(mut self, input: i32) -> Self {
            self.deployment_duration_in_minutes = Some(input);
            self
        }
        /// <p>Total amount of time the deployment lasted.</p>
        pub fn set_deployment_duration_in_minutes(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.deployment_duration_in_minutes = input;
            self
        }
        /// <p>The algorithm used to define how percentage grows over time.</p>
        pub fn growth_type(mut self, input: crate::model::GrowthType) -> Self {
            self.growth_type = Some(input);
            self
        }
        /// <p>The algorithm used to define how percentage grows over time.</p>
        pub fn set_growth_type(
            mut self,
            input: std::option::Option<crate::model::GrowthType>,
        ) -> Self {
            self.growth_type = input;
            self
        }
        /// <p>The percentage of targets to receive a deployed configuration during each
        /// interval.</p>
        pub fn growth_factor(mut self, input: f32) -> Self {
            self.growth_factor = Some(input);
            self
        }
        /// <p>The percentage of targets to receive a deployed configuration during each
        /// interval.</p>
        pub fn set_growth_factor(mut self, input: std::option::Option<f32>) -> Self {
            self.growth_factor = input;
            self
        }
        /// <p>The amount of time AppConfig monitors for alarms before considering the deployment to be
        /// complete and no longer eligible for automatic roll back.</p>
        pub fn final_bake_time_in_minutes(mut self, input: i32) -> Self {
            self.final_bake_time_in_minutes = Some(input);
            self
        }
        /// <p>The amount of time AppConfig monitors for alarms before considering the deployment to be
        /// complete and no longer eligible for automatic roll back.</p>
        pub fn set_final_bake_time_in_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.final_bake_time_in_minutes = input;
            self
        }
        /// <p>The state of the deployment.</p>
        pub fn state(mut self, input: crate::model::DeploymentState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the deployment.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::DeploymentState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>The percentage of targets for which the deployment is available.</p>
        pub fn percentage_complete(mut self, input: f32) -> Self {
            self.percentage_complete = Some(input);
            self
        }
        /// <p>The percentage of targets for which the deployment is available.</p>
        pub fn set_percentage_complete(mut self, input: std::option::Option<f32>) -> Self {
            self.percentage_complete = input;
            self
        }
        /// <p>Time the deployment started.</p>
        pub fn started_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.started_at = Some(input);
            self
        }
        /// <p>Time the deployment started.</p>
        pub fn set_started_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.started_at = input;
            self
        }
        /// <p>Time the deployment completed.</p>
        pub fn completed_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.completed_at = Some(input);
            self
        }
        /// <p>Time the deployment completed.</p>
        pub fn set_completed_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.completed_at = input;
            self
        }
        /// Consumes the builder and constructs a [`DeploymentSummary`](crate::model::DeploymentSummary)
        pub fn build(self) -> crate::model::DeploymentSummary {
            crate::model::DeploymentSummary {
                deployment_number: self.deployment_number.unwrap_or_default(),
                configuration_name: self.configuration_name,
                configuration_version: self.configuration_version,
                deployment_duration_in_minutes: self
                    .deployment_duration_in_minutes
                    .unwrap_or_default(),
                growth_type: self.growth_type,
                growth_factor: self.growth_factor.unwrap_or_default(),
                final_bake_time_in_minutes: self.final_bake_time_in_minutes.unwrap_or_default(),
                state: self.state,
                percentage_complete: self.percentage_complete.unwrap_or_default(),
                started_at: self.started_at,
                completed_at: self.completed_at,
            }
        }
    }
}
impl DeploymentSummary {
    /// Creates a new builder-style object to manufacture [`DeploymentSummary`](crate::model::DeploymentSummary)
    pub fn builder() -> crate::model::deployment_summary::Builder {
        crate::model::deployment_summary::Builder::default()
    }
}

/// <p>A summary of a configuration profile.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConfigurationProfileSummary {
    /// <p>The application ID.</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The ID of the configuration profile.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the configuration profile.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The URI location of the configuration.</p>
    pub location_uri: std::option::Option<std::string::String>,
    /// <p>The types of validators in the configuration profile.</p>
    pub validator_types: std::option::Option<std::vec::Vec<crate::model::ValidatorType>>,
}
impl std::fmt::Debug for ConfigurationProfileSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConfigurationProfileSummary");
        formatter.field("application_id", &self.application_id);
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("location_uri", &self.location_uri);
        formatter.field("validator_types", &self.validator_types);
        formatter.finish()
    }
}
/// See [`ConfigurationProfileSummary`](crate::model::ConfigurationProfileSummary)
pub mod configuration_profile_summary {
    /// A builder for [`ConfigurationProfileSummary`](crate::model::ConfigurationProfileSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) location_uri: std::option::Option<std::string::String>,
        pub(crate) validator_types: std::option::Option<std::vec::Vec<crate::model::ValidatorType>>,
    }
    impl Builder {
        /// <p>The application ID.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The application ID.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The ID of the configuration profile.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the configuration profile.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the configuration profile.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the configuration profile.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The URI location of the configuration.</p>
        pub fn location_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.location_uri = Some(input.into());
            self
        }
        /// <p>The URI location of the configuration.</p>
        pub fn set_location_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location_uri = input;
            self
        }
        /// Appends an item to `validator_types`.
        ///
        /// To override the contents of this collection use [`set_validator_types`](Self::set_validator_types).
        ///
        /// <p>The types of validators in the configuration profile.</p>
        pub fn validator_types(mut self, input: impl Into<crate::model::ValidatorType>) -> Self {
            let mut v = self.validator_types.unwrap_or_default();
            v.push(input.into());
            self.validator_types = Some(v);
            self
        }
        /// <p>The types of validators in the configuration profile.</p>
        pub fn set_validator_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ValidatorType>>,
        ) -> Self {
            self.validator_types = input;
            self
        }
        /// Consumes the builder and constructs a [`ConfigurationProfileSummary`](crate::model::ConfigurationProfileSummary)
        pub fn build(self) -> crate::model::ConfigurationProfileSummary {
            crate::model::ConfigurationProfileSummary {
                application_id: self.application_id,
                id: self.id,
                name: self.name,
                location_uri: self.location_uri,
                validator_types: self.validator_types,
            }
        }
    }
}
impl ConfigurationProfileSummary {
    /// Creates a new builder-style object to manufacture [`ConfigurationProfileSummary`](crate::model::ConfigurationProfileSummary)
    pub fn builder() -> crate::model::configuration_profile_summary::Builder {
        crate::model::configuration_profile_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Application {
    /// <p>The application ID.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The application name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the application.</p>
    pub description: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Application {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Application");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`Application`](crate::model::Application)
pub mod application {
    /// A builder for [`Application`](crate::model::Application)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The application ID.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The application ID.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The application name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The application name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the application.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the application.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`Application`](crate::model::Application)
        pub fn build(self) -> crate::model::Application {
            crate::model::Application {
                id: self.id,
                name: self.name,
                description: self.description,
            }
        }
    }
}
impl Application {
    /// Creates a new builder-style object to manufacture [`Application`](crate::model::Application)
    pub fn builder() -> crate::model::application::Builder {
        crate::model::application::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BytesMeasure {
    #[allow(missing_docs)] // documentation missing in model
    Kilobytes,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BytesMeasure {
    fn from(s: &str) -> Self {
        match s {
            "KILOBYTES" => BytesMeasure::Kilobytes,
            other => BytesMeasure::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BytesMeasure {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BytesMeasure::from(s))
    }
}
impl BytesMeasure {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BytesMeasure::Kilobytes => "KILOBYTES",
            BytesMeasure::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["KILOBYTES"]
    }
}
impl AsRef<str> for BytesMeasure {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
