// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for AmazonApiGatewayV2
///
/// Client for invoking operations on AmazonApiGatewayV2. Each operation on AmazonApiGatewayV2 is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_apigatewayv2::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_apigatewayv2::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_apigatewayv2::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`CreateApi`](crate::client::fluent_builders::CreateApi) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_key_selection_expression(impl Into<String>)`](crate::client::fluent_builders::CreateApi::api_key_selection_expression) / [`set_api_key_selection_expression(Option<String>)`](crate::client::fluent_builders::CreateApi::set_api_key_selection_expression): <p>An API key selection expression. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions">API Key Selection Expressions</a>.</p>
    ///   - [`cors_configuration(Cors)`](crate::client::fluent_builders::CreateApi::cors_configuration) / [`set_cors_configuration(Option<Cors>)`](crate::client::fluent_builders::CreateApi::set_cors_configuration): <p>A CORS configuration. Supported only for HTTP APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-cors.html">Configuring CORS</a> for more information.</p>
    ///   - [`credentials_arn(impl Into<String>)`](crate::client::fluent_builders::CreateApi::credentials_arn) / [`set_credentials_arn(Option<String>)`](crate::client::fluent_builders::CreateApi::set_credentials_arn): <p>This property is part of quick create. It specifies the credentials required for the integration, if any. For a Lambda integration, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, specify null. Currently, this property is not used for HTTP integrations. Supported only for HTTP APIs.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateApi::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateApi::set_description): <p>The description of the API.</p>
    ///   - [`disable_schema_validation(bool)`](crate::client::fluent_builders::CreateApi::disable_schema_validation) / [`set_disable_schema_validation(bool)`](crate::client::fluent_builders::CreateApi::set_disable_schema_validation): <p>Avoid validating models when creating a deployment. Supported only for WebSocket APIs.</p>
    ///   - [`disable_execute_api_endpoint(bool)`](crate::client::fluent_builders::CreateApi::disable_execute_api_endpoint) / [`set_disable_execute_api_endpoint(bool)`](crate::client::fluent_builders::CreateApi::set_disable_execute_api_endpoint): <p>Specifies whether clients can invoke your API by using the default execute-api endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateApi::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateApi::set_name): <p>The name of the API.</p>
    ///   - [`protocol_type(ProtocolType)`](crate::client::fluent_builders::CreateApi::protocol_type) / [`set_protocol_type(Option<ProtocolType>)`](crate::client::fluent_builders::CreateApi::set_protocol_type): <p>The API protocol.</p>
    ///   - [`route_key(impl Into<String>)`](crate::client::fluent_builders::CreateApi::route_key) / [`set_route_key(Option<String>)`](crate::client::fluent_builders::CreateApi::set_route_key): <p>This property is part of quick create. If you don't specify a routeKey, a default route of $default is created. The $default route acts as a catch-all for any request made to your API, for a particular stage. The $default route key can't be modified. You can add routes after creating the API, and you can update the route keys of additional routes. Supported only for HTTP APIs.</p>
    ///   - [`route_selection_expression(impl Into<String>)`](crate::client::fluent_builders::CreateApi::route_selection_expression) / [`set_route_selection_expression(Option<String>)`](crate::client::fluent_builders::CreateApi::set_route_selection_expression): <p>The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateApi::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateApi::set_tags): <p>The collection of tags. Each tag element is associated with a given resource.</p>
    ///   - [`target(impl Into<String>)`](crate::client::fluent_builders::CreateApi::target) / [`set_target(Option<String>)`](crate::client::fluent_builders::CreateApi::set_target): <p>This property is part of quick create. Quick create produces an API with an integration, a default catch-all route, and a default stage which is configured to automatically deploy changes. For HTTP integrations, specify a fully qualified URL. For Lambda integrations, specify a function ARN. The type of the integration will be HTTP_PROXY or AWS_PROXY, respectively. Supported only for HTTP APIs.</p>
    ///   - [`version(impl Into<String>)`](crate::client::fluent_builders::CreateApi::version) / [`set_version(Option<String>)`](crate::client::fluent_builders::CreateApi::set_version): <p>A version identifier for the API.</p>
    /// - On success, responds with [`CreateApiOutput`](crate::output::CreateApiOutput) with field(s):
    ///   - [`api_endpoint(Option<String>)`](crate::output::CreateApiOutput::api_endpoint): <p>The URI of the API, of the form {api-id}.execute-api.{region}.amazonaws.com. The stage name is typically appended to this URI to form a complete path to a deployed API stage.</p>
    ///   - [`api_gateway_managed(bool)`](crate::output::CreateApiOutput::api_gateway_managed): <p>Specifies whether an API is managed by API Gateway. You can't update or delete a managed API by using API Gateway. A managed API can be deleted only through the tooling or service that created it.</p>
    ///   - [`api_id(Option<String>)`](crate::output::CreateApiOutput::api_id): <p>The API ID.</p>
    ///   - [`api_key_selection_expression(Option<String>)`](crate::output::CreateApiOutput::api_key_selection_expression): <p>An API key selection expression. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions">API Key Selection Expressions</a>.</p>
    ///   - [`cors_configuration(Option<Cors>)`](crate::output::CreateApiOutput::cors_configuration): <p>A CORS configuration. Supported only for HTTP APIs.</p>
    ///   - [`created_date(Option<DateTime>)`](crate::output::CreateApiOutput::created_date): <p>The timestamp when the API was created.</p>
    ///   - [`description(Option<String>)`](crate::output::CreateApiOutput::description): <p>The description of the API.</p>
    ///   - [`disable_schema_validation(bool)`](crate::output::CreateApiOutput::disable_schema_validation): <p>Avoid validating models when creating a deployment. Supported only for WebSocket APIs.</p>
    ///   - [`disable_execute_api_endpoint(bool)`](crate::output::CreateApiOutput::disable_execute_api_endpoint): <p>Specifies whether clients can invoke your API by using the default execute-api endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
    ///   - [`import_info(Option<Vec<String>>)`](crate::output::CreateApiOutput::import_info): <p>The validation information during API import. This may include particular properties of your OpenAPI definition which are ignored during import. Supported only for HTTP APIs.</p>
    ///   - [`name(Option<String>)`](crate::output::CreateApiOutput::name): <p>The name of the API.</p>
    ///   - [`protocol_type(Option<ProtocolType>)`](crate::output::CreateApiOutput::protocol_type): <p>The API protocol.</p>
    ///   - [`route_selection_expression(Option<String>)`](crate::output::CreateApiOutput::route_selection_expression): <p>The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::CreateApiOutput::tags): <p>A collection of tags associated with the API.</p>
    ///   - [`version(Option<String>)`](crate::output::CreateApiOutput::version): <p>A version identifier for the API.</p>
    ///   - [`warnings(Option<Vec<String>>)`](crate::output::CreateApiOutput::warnings): <p>The warning messages reported when failonwarnings is turned on during API import.</p>
    /// - On failure, responds with [`SdkError<CreateApiError>`](crate::error::CreateApiError)
    pub fn create_api(&self) -> fluent_builders::CreateApi {
        fluent_builders::CreateApi::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateApiMapping`](crate::client::fluent_builders::CreateApiMapping) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::CreateApiMapping::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::CreateApiMapping::set_api_id): <p>The API identifier.</p>
    ///   - [`api_mapping_key(impl Into<String>)`](crate::client::fluent_builders::CreateApiMapping::api_mapping_key) / [`set_api_mapping_key(Option<String>)`](crate::client::fluent_builders::CreateApiMapping::set_api_mapping_key): The API mapping key.
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::CreateApiMapping::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::CreateApiMapping::set_domain_name): <p>The domain name.</p>
    ///   - [`stage(impl Into<String>)`](crate::client::fluent_builders::CreateApiMapping::stage) / [`set_stage(Option<String>)`](crate::client::fluent_builders::CreateApiMapping::set_stage): <p>The API stage.</p>
    /// - On success, responds with [`CreateApiMappingOutput`](crate::output::CreateApiMappingOutput) with field(s):
    ///   - [`api_id(Option<String>)`](crate::output::CreateApiMappingOutput::api_id): <p>The API identifier.</p>
    ///   - [`api_mapping_id(Option<String>)`](crate::output::CreateApiMappingOutput::api_mapping_id): <p>The API mapping identifier.</p>
    ///   - [`api_mapping_key(Option<String>)`](crate::output::CreateApiMappingOutput::api_mapping_key): <p>The API mapping key.</p>
    ///   - [`stage(Option<String>)`](crate::output::CreateApiMappingOutput::stage): <p>The API stage.</p>
    /// - On failure, responds with [`SdkError<CreateApiMappingError>`](crate::error::CreateApiMappingError)
    pub fn create_api_mapping(&self) -> fluent_builders::CreateApiMapping {
        fluent_builders::CreateApiMapping::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateAuthorizer`](crate::client::fluent_builders::CreateAuthorizer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::CreateAuthorizer::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::CreateAuthorizer::set_api_id): <p>The API identifier.</p>
    ///   - [`authorizer_credentials_arn(impl Into<String>)`](crate::client::fluent_builders::CreateAuthorizer::authorizer_credentials_arn) / [`set_authorizer_credentials_arn(Option<String>)`](crate::client::fluent_builders::CreateAuthorizer::set_authorizer_credentials_arn): <p>Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, don't specify this parameter. Supported only for REQUEST authorizers.</p>
    ///   - [`authorizer_payload_format_version(impl Into<String>)`](crate::client::fluent_builders::CreateAuthorizer::authorizer_payload_format_version) / [`set_authorizer_payload_format_version(Option<String>)`](crate::client::fluent_builders::CreateAuthorizer::set_authorizer_payload_format_version): <p>Specifies the format of the payload sent to an HTTP API Lambda authorizer. Required for HTTP API Lambda authorizers. Supported values are 1.0 and 2.0. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p>
    ///   - [`authorizer_result_ttl_in_seconds(i32)`](crate::client::fluent_builders::CreateAuthorizer::authorizer_result_ttl_in_seconds) / [`set_authorizer_result_ttl_in_seconds(i32)`](crate::client::fluent_builders::CreateAuthorizer::set_authorizer_result_ttl_in_seconds): <p>The time to live (TTL) for cached authorizer results, in seconds. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway caches authorizer responses. The maximum value is 3600, or 1 hour. Supported only for HTTP API Lambda authorizers.</p>
    ///   - [`authorizer_type(AuthorizerType)`](crate::client::fluent_builders::CreateAuthorizer::authorizer_type) / [`set_authorizer_type(Option<AuthorizerType>)`](crate::client::fluent_builders::CreateAuthorizer::set_authorizer_type): <p>The authorizer type. Specify REQUEST for a Lambda function using incoming request parameters. Specify JWT to use JSON Web Tokens (supported only for HTTP APIs).</p>
    ///   - [`authorizer_uri(impl Into<String>)`](crate::client::fluent_builders::CreateAuthorizer::authorizer_uri) / [`set_authorizer_uri(Option<String>)`](crate::client::fluent_builders::CreateAuthorizer::set_authorizer_uri): <p>The authorizer's Uniform Resource Identifier (URI). For REQUEST authorizers, this must be a well-formed Lambda function URI, for example, arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:<replaceable>   {account_id}  </replaceable>:function:<replaceable>   {lambda_function_name}  </replaceable>/invocations. In general, the URI has this form: arn:aws:apigateway:<replaceable>   {region}  </replaceable>:lambda:path/<replaceable>   {service_api}  </replaceable> , where <replaceable></replaceable>{region} is the same as the region hosting the Lambda function, path indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial /. For Lambda functions, this is usually of the form /2015-03-31/functions/[FunctionARN]/invocations. Supported only for REQUEST authorizers.</p>
    ///   - [`enable_simple_responses(bool)`](crate::client::fluent_builders::CreateAuthorizer::enable_simple_responses) / [`set_enable_simple_responses(bool)`](crate::client::fluent_builders::CreateAuthorizer::set_enable_simple_responses): <p>Specifies whether a Lambda authorizer returns a response in a simple format. By default, a Lambda authorizer must return an IAM policy. If enabled, the Lambda authorizer can return a boolean value instead of an IAM policy. Supported only for HTTP APIs. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a></p>
    ///   - [`identity_source(Vec<String>)`](crate::client::fluent_builders::CreateAuthorizer::identity_source) / [`set_identity_source(Option<Vec<String>>)`](crate::client::fluent_builders::CreateAuthorizer::set_identity_source): <p>The identity source for which authorization is requested.</p>  <p>For a REQUEST authorizer, this is optional. The value is a set of one or more mapping expressions of the specified request parameters. The identity source can be headers, query string parameters, stage variables, and context parameters. For example, if an Auth header and a Name query string parameter are defined as identity sources, this value is route.request.header.Auth, route.request.querystring.Name for WebSocket APIs. For HTTP APIs, use selection expressions prefixed with $, for example, $request.header.Auth, $request.querystring.Name. These parameters are used to perform runtime validation for Lambda-based authorizers by verifying all of the identity-related request parameters are present in the request, not null, and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function. Otherwise, it returns a 401 Unauthorized response without calling the Lambda function. For HTTP APIs, identity sources are also used as the cache key when caching is enabled. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p>  <p>For JWT, a single entry that specifies where to extract the JSON Web Token (JWT) from inbound requests. Currently only header-based and query parameter-based selections are supported, for example $request.header.Authorization.</p>
    ///   - [`identity_validation_expression(impl Into<String>)`](crate::client::fluent_builders::CreateAuthorizer::identity_validation_expression) / [`set_identity_validation_expression(Option<String>)`](crate::client::fluent_builders::CreateAuthorizer::set_identity_validation_expression): <p>This parameter is not used.</p>
    ///   - [`jwt_configuration(JwtConfiguration)`](crate::client::fluent_builders::CreateAuthorizer::jwt_configuration) / [`set_jwt_configuration(Option<JwtConfiguration>)`](crate::client::fluent_builders::CreateAuthorizer::set_jwt_configuration): <p>Represents the configuration of a JWT authorizer. Required for the JWT authorizer type. Supported only for HTTP APIs.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateAuthorizer::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateAuthorizer::set_name): <p>The name of the authorizer.</p>
    /// - On success, responds with [`CreateAuthorizerOutput`](crate::output::CreateAuthorizerOutput) with field(s):
    ///   - [`authorizer_credentials_arn(Option<String>)`](crate::output::CreateAuthorizerOutput::authorizer_credentials_arn): <p>Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, don't specify this parameter. Supported only for REQUEST authorizers.</p>
    ///   - [`authorizer_id(Option<String>)`](crate::output::CreateAuthorizerOutput::authorizer_id): <p>The authorizer identifier.</p>
    ///   - [`authorizer_payload_format_version(Option<String>)`](crate::output::CreateAuthorizerOutput::authorizer_payload_format_version): <p>Specifies the format of the payload sent to an HTTP API Lambda authorizer. Required for HTTP API Lambda authorizers. Supported values are 1.0 and 2.0. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p>
    ///   - [`authorizer_result_ttl_in_seconds(i32)`](crate::output::CreateAuthorizerOutput::authorizer_result_ttl_in_seconds): <p>The time to live (TTL) for cached authorizer results, in seconds. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway caches authorizer responses. The maximum value is 3600, or 1 hour. Supported only for HTTP API Lambda authorizers.</p>
    ///   - [`authorizer_type(Option<AuthorizerType>)`](crate::output::CreateAuthorizerOutput::authorizer_type): <p>The authorizer type. Specify REQUEST for a Lambda function using incoming request parameters. Specify JWT to use JSON Web Tokens (supported only for HTTP APIs).</p>
    ///   - [`authorizer_uri(Option<String>)`](crate::output::CreateAuthorizerOutput::authorizer_uri): <p>The authorizer's Uniform Resource Identifier (URI). For REQUEST authorizers, this must be a well-formed Lambda function URI, for example, arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:<replaceable>   {account_id}  </replaceable>:function:<replaceable>   {lambda_function_name}  </replaceable>/invocations. In general, the URI has this form: arn:aws:apigateway:<replaceable>   {region}  </replaceable>:lambda:path/<replaceable>   {service_api}  </replaceable> , where <replaceable></replaceable>{region} is the same as the region hosting the Lambda function, path indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial /. For Lambda functions, this is usually of the form /2015-03-31/functions/[FunctionARN]/invocations. Supported only for REQUEST authorizers.</p>
    ///   - [`enable_simple_responses(bool)`](crate::output::CreateAuthorizerOutput::enable_simple_responses): <p>Specifies whether a Lambda authorizer returns a response in a simple format. If enabled, the Lambda authorizer can return a boolean value instead of an IAM policy. Supported only for HTTP APIs. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a></p>
    ///   - [`identity_source(Option<Vec<String>>)`](crate::output::CreateAuthorizerOutput::identity_source): <p>The identity source for which authorization is requested.</p>  <p>For a REQUEST authorizer, this is optional. The value is a set of one or more mapping expressions of the specified request parameters. The identity source can be headers, query string parameters, stage variables, and context parameters. For example, if an Auth header and a Name query string parameter are defined as identity sources, this value is route.request.header.Auth, route.request.querystring.Name for WebSocket APIs. For HTTP APIs, use selection expressions prefixed with $, for example, $request.header.Auth, $request.querystring.Name. These parameters are used to perform runtime validation for Lambda-based authorizers by verifying all of the identity-related request parameters are present in the request, not null, and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function. Otherwise, it returns a 401 Unauthorized response without calling the Lambda function. For HTTP APIs, identity sources are also used as the cache key when caching is enabled. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p>  <p>For JWT, a single entry that specifies where to extract the JSON Web Token (JWT) from inbound requests. Currently only header-based and query parameter-based selections are supported, for example $request.header.Authorization.</p>
    ///   - [`identity_validation_expression(Option<String>)`](crate::output::CreateAuthorizerOutput::identity_validation_expression): <p>The validation expression does not apply to the REQUEST authorizer.</p>
    ///   - [`jwt_configuration(Option<JwtConfiguration>)`](crate::output::CreateAuthorizerOutput::jwt_configuration): <p>Represents the configuration of a JWT authorizer. Required for the JWT authorizer type. Supported only for HTTP APIs.</p>
    ///   - [`name(Option<String>)`](crate::output::CreateAuthorizerOutput::name): <p>The name of the authorizer.</p>
    /// - On failure, responds with [`SdkError<CreateAuthorizerError>`](crate::error::CreateAuthorizerError)
    pub fn create_authorizer(&self) -> fluent_builders::CreateAuthorizer {
        fluent_builders::CreateAuthorizer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDeployment`](crate::client::fluent_builders::CreateDeployment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::CreateDeployment::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::CreateDeployment::set_api_id): <p>The API identifier.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateDeployment::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateDeployment::set_description): <p>The description for the deployment resource.</p>
    ///   - [`stage_name(impl Into<String>)`](crate::client::fluent_builders::CreateDeployment::stage_name) / [`set_stage_name(Option<String>)`](crate::client::fluent_builders::CreateDeployment::set_stage_name): <p>The name of the Stage resource for the Deployment resource to create.</p>
    /// - On success, responds with [`CreateDeploymentOutput`](crate::output::CreateDeploymentOutput) with field(s):
    ///   - [`auto_deployed(bool)`](crate::output::CreateDeploymentOutput::auto_deployed): <p>Specifies whether a deployment was automatically released.</p>
    ///   - [`created_date(Option<DateTime>)`](crate::output::CreateDeploymentOutput::created_date): <p>The date and time when the Deployment resource was created.</p>
    ///   - [`deployment_id(Option<String>)`](crate::output::CreateDeploymentOutput::deployment_id): <p>The identifier for the deployment.</p>
    ///   - [`deployment_status(Option<DeploymentStatus>)`](crate::output::CreateDeploymentOutput::deployment_status): <p>The status of the deployment: PENDING, FAILED, or SUCCEEDED.</p>
    ///   - [`deployment_status_message(Option<String>)`](crate::output::CreateDeploymentOutput::deployment_status_message): <p>May contain additional feedback on the status of an API deployment.</p>
    ///   - [`description(Option<String>)`](crate::output::CreateDeploymentOutput::description): <p>The description for the deployment.</p>
    /// - On failure, responds with [`SdkError<CreateDeploymentError>`](crate::error::CreateDeploymentError)
    pub fn create_deployment(&self) -> fluent_builders::CreateDeployment {
        fluent_builders::CreateDeployment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDomainName`](crate::client::fluent_builders::CreateDomainName) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::CreateDomainName::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::CreateDomainName::set_domain_name): <p>The domain name.</p>
    ///   - [`domain_name_configurations(Vec<DomainNameConfiguration>)`](crate::client::fluent_builders::CreateDomainName::domain_name_configurations) / [`set_domain_name_configurations(Option<Vec<DomainNameConfiguration>>)`](crate::client::fluent_builders::CreateDomainName::set_domain_name_configurations): <p>The domain name configurations.</p>
    ///   - [`mutual_tls_authentication(MutualTlsAuthenticationInput)`](crate::client::fluent_builders::CreateDomainName::mutual_tls_authentication) / [`set_mutual_tls_authentication(Option<MutualTlsAuthenticationInput>)`](crate::client::fluent_builders::CreateDomainName::set_mutual_tls_authentication): <p>The mutual TLS authentication configuration for a custom domain name.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateDomainName::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateDomainName::set_tags): <p>The collection of tags associated with a domain name.</p>
    /// - On success, responds with [`CreateDomainNameOutput`](crate::output::CreateDomainNameOutput) with field(s):
    ///   - [`api_mapping_selection_expression(Option<String>)`](crate::output::CreateDomainNameOutput::api_mapping_selection_expression): <p>The API mapping selection expression.</p>
    ///   - [`domain_name(Option<String>)`](crate::output::CreateDomainNameOutput::domain_name): <p>The name of the DomainName resource.</p>
    ///   - [`domain_name_configurations(Option<Vec<DomainNameConfiguration>>)`](crate::output::CreateDomainNameOutput::domain_name_configurations): <p>The domain name configurations.</p>
    ///   - [`mutual_tls_authentication(Option<MutualTlsAuthentication>)`](crate::output::CreateDomainNameOutput::mutual_tls_authentication): <p>The mutual TLS authentication configuration for a custom domain name.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::CreateDomainNameOutput::tags): <p>The collection of tags associated with a domain name.</p>
    /// - On failure, responds with [`SdkError<CreateDomainNameError>`](crate::error::CreateDomainNameError)
    pub fn create_domain_name(&self) -> fluent_builders::CreateDomainName {
        fluent_builders::CreateDomainName::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateIntegration`](crate::client::fluent_builders::CreateIntegration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::CreateIntegration::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::CreateIntegration::set_api_id): <p>The API identifier.</p>
    ///   - [`connection_id(impl Into<String>)`](crate::client::fluent_builders::CreateIntegration::connection_id) / [`set_connection_id(Option<String>)`](crate::client::fluent_builders::CreateIntegration::set_connection_id): <p>The ID of the VPC link for a private integration. Supported only for HTTP APIs.</p>
    ///   - [`connection_type(ConnectionType)`](crate::client::fluent_builders::CreateIntegration::connection_type) / [`set_connection_type(Option<ConnectionType>)`](crate::client::fluent_builders::CreateIntegration::set_connection_type): <p>The type of the network connection to the integration endpoint. Specify INTERNET for connections through the public routable internet or VPC_LINK for private connections between API Gateway and resources in a VPC. The default value is INTERNET.</p>
    ///   - [`content_handling_strategy(ContentHandlingStrategy)`](crate::client::fluent_builders::CreateIntegration::content_handling_strategy) / [`set_content_handling_strategy(Option<ContentHandlingStrategy>)`](crate::client::fluent_builders::CreateIntegration::set_content_handling_strategy): <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p>  <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p>  <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p>  <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
    ///   - [`credentials_arn(impl Into<String>)`](crate::client::fluent_builders::CreateIntegration::credentials_arn) / [`set_credentials_arn(Option<String>)`](crate::client::fluent_builders::CreateIntegration::set_credentials_arn): <p>Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, specify null.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateIntegration::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateIntegration::set_description): <p>The description of the integration.</p>
    ///   - [`integration_method(impl Into<String>)`](crate::client::fluent_builders::CreateIntegration::integration_method) / [`set_integration_method(Option<String>)`](crate::client::fluent_builders::CreateIntegration::set_integration_method): <p>Specifies the integration's HTTP method type.</p>
    ///   - [`integration_subtype(impl Into<String>)`](crate::client::fluent_builders::CreateIntegration::integration_subtype) / [`set_integration_subtype(Option<String>)`](crate::client::fluent_builders::CreateIntegration::set_integration_subtype): <p>Supported only for HTTP API AWS_PROXY integrations. Specifies the AWS service action to invoke. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html">Integration subtype reference</a>.</p>
    ///   - [`integration_type(IntegrationType)`](crate::client::fluent_builders::CreateIntegration::integration_type) / [`set_integration_type(Option<IntegrationType>)`](crate::client::fluent_builders::CreateIntegration::set_integration_type): <p>The integration type of an integration. One of the following:</p>  <p>AWS: for integrating the route or method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration. Supported only for WebSocket APIs.</p>  <p>AWS_PROXY: for integrating the route or method request with a Lambda function or other AWS service action. This integration is also referred to as a Lambda proxy integration.</p>  <p>HTTP: for integrating the route or method request with an HTTP endpoint. This integration is also referred to as the HTTP custom integration. Supported only for WebSocket APIs.</p>  <p>HTTP_PROXY: for integrating the route or method request with an HTTP endpoint, with the client request passed through as-is. This is also referred to as HTTP proxy integration. For HTTP API private integrations, use an HTTP_PROXY integration.</p>  <p>MOCK: for integrating the route or method request with API Gateway as a "loopback" endpoint without invoking any backend. Supported only for WebSocket APIs.</p>
    ///   - [`integration_uri(impl Into<String>)`](crate::client::fluent_builders::CreateIntegration::integration_uri) / [`set_integration_uri(Option<String>)`](crate::client::fluent_builders::CreateIntegration::set_integration_uri): <p>For a Lambda integration, specify the URI of a Lambda function.</p>  <p>For an HTTP integration, specify a fully-qualified URL.</p>  <p>For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service. If you specify the ARN of an AWS Cloud Map service, API Gateway uses DiscoverInstances to identify resources. You can use query parameters to target specific resources. To learn more, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_DiscoverInstances.html">DiscoverInstances</a>. For private integrations, all resources must be owned by the same AWS account.</p>
    ///   - [`passthrough_behavior(PassthroughBehavior)`](crate::client::fluent_builders::CreateIntegration::passthrough_behavior) / [`set_passthrough_behavior(Option<PassthroughBehavior>)`](crate::client::fluent_builders::CreateIntegration::set_passthrough_behavior): <p>Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER. Supported only for WebSocket APIs.</p>  <p>WHEN_NO_MATCH passes the request body for unmapped content types through to the integration backend without transformation.</p>  <p>NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type response.</p>  <p>WHEN_NO_TEMPLATES allows pass-through when the integration has no content types mapped to templates. However, if there is at least one content type defined, unmapped content types will be rejected with the same HTTP 415 Unsupported Media Type response.</p>
    ///   - [`payload_format_version(impl Into<String>)`](crate::client::fluent_builders::CreateIntegration::payload_format_version) / [`set_payload_format_version(Option<String>)`](crate::client::fluent_builders::CreateIntegration::set_payload_format_version): <p>Specifies the format of the payload sent to an integration. Required for HTTP APIs.</p>
    ///   - [`request_parameters(HashMap<String, String>)`](crate::client::fluent_builders::CreateIntegration::request_parameters) / [`set_request_parameters(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateIntegration::set_request_parameters): <p>For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the backend. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the backend. The method request parameter value must match the pattern of method.request.<replaceable>   {location}  </replaceable>.<replaceable>   {name}  </replaceable> , where <replaceable>   {location}  </replaceable> is querystring, path, or header; and <replaceable>   {name}  </replaceable> must be a valid and unique method request parameter name.</p>  <p>For HTTP API integrations with a specified integrationSubtype, request parameters are a key-value map specifying parameters that are passed to AWS_PROXY integrations. You can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services.html">Working with AWS service integrations for HTTP APIs</a>.</p>  <p>For HTTP API integrations without a specified integrationSubtype request parameters are a key-value map specifying how to transform HTTP requests before sending them to the backend. The key should follow the pattern &lt;action&gt;:&lt;header|querystring|path&gt;.&lt;location&gt; where action can be append, overwrite or remove. For values, you can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
    ///   - [`request_templates(HashMap<String, String>)`](crate::client::fluent_builders::CreateIntegration::request_templates) / [`set_request_templates(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateIntegration::set_request_templates): <p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value. Supported only for WebSocket APIs.</p>
    ///   - [`response_parameters(HashMap<String, HashMap<String, String>>)`](crate::client::fluent_builders::CreateIntegration::response_parameters) / [`set_response_parameters(Option<HashMap<String, HashMap<String, String>>>)`](crate::client::fluent_builders::CreateIntegration::set_response_parameters): <p>Supported only for HTTP APIs. You use response parameters to transform the HTTP response from a backend integration before returning the response to clients. Specify a key-value map from a selection key to response parameters. The selection key must be a valid HTTP status code within the range of 200-599. Response parameters are a key-value map. The key must match pattern &lt;action&gt;:&lt;header&gt;.&lt;location&gt; or overwrite.statuscode. The action can be append, overwrite or remove. The value can be a static value, or map to response data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
    ///   - [`template_selection_expression(impl Into<String>)`](crate::client::fluent_builders::CreateIntegration::template_selection_expression) / [`set_template_selection_expression(Option<String>)`](crate::client::fluent_builders::CreateIntegration::set_template_selection_expression): <p>The template selection expression for the integration.</p>
    ///   - [`timeout_in_millis(i32)`](crate::client::fluent_builders::CreateIntegration::timeout_in_millis) / [`set_timeout_in_millis(i32)`](crate::client::fluent_builders::CreateIntegration::set_timeout_in_millis): <p>Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs. The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.</p>
    ///   - [`tls_config(TlsConfigInput)`](crate::client::fluent_builders::CreateIntegration::tls_config) / [`set_tls_config(Option<TlsConfigInput>)`](crate::client::fluent_builders::CreateIntegration::set_tls_config): <p>The TLS configuration for a private integration. If you specify a TLS configuration, private integration traffic uses the HTTPS protocol. Supported only for HTTP APIs.</p>
    /// - On success, responds with [`CreateIntegrationOutput`](crate::output::CreateIntegrationOutput) with field(s):
    ///   - [`api_gateway_managed(bool)`](crate::output::CreateIntegrationOutput::api_gateway_managed): <p>Specifies whether an integration is managed by API Gateway. If you created an API using using quick create, the resulting integration is managed by API Gateway. You can update a managed integration, but you can't delete it.</p>
    ///   - [`connection_id(Option<String>)`](crate::output::CreateIntegrationOutput::connection_id): <p>The ID of the VPC link for a private integration. Supported only for HTTP APIs.</p>
    ///   - [`connection_type(Option<ConnectionType>)`](crate::output::CreateIntegrationOutput::connection_type): <p>The type of the network connection to the integration endpoint. Specify INTERNET for connections through the public routable internet or VPC_LINK for private connections between API Gateway and resources in a VPC. The default value is INTERNET.</p>
    ///   - [`content_handling_strategy(Option<ContentHandlingStrategy>)`](crate::output::CreateIntegrationOutput::content_handling_strategy): <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p>  <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p>  <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p>  <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
    ///   - [`credentials_arn(Option<String>)`](crate::output::CreateIntegrationOutput::credentials_arn): <p>Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, specify null.</p>
    ///   - [`description(Option<String>)`](crate::output::CreateIntegrationOutput::description): <p>Represents the description of an integration.</p>
    ///   - [`integration_id(Option<String>)`](crate::output::CreateIntegrationOutput::integration_id): <p>Represents the identifier of an integration.</p>
    ///   - [`integration_method(Option<String>)`](crate::output::CreateIntegrationOutput::integration_method): <p>Specifies the integration's HTTP method type.</p>
    ///   - [`integration_response_selection_expression(Option<String>)`](crate::output::CreateIntegrationOutput::integration_response_selection_expression): <p>The integration response selection expression for the integration. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-integration-response-selection-expressions">Integration Response Selection Expressions</a>.</p>
    ///   - [`integration_subtype(Option<String>)`](crate::output::CreateIntegrationOutput::integration_subtype): <p>Supported only for HTTP API AWS_PROXY integrations. Specifies the AWS service action to invoke. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html">Integration subtype reference</a>.</p>
    ///   - [`integration_type(Option<IntegrationType>)`](crate::output::CreateIntegrationOutput::integration_type): <p>The integration type of an integration. One of the following:</p>  <p>AWS: for integrating the route or method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration. Supported only for WebSocket APIs.</p>  <p>AWS_PROXY: for integrating the route or method request with a Lambda function or other AWS service action. This integration is also referred to as a Lambda proxy integration.</p>  <p>HTTP: for integrating the route or method request with an HTTP endpoint. This integration is also referred to as the HTTP custom integration. Supported only for WebSocket APIs.</p>  <p>HTTP_PROXY: for integrating the route or method request with an HTTP endpoint, with the client request passed through as-is. This is also referred to as HTTP proxy integration.</p>  <p>MOCK: for integrating the route or method request with API Gateway as a "loopback" endpoint without invoking any backend. Supported only for WebSocket APIs.</p>
    ///   - [`integration_uri(Option<String>)`](crate::output::CreateIntegrationOutput::integration_uri): <p>For a Lambda integration, specify the URI of a Lambda function.</p>  <p>For an HTTP integration, specify a fully-qualified URL.</p>  <p>For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service. If you specify the ARN of an AWS Cloud Map service, API Gateway uses DiscoverInstances to identify resources. You can use query parameters to target specific resources. To learn more, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_DiscoverInstances.html">DiscoverInstances</a>. For private integrations, all resources must be owned by the same AWS account.</p>
    ///   - [`passthrough_behavior(Option<PassthroughBehavior>)`](crate::output::CreateIntegrationOutput::passthrough_behavior): <p>Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER. Supported only for WebSocket APIs.</p>  <p>WHEN_NO_MATCH passes the request body for unmapped content types through to the integration backend without transformation.</p>  <p>NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type response.</p>  <p>WHEN_NO_TEMPLATES allows pass-through when the integration has no content types mapped to templates. However, if there is at least one content type defined, unmapped content types will be rejected with the same HTTP 415 Unsupported Media Type response.</p>
    ///   - [`payload_format_version(Option<String>)`](crate::output::CreateIntegrationOutput::payload_format_version): <p>Specifies the format of the payload sent to an integration. Required for HTTP APIs.</p>
    ///   - [`request_parameters(Option<HashMap<String, String>>)`](crate::output::CreateIntegrationOutput::request_parameters): <p>For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the backend. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the backend. The method request parameter value must match the pattern of method.request.<replaceable>   {location}  </replaceable>.<replaceable>   {name}  </replaceable> , where <replaceable>   {location}  </replaceable> is querystring, path, or header; and <replaceable>   {name}  </replaceable> must be a valid and unique method request parameter name.</p>  <p>For HTTP API integrations with a specified integrationSubtype, request parameters are a key-value map specifying parameters that are passed to AWS_PROXY integrations. You can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services.html">Working with AWS service integrations for HTTP APIs</a>.</p>  <p>For HTTP API itegrations, without a specified integrationSubtype request parameters are a key-value map specifying how to transform HTTP requests before sending them to backend integrations. The key should follow the pattern &lt;action&gt;:&lt;header|querystring|path&gt;.&lt;location&gt;. The action can be append, overwrite or remove. For values, you can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
    ///   - [`request_templates(Option<HashMap<String, String>>)`](crate::output::CreateIntegrationOutput::request_templates): <p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value. Supported only for WebSocket APIs.</p>
    ///   - [`response_parameters(Option<HashMap<String, HashMap<String, String>>>)`](crate::output::CreateIntegrationOutput::response_parameters): <p>Supported only for HTTP APIs. You use response parameters to transform the HTTP response from a backend integration before returning the response to clients. Specify a key-value map from a selection key to response parameters. The selection key must be a valid HTTP status code within the range of 200-599. Response parameters are a key-value map. The key must match pattern &lt;action&gt;:&lt;header&gt;.&lt;location&gt; or overwrite.statuscode. The action can be append, overwrite or remove. The value can be a static value, or map to response data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
    ///   - [`template_selection_expression(Option<String>)`](crate::output::CreateIntegrationOutput::template_selection_expression): <p>The template selection expression for the integration. Supported only for WebSocket APIs.</p>
    ///   - [`timeout_in_millis(i32)`](crate::output::CreateIntegrationOutput::timeout_in_millis): <p>Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs. The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.</p>
    ///   - [`tls_config(Option<TlsConfig>)`](crate::output::CreateIntegrationOutput::tls_config): <p>The TLS configuration for a private integration. If you specify a TLS configuration, private integration traffic uses the HTTPS protocol. Supported only for HTTP APIs.</p>
    /// - On failure, responds with [`SdkError<CreateIntegrationError>`](crate::error::CreateIntegrationError)
    pub fn create_integration(&self) -> fluent_builders::CreateIntegration {
        fluent_builders::CreateIntegration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateIntegrationResponse`](crate::client::fluent_builders::CreateIntegrationResponse) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::CreateIntegrationResponse::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::CreateIntegrationResponse::set_api_id): <p>The API identifier.</p>
    ///   - [`content_handling_strategy(ContentHandlingStrategy)`](crate::client::fluent_builders::CreateIntegrationResponse::content_handling_strategy) / [`set_content_handling_strategy(Option<ContentHandlingStrategy>)`](crate::client::fluent_builders::CreateIntegrationResponse::set_content_handling_strategy): <p>Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p>  <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p>  <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p>  <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
    ///   - [`integration_id(impl Into<String>)`](crate::client::fluent_builders::CreateIntegrationResponse::integration_id) / [`set_integration_id(Option<String>)`](crate::client::fluent_builders::CreateIntegrationResponse::set_integration_id): <p>The integration ID.</p>
    ///   - [`integration_response_key(impl Into<String>)`](crate::client::fluent_builders::CreateIntegrationResponse::integration_response_key) / [`set_integration_response_key(Option<String>)`](crate::client::fluent_builders::CreateIntegrationResponse::set_integration_response_key): <p>The integration response key.</p>
    ///   - [`response_parameters(HashMap<String, String>)`](crate::client::fluent_builders::CreateIntegrationResponse::response_parameters) / [`set_response_parameters(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateIntegrationResponse::set_response_parameters): <p>A key-value map specifying response parameters that are passed to the method response from the backend. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of method.response.header.{name}, where {name} is a valid and unique header name. The mapped non-static value must match the pattern of integration.response.header.{name} or integration.response.body.{JSON-expression}, where {name} is a valid and unique response header name and {JSON-expression} is a valid JSON expression without the $ prefix.</p>
    ///   - [`response_templates(HashMap<String, String>)`](crate::client::fluent_builders::CreateIntegrationResponse::response_templates) / [`set_response_templates(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateIntegrationResponse::set_response_templates): <p>The collection of response templates for the integration response as a string-to-string map of key-value pairs. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.</p>
    ///   - [`template_selection_expression(impl Into<String>)`](crate::client::fluent_builders::CreateIntegrationResponse::template_selection_expression) / [`set_template_selection_expression(Option<String>)`](crate::client::fluent_builders::CreateIntegrationResponse::set_template_selection_expression): <p>The template selection expression for the integration response. Supported only for WebSocket APIs.</p>
    /// - On success, responds with [`CreateIntegrationResponseOutput`](crate::output::CreateIntegrationResponseOutput) with field(s):
    ///   - [`content_handling_strategy(Option<ContentHandlingStrategy>)`](crate::output::CreateIntegrationResponseOutput::content_handling_strategy): <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p>  <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p>  <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p>  <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
    ///   - [`integration_response_id(Option<String>)`](crate::output::CreateIntegrationResponseOutput::integration_response_id): <p>The integration response ID.</p>
    ///   - [`integration_response_key(Option<String>)`](crate::output::CreateIntegrationResponseOutput::integration_response_key): <p>The integration response key.</p>
    ///   - [`response_parameters(Option<HashMap<String, String>>)`](crate::output::CreateIntegrationResponseOutput::response_parameters): <p>A key-value map specifying response parameters that are passed to the method response from the backend. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of method.response.header.{name}, where name is a valid and unique header name. The mapped non-static value must match the pattern of integration.response.header.{name} or integration.response.body.{JSON-expression}, where name is a valid and unique response header name and JSON-expression is a valid JSON expression without the $ prefix.</p>
    ///   - [`response_templates(Option<HashMap<String, String>>)`](crate::output::CreateIntegrationResponseOutput::response_templates): <p>The collection of response templates for the integration response as a string-to-string map of key-value pairs. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.</p>
    ///   - [`template_selection_expression(Option<String>)`](crate::output::CreateIntegrationResponseOutput::template_selection_expression): <p>The template selection expressions for the integration response.</p>
    /// - On failure, responds with [`SdkError<CreateIntegrationResponseError>`](crate::error::CreateIntegrationResponseError)
    pub fn create_integration_response(&self) -> fluent_builders::CreateIntegrationResponse {
        fluent_builders::CreateIntegrationResponse::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateModel`](crate::client::fluent_builders::CreateModel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::CreateModel::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::CreateModel::set_api_id): <p>The API identifier.</p>
    ///   - [`content_type(impl Into<String>)`](crate::client::fluent_builders::CreateModel::content_type) / [`set_content_type(Option<String>)`](crate::client::fluent_builders::CreateModel::set_content_type): <p>The content-type for the model, for example, "application/json".</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateModel::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateModel::set_description): <p>The description of the model.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateModel::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateModel::set_name): <p>The name of the model. Must be alphanumeric.</p>
    ///   - [`schema(impl Into<String>)`](crate::client::fluent_builders::CreateModel::schema) / [`set_schema(Option<String>)`](crate::client::fluent_builders::CreateModel::set_schema): <p>The schema for the model. For application/json models, this should be JSON schema draft 4 model.</p>
    /// - On success, responds with [`CreateModelOutput`](crate::output::CreateModelOutput) with field(s):
    ///   - [`content_type(Option<String>)`](crate::output::CreateModelOutput::content_type): <p>The content-type for the model, for example, "application/json".</p>
    ///   - [`description(Option<String>)`](crate::output::CreateModelOutput::description): <p>The description of the model.</p>
    ///   - [`model_id(Option<String>)`](crate::output::CreateModelOutput::model_id): <p>The model identifier.</p>
    ///   - [`name(Option<String>)`](crate::output::CreateModelOutput::name): <p>The name of the model. Must be alphanumeric.</p>
    ///   - [`schema(Option<String>)`](crate::output::CreateModelOutput::schema): <p>The schema for the model. For application/json models, this should be JSON schema draft 4 model.</p>
    /// - On failure, responds with [`SdkError<CreateModelError>`](crate::error::CreateModelError)
    pub fn create_model(&self) -> fluent_builders::CreateModel {
        fluent_builders::CreateModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateRoute`](crate::client::fluent_builders::CreateRoute) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::CreateRoute::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::CreateRoute::set_api_id): <p>The API identifier.</p>
    ///   - [`api_key_required(bool)`](crate::client::fluent_builders::CreateRoute::api_key_required) / [`set_api_key_required(bool)`](crate::client::fluent_builders::CreateRoute::set_api_key_required): <p>Specifies whether an API key is required for the route. Supported only for WebSocket APIs.</p>
    ///   - [`authorization_scopes(Vec<String>)`](crate::client::fluent_builders::CreateRoute::authorization_scopes) / [`set_authorization_scopes(Option<Vec<String>>)`](crate::client::fluent_builders::CreateRoute::set_authorization_scopes): <p>The authorization scopes supported by this route.</p>
    ///   - [`authorization_type(AuthorizationType)`](crate::client::fluent_builders::CreateRoute::authorization_type) / [`set_authorization_type(Option<AuthorizationType>)`](crate::client::fluent_builders::CreateRoute::set_authorization_type): <p>The authorization type for the route. For WebSocket APIs, valid values are NONE for open access, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer For HTTP APIs, valid values are NONE for open access, JWT for using JSON Web Tokens, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer.</p>
    ///   - [`authorizer_id(impl Into<String>)`](crate::client::fluent_builders::CreateRoute::authorizer_id) / [`set_authorizer_id(Option<String>)`](crate::client::fluent_builders::CreateRoute::set_authorizer_id): <p>The identifier of the Authorizer resource to be associated with this route. The authorizer identifier is generated by API Gateway when you created the authorizer.</p>
    ///   - [`model_selection_expression(impl Into<String>)`](crate::client::fluent_builders::CreateRoute::model_selection_expression) / [`set_model_selection_expression(Option<String>)`](crate::client::fluent_builders::CreateRoute::set_model_selection_expression): <p>The model selection expression for the route. Supported only for WebSocket APIs.</p>
    ///   - [`operation_name(impl Into<String>)`](crate::client::fluent_builders::CreateRoute::operation_name) / [`set_operation_name(Option<String>)`](crate::client::fluent_builders::CreateRoute::set_operation_name): <p>The operation name for the route.</p>
    ///   - [`request_models(HashMap<String, String>)`](crate::client::fluent_builders::CreateRoute::request_models) / [`set_request_models(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateRoute::set_request_models): <p>The request models for the route. Supported only for WebSocket APIs.</p>
    ///   - [`request_parameters(HashMap<String, ParameterConstraints>)`](crate::client::fluent_builders::CreateRoute::request_parameters) / [`set_request_parameters(Option<HashMap<String, ParameterConstraints>>)`](crate::client::fluent_builders::CreateRoute::set_request_parameters): <p>The request parameters for the route. Supported only for WebSocket APIs.</p>
    ///   - [`route_key(impl Into<String>)`](crate::client::fluent_builders::CreateRoute::route_key) / [`set_route_key(Option<String>)`](crate::client::fluent_builders::CreateRoute::set_route_key): <p>The route key for the route.</p>
    ///   - [`route_response_selection_expression(impl Into<String>)`](crate::client::fluent_builders::CreateRoute::route_response_selection_expression) / [`set_route_response_selection_expression(Option<String>)`](crate::client::fluent_builders::CreateRoute::set_route_response_selection_expression): <p>The route response selection expression for the route. Supported only for WebSocket APIs.</p>
    ///   - [`target(impl Into<String>)`](crate::client::fluent_builders::CreateRoute::target) / [`set_target(Option<String>)`](crate::client::fluent_builders::CreateRoute::set_target): <p>The target for the route.</p>
    /// - On success, responds with [`CreateRouteOutput`](crate::output::CreateRouteOutput) with field(s):
    ///   - [`api_gateway_managed(bool)`](crate::output::CreateRouteOutput::api_gateway_managed): <p>Specifies whether a route is managed by API Gateway. If you created an API using quick create, the $default route is managed by API Gateway. You can't modify the $default route key.</p>
    ///   - [`api_key_required(bool)`](crate::output::CreateRouteOutput::api_key_required): <p>Specifies whether an API key is required for this route. Supported only for WebSocket APIs.</p>
    ///   - [`authorization_scopes(Option<Vec<String>>)`](crate::output::CreateRouteOutput::authorization_scopes): <p>A list of authorization scopes configured on a route. The scopes are used with a JWT authorizer to authorize the method invocation. The authorization works by matching the route scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any route scope matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the route scope is configured, the client must provide an access token instead of an identity token for authorization purposes.</p>
    ///   - [`authorization_type(Option<AuthorizationType>)`](crate::output::CreateRouteOutput::authorization_type): <p>The authorization type for the route. For WebSocket APIs, valid values are NONE for open access, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer For HTTP APIs, valid values are NONE for open access, JWT for using JSON Web Tokens, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer.</p>
    ///   - [`authorizer_id(Option<String>)`](crate::output::CreateRouteOutput::authorizer_id): <p>The identifier of the Authorizer resource to be associated with this route. The authorizer identifier is generated by API Gateway when you created the authorizer.</p>
    ///   - [`model_selection_expression(Option<String>)`](crate::output::CreateRouteOutput::model_selection_expression): <p>The model selection expression for the route. Supported only for WebSocket APIs.</p>
    ///   - [`operation_name(Option<String>)`](crate::output::CreateRouteOutput::operation_name): <p>The operation name for the route.</p>
    ///   - [`request_models(Option<HashMap<String, String>>)`](crate::output::CreateRouteOutput::request_models): <p>The request models for the route. Supported only for WebSocket APIs.</p>
    ///   - [`request_parameters(Option<HashMap<String, ParameterConstraints>>)`](crate::output::CreateRouteOutput::request_parameters): <p>The request parameters for the route. Supported only for WebSocket APIs.</p>
    ///   - [`route_id(Option<String>)`](crate::output::CreateRouteOutput::route_id): <p>The route ID.</p>
    ///   - [`route_key(Option<String>)`](crate::output::CreateRouteOutput::route_key): <p>The route key for the route.</p>
    ///   - [`route_response_selection_expression(Option<String>)`](crate::output::CreateRouteOutput::route_response_selection_expression): <p>The route response selection expression for the route. Supported only for WebSocket APIs.</p>
    ///   - [`target(Option<String>)`](crate::output::CreateRouteOutput::target): <p>The target for the route.</p>
    /// - On failure, responds with [`SdkError<CreateRouteError>`](crate::error::CreateRouteError)
    pub fn create_route(&self) -> fluent_builders::CreateRoute {
        fluent_builders::CreateRoute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateRouteResponse`](crate::client::fluent_builders::CreateRouteResponse) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::CreateRouteResponse::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::CreateRouteResponse::set_api_id): <p>The API identifier.</p>
    ///   - [`model_selection_expression(impl Into<String>)`](crate::client::fluent_builders::CreateRouteResponse::model_selection_expression) / [`set_model_selection_expression(Option<String>)`](crate::client::fluent_builders::CreateRouteResponse::set_model_selection_expression): <p>The model selection expression for the route response. Supported only for WebSocket APIs.</p>
    ///   - [`response_models(HashMap<String, String>)`](crate::client::fluent_builders::CreateRouteResponse::response_models) / [`set_response_models(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateRouteResponse::set_response_models): <p>The response models for the route response.</p>
    ///   - [`response_parameters(HashMap<String, ParameterConstraints>)`](crate::client::fluent_builders::CreateRouteResponse::response_parameters) / [`set_response_parameters(Option<HashMap<String, ParameterConstraints>>)`](crate::client::fluent_builders::CreateRouteResponse::set_response_parameters): <p>The route response parameters.</p>
    ///   - [`route_id(impl Into<String>)`](crate::client::fluent_builders::CreateRouteResponse::route_id) / [`set_route_id(Option<String>)`](crate::client::fluent_builders::CreateRouteResponse::set_route_id): <p>The route ID.</p>
    ///   - [`route_response_key(impl Into<String>)`](crate::client::fluent_builders::CreateRouteResponse::route_response_key) / [`set_route_response_key(Option<String>)`](crate::client::fluent_builders::CreateRouteResponse::set_route_response_key): <p>The route response key.</p>
    /// - On success, responds with [`CreateRouteResponseOutput`](crate::output::CreateRouteResponseOutput) with field(s):
    ///   - [`model_selection_expression(Option<String>)`](crate::output::CreateRouteResponseOutput::model_selection_expression): <p>Represents the model selection expression of a route response. Supported only for WebSocket APIs.</p>
    ///   - [`response_models(Option<HashMap<String, String>>)`](crate::output::CreateRouteResponseOutput::response_models): <p>Represents the response models of a route response.</p>
    ///   - [`response_parameters(Option<HashMap<String, ParameterConstraints>>)`](crate::output::CreateRouteResponseOutput::response_parameters): <p>Represents the response parameters of a route response.</p>
    ///   - [`route_response_id(Option<String>)`](crate::output::CreateRouteResponseOutput::route_response_id): <p>Represents the identifier of a route response.</p>
    ///   - [`route_response_key(Option<String>)`](crate::output::CreateRouteResponseOutput::route_response_key): <p>Represents the route response key of a route response.</p>
    /// - On failure, responds with [`SdkError<CreateRouteResponseError>`](crate::error::CreateRouteResponseError)
    pub fn create_route_response(&self) -> fluent_builders::CreateRouteResponse {
        fluent_builders::CreateRouteResponse::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateStage`](crate::client::fluent_builders::CreateStage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`access_log_settings(AccessLogSettings)`](crate::client::fluent_builders::CreateStage::access_log_settings) / [`set_access_log_settings(Option<AccessLogSettings>)`](crate::client::fluent_builders::CreateStage::set_access_log_settings): <p>Settings for logging access in this stage.</p>
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::CreateStage::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::CreateStage::set_api_id): <p>The API identifier.</p>
    ///   - [`auto_deploy(bool)`](crate::client::fluent_builders::CreateStage::auto_deploy) / [`set_auto_deploy(bool)`](crate::client::fluent_builders::CreateStage::set_auto_deploy): <p>Specifies whether updates to an API automatically trigger a new deployment. The default value is false.</p>
    ///   - [`client_certificate_id(impl Into<String>)`](crate::client::fluent_builders::CreateStage::client_certificate_id) / [`set_client_certificate_id(Option<String>)`](crate::client::fluent_builders::CreateStage::set_client_certificate_id): <p>The identifier of a client certificate for a Stage. Supported only for WebSocket APIs.</p>
    ///   - [`default_route_settings(RouteSettings)`](crate::client::fluent_builders::CreateStage::default_route_settings) / [`set_default_route_settings(Option<RouteSettings>)`](crate::client::fluent_builders::CreateStage::set_default_route_settings): <p>The default route settings for the stage.</p>
    ///   - [`deployment_id(impl Into<String>)`](crate::client::fluent_builders::CreateStage::deployment_id) / [`set_deployment_id(Option<String>)`](crate::client::fluent_builders::CreateStage::set_deployment_id): <p>The deployment identifier of the API stage.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateStage::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateStage::set_description): <p>The description for the API stage.</p>
    ///   - [`route_settings(HashMap<String, RouteSettings>)`](crate::client::fluent_builders::CreateStage::route_settings) / [`set_route_settings(Option<HashMap<String, RouteSettings>>)`](crate::client::fluent_builders::CreateStage::set_route_settings): <p>Route settings for the stage, by routeKey.</p>
    ///   - [`stage_name(impl Into<String>)`](crate::client::fluent_builders::CreateStage::stage_name) / [`set_stage_name(Option<String>)`](crate::client::fluent_builders::CreateStage::set_stage_name): <p>The name of the stage.</p>
    ///   - [`stage_variables(HashMap<String, String>)`](crate::client::fluent_builders::CreateStage::stage_variables) / [`set_stage_variables(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateStage::set_stage_variables): <p>A map that defines the stage variables for a Stage. Variable names can have alphanumeric and underscore characters, and the values must match [A-Za-z0-9-._~:/?#&amp;=,]+.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateStage::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateStage::set_tags): <p>The collection of tags. Each tag element is associated with a given resource.</p>
    /// - On success, responds with [`CreateStageOutput`](crate::output::CreateStageOutput) with field(s):
    ///   - [`access_log_settings(Option<AccessLogSettings>)`](crate::output::CreateStageOutput::access_log_settings): <p>Settings for logging access in this stage.</p>
    ///   - [`api_gateway_managed(bool)`](crate::output::CreateStageOutput::api_gateway_managed): <p>Specifies whether a stage is managed by API Gateway. If you created an API using quick create, the $default stage is managed by API Gateway. You can't modify the $default stage.</p>
    ///   - [`auto_deploy(bool)`](crate::output::CreateStageOutput::auto_deploy): <p>Specifies whether updates to an API automatically trigger a new deployment. The default value is false.</p>
    ///   - [`client_certificate_id(Option<String>)`](crate::output::CreateStageOutput::client_certificate_id): <p>The identifier of a client certificate for a Stage. Supported only for WebSocket APIs.</p>
    ///   - [`created_date(Option<DateTime>)`](crate::output::CreateStageOutput::created_date): <p>The timestamp when the stage was created.</p>
    ///   - [`default_route_settings(Option<RouteSettings>)`](crate::output::CreateStageOutput::default_route_settings): <p>Default route settings for the stage.</p>
    ///   - [`deployment_id(Option<String>)`](crate::output::CreateStageOutput::deployment_id): <p>The identifier of the Deployment that the Stage is associated with. Can't be updated if autoDeploy is enabled.</p>
    ///   - [`description(Option<String>)`](crate::output::CreateStageOutput::description): <p>The description of the stage.</p>
    ///   - [`last_deployment_status_message(Option<String>)`](crate::output::CreateStageOutput::last_deployment_status_message): <p>Describes the status of the last deployment of a stage. Supported only for stages with autoDeploy enabled.</p>
    ///   - [`last_updated_date(Option<DateTime>)`](crate::output::CreateStageOutput::last_updated_date): <p>The timestamp when the stage was last updated.</p>
    ///   - [`route_settings(Option<HashMap<String, RouteSettings>>)`](crate::output::CreateStageOutput::route_settings): <p>Route settings for the stage, by routeKey.</p>
    ///   - [`stage_name(Option<String>)`](crate::output::CreateStageOutput::stage_name): <p>The name of the stage.</p>
    ///   - [`stage_variables(Option<HashMap<String, String>>)`](crate::output::CreateStageOutput::stage_variables): <p>A map that defines the stage variables for a stage resource. Variable names can have alphanumeric and underscore characters, and the values must match [A-Za-z0-9-._~:/?#&amp;=,]+.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::CreateStageOutput::tags): <p>The collection of tags. Each tag element is associated with a given resource.</p>
    /// - On failure, responds with [`SdkError<CreateStageError>`](crate::error::CreateStageError)
    pub fn create_stage(&self) -> fluent_builders::CreateStage {
        fluent_builders::CreateStage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateVpcLink`](crate::client::fluent_builders::CreateVpcLink) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateVpcLink::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateVpcLink::set_name): <p>The name of the VPC link.</p>
    ///   - [`security_group_ids(Vec<String>)`](crate::client::fluent_builders::CreateVpcLink::security_group_ids) / [`set_security_group_ids(Option<Vec<String>>)`](crate::client::fluent_builders::CreateVpcLink::set_security_group_ids): <p>A list of security group IDs for the VPC link.</p>
    ///   - [`subnet_ids(Vec<String>)`](crate::client::fluent_builders::CreateVpcLink::subnet_ids) / [`set_subnet_ids(Option<Vec<String>>)`](crate::client::fluent_builders::CreateVpcLink::set_subnet_ids): <p>A list of subnet IDs to include in the VPC link.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateVpcLink::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateVpcLink::set_tags): <p>A list of tags.</p>
    /// - On success, responds with [`CreateVpcLinkOutput`](crate::output::CreateVpcLinkOutput) with field(s):
    ///   - [`created_date(Option<DateTime>)`](crate::output::CreateVpcLinkOutput::created_date): <p>The timestamp when the VPC link was created.</p>
    ///   - [`name(Option<String>)`](crate::output::CreateVpcLinkOutput::name): <p>The name of the VPC link.</p>
    ///   - [`security_group_ids(Option<Vec<String>>)`](crate::output::CreateVpcLinkOutput::security_group_ids): <p>A list of security group IDs for the VPC link.</p>
    ///   - [`subnet_ids(Option<Vec<String>>)`](crate::output::CreateVpcLinkOutput::subnet_ids): <p>A list of subnet IDs to include in the VPC link.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::CreateVpcLinkOutput::tags): <p>Tags for the VPC link.</p>
    ///   - [`vpc_link_id(Option<String>)`](crate::output::CreateVpcLinkOutput::vpc_link_id): <p>The ID of the VPC link.</p>
    ///   - [`vpc_link_status(Option<VpcLinkStatus>)`](crate::output::CreateVpcLinkOutput::vpc_link_status): <p>The status of the VPC link.</p>
    ///   - [`vpc_link_status_message(Option<String>)`](crate::output::CreateVpcLinkOutput::vpc_link_status_message): <p>A message summarizing the cause of the status of the VPC link.</p>
    ///   - [`vpc_link_version(Option<VpcLinkVersion>)`](crate::output::CreateVpcLinkOutput::vpc_link_version): <p>The version of the VPC link.</p>
    /// - On failure, responds with [`SdkError<CreateVpcLinkError>`](crate::error::CreateVpcLinkError)
    pub fn create_vpc_link(&self) -> fluent_builders::CreateVpcLink {
        fluent_builders::CreateVpcLink::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteAccessLogSettings`](crate::client::fluent_builders::DeleteAccessLogSettings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::DeleteAccessLogSettings::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::DeleteAccessLogSettings::set_api_id): <p>The API identifier.</p>
    ///   - [`stage_name(impl Into<String>)`](crate::client::fluent_builders::DeleteAccessLogSettings::stage_name) / [`set_stage_name(Option<String>)`](crate::client::fluent_builders::DeleteAccessLogSettings::set_stage_name): <p>The stage name. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.</p>
    /// - On success, responds with [`DeleteAccessLogSettingsOutput`](crate::output::DeleteAccessLogSettingsOutput)

    /// - On failure, responds with [`SdkError<DeleteAccessLogSettingsError>`](crate::error::DeleteAccessLogSettingsError)
    pub fn delete_access_log_settings(&self) -> fluent_builders::DeleteAccessLogSettings {
        fluent_builders::DeleteAccessLogSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteApi`](crate::client::fluent_builders::DeleteApi) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::DeleteApi::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::DeleteApi::set_api_id): <p>The API identifier.</p>
    /// - On success, responds with [`DeleteApiOutput`](crate::output::DeleteApiOutput)

    /// - On failure, responds with [`SdkError<DeleteApiError>`](crate::error::DeleteApiError)
    pub fn delete_api(&self) -> fluent_builders::DeleteApi {
        fluent_builders::DeleteApi::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteApiMapping`](crate::client::fluent_builders::DeleteApiMapping) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_mapping_id(impl Into<String>)`](crate::client::fluent_builders::DeleteApiMapping::api_mapping_id) / [`set_api_mapping_id(Option<String>)`](crate::client::fluent_builders::DeleteApiMapping::set_api_mapping_id): <p>The API mapping identifier.</p>
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::DeleteApiMapping::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::DeleteApiMapping::set_domain_name): <p>The domain name.</p>
    /// - On success, responds with [`DeleteApiMappingOutput`](crate::output::DeleteApiMappingOutput)

    /// - On failure, responds with [`SdkError<DeleteApiMappingError>`](crate::error::DeleteApiMappingError)
    pub fn delete_api_mapping(&self) -> fluent_builders::DeleteApiMapping {
        fluent_builders::DeleteApiMapping::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteAuthorizer`](crate::client::fluent_builders::DeleteAuthorizer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::DeleteAuthorizer::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::DeleteAuthorizer::set_api_id): <p>The API identifier.</p>
    ///   - [`authorizer_id(impl Into<String>)`](crate::client::fluent_builders::DeleteAuthorizer::authorizer_id) / [`set_authorizer_id(Option<String>)`](crate::client::fluent_builders::DeleteAuthorizer::set_authorizer_id): <p>The authorizer identifier.</p>
    /// - On success, responds with [`DeleteAuthorizerOutput`](crate::output::DeleteAuthorizerOutput)

    /// - On failure, responds with [`SdkError<DeleteAuthorizerError>`](crate::error::DeleteAuthorizerError)
    pub fn delete_authorizer(&self) -> fluent_builders::DeleteAuthorizer {
        fluent_builders::DeleteAuthorizer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteCorsConfiguration`](crate::client::fluent_builders::DeleteCorsConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::DeleteCorsConfiguration::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::DeleteCorsConfiguration::set_api_id): <p>The API identifier.</p>
    /// - On success, responds with [`DeleteCorsConfigurationOutput`](crate::output::DeleteCorsConfigurationOutput)

    /// - On failure, responds with [`SdkError<DeleteCorsConfigurationError>`](crate::error::DeleteCorsConfigurationError)
    pub fn delete_cors_configuration(&self) -> fluent_builders::DeleteCorsConfiguration {
        fluent_builders::DeleteCorsConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDeployment`](crate::client::fluent_builders::DeleteDeployment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::DeleteDeployment::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::DeleteDeployment::set_api_id): <p>The API identifier.</p>
    ///   - [`deployment_id(impl Into<String>)`](crate::client::fluent_builders::DeleteDeployment::deployment_id) / [`set_deployment_id(Option<String>)`](crate::client::fluent_builders::DeleteDeployment::set_deployment_id): <p>The deployment ID.</p>
    /// - On success, responds with [`DeleteDeploymentOutput`](crate::output::DeleteDeploymentOutput)

    /// - On failure, responds with [`SdkError<DeleteDeploymentError>`](crate::error::DeleteDeploymentError)
    pub fn delete_deployment(&self) -> fluent_builders::DeleteDeployment {
        fluent_builders::DeleteDeployment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDomainName`](crate::client::fluent_builders::DeleteDomainName) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::DeleteDomainName::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::DeleteDomainName::set_domain_name): <p>The domain name.</p>
    /// - On success, responds with [`DeleteDomainNameOutput`](crate::output::DeleteDomainNameOutput)

    /// - On failure, responds with [`SdkError<DeleteDomainNameError>`](crate::error::DeleteDomainNameError)
    pub fn delete_domain_name(&self) -> fluent_builders::DeleteDomainName {
        fluent_builders::DeleteDomainName::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteIntegration`](crate::client::fluent_builders::DeleteIntegration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::DeleteIntegration::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::DeleteIntegration::set_api_id): <p>The API identifier.</p>
    ///   - [`integration_id(impl Into<String>)`](crate::client::fluent_builders::DeleteIntegration::integration_id) / [`set_integration_id(Option<String>)`](crate::client::fluent_builders::DeleteIntegration::set_integration_id): <p>The integration ID.</p>
    /// - On success, responds with [`DeleteIntegrationOutput`](crate::output::DeleteIntegrationOutput)

    /// - On failure, responds with [`SdkError<DeleteIntegrationError>`](crate::error::DeleteIntegrationError)
    pub fn delete_integration(&self) -> fluent_builders::DeleteIntegration {
        fluent_builders::DeleteIntegration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteIntegrationResponse`](crate::client::fluent_builders::DeleteIntegrationResponse) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::DeleteIntegrationResponse::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::DeleteIntegrationResponse::set_api_id): <p>The API identifier.</p>
    ///   - [`integration_id(impl Into<String>)`](crate::client::fluent_builders::DeleteIntegrationResponse::integration_id) / [`set_integration_id(Option<String>)`](crate::client::fluent_builders::DeleteIntegrationResponse::set_integration_id): <p>The integration ID.</p>
    ///   - [`integration_response_id(impl Into<String>)`](crate::client::fluent_builders::DeleteIntegrationResponse::integration_response_id) / [`set_integration_response_id(Option<String>)`](crate::client::fluent_builders::DeleteIntegrationResponse::set_integration_response_id): <p>The integration response ID.</p>
    /// - On success, responds with [`DeleteIntegrationResponseOutput`](crate::output::DeleteIntegrationResponseOutput)

    /// - On failure, responds with [`SdkError<DeleteIntegrationResponseError>`](crate::error::DeleteIntegrationResponseError)
    pub fn delete_integration_response(&self) -> fluent_builders::DeleteIntegrationResponse {
        fluent_builders::DeleteIntegrationResponse::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteModel`](crate::client::fluent_builders::DeleteModel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::DeleteModel::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::DeleteModel::set_api_id): <p>The API identifier.</p>
    ///   - [`model_id(impl Into<String>)`](crate::client::fluent_builders::DeleteModel::model_id) / [`set_model_id(Option<String>)`](crate::client::fluent_builders::DeleteModel::set_model_id): <p>The model ID.</p>
    /// - On success, responds with [`DeleteModelOutput`](crate::output::DeleteModelOutput)

    /// - On failure, responds with [`SdkError<DeleteModelError>`](crate::error::DeleteModelError)
    pub fn delete_model(&self) -> fluent_builders::DeleteModel {
        fluent_builders::DeleteModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteRoute`](crate::client::fluent_builders::DeleteRoute) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::DeleteRoute::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::DeleteRoute::set_api_id): <p>The API identifier.</p>
    ///   - [`route_id(impl Into<String>)`](crate::client::fluent_builders::DeleteRoute::route_id) / [`set_route_id(Option<String>)`](crate::client::fluent_builders::DeleteRoute::set_route_id): <p>The route ID.</p>
    /// - On success, responds with [`DeleteRouteOutput`](crate::output::DeleteRouteOutput)

    /// - On failure, responds with [`SdkError<DeleteRouteError>`](crate::error::DeleteRouteError)
    pub fn delete_route(&self) -> fluent_builders::DeleteRoute {
        fluent_builders::DeleteRoute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteRouteRequestParameter`](crate::client::fluent_builders::DeleteRouteRequestParameter) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::DeleteRouteRequestParameter::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::DeleteRouteRequestParameter::set_api_id): <p>The API identifier.</p>
    ///   - [`request_parameter_key(impl Into<String>)`](crate::client::fluent_builders::DeleteRouteRequestParameter::request_parameter_key) / [`set_request_parameter_key(Option<String>)`](crate::client::fluent_builders::DeleteRouteRequestParameter::set_request_parameter_key): <p>The route request parameter key.</p>
    ///   - [`route_id(impl Into<String>)`](crate::client::fluent_builders::DeleteRouteRequestParameter::route_id) / [`set_route_id(Option<String>)`](crate::client::fluent_builders::DeleteRouteRequestParameter::set_route_id): <p>The route ID.</p>
    /// - On success, responds with [`DeleteRouteRequestParameterOutput`](crate::output::DeleteRouteRequestParameterOutput)

    /// - On failure, responds with [`SdkError<DeleteRouteRequestParameterError>`](crate::error::DeleteRouteRequestParameterError)
    pub fn delete_route_request_parameter(&self) -> fluent_builders::DeleteRouteRequestParameter {
        fluent_builders::DeleteRouteRequestParameter::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteRouteResponse`](crate::client::fluent_builders::DeleteRouteResponse) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::DeleteRouteResponse::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::DeleteRouteResponse::set_api_id): <p>The API identifier.</p>
    ///   - [`route_id(impl Into<String>)`](crate::client::fluent_builders::DeleteRouteResponse::route_id) / [`set_route_id(Option<String>)`](crate::client::fluent_builders::DeleteRouteResponse::set_route_id): <p>The route ID.</p>
    ///   - [`route_response_id(impl Into<String>)`](crate::client::fluent_builders::DeleteRouteResponse::route_response_id) / [`set_route_response_id(Option<String>)`](crate::client::fluent_builders::DeleteRouteResponse::set_route_response_id): <p>The route response ID.</p>
    /// - On success, responds with [`DeleteRouteResponseOutput`](crate::output::DeleteRouteResponseOutput)

    /// - On failure, responds with [`SdkError<DeleteRouteResponseError>`](crate::error::DeleteRouteResponseError)
    pub fn delete_route_response(&self) -> fluent_builders::DeleteRouteResponse {
        fluent_builders::DeleteRouteResponse::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteRouteSettings`](crate::client::fluent_builders::DeleteRouteSettings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::DeleteRouteSettings::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::DeleteRouteSettings::set_api_id): <p>The API identifier.</p>
    ///   - [`route_key(impl Into<String>)`](crate::client::fluent_builders::DeleteRouteSettings::route_key) / [`set_route_key(Option<String>)`](crate::client::fluent_builders::DeleteRouteSettings::set_route_key): <p>The route key.</p>
    ///   - [`stage_name(impl Into<String>)`](crate::client::fluent_builders::DeleteRouteSettings::stage_name) / [`set_stage_name(Option<String>)`](crate::client::fluent_builders::DeleteRouteSettings::set_stage_name): <p>The stage name. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.</p>
    /// - On success, responds with [`DeleteRouteSettingsOutput`](crate::output::DeleteRouteSettingsOutput)

    /// - On failure, responds with [`SdkError<DeleteRouteSettingsError>`](crate::error::DeleteRouteSettingsError)
    pub fn delete_route_settings(&self) -> fluent_builders::DeleteRouteSettings {
        fluent_builders::DeleteRouteSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteStage`](crate::client::fluent_builders::DeleteStage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::DeleteStage::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::DeleteStage::set_api_id): <p>The API identifier.</p>
    ///   - [`stage_name(impl Into<String>)`](crate::client::fluent_builders::DeleteStage::stage_name) / [`set_stage_name(Option<String>)`](crate::client::fluent_builders::DeleteStage::set_stage_name): <p>The stage name. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.</p>
    /// - On success, responds with [`DeleteStageOutput`](crate::output::DeleteStageOutput)

    /// - On failure, responds with [`SdkError<DeleteStageError>`](crate::error::DeleteStageError)
    pub fn delete_stage(&self) -> fluent_builders::DeleteStage {
        fluent_builders::DeleteStage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteVpcLink`](crate::client::fluent_builders::DeleteVpcLink) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`vpc_link_id(impl Into<String>)`](crate::client::fluent_builders::DeleteVpcLink::vpc_link_id) / [`set_vpc_link_id(Option<String>)`](crate::client::fluent_builders::DeleteVpcLink::set_vpc_link_id): <p>The ID of the VPC link.</p>
    /// - On success, responds with [`DeleteVpcLinkOutput`](crate::output::DeleteVpcLinkOutput)

    /// - On failure, responds with [`SdkError<DeleteVpcLinkError>`](crate::error::DeleteVpcLinkError)
    pub fn delete_vpc_link(&self) -> fluent_builders::DeleteVpcLink {
        fluent_builders::DeleteVpcLink::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ExportApi`](crate::client::fluent_builders::ExportApi) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::ExportApi::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::ExportApi::set_api_id): <p>The API identifier.</p>
    ///   - [`export_version(impl Into<String>)`](crate::client::fluent_builders::ExportApi::export_version) / [`set_export_version(Option<String>)`](crate::client::fluent_builders::ExportApi::set_export_version): <p>The version of the API Gateway export algorithm. API Gateway uses the latest version by default. Currently, the only supported version is 1.0.</p>
    ///   - [`include_extensions(bool)`](crate::client::fluent_builders::ExportApi::include_extensions) / [`set_include_extensions(bool)`](crate::client::fluent_builders::ExportApi::set_include_extensions): <p>Specifies whether to include <a href="https://docs.aws.amazon.com//apigateway/latest/developerguide/api-gateway-swagger-extensions.html">API Gateway extensions</a> in the exported API definition. API Gateway extensions are included by default.</p>
    ///   - [`output_type(impl Into<String>)`](crate::client::fluent_builders::ExportApi::output_type) / [`set_output_type(Option<String>)`](crate::client::fluent_builders::ExportApi::set_output_type): <p>The output type of the exported definition file. Valid values are JSON and YAML.</p>
    ///   - [`specification(impl Into<String>)`](crate::client::fluent_builders::ExportApi::specification) / [`set_specification(Option<String>)`](crate::client::fluent_builders::ExportApi::set_specification): <p>The version of the API specification to use. OAS30, for OpenAPI 3.0, is the only supported value.</p>
    ///   - [`stage_name(impl Into<String>)`](crate::client::fluent_builders::ExportApi::stage_name) / [`set_stage_name(Option<String>)`](crate::client::fluent_builders::ExportApi::set_stage_name): <p>The name of the API stage to export. If you don't specify this property, a representation of the latest API configuration is exported.</p>
    /// - On success, responds with [`ExportApiOutput`](crate::output::ExportApiOutput) with field(s):
    ///   - [`body(Option<Blob>)`](crate::output::ExportApiOutput::body): <p>Represents an exported definition of an API in a particular output format, for example, YAML. The API is serialized to the requested specification, for example, OpenAPI 3.0.</p>
    /// - On failure, responds with [`SdkError<ExportApiError>`](crate::error::ExportApiError)
    pub fn export_api(&self) -> fluent_builders::ExportApi {
        fluent_builders::ExportApi::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetApi`](crate::client::fluent_builders::GetApi) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::GetApi::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::GetApi::set_api_id): <p>The API identifier.</p>
    /// - On success, responds with [`GetApiOutput`](crate::output::GetApiOutput) with field(s):
    ///   - [`api_endpoint(Option<String>)`](crate::output::GetApiOutput::api_endpoint): <p>The URI of the API, of the form {api-id}.execute-api.{region}.amazonaws.com. The stage name is typically appended to this URI to form a complete path to a deployed API stage.</p>
    ///   - [`api_gateway_managed(bool)`](crate::output::GetApiOutput::api_gateway_managed): <p>Specifies whether an API is managed by API Gateway. You can't update or delete a managed API by using API Gateway. A managed API can be deleted only through the tooling or service that created it.</p>
    ///   - [`api_id(Option<String>)`](crate::output::GetApiOutput::api_id): <p>The API ID.</p>
    ///   - [`api_key_selection_expression(Option<String>)`](crate::output::GetApiOutput::api_key_selection_expression): <p>An API key selection expression. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions">API Key Selection Expressions</a>.</p>
    ///   - [`cors_configuration(Option<Cors>)`](crate::output::GetApiOutput::cors_configuration): <p>A CORS configuration. Supported only for HTTP APIs.</p>
    ///   - [`created_date(Option<DateTime>)`](crate::output::GetApiOutput::created_date): <p>The timestamp when the API was created.</p>
    ///   - [`description(Option<String>)`](crate::output::GetApiOutput::description): <p>The description of the API.</p>
    ///   - [`disable_schema_validation(bool)`](crate::output::GetApiOutput::disable_schema_validation): <p>Avoid validating models when creating a deployment. Supported only for WebSocket APIs.</p>
    ///   - [`disable_execute_api_endpoint(bool)`](crate::output::GetApiOutput::disable_execute_api_endpoint): <p>Specifies whether clients can invoke your API by using the default execute-api endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
    ///   - [`import_info(Option<Vec<String>>)`](crate::output::GetApiOutput::import_info): <p>The validation information during API import. This may include particular properties of your OpenAPI definition which are ignored during import. Supported only for HTTP APIs.</p>
    ///   - [`name(Option<String>)`](crate::output::GetApiOutput::name): <p>The name of the API.</p>
    ///   - [`protocol_type(Option<ProtocolType>)`](crate::output::GetApiOutput::protocol_type): <p>The API protocol.</p>
    ///   - [`route_selection_expression(Option<String>)`](crate::output::GetApiOutput::route_selection_expression): <p>The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::GetApiOutput::tags): <p>A collection of tags associated with the API.</p>
    ///   - [`version(Option<String>)`](crate::output::GetApiOutput::version): <p>A version identifier for the API.</p>
    ///   - [`warnings(Option<Vec<String>>)`](crate::output::GetApiOutput::warnings): <p>The warning messages reported when failonwarnings is turned on during API import.</p>
    /// - On failure, responds with [`SdkError<GetApiError>`](crate::error::GetApiError)
    pub fn get_api(&self) -> fluent_builders::GetApi {
        fluent_builders::GetApi::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetApiMapping`](crate::client::fluent_builders::GetApiMapping) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_mapping_id(impl Into<String>)`](crate::client::fluent_builders::GetApiMapping::api_mapping_id) / [`set_api_mapping_id(Option<String>)`](crate::client::fluent_builders::GetApiMapping::set_api_mapping_id): <p>The API mapping identifier.</p>
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::GetApiMapping::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::GetApiMapping::set_domain_name): <p>The domain name.</p>
    /// - On success, responds with [`GetApiMappingOutput`](crate::output::GetApiMappingOutput) with field(s):
    ///   - [`api_id(Option<String>)`](crate::output::GetApiMappingOutput::api_id): <p>The API identifier.</p>
    ///   - [`api_mapping_id(Option<String>)`](crate::output::GetApiMappingOutput::api_mapping_id): <p>The API mapping identifier.</p>
    ///   - [`api_mapping_key(Option<String>)`](crate::output::GetApiMappingOutput::api_mapping_key): <p>The API mapping key.</p>
    ///   - [`stage(Option<String>)`](crate::output::GetApiMappingOutput::stage): <p>The API stage.</p>
    /// - On failure, responds with [`SdkError<GetApiMappingError>`](crate::error::GetApiMappingError)
    pub fn get_api_mapping(&self) -> fluent_builders::GetApiMapping {
        fluent_builders::GetApiMapping::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetApiMappings`](crate::client::fluent_builders::GetApiMappings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::GetApiMappings::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::GetApiMappings::set_domain_name): <p>The domain name.</p>
    ///   - [`max_results(impl Into<String>)`](crate::client::fluent_builders::GetApiMappings::max_results) / [`set_max_results(Option<String>)`](crate::client::fluent_builders::GetApiMappings::set_max_results): <p>The maximum number of elements to be returned for this resource.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetApiMappings::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetApiMappings::set_next_token): <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    /// - On success, responds with [`GetApiMappingsOutput`](crate::output::GetApiMappingsOutput) with field(s):
    ///   - [`items(Option<Vec<ApiMapping>>)`](crate::output::GetApiMappingsOutput::items): <p>The elements from this collection.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetApiMappingsOutput::next_token): <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    /// - On failure, responds with [`SdkError<GetApiMappingsError>`](crate::error::GetApiMappingsError)
    pub fn get_api_mappings(&self) -> fluent_builders::GetApiMappings {
        fluent_builders::GetApiMappings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetApis`](crate::client::fluent_builders::GetApis) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(impl Into<String>)`](crate::client::fluent_builders::GetApis::max_results) / [`set_max_results(Option<String>)`](crate::client::fluent_builders::GetApis::set_max_results): <p>The maximum number of elements to be returned for this resource.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetApis::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetApis::set_next_token): <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    /// - On success, responds with [`GetApisOutput`](crate::output::GetApisOutput) with field(s):
    ///   - [`items(Option<Vec<Api>>)`](crate::output::GetApisOutput::items): <p>The elements from this collection.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetApisOutput::next_token): <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    /// - On failure, responds with [`SdkError<GetApisError>`](crate::error::GetApisError)
    pub fn get_apis(&self) -> fluent_builders::GetApis {
        fluent_builders::GetApis::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAuthorizer`](crate::client::fluent_builders::GetAuthorizer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::GetAuthorizer::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::GetAuthorizer::set_api_id): <p>The API identifier.</p>
    ///   - [`authorizer_id(impl Into<String>)`](crate::client::fluent_builders::GetAuthorizer::authorizer_id) / [`set_authorizer_id(Option<String>)`](crate::client::fluent_builders::GetAuthorizer::set_authorizer_id): <p>The authorizer identifier.</p>
    /// - On success, responds with [`GetAuthorizerOutput`](crate::output::GetAuthorizerOutput) with field(s):
    ///   - [`authorizer_credentials_arn(Option<String>)`](crate::output::GetAuthorizerOutput::authorizer_credentials_arn): <p>Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, don't specify this parameter. Supported only for REQUEST authorizers.</p>
    ///   - [`authorizer_id(Option<String>)`](crate::output::GetAuthorizerOutput::authorizer_id): <p>The authorizer identifier.</p>
    ///   - [`authorizer_payload_format_version(Option<String>)`](crate::output::GetAuthorizerOutput::authorizer_payload_format_version): <p>Specifies the format of the payload sent to an HTTP API Lambda authorizer. Required for HTTP API Lambda authorizers. Supported values are 1.0 and 2.0. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p>
    ///   - [`authorizer_result_ttl_in_seconds(i32)`](crate::output::GetAuthorizerOutput::authorizer_result_ttl_in_seconds): <p>The time to live (TTL) for cached authorizer results, in seconds. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway caches authorizer responses. The maximum value is 3600, or 1 hour. Supported only for HTTP API Lambda authorizers.</p>
    ///   - [`authorizer_type(Option<AuthorizerType>)`](crate::output::GetAuthorizerOutput::authorizer_type): <p>The authorizer type. Specify REQUEST for a Lambda function using incoming request parameters. Specify JWT to use JSON Web Tokens (supported only for HTTP APIs).</p>
    ///   - [`authorizer_uri(Option<String>)`](crate::output::GetAuthorizerOutput::authorizer_uri): <p>The authorizer's Uniform Resource Identifier (URI). For REQUEST authorizers, this must be a well-formed Lambda function URI, for example, arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:<replaceable>   {account_id}  </replaceable>:function:<replaceable>   {lambda_function_name}  </replaceable>/invocations. In general, the URI has this form: arn:aws:apigateway:<replaceable>   {region}  </replaceable>:lambda:path/<replaceable>   {service_api}  </replaceable> , where <replaceable></replaceable>{region} is the same as the region hosting the Lambda function, path indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial /. For Lambda functions, this is usually of the form /2015-03-31/functions/[FunctionARN]/invocations. Supported only for REQUEST authorizers.</p>
    ///   - [`enable_simple_responses(bool)`](crate::output::GetAuthorizerOutput::enable_simple_responses): <p>Specifies whether a Lambda authorizer returns a response in a simple format. If enabled, the Lambda authorizer can return a boolean value instead of an IAM policy. Supported only for HTTP APIs. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a></p>
    ///   - [`identity_source(Option<Vec<String>>)`](crate::output::GetAuthorizerOutput::identity_source): <p>The identity source for which authorization is requested.</p>  <p>For a REQUEST authorizer, this is optional. The value is a set of one or more mapping expressions of the specified request parameters. The identity source can be headers, query string parameters, stage variables, and context parameters. For example, if an Auth header and a Name query string parameter are defined as identity sources, this value is route.request.header.Auth, route.request.querystring.Name for WebSocket APIs. For HTTP APIs, use selection expressions prefixed with $, for example, $request.header.Auth, $request.querystring.Name. These parameters are used to perform runtime validation for Lambda-based authorizers by verifying all of the identity-related request parameters are present in the request, not null, and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function. Otherwise, it returns a 401 Unauthorized response without calling the Lambda function. For HTTP APIs, identity sources are also used as the cache key when caching is enabled. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p>  <p>For JWT, a single entry that specifies where to extract the JSON Web Token (JWT) from inbound requests. Currently only header-based and query parameter-based selections are supported, for example $request.header.Authorization.</p>
    ///   - [`identity_validation_expression(Option<String>)`](crate::output::GetAuthorizerOutput::identity_validation_expression): <p>The validation expression does not apply to the REQUEST authorizer.</p>
    ///   - [`jwt_configuration(Option<JwtConfiguration>)`](crate::output::GetAuthorizerOutput::jwt_configuration): <p>Represents the configuration of a JWT authorizer. Required for the JWT authorizer type. Supported only for HTTP APIs.</p>
    ///   - [`name(Option<String>)`](crate::output::GetAuthorizerOutput::name): <p>The name of the authorizer.</p>
    /// - On failure, responds with [`SdkError<GetAuthorizerError>`](crate::error::GetAuthorizerError)
    pub fn get_authorizer(&self) -> fluent_builders::GetAuthorizer {
        fluent_builders::GetAuthorizer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAuthorizers`](crate::client::fluent_builders::GetAuthorizers) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::GetAuthorizers::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::GetAuthorizers::set_api_id): <p>The API identifier.</p>
    ///   - [`max_results(impl Into<String>)`](crate::client::fluent_builders::GetAuthorizers::max_results) / [`set_max_results(Option<String>)`](crate::client::fluent_builders::GetAuthorizers::set_max_results): <p>The maximum number of elements to be returned for this resource.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetAuthorizers::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetAuthorizers::set_next_token): <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    /// - On success, responds with [`GetAuthorizersOutput`](crate::output::GetAuthorizersOutput) with field(s):
    ///   - [`items(Option<Vec<Authorizer>>)`](crate::output::GetAuthorizersOutput::items): <p>The elements from this collection.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetAuthorizersOutput::next_token): <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    /// - On failure, responds with [`SdkError<GetAuthorizersError>`](crate::error::GetAuthorizersError)
    pub fn get_authorizers(&self) -> fluent_builders::GetAuthorizers {
        fluent_builders::GetAuthorizers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDeployment`](crate::client::fluent_builders::GetDeployment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::GetDeployment::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::GetDeployment::set_api_id): <p>The API identifier.</p>
    ///   - [`deployment_id(impl Into<String>)`](crate::client::fluent_builders::GetDeployment::deployment_id) / [`set_deployment_id(Option<String>)`](crate::client::fluent_builders::GetDeployment::set_deployment_id): <p>The deployment ID.</p>
    /// - On success, responds with [`GetDeploymentOutput`](crate::output::GetDeploymentOutput) with field(s):
    ///   - [`auto_deployed(bool)`](crate::output::GetDeploymentOutput::auto_deployed): <p>Specifies whether a deployment was automatically released.</p>
    ///   - [`created_date(Option<DateTime>)`](crate::output::GetDeploymentOutput::created_date): <p>The date and time when the Deployment resource was created.</p>
    ///   - [`deployment_id(Option<String>)`](crate::output::GetDeploymentOutput::deployment_id): <p>The identifier for the deployment.</p>
    ///   - [`deployment_status(Option<DeploymentStatus>)`](crate::output::GetDeploymentOutput::deployment_status): <p>The status of the deployment: PENDING, FAILED, or SUCCEEDED.</p>
    ///   - [`deployment_status_message(Option<String>)`](crate::output::GetDeploymentOutput::deployment_status_message): <p>May contain additional feedback on the status of an API deployment.</p>
    ///   - [`description(Option<String>)`](crate::output::GetDeploymentOutput::description): <p>The description for the deployment.</p>
    /// - On failure, responds with [`SdkError<GetDeploymentError>`](crate::error::GetDeploymentError)
    pub fn get_deployment(&self) -> fluent_builders::GetDeployment {
        fluent_builders::GetDeployment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDeployments`](crate::client::fluent_builders::GetDeployments) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::GetDeployments::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::GetDeployments::set_api_id): <p>The API identifier.</p>
    ///   - [`max_results(impl Into<String>)`](crate::client::fluent_builders::GetDeployments::max_results) / [`set_max_results(Option<String>)`](crate::client::fluent_builders::GetDeployments::set_max_results): <p>The maximum number of elements to be returned for this resource.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetDeployments::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetDeployments::set_next_token): <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    /// - On success, responds with [`GetDeploymentsOutput`](crate::output::GetDeploymentsOutput) with field(s):
    ///   - [`items(Option<Vec<Deployment>>)`](crate::output::GetDeploymentsOutput::items): <p>The elements from this collection.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetDeploymentsOutput::next_token): <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    /// - On failure, responds with [`SdkError<GetDeploymentsError>`](crate::error::GetDeploymentsError)
    pub fn get_deployments(&self) -> fluent_builders::GetDeployments {
        fluent_builders::GetDeployments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDomainName`](crate::client::fluent_builders::GetDomainName) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::GetDomainName::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::GetDomainName::set_domain_name): <p>The domain name.</p>
    /// - On success, responds with [`GetDomainNameOutput`](crate::output::GetDomainNameOutput) with field(s):
    ///   - [`api_mapping_selection_expression(Option<String>)`](crate::output::GetDomainNameOutput::api_mapping_selection_expression): <p>The API mapping selection expression.</p>
    ///   - [`domain_name(Option<String>)`](crate::output::GetDomainNameOutput::domain_name): <p>The name of the DomainName resource.</p>
    ///   - [`domain_name_configurations(Option<Vec<DomainNameConfiguration>>)`](crate::output::GetDomainNameOutput::domain_name_configurations): <p>The domain name configurations.</p>
    ///   - [`mutual_tls_authentication(Option<MutualTlsAuthentication>)`](crate::output::GetDomainNameOutput::mutual_tls_authentication): <p>The mutual TLS authentication configuration for a custom domain name.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::GetDomainNameOutput::tags): <p>The collection of tags associated with a domain name.</p>
    /// - On failure, responds with [`SdkError<GetDomainNameError>`](crate::error::GetDomainNameError)
    pub fn get_domain_name(&self) -> fluent_builders::GetDomainName {
        fluent_builders::GetDomainName::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDomainNames`](crate::client::fluent_builders::GetDomainNames) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(impl Into<String>)`](crate::client::fluent_builders::GetDomainNames::max_results) / [`set_max_results(Option<String>)`](crate::client::fluent_builders::GetDomainNames::set_max_results): <p>The maximum number of elements to be returned for this resource.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetDomainNames::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetDomainNames::set_next_token): <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    /// - On success, responds with [`GetDomainNamesOutput`](crate::output::GetDomainNamesOutput) with field(s):
    ///   - [`items(Option<Vec<DomainName>>)`](crate::output::GetDomainNamesOutput::items): <p>The elements from this collection.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetDomainNamesOutput::next_token): <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    /// - On failure, responds with [`SdkError<GetDomainNamesError>`](crate::error::GetDomainNamesError)
    pub fn get_domain_names(&self) -> fluent_builders::GetDomainNames {
        fluent_builders::GetDomainNames::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetIntegration`](crate::client::fluent_builders::GetIntegration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::GetIntegration::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::GetIntegration::set_api_id): <p>The API identifier.</p>
    ///   - [`integration_id(impl Into<String>)`](crate::client::fluent_builders::GetIntegration::integration_id) / [`set_integration_id(Option<String>)`](crate::client::fluent_builders::GetIntegration::set_integration_id): <p>The integration ID.</p>
    /// - On success, responds with [`GetIntegrationOutput`](crate::output::GetIntegrationOutput) with field(s):
    ///   - [`api_gateway_managed(bool)`](crate::output::GetIntegrationOutput::api_gateway_managed): <p>Specifies whether an integration is managed by API Gateway. If you created an API using using quick create, the resulting integration is managed by API Gateway. You can update a managed integration, but you can't delete it.</p>
    ///   - [`connection_id(Option<String>)`](crate::output::GetIntegrationOutput::connection_id): <p>The ID of the VPC link for a private integration. Supported only for HTTP APIs.</p>
    ///   - [`connection_type(Option<ConnectionType>)`](crate::output::GetIntegrationOutput::connection_type): <p>The type of the network connection to the integration endpoint. Specify INTERNET for connections through the public routable internet or VPC_LINK for private connections between API Gateway and resources in a VPC. The default value is INTERNET.</p>
    ///   - [`content_handling_strategy(Option<ContentHandlingStrategy>)`](crate::output::GetIntegrationOutput::content_handling_strategy): <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p>  <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p>  <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p>  <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
    ///   - [`credentials_arn(Option<String>)`](crate::output::GetIntegrationOutput::credentials_arn): <p>Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, specify null.</p>
    ///   - [`description(Option<String>)`](crate::output::GetIntegrationOutput::description): <p>Represents the description of an integration.</p>
    ///   - [`integration_id(Option<String>)`](crate::output::GetIntegrationOutput::integration_id): <p>Represents the identifier of an integration.</p>
    ///   - [`integration_method(Option<String>)`](crate::output::GetIntegrationOutput::integration_method): <p>Specifies the integration's HTTP method type.</p>
    ///   - [`integration_response_selection_expression(Option<String>)`](crate::output::GetIntegrationOutput::integration_response_selection_expression): <p>The integration response selection expression for the integration. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-integration-response-selection-expressions">Integration Response Selection Expressions</a>.</p>
    ///   - [`integration_subtype(Option<String>)`](crate::output::GetIntegrationOutput::integration_subtype): <p>Supported only for HTTP API AWS_PROXY integrations. Specifies the AWS service action to invoke. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html">Integration subtype reference</a>.</p>
    ///   - [`integration_type(Option<IntegrationType>)`](crate::output::GetIntegrationOutput::integration_type): <p>The integration type of an integration. One of the following:</p>  <p>AWS: for integrating the route or method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration. Supported only for WebSocket APIs.</p>  <p>AWS_PROXY: for integrating the route or method request with a Lambda function or other AWS service action. This integration is also referred to as a Lambda proxy integration.</p>  <p>HTTP: for integrating the route or method request with an HTTP endpoint. This integration is also referred to as the HTTP custom integration. Supported only for WebSocket APIs.</p>  <p>HTTP_PROXY: for integrating the route or method request with an HTTP endpoint, with the client request passed through as-is. This is also referred to as HTTP proxy integration.</p>  <p>MOCK: for integrating the route or method request with API Gateway as a "loopback" endpoint without invoking any backend. Supported only for WebSocket APIs.</p>
    ///   - [`integration_uri(Option<String>)`](crate::output::GetIntegrationOutput::integration_uri): <p>For a Lambda integration, specify the URI of a Lambda function.</p>  <p>For an HTTP integration, specify a fully-qualified URL.</p>  <p>For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service. If you specify the ARN of an AWS Cloud Map service, API Gateway uses DiscoverInstances to identify resources. You can use query parameters to target specific resources. To learn more, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_DiscoverInstances.html">DiscoverInstances</a>. For private integrations, all resources must be owned by the same AWS account.</p>
    ///   - [`passthrough_behavior(Option<PassthroughBehavior>)`](crate::output::GetIntegrationOutput::passthrough_behavior): <p>Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER. Supported only for WebSocket APIs.</p>  <p>WHEN_NO_MATCH passes the request body for unmapped content types through to the integration backend without transformation.</p>  <p>NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type response.</p>  <p>WHEN_NO_TEMPLATES allows pass-through when the integration has no content types mapped to templates. However, if there is at least one content type defined, unmapped content types will be rejected with the same HTTP 415 Unsupported Media Type response.</p>
    ///   - [`payload_format_version(Option<String>)`](crate::output::GetIntegrationOutput::payload_format_version): <p>Specifies the format of the payload sent to an integration. Required for HTTP APIs.</p>
    ///   - [`request_parameters(Option<HashMap<String, String>>)`](crate::output::GetIntegrationOutput::request_parameters): <p>For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the backend. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the backend. The method request parameter value must match the pattern of method.request.<replaceable>   {location}  </replaceable>.<replaceable>   {name}  </replaceable> , where <replaceable>   {location}  </replaceable> is querystring, path, or header; and <replaceable>   {name}  </replaceable> must be a valid and unique method request parameter name.</p>  <p>For HTTP API integrations with a specified integrationSubtype, request parameters are a key-value map specifying parameters that are passed to AWS_PROXY integrations. You can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services.html">Working with AWS service integrations for HTTP APIs</a>.</p>  <p>For HTTP API itegrations, without a specified integrationSubtype request parameters are a key-value map specifying how to transform HTTP requests before sending them to backend integrations. The key should follow the pattern &lt;action&gt;:&lt;header|querystring|path&gt;.&lt;location&gt;. The action can be append, overwrite or remove. For values, you can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
    ///   - [`request_templates(Option<HashMap<String, String>>)`](crate::output::GetIntegrationOutput::request_templates): <p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value. Supported only for WebSocket APIs.</p>
    ///   - [`response_parameters(Option<HashMap<String, HashMap<String, String>>>)`](crate::output::GetIntegrationOutput::response_parameters): <p>Supported only for HTTP APIs. You use response parameters to transform the HTTP response from a backend integration before returning the response to clients. Specify a key-value map from a selection key to response parameters. The selection key must be a valid HTTP status code within the range of 200-599. Response parameters are a key-value map. The key must match pattern &lt;action&gt;:&lt;header&gt;.&lt;location&gt; or overwrite.statuscode. The action can be append, overwrite or remove. The value can be a static value, or map to response data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
    ///   - [`template_selection_expression(Option<String>)`](crate::output::GetIntegrationOutput::template_selection_expression): <p>The template selection expression for the integration. Supported only for WebSocket APIs.</p>
    ///   - [`timeout_in_millis(i32)`](crate::output::GetIntegrationOutput::timeout_in_millis): <p>Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs. The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.</p>
    ///   - [`tls_config(Option<TlsConfig>)`](crate::output::GetIntegrationOutput::tls_config): <p>The TLS configuration for a private integration. If you specify a TLS configuration, private integration traffic uses the HTTPS protocol. Supported only for HTTP APIs.</p>
    /// - On failure, responds with [`SdkError<GetIntegrationError>`](crate::error::GetIntegrationError)
    pub fn get_integration(&self) -> fluent_builders::GetIntegration {
        fluent_builders::GetIntegration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetIntegrationResponse`](crate::client::fluent_builders::GetIntegrationResponse) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::GetIntegrationResponse::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::GetIntegrationResponse::set_api_id): <p>The API identifier.</p>
    ///   - [`integration_id(impl Into<String>)`](crate::client::fluent_builders::GetIntegrationResponse::integration_id) / [`set_integration_id(Option<String>)`](crate::client::fluent_builders::GetIntegrationResponse::set_integration_id): <p>The integration ID.</p>
    ///   - [`integration_response_id(impl Into<String>)`](crate::client::fluent_builders::GetIntegrationResponse::integration_response_id) / [`set_integration_response_id(Option<String>)`](crate::client::fluent_builders::GetIntegrationResponse::set_integration_response_id): <p>The integration response ID.</p>
    /// - On success, responds with [`GetIntegrationResponseOutput`](crate::output::GetIntegrationResponseOutput) with field(s):
    ///   - [`content_handling_strategy(Option<ContentHandlingStrategy>)`](crate::output::GetIntegrationResponseOutput::content_handling_strategy): <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p>  <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p>  <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p>  <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
    ///   - [`integration_response_id(Option<String>)`](crate::output::GetIntegrationResponseOutput::integration_response_id): <p>The integration response ID.</p>
    ///   - [`integration_response_key(Option<String>)`](crate::output::GetIntegrationResponseOutput::integration_response_key): <p>The integration response key.</p>
    ///   - [`response_parameters(Option<HashMap<String, String>>)`](crate::output::GetIntegrationResponseOutput::response_parameters): <p>A key-value map specifying response parameters that are passed to the method response from the backend. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of method.response.header.{name}, where name is a valid and unique header name. The mapped non-static value must match the pattern of integration.response.header.{name} or integration.response.body.{JSON-expression}, where name is a valid and unique response header name and JSON-expression is a valid JSON expression without the $ prefix.</p>
    ///   - [`response_templates(Option<HashMap<String, String>>)`](crate::output::GetIntegrationResponseOutput::response_templates): <p>The collection of response templates for the integration response as a string-to-string map of key-value pairs. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.</p>
    ///   - [`template_selection_expression(Option<String>)`](crate::output::GetIntegrationResponseOutput::template_selection_expression): <p>The template selection expressions for the integration response.</p>
    /// - On failure, responds with [`SdkError<GetIntegrationResponseError>`](crate::error::GetIntegrationResponseError)
    pub fn get_integration_response(&self) -> fluent_builders::GetIntegrationResponse {
        fluent_builders::GetIntegrationResponse::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetIntegrationResponses`](crate::client::fluent_builders::GetIntegrationResponses) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::GetIntegrationResponses::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::GetIntegrationResponses::set_api_id): <p>The API identifier.</p>
    ///   - [`integration_id(impl Into<String>)`](crate::client::fluent_builders::GetIntegrationResponses::integration_id) / [`set_integration_id(Option<String>)`](crate::client::fluent_builders::GetIntegrationResponses::set_integration_id): <p>The integration ID.</p>
    ///   - [`max_results(impl Into<String>)`](crate::client::fluent_builders::GetIntegrationResponses::max_results) / [`set_max_results(Option<String>)`](crate::client::fluent_builders::GetIntegrationResponses::set_max_results): <p>The maximum number of elements to be returned for this resource.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetIntegrationResponses::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetIntegrationResponses::set_next_token): <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    /// - On success, responds with [`GetIntegrationResponsesOutput`](crate::output::GetIntegrationResponsesOutput) with field(s):
    ///   - [`items(Option<Vec<IntegrationResponse>>)`](crate::output::GetIntegrationResponsesOutput::items): <p>The elements from this collection.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetIntegrationResponsesOutput::next_token): <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    /// - On failure, responds with [`SdkError<GetIntegrationResponsesError>`](crate::error::GetIntegrationResponsesError)
    pub fn get_integration_responses(&self) -> fluent_builders::GetIntegrationResponses {
        fluent_builders::GetIntegrationResponses::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetIntegrations`](crate::client::fluent_builders::GetIntegrations) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::GetIntegrations::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::GetIntegrations::set_api_id): <p>The API identifier.</p>
    ///   - [`max_results(impl Into<String>)`](crate::client::fluent_builders::GetIntegrations::max_results) / [`set_max_results(Option<String>)`](crate::client::fluent_builders::GetIntegrations::set_max_results): <p>The maximum number of elements to be returned for this resource.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetIntegrations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetIntegrations::set_next_token): <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    /// - On success, responds with [`GetIntegrationsOutput`](crate::output::GetIntegrationsOutput) with field(s):
    ///   - [`items(Option<Vec<Integration>>)`](crate::output::GetIntegrationsOutput::items): <p>The elements from this collection.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetIntegrationsOutput::next_token): <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    /// - On failure, responds with [`SdkError<GetIntegrationsError>`](crate::error::GetIntegrationsError)
    pub fn get_integrations(&self) -> fluent_builders::GetIntegrations {
        fluent_builders::GetIntegrations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetModel`](crate::client::fluent_builders::GetModel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::GetModel::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::GetModel::set_api_id): <p>The API identifier.</p>
    ///   - [`model_id(impl Into<String>)`](crate::client::fluent_builders::GetModel::model_id) / [`set_model_id(Option<String>)`](crate::client::fluent_builders::GetModel::set_model_id): <p>The model ID.</p>
    /// - On success, responds with [`GetModelOutput`](crate::output::GetModelOutput) with field(s):
    ///   - [`content_type(Option<String>)`](crate::output::GetModelOutput::content_type): <p>The content-type for the model, for example, "application/json".</p>
    ///   - [`description(Option<String>)`](crate::output::GetModelOutput::description): <p>The description of the model.</p>
    ///   - [`model_id(Option<String>)`](crate::output::GetModelOutput::model_id): <p>The model identifier.</p>
    ///   - [`name(Option<String>)`](crate::output::GetModelOutput::name): <p>The name of the model. Must be alphanumeric.</p>
    ///   - [`schema(Option<String>)`](crate::output::GetModelOutput::schema): <p>The schema for the model. For application/json models, this should be JSON schema draft 4 model.</p>
    /// - On failure, responds with [`SdkError<GetModelError>`](crate::error::GetModelError)
    pub fn get_model(&self) -> fluent_builders::GetModel {
        fluent_builders::GetModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetModels`](crate::client::fluent_builders::GetModels) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::GetModels::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::GetModels::set_api_id): <p>The API identifier.</p>
    ///   - [`max_results(impl Into<String>)`](crate::client::fluent_builders::GetModels::max_results) / [`set_max_results(Option<String>)`](crate::client::fluent_builders::GetModels::set_max_results): <p>The maximum number of elements to be returned for this resource.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetModels::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetModels::set_next_token): <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    /// - On success, responds with [`GetModelsOutput`](crate::output::GetModelsOutput) with field(s):
    ///   - [`items(Option<Vec<Model>>)`](crate::output::GetModelsOutput::items): <p>The elements from this collection.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetModelsOutput::next_token): <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    /// - On failure, responds with [`SdkError<GetModelsError>`](crate::error::GetModelsError)
    pub fn get_models(&self) -> fluent_builders::GetModels {
        fluent_builders::GetModels::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetModelTemplate`](crate::client::fluent_builders::GetModelTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::GetModelTemplate::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::GetModelTemplate::set_api_id): <p>The API identifier.</p>
    ///   - [`model_id(impl Into<String>)`](crate::client::fluent_builders::GetModelTemplate::model_id) / [`set_model_id(Option<String>)`](crate::client::fluent_builders::GetModelTemplate::set_model_id): <p>The model ID.</p>
    /// - On success, responds with [`GetModelTemplateOutput`](crate::output::GetModelTemplateOutput) with field(s):
    ///   - [`value(Option<String>)`](crate::output::GetModelTemplateOutput::value): <p>The template value.</p>
    /// - On failure, responds with [`SdkError<GetModelTemplateError>`](crate::error::GetModelTemplateError)
    pub fn get_model_template(&self) -> fluent_builders::GetModelTemplate {
        fluent_builders::GetModelTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetRoute`](crate::client::fluent_builders::GetRoute) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::GetRoute::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::GetRoute::set_api_id): <p>The API identifier.</p>
    ///   - [`route_id(impl Into<String>)`](crate::client::fluent_builders::GetRoute::route_id) / [`set_route_id(Option<String>)`](crate::client::fluent_builders::GetRoute::set_route_id): <p>The route ID.</p>
    /// - On success, responds with [`GetRouteOutput`](crate::output::GetRouteOutput) with field(s):
    ///   - [`api_gateway_managed(bool)`](crate::output::GetRouteOutput::api_gateway_managed): <p>Specifies whether a route is managed by API Gateway. If you created an API using quick create, the $default route is managed by API Gateway. You can't modify the $default route key.</p>
    ///   - [`api_key_required(bool)`](crate::output::GetRouteOutput::api_key_required): <p>Specifies whether an API key is required for this route. Supported only for WebSocket APIs.</p>
    ///   - [`authorization_scopes(Option<Vec<String>>)`](crate::output::GetRouteOutput::authorization_scopes): <p>A list of authorization scopes configured on a route. The scopes are used with a JWT authorizer to authorize the method invocation. The authorization works by matching the route scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any route scope matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the route scope is configured, the client must provide an access token instead of an identity token for authorization purposes.</p>
    ///   - [`authorization_type(Option<AuthorizationType>)`](crate::output::GetRouteOutput::authorization_type): <p>The authorization type for the route. For WebSocket APIs, valid values are NONE for open access, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer For HTTP APIs, valid values are NONE for open access, JWT for using JSON Web Tokens, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer.</p>
    ///   - [`authorizer_id(Option<String>)`](crate::output::GetRouteOutput::authorizer_id): <p>The identifier of the Authorizer resource to be associated with this route. The authorizer identifier is generated by API Gateway when you created the authorizer.</p>
    ///   - [`model_selection_expression(Option<String>)`](crate::output::GetRouteOutput::model_selection_expression): <p>The model selection expression for the route. Supported only for WebSocket APIs.</p>
    ///   - [`operation_name(Option<String>)`](crate::output::GetRouteOutput::operation_name): <p>The operation name for the route.</p>
    ///   - [`request_models(Option<HashMap<String, String>>)`](crate::output::GetRouteOutput::request_models): <p>The request models for the route. Supported only for WebSocket APIs.</p>
    ///   - [`request_parameters(Option<HashMap<String, ParameterConstraints>>)`](crate::output::GetRouteOutput::request_parameters): <p>The request parameters for the route. Supported only for WebSocket APIs.</p>
    ///   - [`route_id(Option<String>)`](crate::output::GetRouteOutput::route_id): <p>The route ID.</p>
    ///   - [`route_key(Option<String>)`](crate::output::GetRouteOutput::route_key): <p>The route key for the route.</p>
    ///   - [`route_response_selection_expression(Option<String>)`](crate::output::GetRouteOutput::route_response_selection_expression): <p>The route response selection expression for the route. Supported only for WebSocket APIs.</p>
    ///   - [`target(Option<String>)`](crate::output::GetRouteOutput::target): <p>The target for the route.</p>
    /// - On failure, responds with [`SdkError<GetRouteError>`](crate::error::GetRouteError)
    pub fn get_route(&self) -> fluent_builders::GetRoute {
        fluent_builders::GetRoute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetRouteResponse`](crate::client::fluent_builders::GetRouteResponse) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::GetRouteResponse::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::GetRouteResponse::set_api_id): <p>The API identifier.</p>
    ///   - [`route_id(impl Into<String>)`](crate::client::fluent_builders::GetRouteResponse::route_id) / [`set_route_id(Option<String>)`](crate::client::fluent_builders::GetRouteResponse::set_route_id): <p>The route ID.</p>
    ///   - [`route_response_id(impl Into<String>)`](crate::client::fluent_builders::GetRouteResponse::route_response_id) / [`set_route_response_id(Option<String>)`](crate::client::fluent_builders::GetRouteResponse::set_route_response_id): <p>The route response ID.</p>
    /// - On success, responds with [`GetRouteResponseOutput`](crate::output::GetRouteResponseOutput) with field(s):
    ///   - [`model_selection_expression(Option<String>)`](crate::output::GetRouteResponseOutput::model_selection_expression): <p>Represents the model selection expression of a route response. Supported only for WebSocket APIs.</p>
    ///   - [`response_models(Option<HashMap<String, String>>)`](crate::output::GetRouteResponseOutput::response_models): <p>Represents the response models of a route response.</p>
    ///   - [`response_parameters(Option<HashMap<String, ParameterConstraints>>)`](crate::output::GetRouteResponseOutput::response_parameters): <p>Represents the response parameters of a route response.</p>
    ///   - [`route_response_id(Option<String>)`](crate::output::GetRouteResponseOutput::route_response_id): <p>Represents the identifier of a route response.</p>
    ///   - [`route_response_key(Option<String>)`](crate::output::GetRouteResponseOutput::route_response_key): <p>Represents the route response key of a route response.</p>
    /// - On failure, responds with [`SdkError<GetRouteResponseError>`](crate::error::GetRouteResponseError)
    pub fn get_route_response(&self) -> fluent_builders::GetRouteResponse {
        fluent_builders::GetRouteResponse::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetRouteResponses`](crate::client::fluent_builders::GetRouteResponses) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::GetRouteResponses::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::GetRouteResponses::set_api_id): <p>The API identifier.</p>
    ///   - [`max_results(impl Into<String>)`](crate::client::fluent_builders::GetRouteResponses::max_results) / [`set_max_results(Option<String>)`](crate::client::fluent_builders::GetRouteResponses::set_max_results): <p>The maximum number of elements to be returned for this resource.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetRouteResponses::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetRouteResponses::set_next_token): <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    ///   - [`route_id(impl Into<String>)`](crate::client::fluent_builders::GetRouteResponses::route_id) / [`set_route_id(Option<String>)`](crate::client::fluent_builders::GetRouteResponses::set_route_id): <p>The route ID.</p>
    /// - On success, responds with [`GetRouteResponsesOutput`](crate::output::GetRouteResponsesOutput) with field(s):
    ///   - [`items(Option<Vec<RouteResponse>>)`](crate::output::GetRouteResponsesOutput::items): <p>The elements from this collection.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetRouteResponsesOutput::next_token): <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    /// - On failure, responds with [`SdkError<GetRouteResponsesError>`](crate::error::GetRouteResponsesError)
    pub fn get_route_responses(&self) -> fluent_builders::GetRouteResponses {
        fluent_builders::GetRouteResponses::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetRoutes`](crate::client::fluent_builders::GetRoutes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::GetRoutes::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::GetRoutes::set_api_id): <p>The API identifier.</p>
    ///   - [`max_results(impl Into<String>)`](crate::client::fluent_builders::GetRoutes::max_results) / [`set_max_results(Option<String>)`](crate::client::fluent_builders::GetRoutes::set_max_results): <p>The maximum number of elements to be returned for this resource.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetRoutes::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetRoutes::set_next_token): <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    /// - On success, responds with [`GetRoutesOutput`](crate::output::GetRoutesOutput) with field(s):
    ///   - [`items(Option<Vec<Route>>)`](crate::output::GetRoutesOutput::items): <p>The elements from this collection.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetRoutesOutput::next_token): <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    /// - On failure, responds with [`SdkError<GetRoutesError>`](crate::error::GetRoutesError)
    pub fn get_routes(&self) -> fluent_builders::GetRoutes {
        fluent_builders::GetRoutes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetStage`](crate::client::fluent_builders::GetStage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::GetStage::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::GetStage::set_api_id): <p>The API identifier.</p>
    ///   - [`stage_name(impl Into<String>)`](crate::client::fluent_builders::GetStage::stage_name) / [`set_stage_name(Option<String>)`](crate::client::fluent_builders::GetStage::set_stage_name): <p>The stage name. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.</p>
    /// - On success, responds with [`GetStageOutput`](crate::output::GetStageOutput) with field(s):
    ///   - [`access_log_settings(Option<AccessLogSettings>)`](crate::output::GetStageOutput::access_log_settings): <p>Settings for logging access in this stage.</p>
    ///   - [`api_gateway_managed(bool)`](crate::output::GetStageOutput::api_gateway_managed): <p>Specifies whether a stage is managed by API Gateway. If you created an API using quick create, the $default stage is managed by API Gateway. You can't modify the $default stage.</p>
    ///   - [`auto_deploy(bool)`](crate::output::GetStageOutput::auto_deploy): <p>Specifies whether updates to an API automatically trigger a new deployment. The default value is false.</p>
    ///   - [`client_certificate_id(Option<String>)`](crate::output::GetStageOutput::client_certificate_id): <p>The identifier of a client certificate for a Stage. Supported only for WebSocket APIs.</p>
    ///   - [`created_date(Option<DateTime>)`](crate::output::GetStageOutput::created_date): <p>The timestamp when the stage was created.</p>
    ///   - [`default_route_settings(Option<RouteSettings>)`](crate::output::GetStageOutput::default_route_settings): <p>Default route settings for the stage.</p>
    ///   - [`deployment_id(Option<String>)`](crate::output::GetStageOutput::deployment_id): <p>The identifier of the Deployment that the Stage is associated with. Can't be updated if autoDeploy is enabled.</p>
    ///   - [`description(Option<String>)`](crate::output::GetStageOutput::description): <p>The description of the stage.</p>
    ///   - [`last_deployment_status_message(Option<String>)`](crate::output::GetStageOutput::last_deployment_status_message): <p>Describes the status of the last deployment of a stage. Supported only for stages with autoDeploy enabled.</p>
    ///   - [`last_updated_date(Option<DateTime>)`](crate::output::GetStageOutput::last_updated_date): <p>The timestamp when the stage was last updated.</p>
    ///   - [`route_settings(Option<HashMap<String, RouteSettings>>)`](crate::output::GetStageOutput::route_settings): <p>Route settings for the stage, by routeKey.</p>
    ///   - [`stage_name(Option<String>)`](crate::output::GetStageOutput::stage_name): <p>The name of the stage.</p>
    ///   - [`stage_variables(Option<HashMap<String, String>>)`](crate::output::GetStageOutput::stage_variables): <p>A map that defines the stage variables for a stage resource. Variable names can have alphanumeric and underscore characters, and the values must match [A-Za-z0-9-._~:/?#&amp;=,]+.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::GetStageOutput::tags): <p>The collection of tags. Each tag element is associated with a given resource.</p>
    /// - On failure, responds with [`SdkError<GetStageError>`](crate::error::GetStageError)
    pub fn get_stage(&self) -> fluent_builders::GetStage {
        fluent_builders::GetStage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetStages`](crate::client::fluent_builders::GetStages) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::GetStages::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::GetStages::set_api_id): <p>The API identifier.</p>
    ///   - [`max_results(impl Into<String>)`](crate::client::fluent_builders::GetStages::max_results) / [`set_max_results(Option<String>)`](crate::client::fluent_builders::GetStages::set_max_results): <p>The maximum number of elements to be returned for this resource.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetStages::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetStages::set_next_token): <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    /// - On success, responds with [`GetStagesOutput`](crate::output::GetStagesOutput) with field(s):
    ///   - [`items(Option<Vec<Stage>>)`](crate::output::GetStagesOutput::items): <p>The elements from this collection.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetStagesOutput::next_token): <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    /// - On failure, responds with [`SdkError<GetStagesError>`](crate::error::GetStagesError)
    pub fn get_stages(&self) -> fluent_builders::GetStages {
        fluent_builders::GetStages::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetTags`](crate::client::fluent_builders::GetTags) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::GetTags::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::GetTags::set_resource_arn): <p>The resource ARN for the tag.</p>
    /// - On success, responds with [`GetTagsOutput`](crate::output::GetTagsOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::GetTagsOutput::tags): <p>Represents a collection of tags associated with the resource.</p>
    /// - On failure, responds with [`SdkError<GetTagsError>`](crate::error::GetTagsError)
    pub fn get_tags(&self) -> fluent_builders::GetTags {
        fluent_builders::GetTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetVpcLink`](crate::client::fluent_builders::GetVpcLink) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`vpc_link_id(impl Into<String>)`](crate::client::fluent_builders::GetVpcLink::vpc_link_id) / [`set_vpc_link_id(Option<String>)`](crate::client::fluent_builders::GetVpcLink::set_vpc_link_id): <p>The ID of the VPC link.</p>
    /// - On success, responds with [`GetVpcLinkOutput`](crate::output::GetVpcLinkOutput) with field(s):
    ///   - [`created_date(Option<DateTime>)`](crate::output::GetVpcLinkOutput::created_date): <p>The timestamp when the VPC link was created.</p>
    ///   - [`name(Option<String>)`](crate::output::GetVpcLinkOutput::name): <p>The name of the VPC link.</p>
    ///   - [`security_group_ids(Option<Vec<String>>)`](crate::output::GetVpcLinkOutput::security_group_ids): <p>A list of security group IDs for the VPC link.</p>
    ///   - [`subnet_ids(Option<Vec<String>>)`](crate::output::GetVpcLinkOutput::subnet_ids): <p>A list of subnet IDs to include in the VPC link.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::GetVpcLinkOutput::tags): <p>Tags for the VPC link.</p>
    ///   - [`vpc_link_id(Option<String>)`](crate::output::GetVpcLinkOutput::vpc_link_id): <p>The ID of the VPC link.</p>
    ///   - [`vpc_link_status(Option<VpcLinkStatus>)`](crate::output::GetVpcLinkOutput::vpc_link_status): <p>The status of the VPC link.</p>
    ///   - [`vpc_link_status_message(Option<String>)`](crate::output::GetVpcLinkOutput::vpc_link_status_message): <p>A message summarizing the cause of the status of the VPC link.</p>
    ///   - [`vpc_link_version(Option<VpcLinkVersion>)`](crate::output::GetVpcLinkOutput::vpc_link_version): <p>The version of the VPC link.</p>
    /// - On failure, responds with [`SdkError<GetVpcLinkError>`](crate::error::GetVpcLinkError)
    pub fn get_vpc_link(&self) -> fluent_builders::GetVpcLink {
        fluent_builders::GetVpcLink::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetVpcLinks`](crate::client::fluent_builders::GetVpcLinks) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(impl Into<String>)`](crate::client::fluent_builders::GetVpcLinks::max_results) / [`set_max_results(Option<String>)`](crate::client::fluent_builders::GetVpcLinks::set_max_results): <p>The maximum number of elements to be returned for this resource.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetVpcLinks::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetVpcLinks::set_next_token): <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    /// - On success, responds with [`GetVpcLinksOutput`](crate::output::GetVpcLinksOutput) with field(s):
    ///   - [`items(Option<Vec<VpcLink>>)`](crate::output::GetVpcLinksOutput::items): <p>A collection of VPC links.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetVpcLinksOutput::next_token): <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    /// - On failure, responds with [`SdkError<GetVpcLinksError>`](crate::error::GetVpcLinksError)
    pub fn get_vpc_links(&self) -> fluent_builders::GetVpcLinks {
        fluent_builders::GetVpcLinks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ImportApi`](crate::client::fluent_builders::ImportApi) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`basepath(impl Into<String>)`](crate::client::fluent_builders::ImportApi::basepath) / [`set_basepath(Option<String>)`](crate::client::fluent_builders::ImportApi::set_basepath): <p>Specifies how to interpret the base path of the API during import. Valid values are ignore, prepend, and split. The default value is ignore. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-import-api-basePath.html">Set the OpenAPI basePath Property</a>. Supported only for HTTP APIs.</p>
    ///   - [`body(impl Into<String>)`](crate::client::fluent_builders::ImportApi::body) / [`set_body(Option<String>)`](crate::client::fluent_builders::ImportApi::set_body): <p>The OpenAPI definition. Supported only for HTTP APIs.</p>
    ///   - [`fail_on_warnings(bool)`](crate::client::fluent_builders::ImportApi::fail_on_warnings) / [`set_fail_on_warnings(bool)`](crate::client::fluent_builders::ImportApi::set_fail_on_warnings): <p>Specifies whether to rollback the API creation when a warning is encountered. By default, API creation continues if a warning is encountered.</p>
    /// - On success, responds with [`ImportApiOutput`](crate::output::ImportApiOutput) with field(s):
    ///   - [`api_endpoint(Option<String>)`](crate::output::ImportApiOutput::api_endpoint): <p>The URI of the API, of the form {api-id}.execute-api.{region}.amazonaws.com. The stage name is typically appended to this URI to form a complete path to a deployed API stage.</p>
    ///   - [`api_gateway_managed(bool)`](crate::output::ImportApiOutput::api_gateway_managed): <p>Specifies whether an API is managed by API Gateway. You can't update or delete a managed API by using API Gateway. A managed API can be deleted only through the tooling or service that created it.</p>
    ///   - [`api_id(Option<String>)`](crate::output::ImportApiOutput::api_id): <p>The API ID.</p>
    ///   - [`api_key_selection_expression(Option<String>)`](crate::output::ImportApiOutput::api_key_selection_expression): <p>An API key selection expression. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions">API Key Selection Expressions</a>.</p>
    ///   - [`cors_configuration(Option<Cors>)`](crate::output::ImportApiOutput::cors_configuration): <p>A CORS configuration. Supported only for HTTP APIs.</p>
    ///   - [`created_date(Option<DateTime>)`](crate::output::ImportApiOutput::created_date): <p>The timestamp when the API was created.</p>
    ///   - [`description(Option<String>)`](crate::output::ImportApiOutput::description): <p>The description of the API.</p>
    ///   - [`disable_schema_validation(bool)`](crate::output::ImportApiOutput::disable_schema_validation): <p>Avoid validating models when creating a deployment. Supported only for WebSocket APIs.</p>
    ///   - [`disable_execute_api_endpoint(bool)`](crate::output::ImportApiOutput::disable_execute_api_endpoint): <p>Specifies whether clients can invoke your API by using the default execute-api endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
    ///   - [`import_info(Option<Vec<String>>)`](crate::output::ImportApiOutput::import_info): <p>The validation information during API import. This may include particular properties of your OpenAPI definition which are ignored during import. Supported only for HTTP APIs.</p>
    ///   - [`name(Option<String>)`](crate::output::ImportApiOutput::name): <p>The name of the API.</p>
    ///   - [`protocol_type(Option<ProtocolType>)`](crate::output::ImportApiOutput::protocol_type): <p>The API protocol.</p>
    ///   - [`route_selection_expression(Option<String>)`](crate::output::ImportApiOutput::route_selection_expression): <p>The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ImportApiOutput::tags): <p>A collection of tags associated with the API.</p>
    ///   - [`version(Option<String>)`](crate::output::ImportApiOutput::version): <p>A version identifier for the API.</p>
    ///   - [`warnings(Option<Vec<String>>)`](crate::output::ImportApiOutput::warnings): <p>The warning messages reported when failonwarnings is turned on during API import.</p>
    /// - On failure, responds with [`SdkError<ImportApiError>`](crate::error::ImportApiError)
    pub fn import_api(&self) -> fluent_builders::ImportApi {
        fluent_builders::ImportApi::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ReimportApi`](crate::client::fluent_builders::ReimportApi) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::ReimportApi::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::ReimportApi::set_api_id): <p>The API identifier.</p>
    ///   - [`basepath(impl Into<String>)`](crate::client::fluent_builders::ReimportApi::basepath) / [`set_basepath(Option<String>)`](crate::client::fluent_builders::ReimportApi::set_basepath): <p>Specifies how to interpret the base path of the API during import. Valid values are ignore, prepend, and split. The default value is ignore. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-import-api-basePath.html">Set the OpenAPI basePath Property</a>. Supported only for HTTP APIs.</p>
    ///   - [`body(impl Into<String>)`](crate::client::fluent_builders::ReimportApi::body) / [`set_body(Option<String>)`](crate::client::fluent_builders::ReimportApi::set_body): <p>The OpenAPI definition. Supported only for HTTP APIs.</p>
    ///   - [`fail_on_warnings(bool)`](crate::client::fluent_builders::ReimportApi::fail_on_warnings) / [`set_fail_on_warnings(bool)`](crate::client::fluent_builders::ReimportApi::set_fail_on_warnings): <p>Specifies whether to rollback the API creation when a warning is encountered. By default, API creation continues if a warning is encountered.</p>
    /// - On success, responds with [`ReimportApiOutput`](crate::output::ReimportApiOutput) with field(s):
    ///   - [`api_endpoint(Option<String>)`](crate::output::ReimportApiOutput::api_endpoint): <p>The URI of the API, of the form {api-id}.execute-api.{region}.amazonaws.com. The stage name is typically appended to this URI to form a complete path to a deployed API stage.</p>
    ///   - [`api_gateway_managed(bool)`](crate::output::ReimportApiOutput::api_gateway_managed): <p>Specifies whether an API is managed by API Gateway. You can't update or delete a managed API by using API Gateway. A managed API can be deleted only through the tooling or service that created it.</p>
    ///   - [`api_id(Option<String>)`](crate::output::ReimportApiOutput::api_id): <p>The API ID.</p>
    ///   - [`api_key_selection_expression(Option<String>)`](crate::output::ReimportApiOutput::api_key_selection_expression): <p>An API key selection expression. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions">API Key Selection Expressions</a>.</p>
    ///   - [`cors_configuration(Option<Cors>)`](crate::output::ReimportApiOutput::cors_configuration): <p>A CORS configuration. Supported only for HTTP APIs.</p>
    ///   - [`created_date(Option<DateTime>)`](crate::output::ReimportApiOutput::created_date): <p>The timestamp when the API was created.</p>
    ///   - [`description(Option<String>)`](crate::output::ReimportApiOutput::description): <p>The description of the API.</p>
    ///   - [`disable_schema_validation(bool)`](crate::output::ReimportApiOutput::disable_schema_validation): <p>Avoid validating models when creating a deployment. Supported only for WebSocket APIs.</p>
    ///   - [`disable_execute_api_endpoint(bool)`](crate::output::ReimportApiOutput::disable_execute_api_endpoint): <p>Specifies whether clients can invoke your API by using the default execute-api endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
    ///   - [`import_info(Option<Vec<String>>)`](crate::output::ReimportApiOutput::import_info): <p>The validation information during API import. This may include particular properties of your OpenAPI definition which are ignored during import. Supported only for HTTP APIs.</p>
    ///   - [`name(Option<String>)`](crate::output::ReimportApiOutput::name): <p>The name of the API.</p>
    ///   - [`protocol_type(Option<ProtocolType>)`](crate::output::ReimportApiOutput::protocol_type): <p>The API protocol.</p>
    ///   - [`route_selection_expression(Option<String>)`](crate::output::ReimportApiOutput::route_selection_expression): <p>The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ReimportApiOutput::tags): <p>A collection of tags associated with the API.</p>
    ///   - [`version(Option<String>)`](crate::output::ReimportApiOutput::version): <p>A version identifier for the API.</p>
    ///   - [`warnings(Option<Vec<String>>)`](crate::output::ReimportApiOutput::warnings): <p>The warning messages reported when failonwarnings is turned on during API import.</p>
    /// - On failure, responds with [`SdkError<ReimportApiError>`](crate::error::ReimportApiError)
    pub fn reimport_api(&self) -> fluent_builders::ReimportApi {
        fluent_builders::ReimportApi::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ResetAuthorizersCache`](crate::client::fluent_builders::ResetAuthorizersCache) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::ResetAuthorizersCache::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::ResetAuthorizersCache::set_api_id): <p>The API identifier.</p>
    ///   - [`stage_name(impl Into<String>)`](crate::client::fluent_builders::ResetAuthorizersCache::stage_name) / [`set_stage_name(Option<String>)`](crate::client::fluent_builders::ResetAuthorizersCache::set_stage_name): <p>The stage name. Stage names can contain only alphanumeric characters, hyphens, and underscores, or be $default. Maximum length is 128 characters.</p>
    /// - On success, responds with [`ResetAuthorizersCacheOutput`](crate::output::ResetAuthorizersCacheOutput)

    /// - On failure, responds with [`SdkError<ResetAuthorizersCacheError>`](crate::error::ResetAuthorizersCacheError)
    pub fn reset_authorizers_cache(&self) -> fluent_builders::ResetAuthorizersCache {
        fluent_builders::ResetAuthorizersCache::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The resource ARN for the tag.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>The collection of tags. Each tag element is associated with a given resource.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The resource ARN for the tag.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The Tag keys to delete</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateApi`](crate::client::fluent_builders::UpdateApi) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::UpdateApi::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::UpdateApi::set_api_id): <p>The API identifier.</p>
    ///   - [`api_key_selection_expression(impl Into<String>)`](crate::client::fluent_builders::UpdateApi::api_key_selection_expression) / [`set_api_key_selection_expression(Option<String>)`](crate::client::fluent_builders::UpdateApi::set_api_key_selection_expression): <p>An API key selection expression. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions">API Key Selection Expressions</a>.</p>
    ///   - [`cors_configuration(Cors)`](crate::client::fluent_builders::UpdateApi::cors_configuration) / [`set_cors_configuration(Option<Cors>)`](crate::client::fluent_builders::UpdateApi::set_cors_configuration): <p>A CORS configuration. Supported only for HTTP APIs.</p>
    ///   - [`credentials_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateApi::credentials_arn) / [`set_credentials_arn(Option<String>)`](crate::client::fluent_builders::UpdateApi::set_credentials_arn): <p>This property is part of quick create. It specifies the credentials required for the integration, if any. For a Lambda integration, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, don't specify this parameter. Currently, this property is not used for HTTP integrations. If provided, this value replaces the credentials associated with the quick create integration. Supported only for HTTP APIs.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateApi::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateApi::set_description): <p>The description of the API.</p>
    ///   - [`disable_schema_validation(bool)`](crate::client::fluent_builders::UpdateApi::disable_schema_validation) / [`set_disable_schema_validation(bool)`](crate::client::fluent_builders::UpdateApi::set_disable_schema_validation): <p>Avoid validating models when creating a deployment. Supported only for WebSocket APIs.</p>
    ///   - [`disable_execute_api_endpoint(bool)`](crate::client::fluent_builders::UpdateApi::disable_execute_api_endpoint) / [`set_disable_execute_api_endpoint(bool)`](crate::client::fluent_builders::UpdateApi::set_disable_execute_api_endpoint): <p>Specifies whether clients can invoke your API by using the default execute-api endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateApi::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateApi::set_name): <p>The name of the API.</p>
    ///   - [`route_key(impl Into<String>)`](crate::client::fluent_builders::UpdateApi::route_key) / [`set_route_key(Option<String>)`](crate::client::fluent_builders::UpdateApi::set_route_key): <p>This property is part of quick create. If not specified, the route created using quick create is kept. Otherwise, this value replaces the route key of the quick create route. Additional routes may still be added after the API is updated. Supported only for HTTP APIs.</p>
    ///   - [`route_selection_expression(impl Into<String>)`](crate::client::fluent_builders::UpdateApi::route_selection_expression) / [`set_route_selection_expression(Option<String>)`](crate::client::fluent_builders::UpdateApi::set_route_selection_expression): <p>The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.</p>
    ///   - [`target(impl Into<String>)`](crate::client::fluent_builders::UpdateApi::target) / [`set_target(Option<String>)`](crate::client::fluent_builders::UpdateApi::set_target): <p>This property is part of quick create. For HTTP integrations, specify a fully qualified URL. For Lambda integrations, specify a function ARN. The type of the integration will be HTTP_PROXY or AWS_PROXY, respectively. The value provided updates the integration URI and integration type. You can update a quick-created target, but you can't remove it from an API. Supported only for HTTP APIs.</p>
    ///   - [`version(impl Into<String>)`](crate::client::fluent_builders::UpdateApi::version) / [`set_version(Option<String>)`](crate::client::fluent_builders::UpdateApi::set_version): <p>A version identifier for the API.</p>
    /// - On success, responds with [`UpdateApiOutput`](crate::output::UpdateApiOutput) with field(s):
    ///   - [`api_endpoint(Option<String>)`](crate::output::UpdateApiOutput::api_endpoint): <p>The URI of the API, of the form {api-id}.execute-api.{region}.amazonaws.com. The stage name is typically appended to this URI to form a complete path to a deployed API stage.</p>
    ///   - [`api_gateway_managed(bool)`](crate::output::UpdateApiOutput::api_gateway_managed): <p>Specifies whether an API is managed by API Gateway. You can't update or delete a managed API by using API Gateway. A managed API can be deleted only through the tooling or service that created it.</p>
    ///   - [`api_id(Option<String>)`](crate::output::UpdateApiOutput::api_id): <p>The API ID.</p>
    ///   - [`api_key_selection_expression(Option<String>)`](crate::output::UpdateApiOutput::api_key_selection_expression): <p>An API key selection expression. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions">API Key Selection Expressions</a>.</p>
    ///   - [`cors_configuration(Option<Cors>)`](crate::output::UpdateApiOutput::cors_configuration): <p>A CORS configuration. Supported only for HTTP APIs.</p>
    ///   - [`created_date(Option<DateTime>)`](crate::output::UpdateApiOutput::created_date): <p>The timestamp when the API was created.</p>
    ///   - [`description(Option<String>)`](crate::output::UpdateApiOutput::description): <p>The description of the API.</p>
    ///   - [`disable_schema_validation(bool)`](crate::output::UpdateApiOutput::disable_schema_validation): <p>Avoid validating models when creating a deployment. Supported only for WebSocket APIs.</p>
    ///   - [`disable_execute_api_endpoint(bool)`](crate::output::UpdateApiOutput::disable_execute_api_endpoint): <p>Specifies whether clients can invoke your API by using the default execute-api endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
    ///   - [`import_info(Option<Vec<String>>)`](crate::output::UpdateApiOutput::import_info): <p>The validation information during API import. This may include particular properties of your OpenAPI definition which are ignored during import. Supported only for HTTP APIs.</p>
    ///   - [`name(Option<String>)`](crate::output::UpdateApiOutput::name): <p>The name of the API.</p>
    ///   - [`protocol_type(Option<ProtocolType>)`](crate::output::UpdateApiOutput::protocol_type): <p>The API protocol.</p>
    ///   - [`route_selection_expression(Option<String>)`](crate::output::UpdateApiOutput::route_selection_expression): <p>The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::UpdateApiOutput::tags): <p>A collection of tags associated with the API.</p>
    ///   - [`version(Option<String>)`](crate::output::UpdateApiOutput::version): <p>A version identifier for the API.</p>
    ///   - [`warnings(Option<Vec<String>>)`](crate::output::UpdateApiOutput::warnings): <p>The warning messages reported when failonwarnings is turned on during API import.</p>
    /// - On failure, responds with [`SdkError<UpdateApiError>`](crate::error::UpdateApiError)
    pub fn update_api(&self) -> fluent_builders::UpdateApi {
        fluent_builders::UpdateApi::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateApiMapping`](crate::client::fluent_builders::UpdateApiMapping) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::UpdateApiMapping::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::UpdateApiMapping::set_api_id): <p>The API identifier.</p>
    ///   - [`api_mapping_id(impl Into<String>)`](crate::client::fluent_builders::UpdateApiMapping::api_mapping_id) / [`set_api_mapping_id(Option<String>)`](crate::client::fluent_builders::UpdateApiMapping::set_api_mapping_id): <p>The API mapping identifier.</p>
    ///   - [`api_mapping_key(impl Into<String>)`](crate::client::fluent_builders::UpdateApiMapping::api_mapping_key) / [`set_api_mapping_key(Option<String>)`](crate::client::fluent_builders::UpdateApiMapping::set_api_mapping_key): <p>The API mapping key.</p>
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::UpdateApiMapping::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::UpdateApiMapping::set_domain_name): <p>The domain name.</p>
    ///   - [`stage(impl Into<String>)`](crate::client::fluent_builders::UpdateApiMapping::stage) / [`set_stage(Option<String>)`](crate::client::fluent_builders::UpdateApiMapping::set_stage): <p>The API stage.</p>
    /// - On success, responds with [`UpdateApiMappingOutput`](crate::output::UpdateApiMappingOutput) with field(s):
    ///   - [`api_id(Option<String>)`](crate::output::UpdateApiMappingOutput::api_id): <p>The API identifier.</p>
    ///   - [`api_mapping_id(Option<String>)`](crate::output::UpdateApiMappingOutput::api_mapping_id): <p>The API mapping identifier.</p>
    ///   - [`api_mapping_key(Option<String>)`](crate::output::UpdateApiMappingOutput::api_mapping_key): <p>The API mapping key.</p>
    ///   - [`stage(Option<String>)`](crate::output::UpdateApiMappingOutput::stage): <p>The API stage.</p>
    /// - On failure, responds with [`SdkError<UpdateApiMappingError>`](crate::error::UpdateApiMappingError)
    pub fn update_api_mapping(&self) -> fluent_builders::UpdateApiMapping {
        fluent_builders::UpdateApiMapping::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateAuthorizer`](crate::client::fluent_builders::UpdateAuthorizer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::UpdateAuthorizer::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::UpdateAuthorizer::set_api_id): <p>The API identifier.</p>
    ///   - [`authorizer_credentials_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateAuthorizer::authorizer_credentials_arn) / [`set_authorizer_credentials_arn(Option<String>)`](crate::client::fluent_builders::UpdateAuthorizer::set_authorizer_credentials_arn): <p>Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, don't specify this parameter.</p>
    ///   - [`authorizer_id(impl Into<String>)`](crate::client::fluent_builders::UpdateAuthorizer::authorizer_id) / [`set_authorizer_id(Option<String>)`](crate::client::fluent_builders::UpdateAuthorizer::set_authorizer_id): <p>The authorizer identifier.</p>
    ///   - [`authorizer_payload_format_version(impl Into<String>)`](crate::client::fluent_builders::UpdateAuthorizer::authorizer_payload_format_version) / [`set_authorizer_payload_format_version(Option<String>)`](crate::client::fluent_builders::UpdateAuthorizer::set_authorizer_payload_format_version): <p>Specifies the format of the payload sent to an HTTP API Lambda authorizer. Required for HTTP API Lambda authorizers. Supported values are 1.0 and 2.0. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p>
    ///   - [`authorizer_result_ttl_in_seconds(i32)`](crate::client::fluent_builders::UpdateAuthorizer::authorizer_result_ttl_in_seconds) / [`set_authorizer_result_ttl_in_seconds(i32)`](crate::client::fluent_builders::UpdateAuthorizer::set_authorizer_result_ttl_in_seconds): <p>The time to live (TTL) for cached authorizer results, in seconds. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway caches authorizer responses. The maximum value is 3600, or 1 hour. Supported only for HTTP API Lambda authorizers.</p>
    ///   - [`authorizer_type(AuthorizerType)`](crate::client::fluent_builders::UpdateAuthorizer::authorizer_type) / [`set_authorizer_type(Option<AuthorizerType>)`](crate::client::fluent_builders::UpdateAuthorizer::set_authorizer_type): <p>The authorizer type. Specify REQUEST for a Lambda function using incoming request parameters. Specify JWT to use JSON Web Tokens (supported only for HTTP APIs).</p>
    ///   - [`authorizer_uri(impl Into<String>)`](crate::client::fluent_builders::UpdateAuthorizer::authorizer_uri) / [`set_authorizer_uri(Option<String>)`](crate::client::fluent_builders::UpdateAuthorizer::set_authorizer_uri): <p>The authorizer's Uniform Resource Identifier (URI). For REQUEST authorizers, this must be a well-formed Lambda function URI, for example, arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:<replaceable>   {account_id}  </replaceable>:function:<replaceable>   {lambda_function_name}  </replaceable>/invocations. In general, the URI has this form: arn:aws:apigateway:<replaceable>   {region}  </replaceable>:lambda:path/<replaceable>   {service_api}  </replaceable> , where <replaceable></replaceable>{region} is the same as the region hosting the Lambda function, path indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial /. For Lambda functions, this is usually of the form /2015-03-31/functions/[FunctionARN]/invocations. Supported only for REQUEST authorizers.</p>
    ///   - [`enable_simple_responses(bool)`](crate::client::fluent_builders::UpdateAuthorizer::enable_simple_responses) / [`set_enable_simple_responses(bool)`](crate::client::fluent_builders::UpdateAuthorizer::set_enable_simple_responses): <p>Specifies whether a Lambda authorizer returns a response in a simple format. By default, a Lambda authorizer must return an IAM policy. If enabled, the Lambda authorizer can return a boolean value instead of an IAM policy. Supported only for HTTP APIs. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a></p>
    ///   - [`identity_source(Vec<String>)`](crate::client::fluent_builders::UpdateAuthorizer::identity_source) / [`set_identity_source(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateAuthorizer::set_identity_source): <p>The identity source for which authorization is requested.</p>  <p>For a REQUEST authorizer, this is optional. The value is a set of one or more mapping expressions of the specified request parameters. The identity source can be headers, query string parameters, stage variables, and context parameters. For example, if an Auth header and a Name query string parameter are defined as identity sources, this value is route.request.header.Auth, route.request.querystring.Name for WebSocket APIs. For HTTP APIs, use selection expressions prefixed with $, for example, $request.header.Auth, $request.querystring.Name. These parameters are used to perform runtime validation for Lambda-based authorizers by verifying all of the identity-related request parameters are present in the request, not null, and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function. Otherwise, it returns a 401 Unauthorized response without calling the Lambda function. For HTTP APIs, identity sources are also used as the cache key when caching is enabled. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p>  <p>For JWT, a single entry that specifies where to extract the JSON Web Token (JWT) from inbound requests. Currently only header-based and query parameter-based selections are supported, for example $request.header.Authorization.</p>
    ///   - [`identity_validation_expression(impl Into<String>)`](crate::client::fluent_builders::UpdateAuthorizer::identity_validation_expression) / [`set_identity_validation_expression(Option<String>)`](crate::client::fluent_builders::UpdateAuthorizer::set_identity_validation_expression): <p>This parameter is not used.</p>
    ///   - [`jwt_configuration(JwtConfiguration)`](crate::client::fluent_builders::UpdateAuthorizer::jwt_configuration) / [`set_jwt_configuration(Option<JwtConfiguration>)`](crate::client::fluent_builders::UpdateAuthorizer::set_jwt_configuration): <p>Represents the configuration of a JWT authorizer. Required for the JWT authorizer type. Supported only for HTTP APIs.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateAuthorizer::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateAuthorizer::set_name): <p>The name of the authorizer.</p>
    /// - On success, responds with [`UpdateAuthorizerOutput`](crate::output::UpdateAuthorizerOutput) with field(s):
    ///   - [`authorizer_credentials_arn(Option<String>)`](crate::output::UpdateAuthorizerOutput::authorizer_credentials_arn): <p>Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, don't specify this parameter. Supported only for REQUEST authorizers.</p>
    ///   - [`authorizer_id(Option<String>)`](crate::output::UpdateAuthorizerOutput::authorizer_id): <p>The authorizer identifier.</p>
    ///   - [`authorizer_payload_format_version(Option<String>)`](crate::output::UpdateAuthorizerOutput::authorizer_payload_format_version): <p>Specifies the format of the payload sent to an HTTP API Lambda authorizer. Required for HTTP API Lambda authorizers. Supported values are 1.0 and 2.0. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p>
    ///   - [`authorizer_result_ttl_in_seconds(i32)`](crate::output::UpdateAuthorizerOutput::authorizer_result_ttl_in_seconds): <p>The time to live (TTL) for cached authorizer results, in seconds. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway caches authorizer responses. The maximum value is 3600, or 1 hour. Supported only for HTTP API Lambda authorizers.</p>
    ///   - [`authorizer_type(Option<AuthorizerType>)`](crate::output::UpdateAuthorizerOutput::authorizer_type): <p>The authorizer type. Specify REQUEST for a Lambda function using incoming request parameters. Specify JWT to use JSON Web Tokens (supported only for HTTP APIs).</p>
    ///   - [`authorizer_uri(Option<String>)`](crate::output::UpdateAuthorizerOutput::authorizer_uri): <p>The authorizer's Uniform Resource Identifier (URI). For REQUEST authorizers, this must be a well-formed Lambda function URI, for example, arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:<replaceable>   {account_id}  </replaceable>:function:<replaceable>   {lambda_function_name}  </replaceable>/invocations. In general, the URI has this form: arn:aws:apigateway:<replaceable>   {region}  </replaceable>:lambda:path/<replaceable>   {service_api}  </replaceable> , where <replaceable></replaceable>{region} is the same as the region hosting the Lambda function, path indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial /. For Lambda functions, this is usually of the form /2015-03-31/functions/[FunctionARN]/invocations. Supported only for REQUEST authorizers.</p>
    ///   - [`enable_simple_responses(bool)`](crate::output::UpdateAuthorizerOutput::enable_simple_responses): <p>Specifies whether a Lambda authorizer returns a response in a simple format. If enabled, the Lambda authorizer can return a boolean value instead of an IAM policy. Supported only for HTTP APIs. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a></p>
    ///   - [`identity_source(Option<Vec<String>>)`](crate::output::UpdateAuthorizerOutput::identity_source): <p>The identity source for which authorization is requested.</p>  <p>For a REQUEST authorizer, this is optional. The value is a set of one or more mapping expressions of the specified request parameters. The identity source can be headers, query string parameters, stage variables, and context parameters. For example, if an Auth header and a Name query string parameter are defined as identity sources, this value is route.request.header.Auth, route.request.querystring.Name for WebSocket APIs. For HTTP APIs, use selection expressions prefixed with $, for example, $request.header.Auth, $request.querystring.Name. These parameters are used to perform runtime validation for Lambda-based authorizers by verifying all of the identity-related request parameters are present in the request, not null, and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function. Otherwise, it returns a 401 Unauthorized response without calling the Lambda function. For HTTP APIs, identity sources are also used as the cache key when caching is enabled. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p>  <p>For JWT, a single entry that specifies where to extract the JSON Web Token (JWT) from inbound requests. Currently only header-based and query parameter-based selections are supported, for example $request.header.Authorization.</p>
    ///   - [`identity_validation_expression(Option<String>)`](crate::output::UpdateAuthorizerOutput::identity_validation_expression): <p>The validation expression does not apply to the REQUEST authorizer.</p>
    ///   - [`jwt_configuration(Option<JwtConfiguration>)`](crate::output::UpdateAuthorizerOutput::jwt_configuration): <p>Represents the configuration of a JWT authorizer. Required for the JWT authorizer type. Supported only for HTTP APIs.</p>
    ///   - [`name(Option<String>)`](crate::output::UpdateAuthorizerOutput::name): <p>The name of the authorizer.</p>
    /// - On failure, responds with [`SdkError<UpdateAuthorizerError>`](crate::error::UpdateAuthorizerError)
    pub fn update_authorizer(&self) -> fluent_builders::UpdateAuthorizer {
        fluent_builders::UpdateAuthorizer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateDeployment`](crate::client::fluent_builders::UpdateDeployment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::UpdateDeployment::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::UpdateDeployment::set_api_id): <p>The API identifier.</p>
    ///   - [`deployment_id(impl Into<String>)`](crate::client::fluent_builders::UpdateDeployment::deployment_id) / [`set_deployment_id(Option<String>)`](crate::client::fluent_builders::UpdateDeployment::set_deployment_id): <p>The deployment ID.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateDeployment::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateDeployment::set_description): <p>The description for the deployment resource.</p>
    /// - On success, responds with [`UpdateDeploymentOutput`](crate::output::UpdateDeploymentOutput) with field(s):
    ///   - [`auto_deployed(bool)`](crate::output::UpdateDeploymentOutput::auto_deployed): <p>Specifies whether a deployment was automatically released.</p>
    ///   - [`created_date(Option<DateTime>)`](crate::output::UpdateDeploymentOutput::created_date): <p>The date and time when the Deployment resource was created.</p>
    ///   - [`deployment_id(Option<String>)`](crate::output::UpdateDeploymentOutput::deployment_id): <p>The identifier for the deployment.</p>
    ///   - [`deployment_status(Option<DeploymentStatus>)`](crate::output::UpdateDeploymentOutput::deployment_status): <p>The status of the deployment: PENDING, FAILED, or SUCCEEDED.</p>
    ///   - [`deployment_status_message(Option<String>)`](crate::output::UpdateDeploymentOutput::deployment_status_message): <p>May contain additional feedback on the status of an API deployment.</p>
    ///   - [`description(Option<String>)`](crate::output::UpdateDeploymentOutput::description): <p>The description for the deployment.</p>
    /// - On failure, responds with [`SdkError<UpdateDeploymentError>`](crate::error::UpdateDeploymentError)
    pub fn update_deployment(&self) -> fluent_builders::UpdateDeployment {
        fluent_builders::UpdateDeployment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateDomainName`](crate::client::fluent_builders::UpdateDomainName) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::UpdateDomainName::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::UpdateDomainName::set_domain_name): <p>The domain name.</p>
    ///   - [`domain_name_configurations(Vec<DomainNameConfiguration>)`](crate::client::fluent_builders::UpdateDomainName::domain_name_configurations) / [`set_domain_name_configurations(Option<Vec<DomainNameConfiguration>>)`](crate::client::fluent_builders::UpdateDomainName::set_domain_name_configurations): <p>The domain name configurations.</p>
    ///   - [`mutual_tls_authentication(MutualTlsAuthenticationInput)`](crate::client::fluent_builders::UpdateDomainName::mutual_tls_authentication) / [`set_mutual_tls_authentication(Option<MutualTlsAuthenticationInput>)`](crate::client::fluent_builders::UpdateDomainName::set_mutual_tls_authentication): <p>The mutual TLS authentication configuration for a custom domain name.</p>
    /// - On success, responds with [`UpdateDomainNameOutput`](crate::output::UpdateDomainNameOutput) with field(s):
    ///   - [`api_mapping_selection_expression(Option<String>)`](crate::output::UpdateDomainNameOutput::api_mapping_selection_expression): <p>The API mapping selection expression.</p>
    ///   - [`domain_name(Option<String>)`](crate::output::UpdateDomainNameOutput::domain_name): <p>The name of the DomainName resource.</p>
    ///   - [`domain_name_configurations(Option<Vec<DomainNameConfiguration>>)`](crate::output::UpdateDomainNameOutput::domain_name_configurations): <p>The domain name configurations.</p>
    ///   - [`mutual_tls_authentication(Option<MutualTlsAuthentication>)`](crate::output::UpdateDomainNameOutput::mutual_tls_authentication): <p>The mutual TLS authentication configuration for a custom domain name.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::UpdateDomainNameOutput::tags): <p>The collection of tags associated with a domain name.</p>
    /// - On failure, responds with [`SdkError<UpdateDomainNameError>`](crate::error::UpdateDomainNameError)
    pub fn update_domain_name(&self) -> fluent_builders::UpdateDomainName {
        fluent_builders::UpdateDomainName::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateIntegration`](crate::client::fluent_builders::UpdateIntegration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::UpdateIntegration::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::UpdateIntegration::set_api_id): <p>The API identifier.</p>
    ///   - [`connection_id(impl Into<String>)`](crate::client::fluent_builders::UpdateIntegration::connection_id) / [`set_connection_id(Option<String>)`](crate::client::fluent_builders::UpdateIntegration::set_connection_id): <p>The ID of the VPC link for a private integration. Supported only for HTTP APIs.</p>
    ///   - [`connection_type(ConnectionType)`](crate::client::fluent_builders::UpdateIntegration::connection_type) / [`set_connection_type(Option<ConnectionType>)`](crate::client::fluent_builders::UpdateIntegration::set_connection_type): <p>The type of the network connection to the integration endpoint. Specify INTERNET for connections through the public routable internet or VPC_LINK for private connections between API Gateway and resources in a VPC. The default value is INTERNET.</p>
    ///   - [`content_handling_strategy(ContentHandlingStrategy)`](crate::client::fluent_builders::UpdateIntegration::content_handling_strategy) / [`set_content_handling_strategy(Option<ContentHandlingStrategy>)`](crate::client::fluent_builders::UpdateIntegration::set_content_handling_strategy): <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p>  <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p>  <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p>  <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
    ///   - [`credentials_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateIntegration::credentials_arn) / [`set_credentials_arn(Option<String>)`](crate::client::fluent_builders::UpdateIntegration::set_credentials_arn): <p>Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, specify null.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateIntegration::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateIntegration::set_description): <p>The description of the integration</p>
    ///   - [`integration_id(impl Into<String>)`](crate::client::fluent_builders::UpdateIntegration::integration_id) / [`set_integration_id(Option<String>)`](crate::client::fluent_builders::UpdateIntegration::set_integration_id): <p>The integration ID.</p>
    ///   - [`integration_method(impl Into<String>)`](crate::client::fluent_builders::UpdateIntegration::integration_method) / [`set_integration_method(Option<String>)`](crate::client::fluent_builders::UpdateIntegration::set_integration_method): <p>Specifies the integration's HTTP method type.</p>
    ///   - [`integration_subtype(impl Into<String>)`](crate::client::fluent_builders::UpdateIntegration::integration_subtype) / [`set_integration_subtype(Option<String>)`](crate::client::fluent_builders::UpdateIntegration::set_integration_subtype): <p>Supported only for HTTP API AWS_PROXY integrations. Specifies the AWS service action to invoke. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html">Integration subtype reference</a>.</p>
    ///   - [`integration_type(IntegrationType)`](crate::client::fluent_builders::UpdateIntegration::integration_type) / [`set_integration_type(Option<IntegrationType>)`](crate::client::fluent_builders::UpdateIntegration::set_integration_type): <p>The integration type of an integration. One of the following:</p>  <p>AWS: for integrating the route or method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration. Supported only for WebSocket APIs.</p>  <p>AWS_PROXY: for integrating the route or method request with a Lambda function or other AWS service action. This integration is also referred to as a Lambda proxy integration.</p>  <p>HTTP: for integrating the route or method request with an HTTP endpoint. This integration is also referred to as the HTTP custom integration. Supported only for WebSocket APIs.</p>  <p>HTTP_PROXY: for integrating the route or method request with an HTTP endpoint, with the client request passed through as-is. This is also referred to as HTTP proxy integration. For HTTP API private integrations, use an HTTP_PROXY integration.</p>  <p>MOCK: for integrating the route or method request with API Gateway as a "loopback" endpoint without invoking any backend. Supported only for WebSocket APIs.</p>
    ///   - [`integration_uri(impl Into<String>)`](crate::client::fluent_builders::UpdateIntegration::integration_uri) / [`set_integration_uri(Option<String>)`](crate::client::fluent_builders::UpdateIntegration::set_integration_uri): <p>For a Lambda integration, specify the URI of a Lambda function.</p>  <p>For an HTTP integration, specify a fully-qualified URL.</p>  <p>For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service. If you specify the ARN of an AWS Cloud Map service, API Gateway uses DiscoverInstances to identify resources. You can use query parameters to target specific resources. To learn more, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_DiscoverInstances.html">DiscoverInstances</a>. For private integrations, all resources must be owned by the same AWS account.</p>
    ///   - [`passthrough_behavior(PassthroughBehavior)`](crate::client::fluent_builders::UpdateIntegration::passthrough_behavior) / [`set_passthrough_behavior(Option<PassthroughBehavior>)`](crate::client::fluent_builders::UpdateIntegration::set_passthrough_behavior): <p>Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER. Supported only for WebSocket APIs.</p>  <p>WHEN_NO_MATCH passes the request body for unmapped content types through to the integration backend without transformation.</p>  <p>NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type response.</p>  <p>WHEN_NO_TEMPLATES allows pass-through when the integration has no content types mapped to templates. However, if there is at least one content type defined, unmapped content types will be rejected with the same HTTP 415 Unsupported Media Type response.</p>
    ///   - [`payload_format_version(impl Into<String>)`](crate::client::fluent_builders::UpdateIntegration::payload_format_version) / [`set_payload_format_version(Option<String>)`](crate::client::fluent_builders::UpdateIntegration::set_payload_format_version): <p>Specifies the format of the payload sent to an integration. Required for HTTP APIs.</p>
    ///   - [`request_parameters(HashMap<String, String>)`](crate::client::fluent_builders::UpdateIntegration::request_parameters) / [`set_request_parameters(Option<HashMap<String, String>>)`](crate::client::fluent_builders::UpdateIntegration::set_request_parameters): <p>For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the backend. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the backend. The method request parameter value must match the pattern of method.request.<replaceable>   {location}  </replaceable>.<replaceable>   {name}  </replaceable> , where <replaceable>   {location}  </replaceable> is querystring, path, or header; and <replaceable>   {name}  </replaceable> must be a valid and unique method request parameter name.</p>  <p>For HTTP API integrations with a specified integrationSubtype, request parameters are a key-value map specifying parameters that are passed to AWS_PROXY integrations. You can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services.html">Working with AWS service integrations for HTTP APIs</a>.</p>  <p>For HTTP API integrations, without a specified integrationSubtype request parameters are a key-value map specifying how to transform HTTP requests before sending them to the backend. The key should follow the pattern &lt;action&gt;:&lt;header|querystring|path&gt;.&lt;location&gt; where action can be append, overwrite or remove. For values, you can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.">Transforming API requests and responses</a>.</p>
    ///   - [`request_templates(HashMap<String, String>)`](crate::client::fluent_builders::UpdateIntegration::request_templates) / [`set_request_templates(Option<HashMap<String, String>>)`](crate::client::fluent_builders::UpdateIntegration::set_request_templates): <p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value. Supported only for WebSocket APIs.</p>
    ///   - [`response_parameters(HashMap<String, HashMap<String, String>>)`](crate::client::fluent_builders::UpdateIntegration::response_parameters) / [`set_response_parameters(Option<HashMap<String, HashMap<String, String>>>)`](crate::client::fluent_builders::UpdateIntegration::set_response_parameters): <p>Supported only for HTTP APIs. You use response parameters to transform the HTTP response from a backend integration before returning the response to clients. Specify a key-value map from a selection key to response parameters. The selection key must be a valid HTTP status code within the range of 200-599. Response parameters are a key-value map. The key must match pattern &lt;action&gt;:&lt;header&gt;.&lt;location&gt; or overwrite.statuscode. The action can be append, overwrite or remove. The value can be a static value, or map to response data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
    ///   - [`template_selection_expression(impl Into<String>)`](crate::client::fluent_builders::UpdateIntegration::template_selection_expression) / [`set_template_selection_expression(Option<String>)`](crate::client::fluent_builders::UpdateIntegration::set_template_selection_expression): <p>The template selection expression for the integration.</p>
    ///   - [`timeout_in_millis(i32)`](crate::client::fluent_builders::UpdateIntegration::timeout_in_millis) / [`set_timeout_in_millis(i32)`](crate::client::fluent_builders::UpdateIntegration::set_timeout_in_millis): <p>Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs. The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.</p>
    ///   - [`tls_config(TlsConfigInput)`](crate::client::fluent_builders::UpdateIntegration::tls_config) / [`set_tls_config(Option<TlsConfigInput>)`](crate::client::fluent_builders::UpdateIntegration::set_tls_config): <p>The TLS configuration for a private integration. If you specify a TLS configuration, private integration traffic uses the HTTPS protocol. Supported only for HTTP APIs.</p>
    /// - On success, responds with [`UpdateIntegrationOutput`](crate::output::UpdateIntegrationOutput) with field(s):
    ///   - [`api_gateway_managed(bool)`](crate::output::UpdateIntegrationOutput::api_gateway_managed): <p>Specifies whether an integration is managed by API Gateway. If you created an API using using quick create, the resulting integration is managed by API Gateway. You can update a managed integration, but you can't delete it.</p>
    ///   - [`connection_id(Option<String>)`](crate::output::UpdateIntegrationOutput::connection_id): <p>The ID of the VPC link for a private integration. Supported only for HTTP APIs.</p>
    ///   - [`connection_type(Option<ConnectionType>)`](crate::output::UpdateIntegrationOutput::connection_type): <p>The type of the network connection to the integration endpoint. Specify INTERNET for connections through the public routable internet or VPC_LINK for private connections between API Gateway and resources in a VPC. The default value is INTERNET.</p>
    ///   - [`content_handling_strategy(Option<ContentHandlingStrategy>)`](crate::output::UpdateIntegrationOutput::content_handling_strategy): <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p>  <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p>  <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p>  <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
    ///   - [`credentials_arn(Option<String>)`](crate::output::UpdateIntegrationOutput::credentials_arn): <p>Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, specify null.</p>
    ///   - [`description(Option<String>)`](crate::output::UpdateIntegrationOutput::description): <p>Represents the description of an integration.</p>
    ///   - [`integration_id(Option<String>)`](crate::output::UpdateIntegrationOutput::integration_id): <p>Represents the identifier of an integration.</p>
    ///   - [`integration_method(Option<String>)`](crate::output::UpdateIntegrationOutput::integration_method): <p>Specifies the integration's HTTP method type.</p>
    ///   - [`integration_response_selection_expression(Option<String>)`](crate::output::UpdateIntegrationOutput::integration_response_selection_expression): <p>The integration response selection expression for the integration. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-integration-response-selection-expressions">Integration Response Selection Expressions</a>.</p>
    ///   - [`integration_subtype(Option<String>)`](crate::output::UpdateIntegrationOutput::integration_subtype): <p>Supported only for HTTP API AWS_PROXY integrations. Specifies the AWS service action to invoke. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html">Integration subtype reference</a>.</p>
    ///   - [`integration_type(Option<IntegrationType>)`](crate::output::UpdateIntegrationOutput::integration_type): <p>The integration type of an integration. One of the following:</p>  <p>AWS: for integrating the route or method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration. Supported only for WebSocket APIs.</p>  <p>AWS_PROXY: for integrating the route or method request with a Lambda function or other AWS service action. This integration is also referred to as a Lambda proxy integration.</p>  <p>HTTP: for integrating the route or method request with an HTTP endpoint. This integration is also referred to as the HTTP custom integration. Supported only for WebSocket APIs.</p>  <p>HTTP_PROXY: for integrating the route or method request with an HTTP endpoint, with the client request passed through as-is. This is also referred to as HTTP proxy integration.</p>  <p>MOCK: for integrating the route or method request with API Gateway as a "loopback" endpoint without invoking any backend. Supported only for WebSocket APIs.</p>
    ///   - [`integration_uri(Option<String>)`](crate::output::UpdateIntegrationOutput::integration_uri): <p>For a Lambda integration, specify the URI of a Lambda function.</p>  <p>For an HTTP integration, specify a fully-qualified URL.</p>  <p>For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service. If you specify the ARN of an AWS Cloud Map service, API Gateway uses DiscoverInstances to identify resources. You can use query parameters to target specific resources. To learn more, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_DiscoverInstances.html">DiscoverInstances</a>. For private integrations, all resources must be owned by the same AWS account.</p>
    ///   - [`passthrough_behavior(Option<PassthroughBehavior>)`](crate::output::UpdateIntegrationOutput::passthrough_behavior): <p>Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER. Supported only for WebSocket APIs.</p>  <p>WHEN_NO_MATCH passes the request body for unmapped content types through to the integration backend without transformation.</p>  <p>NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type response.</p>  <p>WHEN_NO_TEMPLATES allows pass-through when the integration has no content types mapped to templates. However, if there is at least one content type defined, unmapped content types will be rejected with the same HTTP 415 Unsupported Media Type response.</p>
    ///   - [`payload_format_version(Option<String>)`](crate::output::UpdateIntegrationOutput::payload_format_version): <p>Specifies the format of the payload sent to an integration. Required for HTTP APIs.</p>
    ///   - [`request_parameters(Option<HashMap<String, String>>)`](crate::output::UpdateIntegrationOutput::request_parameters): <p>For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the backend. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the backend. The method request parameter value must match the pattern of method.request.<replaceable>   {location}  </replaceable>.<replaceable>   {name}  </replaceable> , where <replaceable>   {location}  </replaceable> is querystring, path, or header; and <replaceable>   {name}  </replaceable> must be a valid and unique method request parameter name.</p>  <p>For HTTP API integrations with a specified integrationSubtype, request parameters are a key-value map specifying parameters that are passed to AWS_PROXY integrations. You can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services.html">Working with AWS service integrations for HTTP APIs</a>.</p>  <p>For HTTP API itegrations, without a specified integrationSubtype request parameters are a key-value map specifying how to transform HTTP requests before sending them to backend integrations. The key should follow the pattern &lt;action&gt;:&lt;header|querystring|path&gt;.&lt;location&gt;. The action can be append, overwrite or remove. For values, you can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
    ///   - [`request_templates(Option<HashMap<String, String>>)`](crate::output::UpdateIntegrationOutput::request_templates): <p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value. Supported only for WebSocket APIs.</p>
    ///   - [`response_parameters(Option<HashMap<String, HashMap<String, String>>>)`](crate::output::UpdateIntegrationOutput::response_parameters): <p>Supported only for HTTP APIs. You use response parameters to transform the HTTP response from a backend integration before returning the response to clients. Specify a key-value map from a selection key to response parameters. The selection key must be a valid HTTP status code within the range of 200-599. Response parameters are a key-value map. The key must match pattern &lt;action&gt;:&lt;header&gt;.&lt;location&gt; or overwrite.statuscode. The action can be append, overwrite or remove. The value can be a static value, or map to response data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
    ///   - [`template_selection_expression(Option<String>)`](crate::output::UpdateIntegrationOutput::template_selection_expression): <p>The template selection expression for the integration. Supported only for WebSocket APIs.</p>
    ///   - [`timeout_in_millis(i32)`](crate::output::UpdateIntegrationOutput::timeout_in_millis): <p>Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs. The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.</p>
    ///   - [`tls_config(Option<TlsConfig>)`](crate::output::UpdateIntegrationOutput::tls_config): <p>The TLS configuration for a private integration. If you specify a TLS configuration, private integration traffic uses the HTTPS protocol. Supported only for HTTP APIs.</p>
    /// - On failure, responds with [`SdkError<UpdateIntegrationError>`](crate::error::UpdateIntegrationError)
    pub fn update_integration(&self) -> fluent_builders::UpdateIntegration {
        fluent_builders::UpdateIntegration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateIntegrationResponse`](crate::client::fluent_builders::UpdateIntegrationResponse) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::UpdateIntegrationResponse::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::UpdateIntegrationResponse::set_api_id): <p>The API identifier.</p>
    ///   - [`content_handling_strategy(ContentHandlingStrategy)`](crate::client::fluent_builders::UpdateIntegrationResponse::content_handling_strategy) / [`set_content_handling_strategy(Option<ContentHandlingStrategy>)`](crate::client::fluent_builders::UpdateIntegrationResponse::set_content_handling_strategy): <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p>  <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p>  <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p>  <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
    ///   - [`integration_id(impl Into<String>)`](crate::client::fluent_builders::UpdateIntegrationResponse::integration_id) / [`set_integration_id(Option<String>)`](crate::client::fluent_builders::UpdateIntegrationResponse::set_integration_id): <p>The integration ID.</p>
    ///   - [`integration_response_id(impl Into<String>)`](crate::client::fluent_builders::UpdateIntegrationResponse::integration_response_id) / [`set_integration_response_id(Option<String>)`](crate::client::fluent_builders::UpdateIntegrationResponse::set_integration_response_id): <p>The integration response ID.</p>
    ///   - [`integration_response_key(impl Into<String>)`](crate::client::fluent_builders::UpdateIntegrationResponse::integration_response_key) / [`set_integration_response_key(Option<String>)`](crate::client::fluent_builders::UpdateIntegrationResponse::set_integration_response_key): <p>The integration response key.</p>
    ///   - [`response_parameters(HashMap<String, String>)`](crate::client::fluent_builders::UpdateIntegrationResponse::response_parameters) / [`set_response_parameters(Option<HashMap<String, String>>)`](crate::client::fluent_builders::UpdateIntegrationResponse::set_response_parameters): <p>A key-value map specifying response parameters that are passed to the method response from the backend. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of method.response.header.<replaceable>   {name}  </replaceable> , where name is a valid and unique header name. The mapped non-static value must match the pattern of integration.response.header.<replaceable>   {name}  </replaceable> or integration.response.body.<replaceable>   {JSON-expression}  </replaceable> , where <replaceable>   {name}  </replaceable> is a valid and unique response header name and <replaceable>   {JSON-expression}  </replaceable> is a valid JSON expression without the $ prefix.</p>
    ///   - [`response_templates(HashMap<String, String>)`](crate::client::fluent_builders::UpdateIntegrationResponse::response_templates) / [`set_response_templates(Option<HashMap<String, String>>)`](crate::client::fluent_builders::UpdateIntegrationResponse::set_response_templates): <p>The collection of response templates for the integration response as a string-to-string map of key-value pairs. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.</p>
    ///   - [`template_selection_expression(impl Into<String>)`](crate::client::fluent_builders::UpdateIntegrationResponse::template_selection_expression) / [`set_template_selection_expression(Option<String>)`](crate::client::fluent_builders::UpdateIntegrationResponse::set_template_selection_expression): <p>The template selection expression for the integration response. Supported only for WebSocket APIs.</p>
    /// - On success, responds with [`UpdateIntegrationResponseOutput`](crate::output::UpdateIntegrationResponseOutput) with field(s):
    ///   - [`content_handling_strategy(Option<ContentHandlingStrategy>)`](crate::output::UpdateIntegrationResponseOutput::content_handling_strategy): <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p>  <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p>  <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p>  <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
    ///   - [`integration_response_id(Option<String>)`](crate::output::UpdateIntegrationResponseOutput::integration_response_id): <p>The integration response ID.</p>
    ///   - [`integration_response_key(Option<String>)`](crate::output::UpdateIntegrationResponseOutput::integration_response_key): <p>The integration response key.</p>
    ///   - [`response_parameters(Option<HashMap<String, String>>)`](crate::output::UpdateIntegrationResponseOutput::response_parameters): <p>A key-value map specifying response parameters that are passed to the method response from the backend. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of method.response.header.{name}, where name is a valid and unique header name. The mapped non-static value must match the pattern of integration.response.header.{name} or integration.response.body.{JSON-expression}, where name is a valid and unique response header name and JSON-expression is a valid JSON expression without the $ prefix.</p>
    ///   - [`response_templates(Option<HashMap<String, String>>)`](crate::output::UpdateIntegrationResponseOutput::response_templates): <p>The collection of response templates for the integration response as a string-to-string map of key-value pairs. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.</p>
    ///   - [`template_selection_expression(Option<String>)`](crate::output::UpdateIntegrationResponseOutput::template_selection_expression): <p>The template selection expressions for the integration response.</p>
    /// - On failure, responds with [`SdkError<UpdateIntegrationResponseError>`](crate::error::UpdateIntegrationResponseError)
    pub fn update_integration_response(&self) -> fluent_builders::UpdateIntegrationResponse {
        fluent_builders::UpdateIntegrationResponse::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateModel`](crate::client::fluent_builders::UpdateModel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::UpdateModel::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::UpdateModel::set_api_id): <p>The API identifier.</p>
    ///   - [`content_type(impl Into<String>)`](crate::client::fluent_builders::UpdateModel::content_type) / [`set_content_type(Option<String>)`](crate::client::fluent_builders::UpdateModel::set_content_type): <p>The content-type for the model, for example, "application/json".</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateModel::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateModel::set_description): <p>The description of the model.</p>
    ///   - [`model_id(impl Into<String>)`](crate::client::fluent_builders::UpdateModel::model_id) / [`set_model_id(Option<String>)`](crate::client::fluent_builders::UpdateModel::set_model_id): <p>The model ID.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateModel::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateModel::set_name): <p>The name of the model.</p>
    ///   - [`schema(impl Into<String>)`](crate::client::fluent_builders::UpdateModel::schema) / [`set_schema(Option<String>)`](crate::client::fluent_builders::UpdateModel::set_schema): <p>The schema for the model. For application/json models, this should be JSON schema draft 4 model.</p>
    /// - On success, responds with [`UpdateModelOutput`](crate::output::UpdateModelOutput) with field(s):
    ///   - [`content_type(Option<String>)`](crate::output::UpdateModelOutput::content_type): <p>The content-type for the model, for example, "application/json".</p>
    ///   - [`description(Option<String>)`](crate::output::UpdateModelOutput::description): <p>The description of the model.</p>
    ///   - [`model_id(Option<String>)`](crate::output::UpdateModelOutput::model_id): <p>The model identifier.</p>
    ///   - [`name(Option<String>)`](crate::output::UpdateModelOutput::name): <p>The name of the model. Must be alphanumeric.</p>
    ///   - [`schema(Option<String>)`](crate::output::UpdateModelOutput::schema): <p>The schema for the model. For application/json models, this should be JSON schema draft 4 model.</p>
    /// - On failure, responds with [`SdkError<UpdateModelError>`](crate::error::UpdateModelError)
    pub fn update_model(&self) -> fluent_builders::UpdateModel {
        fluent_builders::UpdateModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateRoute`](crate::client::fluent_builders::UpdateRoute) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::UpdateRoute::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::UpdateRoute::set_api_id): <p>The API identifier.</p>
    ///   - [`api_key_required(bool)`](crate::client::fluent_builders::UpdateRoute::api_key_required) / [`set_api_key_required(bool)`](crate::client::fluent_builders::UpdateRoute::set_api_key_required): <p>Specifies whether an API key is required for the route. Supported only for WebSocket APIs.</p>
    ///   - [`authorization_scopes(Vec<String>)`](crate::client::fluent_builders::UpdateRoute::authorization_scopes) / [`set_authorization_scopes(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateRoute::set_authorization_scopes): <p>The authorization scopes supported by this route.</p>
    ///   - [`authorization_type(AuthorizationType)`](crate::client::fluent_builders::UpdateRoute::authorization_type) / [`set_authorization_type(Option<AuthorizationType>)`](crate::client::fluent_builders::UpdateRoute::set_authorization_type): <p>The authorization type for the route. For WebSocket APIs, valid values are NONE for open access, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer For HTTP APIs, valid values are NONE for open access, JWT for using JSON Web Tokens, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer.</p>
    ///   - [`authorizer_id(impl Into<String>)`](crate::client::fluent_builders::UpdateRoute::authorizer_id) / [`set_authorizer_id(Option<String>)`](crate::client::fluent_builders::UpdateRoute::set_authorizer_id): <p>The identifier of the Authorizer resource to be associated with this route. The authorizer identifier is generated by API Gateway when you created the authorizer.</p>
    ///   - [`model_selection_expression(impl Into<String>)`](crate::client::fluent_builders::UpdateRoute::model_selection_expression) / [`set_model_selection_expression(Option<String>)`](crate::client::fluent_builders::UpdateRoute::set_model_selection_expression): <p>The model selection expression for the route. Supported only for WebSocket APIs.</p>
    ///   - [`operation_name(impl Into<String>)`](crate::client::fluent_builders::UpdateRoute::operation_name) / [`set_operation_name(Option<String>)`](crate::client::fluent_builders::UpdateRoute::set_operation_name): <p>The operation name for the route.</p>
    ///   - [`request_models(HashMap<String, String>)`](crate::client::fluent_builders::UpdateRoute::request_models) / [`set_request_models(Option<HashMap<String, String>>)`](crate::client::fluent_builders::UpdateRoute::set_request_models): <p>The request models for the route. Supported only for WebSocket APIs.</p>
    ///   - [`request_parameters(HashMap<String, ParameterConstraints>)`](crate::client::fluent_builders::UpdateRoute::request_parameters) / [`set_request_parameters(Option<HashMap<String, ParameterConstraints>>)`](crate::client::fluent_builders::UpdateRoute::set_request_parameters): <p>The request parameters for the route. Supported only for WebSocket APIs.</p>
    ///   - [`route_id(impl Into<String>)`](crate::client::fluent_builders::UpdateRoute::route_id) / [`set_route_id(Option<String>)`](crate::client::fluent_builders::UpdateRoute::set_route_id): <p>The route ID.</p>
    ///   - [`route_key(impl Into<String>)`](crate::client::fluent_builders::UpdateRoute::route_key) / [`set_route_key(Option<String>)`](crate::client::fluent_builders::UpdateRoute::set_route_key): <p>The route key for the route.</p>
    ///   - [`route_response_selection_expression(impl Into<String>)`](crate::client::fluent_builders::UpdateRoute::route_response_selection_expression) / [`set_route_response_selection_expression(Option<String>)`](crate::client::fluent_builders::UpdateRoute::set_route_response_selection_expression): <p>The route response selection expression for the route. Supported only for WebSocket APIs.</p>
    ///   - [`target(impl Into<String>)`](crate::client::fluent_builders::UpdateRoute::target) / [`set_target(Option<String>)`](crate::client::fluent_builders::UpdateRoute::set_target): <p>The target for the route.</p>
    /// - On success, responds with [`UpdateRouteOutput`](crate::output::UpdateRouteOutput) with field(s):
    ///   - [`api_gateway_managed(bool)`](crate::output::UpdateRouteOutput::api_gateway_managed): <p>Specifies whether a route is managed by API Gateway. If you created an API using quick create, the $default route is managed by API Gateway. You can't modify the $default route key.</p>
    ///   - [`api_key_required(bool)`](crate::output::UpdateRouteOutput::api_key_required): <p>Specifies whether an API key is required for this route. Supported only for WebSocket APIs.</p>
    ///   - [`authorization_scopes(Option<Vec<String>>)`](crate::output::UpdateRouteOutput::authorization_scopes): <p>A list of authorization scopes configured on a route. The scopes are used with a JWT authorizer to authorize the method invocation. The authorization works by matching the route scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any route scope matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the route scope is configured, the client must provide an access token instead of an identity token for authorization purposes.</p>
    ///   - [`authorization_type(Option<AuthorizationType>)`](crate::output::UpdateRouteOutput::authorization_type): <p>The authorization type for the route. For WebSocket APIs, valid values are NONE for open access, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer For HTTP APIs, valid values are NONE for open access, JWT for using JSON Web Tokens, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer.</p>
    ///   - [`authorizer_id(Option<String>)`](crate::output::UpdateRouteOutput::authorizer_id): <p>The identifier of the Authorizer resource to be associated with this route. The authorizer identifier is generated by API Gateway when you created the authorizer.</p>
    ///   - [`model_selection_expression(Option<String>)`](crate::output::UpdateRouteOutput::model_selection_expression): <p>The model selection expression for the route. Supported only for WebSocket APIs.</p>
    ///   - [`operation_name(Option<String>)`](crate::output::UpdateRouteOutput::operation_name): <p>The operation name for the route.</p>
    ///   - [`request_models(Option<HashMap<String, String>>)`](crate::output::UpdateRouteOutput::request_models): <p>The request models for the route. Supported only for WebSocket APIs.</p>
    ///   - [`request_parameters(Option<HashMap<String, ParameterConstraints>>)`](crate::output::UpdateRouteOutput::request_parameters): <p>The request parameters for the route. Supported only for WebSocket APIs.</p>
    ///   - [`route_id(Option<String>)`](crate::output::UpdateRouteOutput::route_id): <p>The route ID.</p>
    ///   - [`route_key(Option<String>)`](crate::output::UpdateRouteOutput::route_key): <p>The route key for the route.</p>
    ///   - [`route_response_selection_expression(Option<String>)`](crate::output::UpdateRouteOutput::route_response_selection_expression): <p>The route response selection expression for the route. Supported only for WebSocket APIs.</p>
    ///   - [`target(Option<String>)`](crate::output::UpdateRouteOutput::target): <p>The target for the route.</p>
    /// - On failure, responds with [`SdkError<UpdateRouteError>`](crate::error::UpdateRouteError)
    pub fn update_route(&self) -> fluent_builders::UpdateRoute {
        fluent_builders::UpdateRoute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateRouteResponse`](crate::client::fluent_builders::UpdateRouteResponse) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::UpdateRouteResponse::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::UpdateRouteResponse::set_api_id): <p>The API identifier.</p>
    ///   - [`model_selection_expression(impl Into<String>)`](crate::client::fluent_builders::UpdateRouteResponse::model_selection_expression) / [`set_model_selection_expression(Option<String>)`](crate::client::fluent_builders::UpdateRouteResponse::set_model_selection_expression): <p>The model selection expression for the route response. Supported only for WebSocket APIs.</p>
    ///   - [`response_models(HashMap<String, String>)`](crate::client::fluent_builders::UpdateRouteResponse::response_models) / [`set_response_models(Option<HashMap<String, String>>)`](crate::client::fluent_builders::UpdateRouteResponse::set_response_models): <p>The response models for the route response.</p>
    ///   - [`response_parameters(HashMap<String, ParameterConstraints>)`](crate::client::fluent_builders::UpdateRouteResponse::response_parameters) / [`set_response_parameters(Option<HashMap<String, ParameterConstraints>>)`](crate::client::fluent_builders::UpdateRouteResponse::set_response_parameters): <p>The route response parameters.</p>
    ///   - [`route_id(impl Into<String>)`](crate::client::fluent_builders::UpdateRouteResponse::route_id) / [`set_route_id(Option<String>)`](crate::client::fluent_builders::UpdateRouteResponse::set_route_id): <p>The route ID.</p>
    ///   - [`route_response_id(impl Into<String>)`](crate::client::fluent_builders::UpdateRouteResponse::route_response_id) / [`set_route_response_id(Option<String>)`](crate::client::fluent_builders::UpdateRouteResponse::set_route_response_id): <p>The route response ID.</p>
    ///   - [`route_response_key(impl Into<String>)`](crate::client::fluent_builders::UpdateRouteResponse::route_response_key) / [`set_route_response_key(Option<String>)`](crate::client::fluent_builders::UpdateRouteResponse::set_route_response_key): <p>The route response key.</p>
    /// - On success, responds with [`UpdateRouteResponseOutput`](crate::output::UpdateRouteResponseOutput) with field(s):
    ///   - [`model_selection_expression(Option<String>)`](crate::output::UpdateRouteResponseOutput::model_selection_expression): <p>Represents the model selection expression of a route response. Supported only for WebSocket APIs.</p>
    ///   - [`response_models(Option<HashMap<String, String>>)`](crate::output::UpdateRouteResponseOutput::response_models): <p>Represents the response models of a route response.</p>
    ///   - [`response_parameters(Option<HashMap<String, ParameterConstraints>>)`](crate::output::UpdateRouteResponseOutput::response_parameters): <p>Represents the response parameters of a route response.</p>
    ///   - [`route_response_id(Option<String>)`](crate::output::UpdateRouteResponseOutput::route_response_id): <p>Represents the identifier of a route response.</p>
    ///   - [`route_response_key(Option<String>)`](crate::output::UpdateRouteResponseOutput::route_response_key): <p>Represents the route response key of a route response.</p>
    /// - On failure, responds with [`SdkError<UpdateRouteResponseError>`](crate::error::UpdateRouteResponseError)
    pub fn update_route_response(&self) -> fluent_builders::UpdateRouteResponse {
        fluent_builders::UpdateRouteResponse::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateStage`](crate::client::fluent_builders::UpdateStage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`access_log_settings(AccessLogSettings)`](crate::client::fluent_builders::UpdateStage::access_log_settings) / [`set_access_log_settings(Option<AccessLogSettings>)`](crate::client::fluent_builders::UpdateStage::set_access_log_settings): <p>Settings for logging access in this stage.</p>
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::UpdateStage::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::UpdateStage::set_api_id): <p>The API identifier.</p>
    ///   - [`auto_deploy(bool)`](crate::client::fluent_builders::UpdateStage::auto_deploy) / [`set_auto_deploy(bool)`](crate::client::fluent_builders::UpdateStage::set_auto_deploy): <p>Specifies whether updates to an API automatically trigger a new deployment. The default value is false.</p>
    ///   - [`client_certificate_id(impl Into<String>)`](crate::client::fluent_builders::UpdateStage::client_certificate_id) / [`set_client_certificate_id(Option<String>)`](crate::client::fluent_builders::UpdateStage::set_client_certificate_id): <p>The identifier of a client certificate for a Stage.</p>
    ///   - [`default_route_settings(RouteSettings)`](crate::client::fluent_builders::UpdateStage::default_route_settings) / [`set_default_route_settings(Option<RouteSettings>)`](crate::client::fluent_builders::UpdateStage::set_default_route_settings): <p>The default route settings for the stage.</p>
    ///   - [`deployment_id(impl Into<String>)`](crate::client::fluent_builders::UpdateStage::deployment_id) / [`set_deployment_id(Option<String>)`](crate::client::fluent_builders::UpdateStage::set_deployment_id): <p>The deployment identifier for the API stage. Can't be updated if autoDeploy is enabled.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateStage::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateStage::set_description): <p>The description for the API stage.</p>
    ///   - [`route_settings(HashMap<String, RouteSettings>)`](crate::client::fluent_builders::UpdateStage::route_settings) / [`set_route_settings(Option<HashMap<String, RouteSettings>>)`](crate::client::fluent_builders::UpdateStage::set_route_settings): <p>Route settings for the stage.</p>
    ///   - [`stage_name(impl Into<String>)`](crate::client::fluent_builders::UpdateStage::stage_name) / [`set_stage_name(Option<String>)`](crate::client::fluent_builders::UpdateStage::set_stage_name): <p>The stage name. Stage names can contain only alphanumeric characters, hyphens, and underscores, or be $default. Maximum length is 128 characters.</p>
    ///   - [`stage_variables(HashMap<String, String>)`](crate::client::fluent_builders::UpdateStage::stage_variables) / [`set_stage_variables(Option<HashMap<String, String>>)`](crate::client::fluent_builders::UpdateStage::set_stage_variables): <p>A map that defines the stage variables for a Stage. Variable names can have alphanumeric and underscore characters, and the values must match [A-Za-z0-9-._~:/?#&amp;=,]+.</p>
    /// - On success, responds with [`UpdateStageOutput`](crate::output::UpdateStageOutput) with field(s):
    ///   - [`access_log_settings(Option<AccessLogSettings>)`](crate::output::UpdateStageOutput::access_log_settings): <p>Settings for logging access in this stage.</p>
    ///   - [`api_gateway_managed(bool)`](crate::output::UpdateStageOutput::api_gateway_managed): <p>Specifies whether a stage is managed by API Gateway. If you created an API using quick create, the $default stage is managed by API Gateway. You can't modify the $default stage.</p>
    ///   - [`auto_deploy(bool)`](crate::output::UpdateStageOutput::auto_deploy): <p>Specifies whether updates to an API automatically trigger a new deployment. The default value is false.</p>
    ///   - [`client_certificate_id(Option<String>)`](crate::output::UpdateStageOutput::client_certificate_id): <p>The identifier of a client certificate for a Stage. Supported only for WebSocket APIs.</p>
    ///   - [`created_date(Option<DateTime>)`](crate::output::UpdateStageOutput::created_date): <p>The timestamp when the stage was created.</p>
    ///   - [`default_route_settings(Option<RouteSettings>)`](crate::output::UpdateStageOutput::default_route_settings): <p>Default route settings for the stage.</p>
    ///   - [`deployment_id(Option<String>)`](crate::output::UpdateStageOutput::deployment_id): <p>The identifier of the Deployment that the Stage is associated with. Can't be updated if autoDeploy is enabled.</p>
    ///   - [`description(Option<String>)`](crate::output::UpdateStageOutput::description): <p>The description of the stage.</p>
    ///   - [`last_deployment_status_message(Option<String>)`](crate::output::UpdateStageOutput::last_deployment_status_message): <p>Describes the status of the last deployment of a stage. Supported only for stages with autoDeploy enabled.</p>
    ///   - [`last_updated_date(Option<DateTime>)`](crate::output::UpdateStageOutput::last_updated_date): <p>The timestamp when the stage was last updated.</p>
    ///   - [`route_settings(Option<HashMap<String, RouteSettings>>)`](crate::output::UpdateStageOutput::route_settings): <p>Route settings for the stage, by routeKey.</p>
    ///   - [`stage_name(Option<String>)`](crate::output::UpdateStageOutput::stage_name): <p>The name of the stage.</p>
    ///   - [`stage_variables(Option<HashMap<String, String>>)`](crate::output::UpdateStageOutput::stage_variables): <p>A map that defines the stage variables for a stage resource. Variable names can have alphanumeric and underscore characters, and the values must match [A-Za-z0-9-._~:/?#&amp;=,]+.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::UpdateStageOutput::tags): <p>The collection of tags. Each tag element is associated with a given resource.</p>
    /// - On failure, responds with [`SdkError<UpdateStageError>`](crate::error::UpdateStageError)
    pub fn update_stage(&self) -> fluent_builders::UpdateStage {
        fluent_builders::UpdateStage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateVpcLink`](crate::client::fluent_builders::UpdateVpcLink) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateVpcLink::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateVpcLink::set_name): <p>The name of the VPC link.</p>
    ///   - [`vpc_link_id(impl Into<String>)`](crate::client::fluent_builders::UpdateVpcLink::vpc_link_id) / [`set_vpc_link_id(Option<String>)`](crate::client::fluent_builders::UpdateVpcLink::set_vpc_link_id): <p>The ID of the VPC link.</p>
    /// - On success, responds with [`UpdateVpcLinkOutput`](crate::output::UpdateVpcLinkOutput) with field(s):
    ///   - [`created_date(Option<DateTime>)`](crate::output::UpdateVpcLinkOutput::created_date): <p>The timestamp when the VPC link was created.</p>
    ///   - [`name(Option<String>)`](crate::output::UpdateVpcLinkOutput::name): <p>The name of the VPC link.</p>
    ///   - [`security_group_ids(Option<Vec<String>>)`](crate::output::UpdateVpcLinkOutput::security_group_ids): <p>A list of security group IDs for the VPC link.</p>
    ///   - [`subnet_ids(Option<Vec<String>>)`](crate::output::UpdateVpcLinkOutput::subnet_ids): <p>A list of subnet IDs to include in the VPC link.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::UpdateVpcLinkOutput::tags): <p>Tags for the VPC link.</p>
    ///   - [`vpc_link_id(Option<String>)`](crate::output::UpdateVpcLinkOutput::vpc_link_id): <p>The ID of the VPC link.</p>
    ///   - [`vpc_link_status(Option<VpcLinkStatus>)`](crate::output::UpdateVpcLinkOutput::vpc_link_status): <p>The status of the VPC link.</p>
    ///   - [`vpc_link_status_message(Option<String>)`](crate::output::UpdateVpcLinkOutput::vpc_link_status_message): <p>A message summarizing the cause of the status of the VPC link.</p>
    ///   - [`vpc_link_version(Option<VpcLinkVersion>)`](crate::output::UpdateVpcLinkOutput::vpc_link_version): <p>The version of the VPC link.</p>
    /// - On failure, responds with [`SdkError<UpdateVpcLinkError>`](crate::error::UpdateVpcLinkError)
    pub fn update_vpc_link(&self) -> fluent_builders::UpdateVpcLink {
        fluent_builders::UpdateVpcLink::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateApi`.
    ///
    /// <p>Creates an Api resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateApi {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_api_input::Builder,
    }
    impl CreateApi {
        /// Creates a new `CreateApi`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateApiOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateApiError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An API key selection expression. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions">API Key Selection Expressions</a>.</p>
        pub fn api_key_selection_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.api_key_selection_expression(input.into());
            self
        }
        /// <p>An API key selection expression. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions">API Key Selection Expressions</a>.</p>
        pub fn set_api_key_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_api_key_selection_expression(input);
            self
        }
        /// <p>A CORS configuration. Supported only for HTTP APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-cors.html">Configuring CORS</a> for more information.</p>
        pub fn cors_configuration(mut self, input: crate::model::Cors) -> Self {
            self.inner = self.inner.cors_configuration(input);
            self
        }
        /// <p>A CORS configuration. Supported only for HTTP APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-cors.html">Configuring CORS</a> for more information.</p>
        pub fn set_cors_configuration(
            mut self,
            input: std::option::Option<crate::model::Cors>,
        ) -> Self {
            self.inner = self.inner.set_cors_configuration(input);
            self
        }
        /// <p>This property is part of quick create. It specifies the credentials required for the integration, if any. For a Lambda integration, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, specify null. Currently, this property is not used for HTTP integrations. Supported only for HTTP APIs.</p>
        pub fn credentials_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.credentials_arn(input.into());
            self
        }
        /// <p>This property is part of quick create. It specifies the credentials required for the integration, if any. For a Lambda integration, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, specify null. Currently, this property is not used for HTTP integrations. Supported only for HTTP APIs.</p>
        pub fn set_credentials_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_credentials_arn(input);
            self
        }
        /// <p>The description of the API.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the API.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Avoid validating models when creating a deployment. Supported only for WebSocket APIs.</p>
        pub fn disable_schema_validation(mut self, input: bool) -> Self {
            self.inner = self.inner.disable_schema_validation(input);
            self
        }
        /// <p>Avoid validating models when creating a deployment. Supported only for WebSocket APIs.</p>
        pub fn set_disable_schema_validation(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_disable_schema_validation(input);
            self
        }
        /// <p>Specifies whether clients can invoke your API by using the default execute-api endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
        pub fn disable_execute_api_endpoint(mut self, input: bool) -> Self {
            self.inner = self.inner.disable_execute_api_endpoint(input);
            self
        }
        /// <p>Specifies whether clients can invoke your API by using the default execute-api endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
        pub fn set_disable_execute_api_endpoint(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_disable_execute_api_endpoint(input);
            self
        }
        /// <p>The name of the API.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the API.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The API protocol.</p>
        pub fn protocol_type(mut self, input: crate::model::ProtocolType) -> Self {
            self.inner = self.inner.protocol_type(input);
            self
        }
        /// <p>The API protocol.</p>
        pub fn set_protocol_type(
            mut self,
            input: std::option::Option<crate::model::ProtocolType>,
        ) -> Self {
            self.inner = self.inner.set_protocol_type(input);
            self
        }
        /// <p>This property is part of quick create. If you don't specify a routeKey, a default route of $default is created. The $default route acts as a catch-all for any request made to your API, for a particular stage. The $default route key can't be modified. You can add routes after creating the API, and you can update the route keys of additional routes. Supported only for HTTP APIs.</p>
        pub fn route_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.route_key(input.into());
            self
        }
        /// <p>This property is part of quick create. If you don't specify a routeKey, a default route of $default is created. The $default route acts as a catch-all for any request made to your API, for a particular stage. The $default route key can't be modified. You can add routes after creating the API, and you can update the route keys of additional routes. Supported only for HTTP APIs.</p>
        pub fn set_route_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_route_key(input);
            self
        }
        /// <p>The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.</p>
        pub fn route_selection_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.route_selection_expression(input.into());
            self
        }
        /// <p>The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.</p>
        pub fn set_route_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_route_selection_expression(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>This property is part of quick create. Quick create produces an API with an integration, a default catch-all route, and a default stage which is configured to automatically deploy changes. For HTTP integrations, specify a fully qualified URL. For Lambda integrations, specify a function ARN. The type of the integration will be HTTP_PROXY or AWS_PROXY, respectively. Supported only for HTTP APIs.</p>
        pub fn target(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target(input.into());
            self
        }
        /// <p>This property is part of quick create. Quick create produces an API with an integration, a default catch-all route, and a default stage which is configured to automatically deploy changes. For HTTP integrations, specify a fully qualified URL. For Lambda integrations, specify a function ARN. The type of the integration will be HTTP_PROXY or AWS_PROXY, respectively. Supported only for HTTP APIs.</p>
        pub fn set_target(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_target(input);
            self
        }
        /// <p>A version identifier for the API.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(input.into());
            self
        }
        /// <p>A version identifier for the API.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateApiMapping`.
    ///
    /// <p>Creates an API mapping.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateApiMapping {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_api_mapping_input::Builder,
    }
    impl CreateApiMapping {
        /// Creates a new `CreateApiMapping`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateApiMappingOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateApiMappingError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// The API mapping key.
        pub fn api_mapping_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_mapping_key(input.into());
            self
        }
        /// The API mapping key.
        pub fn set_api_mapping_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_api_mapping_key(input);
            self
        }
        /// <p>The domain name.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The domain name.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The API stage.</p>
        pub fn stage(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stage(input.into());
            self
        }
        /// <p>The API stage.</p>
        pub fn set_stage(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stage(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAuthorizer`.
    ///
    /// <p>Creates an Authorizer for an API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateAuthorizer {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_authorizer_input::Builder,
    }
    impl CreateAuthorizer {
        /// Creates a new `CreateAuthorizer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAuthorizerOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAuthorizerError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, don't specify this parameter. Supported only for REQUEST authorizers.</p>
        pub fn authorizer_credentials_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authorizer_credentials_arn(input.into());
            self
        }
        /// <p>Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, don't specify this parameter. Supported only for REQUEST authorizers.</p>
        pub fn set_authorizer_credentials_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authorizer_credentials_arn(input);
            self
        }
        /// <p>Specifies the format of the payload sent to an HTTP API Lambda authorizer. Required for HTTP API Lambda authorizers. Supported values are 1.0 and 2.0. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p>
        pub fn authorizer_payload_format_version(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.authorizer_payload_format_version(input.into());
            self
        }
        /// <p>Specifies the format of the payload sent to an HTTP API Lambda authorizer. Required for HTTP API Lambda authorizers. Supported values are 1.0 and 2.0. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p>
        pub fn set_authorizer_payload_format_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authorizer_payload_format_version(input);
            self
        }
        /// <p>The time to live (TTL) for cached authorizer results, in seconds. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway caches authorizer responses. The maximum value is 3600, or 1 hour. Supported only for HTTP API Lambda authorizers.</p>
        pub fn authorizer_result_ttl_in_seconds(mut self, input: i32) -> Self {
            self.inner = self.inner.authorizer_result_ttl_in_seconds(input);
            self
        }
        /// <p>The time to live (TTL) for cached authorizer results, in seconds. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway caches authorizer responses. The maximum value is 3600, or 1 hour. Supported only for HTTP API Lambda authorizers.</p>
        pub fn set_authorizer_result_ttl_in_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_authorizer_result_ttl_in_seconds(input);
            self
        }
        /// <p>The authorizer type. Specify REQUEST for a Lambda function using incoming request parameters. Specify JWT to use JSON Web Tokens (supported only for HTTP APIs).</p>
        pub fn authorizer_type(mut self, input: crate::model::AuthorizerType) -> Self {
            self.inner = self.inner.authorizer_type(input);
            self
        }
        /// <p>The authorizer type. Specify REQUEST for a Lambda function using incoming request parameters. Specify JWT to use JSON Web Tokens (supported only for HTTP APIs).</p>
        pub fn set_authorizer_type(
            mut self,
            input: std::option::Option<crate::model::AuthorizerType>,
        ) -> Self {
            self.inner = self.inner.set_authorizer_type(input);
            self
        }
        /// <p>The authorizer's Uniform Resource Identifier (URI). For REQUEST authorizers, this must be a well-formed Lambda function URI, for example, arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:<replaceable>
        /// {account_id}
        /// </replaceable>:function:<replaceable>
        /// {lambda_function_name}
        /// </replaceable>/invocations. In general, the URI has this form: arn:aws:apigateway:<replaceable>
        /// {region}
        /// </replaceable>:lambda:path/<replaceable>
        /// {service_api}
        /// </replaceable> , where <replaceable></replaceable>{region} is the same as the region hosting the Lambda function, path indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial /. For Lambda functions, this is usually of the form /2015-03-31/functions/[FunctionARN]/invocations. Supported only for REQUEST authorizers.</p>
        pub fn authorizer_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authorizer_uri(input.into());
            self
        }
        /// <p>The authorizer's Uniform Resource Identifier (URI). For REQUEST authorizers, this must be a well-formed Lambda function URI, for example, arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:<replaceable>
        /// {account_id}
        /// </replaceable>:function:<replaceable>
        /// {lambda_function_name}
        /// </replaceable>/invocations. In general, the URI has this form: arn:aws:apigateway:<replaceable>
        /// {region}
        /// </replaceable>:lambda:path/<replaceable>
        /// {service_api}
        /// </replaceable> , where <replaceable></replaceable>{region} is the same as the region hosting the Lambda function, path indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial /. For Lambda functions, this is usually of the form /2015-03-31/functions/[FunctionARN]/invocations. Supported only for REQUEST authorizers.</p>
        pub fn set_authorizer_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authorizer_uri(input);
            self
        }
        /// <p>Specifies whether a Lambda authorizer returns a response in a simple format. By default, a Lambda authorizer must return an IAM policy. If enabled, the Lambda authorizer can return a boolean value instead of an IAM policy. Supported only for HTTP APIs. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a></p>
        pub fn enable_simple_responses(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_simple_responses(input);
            self
        }
        /// <p>Specifies whether a Lambda authorizer returns a response in a simple format. By default, a Lambda authorizer must return an IAM policy. If enabled, the Lambda authorizer can return a boolean value instead of an IAM policy. Supported only for HTTP APIs. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a></p>
        pub fn set_enable_simple_responses(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_simple_responses(input);
            self
        }
        /// Appends an item to `IdentitySource`.
        ///
        /// To override the contents of this collection use [`set_identity_source`](Self::set_identity_source).
        ///
        /// <p>The identity source for which authorization is requested.</p>
        /// <p>For a REQUEST authorizer, this is optional. The value is a set of one or more mapping expressions of the specified request parameters. The identity source can be headers, query string parameters, stage variables, and context parameters. For example, if an Auth header and a Name query string parameter are defined as identity sources, this value is route.request.header.Auth, route.request.querystring.Name for WebSocket APIs. For HTTP APIs, use selection expressions prefixed with $, for example, $request.header.Auth, $request.querystring.Name. These parameters are used to perform runtime validation for Lambda-based authorizers by verifying all of the identity-related request parameters are present in the request, not null, and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function. Otherwise, it returns a 401 Unauthorized response without calling the Lambda function. For HTTP APIs, identity sources are also used as the cache key when caching is enabled. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p>
        /// <p>For JWT, a single entry that specifies where to extract the JSON Web Token (JWT) from inbound requests. Currently only header-based and query parameter-based selections are supported, for example $request.header.Authorization.</p>
        pub fn identity_source(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_source(input.into());
            self
        }
        /// <p>The identity source for which authorization is requested.</p>
        /// <p>For a REQUEST authorizer, this is optional. The value is a set of one or more mapping expressions of the specified request parameters. The identity source can be headers, query string parameters, stage variables, and context parameters. For example, if an Auth header and a Name query string parameter are defined as identity sources, this value is route.request.header.Auth, route.request.querystring.Name for WebSocket APIs. For HTTP APIs, use selection expressions prefixed with $, for example, $request.header.Auth, $request.querystring.Name. These parameters are used to perform runtime validation for Lambda-based authorizers by verifying all of the identity-related request parameters are present in the request, not null, and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function. Otherwise, it returns a 401 Unauthorized response without calling the Lambda function. For HTTP APIs, identity sources are also used as the cache key when caching is enabled. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p>
        /// <p>For JWT, a single entry that specifies where to extract the JSON Web Token (JWT) from inbound requests. Currently only header-based and query parameter-based selections are supported, for example $request.header.Authorization.</p>
        pub fn set_identity_source(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_identity_source(input);
            self
        }
        /// <p>This parameter is not used.</p>
        pub fn identity_validation_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.identity_validation_expression(input.into());
            self
        }
        /// <p>This parameter is not used.</p>
        pub fn set_identity_validation_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_validation_expression(input);
            self
        }
        /// <p>Represents the configuration of a JWT authorizer. Required for the JWT authorizer type. Supported only for HTTP APIs.</p>
        pub fn jwt_configuration(mut self, input: crate::model::JwtConfiguration) -> Self {
            self.inner = self.inner.jwt_configuration(input);
            self
        }
        /// <p>Represents the configuration of a JWT authorizer. Required for the JWT authorizer type. Supported only for HTTP APIs.</p>
        pub fn set_jwt_configuration(
            mut self,
            input: std::option::Option<crate::model::JwtConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_jwt_configuration(input);
            self
        }
        /// <p>The name of the authorizer.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the authorizer.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDeployment`.
    ///
    /// <p>Creates a Deployment for an API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDeployment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_deployment_input::Builder,
    }
    impl CreateDeployment {
        /// Creates a new `CreateDeployment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDeploymentOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDeploymentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The description for the deployment resource.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description for the deployment resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The name of the Stage resource for the Deployment resource to create.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stage_name(input.into());
            self
        }
        /// <p>The name of the Stage resource for the Deployment resource to create.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stage_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDomainName`.
    ///
    /// <p>Creates a domain name.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDomainName {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_domain_name_input::Builder,
    }
    impl CreateDomainName {
        /// Creates a new `CreateDomainName`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDomainNameOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDomainNameError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The domain name.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The domain name.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// Appends an item to `DomainNameConfigurations`.
        ///
        /// To override the contents of this collection use [`set_domain_name_configurations`](Self::set_domain_name_configurations).
        ///
        /// <p>The domain name configurations.</p>
        pub fn domain_name_configurations(
            mut self,
            input: crate::model::DomainNameConfiguration,
        ) -> Self {
            self.inner = self.inner.domain_name_configurations(input);
            self
        }
        /// <p>The domain name configurations.</p>
        pub fn set_domain_name_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DomainNameConfiguration>>,
        ) -> Self {
            self.inner = self.inner.set_domain_name_configurations(input);
            self
        }
        /// <p>The mutual TLS authentication configuration for a custom domain name.</p>
        pub fn mutual_tls_authentication(
            mut self,
            input: crate::model::MutualTlsAuthenticationInput,
        ) -> Self {
            self.inner = self.inner.mutual_tls_authentication(input);
            self
        }
        /// <p>The mutual TLS authentication configuration for a custom domain name.</p>
        pub fn set_mutual_tls_authentication(
            mut self,
            input: std::option::Option<crate::model::MutualTlsAuthenticationInput>,
        ) -> Self {
            self.inner = self.inner.set_mutual_tls_authentication(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The collection of tags associated with a domain name.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The collection of tags associated with a domain name.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateIntegration`.
    ///
    /// <p>Creates an Integration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateIntegration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_integration_input::Builder,
    }
    impl CreateIntegration {
        /// Creates a new `CreateIntegration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateIntegrationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateIntegrationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The ID of the VPC link for a private integration. Supported only for HTTP APIs.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_id(input.into());
            self
        }
        /// <p>The ID of the VPC link for a private integration. Supported only for HTTP APIs.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_id(input);
            self
        }
        /// <p>The type of the network connection to the integration endpoint. Specify INTERNET for connections through the public routable internet or VPC_LINK for private connections between API Gateway and resources in a VPC. The default value is INTERNET.</p>
        pub fn connection_type(mut self, input: crate::model::ConnectionType) -> Self {
            self.inner = self.inner.connection_type(input);
            self
        }
        /// <p>The type of the network connection to the integration endpoint. Specify INTERNET for connections through the public routable internet or VPC_LINK for private connections between API Gateway and resources in a VPC. The default value is INTERNET.</p>
        pub fn set_connection_type(
            mut self,
            input: std::option::Option<crate::model::ConnectionType>,
        ) -> Self {
            self.inner = self.inner.set_connection_type(input);
            self
        }
        /// <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p>
        /// <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p>
        /// <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p>
        /// <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
        pub fn content_handling_strategy(
            mut self,
            input: crate::model::ContentHandlingStrategy,
        ) -> Self {
            self.inner = self.inner.content_handling_strategy(input);
            self
        }
        /// <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p>
        /// <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p>
        /// <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p>
        /// <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
        pub fn set_content_handling_strategy(
            mut self,
            input: std::option::Option<crate::model::ContentHandlingStrategy>,
        ) -> Self {
            self.inner = self.inner.set_content_handling_strategy(input);
            self
        }
        /// <p>Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, specify null.</p>
        pub fn credentials_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.credentials_arn(input.into());
            self
        }
        /// <p>Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, specify null.</p>
        pub fn set_credentials_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_credentials_arn(input);
            self
        }
        /// <p>The description of the integration.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the integration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Specifies the integration's HTTP method type.</p>
        pub fn integration_method(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.integration_method(input.into());
            self
        }
        /// <p>Specifies the integration's HTTP method type.</p>
        pub fn set_integration_method(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_integration_method(input);
            self
        }
        /// <p>Supported only for HTTP API AWS_PROXY integrations. Specifies the AWS service action to invoke. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html">Integration subtype reference</a>.</p>
        pub fn integration_subtype(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.integration_subtype(input.into());
            self
        }
        /// <p>Supported only for HTTP API AWS_PROXY integrations. Specifies the AWS service action to invoke. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html">Integration subtype reference</a>.</p>
        pub fn set_integration_subtype(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_integration_subtype(input);
            self
        }
        /// <p>The integration type of an integration. One of the following:</p>
        /// <p>AWS: for integrating the route or method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration. Supported only for WebSocket APIs.</p>
        /// <p>AWS_PROXY: for integrating the route or method request with a Lambda function or other AWS service action. This integration is also referred to as a Lambda proxy integration.</p>
        /// <p>HTTP: for integrating the route or method request with an HTTP endpoint. This integration is also referred to as the HTTP custom integration. Supported only for WebSocket APIs.</p>
        /// <p>HTTP_PROXY: for integrating the route or method request with an HTTP endpoint, with the client request passed through as-is. This is also referred to as HTTP proxy integration. For HTTP API private integrations, use an HTTP_PROXY integration.</p>
        /// <p>MOCK: for integrating the route or method request with API Gateway as a "loopback" endpoint without invoking any backend. Supported only for WebSocket APIs.</p>
        pub fn integration_type(mut self, input: crate::model::IntegrationType) -> Self {
            self.inner = self.inner.integration_type(input);
            self
        }
        /// <p>The integration type of an integration. One of the following:</p>
        /// <p>AWS: for integrating the route or method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration. Supported only for WebSocket APIs.</p>
        /// <p>AWS_PROXY: for integrating the route or method request with a Lambda function or other AWS service action. This integration is also referred to as a Lambda proxy integration.</p>
        /// <p>HTTP: for integrating the route or method request with an HTTP endpoint. This integration is also referred to as the HTTP custom integration. Supported only for WebSocket APIs.</p>
        /// <p>HTTP_PROXY: for integrating the route or method request with an HTTP endpoint, with the client request passed through as-is. This is also referred to as HTTP proxy integration. For HTTP API private integrations, use an HTTP_PROXY integration.</p>
        /// <p>MOCK: for integrating the route or method request with API Gateway as a "loopback" endpoint without invoking any backend. Supported only for WebSocket APIs.</p>
        pub fn set_integration_type(
            mut self,
            input: std::option::Option<crate::model::IntegrationType>,
        ) -> Self {
            self.inner = self.inner.set_integration_type(input);
            self
        }
        /// <p>For a Lambda integration, specify the URI of a Lambda function.</p>
        /// <p>For an HTTP integration, specify a fully-qualified URL.</p>
        /// <p>For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service. If you specify the ARN of an AWS Cloud Map service, API Gateway uses DiscoverInstances to identify resources. You can use query parameters to target specific resources. To learn more, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_DiscoverInstances.html">DiscoverInstances</a>. For private integrations, all resources must be owned by the same AWS account.</p>
        pub fn integration_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.integration_uri(input.into());
            self
        }
        /// <p>For a Lambda integration, specify the URI of a Lambda function.</p>
        /// <p>For an HTTP integration, specify a fully-qualified URL.</p>
        /// <p>For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service. If you specify the ARN of an AWS Cloud Map service, API Gateway uses DiscoverInstances to identify resources. You can use query parameters to target specific resources. To learn more, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_DiscoverInstances.html">DiscoverInstances</a>. For private integrations, all resources must be owned by the same AWS account.</p>
        pub fn set_integration_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_integration_uri(input);
            self
        }
        /// <p>Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER. Supported only for WebSocket APIs.</p>
        /// <p>WHEN_NO_MATCH passes the request body for unmapped content types through to the integration backend without transformation.</p>
        /// <p>NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type response.</p>
        /// <p>WHEN_NO_TEMPLATES allows pass-through when the integration has no content types mapped to templates. However, if there is at least one content type defined, unmapped content types will be rejected with the same HTTP 415 Unsupported Media Type response.</p>
        pub fn passthrough_behavior(mut self, input: crate::model::PassthroughBehavior) -> Self {
            self.inner = self.inner.passthrough_behavior(input);
            self
        }
        /// <p>Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER. Supported only for WebSocket APIs.</p>
        /// <p>WHEN_NO_MATCH passes the request body for unmapped content types through to the integration backend without transformation.</p>
        /// <p>NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type response.</p>
        /// <p>WHEN_NO_TEMPLATES allows pass-through when the integration has no content types mapped to templates. However, if there is at least one content type defined, unmapped content types will be rejected with the same HTTP 415 Unsupported Media Type response.</p>
        pub fn set_passthrough_behavior(
            mut self,
            input: std::option::Option<crate::model::PassthroughBehavior>,
        ) -> Self {
            self.inner = self.inner.set_passthrough_behavior(input);
            self
        }
        /// <p>Specifies the format of the payload sent to an integration. Required for HTTP APIs.</p>
        pub fn payload_format_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.payload_format_version(input.into());
            self
        }
        /// <p>Specifies the format of the payload sent to an integration. Required for HTTP APIs.</p>
        pub fn set_payload_format_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_payload_format_version(input);
            self
        }
        /// Adds a key-value pair to `RequestParameters`.
        ///
        /// To override the contents of this collection use [`set_request_parameters`](Self::set_request_parameters).
        ///
        /// <p>For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the backend. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the backend. The method request parameter value must match the pattern of method.request.<replaceable>
        /// {location}
        /// </replaceable>.<replaceable>
        /// {name}
        /// </replaceable> , where <replaceable>
        /// {location}
        /// </replaceable> is querystring, path, or header; and <replaceable>
        /// {name}
        /// </replaceable> must be a valid and unique method request parameter name.</p>
        /// <p>For HTTP API integrations with a specified integrationSubtype, request parameters are a key-value map specifying parameters that are passed to AWS_PROXY integrations. You can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services.html">Working with AWS service integrations for HTTP APIs</a>.</p>
        /// <p>For HTTP API integrations without a specified integrationSubtype request parameters are a key-value map specifying how to transform HTTP requests before sending them to the backend. The key should follow the pattern &lt;action&gt;:&lt;header|querystring|path&gt;.&lt;location&gt; where action can be append, overwrite or remove. For values, you can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
        pub fn request_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.request_parameters(k.into(), v.into());
            self
        }
        /// <p>For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the backend. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the backend. The method request parameter value must match the pattern of method.request.<replaceable>
        /// {location}
        /// </replaceable>.<replaceable>
        /// {name}
        /// </replaceable> , where <replaceable>
        /// {location}
        /// </replaceable> is querystring, path, or header; and <replaceable>
        /// {name}
        /// </replaceable> must be a valid and unique method request parameter name.</p>
        /// <p>For HTTP API integrations with a specified integrationSubtype, request parameters are a key-value map specifying parameters that are passed to AWS_PROXY integrations. You can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services.html">Working with AWS service integrations for HTTP APIs</a>.</p>
        /// <p>For HTTP API integrations without a specified integrationSubtype request parameters are a key-value map specifying how to transform HTTP requests before sending them to the backend. The key should follow the pattern &lt;action&gt;:&lt;header|querystring|path&gt;.&lt;location&gt; where action can be append, overwrite or remove. For values, you can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
        pub fn set_request_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_request_parameters(input);
            self
        }
        /// Adds a key-value pair to `RequestTemplates`.
        ///
        /// To override the contents of this collection use [`set_request_templates`](Self::set_request_templates).
        ///
        /// <p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value. Supported only for WebSocket APIs.</p>
        pub fn request_templates(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.request_templates(k.into(), v.into());
            self
        }
        /// <p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value. Supported only for WebSocket APIs.</p>
        pub fn set_request_templates(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_request_templates(input);
            self
        }
        /// Adds a key-value pair to `ResponseParameters`.
        ///
        /// To override the contents of this collection use [`set_response_parameters`](Self::set_response_parameters).
        ///
        /// <p>Supported only for HTTP APIs. You use response parameters to transform the HTTP response from a backend integration before returning the response to clients. Specify a key-value map from a selection key to response parameters. The selection key must be a valid HTTP status code within the range of 200-599. Response parameters are a key-value map. The key must match pattern &lt;action&gt;:&lt;header&gt;.&lt;location&gt; or overwrite.statuscode. The action can be append, overwrite or remove. The value can be a static value, or map to response data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
        pub fn response_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: std::collections::HashMap<std::string::String, std::string::String>,
        ) -> Self {
            self.inner = self.inner.response_parameters(k.into(), v);
            self
        }
        /// <p>Supported only for HTTP APIs. You use response parameters to transform the HTTP response from a backend integration before returning the response to clients. Specify a key-value map from a selection key to response parameters. The selection key must be a valid HTTP status code within the range of 200-599. Response parameters are a key-value map. The key must match pattern &lt;action&gt;:&lt;header&gt;.&lt;location&gt; or overwrite.statuscode. The action can be append, overwrite or remove. The value can be a static value, or map to response data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
        pub fn set_response_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    std::collections::HashMap<std::string::String, std::string::String>,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_response_parameters(input);
            self
        }
        /// <p>The template selection expression for the integration.</p>
        pub fn template_selection_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.template_selection_expression(input.into());
            self
        }
        /// <p>The template selection expression for the integration.</p>
        pub fn set_template_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_selection_expression(input);
            self
        }
        /// <p>Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs. The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.</p>
        pub fn timeout_in_millis(mut self, input: i32) -> Self {
            self.inner = self.inner.timeout_in_millis(input);
            self
        }
        /// <p>Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs. The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.</p>
        pub fn set_timeout_in_millis(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_timeout_in_millis(input);
            self
        }
        /// <p>The TLS configuration for a private integration. If you specify a TLS configuration, private integration traffic uses the HTTPS protocol. Supported only for HTTP APIs.</p>
        pub fn tls_config(mut self, input: crate::model::TlsConfigInput) -> Self {
            self.inner = self.inner.tls_config(input);
            self
        }
        /// <p>The TLS configuration for a private integration. If you specify a TLS configuration, private integration traffic uses the HTTPS protocol. Supported only for HTTP APIs.</p>
        pub fn set_tls_config(
            mut self,
            input: std::option::Option<crate::model::TlsConfigInput>,
        ) -> Self {
            self.inner = self.inner.set_tls_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateIntegrationResponse`.
    ///
    /// <p>Creates an IntegrationResponses.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateIntegrationResponse {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_integration_response_input::Builder,
    }
    impl CreateIntegrationResponse {
        /// Creates a new `CreateIntegrationResponse`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateIntegrationResponseOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateIntegrationResponseError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p>
        /// <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p>
        /// <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p>
        /// <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
        pub fn content_handling_strategy(
            mut self,
            input: crate::model::ContentHandlingStrategy,
        ) -> Self {
            self.inner = self.inner.content_handling_strategy(input);
            self
        }
        /// <p>Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p>
        /// <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p>
        /// <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p>
        /// <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
        pub fn set_content_handling_strategy(
            mut self,
            input: std::option::Option<crate::model::ContentHandlingStrategy>,
        ) -> Self {
            self.inner = self.inner.set_content_handling_strategy(input);
            self
        }
        /// <p>The integration ID.</p>
        pub fn integration_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.integration_id(input.into());
            self
        }
        /// <p>The integration ID.</p>
        pub fn set_integration_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_integration_id(input);
            self
        }
        /// <p>The integration response key.</p>
        pub fn integration_response_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.integration_response_key(input.into());
            self
        }
        /// <p>The integration response key.</p>
        pub fn set_integration_response_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_integration_response_key(input);
            self
        }
        /// Adds a key-value pair to `ResponseParameters`.
        ///
        /// To override the contents of this collection use [`set_response_parameters`](Self::set_response_parameters).
        ///
        /// <p>A key-value map specifying response parameters that are passed to the method response from the backend. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of method.response.header.{name}, where {name} is a valid and unique header name. The mapped non-static value must match the pattern of integration.response.header.{name} or integration.response.body.{JSON-expression}, where {name} is a valid and unique response header name and {JSON-expression} is a valid JSON expression without the $ prefix.</p>
        pub fn response_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.response_parameters(k.into(), v.into());
            self
        }
        /// <p>A key-value map specifying response parameters that are passed to the method response from the backend. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of method.response.header.{name}, where {name} is a valid and unique header name. The mapped non-static value must match the pattern of integration.response.header.{name} or integration.response.body.{JSON-expression}, where {name} is a valid and unique response header name and {JSON-expression} is a valid JSON expression without the $ prefix.</p>
        pub fn set_response_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_response_parameters(input);
            self
        }
        /// Adds a key-value pair to `ResponseTemplates`.
        ///
        /// To override the contents of this collection use [`set_response_templates`](Self::set_response_templates).
        ///
        /// <p>The collection of response templates for the integration response as a string-to-string map of key-value pairs. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.</p>
        pub fn response_templates(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.response_templates(k.into(), v.into());
            self
        }
        /// <p>The collection of response templates for the integration response as a string-to-string map of key-value pairs. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.</p>
        pub fn set_response_templates(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_response_templates(input);
            self
        }
        /// <p>The template selection expression for the integration response. Supported only for WebSocket APIs.</p>
        pub fn template_selection_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.template_selection_expression(input.into());
            self
        }
        /// <p>The template selection expression for the integration response. Supported only for WebSocket APIs.</p>
        pub fn set_template_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_selection_expression(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateModel`.
    ///
    /// <p>Creates a Model for an API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateModel {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_model_input::Builder,
    }
    impl CreateModel {
        /// Creates a new `CreateModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateModelOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateModelError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The content-type for the model, for example, "application/json".</p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content_type(input.into());
            self
        }
        /// <p>The content-type for the model, for example, "application/json".</p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content_type(input);
            self
        }
        /// <p>The description of the model.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the model.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The name of the model. Must be alphanumeric.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the model. Must be alphanumeric.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The schema for the model. For application/json models, this should be JSON schema draft 4 model.</p>
        pub fn schema(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema(input.into());
            self
        }
        /// <p>The schema for the model. For application/json models, this should be JSON schema draft 4 model.</p>
        pub fn set_schema(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schema(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRoute`.
    ///
    /// <p>Creates a Route for an API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateRoute {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_route_input::Builder,
    }
    impl CreateRoute {
        /// Creates a new `CreateRoute`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRouteOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRouteError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>Specifies whether an API key is required for the route. Supported only for WebSocket APIs.</p>
        pub fn api_key_required(mut self, input: bool) -> Self {
            self.inner = self.inner.api_key_required(input);
            self
        }
        /// <p>Specifies whether an API key is required for the route. Supported only for WebSocket APIs.</p>
        pub fn set_api_key_required(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_api_key_required(input);
            self
        }
        /// Appends an item to `AuthorizationScopes`.
        ///
        /// To override the contents of this collection use [`set_authorization_scopes`](Self::set_authorization_scopes).
        ///
        /// <p>The authorization scopes supported by this route.</p>
        pub fn authorization_scopes(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authorization_scopes(input.into());
            self
        }
        /// <p>The authorization scopes supported by this route.</p>
        pub fn set_authorization_scopes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_authorization_scopes(input);
            self
        }
        /// <p>The authorization type for the route. For WebSocket APIs, valid values are NONE for open access, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer For HTTP APIs, valid values are NONE for open access, JWT for using JSON Web Tokens, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer.</p>
        pub fn authorization_type(mut self, input: crate::model::AuthorizationType) -> Self {
            self.inner = self.inner.authorization_type(input);
            self
        }
        /// <p>The authorization type for the route. For WebSocket APIs, valid values are NONE for open access, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer For HTTP APIs, valid values are NONE for open access, JWT for using JSON Web Tokens, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer.</p>
        pub fn set_authorization_type(
            mut self,
            input: std::option::Option<crate::model::AuthorizationType>,
        ) -> Self {
            self.inner = self.inner.set_authorization_type(input);
            self
        }
        /// <p>The identifier of the Authorizer resource to be associated with this route. The authorizer identifier is generated by API Gateway when you created the authorizer.</p>
        pub fn authorizer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authorizer_id(input.into());
            self
        }
        /// <p>The identifier of the Authorizer resource to be associated with this route. The authorizer identifier is generated by API Gateway when you created the authorizer.</p>
        pub fn set_authorizer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authorizer_id(input);
            self
        }
        /// <p>The model selection expression for the route. Supported only for WebSocket APIs.</p>
        pub fn model_selection_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_selection_expression(input.into());
            self
        }
        /// <p>The model selection expression for the route. Supported only for WebSocket APIs.</p>
        pub fn set_model_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_model_selection_expression(input);
            self
        }
        /// <p>The operation name for the route.</p>
        pub fn operation_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.operation_name(input.into());
            self
        }
        /// <p>The operation name for the route.</p>
        pub fn set_operation_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_operation_name(input);
            self
        }
        /// Adds a key-value pair to `RequestModels`.
        ///
        /// To override the contents of this collection use [`set_request_models`](Self::set_request_models).
        ///
        /// <p>The request models for the route. Supported only for WebSocket APIs.</p>
        pub fn request_models(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.request_models(k.into(), v.into());
            self
        }
        /// <p>The request models for the route. Supported only for WebSocket APIs.</p>
        pub fn set_request_models(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_request_models(input);
            self
        }
        /// Adds a key-value pair to `RequestParameters`.
        ///
        /// To override the contents of this collection use [`set_request_parameters`](Self::set_request_parameters).
        ///
        /// <p>The request parameters for the route. Supported only for WebSocket APIs.</p>
        pub fn request_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::ParameterConstraints,
        ) -> Self {
            self.inner = self.inner.request_parameters(k.into(), v);
            self
        }
        /// <p>The request parameters for the route. Supported only for WebSocket APIs.</p>
        pub fn set_request_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::ParameterConstraints>,
            >,
        ) -> Self {
            self.inner = self.inner.set_request_parameters(input);
            self
        }
        /// <p>The route key for the route.</p>
        pub fn route_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.route_key(input.into());
            self
        }
        /// <p>The route key for the route.</p>
        pub fn set_route_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_route_key(input);
            self
        }
        /// <p>The route response selection expression for the route. Supported only for WebSocket APIs.</p>
        pub fn route_response_selection_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.route_response_selection_expression(input.into());
            self
        }
        /// <p>The route response selection expression for the route. Supported only for WebSocket APIs.</p>
        pub fn set_route_response_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_route_response_selection_expression(input);
            self
        }
        /// <p>The target for the route.</p>
        pub fn target(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target(input.into());
            self
        }
        /// <p>The target for the route.</p>
        pub fn set_target(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_target(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRouteResponse`.
    ///
    /// <p>Creates a RouteResponse for a Route.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateRouteResponse {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_route_response_input::Builder,
    }
    impl CreateRouteResponse {
        /// Creates a new `CreateRouteResponse`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRouteResponseOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRouteResponseError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The model selection expression for the route response. Supported only for WebSocket APIs.</p>
        pub fn model_selection_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_selection_expression(input.into());
            self
        }
        /// <p>The model selection expression for the route response. Supported only for WebSocket APIs.</p>
        pub fn set_model_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_model_selection_expression(input);
            self
        }
        /// Adds a key-value pair to `ResponseModels`.
        ///
        /// To override the contents of this collection use [`set_response_models`](Self::set_response_models).
        ///
        /// <p>The response models for the route response.</p>
        pub fn response_models(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.response_models(k.into(), v.into());
            self
        }
        /// <p>The response models for the route response.</p>
        pub fn set_response_models(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_response_models(input);
            self
        }
        /// Adds a key-value pair to `ResponseParameters`.
        ///
        /// To override the contents of this collection use [`set_response_parameters`](Self::set_response_parameters).
        ///
        /// <p>The route response parameters.</p>
        pub fn response_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::ParameterConstraints,
        ) -> Self {
            self.inner = self.inner.response_parameters(k.into(), v);
            self
        }
        /// <p>The route response parameters.</p>
        pub fn set_response_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::ParameterConstraints>,
            >,
        ) -> Self {
            self.inner = self.inner.set_response_parameters(input);
            self
        }
        /// <p>The route ID.</p>
        pub fn route_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.route_id(input.into());
            self
        }
        /// <p>The route ID.</p>
        pub fn set_route_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_route_id(input);
            self
        }
        /// <p>The route response key.</p>
        pub fn route_response_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.route_response_key(input.into());
            self
        }
        /// <p>The route response key.</p>
        pub fn set_route_response_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_route_response_key(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateStage`.
    ///
    /// <p>Creates a Stage for an API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateStage {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_stage_input::Builder,
    }
    impl CreateStage {
        /// Creates a new `CreateStage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateStageOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateStageError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Settings for logging access in this stage.</p>
        pub fn access_log_settings(mut self, input: crate::model::AccessLogSettings) -> Self {
            self.inner = self.inner.access_log_settings(input);
            self
        }
        /// <p>Settings for logging access in this stage.</p>
        pub fn set_access_log_settings(
            mut self,
            input: std::option::Option<crate::model::AccessLogSettings>,
        ) -> Self {
            self.inner = self.inner.set_access_log_settings(input);
            self
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>Specifies whether updates to an API automatically trigger a new deployment. The default value is false.</p>
        pub fn auto_deploy(mut self, input: bool) -> Self {
            self.inner = self.inner.auto_deploy(input);
            self
        }
        /// <p>Specifies whether updates to an API automatically trigger a new deployment. The default value is false.</p>
        pub fn set_auto_deploy(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_deploy(input);
            self
        }
        /// <p>The identifier of a client certificate for a Stage. Supported only for WebSocket APIs.</p>
        pub fn client_certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_certificate_id(input.into());
            self
        }
        /// <p>The identifier of a client certificate for a Stage. Supported only for WebSocket APIs.</p>
        pub fn set_client_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_certificate_id(input);
            self
        }
        /// <p>The default route settings for the stage.</p>
        pub fn default_route_settings(mut self, input: crate::model::RouteSettings) -> Self {
            self.inner = self.inner.default_route_settings(input);
            self
        }
        /// <p>The default route settings for the stage.</p>
        pub fn set_default_route_settings(
            mut self,
            input: std::option::Option<crate::model::RouteSettings>,
        ) -> Self {
            self.inner = self.inner.set_default_route_settings(input);
            self
        }
        /// <p>The deployment identifier of the API stage.</p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_id(input.into());
            self
        }
        /// <p>The deployment identifier of the API stage.</p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_id(input);
            self
        }
        /// <p>The description for the API stage.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description for the API stage.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Adds a key-value pair to `RouteSettings`.
        ///
        /// To override the contents of this collection use [`set_route_settings`](Self::set_route_settings).
        ///
        /// <p>Route settings for the stage, by routeKey.</p>
        pub fn route_settings(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::RouteSettings,
        ) -> Self {
            self.inner = self.inner.route_settings(k.into(), v);
            self
        }
        /// <p>Route settings for the stage, by routeKey.</p>
        pub fn set_route_settings(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::RouteSettings>,
            >,
        ) -> Self {
            self.inner = self.inner.set_route_settings(input);
            self
        }
        /// <p>The name of the stage.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stage_name(input.into());
            self
        }
        /// <p>The name of the stage.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stage_name(input);
            self
        }
        /// Adds a key-value pair to `StageVariables`.
        ///
        /// To override the contents of this collection use [`set_stage_variables`](Self::set_stage_variables).
        ///
        /// <p>A map that defines the stage variables for a Stage. Variable names can have alphanumeric and underscore characters, and the values must match [A-Za-z0-9-._~:/?#&amp;=,]+.</p>
        pub fn stage_variables(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.stage_variables(k.into(), v.into());
            self
        }
        /// <p>A map that defines the stage variables for a Stage. Variable names can have alphanumeric and underscore characters, and the values must match [A-Za-z0-9-._~:/?#&amp;=,]+.</p>
        pub fn set_stage_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_stage_variables(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateVpcLink`.
    ///
    /// <p>Creates a VPC link.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateVpcLink {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_vpc_link_input::Builder,
    }
    impl CreateVpcLink {
        /// Creates a new `CreateVpcLink`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateVpcLinkOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateVpcLinkError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the VPC link.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the VPC link.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Appends an item to `SecurityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>A list of security group IDs for the VPC link.</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_group_ids(input.into());
            self
        }
        /// <p>A list of security group IDs for the VPC link.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_security_group_ids(input);
            self
        }
        /// Appends an item to `SubnetIds`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>A list of subnet IDs to include in the VPC link.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_ids(input.into());
            self
        }
        /// <p>A list of subnet IDs to include in the VPC link.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subnet_ids(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>A list of tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAccessLogSettings`.
    ///
    /// <p>Deletes the AccessLogSettings for a Stage. To disable access logging for a Stage, delete its AccessLogSettings.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAccessLogSettings {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_access_log_settings_input::Builder,
    }
    impl DeleteAccessLogSettings {
        /// Creates a new `DeleteAccessLogSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAccessLogSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAccessLogSettingsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The stage name. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stage_name(input.into());
            self
        }
        /// <p>The stage name. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stage_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteApi`.
    ///
    /// <p>Deletes an Api resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteApi {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_api_input::Builder,
    }
    impl DeleteApi {
        /// Creates a new `DeleteApi`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteApiOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteApiError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteApiMapping`.
    ///
    /// <p>Deletes an API mapping.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteApiMapping {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_api_mapping_input::Builder,
    }
    impl DeleteApiMapping {
        /// Creates a new `DeleteApiMapping`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteApiMappingOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteApiMappingError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API mapping identifier.</p>
        pub fn api_mapping_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_mapping_id(input.into());
            self
        }
        /// <p>The API mapping identifier.</p>
        pub fn set_api_mapping_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_api_mapping_id(input);
            self
        }
        /// <p>The domain name.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The domain name.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAuthorizer`.
    ///
    /// <p>Deletes an Authorizer.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAuthorizer {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_authorizer_input::Builder,
    }
    impl DeleteAuthorizer {
        /// Creates a new `DeleteAuthorizer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAuthorizerOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAuthorizerError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The authorizer identifier.</p>
        pub fn authorizer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authorizer_id(input.into());
            self
        }
        /// <p>The authorizer identifier.</p>
        pub fn set_authorizer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authorizer_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCorsConfiguration`.
    ///
    /// <p>Deletes a CORS configuration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteCorsConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_cors_configuration_input::Builder,
    }
    impl DeleteCorsConfiguration {
        /// Creates a new `DeleteCorsConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCorsConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteCorsConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDeployment`.
    ///
    /// <p>Deletes a Deployment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDeployment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_deployment_input::Builder,
    }
    impl DeleteDeployment {
        /// Creates a new `DeleteDeployment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDeploymentOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDeploymentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The deployment ID.</p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_id(input.into());
            self
        }
        /// <p>The deployment ID.</p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDomainName`.
    ///
    /// <p>Deletes a domain name.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDomainName {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_domain_name_input::Builder,
    }
    impl DeleteDomainName {
        /// Creates a new `DeleteDomainName`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDomainNameOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDomainNameError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The domain name.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The domain name.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteIntegration`.
    ///
    /// <p>Deletes an Integration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteIntegration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_integration_input::Builder,
    }
    impl DeleteIntegration {
        /// Creates a new `DeleteIntegration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteIntegrationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteIntegrationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The integration ID.</p>
        pub fn integration_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.integration_id(input.into());
            self
        }
        /// <p>The integration ID.</p>
        pub fn set_integration_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_integration_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteIntegrationResponse`.
    ///
    /// <p>Deletes an IntegrationResponses.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteIntegrationResponse {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_integration_response_input::Builder,
    }
    impl DeleteIntegrationResponse {
        /// Creates a new `DeleteIntegrationResponse`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteIntegrationResponseOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteIntegrationResponseError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The integration ID.</p>
        pub fn integration_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.integration_id(input.into());
            self
        }
        /// <p>The integration ID.</p>
        pub fn set_integration_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_integration_id(input);
            self
        }
        /// <p>The integration response ID.</p>
        pub fn integration_response_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.integration_response_id(input.into());
            self
        }
        /// <p>The integration response ID.</p>
        pub fn set_integration_response_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_integration_response_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteModel`.
    ///
    /// <p>Deletes a Model.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteModel {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_model_input::Builder,
    }
    impl DeleteModel {
        /// Creates a new `DeleteModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteModelOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteModelError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The model ID.</p>
        pub fn model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_id(input.into());
            self
        }
        /// <p>The model ID.</p>
        pub fn set_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_model_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRoute`.
    ///
    /// <p>Deletes a Route.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteRoute {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_route_input::Builder,
    }
    impl DeleteRoute {
        /// Creates a new `DeleteRoute`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRouteOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRouteError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The route ID.</p>
        pub fn route_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.route_id(input.into());
            self
        }
        /// <p>The route ID.</p>
        pub fn set_route_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_route_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRouteRequestParameter`.
    ///
    /// <p>Deletes a route request parameter.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteRouteRequestParameter {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_route_request_parameter_input::Builder,
    }
    impl DeleteRouteRequestParameter {
        /// Creates a new `DeleteRouteRequestParameter`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRouteRequestParameterOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRouteRequestParameterError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The route request parameter key.</p>
        pub fn request_parameter_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.request_parameter_key(input.into());
            self
        }
        /// <p>The route request parameter key.</p>
        pub fn set_request_parameter_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_request_parameter_key(input);
            self
        }
        /// <p>The route ID.</p>
        pub fn route_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.route_id(input.into());
            self
        }
        /// <p>The route ID.</p>
        pub fn set_route_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_route_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRouteResponse`.
    ///
    /// <p>Deletes a RouteResponse.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteRouteResponse {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_route_response_input::Builder,
    }
    impl DeleteRouteResponse {
        /// Creates a new `DeleteRouteResponse`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRouteResponseOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRouteResponseError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The route ID.</p>
        pub fn route_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.route_id(input.into());
            self
        }
        /// <p>The route ID.</p>
        pub fn set_route_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_route_id(input);
            self
        }
        /// <p>The route response ID.</p>
        pub fn route_response_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.route_response_id(input.into());
            self
        }
        /// <p>The route response ID.</p>
        pub fn set_route_response_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_route_response_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRouteSettings`.
    ///
    /// <p>Deletes the RouteSettings for a stage.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteRouteSettings {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_route_settings_input::Builder,
    }
    impl DeleteRouteSettings {
        /// Creates a new `DeleteRouteSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRouteSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRouteSettingsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The route key.</p>
        pub fn route_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.route_key(input.into());
            self
        }
        /// <p>The route key.</p>
        pub fn set_route_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_route_key(input);
            self
        }
        /// <p>The stage name. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stage_name(input.into());
            self
        }
        /// <p>The stage name. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stage_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteStage`.
    ///
    /// <p>Deletes a Stage.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteStage {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_stage_input::Builder,
    }
    impl DeleteStage {
        /// Creates a new `DeleteStage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteStageOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteStageError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The stage name. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stage_name(input.into());
            self
        }
        /// <p>The stage name. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stage_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteVpcLink`.
    ///
    /// <p>Deletes a VPC link.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteVpcLink {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_vpc_link_input::Builder,
    }
    impl DeleteVpcLink {
        /// Creates a new `DeleteVpcLink`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteVpcLinkOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteVpcLinkError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the VPC link.</p>
        pub fn vpc_link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_link_id(input.into());
            self
        }
        /// <p>The ID of the VPC link.</p>
        pub fn set_vpc_link_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_vpc_link_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ExportApi`.
    ///
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ExportApi {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::export_api_input::Builder,
    }
    impl ExportApi {
        /// Creates a new `ExportApi`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ExportApiOutput,
            aws_smithy_http::result::SdkError<crate::error::ExportApiError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The version of the API Gateway export algorithm. API Gateway uses the latest version by default. Currently, the only supported version is 1.0.</p>
        pub fn export_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.export_version(input.into());
            self
        }
        /// <p>The version of the API Gateway export algorithm. API Gateway uses the latest version by default. Currently, the only supported version is 1.0.</p>
        pub fn set_export_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_export_version(input);
            self
        }
        /// <p>Specifies whether to include <a href="https://docs.aws.amazon.com//apigateway/latest/developerguide/api-gateway-swagger-extensions.html">API Gateway extensions</a> in the exported API definition. API Gateway extensions are included by default.</p>
        pub fn include_extensions(mut self, input: bool) -> Self {
            self.inner = self.inner.include_extensions(input);
            self
        }
        /// <p>Specifies whether to include <a href="https://docs.aws.amazon.com//apigateway/latest/developerguide/api-gateway-swagger-extensions.html">API Gateway extensions</a> in the exported API definition. API Gateway extensions are included by default.</p>
        pub fn set_include_extensions(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_extensions(input);
            self
        }
        /// <p>The output type of the exported definition file. Valid values are JSON and YAML.</p>
        pub fn output_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.output_type(input.into());
            self
        }
        /// <p>The output type of the exported definition file. Valid values are JSON and YAML.</p>
        pub fn set_output_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_output_type(input);
            self
        }
        /// <p>The version of the API specification to use. OAS30, for OpenAPI 3.0, is the only supported value.</p>
        pub fn specification(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.specification(input.into());
            self
        }
        /// <p>The version of the API specification to use. OAS30, for OpenAPI 3.0, is the only supported value.</p>
        pub fn set_specification(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_specification(input);
            self
        }
        /// <p>The name of the API stage to export. If you don't specify this property, a representation of the latest API configuration is exported.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stage_name(input.into());
            self
        }
        /// <p>The name of the API stage to export. If you don't specify this property, a representation of the latest API configuration is exported.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stage_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetApi`.
    ///
    /// <p>Gets an Api resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetApi {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_api_input::Builder,
    }
    impl GetApi {
        /// Creates a new `GetApi`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetApiOutput,
            aws_smithy_http::result::SdkError<crate::error::GetApiError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetApiMapping`.
    ///
    /// <p>Gets an API mapping.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetApiMapping {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_api_mapping_input::Builder,
    }
    impl GetApiMapping {
        /// Creates a new `GetApiMapping`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetApiMappingOutput,
            aws_smithy_http::result::SdkError<crate::error::GetApiMappingError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API mapping identifier.</p>
        pub fn api_mapping_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_mapping_id(input.into());
            self
        }
        /// <p>The API mapping identifier.</p>
        pub fn set_api_mapping_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_api_mapping_id(input);
            self
        }
        /// <p>The domain name.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The domain name.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetApiMappings`.
    ///
    /// <p>Gets API mappings.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetApiMappings {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_api_mappings_input::Builder,
    }
    impl GetApiMappings {
        /// Creates a new `GetApiMappings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetApiMappingsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetApiMappingsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The domain name.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The domain name.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn max_results(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.max_results(input.into());
            self
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetApis`.
    ///
    /// <p>Gets a collection of Api resources.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetApis {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_apis_input::Builder,
    }
    impl GetApis {
        /// Creates a new `GetApis`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetApisOutput,
            aws_smithy_http::result::SdkError<crate::error::GetApisError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn max_results(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.max_results(input.into());
            self
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAuthorizer`.
    ///
    /// <p>Gets an Authorizer.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAuthorizer {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_authorizer_input::Builder,
    }
    impl GetAuthorizer {
        /// Creates a new `GetAuthorizer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAuthorizerOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAuthorizerError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The authorizer identifier.</p>
        pub fn authorizer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authorizer_id(input.into());
            self
        }
        /// <p>The authorizer identifier.</p>
        pub fn set_authorizer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authorizer_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAuthorizers`.
    ///
    /// <p>Gets the Authorizers for an API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAuthorizers {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_authorizers_input::Builder,
    }
    impl GetAuthorizers {
        /// Creates a new `GetAuthorizers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAuthorizersOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAuthorizersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn max_results(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.max_results(input.into());
            self
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDeployment`.
    ///
    /// <p>Gets a Deployment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDeployment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_deployment_input::Builder,
    }
    impl GetDeployment {
        /// Creates a new `GetDeployment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDeploymentOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDeploymentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The deployment ID.</p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_id(input.into());
            self
        }
        /// <p>The deployment ID.</p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDeployments`.
    ///
    /// <p>Gets the Deployments for an API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDeployments {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_deployments_input::Builder,
    }
    impl GetDeployments {
        /// Creates a new `GetDeployments`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDeploymentsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDeploymentsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn max_results(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.max_results(input.into());
            self
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDomainName`.
    ///
    /// <p>Gets a domain name.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDomainName {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_domain_name_input::Builder,
    }
    impl GetDomainName {
        /// Creates a new `GetDomainName`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDomainNameOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDomainNameError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The domain name.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The domain name.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDomainNames`.
    ///
    /// <p>Gets the domain names for an AWS account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDomainNames {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_domain_names_input::Builder,
    }
    impl GetDomainNames {
        /// Creates a new `GetDomainNames`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDomainNamesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDomainNamesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn max_results(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.max_results(input.into());
            self
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetIntegration`.
    ///
    /// <p>Gets an Integration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetIntegration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_integration_input::Builder,
    }
    impl GetIntegration {
        /// Creates a new `GetIntegration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetIntegrationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetIntegrationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The integration ID.</p>
        pub fn integration_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.integration_id(input.into());
            self
        }
        /// <p>The integration ID.</p>
        pub fn set_integration_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_integration_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetIntegrationResponse`.
    ///
    /// <p>Gets an IntegrationResponses.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetIntegrationResponse {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_integration_response_input::Builder,
    }
    impl GetIntegrationResponse {
        /// Creates a new `GetIntegrationResponse`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetIntegrationResponseOutput,
            aws_smithy_http::result::SdkError<crate::error::GetIntegrationResponseError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The integration ID.</p>
        pub fn integration_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.integration_id(input.into());
            self
        }
        /// <p>The integration ID.</p>
        pub fn set_integration_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_integration_id(input);
            self
        }
        /// <p>The integration response ID.</p>
        pub fn integration_response_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.integration_response_id(input.into());
            self
        }
        /// <p>The integration response ID.</p>
        pub fn set_integration_response_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_integration_response_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetIntegrationResponses`.
    ///
    /// <p>Gets the IntegrationResponses for an Integration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetIntegrationResponses {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_integration_responses_input::Builder,
    }
    impl GetIntegrationResponses {
        /// Creates a new `GetIntegrationResponses`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetIntegrationResponsesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetIntegrationResponsesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The integration ID.</p>
        pub fn integration_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.integration_id(input.into());
            self
        }
        /// <p>The integration ID.</p>
        pub fn set_integration_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_integration_id(input);
            self
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn max_results(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.max_results(input.into());
            self
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetIntegrations`.
    ///
    /// <p>Gets the Integrations for an API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetIntegrations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_integrations_input::Builder,
    }
    impl GetIntegrations {
        /// Creates a new `GetIntegrations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetIntegrationsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetIntegrationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn max_results(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.max_results(input.into());
            self
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetModel`.
    ///
    /// <p>Gets a Model.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetModel {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_model_input::Builder,
    }
    impl GetModel {
        /// Creates a new `GetModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetModelOutput,
            aws_smithy_http::result::SdkError<crate::error::GetModelError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The model ID.</p>
        pub fn model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_id(input.into());
            self
        }
        /// <p>The model ID.</p>
        pub fn set_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_model_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetModels`.
    ///
    /// <p>Gets the Models for an API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetModels {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_models_input::Builder,
    }
    impl GetModels {
        /// Creates a new `GetModels`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetModelsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetModelsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn max_results(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.max_results(input.into());
            self
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetModelTemplate`.
    ///
    /// <p>Gets a model template.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetModelTemplate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_model_template_input::Builder,
    }
    impl GetModelTemplate {
        /// Creates a new `GetModelTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetModelTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::GetModelTemplateError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The model ID.</p>
        pub fn model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_id(input.into());
            self
        }
        /// <p>The model ID.</p>
        pub fn set_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_model_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRoute`.
    ///
    /// <p>Gets a Route.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetRoute {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_route_input::Builder,
    }
    impl GetRoute {
        /// Creates a new `GetRoute`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRouteOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRouteError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The route ID.</p>
        pub fn route_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.route_id(input.into());
            self
        }
        /// <p>The route ID.</p>
        pub fn set_route_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_route_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRouteResponse`.
    ///
    /// <p>Gets a RouteResponse.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetRouteResponse {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_route_response_input::Builder,
    }
    impl GetRouteResponse {
        /// Creates a new `GetRouteResponse`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRouteResponseOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRouteResponseError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The route ID.</p>
        pub fn route_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.route_id(input.into());
            self
        }
        /// <p>The route ID.</p>
        pub fn set_route_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_route_id(input);
            self
        }
        /// <p>The route response ID.</p>
        pub fn route_response_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.route_response_id(input.into());
            self
        }
        /// <p>The route response ID.</p>
        pub fn set_route_response_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_route_response_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRouteResponses`.
    ///
    /// <p>Gets the RouteResponses for a Route.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetRouteResponses {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_route_responses_input::Builder,
    }
    impl GetRouteResponses {
        /// Creates a new `GetRouteResponses`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRouteResponsesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRouteResponsesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn max_results(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.max_results(input.into());
            self
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The route ID.</p>
        pub fn route_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.route_id(input.into());
            self
        }
        /// <p>The route ID.</p>
        pub fn set_route_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_route_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRoutes`.
    ///
    /// <p>Gets the Routes for an API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetRoutes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_routes_input::Builder,
    }
    impl GetRoutes {
        /// Creates a new `GetRoutes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRoutesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRoutesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn max_results(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.max_results(input.into());
            self
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetStage`.
    ///
    /// <p>Gets a Stage.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetStage {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_stage_input::Builder,
    }
    impl GetStage {
        /// Creates a new `GetStage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetStageOutput,
            aws_smithy_http::result::SdkError<crate::error::GetStageError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The stage name. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stage_name(input.into());
            self
        }
        /// <p>The stage name. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stage_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetStages`.
    ///
    /// <p>Gets the Stages for an API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetStages {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_stages_input::Builder,
    }
    impl GetStages {
        /// Creates a new `GetStages`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetStagesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetStagesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn max_results(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.max_results(input.into());
            self
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetTags`.
    ///
    /// <p>Gets a collection of Tag resources.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetTags {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_tags_input::Builder,
    }
    impl GetTags {
        /// Creates a new `GetTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetTagsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The resource ARN for the tag.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The resource ARN for the tag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetVpcLink`.
    ///
    /// <p>Gets a VPC link.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetVpcLink {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_vpc_link_input::Builder,
    }
    impl GetVpcLink {
        /// Creates a new `GetVpcLink`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetVpcLinkOutput,
            aws_smithy_http::result::SdkError<crate::error::GetVpcLinkError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the VPC link.</p>
        pub fn vpc_link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_link_id(input.into());
            self
        }
        /// <p>The ID of the VPC link.</p>
        pub fn set_vpc_link_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_vpc_link_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetVpcLinks`.
    ///
    /// <p>Gets a collection of VPC links.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetVpcLinks {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_vpc_links_input::Builder,
    }
    impl GetVpcLinks {
        /// Creates a new `GetVpcLinks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetVpcLinksOutput,
            aws_smithy_http::result::SdkError<crate::error::GetVpcLinksError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn max_results(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.max_results(input.into());
            self
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ImportApi`.
    ///
    /// <p>Imports an API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ImportApi {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::import_api_input::Builder,
    }
    impl ImportApi {
        /// Creates a new `ImportApi`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ImportApiOutput,
            aws_smithy_http::result::SdkError<crate::error::ImportApiError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies how to interpret the base path of the API during import. Valid values are ignore, prepend, and split. The default value is ignore. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-import-api-basePath.html">Set the OpenAPI basePath Property</a>. Supported only for HTTP APIs.</p>
        pub fn basepath(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.basepath(input.into());
            self
        }
        /// <p>Specifies how to interpret the base path of the API during import. Valid values are ignore, prepend, and split. The default value is ignore. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-import-api-basePath.html">Set the OpenAPI basePath Property</a>. Supported only for HTTP APIs.</p>
        pub fn set_basepath(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_basepath(input);
            self
        }
        /// <p>The OpenAPI definition. Supported only for HTTP APIs.</p>
        pub fn body(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.body(input.into());
            self
        }
        /// <p>The OpenAPI definition. Supported only for HTTP APIs.</p>
        pub fn set_body(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_body(input);
            self
        }
        /// <p>Specifies whether to rollback the API creation when a warning is encountered. By default, API creation continues if a warning is encountered.</p>
        pub fn fail_on_warnings(mut self, input: bool) -> Self {
            self.inner = self.inner.fail_on_warnings(input);
            self
        }
        /// <p>Specifies whether to rollback the API creation when a warning is encountered. By default, API creation continues if a warning is encountered.</p>
        pub fn set_fail_on_warnings(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_fail_on_warnings(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ReimportApi`.
    ///
    /// <p>Puts an Api resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ReimportApi {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::reimport_api_input::Builder,
    }
    impl ReimportApi {
        /// Creates a new `ReimportApi`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ReimportApiOutput,
            aws_smithy_http::result::SdkError<crate::error::ReimportApiError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>Specifies how to interpret the base path of the API during import. Valid values are ignore, prepend, and split. The default value is ignore. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-import-api-basePath.html">Set the OpenAPI basePath Property</a>. Supported only for HTTP APIs.</p>
        pub fn basepath(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.basepath(input.into());
            self
        }
        /// <p>Specifies how to interpret the base path of the API during import. Valid values are ignore, prepend, and split. The default value is ignore. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-import-api-basePath.html">Set the OpenAPI basePath Property</a>. Supported only for HTTP APIs.</p>
        pub fn set_basepath(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_basepath(input);
            self
        }
        /// <p>The OpenAPI definition. Supported only for HTTP APIs.</p>
        pub fn body(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.body(input.into());
            self
        }
        /// <p>The OpenAPI definition. Supported only for HTTP APIs.</p>
        pub fn set_body(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_body(input);
            self
        }
        /// <p>Specifies whether to rollback the API creation when a warning is encountered. By default, API creation continues if a warning is encountered.</p>
        pub fn fail_on_warnings(mut self, input: bool) -> Self {
            self.inner = self.inner.fail_on_warnings(input);
            self
        }
        /// <p>Specifies whether to rollback the API creation when a warning is encountered. By default, API creation continues if a warning is encountered.</p>
        pub fn set_fail_on_warnings(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_fail_on_warnings(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ResetAuthorizersCache`.
    ///
    /// <p>Resets all authorizer cache entries on a stage. Supported only for HTTP APIs.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ResetAuthorizersCache {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::reset_authorizers_cache_input::Builder,
    }
    impl ResetAuthorizersCache {
        /// Creates a new `ResetAuthorizersCache`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ResetAuthorizersCacheOutput,
            aws_smithy_http::result::SdkError<crate::error::ResetAuthorizersCacheError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The stage name. Stage names can contain only alphanumeric characters, hyphens, and underscores, or be $default. Maximum length is 128 characters.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stage_name(input.into());
            self
        }
        /// <p>The stage name. Stage names can contain only alphanumeric characters, hyphens, and underscores, or be $default. Maximum length is 128 characters.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stage_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Creates a new Tag resource to represent a tag.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The resource ARN for the tag.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The resource ARN for the tag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Deletes a Tag.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The resource ARN for the tag.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The resource ARN for the tag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The Tag keys to delete</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The Tag keys to delete</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateApi`.
    ///
    /// <p>Updates an Api resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateApi {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_api_input::Builder,
    }
    impl UpdateApi {
        /// Creates a new `UpdateApi`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateApiOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateApiError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>An API key selection expression. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions">API Key Selection Expressions</a>.</p>
        pub fn api_key_selection_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.api_key_selection_expression(input.into());
            self
        }
        /// <p>An API key selection expression. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions">API Key Selection Expressions</a>.</p>
        pub fn set_api_key_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_api_key_selection_expression(input);
            self
        }
        /// <p>A CORS configuration. Supported only for HTTP APIs.</p>
        pub fn cors_configuration(mut self, input: crate::model::Cors) -> Self {
            self.inner = self.inner.cors_configuration(input);
            self
        }
        /// <p>A CORS configuration. Supported only for HTTP APIs.</p>
        pub fn set_cors_configuration(
            mut self,
            input: std::option::Option<crate::model::Cors>,
        ) -> Self {
            self.inner = self.inner.set_cors_configuration(input);
            self
        }
        /// <p>This property is part of quick create. It specifies the credentials required for the integration, if any. For a Lambda integration, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, don't specify this parameter. Currently, this property is not used for HTTP integrations. If provided, this value replaces the credentials associated with the quick create integration. Supported only for HTTP APIs.</p>
        pub fn credentials_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.credentials_arn(input.into());
            self
        }
        /// <p>This property is part of quick create. It specifies the credentials required for the integration, if any. For a Lambda integration, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, don't specify this parameter. Currently, this property is not used for HTTP integrations. If provided, this value replaces the credentials associated with the quick create integration. Supported only for HTTP APIs.</p>
        pub fn set_credentials_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_credentials_arn(input);
            self
        }
        /// <p>The description of the API.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the API.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Avoid validating models when creating a deployment. Supported only for WebSocket APIs.</p>
        pub fn disable_schema_validation(mut self, input: bool) -> Self {
            self.inner = self.inner.disable_schema_validation(input);
            self
        }
        /// <p>Avoid validating models when creating a deployment. Supported only for WebSocket APIs.</p>
        pub fn set_disable_schema_validation(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_disable_schema_validation(input);
            self
        }
        /// <p>Specifies whether clients can invoke your API by using the default execute-api endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
        pub fn disable_execute_api_endpoint(mut self, input: bool) -> Self {
            self.inner = self.inner.disable_execute_api_endpoint(input);
            self
        }
        /// <p>Specifies whether clients can invoke your API by using the default execute-api endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
        pub fn set_disable_execute_api_endpoint(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_disable_execute_api_endpoint(input);
            self
        }
        /// <p>The name of the API.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the API.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>This property is part of quick create. If not specified, the route created using quick create is kept. Otherwise, this value replaces the route key of the quick create route. Additional routes may still be added after the API is updated. Supported only for HTTP APIs.</p>
        pub fn route_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.route_key(input.into());
            self
        }
        /// <p>This property is part of quick create. If not specified, the route created using quick create is kept. Otherwise, this value replaces the route key of the quick create route. Additional routes may still be added after the API is updated. Supported only for HTTP APIs.</p>
        pub fn set_route_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_route_key(input);
            self
        }
        /// <p>The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.</p>
        pub fn route_selection_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.route_selection_expression(input.into());
            self
        }
        /// <p>The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.</p>
        pub fn set_route_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_route_selection_expression(input);
            self
        }
        /// <p>This property is part of quick create. For HTTP integrations, specify a fully qualified URL. For Lambda integrations, specify a function ARN. The type of the integration will be HTTP_PROXY or AWS_PROXY, respectively. The value provided updates the integration URI and integration type. You can update a quick-created target, but you can't remove it from an API. Supported only for HTTP APIs.</p>
        pub fn target(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target(input.into());
            self
        }
        /// <p>This property is part of quick create. For HTTP integrations, specify a fully qualified URL. For Lambda integrations, specify a function ARN. The type of the integration will be HTTP_PROXY or AWS_PROXY, respectively. The value provided updates the integration URI and integration type. You can update a quick-created target, but you can't remove it from an API. Supported only for HTTP APIs.</p>
        pub fn set_target(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_target(input);
            self
        }
        /// <p>A version identifier for the API.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(input.into());
            self
        }
        /// <p>A version identifier for the API.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateApiMapping`.
    ///
    /// <p>The API mapping.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateApiMapping {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_api_mapping_input::Builder,
    }
    impl UpdateApiMapping {
        /// Creates a new `UpdateApiMapping`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateApiMappingOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateApiMappingError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The API mapping identifier.</p>
        pub fn api_mapping_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_mapping_id(input.into());
            self
        }
        /// <p>The API mapping identifier.</p>
        pub fn set_api_mapping_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_api_mapping_id(input);
            self
        }
        /// <p>The API mapping key.</p>
        pub fn api_mapping_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_mapping_key(input.into());
            self
        }
        /// <p>The API mapping key.</p>
        pub fn set_api_mapping_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_api_mapping_key(input);
            self
        }
        /// <p>The domain name.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The domain name.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The API stage.</p>
        pub fn stage(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stage(input.into());
            self
        }
        /// <p>The API stage.</p>
        pub fn set_stage(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stage(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAuthorizer`.
    ///
    /// <p>Updates an Authorizer.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateAuthorizer {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_authorizer_input::Builder,
    }
    impl UpdateAuthorizer {
        /// Creates a new `UpdateAuthorizer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAuthorizerOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAuthorizerError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, don't specify this parameter.</p>
        pub fn authorizer_credentials_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authorizer_credentials_arn(input.into());
            self
        }
        /// <p>Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, don't specify this parameter.</p>
        pub fn set_authorizer_credentials_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authorizer_credentials_arn(input);
            self
        }
        /// <p>The authorizer identifier.</p>
        pub fn authorizer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authorizer_id(input.into());
            self
        }
        /// <p>The authorizer identifier.</p>
        pub fn set_authorizer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authorizer_id(input);
            self
        }
        /// <p>Specifies the format of the payload sent to an HTTP API Lambda authorizer. Required for HTTP API Lambda authorizers. Supported values are 1.0 and 2.0. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p>
        pub fn authorizer_payload_format_version(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.authorizer_payload_format_version(input.into());
            self
        }
        /// <p>Specifies the format of the payload sent to an HTTP API Lambda authorizer. Required for HTTP API Lambda authorizers. Supported values are 1.0 and 2.0. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p>
        pub fn set_authorizer_payload_format_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authorizer_payload_format_version(input);
            self
        }
        /// <p>The time to live (TTL) for cached authorizer results, in seconds. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway caches authorizer responses. The maximum value is 3600, or 1 hour. Supported only for HTTP API Lambda authorizers.</p>
        pub fn authorizer_result_ttl_in_seconds(mut self, input: i32) -> Self {
            self.inner = self.inner.authorizer_result_ttl_in_seconds(input);
            self
        }
        /// <p>The time to live (TTL) for cached authorizer results, in seconds. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway caches authorizer responses. The maximum value is 3600, or 1 hour. Supported only for HTTP API Lambda authorizers.</p>
        pub fn set_authorizer_result_ttl_in_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_authorizer_result_ttl_in_seconds(input);
            self
        }
        /// <p>The authorizer type. Specify REQUEST for a Lambda function using incoming request parameters. Specify JWT to use JSON Web Tokens (supported only for HTTP APIs).</p>
        pub fn authorizer_type(mut self, input: crate::model::AuthorizerType) -> Self {
            self.inner = self.inner.authorizer_type(input);
            self
        }
        /// <p>The authorizer type. Specify REQUEST for a Lambda function using incoming request parameters. Specify JWT to use JSON Web Tokens (supported only for HTTP APIs).</p>
        pub fn set_authorizer_type(
            mut self,
            input: std::option::Option<crate::model::AuthorizerType>,
        ) -> Self {
            self.inner = self.inner.set_authorizer_type(input);
            self
        }
        /// <p>The authorizer's Uniform Resource Identifier (URI). For REQUEST authorizers, this must be a well-formed Lambda function URI, for example, arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:<replaceable>
        /// {account_id}
        /// </replaceable>:function:<replaceable>
        /// {lambda_function_name}
        /// </replaceable>/invocations. In general, the URI has this form: arn:aws:apigateway:<replaceable>
        /// {region}
        /// </replaceable>:lambda:path/<replaceable>
        /// {service_api}
        /// </replaceable> , where <replaceable></replaceable>{region} is the same as the region hosting the Lambda function, path indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial /. For Lambda functions, this is usually of the form /2015-03-31/functions/[FunctionARN]/invocations. Supported only for REQUEST authorizers.</p>
        pub fn authorizer_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authorizer_uri(input.into());
            self
        }
        /// <p>The authorizer's Uniform Resource Identifier (URI). For REQUEST authorizers, this must be a well-formed Lambda function URI, for example, arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:<replaceable>
        /// {account_id}
        /// </replaceable>:function:<replaceable>
        /// {lambda_function_name}
        /// </replaceable>/invocations. In general, the URI has this form: arn:aws:apigateway:<replaceable>
        /// {region}
        /// </replaceable>:lambda:path/<replaceable>
        /// {service_api}
        /// </replaceable> , where <replaceable></replaceable>{region} is the same as the region hosting the Lambda function, path indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial /. For Lambda functions, this is usually of the form /2015-03-31/functions/[FunctionARN]/invocations. Supported only for REQUEST authorizers.</p>
        pub fn set_authorizer_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authorizer_uri(input);
            self
        }
        /// <p>Specifies whether a Lambda authorizer returns a response in a simple format. By default, a Lambda authorizer must return an IAM policy. If enabled, the Lambda authorizer can return a boolean value instead of an IAM policy. Supported only for HTTP APIs. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a></p>
        pub fn enable_simple_responses(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_simple_responses(input);
            self
        }
        /// <p>Specifies whether a Lambda authorizer returns a response in a simple format. By default, a Lambda authorizer must return an IAM policy. If enabled, the Lambda authorizer can return a boolean value instead of an IAM policy. Supported only for HTTP APIs. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a></p>
        pub fn set_enable_simple_responses(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_simple_responses(input);
            self
        }
        /// Appends an item to `IdentitySource`.
        ///
        /// To override the contents of this collection use [`set_identity_source`](Self::set_identity_source).
        ///
        /// <p>The identity source for which authorization is requested.</p>
        /// <p>For a REQUEST authorizer, this is optional. The value is a set of one or more mapping expressions of the specified request parameters. The identity source can be headers, query string parameters, stage variables, and context parameters. For example, if an Auth header and a Name query string parameter are defined as identity sources, this value is route.request.header.Auth, route.request.querystring.Name for WebSocket APIs. For HTTP APIs, use selection expressions prefixed with $, for example, $request.header.Auth, $request.querystring.Name. These parameters are used to perform runtime validation for Lambda-based authorizers by verifying all of the identity-related request parameters are present in the request, not null, and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function. Otherwise, it returns a 401 Unauthorized response without calling the Lambda function. For HTTP APIs, identity sources are also used as the cache key when caching is enabled. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p>
        /// <p>For JWT, a single entry that specifies where to extract the JSON Web Token (JWT) from inbound requests. Currently only header-based and query parameter-based selections are supported, for example $request.header.Authorization.</p>
        pub fn identity_source(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_source(input.into());
            self
        }
        /// <p>The identity source for which authorization is requested.</p>
        /// <p>For a REQUEST authorizer, this is optional. The value is a set of one or more mapping expressions of the specified request parameters. The identity source can be headers, query string parameters, stage variables, and context parameters. For example, if an Auth header and a Name query string parameter are defined as identity sources, this value is route.request.header.Auth, route.request.querystring.Name for WebSocket APIs. For HTTP APIs, use selection expressions prefixed with $, for example, $request.header.Auth, $request.querystring.Name. These parameters are used to perform runtime validation for Lambda-based authorizers by verifying all of the identity-related request parameters are present in the request, not null, and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function. Otherwise, it returns a 401 Unauthorized response without calling the Lambda function. For HTTP APIs, identity sources are also used as the cache key when caching is enabled. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p>
        /// <p>For JWT, a single entry that specifies where to extract the JSON Web Token (JWT) from inbound requests. Currently only header-based and query parameter-based selections are supported, for example $request.header.Authorization.</p>
        pub fn set_identity_source(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_identity_source(input);
            self
        }
        /// <p>This parameter is not used.</p>
        pub fn identity_validation_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.identity_validation_expression(input.into());
            self
        }
        /// <p>This parameter is not used.</p>
        pub fn set_identity_validation_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_validation_expression(input);
            self
        }
        /// <p>Represents the configuration of a JWT authorizer. Required for the JWT authorizer type. Supported only for HTTP APIs.</p>
        pub fn jwt_configuration(mut self, input: crate::model::JwtConfiguration) -> Self {
            self.inner = self.inner.jwt_configuration(input);
            self
        }
        /// <p>Represents the configuration of a JWT authorizer. Required for the JWT authorizer type. Supported only for HTTP APIs.</p>
        pub fn set_jwt_configuration(
            mut self,
            input: std::option::Option<crate::model::JwtConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_jwt_configuration(input);
            self
        }
        /// <p>The name of the authorizer.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the authorizer.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDeployment`.
    ///
    /// <p>Updates a Deployment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateDeployment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_deployment_input::Builder,
    }
    impl UpdateDeployment {
        /// Creates a new `UpdateDeployment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDeploymentOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDeploymentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The deployment ID.</p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_id(input.into());
            self
        }
        /// <p>The deployment ID.</p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_id(input);
            self
        }
        /// <p>The description for the deployment resource.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description for the deployment resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDomainName`.
    ///
    /// <p>Updates a domain name.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateDomainName {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_domain_name_input::Builder,
    }
    impl UpdateDomainName {
        /// Creates a new `UpdateDomainName`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDomainNameOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDomainNameError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The domain name.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The domain name.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// Appends an item to `DomainNameConfigurations`.
        ///
        /// To override the contents of this collection use [`set_domain_name_configurations`](Self::set_domain_name_configurations).
        ///
        /// <p>The domain name configurations.</p>
        pub fn domain_name_configurations(
            mut self,
            input: crate::model::DomainNameConfiguration,
        ) -> Self {
            self.inner = self.inner.domain_name_configurations(input);
            self
        }
        /// <p>The domain name configurations.</p>
        pub fn set_domain_name_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DomainNameConfiguration>>,
        ) -> Self {
            self.inner = self.inner.set_domain_name_configurations(input);
            self
        }
        /// <p>The mutual TLS authentication configuration for a custom domain name.</p>
        pub fn mutual_tls_authentication(
            mut self,
            input: crate::model::MutualTlsAuthenticationInput,
        ) -> Self {
            self.inner = self.inner.mutual_tls_authentication(input);
            self
        }
        /// <p>The mutual TLS authentication configuration for a custom domain name.</p>
        pub fn set_mutual_tls_authentication(
            mut self,
            input: std::option::Option<crate::model::MutualTlsAuthenticationInput>,
        ) -> Self {
            self.inner = self.inner.set_mutual_tls_authentication(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateIntegration`.
    ///
    /// <p>Updates an Integration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateIntegration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_integration_input::Builder,
    }
    impl UpdateIntegration {
        /// Creates a new `UpdateIntegration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateIntegrationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateIntegrationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The ID of the VPC link for a private integration. Supported only for HTTP APIs.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_id(input.into());
            self
        }
        /// <p>The ID of the VPC link for a private integration. Supported only for HTTP APIs.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_id(input);
            self
        }
        /// <p>The type of the network connection to the integration endpoint. Specify INTERNET for connections through the public routable internet or VPC_LINK for private connections between API Gateway and resources in a VPC. The default value is INTERNET.</p>
        pub fn connection_type(mut self, input: crate::model::ConnectionType) -> Self {
            self.inner = self.inner.connection_type(input);
            self
        }
        /// <p>The type of the network connection to the integration endpoint. Specify INTERNET for connections through the public routable internet or VPC_LINK for private connections between API Gateway and resources in a VPC. The default value is INTERNET.</p>
        pub fn set_connection_type(
            mut self,
            input: std::option::Option<crate::model::ConnectionType>,
        ) -> Self {
            self.inner = self.inner.set_connection_type(input);
            self
        }
        /// <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p>
        /// <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p>
        /// <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p>
        /// <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
        pub fn content_handling_strategy(
            mut self,
            input: crate::model::ContentHandlingStrategy,
        ) -> Self {
            self.inner = self.inner.content_handling_strategy(input);
            self
        }
        /// <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p>
        /// <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p>
        /// <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p>
        /// <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
        pub fn set_content_handling_strategy(
            mut self,
            input: std::option::Option<crate::model::ContentHandlingStrategy>,
        ) -> Self {
            self.inner = self.inner.set_content_handling_strategy(input);
            self
        }
        /// <p>Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, specify null.</p>
        pub fn credentials_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.credentials_arn(input.into());
            self
        }
        /// <p>Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, specify null.</p>
        pub fn set_credentials_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_credentials_arn(input);
            self
        }
        /// <p>The description of the integration</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the integration</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The integration ID.</p>
        pub fn integration_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.integration_id(input.into());
            self
        }
        /// <p>The integration ID.</p>
        pub fn set_integration_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_integration_id(input);
            self
        }
        /// <p>Specifies the integration's HTTP method type.</p>
        pub fn integration_method(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.integration_method(input.into());
            self
        }
        /// <p>Specifies the integration's HTTP method type.</p>
        pub fn set_integration_method(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_integration_method(input);
            self
        }
        /// <p>Supported only for HTTP API AWS_PROXY integrations. Specifies the AWS service action to invoke. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html">Integration subtype reference</a>.</p>
        pub fn integration_subtype(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.integration_subtype(input.into());
            self
        }
        /// <p>Supported only for HTTP API AWS_PROXY integrations. Specifies the AWS service action to invoke. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html">Integration subtype reference</a>.</p>
        pub fn set_integration_subtype(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_integration_subtype(input);
            self
        }
        /// <p>The integration type of an integration. One of the following:</p>
        /// <p>AWS: for integrating the route or method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration. Supported only for WebSocket APIs.</p>
        /// <p>AWS_PROXY: for integrating the route or method request with a Lambda function or other AWS service action. This integration is also referred to as a Lambda proxy integration.</p>
        /// <p>HTTP: for integrating the route or method request with an HTTP endpoint. This integration is also referred to as the HTTP custom integration. Supported only for WebSocket APIs.</p>
        /// <p>HTTP_PROXY: for integrating the route or method request with an HTTP endpoint, with the client request passed through as-is. This is also referred to as HTTP proxy integration. For HTTP API private integrations, use an HTTP_PROXY integration.</p>
        /// <p>MOCK: for integrating the route or method request with API Gateway as a "loopback" endpoint without invoking any backend. Supported only for WebSocket APIs.</p>
        pub fn integration_type(mut self, input: crate::model::IntegrationType) -> Self {
            self.inner = self.inner.integration_type(input);
            self
        }
        /// <p>The integration type of an integration. One of the following:</p>
        /// <p>AWS: for integrating the route or method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration. Supported only for WebSocket APIs.</p>
        /// <p>AWS_PROXY: for integrating the route or method request with a Lambda function or other AWS service action. This integration is also referred to as a Lambda proxy integration.</p>
        /// <p>HTTP: for integrating the route or method request with an HTTP endpoint. This integration is also referred to as the HTTP custom integration. Supported only for WebSocket APIs.</p>
        /// <p>HTTP_PROXY: for integrating the route or method request with an HTTP endpoint, with the client request passed through as-is. This is also referred to as HTTP proxy integration. For HTTP API private integrations, use an HTTP_PROXY integration.</p>
        /// <p>MOCK: for integrating the route or method request with API Gateway as a "loopback" endpoint without invoking any backend. Supported only for WebSocket APIs.</p>
        pub fn set_integration_type(
            mut self,
            input: std::option::Option<crate::model::IntegrationType>,
        ) -> Self {
            self.inner = self.inner.set_integration_type(input);
            self
        }
        /// <p>For a Lambda integration, specify the URI of a Lambda function.</p>
        /// <p>For an HTTP integration, specify a fully-qualified URL.</p>
        /// <p>For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service. If you specify the ARN of an AWS Cloud Map service, API Gateway uses DiscoverInstances to identify resources. You can use query parameters to target specific resources. To learn more, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_DiscoverInstances.html">DiscoverInstances</a>. For private integrations, all resources must be owned by the same AWS account.</p>
        pub fn integration_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.integration_uri(input.into());
            self
        }
        /// <p>For a Lambda integration, specify the URI of a Lambda function.</p>
        /// <p>For an HTTP integration, specify a fully-qualified URL.</p>
        /// <p>For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service. If you specify the ARN of an AWS Cloud Map service, API Gateway uses DiscoverInstances to identify resources. You can use query parameters to target specific resources. To learn more, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_DiscoverInstances.html">DiscoverInstances</a>. For private integrations, all resources must be owned by the same AWS account.</p>
        pub fn set_integration_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_integration_uri(input);
            self
        }
        /// <p>Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER. Supported only for WebSocket APIs.</p>
        /// <p>WHEN_NO_MATCH passes the request body for unmapped content types through to the integration backend without transformation.</p>
        /// <p>NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type response.</p>
        /// <p>WHEN_NO_TEMPLATES allows pass-through when the integration has no content types mapped to templates. However, if there is at least one content type defined, unmapped content types will be rejected with the same HTTP 415 Unsupported Media Type response.</p>
        pub fn passthrough_behavior(mut self, input: crate::model::PassthroughBehavior) -> Self {
            self.inner = self.inner.passthrough_behavior(input);
            self
        }
        /// <p>Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER. Supported only for WebSocket APIs.</p>
        /// <p>WHEN_NO_MATCH passes the request body for unmapped content types through to the integration backend without transformation.</p>
        /// <p>NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type response.</p>
        /// <p>WHEN_NO_TEMPLATES allows pass-through when the integration has no content types mapped to templates. However, if there is at least one content type defined, unmapped content types will be rejected with the same HTTP 415 Unsupported Media Type response.</p>
        pub fn set_passthrough_behavior(
            mut self,
            input: std::option::Option<crate::model::PassthroughBehavior>,
        ) -> Self {
            self.inner = self.inner.set_passthrough_behavior(input);
            self
        }
        /// <p>Specifies the format of the payload sent to an integration. Required for HTTP APIs.</p>
        pub fn payload_format_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.payload_format_version(input.into());
            self
        }
        /// <p>Specifies the format of the payload sent to an integration. Required for HTTP APIs.</p>
        pub fn set_payload_format_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_payload_format_version(input);
            self
        }
        /// Adds a key-value pair to `RequestParameters`.
        ///
        /// To override the contents of this collection use [`set_request_parameters`](Self::set_request_parameters).
        ///
        /// <p>For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the backend. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the backend. The method request parameter value must match the pattern of method.request.<replaceable>
        /// {location}
        /// </replaceable>.<replaceable>
        /// {name}
        /// </replaceable> , where <replaceable>
        /// {location}
        /// </replaceable> is querystring, path, or header; and <replaceable>
        /// {name}
        /// </replaceable> must be a valid and unique method request parameter name.</p>
        /// <p>For HTTP API integrations with a specified integrationSubtype, request parameters are a key-value map specifying parameters that are passed to AWS_PROXY integrations. You can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services.html">Working with AWS service integrations for HTTP APIs</a>.</p>
        /// <p>For HTTP API integrations, without a specified integrationSubtype request parameters are a key-value map specifying how to transform HTTP requests before sending them to the backend. The key should follow the pattern &lt;action&gt;:&lt;header|querystring|path&gt;.&lt;location&gt; where action can be append, overwrite or remove. For values, you can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.">Transforming API requests and responses</a>.</p>
        pub fn request_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.request_parameters(k.into(), v.into());
            self
        }
        /// <p>For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the backend. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the backend. The method request parameter value must match the pattern of method.request.<replaceable>
        /// {location}
        /// </replaceable>.<replaceable>
        /// {name}
        /// </replaceable> , where <replaceable>
        /// {location}
        /// </replaceable> is querystring, path, or header; and <replaceable>
        /// {name}
        /// </replaceable> must be a valid and unique method request parameter name.</p>
        /// <p>For HTTP API integrations with a specified integrationSubtype, request parameters are a key-value map specifying parameters that are passed to AWS_PROXY integrations. You can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services.html">Working with AWS service integrations for HTTP APIs</a>.</p>
        /// <p>For HTTP API integrations, without a specified integrationSubtype request parameters are a key-value map specifying how to transform HTTP requests before sending them to the backend. The key should follow the pattern &lt;action&gt;:&lt;header|querystring|path&gt;.&lt;location&gt; where action can be append, overwrite or remove. For values, you can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.">Transforming API requests and responses</a>.</p>
        pub fn set_request_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_request_parameters(input);
            self
        }
        /// Adds a key-value pair to `RequestTemplates`.
        ///
        /// To override the contents of this collection use [`set_request_templates`](Self::set_request_templates).
        ///
        /// <p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value. Supported only for WebSocket APIs.</p>
        pub fn request_templates(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.request_templates(k.into(), v.into());
            self
        }
        /// <p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value. Supported only for WebSocket APIs.</p>
        pub fn set_request_templates(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_request_templates(input);
            self
        }
        /// Adds a key-value pair to `ResponseParameters`.
        ///
        /// To override the contents of this collection use [`set_response_parameters`](Self::set_response_parameters).
        ///
        /// <p>Supported only for HTTP APIs. You use response parameters to transform the HTTP response from a backend integration before returning the response to clients. Specify a key-value map from a selection key to response parameters. The selection key must be a valid HTTP status code within the range of 200-599. Response parameters are a key-value map. The key must match pattern &lt;action&gt;:&lt;header&gt;.&lt;location&gt; or overwrite.statuscode. The action can be append, overwrite or remove. The value can be a static value, or map to response data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
        pub fn response_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: std::collections::HashMap<std::string::String, std::string::String>,
        ) -> Self {
            self.inner = self.inner.response_parameters(k.into(), v);
            self
        }
        /// <p>Supported only for HTTP APIs. You use response parameters to transform the HTTP response from a backend integration before returning the response to clients. Specify a key-value map from a selection key to response parameters. The selection key must be a valid HTTP status code within the range of 200-599. Response parameters are a key-value map. The key must match pattern &lt;action&gt;:&lt;header&gt;.&lt;location&gt; or overwrite.statuscode. The action can be append, overwrite or remove. The value can be a static value, or map to response data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
        pub fn set_response_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    std::collections::HashMap<std::string::String, std::string::String>,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_response_parameters(input);
            self
        }
        /// <p>The template selection expression for the integration.</p>
        pub fn template_selection_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.template_selection_expression(input.into());
            self
        }
        /// <p>The template selection expression for the integration.</p>
        pub fn set_template_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_selection_expression(input);
            self
        }
        /// <p>Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs. The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.</p>
        pub fn timeout_in_millis(mut self, input: i32) -> Self {
            self.inner = self.inner.timeout_in_millis(input);
            self
        }
        /// <p>Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs. The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.</p>
        pub fn set_timeout_in_millis(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_timeout_in_millis(input);
            self
        }
        /// <p>The TLS configuration for a private integration. If you specify a TLS configuration, private integration traffic uses the HTTPS protocol. Supported only for HTTP APIs.</p>
        pub fn tls_config(mut self, input: crate::model::TlsConfigInput) -> Self {
            self.inner = self.inner.tls_config(input);
            self
        }
        /// <p>The TLS configuration for a private integration. If you specify a TLS configuration, private integration traffic uses the HTTPS protocol. Supported only for HTTP APIs.</p>
        pub fn set_tls_config(
            mut self,
            input: std::option::Option<crate::model::TlsConfigInput>,
        ) -> Self {
            self.inner = self.inner.set_tls_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateIntegrationResponse`.
    ///
    /// <p>Updates an IntegrationResponses.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateIntegrationResponse {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_integration_response_input::Builder,
    }
    impl UpdateIntegrationResponse {
        /// Creates a new `UpdateIntegrationResponse`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateIntegrationResponseOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateIntegrationResponseError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p>
        /// <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p>
        /// <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p>
        /// <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
        pub fn content_handling_strategy(
            mut self,
            input: crate::model::ContentHandlingStrategy,
        ) -> Self {
            self.inner = self.inner.content_handling_strategy(input);
            self
        }
        /// <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p>
        /// <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p>
        /// <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p>
        /// <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
        pub fn set_content_handling_strategy(
            mut self,
            input: std::option::Option<crate::model::ContentHandlingStrategy>,
        ) -> Self {
            self.inner = self.inner.set_content_handling_strategy(input);
            self
        }
        /// <p>The integration ID.</p>
        pub fn integration_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.integration_id(input.into());
            self
        }
        /// <p>The integration ID.</p>
        pub fn set_integration_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_integration_id(input);
            self
        }
        /// <p>The integration response ID.</p>
        pub fn integration_response_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.integration_response_id(input.into());
            self
        }
        /// <p>The integration response ID.</p>
        pub fn set_integration_response_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_integration_response_id(input);
            self
        }
        /// <p>The integration response key.</p>
        pub fn integration_response_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.integration_response_key(input.into());
            self
        }
        /// <p>The integration response key.</p>
        pub fn set_integration_response_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_integration_response_key(input);
            self
        }
        /// Adds a key-value pair to `ResponseParameters`.
        ///
        /// To override the contents of this collection use [`set_response_parameters`](Self::set_response_parameters).
        ///
        /// <p>A key-value map specifying response parameters that are passed to the method response from the backend. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of method.response.header.<replaceable>
        /// {name}
        /// </replaceable> , where name is a valid and unique header name. The mapped non-static value must match the pattern of integration.response.header.<replaceable>
        /// {name}
        /// </replaceable> or integration.response.body.<replaceable>
        /// {JSON-expression}
        /// </replaceable> , where <replaceable>
        /// {name}
        /// </replaceable> is a valid and unique response header name and <replaceable>
        /// {JSON-expression}
        /// </replaceable> is a valid JSON expression without the $ prefix.</p>
        pub fn response_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.response_parameters(k.into(), v.into());
            self
        }
        /// <p>A key-value map specifying response parameters that are passed to the method response from the backend. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of method.response.header.<replaceable>
        /// {name}
        /// </replaceable> , where name is a valid and unique header name. The mapped non-static value must match the pattern of integration.response.header.<replaceable>
        /// {name}
        /// </replaceable> or integration.response.body.<replaceable>
        /// {JSON-expression}
        /// </replaceable> , where <replaceable>
        /// {name}
        /// </replaceable> is a valid and unique response header name and <replaceable>
        /// {JSON-expression}
        /// </replaceable> is a valid JSON expression without the $ prefix.</p>
        pub fn set_response_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_response_parameters(input);
            self
        }
        /// Adds a key-value pair to `ResponseTemplates`.
        ///
        /// To override the contents of this collection use [`set_response_templates`](Self::set_response_templates).
        ///
        /// <p>The collection of response templates for the integration response as a string-to-string map of key-value pairs. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.</p>
        pub fn response_templates(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.response_templates(k.into(), v.into());
            self
        }
        /// <p>The collection of response templates for the integration response as a string-to-string map of key-value pairs. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.</p>
        pub fn set_response_templates(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_response_templates(input);
            self
        }
        /// <p>The template selection expression for the integration response. Supported only for WebSocket APIs.</p>
        pub fn template_selection_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.template_selection_expression(input.into());
            self
        }
        /// <p>The template selection expression for the integration response. Supported only for WebSocket APIs.</p>
        pub fn set_template_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_selection_expression(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateModel`.
    ///
    /// <p>Updates a Model.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateModel {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_model_input::Builder,
    }
    impl UpdateModel {
        /// Creates a new `UpdateModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateModelOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateModelError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The content-type for the model, for example, "application/json".</p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content_type(input.into());
            self
        }
        /// <p>The content-type for the model, for example, "application/json".</p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content_type(input);
            self
        }
        /// <p>The description of the model.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the model.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The model ID.</p>
        pub fn model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_id(input.into());
            self
        }
        /// <p>The model ID.</p>
        pub fn set_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_model_id(input);
            self
        }
        /// <p>The name of the model.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the model.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The schema for the model. For application/json models, this should be JSON schema draft 4 model.</p>
        pub fn schema(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema(input.into());
            self
        }
        /// <p>The schema for the model. For application/json models, this should be JSON schema draft 4 model.</p>
        pub fn set_schema(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schema(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRoute`.
    ///
    /// <p>Updates a Route.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateRoute {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_route_input::Builder,
    }
    impl UpdateRoute {
        /// Creates a new `UpdateRoute`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRouteOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRouteError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>Specifies whether an API key is required for the route. Supported only for WebSocket APIs.</p>
        pub fn api_key_required(mut self, input: bool) -> Self {
            self.inner = self.inner.api_key_required(input);
            self
        }
        /// <p>Specifies whether an API key is required for the route. Supported only for WebSocket APIs.</p>
        pub fn set_api_key_required(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_api_key_required(input);
            self
        }
        /// Appends an item to `AuthorizationScopes`.
        ///
        /// To override the contents of this collection use [`set_authorization_scopes`](Self::set_authorization_scopes).
        ///
        /// <p>The authorization scopes supported by this route.</p>
        pub fn authorization_scopes(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authorization_scopes(input.into());
            self
        }
        /// <p>The authorization scopes supported by this route.</p>
        pub fn set_authorization_scopes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_authorization_scopes(input);
            self
        }
        /// <p>The authorization type for the route. For WebSocket APIs, valid values are NONE for open access, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer For HTTP APIs, valid values are NONE for open access, JWT for using JSON Web Tokens, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer.</p>
        pub fn authorization_type(mut self, input: crate::model::AuthorizationType) -> Self {
            self.inner = self.inner.authorization_type(input);
            self
        }
        /// <p>The authorization type for the route. For WebSocket APIs, valid values are NONE for open access, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer For HTTP APIs, valid values are NONE for open access, JWT for using JSON Web Tokens, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer.</p>
        pub fn set_authorization_type(
            mut self,
            input: std::option::Option<crate::model::AuthorizationType>,
        ) -> Self {
            self.inner = self.inner.set_authorization_type(input);
            self
        }
        /// <p>The identifier of the Authorizer resource to be associated with this route. The authorizer identifier is generated by API Gateway when you created the authorizer.</p>
        pub fn authorizer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authorizer_id(input.into());
            self
        }
        /// <p>The identifier of the Authorizer resource to be associated with this route. The authorizer identifier is generated by API Gateway when you created the authorizer.</p>
        pub fn set_authorizer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authorizer_id(input);
            self
        }
        /// <p>The model selection expression for the route. Supported only for WebSocket APIs.</p>
        pub fn model_selection_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_selection_expression(input.into());
            self
        }
        /// <p>The model selection expression for the route. Supported only for WebSocket APIs.</p>
        pub fn set_model_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_model_selection_expression(input);
            self
        }
        /// <p>The operation name for the route.</p>
        pub fn operation_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.operation_name(input.into());
            self
        }
        /// <p>The operation name for the route.</p>
        pub fn set_operation_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_operation_name(input);
            self
        }
        /// Adds a key-value pair to `RequestModels`.
        ///
        /// To override the contents of this collection use [`set_request_models`](Self::set_request_models).
        ///
        /// <p>The request models for the route. Supported only for WebSocket APIs.</p>
        pub fn request_models(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.request_models(k.into(), v.into());
            self
        }
        /// <p>The request models for the route. Supported only for WebSocket APIs.</p>
        pub fn set_request_models(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_request_models(input);
            self
        }
        /// Adds a key-value pair to `RequestParameters`.
        ///
        /// To override the contents of this collection use [`set_request_parameters`](Self::set_request_parameters).
        ///
        /// <p>The request parameters for the route. Supported only for WebSocket APIs.</p>
        pub fn request_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::ParameterConstraints,
        ) -> Self {
            self.inner = self.inner.request_parameters(k.into(), v);
            self
        }
        /// <p>The request parameters for the route. Supported only for WebSocket APIs.</p>
        pub fn set_request_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::ParameterConstraints>,
            >,
        ) -> Self {
            self.inner = self.inner.set_request_parameters(input);
            self
        }
        /// <p>The route ID.</p>
        pub fn route_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.route_id(input.into());
            self
        }
        /// <p>The route ID.</p>
        pub fn set_route_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_route_id(input);
            self
        }
        /// <p>The route key for the route.</p>
        pub fn route_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.route_key(input.into());
            self
        }
        /// <p>The route key for the route.</p>
        pub fn set_route_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_route_key(input);
            self
        }
        /// <p>The route response selection expression for the route. Supported only for WebSocket APIs.</p>
        pub fn route_response_selection_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.route_response_selection_expression(input.into());
            self
        }
        /// <p>The route response selection expression for the route. Supported only for WebSocket APIs.</p>
        pub fn set_route_response_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_route_response_selection_expression(input);
            self
        }
        /// <p>The target for the route.</p>
        pub fn target(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target(input.into());
            self
        }
        /// <p>The target for the route.</p>
        pub fn set_target(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_target(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRouteResponse`.
    ///
    /// <p>Updates a RouteResponse.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateRouteResponse {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_route_response_input::Builder,
    }
    impl UpdateRouteResponse {
        /// Creates a new `UpdateRouteResponse`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRouteResponseOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRouteResponseError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The model selection expression for the route response. Supported only for WebSocket APIs.</p>
        pub fn model_selection_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_selection_expression(input.into());
            self
        }
        /// <p>The model selection expression for the route response. Supported only for WebSocket APIs.</p>
        pub fn set_model_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_model_selection_expression(input);
            self
        }
        /// Adds a key-value pair to `ResponseModels`.
        ///
        /// To override the contents of this collection use [`set_response_models`](Self::set_response_models).
        ///
        /// <p>The response models for the route response.</p>
        pub fn response_models(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.response_models(k.into(), v.into());
            self
        }
        /// <p>The response models for the route response.</p>
        pub fn set_response_models(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_response_models(input);
            self
        }
        /// Adds a key-value pair to `ResponseParameters`.
        ///
        /// To override the contents of this collection use [`set_response_parameters`](Self::set_response_parameters).
        ///
        /// <p>The route response parameters.</p>
        pub fn response_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::ParameterConstraints,
        ) -> Self {
            self.inner = self.inner.response_parameters(k.into(), v);
            self
        }
        /// <p>The route response parameters.</p>
        pub fn set_response_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::ParameterConstraints>,
            >,
        ) -> Self {
            self.inner = self.inner.set_response_parameters(input);
            self
        }
        /// <p>The route ID.</p>
        pub fn route_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.route_id(input.into());
            self
        }
        /// <p>The route ID.</p>
        pub fn set_route_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_route_id(input);
            self
        }
        /// <p>The route response ID.</p>
        pub fn route_response_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.route_response_id(input.into());
            self
        }
        /// <p>The route response ID.</p>
        pub fn set_route_response_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_route_response_id(input);
            self
        }
        /// <p>The route response key.</p>
        pub fn route_response_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.route_response_key(input.into());
            self
        }
        /// <p>The route response key.</p>
        pub fn set_route_response_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_route_response_key(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateStage`.
    ///
    /// <p>Updates a Stage.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateStage {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_stage_input::Builder,
    }
    impl UpdateStage {
        /// Creates a new `UpdateStage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateStageOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateStageError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Settings for logging access in this stage.</p>
        pub fn access_log_settings(mut self, input: crate::model::AccessLogSettings) -> Self {
            self.inner = self.inner.access_log_settings(input);
            self
        }
        /// <p>Settings for logging access in this stage.</p>
        pub fn set_access_log_settings(
            mut self,
            input: std::option::Option<crate::model::AccessLogSettings>,
        ) -> Self {
            self.inner = self.inner.set_access_log_settings(input);
            self
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>Specifies whether updates to an API automatically trigger a new deployment. The default value is false.</p>
        pub fn auto_deploy(mut self, input: bool) -> Self {
            self.inner = self.inner.auto_deploy(input);
            self
        }
        /// <p>Specifies whether updates to an API automatically trigger a new deployment. The default value is false.</p>
        pub fn set_auto_deploy(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_deploy(input);
            self
        }
        /// <p>The identifier of a client certificate for a Stage.</p>
        pub fn client_certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_certificate_id(input.into());
            self
        }
        /// <p>The identifier of a client certificate for a Stage.</p>
        pub fn set_client_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_certificate_id(input);
            self
        }
        /// <p>The default route settings for the stage.</p>
        pub fn default_route_settings(mut self, input: crate::model::RouteSettings) -> Self {
            self.inner = self.inner.default_route_settings(input);
            self
        }
        /// <p>The default route settings for the stage.</p>
        pub fn set_default_route_settings(
            mut self,
            input: std::option::Option<crate::model::RouteSettings>,
        ) -> Self {
            self.inner = self.inner.set_default_route_settings(input);
            self
        }
        /// <p>The deployment identifier for the API stage. Can't be updated if autoDeploy is enabled.</p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_id(input.into());
            self
        }
        /// <p>The deployment identifier for the API stage. Can't be updated if autoDeploy is enabled.</p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_id(input);
            self
        }
        /// <p>The description for the API stage.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description for the API stage.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Adds a key-value pair to `RouteSettings`.
        ///
        /// To override the contents of this collection use [`set_route_settings`](Self::set_route_settings).
        ///
        /// <p>Route settings for the stage.</p>
        pub fn route_settings(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::RouteSettings,
        ) -> Self {
            self.inner = self.inner.route_settings(k.into(), v);
            self
        }
        /// <p>Route settings for the stage.</p>
        pub fn set_route_settings(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::RouteSettings>,
            >,
        ) -> Self {
            self.inner = self.inner.set_route_settings(input);
            self
        }
        /// <p>The stage name. Stage names can contain only alphanumeric characters, hyphens, and underscores, or be $default. Maximum length is 128 characters.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stage_name(input.into());
            self
        }
        /// <p>The stage name. Stage names can contain only alphanumeric characters, hyphens, and underscores, or be $default. Maximum length is 128 characters.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stage_name(input);
            self
        }
        /// Adds a key-value pair to `StageVariables`.
        ///
        /// To override the contents of this collection use [`set_stage_variables`](Self::set_stage_variables).
        ///
        /// <p>A map that defines the stage variables for a Stage. Variable names can have alphanumeric and underscore characters, and the values must match [A-Za-z0-9-._~:/?#&amp;=,]+.</p>
        pub fn stage_variables(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.stage_variables(k.into(), v.into());
            self
        }
        /// <p>A map that defines the stage variables for a Stage. Variable names can have alphanumeric and underscore characters, and the values must match [A-Za-z0-9-._~:/?#&amp;=,]+.</p>
        pub fn set_stage_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_stage_variables(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateVpcLink`.
    ///
    /// <p>Updates a VPC link.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateVpcLink {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_vpc_link_input::Builder,
    }
    impl UpdateVpcLink {
        /// Creates a new `UpdateVpcLink`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateVpcLinkOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateVpcLinkError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the VPC link.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the VPC link.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The ID of the VPC link.</p>
        pub fn vpc_link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_link_id(input.into());
            self
        }
        /// <p>The ID of the VPC link.</p>
        pub fn set_vpc_link_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_vpc_link_id(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
