// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_api_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateApiOutput, crate::error::CreateApiError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateApiError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateApiError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::CreateApiError {
            meta: generic,
            kind: crate::error::CreateApiErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateApiError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::CreateApiError {
                meta: generic,
                kind: crate::error::CreateApiErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateApiError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "NotFoundException" => crate::error::CreateApiError {
            meta: generic,
            kind: crate::error::CreateApiErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateApiError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::CreateApiError {
            meta: generic,
            kind: crate::error::CreateApiErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateApiError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateApiError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_api_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateApiOutput, crate::error::CreateApiError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_api_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_api(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateApiError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_api_mapping_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateApiMappingOutput, crate::error::CreateApiMappingError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateApiMappingError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateApiMappingError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::CreateApiMappingError {
            meta: generic,
            kind: crate::error::CreateApiMappingErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateApiMappingError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::CreateApiMappingError {
                meta: generic,
                kind: crate::error::CreateApiMappingErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateApiMappingError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "NotFoundException" => crate::error::CreateApiMappingError {
            meta: generic,
            kind: crate::error::CreateApiMappingErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateApiMappingError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::CreateApiMappingError {
            meta: generic,
            kind: crate::error::CreateApiMappingErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateApiMappingError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateApiMappingError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_api_mapping_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateApiMappingOutput, crate::error::CreateApiMappingError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_api_mapping_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_api_mapping(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateApiMappingError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_authorizer_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateAuthorizerOutput, crate::error::CreateAuthorizerError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateAuthorizerError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateAuthorizerError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::CreateAuthorizerError {
            meta: generic,
            kind: crate::error::CreateAuthorizerErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateAuthorizerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::CreateAuthorizerError {
                meta: generic,
                kind: crate::error::CreateAuthorizerErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateAuthorizerError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "NotFoundException" => crate::error::CreateAuthorizerError {
            meta: generic,
            kind: crate::error::CreateAuthorizerErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateAuthorizerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::CreateAuthorizerError {
            meta: generic,
            kind: crate::error::CreateAuthorizerErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateAuthorizerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateAuthorizerError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_authorizer_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateAuthorizerOutput, crate::error::CreateAuthorizerError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_authorizer_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_authorizer(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateAuthorizerError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_deployment_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateDeploymentOutput, crate::error::CreateDeploymentError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateDeploymentError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateDeploymentError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::CreateDeploymentError {
            meta: generic,
            kind: crate::error::CreateDeploymentErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDeploymentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::CreateDeploymentError {
                meta: generic,
                kind: crate::error::CreateDeploymentErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDeploymentError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "NotFoundException" => crate::error::CreateDeploymentError {
            meta: generic,
            kind: crate::error::CreateDeploymentErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDeploymentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::CreateDeploymentError {
            meta: generic,
            kind: crate::error::CreateDeploymentErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDeploymentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateDeploymentError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_deployment_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateDeploymentOutput, crate::error::CreateDeploymentError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_deployment_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_deployment(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateDeploymentError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_domain_name_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateDomainNameOutput, crate::error::CreateDomainNameError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateDomainNameError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateDomainNameError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::CreateDomainNameError {
            meta: generic,
            kind: crate::error::CreateDomainNameErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDomainNameError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "BadRequestException" => crate::error::CreateDomainNameError {
            meta: generic,
            kind: crate::error::CreateDomainNameErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDomainNameError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::CreateDomainNameError {
                meta: generic,
                kind: crate::error::CreateDomainNameErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDomainNameError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "NotFoundException" => crate::error::CreateDomainNameError {
            meta: generic,
            kind: crate::error::CreateDomainNameErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDomainNameError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::CreateDomainNameError {
            meta: generic,
            kind: crate::error::CreateDomainNameErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDomainNameError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateDomainNameError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_domain_name_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateDomainNameOutput, crate::error::CreateDomainNameError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_domain_name_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_domain_name(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateDomainNameError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_integration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateIntegrationOutput, crate::error::CreateIntegrationError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateIntegrationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateIntegrationError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::CreateIntegrationError {
            meta: generic,
            kind: crate::error::CreateIntegrationErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateIntegrationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::CreateIntegrationError {
                meta: generic,
                kind: crate::error::CreateIntegrationErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateIntegrationError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "NotFoundException" => crate::error::CreateIntegrationError {
            meta: generic,
            kind: crate::error::CreateIntegrationErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateIntegrationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::CreateIntegrationError {
            meta: generic,
            kind: crate::error::CreateIntegrationErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateIntegrationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateIntegrationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_integration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateIntegrationOutput, crate::error::CreateIntegrationError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_integration_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_integration(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateIntegrationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_integration_response_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateIntegrationResponseOutput,
    crate::error::CreateIntegrationResponseError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateIntegrationResponseError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateIntegrationResponseError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::CreateIntegrationResponseError {
            meta: generic,
            kind: crate::error::CreateIntegrationResponseErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateIntegrationResponseError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::CreateIntegrationResponseError {
                meta: generic,
                kind: crate::error::CreateIntegrationResponseErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateIntegrationResponseError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "NotFoundException" => crate::error::CreateIntegrationResponseError {
            meta: generic,
            kind: crate::error::CreateIntegrationResponseErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateIntegrationResponseError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::CreateIntegrationResponseError {
            meta: generic,
            kind: crate::error::CreateIntegrationResponseErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateIntegrationResponseError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateIntegrationResponseError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_integration_response_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateIntegrationResponseOutput,
    crate::error::CreateIntegrationResponseError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_integration_response_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_integration_response(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateIntegrationResponseError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_model_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateModelOutput, crate::error::CreateModelError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateModelError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateModelError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::CreateModelError {
            meta: generic,
            kind: crate::error::CreateModelErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateModelError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::CreateModelError {
                meta: generic,
                kind: crate::error::CreateModelErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateModelError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "NotFoundException" => crate::error::CreateModelError {
            meta: generic,
            kind: crate::error::CreateModelErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateModelError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::CreateModelError {
            meta: generic,
            kind: crate::error::CreateModelErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateModelError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateModelError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_model_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateModelOutput, crate::error::CreateModelError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_model_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_model(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateModelError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_route_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateRouteOutput, crate::error::CreateRouteError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateRouteError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateRouteError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::CreateRouteError {
            meta: generic,
            kind: crate::error::CreateRouteErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRouteError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::CreateRouteError {
                meta: generic,
                kind: crate::error::CreateRouteErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRouteError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "NotFoundException" => crate::error::CreateRouteError {
            meta: generic,
            kind: crate::error::CreateRouteErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRouteError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::CreateRouteError {
            meta: generic,
            kind: crate::error::CreateRouteErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRouteError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateRouteError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_route_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateRouteOutput, crate::error::CreateRouteError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_route_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_route(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateRouteError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_route_response_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateRouteResponseOutput,
    crate::error::CreateRouteResponseError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateRouteResponseError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateRouteResponseError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::CreateRouteResponseError {
            meta: generic,
            kind: crate::error::CreateRouteResponseErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRouteResponseError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::CreateRouteResponseError {
                meta: generic,
                kind: crate::error::CreateRouteResponseErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRouteResponseError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "NotFoundException" => crate::error::CreateRouteResponseError {
            meta: generic,
            kind: crate::error::CreateRouteResponseErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRouteResponseError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::CreateRouteResponseError {
            meta: generic,
            kind: crate::error::CreateRouteResponseErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRouteResponseError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateRouteResponseError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_route_response_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateRouteResponseOutput,
    crate::error::CreateRouteResponseError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_route_response_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_route_response(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateRouteResponseError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_stage_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateStageOutput, crate::error::CreateStageError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateStageError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateStageError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::CreateStageError {
            meta: generic,
            kind: crate::error::CreateStageErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateStageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::CreateStageError {
                meta: generic,
                kind: crate::error::CreateStageErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateStageError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "NotFoundException" => crate::error::CreateStageError {
            meta: generic,
            kind: crate::error::CreateStageErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateStageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::CreateStageError {
            meta: generic,
            kind: crate::error::CreateStageErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateStageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateStageError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_stage_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateStageOutput, crate::error::CreateStageError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_stage_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_stage(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateStageError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_vpc_link_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateVpcLinkOutput, crate::error::CreateVpcLinkError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateVpcLinkError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateVpcLinkError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::CreateVpcLinkError {
            meta: generic,
            kind: crate::error::CreateVpcLinkErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateVpcLinkError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::CreateVpcLinkError {
            meta: generic,
            kind: crate::error::CreateVpcLinkErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateVpcLinkError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateVpcLinkError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_vpc_link_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateVpcLinkOutput, crate::error::CreateVpcLinkError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_vpc_link_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_vpc_link(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateVpcLinkError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_access_log_settings_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteAccessLogSettingsOutput,
    crate::error::DeleteAccessLogSettingsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteAccessLogSettingsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteAccessLogSettingsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NotFoundException" => crate::error::DeleteAccessLogSettingsError {
            meta: generic,
            kind: crate::error::DeleteAccessLogSettingsErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAccessLogSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::DeleteAccessLogSettingsError {
            meta: generic,
            kind: crate::error::DeleteAccessLogSettingsErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAccessLogSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteAccessLogSettingsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_access_log_settings_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteAccessLogSettingsOutput,
    crate::error::DeleteAccessLogSettingsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_access_log_settings_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_api_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteApiOutput, crate::error::DeleteApiError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteApiError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteApiError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NotFoundException" => crate::error::DeleteApiError {
            meta: generic,
            kind: crate::error::DeleteApiErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteApiError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::DeleteApiError {
            meta: generic,
            kind: crate::error::DeleteApiErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteApiError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteApiError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_api_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteApiOutput, crate::error::DeleteApiError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_api_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_api_mapping_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteApiMappingOutput, crate::error::DeleteApiMappingError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteApiMappingError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteApiMappingError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::DeleteApiMappingError {
            meta: generic,
            kind: crate::error::DeleteApiMappingErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteApiMappingError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::DeleteApiMappingError {
            meta: generic,
            kind: crate::error::DeleteApiMappingErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteApiMappingError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::DeleteApiMappingError {
            meta: generic,
            kind: crate::error::DeleteApiMappingErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteApiMappingError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteApiMappingError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_api_mapping_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteApiMappingOutput, crate::error::DeleteApiMappingError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_api_mapping_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_authorizer_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteAuthorizerOutput, crate::error::DeleteAuthorizerError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteAuthorizerError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteAuthorizerError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NotFoundException" => crate::error::DeleteAuthorizerError {
            meta: generic,
            kind: crate::error::DeleteAuthorizerErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAuthorizerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::DeleteAuthorizerError {
            meta: generic,
            kind: crate::error::DeleteAuthorizerErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAuthorizerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteAuthorizerError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_authorizer_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteAuthorizerOutput, crate::error::DeleteAuthorizerError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_authorizer_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_cors_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteCorsConfigurationOutput,
    crate::error::DeleteCorsConfigurationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteCorsConfigurationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteCorsConfigurationError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NotFoundException" => crate::error::DeleteCorsConfigurationError {
            meta: generic,
            kind: crate::error::DeleteCorsConfigurationErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteCorsConfigurationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::DeleteCorsConfigurationError {
            meta: generic,
            kind: crate::error::DeleteCorsConfigurationErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteCorsConfigurationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteCorsConfigurationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_cors_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteCorsConfigurationOutput,
    crate::error::DeleteCorsConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_cors_configuration_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_deployment_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteDeploymentOutput, crate::error::DeleteDeploymentError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteDeploymentError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteDeploymentError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NotFoundException" => crate::error::DeleteDeploymentError {
            meta: generic,
            kind: crate::error::DeleteDeploymentErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteDeploymentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::DeleteDeploymentError {
            meta: generic,
            kind: crate::error::DeleteDeploymentErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteDeploymentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteDeploymentError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_deployment_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteDeploymentOutput, crate::error::DeleteDeploymentError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_deployment_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_domain_name_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteDomainNameOutput, crate::error::DeleteDomainNameError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteDomainNameError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteDomainNameError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NotFoundException" => crate::error::DeleteDomainNameError {
            meta: generic,
            kind: crate::error::DeleteDomainNameErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteDomainNameError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::DeleteDomainNameError {
            meta: generic,
            kind: crate::error::DeleteDomainNameErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteDomainNameError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteDomainNameError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_domain_name_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteDomainNameOutput, crate::error::DeleteDomainNameError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_domain_name_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_integration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteIntegrationOutput, crate::error::DeleteIntegrationError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteIntegrationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteIntegrationError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NotFoundException" => crate::error::DeleteIntegrationError {
            meta: generic,
            kind: crate::error::DeleteIntegrationErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteIntegrationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::DeleteIntegrationError {
            meta: generic,
            kind: crate::error::DeleteIntegrationErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteIntegrationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteIntegrationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_integration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteIntegrationOutput, crate::error::DeleteIntegrationError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_integration_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_integration_response_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteIntegrationResponseOutput,
    crate::error::DeleteIntegrationResponseError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteIntegrationResponseError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteIntegrationResponseError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NotFoundException" => crate::error::DeleteIntegrationResponseError {
            meta: generic,
            kind: crate::error::DeleteIntegrationResponseErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteIntegrationResponseError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::DeleteIntegrationResponseError {
            meta: generic,
            kind: crate::error::DeleteIntegrationResponseErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteIntegrationResponseError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteIntegrationResponseError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_integration_response_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteIntegrationResponseOutput,
    crate::error::DeleteIntegrationResponseError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_integration_response_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_model_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteModelOutput, crate::error::DeleteModelError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteModelError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteModelError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NotFoundException" => crate::error::DeleteModelError {
            meta: generic,
            kind: crate::error::DeleteModelErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteModelError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::DeleteModelError {
            meta: generic,
            kind: crate::error::DeleteModelErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteModelError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteModelError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_model_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteModelOutput, crate::error::DeleteModelError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_model_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_route_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteRouteOutput, crate::error::DeleteRouteError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteRouteError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteRouteError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NotFoundException" => crate::error::DeleteRouteError {
            meta: generic,
            kind: crate::error::DeleteRouteErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRouteError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::DeleteRouteError {
            meta: generic,
            kind: crate::error::DeleteRouteErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRouteError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteRouteError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_route_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteRouteOutput, crate::error::DeleteRouteError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_route_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_route_request_parameter_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteRouteRequestParameterOutput,
    crate::error::DeleteRouteRequestParameterError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteRouteRequestParameterError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteRouteRequestParameterError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NotFoundException" => crate::error::DeleteRouteRequestParameterError {
            meta: generic,
            kind: crate::error::DeleteRouteRequestParameterErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRouteRequestParameterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::DeleteRouteRequestParameterError {
            meta: generic,
            kind: crate::error::DeleteRouteRequestParameterErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRouteRequestParameterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteRouteRequestParameterError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_route_request_parameter_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteRouteRequestParameterOutput,
    crate::error::DeleteRouteRequestParameterError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_route_request_parameter_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_route_response_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteRouteResponseOutput,
    crate::error::DeleteRouteResponseError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteRouteResponseError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteRouteResponseError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NotFoundException" => crate::error::DeleteRouteResponseError {
            meta: generic,
            kind: crate::error::DeleteRouteResponseErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRouteResponseError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::DeleteRouteResponseError {
            meta: generic,
            kind: crate::error::DeleteRouteResponseErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRouteResponseError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteRouteResponseError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_route_response_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteRouteResponseOutput,
    crate::error::DeleteRouteResponseError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_route_response_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_route_settings_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteRouteSettingsOutput,
    crate::error::DeleteRouteSettingsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteRouteSettingsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteRouteSettingsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NotFoundException" => crate::error::DeleteRouteSettingsError {
            meta: generic,
            kind: crate::error::DeleteRouteSettingsErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRouteSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::DeleteRouteSettingsError {
            meta: generic,
            kind: crate::error::DeleteRouteSettingsErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRouteSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteRouteSettingsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_route_settings_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteRouteSettingsOutput,
    crate::error::DeleteRouteSettingsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_route_settings_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_stage_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteStageOutput, crate::error::DeleteStageError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteStageError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteStageError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NotFoundException" => crate::error::DeleteStageError {
            meta: generic,
            kind: crate::error::DeleteStageErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteStageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::DeleteStageError {
            meta: generic,
            kind: crate::error::DeleteStageErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteStageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteStageError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_stage_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteStageOutput, crate::error::DeleteStageError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_stage_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_vpc_link_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteVpcLinkOutput, crate::error::DeleteVpcLinkError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteVpcLinkError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteVpcLinkError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NotFoundException" => crate::error::DeleteVpcLinkError {
            meta: generic,
            kind: crate::error::DeleteVpcLinkErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteVpcLinkError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::DeleteVpcLinkError {
            meta: generic,
            kind: crate::error::DeleteVpcLinkErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteVpcLinkError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteVpcLinkError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_vpc_link_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteVpcLinkOutput, crate::error::DeleteVpcLinkError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_vpc_link_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_export_api_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ExportApiOutput, crate::error::ExportApiError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ExportApiError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ExportApiError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::ExportApiError {
            meta: generic,
            kind: crate::error::ExportApiErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ExportApiError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::ExportApiError {
            meta: generic,
            kind: crate::error::ExportApiErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ExportApiError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::ExportApiError {
            meta: generic,
            kind: crate::error::ExportApiErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ExportApiError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ExportApiError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_export_api_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ExportApiOutput, crate::error::ExportApiError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::export_api_output::Builder::default();
        let _ = response;
        output = output.set_body(
            crate::http_serde::deser_payload_export_api_export_api_output_body(
                response.body().as_ref(),
            )?,
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_api_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetApiOutput, crate::error::GetApiError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetApiError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetApiError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NotFoundException" => crate::error::GetApiError {
            meta: generic,
            kind: crate::error::GetApiErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetApiError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::GetApiError {
            meta: generic,
            kind: crate::error::GetApiErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetApiError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetApiError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_api_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetApiOutput, crate::error::GetApiError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_api_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_api(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetApiError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_api_mapping_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetApiMappingOutput, crate::error::GetApiMappingError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetApiMappingError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetApiMappingError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::GetApiMappingError {
            meta: generic,
            kind: crate::error::GetApiMappingErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetApiMappingError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetApiMappingError {
            meta: generic,
            kind: crate::error::GetApiMappingErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetApiMappingError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::GetApiMappingError {
            meta: generic,
            kind: crate::error::GetApiMappingErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetApiMappingError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetApiMappingError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_api_mapping_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetApiMappingOutput, crate::error::GetApiMappingError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_api_mapping_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_api_mapping(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetApiMappingError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_api_mappings_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetApiMappingsOutput, crate::error::GetApiMappingsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetApiMappingsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetApiMappingsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::GetApiMappingsError {
            meta: generic,
            kind: crate::error::GetApiMappingsErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetApiMappingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetApiMappingsError {
            meta: generic,
            kind: crate::error::GetApiMappingsErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetApiMappingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::GetApiMappingsError {
            meta: generic,
            kind: crate::error::GetApiMappingsErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetApiMappingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetApiMappingsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_api_mappings_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetApiMappingsOutput, crate::error::GetApiMappingsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_api_mappings_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_api_mappings(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetApiMappingsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_apis_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetApisOutput, crate::error::GetApisError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetApisError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetApisError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::GetApisError {
            meta: generic,
            kind: crate::error::GetApisErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetApisError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetApisError {
            meta: generic,
            kind: crate::error::GetApisErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetApisError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::GetApisError {
            meta: generic,
            kind: crate::error::GetApisErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetApisError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetApisError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_apis_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetApisOutput, crate::error::GetApisError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_apis_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_apis(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetApisError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_authorizer_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetAuthorizerOutput, crate::error::GetAuthorizerError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetAuthorizerError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetAuthorizerError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NotFoundException" => crate::error::GetAuthorizerError {
            meta: generic,
            kind: crate::error::GetAuthorizerErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetAuthorizerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::GetAuthorizerError {
            meta: generic,
            kind: crate::error::GetAuthorizerErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetAuthorizerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetAuthorizerError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_authorizer_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetAuthorizerOutput, crate::error::GetAuthorizerError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_authorizer_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_authorizer(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetAuthorizerError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_authorizers_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetAuthorizersOutput, crate::error::GetAuthorizersError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetAuthorizersError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetAuthorizersError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::GetAuthorizersError {
            meta: generic,
            kind: crate::error::GetAuthorizersErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetAuthorizersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetAuthorizersError {
            meta: generic,
            kind: crate::error::GetAuthorizersErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetAuthorizersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::GetAuthorizersError {
            meta: generic,
            kind: crate::error::GetAuthorizersErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetAuthorizersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetAuthorizersError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_authorizers_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetAuthorizersOutput, crate::error::GetAuthorizersError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_authorizers_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_authorizers(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetAuthorizersError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_deployment_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetDeploymentOutput, crate::error::GetDeploymentError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetDeploymentError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetDeploymentError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NotFoundException" => crate::error::GetDeploymentError {
            meta: generic,
            kind: crate::error::GetDeploymentErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDeploymentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::GetDeploymentError {
            meta: generic,
            kind: crate::error::GetDeploymentErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDeploymentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetDeploymentError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_deployment_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetDeploymentOutput, crate::error::GetDeploymentError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_deployment_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_deployment(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetDeploymentError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_deployments_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetDeploymentsOutput, crate::error::GetDeploymentsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetDeploymentsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetDeploymentsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::GetDeploymentsError {
            meta: generic,
            kind: crate::error::GetDeploymentsErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDeploymentsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetDeploymentsError {
            meta: generic,
            kind: crate::error::GetDeploymentsErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDeploymentsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::GetDeploymentsError {
            meta: generic,
            kind: crate::error::GetDeploymentsErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDeploymentsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetDeploymentsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_deployments_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetDeploymentsOutput, crate::error::GetDeploymentsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_deployments_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_deployments(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetDeploymentsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_domain_name_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetDomainNameOutput, crate::error::GetDomainNameError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetDomainNameError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetDomainNameError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NotFoundException" => crate::error::GetDomainNameError {
            meta: generic,
            kind: crate::error::GetDomainNameErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDomainNameError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::GetDomainNameError {
            meta: generic,
            kind: crate::error::GetDomainNameErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDomainNameError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetDomainNameError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_domain_name_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetDomainNameOutput, crate::error::GetDomainNameError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_domain_name_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_domain_name(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetDomainNameError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_domain_names_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetDomainNamesOutput, crate::error::GetDomainNamesError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetDomainNamesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetDomainNamesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::GetDomainNamesError {
            meta: generic,
            kind: crate::error::GetDomainNamesErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDomainNamesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetDomainNamesError {
            meta: generic,
            kind: crate::error::GetDomainNamesErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDomainNamesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::GetDomainNamesError {
            meta: generic,
            kind: crate::error::GetDomainNamesErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDomainNamesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetDomainNamesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_domain_names_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetDomainNamesOutput, crate::error::GetDomainNamesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_domain_names_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_domain_names(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetDomainNamesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_integration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetIntegrationOutput, crate::error::GetIntegrationError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetIntegrationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetIntegrationError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NotFoundException" => crate::error::GetIntegrationError {
            meta: generic,
            kind: crate::error::GetIntegrationErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetIntegrationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::GetIntegrationError {
            meta: generic,
            kind: crate::error::GetIntegrationErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetIntegrationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetIntegrationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_integration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetIntegrationOutput, crate::error::GetIntegrationError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_integration_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_integration(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetIntegrationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_integration_response_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetIntegrationResponseOutput,
    crate::error::GetIntegrationResponseError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetIntegrationResponseError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetIntegrationResponseError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NotFoundException" => crate::error::GetIntegrationResponseError {
            meta: generic,
            kind: crate::error::GetIntegrationResponseErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetIntegrationResponseError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::GetIntegrationResponseError {
            meta: generic,
            kind: crate::error::GetIntegrationResponseErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetIntegrationResponseError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetIntegrationResponseError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_integration_response_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetIntegrationResponseOutput,
    crate::error::GetIntegrationResponseError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_integration_response_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_integration_response(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetIntegrationResponseError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_integration_responses_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetIntegrationResponsesOutput,
    crate::error::GetIntegrationResponsesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetIntegrationResponsesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetIntegrationResponsesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::GetIntegrationResponsesError {
            meta: generic,
            kind: crate::error::GetIntegrationResponsesErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetIntegrationResponsesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetIntegrationResponsesError {
            meta: generic,
            kind: crate::error::GetIntegrationResponsesErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetIntegrationResponsesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::GetIntegrationResponsesError {
            meta: generic,
            kind: crate::error::GetIntegrationResponsesErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetIntegrationResponsesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetIntegrationResponsesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_integration_responses_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetIntegrationResponsesOutput,
    crate::error::GetIntegrationResponsesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_integration_responses_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_integration_responses(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetIntegrationResponsesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_integrations_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetIntegrationsOutput, crate::error::GetIntegrationsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetIntegrationsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetIntegrationsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::GetIntegrationsError {
            meta: generic,
            kind: crate::error::GetIntegrationsErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetIntegrationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetIntegrationsError {
            meta: generic,
            kind: crate::error::GetIntegrationsErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetIntegrationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::GetIntegrationsError {
            meta: generic,
            kind: crate::error::GetIntegrationsErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetIntegrationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetIntegrationsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_integrations_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetIntegrationsOutput, crate::error::GetIntegrationsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_integrations_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_integrations(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetIntegrationsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_model_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetModelOutput, crate::error::GetModelError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetModelError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetModelError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NotFoundException" => crate::error::GetModelError {
            meta: generic,
            kind: crate::error::GetModelErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetModelError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::GetModelError {
            meta: generic,
            kind: crate::error::GetModelErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetModelError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetModelError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_model_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetModelOutput, crate::error::GetModelError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_model_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_model(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetModelError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_models_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetModelsOutput, crate::error::GetModelsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetModelsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetModelsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::GetModelsError {
            meta: generic,
            kind: crate::error::GetModelsErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetModelsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetModelsError {
            meta: generic,
            kind: crate::error::GetModelsErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetModelsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::GetModelsError {
            meta: generic,
            kind: crate::error::GetModelsErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetModelsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetModelsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_models_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetModelsOutput, crate::error::GetModelsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_models_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_models(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetModelsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_model_template_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetModelTemplateOutput, crate::error::GetModelTemplateError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetModelTemplateError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetModelTemplateError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NotFoundException" => crate::error::GetModelTemplateError {
            meta: generic,
            kind: crate::error::GetModelTemplateErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetModelTemplateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::GetModelTemplateError {
            meta: generic,
            kind: crate::error::GetModelTemplateErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetModelTemplateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetModelTemplateError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_model_template_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetModelTemplateOutput, crate::error::GetModelTemplateError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_model_template_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_model_template(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetModelTemplateError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_route_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetRouteOutput, crate::error::GetRouteError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetRouteError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetRouteError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NotFoundException" => crate::error::GetRouteError {
            meta: generic,
            kind: crate::error::GetRouteErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRouteError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::GetRouteError {
            meta: generic,
            kind: crate::error::GetRouteErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRouteError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetRouteError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_route_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetRouteOutput, crate::error::GetRouteError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_route_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_route(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetRouteError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_route_response_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetRouteResponseOutput, crate::error::GetRouteResponseError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetRouteResponseError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetRouteResponseError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NotFoundException" => crate::error::GetRouteResponseError {
            meta: generic,
            kind: crate::error::GetRouteResponseErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRouteResponseError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::GetRouteResponseError {
            meta: generic,
            kind: crate::error::GetRouteResponseErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRouteResponseError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetRouteResponseError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_route_response_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetRouteResponseOutput, crate::error::GetRouteResponseError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_route_response_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_route_response(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetRouteResponseError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_route_responses_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetRouteResponsesOutput, crate::error::GetRouteResponsesError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetRouteResponsesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetRouteResponsesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::GetRouteResponsesError {
            meta: generic,
            kind: crate::error::GetRouteResponsesErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRouteResponsesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetRouteResponsesError {
            meta: generic,
            kind: crate::error::GetRouteResponsesErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRouteResponsesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::GetRouteResponsesError {
            meta: generic,
            kind: crate::error::GetRouteResponsesErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRouteResponsesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetRouteResponsesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_route_responses_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetRouteResponsesOutput, crate::error::GetRouteResponsesError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_route_responses_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_route_responses(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetRouteResponsesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_routes_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetRoutesOutput, crate::error::GetRoutesError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetRoutesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetRoutesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::GetRoutesError {
            meta: generic,
            kind: crate::error::GetRoutesErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRoutesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetRoutesError {
            meta: generic,
            kind: crate::error::GetRoutesErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRoutesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::GetRoutesError {
            meta: generic,
            kind: crate::error::GetRoutesErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRoutesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetRoutesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_routes_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetRoutesOutput, crate::error::GetRoutesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_routes_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_routes(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetRoutesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_stage_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetStageOutput, crate::error::GetStageError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetStageError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetStageError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NotFoundException" => crate::error::GetStageError {
            meta: generic,
            kind: crate::error::GetStageErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetStageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::GetStageError {
            meta: generic,
            kind: crate::error::GetStageErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetStageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetStageError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_stage_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetStageOutput, crate::error::GetStageError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_stage_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_stage(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetStageError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_stages_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetStagesOutput, crate::error::GetStagesError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetStagesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetStagesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::GetStagesError {
            meta: generic,
            kind: crate::error::GetStagesErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetStagesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetStagesError {
            meta: generic,
            kind: crate::error::GetStagesErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetStagesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::GetStagesError {
            meta: generic,
            kind: crate::error::GetStagesErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetStagesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetStagesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_stages_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetStagesOutput, crate::error::GetStagesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_stages_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_stages(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetStagesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_tags_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetTagsOutput, crate::error::GetTagsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetTagsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetTagsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::GetTagsError {
            meta: generic,
            kind: crate::error::GetTagsErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::GetTagsError {
                meta: generic,
                kind: crate::error::GetTagsErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetTagsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "NotFoundException" => crate::error::GetTagsError {
            meta: generic,
            kind: crate::error::GetTagsErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::GetTagsError {
            meta: generic,
            kind: crate::error::GetTagsErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetTagsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_tags_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetTagsOutput, crate::error::GetTagsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_tags_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_tags(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetTagsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_vpc_link_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetVpcLinkOutput, crate::error::GetVpcLinkError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetVpcLinkError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetVpcLinkError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NotFoundException" => crate::error::GetVpcLinkError {
            meta: generic,
            kind: crate::error::GetVpcLinkErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetVpcLinkError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::GetVpcLinkError {
            meta: generic,
            kind: crate::error::GetVpcLinkErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetVpcLinkError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetVpcLinkError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_vpc_link_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetVpcLinkOutput, crate::error::GetVpcLinkError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_vpc_link_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_vpc_link(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetVpcLinkError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_vpc_links_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetVpcLinksOutput, crate::error::GetVpcLinksError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetVpcLinksError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetVpcLinksError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::GetVpcLinksError {
            meta: generic,
            kind: crate::error::GetVpcLinksErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetVpcLinksError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::GetVpcLinksError {
            meta: generic,
            kind: crate::error::GetVpcLinksErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetVpcLinksError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetVpcLinksError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_vpc_links_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetVpcLinksOutput, crate::error::GetVpcLinksError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_vpc_links_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_vpc_links(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetVpcLinksError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_import_api_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ImportApiOutput, crate::error::ImportApiError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ImportApiError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ImportApiError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::ImportApiError {
            meta: generic,
            kind: crate::error::ImportApiErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ImportApiError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::ImportApiError {
                meta: generic,
                kind: crate::error::ImportApiErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ImportApiError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "NotFoundException" => crate::error::ImportApiError {
            meta: generic,
            kind: crate::error::ImportApiErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ImportApiError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::ImportApiError {
            meta: generic,
            kind: crate::error::ImportApiErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ImportApiError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ImportApiError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_import_api_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ImportApiOutput, crate::error::ImportApiError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::import_api_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_import_api(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ImportApiError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_reimport_api_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ReimportApiOutput, crate::error::ReimportApiError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ReimportApiError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ReimportApiError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::ReimportApiError {
            meta: generic,
            kind: crate::error::ReimportApiErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ReimportApiError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::ReimportApiError {
                meta: generic,
                kind: crate::error::ReimportApiErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ReimportApiError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "NotFoundException" => crate::error::ReimportApiError {
            meta: generic,
            kind: crate::error::ReimportApiErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ReimportApiError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::ReimportApiError {
            meta: generic,
            kind: crate::error::ReimportApiErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ReimportApiError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ReimportApiError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_reimport_api_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ReimportApiOutput, crate::error::ReimportApiError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::reimport_api_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_reimport_api(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ReimportApiError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_reset_authorizers_cache_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ResetAuthorizersCacheOutput,
    crate::error::ResetAuthorizersCacheError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ResetAuthorizersCacheError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ResetAuthorizersCacheError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NotFoundException" => crate::error::ResetAuthorizersCacheError {
            meta: generic,
            kind: crate::error::ResetAuthorizersCacheErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ResetAuthorizersCacheError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::ResetAuthorizersCacheError {
            meta: generic,
            kind: crate::error::ResetAuthorizersCacheErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ResetAuthorizersCacheError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ResetAuthorizersCacheError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_reset_authorizers_cache_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ResetAuthorizersCacheOutput,
    crate::error::ResetAuthorizersCacheError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::reset_authorizers_cache_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::TagResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::TagResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::TagResourceError {
                meta: generic,
                kind: crate::error::TagResourceErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "NotFoundException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::TagResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::tag_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UntagResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UntagResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::UntagResourceError {
                meta: generic,
                kind: crate::error::UntagResourceErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "NotFoundException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UntagResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::untag_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_api_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateApiOutput, crate::error::UpdateApiError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateApiError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateApiError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::UpdateApiError {
            meta: generic,
            kind: crate::error::UpdateApiErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateApiError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::UpdateApiError {
                meta: generic,
                kind: crate::error::UpdateApiErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateApiError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "NotFoundException" => crate::error::UpdateApiError {
            meta: generic,
            kind: crate::error::UpdateApiErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateApiError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::UpdateApiError {
            meta: generic,
            kind: crate::error::UpdateApiErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateApiError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateApiError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_api_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateApiOutput, crate::error::UpdateApiError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_api_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_api(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateApiError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_api_mapping_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateApiMappingOutput, crate::error::UpdateApiMappingError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateApiMappingError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateApiMappingError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::UpdateApiMappingError {
            meta: generic,
            kind: crate::error::UpdateApiMappingErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateApiMappingError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::UpdateApiMappingError {
                meta: generic,
                kind: crate::error::UpdateApiMappingErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateApiMappingError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "NotFoundException" => crate::error::UpdateApiMappingError {
            meta: generic,
            kind: crate::error::UpdateApiMappingErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateApiMappingError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::UpdateApiMappingError {
            meta: generic,
            kind: crate::error::UpdateApiMappingErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateApiMappingError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateApiMappingError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_api_mapping_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateApiMappingOutput, crate::error::UpdateApiMappingError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_api_mapping_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_api_mapping(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateApiMappingError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_authorizer_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateAuthorizerOutput, crate::error::UpdateAuthorizerError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateAuthorizerError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateAuthorizerError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::UpdateAuthorizerError {
            meta: generic,
            kind: crate::error::UpdateAuthorizerErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateAuthorizerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::UpdateAuthorizerError {
                meta: generic,
                kind: crate::error::UpdateAuthorizerErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateAuthorizerError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "NotFoundException" => crate::error::UpdateAuthorizerError {
            meta: generic,
            kind: crate::error::UpdateAuthorizerErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateAuthorizerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::UpdateAuthorizerError {
            meta: generic,
            kind: crate::error::UpdateAuthorizerErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateAuthorizerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateAuthorizerError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_authorizer_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateAuthorizerOutput, crate::error::UpdateAuthorizerError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_authorizer_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_authorizer(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateAuthorizerError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_deployment_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateDeploymentOutput, crate::error::UpdateDeploymentError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateDeploymentError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateDeploymentError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::UpdateDeploymentError {
            meta: generic,
            kind: crate::error::UpdateDeploymentErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateDeploymentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::UpdateDeploymentError {
                meta: generic,
                kind: crate::error::UpdateDeploymentErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateDeploymentError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "NotFoundException" => crate::error::UpdateDeploymentError {
            meta: generic,
            kind: crate::error::UpdateDeploymentErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateDeploymentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::UpdateDeploymentError {
            meta: generic,
            kind: crate::error::UpdateDeploymentErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateDeploymentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateDeploymentError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_deployment_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateDeploymentOutput, crate::error::UpdateDeploymentError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_deployment_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_deployment(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateDeploymentError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_domain_name_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateDomainNameOutput, crate::error::UpdateDomainNameError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateDomainNameError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateDomainNameError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::UpdateDomainNameError {
            meta: generic,
            kind: crate::error::UpdateDomainNameErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateDomainNameError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::UpdateDomainNameError {
                meta: generic,
                kind: crate::error::UpdateDomainNameErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateDomainNameError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "NotFoundException" => crate::error::UpdateDomainNameError {
            meta: generic,
            kind: crate::error::UpdateDomainNameErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateDomainNameError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::UpdateDomainNameError {
            meta: generic,
            kind: crate::error::UpdateDomainNameErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateDomainNameError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateDomainNameError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_domain_name_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateDomainNameOutput, crate::error::UpdateDomainNameError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_domain_name_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_domain_name(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateDomainNameError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_integration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateIntegrationOutput, crate::error::UpdateIntegrationError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateIntegrationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateIntegrationError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::UpdateIntegrationError {
            meta: generic,
            kind: crate::error::UpdateIntegrationErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateIntegrationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::UpdateIntegrationError {
                meta: generic,
                kind: crate::error::UpdateIntegrationErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateIntegrationError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "NotFoundException" => crate::error::UpdateIntegrationError {
            meta: generic,
            kind: crate::error::UpdateIntegrationErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateIntegrationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::UpdateIntegrationError {
            meta: generic,
            kind: crate::error::UpdateIntegrationErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateIntegrationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateIntegrationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_integration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateIntegrationOutput, crate::error::UpdateIntegrationError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_integration_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_integration(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateIntegrationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_integration_response_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateIntegrationResponseOutput,
    crate::error::UpdateIntegrationResponseError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateIntegrationResponseError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateIntegrationResponseError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::UpdateIntegrationResponseError {
            meta: generic,
            kind: crate::error::UpdateIntegrationResponseErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateIntegrationResponseError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::UpdateIntegrationResponseError {
                meta: generic,
                kind: crate::error::UpdateIntegrationResponseErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateIntegrationResponseError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "NotFoundException" => crate::error::UpdateIntegrationResponseError {
            meta: generic,
            kind: crate::error::UpdateIntegrationResponseErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateIntegrationResponseError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::UpdateIntegrationResponseError {
            meta: generic,
            kind: crate::error::UpdateIntegrationResponseErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateIntegrationResponseError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateIntegrationResponseError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_integration_response_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateIntegrationResponseOutput,
    crate::error::UpdateIntegrationResponseError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_integration_response_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_integration_response(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateIntegrationResponseError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_model_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateModelOutput, crate::error::UpdateModelError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateModelError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateModelError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::UpdateModelError {
            meta: generic,
            kind: crate::error::UpdateModelErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateModelError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::UpdateModelError {
                meta: generic,
                kind: crate::error::UpdateModelErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateModelError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "NotFoundException" => crate::error::UpdateModelError {
            meta: generic,
            kind: crate::error::UpdateModelErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateModelError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::UpdateModelError {
            meta: generic,
            kind: crate::error::UpdateModelErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateModelError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateModelError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_model_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateModelOutput, crate::error::UpdateModelError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_model_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_model(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateModelError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_route_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateRouteOutput, crate::error::UpdateRouteError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateRouteError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateRouteError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::UpdateRouteError {
            meta: generic,
            kind: crate::error::UpdateRouteErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRouteError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::UpdateRouteError {
                meta: generic,
                kind: crate::error::UpdateRouteErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRouteError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "NotFoundException" => crate::error::UpdateRouteError {
            meta: generic,
            kind: crate::error::UpdateRouteErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRouteError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::UpdateRouteError {
            meta: generic,
            kind: crate::error::UpdateRouteErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRouteError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateRouteError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_route_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateRouteOutput, crate::error::UpdateRouteError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_route_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_route(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateRouteError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_route_response_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateRouteResponseOutput,
    crate::error::UpdateRouteResponseError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateRouteResponseError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateRouteResponseError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::UpdateRouteResponseError {
            meta: generic,
            kind: crate::error::UpdateRouteResponseErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRouteResponseError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::UpdateRouteResponseError {
                meta: generic,
                kind: crate::error::UpdateRouteResponseErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRouteResponseError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "NotFoundException" => crate::error::UpdateRouteResponseError {
            meta: generic,
            kind: crate::error::UpdateRouteResponseErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRouteResponseError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::UpdateRouteResponseError {
            meta: generic,
            kind: crate::error::UpdateRouteResponseErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRouteResponseError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateRouteResponseError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_route_response_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateRouteResponseOutput,
    crate::error::UpdateRouteResponseError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_route_response_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_route_response(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateRouteResponseError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_stage_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateStageOutput, crate::error::UpdateStageError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateStageError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateStageError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::UpdateStageError {
            meta: generic,
            kind: crate::error::UpdateStageErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateStageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::UpdateStageError {
                meta: generic,
                kind: crate::error::UpdateStageErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateStageError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "NotFoundException" => crate::error::UpdateStageError {
            meta: generic,
            kind: crate::error::UpdateStageErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateStageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::UpdateStageError {
            meta: generic,
            kind: crate::error::UpdateStageErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateStageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateStageError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_stage_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateStageOutput, crate::error::UpdateStageError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_stage_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_stage(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateStageError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_vpc_link_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateVpcLinkOutput, crate::error::UpdateVpcLinkError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateVpcLinkError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateVpcLinkError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::UpdateVpcLinkError {
            meta: generic,
            kind: crate::error::UpdateVpcLinkErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateVpcLinkError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::UpdateVpcLinkError {
            meta: generic,
            kind: crate::error::UpdateVpcLinkErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateVpcLinkError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::UpdateVpcLinkError {
            meta: generic,
            kind: crate::error::UpdateVpcLinkErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateVpcLinkError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateVpcLinkError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_vpc_link_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateVpcLinkOutput, crate::error::UpdateVpcLinkError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_vpc_link_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_vpc_link(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateVpcLinkError::unhandled)?;
        output.build()
    })
}
