// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for AmazonApiGatewayV2
///
/// Client for invoking operations on AmazonApiGatewayV2. Each operation on AmazonApiGatewayV2 is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_apigatewayv2::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_apigatewayv2::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_apigatewayv2::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `CreateApi` operation.
    ///
    /// See [`CreateApi`](crate::client::fluent_builders::CreateApi) for more information about the
    /// operation and its arguments.
    pub fn create_api(&self) -> fluent_builders::CreateApi<C, M, R> {
        fluent_builders::CreateApi::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateApiMapping` operation.
    ///
    /// See [`CreateApiMapping`](crate::client::fluent_builders::CreateApiMapping) for more information about the
    /// operation and its arguments.
    pub fn create_api_mapping(&self) -> fluent_builders::CreateApiMapping<C, M, R> {
        fluent_builders::CreateApiMapping::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateAuthorizer` operation.
    ///
    /// See [`CreateAuthorizer`](crate::client::fluent_builders::CreateAuthorizer) for more information about the
    /// operation and its arguments.
    pub fn create_authorizer(&self) -> fluent_builders::CreateAuthorizer<C, M, R> {
        fluent_builders::CreateAuthorizer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDeployment` operation.
    ///
    /// See [`CreateDeployment`](crate::client::fluent_builders::CreateDeployment) for more information about the
    /// operation and its arguments.
    pub fn create_deployment(&self) -> fluent_builders::CreateDeployment<C, M, R> {
        fluent_builders::CreateDeployment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDomainName` operation.
    ///
    /// See [`CreateDomainName`](crate::client::fluent_builders::CreateDomainName) for more information about the
    /// operation and its arguments.
    pub fn create_domain_name(&self) -> fluent_builders::CreateDomainName<C, M, R> {
        fluent_builders::CreateDomainName::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateIntegration` operation.
    ///
    /// See [`CreateIntegration`](crate::client::fluent_builders::CreateIntegration) for more information about the
    /// operation and its arguments.
    pub fn create_integration(&self) -> fluent_builders::CreateIntegration<C, M, R> {
        fluent_builders::CreateIntegration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateIntegrationResponse` operation.
    ///
    /// See [`CreateIntegrationResponse`](crate::client::fluent_builders::CreateIntegrationResponse) for more information about the
    /// operation and its arguments.
    pub fn create_integration_response(
        &self,
    ) -> fluent_builders::CreateIntegrationResponse<C, M, R> {
        fluent_builders::CreateIntegrationResponse::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateModel` operation.
    ///
    /// See [`CreateModel`](crate::client::fluent_builders::CreateModel) for more information about the
    /// operation and its arguments.
    pub fn create_model(&self) -> fluent_builders::CreateModel<C, M, R> {
        fluent_builders::CreateModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateRoute` operation.
    ///
    /// See [`CreateRoute`](crate::client::fluent_builders::CreateRoute) for more information about the
    /// operation and its arguments.
    pub fn create_route(&self) -> fluent_builders::CreateRoute<C, M, R> {
        fluent_builders::CreateRoute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateRouteResponse` operation.
    ///
    /// See [`CreateRouteResponse`](crate::client::fluent_builders::CreateRouteResponse) for more information about the
    /// operation and its arguments.
    pub fn create_route_response(&self) -> fluent_builders::CreateRouteResponse<C, M, R> {
        fluent_builders::CreateRouteResponse::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateStage` operation.
    ///
    /// See [`CreateStage`](crate::client::fluent_builders::CreateStage) for more information about the
    /// operation and its arguments.
    pub fn create_stage(&self) -> fluent_builders::CreateStage<C, M, R> {
        fluent_builders::CreateStage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateVpcLink` operation.
    ///
    /// See [`CreateVpcLink`](crate::client::fluent_builders::CreateVpcLink) for more information about the
    /// operation and its arguments.
    pub fn create_vpc_link(&self) -> fluent_builders::CreateVpcLink<C, M, R> {
        fluent_builders::CreateVpcLink::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAccessLogSettings` operation.
    ///
    /// See [`DeleteAccessLogSettings`](crate::client::fluent_builders::DeleteAccessLogSettings) for more information about the
    /// operation and its arguments.
    pub fn delete_access_log_settings(&self) -> fluent_builders::DeleteAccessLogSettings<C, M, R> {
        fluent_builders::DeleteAccessLogSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteApi` operation.
    ///
    /// See [`DeleteApi`](crate::client::fluent_builders::DeleteApi) for more information about the
    /// operation and its arguments.
    pub fn delete_api(&self) -> fluent_builders::DeleteApi<C, M, R> {
        fluent_builders::DeleteApi::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteApiMapping` operation.
    ///
    /// See [`DeleteApiMapping`](crate::client::fluent_builders::DeleteApiMapping) for more information about the
    /// operation and its arguments.
    pub fn delete_api_mapping(&self) -> fluent_builders::DeleteApiMapping<C, M, R> {
        fluent_builders::DeleteApiMapping::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAuthorizer` operation.
    ///
    /// See [`DeleteAuthorizer`](crate::client::fluent_builders::DeleteAuthorizer) for more information about the
    /// operation and its arguments.
    pub fn delete_authorizer(&self) -> fluent_builders::DeleteAuthorizer<C, M, R> {
        fluent_builders::DeleteAuthorizer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteCorsConfiguration` operation.
    ///
    /// See [`DeleteCorsConfiguration`](crate::client::fluent_builders::DeleteCorsConfiguration) for more information about the
    /// operation and its arguments.
    pub fn delete_cors_configuration(&self) -> fluent_builders::DeleteCorsConfiguration<C, M, R> {
        fluent_builders::DeleteCorsConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDeployment` operation.
    ///
    /// See [`DeleteDeployment`](crate::client::fluent_builders::DeleteDeployment) for more information about the
    /// operation and its arguments.
    pub fn delete_deployment(&self) -> fluent_builders::DeleteDeployment<C, M, R> {
        fluent_builders::DeleteDeployment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDomainName` operation.
    ///
    /// See [`DeleteDomainName`](crate::client::fluent_builders::DeleteDomainName) for more information about the
    /// operation and its arguments.
    pub fn delete_domain_name(&self) -> fluent_builders::DeleteDomainName<C, M, R> {
        fluent_builders::DeleteDomainName::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteIntegration` operation.
    ///
    /// See [`DeleteIntegration`](crate::client::fluent_builders::DeleteIntegration) for more information about the
    /// operation and its arguments.
    pub fn delete_integration(&self) -> fluent_builders::DeleteIntegration<C, M, R> {
        fluent_builders::DeleteIntegration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteIntegrationResponse` operation.
    ///
    /// See [`DeleteIntegrationResponse`](crate::client::fluent_builders::DeleteIntegrationResponse) for more information about the
    /// operation and its arguments.
    pub fn delete_integration_response(
        &self,
    ) -> fluent_builders::DeleteIntegrationResponse<C, M, R> {
        fluent_builders::DeleteIntegrationResponse::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteModel` operation.
    ///
    /// See [`DeleteModel`](crate::client::fluent_builders::DeleteModel) for more information about the
    /// operation and its arguments.
    pub fn delete_model(&self) -> fluent_builders::DeleteModel<C, M, R> {
        fluent_builders::DeleteModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRoute` operation.
    ///
    /// See [`DeleteRoute`](crate::client::fluent_builders::DeleteRoute) for more information about the
    /// operation and its arguments.
    pub fn delete_route(&self) -> fluent_builders::DeleteRoute<C, M, R> {
        fluent_builders::DeleteRoute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRouteRequestParameter` operation.
    ///
    /// See [`DeleteRouteRequestParameter`](crate::client::fluent_builders::DeleteRouteRequestParameter) for more information about the
    /// operation and its arguments.
    pub fn delete_route_request_parameter(
        &self,
    ) -> fluent_builders::DeleteRouteRequestParameter<C, M, R> {
        fluent_builders::DeleteRouteRequestParameter::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRouteResponse` operation.
    ///
    /// See [`DeleteRouteResponse`](crate::client::fluent_builders::DeleteRouteResponse) for more information about the
    /// operation and its arguments.
    pub fn delete_route_response(&self) -> fluent_builders::DeleteRouteResponse<C, M, R> {
        fluent_builders::DeleteRouteResponse::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRouteSettings` operation.
    ///
    /// See [`DeleteRouteSettings`](crate::client::fluent_builders::DeleteRouteSettings) for more information about the
    /// operation and its arguments.
    pub fn delete_route_settings(&self) -> fluent_builders::DeleteRouteSettings<C, M, R> {
        fluent_builders::DeleteRouteSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteStage` operation.
    ///
    /// See [`DeleteStage`](crate::client::fluent_builders::DeleteStage) for more information about the
    /// operation and its arguments.
    pub fn delete_stage(&self) -> fluent_builders::DeleteStage<C, M, R> {
        fluent_builders::DeleteStage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteVpcLink` operation.
    ///
    /// See [`DeleteVpcLink`](crate::client::fluent_builders::DeleteVpcLink) for more information about the
    /// operation and its arguments.
    pub fn delete_vpc_link(&self) -> fluent_builders::DeleteVpcLink<C, M, R> {
        fluent_builders::DeleteVpcLink::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ExportApi` operation.
    ///
    /// See [`ExportApi`](crate::client::fluent_builders::ExportApi) for more information about the
    /// operation and its arguments.
    pub fn export_api(&self) -> fluent_builders::ExportApi<C, M, R> {
        fluent_builders::ExportApi::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetApi` operation.
    ///
    /// See [`GetApi`](crate::client::fluent_builders::GetApi) for more information about the
    /// operation and its arguments.
    pub fn get_api(&self) -> fluent_builders::GetApi<C, M, R> {
        fluent_builders::GetApi::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetApiMapping` operation.
    ///
    /// See [`GetApiMapping`](crate::client::fluent_builders::GetApiMapping) for more information about the
    /// operation and its arguments.
    pub fn get_api_mapping(&self) -> fluent_builders::GetApiMapping<C, M, R> {
        fluent_builders::GetApiMapping::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetApiMappings` operation.
    ///
    /// See [`GetApiMappings`](crate::client::fluent_builders::GetApiMappings) for more information about the
    /// operation and its arguments.
    pub fn get_api_mappings(&self) -> fluent_builders::GetApiMappings<C, M, R> {
        fluent_builders::GetApiMappings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetApis` operation.
    ///
    /// See [`GetApis`](crate::client::fluent_builders::GetApis) for more information about the
    /// operation and its arguments.
    pub fn get_apis(&self) -> fluent_builders::GetApis<C, M, R> {
        fluent_builders::GetApis::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAuthorizer` operation.
    ///
    /// See [`GetAuthorizer`](crate::client::fluent_builders::GetAuthorizer) for more information about the
    /// operation and its arguments.
    pub fn get_authorizer(&self) -> fluent_builders::GetAuthorizer<C, M, R> {
        fluent_builders::GetAuthorizer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAuthorizers` operation.
    ///
    /// See [`GetAuthorizers`](crate::client::fluent_builders::GetAuthorizers) for more information about the
    /// operation and its arguments.
    pub fn get_authorizers(&self) -> fluent_builders::GetAuthorizers<C, M, R> {
        fluent_builders::GetAuthorizers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDeployment` operation.
    ///
    /// See [`GetDeployment`](crate::client::fluent_builders::GetDeployment) for more information about the
    /// operation and its arguments.
    pub fn get_deployment(&self) -> fluent_builders::GetDeployment<C, M, R> {
        fluent_builders::GetDeployment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDeployments` operation.
    ///
    /// See [`GetDeployments`](crate::client::fluent_builders::GetDeployments) for more information about the
    /// operation and its arguments.
    pub fn get_deployments(&self) -> fluent_builders::GetDeployments<C, M, R> {
        fluent_builders::GetDeployments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDomainName` operation.
    ///
    /// See [`GetDomainName`](crate::client::fluent_builders::GetDomainName) for more information about the
    /// operation and its arguments.
    pub fn get_domain_name(&self) -> fluent_builders::GetDomainName<C, M, R> {
        fluent_builders::GetDomainName::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDomainNames` operation.
    ///
    /// See [`GetDomainNames`](crate::client::fluent_builders::GetDomainNames) for more information about the
    /// operation and its arguments.
    pub fn get_domain_names(&self) -> fluent_builders::GetDomainNames<C, M, R> {
        fluent_builders::GetDomainNames::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetIntegration` operation.
    ///
    /// See [`GetIntegration`](crate::client::fluent_builders::GetIntegration) for more information about the
    /// operation and its arguments.
    pub fn get_integration(&self) -> fluent_builders::GetIntegration<C, M, R> {
        fluent_builders::GetIntegration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetIntegrationResponse` operation.
    ///
    /// See [`GetIntegrationResponse`](crate::client::fluent_builders::GetIntegrationResponse) for more information about the
    /// operation and its arguments.
    pub fn get_integration_response(&self) -> fluent_builders::GetIntegrationResponse<C, M, R> {
        fluent_builders::GetIntegrationResponse::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetIntegrationResponses` operation.
    ///
    /// See [`GetIntegrationResponses`](crate::client::fluent_builders::GetIntegrationResponses) for more information about the
    /// operation and its arguments.
    pub fn get_integration_responses(&self) -> fluent_builders::GetIntegrationResponses<C, M, R> {
        fluent_builders::GetIntegrationResponses::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetIntegrations` operation.
    ///
    /// See [`GetIntegrations`](crate::client::fluent_builders::GetIntegrations) for more information about the
    /// operation and its arguments.
    pub fn get_integrations(&self) -> fluent_builders::GetIntegrations<C, M, R> {
        fluent_builders::GetIntegrations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetModel` operation.
    ///
    /// See [`GetModel`](crate::client::fluent_builders::GetModel) for more information about the
    /// operation and its arguments.
    pub fn get_model(&self) -> fluent_builders::GetModel<C, M, R> {
        fluent_builders::GetModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetModels` operation.
    ///
    /// See [`GetModels`](crate::client::fluent_builders::GetModels) for more information about the
    /// operation and its arguments.
    pub fn get_models(&self) -> fluent_builders::GetModels<C, M, R> {
        fluent_builders::GetModels::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetModelTemplate` operation.
    ///
    /// See [`GetModelTemplate`](crate::client::fluent_builders::GetModelTemplate) for more information about the
    /// operation and its arguments.
    pub fn get_model_template(&self) -> fluent_builders::GetModelTemplate<C, M, R> {
        fluent_builders::GetModelTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRoute` operation.
    ///
    /// See [`GetRoute`](crate::client::fluent_builders::GetRoute) for more information about the
    /// operation and its arguments.
    pub fn get_route(&self) -> fluent_builders::GetRoute<C, M, R> {
        fluent_builders::GetRoute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRouteResponse` operation.
    ///
    /// See [`GetRouteResponse`](crate::client::fluent_builders::GetRouteResponse) for more information about the
    /// operation and its arguments.
    pub fn get_route_response(&self) -> fluent_builders::GetRouteResponse<C, M, R> {
        fluent_builders::GetRouteResponse::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRouteResponses` operation.
    ///
    /// See [`GetRouteResponses`](crate::client::fluent_builders::GetRouteResponses) for more information about the
    /// operation and its arguments.
    pub fn get_route_responses(&self) -> fluent_builders::GetRouteResponses<C, M, R> {
        fluent_builders::GetRouteResponses::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRoutes` operation.
    ///
    /// See [`GetRoutes`](crate::client::fluent_builders::GetRoutes) for more information about the
    /// operation and its arguments.
    pub fn get_routes(&self) -> fluent_builders::GetRoutes<C, M, R> {
        fluent_builders::GetRoutes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetStage` operation.
    ///
    /// See [`GetStage`](crate::client::fluent_builders::GetStage) for more information about the
    /// operation and its arguments.
    pub fn get_stage(&self) -> fluent_builders::GetStage<C, M, R> {
        fluent_builders::GetStage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetStages` operation.
    ///
    /// See [`GetStages`](crate::client::fluent_builders::GetStages) for more information about the
    /// operation and its arguments.
    pub fn get_stages(&self) -> fluent_builders::GetStages<C, M, R> {
        fluent_builders::GetStages::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetTags` operation.
    ///
    /// See [`GetTags`](crate::client::fluent_builders::GetTags) for more information about the
    /// operation and its arguments.
    pub fn get_tags(&self) -> fluent_builders::GetTags<C, M, R> {
        fluent_builders::GetTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetVpcLink` operation.
    ///
    /// See [`GetVpcLink`](crate::client::fluent_builders::GetVpcLink) for more information about the
    /// operation and its arguments.
    pub fn get_vpc_link(&self) -> fluent_builders::GetVpcLink<C, M, R> {
        fluent_builders::GetVpcLink::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetVpcLinks` operation.
    ///
    /// See [`GetVpcLinks`](crate::client::fluent_builders::GetVpcLinks) for more information about the
    /// operation and its arguments.
    pub fn get_vpc_links(&self) -> fluent_builders::GetVpcLinks<C, M, R> {
        fluent_builders::GetVpcLinks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ImportApi` operation.
    ///
    /// See [`ImportApi`](crate::client::fluent_builders::ImportApi) for more information about the
    /// operation and its arguments.
    pub fn import_api(&self) -> fluent_builders::ImportApi<C, M, R> {
        fluent_builders::ImportApi::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ReimportApi` operation.
    ///
    /// See [`ReimportApi`](crate::client::fluent_builders::ReimportApi) for more information about the
    /// operation and its arguments.
    pub fn reimport_api(&self) -> fluent_builders::ReimportApi<C, M, R> {
        fluent_builders::ReimportApi::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ResetAuthorizersCache` operation.
    ///
    /// See [`ResetAuthorizersCache`](crate::client::fluent_builders::ResetAuthorizersCache) for more information about the
    /// operation and its arguments.
    pub fn reset_authorizers_cache(&self) -> fluent_builders::ResetAuthorizersCache<C, M, R> {
        fluent_builders::ResetAuthorizersCache::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateApi` operation.
    ///
    /// See [`UpdateApi`](crate::client::fluent_builders::UpdateApi) for more information about the
    /// operation and its arguments.
    pub fn update_api(&self) -> fluent_builders::UpdateApi<C, M, R> {
        fluent_builders::UpdateApi::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateApiMapping` operation.
    ///
    /// See [`UpdateApiMapping`](crate::client::fluent_builders::UpdateApiMapping) for more information about the
    /// operation and its arguments.
    pub fn update_api_mapping(&self) -> fluent_builders::UpdateApiMapping<C, M, R> {
        fluent_builders::UpdateApiMapping::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateAuthorizer` operation.
    ///
    /// See [`UpdateAuthorizer`](crate::client::fluent_builders::UpdateAuthorizer) for more information about the
    /// operation and its arguments.
    pub fn update_authorizer(&self) -> fluent_builders::UpdateAuthorizer<C, M, R> {
        fluent_builders::UpdateAuthorizer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDeployment` operation.
    ///
    /// See [`UpdateDeployment`](crate::client::fluent_builders::UpdateDeployment) for more information about the
    /// operation and its arguments.
    pub fn update_deployment(&self) -> fluent_builders::UpdateDeployment<C, M, R> {
        fluent_builders::UpdateDeployment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDomainName` operation.
    ///
    /// See [`UpdateDomainName`](crate::client::fluent_builders::UpdateDomainName) for more information about the
    /// operation and its arguments.
    pub fn update_domain_name(&self) -> fluent_builders::UpdateDomainName<C, M, R> {
        fluent_builders::UpdateDomainName::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateIntegration` operation.
    ///
    /// See [`UpdateIntegration`](crate::client::fluent_builders::UpdateIntegration) for more information about the
    /// operation and its arguments.
    pub fn update_integration(&self) -> fluent_builders::UpdateIntegration<C, M, R> {
        fluent_builders::UpdateIntegration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateIntegrationResponse` operation.
    ///
    /// See [`UpdateIntegrationResponse`](crate::client::fluent_builders::UpdateIntegrationResponse) for more information about the
    /// operation and its arguments.
    pub fn update_integration_response(
        &self,
    ) -> fluent_builders::UpdateIntegrationResponse<C, M, R> {
        fluent_builders::UpdateIntegrationResponse::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateModel` operation.
    ///
    /// See [`UpdateModel`](crate::client::fluent_builders::UpdateModel) for more information about the
    /// operation and its arguments.
    pub fn update_model(&self) -> fluent_builders::UpdateModel<C, M, R> {
        fluent_builders::UpdateModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateRoute` operation.
    ///
    /// See [`UpdateRoute`](crate::client::fluent_builders::UpdateRoute) for more information about the
    /// operation and its arguments.
    pub fn update_route(&self) -> fluent_builders::UpdateRoute<C, M, R> {
        fluent_builders::UpdateRoute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateRouteResponse` operation.
    ///
    /// See [`UpdateRouteResponse`](crate::client::fluent_builders::UpdateRouteResponse) for more information about the
    /// operation and its arguments.
    pub fn update_route_response(&self) -> fluent_builders::UpdateRouteResponse<C, M, R> {
        fluent_builders::UpdateRouteResponse::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateStage` operation.
    ///
    /// See [`UpdateStage`](crate::client::fluent_builders::UpdateStage) for more information about the
    /// operation and its arguments.
    pub fn update_stage(&self) -> fluent_builders::UpdateStage<C, M, R> {
        fluent_builders::UpdateStage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateVpcLink` operation.
    ///
    /// See [`UpdateVpcLink`](crate::client::fluent_builders::UpdateVpcLink) for more information about the
    /// operation and its arguments.
    pub fn update_vpc_link(&self) -> fluent_builders::UpdateVpcLink<C, M, R> {
        fluent_builders::UpdateVpcLink::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateApi`.
    ///
    /// <p>Creates an Api resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateApi<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_api_input::Builder,
    }
    impl<C, M, R> CreateApi<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateApi`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateApiOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateApiError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateApiInputOperationOutputAlias,
                crate::output::CreateApiOutput,
                crate::error::CreateApiError,
                crate::input::CreateApiInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An API key selection expression. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions">API Key Selection Expressions</a>.</p>
        pub fn api_key_selection_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.api_key_selection_expression(input.into());
            self
        }
        /// <p>An API key selection expression. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions">API Key Selection Expressions</a>.</p>
        pub fn set_api_key_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_api_key_selection_expression(input);
            self
        }
        /// <p>A CORS configuration. Supported only for HTTP APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-cors.html">Configuring CORS</a> for more information.</p>
        pub fn cors_configuration(mut self, input: crate::model::Cors) -> Self {
            self.inner = self.inner.cors_configuration(input);
            self
        }
        /// <p>A CORS configuration. Supported only for HTTP APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-cors.html">Configuring CORS</a> for more information.</p>
        pub fn set_cors_configuration(
            mut self,
            input: std::option::Option<crate::model::Cors>,
        ) -> Self {
            self.inner = self.inner.set_cors_configuration(input);
            self
        }
        /// <p>This property is part of quick create. It specifies the credentials required for the integration, if any. For a Lambda integration, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, specify null. Currently, this property is not used for HTTP integrations. Supported only for HTTP APIs.</p>
        pub fn credentials_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.credentials_arn(input.into());
            self
        }
        /// <p>This property is part of quick create. It specifies the credentials required for the integration, if any. For a Lambda integration, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, specify null. Currently, this property is not used for HTTP integrations. Supported only for HTTP APIs.</p>
        pub fn set_credentials_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_credentials_arn(input);
            self
        }
        /// <p>The description of the API.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the API.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Avoid validating models when creating a deployment. Supported only for WebSocket APIs.</p>
        pub fn disable_schema_validation(mut self, input: bool) -> Self {
            self.inner = self.inner.disable_schema_validation(input);
            self
        }
        /// <p>Avoid validating models when creating a deployment. Supported only for WebSocket APIs.</p>
        pub fn set_disable_schema_validation(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_disable_schema_validation(input);
            self
        }
        /// <p>Specifies whether clients can invoke your API by using the default execute-api endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
        pub fn disable_execute_api_endpoint(mut self, input: bool) -> Self {
            self.inner = self.inner.disable_execute_api_endpoint(input);
            self
        }
        /// <p>Specifies whether clients can invoke your API by using the default execute-api endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
        pub fn set_disable_execute_api_endpoint(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_disable_execute_api_endpoint(input);
            self
        }
        /// <p>The name of the API.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the API.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The API protocol.</p>
        pub fn protocol_type(mut self, input: crate::model::ProtocolType) -> Self {
            self.inner = self.inner.protocol_type(input);
            self
        }
        /// <p>The API protocol.</p>
        pub fn set_protocol_type(
            mut self,
            input: std::option::Option<crate::model::ProtocolType>,
        ) -> Self {
            self.inner = self.inner.set_protocol_type(input);
            self
        }
        /// <p>This property is part of quick create. If you don't specify a routeKey, a default route of $default is created. The $default route acts as a catch-all for any request made to your API, for a particular stage. The $default route key can't be modified. You can add routes after creating the API, and you can update the route keys of additional routes. Supported only for HTTP APIs.</p>
        pub fn route_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.route_key(input.into());
            self
        }
        /// <p>This property is part of quick create. If you don't specify a routeKey, a default route of $default is created. The $default route acts as a catch-all for any request made to your API, for a particular stage. The $default route key can't be modified. You can add routes after creating the API, and you can update the route keys of additional routes. Supported only for HTTP APIs.</p>
        pub fn set_route_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_route_key(input);
            self
        }
        /// <p>The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.</p>
        pub fn route_selection_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.route_selection_expression(input.into());
            self
        }
        /// <p>The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.</p>
        pub fn set_route_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_route_selection_expression(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>This property is part of quick create. Quick create produces an API with an integration, a default catch-all route, and a default stage which is configured to automatically deploy changes. For HTTP integrations, specify a fully qualified URL. For Lambda integrations, specify a function ARN. The type of the integration will be HTTP_PROXY or AWS_PROXY, respectively. Supported only for HTTP APIs.</p>
        pub fn target(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target(input.into());
            self
        }
        /// <p>This property is part of quick create. Quick create produces an API with an integration, a default catch-all route, and a default stage which is configured to automatically deploy changes. For HTTP integrations, specify a fully qualified URL. For Lambda integrations, specify a function ARN. The type of the integration will be HTTP_PROXY or AWS_PROXY, respectively. Supported only for HTTP APIs.</p>
        pub fn set_target(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_target(input);
            self
        }
        /// <p>A version identifier for the API.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(input.into());
            self
        }
        /// <p>A version identifier for the API.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateApiMapping`.
    ///
    /// <p>Creates an API mapping.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateApiMapping<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_api_mapping_input::Builder,
    }
    impl<C, M, R> CreateApiMapping<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateApiMapping`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateApiMappingOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateApiMappingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateApiMappingInputOperationOutputAlias,
                crate::output::CreateApiMappingOutput,
                crate::error::CreateApiMappingError,
                crate::input::CreateApiMappingInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// The API mapping key.
        pub fn api_mapping_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_mapping_key(input.into());
            self
        }
        /// The API mapping key.
        pub fn set_api_mapping_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_api_mapping_key(input);
            self
        }
        /// <p>The domain name.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The domain name.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The API stage.</p>
        pub fn stage(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stage(input.into());
            self
        }
        /// <p>The API stage.</p>
        pub fn set_stage(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stage(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAuthorizer`.
    ///
    /// <p>Creates an Authorizer for an API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateAuthorizer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_authorizer_input::Builder,
    }
    impl<C, M, R> CreateAuthorizer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAuthorizer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAuthorizerOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAuthorizerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAuthorizerInputOperationOutputAlias,
                crate::output::CreateAuthorizerOutput,
                crate::error::CreateAuthorizerError,
                crate::input::CreateAuthorizerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, don't specify this parameter. Supported only for REQUEST authorizers.</p>
        pub fn authorizer_credentials_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authorizer_credentials_arn(input.into());
            self
        }
        /// <p>Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, don't specify this parameter. Supported only for REQUEST authorizers.</p>
        pub fn set_authorizer_credentials_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authorizer_credentials_arn(input);
            self
        }
        /// <p>Specifies the format of the payload sent to an HTTP API Lambda authorizer. Required for HTTP API Lambda authorizers. Supported values are 1.0 and 2.0. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p>
        pub fn authorizer_payload_format_version(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.authorizer_payload_format_version(input.into());
            self
        }
        /// <p>Specifies the format of the payload sent to an HTTP API Lambda authorizer. Required for HTTP API Lambda authorizers. Supported values are 1.0 and 2.0. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p>
        pub fn set_authorizer_payload_format_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authorizer_payload_format_version(input);
            self
        }
        /// <p>The time to live (TTL) for cached authorizer results, in seconds. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway caches authorizer responses. The maximum value is 3600, or 1 hour. Supported only for HTTP API Lambda authorizers.</p>
        pub fn authorizer_result_ttl_in_seconds(mut self, input: i32) -> Self {
            self.inner = self.inner.authorizer_result_ttl_in_seconds(input);
            self
        }
        /// <p>The time to live (TTL) for cached authorizer results, in seconds. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway caches authorizer responses. The maximum value is 3600, or 1 hour. Supported only for HTTP API Lambda authorizers.</p>
        pub fn set_authorizer_result_ttl_in_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_authorizer_result_ttl_in_seconds(input);
            self
        }
        /// <p>The authorizer type. Specify REQUEST for a Lambda function using incoming request parameters. Specify JWT to use JSON Web Tokens (supported only for HTTP APIs).</p>
        pub fn authorizer_type(mut self, input: crate::model::AuthorizerType) -> Self {
            self.inner = self.inner.authorizer_type(input);
            self
        }
        /// <p>The authorizer type. Specify REQUEST for a Lambda function using incoming request parameters. Specify JWT to use JSON Web Tokens (supported only for HTTP APIs).</p>
        pub fn set_authorizer_type(
            mut self,
            input: std::option::Option<crate::model::AuthorizerType>,
        ) -> Self {
            self.inner = self.inner.set_authorizer_type(input);
            self
        }
        /// <p>The authorizer's Uniform Resource Identifier (URI). For REQUEST authorizers, this must be a well-formed Lambda function URI, for example, arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:<replaceable>
        /// {account_id}
        /// </replaceable>:function:<replaceable>
        /// {lambda_function_name}
        /// </replaceable>/invocations. In general, the URI has this form: arn:aws:apigateway:<replaceable>
        /// {region}
        /// </replaceable>:lambda:path/<replaceable>
        /// {service_api}
        /// </replaceable> , where <replaceable></replaceable>{region} is the same as the region hosting the Lambda function, path indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial /. For Lambda functions, this is usually of the form /2015-03-31/functions/[FunctionARN]/invocations. Supported only for REQUEST authorizers.</p>
        pub fn authorizer_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authorizer_uri(input.into());
            self
        }
        /// <p>The authorizer's Uniform Resource Identifier (URI). For REQUEST authorizers, this must be a well-formed Lambda function URI, for example, arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:<replaceable>
        /// {account_id}
        /// </replaceable>:function:<replaceable>
        /// {lambda_function_name}
        /// </replaceable>/invocations. In general, the URI has this form: arn:aws:apigateway:<replaceable>
        /// {region}
        /// </replaceable>:lambda:path/<replaceable>
        /// {service_api}
        /// </replaceable> , where <replaceable></replaceable>{region} is the same as the region hosting the Lambda function, path indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial /. For Lambda functions, this is usually of the form /2015-03-31/functions/[FunctionARN]/invocations. Supported only for REQUEST authorizers.</p>
        pub fn set_authorizer_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authorizer_uri(input);
            self
        }
        /// <p>Specifies whether a Lambda authorizer returns a response in a simple format. By default, a Lambda authorizer must return an IAM policy. If enabled, the Lambda authorizer can return a boolean value instead of an IAM policy. Supported only for HTTP APIs. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a></p>
        pub fn enable_simple_responses(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_simple_responses(input);
            self
        }
        /// <p>Specifies whether a Lambda authorizer returns a response in a simple format. By default, a Lambda authorizer must return an IAM policy. If enabled, the Lambda authorizer can return a boolean value instead of an IAM policy. Supported only for HTTP APIs. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a></p>
        pub fn set_enable_simple_responses(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_simple_responses(input);
            self
        }
        /// Appends an item to `IdentitySource`.
        ///
        /// To override the contents of this collection use [`set_identity_source`](Self::set_identity_source).
        ///
        /// <p>The identity source for which authorization is requested.</p>
        /// <p>For a REQUEST authorizer, this is optional. The value is a set of one or more mapping expressions of the specified request parameters. The identity source can be headers, query string parameters, stage variables, and context parameters. For example, if an Auth header and a Name query string parameter are defined as identity sources, this value is route.request.header.Auth, route.request.querystring.Name for WebSocket APIs. For HTTP APIs, use selection expressions prefixed with $, for example, $request.header.Auth, $request.querystring.Name. These parameters are used to perform runtime validation for Lambda-based authorizers by verifying all of the identity-related request parameters are present in the request, not null, and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function. Otherwise, it returns a 401 Unauthorized response without calling the Lambda function. For HTTP APIs, identity sources are also used as the cache key when caching is enabled. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p>
        /// <p>For JWT, a single entry that specifies where to extract the JSON Web Token (JWT) from inbound requests. Currently only header-based and query parameter-based selections are supported, for example $request.header.Authorization.</p>
        pub fn identity_source(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_source(input.into());
            self
        }
        /// <p>The identity source for which authorization is requested.</p>
        /// <p>For a REQUEST authorizer, this is optional. The value is a set of one or more mapping expressions of the specified request parameters. The identity source can be headers, query string parameters, stage variables, and context parameters. For example, if an Auth header and a Name query string parameter are defined as identity sources, this value is route.request.header.Auth, route.request.querystring.Name for WebSocket APIs. For HTTP APIs, use selection expressions prefixed with $, for example, $request.header.Auth, $request.querystring.Name. These parameters are used to perform runtime validation for Lambda-based authorizers by verifying all of the identity-related request parameters are present in the request, not null, and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function. Otherwise, it returns a 401 Unauthorized response without calling the Lambda function. For HTTP APIs, identity sources are also used as the cache key when caching is enabled. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p>
        /// <p>For JWT, a single entry that specifies where to extract the JSON Web Token (JWT) from inbound requests. Currently only header-based and query parameter-based selections are supported, for example $request.header.Authorization.</p>
        pub fn set_identity_source(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_identity_source(input);
            self
        }
        /// <p>This parameter is not used.</p>
        pub fn identity_validation_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.identity_validation_expression(input.into());
            self
        }
        /// <p>This parameter is not used.</p>
        pub fn set_identity_validation_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_validation_expression(input);
            self
        }
        /// <p>Represents the configuration of a JWT authorizer. Required for the JWT authorizer type. Supported only for HTTP APIs.</p>
        pub fn jwt_configuration(mut self, input: crate::model::JwtConfiguration) -> Self {
            self.inner = self.inner.jwt_configuration(input);
            self
        }
        /// <p>Represents the configuration of a JWT authorizer. Required for the JWT authorizer type. Supported only for HTTP APIs.</p>
        pub fn set_jwt_configuration(
            mut self,
            input: std::option::Option<crate::model::JwtConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_jwt_configuration(input);
            self
        }
        /// <p>The name of the authorizer.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the authorizer.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDeployment`.
    ///
    /// <p>Creates a Deployment for an API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDeployment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_deployment_input::Builder,
    }
    impl<C, M, R> CreateDeployment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDeployment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDeploymentOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDeploymentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDeploymentInputOperationOutputAlias,
                crate::output::CreateDeploymentOutput,
                crate::error::CreateDeploymentError,
                crate::input::CreateDeploymentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The description for the deployment resource.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description for the deployment resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The name of the Stage resource for the Deployment resource to create.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stage_name(input.into());
            self
        }
        /// <p>The name of the Stage resource for the Deployment resource to create.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stage_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDomainName`.
    ///
    /// <p>Creates a domain name.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDomainName<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_domain_name_input::Builder,
    }
    impl<C, M, R> CreateDomainName<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDomainName`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDomainNameOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDomainNameError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDomainNameInputOperationOutputAlias,
                crate::output::CreateDomainNameOutput,
                crate::error::CreateDomainNameError,
                crate::input::CreateDomainNameInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The domain name.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The domain name.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// Appends an item to `DomainNameConfigurations`.
        ///
        /// To override the contents of this collection use [`set_domain_name_configurations`](Self::set_domain_name_configurations).
        ///
        /// <p>The domain name configurations.</p>
        pub fn domain_name_configurations(
            mut self,
            input: crate::model::DomainNameConfiguration,
        ) -> Self {
            self.inner = self.inner.domain_name_configurations(input);
            self
        }
        /// <p>The domain name configurations.</p>
        pub fn set_domain_name_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DomainNameConfiguration>>,
        ) -> Self {
            self.inner = self.inner.set_domain_name_configurations(input);
            self
        }
        /// <p>The mutual TLS authentication configuration for a custom domain name.</p>
        pub fn mutual_tls_authentication(
            mut self,
            input: crate::model::MutualTlsAuthenticationInput,
        ) -> Self {
            self.inner = self.inner.mutual_tls_authentication(input);
            self
        }
        /// <p>The mutual TLS authentication configuration for a custom domain name.</p>
        pub fn set_mutual_tls_authentication(
            mut self,
            input: std::option::Option<crate::model::MutualTlsAuthenticationInput>,
        ) -> Self {
            self.inner = self.inner.set_mutual_tls_authentication(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The collection of tags associated with a domain name.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The collection of tags associated with a domain name.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateIntegration`.
    ///
    /// <p>Creates an Integration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateIntegration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_integration_input::Builder,
    }
    impl<C, M, R> CreateIntegration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateIntegration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateIntegrationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateIntegrationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateIntegrationInputOperationOutputAlias,
                crate::output::CreateIntegrationOutput,
                crate::error::CreateIntegrationError,
                crate::input::CreateIntegrationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The ID of the VPC link for a private integration. Supported only for HTTP APIs.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_id(input.into());
            self
        }
        /// <p>The ID of the VPC link for a private integration. Supported only for HTTP APIs.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_id(input);
            self
        }
        /// <p>The type of the network connection to the integration endpoint. Specify INTERNET for connections through the public routable internet or VPC_LINK for private connections between API Gateway and resources in a VPC. The default value is INTERNET.</p>
        pub fn connection_type(mut self, input: crate::model::ConnectionType) -> Self {
            self.inner = self.inner.connection_type(input);
            self
        }
        /// <p>The type of the network connection to the integration endpoint. Specify INTERNET for connections through the public routable internet or VPC_LINK for private connections between API Gateway and resources in a VPC. The default value is INTERNET.</p>
        pub fn set_connection_type(
            mut self,
            input: std::option::Option<crate::model::ConnectionType>,
        ) -> Self {
            self.inner = self.inner.set_connection_type(input);
            self
        }
        /// <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p>
        /// <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p>
        /// <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p>
        /// <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
        pub fn content_handling_strategy(
            mut self,
            input: crate::model::ContentHandlingStrategy,
        ) -> Self {
            self.inner = self.inner.content_handling_strategy(input);
            self
        }
        /// <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p>
        /// <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p>
        /// <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p>
        /// <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
        pub fn set_content_handling_strategy(
            mut self,
            input: std::option::Option<crate::model::ContentHandlingStrategy>,
        ) -> Self {
            self.inner = self.inner.set_content_handling_strategy(input);
            self
        }
        /// <p>Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, specify null.</p>
        pub fn credentials_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.credentials_arn(input.into());
            self
        }
        /// <p>Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, specify null.</p>
        pub fn set_credentials_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_credentials_arn(input);
            self
        }
        /// <p>The description of the integration.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the integration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Specifies the integration's HTTP method type.</p>
        pub fn integration_method(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.integration_method(input.into());
            self
        }
        /// <p>Specifies the integration's HTTP method type.</p>
        pub fn set_integration_method(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_integration_method(input);
            self
        }
        /// <p>Supported only for HTTP API AWS_PROXY integrations. Specifies the AWS service action to invoke. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html">Integration subtype reference</a>.</p>
        pub fn integration_subtype(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.integration_subtype(input.into());
            self
        }
        /// <p>Supported only for HTTP API AWS_PROXY integrations. Specifies the AWS service action to invoke. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html">Integration subtype reference</a>.</p>
        pub fn set_integration_subtype(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_integration_subtype(input);
            self
        }
        /// <p>The integration type of an integration. One of the following:</p>
        /// <p>AWS: for integrating the route or method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration. Supported only for WebSocket APIs.</p>
        /// <p>AWS_PROXY: for integrating the route or method request with a Lambda function or other AWS service action. This integration is also referred to as a Lambda proxy integration.</p>
        /// <p>HTTP: for integrating the route or method request with an HTTP endpoint. This integration is also referred to as the HTTP custom integration. Supported only for WebSocket APIs.</p>
        /// <p>HTTP_PROXY: for integrating the route or method request with an HTTP endpoint, with the client request passed through as-is. This is also referred to as HTTP proxy integration. For HTTP API private integrations, use an HTTP_PROXY integration.</p>
        /// <p>MOCK: for integrating the route or method request with API Gateway as a "loopback" endpoint without invoking any backend. Supported only for WebSocket APIs.</p>
        pub fn integration_type(mut self, input: crate::model::IntegrationType) -> Self {
            self.inner = self.inner.integration_type(input);
            self
        }
        /// <p>The integration type of an integration. One of the following:</p>
        /// <p>AWS: for integrating the route or method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration. Supported only for WebSocket APIs.</p>
        /// <p>AWS_PROXY: for integrating the route or method request with a Lambda function or other AWS service action. This integration is also referred to as a Lambda proxy integration.</p>
        /// <p>HTTP: for integrating the route or method request with an HTTP endpoint. This integration is also referred to as the HTTP custom integration. Supported only for WebSocket APIs.</p>
        /// <p>HTTP_PROXY: for integrating the route or method request with an HTTP endpoint, with the client request passed through as-is. This is also referred to as HTTP proxy integration. For HTTP API private integrations, use an HTTP_PROXY integration.</p>
        /// <p>MOCK: for integrating the route or method request with API Gateway as a "loopback" endpoint without invoking any backend. Supported only for WebSocket APIs.</p>
        pub fn set_integration_type(
            mut self,
            input: std::option::Option<crate::model::IntegrationType>,
        ) -> Self {
            self.inner = self.inner.set_integration_type(input);
            self
        }
        /// <p>For a Lambda integration, specify the URI of a Lambda function.</p>
        /// <p>For an HTTP integration, specify a fully-qualified URL.</p>
        /// <p>For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service. If you specify the ARN of an AWS Cloud Map service, API Gateway uses DiscoverInstances to identify resources. You can use query parameters to target specific resources. To learn more, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_DiscoverInstances.html">DiscoverInstances</a>. For private integrations, all resources must be owned by the same AWS account.</p>
        pub fn integration_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.integration_uri(input.into());
            self
        }
        /// <p>For a Lambda integration, specify the URI of a Lambda function.</p>
        /// <p>For an HTTP integration, specify a fully-qualified URL.</p>
        /// <p>For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service. If you specify the ARN of an AWS Cloud Map service, API Gateway uses DiscoverInstances to identify resources. You can use query parameters to target specific resources. To learn more, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_DiscoverInstances.html">DiscoverInstances</a>. For private integrations, all resources must be owned by the same AWS account.</p>
        pub fn set_integration_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_integration_uri(input);
            self
        }
        /// <p>Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER. Supported only for WebSocket APIs.</p>
        /// <p>WHEN_NO_MATCH passes the request body for unmapped content types through to the integration backend without transformation.</p>
        /// <p>NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type response.</p>
        /// <p>WHEN_NO_TEMPLATES allows pass-through when the integration has no content types mapped to templates. However, if there is at least one content type defined, unmapped content types will be rejected with the same HTTP 415 Unsupported Media Type response.</p>
        pub fn passthrough_behavior(mut self, input: crate::model::PassthroughBehavior) -> Self {
            self.inner = self.inner.passthrough_behavior(input);
            self
        }
        /// <p>Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER. Supported only for WebSocket APIs.</p>
        /// <p>WHEN_NO_MATCH passes the request body for unmapped content types through to the integration backend without transformation.</p>
        /// <p>NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type response.</p>
        /// <p>WHEN_NO_TEMPLATES allows pass-through when the integration has no content types mapped to templates. However, if there is at least one content type defined, unmapped content types will be rejected with the same HTTP 415 Unsupported Media Type response.</p>
        pub fn set_passthrough_behavior(
            mut self,
            input: std::option::Option<crate::model::PassthroughBehavior>,
        ) -> Self {
            self.inner = self.inner.set_passthrough_behavior(input);
            self
        }
        /// <p>Specifies the format of the payload sent to an integration. Required for HTTP APIs.</p>
        pub fn payload_format_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.payload_format_version(input.into());
            self
        }
        /// <p>Specifies the format of the payload sent to an integration. Required for HTTP APIs.</p>
        pub fn set_payload_format_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_payload_format_version(input);
            self
        }
        /// Adds a key-value pair to `RequestParameters`.
        ///
        /// To override the contents of this collection use [`set_request_parameters`](Self::set_request_parameters).
        ///
        /// <p>For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the backend. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the backend. The method request parameter value must match the pattern of method.request.<replaceable>
        /// {location}
        /// </replaceable>.<replaceable>
        /// {name}
        /// </replaceable> , where <replaceable>
        /// {location}
        /// </replaceable> is querystring, path, or header; and <replaceable>
        /// {name}
        /// </replaceable> must be a valid and unique method request parameter name.</p>
        /// <p>For HTTP API integrations with a specified integrationSubtype, request parameters are a key-value map specifying parameters that are passed to AWS_PROXY integrations. You can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services.html">Working with AWS service integrations for HTTP APIs</a>.</p>
        /// <p>For HTTP API integrations without a specified integrationSubtype request parameters are a key-value map specifying how to transform HTTP requests before sending them to the backend. The key should follow the pattern &lt;action&gt;:&lt;header|querystring|path&gt;.&lt;location&gt; where action can be append, overwrite or remove. For values, you can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
        pub fn request_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.request_parameters(k.into(), v.into());
            self
        }
        /// <p>For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the backend. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the backend. The method request parameter value must match the pattern of method.request.<replaceable>
        /// {location}
        /// </replaceable>.<replaceable>
        /// {name}
        /// </replaceable> , where <replaceable>
        /// {location}
        /// </replaceable> is querystring, path, or header; and <replaceable>
        /// {name}
        /// </replaceable> must be a valid and unique method request parameter name.</p>
        /// <p>For HTTP API integrations with a specified integrationSubtype, request parameters are a key-value map specifying parameters that are passed to AWS_PROXY integrations. You can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services.html">Working with AWS service integrations for HTTP APIs</a>.</p>
        /// <p>For HTTP API integrations without a specified integrationSubtype request parameters are a key-value map specifying how to transform HTTP requests before sending them to the backend. The key should follow the pattern &lt;action&gt;:&lt;header|querystring|path&gt;.&lt;location&gt; where action can be append, overwrite or remove. For values, you can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
        pub fn set_request_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_request_parameters(input);
            self
        }
        /// Adds a key-value pair to `RequestTemplates`.
        ///
        /// To override the contents of this collection use [`set_request_templates`](Self::set_request_templates).
        ///
        /// <p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value. Supported only for WebSocket APIs.</p>
        pub fn request_templates(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.request_templates(k.into(), v.into());
            self
        }
        /// <p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value. Supported only for WebSocket APIs.</p>
        pub fn set_request_templates(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_request_templates(input);
            self
        }
        /// Adds a key-value pair to `ResponseParameters`.
        ///
        /// To override the contents of this collection use [`set_response_parameters`](Self::set_response_parameters).
        ///
        /// <p>Supported only for HTTP APIs. You use response parameters to transform the HTTP response from a backend integration before returning the response to clients. Specify a key-value map from a selection key to response parameters. The selection key must be a valid HTTP status code within the range of 200-599. Response parameters are a key-value map. The key must match pattern &lt;action&gt;:&lt;header&gt;.&lt;location&gt; or overwrite.statuscode. The action can be append, overwrite or remove. The value can be a static value, or map to response data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
        pub fn response_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: std::collections::HashMap<std::string::String, std::string::String>,
        ) -> Self {
            self.inner = self.inner.response_parameters(k.into(), v);
            self
        }
        /// <p>Supported only for HTTP APIs. You use response parameters to transform the HTTP response from a backend integration before returning the response to clients. Specify a key-value map from a selection key to response parameters. The selection key must be a valid HTTP status code within the range of 200-599. Response parameters are a key-value map. The key must match pattern &lt;action&gt;:&lt;header&gt;.&lt;location&gt; or overwrite.statuscode. The action can be append, overwrite or remove. The value can be a static value, or map to response data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
        pub fn set_response_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    std::collections::HashMap<std::string::String, std::string::String>,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_response_parameters(input);
            self
        }
        /// <p>The template selection expression for the integration.</p>
        pub fn template_selection_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.template_selection_expression(input.into());
            self
        }
        /// <p>The template selection expression for the integration.</p>
        pub fn set_template_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_selection_expression(input);
            self
        }
        /// <p>Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs. The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.</p>
        pub fn timeout_in_millis(mut self, input: i32) -> Self {
            self.inner = self.inner.timeout_in_millis(input);
            self
        }
        /// <p>Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs. The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.</p>
        pub fn set_timeout_in_millis(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_timeout_in_millis(input);
            self
        }
        /// <p>The TLS configuration for a private integration. If you specify a TLS configuration, private integration traffic uses the HTTPS protocol. Supported only for HTTP APIs.</p>
        pub fn tls_config(mut self, input: crate::model::TlsConfigInput) -> Self {
            self.inner = self.inner.tls_config(input);
            self
        }
        /// <p>The TLS configuration for a private integration. If you specify a TLS configuration, private integration traffic uses the HTTPS protocol. Supported only for HTTP APIs.</p>
        pub fn set_tls_config(
            mut self,
            input: std::option::Option<crate::model::TlsConfigInput>,
        ) -> Self {
            self.inner = self.inner.set_tls_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateIntegrationResponse`.
    ///
    /// <p>Creates an IntegrationResponses.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateIntegrationResponse<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_integration_response_input::Builder,
    }
    impl<C, M, R> CreateIntegrationResponse<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateIntegrationResponse`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateIntegrationResponseOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateIntegrationResponseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateIntegrationResponseInputOperationOutputAlias,
                crate::output::CreateIntegrationResponseOutput,
                crate::error::CreateIntegrationResponseError,
                crate::input::CreateIntegrationResponseInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p>
        /// <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p>
        /// <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p>
        /// <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
        pub fn content_handling_strategy(
            mut self,
            input: crate::model::ContentHandlingStrategy,
        ) -> Self {
            self.inner = self.inner.content_handling_strategy(input);
            self
        }
        /// <p>Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p>
        /// <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p>
        /// <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p>
        /// <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
        pub fn set_content_handling_strategy(
            mut self,
            input: std::option::Option<crate::model::ContentHandlingStrategy>,
        ) -> Self {
            self.inner = self.inner.set_content_handling_strategy(input);
            self
        }
        /// <p>The integration ID.</p>
        pub fn integration_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.integration_id(input.into());
            self
        }
        /// <p>The integration ID.</p>
        pub fn set_integration_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_integration_id(input);
            self
        }
        /// <p>The integration response key.</p>
        pub fn integration_response_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.integration_response_key(input.into());
            self
        }
        /// <p>The integration response key.</p>
        pub fn set_integration_response_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_integration_response_key(input);
            self
        }
        /// Adds a key-value pair to `ResponseParameters`.
        ///
        /// To override the contents of this collection use [`set_response_parameters`](Self::set_response_parameters).
        ///
        /// <p>A key-value map specifying response parameters that are passed to the method response from the backend. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of method.response.header.{name}, where {name} is a valid and unique header name. The mapped non-static value must match the pattern of integration.response.header.{name} or integration.response.body.{JSON-expression}, where {name} is a valid and unique response header name and {JSON-expression} is a valid JSON expression without the $ prefix.</p>
        pub fn response_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.response_parameters(k.into(), v.into());
            self
        }
        /// <p>A key-value map specifying response parameters that are passed to the method response from the backend. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of method.response.header.{name}, where {name} is a valid and unique header name. The mapped non-static value must match the pattern of integration.response.header.{name} or integration.response.body.{JSON-expression}, where {name} is a valid and unique response header name and {JSON-expression} is a valid JSON expression without the $ prefix.</p>
        pub fn set_response_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_response_parameters(input);
            self
        }
        /// Adds a key-value pair to `ResponseTemplates`.
        ///
        /// To override the contents of this collection use [`set_response_templates`](Self::set_response_templates).
        ///
        /// <p>The collection of response templates for the integration response as a string-to-string map of key-value pairs. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.</p>
        pub fn response_templates(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.response_templates(k.into(), v.into());
            self
        }
        /// <p>The collection of response templates for the integration response as a string-to-string map of key-value pairs. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.</p>
        pub fn set_response_templates(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_response_templates(input);
            self
        }
        /// <p>The template selection expression for the integration response. Supported only for WebSocket APIs.</p>
        pub fn template_selection_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.template_selection_expression(input.into());
            self
        }
        /// <p>The template selection expression for the integration response. Supported only for WebSocket APIs.</p>
        pub fn set_template_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_selection_expression(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateModel`.
    ///
    /// <p>Creates a Model for an API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateModel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_model_input::Builder,
    }
    impl<C, M, R> CreateModel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateModelOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateModelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateModelInputOperationOutputAlias,
                crate::output::CreateModelOutput,
                crate::error::CreateModelError,
                crate::input::CreateModelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The content-type for the model, for example, "application/json".</p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content_type(input.into());
            self
        }
        /// <p>The content-type for the model, for example, "application/json".</p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content_type(input);
            self
        }
        /// <p>The description of the model.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the model.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The name of the model. Must be alphanumeric.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the model. Must be alphanumeric.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The schema for the model. For application/json models, this should be JSON schema draft 4 model.</p>
        pub fn schema(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema(input.into());
            self
        }
        /// <p>The schema for the model. For application/json models, this should be JSON schema draft 4 model.</p>
        pub fn set_schema(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schema(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRoute`.
    ///
    /// <p>Creates a Route for an API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateRoute<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_route_input::Builder,
    }
    impl<C, M, R> CreateRoute<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateRoute`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRouteOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRouteError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateRouteInputOperationOutputAlias,
                crate::output::CreateRouteOutput,
                crate::error::CreateRouteError,
                crate::input::CreateRouteInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>Specifies whether an API key is required for the route. Supported only for WebSocket APIs.</p>
        pub fn api_key_required(mut self, input: bool) -> Self {
            self.inner = self.inner.api_key_required(input);
            self
        }
        /// <p>Specifies whether an API key is required for the route. Supported only for WebSocket APIs.</p>
        pub fn set_api_key_required(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_api_key_required(input);
            self
        }
        /// Appends an item to `AuthorizationScopes`.
        ///
        /// To override the contents of this collection use [`set_authorization_scopes`](Self::set_authorization_scopes).
        ///
        /// <p>The authorization scopes supported by this route.</p>
        pub fn authorization_scopes(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authorization_scopes(input.into());
            self
        }
        /// <p>The authorization scopes supported by this route.</p>
        pub fn set_authorization_scopes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_authorization_scopes(input);
            self
        }
        /// <p>The authorization type for the route. For WebSocket APIs, valid values are NONE for open access, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer For HTTP APIs, valid values are NONE for open access, JWT for using JSON Web Tokens, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer.</p>
        pub fn authorization_type(mut self, input: crate::model::AuthorizationType) -> Self {
            self.inner = self.inner.authorization_type(input);
            self
        }
        /// <p>The authorization type for the route. For WebSocket APIs, valid values are NONE for open access, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer For HTTP APIs, valid values are NONE for open access, JWT for using JSON Web Tokens, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer.</p>
        pub fn set_authorization_type(
            mut self,
            input: std::option::Option<crate::model::AuthorizationType>,
        ) -> Self {
            self.inner = self.inner.set_authorization_type(input);
            self
        }
        /// <p>The identifier of the Authorizer resource to be associated with this route. The authorizer identifier is generated by API Gateway when you created the authorizer.</p>
        pub fn authorizer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authorizer_id(input.into());
            self
        }
        /// <p>The identifier of the Authorizer resource to be associated with this route. The authorizer identifier is generated by API Gateway when you created the authorizer.</p>
        pub fn set_authorizer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authorizer_id(input);
            self
        }
        /// <p>The model selection expression for the route. Supported only for WebSocket APIs.</p>
        pub fn model_selection_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_selection_expression(input.into());
            self
        }
        /// <p>The model selection expression for the route. Supported only for WebSocket APIs.</p>
        pub fn set_model_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_model_selection_expression(input);
            self
        }
        /// <p>The operation name for the route.</p>
        pub fn operation_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.operation_name(input.into());
            self
        }
        /// <p>The operation name for the route.</p>
        pub fn set_operation_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_operation_name(input);
            self
        }
        /// Adds a key-value pair to `RequestModels`.
        ///
        /// To override the contents of this collection use [`set_request_models`](Self::set_request_models).
        ///
        /// <p>The request models for the route. Supported only for WebSocket APIs.</p>
        pub fn request_models(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.request_models(k.into(), v.into());
            self
        }
        /// <p>The request models for the route. Supported only for WebSocket APIs.</p>
        pub fn set_request_models(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_request_models(input);
            self
        }
        /// Adds a key-value pair to `RequestParameters`.
        ///
        /// To override the contents of this collection use [`set_request_parameters`](Self::set_request_parameters).
        ///
        /// <p>The request parameters for the route. Supported only for WebSocket APIs.</p>
        pub fn request_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::ParameterConstraints,
        ) -> Self {
            self.inner = self.inner.request_parameters(k.into(), v);
            self
        }
        /// <p>The request parameters for the route. Supported only for WebSocket APIs.</p>
        pub fn set_request_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::ParameterConstraints>,
            >,
        ) -> Self {
            self.inner = self.inner.set_request_parameters(input);
            self
        }
        /// <p>The route key for the route.</p>
        pub fn route_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.route_key(input.into());
            self
        }
        /// <p>The route key for the route.</p>
        pub fn set_route_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_route_key(input);
            self
        }
        /// <p>The route response selection expression for the route. Supported only for WebSocket APIs.</p>
        pub fn route_response_selection_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.route_response_selection_expression(input.into());
            self
        }
        /// <p>The route response selection expression for the route. Supported only for WebSocket APIs.</p>
        pub fn set_route_response_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_route_response_selection_expression(input);
            self
        }
        /// <p>The target for the route.</p>
        pub fn target(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target(input.into());
            self
        }
        /// <p>The target for the route.</p>
        pub fn set_target(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_target(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRouteResponse`.
    ///
    /// <p>Creates a RouteResponse for a Route.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateRouteResponse<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_route_response_input::Builder,
    }
    impl<C, M, R> CreateRouteResponse<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateRouteResponse`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRouteResponseOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRouteResponseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateRouteResponseInputOperationOutputAlias,
                crate::output::CreateRouteResponseOutput,
                crate::error::CreateRouteResponseError,
                crate::input::CreateRouteResponseInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The model selection expression for the route response. Supported only for WebSocket APIs.</p>
        pub fn model_selection_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_selection_expression(input.into());
            self
        }
        /// <p>The model selection expression for the route response. Supported only for WebSocket APIs.</p>
        pub fn set_model_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_model_selection_expression(input);
            self
        }
        /// Adds a key-value pair to `ResponseModels`.
        ///
        /// To override the contents of this collection use [`set_response_models`](Self::set_response_models).
        ///
        /// <p>The response models for the route response.</p>
        pub fn response_models(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.response_models(k.into(), v.into());
            self
        }
        /// <p>The response models for the route response.</p>
        pub fn set_response_models(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_response_models(input);
            self
        }
        /// Adds a key-value pair to `ResponseParameters`.
        ///
        /// To override the contents of this collection use [`set_response_parameters`](Self::set_response_parameters).
        ///
        /// <p>The route response parameters.</p>
        pub fn response_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::ParameterConstraints,
        ) -> Self {
            self.inner = self.inner.response_parameters(k.into(), v);
            self
        }
        /// <p>The route response parameters.</p>
        pub fn set_response_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::ParameterConstraints>,
            >,
        ) -> Self {
            self.inner = self.inner.set_response_parameters(input);
            self
        }
        /// <p>The route ID.</p>
        pub fn route_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.route_id(input.into());
            self
        }
        /// <p>The route ID.</p>
        pub fn set_route_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_route_id(input);
            self
        }
        /// <p>The route response key.</p>
        pub fn route_response_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.route_response_key(input.into());
            self
        }
        /// <p>The route response key.</p>
        pub fn set_route_response_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_route_response_key(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateStage`.
    ///
    /// <p>Creates a Stage for an API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateStage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_stage_input::Builder,
    }
    impl<C, M, R> CreateStage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateStage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateStageOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateStageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateStageInputOperationOutputAlias,
                crate::output::CreateStageOutput,
                crate::error::CreateStageError,
                crate::input::CreateStageInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Settings for logging access in this stage.</p>
        pub fn access_log_settings(mut self, input: crate::model::AccessLogSettings) -> Self {
            self.inner = self.inner.access_log_settings(input);
            self
        }
        /// <p>Settings for logging access in this stage.</p>
        pub fn set_access_log_settings(
            mut self,
            input: std::option::Option<crate::model::AccessLogSettings>,
        ) -> Self {
            self.inner = self.inner.set_access_log_settings(input);
            self
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>Specifies whether updates to an API automatically trigger a new deployment. The default value is false.</p>
        pub fn auto_deploy(mut self, input: bool) -> Self {
            self.inner = self.inner.auto_deploy(input);
            self
        }
        /// <p>Specifies whether updates to an API automatically trigger a new deployment. The default value is false.</p>
        pub fn set_auto_deploy(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_deploy(input);
            self
        }
        /// <p>The identifier of a client certificate for a Stage. Supported only for WebSocket APIs.</p>
        pub fn client_certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_certificate_id(input.into());
            self
        }
        /// <p>The identifier of a client certificate for a Stage. Supported only for WebSocket APIs.</p>
        pub fn set_client_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_certificate_id(input);
            self
        }
        /// <p>The default route settings for the stage.</p>
        pub fn default_route_settings(mut self, input: crate::model::RouteSettings) -> Self {
            self.inner = self.inner.default_route_settings(input);
            self
        }
        /// <p>The default route settings for the stage.</p>
        pub fn set_default_route_settings(
            mut self,
            input: std::option::Option<crate::model::RouteSettings>,
        ) -> Self {
            self.inner = self.inner.set_default_route_settings(input);
            self
        }
        /// <p>The deployment identifier of the API stage.</p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_id(input.into());
            self
        }
        /// <p>The deployment identifier of the API stage.</p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_id(input);
            self
        }
        /// <p>The description for the API stage.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description for the API stage.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Adds a key-value pair to `RouteSettings`.
        ///
        /// To override the contents of this collection use [`set_route_settings`](Self::set_route_settings).
        ///
        /// <p>Route settings for the stage, by routeKey.</p>
        pub fn route_settings(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::RouteSettings,
        ) -> Self {
            self.inner = self.inner.route_settings(k.into(), v);
            self
        }
        /// <p>Route settings for the stage, by routeKey.</p>
        pub fn set_route_settings(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::RouteSettings>,
            >,
        ) -> Self {
            self.inner = self.inner.set_route_settings(input);
            self
        }
        /// <p>The name of the stage.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stage_name(input.into());
            self
        }
        /// <p>The name of the stage.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stage_name(input);
            self
        }
        /// Adds a key-value pair to `StageVariables`.
        ///
        /// To override the contents of this collection use [`set_stage_variables`](Self::set_stage_variables).
        ///
        /// <p>A map that defines the stage variables for a Stage. Variable names can have alphanumeric and underscore characters, and the values must match [A-Za-z0-9-._~:/?#&amp;=,]+.</p>
        pub fn stage_variables(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.stage_variables(k.into(), v.into());
            self
        }
        /// <p>A map that defines the stage variables for a Stage. Variable names can have alphanumeric and underscore characters, and the values must match [A-Za-z0-9-._~:/?#&amp;=,]+.</p>
        pub fn set_stage_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_stage_variables(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateVpcLink`.
    ///
    /// <p>Creates a VPC link.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateVpcLink<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_vpc_link_input::Builder,
    }
    impl<C, M, R> CreateVpcLink<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateVpcLink`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateVpcLinkOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateVpcLinkError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateVpcLinkInputOperationOutputAlias,
                crate::output::CreateVpcLinkOutput,
                crate::error::CreateVpcLinkError,
                crate::input::CreateVpcLinkInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the VPC link.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the VPC link.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Appends an item to `SecurityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>A list of security group IDs for the VPC link.</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_group_ids(input.into());
            self
        }
        /// <p>A list of security group IDs for the VPC link.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_security_group_ids(input);
            self
        }
        /// Appends an item to `SubnetIds`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>A list of subnet IDs to include in the VPC link.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_ids(input.into());
            self
        }
        /// <p>A list of subnet IDs to include in the VPC link.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subnet_ids(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>A list of tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAccessLogSettings`.
    ///
    /// <p>Deletes the AccessLogSettings for a Stage. To disable access logging for a Stage, delete its AccessLogSettings.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAccessLogSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_access_log_settings_input::Builder,
    }
    impl<C, M, R> DeleteAccessLogSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAccessLogSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAccessLogSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAccessLogSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAccessLogSettingsInputOperationOutputAlias,
                crate::output::DeleteAccessLogSettingsOutput,
                crate::error::DeleteAccessLogSettingsError,
                crate::input::DeleteAccessLogSettingsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The stage name. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stage_name(input.into());
            self
        }
        /// <p>The stage name. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stage_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteApi`.
    ///
    /// <p>Deletes an Api resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteApi<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_api_input::Builder,
    }
    impl<C, M, R> DeleteApi<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteApi`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteApiOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteApiError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteApiInputOperationOutputAlias,
                crate::output::DeleteApiOutput,
                crate::error::DeleteApiError,
                crate::input::DeleteApiInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteApiMapping`.
    ///
    /// <p>Deletes an API mapping.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteApiMapping<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_api_mapping_input::Builder,
    }
    impl<C, M, R> DeleteApiMapping<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteApiMapping`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteApiMappingOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteApiMappingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteApiMappingInputOperationOutputAlias,
                crate::output::DeleteApiMappingOutput,
                crate::error::DeleteApiMappingError,
                crate::input::DeleteApiMappingInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API mapping identifier.</p>
        pub fn api_mapping_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_mapping_id(input.into());
            self
        }
        /// <p>The API mapping identifier.</p>
        pub fn set_api_mapping_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_api_mapping_id(input);
            self
        }
        /// <p>The domain name.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The domain name.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAuthorizer`.
    ///
    /// <p>Deletes an Authorizer.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAuthorizer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_authorizer_input::Builder,
    }
    impl<C, M, R> DeleteAuthorizer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAuthorizer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAuthorizerOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAuthorizerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAuthorizerInputOperationOutputAlias,
                crate::output::DeleteAuthorizerOutput,
                crate::error::DeleteAuthorizerError,
                crate::input::DeleteAuthorizerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The authorizer identifier.</p>
        pub fn authorizer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authorizer_id(input.into());
            self
        }
        /// <p>The authorizer identifier.</p>
        pub fn set_authorizer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authorizer_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCorsConfiguration`.
    ///
    /// <p>Deletes a CORS configuration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteCorsConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_cors_configuration_input::Builder,
    }
    impl<C, M, R> DeleteCorsConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteCorsConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCorsConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteCorsConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteCorsConfigurationInputOperationOutputAlias,
                crate::output::DeleteCorsConfigurationOutput,
                crate::error::DeleteCorsConfigurationError,
                crate::input::DeleteCorsConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDeployment`.
    ///
    /// <p>Deletes a Deployment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDeployment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_deployment_input::Builder,
    }
    impl<C, M, R> DeleteDeployment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDeployment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDeploymentOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDeploymentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDeploymentInputOperationOutputAlias,
                crate::output::DeleteDeploymentOutput,
                crate::error::DeleteDeploymentError,
                crate::input::DeleteDeploymentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The deployment ID.</p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_id(input.into());
            self
        }
        /// <p>The deployment ID.</p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDomainName`.
    ///
    /// <p>Deletes a domain name.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDomainName<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_domain_name_input::Builder,
    }
    impl<C, M, R> DeleteDomainName<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDomainName`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDomainNameOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDomainNameError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDomainNameInputOperationOutputAlias,
                crate::output::DeleteDomainNameOutput,
                crate::error::DeleteDomainNameError,
                crate::input::DeleteDomainNameInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The domain name.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The domain name.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteIntegration`.
    ///
    /// <p>Deletes an Integration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteIntegration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_integration_input::Builder,
    }
    impl<C, M, R> DeleteIntegration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteIntegration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteIntegrationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteIntegrationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteIntegrationInputOperationOutputAlias,
                crate::output::DeleteIntegrationOutput,
                crate::error::DeleteIntegrationError,
                crate::input::DeleteIntegrationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The integration ID.</p>
        pub fn integration_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.integration_id(input.into());
            self
        }
        /// <p>The integration ID.</p>
        pub fn set_integration_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_integration_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteIntegrationResponse`.
    ///
    /// <p>Deletes an IntegrationResponses.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteIntegrationResponse<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_integration_response_input::Builder,
    }
    impl<C, M, R> DeleteIntegrationResponse<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteIntegrationResponse`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteIntegrationResponseOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteIntegrationResponseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteIntegrationResponseInputOperationOutputAlias,
                crate::output::DeleteIntegrationResponseOutput,
                crate::error::DeleteIntegrationResponseError,
                crate::input::DeleteIntegrationResponseInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The integration ID.</p>
        pub fn integration_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.integration_id(input.into());
            self
        }
        /// <p>The integration ID.</p>
        pub fn set_integration_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_integration_id(input);
            self
        }
        /// <p>The integration response ID.</p>
        pub fn integration_response_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.integration_response_id(input.into());
            self
        }
        /// <p>The integration response ID.</p>
        pub fn set_integration_response_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_integration_response_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteModel`.
    ///
    /// <p>Deletes a Model.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteModel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_model_input::Builder,
    }
    impl<C, M, R> DeleteModel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteModelOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteModelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteModelInputOperationOutputAlias,
                crate::output::DeleteModelOutput,
                crate::error::DeleteModelError,
                crate::input::DeleteModelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The model ID.</p>
        pub fn model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_id(input.into());
            self
        }
        /// <p>The model ID.</p>
        pub fn set_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_model_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRoute`.
    ///
    /// <p>Deletes a Route.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteRoute<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_route_input::Builder,
    }
    impl<C, M, R> DeleteRoute<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRoute`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRouteOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRouteError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRouteInputOperationOutputAlias,
                crate::output::DeleteRouteOutput,
                crate::error::DeleteRouteError,
                crate::input::DeleteRouteInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The route ID.</p>
        pub fn route_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.route_id(input.into());
            self
        }
        /// <p>The route ID.</p>
        pub fn set_route_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_route_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRouteRequestParameter`.
    ///
    /// <p>Deletes a route request parameter.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteRouteRequestParameter<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_route_request_parameter_input::Builder,
    }
    impl<C, M, R> DeleteRouteRequestParameter<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRouteRequestParameter`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRouteRequestParameterOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRouteRequestParameterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRouteRequestParameterInputOperationOutputAlias,
                crate::output::DeleteRouteRequestParameterOutput,
                crate::error::DeleteRouteRequestParameterError,
                crate::input::DeleteRouteRequestParameterInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The route request parameter key.</p>
        pub fn request_parameter_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.request_parameter_key(input.into());
            self
        }
        /// <p>The route request parameter key.</p>
        pub fn set_request_parameter_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_request_parameter_key(input);
            self
        }
        /// <p>The route ID.</p>
        pub fn route_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.route_id(input.into());
            self
        }
        /// <p>The route ID.</p>
        pub fn set_route_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_route_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRouteResponse`.
    ///
    /// <p>Deletes a RouteResponse.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteRouteResponse<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_route_response_input::Builder,
    }
    impl<C, M, R> DeleteRouteResponse<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRouteResponse`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRouteResponseOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRouteResponseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRouteResponseInputOperationOutputAlias,
                crate::output::DeleteRouteResponseOutput,
                crate::error::DeleteRouteResponseError,
                crate::input::DeleteRouteResponseInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The route ID.</p>
        pub fn route_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.route_id(input.into());
            self
        }
        /// <p>The route ID.</p>
        pub fn set_route_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_route_id(input);
            self
        }
        /// <p>The route response ID.</p>
        pub fn route_response_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.route_response_id(input.into());
            self
        }
        /// <p>The route response ID.</p>
        pub fn set_route_response_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_route_response_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRouteSettings`.
    ///
    /// <p>Deletes the RouteSettings for a stage.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteRouteSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_route_settings_input::Builder,
    }
    impl<C, M, R> DeleteRouteSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRouteSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRouteSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRouteSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRouteSettingsInputOperationOutputAlias,
                crate::output::DeleteRouteSettingsOutput,
                crate::error::DeleteRouteSettingsError,
                crate::input::DeleteRouteSettingsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The route key.</p>
        pub fn route_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.route_key(input.into());
            self
        }
        /// <p>The route key.</p>
        pub fn set_route_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_route_key(input);
            self
        }
        /// <p>The stage name. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stage_name(input.into());
            self
        }
        /// <p>The stage name. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stage_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteStage`.
    ///
    /// <p>Deletes a Stage.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteStage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_stage_input::Builder,
    }
    impl<C, M, R> DeleteStage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteStage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteStageOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteStageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteStageInputOperationOutputAlias,
                crate::output::DeleteStageOutput,
                crate::error::DeleteStageError,
                crate::input::DeleteStageInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The stage name. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stage_name(input.into());
            self
        }
        /// <p>The stage name. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stage_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteVpcLink`.
    ///
    /// <p>Deletes a VPC link.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteVpcLink<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_vpc_link_input::Builder,
    }
    impl<C, M, R> DeleteVpcLink<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteVpcLink`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteVpcLinkOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteVpcLinkError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteVpcLinkInputOperationOutputAlias,
                crate::output::DeleteVpcLinkOutput,
                crate::error::DeleteVpcLinkError,
                crate::input::DeleteVpcLinkInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the VPC link.</p>
        pub fn vpc_link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_link_id(input.into());
            self
        }
        /// <p>The ID of the VPC link.</p>
        pub fn set_vpc_link_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_vpc_link_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ExportApi`.
    ///
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ExportApi<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::export_api_input::Builder,
    }
    impl<C, M, R> ExportApi<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ExportApi`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ExportApiOutput,
            aws_smithy_http::result::SdkError<crate::error::ExportApiError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ExportApiInputOperationOutputAlias,
                crate::output::ExportApiOutput,
                crate::error::ExportApiError,
                crate::input::ExportApiInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The version of the API Gateway export algorithm. API Gateway uses the latest version by default. Currently, the only supported version is 1.0.</p>
        pub fn export_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.export_version(input.into());
            self
        }
        /// <p>The version of the API Gateway export algorithm. API Gateway uses the latest version by default. Currently, the only supported version is 1.0.</p>
        pub fn set_export_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_export_version(input);
            self
        }
        /// <p>Specifies whether to include <a href="https://docs.aws.amazon.com//apigateway/latest/developerguide/api-gateway-swagger-extensions.html">API Gateway extensions</a> in the exported API definition. API Gateway extensions are included by default.</p>
        pub fn include_extensions(mut self, input: bool) -> Self {
            self.inner = self.inner.include_extensions(input);
            self
        }
        /// <p>Specifies whether to include <a href="https://docs.aws.amazon.com//apigateway/latest/developerguide/api-gateway-swagger-extensions.html">API Gateway extensions</a> in the exported API definition. API Gateway extensions are included by default.</p>
        pub fn set_include_extensions(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_extensions(input);
            self
        }
        /// <p>The output type of the exported definition file. Valid values are JSON and YAML.</p>
        pub fn output_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.output_type(input.into());
            self
        }
        /// <p>The output type of the exported definition file. Valid values are JSON and YAML.</p>
        pub fn set_output_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_output_type(input);
            self
        }
        /// <p>The version of the API specification to use. OAS30, for OpenAPI 3.0, is the only supported value.</p>
        pub fn specification(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.specification(input.into());
            self
        }
        /// <p>The version of the API specification to use. OAS30, for OpenAPI 3.0, is the only supported value.</p>
        pub fn set_specification(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_specification(input);
            self
        }
        /// <p>The name of the API stage to export. If you don't specify this property, a representation of the latest API configuration is exported.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stage_name(input.into());
            self
        }
        /// <p>The name of the API stage to export. If you don't specify this property, a representation of the latest API configuration is exported.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stage_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetApi`.
    ///
    /// <p>Gets an Api resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetApi<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_api_input::Builder,
    }
    impl<C, M, R> GetApi<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetApi`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetApiOutput,
            aws_smithy_http::result::SdkError<crate::error::GetApiError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetApiInputOperationOutputAlias,
                crate::output::GetApiOutput,
                crate::error::GetApiError,
                crate::input::GetApiInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetApiMapping`.
    ///
    /// <p>Gets an API mapping.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetApiMapping<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_api_mapping_input::Builder,
    }
    impl<C, M, R> GetApiMapping<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetApiMapping`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetApiMappingOutput,
            aws_smithy_http::result::SdkError<crate::error::GetApiMappingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetApiMappingInputOperationOutputAlias,
                crate::output::GetApiMappingOutput,
                crate::error::GetApiMappingError,
                crate::input::GetApiMappingInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API mapping identifier.</p>
        pub fn api_mapping_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_mapping_id(input.into());
            self
        }
        /// <p>The API mapping identifier.</p>
        pub fn set_api_mapping_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_api_mapping_id(input);
            self
        }
        /// <p>The domain name.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The domain name.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetApiMappings`.
    ///
    /// <p>Gets API mappings.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetApiMappings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_api_mappings_input::Builder,
    }
    impl<C, M, R> GetApiMappings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetApiMappings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetApiMappingsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetApiMappingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetApiMappingsInputOperationOutputAlias,
                crate::output::GetApiMappingsOutput,
                crate::error::GetApiMappingsError,
                crate::input::GetApiMappingsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The domain name.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The domain name.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn max_results(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.max_results(input.into());
            self
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetApis`.
    ///
    /// <p>Gets a collection of Api resources.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetApis<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_apis_input::Builder,
    }
    impl<C, M, R> GetApis<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetApis`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetApisOutput,
            aws_smithy_http::result::SdkError<crate::error::GetApisError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetApisInputOperationOutputAlias,
                crate::output::GetApisOutput,
                crate::error::GetApisError,
                crate::input::GetApisInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn max_results(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.max_results(input.into());
            self
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAuthorizer`.
    ///
    /// <p>Gets an Authorizer.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAuthorizer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_authorizer_input::Builder,
    }
    impl<C, M, R> GetAuthorizer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAuthorizer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAuthorizerOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAuthorizerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAuthorizerInputOperationOutputAlias,
                crate::output::GetAuthorizerOutput,
                crate::error::GetAuthorizerError,
                crate::input::GetAuthorizerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The authorizer identifier.</p>
        pub fn authorizer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authorizer_id(input.into());
            self
        }
        /// <p>The authorizer identifier.</p>
        pub fn set_authorizer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authorizer_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAuthorizers`.
    ///
    /// <p>Gets the Authorizers for an API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAuthorizers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_authorizers_input::Builder,
    }
    impl<C, M, R> GetAuthorizers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAuthorizers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAuthorizersOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAuthorizersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAuthorizersInputOperationOutputAlias,
                crate::output::GetAuthorizersOutput,
                crate::error::GetAuthorizersError,
                crate::input::GetAuthorizersInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn max_results(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.max_results(input.into());
            self
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDeployment`.
    ///
    /// <p>Gets a Deployment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDeployment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_deployment_input::Builder,
    }
    impl<C, M, R> GetDeployment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDeployment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDeploymentOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDeploymentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDeploymentInputOperationOutputAlias,
                crate::output::GetDeploymentOutput,
                crate::error::GetDeploymentError,
                crate::input::GetDeploymentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The deployment ID.</p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_id(input.into());
            self
        }
        /// <p>The deployment ID.</p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDeployments`.
    ///
    /// <p>Gets the Deployments for an API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDeployments<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_deployments_input::Builder,
    }
    impl<C, M, R> GetDeployments<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDeployments`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDeploymentsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDeploymentsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDeploymentsInputOperationOutputAlias,
                crate::output::GetDeploymentsOutput,
                crate::error::GetDeploymentsError,
                crate::input::GetDeploymentsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn max_results(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.max_results(input.into());
            self
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDomainName`.
    ///
    /// <p>Gets a domain name.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDomainName<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_domain_name_input::Builder,
    }
    impl<C, M, R> GetDomainName<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDomainName`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDomainNameOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDomainNameError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDomainNameInputOperationOutputAlias,
                crate::output::GetDomainNameOutput,
                crate::error::GetDomainNameError,
                crate::input::GetDomainNameInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The domain name.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The domain name.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDomainNames`.
    ///
    /// <p>Gets the domain names for an AWS account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDomainNames<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_domain_names_input::Builder,
    }
    impl<C, M, R> GetDomainNames<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDomainNames`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDomainNamesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDomainNamesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDomainNamesInputOperationOutputAlias,
                crate::output::GetDomainNamesOutput,
                crate::error::GetDomainNamesError,
                crate::input::GetDomainNamesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn max_results(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.max_results(input.into());
            self
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetIntegration`.
    ///
    /// <p>Gets an Integration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetIntegration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_integration_input::Builder,
    }
    impl<C, M, R> GetIntegration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetIntegration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetIntegrationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetIntegrationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetIntegrationInputOperationOutputAlias,
                crate::output::GetIntegrationOutput,
                crate::error::GetIntegrationError,
                crate::input::GetIntegrationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The integration ID.</p>
        pub fn integration_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.integration_id(input.into());
            self
        }
        /// <p>The integration ID.</p>
        pub fn set_integration_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_integration_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetIntegrationResponse`.
    ///
    /// <p>Gets an IntegrationResponses.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetIntegrationResponse<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_integration_response_input::Builder,
    }
    impl<C, M, R> GetIntegrationResponse<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetIntegrationResponse`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetIntegrationResponseOutput,
            aws_smithy_http::result::SdkError<crate::error::GetIntegrationResponseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetIntegrationResponseInputOperationOutputAlias,
                crate::output::GetIntegrationResponseOutput,
                crate::error::GetIntegrationResponseError,
                crate::input::GetIntegrationResponseInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The integration ID.</p>
        pub fn integration_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.integration_id(input.into());
            self
        }
        /// <p>The integration ID.</p>
        pub fn set_integration_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_integration_id(input);
            self
        }
        /// <p>The integration response ID.</p>
        pub fn integration_response_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.integration_response_id(input.into());
            self
        }
        /// <p>The integration response ID.</p>
        pub fn set_integration_response_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_integration_response_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetIntegrationResponses`.
    ///
    /// <p>Gets the IntegrationResponses for an Integration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetIntegrationResponses<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_integration_responses_input::Builder,
    }
    impl<C, M, R> GetIntegrationResponses<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetIntegrationResponses`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetIntegrationResponsesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetIntegrationResponsesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetIntegrationResponsesInputOperationOutputAlias,
                crate::output::GetIntegrationResponsesOutput,
                crate::error::GetIntegrationResponsesError,
                crate::input::GetIntegrationResponsesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The integration ID.</p>
        pub fn integration_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.integration_id(input.into());
            self
        }
        /// <p>The integration ID.</p>
        pub fn set_integration_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_integration_id(input);
            self
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn max_results(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.max_results(input.into());
            self
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetIntegrations`.
    ///
    /// <p>Gets the Integrations for an API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetIntegrations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_integrations_input::Builder,
    }
    impl<C, M, R> GetIntegrations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetIntegrations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetIntegrationsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetIntegrationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetIntegrationsInputOperationOutputAlias,
                crate::output::GetIntegrationsOutput,
                crate::error::GetIntegrationsError,
                crate::input::GetIntegrationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn max_results(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.max_results(input.into());
            self
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetModel`.
    ///
    /// <p>Gets a Model.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetModel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_model_input::Builder,
    }
    impl<C, M, R> GetModel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetModelOutput,
            aws_smithy_http::result::SdkError<crate::error::GetModelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetModelInputOperationOutputAlias,
                crate::output::GetModelOutput,
                crate::error::GetModelError,
                crate::input::GetModelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The model ID.</p>
        pub fn model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_id(input.into());
            self
        }
        /// <p>The model ID.</p>
        pub fn set_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_model_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetModels`.
    ///
    /// <p>Gets the Models for an API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetModels<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_models_input::Builder,
    }
    impl<C, M, R> GetModels<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetModels`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetModelsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetModelsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetModelsInputOperationOutputAlias,
                crate::output::GetModelsOutput,
                crate::error::GetModelsError,
                crate::input::GetModelsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn max_results(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.max_results(input.into());
            self
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetModelTemplate`.
    ///
    /// <p>Gets a model template.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetModelTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_model_template_input::Builder,
    }
    impl<C, M, R> GetModelTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetModelTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetModelTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::GetModelTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetModelTemplateInputOperationOutputAlias,
                crate::output::GetModelTemplateOutput,
                crate::error::GetModelTemplateError,
                crate::input::GetModelTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The model ID.</p>
        pub fn model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_id(input.into());
            self
        }
        /// <p>The model ID.</p>
        pub fn set_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_model_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRoute`.
    ///
    /// <p>Gets a Route.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetRoute<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_route_input::Builder,
    }
    impl<C, M, R> GetRoute<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRoute`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRouteOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRouteError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRouteInputOperationOutputAlias,
                crate::output::GetRouteOutput,
                crate::error::GetRouteError,
                crate::input::GetRouteInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The route ID.</p>
        pub fn route_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.route_id(input.into());
            self
        }
        /// <p>The route ID.</p>
        pub fn set_route_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_route_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRouteResponse`.
    ///
    /// <p>Gets a RouteResponse.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetRouteResponse<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_route_response_input::Builder,
    }
    impl<C, M, R> GetRouteResponse<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRouteResponse`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRouteResponseOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRouteResponseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRouteResponseInputOperationOutputAlias,
                crate::output::GetRouteResponseOutput,
                crate::error::GetRouteResponseError,
                crate::input::GetRouteResponseInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The route ID.</p>
        pub fn route_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.route_id(input.into());
            self
        }
        /// <p>The route ID.</p>
        pub fn set_route_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_route_id(input);
            self
        }
        /// <p>The route response ID.</p>
        pub fn route_response_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.route_response_id(input.into());
            self
        }
        /// <p>The route response ID.</p>
        pub fn set_route_response_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_route_response_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRouteResponses`.
    ///
    /// <p>Gets the RouteResponses for a Route.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetRouteResponses<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_route_responses_input::Builder,
    }
    impl<C, M, R> GetRouteResponses<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRouteResponses`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRouteResponsesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRouteResponsesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRouteResponsesInputOperationOutputAlias,
                crate::output::GetRouteResponsesOutput,
                crate::error::GetRouteResponsesError,
                crate::input::GetRouteResponsesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn max_results(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.max_results(input.into());
            self
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The route ID.</p>
        pub fn route_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.route_id(input.into());
            self
        }
        /// <p>The route ID.</p>
        pub fn set_route_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_route_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRoutes`.
    ///
    /// <p>Gets the Routes for an API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetRoutes<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_routes_input::Builder,
    }
    impl<C, M, R> GetRoutes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRoutes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRoutesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRoutesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRoutesInputOperationOutputAlias,
                crate::output::GetRoutesOutput,
                crate::error::GetRoutesError,
                crate::input::GetRoutesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn max_results(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.max_results(input.into());
            self
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetStage`.
    ///
    /// <p>Gets a Stage.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetStage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_stage_input::Builder,
    }
    impl<C, M, R> GetStage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetStage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetStageOutput,
            aws_smithy_http::result::SdkError<crate::error::GetStageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetStageInputOperationOutputAlias,
                crate::output::GetStageOutput,
                crate::error::GetStageError,
                crate::input::GetStageInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The stage name. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stage_name(input.into());
            self
        }
        /// <p>The stage name. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stage_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetStages`.
    ///
    /// <p>Gets the Stages for an API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetStages<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_stages_input::Builder,
    }
    impl<C, M, R> GetStages<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetStages`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetStagesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetStagesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetStagesInputOperationOutputAlias,
                crate::output::GetStagesOutput,
                crate::error::GetStagesError,
                crate::input::GetStagesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn max_results(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.max_results(input.into());
            self
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetTags`.
    ///
    /// <p>Gets a collection of Tag resources.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetTags<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_tags_input::Builder,
    }
    impl<C, M, R> GetTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetTagsInputOperationOutputAlias,
                crate::output::GetTagsOutput,
                crate::error::GetTagsError,
                crate::input::GetTagsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The resource ARN for the tag.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The resource ARN for the tag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetVpcLink`.
    ///
    /// <p>Gets a VPC link.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetVpcLink<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_vpc_link_input::Builder,
    }
    impl<C, M, R> GetVpcLink<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetVpcLink`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetVpcLinkOutput,
            aws_smithy_http::result::SdkError<crate::error::GetVpcLinkError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetVpcLinkInputOperationOutputAlias,
                crate::output::GetVpcLinkOutput,
                crate::error::GetVpcLinkError,
                crate::input::GetVpcLinkInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the VPC link.</p>
        pub fn vpc_link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_link_id(input.into());
            self
        }
        /// <p>The ID of the VPC link.</p>
        pub fn set_vpc_link_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_vpc_link_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetVpcLinks`.
    ///
    /// <p>Gets a collection of VPC links.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetVpcLinks<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_vpc_links_input::Builder,
    }
    impl<C, M, R> GetVpcLinks<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetVpcLinks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetVpcLinksOutput,
            aws_smithy_http::result::SdkError<crate::error::GetVpcLinksError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetVpcLinksInputOperationOutputAlias,
                crate::output::GetVpcLinksOutput,
                crate::error::GetVpcLinksError,
                crate::input::GetVpcLinksInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn max_results(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.max_results(input.into());
            self
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ImportApi`.
    ///
    /// <p>Imports an API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ImportApi<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::import_api_input::Builder,
    }
    impl<C, M, R> ImportApi<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ImportApi`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ImportApiOutput,
            aws_smithy_http::result::SdkError<crate::error::ImportApiError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ImportApiInputOperationOutputAlias,
                crate::output::ImportApiOutput,
                crate::error::ImportApiError,
                crate::input::ImportApiInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies how to interpret the base path of the API during import. Valid values are ignore, prepend, and split. The default value is ignore. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-import-api-basePath.html">Set the OpenAPI basePath Property</a>. Supported only for HTTP APIs.</p>
        pub fn basepath(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.basepath(input.into());
            self
        }
        /// <p>Specifies how to interpret the base path of the API during import. Valid values are ignore, prepend, and split. The default value is ignore. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-import-api-basePath.html">Set the OpenAPI basePath Property</a>. Supported only for HTTP APIs.</p>
        pub fn set_basepath(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_basepath(input);
            self
        }
        /// <p>The OpenAPI definition. Supported only for HTTP APIs.</p>
        pub fn body(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.body(input.into());
            self
        }
        /// <p>The OpenAPI definition. Supported only for HTTP APIs.</p>
        pub fn set_body(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_body(input);
            self
        }
        /// <p>Specifies whether to rollback the API creation when a warning is encountered. By default, API creation continues if a warning is encountered.</p>
        pub fn fail_on_warnings(mut self, input: bool) -> Self {
            self.inner = self.inner.fail_on_warnings(input);
            self
        }
        /// <p>Specifies whether to rollback the API creation when a warning is encountered. By default, API creation continues if a warning is encountered.</p>
        pub fn set_fail_on_warnings(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_fail_on_warnings(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ReimportApi`.
    ///
    /// <p>Puts an Api resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ReimportApi<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::reimport_api_input::Builder,
    }
    impl<C, M, R> ReimportApi<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ReimportApi`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ReimportApiOutput,
            aws_smithy_http::result::SdkError<crate::error::ReimportApiError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ReimportApiInputOperationOutputAlias,
                crate::output::ReimportApiOutput,
                crate::error::ReimportApiError,
                crate::input::ReimportApiInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>Specifies how to interpret the base path of the API during import. Valid values are ignore, prepend, and split. The default value is ignore. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-import-api-basePath.html">Set the OpenAPI basePath Property</a>. Supported only for HTTP APIs.</p>
        pub fn basepath(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.basepath(input.into());
            self
        }
        /// <p>Specifies how to interpret the base path of the API during import. Valid values are ignore, prepend, and split. The default value is ignore. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-import-api-basePath.html">Set the OpenAPI basePath Property</a>. Supported only for HTTP APIs.</p>
        pub fn set_basepath(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_basepath(input);
            self
        }
        /// <p>The OpenAPI definition. Supported only for HTTP APIs.</p>
        pub fn body(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.body(input.into());
            self
        }
        /// <p>The OpenAPI definition. Supported only for HTTP APIs.</p>
        pub fn set_body(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_body(input);
            self
        }
        /// <p>Specifies whether to rollback the API creation when a warning is encountered. By default, API creation continues if a warning is encountered.</p>
        pub fn fail_on_warnings(mut self, input: bool) -> Self {
            self.inner = self.inner.fail_on_warnings(input);
            self
        }
        /// <p>Specifies whether to rollback the API creation when a warning is encountered. By default, API creation continues if a warning is encountered.</p>
        pub fn set_fail_on_warnings(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_fail_on_warnings(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ResetAuthorizersCache`.
    ///
    /// <p>Resets all authorizer cache entries on a stage. Supported only for HTTP APIs.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ResetAuthorizersCache<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::reset_authorizers_cache_input::Builder,
    }
    impl<C, M, R> ResetAuthorizersCache<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ResetAuthorizersCache`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ResetAuthorizersCacheOutput,
            aws_smithy_http::result::SdkError<crate::error::ResetAuthorizersCacheError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ResetAuthorizersCacheInputOperationOutputAlias,
                crate::output::ResetAuthorizersCacheOutput,
                crate::error::ResetAuthorizersCacheError,
                crate::input::ResetAuthorizersCacheInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The stage name. Stage names can contain only alphanumeric characters, hyphens, and underscores, or be $default. Maximum length is 128 characters.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stage_name(input.into());
            self
        }
        /// <p>The stage name. Stage names can contain only alphanumeric characters, hyphens, and underscores, or be $default. Maximum length is 128 characters.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stage_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Creates a new Tag resource to represent a tag.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The resource ARN for the tag.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The resource ARN for the tag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Deletes a Tag.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The resource ARN for the tag.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The resource ARN for the tag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The Tag keys to delete</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The Tag keys to delete</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateApi`.
    ///
    /// <p>Updates an Api resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateApi<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_api_input::Builder,
    }
    impl<C, M, R> UpdateApi<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateApi`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateApiOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateApiError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateApiInputOperationOutputAlias,
                crate::output::UpdateApiOutput,
                crate::error::UpdateApiError,
                crate::input::UpdateApiInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>An API key selection expression. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions">API Key Selection Expressions</a>.</p>
        pub fn api_key_selection_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.api_key_selection_expression(input.into());
            self
        }
        /// <p>An API key selection expression. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions">API Key Selection Expressions</a>.</p>
        pub fn set_api_key_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_api_key_selection_expression(input);
            self
        }
        /// <p>A CORS configuration. Supported only for HTTP APIs.</p>
        pub fn cors_configuration(mut self, input: crate::model::Cors) -> Self {
            self.inner = self.inner.cors_configuration(input);
            self
        }
        /// <p>A CORS configuration. Supported only for HTTP APIs.</p>
        pub fn set_cors_configuration(
            mut self,
            input: std::option::Option<crate::model::Cors>,
        ) -> Self {
            self.inner = self.inner.set_cors_configuration(input);
            self
        }
        /// <p>This property is part of quick create. It specifies the credentials required for the integration, if any. For a Lambda integration, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, don't specify this parameter. Currently, this property is not used for HTTP integrations. If provided, this value replaces the credentials associated with the quick create integration. Supported only for HTTP APIs.</p>
        pub fn credentials_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.credentials_arn(input.into());
            self
        }
        /// <p>This property is part of quick create. It specifies the credentials required for the integration, if any. For a Lambda integration, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, don't specify this parameter. Currently, this property is not used for HTTP integrations. If provided, this value replaces the credentials associated with the quick create integration. Supported only for HTTP APIs.</p>
        pub fn set_credentials_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_credentials_arn(input);
            self
        }
        /// <p>The description of the API.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the API.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Avoid validating models when creating a deployment. Supported only for WebSocket APIs.</p>
        pub fn disable_schema_validation(mut self, input: bool) -> Self {
            self.inner = self.inner.disable_schema_validation(input);
            self
        }
        /// <p>Avoid validating models when creating a deployment. Supported only for WebSocket APIs.</p>
        pub fn set_disable_schema_validation(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_disable_schema_validation(input);
            self
        }
        /// <p>Specifies whether clients can invoke your API by using the default execute-api endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
        pub fn disable_execute_api_endpoint(mut self, input: bool) -> Self {
            self.inner = self.inner.disable_execute_api_endpoint(input);
            self
        }
        /// <p>Specifies whether clients can invoke your API by using the default execute-api endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
        pub fn set_disable_execute_api_endpoint(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_disable_execute_api_endpoint(input);
            self
        }
        /// <p>The name of the API.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the API.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>This property is part of quick create. If not specified, the route created using quick create is kept. Otherwise, this value replaces the route key of the quick create route. Additional routes may still be added after the API is updated. Supported only for HTTP APIs.</p>
        pub fn route_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.route_key(input.into());
            self
        }
        /// <p>This property is part of quick create. If not specified, the route created using quick create is kept. Otherwise, this value replaces the route key of the quick create route. Additional routes may still be added after the API is updated. Supported only for HTTP APIs.</p>
        pub fn set_route_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_route_key(input);
            self
        }
        /// <p>The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.</p>
        pub fn route_selection_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.route_selection_expression(input.into());
            self
        }
        /// <p>The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.</p>
        pub fn set_route_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_route_selection_expression(input);
            self
        }
        /// <p>This property is part of quick create. For HTTP integrations, specify a fully qualified URL. For Lambda integrations, specify a function ARN. The type of the integration will be HTTP_PROXY or AWS_PROXY, respectively. The value provided updates the integration URI and integration type. You can update a quick-created target, but you can't remove it from an API. Supported only for HTTP APIs.</p>
        pub fn target(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target(input.into());
            self
        }
        /// <p>This property is part of quick create. For HTTP integrations, specify a fully qualified URL. For Lambda integrations, specify a function ARN. The type of the integration will be HTTP_PROXY or AWS_PROXY, respectively. The value provided updates the integration URI and integration type. You can update a quick-created target, but you can't remove it from an API. Supported only for HTTP APIs.</p>
        pub fn set_target(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_target(input);
            self
        }
        /// <p>A version identifier for the API.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(input.into());
            self
        }
        /// <p>A version identifier for the API.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateApiMapping`.
    ///
    /// <p>The API mapping.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateApiMapping<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_api_mapping_input::Builder,
    }
    impl<C, M, R> UpdateApiMapping<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateApiMapping`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateApiMappingOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateApiMappingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateApiMappingInputOperationOutputAlias,
                crate::output::UpdateApiMappingOutput,
                crate::error::UpdateApiMappingError,
                crate::input::UpdateApiMappingInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The API mapping identifier.</p>
        pub fn api_mapping_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_mapping_id(input.into());
            self
        }
        /// <p>The API mapping identifier.</p>
        pub fn set_api_mapping_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_api_mapping_id(input);
            self
        }
        /// <p>The API mapping key.</p>
        pub fn api_mapping_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_mapping_key(input.into());
            self
        }
        /// <p>The API mapping key.</p>
        pub fn set_api_mapping_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_api_mapping_key(input);
            self
        }
        /// <p>The domain name.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The domain name.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The API stage.</p>
        pub fn stage(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stage(input.into());
            self
        }
        /// <p>The API stage.</p>
        pub fn set_stage(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stage(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAuthorizer`.
    ///
    /// <p>Updates an Authorizer.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateAuthorizer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_authorizer_input::Builder,
    }
    impl<C, M, R> UpdateAuthorizer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateAuthorizer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAuthorizerOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAuthorizerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateAuthorizerInputOperationOutputAlias,
                crate::output::UpdateAuthorizerOutput,
                crate::error::UpdateAuthorizerError,
                crate::input::UpdateAuthorizerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, don't specify this parameter.</p>
        pub fn authorizer_credentials_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authorizer_credentials_arn(input.into());
            self
        }
        /// <p>Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, don't specify this parameter.</p>
        pub fn set_authorizer_credentials_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authorizer_credentials_arn(input);
            self
        }
        /// <p>The authorizer identifier.</p>
        pub fn authorizer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authorizer_id(input.into());
            self
        }
        /// <p>The authorizer identifier.</p>
        pub fn set_authorizer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authorizer_id(input);
            self
        }
        /// <p>Specifies the format of the payload sent to an HTTP API Lambda authorizer. Required for HTTP API Lambda authorizers. Supported values are 1.0 and 2.0. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p>
        pub fn authorizer_payload_format_version(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.authorizer_payload_format_version(input.into());
            self
        }
        /// <p>Specifies the format of the payload sent to an HTTP API Lambda authorizer. Required for HTTP API Lambda authorizers. Supported values are 1.0 and 2.0. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p>
        pub fn set_authorizer_payload_format_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authorizer_payload_format_version(input);
            self
        }
        /// <p>The time to live (TTL) for cached authorizer results, in seconds. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway caches authorizer responses. The maximum value is 3600, or 1 hour. Supported only for HTTP API Lambda authorizers.</p>
        pub fn authorizer_result_ttl_in_seconds(mut self, input: i32) -> Self {
            self.inner = self.inner.authorizer_result_ttl_in_seconds(input);
            self
        }
        /// <p>The time to live (TTL) for cached authorizer results, in seconds. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway caches authorizer responses. The maximum value is 3600, or 1 hour. Supported only for HTTP API Lambda authorizers.</p>
        pub fn set_authorizer_result_ttl_in_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_authorizer_result_ttl_in_seconds(input);
            self
        }
        /// <p>The authorizer type. Specify REQUEST for a Lambda function using incoming request parameters. Specify JWT to use JSON Web Tokens (supported only for HTTP APIs).</p>
        pub fn authorizer_type(mut self, input: crate::model::AuthorizerType) -> Self {
            self.inner = self.inner.authorizer_type(input);
            self
        }
        /// <p>The authorizer type. Specify REQUEST for a Lambda function using incoming request parameters. Specify JWT to use JSON Web Tokens (supported only for HTTP APIs).</p>
        pub fn set_authorizer_type(
            mut self,
            input: std::option::Option<crate::model::AuthorizerType>,
        ) -> Self {
            self.inner = self.inner.set_authorizer_type(input);
            self
        }
        /// <p>The authorizer's Uniform Resource Identifier (URI). For REQUEST authorizers, this must be a well-formed Lambda function URI, for example, arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:<replaceable>
        /// {account_id}
        /// </replaceable>:function:<replaceable>
        /// {lambda_function_name}
        /// </replaceable>/invocations. In general, the URI has this form: arn:aws:apigateway:<replaceable>
        /// {region}
        /// </replaceable>:lambda:path/<replaceable>
        /// {service_api}
        /// </replaceable> , where <replaceable></replaceable>{region} is the same as the region hosting the Lambda function, path indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial /. For Lambda functions, this is usually of the form /2015-03-31/functions/[FunctionARN]/invocations. Supported only for REQUEST authorizers.</p>
        pub fn authorizer_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authorizer_uri(input.into());
            self
        }
        /// <p>The authorizer's Uniform Resource Identifier (URI). For REQUEST authorizers, this must be a well-formed Lambda function URI, for example, arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:<replaceable>
        /// {account_id}
        /// </replaceable>:function:<replaceable>
        /// {lambda_function_name}
        /// </replaceable>/invocations. In general, the URI has this form: arn:aws:apigateway:<replaceable>
        /// {region}
        /// </replaceable>:lambda:path/<replaceable>
        /// {service_api}
        /// </replaceable> , where <replaceable></replaceable>{region} is the same as the region hosting the Lambda function, path indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial /. For Lambda functions, this is usually of the form /2015-03-31/functions/[FunctionARN]/invocations. Supported only for REQUEST authorizers.</p>
        pub fn set_authorizer_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authorizer_uri(input);
            self
        }
        /// <p>Specifies whether a Lambda authorizer returns a response in a simple format. By default, a Lambda authorizer must return an IAM policy. If enabled, the Lambda authorizer can return a boolean value instead of an IAM policy. Supported only for HTTP APIs. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a></p>
        pub fn enable_simple_responses(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_simple_responses(input);
            self
        }
        /// <p>Specifies whether a Lambda authorizer returns a response in a simple format. By default, a Lambda authorizer must return an IAM policy. If enabled, the Lambda authorizer can return a boolean value instead of an IAM policy. Supported only for HTTP APIs. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a></p>
        pub fn set_enable_simple_responses(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_simple_responses(input);
            self
        }
        /// Appends an item to `IdentitySource`.
        ///
        /// To override the contents of this collection use [`set_identity_source`](Self::set_identity_source).
        ///
        /// <p>The identity source for which authorization is requested.</p>
        /// <p>For a REQUEST authorizer, this is optional. The value is a set of one or more mapping expressions of the specified request parameters. The identity source can be headers, query string parameters, stage variables, and context parameters. For example, if an Auth header and a Name query string parameter are defined as identity sources, this value is route.request.header.Auth, route.request.querystring.Name for WebSocket APIs. For HTTP APIs, use selection expressions prefixed with $, for example, $request.header.Auth, $request.querystring.Name. These parameters are used to perform runtime validation for Lambda-based authorizers by verifying all of the identity-related request parameters are present in the request, not null, and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function. Otherwise, it returns a 401 Unauthorized response without calling the Lambda function. For HTTP APIs, identity sources are also used as the cache key when caching is enabled. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p>
        /// <p>For JWT, a single entry that specifies where to extract the JSON Web Token (JWT) from inbound requests. Currently only header-based and query parameter-based selections are supported, for example $request.header.Authorization.</p>
        pub fn identity_source(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_source(input.into());
            self
        }
        /// <p>The identity source for which authorization is requested.</p>
        /// <p>For a REQUEST authorizer, this is optional. The value is a set of one or more mapping expressions of the specified request parameters. The identity source can be headers, query string parameters, stage variables, and context parameters. For example, if an Auth header and a Name query string parameter are defined as identity sources, this value is route.request.header.Auth, route.request.querystring.Name for WebSocket APIs. For HTTP APIs, use selection expressions prefixed with $, for example, $request.header.Auth, $request.querystring.Name. These parameters are used to perform runtime validation for Lambda-based authorizers by verifying all of the identity-related request parameters are present in the request, not null, and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function. Otherwise, it returns a 401 Unauthorized response without calling the Lambda function. For HTTP APIs, identity sources are also used as the cache key when caching is enabled. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p>
        /// <p>For JWT, a single entry that specifies where to extract the JSON Web Token (JWT) from inbound requests. Currently only header-based and query parameter-based selections are supported, for example $request.header.Authorization.</p>
        pub fn set_identity_source(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_identity_source(input);
            self
        }
        /// <p>This parameter is not used.</p>
        pub fn identity_validation_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.identity_validation_expression(input.into());
            self
        }
        /// <p>This parameter is not used.</p>
        pub fn set_identity_validation_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_validation_expression(input);
            self
        }
        /// <p>Represents the configuration of a JWT authorizer. Required for the JWT authorizer type. Supported only for HTTP APIs.</p>
        pub fn jwt_configuration(mut self, input: crate::model::JwtConfiguration) -> Self {
            self.inner = self.inner.jwt_configuration(input);
            self
        }
        /// <p>Represents the configuration of a JWT authorizer. Required for the JWT authorizer type. Supported only for HTTP APIs.</p>
        pub fn set_jwt_configuration(
            mut self,
            input: std::option::Option<crate::model::JwtConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_jwt_configuration(input);
            self
        }
        /// <p>The name of the authorizer.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the authorizer.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDeployment`.
    ///
    /// <p>Updates a Deployment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateDeployment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_deployment_input::Builder,
    }
    impl<C, M, R> UpdateDeployment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDeployment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDeploymentOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDeploymentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDeploymentInputOperationOutputAlias,
                crate::output::UpdateDeploymentOutput,
                crate::error::UpdateDeploymentError,
                crate::input::UpdateDeploymentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The deployment ID.</p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_id(input.into());
            self
        }
        /// <p>The deployment ID.</p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_id(input);
            self
        }
        /// <p>The description for the deployment resource.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description for the deployment resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDomainName`.
    ///
    /// <p>Updates a domain name.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateDomainName<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_domain_name_input::Builder,
    }
    impl<C, M, R> UpdateDomainName<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDomainName`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDomainNameOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDomainNameError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDomainNameInputOperationOutputAlias,
                crate::output::UpdateDomainNameOutput,
                crate::error::UpdateDomainNameError,
                crate::input::UpdateDomainNameInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The domain name.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The domain name.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// Appends an item to `DomainNameConfigurations`.
        ///
        /// To override the contents of this collection use [`set_domain_name_configurations`](Self::set_domain_name_configurations).
        ///
        /// <p>The domain name configurations.</p>
        pub fn domain_name_configurations(
            mut self,
            input: crate::model::DomainNameConfiguration,
        ) -> Self {
            self.inner = self.inner.domain_name_configurations(input);
            self
        }
        /// <p>The domain name configurations.</p>
        pub fn set_domain_name_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DomainNameConfiguration>>,
        ) -> Self {
            self.inner = self.inner.set_domain_name_configurations(input);
            self
        }
        /// <p>The mutual TLS authentication configuration for a custom domain name.</p>
        pub fn mutual_tls_authentication(
            mut self,
            input: crate::model::MutualTlsAuthenticationInput,
        ) -> Self {
            self.inner = self.inner.mutual_tls_authentication(input);
            self
        }
        /// <p>The mutual TLS authentication configuration for a custom domain name.</p>
        pub fn set_mutual_tls_authentication(
            mut self,
            input: std::option::Option<crate::model::MutualTlsAuthenticationInput>,
        ) -> Self {
            self.inner = self.inner.set_mutual_tls_authentication(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateIntegration`.
    ///
    /// <p>Updates an Integration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateIntegration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_integration_input::Builder,
    }
    impl<C, M, R> UpdateIntegration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateIntegration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateIntegrationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateIntegrationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateIntegrationInputOperationOutputAlias,
                crate::output::UpdateIntegrationOutput,
                crate::error::UpdateIntegrationError,
                crate::input::UpdateIntegrationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The ID of the VPC link for a private integration. Supported only for HTTP APIs.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_id(input.into());
            self
        }
        /// <p>The ID of the VPC link for a private integration. Supported only for HTTP APIs.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_id(input);
            self
        }
        /// <p>The type of the network connection to the integration endpoint. Specify INTERNET for connections through the public routable internet or VPC_LINK for private connections between API Gateway and resources in a VPC. The default value is INTERNET.</p>
        pub fn connection_type(mut self, input: crate::model::ConnectionType) -> Self {
            self.inner = self.inner.connection_type(input);
            self
        }
        /// <p>The type of the network connection to the integration endpoint. Specify INTERNET for connections through the public routable internet or VPC_LINK for private connections between API Gateway and resources in a VPC. The default value is INTERNET.</p>
        pub fn set_connection_type(
            mut self,
            input: std::option::Option<crate::model::ConnectionType>,
        ) -> Self {
            self.inner = self.inner.set_connection_type(input);
            self
        }
        /// <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p>
        /// <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p>
        /// <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p>
        /// <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
        pub fn content_handling_strategy(
            mut self,
            input: crate::model::ContentHandlingStrategy,
        ) -> Self {
            self.inner = self.inner.content_handling_strategy(input);
            self
        }
        /// <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p>
        /// <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p>
        /// <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p>
        /// <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
        pub fn set_content_handling_strategy(
            mut self,
            input: std::option::Option<crate::model::ContentHandlingStrategy>,
        ) -> Self {
            self.inner = self.inner.set_content_handling_strategy(input);
            self
        }
        /// <p>Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, specify null.</p>
        pub fn credentials_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.credentials_arn(input.into());
            self
        }
        /// <p>Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, specify null.</p>
        pub fn set_credentials_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_credentials_arn(input);
            self
        }
        /// <p>The description of the integration</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the integration</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The integration ID.</p>
        pub fn integration_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.integration_id(input.into());
            self
        }
        /// <p>The integration ID.</p>
        pub fn set_integration_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_integration_id(input);
            self
        }
        /// <p>Specifies the integration's HTTP method type.</p>
        pub fn integration_method(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.integration_method(input.into());
            self
        }
        /// <p>Specifies the integration's HTTP method type.</p>
        pub fn set_integration_method(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_integration_method(input);
            self
        }
        /// <p>Supported only for HTTP API AWS_PROXY integrations. Specifies the AWS service action to invoke. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html">Integration subtype reference</a>.</p>
        pub fn integration_subtype(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.integration_subtype(input.into());
            self
        }
        /// <p>Supported only for HTTP API AWS_PROXY integrations. Specifies the AWS service action to invoke. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html">Integration subtype reference</a>.</p>
        pub fn set_integration_subtype(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_integration_subtype(input);
            self
        }
        /// <p>The integration type of an integration. One of the following:</p>
        /// <p>AWS: for integrating the route or method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration. Supported only for WebSocket APIs.</p>
        /// <p>AWS_PROXY: for integrating the route or method request with a Lambda function or other AWS service action. This integration is also referred to as a Lambda proxy integration.</p>
        /// <p>HTTP: for integrating the route or method request with an HTTP endpoint. This integration is also referred to as the HTTP custom integration. Supported only for WebSocket APIs.</p>
        /// <p>HTTP_PROXY: for integrating the route or method request with an HTTP endpoint, with the client request passed through as-is. This is also referred to as HTTP proxy integration. For HTTP API private integrations, use an HTTP_PROXY integration.</p>
        /// <p>MOCK: for integrating the route or method request with API Gateway as a "loopback" endpoint without invoking any backend. Supported only for WebSocket APIs.</p>
        pub fn integration_type(mut self, input: crate::model::IntegrationType) -> Self {
            self.inner = self.inner.integration_type(input);
            self
        }
        /// <p>The integration type of an integration. One of the following:</p>
        /// <p>AWS: for integrating the route or method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration. Supported only for WebSocket APIs.</p>
        /// <p>AWS_PROXY: for integrating the route or method request with a Lambda function or other AWS service action. This integration is also referred to as a Lambda proxy integration.</p>
        /// <p>HTTP: for integrating the route or method request with an HTTP endpoint. This integration is also referred to as the HTTP custom integration. Supported only for WebSocket APIs.</p>
        /// <p>HTTP_PROXY: for integrating the route or method request with an HTTP endpoint, with the client request passed through as-is. This is also referred to as HTTP proxy integration. For HTTP API private integrations, use an HTTP_PROXY integration.</p>
        /// <p>MOCK: for integrating the route or method request with API Gateway as a "loopback" endpoint without invoking any backend. Supported only for WebSocket APIs.</p>
        pub fn set_integration_type(
            mut self,
            input: std::option::Option<crate::model::IntegrationType>,
        ) -> Self {
            self.inner = self.inner.set_integration_type(input);
            self
        }
        /// <p>For a Lambda integration, specify the URI of a Lambda function.</p>
        /// <p>For an HTTP integration, specify a fully-qualified URL.</p>
        /// <p>For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service. If you specify the ARN of an AWS Cloud Map service, API Gateway uses DiscoverInstances to identify resources. You can use query parameters to target specific resources. To learn more, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_DiscoverInstances.html">DiscoverInstances</a>. For private integrations, all resources must be owned by the same AWS account.</p>
        pub fn integration_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.integration_uri(input.into());
            self
        }
        /// <p>For a Lambda integration, specify the URI of a Lambda function.</p>
        /// <p>For an HTTP integration, specify a fully-qualified URL.</p>
        /// <p>For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service. If you specify the ARN of an AWS Cloud Map service, API Gateway uses DiscoverInstances to identify resources. You can use query parameters to target specific resources. To learn more, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_DiscoverInstances.html">DiscoverInstances</a>. For private integrations, all resources must be owned by the same AWS account.</p>
        pub fn set_integration_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_integration_uri(input);
            self
        }
        /// <p>Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER. Supported only for WebSocket APIs.</p>
        /// <p>WHEN_NO_MATCH passes the request body for unmapped content types through to the integration backend without transformation.</p>
        /// <p>NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type response.</p>
        /// <p>WHEN_NO_TEMPLATES allows pass-through when the integration has no content types mapped to templates. However, if there is at least one content type defined, unmapped content types will be rejected with the same HTTP 415 Unsupported Media Type response.</p>
        pub fn passthrough_behavior(mut self, input: crate::model::PassthroughBehavior) -> Self {
            self.inner = self.inner.passthrough_behavior(input);
            self
        }
        /// <p>Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER. Supported only for WebSocket APIs.</p>
        /// <p>WHEN_NO_MATCH passes the request body for unmapped content types through to the integration backend without transformation.</p>
        /// <p>NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type response.</p>
        /// <p>WHEN_NO_TEMPLATES allows pass-through when the integration has no content types mapped to templates. However, if there is at least one content type defined, unmapped content types will be rejected with the same HTTP 415 Unsupported Media Type response.</p>
        pub fn set_passthrough_behavior(
            mut self,
            input: std::option::Option<crate::model::PassthroughBehavior>,
        ) -> Self {
            self.inner = self.inner.set_passthrough_behavior(input);
            self
        }
        /// <p>Specifies the format of the payload sent to an integration. Required for HTTP APIs.</p>
        pub fn payload_format_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.payload_format_version(input.into());
            self
        }
        /// <p>Specifies the format of the payload sent to an integration. Required for HTTP APIs.</p>
        pub fn set_payload_format_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_payload_format_version(input);
            self
        }
        /// Adds a key-value pair to `RequestParameters`.
        ///
        /// To override the contents of this collection use [`set_request_parameters`](Self::set_request_parameters).
        ///
        /// <p>For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the backend. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the backend. The method request parameter value must match the pattern of method.request.<replaceable>
        /// {location}
        /// </replaceable>.<replaceable>
        /// {name}
        /// </replaceable> , where <replaceable>
        /// {location}
        /// </replaceable> is querystring, path, or header; and <replaceable>
        /// {name}
        /// </replaceable> must be a valid and unique method request parameter name.</p>
        /// <p>For HTTP API integrations with a specified integrationSubtype, request parameters are a key-value map specifying parameters that are passed to AWS_PROXY integrations. You can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services.html">Working with AWS service integrations for HTTP APIs</a>.</p>
        /// <p>For HTTP API integrations, without a specified integrationSubtype request parameters are a key-value map specifying how to transform HTTP requests before sending them to the backend. The key should follow the pattern &lt;action&gt;:&lt;header|querystring|path&gt;.&lt;location&gt; where action can be append, overwrite or remove. For values, you can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.">Transforming API requests and responses</a>.</p>
        pub fn request_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.request_parameters(k.into(), v.into());
            self
        }
        /// <p>For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the backend. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the backend. The method request parameter value must match the pattern of method.request.<replaceable>
        /// {location}
        /// </replaceable>.<replaceable>
        /// {name}
        /// </replaceable> , where <replaceable>
        /// {location}
        /// </replaceable> is querystring, path, or header; and <replaceable>
        /// {name}
        /// </replaceable> must be a valid and unique method request parameter name.</p>
        /// <p>For HTTP API integrations with a specified integrationSubtype, request parameters are a key-value map specifying parameters that are passed to AWS_PROXY integrations. You can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services.html">Working with AWS service integrations for HTTP APIs</a>.</p>
        /// <p>For HTTP API integrations, without a specified integrationSubtype request parameters are a key-value map specifying how to transform HTTP requests before sending them to the backend. The key should follow the pattern &lt;action&gt;:&lt;header|querystring|path&gt;.&lt;location&gt; where action can be append, overwrite or remove. For values, you can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.">Transforming API requests and responses</a>.</p>
        pub fn set_request_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_request_parameters(input);
            self
        }
        /// Adds a key-value pair to `RequestTemplates`.
        ///
        /// To override the contents of this collection use [`set_request_templates`](Self::set_request_templates).
        ///
        /// <p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value. Supported only for WebSocket APIs.</p>
        pub fn request_templates(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.request_templates(k.into(), v.into());
            self
        }
        /// <p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value. Supported only for WebSocket APIs.</p>
        pub fn set_request_templates(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_request_templates(input);
            self
        }
        /// Adds a key-value pair to `ResponseParameters`.
        ///
        /// To override the contents of this collection use [`set_response_parameters`](Self::set_response_parameters).
        ///
        /// <p>Supported only for HTTP APIs. You use response parameters to transform the HTTP response from a backend integration before returning the response to clients. Specify a key-value map from a selection key to response parameters. The selection key must be a valid HTTP status code within the range of 200-599. Response parameters are a key-value map. The key must match pattern &lt;action&gt;:&lt;header&gt;.&lt;location&gt; or overwrite.statuscode. The action can be append, overwrite or remove. The value can be a static value, or map to response data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
        pub fn response_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: std::collections::HashMap<std::string::String, std::string::String>,
        ) -> Self {
            self.inner = self.inner.response_parameters(k.into(), v);
            self
        }
        /// <p>Supported only for HTTP APIs. You use response parameters to transform the HTTP response from a backend integration before returning the response to clients. Specify a key-value map from a selection key to response parameters. The selection key must be a valid HTTP status code within the range of 200-599. Response parameters are a key-value map. The key must match pattern &lt;action&gt;:&lt;header&gt;.&lt;location&gt; or overwrite.statuscode. The action can be append, overwrite or remove. The value can be a static value, or map to response data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
        pub fn set_response_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    std::collections::HashMap<std::string::String, std::string::String>,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_response_parameters(input);
            self
        }
        /// <p>The template selection expression for the integration.</p>
        pub fn template_selection_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.template_selection_expression(input.into());
            self
        }
        /// <p>The template selection expression for the integration.</p>
        pub fn set_template_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_selection_expression(input);
            self
        }
        /// <p>Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs. The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.</p>
        pub fn timeout_in_millis(mut self, input: i32) -> Self {
            self.inner = self.inner.timeout_in_millis(input);
            self
        }
        /// <p>Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs. The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.</p>
        pub fn set_timeout_in_millis(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_timeout_in_millis(input);
            self
        }
        /// <p>The TLS configuration for a private integration. If you specify a TLS configuration, private integration traffic uses the HTTPS protocol. Supported only for HTTP APIs.</p>
        pub fn tls_config(mut self, input: crate::model::TlsConfigInput) -> Self {
            self.inner = self.inner.tls_config(input);
            self
        }
        /// <p>The TLS configuration for a private integration. If you specify a TLS configuration, private integration traffic uses the HTTPS protocol. Supported only for HTTP APIs.</p>
        pub fn set_tls_config(
            mut self,
            input: std::option::Option<crate::model::TlsConfigInput>,
        ) -> Self {
            self.inner = self.inner.set_tls_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateIntegrationResponse`.
    ///
    /// <p>Updates an IntegrationResponses.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateIntegrationResponse<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_integration_response_input::Builder,
    }
    impl<C, M, R> UpdateIntegrationResponse<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateIntegrationResponse`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateIntegrationResponseOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateIntegrationResponseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateIntegrationResponseInputOperationOutputAlias,
                crate::output::UpdateIntegrationResponseOutput,
                crate::error::UpdateIntegrationResponseError,
                crate::input::UpdateIntegrationResponseInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p>
        /// <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p>
        /// <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p>
        /// <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
        pub fn content_handling_strategy(
            mut self,
            input: crate::model::ContentHandlingStrategy,
        ) -> Self {
            self.inner = self.inner.content_handling_strategy(input);
            self
        }
        /// <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p>
        /// <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p>
        /// <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p>
        /// <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
        pub fn set_content_handling_strategy(
            mut self,
            input: std::option::Option<crate::model::ContentHandlingStrategy>,
        ) -> Self {
            self.inner = self.inner.set_content_handling_strategy(input);
            self
        }
        /// <p>The integration ID.</p>
        pub fn integration_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.integration_id(input.into());
            self
        }
        /// <p>The integration ID.</p>
        pub fn set_integration_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_integration_id(input);
            self
        }
        /// <p>The integration response ID.</p>
        pub fn integration_response_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.integration_response_id(input.into());
            self
        }
        /// <p>The integration response ID.</p>
        pub fn set_integration_response_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_integration_response_id(input);
            self
        }
        /// <p>The integration response key.</p>
        pub fn integration_response_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.integration_response_key(input.into());
            self
        }
        /// <p>The integration response key.</p>
        pub fn set_integration_response_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_integration_response_key(input);
            self
        }
        /// Adds a key-value pair to `ResponseParameters`.
        ///
        /// To override the contents of this collection use [`set_response_parameters`](Self::set_response_parameters).
        ///
        /// <p>A key-value map specifying response parameters that are passed to the method response from the backend. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of method.response.header.<replaceable>
        /// {name}
        /// </replaceable> , where name is a valid and unique header name. The mapped non-static value must match the pattern of integration.response.header.<replaceable>
        /// {name}
        /// </replaceable> or integration.response.body.<replaceable>
        /// {JSON-expression}
        /// </replaceable> , where <replaceable>
        /// {name}
        /// </replaceable> is a valid and unique response header name and <replaceable>
        /// {JSON-expression}
        /// </replaceable> is a valid JSON expression without the $ prefix.</p>
        pub fn response_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.response_parameters(k.into(), v.into());
            self
        }
        /// <p>A key-value map specifying response parameters that are passed to the method response from the backend. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of method.response.header.<replaceable>
        /// {name}
        /// </replaceable> , where name is a valid and unique header name. The mapped non-static value must match the pattern of integration.response.header.<replaceable>
        /// {name}
        /// </replaceable> or integration.response.body.<replaceable>
        /// {JSON-expression}
        /// </replaceable> , where <replaceable>
        /// {name}
        /// </replaceable> is a valid and unique response header name and <replaceable>
        /// {JSON-expression}
        /// </replaceable> is a valid JSON expression without the $ prefix.</p>
        pub fn set_response_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_response_parameters(input);
            self
        }
        /// Adds a key-value pair to `ResponseTemplates`.
        ///
        /// To override the contents of this collection use [`set_response_templates`](Self::set_response_templates).
        ///
        /// <p>The collection of response templates for the integration response as a string-to-string map of key-value pairs. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.</p>
        pub fn response_templates(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.response_templates(k.into(), v.into());
            self
        }
        /// <p>The collection of response templates for the integration response as a string-to-string map of key-value pairs. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.</p>
        pub fn set_response_templates(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_response_templates(input);
            self
        }
        /// <p>The template selection expression for the integration response. Supported only for WebSocket APIs.</p>
        pub fn template_selection_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.template_selection_expression(input.into());
            self
        }
        /// <p>The template selection expression for the integration response. Supported only for WebSocket APIs.</p>
        pub fn set_template_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_selection_expression(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateModel`.
    ///
    /// <p>Updates a Model.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateModel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_model_input::Builder,
    }
    impl<C, M, R> UpdateModel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateModelOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateModelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateModelInputOperationOutputAlias,
                crate::output::UpdateModelOutput,
                crate::error::UpdateModelError,
                crate::input::UpdateModelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The content-type for the model, for example, "application/json".</p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content_type(input.into());
            self
        }
        /// <p>The content-type for the model, for example, "application/json".</p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content_type(input);
            self
        }
        /// <p>The description of the model.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the model.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The model ID.</p>
        pub fn model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_id(input.into());
            self
        }
        /// <p>The model ID.</p>
        pub fn set_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_model_id(input);
            self
        }
        /// <p>The name of the model.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the model.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The schema for the model. For application/json models, this should be JSON schema draft 4 model.</p>
        pub fn schema(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema(input.into());
            self
        }
        /// <p>The schema for the model. For application/json models, this should be JSON schema draft 4 model.</p>
        pub fn set_schema(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schema(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRoute`.
    ///
    /// <p>Updates a Route.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateRoute<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_route_input::Builder,
    }
    impl<C, M, R> UpdateRoute<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateRoute`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRouteOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRouteError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateRouteInputOperationOutputAlias,
                crate::output::UpdateRouteOutput,
                crate::error::UpdateRouteError,
                crate::input::UpdateRouteInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>Specifies whether an API key is required for the route. Supported only for WebSocket APIs.</p>
        pub fn api_key_required(mut self, input: bool) -> Self {
            self.inner = self.inner.api_key_required(input);
            self
        }
        /// <p>Specifies whether an API key is required for the route. Supported only for WebSocket APIs.</p>
        pub fn set_api_key_required(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_api_key_required(input);
            self
        }
        /// Appends an item to `AuthorizationScopes`.
        ///
        /// To override the contents of this collection use [`set_authorization_scopes`](Self::set_authorization_scopes).
        ///
        /// <p>The authorization scopes supported by this route.</p>
        pub fn authorization_scopes(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authorization_scopes(input.into());
            self
        }
        /// <p>The authorization scopes supported by this route.</p>
        pub fn set_authorization_scopes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_authorization_scopes(input);
            self
        }
        /// <p>The authorization type for the route. For WebSocket APIs, valid values are NONE for open access, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer For HTTP APIs, valid values are NONE for open access, JWT for using JSON Web Tokens, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer.</p>
        pub fn authorization_type(mut self, input: crate::model::AuthorizationType) -> Self {
            self.inner = self.inner.authorization_type(input);
            self
        }
        /// <p>The authorization type for the route. For WebSocket APIs, valid values are NONE for open access, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer For HTTP APIs, valid values are NONE for open access, JWT for using JSON Web Tokens, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer.</p>
        pub fn set_authorization_type(
            mut self,
            input: std::option::Option<crate::model::AuthorizationType>,
        ) -> Self {
            self.inner = self.inner.set_authorization_type(input);
            self
        }
        /// <p>The identifier of the Authorizer resource to be associated with this route. The authorizer identifier is generated by API Gateway when you created the authorizer.</p>
        pub fn authorizer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authorizer_id(input.into());
            self
        }
        /// <p>The identifier of the Authorizer resource to be associated with this route. The authorizer identifier is generated by API Gateway when you created the authorizer.</p>
        pub fn set_authorizer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authorizer_id(input);
            self
        }
        /// <p>The model selection expression for the route. Supported only for WebSocket APIs.</p>
        pub fn model_selection_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_selection_expression(input.into());
            self
        }
        /// <p>The model selection expression for the route. Supported only for WebSocket APIs.</p>
        pub fn set_model_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_model_selection_expression(input);
            self
        }
        /// <p>The operation name for the route.</p>
        pub fn operation_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.operation_name(input.into());
            self
        }
        /// <p>The operation name for the route.</p>
        pub fn set_operation_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_operation_name(input);
            self
        }
        /// Adds a key-value pair to `RequestModels`.
        ///
        /// To override the contents of this collection use [`set_request_models`](Self::set_request_models).
        ///
        /// <p>The request models for the route. Supported only for WebSocket APIs.</p>
        pub fn request_models(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.request_models(k.into(), v.into());
            self
        }
        /// <p>The request models for the route. Supported only for WebSocket APIs.</p>
        pub fn set_request_models(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_request_models(input);
            self
        }
        /// Adds a key-value pair to `RequestParameters`.
        ///
        /// To override the contents of this collection use [`set_request_parameters`](Self::set_request_parameters).
        ///
        /// <p>The request parameters for the route. Supported only for WebSocket APIs.</p>
        pub fn request_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::ParameterConstraints,
        ) -> Self {
            self.inner = self.inner.request_parameters(k.into(), v);
            self
        }
        /// <p>The request parameters for the route. Supported only for WebSocket APIs.</p>
        pub fn set_request_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::ParameterConstraints>,
            >,
        ) -> Self {
            self.inner = self.inner.set_request_parameters(input);
            self
        }
        /// <p>The route ID.</p>
        pub fn route_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.route_id(input.into());
            self
        }
        /// <p>The route ID.</p>
        pub fn set_route_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_route_id(input);
            self
        }
        /// <p>The route key for the route.</p>
        pub fn route_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.route_key(input.into());
            self
        }
        /// <p>The route key for the route.</p>
        pub fn set_route_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_route_key(input);
            self
        }
        /// <p>The route response selection expression for the route. Supported only for WebSocket APIs.</p>
        pub fn route_response_selection_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.route_response_selection_expression(input.into());
            self
        }
        /// <p>The route response selection expression for the route. Supported only for WebSocket APIs.</p>
        pub fn set_route_response_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_route_response_selection_expression(input);
            self
        }
        /// <p>The target for the route.</p>
        pub fn target(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target(input.into());
            self
        }
        /// <p>The target for the route.</p>
        pub fn set_target(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_target(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRouteResponse`.
    ///
    /// <p>Updates a RouteResponse.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateRouteResponse<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_route_response_input::Builder,
    }
    impl<C, M, R> UpdateRouteResponse<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateRouteResponse`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRouteResponseOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRouteResponseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateRouteResponseInputOperationOutputAlias,
                crate::output::UpdateRouteResponseOutput,
                crate::error::UpdateRouteResponseError,
                crate::input::UpdateRouteResponseInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The model selection expression for the route response. Supported only for WebSocket APIs.</p>
        pub fn model_selection_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_selection_expression(input.into());
            self
        }
        /// <p>The model selection expression for the route response. Supported only for WebSocket APIs.</p>
        pub fn set_model_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_model_selection_expression(input);
            self
        }
        /// Adds a key-value pair to `ResponseModels`.
        ///
        /// To override the contents of this collection use [`set_response_models`](Self::set_response_models).
        ///
        /// <p>The response models for the route response.</p>
        pub fn response_models(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.response_models(k.into(), v.into());
            self
        }
        /// <p>The response models for the route response.</p>
        pub fn set_response_models(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_response_models(input);
            self
        }
        /// Adds a key-value pair to `ResponseParameters`.
        ///
        /// To override the contents of this collection use [`set_response_parameters`](Self::set_response_parameters).
        ///
        /// <p>The route response parameters.</p>
        pub fn response_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::ParameterConstraints,
        ) -> Self {
            self.inner = self.inner.response_parameters(k.into(), v);
            self
        }
        /// <p>The route response parameters.</p>
        pub fn set_response_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::ParameterConstraints>,
            >,
        ) -> Self {
            self.inner = self.inner.set_response_parameters(input);
            self
        }
        /// <p>The route ID.</p>
        pub fn route_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.route_id(input.into());
            self
        }
        /// <p>The route ID.</p>
        pub fn set_route_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_route_id(input);
            self
        }
        /// <p>The route response ID.</p>
        pub fn route_response_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.route_response_id(input.into());
            self
        }
        /// <p>The route response ID.</p>
        pub fn set_route_response_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_route_response_id(input);
            self
        }
        /// <p>The route response key.</p>
        pub fn route_response_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.route_response_key(input.into());
            self
        }
        /// <p>The route response key.</p>
        pub fn set_route_response_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_route_response_key(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateStage`.
    ///
    /// <p>Updates a Stage.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateStage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_stage_input::Builder,
    }
    impl<C, M, R> UpdateStage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateStage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateStageOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateStageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateStageInputOperationOutputAlias,
                crate::output::UpdateStageOutput,
                crate::error::UpdateStageError,
                crate::input::UpdateStageInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Settings for logging access in this stage.</p>
        pub fn access_log_settings(mut self, input: crate::model::AccessLogSettings) -> Self {
            self.inner = self.inner.access_log_settings(input);
            self
        }
        /// <p>Settings for logging access in this stage.</p>
        pub fn set_access_log_settings(
            mut self,
            input: std::option::Option<crate::model::AccessLogSettings>,
        ) -> Self {
            self.inner = self.inner.set_access_log_settings(input);
            self
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>Specifies whether updates to an API automatically trigger a new deployment. The default value is false.</p>
        pub fn auto_deploy(mut self, input: bool) -> Self {
            self.inner = self.inner.auto_deploy(input);
            self
        }
        /// <p>Specifies whether updates to an API automatically trigger a new deployment. The default value is false.</p>
        pub fn set_auto_deploy(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_deploy(input);
            self
        }
        /// <p>The identifier of a client certificate for a Stage.</p>
        pub fn client_certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_certificate_id(input.into());
            self
        }
        /// <p>The identifier of a client certificate for a Stage.</p>
        pub fn set_client_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_certificate_id(input);
            self
        }
        /// <p>The default route settings for the stage.</p>
        pub fn default_route_settings(mut self, input: crate::model::RouteSettings) -> Self {
            self.inner = self.inner.default_route_settings(input);
            self
        }
        /// <p>The default route settings for the stage.</p>
        pub fn set_default_route_settings(
            mut self,
            input: std::option::Option<crate::model::RouteSettings>,
        ) -> Self {
            self.inner = self.inner.set_default_route_settings(input);
            self
        }
        /// <p>The deployment identifier for the API stage. Can't be updated if autoDeploy is enabled.</p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_id(input.into());
            self
        }
        /// <p>The deployment identifier for the API stage. Can't be updated if autoDeploy is enabled.</p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_id(input);
            self
        }
        /// <p>The description for the API stage.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description for the API stage.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Adds a key-value pair to `RouteSettings`.
        ///
        /// To override the contents of this collection use [`set_route_settings`](Self::set_route_settings).
        ///
        /// <p>Route settings for the stage.</p>
        pub fn route_settings(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::RouteSettings,
        ) -> Self {
            self.inner = self.inner.route_settings(k.into(), v);
            self
        }
        /// <p>Route settings for the stage.</p>
        pub fn set_route_settings(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::RouteSettings>,
            >,
        ) -> Self {
            self.inner = self.inner.set_route_settings(input);
            self
        }
        /// <p>The stage name. Stage names can contain only alphanumeric characters, hyphens, and underscores, or be $default. Maximum length is 128 characters.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stage_name(input.into());
            self
        }
        /// <p>The stage name. Stage names can contain only alphanumeric characters, hyphens, and underscores, or be $default. Maximum length is 128 characters.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stage_name(input);
            self
        }
        /// Adds a key-value pair to `StageVariables`.
        ///
        /// To override the contents of this collection use [`set_stage_variables`](Self::set_stage_variables).
        ///
        /// <p>A map that defines the stage variables for a Stage. Variable names can have alphanumeric and underscore characters, and the values must match [A-Za-z0-9-._~:/?#&amp;=,]+.</p>
        pub fn stage_variables(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.stage_variables(k.into(), v.into());
            self
        }
        /// <p>A map that defines the stage variables for a Stage. Variable names can have alphanumeric and underscore characters, and the values must match [A-Za-z0-9-._~:/?#&amp;=,]+.</p>
        pub fn set_stage_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_stage_variables(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateVpcLink`.
    ///
    /// <p>Updates a VPC link.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateVpcLink<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_vpc_link_input::Builder,
    }
    impl<C, M, R> UpdateVpcLink<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateVpcLink`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateVpcLinkOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateVpcLinkError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateVpcLinkInputOperationOutputAlias,
                crate::output::UpdateVpcLinkOutput,
                crate::error::UpdateVpcLinkError,
                crate::input::UpdateVpcLinkInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the VPC link.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the VPC link.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The ID of the VPC link.</p>
        pub fn vpc_link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_link_id(input.into());
            self
        }
        /// <p>The ID of the VPC link.</p>
        pub fn set_vpc_link_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_vpc_link_id(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
