// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `CreateApi`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_api`](crate::client::Client::create_api).
///
/// See [`crate::client::fluent_builders::CreateApi`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateApi {
    _private: (),
}
impl CreateApi {
    /// Creates a new builder-style object to manufacture [`CreateApiInput`](crate::input::CreateApiInput)
    pub fn builder() -> crate::input::create_api_input::Builder {
        crate::input::create_api_input::Builder::default()
    }
    /// Creates a new `CreateApi` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateApi {
    type Output = std::result::Result<crate::output::CreateApiOutput, crate::error::CreateApiError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_api_error(response)
        } else {
            crate::operation_deser::parse_create_api_response(response)
        }
    }
}

/// Operation shape for `CreateApiMapping`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_api_mapping`](crate::client::Client::create_api_mapping).
///
/// See [`crate::client::fluent_builders::CreateApiMapping`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateApiMapping {
    _private: (),
}
impl CreateApiMapping {
    /// Creates a new builder-style object to manufacture [`CreateApiMappingInput`](crate::input::CreateApiMappingInput)
    pub fn builder() -> crate::input::create_api_mapping_input::Builder {
        crate::input::create_api_mapping_input::Builder::default()
    }
    /// Creates a new `CreateApiMapping` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateApiMapping {
    type Output = std::result::Result<
        crate::output::CreateApiMappingOutput,
        crate::error::CreateApiMappingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_api_mapping_error(response)
        } else {
            crate::operation_deser::parse_create_api_mapping_response(response)
        }
    }
}

/// Operation shape for `CreateAuthorizer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_authorizer`](crate::client::Client::create_authorizer).
///
/// See [`crate::client::fluent_builders::CreateAuthorizer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateAuthorizer {
    _private: (),
}
impl CreateAuthorizer {
    /// Creates a new builder-style object to manufacture [`CreateAuthorizerInput`](crate::input::CreateAuthorizerInput)
    pub fn builder() -> crate::input::create_authorizer_input::Builder {
        crate::input::create_authorizer_input::Builder::default()
    }
    /// Creates a new `CreateAuthorizer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateAuthorizer {
    type Output = std::result::Result<
        crate::output::CreateAuthorizerOutput,
        crate::error::CreateAuthorizerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_authorizer_error(response)
        } else {
            crate::operation_deser::parse_create_authorizer_response(response)
        }
    }
}

/// Operation shape for `CreateDeployment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_deployment`](crate::client::Client::create_deployment).
///
/// See [`crate::client::fluent_builders::CreateDeployment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDeployment {
    _private: (),
}
impl CreateDeployment {
    /// Creates a new builder-style object to manufacture [`CreateDeploymentInput`](crate::input::CreateDeploymentInput)
    pub fn builder() -> crate::input::create_deployment_input::Builder {
        crate::input::create_deployment_input::Builder::default()
    }
    /// Creates a new `CreateDeployment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDeployment {
    type Output = std::result::Result<
        crate::output::CreateDeploymentOutput,
        crate::error::CreateDeploymentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_deployment_error(response)
        } else {
            crate::operation_deser::parse_create_deployment_response(response)
        }
    }
}

/// Operation shape for `CreateDomainName`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_domain_name`](crate::client::Client::create_domain_name).
///
/// See [`crate::client::fluent_builders::CreateDomainName`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDomainName {
    _private: (),
}
impl CreateDomainName {
    /// Creates a new builder-style object to manufacture [`CreateDomainNameInput`](crate::input::CreateDomainNameInput)
    pub fn builder() -> crate::input::create_domain_name_input::Builder {
        crate::input::create_domain_name_input::Builder::default()
    }
    /// Creates a new `CreateDomainName` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDomainName {
    type Output = std::result::Result<
        crate::output::CreateDomainNameOutput,
        crate::error::CreateDomainNameError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_domain_name_error(response)
        } else {
            crate::operation_deser::parse_create_domain_name_response(response)
        }
    }
}

/// Operation shape for `CreateIntegration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_integration`](crate::client::Client::create_integration).
///
/// See [`crate::client::fluent_builders::CreateIntegration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateIntegration {
    _private: (),
}
impl CreateIntegration {
    /// Creates a new builder-style object to manufacture [`CreateIntegrationInput`](crate::input::CreateIntegrationInput)
    pub fn builder() -> crate::input::create_integration_input::Builder {
        crate::input::create_integration_input::Builder::default()
    }
    /// Creates a new `CreateIntegration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateIntegration {
    type Output = std::result::Result<
        crate::output::CreateIntegrationOutput,
        crate::error::CreateIntegrationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_integration_error(response)
        } else {
            crate::operation_deser::parse_create_integration_response(response)
        }
    }
}

/// Operation shape for `CreateIntegrationResponse`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_integration_response`](crate::client::Client::create_integration_response).
///
/// See [`crate::client::fluent_builders::CreateIntegrationResponse`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateIntegrationResponse {
    _private: (),
}
impl CreateIntegrationResponse {
    /// Creates a new builder-style object to manufacture [`CreateIntegrationResponseInput`](crate::input::CreateIntegrationResponseInput)
    pub fn builder() -> crate::input::create_integration_response_input::Builder {
        crate::input::create_integration_response_input::Builder::default()
    }
    /// Creates a new `CreateIntegrationResponse` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateIntegrationResponse {
    type Output = std::result::Result<
        crate::output::CreateIntegrationResponseOutput,
        crate::error::CreateIntegrationResponseError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_integration_response_error(response)
        } else {
            crate::operation_deser::parse_create_integration_response_response(response)
        }
    }
}

/// Operation shape for `CreateModel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_model`](crate::client::Client::create_model).
///
/// See [`crate::client::fluent_builders::CreateModel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateModel {
    _private: (),
}
impl CreateModel {
    /// Creates a new builder-style object to manufacture [`CreateModelInput`](crate::input::CreateModelInput)
    pub fn builder() -> crate::input::create_model_input::Builder {
        crate::input::create_model_input::Builder::default()
    }
    /// Creates a new `CreateModel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateModel {
    type Output =
        std::result::Result<crate::output::CreateModelOutput, crate::error::CreateModelError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_model_error(response)
        } else {
            crate::operation_deser::parse_create_model_response(response)
        }
    }
}

/// Operation shape for `CreateRoute`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_route`](crate::client::Client::create_route).
///
/// See [`crate::client::fluent_builders::CreateRoute`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateRoute {
    _private: (),
}
impl CreateRoute {
    /// Creates a new builder-style object to manufacture [`CreateRouteInput`](crate::input::CreateRouteInput)
    pub fn builder() -> crate::input::create_route_input::Builder {
        crate::input::create_route_input::Builder::default()
    }
    /// Creates a new `CreateRoute` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateRoute {
    type Output =
        std::result::Result<crate::output::CreateRouteOutput, crate::error::CreateRouteError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_route_error(response)
        } else {
            crate::operation_deser::parse_create_route_response(response)
        }
    }
}

/// Operation shape for `CreateRouteResponse`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_route_response`](crate::client::Client::create_route_response).
///
/// See [`crate::client::fluent_builders::CreateRouteResponse`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateRouteResponse {
    _private: (),
}
impl CreateRouteResponse {
    /// Creates a new builder-style object to manufacture [`CreateRouteResponseInput`](crate::input::CreateRouteResponseInput)
    pub fn builder() -> crate::input::create_route_response_input::Builder {
        crate::input::create_route_response_input::Builder::default()
    }
    /// Creates a new `CreateRouteResponse` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateRouteResponse {
    type Output = std::result::Result<
        crate::output::CreateRouteResponseOutput,
        crate::error::CreateRouteResponseError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_route_response_error(response)
        } else {
            crate::operation_deser::parse_create_route_response_response(response)
        }
    }
}

/// Operation shape for `CreateStage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_stage`](crate::client::Client::create_stage).
///
/// See [`crate::client::fluent_builders::CreateStage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateStage {
    _private: (),
}
impl CreateStage {
    /// Creates a new builder-style object to manufacture [`CreateStageInput`](crate::input::CreateStageInput)
    pub fn builder() -> crate::input::create_stage_input::Builder {
        crate::input::create_stage_input::Builder::default()
    }
    /// Creates a new `CreateStage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateStage {
    type Output =
        std::result::Result<crate::output::CreateStageOutput, crate::error::CreateStageError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_stage_error(response)
        } else {
            crate::operation_deser::parse_create_stage_response(response)
        }
    }
}

/// Operation shape for `CreateVpcLink`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_vpc_link`](crate::client::Client::create_vpc_link).
///
/// See [`crate::client::fluent_builders::CreateVpcLink`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateVpcLink {
    _private: (),
}
impl CreateVpcLink {
    /// Creates a new builder-style object to manufacture [`CreateVpcLinkInput`](crate::input::CreateVpcLinkInput)
    pub fn builder() -> crate::input::create_vpc_link_input::Builder {
        crate::input::create_vpc_link_input::Builder::default()
    }
    /// Creates a new `CreateVpcLink` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateVpcLink {
    type Output =
        std::result::Result<crate::output::CreateVpcLinkOutput, crate::error::CreateVpcLinkError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_vpc_link_error(response)
        } else {
            crate::operation_deser::parse_create_vpc_link_response(response)
        }
    }
}

/// Operation shape for `DeleteAccessLogSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_access_log_settings`](crate::client::Client::delete_access_log_settings).
///
/// See [`crate::client::fluent_builders::DeleteAccessLogSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAccessLogSettings {
    _private: (),
}
impl DeleteAccessLogSettings {
    /// Creates a new builder-style object to manufacture [`DeleteAccessLogSettingsInput`](crate::input::DeleteAccessLogSettingsInput)
    pub fn builder() -> crate::input::delete_access_log_settings_input::Builder {
        crate::input::delete_access_log_settings_input::Builder::default()
    }
    /// Creates a new `DeleteAccessLogSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAccessLogSettings {
    type Output = std::result::Result<
        crate::output::DeleteAccessLogSettingsOutput,
        crate::error::DeleteAccessLogSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_access_log_settings_error(response)
        } else {
            crate::operation_deser::parse_delete_access_log_settings_response(response)
        }
    }
}

/// Operation shape for `DeleteApi`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_api`](crate::client::Client::delete_api).
///
/// See [`crate::client::fluent_builders::DeleteApi`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteApi {
    _private: (),
}
impl DeleteApi {
    /// Creates a new builder-style object to manufacture [`DeleteApiInput`](crate::input::DeleteApiInput)
    pub fn builder() -> crate::input::delete_api_input::Builder {
        crate::input::delete_api_input::Builder::default()
    }
    /// Creates a new `DeleteApi` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteApi {
    type Output = std::result::Result<crate::output::DeleteApiOutput, crate::error::DeleteApiError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_api_error(response)
        } else {
            crate::operation_deser::parse_delete_api_response(response)
        }
    }
}

/// Operation shape for `DeleteApiMapping`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_api_mapping`](crate::client::Client::delete_api_mapping).
///
/// See [`crate::client::fluent_builders::DeleteApiMapping`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteApiMapping {
    _private: (),
}
impl DeleteApiMapping {
    /// Creates a new builder-style object to manufacture [`DeleteApiMappingInput`](crate::input::DeleteApiMappingInput)
    pub fn builder() -> crate::input::delete_api_mapping_input::Builder {
        crate::input::delete_api_mapping_input::Builder::default()
    }
    /// Creates a new `DeleteApiMapping` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteApiMapping {
    type Output = std::result::Result<
        crate::output::DeleteApiMappingOutput,
        crate::error::DeleteApiMappingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_api_mapping_error(response)
        } else {
            crate::operation_deser::parse_delete_api_mapping_response(response)
        }
    }
}

/// Operation shape for `DeleteAuthorizer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_authorizer`](crate::client::Client::delete_authorizer).
///
/// See [`crate::client::fluent_builders::DeleteAuthorizer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAuthorizer {
    _private: (),
}
impl DeleteAuthorizer {
    /// Creates a new builder-style object to manufacture [`DeleteAuthorizerInput`](crate::input::DeleteAuthorizerInput)
    pub fn builder() -> crate::input::delete_authorizer_input::Builder {
        crate::input::delete_authorizer_input::Builder::default()
    }
    /// Creates a new `DeleteAuthorizer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAuthorizer {
    type Output = std::result::Result<
        crate::output::DeleteAuthorizerOutput,
        crate::error::DeleteAuthorizerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_authorizer_error(response)
        } else {
            crate::operation_deser::parse_delete_authorizer_response(response)
        }
    }
}

/// Operation shape for `DeleteCorsConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_cors_configuration`](crate::client::Client::delete_cors_configuration).
///
/// See [`crate::client::fluent_builders::DeleteCorsConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteCorsConfiguration {
    _private: (),
}
impl DeleteCorsConfiguration {
    /// Creates a new builder-style object to manufacture [`DeleteCorsConfigurationInput`](crate::input::DeleteCorsConfigurationInput)
    pub fn builder() -> crate::input::delete_cors_configuration_input::Builder {
        crate::input::delete_cors_configuration_input::Builder::default()
    }
    /// Creates a new `DeleteCorsConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteCorsConfiguration {
    type Output = std::result::Result<
        crate::output::DeleteCorsConfigurationOutput,
        crate::error::DeleteCorsConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_cors_configuration_error(response)
        } else {
            crate::operation_deser::parse_delete_cors_configuration_response(response)
        }
    }
}

/// Operation shape for `DeleteDeployment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_deployment`](crate::client::Client::delete_deployment).
///
/// See [`crate::client::fluent_builders::DeleteDeployment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDeployment {
    _private: (),
}
impl DeleteDeployment {
    /// Creates a new builder-style object to manufacture [`DeleteDeploymentInput`](crate::input::DeleteDeploymentInput)
    pub fn builder() -> crate::input::delete_deployment_input::Builder {
        crate::input::delete_deployment_input::Builder::default()
    }
    /// Creates a new `DeleteDeployment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDeployment {
    type Output = std::result::Result<
        crate::output::DeleteDeploymentOutput,
        crate::error::DeleteDeploymentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_deployment_error(response)
        } else {
            crate::operation_deser::parse_delete_deployment_response(response)
        }
    }
}

/// Operation shape for `DeleteDomainName`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_domain_name`](crate::client::Client::delete_domain_name).
///
/// See [`crate::client::fluent_builders::DeleteDomainName`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDomainName {
    _private: (),
}
impl DeleteDomainName {
    /// Creates a new builder-style object to manufacture [`DeleteDomainNameInput`](crate::input::DeleteDomainNameInput)
    pub fn builder() -> crate::input::delete_domain_name_input::Builder {
        crate::input::delete_domain_name_input::Builder::default()
    }
    /// Creates a new `DeleteDomainName` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDomainName {
    type Output = std::result::Result<
        crate::output::DeleteDomainNameOutput,
        crate::error::DeleteDomainNameError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_domain_name_error(response)
        } else {
            crate::operation_deser::parse_delete_domain_name_response(response)
        }
    }
}

/// Operation shape for `DeleteIntegration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_integration`](crate::client::Client::delete_integration).
///
/// See [`crate::client::fluent_builders::DeleteIntegration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteIntegration {
    _private: (),
}
impl DeleteIntegration {
    /// Creates a new builder-style object to manufacture [`DeleteIntegrationInput`](crate::input::DeleteIntegrationInput)
    pub fn builder() -> crate::input::delete_integration_input::Builder {
        crate::input::delete_integration_input::Builder::default()
    }
    /// Creates a new `DeleteIntegration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteIntegration {
    type Output = std::result::Result<
        crate::output::DeleteIntegrationOutput,
        crate::error::DeleteIntegrationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_integration_error(response)
        } else {
            crate::operation_deser::parse_delete_integration_response(response)
        }
    }
}

/// Operation shape for `DeleteIntegrationResponse`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_integration_response`](crate::client::Client::delete_integration_response).
///
/// See [`crate::client::fluent_builders::DeleteIntegrationResponse`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteIntegrationResponse {
    _private: (),
}
impl DeleteIntegrationResponse {
    /// Creates a new builder-style object to manufacture [`DeleteIntegrationResponseInput`](crate::input::DeleteIntegrationResponseInput)
    pub fn builder() -> crate::input::delete_integration_response_input::Builder {
        crate::input::delete_integration_response_input::Builder::default()
    }
    /// Creates a new `DeleteIntegrationResponse` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteIntegrationResponse {
    type Output = std::result::Result<
        crate::output::DeleteIntegrationResponseOutput,
        crate::error::DeleteIntegrationResponseError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_integration_response_error(response)
        } else {
            crate::operation_deser::parse_delete_integration_response_response(response)
        }
    }
}

/// Operation shape for `DeleteModel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_model`](crate::client::Client::delete_model).
///
/// See [`crate::client::fluent_builders::DeleteModel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteModel {
    _private: (),
}
impl DeleteModel {
    /// Creates a new builder-style object to manufacture [`DeleteModelInput`](crate::input::DeleteModelInput)
    pub fn builder() -> crate::input::delete_model_input::Builder {
        crate::input::delete_model_input::Builder::default()
    }
    /// Creates a new `DeleteModel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteModel {
    type Output =
        std::result::Result<crate::output::DeleteModelOutput, crate::error::DeleteModelError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_model_error(response)
        } else {
            crate::operation_deser::parse_delete_model_response(response)
        }
    }
}

/// Operation shape for `DeleteRoute`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_route`](crate::client::Client::delete_route).
///
/// See [`crate::client::fluent_builders::DeleteRoute`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteRoute {
    _private: (),
}
impl DeleteRoute {
    /// Creates a new builder-style object to manufacture [`DeleteRouteInput`](crate::input::DeleteRouteInput)
    pub fn builder() -> crate::input::delete_route_input::Builder {
        crate::input::delete_route_input::Builder::default()
    }
    /// Creates a new `DeleteRoute` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteRoute {
    type Output =
        std::result::Result<crate::output::DeleteRouteOutput, crate::error::DeleteRouteError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_route_error(response)
        } else {
            crate::operation_deser::parse_delete_route_response(response)
        }
    }
}

/// Operation shape for `DeleteRouteRequestParameter`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_route_request_parameter`](crate::client::Client::delete_route_request_parameter).
///
/// See [`crate::client::fluent_builders::DeleteRouteRequestParameter`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteRouteRequestParameter {
    _private: (),
}
impl DeleteRouteRequestParameter {
    /// Creates a new builder-style object to manufacture [`DeleteRouteRequestParameterInput`](crate::input::DeleteRouteRequestParameterInput)
    pub fn builder() -> crate::input::delete_route_request_parameter_input::Builder {
        crate::input::delete_route_request_parameter_input::Builder::default()
    }
    /// Creates a new `DeleteRouteRequestParameter` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteRouteRequestParameter {
    type Output = std::result::Result<
        crate::output::DeleteRouteRequestParameterOutput,
        crate::error::DeleteRouteRequestParameterError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_route_request_parameter_error(response)
        } else {
            crate::operation_deser::parse_delete_route_request_parameter_response(response)
        }
    }
}

/// Operation shape for `DeleteRouteResponse`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_route_response`](crate::client::Client::delete_route_response).
///
/// See [`crate::client::fluent_builders::DeleteRouteResponse`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteRouteResponse {
    _private: (),
}
impl DeleteRouteResponse {
    /// Creates a new builder-style object to manufacture [`DeleteRouteResponseInput`](crate::input::DeleteRouteResponseInput)
    pub fn builder() -> crate::input::delete_route_response_input::Builder {
        crate::input::delete_route_response_input::Builder::default()
    }
    /// Creates a new `DeleteRouteResponse` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteRouteResponse {
    type Output = std::result::Result<
        crate::output::DeleteRouteResponseOutput,
        crate::error::DeleteRouteResponseError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_route_response_error(response)
        } else {
            crate::operation_deser::parse_delete_route_response_response(response)
        }
    }
}

/// Operation shape for `DeleteRouteSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_route_settings`](crate::client::Client::delete_route_settings).
///
/// See [`crate::client::fluent_builders::DeleteRouteSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteRouteSettings {
    _private: (),
}
impl DeleteRouteSettings {
    /// Creates a new builder-style object to manufacture [`DeleteRouteSettingsInput`](crate::input::DeleteRouteSettingsInput)
    pub fn builder() -> crate::input::delete_route_settings_input::Builder {
        crate::input::delete_route_settings_input::Builder::default()
    }
    /// Creates a new `DeleteRouteSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteRouteSettings {
    type Output = std::result::Result<
        crate::output::DeleteRouteSettingsOutput,
        crate::error::DeleteRouteSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_route_settings_error(response)
        } else {
            crate::operation_deser::parse_delete_route_settings_response(response)
        }
    }
}

/// Operation shape for `DeleteStage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_stage`](crate::client::Client::delete_stage).
///
/// See [`crate::client::fluent_builders::DeleteStage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteStage {
    _private: (),
}
impl DeleteStage {
    /// Creates a new builder-style object to manufacture [`DeleteStageInput`](crate::input::DeleteStageInput)
    pub fn builder() -> crate::input::delete_stage_input::Builder {
        crate::input::delete_stage_input::Builder::default()
    }
    /// Creates a new `DeleteStage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteStage {
    type Output =
        std::result::Result<crate::output::DeleteStageOutput, crate::error::DeleteStageError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_stage_error(response)
        } else {
            crate::operation_deser::parse_delete_stage_response(response)
        }
    }
}

/// Operation shape for `DeleteVpcLink`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_vpc_link`](crate::client::Client::delete_vpc_link).
///
/// See [`crate::client::fluent_builders::DeleteVpcLink`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteVpcLink {
    _private: (),
}
impl DeleteVpcLink {
    /// Creates a new builder-style object to manufacture [`DeleteVpcLinkInput`](crate::input::DeleteVpcLinkInput)
    pub fn builder() -> crate::input::delete_vpc_link_input::Builder {
        crate::input::delete_vpc_link_input::Builder::default()
    }
    /// Creates a new `DeleteVpcLink` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteVpcLink {
    type Output =
        std::result::Result<crate::output::DeleteVpcLinkOutput, crate::error::DeleteVpcLinkError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_delete_vpc_link_error(response)
        } else {
            crate::operation_deser::parse_delete_vpc_link_response(response)
        }
    }
}

/// Operation shape for `ExportApi`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`export_api`](crate::client::Client::export_api).
///
/// See [`crate::client::fluent_builders::ExportApi`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ExportApi {
    _private: (),
}
impl ExportApi {
    /// Creates a new builder-style object to manufacture [`ExportApiInput`](crate::input::ExportApiInput)
    pub fn builder() -> crate::input::export_api_input::Builder {
        crate::input::export_api_input::Builder::default()
    }
    /// Creates a new `ExportApi` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ExportApi {
    type Output = std::result::Result<crate::output::ExportApiOutput, crate::error::ExportApiError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_export_api_error(response)
        } else {
            crate::operation_deser::parse_export_api_response(response)
        }
    }
}

/// Operation shape for `GetApi`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_api`](crate::client::Client::get_api).
///
/// See [`crate::client::fluent_builders::GetApi`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetApi {
    _private: (),
}
impl GetApi {
    /// Creates a new builder-style object to manufacture [`GetApiInput`](crate::input::GetApiInput)
    pub fn builder() -> crate::input::get_api_input::Builder {
        crate::input::get_api_input::Builder::default()
    }
    /// Creates a new `GetApi` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetApi {
    type Output = std::result::Result<crate::output::GetApiOutput, crate::error::GetApiError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_api_error(response)
        } else {
            crate::operation_deser::parse_get_api_response(response)
        }
    }
}

/// Operation shape for `GetApiMapping`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_api_mapping`](crate::client::Client::get_api_mapping).
///
/// See [`crate::client::fluent_builders::GetApiMapping`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetApiMapping {
    _private: (),
}
impl GetApiMapping {
    /// Creates a new builder-style object to manufacture [`GetApiMappingInput`](crate::input::GetApiMappingInput)
    pub fn builder() -> crate::input::get_api_mapping_input::Builder {
        crate::input::get_api_mapping_input::Builder::default()
    }
    /// Creates a new `GetApiMapping` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetApiMapping {
    type Output =
        std::result::Result<crate::output::GetApiMappingOutput, crate::error::GetApiMappingError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_api_mapping_error(response)
        } else {
            crate::operation_deser::parse_get_api_mapping_response(response)
        }
    }
}

/// Operation shape for `GetApiMappings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_api_mappings`](crate::client::Client::get_api_mappings).
///
/// See [`crate::client::fluent_builders::GetApiMappings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetApiMappings {
    _private: (),
}
impl GetApiMappings {
    /// Creates a new builder-style object to manufacture [`GetApiMappingsInput`](crate::input::GetApiMappingsInput)
    pub fn builder() -> crate::input::get_api_mappings_input::Builder {
        crate::input::get_api_mappings_input::Builder::default()
    }
    /// Creates a new `GetApiMappings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetApiMappings {
    type Output =
        std::result::Result<crate::output::GetApiMappingsOutput, crate::error::GetApiMappingsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_api_mappings_error(response)
        } else {
            crate::operation_deser::parse_get_api_mappings_response(response)
        }
    }
}

/// Operation shape for `GetApis`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_apis`](crate::client::Client::get_apis).
///
/// See [`crate::client::fluent_builders::GetApis`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetApis {
    _private: (),
}
impl GetApis {
    /// Creates a new builder-style object to manufacture [`GetApisInput`](crate::input::GetApisInput)
    pub fn builder() -> crate::input::get_apis_input::Builder {
        crate::input::get_apis_input::Builder::default()
    }
    /// Creates a new `GetApis` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetApis {
    type Output = std::result::Result<crate::output::GetApisOutput, crate::error::GetApisError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_apis_error(response)
        } else {
            crate::operation_deser::parse_get_apis_response(response)
        }
    }
}

/// Operation shape for `GetAuthorizer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_authorizer`](crate::client::Client::get_authorizer).
///
/// See [`crate::client::fluent_builders::GetAuthorizer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAuthorizer {
    _private: (),
}
impl GetAuthorizer {
    /// Creates a new builder-style object to manufacture [`GetAuthorizerInput`](crate::input::GetAuthorizerInput)
    pub fn builder() -> crate::input::get_authorizer_input::Builder {
        crate::input::get_authorizer_input::Builder::default()
    }
    /// Creates a new `GetAuthorizer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAuthorizer {
    type Output =
        std::result::Result<crate::output::GetAuthorizerOutput, crate::error::GetAuthorizerError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_authorizer_error(response)
        } else {
            crate::operation_deser::parse_get_authorizer_response(response)
        }
    }
}

/// Operation shape for `GetAuthorizers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_authorizers`](crate::client::Client::get_authorizers).
///
/// See [`crate::client::fluent_builders::GetAuthorizers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAuthorizers {
    _private: (),
}
impl GetAuthorizers {
    /// Creates a new builder-style object to manufacture [`GetAuthorizersInput`](crate::input::GetAuthorizersInput)
    pub fn builder() -> crate::input::get_authorizers_input::Builder {
        crate::input::get_authorizers_input::Builder::default()
    }
    /// Creates a new `GetAuthorizers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAuthorizers {
    type Output =
        std::result::Result<crate::output::GetAuthorizersOutput, crate::error::GetAuthorizersError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_authorizers_error(response)
        } else {
            crate::operation_deser::parse_get_authorizers_response(response)
        }
    }
}

/// Operation shape for `GetDeployment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_deployment`](crate::client::Client::get_deployment).
///
/// See [`crate::client::fluent_builders::GetDeployment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDeployment {
    _private: (),
}
impl GetDeployment {
    /// Creates a new builder-style object to manufacture [`GetDeploymentInput`](crate::input::GetDeploymentInput)
    pub fn builder() -> crate::input::get_deployment_input::Builder {
        crate::input::get_deployment_input::Builder::default()
    }
    /// Creates a new `GetDeployment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDeployment {
    type Output =
        std::result::Result<crate::output::GetDeploymentOutput, crate::error::GetDeploymentError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_deployment_error(response)
        } else {
            crate::operation_deser::parse_get_deployment_response(response)
        }
    }
}

/// Operation shape for `GetDeployments`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_deployments`](crate::client::Client::get_deployments).
///
/// See [`crate::client::fluent_builders::GetDeployments`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDeployments {
    _private: (),
}
impl GetDeployments {
    /// Creates a new builder-style object to manufacture [`GetDeploymentsInput`](crate::input::GetDeploymentsInput)
    pub fn builder() -> crate::input::get_deployments_input::Builder {
        crate::input::get_deployments_input::Builder::default()
    }
    /// Creates a new `GetDeployments` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDeployments {
    type Output =
        std::result::Result<crate::output::GetDeploymentsOutput, crate::error::GetDeploymentsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_deployments_error(response)
        } else {
            crate::operation_deser::parse_get_deployments_response(response)
        }
    }
}

/// Operation shape for `GetDomainName`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_domain_name`](crate::client::Client::get_domain_name).
///
/// See [`crate::client::fluent_builders::GetDomainName`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDomainName {
    _private: (),
}
impl GetDomainName {
    /// Creates a new builder-style object to manufacture [`GetDomainNameInput`](crate::input::GetDomainNameInput)
    pub fn builder() -> crate::input::get_domain_name_input::Builder {
        crate::input::get_domain_name_input::Builder::default()
    }
    /// Creates a new `GetDomainName` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDomainName {
    type Output =
        std::result::Result<crate::output::GetDomainNameOutput, crate::error::GetDomainNameError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_domain_name_error(response)
        } else {
            crate::operation_deser::parse_get_domain_name_response(response)
        }
    }
}

/// Operation shape for `GetDomainNames`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_domain_names`](crate::client::Client::get_domain_names).
///
/// See [`crate::client::fluent_builders::GetDomainNames`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDomainNames {
    _private: (),
}
impl GetDomainNames {
    /// Creates a new builder-style object to manufacture [`GetDomainNamesInput`](crate::input::GetDomainNamesInput)
    pub fn builder() -> crate::input::get_domain_names_input::Builder {
        crate::input::get_domain_names_input::Builder::default()
    }
    /// Creates a new `GetDomainNames` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDomainNames {
    type Output =
        std::result::Result<crate::output::GetDomainNamesOutput, crate::error::GetDomainNamesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_domain_names_error(response)
        } else {
            crate::operation_deser::parse_get_domain_names_response(response)
        }
    }
}

/// Operation shape for `GetIntegration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_integration`](crate::client::Client::get_integration).
///
/// See [`crate::client::fluent_builders::GetIntegration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetIntegration {
    _private: (),
}
impl GetIntegration {
    /// Creates a new builder-style object to manufacture [`GetIntegrationInput`](crate::input::GetIntegrationInput)
    pub fn builder() -> crate::input::get_integration_input::Builder {
        crate::input::get_integration_input::Builder::default()
    }
    /// Creates a new `GetIntegration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetIntegration {
    type Output =
        std::result::Result<crate::output::GetIntegrationOutput, crate::error::GetIntegrationError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_integration_error(response)
        } else {
            crate::operation_deser::parse_get_integration_response(response)
        }
    }
}

/// Operation shape for `GetIntegrationResponse`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_integration_response`](crate::client::Client::get_integration_response).
///
/// See [`crate::client::fluent_builders::GetIntegrationResponse`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetIntegrationResponse {
    _private: (),
}
impl GetIntegrationResponse {
    /// Creates a new builder-style object to manufacture [`GetIntegrationResponseInput`](crate::input::GetIntegrationResponseInput)
    pub fn builder() -> crate::input::get_integration_response_input::Builder {
        crate::input::get_integration_response_input::Builder::default()
    }
    /// Creates a new `GetIntegrationResponse` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetIntegrationResponse {
    type Output = std::result::Result<
        crate::output::GetIntegrationResponseOutput,
        crate::error::GetIntegrationResponseError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_integration_response_error(response)
        } else {
            crate::operation_deser::parse_get_integration_response_response(response)
        }
    }
}

/// Operation shape for `GetIntegrationResponses`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_integration_responses`](crate::client::Client::get_integration_responses).
///
/// See [`crate::client::fluent_builders::GetIntegrationResponses`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetIntegrationResponses {
    _private: (),
}
impl GetIntegrationResponses {
    /// Creates a new builder-style object to manufacture [`GetIntegrationResponsesInput`](crate::input::GetIntegrationResponsesInput)
    pub fn builder() -> crate::input::get_integration_responses_input::Builder {
        crate::input::get_integration_responses_input::Builder::default()
    }
    /// Creates a new `GetIntegrationResponses` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetIntegrationResponses {
    type Output = std::result::Result<
        crate::output::GetIntegrationResponsesOutput,
        crate::error::GetIntegrationResponsesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_integration_responses_error(response)
        } else {
            crate::operation_deser::parse_get_integration_responses_response(response)
        }
    }
}

/// Operation shape for `GetIntegrations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_integrations`](crate::client::Client::get_integrations).
///
/// See [`crate::client::fluent_builders::GetIntegrations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetIntegrations {
    _private: (),
}
impl GetIntegrations {
    /// Creates a new builder-style object to manufacture [`GetIntegrationsInput`](crate::input::GetIntegrationsInput)
    pub fn builder() -> crate::input::get_integrations_input::Builder {
        crate::input::get_integrations_input::Builder::default()
    }
    /// Creates a new `GetIntegrations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetIntegrations {
    type Output = std::result::Result<
        crate::output::GetIntegrationsOutput,
        crate::error::GetIntegrationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_integrations_error(response)
        } else {
            crate::operation_deser::parse_get_integrations_response(response)
        }
    }
}

/// Operation shape for `GetModel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_model`](crate::client::Client::get_model).
///
/// See [`crate::client::fluent_builders::GetModel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetModel {
    _private: (),
}
impl GetModel {
    /// Creates a new builder-style object to manufacture [`GetModelInput`](crate::input::GetModelInput)
    pub fn builder() -> crate::input::get_model_input::Builder {
        crate::input::get_model_input::Builder::default()
    }
    /// Creates a new `GetModel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetModel {
    type Output = std::result::Result<crate::output::GetModelOutput, crate::error::GetModelError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_model_error(response)
        } else {
            crate::operation_deser::parse_get_model_response(response)
        }
    }
}

/// Operation shape for `GetModels`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_models`](crate::client::Client::get_models).
///
/// See [`crate::client::fluent_builders::GetModels`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetModels {
    _private: (),
}
impl GetModels {
    /// Creates a new builder-style object to manufacture [`GetModelsInput`](crate::input::GetModelsInput)
    pub fn builder() -> crate::input::get_models_input::Builder {
        crate::input::get_models_input::Builder::default()
    }
    /// Creates a new `GetModels` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetModels {
    type Output = std::result::Result<crate::output::GetModelsOutput, crate::error::GetModelsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_models_error(response)
        } else {
            crate::operation_deser::parse_get_models_response(response)
        }
    }
}

/// Operation shape for `GetModelTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_model_template`](crate::client::Client::get_model_template).
///
/// See [`crate::client::fluent_builders::GetModelTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetModelTemplate {
    _private: (),
}
impl GetModelTemplate {
    /// Creates a new builder-style object to manufacture [`GetModelTemplateInput`](crate::input::GetModelTemplateInput)
    pub fn builder() -> crate::input::get_model_template_input::Builder {
        crate::input::get_model_template_input::Builder::default()
    }
    /// Creates a new `GetModelTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetModelTemplate {
    type Output = std::result::Result<
        crate::output::GetModelTemplateOutput,
        crate::error::GetModelTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_model_template_error(response)
        } else {
            crate::operation_deser::parse_get_model_template_response(response)
        }
    }
}

/// Operation shape for `GetRoute`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_route`](crate::client::Client::get_route).
///
/// See [`crate::client::fluent_builders::GetRoute`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetRoute {
    _private: (),
}
impl GetRoute {
    /// Creates a new builder-style object to manufacture [`GetRouteInput`](crate::input::GetRouteInput)
    pub fn builder() -> crate::input::get_route_input::Builder {
        crate::input::get_route_input::Builder::default()
    }
    /// Creates a new `GetRoute` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetRoute {
    type Output = std::result::Result<crate::output::GetRouteOutput, crate::error::GetRouteError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_route_error(response)
        } else {
            crate::operation_deser::parse_get_route_response(response)
        }
    }
}

/// Operation shape for `GetRouteResponse`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_route_response`](crate::client::Client::get_route_response).
///
/// See [`crate::client::fluent_builders::GetRouteResponse`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetRouteResponse {
    _private: (),
}
impl GetRouteResponse {
    /// Creates a new builder-style object to manufacture [`GetRouteResponseInput`](crate::input::GetRouteResponseInput)
    pub fn builder() -> crate::input::get_route_response_input::Builder {
        crate::input::get_route_response_input::Builder::default()
    }
    /// Creates a new `GetRouteResponse` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetRouteResponse {
    type Output = std::result::Result<
        crate::output::GetRouteResponseOutput,
        crate::error::GetRouteResponseError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_route_response_error(response)
        } else {
            crate::operation_deser::parse_get_route_response_response(response)
        }
    }
}

/// Operation shape for `GetRouteResponses`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_route_responses`](crate::client::Client::get_route_responses).
///
/// See [`crate::client::fluent_builders::GetRouteResponses`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetRouteResponses {
    _private: (),
}
impl GetRouteResponses {
    /// Creates a new builder-style object to manufacture [`GetRouteResponsesInput`](crate::input::GetRouteResponsesInput)
    pub fn builder() -> crate::input::get_route_responses_input::Builder {
        crate::input::get_route_responses_input::Builder::default()
    }
    /// Creates a new `GetRouteResponses` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetRouteResponses {
    type Output = std::result::Result<
        crate::output::GetRouteResponsesOutput,
        crate::error::GetRouteResponsesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_route_responses_error(response)
        } else {
            crate::operation_deser::parse_get_route_responses_response(response)
        }
    }
}

/// Operation shape for `GetRoutes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_routes`](crate::client::Client::get_routes).
///
/// See [`crate::client::fluent_builders::GetRoutes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetRoutes {
    _private: (),
}
impl GetRoutes {
    /// Creates a new builder-style object to manufacture [`GetRoutesInput`](crate::input::GetRoutesInput)
    pub fn builder() -> crate::input::get_routes_input::Builder {
        crate::input::get_routes_input::Builder::default()
    }
    /// Creates a new `GetRoutes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetRoutes {
    type Output = std::result::Result<crate::output::GetRoutesOutput, crate::error::GetRoutesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_routes_error(response)
        } else {
            crate::operation_deser::parse_get_routes_response(response)
        }
    }
}

/// Operation shape for `GetStage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_stage`](crate::client::Client::get_stage).
///
/// See [`crate::client::fluent_builders::GetStage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetStage {
    _private: (),
}
impl GetStage {
    /// Creates a new builder-style object to manufacture [`GetStageInput`](crate::input::GetStageInput)
    pub fn builder() -> crate::input::get_stage_input::Builder {
        crate::input::get_stage_input::Builder::default()
    }
    /// Creates a new `GetStage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetStage {
    type Output = std::result::Result<crate::output::GetStageOutput, crate::error::GetStageError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_stage_error(response)
        } else {
            crate::operation_deser::parse_get_stage_response(response)
        }
    }
}

/// Operation shape for `GetStages`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_stages`](crate::client::Client::get_stages).
///
/// See [`crate::client::fluent_builders::GetStages`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetStages {
    _private: (),
}
impl GetStages {
    /// Creates a new builder-style object to manufacture [`GetStagesInput`](crate::input::GetStagesInput)
    pub fn builder() -> crate::input::get_stages_input::Builder {
        crate::input::get_stages_input::Builder::default()
    }
    /// Creates a new `GetStages` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetStages {
    type Output = std::result::Result<crate::output::GetStagesOutput, crate::error::GetStagesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_stages_error(response)
        } else {
            crate::operation_deser::parse_get_stages_response(response)
        }
    }
}

/// Operation shape for `GetTags`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_tags`](crate::client::Client::get_tags).
///
/// See [`crate::client::fluent_builders::GetTags`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetTags {
    _private: (),
}
impl GetTags {
    /// Creates a new builder-style object to manufacture [`GetTagsInput`](crate::input::GetTagsInput)
    pub fn builder() -> crate::input::get_tags_input::Builder {
        crate::input::get_tags_input::Builder::default()
    }
    /// Creates a new `GetTags` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetTags {
    type Output = std::result::Result<crate::output::GetTagsOutput, crate::error::GetTagsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_tags_error(response)
        } else {
            crate::operation_deser::parse_get_tags_response(response)
        }
    }
}

/// Operation shape for `GetVpcLink`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_vpc_link`](crate::client::Client::get_vpc_link).
///
/// See [`crate::client::fluent_builders::GetVpcLink`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetVpcLink {
    _private: (),
}
impl GetVpcLink {
    /// Creates a new builder-style object to manufacture [`GetVpcLinkInput`](crate::input::GetVpcLinkInput)
    pub fn builder() -> crate::input::get_vpc_link_input::Builder {
        crate::input::get_vpc_link_input::Builder::default()
    }
    /// Creates a new `GetVpcLink` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetVpcLink {
    type Output =
        std::result::Result<crate::output::GetVpcLinkOutput, crate::error::GetVpcLinkError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_vpc_link_error(response)
        } else {
            crate::operation_deser::parse_get_vpc_link_response(response)
        }
    }
}

/// Operation shape for `GetVpcLinks`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_vpc_links`](crate::client::Client::get_vpc_links).
///
/// See [`crate::client::fluent_builders::GetVpcLinks`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetVpcLinks {
    _private: (),
}
impl GetVpcLinks {
    /// Creates a new builder-style object to manufacture [`GetVpcLinksInput`](crate::input::GetVpcLinksInput)
    pub fn builder() -> crate::input::get_vpc_links_input::Builder {
        crate::input::get_vpc_links_input::Builder::default()
    }
    /// Creates a new `GetVpcLinks` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetVpcLinks {
    type Output =
        std::result::Result<crate::output::GetVpcLinksOutput, crate::error::GetVpcLinksError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_vpc_links_error(response)
        } else {
            crate::operation_deser::parse_get_vpc_links_response(response)
        }
    }
}

/// Operation shape for `ImportApi`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`import_api`](crate::client::Client::import_api).
///
/// See [`crate::client::fluent_builders::ImportApi`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ImportApi {
    _private: (),
}
impl ImportApi {
    /// Creates a new builder-style object to manufacture [`ImportApiInput`](crate::input::ImportApiInput)
    pub fn builder() -> crate::input::import_api_input::Builder {
        crate::input::import_api_input::Builder::default()
    }
    /// Creates a new `ImportApi` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ImportApi {
    type Output = std::result::Result<crate::output::ImportApiOutput, crate::error::ImportApiError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_import_api_error(response)
        } else {
            crate::operation_deser::parse_import_api_response(response)
        }
    }
}

/// Operation shape for `ReimportApi`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`reimport_api`](crate::client::Client::reimport_api).
///
/// See [`crate::client::fluent_builders::ReimportApi`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ReimportApi {
    _private: (),
}
impl ReimportApi {
    /// Creates a new builder-style object to manufacture [`ReimportApiInput`](crate::input::ReimportApiInput)
    pub fn builder() -> crate::input::reimport_api_input::Builder {
        crate::input::reimport_api_input::Builder::default()
    }
    /// Creates a new `ReimportApi` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ReimportApi {
    type Output =
        std::result::Result<crate::output::ReimportApiOutput, crate::error::ReimportApiError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_reimport_api_error(response)
        } else {
            crate::operation_deser::parse_reimport_api_response(response)
        }
    }
}

/// Operation shape for `ResetAuthorizersCache`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`reset_authorizers_cache`](crate::client::Client::reset_authorizers_cache).
///
/// See [`crate::client::fluent_builders::ResetAuthorizersCache`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ResetAuthorizersCache {
    _private: (),
}
impl ResetAuthorizersCache {
    /// Creates a new builder-style object to manufacture [`ResetAuthorizersCacheInput`](crate::input::ResetAuthorizersCacheInput)
    pub fn builder() -> crate::input::reset_authorizers_cache_input::Builder {
        crate::input::reset_authorizers_cache_input::Builder::default()
    }
    /// Creates a new `ResetAuthorizersCache` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ResetAuthorizersCache {
    type Output = std::result::Result<
        crate::output::ResetAuthorizersCacheOutput,
        crate::error::ResetAuthorizersCacheError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_reset_authorizers_cache_error(response)
        } else {
            crate::operation_deser::parse_reset_authorizers_cache_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateApi`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_api`](crate::client::Client::update_api).
///
/// See [`crate::client::fluent_builders::UpdateApi`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateApi {
    _private: (),
}
impl UpdateApi {
    /// Creates a new builder-style object to manufacture [`UpdateApiInput`](crate::input::UpdateApiInput)
    pub fn builder() -> crate::input::update_api_input::Builder {
        crate::input::update_api_input::Builder::default()
    }
    /// Creates a new `UpdateApi` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateApi {
    type Output = std::result::Result<crate::output::UpdateApiOutput, crate::error::UpdateApiError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_api_error(response)
        } else {
            crate::operation_deser::parse_update_api_response(response)
        }
    }
}

/// Operation shape for `UpdateApiMapping`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_api_mapping`](crate::client::Client::update_api_mapping).
///
/// See [`crate::client::fluent_builders::UpdateApiMapping`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateApiMapping {
    _private: (),
}
impl UpdateApiMapping {
    /// Creates a new builder-style object to manufacture [`UpdateApiMappingInput`](crate::input::UpdateApiMappingInput)
    pub fn builder() -> crate::input::update_api_mapping_input::Builder {
        crate::input::update_api_mapping_input::Builder::default()
    }
    /// Creates a new `UpdateApiMapping` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateApiMapping {
    type Output = std::result::Result<
        crate::output::UpdateApiMappingOutput,
        crate::error::UpdateApiMappingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_api_mapping_error(response)
        } else {
            crate::operation_deser::parse_update_api_mapping_response(response)
        }
    }
}

/// Operation shape for `UpdateAuthorizer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_authorizer`](crate::client::Client::update_authorizer).
///
/// See [`crate::client::fluent_builders::UpdateAuthorizer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateAuthorizer {
    _private: (),
}
impl UpdateAuthorizer {
    /// Creates a new builder-style object to manufacture [`UpdateAuthorizerInput`](crate::input::UpdateAuthorizerInput)
    pub fn builder() -> crate::input::update_authorizer_input::Builder {
        crate::input::update_authorizer_input::Builder::default()
    }
    /// Creates a new `UpdateAuthorizer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateAuthorizer {
    type Output = std::result::Result<
        crate::output::UpdateAuthorizerOutput,
        crate::error::UpdateAuthorizerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_authorizer_error(response)
        } else {
            crate::operation_deser::parse_update_authorizer_response(response)
        }
    }
}

/// Operation shape for `UpdateDeployment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_deployment`](crate::client::Client::update_deployment).
///
/// See [`crate::client::fluent_builders::UpdateDeployment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDeployment {
    _private: (),
}
impl UpdateDeployment {
    /// Creates a new builder-style object to manufacture [`UpdateDeploymentInput`](crate::input::UpdateDeploymentInput)
    pub fn builder() -> crate::input::update_deployment_input::Builder {
        crate::input::update_deployment_input::Builder::default()
    }
    /// Creates a new `UpdateDeployment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDeployment {
    type Output = std::result::Result<
        crate::output::UpdateDeploymentOutput,
        crate::error::UpdateDeploymentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_deployment_error(response)
        } else {
            crate::operation_deser::parse_update_deployment_response(response)
        }
    }
}

/// Operation shape for `UpdateDomainName`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_domain_name`](crate::client::Client::update_domain_name).
///
/// See [`crate::client::fluent_builders::UpdateDomainName`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDomainName {
    _private: (),
}
impl UpdateDomainName {
    /// Creates a new builder-style object to manufacture [`UpdateDomainNameInput`](crate::input::UpdateDomainNameInput)
    pub fn builder() -> crate::input::update_domain_name_input::Builder {
        crate::input::update_domain_name_input::Builder::default()
    }
    /// Creates a new `UpdateDomainName` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDomainName {
    type Output = std::result::Result<
        crate::output::UpdateDomainNameOutput,
        crate::error::UpdateDomainNameError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_domain_name_error(response)
        } else {
            crate::operation_deser::parse_update_domain_name_response(response)
        }
    }
}

/// Operation shape for `UpdateIntegration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_integration`](crate::client::Client::update_integration).
///
/// See [`crate::client::fluent_builders::UpdateIntegration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateIntegration {
    _private: (),
}
impl UpdateIntegration {
    /// Creates a new builder-style object to manufacture [`UpdateIntegrationInput`](crate::input::UpdateIntegrationInput)
    pub fn builder() -> crate::input::update_integration_input::Builder {
        crate::input::update_integration_input::Builder::default()
    }
    /// Creates a new `UpdateIntegration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateIntegration {
    type Output = std::result::Result<
        crate::output::UpdateIntegrationOutput,
        crate::error::UpdateIntegrationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_integration_error(response)
        } else {
            crate::operation_deser::parse_update_integration_response(response)
        }
    }
}

/// Operation shape for `UpdateIntegrationResponse`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_integration_response`](crate::client::Client::update_integration_response).
///
/// See [`crate::client::fluent_builders::UpdateIntegrationResponse`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateIntegrationResponse {
    _private: (),
}
impl UpdateIntegrationResponse {
    /// Creates a new builder-style object to manufacture [`UpdateIntegrationResponseInput`](crate::input::UpdateIntegrationResponseInput)
    pub fn builder() -> crate::input::update_integration_response_input::Builder {
        crate::input::update_integration_response_input::Builder::default()
    }
    /// Creates a new `UpdateIntegrationResponse` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateIntegrationResponse {
    type Output = std::result::Result<
        crate::output::UpdateIntegrationResponseOutput,
        crate::error::UpdateIntegrationResponseError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_integration_response_error(response)
        } else {
            crate::operation_deser::parse_update_integration_response_response(response)
        }
    }
}

/// Operation shape for `UpdateModel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_model`](crate::client::Client::update_model).
///
/// See [`crate::client::fluent_builders::UpdateModel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateModel {
    _private: (),
}
impl UpdateModel {
    /// Creates a new builder-style object to manufacture [`UpdateModelInput`](crate::input::UpdateModelInput)
    pub fn builder() -> crate::input::update_model_input::Builder {
        crate::input::update_model_input::Builder::default()
    }
    /// Creates a new `UpdateModel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateModel {
    type Output =
        std::result::Result<crate::output::UpdateModelOutput, crate::error::UpdateModelError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_model_error(response)
        } else {
            crate::operation_deser::parse_update_model_response(response)
        }
    }
}

/// Operation shape for `UpdateRoute`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_route`](crate::client::Client::update_route).
///
/// See [`crate::client::fluent_builders::UpdateRoute`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateRoute {
    _private: (),
}
impl UpdateRoute {
    /// Creates a new builder-style object to manufacture [`UpdateRouteInput`](crate::input::UpdateRouteInput)
    pub fn builder() -> crate::input::update_route_input::Builder {
        crate::input::update_route_input::Builder::default()
    }
    /// Creates a new `UpdateRoute` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateRoute {
    type Output =
        std::result::Result<crate::output::UpdateRouteOutput, crate::error::UpdateRouteError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_route_error(response)
        } else {
            crate::operation_deser::parse_update_route_response(response)
        }
    }
}

/// Operation shape for `UpdateRouteResponse`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_route_response`](crate::client::Client::update_route_response).
///
/// See [`crate::client::fluent_builders::UpdateRouteResponse`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateRouteResponse {
    _private: (),
}
impl UpdateRouteResponse {
    /// Creates a new builder-style object to manufacture [`UpdateRouteResponseInput`](crate::input::UpdateRouteResponseInput)
    pub fn builder() -> crate::input::update_route_response_input::Builder {
        crate::input::update_route_response_input::Builder::default()
    }
    /// Creates a new `UpdateRouteResponse` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateRouteResponse {
    type Output = std::result::Result<
        crate::output::UpdateRouteResponseOutput,
        crate::error::UpdateRouteResponseError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_route_response_error(response)
        } else {
            crate::operation_deser::parse_update_route_response_response(response)
        }
    }
}

/// Operation shape for `UpdateStage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_stage`](crate::client::Client::update_stage).
///
/// See [`crate::client::fluent_builders::UpdateStage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateStage {
    _private: (),
}
impl UpdateStage {
    /// Creates a new builder-style object to manufacture [`UpdateStageInput`](crate::input::UpdateStageInput)
    pub fn builder() -> crate::input::update_stage_input::Builder {
        crate::input::update_stage_input::Builder::default()
    }
    /// Creates a new `UpdateStage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateStage {
    type Output =
        std::result::Result<crate::output::UpdateStageOutput, crate::error::UpdateStageError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_stage_error(response)
        } else {
            crate::operation_deser::parse_update_stage_response(response)
        }
    }
}

/// Operation shape for `UpdateVpcLink`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_vpc_link`](crate::client::Client::update_vpc_link).
///
/// See [`crate::client::fluent_builders::UpdateVpcLink`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateVpcLink {
    _private: (),
}
impl UpdateVpcLink {
    /// Creates a new builder-style object to manufacture [`UpdateVpcLinkInput`](crate::input::UpdateVpcLinkInput)
    pub fn builder() -> crate::input::update_vpc_link_input::Builder {
        crate::input::update_vpc_link_input::Builder::default()
    }
    /// Creates a new `UpdateVpcLink` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateVpcLink {
    type Output =
        std::result::Result<crate::output::UpdateVpcLinkOutput, crate::error::UpdateVpcLinkError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_vpc_link_error(response)
        } else {
            crate::operation_deser::parse_update_vpc_link_response(response)
        }
    }
}
