// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>The version of the VPC link.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum VpcLinkVersion {
    #[allow(missing_docs)] // documentation missing in model
    V2,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for VpcLinkVersion {
    fn from(s: &str) -> Self {
        match s {
            "V2" => VpcLinkVersion::V2,
            other => VpcLinkVersion::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for VpcLinkVersion {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(VpcLinkVersion::from(s))
    }
}
impl VpcLinkVersion {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            VpcLinkVersion::V2 => "V2",
            VpcLinkVersion::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["V2"]
    }
}
impl AsRef<str> for VpcLinkVersion {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The status of the VPC link.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum VpcLinkStatus {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Inactive,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for VpcLinkStatus {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => VpcLinkStatus::Available,
            "DELETING" => VpcLinkStatus::Deleting,
            "FAILED" => VpcLinkStatus::Failed,
            "INACTIVE" => VpcLinkStatus::Inactive,
            "PENDING" => VpcLinkStatus::Pending,
            other => VpcLinkStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for VpcLinkStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(VpcLinkStatus::from(s))
    }
}
impl VpcLinkStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            VpcLinkStatus::Available => "AVAILABLE",
            VpcLinkStatus::Deleting => "DELETING",
            VpcLinkStatus::Failed => "FAILED",
            VpcLinkStatus::Inactive => "INACTIVE",
            VpcLinkStatus::Pending => "PENDING",
            VpcLinkStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AVAILABLE", "DELETING", "FAILED", "INACTIVE", "PENDING"]
    }
}
impl AsRef<str> for VpcLinkStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents a collection of route settings.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RouteSettings {
    /// <p>Specifies whether (true) or not (false) data trace logging is enabled for this route. This property affects the log entries pushed to Amazon CloudWatch Logs. Supported only for WebSocket APIs.</p>
    pub data_trace_enabled: bool,
    /// <p>Specifies whether detailed metrics are enabled.</p>
    pub detailed_metrics_enabled: bool,
    /// <p>Specifies the logging level for this route: INFO, ERROR, or OFF. This property affects the log entries pushed to Amazon CloudWatch Logs. Supported only for WebSocket APIs.</p>
    pub logging_level: std::option::Option<crate::model::LoggingLevel>,
    /// <p>Specifies the throttling burst limit.</p>
    pub throttling_burst_limit: i32,
    /// <p>Specifies the throttling rate limit.</p>
    pub throttling_rate_limit: f64,
}
impl RouteSettings {
    /// <p>Specifies whether (true) or not (false) data trace logging is enabled for this route. This property affects the log entries pushed to Amazon CloudWatch Logs. Supported only for WebSocket APIs.</p>
    pub fn data_trace_enabled(&self) -> bool {
        self.data_trace_enabled
    }
    /// <p>Specifies whether detailed metrics are enabled.</p>
    pub fn detailed_metrics_enabled(&self) -> bool {
        self.detailed_metrics_enabled
    }
    /// <p>Specifies the logging level for this route: INFO, ERROR, or OFF. This property affects the log entries pushed to Amazon CloudWatch Logs. Supported only for WebSocket APIs.</p>
    pub fn logging_level(&self) -> std::option::Option<&crate::model::LoggingLevel> {
        self.logging_level.as_ref()
    }
    /// <p>Specifies the throttling burst limit.</p>
    pub fn throttling_burst_limit(&self) -> i32 {
        self.throttling_burst_limit
    }
    /// <p>Specifies the throttling rate limit.</p>
    pub fn throttling_rate_limit(&self) -> f64 {
        self.throttling_rate_limit
    }
}
impl std::fmt::Debug for RouteSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RouteSettings");
        formatter.field("data_trace_enabled", &self.data_trace_enabled);
        formatter.field("detailed_metrics_enabled", &self.detailed_metrics_enabled);
        formatter.field("logging_level", &self.logging_level);
        formatter.field("throttling_burst_limit", &self.throttling_burst_limit);
        formatter.field("throttling_rate_limit", &self.throttling_rate_limit);
        formatter.finish()
    }
}
/// See [`RouteSettings`](crate::model::RouteSettings)
pub mod route_settings {
    /// A builder for [`RouteSettings`](crate::model::RouteSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_trace_enabled: std::option::Option<bool>,
        pub(crate) detailed_metrics_enabled: std::option::Option<bool>,
        pub(crate) logging_level: std::option::Option<crate::model::LoggingLevel>,
        pub(crate) throttling_burst_limit: std::option::Option<i32>,
        pub(crate) throttling_rate_limit: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>Specifies whether (true) or not (false) data trace logging is enabled for this route. This property affects the log entries pushed to Amazon CloudWatch Logs. Supported only for WebSocket APIs.</p>
        pub fn data_trace_enabled(mut self, input: bool) -> Self {
            self.data_trace_enabled = Some(input);
            self
        }
        /// <p>Specifies whether (true) or not (false) data trace logging is enabled for this route. This property affects the log entries pushed to Amazon CloudWatch Logs. Supported only for WebSocket APIs.</p>
        pub fn set_data_trace_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.data_trace_enabled = input;
            self
        }
        /// <p>Specifies whether detailed metrics are enabled.</p>
        pub fn detailed_metrics_enabled(mut self, input: bool) -> Self {
            self.detailed_metrics_enabled = Some(input);
            self
        }
        /// <p>Specifies whether detailed metrics are enabled.</p>
        pub fn set_detailed_metrics_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.detailed_metrics_enabled = input;
            self
        }
        /// <p>Specifies the logging level for this route: INFO, ERROR, or OFF. This property affects the log entries pushed to Amazon CloudWatch Logs. Supported only for WebSocket APIs.</p>
        pub fn logging_level(mut self, input: crate::model::LoggingLevel) -> Self {
            self.logging_level = Some(input);
            self
        }
        /// <p>Specifies the logging level for this route: INFO, ERROR, or OFF. This property affects the log entries pushed to Amazon CloudWatch Logs. Supported only for WebSocket APIs.</p>
        pub fn set_logging_level(
            mut self,
            input: std::option::Option<crate::model::LoggingLevel>,
        ) -> Self {
            self.logging_level = input;
            self
        }
        /// <p>Specifies the throttling burst limit.</p>
        pub fn throttling_burst_limit(mut self, input: i32) -> Self {
            self.throttling_burst_limit = Some(input);
            self
        }
        /// <p>Specifies the throttling burst limit.</p>
        pub fn set_throttling_burst_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.throttling_burst_limit = input;
            self
        }
        /// <p>Specifies the throttling rate limit.</p>
        pub fn throttling_rate_limit(mut self, input: f64) -> Self {
            self.throttling_rate_limit = Some(input);
            self
        }
        /// <p>Specifies the throttling rate limit.</p>
        pub fn set_throttling_rate_limit(mut self, input: std::option::Option<f64>) -> Self {
            self.throttling_rate_limit = input;
            self
        }
        /// Consumes the builder and constructs a [`RouteSettings`](crate::model::RouteSettings)
        pub fn build(self) -> crate::model::RouteSettings {
            crate::model::RouteSettings {
                data_trace_enabled: self.data_trace_enabled.unwrap_or_default(),
                detailed_metrics_enabled: self.detailed_metrics_enabled.unwrap_or_default(),
                logging_level: self.logging_level,
                throttling_burst_limit: self.throttling_burst_limit.unwrap_or_default(),
                throttling_rate_limit: self.throttling_rate_limit.unwrap_or_default(),
            }
        }
    }
}
impl RouteSettings {
    /// Creates a new builder-style object to manufacture [`RouteSettings`](crate::model::RouteSettings)
    pub fn builder() -> crate::model::route_settings::Builder {
        crate::model::route_settings::Builder::default()
    }
}

/// <p>The logging level.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LoggingLevel {
    #[allow(missing_docs)] // documentation missing in model
    Error,
    #[allow(missing_docs)] // documentation missing in model
    Info,
    #[allow(missing_docs)] // documentation missing in model
    Off,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LoggingLevel {
    fn from(s: &str) -> Self {
        match s {
            "ERROR" => LoggingLevel::Error,
            "INFO" => LoggingLevel::Info,
            "OFF" => LoggingLevel::Off,
            other => LoggingLevel::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LoggingLevel {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LoggingLevel::from(s))
    }
}
impl LoggingLevel {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LoggingLevel::Error => "ERROR",
            LoggingLevel::Info => "INFO",
            LoggingLevel::Off => "OFF",
            LoggingLevel::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ERROR", "INFO", "OFF"]
    }
}
impl AsRef<str> for LoggingLevel {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Settings for logging access in a stage.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessLogSettings {
    /// <p>The ARN of the CloudWatch Logs log group to receive access logs.</p>
    pub destination_arn: std::option::Option<std::string::String>,
    /// <p>A single line format of the access logs of data, as specified by selected $context variables. The format must include at least $context.requestId.</p>
    pub format: std::option::Option<std::string::String>,
}
impl AccessLogSettings {
    /// <p>The ARN of the CloudWatch Logs log group to receive access logs.</p>
    pub fn destination_arn(&self) -> std::option::Option<&str> {
        self.destination_arn.as_deref()
    }
    /// <p>A single line format of the access logs of data, as specified by selected $context variables. The format must include at least $context.requestId.</p>
    pub fn format(&self) -> std::option::Option<&str> {
        self.format.as_deref()
    }
}
impl std::fmt::Debug for AccessLogSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessLogSettings");
        formatter.field("destination_arn", &self.destination_arn);
        formatter.field("format", &self.format);
        formatter.finish()
    }
}
/// See [`AccessLogSettings`](crate::model::AccessLogSettings)
pub mod access_log_settings {
    /// A builder for [`AccessLogSettings`](crate::model::AccessLogSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) destination_arn: std::option::Option<std::string::String>,
        pub(crate) format: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the CloudWatch Logs log group to receive access logs.</p>
        pub fn destination_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the CloudWatch Logs log group to receive access logs.</p>
        pub fn set_destination_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_arn = input;
            self
        }
        /// <p>A single line format of the access logs of data, as specified by selected $context variables. The format must include at least $context.requestId.</p>
        pub fn format(mut self, input: impl Into<std::string::String>) -> Self {
            self.format = Some(input.into());
            self
        }
        /// <p>A single line format of the access logs of data, as specified by selected $context variables. The format must include at least $context.requestId.</p>
        pub fn set_format(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.format = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessLogSettings`](crate::model::AccessLogSettings)
        pub fn build(self) -> crate::model::AccessLogSettings {
            crate::model::AccessLogSettings {
                destination_arn: self.destination_arn,
                format: self.format,
            }
        }
    }
}
impl AccessLogSettings {
    /// Creates a new builder-style object to manufacture [`AccessLogSettings`](crate::model::AccessLogSettings)
    pub fn builder() -> crate::model::access_log_settings::Builder {
        crate::model::access_log_settings::Builder::default()
    }
}

/// <p>Validation constraints imposed on parameters of a request (path, query string, headers).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ParameterConstraints {
    /// <p>Whether or not the parameter is required.</p>
    pub required: bool,
}
impl ParameterConstraints {
    /// <p>Whether or not the parameter is required.</p>
    pub fn required(&self) -> bool {
        self.required
    }
}
impl std::fmt::Debug for ParameterConstraints {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ParameterConstraints");
        formatter.field("required", &self.required);
        formatter.finish()
    }
}
/// See [`ParameterConstraints`](crate::model::ParameterConstraints)
pub mod parameter_constraints {
    /// A builder for [`ParameterConstraints`](crate::model::ParameterConstraints)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) required: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Whether or not the parameter is required.</p>
        pub fn required(mut self, input: bool) -> Self {
            self.required = Some(input);
            self
        }
        /// <p>Whether or not the parameter is required.</p>
        pub fn set_required(mut self, input: std::option::Option<bool>) -> Self {
            self.required = input;
            self
        }
        /// Consumes the builder and constructs a [`ParameterConstraints`](crate::model::ParameterConstraints)
        pub fn build(self) -> crate::model::ParameterConstraints {
            crate::model::ParameterConstraints {
                required: self.required.unwrap_or_default(),
            }
        }
    }
}
impl ParameterConstraints {
    /// Creates a new builder-style object to manufacture [`ParameterConstraints`](crate::model::ParameterConstraints)
    pub fn builder() -> crate::model::parameter_constraints::Builder {
        crate::model::parameter_constraints::Builder::default()
    }
}

/// <p>The authorization type. For WebSocket APIs, valid values are NONE for open access, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer. For HTTP APIs, valid values are NONE for open access, JWT for using JSON Web Tokens, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AuthorizationType {
    #[allow(missing_docs)] // documentation missing in model
    AwsIam,
    #[allow(missing_docs)] // documentation missing in model
    Custom,
    #[allow(missing_docs)] // documentation missing in model
    Jwt,
    #[allow(missing_docs)] // documentation missing in model
    None,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AuthorizationType {
    fn from(s: &str) -> Self {
        match s {
            "AWS_IAM" => AuthorizationType::AwsIam,
            "CUSTOM" => AuthorizationType::Custom,
            "JWT" => AuthorizationType::Jwt,
            "NONE" => AuthorizationType::None,
            other => AuthorizationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AuthorizationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AuthorizationType::from(s))
    }
}
impl AuthorizationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AuthorizationType::AwsIam => "AWS_IAM",
            AuthorizationType::Custom => "CUSTOM",
            AuthorizationType::Jwt => "JWT",
            AuthorizationType::None => "NONE",
            AuthorizationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AWS_IAM", "CUSTOM", "JWT", "NONE"]
    }
}
impl AsRef<str> for AuthorizationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies how to handle response payload content type conversions. Supported only for WebSocket APIs.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ContentHandlingStrategy {
    #[allow(missing_docs)] // documentation missing in model
    ConvertToBinary,
    #[allow(missing_docs)] // documentation missing in model
    ConvertToText,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ContentHandlingStrategy {
    fn from(s: &str) -> Self {
        match s {
            "CONVERT_TO_BINARY" => ContentHandlingStrategy::ConvertToBinary,
            "CONVERT_TO_TEXT" => ContentHandlingStrategy::ConvertToText,
            other => ContentHandlingStrategy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ContentHandlingStrategy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ContentHandlingStrategy::from(s))
    }
}
impl ContentHandlingStrategy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ContentHandlingStrategy::ConvertToBinary => "CONVERT_TO_BINARY",
            ContentHandlingStrategy::ConvertToText => "CONVERT_TO_TEXT",
            ContentHandlingStrategy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CONVERT_TO_BINARY", "CONVERT_TO_TEXT"]
    }
}
impl AsRef<str> for ContentHandlingStrategy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The TLS configuration for a private integration. If you specify a TLS configuration, private integration traffic uses the HTTPS protocol. Supported only for HTTP APIs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TlsConfig {
    /// <p>If you specify a server name, API Gateway uses it to verify the hostname on the integration's certificate. The server name is also included in the TLS handshake to support Server Name Indication (SNI) or virtual hosting.</p>
    pub server_name_to_verify: std::option::Option<std::string::String>,
}
impl TlsConfig {
    /// <p>If you specify a server name, API Gateway uses it to verify the hostname on the integration's certificate. The server name is also included in the TLS handshake to support Server Name Indication (SNI) or virtual hosting.</p>
    pub fn server_name_to_verify(&self) -> std::option::Option<&str> {
        self.server_name_to_verify.as_deref()
    }
}
impl std::fmt::Debug for TlsConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TlsConfig");
        formatter.field("server_name_to_verify", &self.server_name_to_verify);
        formatter.finish()
    }
}
/// See [`TlsConfig`](crate::model::TlsConfig)
pub mod tls_config {
    /// A builder for [`TlsConfig`](crate::model::TlsConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) server_name_to_verify: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>If you specify a server name, API Gateway uses it to verify the hostname on the integration's certificate. The server name is also included in the TLS handshake to support Server Name Indication (SNI) or virtual hosting.</p>
        pub fn server_name_to_verify(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_name_to_verify = Some(input.into());
            self
        }
        /// <p>If you specify a server name, API Gateway uses it to verify the hostname on the integration's certificate. The server name is also included in the TLS handshake to support Server Name Indication (SNI) or virtual hosting.</p>
        pub fn set_server_name_to_verify(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.server_name_to_verify = input;
            self
        }
        /// Consumes the builder and constructs a [`TlsConfig`](crate::model::TlsConfig)
        pub fn build(self) -> crate::model::TlsConfig {
            crate::model::TlsConfig {
                server_name_to_verify: self.server_name_to_verify,
            }
        }
    }
}
impl TlsConfig {
    /// Creates a new builder-style object to manufacture [`TlsConfig`](crate::model::TlsConfig)
    pub fn builder() -> crate::model::tls_config::Builder {
        crate::model::tls_config::Builder::default()
    }
}

/// <p>Represents passthrough behavior for an integration response. Supported only for WebSocket APIs.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PassthroughBehavior {
    #[allow(missing_docs)] // documentation missing in model
    Never,
    #[allow(missing_docs)] // documentation missing in model
    WhenNoMatch,
    #[allow(missing_docs)] // documentation missing in model
    WhenNoTemplates,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PassthroughBehavior {
    fn from(s: &str) -> Self {
        match s {
            "NEVER" => PassthroughBehavior::Never,
            "WHEN_NO_MATCH" => PassthroughBehavior::WhenNoMatch,
            "WHEN_NO_TEMPLATES" => PassthroughBehavior::WhenNoTemplates,
            other => PassthroughBehavior::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PassthroughBehavior {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PassthroughBehavior::from(s))
    }
}
impl PassthroughBehavior {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PassthroughBehavior::Never => "NEVER",
            PassthroughBehavior::WhenNoMatch => "WHEN_NO_MATCH",
            PassthroughBehavior::WhenNoTemplates => "WHEN_NO_TEMPLATES",
            PassthroughBehavior::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NEVER", "WHEN_NO_MATCH", "WHEN_NO_TEMPLATES"]
    }
}
impl AsRef<str> for PassthroughBehavior {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents an API method integration type.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum IntegrationType {
    #[allow(missing_docs)] // documentation missing in model
    Aws,
    #[allow(missing_docs)] // documentation missing in model
    AwsProxy,
    #[allow(missing_docs)] // documentation missing in model
    Http,
    #[allow(missing_docs)] // documentation missing in model
    HttpProxy,
    #[allow(missing_docs)] // documentation missing in model
    Mock,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for IntegrationType {
    fn from(s: &str) -> Self {
        match s {
            "AWS" => IntegrationType::Aws,
            "AWS_PROXY" => IntegrationType::AwsProxy,
            "HTTP" => IntegrationType::Http,
            "HTTP_PROXY" => IntegrationType::HttpProxy,
            "MOCK" => IntegrationType::Mock,
            other => IntegrationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for IntegrationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(IntegrationType::from(s))
    }
}
impl IntegrationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            IntegrationType::Aws => "AWS",
            IntegrationType::AwsProxy => "AWS_PROXY",
            IntegrationType::Http => "HTTP",
            IntegrationType::HttpProxy => "HTTP_PROXY",
            IntegrationType::Mock => "MOCK",
            IntegrationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AWS", "AWS_PROXY", "HTTP", "HTTP_PROXY", "MOCK"]
    }
}
impl AsRef<str> for IntegrationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents a connection type.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConnectionType {
    #[allow(missing_docs)] // documentation missing in model
    Internet,
    #[allow(missing_docs)] // documentation missing in model
    VpcLink,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConnectionType {
    fn from(s: &str) -> Self {
        match s {
            "INTERNET" => ConnectionType::Internet,
            "VPC_LINK" => ConnectionType::VpcLink,
            other => ConnectionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConnectionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConnectionType::from(s))
    }
}
impl ConnectionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConnectionType::Internet => "INTERNET",
            ConnectionType::VpcLink => "VPC_LINK",
            ConnectionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["INTERNET", "VPC_LINK"]
    }
}
impl AsRef<str> for ConnectionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The TLS configuration for a private integration. If you specify a TLS configuration, private integration traffic uses the HTTPS protocol. Supported only for HTTP APIs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TlsConfigInput {
    /// <p>If you specify a server name, API Gateway uses it to verify the hostname on the integration's certificate. The server name is also included in the TLS handshake to support Server Name Indication (SNI) or virtual hosting.</p>
    pub server_name_to_verify: std::option::Option<std::string::String>,
}
impl TlsConfigInput {
    /// <p>If you specify a server name, API Gateway uses it to verify the hostname on the integration's certificate. The server name is also included in the TLS handshake to support Server Name Indication (SNI) or virtual hosting.</p>
    pub fn server_name_to_verify(&self) -> std::option::Option<&str> {
        self.server_name_to_verify.as_deref()
    }
}
impl std::fmt::Debug for TlsConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TlsConfigInput");
        formatter.field("server_name_to_verify", &self.server_name_to_verify);
        formatter.finish()
    }
}
/// See [`TlsConfigInput`](crate::model::TlsConfigInput)
pub mod tls_config_input {
    /// A builder for [`TlsConfigInput`](crate::model::TlsConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) server_name_to_verify: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>If you specify a server name, API Gateway uses it to verify the hostname on the integration's certificate. The server name is also included in the TLS handshake to support Server Name Indication (SNI) or virtual hosting.</p>
        pub fn server_name_to_verify(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_name_to_verify = Some(input.into());
            self
        }
        /// <p>If you specify a server name, API Gateway uses it to verify the hostname on the integration's certificate. The server name is also included in the TLS handshake to support Server Name Indication (SNI) or virtual hosting.</p>
        pub fn set_server_name_to_verify(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.server_name_to_verify = input;
            self
        }
        /// Consumes the builder and constructs a [`TlsConfigInput`](crate::model::TlsConfigInput)
        pub fn build(self) -> crate::model::TlsConfigInput {
            crate::model::TlsConfigInput {
                server_name_to_verify: self.server_name_to_verify,
            }
        }
    }
}
impl TlsConfigInput {
    /// Creates a new builder-style object to manufacture [`TlsConfigInput`](crate::model::TlsConfigInput)
    pub fn builder() -> crate::model::tls_config_input::Builder {
        crate::model::tls_config_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MutualTlsAuthentication {
    /// <p>An Amazon S3 URL that specifies the truststore for mutual TLS authentication, for example, s3://<replaceable>bucket-name</replaceable>/<replaceable>key-name</replaceable>. The truststore can contain certificates from public or private certificate authorities. To update the truststore, upload a new version to S3, and then update your custom domain name to use the new version. To update the truststore, you must have permissions to access the S3 object.</p>
    pub truststore_uri: std::option::Option<std::string::String>,
    /// <p>The version of the S3 object that contains your truststore. To specify a version, you must have versioning enabled for the S3 bucket.</p>
    pub truststore_version: std::option::Option<std::string::String>,
    /// <p>A list of warnings that API Gateway returns while processing your truststore. Invalid certificates produce warnings. Mutual TLS is still enabled, but some clients might not be able to access your API. To resolve warnings, upload a new truststore to S3, and then update you domain name to use the new version.</p>
    pub truststore_warnings: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl MutualTlsAuthentication {
    /// <p>An Amazon S3 URL that specifies the truststore for mutual TLS authentication, for example, s3://<replaceable>bucket-name</replaceable>/<replaceable>key-name</replaceable>. The truststore can contain certificates from public or private certificate authorities. To update the truststore, upload a new version to S3, and then update your custom domain name to use the new version. To update the truststore, you must have permissions to access the S3 object.</p>
    pub fn truststore_uri(&self) -> std::option::Option<&str> {
        self.truststore_uri.as_deref()
    }
    /// <p>The version of the S3 object that contains your truststore. To specify a version, you must have versioning enabled for the S3 bucket.</p>
    pub fn truststore_version(&self) -> std::option::Option<&str> {
        self.truststore_version.as_deref()
    }
    /// <p>A list of warnings that API Gateway returns while processing your truststore. Invalid certificates produce warnings. Mutual TLS is still enabled, but some clients might not be able to access your API. To resolve warnings, upload a new truststore to S3, and then update you domain name to use the new version.</p>
    pub fn truststore_warnings(&self) -> std::option::Option<&[std::string::String]> {
        self.truststore_warnings.as_deref()
    }
}
impl std::fmt::Debug for MutualTlsAuthentication {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MutualTlsAuthentication");
        formatter.field("truststore_uri", &self.truststore_uri);
        formatter.field("truststore_version", &self.truststore_version);
        formatter.field("truststore_warnings", &self.truststore_warnings);
        formatter.finish()
    }
}
/// See [`MutualTlsAuthentication`](crate::model::MutualTlsAuthentication)
pub mod mutual_tls_authentication {
    /// A builder for [`MutualTlsAuthentication`](crate::model::MutualTlsAuthentication)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) truststore_uri: std::option::Option<std::string::String>,
        pub(crate) truststore_version: std::option::Option<std::string::String>,
        pub(crate) truststore_warnings: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>An Amazon S3 URL that specifies the truststore for mutual TLS authentication, for example, s3://<replaceable>bucket-name</replaceable>/<replaceable>key-name</replaceable>. The truststore can contain certificates from public or private certificate authorities. To update the truststore, upload a new version to S3, and then update your custom domain name to use the new version. To update the truststore, you must have permissions to access the S3 object.</p>
        pub fn truststore_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.truststore_uri = Some(input.into());
            self
        }
        /// <p>An Amazon S3 URL that specifies the truststore for mutual TLS authentication, for example, s3://<replaceable>bucket-name</replaceable>/<replaceable>key-name</replaceable>. The truststore can contain certificates from public or private certificate authorities. To update the truststore, upload a new version to S3, and then update your custom domain name to use the new version. To update the truststore, you must have permissions to access the S3 object.</p>
        pub fn set_truststore_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.truststore_uri = input;
            self
        }
        /// <p>The version of the S3 object that contains your truststore. To specify a version, you must have versioning enabled for the S3 bucket.</p>
        pub fn truststore_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.truststore_version = Some(input.into());
            self
        }
        /// <p>The version of the S3 object that contains your truststore. To specify a version, you must have versioning enabled for the S3 bucket.</p>
        pub fn set_truststore_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.truststore_version = input;
            self
        }
        /// Appends an item to `truststore_warnings`.
        ///
        /// To override the contents of this collection use [`set_truststore_warnings`](Self::set_truststore_warnings).
        ///
        /// <p>A list of warnings that API Gateway returns while processing your truststore. Invalid certificates produce warnings. Mutual TLS is still enabled, but some clients might not be able to access your API. To resolve warnings, upload a new truststore to S3, and then update you domain name to use the new version.</p>
        pub fn truststore_warnings(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.truststore_warnings.unwrap_or_default();
            v.push(input.into());
            self.truststore_warnings = Some(v);
            self
        }
        /// <p>A list of warnings that API Gateway returns while processing your truststore. Invalid certificates produce warnings. Mutual TLS is still enabled, but some clients might not be able to access your API. To resolve warnings, upload a new truststore to S3, and then update you domain name to use the new version.</p>
        pub fn set_truststore_warnings(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.truststore_warnings = input;
            self
        }
        /// Consumes the builder and constructs a [`MutualTlsAuthentication`](crate::model::MutualTlsAuthentication)
        pub fn build(self) -> crate::model::MutualTlsAuthentication {
            crate::model::MutualTlsAuthentication {
                truststore_uri: self.truststore_uri,
                truststore_version: self.truststore_version,
                truststore_warnings: self.truststore_warnings,
            }
        }
    }
}
impl MutualTlsAuthentication {
    /// Creates a new builder-style object to manufacture [`MutualTlsAuthentication`](crate::model::MutualTlsAuthentication)
    pub fn builder() -> crate::model::mutual_tls_authentication::Builder {
        crate::model::mutual_tls_authentication::Builder::default()
    }
}

/// <p>The domain name configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DomainNameConfiguration {
    /// <p>A domain name for the API.</p>
    pub api_gateway_domain_name: std::option::Option<std::string::String>,
    /// <p>An AWS-managed certificate that will be used by the edge-optimized endpoint for this domain name. AWS Certificate Manager is the only supported source.</p>
    pub certificate_arn: std::option::Option<std::string::String>,
    /// <p>The user-friendly name of the certificate that will be used by the edge-optimized endpoint for this domain name.</p>
    pub certificate_name: std::option::Option<std::string::String>,
    /// <p>The timestamp when the certificate that was used by edge-optimized endpoint for this domain name was uploaded.</p>
    pub certificate_upload_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The status of the domain name migration. The valid values are AVAILABLE, UPDATING, PENDING_CERTIFICATE_REIMPORT, and PENDING_OWNERSHIP_VERIFICATION. If the status is UPDATING, the domain cannot be modified further until the existing operation is complete. If it is AVAILABLE, the domain can be updated.</p>
    pub domain_name_status: std::option::Option<crate::model::DomainNameStatus>,
    /// <p>An optional text message containing detailed information about status of the domain name migration.</p>
    pub domain_name_status_message: std::option::Option<std::string::String>,
    /// <p>The endpoint type.</p>
    pub endpoint_type: std::option::Option<crate::model::EndpointType>,
    /// <p>The Amazon Route 53 Hosted Zone ID of the endpoint.</p>
    pub hosted_zone_id: std::option::Option<std::string::String>,
    /// <p>The Transport Layer Security (TLS) version of the security policy for this domain name. The valid values are TLS_1_0 and TLS_1_2.</p>
    pub security_policy: std::option::Option<crate::model::SecurityPolicy>,
    /// <p>The ARN of the public certificate issued by ACM to validate ownership of your custom domain. Only required when configuring mutual TLS and using an ACM imported or private CA certificate ARN as the regionalCertificateArn</p>
    pub ownership_verification_certificate_arn: std::option::Option<std::string::String>,
}
impl DomainNameConfiguration {
    /// <p>A domain name for the API.</p>
    pub fn api_gateway_domain_name(&self) -> std::option::Option<&str> {
        self.api_gateway_domain_name.as_deref()
    }
    /// <p>An AWS-managed certificate that will be used by the edge-optimized endpoint for this domain name. AWS Certificate Manager is the only supported source.</p>
    pub fn certificate_arn(&self) -> std::option::Option<&str> {
        self.certificate_arn.as_deref()
    }
    /// <p>The user-friendly name of the certificate that will be used by the edge-optimized endpoint for this domain name.</p>
    pub fn certificate_name(&self) -> std::option::Option<&str> {
        self.certificate_name.as_deref()
    }
    /// <p>The timestamp when the certificate that was used by edge-optimized endpoint for this domain name was uploaded.</p>
    pub fn certificate_upload_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.certificate_upload_date.as_ref()
    }
    /// <p>The status of the domain name migration. The valid values are AVAILABLE, UPDATING, PENDING_CERTIFICATE_REIMPORT, and PENDING_OWNERSHIP_VERIFICATION. If the status is UPDATING, the domain cannot be modified further until the existing operation is complete. If it is AVAILABLE, the domain can be updated.</p>
    pub fn domain_name_status(&self) -> std::option::Option<&crate::model::DomainNameStatus> {
        self.domain_name_status.as_ref()
    }
    /// <p>An optional text message containing detailed information about status of the domain name migration.</p>
    pub fn domain_name_status_message(&self) -> std::option::Option<&str> {
        self.domain_name_status_message.as_deref()
    }
    /// <p>The endpoint type.</p>
    pub fn endpoint_type(&self) -> std::option::Option<&crate::model::EndpointType> {
        self.endpoint_type.as_ref()
    }
    /// <p>The Amazon Route 53 Hosted Zone ID of the endpoint.</p>
    pub fn hosted_zone_id(&self) -> std::option::Option<&str> {
        self.hosted_zone_id.as_deref()
    }
    /// <p>The Transport Layer Security (TLS) version of the security policy for this domain name. The valid values are TLS_1_0 and TLS_1_2.</p>
    pub fn security_policy(&self) -> std::option::Option<&crate::model::SecurityPolicy> {
        self.security_policy.as_ref()
    }
    /// <p>The ARN of the public certificate issued by ACM to validate ownership of your custom domain. Only required when configuring mutual TLS and using an ACM imported or private CA certificate ARN as the regionalCertificateArn</p>
    pub fn ownership_verification_certificate_arn(&self) -> std::option::Option<&str> {
        self.ownership_verification_certificate_arn.as_deref()
    }
}
impl std::fmt::Debug for DomainNameConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DomainNameConfiguration");
        formatter.field("api_gateway_domain_name", &self.api_gateway_domain_name);
        formatter.field("certificate_arn", &self.certificate_arn);
        formatter.field("certificate_name", &self.certificate_name);
        formatter.field("certificate_upload_date", &self.certificate_upload_date);
        formatter.field("domain_name_status", &self.domain_name_status);
        formatter.field(
            "domain_name_status_message",
            &self.domain_name_status_message,
        );
        formatter.field("endpoint_type", &self.endpoint_type);
        formatter.field("hosted_zone_id", &self.hosted_zone_id);
        formatter.field("security_policy", &self.security_policy);
        formatter.field(
            "ownership_verification_certificate_arn",
            &self.ownership_verification_certificate_arn,
        );
        formatter.finish()
    }
}
/// See [`DomainNameConfiguration`](crate::model::DomainNameConfiguration)
pub mod domain_name_configuration {
    /// A builder for [`DomainNameConfiguration`](crate::model::DomainNameConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_gateway_domain_name: std::option::Option<std::string::String>,
        pub(crate) certificate_arn: std::option::Option<std::string::String>,
        pub(crate) certificate_name: std::option::Option<std::string::String>,
        pub(crate) certificate_upload_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) domain_name_status: std::option::Option<crate::model::DomainNameStatus>,
        pub(crate) domain_name_status_message: std::option::Option<std::string::String>,
        pub(crate) endpoint_type: std::option::Option<crate::model::EndpointType>,
        pub(crate) hosted_zone_id: std::option::Option<std::string::String>,
        pub(crate) security_policy: std::option::Option<crate::model::SecurityPolicy>,
        pub(crate) ownership_verification_certificate_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A domain name for the API.</p>
        pub fn api_gateway_domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_gateway_domain_name = Some(input.into());
            self
        }
        /// <p>A domain name for the API.</p>
        pub fn set_api_gateway_domain_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.api_gateway_domain_name = input;
            self
        }
        /// <p>An AWS-managed certificate that will be used by the edge-optimized endpoint for this domain name. AWS Certificate Manager is the only supported source.</p>
        pub fn certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_arn = Some(input.into());
            self
        }
        /// <p>An AWS-managed certificate that will be used by the edge-optimized endpoint for this domain name. AWS Certificate Manager is the only supported source.</p>
        pub fn set_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_arn = input;
            self
        }
        /// <p>The user-friendly name of the certificate that will be used by the edge-optimized endpoint for this domain name.</p>
        pub fn certificate_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_name = Some(input.into());
            self
        }
        /// <p>The user-friendly name of the certificate that will be used by the edge-optimized endpoint for this domain name.</p>
        pub fn set_certificate_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_name = input;
            self
        }
        /// <p>The timestamp when the certificate that was used by edge-optimized endpoint for this domain name was uploaded.</p>
        pub fn certificate_upload_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.certificate_upload_date = Some(input);
            self
        }
        /// <p>The timestamp when the certificate that was used by edge-optimized endpoint for this domain name was uploaded.</p>
        pub fn set_certificate_upload_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.certificate_upload_date = input;
            self
        }
        /// <p>The status of the domain name migration. The valid values are AVAILABLE, UPDATING, PENDING_CERTIFICATE_REIMPORT, and PENDING_OWNERSHIP_VERIFICATION. If the status is UPDATING, the domain cannot be modified further until the existing operation is complete. If it is AVAILABLE, the domain can be updated.</p>
        pub fn domain_name_status(mut self, input: crate::model::DomainNameStatus) -> Self {
            self.domain_name_status = Some(input);
            self
        }
        /// <p>The status of the domain name migration. The valid values are AVAILABLE, UPDATING, PENDING_CERTIFICATE_REIMPORT, and PENDING_OWNERSHIP_VERIFICATION. If the status is UPDATING, the domain cannot be modified further until the existing operation is complete. If it is AVAILABLE, the domain can be updated.</p>
        pub fn set_domain_name_status(
            mut self,
            input: std::option::Option<crate::model::DomainNameStatus>,
        ) -> Self {
            self.domain_name_status = input;
            self
        }
        /// <p>An optional text message containing detailed information about status of the domain name migration.</p>
        pub fn domain_name_status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name_status_message = Some(input.into());
            self
        }
        /// <p>An optional text message containing detailed information about status of the domain name migration.</p>
        pub fn set_domain_name_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.domain_name_status_message = input;
            self
        }
        /// <p>The endpoint type.</p>
        pub fn endpoint_type(mut self, input: crate::model::EndpointType) -> Self {
            self.endpoint_type = Some(input);
            self
        }
        /// <p>The endpoint type.</p>
        pub fn set_endpoint_type(
            mut self,
            input: std::option::Option<crate::model::EndpointType>,
        ) -> Self {
            self.endpoint_type = input;
            self
        }
        /// <p>The Amazon Route 53 Hosted Zone ID of the endpoint.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hosted_zone_id = Some(input.into());
            self
        }
        /// <p>The Amazon Route 53 Hosted Zone ID of the endpoint.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hosted_zone_id = input;
            self
        }
        /// <p>The Transport Layer Security (TLS) version of the security policy for this domain name. The valid values are TLS_1_0 and TLS_1_2.</p>
        pub fn security_policy(mut self, input: crate::model::SecurityPolicy) -> Self {
            self.security_policy = Some(input);
            self
        }
        /// <p>The Transport Layer Security (TLS) version of the security policy for this domain name. The valid values are TLS_1_0 and TLS_1_2.</p>
        pub fn set_security_policy(
            mut self,
            input: std::option::Option<crate::model::SecurityPolicy>,
        ) -> Self {
            self.security_policy = input;
            self
        }
        /// <p>The ARN of the public certificate issued by ACM to validate ownership of your custom domain. Only required when configuring mutual TLS and using an ACM imported or private CA certificate ARN as the regionalCertificateArn</p>
        pub fn ownership_verification_certificate_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.ownership_verification_certificate_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the public certificate issued by ACM to validate ownership of your custom domain. Only required when configuring mutual TLS and using an ACM imported or private CA certificate ARN as the regionalCertificateArn</p>
        pub fn set_ownership_verification_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ownership_verification_certificate_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DomainNameConfiguration`](crate::model::DomainNameConfiguration)
        pub fn build(self) -> crate::model::DomainNameConfiguration {
            crate::model::DomainNameConfiguration {
                api_gateway_domain_name: self.api_gateway_domain_name,
                certificate_arn: self.certificate_arn,
                certificate_name: self.certificate_name,
                certificate_upload_date: self.certificate_upload_date,
                domain_name_status: self.domain_name_status,
                domain_name_status_message: self.domain_name_status_message,
                endpoint_type: self.endpoint_type,
                hosted_zone_id: self.hosted_zone_id,
                security_policy: self.security_policy,
                ownership_verification_certificate_arn: self.ownership_verification_certificate_arn,
            }
        }
    }
}
impl DomainNameConfiguration {
    /// Creates a new builder-style object to manufacture [`DomainNameConfiguration`](crate::model::DomainNameConfiguration)
    pub fn builder() -> crate::model::domain_name_configuration::Builder {
        crate::model::domain_name_configuration::Builder::default()
    }
}

/// <p>The Transport Layer Security (TLS) version of the security policy for this domain name. The valid values are TLS_1_0 and TLS_1_2.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SecurityPolicy {
    #[allow(missing_docs)] // documentation missing in model
    Tls10,
    #[allow(missing_docs)] // documentation missing in model
    Tls12,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SecurityPolicy {
    fn from(s: &str) -> Self {
        match s {
            "TLS_1_0" => SecurityPolicy::Tls10,
            "TLS_1_2" => SecurityPolicy::Tls12,
            other => SecurityPolicy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SecurityPolicy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SecurityPolicy::from(s))
    }
}
impl SecurityPolicy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SecurityPolicy::Tls10 => "TLS_1_0",
            SecurityPolicy::Tls12 => "TLS_1_2",
            SecurityPolicy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["TLS_1_0", "TLS_1_2"]
    }
}
impl AsRef<str> for SecurityPolicy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents an endpoint type.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EndpointType {
    #[allow(missing_docs)] // documentation missing in model
    Edge,
    #[allow(missing_docs)] // documentation missing in model
    Regional,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EndpointType {
    fn from(s: &str) -> Self {
        match s {
            "EDGE" => EndpointType::Edge,
            "REGIONAL" => EndpointType::Regional,
            other => EndpointType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EndpointType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EndpointType::from(s))
    }
}
impl EndpointType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EndpointType::Edge => "EDGE",
            EndpointType::Regional => "REGIONAL",
            EndpointType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["EDGE", "REGIONAL"]
    }
}
impl AsRef<str> for EndpointType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The status of the domain name migration. The valid values are AVAILABLE, UPDATING, PENDING_CERTIFICATE_REIMPORT, and PENDING_OWNERSHIP_VERIFICATION. If the status is UPDATING, the domain cannot be modified further until the existing operation is complete. If it is AVAILABLE, the domain can be updated.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DomainNameStatus {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    PendingCertificateReimport,
    #[allow(missing_docs)] // documentation missing in model
    PendingOwnershipVerification,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DomainNameStatus {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => DomainNameStatus::Available,
            "PENDING_CERTIFICATE_REIMPORT" => DomainNameStatus::PendingCertificateReimport,
            "PENDING_OWNERSHIP_VERIFICATION" => DomainNameStatus::PendingOwnershipVerification,
            "UPDATING" => DomainNameStatus::Updating,
            other => DomainNameStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DomainNameStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DomainNameStatus::from(s))
    }
}
impl DomainNameStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DomainNameStatus::Available => "AVAILABLE",
            DomainNameStatus::PendingCertificateReimport => "PENDING_CERTIFICATE_REIMPORT",
            DomainNameStatus::PendingOwnershipVerification => "PENDING_OWNERSHIP_VERIFICATION",
            DomainNameStatus::Updating => "UPDATING",
            DomainNameStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AVAILABLE",
            "PENDING_CERTIFICATE_REIMPORT",
            "PENDING_OWNERSHIP_VERIFICATION",
            "UPDATING",
        ]
    }
}
impl AsRef<str> for DomainNameStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MutualTlsAuthenticationInput {
    /// <p>An Amazon S3 URL that specifies the truststore for mutual TLS authentication, for example, s3://<replaceable>bucket-name</replaceable>/<replaceable>key-name</replaceable>. The truststore can contain certificates from public or private certificate authorities. To update the truststore, upload a new version to S3, and then update your custom domain name to use the new version. To update the truststore, you must have permissions to access the S3 object.</p>
    pub truststore_uri: std::option::Option<std::string::String>,
    /// <p>The version of the S3 object that contains your truststore. To specify a version, you must have versioning enabled for the S3 bucket.</p>
    pub truststore_version: std::option::Option<std::string::String>,
}
impl MutualTlsAuthenticationInput {
    /// <p>An Amazon S3 URL that specifies the truststore for mutual TLS authentication, for example, s3://<replaceable>bucket-name</replaceable>/<replaceable>key-name</replaceable>. The truststore can contain certificates from public or private certificate authorities. To update the truststore, upload a new version to S3, and then update your custom domain name to use the new version. To update the truststore, you must have permissions to access the S3 object.</p>
    pub fn truststore_uri(&self) -> std::option::Option<&str> {
        self.truststore_uri.as_deref()
    }
    /// <p>The version of the S3 object that contains your truststore. To specify a version, you must have versioning enabled for the S3 bucket.</p>
    pub fn truststore_version(&self) -> std::option::Option<&str> {
        self.truststore_version.as_deref()
    }
}
impl std::fmt::Debug for MutualTlsAuthenticationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MutualTlsAuthenticationInput");
        formatter.field("truststore_uri", &self.truststore_uri);
        formatter.field("truststore_version", &self.truststore_version);
        formatter.finish()
    }
}
/// See [`MutualTlsAuthenticationInput`](crate::model::MutualTlsAuthenticationInput)
pub mod mutual_tls_authentication_input {
    /// A builder for [`MutualTlsAuthenticationInput`](crate::model::MutualTlsAuthenticationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) truststore_uri: std::option::Option<std::string::String>,
        pub(crate) truststore_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An Amazon S3 URL that specifies the truststore for mutual TLS authentication, for example, s3://<replaceable>bucket-name</replaceable>/<replaceable>key-name</replaceable>. The truststore can contain certificates from public or private certificate authorities. To update the truststore, upload a new version to S3, and then update your custom domain name to use the new version. To update the truststore, you must have permissions to access the S3 object.</p>
        pub fn truststore_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.truststore_uri = Some(input.into());
            self
        }
        /// <p>An Amazon S3 URL that specifies the truststore for mutual TLS authentication, for example, s3://<replaceable>bucket-name</replaceable>/<replaceable>key-name</replaceable>. The truststore can contain certificates from public or private certificate authorities. To update the truststore, upload a new version to S3, and then update your custom domain name to use the new version. To update the truststore, you must have permissions to access the S3 object.</p>
        pub fn set_truststore_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.truststore_uri = input;
            self
        }
        /// <p>The version of the S3 object that contains your truststore. To specify a version, you must have versioning enabled for the S3 bucket.</p>
        pub fn truststore_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.truststore_version = Some(input.into());
            self
        }
        /// <p>The version of the S3 object that contains your truststore. To specify a version, you must have versioning enabled for the S3 bucket.</p>
        pub fn set_truststore_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.truststore_version = input;
            self
        }
        /// Consumes the builder and constructs a [`MutualTlsAuthenticationInput`](crate::model::MutualTlsAuthenticationInput)
        pub fn build(self) -> crate::model::MutualTlsAuthenticationInput {
            crate::model::MutualTlsAuthenticationInput {
                truststore_uri: self.truststore_uri,
                truststore_version: self.truststore_version,
            }
        }
    }
}
impl MutualTlsAuthenticationInput {
    /// Creates a new builder-style object to manufacture [`MutualTlsAuthenticationInput`](crate::model::MutualTlsAuthenticationInput)
    pub fn builder() -> crate::model::mutual_tls_authentication_input::Builder {
        crate::model::mutual_tls_authentication_input::Builder::default()
    }
}

/// <p>Represents a deployment status.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeploymentStatus {
    #[allow(missing_docs)] // documentation missing in model
    Deployed,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeploymentStatus {
    fn from(s: &str) -> Self {
        match s {
            "DEPLOYED" => DeploymentStatus::Deployed,
            "FAILED" => DeploymentStatus::Failed,
            "PENDING" => DeploymentStatus::Pending,
            other => DeploymentStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeploymentStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeploymentStatus::from(s))
    }
}
impl DeploymentStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeploymentStatus::Deployed => "DEPLOYED",
            DeploymentStatus::Failed => "FAILED",
            DeploymentStatus::Pending => "PENDING",
            DeploymentStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DEPLOYED", "FAILED", "PENDING"]
    }
}
impl AsRef<str> for DeploymentStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents the configuration of a JWT authorizer. Required for the JWT authorizer type. Supported only for HTTP APIs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JwtConfiguration {
    /// <p>A list of the intended recipients of the JWT. A valid JWT must provide an aud that matches at least one entry in this list. See <a href="https://tools.ietf.org/html/rfc7519#section-4.1.3">RFC 7519</a>. Supported only for HTTP APIs.</p>
    pub audience: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The base domain of the identity provider that issues JSON Web Tokens. For example, an Amazon Cognito user pool has the following format: https://cognito-idp.<replaceable>{region}</replaceable>.amazonaws.com/<replaceable>{userPoolId}</replaceable>
    /// . Required for the JWT authorizer type. Supported only for HTTP APIs.</p>
    pub issuer: std::option::Option<std::string::String>,
}
impl JwtConfiguration {
    /// <p>A list of the intended recipients of the JWT. A valid JWT must provide an aud that matches at least one entry in this list. See <a href="https://tools.ietf.org/html/rfc7519#section-4.1.3">RFC 7519</a>. Supported only for HTTP APIs.</p>
    pub fn audience(&self) -> std::option::Option<&[std::string::String]> {
        self.audience.as_deref()
    }
    /// <p>The base domain of the identity provider that issues JSON Web Tokens. For example, an Amazon Cognito user pool has the following format: https://cognito-idp.<replaceable>{region}</replaceable>.amazonaws.com/<replaceable>{userPoolId}</replaceable>
    /// . Required for the JWT authorizer type. Supported only for HTTP APIs.</p>
    pub fn issuer(&self) -> std::option::Option<&str> {
        self.issuer.as_deref()
    }
}
impl std::fmt::Debug for JwtConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JwtConfiguration");
        formatter.field("audience", &self.audience);
        formatter.field("issuer", &self.issuer);
        formatter.finish()
    }
}
/// See [`JwtConfiguration`](crate::model::JwtConfiguration)
pub mod jwt_configuration {
    /// A builder for [`JwtConfiguration`](crate::model::JwtConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) audience: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) issuer: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `audience`.
        ///
        /// To override the contents of this collection use [`set_audience`](Self::set_audience).
        ///
        /// <p>A list of the intended recipients of the JWT. A valid JWT must provide an aud that matches at least one entry in this list. See <a href="https://tools.ietf.org/html/rfc7519#section-4.1.3">RFC 7519</a>. Supported only for HTTP APIs.</p>
        pub fn audience(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.audience.unwrap_or_default();
            v.push(input.into());
            self.audience = Some(v);
            self
        }
        /// <p>A list of the intended recipients of the JWT. A valid JWT must provide an aud that matches at least one entry in this list. See <a href="https://tools.ietf.org/html/rfc7519#section-4.1.3">RFC 7519</a>. Supported only for HTTP APIs.</p>
        pub fn set_audience(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.audience = input;
            self
        }
        /// <p>The base domain of the identity provider that issues JSON Web Tokens. For example, an Amazon Cognito user pool has the following format: https://cognito-idp.<replaceable>{region}</replaceable>.amazonaws.com/<replaceable>{userPoolId}</replaceable>
        /// . Required for the JWT authorizer type. Supported only for HTTP APIs.</p>
        pub fn issuer(mut self, input: impl Into<std::string::String>) -> Self {
            self.issuer = Some(input.into());
            self
        }
        /// <p>The base domain of the identity provider that issues JSON Web Tokens. For example, an Amazon Cognito user pool has the following format: https://cognito-idp.<replaceable>{region}</replaceable>.amazonaws.com/<replaceable>{userPoolId}</replaceable>
        /// . Required for the JWT authorizer type. Supported only for HTTP APIs.</p>
        pub fn set_issuer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.issuer = input;
            self
        }
        /// Consumes the builder and constructs a [`JwtConfiguration`](crate::model::JwtConfiguration)
        pub fn build(self) -> crate::model::JwtConfiguration {
            crate::model::JwtConfiguration {
                audience: self.audience,
                issuer: self.issuer,
            }
        }
    }
}
impl JwtConfiguration {
    /// Creates a new builder-style object to manufacture [`JwtConfiguration`](crate::model::JwtConfiguration)
    pub fn builder() -> crate::model::jwt_configuration::Builder {
        crate::model::jwt_configuration::Builder::default()
    }
}

/// <p>The authorizer type. Specify REQUEST for a Lambda function using incoming request parameters. Specify JWT to use JSON Web Tokens (supported only for HTTP APIs).</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AuthorizerType {
    #[allow(missing_docs)] // documentation missing in model
    Jwt,
    #[allow(missing_docs)] // documentation missing in model
    Request,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AuthorizerType {
    fn from(s: &str) -> Self {
        match s {
            "JWT" => AuthorizerType::Jwt,
            "REQUEST" => AuthorizerType::Request,
            other => AuthorizerType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AuthorizerType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AuthorizerType::from(s))
    }
}
impl AuthorizerType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AuthorizerType::Jwt => "JWT",
            AuthorizerType::Request => "REQUEST",
            AuthorizerType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["JWT", "REQUEST"]
    }
}
impl AsRef<str> for AuthorizerType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Represents a protocol type.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ProtocolType {
    #[allow(missing_docs)] // documentation missing in model
    Http,
    #[allow(missing_docs)] // documentation missing in model
    Websocket,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ProtocolType {
    fn from(s: &str) -> Self {
        match s {
            "HTTP" => ProtocolType::Http,
            "WEBSOCKET" => ProtocolType::Websocket,
            other => ProtocolType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ProtocolType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ProtocolType::from(s))
    }
}
impl ProtocolType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ProtocolType::Http => "HTTP",
            ProtocolType::Websocket => "WEBSOCKET",
            ProtocolType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HTTP", "WEBSOCKET"]
    }
}
impl AsRef<str> for ProtocolType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents a CORS configuration. Supported only for HTTP APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-cors.html">Configuring CORS</a> for more information.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Cors {
    /// <p>Specifies whether credentials are included in the CORS request. Supported only for HTTP APIs.</p>
    pub allow_credentials: bool,
    /// <p>Represents a collection of allowed headers. Supported only for HTTP APIs.</p>
    pub allow_headers: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Represents a collection of allowed HTTP methods. Supported only for HTTP APIs.</p>
    pub allow_methods: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Represents a collection of allowed origins. Supported only for HTTP APIs.</p>
    pub allow_origins: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Represents a collection of exposed headers. Supported only for HTTP APIs.</p>
    pub expose_headers: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The number of seconds that the browser should cache preflight request results. Supported only for HTTP APIs.</p>
    pub max_age: i32,
}
impl Cors {
    /// <p>Specifies whether credentials are included in the CORS request. Supported only for HTTP APIs.</p>
    pub fn allow_credentials(&self) -> bool {
        self.allow_credentials
    }
    /// <p>Represents a collection of allowed headers. Supported only for HTTP APIs.</p>
    pub fn allow_headers(&self) -> std::option::Option<&[std::string::String]> {
        self.allow_headers.as_deref()
    }
    /// <p>Represents a collection of allowed HTTP methods. Supported only for HTTP APIs.</p>
    pub fn allow_methods(&self) -> std::option::Option<&[std::string::String]> {
        self.allow_methods.as_deref()
    }
    /// <p>Represents a collection of allowed origins. Supported only for HTTP APIs.</p>
    pub fn allow_origins(&self) -> std::option::Option<&[std::string::String]> {
        self.allow_origins.as_deref()
    }
    /// <p>Represents a collection of exposed headers. Supported only for HTTP APIs.</p>
    pub fn expose_headers(&self) -> std::option::Option<&[std::string::String]> {
        self.expose_headers.as_deref()
    }
    /// <p>The number of seconds that the browser should cache preflight request results. Supported only for HTTP APIs.</p>
    pub fn max_age(&self) -> i32 {
        self.max_age
    }
}
impl std::fmt::Debug for Cors {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Cors");
        formatter.field("allow_credentials", &self.allow_credentials);
        formatter.field("allow_headers", &self.allow_headers);
        formatter.field("allow_methods", &self.allow_methods);
        formatter.field("allow_origins", &self.allow_origins);
        formatter.field("expose_headers", &self.expose_headers);
        formatter.field("max_age", &self.max_age);
        formatter.finish()
    }
}
/// See [`Cors`](crate::model::Cors)
pub mod cors {
    /// A builder for [`Cors`](crate::model::Cors)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) allow_credentials: std::option::Option<bool>,
        pub(crate) allow_headers: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) allow_methods: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) allow_origins: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) expose_headers: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) max_age: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Specifies whether credentials are included in the CORS request. Supported only for HTTP APIs.</p>
        pub fn allow_credentials(mut self, input: bool) -> Self {
            self.allow_credentials = Some(input);
            self
        }
        /// <p>Specifies whether credentials are included in the CORS request. Supported only for HTTP APIs.</p>
        pub fn set_allow_credentials(mut self, input: std::option::Option<bool>) -> Self {
            self.allow_credentials = input;
            self
        }
        /// Appends an item to `allow_headers`.
        ///
        /// To override the contents of this collection use [`set_allow_headers`](Self::set_allow_headers).
        ///
        /// <p>Represents a collection of allowed headers. Supported only for HTTP APIs.</p>
        pub fn allow_headers(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.allow_headers.unwrap_or_default();
            v.push(input.into());
            self.allow_headers = Some(v);
            self
        }
        /// <p>Represents a collection of allowed headers. Supported only for HTTP APIs.</p>
        pub fn set_allow_headers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.allow_headers = input;
            self
        }
        /// Appends an item to `allow_methods`.
        ///
        /// To override the contents of this collection use [`set_allow_methods`](Self::set_allow_methods).
        ///
        /// <p>Represents a collection of allowed HTTP methods. Supported only for HTTP APIs.</p>
        pub fn allow_methods(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.allow_methods.unwrap_or_default();
            v.push(input.into());
            self.allow_methods = Some(v);
            self
        }
        /// <p>Represents a collection of allowed HTTP methods. Supported only for HTTP APIs.</p>
        pub fn set_allow_methods(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.allow_methods = input;
            self
        }
        /// Appends an item to `allow_origins`.
        ///
        /// To override the contents of this collection use [`set_allow_origins`](Self::set_allow_origins).
        ///
        /// <p>Represents a collection of allowed origins. Supported only for HTTP APIs.</p>
        pub fn allow_origins(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.allow_origins.unwrap_or_default();
            v.push(input.into());
            self.allow_origins = Some(v);
            self
        }
        /// <p>Represents a collection of allowed origins. Supported only for HTTP APIs.</p>
        pub fn set_allow_origins(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.allow_origins = input;
            self
        }
        /// Appends an item to `expose_headers`.
        ///
        /// To override the contents of this collection use [`set_expose_headers`](Self::set_expose_headers).
        ///
        /// <p>Represents a collection of exposed headers. Supported only for HTTP APIs.</p>
        pub fn expose_headers(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.expose_headers.unwrap_or_default();
            v.push(input.into());
            self.expose_headers = Some(v);
            self
        }
        /// <p>Represents a collection of exposed headers. Supported only for HTTP APIs.</p>
        pub fn set_expose_headers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.expose_headers = input;
            self
        }
        /// <p>The number of seconds that the browser should cache preflight request results. Supported only for HTTP APIs.</p>
        pub fn max_age(mut self, input: i32) -> Self {
            self.max_age = Some(input);
            self
        }
        /// <p>The number of seconds that the browser should cache preflight request results. Supported only for HTTP APIs.</p>
        pub fn set_max_age(mut self, input: std::option::Option<i32>) -> Self {
            self.max_age = input;
            self
        }
        /// Consumes the builder and constructs a [`Cors`](crate::model::Cors)
        pub fn build(self) -> crate::model::Cors {
            crate::model::Cors {
                allow_credentials: self.allow_credentials.unwrap_or_default(),
                allow_headers: self.allow_headers,
                allow_methods: self.allow_methods,
                allow_origins: self.allow_origins,
                expose_headers: self.expose_headers,
                max_age: self.max_age.unwrap_or_default(),
            }
        }
    }
}
impl Cors {
    /// Creates a new builder-style object to manufacture [`Cors`](crate::model::Cors)
    pub fn builder() -> crate::model::cors::Builder {
        crate::model::cors::Builder::default()
    }
}

/// <p>Represents a VPC link.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VpcLink {
    /// <p>The timestamp when the VPC link was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The name of the VPC link.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A list of security group IDs for the VPC link.</p>
    pub security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of subnet IDs to include in the VPC link.</p>
    pub subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Tags for the VPC link.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The ID of the VPC link.</p>
    pub vpc_link_id: std::option::Option<std::string::String>,
    /// <p>The status of the VPC link.</p>
    pub vpc_link_status: std::option::Option<crate::model::VpcLinkStatus>,
    /// <p>A message summarizing the cause of the status of the VPC link.</p>
    pub vpc_link_status_message: std::option::Option<std::string::String>,
    /// <p>The version of the VPC link.</p>
    pub vpc_link_version: std::option::Option<crate::model::VpcLinkVersion>,
}
impl VpcLink {
    /// <p>The timestamp when the VPC link was created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_date.as_ref()
    }
    /// <p>The name of the VPC link.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A list of security group IDs for the VPC link.</p>
    pub fn security_group_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.security_group_ids.as_deref()
    }
    /// <p>A list of subnet IDs to include in the VPC link.</p>
    pub fn subnet_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.subnet_ids.as_deref()
    }
    /// <p>Tags for the VPC link.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The ID of the VPC link.</p>
    pub fn vpc_link_id(&self) -> std::option::Option<&str> {
        self.vpc_link_id.as_deref()
    }
    /// <p>The status of the VPC link.</p>
    pub fn vpc_link_status(&self) -> std::option::Option<&crate::model::VpcLinkStatus> {
        self.vpc_link_status.as_ref()
    }
    /// <p>A message summarizing the cause of the status of the VPC link.</p>
    pub fn vpc_link_status_message(&self) -> std::option::Option<&str> {
        self.vpc_link_status_message.as_deref()
    }
    /// <p>The version of the VPC link.</p>
    pub fn vpc_link_version(&self) -> std::option::Option<&crate::model::VpcLinkVersion> {
        self.vpc_link_version.as_ref()
    }
}
impl std::fmt::Debug for VpcLink {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VpcLink");
        formatter.field("created_date", &self.created_date);
        formatter.field("name", &self.name);
        formatter.field("security_group_ids", &self.security_group_ids);
        formatter.field("subnet_ids", &self.subnet_ids);
        formatter.field("tags", &self.tags);
        formatter.field("vpc_link_id", &self.vpc_link_id);
        formatter.field("vpc_link_status", &self.vpc_link_status);
        formatter.field("vpc_link_status_message", &self.vpc_link_status_message);
        formatter.field("vpc_link_version", &self.vpc_link_version);
        formatter.finish()
    }
}
/// See [`VpcLink`](crate::model::VpcLink)
pub mod vpc_link {
    /// A builder for [`VpcLink`](crate::model::VpcLink)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) created_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) vpc_link_id: std::option::Option<std::string::String>,
        pub(crate) vpc_link_status: std::option::Option<crate::model::VpcLinkStatus>,
        pub(crate) vpc_link_status_message: std::option::Option<std::string::String>,
        pub(crate) vpc_link_version: std::option::Option<crate::model::VpcLinkVersion>,
    }
    impl Builder {
        /// <p>The timestamp when the VPC link was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The timestamp when the VPC link was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>The name of the VPC link.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the VPC link.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>A list of security group IDs for the VPC link.</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.security_group_ids = Some(v);
            self
        }
        /// <p>A list of security group IDs for the VPC link.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_ids = input;
            self
        }
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>A list of subnet IDs to include in the VPC link.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>A list of subnet IDs to include in the VPC link.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags for the VPC link.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Tags for the VPC link.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The ID of the VPC link.</p>
        pub fn vpc_link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_link_id = Some(input.into());
            self
        }
        /// <p>The ID of the VPC link.</p>
        pub fn set_vpc_link_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_link_id = input;
            self
        }
        /// <p>The status of the VPC link.</p>
        pub fn vpc_link_status(mut self, input: crate::model::VpcLinkStatus) -> Self {
            self.vpc_link_status = Some(input);
            self
        }
        /// <p>The status of the VPC link.</p>
        pub fn set_vpc_link_status(
            mut self,
            input: std::option::Option<crate::model::VpcLinkStatus>,
        ) -> Self {
            self.vpc_link_status = input;
            self
        }
        /// <p>A message summarizing the cause of the status of the VPC link.</p>
        pub fn vpc_link_status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_link_status_message = Some(input.into());
            self
        }
        /// <p>A message summarizing the cause of the status of the VPC link.</p>
        pub fn set_vpc_link_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vpc_link_status_message = input;
            self
        }
        /// <p>The version of the VPC link.</p>
        pub fn vpc_link_version(mut self, input: crate::model::VpcLinkVersion) -> Self {
            self.vpc_link_version = Some(input);
            self
        }
        /// <p>The version of the VPC link.</p>
        pub fn set_vpc_link_version(
            mut self,
            input: std::option::Option<crate::model::VpcLinkVersion>,
        ) -> Self {
            self.vpc_link_version = input;
            self
        }
        /// Consumes the builder and constructs a [`VpcLink`](crate::model::VpcLink)
        pub fn build(self) -> crate::model::VpcLink {
            crate::model::VpcLink {
                created_date: self.created_date,
                name: self.name,
                security_group_ids: self.security_group_ids,
                subnet_ids: self.subnet_ids,
                tags: self.tags,
                vpc_link_id: self.vpc_link_id,
                vpc_link_status: self.vpc_link_status,
                vpc_link_status_message: self.vpc_link_status_message,
                vpc_link_version: self.vpc_link_version,
            }
        }
    }
}
impl VpcLink {
    /// Creates a new builder-style object to manufacture [`VpcLink`](crate::model::VpcLink)
    pub fn builder() -> crate::model::vpc_link::Builder {
        crate::model::vpc_link::Builder::default()
    }
}

/// <p>Represents an API stage.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Stage {
    /// <p>Settings for logging access in this stage.</p>
    pub access_log_settings: std::option::Option<crate::model::AccessLogSettings>,
    /// <p>Specifies whether a stage is managed by API Gateway. If you created an API using quick create, the $default stage is managed by API Gateway. You can't modify the $default stage.</p>
    pub api_gateway_managed: bool,
    /// <p>Specifies whether updates to an API automatically trigger a new deployment. The default value is false.</p>
    pub auto_deploy: bool,
    /// <p>The identifier of a client certificate for a Stage. Supported only for WebSocket APIs.</p>
    pub client_certificate_id: std::option::Option<std::string::String>,
    /// <p>The timestamp when the stage was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Default route settings for the stage.</p>
    pub default_route_settings: std::option::Option<crate::model::RouteSettings>,
    /// <p>The identifier of the Deployment that the Stage is associated with. Can't be updated if autoDeploy is enabled.</p>
    pub deployment_id: std::option::Option<std::string::String>,
    /// <p>The description of the stage.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Describes the status of the last deployment of a stage. Supported only for stages with autoDeploy enabled.</p>
    pub last_deployment_status_message: std::option::Option<std::string::String>,
    /// <p>The timestamp when the stage was last updated.</p>
    pub last_updated_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Route settings for the stage, by routeKey.</p>
    pub route_settings: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::RouteSettings>,
    >,
    /// <p>The name of the stage.</p>
    pub stage_name: std::option::Option<std::string::String>,
    /// <p>A map that defines the stage variables for a stage resource. Variable names can have alphanumeric and underscore characters, and the values must match [A-Za-z0-9-._~:/?#&amp;=,]+.</p>
    pub stage_variables:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl Stage {
    /// <p>Settings for logging access in this stage.</p>
    pub fn access_log_settings(&self) -> std::option::Option<&crate::model::AccessLogSettings> {
        self.access_log_settings.as_ref()
    }
    /// <p>Specifies whether a stage is managed by API Gateway. If you created an API using quick create, the $default stage is managed by API Gateway. You can't modify the $default stage.</p>
    pub fn api_gateway_managed(&self) -> bool {
        self.api_gateway_managed
    }
    /// <p>Specifies whether updates to an API automatically trigger a new deployment. The default value is false.</p>
    pub fn auto_deploy(&self) -> bool {
        self.auto_deploy
    }
    /// <p>The identifier of a client certificate for a Stage. Supported only for WebSocket APIs.</p>
    pub fn client_certificate_id(&self) -> std::option::Option<&str> {
        self.client_certificate_id.as_deref()
    }
    /// <p>The timestamp when the stage was created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_date.as_ref()
    }
    /// <p>Default route settings for the stage.</p>
    pub fn default_route_settings(&self) -> std::option::Option<&crate::model::RouteSettings> {
        self.default_route_settings.as_ref()
    }
    /// <p>The identifier of the Deployment that the Stage is associated with. Can't be updated if autoDeploy is enabled.</p>
    pub fn deployment_id(&self) -> std::option::Option<&str> {
        self.deployment_id.as_deref()
    }
    /// <p>The description of the stage.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Describes the status of the last deployment of a stage. Supported only for stages with autoDeploy enabled.</p>
    pub fn last_deployment_status_message(&self) -> std::option::Option<&str> {
        self.last_deployment_status_message.as_deref()
    }
    /// <p>The timestamp when the stage was last updated.</p>
    pub fn last_updated_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date.as_ref()
    }
    /// <p>Route settings for the stage, by routeKey.</p>
    pub fn route_settings(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::RouteSettings>,
    > {
        self.route_settings.as_ref()
    }
    /// <p>The name of the stage.</p>
    pub fn stage_name(&self) -> std::option::Option<&str> {
        self.stage_name.as_deref()
    }
    /// <p>A map that defines the stage variables for a stage resource. Variable names can have alphanumeric and underscore characters, and the values must match [A-Za-z0-9-._~:/?#&amp;=,]+.</p>
    pub fn stage_variables(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.stage_variables.as_ref()
    }
    /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for Stage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Stage");
        formatter.field("access_log_settings", &self.access_log_settings);
        formatter.field("api_gateway_managed", &self.api_gateway_managed);
        formatter.field("auto_deploy", &self.auto_deploy);
        formatter.field("client_certificate_id", &self.client_certificate_id);
        formatter.field("created_date", &self.created_date);
        formatter.field("default_route_settings", &self.default_route_settings);
        formatter.field("deployment_id", &self.deployment_id);
        formatter.field("description", &self.description);
        formatter.field(
            "last_deployment_status_message",
            &self.last_deployment_status_message,
        );
        formatter.field("last_updated_date", &self.last_updated_date);
        formatter.field("route_settings", &self.route_settings);
        formatter.field("stage_name", &self.stage_name);
        formatter.field("stage_variables", &self.stage_variables);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`Stage`](crate::model::Stage)
pub mod stage {
    /// A builder for [`Stage`](crate::model::Stage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_log_settings: std::option::Option<crate::model::AccessLogSettings>,
        pub(crate) api_gateway_managed: std::option::Option<bool>,
        pub(crate) auto_deploy: std::option::Option<bool>,
        pub(crate) client_certificate_id: std::option::Option<std::string::String>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) default_route_settings: std::option::Option<crate::model::RouteSettings>,
        pub(crate) deployment_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) last_deployment_status_message: std::option::Option<std::string::String>,
        pub(crate) last_updated_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) route_settings: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::RouteSettings>,
        >,
        pub(crate) stage_name: std::option::Option<std::string::String>,
        pub(crate) stage_variables: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>Settings for logging access in this stage.</p>
        pub fn access_log_settings(mut self, input: crate::model::AccessLogSettings) -> Self {
            self.access_log_settings = Some(input);
            self
        }
        /// <p>Settings for logging access in this stage.</p>
        pub fn set_access_log_settings(
            mut self,
            input: std::option::Option<crate::model::AccessLogSettings>,
        ) -> Self {
            self.access_log_settings = input;
            self
        }
        /// <p>Specifies whether a stage is managed by API Gateway. If you created an API using quick create, the $default stage is managed by API Gateway. You can't modify the $default stage.</p>
        pub fn api_gateway_managed(mut self, input: bool) -> Self {
            self.api_gateway_managed = Some(input);
            self
        }
        /// <p>Specifies whether a stage is managed by API Gateway. If you created an API using quick create, the $default stage is managed by API Gateway. You can't modify the $default stage.</p>
        pub fn set_api_gateway_managed(mut self, input: std::option::Option<bool>) -> Self {
            self.api_gateway_managed = input;
            self
        }
        /// <p>Specifies whether updates to an API automatically trigger a new deployment. The default value is false.</p>
        pub fn auto_deploy(mut self, input: bool) -> Self {
            self.auto_deploy = Some(input);
            self
        }
        /// <p>Specifies whether updates to an API automatically trigger a new deployment. The default value is false.</p>
        pub fn set_auto_deploy(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_deploy = input;
            self
        }
        /// <p>The identifier of a client certificate for a Stage. Supported only for WebSocket APIs.</p>
        pub fn client_certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_certificate_id = Some(input.into());
            self
        }
        /// <p>The identifier of a client certificate for a Stage. Supported only for WebSocket APIs.</p>
        pub fn set_client_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_certificate_id = input;
            self
        }
        /// <p>The timestamp when the stage was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The timestamp when the stage was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>Default route settings for the stage.</p>
        pub fn default_route_settings(mut self, input: crate::model::RouteSettings) -> Self {
            self.default_route_settings = Some(input);
            self
        }
        /// <p>Default route settings for the stage.</p>
        pub fn set_default_route_settings(
            mut self,
            input: std::option::Option<crate::model::RouteSettings>,
        ) -> Self {
            self.default_route_settings = input;
            self
        }
        /// <p>The identifier of the Deployment that the Stage is associated with. Can't be updated if autoDeploy is enabled.</p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Deployment that the Stage is associated with. Can't be updated if autoDeploy is enabled.</p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_id = input;
            self
        }
        /// <p>The description of the stage.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the stage.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Describes the status of the last deployment of a stage. Supported only for stages with autoDeploy enabled.</p>
        pub fn last_deployment_status_message(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.last_deployment_status_message = Some(input.into());
            self
        }
        /// <p>Describes the status of the last deployment of a stage. Supported only for stages with autoDeploy enabled.</p>
        pub fn set_last_deployment_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_deployment_status_message = input;
            self
        }
        /// <p>The timestamp when the stage was last updated.</p>
        pub fn last_updated_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date = Some(input);
            self
        }
        /// <p>The timestamp when the stage was last updated.</p>
        pub fn set_last_updated_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date = input;
            self
        }
        /// Adds a key-value pair to `route_settings`.
        ///
        /// To override the contents of this collection use [`set_route_settings`](Self::set_route_settings).
        ///
        /// <p>Route settings for the stage, by routeKey.</p>
        pub fn route_settings(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::RouteSettings>,
        ) -> Self {
            let mut hash_map = self.route_settings.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.route_settings = Some(hash_map);
            self
        }
        /// <p>Route settings for the stage, by routeKey.</p>
        pub fn set_route_settings(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::RouteSettings>,
            >,
        ) -> Self {
            self.route_settings = input;
            self
        }
        /// <p>The name of the stage.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stage_name = Some(input.into());
            self
        }
        /// <p>The name of the stage.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stage_name = input;
            self
        }
        /// Adds a key-value pair to `stage_variables`.
        ///
        /// To override the contents of this collection use [`set_stage_variables`](Self::set_stage_variables).
        ///
        /// <p>A map that defines the stage variables for a stage resource. Variable names can have alphanumeric and underscore characters, and the values must match [A-Za-z0-9-._~:/?#&amp;=,]+.</p>
        pub fn stage_variables(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.stage_variables.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.stage_variables = Some(hash_map);
            self
        }
        /// <p>A map that defines the stage variables for a stage resource. Variable names can have alphanumeric and underscore characters, and the values must match [A-Za-z0-9-._~:/?#&amp;=,]+.</p>
        pub fn set_stage_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.stage_variables = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`Stage`](crate::model::Stage)
        pub fn build(self) -> crate::model::Stage {
            crate::model::Stage {
                access_log_settings: self.access_log_settings,
                api_gateway_managed: self.api_gateway_managed.unwrap_or_default(),
                auto_deploy: self.auto_deploy.unwrap_or_default(),
                client_certificate_id: self.client_certificate_id,
                created_date: self.created_date,
                default_route_settings: self.default_route_settings,
                deployment_id: self.deployment_id,
                description: self.description,
                last_deployment_status_message: self.last_deployment_status_message,
                last_updated_date: self.last_updated_date,
                route_settings: self.route_settings,
                stage_name: self.stage_name,
                stage_variables: self.stage_variables,
                tags: self.tags,
            }
        }
    }
}
impl Stage {
    /// Creates a new builder-style object to manufacture [`Stage`](crate::model::Stage)
    pub fn builder() -> crate::model::stage::Builder {
        crate::model::stage::Builder::default()
    }
}

/// <p>Represents a route.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Route {
    /// <p>Specifies whether a route is managed by API Gateway. If you created an API using quick create, the $default route is managed by API Gateway. You can't modify the $default route key.</p>
    pub api_gateway_managed: bool,
    /// <p>Specifies whether an API key is required for this route. Supported only for WebSocket APIs.</p>
    pub api_key_required: bool,
    /// <p>A list of authorization scopes configured on a route. The scopes are used with a JWT authorizer to authorize the method invocation. The authorization works by matching the route scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any route scope matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the route scope is configured, the client must provide an access token instead of an identity token for authorization purposes.</p>
    pub authorization_scopes: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The authorization type for the route. For WebSocket APIs, valid values are NONE for open access, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer For HTTP APIs, valid values are NONE for open access, JWT for using JSON Web Tokens, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer.</p>
    pub authorization_type: std::option::Option<crate::model::AuthorizationType>,
    /// <p>The identifier of the Authorizer resource to be associated with this route. The authorizer identifier is generated by API Gateway when you created the authorizer.</p>
    pub authorizer_id: std::option::Option<std::string::String>,
    /// <p>The model selection expression for the route. Supported only for WebSocket APIs.</p>
    pub model_selection_expression: std::option::Option<std::string::String>,
    /// <p>The operation name for the route.</p>
    pub operation_name: std::option::Option<std::string::String>,
    /// <p>The request models for the route. Supported only for WebSocket APIs.</p>
    pub request_models:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The request parameters for the route. Supported only for WebSocket APIs.</p>
    pub request_parameters: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::ParameterConstraints>,
    >,
    /// <p>The route ID.</p>
    pub route_id: std::option::Option<std::string::String>,
    /// <p>The route key for the route.</p>
    pub route_key: std::option::Option<std::string::String>,
    /// <p>The route response selection expression for the route. Supported only for WebSocket APIs.</p>
    pub route_response_selection_expression: std::option::Option<std::string::String>,
    /// <p>The target for the route.</p>
    pub target: std::option::Option<std::string::String>,
}
impl Route {
    /// <p>Specifies whether a route is managed by API Gateway. If you created an API using quick create, the $default route is managed by API Gateway. You can't modify the $default route key.</p>
    pub fn api_gateway_managed(&self) -> bool {
        self.api_gateway_managed
    }
    /// <p>Specifies whether an API key is required for this route. Supported only for WebSocket APIs.</p>
    pub fn api_key_required(&self) -> bool {
        self.api_key_required
    }
    /// <p>A list of authorization scopes configured on a route. The scopes are used with a JWT authorizer to authorize the method invocation. The authorization works by matching the route scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any route scope matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the route scope is configured, the client must provide an access token instead of an identity token for authorization purposes.</p>
    pub fn authorization_scopes(&self) -> std::option::Option<&[std::string::String]> {
        self.authorization_scopes.as_deref()
    }
    /// <p>The authorization type for the route. For WebSocket APIs, valid values are NONE for open access, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer For HTTP APIs, valid values are NONE for open access, JWT for using JSON Web Tokens, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer.</p>
    pub fn authorization_type(&self) -> std::option::Option<&crate::model::AuthorizationType> {
        self.authorization_type.as_ref()
    }
    /// <p>The identifier of the Authorizer resource to be associated with this route. The authorizer identifier is generated by API Gateway when you created the authorizer.</p>
    pub fn authorizer_id(&self) -> std::option::Option<&str> {
        self.authorizer_id.as_deref()
    }
    /// <p>The model selection expression for the route. Supported only for WebSocket APIs.</p>
    pub fn model_selection_expression(&self) -> std::option::Option<&str> {
        self.model_selection_expression.as_deref()
    }
    /// <p>The operation name for the route.</p>
    pub fn operation_name(&self) -> std::option::Option<&str> {
        self.operation_name.as_deref()
    }
    /// <p>The request models for the route. Supported only for WebSocket APIs.</p>
    pub fn request_models(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.request_models.as_ref()
    }
    /// <p>The request parameters for the route. Supported only for WebSocket APIs.</p>
    pub fn request_parameters(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::ParameterConstraints>,
    > {
        self.request_parameters.as_ref()
    }
    /// <p>The route ID.</p>
    pub fn route_id(&self) -> std::option::Option<&str> {
        self.route_id.as_deref()
    }
    /// <p>The route key for the route.</p>
    pub fn route_key(&self) -> std::option::Option<&str> {
        self.route_key.as_deref()
    }
    /// <p>The route response selection expression for the route. Supported only for WebSocket APIs.</p>
    pub fn route_response_selection_expression(&self) -> std::option::Option<&str> {
        self.route_response_selection_expression.as_deref()
    }
    /// <p>The target for the route.</p>
    pub fn target(&self) -> std::option::Option<&str> {
        self.target.as_deref()
    }
}
impl std::fmt::Debug for Route {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Route");
        formatter.field("api_gateway_managed", &self.api_gateway_managed);
        formatter.field("api_key_required", &self.api_key_required);
        formatter.field("authorization_scopes", &self.authorization_scopes);
        formatter.field("authorization_type", &self.authorization_type);
        formatter.field("authorizer_id", &self.authorizer_id);
        formatter.field(
            "model_selection_expression",
            &self.model_selection_expression,
        );
        formatter.field("operation_name", &self.operation_name);
        formatter.field("request_models", &self.request_models);
        formatter.field("request_parameters", &self.request_parameters);
        formatter.field("route_id", &self.route_id);
        formatter.field("route_key", &self.route_key);
        formatter.field(
            "route_response_selection_expression",
            &self.route_response_selection_expression,
        );
        formatter.field("target", &self.target);
        formatter.finish()
    }
}
/// See [`Route`](crate::model::Route)
pub mod route {
    /// A builder for [`Route`](crate::model::Route)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_gateway_managed: std::option::Option<bool>,
        pub(crate) api_key_required: std::option::Option<bool>,
        pub(crate) authorization_scopes: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) authorization_type: std::option::Option<crate::model::AuthorizationType>,
        pub(crate) authorizer_id: std::option::Option<std::string::String>,
        pub(crate) model_selection_expression: std::option::Option<std::string::String>,
        pub(crate) operation_name: std::option::Option<std::string::String>,
        pub(crate) request_models: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) request_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::ParameterConstraints>,
        >,
        pub(crate) route_id: std::option::Option<std::string::String>,
        pub(crate) route_key: std::option::Option<std::string::String>,
        pub(crate) route_response_selection_expression: std::option::Option<std::string::String>,
        pub(crate) target: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies whether a route is managed by API Gateway. If you created an API using quick create, the $default route is managed by API Gateway. You can't modify the $default route key.</p>
        pub fn api_gateway_managed(mut self, input: bool) -> Self {
            self.api_gateway_managed = Some(input);
            self
        }
        /// <p>Specifies whether a route is managed by API Gateway. If you created an API using quick create, the $default route is managed by API Gateway. You can't modify the $default route key.</p>
        pub fn set_api_gateway_managed(mut self, input: std::option::Option<bool>) -> Self {
            self.api_gateway_managed = input;
            self
        }
        /// <p>Specifies whether an API key is required for this route. Supported only for WebSocket APIs.</p>
        pub fn api_key_required(mut self, input: bool) -> Self {
            self.api_key_required = Some(input);
            self
        }
        /// <p>Specifies whether an API key is required for this route. Supported only for WebSocket APIs.</p>
        pub fn set_api_key_required(mut self, input: std::option::Option<bool>) -> Self {
            self.api_key_required = input;
            self
        }
        /// Appends an item to `authorization_scopes`.
        ///
        /// To override the contents of this collection use [`set_authorization_scopes`](Self::set_authorization_scopes).
        ///
        /// <p>A list of authorization scopes configured on a route. The scopes are used with a JWT authorizer to authorize the method invocation. The authorization works by matching the route scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any route scope matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the route scope is configured, the client must provide an access token instead of an identity token for authorization purposes.</p>
        pub fn authorization_scopes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.authorization_scopes.unwrap_or_default();
            v.push(input.into());
            self.authorization_scopes = Some(v);
            self
        }
        /// <p>A list of authorization scopes configured on a route. The scopes are used with a JWT authorizer to authorize the method invocation. The authorization works by matching the route scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any route scope matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the route scope is configured, the client must provide an access token instead of an identity token for authorization purposes.</p>
        pub fn set_authorization_scopes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.authorization_scopes = input;
            self
        }
        /// <p>The authorization type for the route. For WebSocket APIs, valid values are NONE for open access, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer For HTTP APIs, valid values are NONE for open access, JWT for using JSON Web Tokens, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer.</p>
        pub fn authorization_type(mut self, input: crate::model::AuthorizationType) -> Self {
            self.authorization_type = Some(input);
            self
        }
        /// <p>The authorization type for the route. For WebSocket APIs, valid values are NONE for open access, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer For HTTP APIs, valid values are NONE for open access, JWT for using JSON Web Tokens, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer.</p>
        pub fn set_authorization_type(
            mut self,
            input: std::option::Option<crate::model::AuthorizationType>,
        ) -> Self {
            self.authorization_type = input;
            self
        }
        /// <p>The identifier of the Authorizer resource to be associated with this route. The authorizer identifier is generated by API Gateway when you created the authorizer.</p>
        pub fn authorizer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorizer_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Authorizer resource to be associated with this route. The authorizer identifier is generated by API Gateway when you created the authorizer.</p>
        pub fn set_authorizer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorizer_id = input;
            self
        }
        /// <p>The model selection expression for the route. Supported only for WebSocket APIs.</p>
        pub fn model_selection_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_selection_expression = Some(input.into());
            self
        }
        /// <p>The model selection expression for the route. Supported only for WebSocket APIs.</p>
        pub fn set_model_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_selection_expression = input;
            self
        }
        /// <p>The operation name for the route.</p>
        pub fn operation_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation_name = Some(input.into());
            self
        }
        /// <p>The operation name for the route.</p>
        pub fn set_operation_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.operation_name = input;
            self
        }
        /// Adds a key-value pair to `request_models`.
        ///
        /// To override the contents of this collection use [`set_request_models`](Self::set_request_models).
        ///
        /// <p>The request models for the route. Supported only for WebSocket APIs.</p>
        pub fn request_models(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.request_models.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.request_models = Some(hash_map);
            self
        }
        /// <p>The request models for the route. Supported only for WebSocket APIs.</p>
        pub fn set_request_models(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.request_models = input;
            self
        }
        /// Adds a key-value pair to `request_parameters`.
        ///
        /// To override the contents of this collection use [`set_request_parameters`](Self::set_request_parameters).
        ///
        /// <p>The request parameters for the route. Supported only for WebSocket APIs.</p>
        pub fn request_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::ParameterConstraints>,
        ) -> Self {
            let mut hash_map = self.request_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.request_parameters = Some(hash_map);
            self
        }
        /// <p>The request parameters for the route. Supported only for WebSocket APIs.</p>
        pub fn set_request_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::ParameterConstraints>,
            >,
        ) -> Self {
            self.request_parameters = input;
            self
        }
        /// <p>The route ID.</p>
        pub fn route_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_id = Some(input.into());
            self
        }
        /// <p>The route ID.</p>
        pub fn set_route_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.route_id = input;
            self
        }
        /// <p>The route key for the route.</p>
        pub fn route_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_key = Some(input.into());
            self
        }
        /// <p>The route key for the route.</p>
        pub fn set_route_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.route_key = input;
            self
        }
        /// <p>The route response selection expression for the route. Supported only for WebSocket APIs.</p>
        pub fn route_response_selection_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.route_response_selection_expression = Some(input.into());
            self
        }
        /// <p>The route response selection expression for the route. Supported only for WebSocket APIs.</p>
        pub fn set_route_response_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.route_response_selection_expression = input;
            self
        }
        /// <p>The target for the route.</p>
        pub fn target(mut self, input: impl Into<std::string::String>) -> Self {
            self.target = Some(input.into());
            self
        }
        /// <p>The target for the route.</p>
        pub fn set_target(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target = input;
            self
        }
        /// Consumes the builder and constructs a [`Route`](crate::model::Route)
        pub fn build(self) -> crate::model::Route {
            crate::model::Route {
                api_gateway_managed: self.api_gateway_managed.unwrap_or_default(),
                api_key_required: self.api_key_required.unwrap_or_default(),
                authorization_scopes: self.authorization_scopes,
                authorization_type: self.authorization_type,
                authorizer_id: self.authorizer_id,
                model_selection_expression: self.model_selection_expression,
                operation_name: self.operation_name,
                request_models: self.request_models,
                request_parameters: self.request_parameters,
                route_id: self.route_id,
                route_key: self.route_key,
                route_response_selection_expression: self.route_response_selection_expression,
                target: self.target,
            }
        }
    }
}
impl Route {
    /// Creates a new builder-style object to manufacture [`Route`](crate::model::Route)
    pub fn builder() -> crate::model::route::Builder {
        crate::model::route::Builder::default()
    }
}

/// <p>Represents a route response.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RouteResponse {
    /// <p>Represents the model selection expression of a route response. Supported only for WebSocket APIs.</p>
    pub model_selection_expression: std::option::Option<std::string::String>,
    /// <p>Represents the response models of a route response.</p>
    pub response_models:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Represents the response parameters of a route response.</p>
    pub response_parameters: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::ParameterConstraints>,
    >,
    /// <p>Represents the identifier of a route response.</p>
    pub route_response_id: std::option::Option<std::string::String>,
    /// <p>Represents the route response key of a route response.</p>
    pub route_response_key: std::option::Option<std::string::String>,
}
impl RouteResponse {
    /// <p>Represents the model selection expression of a route response. Supported only for WebSocket APIs.</p>
    pub fn model_selection_expression(&self) -> std::option::Option<&str> {
        self.model_selection_expression.as_deref()
    }
    /// <p>Represents the response models of a route response.</p>
    pub fn response_models(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.response_models.as_ref()
    }
    /// <p>Represents the response parameters of a route response.</p>
    pub fn response_parameters(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::ParameterConstraints>,
    > {
        self.response_parameters.as_ref()
    }
    /// <p>Represents the identifier of a route response.</p>
    pub fn route_response_id(&self) -> std::option::Option<&str> {
        self.route_response_id.as_deref()
    }
    /// <p>Represents the route response key of a route response.</p>
    pub fn route_response_key(&self) -> std::option::Option<&str> {
        self.route_response_key.as_deref()
    }
}
impl std::fmt::Debug for RouteResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RouteResponse");
        formatter.field(
            "model_selection_expression",
            &self.model_selection_expression,
        );
        formatter.field("response_models", &self.response_models);
        formatter.field("response_parameters", &self.response_parameters);
        formatter.field("route_response_id", &self.route_response_id);
        formatter.field("route_response_key", &self.route_response_key);
        formatter.finish()
    }
}
/// See [`RouteResponse`](crate::model::RouteResponse)
pub mod route_response {
    /// A builder for [`RouteResponse`](crate::model::RouteResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) model_selection_expression: std::option::Option<std::string::String>,
        pub(crate) response_models: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) response_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::ParameterConstraints>,
        >,
        pub(crate) route_response_id: std::option::Option<std::string::String>,
        pub(crate) route_response_key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Represents the model selection expression of a route response. Supported only for WebSocket APIs.</p>
        pub fn model_selection_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_selection_expression = Some(input.into());
            self
        }
        /// <p>Represents the model selection expression of a route response. Supported only for WebSocket APIs.</p>
        pub fn set_model_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_selection_expression = input;
            self
        }
        /// Adds a key-value pair to `response_models`.
        ///
        /// To override the contents of this collection use [`set_response_models`](Self::set_response_models).
        ///
        /// <p>Represents the response models of a route response.</p>
        pub fn response_models(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.response_models.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.response_models = Some(hash_map);
            self
        }
        /// <p>Represents the response models of a route response.</p>
        pub fn set_response_models(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.response_models = input;
            self
        }
        /// Adds a key-value pair to `response_parameters`.
        ///
        /// To override the contents of this collection use [`set_response_parameters`](Self::set_response_parameters).
        ///
        /// <p>Represents the response parameters of a route response.</p>
        pub fn response_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::ParameterConstraints>,
        ) -> Self {
            let mut hash_map = self.response_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.response_parameters = Some(hash_map);
            self
        }
        /// <p>Represents the response parameters of a route response.</p>
        pub fn set_response_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::ParameterConstraints>,
            >,
        ) -> Self {
            self.response_parameters = input;
            self
        }
        /// <p>Represents the identifier of a route response.</p>
        pub fn route_response_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_response_id = Some(input.into());
            self
        }
        /// <p>Represents the identifier of a route response.</p>
        pub fn set_route_response_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.route_response_id = input;
            self
        }
        /// <p>Represents the route response key of a route response.</p>
        pub fn route_response_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_response_key = Some(input.into());
            self
        }
        /// <p>Represents the route response key of a route response.</p>
        pub fn set_route_response_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.route_response_key = input;
            self
        }
        /// Consumes the builder and constructs a [`RouteResponse`](crate::model::RouteResponse)
        pub fn build(self) -> crate::model::RouteResponse {
            crate::model::RouteResponse {
                model_selection_expression: self.model_selection_expression,
                response_models: self.response_models,
                response_parameters: self.response_parameters,
                route_response_id: self.route_response_id,
                route_response_key: self.route_response_key,
            }
        }
    }
}
impl RouteResponse {
    /// Creates a new builder-style object to manufacture [`RouteResponse`](crate::model::RouteResponse)
    pub fn builder() -> crate::model::route_response::Builder {
        crate::model::route_response::Builder::default()
    }
}

/// <p>Represents a data model for an API. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/models-mappings.html">Create Models and Mapping Templates for Request and Response Mappings</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Model {
    /// <p>The content-type for the model, for example, "application/json".</p>
    pub content_type: std::option::Option<std::string::String>,
    /// <p>The description of the model.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The model identifier.</p>
    pub model_id: std::option::Option<std::string::String>,
    /// <p>The name of the model. Must be alphanumeric.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The schema for the model. For application/json models, this should be JSON schema draft 4 model.</p>
    pub schema: std::option::Option<std::string::String>,
}
impl Model {
    /// <p>The content-type for the model, for example, "application/json".</p>
    pub fn content_type(&self) -> std::option::Option<&str> {
        self.content_type.as_deref()
    }
    /// <p>The description of the model.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The model identifier.</p>
    pub fn model_id(&self) -> std::option::Option<&str> {
        self.model_id.as_deref()
    }
    /// <p>The name of the model. Must be alphanumeric.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The schema for the model. For application/json models, this should be JSON schema draft 4 model.</p>
    pub fn schema(&self) -> std::option::Option<&str> {
        self.schema.as_deref()
    }
}
impl std::fmt::Debug for Model {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Model");
        formatter.field("content_type", &self.content_type);
        formatter.field("description", &self.description);
        formatter.field("model_id", &self.model_id);
        formatter.field("name", &self.name);
        formatter.field("schema", &self.schema);
        formatter.finish()
    }
}
/// See [`Model`](crate::model::Model)
pub mod model {
    /// A builder for [`Model`](crate::model::Model)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) content_type: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) model_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) schema: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The content-type for the model, for example, "application/json".</p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_type = Some(input.into());
            self
        }
        /// <p>The content-type for the model, for example, "application/json".</p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_type = input;
            self
        }
        /// <p>The description of the model.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the model.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The model identifier.</p>
        pub fn model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_id = Some(input.into());
            self
        }
        /// <p>The model identifier.</p>
        pub fn set_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.model_id = input;
            self
        }
        /// <p>The name of the model. Must be alphanumeric.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the model. Must be alphanumeric.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The schema for the model. For application/json models, this should be JSON schema draft 4 model.</p>
        pub fn schema(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema = Some(input.into());
            self
        }
        /// <p>The schema for the model. For application/json models, this should be JSON schema draft 4 model.</p>
        pub fn set_schema(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema = input;
            self
        }
        /// Consumes the builder and constructs a [`Model`](crate::model::Model)
        pub fn build(self) -> crate::model::Model {
            crate::model::Model {
                content_type: self.content_type,
                description: self.description,
                model_id: self.model_id,
                name: self.name,
                schema: self.schema,
            }
        }
    }
}
impl Model {
    /// Creates a new builder-style object to manufacture [`Model`](crate::model::Model)
    pub fn builder() -> crate::model::model::Builder {
        crate::model::model::Builder::default()
    }
}

/// <p>Represents an integration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Integration {
    /// <p>Specifies whether an integration is managed by API Gateway. If you created an API using using quick create, the resulting integration is managed by API Gateway. You can update a managed integration, but you can't delete it.</p>
    pub api_gateway_managed: bool,
    /// <p>The ID of the VPC link for a private integration. Supported only for HTTP APIs.</p>
    pub connection_id: std::option::Option<std::string::String>,
    /// <p>The type of the network connection to the integration endpoint. Specify INTERNET for connections through the public routable internet or VPC_LINK for private connections between API Gateway and resources in a VPC. The default value is INTERNET.</p>
    pub connection_type: std::option::Option<crate::model::ConnectionType>,
    /// <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p> <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p> <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p> <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
    pub content_handling_strategy: std::option::Option<crate::model::ContentHandlingStrategy>,
    /// <p>Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, specify null.</p>
    pub credentials_arn: std::option::Option<std::string::String>,
    /// <p>Represents the description of an integration.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Represents the identifier of an integration.</p>
    pub integration_id: std::option::Option<std::string::String>,
    /// <p>Specifies the integration's HTTP method type.</p>
    pub integration_method: std::option::Option<std::string::String>,
    /// <p>The integration response selection expression for the integration. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-integration-response-selection-expressions">Integration Response Selection Expressions</a>.</p>
    pub integration_response_selection_expression: std::option::Option<std::string::String>,
    /// <p>Supported only for HTTP API AWS_PROXY integrations. Specifies the AWS service action to invoke. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html">Integration subtype reference</a>.</p>
    pub integration_subtype: std::option::Option<std::string::String>,
    /// <p>The integration type of an integration. One of the following:</p> <p>AWS: for integrating the route or method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration. Supported only for WebSocket APIs.</p> <p>AWS_PROXY: for integrating the route or method request with a Lambda function or other AWS service action. This integration is also referred to as a Lambda proxy integration.</p> <p>HTTP: for integrating the route or method request with an HTTP endpoint. This integration is also referred to as the HTTP custom integration. Supported only for WebSocket APIs.</p> <p>HTTP_PROXY: for integrating the route or method request with an HTTP endpoint, with the client request passed through as-is. This is also referred to as HTTP proxy integration.</p> <p>MOCK: for integrating the route or method request with API Gateway as a "loopback" endpoint without invoking any backend. Supported only for WebSocket APIs.</p>
    pub integration_type: std::option::Option<crate::model::IntegrationType>,
    /// <p>For a Lambda integration, specify the URI of a Lambda function.</p> <p>For an HTTP integration, specify a fully-qualified URL.</p> <p>For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service. If you specify the ARN of an AWS Cloud Map service, API Gateway uses DiscoverInstances to identify resources. You can use query parameters to target specific resources. To learn more, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_DiscoverInstances.html">DiscoverInstances</a>. For private integrations, all resources must be owned by the same AWS account.</p>
    pub integration_uri: std::option::Option<std::string::String>,
    /// <p>Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER. Supported only for WebSocket APIs.</p> <p>WHEN_NO_MATCH passes the request body for unmapped content types through to the integration backend without transformation.</p> <p>NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type response.</p> <p>WHEN_NO_TEMPLATES allows pass-through when the integration has no content types mapped to templates. However, if there is at least one content type defined, unmapped content types will be rejected with the same HTTP 415 Unsupported Media Type response.</p>
    pub passthrough_behavior: std::option::Option<crate::model::PassthroughBehavior>,
    /// <p>Specifies the format of the payload sent to an integration. Required for HTTP APIs.</p>
    pub payload_format_version: std::option::Option<std::string::String>,
    /// <p>For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the backend. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the backend. The method request parameter value must match the pattern of method.request.<replaceable>{location}</replaceable>.<replaceable>{name}</replaceable>
    /// , where
    /// <replaceable>{location}</replaceable>
    /// is querystring, path, or header; and
    /// <replaceable>{name}</replaceable>
    /// must be a valid and unique method request parameter name.</p> <p>For HTTP API integrations with a specified integrationSubtype, request parameters are a key-value map specifying parameters that are passed to AWS_PROXY integrations. You can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services.html">Working with AWS service integrations for HTTP APIs</a>.</p> <p>For HTTP API itegrations, without a specified integrationSubtype request parameters are a key-value map specifying how to transform HTTP requests before sending them to backend integrations. The key should follow the pattern &lt;action&gt;:&lt;header|querystring|path&gt;.&lt;location&gt;. The action can be append, overwrite or remove. For values, you can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
    pub request_parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value. Supported only for WebSocket APIs.</p>
    pub request_templates:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Supported only for HTTP APIs. You use response parameters to transform the HTTP response from a backend integration before returning the response to clients. Specify a key-value map from a selection key to response parameters. The selection key must be a valid HTTP status code within the range of 200-599. Response parameters are a key-value map. The key must match pattern &lt;action&gt;:&lt;header&gt;.&lt;location&gt; or overwrite.statuscode. The action can be append, overwrite or remove. The value can be a static value, or map to response data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
    pub response_parameters: std::option::Option<
        std::collections::HashMap<
            std::string::String,
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    >,
    /// <p>The template selection expression for the integration. Supported only for WebSocket APIs.</p>
    pub template_selection_expression: std::option::Option<std::string::String>,
    /// <p>Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs. The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.</p>
    pub timeout_in_millis: i32,
    /// <p>The TLS configuration for a private integration. If you specify a TLS configuration, private integration traffic uses the HTTPS protocol. Supported only for HTTP APIs.</p>
    pub tls_config: std::option::Option<crate::model::TlsConfig>,
}
impl Integration {
    /// <p>Specifies whether an integration is managed by API Gateway. If you created an API using using quick create, the resulting integration is managed by API Gateway. You can update a managed integration, but you can't delete it.</p>
    pub fn api_gateway_managed(&self) -> bool {
        self.api_gateway_managed
    }
    /// <p>The ID of the VPC link for a private integration. Supported only for HTTP APIs.</p>
    pub fn connection_id(&self) -> std::option::Option<&str> {
        self.connection_id.as_deref()
    }
    /// <p>The type of the network connection to the integration endpoint. Specify INTERNET for connections through the public routable internet or VPC_LINK for private connections between API Gateway and resources in a VPC. The default value is INTERNET.</p>
    pub fn connection_type(&self) -> std::option::Option<&crate::model::ConnectionType> {
        self.connection_type.as_ref()
    }
    /// <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p> <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p> <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p> <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
    pub fn content_handling_strategy(
        &self,
    ) -> std::option::Option<&crate::model::ContentHandlingStrategy> {
        self.content_handling_strategy.as_ref()
    }
    /// <p>Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, specify null.</p>
    pub fn credentials_arn(&self) -> std::option::Option<&str> {
        self.credentials_arn.as_deref()
    }
    /// <p>Represents the description of an integration.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Represents the identifier of an integration.</p>
    pub fn integration_id(&self) -> std::option::Option<&str> {
        self.integration_id.as_deref()
    }
    /// <p>Specifies the integration's HTTP method type.</p>
    pub fn integration_method(&self) -> std::option::Option<&str> {
        self.integration_method.as_deref()
    }
    /// <p>The integration response selection expression for the integration. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-integration-response-selection-expressions">Integration Response Selection Expressions</a>.</p>
    pub fn integration_response_selection_expression(&self) -> std::option::Option<&str> {
        self.integration_response_selection_expression.as_deref()
    }
    /// <p>Supported only for HTTP API AWS_PROXY integrations. Specifies the AWS service action to invoke. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html">Integration subtype reference</a>.</p>
    pub fn integration_subtype(&self) -> std::option::Option<&str> {
        self.integration_subtype.as_deref()
    }
    /// <p>The integration type of an integration. One of the following:</p> <p>AWS: for integrating the route or method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration. Supported only for WebSocket APIs.</p> <p>AWS_PROXY: for integrating the route or method request with a Lambda function or other AWS service action. This integration is also referred to as a Lambda proxy integration.</p> <p>HTTP: for integrating the route or method request with an HTTP endpoint. This integration is also referred to as the HTTP custom integration. Supported only for WebSocket APIs.</p> <p>HTTP_PROXY: for integrating the route or method request with an HTTP endpoint, with the client request passed through as-is. This is also referred to as HTTP proxy integration.</p> <p>MOCK: for integrating the route or method request with API Gateway as a "loopback" endpoint without invoking any backend. Supported only for WebSocket APIs.</p>
    pub fn integration_type(&self) -> std::option::Option<&crate::model::IntegrationType> {
        self.integration_type.as_ref()
    }
    /// <p>For a Lambda integration, specify the URI of a Lambda function.</p> <p>For an HTTP integration, specify a fully-qualified URL.</p> <p>For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service. If you specify the ARN of an AWS Cloud Map service, API Gateway uses DiscoverInstances to identify resources. You can use query parameters to target specific resources. To learn more, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_DiscoverInstances.html">DiscoverInstances</a>. For private integrations, all resources must be owned by the same AWS account.</p>
    pub fn integration_uri(&self) -> std::option::Option<&str> {
        self.integration_uri.as_deref()
    }
    /// <p>Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER. Supported only for WebSocket APIs.</p> <p>WHEN_NO_MATCH passes the request body for unmapped content types through to the integration backend without transformation.</p> <p>NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type response.</p> <p>WHEN_NO_TEMPLATES allows pass-through when the integration has no content types mapped to templates. However, if there is at least one content type defined, unmapped content types will be rejected with the same HTTP 415 Unsupported Media Type response.</p>
    pub fn passthrough_behavior(&self) -> std::option::Option<&crate::model::PassthroughBehavior> {
        self.passthrough_behavior.as_ref()
    }
    /// <p>Specifies the format of the payload sent to an integration. Required for HTTP APIs.</p>
    pub fn payload_format_version(&self) -> std::option::Option<&str> {
        self.payload_format_version.as_deref()
    }
    /// <p>For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the backend. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the backend. The method request parameter value must match the pattern of method.request.<replaceable>{location}</replaceable>.<replaceable>{name}</replaceable>
    /// , where
    /// <replaceable>{location}</replaceable>
    /// is querystring, path, or header; and
    /// <replaceable>{name}</replaceable>
    /// must be a valid and unique method request parameter name.</p> <p>For HTTP API integrations with a specified integrationSubtype, request parameters are a key-value map specifying parameters that are passed to AWS_PROXY integrations. You can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services.html">Working with AWS service integrations for HTTP APIs</a>.</p> <p>For HTTP API itegrations, without a specified integrationSubtype request parameters are a key-value map specifying how to transform HTTP requests before sending them to backend integrations. The key should follow the pattern &lt;action&gt;:&lt;header|querystring|path&gt;.&lt;location&gt;. The action can be append, overwrite or remove. For values, you can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
    pub fn request_parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.request_parameters.as_ref()
    }
    /// <p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value. Supported only for WebSocket APIs.</p>
    pub fn request_templates(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.request_templates.as_ref()
    }
    /// <p>Supported only for HTTP APIs. You use response parameters to transform the HTTP response from a backend integration before returning the response to clients. Specify a key-value map from a selection key to response parameters. The selection key must be a valid HTTP status code within the range of 200-599. Response parameters are a key-value map. The key must match pattern &lt;action&gt;:&lt;header&gt;.&lt;location&gt; or overwrite.statuscode. The action can be append, overwrite or remove. The value can be a static value, or map to response data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
    pub fn response_parameters(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<
            std::string::String,
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    > {
        self.response_parameters.as_ref()
    }
    /// <p>The template selection expression for the integration. Supported only for WebSocket APIs.</p>
    pub fn template_selection_expression(&self) -> std::option::Option<&str> {
        self.template_selection_expression.as_deref()
    }
    /// <p>Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs. The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.</p>
    pub fn timeout_in_millis(&self) -> i32 {
        self.timeout_in_millis
    }
    /// <p>The TLS configuration for a private integration. If you specify a TLS configuration, private integration traffic uses the HTTPS protocol. Supported only for HTTP APIs.</p>
    pub fn tls_config(&self) -> std::option::Option<&crate::model::TlsConfig> {
        self.tls_config.as_ref()
    }
}
impl std::fmt::Debug for Integration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Integration");
        formatter.field("api_gateway_managed", &self.api_gateway_managed);
        formatter.field("connection_id", &self.connection_id);
        formatter.field("connection_type", &self.connection_type);
        formatter.field("content_handling_strategy", &self.content_handling_strategy);
        formatter.field("credentials_arn", &self.credentials_arn);
        formatter.field("description", &self.description);
        formatter.field("integration_id", &self.integration_id);
        formatter.field("integration_method", &self.integration_method);
        formatter.field(
            "integration_response_selection_expression",
            &self.integration_response_selection_expression,
        );
        formatter.field("integration_subtype", &self.integration_subtype);
        formatter.field("integration_type", &self.integration_type);
        formatter.field("integration_uri", &self.integration_uri);
        formatter.field("passthrough_behavior", &self.passthrough_behavior);
        formatter.field("payload_format_version", &self.payload_format_version);
        formatter.field("request_parameters", &self.request_parameters);
        formatter.field("request_templates", &self.request_templates);
        formatter.field("response_parameters", &self.response_parameters);
        formatter.field(
            "template_selection_expression",
            &self.template_selection_expression,
        );
        formatter.field("timeout_in_millis", &self.timeout_in_millis);
        formatter.field("tls_config", &self.tls_config);
        formatter.finish()
    }
}
/// See [`Integration`](crate::model::Integration)
pub mod integration {
    /// A builder for [`Integration`](crate::model::Integration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_gateway_managed: std::option::Option<bool>,
        pub(crate) connection_id: std::option::Option<std::string::String>,
        pub(crate) connection_type: std::option::Option<crate::model::ConnectionType>,
        pub(crate) content_handling_strategy:
            std::option::Option<crate::model::ContentHandlingStrategy>,
        pub(crate) credentials_arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) integration_id: std::option::Option<std::string::String>,
        pub(crate) integration_method: std::option::Option<std::string::String>,
        pub(crate) integration_response_selection_expression:
            std::option::Option<std::string::String>,
        pub(crate) integration_subtype: std::option::Option<std::string::String>,
        pub(crate) integration_type: std::option::Option<crate::model::IntegrationType>,
        pub(crate) integration_uri: std::option::Option<std::string::String>,
        pub(crate) passthrough_behavior: std::option::Option<crate::model::PassthroughBehavior>,
        pub(crate) payload_format_version: std::option::Option<std::string::String>,
        pub(crate) request_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) request_templates: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) response_parameters: std::option::Option<
            std::collections::HashMap<
                std::string::String,
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        >,
        pub(crate) template_selection_expression: std::option::Option<std::string::String>,
        pub(crate) timeout_in_millis: std::option::Option<i32>,
        pub(crate) tls_config: std::option::Option<crate::model::TlsConfig>,
    }
    impl Builder {
        /// <p>Specifies whether an integration is managed by API Gateway. If you created an API using using quick create, the resulting integration is managed by API Gateway. You can update a managed integration, but you can't delete it.</p>
        pub fn api_gateway_managed(mut self, input: bool) -> Self {
            self.api_gateway_managed = Some(input);
            self
        }
        /// <p>Specifies whether an integration is managed by API Gateway. If you created an API using using quick create, the resulting integration is managed by API Gateway. You can update a managed integration, but you can't delete it.</p>
        pub fn set_api_gateway_managed(mut self, input: std::option::Option<bool>) -> Self {
            self.api_gateway_managed = input;
            self
        }
        /// <p>The ID of the VPC link for a private integration. Supported only for HTTP APIs.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_id = Some(input.into());
            self
        }
        /// <p>The ID of the VPC link for a private integration. Supported only for HTTP APIs.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_id = input;
            self
        }
        /// <p>The type of the network connection to the integration endpoint. Specify INTERNET for connections through the public routable internet or VPC_LINK for private connections between API Gateway and resources in a VPC. The default value is INTERNET.</p>
        pub fn connection_type(mut self, input: crate::model::ConnectionType) -> Self {
            self.connection_type = Some(input);
            self
        }
        /// <p>The type of the network connection to the integration endpoint. Specify INTERNET for connections through the public routable internet or VPC_LINK for private connections between API Gateway and resources in a VPC. The default value is INTERNET.</p>
        pub fn set_connection_type(
            mut self,
            input: std::option::Option<crate::model::ConnectionType>,
        ) -> Self {
            self.connection_type = input;
            self
        }
        /// <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p> <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p> <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p> <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
        pub fn content_handling_strategy(
            mut self,
            input: crate::model::ContentHandlingStrategy,
        ) -> Self {
            self.content_handling_strategy = Some(input);
            self
        }
        /// <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p> <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p> <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p> <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
        pub fn set_content_handling_strategy(
            mut self,
            input: std::option::Option<crate::model::ContentHandlingStrategy>,
        ) -> Self {
            self.content_handling_strategy = input;
            self
        }
        /// <p>Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, specify null.</p>
        pub fn credentials_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.credentials_arn = Some(input.into());
            self
        }
        /// <p>Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, specify null.</p>
        pub fn set_credentials_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.credentials_arn = input;
            self
        }
        /// <p>Represents the description of an integration.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Represents the description of an integration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Represents the identifier of an integration.</p>
        pub fn integration_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.integration_id = Some(input.into());
            self
        }
        /// <p>Represents the identifier of an integration.</p>
        pub fn set_integration_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.integration_id = input;
            self
        }
        /// <p>Specifies the integration's HTTP method type.</p>
        pub fn integration_method(mut self, input: impl Into<std::string::String>) -> Self {
            self.integration_method = Some(input.into());
            self
        }
        /// <p>Specifies the integration's HTTP method type.</p>
        pub fn set_integration_method(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.integration_method = input;
            self
        }
        /// <p>The integration response selection expression for the integration. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-integration-response-selection-expressions">Integration Response Selection Expressions</a>.</p>
        pub fn integration_response_selection_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.integration_response_selection_expression = Some(input.into());
            self
        }
        /// <p>The integration response selection expression for the integration. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-integration-response-selection-expressions">Integration Response Selection Expressions</a>.</p>
        pub fn set_integration_response_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.integration_response_selection_expression = input;
            self
        }
        /// <p>Supported only for HTTP API AWS_PROXY integrations. Specifies the AWS service action to invoke. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html">Integration subtype reference</a>.</p>
        pub fn integration_subtype(mut self, input: impl Into<std::string::String>) -> Self {
            self.integration_subtype = Some(input.into());
            self
        }
        /// <p>Supported only for HTTP API AWS_PROXY integrations. Specifies the AWS service action to invoke. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html">Integration subtype reference</a>.</p>
        pub fn set_integration_subtype(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.integration_subtype = input;
            self
        }
        /// <p>The integration type of an integration. One of the following:</p> <p>AWS: for integrating the route or method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration. Supported only for WebSocket APIs.</p> <p>AWS_PROXY: for integrating the route or method request with a Lambda function or other AWS service action. This integration is also referred to as a Lambda proxy integration.</p> <p>HTTP: for integrating the route or method request with an HTTP endpoint. This integration is also referred to as the HTTP custom integration. Supported only for WebSocket APIs.</p> <p>HTTP_PROXY: for integrating the route or method request with an HTTP endpoint, with the client request passed through as-is. This is also referred to as HTTP proxy integration.</p> <p>MOCK: for integrating the route or method request with API Gateway as a "loopback" endpoint without invoking any backend. Supported only for WebSocket APIs.</p>
        pub fn integration_type(mut self, input: crate::model::IntegrationType) -> Self {
            self.integration_type = Some(input);
            self
        }
        /// <p>The integration type of an integration. One of the following:</p> <p>AWS: for integrating the route or method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration. Supported only for WebSocket APIs.</p> <p>AWS_PROXY: for integrating the route or method request with a Lambda function or other AWS service action. This integration is also referred to as a Lambda proxy integration.</p> <p>HTTP: for integrating the route or method request with an HTTP endpoint. This integration is also referred to as the HTTP custom integration. Supported only for WebSocket APIs.</p> <p>HTTP_PROXY: for integrating the route or method request with an HTTP endpoint, with the client request passed through as-is. This is also referred to as HTTP proxy integration.</p> <p>MOCK: for integrating the route or method request with API Gateway as a "loopback" endpoint without invoking any backend. Supported only for WebSocket APIs.</p>
        pub fn set_integration_type(
            mut self,
            input: std::option::Option<crate::model::IntegrationType>,
        ) -> Self {
            self.integration_type = input;
            self
        }
        /// <p>For a Lambda integration, specify the URI of a Lambda function.</p> <p>For an HTTP integration, specify a fully-qualified URL.</p> <p>For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service. If you specify the ARN of an AWS Cloud Map service, API Gateway uses DiscoverInstances to identify resources. You can use query parameters to target specific resources. To learn more, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_DiscoverInstances.html">DiscoverInstances</a>. For private integrations, all resources must be owned by the same AWS account.</p>
        pub fn integration_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.integration_uri = Some(input.into());
            self
        }
        /// <p>For a Lambda integration, specify the URI of a Lambda function.</p> <p>For an HTTP integration, specify a fully-qualified URL.</p> <p>For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service. If you specify the ARN of an AWS Cloud Map service, API Gateway uses DiscoverInstances to identify resources. You can use query parameters to target specific resources. To learn more, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_DiscoverInstances.html">DiscoverInstances</a>. For private integrations, all resources must be owned by the same AWS account.</p>
        pub fn set_integration_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.integration_uri = input;
            self
        }
        /// <p>Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER. Supported only for WebSocket APIs.</p> <p>WHEN_NO_MATCH passes the request body for unmapped content types through to the integration backend without transformation.</p> <p>NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type response.</p> <p>WHEN_NO_TEMPLATES allows pass-through when the integration has no content types mapped to templates. However, if there is at least one content type defined, unmapped content types will be rejected with the same HTTP 415 Unsupported Media Type response.</p>
        pub fn passthrough_behavior(mut self, input: crate::model::PassthroughBehavior) -> Self {
            self.passthrough_behavior = Some(input);
            self
        }
        /// <p>Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER. Supported only for WebSocket APIs.</p> <p>WHEN_NO_MATCH passes the request body for unmapped content types through to the integration backend without transformation.</p> <p>NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type response.</p> <p>WHEN_NO_TEMPLATES allows pass-through when the integration has no content types mapped to templates. However, if there is at least one content type defined, unmapped content types will be rejected with the same HTTP 415 Unsupported Media Type response.</p>
        pub fn set_passthrough_behavior(
            mut self,
            input: std::option::Option<crate::model::PassthroughBehavior>,
        ) -> Self {
            self.passthrough_behavior = input;
            self
        }
        /// <p>Specifies the format of the payload sent to an integration. Required for HTTP APIs.</p>
        pub fn payload_format_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.payload_format_version = Some(input.into());
            self
        }
        /// <p>Specifies the format of the payload sent to an integration. Required for HTTP APIs.</p>
        pub fn set_payload_format_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.payload_format_version = input;
            self
        }
        /// Adds a key-value pair to `request_parameters`.
        ///
        /// To override the contents of this collection use [`set_request_parameters`](Self::set_request_parameters).
        ///
        /// <p>For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the backend. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the backend. The method request parameter value must match the pattern of method.request.<replaceable>{location}</replaceable>.<replaceable>{name}</replaceable>
        /// , where
        /// <replaceable>{location}</replaceable>
        /// is querystring, path, or header; and
        /// <replaceable>{name}</replaceable>
        /// must be a valid and unique method request parameter name.</p> <p>For HTTP API integrations with a specified integrationSubtype, request parameters are a key-value map specifying parameters that are passed to AWS_PROXY integrations. You can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services.html">Working with AWS service integrations for HTTP APIs</a>.</p> <p>For HTTP API itegrations, without a specified integrationSubtype request parameters are a key-value map specifying how to transform HTTP requests before sending them to backend integrations. The key should follow the pattern &lt;action&gt;:&lt;header|querystring|path&gt;.&lt;location&gt;. The action can be append, overwrite or remove. For values, you can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
        pub fn request_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.request_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.request_parameters = Some(hash_map);
            self
        }
        /// <p>For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the backend. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the backend. The method request parameter value must match the pattern of method.request.<replaceable>{location}</replaceable>.<replaceable>{name}</replaceable>
        /// , where
        /// <replaceable>{location}</replaceable>
        /// is querystring, path, or header; and
        /// <replaceable>{name}</replaceable>
        /// must be a valid and unique method request parameter name.</p> <p>For HTTP API integrations with a specified integrationSubtype, request parameters are a key-value map specifying parameters that are passed to AWS_PROXY integrations. You can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services.html">Working with AWS service integrations for HTTP APIs</a>.</p> <p>For HTTP API itegrations, without a specified integrationSubtype request parameters are a key-value map specifying how to transform HTTP requests before sending them to backend integrations. The key should follow the pattern &lt;action&gt;:&lt;header|querystring|path&gt;.&lt;location&gt;. The action can be append, overwrite or remove. For values, you can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
        pub fn set_request_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.request_parameters = input;
            self
        }
        /// Adds a key-value pair to `request_templates`.
        ///
        /// To override the contents of this collection use [`set_request_templates`](Self::set_request_templates).
        ///
        /// <p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value. Supported only for WebSocket APIs.</p>
        pub fn request_templates(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.request_templates.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.request_templates = Some(hash_map);
            self
        }
        /// <p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value. Supported only for WebSocket APIs.</p>
        pub fn set_request_templates(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.request_templates = input;
            self
        }
        /// Adds a key-value pair to `response_parameters`.
        ///
        /// To override the contents of this collection use [`set_response_parameters`](Self::set_response_parameters).
        ///
        /// <p>Supported only for HTTP APIs. You use response parameters to transform the HTTP response from a backend integration before returning the response to clients. Specify a key-value map from a selection key to response parameters. The selection key must be a valid HTTP status code within the range of 200-599. Response parameters are a key-value map. The key must match pattern &lt;action&gt;:&lt;header&gt;.&lt;location&gt; or overwrite.statuscode. The action can be append, overwrite or remove. The value can be a static value, or map to response data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
        pub fn response_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::collections::HashMap<std::string::String, std::string::String>>,
        ) -> Self {
            let mut hash_map = self.response_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.response_parameters = Some(hash_map);
            self
        }
        /// <p>Supported only for HTTP APIs. You use response parameters to transform the HTTP response from a backend integration before returning the response to clients. Specify a key-value map from a selection key to response parameters. The selection key must be a valid HTTP status code within the range of 200-599. Response parameters are a key-value map. The key must match pattern &lt;action&gt;:&lt;header&gt;.&lt;location&gt; or overwrite.statuscode. The action can be append, overwrite or remove. The value can be a static value, or map to response data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
        pub fn set_response_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    std::collections::HashMap<std::string::String, std::string::String>,
                >,
            >,
        ) -> Self {
            self.response_parameters = input;
            self
        }
        /// <p>The template selection expression for the integration. Supported only for WebSocket APIs.</p>
        pub fn template_selection_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.template_selection_expression = Some(input.into());
            self
        }
        /// <p>The template selection expression for the integration. Supported only for WebSocket APIs.</p>
        pub fn set_template_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_selection_expression = input;
            self
        }
        /// <p>Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs. The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.</p>
        pub fn timeout_in_millis(mut self, input: i32) -> Self {
            self.timeout_in_millis = Some(input);
            self
        }
        /// <p>Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs. The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.</p>
        pub fn set_timeout_in_millis(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout_in_millis = input;
            self
        }
        /// <p>The TLS configuration for a private integration. If you specify a TLS configuration, private integration traffic uses the HTTPS protocol. Supported only for HTTP APIs.</p>
        pub fn tls_config(mut self, input: crate::model::TlsConfig) -> Self {
            self.tls_config = Some(input);
            self
        }
        /// <p>The TLS configuration for a private integration. If you specify a TLS configuration, private integration traffic uses the HTTPS protocol. Supported only for HTTP APIs.</p>
        pub fn set_tls_config(
            mut self,
            input: std::option::Option<crate::model::TlsConfig>,
        ) -> Self {
            self.tls_config = input;
            self
        }
        /// Consumes the builder and constructs a [`Integration`](crate::model::Integration)
        pub fn build(self) -> crate::model::Integration {
            crate::model::Integration {
                api_gateway_managed: self.api_gateway_managed.unwrap_or_default(),
                connection_id: self.connection_id,
                connection_type: self.connection_type,
                content_handling_strategy: self.content_handling_strategy,
                credentials_arn: self.credentials_arn,
                description: self.description,
                integration_id: self.integration_id,
                integration_method: self.integration_method,
                integration_response_selection_expression: self
                    .integration_response_selection_expression,
                integration_subtype: self.integration_subtype,
                integration_type: self.integration_type,
                integration_uri: self.integration_uri,
                passthrough_behavior: self.passthrough_behavior,
                payload_format_version: self.payload_format_version,
                request_parameters: self.request_parameters,
                request_templates: self.request_templates,
                response_parameters: self.response_parameters,
                template_selection_expression: self.template_selection_expression,
                timeout_in_millis: self.timeout_in_millis.unwrap_or_default(),
                tls_config: self.tls_config,
            }
        }
    }
}
impl Integration {
    /// Creates a new builder-style object to manufacture [`Integration`](crate::model::Integration)
    pub fn builder() -> crate::model::integration::Builder {
        crate::model::integration::Builder::default()
    }
}

/// <p>Represents an integration response.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IntegrationResponse {
    /// <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p> <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p> <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p> <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
    pub content_handling_strategy: std::option::Option<crate::model::ContentHandlingStrategy>,
    /// <p>The integration response ID.</p>
    pub integration_response_id: std::option::Option<std::string::String>,
    /// <p>The integration response key.</p>
    pub integration_response_key: std::option::Option<std::string::String>,
    /// <p>A key-value map specifying response parameters that are passed to the method response from the backend. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of method.response.header.{name}, where name is a valid and unique header name. The mapped non-static value must match the pattern of integration.response.header.{name} or integration.response.body.{JSON-expression}, where name is a valid and unique response header name and JSON-expression is a valid JSON expression without the $ prefix.</p>
    pub response_parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The collection of response templates for the integration response as a string-to-string map of key-value pairs. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.</p>
    pub response_templates:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The template selection expressions for the integration response.</p>
    pub template_selection_expression: std::option::Option<std::string::String>,
}
impl IntegrationResponse {
    /// <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p> <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p> <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p> <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
    pub fn content_handling_strategy(
        &self,
    ) -> std::option::Option<&crate::model::ContentHandlingStrategy> {
        self.content_handling_strategy.as_ref()
    }
    /// <p>The integration response ID.</p>
    pub fn integration_response_id(&self) -> std::option::Option<&str> {
        self.integration_response_id.as_deref()
    }
    /// <p>The integration response key.</p>
    pub fn integration_response_key(&self) -> std::option::Option<&str> {
        self.integration_response_key.as_deref()
    }
    /// <p>A key-value map specifying response parameters that are passed to the method response from the backend. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of method.response.header.{name}, where name is a valid and unique header name. The mapped non-static value must match the pattern of integration.response.header.{name} or integration.response.body.{JSON-expression}, where name is a valid and unique response header name and JSON-expression is a valid JSON expression without the $ prefix.</p>
    pub fn response_parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.response_parameters.as_ref()
    }
    /// <p>The collection of response templates for the integration response as a string-to-string map of key-value pairs. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.</p>
    pub fn response_templates(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.response_templates.as_ref()
    }
    /// <p>The template selection expressions for the integration response.</p>
    pub fn template_selection_expression(&self) -> std::option::Option<&str> {
        self.template_selection_expression.as_deref()
    }
}
impl std::fmt::Debug for IntegrationResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IntegrationResponse");
        formatter.field("content_handling_strategy", &self.content_handling_strategy);
        formatter.field("integration_response_id", &self.integration_response_id);
        formatter.field("integration_response_key", &self.integration_response_key);
        formatter.field("response_parameters", &self.response_parameters);
        formatter.field("response_templates", &self.response_templates);
        formatter.field(
            "template_selection_expression",
            &self.template_selection_expression,
        );
        formatter.finish()
    }
}
/// See [`IntegrationResponse`](crate::model::IntegrationResponse)
pub mod integration_response {
    /// A builder for [`IntegrationResponse`](crate::model::IntegrationResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) content_handling_strategy:
            std::option::Option<crate::model::ContentHandlingStrategy>,
        pub(crate) integration_response_id: std::option::Option<std::string::String>,
        pub(crate) integration_response_key: std::option::Option<std::string::String>,
        pub(crate) response_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) response_templates: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) template_selection_expression: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p> <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p> <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p> <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
        pub fn content_handling_strategy(
            mut self,
            input: crate::model::ContentHandlingStrategy,
        ) -> Self {
            self.content_handling_strategy = Some(input);
            self
        }
        /// <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p> <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p> <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p> <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
        pub fn set_content_handling_strategy(
            mut self,
            input: std::option::Option<crate::model::ContentHandlingStrategy>,
        ) -> Self {
            self.content_handling_strategy = input;
            self
        }
        /// <p>The integration response ID.</p>
        pub fn integration_response_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.integration_response_id = Some(input.into());
            self
        }
        /// <p>The integration response ID.</p>
        pub fn set_integration_response_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.integration_response_id = input;
            self
        }
        /// <p>The integration response key.</p>
        pub fn integration_response_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.integration_response_key = Some(input.into());
            self
        }
        /// <p>The integration response key.</p>
        pub fn set_integration_response_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.integration_response_key = input;
            self
        }
        /// Adds a key-value pair to `response_parameters`.
        ///
        /// To override the contents of this collection use [`set_response_parameters`](Self::set_response_parameters).
        ///
        /// <p>A key-value map specifying response parameters that are passed to the method response from the backend. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of method.response.header.{name}, where name is a valid and unique header name. The mapped non-static value must match the pattern of integration.response.header.{name} or integration.response.body.{JSON-expression}, where name is a valid and unique response header name and JSON-expression is a valid JSON expression without the $ prefix.</p>
        pub fn response_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.response_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.response_parameters = Some(hash_map);
            self
        }
        /// <p>A key-value map specifying response parameters that are passed to the method response from the backend. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of method.response.header.{name}, where name is a valid and unique header name. The mapped non-static value must match the pattern of integration.response.header.{name} or integration.response.body.{JSON-expression}, where name is a valid and unique response header name and JSON-expression is a valid JSON expression without the $ prefix.</p>
        pub fn set_response_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.response_parameters = input;
            self
        }
        /// Adds a key-value pair to `response_templates`.
        ///
        /// To override the contents of this collection use [`set_response_templates`](Self::set_response_templates).
        ///
        /// <p>The collection of response templates for the integration response as a string-to-string map of key-value pairs. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.</p>
        pub fn response_templates(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.response_templates.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.response_templates = Some(hash_map);
            self
        }
        /// <p>The collection of response templates for the integration response as a string-to-string map of key-value pairs. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.</p>
        pub fn set_response_templates(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.response_templates = input;
            self
        }
        /// <p>The template selection expressions for the integration response.</p>
        pub fn template_selection_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.template_selection_expression = Some(input.into());
            self
        }
        /// <p>The template selection expressions for the integration response.</p>
        pub fn set_template_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_selection_expression = input;
            self
        }
        /// Consumes the builder and constructs a [`IntegrationResponse`](crate::model::IntegrationResponse)
        pub fn build(self) -> crate::model::IntegrationResponse {
            crate::model::IntegrationResponse {
                content_handling_strategy: self.content_handling_strategy,
                integration_response_id: self.integration_response_id,
                integration_response_key: self.integration_response_key,
                response_parameters: self.response_parameters,
                response_templates: self.response_templates,
                template_selection_expression: self.template_selection_expression,
            }
        }
    }
}
impl IntegrationResponse {
    /// Creates a new builder-style object to manufacture [`IntegrationResponse`](crate::model::IntegrationResponse)
    pub fn builder() -> crate::model::integration_response::Builder {
        crate::model::integration_response::Builder::default()
    }
}

/// <p>Represents a domain name.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DomainName {
    /// <p>The API mapping selection expression.</p>
    pub api_mapping_selection_expression: std::option::Option<std::string::String>,
    /// <p>The name of the DomainName resource.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The domain name configurations.</p>
    pub domain_name_configurations:
        std::option::Option<std::vec::Vec<crate::model::DomainNameConfiguration>>,
    /// <p>The mutual TLS authentication configuration for a custom domain name.</p>
    pub mutual_tls_authentication: std::option::Option<crate::model::MutualTlsAuthentication>,
    /// <p>The collection of tags associated with a domain name.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl DomainName {
    /// <p>The API mapping selection expression.</p>
    pub fn api_mapping_selection_expression(&self) -> std::option::Option<&str> {
        self.api_mapping_selection_expression.as_deref()
    }
    /// <p>The name of the DomainName resource.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>The domain name configurations.</p>
    pub fn domain_name_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::DomainNameConfiguration]> {
        self.domain_name_configurations.as_deref()
    }
    /// <p>The mutual TLS authentication configuration for a custom domain name.</p>
    pub fn mutual_tls_authentication(
        &self,
    ) -> std::option::Option<&crate::model::MutualTlsAuthentication> {
        self.mutual_tls_authentication.as_ref()
    }
    /// <p>The collection of tags associated with a domain name.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for DomainName {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DomainName");
        formatter.field(
            "api_mapping_selection_expression",
            &self.api_mapping_selection_expression,
        );
        formatter.field("domain_name", &self.domain_name);
        formatter.field(
            "domain_name_configurations",
            &self.domain_name_configurations,
        );
        formatter.field("mutual_tls_authentication", &self.mutual_tls_authentication);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`DomainName`](crate::model::DomainName)
pub mod domain_name {
    /// A builder for [`DomainName`](crate::model::DomainName)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_mapping_selection_expression: std::option::Option<std::string::String>,
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) domain_name_configurations:
            std::option::Option<std::vec::Vec<crate::model::DomainNameConfiguration>>,
        pub(crate) mutual_tls_authentication:
            std::option::Option<crate::model::MutualTlsAuthentication>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The API mapping selection expression.</p>
        pub fn api_mapping_selection_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.api_mapping_selection_expression = Some(input.into());
            self
        }
        /// <p>The API mapping selection expression.</p>
        pub fn set_api_mapping_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.api_mapping_selection_expression = input;
            self
        }
        /// <p>The name of the DomainName resource.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of the DomainName resource.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Appends an item to `domain_name_configurations`.
        ///
        /// To override the contents of this collection use [`set_domain_name_configurations`](Self::set_domain_name_configurations).
        ///
        /// <p>The domain name configurations.</p>
        pub fn domain_name_configurations(
            mut self,
            input: impl Into<crate::model::DomainNameConfiguration>,
        ) -> Self {
            let mut v = self.domain_name_configurations.unwrap_or_default();
            v.push(input.into());
            self.domain_name_configurations = Some(v);
            self
        }
        /// <p>The domain name configurations.</p>
        pub fn set_domain_name_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DomainNameConfiguration>>,
        ) -> Self {
            self.domain_name_configurations = input;
            self
        }
        /// <p>The mutual TLS authentication configuration for a custom domain name.</p>
        pub fn mutual_tls_authentication(
            mut self,
            input: crate::model::MutualTlsAuthentication,
        ) -> Self {
            self.mutual_tls_authentication = Some(input);
            self
        }
        /// <p>The mutual TLS authentication configuration for a custom domain name.</p>
        pub fn set_mutual_tls_authentication(
            mut self,
            input: std::option::Option<crate::model::MutualTlsAuthentication>,
        ) -> Self {
            self.mutual_tls_authentication = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The collection of tags associated with a domain name.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The collection of tags associated with a domain name.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`DomainName`](crate::model::DomainName)
        pub fn build(self) -> crate::model::DomainName {
            crate::model::DomainName {
                api_mapping_selection_expression: self.api_mapping_selection_expression,
                domain_name: self.domain_name,
                domain_name_configurations: self.domain_name_configurations,
                mutual_tls_authentication: self.mutual_tls_authentication,
                tags: self.tags,
            }
        }
    }
}
impl DomainName {
    /// Creates a new builder-style object to manufacture [`DomainName`](crate::model::DomainName)
    pub fn builder() -> crate::model::domain_name::Builder {
        crate::model::domain_name::Builder::default()
    }
}

/// <p>An immutable representation of an API that can be called by users. A Deployment must be associated with a Stage for it to be callable over the internet.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Deployment {
    /// <p>Specifies whether a deployment was automatically released.</p>
    pub auto_deployed: bool,
    /// <p>The date and time when the Deployment resource was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The identifier for the deployment.</p>
    pub deployment_id: std::option::Option<std::string::String>,
    /// <p>The status of the deployment: PENDING, FAILED, or SUCCEEDED.</p>
    pub deployment_status: std::option::Option<crate::model::DeploymentStatus>,
    /// <p>May contain additional feedback on the status of an API deployment.</p>
    pub deployment_status_message: std::option::Option<std::string::String>,
    /// <p>The description for the deployment.</p>
    pub description: std::option::Option<std::string::String>,
}
impl Deployment {
    /// <p>Specifies whether a deployment was automatically released.</p>
    pub fn auto_deployed(&self) -> bool {
        self.auto_deployed
    }
    /// <p>The date and time when the Deployment resource was created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_date.as_ref()
    }
    /// <p>The identifier for the deployment.</p>
    pub fn deployment_id(&self) -> std::option::Option<&str> {
        self.deployment_id.as_deref()
    }
    /// <p>The status of the deployment: PENDING, FAILED, or SUCCEEDED.</p>
    pub fn deployment_status(&self) -> std::option::Option<&crate::model::DeploymentStatus> {
        self.deployment_status.as_ref()
    }
    /// <p>May contain additional feedback on the status of an API deployment.</p>
    pub fn deployment_status_message(&self) -> std::option::Option<&str> {
        self.deployment_status_message.as_deref()
    }
    /// <p>The description for the deployment.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for Deployment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Deployment");
        formatter.field("auto_deployed", &self.auto_deployed);
        formatter.field("created_date", &self.created_date);
        formatter.field("deployment_id", &self.deployment_id);
        formatter.field("deployment_status", &self.deployment_status);
        formatter.field("deployment_status_message", &self.deployment_status_message);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`Deployment`](crate::model::Deployment)
pub mod deployment {
    /// A builder for [`Deployment`](crate::model::Deployment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_deployed: std::option::Option<bool>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) deployment_id: std::option::Option<std::string::String>,
        pub(crate) deployment_status: std::option::Option<crate::model::DeploymentStatus>,
        pub(crate) deployment_status_message: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies whether a deployment was automatically released.</p>
        pub fn auto_deployed(mut self, input: bool) -> Self {
            self.auto_deployed = Some(input);
            self
        }
        /// <p>Specifies whether a deployment was automatically released.</p>
        pub fn set_auto_deployed(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_deployed = input;
            self
        }
        /// <p>The date and time when the Deployment resource was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The date and time when the Deployment resource was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>The identifier for the deployment.</p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_id = Some(input.into());
            self
        }
        /// <p>The identifier for the deployment.</p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_id = input;
            self
        }
        /// <p>The status of the deployment: PENDING, FAILED, or SUCCEEDED.</p>
        pub fn deployment_status(mut self, input: crate::model::DeploymentStatus) -> Self {
            self.deployment_status = Some(input);
            self
        }
        /// <p>The status of the deployment: PENDING, FAILED, or SUCCEEDED.</p>
        pub fn set_deployment_status(
            mut self,
            input: std::option::Option<crate::model::DeploymentStatus>,
        ) -> Self {
            self.deployment_status = input;
            self
        }
        /// <p>May contain additional feedback on the status of an API deployment.</p>
        pub fn deployment_status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_status_message = Some(input.into());
            self
        }
        /// <p>May contain additional feedback on the status of an API deployment.</p>
        pub fn set_deployment_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_status_message = input;
            self
        }
        /// <p>The description for the deployment.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description for the deployment.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`Deployment`](crate::model::Deployment)
        pub fn build(self) -> crate::model::Deployment {
            crate::model::Deployment {
                auto_deployed: self.auto_deployed.unwrap_or_default(),
                created_date: self.created_date,
                deployment_id: self.deployment_id,
                deployment_status: self.deployment_status,
                deployment_status_message: self.deployment_status_message,
                description: self.description,
            }
        }
    }
}
impl Deployment {
    /// Creates a new builder-style object to manufacture [`Deployment`](crate::model::Deployment)
    pub fn builder() -> crate::model::deployment::Builder {
        crate::model::deployment::Builder::default()
    }
}

/// <p>Represents an authorizer.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Authorizer {
    /// <p>Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, don't specify this parameter. Supported only for REQUEST authorizers.</p>
    pub authorizer_credentials_arn: std::option::Option<std::string::String>,
    /// <p>The authorizer identifier.</p>
    pub authorizer_id: std::option::Option<std::string::String>,
    /// <p>Specifies the format of the payload sent to an HTTP API Lambda authorizer. Required for HTTP API Lambda authorizers. Supported values are 1.0 and 2.0. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p>
    pub authorizer_payload_format_version: std::option::Option<std::string::String>,
    /// <p>The time to live (TTL) for cached authorizer results, in seconds. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway caches authorizer responses. The maximum value is 3600, or 1 hour. Supported only for HTTP API Lambda authorizers.</p>
    pub authorizer_result_ttl_in_seconds: i32,
    /// <p>The authorizer type. Specify REQUEST for a Lambda function using incoming request parameters. Specify JWT to use JSON Web Tokens (supported only for HTTP APIs).</p>
    pub authorizer_type: std::option::Option<crate::model::AuthorizerType>,
    /// <p>The authorizer's Uniform Resource Identifier (URI). For REQUEST authorizers, this must be a well-formed Lambda function URI, for example, arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:<replaceable>{account_id}</replaceable>:function:<replaceable>{lambda_function_name}</replaceable>/invocations. In general, the URI has this form: arn:aws:apigateway:<replaceable>{region}</replaceable>:lambda:path/<replaceable>{service_api}</replaceable>
    /// , where <replaceable></replaceable>{region} is the same as the region hosting the Lambda function, path indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial /. For Lambda functions, this is usually of the form /2015-03-31/functions/[FunctionARN]/invocations. Supported only for REQUEST authorizers.</p>
    pub authorizer_uri: std::option::Option<std::string::String>,
    /// <p>Specifies whether a Lambda authorizer returns a response in a simple format. If enabled, the Lambda authorizer can return a boolean value instead of an IAM policy. Supported only for HTTP APIs. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a></p>
    pub enable_simple_responses: bool,
    /// <p>The identity source for which authorization is requested.</p> <p>For a REQUEST authorizer, this is optional. The value is a set of one or more mapping expressions of the specified request parameters. The identity source can be headers, query string parameters, stage variables, and context parameters. For example, if an Auth header and a Name query string parameter are defined as identity sources, this value is route.request.header.Auth, route.request.querystring.Name for WebSocket APIs. For HTTP APIs, use selection expressions prefixed with $, for example, $request.header.Auth, $request.querystring.Name. These parameters are used to perform runtime validation for Lambda-based authorizers by verifying all of the identity-related request parameters are present in the request, not null, and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function. Otherwise, it returns a 401 Unauthorized response without calling the Lambda function. For HTTP APIs, identity sources are also used as the cache key when caching is enabled. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p> <p>For JWT, a single entry that specifies where to extract the JSON Web Token (JWT) from inbound requests. Currently only header-based and query parameter-based selections are supported, for example $request.header.Authorization.</p>
    pub identity_source: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The validation expression does not apply to the REQUEST authorizer.</p>
    pub identity_validation_expression: std::option::Option<std::string::String>,
    /// <p>Represents the configuration of a JWT authorizer. Required for the JWT authorizer type. Supported only for HTTP APIs.</p>
    pub jwt_configuration: std::option::Option<crate::model::JwtConfiguration>,
    /// <p>The name of the authorizer.</p>
    pub name: std::option::Option<std::string::String>,
}
impl Authorizer {
    /// <p>Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, don't specify this parameter. Supported only for REQUEST authorizers.</p>
    pub fn authorizer_credentials_arn(&self) -> std::option::Option<&str> {
        self.authorizer_credentials_arn.as_deref()
    }
    /// <p>The authorizer identifier.</p>
    pub fn authorizer_id(&self) -> std::option::Option<&str> {
        self.authorizer_id.as_deref()
    }
    /// <p>Specifies the format of the payload sent to an HTTP API Lambda authorizer. Required for HTTP API Lambda authorizers. Supported values are 1.0 and 2.0. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p>
    pub fn authorizer_payload_format_version(&self) -> std::option::Option<&str> {
        self.authorizer_payload_format_version.as_deref()
    }
    /// <p>The time to live (TTL) for cached authorizer results, in seconds. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway caches authorizer responses. The maximum value is 3600, or 1 hour. Supported only for HTTP API Lambda authorizers.</p>
    pub fn authorizer_result_ttl_in_seconds(&self) -> i32 {
        self.authorizer_result_ttl_in_seconds
    }
    /// <p>The authorizer type. Specify REQUEST for a Lambda function using incoming request parameters. Specify JWT to use JSON Web Tokens (supported only for HTTP APIs).</p>
    pub fn authorizer_type(&self) -> std::option::Option<&crate::model::AuthorizerType> {
        self.authorizer_type.as_ref()
    }
    /// <p>The authorizer's Uniform Resource Identifier (URI). For REQUEST authorizers, this must be a well-formed Lambda function URI, for example, arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:<replaceable>{account_id}</replaceable>:function:<replaceable>{lambda_function_name}</replaceable>/invocations. In general, the URI has this form: arn:aws:apigateway:<replaceable>{region}</replaceable>:lambda:path/<replaceable>{service_api}</replaceable>
    /// , where <replaceable></replaceable>{region} is the same as the region hosting the Lambda function, path indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial /. For Lambda functions, this is usually of the form /2015-03-31/functions/[FunctionARN]/invocations. Supported only for REQUEST authorizers.</p>
    pub fn authorizer_uri(&self) -> std::option::Option<&str> {
        self.authorizer_uri.as_deref()
    }
    /// <p>Specifies whether a Lambda authorizer returns a response in a simple format. If enabled, the Lambda authorizer can return a boolean value instead of an IAM policy. Supported only for HTTP APIs. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a></p>
    pub fn enable_simple_responses(&self) -> bool {
        self.enable_simple_responses
    }
    /// <p>The identity source for which authorization is requested.</p> <p>For a REQUEST authorizer, this is optional. The value is a set of one or more mapping expressions of the specified request parameters. The identity source can be headers, query string parameters, stage variables, and context parameters. For example, if an Auth header and a Name query string parameter are defined as identity sources, this value is route.request.header.Auth, route.request.querystring.Name for WebSocket APIs. For HTTP APIs, use selection expressions prefixed with $, for example, $request.header.Auth, $request.querystring.Name. These parameters are used to perform runtime validation for Lambda-based authorizers by verifying all of the identity-related request parameters are present in the request, not null, and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function. Otherwise, it returns a 401 Unauthorized response without calling the Lambda function. For HTTP APIs, identity sources are also used as the cache key when caching is enabled. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p> <p>For JWT, a single entry that specifies where to extract the JSON Web Token (JWT) from inbound requests. Currently only header-based and query parameter-based selections are supported, for example $request.header.Authorization.</p>
    pub fn identity_source(&self) -> std::option::Option<&[std::string::String]> {
        self.identity_source.as_deref()
    }
    /// <p>The validation expression does not apply to the REQUEST authorizer.</p>
    pub fn identity_validation_expression(&self) -> std::option::Option<&str> {
        self.identity_validation_expression.as_deref()
    }
    /// <p>Represents the configuration of a JWT authorizer. Required for the JWT authorizer type. Supported only for HTTP APIs.</p>
    pub fn jwt_configuration(&self) -> std::option::Option<&crate::model::JwtConfiguration> {
        self.jwt_configuration.as_ref()
    }
    /// <p>The name of the authorizer.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for Authorizer {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Authorizer");
        formatter.field(
            "authorizer_credentials_arn",
            &self.authorizer_credentials_arn,
        );
        formatter.field("authorizer_id", &self.authorizer_id);
        formatter.field(
            "authorizer_payload_format_version",
            &self.authorizer_payload_format_version,
        );
        formatter.field(
            "authorizer_result_ttl_in_seconds",
            &self.authorizer_result_ttl_in_seconds,
        );
        formatter.field("authorizer_type", &self.authorizer_type);
        formatter.field("authorizer_uri", &self.authorizer_uri);
        formatter.field("enable_simple_responses", &self.enable_simple_responses);
        formatter.field("identity_source", &self.identity_source);
        formatter.field(
            "identity_validation_expression",
            &self.identity_validation_expression,
        );
        formatter.field("jwt_configuration", &self.jwt_configuration);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`Authorizer`](crate::model::Authorizer)
pub mod authorizer {
    /// A builder for [`Authorizer`](crate::model::Authorizer)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authorizer_credentials_arn: std::option::Option<std::string::String>,
        pub(crate) authorizer_id: std::option::Option<std::string::String>,
        pub(crate) authorizer_payload_format_version: std::option::Option<std::string::String>,
        pub(crate) authorizer_result_ttl_in_seconds: std::option::Option<i32>,
        pub(crate) authorizer_type: std::option::Option<crate::model::AuthorizerType>,
        pub(crate) authorizer_uri: std::option::Option<std::string::String>,
        pub(crate) enable_simple_responses: std::option::Option<bool>,
        pub(crate) identity_source: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) identity_validation_expression: std::option::Option<std::string::String>,
        pub(crate) jwt_configuration: std::option::Option<crate::model::JwtConfiguration>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, don't specify this parameter. Supported only for REQUEST authorizers.</p>
        pub fn authorizer_credentials_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorizer_credentials_arn = Some(input.into());
            self
        }
        /// <p>Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, don't specify this parameter. Supported only for REQUEST authorizers.</p>
        pub fn set_authorizer_credentials_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorizer_credentials_arn = input;
            self
        }
        /// <p>The authorizer identifier.</p>
        pub fn authorizer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorizer_id = Some(input.into());
            self
        }
        /// <p>The authorizer identifier.</p>
        pub fn set_authorizer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorizer_id = input;
            self
        }
        /// <p>Specifies the format of the payload sent to an HTTP API Lambda authorizer. Required for HTTP API Lambda authorizers. Supported values are 1.0 and 2.0. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p>
        pub fn authorizer_payload_format_version(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.authorizer_payload_format_version = Some(input.into());
            self
        }
        /// <p>Specifies the format of the payload sent to an HTTP API Lambda authorizer. Required for HTTP API Lambda authorizers. Supported values are 1.0 and 2.0. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p>
        pub fn set_authorizer_payload_format_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorizer_payload_format_version = input;
            self
        }
        /// <p>The time to live (TTL) for cached authorizer results, in seconds. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway caches authorizer responses. The maximum value is 3600, or 1 hour. Supported only for HTTP API Lambda authorizers.</p>
        pub fn authorizer_result_ttl_in_seconds(mut self, input: i32) -> Self {
            self.authorizer_result_ttl_in_seconds = Some(input);
            self
        }
        /// <p>The time to live (TTL) for cached authorizer results, in seconds. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway caches authorizer responses. The maximum value is 3600, or 1 hour. Supported only for HTTP API Lambda authorizers.</p>
        pub fn set_authorizer_result_ttl_in_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.authorizer_result_ttl_in_seconds = input;
            self
        }
        /// <p>The authorizer type. Specify REQUEST for a Lambda function using incoming request parameters. Specify JWT to use JSON Web Tokens (supported only for HTTP APIs).</p>
        pub fn authorizer_type(mut self, input: crate::model::AuthorizerType) -> Self {
            self.authorizer_type = Some(input);
            self
        }
        /// <p>The authorizer type. Specify REQUEST for a Lambda function using incoming request parameters. Specify JWT to use JSON Web Tokens (supported only for HTTP APIs).</p>
        pub fn set_authorizer_type(
            mut self,
            input: std::option::Option<crate::model::AuthorizerType>,
        ) -> Self {
            self.authorizer_type = input;
            self
        }
        /// <p>The authorizer's Uniform Resource Identifier (URI). For REQUEST authorizers, this must be a well-formed Lambda function URI, for example, arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:<replaceable>{account_id}</replaceable>:function:<replaceable>{lambda_function_name}</replaceable>/invocations. In general, the URI has this form: arn:aws:apigateway:<replaceable>{region}</replaceable>:lambda:path/<replaceable>{service_api}</replaceable>
        /// , where <replaceable></replaceable>{region} is the same as the region hosting the Lambda function, path indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial /. For Lambda functions, this is usually of the form /2015-03-31/functions/[FunctionARN]/invocations. Supported only for REQUEST authorizers.</p>
        pub fn authorizer_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorizer_uri = Some(input.into());
            self
        }
        /// <p>The authorizer's Uniform Resource Identifier (URI). For REQUEST authorizers, this must be a well-formed Lambda function URI, for example, arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:<replaceable>{account_id}</replaceable>:function:<replaceable>{lambda_function_name}</replaceable>/invocations. In general, the URI has this form: arn:aws:apigateway:<replaceable>{region}</replaceable>:lambda:path/<replaceable>{service_api}</replaceable>
        /// , where <replaceable></replaceable>{region} is the same as the region hosting the Lambda function, path indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial /. For Lambda functions, this is usually of the form /2015-03-31/functions/[FunctionARN]/invocations. Supported only for REQUEST authorizers.</p>
        pub fn set_authorizer_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorizer_uri = input;
            self
        }
        /// <p>Specifies whether a Lambda authorizer returns a response in a simple format. If enabled, the Lambda authorizer can return a boolean value instead of an IAM policy. Supported only for HTTP APIs. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a></p>
        pub fn enable_simple_responses(mut self, input: bool) -> Self {
            self.enable_simple_responses = Some(input);
            self
        }
        /// <p>Specifies whether a Lambda authorizer returns a response in a simple format. If enabled, the Lambda authorizer can return a boolean value instead of an IAM policy. Supported only for HTTP APIs. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a></p>
        pub fn set_enable_simple_responses(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_simple_responses = input;
            self
        }
        /// Appends an item to `identity_source`.
        ///
        /// To override the contents of this collection use [`set_identity_source`](Self::set_identity_source).
        ///
        /// <p>The identity source for which authorization is requested.</p> <p>For a REQUEST authorizer, this is optional. The value is a set of one or more mapping expressions of the specified request parameters. The identity source can be headers, query string parameters, stage variables, and context parameters. For example, if an Auth header and a Name query string parameter are defined as identity sources, this value is route.request.header.Auth, route.request.querystring.Name for WebSocket APIs. For HTTP APIs, use selection expressions prefixed with $, for example, $request.header.Auth, $request.querystring.Name. These parameters are used to perform runtime validation for Lambda-based authorizers by verifying all of the identity-related request parameters are present in the request, not null, and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function. Otherwise, it returns a 401 Unauthorized response without calling the Lambda function. For HTTP APIs, identity sources are also used as the cache key when caching is enabled. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p> <p>For JWT, a single entry that specifies where to extract the JSON Web Token (JWT) from inbound requests. Currently only header-based and query parameter-based selections are supported, for example $request.header.Authorization.</p>
        pub fn identity_source(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.identity_source.unwrap_or_default();
            v.push(input.into());
            self.identity_source = Some(v);
            self
        }
        /// <p>The identity source for which authorization is requested.</p> <p>For a REQUEST authorizer, this is optional. The value is a set of one or more mapping expressions of the specified request parameters. The identity source can be headers, query string parameters, stage variables, and context parameters. For example, if an Auth header and a Name query string parameter are defined as identity sources, this value is route.request.header.Auth, route.request.querystring.Name for WebSocket APIs. For HTTP APIs, use selection expressions prefixed with $, for example, $request.header.Auth, $request.querystring.Name. These parameters are used to perform runtime validation for Lambda-based authorizers by verifying all of the identity-related request parameters are present in the request, not null, and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function. Otherwise, it returns a 401 Unauthorized response without calling the Lambda function. For HTTP APIs, identity sources are also used as the cache key when caching is enabled. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p> <p>For JWT, a single entry that specifies where to extract the JSON Web Token (JWT) from inbound requests. Currently only header-based and query parameter-based selections are supported, for example $request.header.Authorization.</p>
        pub fn set_identity_source(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.identity_source = input;
            self
        }
        /// <p>The validation expression does not apply to the REQUEST authorizer.</p>
        pub fn identity_validation_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.identity_validation_expression = Some(input.into());
            self
        }
        /// <p>The validation expression does not apply to the REQUEST authorizer.</p>
        pub fn set_identity_validation_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_validation_expression = input;
            self
        }
        /// <p>Represents the configuration of a JWT authorizer. Required for the JWT authorizer type. Supported only for HTTP APIs.</p>
        pub fn jwt_configuration(mut self, input: crate::model::JwtConfiguration) -> Self {
            self.jwt_configuration = Some(input);
            self
        }
        /// <p>Represents the configuration of a JWT authorizer. Required for the JWT authorizer type. Supported only for HTTP APIs.</p>
        pub fn set_jwt_configuration(
            mut self,
            input: std::option::Option<crate::model::JwtConfiguration>,
        ) -> Self {
            self.jwt_configuration = input;
            self
        }
        /// <p>The name of the authorizer.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the authorizer.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`Authorizer`](crate::model::Authorizer)
        pub fn build(self) -> crate::model::Authorizer {
            crate::model::Authorizer {
                authorizer_credentials_arn: self.authorizer_credentials_arn,
                authorizer_id: self.authorizer_id,
                authorizer_payload_format_version: self.authorizer_payload_format_version,
                authorizer_result_ttl_in_seconds: self
                    .authorizer_result_ttl_in_seconds
                    .unwrap_or_default(),
                authorizer_type: self.authorizer_type,
                authorizer_uri: self.authorizer_uri,
                enable_simple_responses: self.enable_simple_responses.unwrap_or_default(),
                identity_source: self.identity_source,
                identity_validation_expression: self.identity_validation_expression,
                jwt_configuration: self.jwt_configuration,
                name: self.name,
            }
        }
    }
}
impl Authorizer {
    /// Creates a new builder-style object to manufacture [`Authorizer`](crate::model::Authorizer)
    pub fn builder() -> crate::model::authorizer::Builder {
        crate::model::authorizer::Builder::default()
    }
}

/// <p>Represents an API.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Api {
    /// <p>The URI of the API, of the form {api-id}.execute-api.{region}.amazonaws.com. The stage name is typically appended to this URI to form a complete path to a deployed API stage.</p>
    pub api_endpoint: std::option::Option<std::string::String>,
    /// <p>Specifies whether an API is managed by API Gateway. You can't update or delete a managed API by using API Gateway. A managed API can be deleted only through the tooling or service that created it.</p>
    pub api_gateway_managed: bool,
    /// <p>The API ID.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>An API key selection expression. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions">API Key Selection Expressions</a>.</p>
    pub api_key_selection_expression: std::option::Option<std::string::String>,
    /// <p>A CORS configuration. Supported only for HTTP APIs.</p>
    pub cors_configuration: std::option::Option<crate::model::Cors>,
    /// <p>The timestamp when the API was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The description of the API.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Avoid validating models when creating a deployment. Supported only for WebSocket APIs.</p>
    pub disable_schema_validation: bool,
    /// <p>Specifies whether clients can invoke your API by using the default execute-api endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
    pub disable_execute_api_endpoint: bool,
    /// <p>The validation information during API import. This may include particular properties of your OpenAPI definition which are ignored during import. Supported only for HTTP APIs.</p>
    pub import_info: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The name of the API.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The API protocol.</p>
    pub protocol_type: std::option::Option<crate::model::ProtocolType>,
    /// <p>The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.</p>
    pub route_selection_expression: std::option::Option<std::string::String>,
    /// <p>A collection of tags associated with the API.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A version identifier for the API.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>The warning messages reported when failonwarnings is turned on during API import.</p>
    pub warnings: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl Api {
    /// <p>The URI of the API, of the form {api-id}.execute-api.{region}.amazonaws.com. The stage name is typically appended to this URI to form a complete path to a deployed API stage.</p>
    pub fn api_endpoint(&self) -> std::option::Option<&str> {
        self.api_endpoint.as_deref()
    }
    /// <p>Specifies whether an API is managed by API Gateway. You can't update or delete a managed API by using API Gateway. A managed API can be deleted only through the tooling or service that created it.</p>
    pub fn api_gateway_managed(&self) -> bool {
        self.api_gateway_managed
    }
    /// <p>The API ID.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>An API key selection expression. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions">API Key Selection Expressions</a>.</p>
    pub fn api_key_selection_expression(&self) -> std::option::Option<&str> {
        self.api_key_selection_expression.as_deref()
    }
    /// <p>A CORS configuration. Supported only for HTTP APIs.</p>
    pub fn cors_configuration(&self) -> std::option::Option<&crate::model::Cors> {
        self.cors_configuration.as_ref()
    }
    /// <p>The timestamp when the API was created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_date.as_ref()
    }
    /// <p>The description of the API.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Avoid validating models when creating a deployment. Supported only for WebSocket APIs.</p>
    pub fn disable_schema_validation(&self) -> bool {
        self.disable_schema_validation
    }
    /// <p>Specifies whether clients can invoke your API by using the default execute-api endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
    pub fn disable_execute_api_endpoint(&self) -> bool {
        self.disable_execute_api_endpoint
    }
    /// <p>The validation information during API import. This may include particular properties of your OpenAPI definition which are ignored during import. Supported only for HTTP APIs.</p>
    pub fn import_info(&self) -> std::option::Option<&[std::string::String]> {
        self.import_info.as_deref()
    }
    /// <p>The name of the API.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The API protocol.</p>
    pub fn protocol_type(&self) -> std::option::Option<&crate::model::ProtocolType> {
        self.protocol_type.as_ref()
    }
    /// <p>The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.</p>
    pub fn route_selection_expression(&self) -> std::option::Option<&str> {
        self.route_selection_expression.as_deref()
    }
    /// <p>A collection of tags associated with the API.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>A version identifier for the API.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>The warning messages reported when failonwarnings is turned on during API import.</p>
    pub fn warnings(&self) -> std::option::Option<&[std::string::String]> {
        self.warnings.as_deref()
    }
}
impl std::fmt::Debug for Api {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Api");
        formatter.field("api_endpoint", &self.api_endpoint);
        formatter.field("api_gateway_managed", &self.api_gateway_managed);
        formatter.field("api_id", &self.api_id);
        formatter.field(
            "api_key_selection_expression",
            &self.api_key_selection_expression,
        );
        formatter.field("cors_configuration", &self.cors_configuration);
        formatter.field("created_date", &self.created_date);
        formatter.field("description", &self.description);
        formatter.field("disable_schema_validation", &self.disable_schema_validation);
        formatter.field(
            "disable_execute_api_endpoint",
            &self.disable_execute_api_endpoint,
        );
        formatter.field("import_info", &self.import_info);
        formatter.field("name", &self.name);
        formatter.field("protocol_type", &self.protocol_type);
        formatter.field(
            "route_selection_expression",
            &self.route_selection_expression,
        );
        formatter.field("tags", &self.tags);
        formatter.field("version", &self.version);
        formatter.field("warnings", &self.warnings);
        formatter.finish()
    }
}
/// See [`Api`](crate::model::Api)
pub mod api {
    /// A builder for [`Api`](crate::model::Api)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_endpoint: std::option::Option<std::string::String>,
        pub(crate) api_gateway_managed: std::option::Option<bool>,
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) api_key_selection_expression: std::option::Option<std::string::String>,
        pub(crate) cors_configuration: std::option::Option<crate::model::Cors>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) disable_schema_validation: std::option::Option<bool>,
        pub(crate) disable_execute_api_endpoint: std::option::Option<bool>,
        pub(crate) import_info: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) protocol_type: std::option::Option<crate::model::ProtocolType>,
        pub(crate) route_selection_expression: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) warnings: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The URI of the API, of the form {api-id}.execute-api.{region}.amazonaws.com. The stage name is typically appended to this URI to form a complete path to a deployed API stage.</p>
        pub fn api_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_endpoint = Some(input.into());
            self
        }
        /// <p>The URI of the API, of the form {api-id}.execute-api.{region}.amazonaws.com. The stage name is typically appended to this URI to form a complete path to a deployed API stage.</p>
        pub fn set_api_endpoint(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_endpoint = input;
            self
        }
        /// <p>Specifies whether an API is managed by API Gateway. You can't update or delete a managed API by using API Gateway. A managed API can be deleted only through the tooling or service that created it.</p>
        pub fn api_gateway_managed(mut self, input: bool) -> Self {
            self.api_gateway_managed = Some(input);
            self
        }
        /// <p>Specifies whether an API is managed by API Gateway. You can't update or delete a managed API by using API Gateway. A managed API can be deleted only through the tooling or service that created it.</p>
        pub fn set_api_gateway_managed(mut self, input: std::option::Option<bool>) -> Self {
            self.api_gateway_managed = input;
            self
        }
        /// <p>The API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>An API key selection expression. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions">API Key Selection Expressions</a>.</p>
        pub fn api_key_selection_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.api_key_selection_expression = Some(input.into());
            self
        }
        /// <p>An API key selection expression. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions">API Key Selection Expressions</a>.</p>
        pub fn set_api_key_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.api_key_selection_expression = input;
            self
        }
        /// <p>A CORS configuration. Supported only for HTTP APIs.</p>
        pub fn cors_configuration(mut self, input: crate::model::Cors) -> Self {
            self.cors_configuration = Some(input);
            self
        }
        /// <p>A CORS configuration. Supported only for HTTP APIs.</p>
        pub fn set_cors_configuration(
            mut self,
            input: std::option::Option<crate::model::Cors>,
        ) -> Self {
            self.cors_configuration = input;
            self
        }
        /// <p>The timestamp when the API was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The timestamp when the API was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>The description of the API.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the API.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Avoid validating models when creating a deployment. Supported only for WebSocket APIs.</p>
        pub fn disable_schema_validation(mut self, input: bool) -> Self {
            self.disable_schema_validation = Some(input);
            self
        }
        /// <p>Avoid validating models when creating a deployment. Supported only for WebSocket APIs.</p>
        pub fn set_disable_schema_validation(mut self, input: std::option::Option<bool>) -> Self {
            self.disable_schema_validation = input;
            self
        }
        /// <p>Specifies whether clients can invoke your API by using the default execute-api endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
        pub fn disable_execute_api_endpoint(mut self, input: bool) -> Self {
            self.disable_execute_api_endpoint = Some(input);
            self
        }
        /// <p>Specifies whether clients can invoke your API by using the default execute-api endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
        pub fn set_disable_execute_api_endpoint(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.disable_execute_api_endpoint = input;
            self
        }
        /// Appends an item to `import_info`.
        ///
        /// To override the contents of this collection use [`set_import_info`](Self::set_import_info).
        ///
        /// <p>The validation information during API import. This may include particular properties of your OpenAPI definition which are ignored during import. Supported only for HTTP APIs.</p>
        pub fn import_info(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.import_info.unwrap_or_default();
            v.push(input.into());
            self.import_info = Some(v);
            self
        }
        /// <p>The validation information during API import. This may include particular properties of your OpenAPI definition which are ignored during import. Supported only for HTTP APIs.</p>
        pub fn set_import_info(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.import_info = input;
            self
        }
        /// <p>The name of the API.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the API.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The API protocol.</p>
        pub fn protocol_type(mut self, input: crate::model::ProtocolType) -> Self {
            self.protocol_type = Some(input);
            self
        }
        /// <p>The API protocol.</p>
        pub fn set_protocol_type(
            mut self,
            input: std::option::Option<crate::model::ProtocolType>,
        ) -> Self {
            self.protocol_type = input;
            self
        }
        /// <p>The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.</p>
        pub fn route_selection_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_selection_expression = Some(input.into());
            self
        }
        /// <p>The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.</p>
        pub fn set_route_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.route_selection_expression = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of tags associated with the API.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A collection of tags associated with the API.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>A version identifier for the API.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>A version identifier for the API.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Appends an item to `warnings`.
        ///
        /// To override the contents of this collection use [`set_warnings`](Self::set_warnings).
        ///
        /// <p>The warning messages reported when failonwarnings is turned on during API import.</p>
        pub fn warnings(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.warnings.unwrap_or_default();
            v.push(input.into());
            self.warnings = Some(v);
            self
        }
        /// <p>The warning messages reported when failonwarnings is turned on during API import.</p>
        pub fn set_warnings(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.warnings = input;
            self
        }
        /// Consumes the builder and constructs a [`Api`](crate::model::Api)
        pub fn build(self) -> crate::model::Api {
            crate::model::Api {
                api_endpoint: self.api_endpoint,
                api_gateway_managed: self.api_gateway_managed.unwrap_or_default(),
                api_id: self.api_id,
                api_key_selection_expression: self.api_key_selection_expression,
                cors_configuration: self.cors_configuration,
                created_date: self.created_date,
                description: self.description,
                disable_schema_validation: self.disable_schema_validation.unwrap_or_default(),
                disable_execute_api_endpoint: self.disable_execute_api_endpoint.unwrap_or_default(),
                import_info: self.import_info,
                name: self.name,
                protocol_type: self.protocol_type,
                route_selection_expression: self.route_selection_expression,
                tags: self.tags,
                version: self.version,
                warnings: self.warnings,
            }
        }
    }
}
impl Api {
    /// Creates a new builder-style object to manufacture [`Api`](crate::model::Api)
    pub fn builder() -> crate::model::api::Builder {
        crate::model::api::Builder::default()
    }
}

/// <p>Represents an API mapping.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApiMapping {
    /// <p>The API identifier.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The API mapping identifier.</p>
    pub api_mapping_id: std::option::Option<std::string::String>,
    /// <p>The API mapping key.</p>
    pub api_mapping_key: std::option::Option<std::string::String>,
    /// <p>The API stage.</p>
    pub stage: std::option::Option<std::string::String>,
}
impl ApiMapping {
    /// <p>The API identifier.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The API mapping identifier.</p>
    pub fn api_mapping_id(&self) -> std::option::Option<&str> {
        self.api_mapping_id.as_deref()
    }
    /// <p>The API mapping key.</p>
    pub fn api_mapping_key(&self) -> std::option::Option<&str> {
        self.api_mapping_key.as_deref()
    }
    /// <p>The API stage.</p>
    pub fn stage(&self) -> std::option::Option<&str> {
        self.stage.as_deref()
    }
}
impl std::fmt::Debug for ApiMapping {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApiMapping");
        formatter.field("api_id", &self.api_id);
        formatter.field("api_mapping_id", &self.api_mapping_id);
        formatter.field("api_mapping_key", &self.api_mapping_key);
        formatter.field("stage", &self.stage);
        formatter.finish()
    }
}
/// See [`ApiMapping`](crate::model::ApiMapping)
pub mod api_mapping {
    /// A builder for [`ApiMapping`](crate::model::ApiMapping)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) api_mapping_id: std::option::Option<std::string::String>,
        pub(crate) api_mapping_key: std::option::Option<std::string::String>,
        pub(crate) stage: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The API mapping identifier.</p>
        pub fn api_mapping_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_mapping_id = Some(input.into());
            self
        }
        /// <p>The API mapping identifier.</p>
        pub fn set_api_mapping_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.api_mapping_id = input;
            self
        }
        /// <p>The API mapping key.</p>
        pub fn api_mapping_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_mapping_key = Some(input.into());
            self
        }
        /// <p>The API mapping key.</p>
        pub fn set_api_mapping_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.api_mapping_key = input;
            self
        }
        /// <p>The API stage.</p>
        pub fn stage(mut self, input: impl Into<std::string::String>) -> Self {
            self.stage = Some(input.into());
            self
        }
        /// <p>The API stage.</p>
        pub fn set_stage(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stage = input;
            self
        }
        /// Consumes the builder and constructs a [`ApiMapping`](crate::model::ApiMapping)
        pub fn build(self) -> crate::model::ApiMapping {
            crate::model::ApiMapping {
                api_id: self.api_id,
                api_mapping_id: self.api_mapping_id,
                api_mapping_key: self.api_mapping_key,
                stage: self.stage,
            }
        }
    }
}
impl ApiMapping {
    /// Creates a new builder-style object to manufacture [`ApiMapping`](crate::model::ApiMapping)
    pub fn builder() -> crate::model::api_mapping::Builder {
        crate::model::api_mapping::Builder::default()
    }
}
