// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CreateApiInput`](crate::input::CreateApiInput)
pub mod create_api_input {
    /// A builder for [`CreateApiInput`](crate::input::CreateApiInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_key_selection_expression: std::option::Option<std::string::String>,
        pub(crate) cors_configuration: std::option::Option<crate::model::Cors>,
        pub(crate) credentials_arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) disable_schema_validation: std::option::Option<bool>,
        pub(crate) disable_execute_api_endpoint: std::option::Option<bool>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) protocol_type: std::option::Option<crate::model::ProtocolType>,
        pub(crate) route_key: std::option::Option<std::string::String>,
        pub(crate) route_selection_expression: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) target: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An API key selection expression. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions">API Key Selection Expressions</a>.</p>
        pub fn api_key_selection_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.api_key_selection_expression = Some(input.into());
            self
        }
        /// <p>An API key selection expression. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions">API Key Selection Expressions</a>.</p>
        pub fn set_api_key_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.api_key_selection_expression = input;
            self
        }
        /// <p>A CORS configuration. Supported only for HTTP APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-cors.html">Configuring CORS</a> for more information.</p>
        pub fn cors_configuration(mut self, input: crate::model::Cors) -> Self {
            self.cors_configuration = Some(input);
            self
        }
        /// <p>A CORS configuration. Supported only for HTTP APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-cors.html">Configuring CORS</a> for more information.</p>
        pub fn set_cors_configuration(
            mut self,
            input: std::option::Option<crate::model::Cors>,
        ) -> Self {
            self.cors_configuration = input;
            self
        }
        /// <p>This property is part of quick create. It specifies the credentials required for the integration, if any. For a Lambda integration, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, specify null. Currently, this property is not used for HTTP integrations. Supported only for HTTP APIs.</p>
        pub fn credentials_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.credentials_arn = Some(input.into());
            self
        }
        /// <p>This property is part of quick create. It specifies the credentials required for the integration, if any. For a Lambda integration, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, specify null. Currently, this property is not used for HTTP integrations. Supported only for HTTP APIs.</p>
        pub fn set_credentials_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.credentials_arn = input;
            self
        }
        /// <p>The description of the API.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the API.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Avoid validating models when creating a deployment. Supported only for WebSocket APIs.</p>
        pub fn disable_schema_validation(mut self, input: bool) -> Self {
            self.disable_schema_validation = Some(input);
            self
        }
        /// <p>Avoid validating models when creating a deployment. Supported only for WebSocket APIs.</p>
        pub fn set_disable_schema_validation(mut self, input: std::option::Option<bool>) -> Self {
            self.disable_schema_validation = input;
            self
        }
        /// <p>Specifies whether clients can invoke your API by using the default execute-api endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
        pub fn disable_execute_api_endpoint(mut self, input: bool) -> Self {
            self.disable_execute_api_endpoint = Some(input);
            self
        }
        /// <p>Specifies whether clients can invoke your API by using the default execute-api endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
        pub fn set_disable_execute_api_endpoint(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.disable_execute_api_endpoint = input;
            self
        }
        /// <p>The name of the API.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the API.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The API protocol.</p>
        pub fn protocol_type(mut self, input: crate::model::ProtocolType) -> Self {
            self.protocol_type = Some(input);
            self
        }
        /// <p>The API protocol.</p>
        pub fn set_protocol_type(
            mut self,
            input: std::option::Option<crate::model::ProtocolType>,
        ) -> Self {
            self.protocol_type = input;
            self
        }
        /// <p>This property is part of quick create. If you don't specify a routeKey, a default route of $default is created. The $default route acts as a catch-all for any request made to your API, for a particular stage. The $default route key can't be modified. You can add routes after creating the API, and you can update the route keys of additional routes. Supported only for HTTP APIs.</p>
        pub fn route_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_key = Some(input.into());
            self
        }
        /// <p>This property is part of quick create. If you don't specify a routeKey, a default route of $default is created. The $default route acts as a catch-all for any request made to your API, for a particular stage. The $default route key can't be modified. You can add routes after creating the API, and you can update the route keys of additional routes. Supported only for HTTP APIs.</p>
        pub fn set_route_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.route_key = input;
            self
        }
        /// <p>The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.</p>
        pub fn route_selection_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_selection_expression = Some(input.into());
            self
        }
        /// <p>The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.</p>
        pub fn set_route_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.route_selection_expression = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>This property is part of quick create. Quick create produces an API with an integration, a default catch-all route, and a default stage which is configured to automatically deploy changes. For HTTP integrations, specify a fully qualified URL. For Lambda integrations, specify a function ARN. The type of the integration will be HTTP_PROXY or AWS_PROXY, respectively. Supported only for HTTP APIs.</p>
        pub fn target(mut self, input: impl Into<std::string::String>) -> Self {
            self.target = Some(input.into());
            self
        }
        /// <p>This property is part of quick create. Quick create produces an API with an integration, a default catch-all route, and a default stage which is configured to automatically deploy changes. For HTTP integrations, specify a fully qualified URL. For Lambda integrations, specify a function ARN. The type of the integration will be HTTP_PROXY or AWS_PROXY, respectively. Supported only for HTTP APIs.</p>
        pub fn set_target(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target = input;
            self
        }
        /// <p>A version identifier for the API.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>A version identifier for the API.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateApiInput`](crate::input::CreateApiInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::CreateApiInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::CreateApiInput {
                api_key_selection_expression: self.api_key_selection_expression,
                cors_configuration: self.cors_configuration,
                credentials_arn: self.credentials_arn,
                description: self.description,
                disable_schema_validation: self.disable_schema_validation.unwrap_or_default(),
                disable_execute_api_endpoint: self.disable_execute_api_endpoint.unwrap_or_default(),
                name: self.name,
                protocol_type: self.protocol_type,
                route_key: self.route_key,
                route_selection_expression: self.route_selection_expression,
                tags: self.tags,
                target: self.target,
                version: self.version,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateApiInputOperationOutputAlias = crate::operation::CreateApi;
#[doc(hidden)]
pub type CreateApiInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateApiInput {
    /// Consumes the builder and constructs an Operation<[`CreateApi`](crate::operation::CreateApi)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateApi,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateApiInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/v2/apis").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateApiInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_api(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::CreateApi::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "CreateApi",
                    "apigatewayv2",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateApiInput`](crate::input::CreateApiInput)
    pub fn builder() -> crate::input::create_api_input::Builder {
        crate::input::create_api_input::Builder::default()
    }
}

/// See [`CreateApiMappingInput`](crate::input::CreateApiMappingInput)
pub mod create_api_mapping_input {
    /// A builder for [`CreateApiMappingInput`](crate::input::CreateApiMappingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) api_mapping_key: std::option::Option<std::string::String>,
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) stage: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// The API mapping key.
        pub fn api_mapping_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_mapping_key = Some(input.into());
            self
        }
        /// The API mapping key.
        pub fn set_api_mapping_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.api_mapping_key = input;
            self
        }
        /// <p>The domain name.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The domain name.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The API stage.</p>
        pub fn stage(mut self, input: impl Into<std::string::String>) -> Self {
            self.stage = Some(input.into());
            self
        }
        /// <p>The API stage.</p>
        pub fn set_stage(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stage = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateApiMappingInput`](crate::input::CreateApiMappingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateApiMappingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateApiMappingInput {
                api_id: self.api_id,
                api_mapping_key: self.api_mapping_key,
                domain_name: self.domain_name,
                stage: self.stage,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateApiMappingInputOperationOutputAlias = crate::operation::CreateApiMapping;
#[doc(hidden)]
pub type CreateApiMappingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateApiMappingInput {
    /// Consumes the builder and constructs an Operation<[`CreateApiMapping`](crate::operation::CreateApiMapping)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateApiMapping,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateApiMappingInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_1 = &_input.domain_name;
                let input_1 = input_1.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_1, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/domainnames/{DomainName}/apimappings",
                    DomainName = domain_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateApiMappingInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_api_mapping(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateApiMapping::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateApiMapping",
            "apigatewayv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateApiMappingInput`](crate::input::CreateApiMappingInput)
    pub fn builder() -> crate::input::create_api_mapping_input::Builder {
        crate::input::create_api_mapping_input::Builder::default()
    }
}

/// See [`CreateAuthorizerInput`](crate::input::CreateAuthorizerInput)
pub mod create_authorizer_input {
    /// A builder for [`CreateAuthorizerInput`](crate::input::CreateAuthorizerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) authorizer_credentials_arn: std::option::Option<std::string::String>,
        pub(crate) authorizer_payload_format_version: std::option::Option<std::string::String>,
        pub(crate) authorizer_result_ttl_in_seconds: std::option::Option<i32>,
        pub(crate) authorizer_type: std::option::Option<crate::model::AuthorizerType>,
        pub(crate) authorizer_uri: std::option::Option<std::string::String>,
        pub(crate) enable_simple_responses: std::option::Option<bool>,
        pub(crate) identity_source: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) identity_validation_expression: std::option::Option<std::string::String>,
        pub(crate) jwt_configuration: std::option::Option<crate::model::JwtConfiguration>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, don't specify this parameter. Supported only for REQUEST authorizers.</p>
        pub fn authorizer_credentials_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorizer_credentials_arn = Some(input.into());
            self
        }
        /// <p>Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, don't specify this parameter. Supported only for REQUEST authorizers.</p>
        pub fn set_authorizer_credentials_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorizer_credentials_arn = input;
            self
        }
        /// <p>Specifies the format of the payload sent to an HTTP API Lambda authorizer. Required for HTTP API Lambda authorizers. Supported values are 1.0 and 2.0. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p>
        pub fn authorizer_payload_format_version(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.authorizer_payload_format_version = Some(input.into());
            self
        }
        /// <p>Specifies the format of the payload sent to an HTTP API Lambda authorizer. Required for HTTP API Lambda authorizers. Supported values are 1.0 and 2.0. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p>
        pub fn set_authorizer_payload_format_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorizer_payload_format_version = input;
            self
        }
        /// <p>The time to live (TTL) for cached authorizer results, in seconds. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway caches authorizer responses. The maximum value is 3600, or 1 hour. Supported only for HTTP API Lambda authorizers.</p>
        pub fn authorizer_result_ttl_in_seconds(mut self, input: i32) -> Self {
            self.authorizer_result_ttl_in_seconds = Some(input);
            self
        }
        /// <p>The time to live (TTL) for cached authorizer results, in seconds. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway caches authorizer responses. The maximum value is 3600, or 1 hour. Supported only for HTTP API Lambda authorizers.</p>
        pub fn set_authorizer_result_ttl_in_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.authorizer_result_ttl_in_seconds = input;
            self
        }
        /// <p>The authorizer type. Specify REQUEST for a Lambda function using incoming request parameters. Specify JWT to use JSON Web Tokens (supported only for HTTP APIs).</p>
        pub fn authorizer_type(mut self, input: crate::model::AuthorizerType) -> Self {
            self.authorizer_type = Some(input);
            self
        }
        /// <p>The authorizer type. Specify REQUEST for a Lambda function using incoming request parameters. Specify JWT to use JSON Web Tokens (supported only for HTTP APIs).</p>
        pub fn set_authorizer_type(
            mut self,
            input: std::option::Option<crate::model::AuthorizerType>,
        ) -> Self {
            self.authorizer_type = input;
            self
        }
        /// <p>The authorizer's Uniform Resource Identifier (URI). For REQUEST authorizers, this must be a well-formed Lambda function URI, for example, arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:<replaceable>
        /// {account_id}
        /// </replaceable>:function:<replaceable>
        /// {lambda_function_name}
        /// </replaceable>/invocations. In general, the URI has this form: arn:aws:apigateway:<replaceable>
        /// {region}
        /// </replaceable>:lambda:path/<replaceable>
        /// {service_api}
        /// </replaceable> , where <replaceable></replaceable>{region} is the same as the region hosting the Lambda function, path indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial /. For Lambda functions, this is usually of the form /2015-03-31/functions/[FunctionARN]/invocations. Supported only for REQUEST authorizers.</p>
        pub fn authorizer_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorizer_uri = Some(input.into());
            self
        }
        /// <p>The authorizer's Uniform Resource Identifier (URI). For REQUEST authorizers, this must be a well-formed Lambda function URI, for example, arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:<replaceable>
        /// {account_id}
        /// </replaceable>:function:<replaceable>
        /// {lambda_function_name}
        /// </replaceable>/invocations. In general, the URI has this form: arn:aws:apigateway:<replaceable>
        /// {region}
        /// </replaceable>:lambda:path/<replaceable>
        /// {service_api}
        /// </replaceable> , where <replaceable></replaceable>{region} is the same as the region hosting the Lambda function, path indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial /. For Lambda functions, this is usually of the form /2015-03-31/functions/[FunctionARN]/invocations. Supported only for REQUEST authorizers.</p>
        pub fn set_authorizer_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorizer_uri = input;
            self
        }
        /// <p>Specifies whether a Lambda authorizer returns a response in a simple format. By default, a Lambda authorizer must return an IAM policy. If enabled, the Lambda authorizer can return a boolean value instead of an IAM policy. Supported only for HTTP APIs. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a></p>
        pub fn enable_simple_responses(mut self, input: bool) -> Self {
            self.enable_simple_responses = Some(input);
            self
        }
        /// <p>Specifies whether a Lambda authorizer returns a response in a simple format. By default, a Lambda authorizer must return an IAM policy. If enabled, the Lambda authorizer can return a boolean value instead of an IAM policy. Supported only for HTTP APIs. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a></p>
        pub fn set_enable_simple_responses(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_simple_responses = input;
            self
        }
        /// Appends an item to `identity_source`.
        ///
        /// To override the contents of this collection use [`set_identity_source`](Self::set_identity_source).
        ///
        /// <p>The identity source for which authorization is requested.</p>
        /// <p>For a REQUEST authorizer, this is optional. The value is a set of one or more mapping expressions of the specified request parameters. The identity source can be headers, query string parameters, stage variables, and context parameters. For example, if an Auth header and a Name query string parameter are defined as identity sources, this value is route.request.header.Auth, route.request.querystring.Name for WebSocket APIs. For HTTP APIs, use selection expressions prefixed with $, for example, $request.header.Auth, $request.querystring.Name. These parameters are used to perform runtime validation for Lambda-based authorizers by verifying all of the identity-related request parameters are present in the request, not null, and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function. Otherwise, it returns a 401 Unauthorized response without calling the Lambda function. For HTTP APIs, identity sources are also used as the cache key when caching is enabled. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p>
        /// <p>For JWT, a single entry that specifies where to extract the JSON Web Token (JWT) from inbound requests. Currently only header-based and query parameter-based selections are supported, for example $request.header.Authorization.</p>
        pub fn identity_source(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.identity_source.unwrap_or_default();
            v.push(input.into());
            self.identity_source = Some(v);
            self
        }
        /// <p>The identity source for which authorization is requested.</p>
        /// <p>For a REQUEST authorizer, this is optional. The value is a set of one or more mapping expressions of the specified request parameters. The identity source can be headers, query string parameters, stage variables, and context parameters. For example, if an Auth header and a Name query string parameter are defined as identity sources, this value is route.request.header.Auth, route.request.querystring.Name for WebSocket APIs. For HTTP APIs, use selection expressions prefixed with $, for example, $request.header.Auth, $request.querystring.Name. These parameters are used to perform runtime validation for Lambda-based authorizers by verifying all of the identity-related request parameters are present in the request, not null, and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function. Otherwise, it returns a 401 Unauthorized response without calling the Lambda function. For HTTP APIs, identity sources are also used as the cache key when caching is enabled. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p>
        /// <p>For JWT, a single entry that specifies where to extract the JSON Web Token (JWT) from inbound requests. Currently only header-based and query parameter-based selections are supported, for example $request.header.Authorization.</p>
        pub fn set_identity_source(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.identity_source = input;
            self
        }
        /// <p>This parameter is not used.</p>
        pub fn identity_validation_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.identity_validation_expression = Some(input.into());
            self
        }
        /// <p>This parameter is not used.</p>
        pub fn set_identity_validation_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_validation_expression = input;
            self
        }
        /// <p>Represents the configuration of a JWT authorizer. Required for the JWT authorizer type. Supported only for HTTP APIs.</p>
        pub fn jwt_configuration(mut self, input: crate::model::JwtConfiguration) -> Self {
            self.jwt_configuration = Some(input);
            self
        }
        /// <p>Represents the configuration of a JWT authorizer. Required for the JWT authorizer type. Supported only for HTTP APIs.</p>
        pub fn set_jwt_configuration(
            mut self,
            input: std::option::Option<crate::model::JwtConfiguration>,
        ) -> Self {
            self.jwt_configuration = input;
            self
        }
        /// <p>The name of the authorizer.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the authorizer.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAuthorizerInput`](crate::input::CreateAuthorizerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateAuthorizerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateAuthorizerInput {
                api_id: self.api_id,
                authorizer_credentials_arn: self.authorizer_credentials_arn,
                authorizer_payload_format_version: self.authorizer_payload_format_version,
                authorizer_result_ttl_in_seconds: self
                    .authorizer_result_ttl_in_seconds
                    .unwrap_or_default(),
                authorizer_type: self.authorizer_type,
                authorizer_uri: self.authorizer_uri,
                enable_simple_responses: self.enable_simple_responses.unwrap_or_default(),
                identity_source: self.identity_source,
                identity_validation_expression: self.identity_validation_expression,
                jwt_configuration: self.jwt_configuration,
                name: self.name,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateAuthorizerInputOperationOutputAlias = crate::operation::CreateAuthorizer;
#[doc(hidden)]
pub type CreateAuthorizerInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateAuthorizerInput {
    /// Consumes the builder and constructs an Operation<[`CreateAuthorizer`](crate::operation::CreateAuthorizer)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateAuthorizer,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateAuthorizerInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_2 = &_input.api_id;
                let input_2 = input_2.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_2, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v2/apis/{ApiId}/authorizers", ApiId = api_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateAuthorizerInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_authorizer(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateAuthorizer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateAuthorizer",
            "apigatewayv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateAuthorizerInput`](crate::input::CreateAuthorizerInput)
    pub fn builder() -> crate::input::create_authorizer_input::Builder {
        crate::input::create_authorizer_input::Builder::default()
    }
}

/// See [`CreateDeploymentInput`](crate::input::CreateDeploymentInput)
pub mod create_deployment_input {
    /// A builder for [`CreateDeploymentInput`](crate::input::CreateDeploymentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) stage_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The description for the deployment resource.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description for the deployment resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The name of the Stage resource for the Deployment resource to create.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stage_name = Some(input.into());
            self
        }
        /// <p>The name of the Stage resource for the Deployment resource to create.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stage_name = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDeploymentInput`](crate::input::CreateDeploymentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDeploymentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDeploymentInput {
                api_id: self.api_id,
                description: self.description,
                stage_name: self.stage_name,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDeploymentInputOperationOutputAlias = crate::operation::CreateDeployment;
#[doc(hidden)]
pub type CreateDeploymentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateDeploymentInput {
    /// Consumes the builder and constructs an Operation<[`CreateDeployment`](crate::operation::CreateDeployment)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDeployment,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateDeploymentInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_3 = &_input.api_id;
                let input_3 = input_3.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_3, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v2/apis/{ApiId}/deployments", ApiId = api_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateDeploymentInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_deployment(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDeployment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDeployment",
            "apigatewayv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateDeploymentInput`](crate::input::CreateDeploymentInput)
    pub fn builder() -> crate::input::create_deployment_input::Builder {
        crate::input::create_deployment_input::Builder::default()
    }
}

/// See [`CreateDomainNameInput`](crate::input::CreateDomainNameInput)
pub mod create_domain_name_input {
    /// A builder for [`CreateDomainNameInput`](crate::input::CreateDomainNameInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) domain_name_configurations:
            std::option::Option<std::vec::Vec<crate::model::DomainNameConfiguration>>,
        pub(crate) mutual_tls_authentication:
            std::option::Option<crate::model::MutualTlsAuthenticationInput>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The domain name.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The domain name.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Appends an item to `domain_name_configurations`.
        ///
        /// To override the contents of this collection use [`set_domain_name_configurations`](Self::set_domain_name_configurations).
        ///
        /// <p>The domain name configurations.</p>
        pub fn domain_name_configurations(
            mut self,
            input: crate::model::DomainNameConfiguration,
        ) -> Self {
            let mut v = self.domain_name_configurations.unwrap_or_default();
            v.push(input);
            self.domain_name_configurations = Some(v);
            self
        }
        /// <p>The domain name configurations.</p>
        pub fn set_domain_name_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DomainNameConfiguration>>,
        ) -> Self {
            self.domain_name_configurations = input;
            self
        }
        /// <p>The mutual TLS authentication configuration for a custom domain name.</p>
        pub fn mutual_tls_authentication(
            mut self,
            input: crate::model::MutualTlsAuthenticationInput,
        ) -> Self {
            self.mutual_tls_authentication = Some(input);
            self
        }
        /// <p>The mutual TLS authentication configuration for a custom domain name.</p>
        pub fn set_mutual_tls_authentication(
            mut self,
            input: std::option::Option<crate::model::MutualTlsAuthenticationInput>,
        ) -> Self {
            self.mutual_tls_authentication = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The collection of tags associated with a domain name.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The collection of tags associated with a domain name.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDomainNameInput`](crate::input::CreateDomainNameInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDomainNameInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDomainNameInput {
                domain_name: self.domain_name,
                domain_name_configurations: self.domain_name_configurations,
                mutual_tls_authentication: self.mutual_tls_authentication,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDomainNameInputOperationOutputAlias = crate::operation::CreateDomainName;
#[doc(hidden)]
pub type CreateDomainNameInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateDomainNameInput {
    /// Consumes the builder and constructs an Operation<[`CreateDomainName`](crate::operation::CreateDomainName)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDomainName,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateDomainNameInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/v2/domainnames").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateDomainNameInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_domain_name(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDomainName::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDomainName",
            "apigatewayv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateDomainNameInput`](crate::input::CreateDomainNameInput)
    pub fn builder() -> crate::input::create_domain_name_input::Builder {
        crate::input::create_domain_name_input::Builder::default()
    }
}

/// See [`CreateIntegrationInput`](crate::input::CreateIntegrationInput)
pub mod create_integration_input {
    /// A builder for [`CreateIntegrationInput`](crate::input::CreateIntegrationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) connection_id: std::option::Option<std::string::String>,
        pub(crate) connection_type: std::option::Option<crate::model::ConnectionType>,
        pub(crate) content_handling_strategy:
            std::option::Option<crate::model::ContentHandlingStrategy>,
        pub(crate) credentials_arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) integration_method: std::option::Option<std::string::String>,
        pub(crate) integration_subtype: std::option::Option<std::string::String>,
        pub(crate) integration_type: std::option::Option<crate::model::IntegrationType>,
        pub(crate) integration_uri: std::option::Option<std::string::String>,
        pub(crate) passthrough_behavior: std::option::Option<crate::model::PassthroughBehavior>,
        pub(crate) payload_format_version: std::option::Option<std::string::String>,
        pub(crate) request_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) request_templates: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) response_parameters: std::option::Option<
            std::collections::HashMap<
                std::string::String,
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        >,
        pub(crate) template_selection_expression: std::option::Option<std::string::String>,
        pub(crate) timeout_in_millis: std::option::Option<i32>,
        pub(crate) tls_config: std::option::Option<crate::model::TlsConfigInput>,
    }
    impl Builder {
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The ID of the VPC link for a private integration. Supported only for HTTP APIs.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_id = Some(input.into());
            self
        }
        /// <p>The ID of the VPC link for a private integration. Supported only for HTTP APIs.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_id = input;
            self
        }
        /// <p>The type of the network connection to the integration endpoint. Specify INTERNET for connections through the public routable internet or VPC_LINK for private connections between API Gateway and resources in a VPC. The default value is INTERNET.</p>
        pub fn connection_type(mut self, input: crate::model::ConnectionType) -> Self {
            self.connection_type = Some(input);
            self
        }
        /// <p>The type of the network connection to the integration endpoint. Specify INTERNET for connections through the public routable internet or VPC_LINK for private connections between API Gateway and resources in a VPC. The default value is INTERNET.</p>
        pub fn set_connection_type(
            mut self,
            input: std::option::Option<crate::model::ConnectionType>,
        ) -> Self {
            self.connection_type = input;
            self
        }
        /// <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p>
        /// <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p>
        /// <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p>
        /// <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
        pub fn content_handling_strategy(
            mut self,
            input: crate::model::ContentHandlingStrategy,
        ) -> Self {
            self.content_handling_strategy = Some(input);
            self
        }
        /// <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p>
        /// <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p>
        /// <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p>
        /// <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
        pub fn set_content_handling_strategy(
            mut self,
            input: std::option::Option<crate::model::ContentHandlingStrategy>,
        ) -> Self {
            self.content_handling_strategy = input;
            self
        }
        /// <p>Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, specify null.</p>
        pub fn credentials_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.credentials_arn = Some(input.into());
            self
        }
        /// <p>Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, specify null.</p>
        pub fn set_credentials_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.credentials_arn = input;
            self
        }
        /// <p>The description of the integration.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the integration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Specifies the integration's HTTP method type.</p>
        pub fn integration_method(mut self, input: impl Into<std::string::String>) -> Self {
            self.integration_method = Some(input.into());
            self
        }
        /// <p>Specifies the integration's HTTP method type.</p>
        pub fn set_integration_method(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.integration_method = input;
            self
        }
        /// <p>Supported only for HTTP API AWS_PROXY integrations. Specifies the AWS service action to invoke. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html">Integration subtype reference</a>.</p>
        pub fn integration_subtype(mut self, input: impl Into<std::string::String>) -> Self {
            self.integration_subtype = Some(input.into());
            self
        }
        /// <p>Supported only for HTTP API AWS_PROXY integrations. Specifies the AWS service action to invoke. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html">Integration subtype reference</a>.</p>
        pub fn set_integration_subtype(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.integration_subtype = input;
            self
        }
        /// <p>The integration type of an integration. One of the following:</p>
        /// <p>AWS: for integrating the route or method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration. Supported only for WebSocket APIs.</p>
        /// <p>AWS_PROXY: for integrating the route or method request with a Lambda function or other AWS service action. This integration is also referred to as a Lambda proxy integration.</p>
        /// <p>HTTP: for integrating the route or method request with an HTTP endpoint. This integration is also referred to as the HTTP custom integration. Supported only for WebSocket APIs.</p>
        /// <p>HTTP_PROXY: for integrating the route or method request with an HTTP endpoint, with the client request passed through as-is. This is also referred to as HTTP proxy integration. For HTTP API private integrations, use an HTTP_PROXY integration.</p>
        /// <p>MOCK: for integrating the route or method request with API Gateway as a "loopback" endpoint without invoking any backend. Supported only for WebSocket APIs.</p>
        pub fn integration_type(mut self, input: crate::model::IntegrationType) -> Self {
            self.integration_type = Some(input);
            self
        }
        /// <p>The integration type of an integration. One of the following:</p>
        /// <p>AWS: for integrating the route or method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration. Supported only for WebSocket APIs.</p>
        /// <p>AWS_PROXY: for integrating the route or method request with a Lambda function or other AWS service action. This integration is also referred to as a Lambda proxy integration.</p>
        /// <p>HTTP: for integrating the route or method request with an HTTP endpoint. This integration is also referred to as the HTTP custom integration. Supported only for WebSocket APIs.</p>
        /// <p>HTTP_PROXY: for integrating the route or method request with an HTTP endpoint, with the client request passed through as-is. This is also referred to as HTTP proxy integration. For HTTP API private integrations, use an HTTP_PROXY integration.</p>
        /// <p>MOCK: for integrating the route or method request with API Gateway as a "loopback" endpoint without invoking any backend. Supported only for WebSocket APIs.</p>
        pub fn set_integration_type(
            mut self,
            input: std::option::Option<crate::model::IntegrationType>,
        ) -> Self {
            self.integration_type = input;
            self
        }
        /// <p>For a Lambda integration, specify the URI of a Lambda function.</p>
        /// <p>For an HTTP integration, specify a fully-qualified URL.</p>
        /// <p>For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service. If you specify the ARN of an AWS Cloud Map service, API Gateway uses DiscoverInstances to identify resources. You can use query parameters to target specific resources. To learn more, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_DiscoverInstances.html">DiscoverInstances</a>. For private integrations, all resources must be owned by the same AWS account.</p>
        pub fn integration_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.integration_uri = Some(input.into());
            self
        }
        /// <p>For a Lambda integration, specify the URI of a Lambda function.</p>
        /// <p>For an HTTP integration, specify a fully-qualified URL.</p>
        /// <p>For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service. If you specify the ARN of an AWS Cloud Map service, API Gateway uses DiscoverInstances to identify resources. You can use query parameters to target specific resources. To learn more, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_DiscoverInstances.html">DiscoverInstances</a>. For private integrations, all resources must be owned by the same AWS account.</p>
        pub fn set_integration_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.integration_uri = input;
            self
        }
        /// <p>Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER. Supported only for WebSocket APIs.</p>
        /// <p>WHEN_NO_MATCH passes the request body for unmapped content types through to the integration backend without transformation.</p>
        /// <p>NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type response.</p>
        /// <p>WHEN_NO_TEMPLATES allows pass-through when the integration has no content types mapped to templates. However, if there is at least one content type defined, unmapped content types will be rejected with the same HTTP 415 Unsupported Media Type response.</p>
        pub fn passthrough_behavior(mut self, input: crate::model::PassthroughBehavior) -> Self {
            self.passthrough_behavior = Some(input);
            self
        }
        /// <p>Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER. Supported only for WebSocket APIs.</p>
        /// <p>WHEN_NO_MATCH passes the request body for unmapped content types through to the integration backend without transformation.</p>
        /// <p>NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type response.</p>
        /// <p>WHEN_NO_TEMPLATES allows pass-through when the integration has no content types mapped to templates. However, if there is at least one content type defined, unmapped content types will be rejected with the same HTTP 415 Unsupported Media Type response.</p>
        pub fn set_passthrough_behavior(
            mut self,
            input: std::option::Option<crate::model::PassthroughBehavior>,
        ) -> Self {
            self.passthrough_behavior = input;
            self
        }
        /// <p>Specifies the format of the payload sent to an integration. Required for HTTP APIs.</p>
        pub fn payload_format_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.payload_format_version = Some(input.into());
            self
        }
        /// <p>Specifies the format of the payload sent to an integration. Required for HTTP APIs.</p>
        pub fn set_payload_format_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.payload_format_version = input;
            self
        }
        /// Adds a key-value pair to `request_parameters`.
        ///
        /// To override the contents of this collection use [`set_request_parameters`](Self::set_request_parameters).
        ///
        /// <p>For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the backend. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the backend. The method request parameter value must match the pattern of method.request.<replaceable>
        /// {location}
        /// </replaceable>.<replaceable>
        /// {name}
        /// </replaceable> , where <replaceable>
        /// {location}
        /// </replaceable> is querystring, path, or header; and <replaceable>
        /// {name}
        /// </replaceable> must be a valid and unique method request parameter name.</p>
        /// <p>For HTTP API integrations with a specified integrationSubtype, request parameters are a key-value map specifying parameters that are passed to AWS_PROXY integrations. You can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services.html">Working with AWS service integrations for HTTP APIs</a>.</p>
        /// <p>For HTTP API integrations without a specified integrationSubtype request parameters are a key-value map specifying how to transform HTTP requests before sending them to the backend. The key should follow the pattern &lt;action&gt;:&lt;header|querystring|path&gt;.&lt;location&gt; where action can be append, overwrite or remove. For values, you can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
        pub fn request_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.request_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.request_parameters = Some(hash_map);
            self
        }
        /// <p>For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the backend. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the backend. The method request parameter value must match the pattern of method.request.<replaceable>
        /// {location}
        /// </replaceable>.<replaceable>
        /// {name}
        /// </replaceable> , where <replaceable>
        /// {location}
        /// </replaceable> is querystring, path, or header; and <replaceable>
        /// {name}
        /// </replaceable> must be a valid and unique method request parameter name.</p>
        /// <p>For HTTP API integrations with a specified integrationSubtype, request parameters are a key-value map specifying parameters that are passed to AWS_PROXY integrations. You can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services.html">Working with AWS service integrations for HTTP APIs</a>.</p>
        /// <p>For HTTP API integrations without a specified integrationSubtype request parameters are a key-value map specifying how to transform HTTP requests before sending them to the backend. The key should follow the pattern &lt;action&gt;:&lt;header|querystring|path&gt;.&lt;location&gt; where action can be append, overwrite or remove. For values, you can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
        pub fn set_request_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.request_parameters = input;
            self
        }
        /// Adds a key-value pair to `request_templates`.
        ///
        /// To override the contents of this collection use [`set_request_templates`](Self::set_request_templates).
        ///
        /// <p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value. Supported only for WebSocket APIs.</p>
        pub fn request_templates(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.request_templates.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.request_templates = Some(hash_map);
            self
        }
        /// <p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value. Supported only for WebSocket APIs.</p>
        pub fn set_request_templates(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.request_templates = input;
            self
        }
        /// Adds a key-value pair to `response_parameters`.
        ///
        /// To override the contents of this collection use [`set_response_parameters`](Self::set_response_parameters).
        ///
        /// <p>Supported only for HTTP APIs. You use response parameters to transform the HTTP response from a backend integration before returning the response to clients. Specify a key-value map from a selection key to response parameters. The selection key must be a valid HTTP status code within the range of 200-599. Response parameters are a key-value map. The key must match pattern &lt;action&gt;:&lt;header&gt;.&lt;location&gt; or overwrite.statuscode. The action can be append, overwrite or remove. The value can be a static value, or map to response data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
        pub fn response_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: std::collections::HashMap<std::string::String, std::string::String>,
        ) -> Self {
            let mut hash_map = self.response_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.response_parameters = Some(hash_map);
            self
        }
        /// <p>Supported only for HTTP APIs. You use response parameters to transform the HTTP response from a backend integration before returning the response to clients. Specify a key-value map from a selection key to response parameters. The selection key must be a valid HTTP status code within the range of 200-599. Response parameters are a key-value map. The key must match pattern &lt;action&gt;:&lt;header&gt;.&lt;location&gt; or overwrite.statuscode. The action can be append, overwrite or remove. The value can be a static value, or map to response data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
        pub fn set_response_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    std::collections::HashMap<std::string::String, std::string::String>,
                >,
            >,
        ) -> Self {
            self.response_parameters = input;
            self
        }
        /// <p>The template selection expression for the integration.</p>
        pub fn template_selection_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.template_selection_expression = Some(input.into());
            self
        }
        /// <p>The template selection expression for the integration.</p>
        pub fn set_template_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_selection_expression = input;
            self
        }
        /// <p>Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs. The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.</p>
        pub fn timeout_in_millis(mut self, input: i32) -> Self {
            self.timeout_in_millis = Some(input);
            self
        }
        /// <p>Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs. The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.</p>
        pub fn set_timeout_in_millis(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout_in_millis = input;
            self
        }
        /// <p>The TLS configuration for a private integration. If you specify a TLS configuration, private integration traffic uses the HTTPS protocol. Supported only for HTTP APIs.</p>
        pub fn tls_config(mut self, input: crate::model::TlsConfigInput) -> Self {
            self.tls_config = Some(input);
            self
        }
        /// <p>The TLS configuration for a private integration. If you specify a TLS configuration, private integration traffic uses the HTTPS protocol. Supported only for HTTP APIs.</p>
        pub fn set_tls_config(
            mut self,
            input: std::option::Option<crate::model::TlsConfigInput>,
        ) -> Self {
            self.tls_config = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateIntegrationInput`](crate::input::CreateIntegrationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateIntegrationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateIntegrationInput {
                api_id: self.api_id,
                connection_id: self.connection_id,
                connection_type: self.connection_type,
                content_handling_strategy: self.content_handling_strategy,
                credentials_arn: self.credentials_arn,
                description: self.description,
                integration_method: self.integration_method,
                integration_subtype: self.integration_subtype,
                integration_type: self.integration_type,
                integration_uri: self.integration_uri,
                passthrough_behavior: self.passthrough_behavior,
                payload_format_version: self.payload_format_version,
                request_parameters: self.request_parameters,
                request_templates: self.request_templates,
                response_parameters: self.response_parameters,
                template_selection_expression: self.template_selection_expression,
                timeout_in_millis: self.timeout_in_millis.unwrap_or_default(),
                tls_config: self.tls_config,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateIntegrationInputOperationOutputAlias = crate::operation::CreateIntegration;
#[doc(hidden)]
pub type CreateIntegrationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateIntegrationInput {
    /// Consumes the builder and constructs an Operation<[`CreateIntegration`](crate::operation::CreateIntegration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateIntegration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateIntegrationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_4 = &_input.api_id;
                let input_4 = input_4.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_4, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v2/apis/{ApiId}/integrations", ApiId = api_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateIntegrationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_integration(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateIntegration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateIntegration",
            "apigatewayv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateIntegrationInput`](crate::input::CreateIntegrationInput)
    pub fn builder() -> crate::input::create_integration_input::Builder {
        crate::input::create_integration_input::Builder::default()
    }
}

/// See [`CreateIntegrationResponseInput`](crate::input::CreateIntegrationResponseInput)
pub mod create_integration_response_input {
    /// A builder for [`CreateIntegrationResponseInput`](crate::input::CreateIntegrationResponseInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) content_handling_strategy:
            std::option::Option<crate::model::ContentHandlingStrategy>,
        pub(crate) integration_id: std::option::Option<std::string::String>,
        pub(crate) integration_response_key: std::option::Option<std::string::String>,
        pub(crate) response_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) response_templates: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) template_selection_expression: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p>
        /// <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p>
        /// <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p>
        /// <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
        pub fn content_handling_strategy(
            mut self,
            input: crate::model::ContentHandlingStrategy,
        ) -> Self {
            self.content_handling_strategy = Some(input);
            self
        }
        /// <p>Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p>
        /// <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p>
        /// <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p>
        /// <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
        pub fn set_content_handling_strategy(
            mut self,
            input: std::option::Option<crate::model::ContentHandlingStrategy>,
        ) -> Self {
            self.content_handling_strategy = input;
            self
        }
        /// <p>The integration ID.</p>
        pub fn integration_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.integration_id = Some(input.into());
            self
        }
        /// <p>The integration ID.</p>
        pub fn set_integration_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.integration_id = input;
            self
        }
        /// <p>The integration response key.</p>
        pub fn integration_response_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.integration_response_key = Some(input.into());
            self
        }
        /// <p>The integration response key.</p>
        pub fn set_integration_response_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.integration_response_key = input;
            self
        }
        /// Adds a key-value pair to `response_parameters`.
        ///
        /// To override the contents of this collection use [`set_response_parameters`](Self::set_response_parameters).
        ///
        /// <p>A key-value map specifying response parameters that are passed to the method response from the backend. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of method.response.header.{name}, where {name} is a valid and unique header name. The mapped non-static value must match the pattern of integration.response.header.{name} or integration.response.body.{JSON-expression}, where {name} is a valid and unique response header name and {JSON-expression} is a valid JSON expression without the $ prefix.</p>
        pub fn response_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.response_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.response_parameters = Some(hash_map);
            self
        }
        /// <p>A key-value map specifying response parameters that are passed to the method response from the backend. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of method.response.header.{name}, where {name} is a valid and unique header name. The mapped non-static value must match the pattern of integration.response.header.{name} or integration.response.body.{JSON-expression}, where {name} is a valid and unique response header name and {JSON-expression} is a valid JSON expression without the $ prefix.</p>
        pub fn set_response_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.response_parameters = input;
            self
        }
        /// Adds a key-value pair to `response_templates`.
        ///
        /// To override the contents of this collection use [`set_response_templates`](Self::set_response_templates).
        ///
        /// <p>The collection of response templates for the integration response as a string-to-string map of key-value pairs. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.</p>
        pub fn response_templates(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.response_templates.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.response_templates = Some(hash_map);
            self
        }
        /// <p>The collection of response templates for the integration response as a string-to-string map of key-value pairs. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.</p>
        pub fn set_response_templates(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.response_templates = input;
            self
        }
        /// <p>The template selection expression for the integration response. Supported only for WebSocket APIs.</p>
        pub fn template_selection_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.template_selection_expression = Some(input.into());
            self
        }
        /// <p>The template selection expression for the integration response. Supported only for WebSocket APIs.</p>
        pub fn set_template_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_selection_expression = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateIntegrationResponseInput`](crate::input::CreateIntegrationResponseInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateIntegrationResponseInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateIntegrationResponseInput {
                api_id: self.api_id,
                content_handling_strategy: self.content_handling_strategy,
                integration_id: self.integration_id,
                integration_response_key: self.integration_response_key,
                response_parameters: self.response_parameters,
                response_templates: self.response_templates,
                template_selection_expression: self.template_selection_expression,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateIntegrationResponseInputOperationOutputAlias =
    crate::operation::CreateIntegrationResponse;
#[doc(hidden)]
pub type CreateIntegrationResponseInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateIntegrationResponseInput {
    /// Consumes the builder and constructs an Operation<[`CreateIntegrationResponse`](crate::operation::CreateIntegrationResponse)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateIntegrationResponse,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateIntegrationResponseInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_5 = &_input.api_id;
                let input_5 = input_5.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_5, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_6 = &_input.integration_id;
                let input_6 = input_6.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "integration_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let integration_id = aws_smithy_http::label::fmt_string(input_6, false);
                if integration_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "integration_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/apis/{ApiId}/integrations/{IntegrationId}/integrationresponses",
                    ApiId = api_id,
                    IntegrationId = integration_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateIntegrationResponseInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_integration_response(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateIntegrationResponse::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateIntegrationResponse",
            "apigatewayv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateIntegrationResponseInput`](crate::input::CreateIntegrationResponseInput)
    pub fn builder() -> crate::input::create_integration_response_input::Builder {
        crate::input::create_integration_response_input::Builder::default()
    }
}

/// See [`CreateModelInput`](crate::input::CreateModelInput)
pub mod create_model_input {
    /// A builder for [`CreateModelInput`](crate::input::CreateModelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) content_type: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) schema: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The content-type for the model, for example, "application/json".</p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_type = Some(input.into());
            self
        }
        /// <p>The content-type for the model, for example, "application/json".</p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_type = input;
            self
        }
        /// <p>The description of the model.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the model.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The name of the model. Must be alphanumeric.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the model. Must be alphanumeric.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The schema for the model. For application/json models, this should be JSON schema draft 4 model.</p>
        pub fn schema(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema = Some(input.into());
            self
        }
        /// <p>The schema for the model. For application/json models, this should be JSON schema draft 4 model.</p>
        pub fn set_schema(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateModelInput`](crate::input::CreateModelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateModelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateModelInput {
                api_id: self.api_id,
                content_type: self.content_type,
                description: self.description,
                name: self.name,
                schema: self.schema,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateModelInputOperationOutputAlias = crate::operation::CreateModel;
#[doc(hidden)]
pub type CreateModelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateModelInput {
    /// Consumes the builder and constructs an Operation<[`CreateModel`](crate::operation::CreateModel)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateModel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateModelInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_7 = &_input.api_id;
                let input_7 = input_7.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_7, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v2/apis/{ApiId}/models", ApiId = api_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateModelInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_model(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateModel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateModel",
            "apigatewayv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateModelInput`](crate::input::CreateModelInput)
    pub fn builder() -> crate::input::create_model_input::Builder {
        crate::input::create_model_input::Builder::default()
    }
}

/// See [`CreateRouteInput`](crate::input::CreateRouteInput)
pub mod create_route_input {
    /// A builder for [`CreateRouteInput`](crate::input::CreateRouteInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) api_key_required: std::option::Option<bool>,
        pub(crate) authorization_scopes: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) authorization_type: std::option::Option<crate::model::AuthorizationType>,
        pub(crate) authorizer_id: std::option::Option<std::string::String>,
        pub(crate) model_selection_expression: std::option::Option<std::string::String>,
        pub(crate) operation_name: std::option::Option<std::string::String>,
        pub(crate) request_models: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) request_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::ParameterConstraints>,
        >,
        pub(crate) route_key: std::option::Option<std::string::String>,
        pub(crate) route_response_selection_expression: std::option::Option<std::string::String>,
        pub(crate) target: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>Specifies whether an API key is required for the route. Supported only for WebSocket APIs.</p>
        pub fn api_key_required(mut self, input: bool) -> Self {
            self.api_key_required = Some(input);
            self
        }
        /// <p>Specifies whether an API key is required for the route. Supported only for WebSocket APIs.</p>
        pub fn set_api_key_required(mut self, input: std::option::Option<bool>) -> Self {
            self.api_key_required = input;
            self
        }
        /// Appends an item to `authorization_scopes`.
        ///
        /// To override the contents of this collection use [`set_authorization_scopes`](Self::set_authorization_scopes).
        ///
        /// <p>The authorization scopes supported by this route.</p>
        pub fn authorization_scopes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.authorization_scopes.unwrap_or_default();
            v.push(input.into());
            self.authorization_scopes = Some(v);
            self
        }
        /// <p>The authorization scopes supported by this route.</p>
        pub fn set_authorization_scopes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.authorization_scopes = input;
            self
        }
        /// <p>The authorization type for the route. For WebSocket APIs, valid values are NONE for open access, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer For HTTP APIs, valid values are NONE for open access, JWT for using JSON Web Tokens, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer.</p>
        pub fn authorization_type(mut self, input: crate::model::AuthorizationType) -> Self {
            self.authorization_type = Some(input);
            self
        }
        /// <p>The authorization type for the route. For WebSocket APIs, valid values are NONE for open access, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer For HTTP APIs, valid values are NONE for open access, JWT for using JSON Web Tokens, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer.</p>
        pub fn set_authorization_type(
            mut self,
            input: std::option::Option<crate::model::AuthorizationType>,
        ) -> Self {
            self.authorization_type = input;
            self
        }
        /// <p>The identifier of the Authorizer resource to be associated with this route. The authorizer identifier is generated by API Gateway when you created the authorizer.</p>
        pub fn authorizer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorizer_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Authorizer resource to be associated with this route. The authorizer identifier is generated by API Gateway when you created the authorizer.</p>
        pub fn set_authorizer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorizer_id = input;
            self
        }
        /// <p>The model selection expression for the route. Supported only for WebSocket APIs.</p>
        pub fn model_selection_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_selection_expression = Some(input.into());
            self
        }
        /// <p>The model selection expression for the route. Supported only for WebSocket APIs.</p>
        pub fn set_model_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_selection_expression = input;
            self
        }
        /// <p>The operation name for the route.</p>
        pub fn operation_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation_name = Some(input.into());
            self
        }
        /// <p>The operation name for the route.</p>
        pub fn set_operation_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.operation_name = input;
            self
        }
        /// Adds a key-value pair to `request_models`.
        ///
        /// To override the contents of this collection use [`set_request_models`](Self::set_request_models).
        ///
        /// <p>The request models for the route. Supported only for WebSocket APIs.</p>
        pub fn request_models(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.request_models.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.request_models = Some(hash_map);
            self
        }
        /// <p>The request models for the route. Supported only for WebSocket APIs.</p>
        pub fn set_request_models(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.request_models = input;
            self
        }
        /// Adds a key-value pair to `request_parameters`.
        ///
        /// To override the contents of this collection use [`set_request_parameters`](Self::set_request_parameters).
        ///
        /// <p>The request parameters for the route. Supported only for WebSocket APIs.</p>
        pub fn request_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::ParameterConstraints,
        ) -> Self {
            let mut hash_map = self.request_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.request_parameters = Some(hash_map);
            self
        }
        /// <p>The request parameters for the route. Supported only for WebSocket APIs.</p>
        pub fn set_request_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::ParameterConstraints>,
            >,
        ) -> Self {
            self.request_parameters = input;
            self
        }
        /// <p>The route key for the route.</p>
        pub fn route_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_key = Some(input.into());
            self
        }
        /// <p>The route key for the route.</p>
        pub fn set_route_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.route_key = input;
            self
        }
        /// <p>The route response selection expression for the route. Supported only for WebSocket APIs.</p>
        pub fn route_response_selection_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.route_response_selection_expression = Some(input.into());
            self
        }
        /// <p>The route response selection expression for the route. Supported only for WebSocket APIs.</p>
        pub fn set_route_response_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.route_response_selection_expression = input;
            self
        }
        /// <p>The target for the route.</p>
        pub fn target(mut self, input: impl Into<std::string::String>) -> Self {
            self.target = Some(input.into());
            self
        }
        /// <p>The target for the route.</p>
        pub fn set_target(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRouteInput`](crate::input::CreateRouteInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateRouteInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateRouteInput {
                api_id: self.api_id,
                api_key_required: self.api_key_required.unwrap_or_default(),
                authorization_scopes: self.authorization_scopes,
                authorization_type: self.authorization_type,
                authorizer_id: self.authorizer_id,
                model_selection_expression: self.model_selection_expression,
                operation_name: self.operation_name,
                request_models: self.request_models,
                request_parameters: self.request_parameters,
                route_key: self.route_key,
                route_response_selection_expression: self.route_response_selection_expression,
                target: self.target,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateRouteInputOperationOutputAlias = crate::operation::CreateRoute;
#[doc(hidden)]
pub type CreateRouteInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateRouteInput {
    /// Consumes the builder and constructs an Operation<[`CreateRoute`](crate::operation::CreateRoute)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateRoute,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateRouteInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_8 = &_input.api_id;
                let input_8 = input_8.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_8, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v2/apis/{ApiId}/routes", ApiId = api_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateRouteInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_route(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateRoute::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateRoute",
            "apigatewayv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateRouteInput`](crate::input::CreateRouteInput)
    pub fn builder() -> crate::input::create_route_input::Builder {
        crate::input::create_route_input::Builder::default()
    }
}

/// See [`CreateRouteResponseInput`](crate::input::CreateRouteResponseInput)
pub mod create_route_response_input {
    /// A builder for [`CreateRouteResponseInput`](crate::input::CreateRouteResponseInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) model_selection_expression: std::option::Option<std::string::String>,
        pub(crate) response_models: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) response_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::ParameterConstraints>,
        >,
        pub(crate) route_id: std::option::Option<std::string::String>,
        pub(crate) route_response_key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The model selection expression for the route response. Supported only for WebSocket APIs.</p>
        pub fn model_selection_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_selection_expression = Some(input.into());
            self
        }
        /// <p>The model selection expression for the route response. Supported only for WebSocket APIs.</p>
        pub fn set_model_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_selection_expression = input;
            self
        }
        /// Adds a key-value pair to `response_models`.
        ///
        /// To override the contents of this collection use [`set_response_models`](Self::set_response_models).
        ///
        /// <p>The response models for the route response.</p>
        pub fn response_models(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.response_models.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.response_models = Some(hash_map);
            self
        }
        /// <p>The response models for the route response.</p>
        pub fn set_response_models(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.response_models = input;
            self
        }
        /// Adds a key-value pair to `response_parameters`.
        ///
        /// To override the contents of this collection use [`set_response_parameters`](Self::set_response_parameters).
        ///
        /// <p>The route response parameters.</p>
        pub fn response_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::ParameterConstraints,
        ) -> Self {
            let mut hash_map = self.response_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.response_parameters = Some(hash_map);
            self
        }
        /// <p>The route response parameters.</p>
        pub fn set_response_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::ParameterConstraints>,
            >,
        ) -> Self {
            self.response_parameters = input;
            self
        }
        /// <p>The route ID.</p>
        pub fn route_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_id = Some(input.into());
            self
        }
        /// <p>The route ID.</p>
        pub fn set_route_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.route_id = input;
            self
        }
        /// <p>The route response key.</p>
        pub fn route_response_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_response_key = Some(input.into());
            self
        }
        /// <p>The route response key.</p>
        pub fn set_route_response_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.route_response_key = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRouteResponseInput`](crate::input::CreateRouteResponseInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateRouteResponseInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateRouteResponseInput {
                api_id: self.api_id,
                model_selection_expression: self.model_selection_expression,
                response_models: self.response_models,
                response_parameters: self.response_parameters,
                route_id: self.route_id,
                route_response_key: self.route_response_key,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateRouteResponseInputOperationOutputAlias = crate::operation::CreateRouteResponse;
#[doc(hidden)]
pub type CreateRouteResponseInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateRouteResponseInput {
    /// Consumes the builder and constructs an Operation<[`CreateRouteResponse`](crate::operation::CreateRouteResponse)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateRouteResponse,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateRouteResponseInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_9 = &_input.api_id;
                let input_9 = input_9.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_9, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_10 = &_input.route_id;
                let input_10 = input_10.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "route_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let route_id = aws_smithy_http::label::fmt_string(input_10, false);
                if route_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "route_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/apis/{ApiId}/routes/{RouteId}/routeresponses",
                    ApiId = api_id,
                    RouteId = route_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateRouteResponseInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_route_response(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateRouteResponse::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateRouteResponse",
            "apigatewayv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateRouteResponseInput`](crate::input::CreateRouteResponseInput)
    pub fn builder() -> crate::input::create_route_response_input::Builder {
        crate::input::create_route_response_input::Builder::default()
    }
}

/// See [`CreateStageInput`](crate::input::CreateStageInput)
pub mod create_stage_input {
    /// A builder for [`CreateStageInput`](crate::input::CreateStageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_log_settings: std::option::Option<crate::model::AccessLogSettings>,
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) auto_deploy: std::option::Option<bool>,
        pub(crate) client_certificate_id: std::option::Option<std::string::String>,
        pub(crate) default_route_settings: std::option::Option<crate::model::RouteSettings>,
        pub(crate) deployment_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) route_settings: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::RouteSettings>,
        >,
        pub(crate) stage_name: std::option::Option<std::string::String>,
        pub(crate) stage_variables: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>Settings for logging access in this stage.</p>
        pub fn access_log_settings(mut self, input: crate::model::AccessLogSettings) -> Self {
            self.access_log_settings = Some(input);
            self
        }
        /// <p>Settings for logging access in this stage.</p>
        pub fn set_access_log_settings(
            mut self,
            input: std::option::Option<crate::model::AccessLogSettings>,
        ) -> Self {
            self.access_log_settings = input;
            self
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>Specifies whether updates to an API automatically trigger a new deployment. The default value is false.</p>
        pub fn auto_deploy(mut self, input: bool) -> Self {
            self.auto_deploy = Some(input);
            self
        }
        /// <p>Specifies whether updates to an API automatically trigger a new deployment. The default value is false.</p>
        pub fn set_auto_deploy(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_deploy = input;
            self
        }
        /// <p>The identifier of a client certificate for a Stage. Supported only for WebSocket APIs.</p>
        pub fn client_certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_certificate_id = Some(input.into());
            self
        }
        /// <p>The identifier of a client certificate for a Stage. Supported only for WebSocket APIs.</p>
        pub fn set_client_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_certificate_id = input;
            self
        }
        /// <p>The default route settings for the stage.</p>
        pub fn default_route_settings(mut self, input: crate::model::RouteSettings) -> Self {
            self.default_route_settings = Some(input);
            self
        }
        /// <p>The default route settings for the stage.</p>
        pub fn set_default_route_settings(
            mut self,
            input: std::option::Option<crate::model::RouteSettings>,
        ) -> Self {
            self.default_route_settings = input;
            self
        }
        /// <p>The deployment identifier of the API stage.</p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_id = Some(input.into());
            self
        }
        /// <p>The deployment identifier of the API stage.</p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_id = input;
            self
        }
        /// <p>The description for the API stage.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description for the API stage.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Adds a key-value pair to `route_settings`.
        ///
        /// To override the contents of this collection use [`set_route_settings`](Self::set_route_settings).
        ///
        /// <p>Route settings for the stage, by routeKey.</p>
        pub fn route_settings(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::RouteSettings,
        ) -> Self {
            let mut hash_map = self.route_settings.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.route_settings = Some(hash_map);
            self
        }
        /// <p>Route settings for the stage, by routeKey.</p>
        pub fn set_route_settings(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::RouteSettings>,
            >,
        ) -> Self {
            self.route_settings = input;
            self
        }
        /// <p>The name of the stage.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stage_name = Some(input.into());
            self
        }
        /// <p>The name of the stage.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stage_name = input;
            self
        }
        /// Adds a key-value pair to `stage_variables`.
        ///
        /// To override the contents of this collection use [`set_stage_variables`](Self::set_stage_variables).
        ///
        /// <p>A map that defines the stage variables for a Stage. Variable names can have alphanumeric and underscore characters, and the values must match [A-Za-z0-9-._~:/?#&amp;=,]+.</p>
        pub fn stage_variables(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.stage_variables.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.stage_variables = Some(hash_map);
            self
        }
        /// <p>A map that defines the stage variables for a Stage. Variable names can have alphanumeric and underscore characters, and the values must match [A-Za-z0-9-._~:/?#&amp;=,]+.</p>
        pub fn set_stage_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.stage_variables = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateStageInput`](crate::input::CreateStageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateStageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateStageInput {
                access_log_settings: self.access_log_settings,
                api_id: self.api_id,
                auto_deploy: self.auto_deploy.unwrap_or_default(),
                client_certificate_id: self.client_certificate_id,
                default_route_settings: self.default_route_settings,
                deployment_id: self.deployment_id,
                description: self.description,
                route_settings: self.route_settings,
                stage_name: self.stage_name,
                stage_variables: self.stage_variables,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateStageInputOperationOutputAlias = crate::operation::CreateStage;
#[doc(hidden)]
pub type CreateStageInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateStageInput {
    /// Consumes the builder and constructs an Operation<[`CreateStage`](crate::operation::CreateStage)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateStage,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateStageInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_11 = &_input.api_id;
                let input_11 = input_11.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_11, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v2/apis/{ApiId}/stages", ApiId = api_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateStageInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_stage(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateStage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateStage",
            "apigatewayv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateStageInput`](crate::input::CreateStageInput)
    pub fn builder() -> crate::input::create_stage_input::Builder {
        crate::input::create_stage_input::Builder::default()
    }
}

/// See [`CreateVpcLinkInput`](crate::input::CreateVpcLinkInput)
pub mod create_vpc_link_input {
    /// A builder for [`CreateVpcLinkInput`](crate::input::CreateVpcLinkInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the VPC link.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the VPC link.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>A list of security group IDs for the VPC link.</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.security_group_ids = Some(v);
            self
        }
        /// <p>A list of security group IDs for the VPC link.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_ids = input;
            self
        }
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>A list of subnet IDs to include in the VPC link.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>A list of subnet IDs to include in the VPC link.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A list of tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateVpcLinkInput`](crate::input::CreateVpcLinkInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateVpcLinkInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateVpcLinkInput {
                name: self.name,
                security_group_ids: self.security_group_ids,
                subnet_ids: self.subnet_ids,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateVpcLinkInputOperationOutputAlias = crate::operation::CreateVpcLink;
#[doc(hidden)]
pub type CreateVpcLinkInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateVpcLinkInput {
    /// Consumes the builder and constructs an Operation<[`CreateVpcLink`](crate::operation::CreateVpcLink)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateVpcLink,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateVpcLinkInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/v2/vpclinks").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateVpcLinkInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_vpc_link(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateVpcLink::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateVpcLink",
            "apigatewayv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateVpcLinkInput`](crate::input::CreateVpcLinkInput)
    pub fn builder() -> crate::input::create_vpc_link_input::Builder {
        crate::input::create_vpc_link_input::Builder::default()
    }
}

/// See [`DeleteAccessLogSettingsInput`](crate::input::DeleteAccessLogSettingsInput)
pub mod delete_access_log_settings_input {
    /// A builder for [`DeleteAccessLogSettingsInput`](crate::input::DeleteAccessLogSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) stage_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The stage name. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stage_name = Some(input.into());
            self
        }
        /// <p>The stage name. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stage_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAccessLogSettingsInput`](crate::input::DeleteAccessLogSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAccessLogSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAccessLogSettingsInput {
                api_id: self.api_id,
                stage_name: self.stage_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAccessLogSettingsInputOperationOutputAlias =
    crate::operation::DeleteAccessLogSettings;
#[doc(hidden)]
pub type DeleteAccessLogSettingsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteAccessLogSettingsInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAccessLogSettings`](crate::operation::DeleteAccessLogSettings)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAccessLogSettings,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteAccessLogSettingsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_12 = &_input.api_id;
                let input_12 = input_12.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_12, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_13 = &_input.stage_name;
                let input_13 = input_13.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "stage_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let stage_name = aws_smithy_http::label::fmt_string(input_13, false);
                if stage_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "stage_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/apis/{ApiId}/stages/{StageName}/accesslogsettings",
                    ApiId = api_id,
                    StageName = stage_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteAccessLogSettingsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAccessLogSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAccessLogSettings",
            "apigatewayv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteAccessLogSettingsInput`](crate::input::DeleteAccessLogSettingsInput)
    pub fn builder() -> crate::input::delete_access_log_settings_input::Builder {
        crate::input::delete_access_log_settings_input::Builder::default()
    }
}

/// See [`DeleteApiInput`](crate::input::DeleteApiInput)
pub mod delete_api_input {
    /// A builder for [`DeleteApiInput`](crate::input::DeleteApiInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteApiInput`](crate::input::DeleteApiInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::DeleteApiInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::DeleteApiInput {
                api_id: self.api_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteApiInputOperationOutputAlias = crate::operation::DeleteApi;
#[doc(hidden)]
pub type DeleteApiInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteApiInput {
    /// Consumes the builder and constructs an Operation<[`DeleteApi`](crate::operation::DeleteApi)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteApi,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteApiInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_14 = &_input.api_id;
                let input_14 = input_14.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_14, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v2/apis/{ApiId}", ApiId = api_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteApiInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::DeleteApi::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "DeleteApi",
                    "apigatewayv2",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteApiInput`](crate::input::DeleteApiInput)
    pub fn builder() -> crate::input::delete_api_input::Builder {
        crate::input::delete_api_input::Builder::default()
    }
}

/// See [`DeleteApiMappingInput`](crate::input::DeleteApiMappingInput)
pub mod delete_api_mapping_input {
    /// A builder for [`DeleteApiMappingInput`](crate::input::DeleteApiMappingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_mapping_id: std::option::Option<std::string::String>,
        pub(crate) domain_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API mapping identifier.</p>
        pub fn api_mapping_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_mapping_id = Some(input.into());
            self
        }
        /// <p>The API mapping identifier.</p>
        pub fn set_api_mapping_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.api_mapping_id = input;
            self
        }
        /// <p>The domain name.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The domain name.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteApiMappingInput`](crate::input::DeleteApiMappingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteApiMappingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteApiMappingInput {
                api_mapping_id: self.api_mapping_id,
                domain_name: self.domain_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteApiMappingInputOperationOutputAlias = crate::operation::DeleteApiMapping;
#[doc(hidden)]
pub type DeleteApiMappingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteApiMappingInput {
    /// Consumes the builder and constructs an Operation<[`DeleteApiMapping`](crate::operation::DeleteApiMapping)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteApiMapping,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteApiMappingInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_15 = &_input.domain_name;
                let input_15 = input_15.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_15, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_16 = &_input.api_mapping_id;
                let input_16 = input_16.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_mapping_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_mapping_id = aws_smithy_http::label::fmt_string(input_16, false);
                if api_mapping_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_mapping_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/domainnames/{DomainName}/apimappings/{ApiMappingId}",
                    DomainName = domain_name,
                    ApiMappingId = api_mapping_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteApiMappingInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteApiMapping::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteApiMapping",
            "apigatewayv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteApiMappingInput`](crate::input::DeleteApiMappingInput)
    pub fn builder() -> crate::input::delete_api_mapping_input::Builder {
        crate::input::delete_api_mapping_input::Builder::default()
    }
}

/// See [`DeleteAuthorizerInput`](crate::input::DeleteAuthorizerInput)
pub mod delete_authorizer_input {
    /// A builder for [`DeleteAuthorizerInput`](crate::input::DeleteAuthorizerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) authorizer_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The authorizer identifier.</p>
        pub fn authorizer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorizer_id = Some(input.into());
            self
        }
        /// <p>The authorizer identifier.</p>
        pub fn set_authorizer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorizer_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAuthorizerInput`](crate::input::DeleteAuthorizerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAuthorizerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAuthorizerInput {
                api_id: self.api_id,
                authorizer_id: self.authorizer_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAuthorizerInputOperationOutputAlias = crate::operation::DeleteAuthorizer;
#[doc(hidden)]
pub type DeleteAuthorizerInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteAuthorizerInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAuthorizer`](crate::operation::DeleteAuthorizer)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAuthorizer,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteAuthorizerInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_17 = &_input.api_id;
                let input_17 = input_17.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_17, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_18 = &_input.authorizer_id;
                let input_18 = input_18.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "authorizer_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let authorizer_id = aws_smithy_http::label::fmt_string(input_18, false);
                if authorizer_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "authorizer_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/apis/{ApiId}/authorizers/{AuthorizerId}",
                    ApiId = api_id,
                    AuthorizerId = authorizer_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteAuthorizerInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAuthorizer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAuthorizer",
            "apigatewayv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteAuthorizerInput`](crate::input::DeleteAuthorizerInput)
    pub fn builder() -> crate::input::delete_authorizer_input::Builder {
        crate::input::delete_authorizer_input::Builder::default()
    }
}

/// See [`DeleteCorsConfigurationInput`](crate::input::DeleteCorsConfigurationInput)
pub mod delete_cors_configuration_input {
    /// A builder for [`DeleteCorsConfigurationInput`](crate::input::DeleteCorsConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteCorsConfigurationInput`](crate::input::DeleteCorsConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteCorsConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteCorsConfigurationInput {
                api_id: self.api_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteCorsConfigurationInputOperationOutputAlias =
    crate::operation::DeleteCorsConfiguration;
#[doc(hidden)]
pub type DeleteCorsConfigurationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteCorsConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteCorsConfiguration`](crate::operation::DeleteCorsConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteCorsConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteCorsConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_19 = &_input.api_id;
                let input_19 = input_19.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_19, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v2/apis/{ApiId}/cors", ApiId = api_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteCorsConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteCorsConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteCorsConfiguration",
            "apigatewayv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteCorsConfigurationInput`](crate::input::DeleteCorsConfigurationInput)
    pub fn builder() -> crate::input::delete_cors_configuration_input::Builder {
        crate::input::delete_cors_configuration_input::Builder::default()
    }
}

/// See [`DeleteDeploymentInput`](crate::input::DeleteDeploymentInput)
pub mod delete_deployment_input {
    /// A builder for [`DeleteDeploymentInput`](crate::input::DeleteDeploymentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) deployment_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The deployment ID.</p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_id = Some(input.into());
            self
        }
        /// <p>The deployment ID.</p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDeploymentInput`](crate::input::DeleteDeploymentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDeploymentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDeploymentInput {
                api_id: self.api_id,
                deployment_id: self.deployment_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDeploymentInputOperationOutputAlias = crate::operation::DeleteDeployment;
#[doc(hidden)]
pub type DeleteDeploymentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteDeploymentInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDeployment`](crate::operation::DeleteDeployment)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDeployment,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteDeploymentInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_20 = &_input.api_id;
                let input_20 = input_20.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_20, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_21 = &_input.deployment_id;
                let input_21 = input_21.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "deployment_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let deployment_id = aws_smithy_http::label::fmt_string(input_21, false);
                if deployment_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "deployment_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/apis/{ApiId}/deployments/{DeploymentId}",
                    ApiId = api_id,
                    DeploymentId = deployment_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteDeploymentInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDeployment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDeployment",
            "apigatewayv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteDeploymentInput`](crate::input::DeleteDeploymentInput)
    pub fn builder() -> crate::input::delete_deployment_input::Builder {
        crate::input::delete_deployment_input::Builder::default()
    }
}

/// See [`DeleteDomainNameInput`](crate::input::DeleteDomainNameInput)
pub mod delete_domain_name_input {
    /// A builder for [`DeleteDomainNameInput`](crate::input::DeleteDomainNameInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The domain name.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The domain name.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDomainNameInput`](crate::input::DeleteDomainNameInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDomainNameInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDomainNameInput {
                domain_name: self.domain_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDomainNameInputOperationOutputAlias = crate::operation::DeleteDomainName;
#[doc(hidden)]
pub type DeleteDomainNameInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteDomainNameInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDomainName`](crate::operation::DeleteDomainName)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDomainName,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteDomainNameInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_22 = &_input.domain_name;
                let input_22 = input_22.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_22, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/domainnames/{DomainName}",
                    DomainName = domain_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteDomainNameInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDomainName::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDomainName",
            "apigatewayv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteDomainNameInput`](crate::input::DeleteDomainNameInput)
    pub fn builder() -> crate::input::delete_domain_name_input::Builder {
        crate::input::delete_domain_name_input::Builder::default()
    }
}

/// See [`DeleteIntegrationInput`](crate::input::DeleteIntegrationInput)
pub mod delete_integration_input {
    /// A builder for [`DeleteIntegrationInput`](crate::input::DeleteIntegrationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) integration_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The integration ID.</p>
        pub fn integration_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.integration_id = Some(input.into());
            self
        }
        /// <p>The integration ID.</p>
        pub fn set_integration_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.integration_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteIntegrationInput`](crate::input::DeleteIntegrationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteIntegrationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteIntegrationInput {
                api_id: self.api_id,
                integration_id: self.integration_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteIntegrationInputOperationOutputAlias = crate::operation::DeleteIntegration;
#[doc(hidden)]
pub type DeleteIntegrationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteIntegrationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteIntegration`](crate::operation::DeleteIntegration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteIntegration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteIntegrationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_23 = &_input.api_id;
                let input_23 = input_23.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_23, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_24 = &_input.integration_id;
                let input_24 = input_24.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "integration_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let integration_id = aws_smithy_http::label::fmt_string(input_24, false);
                if integration_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "integration_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/apis/{ApiId}/integrations/{IntegrationId}",
                    ApiId = api_id,
                    IntegrationId = integration_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteIntegrationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteIntegration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteIntegration",
            "apigatewayv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteIntegrationInput`](crate::input::DeleteIntegrationInput)
    pub fn builder() -> crate::input::delete_integration_input::Builder {
        crate::input::delete_integration_input::Builder::default()
    }
}

/// See [`DeleteIntegrationResponseInput`](crate::input::DeleteIntegrationResponseInput)
pub mod delete_integration_response_input {
    /// A builder for [`DeleteIntegrationResponseInput`](crate::input::DeleteIntegrationResponseInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) integration_id: std::option::Option<std::string::String>,
        pub(crate) integration_response_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The integration ID.</p>
        pub fn integration_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.integration_id = Some(input.into());
            self
        }
        /// <p>The integration ID.</p>
        pub fn set_integration_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.integration_id = input;
            self
        }
        /// <p>The integration response ID.</p>
        pub fn integration_response_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.integration_response_id = Some(input.into());
            self
        }
        /// <p>The integration response ID.</p>
        pub fn set_integration_response_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.integration_response_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteIntegrationResponseInput`](crate::input::DeleteIntegrationResponseInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteIntegrationResponseInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteIntegrationResponseInput {
                api_id: self.api_id,
                integration_id: self.integration_id,
                integration_response_id: self.integration_response_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteIntegrationResponseInputOperationOutputAlias =
    crate::operation::DeleteIntegrationResponse;
#[doc(hidden)]
pub type DeleteIntegrationResponseInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteIntegrationResponseInput {
    /// Consumes the builder and constructs an Operation<[`DeleteIntegrationResponse`](crate::operation::DeleteIntegrationResponse)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteIntegrationResponse,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteIntegrationResponseInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_25 = &_input.api_id;
                let input_25 = input_25.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_25, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_26 = &_input.integration_id;
                let input_26 = input_26.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "integration_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let integration_id = aws_smithy_http::label::fmt_string(input_26, false);
                if integration_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "integration_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_27 = &_input.integration_response_id;
                let input_27 = input_27.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "integration_response_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let integration_response_id = aws_smithy_http::label::fmt_string(input_27, false);
                if integration_response_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "integration_response_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v2/apis/{ApiId}/integrations/{IntegrationId}/integrationresponses/{IntegrationResponseId}", ApiId = api_id, IntegrationId = integration_id, IntegrationResponseId = integration_response_id).expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteIntegrationResponseInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteIntegrationResponse::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteIntegrationResponse",
            "apigatewayv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteIntegrationResponseInput`](crate::input::DeleteIntegrationResponseInput)
    pub fn builder() -> crate::input::delete_integration_response_input::Builder {
        crate::input::delete_integration_response_input::Builder::default()
    }
}

/// See [`DeleteModelInput`](crate::input::DeleteModelInput)
pub mod delete_model_input {
    /// A builder for [`DeleteModelInput`](crate::input::DeleteModelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) model_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The model ID.</p>
        pub fn model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_id = Some(input.into());
            self
        }
        /// <p>The model ID.</p>
        pub fn set_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.model_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteModelInput`](crate::input::DeleteModelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteModelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteModelInput {
                api_id: self.api_id,
                model_id: self.model_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteModelInputOperationOutputAlias = crate::operation::DeleteModel;
#[doc(hidden)]
pub type DeleteModelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteModelInput {
    /// Consumes the builder and constructs an Operation<[`DeleteModel`](crate::operation::DeleteModel)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteModel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteModelInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_28 = &_input.api_id;
                let input_28 = input_28.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_28, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_29 = &_input.model_id;
                let input_29 = input_29.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "model_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let model_id = aws_smithy_http::label::fmt_string(input_29, false);
                if model_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "model_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/apis/{ApiId}/models/{ModelId}",
                    ApiId = api_id,
                    ModelId = model_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteModelInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteModel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteModel",
            "apigatewayv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteModelInput`](crate::input::DeleteModelInput)
    pub fn builder() -> crate::input::delete_model_input::Builder {
        crate::input::delete_model_input::Builder::default()
    }
}

/// See [`DeleteRouteInput`](crate::input::DeleteRouteInput)
pub mod delete_route_input {
    /// A builder for [`DeleteRouteInput`](crate::input::DeleteRouteInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) route_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The route ID.</p>
        pub fn route_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_id = Some(input.into());
            self
        }
        /// <p>The route ID.</p>
        pub fn set_route_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.route_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRouteInput`](crate::input::DeleteRouteInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteRouteInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteRouteInput {
                api_id: self.api_id,
                route_id: self.route_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteRouteInputOperationOutputAlias = crate::operation::DeleteRoute;
#[doc(hidden)]
pub type DeleteRouteInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteRouteInput {
    /// Consumes the builder and constructs an Operation<[`DeleteRoute`](crate::operation::DeleteRoute)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteRoute,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteRouteInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_30 = &_input.api_id;
                let input_30 = input_30.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_30, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_31 = &_input.route_id;
                let input_31 = input_31.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "route_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let route_id = aws_smithy_http::label::fmt_string(input_31, false);
                if route_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "route_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/apis/{ApiId}/routes/{RouteId}",
                    ApiId = api_id,
                    RouteId = route_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteRouteInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteRoute::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteRoute",
            "apigatewayv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteRouteInput`](crate::input::DeleteRouteInput)
    pub fn builder() -> crate::input::delete_route_input::Builder {
        crate::input::delete_route_input::Builder::default()
    }
}

/// See [`DeleteRouteRequestParameterInput`](crate::input::DeleteRouteRequestParameterInput)
pub mod delete_route_request_parameter_input {
    /// A builder for [`DeleteRouteRequestParameterInput`](crate::input::DeleteRouteRequestParameterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) request_parameter_key: std::option::Option<std::string::String>,
        pub(crate) route_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The route request parameter key.</p>
        pub fn request_parameter_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_parameter_key = Some(input.into());
            self
        }
        /// <p>The route request parameter key.</p>
        pub fn set_request_parameter_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.request_parameter_key = input;
            self
        }
        /// <p>The route ID.</p>
        pub fn route_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_id = Some(input.into());
            self
        }
        /// <p>The route ID.</p>
        pub fn set_route_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.route_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRouteRequestParameterInput`](crate::input::DeleteRouteRequestParameterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteRouteRequestParameterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteRouteRequestParameterInput {
                api_id: self.api_id,
                request_parameter_key: self.request_parameter_key,
                route_id: self.route_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteRouteRequestParameterInputOperationOutputAlias =
    crate::operation::DeleteRouteRequestParameter;
#[doc(hidden)]
pub type DeleteRouteRequestParameterInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteRouteRequestParameterInput {
    /// Consumes the builder and constructs an Operation<[`DeleteRouteRequestParameter`](crate::operation::DeleteRouteRequestParameter)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteRouteRequestParameter,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteRouteRequestParameterInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_32 = &_input.api_id;
                let input_32 = input_32.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_32, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_33 = &_input.route_id;
                let input_33 = input_33.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "route_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let route_id = aws_smithy_http::label::fmt_string(input_33, false);
                if route_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "route_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_34 = &_input.request_parameter_key;
                let input_34 = input_34.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "request_parameter_key",
                        details: "cannot be empty or unset",
                    },
                )?;
                let request_parameter_key = aws_smithy_http::label::fmt_string(input_34, false);
                if request_parameter_key.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "request_parameter_key",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/apis/{ApiId}/routes/{RouteId}/requestparameters/{RequestParameterKey}",
                    ApiId = api_id,
                    RouteId = route_id,
                    RequestParameterKey = request_parameter_key
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteRouteRequestParameterInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteRouteRequestParameter::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteRouteRequestParameter",
            "apigatewayv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteRouteRequestParameterInput`](crate::input::DeleteRouteRequestParameterInput)
    pub fn builder() -> crate::input::delete_route_request_parameter_input::Builder {
        crate::input::delete_route_request_parameter_input::Builder::default()
    }
}

/// See [`DeleteRouteResponseInput`](crate::input::DeleteRouteResponseInput)
pub mod delete_route_response_input {
    /// A builder for [`DeleteRouteResponseInput`](crate::input::DeleteRouteResponseInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) route_id: std::option::Option<std::string::String>,
        pub(crate) route_response_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The route ID.</p>
        pub fn route_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_id = Some(input.into());
            self
        }
        /// <p>The route ID.</p>
        pub fn set_route_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.route_id = input;
            self
        }
        /// <p>The route response ID.</p>
        pub fn route_response_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_response_id = Some(input.into());
            self
        }
        /// <p>The route response ID.</p>
        pub fn set_route_response_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.route_response_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRouteResponseInput`](crate::input::DeleteRouteResponseInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteRouteResponseInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteRouteResponseInput {
                api_id: self.api_id,
                route_id: self.route_id,
                route_response_id: self.route_response_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteRouteResponseInputOperationOutputAlias = crate::operation::DeleteRouteResponse;
#[doc(hidden)]
pub type DeleteRouteResponseInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteRouteResponseInput {
    /// Consumes the builder and constructs an Operation<[`DeleteRouteResponse`](crate::operation::DeleteRouteResponse)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteRouteResponse,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteRouteResponseInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_35 = &_input.api_id;
                let input_35 = input_35.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_35, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_36 = &_input.route_id;
                let input_36 = input_36.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "route_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let route_id = aws_smithy_http::label::fmt_string(input_36, false);
                if route_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "route_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_37 = &_input.route_response_id;
                let input_37 = input_37.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "route_response_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let route_response_id = aws_smithy_http::label::fmt_string(input_37, false);
                if route_response_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "route_response_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/apis/{ApiId}/routes/{RouteId}/routeresponses/{RouteResponseId}",
                    ApiId = api_id,
                    RouteId = route_id,
                    RouteResponseId = route_response_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteRouteResponseInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteRouteResponse::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteRouteResponse",
            "apigatewayv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteRouteResponseInput`](crate::input::DeleteRouteResponseInput)
    pub fn builder() -> crate::input::delete_route_response_input::Builder {
        crate::input::delete_route_response_input::Builder::default()
    }
}

/// See [`DeleteRouteSettingsInput`](crate::input::DeleteRouteSettingsInput)
pub mod delete_route_settings_input {
    /// A builder for [`DeleteRouteSettingsInput`](crate::input::DeleteRouteSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) route_key: std::option::Option<std::string::String>,
        pub(crate) stage_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The route key.</p>
        pub fn route_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_key = Some(input.into());
            self
        }
        /// <p>The route key.</p>
        pub fn set_route_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.route_key = input;
            self
        }
        /// <p>The stage name. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stage_name = Some(input.into());
            self
        }
        /// <p>The stage name. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stage_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRouteSettingsInput`](crate::input::DeleteRouteSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteRouteSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteRouteSettingsInput {
                api_id: self.api_id,
                route_key: self.route_key,
                stage_name: self.stage_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteRouteSettingsInputOperationOutputAlias = crate::operation::DeleteRouteSettings;
#[doc(hidden)]
pub type DeleteRouteSettingsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteRouteSettingsInput {
    /// Consumes the builder and constructs an Operation<[`DeleteRouteSettings`](crate::operation::DeleteRouteSettings)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteRouteSettings,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteRouteSettingsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_38 = &_input.api_id;
                let input_38 = input_38.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_38, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_39 = &_input.stage_name;
                let input_39 = input_39.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "stage_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let stage_name = aws_smithy_http::label::fmt_string(input_39, false);
                if stage_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "stage_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_40 = &_input.route_key;
                let input_40 = input_40.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "route_key",
                        details: "cannot be empty or unset",
                    },
                )?;
                let route_key = aws_smithy_http::label::fmt_string(input_40, false);
                if route_key.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "route_key",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/apis/{ApiId}/stages/{StageName}/routesettings/{RouteKey}",
                    ApiId = api_id,
                    StageName = stage_name,
                    RouteKey = route_key
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteRouteSettingsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteRouteSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteRouteSettings",
            "apigatewayv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteRouteSettingsInput`](crate::input::DeleteRouteSettingsInput)
    pub fn builder() -> crate::input::delete_route_settings_input::Builder {
        crate::input::delete_route_settings_input::Builder::default()
    }
}

/// See [`DeleteStageInput`](crate::input::DeleteStageInput)
pub mod delete_stage_input {
    /// A builder for [`DeleteStageInput`](crate::input::DeleteStageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) stage_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The stage name. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stage_name = Some(input.into());
            self
        }
        /// <p>The stage name. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stage_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteStageInput`](crate::input::DeleteStageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteStageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteStageInput {
                api_id: self.api_id,
                stage_name: self.stage_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteStageInputOperationOutputAlias = crate::operation::DeleteStage;
#[doc(hidden)]
pub type DeleteStageInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteStageInput {
    /// Consumes the builder and constructs an Operation<[`DeleteStage`](crate::operation::DeleteStage)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteStage,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteStageInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_41 = &_input.api_id;
                let input_41 = input_41.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_41, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_42 = &_input.stage_name;
                let input_42 = input_42.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "stage_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let stage_name = aws_smithy_http::label::fmt_string(input_42, false);
                if stage_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "stage_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/apis/{ApiId}/stages/{StageName}",
                    ApiId = api_id,
                    StageName = stage_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteStageInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteStage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteStage",
            "apigatewayv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteStageInput`](crate::input::DeleteStageInput)
    pub fn builder() -> crate::input::delete_stage_input::Builder {
        crate::input::delete_stage_input::Builder::default()
    }
}

/// See [`DeleteVpcLinkInput`](crate::input::DeleteVpcLinkInput)
pub mod delete_vpc_link_input {
    /// A builder for [`DeleteVpcLinkInput`](crate::input::DeleteVpcLinkInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) vpc_link_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the VPC link.</p>
        pub fn vpc_link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_link_id = Some(input.into());
            self
        }
        /// <p>The ID of the VPC link.</p>
        pub fn set_vpc_link_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_link_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteVpcLinkInput`](crate::input::DeleteVpcLinkInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteVpcLinkInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteVpcLinkInput {
                vpc_link_id: self.vpc_link_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteVpcLinkInputOperationOutputAlias = crate::operation::DeleteVpcLink;
#[doc(hidden)]
pub type DeleteVpcLinkInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteVpcLinkInput {
    /// Consumes the builder and constructs an Operation<[`DeleteVpcLink`](crate::operation::DeleteVpcLink)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteVpcLink,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteVpcLinkInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_43 = &_input.vpc_link_id;
                let input_43 = input_43.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "vpc_link_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let vpc_link_id = aws_smithy_http::label::fmt_string(input_43, false);
                if vpc_link_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "vpc_link_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v2/vpclinks/{VpcLinkId}", VpcLinkId = vpc_link_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteVpcLinkInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteVpcLink::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteVpcLink",
            "apigatewayv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteVpcLinkInput`](crate::input::DeleteVpcLinkInput)
    pub fn builder() -> crate::input::delete_vpc_link_input::Builder {
        crate::input::delete_vpc_link_input::Builder::default()
    }
}

/// See [`ExportApiInput`](crate::input::ExportApiInput)
pub mod export_api_input {
    /// A builder for [`ExportApiInput`](crate::input::ExportApiInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) export_version: std::option::Option<std::string::String>,
        pub(crate) include_extensions: std::option::Option<bool>,
        pub(crate) output_type: std::option::Option<std::string::String>,
        pub(crate) specification: std::option::Option<std::string::String>,
        pub(crate) stage_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The version of the API Gateway export algorithm. API Gateway uses the latest version by default. Currently, the only supported version is 1.0.</p>
        pub fn export_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.export_version = Some(input.into());
            self
        }
        /// <p>The version of the API Gateway export algorithm. API Gateway uses the latest version by default. Currently, the only supported version is 1.0.</p>
        pub fn set_export_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.export_version = input;
            self
        }
        /// <p>Specifies whether to include <a href="https://docs.aws.amazon.com//apigateway/latest/developerguide/api-gateway-swagger-extensions.html">API Gateway extensions</a> in the exported API definition. API Gateway extensions are included by default.</p>
        pub fn include_extensions(mut self, input: bool) -> Self {
            self.include_extensions = Some(input);
            self
        }
        /// <p>Specifies whether to include <a href="https://docs.aws.amazon.com//apigateway/latest/developerguide/api-gateway-swagger-extensions.html">API Gateway extensions</a> in the exported API definition. API Gateway extensions are included by default.</p>
        pub fn set_include_extensions(mut self, input: std::option::Option<bool>) -> Self {
            self.include_extensions = input;
            self
        }
        /// <p>The output type of the exported definition file. Valid values are JSON and YAML.</p>
        pub fn output_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.output_type = Some(input.into());
            self
        }
        /// <p>The output type of the exported definition file. Valid values are JSON and YAML.</p>
        pub fn set_output_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.output_type = input;
            self
        }
        /// <p>The version of the API specification to use. OAS30, for OpenAPI 3.0, is the only supported value.</p>
        pub fn specification(mut self, input: impl Into<std::string::String>) -> Self {
            self.specification = Some(input.into());
            self
        }
        /// <p>The version of the API specification to use. OAS30, for OpenAPI 3.0, is the only supported value.</p>
        pub fn set_specification(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.specification = input;
            self
        }
        /// <p>The name of the API stage to export. If you don't specify this property, a representation of the latest API configuration is exported.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stage_name = Some(input.into());
            self
        }
        /// <p>The name of the API stage to export. If you don't specify this property, a representation of the latest API configuration is exported.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stage_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ExportApiInput`](crate::input::ExportApiInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ExportApiInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ExportApiInput {
                api_id: self.api_id,
                export_version: self.export_version,
                include_extensions: self.include_extensions.unwrap_or_default(),
                output_type: self.output_type,
                specification: self.specification,
                stage_name: self.stage_name,
            })
        }
    }
}
#[doc(hidden)]
pub type ExportApiInputOperationOutputAlias = crate::operation::ExportApi;
#[doc(hidden)]
pub type ExportApiInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ExportApiInput {
    /// Consumes the builder and constructs an Operation<[`ExportApi`](crate::operation::ExportApi)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ExportApi,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ExportApiInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_44 = &_input.api_id;
                let input_44 = input_44.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_44, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_45 = &_input.specification;
                let input_45 = input_45.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "specification",
                        details: "cannot be empty or unset",
                    },
                )?;
                let specification = aws_smithy_http::label::fmt_string(input_45, false);
                if specification.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "specification",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/apis/{ApiId}/exports/{Specification}",
                    ApiId = api_id,
                    Specification = specification
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ExportApiInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_46) = &_input.export_version {
                    query.push_kv(
                        "exportVersion",
                        &aws_smithy_http::query::fmt_string(&inner_46),
                    );
                }
                if _input.include_extensions {
                    query.push_kv(
                        "includeExtensions",
                        aws_smithy_types::primitive::Encoder::from(_input.include_extensions)
                            .encode(),
                    );
                }
                if let Some(inner_47) = &_input.output_type {
                    query.push_kv("outputType", &aws_smithy_http::query::fmt_string(&inner_47));
                }
                if let Some(inner_48) = &_input.stage_name {
                    query.push_kv("stageName", &aws_smithy_http::query::fmt_string(&inner_48));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ExportApiInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ExportApi::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "ExportApi",
                    "apigatewayv2",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ExportApiInput`](crate::input::ExportApiInput)
    pub fn builder() -> crate::input::export_api_input::Builder {
        crate::input::export_api_input::Builder::default()
    }
}

/// See [`GetApiInput`](crate::input::GetApiInput)
pub mod get_api_input {
    /// A builder for [`GetApiInput`](crate::input::GetApiInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetApiInput`](crate::input::GetApiInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetApiInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetApiInput {
                api_id: self.api_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetApiInputOperationOutputAlias = crate::operation::GetApi;
#[doc(hidden)]
pub type GetApiInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetApiInput {
    /// Consumes the builder and constructs an Operation<[`GetApi`](crate::operation::GetApi)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetApi,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetApiInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_49 = &_input.api_id;
                let input_49 = input_49.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_49, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v2/apis/{ApiId}", ApiId = api_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetApiInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetApi::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetApi",
                    "apigatewayv2",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetApiInput`](crate::input::GetApiInput)
    pub fn builder() -> crate::input::get_api_input::Builder {
        crate::input::get_api_input::Builder::default()
    }
}

/// See [`GetApiMappingInput`](crate::input::GetApiMappingInput)
pub mod get_api_mapping_input {
    /// A builder for [`GetApiMappingInput`](crate::input::GetApiMappingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_mapping_id: std::option::Option<std::string::String>,
        pub(crate) domain_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API mapping identifier.</p>
        pub fn api_mapping_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_mapping_id = Some(input.into());
            self
        }
        /// <p>The API mapping identifier.</p>
        pub fn set_api_mapping_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.api_mapping_id = input;
            self
        }
        /// <p>The domain name.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The domain name.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetApiMappingInput`](crate::input::GetApiMappingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetApiMappingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetApiMappingInput {
                api_mapping_id: self.api_mapping_id,
                domain_name: self.domain_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetApiMappingInputOperationOutputAlias = crate::operation::GetApiMapping;
#[doc(hidden)]
pub type GetApiMappingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetApiMappingInput {
    /// Consumes the builder and constructs an Operation<[`GetApiMapping`](crate::operation::GetApiMapping)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetApiMapping,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetApiMappingInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_50 = &_input.domain_name;
                let input_50 = input_50.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_50, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_51 = &_input.api_mapping_id;
                let input_51 = input_51.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_mapping_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_mapping_id = aws_smithy_http::label::fmt_string(input_51, false);
                if api_mapping_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_mapping_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/domainnames/{DomainName}/apimappings/{ApiMappingId}",
                    DomainName = domain_name,
                    ApiMappingId = api_mapping_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetApiMappingInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetApiMapping::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetApiMapping",
            "apigatewayv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetApiMappingInput`](crate::input::GetApiMappingInput)
    pub fn builder() -> crate::input::get_api_mapping_input::Builder {
        crate::input::get_api_mapping_input::Builder::default()
    }
}

/// See [`GetApiMappingsInput`](crate::input::GetApiMappingsInput)
pub mod get_api_mappings_input {
    /// A builder for [`GetApiMappingsInput`](crate::input::GetApiMappingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The domain name.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The domain name.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn max_results(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_results = Some(input.into());
            self
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetApiMappingsInput`](crate::input::GetApiMappingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetApiMappingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetApiMappingsInput {
                domain_name: self.domain_name,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetApiMappingsInputOperationOutputAlias = crate::operation::GetApiMappings;
#[doc(hidden)]
pub type GetApiMappingsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetApiMappingsInput {
    /// Consumes the builder and constructs an Operation<[`GetApiMappings`](crate::operation::GetApiMappings)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetApiMappings,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetApiMappingsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_52 = &_input.domain_name;
                let input_52 = input_52.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_52, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/domainnames/{DomainName}/apimappings",
                    DomainName = domain_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetApiMappingsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_53) = &_input.max_results {
                    query.push_kv("maxResults", &aws_smithy_http::query::fmt_string(&inner_53));
                }
                if let Some(inner_54) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_54));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetApiMappingsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetApiMappings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetApiMappings",
            "apigatewayv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetApiMappingsInput`](crate::input::GetApiMappingsInput)
    pub fn builder() -> crate::input::get_api_mappings_input::Builder {
        crate::input::get_api_mappings_input::Builder::default()
    }
}

/// See [`GetApisInput`](crate::input::GetApisInput)
pub mod get_apis_input {
    /// A builder for [`GetApisInput`](crate::input::GetApisInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn max_results(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_results = Some(input.into());
            self
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetApisInput`](crate::input::GetApisInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetApisInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetApisInput {
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetApisInputOperationOutputAlias = crate::operation::GetApis;
#[doc(hidden)]
pub type GetApisInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetApisInput {
    /// Consumes the builder and constructs an Operation<[`GetApis`](crate::operation::GetApis)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetApis,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetApisInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/v2/apis").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetApisInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_55) = &_input.max_results {
                    query.push_kv("maxResults", &aws_smithy_http::query::fmt_string(&inner_55));
                }
                if let Some(inner_56) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_56));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetApisInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetApis::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetApis",
                    "apigatewayv2",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetApisInput`](crate::input::GetApisInput)
    pub fn builder() -> crate::input::get_apis_input::Builder {
        crate::input::get_apis_input::Builder::default()
    }
}

/// See [`GetAuthorizerInput`](crate::input::GetAuthorizerInput)
pub mod get_authorizer_input {
    /// A builder for [`GetAuthorizerInput`](crate::input::GetAuthorizerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) authorizer_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The authorizer identifier.</p>
        pub fn authorizer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorizer_id = Some(input.into());
            self
        }
        /// <p>The authorizer identifier.</p>
        pub fn set_authorizer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorizer_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAuthorizerInput`](crate::input::GetAuthorizerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAuthorizerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAuthorizerInput {
                api_id: self.api_id,
                authorizer_id: self.authorizer_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetAuthorizerInputOperationOutputAlias = crate::operation::GetAuthorizer;
#[doc(hidden)]
pub type GetAuthorizerInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetAuthorizerInput {
    /// Consumes the builder and constructs an Operation<[`GetAuthorizer`](crate::operation::GetAuthorizer)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAuthorizer,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetAuthorizerInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_57 = &_input.api_id;
                let input_57 = input_57.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_57, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_58 = &_input.authorizer_id;
                let input_58 = input_58.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "authorizer_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let authorizer_id = aws_smithy_http::label::fmt_string(input_58, false);
                if authorizer_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "authorizer_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/apis/{ApiId}/authorizers/{AuthorizerId}",
                    ApiId = api_id,
                    AuthorizerId = authorizer_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetAuthorizerInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAuthorizer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAuthorizer",
            "apigatewayv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetAuthorizerInput`](crate::input::GetAuthorizerInput)
    pub fn builder() -> crate::input::get_authorizer_input::Builder {
        crate::input::get_authorizer_input::Builder::default()
    }
}

/// See [`GetAuthorizersInput`](crate::input::GetAuthorizersInput)
pub mod get_authorizers_input {
    /// A builder for [`GetAuthorizersInput`](crate::input::GetAuthorizersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn max_results(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_results = Some(input.into());
            self
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAuthorizersInput`](crate::input::GetAuthorizersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAuthorizersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAuthorizersInput {
                api_id: self.api_id,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetAuthorizersInputOperationOutputAlias = crate::operation::GetAuthorizers;
#[doc(hidden)]
pub type GetAuthorizersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetAuthorizersInput {
    /// Consumes the builder and constructs an Operation<[`GetAuthorizers`](crate::operation::GetAuthorizers)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAuthorizers,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetAuthorizersInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_59 = &_input.api_id;
                let input_59 = input_59.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_59, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v2/apis/{ApiId}/authorizers", ApiId = api_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetAuthorizersInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_60) = &_input.max_results {
                    query.push_kv("maxResults", &aws_smithy_http::query::fmt_string(&inner_60));
                }
                if let Some(inner_61) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_61));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetAuthorizersInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAuthorizers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAuthorizers",
            "apigatewayv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetAuthorizersInput`](crate::input::GetAuthorizersInput)
    pub fn builder() -> crate::input::get_authorizers_input::Builder {
        crate::input::get_authorizers_input::Builder::default()
    }
}

/// See [`GetDeploymentInput`](crate::input::GetDeploymentInput)
pub mod get_deployment_input {
    /// A builder for [`GetDeploymentInput`](crate::input::GetDeploymentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) deployment_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The deployment ID.</p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_id = Some(input.into());
            self
        }
        /// <p>The deployment ID.</p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDeploymentInput`](crate::input::GetDeploymentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDeploymentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDeploymentInput {
                api_id: self.api_id,
                deployment_id: self.deployment_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDeploymentInputOperationOutputAlias = crate::operation::GetDeployment;
#[doc(hidden)]
pub type GetDeploymentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetDeploymentInput {
    /// Consumes the builder and constructs an Operation<[`GetDeployment`](crate::operation::GetDeployment)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDeployment,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetDeploymentInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_62 = &_input.api_id;
                let input_62 = input_62.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_62, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_63 = &_input.deployment_id;
                let input_63 = input_63.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "deployment_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let deployment_id = aws_smithy_http::label::fmt_string(input_63, false);
                if deployment_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "deployment_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/apis/{ApiId}/deployments/{DeploymentId}",
                    ApiId = api_id,
                    DeploymentId = deployment_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetDeploymentInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDeployment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDeployment",
            "apigatewayv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetDeploymentInput`](crate::input::GetDeploymentInput)
    pub fn builder() -> crate::input::get_deployment_input::Builder {
        crate::input::get_deployment_input::Builder::default()
    }
}

/// See [`GetDeploymentsInput`](crate::input::GetDeploymentsInput)
pub mod get_deployments_input {
    /// A builder for [`GetDeploymentsInput`](crate::input::GetDeploymentsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn max_results(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_results = Some(input.into());
            self
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDeploymentsInput`](crate::input::GetDeploymentsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDeploymentsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDeploymentsInput {
                api_id: self.api_id,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDeploymentsInputOperationOutputAlias = crate::operation::GetDeployments;
#[doc(hidden)]
pub type GetDeploymentsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetDeploymentsInput {
    /// Consumes the builder and constructs an Operation<[`GetDeployments`](crate::operation::GetDeployments)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDeployments,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetDeploymentsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_64 = &_input.api_id;
                let input_64 = input_64.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_64, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v2/apis/{ApiId}/deployments", ApiId = api_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetDeploymentsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_65) = &_input.max_results {
                    query.push_kv("maxResults", &aws_smithy_http::query::fmt_string(&inner_65));
                }
                if let Some(inner_66) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_66));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetDeploymentsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDeployments::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDeployments",
            "apigatewayv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetDeploymentsInput`](crate::input::GetDeploymentsInput)
    pub fn builder() -> crate::input::get_deployments_input::Builder {
        crate::input::get_deployments_input::Builder::default()
    }
}

/// See [`GetDomainNameInput`](crate::input::GetDomainNameInput)
pub mod get_domain_name_input {
    /// A builder for [`GetDomainNameInput`](crate::input::GetDomainNameInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The domain name.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The domain name.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDomainNameInput`](crate::input::GetDomainNameInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDomainNameInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDomainNameInput {
                domain_name: self.domain_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDomainNameInputOperationOutputAlias = crate::operation::GetDomainName;
#[doc(hidden)]
pub type GetDomainNameInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetDomainNameInput {
    /// Consumes the builder and constructs an Operation<[`GetDomainName`](crate::operation::GetDomainName)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDomainName,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetDomainNameInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_67 = &_input.domain_name;
                let input_67 = input_67.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_67, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/domainnames/{DomainName}",
                    DomainName = domain_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetDomainNameInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDomainName::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDomainName",
            "apigatewayv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetDomainNameInput`](crate::input::GetDomainNameInput)
    pub fn builder() -> crate::input::get_domain_name_input::Builder {
        crate::input::get_domain_name_input::Builder::default()
    }
}

/// See [`GetDomainNamesInput`](crate::input::GetDomainNamesInput)
pub mod get_domain_names_input {
    /// A builder for [`GetDomainNamesInput`](crate::input::GetDomainNamesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn max_results(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_results = Some(input.into());
            self
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDomainNamesInput`](crate::input::GetDomainNamesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDomainNamesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDomainNamesInput {
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDomainNamesInputOperationOutputAlias = crate::operation::GetDomainNames;
#[doc(hidden)]
pub type GetDomainNamesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetDomainNamesInput {
    /// Consumes the builder and constructs an Operation<[`GetDomainNames`](crate::operation::GetDomainNames)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDomainNames,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetDomainNamesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/v2/domainnames").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetDomainNamesInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_68) = &_input.max_results {
                    query.push_kv("maxResults", &aws_smithy_http::query::fmt_string(&inner_68));
                }
                if let Some(inner_69) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_69));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetDomainNamesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDomainNames::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDomainNames",
            "apigatewayv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetDomainNamesInput`](crate::input::GetDomainNamesInput)
    pub fn builder() -> crate::input::get_domain_names_input::Builder {
        crate::input::get_domain_names_input::Builder::default()
    }
}

/// See [`GetIntegrationInput`](crate::input::GetIntegrationInput)
pub mod get_integration_input {
    /// A builder for [`GetIntegrationInput`](crate::input::GetIntegrationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) integration_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The integration ID.</p>
        pub fn integration_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.integration_id = Some(input.into());
            self
        }
        /// <p>The integration ID.</p>
        pub fn set_integration_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.integration_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetIntegrationInput`](crate::input::GetIntegrationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetIntegrationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetIntegrationInput {
                api_id: self.api_id,
                integration_id: self.integration_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetIntegrationInputOperationOutputAlias = crate::operation::GetIntegration;
#[doc(hidden)]
pub type GetIntegrationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetIntegrationInput {
    /// Consumes the builder and constructs an Operation<[`GetIntegration`](crate::operation::GetIntegration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetIntegration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetIntegrationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_70 = &_input.api_id;
                let input_70 = input_70.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_70, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_71 = &_input.integration_id;
                let input_71 = input_71.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "integration_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let integration_id = aws_smithy_http::label::fmt_string(input_71, false);
                if integration_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "integration_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/apis/{ApiId}/integrations/{IntegrationId}",
                    ApiId = api_id,
                    IntegrationId = integration_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetIntegrationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetIntegration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetIntegration",
            "apigatewayv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetIntegrationInput`](crate::input::GetIntegrationInput)
    pub fn builder() -> crate::input::get_integration_input::Builder {
        crate::input::get_integration_input::Builder::default()
    }
}

/// See [`GetIntegrationResponseInput`](crate::input::GetIntegrationResponseInput)
pub mod get_integration_response_input {
    /// A builder for [`GetIntegrationResponseInput`](crate::input::GetIntegrationResponseInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) integration_id: std::option::Option<std::string::String>,
        pub(crate) integration_response_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The integration ID.</p>
        pub fn integration_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.integration_id = Some(input.into());
            self
        }
        /// <p>The integration ID.</p>
        pub fn set_integration_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.integration_id = input;
            self
        }
        /// <p>The integration response ID.</p>
        pub fn integration_response_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.integration_response_id = Some(input.into());
            self
        }
        /// <p>The integration response ID.</p>
        pub fn set_integration_response_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.integration_response_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetIntegrationResponseInput`](crate::input::GetIntegrationResponseInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetIntegrationResponseInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetIntegrationResponseInput {
                api_id: self.api_id,
                integration_id: self.integration_id,
                integration_response_id: self.integration_response_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetIntegrationResponseInputOperationOutputAlias = crate::operation::GetIntegrationResponse;
#[doc(hidden)]
pub type GetIntegrationResponseInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetIntegrationResponseInput {
    /// Consumes the builder and constructs an Operation<[`GetIntegrationResponse`](crate::operation::GetIntegrationResponse)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetIntegrationResponse,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetIntegrationResponseInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_72 = &_input.api_id;
                let input_72 = input_72.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_72, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_73 = &_input.integration_id;
                let input_73 = input_73.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "integration_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let integration_id = aws_smithy_http::label::fmt_string(input_73, false);
                if integration_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "integration_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_74 = &_input.integration_response_id;
                let input_74 = input_74.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "integration_response_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let integration_response_id = aws_smithy_http::label::fmt_string(input_74, false);
                if integration_response_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "integration_response_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v2/apis/{ApiId}/integrations/{IntegrationId}/integrationresponses/{IntegrationResponseId}", ApiId = api_id, IntegrationId = integration_id, IntegrationResponseId = integration_response_id).expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetIntegrationResponseInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetIntegrationResponse::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetIntegrationResponse",
            "apigatewayv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetIntegrationResponseInput`](crate::input::GetIntegrationResponseInput)
    pub fn builder() -> crate::input::get_integration_response_input::Builder {
        crate::input::get_integration_response_input::Builder::default()
    }
}

/// See [`GetIntegrationResponsesInput`](crate::input::GetIntegrationResponsesInput)
pub mod get_integration_responses_input {
    /// A builder for [`GetIntegrationResponsesInput`](crate::input::GetIntegrationResponsesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) integration_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The integration ID.</p>
        pub fn integration_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.integration_id = Some(input.into());
            self
        }
        /// <p>The integration ID.</p>
        pub fn set_integration_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.integration_id = input;
            self
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn max_results(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_results = Some(input.into());
            self
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetIntegrationResponsesInput`](crate::input::GetIntegrationResponsesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetIntegrationResponsesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetIntegrationResponsesInput {
                api_id: self.api_id,
                integration_id: self.integration_id,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetIntegrationResponsesInputOperationOutputAlias =
    crate::operation::GetIntegrationResponses;
#[doc(hidden)]
pub type GetIntegrationResponsesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetIntegrationResponsesInput {
    /// Consumes the builder and constructs an Operation<[`GetIntegrationResponses`](crate::operation::GetIntegrationResponses)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetIntegrationResponses,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetIntegrationResponsesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_75 = &_input.api_id;
                let input_75 = input_75.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_75, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_76 = &_input.integration_id;
                let input_76 = input_76.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "integration_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let integration_id = aws_smithy_http::label::fmt_string(input_76, false);
                if integration_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "integration_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/apis/{ApiId}/integrations/{IntegrationId}/integrationresponses",
                    ApiId = api_id,
                    IntegrationId = integration_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetIntegrationResponsesInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_77) = &_input.max_results {
                    query.push_kv("maxResults", &aws_smithy_http::query::fmt_string(&inner_77));
                }
                if let Some(inner_78) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_78));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetIntegrationResponsesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetIntegrationResponses::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetIntegrationResponses",
            "apigatewayv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetIntegrationResponsesInput`](crate::input::GetIntegrationResponsesInput)
    pub fn builder() -> crate::input::get_integration_responses_input::Builder {
        crate::input::get_integration_responses_input::Builder::default()
    }
}

/// See [`GetIntegrationsInput`](crate::input::GetIntegrationsInput)
pub mod get_integrations_input {
    /// A builder for [`GetIntegrationsInput`](crate::input::GetIntegrationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn max_results(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_results = Some(input.into());
            self
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetIntegrationsInput`](crate::input::GetIntegrationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetIntegrationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetIntegrationsInput {
                api_id: self.api_id,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetIntegrationsInputOperationOutputAlias = crate::operation::GetIntegrations;
#[doc(hidden)]
pub type GetIntegrationsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetIntegrationsInput {
    /// Consumes the builder and constructs an Operation<[`GetIntegrations`](crate::operation::GetIntegrations)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetIntegrations,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetIntegrationsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_79 = &_input.api_id;
                let input_79 = input_79.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_79, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v2/apis/{ApiId}/integrations", ApiId = api_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetIntegrationsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_80) = &_input.max_results {
                    query.push_kv("maxResults", &aws_smithy_http::query::fmt_string(&inner_80));
                }
                if let Some(inner_81) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_81));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetIntegrationsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetIntegrations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetIntegrations",
            "apigatewayv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetIntegrationsInput`](crate::input::GetIntegrationsInput)
    pub fn builder() -> crate::input::get_integrations_input::Builder {
        crate::input::get_integrations_input::Builder::default()
    }
}

/// See [`GetModelInput`](crate::input::GetModelInput)
pub mod get_model_input {
    /// A builder for [`GetModelInput`](crate::input::GetModelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) model_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The model ID.</p>
        pub fn model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_id = Some(input.into());
            self
        }
        /// <p>The model ID.</p>
        pub fn set_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.model_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetModelInput`](crate::input::GetModelInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetModelInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetModelInput {
                api_id: self.api_id,
                model_id: self.model_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetModelInputOperationOutputAlias = crate::operation::GetModel;
#[doc(hidden)]
pub type GetModelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetModelInput {
    /// Consumes the builder and constructs an Operation<[`GetModel`](crate::operation::GetModel)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetModel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetModelInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_82 = &_input.api_id;
                let input_82 = input_82.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_82, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_83 = &_input.model_id;
                let input_83 = input_83.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "model_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let model_id = aws_smithy_http::label::fmt_string(input_83, false);
                if model_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "model_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/apis/{ApiId}/models/{ModelId}",
                    ApiId = api_id,
                    ModelId = model_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetModelInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetModel::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetModel",
                    "apigatewayv2",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetModelInput`](crate::input::GetModelInput)
    pub fn builder() -> crate::input::get_model_input::Builder {
        crate::input::get_model_input::Builder::default()
    }
}

/// See [`GetModelsInput`](crate::input::GetModelsInput)
pub mod get_models_input {
    /// A builder for [`GetModelsInput`](crate::input::GetModelsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn max_results(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_results = Some(input.into());
            self
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetModelsInput`](crate::input::GetModelsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetModelsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetModelsInput {
                api_id: self.api_id,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetModelsInputOperationOutputAlias = crate::operation::GetModels;
#[doc(hidden)]
pub type GetModelsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetModelsInput {
    /// Consumes the builder and constructs an Operation<[`GetModels`](crate::operation::GetModels)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetModels,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetModelsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_84 = &_input.api_id;
                let input_84 = input_84.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_84, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v2/apis/{ApiId}/models", ApiId = api_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetModelsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_85) = &_input.max_results {
                    query.push_kv("maxResults", &aws_smithy_http::query::fmt_string(&inner_85));
                }
                if let Some(inner_86) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_86));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetModelsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetModels::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetModels",
                    "apigatewayv2",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetModelsInput`](crate::input::GetModelsInput)
    pub fn builder() -> crate::input::get_models_input::Builder {
        crate::input::get_models_input::Builder::default()
    }
}

/// See [`GetModelTemplateInput`](crate::input::GetModelTemplateInput)
pub mod get_model_template_input {
    /// A builder for [`GetModelTemplateInput`](crate::input::GetModelTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) model_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The model ID.</p>
        pub fn model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_id = Some(input.into());
            self
        }
        /// <p>The model ID.</p>
        pub fn set_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.model_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetModelTemplateInput`](crate::input::GetModelTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetModelTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetModelTemplateInput {
                api_id: self.api_id,
                model_id: self.model_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetModelTemplateInputOperationOutputAlias = crate::operation::GetModelTemplate;
#[doc(hidden)]
pub type GetModelTemplateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetModelTemplateInput {
    /// Consumes the builder and constructs an Operation<[`GetModelTemplate`](crate::operation::GetModelTemplate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetModelTemplate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetModelTemplateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_87 = &_input.api_id;
                let input_87 = input_87.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_87, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_88 = &_input.model_id;
                let input_88 = input_88.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "model_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let model_id = aws_smithy_http::label::fmt_string(input_88, false);
                if model_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "model_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/apis/{ApiId}/models/{ModelId}/template",
                    ApiId = api_id,
                    ModelId = model_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetModelTemplateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetModelTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetModelTemplate",
            "apigatewayv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetModelTemplateInput`](crate::input::GetModelTemplateInput)
    pub fn builder() -> crate::input::get_model_template_input::Builder {
        crate::input::get_model_template_input::Builder::default()
    }
}

/// See [`GetRouteInput`](crate::input::GetRouteInput)
pub mod get_route_input {
    /// A builder for [`GetRouteInput`](crate::input::GetRouteInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) route_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The route ID.</p>
        pub fn route_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_id = Some(input.into());
            self
        }
        /// <p>The route ID.</p>
        pub fn set_route_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.route_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRouteInput`](crate::input::GetRouteInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetRouteInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetRouteInput {
                api_id: self.api_id,
                route_id: self.route_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetRouteInputOperationOutputAlias = crate::operation::GetRoute;
#[doc(hidden)]
pub type GetRouteInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetRouteInput {
    /// Consumes the builder and constructs an Operation<[`GetRoute`](crate::operation::GetRoute)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetRoute,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetRouteInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_89 = &_input.api_id;
                let input_89 = input_89.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_89, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_90 = &_input.route_id;
                let input_90 = input_90.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "route_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let route_id = aws_smithy_http::label::fmt_string(input_90, false);
                if route_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "route_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/apis/{ApiId}/routes/{RouteId}",
                    ApiId = api_id,
                    RouteId = route_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetRouteInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetRoute::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetRoute",
                    "apigatewayv2",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetRouteInput`](crate::input::GetRouteInput)
    pub fn builder() -> crate::input::get_route_input::Builder {
        crate::input::get_route_input::Builder::default()
    }
}

/// See [`GetRouteResponseInput`](crate::input::GetRouteResponseInput)
pub mod get_route_response_input {
    /// A builder for [`GetRouteResponseInput`](crate::input::GetRouteResponseInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) route_id: std::option::Option<std::string::String>,
        pub(crate) route_response_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The route ID.</p>
        pub fn route_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_id = Some(input.into());
            self
        }
        /// <p>The route ID.</p>
        pub fn set_route_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.route_id = input;
            self
        }
        /// <p>The route response ID.</p>
        pub fn route_response_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_response_id = Some(input.into());
            self
        }
        /// <p>The route response ID.</p>
        pub fn set_route_response_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.route_response_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRouteResponseInput`](crate::input::GetRouteResponseInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetRouteResponseInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetRouteResponseInput {
                api_id: self.api_id,
                route_id: self.route_id,
                route_response_id: self.route_response_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetRouteResponseInputOperationOutputAlias = crate::operation::GetRouteResponse;
#[doc(hidden)]
pub type GetRouteResponseInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetRouteResponseInput {
    /// Consumes the builder and constructs an Operation<[`GetRouteResponse`](crate::operation::GetRouteResponse)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetRouteResponse,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetRouteResponseInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_91 = &_input.api_id;
                let input_91 = input_91.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_91, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_92 = &_input.route_id;
                let input_92 = input_92.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "route_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let route_id = aws_smithy_http::label::fmt_string(input_92, false);
                if route_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "route_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_93 = &_input.route_response_id;
                let input_93 = input_93.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "route_response_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let route_response_id = aws_smithy_http::label::fmt_string(input_93, false);
                if route_response_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "route_response_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/apis/{ApiId}/routes/{RouteId}/routeresponses/{RouteResponseId}",
                    ApiId = api_id,
                    RouteId = route_id,
                    RouteResponseId = route_response_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetRouteResponseInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetRouteResponse::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetRouteResponse",
            "apigatewayv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetRouteResponseInput`](crate::input::GetRouteResponseInput)
    pub fn builder() -> crate::input::get_route_response_input::Builder {
        crate::input::get_route_response_input::Builder::default()
    }
}

/// See [`GetRouteResponsesInput`](crate::input::GetRouteResponsesInput)
pub mod get_route_responses_input {
    /// A builder for [`GetRouteResponsesInput`](crate::input::GetRouteResponsesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) route_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn max_results(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_results = Some(input.into());
            self
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The route ID.</p>
        pub fn route_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_id = Some(input.into());
            self
        }
        /// <p>The route ID.</p>
        pub fn set_route_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.route_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRouteResponsesInput`](crate::input::GetRouteResponsesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetRouteResponsesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetRouteResponsesInput {
                api_id: self.api_id,
                max_results: self.max_results,
                next_token: self.next_token,
                route_id: self.route_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetRouteResponsesInputOperationOutputAlias = crate::operation::GetRouteResponses;
#[doc(hidden)]
pub type GetRouteResponsesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetRouteResponsesInput {
    /// Consumes the builder and constructs an Operation<[`GetRouteResponses`](crate::operation::GetRouteResponses)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetRouteResponses,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetRouteResponsesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_94 = &_input.api_id;
                let input_94 = input_94.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_94, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_95 = &_input.route_id;
                let input_95 = input_95.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "route_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let route_id = aws_smithy_http::label::fmt_string(input_95, false);
                if route_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "route_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/apis/{ApiId}/routes/{RouteId}/routeresponses",
                    ApiId = api_id,
                    RouteId = route_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetRouteResponsesInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_96) = &_input.max_results {
                    query.push_kv("maxResults", &aws_smithy_http::query::fmt_string(&inner_96));
                }
                if let Some(inner_97) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_97));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetRouteResponsesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetRouteResponses::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetRouteResponses",
            "apigatewayv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetRouteResponsesInput`](crate::input::GetRouteResponsesInput)
    pub fn builder() -> crate::input::get_route_responses_input::Builder {
        crate::input::get_route_responses_input::Builder::default()
    }
}

/// See [`GetRoutesInput`](crate::input::GetRoutesInput)
pub mod get_routes_input {
    /// A builder for [`GetRoutesInput`](crate::input::GetRoutesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn max_results(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_results = Some(input.into());
            self
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRoutesInput`](crate::input::GetRoutesInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetRoutesInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetRoutesInput {
                api_id: self.api_id,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetRoutesInputOperationOutputAlias = crate::operation::GetRoutes;
#[doc(hidden)]
pub type GetRoutesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetRoutesInput {
    /// Consumes the builder and constructs an Operation<[`GetRoutes`](crate::operation::GetRoutes)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetRoutes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetRoutesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_98 = &_input.api_id;
                let input_98 = input_98.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_98, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v2/apis/{ApiId}/routes", ApiId = api_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetRoutesInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_99) = &_input.max_results {
                    query.push_kv("maxResults", &aws_smithy_http::query::fmt_string(&inner_99));
                }
                if let Some(inner_100) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_100));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetRoutesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetRoutes::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetRoutes",
                    "apigatewayv2",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetRoutesInput`](crate::input::GetRoutesInput)
    pub fn builder() -> crate::input::get_routes_input::Builder {
        crate::input::get_routes_input::Builder::default()
    }
}

/// See [`GetStageInput`](crate::input::GetStageInput)
pub mod get_stage_input {
    /// A builder for [`GetStageInput`](crate::input::GetStageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) stage_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The stage name. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stage_name = Some(input.into());
            self
        }
        /// <p>The stage name. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stage_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetStageInput`](crate::input::GetStageInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetStageInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetStageInput {
                api_id: self.api_id,
                stage_name: self.stage_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetStageInputOperationOutputAlias = crate::operation::GetStage;
#[doc(hidden)]
pub type GetStageInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetStageInput {
    /// Consumes the builder and constructs an Operation<[`GetStage`](crate::operation::GetStage)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetStage,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetStageInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_101 = &_input.api_id;
                let input_101 = input_101.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_101, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_102 = &_input.stage_name;
                let input_102 = input_102.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "stage_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let stage_name = aws_smithy_http::label::fmt_string(input_102, false);
                if stage_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "stage_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/apis/{ApiId}/stages/{StageName}",
                    ApiId = api_id,
                    StageName = stage_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetStageInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetStage::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetStage",
                    "apigatewayv2",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetStageInput`](crate::input::GetStageInput)
    pub fn builder() -> crate::input::get_stage_input::Builder {
        crate::input::get_stage_input::Builder::default()
    }
}

/// See [`GetStagesInput`](crate::input::GetStagesInput)
pub mod get_stages_input {
    /// A builder for [`GetStagesInput`](crate::input::GetStagesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn max_results(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_results = Some(input.into());
            self
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetStagesInput`](crate::input::GetStagesInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetStagesInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetStagesInput {
                api_id: self.api_id,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetStagesInputOperationOutputAlias = crate::operation::GetStages;
#[doc(hidden)]
pub type GetStagesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetStagesInput {
    /// Consumes the builder and constructs an Operation<[`GetStages`](crate::operation::GetStages)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetStages,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetStagesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_103 = &_input.api_id;
                let input_103 = input_103.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_103, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v2/apis/{ApiId}/stages", ApiId = api_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetStagesInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_104) = &_input.max_results {
                    query.push_kv(
                        "maxResults",
                        &aws_smithy_http::query::fmt_string(&inner_104),
                    );
                }
                if let Some(inner_105) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_105));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetStagesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetStages::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetStages",
                    "apigatewayv2",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetStagesInput`](crate::input::GetStagesInput)
    pub fn builder() -> crate::input::get_stages_input::Builder {
        crate::input::get_stages_input::Builder::default()
    }
}

/// See [`GetTagsInput`](crate::input::GetTagsInput)
pub mod get_tags_input {
    /// A builder for [`GetTagsInput`](crate::input::GetTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The resource ARN for the tag.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The resource ARN for the tag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTagsInput`](crate::input::GetTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetTagsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetTagsInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetTagsInputOperationOutputAlias = crate::operation::GetTags;
#[doc(hidden)]
pub type GetTagsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetTagsInput {
    /// Consumes the builder and constructs an Operation<[`GetTags`](crate::operation::GetTags)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetTags,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetTagsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_106 = &_input.resource_arn;
                let input_106 = input_106.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_arn = aws_smithy_http::label::fmt_string(input_106, false);
                if resource_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v2/tags/{ResourceArn}", ResourceArn = resource_arn)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetTagsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetTags::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetTags",
                    "apigatewayv2",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetTagsInput`](crate::input::GetTagsInput)
    pub fn builder() -> crate::input::get_tags_input::Builder {
        crate::input::get_tags_input::Builder::default()
    }
}

/// See [`GetVpcLinkInput`](crate::input::GetVpcLinkInput)
pub mod get_vpc_link_input {
    /// A builder for [`GetVpcLinkInput`](crate::input::GetVpcLinkInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) vpc_link_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the VPC link.</p>
        pub fn vpc_link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_link_id = Some(input.into());
            self
        }
        /// <p>The ID of the VPC link.</p>
        pub fn set_vpc_link_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_link_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetVpcLinkInput`](crate::input::GetVpcLinkInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetVpcLinkInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetVpcLinkInput {
                vpc_link_id: self.vpc_link_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetVpcLinkInputOperationOutputAlias = crate::operation::GetVpcLink;
#[doc(hidden)]
pub type GetVpcLinkInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetVpcLinkInput {
    /// Consumes the builder and constructs an Operation<[`GetVpcLink`](crate::operation::GetVpcLink)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetVpcLink,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetVpcLinkInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_107 = &_input.vpc_link_id;
                let input_107 = input_107.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "vpc_link_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let vpc_link_id = aws_smithy_http::label::fmt_string(input_107, false);
                if vpc_link_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "vpc_link_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v2/vpclinks/{VpcLinkId}", VpcLinkId = vpc_link_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetVpcLinkInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetVpcLink::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetVpcLink",
            "apigatewayv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetVpcLinkInput`](crate::input::GetVpcLinkInput)
    pub fn builder() -> crate::input::get_vpc_link_input::Builder {
        crate::input::get_vpc_link_input::Builder::default()
    }
}

/// See [`GetVpcLinksInput`](crate::input::GetVpcLinksInput)
pub mod get_vpc_links_input {
    /// A builder for [`GetVpcLinksInput`](crate::input::GetVpcLinksInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn max_results(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_results = Some(input.into());
            self
        }
        /// <p>The maximum number of elements to be returned for this resource.</p>
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetVpcLinksInput`](crate::input::GetVpcLinksInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetVpcLinksInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetVpcLinksInput {
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetVpcLinksInputOperationOutputAlias = crate::operation::GetVpcLinks;
#[doc(hidden)]
pub type GetVpcLinksInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetVpcLinksInput {
    /// Consumes the builder and constructs an Operation<[`GetVpcLinks`](crate::operation::GetVpcLinks)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetVpcLinks,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetVpcLinksInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/v2/vpclinks").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetVpcLinksInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_108) = &_input.max_results {
                    query.push_kv(
                        "maxResults",
                        &aws_smithy_http::query::fmt_string(&inner_108),
                    );
                }
                if let Some(inner_109) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_109));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetVpcLinksInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetVpcLinks::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetVpcLinks",
            "apigatewayv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetVpcLinksInput`](crate::input::GetVpcLinksInput)
    pub fn builder() -> crate::input::get_vpc_links_input::Builder {
        crate::input::get_vpc_links_input::Builder::default()
    }
}

/// See [`ImportApiInput`](crate::input::ImportApiInput)
pub mod import_api_input {
    /// A builder for [`ImportApiInput`](crate::input::ImportApiInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) basepath: std::option::Option<std::string::String>,
        pub(crate) body: std::option::Option<std::string::String>,
        pub(crate) fail_on_warnings: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Specifies how to interpret the base path of the API during import. Valid values are ignore, prepend, and split. The default value is ignore. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-import-api-basePath.html">Set the OpenAPI basePath Property</a>. Supported only for HTTP APIs.</p>
        pub fn basepath(mut self, input: impl Into<std::string::String>) -> Self {
            self.basepath = Some(input.into());
            self
        }
        /// <p>Specifies how to interpret the base path of the API during import. Valid values are ignore, prepend, and split. The default value is ignore. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-import-api-basePath.html">Set the OpenAPI basePath Property</a>. Supported only for HTTP APIs.</p>
        pub fn set_basepath(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.basepath = input;
            self
        }
        /// <p>The OpenAPI definition. Supported only for HTTP APIs.</p>
        pub fn body(mut self, input: impl Into<std::string::String>) -> Self {
            self.body = Some(input.into());
            self
        }
        /// <p>The OpenAPI definition. Supported only for HTTP APIs.</p>
        pub fn set_body(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.body = input;
            self
        }
        /// <p>Specifies whether to rollback the API creation when a warning is encountered. By default, API creation continues if a warning is encountered.</p>
        pub fn fail_on_warnings(mut self, input: bool) -> Self {
            self.fail_on_warnings = Some(input);
            self
        }
        /// <p>Specifies whether to rollback the API creation when a warning is encountered. By default, API creation continues if a warning is encountered.</p>
        pub fn set_fail_on_warnings(mut self, input: std::option::Option<bool>) -> Self {
            self.fail_on_warnings = input;
            self
        }
        /// Consumes the builder and constructs a [`ImportApiInput`](crate::input::ImportApiInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ImportApiInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ImportApiInput {
                basepath: self.basepath,
                body: self.body,
                fail_on_warnings: self.fail_on_warnings.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ImportApiInputOperationOutputAlias = crate::operation::ImportApi;
#[doc(hidden)]
pub type ImportApiInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ImportApiInput {
    /// Consumes the builder and constructs an Operation<[`ImportApi`](crate::operation::ImportApi)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ImportApi,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ImportApiInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/v2/apis").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ImportApiInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_110) = &_input.basepath {
                    query.push_kv("basepath", &aws_smithy_http::query::fmt_string(&inner_110));
                }
                if _input.fail_on_warnings {
                    query.push_kv(
                        "failOnWarnings",
                        aws_smithy_types::primitive::Encoder::from(_input.fail_on_warnings)
                            .encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ImportApiInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_import_api(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ImportApi::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "ImportApi",
                    "apigatewayv2",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ImportApiInput`](crate::input::ImportApiInput)
    pub fn builder() -> crate::input::import_api_input::Builder {
        crate::input::import_api_input::Builder::default()
    }
}

/// See [`ReimportApiInput`](crate::input::ReimportApiInput)
pub mod reimport_api_input {
    /// A builder for [`ReimportApiInput`](crate::input::ReimportApiInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) basepath: std::option::Option<std::string::String>,
        pub(crate) body: std::option::Option<std::string::String>,
        pub(crate) fail_on_warnings: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>Specifies how to interpret the base path of the API during import. Valid values are ignore, prepend, and split. The default value is ignore. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-import-api-basePath.html">Set the OpenAPI basePath Property</a>. Supported only for HTTP APIs.</p>
        pub fn basepath(mut self, input: impl Into<std::string::String>) -> Self {
            self.basepath = Some(input.into());
            self
        }
        /// <p>Specifies how to interpret the base path of the API during import. Valid values are ignore, prepend, and split. The default value is ignore. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-import-api-basePath.html">Set the OpenAPI basePath Property</a>. Supported only for HTTP APIs.</p>
        pub fn set_basepath(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.basepath = input;
            self
        }
        /// <p>The OpenAPI definition. Supported only for HTTP APIs.</p>
        pub fn body(mut self, input: impl Into<std::string::String>) -> Self {
            self.body = Some(input.into());
            self
        }
        /// <p>The OpenAPI definition. Supported only for HTTP APIs.</p>
        pub fn set_body(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.body = input;
            self
        }
        /// <p>Specifies whether to rollback the API creation when a warning is encountered. By default, API creation continues if a warning is encountered.</p>
        pub fn fail_on_warnings(mut self, input: bool) -> Self {
            self.fail_on_warnings = Some(input);
            self
        }
        /// <p>Specifies whether to rollback the API creation when a warning is encountered. By default, API creation continues if a warning is encountered.</p>
        pub fn set_fail_on_warnings(mut self, input: std::option::Option<bool>) -> Self {
            self.fail_on_warnings = input;
            self
        }
        /// Consumes the builder and constructs a [`ReimportApiInput`](crate::input::ReimportApiInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ReimportApiInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ReimportApiInput {
                api_id: self.api_id,
                basepath: self.basepath,
                body: self.body,
                fail_on_warnings: self.fail_on_warnings.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ReimportApiInputOperationOutputAlias = crate::operation::ReimportApi;
#[doc(hidden)]
pub type ReimportApiInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ReimportApiInput {
    /// Consumes the builder and constructs an Operation<[`ReimportApi`](crate::operation::ReimportApi)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ReimportApi,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ReimportApiInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_111 = &_input.api_id;
                let input_111 = input_111.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_111, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v2/apis/{ApiId}", ApiId = api_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ReimportApiInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_112) = &_input.basepath {
                    query.push_kv("basepath", &aws_smithy_http::query::fmt_string(&inner_112));
                }
                if _input.fail_on_warnings {
                    query.push_kv(
                        "failOnWarnings",
                        aws_smithy_types::primitive::Encoder::from(_input.fail_on_warnings)
                            .encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ReimportApiInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_reimport_api(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ReimportApi::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ReimportApi",
            "apigatewayv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ReimportApiInput`](crate::input::ReimportApiInput)
    pub fn builder() -> crate::input::reimport_api_input::Builder {
        crate::input::reimport_api_input::Builder::default()
    }
}

/// See [`ResetAuthorizersCacheInput`](crate::input::ResetAuthorizersCacheInput)
pub mod reset_authorizers_cache_input {
    /// A builder for [`ResetAuthorizersCacheInput`](crate::input::ResetAuthorizersCacheInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) stage_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The stage name. Stage names can contain only alphanumeric characters, hyphens, and underscores, or be $default. Maximum length is 128 characters.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stage_name = Some(input.into());
            self
        }
        /// <p>The stage name. Stage names can contain only alphanumeric characters, hyphens, and underscores, or be $default. Maximum length is 128 characters.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stage_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ResetAuthorizersCacheInput`](crate::input::ResetAuthorizersCacheInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ResetAuthorizersCacheInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ResetAuthorizersCacheInput {
                api_id: self.api_id,
                stage_name: self.stage_name,
            })
        }
    }
}
#[doc(hidden)]
pub type ResetAuthorizersCacheInputOperationOutputAlias = crate::operation::ResetAuthorizersCache;
#[doc(hidden)]
pub type ResetAuthorizersCacheInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ResetAuthorizersCacheInput {
    /// Consumes the builder and constructs an Operation<[`ResetAuthorizersCache`](crate::operation::ResetAuthorizersCache)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ResetAuthorizersCache,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ResetAuthorizersCacheInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_113 = &_input.api_id;
                let input_113 = input_113.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_113, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_114 = &_input.stage_name;
                let input_114 = input_114.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "stage_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let stage_name = aws_smithy_http::label::fmt_string(input_114, false);
                if stage_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "stage_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/apis/{ApiId}/stages/{StageName}/cache/authorizers",
                    ApiId = api_id,
                    StageName = stage_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ResetAuthorizersCacheInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ResetAuthorizersCache::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ResetAuthorizersCache",
            "apigatewayv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ResetAuthorizersCacheInput`](crate::input::ResetAuthorizersCacheInput)
    pub fn builder() -> crate::input::reset_authorizers_cache_input::Builder {
        crate::input::reset_authorizers_cache_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The resource ARN for the tag.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The resource ARN for the tag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::TagResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_115 = &_input.resource_arn;
                let input_115 = input_115.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_arn = aws_smithy_http::label::fmt_string(input_115, false);
                if resource_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v2/tags/{ResourceArn}", ResourceArn = resource_arn)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::TagResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "apigatewayv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The resource ARN for the tag.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The resource ARN for the tag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The Tag keys to delete</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The Tag keys to delete</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UntagResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_116 = &_input.resource_arn;
                let input_116 = input_116.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_arn = aws_smithy_http::label::fmt_string(input_116, false);
                if resource_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v2/tags/{ResourceArn}", ResourceArn = resource_arn)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::UntagResourceInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_117) = &_input.tag_keys {
                    for inner_118 in inner_117 {
                        query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_118));
                    }
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UntagResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "apigatewayv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateApiInput`](crate::input::UpdateApiInput)
pub mod update_api_input {
    /// A builder for [`UpdateApiInput`](crate::input::UpdateApiInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) api_key_selection_expression: std::option::Option<std::string::String>,
        pub(crate) cors_configuration: std::option::Option<crate::model::Cors>,
        pub(crate) credentials_arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) disable_schema_validation: std::option::Option<bool>,
        pub(crate) disable_execute_api_endpoint: std::option::Option<bool>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) route_key: std::option::Option<std::string::String>,
        pub(crate) route_selection_expression: std::option::Option<std::string::String>,
        pub(crate) target: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>An API key selection expression. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions">API Key Selection Expressions</a>.</p>
        pub fn api_key_selection_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.api_key_selection_expression = Some(input.into());
            self
        }
        /// <p>An API key selection expression. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions">API Key Selection Expressions</a>.</p>
        pub fn set_api_key_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.api_key_selection_expression = input;
            self
        }
        /// <p>A CORS configuration. Supported only for HTTP APIs.</p>
        pub fn cors_configuration(mut self, input: crate::model::Cors) -> Self {
            self.cors_configuration = Some(input);
            self
        }
        /// <p>A CORS configuration. Supported only for HTTP APIs.</p>
        pub fn set_cors_configuration(
            mut self,
            input: std::option::Option<crate::model::Cors>,
        ) -> Self {
            self.cors_configuration = input;
            self
        }
        /// <p>This property is part of quick create. It specifies the credentials required for the integration, if any. For a Lambda integration, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, don't specify this parameter. Currently, this property is not used for HTTP integrations. If provided, this value replaces the credentials associated with the quick create integration. Supported only for HTTP APIs.</p>
        pub fn credentials_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.credentials_arn = Some(input.into());
            self
        }
        /// <p>This property is part of quick create. It specifies the credentials required for the integration, if any. For a Lambda integration, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, don't specify this parameter. Currently, this property is not used for HTTP integrations. If provided, this value replaces the credentials associated with the quick create integration. Supported only for HTTP APIs.</p>
        pub fn set_credentials_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.credentials_arn = input;
            self
        }
        /// <p>The description of the API.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the API.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Avoid validating models when creating a deployment. Supported only for WebSocket APIs.</p>
        pub fn disable_schema_validation(mut self, input: bool) -> Self {
            self.disable_schema_validation = Some(input);
            self
        }
        /// <p>Avoid validating models when creating a deployment. Supported only for WebSocket APIs.</p>
        pub fn set_disable_schema_validation(mut self, input: std::option::Option<bool>) -> Self {
            self.disable_schema_validation = input;
            self
        }
        /// <p>Specifies whether clients can invoke your API by using the default execute-api endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
        pub fn disable_execute_api_endpoint(mut self, input: bool) -> Self {
            self.disable_execute_api_endpoint = Some(input);
            self
        }
        /// <p>Specifies whether clients can invoke your API by using the default execute-api endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
        pub fn set_disable_execute_api_endpoint(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.disable_execute_api_endpoint = input;
            self
        }
        /// <p>The name of the API.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the API.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>This property is part of quick create. If not specified, the route created using quick create is kept. Otherwise, this value replaces the route key of the quick create route. Additional routes may still be added after the API is updated. Supported only for HTTP APIs.</p>
        pub fn route_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_key = Some(input.into());
            self
        }
        /// <p>This property is part of quick create. If not specified, the route created using quick create is kept. Otherwise, this value replaces the route key of the quick create route. Additional routes may still be added after the API is updated. Supported only for HTTP APIs.</p>
        pub fn set_route_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.route_key = input;
            self
        }
        /// <p>The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.</p>
        pub fn route_selection_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_selection_expression = Some(input.into());
            self
        }
        /// <p>The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.</p>
        pub fn set_route_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.route_selection_expression = input;
            self
        }
        /// <p>This property is part of quick create. For HTTP integrations, specify a fully qualified URL. For Lambda integrations, specify a function ARN. The type of the integration will be HTTP_PROXY or AWS_PROXY, respectively. The value provided updates the integration URI and integration type. You can update a quick-created target, but you can't remove it from an API. Supported only for HTTP APIs.</p>
        pub fn target(mut self, input: impl Into<std::string::String>) -> Self {
            self.target = Some(input.into());
            self
        }
        /// <p>This property is part of quick create. For HTTP integrations, specify a fully qualified URL. For Lambda integrations, specify a function ARN. The type of the integration will be HTTP_PROXY or AWS_PROXY, respectively. The value provided updates the integration URI and integration type. You can update a quick-created target, but you can't remove it from an API. Supported only for HTTP APIs.</p>
        pub fn set_target(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target = input;
            self
        }
        /// <p>A version identifier for the API.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>A version identifier for the API.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateApiInput`](crate::input::UpdateApiInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::UpdateApiInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::UpdateApiInput {
                api_id: self.api_id,
                api_key_selection_expression: self.api_key_selection_expression,
                cors_configuration: self.cors_configuration,
                credentials_arn: self.credentials_arn,
                description: self.description,
                disable_schema_validation: self.disable_schema_validation.unwrap_or_default(),
                disable_execute_api_endpoint: self.disable_execute_api_endpoint.unwrap_or_default(),
                name: self.name,
                route_key: self.route_key,
                route_selection_expression: self.route_selection_expression,
                target: self.target,
                version: self.version,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateApiInputOperationOutputAlias = crate::operation::UpdateApi;
#[doc(hidden)]
pub type UpdateApiInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateApiInput {
    /// Consumes the builder and constructs an Operation<[`UpdateApi`](crate::operation::UpdateApi)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateApi,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateApiInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_119 = &_input.api_id;
                let input_119 = input_119.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_119, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v2/apis/{ApiId}", ApiId = api_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateApiInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PATCH").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_api(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::UpdateApi::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "UpdateApi",
                    "apigatewayv2",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateApiInput`](crate::input::UpdateApiInput)
    pub fn builder() -> crate::input::update_api_input::Builder {
        crate::input::update_api_input::Builder::default()
    }
}

/// See [`UpdateApiMappingInput`](crate::input::UpdateApiMappingInput)
pub mod update_api_mapping_input {
    /// A builder for [`UpdateApiMappingInput`](crate::input::UpdateApiMappingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) api_mapping_id: std::option::Option<std::string::String>,
        pub(crate) api_mapping_key: std::option::Option<std::string::String>,
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) stage: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The API mapping identifier.</p>
        pub fn api_mapping_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_mapping_id = Some(input.into());
            self
        }
        /// <p>The API mapping identifier.</p>
        pub fn set_api_mapping_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.api_mapping_id = input;
            self
        }
        /// <p>The API mapping key.</p>
        pub fn api_mapping_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_mapping_key = Some(input.into());
            self
        }
        /// <p>The API mapping key.</p>
        pub fn set_api_mapping_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.api_mapping_key = input;
            self
        }
        /// <p>The domain name.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The domain name.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The API stage.</p>
        pub fn stage(mut self, input: impl Into<std::string::String>) -> Self {
            self.stage = Some(input.into());
            self
        }
        /// <p>The API stage.</p>
        pub fn set_stage(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stage = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateApiMappingInput`](crate::input::UpdateApiMappingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateApiMappingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateApiMappingInput {
                api_id: self.api_id,
                api_mapping_id: self.api_mapping_id,
                api_mapping_key: self.api_mapping_key,
                domain_name: self.domain_name,
                stage: self.stage,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateApiMappingInputOperationOutputAlias = crate::operation::UpdateApiMapping;
#[doc(hidden)]
pub type UpdateApiMappingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateApiMappingInput {
    /// Consumes the builder and constructs an Operation<[`UpdateApiMapping`](crate::operation::UpdateApiMapping)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateApiMapping,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateApiMappingInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_120 = &_input.domain_name;
                let input_120 = input_120.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_120, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_121 = &_input.api_mapping_id;
                let input_121 = input_121.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_mapping_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_mapping_id = aws_smithy_http::label::fmt_string(input_121, false);
                if api_mapping_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_mapping_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/domainnames/{DomainName}/apimappings/{ApiMappingId}",
                    DomainName = domain_name,
                    ApiMappingId = api_mapping_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateApiMappingInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PATCH").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_api_mapping(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateApiMapping::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateApiMapping",
            "apigatewayv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateApiMappingInput`](crate::input::UpdateApiMappingInput)
    pub fn builder() -> crate::input::update_api_mapping_input::Builder {
        crate::input::update_api_mapping_input::Builder::default()
    }
}

/// See [`UpdateAuthorizerInput`](crate::input::UpdateAuthorizerInput)
pub mod update_authorizer_input {
    /// A builder for [`UpdateAuthorizerInput`](crate::input::UpdateAuthorizerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) authorizer_credentials_arn: std::option::Option<std::string::String>,
        pub(crate) authorizer_id: std::option::Option<std::string::String>,
        pub(crate) authorizer_payload_format_version: std::option::Option<std::string::String>,
        pub(crate) authorizer_result_ttl_in_seconds: std::option::Option<i32>,
        pub(crate) authorizer_type: std::option::Option<crate::model::AuthorizerType>,
        pub(crate) authorizer_uri: std::option::Option<std::string::String>,
        pub(crate) enable_simple_responses: std::option::Option<bool>,
        pub(crate) identity_source: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) identity_validation_expression: std::option::Option<std::string::String>,
        pub(crate) jwt_configuration: std::option::Option<crate::model::JwtConfiguration>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, don't specify this parameter.</p>
        pub fn authorizer_credentials_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorizer_credentials_arn = Some(input.into());
            self
        }
        /// <p>Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, don't specify this parameter.</p>
        pub fn set_authorizer_credentials_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorizer_credentials_arn = input;
            self
        }
        /// <p>The authorizer identifier.</p>
        pub fn authorizer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorizer_id = Some(input.into());
            self
        }
        /// <p>The authorizer identifier.</p>
        pub fn set_authorizer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorizer_id = input;
            self
        }
        /// <p>Specifies the format of the payload sent to an HTTP API Lambda authorizer. Required for HTTP API Lambda authorizers. Supported values are 1.0 and 2.0. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p>
        pub fn authorizer_payload_format_version(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.authorizer_payload_format_version = Some(input.into());
            self
        }
        /// <p>Specifies the format of the payload sent to an HTTP API Lambda authorizer. Required for HTTP API Lambda authorizers. Supported values are 1.0 and 2.0. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p>
        pub fn set_authorizer_payload_format_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorizer_payload_format_version = input;
            self
        }
        /// <p>The time to live (TTL) for cached authorizer results, in seconds. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway caches authorizer responses. The maximum value is 3600, or 1 hour. Supported only for HTTP API Lambda authorizers.</p>
        pub fn authorizer_result_ttl_in_seconds(mut self, input: i32) -> Self {
            self.authorizer_result_ttl_in_seconds = Some(input);
            self
        }
        /// <p>The time to live (TTL) for cached authorizer results, in seconds. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway caches authorizer responses. The maximum value is 3600, or 1 hour. Supported only for HTTP API Lambda authorizers.</p>
        pub fn set_authorizer_result_ttl_in_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.authorizer_result_ttl_in_seconds = input;
            self
        }
        /// <p>The authorizer type. Specify REQUEST for a Lambda function using incoming request parameters. Specify JWT to use JSON Web Tokens (supported only for HTTP APIs).</p>
        pub fn authorizer_type(mut self, input: crate::model::AuthorizerType) -> Self {
            self.authorizer_type = Some(input);
            self
        }
        /// <p>The authorizer type. Specify REQUEST for a Lambda function using incoming request parameters. Specify JWT to use JSON Web Tokens (supported only for HTTP APIs).</p>
        pub fn set_authorizer_type(
            mut self,
            input: std::option::Option<crate::model::AuthorizerType>,
        ) -> Self {
            self.authorizer_type = input;
            self
        }
        /// <p>The authorizer's Uniform Resource Identifier (URI). For REQUEST authorizers, this must be a well-formed Lambda function URI, for example, arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:<replaceable>
        /// {account_id}
        /// </replaceable>:function:<replaceable>
        /// {lambda_function_name}
        /// </replaceable>/invocations. In general, the URI has this form: arn:aws:apigateway:<replaceable>
        /// {region}
        /// </replaceable>:lambda:path/<replaceable>
        /// {service_api}
        /// </replaceable> , where <replaceable></replaceable>{region} is the same as the region hosting the Lambda function, path indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial /. For Lambda functions, this is usually of the form /2015-03-31/functions/[FunctionARN]/invocations. Supported only for REQUEST authorizers.</p>
        pub fn authorizer_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorizer_uri = Some(input.into());
            self
        }
        /// <p>The authorizer's Uniform Resource Identifier (URI). For REQUEST authorizers, this must be a well-formed Lambda function URI, for example, arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:<replaceable>
        /// {account_id}
        /// </replaceable>:function:<replaceable>
        /// {lambda_function_name}
        /// </replaceable>/invocations. In general, the URI has this form: arn:aws:apigateway:<replaceable>
        /// {region}
        /// </replaceable>:lambda:path/<replaceable>
        /// {service_api}
        /// </replaceable> , where <replaceable></replaceable>{region} is the same as the region hosting the Lambda function, path indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial /. For Lambda functions, this is usually of the form /2015-03-31/functions/[FunctionARN]/invocations. Supported only for REQUEST authorizers.</p>
        pub fn set_authorizer_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorizer_uri = input;
            self
        }
        /// <p>Specifies whether a Lambda authorizer returns a response in a simple format. By default, a Lambda authorizer must return an IAM policy. If enabled, the Lambda authorizer can return a boolean value instead of an IAM policy. Supported only for HTTP APIs. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a></p>
        pub fn enable_simple_responses(mut self, input: bool) -> Self {
            self.enable_simple_responses = Some(input);
            self
        }
        /// <p>Specifies whether a Lambda authorizer returns a response in a simple format. By default, a Lambda authorizer must return an IAM policy. If enabled, the Lambda authorizer can return a boolean value instead of an IAM policy. Supported only for HTTP APIs. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a></p>
        pub fn set_enable_simple_responses(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_simple_responses = input;
            self
        }
        /// Appends an item to `identity_source`.
        ///
        /// To override the contents of this collection use [`set_identity_source`](Self::set_identity_source).
        ///
        /// <p>The identity source for which authorization is requested.</p>
        /// <p>For a REQUEST authorizer, this is optional. The value is a set of one or more mapping expressions of the specified request parameters. The identity source can be headers, query string parameters, stage variables, and context parameters. For example, if an Auth header and a Name query string parameter are defined as identity sources, this value is route.request.header.Auth, route.request.querystring.Name for WebSocket APIs. For HTTP APIs, use selection expressions prefixed with $, for example, $request.header.Auth, $request.querystring.Name. These parameters are used to perform runtime validation for Lambda-based authorizers by verifying all of the identity-related request parameters are present in the request, not null, and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function. Otherwise, it returns a 401 Unauthorized response without calling the Lambda function. For HTTP APIs, identity sources are also used as the cache key when caching is enabled. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p>
        /// <p>For JWT, a single entry that specifies where to extract the JSON Web Token (JWT) from inbound requests. Currently only header-based and query parameter-based selections are supported, for example $request.header.Authorization.</p>
        pub fn identity_source(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.identity_source.unwrap_or_default();
            v.push(input.into());
            self.identity_source = Some(v);
            self
        }
        /// <p>The identity source for which authorization is requested.</p>
        /// <p>For a REQUEST authorizer, this is optional. The value is a set of one or more mapping expressions of the specified request parameters. The identity source can be headers, query string parameters, stage variables, and context parameters. For example, if an Auth header and a Name query string parameter are defined as identity sources, this value is route.request.header.Auth, route.request.querystring.Name for WebSocket APIs. For HTTP APIs, use selection expressions prefixed with $, for example, $request.header.Auth, $request.querystring.Name. These parameters are used to perform runtime validation for Lambda-based authorizers by verifying all of the identity-related request parameters are present in the request, not null, and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function. Otherwise, it returns a 401 Unauthorized response without calling the Lambda function. For HTTP APIs, identity sources are also used as the cache key when caching is enabled. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p>
        /// <p>For JWT, a single entry that specifies where to extract the JSON Web Token (JWT) from inbound requests. Currently only header-based and query parameter-based selections are supported, for example $request.header.Authorization.</p>
        pub fn set_identity_source(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.identity_source = input;
            self
        }
        /// <p>This parameter is not used.</p>
        pub fn identity_validation_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.identity_validation_expression = Some(input.into());
            self
        }
        /// <p>This parameter is not used.</p>
        pub fn set_identity_validation_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_validation_expression = input;
            self
        }
        /// <p>Represents the configuration of a JWT authorizer. Required for the JWT authorizer type. Supported only for HTTP APIs.</p>
        pub fn jwt_configuration(mut self, input: crate::model::JwtConfiguration) -> Self {
            self.jwt_configuration = Some(input);
            self
        }
        /// <p>Represents the configuration of a JWT authorizer. Required for the JWT authorizer type. Supported only for HTTP APIs.</p>
        pub fn set_jwt_configuration(
            mut self,
            input: std::option::Option<crate::model::JwtConfiguration>,
        ) -> Self {
            self.jwt_configuration = input;
            self
        }
        /// <p>The name of the authorizer.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the authorizer.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAuthorizerInput`](crate::input::UpdateAuthorizerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateAuthorizerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateAuthorizerInput {
                api_id: self.api_id,
                authorizer_credentials_arn: self.authorizer_credentials_arn,
                authorizer_id: self.authorizer_id,
                authorizer_payload_format_version: self.authorizer_payload_format_version,
                authorizer_result_ttl_in_seconds: self
                    .authorizer_result_ttl_in_seconds
                    .unwrap_or_default(),
                authorizer_type: self.authorizer_type,
                authorizer_uri: self.authorizer_uri,
                enable_simple_responses: self.enable_simple_responses.unwrap_or_default(),
                identity_source: self.identity_source,
                identity_validation_expression: self.identity_validation_expression,
                jwt_configuration: self.jwt_configuration,
                name: self.name,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateAuthorizerInputOperationOutputAlias = crate::operation::UpdateAuthorizer;
#[doc(hidden)]
pub type UpdateAuthorizerInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateAuthorizerInput {
    /// Consumes the builder and constructs an Operation<[`UpdateAuthorizer`](crate::operation::UpdateAuthorizer)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateAuthorizer,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateAuthorizerInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_122 = &_input.api_id;
                let input_122 = input_122.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_122, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_123 = &_input.authorizer_id;
                let input_123 = input_123.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "authorizer_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let authorizer_id = aws_smithy_http::label::fmt_string(input_123, false);
                if authorizer_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "authorizer_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/apis/{ApiId}/authorizers/{AuthorizerId}",
                    ApiId = api_id,
                    AuthorizerId = authorizer_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateAuthorizerInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PATCH").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_authorizer(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateAuthorizer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateAuthorizer",
            "apigatewayv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateAuthorizerInput`](crate::input::UpdateAuthorizerInput)
    pub fn builder() -> crate::input::update_authorizer_input::Builder {
        crate::input::update_authorizer_input::Builder::default()
    }
}

/// See [`UpdateDeploymentInput`](crate::input::UpdateDeploymentInput)
pub mod update_deployment_input {
    /// A builder for [`UpdateDeploymentInput`](crate::input::UpdateDeploymentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) deployment_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The deployment ID.</p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_id = Some(input.into());
            self
        }
        /// <p>The deployment ID.</p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_id = input;
            self
        }
        /// <p>The description for the deployment resource.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description for the deployment resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDeploymentInput`](crate::input::UpdateDeploymentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateDeploymentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateDeploymentInput {
                api_id: self.api_id,
                deployment_id: self.deployment_id,
                description: self.description,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateDeploymentInputOperationOutputAlias = crate::operation::UpdateDeployment;
#[doc(hidden)]
pub type UpdateDeploymentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateDeploymentInput {
    /// Consumes the builder and constructs an Operation<[`UpdateDeployment`](crate::operation::UpdateDeployment)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateDeployment,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateDeploymentInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_124 = &_input.api_id;
                let input_124 = input_124.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_124, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_125 = &_input.deployment_id;
                let input_125 = input_125.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "deployment_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let deployment_id = aws_smithy_http::label::fmt_string(input_125, false);
                if deployment_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "deployment_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/apis/{ApiId}/deployments/{DeploymentId}",
                    ApiId = api_id,
                    DeploymentId = deployment_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateDeploymentInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PATCH").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_deployment(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateDeployment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateDeployment",
            "apigatewayv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateDeploymentInput`](crate::input::UpdateDeploymentInput)
    pub fn builder() -> crate::input::update_deployment_input::Builder {
        crate::input::update_deployment_input::Builder::default()
    }
}

/// See [`UpdateDomainNameInput`](crate::input::UpdateDomainNameInput)
pub mod update_domain_name_input {
    /// A builder for [`UpdateDomainNameInput`](crate::input::UpdateDomainNameInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) domain_name_configurations:
            std::option::Option<std::vec::Vec<crate::model::DomainNameConfiguration>>,
        pub(crate) mutual_tls_authentication:
            std::option::Option<crate::model::MutualTlsAuthenticationInput>,
    }
    impl Builder {
        /// <p>The domain name.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The domain name.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Appends an item to `domain_name_configurations`.
        ///
        /// To override the contents of this collection use [`set_domain_name_configurations`](Self::set_domain_name_configurations).
        ///
        /// <p>The domain name configurations.</p>
        pub fn domain_name_configurations(
            mut self,
            input: crate::model::DomainNameConfiguration,
        ) -> Self {
            let mut v = self.domain_name_configurations.unwrap_or_default();
            v.push(input);
            self.domain_name_configurations = Some(v);
            self
        }
        /// <p>The domain name configurations.</p>
        pub fn set_domain_name_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DomainNameConfiguration>>,
        ) -> Self {
            self.domain_name_configurations = input;
            self
        }
        /// <p>The mutual TLS authentication configuration for a custom domain name.</p>
        pub fn mutual_tls_authentication(
            mut self,
            input: crate::model::MutualTlsAuthenticationInput,
        ) -> Self {
            self.mutual_tls_authentication = Some(input);
            self
        }
        /// <p>The mutual TLS authentication configuration for a custom domain name.</p>
        pub fn set_mutual_tls_authentication(
            mut self,
            input: std::option::Option<crate::model::MutualTlsAuthenticationInput>,
        ) -> Self {
            self.mutual_tls_authentication = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDomainNameInput`](crate::input::UpdateDomainNameInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateDomainNameInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateDomainNameInput {
                domain_name: self.domain_name,
                domain_name_configurations: self.domain_name_configurations,
                mutual_tls_authentication: self.mutual_tls_authentication,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateDomainNameInputOperationOutputAlias = crate::operation::UpdateDomainName;
#[doc(hidden)]
pub type UpdateDomainNameInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateDomainNameInput {
    /// Consumes the builder and constructs an Operation<[`UpdateDomainName`](crate::operation::UpdateDomainName)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateDomainName,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateDomainNameInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_126 = &_input.domain_name;
                let input_126 = input_126.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_126, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/domainnames/{DomainName}",
                    DomainName = domain_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateDomainNameInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PATCH").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_domain_name(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateDomainName::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateDomainName",
            "apigatewayv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateDomainNameInput`](crate::input::UpdateDomainNameInput)
    pub fn builder() -> crate::input::update_domain_name_input::Builder {
        crate::input::update_domain_name_input::Builder::default()
    }
}

/// See [`UpdateIntegrationInput`](crate::input::UpdateIntegrationInput)
pub mod update_integration_input {
    /// A builder for [`UpdateIntegrationInput`](crate::input::UpdateIntegrationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) connection_id: std::option::Option<std::string::String>,
        pub(crate) connection_type: std::option::Option<crate::model::ConnectionType>,
        pub(crate) content_handling_strategy:
            std::option::Option<crate::model::ContentHandlingStrategy>,
        pub(crate) credentials_arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) integration_id: std::option::Option<std::string::String>,
        pub(crate) integration_method: std::option::Option<std::string::String>,
        pub(crate) integration_subtype: std::option::Option<std::string::String>,
        pub(crate) integration_type: std::option::Option<crate::model::IntegrationType>,
        pub(crate) integration_uri: std::option::Option<std::string::String>,
        pub(crate) passthrough_behavior: std::option::Option<crate::model::PassthroughBehavior>,
        pub(crate) payload_format_version: std::option::Option<std::string::String>,
        pub(crate) request_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) request_templates: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) response_parameters: std::option::Option<
            std::collections::HashMap<
                std::string::String,
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        >,
        pub(crate) template_selection_expression: std::option::Option<std::string::String>,
        pub(crate) timeout_in_millis: std::option::Option<i32>,
        pub(crate) tls_config: std::option::Option<crate::model::TlsConfigInput>,
    }
    impl Builder {
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The ID of the VPC link for a private integration. Supported only for HTTP APIs.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_id = Some(input.into());
            self
        }
        /// <p>The ID of the VPC link for a private integration. Supported only for HTTP APIs.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_id = input;
            self
        }
        /// <p>The type of the network connection to the integration endpoint. Specify INTERNET for connections through the public routable internet or VPC_LINK for private connections between API Gateway and resources in a VPC. The default value is INTERNET.</p>
        pub fn connection_type(mut self, input: crate::model::ConnectionType) -> Self {
            self.connection_type = Some(input);
            self
        }
        /// <p>The type of the network connection to the integration endpoint. Specify INTERNET for connections through the public routable internet or VPC_LINK for private connections between API Gateway and resources in a VPC. The default value is INTERNET.</p>
        pub fn set_connection_type(
            mut self,
            input: std::option::Option<crate::model::ConnectionType>,
        ) -> Self {
            self.connection_type = input;
            self
        }
        /// <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p>
        /// <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p>
        /// <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p>
        /// <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
        pub fn content_handling_strategy(
            mut self,
            input: crate::model::ContentHandlingStrategy,
        ) -> Self {
            self.content_handling_strategy = Some(input);
            self
        }
        /// <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p>
        /// <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p>
        /// <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p>
        /// <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
        pub fn set_content_handling_strategy(
            mut self,
            input: std::option::Option<crate::model::ContentHandlingStrategy>,
        ) -> Self {
            self.content_handling_strategy = input;
            self
        }
        /// <p>Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, specify null.</p>
        pub fn credentials_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.credentials_arn = Some(input.into());
            self
        }
        /// <p>Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, specify null.</p>
        pub fn set_credentials_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.credentials_arn = input;
            self
        }
        /// <p>The description of the integration</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the integration</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The integration ID.</p>
        pub fn integration_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.integration_id = Some(input.into());
            self
        }
        /// <p>The integration ID.</p>
        pub fn set_integration_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.integration_id = input;
            self
        }
        /// <p>Specifies the integration's HTTP method type.</p>
        pub fn integration_method(mut self, input: impl Into<std::string::String>) -> Self {
            self.integration_method = Some(input.into());
            self
        }
        /// <p>Specifies the integration's HTTP method type.</p>
        pub fn set_integration_method(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.integration_method = input;
            self
        }
        /// <p>Supported only for HTTP API AWS_PROXY integrations. Specifies the AWS service action to invoke. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html">Integration subtype reference</a>.</p>
        pub fn integration_subtype(mut self, input: impl Into<std::string::String>) -> Self {
            self.integration_subtype = Some(input.into());
            self
        }
        /// <p>Supported only for HTTP API AWS_PROXY integrations. Specifies the AWS service action to invoke. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html">Integration subtype reference</a>.</p>
        pub fn set_integration_subtype(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.integration_subtype = input;
            self
        }
        /// <p>The integration type of an integration. One of the following:</p>
        /// <p>AWS: for integrating the route or method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration. Supported only for WebSocket APIs.</p>
        /// <p>AWS_PROXY: for integrating the route or method request with a Lambda function or other AWS service action. This integration is also referred to as a Lambda proxy integration.</p>
        /// <p>HTTP: for integrating the route or method request with an HTTP endpoint. This integration is also referred to as the HTTP custom integration. Supported only for WebSocket APIs.</p>
        /// <p>HTTP_PROXY: for integrating the route or method request with an HTTP endpoint, with the client request passed through as-is. This is also referred to as HTTP proxy integration. For HTTP API private integrations, use an HTTP_PROXY integration.</p>
        /// <p>MOCK: for integrating the route or method request with API Gateway as a "loopback" endpoint without invoking any backend. Supported only for WebSocket APIs.</p>
        pub fn integration_type(mut self, input: crate::model::IntegrationType) -> Self {
            self.integration_type = Some(input);
            self
        }
        /// <p>The integration type of an integration. One of the following:</p>
        /// <p>AWS: for integrating the route or method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration. Supported only for WebSocket APIs.</p>
        /// <p>AWS_PROXY: for integrating the route or method request with a Lambda function or other AWS service action. This integration is also referred to as a Lambda proxy integration.</p>
        /// <p>HTTP: for integrating the route or method request with an HTTP endpoint. This integration is also referred to as the HTTP custom integration. Supported only for WebSocket APIs.</p>
        /// <p>HTTP_PROXY: for integrating the route or method request with an HTTP endpoint, with the client request passed through as-is. This is also referred to as HTTP proxy integration. For HTTP API private integrations, use an HTTP_PROXY integration.</p>
        /// <p>MOCK: for integrating the route or method request with API Gateway as a "loopback" endpoint without invoking any backend. Supported only for WebSocket APIs.</p>
        pub fn set_integration_type(
            mut self,
            input: std::option::Option<crate::model::IntegrationType>,
        ) -> Self {
            self.integration_type = input;
            self
        }
        /// <p>For a Lambda integration, specify the URI of a Lambda function.</p>
        /// <p>For an HTTP integration, specify a fully-qualified URL.</p>
        /// <p>For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service. If you specify the ARN of an AWS Cloud Map service, API Gateway uses DiscoverInstances to identify resources. You can use query parameters to target specific resources. To learn more, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_DiscoverInstances.html">DiscoverInstances</a>. For private integrations, all resources must be owned by the same AWS account.</p>
        pub fn integration_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.integration_uri = Some(input.into());
            self
        }
        /// <p>For a Lambda integration, specify the URI of a Lambda function.</p>
        /// <p>For an HTTP integration, specify a fully-qualified URL.</p>
        /// <p>For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service. If you specify the ARN of an AWS Cloud Map service, API Gateway uses DiscoverInstances to identify resources. You can use query parameters to target specific resources. To learn more, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_DiscoverInstances.html">DiscoverInstances</a>. For private integrations, all resources must be owned by the same AWS account.</p>
        pub fn set_integration_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.integration_uri = input;
            self
        }
        /// <p>Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER. Supported only for WebSocket APIs.</p>
        /// <p>WHEN_NO_MATCH passes the request body for unmapped content types through to the integration backend without transformation.</p>
        /// <p>NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type response.</p>
        /// <p>WHEN_NO_TEMPLATES allows pass-through when the integration has no content types mapped to templates. However, if there is at least one content type defined, unmapped content types will be rejected with the same HTTP 415 Unsupported Media Type response.</p>
        pub fn passthrough_behavior(mut self, input: crate::model::PassthroughBehavior) -> Self {
            self.passthrough_behavior = Some(input);
            self
        }
        /// <p>Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER. Supported only for WebSocket APIs.</p>
        /// <p>WHEN_NO_MATCH passes the request body for unmapped content types through to the integration backend without transformation.</p>
        /// <p>NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type response.</p>
        /// <p>WHEN_NO_TEMPLATES allows pass-through when the integration has no content types mapped to templates. However, if there is at least one content type defined, unmapped content types will be rejected with the same HTTP 415 Unsupported Media Type response.</p>
        pub fn set_passthrough_behavior(
            mut self,
            input: std::option::Option<crate::model::PassthroughBehavior>,
        ) -> Self {
            self.passthrough_behavior = input;
            self
        }
        /// <p>Specifies the format of the payload sent to an integration. Required for HTTP APIs.</p>
        pub fn payload_format_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.payload_format_version = Some(input.into());
            self
        }
        /// <p>Specifies the format of the payload sent to an integration. Required for HTTP APIs.</p>
        pub fn set_payload_format_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.payload_format_version = input;
            self
        }
        /// Adds a key-value pair to `request_parameters`.
        ///
        /// To override the contents of this collection use [`set_request_parameters`](Self::set_request_parameters).
        ///
        /// <p>For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the backend. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the backend. The method request parameter value must match the pattern of method.request.<replaceable>
        /// {location}
        /// </replaceable>.<replaceable>
        /// {name}
        /// </replaceable> , where <replaceable>
        /// {location}
        /// </replaceable> is querystring, path, or header; and <replaceable>
        /// {name}
        /// </replaceable> must be a valid and unique method request parameter name.</p>
        /// <p>For HTTP API integrations with a specified integrationSubtype, request parameters are a key-value map specifying parameters that are passed to AWS_PROXY integrations. You can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services.html">Working with AWS service integrations for HTTP APIs</a>.</p>
        /// <p>For HTTP API integrations, without a specified integrationSubtype request parameters are a key-value map specifying how to transform HTTP requests before sending them to the backend. The key should follow the pattern &lt;action&gt;:&lt;header|querystring|path&gt;.&lt;location&gt; where action can be append, overwrite or remove. For values, you can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.">Transforming API requests and responses</a>.</p>
        pub fn request_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.request_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.request_parameters = Some(hash_map);
            self
        }
        /// <p>For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the backend. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the backend. The method request parameter value must match the pattern of method.request.<replaceable>
        /// {location}
        /// </replaceable>.<replaceable>
        /// {name}
        /// </replaceable> , where <replaceable>
        /// {location}
        /// </replaceable> is querystring, path, or header; and <replaceable>
        /// {name}
        /// </replaceable> must be a valid and unique method request parameter name.</p>
        /// <p>For HTTP API integrations with a specified integrationSubtype, request parameters are a key-value map specifying parameters that are passed to AWS_PROXY integrations. You can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services.html">Working with AWS service integrations for HTTP APIs</a>.</p>
        /// <p>For HTTP API integrations, without a specified integrationSubtype request parameters are a key-value map specifying how to transform HTTP requests before sending them to the backend. The key should follow the pattern &lt;action&gt;:&lt;header|querystring|path&gt;.&lt;location&gt; where action can be append, overwrite or remove. For values, you can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.">Transforming API requests and responses</a>.</p>
        pub fn set_request_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.request_parameters = input;
            self
        }
        /// Adds a key-value pair to `request_templates`.
        ///
        /// To override the contents of this collection use [`set_request_templates`](Self::set_request_templates).
        ///
        /// <p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value. Supported only for WebSocket APIs.</p>
        pub fn request_templates(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.request_templates.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.request_templates = Some(hash_map);
            self
        }
        /// <p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value. Supported only for WebSocket APIs.</p>
        pub fn set_request_templates(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.request_templates = input;
            self
        }
        /// Adds a key-value pair to `response_parameters`.
        ///
        /// To override the contents of this collection use [`set_response_parameters`](Self::set_response_parameters).
        ///
        /// <p>Supported only for HTTP APIs. You use response parameters to transform the HTTP response from a backend integration before returning the response to clients. Specify a key-value map from a selection key to response parameters. The selection key must be a valid HTTP status code within the range of 200-599. Response parameters are a key-value map. The key must match pattern &lt;action&gt;:&lt;header&gt;.&lt;location&gt; or overwrite.statuscode. The action can be append, overwrite or remove. The value can be a static value, or map to response data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
        pub fn response_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: std::collections::HashMap<std::string::String, std::string::String>,
        ) -> Self {
            let mut hash_map = self.response_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.response_parameters = Some(hash_map);
            self
        }
        /// <p>Supported only for HTTP APIs. You use response parameters to transform the HTTP response from a backend integration before returning the response to clients. Specify a key-value map from a selection key to response parameters. The selection key must be a valid HTTP status code within the range of 200-599. Response parameters are a key-value map. The key must match pattern &lt;action&gt;:&lt;header&gt;.&lt;location&gt; or overwrite.statuscode. The action can be append, overwrite or remove. The value can be a static value, or map to response data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
        pub fn set_response_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    std::collections::HashMap<std::string::String, std::string::String>,
                >,
            >,
        ) -> Self {
            self.response_parameters = input;
            self
        }
        /// <p>The template selection expression for the integration.</p>
        pub fn template_selection_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.template_selection_expression = Some(input.into());
            self
        }
        /// <p>The template selection expression for the integration.</p>
        pub fn set_template_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_selection_expression = input;
            self
        }
        /// <p>Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs. The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.</p>
        pub fn timeout_in_millis(mut self, input: i32) -> Self {
            self.timeout_in_millis = Some(input);
            self
        }
        /// <p>Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs. The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.</p>
        pub fn set_timeout_in_millis(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout_in_millis = input;
            self
        }
        /// <p>The TLS configuration for a private integration. If you specify a TLS configuration, private integration traffic uses the HTTPS protocol. Supported only for HTTP APIs.</p>
        pub fn tls_config(mut self, input: crate::model::TlsConfigInput) -> Self {
            self.tls_config = Some(input);
            self
        }
        /// <p>The TLS configuration for a private integration. If you specify a TLS configuration, private integration traffic uses the HTTPS protocol. Supported only for HTTP APIs.</p>
        pub fn set_tls_config(
            mut self,
            input: std::option::Option<crate::model::TlsConfigInput>,
        ) -> Self {
            self.tls_config = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateIntegrationInput`](crate::input::UpdateIntegrationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateIntegrationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateIntegrationInput {
                api_id: self.api_id,
                connection_id: self.connection_id,
                connection_type: self.connection_type,
                content_handling_strategy: self.content_handling_strategy,
                credentials_arn: self.credentials_arn,
                description: self.description,
                integration_id: self.integration_id,
                integration_method: self.integration_method,
                integration_subtype: self.integration_subtype,
                integration_type: self.integration_type,
                integration_uri: self.integration_uri,
                passthrough_behavior: self.passthrough_behavior,
                payload_format_version: self.payload_format_version,
                request_parameters: self.request_parameters,
                request_templates: self.request_templates,
                response_parameters: self.response_parameters,
                template_selection_expression: self.template_selection_expression,
                timeout_in_millis: self.timeout_in_millis.unwrap_or_default(),
                tls_config: self.tls_config,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateIntegrationInputOperationOutputAlias = crate::operation::UpdateIntegration;
#[doc(hidden)]
pub type UpdateIntegrationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateIntegrationInput {
    /// Consumes the builder and constructs an Operation<[`UpdateIntegration`](crate::operation::UpdateIntegration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateIntegration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateIntegrationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_127 = &_input.api_id;
                let input_127 = input_127.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_127, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_128 = &_input.integration_id;
                let input_128 = input_128.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "integration_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let integration_id = aws_smithy_http::label::fmt_string(input_128, false);
                if integration_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "integration_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/apis/{ApiId}/integrations/{IntegrationId}",
                    ApiId = api_id,
                    IntegrationId = integration_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateIntegrationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PATCH").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_integration(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateIntegration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateIntegration",
            "apigatewayv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateIntegrationInput`](crate::input::UpdateIntegrationInput)
    pub fn builder() -> crate::input::update_integration_input::Builder {
        crate::input::update_integration_input::Builder::default()
    }
}

/// See [`UpdateIntegrationResponseInput`](crate::input::UpdateIntegrationResponseInput)
pub mod update_integration_response_input {
    /// A builder for [`UpdateIntegrationResponseInput`](crate::input::UpdateIntegrationResponseInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) content_handling_strategy:
            std::option::Option<crate::model::ContentHandlingStrategy>,
        pub(crate) integration_id: std::option::Option<std::string::String>,
        pub(crate) integration_response_id: std::option::Option<std::string::String>,
        pub(crate) integration_response_key: std::option::Option<std::string::String>,
        pub(crate) response_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) response_templates: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) template_selection_expression: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p>
        /// <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p>
        /// <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p>
        /// <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
        pub fn content_handling_strategy(
            mut self,
            input: crate::model::ContentHandlingStrategy,
        ) -> Self {
            self.content_handling_strategy = Some(input);
            self
        }
        /// <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p>
        /// <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p>
        /// <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p>
        /// <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
        pub fn set_content_handling_strategy(
            mut self,
            input: std::option::Option<crate::model::ContentHandlingStrategy>,
        ) -> Self {
            self.content_handling_strategy = input;
            self
        }
        /// <p>The integration ID.</p>
        pub fn integration_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.integration_id = Some(input.into());
            self
        }
        /// <p>The integration ID.</p>
        pub fn set_integration_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.integration_id = input;
            self
        }
        /// <p>The integration response ID.</p>
        pub fn integration_response_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.integration_response_id = Some(input.into());
            self
        }
        /// <p>The integration response ID.</p>
        pub fn set_integration_response_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.integration_response_id = input;
            self
        }
        /// <p>The integration response key.</p>
        pub fn integration_response_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.integration_response_key = Some(input.into());
            self
        }
        /// <p>The integration response key.</p>
        pub fn set_integration_response_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.integration_response_key = input;
            self
        }
        /// Adds a key-value pair to `response_parameters`.
        ///
        /// To override the contents of this collection use [`set_response_parameters`](Self::set_response_parameters).
        ///
        /// <p>A key-value map specifying response parameters that are passed to the method response from the backend. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of method.response.header.<replaceable>
        /// {name}
        /// </replaceable> , where name is a valid and unique header name. The mapped non-static value must match the pattern of integration.response.header.<replaceable>
        /// {name}
        /// </replaceable> or integration.response.body.<replaceable>
        /// {JSON-expression}
        /// </replaceable> , where <replaceable>
        /// {name}
        /// </replaceable> is a valid and unique response header name and <replaceable>
        /// {JSON-expression}
        /// </replaceable> is a valid JSON expression without the $ prefix.</p>
        pub fn response_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.response_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.response_parameters = Some(hash_map);
            self
        }
        /// <p>A key-value map specifying response parameters that are passed to the method response from the backend. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of method.response.header.<replaceable>
        /// {name}
        /// </replaceable> , where name is a valid and unique header name. The mapped non-static value must match the pattern of integration.response.header.<replaceable>
        /// {name}
        /// </replaceable> or integration.response.body.<replaceable>
        /// {JSON-expression}
        /// </replaceable> , where <replaceable>
        /// {name}
        /// </replaceable> is a valid and unique response header name and <replaceable>
        /// {JSON-expression}
        /// </replaceable> is a valid JSON expression without the $ prefix.</p>
        pub fn set_response_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.response_parameters = input;
            self
        }
        /// Adds a key-value pair to `response_templates`.
        ///
        /// To override the contents of this collection use [`set_response_templates`](Self::set_response_templates).
        ///
        /// <p>The collection of response templates for the integration response as a string-to-string map of key-value pairs. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.</p>
        pub fn response_templates(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.response_templates.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.response_templates = Some(hash_map);
            self
        }
        /// <p>The collection of response templates for the integration response as a string-to-string map of key-value pairs. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.</p>
        pub fn set_response_templates(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.response_templates = input;
            self
        }
        /// <p>The template selection expression for the integration response. Supported only for WebSocket APIs.</p>
        pub fn template_selection_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.template_selection_expression = Some(input.into());
            self
        }
        /// <p>The template selection expression for the integration response. Supported only for WebSocket APIs.</p>
        pub fn set_template_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_selection_expression = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateIntegrationResponseInput`](crate::input::UpdateIntegrationResponseInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateIntegrationResponseInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateIntegrationResponseInput {
                api_id: self.api_id,
                content_handling_strategy: self.content_handling_strategy,
                integration_id: self.integration_id,
                integration_response_id: self.integration_response_id,
                integration_response_key: self.integration_response_key,
                response_parameters: self.response_parameters,
                response_templates: self.response_templates,
                template_selection_expression: self.template_selection_expression,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateIntegrationResponseInputOperationOutputAlias =
    crate::operation::UpdateIntegrationResponse;
#[doc(hidden)]
pub type UpdateIntegrationResponseInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateIntegrationResponseInput {
    /// Consumes the builder and constructs an Operation<[`UpdateIntegrationResponse`](crate::operation::UpdateIntegrationResponse)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateIntegrationResponse,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateIntegrationResponseInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_129 = &_input.api_id;
                let input_129 = input_129.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_129, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_130 = &_input.integration_id;
                let input_130 = input_130.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "integration_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let integration_id = aws_smithy_http::label::fmt_string(input_130, false);
                if integration_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "integration_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_131 = &_input.integration_response_id;
                let input_131 = input_131.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "integration_response_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let integration_response_id = aws_smithy_http::label::fmt_string(input_131, false);
                if integration_response_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "integration_response_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v2/apis/{ApiId}/integrations/{IntegrationId}/integrationresponses/{IntegrationResponseId}", ApiId = api_id, IntegrationId = integration_id, IntegrationResponseId = integration_response_id).expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateIntegrationResponseInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PATCH").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_integration_response(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateIntegrationResponse::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateIntegrationResponse",
            "apigatewayv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateIntegrationResponseInput`](crate::input::UpdateIntegrationResponseInput)
    pub fn builder() -> crate::input::update_integration_response_input::Builder {
        crate::input::update_integration_response_input::Builder::default()
    }
}

/// See [`UpdateModelInput`](crate::input::UpdateModelInput)
pub mod update_model_input {
    /// A builder for [`UpdateModelInput`](crate::input::UpdateModelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) content_type: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) model_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) schema: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The content-type for the model, for example, "application/json".</p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_type = Some(input.into());
            self
        }
        /// <p>The content-type for the model, for example, "application/json".</p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_type = input;
            self
        }
        /// <p>The description of the model.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the model.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The model ID.</p>
        pub fn model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_id = Some(input.into());
            self
        }
        /// <p>The model ID.</p>
        pub fn set_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.model_id = input;
            self
        }
        /// <p>The name of the model.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the model.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The schema for the model. For application/json models, this should be JSON schema draft 4 model.</p>
        pub fn schema(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema = Some(input.into());
            self
        }
        /// <p>The schema for the model. For application/json models, this should be JSON schema draft 4 model.</p>
        pub fn set_schema(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateModelInput`](crate::input::UpdateModelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateModelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateModelInput {
                api_id: self.api_id,
                content_type: self.content_type,
                description: self.description,
                model_id: self.model_id,
                name: self.name,
                schema: self.schema,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateModelInputOperationOutputAlias = crate::operation::UpdateModel;
#[doc(hidden)]
pub type UpdateModelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateModelInput {
    /// Consumes the builder and constructs an Operation<[`UpdateModel`](crate::operation::UpdateModel)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateModel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateModelInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_132 = &_input.api_id;
                let input_132 = input_132.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_132, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_133 = &_input.model_id;
                let input_133 = input_133.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "model_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let model_id = aws_smithy_http::label::fmt_string(input_133, false);
                if model_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "model_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/apis/{ApiId}/models/{ModelId}",
                    ApiId = api_id,
                    ModelId = model_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateModelInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PATCH").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_model(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateModel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateModel",
            "apigatewayv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateModelInput`](crate::input::UpdateModelInput)
    pub fn builder() -> crate::input::update_model_input::Builder {
        crate::input::update_model_input::Builder::default()
    }
}

/// See [`UpdateRouteInput`](crate::input::UpdateRouteInput)
pub mod update_route_input {
    /// A builder for [`UpdateRouteInput`](crate::input::UpdateRouteInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) api_key_required: std::option::Option<bool>,
        pub(crate) authorization_scopes: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) authorization_type: std::option::Option<crate::model::AuthorizationType>,
        pub(crate) authorizer_id: std::option::Option<std::string::String>,
        pub(crate) model_selection_expression: std::option::Option<std::string::String>,
        pub(crate) operation_name: std::option::Option<std::string::String>,
        pub(crate) request_models: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) request_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::ParameterConstraints>,
        >,
        pub(crate) route_id: std::option::Option<std::string::String>,
        pub(crate) route_key: std::option::Option<std::string::String>,
        pub(crate) route_response_selection_expression: std::option::Option<std::string::String>,
        pub(crate) target: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>Specifies whether an API key is required for the route. Supported only for WebSocket APIs.</p>
        pub fn api_key_required(mut self, input: bool) -> Self {
            self.api_key_required = Some(input);
            self
        }
        /// <p>Specifies whether an API key is required for the route. Supported only for WebSocket APIs.</p>
        pub fn set_api_key_required(mut self, input: std::option::Option<bool>) -> Self {
            self.api_key_required = input;
            self
        }
        /// Appends an item to `authorization_scopes`.
        ///
        /// To override the contents of this collection use [`set_authorization_scopes`](Self::set_authorization_scopes).
        ///
        /// <p>The authorization scopes supported by this route.</p>
        pub fn authorization_scopes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.authorization_scopes.unwrap_or_default();
            v.push(input.into());
            self.authorization_scopes = Some(v);
            self
        }
        /// <p>The authorization scopes supported by this route.</p>
        pub fn set_authorization_scopes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.authorization_scopes = input;
            self
        }
        /// <p>The authorization type for the route. For WebSocket APIs, valid values are NONE for open access, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer For HTTP APIs, valid values are NONE for open access, JWT for using JSON Web Tokens, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer.</p>
        pub fn authorization_type(mut self, input: crate::model::AuthorizationType) -> Self {
            self.authorization_type = Some(input);
            self
        }
        /// <p>The authorization type for the route. For WebSocket APIs, valid values are NONE for open access, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer For HTTP APIs, valid values are NONE for open access, JWT for using JSON Web Tokens, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer.</p>
        pub fn set_authorization_type(
            mut self,
            input: std::option::Option<crate::model::AuthorizationType>,
        ) -> Self {
            self.authorization_type = input;
            self
        }
        /// <p>The identifier of the Authorizer resource to be associated with this route. The authorizer identifier is generated by API Gateway when you created the authorizer.</p>
        pub fn authorizer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorizer_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Authorizer resource to be associated with this route. The authorizer identifier is generated by API Gateway when you created the authorizer.</p>
        pub fn set_authorizer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorizer_id = input;
            self
        }
        /// <p>The model selection expression for the route. Supported only for WebSocket APIs.</p>
        pub fn model_selection_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_selection_expression = Some(input.into());
            self
        }
        /// <p>The model selection expression for the route. Supported only for WebSocket APIs.</p>
        pub fn set_model_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_selection_expression = input;
            self
        }
        /// <p>The operation name for the route.</p>
        pub fn operation_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation_name = Some(input.into());
            self
        }
        /// <p>The operation name for the route.</p>
        pub fn set_operation_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.operation_name = input;
            self
        }
        /// Adds a key-value pair to `request_models`.
        ///
        /// To override the contents of this collection use [`set_request_models`](Self::set_request_models).
        ///
        /// <p>The request models for the route. Supported only for WebSocket APIs.</p>
        pub fn request_models(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.request_models.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.request_models = Some(hash_map);
            self
        }
        /// <p>The request models for the route. Supported only for WebSocket APIs.</p>
        pub fn set_request_models(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.request_models = input;
            self
        }
        /// Adds a key-value pair to `request_parameters`.
        ///
        /// To override the contents of this collection use [`set_request_parameters`](Self::set_request_parameters).
        ///
        /// <p>The request parameters for the route. Supported only for WebSocket APIs.</p>
        pub fn request_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::ParameterConstraints,
        ) -> Self {
            let mut hash_map = self.request_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.request_parameters = Some(hash_map);
            self
        }
        /// <p>The request parameters for the route. Supported only for WebSocket APIs.</p>
        pub fn set_request_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::ParameterConstraints>,
            >,
        ) -> Self {
            self.request_parameters = input;
            self
        }
        /// <p>The route ID.</p>
        pub fn route_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_id = Some(input.into());
            self
        }
        /// <p>The route ID.</p>
        pub fn set_route_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.route_id = input;
            self
        }
        /// <p>The route key for the route.</p>
        pub fn route_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_key = Some(input.into());
            self
        }
        /// <p>The route key for the route.</p>
        pub fn set_route_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.route_key = input;
            self
        }
        /// <p>The route response selection expression for the route. Supported only for WebSocket APIs.</p>
        pub fn route_response_selection_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.route_response_selection_expression = Some(input.into());
            self
        }
        /// <p>The route response selection expression for the route. Supported only for WebSocket APIs.</p>
        pub fn set_route_response_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.route_response_selection_expression = input;
            self
        }
        /// <p>The target for the route.</p>
        pub fn target(mut self, input: impl Into<std::string::String>) -> Self {
            self.target = Some(input.into());
            self
        }
        /// <p>The target for the route.</p>
        pub fn set_target(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRouteInput`](crate::input::UpdateRouteInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateRouteInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateRouteInput {
                api_id: self.api_id,
                api_key_required: self.api_key_required.unwrap_or_default(),
                authorization_scopes: self.authorization_scopes,
                authorization_type: self.authorization_type,
                authorizer_id: self.authorizer_id,
                model_selection_expression: self.model_selection_expression,
                operation_name: self.operation_name,
                request_models: self.request_models,
                request_parameters: self.request_parameters,
                route_id: self.route_id,
                route_key: self.route_key,
                route_response_selection_expression: self.route_response_selection_expression,
                target: self.target,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateRouteInputOperationOutputAlias = crate::operation::UpdateRoute;
#[doc(hidden)]
pub type UpdateRouteInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateRouteInput {
    /// Consumes the builder and constructs an Operation<[`UpdateRoute`](crate::operation::UpdateRoute)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateRoute,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateRouteInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_134 = &_input.api_id;
                let input_134 = input_134.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_134, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_135 = &_input.route_id;
                let input_135 = input_135.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "route_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let route_id = aws_smithy_http::label::fmt_string(input_135, false);
                if route_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "route_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/apis/{ApiId}/routes/{RouteId}",
                    ApiId = api_id,
                    RouteId = route_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateRouteInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PATCH").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_route(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateRoute::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateRoute",
            "apigatewayv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateRouteInput`](crate::input::UpdateRouteInput)
    pub fn builder() -> crate::input::update_route_input::Builder {
        crate::input::update_route_input::Builder::default()
    }
}

/// See [`UpdateRouteResponseInput`](crate::input::UpdateRouteResponseInput)
pub mod update_route_response_input {
    /// A builder for [`UpdateRouteResponseInput`](crate::input::UpdateRouteResponseInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) model_selection_expression: std::option::Option<std::string::String>,
        pub(crate) response_models: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) response_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::ParameterConstraints>,
        >,
        pub(crate) route_id: std::option::Option<std::string::String>,
        pub(crate) route_response_id: std::option::Option<std::string::String>,
        pub(crate) route_response_key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The model selection expression for the route response. Supported only for WebSocket APIs.</p>
        pub fn model_selection_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_selection_expression = Some(input.into());
            self
        }
        /// <p>The model selection expression for the route response. Supported only for WebSocket APIs.</p>
        pub fn set_model_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_selection_expression = input;
            self
        }
        /// Adds a key-value pair to `response_models`.
        ///
        /// To override the contents of this collection use [`set_response_models`](Self::set_response_models).
        ///
        /// <p>The response models for the route response.</p>
        pub fn response_models(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.response_models.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.response_models = Some(hash_map);
            self
        }
        /// <p>The response models for the route response.</p>
        pub fn set_response_models(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.response_models = input;
            self
        }
        /// Adds a key-value pair to `response_parameters`.
        ///
        /// To override the contents of this collection use [`set_response_parameters`](Self::set_response_parameters).
        ///
        /// <p>The route response parameters.</p>
        pub fn response_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::ParameterConstraints,
        ) -> Self {
            let mut hash_map = self.response_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.response_parameters = Some(hash_map);
            self
        }
        /// <p>The route response parameters.</p>
        pub fn set_response_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::ParameterConstraints>,
            >,
        ) -> Self {
            self.response_parameters = input;
            self
        }
        /// <p>The route ID.</p>
        pub fn route_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_id = Some(input.into());
            self
        }
        /// <p>The route ID.</p>
        pub fn set_route_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.route_id = input;
            self
        }
        /// <p>The route response ID.</p>
        pub fn route_response_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_response_id = Some(input.into());
            self
        }
        /// <p>The route response ID.</p>
        pub fn set_route_response_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.route_response_id = input;
            self
        }
        /// <p>The route response key.</p>
        pub fn route_response_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_response_key = Some(input.into());
            self
        }
        /// <p>The route response key.</p>
        pub fn set_route_response_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.route_response_key = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRouteResponseInput`](crate::input::UpdateRouteResponseInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateRouteResponseInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateRouteResponseInput {
                api_id: self.api_id,
                model_selection_expression: self.model_selection_expression,
                response_models: self.response_models,
                response_parameters: self.response_parameters,
                route_id: self.route_id,
                route_response_id: self.route_response_id,
                route_response_key: self.route_response_key,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateRouteResponseInputOperationOutputAlias = crate::operation::UpdateRouteResponse;
#[doc(hidden)]
pub type UpdateRouteResponseInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateRouteResponseInput {
    /// Consumes the builder and constructs an Operation<[`UpdateRouteResponse`](crate::operation::UpdateRouteResponse)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateRouteResponse,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateRouteResponseInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_136 = &_input.api_id;
                let input_136 = input_136.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_136, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_137 = &_input.route_id;
                let input_137 = input_137.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "route_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let route_id = aws_smithy_http::label::fmt_string(input_137, false);
                if route_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "route_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_138 = &_input.route_response_id;
                let input_138 = input_138.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "route_response_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let route_response_id = aws_smithy_http::label::fmt_string(input_138, false);
                if route_response_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "route_response_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/apis/{ApiId}/routes/{RouteId}/routeresponses/{RouteResponseId}",
                    ApiId = api_id,
                    RouteId = route_id,
                    RouteResponseId = route_response_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateRouteResponseInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PATCH").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_route_response(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateRouteResponse::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateRouteResponse",
            "apigatewayv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateRouteResponseInput`](crate::input::UpdateRouteResponseInput)
    pub fn builder() -> crate::input::update_route_response_input::Builder {
        crate::input::update_route_response_input::Builder::default()
    }
}

/// See [`UpdateStageInput`](crate::input::UpdateStageInput)
pub mod update_stage_input {
    /// A builder for [`UpdateStageInput`](crate::input::UpdateStageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_log_settings: std::option::Option<crate::model::AccessLogSettings>,
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) auto_deploy: std::option::Option<bool>,
        pub(crate) client_certificate_id: std::option::Option<std::string::String>,
        pub(crate) default_route_settings: std::option::Option<crate::model::RouteSettings>,
        pub(crate) deployment_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) route_settings: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::RouteSettings>,
        >,
        pub(crate) stage_name: std::option::Option<std::string::String>,
        pub(crate) stage_variables: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>Settings for logging access in this stage.</p>
        pub fn access_log_settings(mut self, input: crate::model::AccessLogSettings) -> Self {
            self.access_log_settings = Some(input);
            self
        }
        /// <p>Settings for logging access in this stage.</p>
        pub fn set_access_log_settings(
            mut self,
            input: std::option::Option<crate::model::AccessLogSettings>,
        ) -> Self {
            self.access_log_settings = input;
            self
        }
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>Specifies whether updates to an API automatically trigger a new deployment. The default value is false.</p>
        pub fn auto_deploy(mut self, input: bool) -> Self {
            self.auto_deploy = Some(input);
            self
        }
        /// <p>Specifies whether updates to an API automatically trigger a new deployment. The default value is false.</p>
        pub fn set_auto_deploy(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_deploy = input;
            self
        }
        /// <p>The identifier of a client certificate for a Stage.</p>
        pub fn client_certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_certificate_id = Some(input.into());
            self
        }
        /// <p>The identifier of a client certificate for a Stage.</p>
        pub fn set_client_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_certificate_id = input;
            self
        }
        /// <p>The default route settings for the stage.</p>
        pub fn default_route_settings(mut self, input: crate::model::RouteSettings) -> Self {
            self.default_route_settings = Some(input);
            self
        }
        /// <p>The default route settings for the stage.</p>
        pub fn set_default_route_settings(
            mut self,
            input: std::option::Option<crate::model::RouteSettings>,
        ) -> Self {
            self.default_route_settings = input;
            self
        }
        /// <p>The deployment identifier for the API stage. Can't be updated if autoDeploy is enabled.</p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_id = Some(input.into());
            self
        }
        /// <p>The deployment identifier for the API stage. Can't be updated if autoDeploy is enabled.</p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_id = input;
            self
        }
        /// <p>The description for the API stage.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description for the API stage.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Adds a key-value pair to `route_settings`.
        ///
        /// To override the contents of this collection use [`set_route_settings`](Self::set_route_settings).
        ///
        /// <p>Route settings for the stage.</p>
        pub fn route_settings(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::RouteSettings,
        ) -> Self {
            let mut hash_map = self.route_settings.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.route_settings = Some(hash_map);
            self
        }
        /// <p>Route settings for the stage.</p>
        pub fn set_route_settings(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::RouteSettings>,
            >,
        ) -> Self {
            self.route_settings = input;
            self
        }
        /// <p>The stage name. Stage names can contain only alphanumeric characters, hyphens, and underscores, or be $default. Maximum length is 128 characters.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stage_name = Some(input.into());
            self
        }
        /// <p>The stage name. Stage names can contain only alphanumeric characters, hyphens, and underscores, or be $default. Maximum length is 128 characters.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stage_name = input;
            self
        }
        /// Adds a key-value pair to `stage_variables`.
        ///
        /// To override the contents of this collection use [`set_stage_variables`](Self::set_stage_variables).
        ///
        /// <p>A map that defines the stage variables for a Stage. Variable names can have alphanumeric and underscore characters, and the values must match [A-Za-z0-9-._~:/?#&amp;=,]+.</p>
        pub fn stage_variables(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.stage_variables.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.stage_variables = Some(hash_map);
            self
        }
        /// <p>A map that defines the stage variables for a Stage. Variable names can have alphanumeric and underscore characters, and the values must match [A-Za-z0-9-._~:/?#&amp;=,]+.</p>
        pub fn set_stage_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.stage_variables = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateStageInput`](crate::input::UpdateStageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateStageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateStageInput {
                access_log_settings: self.access_log_settings,
                api_id: self.api_id,
                auto_deploy: self.auto_deploy.unwrap_or_default(),
                client_certificate_id: self.client_certificate_id,
                default_route_settings: self.default_route_settings,
                deployment_id: self.deployment_id,
                description: self.description,
                route_settings: self.route_settings,
                stage_name: self.stage_name,
                stage_variables: self.stage_variables,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateStageInputOperationOutputAlias = crate::operation::UpdateStage;
#[doc(hidden)]
pub type UpdateStageInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateStageInput {
    /// Consumes the builder and constructs an Operation<[`UpdateStage`](crate::operation::UpdateStage)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateStage,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateStageInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_139 = &_input.api_id;
                let input_139 = input_139.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_139, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_140 = &_input.stage_name;
                let input_140 = input_140.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "stage_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let stage_name = aws_smithy_http::label::fmt_string(input_140, false);
                if stage_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "stage_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/apis/{ApiId}/stages/{StageName}",
                    ApiId = api_id,
                    StageName = stage_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateStageInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PATCH").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_stage(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateStage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateStage",
            "apigatewayv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateStageInput`](crate::input::UpdateStageInput)
    pub fn builder() -> crate::input::update_stage_input::Builder {
        crate::input::update_stage_input::Builder::default()
    }
}

/// See [`UpdateVpcLinkInput`](crate::input::UpdateVpcLinkInput)
pub mod update_vpc_link_input {
    /// A builder for [`UpdateVpcLinkInput`](crate::input::UpdateVpcLinkInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) vpc_link_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the VPC link.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the VPC link.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The ID of the VPC link.</p>
        pub fn vpc_link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_link_id = Some(input.into());
            self
        }
        /// <p>The ID of the VPC link.</p>
        pub fn set_vpc_link_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_link_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateVpcLinkInput`](crate::input::UpdateVpcLinkInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateVpcLinkInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateVpcLinkInput {
                name: self.name,
                vpc_link_id: self.vpc_link_id,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateVpcLinkInputOperationOutputAlias = crate::operation::UpdateVpcLink;
#[doc(hidden)]
pub type UpdateVpcLinkInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateVpcLinkInput {
    /// Consumes the builder and constructs an Operation<[`UpdateVpcLink`](crate::operation::UpdateVpcLink)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateVpcLink,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateVpcLinkInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_141 = &_input.vpc_link_id;
                let input_141 = input_141.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "vpc_link_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let vpc_link_id = aws_smithy_http::label::fmt_string(input_141, false);
                if vpc_link_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "vpc_link_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v2/vpclinks/{VpcLinkId}", VpcLinkId = vpc_link_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateVpcLinkInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PATCH").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_vpc_link(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateVpcLink::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateVpcLink",
            "apigatewayv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateVpcLinkInput`](crate::input::UpdateVpcLinkInput)
    pub fn builder() -> crate::input::update_vpc_link_input::Builder {
        crate::input::update_vpc_link_input::Builder::default()
    }
}

/// <p>Updates a VPC link.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateVpcLinkInput {
    /// <p>The name of the VPC link.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The ID of the VPC link.</p>
    pub vpc_link_id: std::option::Option<std::string::String>,
}
impl UpdateVpcLinkInput {
    /// <p>The name of the VPC link.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The ID of the VPC link.</p>
    pub fn vpc_link_id(&self) -> std::option::Option<&str> {
        self.vpc_link_id.as_deref()
    }
}
impl std::fmt::Debug for UpdateVpcLinkInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateVpcLinkInput");
        formatter.field("name", &self.name);
        formatter.field("vpc_link_id", &self.vpc_link_id);
        formatter.finish()
    }
}

/// <p>Updates a Stage.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateStageInput {
    /// <p>Settings for logging access in this stage.</p>
    pub access_log_settings: std::option::Option<crate::model::AccessLogSettings>,
    /// <p>The API identifier.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>Specifies whether updates to an API automatically trigger a new deployment. The default value is false.</p>
    pub auto_deploy: bool,
    /// <p>The identifier of a client certificate for a Stage.</p>
    pub client_certificate_id: std::option::Option<std::string::String>,
    /// <p>The default route settings for the stage.</p>
    pub default_route_settings: std::option::Option<crate::model::RouteSettings>,
    /// <p>The deployment identifier for the API stage. Can't be updated if autoDeploy is enabled.</p>
    pub deployment_id: std::option::Option<std::string::String>,
    /// <p>The description for the API stage.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Route settings for the stage.</p>
    pub route_settings: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::RouteSettings>,
    >,
    /// <p>The stage name. Stage names can contain only alphanumeric characters, hyphens, and underscores, or be $default. Maximum length is 128 characters.</p>
    pub stage_name: std::option::Option<std::string::String>,
    /// <p>A map that defines the stage variables for a Stage. Variable names can have alphanumeric and underscore characters, and the values must match [A-Za-z0-9-._~:/?#&amp;=,]+.</p>
    pub stage_variables:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl UpdateStageInput {
    /// <p>Settings for logging access in this stage.</p>
    pub fn access_log_settings(&self) -> std::option::Option<&crate::model::AccessLogSettings> {
        self.access_log_settings.as_ref()
    }
    /// <p>The API identifier.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>Specifies whether updates to an API automatically trigger a new deployment. The default value is false.</p>
    pub fn auto_deploy(&self) -> bool {
        self.auto_deploy
    }
    /// <p>The identifier of a client certificate for a Stage.</p>
    pub fn client_certificate_id(&self) -> std::option::Option<&str> {
        self.client_certificate_id.as_deref()
    }
    /// <p>The default route settings for the stage.</p>
    pub fn default_route_settings(&self) -> std::option::Option<&crate::model::RouteSettings> {
        self.default_route_settings.as_ref()
    }
    /// <p>The deployment identifier for the API stage. Can't be updated if autoDeploy is enabled.</p>
    pub fn deployment_id(&self) -> std::option::Option<&str> {
        self.deployment_id.as_deref()
    }
    /// <p>The description for the API stage.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Route settings for the stage.</p>
    pub fn route_settings(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::RouteSettings>,
    > {
        self.route_settings.as_ref()
    }
    /// <p>The stage name. Stage names can contain only alphanumeric characters, hyphens, and underscores, or be $default. Maximum length is 128 characters.</p>
    pub fn stage_name(&self) -> std::option::Option<&str> {
        self.stage_name.as_deref()
    }
    /// <p>A map that defines the stage variables for a Stage. Variable names can have alphanumeric and underscore characters, and the values must match [A-Za-z0-9-._~:/?#&amp;=,]+.</p>
    pub fn stage_variables(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.stage_variables.as_ref()
    }
}
impl std::fmt::Debug for UpdateStageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateStageInput");
        formatter.field("access_log_settings", &self.access_log_settings);
        formatter.field("api_id", &self.api_id);
        formatter.field("auto_deploy", &self.auto_deploy);
        formatter.field("client_certificate_id", &self.client_certificate_id);
        formatter.field("default_route_settings", &self.default_route_settings);
        formatter.field("deployment_id", &self.deployment_id);
        formatter.field("description", &self.description);
        formatter.field("route_settings", &self.route_settings);
        formatter.field("stage_name", &self.stage_name);
        formatter.field("stage_variables", &self.stage_variables);
        formatter.finish()
    }
}

/// <p>Updates a RouteResponse.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRouteResponseInput {
    /// <p>The API identifier.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The model selection expression for the route response. Supported only for WebSocket APIs.</p>
    pub model_selection_expression: std::option::Option<std::string::String>,
    /// <p>The response models for the route response.</p>
    pub response_models:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The route response parameters.</p>
    pub response_parameters: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::ParameterConstraints>,
    >,
    /// <p>The route ID.</p>
    pub route_id: std::option::Option<std::string::String>,
    /// <p>The route response ID.</p>
    pub route_response_id: std::option::Option<std::string::String>,
    /// <p>The route response key.</p>
    pub route_response_key: std::option::Option<std::string::String>,
}
impl UpdateRouteResponseInput {
    /// <p>The API identifier.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The model selection expression for the route response. Supported only for WebSocket APIs.</p>
    pub fn model_selection_expression(&self) -> std::option::Option<&str> {
        self.model_selection_expression.as_deref()
    }
    /// <p>The response models for the route response.</p>
    pub fn response_models(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.response_models.as_ref()
    }
    /// <p>The route response parameters.</p>
    pub fn response_parameters(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::ParameterConstraints>,
    > {
        self.response_parameters.as_ref()
    }
    /// <p>The route ID.</p>
    pub fn route_id(&self) -> std::option::Option<&str> {
        self.route_id.as_deref()
    }
    /// <p>The route response ID.</p>
    pub fn route_response_id(&self) -> std::option::Option<&str> {
        self.route_response_id.as_deref()
    }
    /// <p>The route response key.</p>
    pub fn route_response_key(&self) -> std::option::Option<&str> {
        self.route_response_key.as_deref()
    }
}
impl std::fmt::Debug for UpdateRouteResponseInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRouteResponseInput");
        formatter.field("api_id", &self.api_id);
        formatter.field(
            "model_selection_expression",
            &self.model_selection_expression,
        );
        formatter.field("response_models", &self.response_models);
        formatter.field("response_parameters", &self.response_parameters);
        formatter.field("route_id", &self.route_id);
        formatter.field("route_response_id", &self.route_response_id);
        formatter.field("route_response_key", &self.route_response_key);
        formatter.finish()
    }
}

/// <p>Updates a Route.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRouteInput {
    /// <p>The API identifier.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>Specifies whether an API key is required for the route. Supported only for WebSocket APIs.</p>
    pub api_key_required: bool,
    /// <p>The authorization scopes supported by this route.</p>
    pub authorization_scopes: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The authorization type for the route. For WebSocket APIs, valid values are NONE for open access, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer For HTTP APIs, valid values are NONE for open access, JWT for using JSON Web Tokens, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer.</p>
    pub authorization_type: std::option::Option<crate::model::AuthorizationType>,
    /// <p>The identifier of the Authorizer resource to be associated with this route. The authorizer identifier is generated by API Gateway when you created the authorizer.</p>
    pub authorizer_id: std::option::Option<std::string::String>,
    /// <p>The model selection expression for the route. Supported only for WebSocket APIs.</p>
    pub model_selection_expression: std::option::Option<std::string::String>,
    /// <p>The operation name for the route.</p>
    pub operation_name: std::option::Option<std::string::String>,
    /// <p>The request models for the route. Supported only for WebSocket APIs.</p>
    pub request_models:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The request parameters for the route. Supported only for WebSocket APIs.</p>
    pub request_parameters: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::ParameterConstraints>,
    >,
    /// <p>The route ID.</p>
    pub route_id: std::option::Option<std::string::String>,
    /// <p>The route key for the route.</p>
    pub route_key: std::option::Option<std::string::String>,
    /// <p>The route response selection expression for the route. Supported only for WebSocket APIs.</p>
    pub route_response_selection_expression: std::option::Option<std::string::String>,
    /// <p>The target for the route.</p>
    pub target: std::option::Option<std::string::String>,
}
impl UpdateRouteInput {
    /// <p>The API identifier.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>Specifies whether an API key is required for the route. Supported only for WebSocket APIs.</p>
    pub fn api_key_required(&self) -> bool {
        self.api_key_required
    }
    /// <p>The authorization scopes supported by this route.</p>
    pub fn authorization_scopes(&self) -> std::option::Option<&[std::string::String]> {
        self.authorization_scopes.as_deref()
    }
    /// <p>The authorization type for the route. For WebSocket APIs, valid values are NONE for open access, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer For HTTP APIs, valid values are NONE for open access, JWT for using JSON Web Tokens, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer.</p>
    pub fn authorization_type(&self) -> std::option::Option<&crate::model::AuthorizationType> {
        self.authorization_type.as_ref()
    }
    /// <p>The identifier of the Authorizer resource to be associated with this route. The authorizer identifier is generated by API Gateway when you created the authorizer.</p>
    pub fn authorizer_id(&self) -> std::option::Option<&str> {
        self.authorizer_id.as_deref()
    }
    /// <p>The model selection expression for the route. Supported only for WebSocket APIs.</p>
    pub fn model_selection_expression(&self) -> std::option::Option<&str> {
        self.model_selection_expression.as_deref()
    }
    /// <p>The operation name for the route.</p>
    pub fn operation_name(&self) -> std::option::Option<&str> {
        self.operation_name.as_deref()
    }
    /// <p>The request models for the route. Supported only for WebSocket APIs.</p>
    pub fn request_models(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.request_models.as_ref()
    }
    /// <p>The request parameters for the route. Supported only for WebSocket APIs.</p>
    pub fn request_parameters(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::ParameterConstraints>,
    > {
        self.request_parameters.as_ref()
    }
    /// <p>The route ID.</p>
    pub fn route_id(&self) -> std::option::Option<&str> {
        self.route_id.as_deref()
    }
    /// <p>The route key for the route.</p>
    pub fn route_key(&self) -> std::option::Option<&str> {
        self.route_key.as_deref()
    }
    /// <p>The route response selection expression for the route. Supported only for WebSocket APIs.</p>
    pub fn route_response_selection_expression(&self) -> std::option::Option<&str> {
        self.route_response_selection_expression.as_deref()
    }
    /// <p>The target for the route.</p>
    pub fn target(&self) -> std::option::Option<&str> {
        self.target.as_deref()
    }
}
impl std::fmt::Debug for UpdateRouteInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRouteInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("api_key_required", &self.api_key_required);
        formatter.field("authorization_scopes", &self.authorization_scopes);
        formatter.field("authorization_type", &self.authorization_type);
        formatter.field("authorizer_id", &self.authorizer_id);
        formatter.field(
            "model_selection_expression",
            &self.model_selection_expression,
        );
        formatter.field("operation_name", &self.operation_name);
        formatter.field("request_models", &self.request_models);
        formatter.field("request_parameters", &self.request_parameters);
        formatter.field("route_id", &self.route_id);
        formatter.field("route_key", &self.route_key);
        formatter.field(
            "route_response_selection_expression",
            &self.route_response_selection_expression,
        );
        formatter.field("target", &self.target);
        formatter.finish()
    }
}

/// <p>Updates a Model.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateModelInput {
    /// <p>The API identifier.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The content-type for the model, for example, "application/json".</p>
    pub content_type: std::option::Option<std::string::String>,
    /// <p>The description of the model.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The model ID.</p>
    pub model_id: std::option::Option<std::string::String>,
    /// <p>The name of the model.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The schema for the model. For application/json models, this should be JSON schema draft 4 model.</p>
    pub schema: std::option::Option<std::string::String>,
}
impl UpdateModelInput {
    /// <p>The API identifier.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The content-type for the model, for example, "application/json".</p>
    pub fn content_type(&self) -> std::option::Option<&str> {
        self.content_type.as_deref()
    }
    /// <p>The description of the model.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The model ID.</p>
    pub fn model_id(&self) -> std::option::Option<&str> {
        self.model_id.as_deref()
    }
    /// <p>The name of the model.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The schema for the model. For application/json models, this should be JSON schema draft 4 model.</p>
    pub fn schema(&self) -> std::option::Option<&str> {
        self.schema.as_deref()
    }
}
impl std::fmt::Debug for UpdateModelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateModelInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("content_type", &self.content_type);
        formatter.field("description", &self.description);
        formatter.field("model_id", &self.model_id);
        formatter.field("name", &self.name);
        formatter.field("schema", &self.schema);
        formatter.finish()
    }
}

/// <p>Updates an IntegrationResponses.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateIntegrationResponseInput {
    /// <p>The API identifier.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p>
    /// <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p>
    /// <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p>
    /// <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
    pub content_handling_strategy: std::option::Option<crate::model::ContentHandlingStrategy>,
    /// <p>The integration ID.</p>
    pub integration_id: std::option::Option<std::string::String>,
    /// <p>The integration response ID.</p>
    pub integration_response_id: std::option::Option<std::string::String>,
    /// <p>The integration response key.</p>
    pub integration_response_key: std::option::Option<std::string::String>,
    /// <p>A key-value map specifying response parameters that are passed to the method response from the backend. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of method.response.header.<replaceable>
    /// {name}
    /// </replaceable> , where name is a valid and unique header name. The mapped non-static value must match the pattern of integration.response.header.<replaceable>
    /// {name}
    /// </replaceable> or integration.response.body.<replaceable>
    /// {JSON-expression}
    /// </replaceable> , where <replaceable>
    /// {name}
    /// </replaceable> is a valid and unique response header name and <replaceable>
    /// {JSON-expression}
    /// </replaceable> is a valid JSON expression without the $ prefix.</p>
    pub response_parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The collection of response templates for the integration response as a string-to-string map of key-value pairs. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.</p>
    pub response_templates:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The template selection expression for the integration response. Supported only for WebSocket APIs.</p>
    pub template_selection_expression: std::option::Option<std::string::String>,
}
impl UpdateIntegrationResponseInput {
    /// <p>The API identifier.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p>
    /// <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p>
    /// <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p>
    /// <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
    pub fn content_handling_strategy(
        &self,
    ) -> std::option::Option<&crate::model::ContentHandlingStrategy> {
        self.content_handling_strategy.as_ref()
    }
    /// <p>The integration ID.</p>
    pub fn integration_id(&self) -> std::option::Option<&str> {
        self.integration_id.as_deref()
    }
    /// <p>The integration response ID.</p>
    pub fn integration_response_id(&self) -> std::option::Option<&str> {
        self.integration_response_id.as_deref()
    }
    /// <p>The integration response key.</p>
    pub fn integration_response_key(&self) -> std::option::Option<&str> {
        self.integration_response_key.as_deref()
    }
    /// <p>A key-value map specifying response parameters that are passed to the method response from the backend. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of method.response.header.<replaceable>
    /// {name}
    /// </replaceable> , where name is a valid and unique header name. The mapped non-static value must match the pattern of integration.response.header.<replaceable>
    /// {name}
    /// </replaceable> or integration.response.body.<replaceable>
    /// {JSON-expression}
    /// </replaceable> , where <replaceable>
    /// {name}
    /// </replaceable> is a valid and unique response header name and <replaceable>
    /// {JSON-expression}
    /// </replaceable> is a valid JSON expression without the $ prefix.</p>
    pub fn response_parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.response_parameters.as_ref()
    }
    /// <p>The collection of response templates for the integration response as a string-to-string map of key-value pairs. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.</p>
    pub fn response_templates(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.response_templates.as_ref()
    }
    /// <p>The template selection expression for the integration response. Supported only for WebSocket APIs.</p>
    pub fn template_selection_expression(&self) -> std::option::Option<&str> {
        self.template_selection_expression.as_deref()
    }
}
impl std::fmt::Debug for UpdateIntegrationResponseInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateIntegrationResponseInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("content_handling_strategy", &self.content_handling_strategy);
        formatter.field("integration_id", &self.integration_id);
        formatter.field("integration_response_id", &self.integration_response_id);
        formatter.field("integration_response_key", &self.integration_response_key);
        formatter.field("response_parameters", &self.response_parameters);
        formatter.field("response_templates", &self.response_templates);
        formatter.field(
            "template_selection_expression",
            &self.template_selection_expression,
        );
        formatter.finish()
    }
}

/// <p>Updates an Integration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateIntegrationInput {
    /// <p>The API identifier.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The ID of the VPC link for a private integration. Supported only for HTTP APIs.</p>
    pub connection_id: std::option::Option<std::string::String>,
    /// <p>The type of the network connection to the integration endpoint. Specify INTERNET for connections through the public routable internet or VPC_LINK for private connections between API Gateway and resources in a VPC. The default value is INTERNET.</p>
    pub connection_type: std::option::Option<crate::model::ConnectionType>,
    /// <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p>
    /// <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p>
    /// <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p>
    /// <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
    pub content_handling_strategy: std::option::Option<crate::model::ContentHandlingStrategy>,
    /// <p>Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, specify null.</p>
    pub credentials_arn: std::option::Option<std::string::String>,
    /// <p>The description of the integration</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The integration ID.</p>
    pub integration_id: std::option::Option<std::string::String>,
    /// <p>Specifies the integration's HTTP method type.</p>
    pub integration_method: std::option::Option<std::string::String>,
    /// <p>Supported only for HTTP API AWS_PROXY integrations. Specifies the AWS service action to invoke. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html">Integration subtype reference</a>.</p>
    pub integration_subtype: std::option::Option<std::string::String>,
    /// <p>The integration type of an integration. One of the following:</p>
    /// <p>AWS: for integrating the route or method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration. Supported only for WebSocket APIs.</p>
    /// <p>AWS_PROXY: for integrating the route or method request with a Lambda function or other AWS service action. This integration is also referred to as a Lambda proxy integration.</p>
    /// <p>HTTP: for integrating the route or method request with an HTTP endpoint. This integration is also referred to as the HTTP custom integration. Supported only for WebSocket APIs.</p>
    /// <p>HTTP_PROXY: for integrating the route or method request with an HTTP endpoint, with the client request passed through as-is. This is also referred to as HTTP proxy integration. For HTTP API private integrations, use an HTTP_PROXY integration.</p>
    /// <p>MOCK: for integrating the route or method request with API Gateway as a "loopback" endpoint without invoking any backend. Supported only for WebSocket APIs.</p>
    pub integration_type: std::option::Option<crate::model::IntegrationType>,
    /// <p>For a Lambda integration, specify the URI of a Lambda function.</p>
    /// <p>For an HTTP integration, specify a fully-qualified URL.</p>
    /// <p>For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service. If you specify the ARN of an AWS Cloud Map service, API Gateway uses DiscoverInstances to identify resources. You can use query parameters to target specific resources. To learn more, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_DiscoverInstances.html">DiscoverInstances</a>. For private integrations, all resources must be owned by the same AWS account.</p>
    pub integration_uri: std::option::Option<std::string::String>,
    /// <p>Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER. Supported only for WebSocket APIs.</p>
    /// <p>WHEN_NO_MATCH passes the request body for unmapped content types through to the integration backend without transformation.</p>
    /// <p>NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type response.</p>
    /// <p>WHEN_NO_TEMPLATES allows pass-through when the integration has no content types mapped to templates. However, if there is at least one content type defined, unmapped content types will be rejected with the same HTTP 415 Unsupported Media Type response.</p>
    pub passthrough_behavior: std::option::Option<crate::model::PassthroughBehavior>,
    /// <p>Specifies the format of the payload sent to an integration. Required for HTTP APIs.</p>
    pub payload_format_version: std::option::Option<std::string::String>,
    /// <p>For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the backend. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the backend. The method request parameter value must match the pattern of method.request.<replaceable>
    /// {location}
    /// </replaceable>.<replaceable>
    /// {name}
    /// </replaceable> , where <replaceable>
    /// {location}
    /// </replaceable> is querystring, path, or header; and <replaceable>
    /// {name}
    /// </replaceable> must be a valid and unique method request parameter name.</p>
    /// <p>For HTTP API integrations with a specified integrationSubtype, request parameters are a key-value map specifying parameters that are passed to AWS_PROXY integrations. You can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services.html">Working with AWS service integrations for HTTP APIs</a>.</p>
    /// <p>For HTTP API integrations, without a specified integrationSubtype request parameters are a key-value map specifying how to transform HTTP requests before sending them to the backend. The key should follow the pattern &lt;action&gt;:&lt;header|querystring|path&gt;.&lt;location&gt; where action can be append, overwrite or remove. For values, you can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.">Transforming API requests and responses</a>.</p>
    pub request_parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value. Supported only for WebSocket APIs.</p>
    pub request_templates:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Supported only for HTTP APIs. You use response parameters to transform the HTTP response from a backend integration before returning the response to clients. Specify a key-value map from a selection key to response parameters. The selection key must be a valid HTTP status code within the range of 200-599. Response parameters are a key-value map. The key must match pattern &lt;action&gt;:&lt;header&gt;.&lt;location&gt; or overwrite.statuscode. The action can be append, overwrite or remove. The value can be a static value, or map to response data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
    pub response_parameters: std::option::Option<
        std::collections::HashMap<
            std::string::String,
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    >,
    /// <p>The template selection expression for the integration.</p>
    pub template_selection_expression: std::option::Option<std::string::String>,
    /// <p>Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs. The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.</p>
    pub timeout_in_millis: i32,
    /// <p>The TLS configuration for a private integration. If you specify a TLS configuration, private integration traffic uses the HTTPS protocol. Supported only for HTTP APIs.</p>
    pub tls_config: std::option::Option<crate::model::TlsConfigInput>,
}
impl UpdateIntegrationInput {
    /// <p>The API identifier.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The ID of the VPC link for a private integration. Supported only for HTTP APIs.</p>
    pub fn connection_id(&self) -> std::option::Option<&str> {
        self.connection_id.as_deref()
    }
    /// <p>The type of the network connection to the integration endpoint. Specify INTERNET for connections through the public routable internet or VPC_LINK for private connections between API Gateway and resources in a VPC. The default value is INTERNET.</p>
    pub fn connection_type(&self) -> std::option::Option<&crate::model::ConnectionType> {
        self.connection_type.as_ref()
    }
    /// <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p>
    /// <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p>
    /// <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p>
    /// <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
    pub fn content_handling_strategy(
        &self,
    ) -> std::option::Option<&crate::model::ContentHandlingStrategy> {
        self.content_handling_strategy.as_ref()
    }
    /// <p>Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, specify null.</p>
    pub fn credentials_arn(&self) -> std::option::Option<&str> {
        self.credentials_arn.as_deref()
    }
    /// <p>The description of the integration</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The integration ID.</p>
    pub fn integration_id(&self) -> std::option::Option<&str> {
        self.integration_id.as_deref()
    }
    /// <p>Specifies the integration's HTTP method type.</p>
    pub fn integration_method(&self) -> std::option::Option<&str> {
        self.integration_method.as_deref()
    }
    /// <p>Supported only for HTTP API AWS_PROXY integrations. Specifies the AWS service action to invoke. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html">Integration subtype reference</a>.</p>
    pub fn integration_subtype(&self) -> std::option::Option<&str> {
        self.integration_subtype.as_deref()
    }
    /// <p>The integration type of an integration. One of the following:</p>
    /// <p>AWS: for integrating the route or method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration. Supported only for WebSocket APIs.</p>
    /// <p>AWS_PROXY: for integrating the route or method request with a Lambda function or other AWS service action. This integration is also referred to as a Lambda proxy integration.</p>
    /// <p>HTTP: for integrating the route or method request with an HTTP endpoint. This integration is also referred to as the HTTP custom integration. Supported only for WebSocket APIs.</p>
    /// <p>HTTP_PROXY: for integrating the route or method request with an HTTP endpoint, with the client request passed through as-is. This is also referred to as HTTP proxy integration. For HTTP API private integrations, use an HTTP_PROXY integration.</p>
    /// <p>MOCK: for integrating the route or method request with API Gateway as a "loopback" endpoint without invoking any backend. Supported only for WebSocket APIs.</p>
    pub fn integration_type(&self) -> std::option::Option<&crate::model::IntegrationType> {
        self.integration_type.as_ref()
    }
    /// <p>For a Lambda integration, specify the URI of a Lambda function.</p>
    /// <p>For an HTTP integration, specify a fully-qualified URL.</p>
    /// <p>For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service. If you specify the ARN of an AWS Cloud Map service, API Gateway uses DiscoverInstances to identify resources. You can use query parameters to target specific resources. To learn more, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_DiscoverInstances.html">DiscoverInstances</a>. For private integrations, all resources must be owned by the same AWS account.</p>
    pub fn integration_uri(&self) -> std::option::Option<&str> {
        self.integration_uri.as_deref()
    }
    /// <p>Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER. Supported only for WebSocket APIs.</p>
    /// <p>WHEN_NO_MATCH passes the request body for unmapped content types through to the integration backend without transformation.</p>
    /// <p>NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type response.</p>
    /// <p>WHEN_NO_TEMPLATES allows pass-through when the integration has no content types mapped to templates. However, if there is at least one content type defined, unmapped content types will be rejected with the same HTTP 415 Unsupported Media Type response.</p>
    pub fn passthrough_behavior(&self) -> std::option::Option<&crate::model::PassthroughBehavior> {
        self.passthrough_behavior.as_ref()
    }
    /// <p>Specifies the format of the payload sent to an integration. Required for HTTP APIs.</p>
    pub fn payload_format_version(&self) -> std::option::Option<&str> {
        self.payload_format_version.as_deref()
    }
    /// <p>For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the backend. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the backend. The method request parameter value must match the pattern of method.request.<replaceable>
    /// {location}
    /// </replaceable>.<replaceable>
    /// {name}
    /// </replaceable> , where <replaceable>
    /// {location}
    /// </replaceable> is querystring, path, or header; and <replaceable>
    /// {name}
    /// </replaceable> must be a valid and unique method request parameter name.</p>
    /// <p>For HTTP API integrations with a specified integrationSubtype, request parameters are a key-value map specifying parameters that are passed to AWS_PROXY integrations. You can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services.html">Working with AWS service integrations for HTTP APIs</a>.</p>
    /// <p>For HTTP API integrations, without a specified integrationSubtype request parameters are a key-value map specifying how to transform HTTP requests before sending them to the backend. The key should follow the pattern &lt;action&gt;:&lt;header|querystring|path&gt;.&lt;location&gt; where action can be append, overwrite or remove. For values, you can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.">Transforming API requests and responses</a>.</p>
    pub fn request_parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.request_parameters.as_ref()
    }
    /// <p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value. Supported only for WebSocket APIs.</p>
    pub fn request_templates(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.request_templates.as_ref()
    }
    /// <p>Supported only for HTTP APIs. You use response parameters to transform the HTTP response from a backend integration before returning the response to clients. Specify a key-value map from a selection key to response parameters. The selection key must be a valid HTTP status code within the range of 200-599. Response parameters are a key-value map. The key must match pattern &lt;action&gt;:&lt;header&gt;.&lt;location&gt; or overwrite.statuscode. The action can be append, overwrite or remove. The value can be a static value, or map to response data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
    pub fn response_parameters(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<
            std::string::String,
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    > {
        self.response_parameters.as_ref()
    }
    /// <p>The template selection expression for the integration.</p>
    pub fn template_selection_expression(&self) -> std::option::Option<&str> {
        self.template_selection_expression.as_deref()
    }
    /// <p>Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs. The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.</p>
    pub fn timeout_in_millis(&self) -> i32 {
        self.timeout_in_millis
    }
    /// <p>The TLS configuration for a private integration. If you specify a TLS configuration, private integration traffic uses the HTTPS protocol. Supported only for HTTP APIs.</p>
    pub fn tls_config(&self) -> std::option::Option<&crate::model::TlsConfigInput> {
        self.tls_config.as_ref()
    }
}
impl std::fmt::Debug for UpdateIntegrationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateIntegrationInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("connection_id", &self.connection_id);
        formatter.field("connection_type", &self.connection_type);
        formatter.field("content_handling_strategy", &self.content_handling_strategy);
        formatter.field("credentials_arn", &self.credentials_arn);
        formatter.field("description", &self.description);
        formatter.field("integration_id", &self.integration_id);
        formatter.field("integration_method", &self.integration_method);
        formatter.field("integration_subtype", &self.integration_subtype);
        formatter.field("integration_type", &self.integration_type);
        formatter.field("integration_uri", &self.integration_uri);
        formatter.field("passthrough_behavior", &self.passthrough_behavior);
        formatter.field("payload_format_version", &self.payload_format_version);
        formatter.field("request_parameters", &self.request_parameters);
        formatter.field("request_templates", &self.request_templates);
        formatter.field("response_parameters", &self.response_parameters);
        formatter.field(
            "template_selection_expression",
            &self.template_selection_expression,
        );
        formatter.field("timeout_in_millis", &self.timeout_in_millis);
        formatter.field("tls_config", &self.tls_config);
        formatter.finish()
    }
}

/// <p>Updates a DomainName.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDomainNameInput {
    /// <p>The domain name.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The domain name configurations.</p>
    pub domain_name_configurations:
        std::option::Option<std::vec::Vec<crate::model::DomainNameConfiguration>>,
    /// <p>The mutual TLS authentication configuration for a custom domain name.</p>
    pub mutual_tls_authentication: std::option::Option<crate::model::MutualTlsAuthenticationInput>,
}
impl UpdateDomainNameInput {
    /// <p>The domain name.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>The domain name configurations.</p>
    pub fn domain_name_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::DomainNameConfiguration]> {
        self.domain_name_configurations.as_deref()
    }
    /// <p>The mutual TLS authentication configuration for a custom domain name.</p>
    pub fn mutual_tls_authentication(
        &self,
    ) -> std::option::Option<&crate::model::MutualTlsAuthenticationInput> {
        self.mutual_tls_authentication.as_ref()
    }
}
impl std::fmt::Debug for UpdateDomainNameInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDomainNameInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field(
            "domain_name_configurations",
            &self.domain_name_configurations,
        );
        formatter.field("mutual_tls_authentication", &self.mutual_tls_authentication);
        formatter.finish()
    }
}

/// <p>Updates a Deployment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDeploymentInput {
    /// <p>The API identifier.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The deployment ID.</p>
    pub deployment_id: std::option::Option<std::string::String>,
    /// <p>The description for the deployment resource.</p>
    pub description: std::option::Option<std::string::String>,
}
impl UpdateDeploymentInput {
    /// <p>The API identifier.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The deployment ID.</p>
    pub fn deployment_id(&self) -> std::option::Option<&str> {
        self.deployment_id.as_deref()
    }
    /// <p>The description for the deployment resource.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for UpdateDeploymentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDeploymentInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("deployment_id", &self.deployment_id);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}

/// <p>Updates an Authorizer.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAuthorizerInput {
    /// <p>The API identifier.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, don't specify this parameter.</p>
    pub authorizer_credentials_arn: std::option::Option<std::string::String>,
    /// <p>The authorizer identifier.</p>
    pub authorizer_id: std::option::Option<std::string::String>,
    /// <p>Specifies the format of the payload sent to an HTTP API Lambda authorizer. Required for HTTP API Lambda authorizers. Supported values are 1.0 and 2.0. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p>
    pub authorizer_payload_format_version: std::option::Option<std::string::String>,
    /// <p>The time to live (TTL) for cached authorizer results, in seconds. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway caches authorizer responses. The maximum value is 3600, or 1 hour. Supported only for HTTP API Lambda authorizers.</p>
    pub authorizer_result_ttl_in_seconds: i32,
    /// <p>The authorizer type. Specify REQUEST for a Lambda function using incoming request parameters. Specify JWT to use JSON Web Tokens (supported only for HTTP APIs).</p>
    pub authorizer_type: std::option::Option<crate::model::AuthorizerType>,
    /// <p>The authorizer's Uniform Resource Identifier (URI). For REQUEST authorizers, this must be a well-formed Lambda function URI, for example, arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:<replaceable>
    /// {account_id}
    /// </replaceable>:function:<replaceable>
    /// {lambda_function_name}
    /// </replaceable>/invocations. In general, the URI has this form: arn:aws:apigateway:<replaceable>
    /// {region}
    /// </replaceable>:lambda:path/<replaceable>
    /// {service_api}
    /// </replaceable> , where <replaceable></replaceable>{region} is the same as the region hosting the Lambda function, path indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial /. For Lambda functions, this is usually of the form /2015-03-31/functions/[FunctionARN]/invocations. Supported only for REQUEST authorizers.</p>
    pub authorizer_uri: std::option::Option<std::string::String>,
    /// <p>Specifies whether a Lambda authorizer returns a response in a simple format. By default, a Lambda authorizer must return an IAM policy. If enabled, the Lambda authorizer can return a boolean value instead of an IAM policy. Supported only for HTTP APIs. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a></p>
    pub enable_simple_responses: bool,
    /// <p>The identity source for which authorization is requested.</p>
    /// <p>For a REQUEST authorizer, this is optional. The value is a set of one or more mapping expressions of the specified request parameters. The identity source can be headers, query string parameters, stage variables, and context parameters. For example, if an Auth header and a Name query string parameter are defined as identity sources, this value is route.request.header.Auth, route.request.querystring.Name for WebSocket APIs. For HTTP APIs, use selection expressions prefixed with $, for example, $request.header.Auth, $request.querystring.Name. These parameters are used to perform runtime validation for Lambda-based authorizers by verifying all of the identity-related request parameters are present in the request, not null, and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function. Otherwise, it returns a 401 Unauthorized response without calling the Lambda function. For HTTP APIs, identity sources are also used as the cache key when caching is enabled. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p>
    /// <p>For JWT, a single entry that specifies where to extract the JSON Web Token (JWT) from inbound requests. Currently only header-based and query parameter-based selections are supported, for example $request.header.Authorization.</p>
    pub identity_source: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>This parameter is not used.</p>
    pub identity_validation_expression: std::option::Option<std::string::String>,
    /// <p>Represents the configuration of a JWT authorizer. Required for the JWT authorizer type. Supported only for HTTP APIs.</p>
    pub jwt_configuration: std::option::Option<crate::model::JwtConfiguration>,
    /// <p>The name of the authorizer.</p>
    pub name: std::option::Option<std::string::String>,
}
impl UpdateAuthorizerInput {
    /// <p>The API identifier.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, don't specify this parameter.</p>
    pub fn authorizer_credentials_arn(&self) -> std::option::Option<&str> {
        self.authorizer_credentials_arn.as_deref()
    }
    /// <p>The authorizer identifier.</p>
    pub fn authorizer_id(&self) -> std::option::Option<&str> {
        self.authorizer_id.as_deref()
    }
    /// <p>Specifies the format of the payload sent to an HTTP API Lambda authorizer. Required for HTTP API Lambda authorizers. Supported values are 1.0 and 2.0. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p>
    pub fn authorizer_payload_format_version(&self) -> std::option::Option<&str> {
        self.authorizer_payload_format_version.as_deref()
    }
    /// <p>The time to live (TTL) for cached authorizer results, in seconds. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway caches authorizer responses. The maximum value is 3600, or 1 hour. Supported only for HTTP API Lambda authorizers.</p>
    pub fn authorizer_result_ttl_in_seconds(&self) -> i32 {
        self.authorizer_result_ttl_in_seconds
    }
    /// <p>The authorizer type. Specify REQUEST for a Lambda function using incoming request parameters. Specify JWT to use JSON Web Tokens (supported only for HTTP APIs).</p>
    pub fn authorizer_type(&self) -> std::option::Option<&crate::model::AuthorizerType> {
        self.authorizer_type.as_ref()
    }
    /// <p>The authorizer's Uniform Resource Identifier (URI). For REQUEST authorizers, this must be a well-formed Lambda function URI, for example, arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:<replaceable>
    /// {account_id}
    /// </replaceable>:function:<replaceable>
    /// {lambda_function_name}
    /// </replaceable>/invocations. In general, the URI has this form: arn:aws:apigateway:<replaceable>
    /// {region}
    /// </replaceable>:lambda:path/<replaceable>
    /// {service_api}
    /// </replaceable> , where <replaceable></replaceable>{region} is the same as the region hosting the Lambda function, path indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial /. For Lambda functions, this is usually of the form /2015-03-31/functions/[FunctionARN]/invocations. Supported only for REQUEST authorizers.</p>
    pub fn authorizer_uri(&self) -> std::option::Option<&str> {
        self.authorizer_uri.as_deref()
    }
    /// <p>Specifies whether a Lambda authorizer returns a response in a simple format. By default, a Lambda authorizer must return an IAM policy. If enabled, the Lambda authorizer can return a boolean value instead of an IAM policy. Supported only for HTTP APIs. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a></p>
    pub fn enable_simple_responses(&self) -> bool {
        self.enable_simple_responses
    }
    /// <p>The identity source for which authorization is requested.</p>
    /// <p>For a REQUEST authorizer, this is optional. The value is a set of one or more mapping expressions of the specified request parameters. The identity source can be headers, query string parameters, stage variables, and context parameters. For example, if an Auth header and a Name query string parameter are defined as identity sources, this value is route.request.header.Auth, route.request.querystring.Name for WebSocket APIs. For HTTP APIs, use selection expressions prefixed with $, for example, $request.header.Auth, $request.querystring.Name. These parameters are used to perform runtime validation for Lambda-based authorizers by verifying all of the identity-related request parameters are present in the request, not null, and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function. Otherwise, it returns a 401 Unauthorized response without calling the Lambda function. For HTTP APIs, identity sources are also used as the cache key when caching is enabled. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p>
    /// <p>For JWT, a single entry that specifies where to extract the JSON Web Token (JWT) from inbound requests. Currently only header-based and query parameter-based selections are supported, for example $request.header.Authorization.</p>
    pub fn identity_source(&self) -> std::option::Option<&[std::string::String]> {
        self.identity_source.as_deref()
    }
    /// <p>This parameter is not used.</p>
    pub fn identity_validation_expression(&self) -> std::option::Option<&str> {
        self.identity_validation_expression.as_deref()
    }
    /// <p>Represents the configuration of a JWT authorizer. Required for the JWT authorizer type. Supported only for HTTP APIs.</p>
    pub fn jwt_configuration(&self) -> std::option::Option<&crate::model::JwtConfiguration> {
        self.jwt_configuration.as_ref()
    }
    /// <p>The name of the authorizer.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for UpdateAuthorizerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAuthorizerInput");
        formatter.field("api_id", &self.api_id);
        formatter.field(
            "authorizer_credentials_arn",
            &self.authorizer_credentials_arn,
        );
        formatter.field("authorizer_id", &self.authorizer_id);
        formatter.field(
            "authorizer_payload_format_version",
            &self.authorizer_payload_format_version,
        );
        formatter.field(
            "authorizer_result_ttl_in_seconds",
            &self.authorizer_result_ttl_in_seconds,
        );
        formatter.field("authorizer_type", &self.authorizer_type);
        formatter.field("authorizer_uri", &self.authorizer_uri);
        formatter.field("enable_simple_responses", &self.enable_simple_responses);
        formatter.field("identity_source", &self.identity_source);
        formatter.field(
            "identity_validation_expression",
            &self.identity_validation_expression,
        );
        formatter.field("jwt_configuration", &self.jwt_configuration);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

/// <p>Updates an ApiMapping.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateApiMappingInput {
    /// <p>The API identifier.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The API mapping identifier.</p>
    pub api_mapping_id: std::option::Option<std::string::String>,
    /// <p>The API mapping key.</p>
    pub api_mapping_key: std::option::Option<std::string::String>,
    /// <p>The domain name.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The API stage.</p>
    pub stage: std::option::Option<std::string::String>,
}
impl UpdateApiMappingInput {
    /// <p>The API identifier.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The API mapping identifier.</p>
    pub fn api_mapping_id(&self) -> std::option::Option<&str> {
        self.api_mapping_id.as_deref()
    }
    /// <p>The API mapping key.</p>
    pub fn api_mapping_key(&self) -> std::option::Option<&str> {
        self.api_mapping_key.as_deref()
    }
    /// <p>The domain name.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>The API stage.</p>
    pub fn stage(&self) -> std::option::Option<&str> {
        self.stage.as_deref()
    }
}
impl std::fmt::Debug for UpdateApiMappingInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateApiMappingInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("api_mapping_id", &self.api_mapping_id);
        formatter.field("api_mapping_key", &self.api_mapping_key);
        formatter.field("domain_name", &self.domain_name);
        formatter.field("stage", &self.stage);
        formatter.finish()
    }
}

/// <p>Updates an Api.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateApiInput {
    /// <p>The API identifier.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>An API key selection expression. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions">API Key Selection Expressions</a>.</p>
    pub api_key_selection_expression: std::option::Option<std::string::String>,
    /// <p>A CORS configuration. Supported only for HTTP APIs.</p>
    pub cors_configuration: std::option::Option<crate::model::Cors>,
    /// <p>This property is part of quick create. It specifies the credentials required for the integration, if any. For a Lambda integration, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, don't specify this parameter. Currently, this property is not used for HTTP integrations. If provided, this value replaces the credentials associated with the quick create integration. Supported only for HTTP APIs.</p>
    pub credentials_arn: std::option::Option<std::string::String>,
    /// <p>The description of the API.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Avoid validating models when creating a deployment. Supported only for WebSocket APIs.</p>
    pub disable_schema_validation: bool,
    /// <p>Specifies whether clients can invoke your API by using the default execute-api endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
    pub disable_execute_api_endpoint: bool,
    /// <p>The name of the API.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>This property is part of quick create. If not specified, the route created using quick create is kept. Otherwise, this value replaces the route key of the quick create route. Additional routes may still be added after the API is updated. Supported only for HTTP APIs.</p>
    pub route_key: std::option::Option<std::string::String>,
    /// <p>The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.</p>
    pub route_selection_expression: std::option::Option<std::string::String>,
    /// <p>This property is part of quick create. For HTTP integrations, specify a fully qualified URL. For Lambda integrations, specify a function ARN. The type of the integration will be HTTP_PROXY or AWS_PROXY, respectively. The value provided updates the integration URI and integration type. You can update a quick-created target, but you can't remove it from an API. Supported only for HTTP APIs.</p>
    pub target: std::option::Option<std::string::String>,
    /// <p>A version identifier for the API.</p>
    pub version: std::option::Option<std::string::String>,
}
impl UpdateApiInput {
    /// <p>The API identifier.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>An API key selection expression. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions">API Key Selection Expressions</a>.</p>
    pub fn api_key_selection_expression(&self) -> std::option::Option<&str> {
        self.api_key_selection_expression.as_deref()
    }
    /// <p>A CORS configuration. Supported only for HTTP APIs.</p>
    pub fn cors_configuration(&self) -> std::option::Option<&crate::model::Cors> {
        self.cors_configuration.as_ref()
    }
    /// <p>This property is part of quick create. It specifies the credentials required for the integration, if any. For a Lambda integration, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, don't specify this parameter. Currently, this property is not used for HTTP integrations. If provided, this value replaces the credentials associated with the quick create integration. Supported only for HTTP APIs.</p>
    pub fn credentials_arn(&self) -> std::option::Option<&str> {
        self.credentials_arn.as_deref()
    }
    /// <p>The description of the API.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Avoid validating models when creating a deployment. Supported only for WebSocket APIs.</p>
    pub fn disable_schema_validation(&self) -> bool {
        self.disable_schema_validation
    }
    /// <p>Specifies whether clients can invoke your API by using the default execute-api endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
    pub fn disable_execute_api_endpoint(&self) -> bool {
        self.disable_execute_api_endpoint
    }
    /// <p>The name of the API.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>This property is part of quick create. If not specified, the route created using quick create is kept. Otherwise, this value replaces the route key of the quick create route. Additional routes may still be added after the API is updated. Supported only for HTTP APIs.</p>
    pub fn route_key(&self) -> std::option::Option<&str> {
        self.route_key.as_deref()
    }
    /// <p>The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.</p>
    pub fn route_selection_expression(&self) -> std::option::Option<&str> {
        self.route_selection_expression.as_deref()
    }
    /// <p>This property is part of quick create. For HTTP integrations, specify a fully qualified URL. For Lambda integrations, specify a function ARN. The type of the integration will be HTTP_PROXY or AWS_PROXY, respectively. The value provided updates the integration URI and integration type. You can update a quick-created target, but you can't remove it from an API. Supported only for HTTP APIs.</p>
    pub fn target(&self) -> std::option::Option<&str> {
        self.target.as_deref()
    }
    /// <p>A version identifier for the API.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
}
impl std::fmt::Debug for UpdateApiInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateApiInput");
        formatter.field("api_id", &self.api_id);
        formatter.field(
            "api_key_selection_expression",
            &self.api_key_selection_expression,
        );
        formatter.field("cors_configuration", &self.cors_configuration);
        formatter.field("credentials_arn", &self.credentials_arn);
        formatter.field("description", &self.description);
        formatter.field("disable_schema_validation", &self.disable_schema_validation);
        formatter.field(
            "disable_execute_api_endpoint",
            &self.disable_execute_api_endpoint,
        );
        formatter.field("name", &self.name);
        formatter.field("route_key", &self.route_key);
        formatter.field(
            "route_selection_expression",
            &self.route_selection_expression,
        );
        formatter.field("target", &self.target);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The resource ARN for the tag.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The Tag keys to delete</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The resource ARN for the tag.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The Tag keys to delete</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

/// <p>Creates a new Tag resource to represent a tag.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The resource ARN for the tag.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl TagResourceInput {
    /// <p>The resource ARN for the tag.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResetAuthorizersCacheInput {
    /// <p>The API identifier.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The stage name. Stage names can contain only alphanumeric characters, hyphens, and underscores, or be $default. Maximum length is 128 characters.</p>
    pub stage_name: std::option::Option<std::string::String>,
}
impl ResetAuthorizersCacheInput {
    /// <p>The API identifier.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The stage name. Stage names can contain only alphanumeric characters, hyphens, and underscores, or be $default. Maximum length is 128 characters.</p>
    pub fn stage_name(&self) -> std::option::Option<&str> {
        self.stage_name.as_deref()
    }
}
impl std::fmt::Debug for ResetAuthorizersCacheInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResetAuthorizersCacheInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("stage_name", &self.stage_name);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReimportApiInput {
    /// <p>The API identifier.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>Specifies how to interpret the base path of the API during import. Valid values are ignore, prepend, and split. The default value is ignore. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-import-api-basePath.html">Set the OpenAPI basePath Property</a>. Supported only for HTTP APIs.</p>
    pub basepath: std::option::Option<std::string::String>,
    /// <p>The OpenAPI definition. Supported only for HTTP APIs.</p>
    pub body: std::option::Option<std::string::String>,
    /// <p>Specifies whether to rollback the API creation when a warning is encountered. By default, API creation continues if a warning is encountered.</p>
    pub fail_on_warnings: bool,
}
impl ReimportApiInput {
    /// <p>The API identifier.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>Specifies how to interpret the base path of the API during import. Valid values are ignore, prepend, and split. The default value is ignore. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-import-api-basePath.html">Set the OpenAPI basePath Property</a>. Supported only for HTTP APIs.</p>
    pub fn basepath(&self) -> std::option::Option<&str> {
        self.basepath.as_deref()
    }
    /// <p>The OpenAPI definition. Supported only for HTTP APIs.</p>
    pub fn body(&self) -> std::option::Option<&str> {
        self.body.as_deref()
    }
    /// <p>Specifies whether to rollback the API creation when a warning is encountered. By default, API creation continues if a warning is encountered.</p>
    pub fn fail_on_warnings(&self) -> bool {
        self.fail_on_warnings
    }
}
impl std::fmt::Debug for ReimportApiInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReimportApiInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("basepath", &self.basepath);
        formatter.field("body", &self.body);
        formatter.field("fail_on_warnings", &self.fail_on_warnings);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImportApiInput {
    /// <p>Specifies how to interpret the base path of the API during import. Valid values are ignore, prepend, and split. The default value is ignore. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-import-api-basePath.html">Set the OpenAPI basePath Property</a>. Supported only for HTTP APIs.</p>
    pub basepath: std::option::Option<std::string::String>,
    /// <p>The OpenAPI definition. Supported only for HTTP APIs.</p>
    pub body: std::option::Option<std::string::String>,
    /// <p>Specifies whether to rollback the API creation when a warning is encountered. By default, API creation continues if a warning is encountered.</p>
    pub fail_on_warnings: bool,
}
impl ImportApiInput {
    /// <p>Specifies how to interpret the base path of the API during import. Valid values are ignore, prepend, and split. The default value is ignore. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-import-api-basePath.html">Set the OpenAPI basePath Property</a>. Supported only for HTTP APIs.</p>
    pub fn basepath(&self) -> std::option::Option<&str> {
        self.basepath.as_deref()
    }
    /// <p>The OpenAPI definition. Supported only for HTTP APIs.</p>
    pub fn body(&self) -> std::option::Option<&str> {
        self.body.as_deref()
    }
    /// <p>Specifies whether to rollback the API creation when a warning is encountered. By default, API creation continues if a warning is encountered.</p>
    pub fn fail_on_warnings(&self) -> bool {
        self.fail_on_warnings
    }
}
impl std::fmt::Debug for ImportApiInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImportApiInput");
        formatter.field("basepath", &self.basepath);
        formatter.field("body", &self.body);
        formatter.field("fail_on_warnings", &self.fail_on_warnings);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetVpcLinksInput {
    /// <p>The maximum number of elements to be returned for this resource.</p>
    pub max_results: std::option::Option<std::string::String>,
    /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetVpcLinksInput {
    /// <p>The maximum number of elements to be returned for this resource.</p>
    pub fn max_results(&self) -> std::option::Option<&str> {
        self.max_results.as_deref()
    }
    /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetVpcLinksInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetVpcLinksInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetVpcLinkInput {
    /// <p>The ID of the VPC link.</p>
    pub vpc_link_id: std::option::Option<std::string::String>,
}
impl GetVpcLinkInput {
    /// <p>The ID of the VPC link.</p>
    pub fn vpc_link_id(&self) -> std::option::Option<&str> {
        self.vpc_link_id.as_deref()
    }
}
impl std::fmt::Debug for GetVpcLinkInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetVpcLinkInput");
        formatter.field("vpc_link_id", &self.vpc_link_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTagsInput {
    /// <p>The resource ARN for the tag.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl GetTagsInput {
    /// <p>The resource ARN for the tag.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for GetTagsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTagsInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetStagesInput {
    /// <p>The API identifier.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of elements to be returned for this resource.</p>
    pub max_results: std::option::Option<std::string::String>,
    /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetStagesInput {
    /// <p>The API identifier.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The maximum number of elements to be returned for this resource.</p>
    pub fn max_results(&self) -> std::option::Option<&str> {
        self.max_results.as_deref()
    }
    /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetStagesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetStagesInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetStageInput {
    /// <p>The API identifier.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The stage name. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.</p>
    pub stage_name: std::option::Option<std::string::String>,
}
impl GetStageInput {
    /// <p>The API identifier.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The stage name. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.</p>
    pub fn stage_name(&self) -> std::option::Option<&str> {
        self.stage_name.as_deref()
    }
}
impl std::fmt::Debug for GetStageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetStageInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("stage_name", &self.stage_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRoutesInput {
    /// <p>The API identifier.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of elements to be returned for this resource.</p>
    pub max_results: std::option::Option<std::string::String>,
    /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetRoutesInput {
    /// <p>The API identifier.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The maximum number of elements to be returned for this resource.</p>
    pub fn max_results(&self) -> std::option::Option<&str> {
        self.max_results.as_deref()
    }
    /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetRoutesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRoutesInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRouteResponsesInput {
    /// <p>The API identifier.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of elements to be returned for this resource.</p>
    pub max_results: std::option::Option<std::string::String>,
    /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The route ID.</p>
    pub route_id: std::option::Option<std::string::String>,
}
impl GetRouteResponsesInput {
    /// <p>The API identifier.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The maximum number of elements to be returned for this resource.</p>
    pub fn max_results(&self) -> std::option::Option<&str> {
        self.max_results.as_deref()
    }
    /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The route ID.</p>
    pub fn route_id(&self) -> std::option::Option<&str> {
        self.route_id.as_deref()
    }
}
impl std::fmt::Debug for GetRouteResponsesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRouteResponsesInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("route_id", &self.route_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRouteResponseInput {
    /// <p>The API identifier.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The route ID.</p>
    pub route_id: std::option::Option<std::string::String>,
    /// <p>The route response ID.</p>
    pub route_response_id: std::option::Option<std::string::String>,
}
impl GetRouteResponseInput {
    /// <p>The API identifier.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The route ID.</p>
    pub fn route_id(&self) -> std::option::Option<&str> {
        self.route_id.as_deref()
    }
    /// <p>The route response ID.</p>
    pub fn route_response_id(&self) -> std::option::Option<&str> {
        self.route_response_id.as_deref()
    }
}
impl std::fmt::Debug for GetRouteResponseInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRouteResponseInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("route_id", &self.route_id);
        formatter.field("route_response_id", &self.route_response_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRouteInput {
    /// <p>The API identifier.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The route ID.</p>
    pub route_id: std::option::Option<std::string::String>,
}
impl GetRouteInput {
    /// <p>The API identifier.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The route ID.</p>
    pub fn route_id(&self) -> std::option::Option<&str> {
        self.route_id.as_deref()
    }
}
impl std::fmt::Debug for GetRouteInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRouteInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("route_id", &self.route_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetModelTemplateInput {
    /// <p>The API identifier.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The model ID.</p>
    pub model_id: std::option::Option<std::string::String>,
}
impl GetModelTemplateInput {
    /// <p>The API identifier.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The model ID.</p>
    pub fn model_id(&self) -> std::option::Option<&str> {
        self.model_id.as_deref()
    }
}
impl std::fmt::Debug for GetModelTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetModelTemplateInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("model_id", &self.model_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetModelsInput {
    /// <p>The API identifier.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of elements to be returned for this resource.</p>
    pub max_results: std::option::Option<std::string::String>,
    /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetModelsInput {
    /// <p>The API identifier.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The maximum number of elements to be returned for this resource.</p>
    pub fn max_results(&self) -> std::option::Option<&str> {
        self.max_results.as_deref()
    }
    /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetModelsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetModelsInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetModelInput {
    /// <p>The API identifier.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The model ID.</p>
    pub model_id: std::option::Option<std::string::String>,
}
impl GetModelInput {
    /// <p>The API identifier.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The model ID.</p>
    pub fn model_id(&self) -> std::option::Option<&str> {
        self.model_id.as_deref()
    }
}
impl std::fmt::Debug for GetModelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetModelInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("model_id", &self.model_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetIntegrationsInput {
    /// <p>The API identifier.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of elements to be returned for this resource.</p>
    pub max_results: std::option::Option<std::string::String>,
    /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetIntegrationsInput {
    /// <p>The API identifier.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The maximum number of elements to be returned for this resource.</p>
    pub fn max_results(&self) -> std::option::Option<&str> {
        self.max_results.as_deref()
    }
    /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetIntegrationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetIntegrationsInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetIntegrationResponsesInput {
    /// <p>The API identifier.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The integration ID.</p>
    pub integration_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of elements to be returned for this resource.</p>
    pub max_results: std::option::Option<std::string::String>,
    /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetIntegrationResponsesInput {
    /// <p>The API identifier.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The integration ID.</p>
    pub fn integration_id(&self) -> std::option::Option<&str> {
        self.integration_id.as_deref()
    }
    /// <p>The maximum number of elements to be returned for this resource.</p>
    pub fn max_results(&self) -> std::option::Option<&str> {
        self.max_results.as_deref()
    }
    /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetIntegrationResponsesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetIntegrationResponsesInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("integration_id", &self.integration_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetIntegrationResponseInput {
    /// <p>The API identifier.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The integration ID.</p>
    pub integration_id: std::option::Option<std::string::String>,
    /// <p>The integration response ID.</p>
    pub integration_response_id: std::option::Option<std::string::String>,
}
impl GetIntegrationResponseInput {
    /// <p>The API identifier.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The integration ID.</p>
    pub fn integration_id(&self) -> std::option::Option<&str> {
        self.integration_id.as_deref()
    }
    /// <p>The integration response ID.</p>
    pub fn integration_response_id(&self) -> std::option::Option<&str> {
        self.integration_response_id.as_deref()
    }
}
impl std::fmt::Debug for GetIntegrationResponseInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetIntegrationResponseInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("integration_id", &self.integration_id);
        formatter.field("integration_response_id", &self.integration_response_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetIntegrationInput {
    /// <p>The API identifier.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The integration ID.</p>
    pub integration_id: std::option::Option<std::string::String>,
}
impl GetIntegrationInput {
    /// <p>The API identifier.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The integration ID.</p>
    pub fn integration_id(&self) -> std::option::Option<&str> {
        self.integration_id.as_deref()
    }
}
impl std::fmt::Debug for GetIntegrationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetIntegrationInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("integration_id", &self.integration_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDomainNamesInput {
    /// <p>The maximum number of elements to be returned for this resource.</p>
    pub max_results: std::option::Option<std::string::String>,
    /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetDomainNamesInput {
    /// <p>The maximum number of elements to be returned for this resource.</p>
    pub fn max_results(&self) -> std::option::Option<&str> {
        self.max_results.as_deref()
    }
    /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetDomainNamesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDomainNamesInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDomainNameInput {
    /// <p>The domain name.</p>
    pub domain_name: std::option::Option<std::string::String>,
}
impl GetDomainNameInput {
    /// <p>The domain name.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
}
impl std::fmt::Debug for GetDomainNameInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDomainNameInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDeploymentsInput {
    /// <p>The API identifier.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of elements to be returned for this resource.</p>
    pub max_results: std::option::Option<std::string::String>,
    /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetDeploymentsInput {
    /// <p>The API identifier.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The maximum number of elements to be returned for this resource.</p>
    pub fn max_results(&self) -> std::option::Option<&str> {
        self.max_results.as_deref()
    }
    /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetDeploymentsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDeploymentsInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDeploymentInput {
    /// <p>The API identifier.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The deployment ID.</p>
    pub deployment_id: std::option::Option<std::string::String>,
}
impl GetDeploymentInput {
    /// <p>The API identifier.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The deployment ID.</p>
    pub fn deployment_id(&self) -> std::option::Option<&str> {
        self.deployment_id.as_deref()
    }
}
impl std::fmt::Debug for GetDeploymentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDeploymentInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("deployment_id", &self.deployment_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAuthorizersInput {
    /// <p>The API identifier.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of elements to be returned for this resource.</p>
    pub max_results: std::option::Option<std::string::String>,
    /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetAuthorizersInput {
    /// <p>The API identifier.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The maximum number of elements to be returned for this resource.</p>
    pub fn max_results(&self) -> std::option::Option<&str> {
        self.max_results.as_deref()
    }
    /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetAuthorizersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAuthorizersInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAuthorizerInput {
    /// <p>The API identifier.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The authorizer identifier.</p>
    pub authorizer_id: std::option::Option<std::string::String>,
}
impl GetAuthorizerInput {
    /// <p>The API identifier.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The authorizer identifier.</p>
    pub fn authorizer_id(&self) -> std::option::Option<&str> {
        self.authorizer_id.as_deref()
    }
}
impl std::fmt::Debug for GetAuthorizerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAuthorizerInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("authorizer_id", &self.authorizer_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetApisInput {
    /// <p>The maximum number of elements to be returned for this resource.</p>
    pub max_results: std::option::Option<std::string::String>,
    /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetApisInput {
    /// <p>The maximum number of elements to be returned for this resource.</p>
    pub fn max_results(&self) -> std::option::Option<&str> {
        self.max_results.as_deref()
    }
    /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetApisInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetApisInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetApiMappingsInput {
    /// <p>The domain name.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The maximum number of elements to be returned for this resource.</p>
    pub max_results: std::option::Option<std::string::String>,
    /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetApiMappingsInput {
    /// <p>The domain name.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>The maximum number of elements to be returned for this resource.</p>
    pub fn max_results(&self) -> std::option::Option<&str> {
        self.max_results.as_deref()
    }
    /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetApiMappingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetApiMappingsInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetApiMappingInput {
    /// <p>The API mapping identifier.</p>
    pub api_mapping_id: std::option::Option<std::string::String>,
    /// <p>The domain name.</p>
    pub domain_name: std::option::Option<std::string::String>,
}
impl GetApiMappingInput {
    /// <p>The API mapping identifier.</p>
    pub fn api_mapping_id(&self) -> std::option::Option<&str> {
        self.api_mapping_id.as_deref()
    }
    /// <p>The domain name.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
}
impl std::fmt::Debug for GetApiMappingInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetApiMappingInput");
        formatter.field("api_mapping_id", &self.api_mapping_id);
        formatter.field("domain_name", &self.domain_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetApiInput {
    /// <p>The API identifier.</p>
    pub api_id: std::option::Option<std::string::String>,
}
impl GetApiInput {
    /// <p>The API identifier.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
}
impl std::fmt::Debug for GetApiInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetApiInput");
        formatter.field("api_id", &self.api_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExportApiInput {
    /// <p>The API identifier.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The version of the API Gateway export algorithm. API Gateway uses the latest version by default. Currently, the only supported version is 1.0.</p>
    pub export_version: std::option::Option<std::string::String>,
    /// <p>Specifies whether to include <a href="https://docs.aws.amazon.com//apigateway/latest/developerguide/api-gateway-swagger-extensions.html">API Gateway extensions</a> in the exported API definition. API Gateway extensions are included by default.</p>
    pub include_extensions: bool,
    /// <p>The output type of the exported definition file. Valid values are JSON and YAML.</p>
    pub output_type: std::option::Option<std::string::String>,
    /// <p>The version of the API specification to use. OAS30, for OpenAPI 3.0, is the only supported value.</p>
    pub specification: std::option::Option<std::string::String>,
    /// <p>The name of the API stage to export. If you don't specify this property, a representation of the latest API configuration is exported.</p>
    pub stage_name: std::option::Option<std::string::String>,
}
impl ExportApiInput {
    /// <p>The API identifier.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The version of the API Gateway export algorithm. API Gateway uses the latest version by default. Currently, the only supported version is 1.0.</p>
    pub fn export_version(&self) -> std::option::Option<&str> {
        self.export_version.as_deref()
    }
    /// <p>Specifies whether to include <a href="https://docs.aws.amazon.com//apigateway/latest/developerguide/api-gateway-swagger-extensions.html">API Gateway extensions</a> in the exported API definition. API Gateway extensions are included by default.</p>
    pub fn include_extensions(&self) -> bool {
        self.include_extensions
    }
    /// <p>The output type of the exported definition file. Valid values are JSON and YAML.</p>
    pub fn output_type(&self) -> std::option::Option<&str> {
        self.output_type.as_deref()
    }
    /// <p>The version of the API specification to use. OAS30, for OpenAPI 3.0, is the only supported value.</p>
    pub fn specification(&self) -> std::option::Option<&str> {
        self.specification.as_deref()
    }
    /// <p>The name of the API stage to export. If you don't specify this property, a representation of the latest API configuration is exported.</p>
    pub fn stage_name(&self) -> std::option::Option<&str> {
        self.stage_name.as_deref()
    }
}
impl std::fmt::Debug for ExportApiInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExportApiInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("export_version", &self.export_version);
        formatter.field("include_extensions", &self.include_extensions);
        formatter.field("output_type", &self.output_type);
        formatter.field("specification", &self.specification);
        formatter.field("stage_name", &self.stage_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteVpcLinkInput {
    /// <p>The ID of the VPC link.</p>
    pub vpc_link_id: std::option::Option<std::string::String>,
}
impl DeleteVpcLinkInput {
    /// <p>The ID of the VPC link.</p>
    pub fn vpc_link_id(&self) -> std::option::Option<&str> {
        self.vpc_link_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteVpcLinkInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteVpcLinkInput");
        formatter.field("vpc_link_id", &self.vpc_link_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteStageInput {
    /// <p>The API identifier.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The stage name. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.</p>
    pub stage_name: std::option::Option<std::string::String>,
}
impl DeleteStageInput {
    /// <p>The API identifier.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The stage name. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.</p>
    pub fn stage_name(&self) -> std::option::Option<&str> {
        self.stage_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteStageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteStageInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("stage_name", &self.stage_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRouteSettingsInput {
    /// <p>The API identifier.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The route key.</p>
    pub route_key: std::option::Option<std::string::String>,
    /// <p>The stage name. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.</p>
    pub stage_name: std::option::Option<std::string::String>,
}
impl DeleteRouteSettingsInput {
    /// <p>The API identifier.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The route key.</p>
    pub fn route_key(&self) -> std::option::Option<&str> {
        self.route_key.as_deref()
    }
    /// <p>The stage name. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.</p>
    pub fn stage_name(&self) -> std::option::Option<&str> {
        self.stage_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteRouteSettingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRouteSettingsInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("route_key", &self.route_key);
        formatter.field("stage_name", &self.stage_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRouteResponseInput {
    /// <p>The API identifier.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The route ID.</p>
    pub route_id: std::option::Option<std::string::String>,
    /// <p>The route response ID.</p>
    pub route_response_id: std::option::Option<std::string::String>,
}
impl DeleteRouteResponseInput {
    /// <p>The API identifier.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The route ID.</p>
    pub fn route_id(&self) -> std::option::Option<&str> {
        self.route_id.as_deref()
    }
    /// <p>The route response ID.</p>
    pub fn route_response_id(&self) -> std::option::Option<&str> {
        self.route_response_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteRouteResponseInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRouteResponseInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("route_id", &self.route_id);
        formatter.field("route_response_id", &self.route_response_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRouteRequestParameterInput {
    /// <p>The API identifier.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The route request parameter key.</p>
    pub request_parameter_key: std::option::Option<std::string::String>,
    /// <p>The route ID.</p>
    pub route_id: std::option::Option<std::string::String>,
}
impl DeleteRouteRequestParameterInput {
    /// <p>The API identifier.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The route request parameter key.</p>
    pub fn request_parameter_key(&self) -> std::option::Option<&str> {
        self.request_parameter_key.as_deref()
    }
    /// <p>The route ID.</p>
    pub fn route_id(&self) -> std::option::Option<&str> {
        self.route_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteRouteRequestParameterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRouteRequestParameterInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("request_parameter_key", &self.request_parameter_key);
        formatter.field("route_id", &self.route_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRouteInput {
    /// <p>The API identifier.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The route ID.</p>
    pub route_id: std::option::Option<std::string::String>,
}
impl DeleteRouteInput {
    /// <p>The API identifier.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The route ID.</p>
    pub fn route_id(&self) -> std::option::Option<&str> {
        self.route_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteRouteInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRouteInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("route_id", &self.route_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteModelInput {
    /// <p>The API identifier.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The model ID.</p>
    pub model_id: std::option::Option<std::string::String>,
}
impl DeleteModelInput {
    /// <p>The API identifier.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The model ID.</p>
    pub fn model_id(&self) -> std::option::Option<&str> {
        self.model_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteModelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteModelInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("model_id", &self.model_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteIntegrationResponseInput {
    /// <p>The API identifier.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The integration ID.</p>
    pub integration_id: std::option::Option<std::string::String>,
    /// <p>The integration response ID.</p>
    pub integration_response_id: std::option::Option<std::string::String>,
}
impl DeleteIntegrationResponseInput {
    /// <p>The API identifier.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The integration ID.</p>
    pub fn integration_id(&self) -> std::option::Option<&str> {
        self.integration_id.as_deref()
    }
    /// <p>The integration response ID.</p>
    pub fn integration_response_id(&self) -> std::option::Option<&str> {
        self.integration_response_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteIntegrationResponseInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteIntegrationResponseInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("integration_id", &self.integration_id);
        formatter.field("integration_response_id", &self.integration_response_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteIntegrationInput {
    /// <p>The API identifier.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The integration ID.</p>
    pub integration_id: std::option::Option<std::string::String>,
}
impl DeleteIntegrationInput {
    /// <p>The API identifier.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The integration ID.</p>
    pub fn integration_id(&self) -> std::option::Option<&str> {
        self.integration_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteIntegrationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteIntegrationInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("integration_id", &self.integration_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDomainNameInput {
    /// <p>The domain name.</p>
    pub domain_name: std::option::Option<std::string::String>,
}
impl DeleteDomainNameInput {
    /// <p>The domain name.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteDomainNameInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDomainNameInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDeploymentInput {
    /// <p>The API identifier.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The deployment ID.</p>
    pub deployment_id: std::option::Option<std::string::String>,
}
impl DeleteDeploymentInput {
    /// <p>The API identifier.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The deployment ID.</p>
    pub fn deployment_id(&self) -> std::option::Option<&str> {
        self.deployment_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteDeploymentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDeploymentInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("deployment_id", &self.deployment_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteCorsConfigurationInput {
    /// <p>The API identifier.</p>
    pub api_id: std::option::Option<std::string::String>,
}
impl DeleteCorsConfigurationInput {
    /// <p>The API identifier.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteCorsConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteCorsConfigurationInput");
        formatter.field("api_id", &self.api_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAuthorizerInput {
    /// <p>The API identifier.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The authorizer identifier.</p>
    pub authorizer_id: std::option::Option<std::string::String>,
}
impl DeleteAuthorizerInput {
    /// <p>The API identifier.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The authorizer identifier.</p>
    pub fn authorizer_id(&self) -> std::option::Option<&str> {
        self.authorizer_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteAuthorizerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAuthorizerInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("authorizer_id", &self.authorizer_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteApiMappingInput {
    /// <p>The API mapping identifier.</p>
    pub api_mapping_id: std::option::Option<std::string::String>,
    /// <p>The domain name.</p>
    pub domain_name: std::option::Option<std::string::String>,
}
impl DeleteApiMappingInput {
    /// <p>The API mapping identifier.</p>
    pub fn api_mapping_id(&self) -> std::option::Option<&str> {
        self.api_mapping_id.as_deref()
    }
    /// <p>The domain name.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteApiMappingInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteApiMappingInput");
        formatter.field("api_mapping_id", &self.api_mapping_id);
        formatter.field("domain_name", &self.domain_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteApiInput {
    /// <p>The API identifier.</p>
    pub api_id: std::option::Option<std::string::String>,
}
impl DeleteApiInput {
    /// <p>The API identifier.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteApiInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteApiInput");
        formatter.field("api_id", &self.api_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAccessLogSettingsInput {
    /// <p>The API identifier.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The stage name. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.</p>
    pub stage_name: std::option::Option<std::string::String>,
}
impl DeleteAccessLogSettingsInput {
    /// <p>The API identifier.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The stage name. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.</p>
    pub fn stage_name(&self) -> std::option::Option<&str> {
        self.stage_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteAccessLogSettingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAccessLogSettingsInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("stage_name", &self.stage_name);
        formatter.finish()
    }
}

/// <p>Creates a VPC link</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateVpcLinkInput {
    /// <p>The name of the VPC link.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A list of security group IDs for the VPC link.</p>
    pub security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of subnet IDs to include in the VPC link.</p>
    pub subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of tags.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateVpcLinkInput {
    /// <p>The name of the VPC link.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A list of security group IDs for the VPC link.</p>
    pub fn security_group_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.security_group_ids.as_deref()
    }
    /// <p>A list of subnet IDs to include in the VPC link.</p>
    pub fn subnet_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.subnet_ids.as_deref()
    }
    /// <p>A list of tags.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateVpcLinkInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateVpcLinkInput");
        formatter.field("name", &self.name);
        formatter.field("security_group_ids", &self.security_group_ids);
        formatter.field("subnet_ids", &self.subnet_ids);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// <p>Creates a new Stage resource to represent a stage.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateStageInput {
    /// <p>Settings for logging access in this stage.</p>
    pub access_log_settings: std::option::Option<crate::model::AccessLogSettings>,
    /// <p>The API identifier.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>Specifies whether updates to an API automatically trigger a new deployment. The default value is false.</p>
    pub auto_deploy: bool,
    /// <p>The identifier of a client certificate for a Stage. Supported only for WebSocket APIs.</p>
    pub client_certificate_id: std::option::Option<std::string::String>,
    /// <p>The default route settings for the stage.</p>
    pub default_route_settings: std::option::Option<crate::model::RouteSettings>,
    /// <p>The deployment identifier of the API stage.</p>
    pub deployment_id: std::option::Option<std::string::String>,
    /// <p>The description for the API stage.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Route settings for the stage, by routeKey.</p>
    pub route_settings: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::RouteSettings>,
    >,
    /// <p>The name of the stage.</p>
    pub stage_name: std::option::Option<std::string::String>,
    /// <p>A map that defines the stage variables for a Stage. Variable names can have alphanumeric and underscore characters, and the values must match [A-Za-z0-9-._~:/?#&amp;=,]+.</p>
    pub stage_variables:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateStageInput {
    /// <p>Settings for logging access in this stage.</p>
    pub fn access_log_settings(&self) -> std::option::Option<&crate::model::AccessLogSettings> {
        self.access_log_settings.as_ref()
    }
    /// <p>The API identifier.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>Specifies whether updates to an API automatically trigger a new deployment. The default value is false.</p>
    pub fn auto_deploy(&self) -> bool {
        self.auto_deploy
    }
    /// <p>The identifier of a client certificate for a Stage. Supported only for WebSocket APIs.</p>
    pub fn client_certificate_id(&self) -> std::option::Option<&str> {
        self.client_certificate_id.as_deref()
    }
    /// <p>The default route settings for the stage.</p>
    pub fn default_route_settings(&self) -> std::option::Option<&crate::model::RouteSettings> {
        self.default_route_settings.as_ref()
    }
    /// <p>The deployment identifier of the API stage.</p>
    pub fn deployment_id(&self) -> std::option::Option<&str> {
        self.deployment_id.as_deref()
    }
    /// <p>The description for the API stage.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Route settings for the stage, by routeKey.</p>
    pub fn route_settings(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::RouteSettings>,
    > {
        self.route_settings.as_ref()
    }
    /// <p>The name of the stage.</p>
    pub fn stage_name(&self) -> std::option::Option<&str> {
        self.stage_name.as_deref()
    }
    /// <p>A map that defines the stage variables for a Stage. Variable names can have alphanumeric and underscore characters, and the values must match [A-Za-z0-9-._~:/?#&amp;=,]+.</p>
    pub fn stage_variables(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.stage_variables.as_ref()
    }
    /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateStageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateStageInput");
        formatter.field("access_log_settings", &self.access_log_settings);
        formatter.field("api_id", &self.api_id);
        formatter.field("auto_deploy", &self.auto_deploy);
        formatter.field("client_certificate_id", &self.client_certificate_id);
        formatter.field("default_route_settings", &self.default_route_settings);
        formatter.field("deployment_id", &self.deployment_id);
        formatter.field("description", &self.description);
        formatter.field("route_settings", &self.route_settings);
        formatter.field("stage_name", &self.stage_name);
        formatter.field("stage_variables", &self.stage_variables);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// <p>Creates a new RouteResponse resource to represent a route response.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRouteResponseInput {
    /// <p>The API identifier.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The model selection expression for the route response. Supported only for WebSocket APIs.</p>
    pub model_selection_expression: std::option::Option<std::string::String>,
    /// <p>The response models for the route response.</p>
    pub response_models:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The route response parameters.</p>
    pub response_parameters: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::ParameterConstraints>,
    >,
    /// <p>The route ID.</p>
    pub route_id: std::option::Option<std::string::String>,
    /// <p>The route response key.</p>
    pub route_response_key: std::option::Option<std::string::String>,
}
impl CreateRouteResponseInput {
    /// <p>The API identifier.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The model selection expression for the route response. Supported only for WebSocket APIs.</p>
    pub fn model_selection_expression(&self) -> std::option::Option<&str> {
        self.model_selection_expression.as_deref()
    }
    /// <p>The response models for the route response.</p>
    pub fn response_models(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.response_models.as_ref()
    }
    /// <p>The route response parameters.</p>
    pub fn response_parameters(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::ParameterConstraints>,
    > {
        self.response_parameters.as_ref()
    }
    /// <p>The route ID.</p>
    pub fn route_id(&self) -> std::option::Option<&str> {
        self.route_id.as_deref()
    }
    /// <p>The route response key.</p>
    pub fn route_response_key(&self) -> std::option::Option<&str> {
        self.route_response_key.as_deref()
    }
}
impl std::fmt::Debug for CreateRouteResponseInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRouteResponseInput");
        formatter.field("api_id", &self.api_id);
        formatter.field(
            "model_selection_expression",
            &self.model_selection_expression,
        );
        formatter.field("response_models", &self.response_models);
        formatter.field("response_parameters", &self.response_parameters);
        formatter.field("route_id", &self.route_id);
        formatter.field("route_response_key", &self.route_response_key);
        formatter.finish()
    }
}

/// <p>Creates a new Route resource to represent a route.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRouteInput {
    /// <p>The API identifier.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>Specifies whether an API key is required for the route. Supported only for WebSocket APIs.</p>
    pub api_key_required: bool,
    /// <p>The authorization scopes supported by this route.</p>
    pub authorization_scopes: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The authorization type for the route. For WebSocket APIs, valid values are NONE for open access, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer For HTTP APIs, valid values are NONE for open access, JWT for using JSON Web Tokens, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer.</p>
    pub authorization_type: std::option::Option<crate::model::AuthorizationType>,
    /// <p>The identifier of the Authorizer resource to be associated with this route. The authorizer identifier is generated by API Gateway when you created the authorizer.</p>
    pub authorizer_id: std::option::Option<std::string::String>,
    /// <p>The model selection expression for the route. Supported only for WebSocket APIs.</p>
    pub model_selection_expression: std::option::Option<std::string::String>,
    /// <p>The operation name for the route.</p>
    pub operation_name: std::option::Option<std::string::String>,
    /// <p>The request models for the route. Supported only for WebSocket APIs.</p>
    pub request_models:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The request parameters for the route. Supported only for WebSocket APIs.</p>
    pub request_parameters: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::ParameterConstraints>,
    >,
    /// <p>The route key for the route.</p>
    pub route_key: std::option::Option<std::string::String>,
    /// <p>The route response selection expression for the route. Supported only for WebSocket APIs.</p>
    pub route_response_selection_expression: std::option::Option<std::string::String>,
    /// <p>The target for the route.</p>
    pub target: std::option::Option<std::string::String>,
}
impl CreateRouteInput {
    /// <p>The API identifier.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>Specifies whether an API key is required for the route. Supported only for WebSocket APIs.</p>
    pub fn api_key_required(&self) -> bool {
        self.api_key_required
    }
    /// <p>The authorization scopes supported by this route.</p>
    pub fn authorization_scopes(&self) -> std::option::Option<&[std::string::String]> {
        self.authorization_scopes.as_deref()
    }
    /// <p>The authorization type for the route. For WebSocket APIs, valid values are NONE for open access, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer For HTTP APIs, valid values are NONE for open access, JWT for using JSON Web Tokens, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer.</p>
    pub fn authorization_type(&self) -> std::option::Option<&crate::model::AuthorizationType> {
        self.authorization_type.as_ref()
    }
    /// <p>The identifier of the Authorizer resource to be associated with this route. The authorizer identifier is generated by API Gateway when you created the authorizer.</p>
    pub fn authorizer_id(&self) -> std::option::Option<&str> {
        self.authorizer_id.as_deref()
    }
    /// <p>The model selection expression for the route. Supported only for WebSocket APIs.</p>
    pub fn model_selection_expression(&self) -> std::option::Option<&str> {
        self.model_selection_expression.as_deref()
    }
    /// <p>The operation name for the route.</p>
    pub fn operation_name(&self) -> std::option::Option<&str> {
        self.operation_name.as_deref()
    }
    /// <p>The request models for the route. Supported only for WebSocket APIs.</p>
    pub fn request_models(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.request_models.as_ref()
    }
    /// <p>The request parameters for the route. Supported only for WebSocket APIs.</p>
    pub fn request_parameters(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::ParameterConstraints>,
    > {
        self.request_parameters.as_ref()
    }
    /// <p>The route key for the route.</p>
    pub fn route_key(&self) -> std::option::Option<&str> {
        self.route_key.as_deref()
    }
    /// <p>The route response selection expression for the route. Supported only for WebSocket APIs.</p>
    pub fn route_response_selection_expression(&self) -> std::option::Option<&str> {
        self.route_response_selection_expression.as_deref()
    }
    /// <p>The target for the route.</p>
    pub fn target(&self) -> std::option::Option<&str> {
        self.target.as_deref()
    }
}
impl std::fmt::Debug for CreateRouteInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRouteInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("api_key_required", &self.api_key_required);
        formatter.field("authorization_scopes", &self.authorization_scopes);
        formatter.field("authorization_type", &self.authorization_type);
        formatter.field("authorizer_id", &self.authorizer_id);
        formatter.field(
            "model_selection_expression",
            &self.model_selection_expression,
        );
        formatter.field("operation_name", &self.operation_name);
        formatter.field("request_models", &self.request_models);
        formatter.field("request_parameters", &self.request_parameters);
        formatter.field("route_key", &self.route_key);
        formatter.field(
            "route_response_selection_expression",
            &self.route_response_selection_expression,
        );
        formatter.field("target", &self.target);
        formatter.finish()
    }
}

/// <p>Creates a new Model.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateModelInput {
    /// <p>The API identifier.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The content-type for the model, for example, "application/json".</p>
    pub content_type: std::option::Option<std::string::String>,
    /// <p>The description of the model.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The name of the model. Must be alphanumeric.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The schema for the model. For application/json models, this should be JSON schema draft 4 model.</p>
    pub schema: std::option::Option<std::string::String>,
}
impl CreateModelInput {
    /// <p>The API identifier.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The content-type for the model, for example, "application/json".</p>
    pub fn content_type(&self) -> std::option::Option<&str> {
        self.content_type.as_deref()
    }
    /// <p>The description of the model.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The name of the model. Must be alphanumeric.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The schema for the model. For application/json models, this should be JSON schema draft 4 model.</p>
    pub fn schema(&self) -> std::option::Option<&str> {
        self.schema.as_deref()
    }
}
impl std::fmt::Debug for CreateModelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateModelInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("content_type", &self.content_type);
        formatter.field("description", &self.description);
        formatter.field("name", &self.name);
        formatter.field("schema", &self.schema);
        formatter.finish()
    }
}

/// <p>Creates a new IntegrationResponse resource to represent an integration response.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateIntegrationResponseInput {
    /// <p>The API identifier.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p>
    /// <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p>
    /// <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p>
    /// <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
    pub content_handling_strategy: std::option::Option<crate::model::ContentHandlingStrategy>,
    /// <p>The integration ID.</p>
    pub integration_id: std::option::Option<std::string::String>,
    /// <p>The integration response key.</p>
    pub integration_response_key: std::option::Option<std::string::String>,
    /// <p>A key-value map specifying response parameters that are passed to the method response from the backend. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of method.response.header.{name}, where {name} is a valid and unique header name. The mapped non-static value must match the pattern of integration.response.header.{name} or integration.response.body.{JSON-expression}, where {name} is a valid and unique response header name and {JSON-expression} is a valid JSON expression without the $ prefix.</p>
    pub response_parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The collection of response templates for the integration response as a string-to-string map of key-value pairs. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.</p>
    pub response_templates:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The template selection expression for the integration response. Supported only for WebSocket APIs.</p>
    pub template_selection_expression: std::option::Option<std::string::String>,
}
impl CreateIntegrationResponseInput {
    /// <p>The API identifier.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p>
    /// <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p>
    /// <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p>
    /// <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
    pub fn content_handling_strategy(
        &self,
    ) -> std::option::Option<&crate::model::ContentHandlingStrategy> {
        self.content_handling_strategy.as_ref()
    }
    /// <p>The integration ID.</p>
    pub fn integration_id(&self) -> std::option::Option<&str> {
        self.integration_id.as_deref()
    }
    /// <p>The integration response key.</p>
    pub fn integration_response_key(&self) -> std::option::Option<&str> {
        self.integration_response_key.as_deref()
    }
    /// <p>A key-value map specifying response parameters that are passed to the method response from the backend. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of method.response.header.{name}, where {name} is a valid and unique header name. The mapped non-static value must match the pattern of integration.response.header.{name} or integration.response.body.{JSON-expression}, where {name} is a valid and unique response header name and {JSON-expression} is a valid JSON expression without the $ prefix.</p>
    pub fn response_parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.response_parameters.as_ref()
    }
    /// <p>The collection of response templates for the integration response as a string-to-string map of key-value pairs. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.</p>
    pub fn response_templates(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.response_templates.as_ref()
    }
    /// <p>The template selection expression for the integration response. Supported only for WebSocket APIs.</p>
    pub fn template_selection_expression(&self) -> std::option::Option<&str> {
        self.template_selection_expression.as_deref()
    }
}
impl std::fmt::Debug for CreateIntegrationResponseInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateIntegrationResponseInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("content_handling_strategy", &self.content_handling_strategy);
        formatter.field("integration_id", &self.integration_id);
        formatter.field("integration_response_key", &self.integration_response_key);
        formatter.field("response_parameters", &self.response_parameters);
        formatter.field("response_templates", &self.response_templates);
        formatter.field(
            "template_selection_expression",
            &self.template_selection_expression,
        );
        formatter.finish()
    }
}

/// <p>Creates a new Integration resource to represent an integration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateIntegrationInput {
    /// <p>The API identifier.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The ID of the VPC link for a private integration. Supported only for HTTP APIs.</p>
    pub connection_id: std::option::Option<std::string::String>,
    /// <p>The type of the network connection to the integration endpoint. Specify INTERNET for connections through the public routable internet or VPC_LINK for private connections between API Gateway and resources in a VPC. The default value is INTERNET.</p>
    pub connection_type: std::option::Option<crate::model::ConnectionType>,
    /// <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p>
    /// <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p>
    /// <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p>
    /// <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
    pub content_handling_strategy: std::option::Option<crate::model::ContentHandlingStrategy>,
    /// <p>Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, specify null.</p>
    pub credentials_arn: std::option::Option<std::string::String>,
    /// <p>The description of the integration.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Specifies the integration's HTTP method type.</p>
    pub integration_method: std::option::Option<std::string::String>,
    /// <p>Supported only for HTTP API AWS_PROXY integrations. Specifies the AWS service action to invoke. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html">Integration subtype reference</a>.</p>
    pub integration_subtype: std::option::Option<std::string::String>,
    /// <p>The integration type of an integration. One of the following:</p>
    /// <p>AWS: for integrating the route or method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration. Supported only for WebSocket APIs.</p>
    /// <p>AWS_PROXY: for integrating the route or method request with a Lambda function or other AWS service action. This integration is also referred to as a Lambda proxy integration.</p>
    /// <p>HTTP: for integrating the route or method request with an HTTP endpoint. This integration is also referred to as the HTTP custom integration. Supported only for WebSocket APIs.</p>
    /// <p>HTTP_PROXY: for integrating the route or method request with an HTTP endpoint, with the client request passed through as-is. This is also referred to as HTTP proxy integration. For HTTP API private integrations, use an HTTP_PROXY integration.</p>
    /// <p>MOCK: for integrating the route or method request with API Gateway as a "loopback" endpoint without invoking any backend. Supported only for WebSocket APIs.</p>
    pub integration_type: std::option::Option<crate::model::IntegrationType>,
    /// <p>For a Lambda integration, specify the URI of a Lambda function.</p>
    /// <p>For an HTTP integration, specify a fully-qualified URL.</p>
    /// <p>For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service. If you specify the ARN of an AWS Cloud Map service, API Gateway uses DiscoverInstances to identify resources. You can use query parameters to target specific resources. To learn more, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_DiscoverInstances.html">DiscoverInstances</a>. For private integrations, all resources must be owned by the same AWS account.</p>
    pub integration_uri: std::option::Option<std::string::String>,
    /// <p>Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER. Supported only for WebSocket APIs.</p>
    /// <p>WHEN_NO_MATCH passes the request body for unmapped content types through to the integration backend without transformation.</p>
    /// <p>NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type response.</p>
    /// <p>WHEN_NO_TEMPLATES allows pass-through when the integration has no content types mapped to templates. However, if there is at least one content type defined, unmapped content types will be rejected with the same HTTP 415 Unsupported Media Type response.</p>
    pub passthrough_behavior: std::option::Option<crate::model::PassthroughBehavior>,
    /// <p>Specifies the format of the payload sent to an integration. Required for HTTP APIs.</p>
    pub payload_format_version: std::option::Option<std::string::String>,
    /// <p>For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the backend. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the backend. The method request parameter value must match the pattern of method.request.<replaceable>
    /// {location}
    /// </replaceable>.<replaceable>
    /// {name}
    /// </replaceable> , where <replaceable>
    /// {location}
    /// </replaceable> is querystring, path, or header; and <replaceable>
    /// {name}
    /// </replaceable> must be a valid and unique method request parameter name.</p>
    /// <p>For HTTP API integrations with a specified integrationSubtype, request parameters are a key-value map specifying parameters that are passed to AWS_PROXY integrations. You can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services.html">Working with AWS service integrations for HTTP APIs</a>.</p>
    /// <p>For HTTP API integrations without a specified integrationSubtype request parameters are a key-value map specifying how to transform HTTP requests before sending them to the backend. The key should follow the pattern &lt;action&gt;:&lt;header|querystring|path&gt;.&lt;location&gt; where action can be append, overwrite or remove. For values, you can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
    pub request_parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value. Supported only for WebSocket APIs.</p>
    pub request_templates:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Supported only for HTTP APIs. You use response parameters to transform the HTTP response from a backend integration before returning the response to clients. Specify a key-value map from a selection key to response parameters. The selection key must be a valid HTTP status code within the range of 200-599. Response parameters are a key-value map. The key must match pattern &lt;action&gt;:&lt;header&gt;.&lt;location&gt; or overwrite.statuscode. The action can be append, overwrite or remove. The value can be a static value, or map to response data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
    pub response_parameters: std::option::Option<
        std::collections::HashMap<
            std::string::String,
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    >,
    /// <p>The template selection expression for the integration.</p>
    pub template_selection_expression: std::option::Option<std::string::String>,
    /// <p>Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs. The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.</p>
    pub timeout_in_millis: i32,
    /// <p>The TLS configuration for a private integration. If you specify a TLS configuration, private integration traffic uses the HTTPS protocol. Supported only for HTTP APIs.</p>
    pub tls_config: std::option::Option<crate::model::TlsConfigInput>,
}
impl CreateIntegrationInput {
    /// <p>The API identifier.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The ID of the VPC link for a private integration. Supported only for HTTP APIs.</p>
    pub fn connection_id(&self) -> std::option::Option<&str> {
        self.connection_id.as_deref()
    }
    /// <p>The type of the network connection to the integration endpoint. Specify INTERNET for connections through the public routable internet or VPC_LINK for private connections between API Gateway and resources in a VPC. The default value is INTERNET.</p>
    pub fn connection_type(&self) -> std::option::Option<&crate::model::ConnectionType> {
        self.connection_type.as_ref()
    }
    /// <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p>
    /// <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p>
    /// <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p>
    /// <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
    pub fn content_handling_strategy(
        &self,
    ) -> std::option::Option<&crate::model::ContentHandlingStrategy> {
        self.content_handling_strategy.as_ref()
    }
    /// <p>Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, specify null.</p>
    pub fn credentials_arn(&self) -> std::option::Option<&str> {
        self.credentials_arn.as_deref()
    }
    /// <p>The description of the integration.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Specifies the integration's HTTP method type.</p>
    pub fn integration_method(&self) -> std::option::Option<&str> {
        self.integration_method.as_deref()
    }
    /// <p>Supported only for HTTP API AWS_PROXY integrations. Specifies the AWS service action to invoke. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html">Integration subtype reference</a>.</p>
    pub fn integration_subtype(&self) -> std::option::Option<&str> {
        self.integration_subtype.as_deref()
    }
    /// <p>The integration type of an integration. One of the following:</p>
    /// <p>AWS: for integrating the route or method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration. Supported only for WebSocket APIs.</p>
    /// <p>AWS_PROXY: for integrating the route or method request with a Lambda function or other AWS service action. This integration is also referred to as a Lambda proxy integration.</p>
    /// <p>HTTP: for integrating the route or method request with an HTTP endpoint. This integration is also referred to as the HTTP custom integration. Supported only for WebSocket APIs.</p>
    /// <p>HTTP_PROXY: for integrating the route or method request with an HTTP endpoint, with the client request passed through as-is. This is also referred to as HTTP proxy integration. For HTTP API private integrations, use an HTTP_PROXY integration.</p>
    /// <p>MOCK: for integrating the route or method request with API Gateway as a "loopback" endpoint without invoking any backend. Supported only for WebSocket APIs.</p>
    pub fn integration_type(&self) -> std::option::Option<&crate::model::IntegrationType> {
        self.integration_type.as_ref()
    }
    /// <p>For a Lambda integration, specify the URI of a Lambda function.</p>
    /// <p>For an HTTP integration, specify a fully-qualified URL.</p>
    /// <p>For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service. If you specify the ARN of an AWS Cloud Map service, API Gateway uses DiscoverInstances to identify resources. You can use query parameters to target specific resources. To learn more, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_DiscoverInstances.html">DiscoverInstances</a>. For private integrations, all resources must be owned by the same AWS account.</p>
    pub fn integration_uri(&self) -> std::option::Option<&str> {
        self.integration_uri.as_deref()
    }
    /// <p>Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER. Supported only for WebSocket APIs.</p>
    /// <p>WHEN_NO_MATCH passes the request body for unmapped content types through to the integration backend without transformation.</p>
    /// <p>NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type response.</p>
    /// <p>WHEN_NO_TEMPLATES allows pass-through when the integration has no content types mapped to templates. However, if there is at least one content type defined, unmapped content types will be rejected with the same HTTP 415 Unsupported Media Type response.</p>
    pub fn passthrough_behavior(&self) -> std::option::Option<&crate::model::PassthroughBehavior> {
        self.passthrough_behavior.as_ref()
    }
    /// <p>Specifies the format of the payload sent to an integration. Required for HTTP APIs.</p>
    pub fn payload_format_version(&self) -> std::option::Option<&str> {
        self.payload_format_version.as_deref()
    }
    /// <p>For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the backend. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the backend. The method request parameter value must match the pattern of method.request.<replaceable>
    /// {location}
    /// </replaceable>.<replaceable>
    /// {name}
    /// </replaceable> , where <replaceable>
    /// {location}
    /// </replaceable> is querystring, path, or header; and <replaceable>
    /// {name}
    /// </replaceable> must be a valid and unique method request parameter name.</p>
    /// <p>For HTTP API integrations with a specified integrationSubtype, request parameters are a key-value map specifying parameters that are passed to AWS_PROXY integrations. You can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services.html">Working with AWS service integrations for HTTP APIs</a>.</p>
    /// <p>For HTTP API integrations without a specified integrationSubtype request parameters are a key-value map specifying how to transform HTTP requests before sending them to the backend. The key should follow the pattern &lt;action&gt;:&lt;header|querystring|path&gt;.&lt;location&gt; where action can be append, overwrite or remove. For values, you can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
    pub fn request_parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.request_parameters.as_ref()
    }
    /// <p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value. Supported only for WebSocket APIs.</p>
    pub fn request_templates(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.request_templates.as_ref()
    }
    /// <p>Supported only for HTTP APIs. You use response parameters to transform the HTTP response from a backend integration before returning the response to clients. Specify a key-value map from a selection key to response parameters. The selection key must be a valid HTTP status code within the range of 200-599. Response parameters are a key-value map. The key must match pattern &lt;action&gt;:&lt;header&gt;.&lt;location&gt; or overwrite.statuscode. The action can be append, overwrite or remove. The value can be a static value, or map to response data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
    pub fn response_parameters(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<
            std::string::String,
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    > {
        self.response_parameters.as_ref()
    }
    /// <p>The template selection expression for the integration.</p>
    pub fn template_selection_expression(&self) -> std::option::Option<&str> {
        self.template_selection_expression.as_deref()
    }
    /// <p>Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs. The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.</p>
    pub fn timeout_in_millis(&self) -> i32 {
        self.timeout_in_millis
    }
    /// <p>The TLS configuration for a private integration. If you specify a TLS configuration, private integration traffic uses the HTTPS protocol. Supported only for HTTP APIs.</p>
    pub fn tls_config(&self) -> std::option::Option<&crate::model::TlsConfigInput> {
        self.tls_config.as_ref()
    }
}
impl std::fmt::Debug for CreateIntegrationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateIntegrationInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("connection_id", &self.connection_id);
        formatter.field("connection_type", &self.connection_type);
        formatter.field("content_handling_strategy", &self.content_handling_strategy);
        formatter.field("credentials_arn", &self.credentials_arn);
        formatter.field("description", &self.description);
        formatter.field("integration_method", &self.integration_method);
        formatter.field("integration_subtype", &self.integration_subtype);
        formatter.field("integration_type", &self.integration_type);
        formatter.field("integration_uri", &self.integration_uri);
        formatter.field("passthrough_behavior", &self.passthrough_behavior);
        formatter.field("payload_format_version", &self.payload_format_version);
        formatter.field("request_parameters", &self.request_parameters);
        formatter.field("request_templates", &self.request_templates);
        formatter.field("response_parameters", &self.response_parameters);
        formatter.field(
            "template_selection_expression",
            &self.template_selection_expression,
        );
        formatter.field("timeout_in_millis", &self.timeout_in_millis);
        formatter.field("tls_config", &self.tls_config);
        formatter.finish()
    }
}

/// <p>Creates a new DomainName resource to represent a domain name.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDomainNameInput {
    /// <p>The domain name.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The domain name configurations.</p>
    pub domain_name_configurations:
        std::option::Option<std::vec::Vec<crate::model::DomainNameConfiguration>>,
    /// <p>The mutual TLS authentication configuration for a custom domain name.</p>
    pub mutual_tls_authentication: std::option::Option<crate::model::MutualTlsAuthenticationInput>,
    /// <p>The collection of tags associated with a domain name.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateDomainNameInput {
    /// <p>The domain name.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>The domain name configurations.</p>
    pub fn domain_name_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::DomainNameConfiguration]> {
        self.domain_name_configurations.as_deref()
    }
    /// <p>The mutual TLS authentication configuration for a custom domain name.</p>
    pub fn mutual_tls_authentication(
        &self,
    ) -> std::option::Option<&crate::model::MutualTlsAuthenticationInput> {
        self.mutual_tls_authentication.as_ref()
    }
    /// <p>The collection of tags associated with a domain name.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateDomainNameInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDomainNameInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field(
            "domain_name_configurations",
            &self.domain_name_configurations,
        );
        formatter.field("mutual_tls_authentication", &self.mutual_tls_authentication);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// <p>Creates a new Deployment resource to represent a deployment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDeploymentInput {
    /// <p>The API identifier.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The description for the deployment resource.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The name of the Stage resource for the Deployment resource to create.</p>
    pub stage_name: std::option::Option<std::string::String>,
}
impl CreateDeploymentInput {
    /// <p>The API identifier.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The description for the deployment resource.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The name of the Stage resource for the Deployment resource to create.</p>
    pub fn stage_name(&self) -> std::option::Option<&str> {
        self.stage_name.as_deref()
    }
}
impl std::fmt::Debug for CreateDeploymentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDeploymentInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("description", &self.description);
        formatter.field("stage_name", &self.stage_name);
        formatter.finish()
    }
}

/// <p>Creates a new Authorizer resource to represent an authorizer.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAuthorizerInput {
    /// <p>The API identifier.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, don't specify this parameter. Supported only for REQUEST authorizers.</p>
    pub authorizer_credentials_arn: std::option::Option<std::string::String>,
    /// <p>Specifies the format of the payload sent to an HTTP API Lambda authorizer. Required for HTTP API Lambda authorizers. Supported values are 1.0 and 2.0. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p>
    pub authorizer_payload_format_version: std::option::Option<std::string::String>,
    /// <p>The time to live (TTL) for cached authorizer results, in seconds. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway caches authorizer responses. The maximum value is 3600, or 1 hour. Supported only for HTTP API Lambda authorizers.</p>
    pub authorizer_result_ttl_in_seconds: i32,
    /// <p>The authorizer type. Specify REQUEST for a Lambda function using incoming request parameters. Specify JWT to use JSON Web Tokens (supported only for HTTP APIs).</p>
    pub authorizer_type: std::option::Option<crate::model::AuthorizerType>,
    /// <p>The authorizer's Uniform Resource Identifier (URI). For REQUEST authorizers, this must be a well-formed Lambda function URI, for example, arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:<replaceable>
    /// {account_id}
    /// </replaceable>:function:<replaceable>
    /// {lambda_function_name}
    /// </replaceable>/invocations. In general, the URI has this form: arn:aws:apigateway:<replaceable>
    /// {region}
    /// </replaceable>:lambda:path/<replaceable>
    /// {service_api}
    /// </replaceable> , where <replaceable></replaceable>{region} is the same as the region hosting the Lambda function, path indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial /. For Lambda functions, this is usually of the form /2015-03-31/functions/[FunctionARN]/invocations. Supported only for REQUEST authorizers.</p>
    pub authorizer_uri: std::option::Option<std::string::String>,
    /// <p>Specifies whether a Lambda authorizer returns a response in a simple format. By default, a Lambda authorizer must return an IAM policy. If enabled, the Lambda authorizer can return a boolean value instead of an IAM policy. Supported only for HTTP APIs. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a></p>
    pub enable_simple_responses: bool,
    /// <p>The identity source for which authorization is requested.</p>
    /// <p>For a REQUEST authorizer, this is optional. The value is a set of one or more mapping expressions of the specified request parameters. The identity source can be headers, query string parameters, stage variables, and context parameters. For example, if an Auth header and a Name query string parameter are defined as identity sources, this value is route.request.header.Auth, route.request.querystring.Name for WebSocket APIs. For HTTP APIs, use selection expressions prefixed with $, for example, $request.header.Auth, $request.querystring.Name. These parameters are used to perform runtime validation for Lambda-based authorizers by verifying all of the identity-related request parameters are present in the request, not null, and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function. Otherwise, it returns a 401 Unauthorized response without calling the Lambda function. For HTTP APIs, identity sources are also used as the cache key when caching is enabled. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p>
    /// <p>For JWT, a single entry that specifies where to extract the JSON Web Token (JWT) from inbound requests. Currently only header-based and query parameter-based selections are supported, for example $request.header.Authorization.</p>
    pub identity_source: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>This parameter is not used.</p>
    pub identity_validation_expression: std::option::Option<std::string::String>,
    /// <p>Represents the configuration of a JWT authorizer. Required for the JWT authorizer type. Supported only for HTTP APIs.</p>
    pub jwt_configuration: std::option::Option<crate::model::JwtConfiguration>,
    /// <p>The name of the authorizer.</p>
    pub name: std::option::Option<std::string::String>,
}
impl CreateAuthorizerInput {
    /// <p>The API identifier.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, don't specify this parameter. Supported only for REQUEST authorizers.</p>
    pub fn authorizer_credentials_arn(&self) -> std::option::Option<&str> {
        self.authorizer_credentials_arn.as_deref()
    }
    /// <p>Specifies the format of the payload sent to an HTTP API Lambda authorizer. Required for HTTP API Lambda authorizers. Supported values are 1.0 and 2.0. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p>
    pub fn authorizer_payload_format_version(&self) -> std::option::Option<&str> {
        self.authorizer_payload_format_version.as_deref()
    }
    /// <p>The time to live (TTL) for cached authorizer results, in seconds. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway caches authorizer responses. The maximum value is 3600, or 1 hour. Supported only for HTTP API Lambda authorizers.</p>
    pub fn authorizer_result_ttl_in_seconds(&self) -> i32 {
        self.authorizer_result_ttl_in_seconds
    }
    /// <p>The authorizer type. Specify REQUEST for a Lambda function using incoming request parameters. Specify JWT to use JSON Web Tokens (supported only for HTTP APIs).</p>
    pub fn authorizer_type(&self) -> std::option::Option<&crate::model::AuthorizerType> {
        self.authorizer_type.as_ref()
    }
    /// <p>The authorizer's Uniform Resource Identifier (URI). For REQUEST authorizers, this must be a well-formed Lambda function URI, for example, arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:<replaceable>
    /// {account_id}
    /// </replaceable>:function:<replaceable>
    /// {lambda_function_name}
    /// </replaceable>/invocations. In general, the URI has this form: arn:aws:apigateway:<replaceable>
    /// {region}
    /// </replaceable>:lambda:path/<replaceable>
    /// {service_api}
    /// </replaceable> , where <replaceable></replaceable>{region} is the same as the region hosting the Lambda function, path indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial /. For Lambda functions, this is usually of the form /2015-03-31/functions/[FunctionARN]/invocations. Supported only for REQUEST authorizers.</p>
    pub fn authorizer_uri(&self) -> std::option::Option<&str> {
        self.authorizer_uri.as_deref()
    }
    /// <p>Specifies whether a Lambda authorizer returns a response in a simple format. By default, a Lambda authorizer must return an IAM policy. If enabled, the Lambda authorizer can return a boolean value instead of an IAM policy. Supported only for HTTP APIs. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a></p>
    pub fn enable_simple_responses(&self) -> bool {
        self.enable_simple_responses
    }
    /// <p>The identity source for which authorization is requested.</p>
    /// <p>For a REQUEST authorizer, this is optional. The value is a set of one or more mapping expressions of the specified request parameters. The identity source can be headers, query string parameters, stage variables, and context parameters. For example, if an Auth header and a Name query string parameter are defined as identity sources, this value is route.request.header.Auth, route.request.querystring.Name for WebSocket APIs. For HTTP APIs, use selection expressions prefixed with $, for example, $request.header.Auth, $request.querystring.Name. These parameters are used to perform runtime validation for Lambda-based authorizers by verifying all of the identity-related request parameters are present in the request, not null, and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function. Otherwise, it returns a 401 Unauthorized response without calling the Lambda function. For HTTP APIs, identity sources are also used as the cache key when caching is enabled. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p>
    /// <p>For JWT, a single entry that specifies where to extract the JSON Web Token (JWT) from inbound requests. Currently only header-based and query parameter-based selections are supported, for example $request.header.Authorization.</p>
    pub fn identity_source(&self) -> std::option::Option<&[std::string::String]> {
        self.identity_source.as_deref()
    }
    /// <p>This parameter is not used.</p>
    pub fn identity_validation_expression(&self) -> std::option::Option<&str> {
        self.identity_validation_expression.as_deref()
    }
    /// <p>Represents the configuration of a JWT authorizer. Required for the JWT authorizer type. Supported only for HTTP APIs.</p>
    pub fn jwt_configuration(&self) -> std::option::Option<&crate::model::JwtConfiguration> {
        self.jwt_configuration.as_ref()
    }
    /// <p>The name of the authorizer.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for CreateAuthorizerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAuthorizerInput");
        formatter.field("api_id", &self.api_id);
        formatter.field(
            "authorizer_credentials_arn",
            &self.authorizer_credentials_arn,
        );
        formatter.field(
            "authorizer_payload_format_version",
            &self.authorizer_payload_format_version,
        );
        formatter.field(
            "authorizer_result_ttl_in_seconds",
            &self.authorizer_result_ttl_in_seconds,
        );
        formatter.field("authorizer_type", &self.authorizer_type);
        formatter.field("authorizer_uri", &self.authorizer_uri);
        formatter.field("enable_simple_responses", &self.enable_simple_responses);
        formatter.field("identity_source", &self.identity_source);
        formatter.field(
            "identity_validation_expression",
            &self.identity_validation_expression,
        );
        formatter.field("jwt_configuration", &self.jwt_configuration);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

/// <p>Creates a new ApiMapping resource to represent an API mapping.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateApiMappingInput {
    /// <p>The API identifier.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// The API mapping key.
    pub api_mapping_key: std::option::Option<std::string::String>,
    /// <p>The domain name.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The API stage.</p>
    pub stage: std::option::Option<std::string::String>,
}
impl CreateApiMappingInput {
    /// <p>The API identifier.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// The API mapping key.
    pub fn api_mapping_key(&self) -> std::option::Option<&str> {
        self.api_mapping_key.as_deref()
    }
    /// <p>The domain name.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>The API stage.</p>
    pub fn stage(&self) -> std::option::Option<&str> {
        self.stage.as_deref()
    }
}
impl std::fmt::Debug for CreateApiMappingInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateApiMappingInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("api_mapping_key", &self.api_mapping_key);
        formatter.field("domain_name", &self.domain_name);
        formatter.field("stage", &self.stage);
        formatter.finish()
    }
}

/// <p>Creates a new Api resource to represent an API.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateApiInput {
    /// <p>An API key selection expression. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions">API Key Selection Expressions</a>.</p>
    pub api_key_selection_expression: std::option::Option<std::string::String>,
    /// <p>A CORS configuration. Supported only for HTTP APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-cors.html">Configuring CORS</a> for more information.</p>
    pub cors_configuration: std::option::Option<crate::model::Cors>,
    /// <p>This property is part of quick create. It specifies the credentials required for the integration, if any. For a Lambda integration, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, specify null. Currently, this property is not used for HTTP integrations. Supported only for HTTP APIs.</p>
    pub credentials_arn: std::option::Option<std::string::String>,
    /// <p>The description of the API.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Avoid validating models when creating a deployment. Supported only for WebSocket APIs.</p>
    pub disable_schema_validation: bool,
    /// <p>Specifies whether clients can invoke your API by using the default execute-api endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
    pub disable_execute_api_endpoint: bool,
    /// <p>The name of the API.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The API protocol.</p>
    pub protocol_type: std::option::Option<crate::model::ProtocolType>,
    /// <p>This property is part of quick create. If you don't specify a routeKey, a default route of $default is created. The $default route acts as a catch-all for any request made to your API, for a particular stage. The $default route key can't be modified. You can add routes after creating the API, and you can update the route keys of additional routes. Supported only for HTTP APIs.</p>
    pub route_key: std::option::Option<std::string::String>,
    /// <p>The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.</p>
    pub route_selection_expression: std::option::Option<std::string::String>,
    /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>This property is part of quick create. Quick create produces an API with an integration, a default catch-all route, and a default stage which is configured to automatically deploy changes. For HTTP integrations, specify a fully qualified URL. For Lambda integrations, specify a function ARN. The type of the integration will be HTTP_PROXY or AWS_PROXY, respectively. Supported only for HTTP APIs.</p>
    pub target: std::option::Option<std::string::String>,
    /// <p>A version identifier for the API.</p>
    pub version: std::option::Option<std::string::String>,
}
impl CreateApiInput {
    /// <p>An API key selection expression. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions">API Key Selection Expressions</a>.</p>
    pub fn api_key_selection_expression(&self) -> std::option::Option<&str> {
        self.api_key_selection_expression.as_deref()
    }
    /// <p>A CORS configuration. Supported only for HTTP APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-cors.html">Configuring CORS</a> for more information.</p>
    pub fn cors_configuration(&self) -> std::option::Option<&crate::model::Cors> {
        self.cors_configuration.as_ref()
    }
    /// <p>This property is part of quick create. It specifies the credentials required for the integration, if any. For a Lambda integration, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, specify null. Currently, this property is not used for HTTP integrations. Supported only for HTTP APIs.</p>
    pub fn credentials_arn(&self) -> std::option::Option<&str> {
        self.credentials_arn.as_deref()
    }
    /// <p>The description of the API.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Avoid validating models when creating a deployment. Supported only for WebSocket APIs.</p>
    pub fn disable_schema_validation(&self) -> bool {
        self.disable_schema_validation
    }
    /// <p>Specifies whether clients can invoke your API by using the default execute-api endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
    pub fn disable_execute_api_endpoint(&self) -> bool {
        self.disable_execute_api_endpoint
    }
    /// <p>The name of the API.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The API protocol.</p>
    pub fn protocol_type(&self) -> std::option::Option<&crate::model::ProtocolType> {
        self.protocol_type.as_ref()
    }
    /// <p>This property is part of quick create. If you don't specify a routeKey, a default route of $default is created. The $default route acts as a catch-all for any request made to your API, for a particular stage. The $default route key can't be modified. You can add routes after creating the API, and you can update the route keys of additional routes. Supported only for HTTP APIs.</p>
    pub fn route_key(&self) -> std::option::Option<&str> {
        self.route_key.as_deref()
    }
    /// <p>The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.</p>
    pub fn route_selection_expression(&self) -> std::option::Option<&str> {
        self.route_selection_expression.as_deref()
    }
    /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>This property is part of quick create. Quick create produces an API with an integration, a default catch-all route, and a default stage which is configured to automatically deploy changes. For HTTP integrations, specify a fully qualified URL. For Lambda integrations, specify a function ARN. The type of the integration will be HTTP_PROXY or AWS_PROXY, respectively. Supported only for HTTP APIs.</p>
    pub fn target(&self) -> std::option::Option<&str> {
        self.target.as_deref()
    }
    /// <p>A version identifier for the API.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
}
impl std::fmt::Debug for CreateApiInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateApiInput");
        formatter.field(
            "api_key_selection_expression",
            &self.api_key_selection_expression,
        );
        formatter.field("cors_configuration", &self.cors_configuration);
        formatter.field("credentials_arn", &self.credentials_arn);
        formatter.field("description", &self.description);
        formatter.field("disable_schema_validation", &self.disable_schema_validation);
        formatter.field(
            "disable_execute_api_endpoint",
            &self.disable_execute_api_endpoint,
        );
        formatter.field("name", &self.name);
        formatter.field("protocol_type", &self.protocol_type);
        formatter.field("route_key", &self.route_key);
        formatter.field(
            "route_selection_expression",
            &self.route_selection_expression,
        );
        formatter.field("tags", &self.tags);
        formatter.field("target", &self.target);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}
