// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateVpcLinkOutput {
    /// <p>The timestamp when the VPC link was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The name of the VPC link.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A list of security group IDs for the VPC link.</p>
    pub security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of subnet IDs to include in the VPC link.</p>
    pub subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Tags for the VPC link.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The ID of the VPC link.</p>
    pub vpc_link_id: std::option::Option<std::string::String>,
    /// <p>The status of the VPC link.</p>
    pub vpc_link_status: std::option::Option<crate::model::VpcLinkStatus>,
    /// <p>A message summarizing the cause of the status of the VPC link.</p>
    pub vpc_link_status_message: std::option::Option<std::string::String>,
    /// <p>The version of the VPC link.</p>
    pub vpc_link_version: std::option::Option<crate::model::VpcLinkVersion>,
}
impl UpdateVpcLinkOutput {
    /// <p>The timestamp when the VPC link was created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_date.as_ref()
    }
    /// <p>The name of the VPC link.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A list of security group IDs for the VPC link.</p>
    pub fn security_group_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.security_group_ids.as_deref()
    }
    /// <p>A list of subnet IDs to include in the VPC link.</p>
    pub fn subnet_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.subnet_ids.as_deref()
    }
    /// <p>Tags for the VPC link.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The ID of the VPC link.</p>
    pub fn vpc_link_id(&self) -> std::option::Option<&str> {
        self.vpc_link_id.as_deref()
    }
    /// <p>The status of the VPC link.</p>
    pub fn vpc_link_status(&self) -> std::option::Option<&crate::model::VpcLinkStatus> {
        self.vpc_link_status.as_ref()
    }
    /// <p>A message summarizing the cause of the status of the VPC link.</p>
    pub fn vpc_link_status_message(&self) -> std::option::Option<&str> {
        self.vpc_link_status_message.as_deref()
    }
    /// <p>The version of the VPC link.</p>
    pub fn vpc_link_version(&self) -> std::option::Option<&crate::model::VpcLinkVersion> {
        self.vpc_link_version.as_ref()
    }
}
impl std::fmt::Debug for UpdateVpcLinkOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateVpcLinkOutput");
        formatter.field("created_date", &self.created_date);
        formatter.field("name", &self.name);
        formatter.field("security_group_ids", &self.security_group_ids);
        formatter.field("subnet_ids", &self.subnet_ids);
        formatter.field("tags", &self.tags);
        formatter.field("vpc_link_id", &self.vpc_link_id);
        formatter.field("vpc_link_status", &self.vpc_link_status);
        formatter.field("vpc_link_status_message", &self.vpc_link_status_message);
        formatter.field("vpc_link_version", &self.vpc_link_version);
        formatter.finish()
    }
}
/// See [`UpdateVpcLinkOutput`](crate::output::UpdateVpcLinkOutput)
pub mod update_vpc_link_output {
    /// A builder for [`UpdateVpcLinkOutput`](crate::output::UpdateVpcLinkOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) created_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) vpc_link_id: std::option::Option<std::string::String>,
        pub(crate) vpc_link_status: std::option::Option<crate::model::VpcLinkStatus>,
        pub(crate) vpc_link_status_message: std::option::Option<std::string::String>,
        pub(crate) vpc_link_version: std::option::Option<crate::model::VpcLinkVersion>,
    }
    impl Builder {
        /// <p>The timestamp when the VPC link was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The timestamp when the VPC link was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>The name of the VPC link.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the VPC link.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>A list of security group IDs for the VPC link.</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.security_group_ids = Some(v);
            self
        }
        /// <p>A list of security group IDs for the VPC link.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_ids = input;
            self
        }
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>A list of subnet IDs to include in the VPC link.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>A list of subnet IDs to include in the VPC link.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags for the VPC link.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Tags for the VPC link.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The ID of the VPC link.</p>
        pub fn vpc_link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_link_id = Some(input.into());
            self
        }
        /// <p>The ID of the VPC link.</p>
        pub fn set_vpc_link_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_link_id = input;
            self
        }
        /// <p>The status of the VPC link.</p>
        pub fn vpc_link_status(mut self, input: crate::model::VpcLinkStatus) -> Self {
            self.vpc_link_status = Some(input);
            self
        }
        /// <p>The status of the VPC link.</p>
        pub fn set_vpc_link_status(
            mut self,
            input: std::option::Option<crate::model::VpcLinkStatus>,
        ) -> Self {
            self.vpc_link_status = input;
            self
        }
        /// <p>A message summarizing the cause of the status of the VPC link.</p>
        pub fn vpc_link_status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_link_status_message = Some(input.into());
            self
        }
        /// <p>A message summarizing the cause of the status of the VPC link.</p>
        pub fn set_vpc_link_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vpc_link_status_message = input;
            self
        }
        /// <p>The version of the VPC link.</p>
        pub fn vpc_link_version(mut self, input: crate::model::VpcLinkVersion) -> Self {
            self.vpc_link_version = Some(input);
            self
        }
        /// <p>The version of the VPC link.</p>
        pub fn set_vpc_link_version(
            mut self,
            input: std::option::Option<crate::model::VpcLinkVersion>,
        ) -> Self {
            self.vpc_link_version = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateVpcLinkOutput`](crate::output::UpdateVpcLinkOutput)
        pub fn build(self) -> crate::output::UpdateVpcLinkOutput {
            crate::output::UpdateVpcLinkOutput {
                created_date: self.created_date,
                name: self.name,
                security_group_ids: self.security_group_ids,
                subnet_ids: self.subnet_ids,
                tags: self.tags,
                vpc_link_id: self.vpc_link_id,
                vpc_link_status: self.vpc_link_status,
                vpc_link_status_message: self.vpc_link_status_message,
                vpc_link_version: self.vpc_link_version,
            }
        }
    }
}
impl UpdateVpcLinkOutput {
    /// Creates a new builder-style object to manufacture [`UpdateVpcLinkOutput`](crate::output::UpdateVpcLinkOutput)
    pub fn builder() -> crate::output::update_vpc_link_output::Builder {
        crate::output::update_vpc_link_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateStageOutput {
    /// <p>Settings for logging access in this stage.</p>
    pub access_log_settings: std::option::Option<crate::model::AccessLogSettings>,
    /// <p>Specifies whether a stage is managed by API Gateway. If you created an API using quick create, the $default stage is managed by API Gateway. You can't modify the $default stage.</p>
    pub api_gateway_managed: bool,
    /// <p>Specifies whether updates to an API automatically trigger a new deployment. The default value is false.</p>
    pub auto_deploy: bool,
    /// <p>The identifier of a client certificate for a Stage. Supported only for WebSocket APIs.</p>
    pub client_certificate_id: std::option::Option<std::string::String>,
    /// <p>The timestamp when the stage was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Default route settings for the stage.</p>
    pub default_route_settings: std::option::Option<crate::model::RouteSettings>,
    /// <p>The identifier of the Deployment that the Stage is associated with. Can't be updated if autoDeploy is enabled.</p>
    pub deployment_id: std::option::Option<std::string::String>,
    /// <p>The description of the stage.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Describes the status of the last deployment of a stage. Supported only for stages with autoDeploy enabled.</p>
    pub last_deployment_status_message: std::option::Option<std::string::String>,
    /// <p>The timestamp when the stage was last updated.</p>
    pub last_updated_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Route settings for the stage, by routeKey.</p>
    pub route_settings: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::RouteSettings>,
    >,
    /// <p>The name of the stage.</p>
    pub stage_name: std::option::Option<std::string::String>,
    /// <p>A map that defines the stage variables for a stage resource. Variable names can have alphanumeric and underscore characters, and the values must match [A-Za-z0-9-._~:/?#&amp;=,]+.</p>
    pub stage_variables:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl UpdateStageOutput {
    /// <p>Settings for logging access in this stage.</p>
    pub fn access_log_settings(&self) -> std::option::Option<&crate::model::AccessLogSettings> {
        self.access_log_settings.as_ref()
    }
    /// <p>Specifies whether a stage is managed by API Gateway. If you created an API using quick create, the $default stage is managed by API Gateway. You can't modify the $default stage.</p>
    pub fn api_gateway_managed(&self) -> bool {
        self.api_gateway_managed
    }
    /// <p>Specifies whether updates to an API automatically trigger a new deployment. The default value is false.</p>
    pub fn auto_deploy(&self) -> bool {
        self.auto_deploy
    }
    /// <p>The identifier of a client certificate for a Stage. Supported only for WebSocket APIs.</p>
    pub fn client_certificate_id(&self) -> std::option::Option<&str> {
        self.client_certificate_id.as_deref()
    }
    /// <p>The timestamp when the stage was created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_date.as_ref()
    }
    /// <p>Default route settings for the stage.</p>
    pub fn default_route_settings(&self) -> std::option::Option<&crate::model::RouteSettings> {
        self.default_route_settings.as_ref()
    }
    /// <p>The identifier of the Deployment that the Stage is associated with. Can't be updated if autoDeploy is enabled.</p>
    pub fn deployment_id(&self) -> std::option::Option<&str> {
        self.deployment_id.as_deref()
    }
    /// <p>The description of the stage.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Describes the status of the last deployment of a stage. Supported only for stages with autoDeploy enabled.</p>
    pub fn last_deployment_status_message(&self) -> std::option::Option<&str> {
        self.last_deployment_status_message.as_deref()
    }
    /// <p>The timestamp when the stage was last updated.</p>
    pub fn last_updated_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_updated_date.as_ref()
    }
    /// <p>Route settings for the stage, by routeKey.</p>
    pub fn route_settings(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::RouteSettings>,
    > {
        self.route_settings.as_ref()
    }
    /// <p>The name of the stage.</p>
    pub fn stage_name(&self) -> std::option::Option<&str> {
        self.stage_name.as_deref()
    }
    /// <p>A map that defines the stage variables for a stage resource. Variable names can have alphanumeric and underscore characters, and the values must match [A-Za-z0-9-._~:/?#&amp;=,]+.</p>
    pub fn stage_variables(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.stage_variables.as_ref()
    }
    /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for UpdateStageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateStageOutput");
        formatter.field("access_log_settings", &self.access_log_settings);
        formatter.field("api_gateway_managed", &self.api_gateway_managed);
        formatter.field("auto_deploy", &self.auto_deploy);
        formatter.field("client_certificate_id", &self.client_certificate_id);
        formatter.field("created_date", &self.created_date);
        formatter.field("default_route_settings", &self.default_route_settings);
        formatter.field("deployment_id", &self.deployment_id);
        formatter.field("description", &self.description);
        formatter.field(
            "last_deployment_status_message",
            &self.last_deployment_status_message,
        );
        formatter.field("last_updated_date", &self.last_updated_date);
        formatter.field("route_settings", &self.route_settings);
        formatter.field("stage_name", &self.stage_name);
        formatter.field("stage_variables", &self.stage_variables);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`UpdateStageOutput`](crate::output::UpdateStageOutput)
pub mod update_stage_output {
    /// A builder for [`UpdateStageOutput`](crate::output::UpdateStageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_log_settings: std::option::Option<crate::model::AccessLogSettings>,
        pub(crate) api_gateway_managed: std::option::Option<bool>,
        pub(crate) auto_deploy: std::option::Option<bool>,
        pub(crate) client_certificate_id: std::option::Option<std::string::String>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) default_route_settings: std::option::Option<crate::model::RouteSettings>,
        pub(crate) deployment_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) last_deployment_status_message: std::option::Option<std::string::String>,
        pub(crate) last_updated_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) route_settings: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::RouteSettings>,
        >,
        pub(crate) stage_name: std::option::Option<std::string::String>,
        pub(crate) stage_variables: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>Settings for logging access in this stage.</p>
        pub fn access_log_settings(mut self, input: crate::model::AccessLogSettings) -> Self {
            self.access_log_settings = Some(input);
            self
        }
        /// <p>Settings for logging access in this stage.</p>
        pub fn set_access_log_settings(
            mut self,
            input: std::option::Option<crate::model::AccessLogSettings>,
        ) -> Self {
            self.access_log_settings = input;
            self
        }
        /// <p>Specifies whether a stage is managed by API Gateway. If you created an API using quick create, the $default stage is managed by API Gateway. You can't modify the $default stage.</p>
        pub fn api_gateway_managed(mut self, input: bool) -> Self {
            self.api_gateway_managed = Some(input);
            self
        }
        /// <p>Specifies whether a stage is managed by API Gateway. If you created an API using quick create, the $default stage is managed by API Gateway. You can't modify the $default stage.</p>
        pub fn set_api_gateway_managed(mut self, input: std::option::Option<bool>) -> Self {
            self.api_gateway_managed = input;
            self
        }
        /// <p>Specifies whether updates to an API automatically trigger a new deployment. The default value is false.</p>
        pub fn auto_deploy(mut self, input: bool) -> Self {
            self.auto_deploy = Some(input);
            self
        }
        /// <p>Specifies whether updates to an API automatically trigger a new deployment. The default value is false.</p>
        pub fn set_auto_deploy(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_deploy = input;
            self
        }
        /// <p>The identifier of a client certificate for a Stage. Supported only for WebSocket APIs.</p>
        pub fn client_certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_certificate_id = Some(input.into());
            self
        }
        /// <p>The identifier of a client certificate for a Stage. Supported only for WebSocket APIs.</p>
        pub fn set_client_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_certificate_id = input;
            self
        }
        /// <p>The timestamp when the stage was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The timestamp when the stage was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>Default route settings for the stage.</p>
        pub fn default_route_settings(mut self, input: crate::model::RouteSettings) -> Self {
            self.default_route_settings = Some(input);
            self
        }
        /// <p>Default route settings for the stage.</p>
        pub fn set_default_route_settings(
            mut self,
            input: std::option::Option<crate::model::RouteSettings>,
        ) -> Self {
            self.default_route_settings = input;
            self
        }
        /// <p>The identifier of the Deployment that the Stage is associated with. Can't be updated if autoDeploy is enabled.</p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Deployment that the Stage is associated with. Can't be updated if autoDeploy is enabled.</p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_id = input;
            self
        }
        /// <p>The description of the stage.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the stage.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Describes the status of the last deployment of a stage. Supported only for stages with autoDeploy enabled.</p>
        pub fn last_deployment_status_message(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.last_deployment_status_message = Some(input.into());
            self
        }
        /// <p>Describes the status of the last deployment of a stage. Supported only for stages with autoDeploy enabled.</p>
        pub fn set_last_deployment_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_deployment_status_message = input;
            self
        }
        /// <p>The timestamp when the stage was last updated.</p>
        pub fn last_updated_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_date = Some(input);
            self
        }
        /// <p>The timestamp when the stage was last updated.</p>
        pub fn set_last_updated_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_date = input;
            self
        }
        /// Adds a key-value pair to `route_settings`.
        ///
        /// To override the contents of this collection use [`set_route_settings`](Self::set_route_settings).
        ///
        /// <p>Route settings for the stage, by routeKey.</p>
        pub fn route_settings(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::RouteSettings>,
        ) -> Self {
            let mut hash_map = self.route_settings.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.route_settings = Some(hash_map);
            self
        }
        /// <p>Route settings for the stage, by routeKey.</p>
        pub fn set_route_settings(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::RouteSettings>,
            >,
        ) -> Self {
            self.route_settings = input;
            self
        }
        /// <p>The name of the stage.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stage_name = Some(input.into());
            self
        }
        /// <p>The name of the stage.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stage_name = input;
            self
        }
        /// Adds a key-value pair to `stage_variables`.
        ///
        /// To override the contents of this collection use [`set_stage_variables`](Self::set_stage_variables).
        ///
        /// <p>A map that defines the stage variables for a stage resource. Variable names can have alphanumeric and underscore characters, and the values must match [A-Za-z0-9-._~:/?#&amp;=,]+.</p>
        pub fn stage_variables(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.stage_variables.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.stage_variables = Some(hash_map);
            self
        }
        /// <p>A map that defines the stage variables for a stage resource. Variable names can have alphanumeric and underscore characters, and the values must match [A-Za-z0-9-._~:/?#&amp;=,]+.</p>
        pub fn set_stage_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.stage_variables = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateStageOutput`](crate::output::UpdateStageOutput)
        pub fn build(self) -> crate::output::UpdateStageOutput {
            crate::output::UpdateStageOutput {
                access_log_settings: self.access_log_settings,
                api_gateway_managed: self.api_gateway_managed.unwrap_or_default(),
                auto_deploy: self.auto_deploy.unwrap_or_default(),
                client_certificate_id: self.client_certificate_id,
                created_date: self.created_date,
                default_route_settings: self.default_route_settings,
                deployment_id: self.deployment_id,
                description: self.description,
                last_deployment_status_message: self.last_deployment_status_message,
                last_updated_date: self.last_updated_date,
                route_settings: self.route_settings,
                stage_name: self.stage_name,
                stage_variables: self.stage_variables,
                tags: self.tags,
            }
        }
    }
}
impl UpdateStageOutput {
    /// Creates a new builder-style object to manufacture [`UpdateStageOutput`](crate::output::UpdateStageOutput)
    pub fn builder() -> crate::output::update_stage_output::Builder {
        crate::output::update_stage_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRouteResponseOutput {
    /// <p>Represents the model selection expression of a route response. Supported only for WebSocket APIs.</p>
    pub model_selection_expression: std::option::Option<std::string::String>,
    /// <p>Represents the response models of a route response.</p>
    pub response_models:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Represents the response parameters of a route response.</p>
    pub response_parameters: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::ParameterConstraints>,
    >,
    /// <p>Represents the identifier of a route response.</p>
    pub route_response_id: std::option::Option<std::string::String>,
    /// <p>Represents the route response key of a route response.</p>
    pub route_response_key: std::option::Option<std::string::String>,
}
impl UpdateRouteResponseOutput {
    /// <p>Represents the model selection expression of a route response. Supported only for WebSocket APIs.</p>
    pub fn model_selection_expression(&self) -> std::option::Option<&str> {
        self.model_selection_expression.as_deref()
    }
    /// <p>Represents the response models of a route response.</p>
    pub fn response_models(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.response_models.as_ref()
    }
    /// <p>Represents the response parameters of a route response.</p>
    pub fn response_parameters(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::ParameterConstraints>,
    > {
        self.response_parameters.as_ref()
    }
    /// <p>Represents the identifier of a route response.</p>
    pub fn route_response_id(&self) -> std::option::Option<&str> {
        self.route_response_id.as_deref()
    }
    /// <p>Represents the route response key of a route response.</p>
    pub fn route_response_key(&self) -> std::option::Option<&str> {
        self.route_response_key.as_deref()
    }
}
impl std::fmt::Debug for UpdateRouteResponseOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRouteResponseOutput");
        formatter.field(
            "model_selection_expression",
            &self.model_selection_expression,
        );
        formatter.field("response_models", &self.response_models);
        formatter.field("response_parameters", &self.response_parameters);
        formatter.field("route_response_id", &self.route_response_id);
        formatter.field("route_response_key", &self.route_response_key);
        formatter.finish()
    }
}
/// See [`UpdateRouteResponseOutput`](crate::output::UpdateRouteResponseOutput)
pub mod update_route_response_output {
    /// A builder for [`UpdateRouteResponseOutput`](crate::output::UpdateRouteResponseOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) model_selection_expression: std::option::Option<std::string::String>,
        pub(crate) response_models: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) response_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::ParameterConstraints>,
        >,
        pub(crate) route_response_id: std::option::Option<std::string::String>,
        pub(crate) route_response_key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Represents the model selection expression of a route response. Supported only for WebSocket APIs.</p>
        pub fn model_selection_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_selection_expression = Some(input.into());
            self
        }
        /// <p>Represents the model selection expression of a route response. Supported only for WebSocket APIs.</p>
        pub fn set_model_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_selection_expression = input;
            self
        }
        /// Adds a key-value pair to `response_models`.
        ///
        /// To override the contents of this collection use [`set_response_models`](Self::set_response_models).
        ///
        /// <p>Represents the response models of a route response.</p>
        pub fn response_models(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.response_models.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.response_models = Some(hash_map);
            self
        }
        /// <p>Represents the response models of a route response.</p>
        pub fn set_response_models(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.response_models = input;
            self
        }
        /// Adds a key-value pair to `response_parameters`.
        ///
        /// To override the contents of this collection use [`set_response_parameters`](Self::set_response_parameters).
        ///
        /// <p>Represents the response parameters of a route response.</p>
        pub fn response_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::ParameterConstraints>,
        ) -> Self {
            let mut hash_map = self.response_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.response_parameters = Some(hash_map);
            self
        }
        /// <p>Represents the response parameters of a route response.</p>
        pub fn set_response_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::ParameterConstraints>,
            >,
        ) -> Self {
            self.response_parameters = input;
            self
        }
        /// <p>Represents the identifier of a route response.</p>
        pub fn route_response_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_response_id = Some(input.into());
            self
        }
        /// <p>Represents the identifier of a route response.</p>
        pub fn set_route_response_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.route_response_id = input;
            self
        }
        /// <p>Represents the route response key of a route response.</p>
        pub fn route_response_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_response_key = Some(input.into());
            self
        }
        /// <p>Represents the route response key of a route response.</p>
        pub fn set_route_response_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.route_response_key = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRouteResponseOutput`](crate::output::UpdateRouteResponseOutput)
        pub fn build(self) -> crate::output::UpdateRouteResponseOutput {
            crate::output::UpdateRouteResponseOutput {
                model_selection_expression: self.model_selection_expression,
                response_models: self.response_models,
                response_parameters: self.response_parameters,
                route_response_id: self.route_response_id,
                route_response_key: self.route_response_key,
            }
        }
    }
}
impl UpdateRouteResponseOutput {
    /// Creates a new builder-style object to manufacture [`UpdateRouteResponseOutput`](crate::output::UpdateRouteResponseOutput)
    pub fn builder() -> crate::output::update_route_response_output::Builder {
        crate::output::update_route_response_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRouteOutput {
    /// <p>Specifies whether a route is managed by API Gateway. If you created an API using quick create, the $default route is managed by API Gateway. You can't modify the $default route key.</p>
    pub api_gateway_managed: bool,
    /// <p>Specifies whether an API key is required for this route. Supported only for WebSocket APIs.</p>
    pub api_key_required: bool,
    /// <p>A list of authorization scopes configured on a route. The scopes are used with a JWT authorizer to authorize the method invocation. The authorization works by matching the route scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any route scope matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the route scope is configured, the client must provide an access token instead of an identity token for authorization purposes.</p>
    pub authorization_scopes: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The authorization type for the route. For WebSocket APIs, valid values are NONE for open access, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer For HTTP APIs, valid values are NONE for open access, JWT for using JSON Web Tokens, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer.</p>
    pub authorization_type: std::option::Option<crate::model::AuthorizationType>,
    /// <p>The identifier of the Authorizer resource to be associated with this route. The authorizer identifier is generated by API Gateway when you created the authorizer.</p>
    pub authorizer_id: std::option::Option<std::string::String>,
    /// <p>The model selection expression for the route. Supported only for WebSocket APIs.</p>
    pub model_selection_expression: std::option::Option<std::string::String>,
    /// <p>The operation name for the route.</p>
    pub operation_name: std::option::Option<std::string::String>,
    /// <p>The request models for the route. Supported only for WebSocket APIs.</p>
    pub request_models:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The request parameters for the route. Supported only for WebSocket APIs.</p>
    pub request_parameters: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::ParameterConstraints>,
    >,
    /// <p>The route ID.</p>
    pub route_id: std::option::Option<std::string::String>,
    /// <p>The route key for the route.</p>
    pub route_key: std::option::Option<std::string::String>,
    /// <p>The route response selection expression for the route. Supported only for WebSocket APIs.</p>
    pub route_response_selection_expression: std::option::Option<std::string::String>,
    /// <p>The target for the route.</p>
    pub target: std::option::Option<std::string::String>,
}
impl UpdateRouteOutput {
    /// <p>Specifies whether a route is managed by API Gateway. If you created an API using quick create, the $default route is managed by API Gateway. You can't modify the $default route key.</p>
    pub fn api_gateway_managed(&self) -> bool {
        self.api_gateway_managed
    }
    /// <p>Specifies whether an API key is required for this route. Supported only for WebSocket APIs.</p>
    pub fn api_key_required(&self) -> bool {
        self.api_key_required
    }
    /// <p>A list of authorization scopes configured on a route. The scopes are used with a JWT authorizer to authorize the method invocation. The authorization works by matching the route scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any route scope matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the route scope is configured, the client must provide an access token instead of an identity token for authorization purposes.</p>
    pub fn authorization_scopes(&self) -> std::option::Option<&[std::string::String]> {
        self.authorization_scopes.as_deref()
    }
    /// <p>The authorization type for the route. For WebSocket APIs, valid values are NONE for open access, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer For HTTP APIs, valid values are NONE for open access, JWT for using JSON Web Tokens, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer.</p>
    pub fn authorization_type(&self) -> std::option::Option<&crate::model::AuthorizationType> {
        self.authorization_type.as_ref()
    }
    /// <p>The identifier of the Authorizer resource to be associated with this route. The authorizer identifier is generated by API Gateway when you created the authorizer.</p>
    pub fn authorizer_id(&self) -> std::option::Option<&str> {
        self.authorizer_id.as_deref()
    }
    /// <p>The model selection expression for the route. Supported only for WebSocket APIs.</p>
    pub fn model_selection_expression(&self) -> std::option::Option<&str> {
        self.model_selection_expression.as_deref()
    }
    /// <p>The operation name for the route.</p>
    pub fn operation_name(&self) -> std::option::Option<&str> {
        self.operation_name.as_deref()
    }
    /// <p>The request models for the route. Supported only for WebSocket APIs.</p>
    pub fn request_models(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.request_models.as_ref()
    }
    /// <p>The request parameters for the route. Supported only for WebSocket APIs.</p>
    pub fn request_parameters(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::ParameterConstraints>,
    > {
        self.request_parameters.as_ref()
    }
    /// <p>The route ID.</p>
    pub fn route_id(&self) -> std::option::Option<&str> {
        self.route_id.as_deref()
    }
    /// <p>The route key for the route.</p>
    pub fn route_key(&self) -> std::option::Option<&str> {
        self.route_key.as_deref()
    }
    /// <p>The route response selection expression for the route. Supported only for WebSocket APIs.</p>
    pub fn route_response_selection_expression(&self) -> std::option::Option<&str> {
        self.route_response_selection_expression.as_deref()
    }
    /// <p>The target for the route.</p>
    pub fn target(&self) -> std::option::Option<&str> {
        self.target.as_deref()
    }
}
impl std::fmt::Debug for UpdateRouteOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRouteOutput");
        formatter.field("api_gateway_managed", &self.api_gateway_managed);
        formatter.field("api_key_required", &self.api_key_required);
        formatter.field("authorization_scopes", &self.authorization_scopes);
        formatter.field("authorization_type", &self.authorization_type);
        formatter.field("authorizer_id", &self.authorizer_id);
        formatter.field(
            "model_selection_expression",
            &self.model_selection_expression,
        );
        formatter.field("operation_name", &self.operation_name);
        formatter.field("request_models", &self.request_models);
        formatter.field("request_parameters", &self.request_parameters);
        formatter.field("route_id", &self.route_id);
        formatter.field("route_key", &self.route_key);
        formatter.field(
            "route_response_selection_expression",
            &self.route_response_selection_expression,
        );
        formatter.field("target", &self.target);
        formatter.finish()
    }
}
/// See [`UpdateRouteOutput`](crate::output::UpdateRouteOutput)
pub mod update_route_output {
    /// A builder for [`UpdateRouteOutput`](crate::output::UpdateRouteOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_gateway_managed: std::option::Option<bool>,
        pub(crate) api_key_required: std::option::Option<bool>,
        pub(crate) authorization_scopes: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) authorization_type: std::option::Option<crate::model::AuthorizationType>,
        pub(crate) authorizer_id: std::option::Option<std::string::String>,
        pub(crate) model_selection_expression: std::option::Option<std::string::String>,
        pub(crate) operation_name: std::option::Option<std::string::String>,
        pub(crate) request_models: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) request_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::ParameterConstraints>,
        >,
        pub(crate) route_id: std::option::Option<std::string::String>,
        pub(crate) route_key: std::option::Option<std::string::String>,
        pub(crate) route_response_selection_expression: std::option::Option<std::string::String>,
        pub(crate) target: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies whether a route is managed by API Gateway. If you created an API using quick create, the $default route is managed by API Gateway. You can't modify the $default route key.</p>
        pub fn api_gateway_managed(mut self, input: bool) -> Self {
            self.api_gateway_managed = Some(input);
            self
        }
        /// <p>Specifies whether a route is managed by API Gateway. If you created an API using quick create, the $default route is managed by API Gateway. You can't modify the $default route key.</p>
        pub fn set_api_gateway_managed(mut self, input: std::option::Option<bool>) -> Self {
            self.api_gateway_managed = input;
            self
        }
        /// <p>Specifies whether an API key is required for this route. Supported only for WebSocket APIs.</p>
        pub fn api_key_required(mut self, input: bool) -> Self {
            self.api_key_required = Some(input);
            self
        }
        /// <p>Specifies whether an API key is required for this route. Supported only for WebSocket APIs.</p>
        pub fn set_api_key_required(mut self, input: std::option::Option<bool>) -> Self {
            self.api_key_required = input;
            self
        }
        /// Appends an item to `authorization_scopes`.
        ///
        /// To override the contents of this collection use [`set_authorization_scopes`](Self::set_authorization_scopes).
        ///
        /// <p>A list of authorization scopes configured on a route. The scopes are used with a JWT authorizer to authorize the method invocation. The authorization works by matching the route scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any route scope matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the route scope is configured, the client must provide an access token instead of an identity token for authorization purposes.</p>
        pub fn authorization_scopes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.authorization_scopes.unwrap_or_default();
            v.push(input.into());
            self.authorization_scopes = Some(v);
            self
        }
        /// <p>A list of authorization scopes configured on a route. The scopes are used with a JWT authorizer to authorize the method invocation. The authorization works by matching the route scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any route scope matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the route scope is configured, the client must provide an access token instead of an identity token for authorization purposes.</p>
        pub fn set_authorization_scopes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.authorization_scopes = input;
            self
        }
        /// <p>The authorization type for the route. For WebSocket APIs, valid values are NONE for open access, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer For HTTP APIs, valid values are NONE for open access, JWT for using JSON Web Tokens, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer.</p>
        pub fn authorization_type(mut self, input: crate::model::AuthorizationType) -> Self {
            self.authorization_type = Some(input);
            self
        }
        /// <p>The authorization type for the route. For WebSocket APIs, valid values are NONE for open access, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer For HTTP APIs, valid values are NONE for open access, JWT for using JSON Web Tokens, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer.</p>
        pub fn set_authorization_type(
            mut self,
            input: std::option::Option<crate::model::AuthorizationType>,
        ) -> Self {
            self.authorization_type = input;
            self
        }
        /// <p>The identifier of the Authorizer resource to be associated with this route. The authorizer identifier is generated by API Gateway when you created the authorizer.</p>
        pub fn authorizer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorizer_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Authorizer resource to be associated with this route. The authorizer identifier is generated by API Gateway when you created the authorizer.</p>
        pub fn set_authorizer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorizer_id = input;
            self
        }
        /// <p>The model selection expression for the route. Supported only for WebSocket APIs.</p>
        pub fn model_selection_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_selection_expression = Some(input.into());
            self
        }
        /// <p>The model selection expression for the route. Supported only for WebSocket APIs.</p>
        pub fn set_model_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_selection_expression = input;
            self
        }
        /// <p>The operation name for the route.</p>
        pub fn operation_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation_name = Some(input.into());
            self
        }
        /// <p>The operation name for the route.</p>
        pub fn set_operation_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.operation_name = input;
            self
        }
        /// Adds a key-value pair to `request_models`.
        ///
        /// To override the contents of this collection use [`set_request_models`](Self::set_request_models).
        ///
        /// <p>The request models for the route. Supported only for WebSocket APIs.</p>
        pub fn request_models(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.request_models.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.request_models = Some(hash_map);
            self
        }
        /// <p>The request models for the route. Supported only for WebSocket APIs.</p>
        pub fn set_request_models(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.request_models = input;
            self
        }
        /// Adds a key-value pair to `request_parameters`.
        ///
        /// To override the contents of this collection use [`set_request_parameters`](Self::set_request_parameters).
        ///
        /// <p>The request parameters for the route. Supported only for WebSocket APIs.</p>
        pub fn request_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::ParameterConstraints>,
        ) -> Self {
            let mut hash_map = self.request_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.request_parameters = Some(hash_map);
            self
        }
        /// <p>The request parameters for the route. Supported only for WebSocket APIs.</p>
        pub fn set_request_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::ParameterConstraints>,
            >,
        ) -> Self {
            self.request_parameters = input;
            self
        }
        /// <p>The route ID.</p>
        pub fn route_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_id = Some(input.into());
            self
        }
        /// <p>The route ID.</p>
        pub fn set_route_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.route_id = input;
            self
        }
        /// <p>The route key for the route.</p>
        pub fn route_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_key = Some(input.into());
            self
        }
        /// <p>The route key for the route.</p>
        pub fn set_route_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.route_key = input;
            self
        }
        /// <p>The route response selection expression for the route. Supported only for WebSocket APIs.</p>
        pub fn route_response_selection_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.route_response_selection_expression = Some(input.into());
            self
        }
        /// <p>The route response selection expression for the route. Supported only for WebSocket APIs.</p>
        pub fn set_route_response_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.route_response_selection_expression = input;
            self
        }
        /// <p>The target for the route.</p>
        pub fn target(mut self, input: impl Into<std::string::String>) -> Self {
            self.target = Some(input.into());
            self
        }
        /// <p>The target for the route.</p>
        pub fn set_target(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRouteOutput`](crate::output::UpdateRouteOutput)
        pub fn build(self) -> crate::output::UpdateRouteOutput {
            crate::output::UpdateRouteOutput {
                api_gateway_managed: self.api_gateway_managed.unwrap_or_default(),
                api_key_required: self.api_key_required.unwrap_or_default(),
                authorization_scopes: self.authorization_scopes,
                authorization_type: self.authorization_type,
                authorizer_id: self.authorizer_id,
                model_selection_expression: self.model_selection_expression,
                operation_name: self.operation_name,
                request_models: self.request_models,
                request_parameters: self.request_parameters,
                route_id: self.route_id,
                route_key: self.route_key,
                route_response_selection_expression: self.route_response_selection_expression,
                target: self.target,
            }
        }
    }
}
impl UpdateRouteOutput {
    /// Creates a new builder-style object to manufacture [`UpdateRouteOutput`](crate::output::UpdateRouteOutput)
    pub fn builder() -> crate::output::update_route_output::Builder {
        crate::output::update_route_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateModelOutput {
    /// <p>The content-type for the model, for example, "application/json".</p>
    pub content_type: std::option::Option<std::string::String>,
    /// <p>The description of the model.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The model identifier.</p>
    pub model_id: std::option::Option<std::string::String>,
    /// <p>The name of the model. Must be alphanumeric.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The schema for the model. For application/json models, this should be JSON schema draft 4 model.</p>
    pub schema: std::option::Option<std::string::String>,
}
impl UpdateModelOutput {
    /// <p>The content-type for the model, for example, "application/json".</p>
    pub fn content_type(&self) -> std::option::Option<&str> {
        self.content_type.as_deref()
    }
    /// <p>The description of the model.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The model identifier.</p>
    pub fn model_id(&self) -> std::option::Option<&str> {
        self.model_id.as_deref()
    }
    /// <p>The name of the model. Must be alphanumeric.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The schema for the model. For application/json models, this should be JSON schema draft 4 model.</p>
    pub fn schema(&self) -> std::option::Option<&str> {
        self.schema.as_deref()
    }
}
impl std::fmt::Debug for UpdateModelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateModelOutput");
        formatter.field("content_type", &self.content_type);
        formatter.field("description", &self.description);
        formatter.field("model_id", &self.model_id);
        formatter.field("name", &self.name);
        formatter.field("schema", &self.schema);
        formatter.finish()
    }
}
/// See [`UpdateModelOutput`](crate::output::UpdateModelOutput)
pub mod update_model_output {
    /// A builder for [`UpdateModelOutput`](crate::output::UpdateModelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) content_type: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) model_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) schema: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The content-type for the model, for example, "application/json".</p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_type = Some(input.into());
            self
        }
        /// <p>The content-type for the model, for example, "application/json".</p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_type = input;
            self
        }
        /// <p>The description of the model.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the model.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The model identifier.</p>
        pub fn model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_id = Some(input.into());
            self
        }
        /// <p>The model identifier.</p>
        pub fn set_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.model_id = input;
            self
        }
        /// <p>The name of the model. Must be alphanumeric.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the model. Must be alphanumeric.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The schema for the model. For application/json models, this should be JSON schema draft 4 model.</p>
        pub fn schema(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema = Some(input.into());
            self
        }
        /// <p>The schema for the model. For application/json models, this should be JSON schema draft 4 model.</p>
        pub fn set_schema(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateModelOutput`](crate::output::UpdateModelOutput)
        pub fn build(self) -> crate::output::UpdateModelOutput {
            crate::output::UpdateModelOutput {
                content_type: self.content_type,
                description: self.description,
                model_id: self.model_id,
                name: self.name,
                schema: self.schema,
            }
        }
    }
}
impl UpdateModelOutput {
    /// Creates a new builder-style object to manufacture [`UpdateModelOutput`](crate::output::UpdateModelOutput)
    pub fn builder() -> crate::output::update_model_output::Builder {
        crate::output::update_model_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateIntegrationResponseOutput {
    /// <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p> <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p> <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p> <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
    pub content_handling_strategy: std::option::Option<crate::model::ContentHandlingStrategy>,
    /// <p>The integration response ID.</p>
    pub integration_response_id: std::option::Option<std::string::String>,
    /// <p>The integration response key.</p>
    pub integration_response_key: std::option::Option<std::string::String>,
    /// <p>A key-value map specifying response parameters that are passed to the method response from the backend. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of method.response.header.{name}, where name is a valid and unique header name. The mapped non-static value must match the pattern of integration.response.header.{name} or integration.response.body.{JSON-expression}, where name is a valid and unique response header name and JSON-expression is a valid JSON expression without the $ prefix.</p>
    pub response_parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The collection of response templates for the integration response as a string-to-string map of key-value pairs. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.</p>
    pub response_templates:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The template selection expressions for the integration response.</p>
    pub template_selection_expression: std::option::Option<std::string::String>,
}
impl UpdateIntegrationResponseOutput {
    /// <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p> <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p> <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p> <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
    pub fn content_handling_strategy(
        &self,
    ) -> std::option::Option<&crate::model::ContentHandlingStrategy> {
        self.content_handling_strategy.as_ref()
    }
    /// <p>The integration response ID.</p>
    pub fn integration_response_id(&self) -> std::option::Option<&str> {
        self.integration_response_id.as_deref()
    }
    /// <p>The integration response key.</p>
    pub fn integration_response_key(&self) -> std::option::Option<&str> {
        self.integration_response_key.as_deref()
    }
    /// <p>A key-value map specifying response parameters that are passed to the method response from the backend. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of method.response.header.{name}, where name is a valid and unique header name. The mapped non-static value must match the pattern of integration.response.header.{name} or integration.response.body.{JSON-expression}, where name is a valid and unique response header name and JSON-expression is a valid JSON expression without the $ prefix.</p>
    pub fn response_parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.response_parameters.as_ref()
    }
    /// <p>The collection of response templates for the integration response as a string-to-string map of key-value pairs. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.</p>
    pub fn response_templates(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.response_templates.as_ref()
    }
    /// <p>The template selection expressions for the integration response.</p>
    pub fn template_selection_expression(&self) -> std::option::Option<&str> {
        self.template_selection_expression.as_deref()
    }
}
impl std::fmt::Debug for UpdateIntegrationResponseOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateIntegrationResponseOutput");
        formatter.field("content_handling_strategy", &self.content_handling_strategy);
        formatter.field("integration_response_id", &self.integration_response_id);
        formatter.field("integration_response_key", &self.integration_response_key);
        formatter.field("response_parameters", &self.response_parameters);
        formatter.field("response_templates", &self.response_templates);
        formatter.field(
            "template_selection_expression",
            &self.template_selection_expression,
        );
        formatter.finish()
    }
}
/// See [`UpdateIntegrationResponseOutput`](crate::output::UpdateIntegrationResponseOutput)
pub mod update_integration_response_output {
    /// A builder for [`UpdateIntegrationResponseOutput`](crate::output::UpdateIntegrationResponseOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) content_handling_strategy:
            std::option::Option<crate::model::ContentHandlingStrategy>,
        pub(crate) integration_response_id: std::option::Option<std::string::String>,
        pub(crate) integration_response_key: std::option::Option<std::string::String>,
        pub(crate) response_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) response_templates: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) template_selection_expression: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p> <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p> <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p> <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
        pub fn content_handling_strategy(
            mut self,
            input: crate::model::ContentHandlingStrategy,
        ) -> Self {
            self.content_handling_strategy = Some(input);
            self
        }
        /// <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p> <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p> <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p> <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
        pub fn set_content_handling_strategy(
            mut self,
            input: std::option::Option<crate::model::ContentHandlingStrategy>,
        ) -> Self {
            self.content_handling_strategy = input;
            self
        }
        /// <p>The integration response ID.</p>
        pub fn integration_response_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.integration_response_id = Some(input.into());
            self
        }
        /// <p>The integration response ID.</p>
        pub fn set_integration_response_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.integration_response_id = input;
            self
        }
        /// <p>The integration response key.</p>
        pub fn integration_response_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.integration_response_key = Some(input.into());
            self
        }
        /// <p>The integration response key.</p>
        pub fn set_integration_response_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.integration_response_key = input;
            self
        }
        /// Adds a key-value pair to `response_parameters`.
        ///
        /// To override the contents of this collection use [`set_response_parameters`](Self::set_response_parameters).
        ///
        /// <p>A key-value map specifying response parameters that are passed to the method response from the backend. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of method.response.header.{name}, where name is a valid and unique header name. The mapped non-static value must match the pattern of integration.response.header.{name} or integration.response.body.{JSON-expression}, where name is a valid and unique response header name and JSON-expression is a valid JSON expression without the $ prefix.</p>
        pub fn response_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.response_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.response_parameters = Some(hash_map);
            self
        }
        /// <p>A key-value map specifying response parameters that are passed to the method response from the backend. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of method.response.header.{name}, where name is a valid and unique header name. The mapped non-static value must match the pattern of integration.response.header.{name} or integration.response.body.{JSON-expression}, where name is a valid and unique response header name and JSON-expression is a valid JSON expression without the $ prefix.</p>
        pub fn set_response_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.response_parameters = input;
            self
        }
        /// Adds a key-value pair to `response_templates`.
        ///
        /// To override the contents of this collection use [`set_response_templates`](Self::set_response_templates).
        ///
        /// <p>The collection of response templates for the integration response as a string-to-string map of key-value pairs. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.</p>
        pub fn response_templates(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.response_templates.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.response_templates = Some(hash_map);
            self
        }
        /// <p>The collection of response templates for the integration response as a string-to-string map of key-value pairs. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.</p>
        pub fn set_response_templates(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.response_templates = input;
            self
        }
        /// <p>The template selection expressions for the integration response.</p>
        pub fn template_selection_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.template_selection_expression = Some(input.into());
            self
        }
        /// <p>The template selection expressions for the integration response.</p>
        pub fn set_template_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_selection_expression = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateIntegrationResponseOutput`](crate::output::UpdateIntegrationResponseOutput)
        pub fn build(self) -> crate::output::UpdateIntegrationResponseOutput {
            crate::output::UpdateIntegrationResponseOutput {
                content_handling_strategy: self.content_handling_strategy,
                integration_response_id: self.integration_response_id,
                integration_response_key: self.integration_response_key,
                response_parameters: self.response_parameters,
                response_templates: self.response_templates,
                template_selection_expression: self.template_selection_expression,
            }
        }
    }
}
impl UpdateIntegrationResponseOutput {
    /// Creates a new builder-style object to manufacture [`UpdateIntegrationResponseOutput`](crate::output::UpdateIntegrationResponseOutput)
    pub fn builder() -> crate::output::update_integration_response_output::Builder {
        crate::output::update_integration_response_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateIntegrationOutput {
    /// <p>Specifies whether an integration is managed by API Gateway. If you created an API using using quick create, the resulting integration is managed by API Gateway. You can update a managed integration, but you can't delete it.</p>
    pub api_gateway_managed: bool,
    /// <p>The ID of the VPC link for a private integration. Supported only for HTTP APIs.</p>
    pub connection_id: std::option::Option<std::string::String>,
    /// <p>The type of the network connection to the integration endpoint. Specify INTERNET for connections through the public routable internet or VPC_LINK for private connections between API Gateway and resources in a VPC. The default value is INTERNET.</p>
    pub connection_type: std::option::Option<crate::model::ConnectionType>,
    /// <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p> <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p> <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p> <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
    pub content_handling_strategy: std::option::Option<crate::model::ContentHandlingStrategy>,
    /// <p>Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, specify null.</p>
    pub credentials_arn: std::option::Option<std::string::String>,
    /// <p>Represents the description of an integration.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Represents the identifier of an integration.</p>
    pub integration_id: std::option::Option<std::string::String>,
    /// <p>Specifies the integration's HTTP method type.</p>
    pub integration_method: std::option::Option<std::string::String>,
    /// <p>The integration response selection expression for the integration. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-integration-response-selection-expressions">Integration Response Selection Expressions</a>.</p>
    pub integration_response_selection_expression: std::option::Option<std::string::String>,
    /// <p>Supported only for HTTP API AWS_PROXY integrations. Specifies the AWS service action to invoke. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html">Integration subtype reference</a>.</p>
    pub integration_subtype: std::option::Option<std::string::String>,
    /// <p>The integration type of an integration. One of the following:</p> <p>AWS: for integrating the route or method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration. Supported only for WebSocket APIs.</p> <p>AWS_PROXY: for integrating the route or method request with a Lambda function or other AWS service action. This integration is also referred to as a Lambda proxy integration.</p> <p>HTTP: for integrating the route or method request with an HTTP endpoint. This integration is also referred to as the HTTP custom integration. Supported only for WebSocket APIs.</p> <p>HTTP_PROXY: for integrating the route or method request with an HTTP endpoint, with the client request passed through as-is. This is also referred to as HTTP proxy integration.</p> <p>MOCK: for integrating the route or method request with API Gateway as a "loopback" endpoint without invoking any backend. Supported only for WebSocket APIs.</p>
    pub integration_type: std::option::Option<crate::model::IntegrationType>,
    /// <p>For a Lambda integration, specify the URI of a Lambda function.</p> <p>For an HTTP integration, specify a fully-qualified URL.</p> <p>For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service. If you specify the ARN of an AWS Cloud Map service, API Gateway uses DiscoverInstances to identify resources. You can use query parameters to target specific resources. To learn more, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_DiscoverInstances.html">DiscoverInstances</a>. For private integrations, all resources must be owned by the same AWS account.</p>
    pub integration_uri: std::option::Option<std::string::String>,
    /// <p>Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER. Supported only for WebSocket APIs.</p> <p>WHEN_NO_MATCH passes the request body for unmapped content types through to the integration backend without transformation.</p> <p>NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type response.</p> <p>WHEN_NO_TEMPLATES allows pass-through when the integration has no content types mapped to templates. However, if there is at least one content type defined, unmapped content types will be rejected with the same HTTP 415 Unsupported Media Type response.</p>
    pub passthrough_behavior: std::option::Option<crate::model::PassthroughBehavior>,
    /// <p>Specifies the format of the payload sent to an integration. Required for HTTP APIs.</p>
    pub payload_format_version: std::option::Option<std::string::String>,
    /// <p>For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the backend. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the backend. The method request parameter value must match the pattern of method.request.<replaceable>{location}</replaceable>.<replaceable>{name}</replaceable>
    /// , where
    /// <replaceable>{location}</replaceable>
    /// is querystring, path, or header; and
    /// <replaceable>{name}</replaceable>
    /// must be a valid and unique method request parameter name.</p> <p>For HTTP API integrations with a specified integrationSubtype, request parameters are a key-value map specifying parameters that are passed to AWS_PROXY integrations. You can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services.html">Working with AWS service integrations for HTTP APIs</a>.</p> <p>For HTTP API itegrations, without a specified integrationSubtype request parameters are a key-value map specifying how to transform HTTP requests before sending them to backend integrations. The key should follow the pattern &lt;action&gt;:&lt;header|querystring|path&gt;.&lt;location&gt;. The action can be append, overwrite or remove. For values, you can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
    pub request_parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value. Supported only for WebSocket APIs.</p>
    pub request_templates:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Supported only for HTTP APIs. You use response parameters to transform the HTTP response from a backend integration before returning the response to clients. Specify a key-value map from a selection key to response parameters. The selection key must be a valid HTTP status code within the range of 200-599. Response parameters are a key-value map. The key must match pattern &lt;action&gt;:&lt;header&gt;.&lt;location&gt; or overwrite.statuscode. The action can be append, overwrite or remove. The value can be a static value, or map to response data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
    pub response_parameters: std::option::Option<
        std::collections::HashMap<
            std::string::String,
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    >,
    /// <p>The template selection expression for the integration. Supported only for WebSocket APIs.</p>
    pub template_selection_expression: std::option::Option<std::string::String>,
    /// <p>Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs. The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.</p>
    pub timeout_in_millis: i32,
    /// <p>The TLS configuration for a private integration. If you specify a TLS configuration, private integration traffic uses the HTTPS protocol. Supported only for HTTP APIs.</p>
    pub tls_config: std::option::Option<crate::model::TlsConfig>,
}
impl UpdateIntegrationOutput {
    /// <p>Specifies whether an integration is managed by API Gateway. If you created an API using using quick create, the resulting integration is managed by API Gateway. You can update a managed integration, but you can't delete it.</p>
    pub fn api_gateway_managed(&self) -> bool {
        self.api_gateway_managed
    }
    /// <p>The ID of the VPC link for a private integration. Supported only for HTTP APIs.</p>
    pub fn connection_id(&self) -> std::option::Option<&str> {
        self.connection_id.as_deref()
    }
    /// <p>The type of the network connection to the integration endpoint. Specify INTERNET for connections through the public routable internet or VPC_LINK for private connections between API Gateway and resources in a VPC. The default value is INTERNET.</p>
    pub fn connection_type(&self) -> std::option::Option<&crate::model::ConnectionType> {
        self.connection_type.as_ref()
    }
    /// <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p> <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p> <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p> <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
    pub fn content_handling_strategy(
        &self,
    ) -> std::option::Option<&crate::model::ContentHandlingStrategy> {
        self.content_handling_strategy.as_ref()
    }
    /// <p>Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, specify null.</p>
    pub fn credentials_arn(&self) -> std::option::Option<&str> {
        self.credentials_arn.as_deref()
    }
    /// <p>Represents the description of an integration.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Represents the identifier of an integration.</p>
    pub fn integration_id(&self) -> std::option::Option<&str> {
        self.integration_id.as_deref()
    }
    /// <p>Specifies the integration's HTTP method type.</p>
    pub fn integration_method(&self) -> std::option::Option<&str> {
        self.integration_method.as_deref()
    }
    /// <p>The integration response selection expression for the integration. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-integration-response-selection-expressions">Integration Response Selection Expressions</a>.</p>
    pub fn integration_response_selection_expression(&self) -> std::option::Option<&str> {
        self.integration_response_selection_expression.as_deref()
    }
    /// <p>Supported only for HTTP API AWS_PROXY integrations. Specifies the AWS service action to invoke. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html">Integration subtype reference</a>.</p>
    pub fn integration_subtype(&self) -> std::option::Option<&str> {
        self.integration_subtype.as_deref()
    }
    /// <p>The integration type of an integration. One of the following:</p> <p>AWS: for integrating the route or method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration. Supported only for WebSocket APIs.</p> <p>AWS_PROXY: for integrating the route or method request with a Lambda function or other AWS service action. This integration is also referred to as a Lambda proxy integration.</p> <p>HTTP: for integrating the route or method request with an HTTP endpoint. This integration is also referred to as the HTTP custom integration. Supported only for WebSocket APIs.</p> <p>HTTP_PROXY: for integrating the route or method request with an HTTP endpoint, with the client request passed through as-is. This is also referred to as HTTP proxy integration.</p> <p>MOCK: for integrating the route or method request with API Gateway as a "loopback" endpoint without invoking any backend. Supported only for WebSocket APIs.</p>
    pub fn integration_type(&self) -> std::option::Option<&crate::model::IntegrationType> {
        self.integration_type.as_ref()
    }
    /// <p>For a Lambda integration, specify the URI of a Lambda function.</p> <p>For an HTTP integration, specify a fully-qualified URL.</p> <p>For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service. If you specify the ARN of an AWS Cloud Map service, API Gateway uses DiscoverInstances to identify resources. You can use query parameters to target specific resources. To learn more, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_DiscoverInstances.html">DiscoverInstances</a>. For private integrations, all resources must be owned by the same AWS account.</p>
    pub fn integration_uri(&self) -> std::option::Option<&str> {
        self.integration_uri.as_deref()
    }
    /// <p>Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER. Supported only for WebSocket APIs.</p> <p>WHEN_NO_MATCH passes the request body for unmapped content types through to the integration backend without transformation.</p> <p>NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type response.</p> <p>WHEN_NO_TEMPLATES allows pass-through when the integration has no content types mapped to templates. However, if there is at least one content type defined, unmapped content types will be rejected with the same HTTP 415 Unsupported Media Type response.</p>
    pub fn passthrough_behavior(&self) -> std::option::Option<&crate::model::PassthroughBehavior> {
        self.passthrough_behavior.as_ref()
    }
    /// <p>Specifies the format of the payload sent to an integration. Required for HTTP APIs.</p>
    pub fn payload_format_version(&self) -> std::option::Option<&str> {
        self.payload_format_version.as_deref()
    }
    /// <p>For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the backend. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the backend. The method request parameter value must match the pattern of method.request.<replaceable>{location}</replaceable>.<replaceable>{name}</replaceable>
    /// , where
    /// <replaceable>{location}</replaceable>
    /// is querystring, path, or header; and
    /// <replaceable>{name}</replaceable>
    /// must be a valid and unique method request parameter name.</p> <p>For HTTP API integrations with a specified integrationSubtype, request parameters are a key-value map specifying parameters that are passed to AWS_PROXY integrations. You can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services.html">Working with AWS service integrations for HTTP APIs</a>.</p> <p>For HTTP API itegrations, without a specified integrationSubtype request parameters are a key-value map specifying how to transform HTTP requests before sending them to backend integrations. The key should follow the pattern &lt;action&gt;:&lt;header|querystring|path&gt;.&lt;location&gt;. The action can be append, overwrite or remove. For values, you can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
    pub fn request_parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.request_parameters.as_ref()
    }
    /// <p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value. Supported only for WebSocket APIs.</p>
    pub fn request_templates(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.request_templates.as_ref()
    }
    /// <p>Supported only for HTTP APIs. You use response parameters to transform the HTTP response from a backend integration before returning the response to clients. Specify a key-value map from a selection key to response parameters. The selection key must be a valid HTTP status code within the range of 200-599. Response parameters are a key-value map. The key must match pattern &lt;action&gt;:&lt;header&gt;.&lt;location&gt; or overwrite.statuscode. The action can be append, overwrite or remove. The value can be a static value, or map to response data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
    pub fn response_parameters(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<
            std::string::String,
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    > {
        self.response_parameters.as_ref()
    }
    /// <p>The template selection expression for the integration. Supported only for WebSocket APIs.</p>
    pub fn template_selection_expression(&self) -> std::option::Option<&str> {
        self.template_selection_expression.as_deref()
    }
    /// <p>Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs. The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.</p>
    pub fn timeout_in_millis(&self) -> i32 {
        self.timeout_in_millis
    }
    /// <p>The TLS configuration for a private integration. If you specify a TLS configuration, private integration traffic uses the HTTPS protocol. Supported only for HTTP APIs.</p>
    pub fn tls_config(&self) -> std::option::Option<&crate::model::TlsConfig> {
        self.tls_config.as_ref()
    }
}
impl std::fmt::Debug for UpdateIntegrationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateIntegrationOutput");
        formatter.field("api_gateway_managed", &self.api_gateway_managed);
        formatter.field("connection_id", &self.connection_id);
        formatter.field("connection_type", &self.connection_type);
        formatter.field("content_handling_strategy", &self.content_handling_strategy);
        formatter.field("credentials_arn", &self.credentials_arn);
        formatter.field("description", &self.description);
        formatter.field("integration_id", &self.integration_id);
        formatter.field("integration_method", &self.integration_method);
        formatter.field(
            "integration_response_selection_expression",
            &self.integration_response_selection_expression,
        );
        formatter.field("integration_subtype", &self.integration_subtype);
        formatter.field("integration_type", &self.integration_type);
        formatter.field("integration_uri", &self.integration_uri);
        formatter.field("passthrough_behavior", &self.passthrough_behavior);
        formatter.field("payload_format_version", &self.payload_format_version);
        formatter.field("request_parameters", &self.request_parameters);
        formatter.field("request_templates", &self.request_templates);
        formatter.field("response_parameters", &self.response_parameters);
        formatter.field(
            "template_selection_expression",
            &self.template_selection_expression,
        );
        formatter.field("timeout_in_millis", &self.timeout_in_millis);
        formatter.field("tls_config", &self.tls_config);
        formatter.finish()
    }
}
/// See [`UpdateIntegrationOutput`](crate::output::UpdateIntegrationOutput)
pub mod update_integration_output {
    /// A builder for [`UpdateIntegrationOutput`](crate::output::UpdateIntegrationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_gateway_managed: std::option::Option<bool>,
        pub(crate) connection_id: std::option::Option<std::string::String>,
        pub(crate) connection_type: std::option::Option<crate::model::ConnectionType>,
        pub(crate) content_handling_strategy:
            std::option::Option<crate::model::ContentHandlingStrategy>,
        pub(crate) credentials_arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) integration_id: std::option::Option<std::string::String>,
        pub(crate) integration_method: std::option::Option<std::string::String>,
        pub(crate) integration_response_selection_expression:
            std::option::Option<std::string::String>,
        pub(crate) integration_subtype: std::option::Option<std::string::String>,
        pub(crate) integration_type: std::option::Option<crate::model::IntegrationType>,
        pub(crate) integration_uri: std::option::Option<std::string::String>,
        pub(crate) passthrough_behavior: std::option::Option<crate::model::PassthroughBehavior>,
        pub(crate) payload_format_version: std::option::Option<std::string::String>,
        pub(crate) request_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) request_templates: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) response_parameters: std::option::Option<
            std::collections::HashMap<
                std::string::String,
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        >,
        pub(crate) template_selection_expression: std::option::Option<std::string::String>,
        pub(crate) timeout_in_millis: std::option::Option<i32>,
        pub(crate) tls_config: std::option::Option<crate::model::TlsConfig>,
    }
    impl Builder {
        /// <p>Specifies whether an integration is managed by API Gateway. If you created an API using using quick create, the resulting integration is managed by API Gateway. You can update a managed integration, but you can't delete it.</p>
        pub fn api_gateway_managed(mut self, input: bool) -> Self {
            self.api_gateway_managed = Some(input);
            self
        }
        /// <p>Specifies whether an integration is managed by API Gateway. If you created an API using using quick create, the resulting integration is managed by API Gateway. You can update a managed integration, but you can't delete it.</p>
        pub fn set_api_gateway_managed(mut self, input: std::option::Option<bool>) -> Self {
            self.api_gateway_managed = input;
            self
        }
        /// <p>The ID of the VPC link for a private integration. Supported only for HTTP APIs.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_id = Some(input.into());
            self
        }
        /// <p>The ID of the VPC link for a private integration. Supported only for HTTP APIs.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_id = input;
            self
        }
        /// <p>The type of the network connection to the integration endpoint. Specify INTERNET for connections through the public routable internet or VPC_LINK for private connections between API Gateway and resources in a VPC. The default value is INTERNET.</p>
        pub fn connection_type(mut self, input: crate::model::ConnectionType) -> Self {
            self.connection_type = Some(input);
            self
        }
        /// <p>The type of the network connection to the integration endpoint. Specify INTERNET for connections through the public routable internet or VPC_LINK for private connections between API Gateway and resources in a VPC. The default value is INTERNET.</p>
        pub fn set_connection_type(
            mut self,
            input: std::option::Option<crate::model::ConnectionType>,
        ) -> Self {
            self.connection_type = input;
            self
        }
        /// <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p> <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p> <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p> <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
        pub fn content_handling_strategy(
            mut self,
            input: crate::model::ContentHandlingStrategy,
        ) -> Self {
            self.content_handling_strategy = Some(input);
            self
        }
        /// <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p> <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p> <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p> <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
        pub fn set_content_handling_strategy(
            mut self,
            input: std::option::Option<crate::model::ContentHandlingStrategy>,
        ) -> Self {
            self.content_handling_strategy = input;
            self
        }
        /// <p>Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, specify null.</p>
        pub fn credentials_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.credentials_arn = Some(input.into());
            self
        }
        /// <p>Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, specify null.</p>
        pub fn set_credentials_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.credentials_arn = input;
            self
        }
        /// <p>Represents the description of an integration.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Represents the description of an integration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Represents the identifier of an integration.</p>
        pub fn integration_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.integration_id = Some(input.into());
            self
        }
        /// <p>Represents the identifier of an integration.</p>
        pub fn set_integration_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.integration_id = input;
            self
        }
        /// <p>Specifies the integration's HTTP method type.</p>
        pub fn integration_method(mut self, input: impl Into<std::string::String>) -> Self {
            self.integration_method = Some(input.into());
            self
        }
        /// <p>Specifies the integration's HTTP method type.</p>
        pub fn set_integration_method(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.integration_method = input;
            self
        }
        /// <p>The integration response selection expression for the integration. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-integration-response-selection-expressions">Integration Response Selection Expressions</a>.</p>
        pub fn integration_response_selection_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.integration_response_selection_expression = Some(input.into());
            self
        }
        /// <p>The integration response selection expression for the integration. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-integration-response-selection-expressions">Integration Response Selection Expressions</a>.</p>
        pub fn set_integration_response_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.integration_response_selection_expression = input;
            self
        }
        /// <p>Supported only for HTTP API AWS_PROXY integrations. Specifies the AWS service action to invoke. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html">Integration subtype reference</a>.</p>
        pub fn integration_subtype(mut self, input: impl Into<std::string::String>) -> Self {
            self.integration_subtype = Some(input.into());
            self
        }
        /// <p>Supported only for HTTP API AWS_PROXY integrations. Specifies the AWS service action to invoke. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html">Integration subtype reference</a>.</p>
        pub fn set_integration_subtype(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.integration_subtype = input;
            self
        }
        /// <p>The integration type of an integration. One of the following:</p> <p>AWS: for integrating the route or method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration. Supported only for WebSocket APIs.</p> <p>AWS_PROXY: for integrating the route or method request with a Lambda function or other AWS service action. This integration is also referred to as a Lambda proxy integration.</p> <p>HTTP: for integrating the route or method request with an HTTP endpoint. This integration is also referred to as the HTTP custom integration. Supported only for WebSocket APIs.</p> <p>HTTP_PROXY: for integrating the route or method request with an HTTP endpoint, with the client request passed through as-is. This is also referred to as HTTP proxy integration.</p> <p>MOCK: for integrating the route or method request with API Gateway as a "loopback" endpoint without invoking any backend. Supported only for WebSocket APIs.</p>
        pub fn integration_type(mut self, input: crate::model::IntegrationType) -> Self {
            self.integration_type = Some(input);
            self
        }
        /// <p>The integration type of an integration. One of the following:</p> <p>AWS: for integrating the route or method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration. Supported only for WebSocket APIs.</p> <p>AWS_PROXY: for integrating the route or method request with a Lambda function or other AWS service action. This integration is also referred to as a Lambda proxy integration.</p> <p>HTTP: for integrating the route or method request with an HTTP endpoint. This integration is also referred to as the HTTP custom integration. Supported only for WebSocket APIs.</p> <p>HTTP_PROXY: for integrating the route or method request with an HTTP endpoint, with the client request passed through as-is. This is also referred to as HTTP proxy integration.</p> <p>MOCK: for integrating the route or method request with API Gateway as a "loopback" endpoint without invoking any backend. Supported only for WebSocket APIs.</p>
        pub fn set_integration_type(
            mut self,
            input: std::option::Option<crate::model::IntegrationType>,
        ) -> Self {
            self.integration_type = input;
            self
        }
        /// <p>For a Lambda integration, specify the URI of a Lambda function.</p> <p>For an HTTP integration, specify a fully-qualified URL.</p> <p>For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service. If you specify the ARN of an AWS Cloud Map service, API Gateway uses DiscoverInstances to identify resources. You can use query parameters to target specific resources. To learn more, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_DiscoverInstances.html">DiscoverInstances</a>. For private integrations, all resources must be owned by the same AWS account.</p>
        pub fn integration_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.integration_uri = Some(input.into());
            self
        }
        /// <p>For a Lambda integration, specify the URI of a Lambda function.</p> <p>For an HTTP integration, specify a fully-qualified URL.</p> <p>For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service. If you specify the ARN of an AWS Cloud Map service, API Gateway uses DiscoverInstances to identify resources. You can use query parameters to target specific resources. To learn more, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_DiscoverInstances.html">DiscoverInstances</a>. For private integrations, all resources must be owned by the same AWS account.</p>
        pub fn set_integration_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.integration_uri = input;
            self
        }
        /// <p>Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER. Supported only for WebSocket APIs.</p> <p>WHEN_NO_MATCH passes the request body for unmapped content types through to the integration backend without transformation.</p> <p>NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type response.</p> <p>WHEN_NO_TEMPLATES allows pass-through when the integration has no content types mapped to templates. However, if there is at least one content type defined, unmapped content types will be rejected with the same HTTP 415 Unsupported Media Type response.</p>
        pub fn passthrough_behavior(mut self, input: crate::model::PassthroughBehavior) -> Self {
            self.passthrough_behavior = Some(input);
            self
        }
        /// <p>Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER. Supported only for WebSocket APIs.</p> <p>WHEN_NO_MATCH passes the request body for unmapped content types through to the integration backend without transformation.</p> <p>NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type response.</p> <p>WHEN_NO_TEMPLATES allows pass-through when the integration has no content types mapped to templates. However, if there is at least one content type defined, unmapped content types will be rejected with the same HTTP 415 Unsupported Media Type response.</p>
        pub fn set_passthrough_behavior(
            mut self,
            input: std::option::Option<crate::model::PassthroughBehavior>,
        ) -> Self {
            self.passthrough_behavior = input;
            self
        }
        /// <p>Specifies the format of the payload sent to an integration. Required for HTTP APIs.</p>
        pub fn payload_format_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.payload_format_version = Some(input.into());
            self
        }
        /// <p>Specifies the format of the payload sent to an integration. Required for HTTP APIs.</p>
        pub fn set_payload_format_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.payload_format_version = input;
            self
        }
        /// Adds a key-value pair to `request_parameters`.
        ///
        /// To override the contents of this collection use [`set_request_parameters`](Self::set_request_parameters).
        ///
        /// <p>For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the backend. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the backend. The method request parameter value must match the pattern of method.request.<replaceable>{location}</replaceable>.<replaceable>{name}</replaceable>
        /// , where
        /// <replaceable>{location}</replaceable>
        /// is querystring, path, or header; and
        /// <replaceable>{name}</replaceable>
        /// must be a valid and unique method request parameter name.</p> <p>For HTTP API integrations with a specified integrationSubtype, request parameters are a key-value map specifying parameters that are passed to AWS_PROXY integrations. You can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services.html">Working with AWS service integrations for HTTP APIs</a>.</p> <p>For HTTP API itegrations, without a specified integrationSubtype request parameters are a key-value map specifying how to transform HTTP requests before sending them to backend integrations. The key should follow the pattern &lt;action&gt;:&lt;header|querystring|path&gt;.&lt;location&gt;. The action can be append, overwrite or remove. For values, you can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
        pub fn request_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.request_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.request_parameters = Some(hash_map);
            self
        }
        /// <p>For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the backend. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the backend. The method request parameter value must match the pattern of method.request.<replaceable>{location}</replaceable>.<replaceable>{name}</replaceable>
        /// , where
        /// <replaceable>{location}</replaceable>
        /// is querystring, path, or header; and
        /// <replaceable>{name}</replaceable>
        /// must be a valid and unique method request parameter name.</p> <p>For HTTP API integrations with a specified integrationSubtype, request parameters are a key-value map specifying parameters that are passed to AWS_PROXY integrations. You can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services.html">Working with AWS service integrations for HTTP APIs</a>.</p> <p>For HTTP API itegrations, without a specified integrationSubtype request parameters are a key-value map specifying how to transform HTTP requests before sending them to backend integrations. The key should follow the pattern &lt;action&gt;:&lt;header|querystring|path&gt;.&lt;location&gt;. The action can be append, overwrite or remove. For values, you can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
        pub fn set_request_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.request_parameters = input;
            self
        }
        /// Adds a key-value pair to `request_templates`.
        ///
        /// To override the contents of this collection use [`set_request_templates`](Self::set_request_templates).
        ///
        /// <p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value. Supported only for WebSocket APIs.</p>
        pub fn request_templates(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.request_templates.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.request_templates = Some(hash_map);
            self
        }
        /// <p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value. Supported only for WebSocket APIs.</p>
        pub fn set_request_templates(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.request_templates = input;
            self
        }
        /// Adds a key-value pair to `response_parameters`.
        ///
        /// To override the contents of this collection use [`set_response_parameters`](Self::set_response_parameters).
        ///
        /// <p>Supported only for HTTP APIs. You use response parameters to transform the HTTP response from a backend integration before returning the response to clients. Specify a key-value map from a selection key to response parameters. The selection key must be a valid HTTP status code within the range of 200-599. Response parameters are a key-value map. The key must match pattern &lt;action&gt;:&lt;header&gt;.&lt;location&gt; or overwrite.statuscode. The action can be append, overwrite or remove. The value can be a static value, or map to response data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
        pub fn response_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::collections::HashMap<std::string::String, std::string::String>>,
        ) -> Self {
            let mut hash_map = self.response_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.response_parameters = Some(hash_map);
            self
        }
        /// <p>Supported only for HTTP APIs. You use response parameters to transform the HTTP response from a backend integration before returning the response to clients. Specify a key-value map from a selection key to response parameters. The selection key must be a valid HTTP status code within the range of 200-599. Response parameters are a key-value map. The key must match pattern &lt;action&gt;:&lt;header&gt;.&lt;location&gt; or overwrite.statuscode. The action can be append, overwrite or remove. The value can be a static value, or map to response data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
        pub fn set_response_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    std::collections::HashMap<std::string::String, std::string::String>,
                >,
            >,
        ) -> Self {
            self.response_parameters = input;
            self
        }
        /// <p>The template selection expression for the integration. Supported only for WebSocket APIs.</p>
        pub fn template_selection_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.template_selection_expression = Some(input.into());
            self
        }
        /// <p>The template selection expression for the integration. Supported only for WebSocket APIs.</p>
        pub fn set_template_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_selection_expression = input;
            self
        }
        /// <p>Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs. The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.</p>
        pub fn timeout_in_millis(mut self, input: i32) -> Self {
            self.timeout_in_millis = Some(input);
            self
        }
        /// <p>Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs. The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.</p>
        pub fn set_timeout_in_millis(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout_in_millis = input;
            self
        }
        /// <p>The TLS configuration for a private integration. If you specify a TLS configuration, private integration traffic uses the HTTPS protocol. Supported only for HTTP APIs.</p>
        pub fn tls_config(mut self, input: crate::model::TlsConfig) -> Self {
            self.tls_config = Some(input);
            self
        }
        /// <p>The TLS configuration for a private integration. If you specify a TLS configuration, private integration traffic uses the HTTPS protocol. Supported only for HTTP APIs.</p>
        pub fn set_tls_config(
            mut self,
            input: std::option::Option<crate::model::TlsConfig>,
        ) -> Self {
            self.tls_config = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateIntegrationOutput`](crate::output::UpdateIntegrationOutput)
        pub fn build(self) -> crate::output::UpdateIntegrationOutput {
            crate::output::UpdateIntegrationOutput {
                api_gateway_managed: self.api_gateway_managed.unwrap_or_default(),
                connection_id: self.connection_id,
                connection_type: self.connection_type,
                content_handling_strategy: self.content_handling_strategy,
                credentials_arn: self.credentials_arn,
                description: self.description,
                integration_id: self.integration_id,
                integration_method: self.integration_method,
                integration_response_selection_expression: self
                    .integration_response_selection_expression,
                integration_subtype: self.integration_subtype,
                integration_type: self.integration_type,
                integration_uri: self.integration_uri,
                passthrough_behavior: self.passthrough_behavior,
                payload_format_version: self.payload_format_version,
                request_parameters: self.request_parameters,
                request_templates: self.request_templates,
                response_parameters: self.response_parameters,
                template_selection_expression: self.template_selection_expression,
                timeout_in_millis: self.timeout_in_millis.unwrap_or_default(),
                tls_config: self.tls_config,
            }
        }
    }
}
impl UpdateIntegrationOutput {
    /// Creates a new builder-style object to manufacture [`UpdateIntegrationOutput`](crate::output::UpdateIntegrationOutput)
    pub fn builder() -> crate::output::update_integration_output::Builder {
        crate::output::update_integration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDomainNameOutput {
    /// <p>The API mapping selection expression.</p>
    pub api_mapping_selection_expression: std::option::Option<std::string::String>,
    /// <p>The name of the DomainName resource.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The domain name configurations.</p>
    pub domain_name_configurations:
        std::option::Option<std::vec::Vec<crate::model::DomainNameConfiguration>>,
    /// <p>The mutual TLS authentication configuration for a custom domain name.</p>
    pub mutual_tls_authentication: std::option::Option<crate::model::MutualTlsAuthentication>,
    /// <p>The collection of tags associated with a domain name.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl UpdateDomainNameOutput {
    /// <p>The API mapping selection expression.</p>
    pub fn api_mapping_selection_expression(&self) -> std::option::Option<&str> {
        self.api_mapping_selection_expression.as_deref()
    }
    /// <p>The name of the DomainName resource.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>The domain name configurations.</p>
    pub fn domain_name_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::DomainNameConfiguration]> {
        self.domain_name_configurations.as_deref()
    }
    /// <p>The mutual TLS authentication configuration for a custom domain name.</p>
    pub fn mutual_tls_authentication(
        &self,
    ) -> std::option::Option<&crate::model::MutualTlsAuthentication> {
        self.mutual_tls_authentication.as_ref()
    }
    /// <p>The collection of tags associated with a domain name.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for UpdateDomainNameOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDomainNameOutput");
        formatter.field(
            "api_mapping_selection_expression",
            &self.api_mapping_selection_expression,
        );
        formatter.field("domain_name", &self.domain_name);
        formatter.field(
            "domain_name_configurations",
            &self.domain_name_configurations,
        );
        formatter.field("mutual_tls_authentication", &self.mutual_tls_authentication);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`UpdateDomainNameOutput`](crate::output::UpdateDomainNameOutput)
pub mod update_domain_name_output {
    /// A builder for [`UpdateDomainNameOutput`](crate::output::UpdateDomainNameOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_mapping_selection_expression: std::option::Option<std::string::String>,
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) domain_name_configurations:
            std::option::Option<std::vec::Vec<crate::model::DomainNameConfiguration>>,
        pub(crate) mutual_tls_authentication:
            std::option::Option<crate::model::MutualTlsAuthentication>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The API mapping selection expression.</p>
        pub fn api_mapping_selection_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.api_mapping_selection_expression = Some(input.into());
            self
        }
        /// <p>The API mapping selection expression.</p>
        pub fn set_api_mapping_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.api_mapping_selection_expression = input;
            self
        }
        /// <p>The name of the DomainName resource.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of the DomainName resource.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Appends an item to `domain_name_configurations`.
        ///
        /// To override the contents of this collection use [`set_domain_name_configurations`](Self::set_domain_name_configurations).
        ///
        /// <p>The domain name configurations.</p>
        pub fn domain_name_configurations(
            mut self,
            input: impl Into<crate::model::DomainNameConfiguration>,
        ) -> Self {
            let mut v = self.domain_name_configurations.unwrap_or_default();
            v.push(input.into());
            self.domain_name_configurations = Some(v);
            self
        }
        /// <p>The domain name configurations.</p>
        pub fn set_domain_name_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DomainNameConfiguration>>,
        ) -> Self {
            self.domain_name_configurations = input;
            self
        }
        /// <p>The mutual TLS authentication configuration for a custom domain name.</p>
        pub fn mutual_tls_authentication(
            mut self,
            input: crate::model::MutualTlsAuthentication,
        ) -> Self {
            self.mutual_tls_authentication = Some(input);
            self
        }
        /// <p>The mutual TLS authentication configuration for a custom domain name.</p>
        pub fn set_mutual_tls_authentication(
            mut self,
            input: std::option::Option<crate::model::MutualTlsAuthentication>,
        ) -> Self {
            self.mutual_tls_authentication = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The collection of tags associated with a domain name.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The collection of tags associated with a domain name.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDomainNameOutput`](crate::output::UpdateDomainNameOutput)
        pub fn build(self) -> crate::output::UpdateDomainNameOutput {
            crate::output::UpdateDomainNameOutput {
                api_mapping_selection_expression: self.api_mapping_selection_expression,
                domain_name: self.domain_name,
                domain_name_configurations: self.domain_name_configurations,
                mutual_tls_authentication: self.mutual_tls_authentication,
                tags: self.tags,
            }
        }
    }
}
impl UpdateDomainNameOutput {
    /// Creates a new builder-style object to manufacture [`UpdateDomainNameOutput`](crate::output::UpdateDomainNameOutput)
    pub fn builder() -> crate::output::update_domain_name_output::Builder {
        crate::output::update_domain_name_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDeploymentOutput {
    /// <p>Specifies whether a deployment was automatically released.</p>
    pub auto_deployed: bool,
    /// <p>The date and time when the Deployment resource was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The identifier for the deployment.</p>
    pub deployment_id: std::option::Option<std::string::String>,
    /// <p>The status of the deployment: PENDING, FAILED, or SUCCEEDED.</p>
    pub deployment_status: std::option::Option<crate::model::DeploymentStatus>,
    /// <p>May contain additional feedback on the status of an API deployment.</p>
    pub deployment_status_message: std::option::Option<std::string::String>,
    /// <p>The description for the deployment.</p>
    pub description: std::option::Option<std::string::String>,
}
impl UpdateDeploymentOutput {
    /// <p>Specifies whether a deployment was automatically released.</p>
    pub fn auto_deployed(&self) -> bool {
        self.auto_deployed
    }
    /// <p>The date and time when the Deployment resource was created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_date.as_ref()
    }
    /// <p>The identifier for the deployment.</p>
    pub fn deployment_id(&self) -> std::option::Option<&str> {
        self.deployment_id.as_deref()
    }
    /// <p>The status of the deployment: PENDING, FAILED, or SUCCEEDED.</p>
    pub fn deployment_status(&self) -> std::option::Option<&crate::model::DeploymentStatus> {
        self.deployment_status.as_ref()
    }
    /// <p>May contain additional feedback on the status of an API deployment.</p>
    pub fn deployment_status_message(&self) -> std::option::Option<&str> {
        self.deployment_status_message.as_deref()
    }
    /// <p>The description for the deployment.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for UpdateDeploymentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDeploymentOutput");
        formatter.field("auto_deployed", &self.auto_deployed);
        formatter.field("created_date", &self.created_date);
        formatter.field("deployment_id", &self.deployment_id);
        formatter.field("deployment_status", &self.deployment_status);
        formatter.field("deployment_status_message", &self.deployment_status_message);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`UpdateDeploymentOutput`](crate::output::UpdateDeploymentOutput)
pub mod update_deployment_output {
    /// A builder for [`UpdateDeploymentOutput`](crate::output::UpdateDeploymentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_deployed: std::option::Option<bool>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) deployment_id: std::option::Option<std::string::String>,
        pub(crate) deployment_status: std::option::Option<crate::model::DeploymentStatus>,
        pub(crate) deployment_status_message: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies whether a deployment was automatically released.</p>
        pub fn auto_deployed(mut self, input: bool) -> Self {
            self.auto_deployed = Some(input);
            self
        }
        /// <p>Specifies whether a deployment was automatically released.</p>
        pub fn set_auto_deployed(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_deployed = input;
            self
        }
        /// <p>The date and time when the Deployment resource was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The date and time when the Deployment resource was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>The identifier for the deployment.</p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_id = Some(input.into());
            self
        }
        /// <p>The identifier for the deployment.</p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_id = input;
            self
        }
        /// <p>The status of the deployment: PENDING, FAILED, or SUCCEEDED.</p>
        pub fn deployment_status(mut self, input: crate::model::DeploymentStatus) -> Self {
            self.deployment_status = Some(input);
            self
        }
        /// <p>The status of the deployment: PENDING, FAILED, or SUCCEEDED.</p>
        pub fn set_deployment_status(
            mut self,
            input: std::option::Option<crate::model::DeploymentStatus>,
        ) -> Self {
            self.deployment_status = input;
            self
        }
        /// <p>May contain additional feedback on the status of an API deployment.</p>
        pub fn deployment_status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_status_message = Some(input.into());
            self
        }
        /// <p>May contain additional feedback on the status of an API deployment.</p>
        pub fn set_deployment_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_status_message = input;
            self
        }
        /// <p>The description for the deployment.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description for the deployment.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDeploymentOutput`](crate::output::UpdateDeploymentOutput)
        pub fn build(self) -> crate::output::UpdateDeploymentOutput {
            crate::output::UpdateDeploymentOutput {
                auto_deployed: self.auto_deployed.unwrap_or_default(),
                created_date: self.created_date,
                deployment_id: self.deployment_id,
                deployment_status: self.deployment_status,
                deployment_status_message: self.deployment_status_message,
                description: self.description,
            }
        }
    }
}
impl UpdateDeploymentOutput {
    /// Creates a new builder-style object to manufacture [`UpdateDeploymentOutput`](crate::output::UpdateDeploymentOutput)
    pub fn builder() -> crate::output::update_deployment_output::Builder {
        crate::output::update_deployment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAuthorizerOutput {
    /// <p>Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, don't specify this parameter. Supported only for REQUEST authorizers.</p>
    pub authorizer_credentials_arn: std::option::Option<std::string::String>,
    /// <p>The authorizer identifier.</p>
    pub authorizer_id: std::option::Option<std::string::String>,
    /// <p>Specifies the format of the payload sent to an HTTP API Lambda authorizer. Required for HTTP API Lambda authorizers. Supported values are 1.0 and 2.0. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p>
    pub authorizer_payload_format_version: std::option::Option<std::string::String>,
    /// <p>The time to live (TTL) for cached authorizer results, in seconds. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway caches authorizer responses. The maximum value is 3600, or 1 hour. Supported only for HTTP API Lambda authorizers.</p>
    pub authorizer_result_ttl_in_seconds: i32,
    /// <p>The authorizer type. Specify REQUEST for a Lambda function using incoming request parameters. Specify JWT to use JSON Web Tokens (supported only for HTTP APIs).</p>
    pub authorizer_type: std::option::Option<crate::model::AuthorizerType>,
    /// <p>The authorizer's Uniform Resource Identifier (URI). For REQUEST authorizers, this must be a well-formed Lambda function URI, for example, arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:<replaceable>{account_id}</replaceable>:function:<replaceable>{lambda_function_name}</replaceable>/invocations. In general, the URI has this form: arn:aws:apigateway:<replaceable>{region}</replaceable>:lambda:path/<replaceable>{service_api}</replaceable>
    /// , where <replaceable></replaceable>{region} is the same as the region hosting the Lambda function, path indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial /. For Lambda functions, this is usually of the form /2015-03-31/functions/[FunctionARN]/invocations. Supported only for REQUEST authorizers.</p>
    pub authorizer_uri: std::option::Option<std::string::String>,
    /// <p>Specifies whether a Lambda authorizer returns a response in a simple format. If enabled, the Lambda authorizer can return a boolean value instead of an IAM policy. Supported only for HTTP APIs. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a></p>
    pub enable_simple_responses: bool,
    /// <p>The identity source for which authorization is requested.</p> <p>For a REQUEST authorizer, this is optional. The value is a set of one or more mapping expressions of the specified request parameters. The identity source can be headers, query string parameters, stage variables, and context parameters. For example, if an Auth header and a Name query string parameter are defined as identity sources, this value is route.request.header.Auth, route.request.querystring.Name for WebSocket APIs. For HTTP APIs, use selection expressions prefixed with $, for example, $request.header.Auth, $request.querystring.Name. These parameters are used to perform runtime validation for Lambda-based authorizers by verifying all of the identity-related request parameters are present in the request, not null, and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function. Otherwise, it returns a 401 Unauthorized response without calling the Lambda function. For HTTP APIs, identity sources are also used as the cache key when caching is enabled. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p> <p>For JWT, a single entry that specifies where to extract the JSON Web Token (JWT) from inbound requests. Currently only header-based and query parameter-based selections are supported, for example $request.header.Authorization.</p>
    pub identity_source: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The validation expression does not apply to the REQUEST authorizer.</p>
    pub identity_validation_expression: std::option::Option<std::string::String>,
    /// <p>Represents the configuration of a JWT authorizer. Required for the JWT authorizer type. Supported only for HTTP APIs.</p>
    pub jwt_configuration: std::option::Option<crate::model::JwtConfiguration>,
    /// <p>The name of the authorizer.</p>
    pub name: std::option::Option<std::string::String>,
}
impl UpdateAuthorizerOutput {
    /// <p>Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, don't specify this parameter. Supported only for REQUEST authorizers.</p>
    pub fn authorizer_credentials_arn(&self) -> std::option::Option<&str> {
        self.authorizer_credentials_arn.as_deref()
    }
    /// <p>The authorizer identifier.</p>
    pub fn authorizer_id(&self) -> std::option::Option<&str> {
        self.authorizer_id.as_deref()
    }
    /// <p>Specifies the format of the payload sent to an HTTP API Lambda authorizer. Required for HTTP API Lambda authorizers. Supported values are 1.0 and 2.0. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p>
    pub fn authorizer_payload_format_version(&self) -> std::option::Option<&str> {
        self.authorizer_payload_format_version.as_deref()
    }
    /// <p>The time to live (TTL) for cached authorizer results, in seconds. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway caches authorizer responses. The maximum value is 3600, or 1 hour. Supported only for HTTP API Lambda authorizers.</p>
    pub fn authorizer_result_ttl_in_seconds(&self) -> i32 {
        self.authorizer_result_ttl_in_seconds
    }
    /// <p>The authorizer type. Specify REQUEST for a Lambda function using incoming request parameters. Specify JWT to use JSON Web Tokens (supported only for HTTP APIs).</p>
    pub fn authorizer_type(&self) -> std::option::Option<&crate::model::AuthorizerType> {
        self.authorizer_type.as_ref()
    }
    /// <p>The authorizer's Uniform Resource Identifier (URI). For REQUEST authorizers, this must be a well-formed Lambda function URI, for example, arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:<replaceable>{account_id}</replaceable>:function:<replaceable>{lambda_function_name}</replaceable>/invocations. In general, the URI has this form: arn:aws:apigateway:<replaceable>{region}</replaceable>:lambda:path/<replaceable>{service_api}</replaceable>
    /// , where <replaceable></replaceable>{region} is the same as the region hosting the Lambda function, path indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial /. For Lambda functions, this is usually of the form /2015-03-31/functions/[FunctionARN]/invocations. Supported only for REQUEST authorizers.</p>
    pub fn authorizer_uri(&self) -> std::option::Option<&str> {
        self.authorizer_uri.as_deref()
    }
    /// <p>Specifies whether a Lambda authorizer returns a response in a simple format. If enabled, the Lambda authorizer can return a boolean value instead of an IAM policy. Supported only for HTTP APIs. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a></p>
    pub fn enable_simple_responses(&self) -> bool {
        self.enable_simple_responses
    }
    /// <p>The identity source for which authorization is requested.</p> <p>For a REQUEST authorizer, this is optional. The value is a set of one or more mapping expressions of the specified request parameters. The identity source can be headers, query string parameters, stage variables, and context parameters. For example, if an Auth header and a Name query string parameter are defined as identity sources, this value is route.request.header.Auth, route.request.querystring.Name for WebSocket APIs. For HTTP APIs, use selection expressions prefixed with $, for example, $request.header.Auth, $request.querystring.Name. These parameters are used to perform runtime validation for Lambda-based authorizers by verifying all of the identity-related request parameters are present in the request, not null, and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function. Otherwise, it returns a 401 Unauthorized response without calling the Lambda function. For HTTP APIs, identity sources are also used as the cache key when caching is enabled. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p> <p>For JWT, a single entry that specifies where to extract the JSON Web Token (JWT) from inbound requests. Currently only header-based and query parameter-based selections are supported, for example $request.header.Authorization.</p>
    pub fn identity_source(&self) -> std::option::Option<&[std::string::String]> {
        self.identity_source.as_deref()
    }
    /// <p>The validation expression does not apply to the REQUEST authorizer.</p>
    pub fn identity_validation_expression(&self) -> std::option::Option<&str> {
        self.identity_validation_expression.as_deref()
    }
    /// <p>Represents the configuration of a JWT authorizer. Required for the JWT authorizer type. Supported only for HTTP APIs.</p>
    pub fn jwt_configuration(&self) -> std::option::Option<&crate::model::JwtConfiguration> {
        self.jwt_configuration.as_ref()
    }
    /// <p>The name of the authorizer.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for UpdateAuthorizerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAuthorizerOutput");
        formatter.field(
            "authorizer_credentials_arn",
            &self.authorizer_credentials_arn,
        );
        formatter.field("authorizer_id", &self.authorizer_id);
        formatter.field(
            "authorizer_payload_format_version",
            &self.authorizer_payload_format_version,
        );
        formatter.field(
            "authorizer_result_ttl_in_seconds",
            &self.authorizer_result_ttl_in_seconds,
        );
        formatter.field("authorizer_type", &self.authorizer_type);
        formatter.field("authorizer_uri", &self.authorizer_uri);
        formatter.field("enable_simple_responses", &self.enable_simple_responses);
        formatter.field("identity_source", &self.identity_source);
        formatter.field(
            "identity_validation_expression",
            &self.identity_validation_expression,
        );
        formatter.field("jwt_configuration", &self.jwt_configuration);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`UpdateAuthorizerOutput`](crate::output::UpdateAuthorizerOutput)
pub mod update_authorizer_output {
    /// A builder for [`UpdateAuthorizerOutput`](crate::output::UpdateAuthorizerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authorizer_credentials_arn: std::option::Option<std::string::String>,
        pub(crate) authorizer_id: std::option::Option<std::string::String>,
        pub(crate) authorizer_payload_format_version: std::option::Option<std::string::String>,
        pub(crate) authorizer_result_ttl_in_seconds: std::option::Option<i32>,
        pub(crate) authorizer_type: std::option::Option<crate::model::AuthorizerType>,
        pub(crate) authorizer_uri: std::option::Option<std::string::String>,
        pub(crate) enable_simple_responses: std::option::Option<bool>,
        pub(crate) identity_source: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) identity_validation_expression: std::option::Option<std::string::String>,
        pub(crate) jwt_configuration: std::option::Option<crate::model::JwtConfiguration>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, don't specify this parameter. Supported only for REQUEST authorizers.</p>
        pub fn authorizer_credentials_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorizer_credentials_arn = Some(input.into());
            self
        }
        /// <p>Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, don't specify this parameter. Supported only for REQUEST authorizers.</p>
        pub fn set_authorizer_credentials_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorizer_credentials_arn = input;
            self
        }
        /// <p>The authorizer identifier.</p>
        pub fn authorizer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorizer_id = Some(input.into());
            self
        }
        /// <p>The authorizer identifier.</p>
        pub fn set_authorizer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorizer_id = input;
            self
        }
        /// <p>Specifies the format of the payload sent to an HTTP API Lambda authorizer. Required for HTTP API Lambda authorizers. Supported values are 1.0 and 2.0. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p>
        pub fn authorizer_payload_format_version(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.authorizer_payload_format_version = Some(input.into());
            self
        }
        /// <p>Specifies the format of the payload sent to an HTTP API Lambda authorizer. Required for HTTP API Lambda authorizers. Supported values are 1.0 and 2.0. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p>
        pub fn set_authorizer_payload_format_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorizer_payload_format_version = input;
            self
        }
        /// <p>The time to live (TTL) for cached authorizer results, in seconds. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway caches authorizer responses. The maximum value is 3600, or 1 hour. Supported only for HTTP API Lambda authorizers.</p>
        pub fn authorizer_result_ttl_in_seconds(mut self, input: i32) -> Self {
            self.authorizer_result_ttl_in_seconds = Some(input);
            self
        }
        /// <p>The time to live (TTL) for cached authorizer results, in seconds. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway caches authorizer responses. The maximum value is 3600, or 1 hour. Supported only for HTTP API Lambda authorizers.</p>
        pub fn set_authorizer_result_ttl_in_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.authorizer_result_ttl_in_seconds = input;
            self
        }
        /// <p>The authorizer type. Specify REQUEST for a Lambda function using incoming request parameters. Specify JWT to use JSON Web Tokens (supported only for HTTP APIs).</p>
        pub fn authorizer_type(mut self, input: crate::model::AuthorizerType) -> Self {
            self.authorizer_type = Some(input);
            self
        }
        /// <p>The authorizer type. Specify REQUEST for a Lambda function using incoming request parameters. Specify JWT to use JSON Web Tokens (supported only for HTTP APIs).</p>
        pub fn set_authorizer_type(
            mut self,
            input: std::option::Option<crate::model::AuthorizerType>,
        ) -> Self {
            self.authorizer_type = input;
            self
        }
        /// <p>The authorizer's Uniform Resource Identifier (URI). For REQUEST authorizers, this must be a well-formed Lambda function URI, for example, arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:<replaceable>{account_id}</replaceable>:function:<replaceable>{lambda_function_name}</replaceable>/invocations. In general, the URI has this form: arn:aws:apigateway:<replaceable>{region}</replaceable>:lambda:path/<replaceable>{service_api}</replaceable>
        /// , where <replaceable></replaceable>{region} is the same as the region hosting the Lambda function, path indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial /. For Lambda functions, this is usually of the form /2015-03-31/functions/[FunctionARN]/invocations. Supported only for REQUEST authorizers.</p>
        pub fn authorizer_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorizer_uri = Some(input.into());
            self
        }
        /// <p>The authorizer's Uniform Resource Identifier (URI). For REQUEST authorizers, this must be a well-formed Lambda function URI, for example, arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:<replaceable>{account_id}</replaceable>:function:<replaceable>{lambda_function_name}</replaceable>/invocations. In general, the URI has this form: arn:aws:apigateway:<replaceable>{region}</replaceable>:lambda:path/<replaceable>{service_api}</replaceable>
        /// , where <replaceable></replaceable>{region} is the same as the region hosting the Lambda function, path indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial /. For Lambda functions, this is usually of the form /2015-03-31/functions/[FunctionARN]/invocations. Supported only for REQUEST authorizers.</p>
        pub fn set_authorizer_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorizer_uri = input;
            self
        }
        /// <p>Specifies whether a Lambda authorizer returns a response in a simple format. If enabled, the Lambda authorizer can return a boolean value instead of an IAM policy. Supported only for HTTP APIs. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a></p>
        pub fn enable_simple_responses(mut self, input: bool) -> Self {
            self.enable_simple_responses = Some(input);
            self
        }
        /// <p>Specifies whether a Lambda authorizer returns a response in a simple format. If enabled, the Lambda authorizer can return a boolean value instead of an IAM policy. Supported only for HTTP APIs. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a></p>
        pub fn set_enable_simple_responses(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_simple_responses = input;
            self
        }
        /// Appends an item to `identity_source`.
        ///
        /// To override the contents of this collection use [`set_identity_source`](Self::set_identity_source).
        ///
        /// <p>The identity source for which authorization is requested.</p> <p>For a REQUEST authorizer, this is optional. The value is a set of one or more mapping expressions of the specified request parameters. The identity source can be headers, query string parameters, stage variables, and context parameters. For example, if an Auth header and a Name query string parameter are defined as identity sources, this value is route.request.header.Auth, route.request.querystring.Name for WebSocket APIs. For HTTP APIs, use selection expressions prefixed with $, for example, $request.header.Auth, $request.querystring.Name. These parameters are used to perform runtime validation for Lambda-based authorizers by verifying all of the identity-related request parameters are present in the request, not null, and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function. Otherwise, it returns a 401 Unauthorized response without calling the Lambda function. For HTTP APIs, identity sources are also used as the cache key when caching is enabled. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p> <p>For JWT, a single entry that specifies where to extract the JSON Web Token (JWT) from inbound requests. Currently only header-based and query parameter-based selections are supported, for example $request.header.Authorization.</p>
        pub fn identity_source(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.identity_source.unwrap_or_default();
            v.push(input.into());
            self.identity_source = Some(v);
            self
        }
        /// <p>The identity source for which authorization is requested.</p> <p>For a REQUEST authorizer, this is optional. The value is a set of one or more mapping expressions of the specified request parameters. The identity source can be headers, query string parameters, stage variables, and context parameters. For example, if an Auth header and a Name query string parameter are defined as identity sources, this value is route.request.header.Auth, route.request.querystring.Name for WebSocket APIs. For HTTP APIs, use selection expressions prefixed with $, for example, $request.header.Auth, $request.querystring.Name. These parameters are used to perform runtime validation for Lambda-based authorizers by verifying all of the identity-related request parameters are present in the request, not null, and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function. Otherwise, it returns a 401 Unauthorized response without calling the Lambda function. For HTTP APIs, identity sources are also used as the cache key when caching is enabled. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p> <p>For JWT, a single entry that specifies where to extract the JSON Web Token (JWT) from inbound requests. Currently only header-based and query parameter-based selections are supported, for example $request.header.Authorization.</p>
        pub fn set_identity_source(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.identity_source = input;
            self
        }
        /// <p>The validation expression does not apply to the REQUEST authorizer.</p>
        pub fn identity_validation_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.identity_validation_expression = Some(input.into());
            self
        }
        /// <p>The validation expression does not apply to the REQUEST authorizer.</p>
        pub fn set_identity_validation_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_validation_expression = input;
            self
        }
        /// <p>Represents the configuration of a JWT authorizer. Required for the JWT authorizer type. Supported only for HTTP APIs.</p>
        pub fn jwt_configuration(mut self, input: crate::model::JwtConfiguration) -> Self {
            self.jwt_configuration = Some(input);
            self
        }
        /// <p>Represents the configuration of a JWT authorizer. Required for the JWT authorizer type. Supported only for HTTP APIs.</p>
        pub fn set_jwt_configuration(
            mut self,
            input: std::option::Option<crate::model::JwtConfiguration>,
        ) -> Self {
            self.jwt_configuration = input;
            self
        }
        /// <p>The name of the authorizer.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the authorizer.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAuthorizerOutput`](crate::output::UpdateAuthorizerOutput)
        pub fn build(self) -> crate::output::UpdateAuthorizerOutput {
            crate::output::UpdateAuthorizerOutput {
                authorizer_credentials_arn: self.authorizer_credentials_arn,
                authorizer_id: self.authorizer_id,
                authorizer_payload_format_version: self.authorizer_payload_format_version,
                authorizer_result_ttl_in_seconds: self
                    .authorizer_result_ttl_in_seconds
                    .unwrap_or_default(),
                authorizer_type: self.authorizer_type,
                authorizer_uri: self.authorizer_uri,
                enable_simple_responses: self.enable_simple_responses.unwrap_or_default(),
                identity_source: self.identity_source,
                identity_validation_expression: self.identity_validation_expression,
                jwt_configuration: self.jwt_configuration,
                name: self.name,
            }
        }
    }
}
impl UpdateAuthorizerOutput {
    /// Creates a new builder-style object to manufacture [`UpdateAuthorizerOutput`](crate::output::UpdateAuthorizerOutput)
    pub fn builder() -> crate::output::update_authorizer_output::Builder {
        crate::output::update_authorizer_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateApiMappingOutput {
    /// <p>The API identifier.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The API mapping identifier.</p>
    pub api_mapping_id: std::option::Option<std::string::String>,
    /// <p>The API mapping key.</p>
    pub api_mapping_key: std::option::Option<std::string::String>,
    /// <p>The API stage.</p>
    pub stage: std::option::Option<std::string::String>,
}
impl UpdateApiMappingOutput {
    /// <p>The API identifier.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The API mapping identifier.</p>
    pub fn api_mapping_id(&self) -> std::option::Option<&str> {
        self.api_mapping_id.as_deref()
    }
    /// <p>The API mapping key.</p>
    pub fn api_mapping_key(&self) -> std::option::Option<&str> {
        self.api_mapping_key.as_deref()
    }
    /// <p>The API stage.</p>
    pub fn stage(&self) -> std::option::Option<&str> {
        self.stage.as_deref()
    }
}
impl std::fmt::Debug for UpdateApiMappingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateApiMappingOutput");
        formatter.field("api_id", &self.api_id);
        formatter.field("api_mapping_id", &self.api_mapping_id);
        formatter.field("api_mapping_key", &self.api_mapping_key);
        formatter.field("stage", &self.stage);
        formatter.finish()
    }
}
/// See [`UpdateApiMappingOutput`](crate::output::UpdateApiMappingOutput)
pub mod update_api_mapping_output {
    /// A builder for [`UpdateApiMappingOutput`](crate::output::UpdateApiMappingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) api_mapping_id: std::option::Option<std::string::String>,
        pub(crate) api_mapping_key: std::option::Option<std::string::String>,
        pub(crate) stage: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The API mapping identifier.</p>
        pub fn api_mapping_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_mapping_id = Some(input.into());
            self
        }
        /// <p>The API mapping identifier.</p>
        pub fn set_api_mapping_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.api_mapping_id = input;
            self
        }
        /// <p>The API mapping key.</p>
        pub fn api_mapping_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_mapping_key = Some(input.into());
            self
        }
        /// <p>The API mapping key.</p>
        pub fn set_api_mapping_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.api_mapping_key = input;
            self
        }
        /// <p>The API stage.</p>
        pub fn stage(mut self, input: impl Into<std::string::String>) -> Self {
            self.stage = Some(input.into());
            self
        }
        /// <p>The API stage.</p>
        pub fn set_stage(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stage = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateApiMappingOutput`](crate::output::UpdateApiMappingOutput)
        pub fn build(self) -> crate::output::UpdateApiMappingOutput {
            crate::output::UpdateApiMappingOutput {
                api_id: self.api_id,
                api_mapping_id: self.api_mapping_id,
                api_mapping_key: self.api_mapping_key,
                stage: self.stage,
            }
        }
    }
}
impl UpdateApiMappingOutput {
    /// Creates a new builder-style object to manufacture [`UpdateApiMappingOutput`](crate::output::UpdateApiMappingOutput)
    pub fn builder() -> crate::output::update_api_mapping_output::Builder {
        crate::output::update_api_mapping_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateApiOutput {
    /// <p>The URI of the API, of the form {api-id}.execute-api.{region}.amazonaws.com. The stage name is typically appended to this URI to form a complete path to a deployed API stage.</p>
    pub api_endpoint: std::option::Option<std::string::String>,
    /// <p>Specifies whether an API is managed by API Gateway. You can't update or delete a managed API by using API Gateway. A managed API can be deleted only through the tooling or service that created it.</p>
    pub api_gateway_managed: bool,
    /// <p>The API ID.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>An API key selection expression. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions">API Key Selection Expressions</a>.</p>
    pub api_key_selection_expression: std::option::Option<std::string::String>,
    /// <p>A CORS configuration. Supported only for HTTP APIs.</p>
    pub cors_configuration: std::option::Option<crate::model::Cors>,
    /// <p>The timestamp when the API was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The description of the API.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Avoid validating models when creating a deployment. Supported only for WebSocket APIs.</p>
    pub disable_schema_validation: bool,
    /// <p>Specifies whether clients can invoke your API by using the default execute-api endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
    pub disable_execute_api_endpoint: bool,
    /// <p>The validation information during API import. This may include particular properties of your OpenAPI definition which are ignored during import. Supported only for HTTP APIs.</p>
    pub import_info: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The name of the API.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The API protocol.</p>
    pub protocol_type: std::option::Option<crate::model::ProtocolType>,
    /// <p>The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.</p>
    pub route_selection_expression: std::option::Option<std::string::String>,
    /// <p>A collection of tags associated with the API.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A version identifier for the API.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>The warning messages reported when failonwarnings is turned on during API import.</p>
    pub warnings: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UpdateApiOutput {
    /// <p>The URI of the API, of the form {api-id}.execute-api.{region}.amazonaws.com. The stage name is typically appended to this URI to form a complete path to a deployed API stage.</p>
    pub fn api_endpoint(&self) -> std::option::Option<&str> {
        self.api_endpoint.as_deref()
    }
    /// <p>Specifies whether an API is managed by API Gateway. You can't update or delete a managed API by using API Gateway. A managed API can be deleted only through the tooling or service that created it.</p>
    pub fn api_gateway_managed(&self) -> bool {
        self.api_gateway_managed
    }
    /// <p>The API ID.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>An API key selection expression. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions">API Key Selection Expressions</a>.</p>
    pub fn api_key_selection_expression(&self) -> std::option::Option<&str> {
        self.api_key_selection_expression.as_deref()
    }
    /// <p>A CORS configuration. Supported only for HTTP APIs.</p>
    pub fn cors_configuration(&self) -> std::option::Option<&crate::model::Cors> {
        self.cors_configuration.as_ref()
    }
    /// <p>The timestamp when the API was created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_date.as_ref()
    }
    /// <p>The description of the API.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Avoid validating models when creating a deployment. Supported only for WebSocket APIs.</p>
    pub fn disable_schema_validation(&self) -> bool {
        self.disable_schema_validation
    }
    /// <p>Specifies whether clients can invoke your API by using the default execute-api endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
    pub fn disable_execute_api_endpoint(&self) -> bool {
        self.disable_execute_api_endpoint
    }
    /// <p>The validation information during API import. This may include particular properties of your OpenAPI definition which are ignored during import. Supported only for HTTP APIs.</p>
    pub fn import_info(&self) -> std::option::Option<&[std::string::String]> {
        self.import_info.as_deref()
    }
    /// <p>The name of the API.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The API protocol.</p>
    pub fn protocol_type(&self) -> std::option::Option<&crate::model::ProtocolType> {
        self.protocol_type.as_ref()
    }
    /// <p>The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.</p>
    pub fn route_selection_expression(&self) -> std::option::Option<&str> {
        self.route_selection_expression.as_deref()
    }
    /// <p>A collection of tags associated with the API.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>A version identifier for the API.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>The warning messages reported when failonwarnings is turned on during API import.</p>
    pub fn warnings(&self) -> std::option::Option<&[std::string::String]> {
        self.warnings.as_deref()
    }
}
impl std::fmt::Debug for UpdateApiOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateApiOutput");
        formatter.field("api_endpoint", &self.api_endpoint);
        formatter.field("api_gateway_managed", &self.api_gateway_managed);
        formatter.field("api_id", &self.api_id);
        formatter.field(
            "api_key_selection_expression",
            &self.api_key_selection_expression,
        );
        formatter.field("cors_configuration", &self.cors_configuration);
        formatter.field("created_date", &self.created_date);
        formatter.field("description", &self.description);
        formatter.field("disable_schema_validation", &self.disable_schema_validation);
        formatter.field(
            "disable_execute_api_endpoint",
            &self.disable_execute_api_endpoint,
        );
        formatter.field("import_info", &self.import_info);
        formatter.field("name", &self.name);
        formatter.field("protocol_type", &self.protocol_type);
        formatter.field(
            "route_selection_expression",
            &self.route_selection_expression,
        );
        formatter.field("tags", &self.tags);
        formatter.field("version", &self.version);
        formatter.field("warnings", &self.warnings);
        formatter.finish()
    }
}
/// See [`UpdateApiOutput`](crate::output::UpdateApiOutput)
pub mod update_api_output {
    /// A builder for [`UpdateApiOutput`](crate::output::UpdateApiOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_endpoint: std::option::Option<std::string::String>,
        pub(crate) api_gateway_managed: std::option::Option<bool>,
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) api_key_selection_expression: std::option::Option<std::string::String>,
        pub(crate) cors_configuration: std::option::Option<crate::model::Cors>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) disable_schema_validation: std::option::Option<bool>,
        pub(crate) disable_execute_api_endpoint: std::option::Option<bool>,
        pub(crate) import_info: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) protocol_type: std::option::Option<crate::model::ProtocolType>,
        pub(crate) route_selection_expression: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) warnings: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The URI of the API, of the form {api-id}.execute-api.{region}.amazonaws.com. The stage name is typically appended to this URI to form a complete path to a deployed API stage.</p>
        pub fn api_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_endpoint = Some(input.into());
            self
        }
        /// <p>The URI of the API, of the form {api-id}.execute-api.{region}.amazonaws.com. The stage name is typically appended to this URI to form a complete path to a deployed API stage.</p>
        pub fn set_api_endpoint(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_endpoint = input;
            self
        }
        /// <p>Specifies whether an API is managed by API Gateway. You can't update or delete a managed API by using API Gateway. A managed API can be deleted only through the tooling or service that created it.</p>
        pub fn api_gateway_managed(mut self, input: bool) -> Self {
            self.api_gateway_managed = Some(input);
            self
        }
        /// <p>Specifies whether an API is managed by API Gateway. You can't update or delete a managed API by using API Gateway. A managed API can be deleted only through the tooling or service that created it.</p>
        pub fn set_api_gateway_managed(mut self, input: std::option::Option<bool>) -> Self {
            self.api_gateway_managed = input;
            self
        }
        /// <p>The API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>An API key selection expression. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions">API Key Selection Expressions</a>.</p>
        pub fn api_key_selection_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.api_key_selection_expression = Some(input.into());
            self
        }
        /// <p>An API key selection expression. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions">API Key Selection Expressions</a>.</p>
        pub fn set_api_key_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.api_key_selection_expression = input;
            self
        }
        /// <p>A CORS configuration. Supported only for HTTP APIs.</p>
        pub fn cors_configuration(mut self, input: crate::model::Cors) -> Self {
            self.cors_configuration = Some(input);
            self
        }
        /// <p>A CORS configuration. Supported only for HTTP APIs.</p>
        pub fn set_cors_configuration(
            mut self,
            input: std::option::Option<crate::model::Cors>,
        ) -> Self {
            self.cors_configuration = input;
            self
        }
        /// <p>The timestamp when the API was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The timestamp when the API was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>The description of the API.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the API.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Avoid validating models when creating a deployment. Supported only for WebSocket APIs.</p>
        pub fn disable_schema_validation(mut self, input: bool) -> Self {
            self.disable_schema_validation = Some(input);
            self
        }
        /// <p>Avoid validating models when creating a deployment. Supported only for WebSocket APIs.</p>
        pub fn set_disable_schema_validation(mut self, input: std::option::Option<bool>) -> Self {
            self.disable_schema_validation = input;
            self
        }
        /// <p>Specifies whether clients can invoke your API by using the default execute-api endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
        pub fn disable_execute_api_endpoint(mut self, input: bool) -> Self {
            self.disable_execute_api_endpoint = Some(input);
            self
        }
        /// <p>Specifies whether clients can invoke your API by using the default execute-api endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
        pub fn set_disable_execute_api_endpoint(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.disable_execute_api_endpoint = input;
            self
        }
        /// Appends an item to `import_info`.
        ///
        /// To override the contents of this collection use [`set_import_info`](Self::set_import_info).
        ///
        /// <p>The validation information during API import. This may include particular properties of your OpenAPI definition which are ignored during import. Supported only for HTTP APIs.</p>
        pub fn import_info(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.import_info.unwrap_or_default();
            v.push(input.into());
            self.import_info = Some(v);
            self
        }
        /// <p>The validation information during API import. This may include particular properties of your OpenAPI definition which are ignored during import. Supported only for HTTP APIs.</p>
        pub fn set_import_info(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.import_info = input;
            self
        }
        /// <p>The name of the API.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the API.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The API protocol.</p>
        pub fn protocol_type(mut self, input: crate::model::ProtocolType) -> Self {
            self.protocol_type = Some(input);
            self
        }
        /// <p>The API protocol.</p>
        pub fn set_protocol_type(
            mut self,
            input: std::option::Option<crate::model::ProtocolType>,
        ) -> Self {
            self.protocol_type = input;
            self
        }
        /// <p>The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.</p>
        pub fn route_selection_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_selection_expression = Some(input.into());
            self
        }
        /// <p>The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.</p>
        pub fn set_route_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.route_selection_expression = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of tags associated with the API.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A collection of tags associated with the API.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>A version identifier for the API.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>A version identifier for the API.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Appends an item to `warnings`.
        ///
        /// To override the contents of this collection use [`set_warnings`](Self::set_warnings).
        ///
        /// <p>The warning messages reported when failonwarnings is turned on during API import.</p>
        pub fn warnings(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.warnings.unwrap_or_default();
            v.push(input.into());
            self.warnings = Some(v);
            self
        }
        /// <p>The warning messages reported when failonwarnings is turned on during API import.</p>
        pub fn set_warnings(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.warnings = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateApiOutput`](crate::output::UpdateApiOutput)
        pub fn build(self) -> crate::output::UpdateApiOutput {
            crate::output::UpdateApiOutput {
                api_endpoint: self.api_endpoint,
                api_gateway_managed: self.api_gateway_managed.unwrap_or_default(),
                api_id: self.api_id,
                api_key_selection_expression: self.api_key_selection_expression,
                cors_configuration: self.cors_configuration,
                created_date: self.created_date,
                description: self.description,
                disable_schema_validation: self.disable_schema_validation.unwrap_or_default(),
                disable_execute_api_endpoint: self.disable_execute_api_endpoint.unwrap_or_default(),
                import_info: self.import_info,
                name: self.name,
                protocol_type: self.protocol_type,
                route_selection_expression: self.route_selection_expression,
                tags: self.tags,
                version: self.version,
                warnings: self.warnings,
            }
        }
    }
}
impl UpdateApiOutput {
    /// Creates a new builder-style object to manufacture [`UpdateApiOutput`](crate::output::UpdateApiOutput)
    pub fn builder() -> crate::output::update_api_output::Builder {
        crate::output::update_api_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResetAuthorizersCacheOutput {}
impl std::fmt::Debug for ResetAuthorizersCacheOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResetAuthorizersCacheOutput");
        formatter.finish()
    }
}
/// See [`ResetAuthorizersCacheOutput`](crate::output::ResetAuthorizersCacheOutput)
pub mod reset_authorizers_cache_output {
    /// A builder for [`ResetAuthorizersCacheOutput`](crate::output::ResetAuthorizersCacheOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`ResetAuthorizersCacheOutput`](crate::output::ResetAuthorizersCacheOutput)
        pub fn build(self) -> crate::output::ResetAuthorizersCacheOutput {
            crate::output::ResetAuthorizersCacheOutput {}
        }
    }
}
impl ResetAuthorizersCacheOutput {
    /// Creates a new builder-style object to manufacture [`ResetAuthorizersCacheOutput`](crate::output::ResetAuthorizersCacheOutput)
    pub fn builder() -> crate::output::reset_authorizers_cache_output::Builder {
        crate::output::reset_authorizers_cache_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReimportApiOutput {
    /// <p>The URI of the API, of the form {api-id}.execute-api.{region}.amazonaws.com. The stage name is typically appended to this URI to form a complete path to a deployed API stage.</p>
    pub api_endpoint: std::option::Option<std::string::String>,
    /// <p>Specifies whether an API is managed by API Gateway. You can't update or delete a managed API by using API Gateway. A managed API can be deleted only through the tooling or service that created it.</p>
    pub api_gateway_managed: bool,
    /// <p>The API ID.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>An API key selection expression. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions">API Key Selection Expressions</a>.</p>
    pub api_key_selection_expression: std::option::Option<std::string::String>,
    /// <p>A CORS configuration. Supported only for HTTP APIs.</p>
    pub cors_configuration: std::option::Option<crate::model::Cors>,
    /// <p>The timestamp when the API was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The description of the API.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Avoid validating models when creating a deployment. Supported only for WebSocket APIs.</p>
    pub disable_schema_validation: bool,
    /// <p>Specifies whether clients can invoke your API by using the default execute-api endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
    pub disable_execute_api_endpoint: bool,
    /// <p>The validation information during API import. This may include particular properties of your OpenAPI definition which are ignored during import. Supported only for HTTP APIs.</p>
    pub import_info: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The name of the API.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The API protocol.</p>
    pub protocol_type: std::option::Option<crate::model::ProtocolType>,
    /// <p>The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.</p>
    pub route_selection_expression: std::option::Option<std::string::String>,
    /// <p>A collection of tags associated with the API.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A version identifier for the API.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>The warning messages reported when failonwarnings is turned on during API import.</p>
    pub warnings: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ReimportApiOutput {
    /// <p>The URI of the API, of the form {api-id}.execute-api.{region}.amazonaws.com. The stage name is typically appended to this URI to form a complete path to a deployed API stage.</p>
    pub fn api_endpoint(&self) -> std::option::Option<&str> {
        self.api_endpoint.as_deref()
    }
    /// <p>Specifies whether an API is managed by API Gateway. You can't update or delete a managed API by using API Gateway. A managed API can be deleted only through the tooling or service that created it.</p>
    pub fn api_gateway_managed(&self) -> bool {
        self.api_gateway_managed
    }
    /// <p>The API ID.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>An API key selection expression. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions">API Key Selection Expressions</a>.</p>
    pub fn api_key_selection_expression(&self) -> std::option::Option<&str> {
        self.api_key_selection_expression.as_deref()
    }
    /// <p>A CORS configuration. Supported only for HTTP APIs.</p>
    pub fn cors_configuration(&self) -> std::option::Option<&crate::model::Cors> {
        self.cors_configuration.as_ref()
    }
    /// <p>The timestamp when the API was created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_date.as_ref()
    }
    /// <p>The description of the API.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Avoid validating models when creating a deployment. Supported only for WebSocket APIs.</p>
    pub fn disable_schema_validation(&self) -> bool {
        self.disable_schema_validation
    }
    /// <p>Specifies whether clients can invoke your API by using the default execute-api endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
    pub fn disable_execute_api_endpoint(&self) -> bool {
        self.disable_execute_api_endpoint
    }
    /// <p>The validation information during API import. This may include particular properties of your OpenAPI definition which are ignored during import. Supported only for HTTP APIs.</p>
    pub fn import_info(&self) -> std::option::Option<&[std::string::String]> {
        self.import_info.as_deref()
    }
    /// <p>The name of the API.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The API protocol.</p>
    pub fn protocol_type(&self) -> std::option::Option<&crate::model::ProtocolType> {
        self.protocol_type.as_ref()
    }
    /// <p>The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.</p>
    pub fn route_selection_expression(&self) -> std::option::Option<&str> {
        self.route_selection_expression.as_deref()
    }
    /// <p>A collection of tags associated with the API.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>A version identifier for the API.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>The warning messages reported when failonwarnings is turned on during API import.</p>
    pub fn warnings(&self) -> std::option::Option<&[std::string::String]> {
        self.warnings.as_deref()
    }
}
impl std::fmt::Debug for ReimportApiOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReimportApiOutput");
        formatter.field("api_endpoint", &self.api_endpoint);
        formatter.field("api_gateway_managed", &self.api_gateway_managed);
        formatter.field("api_id", &self.api_id);
        formatter.field(
            "api_key_selection_expression",
            &self.api_key_selection_expression,
        );
        formatter.field("cors_configuration", &self.cors_configuration);
        formatter.field("created_date", &self.created_date);
        formatter.field("description", &self.description);
        formatter.field("disable_schema_validation", &self.disable_schema_validation);
        formatter.field(
            "disable_execute_api_endpoint",
            &self.disable_execute_api_endpoint,
        );
        formatter.field("import_info", &self.import_info);
        formatter.field("name", &self.name);
        formatter.field("protocol_type", &self.protocol_type);
        formatter.field(
            "route_selection_expression",
            &self.route_selection_expression,
        );
        formatter.field("tags", &self.tags);
        formatter.field("version", &self.version);
        formatter.field("warnings", &self.warnings);
        formatter.finish()
    }
}
/// See [`ReimportApiOutput`](crate::output::ReimportApiOutput)
pub mod reimport_api_output {
    /// A builder for [`ReimportApiOutput`](crate::output::ReimportApiOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_endpoint: std::option::Option<std::string::String>,
        pub(crate) api_gateway_managed: std::option::Option<bool>,
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) api_key_selection_expression: std::option::Option<std::string::String>,
        pub(crate) cors_configuration: std::option::Option<crate::model::Cors>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) disable_schema_validation: std::option::Option<bool>,
        pub(crate) disable_execute_api_endpoint: std::option::Option<bool>,
        pub(crate) import_info: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) protocol_type: std::option::Option<crate::model::ProtocolType>,
        pub(crate) route_selection_expression: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) warnings: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The URI of the API, of the form {api-id}.execute-api.{region}.amazonaws.com. The stage name is typically appended to this URI to form a complete path to a deployed API stage.</p>
        pub fn api_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_endpoint = Some(input.into());
            self
        }
        /// <p>The URI of the API, of the form {api-id}.execute-api.{region}.amazonaws.com. The stage name is typically appended to this URI to form a complete path to a deployed API stage.</p>
        pub fn set_api_endpoint(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_endpoint = input;
            self
        }
        /// <p>Specifies whether an API is managed by API Gateway. You can't update or delete a managed API by using API Gateway. A managed API can be deleted only through the tooling or service that created it.</p>
        pub fn api_gateway_managed(mut self, input: bool) -> Self {
            self.api_gateway_managed = Some(input);
            self
        }
        /// <p>Specifies whether an API is managed by API Gateway. You can't update or delete a managed API by using API Gateway. A managed API can be deleted only through the tooling or service that created it.</p>
        pub fn set_api_gateway_managed(mut self, input: std::option::Option<bool>) -> Self {
            self.api_gateway_managed = input;
            self
        }
        /// <p>The API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>An API key selection expression. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions">API Key Selection Expressions</a>.</p>
        pub fn api_key_selection_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.api_key_selection_expression = Some(input.into());
            self
        }
        /// <p>An API key selection expression. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions">API Key Selection Expressions</a>.</p>
        pub fn set_api_key_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.api_key_selection_expression = input;
            self
        }
        /// <p>A CORS configuration. Supported only for HTTP APIs.</p>
        pub fn cors_configuration(mut self, input: crate::model::Cors) -> Self {
            self.cors_configuration = Some(input);
            self
        }
        /// <p>A CORS configuration. Supported only for HTTP APIs.</p>
        pub fn set_cors_configuration(
            mut self,
            input: std::option::Option<crate::model::Cors>,
        ) -> Self {
            self.cors_configuration = input;
            self
        }
        /// <p>The timestamp when the API was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The timestamp when the API was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>The description of the API.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the API.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Avoid validating models when creating a deployment. Supported only for WebSocket APIs.</p>
        pub fn disable_schema_validation(mut self, input: bool) -> Self {
            self.disable_schema_validation = Some(input);
            self
        }
        /// <p>Avoid validating models when creating a deployment. Supported only for WebSocket APIs.</p>
        pub fn set_disable_schema_validation(mut self, input: std::option::Option<bool>) -> Self {
            self.disable_schema_validation = input;
            self
        }
        /// <p>Specifies whether clients can invoke your API by using the default execute-api endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
        pub fn disable_execute_api_endpoint(mut self, input: bool) -> Self {
            self.disable_execute_api_endpoint = Some(input);
            self
        }
        /// <p>Specifies whether clients can invoke your API by using the default execute-api endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
        pub fn set_disable_execute_api_endpoint(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.disable_execute_api_endpoint = input;
            self
        }
        /// Appends an item to `import_info`.
        ///
        /// To override the contents of this collection use [`set_import_info`](Self::set_import_info).
        ///
        /// <p>The validation information during API import. This may include particular properties of your OpenAPI definition which are ignored during import. Supported only for HTTP APIs.</p>
        pub fn import_info(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.import_info.unwrap_or_default();
            v.push(input.into());
            self.import_info = Some(v);
            self
        }
        /// <p>The validation information during API import. This may include particular properties of your OpenAPI definition which are ignored during import. Supported only for HTTP APIs.</p>
        pub fn set_import_info(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.import_info = input;
            self
        }
        /// <p>The name of the API.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the API.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The API protocol.</p>
        pub fn protocol_type(mut self, input: crate::model::ProtocolType) -> Self {
            self.protocol_type = Some(input);
            self
        }
        /// <p>The API protocol.</p>
        pub fn set_protocol_type(
            mut self,
            input: std::option::Option<crate::model::ProtocolType>,
        ) -> Self {
            self.protocol_type = input;
            self
        }
        /// <p>The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.</p>
        pub fn route_selection_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_selection_expression = Some(input.into());
            self
        }
        /// <p>The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.</p>
        pub fn set_route_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.route_selection_expression = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of tags associated with the API.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A collection of tags associated with the API.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>A version identifier for the API.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>A version identifier for the API.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Appends an item to `warnings`.
        ///
        /// To override the contents of this collection use [`set_warnings`](Self::set_warnings).
        ///
        /// <p>The warning messages reported when failonwarnings is turned on during API import.</p>
        pub fn warnings(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.warnings.unwrap_or_default();
            v.push(input.into());
            self.warnings = Some(v);
            self
        }
        /// <p>The warning messages reported when failonwarnings is turned on during API import.</p>
        pub fn set_warnings(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.warnings = input;
            self
        }
        /// Consumes the builder and constructs a [`ReimportApiOutput`](crate::output::ReimportApiOutput)
        pub fn build(self) -> crate::output::ReimportApiOutput {
            crate::output::ReimportApiOutput {
                api_endpoint: self.api_endpoint,
                api_gateway_managed: self.api_gateway_managed.unwrap_or_default(),
                api_id: self.api_id,
                api_key_selection_expression: self.api_key_selection_expression,
                cors_configuration: self.cors_configuration,
                created_date: self.created_date,
                description: self.description,
                disable_schema_validation: self.disable_schema_validation.unwrap_or_default(),
                disable_execute_api_endpoint: self.disable_execute_api_endpoint.unwrap_or_default(),
                import_info: self.import_info,
                name: self.name,
                protocol_type: self.protocol_type,
                route_selection_expression: self.route_selection_expression,
                tags: self.tags,
                version: self.version,
                warnings: self.warnings,
            }
        }
    }
}
impl ReimportApiOutput {
    /// Creates a new builder-style object to manufacture [`ReimportApiOutput`](crate::output::ReimportApiOutput)
    pub fn builder() -> crate::output::reimport_api_output::Builder {
        crate::output::reimport_api_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImportApiOutput {
    /// <p>The URI of the API, of the form {api-id}.execute-api.{region}.amazonaws.com. The stage name is typically appended to this URI to form a complete path to a deployed API stage.</p>
    pub api_endpoint: std::option::Option<std::string::String>,
    /// <p>Specifies whether an API is managed by API Gateway. You can't update or delete a managed API by using API Gateway. A managed API can be deleted only through the tooling or service that created it.</p>
    pub api_gateway_managed: bool,
    /// <p>The API ID.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>An API key selection expression. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions">API Key Selection Expressions</a>.</p>
    pub api_key_selection_expression: std::option::Option<std::string::String>,
    /// <p>A CORS configuration. Supported only for HTTP APIs.</p>
    pub cors_configuration: std::option::Option<crate::model::Cors>,
    /// <p>The timestamp when the API was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The description of the API.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Avoid validating models when creating a deployment. Supported only for WebSocket APIs.</p>
    pub disable_schema_validation: bool,
    /// <p>Specifies whether clients can invoke your API by using the default execute-api endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
    pub disable_execute_api_endpoint: bool,
    /// <p>The validation information during API import. This may include particular properties of your OpenAPI definition which are ignored during import. Supported only for HTTP APIs.</p>
    pub import_info: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The name of the API.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The API protocol.</p>
    pub protocol_type: std::option::Option<crate::model::ProtocolType>,
    /// <p>The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.</p>
    pub route_selection_expression: std::option::Option<std::string::String>,
    /// <p>A collection of tags associated with the API.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A version identifier for the API.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>The warning messages reported when failonwarnings is turned on during API import.</p>
    pub warnings: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ImportApiOutput {
    /// <p>The URI of the API, of the form {api-id}.execute-api.{region}.amazonaws.com. The stage name is typically appended to this URI to form a complete path to a deployed API stage.</p>
    pub fn api_endpoint(&self) -> std::option::Option<&str> {
        self.api_endpoint.as_deref()
    }
    /// <p>Specifies whether an API is managed by API Gateway. You can't update or delete a managed API by using API Gateway. A managed API can be deleted only through the tooling or service that created it.</p>
    pub fn api_gateway_managed(&self) -> bool {
        self.api_gateway_managed
    }
    /// <p>The API ID.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>An API key selection expression. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions">API Key Selection Expressions</a>.</p>
    pub fn api_key_selection_expression(&self) -> std::option::Option<&str> {
        self.api_key_selection_expression.as_deref()
    }
    /// <p>A CORS configuration. Supported only for HTTP APIs.</p>
    pub fn cors_configuration(&self) -> std::option::Option<&crate::model::Cors> {
        self.cors_configuration.as_ref()
    }
    /// <p>The timestamp when the API was created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_date.as_ref()
    }
    /// <p>The description of the API.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Avoid validating models when creating a deployment. Supported only for WebSocket APIs.</p>
    pub fn disable_schema_validation(&self) -> bool {
        self.disable_schema_validation
    }
    /// <p>Specifies whether clients can invoke your API by using the default execute-api endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
    pub fn disable_execute_api_endpoint(&self) -> bool {
        self.disable_execute_api_endpoint
    }
    /// <p>The validation information during API import. This may include particular properties of your OpenAPI definition which are ignored during import. Supported only for HTTP APIs.</p>
    pub fn import_info(&self) -> std::option::Option<&[std::string::String]> {
        self.import_info.as_deref()
    }
    /// <p>The name of the API.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The API protocol.</p>
    pub fn protocol_type(&self) -> std::option::Option<&crate::model::ProtocolType> {
        self.protocol_type.as_ref()
    }
    /// <p>The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.</p>
    pub fn route_selection_expression(&self) -> std::option::Option<&str> {
        self.route_selection_expression.as_deref()
    }
    /// <p>A collection of tags associated with the API.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>A version identifier for the API.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>The warning messages reported when failonwarnings is turned on during API import.</p>
    pub fn warnings(&self) -> std::option::Option<&[std::string::String]> {
        self.warnings.as_deref()
    }
}
impl std::fmt::Debug for ImportApiOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImportApiOutput");
        formatter.field("api_endpoint", &self.api_endpoint);
        formatter.field("api_gateway_managed", &self.api_gateway_managed);
        formatter.field("api_id", &self.api_id);
        formatter.field(
            "api_key_selection_expression",
            &self.api_key_selection_expression,
        );
        formatter.field("cors_configuration", &self.cors_configuration);
        formatter.field("created_date", &self.created_date);
        formatter.field("description", &self.description);
        formatter.field("disable_schema_validation", &self.disable_schema_validation);
        formatter.field(
            "disable_execute_api_endpoint",
            &self.disable_execute_api_endpoint,
        );
        formatter.field("import_info", &self.import_info);
        formatter.field("name", &self.name);
        formatter.field("protocol_type", &self.protocol_type);
        formatter.field(
            "route_selection_expression",
            &self.route_selection_expression,
        );
        formatter.field("tags", &self.tags);
        formatter.field("version", &self.version);
        formatter.field("warnings", &self.warnings);
        formatter.finish()
    }
}
/// See [`ImportApiOutput`](crate::output::ImportApiOutput)
pub mod import_api_output {
    /// A builder for [`ImportApiOutput`](crate::output::ImportApiOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_endpoint: std::option::Option<std::string::String>,
        pub(crate) api_gateway_managed: std::option::Option<bool>,
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) api_key_selection_expression: std::option::Option<std::string::String>,
        pub(crate) cors_configuration: std::option::Option<crate::model::Cors>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) disable_schema_validation: std::option::Option<bool>,
        pub(crate) disable_execute_api_endpoint: std::option::Option<bool>,
        pub(crate) import_info: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) protocol_type: std::option::Option<crate::model::ProtocolType>,
        pub(crate) route_selection_expression: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) warnings: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The URI of the API, of the form {api-id}.execute-api.{region}.amazonaws.com. The stage name is typically appended to this URI to form a complete path to a deployed API stage.</p>
        pub fn api_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_endpoint = Some(input.into());
            self
        }
        /// <p>The URI of the API, of the form {api-id}.execute-api.{region}.amazonaws.com. The stage name is typically appended to this URI to form a complete path to a deployed API stage.</p>
        pub fn set_api_endpoint(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_endpoint = input;
            self
        }
        /// <p>Specifies whether an API is managed by API Gateway. You can't update or delete a managed API by using API Gateway. A managed API can be deleted only through the tooling or service that created it.</p>
        pub fn api_gateway_managed(mut self, input: bool) -> Self {
            self.api_gateway_managed = Some(input);
            self
        }
        /// <p>Specifies whether an API is managed by API Gateway. You can't update or delete a managed API by using API Gateway. A managed API can be deleted only through the tooling or service that created it.</p>
        pub fn set_api_gateway_managed(mut self, input: std::option::Option<bool>) -> Self {
            self.api_gateway_managed = input;
            self
        }
        /// <p>The API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>An API key selection expression. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions">API Key Selection Expressions</a>.</p>
        pub fn api_key_selection_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.api_key_selection_expression = Some(input.into());
            self
        }
        /// <p>An API key selection expression. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions">API Key Selection Expressions</a>.</p>
        pub fn set_api_key_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.api_key_selection_expression = input;
            self
        }
        /// <p>A CORS configuration. Supported only for HTTP APIs.</p>
        pub fn cors_configuration(mut self, input: crate::model::Cors) -> Self {
            self.cors_configuration = Some(input);
            self
        }
        /// <p>A CORS configuration. Supported only for HTTP APIs.</p>
        pub fn set_cors_configuration(
            mut self,
            input: std::option::Option<crate::model::Cors>,
        ) -> Self {
            self.cors_configuration = input;
            self
        }
        /// <p>The timestamp when the API was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The timestamp when the API was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>The description of the API.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the API.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Avoid validating models when creating a deployment. Supported only for WebSocket APIs.</p>
        pub fn disable_schema_validation(mut self, input: bool) -> Self {
            self.disable_schema_validation = Some(input);
            self
        }
        /// <p>Avoid validating models when creating a deployment. Supported only for WebSocket APIs.</p>
        pub fn set_disable_schema_validation(mut self, input: std::option::Option<bool>) -> Self {
            self.disable_schema_validation = input;
            self
        }
        /// <p>Specifies whether clients can invoke your API by using the default execute-api endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
        pub fn disable_execute_api_endpoint(mut self, input: bool) -> Self {
            self.disable_execute_api_endpoint = Some(input);
            self
        }
        /// <p>Specifies whether clients can invoke your API by using the default execute-api endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
        pub fn set_disable_execute_api_endpoint(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.disable_execute_api_endpoint = input;
            self
        }
        /// Appends an item to `import_info`.
        ///
        /// To override the contents of this collection use [`set_import_info`](Self::set_import_info).
        ///
        /// <p>The validation information during API import. This may include particular properties of your OpenAPI definition which are ignored during import. Supported only for HTTP APIs.</p>
        pub fn import_info(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.import_info.unwrap_or_default();
            v.push(input.into());
            self.import_info = Some(v);
            self
        }
        /// <p>The validation information during API import. This may include particular properties of your OpenAPI definition which are ignored during import. Supported only for HTTP APIs.</p>
        pub fn set_import_info(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.import_info = input;
            self
        }
        /// <p>The name of the API.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the API.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The API protocol.</p>
        pub fn protocol_type(mut self, input: crate::model::ProtocolType) -> Self {
            self.protocol_type = Some(input);
            self
        }
        /// <p>The API protocol.</p>
        pub fn set_protocol_type(
            mut self,
            input: std::option::Option<crate::model::ProtocolType>,
        ) -> Self {
            self.protocol_type = input;
            self
        }
        /// <p>The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.</p>
        pub fn route_selection_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_selection_expression = Some(input.into());
            self
        }
        /// <p>The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.</p>
        pub fn set_route_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.route_selection_expression = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of tags associated with the API.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A collection of tags associated with the API.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>A version identifier for the API.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>A version identifier for the API.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Appends an item to `warnings`.
        ///
        /// To override the contents of this collection use [`set_warnings`](Self::set_warnings).
        ///
        /// <p>The warning messages reported when failonwarnings is turned on during API import.</p>
        pub fn warnings(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.warnings.unwrap_or_default();
            v.push(input.into());
            self.warnings = Some(v);
            self
        }
        /// <p>The warning messages reported when failonwarnings is turned on during API import.</p>
        pub fn set_warnings(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.warnings = input;
            self
        }
        /// Consumes the builder and constructs a [`ImportApiOutput`](crate::output::ImportApiOutput)
        pub fn build(self) -> crate::output::ImportApiOutput {
            crate::output::ImportApiOutput {
                api_endpoint: self.api_endpoint,
                api_gateway_managed: self.api_gateway_managed.unwrap_or_default(),
                api_id: self.api_id,
                api_key_selection_expression: self.api_key_selection_expression,
                cors_configuration: self.cors_configuration,
                created_date: self.created_date,
                description: self.description,
                disable_schema_validation: self.disable_schema_validation.unwrap_or_default(),
                disable_execute_api_endpoint: self.disable_execute_api_endpoint.unwrap_or_default(),
                import_info: self.import_info,
                name: self.name,
                protocol_type: self.protocol_type,
                route_selection_expression: self.route_selection_expression,
                tags: self.tags,
                version: self.version,
                warnings: self.warnings,
            }
        }
    }
}
impl ImportApiOutput {
    /// Creates a new builder-style object to manufacture [`ImportApiOutput`](crate::output::ImportApiOutput)
    pub fn builder() -> crate::output::import_api_output::Builder {
        crate::output::import_api_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetVpcLinksOutput {
    /// <p>A collection of VPC links.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::VpcLink>>,
    /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetVpcLinksOutput {
    /// <p>A collection of VPC links.</p>
    pub fn items(&self) -> std::option::Option<&[crate::model::VpcLink]> {
        self.items.as_deref()
    }
    /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetVpcLinksOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetVpcLinksOutput");
        formatter.field("items", &self.items);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetVpcLinksOutput`](crate::output::GetVpcLinksOutput)
pub mod get_vpc_links_output {
    /// A builder for [`GetVpcLinksOutput`](crate::output::GetVpcLinksOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) items: std::option::Option<std::vec::Vec<crate::model::VpcLink>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>A collection of VPC links.</p>
        pub fn items(mut self, input: impl Into<crate::model::VpcLink>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>A collection of VPC links.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VpcLink>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetVpcLinksOutput`](crate::output::GetVpcLinksOutput)
        pub fn build(self) -> crate::output::GetVpcLinksOutput {
            crate::output::GetVpcLinksOutput {
                items: self.items,
                next_token: self.next_token,
            }
        }
    }
}
impl GetVpcLinksOutput {
    /// Creates a new builder-style object to manufacture [`GetVpcLinksOutput`](crate::output::GetVpcLinksOutput)
    pub fn builder() -> crate::output::get_vpc_links_output::Builder {
        crate::output::get_vpc_links_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetVpcLinkOutput {
    /// <p>The timestamp when the VPC link was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The name of the VPC link.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A list of security group IDs for the VPC link.</p>
    pub security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of subnet IDs to include in the VPC link.</p>
    pub subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Tags for the VPC link.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The ID of the VPC link.</p>
    pub vpc_link_id: std::option::Option<std::string::String>,
    /// <p>The status of the VPC link.</p>
    pub vpc_link_status: std::option::Option<crate::model::VpcLinkStatus>,
    /// <p>A message summarizing the cause of the status of the VPC link.</p>
    pub vpc_link_status_message: std::option::Option<std::string::String>,
    /// <p>The version of the VPC link.</p>
    pub vpc_link_version: std::option::Option<crate::model::VpcLinkVersion>,
}
impl GetVpcLinkOutput {
    /// <p>The timestamp when the VPC link was created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_date.as_ref()
    }
    /// <p>The name of the VPC link.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A list of security group IDs for the VPC link.</p>
    pub fn security_group_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.security_group_ids.as_deref()
    }
    /// <p>A list of subnet IDs to include in the VPC link.</p>
    pub fn subnet_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.subnet_ids.as_deref()
    }
    /// <p>Tags for the VPC link.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The ID of the VPC link.</p>
    pub fn vpc_link_id(&self) -> std::option::Option<&str> {
        self.vpc_link_id.as_deref()
    }
    /// <p>The status of the VPC link.</p>
    pub fn vpc_link_status(&self) -> std::option::Option<&crate::model::VpcLinkStatus> {
        self.vpc_link_status.as_ref()
    }
    /// <p>A message summarizing the cause of the status of the VPC link.</p>
    pub fn vpc_link_status_message(&self) -> std::option::Option<&str> {
        self.vpc_link_status_message.as_deref()
    }
    /// <p>The version of the VPC link.</p>
    pub fn vpc_link_version(&self) -> std::option::Option<&crate::model::VpcLinkVersion> {
        self.vpc_link_version.as_ref()
    }
}
impl std::fmt::Debug for GetVpcLinkOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetVpcLinkOutput");
        formatter.field("created_date", &self.created_date);
        formatter.field("name", &self.name);
        formatter.field("security_group_ids", &self.security_group_ids);
        formatter.field("subnet_ids", &self.subnet_ids);
        formatter.field("tags", &self.tags);
        formatter.field("vpc_link_id", &self.vpc_link_id);
        formatter.field("vpc_link_status", &self.vpc_link_status);
        formatter.field("vpc_link_status_message", &self.vpc_link_status_message);
        formatter.field("vpc_link_version", &self.vpc_link_version);
        formatter.finish()
    }
}
/// See [`GetVpcLinkOutput`](crate::output::GetVpcLinkOutput)
pub mod get_vpc_link_output {
    /// A builder for [`GetVpcLinkOutput`](crate::output::GetVpcLinkOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) created_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) vpc_link_id: std::option::Option<std::string::String>,
        pub(crate) vpc_link_status: std::option::Option<crate::model::VpcLinkStatus>,
        pub(crate) vpc_link_status_message: std::option::Option<std::string::String>,
        pub(crate) vpc_link_version: std::option::Option<crate::model::VpcLinkVersion>,
    }
    impl Builder {
        /// <p>The timestamp when the VPC link was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The timestamp when the VPC link was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>The name of the VPC link.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the VPC link.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>A list of security group IDs for the VPC link.</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.security_group_ids = Some(v);
            self
        }
        /// <p>A list of security group IDs for the VPC link.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_ids = input;
            self
        }
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>A list of subnet IDs to include in the VPC link.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>A list of subnet IDs to include in the VPC link.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags for the VPC link.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Tags for the VPC link.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The ID of the VPC link.</p>
        pub fn vpc_link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_link_id = Some(input.into());
            self
        }
        /// <p>The ID of the VPC link.</p>
        pub fn set_vpc_link_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_link_id = input;
            self
        }
        /// <p>The status of the VPC link.</p>
        pub fn vpc_link_status(mut self, input: crate::model::VpcLinkStatus) -> Self {
            self.vpc_link_status = Some(input);
            self
        }
        /// <p>The status of the VPC link.</p>
        pub fn set_vpc_link_status(
            mut self,
            input: std::option::Option<crate::model::VpcLinkStatus>,
        ) -> Self {
            self.vpc_link_status = input;
            self
        }
        /// <p>A message summarizing the cause of the status of the VPC link.</p>
        pub fn vpc_link_status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_link_status_message = Some(input.into());
            self
        }
        /// <p>A message summarizing the cause of the status of the VPC link.</p>
        pub fn set_vpc_link_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vpc_link_status_message = input;
            self
        }
        /// <p>The version of the VPC link.</p>
        pub fn vpc_link_version(mut self, input: crate::model::VpcLinkVersion) -> Self {
            self.vpc_link_version = Some(input);
            self
        }
        /// <p>The version of the VPC link.</p>
        pub fn set_vpc_link_version(
            mut self,
            input: std::option::Option<crate::model::VpcLinkVersion>,
        ) -> Self {
            self.vpc_link_version = input;
            self
        }
        /// Consumes the builder and constructs a [`GetVpcLinkOutput`](crate::output::GetVpcLinkOutput)
        pub fn build(self) -> crate::output::GetVpcLinkOutput {
            crate::output::GetVpcLinkOutput {
                created_date: self.created_date,
                name: self.name,
                security_group_ids: self.security_group_ids,
                subnet_ids: self.subnet_ids,
                tags: self.tags,
                vpc_link_id: self.vpc_link_id,
                vpc_link_status: self.vpc_link_status,
                vpc_link_status_message: self.vpc_link_status_message,
                vpc_link_version: self.vpc_link_version,
            }
        }
    }
}
impl GetVpcLinkOutput {
    /// Creates a new builder-style object to manufacture [`GetVpcLinkOutput`](crate::output::GetVpcLinkOutput)
    pub fn builder() -> crate::output::get_vpc_link_output::Builder {
        crate::output::get_vpc_link_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTagsOutput {
    /// <p>Represents a collection of tags associated with the resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl GetTagsOutput {
    /// <p>Represents a collection of tags associated with the resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for GetTagsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTagsOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`GetTagsOutput`](crate::output::GetTagsOutput)
pub mod get_tags_output {
    /// A builder for [`GetTagsOutput`](crate::output::GetTagsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Represents a collection of tags associated with the resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Represents a collection of tags associated with the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTagsOutput`](crate::output::GetTagsOutput)
        pub fn build(self) -> crate::output::GetTagsOutput {
            crate::output::GetTagsOutput { tags: self.tags }
        }
    }
}
impl GetTagsOutput {
    /// Creates a new builder-style object to manufacture [`GetTagsOutput`](crate::output::GetTagsOutput)
    pub fn builder() -> crate::output::get_tags_output::Builder {
        crate::output::get_tags_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetStagesOutput {
    /// <p>The elements from this collection.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::Stage>>,
    /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetStagesOutput {
    /// <p>The elements from this collection.</p>
    pub fn items(&self) -> std::option::Option<&[crate::model::Stage]> {
        self.items.as_deref()
    }
    /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetStagesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetStagesOutput");
        formatter.field("items", &self.items);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetStagesOutput`](crate::output::GetStagesOutput)
pub mod get_stages_output {
    /// A builder for [`GetStagesOutput`](crate::output::GetStagesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) items: std::option::Option<std::vec::Vec<crate::model::Stage>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>The elements from this collection.</p>
        pub fn items(mut self, input: impl Into<crate::model::Stage>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>The elements from this collection.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Stage>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetStagesOutput`](crate::output::GetStagesOutput)
        pub fn build(self) -> crate::output::GetStagesOutput {
            crate::output::GetStagesOutput {
                items: self.items,
                next_token: self.next_token,
            }
        }
    }
}
impl GetStagesOutput {
    /// Creates a new builder-style object to manufacture [`GetStagesOutput`](crate::output::GetStagesOutput)
    pub fn builder() -> crate::output::get_stages_output::Builder {
        crate::output::get_stages_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetStageOutput {
    /// <p>Settings for logging access in this stage.</p>
    pub access_log_settings: std::option::Option<crate::model::AccessLogSettings>,
    /// <p>Specifies whether a stage is managed by API Gateway. If you created an API using quick create, the $default stage is managed by API Gateway. You can't modify the $default stage.</p>
    pub api_gateway_managed: bool,
    /// <p>Specifies whether updates to an API automatically trigger a new deployment. The default value is false.</p>
    pub auto_deploy: bool,
    /// <p>The identifier of a client certificate for a Stage. Supported only for WebSocket APIs.</p>
    pub client_certificate_id: std::option::Option<std::string::String>,
    /// <p>The timestamp when the stage was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Default route settings for the stage.</p>
    pub default_route_settings: std::option::Option<crate::model::RouteSettings>,
    /// <p>The identifier of the Deployment that the Stage is associated with. Can't be updated if autoDeploy is enabled.</p>
    pub deployment_id: std::option::Option<std::string::String>,
    /// <p>The description of the stage.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Describes the status of the last deployment of a stage. Supported only for stages with autoDeploy enabled.</p>
    pub last_deployment_status_message: std::option::Option<std::string::String>,
    /// <p>The timestamp when the stage was last updated.</p>
    pub last_updated_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Route settings for the stage, by routeKey.</p>
    pub route_settings: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::RouteSettings>,
    >,
    /// <p>The name of the stage.</p>
    pub stage_name: std::option::Option<std::string::String>,
    /// <p>A map that defines the stage variables for a stage resource. Variable names can have alphanumeric and underscore characters, and the values must match [A-Za-z0-9-._~:/?#&amp;=,]+.</p>
    pub stage_variables:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl GetStageOutput {
    /// <p>Settings for logging access in this stage.</p>
    pub fn access_log_settings(&self) -> std::option::Option<&crate::model::AccessLogSettings> {
        self.access_log_settings.as_ref()
    }
    /// <p>Specifies whether a stage is managed by API Gateway. If you created an API using quick create, the $default stage is managed by API Gateway. You can't modify the $default stage.</p>
    pub fn api_gateway_managed(&self) -> bool {
        self.api_gateway_managed
    }
    /// <p>Specifies whether updates to an API automatically trigger a new deployment. The default value is false.</p>
    pub fn auto_deploy(&self) -> bool {
        self.auto_deploy
    }
    /// <p>The identifier of a client certificate for a Stage. Supported only for WebSocket APIs.</p>
    pub fn client_certificate_id(&self) -> std::option::Option<&str> {
        self.client_certificate_id.as_deref()
    }
    /// <p>The timestamp when the stage was created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_date.as_ref()
    }
    /// <p>Default route settings for the stage.</p>
    pub fn default_route_settings(&self) -> std::option::Option<&crate::model::RouteSettings> {
        self.default_route_settings.as_ref()
    }
    /// <p>The identifier of the Deployment that the Stage is associated with. Can't be updated if autoDeploy is enabled.</p>
    pub fn deployment_id(&self) -> std::option::Option<&str> {
        self.deployment_id.as_deref()
    }
    /// <p>The description of the stage.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Describes the status of the last deployment of a stage. Supported only for stages with autoDeploy enabled.</p>
    pub fn last_deployment_status_message(&self) -> std::option::Option<&str> {
        self.last_deployment_status_message.as_deref()
    }
    /// <p>The timestamp when the stage was last updated.</p>
    pub fn last_updated_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_updated_date.as_ref()
    }
    /// <p>Route settings for the stage, by routeKey.</p>
    pub fn route_settings(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::RouteSettings>,
    > {
        self.route_settings.as_ref()
    }
    /// <p>The name of the stage.</p>
    pub fn stage_name(&self) -> std::option::Option<&str> {
        self.stage_name.as_deref()
    }
    /// <p>A map that defines the stage variables for a stage resource. Variable names can have alphanumeric and underscore characters, and the values must match [A-Za-z0-9-._~:/?#&amp;=,]+.</p>
    pub fn stage_variables(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.stage_variables.as_ref()
    }
    /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for GetStageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetStageOutput");
        formatter.field("access_log_settings", &self.access_log_settings);
        formatter.field("api_gateway_managed", &self.api_gateway_managed);
        formatter.field("auto_deploy", &self.auto_deploy);
        formatter.field("client_certificate_id", &self.client_certificate_id);
        formatter.field("created_date", &self.created_date);
        formatter.field("default_route_settings", &self.default_route_settings);
        formatter.field("deployment_id", &self.deployment_id);
        formatter.field("description", &self.description);
        formatter.field(
            "last_deployment_status_message",
            &self.last_deployment_status_message,
        );
        formatter.field("last_updated_date", &self.last_updated_date);
        formatter.field("route_settings", &self.route_settings);
        formatter.field("stage_name", &self.stage_name);
        formatter.field("stage_variables", &self.stage_variables);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`GetStageOutput`](crate::output::GetStageOutput)
pub mod get_stage_output {
    /// A builder for [`GetStageOutput`](crate::output::GetStageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_log_settings: std::option::Option<crate::model::AccessLogSettings>,
        pub(crate) api_gateway_managed: std::option::Option<bool>,
        pub(crate) auto_deploy: std::option::Option<bool>,
        pub(crate) client_certificate_id: std::option::Option<std::string::String>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) default_route_settings: std::option::Option<crate::model::RouteSettings>,
        pub(crate) deployment_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) last_deployment_status_message: std::option::Option<std::string::String>,
        pub(crate) last_updated_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) route_settings: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::RouteSettings>,
        >,
        pub(crate) stage_name: std::option::Option<std::string::String>,
        pub(crate) stage_variables: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>Settings for logging access in this stage.</p>
        pub fn access_log_settings(mut self, input: crate::model::AccessLogSettings) -> Self {
            self.access_log_settings = Some(input);
            self
        }
        /// <p>Settings for logging access in this stage.</p>
        pub fn set_access_log_settings(
            mut self,
            input: std::option::Option<crate::model::AccessLogSettings>,
        ) -> Self {
            self.access_log_settings = input;
            self
        }
        /// <p>Specifies whether a stage is managed by API Gateway. If you created an API using quick create, the $default stage is managed by API Gateway. You can't modify the $default stage.</p>
        pub fn api_gateway_managed(mut self, input: bool) -> Self {
            self.api_gateway_managed = Some(input);
            self
        }
        /// <p>Specifies whether a stage is managed by API Gateway. If you created an API using quick create, the $default stage is managed by API Gateway. You can't modify the $default stage.</p>
        pub fn set_api_gateway_managed(mut self, input: std::option::Option<bool>) -> Self {
            self.api_gateway_managed = input;
            self
        }
        /// <p>Specifies whether updates to an API automatically trigger a new deployment. The default value is false.</p>
        pub fn auto_deploy(mut self, input: bool) -> Self {
            self.auto_deploy = Some(input);
            self
        }
        /// <p>Specifies whether updates to an API automatically trigger a new deployment. The default value is false.</p>
        pub fn set_auto_deploy(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_deploy = input;
            self
        }
        /// <p>The identifier of a client certificate for a Stage. Supported only for WebSocket APIs.</p>
        pub fn client_certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_certificate_id = Some(input.into());
            self
        }
        /// <p>The identifier of a client certificate for a Stage. Supported only for WebSocket APIs.</p>
        pub fn set_client_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_certificate_id = input;
            self
        }
        /// <p>The timestamp when the stage was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The timestamp when the stage was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>Default route settings for the stage.</p>
        pub fn default_route_settings(mut self, input: crate::model::RouteSettings) -> Self {
            self.default_route_settings = Some(input);
            self
        }
        /// <p>Default route settings for the stage.</p>
        pub fn set_default_route_settings(
            mut self,
            input: std::option::Option<crate::model::RouteSettings>,
        ) -> Self {
            self.default_route_settings = input;
            self
        }
        /// <p>The identifier of the Deployment that the Stage is associated with. Can't be updated if autoDeploy is enabled.</p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Deployment that the Stage is associated with. Can't be updated if autoDeploy is enabled.</p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_id = input;
            self
        }
        /// <p>The description of the stage.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the stage.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Describes the status of the last deployment of a stage. Supported only for stages with autoDeploy enabled.</p>
        pub fn last_deployment_status_message(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.last_deployment_status_message = Some(input.into());
            self
        }
        /// <p>Describes the status of the last deployment of a stage. Supported only for stages with autoDeploy enabled.</p>
        pub fn set_last_deployment_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_deployment_status_message = input;
            self
        }
        /// <p>The timestamp when the stage was last updated.</p>
        pub fn last_updated_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_date = Some(input);
            self
        }
        /// <p>The timestamp when the stage was last updated.</p>
        pub fn set_last_updated_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_date = input;
            self
        }
        /// Adds a key-value pair to `route_settings`.
        ///
        /// To override the contents of this collection use [`set_route_settings`](Self::set_route_settings).
        ///
        /// <p>Route settings for the stage, by routeKey.</p>
        pub fn route_settings(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::RouteSettings>,
        ) -> Self {
            let mut hash_map = self.route_settings.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.route_settings = Some(hash_map);
            self
        }
        /// <p>Route settings for the stage, by routeKey.</p>
        pub fn set_route_settings(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::RouteSettings>,
            >,
        ) -> Self {
            self.route_settings = input;
            self
        }
        /// <p>The name of the stage.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stage_name = Some(input.into());
            self
        }
        /// <p>The name of the stage.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stage_name = input;
            self
        }
        /// Adds a key-value pair to `stage_variables`.
        ///
        /// To override the contents of this collection use [`set_stage_variables`](Self::set_stage_variables).
        ///
        /// <p>A map that defines the stage variables for a stage resource. Variable names can have alphanumeric and underscore characters, and the values must match [A-Za-z0-9-._~:/?#&amp;=,]+.</p>
        pub fn stage_variables(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.stage_variables.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.stage_variables = Some(hash_map);
            self
        }
        /// <p>A map that defines the stage variables for a stage resource. Variable names can have alphanumeric and underscore characters, and the values must match [A-Za-z0-9-._~:/?#&amp;=,]+.</p>
        pub fn set_stage_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.stage_variables = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`GetStageOutput`](crate::output::GetStageOutput)
        pub fn build(self) -> crate::output::GetStageOutput {
            crate::output::GetStageOutput {
                access_log_settings: self.access_log_settings,
                api_gateway_managed: self.api_gateway_managed.unwrap_or_default(),
                auto_deploy: self.auto_deploy.unwrap_or_default(),
                client_certificate_id: self.client_certificate_id,
                created_date: self.created_date,
                default_route_settings: self.default_route_settings,
                deployment_id: self.deployment_id,
                description: self.description,
                last_deployment_status_message: self.last_deployment_status_message,
                last_updated_date: self.last_updated_date,
                route_settings: self.route_settings,
                stage_name: self.stage_name,
                stage_variables: self.stage_variables,
                tags: self.tags,
            }
        }
    }
}
impl GetStageOutput {
    /// Creates a new builder-style object to manufacture [`GetStageOutput`](crate::output::GetStageOutput)
    pub fn builder() -> crate::output::get_stage_output::Builder {
        crate::output::get_stage_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRoutesOutput {
    /// <p>The elements from this collection.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::Route>>,
    /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetRoutesOutput {
    /// <p>The elements from this collection.</p>
    pub fn items(&self) -> std::option::Option<&[crate::model::Route]> {
        self.items.as_deref()
    }
    /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetRoutesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRoutesOutput");
        formatter.field("items", &self.items);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetRoutesOutput`](crate::output::GetRoutesOutput)
pub mod get_routes_output {
    /// A builder for [`GetRoutesOutput`](crate::output::GetRoutesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) items: std::option::Option<std::vec::Vec<crate::model::Route>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>The elements from this collection.</p>
        pub fn items(mut self, input: impl Into<crate::model::Route>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>The elements from this collection.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Route>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRoutesOutput`](crate::output::GetRoutesOutput)
        pub fn build(self) -> crate::output::GetRoutesOutput {
            crate::output::GetRoutesOutput {
                items: self.items,
                next_token: self.next_token,
            }
        }
    }
}
impl GetRoutesOutput {
    /// Creates a new builder-style object to manufacture [`GetRoutesOutput`](crate::output::GetRoutesOutput)
    pub fn builder() -> crate::output::get_routes_output::Builder {
        crate::output::get_routes_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRouteResponsesOutput {
    /// <p>The elements from this collection.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::RouteResponse>>,
    /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetRouteResponsesOutput {
    /// <p>The elements from this collection.</p>
    pub fn items(&self) -> std::option::Option<&[crate::model::RouteResponse]> {
        self.items.as_deref()
    }
    /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetRouteResponsesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRouteResponsesOutput");
        formatter.field("items", &self.items);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetRouteResponsesOutput`](crate::output::GetRouteResponsesOutput)
pub mod get_route_responses_output {
    /// A builder for [`GetRouteResponsesOutput`](crate::output::GetRouteResponsesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) items: std::option::Option<std::vec::Vec<crate::model::RouteResponse>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>The elements from this collection.</p>
        pub fn items(mut self, input: impl Into<crate::model::RouteResponse>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>The elements from this collection.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RouteResponse>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRouteResponsesOutput`](crate::output::GetRouteResponsesOutput)
        pub fn build(self) -> crate::output::GetRouteResponsesOutput {
            crate::output::GetRouteResponsesOutput {
                items: self.items,
                next_token: self.next_token,
            }
        }
    }
}
impl GetRouteResponsesOutput {
    /// Creates a new builder-style object to manufacture [`GetRouteResponsesOutput`](crate::output::GetRouteResponsesOutput)
    pub fn builder() -> crate::output::get_route_responses_output::Builder {
        crate::output::get_route_responses_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRouteResponseOutput {
    /// <p>Represents the model selection expression of a route response. Supported only for WebSocket APIs.</p>
    pub model_selection_expression: std::option::Option<std::string::String>,
    /// <p>Represents the response models of a route response.</p>
    pub response_models:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Represents the response parameters of a route response.</p>
    pub response_parameters: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::ParameterConstraints>,
    >,
    /// <p>Represents the identifier of a route response.</p>
    pub route_response_id: std::option::Option<std::string::String>,
    /// <p>Represents the route response key of a route response.</p>
    pub route_response_key: std::option::Option<std::string::String>,
}
impl GetRouteResponseOutput {
    /// <p>Represents the model selection expression of a route response. Supported only for WebSocket APIs.</p>
    pub fn model_selection_expression(&self) -> std::option::Option<&str> {
        self.model_selection_expression.as_deref()
    }
    /// <p>Represents the response models of a route response.</p>
    pub fn response_models(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.response_models.as_ref()
    }
    /// <p>Represents the response parameters of a route response.</p>
    pub fn response_parameters(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::ParameterConstraints>,
    > {
        self.response_parameters.as_ref()
    }
    /// <p>Represents the identifier of a route response.</p>
    pub fn route_response_id(&self) -> std::option::Option<&str> {
        self.route_response_id.as_deref()
    }
    /// <p>Represents the route response key of a route response.</p>
    pub fn route_response_key(&self) -> std::option::Option<&str> {
        self.route_response_key.as_deref()
    }
}
impl std::fmt::Debug for GetRouteResponseOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRouteResponseOutput");
        formatter.field(
            "model_selection_expression",
            &self.model_selection_expression,
        );
        formatter.field("response_models", &self.response_models);
        formatter.field("response_parameters", &self.response_parameters);
        formatter.field("route_response_id", &self.route_response_id);
        formatter.field("route_response_key", &self.route_response_key);
        formatter.finish()
    }
}
/// See [`GetRouteResponseOutput`](crate::output::GetRouteResponseOutput)
pub mod get_route_response_output {
    /// A builder for [`GetRouteResponseOutput`](crate::output::GetRouteResponseOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) model_selection_expression: std::option::Option<std::string::String>,
        pub(crate) response_models: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) response_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::ParameterConstraints>,
        >,
        pub(crate) route_response_id: std::option::Option<std::string::String>,
        pub(crate) route_response_key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Represents the model selection expression of a route response. Supported only for WebSocket APIs.</p>
        pub fn model_selection_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_selection_expression = Some(input.into());
            self
        }
        /// <p>Represents the model selection expression of a route response. Supported only for WebSocket APIs.</p>
        pub fn set_model_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_selection_expression = input;
            self
        }
        /// Adds a key-value pair to `response_models`.
        ///
        /// To override the contents of this collection use [`set_response_models`](Self::set_response_models).
        ///
        /// <p>Represents the response models of a route response.</p>
        pub fn response_models(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.response_models.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.response_models = Some(hash_map);
            self
        }
        /// <p>Represents the response models of a route response.</p>
        pub fn set_response_models(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.response_models = input;
            self
        }
        /// Adds a key-value pair to `response_parameters`.
        ///
        /// To override the contents of this collection use [`set_response_parameters`](Self::set_response_parameters).
        ///
        /// <p>Represents the response parameters of a route response.</p>
        pub fn response_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::ParameterConstraints>,
        ) -> Self {
            let mut hash_map = self.response_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.response_parameters = Some(hash_map);
            self
        }
        /// <p>Represents the response parameters of a route response.</p>
        pub fn set_response_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::ParameterConstraints>,
            >,
        ) -> Self {
            self.response_parameters = input;
            self
        }
        /// <p>Represents the identifier of a route response.</p>
        pub fn route_response_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_response_id = Some(input.into());
            self
        }
        /// <p>Represents the identifier of a route response.</p>
        pub fn set_route_response_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.route_response_id = input;
            self
        }
        /// <p>Represents the route response key of a route response.</p>
        pub fn route_response_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_response_key = Some(input.into());
            self
        }
        /// <p>Represents the route response key of a route response.</p>
        pub fn set_route_response_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.route_response_key = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRouteResponseOutput`](crate::output::GetRouteResponseOutput)
        pub fn build(self) -> crate::output::GetRouteResponseOutput {
            crate::output::GetRouteResponseOutput {
                model_selection_expression: self.model_selection_expression,
                response_models: self.response_models,
                response_parameters: self.response_parameters,
                route_response_id: self.route_response_id,
                route_response_key: self.route_response_key,
            }
        }
    }
}
impl GetRouteResponseOutput {
    /// Creates a new builder-style object to manufacture [`GetRouteResponseOutput`](crate::output::GetRouteResponseOutput)
    pub fn builder() -> crate::output::get_route_response_output::Builder {
        crate::output::get_route_response_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRouteOutput {
    /// <p>Specifies whether a route is managed by API Gateway. If you created an API using quick create, the $default route is managed by API Gateway. You can't modify the $default route key.</p>
    pub api_gateway_managed: bool,
    /// <p>Specifies whether an API key is required for this route. Supported only for WebSocket APIs.</p>
    pub api_key_required: bool,
    /// <p>A list of authorization scopes configured on a route. The scopes are used with a JWT authorizer to authorize the method invocation. The authorization works by matching the route scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any route scope matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the route scope is configured, the client must provide an access token instead of an identity token for authorization purposes.</p>
    pub authorization_scopes: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The authorization type for the route. For WebSocket APIs, valid values are NONE for open access, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer For HTTP APIs, valid values are NONE for open access, JWT for using JSON Web Tokens, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer.</p>
    pub authorization_type: std::option::Option<crate::model::AuthorizationType>,
    /// <p>The identifier of the Authorizer resource to be associated with this route. The authorizer identifier is generated by API Gateway when you created the authorizer.</p>
    pub authorizer_id: std::option::Option<std::string::String>,
    /// <p>The model selection expression for the route. Supported only for WebSocket APIs.</p>
    pub model_selection_expression: std::option::Option<std::string::String>,
    /// <p>The operation name for the route.</p>
    pub operation_name: std::option::Option<std::string::String>,
    /// <p>The request models for the route. Supported only for WebSocket APIs.</p>
    pub request_models:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The request parameters for the route. Supported only for WebSocket APIs.</p>
    pub request_parameters: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::ParameterConstraints>,
    >,
    /// <p>The route ID.</p>
    pub route_id: std::option::Option<std::string::String>,
    /// <p>The route key for the route.</p>
    pub route_key: std::option::Option<std::string::String>,
    /// <p>The route response selection expression for the route. Supported only for WebSocket APIs.</p>
    pub route_response_selection_expression: std::option::Option<std::string::String>,
    /// <p>The target for the route.</p>
    pub target: std::option::Option<std::string::String>,
}
impl GetRouteOutput {
    /// <p>Specifies whether a route is managed by API Gateway. If you created an API using quick create, the $default route is managed by API Gateway. You can't modify the $default route key.</p>
    pub fn api_gateway_managed(&self) -> bool {
        self.api_gateway_managed
    }
    /// <p>Specifies whether an API key is required for this route. Supported only for WebSocket APIs.</p>
    pub fn api_key_required(&self) -> bool {
        self.api_key_required
    }
    /// <p>A list of authorization scopes configured on a route. The scopes are used with a JWT authorizer to authorize the method invocation. The authorization works by matching the route scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any route scope matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the route scope is configured, the client must provide an access token instead of an identity token for authorization purposes.</p>
    pub fn authorization_scopes(&self) -> std::option::Option<&[std::string::String]> {
        self.authorization_scopes.as_deref()
    }
    /// <p>The authorization type for the route. For WebSocket APIs, valid values are NONE for open access, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer For HTTP APIs, valid values are NONE for open access, JWT for using JSON Web Tokens, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer.</p>
    pub fn authorization_type(&self) -> std::option::Option<&crate::model::AuthorizationType> {
        self.authorization_type.as_ref()
    }
    /// <p>The identifier of the Authorizer resource to be associated with this route. The authorizer identifier is generated by API Gateway when you created the authorizer.</p>
    pub fn authorizer_id(&self) -> std::option::Option<&str> {
        self.authorizer_id.as_deref()
    }
    /// <p>The model selection expression for the route. Supported only for WebSocket APIs.</p>
    pub fn model_selection_expression(&self) -> std::option::Option<&str> {
        self.model_selection_expression.as_deref()
    }
    /// <p>The operation name for the route.</p>
    pub fn operation_name(&self) -> std::option::Option<&str> {
        self.operation_name.as_deref()
    }
    /// <p>The request models for the route. Supported only for WebSocket APIs.</p>
    pub fn request_models(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.request_models.as_ref()
    }
    /// <p>The request parameters for the route. Supported only for WebSocket APIs.</p>
    pub fn request_parameters(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::ParameterConstraints>,
    > {
        self.request_parameters.as_ref()
    }
    /// <p>The route ID.</p>
    pub fn route_id(&self) -> std::option::Option<&str> {
        self.route_id.as_deref()
    }
    /// <p>The route key for the route.</p>
    pub fn route_key(&self) -> std::option::Option<&str> {
        self.route_key.as_deref()
    }
    /// <p>The route response selection expression for the route. Supported only for WebSocket APIs.</p>
    pub fn route_response_selection_expression(&self) -> std::option::Option<&str> {
        self.route_response_selection_expression.as_deref()
    }
    /// <p>The target for the route.</p>
    pub fn target(&self) -> std::option::Option<&str> {
        self.target.as_deref()
    }
}
impl std::fmt::Debug for GetRouteOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRouteOutput");
        formatter.field("api_gateway_managed", &self.api_gateway_managed);
        formatter.field("api_key_required", &self.api_key_required);
        formatter.field("authorization_scopes", &self.authorization_scopes);
        formatter.field("authorization_type", &self.authorization_type);
        formatter.field("authorizer_id", &self.authorizer_id);
        formatter.field(
            "model_selection_expression",
            &self.model_selection_expression,
        );
        formatter.field("operation_name", &self.operation_name);
        formatter.field("request_models", &self.request_models);
        formatter.field("request_parameters", &self.request_parameters);
        formatter.field("route_id", &self.route_id);
        formatter.field("route_key", &self.route_key);
        formatter.field(
            "route_response_selection_expression",
            &self.route_response_selection_expression,
        );
        formatter.field("target", &self.target);
        formatter.finish()
    }
}
/// See [`GetRouteOutput`](crate::output::GetRouteOutput)
pub mod get_route_output {
    /// A builder for [`GetRouteOutput`](crate::output::GetRouteOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_gateway_managed: std::option::Option<bool>,
        pub(crate) api_key_required: std::option::Option<bool>,
        pub(crate) authorization_scopes: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) authorization_type: std::option::Option<crate::model::AuthorizationType>,
        pub(crate) authorizer_id: std::option::Option<std::string::String>,
        pub(crate) model_selection_expression: std::option::Option<std::string::String>,
        pub(crate) operation_name: std::option::Option<std::string::String>,
        pub(crate) request_models: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) request_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::ParameterConstraints>,
        >,
        pub(crate) route_id: std::option::Option<std::string::String>,
        pub(crate) route_key: std::option::Option<std::string::String>,
        pub(crate) route_response_selection_expression: std::option::Option<std::string::String>,
        pub(crate) target: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies whether a route is managed by API Gateway. If you created an API using quick create, the $default route is managed by API Gateway. You can't modify the $default route key.</p>
        pub fn api_gateway_managed(mut self, input: bool) -> Self {
            self.api_gateway_managed = Some(input);
            self
        }
        /// <p>Specifies whether a route is managed by API Gateway. If you created an API using quick create, the $default route is managed by API Gateway. You can't modify the $default route key.</p>
        pub fn set_api_gateway_managed(mut self, input: std::option::Option<bool>) -> Self {
            self.api_gateway_managed = input;
            self
        }
        /// <p>Specifies whether an API key is required for this route. Supported only for WebSocket APIs.</p>
        pub fn api_key_required(mut self, input: bool) -> Self {
            self.api_key_required = Some(input);
            self
        }
        /// <p>Specifies whether an API key is required for this route. Supported only for WebSocket APIs.</p>
        pub fn set_api_key_required(mut self, input: std::option::Option<bool>) -> Self {
            self.api_key_required = input;
            self
        }
        /// Appends an item to `authorization_scopes`.
        ///
        /// To override the contents of this collection use [`set_authorization_scopes`](Self::set_authorization_scopes).
        ///
        /// <p>A list of authorization scopes configured on a route. The scopes are used with a JWT authorizer to authorize the method invocation. The authorization works by matching the route scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any route scope matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the route scope is configured, the client must provide an access token instead of an identity token for authorization purposes.</p>
        pub fn authorization_scopes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.authorization_scopes.unwrap_or_default();
            v.push(input.into());
            self.authorization_scopes = Some(v);
            self
        }
        /// <p>A list of authorization scopes configured on a route. The scopes are used with a JWT authorizer to authorize the method invocation. The authorization works by matching the route scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any route scope matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the route scope is configured, the client must provide an access token instead of an identity token for authorization purposes.</p>
        pub fn set_authorization_scopes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.authorization_scopes = input;
            self
        }
        /// <p>The authorization type for the route. For WebSocket APIs, valid values are NONE for open access, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer For HTTP APIs, valid values are NONE for open access, JWT for using JSON Web Tokens, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer.</p>
        pub fn authorization_type(mut self, input: crate::model::AuthorizationType) -> Self {
            self.authorization_type = Some(input);
            self
        }
        /// <p>The authorization type for the route. For WebSocket APIs, valid values are NONE for open access, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer For HTTP APIs, valid values are NONE for open access, JWT for using JSON Web Tokens, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer.</p>
        pub fn set_authorization_type(
            mut self,
            input: std::option::Option<crate::model::AuthorizationType>,
        ) -> Self {
            self.authorization_type = input;
            self
        }
        /// <p>The identifier of the Authorizer resource to be associated with this route. The authorizer identifier is generated by API Gateway when you created the authorizer.</p>
        pub fn authorizer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorizer_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Authorizer resource to be associated with this route. The authorizer identifier is generated by API Gateway when you created the authorizer.</p>
        pub fn set_authorizer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorizer_id = input;
            self
        }
        /// <p>The model selection expression for the route. Supported only for WebSocket APIs.</p>
        pub fn model_selection_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_selection_expression = Some(input.into());
            self
        }
        /// <p>The model selection expression for the route. Supported only for WebSocket APIs.</p>
        pub fn set_model_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_selection_expression = input;
            self
        }
        /// <p>The operation name for the route.</p>
        pub fn operation_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation_name = Some(input.into());
            self
        }
        /// <p>The operation name for the route.</p>
        pub fn set_operation_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.operation_name = input;
            self
        }
        /// Adds a key-value pair to `request_models`.
        ///
        /// To override the contents of this collection use [`set_request_models`](Self::set_request_models).
        ///
        /// <p>The request models for the route. Supported only for WebSocket APIs.</p>
        pub fn request_models(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.request_models.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.request_models = Some(hash_map);
            self
        }
        /// <p>The request models for the route. Supported only for WebSocket APIs.</p>
        pub fn set_request_models(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.request_models = input;
            self
        }
        /// Adds a key-value pair to `request_parameters`.
        ///
        /// To override the contents of this collection use [`set_request_parameters`](Self::set_request_parameters).
        ///
        /// <p>The request parameters for the route. Supported only for WebSocket APIs.</p>
        pub fn request_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::ParameterConstraints>,
        ) -> Self {
            let mut hash_map = self.request_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.request_parameters = Some(hash_map);
            self
        }
        /// <p>The request parameters for the route. Supported only for WebSocket APIs.</p>
        pub fn set_request_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::ParameterConstraints>,
            >,
        ) -> Self {
            self.request_parameters = input;
            self
        }
        /// <p>The route ID.</p>
        pub fn route_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_id = Some(input.into());
            self
        }
        /// <p>The route ID.</p>
        pub fn set_route_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.route_id = input;
            self
        }
        /// <p>The route key for the route.</p>
        pub fn route_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_key = Some(input.into());
            self
        }
        /// <p>The route key for the route.</p>
        pub fn set_route_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.route_key = input;
            self
        }
        /// <p>The route response selection expression for the route. Supported only for WebSocket APIs.</p>
        pub fn route_response_selection_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.route_response_selection_expression = Some(input.into());
            self
        }
        /// <p>The route response selection expression for the route. Supported only for WebSocket APIs.</p>
        pub fn set_route_response_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.route_response_selection_expression = input;
            self
        }
        /// <p>The target for the route.</p>
        pub fn target(mut self, input: impl Into<std::string::String>) -> Self {
            self.target = Some(input.into());
            self
        }
        /// <p>The target for the route.</p>
        pub fn set_target(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRouteOutput`](crate::output::GetRouteOutput)
        pub fn build(self) -> crate::output::GetRouteOutput {
            crate::output::GetRouteOutput {
                api_gateway_managed: self.api_gateway_managed.unwrap_or_default(),
                api_key_required: self.api_key_required.unwrap_or_default(),
                authorization_scopes: self.authorization_scopes,
                authorization_type: self.authorization_type,
                authorizer_id: self.authorizer_id,
                model_selection_expression: self.model_selection_expression,
                operation_name: self.operation_name,
                request_models: self.request_models,
                request_parameters: self.request_parameters,
                route_id: self.route_id,
                route_key: self.route_key,
                route_response_selection_expression: self.route_response_selection_expression,
                target: self.target,
            }
        }
    }
}
impl GetRouteOutput {
    /// Creates a new builder-style object to manufacture [`GetRouteOutput`](crate::output::GetRouteOutput)
    pub fn builder() -> crate::output::get_route_output::Builder {
        crate::output::get_route_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetModelTemplateOutput {
    /// <p>The template value.</p>
    pub value: std::option::Option<std::string::String>,
}
impl GetModelTemplateOutput {
    /// <p>The template value.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for GetModelTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetModelTemplateOutput");
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`GetModelTemplateOutput`](crate::output::GetModelTemplateOutput)
pub mod get_model_template_output {
    /// A builder for [`GetModelTemplateOutput`](crate::output::GetModelTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The template value.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The template value.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`GetModelTemplateOutput`](crate::output::GetModelTemplateOutput)
        pub fn build(self) -> crate::output::GetModelTemplateOutput {
            crate::output::GetModelTemplateOutput { value: self.value }
        }
    }
}
impl GetModelTemplateOutput {
    /// Creates a new builder-style object to manufacture [`GetModelTemplateOutput`](crate::output::GetModelTemplateOutput)
    pub fn builder() -> crate::output::get_model_template_output::Builder {
        crate::output::get_model_template_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetModelsOutput {
    /// <p>The elements from this collection.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::Model>>,
    /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetModelsOutput {
    /// <p>The elements from this collection.</p>
    pub fn items(&self) -> std::option::Option<&[crate::model::Model]> {
        self.items.as_deref()
    }
    /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetModelsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetModelsOutput");
        formatter.field("items", &self.items);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetModelsOutput`](crate::output::GetModelsOutput)
pub mod get_models_output {
    /// A builder for [`GetModelsOutput`](crate::output::GetModelsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) items: std::option::Option<std::vec::Vec<crate::model::Model>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>The elements from this collection.</p>
        pub fn items(mut self, input: impl Into<crate::model::Model>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>The elements from this collection.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Model>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetModelsOutput`](crate::output::GetModelsOutput)
        pub fn build(self) -> crate::output::GetModelsOutput {
            crate::output::GetModelsOutput {
                items: self.items,
                next_token: self.next_token,
            }
        }
    }
}
impl GetModelsOutput {
    /// Creates a new builder-style object to manufacture [`GetModelsOutput`](crate::output::GetModelsOutput)
    pub fn builder() -> crate::output::get_models_output::Builder {
        crate::output::get_models_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetModelOutput {
    /// <p>The content-type for the model, for example, "application/json".</p>
    pub content_type: std::option::Option<std::string::String>,
    /// <p>The description of the model.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The model identifier.</p>
    pub model_id: std::option::Option<std::string::String>,
    /// <p>The name of the model. Must be alphanumeric.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The schema for the model. For application/json models, this should be JSON schema draft 4 model.</p>
    pub schema: std::option::Option<std::string::String>,
}
impl GetModelOutput {
    /// <p>The content-type for the model, for example, "application/json".</p>
    pub fn content_type(&self) -> std::option::Option<&str> {
        self.content_type.as_deref()
    }
    /// <p>The description of the model.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The model identifier.</p>
    pub fn model_id(&self) -> std::option::Option<&str> {
        self.model_id.as_deref()
    }
    /// <p>The name of the model. Must be alphanumeric.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The schema for the model. For application/json models, this should be JSON schema draft 4 model.</p>
    pub fn schema(&self) -> std::option::Option<&str> {
        self.schema.as_deref()
    }
}
impl std::fmt::Debug for GetModelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetModelOutput");
        formatter.field("content_type", &self.content_type);
        formatter.field("description", &self.description);
        formatter.field("model_id", &self.model_id);
        formatter.field("name", &self.name);
        formatter.field("schema", &self.schema);
        formatter.finish()
    }
}
/// See [`GetModelOutput`](crate::output::GetModelOutput)
pub mod get_model_output {
    /// A builder for [`GetModelOutput`](crate::output::GetModelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) content_type: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) model_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) schema: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The content-type for the model, for example, "application/json".</p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_type = Some(input.into());
            self
        }
        /// <p>The content-type for the model, for example, "application/json".</p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_type = input;
            self
        }
        /// <p>The description of the model.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the model.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The model identifier.</p>
        pub fn model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_id = Some(input.into());
            self
        }
        /// <p>The model identifier.</p>
        pub fn set_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.model_id = input;
            self
        }
        /// <p>The name of the model. Must be alphanumeric.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the model. Must be alphanumeric.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The schema for the model. For application/json models, this should be JSON schema draft 4 model.</p>
        pub fn schema(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema = Some(input.into());
            self
        }
        /// <p>The schema for the model. For application/json models, this should be JSON schema draft 4 model.</p>
        pub fn set_schema(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema = input;
            self
        }
        /// Consumes the builder and constructs a [`GetModelOutput`](crate::output::GetModelOutput)
        pub fn build(self) -> crate::output::GetModelOutput {
            crate::output::GetModelOutput {
                content_type: self.content_type,
                description: self.description,
                model_id: self.model_id,
                name: self.name,
                schema: self.schema,
            }
        }
    }
}
impl GetModelOutput {
    /// Creates a new builder-style object to manufacture [`GetModelOutput`](crate::output::GetModelOutput)
    pub fn builder() -> crate::output::get_model_output::Builder {
        crate::output::get_model_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetIntegrationsOutput {
    /// <p>The elements from this collection.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::Integration>>,
    /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetIntegrationsOutput {
    /// <p>The elements from this collection.</p>
    pub fn items(&self) -> std::option::Option<&[crate::model::Integration]> {
        self.items.as_deref()
    }
    /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetIntegrationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetIntegrationsOutput");
        formatter.field("items", &self.items);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetIntegrationsOutput`](crate::output::GetIntegrationsOutput)
pub mod get_integrations_output {
    /// A builder for [`GetIntegrationsOutput`](crate::output::GetIntegrationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) items: std::option::Option<std::vec::Vec<crate::model::Integration>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>The elements from this collection.</p>
        pub fn items(mut self, input: impl Into<crate::model::Integration>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>The elements from this collection.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Integration>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetIntegrationsOutput`](crate::output::GetIntegrationsOutput)
        pub fn build(self) -> crate::output::GetIntegrationsOutput {
            crate::output::GetIntegrationsOutput {
                items: self.items,
                next_token: self.next_token,
            }
        }
    }
}
impl GetIntegrationsOutput {
    /// Creates a new builder-style object to manufacture [`GetIntegrationsOutput`](crate::output::GetIntegrationsOutput)
    pub fn builder() -> crate::output::get_integrations_output::Builder {
        crate::output::get_integrations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetIntegrationResponsesOutput {
    /// <p>The elements from this collection.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::IntegrationResponse>>,
    /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetIntegrationResponsesOutput {
    /// <p>The elements from this collection.</p>
    pub fn items(&self) -> std::option::Option<&[crate::model::IntegrationResponse]> {
        self.items.as_deref()
    }
    /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetIntegrationResponsesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetIntegrationResponsesOutput");
        formatter.field("items", &self.items);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetIntegrationResponsesOutput`](crate::output::GetIntegrationResponsesOutput)
pub mod get_integration_responses_output {
    /// A builder for [`GetIntegrationResponsesOutput`](crate::output::GetIntegrationResponsesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) items: std::option::Option<std::vec::Vec<crate::model::IntegrationResponse>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>The elements from this collection.</p>
        pub fn items(mut self, input: impl Into<crate::model::IntegrationResponse>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>The elements from this collection.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IntegrationResponse>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetIntegrationResponsesOutput`](crate::output::GetIntegrationResponsesOutput)
        pub fn build(self) -> crate::output::GetIntegrationResponsesOutput {
            crate::output::GetIntegrationResponsesOutput {
                items: self.items,
                next_token: self.next_token,
            }
        }
    }
}
impl GetIntegrationResponsesOutput {
    /// Creates a new builder-style object to manufacture [`GetIntegrationResponsesOutput`](crate::output::GetIntegrationResponsesOutput)
    pub fn builder() -> crate::output::get_integration_responses_output::Builder {
        crate::output::get_integration_responses_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetIntegrationResponseOutput {
    /// <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p> <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p> <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p> <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
    pub content_handling_strategy: std::option::Option<crate::model::ContentHandlingStrategy>,
    /// <p>The integration response ID.</p>
    pub integration_response_id: std::option::Option<std::string::String>,
    /// <p>The integration response key.</p>
    pub integration_response_key: std::option::Option<std::string::String>,
    /// <p>A key-value map specifying response parameters that are passed to the method response from the backend. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of method.response.header.{name}, where name is a valid and unique header name. The mapped non-static value must match the pattern of integration.response.header.{name} or integration.response.body.{JSON-expression}, where name is a valid and unique response header name and JSON-expression is a valid JSON expression without the $ prefix.</p>
    pub response_parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The collection of response templates for the integration response as a string-to-string map of key-value pairs. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.</p>
    pub response_templates:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The template selection expressions for the integration response.</p>
    pub template_selection_expression: std::option::Option<std::string::String>,
}
impl GetIntegrationResponseOutput {
    /// <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p> <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p> <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p> <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
    pub fn content_handling_strategy(
        &self,
    ) -> std::option::Option<&crate::model::ContentHandlingStrategy> {
        self.content_handling_strategy.as_ref()
    }
    /// <p>The integration response ID.</p>
    pub fn integration_response_id(&self) -> std::option::Option<&str> {
        self.integration_response_id.as_deref()
    }
    /// <p>The integration response key.</p>
    pub fn integration_response_key(&self) -> std::option::Option<&str> {
        self.integration_response_key.as_deref()
    }
    /// <p>A key-value map specifying response parameters that are passed to the method response from the backend. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of method.response.header.{name}, where name is a valid and unique header name. The mapped non-static value must match the pattern of integration.response.header.{name} or integration.response.body.{JSON-expression}, where name is a valid and unique response header name and JSON-expression is a valid JSON expression without the $ prefix.</p>
    pub fn response_parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.response_parameters.as_ref()
    }
    /// <p>The collection of response templates for the integration response as a string-to-string map of key-value pairs. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.</p>
    pub fn response_templates(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.response_templates.as_ref()
    }
    /// <p>The template selection expressions for the integration response.</p>
    pub fn template_selection_expression(&self) -> std::option::Option<&str> {
        self.template_selection_expression.as_deref()
    }
}
impl std::fmt::Debug for GetIntegrationResponseOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetIntegrationResponseOutput");
        formatter.field("content_handling_strategy", &self.content_handling_strategy);
        formatter.field("integration_response_id", &self.integration_response_id);
        formatter.field("integration_response_key", &self.integration_response_key);
        formatter.field("response_parameters", &self.response_parameters);
        formatter.field("response_templates", &self.response_templates);
        formatter.field(
            "template_selection_expression",
            &self.template_selection_expression,
        );
        formatter.finish()
    }
}
/// See [`GetIntegrationResponseOutput`](crate::output::GetIntegrationResponseOutput)
pub mod get_integration_response_output {
    /// A builder for [`GetIntegrationResponseOutput`](crate::output::GetIntegrationResponseOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) content_handling_strategy:
            std::option::Option<crate::model::ContentHandlingStrategy>,
        pub(crate) integration_response_id: std::option::Option<std::string::String>,
        pub(crate) integration_response_key: std::option::Option<std::string::String>,
        pub(crate) response_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) response_templates: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) template_selection_expression: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p> <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p> <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p> <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
        pub fn content_handling_strategy(
            mut self,
            input: crate::model::ContentHandlingStrategy,
        ) -> Self {
            self.content_handling_strategy = Some(input);
            self
        }
        /// <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p> <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p> <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p> <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
        pub fn set_content_handling_strategy(
            mut self,
            input: std::option::Option<crate::model::ContentHandlingStrategy>,
        ) -> Self {
            self.content_handling_strategy = input;
            self
        }
        /// <p>The integration response ID.</p>
        pub fn integration_response_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.integration_response_id = Some(input.into());
            self
        }
        /// <p>The integration response ID.</p>
        pub fn set_integration_response_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.integration_response_id = input;
            self
        }
        /// <p>The integration response key.</p>
        pub fn integration_response_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.integration_response_key = Some(input.into());
            self
        }
        /// <p>The integration response key.</p>
        pub fn set_integration_response_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.integration_response_key = input;
            self
        }
        /// Adds a key-value pair to `response_parameters`.
        ///
        /// To override the contents of this collection use [`set_response_parameters`](Self::set_response_parameters).
        ///
        /// <p>A key-value map specifying response parameters that are passed to the method response from the backend. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of method.response.header.{name}, where name is a valid and unique header name. The mapped non-static value must match the pattern of integration.response.header.{name} or integration.response.body.{JSON-expression}, where name is a valid and unique response header name and JSON-expression is a valid JSON expression without the $ prefix.</p>
        pub fn response_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.response_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.response_parameters = Some(hash_map);
            self
        }
        /// <p>A key-value map specifying response parameters that are passed to the method response from the backend. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of method.response.header.{name}, where name is a valid and unique header name. The mapped non-static value must match the pattern of integration.response.header.{name} or integration.response.body.{JSON-expression}, where name is a valid and unique response header name and JSON-expression is a valid JSON expression without the $ prefix.</p>
        pub fn set_response_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.response_parameters = input;
            self
        }
        /// Adds a key-value pair to `response_templates`.
        ///
        /// To override the contents of this collection use [`set_response_templates`](Self::set_response_templates).
        ///
        /// <p>The collection of response templates for the integration response as a string-to-string map of key-value pairs. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.</p>
        pub fn response_templates(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.response_templates.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.response_templates = Some(hash_map);
            self
        }
        /// <p>The collection of response templates for the integration response as a string-to-string map of key-value pairs. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.</p>
        pub fn set_response_templates(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.response_templates = input;
            self
        }
        /// <p>The template selection expressions for the integration response.</p>
        pub fn template_selection_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.template_selection_expression = Some(input.into());
            self
        }
        /// <p>The template selection expressions for the integration response.</p>
        pub fn set_template_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_selection_expression = input;
            self
        }
        /// Consumes the builder and constructs a [`GetIntegrationResponseOutput`](crate::output::GetIntegrationResponseOutput)
        pub fn build(self) -> crate::output::GetIntegrationResponseOutput {
            crate::output::GetIntegrationResponseOutput {
                content_handling_strategy: self.content_handling_strategy,
                integration_response_id: self.integration_response_id,
                integration_response_key: self.integration_response_key,
                response_parameters: self.response_parameters,
                response_templates: self.response_templates,
                template_selection_expression: self.template_selection_expression,
            }
        }
    }
}
impl GetIntegrationResponseOutput {
    /// Creates a new builder-style object to manufacture [`GetIntegrationResponseOutput`](crate::output::GetIntegrationResponseOutput)
    pub fn builder() -> crate::output::get_integration_response_output::Builder {
        crate::output::get_integration_response_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetIntegrationOutput {
    /// <p>Specifies whether an integration is managed by API Gateway. If you created an API using using quick create, the resulting integration is managed by API Gateway. You can update a managed integration, but you can't delete it.</p>
    pub api_gateway_managed: bool,
    /// <p>The ID of the VPC link for a private integration. Supported only for HTTP APIs.</p>
    pub connection_id: std::option::Option<std::string::String>,
    /// <p>The type of the network connection to the integration endpoint. Specify INTERNET for connections through the public routable internet or VPC_LINK for private connections between API Gateway and resources in a VPC. The default value is INTERNET.</p>
    pub connection_type: std::option::Option<crate::model::ConnectionType>,
    /// <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p> <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p> <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p> <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
    pub content_handling_strategy: std::option::Option<crate::model::ContentHandlingStrategy>,
    /// <p>Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, specify null.</p>
    pub credentials_arn: std::option::Option<std::string::String>,
    /// <p>Represents the description of an integration.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Represents the identifier of an integration.</p>
    pub integration_id: std::option::Option<std::string::String>,
    /// <p>Specifies the integration's HTTP method type.</p>
    pub integration_method: std::option::Option<std::string::String>,
    /// <p>The integration response selection expression for the integration. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-integration-response-selection-expressions">Integration Response Selection Expressions</a>.</p>
    pub integration_response_selection_expression: std::option::Option<std::string::String>,
    /// <p>Supported only for HTTP API AWS_PROXY integrations. Specifies the AWS service action to invoke. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html">Integration subtype reference</a>.</p>
    pub integration_subtype: std::option::Option<std::string::String>,
    /// <p>The integration type of an integration. One of the following:</p> <p>AWS: for integrating the route or method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration. Supported only for WebSocket APIs.</p> <p>AWS_PROXY: for integrating the route or method request with a Lambda function or other AWS service action. This integration is also referred to as a Lambda proxy integration.</p> <p>HTTP: for integrating the route or method request with an HTTP endpoint. This integration is also referred to as the HTTP custom integration. Supported only for WebSocket APIs.</p> <p>HTTP_PROXY: for integrating the route or method request with an HTTP endpoint, with the client request passed through as-is. This is also referred to as HTTP proxy integration.</p> <p>MOCK: for integrating the route or method request with API Gateway as a "loopback" endpoint without invoking any backend. Supported only for WebSocket APIs.</p>
    pub integration_type: std::option::Option<crate::model::IntegrationType>,
    /// <p>For a Lambda integration, specify the URI of a Lambda function.</p> <p>For an HTTP integration, specify a fully-qualified URL.</p> <p>For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service. If you specify the ARN of an AWS Cloud Map service, API Gateway uses DiscoverInstances to identify resources. You can use query parameters to target specific resources. To learn more, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_DiscoverInstances.html">DiscoverInstances</a>. For private integrations, all resources must be owned by the same AWS account.</p>
    pub integration_uri: std::option::Option<std::string::String>,
    /// <p>Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER. Supported only for WebSocket APIs.</p> <p>WHEN_NO_MATCH passes the request body for unmapped content types through to the integration backend without transformation.</p> <p>NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type response.</p> <p>WHEN_NO_TEMPLATES allows pass-through when the integration has no content types mapped to templates. However, if there is at least one content type defined, unmapped content types will be rejected with the same HTTP 415 Unsupported Media Type response.</p>
    pub passthrough_behavior: std::option::Option<crate::model::PassthroughBehavior>,
    /// <p>Specifies the format of the payload sent to an integration. Required for HTTP APIs.</p>
    pub payload_format_version: std::option::Option<std::string::String>,
    /// <p>For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the backend. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the backend. The method request parameter value must match the pattern of method.request.<replaceable>{location}</replaceable>.<replaceable>{name}</replaceable>
    /// , where
    /// <replaceable>{location}</replaceable>
    /// is querystring, path, or header; and
    /// <replaceable>{name}</replaceable>
    /// must be a valid and unique method request parameter name.</p> <p>For HTTP API integrations with a specified integrationSubtype, request parameters are a key-value map specifying parameters that are passed to AWS_PROXY integrations. You can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services.html">Working with AWS service integrations for HTTP APIs</a>.</p> <p>For HTTP API itegrations, without a specified integrationSubtype request parameters are a key-value map specifying how to transform HTTP requests before sending them to backend integrations. The key should follow the pattern &lt;action&gt;:&lt;header|querystring|path&gt;.&lt;location&gt;. The action can be append, overwrite or remove. For values, you can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
    pub request_parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value. Supported only for WebSocket APIs.</p>
    pub request_templates:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Supported only for HTTP APIs. You use response parameters to transform the HTTP response from a backend integration before returning the response to clients. Specify a key-value map from a selection key to response parameters. The selection key must be a valid HTTP status code within the range of 200-599. Response parameters are a key-value map. The key must match pattern &lt;action&gt;:&lt;header&gt;.&lt;location&gt; or overwrite.statuscode. The action can be append, overwrite or remove. The value can be a static value, or map to response data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
    pub response_parameters: std::option::Option<
        std::collections::HashMap<
            std::string::String,
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    >,
    /// <p>The template selection expression for the integration. Supported only for WebSocket APIs.</p>
    pub template_selection_expression: std::option::Option<std::string::String>,
    /// <p>Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs. The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.</p>
    pub timeout_in_millis: i32,
    /// <p>The TLS configuration for a private integration. If you specify a TLS configuration, private integration traffic uses the HTTPS protocol. Supported only for HTTP APIs.</p>
    pub tls_config: std::option::Option<crate::model::TlsConfig>,
}
impl GetIntegrationOutput {
    /// <p>Specifies whether an integration is managed by API Gateway. If you created an API using using quick create, the resulting integration is managed by API Gateway. You can update a managed integration, but you can't delete it.</p>
    pub fn api_gateway_managed(&self) -> bool {
        self.api_gateway_managed
    }
    /// <p>The ID of the VPC link for a private integration. Supported only for HTTP APIs.</p>
    pub fn connection_id(&self) -> std::option::Option<&str> {
        self.connection_id.as_deref()
    }
    /// <p>The type of the network connection to the integration endpoint. Specify INTERNET for connections through the public routable internet or VPC_LINK for private connections between API Gateway and resources in a VPC. The default value is INTERNET.</p>
    pub fn connection_type(&self) -> std::option::Option<&crate::model::ConnectionType> {
        self.connection_type.as_ref()
    }
    /// <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p> <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p> <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p> <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
    pub fn content_handling_strategy(
        &self,
    ) -> std::option::Option<&crate::model::ContentHandlingStrategy> {
        self.content_handling_strategy.as_ref()
    }
    /// <p>Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, specify null.</p>
    pub fn credentials_arn(&self) -> std::option::Option<&str> {
        self.credentials_arn.as_deref()
    }
    /// <p>Represents the description of an integration.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Represents the identifier of an integration.</p>
    pub fn integration_id(&self) -> std::option::Option<&str> {
        self.integration_id.as_deref()
    }
    /// <p>Specifies the integration's HTTP method type.</p>
    pub fn integration_method(&self) -> std::option::Option<&str> {
        self.integration_method.as_deref()
    }
    /// <p>The integration response selection expression for the integration. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-integration-response-selection-expressions">Integration Response Selection Expressions</a>.</p>
    pub fn integration_response_selection_expression(&self) -> std::option::Option<&str> {
        self.integration_response_selection_expression.as_deref()
    }
    /// <p>Supported only for HTTP API AWS_PROXY integrations. Specifies the AWS service action to invoke. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html">Integration subtype reference</a>.</p>
    pub fn integration_subtype(&self) -> std::option::Option<&str> {
        self.integration_subtype.as_deref()
    }
    /// <p>The integration type of an integration. One of the following:</p> <p>AWS: for integrating the route or method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration. Supported only for WebSocket APIs.</p> <p>AWS_PROXY: for integrating the route or method request with a Lambda function or other AWS service action. This integration is also referred to as a Lambda proxy integration.</p> <p>HTTP: for integrating the route or method request with an HTTP endpoint. This integration is also referred to as the HTTP custom integration. Supported only for WebSocket APIs.</p> <p>HTTP_PROXY: for integrating the route or method request with an HTTP endpoint, with the client request passed through as-is. This is also referred to as HTTP proxy integration.</p> <p>MOCK: for integrating the route or method request with API Gateway as a "loopback" endpoint without invoking any backend. Supported only for WebSocket APIs.</p>
    pub fn integration_type(&self) -> std::option::Option<&crate::model::IntegrationType> {
        self.integration_type.as_ref()
    }
    /// <p>For a Lambda integration, specify the URI of a Lambda function.</p> <p>For an HTTP integration, specify a fully-qualified URL.</p> <p>For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service. If you specify the ARN of an AWS Cloud Map service, API Gateway uses DiscoverInstances to identify resources. You can use query parameters to target specific resources. To learn more, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_DiscoverInstances.html">DiscoverInstances</a>. For private integrations, all resources must be owned by the same AWS account.</p>
    pub fn integration_uri(&self) -> std::option::Option<&str> {
        self.integration_uri.as_deref()
    }
    /// <p>Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER. Supported only for WebSocket APIs.</p> <p>WHEN_NO_MATCH passes the request body for unmapped content types through to the integration backend without transformation.</p> <p>NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type response.</p> <p>WHEN_NO_TEMPLATES allows pass-through when the integration has no content types mapped to templates. However, if there is at least one content type defined, unmapped content types will be rejected with the same HTTP 415 Unsupported Media Type response.</p>
    pub fn passthrough_behavior(&self) -> std::option::Option<&crate::model::PassthroughBehavior> {
        self.passthrough_behavior.as_ref()
    }
    /// <p>Specifies the format of the payload sent to an integration. Required for HTTP APIs.</p>
    pub fn payload_format_version(&self) -> std::option::Option<&str> {
        self.payload_format_version.as_deref()
    }
    /// <p>For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the backend. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the backend. The method request parameter value must match the pattern of method.request.<replaceable>{location}</replaceable>.<replaceable>{name}</replaceable>
    /// , where
    /// <replaceable>{location}</replaceable>
    /// is querystring, path, or header; and
    /// <replaceable>{name}</replaceable>
    /// must be a valid and unique method request parameter name.</p> <p>For HTTP API integrations with a specified integrationSubtype, request parameters are a key-value map specifying parameters that are passed to AWS_PROXY integrations. You can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services.html">Working with AWS service integrations for HTTP APIs</a>.</p> <p>For HTTP API itegrations, without a specified integrationSubtype request parameters are a key-value map specifying how to transform HTTP requests before sending them to backend integrations. The key should follow the pattern &lt;action&gt;:&lt;header|querystring|path&gt;.&lt;location&gt;. The action can be append, overwrite or remove. For values, you can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
    pub fn request_parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.request_parameters.as_ref()
    }
    /// <p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value. Supported only for WebSocket APIs.</p>
    pub fn request_templates(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.request_templates.as_ref()
    }
    /// <p>Supported only for HTTP APIs. You use response parameters to transform the HTTP response from a backend integration before returning the response to clients. Specify a key-value map from a selection key to response parameters. The selection key must be a valid HTTP status code within the range of 200-599. Response parameters are a key-value map. The key must match pattern &lt;action&gt;:&lt;header&gt;.&lt;location&gt; or overwrite.statuscode. The action can be append, overwrite or remove. The value can be a static value, or map to response data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
    pub fn response_parameters(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<
            std::string::String,
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    > {
        self.response_parameters.as_ref()
    }
    /// <p>The template selection expression for the integration. Supported only for WebSocket APIs.</p>
    pub fn template_selection_expression(&self) -> std::option::Option<&str> {
        self.template_selection_expression.as_deref()
    }
    /// <p>Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs. The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.</p>
    pub fn timeout_in_millis(&self) -> i32 {
        self.timeout_in_millis
    }
    /// <p>The TLS configuration for a private integration. If you specify a TLS configuration, private integration traffic uses the HTTPS protocol. Supported only for HTTP APIs.</p>
    pub fn tls_config(&self) -> std::option::Option<&crate::model::TlsConfig> {
        self.tls_config.as_ref()
    }
}
impl std::fmt::Debug for GetIntegrationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetIntegrationOutput");
        formatter.field("api_gateway_managed", &self.api_gateway_managed);
        formatter.field("connection_id", &self.connection_id);
        formatter.field("connection_type", &self.connection_type);
        formatter.field("content_handling_strategy", &self.content_handling_strategy);
        formatter.field("credentials_arn", &self.credentials_arn);
        formatter.field("description", &self.description);
        formatter.field("integration_id", &self.integration_id);
        formatter.field("integration_method", &self.integration_method);
        formatter.field(
            "integration_response_selection_expression",
            &self.integration_response_selection_expression,
        );
        formatter.field("integration_subtype", &self.integration_subtype);
        formatter.field("integration_type", &self.integration_type);
        formatter.field("integration_uri", &self.integration_uri);
        formatter.field("passthrough_behavior", &self.passthrough_behavior);
        formatter.field("payload_format_version", &self.payload_format_version);
        formatter.field("request_parameters", &self.request_parameters);
        formatter.field("request_templates", &self.request_templates);
        formatter.field("response_parameters", &self.response_parameters);
        formatter.field(
            "template_selection_expression",
            &self.template_selection_expression,
        );
        formatter.field("timeout_in_millis", &self.timeout_in_millis);
        formatter.field("tls_config", &self.tls_config);
        formatter.finish()
    }
}
/// See [`GetIntegrationOutput`](crate::output::GetIntegrationOutput)
pub mod get_integration_output {
    /// A builder for [`GetIntegrationOutput`](crate::output::GetIntegrationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_gateway_managed: std::option::Option<bool>,
        pub(crate) connection_id: std::option::Option<std::string::String>,
        pub(crate) connection_type: std::option::Option<crate::model::ConnectionType>,
        pub(crate) content_handling_strategy:
            std::option::Option<crate::model::ContentHandlingStrategy>,
        pub(crate) credentials_arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) integration_id: std::option::Option<std::string::String>,
        pub(crate) integration_method: std::option::Option<std::string::String>,
        pub(crate) integration_response_selection_expression:
            std::option::Option<std::string::String>,
        pub(crate) integration_subtype: std::option::Option<std::string::String>,
        pub(crate) integration_type: std::option::Option<crate::model::IntegrationType>,
        pub(crate) integration_uri: std::option::Option<std::string::String>,
        pub(crate) passthrough_behavior: std::option::Option<crate::model::PassthroughBehavior>,
        pub(crate) payload_format_version: std::option::Option<std::string::String>,
        pub(crate) request_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) request_templates: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) response_parameters: std::option::Option<
            std::collections::HashMap<
                std::string::String,
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        >,
        pub(crate) template_selection_expression: std::option::Option<std::string::String>,
        pub(crate) timeout_in_millis: std::option::Option<i32>,
        pub(crate) tls_config: std::option::Option<crate::model::TlsConfig>,
    }
    impl Builder {
        /// <p>Specifies whether an integration is managed by API Gateway. If you created an API using using quick create, the resulting integration is managed by API Gateway. You can update a managed integration, but you can't delete it.</p>
        pub fn api_gateway_managed(mut self, input: bool) -> Self {
            self.api_gateway_managed = Some(input);
            self
        }
        /// <p>Specifies whether an integration is managed by API Gateway. If you created an API using using quick create, the resulting integration is managed by API Gateway. You can update a managed integration, but you can't delete it.</p>
        pub fn set_api_gateway_managed(mut self, input: std::option::Option<bool>) -> Self {
            self.api_gateway_managed = input;
            self
        }
        /// <p>The ID of the VPC link for a private integration. Supported only for HTTP APIs.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_id = Some(input.into());
            self
        }
        /// <p>The ID of the VPC link for a private integration. Supported only for HTTP APIs.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_id = input;
            self
        }
        /// <p>The type of the network connection to the integration endpoint. Specify INTERNET for connections through the public routable internet or VPC_LINK for private connections between API Gateway and resources in a VPC. The default value is INTERNET.</p>
        pub fn connection_type(mut self, input: crate::model::ConnectionType) -> Self {
            self.connection_type = Some(input);
            self
        }
        /// <p>The type of the network connection to the integration endpoint. Specify INTERNET for connections through the public routable internet or VPC_LINK for private connections between API Gateway and resources in a VPC. The default value is INTERNET.</p>
        pub fn set_connection_type(
            mut self,
            input: std::option::Option<crate::model::ConnectionType>,
        ) -> Self {
            self.connection_type = input;
            self
        }
        /// <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p> <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p> <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p> <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
        pub fn content_handling_strategy(
            mut self,
            input: crate::model::ContentHandlingStrategy,
        ) -> Self {
            self.content_handling_strategy = Some(input);
            self
        }
        /// <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p> <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p> <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p> <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
        pub fn set_content_handling_strategy(
            mut self,
            input: std::option::Option<crate::model::ContentHandlingStrategy>,
        ) -> Self {
            self.content_handling_strategy = input;
            self
        }
        /// <p>Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, specify null.</p>
        pub fn credentials_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.credentials_arn = Some(input.into());
            self
        }
        /// <p>Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, specify null.</p>
        pub fn set_credentials_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.credentials_arn = input;
            self
        }
        /// <p>Represents the description of an integration.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Represents the description of an integration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Represents the identifier of an integration.</p>
        pub fn integration_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.integration_id = Some(input.into());
            self
        }
        /// <p>Represents the identifier of an integration.</p>
        pub fn set_integration_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.integration_id = input;
            self
        }
        /// <p>Specifies the integration's HTTP method type.</p>
        pub fn integration_method(mut self, input: impl Into<std::string::String>) -> Self {
            self.integration_method = Some(input.into());
            self
        }
        /// <p>Specifies the integration's HTTP method type.</p>
        pub fn set_integration_method(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.integration_method = input;
            self
        }
        /// <p>The integration response selection expression for the integration. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-integration-response-selection-expressions">Integration Response Selection Expressions</a>.</p>
        pub fn integration_response_selection_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.integration_response_selection_expression = Some(input.into());
            self
        }
        /// <p>The integration response selection expression for the integration. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-integration-response-selection-expressions">Integration Response Selection Expressions</a>.</p>
        pub fn set_integration_response_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.integration_response_selection_expression = input;
            self
        }
        /// <p>Supported only for HTTP API AWS_PROXY integrations. Specifies the AWS service action to invoke. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html">Integration subtype reference</a>.</p>
        pub fn integration_subtype(mut self, input: impl Into<std::string::String>) -> Self {
            self.integration_subtype = Some(input.into());
            self
        }
        /// <p>Supported only for HTTP API AWS_PROXY integrations. Specifies the AWS service action to invoke. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html">Integration subtype reference</a>.</p>
        pub fn set_integration_subtype(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.integration_subtype = input;
            self
        }
        /// <p>The integration type of an integration. One of the following:</p> <p>AWS: for integrating the route or method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration. Supported only for WebSocket APIs.</p> <p>AWS_PROXY: for integrating the route or method request with a Lambda function or other AWS service action. This integration is also referred to as a Lambda proxy integration.</p> <p>HTTP: for integrating the route or method request with an HTTP endpoint. This integration is also referred to as the HTTP custom integration. Supported only for WebSocket APIs.</p> <p>HTTP_PROXY: for integrating the route or method request with an HTTP endpoint, with the client request passed through as-is. This is also referred to as HTTP proxy integration.</p> <p>MOCK: for integrating the route or method request with API Gateway as a "loopback" endpoint without invoking any backend. Supported only for WebSocket APIs.</p>
        pub fn integration_type(mut self, input: crate::model::IntegrationType) -> Self {
            self.integration_type = Some(input);
            self
        }
        /// <p>The integration type of an integration. One of the following:</p> <p>AWS: for integrating the route or method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration. Supported only for WebSocket APIs.</p> <p>AWS_PROXY: for integrating the route or method request with a Lambda function or other AWS service action. This integration is also referred to as a Lambda proxy integration.</p> <p>HTTP: for integrating the route or method request with an HTTP endpoint. This integration is also referred to as the HTTP custom integration. Supported only for WebSocket APIs.</p> <p>HTTP_PROXY: for integrating the route or method request with an HTTP endpoint, with the client request passed through as-is. This is also referred to as HTTP proxy integration.</p> <p>MOCK: for integrating the route or method request with API Gateway as a "loopback" endpoint without invoking any backend. Supported only for WebSocket APIs.</p>
        pub fn set_integration_type(
            mut self,
            input: std::option::Option<crate::model::IntegrationType>,
        ) -> Self {
            self.integration_type = input;
            self
        }
        /// <p>For a Lambda integration, specify the URI of a Lambda function.</p> <p>For an HTTP integration, specify a fully-qualified URL.</p> <p>For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service. If you specify the ARN of an AWS Cloud Map service, API Gateway uses DiscoverInstances to identify resources. You can use query parameters to target specific resources. To learn more, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_DiscoverInstances.html">DiscoverInstances</a>. For private integrations, all resources must be owned by the same AWS account.</p>
        pub fn integration_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.integration_uri = Some(input.into());
            self
        }
        /// <p>For a Lambda integration, specify the URI of a Lambda function.</p> <p>For an HTTP integration, specify a fully-qualified URL.</p> <p>For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service. If you specify the ARN of an AWS Cloud Map service, API Gateway uses DiscoverInstances to identify resources. You can use query parameters to target specific resources. To learn more, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_DiscoverInstances.html">DiscoverInstances</a>. For private integrations, all resources must be owned by the same AWS account.</p>
        pub fn set_integration_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.integration_uri = input;
            self
        }
        /// <p>Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER. Supported only for WebSocket APIs.</p> <p>WHEN_NO_MATCH passes the request body for unmapped content types through to the integration backend without transformation.</p> <p>NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type response.</p> <p>WHEN_NO_TEMPLATES allows pass-through when the integration has no content types mapped to templates. However, if there is at least one content type defined, unmapped content types will be rejected with the same HTTP 415 Unsupported Media Type response.</p>
        pub fn passthrough_behavior(mut self, input: crate::model::PassthroughBehavior) -> Self {
            self.passthrough_behavior = Some(input);
            self
        }
        /// <p>Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER. Supported only for WebSocket APIs.</p> <p>WHEN_NO_MATCH passes the request body for unmapped content types through to the integration backend without transformation.</p> <p>NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type response.</p> <p>WHEN_NO_TEMPLATES allows pass-through when the integration has no content types mapped to templates. However, if there is at least one content type defined, unmapped content types will be rejected with the same HTTP 415 Unsupported Media Type response.</p>
        pub fn set_passthrough_behavior(
            mut self,
            input: std::option::Option<crate::model::PassthroughBehavior>,
        ) -> Self {
            self.passthrough_behavior = input;
            self
        }
        /// <p>Specifies the format of the payload sent to an integration. Required for HTTP APIs.</p>
        pub fn payload_format_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.payload_format_version = Some(input.into());
            self
        }
        /// <p>Specifies the format of the payload sent to an integration. Required for HTTP APIs.</p>
        pub fn set_payload_format_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.payload_format_version = input;
            self
        }
        /// Adds a key-value pair to `request_parameters`.
        ///
        /// To override the contents of this collection use [`set_request_parameters`](Self::set_request_parameters).
        ///
        /// <p>For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the backend. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the backend. The method request parameter value must match the pattern of method.request.<replaceable>{location}</replaceable>.<replaceable>{name}</replaceable>
        /// , where
        /// <replaceable>{location}</replaceable>
        /// is querystring, path, or header; and
        /// <replaceable>{name}</replaceable>
        /// must be a valid and unique method request parameter name.</p> <p>For HTTP API integrations with a specified integrationSubtype, request parameters are a key-value map specifying parameters that are passed to AWS_PROXY integrations. You can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services.html">Working with AWS service integrations for HTTP APIs</a>.</p> <p>For HTTP API itegrations, without a specified integrationSubtype request parameters are a key-value map specifying how to transform HTTP requests before sending them to backend integrations. The key should follow the pattern &lt;action&gt;:&lt;header|querystring|path&gt;.&lt;location&gt;. The action can be append, overwrite or remove. For values, you can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
        pub fn request_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.request_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.request_parameters = Some(hash_map);
            self
        }
        /// <p>For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the backend. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the backend. The method request parameter value must match the pattern of method.request.<replaceable>{location}</replaceable>.<replaceable>{name}</replaceable>
        /// , where
        /// <replaceable>{location}</replaceable>
        /// is querystring, path, or header; and
        /// <replaceable>{name}</replaceable>
        /// must be a valid and unique method request parameter name.</p> <p>For HTTP API integrations with a specified integrationSubtype, request parameters are a key-value map specifying parameters that are passed to AWS_PROXY integrations. You can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services.html">Working with AWS service integrations for HTTP APIs</a>.</p> <p>For HTTP API itegrations, without a specified integrationSubtype request parameters are a key-value map specifying how to transform HTTP requests before sending them to backend integrations. The key should follow the pattern &lt;action&gt;:&lt;header|querystring|path&gt;.&lt;location&gt;. The action can be append, overwrite or remove. For values, you can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
        pub fn set_request_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.request_parameters = input;
            self
        }
        /// Adds a key-value pair to `request_templates`.
        ///
        /// To override the contents of this collection use [`set_request_templates`](Self::set_request_templates).
        ///
        /// <p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value. Supported only for WebSocket APIs.</p>
        pub fn request_templates(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.request_templates.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.request_templates = Some(hash_map);
            self
        }
        /// <p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value. Supported only for WebSocket APIs.</p>
        pub fn set_request_templates(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.request_templates = input;
            self
        }
        /// Adds a key-value pair to `response_parameters`.
        ///
        /// To override the contents of this collection use [`set_response_parameters`](Self::set_response_parameters).
        ///
        /// <p>Supported only for HTTP APIs. You use response parameters to transform the HTTP response from a backend integration before returning the response to clients. Specify a key-value map from a selection key to response parameters. The selection key must be a valid HTTP status code within the range of 200-599. Response parameters are a key-value map. The key must match pattern &lt;action&gt;:&lt;header&gt;.&lt;location&gt; or overwrite.statuscode. The action can be append, overwrite or remove. The value can be a static value, or map to response data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
        pub fn response_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::collections::HashMap<std::string::String, std::string::String>>,
        ) -> Self {
            let mut hash_map = self.response_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.response_parameters = Some(hash_map);
            self
        }
        /// <p>Supported only for HTTP APIs. You use response parameters to transform the HTTP response from a backend integration before returning the response to clients. Specify a key-value map from a selection key to response parameters. The selection key must be a valid HTTP status code within the range of 200-599. Response parameters are a key-value map. The key must match pattern &lt;action&gt;:&lt;header&gt;.&lt;location&gt; or overwrite.statuscode. The action can be append, overwrite or remove. The value can be a static value, or map to response data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
        pub fn set_response_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    std::collections::HashMap<std::string::String, std::string::String>,
                >,
            >,
        ) -> Self {
            self.response_parameters = input;
            self
        }
        /// <p>The template selection expression for the integration. Supported only for WebSocket APIs.</p>
        pub fn template_selection_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.template_selection_expression = Some(input.into());
            self
        }
        /// <p>The template selection expression for the integration. Supported only for WebSocket APIs.</p>
        pub fn set_template_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_selection_expression = input;
            self
        }
        /// <p>Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs. The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.</p>
        pub fn timeout_in_millis(mut self, input: i32) -> Self {
            self.timeout_in_millis = Some(input);
            self
        }
        /// <p>Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs. The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.</p>
        pub fn set_timeout_in_millis(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout_in_millis = input;
            self
        }
        /// <p>The TLS configuration for a private integration. If you specify a TLS configuration, private integration traffic uses the HTTPS protocol. Supported only for HTTP APIs.</p>
        pub fn tls_config(mut self, input: crate::model::TlsConfig) -> Self {
            self.tls_config = Some(input);
            self
        }
        /// <p>The TLS configuration for a private integration. If you specify a TLS configuration, private integration traffic uses the HTTPS protocol. Supported only for HTTP APIs.</p>
        pub fn set_tls_config(
            mut self,
            input: std::option::Option<crate::model::TlsConfig>,
        ) -> Self {
            self.tls_config = input;
            self
        }
        /// Consumes the builder and constructs a [`GetIntegrationOutput`](crate::output::GetIntegrationOutput)
        pub fn build(self) -> crate::output::GetIntegrationOutput {
            crate::output::GetIntegrationOutput {
                api_gateway_managed: self.api_gateway_managed.unwrap_or_default(),
                connection_id: self.connection_id,
                connection_type: self.connection_type,
                content_handling_strategy: self.content_handling_strategy,
                credentials_arn: self.credentials_arn,
                description: self.description,
                integration_id: self.integration_id,
                integration_method: self.integration_method,
                integration_response_selection_expression: self
                    .integration_response_selection_expression,
                integration_subtype: self.integration_subtype,
                integration_type: self.integration_type,
                integration_uri: self.integration_uri,
                passthrough_behavior: self.passthrough_behavior,
                payload_format_version: self.payload_format_version,
                request_parameters: self.request_parameters,
                request_templates: self.request_templates,
                response_parameters: self.response_parameters,
                template_selection_expression: self.template_selection_expression,
                timeout_in_millis: self.timeout_in_millis.unwrap_or_default(),
                tls_config: self.tls_config,
            }
        }
    }
}
impl GetIntegrationOutput {
    /// Creates a new builder-style object to manufacture [`GetIntegrationOutput`](crate::output::GetIntegrationOutput)
    pub fn builder() -> crate::output::get_integration_output::Builder {
        crate::output::get_integration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDomainNamesOutput {
    /// <p>The elements from this collection.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::DomainName>>,
    /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetDomainNamesOutput {
    /// <p>The elements from this collection.</p>
    pub fn items(&self) -> std::option::Option<&[crate::model::DomainName]> {
        self.items.as_deref()
    }
    /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetDomainNamesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDomainNamesOutput");
        formatter.field("items", &self.items);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetDomainNamesOutput`](crate::output::GetDomainNamesOutput)
pub mod get_domain_names_output {
    /// A builder for [`GetDomainNamesOutput`](crate::output::GetDomainNamesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) items: std::option::Option<std::vec::Vec<crate::model::DomainName>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>The elements from this collection.</p>
        pub fn items(mut self, input: impl Into<crate::model::DomainName>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>The elements from this collection.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DomainName>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDomainNamesOutput`](crate::output::GetDomainNamesOutput)
        pub fn build(self) -> crate::output::GetDomainNamesOutput {
            crate::output::GetDomainNamesOutput {
                items: self.items,
                next_token: self.next_token,
            }
        }
    }
}
impl GetDomainNamesOutput {
    /// Creates a new builder-style object to manufacture [`GetDomainNamesOutput`](crate::output::GetDomainNamesOutput)
    pub fn builder() -> crate::output::get_domain_names_output::Builder {
        crate::output::get_domain_names_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDomainNameOutput {
    /// <p>The API mapping selection expression.</p>
    pub api_mapping_selection_expression: std::option::Option<std::string::String>,
    /// <p>The name of the DomainName resource.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The domain name configurations.</p>
    pub domain_name_configurations:
        std::option::Option<std::vec::Vec<crate::model::DomainNameConfiguration>>,
    /// <p>The mutual TLS authentication configuration for a custom domain name.</p>
    pub mutual_tls_authentication: std::option::Option<crate::model::MutualTlsAuthentication>,
    /// <p>The collection of tags associated with a domain name.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl GetDomainNameOutput {
    /// <p>The API mapping selection expression.</p>
    pub fn api_mapping_selection_expression(&self) -> std::option::Option<&str> {
        self.api_mapping_selection_expression.as_deref()
    }
    /// <p>The name of the DomainName resource.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>The domain name configurations.</p>
    pub fn domain_name_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::DomainNameConfiguration]> {
        self.domain_name_configurations.as_deref()
    }
    /// <p>The mutual TLS authentication configuration for a custom domain name.</p>
    pub fn mutual_tls_authentication(
        &self,
    ) -> std::option::Option<&crate::model::MutualTlsAuthentication> {
        self.mutual_tls_authentication.as_ref()
    }
    /// <p>The collection of tags associated with a domain name.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for GetDomainNameOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDomainNameOutput");
        formatter.field(
            "api_mapping_selection_expression",
            &self.api_mapping_selection_expression,
        );
        formatter.field("domain_name", &self.domain_name);
        formatter.field(
            "domain_name_configurations",
            &self.domain_name_configurations,
        );
        formatter.field("mutual_tls_authentication", &self.mutual_tls_authentication);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`GetDomainNameOutput`](crate::output::GetDomainNameOutput)
pub mod get_domain_name_output {
    /// A builder for [`GetDomainNameOutput`](crate::output::GetDomainNameOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_mapping_selection_expression: std::option::Option<std::string::String>,
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) domain_name_configurations:
            std::option::Option<std::vec::Vec<crate::model::DomainNameConfiguration>>,
        pub(crate) mutual_tls_authentication:
            std::option::Option<crate::model::MutualTlsAuthentication>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The API mapping selection expression.</p>
        pub fn api_mapping_selection_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.api_mapping_selection_expression = Some(input.into());
            self
        }
        /// <p>The API mapping selection expression.</p>
        pub fn set_api_mapping_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.api_mapping_selection_expression = input;
            self
        }
        /// <p>The name of the DomainName resource.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of the DomainName resource.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Appends an item to `domain_name_configurations`.
        ///
        /// To override the contents of this collection use [`set_domain_name_configurations`](Self::set_domain_name_configurations).
        ///
        /// <p>The domain name configurations.</p>
        pub fn domain_name_configurations(
            mut self,
            input: impl Into<crate::model::DomainNameConfiguration>,
        ) -> Self {
            let mut v = self.domain_name_configurations.unwrap_or_default();
            v.push(input.into());
            self.domain_name_configurations = Some(v);
            self
        }
        /// <p>The domain name configurations.</p>
        pub fn set_domain_name_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DomainNameConfiguration>>,
        ) -> Self {
            self.domain_name_configurations = input;
            self
        }
        /// <p>The mutual TLS authentication configuration for a custom domain name.</p>
        pub fn mutual_tls_authentication(
            mut self,
            input: crate::model::MutualTlsAuthentication,
        ) -> Self {
            self.mutual_tls_authentication = Some(input);
            self
        }
        /// <p>The mutual TLS authentication configuration for a custom domain name.</p>
        pub fn set_mutual_tls_authentication(
            mut self,
            input: std::option::Option<crate::model::MutualTlsAuthentication>,
        ) -> Self {
            self.mutual_tls_authentication = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The collection of tags associated with a domain name.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The collection of tags associated with a domain name.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDomainNameOutput`](crate::output::GetDomainNameOutput)
        pub fn build(self) -> crate::output::GetDomainNameOutput {
            crate::output::GetDomainNameOutput {
                api_mapping_selection_expression: self.api_mapping_selection_expression,
                domain_name: self.domain_name,
                domain_name_configurations: self.domain_name_configurations,
                mutual_tls_authentication: self.mutual_tls_authentication,
                tags: self.tags,
            }
        }
    }
}
impl GetDomainNameOutput {
    /// Creates a new builder-style object to manufacture [`GetDomainNameOutput`](crate::output::GetDomainNameOutput)
    pub fn builder() -> crate::output::get_domain_name_output::Builder {
        crate::output::get_domain_name_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDeploymentsOutput {
    /// <p>The elements from this collection.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::Deployment>>,
    /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetDeploymentsOutput {
    /// <p>The elements from this collection.</p>
    pub fn items(&self) -> std::option::Option<&[crate::model::Deployment]> {
        self.items.as_deref()
    }
    /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetDeploymentsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDeploymentsOutput");
        formatter.field("items", &self.items);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetDeploymentsOutput`](crate::output::GetDeploymentsOutput)
pub mod get_deployments_output {
    /// A builder for [`GetDeploymentsOutput`](crate::output::GetDeploymentsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) items: std::option::Option<std::vec::Vec<crate::model::Deployment>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>The elements from this collection.</p>
        pub fn items(mut self, input: impl Into<crate::model::Deployment>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>The elements from this collection.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Deployment>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDeploymentsOutput`](crate::output::GetDeploymentsOutput)
        pub fn build(self) -> crate::output::GetDeploymentsOutput {
            crate::output::GetDeploymentsOutput {
                items: self.items,
                next_token: self.next_token,
            }
        }
    }
}
impl GetDeploymentsOutput {
    /// Creates a new builder-style object to manufacture [`GetDeploymentsOutput`](crate::output::GetDeploymentsOutput)
    pub fn builder() -> crate::output::get_deployments_output::Builder {
        crate::output::get_deployments_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDeploymentOutput {
    /// <p>Specifies whether a deployment was automatically released.</p>
    pub auto_deployed: bool,
    /// <p>The date and time when the Deployment resource was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The identifier for the deployment.</p>
    pub deployment_id: std::option::Option<std::string::String>,
    /// <p>The status of the deployment: PENDING, FAILED, or SUCCEEDED.</p>
    pub deployment_status: std::option::Option<crate::model::DeploymentStatus>,
    /// <p>May contain additional feedback on the status of an API deployment.</p>
    pub deployment_status_message: std::option::Option<std::string::String>,
    /// <p>The description for the deployment.</p>
    pub description: std::option::Option<std::string::String>,
}
impl GetDeploymentOutput {
    /// <p>Specifies whether a deployment was automatically released.</p>
    pub fn auto_deployed(&self) -> bool {
        self.auto_deployed
    }
    /// <p>The date and time when the Deployment resource was created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_date.as_ref()
    }
    /// <p>The identifier for the deployment.</p>
    pub fn deployment_id(&self) -> std::option::Option<&str> {
        self.deployment_id.as_deref()
    }
    /// <p>The status of the deployment: PENDING, FAILED, or SUCCEEDED.</p>
    pub fn deployment_status(&self) -> std::option::Option<&crate::model::DeploymentStatus> {
        self.deployment_status.as_ref()
    }
    /// <p>May contain additional feedback on the status of an API deployment.</p>
    pub fn deployment_status_message(&self) -> std::option::Option<&str> {
        self.deployment_status_message.as_deref()
    }
    /// <p>The description for the deployment.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for GetDeploymentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDeploymentOutput");
        formatter.field("auto_deployed", &self.auto_deployed);
        formatter.field("created_date", &self.created_date);
        formatter.field("deployment_id", &self.deployment_id);
        formatter.field("deployment_status", &self.deployment_status);
        formatter.field("deployment_status_message", &self.deployment_status_message);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`GetDeploymentOutput`](crate::output::GetDeploymentOutput)
pub mod get_deployment_output {
    /// A builder for [`GetDeploymentOutput`](crate::output::GetDeploymentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_deployed: std::option::Option<bool>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) deployment_id: std::option::Option<std::string::String>,
        pub(crate) deployment_status: std::option::Option<crate::model::DeploymentStatus>,
        pub(crate) deployment_status_message: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies whether a deployment was automatically released.</p>
        pub fn auto_deployed(mut self, input: bool) -> Self {
            self.auto_deployed = Some(input);
            self
        }
        /// <p>Specifies whether a deployment was automatically released.</p>
        pub fn set_auto_deployed(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_deployed = input;
            self
        }
        /// <p>The date and time when the Deployment resource was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The date and time when the Deployment resource was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>The identifier for the deployment.</p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_id = Some(input.into());
            self
        }
        /// <p>The identifier for the deployment.</p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_id = input;
            self
        }
        /// <p>The status of the deployment: PENDING, FAILED, or SUCCEEDED.</p>
        pub fn deployment_status(mut self, input: crate::model::DeploymentStatus) -> Self {
            self.deployment_status = Some(input);
            self
        }
        /// <p>The status of the deployment: PENDING, FAILED, or SUCCEEDED.</p>
        pub fn set_deployment_status(
            mut self,
            input: std::option::Option<crate::model::DeploymentStatus>,
        ) -> Self {
            self.deployment_status = input;
            self
        }
        /// <p>May contain additional feedback on the status of an API deployment.</p>
        pub fn deployment_status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_status_message = Some(input.into());
            self
        }
        /// <p>May contain additional feedback on the status of an API deployment.</p>
        pub fn set_deployment_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_status_message = input;
            self
        }
        /// <p>The description for the deployment.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description for the deployment.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDeploymentOutput`](crate::output::GetDeploymentOutput)
        pub fn build(self) -> crate::output::GetDeploymentOutput {
            crate::output::GetDeploymentOutput {
                auto_deployed: self.auto_deployed.unwrap_or_default(),
                created_date: self.created_date,
                deployment_id: self.deployment_id,
                deployment_status: self.deployment_status,
                deployment_status_message: self.deployment_status_message,
                description: self.description,
            }
        }
    }
}
impl GetDeploymentOutput {
    /// Creates a new builder-style object to manufacture [`GetDeploymentOutput`](crate::output::GetDeploymentOutput)
    pub fn builder() -> crate::output::get_deployment_output::Builder {
        crate::output::get_deployment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAuthorizersOutput {
    /// <p>The elements from this collection.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::Authorizer>>,
    /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetAuthorizersOutput {
    /// <p>The elements from this collection.</p>
    pub fn items(&self) -> std::option::Option<&[crate::model::Authorizer]> {
        self.items.as_deref()
    }
    /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetAuthorizersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAuthorizersOutput");
        formatter.field("items", &self.items);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetAuthorizersOutput`](crate::output::GetAuthorizersOutput)
pub mod get_authorizers_output {
    /// A builder for [`GetAuthorizersOutput`](crate::output::GetAuthorizersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) items: std::option::Option<std::vec::Vec<crate::model::Authorizer>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>The elements from this collection.</p>
        pub fn items(mut self, input: impl Into<crate::model::Authorizer>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>The elements from this collection.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Authorizer>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAuthorizersOutput`](crate::output::GetAuthorizersOutput)
        pub fn build(self) -> crate::output::GetAuthorizersOutput {
            crate::output::GetAuthorizersOutput {
                items: self.items,
                next_token: self.next_token,
            }
        }
    }
}
impl GetAuthorizersOutput {
    /// Creates a new builder-style object to manufacture [`GetAuthorizersOutput`](crate::output::GetAuthorizersOutput)
    pub fn builder() -> crate::output::get_authorizers_output::Builder {
        crate::output::get_authorizers_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAuthorizerOutput {
    /// <p>Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, don't specify this parameter. Supported only for REQUEST authorizers.</p>
    pub authorizer_credentials_arn: std::option::Option<std::string::String>,
    /// <p>The authorizer identifier.</p>
    pub authorizer_id: std::option::Option<std::string::String>,
    /// <p>Specifies the format of the payload sent to an HTTP API Lambda authorizer. Required for HTTP API Lambda authorizers. Supported values are 1.0 and 2.0. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p>
    pub authorizer_payload_format_version: std::option::Option<std::string::String>,
    /// <p>The time to live (TTL) for cached authorizer results, in seconds. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway caches authorizer responses. The maximum value is 3600, or 1 hour. Supported only for HTTP API Lambda authorizers.</p>
    pub authorizer_result_ttl_in_seconds: i32,
    /// <p>The authorizer type. Specify REQUEST for a Lambda function using incoming request parameters. Specify JWT to use JSON Web Tokens (supported only for HTTP APIs).</p>
    pub authorizer_type: std::option::Option<crate::model::AuthorizerType>,
    /// <p>The authorizer's Uniform Resource Identifier (URI). For REQUEST authorizers, this must be a well-formed Lambda function URI, for example, arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:<replaceable>{account_id}</replaceable>:function:<replaceable>{lambda_function_name}</replaceable>/invocations. In general, the URI has this form: arn:aws:apigateway:<replaceable>{region}</replaceable>:lambda:path/<replaceable>{service_api}</replaceable>
    /// , where <replaceable></replaceable>{region} is the same as the region hosting the Lambda function, path indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial /. For Lambda functions, this is usually of the form /2015-03-31/functions/[FunctionARN]/invocations. Supported only for REQUEST authorizers.</p>
    pub authorizer_uri: std::option::Option<std::string::String>,
    /// <p>Specifies whether a Lambda authorizer returns a response in a simple format. If enabled, the Lambda authorizer can return a boolean value instead of an IAM policy. Supported only for HTTP APIs. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a></p>
    pub enable_simple_responses: bool,
    /// <p>The identity source for which authorization is requested.</p> <p>For a REQUEST authorizer, this is optional. The value is a set of one or more mapping expressions of the specified request parameters. The identity source can be headers, query string parameters, stage variables, and context parameters. For example, if an Auth header and a Name query string parameter are defined as identity sources, this value is route.request.header.Auth, route.request.querystring.Name for WebSocket APIs. For HTTP APIs, use selection expressions prefixed with $, for example, $request.header.Auth, $request.querystring.Name. These parameters are used to perform runtime validation for Lambda-based authorizers by verifying all of the identity-related request parameters are present in the request, not null, and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function. Otherwise, it returns a 401 Unauthorized response without calling the Lambda function. For HTTP APIs, identity sources are also used as the cache key when caching is enabled. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p> <p>For JWT, a single entry that specifies where to extract the JSON Web Token (JWT) from inbound requests. Currently only header-based and query parameter-based selections are supported, for example $request.header.Authorization.</p>
    pub identity_source: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The validation expression does not apply to the REQUEST authorizer.</p>
    pub identity_validation_expression: std::option::Option<std::string::String>,
    /// <p>Represents the configuration of a JWT authorizer. Required for the JWT authorizer type. Supported only for HTTP APIs.</p>
    pub jwt_configuration: std::option::Option<crate::model::JwtConfiguration>,
    /// <p>The name of the authorizer.</p>
    pub name: std::option::Option<std::string::String>,
}
impl GetAuthorizerOutput {
    /// <p>Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, don't specify this parameter. Supported only for REQUEST authorizers.</p>
    pub fn authorizer_credentials_arn(&self) -> std::option::Option<&str> {
        self.authorizer_credentials_arn.as_deref()
    }
    /// <p>The authorizer identifier.</p>
    pub fn authorizer_id(&self) -> std::option::Option<&str> {
        self.authorizer_id.as_deref()
    }
    /// <p>Specifies the format of the payload sent to an HTTP API Lambda authorizer. Required for HTTP API Lambda authorizers. Supported values are 1.0 and 2.0. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p>
    pub fn authorizer_payload_format_version(&self) -> std::option::Option<&str> {
        self.authorizer_payload_format_version.as_deref()
    }
    /// <p>The time to live (TTL) for cached authorizer results, in seconds. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway caches authorizer responses. The maximum value is 3600, or 1 hour. Supported only for HTTP API Lambda authorizers.</p>
    pub fn authorizer_result_ttl_in_seconds(&self) -> i32 {
        self.authorizer_result_ttl_in_seconds
    }
    /// <p>The authorizer type. Specify REQUEST for a Lambda function using incoming request parameters. Specify JWT to use JSON Web Tokens (supported only for HTTP APIs).</p>
    pub fn authorizer_type(&self) -> std::option::Option<&crate::model::AuthorizerType> {
        self.authorizer_type.as_ref()
    }
    /// <p>The authorizer's Uniform Resource Identifier (URI). For REQUEST authorizers, this must be a well-formed Lambda function URI, for example, arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:<replaceable>{account_id}</replaceable>:function:<replaceable>{lambda_function_name}</replaceable>/invocations. In general, the URI has this form: arn:aws:apigateway:<replaceable>{region}</replaceable>:lambda:path/<replaceable>{service_api}</replaceable>
    /// , where <replaceable></replaceable>{region} is the same as the region hosting the Lambda function, path indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial /. For Lambda functions, this is usually of the form /2015-03-31/functions/[FunctionARN]/invocations. Supported only for REQUEST authorizers.</p>
    pub fn authorizer_uri(&self) -> std::option::Option<&str> {
        self.authorizer_uri.as_deref()
    }
    /// <p>Specifies whether a Lambda authorizer returns a response in a simple format. If enabled, the Lambda authorizer can return a boolean value instead of an IAM policy. Supported only for HTTP APIs. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a></p>
    pub fn enable_simple_responses(&self) -> bool {
        self.enable_simple_responses
    }
    /// <p>The identity source for which authorization is requested.</p> <p>For a REQUEST authorizer, this is optional. The value is a set of one or more mapping expressions of the specified request parameters. The identity source can be headers, query string parameters, stage variables, and context parameters. For example, if an Auth header and a Name query string parameter are defined as identity sources, this value is route.request.header.Auth, route.request.querystring.Name for WebSocket APIs. For HTTP APIs, use selection expressions prefixed with $, for example, $request.header.Auth, $request.querystring.Name. These parameters are used to perform runtime validation for Lambda-based authorizers by verifying all of the identity-related request parameters are present in the request, not null, and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function. Otherwise, it returns a 401 Unauthorized response without calling the Lambda function. For HTTP APIs, identity sources are also used as the cache key when caching is enabled. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p> <p>For JWT, a single entry that specifies where to extract the JSON Web Token (JWT) from inbound requests. Currently only header-based and query parameter-based selections are supported, for example $request.header.Authorization.</p>
    pub fn identity_source(&self) -> std::option::Option<&[std::string::String]> {
        self.identity_source.as_deref()
    }
    /// <p>The validation expression does not apply to the REQUEST authorizer.</p>
    pub fn identity_validation_expression(&self) -> std::option::Option<&str> {
        self.identity_validation_expression.as_deref()
    }
    /// <p>Represents the configuration of a JWT authorizer. Required for the JWT authorizer type. Supported only for HTTP APIs.</p>
    pub fn jwt_configuration(&self) -> std::option::Option<&crate::model::JwtConfiguration> {
        self.jwt_configuration.as_ref()
    }
    /// <p>The name of the authorizer.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for GetAuthorizerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAuthorizerOutput");
        formatter.field(
            "authorizer_credentials_arn",
            &self.authorizer_credentials_arn,
        );
        formatter.field("authorizer_id", &self.authorizer_id);
        formatter.field(
            "authorizer_payload_format_version",
            &self.authorizer_payload_format_version,
        );
        formatter.field(
            "authorizer_result_ttl_in_seconds",
            &self.authorizer_result_ttl_in_seconds,
        );
        formatter.field("authorizer_type", &self.authorizer_type);
        formatter.field("authorizer_uri", &self.authorizer_uri);
        formatter.field("enable_simple_responses", &self.enable_simple_responses);
        formatter.field("identity_source", &self.identity_source);
        formatter.field(
            "identity_validation_expression",
            &self.identity_validation_expression,
        );
        formatter.field("jwt_configuration", &self.jwt_configuration);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`GetAuthorizerOutput`](crate::output::GetAuthorizerOutput)
pub mod get_authorizer_output {
    /// A builder for [`GetAuthorizerOutput`](crate::output::GetAuthorizerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authorizer_credentials_arn: std::option::Option<std::string::String>,
        pub(crate) authorizer_id: std::option::Option<std::string::String>,
        pub(crate) authorizer_payload_format_version: std::option::Option<std::string::String>,
        pub(crate) authorizer_result_ttl_in_seconds: std::option::Option<i32>,
        pub(crate) authorizer_type: std::option::Option<crate::model::AuthorizerType>,
        pub(crate) authorizer_uri: std::option::Option<std::string::String>,
        pub(crate) enable_simple_responses: std::option::Option<bool>,
        pub(crate) identity_source: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) identity_validation_expression: std::option::Option<std::string::String>,
        pub(crate) jwt_configuration: std::option::Option<crate::model::JwtConfiguration>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, don't specify this parameter. Supported only for REQUEST authorizers.</p>
        pub fn authorizer_credentials_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorizer_credentials_arn = Some(input.into());
            self
        }
        /// <p>Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, don't specify this parameter. Supported only for REQUEST authorizers.</p>
        pub fn set_authorizer_credentials_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorizer_credentials_arn = input;
            self
        }
        /// <p>The authorizer identifier.</p>
        pub fn authorizer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorizer_id = Some(input.into());
            self
        }
        /// <p>The authorizer identifier.</p>
        pub fn set_authorizer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorizer_id = input;
            self
        }
        /// <p>Specifies the format of the payload sent to an HTTP API Lambda authorizer. Required for HTTP API Lambda authorizers. Supported values are 1.0 and 2.0. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p>
        pub fn authorizer_payload_format_version(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.authorizer_payload_format_version = Some(input.into());
            self
        }
        /// <p>Specifies the format of the payload sent to an HTTP API Lambda authorizer. Required for HTTP API Lambda authorizers. Supported values are 1.0 and 2.0. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p>
        pub fn set_authorizer_payload_format_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorizer_payload_format_version = input;
            self
        }
        /// <p>The time to live (TTL) for cached authorizer results, in seconds. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway caches authorizer responses. The maximum value is 3600, or 1 hour. Supported only for HTTP API Lambda authorizers.</p>
        pub fn authorizer_result_ttl_in_seconds(mut self, input: i32) -> Self {
            self.authorizer_result_ttl_in_seconds = Some(input);
            self
        }
        /// <p>The time to live (TTL) for cached authorizer results, in seconds. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway caches authorizer responses. The maximum value is 3600, or 1 hour. Supported only for HTTP API Lambda authorizers.</p>
        pub fn set_authorizer_result_ttl_in_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.authorizer_result_ttl_in_seconds = input;
            self
        }
        /// <p>The authorizer type. Specify REQUEST for a Lambda function using incoming request parameters. Specify JWT to use JSON Web Tokens (supported only for HTTP APIs).</p>
        pub fn authorizer_type(mut self, input: crate::model::AuthorizerType) -> Self {
            self.authorizer_type = Some(input);
            self
        }
        /// <p>The authorizer type. Specify REQUEST for a Lambda function using incoming request parameters. Specify JWT to use JSON Web Tokens (supported only for HTTP APIs).</p>
        pub fn set_authorizer_type(
            mut self,
            input: std::option::Option<crate::model::AuthorizerType>,
        ) -> Self {
            self.authorizer_type = input;
            self
        }
        /// <p>The authorizer's Uniform Resource Identifier (URI). For REQUEST authorizers, this must be a well-formed Lambda function URI, for example, arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:<replaceable>{account_id}</replaceable>:function:<replaceable>{lambda_function_name}</replaceable>/invocations. In general, the URI has this form: arn:aws:apigateway:<replaceable>{region}</replaceable>:lambda:path/<replaceable>{service_api}</replaceable>
        /// , where <replaceable></replaceable>{region} is the same as the region hosting the Lambda function, path indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial /. For Lambda functions, this is usually of the form /2015-03-31/functions/[FunctionARN]/invocations. Supported only for REQUEST authorizers.</p>
        pub fn authorizer_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorizer_uri = Some(input.into());
            self
        }
        /// <p>The authorizer's Uniform Resource Identifier (URI). For REQUEST authorizers, this must be a well-formed Lambda function URI, for example, arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:<replaceable>{account_id}</replaceable>:function:<replaceable>{lambda_function_name}</replaceable>/invocations. In general, the URI has this form: arn:aws:apigateway:<replaceable>{region}</replaceable>:lambda:path/<replaceable>{service_api}</replaceable>
        /// , where <replaceable></replaceable>{region} is the same as the region hosting the Lambda function, path indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial /. For Lambda functions, this is usually of the form /2015-03-31/functions/[FunctionARN]/invocations. Supported only for REQUEST authorizers.</p>
        pub fn set_authorizer_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorizer_uri = input;
            self
        }
        /// <p>Specifies whether a Lambda authorizer returns a response in a simple format. If enabled, the Lambda authorizer can return a boolean value instead of an IAM policy. Supported only for HTTP APIs. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a></p>
        pub fn enable_simple_responses(mut self, input: bool) -> Self {
            self.enable_simple_responses = Some(input);
            self
        }
        /// <p>Specifies whether a Lambda authorizer returns a response in a simple format. If enabled, the Lambda authorizer can return a boolean value instead of an IAM policy. Supported only for HTTP APIs. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a></p>
        pub fn set_enable_simple_responses(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_simple_responses = input;
            self
        }
        /// Appends an item to `identity_source`.
        ///
        /// To override the contents of this collection use [`set_identity_source`](Self::set_identity_source).
        ///
        /// <p>The identity source for which authorization is requested.</p> <p>For a REQUEST authorizer, this is optional. The value is a set of one or more mapping expressions of the specified request parameters. The identity source can be headers, query string parameters, stage variables, and context parameters. For example, if an Auth header and a Name query string parameter are defined as identity sources, this value is route.request.header.Auth, route.request.querystring.Name for WebSocket APIs. For HTTP APIs, use selection expressions prefixed with $, for example, $request.header.Auth, $request.querystring.Name. These parameters are used to perform runtime validation for Lambda-based authorizers by verifying all of the identity-related request parameters are present in the request, not null, and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function. Otherwise, it returns a 401 Unauthorized response without calling the Lambda function. For HTTP APIs, identity sources are also used as the cache key when caching is enabled. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p> <p>For JWT, a single entry that specifies where to extract the JSON Web Token (JWT) from inbound requests. Currently only header-based and query parameter-based selections are supported, for example $request.header.Authorization.</p>
        pub fn identity_source(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.identity_source.unwrap_or_default();
            v.push(input.into());
            self.identity_source = Some(v);
            self
        }
        /// <p>The identity source for which authorization is requested.</p> <p>For a REQUEST authorizer, this is optional. The value is a set of one or more mapping expressions of the specified request parameters. The identity source can be headers, query string parameters, stage variables, and context parameters. For example, if an Auth header and a Name query string parameter are defined as identity sources, this value is route.request.header.Auth, route.request.querystring.Name for WebSocket APIs. For HTTP APIs, use selection expressions prefixed with $, for example, $request.header.Auth, $request.querystring.Name. These parameters are used to perform runtime validation for Lambda-based authorizers by verifying all of the identity-related request parameters are present in the request, not null, and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function. Otherwise, it returns a 401 Unauthorized response without calling the Lambda function. For HTTP APIs, identity sources are also used as the cache key when caching is enabled. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p> <p>For JWT, a single entry that specifies where to extract the JSON Web Token (JWT) from inbound requests. Currently only header-based and query parameter-based selections are supported, for example $request.header.Authorization.</p>
        pub fn set_identity_source(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.identity_source = input;
            self
        }
        /// <p>The validation expression does not apply to the REQUEST authorizer.</p>
        pub fn identity_validation_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.identity_validation_expression = Some(input.into());
            self
        }
        /// <p>The validation expression does not apply to the REQUEST authorizer.</p>
        pub fn set_identity_validation_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_validation_expression = input;
            self
        }
        /// <p>Represents the configuration of a JWT authorizer. Required for the JWT authorizer type. Supported only for HTTP APIs.</p>
        pub fn jwt_configuration(mut self, input: crate::model::JwtConfiguration) -> Self {
            self.jwt_configuration = Some(input);
            self
        }
        /// <p>Represents the configuration of a JWT authorizer. Required for the JWT authorizer type. Supported only for HTTP APIs.</p>
        pub fn set_jwt_configuration(
            mut self,
            input: std::option::Option<crate::model::JwtConfiguration>,
        ) -> Self {
            self.jwt_configuration = input;
            self
        }
        /// <p>The name of the authorizer.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the authorizer.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAuthorizerOutput`](crate::output::GetAuthorizerOutput)
        pub fn build(self) -> crate::output::GetAuthorizerOutput {
            crate::output::GetAuthorizerOutput {
                authorizer_credentials_arn: self.authorizer_credentials_arn,
                authorizer_id: self.authorizer_id,
                authorizer_payload_format_version: self.authorizer_payload_format_version,
                authorizer_result_ttl_in_seconds: self
                    .authorizer_result_ttl_in_seconds
                    .unwrap_or_default(),
                authorizer_type: self.authorizer_type,
                authorizer_uri: self.authorizer_uri,
                enable_simple_responses: self.enable_simple_responses.unwrap_or_default(),
                identity_source: self.identity_source,
                identity_validation_expression: self.identity_validation_expression,
                jwt_configuration: self.jwt_configuration,
                name: self.name,
            }
        }
    }
}
impl GetAuthorizerOutput {
    /// Creates a new builder-style object to manufacture [`GetAuthorizerOutput`](crate::output::GetAuthorizerOutput)
    pub fn builder() -> crate::output::get_authorizer_output::Builder {
        crate::output::get_authorizer_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetApisOutput {
    /// <p>The elements from this collection.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::Api>>,
    /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetApisOutput {
    /// <p>The elements from this collection.</p>
    pub fn items(&self) -> std::option::Option<&[crate::model::Api]> {
        self.items.as_deref()
    }
    /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetApisOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetApisOutput");
        formatter.field("items", &self.items);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetApisOutput`](crate::output::GetApisOutput)
pub mod get_apis_output {
    /// A builder for [`GetApisOutput`](crate::output::GetApisOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) items: std::option::Option<std::vec::Vec<crate::model::Api>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>The elements from this collection.</p>
        pub fn items(mut self, input: impl Into<crate::model::Api>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>The elements from this collection.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Api>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetApisOutput`](crate::output::GetApisOutput)
        pub fn build(self) -> crate::output::GetApisOutput {
            crate::output::GetApisOutput {
                items: self.items,
                next_token: self.next_token,
            }
        }
    }
}
impl GetApisOutput {
    /// Creates a new builder-style object to manufacture [`GetApisOutput`](crate::output::GetApisOutput)
    pub fn builder() -> crate::output::get_apis_output::Builder {
        crate::output::get_apis_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetApiMappingsOutput {
    /// <p>The elements from this collection.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::ApiMapping>>,
    /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetApiMappingsOutput {
    /// <p>The elements from this collection.</p>
    pub fn items(&self) -> std::option::Option<&[crate::model::ApiMapping]> {
        self.items.as_deref()
    }
    /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetApiMappingsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetApiMappingsOutput");
        formatter.field("items", &self.items);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetApiMappingsOutput`](crate::output::GetApiMappingsOutput)
pub mod get_api_mappings_output {
    /// A builder for [`GetApiMappingsOutput`](crate::output::GetApiMappingsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) items: std::option::Option<std::vec::Vec<crate::model::ApiMapping>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>The elements from this collection.</p>
        pub fn items(mut self, input: impl Into<crate::model::ApiMapping>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>The elements from this collection.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ApiMapping>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next page of elements from this collection. Not valid for the last element of the collection.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetApiMappingsOutput`](crate::output::GetApiMappingsOutput)
        pub fn build(self) -> crate::output::GetApiMappingsOutput {
            crate::output::GetApiMappingsOutput {
                items: self.items,
                next_token: self.next_token,
            }
        }
    }
}
impl GetApiMappingsOutput {
    /// Creates a new builder-style object to manufacture [`GetApiMappingsOutput`](crate::output::GetApiMappingsOutput)
    pub fn builder() -> crate::output::get_api_mappings_output::Builder {
        crate::output::get_api_mappings_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetApiMappingOutput {
    /// <p>The API identifier.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The API mapping identifier.</p>
    pub api_mapping_id: std::option::Option<std::string::String>,
    /// <p>The API mapping key.</p>
    pub api_mapping_key: std::option::Option<std::string::String>,
    /// <p>The API stage.</p>
    pub stage: std::option::Option<std::string::String>,
}
impl GetApiMappingOutput {
    /// <p>The API identifier.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The API mapping identifier.</p>
    pub fn api_mapping_id(&self) -> std::option::Option<&str> {
        self.api_mapping_id.as_deref()
    }
    /// <p>The API mapping key.</p>
    pub fn api_mapping_key(&self) -> std::option::Option<&str> {
        self.api_mapping_key.as_deref()
    }
    /// <p>The API stage.</p>
    pub fn stage(&self) -> std::option::Option<&str> {
        self.stage.as_deref()
    }
}
impl std::fmt::Debug for GetApiMappingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetApiMappingOutput");
        formatter.field("api_id", &self.api_id);
        formatter.field("api_mapping_id", &self.api_mapping_id);
        formatter.field("api_mapping_key", &self.api_mapping_key);
        formatter.field("stage", &self.stage);
        formatter.finish()
    }
}
/// See [`GetApiMappingOutput`](crate::output::GetApiMappingOutput)
pub mod get_api_mapping_output {
    /// A builder for [`GetApiMappingOutput`](crate::output::GetApiMappingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) api_mapping_id: std::option::Option<std::string::String>,
        pub(crate) api_mapping_key: std::option::Option<std::string::String>,
        pub(crate) stage: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The API mapping identifier.</p>
        pub fn api_mapping_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_mapping_id = Some(input.into());
            self
        }
        /// <p>The API mapping identifier.</p>
        pub fn set_api_mapping_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.api_mapping_id = input;
            self
        }
        /// <p>The API mapping key.</p>
        pub fn api_mapping_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_mapping_key = Some(input.into());
            self
        }
        /// <p>The API mapping key.</p>
        pub fn set_api_mapping_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.api_mapping_key = input;
            self
        }
        /// <p>The API stage.</p>
        pub fn stage(mut self, input: impl Into<std::string::String>) -> Self {
            self.stage = Some(input.into());
            self
        }
        /// <p>The API stage.</p>
        pub fn set_stage(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stage = input;
            self
        }
        /// Consumes the builder and constructs a [`GetApiMappingOutput`](crate::output::GetApiMappingOutput)
        pub fn build(self) -> crate::output::GetApiMappingOutput {
            crate::output::GetApiMappingOutput {
                api_id: self.api_id,
                api_mapping_id: self.api_mapping_id,
                api_mapping_key: self.api_mapping_key,
                stage: self.stage,
            }
        }
    }
}
impl GetApiMappingOutput {
    /// Creates a new builder-style object to manufacture [`GetApiMappingOutput`](crate::output::GetApiMappingOutput)
    pub fn builder() -> crate::output::get_api_mapping_output::Builder {
        crate::output::get_api_mapping_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetApiOutput {
    /// <p>The URI of the API, of the form {api-id}.execute-api.{region}.amazonaws.com. The stage name is typically appended to this URI to form a complete path to a deployed API stage.</p>
    pub api_endpoint: std::option::Option<std::string::String>,
    /// <p>Specifies whether an API is managed by API Gateway. You can't update or delete a managed API by using API Gateway. A managed API can be deleted only through the tooling or service that created it.</p>
    pub api_gateway_managed: bool,
    /// <p>The API ID.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>An API key selection expression. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions">API Key Selection Expressions</a>.</p>
    pub api_key_selection_expression: std::option::Option<std::string::String>,
    /// <p>A CORS configuration. Supported only for HTTP APIs.</p>
    pub cors_configuration: std::option::Option<crate::model::Cors>,
    /// <p>The timestamp when the API was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The description of the API.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Avoid validating models when creating a deployment. Supported only for WebSocket APIs.</p>
    pub disable_schema_validation: bool,
    /// <p>Specifies whether clients can invoke your API by using the default execute-api endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
    pub disable_execute_api_endpoint: bool,
    /// <p>The validation information during API import. This may include particular properties of your OpenAPI definition which are ignored during import. Supported only for HTTP APIs.</p>
    pub import_info: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The name of the API.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The API protocol.</p>
    pub protocol_type: std::option::Option<crate::model::ProtocolType>,
    /// <p>The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.</p>
    pub route_selection_expression: std::option::Option<std::string::String>,
    /// <p>A collection of tags associated with the API.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A version identifier for the API.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>The warning messages reported when failonwarnings is turned on during API import.</p>
    pub warnings: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl GetApiOutput {
    /// <p>The URI of the API, of the form {api-id}.execute-api.{region}.amazonaws.com. The stage name is typically appended to this URI to form a complete path to a deployed API stage.</p>
    pub fn api_endpoint(&self) -> std::option::Option<&str> {
        self.api_endpoint.as_deref()
    }
    /// <p>Specifies whether an API is managed by API Gateway. You can't update or delete a managed API by using API Gateway. A managed API can be deleted only through the tooling or service that created it.</p>
    pub fn api_gateway_managed(&self) -> bool {
        self.api_gateway_managed
    }
    /// <p>The API ID.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>An API key selection expression. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions">API Key Selection Expressions</a>.</p>
    pub fn api_key_selection_expression(&self) -> std::option::Option<&str> {
        self.api_key_selection_expression.as_deref()
    }
    /// <p>A CORS configuration. Supported only for HTTP APIs.</p>
    pub fn cors_configuration(&self) -> std::option::Option<&crate::model::Cors> {
        self.cors_configuration.as_ref()
    }
    /// <p>The timestamp when the API was created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_date.as_ref()
    }
    /// <p>The description of the API.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Avoid validating models when creating a deployment. Supported only for WebSocket APIs.</p>
    pub fn disable_schema_validation(&self) -> bool {
        self.disable_schema_validation
    }
    /// <p>Specifies whether clients can invoke your API by using the default execute-api endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
    pub fn disable_execute_api_endpoint(&self) -> bool {
        self.disable_execute_api_endpoint
    }
    /// <p>The validation information during API import. This may include particular properties of your OpenAPI definition which are ignored during import. Supported only for HTTP APIs.</p>
    pub fn import_info(&self) -> std::option::Option<&[std::string::String]> {
        self.import_info.as_deref()
    }
    /// <p>The name of the API.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The API protocol.</p>
    pub fn protocol_type(&self) -> std::option::Option<&crate::model::ProtocolType> {
        self.protocol_type.as_ref()
    }
    /// <p>The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.</p>
    pub fn route_selection_expression(&self) -> std::option::Option<&str> {
        self.route_selection_expression.as_deref()
    }
    /// <p>A collection of tags associated with the API.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>A version identifier for the API.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>The warning messages reported when failonwarnings is turned on during API import.</p>
    pub fn warnings(&self) -> std::option::Option<&[std::string::String]> {
        self.warnings.as_deref()
    }
}
impl std::fmt::Debug for GetApiOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetApiOutput");
        formatter.field("api_endpoint", &self.api_endpoint);
        formatter.field("api_gateway_managed", &self.api_gateway_managed);
        formatter.field("api_id", &self.api_id);
        formatter.field(
            "api_key_selection_expression",
            &self.api_key_selection_expression,
        );
        formatter.field("cors_configuration", &self.cors_configuration);
        formatter.field("created_date", &self.created_date);
        formatter.field("description", &self.description);
        formatter.field("disable_schema_validation", &self.disable_schema_validation);
        formatter.field(
            "disable_execute_api_endpoint",
            &self.disable_execute_api_endpoint,
        );
        formatter.field("import_info", &self.import_info);
        formatter.field("name", &self.name);
        formatter.field("protocol_type", &self.protocol_type);
        formatter.field(
            "route_selection_expression",
            &self.route_selection_expression,
        );
        formatter.field("tags", &self.tags);
        formatter.field("version", &self.version);
        formatter.field("warnings", &self.warnings);
        formatter.finish()
    }
}
/// See [`GetApiOutput`](crate::output::GetApiOutput)
pub mod get_api_output {
    /// A builder for [`GetApiOutput`](crate::output::GetApiOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_endpoint: std::option::Option<std::string::String>,
        pub(crate) api_gateway_managed: std::option::Option<bool>,
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) api_key_selection_expression: std::option::Option<std::string::String>,
        pub(crate) cors_configuration: std::option::Option<crate::model::Cors>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) disable_schema_validation: std::option::Option<bool>,
        pub(crate) disable_execute_api_endpoint: std::option::Option<bool>,
        pub(crate) import_info: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) protocol_type: std::option::Option<crate::model::ProtocolType>,
        pub(crate) route_selection_expression: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) warnings: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The URI of the API, of the form {api-id}.execute-api.{region}.amazonaws.com. The stage name is typically appended to this URI to form a complete path to a deployed API stage.</p>
        pub fn api_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_endpoint = Some(input.into());
            self
        }
        /// <p>The URI of the API, of the form {api-id}.execute-api.{region}.amazonaws.com. The stage name is typically appended to this URI to form a complete path to a deployed API stage.</p>
        pub fn set_api_endpoint(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_endpoint = input;
            self
        }
        /// <p>Specifies whether an API is managed by API Gateway. You can't update or delete a managed API by using API Gateway. A managed API can be deleted only through the tooling or service that created it.</p>
        pub fn api_gateway_managed(mut self, input: bool) -> Self {
            self.api_gateway_managed = Some(input);
            self
        }
        /// <p>Specifies whether an API is managed by API Gateway. You can't update or delete a managed API by using API Gateway. A managed API can be deleted only through the tooling or service that created it.</p>
        pub fn set_api_gateway_managed(mut self, input: std::option::Option<bool>) -> Self {
            self.api_gateway_managed = input;
            self
        }
        /// <p>The API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>An API key selection expression. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions">API Key Selection Expressions</a>.</p>
        pub fn api_key_selection_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.api_key_selection_expression = Some(input.into());
            self
        }
        /// <p>An API key selection expression. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions">API Key Selection Expressions</a>.</p>
        pub fn set_api_key_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.api_key_selection_expression = input;
            self
        }
        /// <p>A CORS configuration. Supported only for HTTP APIs.</p>
        pub fn cors_configuration(mut self, input: crate::model::Cors) -> Self {
            self.cors_configuration = Some(input);
            self
        }
        /// <p>A CORS configuration. Supported only for HTTP APIs.</p>
        pub fn set_cors_configuration(
            mut self,
            input: std::option::Option<crate::model::Cors>,
        ) -> Self {
            self.cors_configuration = input;
            self
        }
        /// <p>The timestamp when the API was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The timestamp when the API was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>The description of the API.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the API.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Avoid validating models when creating a deployment. Supported only for WebSocket APIs.</p>
        pub fn disable_schema_validation(mut self, input: bool) -> Self {
            self.disable_schema_validation = Some(input);
            self
        }
        /// <p>Avoid validating models when creating a deployment. Supported only for WebSocket APIs.</p>
        pub fn set_disable_schema_validation(mut self, input: std::option::Option<bool>) -> Self {
            self.disable_schema_validation = input;
            self
        }
        /// <p>Specifies whether clients can invoke your API by using the default execute-api endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
        pub fn disable_execute_api_endpoint(mut self, input: bool) -> Self {
            self.disable_execute_api_endpoint = Some(input);
            self
        }
        /// <p>Specifies whether clients can invoke your API by using the default execute-api endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
        pub fn set_disable_execute_api_endpoint(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.disable_execute_api_endpoint = input;
            self
        }
        /// Appends an item to `import_info`.
        ///
        /// To override the contents of this collection use [`set_import_info`](Self::set_import_info).
        ///
        /// <p>The validation information during API import. This may include particular properties of your OpenAPI definition which are ignored during import. Supported only for HTTP APIs.</p>
        pub fn import_info(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.import_info.unwrap_or_default();
            v.push(input.into());
            self.import_info = Some(v);
            self
        }
        /// <p>The validation information during API import. This may include particular properties of your OpenAPI definition which are ignored during import. Supported only for HTTP APIs.</p>
        pub fn set_import_info(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.import_info = input;
            self
        }
        /// <p>The name of the API.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the API.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The API protocol.</p>
        pub fn protocol_type(mut self, input: crate::model::ProtocolType) -> Self {
            self.protocol_type = Some(input);
            self
        }
        /// <p>The API protocol.</p>
        pub fn set_protocol_type(
            mut self,
            input: std::option::Option<crate::model::ProtocolType>,
        ) -> Self {
            self.protocol_type = input;
            self
        }
        /// <p>The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.</p>
        pub fn route_selection_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_selection_expression = Some(input.into());
            self
        }
        /// <p>The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.</p>
        pub fn set_route_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.route_selection_expression = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of tags associated with the API.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A collection of tags associated with the API.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>A version identifier for the API.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>A version identifier for the API.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Appends an item to `warnings`.
        ///
        /// To override the contents of this collection use [`set_warnings`](Self::set_warnings).
        ///
        /// <p>The warning messages reported when failonwarnings is turned on during API import.</p>
        pub fn warnings(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.warnings.unwrap_or_default();
            v.push(input.into());
            self.warnings = Some(v);
            self
        }
        /// <p>The warning messages reported when failonwarnings is turned on during API import.</p>
        pub fn set_warnings(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.warnings = input;
            self
        }
        /// Consumes the builder and constructs a [`GetApiOutput`](crate::output::GetApiOutput)
        pub fn build(self) -> crate::output::GetApiOutput {
            crate::output::GetApiOutput {
                api_endpoint: self.api_endpoint,
                api_gateway_managed: self.api_gateway_managed.unwrap_or_default(),
                api_id: self.api_id,
                api_key_selection_expression: self.api_key_selection_expression,
                cors_configuration: self.cors_configuration,
                created_date: self.created_date,
                description: self.description,
                disable_schema_validation: self.disable_schema_validation.unwrap_or_default(),
                disable_execute_api_endpoint: self.disable_execute_api_endpoint.unwrap_or_default(),
                import_info: self.import_info,
                name: self.name,
                protocol_type: self.protocol_type,
                route_selection_expression: self.route_selection_expression,
                tags: self.tags,
                version: self.version,
                warnings: self.warnings,
            }
        }
    }
}
impl GetApiOutput {
    /// Creates a new builder-style object to manufacture [`GetApiOutput`](crate::output::GetApiOutput)
    pub fn builder() -> crate::output::get_api_output::Builder {
        crate::output::get_api_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExportApiOutput {
    /// <p>Represents an exported definition of an API in a particular output format, for example, YAML. The API is serialized to the requested specification, for example, OpenAPI 3.0.</p>
    pub body: std::option::Option<aws_smithy_types::Blob>,
}
impl ExportApiOutput {
    /// <p>Represents an exported definition of an API in a particular output format, for example, YAML. The API is serialized to the requested specification, for example, OpenAPI 3.0.</p>
    pub fn body(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.body.as_ref()
    }
}
impl std::fmt::Debug for ExportApiOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExportApiOutput");
        formatter.field("body", &self.body);
        formatter.finish()
    }
}
/// See [`ExportApiOutput`](crate::output::ExportApiOutput)
pub mod export_api_output {
    /// A builder for [`ExportApiOutput`](crate::output::ExportApiOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) body: std::option::Option<aws_smithy_types::Blob>,
    }
    impl Builder {
        /// <p>Represents an exported definition of an API in a particular output format, for example, YAML. The API is serialized to the requested specification, for example, OpenAPI 3.0.</p>
        pub fn body(mut self, input: aws_smithy_types::Blob) -> Self {
            self.body = Some(input);
            self
        }
        /// <p>Represents an exported definition of an API in a particular output format, for example, YAML. The API is serialized to the requested specification, for example, OpenAPI 3.0.</p>
        pub fn set_body(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.body = input;
            self
        }
        /// Consumes the builder and constructs a [`ExportApiOutput`](crate::output::ExportApiOutput)
        pub fn build(self) -> crate::output::ExportApiOutput {
            crate::output::ExportApiOutput { body: self.body }
        }
    }
}
impl ExportApiOutput {
    /// Creates a new builder-style object to manufacture [`ExportApiOutput`](crate::output::ExportApiOutput)
    pub fn builder() -> crate::output::export_api_output::Builder {
        crate::output::export_api_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteVpcLinkOutput {}
impl std::fmt::Debug for DeleteVpcLinkOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteVpcLinkOutput");
        formatter.finish()
    }
}
/// See [`DeleteVpcLinkOutput`](crate::output::DeleteVpcLinkOutput)
pub mod delete_vpc_link_output {
    /// A builder for [`DeleteVpcLinkOutput`](crate::output::DeleteVpcLinkOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteVpcLinkOutput`](crate::output::DeleteVpcLinkOutput)
        pub fn build(self) -> crate::output::DeleteVpcLinkOutput {
            crate::output::DeleteVpcLinkOutput {}
        }
    }
}
impl DeleteVpcLinkOutput {
    /// Creates a new builder-style object to manufacture [`DeleteVpcLinkOutput`](crate::output::DeleteVpcLinkOutput)
    pub fn builder() -> crate::output::delete_vpc_link_output::Builder {
        crate::output::delete_vpc_link_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteStageOutput {}
impl std::fmt::Debug for DeleteStageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteStageOutput");
        formatter.finish()
    }
}
/// See [`DeleteStageOutput`](crate::output::DeleteStageOutput)
pub mod delete_stage_output {
    /// A builder for [`DeleteStageOutput`](crate::output::DeleteStageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteStageOutput`](crate::output::DeleteStageOutput)
        pub fn build(self) -> crate::output::DeleteStageOutput {
            crate::output::DeleteStageOutput {}
        }
    }
}
impl DeleteStageOutput {
    /// Creates a new builder-style object to manufacture [`DeleteStageOutput`](crate::output::DeleteStageOutput)
    pub fn builder() -> crate::output::delete_stage_output::Builder {
        crate::output::delete_stage_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRouteSettingsOutput {}
impl std::fmt::Debug for DeleteRouteSettingsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRouteSettingsOutput");
        formatter.finish()
    }
}
/// See [`DeleteRouteSettingsOutput`](crate::output::DeleteRouteSettingsOutput)
pub mod delete_route_settings_output {
    /// A builder for [`DeleteRouteSettingsOutput`](crate::output::DeleteRouteSettingsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteRouteSettingsOutput`](crate::output::DeleteRouteSettingsOutput)
        pub fn build(self) -> crate::output::DeleteRouteSettingsOutput {
            crate::output::DeleteRouteSettingsOutput {}
        }
    }
}
impl DeleteRouteSettingsOutput {
    /// Creates a new builder-style object to manufacture [`DeleteRouteSettingsOutput`](crate::output::DeleteRouteSettingsOutput)
    pub fn builder() -> crate::output::delete_route_settings_output::Builder {
        crate::output::delete_route_settings_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRouteResponseOutput {}
impl std::fmt::Debug for DeleteRouteResponseOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRouteResponseOutput");
        formatter.finish()
    }
}
/// See [`DeleteRouteResponseOutput`](crate::output::DeleteRouteResponseOutput)
pub mod delete_route_response_output {
    /// A builder for [`DeleteRouteResponseOutput`](crate::output::DeleteRouteResponseOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteRouteResponseOutput`](crate::output::DeleteRouteResponseOutput)
        pub fn build(self) -> crate::output::DeleteRouteResponseOutput {
            crate::output::DeleteRouteResponseOutput {}
        }
    }
}
impl DeleteRouteResponseOutput {
    /// Creates a new builder-style object to manufacture [`DeleteRouteResponseOutput`](crate::output::DeleteRouteResponseOutput)
    pub fn builder() -> crate::output::delete_route_response_output::Builder {
        crate::output::delete_route_response_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRouteRequestParameterOutput {}
impl std::fmt::Debug for DeleteRouteRequestParameterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRouteRequestParameterOutput");
        formatter.finish()
    }
}
/// See [`DeleteRouteRequestParameterOutput`](crate::output::DeleteRouteRequestParameterOutput)
pub mod delete_route_request_parameter_output {
    /// A builder for [`DeleteRouteRequestParameterOutput`](crate::output::DeleteRouteRequestParameterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteRouteRequestParameterOutput`](crate::output::DeleteRouteRequestParameterOutput)
        pub fn build(self) -> crate::output::DeleteRouteRequestParameterOutput {
            crate::output::DeleteRouteRequestParameterOutput {}
        }
    }
}
impl DeleteRouteRequestParameterOutput {
    /// Creates a new builder-style object to manufacture [`DeleteRouteRequestParameterOutput`](crate::output::DeleteRouteRequestParameterOutput)
    pub fn builder() -> crate::output::delete_route_request_parameter_output::Builder {
        crate::output::delete_route_request_parameter_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRouteOutput {}
impl std::fmt::Debug for DeleteRouteOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRouteOutput");
        formatter.finish()
    }
}
/// See [`DeleteRouteOutput`](crate::output::DeleteRouteOutput)
pub mod delete_route_output {
    /// A builder for [`DeleteRouteOutput`](crate::output::DeleteRouteOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteRouteOutput`](crate::output::DeleteRouteOutput)
        pub fn build(self) -> crate::output::DeleteRouteOutput {
            crate::output::DeleteRouteOutput {}
        }
    }
}
impl DeleteRouteOutput {
    /// Creates a new builder-style object to manufacture [`DeleteRouteOutput`](crate::output::DeleteRouteOutput)
    pub fn builder() -> crate::output::delete_route_output::Builder {
        crate::output::delete_route_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteModelOutput {}
impl std::fmt::Debug for DeleteModelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteModelOutput");
        formatter.finish()
    }
}
/// See [`DeleteModelOutput`](crate::output::DeleteModelOutput)
pub mod delete_model_output {
    /// A builder for [`DeleteModelOutput`](crate::output::DeleteModelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteModelOutput`](crate::output::DeleteModelOutput)
        pub fn build(self) -> crate::output::DeleteModelOutput {
            crate::output::DeleteModelOutput {}
        }
    }
}
impl DeleteModelOutput {
    /// Creates a new builder-style object to manufacture [`DeleteModelOutput`](crate::output::DeleteModelOutput)
    pub fn builder() -> crate::output::delete_model_output::Builder {
        crate::output::delete_model_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteIntegrationResponseOutput {}
impl std::fmt::Debug for DeleteIntegrationResponseOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteIntegrationResponseOutput");
        formatter.finish()
    }
}
/// See [`DeleteIntegrationResponseOutput`](crate::output::DeleteIntegrationResponseOutput)
pub mod delete_integration_response_output {
    /// A builder for [`DeleteIntegrationResponseOutput`](crate::output::DeleteIntegrationResponseOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteIntegrationResponseOutput`](crate::output::DeleteIntegrationResponseOutput)
        pub fn build(self) -> crate::output::DeleteIntegrationResponseOutput {
            crate::output::DeleteIntegrationResponseOutput {}
        }
    }
}
impl DeleteIntegrationResponseOutput {
    /// Creates a new builder-style object to manufacture [`DeleteIntegrationResponseOutput`](crate::output::DeleteIntegrationResponseOutput)
    pub fn builder() -> crate::output::delete_integration_response_output::Builder {
        crate::output::delete_integration_response_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteIntegrationOutput {}
impl std::fmt::Debug for DeleteIntegrationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteIntegrationOutput");
        formatter.finish()
    }
}
/// See [`DeleteIntegrationOutput`](crate::output::DeleteIntegrationOutput)
pub mod delete_integration_output {
    /// A builder for [`DeleteIntegrationOutput`](crate::output::DeleteIntegrationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteIntegrationOutput`](crate::output::DeleteIntegrationOutput)
        pub fn build(self) -> crate::output::DeleteIntegrationOutput {
            crate::output::DeleteIntegrationOutput {}
        }
    }
}
impl DeleteIntegrationOutput {
    /// Creates a new builder-style object to manufacture [`DeleteIntegrationOutput`](crate::output::DeleteIntegrationOutput)
    pub fn builder() -> crate::output::delete_integration_output::Builder {
        crate::output::delete_integration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDomainNameOutput {}
impl std::fmt::Debug for DeleteDomainNameOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDomainNameOutput");
        formatter.finish()
    }
}
/// See [`DeleteDomainNameOutput`](crate::output::DeleteDomainNameOutput)
pub mod delete_domain_name_output {
    /// A builder for [`DeleteDomainNameOutput`](crate::output::DeleteDomainNameOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteDomainNameOutput`](crate::output::DeleteDomainNameOutput)
        pub fn build(self) -> crate::output::DeleteDomainNameOutput {
            crate::output::DeleteDomainNameOutput {}
        }
    }
}
impl DeleteDomainNameOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDomainNameOutput`](crate::output::DeleteDomainNameOutput)
    pub fn builder() -> crate::output::delete_domain_name_output::Builder {
        crate::output::delete_domain_name_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDeploymentOutput {}
impl std::fmt::Debug for DeleteDeploymentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDeploymentOutput");
        formatter.finish()
    }
}
/// See [`DeleteDeploymentOutput`](crate::output::DeleteDeploymentOutput)
pub mod delete_deployment_output {
    /// A builder for [`DeleteDeploymentOutput`](crate::output::DeleteDeploymentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteDeploymentOutput`](crate::output::DeleteDeploymentOutput)
        pub fn build(self) -> crate::output::DeleteDeploymentOutput {
            crate::output::DeleteDeploymentOutput {}
        }
    }
}
impl DeleteDeploymentOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDeploymentOutput`](crate::output::DeleteDeploymentOutput)
    pub fn builder() -> crate::output::delete_deployment_output::Builder {
        crate::output::delete_deployment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteCorsConfigurationOutput {}
impl std::fmt::Debug for DeleteCorsConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteCorsConfigurationOutput");
        formatter.finish()
    }
}
/// See [`DeleteCorsConfigurationOutput`](crate::output::DeleteCorsConfigurationOutput)
pub mod delete_cors_configuration_output {
    /// A builder for [`DeleteCorsConfigurationOutput`](crate::output::DeleteCorsConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteCorsConfigurationOutput`](crate::output::DeleteCorsConfigurationOutput)
        pub fn build(self) -> crate::output::DeleteCorsConfigurationOutput {
            crate::output::DeleteCorsConfigurationOutput {}
        }
    }
}
impl DeleteCorsConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`DeleteCorsConfigurationOutput`](crate::output::DeleteCorsConfigurationOutput)
    pub fn builder() -> crate::output::delete_cors_configuration_output::Builder {
        crate::output::delete_cors_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAuthorizerOutput {}
impl std::fmt::Debug for DeleteAuthorizerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAuthorizerOutput");
        formatter.finish()
    }
}
/// See [`DeleteAuthorizerOutput`](crate::output::DeleteAuthorizerOutput)
pub mod delete_authorizer_output {
    /// A builder for [`DeleteAuthorizerOutput`](crate::output::DeleteAuthorizerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteAuthorizerOutput`](crate::output::DeleteAuthorizerOutput)
        pub fn build(self) -> crate::output::DeleteAuthorizerOutput {
            crate::output::DeleteAuthorizerOutput {}
        }
    }
}
impl DeleteAuthorizerOutput {
    /// Creates a new builder-style object to manufacture [`DeleteAuthorizerOutput`](crate::output::DeleteAuthorizerOutput)
    pub fn builder() -> crate::output::delete_authorizer_output::Builder {
        crate::output::delete_authorizer_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteApiMappingOutput {}
impl std::fmt::Debug for DeleteApiMappingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteApiMappingOutput");
        formatter.finish()
    }
}
/// See [`DeleteApiMappingOutput`](crate::output::DeleteApiMappingOutput)
pub mod delete_api_mapping_output {
    /// A builder for [`DeleteApiMappingOutput`](crate::output::DeleteApiMappingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteApiMappingOutput`](crate::output::DeleteApiMappingOutput)
        pub fn build(self) -> crate::output::DeleteApiMappingOutput {
            crate::output::DeleteApiMappingOutput {}
        }
    }
}
impl DeleteApiMappingOutput {
    /// Creates a new builder-style object to manufacture [`DeleteApiMappingOutput`](crate::output::DeleteApiMappingOutput)
    pub fn builder() -> crate::output::delete_api_mapping_output::Builder {
        crate::output::delete_api_mapping_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteApiOutput {}
impl std::fmt::Debug for DeleteApiOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteApiOutput");
        formatter.finish()
    }
}
/// See [`DeleteApiOutput`](crate::output::DeleteApiOutput)
pub mod delete_api_output {
    /// A builder for [`DeleteApiOutput`](crate::output::DeleteApiOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteApiOutput`](crate::output::DeleteApiOutput)
        pub fn build(self) -> crate::output::DeleteApiOutput {
            crate::output::DeleteApiOutput {}
        }
    }
}
impl DeleteApiOutput {
    /// Creates a new builder-style object to manufacture [`DeleteApiOutput`](crate::output::DeleteApiOutput)
    pub fn builder() -> crate::output::delete_api_output::Builder {
        crate::output::delete_api_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAccessLogSettingsOutput {}
impl std::fmt::Debug for DeleteAccessLogSettingsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAccessLogSettingsOutput");
        formatter.finish()
    }
}
/// See [`DeleteAccessLogSettingsOutput`](crate::output::DeleteAccessLogSettingsOutput)
pub mod delete_access_log_settings_output {
    /// A builder for [`DeleteAccessLogSettingsOutput`](crate::output::DeleteAccessLogSettingsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteAccessLogSettingsOutput`](crate::output::DeleteAccessLogSettingsOutput)
        pub fn build(self) -> crate::output::DeleteAccessLogSettingsOutput {
            crate::output::DeleteAccessLogSettingsOutput {}
        }
    }
}
impl DeleteAccessLogSettingsOutput {
    /// Creates a new builder-style object to manufacture [`DeleteAccessLogSettingsOutput`](crate::output::DeleteAccessLogSettingsOutput)
    pub fn builder() -> crate::output::delete_access_log_settings_output::Builder {
        crate::output::delete_access_log_settings_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateVpcLinkOutput {
    /// <p>The timestamp when the VPC link was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The name of the VPC link.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A list of security group IDs for the VPC link.</p>
    pub security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of subnet IDs to include in the VPC link.</p>
    pub subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Tags for the VPC link.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The ID of the VPC link.</p>
    pub vpc_link_id: std::option::Option<std::string::String>,
    /// <p>The status of the VPC link.</p>
    pub vpc_link_status: std::option::Option<crate::model::VpcLinkStatus>,
    /// <p>A message summarizing the cause of the status of the VPC link.</p>
    pub vpc_link_status_message: std::option::Option<std::string::String>,
    /// <p>The version of the VPC link.</p>
    pub vpc_link_version: std::option::Option<crate::model::VpcLinkVersion>,
}
impl CreateVpcLinkOutput {
    /// <p>The timestamp when the VPC link was created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_date.as_ref()
    }
    /// <p>The name of the VPC link.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A list of security group IDs for the VPC link.</p>
    pub fn security_group_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.security_group_ids.as_deref()
    }
    /// <p>A list of subnet IDs to include in the VPC link.</p>
    pub fn subnet_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.subnet_ids.as_deref()
    }
    /// <p>Tags for the VPC link.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The ID of the VPC link.</p>
    pub fn vpc_link_id(&self) -> std::option::Option<&str> {
        self.vpc_link_id.as_deref()
    }
    /// <p>The status of the VPC link.</p>
    pub fn vpc_link_status(&self) -> std::option::Option<&crate::model::VpcLinkStatus> {
        self.vpc_link_status.as_ref()
    }
    /// <p>A message summarizing the cause of the status of the VPC link.</p>
    pub fn vpc_link_status_message(&self) -> std::option::Option<&str> {
        self.vpc_link_status_message.as_deref()
    }
    /// <p>The version of the VPC link.</p>
    pub fn vpc_link_version(&self) -> std::option::Option<&crate::model::VpcLinkVersion> {
        self.vpc_link_version.as_ref()
    }
}
impl std::fmt::Debug for CreateVpcLinkOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateVpcLinkOutput");
        formatter.field("created_date", &self.created_date);
        formatter.field("name", &self.name);
        formatter.field("security_group_ids", &self.security_group_ids);
        formatter.field("subnet_ids", &self.subnet_ids);
        formatter.field("tags", &self.tags);
        formatter.field("vpc_link_id", &self.vpc_link_id);
        formatter.field("vpc_link_status", &self.vpc_link_status);
        formatter.field("vpc_link_status_message", &self.vpc_link_status_message);
        formatter.field("vpc_link_version", &self.vpc_link_version);
        formatter.finish()
    }
}
/// See [`CreateVpcLinkOutput`](crate::output::CreateVpcLinkOutput)
pub mod create_vpc_link_output {
    /// A builder for [`CreateVpcLinkOutput`](crate::output::CreateVpcLinkOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) created_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) vpc_link_id: std::option::Option<std::string::String>,
        pub(crate) vpc_link_status: std::option::Option<crate::model::VpcLinkStatus>,
        pub(crate) vpc_link_status_message: std::option::Option<std::string::String>,
        pub(crate) vpc_link_version: std::option::Option<crate::model::VpcLinkVersion>,
    }
    impl Builder {
        /// <p>The timestamp when the VPC link was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The timestamp when the VPC link was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>The name of the VPC link.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the VPC link.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>A list of security group IDs for the VPC link.</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.security_group_ids = Some(v);
            self
        }
        /// <p>A list of security group IDs for the VPC link.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_ids = input;
            self
        }
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>A list of subnet IDs to include in the VPC link.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>A list of subnet IDs to include in the VPC link.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags for the VPC link.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Tags for the VPC link.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The ID of the VPC link.</p>
        pub fn vpc_link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_link_id = Some(input.into());
            self
        }
        /// <p>The ID of the VPC link.</p>
        pub fn set_vpc_link_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_link_id = input;
            self
        }
        /// <p>The status of the VPC link.</p>
        pub fn vpc_link_status(mut self, input: crate::model::VpcLinkStatus) -> Self {
            self.vpc_link_status = Some(input);
            self
        }
        /// <p>The status of the VPC link.</p>
        pub fn set_vpc_link_status(
            mut self,
            input: std::option::Option<crate::model::VpcLinkStatus>,
        ) -> Self {
            self.vpc_link_status = input;
            self
        }
        /// <p>A message summarizing the cause of the status of the VPC link.</p>
        pub fn vpc_link_status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_link_status_message = Some(input.into());
            self
        }
        /// <p>A message summarizing the cause of the status of the VPC link.</p>
        pub fn set_vpc_link_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vpc_link_status_message = input;
            self
        }
        /// <p>The version of the VPC link.</p>
        pub fn vpc_link_version(mut self, input: crate::model::VpcLinkVersion) -> Self {
            self.vpc_link_version = Some(input);
            self
        }
        /// <p>The version of the VPC link.</p>
        pub fn set_vpc_link_version(
            mut self,
            input: std::option::Option<crate::model::VpcLinkVersion>,
        ) -> Self {
            self.vpc_link_version = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateVpcLinkOutput`](crate::output::CreateVpcLinkOutput)
        pub fn build(self) -> crate::output::CreateVpcLinkOutput {
            crate::output::CreateVpcLinkOutput {
                created_date: self.created_date,
                name: self.name,
                security_group_ids: self.security_group_ids,
                subnet_ids: self.subnet_ids,
                tags: self.tags,
                vpc_link_id: self.vpc_link_id,
                vpc_link_status: self.vpc_link_status,
                vpc_link_status_message: self.vpc_link_status_message,
                vpc_link_version: self.vpc_link_version,
            }
        }
    }
}
impl CreateVpcLinkOutput {
    /// Creates a new builder-style object to manufacture [`CreateVpcLinkOutput`](crate::output::CreateVpcLinkOutput)
    pub fn builder() -> crate::output::create_vpc_link_output::Builder {
        crate::output::create_vpc_link_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateStageOutput {
    /// <p>Settings for logging access in this stage.</p>
    pub access_log_settings: std::option::Option<crate::model::AccessLogSettings>,
    /// <p>Specifies whether a stage is managed by API Gateway. If you created an API using quick create, the $default stage is managed by API Gateway. You can't modify the $default stage.</p>
    pub api_gateway_managed: bool,
    /// <p>Specifies whether updates to an API automatically trigger a new deployment. The default value is false.</p>
    pub auto_deploy: bool,
    /// <p>The identifier of a client certificate for a Stage. Supported only for WebSocket APIs.</p>
    pub client_certificate_id: std::option::Option<std::string::String>,
    /// <p>The timestamp when the stage was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Default route settings for the stage.</p>
    pub default_route_settings: std::option::Option<crate::model::RouteSettings>,
    /// <p>The identifier of the Deployment that the Stage is associated with. Can't be updated if autoDeploy is enabled.</p>
    pub deployment_id: std::option::Option<std::string::String>,
    /// <p>The description of the stage.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Describes the status of the last deployment of a stage. Supported only for stages with autoDeploy enabled.</p>
    pub last_deployment_status_message: std::option::Option<std::string::String>,
    /// <p>The timestamp when the stage was last updated.</p>
    pub last_updated_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Route settings for the stage, by routeKey.</p>
    pub route_settings: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::RouteSettings>,
    >,
    /// <p>The name of the stage.</p>
    pub stage_name: std::option::Option<std::string::String>,
    /// <p>A map that defines the stage variables for a stage resource. Variable names can have alphanumeric and underscore characters, and the values must match [A-Za-z0-9-._~:/?#&amp;=,]+.</p>
    pub stage_variables:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateStageOutput {
    /// <p>Settings for logging access in this stage.</p>
    pub fn access_log_settings(&self) -> std::option::Option<&crate::model::AccessLogSettings> {
        self.access_log_settings.as_ref()
    }
    /// <p>Specifies whether a stage is managed by API Gateway. If you created an API using quick create, the $default stage is managed by API Gateway. You can't modify the $default stage.</p>
    pub fn api_gateway_managed(&self) -> bool {
        self.api_gateway_managed
    }
    /// <p>Specifies whether updates to an API automatically trigger a new deployment. The default value is false.</p>
    pub fn auto_deploy(&self) -> bool {
        self.auto_deploy
    }
    /// <p>The identifier of a client certificate for a Stage. Supported only for WebSocket APIs.</p>
    pub fn client_certificate_id(&self) -> std::option::Option<&str> {
        self.client_certificate_id.as_deref()
    }
    /// <p>The timestamp when the stage was created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_date.as_ref()
    }
    /// <p>Default route settings for the stage.</p>
    pub fn default_route_settings(&self) -> std::option::Option<&crate::model::RouteSettings> {
        self.default_route_settings.as_ref()
    }
    /// <p>The identifier of the Deployment that the Stage is associated with. Can't be updated if autoDeploy is enabled.</p>
    pub fn deployment_id(&self) -> std::option::Option<&str> {
        self.deployment_id.as_deref()
    }
    /// <p>The description of the stage.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Describes the status of the last deployment of a stage. Supported only for stages with autoDeploy enabled.</p>
    pub fn last_deployment_status_message(&self) -> std::option::Option<&str> {
        self.last_deployment_status_message.as_deref()
    }
    /// <p>The timestamp when the stage was last updated.</p>
    pub fn last_updated_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_updated_date.as_ref()
    }
    /// <p>Route settings for the stage, by routeKey.</p>
    pub fn route_settings(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::RouteSettings>,
    > {
        self.route_settings.as_ref()
    }
    /// <p>The name of the stage.</p>
    pub fn stage_name(&self) -> std::option::Option<&str> {
        self.stage_name.as_deref()
    }
    /// <p>A map that defines the stage variables for a stage resource. Variable names can have alphanumeric and underscore characters, and the values must match [A-Za-z0-9-._~:/?#&amp;=,]+.</p>
    pub fn stage_variables(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.stage_variables.as_ref()
    }
    /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateStageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateStageOutput");
        formatter.field("access_log_settings", &self.access_log_settings);
        formatter.field("api_gateway_managed", &self.api_gateway_managed);
        formatter.field("auto_deploy", &self.auto_deploy);
        formatter.field("client_certificate_id", &self.client_certificate_id);
        formatter.field("created_date", &self.created_date);
        formatter.field("default_route_settings", &self.default_route_settings);
        formatter.field("deployment_id", &self.deployment_id);
        formatter.field("description", &self.description);
        formatter.field(
            "last_deployment_status_message",
            &self.last_deployment_status_message,
        );
        formatter.field("last_updated_date", &self.last_updated_date);
        formatter.field("route_settings", &self.route_settings);
        formatter.field("stage_name", &self.stage_name);
        formatter.field("stage_variables", &self.stage_variables);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`CreateStageOutput`](crate::output::CreateStageOutput)
pub mod create_stage_output {
    /// A builder for [`CreateStageOutput`](crate::output::CreateStageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_log_settings: std::option::Option<crate::model::AccessLogSettings>,
        pub(crate) api_gateway_managed: std::option::Option<bool>,
        pub(crate) auto_deploy: std::option::Option<bool>,
        pub(crate) client_certificate_id: std::option::Option<std::string::String>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) default_route_settings: std::option::Option<crate::model::RouteSettings>,
        pub(crate) deployment_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) last_deployment_status_message: std::option::Option<std::string::String>,
        pub(crate) last_updated_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) route_settings: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::RouteSettings>,
        >,
        pub(crate) stage_name: std::option::Option<std::string::String>,
        pub(crate) stage_variables: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>Settings for logging access in this stage.</p>
        pub fn access_log_settings(mut self, input: crate::model::AccessLogSettings) -> Self {
            self.access_log_settings = Some(input);
            self
        }
        /// <p>Settings for logging access in this stage.</p>
        pub fn set_access_log_settings(
            mut self,
            input: std::option::Option<crate::model::AccessLogSettings>,
        ) -> Self {
            self.access_log_settings = input;
            self
        }
        /// <p>Specifies whether a stage is managed by API Gateway. If you created an API using quick create, the $default stage is managed by API Gateway. You can't modify the $default stage.</p>
        pub fn api_gateway_managed(mut self, input: bool) -> Self {
            self.api_gateway_managed = Some(input);
            self
        }
        /// <p>Specifies whether a stage is managed by API Gateway. If you created an API using quick create, the $default stage is managed by API Gateway. You can't modify the $default stage.</p>
        pub fn set_api_gateway_managed(mut self, input: std::option::Option<bool>) -> Self {
            self.api_gateway_managed = input;
            self
        }
        /// <p>Specifies whether updates to an API automatically trigger a new deployment. The default value is false.</p>
        pub fn auto_deploy(mut self, input: bool) -> Self {
            self.auto_deploy = Some(input);
            self
        }
        /// <p>Specifies whether updates to an API automatically trigger a new deployment. The default value is false.</p>
        pub fn set_auto_deploy(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_deploy = input;
            self
        }
        /// <p>The identifier of a client certificate for a Stage. Supported only for WebSocket APIs.</p>
        pub fn client_certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_certificate_id = Some(input.into());
            self
        }
        /// <p>The identifier of a client certificate for a Stage. Supported only for WebSocket APIs.</p>
        pub fn set_client_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_certificate_id = input;
            self
        }
        /// <p>The timestamp when the stage was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The timestamp when the stage was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>Default route settings for the stage.</p>
        pub fn default_route_settings(mut self, input: crate::model::RouteSettings) -> Self {
            self.default_route_settings = Some(input);
            self
        }
        /// <p>Default route settings for the stage.</p>
        pub fn set_default_route_settings(
            mut self,
            input: std::option::Option<crate::model::RouteSettings>,
        ) -> Self {
            self.default_route_settings = input;
            self
        }
        /// <p>The identifier of the Deployment that the Stage is associated with. Can't be updated if autoDeploy is enabled.</p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Deployment that the Stage is associated with. Can't be updated if autoDeploy is enabled.</p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_id = input;
            self
        }
        /// <p>The description of the stage.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the stage.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Describes the status of the last deployment of a stage. Supported only for stages with autoDeploy enabled.</p>
        pub fn last_deployment_status_message(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.last_deployment_status_message = Some(input.into());
            self
        }
        /// <p>Describes the status of the last deployment of a stage. Supported only for stages with autoDeploy enabled.</p>
        pub fn set_last_deployment_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_deployment_status_message = input;
            self
        }
        /// <p>The timestamp when the stage was last updated.</p>
        pub fn last_updated_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_date = Some(input);
            self
        }
        /// <p>The timestamp when the stage was last updated.</p>
        pub fn set_last_updated_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_date = input;
            self
        }
        /// Adds a key-value pair to `route_settings`.
        ///
        /// To override the contents of this collection use [`set_route_settings`](Self::set_route_settings).
        ///
        /// <p>Route settings for the stage, by routeKey.</p>
        pub fn route_settings(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::RouteSettings>,
        ) -> Self {
            let mut hash_map = self.route_settings.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.route_settings = Some(hash_map);
            self
        }
        /// <p>Route settings for the stage, by routeKey.</p>
        pub fn set_route_settings(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::RouteSettings>,
            >,
        ) -> Self {
            self.route_settings = input;
            self
        }
        /// <p>The name of the stage.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stage_name = Some(input.into());
            self
        }
        /// <p>The name of the stage.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stage_name = input;
            self
        }
        /// Adds a key-value pair to `stage_variables`.
        ///
        /// To override the contents of this collection use [`set_stage_variables`](Self::set_stage_variables).
        ///
        /// <p>A map that defines the stage variables for a stage resource. Variable names can have alphanumeric and underscore characters, and the values must match [A-Za-z0-9-._~:/?#&amp;=,]+.</p>
        pub fn stage_variables(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.stage_variables.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.stage_variables = Some(hash_map);
            self
        }
        /// <p>A map that defines the stage variables for a stage resource. Variable names can have alphanumeric and underscore characters, and the values must match [A-Za-z0-9-._~:/?#&amp;=,]+.</p>
        pub fn set_stage_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.stage_variables = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateStageOutput`](crate::output::CreateStageOutput)
        pub fn build(self) -> crate::output::CreateStageOutput {
            crate::output::CreateStageOutput {
                access_log_settings: self.access_log_settings,
                api_gateway_managed: self.api_gateway_managed.unwrap_or_default(),
                auto_deploy: self.auto_deploy.unwrap_or_default(),
                client_certificate_id: self.client_certificate_id,
                created_date: self.created_date,
                default_route_settings: self.default_route_settings,
                deployment_id: self.deployment_id,
                description: self.description,
                last_deployment_status_message: self.last_deployment_status_message,
                last_updated_date: self.last_updated_date,
                route_settings: self.route_settings,
                stage_name: self.stage_name,
                stage_variables: self.stage_variables,
                tags: self.tags,
            }
        }
    }
}
impl CreateStageOutput {
    /// Creates a new builder-style object to manufacture [`CreateStageOutput`](crate::output::CreateStageOutput)
    pub fn builder() -> crate::output::create_stage_output::Builder {
        crate::output::create_stage_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRouteResponseOutput {
    /// <p>Represents the model selection expression of a route response. Supported only for WebSocket APIs.</p>
    pub model_selection_expression: std::option::Option<std::string::String>,
    /// <p>Represents the response models of a route response.</p>
    pub response_models:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Represents the response parameters of a route response.</p>
    pub response_parameters: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::ParameterConstraints>,
    >,
    /// <p>Represents the identifier of a route response.</p>
    pub route_response_id: std::option::Option<std::string::String>,
    /// <p>Represents the route response key of a route response.</p>
    pub route_response_key: std::option::Option<std::string::String>,
}
impl CreateRouteResponseOutput {
    /// <p>Represents the model selection expression of a route response. Supported only for WebSocket APIs.</p>
    pub fn model_selection_expression(&self) -> std::option::Option<&str> {
        self.model_selection_expression.as_deref()
    }
    /// <p>Represents the response models of a route response.</p>
    pub fn response_models(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.response_models.as_ref()
    }
    /// <p>Represents the response parameters of a route response.</p>
    pub fn response_parameters(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::ParameterConstraints>,
    > {
        self.response_parameters.as_ref()
    }
    /// <p>Represents the identifier of a route response.</p>
    pub fn route_response_id(&self) -> std::option::Option<&str> {
        self.route_response_id.as_deref()
    }
    /// <p>Represents the route response key of a route response.</p>
    pub fn route_response_key(&self) -> std::option::Option<&str> {
        self.route_response_key.as_deref()
    }
}
impl std::fmt::Debug for CreateRouteResponseOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRouteResponseOutput");
        formatter.field(
            "model_selection_expression",
            &self.model_selection_expression,
        );
        formatter.field("response_models", &self.response_models);
        formatter.field("response_parameters", &self.response_parameters);
        formatter.field("route_response_id", &self.route_response_id);
        formatter.field("route_response_key", &self.route_response_key);
        formatter.finish()
    }
}
/// See [`CreateRouteResponseOutput`](crate::output::CreateRouteResponseOutput)
pub mod create_route_response_output {
    /// A builder for [`CreateRouteResponseOutput`](crate::output::CreateRouteResponseOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) model_selection_expression: std::option::Option<std::string::String>,
        pub(crate) response_models: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) response_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::ParameterConstraints>,
        >,
        pub(crate) route_response_id: std::option::Option<std::string::String>,
        pub(crate) route_response_key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Represents the model selection expression of a route response. Supported only for WebSocket APIs.</p>
        pub fn model_selection_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_selection_expression = Some(input.into());
            self
        }
        /// <p>Represents the model selection expression of a route response. Supported only for WebSocket APIs.</p>
        pub fn set_model_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_selection_expression = input;
            self
        }
        /// Adds a key-value pair to `response_models`.
        ///
        /// To override the contents of this collection use [`set_response_models`](Self::set_response_models).
        ///
        /// <p>Represents the response models of a route response.</p>
        pub fn response_models(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.response_models.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.response_models = Some(hash_map);
            self
        }
        /// <p>Represents the response models of a route response.</p>
        pub fn set_response_models(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.response_models = input;
            self
        }
        /// Adds a key-value pair to `response_parameters`.
        ///
        /// To override the contents of this collection use [`set_response_parameters`](Self::set_response_parameters).
        ///
        /// <p>Represents the response parameters of a route response.</p>
        pub fn response_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::ParameterConstraints>,
        ) -> Self {
            let mut hash_map = self.response_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.response_parameters = Some(hash_map);
            self
        }
        /// <p>Represents the response parameters of a route response.</p>
        pub fn set_response_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::ParameterConstraints>,
            >,
        ) -> Self {
            self.response_parameters = input;
            self
        }
        /// <p>Represents the identifier of a route response.</p>
        pub fn route_response_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_response_id = Some(input.into());
            self
        }
        /// <p>Represents the identifier of a route response.</p>
        pub fn set_route_response_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.route_response_id = input;
            self
        }
        /// <p>Represents the route response key of a route response.</p>
        pub fn route_response_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_response_key = Some(input.into());
            self
        }
        /// <p>Represents the route response key of a route response.</p>
        pub fn set_route_response_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.route_response_key = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRouteResponseOutput`](crate::output::CreateRouteResponseOutput)
        pub fn build(self) -> crate::output::CreateRouteResponseOutput {
            crate::output::CreateRouteResponseOutput {
                model_selection_expression: self.model_selection_expression,
                response_models: self.response_models,
                response_parameters: self.response_parameters,
                route_response_id: self.route_response_id,
                route_response_key: self.route_response_key,
            }
        }
    }
}
impl CreateRouteResponseOutput {
    /// Creates a new builder-style object to manufacture [`CreateRouteResponseOutput`](crate::output::CreateRouteResponseOutput)
    pub fn builder() -> crate::output::create_route_response_output::Builder {
        crate::output::create_route_response_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRouteOutput {
    /// <p>Specifies whether a route is managed by API Gateway. If you created an API using quick create, the $default route is managed by API Gateway. You can't modify the $default route key.</p>
    pub api_gateway_managed: bool,
    /// <p>Specifies whether an API key is required for this route. Supported only for WebSocket APIs.</p>
    pub api_key_required: bool,
    /// <p>A list of authorization scopes configured on a route. The scopes are used with a JWT authorizer to authorize the method invocation. The authorization works by matching the route scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any route scope matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the route scope is configured, the client must provide an access token instead of an identity token for authorization purposes.</p>
    pub authorization_scopes: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The authorization type for the route. For WebSocket APIs, valid values are NONE for open access, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer For HTTP APIs, valid values are NONE for open access, JWT for using JSON Web Tokens, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer.</p>
    pub authorization_type: std::option::Option<crate::model::AuthorizationType>,
    /// <p>The identifier of the Authorizer resource to be associated with this route. The authorizer identifier is generated by API Gateway when you created the authorizer.</p>
    pub authorizer_id: std::option::Option<std::string::String>,
    /// <p>The model selection expression for the route. Supported only for WebSocket APIs.</p>
    pub model_selection_expression: std::option::Option<std::string::String>,
    /// <p>The operation name for the route.</p>
    pub operation_name: std::option::Option<std::string::String>,
    /// <p>The request models for the route. Supported only for WebSocket APIs.</p>
    pub request_models:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The request parameters for the route. Supported only for WebSocket APIs.</p>
    pub request_parameters: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::ParameterConstraints>,
    >,
    /// <p>The route ID.</p>
    pub route_id: std::option::Option<std::string::String>,
    /// <p>The route key for the route.</p>
    pub route_key: std::option::Option<std::string::String>,
    /// <p>The route response selection expression for the route. Supported only for WebSocket APIs.</p>
    pub route_response_selection_expression: std::option::Option<std::string::String>,
    /// <p>The target for the route.</p>
    pub target: std::option::Option<std::string::String>,
}
impl CreateRouteOutput {
    /// <p>Specifies whether a route is managed by API Gateway. If you created an API using quick create, the $default route is managed by API Gateway. You can't modify the $default route key.</p>
    pub fn api_gateway_managed(&self) -> bool {
        self.api_gateway_managed
    }
    /// <p>Specifies whether an API key is required for this route. Supported only for WebSocket APIs.</p>
    pub fn api_key_required(&self) -> bool {
        self.api_key_required
    }
    /// <p>A list of authorization scopes configured on a route. The scopes are used with a JWT authorizer to authorize the method invocation. The authorization works by matching the route scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any route scope matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the route scope is configured, the client must provide an access token instead of an identity token for authorization purposes.</p>
    pub fn authorization_scopes(&self) -> std::option::Option<&[std::string::String]> {
        self.authorization_scopes.as_deref()
    }
    /// <p>The authorization type for the route. For WebSocket APIs, valid values are NONE for open access, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer For HTTP APIs, valid values are NONE for open access, JWT for using JSON Web Tokens, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer.</p>
    pub fn authorization_type(&self) -> std::option::Option<&crate::model::AuthorizationType> {
        self.authorization_type.as_ref()
    }
    /// <p>The identifier of the Authorizer resource to be associated with this route. The authorizer identifier is generated by API Gateway when you created the authorizer.</p>
    pub fn authorizer_id(&self) -> std::option::Option<&str> {
        self.authorizer_id.as_deref()
    }
    /// <p>The model selection expression for the route. Supported only for WebSocket APIs.</p>
    pub fn model_selection_expression(&self) -> std::option::Option<&str> {
        self.model_selection_expression.as_deref()
    }
    /// <p>The operation name for the route.</p>
    pub fn operation_name(&self) -> std::option::Option<&str> {
        self.operation_name.as_deref()
    }
    /// <p>The request models for the route. Supported only for WebSocket APIs.</p>
    pub fn request_models(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.request_models.as_ref()
    }
    /// <p>The request parameters for the route. Supported only for WebSocket APIs.</p>
    pub fn request_parameters(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::ParameterConstraints>,
    > {
        self.request_parameters.as_ref()
    }
    /// <p>The route ID.</p>
    pub fn route_id(&self) -> std::option::Option<&str> {
        self.route_id.as_deref()
    }
    /// <p>The route key for the route.</p>
    pub fn route_key(&self) -> std::option::Option<&str> {
        self.route_key.as_deref()
    }
    /// <p>The route response selection expression for the route. Supported only for WebSocket APIs.</p>
    pub fn route_response_selection_expression(&self) -> std::option::Option<&str> {
        self.route_response_selection_expression.as_deref()
    }
    /// <p>The target for the route.</p>
    pub fn target(&self) -> std::option::Option<&str> {
        self.target.as_deref()
    }
}
impl std::fmt::Debug for CreateRouteOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRouteOutput");
        formatter.field("api_gateway_managed", &self.api_gateway_managed);
        formatter.field("api_key_required", &self.api_key_required);
        formatter.field("authorization_scopes", &self.authorization_scopes);
        formatter.field("authorization_type", &self.authorization_type);
        formatter.field("authorizer_id", &self.authorizer_id);
        formatter.field(
            "model_selection_expression",
            &self.model_selection_expression,
        );
        formatter.field("operation_name", &self.operation_name);
        formatter.field("request_models", &self.request_models);
        formatter.field("request_parameters", &self.request_parameters);
        formatter.field("route_id", &self.route_id);
        formatter.field("route_key", &self.route_key);
        formatter.field(
            "route_response_selection_expression",
            &self.route_response_selection_expression,
        );
        formatter.field("target", &self.target);
        formatter.finish()
    }
}
/// See [`CreateRouteOutput`](crate::output::CreateRouteOutput)
pub mod create_route_output {
    /// A builder for [`CreateRouteOutput`](crate::output::CreateRouteOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_gateway_managed: std::option::Option<bool>,
        pub(crate) api_key_required: std::option::Option<bool>,
        pub(crate) authorization_scopes: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) authorization_type: std::option::Option<crate::model::AuthorizationType>,
        pub(crate) authorizer_id: std::option::Option<std::string::String>,
        pub(crate) model_selection_expression: std::option::Option<std::string::String>,
        pub(crate) operation_name: std::option::Option<std::string::String>,
        pub(crate) request_models: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) request_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::ParameterConstraints>,
        >,
        pub(crate) route_id: std::option::Option<std::string::String>,
        pub(crate) route_key: std::option::Option<std::string::String>,
        pub(crate) route_response_selection_expression: std::option::Option<std::string::String>,
        pub(crate) target: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies whether a route is managed by API Gateway. If you created an API using quick create, the $default route is managed by API Gateway. You can't modify the $default route key.</p>
        pub fn api_gateway_managed(mut self, input: bool) -> Self {
            self.api_gateway_managed = Some(input);
            self
        }
        /// <p>Specifies whether a route is managed by API Gateway. If you created an API using quick create, the $default route is managed by API Gateway. You can't modify the $default route key.</p>
        pub fn set_api_gateway_managed(mut self, input: std::option::Option<bool>) -> Self {
            self.api_gateway_managed = input;
            self
        }
        /// <p>Specifies whether an API key is required for this route. Supported only for WebSocket APIs.</p>
        pub fn api_key_required(mut self, input: bool) -> Self {
            self.api_key_required = Some(input);
            self
        }
        /// <p>Specifies whether an API key is required for this route. Supported only for WebSocket APIs.</p>
        pub fn set_api_key_required(mut self, input: std::option::Option<bool>) -> Self {
            self.api_key_required = input;
            self
        }
        /// Appends an item to `authorization_scopes`.
        ///
        /// To override the contents of this collection use [`set_authorization_scopes`](Self::set_authorization_scopes).
        ///
        /// <p>A list of authorization scopes configured on a route. The scopes are used with a JWT authorizer to authorize the method invocation. The authorization works by matching the route scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any route scope matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the route scope is configured, the client must provide an access token instead of an identity token for authorization purposes.</p>
        pub fn authorization_scopes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.authorization_scopes.unwrap_or_default();
            v.push(input.into());
            self.authorization_scopes = Some(v);
            self
        }
        /// <p>A list of authorization scopes configured on a route. The scopes are used with a JWT authorizer to authorize the method invocation. The authorization works by matching the route scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any route scope matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the route scope is configured, the client must provide an access token instead of an identity token for authorization purposes.</p>
        pub fn set_authorization_scopes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.authorization_scopes = input;
            self
        }
        /// <p>The authorization type for the route. For WebSocket APIs, valid values are NONE for open access, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer For HTTP APIs, valid values are NONE for open access, JWT for using JSON Web Tokens, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer.</p>
        pub fn authorization_type(mut self, input: crate::model::AuthorizationType) -> Self {
            self.authorization_type = Some(input);
            self
        }
        /// <p>The authorization type for the route. For WebSocket APIs, valid values are NONE for open access, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer For HTTP APIs, valid values are NONE for open access, JWT for using JSON Web Tokens, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer.</p>
        pub fn set_authorization_type(
            mut self,
            input: std::option::Option<crate::model::AuthorizationType>,
        ) -> Self {
            self.authorization_type = input;
            self
        }
        /// <p>The identifier of the Authorizer resource to be associated with this route. The authorizer identifier is generated by API Gateway when you created the authorizer.</p>
        pub fn authorizer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorizer_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Authorizer resource to be associated with this route. The authorizer identifier is generated by API Gateway when you created the authorizer.</p>
        pub fn set_authorizer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorizer_id = input;
            self
        }
        /// <p>The model selection expression for the route. Supported only for WebSocket APIs.</p>
        pub fn model_selection_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_selection_expression = Some(input.into());
            self
        }
        /// <p>The model selection expression for the route. Supported only for WebSocket APIs.</p>
        pub fn set_model_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_selection_expression = input;
            self
        }
        /// <p>The operation name for the route.</p>
        pub fn operation_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation_name = Some(input.into());
            self
        }
        /// <p>The operation name for the route.</p>
        pub fn set_operation_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.operation_name = input;
            self
        }
        /// Adds a key-value pair to `request_models`.
        ///
        /// To override the contents of this collection use [`set_request_models`](Self::set_request_models).
        ///
        /// <p>The request models for the route. Supported only for WebSocket APIs.</p>
        pub fn request_models(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.request_models.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.request_models = Some(hash_map);
            self
        }
        /// <p>The request models for the route. Supported only for WebSocket APIs.</p>
        pub fn set_request_models(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.request_models = input;
            self
        }
        /// Adds a key-value pair to `request_parameters`.
        ///
        /// To override the contents of this collection use [`set_request_parameters`](Self::set_request_parameters).
        ///
        /// <p>The request parameters for the route. Supported only for WebSocket APIs.</p>
        pub fn request_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::ParameterConstraints>,
        ) -> Self {
            let mut hash_map = self.request_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.request_parameters = Some(hash_map);
            self
        }
        /// <p>The request parameters for the route. Supported only for WebSocket APIs.</p>
        pub fn set_request_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::ParameterConstraints>,
            >,
        ) -> Self {
            self.request_parameters = input;
            self
        }
        /// <p>The route ID.</p>
        pub fn route_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_id = Some(input.into());
            self
        }
        /// <p>The route ID.</p>
        pub fn set_route_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.route_id = input;
            self
        }
        /// <p>The route key for the route.</p>
        pub fn route_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_key = Some(input.into());
            self
        }
        /// <p>The route key for the route.</p>
        pub fn set_route_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.route_key = input;
            self
        }
        /// <p>The route response selection expression for the route. Supported only for WebSocket APIs.</p>
        pub fn route_response_selection_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.route_response_selection_expression = Some(input.into());
            self
        }
        /// <p>The route response selection expression for the route. Supported only for WebSocket APIs.</p>
        pub fn set_route_response_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.route_response_selection_expression = input;
            self
        }
        /// <p>The target for the route.</p>
        pub fn target(mut self, input: impl Into<std::string::String>) -> Self {
            self.target = Some(input.into());
            self
        }
        /// <p>The target for the route.</p>
        pub fn set_target(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRouteOutput`](crate::output::CreateRouteOutput)
        pub fn build(self) -> crate::output::CreateRouteOutput {
            crate::output::CreateRouteOutput {
                api_gateway_managed: self.api_gateway_managed.unwrap_or_default(),
                api_key_required: self.api_key_required.unwrap_or_default(),
                authorization_scopes: self.authorization_scopes,
                authorization_type: self.authorization_type,
                authorizer_id: self.authorizer_id,
                model_selection_expression: self.model_selection_expression,
                operation_name: self.operation_name,
                request_models: self.request_models,
                request_parameters: self.request_parameters,
                route_id: self.route_id,
                route_key: self.route_key,
                route_response_selection_expression: self.route_response_selection_expression,
                target: self.target,
            }
        }
    }
}
impl CreateRouteOutput {
    /// Creates a new builder-style object to manufacture [`CreateRouteOutput`](crate::output::CreateRouteOutput)
    pub fn builder() -> crate::output::create_route_output::Builder {
        crate::output::create_route_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateModelOutput {
    /// <p>The content-type for the model, for example, "application/json".</p>
    pub content_type: std::option::Option<std::string::String>,
    /// <p>The description of the model.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The model identifier.</p>
    pub model_id: std::option::Option<std::string::String>,
    /// <p>The name of the model. Must be alphanumeric.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The schema for the model. For application/json models, this should be JSON schema draft 4 model.</p>
    pub schema: std::option::Option<std::string::String>,
}
impl CreateModelOutput {
    /// <p>The content-type for the model, for example, "application/json".</p>
    pub fn content_type(&self) -> std::option::Option<&str> {
        self.content_type.as_deref()
    }
    /// <p>The description of the model.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The model identifier.</p>
    pub fn model_id(&self) -> std::option::Option<&str> {
        self.model_id.as_deref()
    }
    /// <p>The name of the model. Must be alphanumeric.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The schema for the model. For application/json models, this should be JSON schema draft 4 model.</p>
    pub fn schema(&self) -> std::option::Option<&str> {
        self.schema.as_deref()
    }
}
impl std::fmt::Debug for CreateModelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateModelOutput");
        formatter.field("content_type", &self.content_type);
        formatter.field("description", &self.description);
        formatter.field("model_id", &self.model_id);
        formatter.field("name", &self.name);
        formatter.field("schema", &self.schema);
        formatter.finish()
    }
}
/// See [`CreateModelOutput`](crate::output::CreateModelOutput)
pub mod create_model_output {
    /// A builder for [`CreateModelOutput`](crate::output::CreateModelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) content_type: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) model_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) schema: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The content-type for the model, for example, "application/json".</p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_type = Some(input.into());
            self
        }
        /// <p>The content-type for the model, for example, "application/json".</p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_type = input;
            self
        }
        /// <p>The description of the model.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the model.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The model identifier.</p>
        pub fn model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_id = Some(input.into());
            self
        }
        /// <p>The model identifier.</p>
        pub fn set_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.model_id = input;
            self
        }
        /// <p>The name of the model. Must be alphanumeric.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the model. Must be alphanumeric.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The schema for the model. For application/json models, this should be JSON schema draft 4 model.</p>
        pub fn schema(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema = Some(input.into());
            self
        }
        /// <p>The schema for the model. For application/json models, this should be JSON schema draft 4 model.</p>
        pub fn set_schema(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateModelOutput`](crate::output::CreateModelOutput)
        pub fn build(self) -> crate::output::CreateModelOutput {
            crate::output::CreateModelOutput {
                content_type: self.content_type,
                description: self.description,
                model_id: self.model_id,
                name: self.name,
                schema: self.schema,
            }
        }
    }
}
impl CreateModelOutput {
    /// Creates a new builder-style object to manufacture [`CreateModelOutput`](crate::output::CreateModelOutput)
    pub fn builder() -> crate::output::create_model_output::Builder {
        crate::output::create_model_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateIntegrationResponseOutput {
    /// <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p> <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p> <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p> <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
    pub content_handling_strategy: std::option::Option<crate::model::ContentHandlingStrategy>,
    /// <p>The integration response ID.</p>
    pub integration_response_id: std::option::Option<std::string::String>,
    /// <p>The integration response key.</p>
    pub integration_response_key: std::option::Option<std::string::String>,
    /// <p>A key-value map specifying response parameters that are passed to the method response from the backend. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of method.response.header.{name}, where name is a valid and unique header name. The mapped non-static value must match the pattern of integration.response.header.{name} or integration.response.body.{JSON-expression}, where name is a valid and unique response header name and JSON-expression is a valid JSON expression without the $ prefix.</p>
    pub response_parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The collection of response templates for the integration response as a string-to-string map of key-value pairs. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.</p>
    pub response_templates:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The template selection expressions for the integration response.</p>
    pub template_selection_expression: std::option::Option<std::string::String>,
}
impl CreateIntegrationResponseOutput {
    /// <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p> <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p> <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p> <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
    pub fn content_handling_strategy(
        &self,
    ) -> std::option::Option<&crate::model::ContentHandlingStrategy> {
        self.content_handling_strategy.as_ref()
    }
    /// <p>The integration response ID.</p>
    pub fn integration_response_id(&self) -> std::option::Option<&str> {
        self.integration_response_id.as_deref()
    }
    /// <p>The integration response key.</p>
    pub fn integration_response_key(&self) -> std::option::Option<&str> {
        self.integration_response_key.as_deref()
    }
    /// <p>A key-value map specifying response parameters that are passed to the method response from the backend. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of method.response.header.{name}, where name is a valid and unique header name. The mapped non-static value must match the pattern of integration.response.header.{name} or integration.response.body.{JSON-expression}, where name is a valid and unique response header name and JSON-expression is a valid JSON expression without the $ prefix.</p>
    pub fn response_parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.response_parameters.as_ref()
    }
    /// <p>The collection of response templates for the integration response as a string-to-string map of key-value pairs. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.</p>
    pub fn response_templates(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.response_templates.as_ref()
    }
    /// <p>The template selection expressions for the integration response.</p>
    pub fn template_selection_expression(&self) -> std::option::Option<&str> {
        self.template_selection_expression.as_deref()
    }
}
impl std::fmt::Debug for CreateIntegrationResponseOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateIntegrationResponseOutput");
        formatter.field("content_handling_strategy", &self.content_handling_strategy);
        formatter.field("integration_response_id", &self.integration_response_id);
        formatter.field("integration_response_key", &self.integration_response_key);
        formatter.field("response_parameters", &self.response_parameters);
        formatter.field("response_templates", &self.response_templates);
        formatter.field(
            "template_selection_expression",
            &self.template_selection_expression,
        );
        formatter.finish()
    }
}
/// See [`CreateIntegrationResponseOutput`](crate::output::CreateIntegrationResponseOutput)
pub mod create_integration_response_output {
    /// A builder for [`CreateIntegrationResponseOutput`](crate::output::CreateIntegrationResponseOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) content_handling_strategy:
            std::option::Option<crate::model::ContentHandlingStrategy>,
        pub(crate) integration_response_id: std::option::Option<std::string::String>,
        pub(crate) integration_response_key: std::option::Option<std::string::String>,
        pub(crate) response_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) response_templates: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) template_selection_expression: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p> <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p> <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p> <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
        pub fn content_handling_strategy(
            mut self,
            input: crate::model::ContentHandlingStrategy,
        ) -> Self {
            self.content_handling_strategy = Some(input);
            self
        }
        /// <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p> <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p> <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p> <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
        pub fn set_content_handling_strategy(
            mut self,
            input: std::option::Option<crate::model::ContentHandlingStrategy>,
        ) -> Self {
            self.content_handling_strategy = input;
            self
        }
        /// <p>The integration response ID.</p>
        pub fn integration_response_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.integration_response_id = Some(input.into());
            self
        }
        /// <p>The integration response ID.</p>
        pub fn set_integration_response_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.integration_response_id = input;
            self
        }
        /// <p>The integration response key.</p>
        pub fn integration_response_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.integration_response_key = Some(input.into());
            self
        }
        /// <p>The integration response key.</p>
        pub fn set_integration_response_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.integration_response_key = input;
            self
        }
        /// Adds a key-value pair to `response_parameters`.
        ///
        /// To override the contents of this collection use [`set_response_parameters`](Self::set_response_parameters).
        ///
        /// <p>A key-value map specifying response parameters that are passed to the method response from the backend. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of method.response.header.{name}, where name is a valid and unique header name. The mapped non-static value must match the pattern of integration.response.header.{name} or integration.response.body.{JSON-expression}, where name is a valid and unique response header name and JSON-expression is a valid JSON expression without the $ prefix.</p>
        pub fn response_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.response_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.response_parameters = Some(hash_map);
            self
        }
        /// <p>A key-value map specifying response parameters that are passed to the method response from the backend. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of method.response.header.{name}, where name is a valid and unique header name. The mapped non-static value must match the pattern of integration.response.header.{name} or integration.response.body.{JSON-expression}, where name is a valid and unique response header name and JSON-expression is a valid JSON expression without the $ prefix.</p>
        pub fn set_response_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.response_parameters = input;
            self
        }
        /// Adds a key-value pair to `response_templates`.
        ///
        /// To override the contents of this collection use [`set_response_templates`](Self::set_response_templates).
        ///
        /// <p>The collection of response templates for the integration response as a string-to-string map of key-value pairs. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.</p>
        pub fn response_templates(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.response_templates.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.response_templates = Some(hash_map);
            self
        }
        /// <p>The collection of response templates for the integration response as a string-to-string map of key-value pairs. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.</p>
        pub fn set_response_templates(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.response_templates = input;
            self
        }
        /// <p>The template selection expressions for the integration response.</p>
        pub fn template_selection_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.template_selection_expression = Some(input.into());
            self
        }
        /// <p>The template selection expressions for the integration response.</p>
        pub fn set_template_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_selection_expression = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateIntegrationResponseOutput`](crate::output::CreateIntegrationResponseOutput)
        pub fn build(self) -> crate::output::CreateIntegrationResponseOutput {
            crate::output::CreateIntegrationResponseOutput {
                content_handling_strategy: self.content_handling_strategy,
                integration_response_id: self.integration_response_id,
                integration_response_key: self.integration_response_key,
                response_parameters: self.response_parameters,
                response_templates: self.response_templates,
                template_selection_expression: self.template_selection_expression,
            }
        }
    }
}
impl CreateIntegrationResponseOutput {
    /// Creates a new builder-style object to manufacture [`CreateIntegrationResponseOutput`](crate::output::CreateIntegrationResponseOutput)
    pub fn builder() -> crate::output::create_integration_response_output::Builder {
        crate::output::create_integration_response_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateIntegrationOutput {
    /// <p>Specifies whether an integration is managed by API Gateway. If you created an API using using quick create, the resulting integration is managed by API Gateway. You can update a managed integration, but you can't delete it.</p>
    pub api_gateway_managed: bool,
    /// <p>The ID of the VPC link for a private integration. Supported only for HTTP APIs.</p>
    pub connection_id: std::option::Option<std::string::String>,
    /// <p>The type of the network connection to the integration endpoint. Specify INTERNET for connections through the public routable internet or VPC_LINK for private connections between API Gateway and resources in a VPC. The default value is INTERNET.</p>
    pub connection_type: std::option::Option<crate::model::ConnectionType>,
    /// <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p> <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p> <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p> <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
    pub content_handling_strategy: std::option::Option<crate::model::ContentHandlingStrategy>,
    /// <p>Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, specify null.</p>
    pub credentials_arn: std::option::Option<std::string::String>,
    /// <p>Represents the description of an integration.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Represents the identifier of an integration.</p>
    pub integration_id: std::option::Option<std::string::String>,
    /// <p>Specifies the integration's HTTP method type.</p>
    pub integration_method: std::option::Option<std::string::String>,
    /// <p>The integration response selection expression for the integration. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-integration-response-selection-expressions">Integration Response Selection Expressions</a>.</p>
    pub integration_response_selection_expression: std::option::Option<std::string::String>,
    /// <p>Supported only for HTTP API AWS_PROXY integrations. Specifies the AWS service action to invoke. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html">Integration subtype reference</a>.</p>
    pub integration_subtype: std::option::Option<std::string::String>,
    /// <p>The integration type of an integration. One of the following:</p> <p>AWS: for integrating the route or method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration. Supported only for WebSocket APIs.</p> <p>AWS_PROXY: for integrating the route or method request with a Lambda function or other AWS service action. This integration is also referred to as a Lambda proxy integration.</p> <p>HTTP: for integrating the route or method request with an HTTP endpoint. This integration is also referred to as the HTTP custom integration. Supported only for WebSocket APIs.</p> <p>HTTP_PROXY: for integrating the route or method request with an HTTP endpoint, with the client request passed through as-is. This is also referred to as HTTP proxy integration.</p> <p>MOCK: for integrating the route or method request with API Gateway as a "loopback" endpoint without invoking any backend. Supported only for WebSocket APIs.</p>
    pub integration_type: std::option::Option<crate::model::IntegrationType>,
    /// <p>For a Lambda integration, specify the URI of a Lambda function.</p> <p>For an HTTP integration, specify a fully-qualified URL.</p> <p>For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service. If you specify the ARN of an AWS Cloud Map service, API Gateway uses DiscoverInstances to identify resources. You can use query parameters to target specific resources. To learn more, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_DiscoverInstances.html">DiscoverInstances</a>. For private integrations, all resources must be owned by the same AWS account.</p>
    pub integration_uri: std::option::Option<std::string::String>,
    /// <p>Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER. Supported only for WebSocket APIs.</p> <p>WHEN_NO_MATCH passes the request body for unmapped content types through to the integration backend without transformation.</p> <p>NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type response.</p> <p>WHEN_NO_TEMPLATES allows pass-through when the integration has no content types mapped to templates. However, if there is at least one content type defined, unmapped content types will be rejected with the same HTTP 415 Unsupported Media Type response.</p>
    pub passthrough_behavior: std::option::Option<crate::model::PassthroughBehavior>,
    /// <p>Specifies the format of the payload sent to an integration. Required for HTTP APIs.</p>
    pub payload_format_version: std::option::Option<std::string::String>,
    /// <p>For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the backend. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the backend. The method request parameter value must match the pattern of method.request.<replaceable>{location}</replaceable>.<replaceable>{name}</replaceable>
    /// , where
    /// <replaceable>{location}</replaceable>
    /// is querystring, path, or header; and
    /// <replaceable>{name}</replaceable>
    /// must be a valid and unique method request parameter name.</p> <p>For HTTP API integrations with a specified integrationSubtype, request parameters are a key-value map specifying parameters that are passed to AWS_PROXY integrations. You can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services.html">Working with AWS service integrations for HTTP APIs</a>.</p> <p>For HTTP API itegrations, without a specified integrationSubtype request parameters are a key-value map specifying how to transform HTTP requests before sending them to backend integrations. The key should follow the pattern &lt;action&gt;:&lt;header|querystring|path&gt;.&lt;location&gt;. The action can be append, overwrite or remove. For values, you can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
    pub request_parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value. Supported only for WebSocket APIs.</p>
    pub request_templates:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Supported only for HTTP APIs. You use response parameters to transform the HTTP response from a backend integration before returning the response to clients. Specify a key-value map from a selection key to response parameters. The selection key must be a valid HTTP status code within the range of 200-599. Response parameters are a key-value map. The key must match pattern &lt;action&gt;:&lt;header&gt;.&lt;location&gt; or overwrite.statuscode. The action can be append, overwrite or remove. The value can be a static value, or map to response data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
    pub response_parameters: std::option::Option<
        std::collections::HashMap<
            std::string::String,
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    >,
    /// <p>The template selection expression for the integration. Supported only for WebSocket APIs.</p>
    pub template_selection_expression: std::option::Option<std::string::String>,
    /// <p>Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs. The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.</p>
    pub timeout_in_millis: i32,
    /// <p>The TLS configuration for a private integration. If you specify a TLS configuration, private integration traffic uses the HTTPS protocol. Supported only for HTTP APIs.</p>
    pub tls_config: std::option::Option<crate::model::TlsConfig>,
}
impl CreateIntegrationOutput {
    /// <p>Specifies whether an integration is managed by API Gateway. If you created an API using using quick create, the resulting integration is managed by API Gateway. You can update a managed integration, but you can't delete it.</p>
    pub fn api_gateway_managed(&self) -> bool {
        self.api_gateway_managed
    }
    /// <p>The ID of the VPC link for a private integration. Supported only for HTTP APIs.</p>
    pub fn connection_id(&self) -> std::option::Option<&str> {
        self.connection_id.as_deref()
    }
    /// <p>The type of the network connection to the integration endpoint. Specify INTERNET for connections through the public routable internet or VPC_LINK for private connections between API Gateway and resources in a VPC. The default value is INTERNET.</p>
    pub fn connection_type(&self) -> std::option::Option<&crate::model::ConnectionType> {
        self.connection_type.as_ref()
    }
    /// <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p> <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p> <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p> <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
    pub fn content_handling_strategy(
        &self,
    ) -> std::option::Option<&crate::model::ContentHandlingStrategy> {
        self.content_handling_strategy.as_ref()
    }
    /// <p>Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, specify null.</p>
    pub fn credentials_arn(&self) -> std::option::Option<&str> {
        self.credentials_arn.as_deref()
    }
    /// <p>Represents the description of an integration.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Represents the identifier of an integration.</p>
    pub fn integration_id(&self) -> std::option::Option<&str> {
        self.integration_id.as_deref()
    }
    /// <p>Specifies the integration's HTTP method type.</p>
    pub fn integration_method(&self) -> std::option::Option<&str> {
        self.integration_method.as_deref()
    }
    /// <p>The integration response selection expression for the integration. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-integration-response-selection-expressions">Integration Response Selection Expressions</a>.</p>
    pub fn integration_response_selection_expression(&self) -> std::option::Option<&str> {
        self.integration_response_selection_expression.as_deref()
    }
    /// <p>Supported only for HTTP API AWS_PROXY integrations. Specifies the AWS service action to invoke. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html">Integration subtype reference</a>.</p>
    pub fn integration_subtype(&self) -> std::option::Option<&str> {
        self.integration_subtype.as_deref()
    }
    /// <p>The integration type of an integration. One of the following:</p> <p>AWS: for integrating the route or method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration. Supported only for WebSocket APIs.</p> <p>AWS_PROXY: for integrating the route or method request with a Lambda function or other AWS service action. This integration is also referred to as a Lambda proxy integration.</p> <p>HTTP: for integrating the route or method request with an HTTP endpoint. This integration is also referred to as the HTTP custom integration. Supported only for WebSocket APIs.</p> <p>HTTP_PROXY: for integrating the route or method request with an HTTP endpoint, with the client request passed through as-is. This is also referred to as HTTP proxy integration.</p> <p>MOCK: for integrating the route or method request with API Gateway as a "loopback" endpoint without invoking any backend. Supported only for WebSocket APIs.</p>
    pub fn integration_type(&self) -> std::option::Option<&crate::model::IntegrationType> {
        self.integration_type.as_ref()
    }
    /// <p>For a Lambda integration, specify the URI of a Lambda function.</p> <p>For an HTTP integration, specify a fully-qualified URL.</p> <p>For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service. If you specify the ARN of an AWS Cloud Map service, API Gateway uses DiscoverInstances to identify resources. You can use query parameters to target specific resources. To learn more, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_DiscoverInstances.html">DiscoverInstances</a>. For private integrations, all resources must be owned by the same AWS account.</p>
    pub fn integration_uri(&self) -> std::option::Option<&str> {
        self.integration_uri.as_deref()
    }
    /// <p>Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER. Supported only for WebSocket APIs.</p> <p>WHEN_NO_MATCH passes the request body for unmapped content types through to the integration backend without transformation.</p> <p>NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type response.</p> <p>WHEN_NO_TEMPLATES allows pass-through when the integration has no content types mapped to templates. However, if there is at least one content type defined, unmapped content types will be rejected with the same HTTP 415 Unsupported Media Type response.</p>
    pub fn passthrough_behavior(&self) -> std::option::Option<&crate::model::PassthroughBehavior> {
        self.passthrough_behavior.as_ref()
    }
    /// <p>Specifies the format of the payload sent to an integration. Required for HTTP APIs.</p>
    pub fn payload_format_version(&self) -> std::option::Option<&str> {
        self.payload_format_version.as_deref()
    }
    /// <p>For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the backend. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the backend. The method request parameter value must match the pattern of method.request.<replaceable>{location}</replaceable>.<replaceable>{name}</replaceable>
    /// , where
    /// <replaceable>{location}</replaceable>
    /// is querystring, path, or header; and
    /// <replaceable>{name}</replaceable>
    /// must be a valid and unique method request parameter name.</p> <p>For HTTP API integrations with a specified integrationSubtype, request parameters are a key-value map specifying parameters that are passed to AWS_PROXY integrations. You can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services.html">Working with AWS service integrations for HTTP APIs</a>.</p> <p>For HTTP API itegrations, without a specified integrationSubtype request parameters are a key-value map specifying how to transform HTTP requests before sending them to backend integrations. The key should follow the pattern &lt;action&gt;:&lt;header|querystring|path&gt;.&lt;location&gt;. The action can be append, overwrite or remove. For values, you can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
    pub fn request_parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.request_parameters.as_ref()
    }
    /// <p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value. Supported only for WebSocket APIs.</p>
    pub fn request_templates(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.request_templates.as_ref()
    }
    /// <p>Supported only for HTTP APIs. You use response parameters to transform the HTTP response from a backend integration before returning the response to clients. Specify a key-value map from a selection key to response parameters. The selection key must be a valid HTTP status code within the range of 200-599. Response parameters are a key-value map. The key must match pattern &lt;action&gt;:&lt;header&gt;.&lt;location&gt; or overwrite.statuscode. The action can be append, overwrite or remove. The value can be a static value, or map to response data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
    pub fn response_parameters(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<
            std::string::String,
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    > {
        self.response_parameters.as_ref()
    }
    /// <p>The template selection expression for the integration. Supported only for WebSocket APIs.</p>
    pub fn template_selection_expression(&self) -> std::option::Option<&str> {
        self.template_selection_expression.as_deref()
    }
    /// <p>Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs. The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.</p>
    pub fn timeout_in_millis(&self) -> i32 {
        self.timeout_in_millis
    }
    /// <p>The TLS configuration for a private integration. If you specify a TLS configuration, private integration traffic uses the HTTPS protocol. Supported only for HTTP APIs.</p>
    pub fn tls_config(&self) -> std::option::Option<&crate::model::TlsConfig> {
        self.tls_config.as_ref()
    }
}
impl std::fmt::Debug for CreateIntegrationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateIntegrationOutput");
        formatter.field("api_gateway_managed", &self.api_gateway_managed);
        formatter.field("connection_id", &self.connection_id);
        formatter.field("connection_type", &self.connection_type);
        formatter.field("content_handling_strategy", &self.content_handling_strategy);
        formatter.field("credentials_arn", &self.credentials_arn);
        formatter.field("description", &self.description);
        formatter.field("integration_id", &self.integration_id);
        formatter.field("integration_method", &self.integration_method);
        formatter.field(
            "integration_response_selection_expression",
            &self.integration_response_selection_expression,
        );
        formatter.field("integration_subtype", &self.integration_subtype);
        formatter.field("integration_type", &self.integration_type);
        formatter.field("integration_uri", &self.integration_uri);
        formatter.field("passthrough_behavior", &self.passthrough_behavior);
        formatter.field("payload_format_version", &self.payload_format_version);
        formatter.field("request_parameters", &self.request_parameters);
        formatter.field("request_templates", &self.request_templates);
        formatter.field("response_parameters", &self.response_parameters);
        formatter.field(
            "template_selection_expression",
            &self.template_selection_expression,
        );
        formatter.field("timeout_in_millis", &self.timeout_in_millis);
        formatter.field("tls_config", &self.tls_config);
        formatter.finish()
    }
}
/// See [`CreateIntegrationOutput`](crate::output::CreateIntegrationOutput)
pub mod create_integration_output {
    /// A builder for [`CreateIntegrationOutput`](crate::output::CreateIntegrationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_gateway_managed: std::option::Option<bool>,
        pub(crate) connection_id: std::option::Option<std::string::String>,
        pub(crate) connection_type: std::option::Option<crate::model::ConnectionType>,
        pub(crate) content_handling_strategy:
            std::option::Option<crate::model::ContentHandlingStrategy>,
        pub(crate) credentials_arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) integration_id: std::option::Option<std::string::String>,
        pub(crate) integration_method: std::option::Option<std::string::String>,
        pub(crate) integration_response_selection_expression:
            std::option::Option<std::string::String>,
        pub(crate) integration_subtype: std::option::Option<std::string::String>,
        pub(crate) integration_type: std::option::Option<crate::model::IntegrationType>,
        pub(crate) integration_uri: std::option::Option<std::string::String>,
        pub(crate) passthrough_behavior: std::option::Option<crate::model::PassthroughBehavior>,
        pub(crate) payload_format_version: std::option::Option<std::string::String>,
        pub(crate) request_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) request_templates: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) response_parameters: std::option::Option<
            std::collections::HashMap<
                std::string::String,
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        >,
        pub(crate) template_selection_expression: std::option::Option<std::string::String>,
        pub(crate) timeout_in_millis: std::option::Option<i32>,
        pub(crate) tls_config: std::option::Option<crate::model::TlsConfig>,
    }
    impl Builder {
        /// <p>Specifies whether an integration is managed by API Gateway. If you created an API using using quick create, the resulting integration is managed by API Gateway. You can update a managed integration, but you can't delete it.</p>
        pub fn api_gateway_managed(mut self, input: bool) -> Self {
            self.api_gateway_managed = Some(input);
            self
        }
        /// <p>Specifies whether an integration is managed by API Gateway. If you created an API using using quick create, the resulting integration is managed by API Gateway. You can update a managed integration, but you can't delete it.</p>
        pub fn set_api_gateway_managed(mut self, input: std::option::Option<bool>) -> Self {
            self.api_gateway_managed = input;
            self
        }
        /// <p>The ID of the VPC link for a private integration. Supported only for HTTP APIs.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_id = Some(input.into());
            self
        }
        /// <p>The ID of the VPC link for a private integration. Supported only for HTTP APIs.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_id = input;
            self
        }
        /// <p>The type of the network connection to the integration endpoint. Specify INTERNET for connections through the public routable internet or VPC_LINK for private connections between API Gateway and resources in a VPC. The default value is INTERNET.</p>
        pub fn connection_type(mut self, input: crate::model::ConnectionType) -> Self {
            self.connection_type = Some(input);
            self
        }
        /// <p>The type of the network connection to the integration endpoint. Specify INTERNET for connections through the public routable internet or VPC_LINK for private connections between API Gateway and resources in a VPC. The default value is INTERNET.</p>
        pub fn set_connection_type(
            mut self,
            input: std::option::Option<crate::model::ConnectionType>,
        ) -> Self {
            self.connection_type = input;
            self
        }
        /// <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p> <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p> <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p> <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
        pub fn content_handling_strategy(
            mut self,
            input: crate::model::ContentHandlingStrategy,
        ) -> Self {
            self.content_handling_strategy = Some(input);
            self
        }
        /// <p>Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p> <p>CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p> <p>CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.</p> <p>If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.</p>
        pub fn set_content_handling_strategy(
            mut self,
            input: std::option::Option<crate::model::ContentHandlingStrategy>,
        ) -> Self {
            self.content_handling_strategy = input;
            self
        }
        /// <p>Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, specify null.</p>
        pub fn credentials_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.credentials_arn = Some(input.into());
            self
        }
        /// <p>Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, specify null.</p>
        pub fn set_credentials_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.credentials_arn = input;
            self
        }
        /// <p>Represents the description of an integration.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Represents the description of an integration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Represents the identifier of an integration.</p>
        pub fn integration_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.integration_id = Some(input.into());
            self
        }
        /// <p>Represents the identifier of an integration.</p>
        pub fn set_integration_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.integration_id = input;
            self
        }
        /// <p>Specifies the integration's HTTP method type.</p>
        pub fn integration_method(mut self, input: impl Into<std::string::String>) -> Self {
            self.integration_method = Some(input.into());
            self
        }
        /// <p>Specifies the integration's HTTP method type.</p>
        pub fn set_integration_method(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.integration_method = input;
            self
        }
        /// <p>The integration response selection expression for the integration. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-integration-response-selection-expressions">Integration Response Selection Expressions</a>.</p>
        pub fn integration_response_selection_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.integration_response_selection_expression = Some(input.into());
            self
        }
        /// <p>The integration response selection expression for the integration. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-integration-response-selection-expressions">Integration Response Selection Expressions</a>.</p>
        pub fn set_integration_response_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.integration_response_selection_expression = input;
            self
        }
        /// <p>Supported only for HTTP API AWS_PROXY integrations. Specifies the AWS service action to invoke. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html">Integration subtype reference</a>.</p>
        pub fn integration_subtype(mut self, input: impl Into<std::string::String>) -> Self {
            self.integration_subtype = Some(input.into());
            self
        }
        /// <p>Supported only for HTTP API AWS_PROXY integrations. Specifies the AWS service action to invoke. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html">Integration subtype reference</a>.</p>
        pub fn set_integration_subtype(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.integration_subtype = input;
            self
        }
        /// <p>The integration type of an integration. One of the following:</p> <p>AWS: for integrating the route or method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration. Supported only for WebSocket APIs.</p> <p>AWS_PROXY: for integrating the route or method request with a Lambda function or other AWS service action. This integration is also referred to as a Lambda proxy integration.</p> <p>HTTP: for integrating the route or method request with an HTTP endpoint. This integration is also referred to as the HTTP custom integration. Supported only for WebSocket APIs.</p> <p>HTTP_PROXY: for integrating the route or method request with an HTTP endpoint, with the client request passed through as-is. This is also referred to as HTTP proxy integration.</p> <p>MOCK: for integrating the route or method request with API Gateway as a "loopback" endpoint without invoking any backend. Supported only for WebSocket APIs.</p>
        pub fn integration_type(mut self, input: crate::model::IntegrationType) -> Self {
            self.integration_type = Some(input);
            self
        }
        /// <p>The integration type of an integration. One of the following:</p> <p>AWS: for integrating the route or method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration. Supported only for WebSocket APIs.</p> <p>AWS_PROXY: for integrating the route or method request with a Lambda function or other AWS service action. This integration is also referred to as a Lambda proxy integration.</p> <p>HTTP: for integrating the route or method request with an HTTP endpoint. This integration is also referred to as the HTTP custom integration. Supported only for WebSocket APIs.</p> <p>HTTP_PROXY: for integrating the route or method request with an HTTP endpoint, with the client request passed through as-is. This is also referred to as HTTP proxy integration.</p> <p>MOCK: for integrating the route or method request with API Gateway as a "loopback" endpoint without invoking any backend. Supported only for WebSocket APIs.</p>
        pub fn set_integration_type(
            mut self,
            input: std::option::Option<crate::model::IntegrationType>,
        ) -> Self {
            self.integration_type = input;
            self
        }
        /// <p>For a Lambda integration, specify the URI of a Lambda function.</p> <p>For an HTTP integration, specify a fully-qualified URL.</p> <p>For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service. If you specify the ARN of an AWS Cloud Map service, API Gateway uses DiscoverInstances to identify resources. You can use query parameters to target specific resources. To learn more, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_DiscoverInstances.html">DiscoverInstances</a>. For private integrations, all resources must be owned by the same AWS account.</p>
        pub fn integration_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.integration_uri = Some(input.into());
            self
        }
        /// <p>For a Lambda integration, specify the URI of a Lambda function.</p> <p>For an HTTP integration, specify a fully-qualified URL.</p> <p>For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service. If you specify the ARN of an AWS Cloud Map service, API Gateway uses DiscoverInstances to identify resources. You can use query parameters to target specific resources. To learn more, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_DiscoverInstances.html">DiscoverInstances</a>. For private integrations, all resources must be owned by the same AWS account.</p>
        pub fn set_integration_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.integration_uri = input;
            self
        }
        /// <p>Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER. Supported only for WebSocket APIs.</p> <p>WHEN_NO_MATCH passes the request body for unmapped content types through to the integration backend without transformation.</p> <p>NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type response.</p> <p>WHEN_NO_TEMPLATES allows pass-through when the integration has no content types mapped to templates. However, if there is at least one content type defined, unmapped content types will be rejected with the same HTTP 415 Unsupported Media Type response.</p>
        pub fn passthrough_behavior(mut self, input: crate::model::PassthroughBehavior) -> Self {
            self.passthrough_behavior = Some(input);
            self
        }
        /// <p>Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER. Supported only for WebSocket APIs.</p> <p>WHEN_NO_MATCH passes the request body for unmapped content types through to the integration backend without transformation.</p> <p>NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type response.</p> <p>WHEN_NO_TEMPLATES allows pass-through when the integration has no content types mapped to templates. However, if there is at least one content type defined, unmapped content types will be rejected with the same HTTP 415 Unsupported Media Type response.</p>
        pub fn set_passthrough_behavior(
            mut self,
            input: std::option::Option<crate::model::PassthroughBehavior>,
        ) -> Self {
            self.passthrough_behavior = input;
            self
        }
        /// <p>Specifies the format of the payload sent to an integration. Required for HTTP APIs.</p>
        pub fn payload_format_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.payload_format_version = Some(input.into());
            self
        }
        /// <p>Specifies the format of the payload sent to an integration. Required for HTTP APIs.</p>
        pub fn set_payload_format_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.payload_format_version = input;
            self
        }
        /// Adds a key-value pair to `request_parameters`.
        ///
        /// To override the contents of this collection use [`set_request_parameters`](Self::set_request_parameters).
        ///
        /// <p>For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the backend. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the backend. The method request parameter value must match the pattern of method.request.<replaceable>{location}</replaceable>.<replaceable>{name}</replaceable>
        /// , where
        /// <replaceable>{location}</replaceable>
        /// is querystring, path, or header; and
        /// <replaceable>{name}</replaceable>
        /// must be a valid and unique method request parameter name.</p> <p>For HTTP API integrations with a specified integrationSubtype, request parameters are a key-value map specifying parameters that are passed to AWS_PROXY integrations. You can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services.html">Working with AWS service integrations for HTTP APIs</a>.</p> <p>For HTTP API itegrations, without a specified integrationSubtype request parameters are a key-value map specifying how to transform HTTP requests before sending them to backend integrations. The key should follow the pattern &lt;action&gt;:&lt;header|querystring|path&gt;.&lt;location&gt;. The action can be append, overwrite or remove. For values, you can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
        pub fn request_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.request_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.request_parameters = Some(hash_map);
            self
        }
        /// <p>For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the backend. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the backend. The method request parameter value must match the pattern of method.request.<replaceable>{location}</replaceable>.<replaceable>{name}</replaceable>
        /// , where
        /// <replaceable>{location}</replaceable>
        /// is querystring, path, or header; and
        /// <replaceable>{name}</replaceable>
        /// must be a valid and unique method request parameter name.</p> <p>For HTTP API integrations with a specified integrationSubtype, request parameters are a key-value map specifying parameters that are passed to AWS_PROXY integrations. You can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services.html">Working with AWS service integrations for HTTP APIs</a>.</p> <p>For HTTP API itegrations, without a specified integrationSubtype request parameters are a key-value map specifying how to transform HTTP requests before sending them to backend integrations. The key should follow the pattern &lt;action&gt;:&lt;header|querystring|path&gt;.&lt;location&gt;. The action can be append, overwrite or remove. For values, you can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
        pub fn set_request_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.request_parameters = input;
            self
        }
        /// Adds a key-value pair to `request_templates`.
        ///
        /// To override the contents of this collection use [`set_request_templates`](Self::set_request_templates).
        ///
        /// <p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value. Supported only for WebSocket APIs.</p>
        pub fn request_templates(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.request_templates.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.request_templates = Some(hash_map);
            self
        }
        /// <p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value. Supported only for WebSocket APIs.</p>
        pub fn set_request_templates(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.request_templates = input;
            self
        }
        /// Adds a key-value pair to `response_parameters`.
        ///
        /// To override the contents of this collection use [`set_response_parameters`](Self::set_response_parameters).
        ///
        /// <p>Supported only for HTTP APIs. You use response parameters to transform the HTTP response from a backend integration before returning the response to clients. Specify a key-value map from a selection key to response parameters. The selection key must be a valid HTTP status code within the range of 200-599. Response parameters are a key-value map. The key must match pattern &lt;action&gt;:&lt;header&gt;.&lt;location&gt; or overwrite.statuscode. The action can be append, overwrite or remove. The value can be a static value, or map to response data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
        pub fn response_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::collections::HashMap<std::string::String, std::string::String>>,
        ) -> Self {
            let mut hash_map = self.response_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.response_parameters = Some(hash_map);
            self
        }
        /// <p>Supported only for HTTP APIs. You use response parameters to transform the HTTP response from a backend integration before returning the response to clients. Specify a key-value map from a selection key to response parameters. The selection key must be a valid HTTP status code within the range of 200-599. Response parameters are a key-value map. The key must match pattern &lt;action&gt;:&lt;header&gt;.&lt;location&gt; or overwrite.statuscode. The action can be append, overwrite or remove. The value can be a static value, or map to response data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a>.</p>
        pub fn set_response_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    std::collections::HashMap<std::string::String, std::string::String>,
                >,
            >,
        ) -> Self {
            self.response_parameters = input;
            self
        }
        /// <p>The template selection expression for the integration. Supported only for WebSocket APIs.</p>
        pub fn template_selection_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.template_selection_expression = Some(input.into());
            self
        }
        /// <p>The template selection expression for the integration. Supported only for WebSocket APIs.</p>
        pub fn set_template_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_selection_expression = input;
            self
        }
        /// <p>Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs. The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.</p>
        pub fn timeout_in_millis(mut self, input: i32) -> Self {
            self.timeout_in_millis = Some(input);
            self
        }
        /// <p>Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs. The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.</p>
        pub fn set_timeout_in_millis(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout_in_millis = input;
            self
        }
        /// <p>The TLS configuration for a private integration. If you specify a TLS configuration, private integration traffic uses the HTTPS protocol. Supported only for HTTP APIs.</p>
        pub fn tls_config(mut self, input: crate::model::TlsConfig) -> Self {
            self.tls_config = Some(input);
            self
        }
        /// <p>The TLS configuration for a private integration. If you specify a TLS configuration, private integration traffic uses the HTTPS protocol. Supported only for HTTP APIs.</p>
        pub fn set_tls_config(
            mut self,
            input: std::option::Option<crate::model::TlsConfig>,
        ) -> Self {
            self.tls_config = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateIntegrationOutput`](crate::output::CreateIntegrationOutput)
        pub fn build(self) -> crate::output::CreateIntegrationOutput {
            crate::output::CreateIntegrationOutput {
                api_gateway_managed: self.api_gateway_managed.unwrap_or_default(),
                connection_id: self.connection_id,
                connection_type: self.connection_type,
                content_handling_strategy: self.content_handling_strategy,
                credentials_arn: self.credentials_arn,
                description: self.description,
                integration_id: self.integration_id,
                integration_method: self.integration_method,
                integration_response_selection_expression: self
                    .integration_response_selection_expression,
                integration_subtype: self.integration_subtype,
                integration_type: self.integration_type,
                integration_uri: self.integration_uri,
                passthrough_behavior: self.passthrough_behavior,
                payload_format_version: self.payload_format_version,
                request_parameters: self.request_parameters,
                request_templates: self.request_templates,
                response_parameters: self.response_parameters,
                template_selection_expression: self.template_selection_expression,
                timeout_in_millis: self.timeout_in_millis.unwrap_or_default(),
                tls_config: self.tls_config,
            }
        }
    }
}
impl CreateIntegrationOutput {
    /// Creates a new builder-style object to manufacture [`CreateIntegrationOutput`](crate::output::CreateIntegrationOutput)
    pub fn builder() -> crate::output::create_integration_output::Builder {
        crate::output::create_integration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDomainNameOutput {
    /// <p>The API mapping selection expression.</p>
    pub api_mapping_selection_expression: std::option::Option<std::string::String>,
    /// <p>The name of the DomainName resource.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The domain name configurations.</p>
    pub domain_name_configurations:
        std::option::Option<std::vec::Vec<crate::model::DomainNameConfiguration>>,
    /// <p>The mutual TLS authentication configuration for a custom domain name.</p>
    pub mutual_tls_authentication: std::option::Option<crate::model::MutualTlsAuthentication>,
    /// <p>The collection of tags associated with a domain name.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateDomainNameOutput {
    /// <p>The API mapping selection expression.</p>
    pub fn api_mapping_selection_expression(&self) -> std::option::Option<&str> {
        self.api_mapping_selection_expression.as_deref()
    }
    /// <p>The name of the DomainName resource.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>The domain name configurations.</p>
    pub fn domain_name_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::DomainNameConfiguration]> {
        self.domain_name_configurations.as_deref()
    }
    /// <p>The mutual TLS authentication configuration for a custom domain name.</p>
    pub fn mutual_tls_authentication(
        &self,
    ) -> std::option::Option<&crate::model::MutualTlsAuthentication> {
        self.mutual_tls_authentication.as_ref()
    }
    /// <p>The collection of tags associated with a domain name.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateDomainNameOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDomainNameOutput");
        formatter.field(
            "api_mapping_selection_expression",
            &self.api_mapping_selection_expression,
        );
        formatter.field("domain_name", &self.domain_name);
        formatter.field(
            "domain_name_configurations",
            &self.domain_name_configurations,
        );
        formatter.field("mutual_tls_authentication", &self.mutual_tls_authentication);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`CreateDomainNameOutput`](crate::output::CreateDomainNameOutput)
pub mod create_domain_name_output {
    /// A builder for [`CreateDomainNameOutput`](crate::output::CreateDomainNameOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_mapping_selection_expression: std::option::Option<std::string::String>,
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) domain_name_configurations:
            std::option::Option<std::vec::Vec<crate::model::DomainNameConfiguration>>,
        pub(crate) mutual_tls_authentication:
            std::option::Option<crate::model::MutualTlsAuthentication>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The API mapping selection expression.</p>
        pub fn api_mapping_selection_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.api_mapping_selection_expression = Some(input.into());
            self
        }
        /// <p>The API mapping selection expression.</p>
        pub fn set_api_mapping_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.api_mapping_selection_expression = input;
            self
        }
        /// <p>The name of the DomainName resource.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of the DomainName resource.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Appends an item to `domain_name_configurations`.
        ///
        /// To override the contents of this collection use [`set_domain_name_configurations`](Self::set_domain_name_configurations).
        ///
        /// <p>The domain name configurations.</p>
        pub fn domain_name_configurations(
            mut self,
            input: impl Into<crate::model::DomainNameConfiguration>,
        ) -> Self {
            let mut v = self.domain_name_configurations.unwrap_or_default();
            v.push(input.into());
            self.domain_name_configurations = Some(v);
            self
        }
        /// <p>The domain name configurations.</p>
        pub fn set_domain_name_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DomainNameConfiguration>>,
        ) -> Self {
            self.domain_name_configurations = input;
            self
        }
        /// <p>The mutual TLS authentication configuration for a custom domain name.</p>
        pub fn mutual_tls_authentication(
            mut self,
            input: crate::model::MutualTlsAuthentication,
        ) -> Self {
            self.mutual_tls_authentication = Some(input);
            self
        }
        /// <p>The mutual TLS authentication configuration for a custom domain name.</p>
        pub fn set_mutual_tls_authentication(
            mut self,
            input: std::option::Option<crate::model::MutualTlsAuthentication>,
        ) -> Self {
            self.mutual_tls_authentication = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The collection of tags associated with a domain name.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The collection of tags associated with a domain name.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDomainNameOutput`](crate::output::CreateDomainNameOutput)
        pub fn build(self) -> crate::output::CreateDomainNameOutput {
            crate::output::CreateDomainNameOutput {
                api_mapping_selection_expression: self.api_mapping_selection_expression,
                domain_name: self.domain_name,
                domain_name_configurations: self.domain_name_configurations,
                mutual_tls_authentication: self.mutual_tls_authentication,
                tags: self.tags,
            }
        }
    }
}
impl CreateDomainNameOutput {
    /// Creates a new builder-style object to manufacture [`CreateDomainNameOutput`](crate::output::CreateDomainNameOutput)
    pub fn builder() -> crate::output::create_domain_name_output::Builder {
        crate::output::create_domain_name_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDeploymentOutput {
    /// <p>Specifies whether a deployment was automatically released.</p>
    pub auto_deployed: bool,
    /// <p>The date and time when the Deployment resource was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The identifier for the deployment.</p>
    pub deployment_id: std::option::Option<std::string::String>,
    /// <p>The status of the deployment: PENDING, FAILED, or SUCCEEDED.</p>
    pub deployment_status: std::option::Option<crate::model::DeploymentStatus>,
    /// <p>May contain additional feedback on the status of an API deployment.</p>
    pub deployment_status_message: std::option::Option<std::string::String>,
    /// <p>The description for the deployment.</p>
    pub description: std::option::Option<std::string::String>,
}
impl CreateDeploymentOutput {
    /// <p>Specifies whether a deployment was automatically released.</p>
    pub fn auto_deployed(&self) -> bool {
        self.auto_deployed
    }
    /// <p>The date and time when the Deployment resource was created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_date.as_ref()
    }
    /// <p>The identifier for the deployment.</p>
    pub fn deployment_id(&self) -> std::option::Option<&str> {
        self.deployment_id.as_deref()
    }
    /// <p>The status of the deployment: PENDING, FAILED, or SUCCEEDED.</p>
    pub fn deployment_status(&self) -> std::option::Option<&crate::model::DeploymentStatus> {
        self.deployment_status.as_ref()
    }
    /// <p>May contain additional feedback on the status of an API deployment.</p>
    pub fn deployment_status_message(&self) -> std::option::Option<&str> {
        self.deployment_status_message.as_deref()
    }
    /// <p>The description for the deployment.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for CreateDeploymentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDeploymentOutput");
        formatter.field("auto_deployed", &self.auto_deployed);
        formatter.field("created_date", &self.created_date);
        formatter.field("deployment_id", &self.deployment_id);
        formatter.field("deployment_status", &self.deployment_status);
        formatter.field("deployment_status_message", &self.deployment_status_message);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`CreateDeploymentOutput`](crate::output::CreateDeploymentOutput)
pub mod create_deployment_output {
    /// A builder for [`CreateDeploymentOutput`](crate::output::CreateDeploymentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_deployed: std::option::Option<bool>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) deployment_id: std::option::Option<std::string::String>,
        pub(crate) deployment_status: std::option::Option<crate::model::DeploymentStatus>,
        pub(crate) deployment_status_message: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies whether a deployment was automatically released.</p>
        pub fn auto_deployed(mut self, input: bool) -> Self {
            self.auto_deployed = Some(input);
            self
        }
        /// <p>Specifies whether a deployment was automatically released.</p>
        pub fn set_auto_deployed(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_deployed = input;
            self
        }
        /// <p>The date and time when the Deployment resource was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The date and time when the Deployment resource was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>The identifier for the deployment.</p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_id = Some(input.into());
            self
        }
        /// <p>The identifier for the deployment.</p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_id = input;
            self
        }
        /// <p>The status of the deployment: PENDING, FAILED, or SUCCEEDED.</p>
        pub fn deployment_status(mut self, input: crate::model::DeploymentStatus) -> Self {
            self.deployment_status = Some(input);
            self
        }
        /// <p>The status of the deployment: PENDING, FAILED, or SUCCEEDED.</p>
        pub fn set_deployment_status(
            mut self,
            input: std::option::Option<crate::model::DeploymentStatus>,
        ) -> Self {
            self.deployment_status = input;
            self
        }
        /// <p>May contain additional feedback on the status of an API deployment.</p>
        pub fn deployment_status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_status_message = Some(input.into());
            self
        }
        /// <p>May contain additional feedback on the status of an API deployment.</p>
        pub fn set_deployment_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_status_message = input;
            self
        }
        /// <p>The description for the deployment.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description for the deployment.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDeploymentOutput`](crate::output::CreateDeploymentOutput)
        pub fn build(self) -> crate::output::CreateDeploymentOutput {
            crate::output::CreateDeploymentOutput {
                auto_deployed: self.auto_deployed.unwrap_or_default(),
                created_date: self.created_date,
                deployment_id: self.deployment_id,
                deployment_status: self.deployment_status,
                deployment_status_message: self.deployment_status_message,
                description: self.description,
            }
        }
    }
}
impl CreateDeploymentOutput {
    /// Creates a new builder-style object to manufacture [`CreateDeploymentOutput`](crate::output::CreateDeploymentOutput)
    pub fn builder() -> crate::output::create_deployment_output::Builder {
        crate::output::create_deployment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAuthorizerOutput {
    /// <p>Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, don't specify this parameter. Supported only for REQUEST authorizers.</p>
    pub authorizer_credentials_arn: std::option::Option<std::string::String>,
    /// <p>The authorizer identifier.</p>
    pub authorizer_id: std::option::Option<std::string::String>,
    /// <p>Specifies the format of the payload sent to an HTTP API Lambda authorizer. Required for HTTP API Lambda authorizers. Supported values are 1.0 and 2.0. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p>
    pub authorizer_payload_format_version: std::option::Option<std::string::String>,
    /// <p>The time to live (TTL) for cached authorizer results, in seconds. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway caches authorizer responses. The maximum value is 3600, or 1 hour. Supported only for HTTP API Lambda authorizers.</p>
    pub authorizer_result_ttl_in_seconds: i32,
    /// <p>The authorizer type. Specify REQUEST for a Lambda function using incoming request parameters. Specify JWT to use JSON Web Tokens (supported only for HTTP APIs).</p>
    pub authorizer_type: std::option::Option<crate::model::AuthorizerType>,
    /// <p>The authorizer's Uniform Resource Identifier (URI). For REQUEST authorizers, this must be a well-formed Lambda function URI, for example, arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:<replaceable>{account_id}</replaceable>:function:<replaceable>{lambda_function_name}</replaceable>/invocations. In general, the URI has this form: arn:aws:apigateway:<replaceable>{region}</replaceable>:lambda:path/<replaceable>{service_api}</replaceable>
    /// , where <replaceable></replaceable>{region} is the same as the region hosting the Lambda function, path indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial /. For Lambda functions, this is usually of the form /2015-03-31/functions/[FunctionARN]/invocations. Supported only for REQUEST authorizers.</p>
    pub authorizer_uri: std::option::Option<std::string::String>,
    /// <p>Specifies whether a Lambda authorizer returns a response in a simple format. If enabled, the Lambda authorizer can return a boolean value instead of an IAM policy. Supported only for HTTP APIs. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a></p>
    pub enable_simple_responses: bool,
    /// <p>The identity source for which authorization is requested.</p> <p>For a REQUEST authorizer, this is optional. The value is a set of one or more mapping expressions of the specified request parameters. The identity source can be headers, query string parameters, stage variables, and context parameters. For example, if an Auth header and a Name query string parameter are defined as identity sources, this value is route.request.header.Auth, route.request.querystring.Name for WebSocket APIs. For HTTP APIs, use selection expressions prefixed with $, for example, $request.header.Auth, $request.querystring.Name. These parameters are used to perform runtime validation for Lambda-based authorizers by verifying all of the identity-related request parameters are present in the request, not null, and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function. Otherwise, it returns a 401 Unauthorized response without calling the Lambda function. For HTTP APIs, identity sources are also used as the cache key when caching is enabled. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p> <p>For JWT, a single entry that specifies where to extract the JSON Web Token (JWT) from inbound requests. Currently only header-based and query parameter-based selections are supported, for example $request.header.Authorization.</p>
    pub identity_source: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The validation expression does not apply to the REQUEST authorizer.</p>
    pub identity_validation_expression: std::option::Option<std::string::String>,
    /// <p>Represents the configuration of a JWT authorizer. Required for the JWT authorizer type. Supported only for HTTP APIs.</p>
    pub jwt_configuration: std::option::Option<crate::model::JwtConfiguration>,
    /// <p>The name of the authorizer.</p>
    pub name: std::option::Option<std::string::String>,
}
impl CreateAuthorizerOutput {
    /// <p>Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, don't specify this parameter. Supported only for REQUEST authorizers.</p>
    pub fn authorizer_credentials_arn(&self) -> std::option::Option<&str> {
        self.authorizer_credentials_arn.as_deref()
    }
    /// <p>The authorizer identifier.</p>
    pub fn authorizer_id(&self) -> std::option::Option<&str> {
        self.authorizer_id.as_deref()
    }
    /// <p>Specifies the format of the payload sent to an HTTP API Lambda authorizer. Required for HTTP API Lambda authorizers. Supported values are 1.0 and 2.0. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p>
    pub fn authorizer_payload_format_version(&self) -> std::option::Option<&str> {
        self.authorizer_payload_format_version.as_deref()
    }
    /// <p>The time to live (TTL) for cached authorizer results, in seconds. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway caches authorizer responses. The maximum value is 3600, or 1 hour. Supported only for HTTP API Lambda authorizers.</p>
    pub fn authorizer_result_ttl_in_seconds(&self) -> i32 {
        self.authorizer_result_ttl_in_seconds
    }
    /// <p>The authorizer type. Specify REQUEST for a Lambda function using incoming request parameters. Specify JWT to use JSON Web Tokens (supported only for HTTP APIs).</p>
    pub fn authorizer_type(&self) -> std::option::Option<&crate::model::AuthorizerType> {
        self.authorizer_type.as_ref()
    }
    /// <p>The authorizer's Uniform Resource Identifier (URI). For REQUEST authorizers, this must be a well-formed Lambda function URI, for example, arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:<replaceable>{account_id}</replaceable>:function:<replaceable>{lambda_function_name}</replaceable>/invocations. In general, the URI has this form: arn:aws:apigateway:<replaceable>{region}</replaceable>:lambda:path/<replaceable>{service_api}</replaceable>
    /// , where <replaceable></replaceable>{region} is the same as the region hosting the Lambda function, path indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial /. For Lambda functions, this is usually of the form /2015-03-31/functions/[FunctionARN]/invocations. Supported only for REQUEST authorizers.</p>
    pub fn authorizer_uri(&self) -> std::option::Option<&str> {
        self.authorizer_uri.as_deref()
    }
    /// <p>Specifies whether a Lambda authorizer returns a response in a simple format. If enabled, the Lambda authorizer can return a boolean value instead of an IAM policy. Supported only for HTTP APIs. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a></p>
    pub fn enable_simple_responses(&self) -> bool {
        self.enable_simple_responses
    }
    /// <p>The identity source for which authorization is requested.</p> <p>For a REQUEST authorizer, this is optional. The value is a set of one or more mapping expressions of the specified request parameters. The identity source can be headers, query string parameters, stage variables, and context parameters. For example, if an Auth header and a Name query string parameter are defined as identity sources, this value is route.request.header.Auth, route.request.querystring.Name for WebSocket APIs. For HTTP APIs, use selection expressions prefixed with $, for example, $request.header.Auth, $request.querystring.Name. These parameters are used to perform runtime validation for Lambda-based authorizers by verifying all of the identity-related request parameters are present in the request, not null, and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function. Otherwise, it returns a 401 Unauthorized response without calling the Lambda function. For HTTP APIs, identity sources are also used as the cache key when caching is enabled. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p> <p>For JWT, a single entry that specifies where to extract the JSON Web Token (JWT) from inbound requests. Currently only header-based and query parameter-based selections are supported, for example $request.header.Authorization.</p>
    pub fn identity_source(&self) -> std::option::Option<&[std::string::String]> {
        self.identity_source.as_deref()
    }
    /// <p>The validation expression does not apply to the REQUEST authorizer.</p>
    pub fn identity_validation_expression(&self) -> std::option::Option<&str> {
        self.identity_validation_expression.as_deref()
    }
    /// <p>Represents the configuration of a JWT authorizer. Required for the JWT authorizer type. Supported only for HTTP APIs.</p>
    pub fn jwt_configuration(&self) -> std::option::Option<&crate::model::JwtConfiguration> {
        self.jwt_configuration.as_ref()
    }
    /// <p>The name of the authorizer.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for CreateAuthorizerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAuthorizerOutput");
        formatter.field(
            "authorizer_credentials_arn",
            &self.authorizer_credentials_arn,
        );
        formatter.field("authorizer_id", &self.authorizer_id);
        formatter.field(
            "authorizer_payload_format_version",
            &self.authorizer_payload_format_version,
        );
        formatter.field(
            "authorizer_result_ttl_in_seconds",
            &self.authorizer_result_ttl_in_seconds,
        );
        formatter.field("authorizer_type", &self.authorizer_type);
        formatter.field("authorizer_uri", &self.authorizer_uri);
        formatter.field("enable_simple_responses", &self.enable_simple_responses);
        formatter.field("identity_source", &self.identity_source);
        formatter.field(
            "identity_validation_expression",
            &self.identity_validation_expression,
        );
        formatter.field("jwt_configuration", &self.jwt_configuration);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`CreateAuthorizerOutput`](crate::output::CreateAuthorizerOutput)
pub mod create_authorizer_output {
    /// A builder for [`CreateAuthorizerOutput`](crate::output::CreateAuthorizerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authorizer_credentials_arn: std::option::Option<std::string::String>,
        pub(crate) authorizer_id: std::option::Option<std::string::String>,
        pub(crate) authorizer_payload_format_version: std::option::Option<std::string::String>,
        pub(crate) authorizer_result_ttl_in_seconds: std::option::Option<i32>,
        pub(crate) authorizer_type: std::option::Option<crate::model::AuthorizerType>,
        pub(crate) authorizer_uri: std::option::Option<std::string::String>,
        pub(crate) enable_simple_responses: std::option::Option<bool>,
        pub(crate) identity_source: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) identity_validation_expression: std::option::Option<std::string::String>,
        pub(crate) jwt_configuration: std::option::Option<crate::model::JwtConfiguration>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, don't specify this parameter. Supported only for REQUEST authorizers.</p>
        pub fn authorizer_credentials_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorizer_credentials_arn = Some(input.into());
            self
        }
        /// <p>Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, don't specify this parameter. Supported only for REQUEST authorizers.</p>
        pub fn set_authorizer_credentials_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorizer_credentials_arn = input;
            self
        }
        /// <p>The authorizer identifier.</p>
        pub fn authorizer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorizer_id = Some(input.into());
            self
        }
        /// <p>The authorizer identifier.</p>
        pub fn set_authorizer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorizer_id = input;
            self
        }
        /// <p>Specifies the format of the payload sent to an HTTP API Lambda authorizer. Required for HTTP API Lambda authorizers. Supported values are 1.0 and 2.0. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p>
        pub fn authorizer_payload_format_version(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.authorizer_payload_format_version = Some(input.into());
            self
        }
        /// <p>Specifies the format of the payload sent to an HTTP API Lambda authorizer. Required for HTTP API Lambda authorizers. Supported values are 1.0 and 2.0. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p>
        pub fn set_authorizer_payload_format_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorizer_payload_format_version = input;
            self
        }
        /// <p>The time to live (TTL) for cached authorizer results, in seconds. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway caches authorizer responses. The maximum value is 3600, or 1 hour. Supported only for HTTP API Lambda authorizers.</p>
        pub fn authorizer_result_ttl_in_seconds(mut self, input: i32) -> Self {
            self.authorizer_result_ttl_in_seconds = Some(input);
            self
        }
        /// <p>The time to live (TTL) for cached authorizer results, in seconds. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway caches authorizer responses. The maximum value is 3600, or 1 hour. Supported only for HTTP API Lambda authorizers.</p>
        pub fn set_authorizer_result_ttl_in_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.authorizer_result_ttl_in_seconds = input;
            self
        }
        /// <p>The authorizer type. Specify REQUEST for a Lambda function using incoming request parameters. Specify JWT to use JSON Web Tokens (supported only for HTTP APIs).</p>
        pub fn authorizer_type(mut self, input: crate::model::AuthorizerType) -> Self {
            self.authorizer_type = Some(input);
            self
        }
        /// <p>The authorizer type. Specify REQUEST for a Lambda function using incoming request parameters. Specify JWT to use JSON Web Tokens (supported only for HTTP APIs).</p>
        pub fn set_authorizer_type(
            mut self,
            input: std::option::Option<crate::model::AuthorizerType>,
        ) -> Self {
            self.authorizer_type = input;
            self
        }
        /// <p>The authorizer's Uniform Resource Identifier (URI). For REQUEST authorizers, this must be a well-formed Lambda function URI, for example, arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:<replaceable>{account_id}</replaceable>:function:<replaceable>{lambda_function_name}</replaceable>/invocations. In general, the URI has this form: arn:aws:apigateway:<replaceable>{region}</replaceable>:lambda:path/<replaceable>{service_api}</replaceable>
        /// , where <replaceable></replaceable>{region} is the same as the region hosting the Lambda function, path indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial /. For Lambda functions, this is usually of the form /2015-03-31/functions/[FunctionARN]/invocations. Supported only for REQUEST authorizers.</p>
        pub fn authorizer_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorizer_uri = Some(input.into());
            self
        }
        /// <p>The authorizer's Uniform Resource Identifier (URI). For REQUEST authorizers, this must be a well-formed Lambda function URI, for example, arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:<replaceable>{account_id}</replaceable>:function:<replaceable>{lambda_function_name}</replaceable>/invocations. In general, the URI has this form: arn:aws:apigateway:<replaceable>{region}</replaceable>:lambda:path/<replaceable>{service_api}</replaceable>
        /// , where <replaceable></replaceable>{region} is the same as the region hosting the Lambda function, path indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial /. For Lambda functions, this is usually of the form /2015-03-31/functions/[FunctionARN]/invocations. Supported only for REQUEST authorizers.</p>
        pub fn set_authorizer_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorizer_uri = input;
            self
        }
        /// <p>Specifies whether a Lambda authorizer returns a response in a simple format. If enabled, the Lambda authorizer can return a boolean value instead of an IAM policy. Supported only for HTTP APIs. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a></p>
        pub fn enable_simple_responses(mut self, input: bool) -> Self {
            self.enable_simple_responses = Some(input);
            self
        }
        /// <p>Specifies whether a Lambda authorizer returns a response in a simple format. If enabled, the Lambda authorizer can return a boolean value instead of an IAM policy. Supported only for HTTP APIs. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a></p>
        pub fn set_enable_simple_responses(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_simple_responses = input;
            self
        }
        /// Appends an item to `identity_source`.
        ///
        /// To override the contents of this collection use [`set_identity_source`](Self::set_identity_source).
        ///
        /// <p>The identity source for which authorization is requested.</p> <p>For a REQUEST authorizer, this is optional. The value is a set of one or more mapping expressions of the specified request parameters. The identity source can be headers, query string parameters, stage variables, and context parameters. For example, if an Auth header and a Name query string parameter are defined as identity sources, this value is route.request.header.Auth, route.request.querystring.Name for WebSocket APIs. For HTTP APIs, use selection expressions prefixed with $, for example, $request.header.Auth, $request.querystring.Name. These parameters are used to perform runtime validation for Lambda-based authorizers by verifying all of the identity-related request parameters are present in the request, not null, and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function. Otherwise, it returns a 401 Unauthorized response without calling the Lambda function. For HTTP APIs, identity sources are also used as the cache key when caching is enabled. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p> <p>For JWT, a single entry that specifies where to extract the JSON Web Token (JWT) from inbound requests. Currently only header-based and query parameter-based selections are supported, for example $request.header.Authorization.</p>
        pub fn identity_source(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.identity_source.unwrap_or_default();
            v.push(input.into());
            self.identity_source = Some(v);
            self
        }
        /// <p>The identity source for which authorization is requested.</p> <p>For a REQUEST authorizer, this is optional. The value is a set of one or more mapping expressions of the specified request parameters. The identity source can be headers, query string parameters, stage variables, and context parameters. For example, if an Auth header and a Name query string parameter are defined as identity sources, this value is route.request.header.Auth, route.request.querystring.Name for WebSocket APIs. For HTTP APIs, use selection expressions prefixed with $, for example, $request.header.Auth, $request.querystring.Name. These parameters are used to perform runtime validation for Lambda-based authorizers by verifying all of the identity-related request parameters are present in the request, not null, and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function. Otherwise, it returns a 401 Unauthorized response without calling the Lambda function. For HTTP APIs, identity sources are also used as the cache key when caching is enabled. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a>.</p> <p>For JWT, a single entry that specifies where to extract the JSON Web Token (JWT) from inbound requests. Currently only header-based and query parameter-based selections are supported, for example $request.header.Authorization.</p>
        pub fn set_identity_source(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.identity_source = input;
            self
        }
        /// <p>The validation expression does not apply to the REQUEST authorizer.</p>
        pub fn identity_validation_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.identity_validation_expression = Some(input.into());
            self
        }
        /// <p>The validation expression does not apply to the REQUEST authorizer.</p>
        pub fn set_identity_validation_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_validation_expression = input;
            self
        }
        /// <p>Represents the configuration of a JWT authorizer. Required for the JWT authorizer type. Supported only for HTTP APIs.</p>
        pub fn jwt_configuration(mut self, input: crate::model::JwtConfiguration) -> Self {
            self.jwt_configuration = Some(input);
            self
        }
        /// <p>Represents the configuration of a JWT authorizer. Required for the JWT authorizer type. Supported only for HTTP APIs.</p>
        pub fn set_jwt_configuration(
            mut self,
            input: std::option::Option<crate::model::JwtConfiguration>,
        ) -> Self {
            self.jwt_configuration = input;
            self
        }
        /// <p>The name of the authorizer.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the authorizer.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAuthorizerOutput`](crate::output::CreateAuthorizerOutput)
        pub fn build(self) -> crate::output::CreateAuthorizerOutput {
            crate::output::CreateAuthorizerOutput {
                authorizer_credentials_arn: self.authorizer_credentials_arn,
                authorizer_id: self.authorizer_id,
                authorizer_payload_format_version: self.authorizer_payload_format_version,
                authorizer_result_ttl_in_seconds: self
                    .authorizer_result_ttl_in_seconds
                    .unwrap_or_default(),
                authorizer_type: self.authorizer_type,
                authorizer_uri: self.authorizer_uri,
                enable_simple_responses: self.enable_simple_responses.unwrap_or_default(),
                identity_source: self.identity_source,
                identity_validation_expression: self.identity_validation_expression,
                jwt_configuration: self.jwt_configuration,
                name: self.name,
            }
        }
    }
}
impl CreateAuthorizerOutput {
    /// Creates a new builder-style object to manufacture [`CreateAuthorizerOutput`](crate::output::CreateAuthorizerOutput)
    pub fn builder() -> crate::output::create_authorizer_output::Builder {
        crate::output::create_authorizer_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateApiMappingOutput {
    /// <p>The API identifier.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The API mapping identifier.</p>
    pub api_mapping_id: std::option::Option<std::string::String>,
    /// <p>The API mapping key.</p>
    pub api_mapping_key: std::option::Option<std::string::String>,
    /// <p>The API stage.</p>
    pub stage: std::option::Option<std::string::String>,
}
impl CreateApiMappingOutput {
    /// <p>The API identifier.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The API mapping identifier.</p>
    pub fn api_mapping_id(&self) -> std::option::Option<&str> {
        self.api_mapping_id.as_deref()
    }
    /// <p>The API mapping key.</p>
    pub fn api_mapping_key(&self) -> std::option::Option<&str> {
        self.api_mapping_key.as_deref()
    }
    /// <p>The API stage.</p>
    pub fn stage(&self) -> std::option::Option<&str> {
        self.stage.as_deref()
    }
}
impl std::fmt::Debug for CreateApiMappingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateApiMappingOutput");
        formatter.field("api_id", &self.api_id);
        formatter.field("api_mapping_id", &self.api_mapping_id);
        formatter.field("api_mapping_key", &self.api_mapping_key);
        formatter.field("stage", &self.stage);
        formatter.finish()
    }
}
/// See [`CreateApiMappingOutput`](crate::output::CreateApiMappingOutput)
pub mod create_api_mapping_output {
    /// A builder for [`CreateApiMappingOutput`](crate::output::CreateApiMappingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) api_mapping_id: std::option::Option<std::string::String>,
        pub(crate) api_mapping_key: std::option::Option<std::string::String>,
        pub(crate) stage: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API identifier.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API identifier.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The API mapping identifier.</p>
        pub fn api_mapping_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_mapping_id = Some(input.into());
            self
        }
        /// <p>The API mapping identifier.</p>
        pub fn set_api_mapping_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.api_mapping_id = input;
            self
        }
        /// <p>The API mapping key.</p>
        pub fn api_mapping_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_mapping_key = Some(input.into());
            self
        }
        /// <p>The API mapping key.</p>
        pub fn set_api_mapping_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.api_mapping_key = input;
            self
        }
        /// <p>The API stage.</p>
        pub fn stage(mut self, input: impl Into<std::string::String>) -> Self {
            self.stage = Some(input.into());
            self
        }
        /// <p>The API stage.</p>
        pub fn set_stage(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stage = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateApiMappingOutput`](crate::output::CreateApiMappingOutput)
        pub fn build(self) -> crate::output::CreateApiMappingOutput {
            crate::output::CreateApiMappingOutput {
                api_id: self.api_id,
                api_mapping_id: self.api_mapping_id,
                api_mapping_key: self.api_mapping_key,
                stage: self.stage,
            }
        }
    }
}
impl CreateApiMappingOutput {
    /// Creates a new builder-style object to manufacture [`CreateApiMappingOutput`](crate::output::CreateApiMappingOutput)
    pub fn builder() -> crate::output::create_api_mapping_output::Builder {
        crate::output::create_api_mapping_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateApiOutput {
    /// <p>The URI of the API, of the form {api-id}.execute-api.{region}.amazonaws.com. The stage name is typically appended to this URI to form a complete path to a deployed API stage.</p>
    pub api_endpoint: std::option::Option<std::string::String>,
    /// <p>Specifies whether an API is managed by API Gateway. You can't update or delete a managed API by using API Gateway. A managed API can be deleted only through the tooling or service that created it.</p>
    pub api_gateway_managed: bool,
    /// <p>The API ID.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>An API key selection expression. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions">API Key Selection Expressions</a>.</p>
    pub api_key_selection_expression: std::option::Option<std::string::String>,
    /// <p>A CORS configuration. Supported only for HTTP APIs.</p>
    pub cors_configuration: std::option::Option<crate::model::Cors>,
    /// <p>The timestamp when the API was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The description of the API.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Avoid validating models when creating a deployment. Supported only for WebSocket APIs.</p>
    pub disable_schema_validation: bool,
    /// <p>Specifies whether clients can invoke your API by using the default execute-api endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
    pub disable_execute_api_endpoint: bool,
    /// <p>The validation information during API import. This may include particular properties of your OpenAPI definition which are ignored during import. Supported only for HTTP APIs.</p>
    pub import_info: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The name of the API.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The API protocol.</p>
    pub protocol_type: std::option::Option<crate::model::ProtocolType>,
    /// <p>The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.</p>
    pub route_selection_expression: std::option::Option<std::string::String>,
    /// <p>A collection of tags associated with the API.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A version identifier for the API.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>The warning messages reported when failonwarnings is turned on during API import.</p>
    pub warnings: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl CreateApiOutput {
    /// <p>The URI of the API, of the form {api-id}.execute-api.{region}.amazonaws.com. The stage name is typically appended to this URI to form a complete path to a deployed API stage.</p>
    pub fn api_endpoint(&self) -> std::option::Option<&str> {
        self.api_endpoint.as_deref()
    }
    /// <p>Specifies whether an API is managed by API Gateway. You can't update or delete a managed API by using API Gateway. A managed API can be deleted only through the tooling or service that created it.</p>
    pub fn api_gateway_managed(&self) -> bool {
        self.api_gateway_managed
    }
    /// <p>The API ID.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>An API key selection expression. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions">API Key Selection Expressions</a>.</p>
    pub fn api_key_selection_expression(&self) -> std::option::Option<&str> {
        self.api_key_selection_expression.as_deref()
    }
    /// <p>A CORS configuration. Supported only for HTTP APIs.</p>
    pub fn cors_configuration(&self) -> std::option::Option<&crate::model::Cors> {
        self.cors_configuration.as_ref()
    }
    /// <p>The timestamp when the API was created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_date.as_ref()
    }
    /// <p>The description of the API.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Avoid validating models when creating a deployment. Supported only for WebSocket APIs.</p>
    pub fn disable_schema_validation(&self) -> bool {
        self.disable_schema_validation
    }
    /// <p>Specifies whether clients can invoke your API by using the default execute-api endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
    pub fn disable_execute_api_endpoint(&self) -> bool {
        self.disable_execute_api_endpoint
    }
    /// <p>The validation information during API import. This may include particular properties of your OpenAPI definition which are ignored during import. Supported only for HTTP APIs.</p>
    pub fn import_info(&self) -> std::option::Option<&[std::string::String]> {
        self.import_info.as_deref()
    }
    /// <p>The name of the API.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The API protocol.</p>
    pub fn protocol_type(&self) -> std::option::Option<&crate::model::ProtocolType> {
        self.protocol_type.as_ref()
    }
    /// <p>The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.</p>
    pub fn route_selection_expression(&self) -> std::option::Option<&str> {
        self.route_selection_expression.as_deref()
    }
    /// <p>A collection of tags associated with the API.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>A version identifier for the API.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>The warning messages reported when failonwarnings is turned on during API import.</p>
    pub fn warnings(&self) -> std::option::Option<&[std::string::String]> {
        self.warnings.as_deref()
    }
}
impl std::fmt::Debug for CreateApiOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateApiOutput");
        formatter.field("api_endpoint", &self.api_endpoint);
        formatter.field("api_gateway_managed", &self.api_gateway_managed);
        formatter.field("api_id", &self.api_id);
        formatter.field(
            "api_key_selection_expression",
            &self.api_key_selection_expression,
        );
        formatter.field("cors_configuration", &self.cors_configuration);
        formatter.field("created_date", &self.created_date);
        formatter.field("description", &self.description);
        formatter.field("disable_schema_validation", &self.disable_schema_validation);
        formatter.field(
            "disable_execute_api_endpoint",
            &self.disable_execute_api_endpoint,
        );
        formatter.field("import_info", &self.import_info);
        formatter.field("name", &self.name);
        formatter.field("protocol_type", &self.protocol_type);
        formatter.field(
            "route_selection_expression",
            &self.route_selection_expression,
        );
        formatter.field("tags", &self.tags);
        formatter.field("version", &self.version);
        formatter.field("warnings", &self.warnings);
        formatter.finish()
    }
}
/// See [`CreateApiOutput`](crate::output::CreateApiOutput)
pub mod create_api_output {
    /// A builder for [`CreateApiOutput`](crate::output::CreateApiOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_endpoint: std::option::Option<std::string::String>,
        pub(crate) api_gateway_managed: std::option::Option<bool>,
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) api_key_selection_expression: std::option::Option<std::string::String>,
        pub(crate) cors_configuration: std::option::Option<crate::model::Cors>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) disable_schema_validation: std::option::Option<bool>,
        pub(crate) disable_execute_api_endpoint: std::option::Option<bool>,
        pub(crate) import_info: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) protocol_type: std::option::Option<crate::model::ProtocolType>,
        pub(crate) route_selection_expression: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) warnings: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The URI of the API, of the form {api-id}.execute-api.{region}.amazonaws.com. The stage name is typically appended to this URI to form a complete path to a deployed API stage.</p>
        pub fn api_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_endpoint = Some(input.into());
            self
        }
        /// <p>The URI of the API, of the form {api-id}.execute-api.{region}.amazonaws.com. The stage name is typically appended to this URI to form a complete path to a deployed API stage.</p>
        pub fn set_api_endpoint(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_endpoint = input;
            self
        }
        /// <p>Specifies whether an API is managed by API Gateway. You can't update or delete a managed API by using API Gateway. A managed API can be deleted only through the tooling or service that created it.</p>
        pub fn api_gateway_managed(mut self, input: bool) -> Self {
            self.api_gateway_managed = Some(input);
            self
        }
        /// <p>Specifies whether an API is managed by API Gateway. You can't update or delete a managed API by using API Gateway. A managed API can be deleted only through the tooling or service that created it.</p>
        pub fn set_api_gateway_managed(mut self, input: std::option::Option<bool>) -> Self {
            self.api_gateway_managed = input;
            self
        }
        /// <p>The API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>An API key selection expression. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions">API Key Selection Expressions</a>.</p>
        pub fn api_key_selection_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.api_key_selection_expression = Some(input.into());
            self
        }
        /// <p>An API key selection expression. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions">API Key Selection Expressions</a>.</p>
        pub fn set_api_key_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.api_key_selection_expression = input;
            self
        }
        /// <p>A CORS configuration. Supported only for HTTP APIs.</p>
        pub fn cors_configuration(mut self, input: crate::model::Cors) -> Self {
            self.cors_configuration = Some(input);
            self
        }
        /// <p>A CORS configuration. Supported only for HTTP APIs.</p>
        pub fn set_cors_configuration(
            mut self,
            input: std::option::Option<crate::model::Cors>,
        ) -> Self {
            self.cors_configuration = input;
            self
        }
        /// <p>The timestamp when the API was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The timestamp when the API was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>The description of the API.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the API.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Avoid validating models when creating a deployment. Supported only for WebSocket APIs.</p>
        pub fn disable_schema_validation(mut self, input: bool) -> Self {
            self.disable_schema_validation = Some(input);
            self
        }
        /// <p>Avoid validating models when creating a deployment. Supported only for WebSocket APIs.</p>
        pub fn set_disable_schema_validation(mut self, input: std::option::Option<bool>) -> Self {
            self.disable_schema_validation = input;
            self
        }
        /// <p>Specifies whether clients can invoke your API by using the default execute-api endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
        pub fn disable_execute_api_endpoint(mut self, input: bool) -> Self {
            self.disable_execute_api_endpoint = Some(input);
            self
        }
        /// <p>Specifies whether clients can invoke your API by using the default execute-api endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
        pub fn set_disable_execute_api_endpoint(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.disable_execute_api_endpoint = input;
            self
        }
        /// Appends an item to `import_info`.
        ///
        /// To override the contents of this collection use [`set_import_info`](Self::set_import_info).
        ///
        /// <p>The validation information during API import. This may include particular properties of your OpenAPI definition which are ignored during import. Supported only for HTTP APIs.</p>
        pub fn import_info(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.import_info.unwrap_or_default();
            v.push(input.into());
            self.import_info = Some(v);
            self
        }
        /// <p>The validation information during API import. This may include particular properties of your OpenAPI definition which are ignored during import. Supported only for HTTP APIs.</p>
        pub fn set_import_info(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.import_info = input;
            self
        }
        /// <p>The name of the API.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the API.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The API protocol.</p>
        pub fn protocol_type(mut self, input: crate::model::ProtocolType) -> Self {
            self.protocol_type = Some(input);
            self
        }
        /// <p>The API protocol.</p>
        pub fn set_protocol_type(
            mut self,
            input: std::option::Option<crate::model::ProtocolType>,
        ) -> Self {
            self.protocol_type = input;
            self
        }
        /// <p>The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.</p>
        pub fn route_selection_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_selection_expression = Some(input.into());
            self
        }
        /// <p>The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.</p>
        pub fn set_route_selection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.route_selection_expression = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of tags associated with the API.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A collection of tags associated with the API.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>A version identifier for the API.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>A version identifier for the API.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Appends an item to `warnings`.
        ///
        /// To override the contents of this collection use [`set_warnings`](Self::set_warnings).
        ///
        /// <p>The warning messages reported when failonwarnings is turned on during API import.</p>
        pub fn warnings(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.warnings.unwrap_or_default();
            v.push(input.into());
            self.warnings = Some(v);
            self
        }
        /// <p>The warning messages reported when failonwarnings is turned on during API import.</p>
        pub fn set_warnings(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.warnings = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateApiOutput`](crate::output::CreateApiOutput)
        pub fn build(self) -> crate::output::CreateApiOutput {
            crate::output::CreateApiOutput {
                api_endpoint: self.api_endpoint,
                api_gateway_managed: self.api_gateway_managed.unwrap_or_default(),
                api_id: self.api_id,
                api_key_selection_expression: self.api_key_selection_expression,
                cors_configuration: self.cors_configuration,
                created_date: self.created_date,
                description: self.description,
                disable_schema_validation: self.disable_schema_validation.unwrap_or_default(),
                disable_execute_api_endpoint: self.disable_execute_api_endpoint.unwrap_or_default(),
                import_info: self.import_info,
                name: self.name,
                protocol_type: self.protocol_type,
                route_selection_expression: self.route_selection_expression,
                tags: self.tags,
                version: self.version,
                warnings: self.warnings,
            }
        }
    }
}
impl CreateApiOutput {
    /// Creates a new builder-style object to manufacture [`CreateApiOutput`](crate::output::CreateApiOutput)
    pub fn builder() -> crate::output::create_api_output::Builder {
        crate::output::create_api_output::Builder::default()
    }
}
