// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CreateApi` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateApiError {
    /// Kind of error that occurred.
    pub kind: CreateApiErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateApi` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateApiErrorKind {
    /// <p>The request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested operation would cause a conflict with the current state of a service resource associated with the request. Resolve the conflict before retrying this request. See the accompanying error message for details.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateApiError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateApiErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateApiErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateApiErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateApiErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateApiErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateApiError {
    fn code(&self) -> Option<&str> {
        CreateApiError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateApiError {
    /// Creates a new `CreateApiError`.
    pub fn new(kind: CreateApiErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateApiError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateApiErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateApiError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateApiErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateApiErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreateApiErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `CreateApiErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateApiErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `CreateApiErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateApiErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `CreateApiErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, CreateApiErrorKind::TooManyRequestsException(_))
    }
}
impl std::error::Error for CreateApiError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateApiErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateApiErrorKind::ConflictException(_inner) => Some(_inner),
            CreateApiErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateApiErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateApiErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateApiMapping` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateApiMappingError {
    /// Kind of error that occurred.
    pub kind: CreateApiMappingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateApiMapping` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateApiMappingErrorKind {
    /// <p>The request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested operation would cause a conflict with the current state of a service resource associated with the request. Resolve the conflict before retrying this request. See the accompanying error message for details.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateApiMappingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateApiMappingErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateApiMappingErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateApiMappingErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateApiMappingErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateApiMappingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateApiMappingError {
    fn code(&self) -> Option<&str> {
        CreateApiMappingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateApiMappingError {
    /// Creates a new `CreateApiMappingError`.
    pub fn new(kind: CreateApiMappingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateApiMappingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateApiMappingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateApiMappingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateApiMappingErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateApiMappingErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateApiMappingErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `CreateApiMappingErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateApiMappingErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `CreateApiMappingErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateApiMappingErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `CreateApiMappingErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateApiMappingErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreateApiMappingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateApiMappingErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateApiMappingErrorKind::ConflictException(_inner) => Some(_inner),
            CreateApiMappingErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateApiMappingErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateApiMappingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateAuthorizer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateAuthorizerError {
    /// Kind of error that occurred.
    pub kind: CreateAuthorizerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateAuthorizer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateAuthorizerErrorKind {
    /// <p>The request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested operation would cause a conflict with the current state of a service resource associated with the request. Resolve the conflict before retrying this request. See the accompanying error message for details.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateAuthorizerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateAuthorizerErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateAuthorizerErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateAuthorizerErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateAuthorizerErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateAuthorizerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateAuthorizerError {
    fn code(&self) -> Option<&str> {
        CreateAuthorizerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateAuthorizerError {
    /// Creates a new `CreateAuthorizerError`.
    pub fn new(kind: CreateAuthorizerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateAuthorizerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateAuthorizerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateAuthorizerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateAuthorizerErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateAuthorizerErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAuthorizerErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `CreateAuthorizerErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateAuthorizerErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `CreateAuthorizerErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateAuthorizerErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `CreateAuthorizerErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAuthorizerErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreateAuthorizerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateAuthorizerErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateAuthorizerErrorKind::ConflictException(_inner) => Some(_inner),
            CreateAuthorizerErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateAuthorizerErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateAuthorizerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDeployment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDeploymentError {
    /// Kind of error that occurred.
    pub kind: CreateDeploymentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDeployment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDeploymentErrorKind {
    /// <p>The request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested operation would cause a conflict with the current state of a service resource associated with the request. Resolve the conflict before retrying this request. See the accompanying error message for details.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDeploymentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDeploymentErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateDeploymentErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateDeploymentErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateDeploymentErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateDeploymentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDeploymentError {
    fn code(&self) -> Option<&str> {
        CreateDeploymentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDeploymentError {
    /// Creates a new `CreateDeploymentError`.
    pub fn new(kind: CreateDeploymentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDeploymentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDeploymentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDeploymentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDeploymentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateDeploymentErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDeploymentErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `CreateDeploymentErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateDeploymentErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `CreateDeploymentErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateDeploymentErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `CreateDeploymentErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDeploymentErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreateDeploymentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDeploymentErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateDeploymentErrorKind::ConflictException(_inner) => Some(_inner),
            CreateDeploymentErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateDeploymentErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateDeploymentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDomainName` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDomainNameError {
    /// Kind of error that occurred.
    pub kind: CreateDomainNameErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDomainName` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDomainNameErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested operation would cause a conflict with the current state of a service resource associated with the request. Resolve the conflict before retrying this request. See the accompanying error message for details.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDomainNameError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDomainNameErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateDomainNameErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateDomainNameErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateDomainNameErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateDomainNameErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateDomainNameErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDomainNameError {
    fn code(&self) -> Option<&str> {
        CreateDomainNameError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDomainNameError {
    /// Creates a new `CreateDomainNameError`.
    pub fn new(kind: CreateDomainNameErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDomainNameError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDomainNameErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDomainNameError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDomainNameErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateDomainNameErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDomainNameErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `CreateDomainNameErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDomainNameErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `CreateDomainNameErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateDomainNameErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `CreateDomainNameErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateDomainNameErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `CreateDomainNameErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDomainNameErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreateDomainNameError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDomainNameErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateDomainNameErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateDomainNameErrorKind::ConflictException(_inner) => Some(_inner),
            CreateDomainNameErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateDomainNameErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateDomainNameErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateIntegration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateIntegrationError {
    /// Kind of error that occurred.
    pub kind: CreateIntegrationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateIntegration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateIntegrationErrorKind {
    /// <p>The request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested operation would cause a conflict with the current state of a service resource associated with the request. Resolve the conflict before retrying this request. See the accompanying error message for details.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateIntegrationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateIntegrationErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateIntegrationErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateIntegrationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateIntegrationErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateIntegrationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateIntegrationError {
    fn code(&self) -> Option<&str> {
        CreateIntegrationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateIntegrationError {
    /// Creates a new `CreateIntegrationError`.
    pub fn new(kind: CreateIntegrationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateIntegrationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateIntegrationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateIntegrationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateIntegrationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateIntegrationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIntegrationErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `CreateIntegrationErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateIntegrationErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `CreateIntegrationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateIntegrationErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `CreateIntegrationErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIntegrationErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreateIntegrationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateIntegrationErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateIntegrationErrorKind::ConflictException(_inner) => Some(_inner),
            CreateIntegrationErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateIntegrationErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateIntegrationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateIntegrationResponse` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateIntegrationResponseError {
    /// Kind of error that occurred.
    pub kind: CreateIntegrationResponseErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateIntegrationResponse` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateIntegrationResponseErrorKind {
    /// <p>The request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested operation would cause a conflict with the current state of a service resource associated with the request. Resolve the conflict before retrying this request. See the accompanying error message for details.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateIntegrationResponseError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateIntegrationResponseErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateIntegrationResponseErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateIntegrationResponseErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateIntegrationResponseErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateIntegrationResponseErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateIntegrationResponseError {
    fn code(&self) -> Option<&str> {
        CreateIntegrationResponseError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateIntegrationResponseError {
    /// Creates a new `CreateIntegrationResponseError`.
    pub fn new(kind: CreateIntegrationResponseErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateIntegrationResponseError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateIntegrationResponseErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateIntegrationResponseError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateIntegrationResponseErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateIntegrationResponseErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIntegrationResponseErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `CreateIntegrationResponseErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIntegrationResponseErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `CreateIntegrationResponseErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIntegrationResponseErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `CreateIntegrationResponseErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIntegrationResponseErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreateIntegrationResponseError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateIntegrationResponseErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateIntegrationResponseErrorKind::ConflictException(_inner) => Some(_inner),
            CreateIntegrationResponseErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateIntegrationResponseErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateIntegrationResponseErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateModel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateModelError {
    /// Kind of error that occurred.
    pub kind: CreateModelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateModel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateModelErrorKind {
    /// <p>The request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested operation would cause a conflict with the current state of a service resource associated with the request. Resolve the conflict before retrying this request. See the accompanying error message for details.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateModelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateModelErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateModelErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateModelErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateModelErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateModelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateModelError {
    fn code(&self) -> Option<&str> {
        CreateModelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateModelError {
    /// Creates a new `CreateModelError`.
    pub fn new(kind: CreateModelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateModelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateModelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateModelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateModelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateModelErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreateModelErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `CreateModelErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateModelErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `CreateModelErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateModelErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `CreateModelErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateModelErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreateModelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateModelErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateModelErrorKind::ConflictException(_inner) => Some(_inner),
            CreateModelErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateModelErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateModelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateRoute` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateRouteError {
    /// Kind of error that occurred.
    pub kind: CreateRouteErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateRoute` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateRouteErrorKind {
    /// <p>The request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested operation would cause a conflict with the current state of a service resource associated with the request. Resolve the conflict before retrying this request. See the accompanying error message for details.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateRouteError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateRouteErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateRouteErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateRouteErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateRouteErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateRouteErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateRouteError {
    fn code(&self) -> Option<&str> {
        CreateRouteError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateRouteError {
    /// Creates a new `CreateRouteError`.
    pub fn new(kind: CreateRouteErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateRouteError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateRouteErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateRouteError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateRouteErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateRouteErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreateRouteErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `CreateRouteErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateRouteErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `CreateRouteErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateRouteErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `CreateRouteErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRouteErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreateRouteError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateRouteErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateRouteErrorKind::ConflictException(_inner) => Some(_inner),
            CreateRouteErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateRouteErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateRouteErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateRouteResponse` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateRouteResponseError {
    /// Kind of error that occurred.
    pub kind: CreateRouteResponseErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateRouteResponse` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateRouteResponseErrorKind {
    /// <p>The request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested operation would cause a conflict with the current state of a service resource associated with the request. Resolve the conflict before retrying this request. See the accompanying error message for details.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateRouteResponseError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateRouteResponseErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateRouteResponseErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateRouteResponseErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateRouteResponseErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateRouteResponseErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateRouteResponseError {
    fn code(&self) -> Option<&str> {
        CreateRouteResponseError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateRouteResponseError {
    /// Creates a new `CreateRouteResponseError`.
    pub fn new(kind: CreateRouteResponseErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateRouteResponseError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateRouteResponseErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateRouteResponseError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateRouteResponseErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateRouteResponseErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRouteResponseErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `CreateRouteResponseErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRouteResponseErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `CreateRouteResponseErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRouteResponseErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `CreateRouteResponseErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRouteResponseErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreateRouteResponseError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateRouteResponseErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateRouteResponseErrorKind::ConflictException(_inner) => Some(_inner),
            CreateRouteResponseErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateRouteResponseErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateRouteResponseErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateStage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateStageError {
    /// Kind of error that occurred.
    pub kind: CreateStageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateStage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateStageErrorKind {
    /// <p>The request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested operation would cause a conflict with the current state of a service resource associated with the request. Resolve the conflict before retrying this request. See the accompanying error message for details.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateStageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateStageErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateStageErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateStageErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateStageErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateStageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateStageError {
    fn code(&self) -> Option<&str> {
        CreateStageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateStageError {
    /// Creates a new `CreateStageError`.
    pub fn new(kind: CreateStageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateStageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateStageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateStageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateStageErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateStageErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreateStageErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `CreateStageErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateStageErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `CreateStageErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateStageErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `CreateStageErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStageErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreateStageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateStageErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateStageErrorKind::ConflictException(_inner) => Some(_inner),
            CreateStageErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateStageErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateStageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateVpcLink` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateVpcLinkError {
    /// Kind of error that occurred.
    pub kind: CreateVpcLinkErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateVpcLink` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateVpcLinkErrorKind {
    /// <p>The request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateVpcLinkError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateVpcLinkErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateVpcLinkErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateVpcLinkErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateVpcLinkError {
    fn code(&self) -> Option<&str> {
        CreateVpcLinkError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateVpcLinkError {
    /// Creates a new `CreateVpcLinkError`.
    pub fn new(kind: CreateVpcLinkErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateVpcLinkError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateVpcLinkErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateVpcLinkError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateVpcLinkErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateVpcLinkErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreateVpcLinkErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `CreateVpcLinkErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVpcLinkErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreateVpcLinkError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateVpcLinkErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateVpcLinkErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateVpcLinkErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAccessLogSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAccessLogSettingsError {
    /// Kind of error that occurred.
    pub kind: DeleteAccessLogSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAccessLogSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAccessLogSettingsErrorKind {
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAccessLogSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAccessLogSettingsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteAccessLogSettingsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteAccessLogSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAccessLogSettingsError {
    fn code(&self) -> Option<&str> {
        DeleteAccessLogSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAccessLogSettingsError {
    /// Creates a new `DeleteAccessLogSettingsError`.
    pub fn new(kind: DeleteAccessLogSettingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAccessLogSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAccessLogSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAccessLogSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAccessLogSettingsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteAccessLogSettingsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAccessLogSettingsErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteAccessLogSettingsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAccessLogSettingsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteAccessLogSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAccessLogSettingsErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteAccessLogSettingsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteAccessLogSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteApi` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteApiError {
    /// Kind of error that occurred.
    pub kind: DeleteApiErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteApi` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteApiErrorKind {
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteApiError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteApiErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteApiErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteApiErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteApiError {
    fn code(&self) -> Option<&str> {
        DeleteApiError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteApiError {
    /// Creates a new `DeleteApiError`.
    pub fn new(kind: DeleteApiErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteApiError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteApiErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteApiError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteApiErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteApiErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteApiErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `DeleteApiErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, DeleteApiErrorKind::TooManyRequestsException(_))
    }
}
impl std::error::Error for DeleteApiError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteApiErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteApiErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteApiErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteApiMapping` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteApiMappingError {
    /// Kind of error that occurred.
    pub kind: DeleteApiMappingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteApiMapping` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteApiMappingErrorKind {
    /// <p>The request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteApiMappingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteApiMappingErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteApiMappingErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteApiMappingErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteApiMappingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteApiMappingError {
    fn code(&self) -> Option<&str> {
        DeleteApiMappingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteApiMappingError {
    /// Creates a new `DeleteApiMappingError`.
    pub fn new(kind: DeleteApiMappingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteApiMappingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteApiMappingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteApiMappingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteApiMappingErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteApiMappingErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApiMappingErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `DeleteApiMappingErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteApiMappingErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `DeleteApiMappingErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApiMappingErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteApiMappingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteApiMappingErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteApiMappingErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteApiMappingErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteApiMappingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAuthorizer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAuthorizerError {
    /// Kind of error that occurred.
    pub kind: DeleteAuthorizerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAuthorizer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAuthorizerErrorKind {
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAuthorizerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAuthorizerErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteAuthorizerErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteAuthorizerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAuthorizerError {
    fn code(&self) -> Option<&str> {
        DeleteAuthorizerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAuthorizerError {
    /// Creates a new `DeleteAuthorizerError`.
    pub fn new(kind: DeleteAuthorizerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAuthorizerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAuthorizerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAuthorizerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAuthorizerErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteAuthorizerErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteAuthorizerErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `DeleteAuthorizerErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAuthorizerErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteAuthorizerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAuthorizerErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteAuthorizerErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteAuthorizerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteCorsConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteCorsConfigurationError {
    /// Kind of error that occurred.
    pub kind: DeleteCorsConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteCorsConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteCorsConfigurationErrorKind {
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteCorsConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteCorsConfigurationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteCorsConfigurationErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteCorsConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteCorsConfigurationError {
    fn code(&self) -> Option<&str> {
        DeleteCorsConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteCorsConfigurationError {
    /// Creates a new `DeleteCorsConfigurationError`.
    pub fn new(kind: DeleteCorsConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteCorsConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteCorsConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteCorsConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteCorsConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteCorsConfigurationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCorsConfigurationErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteCorsConfigurationErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCorsConfigurationErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteCorsConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteCorsConfigurationErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteCorsConfigurationErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteCorsConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDeployment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDeploymentError {
    /// Kind of error that occurred.
    pub kind: DeleteDeploymentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDeployment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDeploymentErrorKind {
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDeploymentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDeploymentErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteDeploymentErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteDeploymentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDeploymentError {
    fn code(&self) -> Option<&str> {
        DeleteDeploymentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDeploymentError {
    /// Creates a new `DeleteDeploymentError`.
    pub fn new(kind: DeleteDeploymentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDeploymentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDeploymentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDeploymentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDeploymentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteDeploymentErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteDeploymentErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `DeleteDeploymentErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDeploymentErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteDeploymentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDeploymentErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteDeploymentErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteDeploymentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDomainName` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDomainNameError {
    /// Kind of error that occurred.
    pub kind: DeleteDomainNameErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDomainName` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDomainNameErrorKind {
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDomainNameError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDomainNameErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteDomainNameErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteDomainNameErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDomainNameError {
    fn code(&self) -> Option<&str> {
        DeleteDomainNameError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDomainNameError {
    /// Creates a new `DeleteDomainNameError`.
    pub fn new(kind: DeleteDomainNameErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDomainNameError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDomainNameErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDomainNameError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDomainNameErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteDomainNameErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteDomainNameErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `DeleteDomainNameErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDomainNameErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteDomainNameError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDomainNameErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteDomainNameErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteDomainNameErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteIntegration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteIntegrationError {
    /// Kind of error that occurred.
    pub kind: DeleteIntegrationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteIntegration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteIntegrationErrorKind {
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteIntegrationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteIntegrationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteIntegrationErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteIntegrationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteIntegrationError {
    fn code(&self) -> Option<&str> {
        DeleteIntegrationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteIntegrationError {
    /// Creates a new `DeleteIntegrationError`.
    pub fn new(kind: DeleteIntegrationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteIntegrationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteIntegrationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteIntegrationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteIntegrationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteIntegrationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteIntegrationErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `DeleteIntegrationErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIntegrationErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteIntegrationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteIntegrationErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteIntegrationErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteIntegrationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteIntegrationResponse` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteIntegrationResponseError {
    /// Kind of error that occurred.
    pub kind: DeleteIntegrationResponseErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteIntegrationResponse` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteIntegrationResponseErrorKind {
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteIntegrationResponseError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteIntegrationResponseErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteIntegrationResponseErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteIntegrationResponseErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteIntegrationResponseError {
    fn code(&self) -> Option<&str> {
        DeleteIntegrationResponseError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteIntegrationResponseError {
    /// Creates a new `DeleteIntegrationResponseError`.
    pub fn new(kind: DeleteIntegrationResponseErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteIntegrationResponseError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteIntegrationResponseErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteIntegrationResponseError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteIntegrationResponseErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteIntegrationResponseErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIntegrationResponseErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteIntegrationResponseErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIntegrationResponseErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteIntegrationResponseError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteIntegrationResponseErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteIntegrationResponseErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteIntegrationResponseErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteModel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteModelError {
    /// Kind of error that occurred.
    pub kind: DeleteModelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteModel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteModelErrorKind {
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteModelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteModelErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteModelErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteModelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteModelError {
    fn code(&self) -> Option<&str> {
        DeleteModelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteModelError {
    /// Creates a new `DeleteModelError`.
    pub fn new(kind: DeleteModelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteModelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteModelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteModelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteModelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteModelErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteModelErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `DeleteModelErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteModelErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteModelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteModelErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteModelErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteModelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteRoute` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteRouteError {
    /// Kind of error that occurred.
    pub kind: DeleteRouteErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteRoute` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteRouteErrorKind {
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteRouteError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteRouteErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteRouteErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteRouteErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteRouteError {
    fn code(&self) -> Option<&str> {
        DeleteRouteError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteRouteError {
    /// Creates a new `DeleteRouteError`.
    pub fn new(kind: DeleteRouteErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteRouteError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteRouteErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteRouteError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteRouteErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteRouteErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteRouteErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `DeleteRouteErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRouteErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteRouteError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteRouteErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteRouteErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteRouteErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteRouteRequestParameter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteRouteRequestParameterError {
    /// Kind of error that occurred.
    pub kind: DeleteRouteRequestParameterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteRouteRequestParameter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteRouteRequestParameterErrorKind {
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteRouteRequestParameterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteRouteRequestParameterErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteRouteRequestParameterErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteRouteRequestParameterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteRouteRequestParameterError {
    fn code(&self) -> Option<&str> {
        DeleteRouteRequestParameterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteRouteRequestParameterError {
    /// Creates a new `DeleteRouteRequestParameterError`.
    pub fn new(kind: DeleteRouteRequestParameterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteRouteRequestParameterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteRouteRequestParameterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteRouteRequestParameterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteRouteRequestParameterErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteRouteRequestParameterErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRouteRequestParameterErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteRouteRequestParameterErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRouteRequestParameterErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteRouteRequestParameterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteRouteRequestParameterErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteRouteRequestParameterErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteRouteRequestParameterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteRouteResponse` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteRouteResponseError {
    /// Kind of error that occurred.
    pub kind: DeleteRouteResponseErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteRouteResponse` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteRouteResponseErrorKind {
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteRouteResponseError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteRouteResponseErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteRouteResponseErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteRouteResponseErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteRouteResponseError {
    fn code(&self) -> Option<&str> {
        DeleteRouteResponseError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteRouteResponseError {
    /// Creates a new `DeleteRouteResponseError`.
    pub fn new(kind: DeleteRouteResponseErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteRouteResponseError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteRouteResponseErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteRouteResponseError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteRouteResponseErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteRouteResponseErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRouteResponseErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteRouteResponseErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRouteResponseErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteRouteResponseError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteRouteResponseErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteRouteResponseErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteRouteResponseErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteRouteSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteRouteSettingsError {
    /// Kind of error that occurred.
    pub kind: DeleteRouteSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteRouteSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteRouteSettingsErrorKind {
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteRouteSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteRouteSettingsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteRouteSettingsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteRouteSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteRouteSettingsError {
    fn code(&self) -> Option<&str> {
        DeleteRouteSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteRouteSettingsError {
    /// Creates a new `DeleteRouteSettingsError`.
    pub fn new(kind: DeleteRouteSettingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteRouteSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteRouteSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteRouteSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteRouteSettingsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteRouteSettingsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRouteSettingsErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteRouteSettingsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRouteSettingsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteRouteSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteRouteSettingsErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteRouteSettingsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteRouteSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteStage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteStageError {
    /// Kind of error that occurred.
    pub kind: DeleteStageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteStage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteStageErrorKind {
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteStageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteStageErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteStageErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteStageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteStageError {
    fn code(&self) -> Option<&str> {
        DeleteStageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteStageError {
    /// Creates a new `DeleteStageError`.
    pub fn new(kind: DeleteStageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteStageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteStageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteStageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteStageErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteStageErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteStageErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `DeleteStageErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStageErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteStageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteStageErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteStageErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteStageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteVpcLink` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteVpcLinkError {
    /// Kind of error that occurred.
    pub kind: DeleteVpcLinkErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteVpcLink` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteVpcLinkErrorKind {
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteVpcLinkError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteVpcLinkErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteVpcLinkErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteVpcLinkErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteVpcLinkError {
    fn code(&self) -> Option<&str> {
        DeleteVpcLinkError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteVpcLinkError {
    /// Creates a new `DeleteVpcLinkError`.
    pub fn new(kind: DeleteVpcLinkErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteVpcLinkError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteVpcLinkErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteVpcLinkError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteVpcLinkErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteVpcLinkErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteVpcLinkErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `DeleteVpcLinkErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVpcLinkErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteVpcLinkError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteVpcLinkErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteVpcLinkErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteVpcLinkErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ExportApi` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ExportApiError {
    /// Kind of error that occurred.
    pub kind: ExportApiErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ExportApi` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ExportApiErrorKind {
    /// <p>The request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ExportApiError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ExportApiErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ExportApiErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ExportApiErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ExportApiErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ExportApiError {
    fn code(&self) -> Option<&str> {
        ExportApiError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ExportApiError {
    /// Creates a new `ExportApiError`.
    pub fn new(kind: ExportApiErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ExportApiError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ExportApiErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ExportApiError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ExportApiErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ExportApiErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ExportApiErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `ExportApiErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ExportApiErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `ExportApiErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, ExportApiErrorKind::TooManyRequestsException(_))
    }
}
impl std::error::Error for ExportApiError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ExportApiErrorKind::BadRequestException(_inner) => Some(_inner),
            ExportApiErrorKind::NotFoundException(_inner) => Some(_inner),
            ExportApiErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ExportApiErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetApi` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetApiError {
    /// Kind of error that occurred.
    pub kind: GetApiErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetApi` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetApiErrorKind {
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetApiError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetApiErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetApiErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetApiErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetApiError {
    fn code(&self) -> Option<&str> {
        GetApiError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetApiError {
    /// Creates a new `GetApiError`.
    pub fn new(kind: GetApiErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetApiError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetApiErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetApiError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetApiErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetApiErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetApiErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetApiErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, GetApiErrorKind::TooManyRequestsException(_))
    }
}
impl std::error::Error for GetApiError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetApiErrorKind::NotFoundException(_inner) => Some(_inner),
            GetApiErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetApiErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetApiMapping` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetApiMappingError {
    /// Kind of error that occurred.
    pub kind: GetApiMappingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetApiMapping` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetApiMappingErrorKind {
    /// <p>The request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetApiMappingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetApiMappingErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetApiMappingErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetApiMappingErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetApiMappingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetApiMappingError {
    fn code(&self) -> Option<&str> {
        GetApiMappingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetApiMappingError {
    /// Creates a new `GetApiMappingError`.
    pub fn new(kind: GetApiMappingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetApiMappingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetApiMappingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetApiMappingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetApiMappingErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetApiMappingErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetApiMappingErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `GetApiMappingErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetApiMappingErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetApiMappingErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApiMappingErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetApiMappingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetApiMappingErrorKind::BadRequestException(_inner) => Some(_inner),
            GetApiMappingErrorKind::NotFoundException(_inner) => Some(_inner),
            GetApiMappingErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetApiMappingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetApiMappings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetApiMappingsError {
    /// Kind of error that occurred.
    pub kind: GetApiMappingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetApiMappings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetApiMappingsErrorKind {
    /// <p>The request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetApiMappingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetApiMappingsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetApiMappingsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetApiMappingsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetApiMappingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetApiMappingsError {
    fn code(&self) -> Option<&str> {
        GetApiMappingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetApiMappingsError {
    /// Creates a new `GetApiMappingsError`.
    pub fn new(kind: GetApiMappingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetApiMappingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetApiMappingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetApiMappingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetApiMappingsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetApiMappingsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetApiMappingsErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `GetApiMappingsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetApiMappingsErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetApiMappingsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApiMappingsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetApiMappingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetApiMappingsErrorKind::BadRequestException(_inner) => Some(_inner),
            GetApiMappingsErrorKind::NotFoundException(_inner) => Some(_inner),
            GetApiMappingsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetApiMappingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetApis` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetApisError {
    /// Kind of error that occurred.
    pub kind: GetApisErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetApis` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetApisErrorKind {
    /// <p>The request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetApisError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetApisErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetApisErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetApisErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetApisErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetApisError {
    fn code(&self) -> Option<&str> {
        GetApisError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetApisError {
    /// Creates a new `GetApisError`.
    pub fn new(kind: GetApisErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetApisError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetApisErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetApisError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetApisErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetApisErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetApisErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `GetApisErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetApisErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetApisErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, GetApisErrorKind::TooManyRequestsException(_))
    }
}
impl std::error::Error for GetApisError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetApisErrorKind::BadRequestException(_inner) => Some(_inner),
            GetApisErrorKind::NotFoundException(_inner) => Some(_inner),
            GetApisErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetApisErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetAuthorizer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAuthorizerError {
    /// Kind of error that occurred.
    pub kind: GetAuthorizerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAuthorizer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAuthorizerErrorKind {
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAuthorizerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAuthorizerErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetAuthorizerErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetAuthorizerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAuthorizerError {
    fn code(&self) -> Option<&str> {
        GetAuthorizerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAuthorizerError {
    /// Creates a new `GetAuthorizerError`.
    pub fn new(kind: GetAuthorizerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAuthorizerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAuthorizerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAuthorizerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAuthorizerErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetAuthorizerErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetAuthorizerErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetAuthorizerErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAuthorizerErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetAuthorizerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAuthorizerErrorKind::NotFoundException(_inner) => Some(_inner),
            GetAuthorizerErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetAuthorizerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetAuthorizers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAuthorizersError {
    /// Kind of error that occurred.
    pub kind: GetAuthorizersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAuthorizers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAuthorizersErrorKind {
    /// <p>The request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAuthorizersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAuthorizersErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetAuthorizersErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetAuthorizersErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetAuthorizersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAuthorizersError {
    fn code(&self) -> Option<&str> {
        GetAuthorizersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAuthorizersError {
    /// Creates a new `GetAuthorizersError`.
    pub fn new(kind: GetAuthorizersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAuthorizersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAuthorizersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAuthorizersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAuthorizersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetAuthorizersErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetAuthorizersErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `GetAuthorizersErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetAuthorizersErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetAuthorizersErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAuthorizersErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetAuthorizersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAuthorizersErrorKind::BadRequestException(_inner) => Some(_inner),
            GetAuthorizersErrorKind::NotFoundException(_inner) => Some(_inner),
            GetAuthorizersErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetAuthorizersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDeployment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDeploymentError {
    /// Kind of error that occurred.
    pub kind: GetDeploymentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDeployment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDeploymentErrorKind {
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDeploymentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDeploymentErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetDeploymentErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetDeploymentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDeploymentError {
    fn code(&self) -> Option<&str> {
        GetDeploymentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDeploymentError {
    /// Creates a new `GetDeploymentError`.
    pub fn new(kind: GetDeploymentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDeploymentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDeploymentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDeploymentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDeploymentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetDeploymentErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetDeploymentErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetDeploymentErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDeploymentErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetDeploymentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDeploymentErrorKind::NotFoundException(_inner) => Some(_inner),
            GetDeploymentErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetDeploymentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDeployments` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDeploymentsError {
    /// Kind of error that occurred.
    pub kind: GetDeploymentsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDeployments` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDeploymentsErrorKind {
    /// <p>The request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDeploymentsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDeploymentsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetDeploymentsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetDeploymentsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetDeploymentsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDeploymentsError {
    fn code(&self) -> Option<&str> {
        GetDeploymentsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDeploymentsError {
    /// Creates a new `GetDeploymentsError`.
    pub fn new(kind: GetDeploymentsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDeploymentsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDeploymentsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDeploymentsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDeploymentsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetDeploymentsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetDeploymentsErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `GetDeploymentsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetDeploymentsErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetDeploymentsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDeploymentsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetDeploymentsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDeploymentsErrorKind::BadRequestException(_inner) => Some(_inner),
            GetDeploymentsErrorKind::NotFoundException(_inner) => Some(_inner),
            GetDeploymentsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetDeploymentsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDomainName` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDomainNameError {
    /// Kind of error that occurred.
    pub kind: GetDomainNameErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDomainName` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDomainNameErrorKind {
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDomainNameError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDomainNameErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetDomainNameErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetDomainNameErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDomainNameError {
    fn code(&self) -> Option<&str> {
        GetDomainNameError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDomainNameError {
    /// Creates a new `GetDomainNameError`.
    pub fn new(kind: GetDomainNameErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDomainNameError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDomainNameErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDomainNameError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDomainNameErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetDomainNameErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetDomainNameErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetDomainNameErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDomainNameErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetDomainNameError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDomainNameErrorKind::NotFoundException(_inner) => Some(_inner),
            GetDomainNameErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetDomainNameErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDomainNames` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDomainNamesError {
    /// Kind of error that occurred.
    pub kind: GetDomainNamesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDomainNames` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDomainNamesErrorKind {
    /// <p>The request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDomainNamesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDomainNamesErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetDomainNamesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetDomainNamesErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetDomainNamesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDomainNamesError {
    fn code(&self) -> Option<&str> {
        GetDomainNamesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDomainNamesError {
    /// Creates a new `GetDomainNamesError`.
    pub fn new(kind: GetDomainNamesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDomainNamesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDomainNamesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDomainNamesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDomainNamesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetDomainNamesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetDomainNamesErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `GetDomainNamesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetDomainNamesErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetDomainNamesErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDomainNamesErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetDomainNamesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDomainNamesErrorKind::BadRequestException(_inner) => Some(_inner),
            GetDomainNamesErrorKind::NotFoundException(_inner) => Some(_inner),
            GetDomainNamesErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetDomainNamesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetIntegration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetIntegrationError {
    /// Kind of error that occurred.
    pub kind: GetIntegrationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetIntegration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetIntegrationErrorKind {
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetIntegrationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetIntegrationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetIntegrationErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetIntegrationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetIntegrationError {
    fn code(&self) -> Option<&str> {
        GetIntegrationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetIntegrationError {
    /// Creates a new `GetIntegrationError`.
    pub fn new(kind: GetIntegrationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetIntegrationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetIntegrationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetIntegrationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetIntegrationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetIntegrationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetIntegrationErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetIntegrationErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetIntegrationErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetIntegrationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetIntegrationErrorKind::NotFoundException(_inner) => Some(_inner),
            GetIntegrationErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetIntegrationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetIntegrationResponse` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetIntegrationResponseError {
    /// Kind of error that occurred.
    pub kind: GetIntegrationResponseErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetIntegrationResponse` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetIntegrationResponseErrorKind {
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetIntegrationResponseError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetIntegrationResponseErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetIntegrationResponseErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetIntegrationResponseErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetIntegrationResponseError {
    fn code(&self) -> Option<&str> {
        GetIntegrationResponseError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetIntegrationResponseError {
    /// Creates a new `GetIntegrationResponseError`.
    pub fn new(kind: GetIntegrationResponseErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetIntegrationResponseError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetIntegrationResponseErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetIntegrationResponseError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetIntegrationResponseErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetIntegrationResponseErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetIntegrationResponseErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetIntegrationResponseErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetIntegrationResponseErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetIntegrationResponseError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetIntegrationResponseErrorKind::NotFoundException(_inner) => Some(_inner),
            GetIntegrationResponseErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetIntegrationResponseErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetIntegrationResponses` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetIntegrationResponsesError {
    /// Kind of error that occurred.
    pub kind: GetIntegrationResponsesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetIntegrationResponses` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetIntegrationResponsesErrorKind {
    /// <p>The request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetIntegrationResponsesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetIntegrationResponsesErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetIntegrationResponsesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetIntegrationResponsesErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetIntegrationResponsesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetIntegrationResponsesError {
    fn code(&self) -> Option<&str> {
        GetIntegrationResponsesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetIntegrationResponsesError {
    /// Creates a new `GetIntegrationResponsesError`.
    pub fn new(kind: GetIntegrationResponsesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetIntegrationResponsesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetIntegrationResponsesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetIntegrationResponsesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetIntegrationResponsesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetIntegrationResponsesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetIntegrationResponsesErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `GetIntegrationResponsesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetIntegrationResponsesErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetIntegrationResponsesErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetIntegrationResponsesErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetIntegrationResponsesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetIntegrationResponsesErrorKind::BadRequestException(_inner) => Some(_inner),
            GetIntegrationResponsesErrorKind::NotFoundException(_inner) => Some(_inner),
            GetIntegrationResponsesErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetIntegrationResponsesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetIntegrations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetIntegrationsError {
    /// Kind of error that occurred.
    pub kind: GetIntegrationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetIntegrations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetIntegrationsErrorKind {
    /// <p>The request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetIntegrationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetIntegrationsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetIntegrationsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetIntegrationsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetIntegrationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetIntegrationsError {
    fn code(&self) -> Option<&str> {
        GetIntegrationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetIntegrationsError {
    /// Creates a new `GetIntegrationsError`.
    pub fn new(kind: GetIntegrationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetIntegrationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetIntegrationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetIntegrationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetIntegrationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetIntegrationsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetIntegrationsErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `GetIntegrationsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetIntegrationsErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetIntegrationsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetIntegrationsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetIntegrationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetIntegrationsErrorKind::BadRequestException(_inner) => Some(_inner),
            GetIntegrationsErrorKind::NotFoundException(_inner) => Some(_inner),
            GetIntegrationsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetIntegrationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetModel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetModelError {
    /// Kind of error that occurred.
    pub kind: GetModelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetModel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetModelErrorKind {
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetModelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetModelErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetModelErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetModelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetModelError {
    fn code(&self) -> Option<&str> {
        GetModelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetModelError {
    /// Creates a new `GetModelError`.
    pub fn new(kind: GetModelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetModelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetModelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetModelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetModelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetModelErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetModelErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetModelErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, GetModelErrorKind::TooManyRequestsException(_))
    }
}
impl std::error::Error for GetModelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetModelErrorKind::NotFoundException(_inner) => Some(_inner),
            GetModelErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetModelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetModels` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetModelsError {
    /// Kind of error that occurred.
    pub kind: GetModelsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetModels` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetModelsErrorKind {
    /// <p>The request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetModelsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetModelsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetModelsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetModelsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetModelsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetModelsError {
    fn code(&self) -> Option<&str> {
        GetModelsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetModelsError {
    /// Creates a new `GetModelsError`.
    pub fn new(kind: GetModelsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetModelsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetModelsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetModelsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetModelsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetModelsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetModelsErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `GetModelsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetModelsErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetModelsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, GetModelsErrorKind::TooManyRequestsException(_))
    }
}
impl std::error::Error for GetModelsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetModelsErrorKind::BadRequestException(_inner) => Some(_inner),
            GetModelsErrorKind::NotFoundException(_inner) => Some(_inner),
            GetModelsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetModelsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetModelTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetModelTemplateError {
    /// Kind of error that occurred.
    pub kind: GetModelTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetModelTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetModelTemplateErrorKind {
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetModelTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetModelTemplateErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetModelTemplateErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetModelTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetModelTemplateError {
    fn code(&self) -> Option<&str> {
        GetModelTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetModelTemplateError {
    /// Creates a new `GetModelTemplateError`.
    pub fn new(kind: GetModelTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetModelTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetModelTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetModelTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetModelTemplateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetModelTemplateErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetModelTemplateErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetModelTemplateErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetModelTemplateErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetModelTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetModelTemplateErrorKind::NotFoundException(_inner) => Some(_inner),
            GetModelTemplateErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetModelTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRoute` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRouteError {
    /// Kind of error that occurred.
    pub kind: GetRouteErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRoute` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRouteErrorKind {
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRouteError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRouteErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetRouteErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetRouteErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRouteError {
    fn code(&self) -> Option<&str> {
        GetRouteError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRouteError {
    /// Creates a new `GetRouteError`.
    pub fn new(kind: GetRouteErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRouteError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRouteErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRouteError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRouteErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetRouteErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetRouteErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetRouteErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, GetRouteErrorKind::TooManyRequestsException(_))
    }
}
impl std::error::Error for GetRouteError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRouteErrorKind::NotFoundException(_inner) => Some(_inner),
            GetRouteErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetRouteErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRouteResponse` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRouteResponseError {
    /// Kind of error that occurred.
    pub kind: GetRouteResponseErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRouteResponse` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRouteResponseErrorKind {
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRouteResponseError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRouteResponseErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetRouteResponseErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetRouteResponseErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRouteResponseError {
    fn code(&self) -> Option<&str> {
        GetRouteResponseError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRouteResponseError {
    /// Creates a new `GetRouteResponseError`.
    pub fn new(kind: GetRouteResponseErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRouteResponseError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRouteResponseErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRouteResponseError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRouteResponseErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetRouteResponseErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetRouteResponseErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetRouteResponseErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRouteResponseErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetRouteResponseError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRouteResponseErrorKind::NotFoundException(_inner) => Some(_inner),
            GetRouteResponseErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetRouteResponseErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRouteResponses` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRouteResponsesError {
    /// Kind of error that occurred.
    pub kind: GetRouteResponsesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRouteResponses` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRouteResponsesErrorKind {
    /// <p>The request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRouteResponsesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRouteResponsesErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetRouteResponsesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetRouteResponsesErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetRouteResponsesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRouteResponsesError {
    fn code(&self) -> Option<&str> {
        GetRouteResponsesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRouteResponsesError {
    /// Creates a new `GetRouteResponsesError`.
    pub fn new(kind: GetRouteResponsesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRouteResponsesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRouteResponsesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRouteResponsesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRouteResponsesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetRouteResponsesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRouteResponsesErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `GetRouteResponsesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetRouteResponsesErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetRouteResponsesErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRouteResponsesErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetRouteResponsesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRouteResponsesErrorKind::BadRequestException(_inner) => Some(_inner),
            GetRouteResponsesErrorKind::NotFoundException(_inner) => Some(_inner),
            GetRouteResponsesErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetRouteResponsesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRoutes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRoutesError {
    /// Kind of error that occurred.
    pub kind: GetRoutesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRoutes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRoutesErrorKind {
    /// <p>The request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRoutesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRoutesErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetRoutesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetRoutesErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetRoutesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRoutesError {
    fn code(&self) -> Option<&str> {
        GetRoutesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRoutesError {
    /// Creates a new `GetRoutesError`.
    pub fn new(kind: GetRoutesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRoutesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRoutesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRoutesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRoutesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetRoutesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetRoutesErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `GetRoutesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetRoutesErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetRoutesErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, GetRoutesErrorKind::TooManyRequestsException(_))
    }
}
impl std::error::Error for GetRoutesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRoutesErrorKind::BadRequestException(_inner) => Some(_inner),
            GetRoutesErrorKind::NotFoundException(_inner) => Some(_inner),
            GetRoutesErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetRoutesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetStage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetStageError {
    /// Kind of error that occurred.
    pub kind: GetStageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetStage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetStageErrorKind {
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetStageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetStageErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetStageErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetStageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetStageError {
    fn code(&self) -> Option<&str> {
        GetStageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetStageError {
    /// Creates a new `GetStageError`.
    pub fn new(kind: GetStageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetStageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetStageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetStageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetStageErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetStageErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetStageErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetStageErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, GetStageErrorKind::TooManyRequestsException(_))
    }
}
impl std::error::Error for GetStageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetStageErrorKind::NotFoundException(_inner) => Some(_inner),
            GetStageErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetStageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetStages` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetStagesError {
    /// Kind of error that occurred.
    pub kind: GetStagesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetStages` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetStagesErrorKind {
    /// <p>The request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetStagesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetStagesErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetStagesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetStagesErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetStagesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetStagesError {
    fn code(&self) -> Option<&str> {
        GetStagesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetStagesError {
    /// Creates a new `GetStagesError`.
    pub fn new(kind: GetStagesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetStagesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetStagesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetStagesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetStagesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetStagesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetStagesErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `GetStagesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetStagesErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetStagesErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, GetStagesErrorKind::TooManyRequestsException(_))
    }
}
impl std::error::Error for GetStagesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetStagesErrorKind::BadRequestException(_inner) => Some(_inner),
            GetStagesErrorKind::NotFoundException(_inner) => Some(_inner),
            GetStagesErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetStagesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetTagsError {
    /// Kind of error that occurred.
    pub kind: GetTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetTagsErrorKind {
    /// <p>The request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested operation would cause a conflict with the current state of a service resource associated with the request. Resolve the conflict before retrying this request. See the accompanying error message for details.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetTagsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetTagsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            GetTagsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetTagsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetTagsError {
    fn code(&self) -> Option<&str> {
        GetTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetTagsError {
    /// Creates a new `GetTagsError`.
    pub fn new(kind: GetTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetTagsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetTagsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetTagsErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `GetTagsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, GetTagsErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `GetTagsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetTagsErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetTagsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, GetTagsErrorKind::TooManyRequestsException(_))
    }
}
impl std::error::Error for GetTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetTagsErrorKind::BadRequestException(_inner) => Some(_inner),
            GetTagsErrorKind::ConflictException(_inner) => Some(_inner),
            GetTagsErrorKind::NotFoundException(_inner) => Some(_inner),
            GetTagsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetVpcLink` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetVpcLinkError {
    /// Kind of error that occurred.
    pub kind: GetVpcLinkErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetVpcLink` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetVpcLinkErrorKind {
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetVpcLinkError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetVpcLinkErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetVpcLinkErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetVpcLinkErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetVpcLinkError {
    fn code(&self) -> Option<&str> {
        GetVpcLinkError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetVpcLinkError {
    /// Creates a new `GetVpcLinkError`.
    pub fn new(kind: GetVpcLinkErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetVpcLinkError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetVpcLinkErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetVpcLinkError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetVpcLinkErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetVpcLinkErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetVpcLinkErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetVpcLinkErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, GetVpcLinkErrorKind::TooManyRequestsException(_))
    }
}
impl std::error::Error for GetVpcLinkError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetVpcLinkErrorKind::NotFoundException(_inner) => Some(_inner),
            GetVpcLinkErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetVpcLinkErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetVpcLinks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetVpcLinksError {
    /// Kind of error that occurred.
    pub kind: GetVpcLinksErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetVpcLinks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetVpcLinksErrorKind {
    /// <p>The request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetVpcLinksError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetVpcLinksErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetVpcLinksErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetVpcLinksErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetVpcLinksError {
    fn code(&self) -> Option<&str> {
        GetVpcLinksError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetVpcLinksError {
    /// Creates a new `GetVpcLinksError`.
    pub fn new(kind: GetVpcLinksErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetVpcLinksError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetVpcLinksErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetVpcLinksError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetVpcLinksErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetVpcLinksErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetVpcLinksErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `GetVpcLinksErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVpcLinksErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetVpcLinksError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetVpcLinksErrorKind::BadRequestException(_inner) => Some(_inner),
            GetVpcLinksErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetVpcLinksErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ImportApi` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ImportApiError {
    /// Kind of error that occurred.
    pub kind: ImportApiErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ImportApi` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ImportApiErrorKind {
    /// <p>The request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested operation would cause a conflict with the current state of a service resource associated with the request. Resolve the conflict before retrying this request. See the accompanying error message for details.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ImportApiError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ImportApiErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ImportApiErrorKind::ConflictException(_inner) => _inner.fmt(f),
            ImportApiErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ImportApiErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ImportApiErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ImportApiError {
    fn code(&self) -> Option<&str> {
        ImportApiError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ImportApiError {
    /// Creates a new `ImportApiError`.
    pub fn new(kind: ImportApiErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ImportApiError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ImportApiErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ImportApiError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ImportApiErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ImportApiErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ImportApiErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `ImportApiErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, ImportApiErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `ImportApiErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ImportApiErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `ImportApiErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, ImportApiErrorKind::TooManyRequestsException(_))
    }
}
impl std::error::Error for ImportApiError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ImportApiErrorKind::BadRequestException(_inner) => Some(_inner),
            ImportApiErrorKind::ConflictException(_inner) => Some(_inner),
            ImportApiErrorKind::NotFoundException(_inner) => Some(_inner),
            ImportApiErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ImportApiErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ReimportApi` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ReimportApiError {
    /// Kind of error that occurred.
    pub kind: ReimportApiErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ReimportApi` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ReimportApiErrorKind {
    /// <p>The request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested operation would cause a conflict with the current state of a service resource associated with the request. Resolve the conflict before retrying this request. See the accompanying error message for details.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ReimportApiError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ReimportApiErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ReimportApiErrorKind::ConflictException(_inner) => _inner.fmt(f),
            ReimportApiErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ReimportApiErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ReimportApiErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ReimportApiError {
    fn code(&self) -> Option<&str> {
        ReimportApiError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ReimportApiError {
    /// Creates a new `ReimportApiError`.
    pub fn new(kind: ReimportApiErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ReimportApiError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ReimportApiErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ReimportApiError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ReimportApiErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ReimportApiErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ReimportApiErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `ReimportApiErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, ReimportApiErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `ReimportApiErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ReimportApiErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `ReimportApiErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ReimportApiErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ReimportApiError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ReimportApiErrorKind::BadRequestException(_inner) => Some(_inner),
            ReimportApiErrorKind::ConflictException(_inner) => Some(_inner),
            ReimportApiErrorKind::NotFoundException(_inner) => Some(_inner),
            ReimportApiErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ReimportApiErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ResetAuthorizersCache` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ResetAuthorizersCacheError {
    /// Kind of error that occurred.
    pub kind: ResetAuthorizersCacheErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ResetAuthorizersCache` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ResetAuthorizersCacheErrorKind {
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ResetAuthorizersCacheError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ResetAuthorizersCacheErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ResetAuthorizersCacheErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ResetAuthorizersCacheErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ResetAuthorizersCacheError {
    fn code(&self) -> Option<&str> {
        ResetAuthorizersCacheError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ResetAuthorizersCacheError {
    /// Creates a new `ResetAuthorizersCacheError`.
    pub fn new(kind: ResetAuthorizersCacheErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ResetAuthorizersCacheError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ResetAuthorizersCacheErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ResetAuthorizersCacheError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ResetAuthorizersCacheErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ResetAuthorizersCacheErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResetAuthorizersCacheErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ResetAuthorizersCacheErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResetAuthorizersCacheErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ResetAuthorizersCacheError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ResetAuthorizersCacheErrorKind::NotFoundException(_inner) => Some(_inner),
            ResetAuthorizersCacheErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ResetAuthorizersCacheErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>The request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested operation would cause a conflict with the current state of a service resource associated with the request. Resolve the conflict before retrying this request. See the accompanying error message for details.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `TagResourceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `TagResourceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `TagResourceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `TagResourceErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::BadRequestException(_inner) => Some(_inner),
            TagResourceErrorKind::ConflictException(_inner) => Some(_inner),
            TagResourceErrorKind::NotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>The request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested operation would cause a conflict with the current state of a service resource associated with the request. Resolve the conflict before retrying this request. See the accompanying error message for details.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::BadRequestException(_inner) => Some(_inner),
            UntagResourceErrorKind::ConflictException(_inner) => Some(_inner),
            UntagResourceErrorKind::NotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateApi` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateApiError {
    /// Kind of error that occurred.
    pub kind: UpdateApiErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateApi` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateApiErrorKind {
    /// <p>The request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested operation would cause a conflict with the current state of a service resource associated with the request. Resolve the conflict before retrying this request. See the accompanying error message for details.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateApiError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateApiErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateApiErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateApiErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateApiErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateApiErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateApiError {
    fn code(&self) -> Option<&str> {
        UpdateApiError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateApiError {
    /// Creates a new `UpdateApiError`.
    pub fn new(kind: UpdateApiErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateApiError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateApiErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateApiError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateApiErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateApiErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, UpdateApiErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `UpdateApiErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateApiErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `UpdateApiErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateApiErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `UpdateApiErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, UpdateApiErrorKind::TooManyRequestsException(_))
    }
}
impl std::error::Error for UpdateApiError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateApiErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateApiErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateApiErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateApiErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateApiErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateApiMapping` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateApiMappingError {
    /// Kind of error that occurred.
    pub kind: UpdateApiMappingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateApiMapping` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateApiMappingErrorKind {
    /// <p>The request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested operation would cause a conflict with the current state of a service resource associated with the request. Resolve the conflict before retrying this request. See the accompanying error message for details.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateApiMappingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateApiMappingErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateApiMappingErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateApiMappingErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateApiMappingErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateApiMappingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateApiMappingError {
    fn code(&self) -> Option<&str> {
        UpdateApiMappingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateApiMappingError {
    /// Creates a new `UpdateApiMappingError`.
    pub fn new(kind: UpdateApiMappingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateApiMappingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateApiMappingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateApiMappingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateApiMappingErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateApiMappingErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApiMappingErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `UpdateApiMappingErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateApiMappingErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `UpdateApiMappingErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateApiMappingErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `UpdateApiMappingErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApiMappingErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateApiMappingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateApiMappingErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateApiMappingErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateApiMappingErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateApiMappingErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateApiMappingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateAuthorizer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateAuthorizerError {
    /// Kind of error that occurred.
    pub kind: UpdateAuthorizerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateAuthorizer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateAuthorizerErrorKind {
    /// <p>The request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested operation would cause a conflict with the current state of a service resource associated with the request. Resolve the conflict before retrying this request. See the accompanying error message for details.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateAuthorizerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateAuthorizerErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateAuthorizerErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateAuthorizerErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateAuthorizerErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateAuthorizerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateAuthorizerError {
    fn code(&self) -> Option<&str> {
        UpdateAuthorizerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateAuthorizerError {
    /// Creates a new `UpdateAuthorizerError`.
    pub fn new(kind: UpdateAuthorizerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateAuthorizerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateAuthorizerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateAuthorizerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateAuthorizerErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateAuthorizerErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAuthorizerErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `UpdateAuthorizerErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateAuthorizerErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `UpdateAuthorizerErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateAuthorizerErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `UpdateAuthorizerErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAuthorizerErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateAuthorizerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateAuthorizerErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateAuthorizerErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateAuthorizerErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateAuthorizerErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateAuthorizerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateDeployment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateDeploymentError {
    /// Kind of error that occurred.
    pub kind: UpdateDeploymentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateDeployment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateDeploymentErrorKind {
    /// <p>The request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested operation would cause a conflict with the current state of a service resource associated with the request. Resolve the conflict before retrying this request. See the accompanying error message for details.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateDeploymentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateDeploymentErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateDeploymentErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateDeploymentErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateDeploymentErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateDeploymentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateDeploymentError {
    fn code(&self) -> Option<&str> {
        UpdateDeploymentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateDeploymentError {
    /// Creates a new `UpdateDeploymentError`.
    pub fn new(kind: UpdateDeploymentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateDeploymentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateDeploymentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateDeploymentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateDeploymentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateDeploymentErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDeploymentErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDeploymentErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateDeploymentErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `UpdateDeploymentErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateDeploymentErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `UpdateDeploymentErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDeploymentErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateDeploymentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateDeploymentErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateDeploymentErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateDeploymentErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateDeploymentErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateDeploymentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateDomainName` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateDomainNameError {
    /// Kind of error that occurred.
    pub kind: UpdateDomainNameErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateDomainName` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateDomainNameErrorKind {
    /// <p>The request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested operation would cause a conflict with the current state of a service resource associated with the request. Resolve the conflict before retrying this request. See the accompanying error message for details.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateDomainNameError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateDomainNameErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateDomainNameErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateDomainNameErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateDomainNameErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateDomainNameErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateDomainNameError {
    fn code(&self) -> Option<&str> {
        UpdateDomainNameError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateDomainNameError {
    /// Creates a new `UpdateDomainNameError`.
    pub fn new(kind: UpdateDomainNameErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateDomainNameError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateDomainNameErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateDomainNameError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateDomainNameErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateDomainNameErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDomainNameErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDomainNameErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateDomainNameErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `UpdateDomainNameErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateDomainNameErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `UpdateDomainNameErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDomainNameErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateDomainNameError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateDomainNameErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateDomainNameErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateDomainNameErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateDomainNameErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateDomainNameErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateIntegration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateIntegrationError {
    /// Kind of error that occurred.
    pub kind: UpdateIntegrationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateIntegration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateIntegrationErrorKind {
    /// <p>The request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested operation would cause a conflict with the current state of a service resource associated with the request. Resolve the conflict before retrying this request. See the accompanying error message for details.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateIntegrationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateIntegrationErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateIntegrationErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateIntegrationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateIntegrationErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateIntegrationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateIntegrationError {
    fn code(&self) -> Option<&str> {
        UpdateIntegrationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateIntegrationError {
    /// Creates a new `UpdateIntegrationError`.
    pub fn new(kind: UpdateIntegrationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateIntegrationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateIntegrationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateIntegrationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateIntegrationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateIntegrationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIntegrationErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `UpdateIntegrationErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateIntegrationErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `UpdateIntegrationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateIntegrationErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `UpdateIntegrationErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIntegrationErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateIntegrationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateIntegrationErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateIntegrationErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateIntegrationErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateIntegrationErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateIntegrationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateIntegrationResponse` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateIntegrationResponseError {
    /// Kind of error that occurred.
    pub kind: UpdateIntegrationResponseErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateIntegrationResponse` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateIntegrationResponseErrorKind {
    /// <p>The request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested operation would cause a conflict with the current state of a service resource associated with the request. Resolve the conflict before retrying this request. See the accompanying error message for details.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateIntegrationResponseError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateIntegrationResponseErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateIntegrationResponseErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateIntegrationResponseErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateIntegrationResponseErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateIntegrationResponseErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateIntegrationResponseError {
    fn code(&self) -> Option<&str> {
        UpdateIntegrationResponseError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateIntegrationResponseError {
    /// Creates a new `UpdateIntegrationResponseError`.
    pub fn new(kind: UpdateIntegrationResponseErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateIntegrationResponseError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateIntegrationResponseErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateIntegrationResponseError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateIntegrationResponseErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateIntegrationResponseErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIntegrationResponseErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `UpdateIntegrationResponseErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIntegrationResponseErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `UpdateIntegrationResponseErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIntegrationResponseErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateIntegrationResponseErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIntegrationResponseErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateIntegrationResponseError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateIntegrationResponseErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateIntegrationResponseErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateIntegrationResponseErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateIntegrationResponseErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateIntegrationResponseErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateModel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateModelError {
    /// Kind of error that occurred.
    pub kind: UpdateModelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateModel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateModelErrorKind {
    /// <p>The request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested operation would cause a conflict with the current state of a service resource associated with the request. Resolve the conflict before retrying this request. See the accompanying error message for details.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateModelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateModelErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateModelErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateModelErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateModelErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateModelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateModelError {
    fn code(&self) -> Option<&str> {
        UpdateModelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateModelError {
    /// Creates a new `UpdateModelError`.
    pub fn new(kind: UpdateModelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateModelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateModelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateModelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateModelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateModelErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, UpdateModelErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `UpdateModelErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateModelErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `UpdateModelErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateModelErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `UpdateModelErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateModelErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateModelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateModelErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateModelErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateModelErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateModelErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateModelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateRoute` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateRouteError {
    /// Kind of error that occurred.
    pub kind: UpdateRouteErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateRoute` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateRouteErrorKind {
    /// <p>The request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested operation would cause a conflict with the current state of a service resource associated with the request. Resolve the conflict before retrying this request. See the accompanying error message for details.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateRouteError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateRouteErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateRouteErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateRouteErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateRouteErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateRouteErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateRouteError {
    fn code(&self) -> Option<&str> {
        UpdateRouteError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateRouteError {
    /// Creates a new `UpdateRouteError`.
    pub fn new(kind: UpdateRouteErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateRouteError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateRouteErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateRouteError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateRouteErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateRouteErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, UpdateRouteErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `UpdateRouteErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateRouteErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `UpdateRouteErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateRouteErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `UpdateRouteErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRouteErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateRouteError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateRouteErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateRouteErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateRouteErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateRouteErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateRouteErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateRouteResponse` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateRouteResponseError {
    /// Kind of error that occurred.
    pub kind: UpdateRouteResponseErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateRouteResponse` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateRouteResponseErrorKind {
    /// <p>The request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested operation would cause a conflict with the current state of a service resource associated with the request. Resolve the conflict before retrying this request. See the accompanying error message for details.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateRouteResponseError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateRouteResponseErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateRouteResponseErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateRouteResponseErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateRouteResponseErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateRouteResponseErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateRouteResponseError {
    fn code(&self) -> Option<&str> {
        UpdateRouteResponseError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateRouteResponseError {
    /// Creates a new `UpdateRouteResponseError`.
    pub fn new(kind: UpdateRouteResponseErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateRouteResponseError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateRouteResponseErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateRouteResponseError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateRouteResponseErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateRouteResponseErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRouteResponseErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `UpdateRouteResponseErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRouteResponseErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `UpdateRouteResponseErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRouteResponseErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateRouteResponseErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRouteResponseErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateRouteResponseError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateRouteResponseErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateRouteResponseErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateRouteResponseErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateRouteResponseErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateRouteResponseErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateStage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateStageError {
    /// Kind of error that occurred.
    pub kind: UpdateStageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateStage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateStageErrorKind {
    /// <p>The request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested operation would cause a conflict with the current state of a service resource associated with the request. Resolve the conflict before retrying this request. See the accompanying error message for details.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateStageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateStageErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateStageErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateStageErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateStageErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateStageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateStageError {
    fn code(&self) -> Option<&str> {
        UpdateStageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateStageError {
    /// Creates a new `UpdateStageError`.
    pub fn new(kind: UpdateStageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateStageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateStageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateStageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateStageErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateStageErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, UpdateStageErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `UpdateStageErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateStageErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `UpdateStageErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateStageErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `UpdateStageErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStageErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateStageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateStageErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateStageErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateStageErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateStageErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateStageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateVpcLink` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateVpcLinkError {
    /// Kind of error that occurred.
    pub kind: UpdateVpcLinkErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateVpcLink` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateVpcLinkErrorKind {
    /// <p>The request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The resource specified in the request was not found. See the message field for more information.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A limit has been exceeded. See the accompanying error message for details.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateVpcLinkError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateVpcLinkErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateVpcLinkErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateVpcLinkErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateVpcLinkErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateVpcLinkError {
    fn code(&self) -> Option<&str> {
        UpdateVpcLinkError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateVpcLinkError {
    /// Creates a new `UpdateVpcLinkError`.
    pub fn new(kind: UpdateVpcLinkErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateVpcLinkError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateVpcLinkErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateVpcLinkError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateVpcLinkErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateVpcLinkErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, UpdateVpcLinkErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `UpdateVpcLinkErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateVpcLinkErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `UpdateVpcLinkErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVpcLinkErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateVpcLinkError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateVpcLinkErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateVpcLinkErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateVpcLinkErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateVpcLinkErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>A limit has been exceeded. See the accompanying error message for details.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyRequestsException {
    /// <p>The limit type.</p>
    pub limit_type: std::option::Option<std::string::String>,
    /// <p>Describes the error encountered.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyRequestsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyRequestsException");
        formatter.field("limit_type", &self.limit_type);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyRequestsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyRequestsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyRequestsException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyRequestsException {}
/// See [`TooManyRequestsException`](crate::error::TooManyRequestsException)
pub mod too_many_requests_exception {
    /// A builder for [`TooManyRequestsException`](crate::error::TooManyRequestsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) limit_type: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The limit type.</p>
        pub fn limit_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.limit_type = Some(input.into());
            self
        }
        /// <p>The limit type.</p>
        pub fn set_limit_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.limit_type = input;
            self
        }
        /// <p>Describes the error encountered.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Describes the error encountered.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyRequestsException`](crate::error::TooManyRequestsException)
        pub fn build(self) -> crate::error::TooManyRequestsException {
            crate::error::TooManyRequestsException {
                limit_type: self.limit_type,
                message: self.message,
            }
        }
    }
}
impl TooManyRequestsException {
    /// Creates a new builder-style object to manufacture [`TooManyRequestsException`](crate::error::TooManyRequestsException)
    pub fn builder() -> crate::error::too_many_requests_exception::Builder {
        crate::error::too_many_requests_exception::Builder::default()
    }
}

/// <p>The resource specified in the request was not found. See the message field for more information.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotFoundException {
    /// <p>Describes the error encountered.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The resource type.</p>
    pub resource_type: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotFoundException");
        formatter.field("message", &self.message);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
impl NotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NotFoundException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for NotFoundException {}
/// See [`NotFoundException`](crate::error::NotFoundException)
pub mod not_found_exception {
    /// A builder for [`NotFoundException`](crate::error::NotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Describes the error encountered.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Describes the error encountered.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The resource type.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The resource type.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`NotFoundException`](crate::error::NotFoundException)
        pub fn build(self) -> crate::error::NotFoundException {
            crate::error::NotFoundException {
                message: self.message,
                resource_type: self.resource_type,
            }
        }
    }
}
impl NotFoundException {
    /// Creates a new builder-style object to manufacture [`NotFoundException`](crate::error::NotFoundException)
    pub fn builder() -> crate::error::not_found_exception::Builder {
        crate::error::not_found_exception::Builder::default()
    }
}

/// <p>The request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BadRequestException {
    /// <p>Describes the error encountered.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BadRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BadRequestException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl BadRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for BadRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "BadRequestException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for BadRequestException {}
/// See [`BadRequestException`](crate::error::BadRequestException)
pub mod bad_request_exception {
    /// A builder for [`BadRequestException`](crate::error::BadRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Describes the error encountered.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Describes the error encountered.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`BadRequestException`](crate::error::BadRequestException)
        pub fn build(self) -> crate::error::BadRequestException {
            crate::error::BadRequestException {
                message: self.message,
            }
        }
    }
}
impl BadRequestException {
    /// Creates a new builder-style object to manufacture [`BadRequestException`](crate::error::BadRequestException)
    pub fn builder() -> crate::error::bad_request_exception::Builder {
        crate::error::bad_request_exception::Builder::default()
    }
}

/// <p>The requested operation would cause a conflict with the current state of a service resource associated with the request. Resolve the conflict before retrying this request. See the accompanying error message for details.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    /// <p>Describes the error encountered.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Describes the error encountered.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Describes the error encountered.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}
